// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:55.447567

import 'dart:math' as math;

import 'package:flutter/material.dart';

class AdjustAltIcon extends StatelessWidget {
  final Color? color;

  const AdjustAltIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: AdjustAltPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class AdjustAltPainter extends CustomPainter {
  final Color color;

  const AdjustAltPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 11.449494487271224;
    final scaleY = size.height / 20.014008761859643;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 11.449494487271224 * scale) / 2 - 11.0 * scale;
    final translationY = (size.height - 20.014008761859643 * scale) / 2 - 1.9859912381403575 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      20.83 * scale + translationX,
      7.32 * scale + translationY,
    );

    path.lineTo(
      20.83 * scale + translationX,
      7.32 * scale + translationY,
    );

    path.cubicTo(
      20.835388071241262 * scale + translationX,
      7.293605579198829 * scale + translationY,
      20.835388071241265 * scale + translationX,
      7.266394637762078 * scale + translationY,
      20.830000310391185 * scale + translationX,
      7.240000107884407 * scale + translationY,
    );

    path.cubicTo(
      20.028774730238915 * scale + translationX,
      5.758045891142406 * scale + translationY,
      18.86613448573455 * scale + translationX,
      4.502532017639166 * scale + translationY,
      17.450000260025263 * scale + translationX,
      3.590000053495168 * scale + translationY,
    );

    path.lineTo(
      17.45 * scale + translationX,
      3.59 * scale + translationY,
    );

    path.lineTo(
      17.45 * scale + translationX,
      3.59 * scale + translationY,
    );

    path.cubicTo(
      15.827760471748505 * scale + translationX,
      2.5387699633691034 * scale + translationY,
      13.933015784643688 * scale + translationX,
      1.9859912381403575 * scale + translationY,
      12.000000064306107 * scale + translationX,
      2.0000000107176845 * scale + translationY,
    );

    path.cubicTo(
      11.447715250169207 * scale + translationX,
      2.0 * scale + translationY,
      11.0 * scale + translationX,
      2.4477152501692068 * scale + translationY,
      11.0 * scale + translationX,
      3.0 * scale + translationY,
    );

    path.lineTo(
      11.0 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.cubicTo(
      11.0 * scale + translationX,
      21.552284749830793 * scale + translationY,
      11.447715250169207 * scale + translationX,
      22.0 * scale + translationY,
      12.0 * scale + translationX,
      22.0 * scale + translationY,
    );

    path.lineTo(
      12.28 * scale + translationX,
      22.0 * scale + translationY,
    );

    path.cubicTo(
      15.736048249625817 * scale + translationX,
      21.901417922214932 * scale + translationY,
      18.895987317171702 * scale + translationX,
      20.02457532353531 * scale + translationY,
      20.636073062145424 * scale + translationX,
      17.036919330995627 * scale + translationY,
    );

    path.cubicTo(
      22.376158807119147 * scale + translationX,
      14.049263338455946 * scale + translationY,
      22.449494487271224 * scale + translationX,
      10.374705551614397 * scale + translationY,
      20.830000310391185 * scale + translationX,
      7.320000109076499 * scale + translationY,
    );

    path.close();

    path.moveTo(
      13.0 * scale + translationX,
      4.06 * scale + translationY,
    );

    path.cubicTo(
      13.864771659584935 * scale + translationX,
      4.169367367573287 * scale + translationY,
      14.705856895122054 * scale + translationX,
      4.419328441588334 * scale + translationY,
      15.49 * scale + translationX,
      4.799999999999999 * scale + translationY,
    );

    path.lineTo(
      13.0 * scale + translationX,
      9.12 * scale + translationY,
    );

    path.close();

    path.moveTo(
      13.0 * scale + translationX,
      13.120000000000001 * scale + translationY,
    );

    path.lineTo(
      17.17 * scale + translationX,
      5.9 * scale + translationY,
    );

    path.cubicTo(
      17.78755294476867 * scale + translationX,
      6.425205569451717 * scale + translationY,
      18.32047477824176 * scale + translationX,
      7.042450477841432 * scale + translationY,
      18.749998707618197 * scale + translationX,
      7.729999467194064 * scale + translationY,
    );

    path.lineTo(
      13.0 * scale + translationX,
      17.69 * scale + translationY,
    );

    path.close();

    path.moveTo(
      14.16 * scale + translationX,
      19.69 * scale + translationY,
    );

    path.lineTo(
      19.75 * scale + translationX,
      10.0 * scale + translationY,
    );

    path.cubicTo(
      19.91368687160621 * scale + translationX,
      10.654143954561581 * scale + translationY,
      19.9976301341597 * scale + translationX,
      11.325690054989495 * scale + translationY,
      19.999998987918843 * scale + translationX,
      11.999999392751306 * scale + translationY,
    );

    path.cubicTo(
      20.014789882313288 * scale + translationX,
      15.588526936975747 * scale + translationY,
      17.62077789749618 * scale + translationX,
      18.740916006024303 * scale + translationY,
      14.160000127365608 * scale + translationX,
      19.690000177106555 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}