#!/bin/bash

set -o errexit
set -o nounset
set -o pipefail

if [[ ${TRACE-0} == "1" ]]; then set -o xtrace; fi

trap 'echo "Error occurred at line $LINENO. Command: $BASH_COMMAND"' ERR

# Get current dir
CURRENT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" >/dev/null 2>&1 && pwd)"
readonly CURRENT_DIR

# Check python dependency
command -v python >/dev/null 2>&1 || {
  echo >&2 "I require python but it's not available. Aborting."
  exit 1
}

# Game grids file (dart GameData object)
GAME_GRIDS_FILE="${CURRENT_DIR}/../lib/data/game_data.dart"
GRIDS="$(cat "${GAME_GRIDS_FILE}" | grep "',$" | sed "s/ //g" | sed "s/,//g" | sed "s/'//g")"

function get_block_size() {
  BLOCK_SIZE=""

  GRID_LENGTH="$(echo -n "${GRID}" | wc -c)"
  if [ "${GRID_LENGTH}" == "16" ]; then
    BLOCK_SIZE="2x2"
  fi
  if [ "${GRID_LENGTH}" == "36" ]; then
    BLOCK_SIZE="3x2"
  fi
  if [ "${GRID_LENGTH}" == "81" ]; then
    BLOCK_SIZE="3x3"
  fi
  if [ "${GRID_LENGTH}" == "256" ]; then
    BLOCK_SIZE="4x4"
  fi

  echo "${BLOCK_SIZE}"
}

for GRID in ${GRIDS}; do
  BLOCK_SIZE="$(get_block_size "${GRID}")"
  echo "GRID: ${BLOCK_SIZE} / ${GRID}"
  SOLVED="$(python "${CURRENT_DIR}/solve.py" "${BLOCK_SIZE}" "${GRID}" | tail -n 1)"
  if [[ "${SOLVED}" != "Ok" ]]; then
    echo "Failed to solve grid."
    exit 1
  fi
done
