import 'package:flutter/material.dart';

import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

class ActivityButtonResumeSaved extends StatelessWidget {
  const ActivityButtonResumeSaved({
    super.key,
    required this.onPressed,
    this.onLongPress,
    this.color = Colors.blue,
  });

  final VoidCallback? onPressed;
  final VoidCallback? onLongPress;
  final Color color;

  @override
  Widget build(BuildContext context) {
    return StyledButton.icon(
      color: color,
      onPressed: onPressed,
      onLongPress: onLongPress,
      icon: const Icon(UniconsLine.skip_forward_alt),
    );
  }
}
