import 'package:flutter/material.dart';

import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

class ActivityButtonQuit extends StatelessWidget {
  const ActivityButtonQuit({
    super.key,
    required this.onPressed,
    this.onLongPress,
    this.color = Colors.red,
  });

  final VoidCallback? onPressed;
  final VoidCallback? onLongPress;
  final Color color;

  @override
  Widget build(BuildContext context) {
    return StyledButton.icon(
      color: color,
      onPressed: onPressed,
      onLongPress: onLongPress,
      icon: const Icon(UniconsLine.play),
      quarterTurns: 2,
    );
  }
}
