import 'package:flutter/material.dart';

import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

class ApplicationSettingsThemeModeCard extends StatelessWidget {
  const ApplicationSettingsThemeModeCard({
    super.key,
    required this.mode,
    required this.icon,
  });

  final IconData icon;
  final ThemeMode mode;

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<ApplicationThemeModeCubit, ApplicationThemeModeState>(
      builder: (BuildContext context, ApplicationThemeModeState state) {
        return Card(
          elevation: 2,
          shadowColor: Theme.of(context).colorScheme.shadow,
          color: state.themeMode == mode
              ? Theme.of(context).colorScheme.primary
              : Theme.of(context).colorScheme.surface,
          shape: const RoundedRectangleBorder(
            borderRadius: BorderRadius.all(Radius.circular(12)),
          ),
          margin: const EdgeInsets.all(5),
          child: InkWell(
            onTap: () => BlocProvider.of<ApplicationThemeModeCubit>(context).getTheme(
              ApplicationThemeModeState(themeMode: mode),
            ),
            borderRadius: const BorderRadius.all(Radius.circular(12)),
            child: Icon(
              icon,
              size: 32,
              color: state.themeMode != mode
                  ? Theme.of(context).colorScheme.primary
                  : Colors.white,
            ),
          ),
        );
      },
    );
  }
}
