import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

class ActivitySettings {
  final Map<String, String> values;
  final ApplicationConfigDefinition appConfig;

  ActivitySettings({
    required this.appConfig,
    required this.values,
  });

  factory ActivitySettings.createDefault({
    required ApplicationConfigDefinition appConfig,
  }) {
    Map<String, String> values = {};

    for (var setting in appConfig.activitySettings) {
      values[setting.code] = setting.defaultValue;
    }

    return ActivitySettings(
      appConfig: appConfig,
      values: values,
    );
  }

  String get(String code) {
    if (values.keys.contains(code)) {
      if (appConfig.getFromCode(code).allowMultipleValues) {
        return getAsArray(code).join(',');
      }

      if (appConfig.getFromCode(code).allowedValues.contains(values[code])) {
        return values[code] ?? appConfig.getFromCode(code).defaultValue;
      }
    }

    return appConfig.getFromCode(code).defaultValue;
  }

  int getAsInt(String parameterCode) {
    final ApplicationSettingsParameter parameter = appConfig.getFromCode(parameterCode);

    if (values.keys.contains(parameterCode)) {
      if (parameter.allowedValues.contains(values[parameterCode])) {
        if (parameter.intValueGetter != null) {
          return parameter.intValueGetter!(get(parameterCode));
        } else {
          return int.parse(get(parameterCode));
        }
      }
    }

    if (parameter.intValueGetter != null) {
      return parameter.intValueGetter!(parameter.defaultValue);
    } else {
      return int.parse(parameter.defaultValue);
    }
  }

  List<String> getAsArray(String code) {
    final List<String> legitValues = [];
    if (values[code] != null) {
      values[code]?.split(',').forEach((candidateValue) {
        if (appConfig.getFromCode(code).allowedValues.contains(candidateValue)) {
          legitValues.add(candidateValue);
        }
      });
    }

    return legitValues;
  }

  void dump() {
    printlog('$ActivitySettings:');
    values.forEach((code, value) {
      printlog('  $code: $value');
    });
    printlog('');
  }

  @override
  String toString() {
    return '$ActivitySettings(${toJson()})';
  }

  Map<String, dynamic>? toJson() {
    return values;
  }
}
