import 'package:flutter/material.dart';
import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

class BottomNavBar extends StatelessWidget {
  const BottomNavBar({
    super.key,
    required this.appConfig,
  });

  final ApplicationConfigDefinition appConfig;

  @override
  Widget build(BuildContext context) {
    return Card(
      margin: const EdgeInsets.only(top: 1, right: 4, left: 4),
      elevation: 4,
      shadowColor: Theme.of(context).colorScheme.shadow,
      color: Theme.of(context).colorScheme.surfaceContainerHighest,
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.only(
          topLeft: Radius.circular(16),
          topRight: Radius.circular(16),
        ),
      ),
      child: BlocBuilder<NavCubitPage, int>(builder: (BuildContext context, int state) {
        final List<BottomNavigationBarItem> items = [];

        appConfig.navigation.activityPages.forEach((int pageIndex, ActivityPageItem item) {
          items.add(BottomNavigationBarItem(
            icon: item.icon ?? Icon(null),
            label: tr(item.code),
          ));
        });

        return BottomNavigationBar(
          currentIndex: state,
          onTap: (int index) => BlocProvider.of<NavCubitPage>(context).updateIndex(index),
          type: BottomNavigationBarType.fixed,
          elevation: 0,
          backgroundColor: Colors.transparent,
          selectedItemColor: Theme.of(context).colorScheme.primary,
          unselectedItemColor: Theme.of(context).textTheme.bodySmall!.color,
          items: items,
        );
      }),
    );
  }
}
