// Code generated using SVG Painter package
// Generated in 2024-08-26T20:40:01.319565

import 'dart:math' as math;

import 'package:flutter/material.dart';

class VectorSquareAltIcon extends StatelessWidget {
  final Color? color;

  const VectorSquareAltIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: VectorSquareAltPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class VectorSquareAltPainter extends CustomPainter {
  final Color color;

  const VectorSquareAltPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 20.284315205959324;
    final scaleY = size.height / 20.284315205959324;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 20.284315205959324 * scale) / 2 - 1.8578423970203386 * scale;
    final translationY = (size.height - 20.284315205959324 * scale) / 2 - 1.8578423970203386 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      16.0 * scale + translationX,
      7.0 * scale + translationY,
    );

    path.lineTo(
      8.0 * scale + translationX,
      7.0 * scale + translationY,
    );

    path.cubicTo(
      7.447715250169207 * scale + translationX,
      7.0 * scale + translationY,
      7.0 * scale + translationX,
      7.447715250169207 * scale + translationY,
      7.0 * scale + translationX,
      8.0 * scale + translationY,
    );

    path.lineTo(
      7.0 * scale + translationX,
      16.0 * scale + translationY,
    );

    path.cubicTo(
      7.0 * scale + translationX,
      16.552284749830793 * scale + translationY,
      7.447715250169207 * scale + translationX,
      17.0 * scale + translationY,
      8.0 * scale + translationX,
      17.0 * scale + translationY,
    );

    path.lineTo(
      16.0 * scale + translationX,
      17.0 * scale + translationY,
    );

    path.cubicTo(
      16.552284749830793 * scale + translationX,
      17.0 * scale + translationY,
      17.0 * scale + translationX,
      16.552284749830793 * scale + translationY,
      17.0 * scale + translationX,
      16.0 * scale + translationY,
    );

    path.lineTo(
      17.0 * scale + translationX,
      8.0 * scale + translationY,
    );

    path.cubicTo(
      17.0 * scale + translationX,
      7.447715250169207 * scale + translationY,
      16.552284749830793 * scale + translationX,
      7.0 * scale + translationY,
      16.0 * scale + translationX,
      7.0 * scale + translationY,
    );

    path.close();

    path.moveTo(
      15.0 * scale + translationX,
      15.0 * scale + translationY,
    );

    path.lineTo(
      9.0 * scale + translationX,
      15.0 * scale + translationY,
    );

    path.lineTo(
      9.0 * scale + translationX,
      9.0 * scale + translationY,
    );

    path.lineTo(
      15.0 * scale + translationX,
      9.0 * scale + translationY,
    );

    path.close();

    path.moveTo(
      21.0 * scale + translationX,
      18.28 * scale + translationY,
    );

    path.lineTo(
      21.0 * scale + translationX,
      5.72 * scale + translationY,
    );

    path.cubicTo(
      21.741610185867348 * scale + translationX,
      5.307494669526579 * scale + translationY,
      22.14215760297966 * scale + translationX,
      4.471884608033232 * scale + translationY,
      21.99925249968968 * scale + translationX,
      3.6353892721796077 * scale + translationY,
    );

    path.cubicTo(
      21.8563473963997 * scale + translationX,
      2.7988939363259835 * scale + translationY,
      21.201106063674015 * scale + translationX,
      2.1436526036002994 * scale + translationY,
      20.36461072782039 * scale + translationX,
      2.000747500310319 * scale + translationY,
    );

    path.cubicTo(
      19.528115391966768 * scale + translationX,
      1.8578423970203386 * scale + translationY,
      18.69250533047342 * scale + translationX,
      2.2583898141326513 * scale + translationY,
      18.28 * scale + translationX,
      2.999999999999999 * scale + translationY,
    );

    path.lineTo(
      5.72 * scale + translationX,
      3.0 * scale + translationY,
    );

    path.cubicTo(
      5.30749466952658 * scale + translationX,
      2.2583898141326513 * scale + translationY,
      4.471884608033233 * scale + translationX,
      1.857842397020339 * scale + translationY,
      3.635389272179608 * scale + translationX,
      2.0007475003103194 * scale + translationY,
    );

    path.cubicTo(
      2.798893936325984 * scale + translationX,
      2.1436526036003 * scale + translationY,
      2.1436526036003003 * scale + translationX,
      2.7988939363259835 * scale + translationY,
      2.00074750031032 * scale + translationX,
      3.6353892721796077 * scale + translationY,
    );

    path.cubicTo(
      1.857842397020339 * scale + translationX,
      4.471884608033232 * scale + translationY,
      2.2583898141326513 * scale + translationX,
      5.307494669526579 * scale + translationY,
      2.999999999999999 * scale + translationX,
      5.719999999999999 * scale + translationY,
    );

    path.lineTo(
      3.0 * scale + translationX,
      18.28 * scale + translationY,
    );

    path.cubicTo(
      2.2583898141326513 * scale + translationX,
      18.69250533047342 * scale + translationY,
      1.8578423970203386 * scale + translationX,
      19.528115391966768 * scale + translationY,
      2.000747500310319 * scale + translationX,
      20.36461072782039 * scale + translationY,
    );

    path.cubicTo(
      2.1436526036002994 * scale + translationX,
      21.201106063674015 * scale + translationY,
      2.798893936325983 * scale + translationX,
      21.8563473963997 * scale + translationY,
      3.6353892721796073 * scale + translationX,
      21.99925249968968 * scale + translationY,
    );

    path.cubicTo(
      4.471884608033231 * scale + translationX,
      22.14215760297966 * scale + translationY,
      5.307494669526579 * scale + translationX,
      21.741610185867348 * scale + translationY,
      5.719999999999999 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.lineTo(
      18.28 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.cubicTo(
      18.69250533047342 * scale + translationX,
      21.741610185867348 * scale + translationY,
      19.528115391966768 * scale + translationX,
      22.142157602979662 * scale + translationY,
      20.36461072782039 * scale + translationX,
      21.999252499689682 * scale + translationY,
    );

    path.cubicTo(
      21.20110606367402 * scale + translationX,
      21.856347396399702 * scale + translationY,
      21.856347396399702 * scale + translationX,
      21.20110606367402 * scale + translationY,
      21.999252499689682 * scale + translationX,
      20.364610727820395 * scale + translationY,
    );

    path.cubicTo(
      22.142157602979662 * scale + translationX,
      19.528115391966768 * scale + translationY,
      21.74161018586735 * scale + translationX,
      18.69250533047342 * scale + translationY,
      21.0 * scale + translationX,
      18.28 * scale + translationY,
    );

    path.close();

    path.moveTo(
      19.0 * scale + translationX,
      18.28 * scale + translationY,
    );

    path.cubicTo(
      18.699270442620833 * scale + translationX,
      18.450427307327743 * scale + translationY,
      18.450427307327743 * scale + translationX,
      18.699270442620836 * scale + translationY,
      18.2800002580177 * scale + translationX,
      19.000000268180322 * scale + translationY,
    );

    path.lineTo(
      5.72 * scale + translationX,
      19.0 * scale + translationY,
    );

    path.cubicTo(
      5.549573031426352 * scale + translationX,
      18.699270442620836 * scale + translationY,
      5.300729896133259 * scale + translationX,
      18.450427307327743 * scale + translationY,
      5.00000007057377 * scale + translationX,
      18.2800002580177 * scale + translationY,
    );

    path.lineTo(
      5.0 * scale + translationX,
      5.72 * scale + translationY,
    );

    path.cubicTo(
      5.300729896133258 * scale + translationX,
      5.549573031426352 * scale + translationY,
      5.549573031426352 * scale + translationX,
      5.300729896133258 * scale + translationY,
      5.7200000807363915 * scale + translationX,
      5.000000070573769 * scale + translationY,
    );

    path.lineTo(
      18.28 * scale + translationX,
      5.0 * scale + translationY,
    );

    path.cubicTo(
      18.45042730732774 * scale + translationX,
      5.300729896133258 * scale + translationY,
      18.699270442620836 * scale + translationX,
      5.549573031426352 * scale + translationY,
      19.000000268180322 * scale + translationX,
      5.7200000807363915 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}