// Code generated using SVG Painter package
// Generated in 2024-08-26T20:40:00.860432

import 'dart:math' as math;

import 'package:flutter/material.dart';

class TabletsIcon extends StatelessWidget {
  final Color? color;

  const TabletsIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: TabletsPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class TabletsPainter extends CustomPainter {
  final Color color;

  const TabletsPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 20.47828280704582;
    final scaleY = size.height / 20.488990436413236;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 20.47828280704582 * scale) / 2 - 1.530655388761849 * scale;
    final translationY = (size.height - 20.488990436413236 * scale) / 2 - 1.5110102192378583 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      20.54 * scale + translationX,
      3.46 * scale + translationY,
    );

    path.cubicTo(
      18.58607712551427 * scale + translationX,
      1.5110102192378583 * scale + translationY,
      15.422550613544285 * scale + translationX,
      1.5136760525554114 * scale + translationY,
      13.471914946266219 * scale + translationX,
      3.4659561696345307 * scale + translationY,
    );

    path.cubicTo(
      11.521279278988153 * scale + translationX,
      5.41823628671365 * scale + translationY,
      11.521279278988153 * scale + translationX,
      8.581763921902606 * scale + translationY,
      13.471914946266219 * scale + translationX,
      10.534044038981724 * scale + translationY,
    );

    path.cubicTo(
      15.422550613544285 * scale + translationX,
      12.486324156060844 * scale + translationY,
      18.58607712551427 * scale + translationX,
      12.488989989378398 * scale + translationY,
      20.540000306069853 * scale + translationX,
      10.540000157058238 * scale + translationY,
    );

    path.cubicTo(
      21.480417345287158 * scale + translationX,
      9.60195752272397 * scale + translationY,
      22.00893819580767 * scale + translationX,
      8.328272738777052 * scale + translationY,
      22.00893819580767 * scale + translationX,
      7.000000104308128 * scale + translationY,
    );

    path.cubicTo(
      22.00893819580767 * scale + translationX,
      5.671727469839204 * scale + translationY,
      21.480417345287158 * scale + translationX,
      4.398042685892286 * scale + translationY,
      20.540000306069853 * scale + translationX,
      3.4600000515580174 * scale + translationY,
    );

    path.close();

    path.moveTo(
      14.88 * scale + translationX,
      4.88 * scale + translationY,
    );

    path.cubicTo(
      15.442069887776928 * scale + translationX,
      4.317230170842802 * scale + translationY,
      16.204619079736965 * scale + translationX,
      4.000700317576372 * scale + translationY,
      17.00000050663948 * scale + translationX,
      4.0000001192092896 * scale + translationY,
    );

    path.cubicTo(
      17.443600192718336 * scale + translationX,
      4.0041314297369714 * scale + translationY,
      17.880762752371645 * scale + translationX,
      4.106591404655717 * scale + translationY,
      18.280000544786454 * scale + translationX,
      4.300000128149986 * scale + translationY,
    );

    path.lineTo(
      14.280000000000001 * scale + translationX,
      8.3 * scale + translationY,
    );

    path.cubicTo(
      13.732925891612837 * scale + translationX,
      7.148326565021632 * scale + translationY,
      13.973566969192035 * scale + translationX,
      5.7766724228202 * scale + translationY,
      14.880000443458558 * scale + translationX,
      4.880000145435336 * scale + translationY,
    );

    path.close();

    path.moveTo(
      19.12 * scale + translationX,
      9.120000000000001 * scale + translationY,
    );

    path.cubicTo(
      18.222195981555988 * scale + translationX,
      10.010629118857146 * scale + translationY,
      16.862298957922 * scale + translationX,
      10.242611552300591 * scale + translationY,
      15.72000046849251 * scale + translationX,
      9.700000289082528 * scale + translationY,
    );

    path.lineTo(
      19.72 * scale + translationX,
      5.700000000000001 * scale + translationY,
    );

    path.cubicTo(
      20.267075121666124 * scale + translationX,
      6.851673852210882 * scale + translationY,
      20.026434044086926 * scale + translationX,
      8.223327994412315 * scale + translationY,
      19.120000569820405 * scale + translationX,
      9.12000027179718 * scale + translationY,
    );

    path.close();

    path.moveTo(
      8.0 * scale + translationX,
      10.0 * scale + translationY,
    );

    path.cubicTo(
      6.422412774055428 * scale + translationX,
      9.993700261748454 * scale + translationY,
      4.907342452696664 * scale + translationX,
      10.61628260282937 * scale + translationY,
      3.789999732156129 * scale + translationX,
      11.729999171026757 * scale + translationY,
    );

    path.lineTo(
      3.79 * scale + translationX,
      11.73 * scale + translationY,
    );

    path.lineTo(
      3.79 * scale + translationX,
      11.73 * scale + translationY,
    );

    path.cubicTo(
      2.058576774774213 * scale + translationX,
      13.439162062281365 * scale + translationY,
      1.530655388761849 * scale + translationX,
      16.024688299113286 * scale + translationY,
      2.4534571622392236 * scale + translationX,
      18.27579856362935 * scale + translationY,
    );

    path.cubicTo(
      3.3762589357165984 * scale + translationX,
      20.52690882814542 * scale + translationY,
      5.567089171882926 * scale + translationX,
      21.997932209147514 * scale + translationY,
      8.000000238418577 * scale + translationX,
      22.000000655651093 * scale + translationY,
    );

    path.cubicTo(
      9.542042820769534 * scale + translationX,
      21.999230971268815 * scale + translationY,
      11.024589626425144 * scale + translationX,
      21.40477983663396 * scale + translationY,
      12.140000361800194 * scale + translationX,
      20.340000606179238 * scale + translationY,
    );

    path.lineTo(
      12.26 * scale + translationX,
      20.26 * scale + translationY,
    );

    path.cubicTo(
      12.281031536926752 * scale + translationX,
      20.221917769392125 * scale + translationY,
      12.304409929706432 * scale + translationX,
      20.185180295024058 * scale + translationY,
      12.3299994768032 * scale + translationX,
      20.149999144978466 * scale + translationY,
    );

    path.cubicTo(
      13.991800213191638 * scale + translationX,
      18.414801714605176 * scale + translationY,
      14.458251055310157 * scale + translationX,
      15.85558672435945 * scale + translationY,
      13.515500084818363 * scale + translationX,
      13.645673941335955 * scale + translationY,
    );

    path.cubicTo(
      12.57274911432657 * scale + translationX,
      11.43576115831246 * scale + translationY,
      10.402601361110552 * scale + translationX,
      10.001321726470527 * scale + translationY,
      8.000000238418579 * scale + translationX,
      10.000000298023224 * scale + translationY,
    );

    path.close();

    path.moveTo(
      5.17 * scale + translationX,
      18.83 * scale + translationY,
    );

    path.cubicTo(
      3.8975206751461178 * scale + translationX,
      17.543336630683164 * scale + translationY,
      3.6473692757786917 * scale + translationX,
      15.56262964880666 * scale + translationY,
      4.5600000000000005 * scale + translationX,
      14.0 * scale + translationY,
    );

    path.lineTo(
      10.0 * scale + translationX,
      19.44 * scale + translationY,
    );

    path.cubicTo(
      8.437370351193339 * scale + translationX,
      20.352630724221306 * scale + translationY,
      6.456663369316832 * scale + translationX,
      20.10247932485388 * scale + translationY,
      5.17 * scale + translationX,
      18.83 * scale + translationY,
    );

    path.close();

    path.moveTo(
      11.44 * scale + translationX,
      18.0 * scale + translationY,
    );

    path.lineTo(
      6.0 * scale + translationX,
      12.56 * scale + translationY,
    );

    path.cubicTo(
      6.605731233724939 * scale + translationX,
      12.20049364877921 * scale + translationY,
      7.295655172770264 * scale + translationX,
      12.007314945846518 * scale + translationY,
      8.0 * scale + translationX,
      12.0 * scale + translationY,
    );

    path.cubicTo(
      9.424754467988668 * scale + translationX,
      12.00856999509519 * scale + translationY,
      10.737398821484991 * scale + translationX,
      12.77435097571397 * scale + translationY,
      11.446061877732877 * scale + translationX,
      14.010391190099817 * scale + translationY,
    );

    path.cubicTo(
      12.154724933980763 * scale + translationX,
      15.246431404485666 * scale + translationY,
      12.152415895472467 * scale + translationX,
      16.766118996520426 * scale + translationY,
      11.439999999999998 * scale + translationX,
      18.0 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}