// Code generated using SVG Painter package
// Generated in 2024-08-26T20:40:00.145345

import 'dart:math' as math;

import 'package:flutter/material.dart';

class RssInterfaceIcon extends StatelessWidget {
  final Color? color;

  const RssInterfaceIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: RssInterfacePainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class RssInterfacePainter extends CustomPainter {
  final Color color;

  const RssInterfacePainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 20.098169067313908;
    final scaleY = size.height / 16.091510838788434;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 20.098169067313908 * scale) / 2 - 1.9018316377152924 * scale;
    final translationY = (size.height - 16.091510838788434 * scale) / 2 - 4.0 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      3.0 * scale + translationX,
      14.0 * scale + translationY,
    );

    path.cubicTo(
      2.4477152501692068 * scale + translationX,
      14.0 * scale + translationY,
      2.0 * scale + translationX,
      14.447715250169207 * scale + translationY,
      2.0 * scale + translationX,
      15.0 * scale + translationY,
    );

    path.cubicTo(
      2.0 * scale + translationX,
      15.552284749830793 * scale + translationY,
      2.4477152501692068 * scale + translationX,
      16.0 * scale + translationY,
      3.0 * scale + translationX,
      16.0 * scale + translationY,
    );

    path.cubicTo(
      4.656854408730533 * scale + translationX,
      16.00000042745905 * scale + translationY,
      6.000000228192041 * scale + translationX,
      17.34314624692056 * scale + translationY,
      6.000000178813934 * scale + translationX,
      19.000000566244125 * scale + translationY,
    );

    path.cubicTo(
      6.0 * scale + translationX,
      19.552284749830793 * scale + translationY,
      6.447715250169207 * scale + translationX,
      20.0 * scale + translationY,
      7.0 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.cubicTo(
      7.552284749830793 * scale + translationX,
      20.0 * scale + translationY,
      8.0 * scale + translationX,
      19.552284749830793 * scale + translationY,
      8.0 * scale + translationX,
      19.0 * scale + translationY,
    );

    path.cubicTo(
      8.00000016035771 * scale + translationX,
      16.238576475775442 * scale + translationY,
      5.761423852050105 * scale + translationX,
      14.000000167467835 * scale + translationY,
      3.0000000447034836 * scale + translationX,
      14.000000208616257 * scale + translationY,
    );

    path.close();

    path.moveTo(
      2.29 * scale + translationX,
      18.29 * scale + translationY,
    );

    path.cubicTo(
      1.9018316377152924 * scale + translationX,
      18.681364500751144 * scale + translationY,
      1.9035582343218262 * scale + translationX,
      19.313037533747586 * scale + translationY,
      2.2938602689843166 * scale + translationX,
      19.70227418626801 * scale + translationY,
    );

    path.cubicTo(
      2.684162303646807 * scale + translationX,
      20.091510838788434 * scale + translationY,
      3.3158376963531926 * scale + translationX,
      20.091510838788434 * scale + translationY,
      3.706139731015683 * scale + translationX,
      19.70227418626801 * scale + translationY,
    );

    path.cubicTo(
      4.096441765678174 * scale + translationX,
      19.313037533747586 * scale + translationY,
      4.098168362284707 * scale + translationX,
      18.681364500751144 * scale + translationY,
      3.7100000000000004 * scale + translationX,
      18.29 * scale + translationY,
    );

    path.cubicTo(
      3.5222334000944446 * scale + translationX,
      18.1006873491769 * scale + translationY,
      3.266637536370559 * scale + translationX,
      17.994201675658328 * scale + translationY,
      3.0 * scale + translationX,
      17.994201675658328 * scale + translationY,
    );

    path.cubicTo(
      2.7333624636294416 * scale + translationX,
      17.994201675658328 * scale + translationY,
      2.477766599905556 * scale + translationX,
      18.1006873491769 * scale + translationY,
      2.2899999999999996 * scale + translationX,
      18.29 * scale + translationY,
    );

    path.close();

    path.moveTo(
      19.0 * scale + translationX,
      4.0 * scale + translationY,
    );

    path.lineTo(
      5.0 * scale + translationX,
      4.0 * scale + translationY,
    );

    path.cubicTo(
      3.343145829688046 * scale + translationX,
      4.000000069831182 * scale + translationY,
      2.0000000102265374 * scale + translationX,
      5.343145889292691 * scale + translationY,
      2.0000000596046448 * scale + translationX,
      7.000000208616257 * scale + translationY,
    );

    path.cubicTo(
      2.0 * scale + translationX,
      7.552284749830793 * scale + translationY,
      2.4477152501692068 * scale + translationX,
      8.0 * scale + translationY,
      3.0 * scale + translationX,
      8.0 * scale + translationY,
    );

    path.cubicTo(
      3.5522847498307932 * scale + translationX,
      8.0 * scale + translationY,
      4.0 * scale + translationX,
      7.552284749830793 * scale + translationY,
      4.0 * scale + translationX,
      7.0 * scale + translationY,
    );

    path.cubicTo(
      4.0 * scale + translationX,
      6.447715250169207 * scale + translationY,
      4.447715250169207 * scale + translationX,
      6.0 * scale + translationY,
      5.0 * scale + translationX,
      6.0 * scale + translationY,
    );

    path.lineTo(
      19.0 * scale + translationX,
      6.0 * scale + translationY,
    );

    path.cubicTo(
      19.552284749830793 * scale + translationX,
      6.0 * scale + translationY,
      20.0 * scale + translationX,
      6.447715250169207 * scale + translationY,
      20.0 * scale + translationX,
      7.0 * scale + translationY,
    );

    path.lineTo(
      20.0 * scale + translationX,
      17.0 * scale + translationY,
    );

    path.cubicTo(
      20.0 * scale + translationX,
      17.552284749830793 * scale + translationY,
      19.552284749830793 * scale + translationX,
      18.0 * scale + translationY,
      19.0 * scale + translationX,
      18.0 * scale + translationY,
    );

    path.lineTo(
      15.0 * scale + translationX,
      18.0 * scale + translationY,
    );

    path.cubicTo(
      14.447715250169207 * scale + translationX,
      18.0 * scale + translationY,
      14.0 * scale + translationX,
      18.447715250169207 * scale + translationY,
      14.0 * scale + translationX,
      19.0 * scale + translationY,
    );

    path.cubicTo(
      14.0 * scale + translationX,
      19.552284749830793 * scale + translationY,
      14.447715250169207 * scale + translationX,
      20.0 * scale + translationY,
      15.0 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.lineTo(
      19.0 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.cubicTo(
      20.65685488556769 * scale + translationX,
      20.000000645424553 * scale + translationY,
      22.0000007050292 * scale + translationX,
      18.656854825963045 * scale + translationY,
      22.000000655651093 * scale + translationX,
      17.00000050663948 * scale + translationY,
    );

    path.lineTo(
      22.0 * scale + translationX,
      7.0 * scale + translationY,
    );

    path.cubicTo(
      22.0000007050292 * scale + translationX,
      5.343145889292692 * scale + translationY,
      20.65685488556769 * scale + translationX,
      4.0000000698311835 * scale + translationY,
      19.000000566244125 * scale + translationX,
      4.0000001192092896 * scale + translationY,
    );

    path.close();

    path.moveTo(
      3.0 * scale + translationX,
      10.0 * scale + translationY,
    );

    path.cubicTo(
      2.4477152501692068 * scale + translationX,
      10.0 * scale + translationY,
      2.0 * scale + translationX,
      10.447715250169207 * scale + translationY,
      2.0 * scale + translationX,
      11.0 * scale + translationY,
    );

    path.cubicTo(
      2.0 * scale + translationX,
      11.552284749830793 * scale + translationY,
      2.4477152501692068 * scale + translationX,
      12.0 * scale + translationY,
      3.0 * scale + translationX,
      12.0 * scale + translationY,
    );

    path.cubicTo(
      6.865993627335156 * scale + translationX,
      12.000000363618422 * scale + translationY,
      10.000000619858216 * scale + translationX,
      15.134007356141485 * scale + translationY,
      10.000000447034836 * scale + translationX,
      19.000000849366188 * scale + translationY,
    );

    path.cubicTo(
      10.0 * scale + translationX,
      19.552284749830793 * scale + translationY,
      10.447715250169207 * scale + translationX,
      20.0 * scale + translationY,
      11.0 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.cubicTo(
      11.552284749830793 * scale + translationX,
      20.0 * scale + translationY,
      12.0 * scale + translationX,
      19.552284749830793 * scale + translationY,
      12.0 * scale + translationX,
      19.0 * scale + translationY,
    );

    path.cubicTo(
      12.000000126440545 * scale + translationX,
      14.029437340710503 * scale + translationY,
      7.97056282320227 * scale + translationX,
      10.000000037472228 * scale + translationY,
      3.0000000223517422 * scale + translationX,
      10.000000074505806 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}