// Code generated using SVG Painter package
// Generated in 2024-08-26T20:40:00.140358

import 'dart:math' as math;

import 'package:flutter/material.dart';

class RssAltIcon extends StatelessWidget {
  final Color? color;

  const RssAltIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: RssAltPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class RssAltPainter extends CustomPainter {
  final Color color;

  const RssAltPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 14.252995385468953;
    final scaleY = size.height / 14.252995442834468;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 14.252995385468953 * scale) / 2 - 1.7470052724212664 * scale;
    final translationY = (size.height - 14.252995442834468 * scale) / 2 - 8.0 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      2.88 * scale + translationX,
      16.88 * scale + translationY,
    );

    path.cubicTo(
      2.077388449595272 * scale + translationX,
      17.62788308998269 * scale + translationY,
      1.7470052724212664 * scale + translationX,
      18.754222425790033 * scale + translationY,
      2.018459980346649 * scale + translationX,
      19.817155228926254 * scale + translationY,
    );

    path.cubicTo(
      2.289914688272032 * scale + translationX,
      20.880088032062474 * scale + translationY,
      3.1199126831932595 * scale + translationX,
      21.710086026983703 * scale + translationY,
      4.18284548632948 * scale + translationX,
      21.981540734909085 * scale + translationY,
    );

    path.cubicTo(
      5.245778289465702 * scale + translationX,
      22.252995442834468 * scale + translationY,
      6.372117625273046 * scale + translationX,
      21.92261226566046 * scale + translationY,
      7.120000212192535 * scale + translationX,
      21.120000629425046 * scale + translationY,
    );

    path.lineTo(
      7.12 * scale + translationX,
      21.119999999999997 * scale + translationY,
    );

    path.cubicTo(
      8.28981380855906 * scale + translationX,
      19.94873042781436 * scale + translationY,
      8.28981380855906 * scale + translationX,
      18.051270704673883 * scale + translationY,
      7.120000212192537 * scale + translationX,
      16.880000503063197 * scale + translationY,
    );

    path.cubicTo(
      5.931586272620073 * scale + translationX,
      15.752370683737311 * scale + translationY,
      4.068413384304881 * scale + translationX,
      15.752370683737313 * scale + translationY,
      2.879999901194387 * scale + translationX,
      16.879999420889323 * scale + translationY,
    );

    path.close();

    path.moveTo(
      5.71 * scale + translationX,
      19.71 * scale + translationY,
    );

    path.lineTo(
      5.71 * scale + translationX,
      19.71 * scale + translationY,
    );

    path.cubicTo(
      5.522233400094445 * scale + translationX,
      19.8993126508231 * scale + translationY,
      5.266637536370559 * scale + translationX,
      20.005798324341672 * scale + translationY,
      5.0 * scale + translationX,
      20.005798324341672 * scale + translationY,
    );

    path.cubicTo(
      4.733362463629441 * scale + translationX,
      20.005798324341672 * scale + translationY,
      4.477766599905555 * scale + translationX,
      19.8993126508231 * scale + translationY,
      4.289999999999999 * scale + translationX,
      19.71 * scale + translationY,
    );

    path.cubicTo(
      4.100687349176903 * scale + translationX,
      19.522233400094443 * scale + translationY,
      3.9942016756583296 * scale + translationX,
      19.26663753637056 * scale + translationY,
      3.9942016756583296 * scale + translationX,
      19.0 * scale + translationY,
    );

    path.cubicTo(
      3.9942016756583296 * scale + translationX,
      18.73336246362944 * scale + translationY,
      4.100687349176903 * scale + translationX,
      18.477766599905554 * scale + translationY,
      4.29 * scale + translationX,
      18.29 * scale + translationY,
    );

    path.cubicTo(
      4.477766599905555 * scale + translationX,
      18.1006873491769 * scale + translationY,
      4.733362463629441 * scale + translationX,
      17.994201675658328 * scale + translationY,
      5.0 * scale + translationX,
      17.994201675658328 * scale + translationY,
    );

    path.cubicTo(
      5.266637536370559 * scale + translationX,
      17.994201675658328 * scale + translationY,
      5.522233400094445 * scale + translationX,
      18.1006873491769 * scale + translationY,
      5.710000000000001 * scale + translationX,
      18.29 * scale + translationY,
    );

    path.cubicTo(
      5.899312650823097 * scale + translationX,
      18.477766599905557 * scale + translationY,
      6.00579832434167 * scale + translationX,
      18.73336246362944 * scale + translationY,
      6.00579832434167 * scale + translationX,
      19.0 * scale + translationY,
    );

    path.cubicTo(
      6.00579832434167 * scale + translationX,
      19.26663753637056 * scale + translationY,
      5.899312650823097 * scale + translationX,
      19.522233400094446 * scale + translationY,
      5.71 * scale + translationX,
      19.71 * scale + translationY,
    );

    path.close();

    path.moveTo(
      5.0 * scale + translationX,
      12.0 * scale + translationY,
    );

    path.cubicTo(
      4.447715250169207 * scale + translationX,
      12.0 * scale + translationY,
      4.0 * scale + translationX,
      12.447715250169207 * scale + translationY,
      4.0 * scale + translationX,
      13.0 * scale + translationY,
    );

    path.cubicTo(
      4.0 * scale + translationX,
      13.552284749830793 * scale + translationY,
      4.447715250169207 * scale + translationX,
      14.0 * scale + translationY,
      5.0 * scale + translationX,
      14.0 * scale + translationY,
    );

    path.cubicTo(
      7.761423881852427 * scale + translationX,
      14.000000167467837 * scale + translationY,
      10.000000190160032 * scale + translationX,
      16.238576475775442 * scale + translationY,
      10.000000149011612 * scale + translationX,
      19.000000283122063 * scale + translationY,
    );

    path.cubicTo(
      10.0 * scale + translationX,
      19.552284749830793 * scale + translationY,
      10.447715250169207 * scale + translationX,
      20.0 * scale + translationY,
      11.0 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.cubicTo(
      11.552284749830793 * scale + translationX,
      20.0 * scale + translationY,
      12.0 * scale + translationX,
      19.552284749830793 * scale + translationY,
      12.0 * scale + translationX,
      19.0 * scale + translationY,
    );

    path.cubicTo(
      12.000000709265183 * scale + translationX,
      15.134007356141485 * scale + translationY,
      8.865993716742121 * scale + translationX,
      12.000000363618422 * scale + translationY,
      5.000000223517418 * scale + translationX,
      12.000000536441803 * scale + translationY,
    );

    path.close();

    path.moveTo(
      5.0 * scale + translationX,
      8.0 * scale + translationY,
    );

    path.cubicTo(
      4.447715250169207 * scale + translationX,
      8.0 * scale + translationY,
      4.0 * scale + translationX,
      8.447715250169207 * scale + translationY,
      4.0 * scale + translationX,
      9.0 * scale + translationY,
    );

    path.cubicTo(
      4.0 * scale + translationX,
      9.552284749830793 * scale + translationY,
      4.447715250169207 * scale + translationX,
      10.0 * scale + translationY,
      5.0 * scale + translationX,
      10.0 * scale + translationY,
    );

    path.cubicTo(
      9.970562838103431 * scale + translationX,
      10.000000037472228 * scale + translationY,
      14.000000141341706 * scale + translationX,
      14.029437340710503 * scale + translationY,
      14.000000104308128 * scale + translationX,
      19.00000014156103 * scale + translationY,
    );

    path.cubicTo(
      14.0 * scale + translationX,
      19.552284749830793 * scale + translationY,
      14.447715250169207 * scale + translationX,
      20.0 * scale + translationY,
      15.0 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.cubicTo(
      15.552284749830793 * scale + translationX,
      20.0 * scale + translationY,
      16.0 * scale + translationX,
      19.552284749830793 * scale + translationY,
      16.0 * scale + translationX,
      19.0 * scale + translationY,
    );

    path.cubicTo(
      16.00000065789022 * scale + translationX,
      12.924868062057717 * scale + translationY,
      11.07513265319802 * scale + translationX,
      8.000000057365519 * scale + translationY,
      5.000000149011613 * scale + translationX,
      8.000000238418579 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}