// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:59.262524

import 'dart:math' as math;

import 'package:flutter/material.dart';

class MasterCardIcon extends StatelessWidget {
  final Color? color;

  const MasterCardIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: MasterCardPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class MasterCardPainter extends CustomPainter {
  final Color color;

  const MasterCardPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 21.08686101175451;
    final scaleY = size.height / 14.907777096131795;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 21.08686101175451 * scale) / 2 - 1.463878589681542 * scale;
    final translationY = (size.height - 14.907777096131795 * scale) / 2 - 4.548071923397313 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      15.26465 * scale + translationX,
      5.27441 * scale + translationY,
    );

    path.cubicTo(
      14.1183822122437 * scale + translationX,
      5.273952930706346 * scale + translationY,
      12.991274037069344 * scale + translationX,
      5.56840712193531 * scale + translationY,
      11.991699663326289 * scale + translationX,
      6.12945982791197 * scale + translationY,
    );

    path.cubicTo(
      9.16237805207876 * scale + translationX,
      4.548071923397313 * scale + translationY,
      5.607681816109713 * scale + translationX,
      5.208947112017009 * scale + translationY,
      3.5357802028956273 * scale + translationX,
      7.7015517870631065 * scale + translationY,
    );

    path.cubicTo(
      1.463878589681542 * scale + translationX,
      10.194156462109204 * scale + translationY,
      1.463878589681542 * scale + translationX,
      13.809764480817211 * scale + translationY,
      3.535780202895627 * scale + translationX,
      16.30236915586331 * scale + translationY,
    );

    path.cubicTo(
      5.607681816109712 * scale + translationX,
      18.794973830909406 * scale + translationY,
      9.162378052078758 * scale + translationX,
      19.455849019529108 * scale + translationY,
      11.99170047106017 * scale + translationX,
      17.87446070214784 * scale + translationY,
    );

    path.cubicTo(
      14.45068716952909 * scale + translationX,
      19.245156277883574 * scale + translationY,
      17.503183514586006 * scale + translationX,
      18.93928942538898 * scale + translationY,
      19.64131924241744 * scale + translationX,
      17.107952576004635 * scale + translationY,
    );

    path.cubicTo(
      21.77945497024887 * scale + translationX,
      15.276615726620284 * scale + translationY,
      22.550739601436053 * scale + translationX,
      12.307371970083064 * scale + translationY,
      21.57417434774835 * scale + translationX,
      9.666966820900063 * scale + translationY,
    );

    path.cubicTo(
      20.597609094060648 * scale + translationX,
      7.026561671717064 * scale + translationY,
      18.079863005583597 * scale + translationX,
      5.273780138838738 * scale + translationY,
      15.26465100932884 * scale + translationX,
      5.2744603487577235 * scale + translationY,
    );

    path.close();

    path.moveTo(
      10.23712 * scale + translationX,
      16.457 * scale + translationY,
    );

    path.cubicTo(
      9.749616934123425 * scale + translationX,
      16.631434341885846 * scale + translationY,
      9.236485808196115 * scale + translationX,
      16.723532114126943 * scale + translationY,
      8.718749761806487 * scale + translationX,
      16.729519542954765 * scale + translationY,
    );

    path.cubicTo(
      6.108158758259801 * scale + translationX,
      16.729014790633546 * scale + translationY,
      3.9921242750853283 * scale + translationX,
      14.61257097385248 * scale + translationY,
      3.992124275085328 * scale + translationX,
      12.001979816545859 * scale + translationY,
    );

    path.cubicTo(
      3.992124275085328 * scale + translationX,
      9.391388659239237 * scale + translationY,
      6.1081587582598 * scale + translationX,
      7.27494484245817 * scale + translationY,
      8.718749866731086 * scale + translationX,
      7.2744398888078345 * scale + translationY,
    );

    path.cubicTo(
      9.236487024026914 * scale + translationX,
      7.280425765503799 * scale + translationY,
      9.749618968656218 * scale + translationX,
      7.372527064179236 * scale + translationY,
      10.237119934994 * scale + translationX,
      7.546969952076529 * scale + translationY,
    );

    path.cubicTo(
      7.970457340513684 * scale + translationX,
      10.08449818983154 * scale + translationY,
      7.970457340513684 * scale + translationX,
      13.919440234344437 * scale + translationY,
      10.237119327947847 * scale + translationX,
      16.456968919623666 * scale + translationY,
    );

    path.close();

    path.moveTo(
      11.9917 * scale + translationX,
      15.3996 * scale + translationY,
    );

    path.cubicTo(
      11.062748249725717 * scale + translationX,
      14.51352292460009 * scale + translationY,
      10.537109151951777 * scale + translationX,
      13.285730368504417 * scale + translationY,
      10.537109151951777 * scale + translationX,
      12.001954292128962 * scale + translationY,
    );

    path.cubicTo(
      10.537109151951777 * scale + translationX,
      10.71817821575351 * scale + translationY,
      11.062748249725717 * scale + translationX,
      9.490385659657834 * scale + translationY,
      11.991699292733799 * scale + translationX,
      8.604309492520859 * scale + translationY,
    );

    path.cubicTo(
      12.92065033574188 * scale + translationX,
      9.490385659657834 * scale + translationY,
      13.44628943351582 * scale + translationX,
      10.718178215753507 * scale + translationY,
      13.44628943351582 * scale + translationX,
      12.001954292128962 * scale + translationY,
    );

    path.cubicTo(
      13.44628943351582 * scale + translationX,
      13.285730368504417 * scale + translationY,
      12.92065033574188 * scale + translationX,
      14.513522924600093 * scale + translationY,
      11.991699292733799 * scale + translationX,
      15.399599091737068 * scale + translationY,
    );

    path.close();

    path.moveTo(
      15.26465 * scale + translationX,
      16.72949 * scale + translationY,
    );

    path.cubicTo(
      14.746913185908271 * scale + translationX,
      16.72350274458333 * scale + translationY,
      14.233781916917325 * scale + translationX,
      16.631404946664897 * scale + translationY,
      13.74627937965547 * scale + translationX,
      16.456969257326975 * scale + translationY,
    );

    path.cubicTo(
      16.012941085010723 * scale + translationX,
      13.919440234344439 * scale + translationY,
      16.012941085010723 * scale + translationX,
      10.08449818983154 * scale + translationY,
      13.746279097576556 * scale + translationX,
      7.546969504552311 * scale + translationY,
    );

    path.cubicTo(
      14.23378135657624 * scale + translationX,
      7.372526529966655 * scale + translationY,
      14.746913480338021 * scale + translationX,
      7.280425199138992 * scale + translationY,
      15.264650674525186 * scale + translationX,
      7.274440321448113 * scale + translationY,
    );

    path.cubicTo(
      17.875240875148297 * scale + translationX,
      7.27494484245517 * scale + translationY,
      19.991275358326078 * scale + translationX,
      9.391388659237116 * scale + translationY,
      19.991275358326078 * scale + translationX,
      12.001979816545855 * scale + translationY,
    );

    path.cubicTo(
      19.991275358326078 * scale + translationX,
      14.612570973854597 * scale + translationY,
      17.875240875148297 * scale + translationX,
      16.72901479063654 * scale + translationY,
      15.264649766674891 * scale + translationX,
      16.72951974428388 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}