// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:59.080463

import 'dart:math' as math;

import 'package:flutter/material.dart';

class LinkedinIcon extends StatelessWidget {
  final Color? color;

  const LinkedinIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: LinkedinPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class LinkedinPainter extends CustomPainter {
  final Color color;

  const LinkedinPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 19.880001113821734;
    final scaleY = size.height / 20.022245666106286;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 19.880001113821734 * scale) / 2 - 2.06 * scale;
    final translationY = (size.height - 20.022245666106286 * scale) / 2 - 1.98887777614744 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      20.47 * scale + translationX,
      2.0 * scale + translationY,
    );

    path.lineTo(
      3.5300000000000002 * scale + translationX,
      2.0 * scale + translationY,
    );

    path.cubicTo(
      2.7291567435692747 * scale + translationX,
      1.98887777614744 * scale + translationY,
      2.070970040892653 * scale + translationX,
      2.6291546365743583 * scale + translationY,
      2.0600001045794336 * scale + translationX,
      3.4300001741298334 * scale + translationY,
    );

    path.lineTo(
      2.06 * scale + translationX,
      20.57 * scale + translationY,
    );

    path.cubicTo(
      2.070970040892653 * scale + translationX,
      21.370846581826807 * scale + translationY,
      2.7291567435692747 * scale + translationX,
      22.011123442253727 * scale + translationY,
      3.530000179206505 * scale + translationX,
      22.000001116867736 * scale + translationY,
    );

    path.lineTo(
      20.47 * scale + translationX,
      22.0 * scale + translationY,
    );

    path.cubicTo(
      21.27084447483189 * scale + translationX,
      22.011123442253727 * scale + translationY,
      21.929031177508513 * scale + translationX,
      21.370846581826807 * scale + translationY,
      21.940001113821733 * scale + translationX,
      20.570001044271333 * scale + translationY,
    );

    path.lineTo(
      21.939999999999998 * scale + translationX,
      3.43 * scale + translationY,
    );

    path.cubicTo(
      21.929031177508513 * scale + translationX,
      2.6291546365743588 * scale + translationY,
      21.27084447483189 * scale + translationX,
      1.9888777761474403 * scale + translationY,
      20.47000103919466 * scale + translationX,
      2.0000001015334306 * scale + translationY,
    );

    path.close();

    path.moveTo(
      8.09 * scale + translationX,
      18.74 * scale + translationY,
    );

    path.lineTo(
      5.09 * scale + translationX,
      18.74 * scale + translationY,
    );

    path.lineTo(
      5.09 * scale + translationX,
      9.739999999999998 * scale + translationY,
    );

    path.lineTo(
      8.09 * scale + translationX,
      9.739999999999998 * scale + translationY,
    );

    path.close();

    path.moveTo(
      6.59 * scale + translationX,
      8.48 * scale + translationY,
    );

    path.lineTo(
      6.59 * scale + translationX,
      8.48 * scale + translationY,
    );

    path.cubicTo(
      5.728435800111163 * scale + translationX,
      8.479999919935365 * scale + translationY,
      5.030000035465673 * scale + translationX,
      7.781564155289875 * scale + translationY,
      5.030000035465673 * scale + translationX,
      6.919999977155824 * scale + translationY,
    );

    path.cubicTo(
      5.030000035465673 * scale + translationX,
      6.058435799021773 * scale + translationY,
      5.728435800111163 * scale + translationX,
      5.360000034376283 * scale + translationY,
      6.589999978245214 * scale + translationX,
      5.360000034376283 * scale + translationY,
    );

    path.cubicTo(
      7.189510848675232 * scale + translationX,
      5.292010441259133 * scale + translationY,
      7.77494568611601 * scale + translationX,
      5.57359170327018 * scale + translationY,
      8.096072855125554 * scale + translationX,
      6.0843879763447 * scale + translationY,
    );

    path.cubicTo(
      8.417200024135097 * scale + translationX,
      6.59518424941922 * scale + translationY,
      8.417200024135097 * scale + translationX,
      7.244816419193042 * scale + translationY,
      8.096072855125554 * scale + translationX,
      7.755612692267563 * scale + translationY,
    );

    path.cubicTo(
      7.77494568611601 * scale + translationX,
      8.266408965342082 * scale + translationY,
      7.1895108486752335 * scale + translationX,
      8.547990227353129 * scale + translationY,
      6.5900003183637885 * scale + translationX,
      8.480000409669941 * scale + translationY,
    );

    path.close();

    path.moveTo(
      18.91 * scale + translationX,
      18.74 * scale + translationY,
    );

    path.lineTo(
      15.91 * scale + translationX,
      18.74 * scale + translationY,
    );

    path.lineTo(
      15.91 * scale + translationX,
      13.91 * scale + translationY,
    );

    path.cubicTo(
      15.91 * scale + translationX,
      12.7 * scale + translationY,
      15.48 * scale + translationX,
      11.91 * scale + translationY,
      14.39 * scale + translationX,
      11.91 * scale + translationY,
    );

    path.cubicTo(
      13.699080810788825 * scale + translationX,
      11.915058292735052 * scale + translationY,
      13.084481813261272 * scale + translationX,
      12.350066674101955 * scale + translationY,
      12.850000197282336 * scale + translationX,
      13.000000199585244 * scale + translationY,
    );

    path.cubicTo(
      12.771744448545665 * scale + translationX,
      13.235040267675359 * scale + translationY,
      12.737835791536435 * scale + translationX,
      13.482573463842739 * scale + translationY,
      12.750000000000002 * scale + translationX,
      13.73 * scale + translationY,
    );

    path.lineTo(
      12.75 * scale + translationX,
      18.73 * scale + translationY,
    );

    path.lineTo(
      9.75 * scale + translationX,
      18.73 * scale + translationY,
    );

    path.cubicTo(
      9.75 * scale + translationX,
      18.73 * scale + translationY,
      9.75 * scale + translationX,
      10.55 * scale + translationY,
      9.75 * scale + translationX,
      9.73 * scale + translationY,
    );

    path.lineTo(
      12.75 * scale + translationX,
      9.73 * scale + translationY,
    );

    path.lineTo(
      12.75 * scale + translationX,
      11.0 * scale + translationY,
    );

    path.cubicTo(
      13.305401143674427 * scale + translationX,
      10.036267503003401 * scale + translationY,
      14.348440762998226 * scale + translationX,
      9.458939300425651 * scale + translationY,
      15.460000460743904 * scale + translationX,
      9.500000283122063 * scale + translationY,
    );

    path.cubicTo(
      17.46 * scale + translationX,
      9.5 * scale + translationY,
      18.91 * scale + translationX,
      10.79 * scale + translationY,
      18.91 * scale + translationX,
      13.559999999999999 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}