// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:58.602427

import 'dart:math' as math;

import 'package:flutter/material.dart';

class HouseUserIcon extends StatelessWidget {
  final Color? color;

  const HouseUserIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: HouseUserPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class HouseUserPainter extends CustomPainter {
  final Color color;

  const HouseUserPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 20.229435692278976;
    final scaleY = size.height / 20.08480708589824;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 20.229435692278976 * scale) / 2 - 1.8852831044988216 * scale;
    final translationY = (size.height - 20.08480708589824 * scale) / 2 - 1.9151929141017576 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      21.664 * scale + translationX,
      10.252 * scale + translationY,
    );

    path.lineTo(
      12.664000000000001 * scale + translationX,
      2.2520000000000007 * scale + translationY,
    );

    path.cubicTo(
      12.285399201000043 * scale + translationX,
      1.9151929141017576 * scale + translationY,
      11.714601093994624 * scale + translationX,
      1.9151929141017576 * scale + translationY,
      11.336000139335816 * scale + translationX,
      2.2520000276803334 * scale + translationY,
    );

    path.lineTo(
      2.336000000000002 * scale + translationX,
      10.252 * scale + translationY,
    );

    path.cubicTo(
      1.922891187512778 * scale + translationX,
      10.618717925032051 * scale + translationY,
      1.8852831044988216 * scale + translationX,
      11.250891891885702 * scale + translationY,
      2.2520001978860007 * scale + translationX,
      11.664000906725477 * scale + translationY,
    );

    path.cubicTo(
      2.618717291273179 * scale + translationX,
      12.07710992156525 * scale + translationY,
      3.2508912581268308 * scale + translationX,
      12.114718004579208 * scale + translationY,
      3.6640002729666055 * scale + translationX,
      11.74800091119203 * scale + translationY,
    );

    path.lineTo(
      4.0 * scale + translationX,
      11.449 * scale + translationY,
    );

    path.lineTo(
      4.0 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.cubicTo(
      4.0 * scale + translationX,
      21.552284749830793 * scale + translationY,
      4.447715250169207 * scale + translationX,
      22.0 * scale + translationY,
      5.0 * scale + translationX,
      22.0 * scale + translationY,
    );

    path.lineTo(
      19.0 * scale + translationX,
      22.0 * scale + translationY,
    );

    path.cubicTo(
      19.552284749830793 * scale + translationX,
      22.0 * scale + translationY,
      20.0 * scale + translationX,
      21.552284749830793 * scale + translationY,
      20.0 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.lineTo(
      20.0 * scale + translationX,
      11.449 * scale + translationY,
    );

    path.lineTo(
      20.336 * scale + translationX,
      11.748 * scale + translationY,
    );

    path.cubicTo(
      20.749110643149788 * scale + translationX,
      12.11471800457921 * scale + translationY,
      21.38128461000344 * scale + translationX,
      12.077109921565253 * scale + translationY,
      21.74800170339062 * scale + translationX,
      11.664000906725478 * scale + translationY,
    );

    path.cubicTo(
      22.114718796777797 * scale + translationX,
      11.250891891885702 * scale + translationY,
      22.07711071376384 * scale + translationX,
      10.618717925032051 * scale + translationY,
      21.664001698924064 * scale + translationX,
      10.252000831644871 * scale + translationY,
    );

    path.close();

    path.moveTo(
      9.184 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.cubicTo(
      9.60141196927128 * scale + translationX,
      18.80187169941745 * scale + translationY,
      10.731242780110476 * scale + translationX,
      17.99905562234081 * scale + translationY,
      12.00000086412345 * scale + translationX,
      17.99905562234081 * scale + translationY,
    );

    path.cubicTo(
      13.268758948136425 * scale + translationX,
      17.99905562234081 * scale + translationY,
      14.39858975897562 * scale + translationX,
      18.80187169941745 * scale + translationY,
      14.816001066904418 * scale + translationX,
      20.00000144020575 * scale + translationY,
    );

    path.close();

    path.moveTo(
      10.5 * scale + translationX,
      14.5 * scale + translationY,
    );

    path.cubicTo(
      10.500000337613438 * scale + translationX,
      13.671573319026015 * scale + translationY,
      11.171573214717885 * scale + translationX,
      13.000000468607475 * scale + translationY,
      12.000000327825546 * scale + translationX,
      13.000000476837158 * scale + translationY,
    );

    path.cubicTo(
      12.828427440933204 * scale + translationX,
      13.000000485066842 * scale + translationY,
      13.500000304694701 * scale + translationX,
      13.671573348828339 * scale + translationY,
      13.500000312924385 * scale + translationX,
      14.500000461935997 * scale + translationY,
    );

    path.cubicTo(
      13.500000321154069 * scale + translationX,
      15.328427575043655 * scale + translationY,
      12.828427470735528 * scale + translationX,
      16.000000452148107 * scale + translationY,
      12.000000357627869 * scale + translationX,
      16.000000476837158 * scale + translationY,
    );

    path.cubicTo(
      11.172029046505246 * scale + translationX,
      15.998897299469357 * scale + translationY,
      10.501101194271365 * scale + translationX,
      15.327969447235477 * scale + translationY,
      10.499999403180286 * scale + translationX,
      14.499999175820395 * scale + translationY,
    );

    path.close();

    path.moveTo(
      18.0 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.lineTo(
      16.899 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.cubicTo(
      16.61954239276881 * scale + translationX,
      18.660170240870503 * scale + translationY,
      15.803067599930147 * scale + translationX,
      17.493467880851373 * scale + translationY,
      14.640000218153002 * scale + translationX,
      16.772000249922275 * scale + translationY,
    );

    path.cubicTo(
      15.191220642287293 * scale + translationX,
      16.143125401803594 * scale + translationY,
      15.496639508096331 * scale + translationX,
      15.336251374922037 * scale + translationY,
      15.500000105575012 * scale + translationX,
      14.500000098763717 * scale + translationY,
    );

    path.cubicTo(
      15.500000536441803 * scale + translationX,
      12.567004023792732 * scale + translationY,
      13.93299716084958 * scale + translationX,
      11.000000648200508 * scale + translationY,
      12.000000536441803 * scale + translationX,
      11.000000648200508 * scale + translationY,
    );

    path.cubicTo(
      10.067003912034027 * scale + translationX,
      11.000000648200508 * scale + translationY,
      8.500000536441803 * scale + translationX,
      12.567004023792732 * scale + translationY,
      8.500000536441803 * scale + translationX,
      14.500000648200508 * scale + translationY,
    );

    path.cubicTo(
      8.503360655374655 * scale + translationX,
      15.336251374922037 * scale + translationY,
      8.808779521183693 * scale + translationX,
      16.143125401803594 * scale + translationY,
      9.360000063753683 * scale + translationX,
      16.77200011423897 * scale + translationY,
    );

    path.cubicTo(
      8.196553566953499 * scale + translationX,
      17.493267666468345 * scale + translationY,
      7.379697228057771 * scale + translationX,
      18.659998755829147 * scale + translationY,
      7.1000001057982445 * scale + translationX,
      20.000000298023224 * scale + translationY,
    );

    path.lineTo(
      6.0 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.lineTo(
      6.0 * scale + translationX,
      9.671 * scale + translationY,
    );

    path.lineTo(
      12.0 * scale + translationX,
      4.337999999999999 * scale + translationY,
    );

    path.lineTo(
      18.0 * scale + translationX,
      9.671 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}