// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:58.476072

import 'dart:math' as math;

import 'package:flutter/material.dart';

class HeadphoneSlashIcon extends StatelessWidget {
  final Color? color;

  const HeadphoneSlashIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: HeadphoneSlashPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class HeadphoneSlashPainter extends CustomPainter {
  final Color color;

  const HeadphoneSlashPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 20.184739780718814;
    final scaleY = size.height / 20.18475637937243;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 20.184739780718814 * scale) / 2 - 1.908545786281577 * scale;
    final translationY = (size.height - 20.18475637937243 * scale) / 2 - 1.9085457862815767 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      19.06934 * scale + translationX,
      5.93555 * scale + translationY,
    );

    path.cubicTo(
      16.622033331399045 * scale + translationX,
      3.4649331196932454 * scale + translationY,
      13.06194910708813 * scale + translationX,
      2.452157207135567 * scale + translationY,
      9.680660151687038 * scale + translationX,
      3.264650051154064 * scale + translationY,
    );

    path.cubicTo(
      9.143257925204885 * scale + translationX,
      3.386993375542181 * scale + translationY,
      8.806186123711122 * scale + translationX,
      3.921123635439996 * scale + translationY,
      8.927030883530337 * scale + translationX,
      4.4588646270849015 * scale + translationY,
    );

    path.cubicTo(
      9.047875643349553 * scale + translationX,
      4.9966056187298085 * scale + translationY,
      9.581064144013752 * scale + translationX,
      5.33516515065916 * scale + translationY,
      10.11913993525461 * scale + translationX,
      5.21581996662757 * scale + translationY,
    );

    path.cubicTo(
      12.50371469550456 * scale + translationX,
      4.646726495249845 * scale + translationY,
      15.017610948392152 * scale + translationX,
      5.199632444371092 * scale + translationY,
      16.943347560175123 * scale + translationX,
      6.7167352490569945 * scale + translationY,
    );

    path.cubicTo(
      18.869084171958093 * scale + translationX,
      8.233838053742897 * scale + translationY,
      19.99509172672259 * scale + translationX,
      10.548462503944101 * scale + translationY,
      20.0000006982674 * scale + translationX,
      13.00000045387381 * scale + translationY,
    );

    path.lineTo(
      19.66016 * scale + translationX,
      13.0 * scale + translationY,
    );

    path.cubicTo(
      19.107875250169208 * scale + translationX,
      13.0 * scale + translationY,
      18.66016 * scale + translationX,
      13.447715250169207 * scale + translationY,
      18.66016 * scale + translationX,
      14.0 * scale + translationY,
    );

    path.cubicTo(
      18.66016 * scale + translationX,
      14.552284749830793 * scale + translationY,
      19.107875250169208 * scale + translationX,
      15.0 * scale + translationY,
      19.66016 * scale + translationX,
      15.0 * scale + translationY,
    );

    path.lineTo(
      20.0 * scale + translationX,
      15.0 * scale + translationY,
    );

    path.lineTo(
      20.0 * scale + translationX,
      15.33984 * scale + translationY,
    );

    path.cubicTo(
      20.0 * scale + translationX,
      15.892124749830794 * scale + translationY,
      20.447715250169207 * scale + translationX,
      16.339840000000002 * scale + translationY,
      21.0 * scale + translationX,
      16.339840000000002 * scale + translationY,
    );

    path.cubicTo(
      21.552284749830793 * scale + translationX,
      16.339840000000002 * scale + translationY,
      22.0 * scale + translationX,
      15.892124749830794 * scale + translationY,
      22.0 * scale + translationX,
      15.33984 * scale + translationY,
    );

    path.lineTo(
      22.0 * scale + translationX,
      13.0 * scale + translationY,
    );

    path.cubicTo(
      22.010185744405586 * scale + translationX,
      10.347421032802574 * scale + translationY,
      20.95421552468772 * scale + translationX,
      7.801970923036899 * scale + translationY,
      19.069340455015524 * scale + translationX,
      5.9355501416287835 * scale + translationY,
    );

    path.close();

    path.moveTo(
      3.707 * scale + translationX,
      2.293 * scale + translationY,
    );

    path.cubicTo(
      3.3155194312861966 * scale + translationX,
      1.9085457862815767 * scale + translationY,
      2.68735674858278 * scale + translationX,
      1.9113898681542307 * scale + translationY,
      2.2993733083685055 * scale + translationX,
      2.2993733083685055 * scale + translationY,
    );

    path.cubicTo(
      1.9113898681542307 * scale + translationX,
      2.68735674858278 * scale + translationY,
      1.908545786281577 * scale + translationX,
      3.3155194312861966 * scale + translationY,
      2.293000108927965 * scale + translationX,
      3.707000176099418 * scale + translationY,
    );

    path.lineTo(
      4.72833 * scale + translationX,
      6.1424 * scale + translationY,
    );

    path.cubicTo(
      2.97442839858471 * scale + translationX,
      7.99463923879096 * scale + translationY,
      1.9978987181961512 * scale + translationX,
      10.449126026031722 * scale + translationY,
      1.9999999607917118 * scale + translationX,
      12.999999745146129 * scale + translationY,
    );

    path.lineTo(
      2.0 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.cubicTo(
      2.0 * scale + translationX,
      20.552284749830793 * scale + translationY,
      2.4477152501692068 * scale + translationX,
      21.0 * scale + translationY,
      3.0 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.lineTo(
      6.0 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.cubicTo(
      7.656104479282697 * scale + translationX,
      20.998191160030764 * scale + translationY,
      8.998191779846259 * scale + translationX,
      19.6561038594672 * scale + translationY,
      8.999999535138379 * scale + translationX,
      17.999999070276758 * scale + translationY,
    );

    path.lineTo(
      9.0 * scale + translationX,
      16.0 * scale + translationY,
    );

    path.cubicTo(
      8.998191779846259 * scale + translationX,
      14.343894384388895 * scale + translationY,
      7.656104479282697 * scale + translationX,
      13.001807083825332 * scale + translationY,
      5.9999996900922525 * scale + translationX,
      12.999999328533214 * scale + translationY,
    );

    path.lineTo(
      4.0 * scale + translationX,
      13.0 * scale + translationY,
    );

    path.cubicTo(
      3.998781206013247 * scale + translationX,
      10.97984264588415 * scale + translationY,
      4.765377182006141 * scale + translationX,
      9.03472506313758 * scale + translationY,
      6.144529999910582 * scale + translationX,
      7.55858999989001 * scale + translationY,
    );

    path.lineTo(
      15.0 * scale + translationX,
      16.41406 * scale + translationY,
    );

    path.lineTo(
      15.0 * scale + translationX,
      18.0 * scale + translationY,
    );

    path.cubicTo(
      15.00180698052275 * scale + translationX,
      19.6561038594672 * scale + translationY,
      16.343894281086314 * scale + translationX,
      20.998191160030764 * scale + translationY,
      17.999999070276758 * scale + translationX,
      20.999998915322884 * scale + translationY,
    );

    path.lineTo(
      19.58594 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.lineTo(
      20.29294 * scale + translationX,
      21.707 * scale + translationY,
    );

    path.cubicTo(
      20.684116004481453 * scale + translationX,
      22.093302165654006 * scale + translationY,
      21.31378394428299 * scale + translationX,
      22.091335207767468 * scale + translationY,
      21.702537917691235 * scale + translationX,
      21.702597729584603 * scale + translationY,
    );

    path.cubicTo(
      22.091291891099484 * scale + translationX,
      21.31386025140174 * scale + translationY,
      22.093285567000393 * scale + translationX,
      20.684192395628838 * scale + translationY,
      21.707001031181566 * scale + translationX,
      20.293000964010115 * scale + translationY,
    );

    path.close();

    path.moveTo(
      6.0 * scale + translationX,
      15.0 * scale + translationY,
    );

    path.cubicTo(
      6.551987700096894 * scale + translationX,
      15.000715903767926 * scale + translationY,
      6.999283681722106 * scale + translationX,
      15.448011885393136 * scale + translationY,
      6.999999868110464 * scale + translationX,
      15.999999698538204 * scale + translationY,
    );

    path.lineTo(
      7.0 * scale + translationX,
      18.0 * scale + translationY,
    );

    path.cubicTo(
      6.9992836817221065 * scale + translationX,
      18.551987474000548 * scale + translationY,
      6.551987700096895 * scale + translationX,
      18.999283455625758 * scale + translationY,
      5.9999998869518265 * scale + translationX,
      18.999999642014117 * scale + translationY,
    );

    path.lineTo(
      4.0 * scale + translationX,
      19.0 * scale + translationY,
    );

    path.lineTo(
      4.0 * scale + translationX,
      15.0 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}