// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:57.229227

import 'dart:math' as math;

import 'package:flutter/material.dart';

class CornerDownLeftIcon extends StatelessWidget {
  final Color? color;

  const CornerDownLeftIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: CornerDownLeftPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class CornerDownLeftPainter extends CustomPainter {
  final Color color;

  const CornerDownLeftPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 15.440235944641765;
    final scaleY = size.height / 20.012428635853972;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 15.440235944641765 * scale) / 2 - 4.2899819818503655 * scale;
    final translationY = (size.height - 20.012428635853972 * scale) / 2 - 1.989108122945663 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      18.69 * scale + translationX,
      2.0 * scale + translationY,
    );

    path.cubicTo(
      18.137715250169208 * scale + translationX,
      2.0 * scale + translationY,
      17.69 * scale + translationX,
      2.4477152501692068 * scale + translationY,
      17.69 * scale + translationX,
      3.0 * scale + translationY,
    );

    path.lineTo(
      17.69 * scale + translationX,
      13.37 * scale + translationY,
    );

    path.cubicTo(
      17.69 * scale + translationX,
      14.474569499661586 * scale + translationY,
      16.794569499661588 * scale + translationX,
      15.37 * scale + translationY,
      15.690000000000001 * scale + translationX,
      15.37 * scale + translationY,
    );

    path.lineTo(
      7.690000000000001 * scale + translationX,
      15.37 * scale + translationY,
    );

    path.lineTo(
      10.610000000000001 * scale + translationX,
      12.45 * scale + translationY,
    );

    path.cubicTo(
      10.964371506926685 * scale + translationX,
      12.063402689760348 * scale + translationY,
      10.959880683219795 * scale + translationX,
      11.468715752024277 * scale + translationY,
      10.59971108586053 * scale + translationX,
      11.087514353359362 * scale + translationY,
    );

    path.cubicTo(
      10.239541488501265 * scale + translationX,
      10.706312954694447 * scale + translationY,
      9.646065569066893 * scale + translationX,
      10.668115383266409 * scale + translationY,
      9.24 * scale + translationX,
      11.0 * scale + translationY,
    );

    path.lineTo(
      4.61 * scale + translationX,
      15.66 * scale + translationY,
    );

    path.cubicTo(
      4.518723441463956 * scale + translationX,
      15.756919936201978 * scale + translationY,
      4.444357484511682 * scale + translationX,
      15.868468871630387 * scale + translationY,
      4.390000260806837 * scale + translationX,
      15.990000949954746 * scale + translationY,
    );

    path.cubicTo(
      4.289981981850366 * scale + translationX,
      16.233461355746577 * scale + translationY,
      4.2899819818503655 * scale + translationX,
      16.506538644253425 * scale + translationY,
      4.39 * scale + translationX,
      16.75 * scale + translationY,
    );

    path.cubicTo(
      4.44056547753553 * scale + translationX,
      16.87358500350243 * scale + translationY,
      4.515369795819113 * scale + translationX,
      16.985791480927805 * scale + translationY,
      4.609999999999999 * scale + translationX,
      17.08 * scale + translationY,
    );

    path.lineTo(
      9.24 * scale + translationX,
      21.709999999999997 * scale + translationY,
    );

    path.cubicTo(
      9.426260638525449 * scale + translationX,
      21.894744163617897 * scale + translationY,
      9.677660122615665 * scale + translationX,
      21.99889537845527 * scale + translationY,
      9.94 * scale + translationX,
      21.999999999999996 * scale + translationY,
    );

    path.cubicTo(
      10.20580298465003 * scale + translationX,
      22.001536758799634 * scale + translationY,
      10.461281169195306 * scale + translationX,
      21.897186514407903 * scale + translationY,
      10.65 * scale + translationX,
      21.709999999999997 * scale + translationY,
    );

    path.cubicTo(
      10.839312650823096 * scale + translationX,
      21.522233400094443 * scale + translationY,
      10.94579832434167 * scale + translationX,
      21.26663753637056 * scale + translationY,
      10.94579832434167 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.cubicTo(
      10.94579832434167 * scale + translationX,
      20.73336246362944 * scale + translationY,
      10.839312650823096 * scale + translationX,
      20.477766599905554 * scale + translationY,
      10.65 * scale + translationX,
      20.29 * scale + translationY,
    );

    path.lineTo(
      7.73 * scale + translationX,
      17.37 * scale + translationY,
    );

    path.lineTo(
      15.73 * scale + translationX,
      17.37 * scale + translationY,
    );

    path.cubicTo(
      17.939138999323173 * scale + translationX,
      17.37 * scale + translationY,
      19.73 * scale + translationX,
      15.579138999323174 * scale + translationY,
      19.73 * scale + translationX,
      13.370000000000001 * scale + translationY,
    );

    path.lineTo(
      19.73 * scale + translationX,
      3.0 * scale + translationY,
    );

    path.cubicTo(
      19.73021792649213 * scale + translationX,
      2.7277053410210765 * scale + translationY,
      19.61938809296816 * scale + translationX,
      2.4670964639918775 * scale + translationY,
      19.423109036518355 * scale + translationX,
      2.2783666020209132 * scale + translationY,
    );

    path.cubicTo(
      19.22682998006855 * scale + translationX,
      2.089636740049949 * scale + translationY,
      18.9620768196937 * scale + translationX,
      1.989108122945663 * scale + translationY,
      18.69 * scale + translationX,
      2.0 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}