/*
 * Jitsi, the OpenSource Java VoIP and Instant Messaging client.
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.atalk.android.gui.controller;

import android.view.MotionEvent;
import android.view.View;

/**
 * The controller when set as <code>View.OnTouchListener</code> of given <code>View</code> makes it draggable on the screen.
 *
 * @author Pawel domas
 */
public class SimpleDragController implements View.OnTouchListener
{
	/**
	 * {@inheritDoc}
	 */
	public boolean onTouch(View view, MotionEvent motionEvent)
	{
		int action = motionEvent.getAction();
		if (action == MotionEvent.ACTION_MOVE) {
			view.setX(view.getX() + motionEvent.getX() - (view.getWidth() / 2));
			view.setY(view.getY() + motionEvent.getY() - (view.getHeight() / 2));
		}
		return true;
	}
}
