/*
 * Jitsi, the OpenSource Java VoIP and Instant Messaging client.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package net.java.sip.communicator.service.protocol.event;

import java.util.EventListener;

/**
 * <code>ContactPresenceStatusListener</code>s listener for events caused by changes in the status of
 * contacts that we have active subscriptions for.
 * <p>
 * Events handled by this listener a most often the direct result of server/ remotely generated
 * notifications.
 *
 * @author Emil Ivov
 * @author Eng Chong Meng
 */
public interface ContactPresenceStatusListener extends EventListener
{
    /**
     * Called whenever a change occurs in the PresenceStatus of one of the contacts that we have
     * subscribed for.
     *
     * @param evt the ContactPresenceStatusChangeEvent describing the status change.
     */
    void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt);

}
