/*
 * Jitsi, the OpenSource Java VoIP and Instant Messaging client.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.java.sip.communicator.service.contactsource;

import net.java.sip.communicator.service.protocol.PhoneNumberI18nService;
import net.java.sip.communicator.util.ServiceUtils;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/**
 * @author Damian Minkov
 */
public class ContactSourceActivator implements BundleActivator {
    /**
     * OSGi bundle context.
     */
    public static BundleContext bundleContext;

    /**
     * The registered PhoneNumberI18nService.
     */
    private static PhoneNumberI18nService phoneNumberI18nService;


    @Override
    public void start(BundleContext bundleContext)
            throws Exception {
        ContactSourceActivator.bundleContext = bundleContext;
    }

    @Override
    public void stop(BundleContext bundleContext)
            throws Exception {
    }

    /**
     * Returns the PhoneNumberI18nService.
     *
     * @return returns the PhoneNumberI18nService.
     */
    public static PhoneNumberI18nService getPhoneNumberI18nService() {
        if (phoneNumberI18nService == null) {
            phoneNumberI18nService = ServiceUtils.getService(bundleContext, PhoneNumberI18nService.class);
        }
        return phoneNumberI18nService;
    }
}
