// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Zulu (`zu`).
class AppLocalizationsZu extends AppLocalizations {
  AppLocalizationsZu([String locale = 'zu']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Yes';

  @override
  String get add => 'Engeza';

  @override
  String get account_delete_message =>
      'Uqinisekile ukuthi ufuna ukususa i-akhawunti yakho?\nUma kukhona isizathu esithile, sicela wabelane ngezansi';

  @override
  String get reason => 'Isizathu';

  @override
  String get okay => 'Kulungile';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'Dala';

  @override
  String get applyButtonText => 'Apply';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'Qhubeka';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'Buyela phezulu';

  @override
  String get save => 'Save';

  @override
  String get save_confirmation => 'Uqinisekile ukuthi ufuna ukulondoloza?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Cancel';

  @override
  String get ignore => 'Ziba';

  @override
  String get close => 'Vala';

  @override
  String get no => 'No';

  @override
  String get stop => 'Ima';

  @override
  String get finish => 'Qeda';

  @override
  String get calculate => 'Bala';

  @override
  String get reset_food_prefs => 'Setha kabusha izintandokazi zokudla';

  @override
  String get error => 'Kukhona into engahambanga kahle';

  @override
  String get error_occurred => 'Kuvele iphutha';

  @override
  String get featureInProgress => 'Sisasebenza kulesi sici, hlala ubukele';

  @override
  String get label_web => 'Buka kuwebhu';

  @override
  String get learnMore => 'Funda kabanzi';

  @override
  String get unknown => 'Akwaziwa';

  @override
  String get match_very_good => 'Ukufana okuhle kakhulu';

  @override
  String get match_good => 'Ukufana okuhle';

  @override
  String get match_poor => 'Ukufana okubi';

  @override
  String get match_may_not => 'May not match';

  @override
  String get match_does_not => 'Akufani';

  @override
  String get match_unknown => 'Ukufana okungaziwa';

  @override
  String get match_short_very_good => 'Ukufana okuhle kakhulu';

  @override
  String get match_short_good => 'Ukufana okuhle';

  @override
  String get match_short_poor => 'Ukufana okubi';

  @override
  String get match_short_may_not => 'May not match';

  @override
  String get match_short_does_not => 'Akufani';

  @override
  String get match_short_unknown => 'Ukufana okungaziwa';

  @override
  String get licenses => 'Amalayisense';

  @override
  String get looking_for => 'Ufuna';

  @override
  String get welcomeToOpenFoodFacts => 'Siyakwamukela ku-Open Food Facts';

  @override
  String get whatIsOff =>
      'I-Open Food Facts iyinhlangano engenzi nzuzo yomhlaba wonke eqhutshwa yimiphakathi yasendaweni.';

  @override
  String get productDataUtility =>
      'Bona idatha yokudla ehambisana nezintandokazi zakho.';

  @override
  String get healthCardUtility => 'Khetha ukudla okukulungele.';

  @override
  String get ecoCardUtility => 'Khetha ukudla okuhle emhlabeni.';

  @override
  String get server_error_open_new_issue =>
      'Ayikho impendulo yeseva! Ungavula inkinga ngesixhumanisi esilandelayo.';

  @override
  String get sign_in_text =>
      'Ngena ngemvume ku-akhawunti yakho ye-Open Food Facts ukuze ulondoloze iminikelo yakho';

  @override
  String get incorrect_credentials =>
      'Igama lomsebenzisi noma iphasiwedi engalungile.';

  @override
  String get password_lost_incorrect_credentials =>
      'Le imeyili noma igama lomsebenzisi alikho. Sicela uhlole iziqinisekiso zakho.';

  @override
  String get password_lost_server_unavailable =>
      'Okwamanje sibhekene nokwehla kwezinga lokusebenza kumaseva ethu futhi siyaxolisa ngakho. Sicela uzame futhi kamuva.';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable =>
      'Inethiwekhi ayifinyeleleki';

  @override
  String get login_result_type_server_issue =>
      'Inkinga kuseva. Sicela uzame kamuva.';

  @override
  String get login_page_username_or_email =>
      'Sicela ufake igama lomsebenzisi noma i-imeyili';

  @override
  String get login_page_password_error_empty => 'Sicela ufake iphasiwedi';

  @override
  String get create_account => 'Yenza i-akhawunti';

  @override
  String get sign_in => 'Ngena ngemvume';

  @override
  String get sign_in_mandatory =>
      'Ngaleso sici sidinga ukuthi ungene ngemvume.';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'Phuma ngemvume';

  @override
  String get sign_out_confirmation =>
      'Uqinisekile ukuthi ufuna ukuphuma ngemvume?';

  @override
  String get password => 'Iphasiwedi';

  @override
  String get forgot_password => 'Ukhohlwe iphasiwedi';

  @override
  String get forgot_password_question => 'Ukhohlwe iphasiwedi?';

  @override
  String get view_profile => 'Buka iphrofayela';

  @override
  String get reset_password => 'Setha kabusha iphasiwedi';

  @override
  String get reset_password_explanation_text =>
      'Uma iphasiwedi yakho ikhohliwe, faka igama lakho lomsebenzisi noma ikheli le-imeyili ukuze uthole imiyalelo yokusetha kabusha iphasiwedi. Futhi, khumbula ukuhlola ifolda ye-Spam.';

  @override
  String get username_or_email => 'Igama lomsebenzisi noma i-imeyili';

  @override
  String get reset_password_done =>
      'I-imeyili enesixhumanisi sokusetha kabusha iphasiwedi yakho ithunyelwe ekhelini le-imeyili elihlobene ne-akhawunti yakho. Hlola futhi ugaxekile wakho';

  @override
  String get send_reset_password_mail => 'SHINTSHA iphasiwedi';

  @override
  String get enter_some_text => 'Sicela ufake umbhalo othile';

  @override
  String get sign_up_page_title => 'Bhalisela';

  @override
  String get sign_up_page_action_button => 'Bhalisela';

  @override
  String get sign_up_page_action_doing_it => 'Ukubhalisa…';

  @override
  String get sign_up_page_action_ok =>
      'Halala! I-akhawunti yakho isanda kudalwa.';

  @override
  String get sign_up_page_display_name_hint => 'Igama';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Sicela ufake igama lokubonisa ofuna ukulisebenzisa';

  @override
  String get sign_up_page_email_hint => 'I-imeyili';

  @override
  String get sign_up_page_email_error_empty => 'I-imeyili iyadingeka';

  @override
  String get sign_up_page_email_error_invalid => 'I-imeyili engavumelekile';

  @override
  String get sign_up_page_username_hint =>
      'Igama lomsebenzisi: Kuyabonakala esidlangalaleni';

  @override
  String get sign_up_page_username_error_empty =>
      'Sicela ufake igama lomsebenzisi';

  @override
  String get sign_up_page_username_error_invalid =>
      'Sicela ufake igama lomsebenzisi elivumelekile';

  @override
  String get sign_up_page_username_description =>
      'Username cannot contains spaces, caps or special characters.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Igama lomsebenzisi alikwazi ukudlula izinhlamvu ezingu- $value';
  }

  @override
  String get sign_up_page_password_hint => 'Iphasiwedi';

  @override
  String get sign_up_page_password_error_empty => 'Sicela ufake iphasiwedi';

  @override
  String get sign_up_page_password_error_invalid =>
      'Sicela ufake iphasiwedi evumelekile (okungenani izinhlamvu ezingu-6)';

  @override
  String get sign_up_page_confirm_password_hint => 'Qinisekisa Iphasiwedi';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Sicela uqinisekise iphasiwedi';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Amaphasiwedi awafani';

  @override
  String get sign_up_page_agree_text =>
      'Ngiyavumelana namaqiniso okudla avulekile';

  @override
  String get sign_up_page_terms_text => 'imigomo yokusebenzisa kanye nomnikelo';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Uma udala i-akhawunti, ukuvumelana neMigomo Yokusebenzisa kuyimpoqo, noma kunjalo, iminikelo engaziwa isengenziwa ngohlelo lokusebenza';

  @override
  String get sign_up_page_producer_checkbox => 'Ngingumkhiqizi wokudla';

  @override
  String get sign_up_page_producer_hint => 'Umkhiqizi/umkhiqizo';

  @override
  String get sign_up_page_producer_error_empty =>
      'Sicela ufake umkhiqizi noma igama lomkhiqizo';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Ngingathanda ukubhalisela iphephandaba le-Open Food Facts (Ungazikhipha ohlwini lwazo nganoma yisiphi isikhathi)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Igama lomsebenzisi selivele likhona, sicela ukhethe elinye igama lomsebenzisi.';

  @override
  String get sign_up_page_email_already_exists =>
      'isivele ikhona, ngena ngemvume ku-akhawunti noma zama ngenye i-imeyili.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Sicela unikeze ikheli le-imeyili elivumelekile.';

  @override
  String get sign_up_page_server_busy =>
      'Siyaxolisa kakhulu, sinezinkinga zobuchwepheshe zokudala i-akhawunti yakho. Sicela uzame futhi kamuva.';

  @override
  String get settingsTitle => 'Settings';

  @override
  String get darkmode => 'Itimu';

  @override
  String get darkmode_dark => 'Okumnyama';

  @override
  String get darkmode_light => 'Ukukhanya';

  @override
  String get darkmode_system_default => 'Okuzenzakalelayo kwesistimu';

  @override
  String get thanks_for_contributing => 'Ngiyabonga ngokufaka isandla!';

  @override
  String get contributors_label => 'Bakha uhlelo lokusebenza';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Umnikeli: $name';
  }

  @override
  String get contributors_description =>
      'Uhlu lwabo bonke abanikeli balolu hlelo lokusebenza';

  @override
  String get support => 'Usekelo';

  @override
  String get support_join_slack => 'Cela usizo esiteshini sethu se-Slack';

  @override
  String get support_via_forum => 'Cela usizo esithangamini sethu';

  @override
  String get support_via_email => 'Sithumelele i-imeyili';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Thumela amalogi ohlelo lokusebenza?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Ufisa ukufaka amalogi ezicelo ku-imeyili yakho?';

  @override
  String get termsOfUse => 'Imigomo Yokusebenzisa';

  @override
  String get legalNotices => 'Izaziso zomthetho';

  @override
  String get privacy_policy => 'Inqubomgomo yobumfihlo';

  @override
  String get about_this_app => 'Mayelana nalolu hlelo lokusebenza';

  @override
  String get contribute => 'Contribute';

  @override
  String get contribute_sw_development => 'Ukuthuthukiswa kwesofthiwe';

  @override
  String get contribute_develop_text =>
      'Ikhodi yayo yonke imikhiqizo ye-Open Food Facts iyatholakala ku-GitHub. Wamukelekile ukusebenzisa kabusha ikhodi (ingumthombo ovulekile) futhi usisize siyithuthukise, kuwo wonke umuntu, kuwo wonke umhlaba.';

  @override
  String get contribute_develop_text_2 =>
      'Ungajoyina igumbi lokuxoxa le-Open Food Facts Slack okuyindlela ekhethwayo yokubuza imibuzo.';

  @override
  String get contribute_develop_dev_mode_title => 'Imodi ye-DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Sebenzisa imodi ye-DEV';

  @override
  String get contribute_donate_title => 'Donate';

  @override
  String get contribute_donate_header => 'Nikela ku-Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Sicela uvume ukuthi ngenguqulo ye-alpha yangaphakathi, kungenzeka ukuthi idatha ilahlekelwe ngokuphelele, futhi uhlelo lokusebenza lungase lungasebenzi nganoma yisiphi isikhathi!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Imikhiqizo okumele iqedwe';

  @override
  String get contribute_improve_header => 'Ukuthuthukisa';

  @override
  String get contribute_improve_text =>
      'Isizindalwazi siwumgogodla wephrojekthi. Kulula futhi kuyashesha ukusiza. Ungalanda uhlelo lokusebenza lweselula lwefoni yakho, bese uqala ukwengeza noma ukuthuthukisa imikhiqizo.\n\nNgakolunye uhlangothi, iwebhusayithi ye-Open Food Facts inikeza izindlela eziningi zokufaka isandla: ';

  @override
  String get contribute_translate_header => 'Humusha';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Qala Ukuhumusha';

  @override
  String get contribute_translate_text =>
      'I-Open Food Facts iwumsebenzi womhlaba wonke, oqukethe imikhiqizo evela emazweni angaphezu kuka-160. I-Open Food Facts ihunyushwa ngezilimi eziningi, ngokuqukethwe okuguquka njalo.';

  @override
  String get contribute_translate_text_2 =>
      'Ukuhumusha kungenye yemisebenzi ebalulekile yalo msebenzi';

  @override
  String get contribute_join_skill_pool =>
      'Nikela amakhono akho ku-Open Food Facts. Joyina ichibi lamakhono!';

  @override
  String get contribute_share_header =>
      'Yabelana Ngamaqiniso Okudla Avulekile nabangani bakho';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Nikela amanani ngokucela ukuthunyelwa kwedatha yamakhadi akho okuthembeka yi-GDPR';

  @override
  String get tap_to_answer => 'Thepha lapha ukuze uphendule imibuzo';

  @override
  String get tap_to_answer_hint =>
      'Thepha lapha ukuze uphendule imibuzo mayelana nalo mkhiqizo';

  @override
  String get robotoff_questions_loading_hint =>
      'Sicela ulinde ngenkathi imibuzo mayelana nalo mkhiqizo ilayishwa';

  @override
  String get saving_answer => 'Ilondoloza impendulo yakho';

  @override
  String get contribute_to_get_rewards => 'Yiba umlingisi wokukhanya kokudla';

  @override
  String get question_sign_in_text =>
      'Ngena ngemvume ku-akhawunti yakho ye-Open Food Facts ukuze uthole ikhredithi ngeminikelo yakho';

  @override
  String get question_yes_button_accessibility_value => 'Phendula ngo-yebo';

  @override
  String get question_no_button_accessibility_value => 'Phendula ngokuthi cha';

  @override
  String get question_skip_button_accessibility_value => 'Yeqa lo mbuzo';

  @override
  String get tap_to_edit_search => 'Thepha ukuze uhlele usesho';

  @override
  String get myPreferences => 'Izintandokazi zami';

  @override
  String get account_create_message =>
      'Dala i-akhawunti yakho bese ujoyina umphakathi we-Open Food Facts ukusiza ekwakheni ulwazi lokudla emhlabeni wonke!';

  @override
  String get join_us => 'Sijoyine';

  @override
  String get myPreferences_profile_title => 'Iphrofayela Yakho';

  @override
  String get myPreferences_profile_subtitle =>
      'Phatha i-akhawunti yakho yomnikeli we-Open Food Facts.';

  @override
  String get myPreferences_settings_title =>
      'Izilungiselelo zohlelo lokusebenza';

  @override
  String get myPreferences_settings_subtitle => 'Imodi emnyama, Izilimi…';

  @override
  String get myPreferences_food_title => 'Izintandokazi Zokudla';

  @override
  String get myPreferences_food_subtitle =>
      'Khetha ukuthi yiluphi ulwazi mayelana nokudla olubaluleke kakhulu kuwe.';

  @override
  String get myPreferences_food_comment =>
      'Khetha ukuthi yiluphi ulwazi mayelana nokudla olubaluleke kakhulu kuwe, ukuze uhlele ukudla ngokwezintandokazi zakho, ubone ulwazi olukhathalelayo kuqala, bese uthola isifinyezo sokuhambisana. Lezo zintandokazi zokudla zihlala kudivayisi yakho, futhi azihlotshaniswa ne-akhawunti yakho yomnikeli we-Open Food Facts uma unayo.';

  @override
  String get confirmResetPreferences =>
      'Setha kabusha izintandokazi zakho zokudla?';

  @override
  String get myPersonalizedRanking => 'Izinga lami elenziwe ngezifiso';

  @override
  String get ranking_tab_all => 'All';

  @override
  String get ranking_subtitle_match_yes => 'Umdlalo omuhle kakhulu kuwe';

  @override
  String get ranking_subtitle_match_no => 'Ukufana okubi kakhulu';

  @override
  String get ranking_subtitle_match_maybe => 'Ukufana okungaziwa';

  @override
  String get refresh_with_new_preferences =>
      'Vuselela uhlu ngezintandokazi zakho ezintsha';

  @override
  String get reloaded_with_new_preferences =>
      'Kulayishwe kabusha ngezintandokazi zakho ezintsha';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Skena';

  @override
  String get history_navbar_label => 'Umlando';

  @override
  String get list_navbar_label => 'Uhlu';

  @override
  String get category => 'Hlunga ngesigaba';

  @override
  String get category_all => 'All';

  @override
  String get category_search => '(ukusesha kwesigaba)';

  @override
  String get filter => 'Hlunga';

  @override
  String get scan => 'Imikhiqizo evela esikrinini sokuskena';

  @override
  String get scan_history => 'Umlando wokuskena';

  @override
  String get search => 'Sesha';

  @override
  String get search_product_help =>
      'Sesha umkhiqizo,\numkhiqizo noma ibhakhodi';

  @override
  String get search_filter => 'Sesha isihlungi';

  @override
  String get search_history => 'Umlando wosesho';

  @override
  String get search_store => 'Sesha isitolo';

  @override
  String get search_store_help => 'Ukusikisela: engeza idolobha noma izwe';

  @override
  String get tap_for_more => 'Thepha ukuze ubone ulwazi olwengeziwe…';

  @override
  String get product => 'Product';

  @override
  String get unknownBrand => 'Umkhiqizo ongaziwa';

  @override
  String get unknownQuantity => 'Inani elingaziwa';

  @override
  String get unknownProductName => 'Igama lomkhiqizo elingaziwa';

  @override
  String get label_refresh => 'Refresh';

  @override
  String get label_reload => 'Layisha kabusha';

  @override
  String get image => 'Isithombe';

  @override
  String get front_photo => 'Isithombe sangaphambili';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (lesi sithombe kungenzeka siphelelwe yisikhathi)';
  }

  @override
  String get outdated_image_short_label =>
      'kungenzeka ukuthi isiphelelwe yisikhathi';

  @override
  String get ingredients => 'Ingredients';

  @override
  String get ingredients_editing_instructions =>
      'Gcina uhlelo lokuqala. Khombisa iphesenti uma lishiwo. Hlukanisa nge-comma noma i-hyphen bese usebenzisa ama-bracket ezithako zesithako.';

  @override
  String get ingredients_editing_error => 'Yehlulekile ukulondoloza izithako.';

  @override
  String get ingredients_editing_image_error =>
      'Yehlulekile ukuthola isithombe esisha sezithako.';

  @override
  String get ingredients_editing_title => 'Hlela Izithako';

  @override
  String get ingredients_photo => 'Isithombe sezithako';

  @override
  String get packaging_editing_instructions =>
      'Bhala zonke izingxenye zokupakisha ezihlukaniswe yi-comma noma i-line feed, ngenani lazo (isb. 1 noma 6) uhlobo (isb. ibhodlela, ibhokisi, ithini), izinto (isb. ipulasitiki, insimbi, i-aluminium) kanye nosayizi wazo uma ukhona (isb. 33cl) kanye nemiyalelo yokuvuselela.\nIsibonelo: Ibhodlela elilodwa lengilazi lokuvuselela, i-cork elilodwa lepulasitiki lokulahla';

  @override
  String get packaging_editing_error => 'Yehlulekile ukulondoloza iphakheji.';

  @override
  String get packaging_editing_image_error =>
      'Yehlulekile ukuthola isithombe esisha sokupakisha.';

  @override
  String get packaging_editing_title => 'Hlela Ukupakisha';

  @override
  String get nutrition => 'Ukudla okunempilo';

  @override
  String get nutrition_facts_photo => 'Isithombe samaqiniso okudla okunempilo';

  @override
  String get nutrition_facts_editing_title =>
      'Hlela Amaqiniso Okudla Okunomsoco';

  @override
  String get packaging_information => 'Imiyalelo yokusebenzisa kabusha';

  @override
  String get packaging_information_photo =>
      'Isithombe semiyalelo yokusebenzisa kabusha';

  @override
  String get missing_product => 'Uthole umkhiqizo omusha!';

  @override
  String get add_product_take_photos =>
      'Thatha izithombe zephakheji ukuze ungeze lo mkhiqizo ku-Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Sicela uthathe izithombe kuqala. Ungawuqeda umkhiqizo ngokuhamba kwesikhathi.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'Umkhiqizo Omusha';

  @override
  String get new_product_found_title => 'Kutholakale umkhiqizo omusha!';

  @override
  String get new_product_found_text =>
      'Isizindalwazi sethu sokubambisana siqukethe imikhiqizo engaphezu kwezigidi ezintathu**, kodwa le khodi ayikho: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'Shiya leli khasi?';

  @override
  String get new_product_leave_message =>
      'Kubonakala sengathi awufakanga lutho. Ingabe ufuna ngempela ukushiya leli khasi?';

  @override
  String get new_product_dialog_description =>
      'Sicela uthathe izithombe zephakheji ukuze ungeze lo mkhiqizo kusizindalwazi sethu esivamile';

  @override
  String get new_product_dialog_illustration_description =>
      'Umfanekiso one-Nutri-Score engaziwa kanye ne-Green Score';

  @override
  String get front_packaging_photo_button_label =>
      'Isithombe sokupakisha esingaphambili';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Qinisekisa ukulayishwa kwesithombe sokupakisha sangaphambili';

  @override
  String get confirm_button_label => 'Qinisekisa';

  @override
  String get send_image_button_label => 'Thumela isithombe';

  @override
  String get crop_page_action_saving => 'Ukulondoloza isithombe…';

  @override
  String get crop_page_action_cropping => 'Ukunqamula isithombe…';

  @override
  String get crop_page_action_local => 'Ilondoloza inguqulo yendawo…';

  @override
  String get crop_page_action_local_failed_title =>
      'Hawu… kukhona okuthile ngesithombe sakho!';

  @override
  String get crop_page_action_local_failed_message =>
      'Asikwazi ukucubungula isithombe endaweni, ngaphambi kokusithumela kuseva yethu. Sicela uzame futhi kamuva noma usithinte uma inkinga iqhubeka.';

  @override
  String get crop_page_action_retake => 'Thatha isithombe kabusha';

  @override
  String get crop_page_too_small_image_title => 'Isithombe sincane kakhulu!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Usayizi omncane wamaphikseli wokulayisha isithombe ngu- ${expectedMinWidth}x$expectedMinHeight. Isithombe samanje ngu- ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Ukulungiselela ucingo oluya kuseva…';

  @override
  String get front_packaging_photo_title => 'Isithombe Sokupakisha Ngaphambili';

  @override
  String get ingredients_photo_title => 'Izithako Isithombe';

  @override
  String get nutritional_facts_photo_title =>
      'Isithombe Semininingwane Yokudla Okunempilo';

  @override
  String get recycling_photo_title =>
      'Imiyalelo yokusebenzisa kabusha Isithombe';

  @override
  String get take_photo_title => 'Take a picture';

  @override
  String get take_more_photo_title => 'Take more photos';

  @override
  String get front_photo_uploaded => 'Isithombe sangaphambili silayishiwe';

  @override
  String get ingredients_photo_button_label => 'Isithombe sezithako';

  @override
  String get ingredients_photo_uploaded => 'Izithako isithombe silayishiwe';

  @override
  String get nutrition_cache_loading_error =>
      'Ayikwazi ukulayisha izakhamzimba kusuka kunqolobane';

  @override
  String get nutritional_facts_photo_button_label =>
      'Isithombe samaqiniso okudla okunempilo';

  @override
  String get nutritional_facts_input_button_label =>
      'Gcwalisa amaqiniso okudla okunempilo';

  @override
  String get nutritional_facts_added => 'Amaqiniso okudla okunempilo angeziwe';

  @override
  String get categories_added => 'Izigaba zengeziwe';

  @override
  String get new_product_title_nutriscore => 'Bala i-Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Sisize ngokugcwalisa okungenani isigaba kanye nezindinganiso zokudla okunempilo';

  @override
  String get new_product_title_environmental_score => 'Bala i-Green Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Yithole ngokugcwalisa okungenani isigaba';

  @override
  String get new_product_additional_environmental_score =>
      'Yenza ukubalwa kwe-Green Score kube okunembe kakhudlwana ngemvelaphi, ukupakishwa nokuningi';

  @override
  String get new_product_title_nova =>
      'Bala izinga lokucubungula ukudla (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Yithole ngokugcwalisa isigaba sokudla kanye nezithako';

  @override
  String get new_product_desc_nova_unknown =>
      'Izinga lokucubungula ukudla alaziwa';

  @override
  String get new_product_title_pictures => 'Umkhiqizo omusha';

  @override
  String get new_product_title_pictures_details =>
      'Sicela uthathe izithombe ezilandelayo bese injini ye-Open Food Facts izokwazi ukuthola okunye!';

  @override
  String get new_product_title_misc => 'Futhi idatha eyisisekelo ethile…';

  @override
  String new_product_done_msg(String username) {
    return 'Ngiyabonga ngegalelo lakho “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Ngiyabonga ngomnikelo wakho!';

  @override
  String get new_product_done_button_label => 'Thola umkhiqizo oqediwe';

  @override
  String get hey_incomplete_product_message =>
      'Thepha ukuze uphendule imibuzo emi-3 MANJE ukuze ubale i-Nutri-Score, i-Green Score kanye ne-Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Thepha manje ukuze uphendule imibuzo emi-2 ukusiza ekuhlaziyeni lesi sithako sobuhle!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Thepha manje ukuze uphendule imibuzo emi-3 ukusiza ekuhlaziyeni lo mkhiqizo wokudla kwezilwane ezifuywayo!';

  @override
  String get hey_incomplete_product_message_product =>
      'Thepha manje ukuze usize ekuqedeni lo mkhiqizo!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Isithombe samaqiniso okudla okunempilo silayishiwe';

  @override
  String get recycling_photo_button_label => 'Isithombe sokuvuselela kabusha';

  @override
  String get recycling_photo_uploaded =>
      'Isithombe sokuphinda sisetshenziswe silayishiwe';

  @override
  String get take_more_photo_button_label => 'Take more photos';

  @override
  String get other_photo_uploaded => 'Isithombe esixubile silayishiwe';

  @override
  String get retake_photo_button_label => 'Phinda uthathe';

  @override
  String get selecting_photo => 'Ukukhetha isithombe';

  @override
  String get uploading_image => 'Ukulayisha isithombe kuseva';

  @override
  String get uploading_image_type_front =>
      'Kulayishwa isithombe sangaphambili ku-Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Kulayishwa isithombe sezithako ku-Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Kulayishwa isithombe sokudla okunempilo ku-Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Kulayishwa isithombe sokupakisha ku-Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Kulayishwa esinye isithombe ku-Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Kulayishwa isithombe ku-Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Engeza izithako ezingekho';

  @override
  String get score_add_missing_packaging_image =>
      'Engeza isithombe sokupakisha esingekho';

  @override
  String get score_add_missing_nutrition_facts =>
      'Engeza amaqiniso okudla okunempilo angekho';

  @override
  String get score_add_missing_product_traces =>
      'Engeza ama-trace omkhiqizo angekho';

  @override
  String get score_add_missing_product_category => 'Khetha isigaba';

  @override
  String get score_add_missing_precise_product_category =>
      'Khetha isigaba esinembe kakhudlwana';

  @override
  String get score_add_missing_product_countries =>
      'Engeza amazwe omkhiqizo angekho';

  @override
  String get score_add_missing_product_emb =>
      'Engeza amakhodi okulandelela umkhiqizo angekho';

  @override
  String get score_add_missing_product_labels =>
      'Engeza amalebula omkhiqizo angekho';

  @override
  String get score_add_missing_product_origins =>
      'Engeza imvelaphi yomkhiqizo engekho';

  @override
  String get score_add_missing_product_stores =>
      'Engeza izitolo zemikhiqizo ezingekho';

  @override
  String get score_add_missing_product_brands =>
      'Engeza imikhiqizo yemikhiqizo engekho';

  @override
  String get score_update_nutrition_facts =>
      'Buyekeza amaqiniso okudla okunempilo';

  @override
  String get nutrition_page_title => 'Amaqiniso Okudla Okunomsoco';

  @override
  String get nutrition_page_nutritional_info_title =>
      'Ulwazi lokudla okunempilo';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Amanani achazwe kumkhiqizo:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Yes';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'No';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Vula isithombe';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Imikhuba emihle: Ulwazi lokudla okunempilo';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Ngezinye izikhathi amaqiniso okudla okunempilo awacaciswanga ephaketheni** noma kudokhumenti enikezwe nomkhiqizo. Kulesi simo, futhi kuphela kulesi simo, ungafaka inani ku-**CHA**.';

  @override
  String get nutrition_page_serving_type_label => 'Amanani okudla okunempilo:';

  @override
  String get nutrition_page_per_100g => 'ngamagremu ayi-100';

  @override
  String get nutrition_page_per_100g_100ml => 'ngo-100g/ml';

  @override
  String get nutrition_page_per_serving => 'ngokukhonza ngakunye';

  @override
  String get nutrition_page_add_nutrient => 'Engeza isondlo';

  @override
  String get nutrition_page_serving_size => 'Usayizi wokukhonza';

  @override
  String get nutrition_page_serving_size_hint =>
      'Faka usayizi wokukhonza (isb: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Imikhuba emihle: Usayizi wokukhonza';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Leli nani lisiza ukwenza ukubala okulinganayo kwezakhamzimba ngasinye ngosayizi wokukhonza**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Amayunithi avunyelwe** yilawa: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 公斤, 毫嬍, 公斤, 毫嬍, 公斤, 毫嬍, 公嬍, 公嬍, 公嬍,';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** noma **60 G** (khetha eyokuqala)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** noma **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Iyunithi engavumelekile';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Amayunithi angavumelekile';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      'Amaswidi ayi-9 ** namabhisikidi amabili **';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Iyunithi engekho';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Inombolo engavumelekile';

  @override
  String get nutrition_page_update_running => 'Ukubuyekeza umkhiqizo kuseva…';

  @override
  String get nutrition_page_update_done => 'Umkhiqizo ubuyekeziwe!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Sebenzisa inani lomkhiqizo njengosayizi wokuphakelwa';

  @override
  String get nutrition_page_photo_error => 'Ayikwazi ukulayisha isithombe';

  @override
  String get more_photos => 'Izithombe ezithakazelisa kakhulu';

  @override
  String get view_more_photo_button =>
      'Buka zonke izithombe ezikhona zalo mkhiqizo';

  @override
  String get no_product_found => 'Akukho mkhiqizo otholiwe';

  @override
  String get no_location_found => 'Akukho ndawo etholakele';

  @override
  String get not_found => 'akutholakalanga:';

  @override
  String get refreshing_product => 'Umkhiqizo ovuselelayo';

  @override
  String get product_refreshed => 'Umkhiqizo uvuselelwe';

  @override
  String product_image_accessibility_label(String date) {
    return 'Isithombe sithathwe ku- $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Isithombe sithathwe ku- $date. Lesi sithombe kungenzeka siphelelwe yisikhathi';
  }

  @override
  String get product_image_outdated =>
      'Lesi sithombe kungenzeka siphelelwe yisikhathi';

  @override
  String get product_image_outdated_explanations_title =>
      'Lesi sithombe kungenzeka siphelelwe yisikhathi';

  @override
  String get product_image_outdated_explanations_content =>
      'Lesi sithombe sithathwe isikhathi esingaphezu konyaka odlule.\n**Sicela uhlole ukuthi sisasesikhathini**.\n\nLokhu kumane nje kuyisilumkiso**. Uma okuqukethwe kusafana, ungawushaya indiva lo mlayezo.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Shintsha isithombe ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Engeza isithombe ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Take a picture';

  @override
  String get product_image_action_from_gallery =>
      'Khetha kugalari yefoni yakho';

  @override
  String get product_image_action_choose_existing_photo =>
      'Khetha ezithombeni zomkhiqizo';

  @override
  String get product_image_details_label => 'Ulwazi mayelana nesithombe';

  @override
  String get product_image_details_from_producer => 'Kusuka kumkhiqizi';

  @override
  String get product_image_details_contributor => 'Contributor';

  @override
  String get product_image_details_contributor_producer =>
      'Umnikeli (umkhiqizi)';

  @override
  String get product_image_details_date => 'Usuku';

  @override
  String get product_image_details_date_unknown => 'Akwaziwa';

  @override
  String get homepage_main_card_logo_description =>
      'Siyakwamukela ku-Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Skena** ibhakhodi noma\n**sesha** umkhiqizo';

  @override
  String get homepage_main_card_search_field_hint => 'Sesha umkhiqizo';

  @override
  String get homepage_main_card_search_field_tooltip => 'Qala usesho';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Izindaba zakamuva: $news_title';
  }

  @override
  String get tagline_app_review => 'Uyayithanda yini uhlelo lokusebenza?';

  @override
  String get tagline_app_review_button_positive => 'Ngiyakuthanda! 😍';

  @override
  String get tagline_app_review_button_negative => 'Akuyona ngempela…';

  @override
  String get tagline_app_review_button_later => 'Ngibuze kamuva';

  @override
  String get tagline_feed_news_button => 'Yazi okwengeziwe';

  @override
  String get app_review_negative_modal_title =>
      'Awuwuthandi uhlelo lwethu lokusebenza?';

  @override
  String get app_review_negative_modal_text =>
      'Ungathatha imizuzwana embalwa usitshele ukuthi kungani?';

  @override
  String get app_review_negative_modal_positive_button => 'Yebo, impela!';

  @override
  String get app_review_negative_modal_negative_button => 'No';

  @override
  String get could_not_refresh => 'Ayikwazanga ukuvuselela umkhiqizo';

  @override
  String get product_internet_error_modal_title => 'Kuvele iphutha!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Asikwazi ukulanda ulwazi mayelana nalo mkhiqizo ngenxa yephutha lenethiwekhi. Sicela uhlole uxhumano lwakho lwe-inthanethi bese uzama futhi.\n\nIphutha langaphakathi:\n$error';
  }

  @override
  String get product_tags_title => 'Izakhiwo zomkhiqizo';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Azikho izakhiwo';

  @override
  String get product_tags_explanation =>
      'Ngokungeza izakhiwo (ukhiye/inani) emkhiqizweni, usiza ukuwucebisa.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Engeza izakhiwo';

  @override
  String get add_edit_tags => 'Engeza noma hlela izakhiwo';

  @override
  String get edit_tag => 'Hlela impahla';

  @override
  String get remove_tag => 'Susa impahla';

  @override
  String get tag_key => 'Impahla';

  @override
  String get tag_keys => 'Izakhiwo';

  @override
  String get tag_key_uneditable => 'Impahla (ayihleleki)';

  @override
  String get tag_key_input_hint => 'Faka isici';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Faka inani';

  @override
  String get tag_key_item => 'Impahla:';

  @override
  String get tag_value_item => 'Inani:';

  @override
  String get tag_key_explanations =>
      'Ukhiye kumele ube ngosonhlamvukazi abancane futhi ungabi nezikhala.';

  @override
  String tag_key_already_exists(String property) {
    return 'Ithegi enesici $property isivele ikhona!';
  }

  @override
  String get product_internet_error =>
      'Akunakwenzeka ukulanda ulwazi mayelana nalo mkhiqizo ngenxa yephutha lenethiwekhi.';

  @override
  String get cached_results_from => 'Bonisa imiphumela evela ku:';

  @override
  String get product_search_same_category => 'Thola ezinye izindlela';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'Lesi sici singasetshenziswa kuphela emikhiqizweni enesigaba.\n\nSicela uhlele umkhiqizo ukuze ungeze isigaba.';

  @override
  String get product_improvement_add_category =>
      'Engeza isigaba ukuze ubale i-Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Engeza amaqiniso okudla okunempilo ukuze ubale i-Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Engeza amaqiniso okudla okunempilo kanye nesigaba ukuze ubale i-Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'I-Nutri-Score yalo mkhiqizo ayikwazi ukubalwa, okungase kubangelwe isibonelo isigaba esingejwayelekile. Uma lokhu kubhekwa njengephutha, sicela uxhumane nathi.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Isithombe sokudla okunempilo asisasebenzi: sicela usivuselele.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'I-Green Score icabangela imvelaphi yezithako. Sicela uthathe isithombe sohlu lwezithako kanye/noma noma yisiphi isimangalo sendawo noma uhlele umkhiqizo, ukuze zicatshangelwe.';

  @override
  String get country_chooser_label => 'Sicela ukhethe izwe';

  @override
  String get currency_chooser_label => 'Sicela ukhethe uhlobo lwemali';

  @override
  String get country_change_message => 'Usanda kushintsha amazwe.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Ingabe ufuna ukushintsha imali kusuka ku- $previousCurrency kuya ku- $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Sicela ukhethe izwe:';

  @override
  String get country_chooser_label_from_settings => 'Izwe lakini';

  @override
  String get country_selection_explanation =>
      'Ezinye izici zemvelo ziqondene nendawo ethile';

  @override
  String get product_removed_comparison => 'Umkhiqizo ususiwe ekuqhathanisweni';

  @override
  String get native_app_settings =>
      'Izilungiselelo Zohlelo Lokusebenza Lwendabuko';

  @override
  String get native_app_description =>
      'Vula izilungiselelo zezinhlelo ze-Open Food Facts';

  @override
  String get product_removed_history => 'Umkhiqizo ususiwe emlandweni';

  @override
  String get product_removed_list => 'Umkhiqizo ususiwe ohlwini';

  @override
  String get product_could_not_remove => 'Ayikwazanga ukususa umkhiqizo';

  @override
  String get no_prodcut_in_list => 'Akukho mkhiqizo kulolu hlu';

  @override
  String get no_product_in_section => 'Akukho mkhiqizo kulesi sigaba';

  @override
  String get recently_seen_products => 'Yonke imikhiqizo ebukiwe';

  @override
  String get clear => 'Sula';

  @override
  String get clear_long => 'Sula uhlu';

  @override
  String get really_clear => 'Ingabe ufuna ngempela ukususa lolu hlu?';

  @override
  String pct_match(Object percent) {
    return '$percent% ukufana';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count izinsuku ezedlule',
      one: 'ngosuku olulodwa olwedlule',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count amahora adlule',
      one: 'ihora elilodwa eledlule',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count imizuzu edlule',
      one: 'umzuzu owodwa odlule',
      zero: 'kungakapheli umzuzu odlule',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count izinyanga ezedlule',
      one: 'inyanga eyodwa edlule',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count amasonto adlule',
      one: 'isonto eledlule',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Qhathanisa $count Imikhiqizo',
      one: 'Qhathanisa Umkhiqizo owodwa',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count imikhiqizo ekhethiwe',
      one: 'Umkhiqizo owodwa okhethiwe',
      zero: 'Akukho mkhiqizo okhethiwe',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Qhathanisa imikhiqizo ekhethiwe';

  @override
  String get delete_products_mode => 'Susa imikhiqizo ekhethiwe';

  @override
  String get select_all_products_mode => 'Khetha yonke imikhiqizo';

  @override
  String get select_none_products_mode => 'Khetha lutho';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle =>
      'Sicela ukhethe okungenani imikhiqizo emibili';

  @override
  String get retry_button_label => 'Zama futhi';

  @override
  String get connect_with_us => 'Xhumana nathi';

  @override
  String get tiktok => 'Silandele ku-TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Silandele ku-Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Silandele ku-X (okwakuyi-Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Silandele ku-Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Silandele ku-BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Ibhulogi';

  @override
  String get faq => 'Imibuzo Evame Ukubuzwa';

  @override
  String get discover => 'Discover';

  @override
  String get how_to_contribute => 'Indlela Yokunikela';

  @override
  String get hint_knowledge_panel_message =>
      'Ungathinta noma iyiphi ingxenye yekhadi ukuze uthole imininingwane eyengeziwe ngalokho okubonayo. Zama manje!';

  @override
  String get permissions_page_title => 'Ukufinyelela kwekhamera';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'Uma ushintsha umqondo wakho, le nketho ingavulwa futhi ikhutshazwe nganoma yisiphi isikhathi kusukela kuzilungiselelo.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'I-OS: I-Android (SDK Int: $sdkInt / Ukukhishwa: $release)\nImodeli: $model\nUmkhiqizo: $product\nIdivayisi: $device\nUmkhiqizo:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'I-OS: iOS ($version)\nImodeli: $model\nImodeli yendawo: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nInguqulo yohlelo lokusebenza:$appVersion\nInombolo yokwakha uhlelo lokusebenza:$appBuildNumber\nIgama lephakheji yohlelo lokusebenza:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'Ukulahla';

  @override
  String get ask_me_later_button_label => 'Kamuva';

  @override
  String get are_you_sure => 'Uqinisekile?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Qhubeka ku- $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Siyakwamukela!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Uhlelo lokusebenza olukusiza ukuthi ukhethe ukudla okuhle kuwe kanye nomhlaba wonke!';

  @override
  String get onboarding_continue_button => 'Qhubeka';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Ilayisha umkhiqizo wakho wesibonelo sokuqala';

  @override
  String get onboarding_welcome_warning =>
      'Uxolo, umkhiqizo wethu oyisibonelo, awukwazi ukuwuhlela :)';

  @override
  String get product_list_your_ranking => 'Izinga lakho';

  @override
  String get product_list_empty_icon_desc => 'Umlando awutholakali';

  @override
  String get product_list_empty_title => 'Qala ukuskena';

  @override
  String get product_list_empty_message =>
      'Imikhiqizo eskeniwe izovela lapha futhi ungahlola ulwazi oluningiliziwe ngayo';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'imikhiqizo',
      one: 'umkhiqizo',
      zero: 'umkhiqizo',
    );
    return 'Kuyavuselela $_temp0 emlandweni wakho';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Imikhiqizo',
      one: 'Umkhiqizo',
      zero: 'Umkhiqizo',
    );
    return '$_temp0 ukuvuselela kuqediwe';
  }

  @override
  String get product_list_compare_side_by_side => 'Qhathanisa izinhlangothi';

  @override
  String get loading_dialog_default_title => 'Ukulanda idatha';

  @override
  String get loading_dialog_default_error_message =>
      'Ayikwazanga ukulanda idatha';

  @override
  String get account_delete => 'Susa i-akhawunti';

  @override
  String get account_delete_title => 'Susa i-akhawunti yami';

  @override
  String get user_profile => 'I-akhawunti';

  @override
  String get user_profile_title_guest => 'Siyakwamukela!';

  @override
  String get user_profile_subtitle_guest =>
      'Ngena ngemvume noma ubhalise ukuze ujoyine umphakathi we-Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Vula i-Food Facts ungene ngemvume: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Siyakwamukela $id!';
  }

  @override
  String get email_subject_account_deletion => 'Susa i-akhawunti';

  @override
  String email_body_account_deletion(String userId) {
    return 'Sawubona, ngicela ususe i-akhawunti yami ye-Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Isicelo';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'Ikhamera';

  @override
  String get settings_app_products => 'Imikhiqizo';

  @override
  String get settings_app_miscellaneous => 'Okuhlukahlukene';

  @override
  String get camera_play_sound_title => 'Dlala umsindo ekuskeni';

  @override
  String get camera_play_sound_subtitle =>
      'Kuzokhala njalo lapho kuskenwa okuphumelelayo';

  @override
  String get camera_window_accessibility_label =>
      'Skena ibhakhodi ngekhamera yakho';

  @override
  String get app_haptic_feedback_title => 'Ukudlidliza kanye nama-Haptic';

  @override
  String get app_haptic_feedback_subtitle =>
      'Ukudlidliza ngemva kokwenza ezinye izenzo (ikhodi yebha isusiwe, umkhiqizo ususiwe…).';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Uma ivuliwe, imibiko yokuphahlazeka ithunyelwa ngokuzenzakalelayo ohlelweni lokulandelela amaphutha lwe-Open Food Facts, ukuze kulungiswe amaphutha ngaleyo ndlela kuthuthukiswe uhlelo lokusebenza.';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Hlela Isithombe';

  @override
  String get permission_photo_error => 'Iphutha';

  @override
  String get permission_photo_denied_title =>
      'Vumela ukusetshenziswa kwekhamera ukuskena amabhakhodi';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Ukuze uthole ulwazi oluthuthukisiwe, sicela uvumele $appName ukuthi ifinyelele ikhamera yakho. Uzokwazi ukuskena amabhakhodi ngqo.';
  }

  @override
  String get permission_photo_denied_button => 'Vumela';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Imvume inqatshelwe';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Njengoba uke wenqaba imvume yekhamera ngaphambilini, kufanele uyivumele ngesandla kusuka kuzilungiselelo.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Open Settings';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Cancel';

  @override
  String get permission_photo_none_found => 'Akukho khamera etholiwe';

  @override
  String get permission_photo_denied =>
      'Akukho ukufinyelela kwekhamera okuvunyelwe';

  @override
  String get show_product_pictures => 'Bonisa izithombe zomkhiqizo';

  @override
  String get edit_product_label => 'Hlela umkhiqizo';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Ukulayisha ukuhlela kwakho…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Ukuhlela kwakho kuyathunyelwa **ngemuva** (noma kamuva uma kwenzeka iphutha).\nUngaqhubeka nokuhlela ezinye izinkambu zomkhiqizo.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Ukuhlela kwakho kuthunyelwa **ngemuva** (noma kamuva uma kwenzeka iphutha).';

  @override
  String get edit_product_label_short => 'Edit';

  @override
  String edit_product_form_item_help(String value) {
    return 'Ungayifaka kanjani i-\"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Sicela ufake inani elingenalutho!';

  @override
  String get edit_product_form_item_error_existing =>
      'Leli nani selivele likhona!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Engeza umkhiqizo omusha';

  @override
  String get edit_product_form_item_add_action_label => 'Engeza ilebula elisha';

  @override
  String get edit_product_form_item_add_action_store => 'Engeza isitolo esisha';

  @override
  String get edit_product_form_item_add_action_origin => 'Engeza umsuka omusha';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Engeza ikhodi entsha yokulandelela';

  @override
  String get edit_product_form_item_add_action_country => 'Engeza izwe elisha';

  @override
  String get edit_product_form_item_add_action_category =>
      'Engeza isigaba esisha';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Engeza umkhondo omusha';

  @override
  String get edit_product_form_item_add_suggestion => 'Engeza isiphakamiso';

  @override
  String get edit_product_form_item_deny_suggestion => 'Yenqaba isiphakamiso';

  @override
  String get edit_product_form_item_details_title =>
      'Imininingwane eyisisekelo';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Igama lomkhiqizo, uhlobo, inani';

  @override
  String get edit_product_form_item_other_details_title =>
      'Imininingwane eyengeziwe';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Iwebhusayithi…';

  @override
  String get edit_product_form_item_photos_title => 'Izithombe';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Engeza noma uvuselele izithombe';

  @override
  String get edit_product_form_item_labels_title =>
      'Amalebula kanye Nezitifiketi';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Amalebula Ezemvelo, Ekhwalithi…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Faka ilebula (isb: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Imikhuba Emihle: Amalebula';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Noma yisiphi isici somkhiqizo **esiyiqiniso** futhi esihlukile kwezinye izinkambu.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'I-Nutri-Score, i-NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Kwenziwe eBelgium, kwakhiqizwa eBrittany…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Icebile ngefayibha, umthombo wensimbi…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Ukuhweba okulungile, uMax Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Izitolo';

  @override
  String get edit_product_form_item_stores_hint => 'Faka isitolo';

  @override
  String get edit_product_form_item_stores_type => 'isitolo';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Imikhuba Emihle: Izitolo';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Faka isitolo lapho uthenge khona umkhiqizo.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'I-Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'I-Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'I-Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Imvelaphi';

  @override
  String get edit_product_form_item_origins_hint =>
      'Faka umsuka (isb: iJalimane)';

  @override
  String get edit_product_form_item_origins_type => 'country';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Imikhuba Emihle: Imvelaphi';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Engeza **noma yiziphi izinkomba zemvelaphi ongazithola ephaketheni**.\nAkudingeki ukhathazeke ngemvelaphi ekhonjiswe ngqo ohlwini lwezithako.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Inyama yenkomo evela e-Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Isoya ayiveli e-European Union';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Faka izwe (isb: iJalimane)';

  @override
  String get edit_product_form_item_countries_type => 'country';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Imikhuba Emihle: Amazwe';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Amazwe lapho umkhiqizo utholakala khona kabanzi** (kungabandakanyi izitolo ezigxile emikhiqizweni yangaphandle).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Amakhodi okulandelela';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Faka ikhodi (isb: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'ikhodi yokulandelela';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Imikhuba Emihle: Amakhodi Okulandelela';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Kulesi sigaba, ungafaka amakhodi ahlobene ne-**amamaki okupakisha**, **amamaki okuhlonza** noma **amamaki ezempilo**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Izibonelo zamakhodi okulandelela';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Amakhodi e-EC** asetshenziswa eMphakathini waseYurophu ukuhlonza abakhiqizi bokudla noma abapakishi:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: ikhodi yezwe lase **France**\n**72.264.002**: idatha yendawo\n**CE**: Umphakathi waseYurophu';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Amakhodi e-EMB** asetshenziswa eFrance:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'I-EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Traces';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'Faka umkhondo (isb.: Ubhontshisi besoya)';

  @override
  String get edit_product_form_item_categories_title => 'Categories';

  @override
  String get edit_product_form_item_categories_hint => 'category';

  @override
  String get edit_product_form_item_categories_type =>
      'Faka isigaba (isb: Ijusi lewolintshi)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Imikhuba Emihle: Izigaba';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Khombisa **isigaba esiqondile kakhulu** kuphela.\nIzigaba zabazali zizongezwa ngokuzenzakalelayo.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Isigaba esingekho?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Uma isigaba singatholakali ngokuqedela okuzenzakalelayo**, zizwe ukhululekile ukusifaka noma kunjalo.\nLokhu kuzosisiza sithuthukise amaqiniso okudla avulekile ezweni lakini.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Ama-sardine emafutheni omnqumo';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Ijusi le-orange elivela ku-concentrate';

  @override
  String get edit_product_form_item_exit_title =>
      'Yeka ngaphandle kokulondoloza?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Ingabe ufuna ukulondoloza izinguquko zakho ngaphambi kokushiya leli khasi?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Londoloza izinguquko';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Lahla izinguquko';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredients';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Sondeza futhi uhlehlise isithombe-skrini ngokucindezela';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Sondeza isithombe bese usisondeza';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Usebenzisa isenzo se-**Pinch-to-zoom**, ungasondeza noma ususe isithombe:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Engeza';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Sicela ufake umbhalo kuqala';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Susa';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Londoloza ukuhlela kwakho';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Khansela ukuhlela kwakho';

  @override
  String get edit_product_form_item_packaging_title =>
      'Isithombe semiyalelo yokusebenzisa kabusha';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Amaqiniso okudla okunempilo';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Ukudla okunempilo, okuqukethwe utshwala…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Imikhuba Emihle: Amaqiniso Okudla Okunomsoco';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Amanani okudla okunempilo';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Okokuqala, khetha ukuthi amanani **anikeziwe**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Amaqiniso okudla okunempilo';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Bese ufaka amanani okudla okunempilo **njengoba kuboniswe ephaketheni**. Uma kungekho nzuzo, ungachofoza isithonjana esithi \"Iso\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Inkambu engekho?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Uma kukhona okufakiwe okungekho, ungachofoza kusithonjana esithi \"Plus\"** ukuze ukungeze (isb: i-vitamin D, i-magnesium…).';

  @override
  String get edit_product_form_save => 'Edit';

  @override
  String get edit_product_ingredients_photo_title => 'Isithombe sezithako';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Isithombe sokupakisha';

  @override
  String get edit_product_packaging_list_title => 'Uhlu lokupakisha';

  @override
  String get no_data_available => 'Ayikho idatha etholakalayo';

  @override
  String get product_field_website_title => 'Iwebhusayithi';

  @override
  String get origins_editing_title => 'Hlela Imvelaphi';

  @override
  String get completed_basic_details_btn_text =>
      'Imininingwane eyisisekelo ephelele';

  @override
  String get not_implemented_snackbar_text => 'Akukaqaliswa okwamanje';

  @override
  String get category_picker_page_appbar_text => 'Categories';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Khipha izithako esithombeni';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Ukukhipha izithako\nesithombeni';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Ilayisha isithombe…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Kungani ngibona lo mlayezo?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Ukuze usebenzise isici esithi \"Khipha izithako\", isithombe sidinga ukulayishwa kuqala.\n\nSicela ulinde imizuzwana embalwa noma uzifake ngesandla.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Vuselela isithombe';

  @override
  String get edit_packaging_extract_btn_text => 'Khipha iphakheji\nesithombeni';

  @override
  String get edit_packaging_extract_btn_text_short => 'Ukupakisha okukhishwe';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Ukukhipha iphakheji esithombeni';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Ilayisha isithombe…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Kungani ngibona lo mlayezo?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Ukuze usebenzise isici esithi \"Extract packaging\", isithombe sidinga ukulayishwa kuqala.\n\nSicela ulinde imizuzwana embalwa noma usifake ngesandla.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Vuselela isithombe';

  @override
  String get edit_ocr_extract_failed =>
      'Yehlulekile ukuthola umbhalo esithombeni.';

  @override
  String get edit_ocr_extract_disabled_title => 'Akukho sithombe!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Ukuze usebenzise isici sokukhipha umbhalo, kufanele uqale uthathe isithombe.';

  @override
  String get user_list_dialog_new_title => 'Uhlu olusha lwemikhiqizo';

  @override
  String get user_list_dialog_rename_title => 'Qamba kabusha uhlu';

  @override
  String get user_list_subtitle_product => 'Uhlu';

  @override
  String get user_list_title => 'Your lists';

  @override
  String get user_list_add_product => 'Engeza umkhiqizo ohlwini lwakho';

  @override
  String get user_list_button_new => 'Dala uhlu olusha';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Engeza ohlwini';

  @override
  String get added_to_list_msg => 'Kungezwe ohlwini';

  @override
  String get user_list_popup_clear => 'Sula umlando wakho';

  @override
  String get user_list_popup_rename => 'Qamba kabusha';

  @override
  String get user_list_name_hint => 'Uhlu lwami';

  @override
  String get user_list_name_error_empty => 'Igama liyimpoqo';

  @override
  String get user_list_name_error_already =>
      'Lelo gama selivele lisetshenzisiwe';

  @override
  String get user_list_name_error_same => 'Lelo igama elifanayo';

  @override
  String get user_list_name_input_hint => 'Igama lohlu';

  @override
  String get try_again => 'Zama futhi';

  @override
  String get there_was_an_error => 'Kube nephutha';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Asikho isigaba esitholiwe se- $items';
  }

  @override
  String get camera_toggle_camera =>
      'Shintsha phakathi kwekhamera yangemuva neyangaphambili';

  @override
  String get camera_toggle_flash => 'VULA noma VALISE i-flash yekhamera';

  @override
  String get camera_enable_flash => 'Nika amandla i-flash';

  @override
  String get camera_disable_flash => 'Khubaza i-flash';

  @override
  String get camera_flash_error_dialog_title => 'Kuvele iphutha!';

  @override
  String get camera_flash_error_dialog_message =>
      'Kuvele iphutha ngesikhathi kushintsha isimo se-flash yakho. Sicela uqinisekise ukuthi i-smartphone yakho ayinalo ithoshi elivuliwe kakade.';

  @override
  String get category_picker_no_category_found_button => 'Emuva';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Chofoza ukuze uvule kusiphequluli sakho noma kuhlelo lokusebenza (uma lufakiwe)';

  @override
  String get dev_preferences_screen_title => 'Imodi ye-DEV';

  @override
  String get dev_preferences_screen_subtitle =>
      'Finyelela izici zokuhlola namathuluzi okuthuthukisa';

  @override
  String get dev_preferences_reset_onboarding_title => 'Qala kabusha ukufaka';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Ngemuva kwalokho kufanele uqale kabusha uhlelo lokusebenza ukuze ulubone futhi.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Shintsha phakathi kwe-openfoodfacts.org (PROD) kanye ne-env yokuhlola';

  @override
  String get dev_preferences_test_environment_title =>
      'Amapharamitha endawo yokuhlola';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'I-URL eyisisekelo ye-env yokuhlolwa kwamanje: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Umphathi wendawo yokuhlola';

  @override
  String get dev_preferences_ml_kit_title => 'Sebenzisa i-ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'bese kufanele uqale kabusha lolu hlelo lokusebenza';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Inkinobho eyengeziwe ekhasini lomkhiqizo';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Hlela izithako ngenkinobho yephaneli yolwazi';

  @override
  String get dev_preferences_export_history_title =>
      'Umlando Wokuthumela Ngaphandle';

  @override
  String get dev_preferences_export_history_progress_error => 'okuhlukile';

  @override
  String get dev_preferences_export_history_progress_found =>
      'umkhiqizo utholiwe';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'umkhiqizo AKUTHOLAKALA';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Umlando wokuthumela ngaphandle';

  @override
  String get dev_preferences_button_positive => 'KULUNGILE';

  @override
  String get dev_preferences_button_negative => 'Cancel';

  @override
  String get dev_preferences_migration_title =>
      'Ukufuduka kwedatha kusuka ku-V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Isimo: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'impumelelo noma ukufakwa okusha';

  @override
  String get dev_preferences_migration_status_success => 'impumelelo';

  @override
  String get dev_preferences_migration_status_error => 'iphutha';

  @override
  String get dev_preferences_migration_status_in_progress => 'Kuyaqhubeka';

  @override
  String get dev_preferences_migration_status_required =>
      'kuyadingeka (chofoza ukuze uqale)';

  @override
  String get dev_preferences_migration_status_not_started => 'ayaziwa';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Ngizosula umlando bese ngifaka imikhiqizo emi-3 lapho';

  @override
  String get dev_preferences_news_custom_url_title =>
      'I-URL yangokwezifiso yezindaba';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'I-URL yefayela le-JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Akusethiwe';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Ukuvuselelwa kokugcina: $date';
  }

  @override
  String get product_type_label_food => 'Ukudla';

  @override
  String get product_type_label_beauty => 'Ukunakekelwa komuntu siqu';

  @override
  String get product_type_label_pet_food => 'Ukudla kwezilwane ezifuywayo';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'Uhlobo lomkhiqizo';

  @override
  String get product_type_selection_subtitle => 'Khetha uhlobo lwalo mkhiqizo';

  @override
  String get product_type_selection_empty =>
      'Udinga ukukhetha uhlobo lomkhiqizo kuqala!';

  @override
  String product_type_selection_already(String productType) {
    return 'Awukwazi ukushintsha uhlobo lomkhiqizo ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Uhlelo lokusebenza lwesinqamuleli samanani ekhasini lomkhiqizo';

  @override
  String get prices_app_button => 'Iya kuhlelo lokusebenza lwe-Prices';

  @override
  String get prices_website_button => 'Vula kuwebhusayithi ye-Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Engeza amathegi entengo ngqo kusuka kugalari';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Uma usuzikhethile izithombe, ngeke ukwazi ukuzihlela!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Vumela umphakathi ukuthi uqinisekise izintengo ezikhishwe yi-AI.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Amathegi Amanani Amaningi';

  @override
  String get prices_bulk_proof_upload_title => 'Ukulayisha Ubufakazi Obuningi';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Ukukhetha amafayela';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Iqala ukulayisha';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Ikopisha ifayela endaweni #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Ilungiselela ukulayisha #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Yehlulekile esithombeni #$index/$count';
  }

  @override
  String get prices_generic_title => 'Amanani';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Engeza $count amanani',
      one: 'Engeza intengo',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Thumela $count amanani',
      one: 'Thumela intengo',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Engeza into';

  @override
  String get prices_add_a_price => 'Engeza intengo';

  @override
  String get prices_add_a_receipt => 'Engeza irisidi';

  @override
  String get prices_add_price_tags => 'Engeza amathegi entengo';

  @override
  String prices_barcode_already(String barcode) {
    return 'Le bhakhodi ($barcode) isivele isohlwini!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'Akukho mkhiqizo okwamanje';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Ngifuna $barcode';
  }

  @override
  String get prices_barcode_enter => 'Faka ikhodi yebha';

  @override
  String get prices_category_enter => 'Into engenabhakhodi';

  @override
  String get prices_per_kilogram => 'Inani ngekhilogremu';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' /kg';

  @override
  String get prices_per_unit_short => ' / iyunithi';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'Ongakukhetha';

  @override
  String get prices_category_error_mandatory => 'Isigaba siyimpoqo';

  @override
  String get prices_barcode_reader_action => 'Isifundi sebhakhodi';

  @override
  String get prices_view_prices => 'Buka amanani';

  @override
  String get prices_list_title => 'Uhlu lwamanani';

  @override
  String get prices_list_count => 'Inombolo yezintengo ezingu-\n';

  @override
  String get prices_list_add_new_price => 'Engeza intengo engu-\nentsha';

  @override
  String get prices_list_empty_title => 'Ayikho intengo okwamanje!';

  @override
  String get prices_list_empty_subtitle =>
      'Iba ngowokuqala ukungeza eyodwa:\nNgokuskena **isiliphu** noma **intengo**!';

  @override
  String get prices_entry_shop_not_found => 'Isitolo esingaziwa';

  @override
  String prices_entry_menu_title(String user) {
    return 'Ukufakwa kwentengo kusuka ku-\"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Buka zonke izintengo zalo mkhiqizo';

  @override
  String get prices_entry_menu_open_proof => 'Buka ubufakazi';

  @override
  String get prices_entry_menu_my_prices => 'Buka ezinye izintengo zami';

  @override
  String get prices_entry_menu_author_prices =>
      'Buka ezinye izintengo ngombhali';

  @override
  String get prices_entry_menu_shop_prices => 'Buka ezinye izintengo esitolo';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count amanani',
      one: 'Intengo eyi-1',
    );
    return '$_temp0 ye $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Konke $count amanani',
      one: 'Intengo eyodwa kuphela',
      zero: 'Akukho ntengo okwamanje',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Amanani akamuva $pageSize (isiyonke: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Intengo: $price / Isitolo: \"$location\" / Kushicilelwe ku- $date ngu- \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Ubufakazi obuvulekile be-\"$user\"';
  }

  @override
  String get prices_open_proof => 'Intengo evulekile ayibonakali';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Konke $count ubufakazi',
      one: 'Ubufakazi obubodwa kuphela',
      zero: 'Abukho ubufakazi okwamanje',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Ubufakazi bamuva $pageSize (isiyonke: $total)';
  }

  @override
  String get prices_users_empty_title => 'Akekho umnikeli okwamanje!';

  @override
  String get prices_users_empty_explanation =>
      'Iba ngowokuqala ukungeza intengo!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Abanikeli abaphezulu $pageSize (isamba: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Asikho isitolo okwamanje!';

  @override
  String get prices_locations_empty_explanation =>
      'Iba ngowokuqala ukungeza intengo!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Izindawo eziphezulu $pageSize (isiyonke: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ubufakazi',
      one: 'Ubufakazi obubodwa',
      zero: 'Akukho bufakazi',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count imikhiqizo',
      one: 'Umkhiqizo owodwa',
      zero: 'Akukho mkhiqizo',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count abasebenzisi',
      one: 'Umsebenzisi oyedwa',
      zero: 'Akekho umsebenzisi',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count amanani',
      one: 'Intengo eyodwa',
      zero: 'Akukho ntengo',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Inani lengezwe ngaphambilini';

  @override
  String get prices_amount_subtitle => 'Inani';

  @override
  String get prices_amount_is_discounted => 'Ingabe inesaphulelo?';

  @override
  String get prices_amount_price_normal => 'Intengo';

  @override
  String get prices_amount_price_discounted => 'Intengo encishisiwe';

  @override
  String get prices_amount_price_not_discounted => 'Intengo yokuqala';

  @override
  String get prices_amount_no_product => 'Umkhiqizo owodwa ulahlekile!';

  @override
  String get prices_amount_price_incorrect => 'Inani elingalungile';

  @override
  String get prices_amount_price_mandatory => 'Inani eliphoqelekile';

  @override
  String get prices_currency_subtitle => 'Uhlobo lwemali';

  @override
  String get prices_date_subtitle => 'Usuku';

  @override
  String get prices_location_subtitle => 'Isitolo';

  @override
  String get prices_location_find => 'Thola isitolo';

  @override
  String get prices_location_mandatory => 'Udinga ukukhetha isitolo!';

  @override
  String get prices_location_search_broader =>
      'Awukwazanga ukuthola lokho obukufuna? Ake sizame ukusesha okubanzi!';

  @override
  String get prices_proof_subtitle => 'Ubufakazi';

  @override
  String get prices_proof_empty_title => 'Abukho ubufakazi okwamanje!';

  @override
  String get prices_proof_empty_explanation =>
      'Qala ngokungeza isithombe **residi** noma **intengo**!';

  @override
  String get prices_proof_find => 'Khetha ubufakazi';

  @override
  String get prices_proof_change => 'Ubufakazi bokushintsha';

  @override
  String get prices_proof_receipt => 'Irisidi';

  @override
  String get prices_proof_price_tag => 'Ithegi yentengo';

  @override
  String get prices_proof_mandatory => 'Udinga ukukhetha ubufakazi!';

  @override
  String get prices_add_validation_error => 'Iphutha lokuqinisekisa';

  @override
  String get prices_privacy_warning_title => 'Isexwayiso sobumfihlo';

  @override
  String get prices_unknown_product => 'Umkhiqizo ongaziwa';

  @override
  String get prices_privacy_warning_main_message =>
      'Amanani **azoba esidlangalaleni**, kanye nesitolo ababhekisela kuso.\n\nLokho kungase kuvumele abantu abaziyo ngegama lakho elingelona iqiniso le-Open Food Facts ukuthi:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Khomba ukuthi uhlala kuyiphi indawo';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Yazi ukuthi uthengani';

  @override
  String get prices_privacy_warning_sub_message =>
      'Uma ukhathazekile ngalokho, sicela ushintshe igama lakho elingelona iqiniso, noma udale i-akhawunti entsha ye-Open Food Facts bese ungena kuhlelo lokusebenza ngayo.';

  @override
  String get i_refuse => 'Ngiyenqaba';

  @override
  String get i_accept => 'Ngiyamukela';

  @override
  String get prices_currency_change_proposal_title => 'Shintsha imali?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Imali yakho yamanje ingu-**$currency**. Ungathanda ukuyishintsha ibe yi-**$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Yebo, sebenzisa $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Cha, gcina $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Kuqediwe';

  @override
  String get dev_mode_section_server => 'Ukucushwa kweseva';

  @override
  String get dev_mode_section_news => 'Ukucushwa komhlinzeki wezindaba';

  @override
  String get dev_mode_section_product_page => 'Ikhasi lomkhiqizo';

  @override
  String get dev_mode_section_ui => 'I-Interface Yomsebenzisi';

  @override
  String get dev_mode_section_experimental_features => 'Izici zokuhlola';

  @override
  String get dev_mode_hide_environmental_score_title => 'Khipha i-Green Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Sebenzisa isihloli sokupela kuzikrini ze-OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Izithako kanye nokupakishwa)';

  @override
  String get dev_mode_reset_app_language_title =>
      'Setha kabusha ulimi lohlelo lokusebenza';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Engeza amakhadi';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Shintsha phakathi kwe-prices.openfoodfacts.org (PROD) kanye ne-test env';

  @override
  String get search_history_item_edit_tooltip =>
      'Sebenzisa futhi uhlele lolu kusesha';

  @override
  String get search_history_item_remove_tooltip => 'Susa';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Ulande yonke imikhiqizo ye- $totalSize .';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Landa $count imikhiqizo eyengeziwe\nSekuvele kulandiwe $downloaded ku- $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Usesho lwakho lwe- $search luyaqhubeka.\n\nSicela ulinde imizuzwana embalwa…';
  }

  @override
  String get user_search_contributor_title => 'Imikhiqizo engiyifakile';

  @override
  String get user_search_informer_title => 'Imikhiqizo engiyihlelile';

  @override
  String get user_search_photographer_title => 'Imikhiqizo engiyithathile';

  @override
  String get user_search_to_be_completed_title => 'Imikhiqizo yami ezoqedwa';

  @override
  String get user_search_prices_title => 'Amanani ami';

  @override
  String get user_search_proofs_title => 'Ubufakazi bami';

  @override
  String get user_search_proof_title => 'Ubufakazi bami';

  @override
  String search_proof_title(String user) {
    return 'Ubufakazi obuvela ku-\"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Izintengo zomnikeli: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Amanani Akamuva Angeziwe';

  @override
  String get all_search_prices_top_user_title => 'Abanikeli bentengo ephezulu';

  @override
  String get all_search_prices_top_location_title =>
      'Izitolo ezinezintengo eziningi kakhulu';

  @override
  String get prices_contribution_assistant => 'Umsizi Wokunikela Ngentengo';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system =>
      'Engeza Ubufakazi Obuningi';

  @override
  String get all_search_prices_top_location_single_title => 'Amanani esitolo';

  @override
  String get all_search_prices_top_product_title =>
      'Imikhiqizo enamanani amaningi kakhulu';

  @override
  String get all_search_to_be_completed_title => 'Yonke imikhiqizo ezoqedwa';

  @override
  String get categorize_products_country_title =>
      'Siza ekuhlukaniseni imikhiqizo ezweni lakini';

  @override
  String get edit_product_action_retake_picture => 'Thatha isithombe kabusha';

  @override
  String get edit_product_action_take_picture => 'Thatha isithombe';

  @override
  String get edit_product_action_confirm => 'Qinisekisa';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Ngiyavumelana namaqiniso okudla avulekile ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'imigomo yokusebenzisa kanye nomnikelo';

  @override
  String get analytics_consent_image_semantic_label =>
      'Isithonjana se-Analytics';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Iphutha Elibulalayo: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Iphutha Elibulalayo: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Imininingwane eyisisekelo ephelele';

  @override
  String get edit_photo_button_label => 'Edit';

  @override
  String get edit_photo_unselect_button_label => 'Susa ukukhetha isithombe';

  @override
  String get edit_photo_select_existing_button_label =>
      'Khetha isithombe esikhona kakade';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Khetha isithombe ngokuchofoza kuso';

  @override
  String get edit_photo_select_existing_download_label =>
      'Ukubuyisa izithombe ezikhona…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Azikho izithombe ezilayishwe ngaphambilini ezihlobene nalo mkhiqizo.';

  @override
  String get edit_photo_language_not_this_one =>
      'Asikho isithombe ngalolo limi okwamanje';

  @override
  String get edit_photo_language_none => 'Asikho isithombe okwamanje';

  @override
  String get category_picker_screen_title => 'Categories';

  @override
  String get basic_details => 'Imininingwane Eyisisekelo';

  @override
  String get product_name => 'Igama Lomkhiqizo';

  @override
  String get product_names => 'Amagama Omkhiqizo';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Engeza ukuhumusha okusha';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Ngaphambi kokuqinisekisa, sicela uqinisekise ukuthi ufaka ukuhumusha kuphela **uma ulimi lukhona ephaketheni**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Buka isithombe sangaphambili';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Thatha isithombe sangaphambili';

  @override
  String get add_basic_details_product_name_hint =>
      'Faka igama lomkhiqizo (isb.: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Shintsha ulimi oluzenzakalelayo?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Ingabe ufuna ulimi olumisiwe lomkhiqizo lusethwe ukuze lube \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Izibonelo ezinhle';

  @override
  String get explanation_section_bad_examples => 'Izibonelo ezimbi';

  @override
  String get add_basic_details_product_name_help_title =>
      'Imikhuba emihle: Igama lomkhiqizo';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Igama lomkhiqizo yi-**igama eliyinhloko eliphrintiwe ephaketheni**. Kungaba uphawu lokuhweba olubhalisiwe.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Qaphela:** Sicela ungangezi ukuhumusha **uma ulimi lungekho ephaketheni**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'I-Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'I-Tomato Ketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Ungafaki uphawu egameni';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'I-Tomato Ketchup **nguHeinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Ungasebenzisi izimpawu ®, ™, © noma ezifanayo';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'I-Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count okunye ukuhumusha',
      one: '$count okunye ukuhumusha',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'I gama le-brand';

  @override
  String get brand_names => 'Amagama emikhiqizo';

  @override
  String get add_basic_details_brand_name_error =>
      'Sicela ufake igama lomkhiqizo';

  @override
  String get add_basic_details_brand_names_hint =>
      'Imikhiqizo yokufaka (isb: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Imikhuba Emihle: Imikhiqizo';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Faka **zonke izinhlobo zomkhiqizo**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Umkhiqizo oyinhloko';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'Uhlobo oluyinhloko**, oluvame ukukhonjiswa ngokucacile ephaketheni elingaphambili, kufanele lufakwe kuqala**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Eminye imikhiqizo';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Uma kuthengiswa yinkampani enkulu**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**I-Actimel** ithengiswa yi-**Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Uma ithengiswa nomkhiqizo wayo **ihunyushwe ngezilimi eziningi**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Isigodi Semvelo** ngezinye izikhathi sibhalwa ngokuthi **Imvelo Yemvelo**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 =>
      'I-Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Ubuningi nesisindo';

  @override
  String get add_basic_details_quantity_hint =>
      'Faka isisindo futhi uma kudingeka inani (isb: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Imikhuba Emihle: Ubuningi';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Kopisha inani eliboniswe kumkhiqizo bese u-**ungakhohlwa amayunithi**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** noma **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (ngamaqanda ayisithupha)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(komkhiqizo onamabhokisi ama-3, ngalinye linama-150g)';

  @override
  String get barcode => 'Barcode';

  @override
  String barcode_barcode(String barcode) {
    return 'Ikhodi yebha: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Ibhakhodi engavumelekile';

  @override
  String get basic_details_add_success =>
      'Imininingwane eyisisekelo ingezwe ngempumelelo';

  @override
  String get basic_details_add_error =>
      'Ayikwazi ukwengeza imininingwane eyisisekelo. Sicela uzame futhi ngemva kwesikhathi esithile';

  @override
  String get clear_search => 'Sula usesho lwakho';

  @override
  String get confirm_clear =>
      'Usuzosula wonke umlando wakho: uqinisekile ukuthi ufuna ukuqhubeka?';

  @override
  String get alert_clear_selected_user_list =>
      'Usuzosusa izinto ezikhethiwe emlandweni wakho';

  @override
  String get confirm_clear_selected_user_list =>
      'Uqinisekile ukuthi ufuna ukuqhubeka?';

  @override
  String get alert_select_items_to_clear =>
      'Sicela ukhethe into eyodwa noma ngaphezulu ozoyisula';

  @override
  String confirm_clear_user_list(String name) {
    return 'Usuzosula lolu hlu ($name): uqinisekile ukuthi ufuna ukuqhubeka?';
  }

  @override
  String get confirm_delete_user_list_title => 'Susa uhlu?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Usuzosusa uhlu \"$name\".\nUqinisekile ukuthi ufuna ukuqhubeka?';
  }

  @override
  String get confirm_delete_user_list_button => 'Yebo, ngiyaqinisekisa';

  @override
  String importance_label(String name, String id) {
    return '$name ukubaluleka: $id';
  }

  @override
  String get user_list_all_title => 'Uhlu';

  @override
  String get user_list_all_empty => 'Dala uhlu lwakho lokuqala';

  @override
  String get product_list_select => 'Khetha uhlu';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count imikhiqizo',
      one: 'Umkhiqizo owodwa',
      zero: 'Uhlu olungenalutho',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Engeza uhlu';

  @override
  String get open_food_preferences_tooltip =>
      'Hlela izintandokazi zakho zokudla';

  @override
  String get add_photo_button_label => 'Engeza isithombe';

  @override
  String get add_packaging_photo_button_label =>
      'Thatha izithombe zanoma yiluphi ulwazi lokupakisha/lokusebenzisa kabusha';

  @override
  String get add_origin_photo_button_label =>
      'Thatha izithombe zanoma yiluphi ulwazi lwemvelaphi';

  @override
  String get add_emb_photo_button_label =>
      'Thatha izithombe zanoma yiluphi ulwazi lwekhodi yokulandelela';

  @override
  String get add_label_photo_button_label =>
      'Thatha izithombe zanoma yimaphi amalebula kanye nolwazi lwezitifiketi';

  @override
  String get choose_image_source_title => 'Khetha umthombo wesithombe';

  @override
  String get choose_image_source_body => 'Sicela ukhethe umthombo wesithombe';

  @override
  String get gallery_source_label => 'Igalari';

  @override
  String get gallery_source_access_denied_dialog_title =>
      'Ukufinyelela kuvinjelwe';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Ngeshwa, uhlelo lokusebenza alukwazi ukufinyelela igalari yakho, njengoba uke wenqaba imvume ngaphambilini.\n\nSicela uye kuzilungiselelo zohlelo lokusebenza kuzilungiselelo zefoni yakho -> Izithombe';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Vula izilungiselelo';

  @override
  String get share => 'Yabelana';

  @override
  String share_product_text(String url) {
    return 'Bheka lo mkhiqizo ku-Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Bheka lo mkhiqizo ku-Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Bheka lo mkhiqizo ku-Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Bheka lo mkhiqizo ku-Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Bheka uhlu lwami lwemikhiqizo ku-Open Food Facts: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Take a picture';

  @override
  String get choose_from_gallery => 'Khetha kugalari';

  @override
  String get image_upload_queued =>
      'Isithombe sizolayishwa ngemuva ngokushesha okukhulu.';

  @override
  String get add_price_queued =>
      'Intengo izothunyelwa kuseva ngokushesha okukhulu.';

  @override
  String get background_task_title_full_refresh =>
      'Ukuqala ukuvuselelwa kwayo yonke imikhiqizo egcinwe endaweni';

  @override
  String get background_task_title_folksonomy =>
      'Iqala ukwenza izenzo zeseva ngezibuyekezo ze-folksonomy ezigcinwe endaweni';

  @override
  String get background_task_title_top_n =>
      'Ukuqala ukulanda imikhiqizo ethandwa kakhulu';

  @override
  String get expand_nutrition_facts =>
      'Nweba ithebula lamaqiniso okudla okunempilo';

  @override
  String get expand_nutrition_facts_body =>
      'Gcina ithebula lamaqiniso okudla okunempilo landisiwe';

  @override
  String get expand_ingredients => 'Nweba izithako';

  @override
  String get expand_ingredients_body => 'Gcina iphaneli yezithako inwetshiwe';

  @override
  String get no_internet_connection => 'Akukho uxhumano lwe-inthanethi';

  @override
  String get world_results_label => 'Umhlaba wonke';

  @override
  String get world_results_action => 'Yandisa usesho lwakho emhlabeni wonke';

  @override
  String get copy_to_clipboard => 'Kopisha';

  @override
  String get paste_from_clipboard =>
      'Namathisela kusuka ebhodini lokunamathisela';

  @override
  String get no_data_available_in_clipboard =>
      'Akukho datha etholakalayo ebhodini lakho lokunamathisela';

  @override
  String get clipboard_barcode_copy =>
      'Kopisha ibhakhodi ebhodini lokunamathisela';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Ikhodi yebha $barcode ikopishwe ebhodini lokunamathisela!';
  }

  @override
  String get open_product_website => 'Vula lo mkhiqizo kuwebhusayithi';

  @override
  String get language_picker_label => 'Ulimi lwakho';

  @override
  String get country_picker_label => 'Izwe lakini';

  @override
  String get currency_picker_label => 'Uhlobo lwakho lwemali';

  @override
  String get help_with_openfoodfacts => 'Usizo nge-OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Umkhiqizo uzobuyekezwa ngemuva ngokushesha okukhulu.';

  @override
  String get no_email_client_available_dialog_title =>
      'Azikho izinhlelo zokusebenza ze-imeyili!';

  @override
  String get no_email_client_available_dialog_content =>
      'Sicela usithumelele i-imeyili ngesandla ku-mobile@openfoodfacts.org';

  @override
  String get all_images => 'Zonke Izithombe';

  @override
  String get selected_images => 'Izithombe Ezikhethiwe';

  @override
  String get product_card_remove_product_tooltip => 'Susa umkhiqizo';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Ibhakhodi entsha iskeniwe: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Susa yonke imikhiqizo ku-carousel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Sicela uskene okungenani imikhiqizo emibili ukuze uyiqhathanise';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Chofoza ukuze uqhathanise imikhiqizo oyiskenile';

  @override
  String get scan_product_loading => 'Uskene\nibhakhodi:';

  @override
  String get scan_product_loading_initial =>
      'Sifuna lo mkhiqizo!\nSicela ulinde imizuzwana embalwa…';

  @override
  String get scan_product_loading_long_request =>
      'Sisafuna lo mkhiqizo!\nUthola ukuthi kuthatha isikhathi eside ukulayisha? Nathi sinjalo…';

  @override
  String get scan_product_loading_unresponsive =>
      'Sisafuna lo mkhiqizo.\nUngathanda ukuqala kabusha usesho?';

  @override
  String get scan_product_loading_restart_button => 'Qala kabusha usesho';

  @override
  String get portion_calculator_description =>
      'Bala amaqiniso okudla okunempilo ukuze uthole inani elithile';

  @override
  String get portion_calculator_hint => 'Inani ku';

  @override
  String get portion_calculator_accessibility =>
      'Faka inani ukuze ubale amaqiniso okudla okunempilo';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Sicela ufake inani eliphakathi kuka- $min kanye no- $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Idatha engekho. Ukubala akukwazanga ukwenziwa.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Amaqiniso okudla okunempilo kwe- $grams g (noma ml)';
  }

  @override
  String get offline_data => 'Idatha Engaxhunyiwe Ku-inthanethi';

  @override
  String get ocr_image_upload_instruction =>
      'Layisha isithombe ukuze ukhiphe ngokuzenzakalelayo ulwazi oluqukethwe kuso.';

  @override
  String get upload_image => 'Layisha Isithombe';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Yehlulekile ukulanda isithombe';

  @override
  String get image_edit_url_error =>
      'Yehlulekile ukuhlela isithombe ngoba i-URL yesithombe ayisethiwe.';

  @override
  String get user_picture_source_remember => 'Khumbula ukukhetha kwami';

  @override
  String get user_picture_source_ask => 'Buza isikhathi ngasinye';

  @override
  String get robotoff_continue => 'Qhubeka';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count imibuzo',
      one: 'umbuzo',
    );
    return 'Okulandelayo $_temp0';
  }

  @override
  String get show_password => 'Bonisa Iphasiwedi';

  @override
  String get owner_field_info_title => 'Amanani ahlinzekwe ngumkhiqizi';

  @override
  String get owner_field_info_message =>
      'Ngalelo logo siqokomisa idatha enikezwe umkhiqizi, futhi okungenzeka ukuthi ayihleleki.';

  @override
  String get owner_field_info_close_button => 'Vala lolu lwazi';

  @override
  String get owner_field_image =>
      'Lesi sithombe sinikezwe ngumkhiqizi. Kungenzeka singahleleki.';

  @override
  String get edit_packagings_title => 'Izingxenye zokupakisha';

  @override
  String get edit_packagings_element_add => 'Engeza ingxenye yokupakisha';

  @override
  String get edit_packagings_completed => 'Ukupakisha sekuqediwe';

  @override
  String edit_packagings_element_title(int index) {
    return 'Ingxenye yokupakishwa #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Inani lamayunithi';

  @override
  String get edit_packagings_element_hint_units =>
      'Faka inani lamayunithi okupakisha anesimo esifanayo kanye nezinto eziqukethwe kumkhiqizo.';

  @override
  String get edit_packagings_element_field_shape => 'Isimo';

  @override
  String get edit_packagings_element_hint_shape =>
      'Faka igama lesimo elibhalwe emiyalweni yokuvuselela uma litholakala, noma khetha isimo.';

  @override
  String get edit_packagings_element_example_shape => 'Ibhodlela';

  @override
  String get edit_packagings_element_field_material => 'Izinto';

  @override
  String get edit_packagings_element_hint_material =>
      'Faka into ethile uma ingatholakala (ikhodi yezinto ezingaphakathi kukanxantathu ingatholakala ezingxenyeni zokupakisha), noma into ejwayelekile (isibonelo ipulasitiki noma insimbi) uma ungaqiniseki.';

  @override
  String get edit_packagings_element_example_material => 'Ingilazi';

  @override
  String get edit_packagings_element_field_recycling =>
      'Imiyalelo yokusebenzisa kabusha';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Faka imiyalelo yokuvuselela kuphela uma ibhalwe kumkhiqizo.';

  @override
  String get edit_packagings_element_example_recycling => 'Phinda usebenzise';

  @override
  String get edit_packagings_element_field_quantity =>
      'Inani eliphelele lomkhiqizo ngeyunithi ngayinye';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Faka isisindo esiphelele noma ivolumu ehlanzekile bese ukhombisa iyunithi (isibonelo g noma ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Isisindo seyunithi eyodwa engenalutho (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Susa noma yikuphi ukudla okusele bese ugeza bese womisa ingxenye yokupakisha ngaphambi kokulinganisa. Uma kungenzeka, sebenzisa isikali esinokunemba okungu-0.1g noma okungu-0.01g.';

  @override
  String get background_task_title => 'Iminikelo elindile';

  @override
  String get background_task_subtitle =>
      'Iminikelo yakho igcinwa ngokuzenzakalelayo kuseva yethu, kodwa hhayi ngaso sonke isikhathi ngesikhathi sangempela.';

  @override
  String get background_task_list_empty =>
      'Ayikho Imisebenzi Yangemuva Elindile';

  @override
  String get background_task_error_server_time_out =>
      'Isikhathi sokuvala seseva';

  @override
  String get background_task_error_no_internet =>
      'Iphutha lokuxhumeka kwe-inthanethi. Zama kamuva.';

  @override
  String get background_task_operation_unknown =>
      'uhlobo lokusebenza olungaziwa';

  @override
  String get background_task_operation_details =>
      'izinguquko ezinemininingwane';

  @override
  String get background_task_operation_image => 'ukulayisha isithombe';

  @override
  String get background_task_operation_refresh =>
      'ukuvuselela kubambezelekile ngemva kokulayishwa kwesithombe';

  @override
  String get background_task_run_started => 'kwaqala';

  @override
  String get background_task_run_not_started => 'akukaqalwa okwamanje';

  @override
  String get background_task_run_to_be_deleted => 'kuzosuswa';

  @override
  String get background_task_question_stop =>
      'Ingabe ufuna ukuyeka lowo msebenzi ngokushesha okukhulu?';

  @override
  String get feed_back => 'Impendulo';

  @override
  String get undo => 'Hlehlisa';

  @override
  String get copy_email_to_clip_board =>
      'Kopisha i-imeyili ebhodini lokunamathisela';

  @override
  String get please_send_us_an_email_to =>
      'Sicela usithumelele i-imeyili ngesandla ku-';

  @override
  String get email_copied_to_clip_board =>
      'I-imeyili ikopishwe ebhodini lokunamathisela!';

  @override
  String get select_accent_color => 'Khetha Umbala We-Accent';

  @override
  String get theme_amoled => 'I-AMOLED';

  @override
  String get color_blue => 'Okuluhlaza okwesibhakabhaka';

  @override
  String get color_cyan => 'I-Cyan';

  @override
  String get color_green => 'Okuluhlaza okotshani';

  @override
  String get color_light_brown => 'Okuzenzakalelayo';

  @override
  String get color_magenta => 'I-Magenta';

  @override
  String get color_orange => 'iwolintshi';

  @override
  String get color_pink => 'Opinki';

  @override
  String get color_red => 'Okubomvu';

  @override
  String get color_rust => 'Ukugqwala';

  @override
  String get color_teal => 'I-Teal';

  @override
  String get text_contrast_mode => 'Ukungafani Kombhalo';

  @override
  String get contrast_high => 'Phezulu';

  @override
  String get contrast_medium => 'Okuphakathi nendawo';

  @override
  String get contrast_low => 'Phansi';

  @override
  String get product_refresher_internet_not_found =>
      'Umkhiqizo awutholakalanga!';

  @override
  String get product_refresher_internet_not_connected =>
      'Awuxhunyiwe kwi-inthanethi!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Iseva iphansi ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Iphutha leseva ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Umkhiqizo awutholakalanga!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Umkhiqizo onebhakhodi elandelayo awukho kusizindalwazi sethu: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Akukho uxhumano lwe-inthanethi!';

  @override
  String get product_loader_network_error_message =>
      'Sicela uhlole ukuthi i-smartphone yakho ikunethiwekhi ye-WiFi noma inedatha yeselula evuliwe.';

  @override
  String get page_not_found_title => 'Ikhasi alitholakalanga!';

  @override
  String get page_not_found_button => 'Buyela ekhasini eliyisiqalo';

  @override
  String get download_data => 'Landa idatha';

  @override
  String get download_top_products =>
      'Landa imikhiqizo eyi-1000 ephezulu ezweni lakini ukuze uyiskene ngokushesha';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count',
    );
    return 'Landa imikhiqizo ephezulu $_temp0 ezweni lakini ukuze uskene ngokushesha';
  }

  @override
  String get download_in_progress =>
      'Ukulanda idatha\nLokhu kungathatha isikhashana';

  @override
  String downloaded_products(int num) {
    return '$num imikhiqizo ingeziwe';
  }

  @override
  String get update_offline_data =>
      'Buyekeza idatha yomkhiqizo ongaxhunyiwe ku-inthanethi';

  @override
  String get update_local_database_sub =>
      'Buyekeza isizindalwazi semikhiqizo yasendaweni ngemininingwane yakamuva evela ku-Open Food Facts';

  @override
  String get clear_local_database =>
      'Sula idatha yomkhiqizo ongaxhunyiwe ku-inthanethi';

  @override
  String get clear_local_database_sub =>
      'Sula yonke idatha yomkhiqizo wendawo kusuka kuhlelo lwakho lokusebenza ukuze ukhulule isikhala';

  @override
  String deleted_products(int num) {
    return '$num imikhiqizo isusiwe';
  }

  @override
  String get loading => 'Loading…';

  @override
  String get know_more => 'Yazi Okuningi';

  @override
  String get offline_data_desc =>
      'Chofoza ukuze wazi kabanzi ngedatha engaxhunyiwe ku-inthanethi';

  @override
  String get offline_product_data_title =>
      'Idatha yomkhiqizo engaxhunyiwe ku-inthanethi';

  @override
  String available_for_download(int num) {
    return '$num imikhiqizo etholakalayo ukuze iskenwe ngokushesha';
  }

  @override
  String get country_selector_title => 'Khetha izwe lakini:';

  @override
  String get currency_selector_title => 'Khetha uhlobo lwemali lwakho:';

  @override
  String get language_selector_title => 'Khetha ulimi lwakho:';

  @override
  String get language_selector_section_selected => 'Izilimi ezikhethiwe';

  @override
  String get language_selector_section_frequently_used => 'Isetshenziswa njalo';

  @override
  String get action_delete_list => 'Susa';

  @override
  String get action_change_list => 'Shintsha uhlu lwamanje';

  @override
  String get product_list_create => 'Dala';

  @override
  String get product_list_create_tooltip => 'Dala uhlu olusha';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'I-Nutri-Score A';

  @override
  String get nutriscore_b => 'I-Nutri-Score B';

  @override
  String get nutriscore_c => 'I-Nutri-Score C';

  @override
  String get nutriscore_d => 'I-Nutri-Score D';

  @override
  String get nutriscore_e => 'I-Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'I-Nutri-Score $letter (Ukubalwa okusha)';
  }

  @override
  String get nutriscore_new_formula_title => 'I-Nutri-Score (Ukubalwa okusha)';

  @override
  String get nutriscore_unknown => 'I-Nutri-Score engaziwa';

  @override
  String get nutriscore_unknown_new_formula =>
      'I-Nutri-Score engaziwa (Ukubalwa okusha)';

  @override
  String get nutriscore_not_applicable => 'I-Nutri-Score ayisebenzi';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'I-Nutri-Score ayisebenzi (Ukubalwa okusha)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'IGreen-Score A';

  @override
  String get environmental_score_b_new => 'IGreen-Score B';

  @override
  String get environmental_score_c_new => 'IGreen-Score C';

  @override
  String get environmental_score_d_new => 'IGreen-Score D';

  @override
  String get environmental_score_e_new => 'IGreen-Score E';

  @override
  String get environmental_score_unknown_new => 'I-Green-Score engaziwa';

  @override
  String get environmental_score_not_applicable_new =>
      'IGreen-Score ayisebenzi';

  @override
  String get nova_group_generic_new =>
      'Ukudla okucutshungulwe kakhulu - amaqembu e-NOVA';

  @override
  String get nova_group_1 => 'Iqembu le-NOVA 1';

  @override
  String get nova_group_2 => 'Iqembu le-NOVA 2';

  @override
  String get nova_group_3 => 'Iqembu le-NOVA 3';

  @override
  String get nova_group_4 => 'Iqembu le-NOVA 4';

  @override
  String get nova_group_unknown => 'Iqembu le-NOVA elingaziwa';

  @override
  String get nutrition_facts => 'Amazinga Ezakhamzimba';

  @override
  String get faq_title_partners => 'Abalingani kanye nabaxhasi be-NGO';

  @override
  String get faq_title_vision =>
      'Amaqiniso Okudla Avulekile Umbono, Umsebenzi, Izindinganiso kanye Nezinhlelo';

  @override
  String get faq_title_install_beauty =>
      'Faka i-Open Beauty Facts ukuze udale isizindalwazi sezimonyo';

  @override
  String get faq_title_install_pet =>
      'Faka i-Open Pet Food Facts ukuze udale isizindalwazi sokudla kwezilwane ezifuywayo';

  @override
  String get faq_title_install_product =>
      'Faka i-Open Products Facts ukuze udale isizindalwazi semikhiqizo ukuze wandise impilo yezinto';

  @override
  String get faq_nutriscore_nutriscore =>
      'Ukubalwa okusha kwe-Nutri-Score: yini entsha?';

  @override
  String get contact_title_pro_page =>
      'Uchwepheshe? Ngenisa imikhiqizo yakho ku-Open Food Facts';

  @override
  String get contact_title_pro_email => 'Oxhumana Naye Womkhiqizi';

  @override
  String get contact_title_press_page => 'Ikhasi Lokucindezela';

  @override
  String get contact_title_press_email => 'Xhumana nabezindaba';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'Bhalisela ikhalenda lethu lomphakathi';

  @override
  String get hunger_games_loading_line1 => 'Sicela usinike imizuzwana embalwa…';

  @override
  String get hunger_games_loading_line2 => 'Silanda imibuzo!';

  @override
  String get hunger_games_error_label =>
      'Hawu! Kukhona okungahambanga kahle… futhi asikwazanga ukulayisha imibuzo.';

  @override
  String get hunger_games_error_retry_button => 'Ake sizame futhi!';

  @override
  String get reorder_attribute_action => 'Hlela kabusha izimfanelo';

  @override
  String get link_cant_be_opened =>
      'Lesi sixhumanisi asikwazi ukuvulwa kudivayisi yakho. Sicela uhlole ukuthi unesiphequluli esifakiwe.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Imininingwane ye- $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Imininingwane ye- $pageName nge- $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Yabelana';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Ungasitholaphi isibalo esisha se-Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'I-Nutri-Score isetshenziswa emazweni ayi-7: iFrance, iJalimane, iBelgium, iSpain, iLuxembourg, iNetherlands kanye neSwitzerland.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Abakhiqizi baneminyaka okungenani engu-**2** okungenani ngemuva kokusayina isinqumo **sokufaka esikhundleni** isibalo esidala ngesisha.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Siyini i-Green Score?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'I-Green-Score ilogo ehlose ukukwazisa mayelana **nomthelela wokudla kwemvelo**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Ikhodi yombala iyahlukahluka ukusuka kokuluhlaza okumnyama (**A+**) emikhiqizweni **enomthelela omncane** ukuya kokubomvu okumnyama (**F**) kumikhiqizo **enomthelela omkhulu**.';

  @override
  String get guide_greenscore_logos_caption => 'I-Green-Score logos';

  @override
  String get guide_greenscore_lca_title =>
      'Umongo: Ukuhlolwa komjikelezo wempilo (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Ukuhlolwa kwesayensi kwezigaba zokudla';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Esigabeni ngasinye somkhiqizo, umphumela othi **benchmark** usungulwa kusetshenziswa idatha evela kusizindalwazi sezemvelo se-Agribalyse (eklanywe i-ADEME ne-INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Ukuhlaziywa komjikelezo wempilo** kuyindlela yokuhlola emisiwe yokwenza ukuhlolwa kwemvelo okunezigaba eziningi kanye nemibandela eminingi.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Iyakala:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 izinyathelo zokukhiqiza';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Packaging';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 izinkomba zomthelela kwezemvelo';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Ukushintsha kwesimo sezulu/i-carbon footprint';

  @override
  String get guide_greenscore_lca_arg3_text2 =>
      'Ukuncipha kwesendlalelo se-ozone';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Imisebe ye-ionizing';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Umhlaba';

  @override
  String get guide_greenscore_lca_arg3_text5 =>
      'Ukusetshenziswa kwamanzi namandla';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Ukungcoliswa komoya';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Amanzi olwandle nahlanzekile (izinhlayiya, i-acidification, i-eutrophication)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Ukuqedwa kwezinsiza.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Amabhonasi nezijeziso';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Ukuze siklomelise imikhiqizo engcono ngaphakathi kwesigaba, sisebenzisa amabhonasi nezinhlawulo ngokusekelwe ezimisweni eziningana**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'Ibhonasi** inikezwa imikhiqizo enelebula elisemthethweni, ilebula noma isitifiketi esiqinisekisa izinzuzo zemvelo** (i-organic, ukuhweba okufanelekile, i-HVE, i-Label Rouge, i-Bleu Blanc Cœur, i-MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origin of ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'Ibhonasi** inikezwa ngokusekelwe emvelaphi yezithako. Le bhonasi icabangela umthelela wokuthutha** kanye nenqubomgomo yezemvelo** yezwe lomkhiqizi ngamunye.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Inhlawulo** inikezwa imikhiqizo equkethe izithako ezinemiphumela emibi kakhulu **ezinhlobonhlobo zezinto eziphilayo kanye nezindawo zemvelo**, njengamafutha esundu, okukhiqizwa kwawo okubangela ukugawulwa kwamahlathi okukhulu.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Packaging';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'I-**inhlawulo** ibalwa ukuze kucatshangelwe ukujikeleza kokupakisha** (ukusetshenziswa kwezinto zokusetshenziswa kabusha kanye nokusetshenziswa kabusha) kanye nokupakisha ngokweqile.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Ukuze ubale ngokunembile i-Green-Score, kuyadingeka ukuba nolwazi olungacaciswanga ngempela ephaketheni** (njengomsuka kanye nephesenti eliqondile lesithako ngasinye) noma olungatholakali kalula ngesimo esisebenzisekayo (njengohlu lwazo zonke izingxenye zephakheji enezinhlobo eziqondile zepulasitiki ezisetshenzisiwe).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Kusetshenziswa amanani ajwayelekile uma lolu lwazi lungatholakali**, kodwa manje sinxusa wonke umuntu ukuthi asisize siqoqe lolu lwazi oluzoba usizo kakhulu kwi-Green-Score kodwa nakwezinye izinto eziningi ezisetshenziswayo.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Izakhamuzi zingasiza kanjani?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Zonke izakhamuzi zingasisiza ukuqoqa nokwakha ulwazi olukhona emikhiqizweni noma olungatholakala kuyo, njengolwazi mayelana nokupakisha**: \"I-Mission Emballages\": uhlu olukhulu lokubambisana lokupakisha yonke imikhiqizo yokudla (ngesiFulentshi).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Abakhiqizi bangasiza kanjani';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Abakhiqizi bangasithumela imininingwane yabo ngokuqondile ngenkundla yethu yamahhala yabakhiqizi.';

  @override
  String get guide_greenscore_better_product_title =>
      'Imuphi umkhiqizo ongcono emhlabeni?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Kungaba nzima ukusho';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Ukukhetha ukudla okusimeme kungenye yezinto ezinamandla kakhulu esingazenza esimeni sezulu, njengoba **uhlelo lwethu lokudla emhlabeni wonke lunesibopho sokukhipha isisi esingcolisa umoya** ngaphezu kwekota.\n(Umthombo: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Unamandla!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Izindaba ezinhle ukuthi lokhu kusinika indlela enamandla yokudala ushintsho.\n**Ngamunye wethu udla cishe ukudla okuyinkulungwane njalo ngonyaka**. Lokho kungamathuba angu-1,000 **okukhetha ikusasa elingcono leplanethi**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Kuyasiza ukuba nomthwalo wemfanelo nokunquma';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Ukukhetha ukudla okuzinzile kungazwakala kuyinkimbinkimbi. Amalebula ayadida futhi ulwazi ngokuvamile alukho. I-Green-Score yadalelwa ukwenza kube lula, ikunikeza **okucacile**, **okusekelwe kusayensi**, kanye **okungafihli** kwezemvelo isilinganiso semikhiqizo yokudla, khona kanye lapho ukudinga khona: ngenkathi uthenga.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Ukungafihli';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Ngokungafani namalebula obunikazi, ukubala kwe-Green-Score **kuvulwe ngokuphelele** futhi **kungaqinisekiswa yinoma ubani**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'Yini i-ultra-processing?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Amaqembu e-NOVA akwazisa ngezinga lokucubungula ukudla **.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Ukuhlukaniswa kwe-NOVA kuvumela ukuhlukaniswa kokudla kube **amaqembu angu-4** ngokusekelwe kokuthi **izinga labo lokucutshungulwa kwezimboni** (ukudla okugayiwe kancane noma okungacutshunguliwe, izithako zokupheka, ukudla okugayiwe, ukudla okugayiwe kakhulu).';

  @override
  String get guide_nova_logos_caption => 'Ama-logo we-NOVA';

  @override
  String get guide_nova_groups_title => 'Amaqembu angu-4 we-NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Kunamaqembu angu-4 e-NOVA, eliyinkinga i-Group 4 - ukudla okucutshungulwe kakhulu.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Ukudla okugayiwe kancane noma okungacutshunguliwe';

  @override
  String get guide_nova_groups_arg1_text =>
      'Ukudla okungacutshungulwanga (noma okwemvelo) yizingxenye ezidliwayo zezitshalo** (imbewu, izithelo, amaqabunga, iziqu, izimpande) **noma izilwane** (imisipha, indle, amaqanda, ubisi), kanye nesikhunta, ulwelwe, namanzi, ngemva kokuhlukaniswa nemvelo.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'Izithako zokupheka ezicutshunguliwe, njengamafutha, ibhotela, ushukela, nosawoti, ziyizinto ezithathwe ekudleni kweQembu 1 noma emvelweni ngezinqubo ezihlanganisa ukucindezela, ukucwenga, ukugaya, ukugaya, nokomisa.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'Ukudla okucutshunguliwe, njengemifino ebhodleleni, izinhlanzi ezisemathinini, izithelo ezifakwe kusiraphu, ushizi, kanye nezinkwa ezisanda kwenziwa, **kwenziwa ngokuyinhloko ngokungeza usawoti, uwoyela, ushukela, noma ezinye izinto ezivela ekudleni kweQembu 2 kuya kokudla kweQembu 1**. Izinqubo zifaka izindlela ezahlukene zokugcina noma zokupheka, futhi endabeni yezinkwa noshizi, ukubilisa okungenalo utshwala. Ukudla okuningi okucutshunguliwe kunezithako ezimbili noma ezintathu futhi kuyabonakala njengezinguqulo eziguquliwe zokudla kweQembu 1. Kungadliwa kodwa noma, ngokuvamile, kuhlanganiswe nokunye ukudla.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ukudla okucutshungulwe kakhulu, njengeziphuzo ezibandayo, ukudla okulula okufakwe okumnandi noma okumnandi, imikhiqizo yenyama elungisiwe kabusha, kanye nezitsha eziqandisiwe ezilungiselelwe kusengaphambili, **akukhona nje ukudla okuguquliwe kodwa amafomula enziwe kakhulu noma ngokuphelele ezintweni ezithathwe ekudleni nasezithasiselweni**, anokudla okuncane noma okungenakho konke ukudla kweQembu 1. Izithako kulezi mafomula zivame ukufaka lezo ezitholakala ekudleni okucutshungulwe kakhulu, njengoshukela, uwoyela, amafutha, noma usawoti. Kodwa-ke, imikhiqizo ecutshungulwe kakhulu iqukethe neminye imithombo yamandla nezakhamzimba ezingasetshenziswa ngokuvamile ekulungiseleleni ukupheka. Ezinye zalezi zikhishwa ngqo ekudleni, njenge-casein, i-lactose, i-whey, ne-gluten.';

  @override
  String get guide_nova_explanations_title => 'Izinkinga nge-ultra-processing';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Ukucubungula ngokwedlulele kwezithako zokudla';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Eziningi zitholakala ekucutshungulweni okuqhubekayo kwezakhi zokudla**, njengamafutha ane-hydrogenated noma anesithakazelo, amaprotheni ane-hydrolyzed, isolate ye-soy protein, i-maltodextrin, ushukela ongenayo, kanye nesiraphu yommbila ene-fructose ephezulu.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Izithasiselo ezedlula ukuphepha kokudla okumsulwa';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Izithasiselo ekudleni okucutshungulwe kakhulu zifaka phakathi ezinye ezisetshenziswa ekudleni okucutshungulwe kakhulu, njengezithasiselo, ama-antioxidants, kanye nezithasiselo. Amakilasi ezithasiselo atholakala kuphela emikhiqizweni ecutshungulwe kakhulu afaka phakathi lawo asetshenziselwa ukulingisa noma ukuthuthukisa izimfanelo zokuzwa kokudla noma ukufihla izici ezingathandeki zomkhiqizo wokugcina**. Lezi zithasiselo zifaka phakathi udayi neminye imibala, izithasiselo zombala; ukunambitheka, izithasiselo zokunambitheka, izithasiselo ezingezona ushukela; kanye nezinsiza zokucubungula ezifana ne-carbonating, firming, bulking kanye ne-anti-bulking agents, de-foaming, anti-caking kanye ne-glazing agents, emulsifiers, sequestrants, kanye ne-humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Ukucubungula awukwazi ukukwenza ekhaya';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Kusetshenziswa uchungechunge oluningi lwezinqubo** ukuhlanganisa izithako eziningi ngokuvamile nokudala umkhiqizo wokugcina (ngakho-ke \'ucutshungulwe kakhulu\'). Izinqubo zifaka phakathi eziningana **ezingenazo izinto ezifanayo zasekhaya**, njenge-hydrogenation kanye ne-hydrolysation, i-extrusion kanye ne-molding, kanye ne-pre-processing yokuthosa.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Izici eziyingozi nezezezimali zokucubungula okuphezulu';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Inhloso iyonke yokucubungula kakhulu ukudala imikhiqizo yokudla enophawu**, **elula** (ehlala isikhathi eside, elungele ukudliwa), **ekhangayo** (emnandi kakhulu) kanye **nenzuzo enkulu** (izithako ezishibhile) eyenzelwe ukususa wonke amanye amaqembu okudla. Imikhiqizo yokudla ecutshungulwe kakhulu ivame ukupakishwa ngendlela ekhangayo futhi ithengiswe kakhulu.';

  @override
  String get guide_nova_explanations_arg5_title => 'Ingozi yempilo';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Kusukela ngo-2018, nge-NutriNet-Santé, ukuxhumana kokuqala phakathi kokusetshenziswa kokudla okucutshungulwe kakhulu kanye nezingozi ezengeziwe zomdlavuza, izifo zenhliziyo, nesifo sikashukela kuye kwaqokonyiswa**. Namuhla, izifundo ezingaphezu kuka-90 emhlabeni wonke ziqinisekisa lokhu okutholakele.\nUbudlelwano obuqine kakhulu buhlobene nokukhuluphala ngokweqile, ukufa kwenhliziyo, kanye nezimpawu zokucindezeleka**. Ezinganeni, imiphumela ibonakala kakhulu ekungalingani kwesisindo kanye namafutha.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Amazwe ancoma ukuthi banciphise';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Amanye amazwe asebenzisa amaqembu e-NOVA njengemihlahlandlela noma imigomo yawo yokudla, isibonelo:\n\n- **🇧🇷 Imihlahlandlela yokudla yaseBrazil*** **incoma ukunciphisa ukusetshenziswa** kokudla okucutshunguliwe futhi kugwenywe ukudla okucutshunguliwe kakhulu.\n\n- **🇫🇷 Imigomo yenqubomgomo yokudla kwezempilo yomphakathi yaseFrance** yango-2018-2022 ihlose **ukunciphisa ukusetshenziswa kokudla okucutshunguliwe kakhulu kweqembu lesi-4 ngo-20%**.';

  @override
  String get guide_nova_share_link => 'https://world-zu.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Siyakwamukela ku-Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Kuyini Amaqiniso Okudla Okuvulekile?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'I-Open Food Facts iyisizindalwazi semikhiqizo yokudla esetshenziswa ngokubambisana, ekhululekile, futhi evulekile evela emhlabeni wonke.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Sikholelwa ukuthi wonke umuntu kufanele abe nokufinyelela kolwazi mayelana nalokho akudlayo. Ngokuqoqa idatha ngezithako, izinto ezibangela ukungezwani komzimba, amaqiniso okudla okunempilo, nokuningi, **sinika amandla abathengi ukwenza izinqumo ezinolwazi** futhi siqhube imboni yokudla **ifinyelele ekukhanyeni okukhulu**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Izici Zamaqiniso Okudla Avulekile';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Thola izexwayiso zezithako zakho ezingafuneki';

  @override
  String get guide_open_food_facts_tips_title =>
      'Amathiphu okuthatha izithombe ezinhle';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Okungafanele ukwenze';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Gwema izithunzi nokukhanya okukhanyayo.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Akukho umbhalo ongacacile noma ongacacile.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Ungazikhiphi izingxenye zombhalo.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Gwema izizinda ezimatasa.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Okufanele ukwenze';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Sebenzisa ukukhanya okuhle, okulinganayo.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Qinisekisa ukuthi umbhalo ucacile futhi uyafundeka.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Thwebula lonke uhlu lwezithako.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Gcina umkhiqizo endaweni eyisicaba.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Sisize sakhe \"i-Wikipedia Yokudla\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Isilinganiso sekhwalithi yokudla okunempilo';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Isilinganiso sokugwema ukudla okucutshungulwe kakhulu';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Isikolo seplanethi';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-zu.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Siyakwamukela ku-Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Iyini Imininingwane Yokudla Kwezilwane Ezivulekile?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'I-Open Pet Food Facts idlulisela umsebenzi wethu kubangani bethu abanoboya! Iyi-**database yemikhiqizo yokudla kwezilwane ezifuywayo yamakati, izinja, kanye nabanye abangane**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Siqoqa ulwazi mayelana nezithako **, **ukuhlaziywa kokudla okunempilo**, kanye neziqondiso zokudla ukuze sisize abanikazi bezilwane ezifuywayo ukuba bakhethe ukudla okungcono kakhulu kwezidingo zezilwane zabo.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Izici ze-Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Thola izexwayiso zezithako zakho ezingafuneki';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Ingabe isilwane sakho sinomzimba ongezwani nanoma yiziphi izithako? Ungasetha uhlu lwezithako zobuhle okufanele uzigweme, khona kanye kuhlelo lokusebenza!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Amathiphu okuthatha izithombe ezinhle';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title =>
      'Okungafanele ukwenze';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Gwema izithunzi nokukhanya okukhanyayo.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Akukho umbhalo ongacacile noma ongacacile.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Ungazikhiphi izingxenye zombhalo.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Gwema izizinda ezimatasa.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Okufanele ukwenze';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Sebenzisa ukukhanya okuhle, okulinganayo.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Qinisekisa ukuthi umbhalo ucacile futhi uyafundeka.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Thwebula lonke uhlu lwezithako.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Gcina umkhiqizo endaweni eyisicaba.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Inothi mayelana nokushaya amagoli';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Ukuthuthukisa uhlelo lokuthola amaphuzu ekudleni kwezilwane ezifuywayo **akuyona into eza kuqala njengamanje**. Indlela izoba nzima, njengoba izidingo zokudla okunempilo zihluka kakhulu ngokwezinhlobo, ubudala, kanye nesimo sempilo. Asikakatholi iqembu lesayensi elizimele okwamanje, elikwazile ukuthola amaphuzu anjalo.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-zu.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Siyakwamukela ku-Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Kuyini Amaqiniso Obuhle Ovulekile?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'I-Open Beauty Facts iyisizindalwazi esisebenzisanayo semikhiqizo yezimonyo **.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Umgomo wethu ukuqonda uhlu lwezithako ukuze sikusize **uqonde ukuthi yini esezintweni zakho zokunakekelwa**. Kusukela kuma-moisturizer kuya kuma-makeup, siqoqa idatha ngezithako, izinto ezibangela ukungezwani komzimba, kanye nokupakishwa ukuze sikhuthaze ukucaca embonini yezimonyo.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Izici ze-Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Thola izexwayiso zezithako zakho ezingafuneki';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Ingabe une-allergy kunoma yiziphi izithako? Ufuna ukugwema izinto ezibangela i-comedogenic? Ufuna ukugwema izithako eziphikisanayo? Ungasetha uhlu lwezithako zobuhle okufanele uzigweme, khona kanye kuhlelo lokusebenza!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Amathiphu okuthatha izithombe ezinhle';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Okungafanele ukwenze';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Gwema izithunzi nokukhanya okukhanyayo.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Akukho umbhalo ongacacile noma ongacacile.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Ungazikhiphi izingxenye zombhalo.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Gwema izizinda ezimatasa.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Okufanele ukwenze';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Sebenzisa ukukhanya okuhle, okulinganayo.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Qinisekisa ukuthi umbhalo ucacile futhi uyafundeka.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Thwebula lonke uhlu lwezithako.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Thatha izithombe eziningi ngangokunokwenzeka uma ibhodlela ligobile.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Kungase kudingeke ukuthi ukhiphe ilebula ukuze ubone uhlu lwezithako.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Gcina umkhiqizo endaweni eyisicaba.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Inothi mayelana nokushaya amagoli';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Ngokungafani nemikhiqizo yokudla, umhlaba wezimonyo **awunalo uhlelo lokuthola amaphuzu oluqashelwa emhlabeni wonke, olusekelwa uhulumeni njenge-Nutri-Score**. Imiphumela yezithako ingaba ngeyomuntu siqu kakhulu futhi incike ohlotsheni lwesikhumba, ukungezwani komzimba, kanye nokukhathazeka komuntu ngamunye.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-zu.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'I-Open Prices iphrojekthi yokuqoqa nokwabelana ngamanani emikhiqizo emhlabeni wonke**. Isethi yedatha etholakala emphakathini engasetshenziswa ocwaningweni, ekuhlaziyeni, nokuningi. I-Open Prices ithuthukiswa futhi igcinwe yi-Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Sisebenzisa idatha yamanani evulekile**. Amanani angangezwa abasebenzisi ngalolu hlelo lokusebenza lwewebhu, noma ngohlelo lokusebenza lweselula olusemthethweni lwe-Open Food Facts. Abathengisi noma izinhlelo zokusebenza zezinkampani zangaphandle nazo zinganikela ngokusebenzisa i-API yethu.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Qoqa izithombe zamathegi entengo ezindleleni';

  @override
  String get guide_open_prices_how_arg2_title => 'Qoqa izithombe zamarisidi';

  @override
  String get guide_open_prices_why_title =>
      'Kungani i-Open Food Facts yenza lokhu?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Ulwazi lwamanani lubaluleke kakhulu ukuqonda izinhlelo zokudla. Luyisici esibalulekile ekuqondeni izindleko zokudla nokukhuthaza ukudla okunempilo. Ukuvula idatha yamanani kuyindlela yokwenza kube lula kubacwaningi, izintatheli, kanye nezakhamuzi ukuba **baqonde kangcono ukuthi amanani okudla ahluka kanjani ngokwendawo nangesikhathi**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Landelela ukuvela kwamanani ngokuhamba kwesikhathi';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Bona ukuguquka kwamanani**: ukuncipha kwentengo, ukwehla kwentengo, singakulandelela ndawonye!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Qhathanisa amanani aseduze nawe';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Njengoba sithola amanani engeziwe, ungabona izitolo ezishibhile eziseduze nawe**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Uke wacabanga yini ukususa amanani kumawebhusayithi abathengisi?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Ukuklwebha amanani kuyindlela ecatshangelwayo enguqulweni yesikhathi esizayo ye-Open Prices, kodwa kuzokwenziwa yi-Open Prices uqobo ukuze sibe nobufakazi bentengo ngokusekelwe ekhasini le-HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Unganikela ngamanani ngokusebenzisa i-API yethu.\nUma ufuna ukufaka amanani ngezinga elithile, sicela uxhumane nathi ku-prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Siyakwamukela ku-Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Kuyini Amaqiniso Emikhiqizo Evulekile?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'I-Open Products Facts iyisizindalwazi esikhulu nesivulekile sanoma yimuphi umkhiqizo onebhakhodi, okungesiwo ukudla, izimonyo noma ukudla kwezilwane ezifuywayo**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Kusukela ku-**electronics** kuya ku-**toys**, kanye nezingubo** kuya ku-**izinto zokuhlanza**, uma inebhakhodi, ingangezwa. Le phrojekthi ihlose ukudala \"i-Inthanethi Yezinto\" yezinto zansuku zonke, okwenza ulwazi ngazo lutholakale kuwo wonke umuntu.';

  @override
  String get guide_open_products_facts_features_title =>
      'Izici Zamaqiniso Emikhiqizo Evulekile';

  @override
  String get guide_open_products_facts_features_text =>
      'I-Open Products Facts ihlose ukunikeza abathengi ithuba lokwandisa isikhathi sokuphila kwezinto** ngokunikeza izixazululo eziyindilinga zokunakekela, ukulungisa**, ukuphinda basebenzise** izinto zabo noma ukubanika umnikazi omusha.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Izinyathelo zekhabhoni zemikhiqizo ethile';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** yiFrench Environment Authority ADEME inikeza **impact carbon*** yezigaba eziningi, qiniseka ukuthi uhlukanisa imikhiqizo ngezigaba ngokunembile.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Inkomba yokulungiswa kwemikhiqizo eminingi';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Noma nini lapho inkomba yokulungiswa kabusha yesiFulentshi itholakala, sizoyibonisa. Ngaphezu kwalokho, **ungaqala ukuqoqa iziguquguquko usebenzisa i-Folksonomy Engine**; ukuze sikwazi ukuyibala kabusha thina esikhathini esizayo, ngisho nasemazweni lapho ingatholakali khona.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Thola izindlela zokunikela/ukuthengisa kabusha umkhiqizo wakho';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Sinikeza izixhumanisi ze-**izinsizakalo ezinobungane ezijikelezayo ezivela eceleni** ezikusiza ukuthi uthole uhlobo lomkhiqizo olufunayo, njengomkhiqizo osetshenziwe, ukuze ube mnene kakhulu ezinsizeni zomhlaba.\nQaphela ukuthi asikhokhelwa ukwenza lokho, nokuthi uhlelo lusebenza njengesibonelo kuphela kumawebhusayithi amabili eFrance. Ungasiza ekwandiseni lolu hlelo ngokubhala phansi amasayithi engeziwe ku-wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Yiluphi ulwazi oluwusizo?';

  @override
  String get guide_open_products_facts_information_text =>
      'Kuzinto eziningi kangaka, **idatha esiyiqoqayo iyaguquguquka**. Ukuze senze lokho, **sakha i-Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Injini ye-Folksonomy';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'I-Folksonomy Engine iyithuluzi lokukusiza uqedele imikhiqizo enezakhiwo ezifanele. Lokhu kusiza ukuthuthukisa usesho nokutholakala, kodwa futhi kubalwe futhi kuboniswe izinto ezithakazelisayo esikhathini esizayo.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Ungangeza noma yiziphi izinkinobho namanani afana nalawa: **compatibility_with_5G_mobile_network: yebo**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Uzothola isiphakamiso esizenzakalelayo sezakhiwo ezingaba khona, futhi wamukelekile kakhulu ukwengeza nokubhala phansi ezintsha ezinhlotsheni zakho zemikhiqizo ozithandayo.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-zu.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Izintandokazi zokudla ezivulekile';

  @override
  String get guide_coming_soon_button_title => 'Kuyeza maduze';

  @override
  String get guide_learn_more_subtitle => 'Thepha ukuze ufunde kabanzi';

  @override
  String get preview_badge => 'Ukubuka kuqala';

  @override
  String get prices_feedback_form =>
      'Chofoza lapha ukuze usithumelele impendulo yakho mayelana nalesi sici esisha!';

  @override
  String get menu_button_list_actions => 'Khetha isenzo';

  @override
  String get error_loading_photo => 'Iphutha lokulayisha isithombe';

  @override
  String get photo_viewer_action_use_picture_as => 'Sebenzisa njenge-…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Sebenzisa lesi sithombe njengo-…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Sebenzisa lesi sithombe njengo-… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Imininingwane';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Imininingwane yalesi sithombe';

  @override
  String get photo_viewer_details_title => 'Imininingwane yesithombe';

  @override
  String get photo_viewer_details_contributor_title => 'Contributor';

  @override
  String get photo_viewer_details_size_title => 'Usayizi';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height amaphikseli';
  }

  @override
  String get photo_viewer_details_date_title => 'Usuku';

  @override
  String get photo_viewer_details_url_title => 'I-URL';

  @override
  String get product_page_compatibility_score => 'Iyahambisana';

  @override
  String get user_lists_action_multi_select => 'Ukukhetha okuningi';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Isilinganiso sakho sokuhambisana: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Front picture';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Ingredients picture';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Isithombe sokudla okunempilo';

  @override
  String get product_image_packaging_accessibility_label =>
      'Isithombe sokupakisha';

  @override
  String get product_image_other_accessibility_label => 'Esinye isithombe';

  @override
  String get product_image_outdated_message =>
      'Lesi sithombe kungenzeka ukuthi sesiphelelwe yisikhathi';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (lesi sithombe kungenzeka siphelelwe yisikhathi)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (lesi sithombe singase sivalwe ngumkhiqizi)';
  }

  @override
  String get product_image_error => 'Ayikwazi ukulayisha isithombe!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Ayikwazi ukulayisha i- $type (iphutha lenethiwekhi?)';
  }

  @override
  String get product_page_image_no_image_available => 'Asikho isithombe\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Asikho isithombe esitholakalayo salo mkhiqizo';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Hlela kabusha noma ufihle izenzo';

  @override
  String get product_page_action_bar_setting_modal_title => 'Hlela izenzo';

  @override
  String get product_page_action_bar_item_move_up => 'Hamba uyephezulu';

  @override
  String get product_page_action_bar_item_move_down => 'Yehla';

  @override
  String get product_page_action_bar_item_enable => 'Nika amandla isenzo';

  @override
  String get product_page_action_bar_item_disable => 'Khubaza isenzo';

  @override
  String get product_page_pending_operations_banner_title =>
      'Ukulayisha ukuhlela kwakho…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Idatha eboniswe kuleli khasi **ayikabonisi izinguquko zakho**.\nSicela ulinde imizuzwana embalwa…';

  @override
  String get product_add_a_language => 'Engeza ulimi';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Ikhodi yebha $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Susa lo mkhiqizo ku-carousel';

  @override
  String get carousel_unsupported_header => 'Ibhakhodi engasekelwa!';

  @override
  String get carousel_unsupported_title => 'Hawu!';

  @override
  String get carousel_unsupported_text =>
      'Ibhakhodi eskeniwe ayisekelwa yi-Open Food Facts!';

  @override
  String get carousel_error_header => 'Iphutha!';

  @override
  String get carousel_error_title => 'Kuyadabukisa!';

  @override
  String get carousel_error_text_1 =>
      'Asikwazanga ukulanda ulwazi kule bhakhodi:';

  @override
  String get carousel_error_text_2 =>
      'Sicela uhlole uxhumano lwakho lwe-inthanethi noma uchofoze le nkinobho:';

  @override
  String get carousel_error_button => 'Zama futhi';

  @override
  String get carousel_unknown_product_header => 'Umkhiqizo ongaziwa';

  @override
  String get carousel_unknown_product_title =>
      'Halala!\nUthole __igugu elingavamile!__';

  @override
  String get carousel_unknown_product_text =>
      'Isizindalwazi sethu sokubambisana siqukethe imikhiqizo engaphezu kwezigidi ezintathu**, kodwa le khodi ayikho: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'Ilayisha ulwazi...';

  @override
  String get carousel_loading_title =>
      'Usanda kuskena umkhiqizo ngebhakhodi elandelayo:';

  @override
  String get carousel_loading_text =>
      'Sikufuna kusizindalwazi sethu semikhiqizo engaphezu kwezigidi ezintathu!**';

  @override
  String get product_type_subtitle_food =>
      'Imifino, izithelo, ukudla okuqandisiwe…';

  @override
  String get product_type_subtitle_beauty =>
      'Izimonyo, insipho, amazinyo okuxubha…';

  @override
  String get product_type_subtitle_pet_food => 'Ukudla kwezinja, amakati…';

  @override
  String get product_type_subtitle_product => 'Ama-smartphone, ifenisha…';

  @override
  String get photo_field_front => 'Isithombe somkhiqizo';

  @override
  String get photo_field_ingredients => 'Isithombe sezithako';

  @override
  String get photo_field_nutrition => 'Isithombe sokudla okunempilo';

  @override
  String get photo_field_packaging =>
      'Isithombe semiyalelo yokusebenzisa kabusha';

  @override
  String get photo_already_exists => 'Lesi sithombe sesivele sikhona';

  @override
  String get photo_missing => 'Lesi sithombe asikho';

  @override
  String get date => 'Usuku';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'Hlehlisa isenzo sangaphambilini';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Imephu yomhlaba wonke ye- $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Abanikeli be-OpenStreetMap';

  @override
  String get not_applicable_short => 'Akukho';

  @override
  String get knowledge_panel_warning_text => 'Warning';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Kungani le Nutri-Score ihlukile kulena esephaketheni?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Kunezincazelo ezimbili ezingaba khona:\nUhlu lwezithako kanye/noma amaqiniso okudla okunempilo alukabuyekezwa.\n\nSinikeza \"ukubalwa okusha\" kwe-Nutri-Score (noma i-V2). Sicela uhlole ukuthi unebhena elithi \"Ukubalwa okusha\" ephaketheni.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Hlola izithako';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Hlola amaqiniso okudla okunempilo';

  @override
  String url_not_supported(String url) {
    return 'Ngeshwa, asikwazi ukuvula i-URL:\n$url';
  }

  @override
  String get product_list_export => 'Thumela ngaphandle';

  @override
  String get product_list_import => 'Ngenisa';

  @override
  String get product_footer_action_barcode => 'Buka ibhakhodi';

  @override
  String get product_footer_action_barcode_short => 'Barcode';

  @override
  String get product_footer_action_open_website => 'Vula iwebhusayithi';

  @override
  String get product_footer_action_report => 'Umbiko';

  @override
  String get product_footer_action_contributor_guide => 'Usizo';

  @override
  String get product_footer_action_data_quality_tags => 'Ikhwalithi yedatha';

  @override
  String get product_page_tab_for_me => 'Kwami';

  @override
  String get product_page_tab_website => 'Iwebhusayithi';

  @override
  String get product_page_tab_prices => 'Amanani';

  @override
  String get prices_explanation_card_title => 'Kungani amanani?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** iphrojekthi yokuqoqa nokwabelana ngezintengo zemikhiqizo emhlabeni wonke 🌍. Amanani Avuliwe athuthukiswa futhi agcinwe yi-Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Funda kabanzi';

  @override
  String get product_page_tab_folksonomy => 'I-Folksonomy';

  @override
  String get folksonomy_explanation_card_title =>
      'Yiziphi izimfanelo ze-Folksonomy?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Izibaluli zisuselwe ku-*nani-key**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Lezi zakhiwo zidalwe futhi zifakwe abanikeli banoma yiluphi uhlobo lokusetshenziswa.';

  @override
  String get folksonomy_action_external_link_title =>
      'Vula isixhumanisi sangaphandle';

  @override
  String get folksonomy_action_external_link_warning =>
      'Izixhumanisi zangaphandle zingase zingaphephile. Ingabe ufuna ngempela ukuzivakashela?';

  @override
  String get prices_products_empty_title => 'Ayikho intengo etholakalayo';

  @override
  String get prices_products_empty_explanation =>
      'Iba ngowokuqala ukufaka isandla!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Imikhiqizo $pageSize ephezulu (isiyonke: $total)';
  }

  @override
  String get app_review_title => 'Uyawujabulela lolu hlelo lokusebenza?';

  @override
  String get app_review_low => 'Ngingenza kangcono';

  @override
  String get app_review_medium => 'Akukubi';

  @override
  String get app_review_high => 'Ngiyayithanda!';

  @override
  String get app_review_feedback_modal_title =>
      'Sisize sithuthukise uhlelo lwethu lokusebenza';

  @override
  String get app_review_feedback_modal_content =>
      'Uma unemizuzu embalwa, ungaphendula leli fomu ukuze **sithuthukise izibuyekezo zesikhathi esizayo**:';

  @override
  String get app_review_feedback_modal_open_form => 'Phendula ifomu';

  @override
  String get app_review_feedback_modal_later => 'Ngibuze kamuva';

  @override
  String get nutrition_facts_extract_new =>
      'OKUSHA: Ungakhipha ngokuzenzakalela izakhamzimba esithombeni!';

  @override
  String get nutrition_facts_extract_button_text => 'Khipha manje';

  @override
  String get nutrition_facts_extract_in_progress => 'Ukukhishwa kuyaqhubeka…';

  @override
  String get nutrition_facts_extract_successful => 'Ukukhipha kuphumelele';

  @override
  String get nutrition_facts_extract_failed =>
      'Yehlulekile ukukhipha izakhamzimba esithombeni';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Izibalo';

  @override
  String get prices_stats_title => 'Izibalo Zamanani';

  @override
  String get prices_stats_prices_section => 'Amanani';

  @override
  String get prices_stats_products_section => 'Imikhiqizo';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Okuhlukahlukene';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Ukudla';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Imikhiqizo';

  @override
  String get prices_stats_pet_food => 'Ukudla kwezilwane ezifuywayo';

  @override
  String get prices_stats_osm => 'I-OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Countries';

  @override
  String get prices_stats_price_tag => 'Ithegi yentengo';

  @override
  String get prices_stats_receipt => 'Irisidi';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Iwebhusayithi';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'I-API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'Kugcine ukubuyekezwa ngo-';

  @override
  String get prices_stats_error =>
      'Kuvele iphutha ngesikhathi kulayishwa izibalo.';

  @override
  String get product_edit_robotoff_question_answered => 'Umbuzo uphenduliwe!';

  @override
  String get product_edit_robotoff_proof => 'Ubufakazi';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'Amanani';

  @override
  String get preferences_prices_subtitle =>
      'Phatha izintandokazi zakho zezintengo';

  @override
  String get preferences_card_project => 'Iphrojekthi ye-Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribute';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'Izibalo zami';

  @override
  String get preferences_contribute_subtitle =>
      'Humusha, thuthukisa amathuluzi ethu…';

  @override
  String get preferences_connect_title => 'Xhuma';

  @override
  String get preferences_connect_subtitle =>
      'Xhumana nathi, noma usilandele ezinkundleni zokuxhumana';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Sisize sazise izigidi zabathengi emhlabeni jikelele';

  @override
  String get preferences_card_help => 'Usizo Nosekelo';

  @override
  String get preferences_faq_title => 'Imibuzo Evame Ukubuzwa';

  @override
  String get preferences_faq_subtitle => 'Thola izimpendulo zemibuzo yakho';

  @override
  String get logged_out => 'Uphumile';

  @override
  String get preferences_app_bar_message =>
      'Siyabonga ngokuba ngomunye wamalungu ethu!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Bona zonke izibalo';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Sesha okuthi $provider ukuze uthole \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Sesha isilungiselelo (isb. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Ukufinyeleleka: Bonisa i-emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Ukufinyeleleka: Susa imibala';

  @override
  String get preferences_app_settings_products => 'Imikhiqizo';

  @override
  String get preferences_card_about => 'About';

  @override
  String get preferences_legal_information_title => 'Ulwazi lwezomthetho';

  @override
  String get preferences_legal_information_subtitle =>
      'Imigomo yokusebenzisa, inqubomgomo yobumfihlo, nokuningi';

  @override
  String get preferences_terms_of_use => 'Imigomo Yokusebenzisa';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'I-Open Food Facts iyisizindalwazi semikhiqizo yokudla **eyenziwe yiwo wonke umuntu, yawo wonke umuntu**.\nUngayisebenzisa ukuze wenze ukukhetha okungcono kakhulu kokudla, futhi njengoba kuyi-**idatha evuliwe**, noma ubani angakwazi **ukuphinda ayisebenzisele noma iyiphi injongo**.';

  @override
  String get preferences_privacy_policy => 'Inqubomgomo yobumfihlo';

  @override
  String get preferences_licenses => 'Amalayisense';

  @override
  String get preferences_about_app_title => 'Mayelana nohlelo lokusebenza';

  @override
  String get preferences_about_app_subtitle =>
      'Ulwazi lobuchwepheshe, ulwazi lonjiniyela, nokuningi';

  @override
  String get preferences_card_information => 'Information';

  @override
  String get preferences_version_number_title => 'Inombolo yenguqulo';

  @override
  String get preferences_scanner_title => 'Iskena';

  @override
  String get preferences_app_store => 'Isitolo sohlelo lokusebenza';

  @override
  String get preferences_app_system_settings => 'Izilungiselelo zesistimu';

  @override
  String get preferences_source_code => 'Finyelela ikhodi yomthombo';

  @override
  String get preferences_source_code_subtitle =>
      'Futhi uqale ukwenza umthelela ezigidini';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Complete products';

  @override
  String get preferences_tips => 'Amathiphu';

  @override
  String get tips_discover_nutriscore => 'Zitholele i-Nutri-Score entsha';

  @override
  String get preferences_on_off_website_subtitle =>
      'Kuwebhusayithi ye-Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Phatha i-akhawunti yami';

  @override
  String get preferences_manage_account_tooltip => 'Phatha i-akhawunti yakho';

  @override
  String get preferences_change_password_title => 'Shintsha iphasiwedi yami';

  @override
  String get preferences_danger_zone => 'Indawo eyingozi';

  @override
  String get preferences_account_deletion_subtitle =>
      'Yonke iminikelo yakho izolahleka';

  @override
  String get preferences_contributions_title => 'Contributions';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Izilungiselelo zohlelo lokusebenza';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Indlela yokuhlola kakhulu yokuskena imikhiqizo ungaxhunyiwe ku-inthanethi';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Vuselela yonke imikhiqizo evela kuseva';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Sicela ukugweme ukwenza lokho ngaphandle uma kunesidingo';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Imodi yedemo';

  @override
  String get preferences_dev_mode_add_cards_title => 'Engeza amakhadi kusikena';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Yengeza imikhiqizo eyisampula emi-3 kusikena';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Umphathi we-Folksonomy';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Umsingathi: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Ukuhlolwa kokufinyeleleka';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Ukukhethwa kwemikhiqizo eminingi ngezintengo';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Amaphaneli olwazi a-ode umsebenzisi';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Ukufinyelela kwesikhashana kusesho lwendawo';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Ukuqhathanisa ngakunye kwemikhiqizo emi-2 noma emi-3';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Ukungenisa kohlu lomkhiqizo';

  @override
  String get preferences_faq_scores_methodologies_title => 'Izikolo nezindlela';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Thola ukuthi i-Nutri-Score yenziwa kanjani ikhompuyutha';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Thola izinguquko eziyinhloko endleleni yokusebenza';

  @override
  String get preferences_faq_discover_project_title => 'Discover the project';

  @override
  String get preferences_faq_discover_off_title => 'Zitholele Open Food Facts';

  @override
  String get preferences_faq_discover_obf_title =>
      'Thola Amaqiniso Obuhle Avulekile';

  @override
  String get preferences_faq_discover_opff_title =>
      'Thola Amaqiniso Okudla Kwezilwane Ezifuywayo Avulekile';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Thola Amaqiniso Emikhiqizo Evulekile';

  @override
  String get preferences_faq_faq_title => 'I-FAQ - Imibuzo Evame Ukubuzwa';

  @override
  String get preferences_faq_off_ngo_title => 'I-Open Food Facts NGO';

  @override
  String get preferences_about_information_title => 'Information';

  @override
  String get preferences_connect_community_updates_title =>
      'Thola izibuyekezo zomphakathi';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Hlala unolwazi ngohlelo lokusebenza nezindaba zomphakathi';

  @override
  String get preferences_connect_community_calendar_title =>
      'Bhalisela ikhalenda lethu lomphakathi';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Zibandakanye ngokuhambela omunye wemicimbi yethu ebonakalayo';

  @override
  String get preferences_connect_blog_title => 'Ibhulogi ye-Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Thola izindaba zakamuva, njengoba zenzeka';

  @override
  String get preferences_connect_community_help_title =>
      'Thola usizo emphakathini';

  @override
  String get preferences_connect_improve_app_title =>
      'Sisize sithuthukise uhlelo lokusebenza';

  @override
  String get preferences_connect_debug_info_title =>
      'Sithumelele ulwazi lokususa iphutha';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Sithumele i-imeyili enemininingwane enemininingwane yokulungisa iphutha';

  @override
  String get preferences_connect_feedback_title =>
      'Sithumele impendulo mayelana nohlelo lokusebenza';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Siza ekulolongeni ikusasa lohlelo lokusebenza';

  @override
  String get preferences_connect_survey_title =>
      'Thatha inhlolovo yohlelo lokusebenza';

  @override
  String get preferences_connect_survey_subtitle =>
      'Sisize siqonde okufanele sakhe ngokulandelayo';

  @override
  String get preferences_connect_professionals_title => 'Ochwepheshe';

  @override
  String get preferences_connect_pro_subtitle =>
      'Kumahhala ngokuphelele, kuqinisekisa idatha enembile yezinhlelo zokusebenza ezingu-500 nezigidi zabathengi. Ukuzisiza wena, okuhambisana ne-PIM yakho noma amaspredishithi (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Xhumana naye ukuze uqalise';

  @override
  String get preferences_connect_press_title => 'Press';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Thola konke okubalulekile okudingayo embikweni wakho';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Thintana ukuze uthole imibuzo yabezindaba noma usazise ngombiko wakho';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Iba ivolontiya elisebenzayo';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Ukuthuthukiswa, Ukuxhumana, Idizayini… noma yiluphi uhlobo lokuvolontiya noma ubuchwepheshe bamukelekile!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Thola ezinye zezindlela eziningi onganikela ngazo';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Ukuthuthukiswa kohlelo lokusebenza lweselula';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Funda ukuthi unganikela kanjani ekuthuthukisweni kwesoftware';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Izakhiwo zansuku zonke ezingazinzile, izici ezintsha sha';

  @override
  String get preferences_contribute_local_community_title =>
      'Khulisa umphakathi wangakini';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Usizo ngesofthiwe, okuqukethwe, ukuhumusha kokuhlaziywa kwezithako';

  @override
  String get preferences_contribute_share_subtitle =>
      'Silungiselele isifanekiso esincane sokukusiza :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Izinyathelo ezilula zokukhulisa ukubonakala kokudla ezweni lakini';

  @override
  String get preferences_contribute_data_quality_title => 'Ikhwalithi yedatha';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Joyina ithimba lekhwalithi yedatha';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Joyina umzamo wethu wokuqinisekisa ukuthi isizindalwazi siphelele futhi sinembile';

  @override
  String get preferences_contributions_products_added_title =>
      'Imikhiqizo engeziwe';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Imikhiqizo emisha engiyingeze ku-Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Imikhiqizo engidinga ukuyiqeda';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Yonke imikhiqizo engaphelele';

  @override
  String get preferences_my_contributions_prices_title => 'Amanani';

  @override
  String get preferences_my_contributions_my_prices_title => 'Amanani ami';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Izintengo zami, ubufakazi bami…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Imikhiqizo ongasiza ukuyiqeda';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Siza ukubala i-Nutri-Score & Green-Score ezweni lakini';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Amanani enginikele ngawo';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Amathegi amanani namarisidi';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Thatha izithombe zamaresidi akho futhi uskene amabhakhodi ahlobene';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Thatha izithombe zamanani esitolo';

  @override
  String get preferences_prices_newest_title => 'Izintengo ezintsha';

  @override
  String get preferences_prices_newest_subtitle =>
      'Izintengo zakamuva ezingezwe ngumphakathi we-Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Abanikeli abanamanani amaningi';

  @override
  String get preferences_prices_metrics_title => 'Vula amamethrikhi Entengo';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Landela ukuvela kwephrojekthi';

  @override
  String get preferences_prices_ways_contribute_title => 'Izindlela zokunikela';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Qinisekisa izintengo ezingezwe nguwe noma abanye, ngosizo lwe-AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Engeza ngokushesha amarisidi amaningi noma izithombe zamashalofu kusukela kuroli yekhamera yakho';

  @override
  String get preferences_prices_challenges_title => 'Izinselele zanyanga zonke';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Bamba iqhaza kuzimfuno zetimu yanyanga zonke ukuze uqoqe izintengo';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Thola futhi idatha yakho yokwethembeka';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Funda indlela yokucela idatha yakho';

  @override
  String get preferences_page_customize_app_title =>
      'Enza ngendlela oyifisayo uhlelo lokusebenza';

  @override
  String get preferences_page_contribute_project_title =>
      'Faka isandla kuphrojekthi';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Izindlela ezilula zokusiza Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Izindlela zokuthola amaphuzu, usizo, nokuningi mayelana nephrojekthi';

  @override
  String get product_edit_robotoff_positive_button => 'Yamukela isiphakamiso';

  @override
  String get product_edit_robotoff_negative_button => 'Yenqaba isiphakamiso';

  @override
  String get product_edit_robotoff_show_proof => 'Bonisa ubufakazi';

  @override
  String get product_edit_robotoff_expand_proof => 'Nweba ubufakazi';

  @override
  String get product_page_tab_raw_data => 'Idatha eluhlaza';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Ikhasi $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Ikhasi $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count kwezinto ezingu- $total';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count kwezinto ezingu- $total';
  }

  @override
  String item_count(int count) {
    return '$count izinto';
  }

  @override
  String item_count_string(String count) {
    return '$count izinto';
  }

  @override
  String get prices_no_result => 'Azikho izibalo zentengo ezitholiwe.';

  @override
  String get prices_error_loading_more_items =>
      'Iphutha ekulayisheni izinto ezengeziwe';

  @override
  String get prices_proof_error =>
      'Ukuqinisekisa kuhlulekile, ayikwazanga ukulanda ubufakazi';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count of $total ubufakazi';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count kwabanikeli abangu- $total';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count kwezindawo ezingu- $total';
  }

  @override
  String prices_locations_count(int count) {
    return '$count izindawo';
  }

  @override
  String get restart_to_apply_message =>
      'Sicela uqale kabusha uhlelo lokusebenza ukuze usebenzise izinguquko.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Isixhumi esibonakalayo esibonakalayo';

  @override
  String get preferences_app_settings_media_title => 'Imidiya';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Vula Amaqiniso Okudla Amalebhu';

  @override
  String get preferences_root_account_title => 'I-akhawunti';

  @override
  String get preferences_contribute_translate_header =>
      'Letha Amaqiniso Okudla Okuvulekile olimini lwakho';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Bhalisa kunguqulo ye-alpha yohlelo lokusebenza';

  @override
  String get preferences_dev_mode_section_data =>
      'Idatha yeminikelo nemikhiqizo';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Ungabonisi i-Folksonomy';

  @override
  String get preferences_account_title => 'I-akhawunti';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Kwengezwe kokuthi $created';
  }

  @override
  String get location_map_details_title => 'Imininingwane yendawo';

  @override
  String get location_map_details_name => 'Igama';

  @override
  String get location_map_details_street => 'Umgwaqo';

  @override
  String get location_map_details_city => 'Idolobha';

  @override
  String get location_map_details_postcode => 'Ikhodi yeposi';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Ama-Coordinates';

  @override
  String get location_map_details_osm_id => 'I-ID ye-OSM';
}
