// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Vietnamese (`vi`).
class AppLocalizationsVi extends AppLocalizations {
  AppLocalizationsVi([String locale = 'vi']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Có';

  @override
  String get add => 'Thêm vào';

  @override
  String get account_delete_message =>
      'Bạn có chắc rằng bạn muốn xóa tài khoản của bạn?\nNếu có lý do cụ thể hãy chia sẻ bên dưới';

  @override
  String get reason => 'Lý do';

  @override
  String get okay => 'Okay';

  @override
  String get validate => 'Xác thực';

  @override
  String get create => 'Tạo';

  @override
  String get applyButtonText => 'Áp dụng';

  @override
  String get next_label => 'Kế tiếp';

  @override
  String get continue_label => 'Tiếp tục';

  @override
  String get exit_label => 'Thoát';

  @override
  String get previous_label => 'Quay lại';

  @override
  String get go_back_to_top => 'Quay trở lại bên trên';

  @override
  String get save => 'Lưu';

  @override
  String get save_confirmation => 'Bạn chắc chắn muốn lưu?';

  @override
  String get skip => 'Bỏ qua';

  @override
  String get cancel => 'Huỷ';

  @override
  String get ignore => 'Bỏ qua';

  @override
  String get close => 'Đóng';

  @override
  String get no => 'Không';

  @override
  String get stop => 'Dừng';

  @override
  String get finish => 'Hoàn thành';

  @override
  String get calculate => 'Tính toán';

  @override
  String get reset_food_prefs => 'Đặt lại sở thích ăn uống';

  @override
  String get error => 'Đã xảy ra lỗi';

  @override
  String get error_occurred => 'Đã xảy ra lỗi';

  @override
  String get featureInProgress =>
      'Chúng tôi vẫn đang xây dựng tính năng này, nhớ theo dõi nhé';

  @override
  String get label_web => 'Xem trên web';

  @override
  String get learnMore => 'Tìm hiểu thêm';

  @override
  String get unknown => 'Không biết';

  @override
  String get match_very_good => 'Rất phù hợp';

  @override
  String get match_good => 'Phù hợp';

  @override
  String get match_poor => 'Kém phù hợp';

  @override
  String get match_may_not => 'Không phù hợp';

  @override
  String get match_does_not => 'Không phù hợp';

  @override
  String get match_unknown => 'Độ phù hợp không xác định';

  @override
  String get match_short_very_good => 'Rất phù hợp';

  @override
  String get match_short_good => 'Phù hợp';

  @override
  String get match_short_poor => 'Kém phù hợp';

  @override
  String get match_short_may_not => 'Không phù hợp';

  @override
  String get match_short_does_not => 'Không phù hợp';

  @override
  String get match_short_unknown => 'Độ phù hợp không xác định';

  @override
  String get licenses => 'Giấy phép';

  @override
  String get looking_for => 'Đang tìm';

  @override
  String get welcomeToOpenFoodFacts => 'Chào mừng đến với Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts là một tổ chức phi lợi nhuận toàn cầu được hỗ trợ bởi cộng đồng địa phương.';

  @override
  String get productDataUtility =>
      'Xem dữ liệu thực phẩm liên quan đến sở thích của bạn.';

  @override
  String get healthCardUtility => 'Chọn thực phẩm tốt cho bạn.';

  @override
  String get ecoCardUtility => 'Chọn thực phẩm tốt cho hành tinh này.';

  @override
  String get server_error_open_new_issue =>
      'Không có phản hồi từ máy chủ! Bạn có thể mở sự cố bằng liên kết sau.';

  @override
  String get sign_in_text =>
      'Đăng nhập vào tài khoản Open Food Facts của bạn để lưu các đóng góp của bạn';

  @override
  String get incorrect_credentials => 'Tên đăng nhập hoặc mật khẩu không đúng.';

  @override
  String get password_lost_incorrect_credentials =>
      'Email hoặc tên người dùng này không tồn tại. Vui lòng kiểm tra thông tin đăng nhập của bạn.';

  @override
  String get password_lost_server_unavailable =>
      'Hiện tại, máy chủ của chúng tôi đang gặp sự cố chậm và chúng tôi rất xin lỗi vì điều này. Vui lòng thử lại sau.';

  @override
  String get login => 'Tên người dùng';

  @override
  String get login_result_type_server_unreachable =>
      'Mạng không thể truy cập được';

  @override
  String get login_result_type_server_issue =>
      'Có sự cố trên máy chủ. Vui lòng thử lại sau.';

  @override
  String get login_page_username_or_email =>
      'Vui lòng nhập tên người dùng hoặc e-mail';

  @override
  String get login_page_password_error_empty => 'Vui lòng nhập mật khẩu';

  @override
  String get create_account => 'Tạo tài khoản';

  @override
  String get sign_in => 'Đăng nhập';

  @override
  String get sign_in_mandatory =>
      'Để sử dụng tính năng này chúng tôi cần bạn đăng nhập.';

  @override
  String get help_improve_country =>
      'Giúp cải thiện Open Food Facts ở quốc gia của bạn';

  @override
  String get sign_out => 'Thoát';

  @override
  String get sign_out_confirmation => 'Bạn có chắc muốn thoát không?';

  @override
  String get password => 'Mật khẩu';

  @override
  String get forgot_password => 'Quên mật khẩu';

  @override
  String get forgot_password_question => 'Quên mật khẩu?';

  @override
  String get view_profile => 'Xem hồ sơ';

  @override
  String get reset_password => 'Đặt lại mật khẩu';

  @override
  String get reset_password_explanation_text =>
      'Trong trường hợp quên mật khẩu, vui lòng điền tên đăng nhập hoặc địa chỉ email để nhận hướng dẫn đặt lại mật khẩu. Xin hãy kiểm tra cả hòm thư Spam.';

  @override
  String get username_or_email => 'Tên đăng nhập hoặc email';

  @override
  String get reset_password_done =>
      'Một email chứa liên kết đặt lại mật khẩu đã được gửi tới địa chỉ email liên kết với tài khoản của bạn. Vui lòng kiểm tra đồng thời hòm thư spam';

  @override
  String get send_reset_password_mail => 'Thay đổi mật khẩu';

  @override
  String get enter_some_text => 'Vui lòng nhập một vài kí tự';

  @override
  String get sign_up_page_title => 'Đăng ký';

  @override
  String get sign_up_page_action_button => 'Đăng ký';

  @override
  String get sign_up_page_action_doing_it => 'Đăng ký…';

  @override
  String get sign_up_page_action_ok =>
      'Chúc mừng! Tài khoản của bạn vừa được tạo.';

  @override
  String get sign_up_page_display_name_hint => 'Tên';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Vui lòng nhập tên hiển thị bạn muốn sử dụng';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'Email là bắt buộc';

  @override
  String get sign_up_page_email_error_invalid => 'Email không hợp lệ';

  @override
  String get sign_up_page_username_hint => 'Tên người dùng: Hiển thị công khai';

  @override
  String get sign_up_page_username_error_empty => 'Vui lòng nhập tên đăng nhập';

  @override
  String get sign_up_page_username_error_invalid =>
      'Vui lòng nhập tên đăng nhập hợp lệ';

  @override
  String get sign_up_page_username_description =>
      'Tên người dùng không được chứa dấu cách, chữ hoa hoặc ký tự đặc biệt.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Tên người dùng không được quá $value kí tự';
  }

  @override
  String get sign_up_page_password_hint => 'Mật khẩu';

  @override
  String get sign_up_page_password_error_empty => 'Vui lòng nhập mật khẩu';

  @override
  String get sign_up_page_password_error_invalid =>
      'Vui lòng nhập mật khẩu hợp lệ (ít nhất 6 kí tự)';

  @override
  String get sign_up_page_confirm_password_hint => 'Xác nhận mật khẩu';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Vui lòng xác nhận mật khẩu';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Mật khẩu không khớp';

  @override
  String get sign_up_page_agree_text => 'Tôi đồng ý với Thông tin Thực phẩm Mở';

  @override
  String get sign_up_page_terms_text => 'điều khoản sử dụng và đóng góp';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Khi tạo tài khoản, việc đồng ý với Điều khoản sử dụng là bắt buộc, tuy nhiên người dùng ẩn danh vẫn có thể đóng áp thông qua ứng dụng';

  @override
  String get sign_up_page_producer_checkbox => 'Tôi là nhà sản xuất thực phẩm';

  @override
  String get sign_up_page_producer_hint => 'Nhà sản xuất/thương hiệu';

  @override
  String get sign_up_page_producer_error_empty =>
      'Vui lòng nhập tên nhà sản xuất hoặc thương hiệu';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Tôi muốn đăng ký nhận bản tin Open Food Facts (Bạn có thể hủy đăng ký bất cứ lúc nào)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Tên người dùng đã tồn tại, vui lòng chọn tên người dùng khác.';

  @override
  String get sign_up_page_email_already_exists =>
      'đã tồn tại, đăng nhập vào tài khoản hoặc thử với một email khác.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Vui lòng cung cấp một địa chỉ email hợp lệ.';

  @override
  String get sign_up_page_server_busy =>
      'Chúng tôi rất tiếc, chúng tôi gặp một số khó khăn kỹ thuật khi tạo tài khoản cho bạn. Vui lòng thử lại sau.';

  @override
  String get settingsTitle => 'Cài đặt';

  @override
  String get darkmode => 'Giao diện';

  @override
  String get darkmode_dark => 'Tối';

  @override
  String get darkmode_light => 'Sáng';

  @override
  String get darkmode_system_default => 'Mặc định hệ thống';

  @override
  String get thanks_for_contributing => 'Cảm ơn bạn đã đóng góp!';

  @override
  String get contributors_label => 'Họ đang xây dựng ứng dụng';

  @override
  String get contributors_dialog_title => 'Người đóng góp';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Người đóng góp: $name';
  }

  @override
  String get contributors_description =>
      'Danh sách tất cả những người đóng góp cho ứng dụng này';

  @override
  String get support => 'Hỗ Trợ';

  @override
  String get support_join_slack =>
      'Yêu cầu hỗ trợ trên kênh Slack của chúng tôi';

  @override
  String get support_via_forum =>
      'Hãy yêu cầu trợ giúp trên diễn đàn của chúng tôi';

  @override
  String get support_via_email => 'Gửi email tới chúng tôi';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Gửi nhật ký ứng dụng?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Bạn có muốn đính kèm nhật ký ứng dụng vào email của mình không?';

  @override
  String get termsOfUse => 'Điều khoản sử dụng';

  @override
  String get legalNotices => 'Thông báo pháp lý';

  @override
  String get privacy_policy => 'Chính sách bảo mật';

  @override
  String get about_this_app => 'Thông tin về ứng dụng';

  @override
  String get contribute => 'Góp phần';

  @override
  String get contribute_sw_development => 'Phát triển phần mềm';

  @override
  String get contribute_develop_text =>
      'Mã nguồn của mọi sản phẩm Open Food Facts đều có sẵn trên GitHub. Bạn có thể tái sử dụng mã nguồn (mã nguồn mở) và giúp chúng tôi cải thiện nó, cho tất cả mọi người trên toàn hành tinh.';

  @override
  String get contribute_develop_text_2 =>
      'Bạn có thể tham gia phòng trò chuyện Slack Open Food Facts, đây là cách tốt nhất để đặt câu hỏi.';

  @override
  String get contribute_develop_dev_mode_title => 'Chế độ DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Kích hoạt Chế độ DEV';

  @override
  String get contribute_donate_title => 'Ủng hộ';

  @override
  String get contribute_donate_header => 'Quyên góp cho Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Xin lưu ý rằng với phiên bản alpha nội bộ, việc mất toàn bộ dữ liệu là có thể xảy ra và ứng dụng có thể không sử dụng được bất cứ lúc nào!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Các sản phẩm cần được hoàn thành';

  @override
  String get contribute_improve_header => 'Đang cải thiện';

  @override
  String get contribute_improve_text =>
      'Cơ sở dữ liệu là cốt lõi của dự án. Việc hỗ trợ rất dễ dàng và nhanh chóng. Bạn có thể tải xuống ứng dụng di động cho điện thoại của mình và bắt đầu thêm hoặc cải thiện sản phẩm.\n\nMặt khác, trang web Open Food Facts cung cấp nhiều cách để đóng góp: ';

  @override
  String get contribute_translate_header => 'Dịch';

  @override
  String get contribute_data_quality => 'Chất lượng số liệu';

  @override
  String get contribute_translate_link_text => 'Bắt đầu dịch';

  @override
  String get contribute_translate_text =>
      'Open Food Facts là một dự án toàn cầu, bao gồm các sản phẩm từ hơn 160 quốc gia. Open Food Facts được dịch sang hàng chục ngôn ngữ, với nội dung liên tục được cập nhật.';

  @override
  String get contribute_translate_text_2 =>
      'Phiên dịch là một trong những nhiệm vụ trọng tâm của dự án';

  @override
  String get contribute_join_skill_pool =>
      'Đóng góp kỹ năng của bạn cho Open Food Facts. Hãy tham gia nhóm kỹ năng!';

  @override
  String get contribute_share_header =>
      'Chia sẻ Thông tin Thực phẩm Mở với bạn bè của bạn';

  @override
  String get contribute_share_content =>
      'Tôi muốn giới thiệu với bạn về ứng dụng tôi đang sử dụng, Open Food Facts, cho phép bạn xem thông tin về tác động của thực phẩm đến sức khỏe và môi trường theo cách cá nhân hóa. Ứng dụng hoạt động bằng cách quét mã vạch trên bao bì. Cuối cùng, ứng dụng này hoàn toàn miễn phí, không yêu cầu đăng ký, và bạn thậm chí có thể giúp tăng số lượng sản phẩm được giải mã. Đây là liên kết để tải ứng dụng về điện thoại của bạn: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Đóng góp giá bằng cách yêu cầu xuất dữ liệu thẻ khách hàng thân thiết của bạn theo GDPR';

  @override
  String get tap_to_answer => 'Nhấn vào đây để trả lời câu hỏi';

  @override
  String get tap_to_answer_hint =>
      'Nhấn vào đây để trả lời các câu hỏi về sản phẩm này';

  @override
  String get robotoff_questions_loading_hint =>
      'Vui lòng chờ trong khi các câu hỏi về sản phẩm này được tải';

  @override
  String get saving_answer => 'Lưu câu trả lời của bạn';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Đăng nhập vào tài khoản Open Food Facts của bạn để nhận được tín dụng cho những đóng góp của bạn';

  @override
  String get question_yes_button_accessibility_value => 'Có';

  @override
  String get question_no_button_accessibility_value => 'Không';

  @override
  String get question_skip_button_accessibility_value => 'Bỏ qua câu hỏi này';

  @override
  String get tap_to_edit_search => 'Chạm để chỉnh sửa tìm kiếm';

  @override
  String get myPreferences => 'Tuỳ chọn của tôi';

  @override
  String get account_create_message =>
      'Tạo tài khoản và tham gia cộng đồng Open Food Facts để góp phần xây dựng kiến thức về thực phẩm trên toàn thế giới!';

  @override
  String get join_us => 'Tham gia ngay';

  @override
  String get myPreferences_profile_title => 'Thông tin của bạn';

  @override
  String get myPreferences_profile_subtitle =>
      'Quản lý tài khoản cộng tác viên Open Food Facts của bạn.';

  @override
  String get myPreferences_settings_title => 'Cài đặt ứng dụng';

  @override
  String get myPreferences_settings_subtitle => 'Chế độ tối, Ngôn ngữ…';

  @override
  String get myPreferences_food_title => 'Sở thích ăn uống';

  @override
  String get myPreferences_food_subtitle =>
      'Chọn loại thông tin về thực phẩm quan trọng nhất đối với bạn.';

  @override
  String get myPreferences_food_comment =>
      'Chọn thông tin về thực phẩm quan trọng nhất với bạn để xếp hạng thực phẩm theo sở thích, xem thông tin bạn quan tâm trước và nhận tóm tắt về khả năng tương thích. Những sở thích về thực phẩm đó sẽ được lưu trên thiết bị của bạn và không được liên kết với tài khoản cộng tác viên Open Food Facts của bạn (nếu có).';

  @override
  String get confirmResetPreferences => 'Đặt lại sở thích ăn uống của bạn?';

  @override
  String get myPersonalizedRanking => 'Xếp hạng cá nhân của tôi';

  @override
  String get ranking_tab_all => 'Tất cả';

  @override
  String get ranking_subtitle_match_yes => 'Phù hợp nhất cho bạn';

  @override
  String get ranking_subtitle_match_no => 'Độ phù hợp thấp';

  @override
  String get ranking_subtitle_match_maybe => 'Độ phù hợp không xác định';

  @override
  String get refresh_with_new_preferences =>
      'Làm mới danh sách với các tùy chọn mới của bạn';

  @override
  String get reloaded_with_new_preferences => 'Đã tải lại với các tùy chọn mới';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Quét';

  @override
  String get history_navbar_label => 'Lịch sử';

  @override
  String get list_navbar_label => 'Danh sách';

  @override
  String get category => 'Lọc theo danh mục';

  @override
  String get category_all => 'Tất cả';

  @override
  String get category_search => '(tìm kiếm danh mục)';

  @override
  String get filter => 'Bộ lọc';

  @override
  String get scan => 'Sản phẩm từ màn hình Quét';

  @override
  String get scan_history => 'Lịch sử quét';

  @override
  String get search => 'Tìm kiếm';

  @override
  String get search_product_help =>
      'Tìm kiếm sản phẩm,\nthương hiệu hoặc mã vạch';

  @override
  String get search_filter => 'Bộ lọc tìm kiếm';

  @override
  String get search_history => 'Lịch sử tìm kiếm';

  @override
  String get search_store => 'Tìm kiếm một cửa hàng';

  @override
  String get search_store_help => 'Gợi ý: thêm thành phố hoặc quốc gia';

  @override
  String get tap_for_more => 'Nhấn để xem thêm thông tin…';

  @override
  String get product => 'Sản phẩm';

  @override
  String get unknownBrand => 'Thương hiệu không xác định';

  @override
  String get unknownQuantity => 'Số lượng không xác định';

  @override
  String get unknownProductName => 'Tên sản phẩm không xác định';

  @override
  String get label_refresh => 'Làm mới';

  @override
  String get label_reload => 'Tải lại';

  @override
  String get image => 'Hình ảnh';

  @override
  String get front_photo => 'Ảnh mặt trước';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (hình ảnh này có thể đã lỗi thời)';
  }

  @override
  String get outdated_image_short_label => 'có thể đã lỗi thời';

  @override
  String get ingredients => 'Thành phần';

  @override
  String get ingredients_editing_instructions =>
      'Giữ nguyên thứ tự ban đầu. Ghi rõ phần trăm khi được chỉ định. Phân cách bằng dấu phẩy hoặc dấu gạch ngang và sử dụng dấu ngoặc đơn cho các thành phần của một nguyên liệu.';

  @override
  String get ingredients_editing_error => 'Không thể lưu các thành phần.';

  @override
  String get ingredients_editing_image_error =>
      'Không lấy được hình ảnh nguyên liệu mới.';

  @override
  String get ingredients_editing_title => 'Chỉnh sửa nguyên liệu';

  @override
  String get ingredients_photo => 'Ảnh chụp thành phần';

  @override
  String get packaging_editing_instructions =>
      'Liệt kê tất cả các phần đóng gói, phân tách bằng dấu phẩy hoặc gạch chéo, kèm theo số lượng (ví dụ 1 hoặc 6), loại (ví dụ chai, hộp, lon), chất liệu ( ví dụ nhựa, kim loại, nhôm), kích thước nếu có (ví dụ 33cl) và hướng dẫn tái chế.\nVí dụ 1 chai thủy tinh tái chế, 1 nút chai nhựa cần loại bỏ';

  @override
  String get packaging_editing_error => 'Lỗi lưu ảnh bao bì.';

  @override
  String get packaging_editing_image_error => 'Không thể lấy ảnh bao bì mới.';

  @override
  String get packaging_editing_title => 'Chỉnh sửa bao bì';

  @override
  String get nutrition => 'Dinh dưỡng';

  @override
  String get nutrition_facts_photo => 'Ảnh chụp thông tin dinh dưỡng';

  @override
  String get nutrition_facts_editing_title => 'Chỉnh sửa thông tin dinh dưỡng';

  @override
  String get packaging_information => 'Hướng dẫn tái chế';

  @override
  String get packaging_information_photo => 'Ảnh hướng dẫn tái chế';

  @override
  String get missing_product => 'Bạn đã tìm thấy một sản phẩm mới!';

  @override
  String get add_product_take_photos =>
      'Chụp ảnh bao bì để thêm sản phẩm này vào Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Đầu tiên xin vui lòng chụp một số hình ảnh. Bạn luôn có thể hoàn thiện thông tin sản phẩm sau đó.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'Sản phẩm mới';

  @override
  String get new_product_found_title => 'Đã tìm thấy sản phẩm mới!';

  @override
  String get new_product_found_text =>
      'Cơ sở dữ liệu cộng tác của chúng tôi chứa hơn **3 triệu sản phẩm**, nhưng mã vạch này không tồn tại: ';

  @override
  String get new_product_found_button => 'Thêm sản phẩm này';

  @override
  String get new_product_leave_title => 'Rời khỏi trang này?';

  @override
  String get new_product_leave_message =>
      'Có vẻ như bạn chưa không nhập bất cứ thứ gì. Bạn có thực sự muốn rời khỏi trang này?';

  @override
  String get new_product_dialog_description =>
      'Vui lòng chụp ảnh bao bì để thêm sản phẩm này vào cơ sở dữ liệu chung của chúng tôi';

  @override
  String get new_product_dialog_illustration_description =>
      'Một hình minh họa với Nutri-Score và Green Score chưa biết';

  @override
  String get front_packaging_photo_button_label => 'Ảnh mặt trước sản phẩm';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Xác nhận tải lên ảnh trước của Sản phẩm';

  @override
  String get confirm_button_label => 'Xác nhận';

  @override
  String get send_image_button_label => 'Gửi ảnh';

  @override
  String get crop_page_action_saving => 'Đang lưu ảnh…';

  @override
  String get crop_page_action_cropping => 'Đang cắt hình ảnh…';

  @override
  String get crop_page_action_local => 'Đang lưu phiên bản cục bộ…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ồ… có gì đó trong ảnh của bạn!';

  @override
  String get crop_page_action_local_failed_message =>
      'Chúng tôi không thể xử lý hình ảnh cục bộ trước khi gửi đến máy chủ. Vui lòng thử lại sau hoặc liên hệ với chúng tôi nếu sự cố vẫn tiếp diễn.';

  @override
  String get crop_page_action_retake => 'Chụp lại ảnh';

  @override
  String get crop_page_too_small_image_title => 'Hình ảnh quá nhỏ!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Kích thước tối thiểu tính bằng pixel để tải ảnh lên là ${expectedMinWidth}x$expectedMinHeight. Ảnh hiện tại là ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Chuẩn bị cuộc gọi đến máy chủ…';

  @override
  String get front_packaging_photo_title => 'Ảnh bao bì phía trước';

  @override
  String get ingredients_photo_title => 'Ảnh thành phần';

  @override
  String get nutritional_facts_photo_title => 'Ảnh chụp thông tin dinh dưỡng';

  @override
  String get recycling_photo_title => 'Hướng dẫn tái chế (Ảnh)';

  @override
  String get take_photo_title => 'Chụp ảnh';

  @override
  String get take_more_photo_title => 'Chụp thêm ảnh';

  @override
  String get front_photo_uploaded => 'Đã tải ảnh mặt trước lên';

  @override
  String get ingredients_photo_button_label => 'Ảnh chụp thành phần';

  @override
  String get ingredients_photo_uploaded => 'Đã tải ảnh thành phần lên';

  @override
  String get nutrition_cache_loading_error =>
      'Không thể tải thông tin dinh dưỡng từ bộ nhớ sản phẩm';

  @override
  String get nutritional_facts_photo_button_label =>
      'Ảnh chụp thông tin dinh dưỡng';

  @override
  String get nutritional_facts_input_button_label =>
      'Thêm vào thông tin dinh dưỡng';

  @override
  String get nutritional_facts_added => 'Thông tin dinh dưỡng đã được thêm';

  @override
  String get categories_added => 'Đã thêm danh mục';

  @override
  String get new_product_title_nutriscore => 'Tính toán Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Tính điểm bằng cách điền danh mục thực phẩm và các giá trị dinh dưỡng';

  @override
  String get new_product_title_environmental_score => 'Tính Điểm Xanh';

  @override
  String get new_product_subtitle_environmental_score =>
      'Nhận được nó bằng cách điền vào ít nhất một danh mục';

  @override
  String get new_product_additional_environmental_score =>
      'Làm cho tính toán Điểm Xanh chính xác hơn với nguồn gốc, bao bì và nhiều hơn nữa';

  @override
  String get new_product_title_nova =>
      'Tính toán mức độ chế biến thực phẩm (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Nhận nó bằng cách điền vào danh mục thực phẩm và thành phần';

  @override
  String get new_product_desc_nova_unknown =>
      'Mức độ chế biến thực phẩm không xác định';

  @override
  String get new_product_title_pictures => 'Hãy chụp một vài bức ảnh!';

  @override
  String get new_product_title_pictures_details =>
      'Vui lòng chụp những bức ảnh sau và công cụ Open Food Facts sẽ tự động tính toán phần còn lại!';

  @override
  String get new_product_title_misc => 'Và một số dữ liệu cơ bản…';

  @override
  String new_product_done_msg(String username) {
    return 'Cảm ơn bạn đã đóng góp “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Cảm ơn sự đóng góp của bạn!';

  @override
  String get new_product_done_button_label => 'Khám phá sản phẩm đã hoàn thành';

  @override
  String get hey_incomplete_product_message =>
      'Nhấn để trả lời 3 câu hỏi NGAY để tính Nutri-Score, Điểm xanh và Chế biến siêu tốc (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Nhấn ngay để trả lời 2 câu hỏi giúp phân tích sản phẩm mỹ phẩm này!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Nhấn ngay để trả lời 3 câu hỏi giúp phân tích sản phẩm thức ăn cho thú cưng này!';

  @override
  String get hey_incomplete_product_message_product =>
      'Nhấn ngay để hoàn thiện sản phẩm này!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Ảnh thông tin dinh dưỡng đã được tải lên';

  @override
  String get recycling_photo_button_label => 'Ảnh thông tin tái chế';

  @override
  String get recycling_photo_uploaded =>
      'Ảnh thông tin tái chế đã được tải lên';

  @override
  String get take_more_photo_button_label => 'Chụp thêm ảnh';

  @override
  String get other_photo_uploaded => 'Ảnh hỗn hợp đã được tải lên';

  @override
  String get retake_photo_button_label => 'Chụp lại';

  @override
  String get selecting_photo => 'Chọn ảnh';

  @override
  String get uploading_image => 'Đang tải ảnh lên hệ thống';

  @override
  String get uploading_image_type_front =>
      'Đang tải hình ảnh mặt trước lên Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Tải hình ảnh thành phần lên Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Đang tải hình ảnh dinh dưỡng lên Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Đang tải hình ảnh bao bì lên Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Tải lên hình ảnh khác lên Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Đang tải hình ảnh lên Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Thêm các thành phần còn thiếu';

  @override
  String get score_add_missing_packaging_image =>
      'Thêm hình ảnh bao bì bị thiếu';

  @override
  String get score_add_missing_nutrition_facts =>
      'Thêm thông tin dinh dưỡng còn thiếu';

  @override
  String get score_add_missing_product_traces =>
      'Thêm dấu vết sản phẩm bị thiếu';

  @override
  String get score_add_missing_product_category =>
      'Thêm danh mục sản phẩm bị thiếu';

  @override
  String get score_add_missing_precise_product_category =>
      'Chọn một danh mục chính xác hơn';

  @override
  String get score_add_missing_product_countries =>
      'Thêm quốc gia sản phẩm bị thiếu';

  @override
  String get score_add_missing_product_emb =>
      'Thêm mã truy xuất nguồn gốc sản phẩm còn thiếu';

  @override
  String get score_add_missing_product_labels => 'Thêm nhãn sản phẩm còn thiếu';

  @override
  String get score_add_missing_product_origins =>
      'Thêm nguồn gốc sản phẩm còn thiếu';

  @override
  String get score_add_missing_product_stores =>
      'Thêm cửa hàng bán sản phẩm còn thiếu';

  @override
  String get score_add_missing_product_brands =>
      'Thêm các thương hiệu sản phẩm còn thiếu';

  @override
  String get score_update_nutrition_facts => 'Cập nhật thông tin dinh dưỡng';

  @override
  String get nutrition_page_title => 'Giá trị dinh dưỡng';

  @override
  String get nutrition_page_nutritional_info_title => 'Thông tin dinh dưỡng';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Các giá trị được chỉ định trên sản phẩm:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Có';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Không';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Mở ảnh';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Thực hành tốt: Thông tin dinh dưỡng';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Đôi khi thông tin dinh dưỡng **không được ghi rõ trên bao bì** hoặc trên tài liệu đi kèm sản phẩm. Trong trường hợp này, và chỉ trong trường hợp này, bạn có thể đặt giá trị thành **KHÔNG**.';

  @override
  String get nutrition_page_serving_type_label => 'Giá trị dinh dưỡng:';

  @override
  String get nutrition_page_per_100g => 'mỗi 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'trên 100g/ml';

  @override
  String get nutrition_page_per_serving => 'mỗi khẩu';

  @override
  String get nutrition_page_add_nutrient => 'Thêm chất dinh dưỡng';

  @override
  String get nutrition_page_serving_size => 'Kích thước phục vụ';

  @override
  String get nutrition_page_serving_size_hint =>
      'Nhập khẩu phần ăn (ví dụ: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Thực hành tốt: Khẩu phần ăn';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Giá trị này giúp **tính toán tỷ lệ từng chất dinh dưỡng trên mỗi khẩu phần**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Các đơn vị được phép** là: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** hoặc **60 G** (ưu tiên loại đầu tiên)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** hoặc **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Đơn vị không hợp lệ';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Đơn vị không hợp lệ';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **kẹo** và 2 **bánh quy**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Đơn vị bị thiếu';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Số không hợp lệ';

  @override
  String get nutrition_page_update_running =>
      'Đang cập nhật sản phẩm trên máy chủ…';

  @override
  String get nutrition_page_update_done => 'Sản phẩm được cập nhật!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Sử dụng số lượng sản phẩm làm khẩu phần ăn';

  @override
  String get nutrition_page_photo_error => 'Không thể tải ảnh';

  @override
  String get more_photos => 'Nhiều hình ảnh thú vị hơn';

  @override
  String get view_more_photo_button =>
      'Xem tất cả ảnh hiện có cho sản phẩm này';

  @override
  String get no_product_found => 'Không tìm thấy sản phẩm';

  @override
  String get no_location_found => 'Không tìm thấy vị trí';

  @override
  String get not_found => 'không tìm thấy:';

  @override
  String get refreshing_product => 'Làm mới sản phẩm';

  @override
  String get product_refreshed => 'Sản phẩm đã được làm mới';

  @override
  String product_image_accessibility_label(String date) {
    return 'Hình ảnh được chụp vào ngày $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Hình ảnh được chụp vào ngày $date. Hình ảnh này có thể đã lỗi thời';
  }

  @override
  String get product_image_outdated => 'Hình ảnh này có thể đã lỗi thời';

  @override
  String get product_image_outdated_explanations_title =>
      'Hình ảnh này có thể đã lỗi thời';

  @override
  String get product_image_outdated_explanations_content =>
      'Hình ảnh này được chụp cách đây hơn một năm.\n**Vui lòng kiểm tra xem hình ảnh có còn được cập nhật không**.\n\nĐây **chỉ là một cảnh báo**. Nếu nội dung vẫn như cũ, bạn có thể bỏ qua thông báo này.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Thay thế ảnh ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Thêm ảnh ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Chụp mới';

  @override
  String get product_image_action_take_picture => 'Chụp ảnh';

  @override
  String get product_image_action_from_gallery =>
      'Chọn từ thư viện ảnh trên điện thoại của bạn';

  @override
  String get product_image_action_choose_existing_photo =>
      'Chọn từ ảnh sản phẩm';

  @override
  String get product_image_details_label => 'Thông tin về bức ảnh';

  @override
  String get product_image_details_from_producer => 'Từ nhà sản xuất';

  @override
  String get product_image_details_contributor => 'Người đóng góp';

  @override
  String get product_image_details_contributor_producer =>
      'Người đóng góp (nhà sản xuất)';

  @override
  String get product_image_details_date => 'Ngày';

  @override
  String get product_image_details_date_unknown => 'Không biết';

  @override
  String get homepage_main_card_logo_description =>
      'Chào mừng đến với Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Quét** mã vạch hoặc\n**tìm kiếm** sản phẩm';

  @override
  String get homepage_main_card_search_field_hint => 'Tìm kiếm sản phẩm';

  @override
  String get homepage_main_card_search_field_tooltip => 'Bắt đầu tìm kiếm';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Tin tức mới nhất: $news_title';
  }

  @override
  String get tagline_app_review => 'Bạn có thích ứng dụng này không?';

  @override
  String get tagline_app_review_button_positive => 'Tôi thích nó! 😍';

  @override
  String get tagline_app_review_button_negative => 'Không hẳn vậy…';

  @override
  String get tagline_app_review_button_later => 'Hỏi tôi sau nhé';

  @override
  String get tagline_feed_news_button => 'Tìm hiểu thêm';

  @override
  String get app_review_negative_modal_title =>
      'Bạn không thích ứng dụng của chúng tôi?';

  @override
  String get app_review_negative_modal_text =>
      'Bạn có thể dành vài giây để cho chúng tôi biết lý do không?';

  @override
  String get app_review_negative_modal_positive_button => 'Có, chắc chắn rồi!';

  @override
  String get app_review_negative_modal_negative_button => 'Không';

  @override
  String get could_not_refresh => 'Không thể làm mới sản phẩm';

  @override
  String get product_internet_error_modal_title => 'Đã xảy ra lỗi!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Chúng tôi không thể tìm kiếm thông tin về sản phẩm này do lỗi mạng. Vui lòng kiểm tra kết nối internet của bạn và thử lại.\n\nLỗi nội bộ:\n$error';
  }

  @override
  String get product_tags_title => 'Tính chất sản phẩm';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Không có thuộc tính';

  @override
  String get product_tags_explanation =>
      'Bằng cách thêm thuộc tính (khóa/giá trị) vào sản phẩm, bạn giúp làm phong phú thêm sản phẩm đó.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Thêm thuộc tính';

  @override
  String get add_edit_tags => 'Thêm hoặc chỉnh sửa thuộc tính';

  @override
  String get edit_tag => 'Chỉnh sửa thuộc tính';

  @override
  String get remove_tag => 'Xóa thuộc tính';

  @override
  String get tag_key => 'Tài sản';

  @override
  String get tag_keys => 'Của cải';

  @override
  String get tag_key_uneditable => 'Thuộc tính (không thể chỉnh sửa)';

  @override
  String get tag_key_input_hint => 'Nhập một thuộc tính';

  @override
  String get tag_value => 'Giá trị';

  @override
  String get tag_values => 'Giá trị';

  @override
  String get tag_value_input_hint => 'Nhập một giá trị';

  @override
  String get tag_key_item => 'Tài sản:';

  @override
  String get tag_value_item => 'Giá trị:';

  @override
  String get tag_key_explanations =>
      'Khóa phải viết thường và không có khoảng trắng.';

  @override
  String tag_key_already_exists(String property) {
    return 'Thẻ có thuộc tính $property đã tồn tại!';
  }

  @override
  String get product_internet_error =>
      'Không thể nạp thông tin về sản phẩm này do lỗi kết nối mạng.';

  @override
  String get cached_results_from => 'Hiển thị kết quả từ:';

  @override
  String get product_search_same_category => 'Tìm giải pháp thay thế';

  @override
  String get product_search_same_category_short => 'So sánh';

  @override
  String get product_search_same_category_error =>
      'Tính năng này chỉ có thể sử dụng cho các sản phẩm có danh mục.\n\nVui lòng chỉnh sửa sản phẩm để thêm danh mục.';

  @override
  String get product_improvement_add_category =>
      'Thêm danh mục để tính Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Thêm thông tin dinh dưỡng để tính điểm Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Thêm thông tin dinh dưỡng và danh mục để tính Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Không thể tính được Nutri-Score cho sản phẩm này, có thể do danh mục không đạt tiêu chuẩn. Nếu đây là lỗi, vui lòng liên hệ với chúng tôi.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Hình ảnh dinh dưỡng đã quá hạn: vui lòng cập nhật.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Điểm Xanh có tính đến nguồn gốc của các thành phần. Vui lòng chụp ảnh danh sách thành phần và/hoặc bất kỳ thông tin địa lý nào hoặc chỉnh sửa sản phẩm để chúng tôi có thể xem xét.';

  @override
  String get country_chooser_label => 'Vui lòng chọn quốc gia';

  @override
  String get currency_chooser_label => 'Vui lòng chọn loại tiền tệ';

  @override
  String get country_change_message => 'Bạn vừa thay đổi quốc gia.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Bạn có muốn đổi đơn vị tiền tệ từ $previousCurrency sang ${possibleCurrency}không?';
  }

  @override
  String get onboarding_country_chooser_label => 'Vui lòng chọn một quốc gia:';

  @override
  String get country_chooser_label_from_settings => 'Đất nước của bạn';

  @override
  String get country_selection_explanation =>
      'Một số đặc điểm môi trường là đặc thù địa lý';

  @override
  String get product_removed_comparison =>
      'Sản phẩm bị gỡ bỏ khỏi phần so sánh';

  @override
  String get native_app_settings => 'Cài đặt ứng dụng gốc';

  @override
  String get native_app_description =>
      'Cài đặt hệ thống mở cho Open Food Facts';

  @override
  String get product_removed_history => 'Sản phẩm bị xóa khỏi lịch sử';

  @override
  String get product_removed_list => 'Sản phẩm đã bị xóa khỏi danh sách';

  @override
  String get product_could_not_remove => 'Không thể loại bỏ sản phẩm';

  @override
  String get no_prodcut_in_list => 'Không có sản phẩm nào trong danh sách này';

  @override
  String get no_product_in_section => 'Không có sản phẩm nào trong phần này';

  @override
  String get recently_seen_products => 'Tất cả sản phẩm đã xem';

  @override
  String get clear => 'Xóa';

  @override
  String get clear_long => 'Làm trống danh sách';

  @override
  String get really_clear => 'Bạn có thực sự muốn xoá danh sách này?';

  @override
  String pct_match(Object percent) {
    return '$percent% phù hợp';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ngày trước',
      one: 'một ngày trước',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count giờ trước',
      one: 'một giờ trước',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count phút trước',
      one: 'một phút trước',
      zero: 'gần một phút trước',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tháng trước',
      one: 'một tháng trước',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tuần trước',
      one: 'một tuần trước',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'So sánh $count sản phẩm',
      one: 'So sánh một sản phẩm',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count sản phẩm được chọn',
      one: 'Một sản phẩm được chọn',
      zero: 'Không có sản phẩm nào được chọn',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'So sánh các sản phẩm đã chọn';

  @override
  String get delete_products_mode => 'Xóa sản phẩm đã chọn';

  @override
  String get select_all_products_mode => 'Chọn tất cả sản phẩm';

  @override
  String get select_none_products_mode => 'Chọn không có';

  @override
  String get compare_products_appbar_title => 'So sánh sản phẩm';

  @override
  String get compare_products_appbar_subtitle =>
      'Xin vui lòng chọn ít nhất hai sản phẩm';

  @override
  String get retry_button_label => 'Thử lại';

  @override
  String get connect_with_us => 'Kết nối với chúng tôi';

  @override
  String get tiktok => 'Theo dõi chúng tôi trên TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Theo dõi chúng tôi trên Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Theo dõi chúng tôi trên X (trước đây là Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Theo dõi chúng tôi trên Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Theo dõi chúng tôi trên BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => 'Khám phá';

  @override
  String get how_to_contribute => 'Làm thế nào để đóng góp';

  @override
  String get hint_knowledge_panel_message =>
      'Bạn có thể nhấn vào bất kì vị trí nào trên thẻ để xem chi tiết hơn về những gì bạn đang xem. Thử ngay!';

  @override
  String get permissions_page_title => 'Truy cập máy ảnh';

  @override
  String get permissions_page_body1 =>
      'Để quét mã vạch với máy ảnh của bạn, vui lòng Cấp quyền truy cập.';

  @override
  String get permissions_page_body2 =>
      'Nếu bạn thay đổi ý định, lựa chọn này có thể được bật hoặc tắt bất kì lúc nào trong phần cài đặt.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Phát hành: $release)\nMẫu: $model\nSản phẩm: $product\nThiết bị: $device\nNhãn hiệu:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nMẫu: $model\nMẫu bản địa hóa: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nPhiên bản ứng dụng:$appVersion\nBản dựng ứng dụng số:$appBuildNumber\nTên gói ứng dụng:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Cho phép';

  @override
  String get refuse_button_label => 'Từ chối';

  @override
  String get ask_me_later_button_label => 'Để sau';

  @override
  String get are_you_sure => 'Bạn chắc chứ?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Nhiều hơn trên $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Chào mừng !';

  @override
  String get onboarding_home_welcome_text2 =>
      'Ứng dụng giúp bạn lựa chọn thực phẩm tốt cho **bạn** và **hành tinh**!';

  @override
  String get onboarding_continue_button => 'Tiếp tục';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Đang tải lên sản phẩm mẫu đầu tiên của bạn';

  @override
  String get onboarding_welcome_warning =>
      'Xin lỗi, đây là sản phẩm mẫu của chúng tôi, bạn không thể chỉnh sửa nó :)';

  @override
  String get product_list_your_ranking => 'Xếp hạng của bạn';

  @override
  String get product_list_empty_icon_desc => 'Lịch sử không có sẵn';

  @override
  String get product_list_empty_title => 'Bắt đầu quét';

  @override
  String get product_list_empty_message =>
      'Các sản phẩm bạn quét sẽ xuất hiện ở đây và bạn có thể kiểm tra thông tin chi tiết về chúng';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'sản phẩm',
      one: 'sản phẩm',
      zero: 'sản phẩm',
    );
    return 'Làm mới $_temp0 trong lịch sử của bạn';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'sản phẩm',
      one: 'Sản phẩm',
      zero: 'Sản phẩm',
    );
    return '$_temp0 làm mới hoàn thành';
  }

  @override
  String get product_list_compare_side_by_side => 'So sánh cạnh nhau';

  @override
  String get loading_dialog_default_title => 'Đang tải xuống dữ liệu';

  @override
  String get loading_dialog_default_error_message => 'Không thể tải dữ liệu';

  @override
  String get account_delete => 'Xoá tài khoản';

  @override
  String get account_delete_title => 'Xóa tài khoản của tôi';

  @override
  String get user_profile => 'Tài khoản';

  @override
  String get user_profile_title_guest => 'Xin chào!';

  @override
  String get user_profile_subtitle_guest =>
      'Đăng nhập hoặc đăng ký để tham gia cộng đồng Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Mở thông tin đăng nhập Thực phẩm: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Chào mừng $id!';
  }

  @override
  String get email_subject_account_deletion => 'Xoá tài khoản';

  @override
  String email_body_account_deletion(String userId) {
    return 'Xin chào, vui lòng xóa tài khoản Open Food Facts của tôi: $userId';
  }

  @override
  String get settings_app_app => 'Ứng dụng';

  @override
  String get settings_app_data => 'Quyền riêng tư và giám sát';

  @override
  String get settings_app_camera => 'Máy ảnh';

  @override
  String get settings_app_products => 'Sản phẩm';

  @override
  String get settings_app_miscellaneous => 'Các tùy chọn khác';

  @override
  String get camera_play_sound_title => 'Phát âm thanh khi quét';

  @override
  String get camera_play_sound_subtitle =>
      'Có tiếng bíp mỗi lần quét thành công';

  @override
  String get camera_window_accessibility_label =>
      'Quét mã vạch bằng máy ảnh của bạn';

  @override
  String get app_haptic_feedback_title => 'Rung & Phản hồi';

  @override
  String get app_haptic_feedback_subtitle =>
      'Rung sau khi thực hiện một số hành động (giải mã mã vạch, xóa bỏ sản phẩm…).';

  @override
  String get crash_reporting_toggle_title => 'Báo cáo lỗi';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Khi được bật, báo cáo sự cố sẽ tự động được gửi đến hệ thống theo dõi lỗi của Open Food Facts để sửa lỗi và cải thiện ứng dụng.';

  @override
  String get send_anonymous_data_toggle_title => 'Gửi dữ liệu ẩn danh';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Chỉnh sửa ảnh';

  @override
  String get permission_photo_error => 'Lỗi';

  @override
  String get permission_photo_denied_title =>
      'Cho phép sử dụng máy ảnh để quét mã vạch';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Để có trải nghiệm nâng cao, vui lòng cho phép $appName truy cập vào máy ảnh của bạn. Bạn sẽ có thể quét trực tiếp mã vạch.';
  }

  @override
  String get permission_photo_denied_button => 'Cho phép';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Quyền truy cập bị từ chối';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Vì trước đây bạn đã từ chối quyền đối với máy ảnh, bạn phải cho phép nó theo cách thủ công từ Cài đặt.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Mở cài đặt';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Huỷ';

  @override
  String get permission_photo_none_found => 'Không phát hiện thấy camera';

  @override
  String get permission_photo_denied => 'Không có quyền truy cập máy ảnh';

  @override
  String get show_product_pictures => 'Hiển thị hình ảnh sản phẩm';

  @override
  String get edit_product_label => 'Chỉnh sửa sản phẩm';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Đang tải lên các chỉnh sửa của bạn…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Các chỉnh sửa của bạn đang được **gửi ở chế độ nền** (hoặc sau đó trong trường hợp có lỗi).\nBạn có thể tiếp tục chỉnh sửa các trường sản phẩm khác.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Các chỉnh sửa của bạn đang được **gửi ở chế độ nền** (hoặc sau đó trong trường hợp có lỗi).';

  @override
  String get edit_product_label_short => 'Chỉnh sửa';

  @override
  String edit_product_form_item_help(String value) {
    return 'Làm thế nào để nhập \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Vui lòng nhập giá trị không để trống!';

  @override
  String get edit_product_form_item_error_existing => 'Giá trị này đã có rồi!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Thêm một thương hiệu mới';

  @override
  String get edit_product_form_item_add_action_label => 'Thêm nhãn mới';

  @override
  String get edit_product_form_item_add_action_store => 'Thêm một cửa hàng mới';

  @override
  String get edit_product_form_item_add_action_origin => 'Thêm nguồn gốc mới';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Thêm mã truy xuất nguồn gốc mới';

  @override
  String get edit_product_form_item_add_action_country =>
      'Thêm một quốc gia mới';

  @override
  String get edit_product_form_item_add_action_category =>
      'Thêm một danh mục mới';

  @override
  String get edit_product_form_item_add_action_trace => 'Thêm một dấu vết mới';

  @override
  String get edit_product_form_item_add_suggestion => 'Thêm gợi ý';

  @override
  String get edit_product_form_item_deny_suggestion => 'Từ chối đề xuất';

  @override
  String get edit_product_form_item_details_title => 'Thông tin cơ bản';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Tên sản phẩm, thương hiệu, số lượng';

  @override
  String get edit_product_form_item_other_details_title =>
      'Thông tin chi tiết bổ sung';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Trang web…';

  @override
  String get edit_product_form_item_photos_title => 'Ảnh';

  @override
  String get edit_product_form_item_photos_subtitle => 'Thêm hoặc làm mới ảnh';

  @override
  String get edit_product_form_item_labels_title => 'Nhãn & Giấy chứng nhận';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Nhãn môi trường, chất lượng…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Nhập nhãn (ví dụ: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'nhãn hiệu';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Thực hành tốt: Nhãn';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Bất kỳ đặc điểm nào của sản phẩm **có thật** và khác biệt so với các lĩnh vực khác.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Điểm số dinh dưỡng, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Sản xuất tại Bỉ, sản xuất tại Brittany…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Giàu chất xơ, nguồn cung cấp sắt…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Giao dịch công bằng, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Cửa hàng';

  @override
  String get edit_product_form_item_stores_hint => 'Nhập một cửa hàng';

  @override
  String get edit_product_form_item_stores_type => 'cửa hàng';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Thực hành tốt: Cửa hàng';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Nhập cửa hàng nơi bạn đã mua sản phẩm.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Nguồn gốc';

  @override
  String get edit_product_form_item_origins_hint =>
      'Nhập nguồn gốc (ví dụ: Đức)';

  @override
  String get edit_product_form_item_origins_type => 'nước';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Thực hành tốt: Nguồn gốc';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Thêm **bất kỳ thông tin nào về nguồn gốc mà bạn có thể tìm thấy trên bao bì**.\nBạn không cần phải lo lắng về nguồn gốc được ghi trực tiếp trong danh sách thành phần.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Thịt bò từ Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Đậu nành không đến từ Liên minh Châu Âu';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Nhập một quốc gia (ví dụ: Đức)';

  @override
  String get edit_product_form_item_countries_type => 'nước';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Thực hành tốt: Các quốc gia';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Các quốc gia nơi sản phẩm được bán rộng rãi** (không bao gồm các cửa hàng chuyên bán sản phẩm nước ngoài).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Mã xác định nguồn gốc';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Nhập mã (ví dụ: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'mã truy xuất nguồn gốc';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Thực hành tốt: Mã truy xuất nguồn gốc';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Trong phần này, bạn có thể nhập mã liên quan đến **dấu hiệu bao bì**, **dấu hiệu nhận dạng** hoặc **dấu hiệu sức khỏe**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Ví dụ về mã truy xuất nguồn gốc';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Mã EC** được sử dụng trong Cộng đồng Châu Âu để xác định nhà sản xuất hoặc nhà đóng gói thực phẩm:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: mã quốc gia của **Pháp**\n**72.264.002**: dữ liệu địa lý\n**CE**: Cộng đồng Châu Âu';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Mã EMB** được sử dụng ở Pháp:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Truy gốc';

  @override
  String get edit_product_form_item_traces_hint => 'dấu vết';

  @override
  String get edit_product_form_item_traces_type =>
      'Nhập dấu vết (ví dụ: Đậu nành)';

  @override
  String get edit_product_form_item_categories_title => 'Thể loại';

  @override
  String get edit_product_form_item_categories_hint => 'danh mục';

  @override
  String get edit_product_form_item_categories_type =>
      'Nhập một danh mục (ví dụ: Nước cam)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Thực hành tốt: Danh mục';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Chỉ định **chỉ danh mục cụ thể nhất**.\nDanh mục cha sẽ được tự động thêm vào.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Thiếu danh mục?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Trong trường hợp một danh mục **không có sẵn trong tính năng tự động hoàn thành**, bạn vẫn có thể thêm danh mục đó.\nĐiều này sẽ giúp chúng tôi cải thiện Open Food Facts tại quốc gia của bạn.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Cá mòi trong dầu ô liu';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Nước cam cô đặc';

  @override
  String get edit_product_form_item_exit_title => 'Thoát mà không lưu?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Bạn có muốn lưu các thay đổi trước khi rời trang?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Lưu thay đổi';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Hủy bỏ thay đổi';

  @override
  String get edit_product_form_item_ingredients_title => 'Thành phần';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Phóng to và thu nhỏ bằng cách chụm màn hình';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Phóng to và thu nhỏ ảnh';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Sử dụng cử chỉ **Chụm để phóng to**, bạn có thể phóng to hoặc thu nhỏ ảnh:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Thêm vào';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Vui lòng nhập một văn bản trước';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Gỡ bỏ';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Lưu chỉnh sửa của bạn';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Hủy chỉnh sửa của bạn';

  @override
  String get edit_product_form_item_packaging_title => 'Ảnh hướng dẫn tái chế';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Giá trị dinh dưỡng';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Dinh dưỡng, độ cồn…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Thực hành tốt: Thông tin dinh dưỡng';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Giá trị dinh dưỡng';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Đầu tiên, hãy chọn xem **giá trị có được cung cấp** hay không:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Giá trị dinh dưỡng';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Sau đó, nhập giá trị dinh dưỡng **như được ghi trên bao bì**. Nếu không có giá trị, bạn có thể nhấp vào biểu tượng \"Mắt\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Thiếu trường?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Nếu thiếu mục nào đó, bạn có thể **nhấp vào biểu tượng \"Dấu cộng\"** để thêm mục đó (ví dụ: vitamin D, magie…).';

  @override
  String get edit_product_form_save => 'Chỉnh sửa';

  @override
  String get edit_product_ingredients_photo_title => 'Ảnh chụp thành phần';

  @override
  String get edit_product_ingredients_list_title => 'Danh sách các thành phần';

  @override
  String get edit_product_packaging_photo_title => 'Ảnh bao bì';

  @override
  String get edit_product_packaging_list_title => 'Danh sách đóng gói';

  @override
  String get no_data_available => 'Không có dữ liệu có sẵn';

  @override
  String get product_field_website_title => 'Trang web';

  @override
  String get origins_editing_title => 'Chỉnh sửa nguồn gốc';

  @override
  String get completed_basic_details_btn_text => 'Hoàn thành thông tin cơ bản';

  @override
  String get not_implemented_snackbar_text => 'Chưa thực hiện';

  @override
  String get category_picker_page_appbar_text => 'Thể loại';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Trích xuất các thành phần từ ảnh';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Trích xuất thành phần';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Trích xuất các thành phần\ntừ ảnh';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Đang tải ảnh…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Tại sao tôi lại thấy thông báo này?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Để sử dụng tính năng \"Trích xuất thành phần\", trước tiên bạn cần tải ảnh lên.\n\nVui lòng đợi vài giây hoặc nhập thủ công.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Làm mới ảnh';

  @override
  String get edit_packaging_extract_btn_text => 'Trích xuất bao bì\ntừ ảnh';

  @override
  String get edit_packaging_extract_btn_text_short => 'Chiết xuất bao bì';

  @override
  String get edit_packaging_extracting_btn_text => 'Trích xuất bao bì từ ảnh';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Đang tải ảnh…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Tại sao tôi lại thấy thông báo này?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Để sử dụng tính năng \"Trích xuất bao bì\", trước tiên bạn cần tải ảnh lên.\n\nVui lòng đợi vài giây hoặc nhập thủ công.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Làm mới ảnh';

  @override
  String get edit_ocr_extract_failed =>
      'Không thể phát hiện văn bản trong hình ảnh.';

  @override
  String get edit_ocr_extract_disabled_title => 'Không có hình ảnh!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Để sử dụng tính năng trích xuất văn bản, trước tiên bạn phải chụp ảnh.';

  @override
  String get user_list_dialog_new_title => 'Danh sách sản phẩm mới';

  @override
  String get user_list_dialog_rename_title => 'Đổi tên danh sách';

  @override
  String get user_list_subtitle_product => 'Danh sách';

  @override
  String get user_list_title => 'Danh sách của bạn';

  @override
  String get user_list_add_product => 'Thêm sản phẩm vào danh sách của bạn';

  @override
  String get user_list_button_new => 'Tạo danh sách mới';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Thêm vào danh sách';

  @override
  String get added_to_list_msg => 'Đã thêm vào danh sách';

  @override
  String get user_list_popup_clear => 'Xóa lịch sử của bạn';

  @override
  String get user_list_popup_rename => 'Đổi tên';

  @override
  String get user_list_name_hint => 'Danh sách của tôi';

  @override
  String get user_list_name_error_empty => 'Tên là thông tin bắt buộc';

  @override
  String get user_list_name_error_already => 'Tên đã được sử dụng';

  @override
  String get user_list_name_error_same => 'Tên bị trùng';

  @override
  String get user_list_name_input_hint => 'Tên của danh sách';

  @override
  String get try_again => 'Thử lại';

  @override
  String get there_was_an_error => 'Có lỗi xảy ra';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Không tìm thấy danh mục nào cho $items';
  }

  @override
  String get camera_toggle_camera => 'Chuyển đổi giữa camera trước và sau';

  @override
  String get camera_toggle_flash => 'Bật hoặc tắt đèn flash của máy ảnh';

  @override
  String get camera_enable_flash => 'Bật flash';

  @override
  String get camera_disable_flash => 'Tắt flash';

  @override
  String get camera_flash_error_dialog_title => 'Đã xảy ra lỗi!';

  @override
  String get camera_flash_error_dialog_message =>
      'Đã xảy ra lỗi khi thay đổi trạng thái đèn flash. Vui lòng đảm bảo điện thoại thông minh của bạn chưa bật đèn pin.';

  @override
  String get category_picker_no_category_found_button => 'Quay lại';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Nhấp để mở trong trình duyệt của bạn hoặc trong ứng dụng (nếu đã cài đặt)';

  @override
  String get dev_preferences_screen_title => 'Chế độ DEV';

  @override
  String get dev_preferences_screen_subtitle =>
      'Truy cập các tính năng thử nghiệm và công cụ phát triển';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Bắt đầu lại phần giới thiệu';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Sau đó, bạn phải khởi động lại Ứng dụng để xem lại.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Chuyển đổi giữa openfoodfacts.org (PROD) và test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Các thông số môi trường thử nghiệm';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL cơ sở cho thử nghiệm hiện tại env: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Máy chủ môi trường thử nghiệm';

  @override
  String get dev_preferences_ml_kit_title => 'Sử dụng ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'sau đó bạn phải khởi động lại ứng dụng này';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Nút bổ sung trên trang sản phẩm';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Chỉnh sửa thành phần thông qua nút bảng điều khiển';

  @override
  String get dev_preferences_export_history_title => 'Xuất lịch sử';

  @override
  String get dev_preferences_export_history_progress_error => 'ngoại lệ';

  @override
  String get dev_preferences_export_history_progress_found =>
      'tìm thấy sản phẩm';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'KHÔNG tìm thấy sản phẩm';

  @override
  String get dev_preferences_export_history_dialog_title => 'Xuất lịch sử';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Huỷ';

  @override
  String get dev_preferences_migration_title => 'Chuyển dữ liệu từ V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Trạng thái: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'thành công hoặc cài đặt mới';

  @override
  String get dev_preferences_migration_status_success => 'thành công';

  @override
  String get dev_preferences_migration_status_error => 'lỗi';

  @override
  String get dev_preferences_migration_status_in_progress => 'đang xử lý';

  @override
  String get dev_preferences_migration_status_required =>
      'bắt buộc (bấm để bắt đầu)';

  @override
  String get dev_preferences_migration_status_not_started => 'không xác định';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Sẽ xóa lịch sử và thêm 3 sản phẩm mới vào';

  @override
  String get dev_preferences_news_custom_url_title =>
      'URL tùy chỉnh cho tin tức';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL của tệp JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Chưa thiết lập';

  @override
  String get dev_preferences_news_provider_status_title => 'Trạng thái';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Lần làm mới cuối cùng: $date';
  }

  @override
  String get product_type_label_food => 'Đồ ăn';

  @override
  String get product_type_label_beauty => 'Chăm sóc cá nhân';

  @override
  String get product_type_label_pet_food => 'Thức ăn cho thú cưng';

  @override
  String get product_type_label_product => 'Khác';

  @override
  String get product_type_selection_title => 'Loại sản phẩm';

  @override
  String get product_type_selection_subtitle => 'Chọn loại sản phẩm này';

  @override
  String get product_type_selection_empty =>
      'Trước tiên, bạn cần chọn loại sản phẩm!';

  @override
  String product_type_selection_already(String productType) {
    return 'Bạn không thể thay đổi loại sản phẩm ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Phím tắt đến ứng dụng Giá trên trang sản phẩm';

  @override
  String get prices_app_button => 'Đi tới ứng dụng Giá';

  @override
  String get prices_website_button => 'Mở trên trang web Giá mở';

  @override
  String get prices_bulk_proof_upload_select =>
      'Thêm thẻ giá trực tiếp từ thư viện';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Sau khi đã chọn hình ảnh, bạn sẽ không thể chỉnh sửa chúng nữa!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Cho phép cộng đồng xác thực giá được trích xuất bởi AI.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Nhiều thẻ giá';

  @override
  String get prices_bulk_proof_upload_title => 'Tải lên bản in thử hàng loạt';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Chọn tập tin';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Bắt đầu tải lên';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Sao chép tệp cục bộ #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Đang chuẩn bị tải lên #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Thất bại ở hình ảnh #$index/$count';
  }

  @override
  String get prices_generic_title => 'Giá cả';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Thêm giá $count',
      one: 'Thêm giá',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Gửi giá $count',
      one: 'Gửi giá',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Thêm một mục';

  @override
  String get prices_add_a_price => 'Thêm giá';

  @override
  String get prices_add_a_receipt => 'Thêm biên lai';

  @override
  String get prices_add_price_tags => 'Thêm thẻ giá';

  @override
  String prices_barcode_already(String barcode) {
    return 'Mã vạch này ($barcode) đã có trong danh sách!';
  }

  @override
  String get prices_barcode_search_not_found => 'Không tìm thấy sản phẩm';

  @override
  String get prices_barcode_search_none_yet => 'Chưa có sản phẩm nào';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Tìm kiếm $barcode';
  }

  @override
  String get prices_barcode_enter => 'Nhập mã vạch';

  @override
  String get prices_category_enter => 'Mặt hàng không có mã vạch';

  @override
  String get prices_per_kilogram => 'Giá mỗi kilôgam';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / đơn vị';

  @override
  String get prices_category_mandatory => 'Bắt buộc';

  @override
  String get prices_category_optional => 'Không bắt buộc';

  @override
  String get prices_category_error_mandatory => 'Thể loại này là bắt buộc';

  @override
  String get prices_barcode_reader_action => 'Máy đọc mã vạch';

  @override
  String get prices_view_prices => 'Xem giá';

  @override
  String get prices_list_title => 'Bảng giá';

  @override
  String get prices_list_count => 'Số lượng\ngiá';

  @override
  String get prices_list_add_new_price => 'Thêm giá mới\n';

  @override
  String get prices_list_empty_title => 'Chưa có giá!';

  @override
  String get prices_list_empty_subtitle =>
      'Hãy là người đầu tiên thêm một:\nBằng cách quét **biên lai** hoặc **nhãn giá**!';

  @override
  String get prices_entry_shop_not_found => 'Cửa hàng không xác định';

  @override
  String prices_entry_menu_title(String user) {
    return 'Giá nhập từ \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Xem tất cả giá cho sản phẩm này';

  @override
  String get prices_entry_menu_open_proof => 'Xem bằng chứng';

  @override
  String get prices_entry_menu_my_prices => 'Xem giá khác của tôi';

  @override
  String get prices_entry_menu_author_prices =>
      'Xem các mức giá khác của tác giả';

  @override
  String get prices_entry_menu_shop_prices => 'Xem giá khác từ cửa hàng';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count giá',
      one: '1 giá',
    );
    return '$_temp0 cho $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tất cả $count giá',
      one: 'Chỉ có một giá',
      zero: 'Chưa có giá',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Giá $pageSize mới nhất (tổng cộng: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Giá: $price / Cửa hàng: \"$location\" / Đăng vào $date bởi \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Bản chứng minh mở của \"$user\"';
  }

  @override
  String get prices_open_proof => 'Mở bằng chứng giá';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tất cả $count bằng chứng',
      one: 'Chỉ có một bằng chứng',
      zero: 'Chưa có bằng chứng nào',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Bản in thử $pageSize mới nhất (tổng cộng: $total)';
  }

  @override
  String get prices_users_empty_title => 'Chưa có người đóng góp nào!';

  @override
  String get prices_users_empty_explanation =>
      'Hãy là người đầu tiên thêm giá!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Những người đóng góp hàng đầu $pageSize (tổng số: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Chưa có cửa hàng nào!';

  @override
  String get prices_locations_empty_explanation =>
      'Hãy là người đầu tiên thêm giá!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Các vị trí hàng đầu $pageSize (tổng cộng: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bằng chứng',
      one: 'Một bằng chứng',
      zero: 'Không có bằng chứng',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count sản phẩm',
      one: 'Một sản phẩm',
      zero: 'Không có sản phẩm',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count người dùng',
      one: 'Một người dùng',
      zero: 'Không có người dùng',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count giá',
      one: 'Một giá',
      zero: 'Không có giá',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Giá đã thêm trước đó';

  @override
  String get prices_amount_subtitle => 'Số lượng';

  @override
  String get prices_amount_is_discounted => 'Có được giảm giá không?';

  @override
  String get prices_amount_price_normal => 'Giá';

  @override
  String get prices_amount_price_discounted => 'Giá giảm giá';

  @override
  String get prices_amount_price_not_discounted => 'Giá gốc';

  @override
  String get prices_amount_no_product => 'Thiếu một sản phẩm!';

  @override
  String get prices_amount_price_incorrect => 'Giá trị không chính xác';

  @override
  String get prices_amount_price_mandatory => 'Giá trị bắt buộc';

  @override
  String get prices_currency_subtitle => 'Tiền tệ';

  @override
  String get prices_date_subtitle => 'Ngày';

  @override
  String get prices_location_subtitle => 'Cửa hàng';

  @override
  String get prices_location_find => 'Tìm một cửa hàng';

  @override
  String get prices_location_mandatory => 'Bạn cần phải chọn một cửa hàng!';

  @override
  String get prices_location_search_broader =>
      'Không tìm thấy thông tin bạn cần? Hãy thử tìm kiếm rộng hơn!';

  @override
  String get prices_proof_subtitle => 'Bằng chứng';

  @override
  String get prices_proof_empty_title => 'Chưa có bằng chứng!';

  @override
  String get prices_proof_empty_explanation =>
      'Bắt đầu bằng cách thêm ảnh **biên lai** hoặc **nhãn giá**!';

  @override
  String get prices_proof_find => 'Chọn một bản chứng minh';

  @override
  String get prices_proof_change => 'Thay đổi bằng chứng';

  @override
  String get prices_proof_receipt => 'Biên lai';

  @override
  String get prices_proof_price_tag => 'Giá cả';

  @override
  String get prices_proof_mandatory => 'Bạn cần phải chọn một bản chứng minh!';

  @override
  String get prices_add_validation_error => 'Lỗi xác thực';

  @override
  String get prices_privacy_warning_title => 'Cảnh báo về quyền riêng tư';

  @override
  String get prices_unknown_product => 'Sản phẩm không xác định';

  @override
  String get prices_privacy_warning_main_message =>
      'Giá cả **sẽ được công khai**, cùng với cửa hàng mà chúng đề cập đến.\n\nĐiều đó có thể cho phép những người biết về bút danh Open Food Facts của bạn:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Suy ra bạn sống ở khu vực nào';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Biết những gì bạn đang mua';

  @override
  String get prices_privacy_warning_sub_message =>
      'Nếu bạn không thoải mái với điều đó, vui lòng đổi bút danh hoặc tạo tài khoản Open Food Facts mới và đăng nhập vào ứng dụng bằng tài khoản đó.';

  @override
  String get i_refuse => 'Tôi từ chối';

  @override
  String get i_accept => 'Tôi chấp nhận';

  @override
  String get prices_currency_change_proposal_title => 'Đổi tiền tệ?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Tiền tệ hiện tại của bạn là **$currency**. Bạn có muốn đổi thành **$newCurrency** không?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Có, sử dụng $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Không, giữ lại $currency';
  }

  @override
  String get prices_menu_know_more => 'Tìm hiểu thêm về Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Xong';

  @override
  String get dev_mode_section_server => 'Cấu hình máy chủ';

  @override
  String get dev_mode_section_news => 'Cấu hình nhà cung cấp tin tức';

  @override
  String get dev_mode_section_product_page => 'Trang sản phẩm';

  @override
  String get dev_mode_section_ui => 'Giao diện người dùng';

  @override
  String get dev_mode_section_experimental_features =>
      'Các tính năng thử nghiệm';

  @override
  String get dev_mode_hide_environmental_score_title => 'Loại trừ Điểm Xanh';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Sử dụng trình kiểm tra chính tả cho màn hình OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(Thành phần và bao bì)';

  @override
  String get dev_mode_reset_app_language_title => 'Đặt lại ngôn ngữ ứng dụng';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Thêm thẻ';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Chuyển đổi giữa prices.openfoodfacts.org (PROD) và môi trường thử nghiệm';

  @override
  String get search_history_item_edit_tooltip =>
      'Tái sử dụng và chỉnh sửa tìm kiếm này';

  @override
  String get search_history_item_remove_tooltip => 'Gỡ bỏ';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Bạn vừa tải xuống tất cả $totalSize sản phẩm.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Tải thêm $count sản phẩm\nĐã tải $downloaded trên tổng $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Tìm kiếm $search của bạn đang được tiến hành.\n\nVui lòng đợi vài giây…';
  }

  @override
  String get user_search_contributor_title => 'Sản phẩm tôi đã thêm';

  @override
  String get user_search_informer_title => 'Sản phẩm tôi đã chỉnh sửa';

  @override
  String get user_search_photographer_title => 'Sản phẩm tôi đã chụp';

  @override
  String get user_search_to_be_completed_title =>
      'Các sản phẩm sắp hoàn thiện của tôi';

  @override
  String get user_search_prices_title => 'Giá của tôi';

  @override
  String get user_search_proofs_title => 'Bằng chứng của tôi';

  @override
  String get user_search_proof_title => 'Bằng chứng của tôi';

  @override
  String search_proof_title(String user) {
    return 'Bằng chứng từ \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Giá đóng góp: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Giá mới nhất được thêm vào';

  @override
  String get all_search_prices_top_user_title =>
      'Những người đóng góp giá hàng đầu';

  @override
  String get all_search_prices_top_location_title =>
      'Các cửa hàng có giá cao nhất';

  @override
  String get prices_contribution_assistant => 'Trợ lý đóng góp giá';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Thêm nhiều bằng chứng';

  @override
  String get all_search_prices_top_location_single_title =>
      'Giá cả trong cửa hàng';

  @override
  String get all_search_prices_top_product_title => 'Sản phẩm có giá cao nhất';

  @override
  String get all_search_to_be_completed_title =>
      'Tất cả các sản phẩm sắp hoàn thiện';

  @override
  String get categorize_products_country_title =>
      'Giúp phân loại sản phẩm ở quốc gia của bạn';

  @override
  String get edit_product_action_retake_picture => 'Chụp lại ảnh';

  @override
  String get edit_product_action_take_picture => 'Chụp ảnh';

  @override
  String get edit_product_action_confirm => 'Xác nhận';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Tôi đồng ý với Thông tin Thực phẩm Mở ';

  @override
  String get signup_page_terms_of_use_line2 => 'điều khoản sử dụng và đóng góp';

  @override
  String get analytics_consent_image_semantic_label => 'Biểu tượng phân tích';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Lỗi nghiêm trọng: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Lỗi nghiêm trọng: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Hoàn thành thông tin cơ bản';

  @override
  String get edit_photo_button_label => 'Chỉnh sửa';

  @override
  String get edit_photo_unselect_button_label => 'Bỏ chọn ảnh';

  @override
  String get edit_photo_select_existing_button_label =>
      'Chọn một hình ảnh có sẵn';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Chọn một hình ảnh bằng cách nhấp vào nó';

  @override
  String get edit_photo_select_existing_download_label =>
      'Đang lấy lại hình ảnh hiện có…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Không có hình ảnh nào được tải lên trước đây liên quan đến sản phẩm này.';

  @override
  String get edit_photo_language_not_this_one =>
      'Chưa có hình ảnh nào bằng ngôn ngữ đó';

  @override
  String get edit_photo_language_none => 'Chưa có hình ảnh';

  @override
  String get category_picker_screen_title => 'Thể loại';

  @override
  String get basic_details => 'Thông tin chi tiết cơ bản';

  @override
  String get product_name => 'Tên sản phẩm';

  @override
  String get product_names => 'Tên sản phẩm';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Thêm bản dịch mới';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Trước khi xác thực, vui lòng đảm bảo bạn chỉ thêm bản dịch **nếu ngôn ngữ có trên bao bì**';

  @override
  String get add_basic_details_product_name_open_photo => 'Xem ảnh mặt trước';

  @override
  String get add_basic_details_product_name_take_photo => 'Chụp ảnh mặt trước';

  @override
  String get add_basic_details_product_name_hint =>
      'Nhập tên sản phẩm (ví dụ: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Thay đổi ngôn ngữ mặc định?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Bạn có muốn ngôn ngữ mặc định của sản phẩm được đặt thành \'$language\' không?';
  }

  @override
  String get explanation_section_good_examples => 'Ví dụ tốt';

  @override
  String get explanation_section_bad_examples => 'Những ví dụ tồi';

  @override
  String get add_basic_details_product_name_help_title =>
      'Thực hành tốt: Tên sản phẩm';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Tên sản phẩm là **tên chính được in trên bao bì**. Tên này có thể là nhãn hiệu đã đăng ký.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Lưu ý:** Vui lòng không thêm bản dịch **nếu ngôn ngữ đó không có trên bao bì**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tương cà chua';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Không bao gồm thương hiệu trong tên';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tương cà chua **của Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Không sử dụng các ký hiệu ®, ™, © hoặc tương tự';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bản dịch khác',
      one: '$count bản dịch khác',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Tên thương hiệu';

  @override
  String get brand_names => 'Tên thương hiệu';

  @override
  String get add_basic_details_brand_name_error =>
      'Vui lòng nhập tên thương hiệu';

  @override
  String get add_basic_details_brand_names_hint =>
      'Đầu vào thương hiệu (ví dụ: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Thực hành tốt: Thương hiệu';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Nhập **tất cả các nhãn hiệu của sản phẩm**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Thương hiệu chính';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Thương hiệu chính**, thường được hiển thị rõ ràng ở mặt trước của bao bì, phải được **nhập trước**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Các thương hiệu khác';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Khi được bán **bởi một công ty lớn**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** được bán bởi **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Khi được bán kèm với thương hiệu **được dịch sang nhiều ngôn ngữ**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** đôi khi được viết là **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Số lượng và cân nặng';

  @override
  String get add_basic_details_quantity_hint =>
      'Nhập trọng lượng và nếu cần thì nhập số lượng (ví dụ: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Thực hành tốt: Số lượng';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Sao chép giá trị được ghi trên sản phẩm và **đừng quên đơn vị**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** hoặc **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (cho 6 quả trứng)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(cho sản phẩm có 3 hộp, mỗi hộp 150g)';

  @override
  String get barcode => 'Mã vạch';

  @override
  String barcode_barcode(String barcode) {
    return 'Mã vạch: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Mã vạch không hợp lệ';

  @override
  String get basic_details_add_success =>
      'Thông tin chi tiết cơ bản đã được thêm thành công';

  @override
  String get basic_details_add_error =>
      'Không thể thêm thông tin chi tiết cơ bản. Vui lòng thử lại lúc khác';

  @override
  String get clear_search => 'Xóa tìm kiếm của bạn';

  @override
  String get confirm_clear =>
      'Bạn sắp xóa toàn bộ lịch sử của mình: bạn có chắc muốn tiếp tục?';

  @override
  String get alert_clear_selected_user_list =>
      'Bạn sắp xóa các mục đã chọn trong lịch sử của mình';

  @override
  String get confirm_clear_selected_user_list =>
      'Bạn có chắc chắn muốn tiếp tục không?';

  @override
  String get alert_select_items_to_clear =>
      'Vui lòng chọn một hoặc nhiều mục để xóa';

  @override
  String confirm_clear_user_list(String name) {
    return 'Bạn sắp xóa danh sách ($name): bạn có chắc muốn tiếp tục?';
  }

  @override
  String get confirm_delete_user_list_title => 'Xóa danh sách?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Bạn sắp xóa danh sách \"$name\".\nBạn có chắc chắn muốn tiếp tục không?';
  }

  @override
  String get confirm_delete_user_list_button => 'Vâng, tôi xác nhận';

  @override
  String importance_label(String name, String id) {
    return '$name quan trọng: $id';
  }

  @override
  String get user_list_all_title => 'Danh sách';

  @override
  String get user_list_all_empty => 'Tạo danh sách sản phẩm đầu tiên';

  @override
  String get product_list_select => 'Chọn một danh sách';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Sản phẩm',
      one: 'Một sản phẩm',
      zero: 'Danh sách trống',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Thêm danh sách';

  @override
  String get open_food_preferences_tooltip =>
      'Chỉnh sửa tiêu chí thực phẩm của bạn';

  @override
  String get add_photo_button_label => 'Thêm ảnh';

  @override
  String get add_packaging_photo_button_label =>
      'Chụp ảnh thông tin đóng gói/tái chế bất kì';

  @override
  String get add_origin_photo_button_label =>
      'Chụp ảnh bất kỳ thông tin nguồn gốc nào';

  @override
  String get add_emb_photo_button_label =>
      'Chụp ảnh bất kỳ thông tin mã truy xuất nguồn gốc nào';

  @override
  String get add_label_photo_button_label =>
      'Chụp ảnh bất kỳ nhãn hiệu và thông tin chứng nhận nào';

  @override
  String get choose_image_source_title => 'Chọn nguồn ảnh';

  @override
  String get choose_image_source_body => 'Vui lòng chọn một nguồn ảnh';

  @override
  String get gallery_source_label => 'Thư viện';

  @override
  String get gallery_source_access_denied_dialog_title => 'Truy cập bị từ chối';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Thật không may, ứng dụng không thể truy cập vào thư viện ảnh của bạn vì trước đó bạn đã từ chối cấp quyền.\n\nVui lòng vào cài đặt ứng dụng trong Cài đặt điện thoại -> Ảnh';

  @override
  String get gallery_source_access_denied_dialog_button => 'Mở Cài đặt';

  @override
  String get share => 'Chia sẻ';

  @override
  String share_product_text(String url) {
    return 'Hãy xem sản phẩm này trên Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Hãy xem sản phẩm này trên Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Hãy xem sản phẩm này trên Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Hãy xem sản phẩm này trên Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Hãy xem danh sách sản phẩm của tôi trên Open Food Facts: $url';
  }

  @override
  String get capture => 'Chụp mới';

  @override
  String get capture_new_picture => 'Chụp ảnh';

  @override
  String get choose_from_gallery => 'Chọn từ thư viện ảnh';

  @override
  String get image_upload_queued =>
      'Ảnh sẽ được tải lên trong nền trong thời gian sớm nhất.';

  @override
  String get add_price_queued => 'Giá sẽ được gửi đến máy chủ sớm nhất có thể.';

  @override
  String get background_task_title_full_refresh =>
      'Bắt đầu làm mới tất cả các sản phẩm được lưu trữ cục bộ';

  @override
  String get background_task_title_folksonomy =>
      'Bắt đầu thực hiện các hành động máy chủ cho các bản cập nhật folksonomy được lưu trữ cục bộ';

  @override
  String get background_task_title_top_n =>
      'Bắt đầu tải xuống các sản phẩm phổ biến nhất';

  @override
  String get expand_nutrition_facts => 'Mở rộng bảng thông tin dinh dưỡng';

  @override
  String get expand_nutrition_facts_body =>
      'Giữ bảng thông tin dinh dưỡng mở rộng';

  @override
  String get expand_ingredients => 'Mở rộng thành phần';

  @override
  String get expand_ingredients_body => 'Giữ bảng thành phần mở rộng';

  @override
  String get no_internet_connection => 'Không có kết nối mạng';

  @override
  String get world_results_label => 'Toàn cầu';

  @override
  String get world_results_action => 'Mở rộng tìm kiếm toàn cầu';

  @override
  String get copy_to_clipboard => 'Sao chép';

  @override
  String get paste_from_clipboard => 'Dán từ bảng tạm';

  @override
  String get no_data_available_in_clipboard =>
      'Không có dữ liệu nào có sẵn trong bảng tạm của bạn';

  @override
  String get clipboard_barcode_copy => 'Sao chép mã vạch vào khay nhớ tạm';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Mã vạch $barcode đã được sao chép vào khay nhớ tạm!';
  }

  @override
  String get open_product_website => 'Mở sản phẩm này trên trang web';

  @override
  String get language_picker_label => 'Ngôn ngữ của bạn';

  @override
  String get country_picker_label => 'Đất nước của bạn';

  @override
  String get currency_picker_label => 'Tiền tệ của bạn';

  @override
  String get help_with_openfoodfacts => 'Trợ giúp với OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Sản phẩm sẽ được cập nhật trong nền trong thời gian sớm nhất.';

  @override
  String get no_email_client_available_dialog_title =>
      'Không có ứng dụng email!';

  @override
  String get no_email_client_available_dialog_content =>
      'Vui lòng gửi email cho chúng tôi theo cách thủ công tới mobile@openfoodfacts.org';

  @override
  String get all_images => 'Tất cả Hình ảnh';

  @override
  String get selected_images => 'Hình ảnh được chọn';

  @override
  String get product_card_remove_product_tooltip => 'Gỡ bỏ sản phẩm';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Mã vạch mới được quét: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Xóa tất cả sản phẩm khỏi băng chuyền';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Vui lòng quét ít nhất hai sản phẩm để thực hiện so sánh';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Nhấp để so sánh các sản phẩm bạn đã quét';

  @override
  String get scan_product_loading => 'Bạn đã quét\nmã vạch:';

  @override
  String get scan_product_loading_initial =>
      'Chúng tôi đang tìm kiếm sản phẩm này!\nVui lòng đợi vài giây…';

  @override
  String get scan_product_loading_long_request =>
      'Chúng tôi vẫn đang tìm kiếm sản phẩm này!\nBạn có thấy tải lâu không? Chúng tôi cũng vậy…';

  @override
  String get scan_product_loading_unresponsive =>
      'Chúng tôi vẫn đang tìm kiếm sản phẩm này.\nBạn có muốn bắt đầu lại tìm kiếm không?';

  @override
  String get scan_product_loading_restart_button => 'Khởi động lại tìm kiếm';

  @override
  String get portion_calculator_description =>
      'Tính toán thông tin dĩnh dưỡng cho một khối lượng nhất định';

  @override
  String get portion_calculator_hint => 'Số lượng trong';

  @override
  String get portion_calculator_accessibility =>
      'Nhập số lượng để tính toán thông tin dinh dưỡng';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Vui lòng nhập số lượng từ $min đến $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Thiếu dữ liệu. Không thể thực hiện tính toán.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Thông tin dinh dưỡng cho $grams g (hoặc ml)';
  }

  @override
  String get offline_data => 'Dữ liệu ngoại tuyến';

  @override
  String get ocr_image_upload_instruction =>
      'Tải lên một hình ảnh để tự động trích xuất thông tin chứa trong đó.';

  @override
  String get upload_image => 'Tải ảnh lên';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Tải hình ảnh thất bại';

  @override
  String get image_edit_url_error =>
      'Không thể chỉnh sửa hình ảnh vì URL hình ảnh chưa được đặt.';

  @override
  String get user_picture_source_remember => 'Nhớ lựa chọn của tôi';

  @override
  String get user_picture_source_ask => 'Hỏi mỗi lần';

  @override
  String get robotoff_continue => 'Tiếp tục';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count câu hỏi',
      one: 'câu hỏi',
    );
    return '$_temp0 kế tiếp';
  }

  @override
  String get show_password => 'Hiện mật khẩu';

  @override
  String get owner_field_info_title => 'Giá trị do nhà sản xuất cung cấp';

  @override
  String get owner_field_info_message =>
      'Với logo đó, chúng tôi sẽ làm nổi bật dữ liệu do nhà sản xuất cung cấp và có thể không chỉnh sửa được.';

  @override
  String get owner_field_info_close_button => 'Đóng thông tin này';

  @override
  String get owner_field_image =>
      'Hình ảnh này do nhà sản xuất cung cấp. Có thể không chỉnh sửa được.';

  @override
  String get edit_packagings_title => 'Thành phần bao bì';

  @override
  String get edit_packagings_element_add => 'Thêm thành phần bao bì';

  @override
  String get edit_packagings_completed => 'Bao bì đã hoàn thành';

  @override
  String edit_packagings_element_title(int index) {
    return 'Thành phần bao bì #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Số lượng đơn vị';

  @override
  String get edit_packagings_element_hint_units =>
      'Nhập số lượng đơn vị đóng gói có cùng hình dạng và chất liệu chứa trong sản phẩm.';

  @override
  String get edit_packagings_element_field_shape => 'Hình dạng';

  @override
  String get edit_packagings_element_hint_shape =>
      'Nhập tên hình dạng được liệt kê trong hướng dẫn tái chế nếu chúng có sẵn, hoặc chọn một hình dạng.';

  @override
  String get edit_packagings_element_example_shape => 'Chai';

  @override
  String get edit_packagings_element_field_material => 'Chất liệu';

  @override
  String get edit_packagings_element_hint_material =>
      'Nhập vật liệu cụ thể nếu có thể xác định được (mã vật liệu bên trong hình tam giác thường có trên các bộ phận đóng gói) hoặc một loại vật liệu chung (ví dụ: nhựa hoặc kim loại) nếu bạn không chắc chắn.';

  @override
  String get edit_packagings_element_example_material => 'Thủy tinh';

  @override
  String get edit_packagings_element_field_recycling => 'Hướng dẫn tái chế';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Chỉ nhập hướng dẫn tái chế nếu chúng được liệt kê trên sản phẩm.';

  @override
  String get edit_packagings_element_example_recycling => 'Tái chế';

  @override
  String get edit_packagings_element_field_quantity =>
      'Số lượng tịnh của sản phẩm trên một đơn vị';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Nhập khối lượng tịnh hoặc thể tích tịnh và cho biết đơn vị (ví dụ g hoặc ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Trọng lượng của một đơn vị rỗng (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Loại bỏ bất kỳ thực phẩm thừa sau đó rửa sạch và lau khô bộ phận đóng gói trước khi cân. Nếu có thể, hãy sử dụng cân có độ chính xác đến 0,1g hoặc 0,01g.';

  @override
  String get background_task_title => 'Đóng góp đang chờ xử lý';

  @override
  String get background_task_subtitle =>
      'Đóng góp của bạn được lưu tự động vào máy chủ của chúng tôi, nhưng không phải lúc nào cũng theo thời gian thực.';

  @override
  String get background_task_list_empty => 'Không có tác vụ nền đang chờ xử lý';

  @override
  String get background_task_error_server_time_out =>
      'Hết thời gian chờ của máy chủ';

  @override
  String get background_task_error_no_internet =>
      'Lỗi kết nối Internet. Thử lại sau.';

  @override
  String get background_task_operation_unknown =>
      'loại hoạt động không xác định';

  @override
  String get background_task_operation_details => 'thay đổi chi tiết';

  @override
  String get background_task_operation_image => 'tải ảnh lên';

  @override
  String get background_task_operation_refresh =>
      'làm mới bị trì hoãn sau khi tải ảnh lên';

  @override
  String get background_task_run_started => 'đã bắt đầu';

  @override
  String get background_task_run_not_started => 'chưa bắt đầu';

  @override
  String get background_task_run_to_be_deleted => 'bị xóa';

  @override
  String get background_task_question_stop =>
      'Bạn có muốn dừng nhiệm vụ đó sớm không?';

  @override
  String get feed_back => 'Nhận xét';

  @override
  String get undo => 'Hoàn tác';

  @override
  String get copy_email_to_clip_board => 'Sao chép email vào khay nhớ tạm';

  @override
  String get please_send_us_an_email_to =>
      'Vui lòng gửi cho email cho chúng tôi đến địa chỉ';

  @override
  String get email_copied_to_clip_board => 'Email được sao chép vào clipboard!';

  @override
  String get select_accent_color => 'Chọn màu chủ đề';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Xanh dương';

  @override
  String get color_cyan => 'Lục lam';

  @override
  String get color_green => 'Xanh lá cây';

  @override
  String get color_light_brown => 'Mặc định';

  @override
  String get color_magenta => 'Đỏ tươi';

  @override
  String get color_orange => 'Cam';

  @override
  String get color_pink => 'Hồng';

  @override
  String get color_red => 'Đỏ';

  @override
  String get color_rust => 'Rỉ sắt';

  @override
  String get color_teal => 'Xanh mòng két';

  @override
  String get text_contrast_mode => 'Tương phản văn bản';

  @override
  String get contrast_high => 'Cao';

  @override
  String get contrast_medium => 'Trung bình';

  @override
  String get contrast_low => 'Thấp';

  @override
  String get product_refresher_internet_not_found => 'Không tìm thấy sản phẩm!';

  @override
  String get product_refresher_internet_not_connected =>
      'Bạn không kết nối được với Internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Máy chủ ngừng hoạt động ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Lỗi máy chủ ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Không tìm thấy sản phẩm!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Sản phẩm có vạch mã sau không tồn tại trong cơ sở dữ liệu của chúng tôi: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Không có kết nối mạng!';

  @override
  String get product_loader_network_error_message =>
      'Vui lòng kiểm tra kết nối Wifi hoặc di động trên thiết bị di động của bạn';

  @override
  String get page_not_found_title => 'Không tìm thấy trang!';

  @override
  String get page_not_found_button => 'Trở về trang chủ';

  @override
  String get download_data => 'Tải dữ liệu';

  @override
  String get download_top_products =>
      'Tải xuống 1000 sản phẩm hàng đầu ở quốc gia của bạn để quét ngay lập tức';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count',
    );
    return 'Tải xuống các sản phẩm hàng đầu $_temp0 ở quốc gia của bạn để quét ngay lập tức';
  }

  @override
  String get download_in_progress =>
      'Đang tải xuống dữ liệu\nQuá trình này có thể mất một chút thời gian';

  @override
  String downloaded_products(int num) {
    return 'Đã thêm $num sản phẩm';
  }

  @override
  String get update_offline_data => 'Cập nhật dữ liệu sản phẩm ngoại tuyến';

  @override
  String get update_local_database_sub =>
      'Cập nhật cơ sở dữ liệu sản phẩm địa phương với dữ liệu mới nhất từ Open Food Facts';

  @override
  String get clear_local_database => 'Xóa dữ liệu sản phẩm ngoại tuyến';

  @override
  String get clear_local_database_sub =>
      'Xóa tất cả dữ liệu sản phẩm tại phương khỏi ứng dụng của bạn để giải phóng dung lượng';

  @override
  String deleted_products(int num) {
    return 'Đã xóa $num sản phẩm';
  }

  @override
  String get loading => 'Loading…';

  @override
  String get know_more => 'Tìm hiểu thêm';

  @override
  String get offline_data_desc => 'Nhấp để biết thêm về dữ liệu ngoại tuyến';

  @override
  String get offline_product_data_title => 'Dữ liệu sản phẩm ngoại tuyến';

  @override
  String available_for_download(int num) {
    return '$num sản phẩm có sẵn để quét ngay lập tức';
  }

  @override
  String get country_selector_title => 'Chọn quốc gia của bạn:';

  @override
  String get currency_selector_title => 'Chọn loại tiền tệ của bạn:';

  @override
  String get language_selector_title => 'Chọn ngôn ngữ của bạn:';

  @override
  String get language_selector_section_selected => 'Ngôn ngữ đã chọn';

  @override
  String get language_selector_section_frequently_used =>
      'Thường xuyên sử dụng';

  @override
  String get action_delete_list => 'Xóa';

  @override
  String get action_change_list => 'Thay đổi danh sách hiện tại';

  @override
  String get product_list_create => 'Tạo';

  @override
  String get product_list_create_tooltip => 'Tạo danh sách mới';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Tính toán mới)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Tính toán mới)';

  @override
  String get nutriscore_unknown => 'Nutri-Score chưa biết';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nutri-Score chưa biết (Tính toán mới)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score không áp dụng';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score không áp dụng (Tính toán mới)';

  @override
  String get environmental_score_generic_new => 'Điểm sinh thái';

  @override
  String get environmental_score_a_new => 'Điểm xanh A';

  @override
  String get environmental_score_b_new => 'Điểm xanh B';

  @override
  String get environmental_score_c_new => 'Điểm xanh C';

  @override
  String get environmental_score_d_new => 'Điểm xanh lá cây D';

  @override
  String get environmental_score_e_new => 'Điểm xanh E';

  @override
  String get environmental_score_unknown_new => 'Điểm xanh không xác định';

  @override
  String get environmental_score_not_applicable_new =>
      'Điểm xanh không áp dụng';

  @override
  String get nova_group_generic_new =>
      'Thực phẩm siêu chế biến - Tập đoàn NOVA';

  @override
  String get nova_group_1 => 'Nhóm NOVA 1';

  @override
  String get nova_group_2 => 'Nhóm NOVA 2';

  @override
  String get nova_group_3 => 'Nhóm NOVA 3';

  @override
  String get nova_group_4 => 'Nhóm NOVA 4';

  @override
  String get nova_group_unknown => 'Nhóm NOVA không xác định';

  @override
  String get nutrition_facts => 'Mức độ dinh dưỡng';

  @override
  String get faq_title_partners =>
      'Đối tác và Nhà tài trợ của tổ chức phi chính phủ';

  @override
  String get faq_title_vision =>
      'Tầm nhìn, Sứ mệnh, Giá trị và Chương trình của Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Cài đặt Open Beauty Facts để tạo cơ sở dữ liệu mỹ phẩm';

  @override
  String get faq_title_install_pet =>
      'Cài đặt Open Pet Food Facts để tạo cơ sở dữ liệu thức ăn cho thú cưng';

  @override
  String get faq_title_install_product =>
      'Cài đặt Open Products Facts để tạo cơ sở dữ liệu sản phẩm nhằm kéo dài tuổi thọ của các đối tượng';

  @override
  String get faq_nutriscore_nutriscore =>
      'Cách tính mới của Nutri-Score: có gì mới?';

  @override
  String get contact_title_pro_page =>
      'Ưu điểm? Nhập sản phẩm của bạn vào Open Food Facts';

  @override
  String get contact_title_pro_email => 'Liên hệ nhà sản xuất';

  @override
  String get contact_title_press_page => 'Trang báo chí';

  @override
  String get contact_title_press_email => 'Liên hệ báo chí';

  @override
  String get contact_title_newsletter => 'Đăng ký nhận Bản tin';

  @override
  String get contact_title_calendar => 'Đăng ký lịch cộng đồng của chúng tôi';

  @override
  String get hunger_games_loading_line1 => 'Xin hãy cho chúng tôi vài giây…';

  @override
  String get hunger_games_loading_line2 =>
      'Chúng tôi đang tải xuống các câu hỏi!';

  @override
  String get hunger_games_error_label =>
      'Ôi! Có lỗi xảy ra… và chúng tôi không thể tải câu hỏi.';

  @override
  String get hunger_games_error_retry_button => 'Hãy thử lại!';

  @override
  String get reorder_attribute_action => 'Sắp xếp lại các thuộc tính';

  @override
  String get link_cant_be_opened =>
      'Không thể mở liên kết này trên thiết bị của bạn. Vui lòng kiểm tra xem bạn đã cài đặt trình duyệt chưa.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Chi tiết cho $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Chi tiết cho $pageName với $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Chia sẻ';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Tìm cách tính điểm Nutri-Score mới ở đâu?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score được áp dụng tại 7 quốc gia: Pháp, Đức, Bỉ, Tây Ban Nha, Luxembourg, Hà Lan và Thụy Sĩ.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Các nhà sản xuất có tối đa **2 năm** kể từ ngày ký quyết định **để thay thế** cách tính cũ bằng cách tính mới.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Điểm sinh thái';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'Điểm xanh là gì?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score là một logo có mục đích cung cấp thông tin cho bạn về **tác động của thực phẩm đến môi trường**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Mã màu thay đổi từ màu xanh lá cây đậm (**A+**) cho các sản phẩm **ít tác động nhất** đến màu đỏ đậm (**F**) cho các sản phẩm **có tác động lớn nhất**.';

  @override
  String get guide_greenscore_logos_caption => 'Logo Green-Score';

  @override
  String get guide_greenscore_lca_title => 'Cốt lõi: Đánh giá vòng đời (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Đánh giá khoa học về các loại thực phẩm';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Đối với mỗi danh mục sản phẩm, điểm chuẩn **được thiết lập bằng cách sử dụng dữ liệu từ cơ sở dữ liệu môi trường Agribalyse (do ADEME và INRAE thiết kế).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Phân tích vòng đời** là phương pháp đánh giá chuẩn hóa để thực hiện đánh giá môi trường nhiều giai đoạn và nhiều tiêu chí.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Nó đo:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 bước sản xuất';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Nông nghiệp';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Đang xử lý';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Bao bì';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Vận chuyển';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Phân phối';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Tiêu thụ';

  @override
  String get guide_greenscore_lca_arg3_title => '14 chỉ số tác động môi trường';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Biến đổi khí hậu/dấu chân carbon';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Sự suy giảm tầng ôzôn';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Bức xạ ion hóa';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Đất';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Sử dụng nước và năng lượng';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Ô nhiễm không khí';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Nước biển và nước ngọt (các hạt, axit hóa, phú dưỡng)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Sự cạn kiệt tài nguyên.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Tiền thưởng và tiền phạt';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Để thưởng cho những sản phẩm tốt hơn trong một danh mục, chúng tôi sẽ áp dụng **tiền thưởng và hình phạt dựa trên một số tiêu chí**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Phương thức sản xuất';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Phần thưởng** được trao cho các sản phẩm có **nhãn chính thức, nhãn hoặc chứng nhận đảm bảo lợi ích cho môi trường** (hữu cơ, thương mại công bằng, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Nguồn gốc của các thành phần';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Phần thưởng** được trao dựa trên nguồn gốc của nguyên liệu. Phần thưởng này có tính đến **tác động đến vận chuyển** và **chính sách môi trường** của từng quốc gia sản xuất.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Những loài có nguy có bị tuyệt chủng';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Hình phạt** được áp dụng cho các sản phẩm có chứa thành phần có **tác động tiêu cực đáng kể đến đa dạng sinh học và hệ sinh thái**, chẳng hạn như dầu cọ, loại dầu mà quá trình sản xuất gây ra nạn phá rừng hàng loạt.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Bao bì';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Hình phạt** được tính toán dựa trên **tính tuần hoàn của bao bì** (sử dụng nguyên liệu thô tái chế và khả năng tái chế) và đóng gói quá mức.';

  @override
  String get guide_greenscore_transparency_title =>
      'Nhu cầu về sự minh bạch ngày càng tăng để có thể đo lường tốt hơn và giảm tác động môi trường';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Để tính toán chính xác Điểm Xanh, cần phải có **thông tin không nhất thiết phải được ghi trên bao bì** (chẳng hạn như nguồn gốc và tỷ lệ phần trăm chính xác của từng thành phần) hoặc hiếm khi có sẵn ở dạng có thể sử dụng (chẳng hạn như danh sách tất cả các thành phần của bao bì với các loại nhựa chính xác được sử dụng).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Giá trị trung bình được sử dụng khi thông tin này chưa có sẵn**, nhưng hiện chúng tôi đang kêu gọi mọi người giúp chúng tôi thu thập thông tin này, điều này sẽ rất hữu ích cho Green-Score cũng như nhiều mục đích sử dụng khác.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Người dân có thể giúp đỡ như thế nào?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Mọi công dân có thể giúp chúng tôi thu thập và cấu trúc thông tin có trên sản phẩm hoặc có thể suy ra từ sản phẩm, chẳng hạn như thông tin về **bao bì**: \"Mission Emballages\": một kho lưu trữ bao bì hợp tác quy mô lớn cho tất cả các sản phẩm thực phẩm (bằng tiếng Pháp).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Các nhà sản xuất có thể giúp đỡ như thế nào';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Các nhà sản xuất có thể gửi thông tin trực tiếp cho chúng tôi thông qua nền tảng miễn phí dành cho nhà sản xuất.';

  @override
  String get guide_greenscore_better_product_title =>
      'Sản phẩm nào tốt hơn cho hành tinh?';

  @override
  String get guide_greenscore_better_product_arg1_title => 'Có thể khó để nói';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Lựa chọn thực phẩm bền vững là một trong những điều mạnh mẽ nhất mà chúng ta có thể làm cho khí hậu, vì **hệ thống thực phẩm toàn cầu của chúng ta chịu trách nhiệm cho hơn một phần tư lượng khí thải nhà kính**.\n(Nguồn: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Bạn có sức mạnh!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Tin tốt là điều này mang đến cho chúng ta một cách thức mạnh mẽ để tạo ra sự thay đổi.\n**Mỗi người chúng ta ăn khoảng 1.000 bữa ăn mỗi năm**. Đó là 1.000 cơ hội để **chọn một tương lai tốt đẹp hơn cho hành tinh**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Giúp có trách nhiệm và quyết định';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Việc lựa chọn thực phẩm bền vững có thể khá phức tạp. Nhãn mác dễ gây nhầm lẫn và thông tin thường bị thiếu. Điểm Xanh được tạo ra để đơn giản hóa việc này, cung cấp cho bạn xếp hạng môi trường **rõ ràng**, **dựa trên khoa học** và **minh bạch** cho các sản phẩm thực phẩm, ngay tại nơi bạn cần: khi bạn mua sắm.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Tính minh bạch';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Không giống như các nhãn hiệu độc quyền, phép tính Điểm Xanh **hoàn toàn mở** và có thể được **xác minh bởi bất kỳ ai**.';

  @override
  String get guide_nova_title => 'Thức ăn siêu chế biến';

  @override
  String get guide_nova_what_is_nova_title => 'Siêu xử lý là gì?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Nhóm NOVA cung cấp thông tin cho bạn về **mức độ chế biến thực phẩm**.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Phân loại NOVA cho phép phân loại thực phẩm thành **4 nhóm** dựa trên **mức độ chế biến công nghiệp** (thực phẩm chế biến tối thiểu hoặc chưa chế biến, nguyên liệu nấu ăn, thực phẩm chế biến, thực phẩm siêu chế biến).';

  @override
  String get guide_nova_logos_caption => 'Các logo NOVA';

  @override
  String get guide_nova_groups_title => '4 nhóm NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Có 4 nhóm NOVA, nhóm có vấn đề là Nhóm 4 - Thực phẩm siêu chế biến.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Thực phẩm chế biến tối thiểu hoặc chưa chế biến';

  @override
  String get guide_nova_groups_arg1_text =>
      'Thực phẩm chưa qua chế biến (hay tự nhiên) là **các bộ phận ăn được của thực vật** (hạt, quả, lá, thân, rễ) **hoặc động vật** (cơ, nội tạng, trứng, sữa), cũng như nấm, tảo và nước, sau khi được tách ra khỏi thiên nhiên.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Các thành phần ẩm thực đã qua chế biến';

  @override
  String get guide_nova_groups_arg2_text =>
      'Các thành phần ẩm thực đã qua chế biến, chẳng hạn như **dầu, bơ, đường và muối**, là những chất có nguồn gốc từ thực phẩm Nhóm 1 hoặc từ thiên nhiên thông qua các quá trình bao gồm ép, tinh chế, nghiền, xay và sấy khô.';

  @override
  String get guide_nova_groups_arg3_title => 'Thực phẩm đã qua chế biến';

  @override
  String get guide_nova_groups_arg3_text =>
      'Thực phẩm chế biến, chẳng hạn như rau đóng chai, cá đóng hộp, trái cây ngâm siro, pho mát và bánh mì tươi, **chủ yếu được chế biến bằng cách thêm muối, dầu, đường hoặc các chất khác từ thực phẩm Nhóm 2 vào Nhóm 1**. Các quy trình bao gồm nhiều phương pháp bảo quản hoặc chế biến khác nhau, và trong trường hợp bánh mì và pho mát, là lên men không cồn. Hầu hết thực phẩm chế biến đều có hai hoặc ba thành phần và được nhận biết là phiên bản biến thể của thực phẩm Nhóm 1. Chúng có thể được ăn riêng hoặc phổ biến hơn là kết hợp với các thực phẩm khác.';

  @override
  String get guide_nova_groups_arg4_title => 'Thức ăn siêu chế biến';

  @override
  String get guide_nova_groups_arg4_text =>
      'Thực phẩm siêu chế biến, chẳng hạn như nước ngọt, đồ ăn nhẹ đóng gói ngọt hoặc mặn, các sản phẩm thịt tái chế và các món ăn đông lạnh chế biến sẵn, **không chỉ đơn thuần là thực phẩm biến đổi gen mà là các công thức được làm chủ yếu hoặc hoàn toàn từ các chất có nguồn gốc từ thực phẩm và phụ gia**, với rất ít hoặc không có thực phẩm Nhóm 1 nguyên vẹn. Các thành phần trong các công thức này thường bao gồm các thành phần cũng có trong thực phẩm chế biến, chẳng hạn như đường, dầu, chất béo hoặc muối. Tuy nhiên, các sản phẩm siêu chế biến cũng chứa các nguồn năng lượng và chất dinh dưỡng khác thường không được sử dụng trong chế biến ẩm thực. Một số trong số này được chiết xuất trực tiếp từ thực phẩm, chẳng hạn như casein, lactose, whey và gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Các vấn đề với quá trình xử lý siêu việt';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Xử lý cực độ các thành phần thực phẩm';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Nhiều loại **có nguồn gốc từ quá trình chế biến thêm các thành phần thực phẩm**, chẳng hạn như dầu hydro hóa hoặc dầu este hóa, protein thủy phân, protein đậu nành cô lập, maltodextrin, đường nghịch chuyển và xi-rô ngô có hàm lượng fructose cao.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Phụ gia vượt xa tiêu chuẩn an toàn thực phẩm thuần túy';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Phụ gia trong thực phẩm siêu chế biến bao gồm một số chất cũng được sử dụng trong thực phẩm chế biến, chẳng hạn như chất bảo quản, chất chống oxy hóa và chất ổn định. Các loại phụ gia chỉ có trong sản phẩm siêu chế biến bao gồm những chất được sử dụng **để bắt chước hoặc tăng cường chất lượng cảm quan của thực phẩm hoặc để che giấu những đặc điểm không ngon miệng của sản phẩm cuối cùng**. Các chất phụ gia này bao gồm thuốc nhuộm và các loại màu khác, chất ổn định màu; hương liệu, chất tăng cường hương vị, chất tạo ngọt không đường; và các chất hỗ trợ chế biến như chất tạo ga, chất làm săn chắc, chất tạo khối và chất chống tạo khối, chất phá bọt, chất chống vón cục và chất tạo bóng, chất nhũ hóa, chất tạo phức kim loại và chất giữ ẩm.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Xử lý bạn không thể làm ở nhà';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Nhiều chuỗi quy trình được sử dụng** để kết hợp các nguyên liệu thường rất đa dạng và tạo ra sản phẩm cuối cùng (do đó được gọi là \'siêu chế biến\'). Các quy trình này bao gồm một số quy trình **không có quy trình tương đương trong nước**, chẳng hạn như hydro hóa và thủy phân, đùn và đúc khuôn, và sơ chế để chiên.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Các khía cạnh săn mồi và tài chính của quá trình siêu chế biến';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Mục đích chung của siêu chế biến là tạo ra các sản phẩm thực phẩm có thương hiệu**, **tiện lợi** (bền, dễ tiêu thụ), **hấp dẫn** (siêu ngon miệng) và **lợi nhuận cao** (nguyên liệu giá rẻ) được thiết kế để thay thế tất cả các nhóm thực phẩm khác. Các sản phẩm thực phẩm siêu chế biến thường được đóng gói hấp dẫn và tiếp thị rầm rộ.';

  @override
  String get guide_nova_explanations_arg5_title =>
      'Một mối nguy hiểm cho sức khỏe';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Từ năm 2018, với NutriNet-Santé, những mối liên hệ đầu tiên giữa **việc tiêu thụ thực phẩm siêu chế biến và nguy cơ gia tăng ung thư, bệnh tim mạch và tiểu đường đã được nêu bật**. Ngày nay, hơn 90 nghiên cứu trên toàn thế giới đã xác nhận những phát hiện này.\nMối liên hệ mạnh nhất liên quan đến **béo phì, tử vong do tim mạch và các triệu chứng trầm cảm**. Ở trẻ em, những ảnh hưởng này chủ yếu được quan sát thấy trên cân nặng và mất cân bằng lipid.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Các quốc gia khuyến cáo hạn chế chúng';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Một số quốc gia sử dụng nhóm NOVA làm hướng dẫn hoặc mục tiêu về chế độ ăn uống của họ, ví dụ:\n\n- **Hướng dẫn về chế độ ăn uống của Brazil** **khuyến nghị hạn chế tiêu thụ** thực phẩm chế biến sẵn và tránh thực phẩm siêu chế biến.\n\n- **Mục tiêu chính sách dinh dưỡng y tế công cộng của Pháp** trong giai đoạn 2018-2022 là **giảm 20% lượng tiêu thụ thực phẩm siêu chế biến nhóm 4**.';

  @override
  String get guide_nova_share_link => 'https://world-vi.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Chào mừng đến với Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Open Food Facts là gì?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts là cơ sở dữ liệu **hợp tác**, **miễn phí** và **mở** về các sản phẩm thực phẩm từ khắp nơi trên thế giới.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Chúng tôi tin rằng mọi người đều nên được tiếp cận thông tin về những gì họ ăn. Bằng cách thu thập dữ liệu về thành phần, chất gây dị ứng, thông tin dinh dưỡng, v.v., **chúng tôi trao quyền cho người tiêu dùng đưa ra lựa chọn sáng suốt** và thúc đẩy ngành công nghiệp thực phẩm **hướng tới sự minh bạch hơn**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Các tính năng của Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Nhận cảnh báo về các thành phần không mong muốn của bạn';

  @override
  String get guide_open_food_facts_tips_title => 'Mẹo chụp ảnh đẹp';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Không nên làm';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Tránh bóng tối và ánh sáng chói.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Không có văn bản mờ hoặc mất nét.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Không cắt bỏ một phần văn bản.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Tránh những phông nền lộn xộn.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Nên làm';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Sử dụng ánh sáng tốt và đều.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Đảm bảo văn bản rõ ràng và dễ đọc.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Ghi lại toàn bộ danh sách thành phần.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Đặt sản phẩm trên bề mặt phẳng.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Hãy giúp chúng tôi xây dựng \"Wikipedia về Thực phẩm\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Điểm về chất lượng dinh dưỡng';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Một điểm cần tránh là thực phẩm siêu chế biến';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Một điểm số cho hành tinh';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-vi.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Chào mừng đến với Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Open Pet Food Facts là gì?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts mở rộng sứ mệnh của chúng tôi đến những người bạn lông lá! Đây là **cơ sở dữ liệu về các sản phẩm thức ăn cho thú cưng dành cho mèo, chó và các bạn đồng hành khác**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Chúng tôi thu thập thông tin về **thành phần**, **phân tích dinh dưỡng** và hướng dẫn cho ăn để giúp chủ vật nuôi lựa chọn loại thức ăn tốt nhất cho nhu cầu của vật nuôi.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Đặc điểm của Thực phẩm cho thú cưng mở';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Nhận cảnh báo về các thành phần không mong muốn của bạn';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Thú cưng của bạn có bị dị ứng với bất kỳ thành phần nào không? Bạn có thể thiết lập danh sách các thành phần mỹ phẩm cần tránh ngay trong ứng dụng!';

  @override
  String get guide_open_pet_food_facts_tips_title => 'Mẹo chụp ảnh đẹp';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Không nên làm';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Tránh bóng tối và ánh sáng chói.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Không có văn bản mờ hoặc mất nét.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Không cắt bỏ một phần văn bản.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Tránh những phông nền lộn xộn.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Nên làm';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Sử dụng ánh sáng tốt và đều.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Đảm bảo văn bản rõ ràng và dễ đọc.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Ghi lại toàn bộ danh sách thành phần.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Đặt sản phẩm trên bề mặt phẳng.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Lưu ý về cách chấm điểm';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Việc phát triển hệ thống chấm điểm cho thức ăn thú cưng **hiện không phải là ưu tiên hàng đầu**. Phương pháp này sẽ rất phức tạp, vì nhu cầu dinh dưỡng thay đổi rất nhiều tùy theo loài, độ tuổi và tình trạng sức khỏe. Chúng tôi vẫn chưa tìm được nhóm khoa học độc lập nào có khả năng xây dựng hệ thống chấm điểm như vậy.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-vi.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Chào mừng đến với Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Open Beauty Facts là gì?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts là cơ sở dữ liệu cộng tác về **các sản phẩm mỹ phẩm**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Mục tiêu của chúng tôi là giải mã danh sách thành phần để giúp bạn **hiểu rõ những gì có trong các sản phẩm chăm sóc cá nhân của mình**. Từ kem dưỡng ẩm đến đồ trang điểm, chúng tôi thu thập dữ liệu về thành phần, chất gây dị ứng và bao bì để thúc đẩy tính minh bạch trong ngành mỹ phẩm.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Các tính năng của Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Nhận cảnh báo về các thành phần không mong muốn của bạn';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Bạn có dị ứng với bất kỳ thành phần nào không? Bạn muốn tránh các chất gây mụn? Bạn muốn tránh xa các thành phần gây tranh cãi? Bạn có thể thiết lập danh sách các thành phần mỹ phẩm cần tránh ngay trong ứng dụng!';

  @override
  String get guide_open_beauty_facts_tips_title => 'Mẹo chụp ảnh đẹp';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Không nên làm';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Tránh bóng tối và ánh sáng chói.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Không có văn bản mờ hoặc mất nét.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Không cắt bỏ một phần văn bản.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Tránh những phông nền lộn xộn.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Nên làm';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Sử dụng ánh sáng tốt và đều.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Đảm bảo văn bản rõ ràng và dễ đọc.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Ghi lại toàn bộ danh sách thành phần.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Chụp bao nhiêu ảnh tùy thích nếu chai bị cong.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Bạn có thể cần phải bóc nhãn để xem danh sách thành phần.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Đặt sản phẩm trên bề mặt phẳng.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Lưu ý về cách chấm điểm';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Không giống như thực phẩm, thế giới mỹ phẩm **không có hệ thống chấm điểm được chính phủ công nhận rộng rãi như Nutri-Score**. Hiệu quả của thành phần có thể rất khác nhau tùy thuộc vào từng cá nhân, loại da, tình trạng dị ứng và mối quan tâm của từng người.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-vi.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Chào mừng đến với Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Open Prices là gì?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices là một dự án **thu thập và chia sẻ giá sản phẩm trên toàn thế giới**. Đây là một bộ dữ liệu công khai có thể được sử dụng cho mục đích nghiên cứu, phân tích, v.v. Open Prices được phát triển và duy trì bởi Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title =>
      'Open Prices hoạt động như thế nào?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Chúng tôi đang huy động cộng đồng để xây dựng một bộ dữ liệu giá nguồn mở**. Người dùng có thể thêm giá thông qua ứng dụng web này hoặc qua ứng dụng di động chính thức Open Food Facts. Các nhà bán lẻ hoặc ứng dụng của bên thứ ba cũng có thể đóng góp bằng cách sử dụng API của chúng tôi.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Thu thập hình ảnh các thẻ giá ở lối đi';

  @override
  String get guide_open_prices_how_arg2_title => 'Thu thập hình ảnh biên lai';

  @override
  String get guide_open_prices_why_title =>
      'Tại sao Open Food Facts lại làm như vậy?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Thông tin giá cả đóng vai trò tối quan trọng trong việc hiểu rõ hệ thống thực phẩm. Đây là yếu tố then chốt để hiểu rõ chi phí thực phẩm và thúc đẩy chế độ ăn uống lành mạnh hơn. Việc công khai dữ liệu giá là một cách giúp các nhà nghiên cứu, nhà báo và người dân **hiểu rõ hơn về sự thay đổi giá thực phẩm theo khu vực địa lý và thời gian**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Theo dõi sự phát triển của giá theo thời gian';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Xem **sự tiến hóa của giá cả**: lạm phát suy giảm, lạm phát giá rẻ, chúng ta có thể cùng theo dõi chúng!';

  @override
  String get guide_open_prices_why_arg2_title => 'So sánh giá gần bạn';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Khi có thêm nhiều mức giá hơn, bạn có thể phát hiện **những cửa hàng rẻ nhất xung quanh bạn**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Bạn có cân nhắc việc lấy giá từ trang web của các nhà bán lẻ không?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Vì lý do pháp lý và kỹ thuật, **chúng tôi không coi việc lấy giá từ trang web của nhà bán lẻ là một cách hợp lệ để đóng góp cho Open Prices**. Chúng tôi muốn đảm bảo rằng giá chúng tôi thu thập là chính xác và cập nhật, và việc nhận giá lấy từ người đóng góp không cho phép chúng tôi làm điều đó.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Thu thập giá là một lựa chọn được cân nhắc trong phiên bản Open Prices trong tương lai, nhưng Open Prices sẽ tự thực hiện việc này để chúng ta có bằng chứng về giá dựa trên trang HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Bạn có thể đóng góp giá bằng cách sử dụng API của chúng tôi.\nNếu bạn muốn đóng góp giá ở quy mô lớn, vui lòng liên hệ với chúng tôi theo địa chỉ prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Chào mừng đến với Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Open Products Facts là gì?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts là cơ sở dữ liệu mở khổng lồ dành cho **bất kỳ sản phẩm nào có mã vạch, không phải thực phẩm, mỹ phẩm hoặc thức ăn cho thú cưng**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Từ đồ điện tử đến đồ chơi, quần áo đến đồ dùng vệ sinh, nếu có mã vạch, bạn đều có thể thêm vào. Dự án này hướng đến mục tiêu tạo ra một \"Internet vạn vật\" cho các vật dụng hàng ngày, giúp thông tin về chúng được tiếp cận rộng rãi.';

  @override
  String get guide_open_products_facts_features_title =>
      'Tính năng của Sản phẩm Mở Sự kiện';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts hướng đến mục tiêu cung cấp cho người tiêu dùng giải pháp **kéo dài tuổi thọ của đồ vật** bằng cách cung cấp các giải pháp tuần hoàn để bảo trì, **sửa chữa**, **tái chế** đồ vật hoặc trao cho họ chủ sở hữu mới.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Dấu chân carbon của một số sản phẩm';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Tác động CO2** của Cơ quan Môi trường Pháp ADEME cung cấp **tác động carbon** của nhiều danh mục, hãy đảm bảo phân loại sản phẩm chính xác.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Chỉ số khả năng sửa chữa cho nhiều sản phẩm';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Bất cứ khi nào có chỉ số khả năng sửa chữa của Pháp, chúng tôi sẽ hiển thị. Hơn nữa, **bạn có thể bắt đầu thu thập các biến số bằng Folksonomy Engine**; để chúng tôi có thể tự tính toán lại trong tương lai, ngay cả ở những quốc gia chưa có chỉ số này.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Tìm cách quyên góp/bán lại sản phẩm của bạn';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Chúng tôi cung cấp liên kết đến **các dịch vụ thân thiện với môi trường của bên thứ ba** giúp bạn tìm được loại sản phẩm bạn đang tìm kiếm, dưới dạng sản phẩm đã qua sử dụng, để bảo vệ tài nguyên thiên nhiên tốt hơn.\nLưu ý rằng chúng tôi không được trả tiền để làm điều đó, và hệ thống này chỉ hoạt động như một ví dụ cho hai trang web ở Pháp. Bạn có thể giúp mở rộng hệ thống này bằng cách ghi lại nhiều trang web hơn trên wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Thông tin nào hữu ích?';

  @override
  String get guide_open_products_facts_information_text =>
      'Với phạm vi sản phẩm đa dạng như vậy, **dữ liệu chúng tôi thu thập rất linh hoạt**. Để làm được điều đó, **chúng tôi đã tạo ra Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'Công cụ Folksonomy';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine là một công cụ giúp bạn hoàn thiện sản phẩm với các thuộc tính phù hợp. Công cụ này giúp cải thiện khả năng tìm kiếm và khám phá, đồng thời tính toán và hiển thị những thông tin thú vị trong tương lai.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Bạn có thể thêm bất kỳ khóa và giá trị nào như: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Bạn sẽ nhận được gợi ý tự động về các thuộc tính có thể có và bạn hoàn toàn có thể thêm và ghi lại các thuộc tính mới cho loại sản phẩm yêu thích của mình.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-vi.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Mở sở thích thực phẩm';

  @override
  String get guide_coming_soon_button_title => 'Sắp ra mắt';

  @override
  String get guide_learn_more_subtitle => 'Nhấn để tìm hiểu thêm';

  @override
  String get preview_badge => 'Xem trước';

  @override
  String get prices_feedback_form =>
      'Nhấp vào đây để gửi phản hồi của bạn về tính năng mới này!';

  @override
  String get menu_button_list_actions => 'Chọn một hành động';

  @override
  String get error_loading_photo => 'Lỗi khi tải ảnh';

  @override
  String get photo_viewer_action_use_picture_as => 'Sử dụng như…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Sử dụng hình ảnh này làm…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Sử dụng hình ảnh này làm… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Chi tiết';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Chi tiết của bức ảnh này';

  @override
  String get photo_viewer_details_title => 'Chi tiết của bức ảnh';

  @override
  String get photo_viewer_details_contributor_title => 'Người đóng góp';

  @override
  String get photo_viewer_details_size_title => 'Kích cỡ';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixel';
  }

  @override
  String get photo_viewer_details_date_title => 'Ngày';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Tương thích';

  @override
  String get user_lists_action_multi_select => 'Chọn nhiều';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Điểm tương thích của bạn: $score%';
  }

  @override
  String get product_image_front_accessibility_label =>
      'Hình ảnh của mặt trước';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Hình ảnh trong danh sách các thành phần';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Hình ảnh dinh dưỡng';

  @override
  String get product_image_packaging_accessibility_label => 'Hình ảnh bao bì';

  @override
  String get product_image_other_accessibility_label => 'Hình ảnh khác';

  @override
  String get product_image_outdated_message =>
      'Hình ảnh này có thể đã lỗi thời';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (hình ảnh này có thể đã lỗi thời)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (hình ảnh này có thể bị khóa bởi nhà sản xuất)';
  }

  @override
  String get product_image_error => 'Không thể tải hình ảnh!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Không thể tải $type (lỗi mạng?)';
  }

  @override
  String get product_page_image_no_image_available => 'Không có hình ảnh\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Không có hình ảnh nào cho sản phẩm này';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Sắp xếp lại hoặc ẩn hành động';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Chỉnh sửa hành động';

  @override
  String get product_page_action_bar_item_move_up => 'Di chuyển lên';

  @override
  String get product_page_action_bar_item_move_down => 'Di chuyển xuống';

  @override
  String get product_page_action_bar_item_enable => 'Kích hoạt hành động';

  @override
  String get product_page_action_bar_item_disable => 'Vô hiệu hóa hành động';

  @override
  String get product_page_pending_operations_banner_title =>
      'Đang tải lên các chỉnh sửa của bạn…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Dữ liệu hiển thị trên trang này **chưa phản ánh những thay đổi của bạn**.\nVui lòng đợi vài giây…';

  @override
  String get product_add_a_language => 'Thêm ngôn ngữ';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Mã vạch $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Xóa sản phẩm này khỏi vòng quay';

  @override
  String get carousel_unsupported_header => 'Mã vạch không được hỗ trợ!';

  @override
  String get carousel_unsupported_title => 'Ồ!';

  @override
  String get carousel_unsupported_text =>
      'Mã vạch được quét không được Open Food Facts! hỗ trợ.';

  @override
  String get carousel_error_header => 'Lỗi!';

  @override
  String get carousel_error_title => 'Thật là tệ!';

  @override
  String get carousel_error_text_1 =>
      'Chúng tôi không thể tải xuống thông tin về mã vạch này:';

  @override
  String get carousel_error_text_2 =>
      'Vui lòng kiểm tra kết nối Internet của bạn hoặc nhấp vào nút này:';

  @override
  String get carousel_error_button => 'Thử lại';

  @override
  String get carousel_unknown_product_header => 'Sản phẩm không xác định';

  @override
  String get carousel_unknown_product_title =>
      'Xin chúc mừng!\nBạn đã tìm thấy __viên ngọc quý hiếm!__';

  @override
  String get carousel_unknown_product_text =>
      'Cơ sở dữ liệu cộng tác của chúng tôi chứa hơn **3 triệu sản phẩm**, nhưng mã vạch này không tồn tại: ';

  @override
  String get carousel_unknown_product_button => 'Thêm sản phẩm này';

  @override
  String get carousel_loading_header => 'Đang tải thông tin...';

  @override
  String get carousel_loading_title =>
      'Bạn vừa quét một sản phẩm có mã vạch sau:';

  @override
  String get carousel_loading_text =>
      'Chúng tôi đang tìm kiếm sản phẩm này trong cơ sở dữ liệu có hơn **3 triệu sản phẩm!**';

  @override
  String get product_type_subtitle_food =>
      'Rau, trái cây, thực phẩm đông lạnh…';

  @override
  String get product_type_subtitle_beauty =>
      'Đồ trang điểm, xà phòng, kem đánh răng…';

  @override
  String get product_type_subtitle_pet_food => 'Thức ăn cho chó, mèo…';

  @override
  String get product_type_subtitle_product =>
      'Điện thoại thông minh, đồ nội thất…';

  @override
  String get photo_field_front => 'Ảnh sản phẩm';

  @override
  String get photo_field_ingredients => 'Ảnh chụp thành phần';

  @override
  String get photo_field_nutrition => 'Ảnh dinh dưỡng';

  @override
  String get photo_field_packaging => 'Ảnh hướng dẫn tái chế';

  @override
  String get photo_already_exists => 'Bức ảnh này đã tồn tại';

  @override
  String get photo_missing => 'Bức ảnh này bị mất';

  @override
  String get date => 'Ngày';

  @override
  String get photo_rotate_left => 'Xoay trái';

  @override
  String get photo_rotate_right => 'Xoay phải';

  @override
  String get photo_undo_action => 'Hoàn tác hành động trước đó';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Bản đồ thế giới của $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Những người đóng góp cho OpenStreetMap';

  @override
  String get not_applicable_short => 'Không có';

  @override
  String get knowledge_panel_warning_text => 'Cảnh báo';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Tại sao Nutri-Score này lại khác với Nutri-Score trên bao bì?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Có hai cách giải thích:\nDanh sách thành phần và/hoặc thông tin dinh dưỡng chưa được cập nhật.\n\nChúng tôi cung cấp \"Phép tính mới\" của Nutri-Score (hoặc V2). Vui lòng kiểm tra xem bạn có biểu ngữ \"Phép tính mới\" trên bao bì hay không.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Kiểm tra thành phần';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Kiểm tra thông tin dinh dưỡng';

  @override
  String url_not_supported(String url) {
    return 'Thật không may, chúng tôi không thể mở URL:\n$url';
  }

  @override
  String get product_list_export => 'Xuất khẩu';

  @override
  String get product_list_import => 'Nhập khẩu';

  @override
  String get product_footer_action_barcode => 'Xem mã vạch';

  @override
  String get product_footer_action_barcode_short => 'Mã vạch';

  @override
  String get product_footer_action_open_website => 'Mở trang web';

  @override
  String get product_footer_action_report => 'Báo cáo';

  @override
  String get product_footer_action_contributor_guide => 'Giúp đỡ';

  @override
  String get product_footer_action_data_quality_tags => 'Chất lượng dữ liệu';

  @override
  String get product_page_tab_for_me => 'Đối với tôi';

  @override
  String get product_page_tab_website => 'Trang web';

  @override
  String get product_page_tab_prices => 'Giá cả';

  @override
  String get prices_explanation_card_title => 'Tại sao lại có giá?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** là một dự án thu thập và chia sẻ giá sản phẩm trên toàn thế giới 🌍. Open Prices được phát triển và duy trì bởi Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Tìm hiểu thêm';

  @override
  String get product_page_tab_folksonomy => 'Dân gian học';

  @override
  String get folksonomy_explanation_card_title =>
      'Thuộc tính Folksonomy là gì?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Thuộc tính dựa trên **khóa-giá trị**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Những thuộc tính này được tạo ra và lưu trữ bởi những người đóng góp cho mọi mục đích sử dụng.';

  @override
  String get folksonomy_action_external_link_title => 'Mở liên kết ngoài';

  @override
  String get folksonomy_action_external_link_warning =>
      'Liên kết ngoài có thể không an toàn. Bạn có thực sự muốn truy cập không?';

  @override
  String get prices_products_empty_title => 'Không có giá nào có sẵn';

  @override
  String get prices_products_empty_explanation =>
      'Hãy là người đầu tiên đóng góp!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Sản phẩm hàng đầu $pageSize (tổng cộng: $total)';
  }

  @override
  String get app_review_title => 'Bạn có thích ứng dụng này không?';

  @override
  String get app_review_low => 'Có thể làm tốt hơn';

  @override
  String get app_review_medium => 'Không tệ';

  @override
  String get app_review_high => 'Tôi thích nó!';

  @override
  String get app_review_feedback_modal_title =>
      'Hãy giúp chúng tôi cải thiện ứng dụng của chúng tôi';

  @override
  String get app_review_feedback_modal_content =>
      'Nếu bạn có vài phút, vui lòng trả lời mẫu này để **chúng tôi có thể cải thiện trong các bản cập nhật trong tương lai**:';

  @override
  String get app_review_feedback_modal_open_form => 'Trả lời mẫu đơn';

  @override
  String get app_review_feedback_modal_later => 'Hỏi tôi sau nhé';

  @override
  String get nutrition_facts_extract_new =>
      'MỚI: Bạn có thể tự động chiết xuất chất dinh dưỡng từ hình ảnh!';

  @override
  String get nutrition_facts_extract_button_text => 'Trích xuất ngay';

  @override
  String get nutrition_facts_extract_in_progress => 'Đang trích xuất…';

  @override
  String get nutrition_facts_extract_successful => 'Trích xuất thành công';

  @override
  String get nutrition_facts_extract_failed =>
      'Không thể trích xuất chất dinh dưỡng từ hình ảnh';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Thống kê';

  @override
  String get prices_stats_title => 'Thống kê giá cả';

  @override
  String get prices_stats_prices_section => 'Giá cả';

  @override
  String get prices_stats_products_section => 'Sản phẩm';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Người đóng góp';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Các tùy chọn khác';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Tiêu thụ';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Đồ ăn';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Sản phẩm';

  @override
  String get prices_stats_pet_food => 'Thức ăn cho thú cưng';

  @override
  String get prices_stats_osm => 'Bản đồ đường phố mở';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Quốc gia';

  @override
  String get prices_stats_price_tag => 'Giá cả';

  @override
  String get prices_stats_receipt => 'Biên lai';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Trang web';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Khác';

  @override
  String get prices_stats_last_updated => 'Cập nhật lần cuối vào';

  @override
  String get prices_stats_error => 'Đã xảy ra lỗi khi tải số liệu thống kê.';

  @override
  String get product_edit_robotoff_question_answered =>
      'Câu hỏi đã được giải đáp!';

  @override
  String get product_edit_robotoff_proof => 'Bằng chứng';

  @override
  String get preferences_card_general => 'Chung';

  @override
  String get preferences_prices_title => 'Giá cả';

  @override
  String get preferences_prices_subtitle => 'Quản lý tùy chọn giá của bạn';

  @override
  String get preferences_card_project => 'Dự án Open Food Facts';

  @override
  String get preferences_contribute_title => 'Góp phần';

  @override
  String get preferences_my_contributions_title => 'Đóng góp của tôi';

  @override
  String get preferences_my_stats_title => 'Thống kê của tôi';

  @override
  String get preferences_contribute_subtitle =>
      'Dịch, cải thiện công cụ của chúng tôi…';

  @override
  String get preferences_connect_title => 'Kết nối';

  @override
  String get preferences_connect_subtitle =>
      'Liên hệ hoặc theo dõi chúng tôi trên mạng xã hội';

  @override
  String get preferences_support_title => 'Quyên góp';

  @override
  String get preferences_support_subtitle =>
      'Hãy giúp chúng tôi thông tin đến hàng triệu người tiêu dùng trên toàn thế giới';

  @override
  String get preferences_card_help => 'Trợ giúp & Hỗ trợ';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle => 'Nhận câu trả lời cho câu hỏi của bạn';

  @override
  String get logged_out => 'Đã đăng xuất';

  @override
  String get preferences_app_bar_message =>
      'Cảm ơn bạn đã là thành viên của chúng tôi!';

  @override
  String get preferences_app_bar_products_modified =>
      'Các sản phẩm đã được sửa đổi';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Xem tất cả số liệu thống kê';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Tìm kiếm $provider cho \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Tìm kiếm cài đặt (ví dụ: Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Khả năng truy cập: Hiển thị biểu tượng cảm xúc';

  @override
  String get preferences_accessibility_remove_colors =>
      'Khả năng truy cập: Xóa màu';

  @override
  String get preferences_app_settings_products => 'Sản phẩm';

  @override
  String get preferences_card_about => 'Giới thiệu';

  @override
  String get preferences_legal_information_title => 'Thông tin pháp lý';

  @override
  String get preferences_legal_information_subtitle =>
      'Điều khoản sử dụng, chính sách bảo mật và nhiều hơn nữa';

  @override
  String get preferences_terms_of_use => 'Điều khoản sử dụng';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts là cơ sở dữ liệu về sản phẩm thực phẩm **do mọi người tạo ra, dành cho mọi người**.\nBạn có thể sử dụng cơ sở dữ liệu này để đưa ra những lựa chọn thực phẩm tốt hơn và vì đây là **dữ liệu mở** nên bất kỳ ai cũng có thể **tái sử dụng cho bất kỳ mục đích nào**.';

  @override
  String get preferences_privacy_policy => 'Chính sách bảo mật';

  @override
  String get preferences_licenses => 'Giấy phép';

  @override
  String get preferences_about_app_title => 'Giới thiệu về ứng dụng';

  @override
  String get preferences_about_app_subtitle =>
      'Thông tin kỹ thuật, thông tin dành cho nhà phát triển và nhiều thông tin khác';

  @override
  String get preferences_card_information => 'Thông tin';

  @override
  String get preferences_version_number_title => 'Số phiên bản';

  @override
  String get preferences_scanner_title => 'Máy quét';

  @override
  String get preferences_app_store => 'Cửa hàng ứng dụng';

  @override
  String get preferences_app_system_settings => 'Cài đặt hệ thống';

  @override
  String get preferences_source_code => 'Truy cập mã nguồn';

  @override
  String get preferences_source_code_subtitle =>
      'Và bắt đầu tạo ra tác động cho hàng triệu người';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Nói với toàn thế giới';

  @override
  String get preferences_tips => 'Mẹo';

  @override
  String get tips_discover_nutriscore => 'Khám phá Nutri-Score mới';

  @override
  String get preferences_on_off_website_subtitle =>
      'Trên trang web Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Quản lý tài khoản của tôi';

  @override
  String get preferences_manage_account_tooltip => 'Quản lý tài khoản của bạn';

  @override
  String get preferences_change_password_title => 'Thay đổi mật khẩu của tôi';

  @override
  String get preferences_danger_zone => 'Khu vực nguy hiểm';

  @override
  String get preferences_account_deletion_subtitle =>
      'Mọi đóng góp của bạn sẽ bị mất';

  @override
  String get preferences_contributions_title => 'Đóng góp';

  @override
  String get preferences_dev_mode_app_settings_title => 'Cài đặt ứng dụng';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Cách thử nghiệm để quét sản phẩm ngoại tuyến';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Làm mới tất cả sản phẩm từ máy chủ';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Xin vui lòng tránh làm điều đó trừ khi thực sự cần thiết';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Chế độ demo';

  @override
  String get preferences_dev_mode_add_cards_title => 'Thêm thẻ vào máy quét';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Thêm 3 sản phẩm mẫu vào máy quét';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Người dẫn chương trình Folksonomy';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Máy chủ: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Thí nghiệm về khả năng tiếp cận';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Lựa chọn nhiều sản phẩm cho giá cả';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Bảng kiến thức do người dùng đặt hàng';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Truy cập tạm thời vào tìm kiếm vị trí';

  @override
  String get preferences_dev_mode_comparison_title =>
      'So sánh cạnh nhau cho 2 hoặc 3 sản phẩm';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Nhập danh sách sản phẩm';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Điểm số và phương pháp luận';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Khám phá cách tính điểm Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Khám phá những thay đổi chính về phương pháp luận';

  @override
  String get preferences_faq_discover_project_title => 'Khám phá những dự án';

  @override
  String get preferences_faq_discover_off_title =>
      'Khám phá sự thật về thực phẩm mở';

  @override
  String get preferences_faq_discover_obf_title =>
      'Khám phá sự thật về vẻ đẹp mở';

  @override
  String get preferences_faq_discover_opff_title =>
      'Khám phá sự thật về thức ăn cho thú cưng';

  @override
  String get preferences_faq_discover_op_title => 'Khám phá Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Khám phá sự thật về sản phẩm mở';

  @override
  String get preferences_faq_faq_title => 'FAQ - Những câu hỏi thường gặp';

  @override
  String get preferences_faq_off_ngo_title =>
      'Tổ chức phi chính phủ Open Food Facts';

  @override
  String get preferences_about_information_title => 'Thông tin';

  @override
  String get preferences_connect_community_updates_title =>
      'Nhận thông tin cập nhật từ cộng đồng';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Cập nhật tin tức về ứng dụng và cộng đồng';

  @override
  String get preferences_connect_community_calendar_title =>
      'Đăng ký lịch cộng đồng của chúng tôi';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Tham gia bằng cách tham dự một trong các sự kiện trực tuyến của chúng tôi';

  @override
  String get preferences_connect_blog_title => 'Blog Sự thật về Thực phẩm Mở';

  @override
  String get preferences_connect_blog_subtitle =>
      'Nhận tin tức mới nhất khi chúng xảy ra';

  @override
  String get preferences_connect_community_help_title =>
      'Nhận sự giúp đỡ từ cộng đồng';

  @override
  String get preferences_connect_improve_app_title =>
      'Hãy giúp chúng tôi cải thiện ứng dụng';

  @override
  String get preferences_connect_debug_info_title =>
      'Gửi cho chúng tôi thông tin gỡ lỗi';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Gửi cho chúng tôi một email với thông tin gỡ lỗi chi tiết';

  @override
  String get preferences_connect_feedback_title =>
      'Gửi cho chúng tôi phản hồi về ứng dụng';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Giúp định hình tương lai của ứng dụng';

  @override
  String get preferences_connect_survey_title => 'Tham gia khảo sát ứng dụng';

  @override
  String get preferences_connect_survey_subtitle =>
      'Giúp chúng tôi hiểu những gì chúng tôi nên xây dựng tiếp theo';

  @override
  String get preferences_connect_professionals_title => 'Chuyên gia';

  @override
  String get preferences_connect_pro_subtitle =>
      'Hoàn toàn miễn phí, đảm bảo dữ liệu chính xác cho 500 ứng dụng và hàng triệu người dùng. Tự phục vụ, tương thích với PIM hoặc bảng tính (XLSX) của bạn';

  @override
  String get preferences_connect_pro_email_subtitle => 'Liên hệ để bắt đầu';

  @override
  String get preferences_connect_press_title => 'Báo chí';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Nhận tất cả tài liệu bạn cần cho báo cáo của mình';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Liên hệ để được báo chí hỏi thăm hoặc cho chúng tôi biết về báo cáo của bạn';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Trở thành một tình nguyện viên tích cực';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Phát triển, Truyền thông, Thiết kế… mọi hình thức tình nguyện hoặc chuyên môn đều được hoan nghênh!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Khám phá một số cách bạn có thể đóng góp';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Phát triển ứng dụng di động';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Tìm hiểu cách đóng góp vào quá trình phát triển phần mềm';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Bản dựng không ổn định hàng ngày, các tính năng hoàn toàn mới';

  @override
  String get preferences_contribute_local_community_title =>
      'Phát triển cộng đồng địa phương của bạn';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Hỗ trợ dịch thuật phần mềm, nội dung, phân tích thành phần';

  @override
  String get preferences_contribute_share_subtitle =>
      'Chúng tôi đã chuẩn bị một mẫu nhỏ để giúp bạn :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Các bước đơn giản để tăng cường tính minh bạch về thực phẩm ở quốc gia của bạn';

  @override
  String get preferences_contribute_data_quality_title => 'Chất lượng dữ liệu';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Tham gia nhóm chất lượng dữ liệu';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Hãy tham gia cùng chúng tôi để đảm bảo cơ sở dữ liệu được hoàn thiện và chính xác';

  @override
  String get preferences_contributions_products_added_title =>
      'Sản phẩm đã thêm';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Sản phẩm mới tôi đã thêm vào Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Sản phẩm tôi cần hoàn thành';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Tất cả các sản phẩm chưa hoàn thành';

  @override
  String get preferences_my_contributions_prices_title => 'Giá cả';

  @override
  String get preferences_my_contributions_my_prices_title => 'Giá của tôi';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Giá của tôi, bằng chứng của tôi…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Sản phẩm bạn có thể giúp hoàn thành';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Giúp tính toán Điểm Nutri-Score & Điểm Green-Score ở quốc gia của bạn';

  @override
  String get preferences_prices_user_prices_subtitle => 'Giá tôi đã đóng góp';

  @override
  String get preferences_prices_proofs_subtitle => 'Thẻ giá và biên lai';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Chụp ảnh biên lai của bạn và quét mã vạch liên quan';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Chụp ảnh giá cả trong cửa hàng';

  @override
  String get preferences_prices_newest_title => 'Giá mới nhất';

  @override
  String get preferences_prices_newest_subtitle =>
      'Giá mới nhất được cộng đồng Open Prices thêm vào';

  @override
  String get preferences_prices_top_contributors_title =>
      'Những người đóng góp nhiều giá nhất';

  @override
  String get preferences_prices_metrics_title => 'Số liệu giá mở';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Theo dõi sự phát triển của dự án';

  @override
  String get preferences_prices_ways_contribute_title => 'Các cách đóng góp';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Xác nhận giá do bạn hoặc người khác thêm vào, với sự trợ giúp của AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Nhanh chóng thêm nhiều biên lai hoặc ảnh kệ từ cuộn camera của bạn';

  @override
  String get preferences_prices_challenges_title => 'Thử thách hàng tháng';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Tham gia các nhiệm vụ theo chủ đề hàng tháng để thu thập giá';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Lấy lại dữ liệu lòng trung thành của bạn';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Tìm hiểu cách yêu cầu dữ liệu của bạn';

  @override
  String get preferences_page_customize_app_title => 'Tùy chỉnh ứng dụng';

  @override
  String get preferences_page_contribute_project_title => 'Đóng góp cho dự án';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Những cách đơn giản để giúp Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Phương pháp tính điểm, trợ giúp và nhiều thông tin khác về dự án';

  @override
  String get product_edit_robotoff_positive_button => 'Chấp nhận đề xuất';

  @override
  String get product_edit_robotoff_negative_button => 'Từ chối đề xuất';

  @override
  String get product_edit_robotoff_show_proof => 'Hiển thị bằng chứng';

  @override
  String get product_edit_robotoff_expand_proof => 'Mở rộng bằng chứng';

  @override
  String get product_page_tab_raw_data => 'Dữ liệu thô';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Trang $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Trang $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count trong số $total mục';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count trong số $total mục';
  }

  @override
  String item_count(int count) {
    return '$count mục';
  }

  @override
  String item_count_string(String count) {
    return '$count mục';
  }

  @override
  String get prices_no_result => 'Không tìm thấy số liệu thống kê giá.';

  @override
  String get prices_error_loading_more_items => 'Lỗi khi tải thêm mục';

  @override
  String get prices_proof_error =>
      'Xác thực không thành công, không thể lấy bằng chứng';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count trong số $total bản chứng minh';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count trong số $total người đóng góp';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count trong số $total địa điểm';
  }

  @override
  String prices_locations_count(int count) {
    return '$count địa điểm';
  }

  @override
  String get restart_to_apply_message =>
      'Vui lòng khởi động lại ứng dụng để áp dụng những thay đổi.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Giao diện đồ họa';

  @override
  String get preferences_app_settings_media_title => 'Phương tiện truyền thông';

  @override
  String get preferences_about_app_development_title => 'Phát triển';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Phòng thí nghiệm thông tin thực phẩm mở';

  @override
  String get preferences_root_account_title => 'Tài khoản';

  @override
  String get preferences_contribute_translate_header =>
      'Mang Thông tin Thực phẩm Mở sang ngôn ngữ của bạn';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Đăng ký phiên bản alpha của ứng dụng';

  @override
  String get preferences_dev_mode_section_data => 'Đóng góp & Dữ liệu sản phẩm';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Không hiển thị Folksonomy';

  @override
  String get preferences_account_title => 'Tài khoản';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Đã thêm vào $created';
  }

  @override
  String get location_map_details_title => 'Chi tiết vị trí';

  @override
  String get location_map_details_name => 'Tên';

  @override
  String get location_map_details_street => 'Đường phố';

  @override
  String get location_map_details_city => 'Thành phố';

  @override
  String get location_map_details_postcode => 'Mã bưu chính';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Tọa độ';

  @override
  String get location_map_details_osm_id => 'Mã OSM';
}
