// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Thai (`th`).
class AppLocalizationsTh extends AppLocalizations {
  AppLocalizationsTh([String locale = 'th']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'ถูกต้อง';

  @override
  String get add => 'เพิ่ม';

  @override
  String get account_delete_message =>
      'คุณแน่ใจหรือไม่ว่าต้องการลบบัญชี หากมีเหตุผลที่เฉพาะเจาะจงโปรดแจ้งด้านล่าง';

  @override
  String get reason => 'สาเหตุ';

  @override
  String get okay => 'โอเค';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'สร้าง';

  @override
  String get applyButtonText => 'ใช้';

  @override
  String get next_label => 'ถัดไป';

  @override
  String get continue_label => 'ดำเนินการต่อ';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'กลับขึ้นไปด้านบน';

  @override
  String get save => 'บันทึก';

  @override
  String get save_confirmation => 'คุณแน่ใจว่าต้องการจะบันทึกใช่มั้ย';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'ยกเลิก';

  @override
  String get ignore => 'ละเว้น';

  @override
  String get close => 'ปิด';

  @override
  String get no => 'ไม่ใช่';

  @override
  String get stop => 'หยุด';

  @override
  String get finish => 'เสร็จ';

  @override
  String get calculate => 'คำนวณ';

  @override
  String get reset_food_prefs => 'ล้างค่าการกำหนดลักษณะ';

  @override
  String get error => 'บางอย่างผิดพลาด';

  @override
  String get error_occurred => 'เกิดความผิดพลาด';

  @override
  String get featureInProgress => 'เรากำลังพัฒนากับฟีเจอร์นี้เจอกันเร็วๆนี้';

  @override
  String get label_web => 'เปิดดูบนเว็บไซต์';

  @override
  String get learnMore => 'ดูเพิ่มเติม';

  @override
  String get unknown => 'ไม่ทราบ';

  @override
  String get match_very_good => 'แมตช์ที่ยอดเยี่ยมมาก';

  @override
  String get match_good => 'แมตช์ที่ดี';

  @override
  String get match_poor => 'การจับคู่ที่ไม่ดี';

  @override
  String get match_may_not => 'May not match';

  @override
  String get match_does_not => 'ไม่ตรงกัน';

  @override
  String get match_unknown => 'ไม่พบการจับคู่';

  @override
  String get match_short_very_good => 'แมตช์ที่ยอดเยี่ยมมาก';

  @override
  String get match_short_good => 'แมตช์ที่ดี';

  @override
  String get match_short_poor => 'การจับคู่ที่ไม่ดี';

  @override
  String get match_short_may_not => 'May not match';

  @override
  String get match_short_does_not => 'ไม่ตรงกัน';

  @override
  String get match_short_unknown => 'ไม่พบการจับคู่';

  @override
  String get licenses => 'ใบอนุญาต';

  @override
  String get looking_for => 'กำลังหา';

  @override
  String get welcomeToOpenFoodFacts => 'ยินดีต้อนรับสู่ โอเพ้น ฟู๊ด แฟค';

  @override
  String get whatIsOff =>
      'Open Food Facts เป็นองค์กรไม่แสวงผลกำไรระดับโลกที่ขับเคลื่อนโดยชุมชนท้องถิ่น';

  @override
  String get productDataUtility => 'ดูข้อมูลอาหาร ที่คุณสนใจ(ความต้องการ)';

  @override
  String get healthCardUtility => 'เลือกอาหารที่ดีที่สุดสำหรับคุณ';

  @override
  String get ecoCardUtility => 'เลือกอาหารที่ดีมีประโยชน์ที่ดีกับโลกใบนี้';

  @override
  String get server_error_open_new_issue =>
      'ไม่มีการตอบสนองจากเซิร์ฟเวอร์! คุณสามารถแจ้งปัญหาได้ที่ลิงก์ต่อไปนี้';

  @override
  String get sign_in_text =>
      'ลงชื่อเข้าใช้บัญชี Open Food Facts ของคุณเพื่อบันทึกข้อมูลที่คุณบริจาค';

  @override
  String get incorrect_credentials => 'ชื่อและพาสเวิร์ดไม่ถูกต้อง';

  @override
  String get password_lost_incorrect_credentials =>
      'อีเมลหรือชื่อผู้ใช้นี้ไม่มีอยู่จริง โปรดตรวจสอบข้อมูลการเข้าสู่ระบบของคุณ';

  @override
  String get password_lost_server_unavailable =>
      'ขณะนี้เซิร์ฟเวอร์ของเรากำลังประสบปัญหาความเร็วลดลง เราขออภัยในความไม่สะดวก โปรดลองใหม่อีกครั้งในภายหลัง';

  @override
  String get login => 'ชื่อผู้ใช้';

  @override
  String get login_result_type_server_unreachable =>
      'ไม่สามารถเชื่อมต่อเครือข่ายได้';

  @override
  String get login_result_type_server_issue =>
      'เกิดปัญหาบนเซิร์ฟเวอร์ โปรดลองใหม่อีกครั้ง';

  @override
  String get login_page_username_or_email =>
      'กรุณากรอกชื่อแอคเค้าท์ หรือ อีเมล์';

  @override
  String get login_page_password_error_empty => 'ใส่รหัสผ่าน';

  @override
  String get create_account => 'สร้าง แอคเค้าท์';

  @override
  String get sign_in => 'เข้าสู่ระบบ';

  @override
  String get sign_in_mandatory => 'คุณต้องลงชื่อเข้าใช้ เพื่อใช้ฟีเจอร์นี้';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'ล๊อคเอ้าท์';

  @override
  String get sign_out_confirmation => 'คุณแน่ใจว่าจะล๊อคเอ้าท์?';

  @override
  String get password => 'รหัสผ่าน';

  @override
  String get forgot_password => 'ชืมรหัสผ่าน';

  @override
  String get forgot_password_question => 'ลืมรหัสผ่าน?';

  @override
  String get view_profile => 'ดูโปรไฟล์';

  @override
  String get reset_password => 'รีเซ็ตรหัสผ่าน';

  @override
  String get reset_password_explanation_text =>
      'ถ้าหากชืมรหัสผ่านให้กรอก ชื่อแอคเค้าท์ หรือ อีเมล์ เพื่อรับ ข้อมูล ขั้นตอนการตั้งค่ารหัสใหม่ กรุณาเปิดกล่องจดหมายขยะด้วย';

  @override
  String get username_or_email => 'ชื่อผู้ใช้ หรือ อีเมล์';

  @override
  String get reset_password_done =>
      'อีเมล์ที่มีลิงค์สำหรับ ตั้งค่ารหัสผ่านใหม่ได้ถูกส่งไปยังอีเมล์ที่ท่านใช้สมัครแอคเค้าท์เรียบร้อยแล้ว กรุณาเช็คกล่องจดหมายที่ไม่ต้องการด้วย';

  @override
  String get send_reset_password_mail => 'เปลี่ยนรหัส';

  @override
  String get enter_some_text => 'กรุณาเขียนข้อความ';

  @override
  String get sign_up_page_title => 'สมัคร';

  @override
  String get sign_up_page_action_button => 'สมัคร';

  @override
  String get sign_up_page_action_doing_it => 'กำลังลงทะเบียน…';

  @override
  String get sign_up_page_action_ok =>
      'ยินดีด้วยแอคเค้าท์ของคุณสร้างเสร็จเรียบร้อย';

  @override
  String get sign_up_page_display_name_hint => 'ชื่อ';

  @override
  String get sign_up_page_display_name_error_empty =>
      'กรุณาตั้งชื่อเล่น ที่คุณต้องการ';

  @override
  String get sign_up_page_email_hint => 'อีเม';

  @override
  String get sign_up_page_email_error_empty => 'ต้องระบุอีเมล์';

  @override
  String get sign_up_page_email_error_invalid => 'อีเมลไม่ถูกต้อง';

  @override
  String get sign_up_page_username_hint => 'ชื่อผู้ใช้: เปิดเผยต่อสาธารณะ';

  @override
  String get sign_up_page_username_error_empty => 'กรุณา ใส่ชื่อแอคเค้าท์';

  @override
  String get sign_up_page_username_error_invalid => 'ชื่อไม่ถูกต้อง';

  @override
  String get sign_up_page_username_description =>
      'ชื่อผู้ใช้ต้องไม่มีช่องว่าง ตัวพิมพ์ใหญ่ หรือตัวอักษรพิเศษ';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'ชื่อผู้ใช้ต้องไม่เกิน $value ตัวอักษร';
  }

  @override
  String get sign_up_page_password_hint => 'รหัสผ่าน';

  @override
  String get sign_up_page_password_error_empty => 'ใส่รหัสผ่าน';

  @override
  String get sign_up_page_password_error_invalid =>
      'รหัสผ่านของคุณไม่ถูกต้อง(ต้องมีความยาวอย่างน้อย6ตัว)';

  @override
  String get sign_up_page_confirm_password_hint => 'ยืนยันรหัส';

  @override
  String get sign_up_page_confirm_password_error_empty => 'กรุณยืนยันรหัสผ่าน';

  @override
  String get sign_up_page_confirm_password_error_invalid => 'รหัสผ่านไม่ตรงกัน';

  @override
  String get sign_up_page_agree_text =>
      'ฉันเห็นด้วยกับข้อมูลอาหารเปิดเผย (Open Food Facts)';

  @override
  String get sign_up_page_terms_text => 'ข้อมูลและเงื่อนไขการใช้งาน';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'เมื่อสร้างบัญชี จะถือว่าเป็นการยอมรับข้อกำหนดการใช้งานโดยปริยาย แต่คุณสามารถใช้งานแบบไม่ระบุตัวตนได้ผ่านแอป';

  @override
  String get sign_up_page_producer_checkbox => 'ฉันเป็นผู้ผลิตอาหาร';

  @override
  String get sign_up_page_producer_hint => 'ผู้ผลิต/ยี่ห้อ';

  @override
  String get sign_up_page_producer_error_empty => 'โปรดป้อนผู้ผลิตหรือยี่ห้อ';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'ฉันต้องการสมัครรับจดหมายข่าว Open Food Facts (คุณสามารถยกเลิกการสมัครได้ทุกเมื่อ)';

  @override
  String get sign_up_page_user_name_already_used =>
      'ชื่อผู้ใช้นี้มีอยู่แล้ว โปรดเลือกชื่อผู้ใช้อื่น';

  @override
  String get sign_up_page_email_already_exists =>
      'มีอยู่แล้ว โปรดเข้าสู่ระบบหรือลองด้วยอีเมลอื่น';

  @override
  String get sign_up_page_provide_valid_email =>
      'โปรดใส่ที่อยู่อีเมลที่ถูกต้อง';

  @override
  String get sign_up_page_server_busy =>
      'ขออภัยเป็นอย่างยิ่ง เราประสบปัญหาทางเทคนิคในการสร้างบัญชีของคุณ โปรดลองใหม่อีกครั้งในภายหลัง';

  @override
  String get settingsTitle => 'ตั้งค่า';

  @override
  String get darkmode => 'ธีม';

  @override
  String get darkmode_dark => 'มืด';

  @override
  String get darkmode_light => 'สว่าง';

  @override
  String get darkmode_system_default => 'ใช้ค่าจากระบบ';

  @override
  String get thanks_for_contributing => 'ขอบคุณสำหรับการมีส่วนร่วม!';

  @override
  String get contributors_label => 'พวกเขากำลังพัฒนาแอปอยู่';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'ผู้ร่วมเขียน: $name';
  }

  @override
  String get contributors_description =>
      'รายชื่อผู้มีส่วนร่วมทั้งหมดในแอปพลิเคชันนี้';

  @override
  String get support => 'สนับสนุน';

  @override
  String get support_join_slack => 'ขอความช่วยเหลือผ่าน Slack ของเรา';

  @override
  String get support_via_forum => 'ขอความช่วยเหลือในฟอรัมของเรา';

  @override
  String get support_via_email => 'ส่งอีเมลถึง Open Food Facts';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'ส่งข้อมูลการใช้แอป';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'คุณต้องการแนบบันทึกการใช้งานไปกับอีเมลหรือไม่?';

  @override
  String get termsOfUse => 'ข้อกำหนดการใช้งาน';

  @override
  String get legalNotices => 'ประกาศทางกฎหมาย';

  @override
  String get privacy_policy => 'นโยบายความเป็นส่วนตัว';

  @override
  String get about_this_app => 'เกี่ยวกับแอพนี้';

  @override
  String get contribute => 'ร่วมสนับสนุน';

  @override
  String get contribute_sw_development => 'การพัฒนาซอฟต์แวร์';

  @override
  String get contribute_develop_text =>
      'โค้ดสำหรับผลิตภัณฑ์ Open Food Facts ทุกชิ้นมีให้ใช้งานบน GitHub คุณสามารถนำโค้ดไปใช้ซ้ำได้ (เพราะเป็นโอเพนซอร์ส) และช่วยเราปรับปรุงให้ดียิ่งขึ้นสำหรับทุกคนบนโลกใบนี้';

  @override
  String get contribute_develop_text_2 =>
      'คุณสามารถเข้าร่วมห้องแชท Slack ของ Open Food Facts ซึ่งเป็นช่องทางที่แนะนำสำหรับการถามคำถาม';

  @override
  String get contribute_develop_dev_mode_title => 'โหมด DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'เปิดใช้งานโหมด DEV';

  @override
  String get contribute_donate_title => 'บริจาค';

  @override
  String get contribute_donate_header => 'บริจาคให้กับ Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'โปรดทราบว่าในเวอร์ชันอัลฟ่าภายในนี้ ข้อมูลทั้งหมดอาจสูญหายได้ และแอปอาจใช้งานไม่ได้เลยในทุกเวลา!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'ผลิตภัณฑ์ที่จะผลิตให้เสร็จสมบูรณ์';

  @override
  String get contribute_improve_header => 'ปรับปรุง';

  @override
  String get contribute_improve_text =>
      'ฐานข้อมูลเป็นหัวใจหลักของโครงการ การช่วยเหลือทำได้ง่ายและรวดเร็วมาก คุณสามารถดาวน์โหลดแอปพลิเคชันมือถือลงในโทรศัพท์ของคุณ และเริ่มเพิ่มหรือปรับปรุงผลิตภัณฑ์ได้เลย\n\nในทางกลับกัน เว็บไซต์ Open Food Facts ก็มีช่องทางมากมายให้คุณร่วมให้ข้อมูล: ';

  @override
  String get contribute_translate_header => 'แปลภาษา';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'เริ่มแปล';

  @override
  String get contribute_translate_text =>
      'Open Food Facts เป็นโครงการระดับโลกที่รวบรวมผลิตภัณฑ์จากกว่า 160 ประเทศ Open Food Facts ได้รับการแปลเป็นภาษาต่างๆ มากมาย และมีการพัฒนาเนื้อหาอย่างต่อเนื่อง';

  @override
  String get contribute_translate_text_2 =>
      'การแปลเป็นหนึ่งในงานหลักของโครงการ';

  @override
  String get contribute_join_skill_pool =>
      'ร่วมแบ่งปันทักษะของคุณกับ Open Food Facts เข้าร่วมกลุ่มผู้เชี่ยวชาญได้เลย!';

  @override
  String get contribute_share_header =>
      'แบ่งปันข้อมูล Open Food Facts กับเพื่อนๆ ของคุณ';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'ร่วมให้ข้อมูลราคาโดยการขอส่งออกข้อมูลบัตรสะสมแต้มของคุณตามกฎ GDPR';

  @override
  String get tap_to_answer => 'แตะที่นี่เพื่อตอบคำถาม';

  @override
  String get tap_to_answer_hint => 'แตะที่นี่เพื่อตอบคำถามเกี่ยวกับผลิตภัณฑ์';

  @override
  String get robotoff_questions_loading_hint =>
      'โปรดรอสักครู่ในขณะที่กำลังโหลดคำถามเกี่ยวกับผลิตภัณฑ์นี้';

  @override
  String get saving_answer => 'กำลังบันทึกคำตอบของคุณ';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'ลงชื่อเข้าใช้บัญชี Open Food Facts ของคุณเพื่อรับเครดิตสำหรับการบริจาคของคุณ';

  @override
  String get question_yes_button_accessibility_value => 'ตอบด้วยใช่';

  @override
  String get question_no_button_accessibility_value => 'ตอบด้วยไม่';

  @override
  String get question_skip_button_accessibility_value => 'ข้ามคำถามนี้';

  @override
  String get tap_to_edit_search => 'แตะเพื่อแก้ไขการค้นหา';

  @override
  String get myPreferences => 'การตั้งค่าของฉัน';

  @override
  String get account_create_message =>
      'สร้างบัญชีของคุณและเข้าร่วมชุมชน Open Food Facts เพื่อช่วยกันสร้างองค์ความรู้ด้านอาหารทั่วโลก!';

  @override
  String get join_us => 'เข้าร่วมกับเรา';

  @override
  String get myPreferences_profile_title => 'โปรไฟล์ของคุณ';

  @override
  String get myPreferences_profile_subtitle =>
      'จัดการบัญชีผู้ร่วมเขียนบทความ Open Food Facts ของคุณ';

  @override
  String get myPreferences_settings_title => 'การตั้งค่าแอพ';

  @override
  String get myPreferences_settings_subtitle => 'โหมดมืด, ภาษา…';

  @override
  String get myPreferences_food_title => 'ความชอบด้านอาหาร';

  @override
  String get myPreferences_food_subtitle =>
      'เลือกข้อมูลเกี่ยวกับอาหารที่สำคัญที่สุดสำหรับคุณ';

  @override
  String get myPreferences_food_comment =>
      'เลือกข้อมูลเกี่ยวกับอาหารที่คุณสนใจมากที่สุด เพื่อจัดอันดับอาหารตามความชอบของคุณ ดูข้อมูลที่คุณสนใจก่อน และรับสรุปความเข้ากันได้ การตั้งค่าอาหารเหล่านั้นจะยังคงอยู่ในอุปกรณ์ของคุณ และจะไม่เชื่อมโยงกับบัญชีผู้ร่วมให้ข้อมูล Open Food Facts ของคุณ หากคุณมีบัญชีดังกล่าว';

  @override
  String get confirmResetPreferences => 'รีเซ็ตการตั้งค่าอาหารของคุณ?';

  @override
  String get myPersonalizedRanking => 'การจัดอันดับส่วนบุคคลของฉัน';

  @override
  String get ranking_tab_all => 'ทั้งหมด';

  @override
  String get ranking_subtitle_match_yes => 'จับคู่ที่ดีสำหรับคุณ';

  @override
  String get ranking_subtitle_match_no => 'แย่มาก';

  @override
  String get ranking_subtitle_match_maybe => 'ไม่พบการจับคู่';

  @override
  String get refresh_with_new_preferences =>
      'อัปเดตรายการด้วยการตั้งค่าใหม่ของคุณ';

  @override
  String get reloaded_with_new_preferences =>
      'โหลดข้อมูลใหม่ตามการตั้งค่าใหม่ของคุณเรียบร้อยแล้ว';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'สแกน';

  @override
  String get history_navbar_label => 'ประวัติการเข้าใช้';

  @override
  String get list_navbar_label => 'รายการ';

  @override
  String get category => 'กรองตามหมวดหมู่';

  @override
  String get category_all => 'ทั้งหมด';

  @override
  String get category_search => '(ค้นหาหมวดหมู่)';

  @override
  String get filter => 'กรอง';

  @override
  String get scan => 'ผลิตภัณฑ์จากหน้าจอการสแกน';

  @override
  String get scan_history => 'ประวัติการสแกน';

  @override
  String get search => 'ค้นหา';

  @override
  String get search_product_help => 'ค้นหาผลิตภัณฑ์\nยี่ห้อหรือบาร์โค้ด';

  @override
  String get search_filter => 'ตัวกรองการค้นหา';

  @override
  String get search_history => 'ประวัติการค้นหา';

  @override
  String get search_store => 'ค้นหาร้านค้า';

  @override
  String get search_store_help => 'คำใบ้: เพิ่มเมืองหรือประเทศ';

  @override
  String get tap_for_more => 'แตะเพื่อดูข้อมูลเพิ่มเติม…';

  @override
  String get product => 'สินค้า';

  @override
  String get unknownBrand => 'ไม่ทราบยี่ห้อ';

  @override
  String get unknownQuantity => 'ปริมาณที่ไม่ทราบแน่ชัด';

  @override
  String get unknownProductName => 'ผลิตภัณฑ์ที่ไม่รู้จัก';

  @override
  String get label_refresh => 'โหลดใหม่';

  @override
  String get label_reload => 'โหลดซ้ำ';

  @override
  String get image => 'รูปภาพ';

  @override
  String get front_photo => 'รูปหน้าตรง';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (ภาพนี้อาจล้าสมัยแล้ว)';
  }

  @override
  String get outdated_image_short_label => 'ข้อมูลอาจล้าสมัย';

  @override
  String get ingredients => 'ส่วนผสม';

  @override
  String get ingredients_editing_instructions =>
      'คงลำดับเดิมไว้ ระบุเปอร์เซ็นต์เมื่อมีการกำหนด แยกด้วยเครื่องหมายจุลภาคหรือเครื่องหมายยัติภังค์ และใช้วงเล็บสำหรับส่วนผสมของส่วนผสมแต่ละชนิด';

  @override
  String get ingredients_editing_error => 'ไม่สามาบันทึกส่วนผสมได้';

  @override
  String get ingredients_editing_image_error =>
      'ไม่สามารถใส่รูปภาพของส่วนผสมได้';

  @override
  String get ingredients_editing_title => 'แก้ไขส่วนผสม';

  @override
  String get ingredients_photo => 'รูปภาพของส่วนประกอบของอาหาร';

  @override
  String get packaging_editing_instructions =>
      'ระบุส่วนประกอบบรรจุภัณฑ์ทั้งหมด โดยคั่นด้วยเครื่องหมายจุลภาคหรือขึ้นบรรทัดใหม่ พร้อมระบุจำนวน (เช่น 1 หรือ 6) ประเภท (เช่น ขวด กล่อง กระป๋อง) วัสดุ (เช่น พลาสติก โลหะ อลูมิเนียม) และหากมีข้อมูล ขนาด (เช่น 33cl) และคำแนะนำในการรีไซเคิล\nตัวอย่าง: ขวดแก้ว 1 ขวดสำหรับรีไซเคิล จุกพลาสติก 1 อันสำหรับทิ้ง';

  @override
  String get packaging_editing_error => 'ไม่สามารถเก็บรักษาบรรจุภัณฑ์ไว้ได้';

  @override
  String get packaging_editing_image_error => 'ไม่สามารถหาภาพบรรจุภัณฑ์ใหม่ได้';

  @override
  String get packaging_editing_title => 'แก้ไขบรรจุภัณฑ์';

  @override
  String get nutrition => 'อาหารการกิน';

  @override
  String get nutrition_facts_photo => 'ข้อมูลโภชนาการ';

  @override
  String get nutrition_facts_editing_title => 'แก้ไขข้อมูลโภชนาการ';

  @override
  String get packaging_information => 'คำแนะนำในการรีไซเคิล';

  @override
  String get packaging_information_photo => 'ภาพประกอบคำแนะนำการรีไซเคิล';

  @override
  String get missing_product => 'คุณพบสินค้าใหม่';

  @override
  String get add_product_take_photos =>
      'ถ่ายรูปบรรจุภัณฑ์เพื่อเพิ่มข้อมูลผลิตภัณฑ์นี้ลงใน Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'กรุณาถ่ายรูปไว้ก่อน คุณสามารถทำผลิตภัณฑ์ให้เสร็จสมบูรณ์ในภายหลังได้เสมอ';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'สินค้าใหม่';

  @override
  String get new_product_found_title => 'พบสินค้าใหม่แล้ว!';

  @override
  String get new_product_found_text =>
      'ฐานข้อมูลร่วมของเรามีสินค้ามากกว่า **3 ล้านรายการ** แต่บาร์โค้ดนี้ไม่มีอยู่จริง: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'ออกจากหน้านี้?';

  @override
  String get new_product_leave_message =>
      'ดูเหมือนว่าคุณไม่ได้ป้อนอะไรเลย คุณต้องการออกจากหน้านี้จริง ๆ หรือไม่?';

  @override
  String get new_product_dialog_description =>
      'โปรดถ่ายรูปบรรจุภัณฑ์เพื่อเพิ่มข้อมูลผลิตภัณฑ์นี้ลงในฐานข้อมูลของเรา';

  @override
  String get new_product_dialog_illustration_description =>
      'ภาพประกอบที่มีค่า Nutri-Score และ Green Score ที่ไม่ทราบค่า';

  @override
  String get front_packaging_photo_button_label => 'ภาพด้านหน้าบรรจุภัณฑ์';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'ยืนยันการอัปโหลดรูปภาพด้านหน้าบรรจุภัณฑ์';

  @override
  String get confirm_button_label => 'ยืนยัน';

  @override
  String get send_image_button_label => 'ส่งภาพ';

  @override
  String get crop_page_action_saving => 'กำลังบันทึกภาพ…';

  @override
  String get crop_page_action_cropping => 'การตัดภาพ…';

  @override
  String get crop_page_action_local => 'กำลังบันทึกเวอร์ชันในเครื่อง…';

  @override
  String get crop_page_action_local_failed_title =>
      'อุ๊ปส์… มีบางอย่างผิดปกติกับรูปถ่ายของคุณ!';

  @override
  String get crop_page_action_local_failed_message =>
      'เราไม่สามารถประมวลผลภาพในเครื่องก่อนส่งไปยังเซิร์ฟเวอร์ของเราได้ โปรดลองใหม่อีกครั้งในภายหลัง หรือติดต่อเราหากปัญหายังคงอยู่';

  @override
  String get crop_page_action_retake => 'ถ่ายรูปใหม่';

  @override
  String get crop_page_too_small_image_title => 'รูปภาพเล็กเกินไป!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'ขนาดขั้นต่ำของภาพที่สามารถอัปโหลดได้คือ ${expectedMinWidth}x$expectedMinHeightภาพปัจจุบันมีขนาด ${actualWidth}x$actualHeight';
  }

  @override
  String get crop_page_action_server => 'กำลังเตรียมการโทรไปยังเซิร์ฟเวอร์…';

  @override
  String get front_packaging_photo_title => 'รูปถ่ายด้านหน้าของบรรจุภัณฑ์';

  @override
  String get ingredients_photo_title => 'รูปภาพส่วนประกอบของอาหาร';

  @override
  String get nutritional_facts_photo_title => 'ข้อมูลโภชนาการ (รูปภาพ)';

  @override
  String get recycling_photo_title => 'คำแนะนำในการรีไซเคิล (รูปภาพ)';

  @override
  String get take_photo_title => 'ถ่ายภาพ';

  @override
  String get take_more_photo_title => 'ถ่ายรูปเพิ่มเติม';

  @override
  String get front_photo_uploaded => 'รูปภาพด้านหน้าอัพโหลดเรียบร้อย';

  @override
  String get ingredients_photo_button_label => 'รูปภาพของส่วนประกอบของอาหาร';

  @override
  String get ingredients_photo_uploaded =>
      'รูปภส่วนประกอบของอาหารถูกอัพโหลดแล้ว';

  @override
  String get nutrition_cache_loading_error => 'ไม่สามารถโหลดสารอาหารจากแคชได้';

  @override
  String get nutritional_facts_photo_button_label => 'ข้อมูลโภชนาการ';

  @override
  String get nutritional_facts_input_button_label => 'กรอกข้อมูลโภชนาการ';

  @override
  String get nutritional_facts_added => 'เพิ่มข้อมูลโภชนาการ';

  @override
  String get categories_added => 'เพิ่มหมวดหมู่แล้ว';

  @override
  String get new_product_title_nutriscore => 'Compute the Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'โปรดช่วยเราด้วยการกรอกข้อมูลอย่างน้อยหนึ่งหมวดหมู่และข้อมูลโภชนาการ';

  @override
  String get new_product_title_environmental_score => 'คำนวณคะแนนสีเขียว';

  @override
  String get new_product_subtitle_environmental_score =>
      'รับสิทธิ์โดยการกรอกข้อมูลอย่างน้อยหนึ่งหมวดหมู่';

  @override
  String get new_product_additional_environmental_score =>
      'ทำให้การคำนวณคะแนน Green Score แม่นยำยิ่งขึ้นด้วยการระบุแหล่งที่มา บรรจุภัณฑ์ และอื่นๆ';

  @override
  String get new_product_title_nova => 'คำนวณระดับการแปรรูปอาหาร (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'รับข้อมูลได้โดยกรอกหมวดหมู่และส่วนผสมของอาหาร';

  @override
  String get new_product_desc_nova_unknown => 'ไม่ทราบระดับการแปรรูปอาหาร';

  @override
  String get new_product_title_pictures => 'ผลิตภัณฑ์ใหม่';

  @override
  String get new_product_title_pictures_details =>
      'โปรดนำรูปภาพต่อไปนี้ไปใช้ แล้วระบบ Open Food Facts จะคำนวณส่วนที่เหลือให้เอง!';

  @override
  String get new_product_title_misc => 'และข้อมูลพื้นฐานบางส่วน…';

  @override
  String new_product_done_msg(String username) {
    return 'ขอบคุณสำหรับการมีส่วนร่วมของคุณ “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'ขอบคุณสำหรับการสนับสนุนของคุณ!';

  @override
  String get new_product_done_button_label =>
      'ค้นพบผลิตภัณฑ์ที่เสร็จสมบูรณ์แล้ว';

  @override
  String get hey_incomplete_product_message =>
      'แตะเพื่อตอบ 3 คำถามตอนนี้ เพื่อคำนวณคะแนนโภชนาการ คะแนนความเขียว และคะแนนการประมวลผลขั้นสูง (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'แตะเลยเพื่อตอบคำถาม 2 ข้อที่จะช่วยวิเคราะห์เครื่องสำอางชิ้นนี้!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'แตะเลยเพื่อตอบคำถาม 3 ข้อที่จะช่วยวิเคราะห์ผลิตภัณฑ์อาหารสัตว์เลี้ยงนี้!';

  @override
  String get hey_incomplete_product_message_product =>
      'แตะเลยเพื่อช่วยให้ผลิตภัณฑ์นี้เสร็จสมบูรณ์!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'รูปภาพโภชนาการอาหารอัพโหลดแล้ว';

  @override
  String get recycling_photo_button_label => 'ข้อมูลการรีไซเคิล';

  @override
  String get recycling_photo_uploaded => 'รูปภาพรีไซเคิลอัพโหลดแล้ว';

  @override
  String get take_more_photo_button_label => 'ถ่ายรูปเพิ่มเติม';

  @override
  String get other_photo_uploaded => 'รูปภาพข้อมูลทั่วไป';

  @override
  String get retake_photo_button_label => 'ถ่ายซ้ำ';

  @override
  String get selecting_photo => 'กำลังเลือกรูป';

  @override
  String get uploading_image => 'อัพโหลดรูแขึ้นระบบ';

  @override
  String get uploading_image_type_front =>
      'กำลังอัปโหลดภาพด้านหน้าไปยัง Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'อัปโหลดภาพส่วนผสมไปยัง Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'อัปโหลดภาพข้อมูลโภชนาการไปยัง Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'อัปโหลดภาพบรรจุภัณฑ์ไปยัง Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'กำลังอัปโหลดรูปภาพอื่นไปยัง Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'กำลังอัปโหลดรูปภาพไปยัง Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'เติมส่วนผสมที่ขาดหายไป';

  @override
  String get score_add_missing_packaging_image => 'เพิ่มภาพบรรจุภัณฑ์ที่หายไป';

  @override
  String get score_add_missing_nutrition_facts =>
      'เพิ่มข้อมูลโภชนาการที่ขาดหายไป';

  @override
  String get score_add_missing_product_traces =>
      'เพิ่มข้อมูลผลิตภัณฑ์ที่ไม่ครบถ้วน';

  @override
  String get score_add_missing_product_category => 'เลือกหมวดหมู่';

  @override
  String get score_add_missing_precise_product_category =>
      'เลือกหมวดหมู่ที่แม่นยำยิ่งขึ้น';

  @override
  String get score_add_missing_product_countries =>
      'เพิ่มประเทศสินค้าที่ขาดหายไป';

  @override
  String get score_add_missing_product_emb =>
      'เพิ่มรหัสตรวจสอบย้อนกลับผลิตภัณฑ์ที่ขาดหายไป';

  @override
  String get score_add_missing_product_labels => 'เพิ่มฉลากผลิตภัณฑ์';

  @override
  String get score_add_missing_product_origins => 'เพิ่มแหล่งที่มาของผลิตภัณฑ์';

  @override
  String get score_add_missing_product_stores => 'เพิ่มร้านค้าสินค้า';

  @override
  String get score_add_missing_product_brands => 'เพิ่มแบรนด์สินค้าที่ขาดหายไป';

  @override
  String get score_update_nutrition_facts => 'อัพเดทข้อมูลโภชนาการ';

  @override
  String get nutrition_page_title => 'ข้อมูลโภชนาการ';

  @override
  String get nutrition_page_nutritional_info_title => 'ข้อมูลโภชนาการ';

  @override
  String get nutrition_page_nutritional_info_label =>
      'ค่าต่างๆ ที่ระบุไว้บนผลิตภัณฑ์:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'ถูกต้อง';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'ไม่ใช่';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'เปิดรูปภาพ';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'แนวปฏิบัติที่ดี: ข้อมูลโภชนาการ';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'บางครั้ง ข้อมูลโภชนาการ **ไม่ได้ระบุไว้บนบรรจุภัณฑ์** หรือในเอกสารที่แนบมากับผลิตภัณฑ์ ในกรณีนี้เท่านั้น คุณสามารถตั้งค่าเป็น **ไม่** ได้';

  @override
  String get nutrition_page_serving_type_label => 'คุณค่าทางโภชนาการ:';

  @override
  String get nutrition_page_per_100g => 'ต่อ 100 กรัม';

  @override
  String get nutrition_page_per_100g_100ml => 'ต่อ 100 กรัม/มล.';

  @override
  String get nutrition_page_per_serving => 'ต่อการให้บริการ';

  @override
  String get nutrition_page_add_nutrient => 'เพิ่มสารอาหารอื่นๆ';

  @override
  String get nutrition_page_serving_size => 'หน่วยบริโภค';

  @override
  String get nutrition_page_serving_size_hint =>
      'ระบุขนาดของปริมาณที่รับประทาน (เช่น 100 กรัม)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'แนวปฏิบัติที่ดี: ขนาดของอาหารที่เสิร์ฟ';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'ค่านี้ช่วยในการคำนวณสัดส่วนของสารอาหารแต่ละชนิดต่อหนึ่งหน่วยบริโภคได้อย่างแม่นยำ';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**หน่วยที่อนุญาต** ได้แก่: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 กรัม**, **60 กรัม** หรือ **60 กรัม** (ควรเลือกแบบแรก)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 มล.** หรือ **1 ลิตร**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'หน่วยไม่ถูกต้อง';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **กรัม**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'หน่วยที่ไม่ถูกต้อง';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      'ลูกอม 9 เม็ด และบิสกิต 2 ชิ้น';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'หน่วยที่หายไป';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'หมายเลขไม่ถูกต้อง';

  @override
  String get nutrition_page_update_running =>
      'กำลังอัพเดทผลิตภัณฑ์บนเซิร์ฟเวอร์…';

  @override
  String get nutrition_page_update_done => 'อัพเดทผลิตภัณฑ์สำเร็จ!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'ใช้ปริมาณผลิตภัณฑ์เป็นขนาดการเสิร์ฟ';

  @override
  String get nutrition_page_photo_error => 'ไม่สามารถโหลดรูปภาพได้';

  @override
  String get more_photos => 'รูปภาพอื่นๆที่น่าสนใจ';

  @override
  String get view_more_photo_button => 'ดูรูปภาพทั้งหมดที่มีสำหรับผลิตภัณฑ์นี้';

  @override
  String get no_product_found => 'ไม่พบผลิตภัณฑ์';

  @override
  String get no_location_found => 'ไม่พบตำแหน่งที่ตั้ง';

  @override
  String get not_found => 'ไม่พบ';

  @override
  String get refreshing_product => 'กำลังโหลดผลิตภัณฑ์ใหม่';

  @override
  String get product_refreshed => 'โหลดผลิตภัณฑ์ใหม่สำเร็จ';

  @override
  String product_image_accessibility_label(String date) {
    return 'ภาพถ่ายเมื่อ $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'ภาพถ่ายเมื่อ $dateภาพนี้อาจเป็นภาพที่ล้าสมัยแล้ว';
  }

  @override
  String get product_image_outdated => 'รูปภาพนี้อาจไม่ทันสมัยแล้ว';

  @override
  String get product_image_outdated_explanations_title =>
      'รูปภาพนี้อาจไม่ทันสมัยแล้ว';

  @override
  String get product_image_outdated_explanations_content =>
      'ภาพนี้ถ่ายไว้เมื่อกว่าหนึ่งปีที่แล้ว\n**โปรดตรวจสอบว่ายังเป็นข้อมูลล่าสุดอยู่หรือไม่**\n\nนี่เป็น **เพียงคำเตือน** หากเนื้อหายังคงเหมือนเดิม คุณสามารถละเว้นข้อความนี้ได้';

  @override
  String product_image_action_replace_photo(String type) {
    return 'เปลี่ยนรูปภาพ ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'เพิ่มรูปภาพ ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'ถ่ายภาพ';

  @override
  String get product_image_action_from_gallery =>
      'เลือกจากแกลเลอรีในโทรศัพท์ของคุณ';

  @override
  String get product_image_action_choose_existing_photo =>
      'เลือกจากรูปภาพสินค้า';

  @override
  String get product_image_details_label => 'ข้อมูลเกี่ยวกับรูปภาพ';

  @override
  String get product_image_details_from_producer => 'จากผู้ผลิต';

  @override
  String get product_image_details_contributor => 'Contributor';

  @override
  String get product_image_details_contributor_producer =>
      'ผู้ร่วมงาน (โปรดิวเซอร์)';

  @override
  String get product_image_details_date => 'วันที่';

  @override
  String get product_image_details_date_unknown => 'ไม่ทราบ';

  @override
  String get homepage_main_card_logo_description =>
      'ยินดีต้อนรับสู่ Open Food Facts';

  @override
  String get homepage_main_card_subheading => 'สแกนบาร์โค้ดหรือค้นหาสินค้า\n';

  @override
  String get homepage_main_card_search_field_hint => 'ค้นหาสินค้า';

  @override
  String get homepage_main_card_search_field_tooltip => 'เริ่มการค้นหา';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'ข่าวล่าสุด: $news_title';
  }

  @override
  String get tagline_app_review => 'คุณชอบแอปนี้ไหม?';

  @override
  String get tagline_app_review_button_positive => 'ฉันชอบมาก! 😍';

  @override
  String get tagline_app_review_button_negative => 'ไม่จริงเลย…';

  @override
  String get tagline_app_review_button_later => 'ถามฉันทีหลังนะ';

  @override
  String get tagline_feed_news_button => 'เรียนรู้เพิ่มเติม';

  @override
  String get app_review_negative_modal_title => 'คุณไม่ชอบแอปของเราเหรอ?';

  @override
  String get app_review_negative_modal_text =>
      'คุณช่วยสละเวลาสักสองสามวินาทีเพื่อบอกเหตุผลให้เราฟังได้ไหม?';

  @override
  String get app_review_negative_modal_positive_button => 'ใช่เลย!';

  @override
  String get app_review_negative_modal_negative_button => 'ไม่ใช่';

  @override
  String get could_not_refresh => 'ไม่สามารถโหลดใหม่';

  @override
  String get product_internet_error_modal_title => 'เกิดข้อผิดพลาดขึ้น!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'เราไม่สามารถดึงข้อมูลเกี่ยวกับผลิตภัณฑ์นี้ได้เนื่องจากเกิดข้อผิดพลาดเครือข่าย โปรดตรวจสอบการเชื่อมต่ออินเทอร์เน็ตของคุณแล้วลองใหม่อีกครั้ง\n\nข้อผิดพลาดภายใน:\n$error';
  }

  @override
  String get product_tags_title => 'คุณสมบัติของผลิตภัณฑ์';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'ไม่มีทรัพย์สิน';

  @override
  String get product_tags_explanation =>
      'การเพิ่มคุณสมบัติ (คีย์/ค่า) ให้กับผลิตภัณฑ์จะช่วยเสริมความสมบูรณ์ให้กับผลิตภัณฑ์';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'เพิ่มคุณสมบัติ';

  @override
  String get add_edit_tags => 'เพิ่มหรือแก้ไขคุณสมบัติ';

  @override
  String get edit_tag => 'แก้ไขคุณสมบัติ';

  @override
  String get remove_tag => 'ลบทรัพย์สิน';

  @override
  String get tag_key => 'คุณสมบัติ';

  @override
  String get tag_keys => 'คุณสมบัติ';

  @override
  String get tag_key_uneditable => 'คุณสมบัติ (แก้ไขไม่ได้)';

  @override
  String get tag_key_input_hint => 'ป้อนคุณสมบัติ';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'ป้อนค่า';

  @override
  String get tag_key_item => 'คุณสมบัติ:';

  @override
  String get tag_value_item => 'ค่า:';

  @override
  String get tag_key_explanations =>
      'ชื่อคีย์ต้องเป็นตัวพิมพ์เล็กและไม่มีช่องว่าง';

  @override
  String tag_key_already_exists(String property) {
    return 'แท็กที่มีคุณสมบัติ $property นั้นมีอยู่แล้ว!';
  }

  @override
  String get product_internet_error =>
      'ไม่สามารถดึงข้อมูลเกี่ยวกับผลิตภัณฑ์นี้ได้เนื่องจากข้อผิดพลาดของเครือข่าย';

  @override
  String get cached_results_from => 'แสดงผลลัพธ์จาก:';

  @override
  String get product_search_same_category => 'ค้นหาทางเลือกอื่น';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'ฟีเจอร์นี้ใช้ได้กับสินค้าที่มีหมวดหมู่เท่านั้น\n\nกรุณาแก้ไขรายละเอียดสินค้าเพื่อเพิ่มหมวดหมู่';

  @override
  String get product_improvement_add_category =>
      'เพิ่มหมวดหมู่เพื่อคำนวณ Nutri-Score';

  @override
  String get product_improvement_add_nutrition_facts =>
      'เพิ่มข้อมูลโภชนาการเพื่อคำนวณ Nutri-Score';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'เพิ่มข้อมูลโภชนาการและหมวดหมู่เพื่อคำนวณ Nutri-Score';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'ไม่สามารถคำนวณ Nutri-Score สำหรับผลิตภัณฑ์นี้ อาจเป็นเพราะหมวดหมู่ที่ไม่ได้มาตรฐาน หากสิ่งนี้ถือเป็นข้อผิดพลาด โปรดติดต่อเรา';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'ภาพข้อมูลโภชนาการล้าสมัยแล้ว โปรดอัปเดตภาพใหม่';

  @override
  String get product_improvement_origins_to_be_completed =>
      'คะแนนสีเขียวจะพิจารณาแหล่งที่มาของส่วนผสม โปรดถ่ายรูปรายการส่วนผสมและ/หรือข้อมูลอ้างอิงทางภูมิศาสตร์ หรือแก้ไขข้อมูลผลิตภัณฑ์เพื่อให้สามารถนำมาพิจารณาได้';

  @override
  String get country_chooser_label => 'โปรดเลือกประเทศ';

  @override
  String get currency_chooser_label => 'โปรดเลือกสกุลเงิน';

  @override
  String get country_change_message => 'คุณเพิ่งเปลี่ยนประเทศ';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'คุณต้องการเปลี่ยนสกุลเงินจาก $previousCurrency เป็น $possibleCurrencyหรือไม่?';
  }

  @override
  String get onboarding_country_chooser_label => 'โปรดเลือกประเทศ:';

  @override
  String get country_chooser_label_from_settings => 'ประเทศของคุณ';

  @override
  String get country_selection_explanation =>
      'ลักษณะทางสิ่งแวดล้อมบางอย่างมีความเฉพาะเจาะจงตามสถานที่ตั้ง';

  @override
  String get product_removed_comparison => 'สินค้าถูกนำออกจากการเปรียบเทียบ';

  @override
  String get native_app_settings => 'การตั้งค่าแอปดั้งเดิม';

  @override
  String get native_app_description =>
      'การตั้งค่าระบบแบบเปิดสำหรับ Open Food Facts';

  @override
  String get product_removed_history => 'สินค้าถูกลบออกจากประวัติแล้ว';

  @override
  String get product_removed_list => 'สินค้าถูกลบออกจากรายการแล้ว';

  @override
  String get product_could_not_remove => 'ไม่สามารถนำสินค้าออกได้';

  @override
  String get no_prodcut_in_list => 'ไม่มีสินค้าในรายการนี้';

  @override
  String get no_product_in_section => 'ไม่มีสินค้าในหมวดนี้';

  @override
  String get recently_seen_products => 'สินค้าทั้งหมดที่แสดง';

  @override
  String get clear => 'ล้างข้อมูล';

  @override
  String get clear_long => 'ล้างรายการ';

  @override
  String get really_clear => 'คุณต้องการลบรายชื่อนี้จริง ๆ หรือไม่?';

  @override
  String pct_match(Object percent) {
    return '$percent% ตรงกัน';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count หลายวันก่อน',
      one: 'หนึ่งวันก่อน',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count หลายชั่วโมงที่แล้ว',
      one: 'หนึ่งชั่วโมงที่แล้ว',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count หลายนาทีที่แล้ว',
      one: 'หนึ่งนาทีที่แล้ว',
      zero: 'น้อยกว่าหนึ่งนาทีที่แล้ว',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count หลายเดือนที่แล้ว',
      one: 'หนึ่งเดือนที่แล้ว',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count หลายสัปดาห์ที่แล้ว',
      one: 'หนึ่งสัปดาห์ที่แล้ว',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'เปรียบเทียบสินค้า $count หลายรายการ',
      one: 'เปรียบเทียบสินค้าหนึ่งรายการ',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count มีสินค้าที่เลือกหลายรายการ',
      one: 'มีสินค้าที่เลือก 1 รายการ',
      zero: 'ไม่มีสินค้าที่เลือก',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'เปรียบเทียบผลิตภัณฑ์ที่เลือก';

  @override
  String get delete_products_mode => 'ลบผลิตภัณฑ์ที่เลือก';

  @override
  String get select_all_products_mode => 'เลือกสินค้าทั้งหมด';

  @override
  String get select_none_products_mode => 'เลือกไม่มี';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle =>
      'โปรดเลือกสินค้าอย่างน้อยสองรายการ';

  @override
  String get retry_button_label => 'ลองใหม่อีกครั้ง';

  @override
  String get connect_with_us => 'ติดต่อเรา';

  @override
  String get tiktok => 'ติดตามเราได้ทาง TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'ติดตามเราได้ทางอินสตาแกรม';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'ติดตามเราได้ทาง X (เดิมคือ Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'ติดตามเราได้ที่ Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'ติดตามเราได้ที่ BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'บล็อก';

  @override
  String get faq => 'คำถามที่พบบ่อย';

  @override
  String get discover => 'รู้จักกับ Open Food Facts';

  @override
  String get how_to_contribute => 'วิธีร่วมบริจาค';

  @override
  String get hint_knowledge_panel_message =>
      'คุณสามารถแตะที่ส่วนใดก็ได้ของบัตรเพื่อดูรายละเอียดเพิ่มเติมเกี่ยวกับสิ่งที่คุณเห็น ลองใช้ดูเลย!';

  @override
  String get permissions_page_title => 'การเข้าถึงกล้อง';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'หากคุณเปลี่ยนใจ คุณสามารถเปิดหรือปิดใช้งานตัวเลือกนี้ได้ตลอดเวลาจากเมนูการตั้งค่า';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'ระบบปฏิบัติการ: Android (SDK Int: $sdkInt / รุ่น: $release)\nรุ่น: $model\nผลิตภัณฑ์: $product\nอุปกรณ์: $device\nยี่ห้อ:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'ระบบปฏิบัติการ: iOS ($version)\nรุ่น: $model\nรุ่นที่รองรับภาษาท้องถิ่น: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nเวอร์ชันแอป:$appVersion\nหมายเลขบิลด์แอป:$appBuildNumber\nชื่อแพ็กเกจแอป:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'ปฏิเสธ';

  @override
  String get ask_me_later_button_label => 'ภายหลัง';

  @override
  String get are_you_sure => 'คุณแน่ใจเหรอ?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'ไปต่อที่ $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'ยินดีต้อนรับ !';

  @override
  String get onboarding_home_welcome_text2 =>
      'แอปที่ช่วยคุณเลือกอาหารที่ดีต่อสุขภาพของคุณและโลก!';

  @override
  String get onboarding_continue_button => 'ดำเนินการต่อ';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'กำลังโหลดผลิตภัณฑ์ตัวอย่างแรกของคุณ';

  @override
  String get onboarding_welcome_warning =>
      'ขออภัยค่ะ นี่เป็นสินค้าตัวอย่างของเรา คุณไม่สามารถแก้ไขได้ค่ะ :)';

  @override
  String get product_list_your_ranking => 'อันดับของคุณ';

  @override
  String get product_list_empty_icon_desc => 'ไม่มีประวัติให้ดู';

  @override
  String get product_list_empty_title => 'เริ่มการสแกน';

  @override
  String get product_list_empty_message =>
      'สินค้าที่สแกนแล้วจะปรากฏที่นี่ และคุณสามารถตรวจสอบข้อมูลโดยละเอียดเกี่ยวกับสินค้าเหล่านั้นได้';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ผลิตภัณฑ์',
      one: 'ผลิตภัณฑ์',
      zero: 'ผลิตภัณฑ์',
    );
    return 'รีเฟรช $_temp0 ในประวัติของคุณ';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ผลิตภัณฑ์ต่างๆ',
      one: 'ผลิตภัณฑ์',
      zero: 'ผลิตภัณฑ์',
    );
    return '$_temp0 รีเฟรชเสร็จสมบูรณ์';
  }

  @override
  String get product_list_compare_side_by_side => 'เปรียบเทียบแบบเคียงข้างกัน';

  @override
  String get loading_dialog_default_title => 'กำลังดาวน์โหลดข้อมูล';

  @override
  String get loading_dialog_default_error_message =>
      'ไม่สามารถดาวน์โหลดข้อมูลได้';

  @override
  String get account_delete => 'ลบบัญชี';

  @override
  String get account_delete_title => 'ลบบัญชีของฉัน';

  @override
  String get user_profile => 'บัญชี';

  @override
  String get user_profile_title_guest => 'ยินดีต้อนรับ!';

  @override
  String get user_profile_subtitle_guest =>
      'เข้าสู่ระบบหรือลงทะเบียนเพื่อเข้าร่วมชุมชน Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'เข้าสู่ระบบ Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'ยินดีต้อนรับ $id!';
  }

  @override
  String get email_subject_account_deletion => 'ลบบัญชี';

  @override
  String email_body_account_deletion(String userId) {
    return 'สวัสดีค่ะ กรุณาลบบัญชี Open Food Facts ของฉันด้วยนะคะ: $userId';
  }

  @override
  String get settings_app_app => 'แอปพลิเคชัน';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'กล้อง';

  @override
  String get settings_app_products => 'ผลิตภัณฑ์';

  @override
  String get settings_app_miscellaneous => 'เบ็ดเตล็ด';

  @override
  String get camera_play_sound_title => 'เล่นเสียงเมื่อสแกน';

  @override
  String get camera_play_sound_subtitle => 'จะมีเสียงบี๊บทุกครั้งที่สแกนสำเร็จ';

  @override
  String get camera_window_accessibility_label => 'สแกนบาร์โค้ดด้วยกล้องของคุณ';

  @override
  String get app_haptic_feedback_title => 'การสั่นสะเทือนและการสัมผัส';

  @override
  String get app_haptic_feedback_subtitle =>
      'มีการสั่นเตือนหลังจากดำเนินการบางอย่าง (ถอดรหัสบาร์โค้ดแล้ว นำสินค้าออก…)';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'เมื่อเปิดใช้งาน ระบบจะส่งรายงานข้อผิดพลาดไปยังระบบติดตามข้อผิดพลาดของ Open Food Facts โดยอัตโนมัติ เพื่อให้สามารถแก้ไขข้อผิดพลาดและปรับปรุงแอปได้';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'แก้ไขรูปภาพ';

  @override
  String get permission_photo_error => 'ข้อผิดพลาด';

  @override
  String get permission_photo_denied_title => 'อนุญาตให้ใช้กล้องสแกนบาร์โค้ด';

  @override
  String permission_photo_denied_message(String appName) {
    return 'เพื่อประสบการณ์การใช้งานที่ดียิ่งขึ้น โปรดอนุญาตให้ $appName เข้าถึงกล้องของคุณ คุณจะสามารถสแกนบาร์โค้ดได้โดยตรง';
  }

  @override
  String get permission_photo_denied_button => 'อนุญาต';

  @override
  String get permission_photo_denied_dialog_settings_title => 'ไม่ได้รับอนุญาต';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'เนื่องจากก่อนหน้านี้คุณได้ปฏิเสธการอนุญาตการเข้าถึงกล้อง คุณจึงต้องอนุญาตด้วยตนเองจากเมนูการตั้งค่า';

  @override
  String get permission_photo_denied_dialog_settings_button_open => 'ตั้งค่า';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'ยกเลิก';

  @override
  String get permission_photo_none_found => 'ไม่พบกล้อง';

  @override
  String get permission_photo_denied => 'ไม่อนุญาตให้เข้าถึงกล้อง';

  @override
  String get show_product_pictures => 'แสดงรูปภาพสินค้า';

  @override
  String get edit_product_label => 'แก้ไขสินค้า';

  @override
  String get edit_product_pending_operations_banner_title =>
      'กำลังอัปโหลดการแก้ไขของคุณ…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'การแก้ไขของคุณกำลังถูกส่งไปในเบื้องหลัง (หรือส่งในภายหลังหากเกิดข้อผิดพลาด)\nคุณสามารถแก้ไขฟิลด์ผลิตภัณฑ์อื่นๆ ต่อไปได้';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'การแก้ไขของคุณกำลังถูกส่งไปในเบื้องหลัง (หรือส่งในภายหลังหากเกิดข้อผิดพลาด)';

  @override
  String get edit_product_label_short => 'แก้ไข';

  @override
  String edit_product_form_item_help(String value) {
    return 'วิธีป้อน \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'โปรดป้อนค่าที่ไม่ว่างเปล่า!';

  @override
  String get edit_product_form_item_error_existing => 'ค่านี้มีอยู่แล้ว!';

  @override
  String get edit_product_form_item_add_action_brand => 'เพิ่มแบรนด์ใหม่';

  @override
  String get edit_product_form_item_add_action_label => 'เพิ่มป้ายกำกับใหม่';

  @override
  String get edit_product_form_item_add_action_store => 'เพิ่มร้านค้าใหม่';

  @override
  String get edit_product_form_item_add_action_origin => 'เพิ่มแหล่งกำเนิดใหม่';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'เพิ่มรหัสตรวจสอบย้อนกลับใหม่';

  @override
  String get edit_product_form_item_add_action_country => 'เพิ่มประเทศใหม่';

  @override
  String get edit_product_form_item_add_action_category => 'เพิ่มหมวดหมู่ใหม่';

  @override
  String get edit_product_form_item_add_action_trace => 'เพิ่มการติดตามใหม่';

  @override
  String get edit_product_form_item_add_suggestion => 'เพิ่มคำแนะนำ';

  @override
  String get edit_product_form_item_deny_suggestion => 'ปฏิเสธข้อเสนอแนะ';

  @override
  String get edit_product_form_item_details_title => 'รายละเอียดพื้นฐาน';

  @override
  String get edit_product_form_item_details_subtitle =>
      'ชื่อสินค้า ยี่ห้อ จำนวน';

  @override
  String get edit_product_form_item_other_details_title =>
      'รายละเอียดเพิ่มเติม';

  @override
  String get edit_product_form_item_other_details_subtitle => 'เว็บไซต์…';

  @override
  String get edit_product_form_item_photos_title => 'รูปภาพ';

  @override
  String get edit_product_form_item_photos_subtitle => 'เพิ่มหรืออัปเดตภาพถ่าย';

  @override
  String get edit_product_form_item_labels_title => 'ฉลากและใบรับรอง';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'ฉลากด้านสิ่งแวดล้อมและคุณภาพ…';

  @override
  String get edit_product_form_item_labels_hint =>
      'ป้อนป้ายกำกับ (เช่น: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'แนวปฏิบัติที่ดี: การติดฉลาก';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'คุณลักษณะใดๆ ของผลิตภัณฑ์ **ซึ่งเป็นข้อเท็จจริง** และแตกต่างจากด้านอื่นๆ';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'คะแนนโภชนาการ, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'ผลิตในเบลเยียม ผลิตในแคว้นบริตตานี…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'อุดมไปด้วยใยอาหาร เป็นแหล่งของธาตุเหล็ก…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'การค้าที่เป็นธรรม แม็กซ์ ฮาเวลาร์…';

  @override
  String get edit_product_form_item_stores_title => 'ร้านค้า';

  @override
  String get edit_product_form_item_stores_hint => 'ป้อนชื่อร้านค้า';

  @override
  String get edit_product_form_item_stores_type => 'เก็บ';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'แนวปฏิบัติที่ดี: ร้านค้า';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'กรุณาป้อนชื่อร้านค้าที่คุณซื้อสินค้า';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'วอลมาร์ท';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'คาร์ฟูร์';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'ลิเดิล';

  @override
  String get edit_product_form_item_origins_title => 'ต้นกำเนิด';

  @override
  String get edit_product_form_item_origins_hint =>
      'ระบุประเทศต้นกำเนิด (เช่น เยอรมนี)';

  @override
  String get edit_product_form_item_origins_type => 'ประเทศ';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'แนวปฏิบัติที่ดี: ที่มา';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'เพิ่ม **ข้อมูลบ่งชี้แหล่งที่มาใดๆ ก็ตามที่คุณสามารถหาได้บนบรรจุภัณฑ์**\nคุณไม่จำเป็นต้องกังวลเกี่ยวกับแหล่งที่มาที่ระบุไว้โดยตรงในรายการส่วนผสม';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'เนื้อวัวจากอาร์เจนตินา';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'ถั่วเหลืองนี้ไม่ได้มาจากสหภาพยุโรป';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'ป้อนชื่อประเทศ (เช่น เยอรมนี)';

  @override
  String get edit_product_form_item_countries_type => 'ประเทศ';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'แนวปฏิบัติที่ดี: ประเทศต่างๆ';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**ประเทศที่สินค้ามีจำหน่ายอย่างแพร่หลาย** (ไม่รวมร้านค้าที่จำหน่ายสินค้าต่างประเทศโดยเฉพาะ)';

  @override
  String get edit_product_form_item_emb_codes_title => 'รหัสการตรวจสอบย้อนกลับ';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'ป้อนรหัส (เช่น: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'รหัสตรวจสอบย้อนกลับ';

  @override
  String get edit_product_form_item_emb_help_title =>
      'แนวปฏิบัติที่ดี: รหัสการตรวจสอบย้อนกลับ';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'ในส่วนนี้ คุณสามารถป้อนรหัสที่เกี่ยวข้องกับ **เครื่องหมายบรรจุภัณฑ์** **เครื่องหมายระบุตัวตน** หรือ **เครื่องหมายด้านสุขภาพ** ได้';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'ตัวอย่างรหัสการตรวจสอบย้อนกลับ';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**รหัส EC** ที่ใช้ในประชาคมยุโรปเพื่อระบุผู้ผลิตหรือผู้บรรจุอาหาร:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'ฝรั่งเศส\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: รหัสประเทศของ **ฝรั่งเศส**\n**72.264.002**: ข้อมูลทางภูมิศาสตร์\n**CE**: ประชาคมยุโรป';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**รหัส EMB** ที่ใช้ในฝรั่งเศส:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'อีเอ็มบี 72264';

  @override
  String get edit_product_form_item_traces_title => 'สารเจือปน';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'ป้อนข้อมูลการติดตาม (เช่น ถั่วเหลือง)';

  @override
  String get edit_product_form_item_categories_title => 'หมวดหมู่';

  @override
  String get edit_product_form_item_categories_hint => 'ประเภท';

  @override
  String get edit_product_form_item_categories_type =>
      'ป้อนหมวดหมู่ (เช่น น้ำส้ม)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'แนวปฏิบัติที่ดี: หมวดหมู่';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'ระบุ **เฉพาะหมวดหมู่ที่เฉพาะเจาะจงที่สุด** เท่านั้น\nหมวดหมู่หลักจะถูกเพิ่มโดยอัตโนมัติ';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'หมวดหมู่หายไปใช่ไหม?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'ในกรณีที่หมวดหมู่ **ไม่มีอยู่ในระบบเติมข้อความอัตโนมัติ** คุณสามารถเพิ่มหมวดหมู่เข้าไปได้\nการทำเช่นนี้จะช่วยให้เราปรับปรุง Open Food Facts ในประเทศของคุณให้ดียิ่งขึ้น';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'ปลาซาร์ดินในน้ำมันมะกอก';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'น้ำส้มคั้นจากน้ำส้มเข้มข้น';

  @override
  String get edit_product_form_item_exit_title =>
      'ออกจากโปรแกรมโดยไม่บันทึกใช่ไหม?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'คุณต้องการบันทึกการเปลี่ยนแปลงก่อนออกจากหน้านี้หรือไม่?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'บันทึกการเปลี่ยนแปลง';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'ยกเลิกการเปลี่ยนแปลง';

  @override
  String get edit_product_form_item_ingredients_title => 'ส่วนผสม';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'ซูมเข้าและซูมออกโดยการบีบนิ้วบนหน้าจอ';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'ซูมเข้าและซูมออกรูปภาพ';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'ใช้ท่าทาง **บีบนิ้วเพื่อซูม** เพื่อซูมเข้าหรือซูมออกรูปภาพ:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'เพิ่ม';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'กรุณาป้อนข้อความก่อน';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'ลบ';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'บันทึกการแก้ไขของคุณ';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'ยกเลิกการแก้ไขของคุณ';

  @override
  String get edit_product_form_item_packaging_title =>
      'ภาพประกอบคำแนะนำการรีไซเคิล';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'ข้อมูลโภชนาการ';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'ข้อมูลโภชนาการ ปริมาณแอลกอฮอล์…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'แนวปฏิบัติที่ดี: ข้อมูลโภชนาการ';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'คุณค่าทางโภชนาการ';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'ขั้นแรก เลือกหากมีการระบุค่าไว้:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'ข้อมูลโภชนาการ';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'จากนั้น ป้อนค่าโภชนาการ **ตามที่ระบุไว้บนบรรจุภัณฑ์** หากไม่มีค่าโภชนาการ ให้คลิกที่ไอคอน \"รูปตา\"';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'ข้อมูลที่ขาดหายไป?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'หากรายการใดหายไป คุณสามารถ **คลิกที่ไอคอน \"บวก\"** เพื่อเพิ่มรายการนั้นได้ (เช่น วิตามินดี แมกนีเซียม…)';

  @override
  String get edit_product_form_save => 'แก้ไข';

  @override
  String get edit_product_ingredients_photo_title =>
      'รูปภาพของส่วนประกอบของอาหาร';

  @override
  String get edit_product_ingredients_list_title => 'รายชื่อส่วนผสม';

  @override
  String get edit_product_packaging_photo_title => 'ภาพบรรจุภัณฑ์';

  @override
  String get edit_product_packaging_list_title => 'รายการบรรจุภัณฑ์';

  @override
  String get no_data_available => 'ไม่มีข้อมูล';

  @override
  String get product_field_website_title => 'เว็บไซต์';

  @override
  String get origins_editing_title => 'แก้ไขต้นกำเนิด';

  @override
  String get completed_basic_details_btn_text => 'รายละเอียดพื้นฐานครบถ้วน';

  @override
  String get not_implemented_snackbar_text => 'ยังไม่ได้นำไปใช้งาน';

  @override
  String get category_picker_page_appbar_text => 'หมวดหมู่';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'สกัดส่วนผสมจากรูปภาพ';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'การแยกส่วนประกอบ\nจากรูปภาพ';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'กำลังโหลดรูปภาพ…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'ทำไมฉันถึงเห็นข้อความนี้?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'ในการใช้ฟีเจอร์ \"แยกส่วนผสม\" คุณต้องอัปโหลดรูปภาพก่อน\n\nโปรดรอสักครู่หรือป้อนส่วนผสมด้วยตนเอง';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'รีเฟรชรูปภาพ';

  @override
  String get edit_packaging_extract_btn_text => 'ดึงบรรจุภัณฑ์\nออกจากรูปภาพ';

  @override
  String get edit_packaging_extract_btn_text_short => 'บรรจุภัณฑ์สารสกัด';

  @override
  String get edit_packaging_extracting_btn_text =>
      'การแยกบรรจุภัณฑ์ออกจากภาพถ่าย';

  @override
  String get edit_packaging_loading_photo_btn_text => 'กำลังโหลดรูปภาพ…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'ทำไมฉันถึงเห็นข้อความนี้?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'ในการใช้ฟีเจอร์ \"แยกภาพบรรจุภัณฑ์\" คุณต้องอัปโหลดภาพก่อน\n\nโปรดรอสักครู่หรือป้อนภาพด้วยตนเอง';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'รีเฟรชรูปภาพ';

  @override
  String get edit_ocr_extract_failed => 'ไม่สามารถตรวจจับข้อความในภาพได้';

  @override
  String get edit_ocr_extract_disabled_title => 'ไม่มีรูปภาพ!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'ในการใช้ฟีเจอร์การดึงข้อความ คุณต้องถ่ายรูปก่อน';

  @override
  String get user_list_dialog_new_title => 'รายการสินค้าใหม่';

  @override
  String get user_list_dialog_rename_title => 'เปลี่ยนชื่อรายการ';

  @override
  String get user_list_subtitle_product => 'รายการ';

  @override
  String get user_list_title => 'รายการของคุณ';

  @override
  String get user_list_add_product => 'เพิ่มสินค้าลงในรายการของคุณ';

  @override
  String get user_list_button_new => 'สร้างรายการใหม่';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'เพิ่มลงในรายการ';

  @override
  String get added_to_list_msg => 'เพิ่มลงในรายการแล้ว';

  @override
  String get user_list_popup_clear => 'ล้างประวัติการใช้งานของคุณ';

  @override
  String get user_list_popup_rename => 'เปลี่ยนชื่อ';

  @override
  String get user_list_name_hint => 'รายชื่อของฉัน';

  @override
  String get user_list_name_error_empty => 'ชื่อ (จำเป็นต้องระบุ)';

  @override
  String get user_list_name_error_already => 'ชื่อนั้นมีคนใช้แล้ว';

  @override
  String get user_list_name_error_same => 'นั่นคือชื่อเดียวกัน';

  @override
  String get user_list_name_input_hint => 'ชื่อของรายการ';

  @override
  String get try_again => 'ลองอีกครั้ง';

  @override
  String get there_was_an_error => 'เกิดข้อผิดพลาด';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'ไม่พบหมวดหมู่สำหรับ $items';
  }

  @override
  String get camera_toggle_camera => 'สลับระหว่างกล้องหลังและกล้องหน้า';

  @override
  String get camera_toggle_flash => 'เปิดหรือปิดแฟลชของกล้อง';

  @override
  String get camera_enable_flash => 'เปิดใช้งานแฟลช';

  @override
  String get camera_disable_flash => 'ปิดใช้งานแฟลช';

  @override
  String get camera_flash_error_dialog_title => 'เกิดข้อผิดพลาด!';

  @override
  String get camera_flash_error_dialog_message =>
      'เกิดข้อผิดพลาดขณะเปลี่ยนสถานะของไฟฉาย โปรดตรวจสอบให้แน่ใจว่าสมาร์ทโฟนของคุณไม่ได้เปิดใช้งานไฟฉายอยู่แล้ว';

  @override
  String get category_picker_no_category_found_button => 'ย้อนกลับ';

  @override
  String get user_preferences_item_accessibility_hint =>
      'คลิกเพื่อเปิดในเบราว์เซอร์ของคุณ หรือในแอปพลิเคชัน (หากติดตั้งไว้)';

  @override
  String get dev_preferences_screen_title => 'โหมด DEV';

  @override
  String get dev_preferences_screen_subtitle =>
      'เข้าถึงคุณลักษณะเชิงทดลองและเครื่องมือการพัฒนา';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'เริ่มกระบวนการรับพนักงานใหม่อีกครั้ง';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'จากนั้นคุณต้องรีสตาร์ทแอปเพื่อดูผลลัพธ์อีกครั้ง';

  @override
  String get dev_preferences_environment_switch_title =>
      'สลับระหว่าง openfoodfacts.org (สภาพแวดล้อมการผลิต) และสภาพแวดล้อมทดสอบ';

  @override
  String get dev_preferences_test_environment_title =>
      'พารามิเตอร์สภาพแวดล้อมการทดสอบ';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL พื้นฐานสำหรับสภาพแวดล้อมการทดสอบปัจจุบัน: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'โฮสต์สภาพแวดล้อมการทดสอบ';

  @override
  String get dev_preferences_ml_kit_title => 'ใช้ชุด ML';

  @override
  String get dev_preferences_ml_kit_subtitle => 'จากนั้นคุณต้องรีสตาร์ทแอปนี้';

  @override
  String get dev_preferences_product_additional_features_title =>
      'ปุ่มเพิ่มเติมในหน้าสินค้า';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'แก้ไขส่วนผสมคลิกที่ปุ่มแห่งความรู้';

  @override
  String get dev_preferences_export_history_title => 'ประวัติการส่งออก';

  @override
  String get dev_preferences_export_history_progress_error => 'ข้อยกเว้น';

  @override
  String get dev_preferences_export_history_progress_found => 'พบผลิตภัณฑ์';

  @override
  String get dev_preferences_export_history_progress_not_found => 'ไม่พบสินค้า';

  @override
  String get dev_preferences_export_history_dialog_title => 'ประวัติการส่งออก';

  @override
  String get dev_preferences_button_positive => 'ตกลง';

  @override
  String get dev_preferences_button_negative => 'ยกเลิก';

  @override
  String get dev_preferences_migration_title => 'การย้ายข้อมูลจากเวอร์ชัน 1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'สถานะ: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'สำเร็จหรือติดตั้งใหม่';

  @override
  String get dev_preferences_migration_status_success => 'ความสำเร็จ';

  @override
  String get dev_preferences_migration_status_error => 'ข้อผิดพลาด';

  @override
  String get dev_preferences_migration_status_in_progress => 'กำลังดำเนินการ';

  @override
  String get dev_preferences_migration_status_required =>
      'จำเป็น (คลิกเพื่อเริ่ม)';

  @override
  String get dev_preferences_migration_status_not_started => 'ไม่ทราบ';

  @override
  String get dev_preferences_import_history_subtitle =>
      'จะล้างประวัติและใส่สินค้า 3 รายการเข้าไปแทน';

  @override
  String get dev_preferences_news_custom_url_title =>
      'URL ที่กำหนดเองสำหรับข่าวสาร';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL ของไฟล์ JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'ไม่ได้ตั้งค่า';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'อัปเดตล่าสุด: $date';
  }

  @override
  String get product_type_label_food => 'อาหาร';

  @override
  String get product_type_label_beauty => 'การดูแลส่วนบุคคล';

  @override
  String get product_type_label_pet_food => 'อาหารสัตว์เลี้ยง';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'ประเภทผลิตภัณฑ์';

  @override
  String get product_type_selection_subtitle => 'เลือกประเภทของผลิตภัณฑ์นี้';

  @override
  String get product_type_selection_empty => 'คุณต้องเลือกประเภทสินค้าก่อน!';

  @override
  String product_type_selection_already(String productType) {
    return 'คุณไม่สามารถเปลี่ยนประเภทสินค้าได้ ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag => 'ทางลัดไปยังแอปแสดงราคาบนหน้าสินค้า';

  @override
  String get prices_app_button => 'ไปที่แอปราคา';

  @override
  String get prices_website_button => 'เปิดบนเว็บไซต์ราคาเปิด';

  @override
  String get prices_bulk_proof_upload_select =>
      'เพิ่มป้ายราคาโดยตรงจากแกลเลอรี่';

  @override
  String get prices_bulk_proof_upload_warning =>
      'เมื่อคุณเลือกรูปภาพแล้ว คุณจะไม่สามารถแก้ไขรูปภาพเหล่านั้นได้อีก!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'อนุญาตให้ชุมชนตรวจสอบราคาที่สกัดออกมาโดย AI';

  @override
  String get prices_bulk_proof_upload_subtitle => 'ป้ายราคาหลายแบบ';

  @override
  String get prices_bulk_proof_upload_title => 'การอัปโหลดหลักฐานจำนวนมาก';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'การเลือกไฟล์';

  @override
  String get prices_bulk_proof_upload_step_starting => 'เริ่มต้นการอัพโหลด';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'การคัดลอกไฟล์ภายในเครื่อง #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'กำลังเตรียมอัพโหลด #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'ล้มเหลวที่ภาพ #$index/$count';
  }

  @override
  String get prices_generic_title => 'ราคา';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'เพิ่ม $count ราคา',
      one: 'เพิ่มราคา',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ส่ง $count ราคา',
      one: 'ส่งราคา',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'เพิ่มรายการ';

  @override
  String get prices_add_a_price => 'เพิ่มราคา';

  @override
  String get prices_add_a_receipt => 'เพิ่มใบเสร็จ';

  @override
  String get prices_add_price_tags => 'เพิ่มป้ายราคา';

  @override
  String prices_barcode_already(String barcode) {
    return 'บาร์โค้ดนี้ ($barcode) อยู่ในรายการแล้ว!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'ยังไม่มีสินค้า';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'กำลังมองหา $barcode';
  }

  @override
  String get prices_barcode_enter => 'ป้อนบาร์โค้ด';

  @override
  String get prices_category_enter => 'สินค้าไม่มีบาร์โค้ด';

  @override
  String get prices_per_kilogram => 'ราคาต่อกิโลกรัม';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / กก.';

  @override
  String get prices_per_unit_short => ' / หน่วย';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'ไม่จำเป็น';

  @override
  String get prices_category_error_mandatory => 'หมวดหมู่นี้จำเป็นต้องกรอก';

  @override
  String get prices_barcode_reader_action => 'เครื่องอ่านบาร์โค้ด';

  @override
  String get prices_view_prices => 'ดูราคา';

  @override
  String get prices_list_title => 'รายการราคา';

  @override
  String get prices_list_count => 'จำนวนราคา\n';

  @override
  String get prices_list_add_new_price => 'เพิ่มราคาใหม่\n';

  @override
  String get prices_list_empty_title => 'ยังไม่มีราคา!';

  @override
  String get prices_list_empty_subtitle =>
      'เป็นคนแรกที่จะเพิ่มอันหนึ่ง:\nโดยการสแกน **ใบเสร็จ** หรือ **ป้ายราคา**!';

  @override
  String get prices_entry_shop_not_found => 'ร้านค้าที่ไม่ทราบชื่อ';

  @override
  String prices_entry_menu_title(String user) {
    return 'ราคาเริ่มต้น \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'ดูราคาทั้งหมดสำหรับผลิตภัณฑ์นี้';

  @override
  String get prices_entry_menu_open_proof => 'ดูหลักฐาน';

  @override
  String get prices_entry_menu_my_prices => 'ดูราคาอื่นๆ ของฉัน';

  @override
  String get prices_entry_menu_author_prices => 'ดูราคาอื่นๆ ของผู้แต่ง';

  @override
  String get prices_entry_menu_shop_prices => 'ดูราคาอื่นๆจากร้านค้า';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ราคาต่างๆ',
      one: 'ราคา 1 รายการ',
    );
    return '$_temp0 สำหรับ $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ราคาทั้งหมด $count',
      one: 'มีราคาเดียว',
      zero: 'ยังไม่มีราคา',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'ราคาล่าสุดของ $pageSize (รวมทั้งหมด: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'ราคา: $price / ร้านค้า: \"$location\" / เผยแพร่เมื่อ $date โดย \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'หลักฐานการเปิดเผยของ \"$user\"';
  }

  @override
  String get prices_open_proof => 'หลักฐานราคาแบบเปิด';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'หลักฐานทั้งหมด $count',
      one: 'มีหลักฐานเพียงชิ้นเดียว',
      zero: 'ยังไม่มีหลักฐาน',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'หลักฐาน $pageSize ล่าสุด (ทั้งหมด: $total)';
  }

  @override
  String get prices_users_empty_title => 'ยังไม่มีผู้สนับสนุน!';

  @override
  String get prices_users_empty_explanation => 'เป็นคนแรกที่จะเพิ่มราคา!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'ผู้ร่วมให้ข้อมูลระดับ $pageSize อันดับแรก (รวมทั้งหมด: $total)';
  }

  @override
  String get prices_locations_empty_title => 'ยังไม่มีร้านค้า!';

  @override
  String get prices_locations_empty_explanation => 'เป็นคนแรกที่จะเพิ่มราคา!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'สถานที่ยอดนิยม $pageSize แห่ง (รวมทั้งหมด: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count หลักฐานหลายข้อ',
      one: 'หลักฐานหนึ่งข้อ',
      zero: 'ไม่มีหลักฐาน',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count สินค้า',
      one: 'มีสินค้า 1 ชิ้น',
      zero: 'ไม่มีสินค้า',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ผู้ใช้',
      one: 'ผู้ใช้หนึ่งคน',
      zero: 'ไม่มีผู้ใช้',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ราคาต่างๆ',
      one: 'ราคาเดียว',
      zero: 'ไม่มีราคา',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'ราคาที่เพิ่มไว้ก่อนหน้านี้';

  @override
  String get prices_amount_subtitle => 'จำนวน';

  @override
  String get prices_amount_is_discounted => 'มีส่วนลดไหม?';

  @override
  String get prices_amount_price_normal => 'ราคา';

  @override
  String get prices_amount_price_discounted => 'ราคาลดพิเศษ';

  @override
  String get prices_amount_price_not_discounted => 'ราคาเดิม';

  @override
  String get prices_amount_no_product => 'สินค้าหายไปหนึ่งรายการ!';

  @override
  String get prices_amount_price_incorrect => 'ค่าไม่ถูกต้อง';

  @override
  String get prices_amount_price_mandatory => 'ค่าบังคับ';

  @override
  String get prices_currency_subtitle => 'สกุลเงิน';

  @override
  String get prices_date_subtitle => 'วันที่';

  @override
  String get prices_location_subtitle => 'ร้านค้า';

  @override
  String get prices_location_find => 'ค้นหาร้านค้า';

  @override
  String get prices_location_mandatory => 'คุณต้องเลือกร้านค้า!';

  @override
  String get prices_location_search_broader =>
      'หาไม่เจอสิ่งที่ต้องการใช่ไหม ลองค้นหาในวงกว้างขึ้นดูสิ!';

  @override
  String get prices_proof_subtitle => 'การพิสูจน์';

  @override
  String get prices_proof_empty_title => 'ยังไม่มีหลักฐาน!';

  @override
  String get prices_proof_empty_explanation =>
      'เริ่มต้นด้วยการเพิ่มรูปภาพของ **ใบเสร็จ** หรือ **ป้ายราคา**!';

  @override
  String get prices_proof_find => 'เลือกหลักฐาน';

  @override
  String get prices_proof_change => 'หลักฐานการเปลี่ยนแปลง';

  @override
  String get prices_proof_receipt => 'ใบเสร็จ';

  @override
  String get prices_proof_price_tag => 'ป้ายราคา';

  @override
  String get prices_proof_mandatory => 'คุณต้องเลือกหลักฐาน!';

  @override
  String get prices_add_validation_error => 'ข้อผิดพลาดในการตรวจสอบความถูกต้อง';

  @override
  String get prices_privacy_warning_title => 'คำเตือนเกี่ยวกับความเป็นส่วนตัว';

  @override
  String get prices_unknown_product => 'ผลิตภัณฑ์ไม่ทราบชนิด';

  @override
  String get prices_privacy_warning_main_message =>
      'ราคาสินค้า **จะเปิดเผยต่อสาธารณะ** พร้อมทั้งชื่อร้านค้าที่อ้างอิง\n\nซึ่งอาจช่วยให้ผู้ที่รู้จักนามแฝง Open Food Facts ของคุณ:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'คาดเดาว่าคุณอาศัยอยู่ในพื้นที่ใด';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'รู้ว่าคุณกำลังซื้ออะไร';

  @override
  String get prices_privacy_warning_sub_message =>
      'หากคุณไม่สบายใจกับเรื่องนี้ โปรดเปลี่ยนชื่อเล่นของคุณ หรือสร้างบัญชี Open Food Facts ใหม่ แล้วเข้าสู่ระบบแอปด้วยบัญชีใหม่นั้น';

  @override
  String get i_refuse => 'ฉันปฏิเสธ';

  @override
  String get i_accept => 'ฉันยอมรับ';

  @override
  String get prices_currency_change_proposal_title => 'เปลี่ยนสกุลเงิน?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'สกุลเงินปัจจุบันของคุณคือ **$currency** คุณต้องการเปลี่ยนเป็น **$newCurrency** หรือไม่?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'ใช่ ใช้ $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'ไม่ ให้เก็บ $currencyไว้';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'เสร็จแล้ว';

  @override
  String get dev_mode_section_server => 'การกำหนดค่าเซิร์ฟเวอร์';

  @override
  String get dev_mode_section_news => 'การกำหนดค่าผู้ให้บริการข่าวสาร';

  @override
  String get dev_mode_section_product_page => 'หน้าสินค้า';

  @override
  String get dev_mode_section_ui => 'ส่วนติดต่อผู้ใช้';

  @override
  String get dev_mode_section_experimental_features => 'คุณสมบัติเชิงทดลอง';

  @override
  String get dev_mode_hide_environmental_score_title => 'ไม่รวมคะแนนสีเขียว';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'ใช้โปรแกรมตรวจสอบการสะกดคำสำหรับหน้าจอ OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(ส่วนประกอบและบรรจุภัณฑ์)';

  @override
  String get dev_mode_reset_app_language_title => 'รีเซ็ตภาษาแอป';

  @override
  String get dev_mode_add_demo_cards_language_title => 'เพิ่มการ์ด';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'สลับระหว่าง prices.openfoodfacts.org (PROD) และทดสอบสภาพแวดล้อม';

  @override
  String get search_history_item_edit_tooltip =>
      'นำการค้นหานี้ไปใช้ซ้ำและแก้ไขได้';

  @override
  String get search_history_item_remove_tooltip => 'ลบ';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'คุณได้ดาวน์โหลดผลิตภัณฑ์ $totalSize ทั้งหมดเรียบร้อยแล้ว';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'ดาวน์โหลด $count ผลิตภัณฑ์เพิ่มเติม\nดาวน์โหลดไปแล้ว $downloaded จาก $totalSizeรายการ';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'การค้นหา $search ของคุณกำลังดำเนินการอยู่\n\nโปรดรอสักครู่…';
  }

  @override
  String get user_search_contributor_title => 'สินค้าที่ฉันเพิ่ม';

  @override
  String get user_search_informer_title => 'ผลิตภัณฑ์ที่ฉันตัดต่อ';

  @override
  String get user_search_photographer_title => 'ผลิตภัณฑ์ที่ฉันถ่ายภาพ';

  @override
  String get user_search_to_be_completed_title =>
      'ผลิตภัณฑ์ที่ฉันกำลังจะผลิตให้เสร็จสมบูรณ์';

  @override
  String get user_search_prices_title => 'ราคาของฉัน';

  @override
  String get user_search_proofs_title => 'หลักฐานของฉัน';

  @override
  String get user_search_proof_title => 'หลักฐานของฉัน';

  @override
  String search_proof_title(String user) {
    return 'หลักฐานจาก \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'ราคาผู้สนับสนุน: $user';
  }

  @override
  String get all_search_prices_latest_title => 'เพิ่มราคาล่าสุดแล้ว';

  @override
  String get all_search_prices_top_user_title =>
      'ผู้มีส่วนร่วมในการกำหนดราคาสูงสุด';

  @override
  String get all_search_prices_top_location_title =>
      'ร้านค้าที่มีราคาสูงที่สุด';

  @override
  String get prices_contribution_assistant => 'ผู้ช่วยด้านการกำหนดราคา';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'เพิ่มหลักฐานหลายรายการ';

  @override
  String get all_search_prices_top_location_single_title =>
      'ราคาสินค้าในร้านค้า';

  @override
  String get all_search_prices_top_product_title => 'สินค้าที่มีราคาสูงที่สุด';

  @override
  String get all_search_to_be_completed_title =>
      'ผลิตภัณฑ์ทั้งหมดที่ยังไม่เสร็จสมบูรณ์';

  @override
  String get categorize_products_country_title =>
      'ช่วยจัดหมวดหมู่สินค้าในประเทศของคุณ';

  @override
  String get edit_product_action_retake_picture => 'ถ่ายรูปใหม่';

  @override
  String get edit_product_action_take_picture => 'ถ่ายรูป';

  @override
  String get edit_product_action_confirm => 'ยืนยัน';

  @override
  String get signup_page_terms_of_use_line1 =>
      'ฉันเห็นด้วยกับข้อมูลอาหารเปิดเผย (Open Food Facts) ';

  @override
  String get signup_page_terms_of_use_line2 => 'ข้อมูลและเงื่อนไขการใช้งาน';

  @override
  String get analytics_consent_image_semantic_label => 'ไอคอนการวิเคราะห์';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'ข้อผิดพลาดร้ายแรง: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'ข้อผิดพลาดร้ายแรง: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'รายละเอียดพื้นฐานครบถ้วน';

  @override
  String get edit_photo_button_label => 'แก้ไข';

  @override
  String get edit_photo_unselect_button_label => 'ยกเลิกการเลือกรูปภาพ';

  @override
  String get edit_photo_select_existing_button_label => 'เลือกภาพที่มีอยู่แล้ว';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'เลือกภาพโดยการคลิกที่ภาพนั้น';

  @override
  String get edit_photo_select_existing_download_label =>
      'กำลังดึงภาพที่มีอยู่…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'ก่อนหน้านี้ยังไม่มีการอัปโหลดรูปภาพใดๆ ที่เกี่ยวข้องกับผลิตภัณฑ์นี้';

  @override
  String get edit_photo_language_not_this_one => 'ยังไม่มีภาพในภาษานั้น';

  @override
  String get edit_photo_language_none => 'ยังไม่มีรูปภาพ';

  @override
  String get category_picker_screen_title => 'หมวดหมู่';

  @override
  String get basic_details => 'รายละเอียดพื้นฐาน';

  @override
  String get product_name => 'ชื่อผลิตภัณฑ์';

  @override
  String get product_names => 'ชื่อผลิตภัณฑ์';

  @override
  String get add_basic_details_product_name_add_translation => 'เพิ่มคำแปลใหม่';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'ก่อนยืนยัน โปรดตรวจสอบให้แน่ใจว่าคุณเพิ่มคำแปลเฉพาะในกรณีที่ภาษาดังกล่าวปรากฏอยู่บนบรรจุภัณฑ์เท่านั้น';

  @override
  String get add_basic_details_product_name_open_photo => 'ดูรูปด้านหน้า';

  @override
  String get add_basic_details_product_name_take_photo => 'ถ่ายรูปด้านหน้า';

  @override
  String get add_basic_details_product_name_hint =>
      'ป้อนชื่อผลิตภัณฑ์ (เช่น นูเทลล่า)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'เปลี่ยนภาษาเริ่มต้น?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'คุณต้องการให้ตั้งค่าภาษาเริ่มต้นของผลิตภัณฑ์เป็น \'$language\' หรือไม่';
  }

  @override
  String get explanation_section_good_examples => 'ตัวอย่างที่ดี';

  @override
  String get explanation_section_bad_examples => 'ตัวอย่างที่ไม่ดี';

  @override
  String get add_basic_details_product_name_help_title =>
      'แนวปฏิบัติที่ดี: ชื่อผลิตภัณฑ์';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'ชื่อผลิตภัณฑ์คือ **ชื่อหลักที่พิมพ์อยู่บนบรรจุภัณฑ์** ซึ่งอาจเป็นเครื่องหมายการค้าจดทะเบียนก็ได้';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**หมายเหตุ:** โปรดอย่าเพิ่มคำแปล **หากไม่มีภาษาดังกล่าวระบุไว้บนบรรจุภัณฑ์**';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'เนสควิก';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'ซอสมะเขือเทศ';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'อย่าใส่ชื่อแบรนด์ลงในชื่อ';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'ซอสมะเขือเทศ **ของไฮนซ์**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'ห้ามใช้สัญลักษณ์ ® , ™ , © หรือสัญลักษณ์ที่คล้ายกัน';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'เนสควิก®';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count คำแปลอื่นๆ',
      one: '$count คำแปลอื่นๆ',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'ชื่อแบรนด์';

  @override
  String get brand_names => 'ชื่อแบรนด์';

  @override
  String get add_basic_details_brand_name_error => 'โปรดระบุชื่อแบรนด์';

  @override
  String get add_basic_details_brand_names_hint =>
      'แบรนด์สินค้าที่นำเข้า (เช่น เฟอร์เรโร)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'แนวปฏิบัติที่ดี: แบรนด์ต่างๆ';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'ระบุ **ยี่ห้อสินค้าทั้งหมด**';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'แบรนด์หลัก';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'ควรระบุ **แบรนด์หลัก** ซึ่งโดยทั่วไปจะแสดงไว้อย่างชัดเจนที่ด้านหน้าบรรจุภัณฑ์ **ก่อน**';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'แบรนด์อื่นๆ';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'เมื่อจำหน่ายโดย **บริษัทขนาดใหญ่**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** จำหน่ายโดย **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'เมื่อจำหน่ายพร้อมตราสินค้าที่ **แปลเป็นหลายภาษา**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      'บางครั้ง **Nature Valley** ก็เขียนว่า **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'นูเทลล่า';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'โอรีโอ, มอนเดเลซ';

  @override
  String get quantity => 'ปริมาณและน้ำหนัก';

  @override
  String get add_basic_details_quantity_hint =>
      'ป้อนน้ำหนัก และถ้าจำเป็น ให้ป้อนจำนวน (เช่น 4x100 กรัม)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'แนวปฏิบัติที่ดี: ปริมาณ';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'คัดลอกค่าที่ระบุไว้บนผลิตภัณฑ์ และ **อย่าลืมระบุหน่วย**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 กรัม** หรือ **230 กรัม**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (สำหรับไข่ 6 ฟอง)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 กรัม**\n(สำหรับสินค้า 3 กล่อง กล่องละ 150 กรัม)';

  @override
  String get barcode => 'บาร์โค้ด';

  @override
  String barcode_barcode(String barcode) {
    return 'บาร์โค้ด: $barcode';
  }

  @override
  String get barcode_invalid_error => 'บาร์โค้ดไม่ถูกต้อง';

  @override
  String get basic_details_add_success =>
      'รายละเอียดพื้นฐานถูกเพิ่มเรียบร้อยแล้ว';

  @override
  String get basic_details_add_error =>
      'ไม่สามารถเพิ่มรายละเอียดพื้นฐานได้ โปรดลองอีกครั้งในภายหลัง';

  @override
  String get clear_search => 'ล้างผลการค้นหา';

  @override
  String get confirm_clear =>
      'คุณกำลังจะล้างประวัติการใช้งานทั้งหมดของคุณ คุณแน่ใจหรือไม่ว่าต้องการดำเนินการต่อ?';

  @override
  String get alert_clear_selected_user_list =>
      'คุณกำลังจะล้างรายการที่เลือกไว้ในประวัติของคุณ';

  @override
  String get confirm_clear_selected_user_list =>
      'คุณแน่ใจหรือไม่ว่าต้องการดำเนินการต่อ?';

  @override
  String get alert_select_items_to_clear =>
      'โปรดเลือกรายการอย่างน้อยหนึ่งรายการเพื่อยกเลิก';

  @override
  String confirm_clear_user_list(String name) {
    return 'คุณกำลังจะล้างรายการนี้ ($name): คุณแน่ใจหรือไม่ว่าต้องการดำเนินการต่อ?';
  }

  @override
  String get confirm_delete_user_list_title => 'ลบรายการนั้นเลยไหม?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'คุณกำลังจะลบรายการ \"$name\"\nคุณแน่ใจหรือไม่ว่าต้องการดำเนินการต่อ?';
  }

  @override
  String get confirm_delete_user_list_button => 'สวัสดี​';

  @override
  String importance_label(String name, String id) {
    return '$name ความสำคัญ: $id';
  }

  @override
  String get user_list_all_title => 'รายการ';

  @override
  String get user_list_all_empty => 'สร้างรายการแรกของคุณ';

  @override
  String get product_list_select => 'เลือกรายการ';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count สินค้าหลายรายการ',
      one: 'สินค้าหนึ่งรายการ',
      zero: 'รายการว่างเปล่า',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'เพิ่มรายการ';

  @override
  String get open_food_preferences_tooltip => 'แก้ไขการตั้งค่าอาหารของคุณ';

  @override
  String get add_photo_button_label => 'เพิ่มรูปภาพ';

  @override
  String get add_packaging_photo_button_label =>
      'ถ่ายรูปบรรจุภัณฑ์/ข้อมูลการรีไซเคิลทั้งหมดไว้ด้วย';

  @override
  String get add_origin_photo_button_label =>
      'ถ่ายรูปข้อมูลแหล่งที่มาใดๆ ก็ได้';

  @override
  String get add_emb_photo_button_label =>
      'ถ่ายรูปข้อมูลรหัสตรวจสอบย้อนกลับทั้งหมดไว้';

  @override
  String get add_label_photo_button_label =>
      'ถ่ายรูปฉลากและข้อมูลรับรองต่างๆ ไว้ด้วย';

  @override
  String get choose_image_source_title => 'เลือกแหล่งที่มาของภาพ';

  @override
  String get choose_image_source_body => 'โปรดเลือกแหล่งที่มาของภาพ';

  @override
  String get gallery_source_label => 'แกลเลอรี่';

  @override
  String get gallery_source_access_denied_dialog_title => 'การเข้าถึงถูกปฏิเสธ';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'ขออภัย แอปพลิเคชันไม่สามารถเข้าถึงแกลเลอรีของคุณได้ เนื่องจากคุณได้ปฏิเสธการอนุญาตไปก่อนหน้านี้แล้ว\n\nโปรดไปที่การตั้งค่าแอปในโทรศัพท์ของคุณ การตั้งค่า -> รูปภาพ';

  @override
  String get gallery_source_access_denied_dialog_button => 'เปิดการตั้งค่า';

  @override
  String get share => 'แบ่งปัน';

  @override
  String share_product_text(String url) {
    return 'ดูรายละเอียดผลิตภัณฑ์นี้ได้ที่ Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'ดูรายละเอียดผลิตภัณฑ์นี้ได้ที่ Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'ดูรายละเอียดผลิตภัณฑ์นี้ได้ที่ Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'ดูรายละเอียดผลิตภัณฑ์นี้ได้ที่ Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'ลองดูรายการสินค้าของฉันบน Open Food Facts ได้ที่นี่: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'ถ่ายภาพ';

  @override
  String get choose_from_gallery => 'เลือกจากแกลเลอรี';

  @override
  String get image_upload_queued => 'ภาพจะถูกอัปโหลดในเบื้องหลังโดยเร็วที่สุด';

  @override
  String get add_price_queued => 'ราคาจะถูกส่งไปยังเซิร์ฟเวอร์โดยเร็วที่สุด';

  @override
  String get background_task_title_full_refresh =>
      'เริ่มทำการอัปเดตผลิตภัณฑ์ทั้งหมดที่จัดเก็บไว้ในเครื่อง';

  @override
  String get background_task_title_folksonomy =>
      'เริ่มดำเนินการเซิร์ฟเวอร์สำหรับการอัปเดต Folksonomy ที่เก็บไว้ในเครื่อง';

  @override
  String get background_task_title_top_n => 'เริ่มดาวน์โหลดผลิตภัณฑ์ยอดนิยม';

  @override
  String get expand_nutrition_facts => 'ขยายตารางข้อมูลโภชนาการ';

  @override
  String get expand_nutrition_facts_body =>
      'ควรขยายตารางข้อมูลโภชนาการให้ครบถ้วน';

  @override
  String get expand_ingredients => 'ขยายส่วนผสม';

  @override
  String get expand_ingredients_body => 'ขยายแผงส่วนผสมให้สมบูรณ์';

  @override
  String get no_internet_connection => 'ไม่มีการเชื่อมต่ออินเทอร์เน็ต';

  @override
  String get world_results_label => 'โลกทั้งใบ';

  @override
  String get world_results_action => 'ขยายขอบเขตการค้นหาของคุณไปทั่วโลก';

  @override
  String get copy_to_clipboard => 'สำเนา';

  @override
  String get paste_from_clipboard => 'วางจากคลิปบอร์ด';

  @override
  String get no_data_available_in_clipboard => 'ไม่มีข้อมูลในคลิปบอร์ดของคุณ';

  @override
  String get clipboard_barcode_copy => 'คัดลอกบาร์โค้ดไปยังคลิปบอร์ด';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'คัดลอกบาร์โค้ด $barcode ไปยังคลิปบอร์ดเรียบร้อยแล้ว!';
  }

  @override
  String get open_product_website => 'เปิดดูผลิตภัณฑ์นี้บนเว็บไซต์';

  @override
  String get language_picker_label => 'ภาษาของคุณ';

  @override
  String get country_picker_label => 'ประเทศของคุณ';

  @override
  String get currency_picker_label => 'สกุลเงินของคุณ';

  @override
  String get help_with_openfoodfacts =>
      'ขอความช่วยเหลือเกี่ยวกับ OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'ผลิตภัณฑ์จะได้รับการอัปเดตในเบื้องหลังโดยเร็วที่สุด';

  @override
  String get no_email_client_available_dialog_title => 'ห้ามใช้แอปอีเมล!';

  @override
  String get no_email_client_available_dialog_content =>
      'กรุณาส่งอีเมลถึงเราด้วยตนเองที่ mobile@openfoodfacts.org';

  @override
  String get all_images => 'รูปภาพทั้งหมด';

  @override
  String get selected_images => 'ภาพที่เลือก';

  @override
  String get product_card_remove_product_tooltip => 'นำผลิตภัณฑ์ออก';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'สแกนบาร์โค้ดใหม่แล้ว: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'ลบสินค้าทั้งหมดออกจากแถบเลื่อน';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'โปรดสแกนสินค้าอย่างน้อยสองชิ้นเพื่อเปรียบเทียบกัน';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'คลิกเพื่อเปรียบเทียบผลิตภัณฑ์ที่คุณสแกน';

  @override
  String get scan_product_loading => 'คุณได้สแกนบาร์โค้ด\nแล้ว:';

  @override
  String get scan_product_loading_initial =>
      'เรากำลังมองหาสินค้าชิ้นนี้อยู่!\nโปรดรอสักครู่…';

  @override
  String get scan_product_loading_long_request =>
      'เรายังคงตามหาสินค้านี้อยู่!\nคุณคิดว่ามันโหลดช้าไหม? เราก็เช่นกัน…';

  @override
  String get scan_product_loading_unresponsive =>
      'เรายังคงกำลังค้นหาสินค้าชิ้นนี้อยู่\nคุณต้องการเริ่มต้นการค้นหาใหม่หรือไม่?';

  @override
  String get scan_product_loading_restart_button => 'เริ่มการค้นหาใหม่';

  @override
  String get portion_calculator_description =>
      'คำนวณข้อมูลโภชนาการสำหรับปริมาณที่กำหนด';

  @override
  String get portion_calculator_hint => 'ปริมาณใน';

  @override
  String get portion_calculator_accessibility =>
      'ป้อนปริมาณเพื่อคำนวณข้อมูลโภชนาการ';

  @override
  String portion_calculator_error(int min, int max) {
    return 'โปรดป้อนปริมาณระหว่าง $min และ $max กรัม';
  }

  @override
  String get portion_calculator_computation_error =>
      'ข้อมูลไม่ครบถ้วน ไม่สามารถทำการคำนวณได้';

  @override
  String portion_calculator_result_title(int grams) {
    return 'ข้อมูลโภชนาการสำหรับ $grams กรัม (หรือมิลลิลิตร)';
  }

  @override
  String get offline_data => 'ข้อมูลออฟไลน์';

  @override
  String get ocr_image_upload_instruction =>
      'อัปโหลดรูปภาพเพื่อดึงข้อมูลที่มีอยู่ในภาพโดยอัตโนมัติ';

  @override
  String get upload_image => 'อัปโหลดรูปภาพ';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => '- ';

  @override
  String get image_download_error => 'ไม่สามารถดาวน์โหลดรูปภาพได้';

  @override
  String get image_edit_url_error =>
      'ไม่สามารถแก้ไขรูปภาพได้ เนื่องจากไม่ได้ตั้งค่า URL ของรูปภาพ';

  @override
  String get user_picture_source_remember => 'จำทางเลือกของฉันไว้';

  @override
  String get user_picture_source_ask => 'ถามทุกครั้ง';

  @override
  String get robotoff_continue => 'ดำเนินการต่อ';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count คำถาม',
      one: '',
    );
    return 'คำถามถัดไป $_temp0';
  }

  @override
  String get show_password => 'แสดงรหัสผ่าน';

  @override
  String get owner_field_info_title => 'ค่าที่ผู้ผลิตให้มา';

  @override
  String get owner_field_info_message =>
      'โลโก้นั้นใช้เพื่อเน้นข้อมูลที่ผู้ผลิตให้มา ซึ่งอาจไม่สามารถแก้ไขได้';

  @override
  String get owner_field_info_close_button => 'ปิดข้อมูลนี้';

  @override
  String get owner_field_image => 'ภาพนี้จัดทำโดยผู้ผลิต อาจไม่สามารถแก้ไขได้';

  @override
  String get edit_packagings_title => 'ส่วนประกอบบรรจุภัณฑ์';

  @override
  String get edit_packagings_element_add => 'เพิ่มส่วนประกอบบรรจุภัณฑ์';

  @override
  String get edit_packagings_completed => 'บรรจุภัณฑ์เสร็จสมบูรณ์แล้ว';

  @override
  String edit_packagings_element_title(int index) {
    return 'ส่วนประกอบบรรจุภัณฑ์ #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'จำนวนหน่วย';

  @override
  String get edit_packagings_element_hint_units =>
      'ป้อนจำนวนหน่วยบรรจุภัณฑ์ที่มีรูปร่างและวัสดุเดียวกันที่บรรจุอยู่ในผลิตภัณฑ์';

  @override
  String get edit_packagings_element_field_shape => 'รูปร่าง';

  @override
  String get edit_packagings_element_hint_shape =>
      'ระบุชื่อรูปทรงตามที่ระบุไว้ในคำแนะนำการรีไซเคิล หากมี หรือเลือกรูปทรงที่ต้องการ';

  @override
  String get edit_packagings_element_example_shape => 'ขวด';

  @override
  String get edit_packagings_element_field_material => 'วัสดุ';

  @override
  String get edit_packagings_element_hint_material =>
      'หากสามารถระบุวัสดุได้ ให้ป้อนรหัสวัสดุที่เฉพาะเจาะจง (โดยปกติจะมีรหัสวัสดุอยู่ภายในรูปสามเหลี่ยมบนชิ้นส่วนบรรจุภัณฑ์) หรือหากไม่แน่ใจ ให้ระบุวัสดุทั่วไป (เช่น พลาสติกหรือโลหะ)';

  @override
  String get edit_packagings_element_example_material => 'กระจก';

  @override
  String get edit_packagings_element_field_recycling => 'คำแนะนำในการรีไซเคิล';

  @override
  String get edit_packagings_element_hint_recycling =>
      'ระบุคำแนะนำในการรีไซเคิลเฉพาะในกรณีที่ระบุไว้บนผลิตภัณฑ์เท่านั้น';

  @override
  String get edit_packagings_element_example_recycling => 'รีไซเคิล';

  @override
  String get edit_packagings_element_field_quantity =>
      'ปริมาณสุทธิของผลิตภัณฑ์ต่อหน่วย';

  @override
  String get edit_packagings_element_hint_quantity =>
      'ป้อนน้ำหนักสุทธิหรือปริมาตรสุทธิ และระบุหน่วย (เช่น กรัม หรือ มิลลิลิตร)';

  @override
  String get edit_packagings_element_field_weight =>
      'น้ำหนักของหน่วยเปล่าหนึ่งหน่วย (กรัม)';

  @override
  String get edit_packagings_element_hint_weight =>
      'นำเศษอาหารที่เหลือออกให้หมด และล้างและเช็ดบรรจุภัณฑ์ให้แห้งก่อนชั่งน้ำหนัก ถ้าเป็นไปได้ ให้ใช้เครื่องชั่งที่มีความแม่นยำ 0.1 กรัม หรือ 0.01 กรัม';

  @override
  String get background_task_title => 'เงินบริจาคที่รอดำเนินการ';

  @override
  String get background_task_subtitle =>
      'ข้อมูลที่คุณส่งเข้ามาจะถูกบันทึกไปยังเซิร์ฟเวอร์ของเราโดยอัตโนมัติ แต่อาจไม่ใช่แบบเรียลไทม์เสมอไป';

  @override
  String get background_task_list_empty => 'ไม่มีงานเบื้องหลังที่ค้างอยู่';

  @override
  String get background_task_error_server_time_out => 'เซิร์ฟเวอร์หมดเวลา';

  @override
  String get background_task_error_no_internet =>
      'เกิดข้อผิดพลาดในการเชื่อมต่ออินเทอร์เน็ต โปรดลองใหม่อีกครั้ง';

  @override
  String get background_task_operation_unknown =>
      'ประเภทการดำเนินการที่ไม่รู้จัก';

  @override
  String get background_task_operation_details => 'การเปลี่ยนแปลงโดยละเอียด';

  @override
  String get background_task_operation_image => 'อัปโหลดรูปภาพ';

  @override
  String get background_task_operation_refresh =>
      'การรีเฟรชล่าช้าหลังจากอัปโหลดรูปภาพ';

  @override
  String get background_task_run_started => 'เริ่ม';

  @override
  String get background_task_run_not_started => 'ยังไม่เริ่ม';

  @override
  String get background_task_run_to_be_deleted => 'จะถูกลบ';

  @override
  String get background_task_question_stop =>
      'คุณต้องการหยุดการทำงานนั้นโดยเร็วที่สุดหรือไม่?';

  @override
  String get feed_back => 'ข้อเสนอแนะ';

  @override
  String get undo => 'เลิกทำ';

  @override
  String get copy_email_to_clip_board => 'คัดลอกอีเมลไปยังคลิปบอร์ด';

  @override
  String get please_send_us_an_email_to => 'โปรดส่งอีเมลถึงเราด้วยตนเองที่';

  @override
  String get email_copied_to_clip_board =>
      'คัดลอกอีเมลไปยังคลิปบอร์ดเรียบร้อยแล้ว!';

  @override
  String get select_accent_color => 'เลือกสีเน้น';

  @override
  String get theme_amoled => 'อาซูโม่';

  @override
  String get color_blue => 'สีฟ้า';

  @override
  String get color_cyan => 'สีฟ้าอมเขียว';

  @override
  String get color_green => 'สีเขียว';

  @override
  String get color_light_brown => 'ค่าเริ่มต้น';

  @override
  String get color_magenta => 'แมเจนต้า';

  @override
  String get color_orange => 'ส้ม';

  @override
  String get color_pink => 'สีชมพู';

  @override
  String get color_red => 'สีแดง';

  @override
  String get color_rust => 'สนิม';

  @override
  String get color_teal => 'สีเขียวอมฟ้า';

  @override
  String get text_contrast_mode => 'ความคมชัดของข้อความ';

  @override
  String get contrast_high => 'สูง';

  @override
  String get contrast_medium => 'ปานกลาง';

  @override
  String get contrast_low => 'ต่ำ';

  @override
  String get product_refresher_internet_not_found => 'ไม่พบสินค้า!';

  @override
  String get product_refresher_internet_not_connected =>
      'คุณไม่ได้เชื่อมต่ออินเทอร์เน็ต!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'เซิร์ฟเวอร์ล่ม ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'ข้อผิดพลาดของเซิร์ฟเวอร์ ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'ไม่พบสินค้า!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'สินค้าที่มีบาร์โค้ดต่อไปนี้ไม่มีอยู่ในฐานข้อมูลของเรา: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'ไม่มีการเชื่อมต่ออินเทอร์เน็ต!';

  @override
  String get product_loader_network_error_message =>
      'โปรดตรวจสอบว่าสมาร์ทโฟนของคุณเชื่อมต่อกับเครือข่าย Wi-Fi หรือเปิดใช้งานข้อมูลมือถืออยู่';

  @override
  String get page_not_found_title => 'ไม่พบหน้านี้!';

  @override
  String get page_not_found_button => 'กลับไปที่หน้าแรก';

  @override
  String get download_data => 'ดาวน์โหลดข้อมูล';

  @override
  String get download_top_products =>
      'ดาวน์โหลดรายชื่อ 1,000 ผลิตภัณฑ์ยอดนิยมในประเทศของคุณเพื่อการสแกนทันที';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count',
    );
    return 'ดาวน์โหลดผลิตภัณฑ์ยอดนิยม $_temp0 ในประเทศของคุณเพื่อการสแกนทันที';
  }

  @override
  String get download_in_progress =>
      'กำลังดาวน์โหลดข้อมูล\nอาจใช้เวลานานสักครู่';

  @override
  String downloaded_products(int num) {
    return 'เพิ่มสินค้า $num รายการ';
  }

  @override
  String get update_offline_data => 'อัปเดตข้อมูลผลิตภัณฑ์แบบออฟไลน์';

  @override
  String get update_local_database_sub =>
      'อัปเดตฐานข้อมูลผลิตภัณฑ์ในท้องถิ่นด้วยข้อมูลล่าสุดจาก Open Food Facts';

  @override
  String get clear_local_database => 'ล้างข้อมูลผลิตภัณฑ์แบบออฟไลน์';

  @override
  String get clear_local_database_sub =>
      'ล้างข้อมูลผลิตภัณฑ์ในเครื่องทั้งหมดออกจากแอปของคุณเพื่อเพิ่มพื้นที่ว่าง';

  @override
  String deleted_products(int num) {
    return '$num สินค้าถูกลบแล้ว';
  }

  @override
  String get loading => 'Loading…';

  @override
  String get know_more => 'เรียนรู้เพิ่มเติม';

  @override
  String get offline_data_desc =>
      'คลิกที่นี่เพื่อดูข้อมูลเพิ่มเติมเกี่ยวกับข้อมูลออฟไลน์';

  @override
  String get offline_product_data_title => 'ข้อมูลผลิตภัณฑ์แบบออฟไลน์';

  @override
  String available_for_download(int num) {
    return '$num สินค้าพร้อมสำหรับการสแกนทันที';
  }

  @override
  String get country_selector_title => 'เลือกประเทศของคุณ:';

  @override
  String get currency_selector_title => 'เลือกสกุลเงินของคุณ:';

  @override
  String get language_selector_title => 'เลือกภาษาของคุณ:';

  @override
  String get language_selector_section_selected => 'ภาษาที่เลือก';

  @override
  String get language_selector_section_frequently_used => 'ใช้บ่อย';

  @override
  String get action_delete_list => 'ลบ';

  @override
  String get action_change_list => 'เปลี่ยนรายการปัจจุบัน';

  @override
  String get product_list_create => 'สร้าง';

  @override
  String get product_list_create_tooltip => 'สร้างรายการใหม่';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (New calculation)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (New calculation)';

  @override
  String get nutriscore_unknown => 'ไม่ทราบค่า Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unknown Nutri-Score (New calculation)';

  @override
  String get nutriscore_not_applicable => 'ไม่สามารถใช้ Nutri-Score ได้';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'ไม่สามารถใช้ Nutri-Score ได้ (การคำนวณใหม่)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Green-Score เอ';

  @override
  String get environmental_score_b_new => 'Green-Score บี';

  @override
  String get environmental_score_c_new => 'Green-Score ซี';

  @override
  String get environmental_score_d_new => 'Green-Score ดี';

  @override
  String get environmental_score_e_new => 'Green-Score อี';

  @override
  String get environmental_score_unknown_new => 'Green-Scoreที่ไม่รู้จัก';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Scoreไม่สามารถใช้งานได้';

  @override
  String get nova_group_generic_new => 'อาหารแปรรูปขั้นสูง - กลุ่ม NOVA';

  @override
  String get nova_group_1 => 'NOVA Group 1';

  @override
  String get nova_group_2 => 'NOVA Group 2';

  @override
  String get nova_group_3 => 'NOVA Group 3';

  @override
  String get nova_group_4 => 'NOVA Group 4';

  @override
  String get nova_group_unknown => 'กลุ่ม NOVA ที่ไม่เปิดเผยตัวตน';

  @override
  String get nutrition_facts => 'ระดับสารอาหาร';

  @override
  String get faq_title_partners => 'พันธมิตรและผู้อุปถัมภ์ขององค์กรพัฒนาเอกชน';

  @override
  String get faq_title_vision =>
      'วิสัยทัศน์ พันธกิจ ค่านิยม และโครงการของ Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'ติดตั้ง Open Beauty Facts เพื่อสร้างฐานข้อมูลเครื่องสำอาง';

  @override
  String get faq_title_install_pet =>
      'ติดตั้ง Open Pet Food Facts เพื่อสร้างฐานข้อมูลอาหารสัตว์เลี้ยง';

  @override
  String get faq_title_install_product =>
      'ติดตั้ง Open Products Facts เพื่อสร้างฐานข้อมูลผลิตภัณฑ์เพื่อยืดอายุการใช้งานของวัตถุ';

  @override
  String get faq_nutriscore_nutriscore =>
      'วิธีการคำนวณคะแนนโภชนาการแบบใหม่: มีอะไรใหม่บ้าง?';

  @override
  String get contact_title_pro_page =>
      'มืออาชีพ? นำเข้าผลิตภัณฑ์ของคุณใน Open Food Facts';

  @override
  String get contact_title_pro_email => 'ติดต่อผู้ผลิต';

  @override
  String get contact_title_press_page => 'หน้าข่าวประชาสัมพันธ์';

  @override
  String get contact_title_press_email => 'ติดต่อสื่อมวลชน';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'สมัครรับข้อมูลปฏิทินกิจกรรมชุมชนของเรา';

  @override
  String get hunger_games_loading_line1 => 'โปรดรอสักครู่…';

  @override
  String get hunger_games_loading_line2 => 'เรากำลังดาวน์โหลดคำถามอยู่!';

  @override
  String get hunger_games_error_label =>
      'อ๊าก! เกิดข้อผิดพลาดบางอย่าง… และเราไม่สามารถโหลดคำถามได้';

  @override
  String get hunger_games_error_retry_button => 'ลองใหม่อีกครั้ง!';

  @override
  String get reorder_attribute_action => 'จัดเรียงคุณลักษณะใหม่';

  @override
  String get link_cant_be_opened =>
      'ไม่สามารถเปิดลิงก์นี้บนอุปกรณ์ของคุณได้ โปรดตรวจสอบว่าคุณได้ติดตั้งเบราว์เซอร์แล้ว';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'รายละเอียดสำหรับ $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'รายละเอียดสำหรับ $pageName กับ $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'แบ่งปัน';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'อธิบายเพิ่มเติมเกี่ยวกับ Nutri-Score';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'ประเทศที่มีการนำ Nutri-Score แบบใหม่ไปใช้';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'ระบบการให้คะแนนโภชนาการ (Nutri-Score) ถูกนำมาใช้ใน 7 ประเทศ ได้แก่ ฝรั่งเศส เยอรมนี เบลเยียม สเปน ลักเซมเบิร์ก เนเธอร์แลนด์ และสวิตเซอร์แลนด์';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'ผู้ผลิตมีเวลาอย่างมากที่สุด **2 ปี** นับจากวันที่ลงนามในพระราชกฤษฎีกา **เพื่อเปลี่ยน** วิธีการคำนวณแบบเก่าเป็นวิธีการคำนวณแบบใหม่';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Green Score คืออะไร?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score เป็นโลโก้ที่มุ่งหวังที่จะแจ้งให้คุณทราบเกี่ยวกับ **ผลกระทบต่อสิ่งแวดล้อมของอาหาร**';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'รหัสสีจะแตกต่างกันไปตั้งแต่สีเขียวเข้ม (**A+**) สำหรับผลิตภัณฑ์ **ที่มีผลกระทบน้อยที่สุด** ไปจนถึงสีแดงเข้ม (**F**) สำหรับผลิตภัณฑ์ **ที่มีผลกระทบมากที่สุด**';

  @override
  String get guide_greenscore_logos_caption => 'โลโก้ Green-Score';

  @override
  String get guide_greenscore_lca_title => 'แกนหลัก: การประเมินวงจรชีวิต (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'การประเมินหมวดหมู่อาหารอย่างเป็นวิทยาศาสตร์';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'สำหรับหมวดหมู่ผลิตภัณฑ์แต่ละประเภท จะมีการจัดทำคะแนน **มาตรฐาน** โดยใช้ข้อมูลจากฐานข้อมูลสิ่งแวดล้อมของ Agribalyse (ออกแบบโดย ADEME และ INRAE)';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**การวิเคราะห์วงจรชีวิต** เป็นวิธีการประเมินมาตรฐานสำหรับการดำเนินการประเมินสิ่งแวดล้อมแบบหลายขั้นตอนและหลายเกณฑ์';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**วัดได้ :**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 ขั้นตอนการผลิต';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'บรรจุภัณฑ์';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title =>
      'ตัวชี้วัดผลกระทบสิ่งแวดล้อม 14 รายการ';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'การเปลี่ยนแปลงสภาพภูมิอากาศ/ปริมาณการปล่อยคาร์บอน';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'การทำลายชั้นโอโซน';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'รังสีไอออไนซ์';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'ที่ดิน';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'การใช้น้ำและพลังงาน';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'มลพิษทางอากาศ';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'น้ำทะเลและน้ำจืด (อนุภาค กรด ยูโทรฟิเคชั่น)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'การหมดสิ้นของทรัพยากร';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'โบนัสและค่าปรับ';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'เพื่อเป็นการให้รางวัลแก่ผลิตภัณฑ์ที่ดีกว่าในแต่ละหมวดหมู่ เราจึงใช้ **โบนัสและบทลงโทษโดยพิจารณาจากเกณฑ์หลายประการ**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'จะมีการมอบ **โบนัส** ให้แก่ผลิตภัณฑ์ที่มี **ฉลากอย่างเป็นทางการ ฉลาก หรือใบรับรองที่รับประกันประโยชน์ด้านสิ่งแวดล้อม** (เช่น ออร์แกนิก การค้าที่เป็นธรรม HVE Label Rouge Bleu Blanc Cœur MSC/ASC)';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'แหล่งที่มาของวัตถุดิบ';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'จะมีการให้ **โบนัส** โดยพิจารณาจากแหล่งที่มาของส่วนผสม โบนัสนี้จะคำนึงถึง **ผลกระทบจากการขนส่ง** และ **นโยบายด้านสิ่งแวดล้อม** ของประเทศผู้ผลิตแต่ละรายด้วย';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'ผลิตภัณฑ์ที่มีส่วนผสมที่ส่งผลกระทบเชิงลบอย่างมากต่อความหลากหลายทางชีวภาพและระบบนิเวศ เช่น น้ำมันปาล์ม ซึ่งการผลิตน้ำมันปาล์มเป็นสาเหตุของการทำลายป่าอย่างมหาศาล จะถูกลงโทษ **ปรับ**';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'บรรจุภัณฑ์';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'ค่าปรับจะถูกคำนวณโดยคำนึงถึงความยั่งยืนของบรรจุภัณฑ์ (การใช้วัตถุดิบรีไซเคิลและความสามารถในการรีไซเคิล) และการบรรจุสินค้าเกินความจำเป็น';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'ในการคำนวณคะแนนสีเขียวอย่างแม่นยำ จำเป็นต้องมี **ข้อมูลที่ไม่ได้ระบุไว้บนบรรจุภัณฑ์อย่างชัดเจน** (เช่น แหล่งที่มาและเปอร์เซ็นต์ที่แน่นอนของส่วนผสมแต่ละชนิด) หรือข้อมูลที่หาได้ยากในรูปแบบที่ใช้งานได้ (เช่น รายชื่อส่วนประกอบทั้งหมดของบรรจุภัณฑ์พร้อมประเภทพลาสติกที่ใช้โดยละเอียด)';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**ในกรณีที่ยังไม่มีข้อมูลนี้ จะใช้ค่าเฉลี่ย** แต่ขณะนี้เราขอความช่วยเหลือจากทุกท่านในการรวบรวมข้อมูลนี้ ซึ่งจะเป็นประโยชน์อย่างมากต่อคะแนนสีเขียว (Green-Score) และยังใช้ประโยชน์ได้อีกหลายด้าน';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'ประชาชนสามารถช่วยเหลือได้อย่างไร?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'ประชาชนทุกคนสามารถช่วยเราในการรวบรวมและจัดโครงสร้างข้อมูลที่มีอยู่บนผลิตภัณฑ์ หรือที่สามารถอนุมานได้จากผลิตภัณฑ์เหล่านั้น เช่น ข้อมูลเกี่ยวกับ **บรรจุภัณฑ์**: \"ภารกิจบรรจุภัณฑ์\": การสำรวจบรรจุภัณฑ์อาหารทุกชนิดในวงกว้างโดยความร่วมมือ (เป็นภาษาฝรั่งเศส)';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'ผู้ผลิตสามารถช่วยได้อย่างไร';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'ผู้ผลิตสามารถส่งข้อมูลของตนมาให้เราโดยตรงผ่านแพลตฟอร์มฟรีสำหรับผู้ผลิตของเรา';

  @override
  String get guide_greenscore_better_product_title =>
      'ผลิตภัณฑ์ใดดีต่อโลกมากกว่ากัน?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'มันอาจจะยากที่จะบอก';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'การเลือกอาหารที่ยั่งยืนถือเป็นหนึ่งในสิ่งที่ทรงพลังที่สุดที่เราสามารถทำได้เพื่อสภาพภูมิอากาศ เนื่องจาก **ระบบอาหารทั่วโลกของเรามีส่วนรับผิดชอบต่อการปล่อยก๊าซเรือนกระจกมากกว่าหนึ่งในสี่**\n(ที่มา: Poore & Nemecek, Science, 2018)';

  @override
  String get guide_greenscore_better_product_arg2_title => 'คุณมีอำนาจ!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'ข่าวดีก็คือ นี่เป็นหนทางอันทรงพลังในการสร้างการเปลี่ยนแปลง\n**เราแต่ละคนรับประทานอาหารประมาณ 1,000 มื้อต่อปี** นั่นคือโอกาส 1,000 ครั้งในการเลือก **อนาคตที่ดีกว่าให้กับโลก**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'ช่วยให้มีความรับผิดชอบและตัดสินใจ';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'การเลือกอาหารที่ยั่งยืนอาจดูซับซ้อน ฉลากอาจสร้างความสับสนและมักขาดข้อมูล Green-Score ออกแบบมาเพื่อให้ใช้งานง่าย ช่วยให้คุณได้รับการจัดอันดับด้านสิ่งแวดล้อมที่ **ชัดเจน** **อิงวิทยาศาสตร์** และ **โปร่งใส** สำหรับผลิตภัณฑ์อาหาร ตรงจุดที่คุณต้องการ: ขณะที่คุณกำลังเลือกซื้อ';

  @override
  String get guide_greenscore_better_product_arg4_title => 'ความโปร่งใส';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'ต่างจากฉลากที่เป็นกรรมสิทธิ์ การคำนวณ Green-Score นั้น **เปิดกว้างอย่างสมบูรณ์** และใครๆ ก็สามารถ **ตรวจสอบได้**';

  @override
  String get guide_nova_title => 'อาหารที่ผ่านการแปรรูประดับสูง';

  @override
  String get guide_nova_what_is_nova_title => 'Ultra Processing คืออะไร?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'กลุ่ม NOVA จะแจ้งให้คุณทราบเกี่ยวกับ **ระดับการแปรรูปอาหาร**';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'การจำแนกประเภท NOVA ช่วยให้สามารถจำแนกอาหารออกเป็น **4 กลุ่ม** ตาม **ระดับการแปรรูปทางอุตสาหกรรม** (อาหารที่ผ่านการแปรรูปน้อยที่สุดหรือไม่ได้แปรรูป ส่วนผสมในการปรุงอาหาร อาหารแปรรูป อาหารแปรรูปอย่างมาก)';

  @override
  String get guide_nova_logos_caption => 'โลโก้ NOVA';

  @override
  String get guide_nova_groups_title => 'กลุ่ม NOVA ทั้ง 4 กลุ่ม';

  @override
  String get guide_nova_groups_intro =>
      'มีกลุ่ม NOVA อยู่ 4 กลุ่ม โดยกลุ่มที่เป็นปัญหาคือกลุ่มที่ 4 ซึ่งเป็นอาหารแปรรูปขั้นสูง';

  @override
  String get guide_nova_groups_arg1_title =>
      'อาหารที่ผ่านการแปรรูปน้อยที่สุดหรือไม่ได้แปรรูป';

  @override
  String get guide_nova_groups_arg1_text =>
      'อาหารที่ไม่ผ่านการแปรรูป (หรืออาหารธรรมชาติ) คือ **ส่วนที่กินได้ของพืช** (เมล็ด ผลไม้ ใบ ลำต้น ราก) **หรือสัตว์** (กล้ามเนื้อ เครื่องใน ไข่ นม) รวมถึงเชื้อรา สาหร่าย และน้ำ หลังจากแยกออกจากธรรมชาติแล้ว';

  @override
  String get guide_nova_groups_arg2_title => 'เครื่องปรุงอาหารที่ผ่านการแปรรูป';

  @override
  String get guide_nova_groups_arg2_text =>
      'ส่วนผสมอาหารแปรรูป เช่น **น้ำมัน เนย น้ำตาล และเกลือ** เป็นสารที่ได้มาจากอาหารกลุ่มที่ 1 หรือจากธรรมชาติผ่านกระบวนการต่างๆ เช่น การบีบอัด การกลั่น การบด การโม่ และการอบแห้ง';

  @override
  String get guide_nova_groups_arg3_title => 'อาหารแปรรูป';

  @override
  String get guide_nova_groups_arg3_text =>
      'อาหารแปรรูป เช่น ผักบรรจุขวด ปลาบรรจุกระป๋อง ผลไม้ในน้ำเชื่อม ชีส และขนมปังอบสดใหม่ **ส่วนใหญ่ทำโดยการเติมเกลือ น้ำมัน น้ำตาล หรือสารอื่นๆ จากกลุ่มที่ 2 ลงในกลุ่มที่ 1** กระบวนการแปรรูปนั้นรวมถึงวิธีการถนอมอาหารหรือการปรุงอาหารต่างๆ และในกรณีของขนมปังและชีส จะมีการหมักโดยไม่ใช้แอลกอฮอล์ อาหารแปรรูปส่วนใหญ่มีส่วนผสมสองหรือสามอย่าง และสามารถจำแนกได้ว่าเป็นอาหารกลุ่มที่ 1 ที่ได้รับการดัดแปลง สามารถรับประทานได้โดยตรง หรือที่พบได้บ่อยกว่าคือรับประทานร่วมกับอาหารอื่นๆ';

  @override
  String get guide_nova_groups_arg4_title => 'อาหารที่ผ่านการแปรรูประดับสูง';

  @override
  String get guide_nova_groups_arg4_text =>
      'อาหารแปรรูปขั้นสูง เช่น เครื่องดื่มอัดลม ขนมขบเคี้ยวบรรจุห่อทั้งแบบหวานและเค็ม ผลิตภัณฑ์เนื้อสัตว์แปรรูป และอาหารแช่แข็งสำเร็จรูป **ไม่ใช่เพียงแค่อาหารที่ผ่านการดัดแปลง แต่เป็นสูตรที่ทำขึ้นจากสารที่ได้จากอาหารและสารเติมแต่งเป็นส่วนใหญ่หรือทั้งหมด** โดยมีส่วนประกอบของอาหารกลุ่มที่ 1 น้อยมากหรือไม่มีเลย ส่วนประกอบในสูตรเหล่านี้มักรวมถึงส่วนประกอบที่พบในอาหารแปรรูปทั่วไป เช่น น้ำตาล น้ำมัน ไขมัน หรือเกลือ อย่างไรก็ตาม ผลิตภัณฑ์แปรรูปขั้นสูงยังประกอบด้วยแหล่งพลังงานและสารอาหารอื่นๆ ที่โดยปกติไม่ได้ใช้ในการปรุงอาหาร บางส่วนสกัดโดยตรงจากอาหาร เช่น เคซีน แลคโตส เวย์ และกลูเตน';

  @override
  String get guide_nova_explanations_title => 'ปัญหาของการประมวลผลขั้นสูง';

  @override
  String get guide_nova_explanations_arg1_title =>
      'การแปรรูปส่วนผสมอาหารแบบสุดขั้ว';

  @override
  String get guide_nova_explanations_arg1_text =>
      'หลายชนิด **ได้มาจากการแปรรูปส่วนประกอบอาหารเพิ่มเติม** เช่น น้ำมันที่ผ่านกระบวนการไฮโดรจีเนชั่นหรืออินเตอร์เอสเตอริฟิเคชั่น โปรตีนไฮโดรไลซ์ โปรตีนถั่วเหลืองไอโซเลต มอลโทเดกซ์ทริน น้ำตาลอินเวอร์ต และน้ำเชื่อมข้าวโพดฟรุกโตสสูง';

  @override
  String get guide_nova_explanations_arg2_title =>
      'สารเติมแต่งที่เหนือกว่าความปลอดภัยด้านอาหารอย่างแท้จริง';

  @override
  String get guide_nova_explanations_arg2_text =>
      'สารเติมแต่งในอาหารแปรรูปขั้นสูงบางชนิดก็ใช้ในอาหารแปรรูปทั่วไปเช่นกัน เช่น สารกันเสีย สารต้านอนุมูลอิสระ และสารคงตัว ส่วนสารเติมแต่งที่พบเฉพาะในผลิตภัณฑ์แปรรูปขั้นสูง ได้แก่ สารที่ใช้ **เพื่อเลียนแบบหรือเพิ่มคุณภาพทางประสาทสัมผัสของอาหาร หรือเพื่อปกปิดลักษณะที่ไม่พึงประสงค์ของผลิตภัณฑ์ขั้นสุดท้าย** สารเติมแต่งเหล่านี้ได้แก่ สีย้อมและสีอื่นๆ สารคงสี กลิ่นรส สารเพิ่มกลิ่นรส สารให้ความหวานที่ไม่ใช่น้ำตาล และสารช่วยในการแปรรูป เช่น สารทำให้เกิดฟอง สารทำให้แข็งตัว สารเพิ่มปริมาณและสารป้องกันการเกิดฟอง สารลดฟอง สารป้องกันการจับตัวเป็นก้อนและสารเคลือบเงา สารทำให้เกิดอิมัลชัน สารคีเลต และสารให้ความชุ่มชื้น';

  @override
  String get guide_nova_explanations_arg3_title =>
      'การประมวลผลที่คุณไม่สามารถทำที่บ้านได้';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**มีการใช้กระบวนการหลายขั้นตอน** เพื่อรวมส่วนผสมจำนวนมากเข้าด้วยกันและสร้างผลิตภัณฑ์ขั้นสุดท้าย (จึงเรียกว่า \'ผลิตภัณฑ์แปรรูปขั้นสูง\') กระบวนการเหล่านี้รวมถึงหลายกระบวนการที่ **ไม่มีกระบวนการใดในประเทศที่เทียบเท่าได้** เช่น การเติมไฮโดรเจนและการไฮโดรไลซิส การอัดรีดและการขึ้นรูป และการเตรียมการก่อนทอด';

  @override
  String get guide_nova_explanations_arg4_title =>
      'ด้านล่าเหยื่อและการเงินของการประมวลผลขั้นสูง';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**เป้าหมายโดยรวมของการแปรรูปขั้นสูงคือการสร้างผลิตภัณฑ์อาหารที่มีตราสินค้า** **สะดวก** (เก็บรักษาได้นาน พร้อมรับประทาน) **น่าดึงดูด** (รสชาติอร่อยมาก) และ **ทำกำไรได้สูง** (วัตถุดิบราคาถูก) ซึ่งออกแบบมาเพื่อแทนที่กลุ่มอาหารอื่นๆ ทั้งหมด ผลิตภัณฑ์อาหารแปรรูปขั้นสูงมักบรรจุภัณฑ์สวยงามและทำการตลาดอย่างเข้มข้น';

  @override
  String get guide_nova_explanations_arg5_title => 'อันตรายต่อสุขภาพ';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'ประเทศต่างๆ แนะนำให้จำกัดจำนวน';

  @override
  String get guide_nova_explanations_arg6_text =>
      'บางประเทศใช้กลุ่ม NOVA สำหรับแนวทางหรือเป้าหมายด้านโภชนาการของตน ตัวอย่างเช่น:\n\n- **🇧🇷 บราซิล** มีแนวทางด้านโภชนาการที่ **แนะนำให้จำกัดการบริโภค** อาหารแปรรูปและหลีกเลี่ยงอาหารแปรรูปขั้นสูง\n\n- **🇫🇷 ฝรั่งเศส** มีเป้าหมายนโยบายด้านโภชนาการสาธารณะสำหรับปี 2018-2022 ที่ **ลดการบริโภคอาหารแปรรูปขั้นสูงกลุ่ม 4 ลง 20%**';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/โนวา';

  @override
  String get guide_open_food_facts_title => 'ยินดีต้อนรับสู่ Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Open Food Facts คืออะไร?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts คือฐานข้อมูลผลิตภัณฑ์อาหารจากทั่วโลกที่สร้างขึ้นโดยความร่วมมือ เปิดให้ใช้งานฟรี และเปิดเผยต่อสาธารณะ';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'เราเชื่อว่าทุกคนควรเข้าถึงข้อมูลเกี่ยวกับสิ่งที่พวกเขากินได้ การรวบรวมข้อมูลเกี่ยวกับส่วนผสม สารก่อภูมิแพ้ คุณค่าทางโภชนาการ และอื่นๆ **ช่วยให้ผู้บริโภคสามารถตัดสินใจได้อย่างชาญฉลาด** และผลักดันอุตสาหกรรมอาหาร **ไปสู่ความโปร่งใสที่มากขึ้น**';

  @override
  String get guide_open_food_facts_features_title =>
      'คุณสมบัติของเว็บไซต์ Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'รับการแจ้งเตือนสำหรับส่วนผสมที่ไม่ต้องการ';

  @override
  String get guide_open_food_facts_tips_title => 'เคล็ดลับการถ่ายภาพให้สวยงาม';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'ข้อห้าม';

  @override
  String get guide_open_food_facts_tips_arg1_text1 => 'หลีกเลี่ยงเงาและแสงจ้า';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'ข้อความต้องไม่เบลอหรือไม่ชัด';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'อย่าตัดส่วนใดส่วนหนึ่งของข้อความออก';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'หลีกเลี่ยงพื้นหลังที่มีรายละเอียดเยอะเกินไป';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'สิ่งที่ควรทำ';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'ใช้แสงสว่างที่ดีและสม่ำเสมอ';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'ตรวจสอบให้แน่ใจว่าตัวอักษรคมชัดและอ่านง่าย';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'บันทึกรายการส่วนผสมทั้งหมด';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'วางผลิตภัณฑ์บนพื้นผิวเรียบ';

  @override
  String get guide_open_food_facts_scores_title =>
      'ช่วยเราสร้าง \"วิกิพีเดียแห่งอาหาร\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'คะแนนด้านคุณภาพทางโภชนาการ';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'คะแนนที่ควรหลีกเลี่ยงอาหารแปรรูปขั้นสูง';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'คะแนนสำหรับโลกใบนี้';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-th.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'ยินดีต้อนรับสู่ Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Open Pet Food Facts คืออะไร?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts ขยายภารกิจของเราไปสู่เพื่อนขนปุยของเรา! นี่คือ **ฐานข้อมูลผลิตภัณฑ์อาหารสัตว์เลี้ยงสำหรับแมว สุนัข และสัตว์เลี้ยงอื่นๆ**';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'เราเก็บรวบรวมข้อมูลเกี่ยวกับ **ส่วนผสม**, **การวิเคราะห์คุณค่าทางโภชนาการ** และแนวทางการให้อาหาร เพื่อช่วยให้เจ้าของสัตว์เลี้ยงเลือกอาหารที่ดีที่สุดสำหรับความต้องการของสัตว์เลี้ยงของตน';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'คุณสมบัติของข้อมูลอาหารสัตว์เลี้ยงแบบเปิดเผย';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'รับการแจ้งเตือนสำหรับส่วนผสมที่ไม่ต้องการ';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'สัตว์เลี้ยงของคุณแพ้ส่วนผสมใดบ้างหรือไม่? คุณสามารถตั้งรายการส่วนผสมเครื่องสำอางที่ควรหลีกเลี่ยงได้โดยตรงในแอป!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'เคล็ดลับการถ่ายภาพให้สวยงาม';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'ข้อห้าม';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'หลีกเลี่ยงเงาและแสงจ้า';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'ข้อความต้องไม่เบลอหรือไม่ชัด';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'อย่าตัดส่วนใดส่วนหนึ่งของข้อความออก';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'หลีกเลี่ยงพื้นหลังที่มีรายละเอียดเยอะเกินไป';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'สิ่งที่ควรทำ';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'ใช้แสงสว่างที่ดีและสม่ำเสมอ';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'ตรวจสอบให้แน่ใจว่าตัวอักษรคมชัดและอ่านง่าย';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'บันทึกรายการส่วนผสมทั้งหมด';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'วางผลิตภัณฑ์บนพื้นผิวเรียบ';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'หมายเหตุเกี่ยวกับการให้คะแนน';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'การพัฒนาระบบการให้คะแนนสำหรับอาหารสัตว์เลี้ยง **ยังไม่ใช่เรื่องสำคัญในขณะนี้** เนื่องจากวิธีการนั้นซับซ้อน เพราะความต้องการทางโภชนาการแตกต่างกันอย่างมากตามสายพันธุ์ อายุ และสภาพสุขภาพ เรายังไม่พบทีมวิจัยทางวิทยาศาสตร์อิสระใด ๆ ที่สามารถพัฒนาระบบการให้คะแนนดังกล่าวได้';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-th.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'ยินดีต้อนรับสู่ Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Open Beauty Facts คืออะไร?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts คือฐานข้อมูลแบบร่วมมือกันของ **ผลิตภัณฑ์เครื่องสำอาง**';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'เป้าหมายของเราคือการถอดรหัสรายการส่วนผสมเพื่อช่วยให้คุณ **เข้าใจว่ามีอะไรอยู่ในผลิตภัณฑ์ดูแลส่วนบุคคลของคุณบ้าง** ตั้งแต่ครีมบำรุงผิวไปจนถึงเครื่องสำอาง เราเก็บรวบรวมข้อมูลเกี่ยวกับส่วนผสม สารก่อภูมิแพ้ และบรรจุภัณฑ์ เพื่อส่งเสริมความโปร่งใสในอุตสาหกรรมเครื่องสำอาง';

  @override
  String get guide_open_beauty_facts_features_title =>
      'คุณสมบัติของข้อมูลความงามแบบเปิดเผย';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'รับการแจ้งเตือนสำหรับส่วนผสมที่ไม่ต้องการ';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'คุณแพ้ส่วนผสมใดบ้างหรือไม่? ต้องการหลีกเลี่ยงสารที่ก่อให้เกิดสิวอุดตันหรือไม่? ต้องการหลีกเลี่ยงส่วนประกอบที่เป็นที่ถกเถียงหรือไม่? คุณสามารถตั้งค่ารายการส่วนผสมเครื่องสำอางที่ต้องการหลีกเลี่ยงได้โดยตรงในแอป!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'เคล็ดลับการถ่ายภาพให้สวยงาม';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'ข้อห้าม';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'หลีกเลี่ยงเงาและแสงจ้า';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'ข้อความต้องไม่เบลอหรือไม่ชัด';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'อย่าตัดส่วนใดส่วนหนึ่งของข้อความออก';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'หลีกเลี่ยงพื้นหลังที่มีรายละเอียดเยอะเกินไป';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'สิ่งที่ควรทำ';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'ใช้แสงสว่างที่ดีและสม่ำเสมอ';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'ตรวจสอบให้แน่ใจว่าตัวอักษรคมชัดและอ่านง่าย';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'บันทึกรายการส่วนผสมทั้งหมด';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'ถ้าขวดมีลักษณะโค้ง ให้ถ่ายรูปหลายๆ รูปเท่าที่จำเป็น';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'คุณอาจต้องลอกฉลากออกเพื่อดูรายการส่วนผสม';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'วางผลิตภัณฑ์บนพื้นผิวเรียบ';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'หมายเหตุเกี่ยวกับการให้คะแนน';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'ต่างจากผลิตภัณฑ์อาหาร โลกของเครื่องสำอาง **ไม่มีระบบการให้คะแนนที่เป็นที่ยอมรับในระดับสากลและได้รับการสนับสนุนจากรัฐบาลเหมือนกับ Nutri-Score** ผลกระทบของส่วนผสมอาจแตกต่างกันไปในแต่ละบุคคล และขึ้นอยู่กับประเภทผิว อาการแพ้ และความกังวลเฉพาะบุคคล';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-th.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'ยินดีต้อนรับสู่ Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices คือโครงการที่ **รวบรวมและแบ่งปันราคาสินค้าทั่วโลก** เป็นชุดข้อมูลสาธารณะที่สามารถนำไปใช้ในการวิจัย วิเคราะห์ และอื่นๆ ได้ Open Prices พัฒนาและดูแลโดย Open Food Facts';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**เรากำลังรวบรวมชุดข้อมูลราคาแบบโอเพนซอร์สจากผู้ใช้งาน** ผู้ใช้สามารถเพิ่มราคาได้ผ่านเว็บแอปพลิเคชันนี้ หรือผ่านแอปพลิเคชันมือถือ Open Food Facts อย่างเป็นทางการ นอกจากนี้ ผู้ค้าปลีกหรือแอปพลิเคชันจากบุคคลที่สามก็สามารถร่วมให้ข้อมูลได้โดยใช้ API ของเรา';

  @override
  String get guide_open_prices_how_arg1_title =>
      'รวบรวมภาพถ่ายป้ายราคาตามชั้นวางสินค้า';

  @override
  String get guide_open_prices_how_arg2_title => 'รวบรวมรูปถ่ายใบเสร็จรับเงิน';

  @override
  String get guide_open_prices_why_title =>
      'เหตุใด Open Food Facts จึงทำเช่นนี้?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'ข้อมูลราคาเป็นสิ่งสำคัญอย่างยิ่งต่อการทำความเข้าใจระบบอาหาร เป็นปัจจัยหลักในการทำความเข้าใจต้นทุนอาหารและส่งเสริมการรับประทานอาหารที่ดีต่อสุขภาพ การเปิดเผยข้อมูลราคาเป็นวิธีที่จะช่วยให้นักวิจัย นักข่าว และประชาชนทั่วไปเข้าใจได้ดีขึ้นว่าราคาอาหารเปลี่ยนแปลงไปอย่างไรในแต่ละภูมิภาคและแต่ละช่วงเวลา';

  @override
  String get guide_open_prices_why_arg1_title =>
      'ติดตามการเปลี่ยนแปลงของราคาเมื่อเวลาผ่านไป';

  @override
  String get guide_open_prices_why_arg1_text =>
      'มาดู **วิวัฒนาการของราคา** กัน: สินค้าหดตัวแต่ราคาสูงขึ้น สินค้าราคาถูกแต่ราคาสูงขึ้น เราสามารถติดตามปรากฏการณ์เหล่านี้ไปพร้อมกันได้!';

  @override
  String get guide_open_prices_why_arg2_title => 'เปรียบเทียบราคาใกล้บ้านคุณ';

  @override
  String get guide_open_prices_why_arg2_text =>
      'เมื่อเราได้ข้อมูลราคาสินค้ามากขึ้น คุณจะสามารถค้นหา **ร้านค้าที่ราคาถูกที่สุดในบริเวณใกล้เคียง** ได้';

  @override
  String get guide_open_prices_scrapping_title =>
      'คุณเคยพิจารณาที่จะดึงราคาจากเว็บไซต์ของผู้ค้าปลีกหรือไม่?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'ด้วยเหตุผลทางกฎหมายและทางเทคนิค **เราไม่ถือว่าการดึงราคาจากเว็บไซต์ของผู้ค้าปลีกเป็นวิธีการที่ถูกต้องในการนำข้อมูลมาลงใน Open Prices** เราต้องการให้แน่ใจว่าราคาที่เราเก็บรวบรวมนั้นถูกต้องและเป็นปัจจุบัน และการรับราคาที่ถูกดึงมาจากผู้ร่วมให้ข้อมูลไม่เอื้ออำนวยให้เราทำเช่นนั้นได้';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'การดึงข้อมูลราคาเป็นหนึ่งในตัวเลือกที่พิจารณาในเวอร์ชันต่อไปของ Open Prices แต่จะดำเนินการโดย Open Prices เอง เพื่อให้เราสามารถมีหลักฐานยืนยันราคาจากหน้าเว็บ HTML ได้';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'คุณสามารถส่งข้อมูลราคาผ่าน API ของเราได้\nหากคุณต้องการส่งข้อมูลราคาในปริมาณมาก โปรดติดต่อเราได้ที่ prices@openfoodfacts.org';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'ยินดีต้อนรับสู่ Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Open Products Facts คืออะไร?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts คือฐานข้อมูลขนาดใหญ่แบบเปิดสำหรับ **ผลิตภัณฑ์ใดๆ ก็ตามที่มีบาร์โค้ด ยกเว้นอาหาร เครื่องสำอาง หรืออาหารสัตว์เลี้ยง**';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'ตั้งแต่ **อุปกรณ์อิเล็กทรอนิกส์** ไปจนถึง **ของเล่น** และ **เสื้อผ้า** ไปจนถึง **ผลิตภัณฑ์ทำความสะอาด** หากมีบาร์โค้ด ก็สามารถเพิ่มเข้าไปได้ โครงการนี้มุ่งสร้าง \"อินเทอร์เน็ตของสรรพสิ่ง\" (Internet of Things) สำหรับสิ่งของในชีวิตประจำวัน ทำให้ข้อมูลเกี่ยวกับสิ่งของเหล่านั้นเข้าถึงได้ทั่วถึง';

  @override
  String get guide_open_products_facts_features_title =>
      'คุณสมบัติของข้อมูลผลิตภัณฑ์แบบเปิด';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts มีเป้าหมายที่จะช่วยให้ผู้บริโภคสามารถ **ยืดอายุการใช้งานของสิ่งของ** โดยการนำเสนอโซลูชันแบบหมุนเวียนเพื่อบำรุงรักษา **ซ่อมแซม** **รีไซเคิล** สิ่งของ หรือส่งต่อให้เจ้าของใหม่';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'ปริมาณการปล่อยก๊าซคาร์บอนของผลิตภัณฑ์บางชนิด';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** จากหน่วยงานด้านสิ่งแวดล้อมของฝรั่งเศส ADEME ให้ข้อมูลเกี่ยวกับ **ผลกระทบทางคาร์บอน** ของสินค้าหลายประเภท โปรดระบุหมวดหมู่สินค้าให้ชัดเจน';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'ดัชนีความสามารถในการซ่อมแซมสำหรับผลิตภัณฑ์หลายชนิด';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'เมื่อใดก็ตามที่มีดัชนีความสามารถในการซ่อมแซมของฝรั่งเศส เราจะแสดงผลออกมา นอกจากนี้ **คุณสามารถเริ่มรวบรวมตัวแปรโดยใช้ Folksonomy Engine ได้** เพื่อที่เราจะสามารถคำนวณดัชนีนั้นเองได้ในอนาคต แม้ในประเทศที่ยังไม่มีดัชนีดังกล่าวก็ตาม';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'หาวิธีบริจาค/ขายต่อผลิตภัณฑ์ของคุณ';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'เราได้รวบรวมลิงก์ไปยัง **บริการที่เป็นมิตรต่อเศรษฐกิจหมุนเวียนจากภายนอก** ที่จะช่วยให้คุณหาผลิตภัณฑ์ที่คุณต้องการได้ในรูปแบบสินค้ามือสอง เพื่อลดการใช้ทรัพยากรของโลกให้เหลือน้อยที่สุด\nโปรดทราบว่าเราไม่ได้รับค่าตอบแทนสำหรับการทำเช่นนี้ และระบบนี้เป็นเพียงตัวอย่างสำหรับเว็บไซต์สองแห่งในฝรั่งเศสเท่านั้น คุณสามารถช่วยขยายระบบนี้ได้โดยการบันทึกเว็บไซต์เพิ่มเติมลงในวิกิ';

  @override
  String get guide_open_products_facts_information_title =>
      'ข้อมูลใดบ้างที่มีประโยชน์?';

  @override
  String get guide_open_products_facts_information_text =>
      'เนื่องจากสินค้ามีหลากหลายประเภทมาก **ข้อมูลที่เราเก็บรวบรวมจึงมีความยืดหยุ่น** ดังนั้นเราจึงได้สร้าง **เครื่องมือ Folksonomy** ขึ้นมา';

  @override
  String get guide_open_products_facts_folksonomy_title => 'กลไกโฟล์กโซโนมี';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine เป็นเครื่องมือที่จะช่วยคุณสร้างผลิตภัณฑ์ที่มีคุณสมบัติที่เกี่ยวข้อง ซึ่งจะช่วยปรับปรุงการค้นหาและการค้นพบผลิตภัณฑ์ รวมถึงคำนวณและแสดงผลสิ่งต่างๆ ที่น่าสนใจในอนาคต';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'คุณสามารถเพิ่มคีย์และค่าใดๆ ก็ได้ เช่น: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'คุณจะได้รับการแนะนำคุณสมบัติที่เป็นไปได้โดยอัตโนมัติ และคุณสามารถเพิ่มและบันทึกคุณสมบัติใหม่ ๆ สำหรับผลิตภัณฑ์ประเภทที่คุณชื่นชอบได้ตามต้องการ';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-th.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'เปิดเผยความชอบด้านอาหาร';

  @override
  String get guide_coming_soon_button_title => 'เร็วๆ นี้';

  @override
  String get guide_learn_more_subtitle => 'แตะเพื่อเรียนรู้เพิ่มเติม';

  @override
  String get preview_badge => 'ตัวอย่าง';

  @override
  String get prices_feedback_form =>
      'คลิกที่นี่เพื่อส่งความคิดเห็นของคุณเกี่ยวกับฟีเจอร์ใหม่นี้!';

  @override
  String get menu_button_list_actions => 'เลือกการกระทำ';

  @override
  String get error_loading_photo => 'เกิดข้อผิดพลาดในการโหลดรูปภาพ';

  @override
  String get photo_viewer_action_use_picture_as => 'ใช้เป็น…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'ใช้รูปภาพนี้เป็น…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'ใช้รูปภาพนี้เป็น… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'รายละเอียด';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'รายละเอียดของภาพถ่ายนี้';

  @override
  String get photo_viewer_details_title => 'รายละเอียดของภาพถ่าย';

  @override
  String get photo_viewer_details_contributor_title => 'Contributor';

  @override
  String get photo_viewer_details_size_title => 'ขนาด';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height พิกเซล';
  }

  @override
  String get photo_viewer_details_date_title => 'วันที่';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'เข้ากันได้';

  @override
  String get user_lists_action_multi_select => 'เลือกหลายรายการ';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'คะแนนความเข้ากันได้ของคุณ: $score%';
  }

  @override
  String get product_image_front_accessibility_label =>
      'ภาพถ่ายด้านหน้าของผลิตภัณฑ์';

  @override
  String get product_image_ingredients_accessibility_label =>
      'ภาพถ่ายส่วนประกอบของผลิตภัณฑ์';

  @override
  String get product_image_nutrition_accessibility_label =>
      'ภาพรวมด้านโภชนาการ';

  @override
  String get product_image_packaging_accessibility_label => 'ภาพบรรจุภัณฑ์';

  @override
  String get product_image_other_accessibility_label => 'รูปภาพอื่นๆ';

  @override
  String get product_image_outdated_message => 'รูปภาพนี้อาจจะล้าสมัยแล้ว';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (ภาพนี้อาจล้าสมัยแล้ว)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (ภาพนี้อาจถูกล็อกโดยผู้ผลิต)';
  }

  @override
  String get product_image_error => 'ไม่สามารถโหลดรูปภาพได้!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'ไม่สามารถโหลด $type ได้ (เกิดข้อผิดพลาดเครือข่าย?)';
  }

  @override
  String get product_page_image_no_image_available => 'ไม่มีภาพ\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'ไม่มีรูปภาพสำหรับผลิตภัณฑ์นี้';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'จัดลำดับใหม่หรือซ่อนการกระทำ';

  @override
  String get product_page_action_bar_setting_modal_title => 'แก้ไขการกระทำ';

  @override
  String get product_page_action_bar_item_move_up => 'เลื่อนขึ้น';

  @override
  String get product_page_action_bar_item_move_down => 'เลื่อนลง';

  @override
  String get product_page_action_bar_item_enable => 'เปิดใช้งานการดำเนินการ';

  @override
  String get product_page_action_bar_item_disable => 'ปิดใช้งานการกระทำ';

  @override
  String get product_page_pending_operations_banner_title =>
      'กำลังอัปโหลดการแก้ไขของคุณ…';

  @override
  String get product_page_pending_operations_banner_message =>
      'ข้อมูลที่แสดงบนหน้านี้ **ยังไม่สะท้อนการแก้ไขของคุณ**\nโปรดรอสักครู่…';

  @override
  String get product_add_a_language => 'เพิ่มภาษา';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'บาร์โค้ด $barcode';
  }

  @override
  String get carousel_close_tooltip => 'นำผลิตภัณฑ์นี้ออกจากแถบแสดงสินค้า';

  @override
  String get carousel_unsupported_header => 'บาร์โค้ดนี้ไม่รองรับ!';

  @override
  String get carousel_unsupported_title => 'โอ๊ะ!';

  @override
  String get carousel_unsupported_text =>
      'บาร์โค้ดที่สแกนไม่รองรับโดย Open Food Facts!';

  @override
  String get carousel_error_header => 'ข้อผิดพลาด!';

  @override
  String get carousel_error_title => 'แย่จัง!';

  @override
  String get carousel_error_text_1 =>
      'เราไม่สามารถดาวน์โหลดข้อมูลจากบาร์โค้ดนี้ได้:';

  @override
  String get carousel_error_text_2 =>
      'โปรดตรวจสอบการเชื่อมต่ออินเทอร์เน็ตของคุณ หรือคลิกปุ่มนี้:';

  @override
  String get carousel_error_button => 'ลองใหม่อีกครั้ง';

  @override
  String get carousel_unknown_product_header => 'ผลิตภัณฑ์ไม่ทราบชนิด';

  @override
  String get carousel_unknown_product_title =>
      'ขอแสดงความยินดี!\nคุณได้พบ __อัญมณีหายากแล้ว!__';

  @override
  String get carousel_unknown_product_text =>
      'ฐานข้อมูลร่วมของเรามีสินค้ามากกว่า **3 ล้านรายการ** แต่บาร์โค้ดนี้ไม่มีอยู่จริง: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'กำลังโหลดข้อมูล...';

  @override
  String get carousel_loading_title =>
      'คุณเพิ่งสแกนสินค้าที่มีบาร์โค้ดดังต่อไปนี้:';

  @override
  String get carousel_loading_text =>
      'เรากำลังค้นหาสินค้าชิ้นนั้นในฐานข้อมูลสินค้าของเราที่มีมากกว่า **3 ล้านรายการ!**';

  @override
  String get product_type_subtitle_food => 'ผัก ผลไม้ อาหารแช่แข็ง…';

  @override
  String get product_type_subtitle_beauty => 'เครื่องสำอาง สบู่ ยาสีฟัน…';

  @override
  String get product_type_subtitle_pet_food => 'อาหารสำหรับสุนัขและแมว…';

  @override
  String get product_type_subtitle_product => 'สมาร์ทโฟน เฟอร์นิเจอร์…';

  @override
  String get photo_field_front => 'รูปภาพสินค้า';

  @override
  String get photo_field_ingredients => 'รูปภาพของส่วนประกอบของอาหาร';

  @override
  String get photo_field_nutrition => 'ภาพโภชนาการ';

  @override
  String get photo_field_packaging => 'ภาพประกอบคำแนะนำการรีไซเคิล';

  @override
  String get photo_already_exists => 'รูปนี้มีอยู่แล้ว';

  @override
  String get photo_missing => 'รูปภาพนี้หายไป';

  @override
  String get date => 'วันที่';

  @override
  String get photo_rotate_left => 'หมุนซ้าย';

  @override
  String get photo_rotate_right => 'หมุนขวา';

  @override
  String get photo_undo_action => 'ยกเลิกการกระทำก่อนหน้า';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'แผนที่โลกของ $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'ผู้มีส่วนร่วมใน OpenStreetMap';

  @override
  String get not_applicable_short => 'ไม่มีข้อมูล';

  @override
  String get knowledge_panel_warning_text => 'Warning';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'ทำไมค่า Nutri-Score นี้ถึงแตกต่างจากค่าที่ระบุไว้บนบรรจุภัณฑ์?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'มีสาเหตุที่เป็นไปได้สองประการ:\nรายชื่อส่วนผสมและ/หรือข้อมูลโภชนาการอาจไม่เป็นปัจจุบัน\n\nเราใช้ \"การคำนวณใหม่\" ของ Nutri-Score (หรือ V2) โปรดตรวจสอบว่าคุณเห็นแบนเนอร์ \"การคำนวณใหม่\" บนบรรจุภัณฑ์หรือไม่';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'ตรวจสอบส่วนผสม';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'ตรวจสอบข้อมูลโภชนาการ';

  @override
  String url_not_supported(String url) {
    return 'ขออภัย เราไม่สามารถเปิด URL นี้ได้:\n$url';
  }

  @override
  String get product_list_export => 'ส่งออก';

  @override
  String get product_list_import => 'นำเข้า';

  @override
  String get product_footer_action_barcode => 'ดูบาร์โค้ด';

  @override
  String get product_footer_action_barcode_short => 'บาร์โค้ด';

  @override
  String get product_footer_action_open_website => 'เปิดเว็บไซต์';

  @override
  String get product_footer_action_report => 'รายงาน';

  @override
  String get product_footer_action_contributor_guide => 'ช่วย';

  @override
  String get product_footer_action_data_quality_tags => 'คุณภาพของข้อมูล';

  @override
  String get product_page_tab_for_me => 'สำหรับฉัน';

  @override
  String get product_page_tab_website => 'เว็บไซต์';

  @override
  String get product_page_tab_prices => 'ราคา';

  @override
  String get prices_explanation_card_title => 'ทำไมต้องราคา?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** คือโครงการที่รวบรวมและแบ่งปันราคาสินค้าทั่วโลก 🌍 Open Prices พัฒนาและดูแลโดย Open Food Facts';

  @override
  String get explanation_card_learn_more_button => 'ดูเพิ่มเติม';

  @override
  String get product_page_tab_folksonomy => 'โฟล์กโซโนมี';

  @override
  String get folksonomy_explanation_card_title =>
      'Folksonomy Attribute คืออะไร?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'แอตทริบิวต์จะขึ้นอยู่กับ **คีย์-ค่า**';

  @override
  String get folksonomy_explanation_card_line2 =>
      'คุณสมบัติเหล่านี้ถูกสร้างและยื่นโดยผู้สนับสนุนเพื่อการใช้งานทุกประเภท';

  @override
  String get folksonomy_action_external_link_title => 'เปิดลิงก์ภายนอก';

  @override
  String get folksonomy_action_external_link_warning =>
      'ลิงก์ภายนอกอาจไม่ปลอดภัย คุณต้องการเข้าไปชมจริงๆ หรือไม่?';

  @override
  String get prices_products_empty_title => 'ไม่มีราคาระบุ';

  @override
  String get prices_products_empty_explanation => 'เป็นคนแรกที่จะมีส่วนร่วม!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'สินค้ายอดนิยม $pageSize รายการ (รวมทั้งหมด: $totalรายการ)';
  }

  @override
  String get app_review_title => 'คุณชอบแอปนี้ไหม?';

  @override
  String get app_review_low => 'ทำได้ดีกว่านี้';

  @override
  String get app_review_medium => 'ไม่เลวเลย';

  @override
  String get app_review_high => 'ฉันชอบมันมาก!';

  @override
  String get app_review_feedback_modal_title =>
      'ช่วยเราปรับปรุงแอปพลิเคชันของเรา';

  @override
  String get app_review_feedback_modal_content =>
      'หากคุณมีเวลาสักเล็กน้อย โปรดตอบแบบฟอร์มนี้เพื่อให้เราสามารถปรับปรุงในเวอร์ชันอัปเดตในอนาคตได้:';

  @override
  String get app_review_feedback_modal_open_form => 'ตอบแบบฟอร์ม';

  @override
  String get app_review_feedback_modal_later => 'ถามฉันทีหลังนะ';

  @override
  String get nutrition_facts_extract_new =>
      'ใหม่: คุณสามารถสกัดสารอาหารจากภาพได้โดยอัตโนมัติ!';

  @override
  String get nutrition_facts_extract_button_text => 'ถอนเงินตอนนี้';

  @override
  String get nutrition_facts_extract_in_progress => 'กำลังทำการสกัด…';

  @override
  String get nutrition_facts_extract_successful => 'การสกัดสำเร็จ';

  @override
  String get nutrition_facts_extract_failed => 'ไม่สามารถสกัดสารอาหารจากภาพได้';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'สถิติ';

  @override
  String get prices_stats_title => 'สถิติราคา';

  @override
  String get prices_stats_prices_section => 'ราคา';

  @override
  String get prices_stats_products_section => 'ผลิตภัณฑ์';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'เบ็ดเตล็ด';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'อาหาร';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'ผลิตภัณฑ์';

  @override
  String get prices_stats_pet_food => 'อาหารสัตว์เลี้ยง';

  @override
  String get prices_stats_osm => 'แผนที่ถนนเปิด';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'ประเทศ';

  @override
  String get prices_stats_price_tag => 'ป้ายราคา';

  @override
  String get prices_stats_receipt => 'ใบเสร็จ';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'เว็บไซต์';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'อัปเดตล่าสุดเมื่อ';

  @override
  String get prices_stats_error => 'เกิดข้อผิดพลาดขณะโหลดสถิติ';

  @override
  String get product_edit_robotoff_question_answered => 'คำถามได้รับคำตอบแล้ว!';

  @override
  String get product_edit_robotoff_proof => 'การพิสูจน์';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'ราคา';

  @override
  String get preferences_prices_subtitle => 'จัดการการตั้งค่าราคาของคุณ';

  @override
  String get preferences_card_project => 'โครงการ Open Food Facts';

  @override
  String get preferences_contribute_title => 'ร่วมสนับสนุน';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'สถิติของฉัน';

  @override
  String get preferences_contribute_subtitle => 'แปลปรับปรุงเครื่องมือของเรา…';

  @override
  String get preferences_connect_title => 'เชื่อมต่อ';

  @override
  String get preferences_connect_subtitle =>
      'ติดต่อเราหรือติดตามเราบนโซเชียลมีเดีย';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'ช่วยเราแจ้งข้อมูลให้ผู้บริโภคหลายล้านคนทั่วโลกทราบ';

  @override
  String get preferences_card_help => 'ความช่วยเหลือและการสนับสนุน';

  @override
  String get preferences_faq_title => 'คำถามที่พบบ่อย';

  @override
  String get preferences_faq_subtitle => 'รับคำตอบสำหรับคำถามของคุณ';

  @override
  String get logged_out => 'ออกจากระบบ';

  @override
  String get preferences_app_bar_message =>
      'ขอขอบคุณที่คุณเป็นหนึ่งในสมาชิกของเรา!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'ดูสถิติทั้งหมด';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'ค้นหา $provider สำหรับ \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'ค้นหาการตั้งค่า (เช่น Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji => 'การเข้าถึง: แสดงอีโมจิ';

  @override
  String get preferences_accessibility_remove_colors => 'การเข้าถึง: ลบสีออก';

  @override
  String get preferences_app_settings_products => 'ผลิตภัณฑ์';

  @override
  String get preferences_card_about => 'About';

  @override
  String get preferences_legal_information_title => 'ข้อมูลทางกฎหมาย';

  @override
  String get preferences_legal_information_subtitle =>
      'เงื่อนไขการใช้งาน นโยบายความเป็นส่วนตัว และอื่นๆ';

  @override
  String get preferences_terms_of_use => 'ข้อกำหนดการใช้งาน';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts คือฐานข้อมูลผลิตภัณฑ์อาหารที่ **สร้างโดยทุกคน เพื่อทุกคน**\nคุณสามารถใช้ฐานข้อมูลนี้เพื่อเลือกอาหารที่ดีขึ้น และเนื่องจากเป็น **ข้อมูลเปิด** ทุกคนจึงสามารถ **นำกลับมาใช้ซ้ำเพื่อจุดประสงค์ใดก็ได้**';

  @override
  String get preferences_privacy_policy => 'นโยบายความเป็นส่วนตัว';

  @override
  String get preferences_licenses => 'ใบอนุญาต';

  @override
  String get preferences_about_app_title => 'เกี่ยวกับแอป';

  @override
  String get preferences_about_app_subtitle =>
      'ข้อมูลทางเทคนิค ข้อมูลนักพัฒนา และอื่นๆ';

  @override
  String get preferences_card_information => 'ข้อมูล';

  @override
  String get preferences_version_number_title => 'หมายเลขเวอร์ชัน';

  @override
  String get preferences_scanner_title => 'สแกนเนอร์';

  @override
  String get preferences_app_store => 'แอปสโตร์';

  @override
  String get preferences_app_system_settings => 'การตั้งค่าระบบ';

  @override
  String get preferences_source_code => 'เข้าถึงโค้ดต้นฉบับ';

  @override
  String get preferences_source_code_subtitle =>
      'และเริ่มสร้างผลกระทบให้กับคนนับล้าน';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'ลงข้อมูลผลิตภัณฑ์อาหาร';

  @override
  String get preferences_tips => 'เคล็ดลับ';

  @override
  String get tips_discover_nutriscore => 'ค้นพบ Nutri-Score ใหม่';

  @override
  String get preferences_on_off_website_subtitle =>
      'บนเว็บไซต์ Open Food Facts';

  @override
  String get preferences_manage_account_title => 'จัดการบัญชีของฉัน';

  @override
  String get preferences_manage_account_tooltip => 'จัดการบัญชีของคุณ';

  @override
  String get preferences_change_password_title => 'เปลี่ยนรหัสผ่านของฉัน';

  @override
  String get preferences_danger_zone => 'เขตอันตราย';

  @override
  String get preferences_account_deletion_subtitle =>
      'เงินบริจาคของคุณทั้งหมดจะสูญหาย';

  @override
  String get preferences_contributions_title => 'การมีส่วนร่วม';

  @override
  String get preferences_dev_mode_app_settings_title => 'การตั้งค่าแอป';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'วิธีการทดลองในการสแกนผลิตภัณฑ์แบบออฟไลน์';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'รีเฟรชผลิตภัณฑ์ทั้งหมดจากเซิร์ฟเวอร์';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'โปรดหลีกเลี่ยงการทำเช่นนั้นเว้นแต่จำเป็นจริงๆ';

  @override
  String get preferences_dev_mode_demo_mode_title => 'โหมดสาธิต';

  @override
  String get preferences_dev_mode_add_cards_title => 'เพิ่มบัตรเข้าเครื่องสแกน';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'เพิ่มผลิตภัณฑ์ตัวอย่าง 3 รายการลงในเครื่องสแกน';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'พิธีกรโฟล์คโซโนมี';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'เจ้าภาพ: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'การทดลองการเข้าถึง';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'การเลือกผลิตภัณฑ์หลายรายการตามราคา';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'แผงความรู้ที่ผู้ใช้สั่ง';

  @override
  String get preferences_dev_mode_location_search_title =>
      'การเข้าถึงการค้นหาตำแหน่งที่ตั้งชั่วคราว';

  @override
  String get preferences_dev_mode_comparison_title =>
      'การเปรียบเทียบแบบเคียงข้างกันสำหรับผลิตภัณฑ์ 2 หรือ 3 รายการ';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'การนำเข้ารายการสินค้า';

  @override
  String get preferences_faq_scores_methodologies_title => 'คะแนนและวิธีการ';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'ค้นพบวิธีการคำนวณ Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'ค้นพบการเปลี่ยนแปลงหลักของวิธีการ';

  @override
  String get preferences_faq_discover_project_title => 'ค้นพบโครงการ';

  @override
  String get preferences_faq_discover_off_title => 'ค้นพบOpen Food Facts';

  @override
  String get preferences_faq_discover_obf_title =>
      'ค้นพบข้อเท็จจริงเกี่ยวกับ Open Beauty';

  @override
  String get preferences_faq_discover_opff_title =>
      'ค้นพบข้อมูลอาหารสัตว์เลี้ยงแบบเปิดเผย';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'ค้นพบข้อเท็จจริงเกี่ยวกับผลิตภัณฑ์แบบเปิด';

  @override
  String get preferences_faq_faq_title => 'คำถามที่พบบ่อย';

  @override
  String get preferences_faq_off_ngo_title =>
      'องค์กรพัฒนาเอกชน Open Food Facts';

  @override
  String get preferences_about_information_title => 'ข้อมูล';

  @override
  String get preferences_connect_community_updates_title =>
      'รับการอัปเดตจากชุมชน';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'ติดตามข่าวสารเกี่ยวกับแอปและชุมชน';

  @override
  String get preferences_connect_community_calendar_title =>
      'สมัครรับข้อมูลปฏิทินกิจกรรมชุมชนของเรา';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'มีส่วนร่วมโดยเข้าร่วมกิจกรรมเสมือนจริงของเรา';

  @override
  String get preferences_connect_blog_title => 'บล็อก Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'รับข่าวสารล่าสุดทันทีที่เกิดขึ้น';

  @override
  String get preferences_connect_community_help_title =>
      'รับความช่วยเหลือจากชุมชน';

  @override
  String get preferences_connect_improve_app_title => 'ช่วยเราปรับปรุงแอพ';

  @override
  String get preferences_connect_debug_info_title => 'ส่งข้อมูลการดีบักให้เรา';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'ส่งอีเมลถึงเราพร้อมข้อมูลการแก้ไขข้อบกพร่องโดยละเอียด';

  @override
  String get preferences_connect_feedback_title =>
      'ส่งคำติชมเกี่ยวกับแอปให้เรา';

  @override
  String get preferences_connect_feedback_subtitle => 'ช่วยกำหนดอนาคตของแอป';

  @override
  String get preferences_connect_survey_title => 'ทำแบบสำรวจแอป';

  @override
  String get preferences_connect_survey_subtitle =>
      'ช่วยให้เราเข้าใจว่าเราควรสร้างอะไรต่อไป';

  @override
  String get preferences_connect_professionals_title => 'ผู้เชี่ยวชาญ';

  @override
  String get preferences_connect_pro_subtitle =>
      'ฟรีทั้งหมด รับประกันข้อมูลที่แม่นยำสำหรับแอป 500 รายการและผู้บริโภคหลายล้านคน บริการตนเอง ใช้งานได้กับ PIM หรือสเปรดชีต (XLSX) ของคุณ';

  @override
  String get preferences_connect_pro_email_subtitle => 'ติดต่อเพื่อเริ่มต้น';

  @override
  String get preferences_connect_press_title => 'กด';

  @override
  String get preferences_connect_press_page_subtitle =>
      'รับข้อมูลทั้งหมดที่คุณต้องการสำหรับรายงานของคุณ';

  @override
  String get preferences_connect_press_email_subtitle =>
      'ติดต่อสอบถามข้อมูลข่าวสารหรือแจ้งรายงานของคุณให้เราทราบ';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'มาเป็นอาสาสมัครที่กระตือรือร้น';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'การพัฒนา การสื่อสาร การออกแบบ… ยินดีต้อนรับอาสาสมัครหรือความเชี่ยวชาญทุกประเภท!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'ค้นพบวิธีต่างๆ มากมายที่คุณสามารถมีส่วนร่วมได้';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'การพัฒนาแอปพลิเคชันมือถือ';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'เรียนรู้วิธีการมีส่วนร่วมในการพัฒนาซอฟต์แวร์';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'การสร้างที่ไม่เสถียรทุกวัน คุณสมบัติใหม่ล่าสุด';

  @override
  String get preferences_contribute_local_community_title =>
      'ขยายชุมชนท้องถิ่นของคุณ';

  @override
  String get preferences_contribute_translate_subtitle =>
      'ช่วยเหลือด้านซอฟต์แวร์ เนื้อหา การวิเคราะห์ส่วนผสม และการแปล';

  @override
  String get preferences_contribute_share_subtitle =>
      'เราได้เตรียมเทมเพลตเล็กๆ น้อยๆ ไว้เพื่อช่วยคุณ :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'ขั้นตอนง่ายๆ ในการสร้างความโปร่งใสด้านอาหารในประเทศของคุณ';

  @override
  String get preferences_contribute_data_quality_title => 'คุณภาพของข้อมูล';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'เข้าร่วมทีมคุณภาพข้อมูล';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'เข้าร่วมความพยายามของเราเพื่อให้แน่ใจว่าฐานข้อมูลมีความสมบูรณ์และถูกต้อง';

  @override
  String get preferences_contributions_products_added_title =>
      'สินค้าที่เพิ่มเข้ามา';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'ผลิตภัณฑ์ใหม่ที่ฉันเพิ่มลงใน Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'สินค้าที่ฉันต้องการทำเสร็จ';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'สินค้าไม่สมบูรณ์ทั้งหมด';

  @override
  String get preferences_my_contributions_prices_title => 'ราคา';

  @override
  String get preferences_my_contributions_my_prices_title => 'ราคาของฉัน';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'ราคาของฉัน หลักฐานของฉัน…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'ผลิตภัณฑ์ที่คุณสามารถช่วยทำให้เสร็จสมบูรณ์';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'ช่วยคำนวณคะแนน Nutri-Score และ Green-Score ในประเทศของคุณ';

  @override
  String get preferences_prices_user_prices_subtitle => 'ราคาที่ผมร่วมสมทบ';

  @override
  String get preferences_prices_proofs_subtitle => 'ป้ายราคาและใบเสร็จ';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'ถ่ายรูปใบเสร็จของคุณและสแกนบาร์โค้ดที่เกี่ยวข้อง';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'ถ่ายรูปราคาสินค้าภายในร้าน';

  @override
  String get preferences_prices_newest_title => 'ราคาล่าสุด';

  @override
  String get preferences_prices_newest_subtitle =>
      'ราคาล่าสุดที่เพิ่มโดยชุมชนOpen Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'ผู้ร่วมสมทบที่มีราคาสูงสุด';

  @override
  String get preferences_prices_metrics_title => 'เมตริกราคาเปิด';

  @override
  String get preferences_prices_metrics_subtitle => 'ติดตามพัฒนาการของโครงการ';

  @override
  String get preferences_prices_ways_contribute_title => 'ช่องทางการมีส่วนร่วม';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'ยืนยันราคาที่คุณหรือผู้อื่นเพิ่มด้วยความช่วยเหลือของ AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'เพิ่มใบเสร็จหรือรูปถ่ายของชั้นวางจากม้วนฟิล์มกล้องของคุณได้อย่างรวดเร็ว';

  @override
  String get preferences_prices_challenges_title => 'ความท้าทายรายเดือน';

  @override
  String get preferences_prices_challenges_subtitle =>
      'เข้าร่วมภารกิจตามธีมรายเดือนเพื่อสะสมราคา';

  @override
  String get preferences_prices_loyalty_data_title =>
      'เรียกคืนข้อมูลความภักดีของคุณ';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'เรียนรู้วิธีการขอข้อมูลของคุณ';

  @override
  String get preferences_page_customize_app_title => 'ปรับแต่งแอป';

  @override
  String get preferences_page_contribute_project_title => 'ร่วมสนับสนุนโครงการ';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'วิธีง่ายๆ ที่จะช่วย Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'วิธีการให้คะแนน ความช่วยเหลือ และอื่นๆ เกี่ยวกับโครงการ';

  @override
  String get product_edit_robotoff_positive_button => 'ยอมรับข้อเสนอแนะ';

  @override
  String get product_edit_robotoff_negative_button => 'ปฏิเสธข้อเสนอแนะ';

  @override
  String get product_edit_robotoff_show_proof => 'แสดงหลักฐาน';

  @override
  String get product_edit_robotoff_expand_proof => 'ขยายหลักฐาน';

  @override
  String get product_page_tab_raw_data => 'ข้อมูลดิบ';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'หน้า $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'หน้า $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count จาก $total รายการ';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count จาก $total รายการ';
  }

  @override
  String item_count(int count) {
    return '$count รายการ';
  }

  @override
  String item_count_string(String count) {
    return '$count รายการ';
  }

  @override
  String get prices_no_result => 'ไม่พบสถิติราคา.';

  @override
  String get prices_error_loading_more_items =>
      'เกิดข้อผิดพลาดในการโหลดรายการเพิ่มเติม';

  @override
  String get prices_proof_error =>
      'การตรวจสอบสิทธิ์ล้มเหลว ไม่สามารถดึงหลักฐานได้';

  @override
  String proofs_count_with_total(int count, int total) {
    return 'บทพิสูจน์ $count ของ $total';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count จากผู้ร่วมสนับสนุน $total';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count จาก $total ตำแหน่ง';
  }

  @override
  String prices_locations_count(int count) {
    return '$count สถานที่';
  }

  @override
  String get restart_to_apply_message =>
      'โปรดรีสตาร์ทแอปเพื่อใช้การเปลี่ยนแปลง';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'อินเทอร์เฟซแบบกราฟิก';

  @override
  String get preferences_app_settings_media_title => 'สื่อ';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title => 'Open Food Facts';

  @override
  String get preferences_root_account_title => 'บัญชี';

  @override
  String get preferences_contribute_translate_header =>
      'นำ Open Food Facts มาสู่ภาษาของคุณ';

  @override
  String get preferences_contribute_enroll_alpha =>
      'ลงทะเบียนในเวอร์ชันอัลฟ่าของแอป';

  @override
  String get preferences_dev_mode_section_data =>
      'ข้อมูลการสนับสนุนและผลิตภัณฑ์';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'อย่าแสดง Folksonomy';

  @override
  String get preferences_account_title => 'บัญชี';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'เพิ่มเมื่อ $created';
  }

  @override
  String get location_map_details_title => 'รายละเอียดสถานที่ตั้ง';

  @override
  String get location_map_details_name => 'ชื่อ';

  @override
  String get location_map_details_street => 'ถนน';

  @override
  String get location_map_details_city => 'เมือง';

  @override
  String get location_map_details_postcode => 'รหัสไปรษณีย์';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'พิกัด';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
