// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Tamil (`ta`).
class AppLocalizationsTa extends AppLocalizations {
  AppLocalizationsTa([String locale = 'ta']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'ஆம்';

  @override
  String get add => 'சேர்';

  @override
  String get account_delete_message =>
      'உங்கள் கணக்கை நீக்க விரும்புகிறீர்களா?\nகுறிப்பிட்ட காரணம் இருந்தால், கீழே பகிரவும்.';

  @override
  String get reason => 'காரணம்';

  @override
  String get okay => 'சரி';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'உருவாக்கு';

  @override
  String get applyButtonText => 'பயன்படுத்து';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'தொடரவும்';

  @override
  String get exit_label => 'வெளியேறு';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'மீண்டும் மேலே செல்';

  @override
  String get save => 'சேமி';

  @override
  String get save_confirmation => 'நிச்சயமாக சேமிக்க விரும்புகிறீர்களா?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Cancel';

  @override
  String get ignore => 'விட்டுவிடு';

  @override
  String get close => 'மூடுக‌';

  @override
  String get no => 'இல்லை';

  @override
  String get stop => 'நிறுத்து';

  @override
  String get finish => 'முடித்தல்';

  @override
  String get calculate => 'கணக்கிடுங்கள்';

  @override
  String get reset_food_prefs => 'உணவு விருப்பங்களை மீட்டமைக்கவும்';

  @override
  String get error => 'எதிர் பாராத பிழை ஏற்பட்டு விட்டது';

  @override
  String get error_occurred => 'ஒரு பிழை ஏற்பட்டது';

  @override
  String get featureInProgress =>
      'இந்த வடிவத்தில் நாங்கள் இன்னும் பணியாற்றி வருகிறோம், காத்திருங்கள்.\n';

  @override
  String get label_web => 'வலையில் பார்க்கவும்';

  @override
  String get learnMore => 'மேலும்அறிய';

  @override
  String get unknown => 'தெரியவில்லை';

  @override
  String get match_very_good => 'மிகவும் நல்ல பொருத்தம்';

  @override
  String get match_good => 'நல்ல பொருத்தம்';

  @override
  String get match_poor => 'மோசமான பொருத்தம்';

  @override
  String get match_may_not => 'May not match';

  @override
  String get match_does_not => 'பொருந்தவில்லை';

  @override
  String get match_unknown => 'தெரியாத பொருத்தம்';

  @override
  String get match_short_very_good => 'மிகவும் நல்ல பொருத்தம்';

  @override
  String get match_short_good => 'நல்ல பொருத்தம்';

  @override
  String get match_short_poor => 'மோசமான பொருத்தம்';

  @override
  String get match_short_may_not => 'May not match';

  @override
  String get match_short_does_not => 'பொருந்தவில்லை';

  @override
  String get match_short_unknown => 'தெரியாத பொருத்தம்';

  @override
  String get licenses => 'உரிமங்கள்';

  @override
  String get looking_for => 'தேடுகிறேன்';

  @override
  String get welcomeToOpenFoodFacts => 'திறந்த உணவு உண்மைகளுக்கு வருக.';

  @override
  String get whatIsOff =>
      'ஓபன் ஃபுட் ஃபேக்ட்ஸ் என்பது உள்ளூர் சமூகங்களால் இயக்கப்படும் உலகளாவிய இலாப நோக்கற்ற அமைப்பாகும்.';

  @override
  String get productDataUtility =>
      'உங்கள் விருப்பங்களுக்கு பொருத்தமான உணவுத் தரவைப் பார்க்கவும்.';

  @override
  String get healthCardUtility => 'உங்களுக்கு ஏற்ற உணவுகளைத் தேர்ந்தெடுங்கள்.';

  @override
  String get ecoCardUtility => 'கிரகத்திற்கு நல்ல உணவுகளைத் தேர்ந்தெடுங்கள்.';

  @override
  String get server_error_open_new_issue =>
      'சேவையக பதில் இல்லை! பின்வரும் இணைப்பைப் பயன்படுத்தி நீங்கள் ஒரு சிக்கலைத் தொடங்கலாம்.';

  @override
  String get sign_in_text =>
      'உங்கள் பங்களிப்புகளைச் சேமிக்க உங்கள் Open Food Facts கணக்கில் உள்நுழையவும்.';

  @override
  String get incorrect_credentials => 'தவறான பயனர்பெயர் அல்லது கடவுச்சொல்.';

  @override
  String get password_lost_incorrect_credentials =>
      'இந்த மின்னஞ்சல் முகவரி அல்லது பயனர்பெயர் இல்லை. உங்கள் சான்றுகளைச் சரிபார்க்கவும்.';

  @override
  String get password_lost_server_unavailable =>
      'எங்கள் சேவையகங்களில் தற்போது மந்தநிலை ஏற்பட்டுள்ளது, அதற்காக நாங்கள் வருந்துகிறோம். தயவுசெய்து பின்னர் மீண்டும் முயற்சிக்கவும்.';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable =>
      'நெட்வொர்க்கை அணுக முடியவில்லை.';

  @override
  String get login_result_type_server_issue =>
      'சர்வரில் சிக்கல். பிறகு முயற்சிக்கவும்.';

  @override
  String get login_page_username_or_email =>
      'பயனர்பெயர் அல்லது மின்னஞ்சலை உள்ளிடவும்.';

  @override
  String get login_page_password_error_empty => 'கடவுச்சொல்லை உள்ளிடவும்.';

  @override
  String get create_account => 'கணக்கை உருவாக்கு';

  @override
  String get sign_in => 'உள்நுழை';

  @override
  String get sign_in_mandatory =>
      'அந்த அம்சத்திற்கு நீங்கள் உள்நுழைய வேண்டும்.';

  @override
  String get help_improve_country =>
      'உங்கள் நாட்டில் Open Food Facts உண்மைகளை மேம்படுத்த உதவுங்கள்.';

  @override
  String get sign_out => 'வெளியேறு';

  @override
  String get sign_out_confirmation =>
      'நீங்கள் நிச்சயமாக வெளியேற விரும்புகிறீர்களா?';

  @override
  String get password => 'கடவுச்சொல்';

  @override
  String get forgot_password => 'கடவுச்சொல் மறந்துவிட்டது';

  @override
  String get forgot_password_question => 'கடவுச்சொல்லை மறந்துவிட்டீர்களா?';

  @override
  String get view_profile => 'சுயவிவரத்தைக் காண்க';

  @override
  String get reset_password => 'கடவுச்சொல்லை மீட்டமைக்க';

  @override
  String get reset_password_explanation_text =>
      'கடவுச்சொல் மறந்துவிட்டால், கடவுச்சொல்லை மீட்டமைப்பதற்கான வழிமுறைகளைப் பெற உங்கள் பயனர்பெயர் அல்லது மின்னஞ்சல் முகவரியை உள்ளிடவும். மேலும், ஸ்பேம் கோப்புறையைச் சரிபார்க்கவும்.';

  @override
  String get username_or_email => 'பயனர்பெயர் அல்லது மின்னஞ்சல்';

  @override
  String get reset_password_done =>
      'உங்கள் கடவுச்சொல்லை மீட்டமைப்பதற்கான இணைப்புடன் கூடிய மின்னஞ்சல் உங்கள் கணக்குடன் தொடர்புடைய மின்னஞ்சல் முகவரிக்கு அனுப்பப்பட்டுள்ளது. உங்கள் ஸ்பேமையும் சரிபார்க்கவும்.';

  @override
  String get send_reset_password_mail => 'கடவுச்சொல்லை மாற்றுக';

  @override
  String get enter_some_text => 'தயவுசெய்து சில உரையை உள்ளிடவும்.';

  @override
  String get sign_up_page_title => 'பதிவு செய்';

  @override
  String get sign_up_page_action_button => 'பதிவு செய்';

  @override
  String get sign_up_page_action_doing_it => '…பதிவு செய்தல்';

  @override
  String get sign_up_page_action_ok =>
      'வாழ்த்துக்கள்! உங்கள் கணக்கு இப்போதுதான் உருவாக்கப்பட்டது.';

  @override
  String get sign_up_page_display_name_hint => 'பெயர்';

  @override
  String get sign_up_page_display_name_error_empty =>
      'நீங்கள் பயன்படுத்த விரும்பும் காட்சிப் பெயரை உள்ளிடவும்.';

  @override
  String get sign_up_page_email_hint => 'மின்னஞ்சல்';

  @override
  String get sign_up_page_email_error_empty => 'மின்னஞ்சல் அவசியம்';

  @override
  String get sign_up_page_email_error_invalid => 'தவறான மின்னஞ்சல்';

  @override
  String get sign_up_page_username_hint => 'பயனர்பெயர்: பொதுவில் தெரியும்';

  @override
  String get sign_up_page_username_error_empty =>
      'தயவுசெய்து ஒரு பயனர்பெயரை உள்ளிடவும்.';

  @override
  String get sign_up_page_username_error_invalid =>
      'தயவுசெய்து ஒரு செல்லுபடியாகும் பயனர்பெயரை உள்ளிடவும்.';

  @override
  String get sign_up_page_username_description =>
      'பயனர்பெயரில் இடைவெளிகள், பெரிய எழுத்துக்கள் அல்லது சிறப்பு எழுத்துக்கள் இருக்கக்கூடாது.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'பயனர்பெயர் $value எழுத்துகளுக்கு மேல் இருக்கக்கூடாது';
  }

  @override
  String get sign_up_page_password_hint => 'கடவுச்சொல்';

  @override
  String get sign_up_page_password_error_empty => 'கடவுச்சொல்லை உள்ளிடவும்.';

  @override
  String get sign_up_page_password_error_invalid =>
      'தயவுசெய்து செல்லுபடியாகும் கடவுச்சொல்லை உள்ளிடவும் (குறைந்தது 6 எழுத்துகள்)';

  @override
  String get sign_up_page_confirm_password_hint =>
      'கடவுச்சொல்லை உறுதிப்படுத்தவும்';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'கடவுச்சொல்லை உறுதிப்படுத்தவும்.';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'கடவுச்சொற்கள் பொருந்தவில்லை.';

  @override
  String get sign_up_page_agree_text =>
      'திறந்த உணவு உண்மைகளை நான் ஒப்புக்கொள்கிறேன்.';

  @override
  String get sign_up_page_terms_text =>
      'பயன்பாட்டு விதிமுறைகள் மற்றும் பங்களிப்பு';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'ஒரு கணக்கை உருவாக்கும் போது, பயன்பாட்டு விதிமுறைகளை ஒப்புக்கொள்வது கட்டாயமாகும், இருப்பினும், பயன்பாட்டின் மூலம் அநாமதேய பங்களிப்புகளைச் செய்யலாம்.';

  @override
  String get sign_up_page_producer_checkbox => 'நான் ஒரு உணவு தயாரிப்பாளர்.';

  @override
  String get sign_up_page_producer_hint => 'தயாரிப்பாளர்/பிராண்ட்';

  @override
  String get sign_up_page_producer_error_empty =>
      'தயவுசெய்து ஒரு தயாரிப்பாளர் அல்லது ஒரு பிராண்ட் பெயரை உள்ளிடவும்.';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'நான் திறந்த உணவு உண்மைகள் செய்திமடலுக்கு குழுசேர விரும்புகிறேன் (நீங்கள் எந்த நேரத்திலும் அதிலிருந்து குழுவிலகலாம்)';

  @override
  String get sign_up_page_user_name_already_used =>
      'பயனர் பெயர் ஏற்கனவே உள்ளது, தயவுசெய்து வேறு பயனர்பெயரைத் தேர்வுசெய்க.';

  @override
  String get sign_up_page_email_already_exists =>
      'ஏற்கனவே உள்ளது, கணக்கில் உள்நுழையவும் அல்லது வேறு மின்னஞ்சலைப் பயன்படுத்தி முயற்சிக்கவும்.';

  @override
  String get sign_up_page_provide_valid_email =>
      'சரியான மின்னஞ்சல் முகவரியை வழங்கவும்.';

  @override
  String get sign_up_page_server_busy =>
      'மன்னிக்கவும், உங்கள் கணக்கை உருவாக்குவதில் சில தொழில்நுட்ப சிக்கல்கள் உள்ளன. தயவுசெய்து பின்னர் மீண்டும் முயற்சிக்கவும்.';

  @override
  String get settingsTitle => 'அமைப்புகள்';

  @override
  String get darkmode => 'தீம்';

  @override
  String get darkmode_dark => 'இருள்';

  @override
  String get darkmode_light => 'ஒளி';

  @override
  String get darkmode_system_default => 'கணினி இயல்புநிலை';

  @override
  String get thanks_for_contributing => 'பங்களித்ததற்கு நன்றி!';

  @override
  String get contributors_label => 'அவர்கள் செயலியை உருவாக்குகிறார்கள்.';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'பங்களிப்பாளர்: $name';
  }

  @override
  String get contributors_description =>
      'இந்த செயலியின் அனைத்து பங்களிப்பாளர்களின் பட்டியல்';

  @override
  String get support => 'ஆதரவு';

  @override
  String get support_join_slack => 'எங்கள் ஸ்லாக் சேனலில் உதவி கேளுங்கள்.';

  @override
  String get support_via_forum => 'உதவிக்கு எங்கள் மன்றத்தை நாடவும்';

  @override
  String get support_via_email => 'எங்களுக்கு ஒரு மின்னஞ்சல் அனுப்புங்கள்.';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'ஆப் பதிவுகளை அனுப்பவா?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'உங்கள் மின்னஞ்சலில் இணைப்பில் பயன்பாட்டுப் பதிவுகளைச் சேர்க்க விரும்புகிறீர்களா?';

  @override
  String get termsOfUse => 'பயன்பாட்டு விதிமுறைகள்';

  @override
  String get legalNotices => 'சட்ட அறிவிப்புகள்';

  @override
  String get privacy_policy => 'தனியுரிமைக் கொள்கை';

  @override
  String get about_this_app => 'இந்த ஆப்ஸ் பற்றி';

  @override
  String get contribute => 'Contribute';

  @override
  String get contribute_sw_development => 'மென்பொருள் மேம்பாடு';

  @override
  String get contribute_develop_text =>
      'ஒவ்வொரு Open Food Facts தயாரிப்புக்கான குறியீடும் GitHub இல் கிடைக்கிறது. இந்தக் குறியீட்டை மீண்டும் பயன்படுத்தவும் (இது திறந்த மூலமாகும்) மேலும், உலகம் முழுவதும் உள்ள அனைவருக்கும் அதை மேம்படுத்த எங்களுக்கு உதவவும் உங்களை வரவேற்கிறோம்.';

  @override
  String get contribute_develop_text_2 =>
      'நீங்கள் ஓபன் ஃபுட் ஃபேக்ட்ஸ் ஸ்லாக் அரட்டை அறையில் சேரலாம், இது கேள்விகளைக் கேட்க விருப்பமான வழியாகும்.';

  @override
  String get contribute_develop_dev_mode_title => 'DEV பயன்முறையா?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'DEV பயன்முறையை இயக்கவும்';

  @override
  String get contribute_donate_title => 'நன்கொடை';

  @override
  String get contribute_donate_header =>
      'திறந்த உணவு உண்மைகளுக்கு நன்கொடை அளிக்கவும்';

  @override
  String get contribute_enroll_alpha_warning =>
      'உள் ஆல்பா பதிப்பில், தரவு முழுமையாக இழக்க நேரிடும் என்பதையும், எந்த நேரத்திலும் பயன்பாடு பயன்படுத்த முடியாததாகிவிடும் என்பதையும் ஒப்புக்கொள்ளுங்கள்!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'முடிக்க வேண்டிய தயாரிப்புகள்';

  @override
  String get contribute_improve_header => 'மேம்படுத்துதல்';

  @override
  String get contribute_improve_text =>
      'இந்தத் திட்டத்தின் மையக் கருத்துத் தரவுத்தளம். இது உதவுவது எளிதானது மற்றும் மிக விரைவானது. உங்கள் தொலைபேசிக்கான மொபைல் செயலியைப் பதிவிறக்கம் செய்து, தயாரிப்புகளைச் சேர்க்க அல்லது மேம்படுத்தத் தொடங்கலாம்.\n\nமறுபுறம், ஓபன் ஃபுட் ஃபேக்ட்ஸ் வலைத்தளம் பங்களிக்க பல வழிகளை வழங்குகிறது: ';

  @override
  String get contribute_translate_header => 'மொழிபெயர்';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'மொழிபெயர்க்கத் தொடங்குங்கள்';

  @override
  String get contribute_translate_text =>
      'ஓபன் ஃபுட் ஃபேக்ட்ஸ் என்பது 160க்கும் மேற்பட்ட நாடுகளின் தயாரிப்புகளைக் கொண்ட ஒரு உலகளாவிய திட்டமாகும். ஓபன் ஃபுட் ஃபேக்ட்ஸ் என்பது டஜன் கணக்கான மொழிகளில் மொழிபெயர்க்கப்பட்டுள்ளது, தொடர்ந்து வளர்ந்து வரும் உள்ளடக்கத்துடன்.';

  @override
  String get contribute_translate_text_2 =>
      'மொழிபெயர்ப்புகள் திட்டத்தின் முக்கிய பணிகளில் ஒன்றாகும்.';

  @override
  String get contribute_join_skill_pool =>
      'Contribute your skills to Open Food Facts. Join the skill pool!';

  @override
  String get contribute_share_header =>
      'உணவு பற்றிய திறந்த உண்மைகளை உங்கள் நண்பர்களுடன் பகிர்ந்து கொள்ளுங்கள்.';

  @override
  String get contribute_share_content =>
      'நான் பயன்படுத்தி வரும் Open Food Facts என்ற செயலியைப் பற்றி உங்களுக்குத் தெரிவிக்க விரும்பினேன். இது உங்கள் உணவின் ஆரோக்கியம் மற்றும் சுற்றுச்சூழல் பாதிப்புகளை தனிப்பயனாக்கப்பட்ட முறையில் பெற உங்களை அனுமதிக்கிறது. இது பேக்கேஜிங்கில் உள்ள பார்கோடுகளை ஸ்கேன் செய்வதன் மூலம் செயல்படுகிறது. இறுதியாக இது இலவசம், பதிவு தேவையில்லை, மேலும் டிசைஃபர் செய்யப்பட்ட பொருட்களின் எண்ணிக்கையை அதிகரிக்கவும் நீங்கள் உதவலாம். உங்கள் தொலைபேசியில் இதைப் பெறுவதற்கான இணைப்பு இங்கே: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'உங்கள் லாயல்டி கார்டுகளின் தரவை GDPR ஏற்றுமதி செய்யக் கோருவதன் மூலம் விலைகளை பங்களிக்கவும்.';

  @override
  String get tap_to_answer => 'கேள்விகளுக்கு பதிலளிக்க இங்கே தட்டவும்';

  @override
  String get tap_to_answer_hint =>
      'இந்தத் தயாரிப்புபற்றிய கேள்விகளுக்குப் பதிலளிக்க இங்கே தட்டவும்';

  @override
  String get robotoff_questions_loading_hint =>
      'இந்தத் தயாரிப்புபற்றிய கேள்விகள் ஏற்றப்படும் வரை காத்திருக்கவும்';

  @override
  String get saving_answer => 'உங்கள் பதிலைச் சேமிக்கிறது';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'உங்கள் பங்களிப்புகளுக்கு கிரெடிட்டைப் பெற உங்கள் Open Food Facts கணக்கில் உள்நுழையவும்.';

  @override
  String get question_yes_button_accessibility_value =>
      'ஆம் என்று பதிலளிக்கவும்';

  @override
  String get question_no_button_accessibility_value =>
      'இல்லை என்று பதிலளிக்கவும்';

  @override
  String get question_skip_button_accessibility_value =>
      'இந்தக் கேள்வியைத் தவிர்.';

  @override
  String get tap_to_edit_search => 'தேடலைத் திருத்த தட்டவும்';

  @override
  String get myPreferences => 'எனது விருப்பத்தேர்வுகள்';

  @override
  String get account_create_message =>
      'உலகம் முழுவதும் உணவு அறிவை வளர்க்க உதவ, உங்கள் கணக்கை உருவாக்கி, திறந்த உணவு உண்மைகள் சமூகத்தில் சேருங்கள்!';

  @override
  String get join_us => 'எங்களுடன் சேருங்கள்';

  @override
  String get myPreferences_profile_title => 'உங்கள் சுயவிவரம்';

  @override
  String get myPreferences_profile_subtitle =>
      'உங்கள் திறந்த உணவு உண்மைகள் பங்களிப்பாளர் கணக்கை நிர்வகிக்கவும்.';

  @override
  String get myPreferences_settings_title => 'பயன்பாட்டு அமைப்புகள்';

  @override
  String get myPreferences_settings_subtitle => 'இருண்ட பயன்முறை, மொழிகள்…';

  @override
  String get myPreferences_food_title => 'உணவு விருப்பத்தேர்வுகள்';

  @override
  String get myPreferences_food_subtitle =>
      'உணவு பற்றிய எந்தத் தகவல் உங்களுக்கு மிகவும் முக்கியமானது என்பதைத் தேர்வுசெய்யவும்.';

  @override
  String get myPreferences_food_comment =>
      'உங்கள் விருப்பங்களுக்கு ஏற்ப உணவை தரவரிசைப்படுத்த, முதலில் நீங்கள் அக்கறை கொள்ளும் தகவலைப் பார்த்து, பொருந்தக்கூடிய சுருக்கத்தைப் பெற, உணவைப் பற்றிய எந்தத் தகவல் உங்களுக்கு மிகவும் முக்கியமானது என்பதைத் தேர்வுசெய்யவும். அந்த உணவு விருப்பத்தேர்வுகள் உங்கள் சாதனத்திலேயே இருக்கும், மேலும் உங்களிடம் Open Food Facts பங்களிப்பாளர் கணக்கு இருந்தால் அதனுடன் தொடர்புடையதாக இருக்காது.';

  @override
  String get confirmResetPreferences =>
      'உங்கள் உணவு விருப்பங்களை மீட்டமைக்கவா?';

  @override
  String get myPersonalizedRanking => 'எனது தனிப்பயனாக்கப்பட்ட தரவரிசை';

  @override
  String get ranking_tab_all => 'All';

  @override
  String get ranking_subtitle_match_yes => 'உங்களுக்கு ஒரு சிறந்த போட்டி';

  @override
  String get ranking_subtitle_match_no => 'மிகவும் மோசமான பொருத்தம்';

  @override
  String get ranking_subtitle_match_maybe => 'தெரியாத பொருத்தம்';

  @override
  String get refresh_with_new_preferences =>
      'உங்கள் புதிய விருப்பத்தேர்வுகளுடன் பட்டியலைப் புதுப்பிக்கவும்.';

  @override
  String get reloaded_with_new_preferences =>
      'உங்கள் புதிய விருப்பத்தேர்வுகளுடன் மீண்டும் ஏற்றப்பட்டது';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'ஸ்கேன்';

  @override
  String get history_navbar_label => 'வரலாறு';

  @override
  String get list_navbar_label => 'பட்டியல்கள்';

  @override
  String get category => 'வகையின்படி வடிகட்டவும்';

  @override
  String get category_all => 'All';

  @override
  String get category_search => '(வகை தேடல்)';

  @override
  String get filter => 'வடிகட்டி';

  @override
  String get scan => 'ஸ்கேன் திரையில் இருந்து தயாரிப்புகள்';

  @override
  String get scan_history => 'வரலாற்றை ஸ்கேன் செய்யவும்';

  @override
  String get search => 'தேடுக';

  @override
  String get search_product_help =>
      'ஒரு தயாரிப்பைத் தேடுங்கள்,\nஒரு பிராண்ட் அல்லது பார்கோடைத் தேடுங்கள்';

  @override
  String get search_filter => 'தேடல் வடிகட்டி';

  @override
  String get search_history => 'தேடல் வரலாறு';

  @override
  String get search_store => 'ஒரு கடையைத் தேடுங்கள்';

  @override
  String get search_store_help =>
      'குறிப்பு: நகரம் அல்லது நாட்டைச் சேர்க்கவும்.';

  @override
  String get tap_for_more => 'மேலும் தகவலைப் பார்க்க…தட்டவும்';

  @override
  String get product => 'Product';

  @override
  String get unknownBrand => 'தெரியாத பிராண்ட்';

  @override
  String get unknownQuantity => 'தெரியாத அளவு';

  @override
  String get unknownProductName => 'தெரியாத தயாரிப்பு பெயர்';

  @override
  String get label_refresh => 'Refresh';

  @override
  String get label_reload => 'மீண்டும் ஏற்றவும்';

  @override
  String get image => 'படம்';

  @override
  String get front_photo => 'முன்பக்க புகைப்படம்';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (இந்தப் படம் காலாவதியானதாக இருக்கலாம்)';
  }

  @override
  String get outdated_image_short_label => 'காலாவதியாக இருக்கலாம்';

  @override
  String get ingredients => 'Ingredients';

  @override
  String get ingredients_editing_instructions =>
      'அசல் ஆர்டரை வைத்திருங்கள். குறிப்பிடப்படும்போது சதவீதத்தைக் குறிக்கவும். காற்புள்ளி அல்லது ஹைபனுடன் பிரித்து, மூலப்பொருளின் பொருட்களுக்கு அடைப்புக்குறிகளைப் பயன்படுத்தவும்.';

  @override
  String get ingredients_editing_error => 'பொருட்களைச் சேமிக்க முடியவில்லை.';

  @override
  String get ingredients_editing_image_error =>
      'புதிய மூலப்பொருட்கள் படத்தைப் பெற முடியவில்லை.';

  @override
  String get ingredients_editing_title => 'தேவையான பொருட்களைத் திருத்து';

  @override
  String get ingredients_photo => 'பொருட்கள் புகைப்படம்';

  @override
  String get packaging_editing_instructions =>
      'காற்புள்ளி அல்லது வரி ஊட்டத்தால் பிரிக்கப்பட்ட அனைத்து பேக்கேஜிங் பாகங்களையும் பட்டியலிடுங்கள், அவற்றின் அளவு (எ.கா. 1 அல்லது 6) வகை (எ.கா. பாட்டில், பெட்டி, கேன்), பொருள் (எ.கா. பிளாஸ்டிக், உலோகம், அலுமினியம்) மற்றும் கிடைத்தால் அவற்றின் அளவு (எ.கா. 33cl) மற்றும் மறுசுழற்சி வழிமுறைகளுடன்.\nஎடுத்துக்காட்டு: மறுசுழற்சி செய்ய 1 கண்ணாடி பாட்டில், தூக்கி எறிய 1 பிளாஸ்டிக் கார்க்';

  @override
  String get packaging_editing_error => 'தொகுப்பைச் சேமிக்க முடியவில்லை.';

  @override
  String get packaging_editing_image_error =>
      'புதிய பேக்கேஜிங் படத்தைப் பெற முடியவில்லை.';

  @override
  String get packaging_editing_title => 'பேக்கேஜிங்கைத் திருத்து';

  @override
  String get nutrition => 'ஊட்டச்சத்து';

  @override
  String get nutrition_facts_photo => 'ஊட்டச்சத்து உண்மைகள் புகைப்படம்';

  @override
  String get nutrition_facts_editing_title =>
      'ஊட்டச்சத்து உண்மைகளைத் திருத்தவும்';

  @override
  String get packaging_information => 'மறுசுழற்சி வழிமுறைகள்';

  @override
  String get packaging_information_photo => 'மறுசுழற்சி வழிமுறைகள் புகைப்படம்';

  @override
  String get missing_product =>
      'நீங்கள் ஒரு புதிய தயாரிப்பைக் கண்டுபிடித்தீர்கள்!';

  @override
  String get add_product_take_photos =>
      'இந்த தயாரிப்பை Open Food Facts இல் சேர்க்க, பேக்கேஜிங்கின் புகைப்படங்களை எடுக்கவும்.';

  @override
  String get add_product_take_photos_descriptive =>
      'முதலில் சில புகைப்படங்களை எடுத்துக் கொள்ளுங்கள். நீங்கள் எப்போதும் தயாரிப்பை பின்னர் முடிக்கலாம்.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'புதிய தயாரிப்பு';

  @override
  String get new_product_found_title => 'புதிய தயாரிப்பு கிடைத்தது!';

  @override
  String get new_product_found_text =>
      'எங்கள் கூட்டு தரவுத்தளத்தில் **3 மில்லியனுக்கும் அதிகமான தயாரிப்புகள்** உள்ளன, ஆனால் இந்த பார்கோடு இல்லை: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'இந்தப் பக்கத்தை விட்டு வெளியேறவா?';

  @override
  String get new_product_leave_message =>
      'நீங்கள் எதையும் உள்ளிடவில்லை போலிருக்கிறது. இந்தப் பக்கத்தை விட்டு வெளியேற விரும்புகிறீர்களா?';

  @override
  String get new_product_dialog_description =>
      'இந்த தயாரிப்பை எங்கள் பொதுவான தரவுத்தளத்தில் சேர்க்க, பேக்கேஜிங்கின் புகைப்படங்களை எடுக்கவும்.';

  @override
  String get new_product_dialog_illustration_description =>
      'தெரியாத நியூட்ரி-ஸ்கோர் மற்றும் கிரீன் ஸ்கோர் கொண்ட ஒரு விளக்கம்';

  @override
  String get front_packaging_photo_button_label =>
      'முன்பக்க பேக்கேஜிங் புகைப்படம்';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'முன்பக்க பேக்கேஜிங் புகைப்படத்தைப் பதிவேற்றுவதை உறுதிப்படுத்தவும்.';

  @override
  String get confirm_button_label => 'உறுதிப்படுத்தவும்';

  @override
  String get send_image_button_label => 'படத்தை அனுப்பு';

  @override
  String get crop_page_action_saving => 'படத்தைச் சேமிக்கிறது…';

  @override
  String get crop_page_action_cropping => 'படத்தை செதுக்குதல்…';

  @override
  String get crop_page_action_local => 'உள்ளூர் பதிப்பைச் சேமிக்கிறது…';

  @override
  String get crop_page_action_local_failed_title =>
      'ஐயோ… உங்க போட்டோல ஏதோ இருக்கு!';

  @override
  String get crop_page_action_local_failed_message =>
      'எங்கள் சேவையகத்திற்கு அனுப்புவதற்கு முன்பு, படத்தை உள்ளூரில் செயலாக்க முடியவில்லை. தயவுசெய்து பின்னர் மீண்டும் முயற்சிக்கவும் அல்லது சிக்கல் தொடர்ந்தால் எங்களைத் தொடர்பு கொள்ளவும்.';

  @override
  String get crop_page_action_retake => 'மீண்டும் ஒரு புகைப்படம் எடுக்கவும்';

  @override
  String get crop_page_too_small_image_title => 'படம் ரொம்ப சின்னதா இருக்கு!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'படத்தைப் பதிவேற்றுவதற்கான குறைந்தபட்ச பிக்சல் அளவு ${expectedMinWidth}x$expectedMinHeightஆகும். தற்போதைய படம் ${actualWidth}x$actualHeightஆகும்.';
  }

  @override
  String get crop_page_action_server =>
      'சேவையகத்திற்கு அழைப்பைத் தயார்படுத்துதல்…';

  @override
  String get front_packaging_photo_title => 'முன்பக்க பேக்கேஜிங் புகைப்படம்';

  @override
  String get ingredients_photo_title => 'பொருட்கள் புகைப்படம்';

  @override
  String get nutritional_facts_photo_title => 'ஊட்டச்சத்து உண்மைகள் புகைப்படம்';

  @override
  String get recycling_photo_title => 'மறுசுழற்சி வழிமுறைகள் புகைப்படம்';

  @override
  String get take_photo_title => 'ஒரு படம் எடு';

  @override
  String get take_more_photo_title => 'Take more photos';

  @override
  String get front_photo_uploaded => 'முன்பக்கப் புகைப்படம் பதிவேற்றப்பட்டது';

  @override
  String get ingredients_photo_button_label => 'பொருட்கள் புகைப்படம்';

  @override
  String get ingredients_photo_uploaded =>
      'தேவையான பொருட்கள் புகைப்படம் பதிவேற்றப்பட்டது';

  @override
  String get nutrition_cache_loading_error =>
      'தற்காலிக சேமிப்பிலிருந்து ஊட்டச்சத்துக்களை ஏற்ற முடியவில்லை.';

  @override
  String get nutritional_facts_photo_button_label =>
      'ஊட்டச்சத்து உண்மைகள் புகைப்படம்';

  @override
  String get nutritional_facts_input_button_label =>
      'ஊட்டச்சத்து உண்மைகளை நிரப்பவும்.';

  @override
  String get nutritional_facts_added => 'ஊட்டச்சத்து உண்மைகள் சேர்க்கப்பட்டன';

  @override
  String get categories_added => 'வகைகள் சேர்க்கப்பட்டன';

  @override
  String get new_product_title_nutriscore => 'Compute the Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'உணவு வகை மற்றும் ஊட்டச்சத்து மதிப்புகளை நிரப்புவதன் மூலம் அதைப் பெறுங்கள்';

  @override
  String get new_product_title_environmental_score =>
      'பச்சை மதிப்பெண்ணைக் கணக்கிடுங்கள்';

  @override
  String get new_product_subtitle_environmental_score =>
      'குறைந்தபட்சம் ஒரு வகையையாவது நிரப்புவதன் மூலம் அதைப் பெறுங்கள்.';

  @override
  String get new_product_additional_environmental_score =>
      'தோற்றம், பேக்கேஜிங் மற்றும் பலவற்றைக் கொண்டு பசுமை மதிப்பெண் கணக்கீட்டை மிகவும் துல்லியமாக்குங்கள்.';

  @override
  String get new_product_title_nova =>
      'உணவு பதப்படுத்தும் அளவை (NOVA) கணக்கிடுங்கள்.';

  @override
  String get new_product_subtitle_nova =>
      'உணவு வகை மற்றும் பொருட்களை நிரப்புவதன் மூலம் அதைப் பெறுங்கள்.';

  @override
  String get new_product_desc_nova_unknown =>
      'உணவு பதப்படுத்தும் நிலை தெரியவில்லை';

  @override
  String get new_product_title_pictures => 'புதிய தயாரிப்பு';

  @override
  String get new_product_title_pictures_details =>
      'Please take the following photos and the Open Food Facts engine can work out the rest!';

  @override
  String get new_product_title_misc => 'மேலும் சில அடிப்படைத் தரவு…';

  @override
  String new_product_done_msg(String username) {
    return 'உங்கள் பங்களிப்புக்கு நன்றி “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'உங்கள் பங்களிப்புக்கு நன்றி!';

  @override
  String get new_product_done_button_label =>
      'முடிக்கப்பட்ட தயாரிப்பைக் கண்டறியவும்.';

  @override
  String get hey_incomplete_product_message =>
      'நியூட்ரி-ஸ்கோர், கிரீன் ஸ்கோர் & அல்ட்ரா-பிராசசிங் (NOVA) ஆகியவற்றைக் கணக்கிட 3 கேள்விகளுக்கு இப்போதே பதிலளிக்க தட்டவும்!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'இந்த அழகுசாதனப் பொருளை பகுப்பாய்வு செய்ய உதவும் 2 கேள்விகளுக்கு பதிலளிக்க இப்போதே தட்டவும்!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'இந்த செல்லப்பிராணி உணவு தயாரிப்பை பகுப்பாய்வு செய்ய உதவும் 3 கேள்விகளுக்கு பதிலளிக்க இப்போதே தட்டவும்!';

  @override
  String get hey_incomplete_product_message_product =>
      'இந்த தயாரிப்பை முடிக்க உதவ இப்போது தட்டவும்!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'ஊட்டச்சத்து உண்மைகள் புகைப்படம் பதிவேற்றப்பட்டது';

  @override
  String get recycling_photo_button_label => 'மறுசுழற்சி புகைப்படம்';

  @override
  String get recycling_photo_uploaded =>
      'மறுசுழற்சி புகைப்படம் பதிவேற்றப்பட்டது';

  @override
  String get take_more_photo_button_label => 'Take more photos';

  @override
  String get other_photo_uploaded => 'பல்வேறு புகைப்படம் பதிவேற்றப்பட்டது';

  @override
  String get retake_photo_button_label => 'மீண்டும் எடு';

  @override
  String get selecting_photo => 'புகைப்படத்தைத் தேர்ந்தெடுக்கிறது';

  @override
  String get uploading_image => 'புகைப்படத்தை சேவையகத்தில் பதிவேற்றுகிறது';

  @override
  String get uploading_image_type_front =>
      'திறந்த உணவு உண்மைகளுக்கு முன் படத்தை பதிவேற்றுகிறது';

  @override
  String get uploading_image_type_ingredients =>
      'உணவு உண்மைகள் திறந்தநிலையில் பொருட்களின் படத்தை பதிவேற்றுகிறது';

  @override
  String get uploading_image_type_nutrition =>
      'ஊட்டச்சத்து படத்தை திறந்த உணவு உண்மைகளில் பதிவேற்றுகிறது';

  @override
  String get uploading_image_type_packaging =>
      'திறந்த உணவு உண்மைகளுக்கு பேக்கேஜிங் படத்தை பதிவேற்றுதல்';

  @override
  String get uploading_image_type_other =>
      'திறந்த உணவு உண்மைகளுக்கு மற்றொரு படத்தை பதிவேற்றுகிறது';

  @override
  String get uploading_image_type_generic =>
      'திறந்த உணவு உண்மைகளுக்கு படத்தை பதிவேற்றுகிறது';

  @override
  String get score_add_missing_ingredients =>
      'விடுபட்ட பொருட்களைச் சேர்க்கவும்';

  @override
  String get score_add_missing_packaging_image =>
      'விடுபட்ட பேக்கேஜிங் படத்தைச் சேர்க்கவும்';

  @override
  String get score_add_missing_nutrition_facts =>
      'விடுபட்ட ஊட்டச்சத்து உண்மைகளைச் சேர்க்கவும்.';

  @override
  String get score_add_missing_product_traces =>
      'விடுபட்ட தயாரிப்பு தடயங்களைச் சேர்க்கவும்.';

  @override
  String get score_add_missing_product_category =>
      'ஒரு வகையைத் தேர்ந்தெடுக்கவும்';

  @override
  String get score_add_missing_precise_product_category =>
      'மிகவும் துல்லியமான வகையைத் தேர்ந்தெடுக்கவும்.';

  @override
  String get score_add_missing_product_countries =>
      'விடுபட்ட தயாரிப்பு நாடுகளைச் சேர்க்கவும்';

  @override
  String get score_add_missing_product_emb =>
      'விடுபட்ட தயாரிப்பு கண்காணிப்பு குறியீடுகளைச் சேர்க்கவும்.';

  @override
  String get score_add_missing_product_labels =>
      'விடுபட்ட தயாரிப்பு லேபிள்களைச் சேர்க்கவும்.';

  @override
  String get score_add_missing_product_origins =>
      'விடுபட்ட தயாரிப்பு மூலங்களைச் சேர்க்கவும்';

  @override
  String get score_add_missing_product_stores =>
      'விடுபட்ட தயாரிப்பு கடைகளைச் சேர்க்கவும்.';

  @override
  String get score_add_missing_product_brands =>
      'விடுபட்ட தயாரிப்பு பிராண்டுகளைச் சேர்க்கவும்.';

  @override
  String get score_update_nutrition_facts =>
      'ஊட்டச்சத்து உண்மைகளைப் புதுப்பிக்கவும்';

  @override
  String get nutrition_page_title => 'ஊட்டச்சத்து தகவல்கள்';

  @override
  String get nutrition_page_nutritional_info_title => 'ஊட்டச்சத்துத் தகவல்';

  @override
  String get nutrition_page_nutritional_info_label =>
      'தயாரிப்பில் குறிப்பிடப்பட்ட மதிப்புகள்:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'ஆம்';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'இல்லை';

  @override
  String get nutrition_page_nutritional_info_open_photo =>
      'படத்தைத் திறக்கவும்';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'நல்ல நடைமுறைகள்: ஊட்டச்சத்து தகவல்கள்';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'சில நேரங்களில் ஊட்டச்சத்து உண்மைகள் **பேக்கேஜிங்கில்** அல்லது தயாரிப்புடன் கொடுக்கப்பட்ட ஆவணத்தில் குறிப்பிடப்படவில்லை. இந்த விஷயத்தில், இந்த விஷயத்தில் மட்டுமே, நீங்கள் மதிப்பை **இல்லை** என்று அமைக்கலாம்.';

  @override
  String get nutrition_page_serving_type_label => 'ஊட்டச்சத்து மதிப்புகள்:';

  @override
  String get nutrition_page_per_100g => '100 கிராமுக்கு';

  @override
  String get nutrition_page_per_100g_100ml => '100 கிராம்/மிலிக்கு';

  @override
  String get nutrition_page_per_serving => 'ஒரு பரிமாறலுக்கு';

  @override
  String get nutrition_page_add_nutrient => 'ஒரு ஊட்டச்சத்தைச் சேர்க்கவும்.';

  @override
  String get nutrition_page_serving_size => 'பரிமாறும் அளவு';

  @override
  String get nutrition_page_serving_size_hint =>
      'பரிமாறும் அளவை உள்ளிடவும் (எ. கா: 100 கிராம்)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'நல்ல நடைமுறைகள்: பரிமாறும் அளவு';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'இந்த மதிப்பு **பரிமாறும் அளவிற்கு ஒவ்வொரு ஊட்டச்சத்தின் விகிதாசார கணக்கீட்டைச் செய்ய** உதவுகிறது.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**அனுமதிக்கப்பட்ட அலகுகள்**: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫娍,';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 கிராம்**, **60 கிராம்** அல்லது **60 கிராம்** (முதலாவது ஒன்றை விரும்புங்கள்)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 மிலி** அல்லது **1லி**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'தவறான அலகு';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **கிராம்**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'தவறான அலகுகள்';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **மிட்டாய்கள்** மற்றும் 2 **பிஸ்கட்டுகள்**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'அலகு இல்லை';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'தவறான எண்';

  @override
  String get nutrition_page_update_running =>
      'சேவையகத்தில் தயாரிப்பைப் புதுப்பித்தல்…';

  @override
  String get nutrition_page_update_done => 'தயாரிப்பு புதுப்பிக்கப்பட்டது!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'தயாரிப்பு அளவை பரிமாறும் அளவாகப் பயன்படுத்தவும்.';

  @override
  String get nutrition_page_photo_error => 'புகைப்படத்தை ஏற்ற முடியவில்லை';

  @override
  String get more_photos => 'மேலும் சுவாரஸ்யமான புகைப்படங்கள்';

  @override
  String get view_more_photo_button =>
      'இந்த தயாரிப்புக்கான ஏற்கனவே உள்ள அனைத்து புகைப்படங்களையும் காண்க.';

  @override
  String get no_product_found => 'எந்த தயாரிப்பும் கிடைக்கவில்லை.';

  @override
  String get no_location_found => 'எந்த இடமும் கிடைக்கவில்லை.';

  @override
  String get not_found => 'கிடைக்கவில்லை:';

  @override
  String get refreshing_product => 'புத்துணர்ச்சியூட்டும் தயாரிப்பு';

  @override
  String get product_refreshed => 'தயாரிப்பு புதுப்பிக்கப்பட்டது';

  @override
  String product_image_accessibility_label(String date) {
    return 'படம் எடுக்கப்பட்ட$date அன்று';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return '$dateஅன்று எடுக்கப்பட்ட படம். இந்தப் படம் காலாவதியானதாக இருக்கலாம்.';
  }

  @override
  String get product_image_outdated => 'இந்தப் படம் காலாவதியானதாக இருக்கலாம்.';

  @override
  String get product_image_outdated_explanations_title =>
      'இந்தப் படம் காலாவதியானதாக இருக்கலாம்.';

  @override
  String get product_image_outdated_explanations_content =>
      'இந்தப் படம் ஒரு வருடத்திற்கு முன்பு எடுக்கப்பட்டது.\n**இது இன்னும் புதுப்பித்த நிலையில் உள்ளதா எனப் பார்க்கவும்**.\n\nஇது **வெறும் எச்சரிக்கை**. உள்ளடக்கம் இன்னும் அப்படியே இருந்தால், இந்தச் செய்தியை நீங்கள் புறக்கணிக்கலாம்.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'புகைப்படத்தை மாற்றவும் ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'ஒரு புகைப்படத்தைச் சேர்க்கவும் ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'ஒரு படம் எடு';

  @override
  String get product_image_action_from_gallery =>
      'உங்கள் தொலைபேசியின் கேலரியில் இருந்து தேர்ந்தெடுக்கவும்';

  @override
  String get product_image_action_choose_existing_photo =>
      'தயாரிப்பு புகைப்படங்களிலிருந்து தேர்ந்தெடுக்கவும்';

  @override
  String get product_image_details_label => 'புகைப்படம் பற்றிய தகவல்';

  @override
  String get product_image_details_from_producer => 'தயாரிப்பாளரிடமிருந்து';

  @override
  String get product_image_details_contributor => 'Contributor';

  @override
  String get product_image_details_contributor_producer =>
      'பங்களிப்பாளர் (தயாரிப்பாளர்)';

  @override
  String get product_image_details_date => 'தேதி';

  @override
  String get product_image_details_date_unknown => 'தெரியவில்லை';

  @override
  String get homepage_main_card_logo_description =>
      'திறந்த உணவு உண்மைகளுக்கு வருக.';

  @override
  String get homepage_main_card_subheading =>
      '**பார்கோடை ஸ்கேன்** அல்லது\n**ஒரு பொருளைத் தேடுங்கள்**';

  @override
  String get homepage_main_card_search_field_hint =>
      'ஒரு தயாரிப்பைத் தேடுங்கள்';

  @override
  String get homepage_main_card_search_field_tooltip => 'தேடலைத் தொடங்கு';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'சமீபத்திய செய்திகள்: $news_title';
  }

  @override
  String get tagline_app_review => 'உங்களுக்கு இந்த ஆப்ஸ் பிடிக்குமா?';

  @override
  String get tagline_app_review_button_positive =>
      'எனக்கு ரொம்பப் பிடிச்சிருக்கு! 😍';

  @override
  String get tagline_app_review_button_negative => 'உண்மையில் இல்லை…';

  @override
  String get tagline_app_review_button_later => 'பிறகு கேளுங்கள்.';

  @override
  String get tagline_feed_news_button => 'மேலும் அறிக';

  @override
  String get app_review_negative_modal_title =>
      'எங்கள் பயன்பாடு உங்களுக்குப் பிடிக்கவில்லையா?';

  @override
  String get app_review_negative_modal_text =>
      'ஏன் என்று சொல்ல சில வினாடிகள் ஒதுக்க முடியுமா?';

  @override
  String get app_review_negative_modal_positive_button => 'ஆம், முற்றிலும்!';

  @override
  String get app_review_negative_modal_negative_button => 'இல்லை';

  @override
  String get could_not_refresh => 'தயாரிப்பைப் புதுப்பிக்க முடியவில்லை.';

  @override
  String get product_internet_error_modal_title => 'ஒரு பிழை ஏற்பட்டுள்ளது!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'நெட்வொர்க் பிழை காரணமாக இந்தத் தயாரிப்பு பற்றிய தகவலை எங்களால் பெற முடியவில்லை. உங்கள் இணைய இணைப்பைச் சரிபார்த்து மீண்டும் முயற்சிக்கவும்.\n\nஉள் பிழை:\n$error';
  }

  @override
  String get product_tags_title => 'தயாரிப்பு பண்புகள்';

  @override
  String get no_product_tags_found_message =>
      'தயாரிப்புப் பண்புகள் இல்லை. தயாரிப்புகளை மேலும் விவரங்களில், நெகிழ்வான முறையில் விவரிக்கப் பண்புகலைப் பயன்படுத்தப்படலாம்.';

  @override
  String get product_tags_empty => 'சொத்துக்கள் இல்லை';

  @override
  String get product_tags_explanation =>
      'ஒரு பொருளுக்கு பண்புகளை (திறவுகோல்/மதிப்பு) சேர்ப்பதன் மூலம், நீங்கள் அதை வளப்படுத்த உதவுகிறீர்கள்.';

  @override
  String get add_tag => 'ஒரு குணத்தைச் சேர்க்கவும்';

  @override
  String get add_tags => 'பண்புகளைச் சேர்க்கவும்';

  @override
  String get add_edit_tags => 'பண்புகளைச் சேர்க்கவும் அல்லது திருத்தவும்';

  @override
  String get edit_tag => 'பண்பைத் திருத்து';

  @override
  String get remove_tag => 'சொத்தை அகற்று';

  @override
  String get tag_key => 'சொத்து';

  @override
  String get tag_keys => 'பண்புகள்';

  @override
  String get tag_key_uneditable => 'குணம் (திருத்த முடியாதது)';

  @override
  String get tag_key_input_hint => 'ஒரு குணத்தை உள்ளிடவும்';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'ஒரு மதிப்பை உள்ளிடவும்';

  @override
  String get tag_key_item => 'குணம்:';

  @override
  String get tag_value_item => 'மதிப்பு:';

  @override
  String get tag_key_explanations =>
      'ஒரு சாவி சிறிய எழுத்தாகவும் இடைவெளிகள் இல்லாமலும் இருக்க வேண்டும்.';

  @override
  String tag_key_already_exists(String property) {
    return 'குணம் $property உடன் ஒரு குறிச்சொல் ஏற்கனவே உள்ளது!';
  }

  @override
  String get product_internet_error =>
      'நெட்வொர்க் பிழை காரணமாக இந்தத் தயாரிப்பு பற்றிய தகவலைப் பெறுவது சாத்தியமில்லை.';

  @override
  String get cached_results_from => 'இதிலிருந்து முடிவுகளைக் காட்டு:';

  @override
  String get product_search_same_category => 'மாற்று வழிகளைக் கண்டறியவும்';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'இந்த அம்சத்தை வகையைக் கொண்ட தயாரிப்புகளுக்கு மட்டுமே பயன்படுத்த முடியும்.\n\nவகையைச் சேர்க்க தயாரிப்பைத் திருத்தவும்.';

  @override
  String get product_improvement_add_category =>
      'Add a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Add nutrition facts to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Add nutrition facts and a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'இந்த தயாரிப்புக்கான நியூட்ரி-ஸ்கோரை கணக்கிட முடியாது, இது ஒரு தரமற்ற வகை காரணமாக இருக்கலாம். இது ஒரு பிழையாகக் கருதப்பட்டால், தயவுசெய்து எங்களைத் தொடர்பு கொள்ளவும்.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'ஊட்டச்சத்து படம் காலாவதியானது: தயவுசெய்து அதைப் புதுப்பிக்கவும்.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'பச்சை மதிப்பெண், பொருட்களின் தோற்றத்தை கணக்கில் எடுத்துக்கொள்கிறது. தயவுசெய்து மூலப்பொருள் பட்டியல் மற்றும்/அல்லது ஏதேனும் புவியியல் உரிமைகோரலை புகைப்படம் எடுக்கவும் அல்லது தயாரிப்பைத் திருத்தவும், இதனால் அவை கணக்கில் எடுத்துக்கொள்ளப்படும்.';

  @override
  String get country_chooser_label =>
      'தயவுசெய்து ஒரு நாட்டைத் தேர்ந்தெடுக்கவும்.';

  @override
  String get currency_chooser_label => 'நாணயத்தைத் தேர்வு செய்யவும்';

  @override
  String get country_change_message =>
      'நீங்கள் இப்போதுதான் நாடுகளை மாற்றி இருக்கிறீர்கள்.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'உங்களின் முந்தைய நாணயத்திலிருந்து $previousCurrency சாத்தியமான நாணயத்திற்கு $possibleCurrency மாற்ற விரும்புகிறீர்களா?';
  }

  @override
  String get onboarding_country_chooser_label =>
      'தயவுசெய்து ஒரு நாட்டைத் தேர்ந்தெடுக்கவும்:';

  @override
  String get country_chooser_label_from_settings => 'உங்கள் நாடு';

  @override
  String get country_selection_explanation =>
      'சில சுற்றுச்சூழல் அம்சங்கள் இடம் சார்ந்தவை.';

  @override
  String get product_removed_comparison =>
      'ஒப்பீட்டிலிருந்து தயாரிப்பு அகற்றப்பட்டது';

  @override
  String get native_app_settings => 'சொந்த பயன்பாட்டு அமைப்புகள்';

  @override
  String get native_app_description =>
      'திறந்த உணவு உண்மைகளுக்கான திறந்த அமைப்பு அமைப்புகள்';

  @override
  String get product_removed_history =>
      'வரலாற்றிலிருந்து தயாரிப்பு நீக்கப்பட்டது';

  @override
  String get product_removed_list =>
      'பட்டியலிலிருந்து தயாரிப்பு நீக்கப்பட்டது.';

  @override
  String get product_could_not_remove => 'தயாரிப்பை அகற்ற முடியவில்லை.';

  @override
  String get no_prodcut_in_list => 'இந்தப் பட்டியலில் எந்தப் பொருளும் இல்லை.';

  @override
  String get no_product_in_section => 'இந்தப் பிரிவில் எந்தப் பொருளும் இல்லை.';

  @override
  String get recently_seen_products => 'பார்த்த அனைத்து தயாரிப்புகளும்';

  @override
  String get clear => 'தெளிவு';

  @override
  String get clear_long => 'பட்டியலை காலி செய்.';

  @override
  String get really_clear =>
      'இந்தப் பட்டியலை உண்மையிலேயே நீக்க விரும்புகிறீர்களா?';

  @override
  String pct_match(Object percent) {
    return '$percent% பொருத்தம்';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count நாட்களுக்கு முன்பு',
      one: 'ஒரு நாள் முன்பு',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count மணிநேரங்களுக்கு முன்பு',
      one: 'ஒரு மணி நேரத்திற்கு முன்பு',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count நிமிடங்களுக்கு முன்பு',
      one: 'ஒரு நிமிடத்திற்கு முன்பு',
      zero: 'ஒரு நிமிடத்திற்கும் குறைவான நேரத்திற்கு முன்பு',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count மாதங்களுக்கு முன்பு',
      one: 'ஒரு மாதத்திற்கு முன்பு',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count வாரங்களுக்கு முன்பு',
      one: 'ஒரு வாரத்திற்கு முன்பு',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ஒப்பிடுக $count தயாரிப்புகள்',
      one: 'ஒரு தயாரிப்பை ஒப்பிடுக',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count தேர்ந்தெடுக்கப்பட்ட தயாரிப்புகள்',
      one: 'ஒரு தேர்ந்தெடுக்கப்பட்ட தயாரிப்பு',
      zero: 'தேர்ந்தெடுக்கப்பட்ட தயாரிப்பு இல்லை',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode =>
      'தேர்ந்தெடுக்கப்பட்ட தயாரிப்புகளை ஒப்பிடுக';

  @override
  String get delete_products_mode => 'தேர்ந்தெடுத்த தயாரிப்புகளை நீக்கு';

  @override
  String get select_all_products_mode =>
      'அனைத்து தயாரிப்புகளையும் தேர்ந்தெடுக்கவும்';

  @override
  String get select_none_products_mode => 'எதையும் தேர்ந்தெடுக்க வேண்டாம்';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle =>
      'குறைந்தது இரண்டு தயாரிப்புகளைத் தேர்ந்தெடுக்கவும்.';

  @override
  String get retry_button_label => 'மீண்டும் முயல்க';

  @override
  String get connect_with_us => 'எங்களைத் தொடர்பு கொள்ளுங்கள்';

  @override
  String get tiktok => 'TikTok-இல் எங்களைப் பின்தொடரவும்';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'எங்களை Instagram இல் பின்தொடரவும்';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'X இல் (முன்னர் ட்விட்டர்) எங்களைப் பின்தொடருங்கள்.';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'மாஸ்டோடனில் எங்களைப் பின்தொடருங்கள்';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'BlueSky இல் எங்களைப் பின்தொடருங்கள்.';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'வலைப்பதிவு';

  @override
  String get faq => 'அடிக்கடி கேட்கப்படும் கேள்விகள்';

  @override
  String get discover => 'Discover';

  @override
  String get how_to_contribute => 'பங்களிப்பது எப்படி';

  @override
  String get hint_knowledge_panel_message =>
      'நீங்கள் பார்ப்பதைப் பற்றிய கூடுதல் விவரங்களைப் பெற, கார்டின் எந்தப் பகுதியையும் தட்டலாம். இப்போதே முயற்சிக்கவும்!';

  @override
  String get permissions_page_title => 'கேமரா அணுகல்';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'நீங்கள் உங்கள் மனதை மாற்றிக்கொண்டால், இந்த விருப்பத்தை அமைப்புகளிலிருந்து எந்த நேரத்திலும் இயக்கலாம் அல்லது முடக்கலாம்.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / வெளியீடு: $release)\nமாடல்: $model\nதயாரிப்பு: $product\nசாதனம்: $device\nபிராண்ட்:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nமாடல்: $model\nஉள்ளூர்மயமாக்கப்பட்ட மாடல்: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nஆப் பதிப்பு:$appVersion\nஆப் கட்டமைப்பு எண்:$appBuildNumber\nஆப் தொகுப்பு பெயர்:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'மறுக்கவும்';

  @override
  String get ask_me_later_button_label => 'பின்னர்';

  @override
  String get are_you_sure => 'நீ சொல்வது உறுதியா?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return '$sourceNameமேலும் செல்லவும்';
  }

  @override
  String get onboarding_home_welcome_text1 => 'வரவேற்பு!';

  @override
  String get onboarding_home_welcome_text2 =>
      '**உங்களுக்கும்** **கிரகத்திற்கும்** ஏற்ற உணவைத் தேர்வுசெய்ய உதவும் ஆப்!';

  @override
  String get onboarding_continue_button => 'தொடரவும்';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'உங்கள் முதல் மாதிரி தயாரிப்பை ஏற்றுகிறது.';

  @override
  String get onboarding_welcome_warning =>
      'மன்னிக்கவும், இது எங்கள் உதாரண தயாரிப்பு, நீங்கள் அதைத் திருத்த முடியாது :)';

  @override
  String get product_list_your_ranking => 'உங்கள் தரவரிசை';

  @override
  String get product_list_empty_icon_desc => 'வரலாறு கிடைக்கவில்லை.';

  @override
  String get product_list_empty_title => 'ஸ்கேன் செய்யத் தொடங்கு';

  @override
  String get product_list_empty_message =>
      'ஸ்கேன் செய்யப்பட்ட தயாரிப்புகள் இங்கே தோன்றும், அவற்றைப் பற்றிய விரிவான தகவல்களை நீங்கள் பார்க்கலாம்.';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'தயாரிப்புகள்',
      one: 'தயாரிப்பு',
      zero: 'தயாரிப்பு',
    );
    return 'உங்கள் வரலாற்றில் $_temp0 புதுப்பிக்கிறது';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'தயாரிப்புகள்',
      one: 'தயாரிப்பு',
      zero: 'தயாரிப்பு',
    );
    return '$_temp0 புதுப்பிப்பு முடிந்தது';
  }

  @override
  String get product_list_compare_side_by_side => 'அருகருகே ஒப்பிடுக';

  @override
  String get loading_dialog_default_title => 'தரவைப் பதிவிறக்குகிறது';

  @override
  String get loading_dialog_default_error_message =>
      'தரவைப் பதிவிறக்க முடியவில்லை.';

  @override
  String get account_delete => 'கணக்கை நீக்கு';

  @override
  String get account_delete_title => 'எனது கணக்கை நீக்கு.';

  @override
  String get user_profile => 'கணக்கு';

  @override
  String get user_profile_title_guest => 'நல்வரவு!';

  @override
  String get user_profile_subtitle_guest =>
      'திறந்த உணவு உண்மைகள் சமூகத்தில் சேர உள்நுழையவும் அல்லது பதிவு செய்யவும்.';

  @override
  String user_profile_title_id_email(String email) {
    return 'திறந்த உணவு உண்மைகள் உள்நுழைவு: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'வரவேற்கிறோம் $id!';
  }

  @override
  String get email_subject_account_deletion => 'கணக்கை நீக்கு';

  @override
  String email_body_account_deletion(String userId) {
    return 'வணக்கம், தயவுசெய்து எனது திறந்த உணவு உண்மைகள் கணக்கை நீக்கவும்: $userId';
  }

  @override
  String get settings_app_app => 'விண்ணப்பம்';

  @override
  String get settings_app_data => 'அம்சங்கள் & செயலிழப்பு கண்காணிப்பு';

  @override
  String get settings_app_camera => 'கேமரா';

  @override
  String get settings_app_products => 'தயாரிப்புகள்';

  @override
  String get settings_app_miscellaneous => 'இதர';

  @override
  String get camera_play_sound_title => 'ஸ்கேன் செய்யும்போது ஒலியை இயக்கு.';

  @override
  String get camera_play_sound_subtitle =>
      'ஒவ்வொரு வெற்றிகரமான ஸ்கேன் செய்யும்போதும் பீப் ஒலிக்கும்.';

  @override
  String get camera_window_accessibility_label =>
      'உங்கள் கேமராவைப் பயன்படுத்தி பார்கோடை ஸ்கேன் செய்யுங்கள்';

  @override
  String get app_haptic_feedback_title => 'அதிர்வு & தொடுதல்கள்';

  @override
  String get app_haptic_feedback_subtitle =>
      'சில செயல்களைச் செய்த பிறகு ஏற்படும் அதிர்வுகள் (பார்கோடு டிகோட் செய்யப்பட்டது, தயாரிப்பு அகற்றப்பட்டது…).';

  @override
  String get crash_reporting_toggle_title =>
      'பிழைகள் மற்றும் செயலிழப்புகளைப் புகாரளிக்கவும்';

  @override
  String get crash_reporting_toggle_subtitle =>
      'இயக்கப்பட்டால், செயலிழப்பு அறிக்கைகள் தானாகவே Open Food Facts இன் பிழை கண்காணிப்பு அமைப்பில் சமர்ப்பிக்கப்படும், இதனால் பிழைகள் சரிசெய்யப்பட்டு செயலிழப்பை மேம்படுத்த முடியும்.';

  @override
  String get send_anonymous_data_toggle_title =>
      'அம்சத்தின் பயன்பாட்டை எங்களுக்குத் தெரிவிக்கவும்';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'இயக்கப்பட்டால், அம்சத்தைப் பயன்படுத்துவது தொடர்பான கண்டிப்பாக அநாமதேயத் தகவல்கள், ஓபன் ஃபுட் ஃபேக்ட்ஸ் சர்வர்களுக்கு அனுப்பப்படும், இதன் மூலம் அம்சங்களை மேம்படுத்தும் வகையில் அம்சங்கள் எவ்வாறு பயன்படுத்தப்படுகின்றன என்பதை நாம் புரிந்து கொள்ள முடியும். இல்லையெனில், 0 ஐடி அனுப்பப்படும்.';

  @override
  String get product_edit_photo_title => 'புகைப்படத்தைத் திருத்து';

  @override
  String get permission_photo_error => 'பிழை';

  @override
  String get permission_photo_denied_title =>
      'பார்கோடுகளை ஸ்கேன் செய்ய கேமரா பயன்பாட்டை அனுமதிக்கவும்.';

  @override
  String permission_photo_denied_message(String appName) {
    return 'மேம்பட்ட அனுபவத்திற்கு, $appName உங்கள் கேமராவை அணுக அனுமதிக்கவும். நீங்கள் நேரடியாக பார்கோடுகளை ஸ்கேன் செய்ய முடியும்.';
  }

  @override
  String get permission_photo_denied_button => 'அனுமதி';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'அனுமதி மறுக்கப்பட்டது';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'நீங்கள் முன்பு கேமரா அனுமதியை மறுத்துவிட்டதால், அமைப்புகளில் இருந்து அதை கைமுறையாக அனுமதிக்க வேண்டும்.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'அமைப்புகளைத் திற';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Cancel';

  @override
  String get permission_photo_none_found => 'கேமரா எதுவும் கண்டறியப்படவில்லை.';

  @override
  String get permission_photo_denied => 'கேமரா அணுகல் வழங்கப்படவில்லை.';

  @override
  String get show_product_pictures => 'தயாரிப்பு படங்களைக் காட்டு';

  @override
  String get edit_product_label => 'தயாரிப்பைத் திருத்து';

  @override
  String get edit_product_pending_operations_banner_title =>
      'உங்கள் திருத்தங்களைப் பதிவேற்றுகிறது…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'உங்கள் திருத்தங்கள் **பின்னணியில் அனுப்பப்படுகின்றன** (அல்லது பின்னர் பிழை ஏற்பட்டால்).\nநீங்கள் பிற தயாரிப்புப் புலங்களைத் தொடர்ந்து திருத்தலாம்.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'உங்கள் திருத்தங்கள் **பின்னணியில்** அனுப்பப்படுகின்றன (அல்லது பிழை ஏற்பட்டால் பின்னர் அனுப்பப்படும்).';

  @override
  String get edit_product_label_short => 'திருத்து';

  @override
  String edit_product_form_item_help(String value) {
    return '\"$value\"ஐ எப்படி உள்ளிடுவது?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'காலியாக இல்லாத மதிப்பை உள்ளிடவும்!';

  @override
  String get edit_product_form_item_error_existing =>
      'இந்த மதிப்பு ஏற்கனவே உள்ளது!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'புதிய பிராண்டைச் சேர்க்கவும்';

  @override
  String get edit_product_form_item_add_action_label =>
      'புதிய லேபிளைச் சேர்க்கவும்';

  @override
  String get edit_product_form_item_add_action_store => 'புதிய கடையைச் சேர்';

  @override
  String get edit_product_form_item_add_action_origin =>
      'புதிய மூலத்தைச் சேர்க்கவும்';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'புதிய கண்டறியும் குறியீட்டைச் சேர்க்கவும்.';

  @override
  String get edit_product_form_item_add_action_country => 'புதிய நாட்டைச் சேர்';

  @override
  String get edit_product_form_item_add_action_category => 'புதிய வகையைச் சேர்';

  @override
  String get edit_product_form_item_add_action_trace => 'புதிய தடத்தைச் சேர்';

  @override
  String get edit_product_form_item_add_suggestion => 'பரிந்துரையைச் சேர்';

  @override
  String get edit_product_form_item_deny_suggestion => 'பரிந்துரையை நிராகரி';

  @override
  String get edit_product_form_item_details_title => 'அடிப்படை விவரங்கள்';

  @override
  String get edit_product_form_item_details_subtitle =>
      'தயாரிப்பு பெயர், பிராண்ட், அளவு';

  @override
  String get edit_product_form_item_other_details_title => 'கூடுதல் விவரங்கள்';

  @override
  String get edit_product_form_item_other_details_subtitle => 'வலைத்தளம்…';

  @override
  String get edit_product_form_item_photos_title => 'புகைப்படங்கள்';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'புகைப்படங்களைச் சேர்க்கவும் அல்லது புதுப்பிக்கவும்';

  @override
  String get edit_product_form_item_labels_title => 'லேபிள்கள் & சான்றிதழ்கள்';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'சுற்றுச்சூழல், தர லேபிள்கள்…';

  @override
  String get edit_product_form_item_labels_hint =>
      'ஒரு லேபிளை உள்ளிடவும் (எ. கா: நியூட்ரிஸ்கோர்)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'நல்ல நடைமுறைகள்: லேபிள்கள்';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'தயாரிப்பின் ஏதேனும் பண்பு **உண்மையானது** மற்றும் பிற துறைகளிலிருந்து வேறுபட்டது.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'நியூட்ரி-ஸ்கோர், நோவா…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'பெல்ஜியத்தில் தயாரிக்கப்பட்டது, பிரிட்டானியில் தயாரிக்கப்பட்டது…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'நார்ச்சத்து நிறைந்தது, இரும்பின் மூலமாகும்…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'நியாயமான வர்த்தகம், மேக்ஸ் ஹவேலார்…';

  @override
  String get edit_product_form_item_stores_title => 'கடைகள்';

  @override
  String get edit_product_form_item_stores_hint => 'ஒரு கடையை உள்ளிடவும்';

  @override
  String get edit_product_form_item_stores_type => 'கடை';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'நல்ல நடைமுறைகள்: கடைகள்';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'நீங்கள் பொருளை வாங்கிய கடையின் பெயரை உள்ளிடவும்.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'வால்மார்ட்';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'கேரிஃபோர்';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'லிட்ல்';

  @override
  String get edit_product_form_item_origins_title => 'தோற்றம்';

  @override
  String get edit_product_form_item_origins_hint =>
      'மூலத்தை உள்ளிடவும் (எ. கா: ஜெர்மனி)';

  @override
  String get edit_product_form_item_origins_type => 'country';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'நல்ல நடைமுறைகள்: தோற்றம்';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      '**பேக்கேஜிங்கில் நீங்கள் காணக்கூடிய **எந்தவொரு மூலப்பொருட்களின் அறிகுறிகளையும் சேர்க்கவும்**.\nமூலப்பொருள் பட்டியலில் நேரடியாகக் குறிப்பிடப்பட்டுள்ள மூலப்பொருட்களைப் பற்றி நீங்கள் கவலைப்படத் தேவையில்லை.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'அர்ஜென்டினாவிலிருந்து மாட்டிறைச்சி';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'சோயா ஐரோப்பிய ஒன்றியத்திலிருந்து வரவில்லை.';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'ஒரு நாட்டை உள்ளிடவும் (எ. கா: ஜெர்மனி)';

  @override
  String get edit_product_form_item_countries_type => 'country';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'நல்ல நடைமுறைகள்: நாடுகள்';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**தயாரிப்பு பரவலாகக் கிடைக்கும் நாடுகள்** (வெளிநாட்டு தயாரிப்புகளில் நிபுணத்துவம் பெற்ற கடைகள் சேர்க்கப்படவில்லை).';

  @override
  String get edit_product_form_item_emb_codes_title =>
      'கண்டறியக்கூடிய குறியீடுகள்';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'குறியீட்டை உள்ளிடவும் (எ. கா: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'கண்டறியும் குறியீடு';

  @override
  String get edit_product_form_item_emb_help_title =>
      'நல்ல நடைமுறைகள்: கண்டறியக்கூடிய குறியீடுகள்';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'இந்தப் பிரிவில், **பேக்கேஜிங் மதிப்பெண்கள்**, **அடையாளக் குறிகள்** அல்லது **சுகாதாரக் குறிகள்** தொடர்பான குறியீடுகளை நீங்கள் உள்ளிடலாம்.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'கண்டறியக்கூடிய குறியீடுகளின் எடுத்துக்காட்டுகள்';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      'உணவு உற்பத்தியாளர்கள் அல்லது பேக்கேஜ் செய்பவர்களை அடையாளம் காண ஐரோப்பிய சமூகத்தில் பயன்படுத்தப்படும் **EC குறியீடுகள்**:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: **பிரான்ஸ் நாட்டின் குறியீடு**\n**72.264.002**: புவியியல் தரவு\n**CE**: ஐரோப்பிய சமூகம்';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**பிரான்சில் பயன்படுத்தப்படும் EMB குறியீடுகள்**:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Traces';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'ஒரு சுவடு உள்ளிடவும் (எ.கா: சோயா பீன்ஸ்)';

  @override
  String get edit_product_form_item_categories_title => 'Categories';

  @override
  String get edit_product_form_item_categories_hint => 'category';

  @override
  String get edit_product_form_item_categories_type =>
      'ஒரு வகையை உள்ளிடவும் (எ. கா: ஆரஞ்சு சாறு)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'நல்ல நடைமுறைகள்: வகைகள்';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      '**மிகவும் குறிப்பிட்ட வகையை மட்டும்** குறிப்பிடவும்.\nபெற்றோர் வகைகள் தானாகவே சேர்க்கப்படும்.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'வகை இல்லையா?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'ஒரு வகை **தானியங்கி நிரப்புதலில்** கிடைக்கவில்லை என்றால், அதை எப்படியும் சேர்க்க தயங்க வேண்டாம்.\nஇது உங்கள் நாட்டில் திறந்த உணவு உண்மைகளை மேம்படுத்த எங்களுக்கு உதவும்.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'ஆலிவ் எண்ணெயில் மத்தி';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'அடர் ஆரஞ்சு சாறு';

  @override
  String get edit_product_form_item_exit_title => 'சேமிக்காமல் வெளியேறு?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'இந்தப் பக்கத்தை விட்டு வெளியேறுவதற்கு முன் உங்கள் மாற்றங்களைச் சேமிக்க விரும்புகிறீர்களா?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'மாற்றங்களைச் சேமிக்கவும்';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'மாற்றங்களை நிராகரி';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredients';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'திரையைக் கிள்ளுவதன் மூலம் பெரிதாக்கவும்';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'புகைப்படத்தைப் பெரிதாக்கவோ அல்லது பிரிதாகவோ ஆக்கவும்';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '**பிஞ்ச்-டு-ஜூம் அம்சத்தைப்** பயன்படுத்தி, நீங்கள் புகைப்படத்தைப் பெரிதாக்கலாம் அல்லது சிறிதாக்கலாம்:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'சேர்';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'முதலில் ஒரு உரையை உள்ளிடவும்.';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'அகற்று';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'உங்கள் திருத்தத்தைச் சேமிக்கவும்.';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'உங்கள் திருத்தத்தை ரத்துசெய்';

  @override
  String get edit_product_form_item_packaging_title =>
      'மறுசுழற்சி வழிமுறைகள் புகைப்படம்';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'ஊட்டச்சத்து உண்மைகள்';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'ஊட்டச்சத்து, ஆல்கஹால் உள்ளடக்கம்…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'நல்ல நடைமுறைகள்: ஊட்டச்சத்து உண்மைகள்';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'ஊட்டச்சத்து மதிப்புகள்';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'முதலில், **மதிப்புகள்** வழங்கப்பட்டிருந்தால் தேர்ந்தெடுக்கவும்:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'ஊட்டச்சத்து உண்மைகள்';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'பின்னர், **பேக்கேஜிங்கில் குறிப்பிடப்பட்டுள்ளபடி** ஊட்டச்சத்து மதிப்புகளை உள்ளிடவும். மதிப்பு இல்லை என்றால், நீங்கள் \"கண்\" ஐகானைக் கிளிக் செய்யலாம்.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'புலம் இல்லையா?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'ஏதேனும் உள்ளீடு விடுபட்டிருந்தால், அதைச் சேர்க்க \"பிளஸ்\" ஐகானைக் ** கிளிக் செய்யலாம் (எ.கா: வைட்டமின் டி, மெக்னீசியம்…).';

  @override
  String get edit_product_form_save => 'திருத்து';

  @override
  String get edit_product_ingredients_photo_title => 'பொருட்கள் புகைப்படம்';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'பேக்கேஜிங் புகைப்படம்';

  @override
  String get edit_product_packaging_list_title => 'பேக்கேஜிங் பட்டியல்';

  @override
  String get no_data_available => 'தரவு எதுவும் கிடைக்கவில்லை.';

  @override
  String get product_field_website_title => 'வலைத்தளம்';

  @override
  String get origins_editing_title => 'மூலங்களைத் திருத்தவும்';

  @override
  String get completed_basic_details_btn_text =>
      'அடிப்படை விவரங்களை முடிக்கவும்';

  @override
  String get not_implemented_snackbar_text => 'இன்னும் செயல்படுத்தப்படவில்லை';

  @override
  String get category_picker_page_appbar_text => 'Categories';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'புகைப்படத்திலிருந்து பொருட்களைப் பிரித்தெடுக்கவும்.';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'புகைப்படத்திலிருந்து\nபொருட்களைப் பிரித்தெடுத்தல்';

  @override
  String get edit_ingredients_loading_photo_btn_text =>
      '…புகைப்படத்தை ஏற்றுகிறது';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'நான் ஏன் இந்த செய்தியைப் பார்க்கிறேன்?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      '\"பொருட்களைப் பிரித்தெடுக்கவும்\" அம்சத்தைப் பயன்படுத்த, புகைப்படத்தை முதலில் பதிவேற்ற வேண்டும்.\n\nசில வினாடிகள் காத்திருக்கவும் அல்லது அவற்றை கைமுறையாக உள்ளிடவும்.';

  @override
  String get edit_ingredients_refresh_photo_btn_text =>
      'புகைப்படத்தைப் புதுப்பிக்கவும்';

  @override
  String get edit_packaging_extract_btn_text =>
      'புகைப்படத்திலிருந்து பேக்கேஜிங்\nஐ பிரித்தெடுக்கவும்.';

  @override
  String get edit_packaging_extract_btn_text_short =>
      'பேக்கேஜிங்கை பிரித்தெடுத்தல்';

  @override
  String get edit_packaging_extracting_btn_text =>
      'புகைப்படத்திலிருந்து பேக்கேஜிங்கைப் பிரித்தெடுத்தல்';

  @override
  String get edit_packaging_loading_photo_btn_text =>
      '…புகைப்படத்தை ஏற்றுகிறது';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'நான் ஏன் இந்த செய்தியைப் பார்க்கிறேன்?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      '\"பேக்கேஜிங்கைப் பிரித்தெடு\" அம்சத்தைப் பயன்படுத்த, புகைப்படத்தை முதலில் பதிவேற்ற வேண்டும்.\n\nசில வினாடிகள் காத்திருக்கவும் அல்லது அவற்றை கைமுறையாக உள்ளிடவும்.';

  @override
  String get edit_packaging_refresh_photo_btn_text =>
      'புகைப்படத்தைப் புதுப்பிக்கவும்';

  @override
  String get edit_ocr_extract_failed =>
      'படத்தில் உள்ள உரையைக் கண்டறிய முடியவில்லை.';

  @override
  String get edit_ocr_extract_disabled_title => 'படம் இல்லை!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'உரை பிரித்தெடுத்தல் அம்சத்தைப் பயன்படுத்த, நீங்கள் முதலில் புகைப்படம் எடுக்க வேண்டும்.';

  @override
  String get user_list_dialog_new_title => 'புதிய தயாரிப்புகளின் பட்டியல்';

  @override
  String get user_list_dialog_rename_title => 'பட்டியலை மறுபெயரிடு';

  @override
  String get user_list_subtitle_product => 'பட்டியல்கள்';

  @override
  String get user_list_title => 'உங்களின் பட்டியல்கள்';

  @override
  String get user_list_add_product =>
      'உங்கள் பட்டியல்களில் தயாரிப்பைச் சேர்க்கவும்.';

  @override
  String get user_list_button_new => 'புதிய பட்டியலை உருவாக்கவும்';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'பட்டியலில் சேர்';

  @override
  String get added_to_list_msg => 'பட்டியலில் சேர்க்கப்பட்டது';

  @override
  String get user_list_popup_clear => 'உங்கள் வரலாற்றை அழிக்கவும்';

  @override
  String get user_list_popup_rename => 'மறுபெயரிடு';

  @override
  String get user_list_name_hint => 'எனது பட்டியல்';

  @override
  String get user_list_name_error_empty => 'பெயர் கட்டாயம்';

  @override
  String get user_list_name_error_already =>
      'அந்தப் பெயர் ஏற்கனவே பயன்படுத்தப்பட்டுள்ளது.';

  @override
  String get user_list_name_error_same => 'அதே பெயர்தான்.';

  @override
  String get user_list_name_input_hint => 'பட்டியலின் பெயர்';

  @override
  String get try_again => 'மீண்டும் முயற்சிக்கவும்';

  @override
  String get there_was_an_error => 'ஒரு பிழை ஏற்பட்டது.';

  @override
  String category_picker_no_category_found_message(String items) {
    return '$itemsக்கு எந்த வகையும் கிடைக்கவில்லை.';
  }

  @override
  String get camera_toggle_camera =>
      'பின் மற்றும் முன் கேமராவிற்கு இடையில் மாறவும்';

  @override
  String get camera_toggle_flash =>
      'கேமராவின் ஃபிளாஷை இயக்கவும் அல்லது அணைக்கவும்';

  @override
  String get camera_enable_flash => 'ஃபிளாஷை இயக்கு';

  @override
  String get camera_disable_flash => 'ஃபிளாஷை முடக்கு';

  @override
  String get camera_flash_error_dialog_title => 'ஒரு பிழை ஏற்பட்டது!';

  @override
  String get camera_flash_error_dialog_message =>
      'உங்கள் ஃபிளாஷின் நிலையை மாற்றும்போது பிழை ஏற்பட்டது. உங்கள் ஸ்மார்ட்போனில் டார்ச் ஏற்கனவே இயக்கப்படவில்லை என்பதை உறுதிப்படுத்தவும்.';

  @override
  String get category_picker_no_category_found_button => 'பின்செல்';

  @override
  String get user_preferences_item_accessibility_hint =>
      'உங்கள் உலாவியிலோ அல்லது பயன்பாட்டிலோ (நிறுவப்பட்டிருந்தால்) திறக்க கிளிக் செய்யவும்.';

  @override
  String get dev_preferences_screen_title => 'DEV பயன்முறை';

  @override
  String get dev_preferences_screen_subtitle =>
      'பரிசோதனை அம்சங்கள் மற்றும் மேம்பாட்டு கருவிகளை அணுகவும்';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'ஆன்போர்டிங்கை மீண்டும் தொடங்கு';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'பின்னர் அதை மீண்டும் பார்க்க நீங்கள் பயன்பாட்டை மறுதொடக்கம் செய்ய வேண்டும்.';

  @override
  String get dev_preferences_environment_switch_title =>
      'openfoodfacts.org (PROD) மற்றும் சோதனை env க்கு இடையில் மாறவும்.';

  @override
  String get dev_preferences_test_environment_title =>
      'சூழல் அளவுருக்களைச் சோதிக்கவும்';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'தற்போதைய சோதனைச் சூழலுக்கான அடிப்படை URL: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'சோதனை சூழல் ஹோஸ்ட்';

  @override
  String get dev_preferences_ml_kit_title => 'ML கிட் பயன்படுத்தவும்';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'பிறகு நீங்கள் இந்த செயலியை மறுதொடக்கம் செய்ய வேண்டும்.';

  @override
  String get dev_preferences_product_additional_features_title =>
      'தயாரிப்பு பக்கத்தில் கூடுதல் பொத்தான்';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'அறிவுப் பலகை பொத்தான் மூலம் பொருட்களைத் திருத்தவும்';

  @override
  String get dev_preferences_export_history_title => 'ஏற்றுமதி வரலாறு';

  @override
  String get dev_preferences_export_history_progress_error => 'விதிவிலக்கு';

  @override
  String get dev_preferences_export_history_progress_found =>
      'தயாரிப்பு கண்டுபிடிக்கப்பட்டது';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'தயாரிப்பு கிடைக்கவில்லை.';

  @override
  String get dev_preferences_export_history_dialog_title => 'ஏற்றுமதி வரலாறு';

  @override
  String get dev_preferences_button_positive => 'சரி';

  @override
  String get dev_preferences_button_negative => 'Cancel';

  @override
  String get dev_preferences_migration_title => 'V1 இலிருந்து தரவு இடம்பெயர்வு';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'நிலை: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'வெற்றி அல்லது புதிய நிறுவல்';

  @override
  String get dev_preferences_migration_status_success => 'வெற்றி';

  @override
  String get dev_preferences_migration_status_error => 'பிழை';

  @override
  String get dev_preferences_migration_status_in_progress =>
      'செயல்பாட்டில் உள்ளது';

  @override
  String get dev_preferences_migration_status_required =>
      'தேவை (தொடங்க கிளிக் செய்யவும்)';

  @override
  String get dev_preferences_migration_status_not_started => 'தெரியவில்லை';

  @override
  String get dev_preferences_import_history_subtitle =>
      'வரலாற்றை அழித்து, 3 தயாரிப்புகளை அங்கே வைப்பேன்.';

  @override
  String get dev_preferences_news_custom_url_title =>
      'செய்திகளுக்கான தனிப்பயன் URL';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'JSON கோப்பின் URL:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'அமைக்கப்படவில்லை';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'கடைசி புதுப்பிப்பு: $date';
  }

  @override
  String get product_type_label_food => 'உணவு';

  @override
  String get product_type_label_beauty => 'தனிப்பட்ட பராமரிப்பு';

  @override
  String get product_type_label_pet_food => 'செல்லப்பிராணி உணவு';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'தயாரிப்பு வகை';

  @override
  String get product_type_selection_subtitle =>
      'இந்த தயாரிப்பின் வகையைத் தேர்ந்தெடுக்கவும்.';

  @override
  String get product_type_selection_empty =>
      'நீங்கள் முதலில் ஒரு தயாரிப்பு வகையைத் தேர்ந்தெடுக்க வேண்டும்!';

  @override
  String product_type_selection_already(String productType) {
    return 'நீங்கள் தயாரிப்பு வகையை ($productType) மாற்ற முடியாது!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'தயாரிப்பு பக்கத்தில் விலைகள் பயன்பாட்டிற்கான குறுக்குவழி';

  @override
  String get prices_app_button => 'விலைகள் பயன்பாட்டிற்குச் செல்லவும்';

  @override
  String get prices_website_button => 'திறந்த விலைகள் வலைத்தளத்தில் திறக்கவும்';

  @override
  String get prices_bulk_proof_upload_select =>
      'கேலரியில் இருந்து நேரடியாக விலைக் குறிச்சொற்களைச் சேர்க்கவும்.';

  @override
  String get prices_bulk_proof_upload_warning =>
      'படங்களைத் தேர்ந்தெடுத்த பிறகு, அவற்றைத் திருத்த முடியாது!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'AI ஆல் பிரித்தெடுக்கப்பட்ட விலைகளை சமூகம் சரிபார்க்க அனுமதிக்கவும்.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'பல விலை குறிச்சொற்கள்';

  @override
  String get prices_bulk_proof_upload_title =>
      'மொத்தமாகச் சரிபார்க்கக்கூடிய பதிவேற்றம்';

  @override
  String get prices_bulk_proof_upload_step_selecting =>
      'கோப்புகளைத் தேர்ந்தெடுக்கிறது';

  @override
  String get prices_bulk_proof_upload_step_starting =>
      'பதிவேற்றத்தைத் தொடங்குகிறது';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return '#$index/$countகோப்பை உள்ளூரில் நகலெடுக்கிறது.';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'பதிவேற்றத்தைத் தயார் செய்கிறது #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'படத்தில் தோல்வி #$index/$count';
  }

  @override
  String get prices_generic_title => 'விலைகள்';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count விலைகளைச் சேர்க்கவும்',
      one: 'விலையைச் சேர்க்கவும்',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count விலைகளை அனுப்பு',
      one: 'விலையை அனுப்பு',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'ஒரு பொருளைச் சேர்க்கவும்';

  @override
  String get prices_add_a_price => 'விலையைச் சேர்க்கவும்';

  @override
  String get prices_add_a_receipt => 'ரசீதைச் சேர்க்கவும்';

  @override
  String get prices_add_price_tags => 'விலைக் குறிச்சொற்களைச் சேர்க்கவும்';

  @override
  String prices_barcode_already(String barcode) {
    return 'இந்த பார்கோடு ($barcode) ஏற்கனவே பட்டியலில் உள்ளது!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'இன்னும் தயாரிப்பு இல்லை';

  @override
  String prices_barcode_search_running(String barcode) {
    return '$barcode ஐத் தேடுகிறது அல்லது தேடுகிறோம்';
  }

  @override
  String get prices_barcode_enter => 'பார்கோடை உள்ளிடவும்';

  @override
  String get prices_category_enter => 'பார்கோடு இல்லாத பொருள்';

  @override
  String get prices_per_kilogram => 'ஒரு கிலோகிராமுக்கு விலை';

  @override
  String get prices_per_unit => 'ஒன்றின் விலை';

  @override
  String get prices_per_kilogram_short => ' / கிலோ';

  @override
  String get prices_per_unit_short => ' / அலகு';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'விருப்பத்தேர்வு';

  @override
  String get prices_category_error_mandatory => 'இந்தப் பிரிவு கட்டாயமானது';

  @override
  String get prices_barcode_reader_action => 'பார்கோடு ரீடர்';

  @override
  String get prices_view_prices => 'விலைகளைப் பார்க்கவும்';

  @override
  String get prices_list_title => 'விலைப்பட்டியல்';

  @override
  String get prices_list_count => '\nவிலைகளின் எண்ணிக்கை';

  @override
  String get prices_list_add_new_price => '\nபுதிய விலையைச் சேர்க்கவும்';

  @override
  String get prices_list_empty_title => 'இன்னும் விலை இல்லை!';

  @override
  String get prices_list_empty_subtitle =>
      '**ரசீது** அல்லது **விலை குறிச்சொல்** ஐ ஸ்கேன் செய்வதன் மூலம்\nஐச் சேர்க்கும் முதல் நபராக இருங்கள்!';

  @override
  String get prices_entry_shop_not_found => 'தெரியாத கடை';

  @override
  String prices_entry_menu_title(String user) {
    return '\"$user\" இலிருந்து விலை உள்ளீடு';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'இந்த தயாரிப்புக்கான அனைத்து விலைகளையும் காண்க';

  @override
  String get prices_entry_menu_open_proof => 'ஆதாரத்தைக் காண்க';

  @override
  String get prices_entry_menu_my_prices => 'எனது பிற விலைகளைப் பார்க்கவும்';

  @override
  String get prices_entry_menu_author_prices =>
      'ஆசிரியரின் பிற விலைகளைக் காண்க.';

  @override
  String get prices_entry_menu_shop_prices =>
      'கடையில் உள்ள பிற விலைகளைப் பார்க்கவும்.';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count விலைகள்',
      one: '1 விலை',
    );
    return '$_temp0 $productக்கு';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'அனைத்தும் $count விலைகள்',
      one: 'ஒரே ஒரு விலை',
      zero: 'விலை இன்னும் இல்லை',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'சமீபத்திய $pageSize விலைகள் (மொத்தம்: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'விலை: $price / கடை: \"$location\" / $date இல் \"$user\" ஆல் வெளியிடப்பட்டது';
  }

  @override
  String prices_open_user_proofs(String user) {
    return '\"$user\" இன் திறந்த சான்றுகள்';
  }

  @override
  String get prices_open_proof => 'திறந்த விலைச் சான்று';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'அனைத்தும் $count ஆதாரங்கள்',
      one: 'ஒரே ஒரு ஆதாரம்',
      zero: 'இன்னும் ஆதாரம் இல்லை',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'சமீபத்திய $pageSize சான்றுகள் (மொத்தம்: $total)';
  }

  @override
  String get prices_users_empty_title => 'இன்னும் பங்களிப்பாளர் இல்லை!';

  @override
  String get prices_users_empty_explanation =>
      'விலையைச் சேர்க்கும் முதல் நபராக இருங்கள்!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'சிறந்த $pageSize பங்களிப்பாளர்கள் (மொத்தம்: $total)';
  }

  @override
  String get prices_locations_empty_title => 'இன்னும் கடை இல்லை!';

  @override
  String get prices_locations_empty_explanation =>
      'விலையைச் சேர்க்கும் முதல் நபராக இருங்கள்!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'மேலே $pageSize இடங்கள் (மொத்தம்: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ஆதாரங்கள்',
      one: 'ஒரு ஆதாரம்',
      zero: 'ஆதாரம் இல்லை',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count தயாரிப்புகள்',
      one: 'ஒரு தயாரிப்பு',
      zero: 'தயாரிப்பு இல்லை',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count பயனர்கள்',
      one: 'ஒரு பயனர்',
      zero: 'பயனர் இல்லை',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count விலைகள்',
      one: 'ஒரு விலை',
      zero: 'விலை இல்லை',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'முன்பு சேர்க்கப்பட்ட விலை';

  @override
  String get prices_amount_subtitle => 'தொகை';

  @override
  String get prices_amount_is_discounted => 'தள்ளுபடி உள்ளதா?';

  @override
  String get prices_amount_price_normal => 'விலை';

  @override
  String get prices_amount_price_discounted => 'தள்ளுபடி விலை';

  @override
  String get prices_amount_price_not_discounted => 'அசல் விலை';

  @override
  String get prices_amount_no_product => 'ஒரு தயாரிப்பு காணவில்லை!';

  @override
  String get prices_amount_price_incorrect => 'தவறான மதிப்பு';

  @override
  String get prices_amount_price_mandatory => 'கட்டாய மதிப்பு';

  @override
  String get prices_currency_subtitle => 'நாணயம்';

  @override
  String get prices_date_subtitle => 'தேதி';

  @override
  String get prices_location_subtitle => 'கடை';

  @override
  String get prices_location_find => 'ஒரு கடையைக் கண்டுபிடி.';

  @override
  String get prices_location_mandatory =>
      'நீங்கள் ஒரு கடையைத் தேர்ந்தெடுக்க வேண்டும்!';

  @override
  String get prices_location_search_broader =>
      'நீங்கள் தேடுவதைக் கண்டுபிடிக்க முடியவில்லையா? இன்னும் விரிவாகத் தேட முயற்சிப்போம்!';

  @override
  String get prices_proof_subtitle => 'ஆதாரம்';

  @override
  String get prices_proof_empty_title => 'இன்னும் ஆதாரம் இல்லை!';

  @override
  String get prices_proof_empty_explanation =>
      '**ரசீது** அல்லது **விலை குறி**யின் புகைப்படத்தைச் சேர்ப்பதன் மூலம் தொடங்குங்கள்!';

  @override
  String get prices_proof_find => 'ஒரு சான்றைத் தேர்ந்தெடுக்கவும்';

  @override
  String get prices_proof_change => 'மாற்றச் சான்று';

  @override
  String get prices_proof_receipt => 'ரசீது';

  @override
  String get prices_proof_price_tag => 'விலைக் குறி';

  @override
  String get prices_proof_mandatory =>
      'நீங்கள் ஒரு சான்றைத் தேர்ந்தெடுக்க வேண்டும்!';

  @override
  String get prices_add_validation_error => 'சரிபார்ப்பு பிழை';

  @override
  String get prices_privacy_warning_title => 'தனியுரிமை எச்சரிக்கை';

  @override
  String get prices_unknown_product => 'தெரியாத தயாரிப்பு';

  @override
  String get prices_privacy_warning_main_message =>
      'விலைகள் **பொதுவில் இருக்கும்**, அவர்கள் குறிப்பிடும் கடையுடன் சேர்த்து.\n\nஇது உங்கள் திறந்த உணவு உண்மைகள் புனைப்பெயரைப் பற்றி அறிந்தவர்கள்:\nஎன்று அனுமதிக்கக்கூடும்.';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'நீங்கள் எந்தப் பகுதியில் வசிக்கிறீர்கள் என்று யூகிக்கவும்.';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'நீங்கள் என்ன வாங்குகிறீர்கள் என்பதை அறிந்து கொள்ளுங்கள்';

  @override
  String get prices_privacy_warning_sub_message =>
      'உங்களுக்கு அது சங்கடமாக இருந்தால், தயவுசெய்து உங்கள் புனைப்பெயரை மாற்றவும் அல்லது புதிய Open Food Facts கணக்கை உருவாக்கி அதைப் பயன்படுத்தி செயலியில் உள்நுழையவும்.';

  @override
  String get i_refuse => 'நான் மறுக்கிறேன்.';

  @override
  String get i_accept => 'நான் ஏற்றுக்கொள்கிறேன்';

  @override
  String get prices_currency_change_proposal_title => 'நாணயத்தை மாற்றவா?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'உங்கள் தற்போதைய நாணயத்தை **$currency**. இதை **$newCurrency** ஆக மாற்ற விரும்புகிறீர்களா?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'ஆம், $newCurrency ஐப் பயன்படுத்தவும்';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'இல்லை, $currency வைத்திருங்கள்';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'முடிந்தது';

  @override
  String get dev_mode_section_server => 'சேவையக உள்ளமைவு';

  @override
  String get dev_mode_section_news => 'செய்தி வழங்குநர் உள்ளமைவு';

  @override
  String get dev_mode_section_product_page => 'தயாரிப்பு பக்கம்';

  @override
  String get dev_mode_section_ui => 'பயனர் இடைமுகம்';

  @override
  String get dev_mode_section_experimental_features => 'பரிசோதனை அம்சங்கள்';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'பச்சை மதிப்பெண்ணை விலக்கு';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'OCR திரைகளுக்கு எழுத்துப்பிழை சரிபார்ப்பானைப் பயன்படுத்தவும்.';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(பொருட்கள் மற்றும் பேக்கேஜிங்)';

  @override
  String get dev_mode_reset_app_language_title =>
      'பயன்பாட்டு மொழியை மீட்டமைக்கவும்';

  @override
  String get dev_mode_add_demo_cards_language_title => 'கார்டுகளைச் சேர்';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'prices.openfoodfacts.org (PROD) மற்றும் சோதனை env க்கு இடையில் மாறவும்.';

  @override
  String get search_history_item_edit_tooltip =>
      'இந்த தேடலை மீண்டும் பயன்படுத்தவும் திருத்தவும்.';

  @override
  String get search_history_item_remove_tooltip => 'அகற்று';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'நீங்கள் எல்லா $totalSize தயாரிப்புகளையும் பதிவிறக்கம் செய்துவிட்டீர்கள்.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return '$count மேலும் தயாரிப்புகளைப் பதிவிறக்கவும்\nஏற்கனவே $downloaded இல் $totalSizeபதிவிறக்கப்பட்டது.';
  }

  @override
  String product_search_loading_message(Object search) {
    return '$search க்கான உங்கள் தேடல் நடந்து கொண்டிருக்கிறது.\n\nசில வினாடிகள் காத்திருக்கவும்…';
  }

  @override
  String get user_search_contributor_title => 'நான் சேர்த்த தயாரிப்புகள்';

  @override
  String get user_search_informer_title => 'நான் திருத்திய தயாரிப்புகள்';

  @override
  String get user_search_photographer_title =>
      'நான் புகைப்படம் எடுத்த தயாரிப்புகள்';

  @override
  String get user_search_to_be_completed_title =>
      'எனது முடிக்கப்பட வேண்டிய தயாரிப்புகள்';

  @override
  String get user_search_prices_title => 'எனது விலைகள்';

  @override
  String get user_search_proofs_title => 'எனது சான்றுகள்';

  @override
  String get user_search_proof_title => 'என் ஆதாரம்';

  @override
  String search_proof_title(String user) {
    return '\"$user\" இலிருந்து ஆதாரம்';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'பங்களிப்பாளர் விலைகள்: $user';
  }

  @override
  String get all_search_prices_latest_title =>
      'சமீபத்திய விலைகள் சேர்க்கப்பட்டன';

  @override
  String get all_search_prices_top_user_title => 'அதிக விலை பங்களிப்பாளர்கள்';

  @override
  String get all_search_prices_top_location_title => 'அதிக விலை கொண்ட கடைகள்';

  @override
  String get prices_contribution_assistant => 'விலை பங்களிப்பு உதவியாளர்';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'சவால்கள்';

  @override
  String get prices_multiple_proof_addition_system =>
      'பல சான்றுகளைச் சேர்க்கவும்';

  @override
  String get all_search_prices_top_location_single_title =>
      'ஒரு கடையில் விலைகள்';

  @override
  String get all_search_prices_top_product_title =>
      'அதிக விலை கொண்ட தயாரிப்புகள்';

  @override
  String get all_search_to_be_completed_title =>
      'முடிக்கப்பட வேண்டிய அனைத்து தயாரிப்புகளும்';

  @override
  String get categorize_products_country_title =>
      'உங்கள் நாட்டில் உள்ள பொருட்களை வகைப்படுத்த உதவுங்கள்.';

  @override
  String get edit_product_action_retake_picture => 'புகைப்படத்தை மீண்டும் எடு';

  @override
  String get edit_product_action_take_picture => 'புகைப்படம் எடு';

  @override
  String get edit_product_action_confirm => 'உறுதிப்படுத்தவும்';

  @override
  String get signup_page_terms_of_use_line1 =>
      'திறந்த உணவு உண்மைகளை நான் ஒப்புக்கொள்கிறேன். ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'பயன்பாட்டு விதிமுறைகள் மற்றும் பங்களிப்பு';

  @override
  String get analytics_consent_image_semantic_label => 'பகுப்பாய்வு ஐகான்';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'அபாயகரமான பிழை: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'அபாயகரமான பிழை: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'அடிப்படை விவரங்களை முடிக்கவும்';

  @override
  String get edit_photo_button_label => 'திருத்து';

  @override
  String get edit_photo_unselect_button_label => 'புகைப்படத்தைத் தேர்வுநீக்கு';

  @override
  String get edit_photo_select_existing_button_label =>
      'ஏற்கனவே உள்ள படத்தைத் தேர்ந்தெடுக்கவும்';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'ஒரு படத்தைக் கிளிக் செய்வதன் மூலம் அதைத் தேர்ந்தெடுக்கவும்';

  @override
  String get edit_photo_select_existing_download_label =>
      'ஏற்கனவே உள்ள படங்களை மீட்டெடுக்கிறது…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'இந்த தயாரிப்பு தொடர்பான படங்கள் எதுவும் முன்னர் பதிவேற்றப்படவில்லை.';

  @override
  String get edit_photo_language_not_this_one =>
      'அந்த மொழியில் இன்னும் உருவம் இல்லை';

  @override
  String get edit_photo_language_none => 'இன்னும் எந்த உருவமும் இல்லை';

  @override
  String get category_picker_screen_title => 'Categories';

  @override
  String get basic_details => 'அடிப்படை விவரங்கள்';

  @override
  String get product_name => 'தயாரிப்பு பெயர்';

  @override
  String get product_names => 'தயாரிப்புப் பெயர்கள்';

  @override
  String get add_basic_details_product_name_add_translation =>
      'புதிய மொழிபெயர்ப்பைச் சேர்க்கவும்';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'சரிபார்ப்பதற்கு முன், தொகுப்பில் மொழி இருந்தால் மட்டுமே மொழிபெயர்ப்பைச் சேர்ப்பதை உறுதிசெய்யவும்**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'முன் புகைப்படத்தைப் பார்க்கவும்';

  @override
  String get add_basic_details_product_name_take_photo =>
      'முன் புகைப்படம் எடுக்கவும்';

  @override
  String get add_basic_details_product_name_hint =>
      'தயாரிப்பின் பெயரை உள்ளிடவும் (எ. கா: நுட்டெல்லா)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'இயல்புநிலை மொழியை மாற்றவா?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'தயாரிப்பின் இயல்புநிலை மொழியை \'$language\' என அமைக்க விரும்புகிறீர்களா?';
  }

  @override
  String get explanation_section_good_examples => 'நல்ல உதாரணங்கள்';

  @override
  String get explanation_section_bad_examples => 'மோசமான உதாரணங்கள்';

  @override
  String get add_basic_details_product_name_help_title =>
      'நல்ல நடைமுறைகள்: தயாரிப்பு பெயர்';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'தயாரிப்பு பெயர் **பேக்கேஜிங்கில் அச்சிடப்பட்ட முக்கிய பெயர்**. இது பதிவுசெய்யப்பட்ட வர்த்தக முத்திரையாக இருக்கலாம்.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**குறிப்பு:** தொகுப்பில் மொழி இல்லை என்றால், மொழிபெயர்ப்பைச் சேர்க்க வேண்டாம்**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'நெஸ்கிக்';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'தக்காளி கெட்ச்அப்';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'பெயரில் பிராண்டைச் சேர்க்க வேண்டாம்.';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'தக்காளி கெட்ச்அப் **ஹெய்ன்ஸ் எழுதியது**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      '®, ™, © அல்லது அது போன்ற சின்னங்களைப் பயன்படுத்த வேண்டாம்.';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'நெஸ்கிக்**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count மற்ற மொழிபெயர்ப்பு',
      one: '$count மற்ற மொழிபெயர்ப்பு',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'பிராண்ட் பெயர்';

  @override
  String get brand_names => 'தயாரிப்புப் பெயர்கள்';

  @override
  String get add_basic_details_brand_name_error =>
      'தயவுசெய்து பிராண்ட் பெயரை உள்ளிடவும்.';

  @override
  String get add_basic_details_brand_names_hint =>
      'உள்ளீட்டு பிராண்டுகள் (எ. கா: ஃபெர்ரெரோ)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'நல்ல நடைமுறைகள்: பிராண்டுகள்';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      '**தயாரிப்புகளின் அனைத்து பிராண்டுகளையும்** உள்ளிடவும்.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'முக்கிய பிராண்ட்';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**முக்கிய பிராண்ட்**, பொதுவாக முன் பேக்கில் தெளிவாகக் காட்டப்படும், முதலில் **உள்ளிடப்பட வேண்டும்**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'பிற பிராண்டுகள்';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'ஒரு பெரிய நிறுவனத்தால் **விற்கப்படும்போது**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**ஆக்டிமெல்** **டனோனால்** விற்கப்படுகிறது.';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'அதன் பிராண்டுடன் விற்கப்படும் போது **பல மொழிகளில் மொழிபெயர்க்கப்பட்டுள்ளது**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**இயற்கை பள்ளத்தாக்கு** சில நேரங்களில் **வால் நேச்சர்** என்று எழுதப்படுகிறது.';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'நுடெல்லா';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'ஓரியோ, மொண்டெலெஸ்';

  @override
  String get quantity => 'அளவு மற்றும் எடை';

  @override
  String get add_basic_details_quantity_hint =>
      'எடை மற்றும் தேவைப்பட்டால் அளவை உள்ளிடவும் (எ. கா: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'நல்ல நடைமுறைகள்: அளவு';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'தயாரிப்பில் குறிப்பிடப்பட்டுள்ள மதிப்பை நகலெடுத்து **அலகுகளை மறந்துவிடாதீர்கள்**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 கிராம்** அல்லது **230 கிராம்**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (6 முட்டைகளுக்கு)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 கிராம்**\n(ஒவ்வொன்றும் 150 கிராம் கொண்ட 3 பெட்டிகளைக் கொண்ட தயாரிப்புக்கு)';

  @override
  String get barcode => 'பார்கோடு';

  @override
  String barcode_barcode(String barcode) {
    return 'பார்கோடு: $barcode';
  }

  @override
  String get barcode_invalid_error => 'தவறான பார்கோடு';

  @override
  String get basic_details_add_success =>
      'அடிப்படை விவரங்கள் வெற்றிகரமாக சேர்க்கப்பட்டன.';

  @override
  String get basic_details_add_error =>
      'அடிப்படை விவரங்களைச் சேர்க்க முடியவில்லை. சிறிது நேரம் கழித்து மீண்டும் முயற்சிக்கவும்.';

  @override
  String get clear_search => 'உங்கள் தேடலை அழிக்கவும்';

  @override
  String get confirm_clear =>
      'உங்கள் முழு வரலாற்றையும் அழிக்கப் போகிறீர்கள்: நிச்சயமாகத் தொடர விரும்புகிறீர்களா?';

  @override
  String get alert_clear_selected_user_list =>
      'உங்கள் வரலாற்றில் தேர்ந்தெடுக்கப்பட்ட உருப்படிகளை அழிக்கப் போகிறீர்கள்.';

  @override
  String get confirm_clear_selected_user_list =>
      'நீங்கள் தொடர விரும்புகிறீர்களா?';

  @override
  String get alert_select_items_to_clear =>
      'அழிக்க ஒன்று அல்லது அதற்கு மேற்பட்ட உருப்படிகளைத் தேர்ந்தெடுக்கவும்.';

  @override
  String confirm_clear_user_list(String name) {
    return 'இந்தப் பட்டியலை நீங்கள் அழிக்கப் போகிறீர்கள் ($name): நீங்கள் நிச்சயமாகத் தொடர விரும்புகிறீர்களா?';
  }

  @override
  String get confirm_delete_user_list_title => 'பட்டியலை நீக்கவா?';

  @override
  String confirm_delete_user_list_message(String name) {
    return '\"$name\" பட்டியலை நீக்கப் போகிறீர்கள்.\nதொடர விரும்புகிறீர்களா?';
  }

  @override
  String get confirm_delete_user_list_button => 'ஆம், நான் உறுதி செய்கிறேன்.';

  @override
  String importance_label(String name, String id) {
    return '$name முக்கியத்துவம்: $id';
  }

  @override
  String get user_list_all_title => 'பட்டியல்கள்';

  @override
  String get user_list_all_empty => 'உங்கள் முதல் பட்டியலை உருவாக்கவும்.';

  @override
  String get product_list_select => 'பட்டியலைத் தேர்ந்தெடுக்கவும்';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count தயாரிப்புகள்',
      one: 'ஒரு தயாரிப்பு',
      zero: 'வெற்று பட்டியல்',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'பட்டியலைச் சேர்';

  @override
  String get open_food_preferences_tooltip =>
      'உங்கள் உணவு விருப்பங்களைத் திருத்தவும்';

  @override
  String get add_photo_button_label => 'புகைப்படத்தைச் சேர்';

  @override
  String get add_packaging_photo_button_label =>
      'எந்தவொரு பேக்கேஜிங்/மறுசுழற்சி தகவலின் புகைப்படங்களையும் எடுக்கவும்.';

  @override
  String get add_origin_photo_button_label =>
      'எந்தவொரு மூலத் தகவலின் புகைப்படங்களையும் எடுக்கவும்';

  @override
  String get add_emb_photo_button_label =>
      'எந்தவொரு மூலத் தகவலின் புகைப்படங்களையும் எடுக்கவும்';

  @override
  String get add_label_photo_button_label =>
      'ஏதேனும் லேபிள்கள் மற்றும் சான்றிதழ்கள்பற்றிய தகவல்களைப் புகைப்படம் எடுக்கவும்';

  @override
  String get choose_image_source_title => 'பட மூலத்தைத் தேர்வுசெய்க';

  @override
  String get choose_image_source_body =>
      'தயவுசெய்து ஒரு பட மூலத்தைத் தேர்ந்தெடுக்கவும்.';

  @override
  String get gallery_source_label => 'கேலரி';

  @override
  String get gallery_source_access_denied_dialog_title =>
      'அணுகல் மறுக்கப்பட்டது';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'துரதிர்ஷ்டவசமாக, நீங்கள் முன்பு அனுமதியை மறுத்துவிட்டதால், பயன்பாட்டால் உங்கள் கேலரியை அணுக முடியாது.\n\nஉங்கள் தொலைபேசி அமைப்புகள் -> புகைப்படங்களில் உள்ள பயன்பாட்டு அமைப்புகளுக்குச் செல்லவும்.';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'அமைப்புகளைத் திறக்கவும்';

  @override
  String get share => 'பகிர்க';

  @override
  String share_product_text(String url) {
    return 'இந்த தயாரிப்பை திறந்த உணவு உண்மைகளில் பாருங்கள்: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'இந்த தயாரிப்பை Open Beauty Facts இல் பாருங்கள்: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'இந்த தயாரிப்பை ஓபன் பெட்ஃபுட் உண்மைகளில் பாருங்கள்: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'இந்த தயாரிப்பை திறந்த தயாரிப்புகள் உண்மைகளில் பாருங்கள்: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'திறந்த உணவு உண்மைகளில் எனது தயாரிப்புகளின் பட்டியலைப் பாருங்கள்: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'ஒரு படம் எடு';

  @override
  String get choose_from_gallery => 'கேலரியில் இருந்து தேர்வு செய்யவும்';

  @override
  String get image_upload_queued =>
      'படம் விரைவில் பின்னணியில் பதிவேற்றப்படும்.';

  @override
  String get add_price_queued => 'விலை விரைவில் சேவையகத்திற்கு அனுப்பப்படும்.';

  @override
  String get background_task_title_full_refresh =>
      'உள்நாட்டில் சேமிக்கப்பட்ட அனைத்து தயாரிப்புகளையும் புதுப்பிக்கத் தொடங்குகிறது';

  @override
  String get background_task_title_folksonomy =>
      'உள்ளூரில் சேமிக்கப்பட்ட ஃபோல்க்சனமி புதுப்பிப்புகளுக்கான சேவையக செயல்களைச் செய்யத் தொடங்குகிறது.';

  @override
  String get background_task_title_top_n =>
      'மிகவும் பிரபலமான தயாரிப்புகளின் பதிவிறக்கத்தைத் தொடங்குகிறது';

  @override
  String get expand_nutrition_facts =>
      'ஊட்டச்சத்து உண்மைகள் அட்டவணையை விரிவாக்குங்கள்.';

  @override
  String get expand_nutrition_facts_body =>
      'ஊட்டச்சத்து உண்மைகள் அட்டவணையை விரிவுபடுத்துங்கள்.';

  @override
  String get expand_ingredients => 'பொருட்களை விரிவாக்கு';

  @override
  String get expand_ingredients_body => 'பொருட்கள் பலகையை விரித்து வைக்கவும்.';

  @override
  String get no_internet_connection => 'இணைய இணைப்பு இல்லை';

  @override
  String get world_results_label => 'உலகம் முழுவதும்';

  @override
  String get world_results_action =>
      'உங்கள் தேடலை உலகிற்கு விரிவுபடுத்துங்கள்.';

  @override
  String get copy_to_clipboard => 'நகலெடு';

  @override
  String get paste_from_clipboard => 'கிளிப்போர்டிலிருந்து ஒட்டுக';

  @override
  String get no_data_available_in_clipboard =>
      'உங்கள் கிளிப்போர்டில் தரவு எதுவும் கிடைக்கவில்லை.';

  @override
  String get clipboard_barcode_copy =>
      'பார்கோடை கிளிப்போர்டுக்கு நகலெடுக்கவும்';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'பார்கோடு $barcode கிளிப்போர்டுக்கு நகலெடுக்கப்பட்டது!';
  }

  @override
  String get open_product_website => 'இந்தத் தயாரிப்பை இணையதளத்தில் திறக்கவும்';

  @override
  String get language_picker_label => 'உங்கள் மொழி';

  @override
  String get country_picker_label => 'உங்கள் நாடு';

  @override
  String get currency_picker_label => 'உங்கள் நாணயம்';

  @override
  String get help_with_openfoodfacts => 'OpenFoodFacts தொடர்பான உதவி';

  @override
  String get product_task_background_schedule =>
      'தயாரிப்பு விரைவில் பின்னணியில் புதுப்பிக்கப்படும்.';

  @override
  String get no_email_client_available_dialog_title =>
      'மின்னஞ்சல் பயன்பாடுகள் இல்லை!';

  @override
  String get no_email_client_available_dialog_content =>
      'தயவுசெய்து mobile@openfoodfacts.org என்ற முகவரிக்கு எங்களுக்கு நேரடியாக மின்னஞ்சல் அனுப்புங்கள்.';

  @override
  String get all_images => 'அனைத்து படங்களும்';

  @override
  String get selected_images => 'தேர்ந்தெடுக்கப்பட்ட படங்கள்';

  @override
  String get product_card_remove_product_tooltip => 'தயாரிப்பை அகற்று';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'ஸ்கேன் செய்யப்பட்ட புதிய பார்கோடு: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'கேரோசலில் இருந்து அனைத்து தயாரிப்புகளையும் அகற்று';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'ஒப்பிட்டுப் பார்க்க குறைந்தது இரண்டு தயாரிப்புகளை ஸ்கேன் செய்யவும்.';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'நீங்கள் ஸ்கேன் செய்த தயாரிப்புகளை ஒப்பிடக் கிளிக் செய்யவும்.';

  @override
  String get scan_product_loading =>
      'நீங்கள்\nபார்கோடை ஸ்கேன் செய்துள்ளீர்கள்:';

  @override
  String get scan_product_loading_initial =>
      'இந்த தயாரிப்பை நாங்கள் தேடுகிறோம்!\nசில வினாடிகள் காத்திருக்கவும்…';

  @override
  String get scan_product_loading_long_request =>
      'நாங்கள் இன்னும் இந்தத் தயாரிப்பைத் தேடிக்கொண்டிருக்கிறோம்!\nஏற்றுவதற்கு நீண்ட நேரம் எடுக்கும் என்று நீங்கள் நினைக்கிறீர்களா? நாங்களும்…';

  @override
  String get scan_product_loading_unresponsive =>
      'நாங்கள் இன்னும் இந்தத் தயாரிப்பைத் தேடிக்கொண்டிருக்கிறோம்.\nதேடலை மீண்டும் தொடங்க விரும்புகிறீர்களா?';

  @override
  String get scan_product_loading_restart_button => 'தேடலை மீண்டும் தொடங்கு';

  @override
  String get portion_calculator_description =>
      'ஒரு குறிப்பிட்ட அளவிற்கு ஊட்டச்சத்து உண்மைகளைக் கணக்கிடுங்கள்.';

  @override
  String get portion_calculator_hint => 'அளவு';

  @override
  String get portion_calculator_accessibility =>
      'ஊட்டச்சத்து உண்மைகளைக் கணக்கிட ஒரு அளவை உள்ளிடவும்.';

  @override
  String portion_calculator_error(int min, int max) {
    return '$min மற்றும் $max கிராம் இடையே ஒரு அளவை உள்ளிடவும்';
  }

  @override
  String get portion_calculator_computation_error =>
      'காணாமல் போன தரவு. கணக்கீடு செய்ய முடியவில்லை.';

  @override
  String portion_calculator_result_title(int grams) {
    return '$grams கிராம் (அல்லது மிலி) க்கான ஊட்டச்சத்து தகவல்கள்';
  }

  @override
  String get offline_data => 'ஆஃப்லைன் தரவு';

  @override
  String get ocr_image_upload_instruction =>
      'அதில் உள்ள தகவல்களைத் தானாகப் பிரித்தெடுக்க ஒரு படத்தைப் பதிவேற்றவும்.';

  @override
  String get upload_image => 'புகைப்படத்தைப் பதிவேற்று';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'படத்தைப் பதிவிறக்க முடியவில்லை.';

  @override
  String get image_edit_url_error =>
      'படத்தின் URL அமைக்கப்படாததால் படத்தைத் திருத்த முடியவில்லை.';

  @override
  String get user_picture_source_remember => 'எனது தேர்வை நினைவில்கொள்';

  @override
  String get user_picture_source_ask => 'ஒவ்வொரு முறையும் கேளுங்கள்';

  @override
  String get robotoff_continue => 'தொடரவும்';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count கேள்விகள்',
      one: 'கேள்வி',
    );
    return 'அடுத்தது $_temp0';
  }

  @override
  String get show_password => 'கடவுச்சொல்லைக் காட்டு';

  @override
  String get owner_field_info_title => 'தயாரிப்பாளர் வழங்கிய மதிப்புகள்';

  @override
  String get owner_field_info_message =>
      'அந்த லோகோவுடன், தயாரிப்பாளரால் வழங்கப்பட்ட தரவை நாங்கள் முன்னிலைப்படுத்துகிறோம், மேலும் அதைத் திருத்த முடியாது.';

  @override
  String get owner_field_info_close_button => 'இந்த தகவலை மூடு';

  @override
  String get owner_field_image =>
      'இந்தப் படம் தயாரிப்பாளரால் வழங்கப்பட்டது. இதைத் திருத்த முடியாது.';

  @override
  String get edit_packagings_title => 'பேக்கேஜிங் கூறுகள்';

  @override
  String get edit_packagings_element_add =>
      'ஒரு பேக்கேஜிங் கூறுகளைச் சேர்க்கவும்';

  @override
  String get edit_packagings_completed => 'பேக்கேஜிங் முடிந்தது.';

  @override
  String edit_packagings_element_title(int index) {
    return 'பேக்கேஜிங் கூறு #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'அலகுகளின் எண்ணிக்கை';

  @override
  String get edit_packagings_element_hint_units =>
      'தயாரிப்பில் உள்ள அதே வடிவம் மற்றும் பொருளின் பேக்கேஜிங் அலகுகளின் எண்ணிக்கையை உள்ளிடவும்.';

  @override
  String get edit_packagings_element_field_shape => 'வடிவம்';

  @override
  String get edit_packagings_element_hint_shape =>
      'மறுசுழற்சி வழிமுறைகளில் பட்டியலிடப்பட்டுள்ள வடிவப் பெயரை உள்ளிடவும், அல்லது ஒரு வடிவத்தைத் தேர்ந்தெடுக்கவும்.';

  @override
  String get edit_packagings_element_example_shape => 'பாட்டில்';

  @override
  String get edit_packagings_element_field_material => 'பொருள்';

  @override
  String get edit_packagings_element_hint_material =>
      'குறிப்பிட்ட பொருளைத் தீர்மானிக்க முடிந்தால் அதை உள்ளிடவும் (ஒரு முக்கோணத்திற்குள் ஒரு பொருள் குறியீடு பெரும்பாலும் பேக்கேஜிங் பாகங்களில் காணலாம்), அல்லது உங்களுக்குத் தெரியாவிட்டால் ஒரு பொதுவான பொருளை (எடுத்துக்காட்டாக, பிளாஸ்டிக் அல்லது உலோகம்) உள்ளிடவும்.';

  @override
  String get edit_packagings_element_example_material => 'கண்ணாடி';

  @override
  String get edit_packagings_element_field_recycling => 'மறுசுழற்சி வழிமுறைகள்';

  @override
  String get edit_packagings_element_hint_recycling =>
      'மறுசுழற்சி வழிமுறைகள் தயாரிப்பில் பட்டியலிடப்பட்டிருந்தால் மட்டுமே அவற்றை உள்ளிடவும்.';

  @override
  String get edit_packagings_element_example_recycling => 'மறுசுழற்சி';

  @override
  String get edit_packagings_element_field_quantity =>
      'ஒரு யூனிட்டுக்கு நிகர தயாரிப்பு அளவு';

  @override
  String get edit_packagings_element_hint_quantity =>
      'நிகர எடை அல்லது நிகர அளவை உள்ளிட்டு அலகைக் குறிப்பிடவும் (எடுத்துக்காட்டாக g அல்லது ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'ஒரு காலி அலகின் எடை (கிராம்)';

  @override
  String get edit_packagings_element_hint_weight =>
      'மீதமுள்ள உணவை அகற்றி, எடை போடுவதற்கு முன் பேக்கேஜிங் பகுதியைக் கழுவி உலர வைக்கவும். முடிந்தால், 0.1 கிராம் அல்லது 0.01 கிராம் துல்லியம் கொண்ட அளவைப் பயன்படுத்தவும்.';

  @override
  String get background_task_title => 'நிலுவையில் உள்ள பங்களிப்புகள்';

  @override
  String get background_task_subtitle =>
      'உங்கள் பங்களிப்புகள் எங்கள் சேவையகத்தில் தானாகவே சேமிக்கப்படும், ஆனால் எப்போதும் நிகழ்நேரத்தில் அல்ல.';

  @override
  String get background_task_list_empty =>
      'பின்னணி பணிகள் எதுவும் நிலுவையில் இல்லை.';

  @override
  String get background_task_error_server_time_out => 'சேவையக நேரம் முடிந்தது';

  @override
  String get background_task_error_no_internet =>
      'இணைய இணைப்புப் பிழை. பிறகு முயற்சிக்கவும்.';

  @override
  String get background_task_operation_unknown => 'தெரியாத செயல்பாட்டு வகை';

  @override
  String get background_task_operation_details => 'விரிவான மாற்றங்கள்';

  @override
  String get background_task_operation_image => 'புகைப்பட பதிவேற்றம்';

  @override
  String get background_task_operation_refresh =>
      'புகைப்படம் பதிவேற்றப்பட்ட பிறகு புதுப்பிப்பு தாமதமாகும்.';

  @override
  String get background_task_run_started => 'தொடங்கியது';

  @override
  String get background_task_run_not_started => 'இன்னும் தொடங்கவில்லை.';

  @override
  String get background_task_run_to_be_deleted => 'நீக்கப்பட வேண்டும்';

  @override
  String get background_task_question_stop =>
      'அந்தப் பணியை விரைவில் நிறுத்த விரும்புகிறீர்களா?';

  @override
  String get feed_back => 'கருத்து';

  @override
  String get undo => 'செயல்தவிர்';

  @override
  String get copy_email_to_clip_board => 'மின்னஞ்சலை கிளிப்போர்டுக்கு நகலெடு';

  @override
  String get please_send_us_an_email_to =>
      'தயவுசெய்து எங்களுக்கு கைமுறையாக ஒரு மின்னஞ்சல் அனுப்பவும்';

  @override
  String get email_copied_to_clip_board =>
      'மின்னஞ்சல் கிளிப்போர்டுக்கு நகலெடுக்கப்பட்டது!';

  @override
  String get select_accent_color => 'உச்சரிப்பு நிறத்தைத் தேர்ந்தெடுக்கவும்';

  @override
  String get theme_amoled => 'அமோலேட்';

  @override
  String get color_blue => 'நீலம்';

  @override
  String get color_cyan => 'சியான்';

  @override
  String get color_green => 'பச்சை';

  @override
  String get color_light_brown => 'இயல்புநிலை';

  @override
  String get color_magenta => 'மெஜந்தா';

  @override
  String get color_orange => 'ஆரஞ்சு';

  @override
  String get color_pink => 'இளஞ்சிவப்பு';

  @override
  String get color_red => 'சிவப்பு';

  @override
  String get color_rust => 'துரு';

  @override
  String get color_teal => 'நீலம்';

  @override
  String get text_contrast_mode => 'உரை மாறுபாடு';

  @override
  String get contrast_high => 'உயர்';

  @override
  String get contrast_medium => 'நடுத்தரம்';

  @override
  String get contrast_low => 'குறைந்த';

  @override
  String get product_refresher_internet_not_found => 'தயாரிப்பு கிடைக்கவில்லை!';

  @override
  String get product_refresher_internet_not_connected =>
      'நீங்கள் இணையத்துடன் இணைக்கப்படவில்லை!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'சேவையகம் செயலிழந்தது ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'சர்வர் பிழை ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'தயாரிப்பு கிடைக்கவில்லை!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'பின்வரும் பார்கோடு கொண்ட தயாரிப்பு எங்கள் தரவுத்தளத்தில் இல்லை: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'இணைய இணைப்பு இல்லை!';

  @override
  String get product_loader_network_error_message =>
      'உங்கள் ஸ்மார்ட்போன் வைஃபை நெட்வொர்க்கில் உள்ளதா அல்லது மொபைல் டேட்டா இயக்கப்பட்டுள்ளதா என்பதைச் சரிபார்க்கவும்.';

  @override
  String get page_not_found_title => 'பக்கம் கிடைக்கவில்லை!';

  @override
  String get page_not_found_button => 'முகப்புப் பக்கத்திற்குத் திரும்பு';

  @override
  String get download_data => 'தரவைப் பதிவிறக்கு';

  @override
  String get download_top_products =>
      'உடனடி ஸ்கேனிங்கிற்காக உங்கள் நாட்டில் உள்ள சிறந்த 1000 தயாரிப்புகளைப் பதிவிறக்கவும்.';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count பொருட்கள்',
      one: '',
    );
    return 'மேலே பதிவிறக்கவும் $_temp0 உடனடி ஸ்கேன் செய்ய உங்கள் நாட்டில்';
  }

  @override
  String get download_in_progress =>
      'தரவைப் பதிவிறக்குகிறது\nஇதற்கு சிறிது நேரம் ஆகலாம்';

  @override
  String downloaded_products(int num) {
    return '$num தயாரிப்புகள் சேர்க்கப்பட்டன';
  }

  @override
  String get update_offline_data => 'ஆஃப்லைன் தயாரிப்பு தரவைப் புதுப்பிக்கவும்';

  @override
  String get update_local_database_sub =>
      'திறந்த உணவு உண்மைகளிலிருந்து சமீபத்திய தரவுகளுடன் உள்ளூர் தயாரிப்பு தரவுத்தளத்தைப் புதுப்பிக்கவும்.';

  @override
  String get clear_local_database => 'ஆஃப்லைன் தயாரிப்பு தரவை அழி';

  @override
  String get clear_local_database_sub =>
      'இடத்தைக் காலியாக்க, உங்கள் பயன்பாட்டிலிருந்து அனைத்து உள்ளூர் தயாரிப்புத் தரவையும் அழிக்கவும்.';

  @override
  String deleted_products(int num) {
    return '$num தயாரிப்புகள் நீக்கப்பட்டன';
  }

  @override
  String get loading => 'ஏற்றுகிறது…';

  @override
  String get know_more => 'மேலும் அறிக';

  @override
  String get offline_data_desc =>
      'ஆஃப்லைன் தரவு பற்றி மேலும் அறிய கிளிக் செய்யவும்.';

  @override
  String get offline_product_data_title => 'ஆஃப்லைன் தயாரிப்பு தரவு';

  @override
  String available_for_download(int num) {
    return 'உடனடி ஸ்கேனிங்கிற்குக் கிடைக்கும் $num தயாரிப்புகள்';
  }

  @override
  String get country_selector_title => 'உங்கள் நாட்டைத் தேர்ந்தெடுக்கவும்:';

  @override
  String get currency_selector_title => 'உங்கள் நாணயத்தைத் தேர்ந்தெடுக்கவும்:';

  @override
  String get language_selector_title => 'உங்கள் மொழியைத் தேர்ந்தெடுக்கவும்:';

  @override
  String get language_selector_section_selected =>
      'தேர்ந்தெடுக்கப்பட்ட மொழிகள்';

  @override
  String get language_selector_section_frequently_used =>
      'அடிக்கடி பயன்படுத்தப்படுபவை';

  @override
  String get action_delete_list => 'நீக்கு';

  @override
  String get action_change_list => 'தற்போதைய பட்டியலை மாற்றவும்.';

  @override
  String get product_list_create => 'உருவாக்கு';

  @override
  String get product_list_create_tooltip => 'புதிய பட்டியலை உருவாக்கவும்';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (New calculation)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (New calculation)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'தெரியாத Nutri-Score (புதிய கணக்கீடு)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score is not applicable';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score பொருந்தாது (புதிய கணக்கீடு)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Green-Score A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => 'தெரியாத Green-Score';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score பொருந்தாது.';

  @override
  String get nova_group_generic_new =>
      'மிகவும் பதப்படுத்தப்பட்ட உணவுகள் - NOVA குழுக்கள்';

  @override
  String get nova_group_1 => 'NOVA Group 1';

  @override
  String get nova_group_2 => 'NOVA Group 2';

  @override
  String get nova_group_3 => 'NOVA Group 3';

  @override
  String get nova_group_4 => 'NOVA Group 4';

  @override
  String get nova_group_unknown => 'தெரியாத NOVA குழு';

  @override
  String get nutrition_facts => 'ஊட்டச்சத்து அளவுகள்';

  @override
  String get faq_title_partners =>
      'அரசு சாரா நிறுவனத்தின் கூட்டாளிகள் & புரவலர்கள்';

  @override
  String get faq_title_vision =>
      'திறந்த உணவு உண்மைகள் தொலைநோக்கு, நோக்கம், மதிப்புகள் மற்றும் திட்டங்கள்';

  @override
  String get faq_title_install_beauty =>
      'ஒரு அழகுசாதன தரவுத்தளத்தை உருவாக்க திறந்த அழகு உண்மைகளை நிறுவவும்.';

  @override
  String get faq_title_install_pet =>
      'செல்லப்பிராணி உணவு தரவுத்தளத்தை உருவாக்க திறந்த செல்லப்பிராணி உணவு உண்மைகளை நிறுவவும்.';

  @override
  String get faq_title_install_product =>
      'பொருட்களின் ஆயுளை நீட்டிக்க ஒரு தயாரிப்பு தரவுத்தளத்தை உருவாக்க திறந்த தயாரிப்புகள் உண்மைகளை நிறுவவும்.';

  @override
  String get faq_nutriscore_nutriscore =>
      'நியூட்ரி-ஸ்கோரின் புதிய கணக்கீடு: புதியது என்ன?';

  @override
  String get contact_title_pro_page =>
      'ப்ரோவா? திறந்த உணவு உண்மைகளில் உங்கள் தயாரிப்புகளை இறக்குமதி செய்யுங்கள்.';

  @override
  String get contact_title_pro_email => 'தயாரிப்பாளர் தொடர்பு';

  @override
  String get contact_title_press_page => 'பக்கத்தை அழுத்தவும்';

  @override
  String get contact_title_press_email => 'தொடர்பு என்பதை அழுத்தவும்';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'எங்கள் சமூக நாட்காட்டியில் குழுசேரவும்';

  @override
  String get hunger_games_loading_line1 =>
      'தயவுசெய்து எங்களுக்கு சில வினாடிகள் கொடுங்கள்…';

  @override
  String get hunger_games_loading_line2 =>
      'நாங்கள் கேள்விகளைப் பதிவிறக்குகிறோம்!';

  @override
  String get hunger_games_error_label =>
      'ஐயோ! ஏதோ தவறாகிவிட்டது… , எங்களால் கேள்விகளை ஏற்ற முடியவில்லை.';

  @override
  String get hunger_games_error_retry_button => 'மீண்டும் முயற்சிப்போம்!';

  @override
  String get reorder_attribute_action => 'பண்புக்கூறுகளை மறுவரிசைப்படுத்து';

  @override
  String get link_cant_be_opened =>
      'இந்த இணைப்பை உங்கள் சாதனத்தில் திறக்க முடியாது. உங்களிடம் உலாவி நிறுவப்பட்டுள்ளதா எனச் சரிபார்க்கவும்.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return '$productNameக்கான விவரங்கள்';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return '$pageName க்கான விவரங்கள் $productNameஉடன்';
  }

  @override
  String get guide_title => 'கையேடு';

  @override
  String get guide_share_label => 'பகிர்க';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'புதிய நியூட்ரி-ஸ்கோர் கணக்கீட்டை எங்கே கண்டுபிடிப்பது?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'நியூட்ரி-ஸ்கோர் பிரான்ஸ், ஜெர்மனி, பெல்ஜியம், ஸ்பெயின், லக்சம்பர்க், நெதர்லாந்து மற்றும் சுவிட்சர்லாந்து ஆகிய 7 நாடுகளில் பயன்படுத்தப்படுகிறது.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'ஆணையில் கையொப்பமிட்ட பிறகு, பழைய கணக்கீட்டை புதிய கணக்கீட்டால் மாற்றுவதற்கு உற்பத்தியாளர்கள் அதிகபட்சம் **2 ஆண்டுகள்** அவகாசம் அளிக்கின்றனர்.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'கிரீன் ஸ்கோர் என்றால் என்ன?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score என்பது **உணவின் சுற்றுச்சூழல் தாக்கம்** பற்றி உங்களுக்குத் தெரிவிப்பதை நோக்கமாகக் கொண்ட ஒரு லோகோ ஆகும்.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      '**குறைந்த தாக்கத்தை ஏற்படுத்தும்** தயாரிப்புகளுக்கு வண்ணக் குறியீடு அடர் பச்சை (**A+**) இலிருந்து **மிகவும் தாக்கத்தை ஏற்படுத்தும்** தயாரிப்புகளுக்கு அடர் சிவப்பு (**F**) வரை மாறுபடும்.';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score லோகோக்கள்';

  @override
  String get guide_greenscore_lca_title =>
      'அடிப்படை: வாழ்க்கைச் சுழற்சி மதிப்பீடு (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'உணவு வகைகளின் அறிவியல் மதிப்பீடு';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'ஒவ்வொரு தயாரிப்பு வகைக்கும், Agribalyse சுற்றுச்சூழல் தரவுத்தளத்திலிருந்து (ADEME மற்றும் INRAE ஆல் வடிவமைக்கப்பட்டது) தரவைப் பயன்படுத்தி ஒரு **பெஞ்ச்மார்க்** மதிப்பெண் நிறுவப்படுகிறது.';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**வாழ்க்கைச் சுழற்சி பகுப்பாய்வு** என்பது பல-நிலை மற்றும் பல-அளவுகோல்களைக் கொண்ட சுற்றுச்சூழல் மதிப்பீட்டை மேற்கொள்வதற்கான ஒரு தரப்படுத்தப்பட்ட மதிப்பீட்டு முறையாகும்.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**இது அளவிடுகிறது:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 உற்பத்தி படிகள்';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Packaging';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 சுற்றுச்சூழல் தாக்க குறிகாட்டிகள்';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'காலநிலை மாற்றம்/கார்பன் தடம்';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'ஓசோன் படலக் குறைவு';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'அயனியாக்கும் கதிர்வீச்சு';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'நாடு';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'நீர் மற்றும் ஆற்றல் பயன்பாடு';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'காற்று மாசுபாடு';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'கடல் மற்றும் நன்னீர் (துகள்கள், அமிலமயமாக்கல், யூட்ரோஃபிகேஷன்)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'வளங்கள் குறைதல்.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'போனஸ் & அபராதங்கள்';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'ஒரு வகைக்குள் சிறந்த தயாரிப்புகளுக்கு வெகுமதி அளிக்க, நாங்கள் பல அளவுகோல்களின் அடிப்படையில் **போனஸ்கள் மற்றும் அபராதங்களைப் பயன்படுத்துகிறோம்**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**அதிகாரப்பூர்வ லேபிள், லேபிள் அல்லது சுற்றுச்சூழல் நன்மைகளை உத்தரவாதம் செய்யும் சான்றிதழ்** (ஆர்கானிக், நியாயமான வர்த்தகம், HVE, லேபிள் ரூஜ், ப்ளூ பிளாங்க் கோர், MSC/ASC) கொண்ட தயாரிப்புகளுக்கு **போனஸ்** வழங்கப்படுகிறது.';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origin of ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'மூலப்பொருட்களின் தோற்றத்தின் அடிப்படையில் **போனஸ்** வழங்கப்படுகிறது. இந்த போனஸ், ஒவ்வொரு உற்பத்தியாளரின் நாட்டின் **போக்குவரத்தில் ஏற்படும் தாக்கத்தையும்** **சுற்றுச்சூழல் கொள்கையையும்** கணக்கில் எடுத்துக்கொள்கிறது.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'பல்லுயிர் பெருக்கம் மற்றும் சுற்றுச்சூழல் அமைப்புகளில் குறிப்பிடத்தக்க **எதிர்மறை தாக்கங்களை ஏற்படுத்தும்** பொருட்களைக் கொண்ட தயாரிப்புகளுக்கு **அபராதம்** வழங்கப்படுகிறது, எடுத்துக்காட்டாக பாமாயில் உற்பத்தி, அதன் உற்பத்தியே பாரிய காடழிப்புக்கு காரணமாகிறது.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Packaging';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**பேக்கேஜிங்கின் **சுற்றளவு** (மறுசுழற்சி செய்யப்பட்ட மூலப்பொருட்களின் பயன்பாடு மற்றும் மறுசுழற்சி செய்யும் திறன்) மற்றும் அதிகப்படியான பேக்கிங் ஆகியவற்றைக் கணக்கில் எடுத்துக்கொண்டு **அபராதம்** கணக்கிடப்படுகிறது.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'கிரீன்-ஸ்கோரை துல்லியமாகக் கணக்கிட, **பேக்கேஜிங்கில் அவசியம் குறிப்பிடப்படாத தகவல்கள்** (ஒவ்வொரு மூலப்பொருளின் தோற்றம் மற்றும் சரியான சதவீதம் போன்றவை) அல்லது பயன்படுத்தக்கூடிய வடிவத்தில் அரிதாகவே கிடைக்கும் தகவல்கள் (பயன்படுத்தப்படும் துல்லியமான பிளாஸ்டிக் வகைகளுடன் பேக்கேஜிங்கின் அனைத்து கூறுகளின் பட்டியல் போன்றவை) இருப்பது அவசியம்.';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**இந்தத் தகவல் இன்னும் கிடைக்காதபோது சராசரி மதிப்புகள் பயன்படுத்தப்படுகின்றன**, ஆனால் இந்தத் தகவலைச் சேகரிக்க அனைவரும் உதவுமாறு நாங்கள் இப்போது அழைக்கிறோம், இது கிரீன்-ஸ்கோருக்கு மட்டுமல்ல, பல பயன்பாடுகளுக்கும் மிகவும் பயனுள்ளதாக இருக்கும்.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'குடிமக்கள் எவ்வாறு உதவ முடியும்?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      '**பேக்கேஜிங்** பற்றிய தகவல்கள்: \"மிஷன் எம்பாலேஜ்கள்\": அனைத்து உணவுப் பொருட்களுக்கும் (பிரெஞ்சு மொழியில்) பெரிய அளவிலான கூட்டுப் பேக்கேஜிங் சரக்கு போன்ற தயாரிப்புகளில் உள்ள அல்லது அவற்றிலிருந்து பெறக்கூடிய தகவல்களைச் சேகரித்து வடிவமைக்க அனைத்து குடிமக்களும் எங்களுக்கு உதவ முடியும்.';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'உற்பத்தியாளர்கள் எவ்வாறு உதவ முடியும்';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'உற்பத்தியாளர்கள் எங்கள் இலவச தயாரிப்பாளர் தளத்தின் மூலம் தங்கள் தகவல்களை நேரடியாக எங்களுக்கு அனுப்பலாம்.';

  @override
  String get guide_greenscore_better_product_title =>
      'எந்த தயாரிப்பு கிரகத்திற்கு சிறந்தது?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'சொல்ல கடினமாக இருக்கலாம்.';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      '**நமது உலகளாவிய உணவு முறை அனைத்து பசுமை இல்ல வாயு வெளியேற்றங்களிலும் கால் பங்கிற்கும் மேலாக பொறுப்பேற்பதால்**, நிலையான உணவைத் தேர்ந்தெடுப்பது காலநிலைக்கு நாம் செய்யக்கூடிய மிக சக்திவாய்ந்த விஷயங்களில் ஒன்றாகும்.\n(ஆதாரம்: பூரே & நெமெசெக், அறிவியல், 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title =>
      'உங்களிடம் சக்தி இருக்கிறது!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'நல்ல செய்தி என்னவென்றால், இது மாற்றத்தை உருவாக்க ஒரு சக்திவாய்ந்த வழியை நமக்கு வழங்குகிறது.\n**நாம் ஒவ்வொருவரும் ஒவ்வொரு வருடமும் சுமார் 1,000 உணவுகளை சாப்பிடுகிறோம்**. அது **இந்த கிரகத்திற்கு சிறந்த எதிர்காலத்தைத் தேர்ந்தெடுப்பதற்கான** 1,000 வாய்ப்புகள்!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'பொறுப்பாக இருந்து முடிவெடுக்க உதவுகிறது.';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'நிலையான உணவைத் தேர்ந்தெடுப்பது சிக்கலானதாகத் தோன்றலாம். லேபிள்கள் குழப்பமானவை, மேலும் தகவல்கள் பெரும்பாலும் காணாமல் போகின்றன. Green-Score அதை எளிமையாக்க உருவாக்கப்பட்டது, உங்களுக்குத் தேவையான இடத்தில்: நீங்கள் ஷாப்பிங் செய்யும் போது உணவுப் பொருட்களுக்கு **தெளிவான**, **அறிவியல் அடிப்படையிலான** மற்றும் **வெளிப்படையான** சுற்றுச்சூழல் மதிப்பீட்டை வழங்குகிறது.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'வெளிப்படைத்தன்மை';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'தனியுரிம லேபிள்களைப் போலன்றி, Green-Score கணக்கீடு **முற்றிலும் திறந்திருக்கும்** மற்றும் **எவராலும் சரிபார்க்கப்படலாம்**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'அல்ட்ரா-பிராசசிங் என்றால் என்ன?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'உணவு பதப்படுத்துதலின் அளவைப் பற்றி NOVA குழுக்கள் உங்களுக்குத் தெரிவிக்கின்றன.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      '**தொழில்துறை செயலாக்கத்தின்** (குறைந்தபட்ச பதப்படுத்தப்பட்ட அல்லது பதப்படுத்தப்படாத உணவுகள், சமையல் பொருட்கள், பதப்படுத்தப்பட்ட உணவுகள், தீவிர பதப்படுத்தப்பட்ட உணவுகள்) அடிப்படையில் உணவுகளை **4 குழுக்களாக** வகைப்படுத்த NOVA வகைப்பாடு அனுமதிக்கிறது.';

  @override
  String get guide_nova_logos_caption => 'NOVA லோகோக்கள்';

  @override
  String get guide_nova_groups_title => '4 NOVA குழுக்கள்';

  @override
  String get guide_nova_groups_intro =>
      '4 NOVA குழுக்கள் உள்ளன, அவற்றில் சிக்கலானது குழு 4 - அல்ட்ரா-பதப்படுத்தப்பட்ட உணவுகள்.';

  @override
  String get guide_nova_groups_arg1_title =>
      'குறைந்தபட்சமாக பதப்படுத்தப்பட்ட அல்லது பதப்படுத்தப்படாத உணவுகள்';

  @override
  String get guide_nova_groups_arg1_text =>
      'unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'அல்ட்ரா-பிராசசிங்கில் உள்ள சிக்கல்கள்';

  @override
  String get guide_nova_explanations_arg1_title =>
      'உணவுப் பொருட்களின் தீவிர செயலாக்கம்';

  @override
  String get guide_nova_explanations_arg1_text =>
      'ஹைட்ரஜனேற்றப்பட்ட அல்லது ஆர்வமூட்டும் எண்ணெய்கள், ஹைட்ரோலைஸ் செய்யப்பட்ட புரதங்கள், சோயா புரதம் தனிமைப்படுத்தல், மால்டோடெக்ஸ்ட்ரின், தலைகீழ் சர்க்கரை மற்றும் உயர்-பிரக்டோஸ் கார்ன் சிரப் போன்ற உணவுப் பொருட்களின் மேலும் செயலாக்கத்திலிருந்து பல **பெறப்படுகின்றன.**';

  @override
  String get guide_nova_explanations_arg2_title =>
      'தூய உணவுப் பாதுகாப்பைத் தாண்டிச் செல்லும் சேர்க்கைகள்';

  @override
  String get guide_nova_explanations_arg2_text =>
      'பதப்படுத்தப்பட்ட உணவுகளில் பயன்படுத்தப்படும் சேர்க்கைப் பொருட்களில் பதப்படுத்தப்பட்ட உணவுகளிலும் பயன்படுத்தப்படும் சில பொருட்கள் அடங்கும், அதாவது பாதுகாப்புப் பொருட்கள், ஆக்ஸிஜனேற்றிகள் மற்றும் நிலைப்படுத்திகள். பதப்படுத்தப்பட்ட தயாரிப்புகளில் மட்டுமே காணப்படும் சேர்க்கைப் பொருட்களின் வகைகளில் **உணவுகளின் உணர்ச்சித் தரங்களைப் பின்பற்ற அல்லது மேம்படுத்த அல்லது இறுதிப் பொருளின் விரும்பத்தகாத அம்சங்களை மறைக்கப் பயன்படுத்தப்படும் சேர்க்கைப் பொருட்கள் அடங்கும்**. இந்தச் சேர்க்கைப் பொருட்களில் சாயங்கள் மற்றும் பிற வண்ணங்கள், வண்ண நிலைப்படுத்திகள்; சுவைகள், சுவையை அதிகரிக்கும் பொருட்கள், சர்க்கரை அல்லாத இனிப்புப் பொருட்கள்; மற்றும் கார்பனேட்டிங், ஃபர்மிங், பல்கிங் மற்றும் ஆன்டி-பல்கிங் ஏஜென்ட்கள், டி-ஃபோமிங், ஆன்டி-கேக்கிங் மற்றும் மெருகூட்டல் ஏஜென்ட்கள், குழம்பாக்கிகள், சீக்வெஸ்ட்ரான்ட்கள் மற்றும் ஈரப்பதமூட்டிகள் போன்ற செயலாக்க உதவிகள் அடங்கும்.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'வீட்டிலேயே செய்ய முடியாத செயலாக்கம்';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**பொதுவாக பல பொருட்களை ஒன்றிணைத்து இறுதி தயாரிப்பை உருவாக்க (எனவே \'மிகவும் பதப்படுத்தப்பட்ட\') பல செயல்முறைகள் பயன்படுத்தப்படுகின்றன. இந்த செயல்முறைகளில் **உள்நாட்டு சமமானவை இல்லாத** பல அடங்கும், அதாவது ஹைட்ரஜனேற்றம் மற்றும் நீராற்பகுப்பு, வெளியேற்றம் மற்றும் மோல்டிங், மற்றும் வறுக்க முன் செயலாக்கம்.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'அல்ட்ரா-பிராசசிங்கின் கொள்ளையடிக்கும் மற்றும் நிதி அம்சங்கள்';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**அதிக பதப்படுத்தலின் ஒட்டுமொத்த நோக்கம், மற்ற அனைத்து உணவுக் குழுக்களையும் மாற்றுவதற்காக வடிவமைக்கப்பட்ட பிராண்டட்**, **வசதியான** (நீடித்த, உட்கொள்ளத் தயாராக), **கவர்ச்சிகரமான** (மிகவும் சுவையான) மற்றும் **அதிக லாபகரமான** (குறைந்த விலை பொருட்கள்) உணவுப் பொருட்களை உருவாக்குவதாகும். அல்ட்ரா பதப்படுத்தப்பட்ட உணவுப் பொருட்கள் பொதுவாக கவர்ச்சிகரமான முறையில் பேக் செய்யப்பட்டு தீவிரமாக சந்தைப்படுத்தப்படுகின்றன.';

  @override
  String get guide_nova_explanations_arg5_title => 'உடல்நலக் கேடு';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'நாடுகள் அவற்றைக் கட்டுப்படுத்த பரிந்துரைக்கின்றன';

  @override
  String get guide_nova_explanations_arg6_text =>
      'சில நாடுகள் தங்கள் உணவு வழிகாட்டுதல்கள் அல்லது இலக்குகளுக்கு NOVA குழுக்களைப் பயன்படுத்துகின்றன, எடுத்துக்காட்டாக:\n\n- **🇧🇷 பிரேசிலின்** உணவு வழிகாட்டுதல்கள் **பதப்படுத்தப்பட்ட உணவின் நுகர்வை** குறைக்கவும், மிகை பதப்படுத்தப்பட்ட உணவைத் தவிர்க்கவும் பரிந்துரைக்கின்றன.\n\n- **🇫🇷 2018-2022 ஆம் ஆண்டிற்கான பிரான்சின்** பொது சுகாதார ஊட்டச்சத்து கொள்கை இலக்குகள் **குழு 4 மிகை பதப்படுத்தப்பட்ட உணவுகளின் நுகர்வை 20%** குறைப்பதை நோக்கமாகக் கொண்டுள்ளன.';

  @override
  String get guide_nova_share_link => 'https://world-ta.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'திறந்த உணவு உண்மைகளுக்கு வருக!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'திறந்த உணவு உண்மைகள் என்றால் என்ன?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'ஓபன் ஃபுட் ஃபேக்ட்ஸ் என்பது உலகம் முழுவதிலுமிருந்து வரும் உணவுப் பொருட்களின் **கூட்டுறவு**, **இலவச** மற்றும் **திறந்த** தரவுத்தளமாகும்.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'அனைவரும் தாங்கள் சாப்பிடுவது பற்றிய தகவல்களை அணுக வேண்டும் என்று நாங்கள் நம்புகிறோம். பொருட்கள், ஒவ்வாமை, ஊட்டச்சத்து உண்மைகள் மற்றும் பலவற்றின் தரவைச் சேகரிப்பதன் மூலம், **நுகர்வோர் தகவலறிந்த தேர்வுகளைச் செய்ய நாங்கள் அதிகாரம் அளிக்கிறோம்** மேலும் உணவுத் துறையை **அதிக வெளிப்படைத்தன்மையை நோக்கி** கொண்டு செல்கிறோம்.';

  @override
  String get guide_open_food_facts_features_title =>
      'திறந்த உணவு உண்மைகளின் அம்சங்கள்';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'உங்கள் தேவையற்ற பொருட்களுக்கான விழிப்பூட்டல்களைப் பெறுங்கள்';

  @override
  String get guide_open_food_facts_tips_title =>
      'சிறந்த புகைப்படங்களை எடுப்பதற்கான உதவிக்குறிப்புகள்';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'செய்யக்கூடாதவை';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'நிழல்கள் மற்றும் கண்ணை கூசுவதைத் தவிர்க்கவும்.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'மங்கலான அல்லது தெளிவற்ற உரை இல்லை.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'உரையின் பகுதிகளை வெட்டி எடுக்க வேண்டாம்.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'பரபரப்பான பின்னணியைத் தவிர்க்கவும்.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'செய்ய வேண்டியவை';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'நல்ல, சீரான வெளிச்சத்தைப் பயன்படுத்துங்கள்.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'உரை தெளிவாகவும் படிக்கக்கூடியதாகவும் இருப்பதை உறுதிசெய்யவும்.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'முழு பொருட்களின் பட்டியலையும் பிடிக்கவும்.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'தயாரிப்பை ஒரு தட்டையான மேற்பரப்பில் வைக்கவும்.';

  @override
  String get guide_open_food_facts_scores_title =>
      '\"உணவு விக்கிபீடியாவை\" உருவாக்க எங்களுக்கு உதவுங்கள்.';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'ஊட்டச்சத்து தரத்தில் ஒரு மதிப்பெண்';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'மிகவும் பதப்படுத்தப்பட்ட உணவுகளைத் தவிர்ப்பதற்கான மதிப்பெண்';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'கிரகத்திற்கான மதிப்பெண்';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-ta.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'திறந்த செல்லப்பிராணி உணவு உண்மைகளுக்கு வருக!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'திறந்த செல்லப்பிராணி உணவு உண்மைகள் என்றால் என்ன?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'திறந்த செல்லப்பிராணி உணவு உண்மைகள் எங்கள் பணியை எங்கள் ரோம நண்பர்களுக்கும் விரிவுபடுத்துகின்றன! இது **பூனைகள், நாய்கள் மற்றும் பிற தோழர்களுக்கான செல்லப்பிராணி உணவுப் பொருட்களின் தரவுத்தளமாகும்**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'செல்லப்பிராணி உரிமையாளர்கள் தங்கள் விலங்குகளின் தேவைகளுக்கு ஏற்ற சிறந்த உணவைத் தேர்வுசெய்ய உதவும் வகையில், **பொருட்கள்**, **ஊட்டச்சத்து பகுப்பாய்வு** மற்றும் உணவளிக்கும் வழிகாட்டுதல்கள் பற்றிய தகவல்களை நாங்கள் சேகரிக்கிறோம்.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'திறந்த செல்லப்பிராணி உணவு உண்மைகளின் அம்சங்கள்';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'உங்கள் தேவையற்ற பொருட்களுக்கான விழிப்பூட்டல்களைப் பெறுங்கள்';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'உங்கள் செல்லப்பிராணிக்கு ஏதேனும் பொருட்களால் ஒவ்வாமை உள்ளதா? தவிர்க்க வேண்டிய அழகுசாதனப் பொருட்களின் பட்டியலை, செயலியிலேயே அமைக்கலாம்!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'சிறந்த புகைப்படங்களை எடுப்பதற்கான உதவிக்குறிப்புகள்';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'செய்யக்கூடாதவை';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'நிழல்கள் மற்றும் கண்ணை கூசுவதைத் தவிர்க்கவும்.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'மங்கலான அல்லது தெளிவற்ற உரை இல்லை.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'உரையின் பகுதிகளை வெட்டி எடுக்க வேண்டாம்.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'பரபரப்பான பின்னணியைத் தவிர்க்கவும்.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'செய்ய வேண்டியவை';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'நல்ல, சீரான வெளிச்சத்தைப் பயன்படுத்துங்கள்.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'உரை தெளிவாகவும் படிக்கக்கூடியதாகவும் இருப்பதை உறுதிசெய்யவும்.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'முழு பொருட்களின் பட்டியலையும் பிடிக்கவும்.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'தயாரிப்பை ஒரு தட்டையான மேற்பரப்பில் வைக்கவும்.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'மதிப்பெண் பற்றிய குறிப்பு';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'செல்லப்பிராணி உணவுக்கான மதிப்பெண் முறையை உருவாக்குவது **தற்போது முன்னுரிமை இல்லை**. ஊட்டச்சத்து தேவைகள் இனம், வயது மற்றும் சுகாதார நிலையைப் பொறுத்து பெரிதும் மாறுபடும் என்பதால், இந்த முறை சிக்கலானதாக இருக்கும். அத்தகைய மதிப்பெண்ணை உருவாக்கக்கூடிய எந்தவொரு சுயாதீன அறிவியல் குழுவையும் நாங்கள் இதுவரை கண்டுபிடிக்கவில்லை.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-ta.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'திறந்த அழகு உண்மைகளுக்கு வருக!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'திறந்த அழகு உண்மைகள் என்றால் என்ன?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'ஓபன் பியூட்டி ஃபேக்ட்ஸ் என்பது **ஒப்பனை பொருட்கள்** இன் கூட்டு தரவுத்தளமாகும்.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      '**உங்கள் தனிப்பட்ட பராமரிப்புப் பொருட்களில் என்ன இருக்கிறது என்பதைப் புரிந்துகொள்ள** உதவும் வகையில் மூலப்பொருள் பட்டியலைப் புரிந்துகொள்வதே எங்கள் குறிக்கோள். அழகுசாதனப் பொருட்கள் துறையில் வெளிப்படைத்தன்மையை மேம்படுத்துவதற்காக, மாய்ஸ்சரைசர்கள் முதல் ஒப்பனை வரை, பொருட்கள், ஒவ்வாமை மற்றும் பேக்கேஜிங் பற்றிய தரவை நாங்கள் சேகரிக்கிறோம்.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'திறந்த அழகு உண்மைகளின் அம்சங்கள்';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'உங்கள் தேவையற்ற பொருட்களுக்கான விழிப்பூட்டல்களைப் பெறுங்கள்';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'உங்களுக்கு ஏதேனும் பொருட்களுக்கு ஒவ்வாமை உள்ளதா? காமெடோஜென் பொருட்களைத் தவிர்க்க விரும்புகிறீர்களா? சர்ச்சைக்குரிய கூறுகளைத் தவிர்க்க விரும்புகிறீர்களா? பயன்பாட்டிலேயே தவிர்க்க வேண்டிய அழகுசாதனப் பொருட்களின் பட்டியலை அமைக்கலாம்!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'சிறந்த புகைப்படங்களை எடுப்பதற்கான உதவிக்குறிப்புகள்';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'செய்யக்கூடாதவை';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'நிழல்கள் மற்றும் கண்ணை கூசுவதைத் தவிர்க்கவும்.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'மங்கலான அல்லது தெளிவற்ற உரை இல்லை.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'உரையின் பகுதிகளை வெட்டி எடுக்க வேண்டாம்.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'பரபரப்பான பின்னணியைத் தவிர்க்கவும்.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'செய்ய வேண்டியவை';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'நல்ல, சீரான வெளிச்சத்தைப் பயன்படுத்துங்கள்.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'உரை தெளிவாகவும் படிக்கக்கூடியதாகவும் இருப்பதை உறுதிசெய்யவும்.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'முழு பொருட்களின் பட்டியலையும் பிடிக்கவும்.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'பாட்டில் வளைந்திருந்தால் தேவையான அளவு படங்களை எடுக்கவும்.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'பொருட்களின் பட்டியலைப் பார்க்க நீங்கள் லேபிளை உரிக்க வேண்டியிருக்கலாம்.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'தயாரிப்பை ஒரு தட்டையான மேற்பரப்பில் வைக்கவும்.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'மதிப்பெண் பற்றிய குறிப்பு';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'உணவுப் பொருட்களைப் போலன்றி, அழகுசாதனப் பொருட்களின் உலகில் **நியூட்ரி-ஸ்கோர்** போன்ற உலகளாவிய அங்கீகாரம் பெற்ற, அரசாங்கத்தால் ஆதரிக்கப்படும் மதிப்பெண் முறை இல்லை. மூலப்பொருள் விளைவுகள் மிகவும் தனிப்பட்டவை மற்றும் தோல் வகை, ஒவ்வாமை மற்றும் தனிப்பட்ட கவலைகளைப் பொறுத்தது.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-ta.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'பார்கோடு அளவில் தயாரிப்பு விலைகளின் பெரிய தரவுத்தளங்களை வைத்திருக்கும் நிறுவனங்கள் தற்போது மிகக் குறைவு. இந்த விலைகள் இலவசமாகக் கிடைக்காது, ஆனால் தனியார் நிறுவனங்கள், ஆராய்ச்சியாளர்கள் மற்றும் அவற்றை வாங்கக்கூடிய பிற நிறுவனங்களுக்கு அதிக விலைக்கு விற்கப்படுகின்றன.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**நாங்கள் விலைகளின் திறந்த மூல தரவுத்தொகுப்பை க்ரவுட் சோர்சிங் செய்கிறோம்**. இந்த வலை பயன்பாடு அல்லது அதிகாரப்பூர்வ ஓப்பன் ஃபுட் ஃபேக்ட்ஸ் மொபைல் பயன்பாடு வழியாக பயனர்கள் விலைகளைச் சேர்க்கலாம். சில்லறை விற்பனையாளர்கள் அல்லது மூன்றாம் தரப்பு பயன்பாடுகளும் எங்கள் API ஐப் பயன்படுத்தி பங்களிக்கலாம்.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'வரிசைகளில் விலைக் குறிச்சொற்களின் புகைப்படங்களைச் சேகரிக்கவும்.';

  @override
  String get guide_open_prices_how_arg2_title =>
      'ரசீதுகளின் புகைப்படங்களைச் சேகரிக்கவும்';

  @override
  String get guide_open_prices_why_title =>
      'ஓபன் ஃபுட் ஃபேக்ட்ஸ் ஏன் இதைச் செய்கிறது?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'உணவு முறைகளைப் புரிந்துகொள்வதற்கு விலைத் தகவல் மிக முக்கியமானது. உணவின் விலையைப் புரிந்துகொள்வதிலும் ஆரோக்கியமான உணவுமுறைகளை ஊக்குவிப்பதிலும் இது ஒரு முக்கிய காரணியாகும். விலைத் தரவைத் திறப்பது, ஆராய்ச்சியாளர்கள், பத்திரிகையாளர்கள் மற்றும் குடிமக்கள் **புவியியல் ரீதியாகவும் காலத்திலும் உணவு விலைகள் எவ்வாறு மாறுபடுகின்றன என்பதைப் பற்றி நன்கு புரிந்துகொள்ள** எளிதாக்கும் ஒரு வழியாகும்.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'காலப்போக்கில் விலைகளின் பரிணாம வளர்ச்சியைக் கண்காணிக்கவும்';

  @override
  String get guide_open_prices_why_arg1_text =>
      '**விலைகளின் பரிணாம வளர்ச்சியை** பாருங்கள்: சுருக்கப் பணவீக்கம், மலிவான பணவீக்கம், நாம் அவற்றை ஒன்றாகக் கண்காணிக்கலாம்!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'உங்களுக்கு அருகிலுள்ள விலைகளை ஒப்பிடுக';

  @override
  String get guide_open_prices_why_arg2_text =>
      'நாங்கள் அதிக விலைகளைப் பெறும்போது, **உங்களைச் சுற்றியுள்ள மலிவான கடைகளை** நீங்கள் காணலாம்.';

  @override
  String get guide_open_prices_scrapping_title =>
      'சில்லறை விற்பனையாளர்களின் வலைத்தளங்களிலிருந்து விலைகளைக் குறைப்பது பற்றி நீங்கள் யோசித்தீர்களா?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'நான் ஒரு சில்லறை விற்பனையாளர், விலைகளைப் பங்களிக்க விரும்புகிறேன். அதை நான் எப்படி செய்வது?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'எங்கள் API ஐப் பயன்படுத்தி நீங்கள் விலைகளைப் பங்களிக்கலாம்.\nநீங்கள் அளவில் விலைகளைப் பங்களிக்க விரும்பினால், தயவுசெய்து prices@openfoodfacts.org என்ற மின்னஞ்சல் முகவரியில் எங்களைத் தொடர்பு கொள்ளவும்.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about பற்றி';

  @override
  String get guide_open_products_facts_title =>
      'திறந்த தயாரிப்புகள் உண்மைகளுக்கு வருக!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'திறந்த தயாரிப்புகள் உண்மைகள் என்றால் என்ன?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'ஓபன் ப்ராடக்ட்ஸ் ஃபேக்ட்ஸ் என்பது **பார்கோடு உள்ள எந்தவொரு தயாரிப்புக்கும், இது உணவு, அழகுசாதனப் பொருட்கள் அல்லது செல்லப்பிராணி உணவு** அல்லாத ஒரு பெரிய, திறந்த தரவுத்தளமாகும்.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      '**எலக்ட்ரானிக்ஸ்** முதல் **பொம்மைகள்** வரை, **துப்புரவுப் பொருட்கள்** வரை, பார்கோடு இருந்தால், அதைச் சேர்க்கலாம். இந்தத் திட்டம் அன்றாடப் பொருட்களுக்கான \"இன்டர்நெட் ஆஃப் திங்ஸ்\" ஒன்றை உருவாக்கி, அவற்றைப் பற்றிய தகவல்களை உலகளவில் அணுகக்கூடியதாக மாற்றுவதை நோக்கமாகக் கொண்டுள்ளது.';

  @override
  String get guide_open_products_facts_features_title =>
      'திறந்த தயாரிப்புகளின் அம்சங்கள் உண்மைகள்';

  @override
  String get guide_open_products_facts_features_text =>
      'ஓபன் புராடக்ட்ஸ் ஃபேக்ட்ஸ், நுகர்வோர் தங்கள் பொருட்களைப் பராமரிக்க, **பழுதுபார்க்க**, **மறுசுழற்சி** அல்லது புதிய உரிமையாளரைக் கொடுக்க வட்ட தீர்வுகளை வழங்குவதன் மூலம் பொருட்களின் ஆயுளை **நீட்டிக்க** உதவுவதை நோக்கமாகக் கொண்டுள்ளது.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'சில தயாரிப்புகளுக்கான கார்பன் தடயங்கள்';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**பிரெஞ்சு சுற்றுச்சூழல் ஆணையமான ADEME ஆல் **தாக்கம் CO2** பல வகைகளின் **கார்பன் தாக்கத்தை** வழங்குகிறது, தயாரிப்புகளை துல்லியமாக வகைப்படுத்துவதை உறுதிசெய்யவும்.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'பல தயாரிப்புகளுக்கான பழுதுபார்க்கும் குறியீடு';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'பிரெஞ்சு பழுதுபார்க்கும் குறியீடு கிடைக்கும்போதெல்லாம், அதை நாங்கள் காண்பிப்போம். மேலும், **நீங்கள் ஃபோக்சோனமி எஞ்சினைப் பயன்படுத்தி மாறிகளைச் சேகரிக்கத் தொடங்கலாம்**; இதன் மூலம் எதிர்காலத்தில் அது கிடைக்காத நாடுகளில் கூட, அதை நாமே மீண்டும் கணக்கிட முடியும்.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'உங்கள் தயாரிப்பை நன்கொடையாக/மறுவிற்பனை செய்வதற்கான வழிகளைக் கண்டறியவும்.';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      '**மூன்றாம் தரப்பு வட்ட நட்பு சேவைகளுக்கான** இணைப்புகளை நாங்கள் வழங்குகிறோம், அவை நீங்கள் தேடும் தயாரிப்பைப் பெற உதவும், ஒரு இரண்டாம் நிலை தயாரிப்பாக, கிரக வளங்களில் மிகவும் மென்மையாக இருக்க உதவும்.\nஅதைச் செய்ய எங்களுக்கு பணம் வழங்கப்படவில்லை என்பதையும், இந்த அமைப்பு பிரான்சில் உள்ள இரண்டு வலைத்தளங்களுக்கு ஒரு எடுத்துக்காட்டாக மட்டுமே செயல்படுகிறது என்பதையும் நினைவில் கொள்க. விக்கியில் அதிகமான தளங்களை ஆவணப்படுத்துவதன் மூலம் இந்த அமைப்பை விரிவாக்க நீங்கள் உதவலாம்.';

  @override
  String get guide_open_products_facts_information_title =>
      'என்ன தகவல் பயனுள்ளதாக இருக்கும்?';

  @override
  String get guide_open_products_facts_information_text =>
      'இவ்வளவு பரந்த அளவிலான பொருட்களுக்கு, **நாங்கள் சேகரிக்கும் தரவு நெகிழ்வானது**. அதைச் செய்ய, **நாங்கள் ஃபோக்சோனமி எஞ்சினை** உருவாக்கினோம்.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'ஃபோக்சோனமி எஞ்சின்';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'ஃபோக்சோனமி எஞ்சின் என்பது தொடர்புடைய பண்புகளுடன் தயாரிப்புகளை முடிக்க உதவும் ஒரு கருவியாகும். இது தேடல் மற்றும் கண்டறியும் தன்மையை மேம்படுத்த உதவுகிறது, ஆனால் எதிர்காலத்தில் சுவாரஸ்யமான விஷயங்களைக் கணக்கிட்டு காண்பிக்கவும் உதவுகிறது.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'நீங்கள் எந்த விசைகளையும் மதிப்புகளையும் சேர்க்கலாம், எடுத்துக்காட்டாக: **5G_mobile_network உடன்_compatibility: ஆம்**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'சாத்தியமான சொத்துக்களின் தானியங்கி பரிந்துரையைப் பெறுவீர்கள், மேலும் உங்களுக்குப் பிடித்த வகையான தயாரிப்புகளில் புதியவற்றைச் சேர்த்து ஆவணப்படுத்த உங்களை வரவேற்கிறோம்.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-ta.openproductsfacts.org/discover பற்றிய தகவல்';

  @override
  String get guide_open_preferences_button_title =>
      'திறந்த உணவு விருப்பத்தேர்வுகள்';

  @override
  String get guide_coming_soon_button_title => 'விரைவில் வருகிறது';

  @override
  String get guide_learn_more_subtitle => 'மேலும் அறிய தட்டவும்';

  @override
  String get preview_badge => 'முன்னோட்டம்';

  @override
  String get prices_feedback_form =>
      'இந்தப் புதிய அம்சத்தைப் பற்றிய உங்கள் கருத்தை எங்களுக்கு அனுப்ப இங்கே கிளிக் செய்யவும்!';

  @override
  String get menu_button_list_actions => 'ஒரு செயலைத் தேர்ந்தெடுக்கவும்';

  @override
  String get error_loading_photo => 'புகைப்படத்தை ஏற்றுவதில் பிழை';

  @override
  String get photo_viewer_action_use_picture_as => '…ஆகப் பயன்படுத்தவும்';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'இந்தப் படத்தை…ஆகப் பயன்படுத்தவும்';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'இந்தப் படத்தை… ($language) ஆகப் பயன்படுத்தவும்';
  }

  @override
  String get photo_viewer_details_button => 'விவரங்கள்';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'இந்த புகைப்படத்தின் விவரங்கள்';

  @override
  String get photo_viewer_details_title => 'புகைப்படத்தின் விவரங்கள்';

  @override
  String get photo_viewer_details_contributor_title => 'Contributor';

  @override
  String get photo_viewer_details_size_title => 'அளவு';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height பிக்சல்கள்';
  }

  @override
  String get photo_viewer_details_date_title => 'தேதி';

  @override
  String get photo_viewer_details_url_title => 'URL ஐ';

  @override
  String get product_page_compatibility_score => 'இணக்கமானது';

  @override
  String get user_lists_action_multi_select => 'பல தேர்வு';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'உங்கள் பொருந்தக்கூடிய மதிப்பெண்: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Front picture';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Ingredients picture';

  @override
  String get product_image_nutrition_accessibility_label => 'ஊட்டச்சத்து படம்';

  @override
  String get product_image_packaging_accessibility_label => 'பேக்கேஜிங் படம்';

  @override
  String get product_image_other_accessibility_label => 'மற்ற படம்';

  @override
  String get product_image_outdated_message =>
      'இந்தப் படம் காலாவதியானதாக இருக்கலாம்.';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (இந்தப் படம் காலாவதியானதாக இருக்கலாம்)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (இந்தப் படத்தை தயாரிப்பாளரே பூட்டலாம்)';
  }

  @override
  String get product_image_error => 'படத்தை ஏற்ற முடியவில்லை!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type ஐ ஏற்ற முடியவில்லை (நெட்வொர்க் பிழையா?)';
  }

  @override
  String get product_page_image_no_image_available => '\nபடம் இல்லை!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'இந்த தயாரிப்புக்கான படம் எதுவும் கிடைக்கவில்லை.';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'செயல்களை மறுவரிசைப்படுத்து அல்லது மறை';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'செயல்களைத் திருத்து';

  @override
  String get product_page_action_bar_item_move_up => 'மேலே நகர்த்து';

  @override
  String get product_page_action_bar_item_move_down => 'கீழே நகர்த்து';

  @override
  String get product_page_action_bar_item_enable => 'செயலை இயக்கு';

  @override
  String get product_page_action_bar_item_disable => 'செயலை முடக்கு';

  @override
  String get product_page_pending_operations_banner_title =>
      'உங்கள் திருத்தங்களைப் பதிவேற்றுகிறது…';

  @override
  String get product_page_pending_operations_banner_message =>
      'இந்தப் பக்கத்தில் காட்டப்படும் தரவு **உங்கள் மாற்றங்களை இன்னும் பிரதிபலிக்கவில்லை**.\nசில வினாடிகள் காத்திருக்கவும்…';

  @override
  String get product_add_a_language => 'ஒரு மொழியைச் சேர்க்கவும்';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'பார்கோடு $barcode';
  }

  @override
  String get carousel_close_tooltip =>
      'இந்தத் தயாரிப்பை கேரோசலில் இருந்து அகற்று';

  @override
  String get carousel_unsupported_header => 'ஆதரிக்கப்படாத பார்கோடு!';

  @override
  String get carousel_unsupported_title => 'அச்சச்சோ!';

  @override
  String get carousel_unsupported_text =>
      'ஸ்கேன் செய்யப்பட்ட பார்கோடு திறந்த உணவு உண்மைகளால் ஆதரிக்கப்படவில்லை!';

  @override
  String get carousel_error_header => 'பிழை!';

  @override
  String get carousel_error_title => 'இது ஒரு பெரிய குறை!';

  @override
  String get carousel_error_text_1 =>
      'இந்த பார்கோடில் தகவலை எங்களால் பதிவிறக்க முடியவில்லை:';

  @override
  String get carousel_error_text_2 =>
      'உங்கள் இணைய இணைப்பைச் சரிபார்க்கவும் அல்லது இந்த பொத்தானைக் கிளிக் செய்யவும்:';

  @override
  String get carousel_error_button => 'மீண்டும் முயல்க';

  @override
  String get carousel_unknown_product_header => 'தெரியாத தயாரிப்பு';

  @override
  String get carousel_unknown_product_title =>
      'வாழ்த்துக்கள்!\nநீங்கள் __அரிய ரத்தினத்தைக் கண்டுபிடித்துவிட்டீர்கள்!__';

  @override
  String get carousel_unknown_product_text =>
      'எங்கள் கூட்டு தரவுத்தளத்தில் **3 மில்லியனுக்கும் அதிகமான தயாரிப்புகள்** உள்ளன, ஆனால் இந்த பார்கோடு இல்லை: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'தகவலை ஏற்றுகிறது...';

  @override
  String get carousel_loading_title =>
      'நீங்கள் பின்வரும் பார்கோடு கொண்ட ஒரு தயாரிப்பை ஸ்கேன் செய்துள்ளீர்கள்:';

  @override
  String get carousel_loading_text =>
      '**3 மில்லியனுக்கும் அதிகமான தயாரிப்புகளைக் கொண்ட எங்கள் தரவுத்தளத்தில் அதைத் தேடுகிறோம்!**';

  @override
  String get product_type_subtitle_food => 'காய்கறிகள், பழங்கள், உறைந்த உணவு…';

  @override
  String get product_type_subtitle_beauty => 'ஒப்பனை, சோப்புகள், பற்பசைகள்…';

  @override
  String get product_type_subtitle_pet_food => 'நாய்கள், பூனைகளுக்கான உணவு…';

  @override
  String get product_type_subtitle_product => 'ஸ்மார்ட்போன்கள், தளபாடங்கள்…';

  @override
  String get photo_field_front => 'தயாரிப்பு புகைப்படம்';

  @override
  String get photo_field_ingredients => 'பொருட்கள் புகைப்படம்';

  @override
  String get photo_field_nutrition => 'ஊட்டச்சத்து புகைப்படம்';

  @override
  String get photo_field_packaging => 'மறுசுழற்சி வழிமுறைகள் புகைப்படம்';

  @override
  String get photo_already_exists => 'இந்தப் புகைப்படம் ஏற்கனவே உள்ளது.';

  @override
  String get photo_missing => 'இந்தப் புகைப்படம் இல்லை.';

  @override
  String get date => 'தேதி';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'முந்தைய செயலைச் செயல்தவிர்க்கவும்.';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$location இன் உலக வரைபடம்';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap பங்களிப்பாளர்கள்';

  @override
  String get not_applicable_short => 'பொருந்தாது';

  @override
  String get knowledge_panel_warning_text => 'Warning';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'இந்த Nutri-Score தொகுப்பில் உள்ள மதிப்பெண்ணிலிருந்து ஏன் வேறுபட்டது?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'இரண்டு சாத்தியமான விளக்கங்கள் உள்ளன:\nபொருட்களின் பட்டியல் மற்றும்/அல்லது ஊட்டச்சத்து உண்மைகள் புதுப்பித்த நிலையில் இல்லை.\n\nநியூட்ரி-ஸ்கோரின் (அல்லது V2) \"புதிய கணக்கீட்டை\" நாங்கள் வழங்குகிறோம். தொகுப்பில் \"புதிய கணக்கீடு\" என்ற பேனர் உள்ளதா எனச் சரிபார்க்கவும்.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'பொருட்களைச் சரிபார்க்கவும்';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'ஊட்டச்சத்து உண்மைகளைச் சரிபார்க்கவும்';

  @override
  String url_not_supported(String url) {
    return 'துரதிருஷ்டவசமாக, எங்களால் URL ஐ திறக்க முடியவில்லை:\n$url';
  }

  @override
  String get product_list_export => 'ஏற்றுமதி';

  @override
  String get product_list_import => 'இறக்குமதி';

  @override
  String get product_footer_action_barcode => 'பார்கோடைப் பார்க்கவும்';

  @override
  String get product_footer_action_barcode_short => 'பார்கோடு';

  @override
  String get product_footer_action_open_website => 'இணையதளத்தைத் திறக்கவும்';

  @override
  String get product_footer_action_report => 'அறிக்கை';

  @override
  String get product_footer_action_contributor_guide => 'உதவி';

  @override
  String get product_footer_action_data_quality_tags => 'தரவுகளின் தரம்';

  @override
  String get product_page_tab_for_me => 'எனக்காக';

  @override
  String get product_page_tab_website => 'வலைத்தளம்';

  @override
  String get product_page_tab_prices => 'விலைகள்';

  @override
  String get prices_explanation_card_title => 'ஏன் விலைகள்?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** என்பது உலகம் முழுவதும் உள்ள பொருட்களின் விலைகளைச் சேகரித்துப் பகிர்ந்து கொள்ளும் ஒரு திட்டமாகும் 🌍. Open Prices Open Food Facts உண்மைகளால் உருவாக்கப்பட்டு பராமரிக்கப்படுகின்றன.';

  @override
  String get explanation_card_learn_more_button => 'மேலும்அறிய';

  @override
  String get product_page_tab_folksonomy => 'நாட்டுப்புறவியல்';

  @override
  String get folksonomy_explanation_card_title =>
      'ஃபோக்சோனமியின் பண்புக்கூறுகள் என்ன?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'பண்புக்கூறுகள் **முக்கிய-மதிப்பு** அடிப்படையிலானவை.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'இந்தப் பண்புகள் பங்களிப்பாளர்களால் எந்தவொரு பயன்பாட்டிற்கும் உருவாக்கப்பட்டு தாக்கல் செய்யப்படுகின்றன.';

  @override
  String get folksonomy_action_external_link_title => 'வெளிப்புற இணைப்பைத் திற';

  @override
  String get folksonomy_action_external_link_warning =>
      'வெளிப்புற இணைப்புகள் பாதுகாப்பற்றதாக இருக்கலாம். நீங்கள் உண்மையிலேயே அதைப் பார்வையிட விரும்புகிறீர்களா?';

  @override
  String get prices_products_empty_title => 'விலை எதுவும் கிடைக்கவில்லை.';

  @override
  String get prices_products_empty_explanation => 'முதலில் பங்களிக்கவும்!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'மேலே $pageSize தயாரிப்புகள் (மொத்தம்: $total)';
  }

  @override
  String get app_review_title => 'இந்த ஆப் உங்களுக்குப் பிடித்திருக்கிறதா?';

  @override
  String get app_review_low => 'இன்னும் சிறப்பாகச் செய்ய முடியும்';

  @override
  String get app_review_medium => 'மோசமாக இல்லை';

  @override
  String get app_review_high => 'நான் அதை விரும்புகிறேன்!';

  @override
  String get app_review_feedback_modal_title =>
      'எங்கள் பயன்பாட்டை மேம்படுத்த உதவுங்கள்.';

  @override
  String get app_review_feedback_modal_content =>
      'உங்களிடம் சில நிமிடங்கள் இருந்தால், இந்த படிவத்திற்கு பதிலளிக்க முடியுமா, அதனால் **எதிர்கால புதுப்பிப்புகளில் நாங்கள் மேம்படுத்த முடியும்**:';

  @override
  String get app_review_feedback_modal_open_form =>
      'படிவத்திற்கு பதிலளிக்கவும்';

  @override
  String get app_review_feedback_modal_later => 'பிறகு கேளுங்கள்.';

  @override
  String get nutrition_facts_extract_new =>
      'புதியது: படத்திலிருந்து ஊட்டச்சத்துக்களை நீங்கள் தானாகவே பிரித்தெடுக்கலாம்!';

  @override
  String get nutrition_facts_extract_button_text => 'இப்போது பிரித்தெடு';

  @override
  String get nutrition_facts_extract_in_progress =>
      'பிரித்தெடுக்கும் பணி நடந்து கொண்டிருக்கிறது…';

  @override
  String get nutrition_facts_extract_successful =>
      'பிரித்தெடுத்தல் வெற்றியடைந்தது';

  @override
  String get nutrition_facts_extract_failed =>
      'படத்திலிருந்து ஊட்டச்சத்துக்களைப் பிரித்தெடுக்க முடியவில்லை';

  @override
  String get prices_discount => 'தள்ளுபடி';

  @override
  String get prices_stats_statistics => 'புள்ளிவிவரங்கள்';

  @override
  String get prices_stats_title => 'விலை புள்ளிவிவரங்கள்';

  @override
  String get prices_stats_prices_section => 'விலைகள்';

  @override
  String get prices_stats_products_section => 'தயாரிப்புகள்';

  @override
  String get prices_stats_locations_section => 'இடங்கள்';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'இதர';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'ஒரு விலையுடன்';

  @override
  String get prices_stats_food => 'உணவு';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'தயாரிப்புகள்';

  @override
  String get prices_stats_pet_food => 'செல்லப்பிராணி உணவு';

  @override
  String get prices_stats_osm => 'ஓபன் ஸ்ட்ரீட்மேப்';

  @override
  String get prices_stats_online => 'ஆன்லைன்';

  @override
  String get prices_stats_countries => 'Countries';

  @override
  String get prices_stats_price_tag => 'விலைக் குறி';

  @override
  String get prices_stats_receipt => 'ரசீது';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'சவால்கள்';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title =>
      'மூலத்திற்கான விலைகள் மற்றும் சான்றுகள்';

  @override
  String get prices_stats_website => 'வலைத்தளம்';

  @override
  String get prices_stats_mobile_app => 'மொபைல் பயன்பாடு';

  @override
  String get prices_stats_api => 'ஏபிஐ';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'கடைசியாகப் புதுப்பிக்கப்பட்டது';

  @override
  String get prices_stats_error =>
      'புள்ளிவிவரங்களை ஏற்றும்போது பிழை ஏற்பட்டது.';

  @override
  String get product_edit_robotoff_question_answered =>
      'கேள்விக்கு பதில் கிடைத்தது!';

  @override
  String get product_edit_robotoff_proof => 'ஆதாரம்';

  @override
  String get preferences_card_general => 'பொது';

  @override
  String get preferences_prices_title => 'விலைகள்';

  @override
  String get preferences_prices_subtitle =>
      'உங்கள் விலை விருப்பங்களை நிர்வகிக்கவும்';

  @override
  String get preferences_card_project => 'திறந்த உணவு உண்மைகள் திட்டம்';

  @override
  String get preferences_contribute_title => 'Contribute';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'எனது புள்ளிவிவரங்கள்';

  @override
  String get preferences_contribute_subtitle =>
      'மொழிபெயர்க்கவும், எங்கள் கருவிகளை மேம்படுத்தவும்…';

  @override
  String get preferences_connect_title => 'இணைக்கவும்';

  @override
  String get preferences_connect_subtitle =>
      'எங்களைத் தொடர்பு கொள்ளுங்கள் அல்லது சமூக ஊடகங்களில் எங்களைப் பின்தொடருங்கள்';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'உலகெங்கிலும் உள்ள மில்லியன் கணக்கான நுகர்வோருக்குத் தெரிவிக்க எங்களுக்கு உதவுங்கள்.';

  @override
  String get preferences_card_help => 'உதவி & ஆதரவு';

  @override
  String get preferences_faq_title => 'அடிக்கடி கேட்கப்படும் கேள்விகள்';

  @override
  String get preferences_faq_subtitle =>
      'உங்கள் கேள்விகளுக்கான பதில்களைப் பெறுங்கள்';

  @override
  String get logged_out => 'வெளியேறிவிட்டார்';

  @override
  String get preferences_app_bar_message =>
      'எங்கள் உறுப்பினர்களில் ஒருவராக இருப்பதற்கு நன்றி!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'விலைகள் சேர்க்கப்பட்டன';

  @override
  String get preferences_app_bar_see_all_stats =>
      'எல்லா புள்ளிவிவரங்களையும் காண்க';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '\"$keyword\" -ஐ $provider -ல் தேடவும்.';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'ஒரு அமைப்பைத் தேடுங்கள் (எ.கா. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'அணுகல்தன்மை: ஈமோஜியைக் காட்டு';

  @override
  String get preferences_accessibility_remove_colors =>
      'அணுகல்தன்மை: வண்ணங்களை அகற்று';

  @override
  String get preferences_app_settings_products => 'தயாரிப்புகள்';

  @override
  String get preferences_card_about => 'இதைப் பற்றி';

  @override
  String get preferences_legal_information_title => 'சட்ட தகவல்';

  @override
  String get preferences_legal_information_subtitle =>
      'பயன்பாட்டு விதிமுறைகள், தனியுரிமைக் கொள்கை மற்றும் பல';

  @override
  String get preferences_terms_of_use => 'பயன்பாட்டு விதிமுறைகள்';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'ஓபன் ஃபுட் ஃபேக்ட்ஸ் என்பது அனைவராலும், அனைவருக்கும்** உருவாக்கப்பட்ட உணவுப் பொருட்களின் தரவுத்தளமாகும்.\nசிறந்த உணவுத் தேர்வுகளைச் செய்ய நீங்கள் இதைப் பயன்படுத்தலாம், மேலும் இது **திறந்த தரவு** என்பதால், யார் வேண்டுமானாலும் எந்த நோக்கத்திற்காகவும் இதை மீண்டும் பயன்படுத்தலாம்**.';

  @override
  String get preferences_privacy_policy => 'தனியுரிமைக் கொள்கை';

  @override
  String get preferences_licenses => 'உரிமங்கள்';

  @override
  String get preferences_about_app_title => 'பயன்பாட்டைப் பற்றி';

  @override
  String get preferences_about_app_subtitle =>
      'தொழில்நுட்பத் தகவல், டெவலப்பர் தகவல் மற்றும் பல';

  @override
  String get preferences_card_information => 'தகவல்';

  @override
  String get preferences_version_number_title => 'பதிப்பு எண்';

  @override
  String get preferences_scanner_title => 'ஸ்கேனர்';

  @override
  String get preferences_app_store => 'ஆப் ஸ்டோர்';

  @override
  String get preferences_app_system_settings => 'கணினி அமைப்புகள்';

  @override
  String get preferences_source_code => 'மூலக் குறியீட்டை அணுகவும்';

  @override
  String get preferences_source_code_subtitle =>
      'மில்லியன் கணக்கானவர்களுக்கு ஒரு தாக்கத்தை ஏற்படுத்தத் தொடங்குங்கள்.';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'முழுமையான தயாரிப்புகள்';

  @override
  String get preferences_tips => 'குறிப்புகள்';

  @override
  String get tips_discover_nutriscore => 'புதிய நியூட்ரி-ஸ்கோரைக் கண்டறியவும்';

  @override
  String get preferences_on_off_website_subtitle =>
      'ஓபன் ஃபுட் ஃபேக்ட்ஸ் வலைத்தளத்தில்';

  @override
  String get preferences_manage_account_title => 'எனது கணக்கை நிர்வகிக்கவும்';

  @override
  String get preferences_manage_account_tooltip =>
      'உங்கள் கணக்கை நிர்வகிக்கவும்';

  @override
  String get preferences_change_password_title => 'எனது கடவுச்சொல்லை மாற்று';

  @override
  String get preferences_danger_zone => 'ஆபத்து மண்டலம்';

  @override
  String get preferences_account_deletion_subtitle =>
      'உங்கள் பங்களிப்புகள் அனைத்தும் இழக்கப்படும்.';

  @override
  String get preferences_contributions_title => 'Contributions';

  @override
  String get preferences_dev_mode_app_settings_title => 'பயன்பாட்டு அமைப்புகள்';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'தயாரிப்புகளை ஆஃப்லைனில் ஸ்கேன் செய்வதற்கான மிகவும் சோதனை வழி';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'சேவையகத்திலிருந்து அனைத்து தயாரிப்புகளையும் புதுப்பிக்கவும்.';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'மிகவும் அவசியமானால் தவிர, தயவுசெய்து அதைச் செய்வதைத் தவிர்க்கவும்.';

  @override
  String get preferences_dev_mode_demo_mode_title => 'டெமோ பயன்முறை';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'ஸ்கேனரில் கார்டுகளைச் சேர்க்கவும்';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'ஸ்கேனரில் 3 மாதிரி தயாரிப்புகளைச் சேர்க்கிறது.';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'ஃபோக்சோனமி ஹோஸ்ட்';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'தொகுப்பாளர்: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'அணுகல்தன்மை பரிசோதனைகள்';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'விலைகளுக்கு ஏற்ப பல தயாரிப்புகளின் தேர்வு';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'பயனர் ஆர்டர் செய்த தகவல் பலகைகள்';

  @override
  String get preferences_dev_mode_location_search_title =>
      'இருப்பிடத் தேடலுக்கான தற்காலிக அணுகல்';

  @override
  String get preferences_dev_mode_comparison_title =>
      '2 அல்லது 3 தயாரிப்புகளுக்கான பக்கவாட்டு ஒப்பீடு';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'தயாரிப்பு பட்டியல் இறக்குமதி';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'மதிப்பெண்கள் & வழிமுறைகள்';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Nutri-Score எவ்வாறு கணக்கிடப்படுகிறது என்பதைக் கண்டறியவும்.';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'முறைமையில் ஏற்பட்ட முக்கிய மாற்றங்களைக் கண்டறியவும்.';

  @override
  String get preferences_faq_discover_project_title => 'Discover the project';

  @override
  String get preferences_faq_discover_off_title =>
      'Open Food Facts உண்மைகளைக் கண்டறியவும்';

  @override
  String get preferences_faq_discover_obf_title =>
      'Open Beauty உண்மைகளைக் கண்டறியவும்';

  @override
  String get preferences_faq_discover_opff_title =>
      'திறந்த செல்லப்பிராணி உணவு உண்மைகளைக் கண்டறியவும்';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'திறந்த தயாரிப்புகள் உண்மைகளைக் கண்டறியவும்';

  @override
  String get preferences_faq_faq_title =>
      'அடிக்கடி கேட்கப்படும் கேள்விகள் - அடிக்கடி கேட்கப்படும் கேள்விகள்';

  @override
  String get preferences_faq_off_ngo_title =>
      'Open Food Facts அரசு சாரா நிறுவனம்';

  @override
  String get preferences_about_information_title => 'தகவல்';

  @override
  String get preferences_connect_community_updates_title =>
      'சமூக புதுப்பிப்புகளைப் பெறுங்கள்';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'பயன்பாடு மற்றும் சமூக செய்திகளுடன் இணைந்திருங்கள்.';

  @override
  String get preferences_connect_community_calendar_title =>
      'எங்கள் சமூக நாட்காட்டியில் குழுசேரவும்';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'எங்கள் மெய்நிகர் நிகழ்வுகளில் ஒன்றில் கலந்துகொள்வதன் மூலம் ஈடுபடுங்கள்.';

  @override
  String get preferences_connect_blog_title => 'Open Food Facts வலைப்பதிவு';

  @override
  String get preferences_connect_blog_subtitle =>
      'சமீபத்திய செய்திகளை அவை நடக்கும்போதே பெறுங்கள்';

  @override
  String get preferences_connect_community_help_title =>
      'சமூகத்திடமிருந்து உதவி பெறுங்கள்';

  @override
  String get preferences_connect_improve_app_title =>
      'பயன்பாட்டை மேம்படுத்த எங்களுக்கு உதவுங்கள்.';

  @override
  String get preferences_connect_debug_info_title =>
      'பிழைத்திருத்த தகவலை எங்களுக்கு அனுப்புங்கள்.';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'விரிவான பிழைத்திருத்த தகவலுடன் எங்களுக்கு ஒரு மின்னஞ்சல் அனுப்புங்கள்.';

  @override
  String get preferences_connect_feedback_title =>
      'பயன்பாட்டைப் பற்றிய உங்கள் கருத்துக்களை எங்களுக்கு அனுப்புங்கள்.';

  @override
  String get preferences_connect_feedback_subtitle =>
      'பயன்பாட்டின் எதிர்காலத்தை வடிவமைக்க உதவுங்கள்.';

  @override
  String get preferences_connect_survey_title =>
      'பயன்பாட்டு கணக்கெடுப்பில் பங்கேற்கவும்';

  @override
  String get preferences_connect_survey_subtitle =>
      'அடுத்து என்ன கட்ட வேண்டும் என்பதைப் புரிந்துகொள்ள உதவுங்கள்.';

  @override
  String get preferences_connect_professionals_title => 'வல்லுநர்கள்';

  @override
  String get preferences_connect_pro_subtitle =>
      'முற்றிலும் இலவசம், 500 பயன்பாடுகள் மற்றும் மில்லியன் கணக்கான நுகர்வோருக்கு துல்லியமான தரவை உறுதி செய்கிறது. சுய சேவை, உங்கள் PIM அல்லது விரிதாள்களுடன் (XLSX) இணக்கமானது.';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'தொடங்குவதற்கு தொடர்பு கொள்ளவும்.';

  @override
  String get preferences_connect_press_title => 'Press';

  @override
  String get preferences_connect_press_page_subtitle =>
      'உங்கள் அறிக்கைக்குத் தேவையான அனைத்துப் பொருட்களையும் பெறுங்கள்.';

  @override
  String get preferences_connect_press_email_subtitle =>
      'பத்திரிகை விசாரணைகளுக்கு அல்லது உங்கள் அறிக்கையைப் பற்றி எங்களுக்குத் தெரிவிக்க தொடர்பு கொள்ளவும்.';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'ஒரு செயலில் தன்னார்வலராகுங்கள்';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'மேம்பாடு, தொடர்பு, வடிவமைப்பு… எந்த வகையான தன்னார்வத் தொண்டு அல்லது நிபுணத்துவமும் வரவேற்கப்படுகிறது!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'நீங்கள் பங்களிக்கக்கூடிய பல வழிகளில் சிலவற்றைக் கண்டறியவும்.';

  @override
  String get preferences_contribute_mobile_dev_title => 'மொபைல் செயலி மேம்பாடு';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'மென்பொருள் மேம்பாட்டிற்கு எவ்வாறு பங்களிப்பது என்பதை அறிக.';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'தினசரி நிலையற்ற உருவாக்கங்கள், புத்தம் புதிய அம்சங்கள்';

  @override
  String get preferences_contribute_local_community_title =>
      'உங்கள் உள்ளூர் சமூகத்தை வளர்க்கவும்.';

  @override
  String get preferences_contribute_translate_subtitle =>
      'மென்பொருள், உள்ளடக்கங்கள், மூலப்பொருள் பகுப்பாய்வு மொழிபெயர்ப்புகளுக்கு உதவி.';

  @override
  String get preferences_contribute_share_subtitle =>
      'உங்களுக்கு உதவ ஒரு சிறிய டெம்ப்ளேட்டை நாங்கள் தயார் செய்துள்ளோம் :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'உங்கள் நாட்டில் உணவு வெளிப்படைத்தன்மையை வளர்ப்பதற்கான எளிய வழிமுறைகள்.';

  @override
  String get preferences_contribute_data_quality_title => 'தரவுகளின் தரம்';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'தரவு தரக் குழுவில் சேருங்கள்';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'தரவுத்தளம் முழுமையாகவும் துல்லியமாகவும் இருப்பதை உறுதிசெய்ய எங்கள் முயற்சியில் சேருங்கள்.';

  @override
  String get preferences_contributions_products_added_title =>
      'சேர்க்கப்பட்ட தயாரிப்புகள்';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Open Food Facts உண்மைகளில் நான் சேர்த்த புதிய தயாரிப்புகள்';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'நான் முடிக்க வேண்டிய தயாரிப்புகள்';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'முழுமையற்ற அனைத்து தயாரிப்புகளும்';

  @override
  String get preferences_my_contributions_prices_title => 'விலைகள்';

  @override
  String get preferences_my_contributions_my_prices_title => 'எனது விலைகள்';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'என்னுடைய விலைகள், என்னுடைய சான்றுகள்…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'நீங்கள் முடிக்க உதவும் தயாரிப்புகள்';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'உங்கள் நாட்டில் Nutri-Score & கிரீன்-ஸ்கோரைக் கணக்கிட உதவுங்கள்.';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'நான் பங்களித்த விலைகள்';

  @override
  String get preferences_prices_proofs_subtitle =>
      'விலைக் குறிச்சொற்கள் மற்றும் ரசீதுகள்';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'உங்கள் ரசீதுகளின் புகைப்படங்களை எடுத்து தொடர்புடைய பார்கோடுகளை ஸ்கேன் செய்யுங்கள்.';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'ஒரு கடையில் விலைகளின் புகைப்படங்களை எடுத்துக் கொள்ளுங்கள்.';

  @override
  String get preferences_prices_newest_title => 'புதிய விலைகள்';

  @override
  String get preferences_prices_newest_subtitle =>
      'Open Prices சமூகத்தால் சேர்க்கப்பட்ட சமீபத்திய விலைகள்';

  @override
  String get preferences_prices_top_contributors_title =>
      'அதிக விலைகளைக் கொண்ட பங்களிப்பாளர்கள்';

  @override
  String get preferences_prices_metrics_title => 'திறந்த விலை அளவீடுகள்';

  @override
  String get preferences_prices_metrics_subtitle =>
      'திட்டத்தின் பரிணாம வளர்ச்சியைப் பின்பற்றுங்கள்';

  @override
  String get preferences_prices_ways_contribute_title =>
      'பங்களிப்பதற்கான வழிகள்';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'AI உதவியுடன், நீங்களோ அல்லது மற்றவர்களோ சேர்த்த விலைகளை உறுதிப்படுத்தவும்.';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'உங்கள் கேமரா ரோலில் இருந்து பல ரசீதுகள் அல்லது அலமாரிகளின் புகைப்படங்களை விரைவாகச் சேர்க்கவும்';

  @override
  String get preferences_prices_challenges_title => 'மாதாந்திர சவால்கள்';

  @override
  String get preferences_prices_challenges_subtitle =>
      'விலைகளைச் சேகரிக்க மாதாந்திர கருப்பொருள் தேடல்களில் பங்கேற்கவும்';

  @override
  String get preferences_prices_loyalty_data_title =>
      'உங்கள் விசுவாசத் தரவை மீட்டெடுக்கவும்';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'உங்கள் தரவை எவ்வாறு கோருவது என்பதை அறிக.';

  @override
  String get preferences_page_customize_app_title =>
      'பயன்பாட்டைத் தனிப்பயனாக்குங்கள்';

  @override
  String get preferences_page_contribute_project_title =>
      'திட்டத்திற்கு பங்களிக்கவும்';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Open Food Factsக்க உதவும் எளிய வழிகள்';

  @override
  String get preferences_page_faq_subtitle =>
      'திட்டத்தைப் பற்றிய மதிப்பெண் முறைகள், உதவி மற்றும் பல.';

  @override
  String get product_edit_robotoff_positive_button => 'பரிந்துரையை ஏற்கிறேன்';

  @override
  String get product_edit_robotoff_negative_button => 'பரிந்துரையை நிராகரி';

  @override
  String get product_edit_robotoff_show_proof => 'ஆதாரம் காட்டு.';

  @override
  String get product_edit_robotoff_expand_proof => 'ஆதாரத்தை விரிவாக்கு';

  @override
  String get product_page_tab_raw_data => 'மூல தரவு';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'பக்கம் $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'பக்கம் $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count / $total பொருட்கள்';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count / $total பொருட்கள்';
  }

  @override
  String item_count(int count) {
    return '$count பொருட்கள்';
  }

  @override
  String item_count_string(String count) {
    return '$count பொருட்கள்';
  }

  @override
  String get prices_no_result => 'விலை புள்ளிவிவரங்கள் எதுவும் கிடைக்கவில்லை.';

  @override
  String get prices_error_loading_more_items =>
      'கூடுதல் உருப்படிகளை ஏற்றுவதில் பிழை';

  @override
  String get prices_proof_error =>
      'அங்கீகாரம் தோல்வியடைந்தது, சான்றுகளைப் பெற முடியவில்லை.';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count / $total சான்றுகள்';
  }

  @override
  String proof_count(int count) {
    return '$count சான்றுகள்';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$total பங்களிப்பாளர்களில் $count';
  }

  @override
  String contributors_count(int count) {
    return '$count பங்களிப்பாளர்கள்';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$total இடங்களில் $count';
  }

  @override
  String prices_locations_count(int count) {
    return '$count இடங்கள்';
  }

  @override
  String get restart_to_apply_message =>
      'மாற்றங்களைப் பயன்படுத்த பயன்பாட்டை மறுதொடக்கம் செய்யவும்.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'வரைகலை இடைமுகம்';

  @override
  String get preferences_app_settings_media_title => 'ஊடகம்';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Open Food Facts ஆய்வகங்கள்';

  @override
  String get preferences_root_account_title => 'கணக்கு';

  @override
  String get preferences_contribute_translate_header =>
      'Open Food Facts உண்மைகளை உங்கள் மொழியில் கொண்டு வாருங்கள்.';

  @override
  String get preferences_contribute_enroll_alpha =>
      'பயன்பாட்டின் ஆல்பா பதிப்பில் பதிவுசெய்யவும்';

  @override
  String get preferences_dev_mode_section_data =>
      'பங்களிப்புகள் & தயாரிப்பு தரவு';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'ஃபோக்சோனமியைக் காட்டாதே';

  @override
  String get preferences_account_title => 'கணக்கு';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '$createdஇல் சேர்க்கப்பட்டது';
  }

  @override
  String get location_map_details_title => 'இருப்பிட விவரங்கள்';

  @override
  String get location_map_details_name => 'பெயர்';

  @override
  String get location_map_details_street => 'தெரு';

  @override
  String get location_map_details_city => 'நகரம்';

  @override
  String get location_map_details_postcode => 'அஞ்சல் குறியீடு';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'ஆயத்தொலைவுகள்';

  @override
  String get location_map_details_osm_id => 'OSM ஐடி';
}
