// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Swahili (`sw`).
class AppLocalizationsSw extends AppLocalizations {
  AppLocalizationsSw([String locale = 'sw']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Yes';

  @override
  String get add => 'Ongeza';

  @override
  String get account_delete_message =>
      'Je, una uhakika unataka kufuta akaunti yako?\nIkiwa kuna sababu maalum, tafadhali shiriki hapa chini';

  @override
  String get reason => 'Sababu';

  @override
  String get okay => 'Sawa';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'Unda';

  @override
  String get applyButtonText => 'Apply';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'Endelea';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'Rudi juu';

  @override
  String get save => 'Hifadhi';

  @override
  String get save_confirmation => 'Je, una uhakika unataka kuhifadhi?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Ghairi';

  @override
  String get ignore => 'Puuza';

  @override
  String get close => 'Funga';

  @override
  String get no => 'No';

  @override
  String get stop => 'Acha';

  @override
  String get finish => 'Maliza';

  @override
  String get calculate => 'Kokotoa';

  @override
  String get reset_food_prefs => 'Weka upya mapendeleo ya chakula';

  @override
  String get error => 'Kuna kitu ilienda mrama';

  @override
  String get error_occurred => 'Hitilafu imetokea';

  @override
  String get featureInProgress =>
      'Bado tunafanyia kazi kipengele hiki, endelea kufuatilia';

  @override
  String get label_web => 'Tazama kwenye wavuti';

  @override
  String get learnMore => 'Jifunze zaidi';

  @override
  String get unknown => 'Haijulikani';

  @override
  String get match_very_good => 'Mechi nzuri sana';

  @override
  String get match_good => 'Mechi nzuri';

  @override
  String get match_poor => 'Mechi mbaya';

  @override
  String get match_may_not => 'May not match';

  @override
  String get match_does_not => 'hailingani';

  @override
  String get match_unknown => 'Ulinganifu usiojulikana';

  @override
  String get match_short_very_good => 'Mechi nzuri sana';

  @override
  String get match_short_good => 'Mechi nzuri';

  @override
  String get match_short_poor => 'Mechi mbaya';

  @override
  String get match_short_may_not => 'May not match';

  @override
  String get match_short_does_not => 'hailingani';

  @override
  String get match_short_unknown => 'Ulinganifu usiojulikana';

  @override
  String get licenses => 'Leseni';

  @override
  String get looking_for => 'Kutafuta';

  @override
  String get welcomeToOpenFoodFacts => 'Karibu kwa Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts ni shirika lisilo la faida la kimataifa linaloendeshwa na jumuiya za wenyeji.';

  @override
  String get productDataUtility =>
      'Tazama data ya chakula inayohusiana na mapendeleo yako.';

  @override
  String get healthCardUtility => 'Chagua vyakula ambavyo vinafaa kwako.';

  @override
  String get ecoCardUtility => 'Chagua vyakula ambavyo ni nzuri kwa sayari.';

  @override
  String get server_error_open_new_issue =>
      'Hakuna jibu la seva! Unaweza kufungua suala kwa kiungo kifuatacho.';

  @override
  String get sign_in_text =>
      'Ingia katika akaunti yako ya Open Food Facts ili kuhifadhi michango yako';

  @override
  String get incorrect_credentials => 'Jina la mtumiaji au nenosiri si sahihi.';

  @override
  String get password_lost_incorrect_credentials =>
      'Barua pepe hii au jina la mtumiaji halipo. Tafadhali angalia stakabadhi zako.';

  @override
  String get password_lost_server_unavailable =>
      'Kwa sasa tunakumbwa na kushuka kwa kasi kwa seva zetu na tunaomba radhi kwa hilo. Tafadhali jaribu tena baadaye.';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable => 'Mtandao haupatikani';

  @override
  String get login_result_type_server_issue =>
      'Tatizo kwenye seva. Tafadhali jaribu baadaye.';

  @override
  String get login_page_username_or_email =>
      'Tafadhali ingiza jina la mtumiaji au barua pepe';

  @override
  String get login_page_password_error_empty => 'Tafadhali weka nenosiri';

  @override
  String get create_account => 'Fungua akaunti';

  @override
  String get sign_in => 'Ingia';

  @override
  String get sign_in_mandatory => 'Kwa kipengele hicho tunahitaji uingie.';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'Ondoka';

  @override
  String get sign_out_confirmation => 'Je, una uhakika unataka kuondoka?';

  @override
  String get password => 'Nenosiri';

  @override
  String get forgot_password => 'Umesahau nenosiri';

  @override
  String get forgot_password_question => 'Umesahau nenosiri?';

  @override
  String get view_profile => 'Tazama wasifu';

  @override
  String get reset_password => 'Weka upya nenosiri';

  @override
  String get reset_password_explanation_text =>
      'Ikiwa nenosiri limesahaulika, ingiza jina lako la mtumiaji au anwani ya barua pepe ili kupokea maagizo ya kuweka upya nenosiri. Pia, kumbuka kuangalia folda ya Barua taka.';

  @override
  String get username_or_email => 'Jina la mtumiaji au barua pepe';

  @override
  String get reset_password_done =>
      'Barua pepe iliyo na kiungo cha kuweka upya nenosiri lako imetumwa kwa anwani ya barua pepe inayohusishwa na akaunti yako. Pia angalia barua taka zako';

  @override
  String get send_reset_password_mail => 'Badilisha nenosiri';

  @override
  String get enter_some_text => 'Tafadhali weka maandishi';

  @override
  String get sign_up_page_title => 'Jisajili';

  @override
  String get sign_up_page_action_button => 'Jisajili';

  @override
  String get sign_up_page_action_doing_it => 'Inajisajili…';

  @override
  String get sign_up_page_action_ok =>
      'Hongera! Akaunti yako imeundwa hivi punde.';

  @override
  String get sign_up_page_display_name_hint => 'Jina';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Tafadhali ingiza jina la onyesho unalotaka kutumia';

  @override
  String get sign_up_page_email_hint => 'Barua pepe';

  @override
  String get sign_up_page_email_error_empty => 'Barua pepe inahitajika';

  @override
  String get sign_up_page_email_error_invalid => 'Barua pepe si sahihi';

  @override
  String get sign_up_page_username_hint =>
      'Jina la mtumiaji: Inaonekana hadharani';

  @override
  String get sign_up_page_username_error_empty =>
      'Tafadhali weka jina la mtumiaji';

  @override
  String get sign_up_page_username_error_invalid =>
      'Tafadhali weka jina la mtumiaji halali';

  @override
  String get sign_up_page_username_description =>
      'Jina la mtumiaji haliwezi kuwa na nafasi, kofia au herufi maalum.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Jina la mtumiaji haliwezi kuzidi vibambo $value';
  }

  @override
  String get sign_up_page_password_hint => 'Nenosiri';

  @override
  String get sign_up_page_password_error_empty => 'Tafadhali weka nenosiri';

  @override
  String get sign_up_page_password_error_invalid =>
      'Tafadhali weka nenosiri halali (angalau vibambo 6)';

  @override
  String get sign_up_page_confirm_password_hint => 'Thibitisha Nenosiri';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Tafadhali thibitisha nenosiri';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Manenosiri hayalingani';

  @override
  String get sign_up_page_agree_text => 'Ninakubali Ukweli wa Chakula Huria';

  @override
  String get sign_up_page_terms_text => 'masharti ya matumizi na mchango';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Wakati wa kuunda akaunti, kukubaliana na Sheria na Masharti ni lazima, hata hivyo, michango isiyojulikana bado inaweza kufanywa kupitia programu.';

  @override
  String get sign_up_page_producer_checkbox => 'Mimi ni mzalishaji wa chakula';

  @override
  String get sign_up_page_producer_hint => 'Mtayarishaji/chapa';

  @override
  String get sign_up_page_producer_error_empty =>
      'Tafadhali weka mzalishaji au jina la biashara';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Ningependa kujiandikisha kwa jarida la Open Food Facts (Unaweza kujiondoa kutoka kwalo wakati wowote)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Jina la mtumiaji tayari lipo, tafadhali chagua jina lingine la mtumiaji.';

  @override
  String get sign_up_page_email_already_exists =>
      'tayari ipo, ingia kwenye akaunti au jaribu na barua pepe nyingine.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Tafadhali toa barua pepe halali.';

  @override
  String get sign_up_page_server_busy =>
      'Samahani sana, tuna matatizo ya kiufundi kuunda akaunti yako. Tafadhali jaribu tena baadaye.';

  @override
  String get settingsTitle => 'Mipangilio';

  @override
  String get darkmode => 'Mandhari';

  @override
  String get darkmode_dark => 'Giza';

  @override
  String get darkmode_light => 'Mwanga';

  @override
  String get darkmode_system_default => 'Chaguomsingi ya mfumo';

  @override
  String get thanks_for_contributing => 'Asante kwa kuchangia!';

  @override
  String get contributors_label => 'Wanatengeneza programu';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Mchangiaji: $name';
  }

  @override
  String get contributors_description =>
      'Orodha ya wachangiaji wote wa programu hii';

  @override
  String get support => 'Msaada';

  @override
  String get support_join_slack => 'Omba usaidizi katika kituo chetu cha Slack';

  @override
  String get support_via_forum => 'Omba msaada kwenye jukwaa letu';

  @override
  String get support_via_email => 'Tutumie barua pepe';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Ungependa kutuma kumbukumbu za programu?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Je, ungependa kujumuisha kumbukumbu za maombi kwenye kiambatisho cha barua pepe yako?';

  @override
  String get termsOfUse => 'Masharti ya matumizi';

  @override
  String get legalNotices => 'Matangazo ya kisheria';

  @override
  String get privacy_policy => 'Sera ya faragha';

  @override
  String get about_this_app => 'Kuhusu programu hii';

  @override
  String get contribute => 'Contribute';

  @override
  String get contribute_sw_development => 'Maendeleo ya programu';

  @override
  String get contribute_develop_text =>
      'Nambari ya kila bidhaa ya Open Food Facts inapatikana kwenye GitHub. Unakaribishwa kutumia tena msimbo (ni chanzo huria) na utusaidie kuuboresha, kwa kila mtu, kwenye sayari yote.';

  @override
  String get contribute_develop_text_2 =>
      'Unaweza kujiunga na mazungumzo ya Open Food Facts Slack ambayo ndiyo njia inayopendelewa ya kuuliza maswali.';

  @override
  String get contribute_develop_dev_mode_title => 'Hali ya DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Washa Hali ya DEV';

  @override
  String get contribute_donate_title => 'Donate';

  @override
  String get contribute_donate_header => 'Changia Kufungua Ukweli wa Chakula';

  @override
  String get contribute_enroll_alpha_warning => '!';

  @override
  String get contribute_improve_ProductsToBeCompleted => 'Bidhaa kukamilika';

  @override
  String get contribute_improve_header => 'Kuboresha';

  @override
  String get contribute_improve_text =>
      'Hifadhidata ndio msingi wa mradi. Ni rahisi na haraka sana kusaidia. Unaweza kupakua programu ya simu kwa simu yako, na kuanza kuongeza au kuboresha bidhaa.\n\nKwa upande mwingine, tovuti ya Open Food Facts inatoa njia nyingi za kuchangia: ';

  @override
  String get contribute_translate_header => 'Tafsiri';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Anza Kutafsiri';

  @override
  String get contribute_translate_text =>
      'Open Food Facts ni mradi wa kimataifa, unaojumuisha bidhaa kutoka zaidi ya nchi 160. Ukweli wa Chakula cha Open hutafsiriwa katika lugha kadhaa, na maudhui yanayobadilika kila mara.';

  @override
  String get contribute_translate_text_2 =>
      'Tafsiri ni moja wapo ya kazi kuu za mradi';

  @override
  String get contribute_join_skill_pool =>
      'Contribute your skills to Open Food Facts. Join the skill pool!';

  @override
  String get contribute_share_header =>
      'Shiriki Ukweli wa Chakula cha Open na marafiki zako';

  @override
  String get contribute_share_content =>
      'Nilitaka kukujulisha kuhusu programu ambayo nimekuwa nikitumia, Ukweli wa Chakula cha Open, ambayo hukuruhusu kupata athari za kiafya na mazingira za chakula chako, kwa njia iliyobinafsishwa. Inafanya kazi kwa kuchanganua misimbopau kwenye kifurushi. Hatimaye ni bure, hauhitaji usajili, na unaweza hata kusaidia kuongeza idadi ya bidhaa decyphered. Hiki hapa ni kiungo cha kuipata kwa simu yako: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Changia bei kwa kuomba uhamishaji wa data ya kadi zako za uaminifu kwa GDPR';

  @override
  String get tap_to_answer => 'Gonga hapa ili kujibu maswali';

  @override
  String get tap_to_answer_hint =>
      'Gusa hapa ili kujibu maswali kuhusu bidhaa hii';

  @override
  String get robotoff_questions_loading_hint =>
      'Tafadhali subiri wakati maswali kuhusu bidhaa hii yanapakiwa';

  @override
  String get saving_answer => 'Inahifadhi jibu lako';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Ingia katika akaunti yako ya Open Food Facts ili upate mkopo kwa michango yako';

  @override
  String get question_yes_button_accessibility_value => 'Jibu na ndiyo';

  @override
  String get question_no_button_accessibility_value => 'Jibu kwa hapana';

  @override
  String get question_skip_button_accessibility_value => 'Ruka swali hili';

  @override
  String get tap_to_edit_search => 'Gusa ili kuhariri utafutaji';

  @override
  String get myPreferences => 'Mapendeleo yangu';

  @override
  String get account_create_message =>
      'Fungua akaunti yako na ujiunge na jumuiya ya Open Food Facts ili kusaidia kujenga ujuzi wa chakula duniani kote!';

  @override
  String get join_us => 'Jiunge nasi';

  @override
  String get myPreferences_profile_title => 'Wasifu wako';

  @override
  String get myPreferences_profile_subtitle =>
      'Dhibiti akaunti yako ya mchangiaji wa Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Mipangilio ya Programu';

  @override
  String get myPreferences_settings_subtitle => 'Hali nyeusi, Lugha…';

  @override
  String get myPreferences_food_title => 'Mapendeleo ya Chakula';

  @override
  String get myPreferences_food_subtitle =>
      'Chagua ni taarifa gani kuhusu chakula muhimu zaidi kwako.';

  @override
  String get myPreferences_food_comment =>
      'Chagua ni taarifa gani kuhusu chakula muhimu zaidi kwako, ili kupanga chakula kulingana na mapendeleo yako, angalia maelezo unayojali kwanza, na upate muhtasari wa uoanifu. Mapendeleo hayo ya chakula hukaa kwenye kifaa chako, na hayahusiani na akaunti yako ya mchangiaji wa Ukweli wa Chakula Huria ikiwa unayo.';

  @override
  String get confirmResetPreferences =>
      'Ungependa kuweka upya mapendeleo yako ya chakula?';

  @override
  String get myPersonalizedRanking => 'Nafasi yangu iliyobinafsishwa';

  @override
  String get ranking_tab_all => 'All';

  @override
  String get ranking_subtitle_match_yes => 'Mechi nzuri kwako';

  @override
  String get ranking_subtitle_match_no => 'Mechi mbaya sana';

  @override
  String get ranking_subtitle_match_maybe => 'Ulinganifu usiojulikana';

  @override
  String get refresh_with_new_preferences =>
      'Onyesha upya orodha na mapendeleo yako mapya';

  @override
  String get reloaded_with_new_preferences =>
      'Imepakiwa upya na mapendeleo yako mapya';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Changanua';

  @override
  String get history_navbar_label => 'Historia';

  @override
  String get list_navbar_label => 'Orodha';

  @override
  String get category => 'Chuja kwa kategoria';

  @override
  String get category_all => 'All';

  @override
  String get category_search => '(tafuta kategoria)';

  @override
  String get filter => 'Chuja';

  @override
  String get scan => 'Bidhaa kutoka skrini ya Scan';

  @override
  String get scan_history => 'Historia ya kuchanganua';

  @override
  String get search => 'Tafuta';

  @override
  String get search_product_help => 'Tafuta bidhaa,\nchapa au msimbopau';

  @override
  String get search_filter => 'Tafuta kichujio';

  @override
  String get search_history => 'Historia ya utafutaji';

  @override
  String get search_store => 'Tafuta duka';

  @override
  String get search_store_help => 'Kidokezo: ongeza jiji au nchi';

  @override
  String get tap_for_more => 'Gusa ili kuona maelezo zaidi…';

  @override
  String get product => 'Product';

  @override
  String get unknownBrand => 'Chapa isiyojulikana';

  @override
  String get unknownQuantity => 'Kiasi kisichojulikana';

  @override
  String get unknownProductName => 'Jina la bidhaa lisilojulikana';

  @override
  String get label_refresh => 'Refresh';

  @override
  String get label_reload => 'Pakia upya';

  @override
  String get image => 'Picha';

  @override
  String get front_photo => 'Picha ya mbele';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (picha hii inaweza kuwa imepitwa na wakati)';
  }

  @override
  String get outdated_image_short_label => 'inaweza kuwa imepitwa na wakati';

  @override
  String get ingredients => 'Viungo';

  @override
  String get ingredients_editing_instructions =>
      'Weka agizo asili. Onyesha asilimia unapobainishwa. Tenganisha kwa koma au hyphen na utumie mabano kwa viungo vya kiungo.';

  @override
  String get ingredients_editing_error => 'Imeshindwa kuhifadhi viungo.';

  @override
  String get ingredients_editing_image_error =>
      'Imeshindwa kupata picha ya viungo vipya.';

  @override
  String get ingredients_editing_title => 'Hariri Viungo';

  @override
  String get ingredients_photo => 'Picha ya viungo';

  @override
  String get packaging_editing_instructions =>
      'Orodhesha sehemu zote za ufungashaji zilizotenganishwa na koma au mlisho wa laini, na kiasi chake (km 1 au 6) aina (km chupa, sanduku, kopo), nyenzo (km plastiki, chuma, alumini) na ikiwa inapatikana saizi yake (km 33cl) na maagizo ya kuchakata tena.\nMfano: chupa 1 ya glasi ya kuchakata tena, kizibo 1 cha plastiki cha kutupa';

  @override
  String get packaging_editing_error => 'Imeshindwa kuhifadhi kifurushi.';

  @override
  String get packaging_editing_image_error =>
      'Imeshindwa kupata picha ya kifungashio kipya.';

  @override
  String get packaging_editing_title => 'Badilisha Ufungaji';

  @override
  String get nutrition => 'Lishe';

  @override
  String get nutrition_facts_photo => 'Picha za ukweli wa lishe';

  @override
  String get nutrition_facts_editing_title => 'Hariri Ukweli wa Lishe';

  @override
  String get packaging_information => 'Maagizo ya kuchakata tena';

  @override
  String get packaging_information_photo => 'Maagizo ya kuchakata picha';

  @override
  String get missing_product => 'Umepata bidhaa mpya!';

  @override
  String get add_product_take_photos =>
      'Piga picha za kifurushi ili kuongeza bidhaa hii kwenye Ukweli wa Chakula cha Open';

  @override
  String get add_product_take_photos_descriptive =>
      'Tafadhali piga picha kadhaa kwanza. Unaweza kukamilisha bidhaa wakati wowote baadaye.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'Bidhaa Mpya';

  @override
  String get new_product_found_title => 'Bidhaa mpya imepatikana!';

  @override
  String get new_product_found_text =>
      'Hifadhidata yetu shirikishi ina zaidi ya **bidhaa milioni 3**, lakini msimbopau huu haupo: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title =>
      'Ungependa kuondoka kwenye ukurasa huu?';

  @override
  String get new_product_leave_message =>
      'Inaonekana hukuweka chochote. Je, kweli unataka kuondoka kwenye ukurasa huu?';

  @override
  String get new_product_dialog_description =>
      'Tafadhali piga picha za kifurushi ili kuongeza bidhaa hii kwenye hifadhidata yetu ya kawaida';

  @override
  String get new_product_dialog_illustration_description =>
      'Mchoro wa Nutri-Alama na Alama ya Kijani isiyojulikana';

  @override
  String get front_packaging_photo_button_label => 'Picha ya ufungaji wa mbele';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Thibitisha upakiaji wa picha ya kifungashio cha Mbele';

  @override
  String get confirm_button_label => 'Thibitisha';

  @override
  String get send_image_button_label => 'Tuma picha';

  @override
  String get crop_page_action_saving => 'Inahifadhi picha…';

  @override
  String get crop_page_action_cropping => 'Inapunguza picha…';

  @override
  String get crop_page_action_local => 'Inahifadhi toleo la ndani…';

  @override
  String get crop_page_action_local_failed_title =>
      'Lo… kuna kitu na picha yako!';

  @override
  String get crop_page_action_local_failed_message =>
      'Hatuwezi kuchakata picha ndani ya nchi, kabla ya kuituma kwa seva yetu. Tafadhali jaribu tena baadaye au wasiliana nasi kama tatizo litaendelea.';

  @override
  String get crop_page_action_retake => 'Piga picha tena';

  @override
  String get crop_page_too_small_image_title => 'Picha ni ndogo mno!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Ukubwa wa chini zaidi katika pikseli kwa upakiaji wa picha ni ${expectedMinWidth}x$expectedMinHeight. Picha ya sasa ni ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Inatayarisha simu kwa seva…';

  @override
  String get front_packaging_photo_title => 'Picha ya Ufungaji wa Mbele';

  @override
  String get ingredients_photo_title => 'Picha ya viungo';

  @override
  String get nutritional_facts_photo_title => 'Picha ya Ukweli wa Lishe';

  @override
  String get recycling_photo_title => 'Maagizo ya kuchakata tena Picha';

  @override
  String get take_photo_title => 'Piga picha';

  @override
  String get take_more_photo_title => 'Piga picha zaidi';

  @override
  String get front_photo_uploaded => 'Picha ya mbele imepakiwa';

  @override
  String get ingredients_photo_button_label => 'Picha ya viungo';

  @override
  String get ingredients_photo_uploaded => 'Picha ya viungo imepakiwa';

  @override
  String get nutrition_cache_loading_error =>
      'Haiwezi kupakia virutubishi kutoka kwa akiba';

  @override
  String get nutritional_facts_photo_button_label => 'Picha za ukweli wa lishe';

  @override
  String get nutritional_facts_input_button_label => 'Jaza ukweli wa lishe';

  @override
  String get nutritional_facts_added => 'Ukweli wa lishe umeongezwa';

  @override
  String get categories_added => 'Kategoria zimeongezwa';

  @override
  String get new_product_title_nutriscore => 'Compute the Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Tusaidie kwa kujaza angalau kategoria na maadili ya lishe';

  @override
  String get new_product_title_environmental_score =>
      'Kuhesabu Alama ya Kijani';

  @override
  String get new_product_subtitle_environmental_score =>
      'Ipate kwa kujaza angalau kategoria';

  @override
  String get new_product_additional_environmental_score =>
      'Fanya hesabu ya Alama ya Kijani iwe sahihi zaidi ukitumia asili, vifungashio na zaidi';

  @override
  String get new_product_title_nova =>
      'Kuhesabu kiwango cha usindikaji wa chakula (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Ipate kwa kujaza kategoria ya chakula na viungo';

  @override
  String get new_product_desc_nova_unknown =>
      'Kiwango cha usindikaji wa chakula hakijulikani';

  @override
  String get new_product_title_pictures => 'Bidhaa mpya';

  @override
  String get new_product_title_pictures_details =>
      'Tafadhali piga picha zifuatazo na injini ya Open Food Facts inaweza kusuluhisha zingine!';

  @override
  String get new_product_title_misc => 'Na baadhi ya data msingi…';

  @override
  String new_product_done_msg(String username) {
    return 'Asante kwa mchango wako “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Asante kwa mchango wako!';

  @override
  String get new_product_done_button_label => 'Gundua bidhaa iliyokamilishwa';

  @override
  String get hey_incomplete_product_message =>
      'Gusa ili ujibu maswali 3 SASA ili kukokotoa Nutri-Score, Green Score & Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Gusa sasa ili kujibu maswali 2 ili kukusaidia kuchanganua kipodozi hiki!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Gusa sasa ili kujibu maswali 3 ili kusaidia kuchanganua bidhaa hii ya chakula pendwa!';

  @override
  String get hey_incomplete_product_message_product =>
      'Gusa sasa ili kusaidia kukamilisha bidhaa hii!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Picha ya ukweli wa lishe imepakiwa';

  @override
  String get recycling_photo_button_label => 'Inarejeleza picha';

  @override
  String get recycling_photo_uploaded => 'Picha ya kuchakata imepakiwa';

  @override
  String get take_more_photo_button_label => 'Piga picha zaidi';

  @override
  String get other_photo_uploaded => 'Picha mbalimbali zimepakiwa';

  @override
  String get retake_photo_button_label => 'Chukua tena';

  @override
  String get selecting_photo => 'Inachagua picha';

  @override
  String get uploading_image => 'Inapakia picha kwenye seva';

  @override
  String get uploading_image_type_front =>
      'Inapakia picha ya mbele kwa Fungua Ukweli wa Chakula';

  @override
  String get uploading_image_type_ingredients =>
      'Inapakia picha ya viungo kwa Fungua Ukweli wa Chakula';

  @override
  String get uploading_image_type_nutrition =>
      'Inapakia picha ya lishe kwa Fungua Ukweli wa Chakula';

  @override
  String get uploading_image_type_packaging =>
      'Inapakia picha ya kifungashio kwa Fungua Ukweli wa Chakula';

  @override
  String get uploading_image_type_other =>
      'Inapakia picha nyingine kwa Fungua Ukweli wa Chakula';

  @override
  String get uploading_image_type_generic =>
      'Inapakia picha kwenye Fungua Ukweli wa Chakula';

  @override
  String get score_add_missing_ingredients => 'Ongeza viungo vilivyokosekana';

  @override
  String get score_add_missing_packaging_image =>
      'Ongeza picha ya kifungashio ambayo haipo';

  @override
  String get score_add_missing_nutrition_facts =>
      'Ongeza ukweli wa lishe unaokosekana';

  @override
  String get score_add_missing_product_traces =>
      'Ongeza alama za bidhaa ambazo hazipo';

  @override
  String get score_add_missing_product_category => 'Chagua kategoria';

  @override
  String get score_add_missing_precise_product_category =>
      'Chagua aina sahihi zaidi';

  @override
  String get score_add_missing_product_countries =>
      'Ongeza nchi za bidhaa ambazo hazipo';

  @override
  String get score_add_missing_product_emb =>
      'Ongeza misimbo ya ufuatiliaji wa bidhaa ambayo haipo';

  @override
  String get score_add_missing_product_labels =>
      'Ongeza lebo za bidhaa ambazo hazipo';

  @override
  String get score_add_missing_product_origins =>
      'Ongeza asili ya bidhaa inayokosekana';

  @override
  String get score_add_missing_product_stores =>
      'Ongeza maduka ya bidhaa ambayo hayapo';

  @override
  String get score_add_missing_product_brands =>
      'Ongeza chapa za bidhaa zinazokosekana';

  @override
  String get score_update_nutrition_facts => 'Sasisha ukweli wa lishe';

  @override
  String get nutrition_page_title => 'Ukweli wa Lishe';

  @override
  String get nutrition_page_nutritional_info_title => 'Taarifa za lishe';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Thamani zilizoainishwa kwenye bidhaa:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Yes';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'No';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Fungua picha';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Mazoea mazuri: Taarifa za lishe';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Wakati mwingine ukweli wa lishe **haujabainishwa kwenye kifungashio** au kwenye hati iliyotolewa pamoja na bidhaa. Katika kesi hii, na tu katika kesi hii, unaweza kuweka thamani kwa ** NO **.';

  @override
  String get nutrition_page_serving_type_label => 'Thamani za lishe:';

  @override
  String get nutrition_page_per_100g => 'kwa 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'kwa 100g/ml';

  @override
  String get nutrition_page_per_serving => 'kwa kuwahudumia';

  @override
  String get nutrition_page_add_nutrient => 'Ongeza virutubisho';

  @override
  String get nutrition_page_serving_size => 'Saizi ya kutumikia';

  @override
  String get nutrition_page_serving_size_hint =>
      'Weka ukubwa wa kuhudumia (km: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Mazoea mazuri: saizi ya kutumikia';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Thamani hii husaidia **kufanya hesabu ya sawia ya kila kirutubisho kwa saizi ya kuhudumia**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Vizio vinavyoruhusiwa** ni: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫嬍, 公斤, 毫嬍, 公斤, 毫嬍, 公斤, 毫嬍';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** au **60 G** (pendelea ya kwanza)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** au **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Kitengo batili';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Vizio batili';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **pipi** na 2 **biskuti**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Kitengo kinakosekana';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Nambari batili';

  @override
  String get nutrition_page_update_running => 'Kusasisha bidhaa kwenye seva…';

  @override
  String get nutrition_page_update_done => 'Bidhaa imesasishwa!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Tumia kiasi cha bidhaa kama saizi ya kuhudumia';

  @override
  String get nutrition_page_photo_error => 'Imeshindwa kupakia picha';

  @override
  String get more_photos => 'Picha za kuvutia zaidi';

  @override
  String get view_more_photo_button =>
      'Tazama picha zote zilizopo za bidhaa hii';

  @override
  String get no_product_found => 'Hakuna bidhaa iliyopatikana';

  @override
  String get no_location_found => 'Hakuna eneo lililopatikana';

  @override
  String get not_found => 'haijapatikana:';

  @override
  String get refreshing_product => 'Bidhaa ya kuburudisha';

  @override
  String get product_refreshed => 'Bidhaa imeonyeshwa upya';

  @override
  String product_image_accessibility_label(String date) {
    return 'Picha ilipigwa tarehe $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Picha iliyopigwa tarehe $date. Picha hii inaweza kuwa imepitwa na wakati';
  }

  @override
  String get product_image_outdated =>
      'Picha hii inaweza kuwa imepitwa na wakati';

  @override
  String get product_image_outdated_explanations_title =>
      'Picha hii inaweza kuwa imepitwa na wakati';

  @override
  String get product_image_outdated_explanations_content =>
      'Picha hii ilipigwa zaidi ya mwaka mmoja uliopita.\n**Tafadhali angalia kwamba bado ni ya kisasa**.\n\nHili ni **onyo tu**. Ikiwa maudhui bado ni sawa, unaweza kupuuza ujumbe huu.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Badilisha picha ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Ongeza picha ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Piga picha';

  @override
  String get product_image_action_from_gallery =>
      'Chagua kutoka kwenye ghala ya simu yako';

  @override
  String get product_image_action_choose_existing_photo =>
      'Chagua kutoka kwa picha za bidhaa';

  @override
  String get product_image_details_label => 'Taarifa kuhusu picha';

  @override
  String get product_image_details_from_producer => 'Kutoka kwa mtayarishaji';

  @override
  String get product_image_details_contributor => 'Contributor';

  @override
  String get product_image_details_contributor_producer =>
      'Mchangiaji (mtayarishaji)';

  @override
  String get product_image_details_date => 'Tarehe';

  @override
  String get product_image_details_date_unknown => 'Haijulikani';

  @override
  String get homepage_main_card_logo_description =>
      'Karibu kwa Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Changanua** msimbo pau au\n**tafuta** bidhaa';

  @override
  String get homepage_main_card_search_field_hint => 'Tafuta bidhaa';

  @override
  String get homepage_main_card_search_field_tooltip => 'Anza kutafuta';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Habari za hivi punde: $news_title';
  }

  @override
  String get tagline_app_review => 'Je, unapenda programu?';

  @override
  String get tagline_app_review_button_positive => 'Naipenda! 😍';

  @override
  String get tagline_app_review_button_negative => 'Si kweli…';

  @override
  String get tagline_app_review_button_later => 'Niulize baadaye';

  @override
  String get tagline_feed_news_button => 'Jua zaidi';

  @override
  String get app_review_negative_modal_title => 'Hupendi programu yetu?';

  @override
  String get app_review_negative_modal_text =>
      'Unaweza kuchukua sekunde chache kutuambia kwa nini?';

  @override
  String get app_review_negative_modal_positive_button => 'Ndiyo, kabisa!';

  @override
  String get app_review_negative_modal_negative_button => 'No';

  @override
  String get could_not_refresh => 'Haikuweza kuonyesha upya bidhaa';

  @override
  String get product_internet_error_modal_title => 'Hitilafu imetokea!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Hatujaweza kupata maelezo kuhusu bidhaa hii kwa sababu ya hitilafu ya mtandao. Tafadhali angalia muunganisho wako wa intaneti na ujaribu tena.\n\nHitilafu ya ndani:\n$error';
  }

  @override
  String get product_tags_title => 'Tabia za bidhaa';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Hakuna mali';

  @override
  String get product_tags_explanation =>
      'Kwa kuongeza sifa (ufunguo/thamani) kwa bidhaa, unasaidia kuiboresha.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Ongeza sifa';

  @override
  String get add_edit_tags => 'Ongeza au hariri sifa';

  @override
  String get edit_tag => 'Hariri mali';

  @override
  String get remove_tag => 'Ondoa mali';

  @override
  String get tag_key => 'Mali';

  @override
  String get tag_keys => 'Mali';

  @override
  String get tag_key_uneditable => 'Mali (isiyoweza kuhaririwa)';

  @override
  String get tag_key_input_hint => 'Ingiza mali';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Ingiza thamani';

  @override
  String get tag_key_item => 'Mali:';

  @override
  String get tag_value_item => 'Thamani:';

  @override
  String get tag_key_explanations =>
      'Ufunguo lazima uwe na herufi ndogo na bila nafasi yoyote.';

  @override
  String tag_key_already_exists(String property) {
    return 'Lebo iliyo na sifa $property tayari ipo!';
  }

  @override
  String get product_internet_error =>
      'Haiwezekani kuleta maelezo kuhusu bidhaa hii kwa sababu ya hitilafu ya mtandao.';

  @override
  String get cached_results_from => 'Onyesha matokeo kutoka:';

  @override
  String get product_search_same_category => 'Tafuta njia mbadala';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'Kipengele hiki kinaweza kutumika tu kwa bidhaa zilizo na kitengo.\n\nTafadhali hariri bidhaa ili kuongeza kategoria.';

  @override
  String get product_improvement_add_category =>
      'Add a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Ongeza ukweli wa lishe ili kukokotoa Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Add nutrition facts and a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-Alama ya bidhaa hii haiwezi kuhesabiwa, ambayo inaweza kuwa kutokana na mfano kategoria isiyo ya kawaida. Ikiwa hii inachukuliwa kuwa kosa, tafadhali wasiliana nasi.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Picha ya lishe imepitwa na wakati: tafadhali ionyeshe upya.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Alama ya Kijani huzingatia asili ya viungo. Tafadhali piga picha ya orodha ya viambato na/au dai lolote la kijiografia au uhariri bidhaa, ili ziweze kuzingatiwa.';

  @override
  String get country_chooser_label => 'Tafadhali chagua nchi';

  @override
  String get currency_chooser_label => 'Tafadhali chagua sarafu';

  @override
  String get country_change_message => 'Umebadilisha nchi.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Je, ungependa kubadilisha sarafu kutoka $previousCurrency hadi $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Tafadhali chagua nchi:';

  @override
  String get country_chooser_label_from_settings => 'Nchi yako';

  @override
  String get country_selection_explanation =>
      'Baadhi ya vipengele vya mazingira ni mahususi kwa eneo';

  @override
  String get product_removed_comparison =>
      'Bidhaa imeondolewa kutoka kwa kulinganisha';

  @override
  String get native_app_settings => 'Mipangilio ya Programu Asilia';

  @override
  String get native_app_description =>
      'Fungua mipangilio ya mifumo ya Ukweli wa Chakula Huria';

  @override
  String get product_removed_history => 'Bidhaa imeondolewa kwenye historia';

  @override
  String get product_removed_list => 'Bidhaa imeondolewa kwenye orodha';

  @override
  String get product_could_not_remove => 'Haikuweza kuondoa bidhaa';

  @override
  String get no_prodcut_in_list => 'Hakuna bidhaa katika orodha hii';

  @override
  String get no_product_in_section => 'Hakuna bidhaa katika sehemu hii';

  @override
  String get recently_seen_products => 'Bidhaa zote zilizotazamwa';

  @override
  String get clear => 'Wazi';

  @override
  String get clear_long => 'Futa orodha';

  @override
  String get really_clear => 'Je, kweli unataka kufuta orodha hii?';

  @override
  String pct_match(Object percent) {
    return '$percent% inayolingana';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count siku zilizopita',
      one: 'siku moja iliyopita',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count masaa iliyopita',
      one: 'saa moja iliyopita',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minutes ago',
      one: 'dakika moja iliyopita',
      zero: 'chini ya dakika moja iliyopita',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count miezi iliyopita',
      one: 'mwezi mmoja uliopita',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count wiki zilizopita',
      one: 'wiki moja iliyopita',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Linganisha $count Bidhaa',
      one: 'Linganisha Bidhaa moja',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bidhaa zilizochaguliwa',
      one: 'Bidhaa moja iliyochaguliwa',
      zero: 'Hakuna bidhaa iliyochaguliwa',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Linganisha bidhaa zilizochaguliwa';

  @override
  String get delete_products_mode => 'Futa bidhaa zilizochaguliwa';

  @override
  String get select_all_products_mode => 'Chagua bidhaa zote';

  @override
  String get select_none_products_mode => 'Usichague yoyote';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle =>
      'Tafadhali chagua angalau bidhaa mbili';

  @override
  String get retry_button_label => 'Jaribu tena';

  @override
  String get connect_with_us => 'Ungana nasi';

  @override
  String get tiktok => 'Tufuate kwenye TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Tufuate kwenye Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Tufuate kwenye X (zamani Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Tufuate kwenye Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Tufuate kwenye BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blogu';

  @override
  String get faq => 'Maswali Yanayoulizwa Mara kwa Mara';

  @override
  String get discover => 'Gundua';

  @override
  String get how_to_contribute => 'Jinsi ya Kuchangia';

  @override
  String get hint_knowledge_panel_message =>
      'Unaweza kugonga sehemu yoyote ya kadi ili kupata maelezo zaidi kuhusu unachokiona. Ijaribu sasa!';

  @override
  String get permissions_page_title => 'Ufikiaji wa kamera';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'Ukibadilisha nia yako, chaguo hili linaweza kuwashwa na kuzimwa wakati wowote kutoka kwa mipangilio.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'Mfumo wa Uendeshaji: Android (SDK Int: $sdkInt / Toleo: $release)\nMfano: $model\nBidhaa: $product\nKifaa: $device\nChapa:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'Mfumo wa Uendeshaji: iOS ($version)\nMuundo: $model\nMuundo uliojanibishwa: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nToleo la programu:$appVersion\nNambari ya muundo wa programu:$appBuildNumber\nJina la kifurushi cha programu:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'Kataa';

  @override
  String get ask_me_later_button_label => 'Baadaye';

  @override
  String get are_you_sure => 'Je, una uhakika?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Nenda zaidi kwenye $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Karibu !';

  @override
  String get onboarding_home_welcome_text2 =>
      'Programu inayokusaidia kuchagua chakula ambacho kinafaa kwa **wewe** na **sayari**!';

  @override
  String get onboarding_continue_button => 'Endelea';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Inapakia mfano wa bidhaa yako ya kwanza';

  @override
  String get onboarding_welcome_warning =>
      'Samahani, ni mfano wetu wa bidhaa, huwezi kuihariri :)';

  @override
  String get product_list_your_ranking => 'Nafasi yako';

  @override
  String get product_list_empty_icon_desc => 'Historia haipatikani';

  @override
  String get product_list_empty_title => 'Anza kuchanganua';

  @override
  String get product_list_empty_message =>
      'Bidhaa zilizochanganuliwa zitaonekana hapa na unaweza kuangalia maelezo ya kina kuzihusu';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'bidhaa',
      one: 'product',
      zero: 'product',
    );
    return 'Inaonyesha upya $_temp0 katika historia yako';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Bidhaa',
      one: 'Bidhaa',
      zero: 'Bidhaa',
    );
    return '$_temp0 onyesha upya umekamilika';
  }

  @override
  String get product_list_compare_side_by_side =>
      'Linganisha upande kwa upande';

  @override
  String get loading_dialog_default_title => 'Inapakua data';

  @override
  String get loading_dialog_default_error_message => 'Haikuweza kupakua data';

  @override
  String get account_delete => 'Futa akaunti';

  @override
  String get account_delete_title => 'Futa akaunti yangu';

  @override
  String get user_profile => 'Akaunti';

  @override
  String get user_profile_title_guest => 'Karibu!';

  @override
  String get user_profile_subtitle_guest =>
      'Ingia au ujisajili ili ujiunge na jumuiya ya Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Fungua kuingia kwa Ukweli wa Chakula: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Karibu $id!';
  }

  @override
  String get email_subject_account_deletion => 'Futa akaunti';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hujambo, tafadhali futa akaunti yangu ya Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Maombi';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Bidhaa';

  @override
  String get settings_app_miscellaneous => 'Mbalimbali';

  @override
  String get camera_play_sound_title => 'Cheza sauti kwenye uchanganuzi';

  @override
  String get camera_play_sound_subtitle =>
      'Italia kwenye kila uchanganuzi uliofaulu';

  @override
  String get camera_window_accessibility_label =>
      'Changanua msimbopau kwa kamera yako';

  @override
  String get app_haptic_feedback_title => 'Vibration & Haptics';

  @override
  String get app_haptic_feedback_subtitle =>
      'Mitetemo baada ya kutekeleza baadhi ya vitendo (msimbo pau umewekwa, bidhaa imeondolewa…).';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Ikiwashwa, ripoti za kuacha kufanya kazi huwasilishwa kiotomatiki kwenye mfumo wa kufuatilia makosa ya Open Food Facts, ili hitilafu ziweze kurekebishwa na hivyo kuboresha programu.';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Hariri Picha';

  @override
  String get permission_photo_error => 'Hitilafu';

  @override
  String get permission_photo_denied_title =>
      'Ruhusu matumizi ya kamera kuchanganua misimbopau';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Kwa matumizi yaliyoboreshwa, tafadhali ruhusu $appName kufikia kamera yako. Utaweza kuchanganua misimbopau moja kwa moja.';
  }

  @override
  String get permission_photo_denied_button => 'Ruhusu';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Ruhusa imekataliwa';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Kwa vile hapo awali ulinyima ruhusa ya kamera, lazima uiruhusu wewe mwenyewe kutoka kwa Mipangilio.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Fungua mipangilio';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Ghairi';

  @override
  String get permission_photo_none_found => 'Hakuna kamera iliyotambuliwa';

  @override
  String get permission_photo_denied => 'Hakuna ufikiaji wa kamera uliopewa';

  @override
  String get show_product_pictures => 'Onyesha picha za bidhaa';

  @override
  String get edit_product_label => 'Hariri bidhaa';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Inapakia masahihisho yako…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Mabadiliko yako yanatumwa **chinichini** (au baadaye iwapo kutatokea hitilafu).\nUnaweza kuendelea kuhariri sehemu zingine za bidhaa.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Mabadiliko yako yanatumwa **chinichini** (au baadaye iwapo kutatokea hitilafu).';

  @override
  String get edit_product_label_short => 'Hariri';

  @override
  String edit_product_form_item_help(String value) {
    return 'Jinsi ya kuingiza \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Tafadhali weka thamani isiyo tupu!';

  @override
  String get edit_product_form_item_error_existing => 'Thamani hii tayari ipo!';

  @override
  String get edit_product_form_item_add_action_brand => 'Ongeza chapa mpya';

  @override
  String get edit_product_form_item_add_action_label => 'Ongeza lebo mpya';

  @override
  String get edit_product_form_item_add_action_store => 'Ongeza duka jipya';

  @override
  String get edit_product_form_item_add_action_origin => 'Ongeza asili mpya';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Ongeza msimbo mpya wa ufuatiliaji';

  @override
  String get edit_product_form_item_add_action_country => 'Ongeza nchi mpya';

  @override
  String get edit_product_form_item_add_action_category => 'Ongeza aina mpya';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Ongeza ufuatiliaji mpya';

  @override
  String get edit_product_form_item_add_suggestion => 'Ongeza pendekezo';

  @override
  String get edit_product_form_item_deny_suggestion => 'Kataa pendekezo';

  @override
  String get edit_product_form_item_details_title => 'Maelezo ya msingi';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Jina la bidhaa, chapa, wingi';

  @override
  String get edit_product_form_item_other_details_title => 'Maelezo ya ziada';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Tovuti…';

  @override
  String get edit_product_form_item_photos_title => 'Picha';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Ongeza au onyesha upya picha';

  @override
  String get edit_product_form_item_labels_title => 'Lebo na Vyeti';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Lebo za Mazingira, Ubora…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Ingiza lebo (km: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Mazoea mazuri: Lebo';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Tabia yoyote ya bidhaa **ambayo ni ya kweli** na tofauti na nyanja zingine.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Imetengenezwa Ubelgiji, imetolewa nchini Brittany…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Tajiri katika nyuzi, chanzo cha chuma…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Biashara ya haki, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Maduka';

  @override
  String get edit_product_form_item_stores_hint => 'Ingiza duka';

  @override
  String get edit_product_form_item_stores_type => 'duka';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Mazoea mazuri: Maduka';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Ingiza duka ambapo ulinunua bidhaa.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Asili';

  @override
  String get edit_product_form_item_origins_hint =>
      'Ingizo asili (km: Ujerumani)';

  @override
  String get edit_product_form_item_origins_type => 'country';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Mazoea mazuri: Asili';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Ongeza **viashiria vyovyote vya asili unavyoweza kupata kwenye kifurushi**.\nHuhitaji kuwa na wasiwasi kuhusu asili zilizoonyeshwa moja kwa moja kwenye orodha ya viambato.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Nyama ya ng\'ombe kutoka Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soya haitoki Umoja wa Ulaya';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Ingiza nchi (km: Ujerumani)';

  @override
  String get edit_product_form_item_countries_type => 'country';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Mazoea mazuri: Nchi';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Nchi ambazo bidhaa hiyo inapatikana kwa wingi** (bila kujumuisha maduka maalumu kwa bidhaa za kigeni).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Misimbo ya ufuatiliaji';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Ingiza msimbo (km: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'msimbo wa ufuatiliaji';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Mbinu nzuri: Misimbo ya ufuatiliaji';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Katika sehemu hii, unaweza kuingiza misimbo inayohusiana na **alama za kifungashio**, **alama za utambulisho** au **alama za afya**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Mifano ya misimbo ya ufuatiliaji';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Misimbo ya EC** inayotumika katika Jumuiya ya Ulaya kutambua wazalishaji au vifurushi vya chakula:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: msimbo wa nchi wa **Ufaransa**\n**72.264.002**: data ya kijiografia\n**CE**: Jumuiya ya Ulaya';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Misimbo ya EMB** inayotumika Ufaransa:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Traces';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'Ingiza alama (kwa mfano: maharagwe ya soya)';

  @override
  String get edit_product_form_item_categories_title => 'Categories';

  @override
  String get edit_product_form_item_categories_hint => 'category';

  @override
  String get edit_product_form_item_categories_type =>
      'Ingiza kategoria (km: Juisi ya chungwa)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Mazoea mazuri: Kategoria';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Onyesha **kategoria mahususi pekee**.\nKategoria za wazazi zitaongezwa kiotomatiki.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Kategoria inakosa?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Iwapo kategoria haipatikani katika kukamilisha kiotomatiki**, jisikie huru kuiongeza hata hivyo.\nHii itatusaidia kuboresha Ukweli wa Chakula Huria katika nchi yako.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardini katika mafuta';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Juisi ya machungwa kutoka kwa makini';

  @override
  String get edit_product_form_item_exit_title =>
      'Ungependa kuacha bila kuhifadhi?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Je, ungependa kuhifadhi mabadiliko yako kabla ya kuondoka kwenye ukurasa huu?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Hifadhi mabadiliko';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Tupa mabadiliko';

  @override
  String get edit_product_form_item_ingredients_title => 'Viungo';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Vuta ndani na nje kwa kubana skrini';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Kuza ndani na nje picha';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Kwa kutumia ishara **Bana-ili-kukuza**, unaweza kuvuta ndani au nje picha:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Ongeza';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Tafadhali ingiza maandishi kwanza';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Ondoa';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Hifadhi hariri yako';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Ghairi uhariri wako';

  @override
  String get edit_product_form_item_packaging_title =>
      'Maagizo ya kuchakata picha';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Nutrition facts';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Lishe, maudhui ya pombe…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Mazoea mazuri: Ukweli wa lishe';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Maadili ya lishe';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Kwanza, chagua ikiwa **maadili yametolewa**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Nutrition facts';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Kisha, ingiza thamani za lishe **kama ilivyoonyeshwa kwenye kifungashio**. Ikiwa hakuna thamani, unaweza kubofya kwenye icon ya \"Jicho\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Umekosa uwanja?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Ingizo likikosekana, unaweza **kubofya ikoni ya \"Plus\"** ili kuliongeza (km: vitamini D, magnesiamu…).';

  @override
  String get edit_product_form_save => 'Hariri';

  @override
  String get edit_product_ingredients_photo_title => 'Picha ya viungo';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Picha ya ufungaji';

  @override
  String get edit_product_packaging_list_title => 'Orodha ya ufungaji';

  @override
  String get no_data_available => 'Hakuna data inayopatikana';

  @override
  String get product_field_website_title => 'Tovuti';

  @override
  String get origins_editing_title => 'Hariri Asili';

  @override
  String get completed_basic_details_btn_text => 'Kamilisha maelezo ya msingi';

  @override
  String get not_implemented_snackbar_text => 'Bado haijatekelezwa';

  @override
  String get category_picker_page_appbar_text => 'Categories';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Chambua viungo kutoka kwa picha';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Kuchimba viungo\nkutoka kwenye picha';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Inapakia picha…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Kwa nini naona ujumbe huu?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Ili kutumia kipengele cha \"Nyoa viungo\", picha inahitaji kupakiwa kwanza.\n\nTafadhali subiri sekunde chache au uziweke wewe mwenyewe.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Onyesha upya picha';

  @override
  String get edit_packaging_extract_btn_text =>
      'Dondoo kifungashio\nkutoka kwenye picha';

  @override
  String get edit_packaging_extract_btn_text_short => 'Dondoo ufungaji';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Kuchimba ufungaji kutoka kwa picha';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Inapakia picha…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Kwa nini naona ujumbe huu?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Ili kutumia kipengele cha \"Dondoo la ufungashaji\", picha inahitaji kupakiwa kwanza.\n\nTafadhali subiri sekunde chache au uziweke wewe mwenyewe.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Onyesha upya picha';

  @override
  String get edit_ocr_extract_failed =>
      'Imeshindwa kugundua maandishi kwenye picha.';

  @override
  String get edit_ocr_extract_disabled_title => 'Hakuna picha!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Ili kutumia kipengele cha uchimbaji wa maandishi, lazima kwanza upige picha.';

  @override
  String get user_list_dialog_new_title => 'Orodha mpya ya bidhaa';

  @override
  String get user_list_dialog_rename_title => 'Ipe orodha jina upya';

  @override
  String get user_list_subtitle_product => 'Orodha';

  @override
  String get user_list_title => 'Your lists';

  @override
  String get user_list_add_product => 'Ongeza bidhaa kwenye orodha zako';

  @override
  String get user_list_button_new => 'Unda orodha mpya';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Ongeza kwenye orodha';

  @override
  String get added_to_list_msg => 'Imeongezwa kwenye orodha';

  @override
  String get user_list_popup_clear => 'Futa historia yako';

  @override
  String get user_list_popup_rename => 'Badilisha jina';

  @override
  String get user_list_name_hint => 'Orodha yangu';

  @override
  String get user_list_name_error_empty => 'Jina ni lazima';

  @override
  String get user_list_name_error_already => 'Jina hilo tayari limetumika';

  @override
  String get user_list_name_error_same => 'Hilo ni jina moja';

  @override
  String get user_list_name_input_hint => 'Jina la orodha';

  @override
  String get try_again => 'Jaribu Tena';

  @override
  String get there_was_an_error => 'Kulikuwa na hitilafu';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Hakuna kategoria iliyopatikana ya $items';
  }

  @override
  String get camera_toggle_camera =>
      'Badilisha kati ya kamera ya nyuma na ya mbele';

  @override
  String get camera_toggle_flash => 'WASHA au ZIMA mweko wa kamera';

  @override
  String get camera_enable_flash => 'Washa mweko';

  @override
  String get camera_disable_flash => 'Zima flash';

  @override
  String get camera_flash_error_dialog_title => 'Hitilafu imetokea!';

  @override
  String get camera_flash_error_dialog_message =>
      'Hitilafu imetokea wakati wa kubadilisha hali ya mweko wako. Tafadhali hakikisha kuwa simu yako mahiri bado haijawashwa tochi.';

  @override
  String get category_picker_no_category_found_button => 'Nyuma';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Bofya ili kufungua katika kivinjari chako au katika programu (ikiwa imesakinishwa)';

  @override
  String get dev_preferences_screen_title => 'Hali ya DEV';

  @override
  String get dev_preferences_screen_subtitle =>
      'Fikia vipengele vya majaribio na zana za ukuzaji';

  @override
  String get dev_preferences_reset_onboarding_title => 'Anzisha upya kuabiri';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Kisha unapaswa kuanzisha upya Programu ili kuiona tena.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Badili kati ya openfoodfacts.org (PROD) na test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Vigezo vya mazingira ya mtihani';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL ya msingi kwa env ya jaribio la sasa: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Mpangilio wa mazingira wa majaribio';

  @override
  String get dev_preferences_ml_kit_title => 'Tumia ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'basi unapaswa kuanzisha upya programu hii';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Kitufe cha ziada kwenye ukurasa wa bidhaa';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Badilisha viungo kupitia kitufe cha paneli ya muhtasari';

  @override
  String get dev_preferences_export_history_title => 'Hamisha Historia';

  @override
  String get dev_preferences_export_history_progress_error => 'ubaguzi';

  @override
  String get dev_preferences_export_history_progress_found =>
      'bidhaa kupatikana';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'bidhaa HAIJAPATIKANA';

  @override
  String get dev_preferences_export_history_dialog_title => 'Hamisha historia';

  @override
  String get dev_preferences_button_positive => 'Sawa';

  @override
  String get dev_preferences_button_negative => 'Ghairi';

  @override
  String get dev_preferences_migration_title => 'Uhamisho wa data kutoka V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Hali: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'mafanikio au usakinishaji mpya';

  @override
  String get dev_preferences_migration_status_success => 'mafanikio';

  @override
  String get dev_preferences_migration_status_error => 'kosa';

  @override
  String get dev_preferences_migration_status_in_progress => 'inaendelea';

  @override
  String get dev_preferences_migration_status_required =>
      'inahitajika (bofya ili kuanza)';

  @override
  String get dev_preferences_migration_status_not_started => 'haijulikani';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Itafuta historia na kuweka bidhaa 3 hapo';

  @override
  String get dev_preferences_news_custom_url_title => 'URL maalum ya habari';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL ya faili ya JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Haijawekwa';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Kuonyeshwa upya mara ya mwisho: $date';
  }

  @override
  String get product_type_label_food => 'Chakula';

  @override
  String get product_type_label_beauty => 'Utunzaji wa kibinafsi';

  @override
  String get product_type_label_pet_food => 'Chakula cha kipenzi';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'Aina ya bidhaa';

  @override
  String get product_type_selection_subtitle => 'Chagua aina ya bidhaa hii';

  @override
  String get product_type_selection_empty =>
      'Unahitaji kuchagua aina ya bidhaa kwanza!';

  @override
  String product_type_selection_already(String productType) {
    return 'Huwezi kubadilisha aina ya bidhaa ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Njia ya mkato ya programu ya Bei kwenye ukurasa wa bidhaa';

  @override
  String get prices_app_button => 'Nenda kwenye programu ya Bei';

  @override
  String get prices_website_button => 'Fungua kwenye tovuti ya Bei Fungua';

  @override
  String get prices_bulk_proof_upload_select =>
      'Ongeza lebo za bei moja kwa moja kutoka kwa ghala';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Ukishachagua picha, hutaweza kuzihariri!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Ruhusu jumuiya kuthibitisha bei zilizotolewa na AI.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Lebo za Bei Nyingi';

  @override
  String get prices_bulk_proof_upload_title => 'Upakiaji wa Uthibitisho Wingi';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Kuchagua faili';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Kuanzisha upakiaji';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Kunakili faili ndani #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Inatayarisha upakiaji #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Imeshindwa kwenye picha #$index/$count';
  }

  @override
  String get prices_generic_title => 'Bei';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ongeza $count bei',
      one: 'Ongeza bei',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tuma $count bei',
      one: 'Tuma bei',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Ongeza kipengee';

  @override
  String get prices_add_a_price => 'Ongeza bei';

  @override
  String get prices_add_a_receipt => 'Ongeza risiti';

  @override
  String get prices_add_price_tags => 'Ongeza lebo za bei';

  @override
  String prices_barcode_already(String barcode) {
    return 'Msimbopau huu ($barcode) tayari uko kwenye orodha!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'Hakuna bidhaa bado';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Inatafuta $barcode';
  }

  @override
  String get prices_barcode_enter => 'Weka Msimbo Pau';

  @override
  String get prices_category_enter => 'Kipengee kisicho na msimbopau';

  @override
  String get prices_per_kilogram => 'Bei kwa kilo';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / kitengo';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'Hiari';

  @override
  String get prices_category_error_mandatory => 'Jamii ni ya lazima';

  @override
  String get prices_barcode_reader_action => 'Msomaji wa barcode';

  @override
  String get prices_view_prices => 'Tazama bei';

  @override
  String get prices_list_title => 'Orodha ya bei';

  @override
  String get prices_list_count => 'Idadi ya bei\n';

  @override
  String get prices_list_add_new_price => 'Ongeza\nbei mpya';

  @override
  String get prices_list_empty_title => 'Bado hakuna bei!';

  @override
  String get prices_list_empty_subtitle =>
      'Kuwa wa kwanza kuongeza moja:\nKwa kuchanganua **risiti** au ** lebo ya bei**!';

  @override
  String get prices_entry_shop_not_found => 'Duka lisilojulikana';

  @override
  String prices_entry_menu_title(String user) {
    return 'Ingizo la bei kutoka \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Tazama bei zote za bidhaa hii';

  @override
  String get prices_entry_menu_open_proof => 'Tazama uthibitisho';

  @override
  String get prices_entry_menu_my_prices => 'Tazama bei zangu zingine';

  @override
  String get prices_entry_menu_author_prices =>
      'Tazama bei zingine na mwandishi';

  @override
  String get prices_entry_menu_shop_prices =>
      'Tazama bei zingine kutoka kwa duka';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bei',
      one: 'bei 1',
    );
    return '$_temp0 kwa $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Zote $count bei',
      one: 'Bei moja tu',
      zero: 'Hakuna bei bado',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Bei $pageSize za hivi punde (jumla: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Bei: $price / Store: \"$location\" / Imechapishwa kwenye $date na \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Uthibitisho wazi wa \"$user\"';
  }

  @override
  String get prices_open_proof => 'Fungua uthibitisho wa bei';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'All $count uthibitisho',
      one: 'Ushahidi mmoja tu',
      zero: 'Bado hakuna uthibitisho',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Uthibitisho wa hivi punde $pageSize (jumla: $total)';
  }

  @override
  String get prices_users_empty_title => 'Bado hakuna mchangiaji!';

  @override
  String get prices_users_empty_explanation => 'Kuwa wa kwanza kuongeza bei!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Wachangiaji wakuu $pageSize (jumla: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Bado hakuna duka!';

  @override
  String get prices_locations_empty_explanation =>
      'Kuwa wa kwanza kuongeza bei!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Maeneo ya juu $pageSize (jumla: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count uthibitisho',
      one: 'Ushahidi mmoja',
      zero: 'Hakuna uthibitisho',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bidhaa',
      one: 'Bidhaa moja',
      zero: 'Hakuna bidhaa',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count watumiaji',
      one: 'Mtumiaji mmoja',
      zero: 'Hakuna mtumiaji',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bei',
      one: 'Bei moja',
      zero: 'Hakuna bei',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Bei iliongezwa hapo awali';

  @override
  String get prices_amount_subtitle => 'Kiasi';

  @override
  String get prices_amount_is_discounted => 'Je, imepunguzwa bei?';

  @override
  String get prices_amount_price_normal => 'Bei';

  @override
  String get prices_amount_price_discounted => 'Bei iliyopunguzwa';

  @override
  String get prices_amount_price_not_discounted => 'Bei ya asili';

  @override
  String get prices_amount_no_product => 'Bidhaa moja haipo!';

  @override
  String get prices_amount_price_incorrect => 'Thamani isiyo sahihi';

  @override
  String get prices_amount_price_mandatory => 'Thamani ya lazima';

  @override
  String get prices_currency_subtitle => 'Sarafu';

  @override
  String get prices_date_subtitle => 'Tarehe';

  @override
  String get prices_location_subtitle => 'Duka';

  @override
  String get prices_location_find => 'Tafuta duka';

  @override
  String get prices_location_mandatory => 'Unahitaji kuchagua duka!';

  @override
  String get prices_location_search_broader =>
      'Je, hukuweza kupata ulichokuwa unatafuta? Hebu tujaribu utafutaji mpana zaidi!';

  @override
  String get prices_proof_subtitle => 'Ushahidi';

  @override
  String get prices_proof_empty_title => 'Hakuna ushahidi bado!';

  @override
  String get prices_proof_empty_explanation =>
      'Anza kwa kuongeza picha ya **risiti** au ** lebo ya bei**!';

  @override
  String get prices_proof_find => 'Chagua uthibitisho';

  @override
  String get prices_proof_change => 'Badilisha uthibitisho';

  @override
  String get prices_proof_receipt => 'Risiti';

  @override
  String get prices_proof_price_tag => 'Lebo ya bei';

  @override
  String get prices_proof_mandatory => 'Unahitaji kuchagua uthibitisho!';

  @override
  String get prices_add_validation_error => 'Hitilafu ya uthibitishaji';

  @override
  String get prices_privacy_warning_title => 'Onyo la faragha';

  @override
  String get prices_unknown_product => 'Bidhaa isiyojulikana';

  @override
  String get prices_privacy_warning_main_message =>
      'Bei **zitakuwa za umma**, pamoja na duka wanalorejelea.\n\nHuenda hilo likaruhusu watu wanaojua kuhusu jina lako bandia la Open Food Facts:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Eleza ni eneo gani unaishi';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Jua unachonunua';

  @override
  String get prices_privacy_warning_sub_message =>
      'Ikiwa huna wasiwasi na hilo, tafadhali badilisha jina lako bandia, au ufungue akaunti mpya ya Open Food Facts na uingie kwenye programu nayo.';

  @override
  String get i_refuse => 'nakataa';

  @override
  String get i_accept => 'Nakubali';

  @override
  String get prices_currency_change_proposal_title =>
      'Ungependa kubadilisha sarafu?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Sarafu yako ya sasa ni **$currency**. Je, ungependa kuibadilisha kuwa **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Ndiyo, tumia $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Hapana, weka $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Imekamilika';

  @override
  String get dev_mode_section_server => 'Usanidi wa seva';

  @override
  String get dev_mode_section_news => 'Usanidi wa mtoaji wa habari';

  @override
  String get dev_mode_section_product_page => 'Ukurasa wa bidhaa';

  @override
  String get dev_mode_section_ui => 'Kiolesura cha Mtumiaji';

  @override
  String get dev_mode_section_experimental_features =>
      'Vipengele vya majaribio';

  @override
  String get dev_mode_hide_environmental_score_title => 'Ondoa Alama ya Kijani';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Tumia kikagua tahajia kwa skrini za OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(Viungo na ufungaji)';

  @override
  String get dev_mode_reset_app_language_title => 'Weka upya lugha ya programu';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Ongeza kadi';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Badili kati ya prices.openfoodfacts.org (PROD) na test env';

  @override
  String get search_history_item_edit_tooltip =>
      'Tumia tena na uhariri utafutaji huu';

  @override
  String get search_history_item_remove_tooltip => 'Ondoa';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Umepakua $totalSize bidhaa zote.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Pakua $count bidhaa zaidi\nTayari zimepakuliwa $downloaded kati ya $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Utafutaji wako wa $search unaendelea.\n\nTafadhali subiri sekunde chache…';
  }

  @override
  String get user_search_contributor_title => 'Bidhaa nilizoongeza';

  @override
  String get user_search_informer_title => 'Bidhaa nilizohariri';

  @override
  String get user_search_photographer_title => 'Bidhaa nilizopiga picha';

  @override
  String get user_search_to_be_completed_title =>
      'Bidhaa zangu za-kuwa-kukamilika';

  @override
  String get user_search_prices_title => 'Bei zangu';

  @override
  String get user_search_proofs_title => 'Ushahidi wangu';

  @override
  String get user_search_proof_title => 'Ushahidi wangu';

  @override
  String search_proof_title(String user) {
    return 'Uthibitisho kutoka kwa \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Bei za wachangiaji: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Bei za Hivi Punde zimeongezwa';

  @override
  String get all_search_prices_top_user_title => 'Wachangiaji wa bei ya juu';

  @override
  String get all_search_prices_top_location_title =>
      'Maduka yenye bei nyingi zaidi';

  @override
  String get prices_contribution_assistant => 'Msaidizi wa Mchango wa Bei';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system =>
      'Ongeza Uthibitisho Nyingi';

  @override
  String get all_search_prices_top_location_single_title => 'Bei katika duka';

  @override
  String get all_search_prices_top_product_title =>
      'Bidhaa zilizo na bei nyingi zaidi';

  @override
  String get all_search_to_be_completed_title => 'Bidhaa zote za kukamilika';

  @override
  String get categorize_products_country_title =>
      'Saidia kuainisha bidhaa katika nchi yako';

  @override
  String get edit_product_action_retake_picture => 'Piga picha tena';

  @override
  String get edit_product_action_take_picture => 'Piga picha';

  @override
  String get edit_product_action_confirm => 'Thibitisha';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Ninakubali Ukweli wa Chakula Huria ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'masharti ya matumizi na mchango';

  @override
  String get analytics_consent_image_semantic_label => 'Aikoni ya uchanganuzi';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Hitilafu mbaya: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Hitilafu mbaya: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Kamilisha maelezo ya msingi';

  @override
  String get edit_photo_button_label => 'Hariri';

  @override
  String get edit_photo_unselect_button_label => 'Acha kuchagua picha';

  @override
  String get edit_photo_select_existing_button_label => 'Chagua picha iliyopo';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Chagua picha kwa kubofya';

  @override
  String get edit_photo_select_existing_download_label =>
      'Inarejesha picha zilizopo…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Hakuna picha zilizopakiwa hapo awali zinazohusiana na bidhaa hii.';

  @override
  String get edit_photo_language_not_this_one =>
      'Bado hakuna picha katika lugha hiyo';

  @override
  String get edit_photo_language_none => 'Hakuna picha bado';

  @override
  String get category_picker_screen_title => 'Categories';

  @override
  String get basic_details => 'Maelezo ya Msingi';

  @override
  String get product_name => 'Jina la Bidhaa';

  @override
  String get product_names => 'Majina ya Bidhaa';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Ongeza tafsiri mpya';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Kabla ya kuthibitisha, tafadhali hakikisha kuwa unaongeza tafsiri tu **ikiwa lugha ipo kwenye kifurushi**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Tazama picha ya mbele';

  @override
  String get add_basic_details_product_name_take_photo => 'Piga picha ya mbele';

  @override
  String get add_basic_details_product_name_hint =>
      'Ingiza jina la bidhaa (kwa mfano: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Ungependa kubadilisha lugha chaguomsingi?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Je, unataka lugha chaguo-msingi ya bidhaa iwekwe \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Mifano mizuri';

  @override
  String get explanation_section_bad_examples => 'Mifano mbaya';

  @override
  String get add_basic_details_product_name_help_title =>
      'Mazoea mazuri: Jina la bidhaa';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Jina la bidhaa ni **jina kuu lililochapishwa kwenye kifurushi**. Inaweza kuwa alama ya biashara iliyosajiliwa.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Kumbuka:** Tafadhali usiongeze tafsiri **ikiwa lugha haipo kwenye kifungashio**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Ketchup ya Nyanya';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Usijumuishe chapa kwenye jina';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Ketchup ya Nyanya ** na Heinz **';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Usitumie alama ®, ™, © au zinazofanana';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tafsiri zingine',
      one: '$count tafsiri nyingine',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Jina la chapa';

  @override
  String get brand_names => 'Majina ya chapa';

  @override
  String get add_basic_details_brand_name_error =>
      'Tafadhali ingiza jina la chapa';

  @override
  String get add_basic_details_brand_names_hint =>
      'Chapa za ingizo (km: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Mazoea mazuri: Chapa';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Ingiza **aina zote za bidhaa**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Chapa kuu';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Chapa kuu**, kwa ujumla inayoonyeshwa wazi kwenye pakiti ya mbele, inapaswa **kuingizwa kwanza**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Bidhaa zingine';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Inapouzwa **na kampuni kubwa**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** inauzwa na **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Inapouzwa na chapa yake **iliyotafsiriwa katika lugha nyingi**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Bonde la Asili** wakati mwingine huandikwa **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Kiasi na uzito';

  @override
  String get add_basic_details_quantity_hint =>
      'Ingiza uzito na ikihitajika kiasi (kwa mfano: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Mazoea mazuri: Kiasi';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Nakili thamani iliyoonyeshwa kwenye bidhaa na **usisahau vizio**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** au **230g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (kwa mayai 6)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(kwa bidhaa yenye masanduku 3, kila moja ya 150g)';

  @override
  String get barcode => 'Barcode';

  @override
  String barcode_barcode(String barcode) {
    return 'Msimbo pau: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Msimbopau batili';

  @override
  String get basic_details_add_success =>
      'Maelezo ya msingi yameongezwa kwa mafanikio';

  @override
  String get basic_details_add_error =>
      'Imeshindwa kuongeza maelezo ya msingi. Tafadhali jaribu tena baada ya muda';

  @override
  String get clear_search => 'Futa utafutaji wako';

  @override
  String get confirm_clear =>
      'Unakaribia kufuta historia yako yote: una uhakika ungependa kuendelea?';

  @override
  String get alert_clear_selected_user_list =>
      'Unakaribia kufuta vipengee vilivyochaguliwa katika historia yako';

  @override
  String get confirm_clear_selected_user_list =>
      'Je, una uhakika ungependa kuendelea?';

  @override
  String get alert_select_items_to_clear =>
      'Tafadhali chagua kipengee kimoja au zaidi ili kufuta';

  @override
  String confirm_clear_user_list(String name) {
    return 'Unakaribia kufuta orodha hii ($name): una uhakika ungependa kuendelea?';
  }

  @override
  String get confirm_delete_user_list_title => 'Ungependa kufuta orodha?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Unakaribia kufuta orodha \"$name\".\nJe, una uhakika ungependa kuendelea?';
  }

  @override
  String get confirm_delete_user_list_button => 'Ndiyo, nathibitisha';

  @override
  String importance_label(String name, String id) {
    return '$name umuhimu: $id';
  }

  @override
  String get user_list_all_title => 'Orodha';

  @override
  String get user_list_all_empty => 'Unda orodha yako ya kwanza';

  @override
  String get product_list_select => 'Chagua orodha';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bidhaa',
      one: 'Bidhaa moja',
      zero: 'Orodha tupu',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Ongeza orodha';

  @override
  String get open_food_preferences_tooltip =>
      'Badilisha mapendeleo yako ya chakula';

  @override
  String get add_photo_button_label => 'Ongeza picha';

  @override
  String get add_packaging_photo_button_label =>
      'Piga picha za maelezo yoyote ya ufungashaji/usafishaji';

  @override
  String get add_origin_photo_button_label =>
      'Piga picha za maelezo yoyote ya asili';

  @override
  String get add_emb_photo_button_label =>
      'Piga picha za maelezo yoyote ya msimbo wa ufuatiliaji';

  @override
  String get add_label_photo_button_label =>
      'Piga picha za maelezo ya lebo na vyeti vyovyote';

  @override
  String get choose_image_source_title => 'Chagua chanzo cha picha';

  @override
  String get choose_image_source_body => 'Tafadhali chagua chanzo cha picha';

  @override
  String get gallery_source_label => 'Matunzio';

  @override
  String get gallery_source_access_denied_dialog_title =>
      'Ufikiaji umekataliwa';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Kwa bahati mbaya, programu haiwezi kufikia matunzio yako, kwa kuwa hapo awali ulinyima ruhusa.\n\nTafadhali nenda kwenye mipangilio ya programu katika Mipangilio ya simu yako -> Picha';

  @override
  String get gallery_source_access_denied_dialog_button => 'Fungua Mipangilio';

  @override
  String get share => 'Shiriki';

  @override
  String share_product_text(String url) {
    return 'Tazama bidhaa hii kwenye Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Tazama bidhaa hii kwenye Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Tazama bidhaa hii kwenye Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Tazama bidhaa hii kwenye Ukweli wa Bidhaa Huria: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Tazama orodha yangu ya bidhaa kwenye Open Food Facts: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Piga picha';

  @override
  String get choose_from_gallery => 'Chagua kutoka kwenye ghala';

  @override
  String get image_upload_queued =>
      'Picha itapakiwa chinichini haraka iwezekanavyo.';

  @override
  String get add_price_queued => 'Bei itatumwa kwa seva haraka iwezekanavyo.';

  @override
  String get background_task_title_full_refresh =>
      'Kuanzisha uonyeshaji upya wa bidhaa zote zilizohifadhiwa ndani';

  @override
  String get background_task_title_folksonomy =>
      'Inaanza kutekeleza vitendo vya seva kwa masasisho ya folksonomy yaliyohifadhiwa ndani';

  @override
  String get background_task_title_top_n =>
      'Kuanzia upakuaji wa bidhaa maarufu zaidi';

  @override
  String get expand_nutrition_facts => 'Panua jedwali la ukweli wa lishe';

  @override
  String get expand_nutrition_facts_body =>
      'Weka jedwali la ukweli wa lishe kupanuliwa';

  @override
  String get expand_ingredients => 'Panua viungo';

  @override
  String get expand_ingredients_body => 'Weka jopo la viungo kupanuliwa';

  @override
  String get no_internet_connection => 'Hakuna muunganisho wa intaneti';

  @override
  String get world_results_label => 'Dunia nzima';

  @override
  String get world_results_action => 'Panua utafutaji wako kwa ulimwengu';

  @override
  String get copy_to_clipboard => 'Nakili';

  @override
  String get paste_from_clipboard => 'Bandika kutoka kwenye ubao wa kunakili';

  @override
  String get no_data_available_in_clipboard =>
      'Hakuna data inayopatikana kwenye ubao wako wa kunakili';

  @override
  String get clipboard_barcode_copy =>
      'Nakili msimbo pau kwenye ubao wa kunakili';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Msimbo upau $barcode umenakiliwa kwenye ubao wa kunakili!';
  }

  @override
  String get open_product_website => 'Fungua bidhaa hii kwenye wavuti';

  @override
  String get language_picker_label => 'Lugha yako';

  @override
  String get country_picker_label => 'Nchi yako';

  @override
  String get currency_picker_label => 'Sarafu yako';

  @override
  String get help_with_openfoodfacts => 'Msaada na OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Bidhaa itasasishwa chinichini haraka iwezekanavyo.';

  @override
  String get no_email_client_available_dialog_title =>
      'Hakuna programu za barua pepe!';

  @override
  String get no_email_client_available_dialog_content =>
      'Tafadhali tutumie mwenyewe barua pepe kwa mobile@openfoodfacts.org';

  @override
  String get all_images => 'Picha Zote';

  @override
  String get selected_images => 'Picha Zilizochaguliwa';

  @override
  String get product_card_remove_product_tooltip => 'Ondoa bidhaa';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Msimbopau mpya umechanganuliwa: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Ondoa bidhaa zote kutoka kwa jukwa';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Tafadhali changanua angalau bidhaa mbili ili kuzilinganisha';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Bofya ili kulinganisha bidhaa ulizochanganua';

  @override
  String get scan_product_loading => 'Umechanganua\nmsimbo pau:';

  @override
  String get scan_product_loading_initial =>
      'Tunatafuta bidhaa hii!\nTafadhali subiri sekunde chache…';

  @override
  String get scan_product_loading_long_request =>
      'Bado tunatafuta bidhaa hii!\nJe, unaona kuwa inachukua muda mrefu kupakia? Vivyo hivyo na sisi…';

  @override
  String get scan_product_loading_unresponsive =>
      'Bado tunatafuta bidhaa hii.\nJe, ungependa kuanzisha upya utafutaji?';

  @override
  String get scan_product_loading_restart_button => 'Anzisha upya utafutaji';

  @override
  String get portion_calculator_description =>
      'Kuhesabu ukweli wa lishe kwa idadi maalum';

  @override
  String get portion_calculator_hint => 'Kiasi ndani';

  @override
  String get portion_calculator_accessibility =>
      'Ingiza kiasi ili kukokotoa ukweli wa lishe';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Tafadhali weka kiasi kati ya $min na $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Data haipo. Hesabu haikuweza kufanywa.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Ukweli wa lishe kwa $grams g (au ml)';
  }

  @override
  String get offline_data => 'Data ya Nje ya Mtandao';

  @override
  String get ocr_image_upload_instruction =>
      'Pakia picha ili kutoa maelezo yaliyomo kiotomatiki.';

  @override
  String get upload_image => 'Pakia Picha';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Imeshindwa kupakua picha';

  @override
  String get image_edit_url_error =>
      'Imeshindwa kuhariri picha kwa sababu URL ya picha haikuwekwa.';

  @override
  String get user_picture_source_remember => 'Kumbuka chaguo langu';

  @override
  String get user_picture_source_ask => 'Uliza kila wakati';

  @override
  String get robotoff_continue => 'Endelea';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count maswali',
      one: 'swali',
    );
    return 'Swali linalofuata $_temp0';
  }

  @override
  String get show_password => 'Onyesha Nenosiri';

  @override
  String get owner_field_info_title => 'Mtayarishaji alitoa maadili';

  @override
  String get owner_field_info_message =>
      'Kwa nembo hiyo tunaangazia data iliyotolewa na mtayarishaji, na ambayo inaweza isiweze kuhaririwa.';

  @override
  String get owner_field_info_close_button => 'Funga maelezo haya';

  @override
  String get owner_field_image =>
      'Picha hii imetolewa na mtayarishaji. Huenda isiweze kuhaririwa.';

  @override
  String get edit_packagings_title => 'Vipengele vya ufungaji';

  @override
  String get edit_packagings_element_add => 'Ongeza sehemu ya ufungaji';

  @override
  String get edit_packagings_completed => 'Ufungaji umekamilika';

  @override
  String edit_packagings_element_title(int index) {
    return 'Sehemu ya ufungashaji #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Idadi ya vitengo';

  @override
  String get edit_packagings_element_hint_units =>
      'Ingiza idadi ya vitengo vya ufungaji vya sura sawa na nyenzo zilizomo kwenye bidhaa.';

  @override
  String get edit_packagings_element_field_shape => 'Umbo';

  @override
  String get edit_packagings_element_hint_shape =>
      'Ingiza jina la umbo lililoorodheshwa katika maagizo ya kuchakata ikiwa yanapatikana, au chagua umbo.';

  @override
  String get edit_packagings_element_example_shape => 'Chupa';

  @override
  String get edit_packagings_element_field_material => 'Nyenzo';

  @override
  String get edit_packagings_element_hint_material =>
      'Weka nyenzo mahususi ikiwa inaweza kubainishwa (msimbo wa nyenzo ndani ya pembetatu mara nyingi unaweza kupatikana kwenye sehemu za vifungashio), au nyenzo ya jumla (kwa mfano plastiki au chuma) ikiwa huna uhakika.';

  @override
  String get edit_packagings_element_example_material => 'Kioo';

  @override
  String get edit_packagings_element_field_recycling =>
      'Maagizo ya kuchakata tena';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Ingiza maagizo ya kuchakata tu ikiwa yameorodheshwa kwenye bidhaa.';

  @override
  String get edit_packagings_element_example_recycling => 'Recycle';

  @override
  String get edit_packagings_element_field_quantity =>
      'Kiasi halisi cha bidhaa kwa kila kitengo';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Ingiza uzito wa wavu au ujazo wa wavu na uonyeshe kitengo (kwa mfano g au ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Uzito wa kitengo tupu (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Ondoa chakula chochote kilichobaki na osha na kavu sehemu ya ufungaji kabla ya kupima. Ikiwezekana, tumia mizani iliyo na usahihi wa 0.1g au 0.01g.';

  @override
  String get background_task_title => 'Michango inayosubiri';

  @override
  String get background_task_subtitle =>
      'Michango yako inahifadhiwa kiotomatiki kwenye seva yetu, lakini si mara zote katika muda halisi.';

  @override
  String get background_task_list_empty =>
      'Hakuna Majukumu ya Mandharinyuma Yanayosubiri';

  @override
  String get background_task_error_server_time_out => 'Muda wa seva umekwisha';

  @override
  String get background_task_error_no_internet =>
      'Hitilafu ya muunganisho wa mtandao. Jaribu baadaye.';

  @override
  String get background_task_operation_unknown =>
      'aina ya operesheni isiyojulikana';

  @override
  String get background_task_operation_details => 'mabadiliko ya kina';

  @override
  String get background_task_operation_image => 'kupakia picha';

  @override
  String get background_task_operation_refresh =>
      'kuonyesha upya kumechelewa baada ya upakiaji wa picha';

  @override
  String get background_task_run_started => 'ilianza';

  @override
  String get background_task_run_not_started => 'haijaanza bado';

  @override
  String get background_task_run_to_be_deleted => 'kufutwa';

  @override
  String get background_task_question_stop =>
      'Je, ungependa kusitisha jukumu hilo HARAKA?';

  @override
  String get feed_back => 'Maoni';

  @override
  String get undo => 'Tendua';

  @override
  String get copy_email_to_clip_board =>
      'Nakili barua pepe kwenye ubao wa kunakili';

  @override
  String get please_send_us_an_email_to =>
      'Tafadhali tutumie mwenyewe barua pepe kwa';

  @override
  String get email_copied_to_clip_board =>
      'Barua pepe imenakiliwa kwenye ubao wa kunakili!';

  @override
  String get select_accent_color => 'Chagua Rangi ya Lafudhi';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Bluu';

  @override
  String get color_cyan => 'Cyan';

  @override
  String get color_green => 'Kijani';

  @override
  String get color_light_brown => 'Chaguomsingi';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Chungwa';

  @override
  String get color_pink => 'Pink';

  @override
  String get color_red => 'Nyekundu';

  @override
  String get color_rust => 'Kutu';

  @override
  String get color_teal => 'Teal';

  @override
  String get text_contrast_mode => 'Utofautishaji wa Maandishi';

  @override
  String get contrast_high => 'Juu';

  @override
  String get contrast_medium => 'Kati';

  @override
  String get contrast_low => 'Chini';

  @override
  String get product_refresher_internet_not_found => 'Bidhaa haijapatikana!';

  @override
  String get product_refresher_internet_not_connected =>
      'Hujaunganishwa kwenye intaneti!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Seva chini ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Hitilafu ya seva ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Bidhaa haijapatikana!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Bidhaa iliyo na msimbopau ifuatayo haipo kwenye hifadhidata yetu: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Hakuna muunganisho wa mtandao!';

  @override
  String get product_loader_network_error_message =>
      'Tafadhali hakikisha kwamba simu yako mahiri iko kwenye mtandao wa WiFi au imewasha data ya simu ya mkononi';

  @override
  String get page_not_found_title => 'Ukurasa haujapatikana!';

  @override
  String get page_not_found_button => 'Rudi kwenye ukurasa wa nyumbani';

  @override
  String get download_data => 'Pakua data';

  @override
  String get download_top_products =>
      'Pakua bidhaa 1000 bora katika nchi yako ili uchanganue papo hapo';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bidhaa',
    );
    return 'Pakua bidhaa bora $_temp0 katika nchi yako ili uchanganue papo hapo';
  }

  @override
  String get download_in_progress => 'Kupakua data\nHii inaweza kuchukua muda';

  @override
  String downloaded_products(int num) {
    return '$num bidhaa zimeongezwa';
  }

  @override
  String get update_offline_data => 'Sasisha data ya bidhaa nje ya mtandao';

  @override
  String get update_local_database_sub =>
      'Sasisha hifadhidata ya bidhaa za ndani kwa data ya hivi punde kutoka Ukweli wa Open Food';

  @override
  String get clear_local_database => 'Futa data ya bidhaa nje ya mtandao';

  @override
  String get clear_local_database_sub =>
      'Futa data yote ya bidhaa za ndani kutoka kwa programu yako ili kupata nafasi';

  @override
  String deleted_products(int num) {
    return '$num bidhaa zimefutwa';
  }

  @override
  String get loading => 'Loading…';

  @override
  String get know_more => 'Fahamu Zaidi';

  @override
  String get offline_data_desc =>
      'Bofya ili kujua zaidi kuhusu data ya nje ya mtandao';

  @override
  String get offline_product_data_title => 'Data ya bidhaa nje ya mtandao';

  @override
  String available_for_download(int num) {
    return '$num bidhaa zinazopatikana kwa kuchanganua mara moja';
  }

  @override
  String get country_selector_title => 'Chagua nchi yako:';

  @override
  String get currency_selector_title => 'Chagua sarafu yako:';

  @override
  String get language_selector_title => 'Chagua lugha yako:';

  @override
  String get language_selector_section_selected => 'Lugha zilizochaguliwa';

  @override
  String get language_selector_section_frequently_used =>
      'Inatumika mara kwa mara';

  @override
  String get action_delete_list => 'Futa';

  @override
  String get action_change_list => 'Badilisha orodha ya sasa';

  @override
  String get product_list_create => 'Unda';

  @override
  String get product_list_create_tooltip => 'Unda orodha mpya';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (New calculation)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (New calculation)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unknown Nutri-Score (New calculation)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score is not applicable';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score is not applicable (New calculation)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Alama ya Kijani A';

  @override
  String get environmental_score_b_new => 'Alama ya Kijani B';

  @override
  String get environmental_score_c_new => 'Alama ya Kijani C';

  @override
  String get environmental_score_d_new => 'Alama ya Kijani D';

  @override
  String get environmental_score_e_new => 'Alama ya Kijani E';

  @override
  String get environmental_score_unknown_new => 'Alama ya Kijani Isiyojulikana';

  @override
  String get environmental_score_not_applicable_new => 'Green-Alama haitumiki';

  @override
  String get nova_group_generic_new =>
      'Vyakula vilivyosindikwa zaidi - vikundi vya NOVA';

  @override
  String get nova_group_1 => 'Kundi la 1 la NOVA';

  @override
  String get nova_group_2 => 'Kundi la 2 la NOVA';

  @override
  String get nova_group_3 => 'Kundi la 3 la NOVA';

  @override
  String get nova_group_4 => 'Kundi la 4 la NOVA';

  @override
  String get nova_group_unknown => 'Kikundi kisichojulikana cha NOVA';

  @override
  String get nutrition_facts => 'Viwango vya Virutubisho';

  @override
  String get faq_title_partners => 'Washirika na Walezi wa NGO';

  @override
  String get faq_title_vision =>
      'Dira ya Ukweli kuhusu Chakula, Dhamira, Maadili na Mipango';

  @override
  String get faq_title_install_beauty =>
      'Sakinisha Fungua Ukweli wa Urembo ili kuunda hifadhidata ya vipodozi';

  @override
  String get faq_title_install_pet =>
      'Sakinisha Ukweli wa Wazi wa Chakula cha Kipenzi ili kuunda hifadhidata ya vyakula vipenzi';

  @override
  String get faq_title_install_product =>
      'Sakinisha Ukweli wa Bidhaa Huria ili kuunda hifadhidata ya bidhaa ili kupanua maisha ya vitu';

  @override
  String get faq_nutriscore_nutriscore =>
      'Hesabu mpya ya Alama ya Nutri: ni nini kipya?';

  @override
  String get contact_title_pro_page =>
      'Pro? Ingiza bidhaa zako katika Ukweli wa Chakula Huria';

  @override
  String get contact_title_pro_email => 'Mawasiliano ya Mtayarishaji';

  @override
  String get contact_title_press_page => 'Bonyeza Ukurasa';

  @override
  String get contact_title_press_email => 'Bonyeza Anwani';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'Jiandikishe kwa kalenda yetu ya jamii';

  @override
  String get hunger_games_loading_line1 => 'Tafadhali tupe sekunde chache…';

  @override
  String get hunger_games_loading_line2 => 'Tunapakua maswali!';

  @override
  String get hunger_games_error_label =>
      'Argh! Hitilafu fulani imetokea… na hatukuweza kupakia maswali.';

  @override
  String get hunger_games_error_retry_button => 'Hebu tujaribu tena!';

  @override
  String get reorder_attribute_action => 'Panga upya sifa';

  @override
  String get link_cant_be_opened =>
      'Kiungo hiki hakiwezi kufunguliwa kwenye kifaa chako. Tafadhali hakikisha kuwa umesakinisha kivinjari.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Maelezo ya $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Maelezo ya $pageName na $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Shiriki';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Wapi kupata hesabu mpya ya Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Alama inatumika katika nchi 7: Ufaransa, Ujerumani, Ubelgiji, Uhispania, Luxemburg, Uholanzi na Uswizi.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Watengenezaji wana angalau miaka **2** hivi punde zaidi baada ya kutia saini amri **kubadilisha** hesabu ya zamani na mpya.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Alama ya Kijani ni nini?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Alama ya Kijani ni nembo inayolenga kukujulisha kuhusu **athari ya chakula** kwa mazingira.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Msimbo wa rangi hutofautiana kutoka kijani kibichi (**A+**) kwa **bidhaa zenye athari kidogo** hadi nyekundu iliyokolea (**F**) kwa **bidhaa zenye athari kubwa**.';

  @override
  String get guide_greenscore_logos_caption => 'Nembo za Green-Alama';

  @override
  String get guide_greenscore_lca_title =>
      'Msingi: Tathmini ya mzunguko wa maisha (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Tathmini ya kisayansi ya kategoria za chakula';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Kwa kila aina ya bidhaa, alama **kielelezo** huanzishwa kwa kutumia data kutoka hifadhidata ya mazingira ya Agribalyse (iliyoundwa na ADEME na INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Uchambuzi wa mzunguko wa maisha** ni mbinu sanifu ya tathmini ya kufanya tathmini ya mazingira ya hatua nyingi na ya vigezo vingi.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Inapima:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 hatua za uzalishaji';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Packaging';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title =>
      'Viashiria 14 vya athari za mazingira';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Mabadiliko ya hali ya hewa / alama ya kaboni';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Upungufu wa safu ya ozoni';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Mionzi ya ionizing';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Ardhi';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Matumizi ya maji na nishati';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Uchafuzi wa hewa';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Maji ya baharini na safi (chembe, asidi, eutrophication)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Upungufu wa rasilimali.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonasi na adhabu';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Ili zawadi bidhaa bora ndani ya kitengo, sisi kisha kuweka ** bonasi na adhabu kulingana na vigezo kadhaa **:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Bonasi** hutolewa kwa bidhaa ambazo zina **lebo rasmi, lebo au uthibitisho unaohakikisha manufaa ya kimazingira** (biashara ya kikaboni, haki, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origin of ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '** bonasi** hutolewa kulingana na asili ya viungo. Bonasi hii inazingatia **athari kwa usafiri** na pia **sera ya mazingira** ya kila nchi ya mzalishaji.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Adhabu** inatolewa kwa bidhaa ambazo zina viambato ambavyo vina athari kubwa **hasi kwa viumbe hai na mifumo ikolojia**, kama vile mafuta ya mawese, ambayo uzalishaji wake unawajibika kwa ukataji miti mkubwa.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Packaging';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Adhabu** inakokotolewa ili kuzingatia **uduara wa kifungashio** (matumizi ya malighafi iliyosindikwa na kutumika tena) na upakiaji kupita kiasi.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Ili kuhesabu kwa usahihi Alama ya Kijani, ni muhimu kuwa na **maelezo ambayo si lazima yabainishwe kwenye kifurushi** (kama vile asili na asilimia kamili ya kila kiungo) au ambayo ni nadra kupatikana katika muundo unaoweza kutumika (kama vile orodha ya vipengele vyote vya kifungashio na aina sahihi za plastiki zinazotumika).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Thamani za wastani hutumiwa wakati maelezo haya bado hayajapatikana**, lakini sasa tunatoa wito kwa kila mtu atusaidie kukusanya taarifa hii ambayo itakuwa muhimu sana kwa Alama ya Kijani lakini pia kwa matumizi mengine mengi.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Wananchi wanawezaje kusaidia?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Wananchi wote wanaweza kutusaidia kukusanya na kupanga taarifa zilizopo kwenye bidhaa au zinazoweza kutolewa kutoka kwao, kama vile taarifa kuhusu **ufungaji**: \"Mission Emballages\": hesabu kubwa ya shirikishi ya ufungaji wa bidhaa zote za chakula (kwa Kifaransa).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Jinsi watengenezaji wanaweza kusaidia';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Watengenezaji wanaweza kututumia taarifa zao moja kwa moja kupitia jukwaa letu lisilolipishwa la watayarishaji.';

  @override
  String get guide_greenscore_better_product_title =>
      'Ni bidhaa gani bora kwa sayari?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Inaweza kuwa ngumu kusema';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Kuchagua chakula endelevu ni mojawapo ya mambo yenye nguvu zaidi tunaweza kufanya kwa ajili ya hali ya hewa, kwani **mfumo wetu wa chakula duniani unawajibika kwa zaidi ya robo ya uzalishaji wote wa gesi chafuzi**.\n(Chanzo: Poore & Nemecek, Sayansi, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Una nguvu!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Habari njema ni kwamba hii inatupa njia nzuri ya kuunda mabadiliko.\n**Kila mmoja wetu hula karibu milo 1,000 kila mwaka**. Hizo ni fursa 1,000 za **kuchagua mustakabali bora wa sayari**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Inasaidia kuwajibika na kuamua';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Kuchagua chakula endelevu kunaweza kuhisi kuwa ngumu. Lebo zinachanganya na habari mara nyingi hukosekana. Alama ya Kijani iliundwa ili kurahisisha, kukupa ukadiriaji wa **wazi**, **kulingana na sayansi**, na **wazi** wa mazingira kwa bidhaa za chakula, pale unapohitaji: unaponunua.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Uwazi';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Tofauti na lebo za wamiliki, hesabu ya Alama ya Kijani ni **imefunguliwa kabisa** na inaweza **kuthibitishwa na mtu yeyote**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title =>
      'Usindikaji wa hali ya juu ni nini?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Vikundi vya NOVA vinakujulisha kuhusu kiwango cha usindikaji wa chakula.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Uainishaji wa NOVA unaruhusu kuainishwa kwa vyakula katika **makundi 4** kulingana na **shahada zao za usindikaji wa viwandani** (vyakula vilivyosindikwa au ambavyo havijachakatwa, viambato vya upishi, vyakula vilivyochakatwa, vyakula vilivyosindikwa zaidi).';

  @override
  String get guide_nova_logos_caption => 'Nembo za NOVA';

  @override
  String get guide_nova_groups_title => 'Vikundi 4 vya NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Kuna vikundi 4 vya NOVA, moja ya shida ikiwa ni Kundi la 4 - Vyakula vilivyosindikwa sana.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Vyakula vilivyosindikwa kidogo au visivyochakatwa';

  @override
  String get guide_nova_groups_arg1_text =>
      'Vyakula ambavyo havijachakatwa (au asili) ni **sehemu zinazoweza kuliwa za mimea** (mbegu, matunda, majani, shina, mizizi) **au wanyama** (misuli, nyasi, mayai, maziwa), pamoja na fangasi, mwani, na maji, baada ya kutenganishwa na maumbile.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods Or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to Group 1** foods. Processes include various Preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or Three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten On their own Or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. Ingredients in these formulations Usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also Contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, Such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Matatizo ya usindikaji wa hali ya juu';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Usindikaji mkubwa wa viungo vya chakula';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Nyingi **zinatokana na uchakataji zaidi wa viambajengo vya chakula**, kama vile mafuta ya hidrojeni au ya kuvutia, protini za hidrolisisi, kitenganishi cha protini ya soya, maltodextrin, geuza sukari, na sharubati ya mahindi yenye fructose nyingi.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Viungio vinavyoenda zaidi ya usalama wa chakula safi';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Viungio katika vyakula vilivyochakatwa zaidi ni pamoja na vingine ambavyo hutumika pia katika vyakula vilivyochakatwa, kama vile vihifadhi, viondoa sumu mwilini, na vidhibiti. Aina za viongezeo vinavyopatikana tu katika bidhaa zilizochakatwa zaidi ni pamoja na zile zinazotumiwa **kuiga au kuboresha sifa za hisia za vyakula au kuficha vipengele visivyopendeza vya bidhaa ya mwisho**. Viongezeo hivi ni pamoja na rangi na rangi nyingine, vidhibiti vya rangi; ladha, viboreshaji vya ladha, vitamu visivyo na sukari; na vifaa vya usindikaji kama vile kaboni, uimarishaji, bulking na mawakala wa kuzuia bulking, de-povu, anti-caking na ukaushaji mawakala, emulsifiers, sequestrants, na humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Usindikaji hauwezi kufanya nyumbani';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Msururu wa mfuatano wa michakato hutumika** kuchanganya viambato vingi vya kawaida na kuunda bidhaa ya mwisho (kwa hivyo \'kuchakatwa zaidi\'). Michakato hiyo ni pamoja na **isiyo na vilinganishi vya nyumbani** kadhaa, kama vile utiaji hidrojeni na uwekaji hidrolisisi, utoboaji na ukingo, na uchakataji wa awali kwa kukaangia.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Vipengele vya unyanyasaji na kifedha vya usindikaji wa hali ya juu';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Madhumuni ya jumla ya usindikaji wa hali ya juu ni kuunda bidhaa za chakula zenye chapa**, **rahisi** (inayodumu, tayari kutumika), **ya kuvutia** (inayopendeza sana) na **yenye faida kubwa** (viungo vya bei ya chini) vilivyoundwa kuondoa vikundi vingine vyote vya chakula. Bidhaa za chakula zilizochakatwa kwa kiwango cha juu huwekwa kwenye vifurushi vya kuvutia na kuuzwa kwa kasi.';

  @override
  String get guide_nova_explanations_arg5_title => 'Hatari kwa afya';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Tangu 2018, kupitia NutriNet-Santé, viungo vya kwanza kati ya **utumiaji wa vyakula vilivyochakatwa na kuongezeka kwa hatari za saratani, magonjwa ya moyo na mishipa na kisukari vimeangaziwa**. Leo, zaidi ya tafiti 90 ulimwenguni kote zinathibitisha matokeo haya.\nUhusiano thabiti zaidi unahusiana na **unene kupita kiasi, vifo vya moyo na mishipa, na dalili za mfadhaiko**. Kwa watoto, athari huzingatiwa hasa kwa uzito na usawa wa lipid.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Nchi zinapendekeza kuziwekea kikomo';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Baadhi ya nchi hutumia vikundi vya NOVA kwa miongozo au malengo yao ya lishe, kwa mfano:\n\n- **🇧🇷 Miongozo ya lishe ya Brazil** **inapendekeza kupunguza matumizi** ya chakula kilichochakatwa na kuepuka vyakula vilivyochakatwa zaidi.\n\n- **🇫🇷 Malengo ya sera ya lishe ya afya ya umma ya Ufaransa** 2018-2022 yanalenga **kupunguza ulaji wa vyakula vya kundi la 4 vilivyosindikwa zaidi kwa 20%**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Karibu kwenye Ukweli wa Chakula Huria!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Ukweli wa Chakula cha Open ni nini?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts ni **hifadhi data shirikishi**, **bila malipo**, na **wazi** ya bidhaa za chakula kutoka duniani kote.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Tunaamini kwamba kila mtu anapaswa kupata taarifa kuhusu kile anachokula. Kwa kukusanya data kuhusu viambato, vizio, ukweli wa lishe, na zaidi, **tunawawezesha watumiaji kufanya maamuzi sahihi** na kuendeleza sekta ya chakula **kuelekea uwazi zaidi**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Vipengele vya Ukweli wa Chakula cha Open';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Pata arifa za viungo vyako visivyotakikana';

  @override
  String get guide_open_food_facts_tips_title =>
      'Vidokezo vya kupiga picha nzuri';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Usifanye';

  @override
  String get guide_open_food_facts_tips_arg1_text1 => 'Epuka vivuli na glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Hakuna maandishi yenye ukungu au yaliyo nje ya umakini.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Usipunguze sehemu za maandishi.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Epuka mandharinyuma yenye shughuli nyingi.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Fanya';

  @override
  String get guide_open_food_facts_tips_arg2_text1 => 'Tumia vizuri, hata taa.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Hakikisha maandishi ni makali na yanasomeka.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Rekodi orodha nzima ya viungo.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Weka bidhaa kwenye uso wa gorofa.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Tusaidie kujenga \"Wikipedia ya Chakula\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Alama juu ya ubora wa lishe';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Alama ya kuepuka vyakula vilivyosindikwa zaidi';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Alama kwa sayari';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-sw.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Karibu kwa Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Ukweli wa Open Pet Food ni nini?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Fungua Ukweli wa Chakula cha Kipenzi huongeza dhamira yetu kwa marafiki wetu wenye manyoya! Ni **database ya bidhaa za vyakula vipenzi vya paka, mbwa na wenza wengine**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Tunakusanya maelezo kuhusu **viungo**, **uchambuzi wa lishe**, na miongozo ya ulishaji ili kuwasaidia wamiliki wa wanyama vipenzi kuchagua chakula bora kwa mahitaji ya wanyama wao.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Vipengele vya Ukweli wa Chakula cha Wanyama wa Kipenzi';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Pata arifa za viungo vyako visivyotakikana';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Je, mnyama wako ana mzio wa viungo vyovyote? Unaweza kuweka orodha ya viungo vya vipodozi ili kuepuka, moja kwa moja kwenye programu!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Vidokezo vya kupiga picha nzuri';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Usifanye';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Epuka vivuli na glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Hakuna maandishi yenye ukungu au yaliyo nje ya umakini.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Usipunguze sehemu za maandishi.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Epuka mandharinyuma yenye shughuli nyingi.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Fanya';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Tumia vizuri, hata taa.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Hakikisha maandishi ni makali na yanasomeka.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Rekodi orodha nzima ya viungo.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Weka bidhaa kwenye uso wa gorofa.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Ujumbe juu ya kufunga bao';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Kutengeneza mfumo wa alama kwa chakula cha wanyama kipenzi **sio kipaumbele kwa sasa**. Mbinu hiyo itakuwa ngumu, kwani mahitaji ya lishe hutofautiana sana kulingana na spishi, umri, na hali ya afya. Bado hatujapata timu yoyote ya kisayansi inayojitegemea, inayoweza kutengeneza alama kama hiyo.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-sw.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Karibu kwenye Fungua Ukweli wa Urembo!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Ukweli wa Uzuri wa Open ni nini?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Fungua Ukweli wa Urembo ni hifadhidata shirikishi ya **bidhaa za vipodozi**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Lengo letu ni kubainisha orodha za viambato ili kukusaidia **kuelewa ni nini kilicho katika vitu vyako vya utunzaji wa kibinafsi**. Kuanzia vilainishi hadi vipodozi, tunakusanya data kuhusu viambato, vizio, na vifungashio ili kukuza uwazi katika tasnia ya vipodozi.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Vipengele vya Ukweli wa Urembo wazi';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Pata arifa za viungo vyako visivyotakikana';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Je, una mzio wa viungo vyovyote? Unataka kuepuka dutu za comedogen? Je, ungependa kujiepusha na vipengele vyenye utata? Unaweza kuweka orodha ya viungo vya vipodozi ili kuepuka, moja kwa moja kwenye programu!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Vidokezo vya kupiga picha nzuri';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Usifanye';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Epuka vivuli na glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Hakuna maandishi yenye ukungu au yaliyo nje ya umakini.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Usipunguze sehemu za maandishi.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Epuka mandharinyuma yenye shughuli nyingi.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Fanya';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Tumia vizuri, hata taa.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Hakikisha maandishi ni makali na yanasomeka.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Rekodi orodha nzima ya viungo.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Piga picha nyingi kadri inavyohitajika ikiwa chupa imejipinda.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Huenda ukahitaji kumenya lebo ili kuona orodha ya viungo.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Weka bidhaa kwenye uso wa gorofa.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Ujumbe juu ya kufunga bao';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Tofauti na bidhaa za vyakula, ulimwengu wa vipodozi **hauna mfumo wa alama unaotambulika ulimwenguni kote, unaoungwa mkono na serikali kama Nutri-Alama**. Madhara ya viungo yanaweza kuwa ya kibinafsi sana na yanategemea aina ya ngozi, mizio, na wasiwasi wa mtu binafsi.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-sw.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Tunatafuta mkusanyiko wa data wa chanzo huria wa bei**. Bei zinaweza kuongezwa na watumiaji kupitia programu hii ya wavuti, au kupitia programu rasmi ya Open Food Facts ya simu ya mkononi. Wauzaji wa reja reja au programu za wahusika wengine wanaweza kuchangia pia kwa kutumia API yetu.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Kusanya picha za lebo za bei kwenye njia';

  @override
  String get guide_open_prices_how_arg2_title => 'Kusanya picha za risiti';

  @override
  String get guide_open_prices_why_title =>
      'Kwa nini Open Food Facts inafanya hivi?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Taarifa za bei ni muhimu sana kuelewa mifumo ya chakula. Ni jambo muhimu katika kuelewa gharama ya chakula na kukuza lishe bora. Kufungua data ya bei ni njia ya kurahisisha watafiti, wanahabari, na wananchi **kuwa na ufahamu bora wa jinsi bei za vyakula zinavyotofautiana kijiografia na kwa wakati**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Fuatilia mabadiliko ya bei kwa wakati';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Angalia **mabadiliko ya bei**: kushuka kwa bei, bei nafuu, tunaweza kuzifuatilia pamoja!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Linganisha bei zilizo karibu nawe';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Tunapopata bei zaidi, unaweza kuona **maduka nafuu yaliyo karibu nawe**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Je, ulizingatia kuondoa bei kutoka kwa tovuti za wauzaji reja reja?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Unaweza kuchangia bei kwa kutumia API yetu.\nIwapo ungependa kuchangia bei kwa kiwango kikubwa, tafadhali wasiliana nasi kwa prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Karibu kwenye Fungua Ukweli wa Bidhaa!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Ukweli wa Bidhaa Huria ni nini?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Fungua Ukweli wa Bidhaa ni hifadhidata kubwa, iliyo wazi ya **bidhaa yoyote iliyo na msimbopau, ambayo si chakula, vipodozi au chakula cha kipenzi**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Kutoka **elektroniki** hadi **vichezeo**, na **nguo** hadi **vifaa vya kusafisha**, ikiwa ina msimbopau, inaweza kuongezwa. Mradi huu unalenga kuunda \"Mtandao wa Vitu\" kwa vitu vya kila siku, na kufanya habari kuzihusu zipatikane kwa wote.';

  @override
  String get guide_open_products_facts_features_title =>
      'Vipengele vya Ukweli wa Bidhaa Huria';

  @override
  String get guide_open_products_facts_features_text =>
      'Ukweli wa Bidhaa za Open unalenga kuwapa wateja **kurefusha maisha ya vitu** kwa kutoa masuluhisho ya mviringo ili kudumisha, **kurekebisha**, **kusaga** vitu vyao au kumpa mmiliki mpya.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Nyayo za kaboni kwa baadhi ya bidhaa';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Athari CO2** na Mamlaka ya Mazingira ya Ufaransa ADEME hutoa **athari ya kaboni** ya aina nyingi, hakikisha kuwa umeweka bidhaa katika aina kwa njia ipasavyo.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Fahirisi ya urekebishaji kwa bidhaa nyingi';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Wakati wowote faharasa ya urekebishaji ya Kifaransa inapatikana, tutaionyesha. Zaidi ya hayo, **unaweza kuanza kukusanya viambajengo kwa kutumia Injini ya Folksonomy**; ili tuweze kuihesabu wenyewe katika siku zijazo, hata katika nchi ambazo haipatikani.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Tafuta njia za kuchangia/kuuza tena bidhaa yako';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Tunatoa viungo vya **huduma za mduara za wahusika wengine** ambazo hukusaidia kupata aina ya bidhaa unayotafuta, kama bidhaa ya mitumba, ili kuwa mpole zaidi kwenye rasilimali za sayari.\nKumbuka kuwa hatulipwi kufanya hivyo, na kwamba mfumo hufanya kazi kama mfano kwa tovuti mbili nchini Ufaransa pekee. Unaweza kusaidia kupanua mfumo huu kwa kuweka kumbukumbu za tovuti zaidi kwenye wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Ni habari gani muhimu?';

  @override
  String get guide_open_products_facts_information_text =>
      'Kwa anuwai kama hiyo ya bidhaa, **data tunayokusanya inaweza kunyumbulika**. Ili kufanya hivyo, **tuliunda Injini ya Folksonomy**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Injini ya Folksonomy';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Injini ya Folksonomy ni zana ya kukusaidia kukamilisha bidhaa zenye sifa zinazofaa. Hii husaidia kuboresha utafutaji na ugunduzi, lakini pia kukokotoa na kuonyesha mambo ya kuvutia katika siku zijazo.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Unaweza kuongeza funguo na thamani zozote kama vile: **compatibility_with_5G_mobile_network: ndiyo**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Utapata mapendekezo ya kiotomatiki ya sifa zinazowezekana, na unakaribishwa sana kuongeza na kuweka kumbukumbu mpya kwenye aina unazopenda za bidhaa.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-sw.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Fungua upendeleo wa chakula';

  @override
  String get guide_coming_soon_button_title => 'Inakuja hivi karibuni';

  @override
  String get guide_learn_more_subtitle => 'Gusa ili upate maelezo zaidi';

  @override
  String get preview_badge => 'Hakiki';

  @override
  String get prices_feedback_form =>
      'Bofya hapa ili kututumia maoni yako kuhusu kipengele hiki kipya!';

  @override
  String get menu_button_list_actions => 'Chagua kitendo';

  @override
  String get error_loading_photo => 'Hitilafu katika kupakia picha';

  @override
  String get photo_viewer_action_use_picture_as => 'Tumia kama…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Tumia picha hii kama…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Tumia picha hii kama… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Maelezo';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Maelezo ya picha hii';

  @override
  String get photo_viewer_details_title => 'Maelezo ya picha';

  @override
  String get photo_viewer_details_contributor_title => 'Contributor';

  @override
  String get photo_viewer_details_size_title => 'Ukubwa';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pikseli';
  }

  @override
  String get photo_viewer_details_date_title => 'Tarehe';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Sambamba';

  @override
  String get user_lists_action_multi_select => 'Chagua nyingi';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Alama yako ya uoanifu: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Front picture';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Ingredients picture';

  @override
  String get product_image_nutrition_accessibility_label => 'Picha ya lishe';

  @override
  String get product_image_packaging_accessibility_label => 'Picha ya ufungaji';

  @override
  String get product_image_other_accessibility_label => 'Picha nyingine';

  @override
  String get product_image_outdated_message =>
      'Picha hii inaweza kuwa ya zamani';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (picha hii inaweza kuwa imepitwa na wakati)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (picha hii inaweza kufungwa na mtayarishaji)';
  }

  @override
  String get product_image_error => 'Imeshindwa kupakia picha!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Imeshindwa kupakia $type (hitilafu ya mtandao?)';
  }

  @override
  String get product_page_image_no_image_available => 'Hakuna picha\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Hakuna picha inayopatikana kwa bidhaa hii';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Panga upya au ufiche vitendo';

  @override
  String get product_page_action_bar_setting_modal_title => 'Badilisha vitendo';

  @override
  String get product_page_action_bar_item_move_up => 'Sogeza juu';

  @override
  String get product_page_action_bar_item_move_down => 'Sogeza chini';

  @override
  String get product_page_action_bar_item_enable => 'Washa kitendo';

  @override
  String get product_page_action_bar_item_disable => 'Zima kitendo';

  @override
  String get product_page_pending_operations_banner_title =>
      'Inapakia masahihisho yako…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Data iliyoonyeshwa kwenye ukurasa huu **bado haionyeshi marekebisho yako**.\nTafadhali subiri sekunde chache…';

  @override
  String get product_add_a_language => 'Ongeza lugha';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Msimbo pau $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Ondoa bidhaa hii kutoka kwa jukwa';

  @override
  String get carousel_unsupported_header => 'Msimbopau hautumiki!';

  @override
  String get carousel_unsupported_title => 'Lo!';

  @override
  String get carousel_unsupported_text =>
      'Msimbopau uliochanganuliwa hautumiki kwa Open Food Facts!';

  @override
  String get carousel_error_header => 'Hitilafu!';

  @override
  String get carousel_error_title => 'Ni bummer!';

  @override
  String get carousel_error_text_1 =>
      'Hatukuweza kupakua maelezo kwenye msimbopau huu:';

  @override
  String get carousel_error_text_2 =>
      'Tafadhali angalia muunganisho wako wa Mtandao au ubofye kitufe hiki:';

  @override
  String get carousel_error_button => 'Jaribu tena';

  @override
  String get carousel_unknown_product_header => 'Bidhaa isiyojulikana';

  @override
  String get carousel_unknown_product_title =>
      'Hongera!\nUmepata __vito adimu!__';

  @override
  String get carousel_unknown_product_text =>
      'Hifadhidata yetu shirikishi ina zaidi ya **bidhaa milioni 3**, lakini msimbopau huu haupo: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'Inapakia maelezo...';

  @override
  String get carousel_loading_title =>
      'Umechanganua bidhaa kwa kutumia msimbopau ufuatao:';

  @override
  String get carousel_loading_text =>
      'Tunaitafuta katika hifadhidata yetu ya zaidi ya bidhaa **milioni 3!**';

  @override
  String get product_type_subtitle_food =>
      'Mboga, matunda, vyakula vilivyogandishwa…';

  @override
  String get product_type_subtitle_beauty => 'Vipodozi, sabuni, dawa za meno…';

  @override
  String get product_type_subtitle_pet_food => 'Chakula cha mbwa, paka…';

  @override
  String get product_type_subtitle_product => 'Simu mahiri, samani…';

  @override
  String get photo_field_front => 'Picha ya bidhaa';

  @override
  String get photo_field_ingredients => 'Picha ya viungo';

  @override
  String get photo_field_nutrition => 'Picha ya lishe';

  @override
  String get photo_field_packaging => 'Maagizo ya kuchakata picha';

  @override
  String get photo_already_exists => 'Picha hii tayari ipo';

  @override
  String get photo_missing => 'Picha hii haipo';

  @override
  String get date => 'Tarehe';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'Tendua kitendo kilichotangulia';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Ramani ya dunia ya $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Wachangiaji wa OpenStreetMap';

  @override
  String get not_applicable_short => 'N/A';

  @override
  String get knowledge_panel_warning_text => 'Warning';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Kwa nini Nutri-Alama hii ni tofauti na ile iliyo kwenye kifurushi?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Kuna maelezo mawili yanayowezekana:\nOrodha ya viungo na/au ukweli wa lishe si ya kisasa.\n\nTunatoa \"Hesabu Mpya\" ya Nutri-Score (au V2). Tafadhali hakikisha kuwa una bango \"Hesabu Mpya\" kwenye kifurushi.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Angalia viungo';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Angalia ukweli wa lishe';

  @override
  String url_not_supported(String url) {
    return 'Kwa bahati mbaya, hatuwezi kufungua URL:\n$url';
  }

  @override
  String get product_list_export => 'Hamisha';

  @override
  String get product_list_import => 'Ingiza';

  @override
  String get product_footer_action_barcode => 'Tazama msimbopau';

  @override
  String get product_footer_action_barcode_short => 'Barcode';

  @override
  String get product_footer_action_open_website => 'Fungua tovuti';

  @override
  String get product_footer_action_report => 'Ripoti';

  @override
  String get product_footer_action_contributor_guide => 'Msaada';

  @override
  String get product_footer_action_data_quality_tags => 'Ubora wa data';

  @override
  String get product_page_tab_for_me => 'Kwa ajili yangu';

  @override
  String get product_page_tab_website => 'Tovuti';

  @override
  String get product_page_tab_prices => 'Bei';

  @override
  String get prices_explanation_card_title => 'Kwa nini bei?';

  @override
  String get prices_explanation_card_line1 =>
      '**Bei Huria** ni mradi wa kukusanya na kushiriki bei za bidhaa kote ulimwenguni 🌍. Bei Huzi hutengenezwa na kudumishwa na Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Jifunze zaidi';

  @override
  String get product_page_tab_folksonomy => 'Folksonomia';

  @override
  String get folksonomy_explanation_card_title => 'Sifa za Folksonomy ni zipi?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Sifa zinatokana na **thamani-msingi**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Sifa hizi huundwa na kuwasilishwa na wachangiaji kwa matumizi ya aina yoyote.';

  @override
  String get folksonomy_action_external_link_title => 'Fungua kiungo cha nje';

  @override
  String get folksonomy_action_external_link_warning =>
      'Viungo vya nje vinaweza kuwa si salama. Je, kweli ungependa kuitembelea?';

  @override
  String get prices_products_empty_title => 'Hakuna bei inayopatikana';

  @override
  String get prices_products_empty_explanation => 'Kuwa wa kwanza kuchangia!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Bidhaa maarufu $pageSize (jumla: $total)';
  }

  @override
  String get app_review_title => 'Je, unafurahia programu hii?';

  @override
  String get app_review_low => 'Inaweza kufanya vizuri zaidi';

  @override
  String get app_review_medium => 'Sio mbaya';

  @override
  String get app_review_high => 'Naipenda!';

  @override
  String get app_review_feedback_modal_title =>
      'Tusaidie kuboresha programu yetu';

  @override
  String get app_review_feedback_modal_content =>
      'Ikiwa una dakika chache, unaweza kujibu fomu hii ili **tuweze kuboresha katika masasisho yajayo**:';

  @override
  String get app_review_feedback_modal_open_form => 'Jibu fomu';

  @override
  String get app_review_feedback_modal_later => 'Niulize baadaye';

  @override
  String get nutrition_facts_extract_new =>
      'MPYA: Unaweza kutoa virutubisho kiotomatiki kutoka kwenye picha!';

  @override
  String get nutrition_facts_extract_button_text => 'Dondoo sasa';

  @override
  String get nutrition_facts_extract_in_progress => 'Uchimbaji unaendelea…';

  @override
  String get nutrition_facts_extract_successful => 'Uchimbaji umefaulu';

  @override
  String get nutrition_facts_extract_failed =>
      'Imeshindwa kutoa virutubisho kutoka kwa picha';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Takwimu';

  @override
  String get prices_stats_title => 'Takwimu za Bei';

  @override
  String get prices_stats_prices_section => 'Bei';

  @override
  String get prices_stats_products_section => 'Bidhaa';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Mbalimbali';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Chakula';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Bidhaa';

  @override
  String get prices_stats_pet_food => 'Chakula cha kipenzi';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Countries';

  @override
  String get prices_stats_price_tag => 'Lebo ya bei';

  @override
  String get prices_stats_receipt => 'Risiti';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Tovuti';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'Ilisasishwa mwisho';

  @override
  String get prices_stats_error =>
      'Hitilafu ilitokea wakati wa kupakia takwimu.';

  @override
  String get product_edit_robotoff_question_answered => 'Swali limejibiwa!';

  @override
  String get product_edit_robotoff_proof => 'Ushahidi';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'Bei';

  @override
  String get preferences_prices_subtitle => 'Dhibiti mapendeleo yako ya bei';

  @override
  String get preferences_card_project => 'Mradi wa Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribute';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'Takwimu zangu';

  @override
  String get preferences_contribute_subtitle => 'Tafsiri, boresha zana zetu…';

  @override
  String get preferences_connect_title => 'Unganisha';

  @override
  String get preferences_connect_subtitle =>
      'Wasiliana nasi, au Tufuate kwenye mitandao ya kijamii';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Tusaidie kuwafahamisha mamilioni ya watumiaji duniani kote';

  @override
  String get preferences_card_help => 'Usaidizi na Usaidizi';

  @override
  String get preferences_faq_title => 'Maswali Yanayoulizwa Mara kwa Mara';

  @override
  String get preferences_faq_subtitle => 'Pata majibu ya maswali yako';

  @override
  String get logged_out => 'Umetoka nje';

  @override
  String get preferences_app_bar_message =>
      'Asante kwa kuwa mmoja wa wanachama wetu!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Tazama takwimu zote';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Tafuta $provider kwa \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Tafuta mpangilio (km Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji => 'Ufikivu: Onyesha emoji';

  @override
  String get preferences_accessibility_remove_colors => 'Ufikiaji: Ondoa rangi';

  @override
  String get preferences_app_settings_products => 'Bidhaa';

  @override
  String get preferences_card_about => 'Kuhusu';

  @override
  String get preferences_legal_information_title => 'Taarifa za kisheria';

  @override
  String get preferences_legal_information_subtitle =>
      'Masharti ya matumizi, sera ya faragha na zaidi';

  @override
  String get preferences_terms_of_use => 'Masharti ya matumizi';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Fungua Ukweli wa Chakula ni hifadhidata ya bidhaa za chakula **iliyoundwa na kila mtu, kwa kila mtu**.\nUnaweza kuitumia kufanya chaguo bora zaidi za chakula, na kwa vile ni **data wazi**, mtu yeyote anaweza **kuitumia tena kwa madhumuni yoyote**.';

  @override
  String get preferences_privacy_policy => 'Sera ya faragha';

  @override
  String get preferences_licenses => 'Leseni';

  @override
  String get preferences_about_app_title => 'Kuhusu programu';

  @override
  String get preferences_about_app_subtitle =>
      'Maelezo ya kiufundi, maelezo ya msanidi programu, na zaidi';

  @override
  String get preferences_card_information => 'Information';

  @override
  String get preferences_version_number_title => 'Nambari ya toleo';

  @override
  String get preferences_scanner_title => 'Kichanganuzi';

  @override
  String get preferences_app_store => 'Duka la programu';

  @override
  String get preferences_app_system_settings => 'Mipangilio ya mfumo';

  @override
  String get preferences_source_code => 'Fikia msimbo wa chanzo';

  @override
  String get preferences_source_code_subtitle =>
      'Na anza kuleta athari kwa mamilioni';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Bidhaa Zote';

  @override
  String get preferences_tips => 'Vidokezo';

  @override
  String get tips_discover_nutriscore => 'Gundua Nutri-Alama mpya';

  @override
  String get preferences_on_off_website_subtitle =>
      'Kwenye tovuti ya Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Dhibiti akaunti yangu';

  @override
  String get preferences_manage_account_tooltip => 'Dhibiti akaunti yako';

  @override
  String get preferences_change_password_title => 'Badilisha nenosiri langu';

  @override
  String get preferences_danger_zone => 'Eneo la hatari';

  @override
  String get preferences_account_deletion_subtitle =>
      'Michango yako yote itapotea';

  @override
  String get preferences_contributions_title => 'Contributions';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Mipangilio ya programu';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Njia ya majaribio sana ya kuchanganua bidhaa nje ya mtandao';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Onyesha upya bidhaa zote kutoka kwa seva';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Tafadhali epuka kufanya hivyo isipokuwa lazima kabisa';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Hali ya onyesho';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Ongeza kadi kwenye kichanganuzi';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Huongeza sampuli za bidhaa 3 kwenye kichanganuzi';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'mwenyeji wa Folksonomy';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Mpangishi: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Majaribio ya ufikivu';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Uteuzi wa bidhaa nyingi kwa bei';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Vidirisha vya muhtasari vilivyoagizwa na mtumiaji';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Ufikiaji wa muda wa utafutaji wa eneo';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Ulinganisho wa kando kwa bidhaa 2 au 3';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Uingizaji wa orodha ya bidhaa';

  @override
  String get preferences_faq_scores_methodologies_title => 'Alama na mbinu';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Gundua jinsi Nutri-Score inavyokokotwa';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Gundua mabadiliko kuu ya mbinu';

  @override
  String get preferences_faq_discover_project_title => 'Discover the project';

  @override
  String get preferences_faq_discover_off_title =>
      'Gundua Ukweli wa Chakula cha Wazi';

  @override
  String get preferences_faq_discover_obf_title =>
      'Gundua Ukweli Wazi wa Urembo';

  @override
  String get preferences_faq_discover_opff_title =>
      'Gundua Ukweli Wazi wa Chakula Kipenzi';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Gundua Ukweli wa Bidhaa Huria';

  @override
  String get preferences_faq_faq_title =>
      'Maswali Yanayoulizwa Mara Kwa Mara - Maswali Yanayoulizwa Mara Kwa Mara';

  @override
  String get preferences_faq_off_ngo_title => 'NGO ya Open Food Facts';

  @override
  String get preferences_about_information_title => 'Information';

  @override
  String get preferences_connect_community_updates_title =>
      'Pata masasisho ya jumuiya';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Endelea kupata habari kuhusu programu na habari za jumuiya';

  @override
  String get preferences_connect_community_calendar_title =>
      'Jiandikishe kwa kalenda yetu ya jamii';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Jihusishe kwa kuhudhuria mojawapo ya matukio yetu ya mtandaoni';

  @override
  String get preferences_connect_blog_title => 'Blogu ya Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Pata habari za hivi punde, kadri zinavyotokea';

  @override
  String get preferences_connect_community_help_title =>
      'Pata usaidizi kutoka kwa jamii';

  @override
  String get preferences_connect_improve_app_title =>
      'Tusaidie kuboresha programu';

  @override
  String get preferences_connect_debug_info_title =>
      'Tutumie maelezo ya utatuzi';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Tutumie barua pepe yenye maelezo ya kina ya utatuzi';

  @override
  String get preferences_connect_feedback_title =>
      'Tutumie maoni kuhusu programu';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Saidia kuunda mustakabali wa programu';

  @override
  String get preferences_connect_survey_title => 'Chukua uchunguzi wa programu';

  @override
  String get preferences_connect_survey_subtitle =>
      'Tusaidie kuelewa tunachopaswa kujenga baadaye';

  @override
  String get preferences_connect_professionals_title => 'Wataalamu';

  @override
  String get preferences_connect_pro_subtitle =>
      'Bila malipo kabisa, huhakikisha data sahihi kwa programu 500 na mamilioni ya watumiaji. Huduma ya kibinafsi, inayooana na PIM au lahajedwali zako (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle => 'Wasiliana ili kuanza';

  @override
  String get preferences_connect_press_title => 'Press';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Pata nyenzo zote unazohitaji kwa ripoti yako';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Wasiliana na waandishi wa habari kwa maswali au utufahamishe kuhusu ripoti yako';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Kuwa mfanyakazi wa kujitolea anayefanya kazi';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Maendeleo, Mawasiliano, Usanifu… aina yoyote ya kujitolea au utaalam inakaribishwa!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Gundua baadhi ya njia nyingi unazoweza kuchangia';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Maendeleo ya programu ya rununu';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Jifunze jinsi ya kuchangia katika ukuzaji wa programu';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Miundo isiyo thabiti ya kila siku, vipengele vipya kabisa';

  @override
  String get preferences_contribute_local_community_title =>
      'Kuza jumuiya yako ya ndani';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Usaidizi wa programu, yaliyomo, tafsiri za uchanganuzi wa viambato';

  @override
  String get preferences_contribute_share_subtitle =>
      'Tumekuandalia kiolezo kidogo kukusaidia :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Hatua rahisi za kukuza uwazi wa chakula katika nchi yako';

  @override
  String get preferences_contribute_data_quality_title => 'Ubora wa data';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Jiunge na timu ya ubora wa data';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Jiunge na juhudi zetu ili kuhakikisha hifadhidata ni kamili na sahihi';

  @override
  String get preferences_contributions_products_added_title =>
      'Bidhaa zilizoongezwa';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Bidhaa mpya nilizoongeza kwenye Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Bidhaa ninazohitaji kukamilisha';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Bidhaa zote ambazo hazijakamilika';

  @override
  String get preferences_my_contributions_prices_title => 'Bei';

  @override
  String get preferences_my_contributions_my_prices_title => 'Bei zangu';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Bei zangu, uthibitisho wangu…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Bidhaa unazoweza kusaidia kukamilisha';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Saidia kukokotoa Nutri-Score & Green-Score katika nchi yako';

  @override
  String get preferences_prices_user_prices_subtitle => 'Bei nilizochangia';

  @override
  String get preferences_prices_proofs_subtitle => 'Lebo za bei na risiti';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Piga picha za stakabadhi zako na uchanganue misimbopau inayohusishwa';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Piga picha za bei dukani';

  @override
  String get preferences_prices_newest_title => 'Bei mpya zaidi';

  @override
  String get preferences_prices_newest_subtitle =>
      'Latest prices added by the Open Prices community';

  @override
  String get preferences_prices_top_contributors_title =>
      'Wachangiaji walio na bei nyingi zaidi';

  @override
  String get preferences_prices_metrics_title => 'Fungua vipimo vya Bei';

  @override
  String get preferences_prices_metrics_subtitle => 'Fuata maendeleo ya mradi';

  @override
  String get preferences_prices_ways_contribute_title => 'Njia za kuchangia';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Thibitisha bei zilizoongezwa na wewe mwenyewe au wengine, kwa usaidizi wa AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Ongeza kwa haraka risiti nyingi au picha za rafu kutoka kwa orodha ya kamera yako';

  @override
  String get preferences_prices_challenges_title => 'Changamoto za kila mwezi';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Shiriki katika mapambano ya mada ya kila mwezi ili kukusanya bei';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Rejesha data yako ya uaminifu';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Jifunze jinsi ya kuomba data yako';

  @override
  String get preferences_page_customize_app_title => 'Geuza kukufaa programu';

  @override
  String get preferences_page_contribute_project_title =>
      'Changia kwenye mradi';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Simple ways to help Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Mbinu za alama, usaidizi, na zaidi kuhusu mradi';

  @override
  String get product_edit_robotoff_positive_button => 'Kubali pendekezo';

  @override
  String get product_edit_robotoff_negative_button => 'Kataa pendekezo';

  @override
  String get product_edit_robotoff_show_proof => 'Onyesha uthibitisho';

  @override
  String get product_edit_robotoff_expand_proof => 'Panua uthibitisho';

  @override
  String get product_page_tab_raw_data => 'Data ghafi';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Ukurasa $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Ukurasa $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count ya $total vitu';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count ya $total vitu';
  }

  @override
  String item_count(int count) {
    return '$count vitu';
  }

  @override
  String item_count_string(String count) {
    return '$count vitu';
  }

  @override
  String get prices_no_result => 'Hakuna takwimu za bei zilizopatikana.';

  @override
  String get prices_error_loading_more_items =>
      'Hitilafu katika kupakia vipengee zaidi';

  @override
  String get prices_proof_error =>
      'Uthibitishaji umeshindwa, haikuweza kuleta uthibitisho';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count ya $total vithibitisho';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count ya $total wachangiaji';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count ya $total maeneo';
  }

  @override
  String prices_locations_count(int count) {
    return '$count maeneo';
  }

  @override
  String get restart_to_apply_message =>
      'Tafadhali anzisha upya programu ili kutekeleza mabadiliko.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Kiolesura cha mchoro';

  @override
  String get preferences_app_settings_media_title => 'Vyombo vya habari';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Fungua Maabara ya Ukweli wa Chakula';

  @override
  String get preferences_root_account_title => 'Akaunti';

  @override
  String get preferences_contribute_translate_header =>
      'Leta Ukweli wa Chakula Huria kwa lugha yako';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Jiandikishe katika toleo la alpha la programu';

  @override
  String get preferences_dev_mode_section_data => 'Data ya Michango na Bidhaa';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Usionyeshe Folksonomy';

  @override
  String get preferences_account_title => 'Akaunti';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Imeongezwa kwenye $created';
  }

  @override
  String get location_map_details_title => 'Maelezo ya eneo';

  @override
  String get location_map_details_name => 'Jina';

  @override
  String get location_map_details_street => 'Mtaa';

  @override
  String get location_map_details_city => 'Jiji';

  @override
  String get location_map_details_postcode => 'Msimbo wa posta';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Kuratibu';

  @override
  String get location_map_details_osm_id => 'Kitambulisho cha OSM';
}
