// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Swedish (`sv`).
class AppLocalizationsSv extends AppLocalizations {
  AppLocalizationsSv([String locale = 'sv']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Ja';

  @override
  String get add => 'Lägg till';

  @override
  String get account_delete_message =>
      'Är du säker på att du vill radera ditt konto?\nOm det finns en specifik anledning, vänligen dela nedan';

  @override
  String get reason => 'Anledning';

  @override
  String get okay => 'Okej';

  @override
  String get validate => 'Validera';

  @override
  String get create => 'Skapa';

  @override
  String get applyButtonText => 'Verkställ';

  @override
  String get next_label => 'Nästa';

  @override
  String get continue_label => 'Fortsätt';

  @override
  String get exit_label => 'Avsluta';

  @override
  String get previous_label => 'Föregående';

  @override
  String get go_back_to_top => 'Gå tillbaka till toppen';

  @override
  String get save => 'Spara';

  @override
  String get save_confirmation => 'Är du säker på att du vill spara?';

  @override
  String get skip => 'Hoppa over';

  @override
  String get cancel => 'Annulera';

  @override
  String get ignore => 'Ignorera';

  @override
  String get close => 'Stäng';

  @override
  String get no => 'Nej';

  @override
  String get stop => 'Stopp';

  @override
  String get finish => 'Slutför';

  @override
  String get calculate => 'Beräkna';

  @override
  String get reset_food_prefs => 'Återställ matpreferenser';

  @override
  String get error => 'Någonting gick fel';

  @override
  String get error_occurred => 'Ett fel uppstod';

  @override
  String get featureInProgress =>
      'Vi arbetar fortfarande med den här funktionen, håll ögonen öppna';

  @override
  String get label_web => 'Visa på webben';

  @override
  String get learnMore => 'Läs mer';

  @override
  String get unknown => 'Okänd';

  @override
  String get match_very_good => 'Mycket god matchning';

  @override
  String get match_good => 'God matchning';

  @override
  String get match_poor => 'Dålig matchning';

  @override
  String get match_may_not => 'Kanske inte matchar';

  @override
  String get match_does_not => 'Matchar inte';

  @override
  String get match_unknown => 'Okänd matchning';

  @override
  String get match_short_very_good => 'Mycket god matchning';

  @override
  String get match_short_good => 'God matchning';

  @override
  String get match_short_poor => 'Dålig matchning';

  @override
  String get match_short_may_not => 'Kanske inte matchar';

  @override
  String get match_short_does_not => 'Matchar inte';

  @override
  String get match_short_unknown => 'Okänd matchning';

  @override
  String get licenses => 'Licenser';

  @override
  String get looking_for => 'Letar efter';

  @override
  String get welcomeToOpenFoodFacts => 'Välkommen till Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts är en global ideell verksamhet som drivs av lokala intressegrupper.';

  @override
  String get productDataUtility =>
      'Se de matdata som är relevanta för dina önskemål.';

  @override
  String get healthCardUtility => 'Välj mat som är bra för dig.';

  @override
  String get ecoCardUtility => 'Välj mat som är bra för planeten.';

  @override
  String get server_error_open_new_issue =>
      'Inget serversvar! Du kan rapportera ett problem med följande länk.';

  @override
  String get sign_in_text =>
      'Logga in på ditt Open Food Fact-konto för att spara dina bidrag';

  @override
  String get incorrect_credentials => 'Felaktigt användarnamn eller lösenord.';

  @override
  String get password_lost_incorrect_credentials =>
      'Denna e-postadress eller användarnamn finns inte. Vänligen kontrollera dina uppgifter.';

  @override
  String get password_lost_server_unavailable =>
      'Vi upplever för närvarande nedgångar på våra servrar och vi ber om ursäkt för det. Försök igen senare.';

  @override
  String get login => 'Användarnamn';

  @override
  String get login_result_type_server_unreachable => 'Nätverket kan inte nås';

  @override
  String get login_result_type_server_issue =>
      'Problem på servern. Försök senare.';

  @override
  String get login_page_username_or_email =>
      'Vänligen ange användarnamn eller e-post';

  @override
  String get login_page_password_error_empty => 'Vänligen ange ett lösenord';

  @override
  String get create_account => 'Skapa konto';

  @override
  String get sign_in => 'Logga in';

  @override
  String get sign_in_mandatory => 'För den funktionen behöver du logga in.';

  @override
  String get help_improve_country =>
      'Hjälp till att förbättra Open Food Facts i ditt land';

  @override
  String get sign_out => 'Logga ut';

  @override
  String get sign_out_confirmation => 'Är du säker på att du vill logga ut?';

  @override
  String get password => 'Lösenord';

  @override
  String get forgot_password => 'Glömt lösenord';

  @override
  String get forgot_password_question => 'Glömt lösenordet?';

  @override
  String get view_profile => 'Visa profil';

  @override
  String get reset_password => 'Återställ lösenord';

  @override
  String get reset_password_explanation_text =>
      'Om du har glömt lösenordet, skriv in ditt användarnamn eller e-postadress för att få instruktioner om lösenordsåterställning. Kom också ihåg att kontrollera skräppostmappen.';

  @override
  String get username_or_email => 'Användarnamn eller e-postadress';

  @override
  String get reset_password_done =>
      'Ett e-postmeddelande med en länk för att återställa ditt lösenord har skickats till e-postadressen som är kopplad till ditt konto. Kontrollera även din skräppost';

  @override
  String get send_reset_password_mail => 'Ändra lösenord';

  @override
  String get enter_some_text => 'Skriv in lite text';

  @override
  String get sign_up_page_title => 'Registrera dig';

  @override
  String get sign_up_page_action_button => 'Registrera dig';

  @override
  String get sign_up_page_action_doing_it => 'Registrerar…';

  @override
  String get sign_up_page_action_ok => 'Grattis! Ditt konto har just skapats.';

  @override
  String get sign_up_page_display_name_hint => 'Namn';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Ange det visningsnamn du vill använda';

  @override
  String get sign_up_page_email_hint => 'E-post';

  @override
  String get sign_up_page_email_error_empty => 'E-post krävs';

  @override
  String get sign_up_page_email_error_invalid => 'Ogiltig e-postadress';

  @override
  String get sign_up_page_username_hint => 'Användarnamn: Offentligt synligt';

  @override
  String get sign_up_page_username_error_empty => 'Ange ett användarnamn';

  @override
  String get sign_up_page_username_error_invalid =>
      'Ange ett giltigt användarnamn';

  @override
  String get sign_up_page_username_description =>
      'Användarnamnet får inte innehålla mellanslag, versaler eller specialtecken.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Användarnamnet får inte överstiga $value tecken';
  }

  @override
  String get sign_up_page_password_hint => 'Lösenord';

  @override
  String get sign_up_page_password_error_empty => 'Vänligen ange ett lösenord';

  @override
  String get sign_up_page_password_error_invalid =>
      'Vänligen ange ett giltigt lösenord (minst 6 tecken)';

  @override
  String get sign_up_page_confirm_password_hint => 'Bekräfta Lösenord';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Vänligen bekräfta ditt lösenord';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Lösenorden matchar inte';

  @override
  String get sign_up_page_agree_text => 'Jag samtycker till Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'användarvillkor och bidrag';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'När du skapar ett konto är det obligatoriskt att acceptera användarvillkoren, men anonyma bidrag kan fortfarande göras via appen';

  @override
  String get sign_up_page_producer_checkbox => 'Jag är en livsmedelsproducent';

  @override
  String get sign_up_page_producer_hint => 'Producent/märke';

  @override
  String get sign_up_page_producer_error_empty =>
      'Ange en producent eller ett varumärke';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Jag vill prenumerera på Open Food Facts nyhetsbrev (Du kan avregistrera dig när som helst)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Användarnamnet finns redan, välj ett annat användarnamn.';

  @override
  String get sign_up_page_email_already_exists =>
      'finns redan, logga in på kontot eller försök med en annan e-post.';

  @override
  String get sign_up_page_provide_valid_email => 'Ange en giltig e-postadress.';

  @override
  String get sign_up_page_server_busy =>
      'Vi är ledsna, men det uppstod ett tekniskt problem när du skulle skapa ditt konto. Vänligen försök igen senare.';

  @override
  String get settingsTitle => 'Inställningar';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Mörkt';

  @override
  String get darkmode_light => 'Ljust';

  @override
  String get darkmode_system_default => 'Systemets standardinställning';

  @override
  String get thanks_for_contributing => 'Tack för att du bidrar!';

  @override
  String get contributors_label => 'De bygger appen';

  @override
  String get contributors_dialog_title => 'Bidragsgivare';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Bidragsgivare: $name';
  }

  @override
  String get contributors_description =>
      'En lista över alla bidragsgivare till denna app';

  @override
  String get support => 'Stod';

  @override
  String get support_join_slack => 'Be om hjälp i vår Slack-kanal';

  @override
  String get support_via_forum => 'Be om hjälp på vårt forum';

  @override
  String get support_via_email => 'Skicka ett e-postmeddelande till oss';

  @override
  String get support_via_email_include_logs_dialog_title => 'Skicka apploggar?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Vill du bifoga applikationsloggar som bilaga till din e-post?';

  @override
  String get termsOfUse => 'Användningsvillkor';

  @override
  String get legalNotices => 'Juridiska meddelanden';

  @override
  String get privacy_policy => 'Integritetspolicy';

  @override
  String get about_this_app => 'Om appen';

  @override
  String get contribute => 'Bidra';

  @override
  String get contribute_sw_development => 'Mjukvaruutveckling';

  @override
  String get contribute_develop_text =>
      'Koden för alla Open Food Facts-produkter finns på GitHub. Du är välkommen att återanvända koden (den är öppen källkod) och hjälpa oss att förbättra den för alla på hela planeten.';

  @override
  String get contribute_develop_text_2 =>
      'Du kan gå med i Open Food Facts Slack-chattrummet, det är det föredragna sättet att ställa frågor.';

  @override
  String get contribute_develop_dev_mode_title => 'DEV-läge?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktivera DEV-läget';

  @override
  String get contribute_donate_title => 'Donera';

  @override
  String get contribute_donate_header => 'Donera till Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Vänligen observera att med den interna alfaversionen är fullständig dataförlust möjlig, och appen kan bli oanvändbar när som helst!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Produkter att slutföra';

  @override
  String get contribute_improve_header => 'Förbättrar';

  @override
  String get contribute_improve_text =>
      'Databasen är kärnan i projektet. Det är enkelt och väldigt snabbt att hjälpa till. Du kan ladda ner mobilappen till din telefon och börja lägga till eller förbättra produkter.\n\nÅ andra sidan, så erbjuder Open Food Facts webbsida många sätt att bidra: ';

  @override
  String get contribute_translate_header => 'Översätt';

  @override
  String get contribute_data_quality => 'Datakvalitet';

  @override
  String get contribute_translate_link_text => 'Börja översätta';

  @override
  String get contribute_translate_text =>
      'Open Food Facts är ett globalt projekt som innehåller produkter från mer än 160 länder. Open Food Facts översätts till dussintals språk, med innehåll som ständigt förändras.';

  @override
  String get contribute_translate_text_2 =>
      'Översättningar är ett av projektets viktigaste uppgifter';

  @override
  String get contribute_join_skill_pool =>
      'Bidra med dina färdigheter till Open Food Facts. Gå med i kunskapspoolen!';

  @override
  String get contribute_share_header => 'Dela Open Food Facts med dina vänner';

  @override
  String get contribute_share_content =>
      'Jag ville tipsa er om appen jag använder, Open Food Facts, som låter er få information om er mats hälso- och miljöpåverkan på ett personligt sätt. Den fungerar genom att skanna streckkoderna på förpackningen. Den är dessutom gratis, kräver ingen registrering och ni kan till och med bidra till att öka antalet dechiffrerade produkter. Här är länken för att ladda ner den till er telefon: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Bidra till priser genom att begära en GDPR-export av dina lojalitetskortsdata';

  @override
  String get tap_to_answer => 'Tryck här för att svara på frågor';

  @override
  String get tap_to_answer_hint =>
      'Tryck här för att svara på frågor om denna produkt';

  @override
  String get robotoff_questions_loading_hint =>
      'Vänligen vänta medan frågor om den här produkten laddas';

  @override
  String get saving_answer => 'Sparar ditt svar';

  @override
  String get contribute_to_get_rewards =>
      'Bli en aktör för livsmedelstransparens';

  @override
  String get question_sign_in_text =>
      'Logga in på ditt Open Food Facts-konto för att få kredit för dina bidrag';

  @override
  String get question_yes_button_accessibility_value => 'Svara med ja';

  @override
  String get question_no_button_accessibility_value => 'Svara med nej';

  @override
  String get question_skip_button_accessibility_value =>
      'Hoppa över den här frågan';

  @override
  String get tap_to_edit_search => 'Tryck för att redigera sökningen';

  @override
  String get myPreferences => 'Mina preferenser';

  @override
  String get account_create_message =>
      'Skapa ditt konto och gå med i Open Food Facts-communityn för att hjälpa till att bygga upp matkunskap över hela världen!';

  @override
  String get join_us => 'Anslut till oss';

  @override
  String get myPreferences_profile_title => 'Din profil';

  @override
  String get myPreferences_profile_subtitle =>
      'Hantera ditt Open Food Facts bidragsgivarkonto.';

  @override
  String get myPreferences_settings_title => 'Appinställningar';

  @override
  String get myPreferences_settings_subtitle => 'Mörkt läge, Språk…';

  @override
  String get myPreferences_food_title => 'Matpreferenser';

  @override
  String get myPreferences_food_subtitle =>
      'Välj vilken information om mat som är viktigast för dig.';

  @override
  String get myPreferences_food_comment =>
      'Välj vilken information om mat som är viktigast för dig, för att rangordna mat enligt dina preferenser, se den information du bryr dig om först, och få en kompatibilitetssammanfattning. Dessa matpreferenser stannar på din enhet, och är inte associerade med ditt Open Food Facts bidragsgivarkonto om du har ett.';

  @override
  String get confirmResetPreferences => 'Återställa dina matpreferenser?';

  @override
  String get myPersonalizedRanking => 'Min personliga rankning';

  @override
  String get ranking_tab_all => 'Alla';

  @override
  String get ranking_subtitle_match_yes => 'En bra match för dig';

  @override
  String get ranking_subtitle_match_no => 'Mycket dålig matchning';

  @override
  String get ranking_subtitle_match_maybe => 'Okänd matchning';

  @override
  String get refresh_with_new_preferences =>
      'Uppdatera listan med dina nya inställningar';

  @override
  String get reloaded_with_new_preferences =>
      'Laddades om med dina nya inställningar';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Skanna';

  @override
  String get history_navbar_label => 'Historik';

  @override
  String get list_navbar_label => 'Listor';

  @override
  String get category => 'Filtrera efter kategori';

  @override
  String get category_all => 'Alla';

  @override
  String get category_search => '(kategorisökning)';

  @override
  String get filter => 'Filter';

  @override
  String get scan => 'Produkter från skanningsskärmen';

  @override
  String get scan_history => 'Skanningshistorik';

  @override
  String get search => 'Sök';

  @override
  String get search_product_help =>
      'Sök efter en produkt,\nett varumärke eller en streckkod';

  @override
  String get search_filter => 'Sökfilter';

  @override
  String get search_history => 'Sökhistorik';

  @override
  String get search_store => 'Sök efter en butik';

  @override
  String get search_store_help => 'Tips: lägg till stad eller land';

  @override
  String get tap_for_more => 'Tryck för att se mer information…';

  @override
  String get product => 'Produkt';

  @override
  String get unknownBrand => 'Okänt varumärke';

  @override
  String get unknownQuantity => 'Okänd kvantitet';

  @override
  String get unknownProductName => 'Okänt produktnamn';

  @override
  String get label_refresh => 'Uppdatera';

  @override
  String get label_reload => 'Ladda om';

  @override
  String get image => 'Bild';

  @override
  String get front_photo => 'Framsidans foto';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (den här bilden kan vara föråldrad)';
  }

  @override
  String get outdated_image_short_label => 'kan vara föråldrad';

  @override
  String get ingredients => 'Ingredienser';

  @override
  String get ingredients_editing_instructions =>
      'Behåll den ursprungliga ordningen. Ange procentandelen när den anges. Separera med kommatecken eller bindestreck och använd parenteser för ingredienserna i en ingrediens.';

  @override
  String get ingredients_editing_error =>
      'Det gick inte att spara ingredienserna.';

  @override
  String get ingredients_editing_image_error =>
      'Det gick inte att hämta en ny ingrediensbild.';

  @override
  String get ingredients_editing_title => 'Redigera ingredienser';

  @override
  String get ingredients_photo => 'Foto på ingredienser';

  @override
  String get packaging_editing_instructions =>
      'Lista alla förpackningsdelar separerade med kommatecken eller radmatning, med deras mängd (t.ex. 1 eller 6), typ (t.ex. flaska, låda, burk), material (t.ex. plast, metall, aluminium) och om tillgängligt deras storlek (t.ex. 33 cl) samt återvinningsinstruktioner.\nExempel: 1 glasflaska att återvinna, 1 plastkork att kasta bort';

  @override
  String get packaging_editing_error =>
      'Misslyckades med att spara förpackningen.';

  @override
  String get packaging_editing_image_error =>
      'Det gick inte att hämta en ny förpackningsbild.';

  @override
  String get packaging_editing_title => 'Redigera förpackning';

  @override
  String get nutrition => 'Näring';

  @override
  String get nutrition_facts_photo => 'Foto på näringsfakta';

  @override
  String get nutrition_facts_editing_title => 'Redigera näringsfakta';

  @override
  String get packaging_information => 'Återvinningsinstruktioner';

  @override
  String get packaging_information_photo => 'Återvinningsinstruktioner foto';

  @override
  String get missing_product => 'Du har hittat en ny produkt!';

  @override
  String get add_product_take_photos =>
      'Ta bilder på förpackningen för att lägga till den här produkten i Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Ta gärna några bilder först. Du kan alltid slutföra produkten senare.';

  @override
  String get add_product_information_button_label =>
      'Lägg till produktinformation';

  @override
  String get new_product => 'Ny produkt';

  @override
  String get new_product_found_title => 'Ny produkt hittad!';

  @override
  String get new_product_found_text =>
      'Vår samarbetsdatabas innehåller mer än **3 miljoner produkter**, men denna streckkod finns inte: ';

  @override
  String get new_product_found_button => 'Lägg till den här produkten';

  @override
  String get new_product_leave_title => 'Lämna denna sida?';

  @override
  String get new_product_leave_message =>
      'Det verkar som att du inte har angett något. Vill du verkligen lämna den här sidan?';

  @override
  String get new_product_dialog_description =>
      'Vänligen ta bilder på förpackningen för att lägga till den här produkten i vår gemensamma databas.';

  @override
  String get new_product_dialog_illustration_description =>
      'En illustration med okänt Nutri-Score och Green Score';

  @override
  String get front_packaging_photo_button_label =>
      'Foto på framsidan av förpackningen';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Bekräfta uppladdning av foto av framsidan av förpackningen';

  @override
  String get confirm_button_label => 'Bekräfta';

  @override
  String get send_image_button_label => 'Skicka bild';

  @override
  String get crop_page_action_saving => 'Sparar bilden…';

  @override
  String get crop_page_action_cropping => 'Beskär bilden…';

  @override
  String get crop_page_action_local => 'Sparar en lokal version…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oj då… det är något fel med ditt foto!';

  @override
  String get crop_page_action_local_failed_message =>
      'Vi kan inte bearbeta bilden lokalt innan vi skickar den till vår server. Försök igen senare eller kontakta oss om problemet kvarstår.';

  @override
  String get crop_page_action_retake => 'Ta om ett foto';

  @override
  String get crop_page_too_small_image_title => 'Bilden är för liten!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Minsta storlek i pixlar för bilduppladdning är ${expectedMinWidth}x$expectedMinHeight. Den aktuella bilden är ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Förbereder ett anrop till servern…';

  @override
  String get front_packaging_photo_title => 'Foto på Förpackningens Framsida';

  @override
  String get ingredients_photo_title => 'Foto på Ingredienser';

  @override
  String get nutritional_facts_photo_title => 'Näringsfakta Foto';

  @override
  String get recycling_photo_title => 'Återvinningsinstruktioner Foto';

  @override
  String get take_photo_title => 'Ta en bild';

  @override
  String get take_more_photo_title => 'Ta fler bilder';

  @override
  String get front_photo_uploaded => 'Framsidefoto uppladdat';

  @override
  String get ingredients_photo_button_label => 'Foto på ingredienser';

  @override
  String get ingredients_photo_uploaded => 'Ingrediensfoto uppladdat';

  @override
  String get nutrition_cache_loading_error =>
      'Det gick inte att ladda näringsämnen från cachen';

  @override
  String get nutritional_facts_photo_button_label => 'Foto på näringsfakta';

  @override
  String get nutritional_facts_input_button_label => 'Fyll i näringsfakta';

  @override
  String get nutritional_facts_added => 'Näringsfakta tillagd';

  @override
  String get categories_added => 'Kategorier tillagda';

  @override
  String get new_product_title_nutriscore => 'Beräkna Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Hjälp oss genom att fylla i minst en kategori och näringsvärden';

  @override
  String get new_product_title_environmental_score =>
      'Beräkna den gröna poängen';

  @override
  String get new_product_subtitle_environmental_score =>
      'Få det genom att fylla i minst en kategori';

  @override
  String get new_product_additional_environmental_score =>
      'Gör beräkningen av Green Score mer exakt med ursprung, förpackning och mer';

  @override
  String get new_product_title_nova =>
      'Beräkna livsmedelsbearbetningsnivån (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Få det genom att fylla i matkategorin och ingredienserna';

  @override
  String get new_product_desc_nova_unknown =>
      'Livsmedelsbearbetningsnivå okänd';

  @override
  String get new_product_title_pictures => 'Ny produkt';

  @override
  String get new_product_title_pictures_details =>
      'Ta följande foton så kan Open Food Facts-motorn fixa resten!';

  @override
  String get new_product_title_misc => 'Och lite grundläggande data…';

  @override
  String new_product_done_msg(String username) {
    return 'Tack för ditt bidrag “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Tack för ditt bidrag!';

  @override
  String get new_product_done_button_label => 'Upptäck den färdiga produkten';

  @override
  String get hey_incomplete_product_message =>
      'Tryck för att svara på 3 frågor NU för att beräkna Nutri-Score, Green Score och Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Tryck nu för att svara på två frågor som hjälper dig att analysera denna kosmetika!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Tryck nu för att svara på 3 frågor som hjälper dig att analysera denna djurfoderprodukt!';

  @override
  String get hey_incomplete_product_message_product =>
      'Tryck nu för att hjälpa till att slutföra den här produkten!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Foto på näringsfakta uppladdat';

  @override
  String get recycling_photo_button_label => 'Foto på återvinningsinformation';

  @override
  String get recycling_photo_uploaded => 'Återvinningsfoto uppladdat';

  @override
  String get take_more_photo_button_label => 'Ta fler bilder';

  @override
  String get other_photo_uploaded => 'Övrigt foto uppladdat';

  @override
  String get retake_photo_button_label => 'Ta om';

  @override
  String get selecting_photo => 'Väljer foto';

  @override
  String get uploading_image => 'Laddar upp fotot till servern';

  @override
  String get uploading_image_type_front =>
      'Laddar upp framsidabild till Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Ladda upp ingrediensbild till Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Ladda upp näringsbild till Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Ladda upp förpackningsbild till Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Laddar upp annan bild till Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Laddar upp bild till Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Lägg till saknade ingredienser';

  @override
  String get score_add_missing_packaging_image =>
      'Lägg till bild på saknad förpackning';

  @override
  String get score_add_missing_nutrition_facts =>
      'Lägg till saknade näringsfakta';

  @override
  String get score_add_missing_product_traces =>
      'Lägg till saknade produktspår';

  @override
  String get score_add_missing_product_category =>
      'Lägg till saknad produktkategori';

  @override
  String get score_add_missing_precise_product_category =>
      'Välj en mer exakt kategori';

  @override
  String get score_add_missing_product_countries =>
      'Lägg till saknade produktländer';

  @override
  String get score_add_missing_product_emb =>
      'Lägg till saknade produktspårbarhetskoder';

  @override
  String get score_add_missing_product_labels =>
      'Lägg till saknade produktetiketter';

  @override
  String get score_add_missing_product_origins =>
      'Lägg till saknade produktursprung';

  @override
  String get score_add_missing_product_stores =>
      'Lägg till saknade produktbutiker';

  @override
  String get score_add_missing_product_brands =>
      'Lägg till saknade produktmärken';

  @override
  String get score_update_nutrition_facts => 'Uppdatera näringsfakta';

  @override
  String get nutrition_page_title => 'Näringsfakta';

  @override
  String get nutrition_page_nutritional_info_title => 'Näringsinformation';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Värden som anges på produkten:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Ja';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Nej';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Öppna foto';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'God praxis: Näringsinformation';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Ibland anges näringsinnehållet inte på förpackningen eller i ett dokument som medföljer produkten. I det här fallet, och endast i det här fallet, kan du ställa in värdet till NEJ.';

  @override
  String get nutrition_page_serving_type_label => 'Näringsvärden:';

  @override
  String get nutrition_page_per_100g => 'per 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'per 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'per portion';

  @override
  String get nutrition_page_add_nutrient => 'Lägg till ett näringsämne';

  @override
  String get nutrition_page_serving_size => 'Portionsstorlek';

  @override
  String get nutrition_page_serving_size_hint =>
      'Ange en portionsstorlek (t.ex. 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'God praxis: Portionsstorlek';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Detta värde hjälper till att **göra en proportionell beräkning av varje näringsämne per portionsstorlek**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Tillåtna enheter** är: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 公卨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** eller **60 G** (föredra den första)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** eller **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Ogiltig enhet';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Ogiltiga enheter';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **godisar** och 2 **kex**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Saknad enhet';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Ogiltigt nummer';

  @override
  String get nutrition_page_update_running =>
      'Uppdaterar produkten på servern…';

  @override
  String get nutrition_page_update_done => 'Produkt uppdaterad!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Använd produktmängden som portionsstorlek';

  @override
  String get nutrition_page_photo_error => 'Det gick inte att ladda fotot';

  @override
  String get more_photos => 'Fler intressanta bilder';

  @override
  String get view_more_photo_button =>
      'Visa alla befintliga foton för den här produkten';

  @override
  String get no_product_found => 'Ingen produkt hittades';

  @override
  String get no_location_found => 'Ingen plats hittades';

  @override
  String get not_found => 'hittades inte:';

  @override
  String get refreshing_product => 'Uppdaterar produkt';

  @override
  String get product_refreshed => 'Produkt uppdaterad';

  @override
  String product_image_accessibility_label(String date) {
    return 'Bilden tagen $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Bilden tagen $date. Den här bilden kan vara föråldrad.';
  }

  @override
  String get product_image_outdated => 'Den här bilden kan vara föråldrad';

  @override
  String get product_image_outdated_explanations_title =>
      'Den här bilden kan vara föråldrad';

  @override
  String get product_image_outdated_explanations_content =>
      'Den här bilden togs för mer än ett år sedan.\n**Kontrollera att den fortfarande är uppdaterad**.\n\nDetta är **bara en varning**. Om innehållet fortfarande är detsamma kan du ignorera det här meddelandet.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Ersätt foto ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Lägg till ett foto ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Ta en bild';

  @override
  String get product_image_action_from_gallery =>
      'Välj från telefonens galleri';

  @override
  String get product_image_action_choose_existing_photo =>
      'Välj bland produktbilderna';

  @override
  String get product_image_details_label => 'Information om fotot';

  @override
  String get product_image_details_from_producer => 'Från producenten';

  @override
  String get product_image_details_contributor => 'Medverkande';

  @override
  String get product_image_details_contributor_producer =>
      'Medarbetare (producent)';

  @override
  String get product_image_details_date => 'Datum';

  @override
  String get product_image_details_date_unknown => 'Okänd';

  @override
  String get homepage_main_card_logo_description =>
      'Välkommen till Öppna Matfakta';

  @override
  String get homepage_main_card_subheading =>
      '**Skanna** en streckkod eller\n**sök** efter en produkt';

  @override
  String get homepage_main_card_search_field_hint => 'Sök efter en produkt';

  @override
  String get homepage_main_card_search_field_tooltip => 'Starta sökning';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Senaste nytt: $news_title';
  }

  @override
  String get tagline_app_review => 'Gillar du appen?';

  @override
  String get tagline_app_review_button_positive => 'Jag älskar det! 😍';

  @override
  String get tagline_app_review_button_negative => 'Inte riktigt…';

  @override
  String get tagline_app_review_button_later => 'Fråga mig senare';

  @override
  String get tagline_feed_news_button => 'Läs mer';

  @override
  String get app_review_negative_modal_title => 'Gillar du inte vår app?';

  @override
  String get app_review_negative_modal_text =>
      'Kan du ta några sekunder att berätta varför?';

  @override
  String get app_review_negative_modal_positive_button => 'Ja, självklart!';

  @override
  String get app_review_negative_modal_negative_button => 'Nej';

  @override
  String get could_not_refresh => 'Kunde inte uppdatera produkt';

  @override
  String get product_internet_error_modal_title => 'Ett fel har uppstått!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Vi kan inte hämta information om den här produkten på grund av ett nätverksfel. Kontrollera din internetanslutning och försök igen.\n\nInternt fel:\n$error';
  }

  @override
  String get product_tags_title => 'Produktegenskaper';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Inga fastigheter';

  @override
  String get product_tags_explanation =>
      'Genom att lägga till egenskaper (nyckel/värde) till en produkt bidrar du till att berika den.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Lägg till egenskaper';

  @override
  String get add_edit_tags => 'Lägg till eller redigera egenskaper';

  @override
  String get edit_tag => 'Redigera egenskap';

  @override
  String get remove_tag => 'Ta bort egenskap';

  @override
  String get tag_key => 'Egenskap';

  @override
  String get tag_keys => 'Fastigheter';

  @override
  String get tag_key_uneditable => 'Egenskap (ej redigerbar)';

  @override
  String get tag_key_input_hint => 'Ange en egenskap';

  @override
  String get tag_value => 'Värde';

  @override
  String get tag_values => 'Värden';

  @override
  String get tag_value_input_hint => 'Ange ett värde';

  @override
  String get tag_key_item => 'Egenskap:';

  @override
  String get tag_value_item => 'Värde:';

  @override
  String get tag_key_explanations =>
      'En nyckel måste vara liten och utan mellanslag.';

  @override
  String tag_key_already_exists(String property) {
    return 'En tagg med egenskapen $property finns redan!';
  }

  @override
  String get product_internet_error =>
      'Omöjligt att hämta information om denna produkt på grund av ett nätverksfel.';

  @override
  String get cached_results_from => 'Visa resultat från:';

  @override
  String get product_search_same_category => 'Hitta alternativ';

  @override
  String get product_search_same_category_short => 'Jämföra';

  @override
  String get product_search_same_category_error =>
      'Den här funktionen kan endast användas för produkter med en kategori.\n\nRedigera produkten för att lägga till en kategori.';

  @override
  String get product_improvement_add_category =>
      'Lägg till en kategori för att beräkna Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Lägg till näringsfakta för att beräkna Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Lägg till näringsfakta och en kategori för att beräkna Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-Score för denna produkt kan inte beräknas, vilket kan bero på t.ex. en kategori som inte är standard. Om detta anses vara ett fel, vänligen kontakta oss.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Näringsbilden är föråldrad: vänligen förnya den.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Green Score tar hänsyn till ingrediensernas ursprung. Vänligen ta ett foto av ingredienslistan och/eller eventuella geografiska påståenden eller redigera produkten så att de kan beaktas.';

  @override
  String get country_chooser_label => 'Välj ett land';

  @override
  String get currency_chooser_label => 'Vänligen välj en valuta';

  @override
  String get country_change_message => 'Du har precis bytt land.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Vill du ändra valutan från $previousCurrency till $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Välj ett land:';

  @override
  String get country_chooser_label_from_settings => 'Ditt land';

  @override
  String get country_selection_explanation =>
      'Vissa miljöegenskaper är platsspecifika';

  @override
  String get product_removed_comparison => 'Produkt borttagen från jämförelse';

  @override
  String get native_app_settings => 'Inställningar för native-appar';

  @override
  String get native_app_description =>
      'Öppna systeminställningar för Öppna matfakta';

  @override
  String get product_removed_history => 'Produkt borttagen från historik';

  @override
  String get product_removed_list => 'Produkt borttagen från listan';

  @override
  String get product_could_not_remove => 'Kunde inte ta bort produkt';

  @override
  String get no_prodcut_in_list => 'Det finns ingen produkt i denna lista';

  @override
  String get no_product_in_section => 'Det finns ingen produkt i detta avsnitt';

  @override
  String get recently_seen_products => 'Alla visade produkter';

  @override
  String get clear => 'Rensa';

  @override
  String get clear_long => 'Töm listan';

  @override
  String get really_clear => 'Vill du verkligen radera den här listan?';

  @override
  String pct_match(Object percent) {
    return '$percent% matchning';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dagar sedan',
      one: 'en dag sedan',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count timmar sedan',
      one: 'en timme sedan',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minuter sedan',
      one: 'en minut sedan',
      zero: 'mindre än en minut sedan',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count månader sedan',
      one: 'en månad sedan',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count veckor sedan',
      one: 'en vecka sedan',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Jämför $count produkter',
      one: 'Jämför en produkt',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count valda produkter',
      one: 'En vald produkt',
      zero: 'Ingen vald produkt',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Jämför utvalda produkter';

  @override
  String get delete_products_mode => 'Ta bort valda produkter';

  @override
  String get select_all_products_mode => 'Välj alla produkter';

  @override
  String get select_none_products_mode => 'Välj ingen';

  @override
  String get compare_products_appbar_title => 'Jämför produkter';

  @override
  String get compare_products_appbar_subtitle =>
      'Vänligen välj minst två produkter';

  @override
  String get retry_button_label => 'Försök igen';

  @override
  String get connect_with_us => 'Kontakta oss';

  @override
  String get tiktok => 'Följ oss på TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Följ oss på Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Följ oss på X (tidigare Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Följ oss på Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Följ oss på BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blogg';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => 'Upptäck';

  @override
  String get how_to_contribute => 'Hur man bidrar';

  @override
  String get hint_knowledge_panel_message =>
      'Du kan trycka på valfri del av kortet för att få mer information om vad du ser. Prova det nu!';

  @override
  String get permissions_page_title => 'Kameraåtkomst';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'Om du ändrar dig kan det här alternativet aktiveras och inaktiveras när som helst från inställningarna.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Version: $release)\nModell: $model\nProdukt: $product\nEnhet: $device\nMärke:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModell: $model\nLokaliserad modell: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nAppversion:$appVersion\nAppversionsnummer:$appBuildNumber\nApppaketnamn:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'Neka';

  @override
  String get ask_me_later_button_label => 'Senare';

  @override
  String get are_you_sure => 'Är du säker?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Gå vidare på $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Välkommen !';

  @override
  String get onboarding_home_welcome_text2 =>
      'Appen som hjälper dig att välja mat som är bra för **dig** och **planeten**!';

  @override
  String get onboarding_continue_button => 'Fortsätt';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Laddar din första exempelprodukt';

  @override
  String get onboarding_welcome_warning =>
      'Tyvärr, det är vår exempelprodukt, du kan inte redigera den :)';

  @override
  String get product_list_your_ranking => 'Din placering är';

  @override
  String get product_list_empty_icon_desc => 'Historik inte tillgänglig';

  @override
  String get product_list_empty_title => 'Börja skanna';

  @override
  String get product_list_empty_message =>
      'Skannade produkter visas här och du kan kontrollera detaljerad information om dem.';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produkter',
      one: 'produkt',
      zero: 'produkt',
    );
    return 'Uppdaterar $_temp0 i din historik';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Produkter',
      one: 'Produkt',
      zero: 'Produkt',
    );
    return '$_temp0 uppdatering klar';
  }

  @override
  String get product_list_compare_side_by_side => 'Jämför sida vid sida';

  @override
  String get loading_dialog_default_title => 'Laddar ner data';

  @override
  String get loading_dialog_default_error_message =>
      'Kunde inte ladda ner data';

  @override
  String get account_delete => 'Radera konto';

  @override
  String get account_delete_title => 'Ta bort mitt konto';

  @override
  String get user_profile => 'Konto';

  @override
  String get user_profile_title_guest => 'Välkommen!';

  @override
  String get user_profile_subtitle_guest =>
      'Logga in eller registrera dig för att gå med i Open Food Facts-communityn';

  @override
  String user_profile_title_id_email(String email) {
    return 'Öppna Matfakta-inloggning: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Välkommen $id!';
  }

  @override
  String get email_subject_account_deletion => 'Radera konto';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hej, vänligen radera mitt Open Food Facts-konto: $userId';
  }

  @override
  String get settings_app_app => 'Ansökan';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Produkter';

  @override
  String get settings_app_miscellaneous => 'Diverse';

  @override
  String get camera_play_sound_title => 'Spela upp ett ljud vid skanning';

  @override
  String get camera_play_sound_subtitle => 'Piper vid varje lyckad skanning';

  @override
  String get camera_window_accessibility_label =>
      'Skanna en streckkod med din kamera';

  @override
  String get app_haptic_feedback_title => 'Vibration och haptik';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrationer efter att vissa åtgärder har utförts (streckkod avkodad, produkt borttagen…).';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'När det är aktiverat skickas kraschrapporter automatiskt till Open Food Facts felspårningssystem, så att buggar kan åtgärdas och därmed förbättra appen.';

  @override
  String get send_anonymous_data_toggle_title => 'Skicka anonym data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Redigera foto';

  @override
  String get permission_photo_error => 'Fel';

  @override
  String get permission_photo_denied_title =>
      'Tillåt kameraanvändning för att skanna streckkoder';

  @override
  String permission_photo_denied_message(String appName) {
    return 'För en förbättrad upplevelse, låt $appName komma åt din kamera. Du kommer att kunna skanna streckkoder direkt.';
  }

  @override
  String get permission_photo_denied_button => 'Tillåt';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Åtkomst nekad';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Eftersom du tidigare har nekat kameratillstånd måste du tillåta det manuellt från Inställningar.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Öppna inställningar';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Annulera';

  @override
  String get permission_photo_none_found => 'Ingen kamera upptäckt';

  @override
  String get permission_photo_denied => 'Ingen kameraåtkomst beviljad';

  @override
  String get show_product_pictures => 'Visa produktbilder';

  @override
  String get edit_product_label => 'Redigera produkt';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Laddar upp dina redigeringar…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Dina redigeringar **skickas i bakgrunden** (eller senare vid fel).\nDu kan fortsätta redigera andra produktfält.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Dina redigeringar **skickas i bakgrunden** (eller senare om det uppstår ett fel).';

  @override
  String get edit_product_label_short => 'Redigera';

  @override
  String edit_product_form_item_help(String value) {
    return 'Hur skriver man in \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Ange ett värde som inte är tomt!';

  @override
  String get edit_product_form_item_error_existing =>
      'Detta värde finns redan där!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Lägg till ett nytt märke';

  @override
  String get edit_product_form_item_add_action_label =>
      'Lägg till en ny etikett';

  @override
  String get edit_product_form_item_add_action_store => 'Lägg till en ny butik';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Lägg till ett nytt ursprung';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Lägg till en ny spårbarhetskod';

  @override
  String get edit_product_form_item_add_action_country =>
      'Lägg till ett nytt land';

  @override
  String get edit_product_form_item_add_action_category =>
      'Lägg till en ny kategori';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Lägg till ett nytt spår';

  @override
  String get edit_product_form_item_add_suggestion => 'Lägg till förslag';

  @override
  String get edit_product_form_item_deny_suggestion => 'Avvisa förslag';

  @override
  String get edit_product_form_item_details_title => 'Grundläggande uppgifter';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Produktnamn, varumärke, kvantitet';

  @override
  String get edit_product_form_item_other_details_title =>
      'Ytterligare detaljer';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Webbplats…';

  @override
  String get edit_product_form_item_photos_title => 'Foton';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Lägg till eller uppdatera foton';

  @override
  String get edit_product_form_item_labels_title =>
      'Etiketter & Certifieringar';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Miljö, Kvalitetsmärkning…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Ange en etikett (t.ex.: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'etikett';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'God praxis: Etiketter';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Alla egenskaper hos produkten **som är faktiska** och skiljer sig från de andra fälten.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Tillverkad i Belgien, producerad i Bretagne…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rik på fiber, källa till järn…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Rättvis handel, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Butiker';

  @override
  String get edit_product_form_item_stores_hint => 'Ange en butik';

  @override
  String get edit_product_form_item_stores_type => 'butik';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'God praxis: Butiker';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Ange butiken där du köpte produkten.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Ursprung';

  @override
  String get edit_product_form_item_origins_hint =>
      'Ange ett ursprung (t.ex. Tyskland)';

  @override
  String get edit_product_form_item_origins_type => 'land';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'God praxis: Ursprung';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Lägg till **alla ursprungsindikationer som du kan hitta på förpackningen**.\nDu behöver inte oroa dig för ursprung som anges direkt i ingredienslistan.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Nötkött från Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Sojan kommer inte från Europeiska unionen';

  @override
  String get edit_product_form_item_countries_title => 'Land';

  @override
  String get edit_product_form_item_countries_hint =>
      'Ange ett land (t.ex. Tyskland)';

  @override
  String get edit_product_form_item_countries_type => 'land';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'God praxis: Länder';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Länder där produkten är allmänt tillgänglig** (exklusive butiker som specialiserar sig på utländska produkter).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Spårbarhetskoder';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Ange en kod (t.ex.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'spårbarhetskod';

  @override
  String get edit_product_form_item_emb_help_title =>
      'God praxis: Spårbarhetskoder';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'I det här avsnittet kan du ange koder relaterade till **förpackningsmärken**, **identifieringsmärken** eller **hälsomärken**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Exempel på spårbarhetskoder';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EG-koder** som används i Europeiska gemenskapen för att identifiera livsmedelsproducenter eller förpackare:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: landskod för **Frankrike**\n**72.264.002**: geografiska data\n**CE**: Europeiska gemenskapen';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB-koder** som används i Frankrike:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Spår';

  @override
  String get edit_product_form_item_traces_hint => 'spår';

  @override
  String get edit_product_form_item_traces_type =>
      'Mata in ett spår (t.ex.: sojabönor)';

  @override
  String get edit_product_form_item_categories_title => 'Kategorier';

  @override
  String get edit_product_form_item_categories_hint => 'kategori';

  @override
  String get edit_product_form_item_categories_type =>
      'Ange en kategori (t.ex.: Apelsinjuice)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'God praxis: Kategorier';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Ange **endast den mest specifika kategorin**.\nÖverordnade kategorier läggs till automatiskt.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Saknad kategori?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Om en kategori **inte är tillgänglig i autokomplettering** kan du gärna lägga till den ändå.\nDetta hjälper oss att förbättra Open Food Facts i ditt land.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardiner i olivolja';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Apelsinjuice från koncentrat';

  @override
  String get edit_product_form_item_exit_title => 'Avsluta utan att spara?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Vill du spara dina ändringar innan du lämnar den här sidan?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Spara ändringar';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Överge ändringar';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredienser';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Zooma in och ut genom att nypa på skärmen';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Zooma in och ut fotot';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Med hjälp av **Nyp-för-att-zooma** kan du zooma in eller ut fotot:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Lägg till';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Vänligen ange en text först';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Ta bort';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Spara din redigering';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Avbryt din redigering';

  @override
  String get edit_product_form_item_packaging_title =>
      'Återvinningsinstruktioner foto';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Näringsfakta';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Näring, alkoholhalt…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'God praxis: Näringsfakta';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Näringsvärden';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Välj först om **värdena anges**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Näringsfakta';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Ange sedan näringsvärdena **som anges på förpackningen**. Om det inte finns något värde kan du klicka på \"Öga\"-ikonen.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Saknat fält?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Om en post saknas kan du **klicka på \"Plus\"-ikonen** för att lägga till den (t.ex.: vitamin D, magnesium…).';

  @override
  String get edit_product_form_save => 'Redigera';

  @override
  String get edit_product_ingredients_photo_title => 'Foto på ingredienser';

  @override
  String get edit_product_ingredients_list_title => 'Lista över ingredienser';

  @override
  String get edit_product_packaging_photo_title => 'Förpackningsfoto';

  @override
  String get edit_product_packaging_list_title => 'Förpackningslista';

  @override
  String get no_data_available => 'Inga data tillgängliga';

  @override
  String get product_field_website_title => 'Webbplats';

  @override
  String get origins_editing_title => 'Redigera ursprung';

  @override
  String get completed_basic_details_btn_text =>
      'Komplettera grundläggande uppgifter';

  @override
  String get not_implemented_snackbar_text => 'Inte implementerat ännu';

  @override
  String get category_picker_page_appbar_text => 'Kategorier';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extrahera ingredienser från fotot';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extrahera ingredienser';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extraherar ingredienser\nfrån fotot';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Laddar foto…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Varför ser jag det här meddelandet?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'För att använda funktionen \"Extrahera ingredienser\" måste fotot först laddas upp.\n\nVänta några sekunder eller ange dem manuellt.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Uppdatera foto';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extrahera förpackningen\nfrån fotot';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extrahera förpackning';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extrahera förpackning från fotot';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Laddar foto…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Varför ser jag det här meddelandet?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'För att använda funktionen \"Extrahera förpackning\" måste fotot först laddas upp.\n\nVänta några sekunder eller ange dem manuellt.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Uppdatera foto';

  @override
  String get edit_ocr_extract_failed => 'Kunde inte identifiera text i bilden.';

  @override
  String get edit_ocr_extract_disabled_title => 'Ingen bild!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'För att kunna använda funktionen för textutvinning måste du först ta ett foto.';

  @override
  String get user_list_dialog_new_title => 'Ny lista över produkter';

  @override
  String get user_list_dialog_rename_title => 'Byt namn på lista';

  @override
  String get user_list_subtitle_product => 'Listor';

  @override
  String get user_list_title => 'Dina listor';

  @override
  String get user_list_add_product => 'Lägg till produkten i dina listor';

  @override
  String get user_list_button_new => 'Skapa en ny lista';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Lägg till i lista';

  @override
  String get added_to_list_msg => 'Tillagd i listan';

  @override
  String get user_list_popup_clear => 'Rensa din historik';

  @override
  String get user_list_popup_rename => 'Byt namn';

  @override
  String get user_list_name_hint => 'Min lista';

  @override
  String get user_list_name_error_empty => 'Namn är obligatoriskt';

  @override
  String get user_list_name_error_already => 'Det namnet används redan';

  @override
  String get user_list_name_error_same => 'Det är samma namn';

  @override
  String get user_list_name_input_hint => 'Namn på listan';

  @override
  String get try_again => 'Försök igen';

  @override
  String get there_was_an_error => 'Ett fel inträffade';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Ingen kategori hittades för $items';
  }

  @override
  String get camera_toggle_camera => 'Växla mellan bakre och främre kamera';

  @override
  String get camera_toggle_flash => 'Slå PÅ eller AV kamerans blixt';

  @override
  String get camera_enable_flash => 'Aktivera blixt';

  @override
  String get camera_disable_flash => 'Inaktivera blixt';

  @override
  String get camera_flash_error_dialog_title => 'Ett fel uppstod!';

  @override
  String get camera_flash_error_dialog_message =>
      'Ett fel uppstod när blixtens status ändrades. Se till att ficklampan inte redan är aktiverad på din smartphone.';

  @override
  String get category_picker_no_category_found_button => 'Tillbaka';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Klicka för att öppna i din webbläsare eller i appen (om den är installerad)';

  @override
  String get dev_preferences_screen_title => 'DEV-läge';

  @override
  String get dev_preferences_screen_subtitle =>
      'Få tillgång till experimentella funktioner och utvecklingsverktyg';

  @override
  String get dev_preferences_reset_onboarding_title => 'Omstart av onboarding';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Du måste sedan starta om appen för att se den igen.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Växla mellan openfoodfacts.org (PROD) och testmiljön';

  @override
  String get dev_preferences_test_environment_title =>
      'Parametrar för testmiljön';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Bas-URL för aktuell testmiljö: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title => 'Testmiljövärd';

  @override
  String get dev_preferences_ml_kit_title => 'Använd ML-kitet';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'då måste du starta om den här appen';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Ytterligare knapp på produktsidan';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Redigera ingredienser via en knapp i kunskapspanelen';

  @override
  String get dev_preferences_export_history_title => 'Exportera historik';

  @override
  String get dev_preferences_export_history_progress_error => 'undantag';

  @override
  String get dev_preferences_export_history_progress_found => 'produkt hittad';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produkt hittades INTE';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Exportera historik';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Annulera';

  @override
  String get dev_preferences_migration_title => 'Datamigrering från V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Status: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'lyckad eller nyinstallation';

  @override
  String get dev_preferences_migration_status_success => 'framgång';

  @override
  String get dev_preferences_migration_status_error => 'fel';

  @override
  String get dev_preferences_migration_status_in_progress => 'pågående';

  @override
  String get dev_preferences_migration_status_required =>
      'obligatorisk (klicka för att starta)';

  @override
  String get dev_preferences_migration_status_not_started => 'okänd';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Rensar historiken och lägger till 3 produkter där';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Anpassad URL för nyheter';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL till JSON-filen:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Inte inställd';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Senaste uppdatering: $date';
  }

  @override
  String get product_type_label_food => 'Mat';

  @override
  String get product_type_label_beauty => 'Personlig vård';

  @override
  String get product_type_label_pet_food => 'Djurmat';

  @override
  String get product_type_label_product => 'Övrigt';

  @override
  String get product_type_selection_title => 'Produkttyp';

  @override
  String get product_type_selection_subtitle => 'Välj typ av denna produkt';

  @override
  String get product_type_selection_empty =>
      'Du måste först välja en produkttyp!';

  @override
  String product_type_selection_already(String productType) {
    return 'Du kan inte ändra produkttypen ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Genväg till Priser-appen på produktsidan';

  @override
  String get prices_app_button => 'Gå till Priser-appen';

  @override
  String get prices_website_button => 'Öppna på webbplatsen för öppna priser';

  @override
  String get prices_bulk_proof_upload_select =>
      'Lägg till prislappar direkt från galleriet';

  @override
  String get prices_bulk_proof_upload_warning =>
      'När du väl har valt bilder kan du inte redigera dem!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI kommer att använda dina bevis för att extrahera priser.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Tillåt communityn att validera priser som extraherats av AI.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Flera prislappar';

  @override
  String get prices_bulk_proof_upload_title => 'Massuppladdning av bevis';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Välja filer';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Startar uppladdningen';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Lokal kopiering av fil #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Förbereder uppladdning #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Misslyckades vid bild #$index/$count';
  }

  @override
  String get prices_generic_title => 'Priser';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Lägg till $count priser',
      one: 'Lägg till ett pris',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Skicka $count priser',
      one: 'Skicka priset',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Lägg till ett objekt';

  @override
  String get prices_add_a_price => 'Lägg till ett pris';

  @override
  String get prices_add_a_receipt => 'Lägg till ett kvitto';

  @override
  String get prices_add_price_tags => 'Lägg till prislappar';

  @override
  String prices_barcode_already(String barcode) {
    return 'Denna streckkod ($barcode) finns redan i listan!';
  }

  @override
  String get prices_barcode_search_not_found => 'Finner ej produkt';

  @override
  String get prices_barcode_search_none_yet => 'Ingen produkt ännu';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Letar efter $barcode';
  }

  @override
  String get prices_barcode_enter => 'Ange streckkoden';

  @override
  String get prices_category_enter => 'Artikel utan streckkod';

  @override
  String get prices_per_kilogram => 'Pris per kilogram';

  @override
  String get prices_per_unit => 'Pris per enhet';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / enhet';

  @override
  String get prices_category_mandatory => 'Obligatorisk';

  @override
  String get prices_category_optional => 'Frivillig';

  @override
  String get prices_category_error_mandatory => 'Kategorin är obligatorisk';

  @override
  String get prices_barcode_reader_action => 'Streckkodsläsare';

  @override
  String get prices_view_prices => 'Visa priserna';

  @override
  String get prices_list_title => 'Prislista';

  @override
  String get prices_list_count => 'Antal\npriser';

  @override
  String get prices_list_add_new_price => 'Lägg till ett nytt pris\n';

  @override
  String get prices_list_empty_title => 'Inget pris än!';

  @override
  String get prices_list_empty_subtitle =>
      'Bli först med att lägga till en:\nGenom att skanna ett **kvitto** eller en **prislapp**!';

  @override
  String get prices_entry_shop_not_found => 'Okänd butik';

  @override
  String prices_entry_menu_title(String user) {
    return 'Prisinmatning från \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Se alla priser för den här produkten';

  @override
  String get prices_entry_menu_open_proof => 'Se bevis';

  @override
  String get prices_entry_menu_my_prices => 'Se mina andra priser';

  @override
  String get prices_entry_menu_author_prices =>
      'Se andra priser av författaren';

  @override
  String get prices_entry_menu_shop_prices => 'Se andra priser från butiken';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count priser',
      one: '1 pris',
    );
    return '$_temp0 för $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Alla $count priser',
      one: 'Endast ett pris',
      zero: 'Inget pris ännu',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Senaste $pageSize priser (totalt: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Pris: $price / Butik: \"$location\" / Publicerad $date av \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Öppna bevis för \"$user\"';
  }

  @override
  String get prices_open_proof => 'Öppet prisbevis';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Alla $count bevis',
      one: 'Endast ett bevis',
      zero: 'Inget bevis ännu',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Senaste $pageSize bevisen (totalt: $total)';
  }

  @override
  String get prices_users_empty_title => 'Ingen bidragsgivare än!';

  @override
  String get prices_users_empty_explanation =>
      'Var först med att lägga till ett pris!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Topp $pageSize bidragsgivare (totalt: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Ingen butik än!';

  @override
  String get prices_locations_empty_explanation =>
      'Var först med att lägga till ett pris!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Topp $pageSize platser (totalt: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bevis',
      one: 'Ett bevis',
      zero: 'Inget bevis',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkter',
      one: 'En produkt',
      zero: 'Ingen produkt',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count användare',
      one: 'En användare',
      zero: 'Ingen användare',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count priser',
      one: 'Ett pris',
      zero: 'Inget pris',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Pris tidigare tillagt';

  @override
  String get prices_amount_subtitle => 'Belopp';

  @override
  String get prices_amount_is_discounted => 'Är rabatterad?';

  @override
  String get prices_amount_price_normal => 'Pris';

  @override
  String get prices_amount_price_discounted => 'Rabatterat pris';

  @override
  String get prices_amount_price_not_discounted => 'Ursprungspris';

  @override
  String get prices_amount_no_product => 'En produkt saknas!';

  @override
  String get prices_amount_price_incorrect => 'Felaktigt värde';

  @override
  String get prices_amount_price_mandatory => 'Obligatoriskt värde';

  @override
  String get prices_currency_subtitle => 'Valuta';

  @override
  String get prices_date_subtitle => 'Datum';

  @override
  String get prices_location_subtitle => 'Handla';

  @override
  String get prices_location_find => 'Hitta en butik';

  @override
  String get prices_location_mandatory => 'Du måste välja en butik!';

  @override
  String get prices_location_search_broader =>
      'Hittade du inte det du sökte? Nu försöker vi med en bredare sökning!';

  @override
  String get prices_proof_subtitle => 'Bevis';

  @override
  String get prices_proof_empty_title => 'Inga bevis än!';

  @override
  String get prices_proof_empty_explanation =>
      'Börja med att lägga till ett foto på ett **kvitto** eller en **prislapp**!';

  @override
  String get prices_proof_find => 'Välj ett bevis';

  @override
  String get prices_proof_change => 'Ändra bevis';

  @override
  String get prices_proof_receipt => 'Kvitto';

  @override
  String get prices_proof_price_tag => 'Prislapp';

  @override
  String get prices_proof_mandatory => 'Du måste välja ett bevis!';

  @override
  String get prices_add_validation_error => 'Valideringsfel';

  @override
  String get prices_privacy_warning_title => 'Sekretessvarning';

  @override
  String get prices_unknown_product => 'Okänd produkt';

  @override
  String get prices_privacy_warning_main_message =>
      'Priserna **kommer att vara offentliga**, tillsammans med butiken de hänvisar till.\n\nDet kan göra det möjligt för personer som känner till din Open Food Facts-pseudonym att:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Gissa i vilket område du bor';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Vet vad du köper';

  @override
  String get prices_privacy_warning_sub_message =>
      'Om du känner dig osäker på det, vänligen byt din pseudonym eller skapa ett nytt Open Food Facts-konto och logga in i appen med det.';

  @override
  String get i_refuse => 'Jag vägrar';

  @override
  String get i_accept => 'Jag accepterar';

  @override
  String get prices_currency_change_proposal_title => 'Ändra valutan?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Din nuvarande valuta är **$currency**. Vill du ändra den till **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Ja, använd $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nej, behåll $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Klar';

  @override
  String get dev_mode_section_server => 'Serverkonfiguration';

  @override
  String get dev_mode_section_news => 'Konfiguration av nyhetsleverantör';

  @override
  String get dev_mode_section_product_page => 'Produktsida';

  @override
  String get dev_mode_section_ui => 'Användargränssnitt';

  @override
  String get dev_mode_section_experimental_features =>
      'Experimentella funktioner';

  @override
  String get dev_mode_hide_environmental_score_title => 'Exkludera grön poäng';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Använd en stavningskontroll för OCR-skärmar';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredienser och förpackning)';

  @override
  String get dev_mode_reset_app_language_title => 'Återställ appens språk';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Lägg till kort';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Växla mellan prices.openfoodfacts.org (PROD) och testmiljön';

  @override
  String get search_history_item_edit_tooltip =>
      'Återanvänd och redigera den här sökningen';

  @override
  String get search_history_item_remove_tooltip => 'Ta bort';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Du har laddat ner alla $totalSize produkter.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Ladda ner $count fler produkter\nHar redan laddats ner $downloaded av $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Din sökning av $search pågår.\n\nVänta några sekunder…';
  }

  @override
  String get user_search_contributor_title => 'Produkter jag har lagt till';

  @override
  String get user_search_informer_title => 'Produkter jag redigerade';

  @override
  String get user_search_photographer_title => 'Produkter jag fotograferade';

  @override
  String get user_search_to_be_completed_title =>
      'Mina produkter som ska färdigställas';

  @override
  String get user_search_prices_title => 'Mina priser';

  @override
  String get user_search_proofs_title => 'Mina bevis';

  @override
  String get user_search_proof_title => 'Mitt bevis';

  @override
  String search_proof_title(String user) {
    return 'Bevis från \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Bidragsgivarpriser: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Senast tillagda priser';

  @override
  String get all_search_prices_top_user_title =>
      'De största prisbidragsgivarna';

  @override
  String get all_search_prices_top_location_title => 'Butiker med högst priser';

  @override
  String get prices_contribution_assistant => 'Prisbidragsassistent';

  @override
  String get prices_validation_assistant => 'Prisvalideringsassistent';

  @override
  String get prices_challenges_page => 'Utmaningar';

  @override
  String get prices_multiple_proof_addition_system => 'Lägg till flera bevis';

  @override
  String get all_search_prices_top_location_single_title => 'Priser i en butik';

  @override
  String get all_search_prices_top_product_title => 'Produkter med högst pris';

  @override
  String get all_search_to_be_completed_title =>
      'Alla produkter som ska färdigställas';

  @override
  String get categorize_products_country_title =>
      'Hjälp med att kategorisera produkter i ditt land';

  @override
  String get edit_product_action_retake_picture => 'Ta om foto';

  @override
  String get edit_product_action_take_picture => 'Ta foto';

  @override
  String get edit_product_action_confirm => 'Bekräfta';

  @override
  String get signup_page_terms_of_use_line1 => 'Jag godkänner Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => 'användarvillkor och bidrag';

  @override
  String get analytics_consent_image_semantic_label => 'Analytics-ikon';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Allvarligt fel: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Allvarligt fel: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Komplettera grundläggande uppgifter';

  @override
  String get edit_photo_button_label => 'Redigera';

  @override
  String get edit_photo_unselect_button_label => 'Avmarkera foto';

  @override
  String get edit_photo_select_existing_button_label =>
      'Välj en befintlig bild';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Välj en bild genom att klicka på den';

  @override
  String get edit_photo_select_existing_download_label =>
      'Hämtar befintliga bilder…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Det finns inga tidigare uppladdade bilder relaterade till den här produkten.';

  @override
  String get edit_photo_language_not_this_one =>
      'Ingen bild på det språket ännu';

  @override
  String get edit_photo_language_none => 'Ingen bild ännu';

  @override
  String get category_picker_screen_title => 'Kategorier';

  @override
  String get basic_details => 'Grundläggande detaljer';

  @override
  String get product_name => 'Produktnamn';

  @override
  String get product_names => 'Produktnamn';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Lägg till en ny översättning';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Innan du validerar, se till att du bara lägger till en översättning **om språket finns med på förpackningen**';

  @override
  String get add_basic_details_product_name_open_photo => 'Se framsidans foto';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Ta ett foto framifrån';

  @override
  String get add_basic_details_product_name_hint =>
      'Ange produktens namn (t.ex.: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Ändra standardspråk?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Vill du att produktens standardspråk ska vara inställt på \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Bra exempel';

  @override
  String get explanation_section_bad_examples => 'Dåliga exempel';

  @override
  String get add_basic_details_product_name_help_title =>
      'God praxis: Produktnamn';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Produktnamnet är det **huvudnamn som är tryckt på förpackningen**. Det kan vara ett registrerat varumärke.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Obs:** Vänligen lägg inte till en översättning **om språket inte finns med på förpackningen**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomatketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Inkludera inte varumärket i namnet';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomatketchup **av Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Använd inte symbolerna ®, ™, © eller liknande';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count andra översättningar',
      one: '$count annan översättning',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Märke';

  @override
  String get brand_names => 'Varumärken';

  @override
  String get add_basic_details_brand_name_error => 'Vänligen ange varumärket';

  @override
  String get add_basic_details_brand_names_hint =>
      'Insatsvarumärken (t.ex. Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'God praxis: Varumärken';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Ange **alla produktens märken**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Huvudmärke';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Huvudmärket**, som vanligtvis visas tydligt på framsidan av förpackningen, ska **anges först**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Andra märken';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'När det säljs **av ett stort företag**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** säljs av **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'När den säljs med sitt varumärke **översatt till flera språk**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** skrivs ibland **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Kvantitet och vikt';

  @override
  String get add_basic_details_quantity_hint =>
      'Ange vikten och vid behov mängden (t.ex.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'God praxis: Kvantitet';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Kopiera värdet som anges på produkten och **glöm inte enheterna**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** eller **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (för 6 ägg)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(för en produkt med 3 lådor, vardera om 150 g)';

  @override
  String get barcode => 'Streckkod';

  @override
  String barcode_barcode(String barcode) {
    return 'Streckkod: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Ogiltig streckkod';

  @override
  String get basic_details_add_success =>
      'Grundläggande detaljer har lagts till';

  @override
  String get basic_details_add_error =>
      'Det gick inte att lägga till grundläggande information. Försök igen om en stund.';

  @override
  String get clear_search => 'Rensa din sökning';

  @override
  String get confirm_clear =>
      'Du håller på att rensa hela din historik: är du säker på att du vill fortsätta?';

  @override
  String get alert_clear_selected_user_list =>
      'Du är på väg att rensa valda objekt i din historik';

  @override
  String get confirm_clear_selected_user_list =>
      'Är du säker på att du vill fortsätta?';

  @override
  String get alert_select_items_to_clear =>
      'Välj ett eller flera objekt att rensa';

  @override
  String confirm_clear_user_list(String name) {
    return 'Du håller på att rensa den här listan ($name): är du säker på att du vill fortsätta?';
  }

  @override
  String get confirm_delete_user_list_title => 'Ta bort listan?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Du håller på att ta bort listan \"$name\".\nÄr du säker på att du vill fortsätta?';
  }

  @override
  String get confirm_delete_user_list_button => 'Ja, jag bekräftar';

  @override
  String importance_label(String name, String id) {
    return '$name viktighet: $id';
  }

  @override
  String get user_list_all_title => 'Listor';

  @override
  String get user_list_all_empty => 'Skapa din första lista';

  @override
  String get product_list_select => 'Välj en lista';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkter',
      one: 'En produkt',
      zero: 'Tom lista',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Lägg till lista';

  @override
  String get open_food_preferences_tooltip => 'Redigera dina matpreferenser';

  @override
  String get add_photo_button_label => 'Lägg till foto';

  @override
  String get add_packaging_photo_button_label =>
      'Ta foton av all förpacknings-/återvinningsinformation';

  @override
  String get add_origin_photo_button_label =>
      'Ta foton av all ursprungsinformation';

  @override
  String get add_emb_photo_button_label =>
      'Ta foton av all spårbarhetskodinformation';

  @override
  String get add_label_photo_button_label =>
      'Ta foton av all etikett- och certifieringsinformation';

  @override
  String get choose_image_source_title => 'Välj bildkälla';

  @override
  String get choose_image_source_body => 'Välj en bildkälla';

  @override
  String get gallery_source_label => 'Galleri';

  @override
  String get gallery_source_access_denied_dialog_title => 'Åtkomst nekad';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Tyvärr kan appen inte komma åt ditt galleri, eftersom du tidigare har nekat behörighet.\n\nGå till appinställningarna i din telefon Inställningar -> Foton';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Öppna inställningarna';

  @override
  String get share => 'Dela';

  @override
  String share_product_text(String url) {
    return 'Ta en titt på den här produkten på Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Ta en titt på den här produkten på Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Ta en titt på den här produkten på Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Ta en titt på den här produkten på Öppna produktfakta: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Ta en titt på min produktlista på Open Food Facts: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Ta en bild';

  @override
  String get choose_from_gallery => 'Välj från galleri';

  @override
  String get image_upload_queued =>
      'Bilden kommer att laddas upp i bakgrunden så snart som möjligt.';

  @override
  String get add_price_queued =>
      'Priset skickas till servern så snart som möjligt.';

  @override
  String get background_task_title_full_refresh =>
      'Startar uppdateringen av alla lokalt lagrade produkter';

  @override
  String get background_task_title_folksonomy =>
      'Börjar utföra serveråtgärderna för folksonomy-uppdateringar som lagras lokalt';

  @override
  String get background_task_title_top_n =>
      'Startar nedladdningen av de mest populära produkterna';

  @override
  String get expand_nutrition_facts => 'Expandera näringsfaktatabellen';

  @override
  String get expand_nutrition_facts_body => 'Håll näringsfaktatabellen utökad';

  @override
  String get expand_ingredients => 'Expandera ingredienser';

  @override
  String get expand_ingredients_body => 'Håll ingredienspanelen utökad';

  @override
  String get no_internet_connection => 'Ingen internetanslutning';

  @override
  String get world_results_label => 'Hela världen';

  @override
  String get world_results_action => 'Utöka din sökning till världen';

  @override
  String get copy_to_clipboard => 'Kopiera';

  @override
  String get paste_from_clipboard => 'Klistra in från urklipp';

  @override
  String get no_data_available_in_clipboard =>
      'Ingen data finns tillgänglig i ditt urklipp';

  @override
  String get clipboard_barcode_copy => 'Kopiera streckkoden till urklipp';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Streckkoden $barcode kopierad till urklipp!';
  }

  @override
  String get open_product_website => 'Öppna den här produkten på webbplatsen';

  @override
  String get language_picker_label => 'Ditt språk';

  @override
  String get country_picker_label => 'Ditt land';

  @override
  String get currency_picker_label => 'Din valuta';

  @override
  String get help_with_openfoodfacts => 'Hjälp med OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produkten kommer att uppdateras i bakgrunden så snart som möjligt.';

  @override
  String get no_email_client_available_dialog_title => 'Inga e-postappar!';

  @override
  String get no_email_client_available_dialog_content =>
      'Vänligen skicka ett e-postmeddelande manuellt till mobile@openfoodfacts.org';

  @override
  String get all_images => 'Alla bilder';

  @override
  String get selected_images => 'Valda bilder';

  @override
  String get product_card_remove_product_tooltip => 'Ta bort produkt';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Ny streckkod skannad: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Ta bort alla produkter från karusellen';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Skanna minst två produkter för att jämföra dem';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Klicka för att jämföra de produkter du har skannat';

  @override
  String get scan_product_loading => 'Du har skannat\nstreckkoden:';

  @override
  String get scan_product_loading_initial =>
      'Vi letar efter den här produkten!\nVänta några sekunder…';

  @override
  String get scan_product_loading_long_request =>
      'Vi letar fortfarande efter den här produkten!\nTycker du att det tar lång tid att ladda? Tycker vi också…';

  @override
  String get scan_product_loading_unresponsive =>
      'Vi letar fortfarande efter den här produkten.\nVill du starta om sökningen?';

  @override
  String get scan_product_loading_restart_button => 'Starta om sökning';

  @override
  String get portion_calculator_description =>
      'Beräkna näringsfakta för en specifik mängd';

  @override
  String get portion_calculator_hint => 'Kvantitet i';

  @override
  String get portion_calculator_accessibility =>
      'Ange en kvantitet för att beräkna näringsfakta';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Ange en kvantitet mellan $min och $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Data saknas. Beräkningen kunde inte utföras.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Näringsinformation för $grams g (eller ml)';
  }

  @override
  String get offline_data => 'Offlinedata';

  @override
  String get ocr_image_upload_instruction =>
      'Ladda upp en bild för att automatiskt extrahera informationen den innehåller.';

  @override
  String get upload_image => 'Ladda upp foto';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Misslyckades med att ladda ner bilden';

  @override
  String get image_edit_url_error =>
      'Det gick inte att redigera bilden eftersom bildens URL inte var angiven.';

  @override
  String get user_picture_source_remember => 'Kom ihåg mitt val';

  @override
  String get user_picture_source_ask => 'Fråga varje gång';

  @override
  String get robotoff_continue => 'Fortsätt';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count frågor',
      one: 'fråga',
    );
    return 'Nästa $_temp0';
  }

  @override
  String get show_password => 'Visa lösenord';

  @override
  String get owner_field_info_title => 'Producenten tillhandahöll värden';

  @override
  String get owner_field_info_message =>
      'Med den logotypen framhäver vi data som tillhandahålls av producenten, och som kanske inte kan redigeras.';

  @override
  String get owner_field_info_close_button => 'Stäng denna information';

  @override
  String get owner_field_image =>
      'Denna bild tillhandahålls av producenten. Den är eventuellt inte redigerbar.';

  @override
  String get edit_packagings_title => 'Förpackningskomponenter';

  @override
  String get edit_packagings_element_add =>
      'Lägg till en förpackningskomponent';

  @override
  String get edit_packagings_completed => 'Förpackningen är komplett';

  @override
  String edit_packagings_element_title(int index) {
    return 'Förpackningskomponent #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Antal enheter';

  @override
  String get edit_packagings_element_hint_units =>
      'Ange antalet förpackningsenheter av samma form och material som produkten innehåller.';

  @override
  String get edit_packagings_element_field_shape => 'Form';

  @override
  String get edit_packagings_element_hint_shape =>
      'Ange formens namn som anges i återvinningsinstruktionerna om de är tillgängliga, eller välj en form.';

  @override
  String get edit_packagings_element_example_shape => 'Flaska';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Ange det specifika materialet om det kan fastställas (en materialkod inuti en triangel finns ofta på förpackningsdelar), eller ett generiskt material (till exempel plast eller metall) om du är osäker.';

  @override
  String get edit_packagings_element_example_material => 'Glas';

  @override
  String get edit_packagings_element_field_recycling =>
      'Återvinningsinstruktion';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Ange endast återvinningsinstruktioner om de finns listade på produkten.';

  @override
  String get edit_packagings_element_example_recycling => 'Återvinna';

  @override
  String get edit_packagings_element_field_quantity =>
      'Netto kvantitet produkt per enhet';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Ange nettovikt eller nettovolym och ange enhet (till exempel g eller ml).';

  @override
  String get edit_packagings_element_field_weight => 'Vikt av en tom enhet (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Ta bort eventuell matrester och tvätta och torka förpackningsdelen innan vägning. Använd om möjligt en våg med 0,1 g eller 0,01 g noggrannhet.';

  @override
  String get background_task_title => 'Väntande bidrag';

  @override
  String get background_task_subtitle =>
      'Dina bidrag sparas automatiskt på vår server, men inte alltid i realtid.';

  @override
  String get background_task_list_empty => 'Inga väntande bakgrundsuppgifter';

  @override
  String get background_task_error_server_time_out => 'Server-timeout';

  @override
  String get background_task_error_no_internet =>
      'Internetanslutningsfel. Försök senare.';

  @override
  String get background_task_operation_unknown => 'okänd operationstyp';

  @override
  String get background_task_operation_details => 'detaljerade ändringar';

  @override
  String get background_task_operation_image => 'fotouppladdning';

  @override
  String get background_task_operation_refresh =>
      'uppdatering försenad efter fotouppladdning';

  @override
  String get background_task_run_started => 'började';

  @override
  String get background_task_run_not_started => 'inte påbörjad än';

  @override
  String get background_task_run_to_be_deleted => 'kommer att tas bort';

  @override
  String get background_task_question_stop =>
      'Vill du stoppa den uppgiften så snart som möjligt?';

  @override
  String get feed_back => 'Feedback';

  @override
  String get undo => 'Ångra';

  @override
  String get copy_email_to_clip_board => 'Kopiera e-post till urklipp';

  @override
  String get please_send_us_an_email_to =>
      'Vänligen skicka oss ett e-postmeddelande manuellt till';

  @override
  String get email_copied_to_clip_board =>
      'E-postmeddelandet kopierat till urklipp!';

  @override
  String get select_accent_color => 'Välj accentfärg';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Blå';

  @override
  String get color_cyan => 'Turkos';

  @override
  String get color_green => 'Grön';

  @override
  String get color_light_brown => 'Standard';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Orange';

  @override
  String get color_pink => 'Rosa';

  @override
  String get color_red => 'Röd';

  @override
  String get color_rust => 'Rost';

  @override
  String get color_teal => 'Kricka';

  @override
  String get text_contrast_mode => 'Textkontrast';

  @override
  String get contrast_high => 'Hög';

  @override
  String get contrast_medium => 'Medium';

  @override
  String get contrast_low => 'Låg';

  @override
  String get product_refresher_internet_not_found =>
      'Produkten kunde inte hittas!';

  @override
  String get product_refresher_internet_not_connected =>
      'Du är inte ansluten till internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server nere ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Serverfel ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produkten kunde inte hittas!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'En produkt med följande streckkod finns inte i vår databas: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Ingen internetanslutning!';

  @override
  String get product_loader_network_error_message =>
      'Kontrollera att din smartphone är ansluten till ett WiFi-nätverk eller att mobildata är aktiverat';

  @override
  String get page_not_found_title => 'Sidan hittades inte!';

  @override
  String get page_not_found_button => 'Gå tillbaka till startsidan';

  @override
  String get download_data => 'Ladda ned data';

  @override
  String get download_top_products =>
      'Ladda ner de 1000 bästa produkterna i ditt land för omedelbar skanning';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkterna',
    );
    return 'Ladda ner de bästa $_temp0 i ditt land för omedelbar skanning';
  }

  @override
  String get download_in_progress => 'Laddar ner data\nDet kan ta ett tag';

  @override
  String downloaded_products(int num) {
    return '$num produkter tillagda';
  }

  @override
  String get update_offline_data => 'Uppdatera offlineproduktdata';

  @override
  String get update_local_database_sub =>
      'Uppdatera den lokala produktdatabasen med den senaste informationen från Open Food Facts';

  @override
  String get clear_local_database => 'Rensa offline produktdata';

  @override
  String get clear_local_database_sub =>
      'Rensa all lokal produktdata från din app för att frigöra utrymme';

  @override
  String deleted_products(int num) {
    return '$num produkter raderade';
  }

  @override
  String get loading => 'Laddar…';

  @override
  String get know_more => 'Lär dig mer';

  @override
  String get offline_data_desc => 'Klicka för att läsa mer om offlinedata';

  @override
  String get offline_product_data_title => 'Produktdata offline';

  @override
  String available_for_download(int num) {
    return '$num produkter tillgängliga för omedelbar skanning';
  }

  @override
  String get country_selector_title => 'Välj ditt land:';

  @override
  String get currency_selector_title => 'Välj din valuta:';

  @override
  String get language_selector_title => 'Välj ditt språk:';

  @override
  String get language_selector_section_selected => 'Valda språk';

  @override
  String get language_selector_section_frequently_used => 'Ofta använda';

  @override
  String get action_delete_list => 'Radera';

  @override
  String get action_change_list => 'Ändra den aktuella listan';

  @override
  String get product_list_create => 'Skapa';

  @override
  String get product_list_create_tooltip => 'Skapa en ny lista';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Ny beräkning)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Ny beräkning)';

  @override
  String get nutriscore_unknown => 'Okänt Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Okänt Nutri-Score (ny beräkning)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score är inte tillämpligt';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score är inte tillämpligt (ny beräkning)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Grön poäng A';

  @override
  String get environmental_score_b_new => 'Grönpoäng B';

  @override
  String get environmental_score_c_new => 'Grönpoäng C';

  @override
  String get environmental_score_d_new => 'Grönpoäng D';

  @override
  String get environmental_score_e_new => 'Grön-poäng E';

  @override
  String get environmental_score_unknown_new => 'Okänd Green-Score';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score är inte tillämpligt';

  @override
  String get nova_group_generic_new =>
      'Ultraprocessade livsmedel - NOVA-grupper';

  @override
  String get nova_group_1 => 'NOVA Grupp 1';

  @override
  String get nova_group_2 => 'NOVA Grupp 2';

  @override
  String get nova_group_3 => 'NOVA Grupp 3';

  @override
  String get nova_group_4 => 'NOVA Grupp 4';

  @override
  String get nova_group_unknown => 'Okänd NOVA-grupp';

  @override
  String get nutrition_facts => 'Näringsnivåer';

  @override
  String get faq_title_partners =>
      'Partners och beskyddare av icke-statliga organisationer';

  @override
  String get faq_title_vision =>
      'Open Food Facts vision, uppdrag, värderingar och program';

  @override
  String get faq_title_install_beauty =>
      'Installera Open Beauty Facts för att skapa en kosmetisk databas';

  @override
  String get faq_title_install_pet =>
      'Installera Open Pet Food Facts för att skapa en databas med djurfoder';

  @override
  String get faq_title_install_product =>
      'Installera Open Products Facts för att skapa en produktdatabas som förlänger objektens livslängd.';

  @override
  String get faq_nutriscore_nutriscore =>
      'Ny beräkning av Nutri-Score: vad är nytt?';

  @override
  String get contact_title_pro_page =>
      'Proffs? Importera dina produkter i Open Food Facts';

  @override
  String get contact_title_pro_email => 'Producentkontakt';

  @override
  String get contact_title_press_page => 'Presssida';

  @override
  String get contact_title_press_email => 'Presskontakt';

  @override
  String get contact_title_newsletter => 'Prenumerera på vårt nyhetsbrev';

  @override
  String get contact_title_calendar => 'Prenumerera på vår communitykalender';

  @override
  String get hunger_games_loading_line1 => 'Vänligen ge oss några sekunder…';

  @override
  String get hunger_games_loading_line2 => 'Vi laddar ner frågorna!';

  @override
  String get hunger_games_error_label =>
      'Åh nej! Något gick fel och vi kunde inte ladda frågorna.';

  @override
  String get hunger_games_error_retry_button => 'Låt oss försöka igen!';

  @override
  String get reorder_attribute_action => 'Ändra ordning på attributen';

  @override
  String get link_cant_be_opened =>
      'Den här länken kan inte öppnas på din enhet. Kontrollera att du har en webbläsare installerad.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Detaljer för $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Detaljer för $pageName med $productName';
  }

  @override
  String get guide_title => 'Handledning';

  @override
  String get guide_share_label => 'Dela';

  @override
  String get guide_nutriscore_v2_title =>
      'Nutri-Score utvecklas: förklaringar!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Vad är Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Nutri-Score är en logotyp som syftar till att informera dig om **näringskvaliteten på livsmedel**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'Färgkoden varierar från mörkgrön (**A**) för de **hälsosammaste** produkterna till mörkröd (**E**) för de **mindre hälsosamma**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'Nutri-Score A-logotypen';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Varför utvecklas Nutri-Score?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'Nutri-Score-formeln **utvecklas** för att ge bättre rekommendationer:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Bättre utvärdera alla drycker';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'De jämförande noteringarna av **mjölk**, **mjölkdrycker** med tillsatt socker och **grönsaksdrycker** var bättre differentierade i den nya algoritmen.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Bättre ranking av drycker';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      '**Sockerhalten** beaktas bättre och gynnar **lågt sötade** drycker.\\n**Sötningsmedel kommer också att bestraffas**: dietläsk kommer att nedgraderas från ett B-betyg till mellan C och E. Vatten förblir den rekommenderade drycken.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt och socker bestraffas';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Produkter som är **för söta** eller **för salta** kommer att få **betyget ytterligare nedgraderat**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarki inom oljor och fiskar';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'Betyget för viss **fet fisk** och **oljor rika på bra fetter** kommer att förbättras.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Begränsa rött kött';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Konsumtionen av **rött kött bör begränsas**. Det är därför **fjäderfä kommer att rankas jämförelsevis bättre**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Hur skiljer man på gammal Nutri-Score och ny beräkning?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'Från och med nu kan logotypen visa omnämnandet \"**Ny beräkning**\" för att förtydliga att detta verkligen är den nya beräkningen.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Logotypen för nya Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Var hittar jag den nya Nutri-Score-beräkningen?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score tillämpas i sju länder: Frankrike, Tyskland, Belgien, Spanien, Luxemburg, Nederländerna och Schweiz.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Tillverkare har högst **2 år** efter undertecknandet av dekretet **på sig** att ersätta** den gamla beräkningen med den nya.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Utan att vänta **finner du redan i OpenFoodFacts-applikationen**, den nya beräkningen, inklusive om tillverkarna inte har uppdaterat poängen.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Vad förändras inte';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Nutri-Score är en poäng utformad för att **mäta näringskvalitet**. Det är ett **komplement till NOVA-gruppen** om **ultraprocessade livsmedel** (finns även detta i applikationen).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'För tillverkarna är visning av Nutri-Score **fortsatt valfri**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Vad är den gröna poängen?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score är en logotyp som syftar till att informera dig om **matens miljöpåverkan**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Färgkoden varierar från mörkgrön (**A+**) för de **minst påverkande** produkterna till mörkröd (**F**) för de **mest påverkande** produkterna.';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score-logotyperna';

  @override
  String get guide_greenscore_lca_title => 'Kärnan: Livscykelanalys (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'En vetenskaplig utvärdering av livsmedelskategorier';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'För varje produktkategori fastställs ett **riktmärke**-resultat med hjälp av data från miljödatabasen Agribalyse (utformad av ADEME och INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Livscykelanalys** är en standardiserad bedömningsmetod för att genomföra en miljöbedömning i flera steg och med flera kriterier.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Den mäter:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 produktionssteg';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Jordbruk';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Bearbetar';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Förpackning';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transport';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Konsumtion';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indikatorer för miljöpåverkan';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Klimatförändringar/koldioxidavtryck';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Utarmning av ozonskiktet';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Joniserande strålning';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Landa';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Vatten- och energianvändning';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Luftföroreningar';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Marint och sötvatten (partiklar, försurning, övergödning)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Utarmning av resurser.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Bonusar och straffavgifter';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'För att belöna bättre produkter inom en kategori tillämpar vi sedan **bonusar och påföljder baserat på flera kriterier**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'Produktionssätt';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'En **bonus** ges till produkter som har en **officiell märkning, en märkning eller en certifiering som garanterar miljöfördelar** (ekologisk, rättvis handel, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Ingredients ursprung';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'En **bonus** delas ut baserat på ingrediensernas ursprung. Denna bonus tar hänsyn till **påverkan på transport** och även **miljöpolicyn** i varje producents land.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Utrotningshotade arter';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Produkter som innehåller ingredienser som har betydande negativa effekter på biologisk mångfald och ekosystem, såsom palmolja, vars produktion orsakar massiv avskogning, bestraffas.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Förpackning';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'En **straffavgift** beräknas för att ta hänsyn till **förpackningens cirkularitet** (användning av återvunnet råmaterial och återvinningsbarhet) och överförpackning.';

  @override
  String get guide_greenscore_transparency_title =>
      'Ett ökat behov av transparens för att bättre mäta och minska miljöpåverkan';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'För att korrekt beräkna Green-Score är det nödvändigt att ha **information som inte nödvändigtvis anges på förpackningen** (såsom ursprung och exakt procentandel av varje ingrediens) eller som sällan är tillgänglig i användbar form (såsom en lista över alla komponenter i förpackningen med exakt vilka typer av plast som används).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Medelvärden används när denna information ännu inte är tillgänglig**, men vi uppmanar nu alla att hjälpa oss att samla in denna information som kommer att vara mycket användbar för Green-Score men även för många andra användningsområden.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Hur kan medborgare hjälpa till?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Alla medborgare kan hjälpa oss att samla in och strukturera den information som finns på produkter eller som kan härledas från dem, såsom information om **förpackningar**: \"Mission Emballages\": en storskalig gemensam inventering av förpackningar för alla livsmedelsprodukter (på franska).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Hur tillverkare kan hjälpa till';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Tillverkare kan skicka sin information direkt till oss via vår kostnadsfria plattform för producenter.';

  @override
  String get guide_greenscore_better_product_title =>
      'Vilken produkt är bäst för planeten?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Det kan vara svårt att säga';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Att välja hållbar mat är en av de mest kraftfulla sakerna vi kan göra för klimatet, eftersom **vårt globala livsmedelssystem står för över en fjärdedel av alla utsläpp av växthusgaser**.\n(Källa: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Du har makten!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Den goda nyheten är att detta ger oss ett kraftfullt sätt att skapa förändring.\n**Var och en av oss äter cirka 1 000 måltider varje år**. Det är 1 000 möjligheter att **välja en bättre framtid för planeten**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Hjälper att ta ansvar och bestämma';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Att välja hållbar mat kan kännas komplicerat. Etiketter är förvirrande och information saknas ofta. Green-Score skapades för att göra det enkelt och ger dig en **tydlig**, **vetenskapsbaserad** och **transparent** miljöklassificering för livsmedelsprodukter, precis där du behöver den: när du handlar.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Genomskinlighet';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Till skillnad från proprietära etiketter är Green-Score-beräkningen **helt öppen** och kan **verifieras av vem som helst**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'Vad är ultraprocessing?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA-grupperna informerar dig om graden av livsmedelsbearbetning.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA-klassificeringen möjliggör kategorisering av livsmedel i **fyra grupper** baserat på deras **grad av industriell bearbetning** (minimalt bearbetade eller obearbetade livsmedel, kulinariska ingredienser, bearbetade livsmedel, ultrabearbetade livsmedel).';

  @override
  String get guide_nova_logos_caption => 'NOVA-logotyperna';

  @override
  String get guide_nova_groups_title => 'De 4 NOVA-grupperna';

  @override
  String get guide_nova_groups_intro =>
      'Det finns fyra NOVA-grupper, varav den problematiska är Grupp 4 - Ultraprocessade livsmedel.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimalt bearbetade eller obearbetade livsmedel';

  @override
  String get guide_nova_groups_arg1_text =>
      'Obearbetade (eller naturliga) livsmedel är de **ätbara delarna av växter** (frön, frukter, blad, stjälkar, rötter) **eller djur** (muskler, slaktbiprodukter, ägg, mjölk), såväl som svampar, alger och vatten, efter att ha separerats från naturen.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Bearbetade kulinariska ingredienser';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Halvfabrikat';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to Group 1** foods. processes include various preservation or cooking methods, and in the case of Breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified Versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. Ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. However, ultra-processed products also contain other sources of energy and nutrients not typically used in Culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Problemen med ultrabearbetning';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Extrem bearbetning av livsmedelsingredienser';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Många härrör från vidare bearbetning av livsmedelsbeståndsdelar, såsom hydrerade eller interesterifierade oljor, hydrolyserade proteiner, sojaproteinisolat, maltodextrin, invertsocker och majssirap med hög fruktoshalt.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Tillsatser som går utöver ren livsmedelssäkerhet';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Tillsatser i ultrabearbetade livsmedel inkluderar vissa som också används i bearbetade livsmedel, såsom konserveringsmedel, antioxidanter och stabiliseringsmedel. Klasser av tillsatser som endast finns i ultrabearbetade produkter inkluderar de som används **för att imitera eller förbättra livsmedels sensoriska egenskaper eller för att dölja obehagliga aspekter av slutprodukten**. Dessa tillsatser inkluderar färgämnen och andra färger, färgstabilisatorer; aromer, smakförstärkare, sötningsmedel utan socker; och processhjälpmedel såsom kolsyrare, fasthetsgivande, bulkmedel och anti-bulkmedel, skumdämpande, klumpförebyggande och glaseringsmedel, emulgeringsmedel, sekvestreringsmedel och fuktighetsbevarande medel.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Bearbetning du inte kan göra hemma';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**En mängd olika processsekvenser används** för att kombinera de vanligtvis många ingredienserna och skapa slutprodukten (därav \"ultraprocessad\"). Processerna inkluderar flera **utan inhemska motsvarigheter**, såsom hydrogenering och hydrolys, extrudering och gjutning, samt förbehandling för stekning.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'De rovgiriga och ekonomiska aspekterna av ultrabearbetning';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Det övergripande syftet med ultraprocessning är att skapa märkesvaror**, **bekväma** (hållbara, färdiga att konsumeras), **attraktiva** (hypervälsmakande) och **mycket lönsamma** (lågkostnadsingredienser) livsmedelsprodukter som är utformade för att ersätta alla andra livsmedelsgrupper. Ultraprocessade livsmedelsprodukter är vanligtvis attraktivt förpackade och marknadsförs intensivt.';

  @override
  String get guide_nova_explanations_arg5_title => 'En hälsorisk';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Sedan 2018 har de första sambanden mellan **konsumtion av ultraprocessade livsmedel och ökade risker för cancer, hjärt-kärlsjukdomar och diabetes** uppmärksammats med NutriNet-Santé. Idag bekräftar mer än 90 studier världen över dessa fynd.\nDe starkaste sambanden relaterar till **fetma, hjärt-kärlsjukdomsdödlighet och depressiva symtom**. Hos barn observeras effekterna främst på vikt och lipidobalanser.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Länder rekommenderar att de begränsas';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Vissa länder använder NOVA-grupperna för sina kostriktlinjer eller mål, till exempel:\n\n- **🇧🇷 Brasiliens kostriktlinjer **rekommenderar att begränsa konsumtionen** av bearbetade livsmedel och undvika ultrabearbetade livsmedel.\n\n- **🇫🇷 Frankrikes folkhälsopolitiska näringspolitiska mål för 2018-2022 syftar till att **minska konsumtionen av ultrabearbetade livsmedel i grupp 4 med 20 %**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Välkommen till Öppna Matfakta!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Vad är öppna matfakta?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts är en **samarbetsbaserad**, **gratis** och **öppen** databas med livsmedelsprodukter från hela världen.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Vi anser att alla ska ha tillgång till information om vad de äter. Genom att samla in data om ingredienser, allergener, näringsfakta med mera, **ger vi konsumenterna möjlighet att fatta välgrundade beslut** och driver livsmedelsindustrin **mot större transparens**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Funktioner i Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Få aviseringar om dina oönskade ingredienser';

  @override
  String get guide_open_food_facts_tips_title =>
      'Tips för att ta fantastiska foton';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Att inte göra';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Undvik skuggor och bländning.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Ingen suddig eller oskarp text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Beskär inte bort delar av texten.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Undvik hektiska bakgrunder.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Att göra';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Använd bra, jämn belysning.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Se till att texten är skarp och läsbar.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Spara hela ingredienslistan.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Förvara produkten på en plan yta.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Hjälp oss att bygga \"Matens Wikipedia\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Ett betyg på näringskvaliteten';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'En poäng för att undvika ultraprocessad mat';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Ett poäng för planeten';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-sv.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Välkommen till Öppna fakta om husdjursmat!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Vad är Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts utvidgar vårt uppdrag till våra pälsklingar! Det är en **databas med djurfoderprodukter för katter, hundar och andra sällskapsdjur**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Vi samlar information om **ingredienser**, **näringsanalys** och utfodringsriktlinjer för att hjälpa husdjursägare att välja det bästa fodret för sina djurs behov.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Funktioner hos Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Få aviseringar om dina oönskade ingredienser';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Är ditt husdjur allergiskt mot någon ingrediens? Du kan ställa in en lista över kosmetiska ingredienser som ska undvikas, direkt i appen!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips för att ta fantastiska foton';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Att inte göra';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Undvik skuggor och bländning.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Ingen suddig eller oskarp text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Beskär inte bort delar av texten.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Undvik hektiska bakgrunder.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Att göra';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Använd bra, jämn belysning.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Se till att texten är skarp och läsbar.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Spara hela ingredienslistan.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Förvara produkten på en plan yta.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'En anmärkning om poängsättning';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Att utveckla ett poängsystem för djurfoder **är inte en prioritet just nu**. Metodiken skulle vara komplex, eftersom näringsbehoven varierar kraftigt beroende på art, ålder och hälsotillstånd. Vi har ännu inte hittat något oberoende vetenskapligt team som kan utveckla ett sådant poängsystem.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-sv.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Välkommen till Öppna Skönhetsfakta!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Vad är Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts är en samarbetsdatabas med **kosmetiska produkter**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Vårt mål är att tyda ingredienslistor för att hjälpa dig att **förstå vad som finns i dina hygienprodukter**. Från fuktighetskrämer till smink samlar vi in data om ingredienser, allergener och förpackningar för att främja transparens inom kosmetikaindustrin.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Funktioner i Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Få aviseringar om dina oönskade ingredienser';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Är du allergisk mot någon ingrediens? Vill du undvika komedogena ämnen? Vill du undvika kontroversiella komponenter? Du kan ställa in en lista över kosmetiska ingredienser att undvika, direkt i appen!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips för att ta fantastiska foton';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Att inte göra';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Undvik skuggor och bländning.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Ingen suddig eller oskarp text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Beskär inte bort delar av texten.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Undvik hektiska bakgrunder.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Att göra';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Använd bra, jämn belysning.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Se till att texten är skarp och läsbar.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Spara hela ingredienslistan.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Ta så många bilder som behövs om flaskan är böjd.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Du kan behöva riva av etiketten för att se ingrediensförteckningen.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Förvara produkten på en plan yta.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'En anmärkning om poängsättning';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Till skillnad från livsmedelsprodukter har kosmetikaindustrin **inte ett universellt erkänt, statligt stödt poängsystem som Nutri-Score**. Ingrediensernas effekter kan vara mycket personliga och bero på hudtyp, allergier och individuella behov.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-sv.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices är ett projekt för att **samla in och dela priser på produkter runt om i världen**. Det är en offentligt tillgänglig datauppsättning som kan användas för forskning, analys och mer. Open Prices utvecklas och underhålls av Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Det finns för närvarande få företag som äger stora databaser med produktpriser på streckkodsnivå. Dessa priser är inte fritt tillgängliga, utan säljs till ett högt pris till privata aktörer, forskare och andra organisationer som har råd med dem.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Vi crowdsourcar en öppen källkodsdatauppsättning med priser**. Priser kan läggas till av användare via den här webbappen eller via den officiella mobilappen Open Food Facts. Återförsäljare eller tredjepartsappar kan också bidra genom att använda vårt API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Samla foton på prislappar i gångarna';

  @override
  String get guide_open_prices_how_arg2_title => 'Samla foton på kvitton';

  @override
  String get guide_open_prices_why_title => 'Varför gör Open Food Facts detta?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Prisinformation är av yttersta vikt för att förstå livsmedelssystem. Det är en nyckelfaktor för att förstå kostnaden för mat och för att främja hälsosammare kostvanor. Att öppna prisdata är ett sätt att göra det lättare för forskare, journalister och medborgare att **få en bättre förståelse för hur livsmedelspriserna varierar geografiskt och över tid**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Följ prisutvecklingen över tid';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Se **prisutvecklingen**: krympinflation, billiginflation, vi kan följa dem tillsammans!';

  @override
  String get guide_open_prices_why_arg2_title => 'Jämför priser nära dig';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Allt eftersom vi får fler priser kan du hitta **de billigaste butikerna i närheten**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Har du funderat på att hämta priser från återförsäljarnas webbplatser?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Prisskrapning är ett övervägt alternativ i en framtida version av Open Prices, men det skulle göras av Open Prices själva så att vi kan ha ett bevis på priset baserat på HTML-sidan.';

  @override
  String get guide_open_prices_retailers_title =>
      'Jag är en återförsäljare och jag vill bidra med priser. Hur kan jag göra det?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Du kan bidra med priser genom att använda vårt API.\nOm du vill bidra med priser i stor skala, vänligen kontakta oss på prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Välkommen till fakta om öppna produkter!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Vad är fakta om öppna produkter?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts är en massiv, öppen databas för **alla produkter med streckkod, som inte är livsmedel, kosmetika eller djurfoder**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Från **elektronik** till **leksaker**, och **kläder** till **städartiklar**, om det har en streckkod kan det läggas till. Det här projektet syftar till att skapa ett \"sakernas internet\" för vardagsföremål, vilket gör information om dem universellt tillgänglig.';

  @override
  String get guide_open_products_facts_features_title =>
      'Funktioner i öppna produktfakta';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts syftar till att ge konsumenter möjlighet att **förlänga livslängden på föremål** genom att tillhandahålla cirkulära lösningar för att underhålla, **reparera**, **återvinna** sina föremål eller ge dem en ny ägare.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Koldioxidavtryck för vissa produkter';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**CO2-påverkan** från den franska miljömyndigheten ADEME tillhandahåller **koldioxidpåverkan** för många kategorier, se till att kategorisera produkterna exakt.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparationsindex för många produkter';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'När ett franskt reparerbarhetsindex är tillgängligt visar vi det. Dessutom **kan du börja samla in variablerna med hjälp av Folksonomy Engine**; så att vi kan beräkna om det själva i framtiden, även i länder där det inte är tillgängligt.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Hitta sätt att donera/sälja vidare din produkt';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Vi tillhandahåller länkar till **tredjeparts cirkulärvänliga tjänster** som hjälper dig att få den typ av produkt du letar efter, som en begagnad produkt, för att vara mer skonsam mot planetens resurser.\nObservera att vi inte får betalt för att göra det, och att systemet bara fungerar som ett exempel för två webbplatser i Frankrike. Du kan hjälpa till att utöka detta system genom att dokumentera fler webbplatser på wikin.';

  @override
  String get guide_open_products_facts_information_title =>
      'Vilken information är användbar?';

  @override
  String get guide_open_products_facts_information_text =>
      'För ett så brett spektrum av objekt **är den data vi samlar in flexibel**. För att göra det **skapade vi Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'Folksonomy-motorn';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine är ett verktyg som hjälper dig att färdigställa produkter med relevanta egenskaper. Detta bidrar till att förbättra sök- och synbarhetsmöjligheter, men också till att beräkna och visa intressanta saker i framtiden.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Du kan lägga till valfria nycklar och värden, till exempel: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Du får automatiska förslag på möjliga egenskaper, och du är varmt välkommen att lägga till och dokumentera nya på dina favoritprodukter.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-sv.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Öppna matpreferenser';

  @override
  String get guide_coming_soon_button_title => 'Kommer snart';

  @override
  String get guide_learn_more_subtitle => 'Tryck för att läsa mer';

  @override
  String get preview_badge => 'Förhandsvisning';

  @override
  String get prices_feedback_form =>
      'Klicka här för att skicka oss din feedback om den här nya funktionen!';

  @override
  String get menu_button_list_actions => 'Välj en åtgärd';

  @override
  String get error_loading_photo => 'Fel vid laddning av foto';

  @override
  String get photo_viewer_action_use_picture_as => 'Använd som…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Använd den här bilden som…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Använd den här bilden som… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Detaljer';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Detaljer om detta foto';

  @override
  String get photo_viewer_details_title => 'Detaljer om fotot';

  @override
  String get photo_viewer_details_contributor_title => 'Medverkande';

  @override
  String get photo_viewer_details_size_title => 'Storlek';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixlar';
  }

  @override
  String get photo_viewer_details_date_title => 'Datum';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Kompatibel';

  @override
  String get user_lists_action_multi_select => 'Flerval';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Din kompatibilitetspoäng: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Framsidesbild';

  @override
  String get product_image_ingredients_accessibility_label => 'Ingrediensbild';

  @override
  String get product_image_nutrition_accessibility_label => 'Näringsbild';

  @override
  String get product_image_packaging_accessibility_label => 'Förpackningsbild';

  @override
  String get product_image_other_accessibility_label => 'Annan bild';

  @override
  String get product_image_outdated_message =>
      'Den här bilden kan vara föråldrad';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (den här bilden kan vara föråldrad)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (denna bild kan vara låst av producenten)';
  }

  @override
  String get product_image_error => 'Det gick inte att ladda bilden!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Det gick inte att ladda $type (nätverksfel?)';
  }

  @override
  String get product_page_image_no_image_available => 'Ingen\nbild!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Ingen bild tillgänglig för denna produkt';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Ändra ordning på eller dölj åtgärder';

  @override
  String get product_page_action_bar_setting_modal_title => 'Redigera åtgärder';

  @override
  String get product_page_action_bar_item_move_up => 'Flytta upp';

  @override
  String get product_page_action_bar_item_move_down => 'Flytta ner';

  @override
  String get product_page_action_bar_item_enable => 'Aktivera åtgärd';

  @override
  String get product_page_action_bar_item_disable => 'Inaktivera åtgärd';

  @override
  String get product_page_pending_operations_banner_title =>
      'Laddar upp dina redigeringar…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Informationen som visas på den här sidan **återspeglar ännu inte dina ändringar**.\nVänta några sekunder…';

  @override
  String get product_add_a_language => 'Lägg till ett språk';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Streckkod $barcode';
  }

  @override
  String get carousel_close_tooltip =>
      'Ta bort den här produkten från karusellen';

  @override
  String get carousel_unsupported_header => 'Streckkod stöds ej!';

  @override
  String get carousel_unsupported_title => 'Hoppsan!';

  @override
  String get carousel_unsupported_text =>
      'Streckkoden som skannas stöds inte av Open Food Facts!';

  @override
  String get carousel_error_header => 'Fel!';

  @override
  String get carousel_error_title => 'Det är en skam!';

  @override
  String get carousel_error_text_1 =>
      'Vi kunde inte ladda ner information om den här streckkoden:';

  @override
  String get carousel_error_text_2 =>
      'Kontrollera din internetanslutning eller klicka på den här knappen:';

  @override
  String get carousel_error_button => 'Försök igen';

  @override
  String get carousel_unknown_product_header => 'Okänd produkt';

  @override
  String get carousel_unknown_product_title =>
      'Grattis!\nDu har hittat __den sällsynta pärlan!__';

  @override
  String get carousel_unknown_product_text =>
      'Vår samarbetsdatabas innehåller mer än **3 miljoner produkter**, men denna streckkod finns inte: ';

  @override
  String get carousel_unknown_product_button => 'Lägg till den här produkten';

  @override
  String get carousel_loading_header => 'Laddar information...';

  @override
  String get carousel_loading_title =>
      'Du har just skannat en produkt med följande streckkod:';

  @override
  String get carousel_loading_text =>
      'Vi söker efter det i vår databas med mer än **3 miljoner produkter!**';

  @override
  String get product_type_subtitle_food => 'Grönsaker, frukt, fryst mat…';

  @override
  String get product_type_subtitle_beauty => 'Smink, tvålar, tandkrämer…';

  @override
  String get product_type_subtitle_pet_food => 'Mat för hundar, katter…';

  @override
  String get product_type_subtitle_product => 'Smartphones, möbler…';

  @override
  String get photo_field_front => 'Produktfoto';

  @override
  String get photo_field_ingredients => 'Foto på ingredienser';

  @override
  String get photo_field_nutrition => 'Näringsfoto';

  @override
  String get photo_field_packaging => 'Återvinningsinstruktioner foto';

  @override
  String get photo_already_exists => 'Det här fotot finns redan';

  @override
  String get photo_missing => 'Det här fotot saknas';

  @override
  String get date => 'Datum';

  @override
  String get photo_rotate_left => 'Rotera vänster';

  @override
  String get photo_rotate_right => 'Rotera höger';

  @override
  String get photo_undo_action => 'Ångra föregående åtgärd';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'En världskarta över $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap-bidragsgivare';

  @override
  String get not_applicable_short => 'N/A';

  @override
  String get knowledge_panel_warning_text => 'Varning';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Varför skiljer sig denna Nutri-Score från den på förpackningen?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Det finns två möjliga förklaringar:\nIngredienslistan och/eller näringsinformationen är inte uppdaterad.\n\nVi tillhandahåller den \"Ny beräkningen\" av Nutri-Score (eller V2). Kontrollera att du har rubriken \"Ny beräkning\" på förpackningen.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Kontrollera ingredienser';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Kontrollera näringsfakta';

  @override
  String url_not_supported(String url) {
    return 'Tyvärr kan vi inte öppna URL:en:\n$url';
  }

  @override
  String get product_list_export => 'Exportera';

  @override
  String get product_list_import => 'Importera';

  @override
  String get product_footer_action_barcode => 'Visa streckkod';

  @override
  String get product_footer_action_barcode_short => 'Streckkod';

  @override
  String get product_footer_action_open_website => 'Öppna webbplats';

  @override
  String get product_footer_action_report => 'Rapportera';

  @override
  String get product_footer_action_contributor_guide => 'Hjälp';

  @override
  String get product_footer_action_data_quality_tags => 'Datakvalitet';

  @override
  String get product_page_tab_for_me => 'För mig';

  @override
  String get product_page_tab_website => 'Webbplats';

  @override
  String get product_page_tab_prices => 'Priser';

  @override
  String get prices_explanation_card_title => 'Varför priser?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** är ett projekt för att samla in och dela priser på produkter runt om i världen 🌍. Open Prices utvecklas och underhålls av Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Läs mer';

  @override
  String get product_page_tab_folksonomy => 'Folksonomi';

  @override
  String get folksonomy_explanation_card_title =>
      'Vad är Folksonomys attribut?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Attribut är **nyckel-värde**-baserade.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Dessa egenskaper skapas och arkiveras av bidragsgivare för alla typer av användningsområden.';

  @override
  String get folksonomy_action_external_link_title => 'Öppna extern länk';

  @override
  String get folksonomy_action_external_link_warning =>
      'Externa länkar kan vara osäkra. Vill du verkligen besöka dem?';

  @override
  String get prices_products_empty_title => 'Inget pris tillgängligt';

  @override
  String get prices_products_empty_explanation => 'Bli först med att bidra!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Topp $pageSize produkter (totalt: $total)';
  }

  @override
  String get app_review_title => 'Gillar du den här appen?';

  @override
  String get app_review_low => 'Kunde göra bättre';

  @override
  String get app_review_medium => 'Inte dåligt';

  @override
  String get app_review_high => 'Jag älskar det!';

  @override
  String get app_review_feedback_modal_title =>
      'Hjälp oss att förbättra vår applikation';

  @override
  String get app_review_feedback_modal_content =>
      'Om du har några minuter över, kan du svara på det här formuläret så att **vi kan förbättra oss i framtida uppdateringar**:';

  @override
  String get app_review_feedback_modal_open_form => 'Svara på formuläret';

  @override
  String get app_review_feedback_modal_later => 'Fråga mig senare';

  @override
  String get nutrition_facts_extract_new =>
      'NYTT: Du kan automatiskt extrahera näringsämnena från bilden!';

  @override
  String get nutrition_facts_extract_button_text => 'Extrahera nu';

  @override
  String get nutrition_facts_extract_in_progress => 'Extraktion pågår…';

  @override
  String get nutrition_facts_extract_successful => 'Extraheringen lyckades';

  @override
  String get nutrition_facts_extract_failed =>
      'Misslyckades med att extrahera näringsämnen från bilden';

  @override
  String get prices_discount => 'Rabatt';

  @override
  String get prices_stats_statistics => 'Statistik';

  @override
  String get prices_stats_title => 'Prisstatistik';

  @override
  String get prices_stats_prices_section => 'Priser';

  @override
  String get prices_stats_products_section => 'Produkter';

  @override
  String get prices_stats_locations_section => 'Platser';

  @override
  String get prices_stats_proofs_section => 'Bevis';

  @override
  String get prices_stats_contributors_section => 'Bidragsgivare';

  @override
  String get prices_stats_experiments_section => 'Experiment';

  @override
  String get prices_stats_misc_section => 'Diverse';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'Med en streckkod';

  @override
  String get prices_stats_with_category => 'Med en kategori';

  @override
  String get prices_stats_with_discount => 'Med rabatt';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Konsumtion';

  @override
  String get prices_stats_with_price => 'Med ett pris';

  @override
  String get prices_stats_food => 'Mat';

  @override
  String get prices_stats_beauty => 'Skönhet';

  @override
  String get prices_stats_products => 'Produkter';

  @override
  String get prices_stats_pet_food => 'Djurmat';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Länder';

  @override
  String get prices_stats_price_tag => 'Prislapp';

  @override
  String get prices_stats_receipt => 'Kvitto';

  @override
  String get prices_stats_gdpr_request => 'GDPR-begäran';

  @override
  String get prices_stats_shop_import => 'Butiksimport';

  @override
  String get prices_stats_challenges => 'Utmaningar';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Valutor';

  @override
  String get prices_stats_years => 'År';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Webbplats';

  @override
  String get prices_stats_mobile_app => 'Mobilapp';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Övrigt';

  @override
  String get prices_stats_last_updated => 'Senast uppdaterad den';

  @override
  String get prices_stats_error => 'Ett fel uppstod när statistiken laddades.';

  @override
  String get product_edit_robotoff_question_answered => 'Fråga besvarad!';

  @override
  String get product_edit_robotoff_proof => 'Bevis';

  @override
  String get preferences_card_general => 'Allmänt';

  @override
  String get preferences_prices_title => 'Priser';

  @override
  String get preferences_prices_subtitle => 'Hantera dina prisinställningar';

  @override
  String get preferences_card_project => 'Projektet Open Food Facts';

  @override
  String get preferences_contribute_title => 'Bidra';

  @override
  String get preferences_my_contributions_title => 'Mina bidrag';

  @override
  String get preferences_my_stats_title => 'Min statistik';

  @override
  String get preferences_contribute_subtitle =>
      'Översätt, förbättra våra verktyg…';

  @override
  String get preferences_connect_title => 'Ansluta';

  @override
  String get preferences_connect_subtitle =>
      'Hör av dig, eller följ oss på sociala medier';

  @override
  String get preferences_support_title => 'Donera';

  @override
  String get preferences_support_subtitle =>
      'Hjälp oss att informera miljontals konsumenter runt om i världen';

  @override
  String get preferences_card_help => 'Hjälp och support';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle => 'Få svar på dina frågor';

  @override
  String get logged_out => 'Utloggad';

  @override
  String get preferences_app_bar_message =>
      'Tack för att du är en av våra medlemmar!';

  @override
  String get preferences_app_bar_products_modified => 'Produkter ändrade';

  @override
  String get preferences_app_bar_prices_added => 'Priser tillagda';

  @override
  String get preferences_app_bar_see_all_stats => 'Se all statistik';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Sök $provider efter \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Sök efter en inställning (t.ex. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Tillgänglighet: Visa emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Tillgänglighet: Ta bort färger';

  @override
  String get preferences_app_settings_products => 'Produkter';

  @override
  String get preferences_card_about => 'Om';

  @override
  String get preferences_legal_information_title => 'Juridisk information';

  @override
  String get preferences_legal_information_subtitle =>
      'Användarvillkor, integritetspolicy och mer';

  @override
  String get preferences_terms_of_use => 'Användningsvillkor';

  @override
  String get preferences_legal_mentions => 'Juridiska omnämnanden';

  @override
  String get preferences_legal_header =>
      'Open Food Facts är en databas med livsmedelsprodukter **skapad av alla, för alla**.\nDu kan använda den för att göra bättre matval, och eftersom det är **öppen data** kan vem som helst **återanvända den för vilket syfte som helst**.';

  @override
  String get preferences_privacy_policy => 'Integritetspolicy';

  @override
  String get preferences_licenses => 'Licenser';

  @override
  String get preferences_about_app_title => 'Om appen';

  @override
  String get preferences_about_app_subtitle =>
      'Teknisk information, utvecklarinformation och mer';

  @override
  String get preferences_card_information => 'Information';

  @override
  String get preferences_version_number_title => 'Versionsnummer';

  @override
  String get preferences_scanner_title => 'Scanner';

  @override
  String get preferences_app_store => 'Appbutik';

  @override
  String get preferences_app_system_settings => 'Systeminställningar';

  @override
  String get preferences_source_code => 'Åtkomst till källkoden';

  @override
  String get preferences_source_code_subtitle =>
      'Och börja göra skillnad för miljontals';

  @override
  String get preferences_add_prices => 'Lägg till priser';

  @override
  String get preferences_complete_products => 'Berätta för världen';

  @override
  String get preferences_tips => 'Tips';

  @override
  String get tips_discover_nutriscore => 'Upptäck den nya Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'På webbplatsen Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Hantera mitt konto';

  @override
  String get preferences_manage_account_tooltip => 'Hantera ditt konto';

  @override
  String get preferences_change_password_title => 'Ändra mitt lösenord';

  @override
  String get preferences_danger_zone => 'Riskzon';

  @override
  String get preferences_account_deletion_subtitle =>
      'Alla dina bidrag kommer att gå förlorade';

  @override
  String get preferences_contributions_title => 'Bidrag';

  @override
  String get preferences_dev_mode_app_settings_title => 'Appinställningar';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Mycket experimentellt sätt att skanna produkter offline';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Uppdatera alla produkter från servern';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Undvik att göra det om det inte är absolut nödvändigt';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demoläge';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Lägg till kort i skannern';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Lägger till 3 provprodukter i skannern';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'Folksonomy-värd';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Värd: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Tillgänglighetsexperiment';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Flerproduktsval för priser';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Användarbeställda kunskapspaneler';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Tillfällig åtkomst till platssökning';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Jämförelse sida vid sida för 2 eller 3 produkter';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Import av produktlista';

  @override
  String get preferences_faq_scores_methodologies_title => 'Poäng och metoder';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Upptäck hur Nutri-Score beräknas';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Upptäck de viktigaste förändringarna i metodiken';

  @override
  String get preferences_faq_discover_project_title => 'Upptäck projektet';

  @override
  String get preferences_faq_discover_off_title => 'Upptäck öppna matfakta';

  @override
  String get preferences_faq_discover_obf_title =>
      'Upptäck fakta om öppna skönhetsföremål';

  @override
  String get preferences_faq_discover_opff_title =>
      'Upptäck öppna fakta om husdjursmat';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Upptäck fakta om öppna produkter';

  @override
  String get preferences_faq_faq_title => 'Vanliga frågor - Vanliga frågor';

  @override
  String get preferences_faq_off_ngo_title => 'NGO:n Open Food Facts';

  @override
  String get preferences_about_information_title => 'Information';

  @override
  String get preferences_connect_community_updates_title =>
      'Få uppdateringar från communityn';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Håll dig uppdaterad med app- och communitynyheter';

  @override
  String get preferences_connect_community_calendar_title =>
      'Prenumerera på vår communitykalender';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Engagera dig genom att delta i ett av våra virtuella evenemang';

  @override
  String get preferences_connect_blog_title => 'Bloggen Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Få de senaste nyheterna, allt eftersom de händer';

  @override
  String get preferences_connect_community_help_title =>
      'Få hjälp från samhället';

  @override
  String get preferences_connect_improve_app_title =>
      'Hjälp oss att förbättra appen';

  @override
  String get preferences_connect_debug_info_title =>
      'Skicka felsökningsinformation till oss';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Skicka oss ett e-postmeddelande med detaljerad felsökningsinformation';

  @override
  String get preferences_connect_feedback_title =>
      'Skicka oss feedback om appen';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Hjälp till att forma appens framtid';

  @override
  String get preferences_connect_survey_title => 'Delta i appundersökningen';

  @override
  String get preferences_connect_survey_subtitle =>
      'Hjälp oss att förstå vad vi ska bygga härnäst';

  @override
  String get preferences_connect_professionals_title => 'yrkesverksamma';

  @override
  String get preferences_connect_pro_subtitle =>
      'Helt gratis, garanterar korrekt data för 500 appar och miljontals konsumenter. Självbetjäning, kompatibel med ditt PIM eller kalkylblad (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Kontakta oss för att komma igång';

  @override
  String get preferences_connect_press_title => 'Press';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Få allt material du behöver till din rapport';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Kontakta oss för pressförfrågningar eller för att berätta om din rapport';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Bli en aktiv volontär';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Utveckling, kommunikation, design… alla former av volontärarbete eller expertis är välkomna!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Upptäck några av de många sätt du kan bidra på';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Utveckling av mobilappar';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Lär dig hur du kan bidra till mjukvaruutveckling';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Dagliga instabila byggen, helt nya funktioner';

  @override
  String get preferences_contribute_local_community_title =>
      'Utveckla ditt lokala samhälle';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Hjälp med översättningar av programvara, innehåll och ingrediensanalyser';

  @override
  String get preferences_contribute_share_subtitle =>
      'Vi har förberett en liten mall som kan hjälpa dig :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Enkla steg för att öka livsmedelstransparensen i ditt land';

  @override
  String get preferences_contribute_data_quality_title => 'Datakvalitet';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Gå med i datakvalitetsteamet';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Hjälp oss att säkerställa att databasen är komplett och korrekt';

  @override
  String get preferences_contributions_products_added_title =>
      'Tillagda produkter';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nya produkter jag har lagt till i Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produkter jag behöver slutföra';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Alla ofullständiga produkter';

  @override
  String get preferences_my_contributions_prices_title => 'Priser';

  @override
  String get preferences_my_contributions_my_prices_title => 'Mina priser';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Mina priser, mina bevis…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produkter du kan hjälpa till att slutföra';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Hjälp till att beräkna Nutri-Score och Green-Score i ditt land';

  @override
  String get preferences_prices_user_prices_subtitle => 'Priser jag bidrog med';

  @override
  String get preferences_prices_proofs_subtitle => 'Prislappar och kvitton';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Ta foton av dina kvitton och skanna tillhörande streckkoder';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Ta bilder på priserna i en butik';

  @override
  String get preferences_prices_newest_title => 'Senaste priserna';

  @override
  String get preferences_prices_newest_subtitle =>
      'Senaste priserna tillagda av Open Prices-communityn';

  @override
  String get preferences_prices_top_contributors_title =>
      'Bidragsgivare med högst priser';

  @override
  String get preferences_prices_metrics_title => 'Mätvärden för öppna priser';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Följ projektets utveckling';

  @override
  String get preferences_prices_ways_contribute_title => 'Sätt att bidra';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Bekräfta priser som lagts till av dig själv eller andra, med hjälp av AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Lägg snabbt till många kvitton eller foton på hyllor från din kamerarulle';

  @override
  String get preferences_prices_challenges_title => 'Månatliga utmaningar';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Delta i månatliga tematiska uppdrag för att samla priser';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Återta din lojalitetsdata';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Läs hur du begär dina uppgifter';

  @override
  String get preferences_page_customize_app_title => 'Anpassa appen';

  @override
  String get preferences_page_contribute_project_title =>
      'Bidra till projektet';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Enkla sätt att hjälpa till Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Poängsättningsmetoder, hjälp och mer om projektet';

  @override
  String get product_edit_robotoff_positive_button => 'Acceptera förslaget';

  @override
  String get product_edit_robotoff_negative_button => 'Avvisa förslag';

  @override
  String get product_edit_robotoff_show_proof => 'Visa bevis';

  @override
  String get product_edit_robotoff_expand_proof => 'Utöka beviset';

  @override
  String get product_page_tab_raw_data => 'Rådata';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Sida $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Sida $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count av $total artiklar';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count av $total artiklar';
  }

  @override
  String item_count(int count) {
    return '$count föremål';
  }

  @override
  String item_count_string(String count) {
    return '$count föremål';
  }

  @override
  String get prices_no_result => 'Ingen prisstatistik hittades.';

  @override
  String get prices_error_loading_more_items =>
      'Fel vid inläsning av fler objekt';

  @override
  String get prices_proof_error =>
      'Autentisering misslyckades, det gick inte att hämta bevis';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count av $total bevis';
  }

  @override
  String proof_count(int count) {
    return '$count bevis';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count av $total bidragsgivare';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count av $total platser';
  }

  @override
  String prices_locations_count(int count) {
    return '$count platser';
  }

  @override
  String get restart_to_apply_message =>
      'Starta om appen för att tillämpa ändringarna.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafiskt gränssnitt';

  @override
  String get preferences_app_settings_media_title => 'Media';

  @override
  String get preferences_about_app_development_title => 'Utveckling';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Öppna matfaktalabb';

  @override
  String get preferences_root_account_title => 'Konto';

  @override
  String get preferences_contribute_translate_header =>
      'Få Open Food Facts till ditt språk';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Registrera dig för alfaversionen av appen';

  @override
  String get preferences_dev_mode_section_data => 'Bidrag och produktdata';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Visa inte folksonomi';

  @override
  String get preferences_account_title => 'Konto';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Tillagd den $created';
  }

  @override
  String get location_map_details_title => 'Platsinformation';

  @override
  String get location_map_details_name => 'Namn';

  @override
  String get location_map_details_street => 'Gata';

  @override
  String get location_map_details_city => 'Stad';

  @override
  String get location_map_details_postcode => 'Postnummer';

  @override
  String get location_map_details_country => 'Land';

  @override
  String get location_map_details_coordinates => 'Koordinater';

  @override
  String get location_map_details_osm_id => 'OSM-ID';
}
