// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Slovak (`sk`).
class AppLocalizationsSk extends AppLocalizations {
  AppLocalizationsSk([String locale = 'sk']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Áno';

  @override
  String get add => 'Pridať';

  @override
  String get account_delete_message =>
      'Naozaj chcete odstrániť svoj účet?\nAk existuje konkrétny dôvod, zdieľajte ho nižšie prosím';

  @override
  String get reason => 'Dôvod';

  @override
  String get okay => 'V poriadku';

  @override
  String get validate => 'Potvrdiť';

  @override
  String get create => 'Vytvoriť';

  @override
  String get applyButtonText => 'Potvrdiť';

  @override
  String get next_label => 'Ďalšie';

  @override
  String get continue_label => 'Pokračovať';

  @override
  String get exit_label => 'Ukončiť';

  @override
  String get previous_label => 'Predchádzajúce';

  @override
  String get go_back_to_top => 'Späť na začiatok';

  @override
  String get save => 'Uložiť';

  @override
  String get save_confirmation => 'Naozaj chcete uložiť?';

  @override
  String get skip => 'Preskočiť';

  @override
  String get cancel => 'Zrušiť';

  @override
  String get ignore => 'Ignorovať';

  @override
  String get close => 'Zatvoriť';

  @override
  String get no => 'Nie';

  @override
  String get stop => 'Zastaviť';

  @override
  String get finish => 'Dokončiť';

  @override
  String get calculate => 'Vypočítať';

  @override
  String get reset_food_prefs => 'Obnoviť potravinové predvoľby';

  @override
  String get error => 'Niečo sa pokazilo';

  @override
  String get error_occurred => 'Vyskytla sa chyba';

  @override
  String get featureInProgress =>
      'Na tejto funkcii ešte pracujeme, zostaňte s nami';

  @override
  String get label_web => 'Zobraziť na webe';

  @override
  String get learnMore => 'Zistiť viac';

  @override
  String get unknown => 'Neznámy';

  @override
  String get match_very_good => 'Veľmi dobrá zhoda';

  @override
  String get match_good => 'Dobrá zhoda';

  @override
  String get match_poor => 'Slabá zhoda';

  @override
  String get match_may_not => 'Nemusí sa zhodovať';

  @override
  String get match_does_not => 'Nezhoduje sa';

  @override
  String get match_unknown => 'Neznáma zhoda';

  @override
  String get match_short_very_good => 'Veľmi dobrá zhoda';

  @override
  String get match_short_good => 'Dobrá zhoda';

  @override
  String get match_short_poor => 'Slabá zhoda';

  @override
  String get match_short_may_not => 'Nemusí sa zhodovať';

  @override
  String get match_short_does_not => 'Nezhoduje sa';

  @override
  String get match_short_unknown => 'Neznáma zhoda';

  @override
  String get licenses => 'Licencie';

  @override
  String get looking_for => 'Hľadám';

  @override
  String get welcomeToOpenFoodFacts => 'Vitajte v službe Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts je globálna nezisková organizácia založená na miestnych komunitách.';

  @override
  String get productDataUtility =>
      'Zobraziť údaje o potravinách, ktoré zodpovedajú vašim preferenciám.';

  @override
  String get healthCardUtility =>
      'Vyberte si potraviny, ktoré sú dobré pre vás a vašu planétu.';

  @override
  String get ecoCardUtility =>
      'Vyberajte potraviny, ktoré sú dobré pre vás a vašu planétu.';

  @override
  String get server_error_open_new_issue =>
      'Žiadna odozva servera! Problém môžete otvoriť pomocou nasledujúceho odkazu.';

  @override
  String get sign_in_text =>
      'Prihláste sa do svojho účtu Open Food Facts a uložte svoje príspevky';

  @override
  String get incorrect_credentials =>
      'Nesprávne používateľské meno alebo heslo.';

  @override
  String get password_lost_incorrect_credentials =>
      'Tento email alebo používateľské meno neexistuje. Skontrolujte svoje poverenia.';

  @override
  String get password_lost_server_unavailable =>
      'Na našich serveroch momentálne dochádza k spomaleniu a ospravedlňujeme sa za to. Skúste to neskôr prosím.';

  @override
  String get login => 'Prihlásenie';

  @override
  String get login_result_type_server_unreachable => 'Sieť je nedostupná';

  @override
  String get login_result_type_server_issue =>
      'Problém na serveri. Prosím, skúste neskôr.';

  @override
  String get login_page_username_or_email =>
      'Zadajte používateľské meno alebo email';

  @override
  String get login_page_password_error_empty => 'Prosím, zadajte heslo';

  @override
  String get create_account => 'Vytvoriť účet';

  @override
  String get sign_in => 'Prihlásiť sa';

  @override
  String get sign_in_mandatory =>
      'Pre túto funkciu potrebujeme, aby ste sa prihlásili.';

  @override
  String get help_improve_country =>
      'Pomôžte zlepšiť Open Food Facts vo vašej krajine';

  @override
  String get sign_out => 'Odhlásiť sa';

  @override
  String get sign_out_confirmation => 'Naozaj sa chcete odhlásiť?';

  @override
  String get password => 'Heslo';

  @override
  String get forgot_password => 'Zabudnuté heslo';

  @override
  String get forgot_password_question => 'Zabudli ste heslo?';

  @override
  String get view_profile => 'Zobraziť účet';

  @override
  String get reset_password => 'Obnoviť heslo';

  @override
  String get reset_password_explanation_text =>
      'V prípade zabudnutého hesla zadajte svoje používateľské meno alebo emailovú adresu, aby ste dostali pokyny na obnovenie hesla. Nezabudnite si tiež skontrolovať priečinok s nevyžiadanou poštou – Spam.';

  @override
  String get username_or_email => 'Používateľské meno alebo email';

  @override
  String get reset_password_done =>
      'Na emailovú adresu priradenú k vášmu účtu bol odoslaný email s odkazom na obnovenie hesla. Skontrolujte si aj priečinok s nevyžiadanou poštou – Spam';

  @override
  String get send_reset_password_mail => 'Zmeniť heslo';

  @override
  String get enter_some_text => 'Prosím, zadajte nejaký text';

  @override
  String get sign_up_page_title => 'Zaregistrovať sa';

  @override
  String get sign_up_page_action_button => 'Zaregistrovať sa';

  @override
  String get sign_up_page_action_doing_it => 'Prihlasovanie…';

  @override
  String get sign_up_page_action_ok =>
      'Gratulujeme! Váš účet bol práve vytvorený.';

  @override
  String get sign_up_page_display_name_hint => 'Názov';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Zadajte zobrazované meno, ktoré chcete použiť';

  @override
  String get sign_up_page_email_hint => 'Emailová adresa';

  @override
  String get sign_up_page_email_error_empty => 'Email je povinný';

  @override
  String get sign_up_page_email_error_invalid => 'Neplatný email';

  @override
  String get sign_up_page_username_hint =>
      'Používateľské meno: verejne viditeľné';

  @override
  String get sign_up_page_username_error_empty =>
      'Prosím, zadajte používateľské meno';

  @override
  String get sign_up_page_username_error_invalid =>
      'Zadajte platné používateľské meno';

  @override
  String get sign_up_page_username_description =>
      'Používateľské meno nemôže obsahovať medzery, veľké písmená ani špeciálne znaky.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Používateľské meno nemôže presiahnuť $value znakov';
  }

  @override
  String get sign_up_page_password_hint => 'Heslo';

  @override
  String get sign_up_page_password_error_empty => 'Prosím, zadajte heslo';

  @override
  String get sign_up_page_password_error_invalid =>
      'Prosím, zadajte heslo (najmenej 6 znakov)';

  @override
  String get sign_up_page_confirm_password_hint => 'Potvrdiť heslo';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Prosím potvrďte heslo';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Heslá sa nezhodujú';

  @override
  String get sign_up_page_agree_text => 'Súhlasím s Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'podmienkami používania a prispievaním';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Pri vytváraní účtu je súhlas s Podmienkami používania povinný, napriek tomu je však možné prostredníctvom aplikácie prispievať anonymne';

  @override
  String get sign_up_page_producer_checkbox => 'Som výrobca potravín';

  @override
  String get sign_up_page_producer_hint => 'Výrobca/značka';

  @override
  String get sign_up_page_producer_error_empty =>
      'Zadajte výrobcu alebo názov značky';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Chcem sa prihlásiť na odber noviniek Open Food Facts (z odberu sa môžete kedykoľvek odhlásiť)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Toto používateľské meno už existuje, prosím zadajte iné.';

  @override
  String get sign_up_page_email_already_exists =>
      'už existuje, prihláste sa do účtu alebo skúste použiť iný email.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Prosím zadajte platnú e-mailovú adresu.';

  @override
  String get sign_up_page_server_busy =>
      'Veľmi nás to mrzí, pri vytváraní vášho účtu máme technické problémy. Skúste neskôr prosím.';

  @override
  String get settingsTitle => 'Nastavenia';

  @override
  String get darkmode => 'Téma';

  @override
  String get darkmode_dark => 'Tmavý';

  @override
  String get darkmode_light => 'Svetlý';

  @override
  String get darkmode_system_default => 'Predvolené nastavenie systému';

  @override
  String get thanks_for_contributing => 'Ďakujeme, že ste prispeli!';

  @override
  String get contributors_label => 'Budujú aplikáciu';

  @override
  String get contributors_dialog_title => 'Prispievatelia';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Prispievateľ: $name';
  }

  @override
  String get contributors_description =>
      'Zoznam všetkých prispievateľov tejto aplikácie';

  @override
  String get support => 'Podpora';

  @override
  String get support_join_slack => 'Požiadajte o pomoc na našom kanáli Slack';

  @override
  String get support_via_forum => 'Požiadajte o pomoc na našom fóre';

  @override
  String get support_via_email => 'Pošlite nám email';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Chcete odoslať logy aplikácie?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Prajete si zahrnúť logy aplikácie do prílohy k vášmu emailu?';

  @override
  String get termsOfUse => 'Podmienky používania';

  @override
  String get legalNotices => 'Právne oznámenia';

  @override
  String get privacy_policy => 'Zásady ochrany osobných údajov';

  @override
  String get about_this_app => 'O tejto aplikácii';

  @override
  String get contribute => 'Prispieť';

  @override
  String get contribute_sw_development => 'Vývoj softvéru';

  @override
  String get contribute_develop_text =>
      'Kód pre každý produkt Open Food Facts je dostupný na GitHube. Môžete použiť kód (je to otvorený zdroj) a pomôcť nám ho vylepšiť pre všetkých na celej planéte.';

  @override
  String get contribute_develop_text_2 =>
      'Môžete sa pripojiť k diskusnej miestnosti Open Food Facts Slack, čo je preferovaný spôsob kladenia otázok.';

  @override
  String get contribute_develop_dev_mode_title => 'Režim DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktivujte režim DEV';

  @override
  String get contribute_donate_title => 'Darovať';

  @override
  String get contribute_donate_header => 'Prispejte na Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Berte prosím na vedomie, že s internou alfa verziou je možná úplná strata údajov a aplikácia sa môže kedykoľvek stať nepoužiteľnou!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Výrobky, ktoré sa majú dokončiť';

  @override
  String get contribute_improve_header => 'Zlepšovanie';

  @override
  String get contribute_improve_text =>
      'Databáza je jadrom projektu. Pomôcť je jednoduché a veľmi rýchle. Môžete si stiahnuť mobilnú aplikáciu pre svoj telefón a začať pridávať alebo vylepšovať produkty.\n\nNa druhej strane webová stránka Open Food Facts ponúka mnoho spôsobov, ako prispieť: ';

  @override
  String get contribute_translate_header => 'Preložiť';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Začnite prekladať';

  @override
  String get contribute_translate_text =>
      'Open Food Facts je globálny projekt, ktorý obsahuje produkty z viac ako 160 krajín. Open Food Facts je preložený do desiatok jazykov s neustále sa vyvíjajúcim obsahom.';

  @override
  String get contribute_translate_text_2 =>
      'Preklady sú jednou z kľúčových úloh projektu';

  @override
  String get contribute_join_skill_pool =>
      'Prispejte svojimi schopnosťami do Open Food Facts. Pridajte sa k tímu zručných!';

  @override
  String get contribute_share_header =>
      'Zdieľajte Open Food Facts so svojimi priateľmi';

  @override
  String get contribute_share_content =>
      'Rád by som vám dal vedieť o aplikácii Open Food Facts, ktorú používam. Umožňuje personalizovaným spôsobom získať informácie o vplyve vášho jedla na zdravie a životné prostredie. Funguje tak, že naskenujete čiarové kódy na obale. Je zdarma, nevyžaduje registráciu a dokonca môžete pomôcť zvýšiť počet rozpoznateľných produktov v ich databáze. Tu je odkaz na jeho získanie pre váš telefón: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Prispejte cenami požiadaním o export údajov z vašich vernostných kariet podľa GDPR';

  @override
  String get tap_to_answer => 'Klepnutím sem odpovedzte na otázky';

  @override
  String get tap_to_answer_hint =>
      'Klepnutím sem odpoviete na otázky o tomto produkte';

  @override
  String get robotoff_questions_loading_hint =>
      'Počkajte, kým sa načítajú otázky o tomto produkte';

  @override
  String get saving_answer => 'Ukladá sa vaša odpoveď';

  @override
  String get contribute_to_get_rewards =>
      'Staňte sa aktérom potravinovej transparentnosti';

  @override
  String get question_sign_in_text =>
      'Prihláste sa do svojho účtu Open Food Facts a získajte kredit za svoj príspevok';

  @override
  String get question_yes_button_accessibility_value => 'Odpovedzte áno';

  @override
  String get question_no_button_accessibility_value => 'Odpovedzte nie';

  @override
  String get question_skip_button_accessibility_value =>
      'Preskočte túto otázku';

  @override
  String get tap_to_edit_search => 'Klepnutím upravíte vyhľadávanie';

  @override
  String get myPreferences => 'Moje nastavenia';

  @override
  String get account_create_message =>
      'Vytvorte si účet a pripojte sa ku komunite Open Food Facts, aby ste pomohli budovať vedomosti o potravinách na celom svete!';

  @override
  String get join_us => 'Pridajte sa';

  @override
  String get myPreferences_profile_title => 'Váš účet';

  @override
  String get myPreferences_profile_subtitle =>
      'Spravujte svoj Open Food Facts účet.';

  @override
  String get myPreferences_settings_title => 'Nastavenia aplikácie';

  @override
  String get myPreferences_settings_subtitle => 'Tmavý režim, jazyky…';

  @override
  String get myPreferences_food_title => 'Potravinové preferencie';

  @override
  String get myPreferences_food_subtitle =>
      'Vyberte si, ktoré informácie o potravinách sú pre vás najdôležitejšie.';

  @override
  String get myPreferences_food_comment =>
      'Vyberte si, ktoré informácie o potravinách sú pre vás najdôležitejšie, aby ste mohli zoradiť produkty podľa svojich preferencií. Pozrite si informácie, ktoré vás zaujímajú ako prvé a získajte súhrn kompatibility. Tieto potravinové preferencie zostanú vo vašom zariadení a nie sú spojené s vaším účtom prispievateľa Open Food Facts, ak ho máte.';

  @override
  String get confirmResetPreferences => 'Obnoviť potravinové preferencie?';

  @override
  String get myPersonalizedRanking => 'Hodnotenie na mieru';

  @override
  String get ranking_tab_all => 'Všetky';

  @override
  String get ranking_subtitle_match_yes => 'Veľká zhoda';

  @override
  String get ranking_subtitle_match_no => 'Veľmi slabá zhoda';

  @override
  String get ranking_subtitle_match_maybe => 'Neznáma zhoda';

  @override
  String get refresh_with_new_preferences =>
      'Obnovte zoznam s vašimi novými preferenciami';

  @override
  String get reloaded_with_new_preferences =>
      'Znova načítané s vašimi novými preferenciami';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Skenovať';

  @override
  String get history_navbar_label => 'História';

  @override
  String get list_navbar_label => 'Zoznamy';

  @override
  String get category => 'Filtrovať podľa kategórie';

  @override
  String get category_all => 'Všetky';

  @override
  String get category_search => '(vyhľadávanie podľa kategórií)';

  @override
  String get filter => 'Filtrovať';

  @override
  String get scan => 'Produkty z obrazovky skenovania';

  @override
  String get scan_history => 'História skenovania';

  @override
  String get search => 'Vyhľadať';

  @override
  String get search_product_help =>
      'Vyhľadajte produkt,\nznačku alebo čiarový kód';

  @override
  String get search_filter => 'Vyhľadávací filter';

  @override
  String get search_history => 'História vyhľadávania';

  @override
  String get search_store => 'Vyhľadajte obchod';

  @override
  String get search_store_help => 'Tip: pridajte mesto alebo krajinu';

  @override
  String get tap_for_more => 'Klepnutím zobrazíte ďalšie informácie…';

  @override
  String get product => 'Produkt';

  @override
  String get unknownBrand => 'Neznáma značka';

  @override
  String get unknownQuantity => 'Neznáme množstvo';

  @override
  String get unknownProductName => 'Neznámy názov výrobku';

  @override
  String get label_refresh => 'Obnoviť';

  @override
  String get label_reload => 'Znovu načítať';

  @override
  String get image => 'Obrázok';

  @override
  String get front_photo => 'Obrázok spredu';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (tento obrázok môže byť zastaraný)';
  }

  @override
  String get outdated_image_short_label => 'môže byť zastarané';

  @override
  String get ingredients => 'Ingrediencie';

  @override
  String get ingredients_editing_instructions =>
      'Ponechajte pôvodné poradie. Uveďte percento ak je dostupné. Oddeľte ich čiarkou alebo pomlčkou a použite zátvorky pre zloženie zložiek.';

  @override
  String get ingredients_editing_error => 'Nepodarilo sa uložiť zložky.';

  @override
  String get ingredients_editing_image_error =>
      'Nepodarilo sa získať obrázok nových zložiek.';

  @override
  String get ingredients_editing_title => 'Upraviť zložky';

  @override
  String get ingredients_photo => 'Fotografia zložiek';

  @override
  String get packaging_editing_instructions =>
      'Uveďte všetky časti balenia oddelené čiarkou alebo riadkom s uvedením ich množstva (napr. 1 alebo 6), typu (napr. fľaša, škatuľa, plechovka), materiálu (napr. plast, kov, hliník) a ak je k dispozícii, ich veľkosti (napr. 33 cl) a pokynov na recykláciu.\nPríklad: 1 sklenená recyklovateľná fľaša, 1 plastový korok na vyhodenie';

  @override
  String get packaging_editing_error => 'Nepodarilo sa uložiť balenie.';

  @override
  String get packaging_editing_image_error =>
      'Nepodarilo sa získať nový obrázok balenia.';

  @override
  String get packaging_editing_title => 'Upraviť balenie';

  @override
  String get nutrition => 'Nutričné hodnoty';

  @override
  String get nutrition_facts_photo => 'Foto výživových údajov';

  @override
  String get nutrition_facts_editing_title => 'Upraviť výživové údaje';

  @override
  String get packaging_information => 'Pokyny na recykláciu';

  @override
  String get packaging_information_photo => 'Fotografia recyklačných pokynov';

  @override
  String get missing_product => 'Našli ste nový produkt!';

  @override
  String get add_product_take_photos =>
      'Odfoťte obal a pridajte tento produkt do Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Najprv urobte nejaké fotografie. Produkt môžete dokončiť kedykoľvek neskôr.';

  @override
  String get add_product_information_button_label =>
      'Pridajte informácie o produkte';

  @override
  String get new_product => 'Nový produkt';

  @override
  String get new_product_found_title => 'Našiel sa nový produkt!';

  @override
  String get new_product_found_text =>
      'Naša databáza obsahuje viac ako **3 milióny produktov**, ale tento čiarový kód v nej neexistuje: ';

  @override
  String get new_product_found_button => 'Pridať tento výrobok';

  @override
  String get new_product_leave_title => 'Opustiť túto stránku?';

  @override
  String get new_product_leave_message =>
      'Zdá sa, že ste nič nezadali. Naozaj chcete opustiť túto stránku?';

  @override
  String get new_product_dialog_description =>
      'Odfoťte obal a pridajte tento produkt do našej databázy';

  @override
  String get new_product_dialog_illustration_description =>
      'Príklad s neznámym Nutri-Score a Green Score';

  @override
  String get front_packaging_photo_button_label => 'Predná fotografia produktu';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Potvrďte nahranie prednej fotografie produktu';

  @override
  String get confirm_button_label => 'Potvrdiť';

  @override
  String get send_image_button_label => 'Odoslať obrázok';

  @override
  String get crop_page_action_saving => 'Ukladá sa obrázok…';

  @override
  String get crop_page_action_cropping => 'Orezanie obrázka…';

  @override
  String get crop_page_action_local => 'Ukladá sa lokálna verzia…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ojoj… niečo je s vašou fotkou!';

  @override
  String get crop_page_action_local_failed_message =>
      'Pred odoslaním na náš server nedokážeme spracovať obrázok lokálne. Skúste to znova neskôr alebo nás kontaktujte, ak problém pretrváva.';

  @override
  String get crop_page_action_retake => 'Znova urobte fotografiu';

  @override
  String get crop_page_too_small_image_title => 'Obrázok je príliš malý!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Minimálna veľkosť obrázka v pixeloch je ${expectedMinWidth}x$expectedMinHeight. Aktuálny obrázok je ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Príprava požiadavky na server…';

  @override
  String get front_packaging_photo_title => 'Predná fotografia produktu';

  @override
  String get ingredients_photo_title => 'Fotografia zložiek';

  @override
  String get nutritional_facts_photo_title => 'Fotografia výživových údajov';

  @override
  String get recycling_photo_title => 'Pokyny na recykláciu Fotografia';

  @override
  String get take_photo_title => 'Odfotiť';

  @override
  String get take_more_photo_title => 'Odfotiť viacej fotografií';

  @override
  String get front_photo_uploaded => 'Predná fotografia produktu bola nahraná';

  @override
  String get ingredients_photo_button_label => 'Fotografia zložiek';

  @override
  String get ingredients_photo_uploaded => 'Fotografia zložiek bola nahraná';

  @override
  String get nutrition_cache_loading_error =>
      'Nie je možné načítať živiny z vyrovnávacej pamäte';

  @override
  String get nutritional_facts_photo_button_label => 'Foto výživových údajov';

  @override
  String get nutritional_facts_input_button_label =>
      'Aktualizujte fakty o nutričných údajoch';

  @override
  String get nutritional_facts_added => 'Nutričné údaje';

  @override
  String get categories_added => 'Kategórie pridané';

  @override
  String get new_product_title_nutriscore => 'Získajte Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Pomôžte nám vyplnením aspoň kategórie a nutričných údajov';

  @override
  String get new_product_title_environmental_score => 'Vypočítajte Green Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Získajte ho vyplnením aspoň kategórie';

  @override
  String get new_product_additional_environmental_score =>
      'Spresnite výpočet Green Score pomocou pôvodu, balenia a ďalších údajov';

  @override
  String get new_product_title_nova =>
      'Vypočítajte úroveň spracovania potravín (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Získajte ho vyplnením kategórie potravín a zložiek';

  @override
  String get new_product_desc_nova_unknown =>
      'Úroveň spracovania potravín neznáma';

  @override
  String get new_product_title_pictures => 'Nový produkt';

  @override
  String get new_product_title_pictures_details =>
      'Urobte prosím nasledujúce fotografie a nástroj Open Food Facts môže vyriešiť zvyšok!';

  @override
  String get new_product_title_misc => 'A pár základných údajov…';

  @override
  String new_product_done_msg(String username) {
    return 'Ďakujeme za váš príspevok „$username“!';
  }

  @override
  String get new_product_done_msg_no_user => 'Ďakujeme za Váš príspevok!';

  @override
  String get new_product_done_button_label => 'Objavte hotový produkt';

  @override
  String get hey_incomplete_product_message =>
      'Klepnutím odpovedzte na 3 otázky a vypočítajte Nutri-Score, Green Score & úroveň spracovania potravín (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Klepnutím teraz odpovedzte na 2 otázky, ktoré vám pomôžu analyzovať túto kozmetiku!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Klepnutím teraz odpovedzte na 3 otázky, ktoré vám pomôžu analyzovať toto krmivo pre domáce zvieratá!';

  @override
  String get hey_incomplete_product_message_product =>
      'Klepnutím teraz pomôžte dokončiť tento produkt!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Fotografia výživových údajov bola nahraná';

  @override
  String get recycling_photo_button_label => 'Recyklačná fotografia';

  @override
  String get recycling_photo_uploaded => 'Recyklačná fotografia bola odovzdaná';

  @override
  String get take_more_photo_button_label => 'Odfotiť viacej fotografií';

  @override
  String get other_photo_uploaded => 'Rôzne fotografie boli nahrané';

  @override
  String get retake_photo_button_label => 'Znova';

  @override
  String get selecting_photo => 'Vybrať fotografiu';

  @override
  String get uploading_image => 'Nahrávanie fotografie na server';

  @override
  String get uploading_image_type_front =>
      'Nahráva sa predný obrázok do Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Nahrávanie obrázka zložiek do Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Nahrávanie obrázka nutričných údajov do Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Nahrávanie obrázka obalu do Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Nahrávanie iného obrázka do Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Nahrávanie obrázka do Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Pridajte chýbajúce zložky';

  @override
  String get score_add_missing_packaging_image =>
      'Pridajte chýbajúcu fotografiu obalu';

  @override
  String get score_add_missing_nutrition_facts =>
      'Pridajte chýbajúce výživové údaje';

  @override
  String get score_add_missing_product_traces =>
      'Pridajte chýbajúce stopy produktu';

  @override
  String get score_add_missing_product_category =>
      'Pridajte chýbajúcu kategóriu produktu';

  @override
  String get score_add_missing_precise_product_category =>
      'Vyberte presnejšiu kategóriu';

  @override
  String get score_add_missing_product_countries =>
      'Pridajte chýbajúce krajiny produktu';

  @override
  String get score_add_missing_product_emb =>
      'Pridajte chýbajúce kódy sledovateľnosti produktu';

  @override
  String get score_add_missing_product_labels =>
      'Pridajte chýbajúce štítky produktov';

  @override
  String get score_add_missing_product_origins =>
      'Pridajte chýbajúci pôvod produktu';

  @override
  String get score_add_missing_product_stores =>
      'Pridajte chýbajúce obchody s produktmi';

  @override
  String get score_add_missing_product_brands =>
      'Pridajte chýbajúcu značku produktu';

  @override
  String get score_update_nutrition_facts => 'Aktualizujte výživové údaje';

  @override
  String get nutrition_page_title => 'Výživové údaje';

  @override
  String get nutrition_page_nutritional_info_title => 'Nutričné informácie';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Hodnoty uvedené na produkte:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Áno';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Nie';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Otvoriť fotografiu';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Osvedčené postupy: výživové údaje';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Niekedy nie sú výživové údaje **uvedené na obale** alebo v dokumente priloženom k produktu. V tomto prípade a iba v tomto prípade môžete nastaviť hodnotu na **NIE**.';

  @override
  String get nutrition_page_serving_type_label => 'Výživové hodnoty:';

  @override
  String get nutrition_page_per_100g => 'na 100 g';

  @override
  String get nutrition_page_per_100g_100ml => 'na 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'na jednu porciu';

  @override
  String get nutrition_page_add_nutrient => 'Pridajte živinu';

  @override
  String get nutrition_page_serving_size => 'Veľkosť porcie';

  @override
  String get nutrition_page_serving_size_hint =>
      'Zadajte veľkosť porcie (napr.: 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Osvedčené postupy: veľkosť porcie';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Táto hodnota pomáha **vytvoriť pomerný výpočet každej živiny na veľkosť porcie**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Povolené jednotky** sú: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** alebo **60 G** (uprednostnite prvý)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** alebo **1 L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Neplatná jednotka';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Neplatné jednotky';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9**cukríkov** a 2**sušienky**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Chýbajúca jednotka';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Neplatné číslo';

  @override
  String get nutrition_page_update_running =>
      'Aktualizácia produktu na serveri…';

  @override
  String get nutrition_page_update_done => 'Produkt bol aktualizovaný!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Ako veľkosť porcie použite množstvo produktu';

  @override
  String get nutrition_page_photo_error =>
      'Nie je možné načítať túto fotografiu';

  @override
  String get more_photos => 'Viac zaujímavých fotiek';

  @override
  String get view_more_photo_button =>
      'Zobraziť všetky existujúce fotografie tohto produktu';

  @override
  String get no_product_found => 'Neboli nájdené žiadne výrobky';

  @override
  String get no_location_found => 'Neboli nájdené žiadne polohy';

  @override
  String get not_found => 'nenájdené:';

  @override
  String get refreshing_product => 'Obnovuje sa produkt';

  @override
  String get product_refreshed => 'Produkt bol obnovený';

  @override
  String product_image_accessibility_label(String date) {
    return 'Fotografia odfotená $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Fotografia odfotená $date. Táto fotografia môže byť neaktuálna';
  }

  @override
  String get product_image_outdated => 'Táto fotografia môže byť neaktuálna';

  @override
  String get product_image_outdated_explanations_title =>
      'Táto fotografia môže byť neaktuálna';

  @override
  String get product_image_outdated_explanations_content =>
      'Táto fotografia vznikla pred viac ako rokom.\n**Skontrolujte, či je aktuálna**.\n\nToto je **len varovanie**. Ak je produkt stále rovnaký, môžete túto správu ignorovať.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Nahradiť fotografiu ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Pridať fotku ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Urobte nový obrázok';

  @override
  String get product_image_action_take_picture => 'Odfotiť';

  @override
  String get product_image_action_from_gallery =>
      'Vyberte z galérie svojho telefónu';

  @override
  String get product_image_action_choose_existing_photo =>
      'Vyberte z fotografií produktu';

  @override
  String get product_image_details_label => 'Informácie o fotografii';

  @override
  String get product_image_details_from_producer => 'Od výrobcu';

  @override
  String get product_image_details_contributor => 'Prispievateľ';

  @override
  String get product_image_details_contributor_producer =>
      'Prispievateľ (výrobca)';

  @override
  String get product_image_details_date => 'Dátum';

  @override
  String get product_image_details_date_unknown => 'Neznámy';

  @override
  String get homepage_main_card_logo_description =>
      'Vitajte v službe Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Naskenujte** čiarový kód alebo\n**vyhľadajte** produkt';

  @override
  String get homepage_main_card_search_field_hint => 'Vyhľadajte produkt';

  @override
  String get homepage_main_card_search_field_tooltip => 'Začať vyhľadávanie';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Najnovšie správy: $news_title';
  }

  @override
  String get tagline_app_review => 'Páči sa vám aplikácia?';

  @override
  String get tagline_app_review_button_positive => 'Milujem to! 😍';

  @override
  String get tagline_app_review_button_negative => 'Naozaj nie…';

  @override
  String get tagline_app_review_button_later => 'Opýtajte sa ma neskôr';

  @override
  String get tagline_feed_news_button => 'Zistiť viac';

  @override
  String get app_review_negative_modal_title => 'Nepáči sa vám naša aplikácia?';

  @override
  String get app_review_negative_modal_text =>
      'Mohli by ste nám nájsť chvíľu a povedať nám prečo?';

  @override
  String get app_review_negative_modal_positive_button => 'Áno, jednoznačne!';

  @override
  String get app_review_negative_modal_negative_button => 'Nie';

  @override
  String get could_not_refresh => 'Produkt sa nepodarilo obnoviť';

  @override
  String get product_internet_error_modal_title => 'Vyskytla sa chyba!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Z dôvodu sieťovej chyby sa nám nepodarilo načítať informácie o tomto produkte. Skontrolujte internetové pripojenie a skúste to znova.\n\nInterná chyba:\n$error';
  }

  @override
  String get product_tags_title => 'Vlastnosti produktu';

  @override
  String get no_product_tags_found_message =>
      'Nenašli sa žiadne vlastnosti produktu. Vlastnosti môžu byť použité na podrobnejšie opísanie produktov flexibilným spôsobom.';

  @override
  String get product_tags_empty => 'Žiadne nehnuteľnosti';

  @override
  String get product_tags_explanation =>
      'Pridaním vlastností (kľúč/hodnota) k produktu ho pomáhate obohatiť.';

  @override
  String get add_tag => 'Pridajte vlastnosť';

  @override
  String get add_tags => 'Pridať vlastnosti';

  @override
  String get add_edit_tags => 'Pridajte alebo upravte vlastnosti';

  @override
  String get edit_tag => 'Upraviť vlastnosť';

  @override
  String get remove_tag => 'Odstrániť vlastnosť';

  @override
  String get tag_key => 'Vlastnosť';

  @override
  String get tag_keys => 'Nehnuteľnosti';

  @override
  String get tag_key_uneditable => 'Vlastnosť (neupraviteľné)';

  @override
  String get tag_key_input_hint => 'Zadajte vlastnosť';

  @override
  String get tag_value => 'Hodnota';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Zadajte hodnotu';

  @override
  String get tag_key_item => 'Vlastnosť:';

  @override
  String get tag_value_item => 'Hodnota:';

  @override
  String get tag_key_explanations => 'Kľúč musí byť malý a bez medzier.';

  @override
  String tag_key_already_exists(String property) {
    return 'Značka s vlastnosťou $property už existuje!';
  }

  @override
  String get product_internet_error =>
      'Nie je možné získať informácie o tomto produkte kvôli chybe siete.';

  @override
  String get cached_results_from => 'Zobraziť výsledky z:';

  @override
  String get product_search_same_category => 'Nájsť alternatívy';

  @override
  String get product_search_same_category_short => 'Porovnať';

  @override
  String get product_search_same_category_error =>
      'Túto funkciu je možné použiť len pre produkty s kategóriou.\n\nAk chcete pridať kategóriu, upravte produkt.';

  @override
  String get product_improvement_add_category =>
      'Pridajte kategóriu na výpočet Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Pridajte výživové údaje na výpočet Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Pridajte výživové údaje a kategóriu na výpočet Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-Score pre tento produkt sa nedá vypočítať, čo môže byť spôsobené napr. neštandardnou kategóriou. Ak to považujete za chybu, kontaktujte nás.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Výživový obrázok je zastaraný: obnovte ho.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Green Score zohľadňuje pôvod zložiek. Odfoťte zoznam zložiek a/alebo akékoľvek geografické tvrdenie alebo upravte produkt, aby ich bolo možné vziať do úvahy.';

  @override
  String get country_chooser_label => 'Prosím vyberte si krajinu';

  @override
  String get currency_chooser_label => 'Prosím vyberte si menu';

  @override
  String get country_change_message => 'Práve ste zmenili krajinu.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Chcete zmeniť menu z $previousCurrency na $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Vyberte krajinu:';

  @override
  String get country_chooser_label_from_settings => 'Vaša krajina';

  @override
  String get country_selection_explanation =>
      'Niektoré vlastnosti prostredia sú špecifické pre danú lokalitu';

  @override
  String get product_removed_comparison =>
      'Produkt bol odstránený z porovnania';

  @override
  String get native_app_settings => 'Nastavenia aplikácie';

  @override
  String get native_app_description =>
      'Nastavenia otvorených systémov pre Open Food Facts';

  @override
  String get product_removed_history => 'Produkt bol odstránený z histórie';

  @override
  String get product_removed_list => 'Produkt odstránený zo zoznamu';

  @override
  String get product_could_not_remove => 'Produkt sa nepodarilo odstrániť';

  @override
  String get no_prodcut_in_list => 'V tomto zozname nie je žiadny produkt';

  @override
  String get no_product_in_section => 'V tejto sekcii nie je žiadny produkt';

  @override
  String get recently_seen_products => 'Všetky prezerané produkty';

  @override
  String get clear => 'Vymazať';

  @override
  String get clear_long => 'Vyprázdnite zoznam';

  @override
  String get really_clear => 'Naozaj chcete odstrániť tento zoznam?';

  @override
  String pct_match(Object percent) {
    return '$percent% zhoda';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'pred $count dňami',
      one: 'včera',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'pred $count hodinami',
      one: 'pred hodinou',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'pred $count minútami',
      one: 'pred jednou minútou',
      zero: 'pred menej ako minútou',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'pred $count mesiacmi',
      one: 'pred mesiacom',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'pred $count týždňami',
      one: 'pred týždňom',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Porovnať $count produkty',
      one: 'Porovnať produkt',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count vybrané produkty',
      one: 'Jeden vybraný produkt',
      zero: 'Žiadny vybraný produkt',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Porovnajte vybrané produkty';

  @override
  String get delete_products_mode => 'Odstrániť vybrané produkty';

  @override
  String get select_all_products_mode => 'Vyberte všetky produkty';

  @override
  String get select_none_products_mode => 'Zrušiť výber';

  @override
  String get compare_products_appbar_title => 'Porovnať výrobky';

  @override
  String get compare_products_appbar_subtitle => 'Vyberte aspoň dva produkty';

  @override
  String get retry_button_label => 'Skúsiť znova';

  @override
  String get connect_with_us => 'Spojte sa s nami';

  @override
  String get tiktok => 'Sledujte nás na TikToku';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Sledujte nás na Instagrame';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Sledujte nás na X (predtým Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Sledujte nás na Mastodon-e';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Sledujte nás na BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'Často kladené otázky';

  @override
  String get discover => 'Objavte';

  @override
  String get how_to_contribute => 'Ako prispieť';

  @override
  String get hint_knowledge_panel_message =>
      'Klepnutím na ktorúkoľvek časť karty získate ďalšie podrobnosti o tom, čo vidíte. Skúste to teraz!';

  @override
  String get permissions_page_title => 'Prístup k fotoaparátu';

  @override
  String get permissions_page_body1 =>
      'Ak chcete skenovať čiarové kódy fotoaparátom svojho telefónu, povoľte prístup.';

  @override
  String get permissions_page_body2 =>
      'Ak zmeníte názor, túto možnosť môžete kedykoľvek povoliť alebo zakázať v nastaveniach.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Release: $release)\nModel: $model\nProdukt: $product\nZariadenie: $device\nZnačka:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModel: $model\nLokalizovaný model: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVerzia aplikácie: $appVersion\nČíslo zostavy aplikácie: $appBuildNumber\nNázov balíka aplikácie: $appPackageName';
  }

  @override
  String get authorize_button_label => 'Povoliť';

  @override
  String get refuse_button_label => 'Odmietnuť';

  @override
  String get ask_me_later_button_label => 'Neskôr';

  @override
  String get are_you_sure => 'Ste si istý?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Pokračujte ďalej na $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Vitajte!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Aplikácia, ktorá vám pomôže vybrať si potravinu, ktorá je dobré pre ** vás** a ** planétu**!';

  @override
  String get onboarding_continue_button => 'Pokračovať';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Načítava sa váš prvý vzorový produkt';

  @override
  String get onboarding_welcome_warning =>
      'Prepáčte, je to náš vzorový produkt, nemôžete ho upravovať :)';

  @override
  String get product_list_your_ranking => 'Vaše hodnotenie';

  @override
  String get product_list_empty_icon_desc => 'História nie je k dispozícii';

  @override
  String get product_list_empty_title => 'Spustiť skenovanie';

  @override
  String get product_list_empty_message =>
      'Tu sa zobrazia naskenované produkty a môžete si o nich skontrolovať podrobné informácie';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produktov',
      one: 'produktu',
      zero: 'produktov',
    );
    return 'Obnovenie $_temp0 vo vašej histórii';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produktov',
      one: 'produktu',
      zero: 'produktov',
    );
    return '$_temp0 obnova dokončená';
  }

  @override
  String get product_list_compare_side_by_side => 'Porovnajte vedľa seba';

  @override
  String get loading_dialog_default_title => 'Sťahovanie údajov';

  @override
  String get loading_dialog_default_error_message =>
      'Údaje sa nepodarilo stiahnuť';

  @override
  String get account_delete => 'Zmazať účet';

  @override
  String get account_delete_title => 'Odstrániť môj účet';

  @override
  String get user_profile => 'Účet';

  @override
  String get user_profile_title_guest => 'Vitajte!';

  @override
  String get user_profile_subtitle_guest =>
      'Ak sa chcete pripojiť ku komunite Open Food Facts, prihláste sa alebo sa zaregistrujte';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts prihlasovacie meno: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Vitajte $id!';
  }

  @override
  String get email_subject_account_deletion => 'Zmazať účet';

  @override
  String email_body_account_deletion(String userId) {
    return 'Dobrý deň, prosím odstráňte môj účet Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Aplikácia';

  @override
  String get settings_app_data => 'Súkromie a monitorovanie';

  @override
  String get settings_app_camera => 'Fotoaparát';

  @override
  String get settings_app_products => 'Výrobky';

  @override
  String get settings_app_miscellaneous => 'Rôzne';

  @override
  String get camera_play_sound_title => 'Prehrávať zvuk pri skenovaní';

  @override
  String get camera_play_sound_subtitle =>
      'Pri každom úspešnom skenovaní pípnuť';

  @override
  String get camera_window_accessibility_label =>
      'Naskenujte čiarový kód pomocou fotoaparátu';

  @override
  String get app_haptic_feedback_title => 'Vibrácie a haptika';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrácie po vykonaní niektorých akcií (čiarový kód dekódovaný, produkt odstránený…).';

  @override
  String get crash_reporting_toggle_title => 'Hlásenie o zlyhaní';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Keď je táto možnosť povolená, správy o zlyhaní sa automaticky odosielajú do systému sledovania chýb Open Food Facts, aby bolo možné opraviť chyby a vylepšiť tak aplikáciu.';

  @override
  String get send_anonymous_data_toggle_title => 'Posielať anonymné údaje';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Keď je táto možnosť povolená, na servery Open Food Facts sa budú odosielať niektoré anonymné informácie o používaní aplikácie, aby sme pochopili, ako a koľko funkcií sa používa na ich zlepšenie.';

  @override
  String get product_edit_photo_title => 'Upraviť fotografiu';

  @override
  String get permission_photo_error => 'Chyba';

  @override
  String get permission_photo_denied_title =>
      'Povoliť používanie fotoaparátu na skenovanie čiarových kódov';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Pre lepší zážitok povoľte $appName prístup k vašej kamere. Budete môcť priamo skenovať čiarové kódy.';
  }

  @override
  String get permission_photo_denied_button => 'Povoliť';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Povolenie zamietnuté';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Keďže ste predtým odmietli povolenie fotoaparátu, musíte ho povoliť manuálne v Nastaveniach.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Otvoriť nastavenia';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Zrušiť';

  @override
  String get permission_photo_none_found => 'Nebola rozpoznaná žiadna kamera';

  @override
  String get permission_photo_denied => 'Nie je povolený prístup k fotoaparátu';

  @override
  String get show_product_pictures => 'Zobraziť fotografie produktov';

  @override
  String get edit_product_label => 'Upraviť výrobok';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Nahrávajú sa vaše úpravy…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Vaše úpravy sa **odosielajú na pozadí** (alebo neskôr v prípade chyby).\nMôžete pokračovať v úprave ďalších polí produktov.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Vaše úpravy sa **odosielajú na pozadí** (alebo neskôr v prípade chyby).';

  @override
  String get edit_product_label_short => 'Upraviť';

  @override
  String edit_product_form_item_help(String value) {
    return 'Ako zadať „$value“?';
  }

  @override
  String get edit_product_form_item_error_empty => 'Zadajte neprázdnu hodnotu!';

  @override
  String get edit_product_form_item_error_existing =>
      'Táto hodnota už existuje!';

  @override
  String get edit_product_form_item_add_action_brand => 'Pridať novú značku';

  @override
  String get edit_product_form_item_add_action_label => 'Pridať nový štítok';

  @override
  String get edit_product_form_item_add_action_store => 'Pridať nový obchod';

  @override
  String get edit_product_form_item_add_action_origin => 'Pridať nový pôvod';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Pridať nový kód sledovateľnosti';

  @override
  String get edit_product_form_item_add_action_country => 'Pridať novú krajinu';

  @override
  String get edit_product_form_item_add_action_category =>
      'Pridať novú kategóriu';

  @override
  String get edit_product_form_item_add_action_trace => 'Pridať novú stopu';

  @override
  String get edit_product_form_item_add_suggestion => 'Pridať návrh';

  @override
  String get edit_product_form_item_deny_suggestion => 'Zamietnuť návrh';

  @override
  String get edit_product_form_item_details_title => 'Základné detaily';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Názov produktu, značka, množstvo';

  @override
  String get edit_product_form_item_other_details_title => 'Ďalšie podrobnosti';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Webová stránka…';

  @override
  String get edit_product_form_item_photos_title => 'Fotografie';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Pridajte alebo obnovte fotografie';

  @override
  String get edit_product_form_item_labels_title => 'Štítky a certifikácie';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Environmentálne značky kvality…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Zadajte štítok (napr.: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'Štítok';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Osvedčené postupy: Štítky';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Akákoľvek charakteristika produktu, **ktorá je skutočná** a odlišuje sa od ostatných oblastí.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Vyrobené v Belgicku, produkované v Bretónsku…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Bohaté na vlákninu, zdroj železa…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fair trade, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Obchody';

  @override
  String get edit_product_form_item_stores_hint => 'Zadajte obchod';

  @override
  String get edit_product_form_item_stores_type => 'obchod';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Osvedčené postupy: Obchody';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Zadajte obchod, kde ste produkt kúpili.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Pôvod';

  @override
  String get edit_product_form_item_origins_hint =>
      'Zadajte pôvod (napr.: Nemecko)';

  @override
  String get edit_product_form_item_origins_type => 'krajina';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Osvedčené postupy: pôvody';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Pridajte **akékoľvek označenie pôvodu, ktoré nájdete na obale**. Nemusíte sa obávať pôvodu uvedeného priamo v zozname ingrediencií.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Hovädzie mäso z Argentíny';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Sója nepochádza z Európskej únie';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Zadajte krajinu (napr.: Nemecko)';

  @override
  String get edit_product_form_item_countries_type => 'krajina';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Osvedčené postupy: krajiny';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Krajiny, kde je produkt široko dostupný** (okrem obchodov špecializujúcich sa na zahraničné produkty).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Kódy vysledovateľnosti';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Zadajte kód (napr.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'kód vysledovateľnosti';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Osvedčené postupy: kódy vysledovateľnosti';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'V tejto časti môžete zadať kódy súvisiace so **značkami na obale**, **identifikačnými značkami** alebo **zdravotnými značkami**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Príklady kódov vysledovateľnosti';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EC kódy** používané v Európskom spoločenstve na identifikáciu výrobcov potravín alebo baliarní:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72 264 002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: kód krajiny **Francúzsko**\n**72 264 002**: geografické údaje\n**CE**: Európske spoločenstvo';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB kódy** používané vo Francúzsku:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Stopy';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'Zadajte stopu (napr.: Sójové bôby)';

  @override
  String get edit_product_form_item_categories_title => 'Kategórie';

  @override
  String get edit_product_form_item_categories_hint => 'Kategória';

  @override
  String get edit_product_form_item_categories_type =>
      'Zadajte kategóriu (napr.: Pomarančový džús)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Osvedčené postupy: kategórie';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Uveďte iba najšpecifickejšiu kategóriu. Nadradené kategórie budú pridané automaticky.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Chýba kategória?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'V prípade, že kategória nie je dostupná v automatickom dopĺňaní, pokojne ju aj tak pridajte, pomôže nám to zlepšiť Open Food Facts vo vašej krajine.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardinky v olivovom oleji';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Pomarančová šťava z koncentrátu';

  @override
  String get edit_product_form_item_exit_title => 'Skončiť bez uloženia?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Chcete uložiť zmeny pred opustením tejto stránky?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Uložiť zmeny';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Zrušiť zmeny';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingrediencie';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Priblíženie a oddialenie gestami na obrazovke';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Priblíženie a oddialenie fotografie';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Pomocou **gesta priblíženia stiahnutím prstov** môžete fotografiu priblížiť alebo oddialiť:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Pridať';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Najprv zadajte text';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Odstrániť';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Uložte svoju úpravu';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Zrušte svoju úpravu';

  @override
  String get edit_product_form_item_packaging_title =>
      'Fotografia recyklačných pokynov';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Nutričné hodnoty';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Výživa, obsah alkoholu…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Osvedčené postupy: výživové údaje';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Výživové hodnoty';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Najprv vyberte, či sú **hodnoty poskytnuté**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Nutričné hodnoty';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Potom zadajte výživové hodnoty **ako je uvedené na obale**. Ak nie je žiadna hodnota, môžete kliknúť na ikonu \"Oko\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Chýbajúce pole?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Ak niektorý záznam chýba, môžete ho pridať **kliknutím na ikonu „Plus“** (napr.: vitamín D, horčík…).';

  @override
  String get edit_product_form_save => 'Upraviť';

  @override
  String get edit_product_ingredients_photo_title => 'Fotografia zložiek';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Fotografia balenia';

  @override
  String get edit_product_packaging_list_title => 'Zoznam balenia';

  @override
  String get no_data_available => 'Dáta nie sú dostupné';

  @override
  String get product_field_website_title => 'Webová stránka';

  @override
  String get origins_editing_title => 'Upraviť pôvod';

  @override
  String get completed_basic_details_btn_text => 'Kompletné základné detaily';

  @override
  String get not_implemented_snackbar_text => 'Zatiaľ neimplementované';

  @override
  String get category_picker_page_appbar_text => 'Kategórie';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Rozpoznať zložky z fotografie';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Rozpoznať zložky';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Rozpoznávanie zložiek z fotografie';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Načítava sa fotka…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Prečo sa mi zobrazuje táto správa?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Ak chcete použiť funkciu „Rozpoznať zložky“, musíte najprv nahrať fotografiu.\n\nPočkajte niekoľko sekúnd alebo ich zadajte ručne.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Obnoviť fotografiu';

  @override
  String get edit_packaging_extract_btn_text =>
      'Rozpoznať recyklačné pokyny\nz fotografie';

  @override
  String get edit_packaging_extract_btn_text_short => 'Rozpoznať balenie';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Rozpoznať balenie z fotografie';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Načítava sa fotka…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Prečo sa mi zobrazuje táto správa?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Ak chcete použiť funkciu „Rozpoznať balenie“, musíte najprv nahrať fotografiu.\n\nPočkajte niekoľko sekúnd alebo ich zadajte ručne.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Obnoviť fotografiu';

  @override
  String get edit_ocr_extract_failed =>
      'Nepodarilo sa zistiť text z fotografie.';

  @override
  String get edit_ocr_extract_disabled_title => 'Žiadny obrázok!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Ak chcete použiť funkciu extrakcie textu, musíte najprv odfotografovať.';

  @override
  String get user_list_dialog_new_title => 'Nový zoznam produktov';

  @override
  String get user_list_dialog_rename_title => 'Premenovať zoznam';

  @override
  String get user_list_subtitle_product => 'Zoznamy';

  @override
  String get user_list_title => 'Vaše zoznamy';

  @override
  String get user_list_add_product => 'Pridajte produkt do svojich zoznamov';

  @override
  String get user_list_button_new => 'Vytvoriť nový zoznam';

  @override
  String get user_list_empty_label =>
      'Zatiaľ nie je dostupný žiadny zoznam!\nZačnite vytvorením.';

  @override
  String get user_list_button_add_product => 'Pridať do zoznamu';

  @override
  String get added_to_list_msg => 'Pridané do zoznamu';

  @override
  String get user_list_popup_clear => 'Vymazať vašu históriu';

  @override
  String get user_list_popup_rename => 'Premenovať';

  @override
  String get user_list_name_hint => 'Môj zoznam';

  @override
  String get user_list_name_error_empty => 'Názov je povinný';

  @override
  String get user_list_name_error_already => 'Taký názov už existuje';

  @override
  String get user_list_name_error_same => 'To je ten istý názov';

  @override
  String get user_list_name_input_hint => 'Názov zoznamu';

  @override
  String get try_again => 'Skúsiť znova';

  @override
  String get there_was_an_error => 'Došlo k chybe';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Kategória sa nenašla pre $items';
  }

  @override
  String get camera_toggle_camera =>
      'Prepínanie medzi zadným a predným fotoaparátom';

  @override
  String get camera_toggle_flash => 'Zapnite alebo vypnite blesk fotoaparátu';

  @override
  String get camera_enable_flash => 'Povoliť blesk';

  @override
  String get camera_disable_flash => 'Vypnúť blesk';

  @override
  String get camera_flash_error_dialog_title => 'Vyskytla sa chyba!';

  @override
  String get camera_flash_error_dialog_message =>
      'Pri nastavovaní blesku sa vyskytla chyba. Uistite sa, že váš telefón už nemá zapnuté svetlo.';

  @override
  String get category_picker_no_category_found_button => 'Späť';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Kliknutím otvoríte vo svojom prehliadači alebo v aplikácii (ak je nainštalovaná)';

  @override
  String get dev_preferences_screen_title => 'Vývojársky režim';

  @override
  String get dev_preferences_screen_subtitle =>
      'Prístup k experimentálnym funkciám a vývojovým nástrojom';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Reštartujte registráciu';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Potom musíte reštartovať aplikáciu, aby ste ju znova videli.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Prepínajte medzi openfoodfacts.org (PROD) a testovacím prostredím';

  @override
  String get dev_preferences_test_environment_title =>
      'Parametre testovacieho prostredia';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Základná adresa URL pre aktuálne testovacie prostredie: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Hostiteľ testovacieho prostredia';

  @override
  String get dev_preferences_ml_kit_title => 'Použite ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'potom musíte túto aplikáciu reštartovať';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Ďalšie tlačidlo na stránke produktu';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Upravte ingrediencie pomocou tlačidla znalostného panela';

  @override
  String get dev_preferences_export_history_title => 'Exportovať históriu';

  @override
  String get dev_preferences_export_history_progress_error => 'výnimka';

  @override
  String get dev_preferences_export_history_progress_found => 'produkt nájdený';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produkt sa nenašiel';

  @override
  String get dev_preferences_export_history_dialog_title => 'História exportu';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Zrušiť';

  @override
  String get dev_preferences_migration_title => 'Migrácia dát z V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Stav: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'úspech alebo nová inštalácia';

  @override
  String get dev_preferences_migration_status_success => 'hotovo';

  @override
  String get dev_preferences_migration_status_error => 'chyba';

  @override
  String get dev_preferences_migration_status_in_progress => 'rozpracované';

  @override
  String get dev_preferences_migration_status_required =>
      'požadované (kliknutím spustíte)';

  @override
  String get dev_preferences_migration_status_not_started => 'neznámy';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Vymaže históriu a vloží tam 3 produkty';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Vlastná adresa URL pre novinky';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'Adresa URL súboru JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Nenastavené';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Posledná aktualizácia: $date';
  }

  @override
  String get product_type_label_food => 'Potravina';

  @override
  String get product_type_label_beauty => 'Osobná starostlivosť';

  @override
  String get product_type_label_pet_food => 'Krmivo pre domáce zvieratá';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'Typ výrobku';

  @override
  String get product_type_selection_subtitle => 'Vyberte typ tohto produktu';

  @override
  String get product_type_selection_empty =>
      'Najprv musíte vybrať typ produktu!';

  @override
  String product_type_selection_already(String productType) {
    return 'Nemôžete zmeniť typ produktu ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag => 'Odkaz na ceny na stránke produktu';

  @override
  String get prices_app_button => 'Prejdite do sekcie Ceny';

  @override
  String get prices_website_button => 'Otvoriť na webovej stránke Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Pridajte cenovky priamo z galérie';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Po vybratí obrázkov ich už nebudete môcť upravovať!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Umožniť komunite overovať ceny získané umelou inteligenciou.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Viaceré cenovky';

  @override
  String get prices_bulk_proof_upload_title => 'Hromadné nahrávanie potvrdení';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Výber súborov';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Spustenie nahrávania';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Lokálne kopírovanie súboru #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Pripravuje sa nahrávanie #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Zlyhalo na obrázku #$index/$count';
  }

  @override
  String get prices_generic_title => 'Ceny';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pridať $count ceny',
      one: 'Pridať cenu',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pošli $count ceny',
      one: 'Pošli cenu',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Pridať položku';

  @override
  String get prices_add_a_price => 'Pridajte cenu';

  @override
  String get prices_add_a_receipt => 'Pridajte účtenku';

  @override
  String get prices_add_price_tags => 'Pridajte cenovky';

  @override
  String prices_barcode_already(String barcode) {
    return 'Tento čiarový kód ($barcode) je už v zozname!';
  }

  @override
  String get prices_barcode_search_not_found => 'Výrobok sa nenašiel';

  @override
  String get prices_barcode_search_none_yet => 'Žiadny produkt';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Hľadáte $barcode';
  }

  @override
  String get prices_barcode_enter => 'Zadajte čiarový kód';

  @override
  String get prices_category_enter => 'Položka bez čiarového kódu';

  @override
  String get prices_per_kilogram => 'Cena za kilogram';

  @override
  String get prices_per_unit => 'Cena za jednotku';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / jednotka';

  @override
  String get prices_category_mandatory => 'Povinné';

  @override
  String get prices_category_optional => 'Voliteľné';

  @override
  String get prices_category_error_mandatory => 'Kategória je povinná';

  @override
  String get prices_barcode_reader_action => 'Čítačka čiarových kódov';

  @override
  String get prices_view_prices => 'Pozrite si ceny';

  @override
  String get prices_list_title => 'Cenník';

  @override
  String get prices_list_count => 'Počet cien\n';

  @override
  String get prices_list_add_new_price => 'Pridať novú cenu\n';

  @override
  String get prices_list_empty_title => 'Zatiaľ žiadna cena!';

  @override
  String get prices_list_empty_subtitle =>
      'Buďte prvý, kto ho pridá:\nNaskenovaním **účtenky** alebo **cenovky**!';

  @override
  String get prices_entry_shop_not_found => 'Neznámy obchod';

  @override
  String prices_entry_menu_title(String user) {
    return 'Zadaná cena od „$user“';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Zobraziť všetky ceny tohto produktu';

  @override
  String get prices_entry_menu_open_proof => 'Zobraziť dôkaz';

  @override
  String get prices_entry_menu_my_prices => 'Pozrite si moje ďalšie ceny';

  @override
  String get prices_entry_menu_author_prices =>
      'Zobraziť ďalšie ceny od autora';

  @override
  String get prices_entry_menu_shop_prices =>
      'Pozrite si ďalšie ceny z obchodu';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ceny',
      one: '1 cena',
    );
    return '$_temp0 pre $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ceny',
      one: 'Iba jedna cena',
      zero: 'Zatiaľ žiadna cena',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Najnovších $pageSize cien (celkovo: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Cena: $price / Obchod: \"$location\" / Publikované dňa $date používateľom \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Otvoriť potvrdenie od „$user“';
  }

  @override
  String get prices_open_proof => 'Otvoriť potvrdenie o cene';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count potvrdení',
      one: 'Len jedno potvrdenie',
      zero: 'Žiadne potvrdenie',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Najnovších $pageSize potvrdení (celkovo: $total)';
  }

  @override
  String get prices_users_empty_title => 'Zatiaľ žiadny prispievateľ!';

  @override
  String get prices_users_empty_explanation => 'Buďte prvý, kto pridá cenu!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Najlepších $pageSize prispievateľov (celkom: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Zatiaľ žiadny obchod!';

  @override
  String get prices_locations_empty_explanation =>
      'Buďte prvý, kto pridá cenu!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Najlepších $pageSize polôh (celkom: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count potvrdenia',
      one: 'Jedno potvrdenie',
      zero: 'Žiadne potvrdenie',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkty',
      one: 'Jeden produkt',
      zero: 'Žiadny produkt',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count používatelia',
      one: 'Jeden používateľ',
      zero: 'Žiadny používateľ',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ceny',
      one: 'Jedna cena',
      zero: 'Žiadna cena',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Cena bola predtým pridaná';

  @override
  String get prices_amount_subtitle => 'Množstvo';

  @override
  String get prices_amount_is_discounted => 'Je zľavnený?';

  @override
  String get prices_amount_price_normal => 'Cena';

  @override
  String get prices_amount_price_discounted => 'Zvýhodnená cena';

  @override
  String get prices_amount_price_not_discounted => 'Pôvodná cena';

  @override
  String get prices_amount_no_product => 'Chýba jeden produkt!';

  @override
  String get prices_amount_price_incorrect => 'Nesprávna hodnota';

  @override
  String get prices_amount_price_mandatory => 'Povinná hodnota';

  @override
  String get prices_currency_subtitle => 'Mena';

  @override
  String get prices_date_subtitle => 'Dátum';

  @override
  String get prices_location_subtitle => 'Obchod';

  @override
  String get prices_location_find => 'Nájdite obchod';

  @override
  String get prices_location_mandatory => 'Musíte vybrať obchod!';

  @override
  String get prices_location_search_broader =>
      'Nenašli ste, čo ste hľadali? Skúste širšie vyhľadávanie!';

  @override
  String get prices_proof_subtitle => 'Potvrdenie';

  @override
  String get prices_proof_empty_title => 'Zatiaľ žiadny dôkaz!';

  @override
  String get prices_proof_empty_explanation =>
      'Začnite pridaním fotografie **účtenky** alebo **cenovky**!';

  @override
  String get prices_proof_find => 'Vyberte potvrdenie';

  @override
  String get prices_proof_change => 'Dôkaz o zmene';

  @override
  String get prices_proof_receipt => 'Účtenka';

  @override
  String get prices_proof_price_tag => 'Cenovka';

  @override
  String get prices_proof_mandatory => 'Musíte si vybrať potvrdenie!';

  @override
  String get prices_add_validation_error => 'Chyba overenia';

  @override
  String get prices_privacy_warning_title =>
      'Upozornenie na ochranu osobných údajov';

  @override
  String get prices_unknown_product => 'Neznámy produkt';

  @override
  String get prices_privacy_warning_main_message =>
      'Open Food FactsOpen Food FactsCeny **budú verejné** spolu s obchodom, na ktorý sa vzťahujú.\n\nTo by mohlo umožniť ľuďom, ktorí poznajú váš pseudonym Open Food Facts:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Zistite, v ktorej oblasti žijete';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Zistite, čo kupujete';

  @override
  String get prices_privacy_warning_sub_message =>
      'Ak sa vám to nepáči, zmeňte si svoj pseudonym alebo si vytvorte nový účet Open Food Facts a prihláste sa pomocou neho do aplikácie.';

  @override
  String get i_refuse => 'Odmietam';

  @override
  String get i_accept => 'Súhlasím';

  @override
  String get prices_currency_change_proposal_title => 'Zmeniť menu?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Vaša aktuálna mena je **$currency**. Chcete ju zmeniť na **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Áno, použiť $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nie, ponechať $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Hotovo';

  @override
  String get dev_mode_section_server => 'Konfigurácia servera';

  @override
  String get dev_mode_section_news => 'Konfigurácia poskytovateľa noviniek';

  @override
  String get dev_mode_section_product_page => 'Stránka produktu';

  @override
  String get dev_mode_section_ui => 'Používateľské rozhranie';

  @override
  String get dev_mode_section_experimental_features => 'Experimentálne funkcie';

  @override
  String get dev_mode_hide_environmental_score_title => 'Vylúčiť Green Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Použite kontrolu pravopisu pre obrazovky OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingrediencie a balenie)';

  @override
  String get dev_mode_reset_app_language_title => 'Obnoviť jazyk aplikácie';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Pridať karty';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Prepínanie medzi prices.openfoodfacts.org (PROD) a testovacím prostredím';

  @override
  String get search_history_item_edit_tooltip =>
      'Opätovne použite a upravte toto vyhľadávanie';

  @override
  String get search_history_item_remove_tooltip => 'Odstrániť';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Stiahli ste si všetky $totalSize produkty.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Stiahnuť $count viac produktov\nUž stiahnuté $downloaded z $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Vaše vyhľadávanie $search práve prebieha.\n\nPočkajte prosím niekoľko sekúnd…';
  }

  @override
  String get user_search_contributor_title => 'Produkty, ktoré som pridal';

  @override
  String get user_search_informer_title => 'Produkty, ktoré som upravoval';

  @override
  String get user_search_photographer_title => 'Produkty, ktoré som nafotil';

  @override
  String get user_search_to_be_completed_title =>
      'Moje produkty, ktoré sa majú dokončiť';

  @override
  String get user_search_prices_title => 'Moje ceny';

  @override
  String get user_search_proofs_title => 'Moje potvrdenia';

  @override
  String get user_search_proof_title => 'Moje potvrdenie';

  @override
  String search_proof_title(String user) {
    return 'Dôkaz z „$user“';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Ceny prispievateľov: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Najnovšie pridané ceny';

  @override
  String get all_search_prices_top_user_title => 'Najlepší prispievatelia cien';

  @override
  String get all_search_prices_top_location_title => 'Obchody s najviac cenami';

  @override
  String get prices_contribution_assistant => 'Asistent cenového príspevku';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system =>
      'Pridať viacero potvrdení';

  @override
  String get all_search_prices_top_location_single_title => 'Ceny v obchode';

  @override
  String get all_search_prices_top_product_title => 'Produkty s najviac cenami';

  @override
  String get all_search_to_be_completed_title =>
      'Všetky produkty, ktoré sa majú dokončiť';

  @override
  String get categorize_products_country_title =>
      'Pomôžte kategorizovať produkty vo vašej krajine';

  @override
  String get edit_product_action_retake_picture => 'Znova urobte fotografiu';

  @override
  String get edit_product_action_take_picture => 'Urobiť fotku';

  @override
  String get edit_product_action_confirm => 'Potvrdiť';

  @override
  String get signup_page_terms_of_use_line1 => 'Súhlasím s Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'podmienkami používania a prispievaním';

  @override
  String get analytics_consent_image_semantic_label => 'Ikonka Analytics';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Závažná chyba: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Závažná chyba: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Kompletné základné detaily';

  @override
  String get edit_photo_button_label => 'Upraviť';

  @override
  String get edit_photo_unselect_button_label => 'Zrušte výber fotografie';

  @override
  String get edit_photo_select_existing_button_label =>
      'Vyberte existujúci obrázok';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Vyberte obrázok kliknutím naň';

  @override
  String get edit_photo_select_existing_download_label =>
      'Načítavanie existujúcich obrázkov…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Neexistujú žiadne predtým nahrané obrázky súvisiace s týmto produktom.';

  @override
  String get edit_photo_language_not_this_one =>
      'Zatiaľ žiadny obrázok v tomto jazyku';

  @override
  String get edit_photo_language_none => 'Zatiaľ žiadny obrázok';

  @override
  String get category_picker_screen_title => 'Kategórie';

  @override
  String get basic_details => 'Základné detaily';

  @override
  String get product_name => 'Názov produktu';

  @override
  String get product_names => 'Názvy produktov';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Pridať nový preklad';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Pred overením sa uistite, že ste pridali iba preklad **ak je jazyk uvedený na obale**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Zobraziť prednú fotografiu produktu';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Urobte prednú fotografiu produktu';

  @override
  String get add_basic_details_product_name_hint =>
      'Zadajte názov produktu (napr.: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Zmeniť predvolený jazyk?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Chcete, aby bol predvolený jazyk produktu nastavený na „$language“?';
  }

  @override
  String get explanation_section_good_examples => 'Dobré príklady';

  @override
  String get explanation_section_bad_examples => 'Zlé príklady';

  @override
  String get add_basic_details_product_name_help_title =>
      'Osvedčené postupy: názov produktu';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Názov produktu je **hlavný názov vytlačený na obale**. Môže to byť registrovaná ochranná známka.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Poznámka:** Nepridávajte preklad, **ak sa jazyk na obale nenachádza**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Paradajkový kečup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Neuvádzajte značku v názve';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Paradajkový kečup **od Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Nepoužívajte symboly ®, ™, © alebo podobné';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count iné preklady',
      one: '$count iný preklad',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Názov značky';

  @override
  String get brand_names => 'Názvy značiek';

  @override
  String get add_basic_details_brand_name_error => 'Zadajte názov značky';

  @override
  String get add_basic_details_brand_names_hint =>
      'Vstupné značky (napr.: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Osvedčené postupy: značky';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Zadajte **všetky značky produktu**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Hlavná značka';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Hlavnú značku**, vo všeobecnosti jasne zobrazenú na prednom balení, **zadajte ako prvú**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Ostatné značky';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Predávaný **veľkou spoločnosťou**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** predávaný **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Pri predaji so svojou značkou **preložené do viacerých jazykov**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** sa niekedy píše **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Množstvo a hmotnosť';

  @override
  String get add_basic_details_quantity_hint =>
      'Zadajte hmotnosť a v prípade potreby množstvo (napr.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Osvedčené postupy: množstvo';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Skopírujte hodnotu uvedenú na produkte a **nezabudnite na jednotky**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** alebo **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (na 6 vajec)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(pre produkt s 3 škatuľkami, každá po 150 g)';

  @override
  String get barcode => 'Čiarový kód';

  @override
  String barcode_barcode(String barcode) {
    return 'Čiarový kód: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Neplatný čiarový kód';

  @override
  String get basic_details_add_success =>
      'Základné podrobnosti boli úspešne pridané';

  @override
  String get basic_details_add_error =>
      'Nie je možné pridať základné podrobnosti. Skúste to znova po nejakom čase';

  @override
  String get clear_search => 'Vymažte vyhľadávanie';

  @override
  String get confirm_clear =>
      'Chystáte sa vymazať celú históriu. Naozaj chcete pokračovať?';

  @override
  String get alert_clear_selected_user_list =>
      'Chystáte sa vymazať vybraté položky z histórie';

  @override
  String get confirm_clear_selected_user_list =>
      'Ste si istý, že chcete pokračovať?';

  @override
  String get alert_select_items_to_clear =>
      'Vyberte jednu alebo viac položiek na vymazanie';

  @override
  String confirm_clear_user_list(String name) {
    return 'Chystáte sa vymazať tento zoznam ($name): naozaj chcete pokračovať?';
  }

  @override
  String get confirm_delete_user_list_title => 'Odstrániť zoznam?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Chystáte sa odstrániť zoznam \"$name\".\nNaozaj chcete pokračovať?';
  }

  @override
  String get confirm_delete_user_list_button => 'Áno, potvrdzujem';

  @override
  String importance_label(String name, String id) {
    return '$name dôležitosť: $id';
  }

  @override
  String get user_list_all_title => 'Zoznamy';

  @override
  String get user_list_all_empty => 'Vytvorte si svoj prvý zoznam';

  @override
  String get product_list_select => 'Vyberte zoznam';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produktov',
      one: 'Jeden produkt',
      zero: 'Prázdny zoznam',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Pridať zoznam';

  @override
  String get open_food_preferences_tooltip => 'Upraviť potravinové preferencie';

  @override
  String get add_photo_button_label => 'Pridať fotografiu';

  @override
  String get add_packaging_photo_button_label =>
      'Odfoťte akékoľvek informácie o balení/recyklácii';

  @override
  String get add_origin_photo_button_label =>
      'Odfoťte akékoľvek informácie o pôvode';

  @override
  String get add_emb_photo_button_label =>
      'Odfoťte všetky informácie o kóde sledovateľnosti';

  @override
  String get add_label_photo_button_label =>
      'Odfoťte akékoľvek informácie o štítkoch a certifikáciách';

  @override
  String get choose_image_source_title => 'Vyberte zdroj fotografie';

  @override
  String get choose_image_source_body => 'Prosím vyberte zdroj fotografie';

  @override
  String get gallery_source_label => 'Galéria';

  @override
  String get gallery_source_access_denied_dialog_title => 'Prístup zamietnutý';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Žiaľ, aplikácia nemôže získať prístup k vašej galérii, pretože ste predtým odmietli povolenie.\n\nPrejdite do nastavení aplikácie v telefóne Nastavenia -> Fotky';

  @override
  String get gallery_source_access_denied_dialog_button => 'Otvoriť nastavenia';

  @override
  String get share => 'Zdielať';

  @override
  String share_product_text(String url) {
    return 'Pozrite si tento produkt na Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Pozrite si tento produkt na Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Pozrite si tento produkt na Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Pozrite sa na tento produkt v sekcii Fakty o otvorených produktoch: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Pozrite si môj zoznam produktov na Open Food Facts: $url';
  }

  @override
  String get capture => 'Urobte nový obrázok';

  @override
  String get capture_new_picture => 'Odfotiť';

  @override
  String get choose_from_gallery => 'Vybrať z galérie';

  @override
  String get image_upload_queued =>
      'Obrázok bude nahraný na pozadí čo najskôr.';

  @override
  String get add_price_queued => 'Cena bude na server odoslaná čo najskôr.';

  @override
  String get background_task_title_full_refresh =>
      'Spustenie obnovy všetkých lokálne uložených produktov';

  @override
  String get background_task_title_folksonomy =>
      'Spustenie vykonávania akcií servera pre lokálne uložené aktualizácie folksonomy';

  @override
  String get background_task_title_top_n =>
      'Spustenie sťahovania najpopulárnejších produktov';

  @override
  String get expand_nutrition_facts => 'Rozbaliť tabuľku výživových údajov';

  @override
  String get expand_nutrition_facts_body =>
      'Rozbaľovať tabuľku výživových údajov';

  @override
  String get expand_ingredients => 'Rozbaliť zložky';

  @override
  String get expand_ingredients_body => 'Rozbaľovať tabuľku zložiek';

  @override
  String get no_internet_connection => 'Žiadne pripojenie na internet';

  @override
  String get world_results_label => 'Celý svet';

  @override
  String get world_results_action => 'Rozšírte svoje vyhľadávanie na celý svet';

  @override
  String get copy_to_clipboard => 'Kopírovať';

  @override
  String get paste_from_clipboard => 'Vložiť zo schránky';

  @override
  String get no_data_available_in_clipboard =>
      'Vo vašej schránke nie sú dostupné žiadne údaje';

  @override
  String get clipboard_barcode_copy => 'Skopírujte čiarový kód do schránky';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Čiarový kód $barcode bol skopírovaný do schránky!';
  }

  @override
  String get open_product_website => 'Otvorte tento produkt na webovej stránke';

  @override
  String get language_picker_label => 'Váš jazyk';

  @override
  String get country_picker_label => 'Vaša krajina';

  @override
  String get currency_picker_label => 'Vaša mena';

  @override
  String get help_with_openfoodfacts => 'Pomôžte s OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produkt bude aktualizovaný na pozadí čo najskôr.';

  @override
  String get no_email_client_available_dialog_title =>
      'Žiadne emailové aplikácie!';

  @override
  String get no_email_client_available_dialog_content =>
      'Pošlite nám prosím manuálne email na adresu mobile@openfoodfacts.org';

  @override
  String get all_images => 'Všetky obrázky';

  @override
  String get selected_images => 'Vybrané obrázky';

  @override
  String get product_card_remove_product_tooltip => 'Odstrániť výrobok';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nový naskenovaný čiarový kód: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Odstráňte všetky produkty z karuselu';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Naskenujte aspoň dva produkty a porovnajte ich';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Kliknutím porovnajte produkty, ktoré ste naskenovali';

  @override
  String get scan_product_loading => 'Naskenovali ste\nčiarový kód:';

  @override
  String get scan_product_loading_initial =>
      'Hľadáme tento produkt!\nPočkajte prosím niekoľko sekúnd…';

  @override
  String get scan_product_loading_long_request =>
      'Tento produkt stále hľadáme!\nZdá sa vám, že načítanie trvá dlho? Aj nám…';

  @override
  String get scan_product_loading_unresponsive =>
      'Tento produkt stále hľadáme.\nChcete reštartovať vyhľadávanie?';

  @override
  String get scan_product_loading_restart_button => 'Reštartujte vyhľadávanie';

  @override
  String get portion_calculator_description =>
      'Vypočítajte výživové údaje pre konkrétne množstvo';

  @override
  String get portion_calculator_hint => 'Množstvo v';

  @override
  String get portion_calculator_accessibility =>
      'Zadajte množstvo na výpočet výživových údajov';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Zadajte množstvo od $min do $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Chýbajúce údaje. Výpočet nebolo možné vykonať.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Výživové údaje pre $grams g (alebo ml)';
  }

  @override
  String get offline_data => 'Údaje v režime offline';

  @override
  String get ocr_image_upload_instruction =>
      'Nahrajte obrázok, aby sa automaticky rozpoznali informácie, ktoré obsahuje.';

  @override
  String get upload_image => 'Nahrať fotografiu';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Fotografiu sa nepodarilo stiahnuť';

  @override
  String get image_edit_url_error =>
      'Obrázok sa nepodarilo upraviť, pretože adresa URL obrázka nebola nastavená.';

  @override
  String get user_picture_source_remember => 'Zapamätať si voľbu';

  @override
  String get user_picture_source_ask => 'Vždy sa opýtať';

  @override
  String get robotoff_continue => 'Pokračovať';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ďalších $count otázok',
      one: 'Ďalšia otázka',
    );
    return '$_temp0';
  }

  @override
  String get show_password => 'Zobraziť heslo';

  @override
  String get owner_field_info_title => 'Hodnoty poskytnuté výrobcom';

  @override
  String get owner_field_info_message =>
      'Týmto logom zvýrazňujeme údaje poskytnuté výrobcom, ktoré nemusia byť upraviteľné.';

  @override
  String get owner_field_info_close_button => 'Zatvorte tieto informácie';

  @override
  String get owner_field_image =>
      'Túto fotografiu poskytol výrobca. Nemusí sa dať upravovať.';

  @override
  String get edit_packagings_title => 'Komponenty balenia';

  @override
  String get edit_packagings_element_add => 'Pridajte komponent balenia';

  @override
  String get edit_packagings_completed => 'Balenie je kompletné';

  @override
  String edit_packagings_element_title(int index) {
    return 'Zložka obalu #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Počet jednotiek';

  @override
  String get edit_packagings_element_hint_units =>
      'Zadajte počet baliacich jednotiek rovnakého tvaru a materiálu obsiahnutých vo výrobku.';

  @override
  String get edit_packagings_element_field_shape => 'Tvar';

  @override
  String get edit_packagings_element_hint_shape =>
      'Zadajte názov tvaru uvedený v pokynoch na recykláciu, ak sú k dispozícii, alebo vyberte tvar.';

  @override
  String get edit_packagings_element_example_shape => 'Fľaša';

  @override
  String get edit_packagings_element_field_material => 'Materiál';

  @override
  String get edit_packagings_element_hint_material =>
      'Zadajte konkrétny materiál, ak ho možno určiť (kód materiálu vo vnútri trojuholníka možno často nájsť na častiach balenia), alebo všeobecný materiál (napríklad plast alebo kov), ak si nie ste istí.';

  @override
  String get edit_packagings_element_example_material => 'Sklo';

  @override
  String get edit_packagings_element_field_recycling => 'Pokyny na recykláciu';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Pokyny na recykláciu zadávajte iba vtedy, ak sú uvedené na produkte.';

  @override
  String get edit_packagings_element_example_recycling => 'Recyklovať';

  @override
  String get edit_packagings_element_field_quantity =>
      'Čisté množstvo produktu na jednotku';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Zadajte čistú hmotnosť alebo čistý objem a uveďte jednotku (napríklad g alebo ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Hmotnosť jednej prázdnej jednotky (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Pred vážením odstráňte všetky zvyšky potraviny, umyte a osušte časti obalu. Ak je to možné, použite váhu s presnosťou 0,1 g alebo 0,01 g.';

  @override
  String get background_task_title => 'Čakajúce príspevky';

  @override
  String get background_task_subtitle =>
      'Vaše príspevky sa automaticky ukladajú na náš server, ale nie vždy v reálnom čase.';

  @override
  String get background_task_list_empty => 'Žiadne čakajúce úlohy na pozadí';

  @override
  String get background_task_error_server_time_out => 'Časový limit servera';

  @override
  String get background_task_error_no_internet =>
      'Chyba internetového pripojenia. Skúste neskôr.';

  @override
  String get background_task_operation_unknown => 'neznámy typ operácie';

  @override
  String get background_task_operation_details => 'podrobné zmeny';

  @override
  String get background_task_operation_image => 'nahranie fotografie';

  @override
  String get background_task_operation_refresh =>
      'obnovenie oneskorené po odovzdaní fotografie';

  @override
  String get background_task_run_started => 'začaté';

  @override
  String get background_task_run_not_started => 'ešte nezačaté';

  @override
  String get background_task_run_to_be_deleted => 'vymaže sa';

  @override
  String get background_task_question_stop =>
      'Chcete túto úlohu čo najskôr zastaviť?';

  @override
  String get feed_back => 'Spätná väzba';

  @override
  String get undo => 'Vrátiť späť';

  @override
  String get copy_email_to_clip_board => 'Skopírovať email do schránky';

  @override
  String get please_send_us_an_email_to =>
      'Pošlite nám prosím manuálne email na adresu';

  @override
  String get email_copied_to_clip_board => 'Email skopírovaný do schránky!';

  @override
  String get select_accent_color => 'Vyberte farbu zvýraznenia';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Modrá';

  @override
  String get color_cyan => 'Azúrová';

  @override
  String get color_green => 'Zelená';

  @override
  String get color_light_brown => 'Predvolená';

  @override
  String get color_magenta => 'Purpurová';

  @override
  String get color_orange => 'Oranžová';

  @override
  String get color_pink => 'Ružová';

  @override
  String get color_red => 'Červená';

  @override
  String get color_rust => 'Hnedá';

  @override
  String get color_teal => 'Modrozelená';

  @override
  String get text_contrast_mode => 'Kontrast textu';

  @override
  String get contrast_high => 'Vysoký';

  @override
  String get contrast_medium => 'Stredný';

  @override
  String get contrast_low => 'Nízky';

  @override
  String get product_refresher_internet_not_found => 'Produkt nebol nájdený!';

  @override
  String get product_refresher_internet_not_connected =>
      'Nie ste pripojení k internetu!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server nefunguje ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Chyba servera ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produkt nebol nájdený!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Produkt s nasledujúcim čiarovým kódom sa v našej databáze nenachádza: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Žiadne pripojenie na internet!';

  @override
  String get product_loader_network_error_message =>
      'Skontrolujte, či je váš telefón pripojený k sieti Wi-Fi alebo či má povolené mobilné dáta';

  @override
  String get page_not_found_title => 'Stránka nenájdená!';

  @override
  String get page_not_found_button => 'Vráťte sa na domovskú stránku';

  @override
  String get download_data => 'Stiahnuť údaje';

  @override
  String get download_top_products =>
      'Stiahnite si 1000 najlepších produktov vo vašej krajine na okamžité skenovanie';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produktov',
    );
    return 'Stiahnite si naj $_temp0 vo vašej krajine na okamžité skenovanie';
  }

  @override
  String get download_in_progress => 'Sťahovanie údajov\nMôže to chvíľu trvať';

  @override
  String downloaded_products(int num) {
    return 'Pridaných $num produktov';
  }

  @override
  String get update_offline_data => 'Aktualizujte offline produktové údaje';

  @override
  String get update_local_database_sub =>
      'Aktualizujte lokálnu databázu produktov najnovšími údajmi z Open Food Facts';

  @override
  String get clear_local_database =>
      'Vymazať údaje o produktoch offline údaje o produktoch';

  @override
  String get clear_local_database_sub =>
      'Vymažte všetky údaje o produktoch z aplikácie, aby ste uvoľnili miesto';

  @override
  String deleted_products(int num) {
    return '$num produktov odstránených';
  }

  @override
  String get loading => 'Načítavam…';

  @override
  String get know_more => 'Zistiť viac';

  @override
  String get offline_data_desc =>
      'Kliknutím získate viac informácií o offline údajoch';

  @override
  String get offline_product_data_title => 'Offline údaje o produktoch';

  @override
  String available_for_download(int num) {
    return '$num produktov dostupných na okamžité skenovanie';
  }

  @override
  String get country_selector_title => 'Vyberte vašu krajinu:';

  @override
  String get currency_selector_title => 'Vyberte vašu menu:';

  @override
  String get language_selector_title => 'Vyberte váš jazyk:';

  @override
  String get language_selector_section_selected => 'Vybrané jazyky';

  @override
  String get language_selector_section_frequently_used => 'Často používané';

  @override
  String get action_delete_list => 'Vymazať';

  @override
  String get action_change_list => 'Zmeňte aktuálny zoznam';

  @override
  String get product_list_create => 'Vytvoriť';

  @override
  String get product_list_create_tooltip => 'Vytvoriť nový zoznam';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (nový výpočet)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (nový výpočet)';

  @override
  String get nutriscore_unknown => 'Neznáme Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Neznáme Nutri-Score (nový výpočet)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score nie je použiteľné';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score sa nedá použiť (nový výpočet)';

  @override
  String get environmental_score_generic_new => 'Eko-skóre';

  @override
  String get environmental_score_a_new => 'Zelené skóre A';

  @override
  String get environmental_score_b_new => 'Zelené skóre B';

  @override
  String get environmental_score_c_new => 'Zelené skóre C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Zelené skóre E';

  @override
  String get environmental_score_unknown_new => 'Neznáme zelené skóre';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score sa nepoužije';

  @override
  String get nova_group_generic_new =>
      'Ultraspracované potraviny - skupiny NOVA';

  @override
  String get nova_group_1 => 'Skupina NOVA 1';

  @override
  String get nova_group_2 => 'Skupina NOVA 2';

  @override
  String get nova_group_3 => 'Skupina NOVA 3';

  @override
  String get nova_group_4 => 'Skupina NOVA 4';

  @override
  String get nova_group_unknown => 'Neznáma skupina NOVA';

  @override
  String get nutrition_facts => 'Úrovne živín';

  @override
  String get faq_title_partners => 'Partneri a patróni mimovládnej organizácie';

  @override
  String get faq_title_vision =>
      'Open Food Facts vízia, misia, hodnoty a programy';

  @override
  String get faq_title_install_beauty =>
      'Nainštalujte si Open Beauty Facts a vytvorte kozmetickú databázu';

  @override
  String get faq_title_install_pet =>
      'Nainštalujte si Open Pet Food Facts a vytvorte databázu krmiva pre domáce zvieratá';

  @override
  String get faq_title_install_product =>
      'Nainštalujte si fakty o otvorených produktoch na vytvorenie databázy produktov na predĺženie životnosti objektov';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nový výpočet Nutri-Score: čo je nové?';

  @override
  String get contact_title_pro_page =>
      'Profesionál? Importujte svoje produkty do Open Food Facts';

  @override
  String get contact_title_pro_email => 'Kontakt na výrobcu';

  @override
  String get contact_title_press_page => 'Stránka pre média';

  @override
  String get contact_title_press_email => 'Kontakty pre médiá';

  @override
  String get contact_title_newsletter => 'Prihlásiť sa ku odberu noviniek';

  @override
  String get contact_title_calendar =>
      'Prihláste sa na odber nášho komunitného kalendára';

  @override
  String get hunger_games_loading_line1 => 'Venujte nám prosím pár sekúnd…';

  @override
  String get hunger_games_loading_line2 => 'Sťahujeme otázky!';

  @override
  String get hunger_games_error_label =>
      'Ojoj! Niečo sa pokazilo… a otázky sa nám nepodarilo načítať.';

  @override
  String get hunger_games_error_retry_button => 'Skúsme to znova!';

  @override
  String get reorder_attribute_action => 'Zmeňte poradie atribútov';

  @override
  String get link_cant_be_opened =>
      'Tento odkaz nie je možné otvoriť na vašom zariadení. Skontrolujte, či máte nainštalovaný prehliadač.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Podrobnosti pre $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Podrobnosti pre $pageName s $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Zdielať';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Kde nájsť nový výpočet Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score sa používa v 7 krajinách: Francúzsko, Nemecko, Belgicko, Španielsko, Luxembursko, Holandsko a Švajčiarsko.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Výrobcovia majú maximálne **2 roky** od podpisu vyhlášky **na výmenu** starého výpočtu novým.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Eko-skóre';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Čo je to Zelené skóre?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score je logo, ktorého cieľom je informovať vás o **vplyve potravín na životné prostredie**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Farebný kód sa pohybuje od tmavozelenej (**A+**) pre produkty s **najmenej vplyvom** po tmavočervenú (**F**) pre produkty s **najväčším vplyvom**.';

  @override
  String get guide_greenscore_logos_caption => 'Logá Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Jadro: Posúdenie životného cyklu (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Vedecké hodnotenie kategórií potravín';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Pre každú kategóriu produktov sa stanovuje **referenčné** skóre s použitím údajov z environmentálnej databázy Agribalyse (ktorú navrhli ADEME a INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Analýza životného cyklu** je štandardizovaná metóda hodnotenia na vykonávanie viacstupňového a viackriteriálneho environmentálneho hodnotenia.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Merie:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 výrobných krokov';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Balenie';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 ukazovateľov vplyvu na životné prostredie';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Klimatická zmena/uhlíková stopa';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Úbytok ozónovej vrstvy';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ionizujúce žiarenie';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Pozemok';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Spotreba vody a energie';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Znečistenie ovzdušia';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Morská a sladká voda (častice, okysľovanie, eutrofizácia)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Vyčerpanie zdrojov.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonusy a sankcie';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Aby sme odmenili lepšie produkty v rámci kategórie, uplatňujeme **bonusy a penalizácie na základe niekoľkých kritérií**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'Spôsob výroby';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Bonus** sa udeľuje produktom, ktoré majú **oficiálnu etiketu, etiketu alebo certifikáciu, ktorá zaručuje environmentálne prínosy** (bio, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title => 'Pôvod surovín';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Bonus** sa udeľuje na základe pôvodu surovín. Tento bonus zohľadňuje **vplyv na dopravu** a tiež **environmentálnu politiku** krajiny každého výrobcu.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title => 'Ohrozené druhy';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Pokuta** sa udeľuje výrobkom, ktoré obsahujú zložky s významným **negatívnym vplyvom na biodiverzitu a ekosystémy**, ako napríklad palmový olej, ktorého výroba je zodpovedná za masívne odlesňovanie.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Balenie';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'Výška pokuty sa vypočíta s ohľadom na **obehovosť obalov** (použitie recyklovaných surovín a recyklovateľnosť) a nadmerné balenie.';

  @override
  String get guide_greenscore_transparency_title =>
      'Zvýšená potreba transparentnosti na lepšie meranie a znižovanie vplyvov na životné prostredie';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Na presný výpočet Green-Score je potrebné mať **informácie, ktoré nie sú nevyhnutne uvedené na obale** (ako napríklad pôvod a presné percento každej zložky) alebo ktoré sú zriedkavo dostupné v použiteľnej forme (ako napríklad zoznam všetkých zložiek obalu s presným uvedením použitých typov plastov).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Priemerné hodnoty sa používajú, keď tieto informácie ešte nie sú k dispozícii**, ale teraz vyzývame všetkých, aby nám pomohli zhromaždiť tieto informácie, ktoré budú veľmi užitočné pre Green-Score, ale aj pre mnoho ďalších použití.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Ako môžu občania pomôcť?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Všetci občania nám môžu pomôcť zhromaždiť a štruktúrovať informácie, ktoré sú uvedené na výrobkoch alebo ktoré sa z nich dajú odvodiť, ako napríklad informácie o **obaloch**: „Misia Emballages“: rozsiahly kolaboratívny inventár obalov pre všetky potravinárske výrobky (vo francúzštine).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Ako môžu pomôcť výrobcovia';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Výrobcovia nám môžu posielať svoje informácie priamo prostredníctvom našej bezplatnej platformy pre výrobcov.';

  @override
  String get guide_greenscore_better_product_title =>
      'Ktorý produkt je lepší pre planétu?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Môže byť ťažké povedať';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Výber udržateľných potravín je jednou z najsilnejších vecí, ktoré môžeme urobiť pre klímu, pretože **náš globálny potravinový systém je zodpovedný za viac ako štvrtinu všetkých emisií skleníkových plynov**.\n(Zdroj: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Máš moc!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Dobrou správou je, že nám to dáva silný spôsob, ako dosiahnuť zmenu.\n**Každý z nás zje približne 1 000 jedál ročne**. To je 1 000 príležitostí **vybrať si lepšiu budúcnosť pre planétu**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Pomáha byť zodpovedný a rozhodovať sa';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Výber udržateľných potravín sa môže zdať zložitý. Etikety sú mätúce a informácie často chýbajú. Green-Score bol vytvorený, aby to zjednodušil a poskytol vám **jasné**, **vedecky podložené** a **transparentné** environmentálne hodnotenie potravinárskych výrobkov priamo tam, kde ho potrebujete: počas nakupovania.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparentnosť';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Na rozdiel od proprietárnych značiek je výpočet Green-Score **úplne otvorený** a môže ho **overiť ktokoľvek**.';

  @override
  String get guide_nova_title => 'Ultra spracované potraviny';

  @override
  String get guide_nova_what_is_nova_title => 'Čo je ultraprocesovanie?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Skupiny NOVA vás informujú o úrovni spracovania potravín.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Klasifikácia NOVA umožňuje kategorizáciu potravín do **4 skupín** na základe ich **stupňa priemyselného spracovania** (minimálne spracované alebo nespracované potraviny, kulinárske prísady, spracované potraviny, ultraspracované potraviny).';

  @override
  String get guide_nova_logos_caption => 'Logá NOVA';

  @override
  String get guide_nova_groups_title => '4 skupiny NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Existujú 4 skupiny NOVA, pričom problematickou je skupina 4 – Ultraspracované potraviny.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimálne spracované alebo nespracované potraviny';

  @override
  String get guide_nova_groups_arg1_text =>
      'Nespracované (alebo prírodné) potraviny sú **jedlé časti rastlín** (semená, plody, listy, stonky, korene) **alebo zvierat** (svaly, vnútornosti, vajcia, mlieko), ako aj huby, riasy a voda po oddelení od prírody.';

  @override
  String get guide_nova_groups_arg2_title => 'Spracované kulinárske prísady';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Spracované jedlá';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from Group 2 to group 1** Foods. processes include various preservation or cooking methods, and in the case of breads and Cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified Versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra spracované potraviny';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 Food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, Ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. Some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Problémy s ultraprocesovaním';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Extrémne spracovanie potravinárskych zložiek';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Mnohé z nich pochádzajú z **ďalšieho spracovania zložiek potravín**, ako sú hydrogenované alebo interesterifikované oleje, hydrolyzované bielkoviny, izolát sójových bielkovín, maltodextrín, invertný cukor a kukuričný sirup s vysokým obsahom fruktózy.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Prísady, ktoré idú nad rámec čistej bezpečnosti potravín';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Medzi prísady v ultraspracovaných potravinách patria niektoré, ktoré sa používajú aj v spracovaných potravinách, ako sú konzervačné látky, antioxidanty a stabilizátory. Medzi triedy prísad, ktoré sa nachádzajú iba v ultraspracovaných výrobkoch, patria tie, ktoré sa používajú **na napodobnenie alebo zlepšenie senzorických vlastností potravín alebo na zamaskovanie nechutných aspektov konečného výrobku**. Medzi tieto prísady patria farbivá a iné farby, stabilizátory farieb; arómy, zvýrazňovače chuti, necukrové sladidlá; a pomocné látky pri spracovaní, ako sú sýtiace, spevňujúce, objemové a protihrudkujúce látky, odpeňovacie, protihrudkujúce a leštiace látky, emulgátory, sekvestranty a zvlhčovadlá.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Spracovanie, ktoré doma nezvládnete';

  @override
  String get guide_nova_explanations_arg3_text =>
      'Na skombinovanie zvyčajne veľkého množstva zložiek a vytvorenie konečného produktu (odtiaľ „ultra spracovaný“) sa používa **množstvo postupov**. Medzi tieto procesy patrí niekoľko **ktorých neexistuje žiadny domáci ekvivalent**, ako je hydrogenácia a hydrolýza, extrúzia a tvarovanie a predbežné spracovanie na vyprážanie.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Predátorské a finančné aspekty ultraprocesovania';

  @override
  String get guide_nova_explanations_arg4_text =>
      'Celkovým cieľom ultraspracovania je vytvoriť značkové, pohodlné (trvanlivé, pripravené na konzumáciu), atraktívne (hyperchutné) a vysoko ziskové (s nízkonákladovými zložkami) potravinárske výrobky určené na nahradenie všetkých ostatných skupín potravín. Ultraspracované potraviny sú zvyčajne atraktívne balené a intenzívne sa predávajú.';

  @override
  String get guide_nova_explanations_arg5_title => 'Zdravotné riziko';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Od roku 2018 boli vďaka projektu NutriNet-Santé zdôraznené prvé súvislosti medzi **konzumáciou ultraspracovaných potravín a zvýšeným rizikom rakoviny, kardiovaskulárnych ochorení a cukrovky**. Dnes tieto zistenia potvrdzuje viac ako 90 štúdií na celom svete.\nNajsilnejšie súvislosti sa týkajú **obezity, kardiovaskulárnej úmrtnosti a depresívnych symptómov**. U detí sa účinky pozorujú predovšetkým na hmotnosti a nerovnováhe lipidov.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Krajiny odporúčajú ich obmedzenie';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Niektoré krajiny používajú skupiny NOVA pre svoje stravovacie odporúčania alebo ciele, napríklad:\n\n- **🇧🇷 Brazílske** stravovacie odporúčania **odporúčajú obmedziť** konzumáciu spracovaných potravín a vyhýbať sa ultraspracovaným potravinám.\n\n- **🇫🇷 Francúzsko** má za cieľ **znížiť konzumáciu ultraspracovaných potravín skupiny 4 o 20 %**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Vitajte na stránke Otvorené fakty o jedle!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Čo je to Otvorené fakty o jedle?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts je **kolaboratívna**, **bezplatná** a **otvorená** databáza potravinárskych výrobkov z celého sveta.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Veríme, že každý by mal mať prístup k informáciám o tom, čo konzumuje. Zhromažďovaním údajov o zložkách, alergénoch, nutričných hodnotách a ďalších údajoch **posilňujeme spotrebiteľov, aby sa mohli informovane rozhodovať** a posúvame potravinársky priemysel **k väčšej transparentnosti**.';

  @override
  String get guide_open_food_facts_features_title => 'Funkcie Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Dostávajte upozornenia na nežiaduce zložky';

  @override
  String get guide_open_food_facts_tips_title =>
      'Tipy na fotografovanie skvelých fotografií';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Čo nerobiť';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Vyhnite sa tieňom a oslneniu.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Žiadny rozmazaný alebo nezaostrený text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Nevystrihujte časti textu.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Vyhnite sa rušnému pozadiu.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Čo robiť';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Používajte dobré, rovnomerné osvetlenie.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Uistite sa, že text je ostrý a čitateľný.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Zaznamenajte si celý zoznam ingrediencií.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Výrobok uchovávajte na rovnom povrchu.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Pomôžte nám vytvoriť „Wikipédiu jedla“';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Skóre za nutričnú kvalitu';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Skóre, ako sa vyhnúť ultraspracovaným potravinám';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Skóre pre planétu';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-sk.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Vitajte na stránke Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Čo je Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts rozširuje naše poslanie aj na našich chlpatých priateľov! Je to **databáza krmiva pre mačky, psy a iných domácich miláčikov**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Zhromažďujeme informácie o **zložkách**, **nutričnej analýze** a pokynoch na kŕmenie, aby sme majiteľom domácich zvierat pomohli vybrať si najlepšie krmivo pre potreby ich zvierat.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Vlastnosti Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Dostávajte upozornenia na nežiaduce zložky';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Je váš maznáčik alergický na nejaké zložky? Priamo v aplikácii si môžete nastaviť zoznam kozmetických zložiek, ktorým sa chcete vyhnúť!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tipy na fotografovanie skvelých fotografií';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Čo nerobiť';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Vyhnite sa tieňom a oslneniu.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Žiadny rozmazaný alebo nezaostrený text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Nevystrihujte časti textu.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Vyhnite sa rušnému pozadiu.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Čo robiť';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Používajte dobré, rovnomerné osvetlenie.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Uistite sa, že text je ostrý a čitateľný.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Zaznamenajte si celý zoznam ingrediencií.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Výrobok uchovávajte na rovnom povrchu.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'Poznámka k bodovaniu';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Vytvorenie systému hodnotenia krmiva pre domáce zvieratá **nie je momentálne prioritou**. Metodika by bola zložitá, pretože nutričné potreby sa značne líšia v závislosti od druhu, veku a zdravotného stavu. Zatiaľ sme nenašli žiadny nezávislý vedecký tím, ktorý by bol schopný vyvinúť takéto hodnotenie.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-sk.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Vitajte na stránke Otvorené fakty o kráse!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Čo je to Otvorené fakty o kráse?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts je spoločná databáza **kozmetických produktov**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Naším cieľom je rozlúštiť zoznamy zložiek, aby ste **pochopili, čo sa nachádza vo vašich produktoch osobnej starostlivosti**. Od hydratačných krémov až po mejkap zhromažďujeme údaje o zložkách, alergénoch a obaloch s cieľom podporiť transparentnosť v kozmetickom priemysle.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Funkcie Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Dostávajte upozornenia na nežiaduce zložky';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Ste alergický/á na nejaké zložky? Chcete sa vyhnúť komedogénnym látkam? Chcete sa vyhnúť kontroverzným zložkám? Priamo v aplikácii si môžete nastaviť zoznam kozmetických zložiek, ktorým sa chcete vyhnúť!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tipy na fotografovanie skvelých fotografií';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Čo nerobiť';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Vyhnite sa tieňom a oslneniu.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Žiadny rozmazaný alebo nezaostrený text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Nevystrihujte časti textu.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Vyhnite sa rušnému pozadiu.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Čo robiť';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Používajte dobré, rovnomerné osvetlenie.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Uistite sa, že text je ostrý a čitateľný.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Zaznamenajte si celý zoznam ingrediencií.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Ak je fľaša zakrivená, urobte toľko fotiek, koľko potrebujete.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Možno budete musieť odlepiť štítok, aby ste videli zoznam zložiek.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Výrobok uchovávajte na rovnom povrchu.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Poznámka k bodovaniu';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Na rozdiel od potravinárskych výrobkov, svet kozmetiky **nemá všeobecne uznávaný, vládou podporovaný systém hodnotenia ako Nutri-Score**. Účinky zložiek môžu byť veľmi individuálne a závisia od typu pleti, alergií a individuálnych obáv.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-sk.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices je projekt na **zhromažďovanie a zdieľanie cien produktov z celého sveta**. Ide o verejne dostupný súbor údajov, ktorý možno použiť na výskum, analýzu a ďalšie účely. Open Prices vyvíja a spravuje spoločnosť Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Zhromažďujeme súbor údajov o cenách s otvoreným zdrojovým kódom**. Ceny môžu pridávať používatelia prostredníctvom tejto webovej aplikácie alebo prostredníctvom oficiálnej mobilnej aplikácie Open Food Facts. Prispieť môžu aj maloobchodníci alebo aplikácie tretích strán pomocou nášho API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Zbierajte fotografie cenovok v uličkách';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Zbierajte fotografie účteniek';

  @override
  String get guide_open_prices_why_title => 'Prečo to Open Food Facts robí?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Informácie o cenách sú mimoriadne dôležité pre pochopenie potravinových systémov. Sú kľúčovým faktorom pre pochopenie nákladov na potraviny a pre podporu zdravšieho stravovania. Údaje o počiatočných cenách sú spôsob, ako uľahčiť výskumníkom, novinárom a občanom **lepšie pochopenie toho, ako sa ceny potravín menia geograficky a v čase**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Sledujte vývoj cien v priebehu času';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Pozrite sa na **vývoj cien**: zmenšujúca sa inflácia, lacná inflácia, môžeme ich sledovať spoločne!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Porovnajte ceny vo vašom okolí';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Ako budeme dostávať viac cien, môžete nájsť **najlacnejšie obchody vo vašom okolí**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Zvažovali ste zhromaždenie cien z webových stránok predajcov?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Z právnych a technických dôvodov **nepovažujeme získavanie cien z webových stránok maloobchodníkov za platný spôsob prispievania do Open Prices**. Chceme sa uistiť, že ceny, ktoré zhromažďujeme, sú presné a aktuálne, a prijímanie získaných cien od prispievateľov nám to neumožňuje.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Zber údajov o cenách je v budúcej verzii Open Prices zvažovanou možnosťou, ale vykonával by ho samotný Open Prices, aby sme mali dôkaz o cene na základe HTML stránky.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Ceny môžete prispieť pomocou nášho API.\nAk chcete prispieť cenami vo veľkom, kontaktujte nás na adrese prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Vitajte na stránke Otvorené fakty o produktoch!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Čo sú to fakty o otvorených produktoch?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts je rozsiahla otvorená databáza pre **akýkoľvek produkt s čiarovým kódom, ktorý nie je potravinou, kozmetikou ani krmivom pre domáce zvieratá**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Od **elektroniky** po **hračky** a od **oblečenia** po **čistiace prostriedky**, ak má niečo čiarový kód, je možné ho pridať. Cieľom tohto projektu je vytvoriť „internet vecí“ pre predmety každodennej potreby a sprístupniť informácie o nich univerzálne.';

  @override
  String get guide_open_products_facts_features_title =>
      'Funkcie otvorených produktov Fakty';

  @override
  String get guide_open_products_facts_features_text =>
      'Cieľom Open Products Facts je poskytnúť spotrebiteľom možnosť **predĺžiť životnosť predmetov** poskytovaním obehových riešení na údržbu, **opravu**, **recykláciu** ich predmetov alebo im dať nového majiteľa.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Uhlíková stopa niektorých produktov';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Vplyv CO2** od francúzskeho úradu pre životné prostredie ADEME poskytuje **vplyv uhlíka** z mnohých kategórií, uistite sa, že produkty presne kategorizujete.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Index opraviteľnosti pre mnoho produktov';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Vždy, keď bude k dispozícii francúzsky index opraviteľnosti, zobrazíme ho. Okrem toho **môžete začať zhromažďovať premenné pomocou nástroja Folksonomy Engine**, aby sme ho v budúcnosti mohli prepočítať sami, a to aj v krajinách, kde nie je k dispozícii.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Nájdite spôsoby, ako darovať/ďalšie predať svoj produkt';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Poskytujeme odkazy na **služby tretích strán priateľské k obehovému hospodárstvu**, ktoré vám pomôžu získať požadovaný druh produktu, napríklad z druhej ruky, aby sme boli šetrnejší k planetárnym zdrojom.\nUpozorňujeme, že za to nie sme platení a že systém funguje iba ako príklad pre dve webové stránky vo Francúzsku. Môžete pomôcť rozšíriť tento systém zdokumentovaním ďalších stránok na wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Aké informácie sú užitočné?';

  @override
  String get guide_open_products_facts_information_text =>
      'Pre takú širokú škálu položiek sú **údaje, ktoré zhromažďujeme, flexibilné**. Na tento účel sme **vytvorili Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Folksonomický motor';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine je nástroj, ktorý vám pomôže doplniť produkty relevantnými vlastnosťami. To pomáha zlepšiť vyhľadávanie a objaviteľnosť, ale aj vypočítať a zobraziť zaujímavé veci v budúcnosti.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Môžete pridať ľubovoľné kľúče a hodnoty, ako napríklad: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Dostanete automatické návrhy možných vlastností a budete môcť pridávať a dokumentovať nové vlastnosti pre vaše obľúbené druhy produktov.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-sk.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Otvorte preferencie jedál';

  @override
  String get guide_coming_soon_button_title => 'Čoskoro';

  @override
  String get guide_learn_more_subtitle => 'Klepnutím sa dozviete viac';

  @override
  String get preview_badge => 'Náhľad';

  @override
  String get prices_feedback_form =>
      'Kliknite sem a pošlite nám svoj názor na túto novú funkciu!';

  @override
  String get menu_button_list_actions => 'Vybrať akciu';

  @override
  String get error_loading_photo => 'Chyba pri načítavaní fotografie';

  @override
  String get photo_viewer_action_use_picture_as => 'Použite ako…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Použite tento obrázok ako…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Použite tento obrázok ako… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Podrobnosti';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Podrobnosti o tejto fotografii';

  @override
  String get photo_viewer_details_title => 'Podrobnosti o tejto fotografii';

  @override
  String get photo_viewer_details_contributor_title => 'Prispievateľ';

  @override
  String get photo_viewer_details_size_title => 'Veľkosť';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixelov';
  }

  @override
  String get photo_viewer_details_date_title => 'Dátum';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Kompatibilný';

  @override
  String get user_lists_action_multi_select => 'Viacnásobný výber';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Vaše skóre kompatibility: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Predný obrázok';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Obrázok ingrediencií';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Fotografia nutričných hodnôt';

  @override
  String get product_image_packaging_accessibility_label =>
      'Fotografia balenia';

  @override
  String get product_image_other_accessibility_label => 'Ďalšie fotografie';

  @override
  String get product_image_outdated_message =>
      'Táto fotografia môže byť neaktuálna';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (táto fotografia môže byť neaktuálna)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (táto fotografia môže byť uzamknutá výrobcom)';
  }

  @override
  String get product_image_error => 'Chyba počas načítania obrázka!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Nedá sa načítať $type (chyba siete?)';
  }

  @override
  String get product_page_image_no_image_available => 'Žiadny obrázok!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Pre tento produkt nie je k dispozícii žiadna fotografia';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Zmeňte poradie alebo skryte akcie';

  @override
  String get product_page_action_bar_setting_modal_title => 'Upraviť akcie';

  @override
  String get product_page_action_bar_item_move_up => 'Posunúť nahor';

  @override
  String get product_page_action_bar_item_move_down => 'Posunúť nadol';

  @override
  String get product_page_action_bar_item_enable => 'Povoliť akciu';

  @override
  String get product_page_action_bar_item_disable => 'Zakázať akciu';

  @override
  String get product_page_pending_operations_banner_title =>
      'Nahrávajú sa vaše úpravy…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Údaje zobrazené na tejto stránke **zatiaľ neodrážajú vaše úpravy**.\nPočkajte prosím niekoľko sekúnd…';

  @override
  String get product_add_a_language => 'Pridať jazyk';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Čiarový kód $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Odstráňte tento produkt z karuselu';

  @override
  String get carousel_unsupported_header => 'Nepodporovaný čiarový kód!';

  @override
  String get carousel_unsupported_title => 'Ojoj!';

  @override
  String get carousel_unsupported_text =>
      'Naskenovaný čiarový kód je nepodporovaný Open Food Facts!';

  @override
  String get carousel_error_header => 'Chyba!';

  @override
  String get carousel_error_title => 'Je to trapas!';

  @override
  String get carousel_error_text_1 =>
      'Nepodarilo sa nám stiahnuť informácie o tomto čiarovom kóde:';

  @override
  String get carousel_error_text_2 =>
      'Skontrolujte svoje internetové pripojenie alebo kliknite na toto tlačidlo:';

  @override
  String get carousel_error_button => 'Skúsiť znova';

  @override
  String get carousel_unknown_product_header => 'Neznámy produkt';

  @override
  String get carousel_unknown_product_title =>
      'Gratulujem!\nNašli ste __vzácny drahokam!__';

  @override
  String get carousel_unknown_product_text =>
      'Naša databáza obsahuje viac ako **3 milióny produktov**, ale tento čiarový kód v nej neexistuje: ';

  @override
  String get carousel_unknown_product_button => 'Pridať tento výrobok';

  @override
  String get carousel_loading_header => 'Načítavajú sa informácie…';

  @override
  String get carousel_loading_title =>
      'Práve ste naskenovali produkt s nasledujúcim čiarovým kódom:';

  @override
  String get carousel_loading_text =>
      'Hľadáme ho v našej databáze viac ako **3 miliónov produktov!**';

  @override
  String get product_type_subtitle_food =>
      'Zelenina, ovocie, mrazené potraviny…';

  @override
  String get product_type_subtitle_beauty => 'Make-up, mydlá, zubné pasty…';

  @override
  String get product_type_subtitle_pet_food => 'Krmivo pre psov, mačky…';

  @override
  String get product_type_subtitle_product => 'Telefóny, nábytok…';

  @override
  String get photo_field_front => 'Fotografia produktu';

  @override
  String get photo_field_ingredients => 'Fotografia zložiek';

  @override
  String get photo_field_nutrition => 'Fotografia nutričných hodnôt';

  @override
  String get photo_field_packaging => 'Fotografia recyklačných pokynov';

  @override
  String get photo_already_exists => 'Táto fotografia už existuje';

  @override
  String get photo_missing => 'Táto fotografia chýba';

  @override
  String get date => 'Dátum';

  @override
  String get photo_rotate_left => 'Otočiť doľava';

  @override
  String get photo_rotate_right => 'Otočiť doprava';

  @override
  String get photo_undo_action => 'Vráťte predchádzajúcu akciu späť';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Mapa sveta $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Prispievatelia OpenStreetMap';

  @override
  String get not_applicable_short => 'Nie je k dispozícii';

  @override
  String get knowledge_panel_warning_text => 'Upozornenie';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Prečo sa toto Nutri-Score líši od toho na obale?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Existujú dve možné vysvetlenia:\nZoznam zložiek a/alebo výživových údajov nie je aktuálny.\n\nPoskytujeme \"Nový výpočet\" pre Nutri-Score (alebo V2). Skontrolujte prosím, či máte na balíku informáciu \"Nová výpočet\".';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Skontrolujte zložky';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Skontrolujte výživové údaje';

  @override
  String url_not_supported(String url) {
    return 'Bohužiaľ nemôžeme otvoriť adresu URL:\n$url';
  }

  @override
  String get product_list_export => 'Exportovať';

  @override
  String get product_list_import => 'Importovať';

  @override
  String get product_footer_action_barcode => 'Zobraziť čiarový kód';

  @override
  String get product_footer_action_barcode_short => 'Čiarový kód';

  @override
  String get product_footer_action_open_website => 'Prejsť na webovú stránku';

  @override
  String get product_footer_action_report => 'Nahlásiť';

  @override
  String get product_footer_action_contributor_guide => 'Pomoc';

  @override
  String get product_footer_action_data_quality_tags => 'Kvalita údajov';

  @override
  String get product_page_tab_for_me => 'Pre mňa';

  @override
  String get product_page_tab_website => 'Webová stránka';

  @override
  String get product_page_tab_prices => 'Ceny';

  @override
  String get prices_explanation_card_title => 'Prečo ceny?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** je projekt na zhromažďovanie a zdieľanie cien produktov z celého sveta 🌍. Open Prices vyvíja a spravuje spoločnosť Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Zistiť viac';

  @override
  String get product_page_tab_folksonomy => 'Folksonomia';

  @override
  String get folksonomy_explanation_card_title =>
      'Aké sú atribúty folksonomie?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atribúty sú založené na **kľúč-hodnota**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Tieto vlastnosti vytvárajú a ukladajú prispievatelia pre akékoľvek použitie.';

  @override
  String get folksonomy_action_external_link_title => 'Otvoriť externý odkaz';

  @override
  String get folksonomy_action_external_link_warning =>
      'Externé odkazy môžu byť nebezpečné. Naozaj to chcete navštíviť?';

  @override
  String get prices_products_empty_title => 'Nie je k dispozícii žiadna cena';

  @override
  String get prices_products_empty_explanation => 'Buďte prvý, kto prispeje!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Naj $pageSize produktov (celkom: $total)';
  }

  @override
  String get app_review_title => 'Páči sa vám táto aplikácia?';

  @override
  String get app_review_low => 'Mohlo by to byť lepšie';

  @override
  String get app_review_medium => 'Nie je to zlé';

  @override
  String get app_review_high => 'Milujem to!';

  @override
  String get app_review_feedback_modal_title =>
      'Pomôžte nám zlepšiť našu aplikáciu';

  @override
  String get app_review_feedback_modal_content =>
      'Ak máte pár minút, mohli by ste odpovedať na tento formulár, aby sme sa **mohli zlepšiť v budúcich aktualizáciách**:';

  @override
  String get app_review_feedback_modal_open_form => 'Vyplniť formulár';

  @override
  String get app_review_feedback_modal_later => 'Opýtajte sa ma neskôr';

  @override
  String get nutrition_facts_extract_new =>
      'Novinka: Môžete automaticky rozpoznať výživové údaje z obrázka!';

  @override
  String get nutrition_facts_extract_button_text => 'Rozpoznajte teraz';

  @override
  String get nutrition_facts_extract_in_progress => 'Prebieha extrakcia…';

  @override
  String get nutrition_facts_extract_successful => 'Extrakcia úspešná';

  @override
  String get nutrition_facts_extract_failed =>
      'Nepodarilo sa rozpoznať výživové údaje z obrázka';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Štatistika';

  @override
  String get prices_stats_title => 'Štatistika cien';

  @override
  String get prices_stats_prices_section => 'Ceny';

  @override
  String get prices_stats_products_section => 'Výrobky';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Prispievatelia';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Rôzne';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Potravina';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Výrobky';

  @override
  String get prices_stats_pet_food => 'Krmivo pre domáce zvieratá';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Krajiny';

  @override
  String get prices_stats_price_tag => 'Cenovka';

  @override
  String get prices_stats_receipt => 'Účtenka';

  @override
  String get prices_stats_gdpr_request => 'žiadosť GDPR';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Webová stránka';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'Naposledy aktualizované';

  @override
  String get prices_stats_error =>
      'Pri načítavaní štatistík sa vyskytla chyba.';

  @override
  String get product_edit_robotoff_question_answered => 'Otázka zodpovedaná!';

  @override
  String get product_edit_robotoff_proof => 'Potvrdenie';

  @override
  String get preferences_card_general => 'Všeobecné';

  @override
  String get preferences_prices_title => 'Ceny';

  @override
  String get preferences_prices_subtitle =>
      'Spravujte svoje cenové preferencie';

  @override
  String get preferences_card_project => 'Projekt Otvorené fakty o jedle';

  @override
  String get preferences_contribute_title => 'Prispieť';

  @override
  String get preferences_my_contributions_title => 'Moje prispevky';

  @override
  String get preferences_my_stats_title => 'Moje štatistiky';

  @override
  String get preferences_contribute_subtitle =>
      'Prekladajte, vylepšite naše nástroje…';

  @override
  String get preferences_connect_title => 'Pripojiť';

  @override
  String get preferences_connect_subtitle =>
      'Kontaktujte nás alebo nás sledujte na sociálnych sieťach';

  @override
  String get preferences_support_title => 'Prispieť';

  @override
  String get preferences_support_subtitle =>
      'Pomôžte nám informovať milióny spotrebiteľov na celom svete';

  @override
  String get preferences_card_help => 'Pomoc a podpora';

  @override
  String get preferences_faq_title => 'Často kladené otázky';

  @override
  String get preferences_faq_subtitle => 'Získajte odpovede na svoje otázky';

  @override
  String get logged_out => 'Odhlásený/á';

  @override
  String get preferences_app_bar_message =>
      'Ďakujeme, že ste jedným z našich členov!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Zobraziť všetky štatistiky';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Hľadať $provider pre výraz „$keyword“';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Vyhľadajte nastavenie (napr. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Prístupnosť: Zobraziť emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Prístupnosť: Odstrániť farby';

  @override
  String get preferences_app_settings_products => 'Výrobky';

  @override
  String get preferences_card_about => 'O';

  @override
  String get preferences_legal_information_title => 'Právne informácie';

  @override
  String get preferences_legal_information_subtitle =>
      'Podmienky používania, zásady ochrany osobných údajov a ďalšie';

  @override
  String get preferences_terms_of_use => 'Podmienky používania';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts je databáza potravinových výrobkov **vytvorená každým, pre každého**.\nMôžete ju použiť na lepšie rozhodnutia ohľadom potravín a keďže ide o **otvorené dáta**, ktokoľvek ich môže **znovu použiť na akýkoľvek účel**.';

  @override
  String get preferences_privacy_policy => 'Zásady ochrany osobných údajov';

  @override
  String get preferences_licenses => 'Licencie';

  @override
  String get preferences_about_app_title => 'O aplikácii';

  @override
  String get preferences_about_app_subtitle =>
      'Technické informácie, informácie pre vývojárov a ďalšie';

  @override
  String get preferences_card_information => 'Informácia';

  @override
  String get preferences_version_number_title => 'Číslo verzie';

  @override
  String get preferences_scanner_title => 'Skener';

  @override
  String get preferences_app_store => 'Obchod s aplikáciami';

  @override
  String get preferences_app_system_settings => 'Systémové nastavenia';

  @override
  String get preferences_source_code => 'Prístup k zdrojovému kódu';

  @override
  String get preferences_source_code_subtitle =>
      'A začnite pôsobiť na milióny ľudí';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Dokončite produkty';

  @override
  String get preferences_tips => 'Tipy';

  @override
  String get tips_discover_nutriscore => 'Objavte nový Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Na webovej stránke Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Spravovať môj účet';

  @override
  String get preferences_manage_account_tooltip => 'Spravujte svoj účet';

  @override
  String get preferences_change_password_title => 'Zmeniť moje heslo';

  @override
  String get preferences_danger_zone => 'Nebezpečná zóna';

  @override
  String get preferences_account_deletion_subtitle =>
      'Všetky vaše príspevky budú stratené';

  @override
  String get preferences_contributions_title => 'Príspevky';

  @override
  String get preferences_dev_mode_app_settings_title => 'Nastavenia aplikácie';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Veľmi experimentálny spôsob skenovania produktov offline';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Obnoviť všetky produkty zo servera';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Prosím, vyhnite sa tomu, pokiaľ to nie je absolútne nevyhnutné';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demo režim';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Pridajte karty do skenera';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Pridá do skenera 3 vzorové produkty';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Hostiteľ folksonomie';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Hostiteľ: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Experimenty s prístupnosťou';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Výber viacerých produktov za rôzne ceny';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Používateľom zoradené znalostné panely';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Dočasný prístup k vyhľadávaniu polohy';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Porovnanie 2 alebo 3 produktov vedľa seba';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Import zoznamu produktov';

  @override
  String get preferences_faq_scores_methodologies_title => 'Skóre a metodiky';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Zistite, ako sa vypočítava Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Objavte hlavné zmeny v metodike';

  @override
  String get preferences_faq_discover_project_title => 'Objavte projekt';

  @override
  String get preferences_faq_discover_off_title =>
      'Objavte fakty o otvorenom jedle';

  @override
  String get preferences_faq_discover_obf_title =>
      'Objavte fakty o otvorenej kráse';

  @override
  String get preferences_faq_discover_opff_title =>
      'Objavte fakty o krmive pre domáce zvieratá na Open Pet Food';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Objavte fakty o otvorených produktoch';

  @override
  String get preferences_faq_faq_title =>
      'Často kladené otázky - Často kladené otázky';

  @override
  String get preferences_faq_off_ngo_title =>
      'Mimovládna organizácia Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informácia';

  @override
  String get preferences_connect_community_updates_title =>
      'Získajte aktualizácie komunity';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Zostaňte v obraze s novinkami z aplikácie a komunity';

  @override
  String get preferences_connect_community_calendar_title =>
      'Prihláste sa na odber nášho komunitného kalendára';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Zapojte sa účasťou na jednom z našich virtuálnych podujatí';

  @override
  String get preferences_connect_blog_title => 'Blog Otvorené fakty o jedle';

  @override
  String get preferences_connect_blog_subtitle =>
      'Získajte najnovšie správy hneď, ako sa dejú';

  @override
  String get preferences_connect_community_help_title =>
      'Získajte pomoc od komunity';

  @override
  String get preferences_connect_improve_app_title =>
      'Pomôžte nám vylepšiť aplikáciu';

  @override
  String get preferences_connect_debug_info_title =>
      'Pošlite nám informácie o ladení';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Pošlite nám e-mail s podrobnými informáciami o ladení';

  @override
  String get preferences_connect_feedback_title =>
      'Pošlite nám spätnú väzbu k aplikácii';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Pomôžte formovať budúcnosť aplikácie';

  @override
  String get preferences_connect_survey_title =>
      'Zúčastnite sa prieskumu aplikácie';

  @override
  String get preferences_connect_survey_subtitle =>
      'Pomôžte nám pochopiť, čo by sme mali ďalej budovať';

  @override
  String get preferences_connect_professionals_title => 'Profesionáli';

  @override
  String get preferences_connect_pro_subtitle =>
      'Úplne zadarmo, zaisťuje presné údaje pre 500 aplikácií a milióny spotrebiteľov. Samoobsluha, kompatibilná s vaším PIM alebo tabuľkami (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Kontaktujte nás a začnite';

  @override
  String get preferences_connect_press_title => 'Média';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Získajte všetky materiály, ktoré potrebujete pre svoju správu';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Kontaktujte nás v prípade tlačových otázok alebo ak chcete informovať o svojej správe';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Staňte sa aktívnym dobrovoľníkom';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Vývoj, komunikácia, dizajn… akýkoľvek druh dobrovoľníctva alebo odbornosti je vítaný!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Objavte niektoré z mnohých spôsobov, ako môžete prispieť';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Vývoj mobilných aplikácií';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Naučte sa, ako prispieť k vývoju softvéru';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Denne nestabilné zostavenia, úplne nové funkcie';

  @override
  String get preferences_contribute_local_community_title =>
      'Rozvíjajte svoju miestnu komunitu';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Pomoc so softvérom, obsahom a prekladmi analýz zložiek';

  @override
  String get preferences_contribute_share_subtitle =>
      'Pripravili sme pre vás malú šablónu, ktorá vám s tým pomôže :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Jednoduché kroky k zvýšeniu transparentnosti potravín vo vašej krajine';

  @override
  String get preferences_contribute_data_quality_title => 'Kvalita údajov';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Pridajte sa k tímu pre kvalitu údajov';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Pridajte sa k nášmu úsiliu zabezpečiť, aby databáza bola úplná a presná';

  @override
  String get preferences_contributions_products_added_title =>
      'Pridané produkty';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nové produkty, ktoré som pridal do Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produkty, ktoré potrebujem dokončiť';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Všetky neúplné produkty';

  @override
  String get preferences_my_contributions_prices_title => 'Ceny';

  @override
  String get preferences_my_contributions_my_prices_title => 'Moje ceny';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Moje ceny, moje dôkazy…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produkty, ktoré môžete pomôcť dokončiť';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Pomôžte vypočítať Nutri-Score a Green-Score vo vašej krajine';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Ceny, ktoré som prispel/a';

  @override
  String get preferences_prices_proofs_subtitle => 'Cenovky a účtenky';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Odfoťte si účtenky a naskenujte príslušné čiarové kódy';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Odfoťte si ceny v obchode';

  @override
  String get preferences_prices_newest_title => 'Najnovšie ceny';

  @override
  String get preferences_prices_newest_subtitle =>
      'Najnovšie ceny pridané komunitou Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Prispievatelia s najvyššími cenami';

  @override
  String get preferences_prices_metrics_title => 'Metriky otvorenej ceny';

  @override
  String get preferences_prices_metrics_subtitle => 'Sledujte vývoj projektu';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Spôsoby, ako prispieť';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Potvrďte ceny, ktoré ste pridali vy alebo iní, pomocou umelej inteligencie';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Rýchlo pridajte viacero účteniek alebo fotografií políc z vášho fotoaparátu';

  @override
  String get preferences_prices_challenges_title => 'Mesačné výzvy';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Zúčastnite sa mesačných tematických úloh a zbierajte ceny';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Získajte späť svoje údaje o vernostnom programe';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Zistite, ako požiadať o svoje údaje';

  @override
  String get preferences_page_customize_app_title => 'Prispôsobte si aplikáciu';

  @override
  String get preferences_page_contribute_project_title =>
      'Prispejte k projektu';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Jednoduché spôsoby, ako pomôcť Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodiky hodnotenia, pomoc a ďalšie informácie o projekte';

  @override
  String get product_edit_robotoff_positive_button => 'Prijať návrh';

  @override
  String get product_edit_robotoff_negative_button => 'Odmietnuť návrh';

  @override
  String get product_edit_robotoff_show_proof => 'Ukázať dôkaz';

  @override
  String get product_edit_robotoff_expand_proof => 'Rozbaliť dôkaz';

  @override
  String get product_page_tab_raw_data => 'Nespracované údaje';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Strana $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Strana $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count z $total položiek';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count z $total položiek';
  }

  @override
  String item_count(int count) {
    return '$count položiek';
  }

  @override
  String item_count_string(String count) {
    return '$count položiek';
  }

  @override
  String get prices_no_result => 'Nenašli sa žiadne cenové štatistiky.';

  @override
  String get prices_error_loading_more_items =>
      'Chyba pri načítavaní ďalších položiek';

  @override
  String get prices_proof_error =>
      'Overenie zlyhalo, nepodarilo sa načítať dôkazy';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count z $total dôkazov';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count z $total prispievateľov';
  }

  @override
  String contributors_count(int count) {
    return '$count prispievateľov';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count z $total lokalít';
  }

  @override
  String prices_locations_count(int count) {
    return '$count lokalít';
  }

  @override
  String get restart_to_apply_message =>
      'Reštartujte aplikáciu, aby sa zmeny prejavili.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafické rozhranie';

  @override
  String get preferences_app_settings_media_title => 'Médiá';

  @override
  String get preferences_about_app_development_title => 'Vývoj';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Otvorené laboratóriá faktov o potravinách';

  @override
  String get preferences_root_account_title => 'Účet';

  @override
  String get preferences_contribute_translate_header =>
      'Prineste fakty o otvorených potravinách do svojho jazyka';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Zaregistrujte sa do alfa verzie aplikácie';

  @override
  String get preferences_dev_mode_section_data =>
      'Príspevky a údaje o produktoch';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Nezobrazovať folksonomiu';

  @override
  String get preferences_account_title => 'Účet';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Pridané dňa $created';
  }

  @override
  String get location_map_details_title => 'Podrobnosti o polohe';

  @override
  String get location_map_details_name => 'Názov';

  @override
  String get location_map_details_street => 'Ulica';

  @override
  String get location_map_details_city => 'Mesto';

  @override
  String get location_map_details_postcode => 'PSČ';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Súradnice';

  @override
  String get location_map_details_osm_id => 'ID OSM';
}
