// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Russian (`ru`).
class AppLocalizationsRu extends AppLocalizations {
  AppLocalizationsRu([String locale = 'ru']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Да';

  @override
  String get add => 'Добавить';

  @override
  String get account_delete_message =>
      'Вы уверены, что хотите удалить свой аккаунт?\nЕсли есть конкретная причина, пожалуйста, поделитесь ею ниже';

  @override
  String get reason => 'Причина';

  @override
  String get okay => 'Окей';

  @override
  String get validate => 'Подтвердить';

  @override
  String get create => 'Создать';

  @override
  String get applyButtonText => 'Применить';

  @override
  String get next_label => 'Следующий';

  @override
  String get continue_label => 'Продолжить';

  @override
  String get exit_label => 'Выход';

  @override
  String get previous_label => 'Предыдущая';

  @override
  String get go_back_to_top => 'Вернуться к началу';

  @override
  String get save => 'Сохранить';

  @override
  String get save_confirmation => 'Вы уверены, что хотите сохранить?';

  @override
  String get skip => 'Пропустить';

  @override
  String get cancel => 'Отмена';

  @override
  String get ignore => 'Пропустить';

  @override
  String get close => 'Закрыть';

  @override
  String get no => 'Нет';

  @override
  String get stop => 'Стоп';

  @override
  String get finish => 'Готово';

  @override
  String get calculate => 'Рассчитать';

  @override
  String get reset_food_prefs => 'Сбросить настройки предпочтений';

  @override
  String get error => 'Упс... что-то пошло не так';

  @override
  String get error_occurred => 'Произошла ошибка';

  @override
  String get featureInProgress =>
      'Мы все еще работаем над этой функцией, следите за обновлениями';

  @override
  String get label_web => 'Посмотреть в Интернете';

  @override
  String get learnMore => 'Узнать больше';

  @override
  String get unknown => 'Неизвестный';

  @override
  String get match_very_good => 'Очень хорошо подходит';

  @override
  String get match_good => 'Хорошо подходит';

  @override
  String get match_poor => 'Плохо подходит';

  @override
  String get match_may_not => 'Может не подходить вам';

  @override
  String get match_does_not => 'Продукт не совместим';

  @override
  String get match_unknown => 'Неизвестное совпадение';

  @override
  String get match_short_very_good => 'Очень хорошо подходит';

  @override
  String get match_short_good => 'Хорошо подходит';

  @override
  String get match_short_poor => 'Плохо подходит';

  @override
  String get match_short_may_not => 'Может не подходить вам';

  @override
  String get match_short_does_not => 'Продукт не совместим';

  @override
  String get match_short_unknown => 'Неизвестное совпадение';

  @override
  String get licenses => 'Лицензии';

  @override
  String get looking_for => 'Я ищу';

  @override
  String get welcomeToOpenFoodFacts => 'Добро пожаловать в Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts — это глобальная некоммерческая организация, основанная местными сообществами.';

  @override
  String get productDataUtility =>
      'Смотрите данные о еде, соответствующие вашим предпочтениям.';

  @override
  String get healthCardUtility =>
      '▶ Выбирайте продукты, которые полезны для вас.';

  @override
  String get ecoCardUtility => 'Выбирайте продукты, полезные для планеты.';

  @override
  String get server_error_open_new_issue =>
      'Нет ответа сервера! Вы можете открыть проблему по следующей ссылке.';

  @override
  String get sign_in_text =>
      'Войдите в свою учетную запись Open Food Facts, чтобы сохранить свои взносы';

  @override
  String get incorrect_credentials => 'Неверное имя пользователя или пароль.';

  @override
  String get password_lost_incorrect_credentials =>
      'Этот адрес электронной почты или имя пользователя не существует. Проверьте свои учетные данные.';

  @override
  String get password_lost_server_unavailable =>
      'В настоящее время мы испытываем замедление работы наших серверов и приносим извинения за это. Пожалуйста, попробуйте еще раз позже.';

  @override
  String get login => 'Имя пользователя';

  @override
  String get login_result_type_server_unreachable => 'Сеть недоступна';

  @override
  String get login_result_type_server_issue =>
      'Проблема на сервере. Попробуйте позже.';

  @override
  String get login_page_username_or_email =>
      'Пожалуйста, введите имя пользователя или e-mail';

  @override
  String get login_page_password_error_empty => 'Введите пароль';

  @override
  String get create_account => 'Создать учётную запись';

  @override
  String get sign_in => 'Войти';

  @override
  String get sign_in_mandatory =>
      'Для использования этой функции вам надо войти в систему.';

  @override
  String get help_improve_country =>
      'Помогите улучшить Open Food Facts в вашей стране';

  @override
  String get sign_out => 'Выйти';

  @override
  String get sign_out_confirmation =>
      'Вы действительно хотите выйти из учётной записи?';

  @override
  String get password => 'Пароль';

  @override
  String get forgot_password => 'Не помню пароль';

  @override
  String get forgot_password_question => 'Забыли пароль?';

  @override
  String get view_profile => 'Профиль';

  @override
  String get reset_password => 'Сброс пароля';

  @override
  String get reset_password_explanation_text =>
      'В случае утраты пароля, введите имя пользователя или адрес электронной почты, чтобы получить инструкции по сбросу пароля. Не забудьте проверить папку \"Спам\".';

  @override
  String get username_or_email => 'Имя пользователя или e-mail';

  @override
  String get reset_password_done =>
      'Письмо ссылкой для сброса пароля было отправлено на вашу электронную почту. Не забудьте проверить папку \"Спам\"';

  @override
  String get send_reset_password_mail => 'Сменить пароль';

  @override
  String get enter_some_text => 'Пожалуйста, заполните это поле';

  @override
  String get sign_up_page_title => 'Зарегистрироваться';

  @override
  String get sign_up_page_action_button => 'Зарегистрироваться';

  @override
  String get sign_up_page_action_doing_it => 'Регистрация…';

  @override
  String get sign_up_page_action_ok =>
      'Поздравляем! Ваша учётная запись успешно зарегистрирована.';

  @override
  String get sign_up_page_display_name_hint => 'Название';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Пожалуйста, введите имя пользователя';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty =>
      'Введите адрес электронной почты';

  @override
  String get sign_up_page_email_error_invalid => 'Неверный e-mail';

  @override
  String get sign_up_page_username_hint => 'Имя пользователя: Общедоступно';

  @override
  String get sign_up_page_username_error_empty => 'Введите имя пользователя';

  @override
  String get sign_up_page_username_error_invalid =>
      'Пожалуйста, введите корректное имя пользователя';

  @override
  String get sign_up_page_username_description =>
      'Имя пользователя не может содержать пробелы, заглавные буквы или специальные символы.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Имя пользователя не может быть длиннее $value символов';
  }

  @override
  String get sign_up_page_password_hint => 'Пароль';

  @override
  String get sign_up_page_password_error_empty => 'Введите пароль';

  @override
  String get sign_up_page_password_error_invalid =>
      'Пароль должен содержать не менее 6 символов';

  @override
  String get sign_up_page_confirm_password_hint => 'Подтвердите пароль';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Пожалуйста, подтверлите пароль';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Пароли не совпадают';

  @override
  String get sign_up_page_agree_text => 'Я согласен с Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'условия использования и вклад';

  @override
  String get donate_url =>
      'https://world-ru.openfoodfacts.org/pozhertvovat-open-food-facts';

  @override
  String get sign_up_page_agree_error_invalid =>
      'При создании учетной записи согласие с Условиями использования является обязательным, однако анонимные взносы по-прежнему можно делать через приложение';

  @override
  String get sign_up_page_producer_checkbox =>
      'Я производитель продуктов питания';

  @override
  String get sign_up_page_producer_hint => 'Производитель/марка';

  @override
  String get sign_up_page_producer_error_empty =>
      'Пожалуйста, введите производителя или название марки';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Я хотел бы подписаться на рассылку Open Food Facts (Вы можете отказаться от рассылки в любое время)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Имя пользователя уже существует, пожалуйста выберите другое имя.';

  @override
  String get sign_up_page_email_already_exists =>
      'уже существует, войдите в учётную запись или попробуйте другой адрес электронной почты.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Пожалуйста, укажите действующий адрес электронной почты.';

  @override
  String get sign_up_page_server_busy =>
      'К сожалению, при создании учётной записи возникли технические трудности. Пожалуйста, повторите попытку позже.';

  @override
  String get settingsTitle => 'Настройки';

  @override
  String get darkmode => 'Тема';

  @override
  String get darkmode_dark => 'Ночной режим';

  @override
  String get darkmode_light => 'Дневной режим';

  @override
  String get darkmode_system_default => 'Настройки по умолчанию';

  @override
  String get thanks_for_contributing => 'Спасибо за вклад!';

  @override
  String get contributors_label => 'Они создают приложение';

  @override
  String get contributors_dialog_title => 'Участники';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Участник: $name';
  }

  @override
  String get contributors_description =>
      'Список всех пользователей этого приложения';

  @override
  String get support => 'Поддержка';

  @override
  String get support_join_slack => 'Попросите помощи в нашем канале Slack';

  @override
  String get support_via_forum => 'Обратитесь за помощью на наш форум';

  @override
  String get support_via_email => 'Отправьте нам электронное письмо';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Отправить журнал приложений?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Вы хотите включить журналы приложений во вложение к вашему электронному письму?';

  @override
  String get termsOfUse => 'Условия использования';

  @override
  String get legalNotices => 'Правовая информация';

  @override
  String get privacy_policy => 'Политика конфиденциальности';

  @override
  String get about_this_app => 'О приложении';

  @override
  String get contribute => 'Способствовать';

  @override
  String get contribute_sw_development => 'Разработка программного обеспечения';

  @override
  String get contribute_develop_text =>
      'Код для каждого продукта Open Food Facts доступен на GitHub. Вы можете повторно использовать код (это открытый исходный код) и помочь нам улучшить его для всех людей на нашей планете.';

  @override
  String get contribute_develop_text_2 =>
      'Вы можете присоединиться к чату Open Food Facts Slack, здесь будет удобно задавать вопросы.';

  @override
  String get contribute_develop_dev_mode_title => 'Режим Разработчика?';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'Активировать Режим Разработчика';

  @override
  String get contribute_donate_title => 'Поддержать';

  @override
  String get contribute_donate_header => 'Поддержите Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Пожалуйста, примите во внимание, что при использовании внутренней альфа-версии возможна полная потеря данных, и приложение может стать непригодным для использования в любой момент!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Незавершенные продукты';

  @override
  String get contribute_improve_header => 'Улучшение';

  @override
  String get contribute_improve_text =>
      'База данных — это основа проекта. Помочь нетрудно и не займет много времени. Вы можете загрузить мобильное приложение на свой телефон и начать добавлять или улучшать продукты.\n\nВ то же время, сайт Open Food Facts предлагает множество способов внести свой вклад: ';

  @override
  String get contribute_translate_header => 'Перевести';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Начать переводить';

  @override
  String get contribute_translate_text =>
      'Open Food Facts — это глобальный проект, содержащий информацию о продуктах из более чем 160 стран. Open Food Facts переведена на десятки языков, и продолжает постоянно изменяться.';

  @override
  String get contribute_translate_text_2 =>
      'Переводы — одна из ключевых задач проекта';

  @override
  String get contribute_join_skill_pool =>
      'Поделитесь своими навыками с Open Food Facts. Присоединяйтесь к пулу навыков!';

  @override
  String get contribute_share_header => 'Поделитесь Open Food Facts с друзьями';

  @override
  String get contribute_share_content =>
      'Хочу рассказать вам о приложении Open Food Facts, которое позволяет получать информацию и персональные рекомендации о влиянии еды на здоровье и окружающую среду. Приложение работает путём сканирования штрихкодов. Приложение бесплатное, не требует регистрации, и вы можете добавить недостающую информацию! Ссылка для установки: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Укажите цены, запросив экспорт данных ваших карт лояльности в соответствии с GDPR';

  @override
  String get tap_to_answer =>
      'Нажмите здесь, чтобы ответить на несколько вопросов';

  @override
  String get tap_to_answer_hint =>
      'Нажмите здесь, чтобы ответить на вопросы об этом продукте';

  @override
  String get robotoff_questions_loading_hint =>
      'Пожалуйста, подождите, пока вопросы об этом продукте загрузятся';

  @override
  String get saving_answer => 'Сохранение вашего ответа';

  @override
  String get contribute_to_get_rewards =>
      'Станьте участником пищевой прозрачности';

  @override
  String get question_sign_in_text =>
      'Войдите в свою учетную запись Open Food Facts, чтобы получить признание за свой вклад';

  @override
  String get question_yes_button_accessibility_value => 'Ответить да';

  @override
  String get question_no_button_accessibility_value => 'Ответить нет';

  @override
  String get question_skip_button_accessibility_value =>
      'Пропустить этот вопрос';

  @override
  String get tap_to_edit_search => 'Нажмите для редактирования поиска';

  @override
  String get myPreferences => 'Мои настройки';

  @override
  String get account_create_message =>
      'Создайте свой аккаунт и присоединяйтесь к сообществу Open Food Facts, чтобы помочь создать знания о пище по всему миру!';

  @override
  String get join_us => 'Присоединяйтесь к нам';

  @override
  String get myPreferences_profile_title => 'Ваш профиль';

  @override
  String get myPreferences_profile_subtitle =>
      'Управляйте своей учётной записью участника Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Настройки';

  @override
  String get myPreferences_settings_subtitle => 'Тёмный режим, Языки…';

  @override
  String get myPreferences_food_title => 'Предпочтения в еде';

  @override
  String get myPreferences_food_subtitle =>
      'Выберите, какая информация о еде представляет для вас наибольший интерес.';

  @override
  String get myPreferences_food_comment =>
      'Выберите информацию о еде, которая представляет для вас наибольший интерес, чтобы отсортировывать еду в соответствии с вашими предпочтениями, показывать нужную вам информацию в первую очередь, а также получать данные о совместимости. Выбранные вами предпочтения останутся на вашем устройстве и никак не связаны с вашим профилем участника Open Food Facts, если таковой имеется.';

  @override
  String get confirmResetPreferences => 'Сбросить предпочтения?';

  @override
  String get myPersonalizedRanking => 'Мой персональный рейтинг';

  @override
  String get ranking_tab_all => 'Все';

  @override
  String get ranking_subtitle_match_yes => 'Хорошо подходит для вас';

  @override
  String get ranking_subtitle_match_no => 'Плохо подходит для вас';

  @override
  String get ranking_subtitle_match_maybe => 'Неизвестное совпадение';

  @override
  String get refresh_with_new_preferences =>
      'Обновите список с вашими новыми предпочтениями';

  @override
  String get reloaded_with_new_preferences =>
      'Перезагружено с вашими новыми настройками';

  @override
  String get profile_navbar_label => 'Сообщество';

  @override
  String get scan_navbar_label => 'Сканировать';

  @override
  String get history_navbar_label => 'История';

  @override
  String get list_navbar_label => 'Списки';

  @override
  String get category => 'Фильтр по категориям';

  @override
  String get category_all => 'Все';

  @override
  String get category_search => '(поиск по категории)';

  @override
  String get filter => 'Фильтр';

  @override
  String get scan => 'Продукты с экрана сканирования';

  @override
  String get scan_history => 'История сканов';

  @override
  String get search => 'Поиск';

  @override
  String get search_product_help => 'Поиск продукта,\nбренда или штрихкода';

  @override
  String get search_filter => 'Фильтр поиска';

  @override
  String get search_history => 'История поиска';

  @override
  String get search_store => 'Поиск магазина';

  @override
  String get search_store_help => 'Подсказка: добавьте город или страну.';

  @override
  String get tap_for_more => 'Нажмите для просмотра…';

  @override
  String get product => 'Продукт';

  @override
  String get unknownBrand => 'Неизвестный бренд';

  @override
  String get unknownQuantity => 'Неизвестная величина';

  @override
  String get unknownProductName => 'Неизвестный продукт';

  @override
  String get label_refresh => 'Обновить';

  @override
  String get label_reload => 'Перезагрузка';

  @override
  String get image => 'Изображение';

  @override
  String get front_photo => 'Фото спереди';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (это изображение может быть устаревшим)';
  }

  @override
  String get outdated_image_short_label => 'может быть устаревшим';

  @override
  String get ingredients => 'Ингредиенты';

  @override
  String get ingredients_editing_instructions =>
      'Сохраняйте первоначальный порядок. Укажите процент, если он указан. Разделяйте запятой или дефисом, используйте круглые скобки для ингредиентов и указывайте аллергены между символами подчеркивания.';

  @override
  String get ingredients_editing_error => 'Не удалось сохранить ингредиенты.';

  @override
  String get ingredients_editing_image_error =>
      'Не удалось получить изображение нового ингредиента.';

  @override
  String get ingredients_editing_title => 'Изменить ингредиенты';

  @override
  String get ingredients_photo => 'Фото состава';

  @override
  String get packaging_editing_instructions =>
      'Перечислите все части упаковки, разделенные запятой или переводом строки, с указанием их количества (например, 1 или 6), типа (например, бутылка, коробка, банка), материала (например, пластик, металл, алюминий) и, если возможно, их размера (например, 33 cl) и инструкции по утилизации.\nПример: 1 стеклянная бутылка на переработку, 1 пластиковая пробка на выброс';

  @override
  String get packaging_editing_error => 'Не удалось сохранить изменения.';

  @override
  String get packaging_editing_image_error =>
      'Не удалось получить изображение нового ингредиента.';

  @override
  String get packaging_editing_title => 'Редактировать пакет';

  @override
  String get nutrition => 'Пищевая ценность';

  @override
  String get nutrition_facts_photo => 'Фото информации о пищевой ценности';

  @override
  String get nutrition_facts_editing_title =>
      'Добавить данные о пищевой ценности';

  @override
  String get packaging_information => 'Инструкции по переработке';

  @override
  String get packaging_information_photo => 'Фото инструкции по переработке';

  @override
  String get missing_product => 'Вы нашли новый продукт!';

  @override
  String get add_product_take_photos =>
      'Сфотографируйте упаковку, чтобы добавить этот продукт в Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Пожалуйста, сделайте фотографии в первую очередь. Вы всегда можете дополнить продукт потом.';

  @override
  String get add_product_information_button_label =>
      'Добавление информации о продукте';

  @override
  String get new_product => 'Новый продукт';

  @override
  String get new_product_found_title => 'Найден новый продукт!';

  @override
  String get new_product_found_text =>
      'Наша совместная база данных содержит более **3 миллионов товаров**, но такого штрихкода не существует: ';

  @override
  String get new_product_found_button => 'Добавить этот продукт';

  @override
  String get new_product_leave_title => 'Покинуть эту страницу?';

  @override
  String get new_product_leave_message =>
      'Похоже, вы ничего не ввели. Вы уверены, что хотите покинуть эту страницу?';

  @override
  String get new_product_dialog_description =>
      'Пожалуйста, сделайте фотографии упаковки, чтобы добавить этот продукт в нашу общую базу данных';

  @override
  String get new_product_dialog_illustration_description =>
      'Иллюстрация с неизвестными показателями Nutri-Score и Green Score';

  @override
  String get front_packaging_photo_button_label =>
      'Фотография лицевой стороны продукта';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Подтвердить загрузку фотографии лицевой стороны продукта';

  @override
  String get confirm_button_label => 'Подтвердить';

  @override
  String get send_image_button_label => 'Отправить изображение';

  @override
  String get crop_page_action_saving => 'Сохранение изображения…';

  @override
  String get crop_page_action_cropping => 'Обрезка изображения…';

  @override
  String get crop_page_action_local => 'Сохранение локальной версии…';

  @override
  String get crop_page_action_local_failed_title =>
      'Упс… что-то с вашей фотографией!';

  @override
  String get crop_page_action_local_failed_message =>
      'Мы не смогли обработать изображение локально перед отправкой на наш сервер. Пожалуйста, повторите попытку позже или свяжитесь с нами, если проблема не исчезнет.';

  @override
  String get crop_page_action_retake => 'Сделать фото заново';

  @override
  String get crop_page_too_small_image_title =>
      'Изображение слишком маленькое!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Минимальный размер загружаемого изображения ${expectedMinWidth}x$expectedMinHeight пикселей. Текущее изображение имеет размер ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Подготавливаем запрос для сервера…';

  @override
  String get front_packaging_photo_title => 'Фото упаковки спереди';

  @override
  String get ingredients_photo_title => 'Фото состава';

  @override
  String get nutritional_facts_photo_title =>
      'Фото информации о пищевой ценности';

  @override
  String get recycling_photo_title => 'Инструкции по переработке (фото)';

  @override
  String get take_photo_title => 'Сфотографировать';

  @override
  String get take_more_photo_title => 'Сделайте дополнительные фото';

  @override
  String get front_photo_uploaded => 'Загружено переднее фото';

  @override
  String get ingredients_photo_button_label => 'Фото состава';

  @override
  String get ingredients_photo_uploaded => 'Фото ингредиентов загружено';

  @override
  String get nutrition_cache_loading_error =>
      'Не удается загрузить питательные вещества из кэша';

  @override
  String get nutritional_facts_photo_button_label =>
      'Фото информации о пищевой ценности';

  @override
  String get nutritional_facts_input_button_label =>
      'Введите данные о пищевой ценности';

  @override
  String get nutritional_facts_added => 'Добавлены факты о пищевой ценности';

  @override
  String get categories_added => 'Категории добавлены';

  @override
  String get new_product_title_nutriscore => 'Рассчитать Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Для этого заполните категорию продукта и данные пищевой ценности';

  @override
  String get new_product_title_environmental_score => 'Рассчитать Green Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Для этого укажите хотя бы одну категорию';

  @override
  String get new_product_additional_environmental_score =>
      'Сделайте вычисления Grren Score более точными, указав происхождение, упаковку и другие параметры';

  @override
  String get new_product_title_nova =>
      'Вычислить уровень обработки пищевых продуктов (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Для этого заполните категорию и состав продукта';

  @override
  String get new_product_desc_nova_unknown =>
      'Степень обработки продуктов неизвестна';

  @override
  String get new_product_title_pictures =>
      'Давайте сделаем несколько фотографий!';

  @override
  String get new_product_title_pictures_details =>
      'Пожалуйста, сделайте следующие фотографии, а движок Open Food Facts сделает все остальное!';

  @override
  String get new_product_title_misc => 'И некоторые основные данные…';

  @override
  String new_product_done_msg(String username) {
    return 'Спасибо за ваш вклад «$username»!';
  }

  @override
  String get new_product_done_msg_no_user => 'Спасибо за Ваш вклад!';

  @override
  String get new_product_done_button_label =>
      'Откройте для себя готовый продукт';

  @override
  String get hey_incomplete_product_message =>
      'Нажмите, чтобы ответить на 3 вопроса СЕЙЧАС и рассчитать Nutri-Score, Green Score и Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Нажмите сейчас, чтобы ответить на 2 вопроса и помочь проанализировать это косметическое средство!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Нажмите сейчас, чтобы ответить на 3 вопроса и помочь проанализировать этот корм для домашних животных!';

  @override
  String get hey_incomplete_product_message_product =>
      'Нажмите сейчас, чтобы помочь завершить этот продукт!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Фото информации о пищевой ценности загружено';

  @override
  String get recycling_photo_button_label =>
      'Информационное фото по переработке';

  @override
  String get recycling_photo_uploaded => 'Фотография утилизации загружена';

  @override
  String get take_more_photo_button_label => 'Сделайте дополнительные фото';

  @override
  String get other_photo_uploaded => 'Разное фото загружены';

  @override
  String get retake_photo_button_label => 'Переснять';

  @override
  String get selecting_photo => 'Выберите фотографию';

  @override
  String get uploading_image => 'Фото выгружается на сервер';

  @override
  String get uploading_image_type_front =>
      'Загрузка фронтального изображения в Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Загрузка списка ингредиентов в Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Загрузка изображения пищевой ценности в Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Загрузка изображения упаковки в Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Загрузка другого изображения на Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Загрузка изображения в Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Добавить недостающие ингридиенты';

  @override
  String get score_add_missing_packaging_image =>
      'Добавить отсутствующее изображение упаковки';

  @override
  String get score_add_missing_nutrition_facts =>
      'Добавить данные о пищевой ценности';

  @override
  String get score_add_missing_product_traces =>
      'Добавить пропущенные треки товаров';

  @override
  String get score_add_missing_product_category =>
      'Добавить собственную категорию продукта';

  @override
  String get score_add_missing_precise_product_category =>
      'Выберите более точную категорию';

  @override
  String get score_add_missing_product_countries =>
      'Добавить отсутствующие страны продукта';

  @override
  String get score_add_missing_product_emb =>
      'Добавьте отсутствующие коды отслеживания продукта';

  @override
  String get score_add_missing_product_labels =>
      'Добавить отсутствующие метки продукта';

  @override
  String get score_add_missing_product_origins =>
      'Добавить недостающее происхождение продукта';

  @override
  String get score_add_missing_product_stores =>
      'Добавить недостающие магазины продукта';

  @override
  String get score_add_missing_product_brands =>
      'Добавить отсутствующие бренды продуктов';

  @override
  String get score_update_nutrition_facts =>
      'Введите данные о пищевой ценности';

  @override
  String get nutrition_page_title => 'Пищевая ценность';

  @override
  String get nutrition_page_nutritional_info_title =>
      'Информация о пищевой ценности';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Значения, указанные на изделии:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Да';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Нет';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Открыть фото';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Надлежащая практика: Информация о пищевой ценности';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Иногда факты о питании **не указаны на упаковке** или в документе, прилагаемом к продукту. В этом случае и только в этом случае, вы можете установить значение **НЕТ**.';

  @override
  String get nutrition_page_serving_type_label => 'Пищевая ценность:';

  @override
  String get nutrition_page_per_100g => 'на 100 грамм';

  @override
  String get nutrition_page_per_100g_100ml => 'на 100 г/мл';

  @override
  String get nutrition_page_per_serving => 'на порцию';

  @override
  String get nutrition_page_add_nutrient => 'Добавить питательное вещество';

  @override
  String get nutrition_page_serving_size => 'Размер порции';

  @override
  String get nutrition_page_serving_size_hint =>
      'Введите размер порции (например: 100 г)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Хорошие практики: Размер порции';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Это значение помогает **произвести пропорциональный расчет каждого питательного вещества на размер порции**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Допустимые единицы**: кг, г, мг, мкг, унции, л, дл, кл, мл, жидкие унции, жидкие унции, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 г**, **60г** или **60 Г** (предпочтительнее первый вариант)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 мл** или **1Л**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Неверная единица измерения';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **гр**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Неверные единицы';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **конфет** and 2 **печеньки**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Отсутствует единица';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Неверный номер';

  @override
  String get nutrition_page_update_running => 'Обновление продукта на сервере…';

  @override
  String get nutrition_page_update_done => 'Обновления продукта!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Используйте количество продукта в качестве размера порции.';

  @override
  String get nutrition_page_photo_error => 'Не удалось загрузить фото.';

  @override
  String get more_photos => 'Больше интересных фото';

  @override
  String get view_more_photo_button =>
      'Просмотреть все существующие фотографии для этого продукта';

  @override
  String get no_product_found => 'Продукт не найден';

  @override
  String get no_location_found => 'Расположение не найдено';

  @override
  String get not_found => 'не найдено:';

  @override
  String get refreshing_product => 'Обновление продукта';

  @override
  String get product_refreshed => 'Продукт обновлен';

  @override
  String product_image_accessibility_label(String date) {
    return 'Изображение сделано $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Изображение сделано $date. Это изображение может быть устаревшим';
  }

  @override
  String get product_image_outdated => 'Это изображение может быть устаревшим';

  @override
  String get product_image_outdated_explanations_title =>
      'Это изображение может быть устаревшим';

  @override
  String get product_image_outdated_explanations_content =>
      'Это изображение было сделано больше года назад.\n**Пожалуйста, проверьте, актуально ли оно**.\n\nЭто **просто предупреждение**. Если содержимое осталось прежним, вы можете проигнорировать это сообщение.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Заменить фото ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Добавить фото ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Новый снимок';

  @override
  String get product_image_action_take_picture => 'Сфотографировать';

  @override
  String get product_image_action_from_gallery =>
      'Выберите из галереи вашего телефона';

  @override
  String get product_image_action_choose_existing_photo =>
      'Выберите из фотографий продукта';

  @override
  String get product_image_details_label => 'Информация о фотографии';

  @override
  String get product_image_details_from_producer => 'От производителя';

  @override
  String get product_image_details_contributor => 'Участник';

  @override
  String get product_image_details_contributor_producer =>
      'Участник (производитель)';

  @override
  String get product_image_details_date => 'Дата';

  @override
  String get product_image_details_date_unknown => 'Неизвестный';

  @override
  String get homepage_main_card_logo_description =>
      'Добро пожаловать в Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Сканируйте** штрихкод или\n**найдите** продукт';

  @override
  String get homepage_main_card_search_field_hint => 'Искать товар';

  @override
  String get homepage_main_card_search_field_tooltip => 'Начать поиск';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Последние новости: $news_title';
  }

  @override
  String get tagline_app_review => 'Нравится приложение?';

  @override
  String get tagline_app_review_button_positive => 'Конечно! 😍';

  @override
  String get tagline_app_review_button_negative => 'Не очень…';

  @override
  String get tagline_app_review_button_later => 'Позже';

  @override
  String get tagline_feed_news_button => 'Подробнее';

  @override
  String get app_review_negative_modal_title => 'Не нравится наше приложение?';

  @override
  String get app_review_negative_modal_text => 'Пожалуйста, напишите, почему.';

  @override
  String get app_review_negative_modal_positive_button => 'Да, конечно!';

  @override
  String get app_review_negative_modal_negative_button => 'Нет';

  @override
  String get could_not_refresh => 'Не удалось обновить продукт';

  @override
  String get product_internet_error_modal_title => 'Произошла ошибка!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Мы не можем получить информацию об этом продукте из-за ошибки сети. Проверьте подключение к Интернету и повторите попытку.\n\nВнутренняя ошибка:\n$error';
  }

  @override
  String get product_tags_title => 'Свойства продукта';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Нет свойств';

  @override
  String get product_tags_explanation =>
      'Добавляя свойства (ключ/значение) к продукту, вы помогаете его обогатить.';

  @override
  String get add_tag => 'Добавить свойство';

  @override
  String get add_tags => 'Добавить свойства';

  @override
  String get add_edit_tags => 'Добавить или изменить свойства';

  @override
  String get edit_tag => 'Изменить свойство';

  @override
  String get remove_tag => 'Удалить свойство';

  @override
  String get tag_key => 'Свойство';

  @override
  String get tag_keys => 'Характеристики';

  @override
  String get tag_key_uneditable => 'Свойство (нередактируемое)';

  @override
  String get tag_key_input_hint => 'Введите свойство';

  @override
  String get tag_value => 'Значение';

  @override
  String get tag_values => 'Ценности';

  @override
  String get tag_value_input_hint => 'Введите значение';

  @override
  String get tag_key_item => 'Свойство:';

  @override
  String get tag_value_item => 'Цена:';

  @override
  String get tag_key_explanations =>
      'Ключ должен быть написан строчными буквами и не содержать пробелов.';

  @override
  String tag_key_already_exists(String property) {
    return 'Тег со свойством $property уже существует!';
  }

  @override
  String get product_internet_error =>
      'Невозможно получить информацию об этом продукте из-за сетевой ошибки.';

  @override
  String get cached_results_from => 'Показать результаты из:';

  @override
  String get product_search_same_category => 'Найти альтернативы';

  @override
  String get product_search_same_category_short => 'Сравнить';

  @override
  String get product_search_same_category_error =>
      'Эту функцию можно использовать только для продуктов с категорией.\n\nИзмените продукт, чтобы добавить категорию.';

  @override
  String get product_improvement_add_category =>
      'Добавьте категорию для расчета Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Добавьте информацию о пищевой ценности, чтобы вычислить Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Добавить пищевую ценность и категорию для вычисления Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Невозможно рассчитать Nutri-Score для этого продукта, что может быть связано, например, с нестандартной категорией. Если это ошибка, пожалуйста, свяжитесь с нами.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Изображение пищевой ценности устарело: обновите его.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Green Score учитывает происхождение ингредиентов. Пожалуйста, сфотографируйте список ингредиентов и/или любые географические заявления или отредактируйте продукт, чтобы их можно было учесть.';

  @override
  String get country_chooser_label => 'Пожалуйста, выберите страну';

  @override
  String get currency_chooser_label => 'Пожалуйста, выберите валюту';

  @override
  String get country_change_message => 'Вы только что сменили страну.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Хотите изменить валюту с $previousCurrency на $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Пожалуйста, выберите страну';

  @override
  String get country_chooser_label_from_settings => 'Ваша страна';

  @override
  String get country_selection_explanation =>
      'Некоторые особенности окружающей среды зависят от местоположения';

  @override
  String get product_removed_comparison => 'Продукт удален из сравнения';

  @override
  String get native_app_settings => 'Системные настройки приложения';

  @override
  String get native_app_description =>
      'Открыть настройки системы для Open Food Facts';

  @override
  String get product_removed_history => 'Продукт удален из истории';

  @override
  String get product_removed_list => 'Продукт убран из списка';

  @override
  String get product_could_not_remove => 'Не удалось удалить продукт';

  @override
  String get no_prodcut_in_list => 'В этом списке нет продуктов';

  @override
  String get no_product_in_section => 'В этом разделе нет продуктов';

  @override
  String get recently_seen_products => 'Все просмотренные продукты';

  @override
  String get clear => 'Очистить';

  @override
  String get clear_long => 'Очистить список';

  @override
  String get really_clear => 'Вы действительно хотите удалить этот список?';

  @override
  String pct_match(Object percent) {
    return '$percent% совместимости';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count дней назад',
      one: 'один день назад',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count часов назад',
      one: 'один час назад',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count минут назад',
      one: 'одну минуту назад',
      zero: 'меньше минуты назад',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count месяцев назад',
      one: 'один месяц назад',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count недель назад',
      one: 'одну неделю назад',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Сравнить $count Продукты',
      one: 'Сравнить один продукт',
      many: 'Сравнить $count Продукты',
      few: 'Сравнить $count Продукты',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count выбрано продуктов',
      one: 'Один выбранный продукт',
      zero: 'Не выбрано ни одного продукта',
      many: '$count выбрано продуктов',
      few: '$count выбрано продуктов',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Сравнить выбранные продукты';

  @override
  String get delete_products_mode => 'Удалить выбранные продукты';

  @override
  String get select_all_products_mode => 'Выбрать все продукты';

  @override
  String get select_none_products_mode => 'Очистить';

  @override
  String get compare_products_appbar_title => 'Сравнить продукты';

  @override
  String get compare_products_appbar_subtitle =>
      'Пожалуйста, выберите не менее двух продуктов';

  @override
  String get retry_button_label => 'Повтор';

  @override
  String get connect_with_us => 'Мы в соцсетях';

  @override
  String get tiktok => 'Подписывайтесь на наш TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Подпишитесь на нас в Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Подпишитесь на нас в X (ранее Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Подпишитесь на нас в Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Подпишитесь на нас на BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Блог';

  @override
  String get faq => 'Часто задаваемые вопросы';

  @override
  String get discover => 'О проекте';

  @override
  String get how_to_contribute => 'Как помочь проекту';

  @override
  String get hint_knowledge_panel_message =>
      'Вы можете нажать на любую часть карточки, чтобы получить более подробную информацию о том, что вы видите. Попробуйте сейчас!';

  @override
  String get permissions_page_title => 'Доступ к камере';

  @override
  String get permissions_page_body1 =>
      'Для сканирования штрих-кодов с помощью камеры вашего телефона, пожалуйста, авторизуйтесь для доступа.';

  @override
  String get permissions_page_body2 =>
      'Если вы передумаете, эту опцию можно включить и отключить в настройках в любое время.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'ОС: Android (SDK Int: $sdkInt / Выпуск: \$$release)\nМодель: \$$model\nПродукт: \$$product\nУстройство: \$$device\nМарка:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'ОС: iOS ($version)\nМодель: $model\nЛокализованная модель: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nВерсия приложения:$appVersion\nНомер сборки приложения:$appBuildNumber\nИмя пакета приложения:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Авторизация';

  @override
  String get refuse_button_label => 'Отклонить';

  @override
  String get ask_me_later_button_label => 'Позже';

  @override
  String get are_you_sure => 'Вы уверены?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Проследуйте на $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Добро пожаловать !';

  @override
  String get onboarding_home_welcome_text2 =>
      'Приложение, которое поможет вам выбрать еду, что полезна для **вас** и **планеты**!';

  @override
  String get onboarding_continue_button => 'Продолжить';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Загрузка вашего первого примера продукта';

  @override
  String get onboarding_welcome_warning =>
      'Извините, это наш пример товара, вы не можете его редактировать :)';

  @override
  String get product_list_your_ranking => 'Ваш рейтинг';

  @override
  String get product_list_empty_icon_desc => 'История недоступна';

  @override
  String get product_list_empty_title => 'Начать сканирование';

  @override
  String get product_list_empty_message =>
      'Отсканированные продукты появятся здесь, и вы сможете просмотреть подробную информацию о них';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'продуктов',
      one: 'продукта',
      zero: 'продукта',
      many: 'продуктов',
      few: 'продуктов',
    );
    return 'Обновление $_temp0 в вашей истории';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Продукты',
      one: 'Продукт',
      zero: 'Продукт',
      many: 'Продукты',
      few: 'Продукты',
    );
    return '$_temp0 обновление завершено';
  }

  @override
  String get product_list_compare_side_by_side => 'Сравните бок о бок';

  @override
  String get loading_dialog_default_title => 'Загрузка данных';

  @override
  String get loading_dialog_default_error_message =>
      'Не удалось загрузить данные';

  @override
  String get account_delete => 'Удалить учётную запись';

  @override
  String get account_delete_title => 'Удалить мою учетную запись';

  @override
  String get user_profile => 'Учётная запись';

  @override
  String get user_profile_title_guest => 'Добро пожаловать!';

  @override
  String get user_profile_subtitle_guest =>
      'Войти или зарегистрироваться, чтобы присоединиться к сообществу Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts логин: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Добро пожаловать, $id!';
  }

  @override
  String get email_subject_account_deletion => 'Удалить учётную запись';

  @override
  String email_body_account_deletion(String userId) {
    return 'Пожалуйста, удалите мою учётную запись Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Приложение';

  @override
  String get settings_app_data => 'Конфиденциальность и мониторинг';

  @override
  String get settings_app_camera => 'Камера';

  @override
  String get settings_app_products => 'Продукты';

  @override
  String get settings_app_miscellaneous => 'Прочее';

  @override
  String get camera_play_sound_title => 'Воспроизвести звук при сканировании';

  @override
  String get camera_play_sound_subtitle =>
      'Издавать звуковой сигнал при каждом успешном сканировании';

  @override
  String get camera_window_accessibility_label =>
      'Отсканируйте штрих-код с помощью камеры';

  @override
  String get app_haptic_feedback_title => 'Вибрация и отклик';

  @override
  String get app_haptic_feedback_subtitle =>
      'Вибрация после завершения некоторых действий (штрихкод декодирован, продукт удален…).';

  @override
  String get crash_reporting_toggle_title => 'Отчеты об ошибках';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Автоматически отправлять отчёты о неполадках в систему отслеживания ошибок для их последующего исправления.';

  @override
  String get send_anonymous_data_toggle_title => 'Отправлять анонимные данные';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Отправлять анонимные данные аналитики, которые помогают Open Food Facts оценивать информацию об использовании функций.';

  @override
  String get product_edit_photo_title => 'Редактировать фото';

  @override
  String get permission_photo_error => 'Ошибка';

  @override
  String get permission_photo_denied_title =>
      'Разрешите использование камеры для сканирования штрихкодов';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Для расширения возможностей разрешите $appName доступ к вашей камере. Вы сможете сканировать штрихкоды напрямую.';
  }

  @override
  String get permission_photo_denied_button => 'Разрешить';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Отказано в доступе';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Поскольку ранее вы отказали в доступе к камере, вы должны разрешить его вручную в настройках.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Открыть настройки';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Отмена';

  @override
  String get permission_photo_none_found => 'Камера не обнаружена';

  @override
  String get permission_photo_denied => 'Нет доступа к камере';

  @override
  String get show_product_pictures => 'Показать фотографии продукта';

  @override
  String get edit_product_label => 'Редактировать продукт';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Загрузка ваших правок…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Ваши изменения **отправляются в фоновом режиме** (или позже в случае ошибки).\nВы можете продолжить редактирование других полей продукта.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Ваши правки **отправляются в фоновом режиме** (или позже в случае ошибки).';

  @override
  String get edit_product_label_short => 'Редактировать';

  @override
  String edit_product_form_item_help(String value) {
    return 'Как ввести «$value»?';
  }

  @override
  String get edit_product_form_item_error_empty => 'Введите непустое значение!';

  @override
  String get edit_product_form_item_error_existing =>
      'Это значение уже существует!';

  @override
  String get edit_product_form_item_add_action_brand => 'Добавить новый бренд';

  @override
  String get edit_product_form_item_add_action_label => 'Добавить новый ярлык';

  @override
  String get edit_product_form_item_add_action_store =>
      'Добавить новый магазин';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Добавить новый источник';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Добавить новый код отслеживания';

  @override
  String get edit_product_form_item_add_action_country =>
      'Добавить новую страну';

  @override
  String get edit_product_form_item_add_action_category =>
      'Добавление новой категории';

  @override
  String get edit_product_form_item_add_action_trace => 'Добавить новый след';

  @override
  String get edit_product_form_item_add_suggestion => 'Добавить предложение';

  @override
  String get edit_product_form_item_deny_suggestion => 'Отклонить предложение';

  @override
  String get edit_product_form_item_details_title => 'Основные детали';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Название продукта, марка, количество';

  @override
  String get edit_product_form_item_other_details_title =>
      'Дополнительная информация';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Веб-сайт…';

  @override
  String get edit_product_form_item_photos_title => 'Фотографии';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Добавьте или обновите фотографии';

  @override
  String get edit_product_form_item_labels_title => 'Этикетки и сертификаты';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Экологичность, знаки качества…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Введите метку (например: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'маркировка';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Хорошие практики: Бренды';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Любая характеристика продукта, **которая является фактической** и отличается от других полей.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Сделано в Бельгии, произведено в Бретани…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Богат клетчаткой, источник железа…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Справедливая торговля, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Магазины';

  @override
  String get edit_product_form_item_stores_hint => 'Введите магазин';

  @override
  String get edit_product_form_item_stores_type => 'магазин';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Хорошие практики: Магазины';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Введите магазин, где вы купили товар.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Каррефур';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Лидл';

  @override
  String get edit_product_form_item_origins_title => 'Происхождение';

  @override
  String get edit_product_form_item_origins_hint =>
      'Введите страну происхождения (например: Германия)';

  @override
  String get edit_product_form_item_origins_type => 'страна';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Хорошие практики: Истоки';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Добавьте **любые указания на происхождение, которые вы можете найти на упаковке**.\nВам не нужно беспокоиться о происхождении, указанном непосредственно в списке ингредиентов.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Говядина из Аргентины';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Соя не из Европейского Союза';

  @override
  String get edit_product_form_item_countries_title => 'Страна';

  @override
  String get edit_product_form_item_countries_hint =>
      'Введите страну (например: Германия)';

  @override
  String get edit_product_form_item_countries_type => 'страна';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Хорошая практика: Страны';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Страны, в которых продукт широко доступен** (не включая магазины, специализирующиеся на иностранной продукции).';

  @override
  String get edit_product_form_item_emb_codes_title =>
      'Код отслеживания продукта';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Введите код (например: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type =>
      'Код отслеживания продукта';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Хорошая практика: Коды отслеживания';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'В этом разделе вы можете ввести коды, относящиеся к **маркировке упаковки**, **идентификационным знакам** или **знакам здоровья**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Примеры кодов прослеживаемости';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Коды ЕС**, используемые в Европейском сообществе для идентификации производителей или упаковщиков продуктов питания:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: код страны **Франция**\n**72.264.002**: географические данные\n**CE**: Европейское сообщество';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Коды EMB**, используемые во Франции:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'ЕМВ 72264';

  @override
  String get edit_product_form_item_traces_title => 'Следы';

  @override
  String get edit_product_form_item_traces_hint => 'след';

  @override
  String get edit_product_form_item_traces_type =>
      'Введите след (например: соевые бобы)';

  @override
  String get edit_product_form_item_categories_title => 'Категории';

  @override
  String get edit_product_form_item_categories_hint => 'категория';

  @override
  String get edit_product_form_item_categories_type =>
      'Введите категорию (например: Апельсиновый сок)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Хорошие практики: Категории';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Укажите **только самую конкретную категорию**.\nРодительские категории будут добавлены автоматически.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Отсутствует категория?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Если категория **недоступна в автозаполнении**, смело добавляйте ее.\nЭто поможет нам улучшить Open Food Facts в вашей стране.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Сардины в оливковом масле';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Апельсиновый сок из концентрата';

  @override
  String get edit_product_form_item_exit_title => 'Выйти без сохранения?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Хотите ли Вы сохранить изменения прежде чем покинуть страницу?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Сохранить изменения';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Отменить изменения';

  @override
  String get edit_product_form_item_ingredients_title => 'Ингредиенты';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Увеличение и уменьшение масштаба путем сведения и разведения пальцев на экране';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Увеличивайте и уменьшайте масштаб фотографии';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Используя **жест масштабирования пальцами**, вы можете увеличивать или уменьшать масштаб фотографии:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Добавить';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Пожалуйста, сначала введите текст';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Удалить';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Сохраните ваши изменения';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Отменить редактирование';

  @override
  String get edit_product_form_item_packaging_title =>
      'Фото инструкции по переработке';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Пищевая и энергетическая ценность';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Пищевая ценность, содержание алкоголя…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Хорошая практика: питательная ценность';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Пищевая ценность';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Сначала выберите, предоставлены ли **значения**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Пищевая и энергетическая ценность';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Затем введите пищевую ценность **как указано на упаковке**. Если значения нет, вы можете нажать на значок «Глаз».';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Отсутствует поле?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Если запись отсутствует, вы можете **нажать на значок «Плюс»**, чтобы добавить ее (например: витамин D, магний…).';

  @override
  String get edit_product_form_save => 'Редактировать';

  @override
  String get edit_product_ingredients_photo_title => 'Фото состава';

  @override
  String get edit_product_ingredients_list_title => 'Список ингредиентов';

  @override
  String get edit_product_packaging_photo_title => 'Фото упаковки';

  @override
  String get edit_product_packaging_list_title => 'Список упаковки';

  @override
  String get no_data_available => 'Нет данных';

  @override
  String get product_field_website_title => 'Веб-сайт';

  @override
  String get origins_editing_title => 'Редактировать Происхождение';

  @override
  String get completed_basic_details_btn_text => 'Детальная информация';

  @override
  String get not_implemented_snackbar_text => 'Пока что не реализовано';

  @override
  String get category_picker_page_appbar_text => 'Категории';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Извлечь ингредиенты из фотографии';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Распознать ингредиенты';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Извлечение ингредиентов\nиз фотографии';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Загрузка фото…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Почему я вижу это сообщение?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Чтобы использовать функцию «Извлечь ингредиенты», сначала необходимо загрузить фотографию.\n\nПожалуйста, подождите несколько секунд или введите их вручную.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Обновить фото';

  @override
  String get edit_packaging_extract_btn_text =>
      'Извлечь упаковку\nиз фотографии';

  @override
  String get edit_packaging_extract_btn_text_short => 'Извлечь упаковку';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Извлечение упаковки из фото';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Загрузка фото…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Почему я вижу это сообщение?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Чтобы использовать функцию «Извлечь упаковку», необходимо сначала загрузить фотографию.\n\nПожалуйста, подождите несколько секунд или введите их вручную.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Обновить фото';

  @override
  String get edit_ocr_extract_failed =>
      'Не удалось обнаружить текст на изображении.';

  @override
  String get edit_ocr_extract_disabled_title => 'Нет картинки!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Для того чтобы использовать функцию извлечения текста, необходимо сначала сделать фотографию.';

  @override
  String get user_list_dialog_new_title => 'Новый список продуктов';

  @override
  String get user_list_dialog_rename_title => 'Переименование списка';

  @override
  String get user_list_subtitle_product => 'Списки';

  @override
  String get user_list_title => 'Ваши списки';

  @override
  String get user_list_add_product => 'Добавить этот продукт в ваши списки';

  @override
  String get user_list_button_new => 'Создание нового списка';

  @override
  String get user_list_empty_label =>
      'Нет доступных списков, пожалуйста, создайте новый';

  @override
  String get user_list_button_add_product => 'Добавить в список';

  @override
  String get added_to_list_msg => 'Добавлено в список';

  @override
  String get user_list_popup_clear => 'Очистить вашу историю';

  @override
  String get user_list_popup_rename => 'Переименовать';

  @override
  String get user_list_name_hint => 'Мой список';

  @override
  String get user_list_name_error_empty => 'Поле \"Имя\" является обязательным';

  @override
  String get user_list_name_error_already => 'Это имя уже используется';

  @override
  String get user_list_name_error_same => 'Это то же самое название';

  @override
  String get user_list_name_input_hint => 'Название списка';

  @override
  String get try_again => 'Попробуйте снова';

  @override
  String get there_was_an_error => 'Ошибка';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Не найдена категория для $items';
  }

  @override
  String get camera_toggle_camera =>
      'Переключиться между задней и фронтальной камерой';

  @override
  String get camera_toggle_flash => 'Включить или выключить вспышку камеры';

  @override
  String get camera_enable_flash => 'Включить фонарь';

  @override
  String get camera_disable_flash => 'Выключить фонарь';

  @override
  String get camera_flash_error_dialog_title => 'Произошла ошибка!';

  @override
  String get camera_flash_error_dialog_message =>
      'Произошла ошибка переключения состояния вспышки. Убедитесь что у вашего смартфона не включен режим фонарика.';

  @override
  String get category_picker_no_category_found_button => 'Назад';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Нажмите, чтобы открыть в браузере или в приложении (если установлено)';

  @override
  String get dev_preferences_screen_title => 'Режим отладки';

  @override
  String get dev_preferences_screen_subtitle =>
      'Доступ к экспериментальным функциям и инструментам разработки';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Перезапустить ознакомление';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Затем вам придется перезапустить приложение, чтобы увидеть его снова.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Переключить между openfoodfacts.org (PROD) и тестовой средой';

  @override
  String get dev_preferences_test_environment_title =>
      'Параметры тестовой среды';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Базовый URL для текущей тестовой среды: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Хост тестового окружения';

  @override
  String get dev_preferences_ml_kit_title => 'Использовать ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'тогда вам нужно перезапустить это приложение';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Дополнительная кнопка на странице продукта';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Редактировать состав с помощью кнопки на панели информации';

  @override
  String get dev_preferences_export_history_title => 'Экспортировать историю';

  @override
  String get dev_preferences_export_history_progress_error => 'исключение';

  @override
  String get dev_preferences_export_history_progress_found => 'продукт найден';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'продукт НЕ найден';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Экспортировать историю';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Отмена';

  @override
  String get dev_preferences_migration_title => 'Перенос данных из V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Статус: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'успех или свежая установка';

  @override
  String get dev_preferences_migration_status_success => 'успех';

  @override
  String get dev_preferences_migration_status_error => 'ошибка';

  @override
  String get dev_preferences_migration_status_in_progress =>
      'в процессе выполнения';

  @override
  String get dev_preferences_migration_status_required =>
      'обязательно (нажать, чтобы начать)';

  @override
  String get dev_preferences_migration_status_not_started => 'неизвестно';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Очистит историю и поместит туда 3 продукта';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Пользовательский URL для новостей';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL-адрес JSON-файла:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Не задано';

  @override
  String get dev_preferences_news_provider_status_title => 'Статус';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Последнее обновление: $date';
  }

  @override
  String get product_type_label_food => 'Еда';

  @override
  String get product_type_label_beauty => 'Личная гигиена';

  @override
  String get product_type_label_pet_food => 'Корм';

  @override
  String get product_type_label_product => 'Прочее';

  @override
  String get product_type_selection_title => 'Тип изделия';

  @override
  String get product_type_selection_subtitle => 'Выберите тип этого продукта';

  @override
  String get product_type_selection_empty =>
      'Сначала вам необходимо выбрать тип продукта!';

  @override
  String product_type_selection_already(String productType) {
    return 'Вы не можете изменить тип продукта ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Ярлык приложения «Цены» на странице продукта';

  @override
  String get prices_app_button => 'Перейти к приложению «Цены»';

  @override
  String get prices_website_button => 'Открыть на сайте Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Добавляйте ценники прямо из галереи';

  @override
  String get prices_bulk_proof_upload_warning =>
      'После выбора изображений вы не сможете их редактировать!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Разрешить сообществу проверять цены, полученные с помощью ИИ.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Несколько ценников';

  @override
  String get prices_bulk_proof_upload_title => 'Массовая загрузка';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Выбор файлов';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Начинаем загрузку';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Локальное копирование файла #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Подготовка загрузки #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Ошибка на изображении #$index/$count';
  }

  @override
  String get prices_generic_title => 'Цены';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Добавить $count цены',
      one: 'Добавить цену',
      many: 'Добавить $count цены',
      few: 'Добавить $count цены',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Отправить $count цены',
      one: 'Отправить цену',
      many: 'Отправить $count цены',
      few: 'Отправить $count цены',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Добавить элемент';

  @override
  String get prices_add_a_price => 'Добавить цену';

  @override
  String get prices_add_a_receipt => 'Добавить чек';

  @override
  String get prices_add_price_tags => 'Добавить ценники';

  @override
  String prices_barcode_already(String barcode) {
    return 'Этот штрих-код ($barcode) уже есть в списке!';
  }

  @override
  String get prices_barcode_search_not_found => 'Продукт не найден';

  @override
  String get prices_barcode_search_none_yet => 'Пока нет продукта';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Ищу $barcode';
  }

  @override
  String get prices_barcode_enter => 'Введите штрих-код';

  @override
  String get prices_category_enter => 'Товар без штрих-кода';

  @override
  String get prices_per_kilogram => 'Цена за килограмм';

  @override
  String get prices_per_unit => 'Цена за единицу товара';

  @override
  String get prices_per_kilogram_short => ' / кг';

  @override
  String get prices_per_unit_short => ' / единица';

  @override
  String get prices_category_mandatory => 'Обязательно';

  @override
  String get prices_category_optional => 'Необязательный';

  @override
  String get prices_category_error_mandatory => 'Категория обязательна';

  @override
  String get prices_barcode_reader_action => 'Считыватель штрих-кода';

  @override
  String get prices_view_prices => 'Посмотреть цены';

  @override
  String get prices_list_title => 'Прайс-лист';

  @override
  String get prices_list_count => 'Количество\nцен';

  @override
  String get prices_list_add_new_price => 'Добавьте новую цену\n';

  @override
  String get prices_list_empty_title => 'Цена пока неизвестна!';

  @override
  String get prices_list_empty_subtitle =>
      'Будьте первым, кто добавит:\nОтсканировав **чек** или **ценник**!';

  @override
  String get prices_entry_shop_not_found => 'Неизвестный магазин';

  @override
  String prices_entry_menu_title(String user) {
    return 'Цена записи от \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Посмотреть все цены на этот продукт';

  @override
  String get prices_entry_menu_open_proof => 'Посмотреть доказательство';

  @override
  String get prices_entry_menu_my_prices => 'Посмотреть мои другие цены';

  @override
  String get prices_entry_menu_author_prices => 'Посмотреть другие цены автора';

  @override
  String get prices_entry_menu_shop_prices =>
      'Посмотреть другие цены из магазина';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count цены',
      one: '1 цена',
      many: '$count цены',
      few: '$count цены',
    );
    return '$_temp0 за $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Все $count цены',
      one: 'Только одна цена',
      zero: 'Пока нет цены',
      many: 'Все $count цены',
      few: 'Все $count цены',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Последние $pageSize цены (всего: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Цена: $price / Магазин: \"$location\" / Опубликовано $date пользователем \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Открытые доказательства \"$user\"';
  }

  @override
  String get prices_open_proof => 'Цена открыта';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Все $count доказательства',
      one: 'Только одно доказательство',
      zero: 'Пока нет доказательств',
      many: 'Все $count доказательства',
      few: 'Все $count доказательства',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Последние $pageSize доказательства (всего: $total)';
  }

  @override
  String get prices_users_empty_title => 'Пока нет участников!';

  @override
  String get prices_users_empty_explanation =>
      'Будьте первым, кто добавит цену!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Лучшие $pageSize участники (всего: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Магазина пока нет!';

  @override
  String get prices_locations_empty_explanation =>
      'Будьте первым, кто добавит цену!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Лучшие $pageSize локации (всего: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count доказательства',
      one: 'Одно доказательство',
      zero: 'Нет доказательств',
      many: '$count доказательства',
      few: '$count доказательства',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count продуктов',
      one: 'Один продукт',
      zero: 'Нет продукта',
      many: '$count продуктов',
      few: '$count продуктов',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count пользователей',
      one: 'Один пользователь',
      zero: 'Нет пользователя',
      many: '$count пользователей',
      few: '$count пользователей',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count цены',
      one: 'Одна цена',
      zero: 'Нет цены',
      many: '$count цены',
      few: '$count цены',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Цена ранее добавлена';

  @override
  String get prices_amount_subtitle => 'Количество';

  @override
  String get prices_amount_is_discounted => 'Есть ли скидка?';

  @override
  String get prices_amount_price_normal => 'Цена';

  @override
  String get prices_amount_price_discounted => 'Цена со скидкой';

  @override
  String get prices_amount_price_not_discounted => 'Начальная цена';

  @override
  String get prices_amount_no_product => 'Не хватает одного товара!';

  @override
  String get prices_amount_price_incorrect => 'Некорректное значение';

  @override
  String get prices_amount_price_mandatory => 'Обязательное значение';

  @override
  String get prices_currency_subtitle => 'Валюта';

  @override
  String get prices_date_subtitle => 'Дата';

  @override
  String get prices_location_subtitle => 'Магазин';

  @override
  String get prices_location_find => 'Найти магазин';

  @override
  String get prices_location_mandatory => 'Вам нужно выбрать магазин!';

  @override
  String get prices_location_search_broader =>
      'Не смогли найти то, что искали? Давайте попробуем более широкий поиск!';

  @override
  String get prices_proof_subtitle => 'Доказательство';

  @override
  String get prices_proof_empty_title => 'Пока нет доказательств!';

  @override
  String get prices_proof_empty_explanation =>
      'Начните с добавления фотографии **чека** или **ценника**!';

  @override
  String get prices_proof_find => 'Выберите доказательство';

  @override
  String get prices_proof_change => 'Изменение доказательства';

  @override
  String get prices_proof_receipt => 'Чек';

  @override
  String get prices_proof_price_tag => 'Ценник';

  @override
  String get prices_proof_mandatory => 'Вам нужно выбрать доказательство!';

  @override
  String get prices_add_validation_error => 'Ошибка проверки';

  @override
  String get prices_privacy_warning_title =>
      'Предупреждение о конфиденциальности';

  @override
  String get prices_unknown_product => 'Неизвестный продукт';

  @override
  String get prices_privacy_warning_main_message =>
      'Цены **будут публичными**, вместе с магазином, к которому они относятся.\n\nЭто может позволить людям, знающим ваш псевдоним Open Food Facts:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Определите, в каком районе вы живете';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Знайте, что вы покупаете';

  @override
  String get prices_privacy_warning_sub_message =>
      'Если вас это не устраивает, пожалуйста, измените свой псевдоним или создайте новую учетную запись Open Food Facts и войдите в приложение, используя ее.';

  @override
  String get i_refuse => 'Я отказываюсь';

  @override
  String get i_accept => 'Я принимаю';

  @override
  String get prices_currency_change_proposal_title => 'Изменить валюту?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Ваша текущая валюта **$currency**. Хотите изменить ее на **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Да, используйте $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Нет, оставь $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Готово';

  @override
  String get dev_mode_section_server => 'Настройка сервера';

  @override
  String get dev_mode_section_news => 'Конфигурация поставщика новостей';

  @override
  String get dev_mode_section_product_page => 'Страница товара';

  @override
  String get dev_mode_section_ui => 'Пользовательский интерфейс';

  @override
  String get dev_mode_section_experimental_features =>
      'Экспериментальные функции';

  @override
  String get dev_mode_hide_environmental_score_title => 'Исключить Green Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Используйте проверку орфографии для экранов OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(Состав и упаковка)';

  @override
  String get dev_mode_reset_app_language_title => 'Сбросить язык приложения';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Добавить карты';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Switch between prices.openfoodfacts.org (PROD) and test env';

  @override
  String get search_history_item_edit_tooltip =>
      'Повторно используйте и редактируйте этот поиск';

  @override
  String get search_history_item_remove_tooltip => 'Удалить';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Вы загрузили все $totalSize продукты.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Загрузить $count еще продуктов\nУже загружено $downloaded из $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Ваш поиск $search продолжается.\n\nПожалуйста, подождите несколько секунд…';
  }

  @override
  String get user_search_contributor_title => 'Добавленные мной продукты';

  @override
  String get user_search_informer_title => 'Отредактированные мной продукты';

  @override
  String get user_search_photographer_title =>
      'Сфотографированные мной продукты';

  @override
  String get user_search_to_be_completed_title => 'Мои незавершённые продукты';

  @override
  String get user_search_prices_title => 'Мои цены';

  @override
  String get user_search_proofs_title => 'Мои доказательства';

  @override
  String get user_search_proof_title => 'Моё доказательство';

  @override
  String search_proof_title(String user) {
    return 'Доказательство из \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Цены для участников: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Последние добавленные цены';

  @override
  String get all_search_prices_top_user_title => 'Лучшие ценовые участники';

  @override
  String get all_search_prices_top_location_title =>
      'Магазин с наибольшими ценами';

  @override
  String get prices_contribution_assistant => 'Помощник по ценам';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Вызовы';

  @override
  String get prices_multiple_proof_addition_system =>
      'Добавить несколько доказательств';

  @override
  String get all_search_prices_top_location_single_title => 'Цены в магазине';

  @override
  String get all_search_prices_top_product_title =>
      'Продукты с самыми высокими ценами';

  @override
  String get all_search_to_be_completed_title => 'Все незавершённые продукты';

  @override
  String get categorize_products_country_title =>
      'Помогите классифицировать товары в вашей стране';

  @override
  String get edit_product_action_retake_picture => 'Переснять';

  @override
  String get edit_product_action_take_picture => 'Сфотографировать';

  @override
  String get edit_product_action_confirm => 'Подтвердить';

  @override
  String get signup_page_terms_of_use_line1 => 'Я согласен с Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => 'условия использования и вклад';

  @override
  String get analytics_consent_image_semantic_label => 'Значок аналитики';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Критическая ошибка: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Критическая ошибка: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'Детальная информация';

  @override
  String get edit_photo_button_label => 'Редактировать';

  @override
  String get edit_photo_unselect_button_label => 'Отменить выбор фото';

  @override
  String get edit_photo_select_existing_button_label =>
      'Выберите существующее изображение';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Выберите изображение, нажав на него.';

  @override
  String get edit_photo_select_existing_download_label =>
      'Извлечение существующих изображений…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Ранее не было загружено ни одного изображения, связанного с этим продуктом.';

  @override
  String get edit_photo_language_not_this_one =>
      'Пока нет изображения на этом языке';

  @override
  String get edit_photo_language_none => 'Пока нет изображения';

  @override
  String get category_picker_screen_title => 'Категории';

  @override
  String get basic_details => 'Основные сведения';

  @override
  String get product_name => 'Название продукта';

  @override
  String get product_names => 'Названия продуктов';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Добавить новый перевод';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Перед проверкой убедитесь, что вы добавляете перевод только **если язык присутствует на упаковке**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Посмотреть переднее фото';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Сделать фото спереди';

  @override
  String get add_basic_details_product_name_hint =>
      'Введите название продукта (например: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Изменить язык по умолчанию?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Хотите ли вы, чтобы язык продукта по умолчанию был установлен на «$language»?';
  }

  @override
  String get explanation_section_good_examples => 'Хорошие примеры';

  @override
  String get explanation_section_bad_examples => 'Плохие примеры';

  @override
  String get add_basic_details_product_name_help_title =>
      'Хорошая практика: название продукта';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Название товара - **основное имя, напечатанное на упаковке**. Оно может быть зарегистрированным товарным знаком.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Внимание:** Пожалуйста, не добавляйте перевод, **если язык отсутствует на упаковке**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Томатный кетчуп';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Не включайте бренд в название';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Томатный кетчуп **от Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Не используйте символы ®, ™, © или подобные.';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count другие переводы',
      many: '$count другие переводы',
      few: '$count другие переводы',
      one: '$count другой перевод',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Бренд';

  @override
  String get brand_names => 'Названия брендов';

  @override
  String get add_basic_details_brand_name_error =>
      'Пожалуйста, введите название бренда';

  @override
  String get add_basic_details_brand_names_hint =>
      'Внесите бренды (например: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Хорошие практики: Бренды';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Ввод **всех марок продукта**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Основной бренд';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Основной бренд**, который обычно четко указан на передней упаковке, следует **ввести первым**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Другие бренды';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Когда продано **крупной компанией**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** продается компанией **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'При продаже с торговой маркой **переведенной на несколько языков**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** иногда пишется как **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Количество и вес';

  @override
  String get add_basic_details_quantity_hint =>
      'Введите вес и при необходимости количество (например, 4x100гр)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Хорошие практики: Количество';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Скопируйте значение, указанное на товаре, и **не забудьте единицы измерения**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 г** или **230 г**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (для 6 яиц)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 г**\n(для продукта с 3 коробками, каждая по 150 г)';

  @override
  String get barcode => 'Штрих-код';

  @override
  String barcode_barcode(String barcode) {
    return 'Штрихкод: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Неверный штрихкод';

  @override
  String get basic_details_add_success => 'Основные сведения успешно добавлены';

  @override
  String get basic_details_add_error =>
      'Не удалось добавить основные сведения. Повторите попытку через некоторое время';

  @override
  String get clear_search => 'Очистить поиск';

  @override
  String get confirm_clear =>
      'Вы собираетесь очистить всю вашу историю: вы уверены, что хотите продолжить?';

  @override
  String get alert_clear_selected_user_list =>
      'Вы собираетесь очистить выбранные элементы в своей истории';

  @override
  String get confirm_clear_selected_user_list =>
      'Вы уверены, что хотите продолжить?';

  @override
  String get alert_select_items_to_clear =>
      'Пожалуйста, выберите один или несколько элементов для очистки';

  @override
  String confirm_clear_user_list(String name) {
    return 'Вы собираетесь удалить список ($name). Вы действительно хотите продолжить?';
  }

  @override
  String get confirm_delete_user_list_title => 'Удалить список?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Вы собираетесь удалить список «$name».\nВы уверены, что хотите продолжить?';
  }

  @override
  String get confirm_delete_user_list_button => 'Да, я подтверждаю.';

  @override
  String importance_label(String name, String id) {
    return 'Важность $name: $id';
  }

  @override
  String get user_list_all_title => 'Списки';

  @override
  String get user_list_all_empty => 'Создать ваш первый список';

  @override
  String get product_list_select => 'Выберите список';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count продукт(а/ов)',
      one: 'Один продукт',
      zero: 'Пустой список',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Добавить список';

  @override
  String get open_food_preferences_tooltip =>
      'Изменить Ваши предпочтения в еде';

  @override
  String get add_photo_button_label => 'Добавить фото';

  @override
  String get add_packaging_photo_button_label =>
      'Сфотографируйте всю информацию об упаковке/переработке.';

  @override
  String get add_origin_photo_button_label =>
      'Сфотографируйте любую информацию о происхождении';

  @override
  String get add_emb_photo_button_label =>
      'Сфотографируйте всю информацию о коде отслеживания.';

  @override
  String get add_label_photo_button_label =>
      'Сфотографируйте все этикетки и информацию о сертификации.';

  @override
  String get choose_image_source_title => 'Выбрать источник изображения';

  @override
  String get choose_image_source_body =>
      'Пожалуйста, выберите источник изображения';

  @override
  String get gallery_source_label => 'Галерея';

  @override
  String get gallery_source_access_denied_dialog_title => 'Доступ запрещён';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'К сожалению, приложение не может получить доступ к вашей галерее, так как вы ранее отказали в разрешении.\n\nПожалуйста, перейдите в настройки приложения в настройках телефона -> Фотографии';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Откройте приложение Настройки';

  @override
  String get share => 'Поделиться';

  @override
  String share_product_text(String url) {
    return 'Посмотрите как выглядит этот продукт на Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Посмотрите этот продукт на Open Beauty Facts:';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Взгляните на этот продукт на сайте Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Взгляните на этот продукт на сайте Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Взгляните на мой список продуктов на Open Food Facts: $url';
  }

  @override
  String get capture => 'Новый снимок';

  @override
  String get capture_new_picture => 'Сфотографировать';

  @override
  String get choose_from_gallery => 'Выбрать из галереи';

  @override
  String get image_upload_queued =>
      'Изображение будет загружено в фоновом режиме как можно скорее.';

  @override
  String get add_price_queued =>
      'Цена будет отправлена на сервер как можно скорее.';

  @override
  String get background_task_title_full_refresh =>
      'Начинаем обновление всех локально хранящихся продуктов.';

  @override
  String get background_task_title_folksonomy =>
      'Начало выполнения действий сервера для обновлений folksonomy, хранящихся локально.';

  @override
  String get background_task_title_top_n =>
      'Начинаем загрузку самых популярных продуктов';

  @override
  String get expand_nutrition_facts => 'Развернуть таблицу пищевой ценности';

  @override
  String get expand_nutrition_facts_body =>
      'Оставить таблицу пищевой ценности развернутой';

  @override
  String get expand_ingredients => 'Развернуть ингредиенты';

  @override
  String get expand_ingredients_body =>
      'Оставить панель ингредиентов развернутой';

  @override
  String get no_internet_connection => 'Нет подключения к интернету';

  @override
  String get world_results_label => 'Весь мир';

  @override
  String get world_results_action => 'Расширить ваш поиск до всего мира';

  @override
  String get copy_to_clipboard => 'Копировать';

  @override
  String get paste_from_clipboard => 'Вставить из буфера обмена';

  @override
  String get no_data_available_in_clipboard =>
      'В вашем буфере обмена нет доступных данных';

  @override
  String get clipboard_barcode_copy => 'Скопировать штрихкод в буфер обмена';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Штрих-код $barcode скопирован в буфер обмена!';
  }

  @override
  String get open_product_website => 'Открыть этот продукт на сайте';

  @override
  String get language_picker_label => 'Ваш язык';

  @override
  String get country_picker_label => 'Ваша страна';

  @override
  String get currency_picker_label => 'Ваша валюта';

  @override
  String get help_with_openfoodfacts => 'Помощь с OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Продукт будет обновлен в фоновом режиме как можно скорее.';

  @override
  String get no_email_client_available_dialog_title =>
      'Нет почтовых приложений!';

  @override
  String get no_email_client_available_dialog_content =>
      'Пожалуйста, отправьте нам электронное письмо вручную на адрес mobile@openfoodfacts.org';

  @override
  String get all_images => 'Все изображения';

  @override
  String get selected_images =>
      'Ważne: potrzebujemy Twojego wsparcia!\n\nOpen Food Facts to wspólny projekt stworzony przez dziesiątki tysięcy wolontariuszy i zarządzany przez organizację non-profit z 4 pracownikami.\nPotrzebujemy Twoich darowizn, aby sfinansować budżet Open Food Facts na rok 2022 i kontynuować prace nad projektem. Dziękuję! ❤️';

  @override
  String get product_card_remove_product_tooltip => 'Удалить продукт';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Новый штрих-код отсканирован: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Удалить все продукты из карусели';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Пожалуйста, отсканируйте как минимум два продукта, чтобы сравнить их.';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Нажмите, чтобы сравнить отсканированные вами продукты';

  @override
  String get scan_product_loading => 'Вы отсканировали\nштрих-код:';

  @override
  String get scan_product_loading_initial =>
      'Мы ищем этот продукт!\nПожалуйста, подождите несколько секунд…';

  @override
  String get scan_product_loading_long_request =>
      'Мы все еще ищем этот продукт!\nВы считаете, что загрузка займет много времени? Так и есть…';

  @override
  String get scan_product_loading_unresponsive =>
      'Мы все еще ищем этот продукт.\nХотите перезапустить поиск?';

  @override
  String get scan_product_loading_restart_button => 'Искать заново';

  @override
  String get portion_calculator_description =>
      'Рассчет пищевой ценности для определенного количества';

  @override
  String get portion_calculator_hint => 'Количество в';

  @override
  String get portion_calculator_accessibility =>
      'Введите количество для расчета пищевой ценности';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Введите количество от $min до $max г';
  }

  @override
  String get portion_calculator_computation_error =>
      'Отсутствуют данные. Расчет не может быть выполнен.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Пищевая ценность на $grams г (или мл)';
  }

  @override
  String get offline_data => 'Автономные данные';

  @override
  String get ocr_image_upload_instruction =>
      'Загрузка изображения с извлечением автоматически распознанного текста.';

  @override
  String get upload_image => 'Загрузить Фото';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Не удалось загрузить изображение';

  @override
  String get image_edit_url_error =>
      'Не удалось отредактировать изображение, так как URL изображения не был задан.';

  @override
  String get user_picture_source_remember => 'Запомнить мой выбор';

  @override
  String get user_picture_source_ask => 'Спрашивать каждый раз';

  @override
  String get robotoff_continue => 'Продолжить';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Следующий $count вопрос',
      one: 'Следующий вопрос',
      many: 'Следующие $count вопросов',
      few: 'Следующие $count вопроса',
    );
    return '$_temp0';
  }

  @override
  String get show_password => 'Показать пароль';

  @override
  String get owner_field_info_title =>
      'Значения, предоставленные производителем';

  @override
  String get owner_field_info_message =>
      'Этим логотипом мы выделяем данные, предоставленные производителем, и они могут быть нередактируемыми.';

  @override
  String get owner_field_info_close_button => 'Закрыть эту информацию';

  @override
  String get owner_field_image =>
      'Это изображение предоставлено производителем. Оно может быть нередактируемым.';

  @override
  String get edit_packagings_title => 'Компоненты упаковки';

  @override
  String get edit_packagings_element_add => 'Добавить компонент упаковки';

  @override
  String get edit_packagings_completed => 'Упаковка завершена';

  @override
  String edit_packagings_element_title(int index) {
    return 'Компонент упаковки #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Количество единиц';

  @override
  String get edit_packagings_element_hint_units =>
      'Введите количество упаковочных единиц одинаковой формы и материала, содержащихся в изделии.';

  @override
  String get edit_packagings_element_field_shape => 'Форма';

  @override
  String get edit_packagings_element_hint_shape =>
      'Введите название формы, указанное в инструкциях по переработке, если они имеются, или выберите форму.';

  @override
  String get edit_packagings_element_example_shape => 'Бутылка';

  @override
  String get edit_packagings_element_field_material => 'Материал';

  @override
  String get edit_packagings_element_hint_material =>
      'Введите конкретный материал, если его можно определить (код материала внутри треугольника часто можно найти на упаковочных деталях), или общий материал (например, пластик или металл), если вы не уверены.';

  @override
  String get edit_packagings_element_example_material => 'Стекло';

  @override
  String get edit_packagings_element_field_recycling =>
      'Инструкция по переработке';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Введите инструкции по переработке только в том случае, если они указаны на изделии.';

  @override
  String get edit_packagings_element_example_recycling => 'Переработка';

  @override
  String get edit_packagings_element_field_quantity =>
      'Количество продуктов в единице товара';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Введите чистый вес или чистый объем и укажите единицу измерения (например, г или мл).';

  @override
  String get edit_packagings_element_field_weight => 'Масса тары (г)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Удалите остатки пищи, вымойте и высушите упаковочную часть перед взвешиванием. Если возможно, используйте весы с точностью 0,1 г или 0,01 г.';

  @override
  String get background_task_title => 'Ожидаемые взносы';

  @override
  String get background_task_subtitle =>
      'Ваши сообщения автоматически сохраняются на нашем сервере, но не всегда в режиме реального времени.';

  @override
  String get background_task_list_empty => 'Нет ожидающих фоновых задач';

  @override
  String get background_task_error_server_time_out => 'Время ожидания сервера';

  @override
  String get background_task_error_no_internet =>
      'Ошибка подключения к Интернету. Попробуйте позже.';

  @override
  String get background_task_operation_unknown => 'неизвестный тип операции';

  @override
  String get background_task_operation_details => 'подробные изменения';

  @override
  String get background_task_operation_image => 'загрузка фото';

  @override
  String get background_task_operation_refresh =>
      'обновление отложено после загрузки фото';

  @override
  String get background_task_run_started => 'начато';

  @override
  String get background_task_run_not_started => 'Пока не начато';

  @override
  String get background_task_run_to_be_deleted => 'для удаления';

  @override
  String get background_task_question_stop =>
      'Хотите ли вы остановить эту задачу как можно скорее?';

  @override
  String get feed_back => 'Обратная связь';

  @override
  String get undo => 'Отменить';

  @override
  String get copy_email_to_clip_board =>
      'Скопировать адрес эл. почты в буфер обмена';

  @override
  String get please_send_us_an_email_to =>
      'Пожалуйста, отправьте нам вручную электронное письмо на адрес';

  @override
  String get email_copied_to_clip_board => 'Email скопирован в буфер обмена!';

  @override
  String get select_accent_color => 'Выберите акцентный цвет';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Синий';

  @override
  String get color_cyan => 'Циан';

  @override
  String get color_green => 'Зеленый';

  @override
  String get color_light_brown => 'Стандартный';

  @override
  String get color_magenta => 'Красновато-Лиловый';

  @override
  String get color_orange => 'Оранжевый';

  @override
  String get color_pink => 'Розовый';

  @override
  String get color_red => 'Красный';

  @override
  String get color_rust => 'Ржавчина';

  @override
  String get color_teal => 'Бирюза';

  @override
  String get text_contrast_mode => 'Контрастность текста';

  @override
  String get contrast_high => 'Высокая';

  @override
  String get contrast_medium => 'Средняя';

  @override
  String get contrast_low => 'Низкая';

  @override
  String get product_refresher_internet_not_found => 'Продукт не найден!';

  @override
  String get product_refresher_internet_not_connected =>
      'Вы не подключены к интернету!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Сервер не работает ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Ошибка сервера ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Продукт не найден!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Продукт со следующим штрихкодом не существует в нашей базе данных: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Нет подключения к интернету!';

  @override
  String get product_loader_network_error_message =>
      'Убедитесь, что ваш смартфон подключен к сети Wi-Fi или на нем включена передача мобильных данных.';

  @override
  String get page_not_found_title => 'Страница не найдена!';

  @override
  String get page_not_found_button => 'Вернуться на главную страницу';

  @override
  String get download_data => 'Скачать данные';

  @override
  String get download_top_products =>
      'Загрузите 1000 лучших товаров в вашей стране для мгновенного сканирования';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count продукты',
      many: '$count продукты',
      few: '$count продукты',
      one: '',
    );
    return 'Загрузите лучшие $_temp0 в вашей стране для мгновенного сканирования';
  }

  @override
  String get download_in_progress =>
      'Загрузка данных\nЭто может занять некоторое время.';

  @override
  String downloaded_products(int num) {
    return '$num добавлено товаров';
  }

  @override
  String get update_offline_data =>
      'Обновление данных о продукте в автономном режиме';

  @override
  String get update_local_database_sub =>
      'Обновите локальную базу данных продуктов с использованием последних данных Open Food Facts';

  @override
  String get clear_local_database =>
      'Очистить данные о продукте в автономном режиме';

  @override
  String get clear_local_database_sub =>
      'Удалите все данные о локальных продуктах из вашего приложения, чтобы освободить место';

  @override
  String deleted_products(int num) {
    return '$num продуктов удалено';
  }

  @override
  String get loading => 'Загрузка…';

  @override
  String get know_more => 'Узнать больше';

  @override
  String get offline_data_desc =>
      'Нажмите, чтобы узнать больше об офлайн-данных';

  @override
  String get offline_product_data_title =>
      'Данные о продуктах в автономном режиме';

  @override
  String available_for_download(int num) {
    return '$num продуктов, доступных для немедленного сканирования';
  }

  @override
  String get country_selector_title => 'Выберите Вашу страну:';

  @override
  String get currency_selector_title => 'Выберите свою валюту';

  @override
  String get language_selector_title => 'Выберите свой язык:';

  @override
  String get language_selector_section_selected => 'Выбранные языки';

  @override
  String get language_selector_section_frequently_used => 'Недавние';

  @override
  String get action_delete_list => 'Удалить';

  @override
  String get action_change_list => 'Изменить текущий список';

  @override
  String get product_list_create => 'Создать';

  @override
  String get product_list_create_tooltip => 'Создание нового списка';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Новый расчет)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (новый расчет)';

  @override
  String get nutriscore_unknown => 'Неизвестно Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Неизвестно Nutri-Score (новый расчет)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score не применим';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score неприменим (новый расчет)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Green-Score A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => 'Неизвестный Green-Score';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score не применяется';

  @override
  String get nova_group_generic_new =>
      'Ультраобработанные продукты - группы NOVA';

  @override
  String get nova_group_1 => 'NOVA Группа 1';

  @override
  String get nova_group_2 => 'NOVA Группа 2';

  @override
  String get nova_group_3 => 'NOVA Группа 3';

  @override
  String get nova_group_4 => 'NOVA Группа 4';

  @override
  String get nova_group_unknown => 'Неизвестная группа NOVA';

  @override
  String get nutrition_facts => 'Уровни питательных веществ';

  @override
  String get faq_title_partners => 'Партнеры и покровители НПО';

  @override
  String get faq_title_vision =>
      'Видение, миссия, ценности и программы Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Установите Open Beauty Facts, чтобы создать базу данных косметических средств';

  @override
  String get faq_title_install_pet =>
      'Установите Open Pet Food Facts, чтобы создать базу данных кормов для домашних животных';

  @override
  String get faq_title_install_product =>
      'Установите Open Products Facts, чтобы создать базу данных продуктов и продлить срок службы объектов.';

  @override
  String get faq_nutriscore_nutriscore =>
      'Новый расчет Nutri-Score: что нового?';

  @override
  String get contact_title_pro_page =>
      'Вы производитель? Импортируйте данные о своих продуктах в Open Food Facts';

  @override
  String get contact_title_pro_email => 'Связаться с нами (для производителей)';

  @override
  String get contact_title_press_page => 'Материалы для прессы';

  @override
  String get contact_title_press_email => 'Связаться с нами (для прессы)';

  @override
  String get contact_title_newsletter => 'Подпишитесь на нашу рассылку';

  @override
  String get contact_title_calendar =>
      'Подпишитесь на наш календарь сообщества';

  @override
  String get hunger_games_loading_line1 =>
      'Пожалуйста, дайте нам несколько секунд…';

  @override
  String get hunger_games_loading_line2 => 'Мы загружаем вопросы!';

  @override
  String get hunger_games_error_label =>
      'Ах! Что-то пошло не так… и нам не удалось загрузить вопросы.';

  @override
  String get hunger_games_error_retry_button => 'Попробуем ещё раз!';

  @override
  String get reorder_attribute_action => 'Изменить порядок атрибутов';

  @override
  String get link_cant_be_opened =>
      'Эта ссылка не может быть открыта на вашем устройстве. Проверьте, установлен ли у вас браузер.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Подробности для $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Подробности для $pageName с $productName';
  }

  @override
  String get guide_title => 'Гайд';

  @override
  String get guide_share_label => 'Поделиться';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Что такое Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Где найти новый расчет Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score применяется в 7 странах: Франции, Германии, Бельгии, Испании, Люксембурге, Нидерландах и Швейцарии.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'У производителей есть максимум **2 года** после подписания указа, чтобы **заменить** старый расчет новым.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Что такое «Зеленый счет»?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score — это логотип, цель которого — информировать вас о **воздействии продуктов питания на окружающую среду**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Цветовой код варьируется от темно-зеленого (**A+**) для **наименее эффективных** продуктов до темно-красного (**F**) для **наиболее эффективных** продуктов.';

  @override
  String get guide_greenscore_logos_caption => 'Логотипы Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Ядро: Оценка жизненного цикла (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Научная оценка категорий продуктов питания';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Для каждой категории продуктов **контрольный** балл устанавливается с использованием данных из экологической базы данных Agribalyse (разработанной ADEME и INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Анализ жизненного цикла** — это стандартизированный метод оценки, позволяющий проводить многоэтапную и многокритериальную оценку воздействия на окружающую среду.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Он измеряет:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 этапов производства';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Сельское хозяйство';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Обработка';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Упаковка';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Транспорт';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Распределение';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Потребление';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 показателей воздействия на окружающую среду';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Изменение климата/углеродный след';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Разрушение озонового слоя';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ионизирующее излучение';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Земля';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Использование воды и энергии';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Загрязнение воздуха';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Морская и пресная вода (частицы, закисление, эвтрофикация)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Истощение ресурсов.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Бонусы и штрафы';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Чтобы поощрить лучшие продукты в категории, мы применяем **бонусы и штрафы на основе нескольких критериев**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Метод производства';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Бонус** начисляется за продукцию, имеющую **официальную маркировку, этикетку или сертификацию, гарантирующую экологические преимущества** (органическая, справедливая торговля, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Происхождение ингредиентов';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Бонус** присуждается в зависимости от происхождения ингредиентов. Он учитывает **воздействие на транспорт**, а также **экологическую политику** страны-производителя.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title => 'Вымирающие виды';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Штраф** налагается на продукты, содержащие ингредиенты, которые оказывают значительное **негативное воздействие на биоразнообразие и экосистемы**, например, пальмовое масло, производство которого приводит к массовой вырубке лесов.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Упаковка';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Штраф** рассчитывается с учетом **циркуляционности упаковки** (использования переработанного сырья и возможности вторичной переработки), а также избыточной упаковки.';

  @override
  String get guide_greenscore_transparency_title =>
      'Повышенная потребность в прозрачности для лучшего измерения и снижения воздействия на окружающую среду';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Для точного расчета Green-Score необходимо иметь **информацию, которая не обязательно указана на упаковке** (например, происхождение и точное процентное содержание каждого ингредиента) или которая редко доступна в удобной для использования форме (например, список всех компонентов упаковки с указанием точных типов использованного пластика).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Когда эта информация еще недоступна, используются средние значения**, но сейчас мы призываем всех помочь нам собрать эту информацию, которая будет очень полезна для Green-Score, а также для многих других целей.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Какую помощь могут оказать граждане?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Все граждане могут помочь нам собрать и структурировать информацию, которая присутствует на продуктах или которую можно из них вывести, например, информацию об **упаковке**: «Mission Emballages»: масштабная совместная инвентаризация упаковки для всех пищевых продуктов (на французском языке).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Как производители могут помочь';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Производители могут отправлять нам свою информацию напрямую через нашу бесплатную платформу для производителей.';

  @override
  String get guide_greenscore_better_product_title =>
      'Какой продукт полезнее для планеты?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Это может быть трудно сказать.';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Выбор экологически чистых продуктов питания — одно из самых важных действий, которые мы можем предпринять для защиты климата, поскольку **наша глобальная продовольственная система ответственна за более чем четверть всех выбросов парниковых газов**.\n(Источник: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'У тебя есть сила!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Хорошая новость в том, что это даёт нам мощный способ изменить ситуацию.\n**Каждый из нас ест около 1000 раз в год**. Это 1000 возможностей **выбрать лучшее будущее для планеты**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Помогает быть ответственным и принимать решения';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Выбор экологичных продуктов питания может показаться сложным. Этикетки сбивают с толку, а информация часто отсутствует. Green-Score был создан, чтобы упростить этот процесс, предоставляя вам **чёткий**, **научно обоснованный** и **прозрачный** экологический рейтинг продуктов питания прямо там, где он вам нужен: во время покупок.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Прозрачность';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'В отличие от фирменных лейблов, расчет Green-Score **полностью открыт** и может быть **проверен любым**.';

  @override
  String get guide_nova_title => 'Ультра-обработанные продукты';

  @override
  String get guide_nova_what_is_nova_title => 'Что такое ультраобработка?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Группы NOVA информируют вас об уровне переработки пищевых продуктов.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Классификация NOVA позволяет разделить продукты на **4 группы** в зависимости от их **степени промышленной обработки** (минимально обработанные или необработанные продукты, кулинарные ингредиенты, обработанные продукты, ультраобработанные продукты).';

  @override
  String get guide_nova_logos_caption => 'Логотипы NOVA';

  @override
  String get guide_nova_groups_title => '4 группы NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Существует 4 группы NOVA, проблемной из которых является Группа 4 — Ультраобработанные продукты.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Минимально обработанные или необработанные продукты';

  @override
  String get guide_nova_groups_arg1_text =>
      'Необработанные (или натуральные) продукты — это **съедобные части растений** (семена, плоды, листья, стебли, корни) **или животных** (мышцы, субпродукты, яйца, молоко), а также грибы, водоросли и вода после отделения от природы.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Обработанные кулинарные ингредиенты';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Обработанные пищевые продукты';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from Group 2 to Group 1** foods. processes include various preservation or cooking methods, and in the case of Breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable As modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ультра-обработанные продукты';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 Food. Ingredients In these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-Processed products also contain other sources of energy and nutrients not typically used in culinary preparations. Some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Проблемы с ультра-обработкой';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Экстремальная обработка пищевых ингредиентов';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Многие из них **получены в результате дальнейшей переработки пищевых компонентов**, таких как гидрогенизированные или переэтерифицированные масла, гидролизованные белки, изолят соевого белка, мальтодекстрин, инвертный сахар и кукурузный сироп с высоким содержанием фруктозы.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Добавки, выходящие за рамки простой безопасности пищевых продуктов';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Добавки в ультрапереработанных продуктах включают в себя те же, что используются и в обработанных продуктах, например, консерванты, антиоксиданты и стабилизаторы. К классам добавок, встречающихся только в ультрапереработанных продуктах, относятся те, которые используются **для имитации или улучшения сенсорных качеств продуктов или для маскировки неприятных вкусовых качеств конечного продукта**. К таким добавкам относятся красители и другие красители, стабилизаторы цвета, ароматизаторы, усилители вкуса, подсластители, не содержащие сахара, а также технологические добавки, такие как карбонизаторы, уплотнители, наполнители и антинаполнители, пеногасители, антислеживатели и глазирующие агенты, эмульгаторы, секвестранты и увлажнители.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Обработка, которую невозможно выполнить дома';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Для объединения обычно многочисленных ингредиентов и создания конечного продукта (отсюда и название «ультраобработанный») используется множество последовательных процессов**. В их число входят несколько процессов, **не имеющих отечественных аналогов**, например, гидрогенизация и гидролиз, экструзия и формование, а также предварительная обработка для жарки.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Хищнические и финансовые аспекты ультрапереработки';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Главная цель ультрапереработки — создание фирменных**, **удобных** (долговечных, готовых к употреблению), **привлекательных** (очень вкусных) и **высокорентабельных** (с недорогими ингредиентами) пищевых продуктов, призванных вытеснить все другие группы продуктов. Ультрапереработанные продукты обычно имеют привлекательную упаковку и активно продвигаются на рынке.';

  @override
  String get guide_nova_explanations_arg5_title => 'Опасность для здоровья';

  @override
  String get guide_nova_explanations_arg5_text =>
      'С 2018 года благодаря проекту NutriNet-Santé впервые была выявлена связь между **потреблением ультра-обработанных продуктов и повышенным риском развития рака, сердечно-сосудистых заболеваний и диабета**. Сегодня более 90 исследований по всему миру подтверждают эти результаты.\nНаиболее выраженная связь связана с **ожирением, смертностью от сердечно-сосудистых заболеваний и симптомами депрессии**. У детей это влияние в первую очередь проявляется в виде нарушения веса и липидного баланса.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Страны рекомендуют ограничить их';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Некоторые страны используют группы NOVA для своих рекомендаций или целей по питанию, например:\n\n- **🇧🇷 Рекомендации по питанию Бразилии** **рекомендуют ограничить потребление** обработанных пищевых продуктов и избегать ультра-обработанных продуктов.\n\n- **🇫🇷 Цели политики общественного здравоохранения в области питания Франции** на 2018–2022 годы направлены на **сокращение потребления группы 4 ультра-обработанных продуктов на 20%**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Добро пожаловать на сайт Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Что такое Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts — это **совместная**, **бесплатная** и **открытая** база данных о продуктах питания со всего мира.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Мы считаем, что каждый должен иметь доступ к информации о том, что он ест. Собирая данные об ингредиентах, аллергенах, пищевой ценности и многом другом, мы **даем потребителям возможность делать осознанный выбор** и способствуем большей прозрачности пищевой промышленности**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Особенности Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Получайте оповещения о нежелательных ингредиентах';

  @override
  String get guide_open_food_facts_tips_title =>
      'Советы по съемке отличных фотографий';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Что нельзя делать';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Избегайте теней и бликов.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Никакого размытого или нерезкого текста.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Не обрезайте части текста.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Избегайте перегруженного фона.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Что нужно делать';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Используйте хорошее, равномерное освещение.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Убедитесь, что текст четкий и читаемый.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Сохраните полный список ингредиентов.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Храните изделие на ровной поверхности.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Помогите нам создать «Википедию еды»';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Оценка качества питания';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Оценка, позволяющая избегать ультра-обработанных продуктов';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Оценка для планеты';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-ru.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Добро пожаловать на сайт Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Что такое Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts распространяет свою миссию и на наших пушистых друзей! Это **база данных о кормах для кошек, собак и других домашних любимцев**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Мы собираем информацию о **ингредиентах**, **анализе питательной ценности** и рекомендациях по кормлению, чтобы помочь владельцам домашних животных выбрать лучший корм, соответствующий потребностям их животных.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Особенности Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Получайте оповещения о нежелательных ингредиентах';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Есть ли у вашего питомца аллергия на какие-либо ингредиенты в косметике? Вы можете составить список косметических ингредиентов, которых следует избегать, прямо в приложении!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Советы по съемке отличных фотографий';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Что нельзя делать';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Избегайте теней и бликов.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Никакого размытого или нерезкого текста.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Не обрезайте части текста.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Избегайте перегруженного фона.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Что нужно делать';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Используйте хорошее, равномерное освещение.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Убедитесь, что текст четкий и читаемый.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Сохраните полный список ингредиентов.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Храните изделие на ровной поверхности.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Примечание о подсчете очков';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Разработка системы оценки кормов для домашних животных **сейчас не является приоритетом**. Методология будет сложной, поскольку потребности в питании сильно различаются в зависимости от вида, возраста и состояния здоровья. Мы пока не нашли ни одной независимой научной группы, способной разработать такую систему.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-ru.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Добро пожаловать на сайт Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Что такое Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts — это совместная база данных **косметических продуктов**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Наша цель — расшифровать списки ингредиентов, чтобы помочь вам **понять, что входит в состав ваших средств личной гигиены**. От увлажняющих средств до декоративной косметики — мы собираем данные об ингредиентах, аллергенах и упаковке, чтобы способствовать прозрачности в косметической промышленности.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Особенности Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Получайте оповещения о нежелательных ингредиентах';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'У вас аллергия на какие-либо ингредиенты? Хотите избежать комедогенов? Хотите избежать использования спорных компонентов? Вы можете составить список косметических ингредиентов, которых следует избегать, прямо в приложении!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Советы по съемке отличных фотографий';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Что нельзя делать';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Избегайте теней и бликов.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Никакого размытого или нерезкого текста.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Не обрезайте части текста.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Избегайте перегруженного фона.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Что нужно делать';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Используйте хорошее, равномерное освещение.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Убедитесь, что текст четкий и читаемый.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Сохраните полный список ингредиентов.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Если бутылка изогнута, сделайте столько снимков, сколько необходимо.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Возможно, вам придется снять этикетку, чтобы увидеть список ингредиентов.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Храните изделие на ровной поверхности.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Примечание о подсчете очков';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'В отличие от продуктов питания, в мире косметики **нет общепризнанной, поддерживаемой государством системы оценки, подобной Nutri-Score**. Влияние ингредиентов может быть очень индивидуальным и зависеть от типа кожи, наличия аллергии и индивидуальных особенностей.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-ru.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Добро пожаловать в Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Что такое Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices — это проект по сбору и распространению данных о ценах на продукты по всему миру. Это общедоступный набор данных, который можно использовать для исследований, анализа и других целей. Open Prices разработан и поддерживается компанией Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'В настоящее время лишь немногие компании владеют большими базами данных цен на продукты на уровне штрих-кодов. Эти цены не находятся в свободном доступе, а продаются по высокой цене частным лицам, исследователям и другим организациям, которые могут себе их позволить.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Мы собираем данные о ценах из открытого источника**. Пользователи могут добавлять цены через это веб-приложение или через официальное мобильное приложение Open Food Facts. Розничные продавцы и сторонние приложения также могут вносить свой вклад, используя наш API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Собирайте фотографии ценников в проходах.';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Собирайте фотографии квитанций';

  @override
  String get guide_open_prices_why_title =>
      'Почему Open Food Facts это делает?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Информация о ценах имеет первостепенное значение для понимания продовольственных систем. Это ключевой фактор в оценке стоимости продуктов питания и продвижении более здорового питания. Данные о ценах на продукты питания позволяют исследователям, журналистам и гражданам **лучше понимать, как цены на продукты питания меняются в зависимости от географического положения и времени**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Отслеживайте динамику цен с течением времени';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Посмотрите на **эволюцию цен**: деструкционная инфляция, дешевая инфляция — мы можем отслеживать их вместе!';

  @override
  String get guide_open_prices_why_arg2_title => 'Сравните цены рядом с вами';

  @override
  String get guide_open_prices_why_arg2_text =>
      'По мере появления новых цен вы сможете найти **самые дешевые магазины рядом с вами**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Рассматривали ли вы возможность копирования цен с сайтов розничных продавцов?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'По юридическим и техническим причинам **мы не считаем сбор цен с сайтов розничных продавцов допустимым способом участия в проекте Open Prices**. Мы хотим быть уверены в точности и актуальности собираемых нами цен, а получение данных о ценах, собранных с сайтов розничных продавцов, не позволяет нам этого делать.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Возможность извлечения данных о ценах рассматривается в качестве опции в будущей версии Open Prices, но Open Prices будет осуществлять ее самостоятельно, чтобы мы могли получить подтверждение цены на основе HTML-страницы.';

  @override
  String get guide_open_prices_retailers_title =>
      'Я розничный торговец и хочу внести цены. Как я могу это сделать?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Вы можете вносить цены, используя наш API.\nЕсли вы хотите вносить цены в больших объемах, свяжитесь с нами по адресу prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Добро пожаловать на сайт Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Что такое Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts — это огромная открытая база данных для **любых продуктов со штрихкодом, которые не являются продуктами питания, косметикой или кормом для домашних животных**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'От **электроники** до **игрушек**, от **одежды** до **чистящих средств** — если у них есть штрихкод, его можно добавить. Цель этого проекта — создать «Интернет вещей» для повседневных предметов, сделав информацию о них общедоступной.';

  @override
  String get guide_open_products_facts_features_title =>
      'Особенности Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Цель Open Products Facts — предоставить потребителям возможность **продлить срок службы предметов**, предлагая циклические решения для обслуживания, **ремонта**, **переработки** их предметов или передачи их новому владельцу.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Углеродный след некоторых продуктов';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Воздействие CO2**, предоставляемое французским агентством по охране окружающей среды ADEME, предоставляет данные о **воздействии углерода** для многих категорий. Обязательно точно классифицируйте продукты.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Индекс ремонтопригодности для многих продуктов';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Мы будем отображать французский индекс ремонтопригодности, как только он станет доступен. Более того, **вы можете начать сбор переменных с помощью Folksonomy Engine**, чтобы мы могли пересчитать его самостоятельно в будущем, даже в тех странах, где он недоступен.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Найдите способы пожертвовать/перепродать свой продукт';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Мы предоставляем ссылки на **сторонние сервисы, ориентированные на циклическое использование**, которые помогут вам получить нужный вам товар, будучи бывшим в употреблении, чтобы бережнее относиться к планетарным ресурсам.\nОбратите внимание, что нам за это не платят, и система работает только в качестве примера для двух сайтов во Франции. Вы можете помочь расширить эту систему, опубликовав информацию о других сайтах в вики.';

  @override
  String get guide_open_products_facts_information_title =>
      'Какая информация полезна?';

  @override
  String get guide_open_products_facts_information_text =>
      'Для столь широкого спектра товаров **мы собираем гибкие данные**. Для этого мы создали **Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Двигатель Фолксономии';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine — это инструмент, который поможет вам дополнить товары релевантными свойствами. Это помогает улучшить поиск и найти нужную информацию, а также вычислить и отобразить интересную информацию в будущем.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Вы можете добавить любые ключи и значения, например: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Вы получите автоматическое предложение возможных свойств, и вы с радостью добавите и задокументируете новые свойства для ваших любимых видов продукции.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-ru.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Открытые предпочтения в еде';

  @override
  String get guide_coming_soon_button_title => 'Вскоре';

  @override
  String get guide_learn_more_subtitle => 'Нажмите, чтобы узнать больше';

  @override
  String get preview_badge => 'Предварительный просмотр';

  @override
  String get prices_feedback_form =>
      'Нажмите здесь, чтобы отправить нам свой отзыв об этой новой функции!';

  @override
  String get menu_button_list_actions => 'Выберите действие';

  @override
  String get error_loading_photo => 'Ошибка загрузки фото';

  @override
  String get photo_viewer_action_use_picture_as => 'Использовать как…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Используйте эту картинку как…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Используйте эту картинку как… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Подробности';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Подробности этой фотографии';

  @override
  String get photo_viewer_details_title => 'Подробности фотографии';

  @override
  String get photo_viewer_details_contributor_title => 'Участник';

  @override
  String get photo_viewer_details_size_title => 'Размер';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height пикселей';
  }

  @override
  String get photo_viewer_details_date_title => 'Дата';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Совместимый';

  @override
  String get user_lists_action_multi_select => 'Мульти-выбор';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Ваш рейтинг совместимости: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Основное фото';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Фото списка ингредиентов';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Пищевая ценность изображения';

  @override
  String get product_image_packaging_accessibility_label =>
      'Изображение упаковки';

  @override
  String get product_image_other_accessibility_label => 'Другое изображение';

  @override
  String get product_image_outdated_message =>
      'Эта фотография может быть устаревшей';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (это изображение может быть устаревшим)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (это изображение может быть заблокировано производителем)';
  }

  @override
  String get product_image_error => 'Не удалось загрузить изображение!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Невозможно загрузить $type (ошибка сети?)';
  }

  @override
  String get product_page_image_no_image_available => 'Нет\nизображения!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Для этого продукта нет изображения';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Изменить порядок или скрыть действия';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Редактировать действия';

  @override
  String get product_page_action_bar_item_move_up => 'Вверх';

  @override
  String get product_page_action_bar_item_move_down => 'Сдвинуть вниз';

  @override
  String get product_page_action_bar_item_enable => 'Включить действие';

  @override
  String get product_page_action_bar_item_disable => 'Отключить действие';

  @override
  String get product_page_pending_operations_banner_title =>
      'Загрузка ваших правок…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Данные, отображаемые на этой странице, **еще не отражают ваши изменения**.\nПожалуйста, подождите несколько секунд…';

  @override
  String get product_add_a_language => 'Добавить язык';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Штрихкод $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Удалить этот продукт из карусели';

  @override
  String get carousel_unsupported_header => 'Неподдерживаемый штрихкод!';

  @override
  String get carousel_unsupported_title => 'Упссс!';

  @override
  String get carousel_unsupported_text =>
      'Отсканированный штрихкод не поддерживается Open Food Facts!';

  @override
  String get carousel_error_header => 'Ошибка!';

  @override
  String get carousel_error_title => 'Это облом!';

  @override
  String get carousel_error_text_1 =>
      'Нам не удалось загрузить информацию по этому штрихкоду:';

  @override
  String get carousel_error_text_2 =>
      'Проверьте подключение к Интернету или нажмите эту кнопку:';

  @override
  String get carousel_error_button => 'Повтор';

  @override
  String get carousel_unknown_product_header => 'Неизвестный продукт';

  @override
  String get carousel_unknown_product_title =>
      'Поздравляем!\nВы нашли __редкий драгоценный камень!__';

  @override
  String get carousel_unknown_product_text =>
      'Наша совместная база данных содержит более **3 миллионов товаров**, но такого штрихкода не существует: ';

  @override
  String get carousel_unknown_product_button => 'Добавить этот продукт';

  @override
  String get carousel_loading_header => 'Загрузка информации...';

  @override
  String get carousel_loading_title =>
      'Вы только что отсканировали продукт со следующим штрихкодом:';

  @override
  String get carousel_loading_text =>
      'Мы ищем его в нашей базе данных, насчитывающей более **3 миллионов товаров!**';

  @override
  String get product_type_subtitle_food =>
      'Овощи, фрукты, замороженные продукты…';

  @override
  String get product_type_subtitle_beauty => 'Косметика, мыло, зубные пасты…';

  @override
  String get product_type_subtitle_pet_food => 'Корм для собак, кошек…';

  @override
  String get product_type_subtitle_product => 'Смартфоны, мебель…';

  @override
  String get photo_field_front => 'Фото продукта';

  @override
  String get photo_field_ingredients => 'Фото состава';

  @override
  String get photo_field_nutrition => 'Фото питания';

  @override
  String get photo_field_packaging => 'Фото инструкции по переработке';

  @override
  String get photo_already_exists => 'Это фото уже существует';

  @override
  String get photo_missing => 'Это фото отсутствует';

  @override
  String get date => 'Дата';

  @override
  String get photo_rotate_left => 'Поворот влево';

  @override
  String get photo_rotate_right => 'Повернуть вправо';

  @override
  String get photo_undo_action => 'Отменить предыдущее действие';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Карта мира $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Участники OpenStreetMap';

  @override
  String get not_applicable_short => 'Н/Д';

  @override
  String get knowledge_panel_warning_text => 'Nazwa zwyczajowa';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Почему этот показатель Nutri-Score отличается от показателя на упаковке?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Возможны два объяснения:\nСписок ингредиентов и/или пищевой ценности неактуален.\n\nМы предоставляем «Новый расчет» Nutri-Score (или V2). Проверьте, есть ли на упаковке баннер «Новый расчет».';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Проверить ингредиенты';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Проверьте факты о питании';

  @override
  String url_not_supported(String url) {
    return 'К сожалению, мы не можем открыть URL:\n$url';
  }

  @override
  String get product_list_export => 'Экспорт';

  @override
  String get product_list_import => 'Импорт';

  @override
  String get product_footer_action_barcode => 'Показать штрихкод';

  @override
  String get product_footer_action_barcode_short => 'Штрих-код';

  @override
  String get product_footer_action_open_website => 'Открыть сайт';

  @override
  String get product_footer_action_report => 'Пожаловаться';

  @override
  String get product_footer_action_contributor_guide => 'Помощь';

  @override
  String get product_footer_action_data_quality_tags => 'Качество данных';

  @override
  String get product_page_tab_for_me => 'Для меня';

  @override
  String get product_page_tab_website => 'Веб-сайт';

  @override
  String get product_page_tab_prices => 'Цены';

  @override
  String get prices_explanation_card_title => 'Почему цены?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** — это проект по сбору и обмену ценами на продукты по всему миру 🌍. Open Prices разработан и поддерживается Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Узнать больше';

  @override
  String get product_page_tab_folksonomy => 'Фолксономия';

  @override
  String get folksonomy_explanation_card_title =>
      'Что такое атрибуты фолксономии?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Атрибуты основаны на **ключ-значение**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Эти свойства создаются и сохраняются участниками для любого вида использования.';

  @override
  String get folksonomy_action_external_link_title => 'Открыть внешнюю ссылку';

  @override
  String get folksonomy_action_external_link_warning =>
      'Внешние ссылки могут быть небезопасны. Вы действительно хотите туда зайти?';

  @override
  String get prices_products_empty_title => 'Цена не указана';

  @override
  String get prices_products_empty_explanation =>
      'Будьте первым, кто внесет свой вклад!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Лучшие $pageSize продукты (всего: $total)';
  }

  @override
  String get app_review_title => 'Вам нравится это приложение?';

  @override
  String get app_review_low => 'Могло бы быть и лучше';

  @override
  String get app_review_medium => 'Неплохо';

  @override
  String get app_review_high => 'Я люблю его!';

  @override
  String get app_review_feedback_modal_title =>
      'Помогите нам улучшить наше приложение';

  @override
  String get app_review_feedback_modal_content =>
      'Если у вас есть несколько минут, не могли бы вы ответить на вопросы этой формы, чтобы **мы могли улучшить будущие обновления**:';

  @override
  String get app_review_feedback_modal_open_form => 'Ответьте на форму';

  @override
  String get app_review_feedback_modal_later => 'Позже';

  @override
  String get nutrition_facts_extract_new =>
      'НОВОЕ: Вы можете автоматически извлекать питательные вещества из изображения!';

  @override
  String get nutrition_facts_extract_button_text => 'Извлечь сейчас';

  @override
  String get nutrition_facts_extract_in_progress => 'Извлечение в процессе…';

  @override
  String get nutrition_facts_extract_successful => 'Извлечение успешно';

  @override
  String get nutrition_facts_extract_failed =>
      'Не удалось извлечь питательные вещества из изображения';

  @override
  String get prices_discount => 'Скидка';

  @override
  String get prices_stats_statistics => 'Статистика';

  @override
  String get prices_stats_title => 'Статистика цен';

  @override
  String get prices_stats_prices_section => 'Цены';

  @override
  String get prices_stats_products_section => 'Продукты';

  @override
  String get prices_stats_locations_section => 'Места';

  @override
  String get prices_stats_proofs_section => 'Доказательства';

  @override
  String get prices_stats_contributors_section => 'Участники';

  @override
  String get prices_stats_experiments_section => 'Эксперименты';

  @override
  String get prices_stats_misc_section => 'Прочее';

  @override
  String get prices_stats_total => 'Всего';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Сообщество';

  @override
  String get prices_stats_consumption => 'Потребление';

  @override
  String get prices_stats_with_price => 'С ценой';

  @override
  String get prices_stats_food => 'Еда';

  @override
  String get prices_stats_beauty => 'Красота';

  @override
  String get prices_stats_products => 'Продукты';

  @override
  String get prices_stats_pet_food => 'Корм';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Онлайн';

  @override
  String get prices_stats_countries => 'Страны';

  @override
  String get prices_stats_price_tag => 'Ценник';

  @override
  String get prices_stats_receipt => 'Чек';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Вызовы';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Валюты';

  @override
  String get prices_stats_years => 'Годы';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Веб-сайт';

  @override
  String get prices_stats_mobile_app => 'Мобильное приложение';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Прочее';

  @override
  String get prices_stats_last_updated => 'Последняя активность';

  @override
  String get prices_stats_error => 'Произошла ошибка при загрузке статистики.';

  @override
  String get product_edit_robotoff_question_answered =>
      'Ответ на вопрос получен!';

  @override
  String get product_edit_robotoff_proof => 'Доказательство';

  @override
  String get preferences_card_general => 'Основныe';

  @override
  String get preferences_prices_title => 'Цены';

  @override
  String get preferences_prices_subtitle =>
      'Управляйте своими ценовыми предпочтениями';

  @override
  String get preferences_card_project => 'Проект Open Food Facts';

  @override
  String get preferences_contribute_title => 'Способствовать';

  @override
  String get preferences_my_contributions_title => 'Мой вклад';

  @override
  String get preferences_my_stats_title => 'Моя статистика';

  @override
  String get preferences_contribute_subtitle =>
      'Переводите, улучшайте наши инструменты…';

  @override
  String get preferences_connect_title => 'Соединять';

  @override
  String get preferences_connect_subtitle =>
      'Свяжитесь с нами или подпишитесь на нас в социальных сетях';

  @override
  String get preferences_support_title => 'Сделать пожертвование';

  @override
  String get preferences_support_subtitle =>
      'Помогите нам информировать миллионы потребителей по всему миру';

  @override
  String get preferences_card_help => 'Помощь и поддержка';

  @override
  String get preferences_faq_title => 'Часто задаваемые вопросы';

  @override
  String get preferences_faq_subtitle => 'Получите ответы на ваши вопросы';

  @override
  String get logged_out => 'Вышел из системы';

  @override
  String get preferences_app_bar_message =>
      'Спасибо, что являетесь одним из наших участников!';

  @override
  String get preferences_app_bar_products_modified => 'Изменённые продукты';

  @override
  String get preferences_app_bar_prices_added => 'Цены добавлены';

  @override
  String get preferences_app_bar_see_all_stats => 'Посмотреть всю статистику';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Поиск $provider для \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Поиск по настройке (например, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Доступность: Показать эмодзи';

  @override
  String get preferences_accessibility_remove_colors =>
      'Доступность: Удалить цвета';

  @override
  String get preferences_app_settings_products => 'Продукты';

  @override
  String get preferences_card_about => 'О приложении';

  @override
  String get preferences_legal_information_title => 'Юридическая информация';

  @override
  String get preferences_legal_information_subtitle =>
      'Условия использования, политика конфиденциальности и многое другое';

  @override
  String get preferences_terms_of_use => 'Условия использования';

  @override
  String get preferences_legal_mentions => 'Правовые основания';

  @override
  String get preferences_legal_header =>
      'Open Food Facts — это база данных о продуктах питания, **созданная всеми для всех**.\nВы можете использовать ее для лучшего выбора продуктов питания, и поскольку это **открытые данные**, любой может **использовать ее повторно в любых целях**.';

  @override
  String get preferences_privacy_policy => 'Политика конфиденциальности';

  @override
  String get preferences_licenses => 'Лицензии';

  @override
  String get preferences_about_app_title => 'О приложении';

  @override
  String get preferences_about_app_subtitle =>
      'Техническая информация, информация для разработчиков и многое другое';

  @override
  String get preferences_card_information => 'Информация';

  @override
  String get preferences_version_number_title => 'Номер версии';

  @override
  String get preferences_scanner_title => 'Сканер';

  @override
  String get preferences_app_store => 'Магазин приложений';

  @override
  String get preferences_app_system_settings => 'Системные настройки';

  @override
  String get preferences_source_code => 'Доступ к исходному коду';

  @override
  String get preferences_source_code_subtitle =>
      'И начните оказывать влияние на миллионы людей.';

  @override
  String get preferences_add_prices => 'Добавить цены';

  @override
  String get preferences_complete_products => 'Расскажите всему миру';

  @override
  String get preferences_tips => 'Советы';

  @override
  String get tips_discover_nutriscore => 'Откройте для себя новый Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle => 'На сайте Open Food Facts';

  @override
  String get preferences_manage_account_title =>
      'Управлять моей учетной записью';

  @override
  String get preferences_manage_account_tooltip => 'Управляйте своим аккаунтом';

  @override
  String get preferences_change_password_title => 'Изменить мой пароль';

  @override
  String get preferences_danger_zone => 'Опасная зона';

  @override
  String get preferences_account_deletion_subtitle =>
      'Все ваши вклады будут потеряны.';

  @override
  String get preferences_contributions_title => 'Вклад';

  @override
  String get preferences_dev_mode_app_settings_title => 'Настройки приложения';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Очень экспериментальный способ сканирования продуктов в офлайн-режиме';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Обновить все продукты с сервера';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Пожалуйста, не делайте этого, если только это не является абсолютно необходимым.';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Демонстрационный режим';

  @override
  String get preferences_dev_mode_add_cards_title => 'Добавить карты в сканер';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Добавляет 3 образца продуктов в сканер';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'Хост Фолксономии';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Хост: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Эксперименты по доступности';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Выбор нескольких продуктов по ценам';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Панели знаний, упорядоченные пользователем';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Временный доступ к поиску местоположения';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Параллельное сравнение 2 или 3 продуктов';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Импорт списка продуктов';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Оценки и методологии';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Узнайте, как рассчитывается Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Откройте для себя основные изменения в методологии';

  @override
  String get preferences_faq_discover_project_title =>
      'Откройте для себя проект';

  @override
  String get preferences_faq_discover_off_title =>
      'Откройте для себя факты об открытых продуктах питания';

  @override
  String get preferences_faq_discover_obf_title =>
      'Откройте для себя Open Beauty Factsе';

  @override
  String get preferences_faq_discover_opff_title =>
      'Откройте для себя факты о кормах для домашних животных';

  @override
  String get preferences_faq_discover_op_title => 'Откройте Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Откройте для себя факты об открытых продуктах';

  @override
  String get preferences_faq_faq_title => 'FAQ — часто задаваемые вопросы';

  @override
  String get preferences_faq_off_ngo_title => 'НПО «Открытые факты о еде»';

  @override
  String get preferences_about_information_title => 'Информация';

  @override
  String get preferences_connect_community_updates_title =>
      'Получайте обновления сообщества';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Будьте в курсе новостей приложения и сообщества';

  @override
  String get preferences_connect_community_calendar_title =>
      'Подпишитесь на наш календарь сообщества';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Примите участие, посетив одно из наших виртуальных мероприятий';

  @override
  String get preferences_connect_blog_title => 'Блог Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Получайте последние новости, как только они происходят';

  @override
  String get preferences_connect_community_help_title =>
      'Получите помощь от сообщества';

  @override
  String get preferences_connect_improve_app_title =>
      'Помогите нам улучшить приложение';

  @override
  String get preferences_connect_debug_info_title =>
      'Отправьте нам отладочную информацию';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Отправьте нам электронное письмо с подробной информацией по отладке';

  @override
  String get preferences_connect_feedback_title =>
      'Отправьте нам отзыв о приложении';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Помогите сформировать будущее приложения';

  @override
  String get preferences_connect_survey_title => 'Пройдите опрос о приложении';

  @override
  String get preferences_connect_survey_subtitle =>
      'Помогите нам понять, что нам следует построить дальше';

  @override
  String get preferences_connect_professionals_title => 'Профессионалы';

  @override
  String get preferences_connect_pro_subtitle =>
      'Абсолютно бесплатно, обеспечивает точность данных для 500 приложений и миллионов пользователей. Самообслуживание, совместимость с PIM или электронными таблицами (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Свяжитесь с нами, чтобы начать';

  @override
  String get preferences_connect_press_title => 'Пресса';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Получите все необходимые материалы для вашего отчета';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Свяжитесь с нами для запросов прессы или чтобы сообщить нам о вашем отчете.';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Станьте активным волонтером';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Разработка, коммуникация, дизайн… любой вид волонтерства или экспертных знаний приветствуется!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Откройте для себя множество способов, которыми вы можете внести свой вклад';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Разработка мобильных приложений';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Узнайте, как внести свой вклад в разработку программного обеспечения';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Ежедневные нестабильные сборки, совершенно новые функции';

  @override
  String get preferences_contribute_local_community_title =>
      'Развивайте свое местное сообщество';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Помощь с программным обеспечением, содержанием, переводами анализа ингредиентов';

  @override
  String get preferences_contribute_share_subtitle =>
      'Мы подготовили небольшой шаблон, чтобы помочь вам :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Простые шаги для повышения прозрачности в сфере продовольствия в вашей стране';

  @override
  String get preferences_contribute_data_quality_title => 'Качество данных';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Присоединяйтесь к команде по качеству данных';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Присоединяйтесь к нашим усилиям, чтобы обеспечить полноту и точность базы данных.';

  @override
  String get preferences_contributions_products_added_title =>
      'Добавленные продукты';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Новые продукты, которые я добавил в Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Продукты, которые мне нужно заполнить';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Все неполные продукты';

  @override
  String get preferences_my_contributions_prices_title => 'Цены';

  @override
  String get preferences_my_contributions_my_prices_title => 'Мои цены';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Мои цены, мои доказательства…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Продукты, которые вы можете помочь завершить';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Помогите рассчитать Nutri-Score и Green-Score в вашей стране';

  @override
  String get preferences_prices_user_prices_subtitle => 'Цены, которые я внес';

  @override
  String get preferences_prices_proofs_subtitle => 'Ценники и чеки';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Сфотографируйте свои чеки и отсканируйте соответствующие штрихкоды.';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Фотографируйте цены в магазине';

  @override
  String get preferences_prices_newest_title => 'Новейшие цены';

  @override
  String get preferences_prices_newest_subtitle =>
      'Последние цены, добавленные сообществом Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Авторы с наибольшим количеством цен';

  @override
  String get preferences_prices_metrics_title => 'Метрики цены открытия';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Следите за развитием проекта';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Способы внесения вклада';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Подтверждайте цены, добавленные вами или другими пользователями, с помощью ИИ';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Быстро добавляйте множество чеков или фотографий полок из вашей фотопленки';

  @override
  String get preferences_prices_challenges_title => 'Ежемесячные задания';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Участвуйте в ежемесячных тематических квестах и собирайте цены.';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Восстановите данные о своей лояльности';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Узнайте, как запросить ваши данные';

  @override
  String get preferences_page_customize_app_title => 'Настройте приложение';

  @override
  String get preferences_page_contribute_project_title =>
      'Внести свой вклад в проект';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Простые способы помочь Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Методологии оценки, помощь и многое другое о проекте';

  @override
  String get product_edit_robotoff_positive_button => 'Принять предложение';

  @override
  String get product_edit_robotoff_negative_button => 'Отклонить предложение';

  @override
  String get product_edit_robotoff_show_proof => 'Показать доказательство';

  @override
  String get product_edit_robotoff_expand_proof => 'Расширить доказательство';

  @override
  String get product_page_tab_raw_data => 'Необработанные данные';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Страница $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Страница $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count из $total предметов';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count из $total предметов';
  }

  @override
  String item_count(int count) {
    return '$count предметов';
  }

  @override
  String item_count_string(String count) {
    return '$count предметов';
  }

  @override
  String get prices_no_result => 'Статистика цен не найдена.';

  @override
  String get prices_error_loading_more_items =>
      'Ошибка при загрузке дополнительных элементов';

  @override
  String get prices_proof_error =>
      'Аутентификация не удалась, невозможно получить доказательства';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count из $total доказательств';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count из $total участников';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count из $total локаций';
  }

  @override
  String prices_locations_count(int count) {
    return '$count локаций';
  }

  @override
  String get restart_to_apply_message =>
      'Пожалуйста, перезапустите приложение, чтобы изменения вступили в силу.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Графический интерфейс';

  @override
  String get preferences_app_settings_media_title => 'СМИ';

  @override
  String get preferences_about_app_development_title => 'Разработка';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Открытые лаборатории фактов о продуктах питания';

  @override
  String get preferences_root_account_title => 'Учётная запись';

  @override
  String get preferences_contribute_translate_header =>
      'Перенесите Open Food Facts на свой язык';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Зарегистрируйтесь в альфа-версии приложения';

  @override
  String get preferences_dev_mode_section_data => 'Вклады и данные о продуктах';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Не показывать Фолксономию';

  @override
  String get preferences_account_title => 'Учётная запись';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Добавлено $created';
  }

  @override
  String get location_map_details_title => 'Подробности местоположения';

  @override
  String get location_map_details_name => 'Название';

  @override
  String get location_map_details_street => 'Улица';

  @override
  String get location_map_details_city => 'Город';

  @override
  String get location_map_details_postcode => 'Почтовый индекс';

  @override
  String get location_map_details_country => 'Страна';

  @override
  String get location_map_details_coordinates => 'Координаты';

  @override
  String get location_map_details_osm_id => 'Идентификатор OSM';
}
