// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Norwegian Bokmål (`nb`).
class AppLocalizationsNb extends AppLocalizations {
  AppLocalizationsNb([String locale = 'nb']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Ja';

  @override
  String get add => 'Legg til';

  @override
  String get account_delete_message =>
      'Er du sikker på at du vil slette kontoen?\nHvis det er av en spesifikk grunn, kan du dele nedenfor';

  @override
  String get reason => 'Grunn';

  @override
  String get okay => 'Ok';

  @override
  String get validate => 'Godkjenn';

  @override
  String get create => 'Opprett';

  @override
  String get applyButtonText => 'Bruk';

  @override
  String get next_label => 'Neste';

  @override
  String get continue_label => 'Fortsette';

  @override
  String get exit_label => 'Avslutt';

  @override
  String get previous_label => 'Forrige';

  @override
  String get go_back_to_top => 'Gå tilbake til toppen';

  @override
  String get save => 'Lagre';

  @override
  String get save_confirmation => 'Er du sikker på at du vil lagre?';

  @override
  String get skip => 'Hopp over';

  @override
  String get cancel => 'Avbryt';

  @override
  String get ignore => 'Ignorer';

  @override
  String get close => 'Lukk';

  @override
  String get no => 'Nei';

  @override
  String get stop => 'Stopp';

  @override
  String get finish => 'Ferdig';

  @override
  String get calculate => 'Beregn';

  @override
  String get reset_food_prefs => 'Tilbakestill matpreferanser';

  @override
  String get error => 'Noe gikk galt';

  @override
  String get error_occurred => 'En feil oppstod';

  @override
  String get featureInProgress =>
      'Vi jobber fortsatt med denne funksjonen, følg med';

  @override
  String get label_web => 'Se på nettet';

  @override
  String get learnMore => 'Lær mer';

  @override
  String get unknown => 'Ukjent';

  @override
  String get match_very_good => 'Veldig bra match';

  @override
  String get match_good => 'Bra match';

  @override
  String get match_poor => 'Dårlig match';

  @override
  String get match_may_not => 'Matcher kanskje ikke';

  @override
  String get match_does_not => 'Matcher ikke';

  @override
  String get match_unknown => 'Ukjent match';

  @override
  String get match_short_very_good => 'Veldig bra match';

  @override
  String get match_short_good => 'Bra match';

  @override
  String get match_short_poor => 'Dårlig match';

  @override
  String get match_short_may_not => 'Matcher kanskje ikke';

  @override
  String get match_short_does_not => 'Matcher ikke';

  @override
  String get match_short_unknown => 'Ukjent match';

  @override
  String get licenses => 'Lisenser';

  @override
  String get looking_for => 'Leter etter';

  @override
  String get welcomeToOpenFoodFacts => 'Velkommen til Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts er en global ideell organisasjon som drives av lokalsamfunn.';

  @override
  String get productDataUtility =>
      'Se matdata som er relevant for dine preferanser.';

  @override
  String get healthCardUtility => 'Velg mat som er bra for deg.';

  @override
  String get ecoCardUtility => 'Velg mat som er bra for planeten.';

  @override
  String get server_error_open_new_issue =>
      'Ingen serverrespons! Du kan åpne et problem med følgende lenke.';

  @override
  String get sign_in_text =>
      'Logg inn på Open Food Facts-kontoen din for å lagre bidragene dine';

  @override
  String get incorrect_credentials => 'Feil brukernavn eller passord.';

  @override
  String get password_lost_incorrect_credentials =>
      'Denne e-postadressen eller brukernavnet eksisterer ikke. Vennligst sjekk legitimasjonen din.';

  @override
  String get password_lost_server_unavailable =>
      'Vi opplever for tiden nedgang på serverne våre, og vi beklager dette. Prøv igjen senere.';

  @override
  String get login => 'Logg inn';

  @override
  String get login_result_type_server_unreachable =>
      'Nettverket er ikke tilgjengelig';

  @override
  String get login_result_type_server_issue =>
      'Problem på serveren. Vennligst prøv igjen senere.';

  @override
  String get login_page_username_or_email =>
      'Vennligst skriv inn brukernavn eller e-post';

  @override
  String get login_page_password_error_empty => 'Vennligst angi passord';

  @override
  String get create_account => 'Opprett konto';

  @override
  String get sign_in => 'Logg på';

  @override
  String get sign_in_mandatory => 'Denne funksjonen krever innlogging.';

  @override
  String get help_improve_country =>
      'Hjelp med å forbedre Open Food Facts i landet ditt';

  @override
  String get sign_out => 'Logg ut';

  @override
  String get sign_out_confirmation => 'Er du sikker på at du vil logge ut?';

  @override
  String get password => 'Passord';

  @override
  String get forgot_password => 'Glemt passordet';

  @override
  String get forgot_password_question => 'Glemt passord?';

  @override
  String get view_profile => 'Vis profil';

  @override
  String get reset_password => 'Tilbakestill passord';

  @override
  String get reset_password_explanation_text =>
      'I tilfelle du har glemt passordet ditt, skriv inn brukernavnet eller e-postadressen din for å motta instruksjoner for tilbakestilling av passordet. Husk å sjekke Spam-mappen om du ikke mottar e-posten.';

  @override
  String get username_or_email => 'Brukernavn eller e-post';

  @override
  String get reset_password_done =>
      'En e-post med en lenke for å tilbakestille passordet ditt er sendt til e-posten knyttet til kontoen din. Sjekk også spam-mappen din';

  @override
  String get send_reset_password_mail => 'Bytt passord';

  @override
  String get enter_some_text => 'Skriv inn tekst';

  @override
  String get sign_up_page_title => 'Registrer deg';

  @override
  String get sign_up_page_action_button => 'Registrer deg';

  @override
  String get sign_up_page_action_doing_it => 'Registrerer…';

  @override
  String get sign_up_page_action_ok =>
      'Gratulerer! Kontoen din er nå opprettet.';

  @override
  String get sign_up_page_display_name_hint => 'Navn';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Vennligst skriv inn navnet du vil andre skal se deg som';

  @override
  String get sign_up_page_email_hint => 'E-post';

  @override
  String get sign_up_page_email_error_empty => 'E-post er påkrevd';

  @override
  String get sign_up_page_email_error_invalid => 'Ugyldig e-postadresse';

  @override
  String get sign_up_page_username_hint => 'Brukernavn: Synlig offentlig';

  @override
  String get sign_up_page_username_error_empty => 'Skriv inn et brukernavn';

  @override
  String get sign_up_page_username_error_invalid =>
      'Vennligst skriv inn et gyldig brukernavn';

  @override
  String get sign_up_page_username_description =>
      'Brukernavnet kan ikke inneholde mellomrom, store bokstaver eller spesialtegn.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Brukernavnet kan ikke være på over $value tegn totalt';
  }

  @override
  String get sign_up_page_password_hint => 'Passord';

  @override
  String get sign_up_page_password_error_empty => 'Vennligst angi passord';

  @override
  String get sign_up_page_password_error_invalid =>
      'Vennligst skriv inn et gyldig passord (minst 6 tegn)';

  @override
  String get sign_up_page_confirm_password_hint => 'Bekreft passord';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Vennligst bekreft passordet ditt';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Passordene er ikke like';

  @override
  String get sign_up_page_agree_text => 'Jeg godtar Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'vilkår for bruk og bidrag';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Når du oppretter en konto, er det obligatorisk å godta bruksvilkårene, men anonyme bidrag kan fortsatt gis gjennom appen.';

  @override
  String get sign_up_page_producer_checkbox => 'Jeg er en matprodusent';

  @override
  String get sign_up_page_producer_hint => 'Produsent/merke';

  @override
  String get sign_up_page_producer_error_empty =>
      'Skriv inn navnet på produsenten eller et merkenavn';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Jeg vil gjerne abonnere på nyhetsbrevet fra Open Food Facts (du kan når som helst melde deg av)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Brukernavnet er allerede i bruk, velg et annet brukernavn.';

  @override
  String get sign_up_page_email_already_exists =>
      'er allerede i bruk, logg inn på kontoen eller prøv med en annen e-post.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Vennligst skriv inn en gyldig epostadresse.';

  @override
  String get sign_up_page_server_busy =>
      'Vi beklager på det sterkeste, men vi har hatt noen tekniske problemer med å opprette kontoen din. Prøv igjen senere.';

  @override
  String get settingsTitle => 'Innstillinger';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Mørkt';

  @override
  String get darkmode_light => 'Lyst';

  @override
  String get darkmode_system_default => 'Systemstandard';

  @override
  String get thanks_for_contributing => 'Takk for at du bidrar!';

  @override
  String get contributors_label => 'De bygger appen';

  @override
  String get contributors_dialog_title => 'Bidragsytere';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Bidragsyter: $name';
  }

  @override
  String get contributors_description =>
      'En liste over alle bidragsytere til denne appen';

  @override
  String get support => 'Støtte';

  @override
  String get support_join_slack => 'Be om hjelp i vår Slack-kanal';

  @override
  String get support_via_forum => 'Be om hjelp på forumet vårt';

  @override
  String get support_via_email => 'Send oss en e-post';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Sende app-logger til support?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Ønsker du å inkludere applikasjonslogger som vedlegg til e-posten din?';

  @override
  String get termsOfUse => 'Bruksvilkår';

  @override
  String get legalNotices => 'Juridisk informasjon';

  @override
  String get privacy_policy => 'Personvernerklæring';

  @override
  String get about_this_app => 'Om denne appen';

  @override
  String get contribute => 'Bidra';

  @override
  String get contribute_sw_development => 'Programvareutvikling';

  @override
  String get contribute_develop_text =>
      'Koden til hvert Open Food Facts-produkt er tilgjengelig på GitHub. Du er velkommen til å gjenbruke koden (det er åpen kildekode) og hjelpe oss med å forbedre den, for alle, og for planeten.';

  @override
  String get contribute_develop_text_2 =>
      'Du kan bli med i Slack-chatterommet til Open Food Facts, som er den foretrukne måten å stille spørsmål på.';

  @override
  String get contribute_develop_dev_mode_title => 'DEV-modus?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktiver DEV-modus';

  @override
  String get contribute_donate_title => 'Doner';

  @override
  String get contribute_donate_header => 'Donér til Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Vær oppmerksom på at med den interne alfaversjonen er fullstendig tap av data mulig, og appen kan bli ubrukelig når som helst!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Produkter som skal fullføres';

  @override
  String get contribute_improve_header => 'Forbedre';

  @override
  String get contribute_improve_text =>
      'Databasen er kjernen i prosjektet. Den er enkel og hjelper raskt. Du kan laste ned mobilappen på telefonen din, og begynne å legge til eller forbedre produkter.\n\nOpen Food Facts sin nettside tilbyr også mange måter å bidra på: ';

  @override
  String get contribute_translate_header => 'Oversett';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Begynn å oversette';

  @override
  String get contribute_translate_text =>
      'Open Food Facts er et globalt prosjekt som inneholder produkter fra mer enn 160 land. Open Food Facts er oversatt til en mengde språk, med innhold som er i stadig utvikling.';

  @override
  String get contribute_translate_text_2 =>
      'Oversettelser er en av hovedoppgavene til prosjektet';

  @override
  String get contribute_join_skill_pool =>
      'Bidra med ferdighetene dine til Open Food Facts. Bli med i ferdighetspuljen!';

  @override
  String get contribute_share_header => 'Del Open Food Facts med vennene dine';

  @override
  String get contribute_share_content =>
      'Jeg ville fortelle deg om appen jeg har brukt, Open Food Facts, som lar deg få informasjon om helse- og miljøpåvirkningen av maten din på en personlig måte. Den fungerer ved å skanne strekkodene på emballasjen. Den er gratis, krever ikke registrering, og du kan til og med bidra til å øke antallet produkter som dekrypteres. Her er lenken for å laste den ned til telefonen din: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Bidra til priser ved å be om GDPR-eksport av lojalitetskortdataene dine';

  @override
  String get tap_to_answer => 'Trykk her for å svare på spørsmål';

  @override
  String get tap_to_answer_hint =>
      'Trykk her for å svare på spørsmål om dette produktet';

  @override
  String get robotoff_questions_loading_hint =>
      'Vent mens spørsmål om dette produktet lastes inn';

  @override
  String get saving_answer => 'Lagrer svaret ditt';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Logg inn på Open Food Facts-kontoen din for å få kreditt for bidragene dine';

  @override
  String get question_yes_button_accessibility_value => 'Svar med ja';

  @override
  String get question_no_button_accessibility_value => 'Svar med nei';

  @override
  String get question_skip_button_accessibility_value =>
      'Hopp over dette spørsmålet';

  @override
  String get tap_to_edit_search => 'Trykk for å redigere søket';

  @override
  String get myPreferences => 'Mine innstillinger';

  @override
  String get account_create_message =>
      'Oprett kontoen din og bli med Open Food Facts-fellesskapet for å hjelpe med å utvide matkunnskapen verden over!';

  @override
  String get join_us => 'Bli med oss';

  @override
  String get myPreferences_profile_title => 'Din profil';

  @override
  String get myPreferences_profile_subtitle =>
      'Administrer din Open Food Facts-konto.';

  @override
  String get myPreferences_settings_title => 'Appinnstillinger';

  @override
  String get myPreferences_settings_subtitle => 'Mørk modus, Språk…';

  @override
  String get myPreferences_food_title => 'Matpreferanser';

  @override
  String get myPreferences_food_subtitle =>
      'Velg den informasjonen om mat som er viktigst for deg.';

  @override
  String get myPreferences_food_comment =>
      'Velg hvilken informasjon om mat som er viktigst for deg, for å rangere mat i henhold til dine preferanser, se informasjonen du bryr deg om først, og få et kompatibilitetssammendrag. Disse matpreferansene forblir på enheten din, og er ikke knyttet til din Open Food Facts-bidragsyterkonto hvis du har en.';

  @override
  String get confirmResetPreferences => 'Tilbakestill matpreferansene dine?';

  @override
  String get myPersonalizedRanking => 'Min personlige rangering';

  @override
  String get ranking_tab_all => 'Alle';

  @override
  String get ranking_subtitle_match_yes => 'En flott match for deg';

  @override
  String get ranking_subtitle_match_no => 'Veldig dårlig match';

  @override
  String get ranking_subtitle_match_maybe => 'Ukjent match';

  @override
  String get refresh_with_new_preferences =>
      'Oppdater listen med de nye innstillingene dine';

  @override
  String get reloaded_with_new_preferences =>
      'Lastet inn på nytt med dine nye preferanser';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Skann';

  @override
  String get history_navbar_label => 'Historikk';

  @override
  String get list_navbar_label => 'Lister';

  @override
  String get category => 'Filtrer etter kategori';

  @override
  String get category_all => 'Alle';

  @override
  String get category_search => '(kategorisøk)';

  @override
  String get filter => 'Filter';

  @override
  String get scan => 'Produkter fra Skann-skjermen';

  @override
  String get scan_history => 'Skannehistorikk';

  @override
  String get search => 'Søk';

  @override
  String get search_product_help =>
      'Søk etter et produkt,\net merke eller en strekkode';

  @override
  String get search_filter => 'Søk i filter';

  @override
  String get search_history => 'Søk historikk';

  @override
  String get search_store => 'Søk etter en butikk';

  @override
  String get search_store_help => 'Tips: legg til byen eller landet';

  @override
  String get tap_for_more => 'Trykk for å se mer informasjon…';

  @override
  String get product => 'Produkt';

  @override
  String get unknownBrand => 'Ukjent merke';

  @override
  String get unknownQuantity => 'Ukjent antall';

  @override
  String get unknownProductName => 'Ukjent produktnavn';

  @override
  String get label_refresh => 'Oppdater';

  @override
  String get label_reload => 'Last inn på nytt';

  @override
  String get image => 'Bilde';

  @override
  String get front_photo => 'Forsidebilde';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (dette bildet kan være utdatert)';
  }

  @override
  String get outdated_image_short_label => 'kan være utdatert';

  @override
  String get ingredients => 'Ingredienser';

  @override
  String get ingredients_editing_instructions =>
      'Behold den opprinnelige rekkefølgen. Angi prosentandelen når den er spesifisert. Skill med komma eller bindestrek, og bruk parenteser for ingrediensene til en ingrediens.';

  @override
  String get ingredients_editing_error => 'Kunne ikke lagre ingrediensene.';

  @override
  String get ingredients_editing_image_error =>
      'Klarte ikke å hente et nytt ingrediensbilde.';

  @override
  String get ingredients_editing_title => 'Rediger ingredienser';

  @override
  String get ingredients_photo => 'Ingredienser bilde';

  @override
  String get packaging_editing_instructions =>
      'List opp alle emballasjedeler atskilt med komma eller linjeskift, med mengde (f.eks. 1 eller 6), type (f.eks. flaske, eske, boks), materiale (f.eks. plast, metall, aluminium) og hvis tilgjengelig størrelse (f.eks. 33 cl) og resirkuleringsinstruksjoner.\nEksempel: 1 glassflaske til resirkulering, 1 plastkork til kasting';

  @override
  String get packaging_editing_error => 'Klarte ikke å lagre emballasjen.';

  @override
  String get packaging_editing_image_error =>
      'Klarte ikke å hente et nytt emballasjebilde.';

  @override
  String get packaging_editing_title => 'Rediger emballasje';

  @override
  String get nutrition => 'Ernæring';

  @override
  String get nutrition_facts_photo => 'Næringsinnholdsinformasjonsbilde';

  @override
  String get nutrition_facts_editing_title => 'Rediger næringsinnhold';

  @override
  String get packaging_information => 'Instrukser for resirkulering';

  @override
  String get packaging_information_photo =>
      'Instruksjoner for resirkulering, bilde';

  @override
  String get missing_product => 'Du har funnet et nytt produkt!';

  @override
  String get add_product_take_photos =>
      'Ta bilder av emballasjen for å legge til dette produktet i Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Ta noen bilder først. Du kan alltids fullføre produktet senere.';

  @override
  String get add_product_information_button_label =>
      'Legg til produktinformasjon';

  @override
  String get new_product => 'Nytt produkt';

  @override
  String get new_product_found_title => 'Nytt produkt funnet!';

  @override
  String get new_product_found_text =>
      'Vår samarbeidsdatabase inneholder mer enn **3 millioner produkter**, men denne strekkoden finnes ikke: ';

  @override
  String get new_product_found_button => 'Legg til dette produktet';

  @override
  String get new_product_leave_title => 'Forlate denne siden?';

  @override
  String get new_product_leave_message =>
      'Det ser ut som du ikke har skrevet inn noe. Vil du virkelig forlate denne siden?';

  @override
  String get new_product_dialog_description =>
      'Vennligst ta bilder av emballasjen for å legge dette produktet til i vår felles database.';

  @override
  String get new_product_dialog_illustration_description =>
      'En illustrasjon med ukjent Nutri-Score og Green Score';

  @override
  String get front_packaging_photo_button_label =>
      'Foto av forsiden av emballasjen';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Bekreft opplasting av bilde av frontemballasjen';

  @override
  String get confirm_button_label => 'Bekreft';

  @override
  String get send_image_button_label => 'Send bilde';

  @override
  String get crop_page_action_saving => 'Lagrer bildet…';

  @override
  String get crop_page_action_cropping => 'Beskjærer bildet…';

  @override
  String get crop_page_action_local => 'Lagrer en lokal versjon…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oisann… det er noe feil med bildet ditt!';

  @override
  String get crop_page_action_local_failed_message =>
      'Vi klarer ikke å behandle bildet lokalt før vi sender det til serveren vår. Vennligst prøv igjen senere eller kontakt oss om problemet vedvarer.';

  @override
  String get crop_page_action_retake => 'Ta et bilde på nytt';

  @override
  String get crop_page_too_small_image_title => 'Bildet er for lite!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Minimumsstørrelsen i piksler for bildeopplastning er $expectedMinWidth x$expectedMinHeight. Bildet er nå ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Forbereder et kall til serveren…';

  @override
  String get front_packaging_photo_title => 'Bilde av framsiden på emballasjen';

  @override
  String get ingredients_photo_title => 'Bilde av ingredienser';

  @override
  String get nutritional_facts_photo_title => 'Bilde av ernæringsfakta';

  @override
  String get recycling_photo_title => 'Instruksjoner for resirkulering foto';

  @override
  String get take_photo_title => 'Ta et bilde';

  @override
  String get take_more_photo_title => 'Ta flere bilder';

  @override
  String get front_photo_uploaded => 'Framsidebilde lastet opp';

  @override
  String get ingredients_photo_button_label => 'Ingredienser bilde';

  @override
  String get ingredients_photo_uploaded => 'Bilde av ingredienser lastet opp';

  @override
  String get nutrition_cache_loading_error =>
      'Kan ikke laste inn næringsstoffer fra hurtigbufferen';

  @override
  String get nutritional_facts_photo_button_label =>
      'Næringsinnholdsinformasjonsbilde';

  @override
  String get nutritional_facts_input_button_label => 'Fyll inn næringsinnhold';

  @override
  String get nutritional_facts_added => 'Ernæringsfakta lagt til';

  @override
  String get categories_added => 'Kategorier lagt til';

  @override
  String get new_product_title_nutriscore => 'Compute the Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Hjelp oss ved å fylle ut minst én kategori og næringsverdier';

  @override
  String get new_product_title_environmental_score =>
      'Beregn den grønne poengsummen';

  @override
  String get new_product_subtitle_environmental_score =>
      'Få det ved å fylle ut minst én kategori';

  @override
  String get new_product_additional_environmental_score =>
      'Gjør beregningen av Green Score mer presis med opprinnelse, emballasje og mer';

  @override
  String get new_product_title_nova => 'Beregn matforedlingsnivået (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Få det ved å fylle ut matkategorien og ingrediensene';

  @override
  String get new_product_desc_nova_unknown => 'Matbearbeidingsnivå ukjent';

  @override
  String get new_product_title_pictures => 'Nytt produkt';

  @override
  String get new_product_title_pictures_details =>
      'Ta de følgende bildene, så kan Open Food Facts-motoren ordne resten!';

  @override
  String get new_product_title_misc => 'Og noen grunnleggende data…';

  @override
  String new_product_done_msg(String username) {
    return 'Takk for bidraget ditt \"$username\"!';
  }

  @override
  String get new_product_done_msg_no_user => 'Takk for bidraget ditt!';

  @override
  String get new_product_done_button_label => 'Oppdag det ferdige produktet';

  @override
  String get hey_incomplete_product_message =>
      'Trykk for å svare på 3 spørsmål NÅ for å beregne Nutri-Score, Green Score og Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Trykk nå for å svare på to spørsmål som kan hjelpe deg med å analysere dette produktet!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Trykk nå for å svare på tre spørsmål som kan hjelpe deg med å analysere dette dyrefôrproduktet!';

  @override
  String get hey_incomplete_product_message_product =>
      'Trykk nå for å fullføre dette produktet!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Bilde av ernæringsfakta lastet opp';

  @override
  String get recycling_photo_button_label =>
      'Bilde av resirkuleringsinformasjon';

  @override
  String get recycling_photo_uploaded =>
      'Bilde av resirkuleringsinformasjon lastet opp';

  @override
  String get take_more_photo_button_label => 'Ta flere bilder';

  @override
  String get other_photo_uploaded => 'Diverse bilder lastet opp';

  @override
  String get retake_photo_button_label => 'Ta på nytt';

  @override
  String get selecting_photo => 'Velg bilde';

  @override
  String get uploading_image => 'Laster opp bilde til serveren';

  @override
  String get uploading_image_type_front =>
      'Laster opp framsidebilde til Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Laster opp bilde av ingredienser til Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Laster opp bilde av ernæringsfakta til Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Laster opp bilde av emballasjeinformasjon til Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Laster opp et annet bilde til Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Laster opp bilde til Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Legg til manglende ingredienser';

  @override
  String get score_add_missing_packaging_image =>
      'Legg til manglende emballasjebilde';

  @override
  String get score_add_missing_nutrition_facts =>
      'Legg til manglende næringsinnhold';

  @override
  String get score_add_missing_product_traces =>
      'Legg til manglende produktspor';

  @override
  String get score_add_missing_product_category => 'Velg en kategori';

  @override
  String get score_add_missing_precise_product_category =>
      'Velg en mer nøyaktig kategori';

  @override
  String get score_add_missing_product_countries =>
      'Legg til manglende produktland';

  @override
  String get score_add_missing_product_emb =>
      'Legg til manglende sporbarhetskoder for produkter';

  @override
  String get score_add_missing_product_labels =>
      'Legg til manglende produktetiketter';

  @override
  String get score_add_missing_product_origins =>
      'Legg til manglende produktopprinnelser';

  @override
  String get score_add_missing_product_stores =>
      'Legg til manglende produktbutikker';

  @override
  String get score_add_missing_product_brands =>
      'Legg til manglende produktmerker';

  @override
  String get score_update_nutrition_facts => 'Oppdater næringsinnhold';

  @override
  String get nutrition_page_title => 'Ernæringsinnhold';

  @override
  String get nutrition_page_nutritional_info_title => 'Næringsinnhold';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Verdier spesifisert på produktet:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Ja';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Nei';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Åpne bildet';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'God praksis: Næringsinnhold';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Noen ganger er næringsinnholdet **ikke spesifisert på emballasjen** eller på et dokument som følger med produktet. I dette tilfellet, og bare i dette tilfellet, kan du sette verdien til **NEI**.';

  @override
  String get nutrition_page_serving_type_label => 'Næringsinnhold:';

  @override
  String get nutrition_page_per_100g => 'per 100 g';

  @override
  String get nutrition_page_per_100g_100ml => 'per 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'per porsjon';

  @override
  String get nutrition_page_add_nutrient => 'Legg til et næringsstoff';

  @override
  String get nutrition_page_serving_size => 'Porsjonstørrelse';

  @override
  String get nutrition_page_serving_size_hint =>
      'Skriv inn en porsjonsstørrelse (f.eks. 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'God praksis: Serveringsstørrelse';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Denne verdien bidrar til å **lage en proporsjonal beregning av hvert næringsstoff per porsjonsstørrelse**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Tillatte enheter** er: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公卨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** eller **60 G** (foretrekk den første)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** eller **1 l**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Ugyldig enhet';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Ugyldige enheter';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **godteri** og 2 **kjeks**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Manglende enhet';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Ugyldig nummer';

  @override
  String get nutrition_page_update_running =>
      'Oppdaterer produktet på serveren…';

  @override
  String get nutrition_page_update_done => 'Produkt oppdatert!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Bruk produktmengden som porsjonsstørrelse';

  @override
  String get nutrition_page_photo_error => 'Kan ikke laste inn bildet';

  @override
  String get more_photos => 'Flere interessante bilder';

  @override
  String get view_more_photo_button =>
      'Se alle eksisterende bilder for dette produktet';

  @override
  String get no_product_found => 'Ingen produkt funnet';

  @override
  String get no_location_found => 'Ingen plassering funnet';

  @override
  String get not_found => 'ikke funnet:';

  @override
  String get refreshing_product => 'Forfriskende produkt';

  @override
  String get product_refreshed => 'Produktet er oppdatert';

  @override
  String product_image_accessibility_label(String date) {
    return 'Bilde tatt $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Bildet er tatt $date. Dette bildet kan være utdatert';
  }

  @override
  String get product_image_outdated => 'Dette bildet kan være utdatert';

  @override
  String get product_image_outdated_explanations_title =>
      'Dette bildet kan være utdatert';

  @override
  String get product_image_outdated_explanations_content =>
      'Dette bildet ble tatt for over et år siden.\n**Sjekk at det fortsatt er oppdatert**.\n\nDette er **bare en advarsel**. Hvis innholdet fortsatt er det samme, kan du ignorere denne meldingen.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Erstatt bilde ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Legg til et bilde ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Ta et bilde';

  @override
  String get product_image_action_from_gallery => 'Velg fra telefonens galleri';

  @override
  String get product_image_action_choose_existing_photo =>
      'Velg fra produktbildene';

  @override
  String get product_image_details_label => 'Informasjon om bildet';

  @override
  String get product_image_details_from_producer => 'Fra produsenten';

  @override
  String get product_image_details_contributor => 'Bidrager';

  @override
  String get product_image_details_contributor_producer =>
      'Bidragsyter (produsent)';

  @override
  String get product_image_details_date => 'Dato';

  @override
  String get product_image_details_date_unknown => 'Ukjent';

  @override
  String get homepage_main_card_logo_description =>
      'Velkommen til Åpne matfakta';

  @override
  String get homepage_main_card_subheading =>
      '**Skann** en strekkode eller\n**søk** etter et produkt';

  @override
  String get homepage_main_card_search_field_hint => 'Søk etter et produkt';

  @override
  String get homepage_main_card_search_field_tooltip => 'Start søk';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Siste nytt: $news_title';
  }

  @override
  String get tagline_app_review => 'Liker du appen?';

  @override
  String get tagline_app_review_button_positive => 'Jeg elsker det! 😍';

  @override
  String get tagline_app_review_button_negative => 'Ikke egentlig…';

  @override
  String get tagline_app_review_button_later => 'Spør meg senere';

  @override
  String get tagline_feed_news_button => 'Lær mer';

  @override
  String get app_review_negative_modal_title => 'Liker du ikke appen vår?';

  @override
  String get app_review_negative_modal_text =>
      'Kan du bruke noen sekunder på å fortelle oss hvorfor?';

  @override
  String get app_review_negative_modal_positive_button => 'Ja, absolutt!';

  @override
  String get app_review_negative_modal_negative_button => 'Nei';

  @override
  String get could_not_refresh => 'Kunne ikke oppdatere produktet';

  @override
  String get product_internet_error_modal_title => 'Det har oppstått en feil!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Vi kan ikke hente informasjon om dette produktet på grunn av en nettverksfeil. Sjekk internettforbindelsen din og prøv på nytt.\n\nIntern feil:\n$error';
  }

  @override
  String get product_tags_title => 'Produktegenskaper';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Ingen egenskaper';

  @override
  String get product_tags_explanation =>
      'Ved å legge til egenskaper (nøkkel/verdi) til et produkt hjelper du deg med å berike det.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Legg til egenskaper';

  @override
  String get add_edit_tags => 'Legg til eller rediger egenskaper';

  @override
  String get edit_tag => 'Rediger egenskap';

  @override
  String get remove_tag => 'Fjern egenskap';

  @override
  String get tag_key => 'Eiendom';

  @override
  String get tag_keys => 'Egenskaper';

  @override
  String get tag_key_uneditable => 'Egenskap (kan ikke redigeres)';

  @override
  String get tag_key_input_hint => 'Skriv inn en egenskap';

  @override
  String get tag_value => 'Verdi';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Skriv inn en verdi';

  @override
  String get tag_key_item => 'Eiendom:';

  @override
  String get tag_value_item => 'Verdi:';

  @override
  String get tag_key_explanations =>
      'En nøkkel må være liten og uten mellomrom.';

  @override
  String tag_key_already_exists(String property) {
    return 'En tagg med en egenskap $property finnes allerede!';
  }

  @override
  String get product_internet_error =>
      'Umulig å hente informasjon om dette produktet på grunn av en nettverksfeil.';

  @override
  String get cached_results_from => 'Vis resultater fra:';

  @override
  String get product_search_same_category => 'Finn alternativer';

  @override
  String get product_search_same_category_short => 'Sammenlign';

  @override
  String get product_search_same_category_error =>
      'Denne funksjonen kan bare brukes for produkter med en kategori.\n\nVennligst rediger produktet for å legge til en kategori.';

  @override
  String get product_improvement_add_category =>
      'Legg til en kategori for å beregne Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Legg til næringsinnhold for å beregne Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Legg til næringsinnhold og en kategori for å beregne Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Næringspoengsummen for dette produktet kan ikke beregnes, noe som for eksempel kan skyldes en ikke-standard kategori. Hvis dette anses som en feil, vennligst kontakt oss.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Ernæringsbildet er utdatert: vennligst oppdater det.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Den grønne poengsummen tar hensyn til ingrediensenes opprinnelse. Vennligst ta et bilde av ingredienslisten og/eller eventuelle geografiske påstander, eller rediger produktet, slik at de kan tas i betraktning.';

  @override
  String get country_chooser_label => 'Velg et land';

  @override
  String get currency_chooser_label => 'Velg en valuta';

  @override
  String get country_change_message => 'Du har nettopp byttet land.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Vil du endre valutaen fra $previousCurrency til $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Vennligst velg et land:';

  @override
  String get country_chooser_label_from_settings => 'Landet ditt';

  @override
  String get country_selection_explanation =>
      'Noen miljøfunksjoner er stedsspesifikke';

  @override
  String get product_removed_comparison =>
      'Produktet er fjernet fra sammenligningen';

  @override
  String get native_app_settings => 'Innebygde appinnstillinger';

  @override
  String get native_app_description =>
      'Åpne systeminnstillinger for Open Food Facts';

  @override
  String get product_removed_history => 'Produktet er fjernet fra historikken';

  @override
  String get product_removed_list => 'Produktet er fjernet fra listen';

  @override
  String get product_could_not_remove => 'Kunne ikke fjerne produktet';

  @override
  String get no_prodcut_in_list => 'Det finnes ingen produkter i denne listen';

  @override
  String get no_product_in_section =>
      'Det finnes ingen produkter i denne seksjonen';

  @override
  String get recently_seen_products => 'Alle viste produkter';

  @override
  String get clear => 'Tøm';

  @override
  String get clear_long => 'Tøm listen';

  @override
  String get really_clear => 'Er du sikker på at du vil slette denne listen?';

  @override
  String pct_match(Object percent) {
    return '$percent% match';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dager siden',
      one: 'en dag siden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count timer siden',
      one: 'en time siden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minutter siden',
      one: 'ett minutt siden',
      zero: 'mindre enn ett minutt siden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count måneder siden',
      one: 'en måned siden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count uker siden',
      one: 'en uke siden',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Sammenlign $count produkter',
      one: 'Sammenlign ett produkt',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count valgte produkter',
      one: 'Ett valgt produkt',
      zero: 'Ingen valgte produkter',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Sammenlign utvalgte produkter';

  @override
  String get delete_products_mode => 'Slett valgte produkter';

  @override
  String get select_all_products_mode => 'Velg alle produkter';

  @override
  String get select_none_products_mode => 'Velg ingen';

  @override
  String get compare_products_appbar_title => 'Sammenlign produkter';

  @override
  String get compare_products_appbar_subtitle => 'Velg minst to produkter';

  @override
  String get retry_button_label => 'Prøv på nytt';

  @override
  String get connect_with_us => 'Kontakt oss';

  @override
  String get tiktok => 'Følg oss på TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Følg oss på Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Følg oss på X (tidligere Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Følg oss på Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Følg oss på BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blogg';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => 'Oppdag';

  @override
  String get how_to_contribute => 'Hvordan bidra';

  @override
  String get hint_knowledge_panel_message =>
      'Du kan trykke på hvilken som helst del av kortet for å få mer informasjon om hva du ser. Prøv det nå!';

  @override
  String get permissions_page_title => 'Kameratilgang';

  @override
  String get permissions_page_body1 =>
      'For å skanne strekkoder med telefonkameraet ditt, vennligst gi oss tilgang.';

  @override
  String get permissions_page_body2 =>
      'Hvis du ombestemmer deg, kan du skru av eller på denne invstillingen senere.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Release: $release)\nModell: $model\nProdukt: $product\nEnhet: $device\nMerke: $brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModell: $model\nLokalisert modell: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nAppversjon:$appVersion\nApp-build-nummer:$appBuildNumber\nApp-pakke-nummer:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Godkjenn';

  @override
  String get refuse_button_label => 'Avslå';

  @override
  String get ask_me_later_button_label => 'Senere';

  @override
  String get are_you_sure => 'Er du sikker?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Gå videre på $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Velkommen!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Appen som hjelper deg med å velge mat som er bra for **deg** og **planeten**!';

  @override
  String get onboarding_continue_button => 'Fortsette';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Laster inn ditt første eksempelprodukt';

  @override
  String get onboarding_welcome_warning =>
      'Beklager, det er vårt eksempelprodukt, du kan ikke redigere det :)';

  @override
  String get product_list_your_ranking => 'Din rangering';

  @override
  String get product_list_empty_icon_desc => 'Historikk utilgjengelig';

  @override
  String get product_list_empty_title => 'Start skanning';

  @override
  String get product_list_empty_message =>
      'Skannede produkter vil vises her, og du kan sjekke detaljert informasjon om dem';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produkter',
      one: 'produkt',
      zero: 'produkt',
    );
    return 'Oppdaterer $_temp0 i historikken din';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Produkter',
      one: 'Produkt',
      zero: 'Produkt',
    );
    return '$_temp0 oppdatering fullført';
  }

  @override
  String get product_list_compare_side_by_side => 'Sammenlign side ved side';

  @override
  String get loading_dialog_default_title => 'Laster ned data';

  @override
  String get loading_dialog_default_error_message =>
      'Kunne ikke laste ned data';

  @override
  String get account_delete => 'Slett konto';

  @override
  String get account_delete_title => 'Slett kontoen min';

  @override
  String get user_profile => 'Konto';

  @override
  String get user_profile_title_guest => 'Velkommen!';

  @override
  String get user_profile_subtitle_guest =>
      'Logg inn eller registrer deg for å bli med i Open Food Facts-fellesskapet';

  @override
  String user_profile_title_id_email(String email) {
    return 'Åpne Matfakta-innlogging: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Velkommen $id!';
  }

  @override
  String get email_subject_account_deletion => 'Slett konto';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hei, vennligst slett Open Food Facts-kontoen min: $userId';
  }

  @override
  String get settings_app_app => 'Applikasjon';

  @override
  String get settings_app_data => 'Personvern og overvåking';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Produkter';

  @override
  String get settings_app_miscellaneous => 'Diverse';

  @override
  String get camera_play_sound_title => 'Spill av en lyd ved skanning';

  @override
  String get camera_play_sound_subtitle =>
      'Vil pipe ved hver vellykket skanning';

  @override
  String get camera_window_accessibility_label =>
      'Skann en strekkode med kameraet ditt';

  @override
  String get app_haptic_feedback_title => 'Vibrasjon og haptikk';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrasjoner etter utførelse av enkelte handlinger (strekkode dekodet, produkt fjernet…).';

  @override
  String get crash_reporting_toggle_title => 'Feilrapportering';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Når det er aktivert, sendes krasjrapporter automatisk til Open Food Facts\' feilsporingssystem, slik at feil kan rettes og dermed forbedre appen.';

  @override
  String get send_anonymous_data_toggle_title => 'Del anonyme data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Rediger bilde';

  @override
  String get permission_photo_error => 'Feilmelding';

  @override
  String get permission_photo_denied_title =>
      'Tillat kamerabruk for å skanne strekkoder';

  @override
  String permission_photo_denied_message(String appName) {
    return 'For en forbedret opplevelse, vennligst gi $appName tilgang til kameraet ditt. Du vil kunne skanne strekkoder direkte.';
  }

  @override
  String get permission_photo_denied_button => 'Tillate';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Tillatelse nektet';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Siden du tidligere har nektet kameratillatelse, må du tillate det manuelt fra Innstillingene.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Open Settings';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Avbryt';

  @override
  String get permission_photo_none_found => 'Ingen kamera oppdaget';

  @override
  String get permission_photo_denied => 'Ingen kameratilgang gitt';

  @override
  String get show_product_pictures => 'Vis produktbilder';

  @override
  String get edit_product_label => 'Rediger produkt';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Laster opp redigeringene dine…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Redigeringene dine sendes i bakgrunnen (eller senere ved feil).\nDu kan fortsette å redigere andre produktfelt.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Redigerelsene dine sendes i bakgrunnen (eller senere ved feil).';

  @override
  String get edit_product_label_short => 'Rediger ';

  @override
  String edit_product_form_item_help(String value) {
    return 'Hvordan skriver man inn «$value»?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Vennligst skriv inn en verdi som ikke er tom!';

  @override
  String get edit_product_form_item_error_existing =>
      'Denne verdien er allerede der!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Legg til et nytt merke';

  @override
  String get edit_product_form_item_add_action_label =>
      'Legg til en ny etikett';

  @override
  String get edit_product_form_item_add_action_store => 'Legg til en ny butikk';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Legg til en ny opprinnelse';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Legg til en ny sporbarhetskode';

  @override
  String get edit_product_form_item_add_action_country =>
      'Legg til et nytt land';

  @override
  String get edit_product_form_item_add_action_category =>
      'Legg til en ny kategori';

  @override
  String get edit_product_form_item_add_action_trace => 'Legg til et nytt spor';

  @override
  String get edit_product_form_item_add_suggestion => 'Legg til forslag';

  @override
  String get edit_product_form_item_deny_suggestion => 'Nekt forslag';

  @override
  String get edit_product_form_item_details_title => 'Grunnleggende detaljer';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Produktnavn, merke, antall';

  @override
  String get edit_product_form_item_other_details_title =>
      'Ytterligere detaljer';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Nettsted…';

  @override
  String get edit_product_form_item_photos_title => 'Bilder';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Legg til eller oppdater bilder';

  @override
  String get edit_product_form_item_labels_title =>
      'Etiketter og sertifiseringer';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Miljø, kvalitetsmerker…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Skriv inn en etikett (f.eks.: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'stempel';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'God praksis: Etiketter';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Enhver egenskap ved produktet **som er faktisk** og forskjellig fra de andre feltene.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Laget i Belgia, produsert i Bretagne…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rik på fiber, kilde til jern…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Rettferdig handel, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Butikker';

  @override
  String get edit_product_form_item_stores_hint => 'Legg inn en butikk';

  @override
  String get edit_product_form_item_stores_type => 'butikk';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'God praksis: Butikker';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Skriv inn butikken der du kjøpte produktet.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Opprinnelse';

  @override
  String get edit_product_form_item_origins_hint =>
      'Skriv inn en opprinnelse (f.eks. Tyskland)';

  @override
  String get edit_product_form_item_origins_type => 'land';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'God praksis: Opprinnelse';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Legg til **eventuelle opprinnelsesangivelser du finner på emballasjen**.\nDu trenger ikke å bekymre deg for opprinnelsesangivelser som er angitt direkte i ingredienslisten.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Storfekjøtt fra Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soyaen kommer ikke fra EU';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Skriv inn et land (f.eks. Tyskland)';

  @override
  String get edit_product_form_item_countries_type => 'land';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'God praksis: Land';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Land der produktet er allment tilgjengelig** (ikke inkludert butikker som spesialiserer seg på utenlandske produkter).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Sporbarhetskode';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Skriv inn en kode (f.eks.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'sporbarhetskode';

  @override
  String get edit_product_form_item_emb_help_title =>
      'God praksis: Sporbarhetskoder';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'I denne delen kan du legge inn koder relatert til **emballasjemerker**, **identifikasjonsmerker** eller **helsemerker**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Eksempler på sporbarhetskoder';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EF-koder** brukt i Det europeiske fellesskap for å identifisere matprodusenter eller -pakkere:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: landskode for **Frankrike**\n**72.264.002**: geografiske data\n**CE**: Det europeiske fellesskap';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB-koder** brukt i Frankrike:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Spor';

  @override
  String get edit_product_form_item_traces_hint => 'spor';

  @override
  String get edit_product_form_item_traces_type =>
      'Skriv inn et spor (f.eks. soyabønner)';

  @override
  String get edit_product_form_item_categories_title => 'Kategorier';

  @override
  String get edit_product_form_item_categories_hint => 'kategori';

  @override
  String get edit_product_form_item_categories_type =>
      'Skriv inn en kategori (f.eks.: Appelsinjuice)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'God praksis: Kategorier';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Angi **kun den mest spesifikke kategorien**.\nOverordnede kategorier vil bli lagt til automatisk.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Mangler kategori?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Hvis en kategori **ikke er tilgjengelig i autofullføring**, kan du gjerne legge den til likevel.\nDette vil hjelpe oss med å forbedre Open Food Facts i landet ditt.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardiner i olivenolje';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Appelsinjuice fra konsentrat';

  @override
  String get edit_product_form_item_exit_title => 'Avslutte uten å lagre?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Vil du lagre endringene dine før du forlater denne siden?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Lagre endringer';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Forkast endringer';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredienser';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Zoom inn og ut ved å klype skjermen';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Zoom inn og ut av bildet';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Ved å bruke **Klyp-for-å-zoome-bevegelsen** kan du zoome inn eller ut av bildet:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Legg til';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Vennligst skriv inn en tekst først';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Fjerne';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Lagre redigeringen din';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Avbryt redigeringen din';

  @override
  String get edit_product_form_item_packaging_title =>
      'Instruksjoner for resirkulering, bilde';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Ernæringsinnhold';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Ernæring, alkoholinnhold…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'God praksis: Næringsinnhold';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Næringsverdier';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Først velger du om **verdiene er oppgitt**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Ernæringsinnhold';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Deretter skriver du inn næringsverdiene **som angitt på emballasjen**. Hvis det ikke finnes noen verdi, kan du klikke på «Øye»-ikonet.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Mangler et felt?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Hvis en oppføring mangler, kan du **klikke på «Pluss»-ikonet** for å legge den til (f.eks.: vitamin D, magnesium…).';

  @override
  String get edit_product_form_save => 'Rediger ';

  @override
  String get edit_product_ingredients_photo_title => 'Ingredienser bilde';

  @override
  String get edit_product_ingredients_list_title => 'Ingrediensliste';

  @override
  String get edit_product_packaging_photo_title => 'Emballasjebilde';

  @override
  String get edit_product_packaging_list_title => 'Pakkeliste';

  @override
  String get no_data_available => 'Ingen data tilgjengelig';

  @override
  String get product_field_website_title => 'Nettsted';

  @override
  String get origins_editing_title => 'Rediger opprinnelse';

  @override
  String get completed_basic_details_btn_text =>
      'Fullfør grunnleggende detaljer';

  @override
  String get not_implemented_snackbar_text => 'Ikke implementert ennå';

  @override
  String get category_picker_page_appbar_text => 'Kategorier';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Hent ut ingredienser fra bildet';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Hent ut ingredienser';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Uttrekk av ingredienser\nfra bildet';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Laster inn bilde…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Hvorfor ser jeg denne meldingen?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'For å bruke funksjonen «Trekke ut ingredienser», må bildet lastes opp først.\n\nVent noen sekunder eller skriv dem inn manuelt.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Oppdater bildet';

  @override
  String get edit_packaging_extract_btn_text =>
      'Hent ut emballasje\nfra bildet';

  @override
  String get edit_packaging_extract_btn_text_short => 'Ekstraktemballasje';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Utpakking av emballasje fra bildet';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Laster inn bilde…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Hvorfor ser jeg denne meldingen?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'For å bruke funksjonen «Pakk ut emballasje» må bildet lastes opp først.\n\nVent noen sekunder eller skriv dem inn manuelt.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Oppdater bildet';

  @override
  String get edit_ocr_extract_failed =>
      'Kunne ikke gjenkjenne tekst på bildet.';

  @override
  String get edit_ocr_extract_disabled_title => 'Ikke noe bilde!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'For å bruke tekstuttrekkingsfunksjonen må du først ta et bilde.';

  @override
  String get user_list_dialog_new_title => 'Ny liste med produkter';

  @override
  String get user_list_dialog_rename_title => 'Endre listenavn';

  @override
  String get user_list_subtitle_product => 'Lister';

  @override
  String get user_list_title => 'Listene dine';

  @override
  String get user_list_add_product => 'Legg produktet til i listene dine';

  @override
  String get user_list_button_new => 'Opprett en ny liste';

  @override
  String get user_list_empty_label =>
      'Ingen liste tilgjengelig ennå, start med å lage en';

  @override
  String get user_list_button_add_product => 'Legg til i liste';

  @override
  String get added_to_list_msg => 'Lagt til i liste';

  @override
  String get user_list_popup_clear => 'Tøm historikken din';

  @override
  String get user_list_popup_rename => 'Gi nytt navn';

  @override
  String get user_list_name_hint => 'Min liste';

  @override
  String get user_list_name_error_empty => 'Navn er obligatorisk';

  @override
  String get user_list_name_error_already => 'Navnet er allerede i bruk';

  @override
  String get user_list_name_error_same => 'Det er det samme navnet';

  @override
  String get user_list_name_input_hint => 'Navnet på listen';

  @override
  String get try_again => 'Prøv igjen';

  @override
  String get there_was_an_error => 'Det oppstod en feil';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Ingen kategori funnet for $items';
  }

  @override
  String get camera_toggle_camera => 'Bytt mellom bak- og frontkamera';

  @override
  String get camera_toggle_flash => 'Slå PÅ eller AV blitsen på kameraet';

  @override
  String get camera_enable_flash => 'Aktiver blits';

  @override
  String get camera_disable_flash => 'Deaktiver blits';

  @override
  String get camera_flash_error_dialog_title => 'Det oppstod en feil!';

  @override
  String get camera_flash_error_dialog_message =>
      'Det oppstod en feil mens du endret statusen til blitsen. Vennligst forsikre deg om at telefonen din ikke har aktivert lommelykta.';

  @override
  String get category_picker_no_category_found_button => 'Tilbake';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Klikk for å åpne i nettleseren din eller i appen (hvis den er installert)';

  @override
  String get dev_preferences_screen_title => 'DEV-modus';

  @override
  String get dev_preferences_screen_subtitle =>
      'Få tilgang til eksperimentelle funksjoner og utviklingsverktøy';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Start omstart av onboarding';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Du må da starte appen på nytt for å se det igjen.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Bytt mellom openfoodfacts.org (PROD) og testmiljø';

  @override
  String get dev_preferences_test_environment_title =>
      'Parametere for testmiljø';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Basis-URL for gjeldende testmiljø: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title => 'Testmiljøvert';

  @override
  String get dev_preferences_ml_kit_title => 'Bruk ML-settet';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'så må du starte denne appen på nytt';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Ekstra knapp på produktsiden';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Rediger ingredienser via en kunnskapspanelknapp';

  @override
  String get dev_preferences_export_history_title => 'Eksporthistorikk';

  @override
  String get dev_preferences_export_history_progress_error => 'unntak';

  @override
  String get dev_preferences_export_history_progress_found => 'produkt funnet';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produkt IKKE funnet';

  @override
  String get dev_preferences_export_history_dialog_title => 'Eksporthistorikk';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Avbryt';

  @override
  String get dev_preferences_migration_title => 'Datamigrering fra V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Status: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'suksess eller ny installasjon';

  @override
  String get dev_preferences_migration_status_success => 'suksess';

  @override
  String get dev_preferences_migration_status_error => 'feil';

  @override
  String get dev_preferences_migration_status_in_progress => 'pågår';

  @override
  String get dev_preferences_migration_status_required =>
      'obligatorisk (klikk for å starte)';

  @override
  String get dev_preferences_migration_status_not_started => 'ukjent';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Vil slette historikken og legge inn 3 produkter der';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Tilpasset URL for nyheter';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL-adressen til JSON-filen:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Ikke angitt';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Siste oppdatering: $date';
  }

  @override
  String get product_type_label_food => 'Mat';

  @override
  String get product_type_label_beauty => 'Personlig pleie';

  @override
  String get product_type_label_pet_food => 'Kjæledyrfôr';

  @override
  String get product_type_label_product => 'Andre';

  @override
  String get product_type_selection_title => 'Produkttype';

  @override
  String get product_type_selection_subtitle => 'Velg typen av dette produktet';

  @override
  String get product_type_selection_empty =>
      'Du må velge en produkttype først!';

  @override
  String product_type_selection_already(String productType) {
    return 'Du kan ikke endre produkttypen ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Snarvei til Priser-appen på produktsiden';

  @override
  String get prices_app_button => 'Gå til Priser-appen';

  @override
  String get prices_website_button => 'Åpne på Open Prices website';

  @override
  String get prices_bulk_proof_upload_select =>
      'Legg til prislapper direkte fra galleriet';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Når du har valgt bilder, kan du ikke redigere dem!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'La fellesskapet validere prisene utvunnet av AI.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Flere prislapper';

  @override
  String get prices_bulk_proof_upload_title => 'Masseopplasting av bevis';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Velger filer';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Starter opplasting';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Lokalt kopierer fil #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Forbereder opplasting av #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Mislyktes på bilde #$index/$count';
  }

  @override
  String get prices_generic_title => 'Priser';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Legg til $count priser',
      one: 'Legg til en pris',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Send $count priser',
      one: 'Send prisen',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Legg til et element';

  @override
  String get prices_add_a_price => 'Legg til en pris';

  @override
  String get prices_add_a_receipt => 'Legg til en kvittering';

  @override
  String get prices_add_price_tags => 'Legg til prislapper';

  @override
  String prices_barcode_already(String barcode) {
    return 'Denne strekkoden ($barcode) er allerede i listen!';
  }

  @override
  String get prices_barcode_search_not_found => 'Fant ikke produktet';

  @override
  String get prices_barcode_search_none_yet => 'Ingen produkt ennå';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Leter etter $barcode';
  }

  @override
  String get prices_barcode_enter => 'Skriv inn strekkoden';

  @override
  String get prices_category_enter => 'Element uten strekkode';

  @override
  String get prices_per_kilogram => 'Pris per kilogram';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / enhet';

  @override
  String get prices_category_mandatory => 'Obligatorisk';

  @override
  String get prices_category_optional => 'Valgfritt';

  @override
  String get prices_category_error_mandatory => 'Kategorien er obligatorisk';

  @override
  String get prices_barcode_reader_action => 'Strekkodeleser';

  @override
  String get prices_view_prices => 'Se prisene';

  @override
  String get prices_list_title => 'Prisliste';

  @override
  String get prices_list_count => 'Antall\npriser';

  @override
  String get prices_list_add_new_price => 'Legg til en\nny pris';

  @override
  String get prices_list_empty_title => 'Ingen pris ennå!';

  @override
  String get prices_list_empty_subtitle =>
      'Bli den første til å legge til en:\nved å skanne en **kvittering** eller en **pristagg**!';

  @override
  String get prices_entry_shop_not_found => 'Ukjent butikk';

  @override
  String prices_entry_menu_title(String user) {
    return 'Pris oppføring fra \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Vis alle priser for dette produktet';

  @override
  String get prices_entry_menu_open_proof => 'Vis bevis';

  @override
  String get prices_entry_menu_my_prices => 'Vis mine andre priser';

  @override
  String get prices_entry_menu_author_prices =>
      'Se andre priser av forfatteren';

  @override
  String get prices_entry_menu_shop_prices => 'Vis andre priser fra butikken';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count priser',
      one: '1 pris',
    );
    return '$_temp0 for $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Alle $count priser',
      one: 'Kun én pris',
      zero: 'Ingen pris ennå',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Siste $pageSize priser (totalt: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Pris: $price / Butikk: \"$location\" / Publisert $date av \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Åpne bevis for «$user»';
  }

  @override
  String get prices_open_proof => 'Åpen prisbevis';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Alle $count bevis',
      one: 'Bare ett bevis',
      zero: 'Ingen bevis ennå',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Siste $pageSize bevis (totalt: $total)';
  }

  @override
  String get prices_users_empty_title => 'Ingen bidragsyter ennå!';

  @override
  String get prices_users_empty_explanation =>
      'Bli den første til å legge til en pris!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Topp $pageSize bidragsytere (totalt: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Ingen butikk ennå!';

  @override
  String get prices_locations_empty_explanation =>
      'Bli den første til å legge til en pris!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Topp $pageSize steder (totalt: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bevis',
      one: 'Ett bevis',
      zero: 'Ingen bevis',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkter',
      one: 'Ett produkt',
      zero: 'Ingen produkter',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count brukere',
      one: 'Én bruker',
      zero: 'Ingen bruker',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count priser',
      one: 'Én pris',
      zero: 'Ingen pris',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Pris tidligere lagt til';

  @override
  String get prices_amount_subtitle => 'Beløp';

  @override
  String get prices_amount_is_discounted => 'Er det rabattert?';

  @override
  String get prices_amount_price_normal => 'Pris';

  @override
  String get prices_amount_price_discounted => 'Rabattert pris';

  @override
  String get prices_amount_price_not_discounted => 'Opprinnelig pris';

  @override
  String get prices_amount_no_product => 'Ett produkt mangler!';

  @override
  String get prices_amount_price_incorrect => 'Feil verdi';

  @override
  String get prices_amount_price_mandatory => 'Obligatorisk verdi';

  @override
  String get prices_currency_subtitle => 'Valuta';

  @override
  String get prices_date_subtitle => 'Dato';

  @override
  String get prices_location_subtitle => 'Butikk';

  @override
  String get prices_location_find => 'Finn en butikk';

  @override
  String get prices_location_mandatory => 'Du må velge en butikk!';

  @override
  String get prices_location_search_broader =>
      'Fant du ikke det du lette etter? La oss prøve et bredere søk!';

  @override
  String get prices_proof_subtitle => 'Bevis';

  @override
  String get prices_proof_empty_title => 'Ingen bevis ennå!';

  @override
  String get prices_proof_empty_explanation =>
      'Start ved å legge til et bilde av en **kvittering** eller en **pristagg**!';

  @override
  String get prices_proof_find => 'Velg et bevis';

  @override
  String get prices_proof_change => 'Endringsbevis';

  @override
  String get prices_proof_receipt => 'Kvittering';

  @override
  String get prices_proof_price_tag => 'Prislapp';

  @override
  String get prices_proof_mandatory => 'Du må velge et bevis!';

  @override
  String get prices_add_validation_error => 'Valideringsfeil';

  @override
  String get prices_privacy_warning_title => 'Personvernadvarsel';

  @override
  String get prices_unknown_product => 'Ukjent produkt';

  @override
  String get prices_privacy_warning_main_message =>
      'Prisene **vil være offentlige**, sammen med butikken de refererer til.\n\nDet kan gjøre det mulig for folk som kjenner til pseudonymet ditt fra Open Food Facts å:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Gjenkjenn hvilket område du bor i';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Vit hva du kjøper';

  @override
  String get prices_privacy_warning_sub_message =>
      'Hvis du er usikker på det, kan du endre pseudonymet ditt, eller opprette en ny Open Food Facts-konto og logge inn på appen med den.';

  @override
  String get i_refuse => 'Jeg nekter';

  @override
  String get i_accept => 'Jeg aksepterer';

  @override
  String get prices_currency_change_proposal_title => 'Endre valutaen?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Din nåværende valuta er **$currency**. Vil du endre den til **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Ja, bruk $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nei, behold $currency';
  }

  @override
  String get prices_menu_know_more => 'Lær mer om Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Ferdig';

  @override
  String get dev_mode_section_server => 'Serverkonfigurasjon';

  @override
  String get dev_mode_section_news => 'Konfigurasjon av nyhetsleverandør';

  @override
  String get dev_mode_section_product_page => 'Produktside';

  @override
  String get dev_mode_section_ui => 'Brukergrensesnitt';

  @override
  String get dev_mode_section_experimental_features =>
      'Eksperimentelle funksjoner';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Ekskluder grønn poengsum';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Bruk en stavekontroll for OCR-skjermer';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredienser og emballasje)';

  @override
  String get dev_mode_reset_app_language_title => 'Tilbakestill appspråk';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Opprett oppgavelapper';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Bytt mellom prices.openfoodfacts.org (PROD) og test env';

  @override
  String get search_history_item_edit_tooltip =>
      'Bruk og rediger dette søket på nytt';

  @override
  String get search_history_item_remove_tooltip => 'Fjerne';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Du har lastet ned $totalSize produkter.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Last ned $count flere produkter\nAllerede lastet ned $downloaded av $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Søket ditt etter $search pågår.\n\nVent noen sekunder…';
  }

  @override
  String get user_search_contributor_title => 'Produkter jeg har lagt til';

  @override
  String get user_search_informer_title => 'Produkter jeg har redigert';

  @override
  String get user_search_photographer_title => 'Produkter jeg har fotografert';

  @override
  String get user_search_to_be_completed_title =>
      'Mine produkter som skal fullføres';

  @override
  String get user_search_prices_title => 'Mine priser';

  @override
  String get user_search_proofs_title => 'Mine bevis';

  @override
  String get user_search_proof_title => 'Mitt bevis';

  @override
  String search_proof_title(String user) {
    return 'Bevis fra «$user»';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Bidragsyter priser: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Siste priser lagt til';

  @override
  String get all_search_prices_top_user_title => 'De største prisbidragsyterne';

  @override
  String get all_search_prices_top_location_title =>
      'Butikkene med de høyeste prisene';

  @override
  String get prices_contribution_assistant => 'Assistent for prisbidrag';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Legg til flere bevis';

  @override
  String get all_search_prices_top_location_single_title =>
      'Priser i en butikk';

  @override
  String get all_search_prices_top_product_title =>
      'Produktene med høyest pris';

  @override
  String get all_search_to_be_completed_title =>
      'Alle produkter som skal fullføres';

  @override
  String get categorize_products_country_title =>
      'Hjelp med å kategorisere produkter i landet ditt';

  @override
  String get edit_product_action_retake_picture => 'Ta bildet på nytt';

  @override
  String get edit_product_action_take_picture => 'Ta bilde';

  @override
  String get edit_product_action_confirm => 'Bekreft';

  @override
  String get signup_page_terms_of_use_line1 => 'Jeg godtar Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => 'vilkår for bruk og bidrag';

  @override
  String get analytics_consent_image_semantic_label => 'Analytics-ikon';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Fatal feil: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Fatal feil: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Fullfør grunnleggende detaljer';

  @override
  String get edit_photo_button_label => 'Rediger ';

  @override
  String get edit_photo_unselect_button_label => 'Fjern valg av bilde';

  @override
  String get edit_photo_select_existing_button_label =>
      'Velg et eksisterende bilde';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Velg et bilde ved å klikke på det';

  @override
  String get edit_photo_select_existing_download_label =>
      'Henter eksisterende bilder…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Det er ingen bilder lastet opp tidligere relatert til dette produktet.';

  @override
  String get edit_photo_language_not_this_one =>
      'Ingen bilder på det språket ennå';

  @override
  String get edit_photo_language_none => 'Ikke noe bilde ennå';

  @override
  String get category_picker_screen_title => 'Kategorier';

  @override
  String get basic_details => 'Grunnleggende detaljer';

  @override
  String get product_name => 'Produktnavn';

  @override
  String get product_names => 'Produktnavn';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Legg til en ny oversettelse';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Før du validerer, må du bare legge til en oversettelse **hvis språket står på emballasjen**';

  @override
  String get add_basic_details_product_name_open_photo => 'Se forsidebilde';

  @override
  String get add_basic_details_product_name_take_photo => 'Ta et bilde foran';

  @override
  String get add_basic_details_product_name_hint =>
      'Skriv inn navnet på produktet (f.eks. Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Endre standard språk?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Vil du at produktets standardspråk skal angis til \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Gode eksempler';

  @override
  String get explanation_section_bad_examples => 'Dårlige eksempler';

  @override
  String get add_basic_details_product_name_help_title =>
      'God praksis: Produktnavn';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Produktnavnet er **hovednavnet som er trykt på emballasjen**. Det kan være et registrert varemerke.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Merk:** Vennligst ikke legg til en oversettelse **hvis språket ikke finnes på emballasjen**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomatketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Ikke ta med merkevaren i navnet';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomatketchup **fra Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Ikke bruk symbolene ®, ™, © eller lignende';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count andre oversettelser',
      one: '$count annen oversettelse',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Merkenavn';

  @override
  String get brand_names => 'Merkenavn';

  @override
  String get add_basic_details_brand_name_error =>
      'Vennligst skriv inn merkenavnet';

  @override
  String get add_basic_details_brand_names_hint =>
      'Merker av innsatsfaktorer (f.eks. Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'God praksis: Merker';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Skriv inn **alle merkene til produktet**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Hovedmerke';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Hovedmerket**, som vanligvis vises tydelig på forsiden av pakken, skal **oppgis først**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Andre merker';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Når det selges **av et stort selskap**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** selges av **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Når det selges med sitt merke **oversatt til flere språk**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** skrives noen ganger som **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Mengde og vekt';

  @override
  String get add_basic_details_quantity_hint =>
      'Skriv inn vekten og om nødvendig mengden (f.eks.: 4 x 100 g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'God praksis: Mengde';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Kopier verdien som er angitt på produktet, og **ikke glem enhetene**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** eller **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (for 6 egg)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(for et produkt med 3 esker, hver på 150 g)';

  @override
  String get barcode => 'Strekkode';

  @override
  String barcode_barcode(String barcode) {
    return 'Strekkode: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Ugyldig strekkode';

  @override
  String get basic_details_add_success => 'Grunnleggende detaljer lagt til';

  @override
  String get basic_details_add_error =>
      'Kunne ikke legge til grunnleggende detaljer. Vennligst prøv igjen om en liten stund';

  @override
  String get clear_search => 'Fjern søket ditt';

  @override
  String get confirm_clear =>
      'Du er i ferd med å tømme hele loggen din: er du sikker på at du vil fortsette?';

  @override
  String get alert_clear_selected_user_list =>
      'Du er i ferd med å slette utvalgte elementer fra loggen din';

  @override
  String get confirm_clear_selected_user_list =>
      'Er du sikker på at du vil fortsette?';

  @override
  String get alert_select_items_to_clear =>
      'Vennligst velg ett eller flere elementer som skal fjernes';

  @override
  String confirm_clear_user_list(String name) {
    return 'Du er i ferd med å tømme denne listen ($name): er du sikker på at du vil fortsette?';
  }

  @override
  String get confirm_delete_user_list_title => 'Vil du slette listen?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Du er i ferd med å slette listen \"$name\".\nEr du sikker på at du vil fortsette?';
  }

  @override
  String get confirm_delete_user_list_button => 'Ja, jeg bekrefter';

  @override
  String importance_label(String name, String id) {
    return '$name viktighet: $id';
  }

  @override
  String get user_list_all_title => 'Lister';

  @override
  String get user_list_all_empty => 'Opprett din første liste';

  @override
  String get product_list_select => 'Velg en liste';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkter',
      one: 'Ett produkt',
      zero: 'Tom liste',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Legg til liste';

  @override
  String get open_food_preferences_tooltip => 'Rediger dine matpreferanser';

  @override
  String get add_photo_button_label => 'Legg til bilde';

  @override
  String get add_packaging_photo_button_label =>
      'Ta bilde av eventuell emballasje/resirkuleringsinformasjon';

  @override
  String get add_origin_photo_button_label =>
      'Ta bilde av eventuell oprinnelsesinformasjon';

  @override
  String get add_emb_photo_button_label =>
      'Ta bilder av all sporbarhetskodeinformasjon';

  @override
  String get add_label_photo_button_label =>
      'Ta bilder av eventuelle etiketter og sertifiseringsinformasjon';

  @override
  String get choose_image_source_title => 'Velg bildekilde';

  @override
  String get choose_image_source_body => 'Velg kilde til bildet';

  @override
  String get gallery_source_label => 'Galleri';

  @override
  String get gallery_source_access_denied_dialog_title => 'Tilgang nektet';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Dessverre har ikke appen tilgang til galleriet ditt, siden du tidligere har nektet tillatelsen.\n\nGå til appinnstillingene i telefonen din Innstillinger -> Bilder';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Åpne innstillingene';

  @override
  String get share => 'Del';

  @override
  String share_product_text(String url) {
    return 'Ta en titt på dette produktet på Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Ta en titt på dette produktet på Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Ta en titt på dette produktet på Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Ta en titt på dette produktet på Åpne produktfakta: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Ta en titt på min liste med produkter på Open Food Facts: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Ta et bilde';

  @override
  String get choose_from_gallery => 'Velg fra bildegalleri';

  @override
  String get image_upload_queued =>
      'Dette bildet vil lastes opp i bakgrunnen så fort som mulig.';

  @override
  String get add_price_queued =>
      'Prisen vil bli sendt til serveren så snart som mulig.';

  @override
  String get background_task_title_full_refresh =>
      'Starter oppdateringen av alle produktene som er lagret lokalt';

  @override
  String get background_task_title_folksonomy =>
      'Starter å utføre server-handlinger for folksonomi-oppdateringer lagret lokalt';

  @override
  String get background_task_title_top_n =>
      'Starter nedlastingen av de mest populære produktene';

  @override
  String get expand_nutrition_facts => 'Utvid tabellen for ernæringsfakta';

  @override
  String get expand_nutrition_facts_body =>
      'Hold tabellen for ernæringsfakta utvidet';

  @override
  String get expand_ingredients => 'Utvid ingredienser';

  @override
  String get expand_ingredients_body => 'Hold ingredienspanelet utvidet';

  @override
  String get no_internet_connection => 'Ingen internettforbindelse';

  @override
  String get world_results_label => 'Hele verden';

  @override
  String get world_results_action => 'Utvid søket ditt til verden';

  @override
  String get copy_to_clipboard => 'Kopier';

  @override
  String get paste_from_clipboard => 'Lim inn fra utklippstavlen';

  @override
  String get no_data_available_in_clipboard =>
      'Ingen data tilgjengelig på utklippstavlen';

  @override
  String get clipboard_barcode_copy => 'Kopier strekkoden til utklippstavlen';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Strekkode $barcode kopiert til utklippstavlen!';
  }

  @override
  String get open_product_website => 'Åpne dette produktet på nettsiden';

  @override
  String get language_picker_label => 'Språket ditt';

  @override
  String get country_picker_label => 'Landet ditt';

  @override
  String get currency_picker_label => 'Din valuta';

  @override
  String get help_with_openfoodfacts => 'Hjelp med OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produktet vil bli oppdatert i bakgrunnen så fort som mulig.';

  @override
  String get no_email_client_available_dialog_title => 'Ingen e-postapper!';

  @override
  String get no_email_client_available_dialog_content =>
      'Send oss en e-post manuelt til mobile@openfoodfacts.org';

  @override
  String get all_images => 'Alle bilder';

  @override
  String get selected_images => 'Utvalgte bilder';

  @override
  String get product_card_remove_product_tooltip => 'Fjern produktet';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Ny strekkode skannet: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Fjern alle produkter fra karusellen';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Vennligst skann minst to produkter for å sammenligne dem';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Klikk for å sammenligne produktene du har skannet';

  @override
  String get scan_product_loading => 'Du har skannet\nstrekkoden:';

  @override
  String get scan_product_loading_initial =>
      'Vi ser etter dette produktet!\nVent noen sekunder…';

  @override
  String get scan_product_loading_long_request =>
      'Vi leter fortsatt etter dette produktet!\nSynes du det tar lang tid å laste? Det gjør vi også…';

  @override
  String get scan_product_loading_unresponsive =>
      'Vi leter fortsatt etter dette produktet.\nVil du starte søket på nytt?';

  @override
  String get scan_product_loading_restart_button => 'Start søket på nytt';

  @override
  String get portion_calculator_description =>
      'Beregn næringsinnhold for en bestemt mengde';

  @override
  String get portion_calculator_hint => 'Antall i';

  @override
  String get portion_calculator_accessibility =>
      'Skriv inn en mengde for å beregne næringsinnhold';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Vennligst skriv inn en mengde mellom $min og $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Manglende data. Beregningen kunne ikke utføres.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Næringsinnhold for $grams g (eller ml)';
  }

  @override
  String get offline_data => 'Frakoblede data';

  @override
  String get ocr_image_upload_instruction =>
      'Last opp et bilde for å automatisk hente ut informasjonen det inneholder.';

  @override
  String get upload_image => 'Last opp bilde';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Kunne ikke laste ned bildet';

  @override
  String get image_edit_url_error =>
      'Kunne ikke redigere bildet fordi bilde-URL-en ikke ble angitt.';

  @override
  String get user_picture_source_remember => 'Husk valget mitt';

  @override
  String get user_picture_source_ask => 'Spør hver gang';

  @override
  String get robotoff_continue => 'Fortsette';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count spørsmål',
      one: 'spørsmål',
    );
    return 'Neste $_temp0';
  }

  @override
  String get show_password => 'Vis passord';

  @override
  String get owner_field_info_title => 'Produsentens oppgitte verdier';

  @override
  String get owner_field_info_message =>
      'Med den logoen fremhever vi data levert av produsenten, og som kanskje ikke kan redigeres.';

  @override
  String get owner_field_info_close_button => 'Lukk denne informasjonen';

  @override
  String get owner_field_image =>
      'Dette bildet er levert av produsenten. Det kan hende det ikke kan redigeres.';

  @override
  String get edit_packagings_title => 'Emballasjekomponenter';

  @override
  String get edit_packagings_element_add => 'Legg til en emballasjekomponent';

  @override
  String get edit_packagings_completed => 'Emballasjen er komplett';

  @override
  String edit_packagings_element_title(int index) {
    return 'Emballasjekomponent #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Antall enheter';

  @override
  String get edit_packagings_element_hint_units =>
      'Angi antall emballasjeenheter av samme form og materiale som produktet inneholder.';

  @override
  String get edit_packagings_element_field_shape => 'Form';

  @override
  String get edit_packagings_element_hint_shape =>
      'Skriv inn formnavnet som er oppført i resirkuleringsinstruksjonene hvis de er tilgjengelige, eller velg en form.';

  @override
  String get edit_packagings_element_example_shape => 'Flaske';

  @override
  String get edit_packagings_element_field_material => 'Materiale';

  @override
  String get edit_packagings_element_hint_material =>
      'Oppgi det spesifikke materialet hvis det kan bestemmes (en materialkode inni en trekant finnes ofte på emballasjedelene), eller et generisk materiale (for eksempel plast eller metall) hvis du er usikker.';

  @override
  String get edit_packagings_element_example_material => 'Glass';

  @override
  String get edit_packagings_element_field_recycling =>
      'Instruksjoner for resirkulering';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Skriv bare inn resirkuleringsinstruksjoner hvis de er oppført på produktet.';

  @override
  String get edit_packagings_element_example_recycling => 'Resirkulere';

  @override
  String get edit_packagings_element_field_quantity =>
      'Netto mengde produkt per enhet';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Skriv inn nettovekten eller nettovolumet og angi enheten (for eksempel g eller ml).';

  @override
  String get edit_packagings_element_field_weight => 'Vekt av én tom enhet (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Fjern eventuelle matrester og vask og tørk emballasjen før veiing. Bruk om mulig en vekt med 0,1 g eller 0,01 g presisjon.';

  @override
  String get background_task_title => 'Ventende bidrag';

  @override
  String get background_task_subtitle =>
      'Bidragene dine lagres automatisk på serveren vår, men ikke alltid i sanntid.';

  @override
  String get background_task_list_empty => 'Ingen ventende bakgrunnsoppgaver';

  @override
  String get background_task_error_server_time_out => 'Servertidsavbrudd';

  @override
  String get background_task_error_no_internet =>
      'Internett-tilkoblingsfeil. Prøv senere.';

  @override
  String get background_task_operation_unknown => 'ukjent operasjonstype';

  @override
  String get background_task_operation_details => 'detaljerte endringer';

  @override
  String get background_task_operation_image => 'bildeopplasting';

  @override
  String get background_task_operation_refresh =>
      'oppdatering forsinket etter bildeopplasting';

  @override
  String get background_task_run_started => 'startet';

  @override
  String get background_task_run_not_started => 'ikke startet ennå';

  @override
  String get background_task_run_to_be_deleted => 'skal slettes';

  @override
  String get background_task_question_stop =>
      'Vil du stoppe den oppgaven så fort som mulig?';

  @override
  String get feed_back => 'Tilbakemelding';

  @override
  String get undo => 'Angre';

  @override
  String get copy_email_to_clip_board => 'Kopier e-post til utklippstavlen';

  @override
  String get please_send_us_an_email_to => 'Send oss en e-post manuelt til';

  @override
  String get email_copied_to_clip_board => 'E-post kopiert til utklippstavlen!';

  @override
  String get select_accent_color => 'Velg aksentfarge';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Blå';

  @override
  String get color_cyan => 'Cyan';

  @override
  String get color_green => 'Grønn';

  @override
  String get color_light_brown => 'Misligholde';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Oransje';

  @override
  String get color_pink => 'Rosa';

  @override
  String get color_red => 'Rød';

  @override
  String get color_rust => 'Rust';

  @override
  String get color_teal => 'Blågrønn';

  @override
  String get text_contrast_mode => 'Tekstkontrast';

  @override
  String get contrast_high => 'Høy';

  @override
  String get contrast_medium => 'Medium';

  @override
  String get contrast_low => 'Lav';

  @override
  String get product_refresher_internet_not_found =>
      'Produktet ble ikke funnet!';

  @override
  String get product_refresher_internet_not_connected =>
      'Du er ikke koblet til internett!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server nede ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Serverfeil ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produktet ble ikke funnet!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Et produkt med følgende strekkode finnes ikke i databasen vår: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Ingen internettforbindelse!';

  @override
  String get product_loader_network_error_message =>
      'Sjekk at smarttelefonen din er på et WiFi-nettverk eller at mobildata er aktivert';

  @override
  String get page_not_found_title => 'Siden ble ikke funnet!';

  @override
  String get page_not_found_button => 'Gå tilbake til hjemmesiden';

  @override
  String get download_data => 'Last ned data';

  @override
  String get download_top_products =>
      'Last ned de 1000 beste produktene i landet ditt for umiddelbar skanning';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produktene',
    );
    return 'Last ned de beste $_temp0 i ditt land for umiddelbar skanning';
  }

  @override
  String get download_in_progress => 'Laster ned data\nDette kan ta en stund';

  @override
  String downloaded_products(int num) {
    return '$num produkter lagt til';
  }

  @override
  String get update_offline_data => 'Oppdater produktdata frakoblet';

  @override
  String get update_local_database_sub =>
      'Oppdater den lokale produktdatabasen med de nyeste dataene fra Open Food Facts';

  @override
  String get clear_local_database => 'Fjern produktdata frakoblet';

  @override
  String get clear_local_database_sub =>
      'Fjern all lokal produktdata fra appen din for å frigjøre plass';

  @override
  String deleted_products(int num) {
    return '$num produkter slettet';
  }

  @override
  String get loading => 'Laster…';

  @override
  String get know_more => 'Lær mer';

  @override
  String get offline_data_desc => 'Klikk for å finne ut mer om frakoblet data';

  @override
  String get offline_product_data_title => 'Produktdata frakoblet';

  @override
  String available_for_download(int num) {
    return '$num produkter tilgjengelig for umiddelbar skanning';
  }

  @override
  String get country_selector_title => 'Velg ditt land:';

  @override
  String get currency_selector_title => 'Velg valuta:';

  @override
  String get language_selector_title => 'Velg språk:';

  @override
  String get language_selector_section_selected => 'Valgte språk';

  @override
  String get language_selector_section_frequently_used => 'Ofte brukt';

  @override
  String get action_delete_list => 'Slett';

  @override
  String get action_change_list => 'Endre gjeldende liste';

  @override
  String get product_list_create => 'Opprett';

  @override
  String get product_list_create_tooltip => 'Opprett en ny liste';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Ny beregning)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Ny beregning)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unknown Nutri-Score (New calculation)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score er ikke aktuelt';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score er ikke aktuelt (ny beregning)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Grå score A';

  @override
  String get environmental_score_b_new => 'Grå score B';

  @override
  String get environmental_score_c_new => 'Grå Score C';

  @override
  String get environmental_score_d_new => 'Grå score D';

  @override
  String get environmental_score_e_new => 'Grå score E';

  @override
  String get environmental_score_unknown_new => 'Ukjent Green-Score';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score er ikke relevant';

  @override
  String get nova_group_generic_new => 'Ultra-behandlet mat – NOVA-grupper';

  @override
  String get nova_group_1 => 'NOVA Gruppe 1';

  @override
  String get nova_group_2 => 'NOVA Gruppe 2';

  @override
  String get nova_group_3 => 'NOVA Gruppe 3';

  @override
  String get nova_group_4 => 'NOVA Gruppe 4';

  @override
  String get nova_group_unknown => 'Ukjent NOVA-gruppe';

  @override
  String get nutrition_facts => 'Næringsnivåer';

  @override
  String get faq_title_partners => 'Partnere og beskyttere av NGO-en';

  @override
  String get faq_title_vision =>
      'Open Food Facts visjon, oppdrag, verdier og programmer';

  @override
  String get faq_title_install_beauty =>
      'Installer Open Beauty Facts for å opprette en kosmetisk database';

  @override
  String get faq_title_install_pet =>
      'Installer Open Pet Food Facts for å opprette en database med kjæledyrfôr';

  @override
  String get faq_title_install_product =>
      'Installer Open Products Facts for å opprette en produktdatabase for å forlenge levetiden til objekter.';

  @override
  String get faq_nutriscore_nutriscore =>
      'Ny beregning av Nutri-Score: hva er nytt?';

  @override
  String get contact_title_pro_page =>
      'Pro? Importer produktene dine i Open Food Facts';

  @override
  String get contact_title_pro_email => 'Produsentkontakt';

  @override
  String get contact_title_press_page => 'Presseside';

  @override
  String get contact_title_press_email => 'Pressekontakt';

  @override
  String get contact_title_newsletter => 'Abonnér på vårt nyhetsbrev';

  @override
  String get contact_title_calendar => 'Abonner på vår fellesskapskalender';

  @override
  String get hunger_games_loading_line1 => 'Vennligst gi oss noen sekunder…';

  @override
  String get hunger_games_loading_line2 => 'Vi laster ned spørsmålene!';

  @override
  String get hunger_games_error_label =>
      'Æsj! Noe gikk galt… , og vi kunne ikke laste inn spørsmålene.';

  @override
  String get hunger_games_error_retry_button => 'La oss prøve på nytt!';

  @override
  String get reorder_attribute_action => 'Endre rekkefølgen på attributtene';

  @override
  String get link_cant_be_opened =>
      'Denne lenken kan ikke åpnes på enheten din. Sjekk at du har en nettleser installert.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Detaljer for $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Detaljer for $pageName med $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Del';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Hva er Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Hvor finner jeg den nye Nutri-Score-beregningen?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score brukes i 7 land: Frankrike, Tyskland, Belgia, Spania, Luxembourg, Nederland og Sveits.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Produsentene har maksimalt **2 år** etter at dekretet er undertegnet **til å erstatte** den gamle beregningen med den nye.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Hva er den grønne poengsumen?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score er en logo som tar sikte på å informere deg om **miljøpåvirkningen fra mat**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Fargekoden varierer fra mørk grønn (**A+**) for de **minst påvirkelige** produktene til mørk rød (**F**) for **de mest påvirkende** produktene.';

  @override
  String get guide_greenscore_logos_caption => 'The Green-Score logoene';

  @override
  String get guide_greenscore_lca_title => 'Kjerne: Livsløpsvurdering (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'En vitenskapelig vurdering av matkategorier';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'For hver produktkategori opprettes det en **benchmark** poengsum ved hjelp av data fra Agribalyse miljødatabasen (utformet av ADEME og INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Livssyklusanalyser** er en standardisert vurderingsmetode for å utføre en miljøvurdering med flere trinn og flere kriterier.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Det tiltak:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 produksjonstrinn';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Landbruk';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Bearbeiding';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Emballasje';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transport';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribusjon';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Forbruk';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indikatorer for miljøpåvirkning';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Climate change/carbon footprint';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Nedbryting av ozonlag';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ioniserende stråling';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Land';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Bruk av vann og energi';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Forurensning av luft';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Marine og ferskvann (partikler, forsuring, eutrofi)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Utarming av ressurser.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonuser & straff';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'For å belønne bedre produkter innenfor en kategori, bruker vi deretter **bonuser og straffer basert på flere kriterier**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'En **bonus** gis til produkter som har en **offisiell etikett, en etikett eller en sertifisering som garanterer miljøfordeler** (økologisk, rettferdig handel, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Ingrediensopprinnelse';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'En **bonus** tildeles basert på ingrediensenes opprinnelse. Denne bonusen tar hensyn til **påvirkningen på transport** og også **miljøpolitikken** i hver produsents land.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Det gis en **straff** til produkter som inneholder ingredienser som har betydelig **negativ innvirkning på biologisk mangfold og økosystemer**, som for eksempel palmeolje, hvis produksjon er ansvarlig for massiv avskoging.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Emballasje';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'En **straff** beregnes for å ta hensyn til **emballasjens sirkularitet** (bruk av resirkulert råmateriale og resirkulerbarhet) og overpakking.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'For å beregne Green-Score nøyaktig er det nødvendig med **informasjon som ikke nødvendigvis er spesifisert på emballasjen** (som opprinnelse og den nøyaktige prosentandelen av hver ingrediens) eller som sjelden er tilgjengelig i brukbar form (som en liste over alle komponentene i emballasjen med de nøyaktige plasttypene som brukes).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Gjennomsnittsverdier brukes når denne informasjonen ikke er tilgjengelig ennå**, men vi ber nå alle om å hjelpe oss med å samle inn denne informasjonen, som vil være svært nyttig for Green-Score, men også for mange andre bruksområder.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Hvordan kan innbyggere hjelpe?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Alle borgere kan hjelpe oss med å samle og strukturere informasjonen som finnes på produkter eller som kan utledes fra dem, for eksempel informasjon om **emballasje**: «Mission Emballages»: en storstilt samarbeidende inventarisering av emballasje for alle matvarer (på fransk).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Hvordan produsenter kan hjelpe';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Produsenter kan sende oss informasjon direkte gjennom vår gratis plattform for produsenter.';

  @override
  String get guide_greenscore_better_product_title =>
      'Hvilket produkt er bedre for planet?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Det kan være vanskelig å fortelle';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Å velge bærekraftig mat er en av de sterkeste tingene vi kan gjøre for klimaet, som **vårt globale matsystem har ansvar for over en fjerdedel av alle klimagassutslipp**.\n(Kilde: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Du har makten!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Den gode nyheten er at dette gir oss en sterk måte å lage en endring.\n**Hver av oss spiser rundt 1000 måltider hvert år. Det er 1000 muligheter til å **velge en bedre fremtid for planet**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Hjelper til å være ansvarlig og bestemme';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Å velge bærekraftig mat kan føle seg komplekse. Etiketter er forvirrende, og informasjonen mangler ofte. Grå-score ble laget for å gjøre det enkelt, noe som gir deg en **clear**, **science-based**, eller ikke**! og **gjennomsiktig** miljøvurdering for matvarer, akkurat der du trenger det: mens du butikken.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Gjennomsiktighet';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'I motsetning til proprietære merker, er beregningen av \"Green-Score **helt åpen\"** og kan **verifiseres av hvem som helst**.';

  @override
  String get guide_nova_title => 'Ultrabearbeidet mat';

  @override
  String get guide_nova_what_is_nova_title => 'Hva foregår ultra-prosessering?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA-gruppene informerer deg om nivået av matforedling.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA-klassifiseringen tillater kategorisering av matvarer i **fire grupper** basert på deres **grad av industriell bearbeiding** (minimalt bearbeidet eller ubearbeidet mat, kulinariske ingredienser, bearbeidet mat, ultrabearbeidet mat).';

  @override
  String get guide_nova_logos_caption => 'NOVA-logoene';

  @override
  String get guide_nova_groups_title => 'De 4 NOVA-gruppene';

  @override
  String get guide_nova_groups_intro =>
      'Det er fire NOVA-grupper, den problematiske er gruppe 4 – ultraprosessert mat.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimalt bearbeidet eller ubearbeidet mat';

  @override
  String get guide_nova_groups_arg1_text =>
      'Ubearbeidet (eller naturlig) mat er de **spiselige delene av planter** (frø, frukt, blader, stilker, røtter) **eller dyr** (muskler, innmat, egg, melk), samt sopp, alger og vann, etter å ha blitt separert fra naturen.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Bearbeidede kulinariske ingredienser';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Bearbeidet mat';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to Group 1** foods. processes include various preservation or cooking methods, and in the case of Breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified Versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultrabearbeidet mat';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with Little to no Intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, Oils, fats, or salt. however, ultra-processed products also contain other sources of energy and Nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Problemene med ultraprosessering';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Ekstrem bearbeiding av matingredienser';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Mange er **utvunnet fra videre bearbeiding av matbestanddeler**, som hydrogenerte eller interesterifiserte oljer, hydrolyserte proteiner, soyaproteinisolat, maltodekstrin, invertsukker og maissirup med høyt fruktoseinnhold.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Tilsetningsstoffer som går utover ren mattrygghet';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Tilsetningsstoffer i ultrabearbeidet mat inkluderer noen som også brukes i bearbeidet mat, for eksempel konserveringsmidler, antioksidanter og stabilisatorer. Klasser av tilsetningsstoffer som bare finnes i ultrabearbeidede produkter inkluderer de som brukes **for å imitere eller forbedre de sensoriske egenskapene til matvarer eller for å skjule usmakelige aspekter ved sluttproduktet**. Disse tilsetningsstoffene inkluderer fargestoffer og andre farger, fargestabilisatorer; smakstilsetninger, smaksforsterkere, ikke-sukkerholdige søtningsmidler; og prosesseringshjelpemidler som kullsyre-, fasthets-, fyllings- og antifylningsmidler, skumdempende, antiklumpe- og glaseringsmidler, emulgatorer, sekvestreringsmidler og fuktighetsbevarende midler.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Behandling du ikke kan gjøre hjemme';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**En rekke prosesssekvenser brukes** for å kombinere de vanligvis mange ingrediensene og for å lage sluttproduktet (derav «ultraprosessert»). Prosessene inkluderer flere **uten innenlandske ekvivalenter**, som hydrogenering og hydrolysering, ekstrudering og støping, og forbehandling for steking.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'De rovlystne og økonomiske aspektene ved ultraprosessering';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Det overordnede formålet med ultraprosessering er å skape merkevareprodukter som er **praktiske** (holdbare, klare til konsum), **attraktive** (hypervelsmakende) og **svært lønnsomme** (lavkostingredienser) og er utformet for å fortrenge alle andre matvaregrupper. Ultraprosesserte matvarer pakkes vanligvis attraktivt og markedsføres intensivt.**';

  @override
  String get guide_nova_explanations_arg5_title => 'En helsefare';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Siden 2018 har de første koblingene mellom **forbruk av ultraprosessert mat og økt risiko for kreft, hjerte- og karsykdommer og diabetes blitt fremhevet** med NutriNet-Santé. I dag bekrefter mer enn 90 studier over hele verden disse funnene.\nDe sterkeste assosiasjonene er knyttet til **fedme, hjerte- og kardødelighet og depressive symptomer**. Hos barn observeres effektene primært på vekt og lipidubalanser.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Land anbefaler å begrense dem';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Noen land bruker NOVA-gruppene for sine kostholdsretningslinjer eller -mål, for eksempel:\n\n- **🇧🇷 Brasils** kostholdsretningslinjer **anbefaler å begrense forbruket** av bearbeidet mat og unngå ultrabearbeidet mat.\n\n- **🇫🇷 Frankrikes** ernæringspolitiske mål for folkehelse for 2018–2022 har som mål å **redusere forbruket av ultrabearbeidet mat i gruppe 4 med 20 %**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Velkommen til Åpne matfakta!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Hva er Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts er en **samarbeidsbasert**, **gratis** og **åpen** database med matvarer fra hele verden.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Vi mener at alle bør ha tilgang til informasjon om hva de spiser. Ved å samle inn data om ingredienser, allergener, næringsinnhold og mer, **gir vi forbrukerne mulighet til å ta informerte valg** og driver matindustrien **mot større åpenhet**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Funksjoner ved Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Få varsler om uønskede ingredienser';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for å ta flotte bilder';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Ikke gjør';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Unngå skygger og gjenskinn.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Ingen uskarp eller uskarp tekst.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Ikke beskjær ut deler av teksten.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Unngå travle bakgrunner.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Gjør-det-selv';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Bruk god, jevn belysning.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Sørg for at teksten er skarp og lesbar.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Ta opp hele ingredienslisten.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Oppbevar produktet på en flat overflate.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Hjelp oss å bygge «Matens Wikipedia»';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'En poengsum på næringskvaliteten';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'En poengsum for å unngå ultraprosessert mat';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'En poengsum for planeten';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-nb.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Velkommen til Åpne fakta om kjæledyrmat!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Hva er åpne fakta om kjæledyrfôr?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts utvider vårt oppdrag til våre pelskledde venner! Det er en **database med kjæledyrfôrprodukter for katter, hunder og andre følgesvenner**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Vi samler informasjon om **ingredienser**, **ernæringsanalyse** og fôringsretningslinjer for å hjelpe dyreeiere med å velge det beste fôret for dyrenes behov.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Funksjoner ved åpne kjæledyrfôrfakta';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Få varsler om uønskede ingredienser';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Er kjæledyret ditt allergisk mot noen ingredienser? Du kan sette opp en liste over kosmetiske ingredienser du bør unngå, rett i appen!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for å ta flotte bilder';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Ikke gjør';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Unngå skygger og gjenskinn.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Ingen uskarp eller uskarp tekst.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Ikke beskjær ut deler av teksten.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Unngå travle bakgrunner.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Gjør-det-selv';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Bruk god, jevn belysning.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Sørg for at teksten er skarp og lesbar.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Ta opp hele ingredienslisten.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Oppbevar produktet på en flat overflate.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'En merknad om poengberegning';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Å utvikle et poengsystem for kjæledyrfôr **er ikke en prioritet akkurat nå**. Metodikken ville være kompleks, ettersom ernæringsbehovene varierer sterkt etter art, alder og helsetilstand. Vi har ennå ikke funnet noe uavhengig vitenskapelig team som er i stand til å utvikle en slik poengsum.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-nb.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Velkommen til Åpne skjønnhetsfakta!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Hva er åpne skjønnhetsfakta?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts er en samarbeidende database med **kosmetikkprodukter**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Målet vårt er å tyde ingredienslister for å hjelpe deg med å **forstå hva som finnes i dine personlige pleieprodukter**. Fra fuktighetskremer til sminke samler vi inn data om ingredienser, allergener og emballasje for å fremme åpenhet i kosmetikkindustrien.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Funksjoner ved åpne skjønnhetsfakta';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Få varsler om uønskede ingredienser';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Er du allergisk mot noen ingredienser? Vil du unngå komedogene stoffer? Vil du unngå kontroversielle komponenter? Du kan angi en liste over kosmetiske ingredienser du vil unngå, rett i appen!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for å ta flotte bilder';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Ikke gjør';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Unngå skygger og gjenskinn.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Ingen uskarp eller uskarp tekst.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Ikke beskjær ut deler av teksten.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Unngå travle bakgrunner.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Gjør-det-selv';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Bruk god, jevn belysning.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Sørg for at teksten er skarp og lesbar.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Ta opp hele ingredienslisten.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Ta så mange bilder som nødvendig hvis flasken er buet.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Du må kanskje rive av etiketten for å se ingredienslisten.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Oppbevar produktet på en flat overflate.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'En merknad om poengberegning';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'I motsetning til matvarer har ikke kosmetikkverdenen et universelt anerkjent, myndighetsstøttet poengsystem som Nutri-Score. Ingrediensenes effekt kan være svært personlig og avhenge av hudtype, allergier og individuelle bekymringer.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-nb.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices er et prosjekt for å **samle inn og dele priser på produkter over hele verden**. Det er et offentlig tilgjengelig datasett som kan brukes til forskning, analyse og mer. Open Prices er utviklet og vedlikeholdt av Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'Hvordan fungerer Open Prices?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Vi bruker crowdsourcing til å finne et åpen kildekode-datasett med priser.** Priser kan legges til av brukere via denne nettappen eller via den offisielle Open Food Facts-mobilappen. Forhandlere eller tredjepartsapper kan også bidra ved å bruke API-et vårt.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Samle bilder av prislapper i gangene';

  @override
  String get guide_open_prices_how_arg2_title => 'Samle bilder av kvitteringer';

  @override
  String get guide_open_prices_why_title =>
      'Hvorfor gjør Open Food Facts dette?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Prisinformasjon er av største betydning for å forstå matsystemer. Det er en nøkkelfaktor for å forstå kostnadene ved mat og for å fremme sunnere kosthold. Å åpne prisdata er en måte å gjøre det enklere for forskere, journalister og innbyggere å **få en bedre forståelse av hvordan matprisene varierer geografisk og over tid**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Spor prisutviklingen over tid';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Se **prisutviklingen**: krympeinflasjon, billiginflasjon, vi kan spore dem sammen!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Sammenlign priser i nærheten av deg';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Etter hvert som vi får flere priser, kan du finne **de billigste butikkene i nærheten**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Har du vurdert å hente priser fra forhandlernes nettsider?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Av juridiske og tekniske årsaker **anser vi ikke det å hente priser fra forhandlernes nettsteder som en gyldig måte å bidra til Open Prices**. Vi ønsker å sørge for at prisene vi samler inn er nøyaktige og oppdaterte, og det å motta hentede priser fra bidragsytere tillater oss ikke å gjøre det.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Prisskraping er et vurdert alternativ i en fremtidig versjon av Open Prices, men det vil bli gjort av Open Prices selv, slik at vi kan ha et bevis på prisen basert på HTML-siden.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Du kan bidra med priser ved å bruke API-et vårt.\nHvis du ønsker å bidra med priser i stor skala, kan du ta kontakt med oss på prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Velkommen til fakta om åpne produkter!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Hva er fakta om åpne produkter?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts er en massiv, åpen database for **alle produkter med strekkode, som ikke er mat, kosmetikk eller dyrefôr**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Fra **elektronikk** til **leker**, og **klær** til **rengjøringsartikler**, hvis det har en strekkode, kan det legges til. Dette prosjektet har som mål å skape et «tingenes internett» for hverdagsgjenstander, og gjøre informasjon om dem universelt tilgjengelig.';

  @override
  String get guide_open_products_facts_features_title =>
      'Funksjoner i åpne produktfakta';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts har som mål å gi forbrukere muligheten til å **forlenge levetiden til gjenstander** ved å tilby sirkulære løsninger for å vedlikeholde, **reparere**, **resirkulere** gjenstandene sine eller gi dem en ny eier.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Karbonavtrykk for noen produkter';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**CO2-påvirkning** fra den franske miljømyndigheten ADEME gir **karbonpåvirkningen** for mange kategorier. Sørg for å kategorisere produktene nøyaktig.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparasjonsindeks for mange produkter';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Når en fransk reparerbarhetsindeks er tilgjengelig, viser vi den. Dessuten **kan du begynne å samle inn variablene ved hjelp av Folksonomy Engine**, slik at vi kan beregne den på nytt selv i fremtiden, selv i land der den ikke er tilgjengelig.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Finn måter å donere/videreselge produktet ditt på';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Vi tilbyr lenker til **tredjeparts sirkulærvennlige tjenester** som hjelper deg med å få den typen produkt du leter etter, som et bruktprodukt, for å være mer skånsom mot planetens ressurser.\nMerk at vi ikke får betalt for å gjøre det, og at systemet bare fungerer som et eksempel for to nettsteder i Frankrike. Du kan bidra til å utvide dette systemet ved å dokumentere flere nettsteder på wikien.';

  @override
  String get guide_open_products_facts_information_title =>
      'Hvilken informasjon er nyttig?';

  @override
  String get guide_open_products_facts_information_text =>
      'For et så bredt spekter av elementer er **dataene vi samler inn fleksible**. For å gjøre det har **vi laget Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'Folksonomi-motoren';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy-motoren er et verktøy som hjelper deg med å fullføre produkter med relevante egenskaper. Dette bidrar til å forbedre søk og synlighet, men også beregne og vise interessante ting i fremtiden.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Du kan legge til hvilke som helst nøkler og verdier som: **kompatibilitet_med_5G_mobilnettverk: ja**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Du får automatiske forslag til mulige egenskaper, og du er hjertelig velkommen til å legge til og dokumentere nye på dine favorittprodukter.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-nb.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Åpne matpreferanser';

  @override
  String get guide_coming_soon_button_title => 'Kommer snart';

  @override
  String get guide_learn_more_subtitle => 'Trykk for å finne ut mer';

  @override
  String get preview_badge => 'Forhåndsvisning';

  @override
  String get prices_feedback_form =>
      'Klikk her for å sende oss din tilbakemelding om denne nye funksjonen!';

  @override
  String get menu_button_list_actions => 'Velg en handling';

  @override
  String get error_loading_photo => 'Feil ved lasting av bilde';

  @override
  String get photo_viewer_action_use_picture_as => 'Bruk som…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Bruk dette bildet som…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Bruk dette bildet som… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Detaljer';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Detaljer om dette bildet';

  @override
  String get photo_viewer_details_title => 'Detaljer om bildet';

  @override
  String get photo_viewer_details_contributor_title => 'Bidrager';

  @override
  String get photo_viewer_details_size_title => 'Størrelse';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height piksler';
  }

  @override
  String get photo_viewer_details_date_title => 'Dato';

  @override
  String get photo_viewer_details_url_title => 'URL-adresse';

  @override
  String get product_page_compatibility_score => 'Kompatibel';

  @override
  String get user_lists_action_multi_select => 'Flervalg';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Din kompatibilitetspoengsum: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Frontbilde';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Bilde av ingredienser';

  @override
  String get product_image_nutrition_accessibility_label => 'Ernæringsbilde';

  @override
  String get product_image_packaging_accessibility_label => 'Emballasjebilde';

  @override
  String get product_image_other_accessibility_label => 'Annet bilde';

  @override
  String get product_image_outdated_message => 'Dette bildet kan være utdatert';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (dette bildet kan være utdatert)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (dette bildet kan være låst av produsenten)';
  }

  @override
  String get product_image_error => 'Klarte ikke å laste inn bildet!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Kan ikke laste inn $type (nettverksfeil?)';
  }

  @override
  String get product_page_image_no_image_available => 'Ikke noe\nbilde!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Ingen bilder tilgjengelig for dette produktet';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Endre rekkefølgen på eller skjul handlinger';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Rediger handlinger';

  @override
  String get product_page_action_bar_item_move_up => 'Flytt opp';

  @override
  String get product_page_action_bar_item_move_down => 'Flytt ned';

  @override
  String get product_page_action_bar_item_enable => 'Aktiver handling';

  @override
  String get product_page_action_bar_item_disable => 'Deaktiver handling';

  @override
  String get product_page_pending_operations_banner_title =>
      'Laster opp redigeringene dine…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Dataene som vises på denne siden **gjenspeiler ikke endringene dine ennå**.\nVent noen sekunder…';

  @override
  String get product_add_a_language => 'Legg til et språk';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Strekkode $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Fjern dette produktet fra karusellen';

  @override
  String get carousel_unsupported_header => 'Ustøttet strekkode!';

  @override
  String get carousel_unsupported_title => 'Ups!';

  @override
  String get carousel_unsupported_text =>
      'Strekkoden som skannes støttes ikke av Open Food Facts!';

  @override
  String get carousel_error_header => 'Feil!';

  @override
  String get carousel_error_title => 'Det er kjipt!';

  @override
  String get carousel_error_text_1 =>
      'Vi kunne ikke laste ned informasjon om denne strekkoden:';

  @override
  String get carousel_error_text_2 =>
      'Sjekk internettforbindelsen din, eller klikk på denne knappen:';

  @override
  String get carousel_error_button => 'Prøv på nytt';

  @override
  String get carousel_unknown_product_header => 'Ukjent produkt';

  @override
  String get carousel_unknown_product_title =>
      'Gratulerer!\nDu har funnet __den sjeldne juvelen!__';

  @override
  String get carousel_unknown_product_text =>
      'Vår samarbeidsdatabase inneholder mer enn **3 millioner produkter**, men denne strekkoden finnes ikke: ';

  @override
  String get carousel_unknown_product_button => 'Legg til dette produktet';

  @override
  String get carousel_loading_header => 'Laster inn informasjon ...';

  @override
  String get carousel_loading_title =>
      'Du har nettopp skannet et produkt med følgende strekkode:';

  @override
  String get carousel_loading_text =>
      'Vi søker etter det i databasen vår med mer enn **3 millioner produkter!**';

  @override
  String get product_type_subtitle_food => 'Grønnsaker, frukt, frossenmat…';

  @override
  String get product_type_subtitle_beauty => 'Sminke, såper, tannkremer…';

  @override
  String get product_type_subtitle_pet_food => 'Mat til hunder og katter…';

  @override
  String get product_type_subtitle_product => 'Smarttelefoner, møbler…';

  @override
  String get photo_field_front => 'Produktbilde';

  @override
  String get photo_field_ingredients => 'Ingredienser bilde';

  @override
  String get photo_field_nutrition => 'Næringsinnholdsbilde';

  @override
  String get photo_field_packaging => 'Instruksjoner for resirkulering, bilde';

  @override
  String get photo_already_exists => 'Dette bildet finnes allerede';

  @override
  String get photo_missing => 'Dette bildet mangler';

  @override
  String get date => 'Dato';

  @override
  String get photo_rotate_left => 'Roter mot venstre';

  @override
  String get photo_rotate_right => 'Roter mot høyre';

  @override
  String get photo_undo_action => 'Angre forrige handling';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Et verdenskart over $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap-bidragsytere';

  @override
  String get not_applicable_short => 'Ikke aktuelt';

  @override
  String get knowledge_panel_warning_text => 'Advarsel';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Hvorfor er denne næringsverdien forskjellig fra den på pakken?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Det er to mulige forklaringer:\nListen over ingredienser og/eller næringsinnholdet er ikke oppdatert.\n\nVi tilbyr den «nye beregningen» av Nutri-Score (eller V2). Sjekk at du har banneret «Ny beregning» på pakken.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Sjekk ingrediensene';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Sjekk næringsinnholdet';

  @override
  String url_not_supported(String url) {
    return 'Dessverre kan vi ikke åpne URL-en:\n$url';
  }

  @override
  String get product_list_export => 'Eksport';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'Vis strekkode';

  @override
  String get product_footer_action_barcode_short => 'Strekkode';

  @override
  String get product_footer_action_open_website => 'Åpne nettsiden';

  @override
  String get product_footer_action_report => 'Rapportere';

  @override
  String get product_footer_action_contributor_guide => 'Hjelp';

  @override
  String get product_footer_action_data_quality_tags => 'Datakvalitet';

  @override
  String get product_page_tab_for_me => 'For meg';

  @override
  String get product_page_tab_website => 'Nettsted';

  @override
  String get product_page_tab_prices => 'Priser';

  @override
  String get prices_explanation_card_title => 'Hvorfor priser?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** er et prosjekt for å samle og dele priser på produkter rundt om i verden 🌍. Open Prices utvikles og vedlikeholdes av Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Lær mer';

  @override
  String get product_page_tab_folksonomy => 'Folkesonomi';

  @override
  String get folksonomy_explanation_card_title =>
      'Hva er Folksonomi attributter?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Attributter er **nøkkelverdi** basert.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Eiendommene lages og deles av bidragsytere for alle typer bruk.';

  @override
  String get folksonomy_action_external_link_title => 'Åpne ekstern lenke';

  @override
  String get folksonomy_action_external_link_warning =>
      'Eksterne lenker kan være utrygge. Vil du virkelig besøke dem?';

  @override
  String get prices_products_empty_title => 'Ingen pris tilgjengelig';

  @override
  String get prices_products_empty_explanation => 'Bli den første til å bidra!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Topp $pageSize produkter (totalt: $total)';
  }

  @override
  String get app_review_title => 'Liker du denne appen?';

  @override
  String get app_review_low => 'Kunne gjort det bedre';

  @override
  String get app_review_medium => 'Ikke dårlig';

  @override
  String get app_review_high => 'Jeg elsker det!';

  @override
  String get app_review_feedback_modal_title =>
      'Hjelp oss med å forbedre applikasjonen vår';

  @override
  String get app_review_feedback_modal_content =>
      'Hvis du har noen minutter, kan du svare på dette skjemaet slik at **vi kan forbedre oss i fremtidige oppdateringer**:';

  @override
  String get app_review_feedback_modal_open_form => 'Svar på skjemaet';

  @override
  String get app_review_feedback_modal_later => 'Spør meg senere';

  @override
  String get nutrition_facts_extract_new =>
      'NYTT: Du kan automatisk trekke ut næringsstoffene fra bildet!';

  @override
  String get nutrition_facts_extract_button_text => 'Uttrekk nå';

  @override
  String get nutrition_facts_extract_in_progress => 'Uttrekking pågår…';

  @override
  String get nutrition_facts_extract_successful => 'Utpakking vellykket';

  @override
  String get nutrition_facts_extract_failed =>
      'Klarte ikke å hente ut næringsstoffer fra bildet';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Statistikk';

  @override
  String get prices_stats_title => 'Prisstatistikk';

  @override
  String get prices_stats_prices_section => 'Priser';

  @override
  String get prices_stats_products_section => 'Produkter';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Bidragsytere';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Diverse';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Forbruk';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Mat';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Produkter';

  @override
  String get prices_stats_pet_food => 'Kjæledyrfôr';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Land';

  @override
  String get prices_stats_price_tag => 'Prislapp';

  @override
  String get prices_stats_receipt => 'Kvittering';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Nettsted';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API-en';

  @override
  String get prices_stats_other => 'Andre';

  @override
  String get prices_stats_last_updated => 'Sist oppdatert';

  @override
  String get prices_stats_error =>
      'Det oppsto en feil under lasting av statistikk.';

  @override
  String get product_edit_robotoff_question_answered =>
      'Spørsmålet er besvart!';

  @override
  String get product_edit_robotoff_proof => 'Bevis';

  @override
  String get preferences_card_general => 'Generelt';

  @override
  String get preferences_prices_title => 'Priser';

  @override
  String get preferences_prices_subtitle =>
      'Administrer prisinnstillingene dine';

  @override
  String get preferences_card_project => 'Prosjektet Open Food Facts';

  @override
  String get preferences_contribute_title => 'Bidra';

  @override
  String get preferences_my_contributions_title => 'Mine bidrag';

  @override
  String get preferences_my_stats_title => 'Min statistikk';

  @override
  String get preferences_contribute_subtitle =>
      'Oversett, forbedre våre verktøy…';

  @override
  String get preferences_connect_title => 'Nettverk';

  @override
  String get preferences_connect_subtitle =>
      'Gå ut eller følg oss på sosiale medier';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Hjelp oss å informere millioner av forbrukere verden rundt';

  @override
  String get preferences_card_help => 'Hjelp & Støtte';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle => 'Få svar på dine spørsmål';

  @override
  String get logged_out => 'Logget av';

  @override
  String get preferences_app_bar_message =>
      'Takk for at du er en av medlemmene vår!';

  @override
  String get preferences_app_bar_products_modified => 'Produkter endret';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Se all statistikk';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Søk $provider etter \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Søk etter innstillinger (f.eks. nøtt-resultat)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Tilgjengelighet: Vis emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Tilgjengelighet: Fjern farger';

  @override
  String get preferences_app_settings_products => 'Produkter';

  @override
  String get preferences_card_about => 'Om';

  @override
  String get preferences_legal_information_title => 'Juridisk informasjon';

  @override
  String get preferences_legal_information_subtitle =>
      'Vilkår for bruk, personvern og mer';

  @override
  String get preferences_terms_of_use => 'Bruksvilkår';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts er en matprodukter database **laget av alle, for alle**.\ndu kan bruke det til å bedre matfatninger og fordi det er **åpne data**, alle kan **bruke det til andre formål**.';

  @override
  String get preferences_privacy_policy => 'Personvernerklæring';

  @override
  String get preferences_licenses => 'Lisenser';

  @override
  String get preferences_about_app_title => 'Om appen';

  @override
  String get preferences_about_app_subtitle =>
      'Teknisk informasjon, utviklerinformasjon og mer';

  @override
  String get preferences_card_information => 'Informasjon';

  @override
  String get preferences_version_number_title => 'Versjonsnummer';

  @override
  String get preferences_scanner_title => 'Skanner';

  @override
  String get preferences_app_store => 'App butikk';

  @override
  String get preferences_app_system_settings => 'System innstillinger';

  @override
  String get preferences_source_code => 'Få tilgang til kildekoden';

  @override
  String get preferences_source_code_subtitle =>
      'Og ha betydning for millioner';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Ferdigstill produkter';

  @override
  String get preferences_tips => 'Tips';

  @override
  String get tips_discover_nutriscore => 'Oppdag den nye Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'På nettsiden Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Administrere min kundekonto';

  @override
  String get preferences_manage_account_tooltip => 'Administrer kontoen din';

  @override
  String get preferences_change_password_title => 'Endre passordet mitt';

  @override
  String get preferences_danger_zone => 'Fare sone';

  @override
  String get preferences_account_deletion_subtitle =>
      'Alle dine bidrag vil gå tapt';

  @override
  String get preferences_contributions_title => 'Bidrag';

  @override
  String get preferences_dev_mode_app_settings_title => 'Innstillinger for app';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Veldig eksperimentell måte å skanne produkter frakoblet';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Oppdater alle produktene fra serveren';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Vennligst unngå å gjøre dette med mindre det er absolutt nødvendig';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demo modus';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Legg til oppgavelapper som skanner';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Legger til 3 eksempelprodukter til skanneren';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'Folksonomi vert';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Vert: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Eksperimenter for tilgjengelighet';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Valg av flere produkter for priser';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Bruker bestilte kunnskapspaneler';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Midlertidig tilgang til posisjonssøk';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Side ved sammenligning for 2 eller 3 produkter';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Import av produktliste';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Poengpoeng & metoder';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Oppdag hvordan Nutri-Score beregnes';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Oppdag de viktigste endringene i metoden';

  @override
  String get preferences_faq_discover_project_title => 'Utforsk prosjektet';

  @override
  String get preferences_faq_discover_off_title => 'Oppdag Open Food Facts';

  @override
  String get preferences_faq_discover_obf_title => 'Oppdag Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Oppdag Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Oppdag Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Oppdag fakta om åpne produkter';

  @override
  String get preferences_faq_faq_title => 'FAQ - Ofte stilte spørsmål';

  @override
  String get preferences_faq_off_ngo_title => 'The Open Food Facts NGO';

  @override
  String get preferences_about_information_title => 'Informasjon';

  @override
  String get preferences_connect_community_updates_title =>
      'Få oppdateringer i nettsamfunnet';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Hold deg i løkken med app og samfunnet nyheter';

  @override
  String get preferences_connect_community_calendar_title =>
      'Abonner på vår fellesskapskalender';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Bli involvert i å delta på en av våre virtuelle hendelser';

  @override
  String get preferences_connect_blog_title => 'The Open Food Facts blogog';

  @override
  String get preferences_connect_blog_subtitle =>
      'Få de siste nyhetene, når de skjer';

  @override
  String get preferences_connect_community_help_title =>
      'Få hjelp fra fellesskapet';

  @override
  String get preferences_connect_improve_app_title =>
      'Hjelp oss med å forbedre appen';

  @override
  String get preferences_connect_debug_info_title =>
      'Send oss debug-informasjon';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Send oss en epost med detaljert feilsøkingsinformasjon';

  @override
  String get preferences_connect_feedback_title =>
      'Send oss en tilbakemelding om appen';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Hjelp oss å forme fremtiden til appen';

  @override
  String get preferences_connect_survey_title => 'Benytt app-undersøkelsen';

  @override
  String get preferences_connect_survey_subtitle =>
      'Hjelp oss å forstå hva vi skal bygge neste';

  @override
  String get preferences_connect_professionals_title => 'Fagperson';

  @override
  String get preferences_connect_pro_subtitle =>
      'Helt gratis, sikrer nøyaktige data for 500 apper og millioner av forbrukere. Selv-service, kompatible med PIM eller regneark (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Ta kontakt for å komme i gang';

  @override
  String get preferences_connect_press_title => 'Presse';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Få alt materialet du trenger for rapporten din';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Ta kontakt for pressehenvendelser eller for å gi oss beskjed om din rapport';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Bli en aktiv frivillig';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Utvikling, Kommunikasjon, Design… alle typer frivillige eller fagkyndige er velkommen!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Oppdag noen av de mange måtene du kan bidra med';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Utvikling av Mobile apper';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Lær å bidra til programvareutvikling';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Daglige ustabile bygg, helt nye funksjoner';

  @override
  String get preferences_contribute_local_community_title =>
      'Øk lokalsamfunnet ditt';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Hjelp med programvare, innhold, ingrediens analyse oversettelser';

  @override
  String get preferences_contribute_share_subtitle =>
      'Vi har utarbeidet en liten mal for å hjelpe deg :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Enkle skritt for å øke åpenhet om mat i landet ditt';

  @override
  String get preferences_contribute_data_quality_title => 'Datakvalitet';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Bli med i datakvalitetsteamet';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Delta i vårt arbeid for å sikre at databasen er komplett og nøyaktig';

  @override
  String get preferences_contributions_products_added_title =>
      'Lagt til produkter';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nye produkter jeg har lagt til i Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produkter jeg må fullføre';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Alle ufullstendige produkter';

  @override
  String get preferences_my_contributions_prices_title => 'Priser';

  @override
  String get preferences_my_contributions_my_prices_title => 'Mine priser';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Mine priser, mine bevis…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produkter du kan hjelpe til med å fullføre';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Hjelp til å beregne Nutri-Score & Green-Score i ditt land';

  @override
  String get preferences_prices_user_prices_subtitle => 'Prisene jeg bidro';

  @override
  String get preferences_prices_proofs_subtitle => 'Pristagger og kvitteringer';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Ta bilder av kvitteringene og skanne tilknyttede strekkoder';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Ta bilder av priser i en butikk';

  @override
  String get preferences_prices_newest_title => 'Nyeste priser';

  @override
  String get preferences_prices_newest_subtitle =>
      'Siste priser lagt til i Open Prices samfunnet';

  @override
  String get preferences_prices_top_contributors_title =>
      'Bidragsytere med flest priser';

  @override
  String get preferences_prices_metrics_title => 'Åpne prismålere';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Følg utviklingen av prosjektet';

  @override
  String get preferences_prices_ways_contribute_title => 'Måter å bidra';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Bekrefte priser lagt til av deg selv eller andre, ved hjelp av AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Raskt legge til mange kvitteringer eller bilder på hyller fra ditt kamera rulle';

  @override
  String get preferences_prices_challenges_title => 'Månedlige utfordringer';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Delta i månedlige temakunnskaper for å samle priser';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Gjenvinne dine lojalitetsdata';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Lær hvordan du ber om dataene dine';

  @override
  String get preferences_page_customize_app_title => 'Tilpass appen';

  @override
  String get preferences_page_contribute_project_title =>
      'Bidra til prosjektet';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Enkle måter å hjelpe Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Score metoder, hjelp og mer om prosjektet';

  @override
  String get product_edit_robotoff_positive_button => 'Godta forslag';

  @override
  String get product_edit_robotoff_negative_button => 'Avvis forslag';

  @override
  String get product_edit_robotoff_show_proof => 'Vis bevis';

  @override
  String get product_edit_robotoff_expand_proof => 'Utvid bevis';

  @override
  String get product_page_tab_raw_data => 'Rå data';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Side $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Side $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count av $total objekter';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count av $total objekter';
  }

  @override
  String item_count(int count) {
    return '$count objekter';
  }

  @override
  String item_count_string(String count) {
    return '$count objekter';
  }

  @override
  String get prices_no_result => 'Ingen statistikk over priser funnet.';

  @override
  String get prices_error_loading_more_items =>
      'Feil ved lasting av flere elementer';

  @override
  String get prices_proof_error =>
      'Autentisering mislyktes, ugyldig å hente bekreftelser';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count av $total bevis';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count av $total bidragsytere';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count av $total steder';
  }

  @override
  String prices_locations_count(int count) {
    return '$count lokasjoner';
  }

  @override
  String get restart_to_apply_message =>
      'Start appen på nytt for å bruke endringene.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafisk grensesnitt';

  @override
  String get preferences_app_settings_media_title => 'Medier';

  @override
  String get preferences_about_app_development_title => 'Utvikling';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Open Food Facts Labs';

  @override
  String get preferences_root_account_title => 'Konto';

  @override
  String get preferences_contribute_translate_header =>
      'Bring Open Food Facts til ditt språk';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Registrer i alpha-versjonen av appen';

  @override
  String get preferences_dev_mode_section_data => 'Bidrag & produktdata';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Ikke vis Folksonomi';

  @override
  String get preferences_account_title => 'Konto';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Lagt til $created';
  }

  @override
  String get location_map_details_title => 'Stedsdetaljer';

  @override
  String get location_map_details_name => 'Navn';

  @override
  String get location_map_details_street => 'Gate';

  @override
  String get location_map_details_city => 'By';

  @override
  String get location_map_details_postcode => 'Postnummer';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Koordinater';

  @override
  String get location_map_details_osm_id => 'OSM-ID';
}
