// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Malay (`ms`).
class AppLocalizationsMs extends AppLocalizations {
  AppLocalizationsMs([String locale = 'ms']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Ya';

  @override
  String get add => 'Tambah';

  @override
  String get account_delete_message =>
      'Adakah anda pasti mahu memadamkan akaun anda?\nJika terdapat sebab tertentu, sila kongsikan di bawah';

  @override
  String get reason => 'Sebab';

  @override
  String get okay => 'Okey';

  @override
  String get validate => 'Tentusahkan';

  @override
  String get create => 'Cipta';

  @override
  String get applyButtonText => 'Memohon';

  @override
  String get next_label => 'Seterusnya';

  @override
  String get continue_label => 'Teruskan';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Terdahulu';

  @override
  String get go_back_to_top => 'Kembali ke atas';

  @override
  String get save => 'Simpan';

  @override
  String get save_confirmation => 'Adakah anda pasti anda mahu simpan?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Cancel';

  @override
  String get ignore => 'Abaikan';

  @override
  String get close => 'Tutup';

  @override
  String get no => 'Tidak';

  @override
  String get stop => 'Berhenti';

  @override
  String get finish => 'Selesai';

  @override
  String get calculate => 'Kira';

  @override
  String get reset_food_prefs => 'Tetapkan semula pilihan makanan';

  @override
  String get error => 'Ada yang tidak kena';

  @override
  String get error_occurred => 'Ralat berlaku';

  @override
  String get featureInProgress => 'Kami masih mengusahakan ciri ini, nantikan';

  @override
  String get label_web => 'Lihat di web';

  @override
  String get learnMore => 'Ketahui lebih lanjut';

  @override
  String get unknown => 'Tidak diketahui';

  @override
  String get match_very_good => 'Padanan yang sangat baik';

  @override
  String get match_good => 'Padanan yang baik';

  @override
  String get match_poor => 'Padanan yang lemah';

  @override
  String get match_may_not => 'May not match';

  @override
  String get match_does_not => 'Tidak sepadan';

  @override
  String get match_unknown => 'Padanan yang tidak diketahui';

  @override
  String get match_short_very_good => 'Padanan yang sangat baik';

  @override
  String get match_short_good => 'Padanan yang baik';

  @override
  String get match_short_poor => 'Padanan yang lemah';

  @override
  String get match_short_may_not => 'May not match';

  @override
  String get match_short_does_not => 'Tidak sepadan';

  @override
  String get match_short_unknown => 'Padanan yang tidak diketahui';

  @override
  String get licenses => 'Lesen';

  @override
  String get looking_for => 'Sedang mencari';

  @override
  String get welcomeToOpenFoodFacts =>
      'Selamat datang ke Fakta Makanan Terbuka';

  @override
  String get whatIsOff =>
      'Open Food Facts ialah sebuah pertubuhan bukan berasaskan keuntungan global yang dikuasakan oleh komuniti tempatan.';

  @override
  String get productDataUtility =>
      'Lihat data makanan yang berkaitan dengan pilihan anda.';

  @override
  String get healthCardUtility => 'Pilih makanan yang baik untuk anda.';

  @override
  String get ecoCardUtility => 'Pilih makanan yang baik untuk planet.';

  @override
  String get server_error_open_new_issue =>
      'Tiada respons pelayan! Anda mungkin menghadapi masalah dengan pautan berikut.';

  @override
  String get sign_in_text =>
      'Log masuk ke akaun Fakta Makanan Terbuka anda untuk menyimpan sumbangan anda';

  @override
  String get incorrect_credentials => 'Nama pengguna atau kata laluan salah.';

  @override
  String get password_lost_incorrect_credentials =>
      'E-mel atau nama pengguna ini tidak wujud. Sila semak kelayakan anda.';

  @override
  String get password_lost_server_unavailable =>
      'Kami sedang mengalami kelembapan pada pelayan kami dan kami memohon maaf atasnya. Sila cuba lagi nanti.';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable =>
      'Rangkaian tidak dapat dicapai';

  @override
  String get login_result_type_server_issue =>
      'Masalah pada pelayan. Sila cuba kemudian.';

  @override
  String get login_page_username_or_email =>
      'Sila masukkan nama pengguna atau e-mel';

  @override
  String get login_page_password_error_empty => 'Sila masukkan kata laluan';

  @override
  String get create_account => 'Buat akaun';

  @override
  String get sign_in => 'Daftar masuk';

  @override
  String get sign_in_mandatory =>
      'Untuk ciri tersebut, kami memerlukan anda log masuk.';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'Daftar keluar';

  @override
  String get sign_out_confirmation => 'Adakah anda pasti untuk log keluar?';

  @override
  String get password => 'Kata laluan';

  @override
  String get forgot_password => 'Lupa kata laluan';

  @override
  String get forgot_password_question => 'Lupa kata laluan?';

  @override
  String get view_profile => 'Lihat profil';

  @override
  String get reset_password => 'Tetapkan semula kata laluan';

  @override
  String get reset_password_explanation_text =>
      'Dalam kes telah terlupa kata laluan, masukkan nama pengguna atau alamat e-mel anda untuk menerima arahan untuk menetapkan semula kata laluan. Juga, ingat supaya menyemak folder Spam.';

  @override
  String get username_or_email => 'Nama pengguna atau e-mel';

  @override
  String get reset_password_done =>
      'E-mel dengan pautan untuk menetapkan semula kata laluan anda telah dihantar ke alamat e-mel yang dikaitkan dengan akaun anda. Semak juga spam anda';

  @override
  String get send_reset_password_mail => 'Tukar kata laluan';

  @override
  String get enter_some_text => 'Sila masukkan sedikit teks';

  @override
  String get sign_up_page_title => 'Daftar';

  @override
  String get sign_up_page_action_button => 'Daftar';

  @override
  String get sign_up_page_action_doing_it => 'Mendaftar…';

  @override
  String get sign_up_page_action_ok =>
      'Tahniah! Akaun anda baru sahaja dibuat.';

  @override
  String get sign_up_page_display_name_hint => 'Nama';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Sila masukkan nama paparan yang ingin anda gunakan';

  @override
  String get sign_up_page_email_hint => 'E-mel';

  @override
  String get sign_up_page_email_error_empty => 'E-mel diperlukan';

  @override
  String get sign_up_page_email_error_invalid => 'E-mel tidak sah';

  @override
  String get sign_up_page_username_hint =>
      'Nama pengguna: Boleh dilihat secara umum';

  @override
  String get sign_up_page_username_error_empty => 'Sila masukkan nama pengguna';

  @override
  String get sign_up_page_username_error_invalid =>
      'Sila masukkan nama pengguna yang sah';

  @override
  String get sign_up_page_username_description =>
      'Username cannot contains spaces, caps or special characters.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Nama pengguna tidak boleh melebihi aksara $value';
  }

  @override
  String get sign_up_page_password_hint => 'Kata laluan';

  @override
  String get sign_up_page_password_error_empty => 'Sila masukkan kata laluan';

  @override
  String get sign_up_page_password_error_invalid =>
      'Sila masukkan kata laluan yang sah (sekurang-kurangnya 6 aksara)';

  @override
  String get sign_up_page_confirm_password_hint => 'Sahkan Kata Laluan';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Sila sahkan kata laluan';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Kata laluan tidak sepadan';

  @override
  String get sign_up_page_agree_text =>
      'Saya bersetuju dengan Fakta Makanan Terbuka';

  @override
  String get sign_up_page_terms_text => 'syarat penggunaan dan sumbangan';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Semasa membuat akaun, bersetuju dengan Syarat Penggunaan adalah wajib, namun, sumbangan tanpa nama masih boleh dibuat melalui aplikasi';

  @override
  String get sign_up_page_producer_checkbox => 'Saya seorang pengeluar makanan';

  @override
  String get sign_up_page_producer_hint => 'Pengeluar/jenama';

  @override
  String get sign_up_page_producer_error_empty =>
      'Sila masukkan pengeluar atau nama jenama';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Saya ingin melanggan surat berita Open Food Facts (Anda boleh berhenti melanggannya pada bila-bila masa)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Nama pengguna sudah wujud, sila pilih nama pengguna lain.';

  @override
  String get sign_up_page_email_already_exists =>
      'sudah wujud, log masuk ke akaun atau cuba dengan e-mel lain.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Sila berikan alamat e-mel yang sah.';

  @override
  String get sign_up_page_server_busy =>
      'Kami amat memohon maaf, kami mengalami sedikit masalah teknikal untuk membuat akaun anda. Sila cuba lagi nanti.';

  @override
  String get settingsTitle => 'Tetapan';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Gelap';

  @override
  String get darkmode_light => 'Cahaya';

  @override
  String get darkmode_system_default => 'Sistem lalai';

  @override
  String get thanks_for_contributing => 'Terima kasih kerana menyumbang!';

  @override
  String get contributors_label => 'Mereka sedang membina aplikasi';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Penyumbang: $name';
  }

  @override
  String get contributors_description =>
      'Senarai semua penyumbang aplikasi ini';

  @override
  String get support => 'Sokongan';

  @override
  String get support_join_slack => 'Minta bantuan di saluran Slack kami';

  @override
  String get support_via_forum => 'Minta bantuan di forum kami';

  @override
  String get support_via_email => 'Hantarkan e-mel kepada kami';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Hantar log aplikasi?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Adakah anda ingin memasukkan log aplikasi sebagai lampiran pada e-mel anda?';

  @override
  String get termsOfUse => 'Syarat-syarat penggunaan';

  @override
  String get legalNotices => 'Notis undang-undang';

  @override
  String get privacy_policy => 'Dasar privasi';

  @override
  String get about_this_app => 'Mengenai aplikasi ini';

  @override
  String get contribute => 'Sumbang';

  @override
  String get contribute_sw_development => 'Pembangunan perisian';

  @override
  String get contribute_develop_text =>
      'Kod untuk setiap produk Open Food Facts tersedia di GitHub. Anda dialu-alukan untuk menggunakan semula kod ini (ia adalah sumber terbuka) dan membantu kami menambah baiknya, untuk semua orang, di seluruh planet ini.';

  @override
  String get contribute_develop_text_2 =>
      'Anda boleh menyertai bilik sembang Open Food Facts Slack yang merupakan cara pilihan untuk bertanya soalan.';

  @override
  String get contribute_develop_dev_mode_title => 'Mod DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktifkan Mod DEV';

  @override
  String get contribute_donate_title => 'Donate';

  @override
  String get contribute_donate_header => 'Derma kepada Fakta Makanan Terbuka';

  @override
  String get contribute_enroll_alpha_warning =>
      'Sila maklum bahawa dengan versi alfa dalaman, kehilangan data sepenuhnya adalah mungkin, dan aplikasi mungkin tidak dapat digunakan pada bila-bila masa!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Produk yang perlu disiapkan';

  @override
  String get contribute_improve_header => 'Menambah baik';

  @override
  String get contribute_improve_text =>
      'Pangkalan data merupakan teras projek ini. Ia mudah dan cepat untuk membantu. Anda boleh memuat turun aplikasi mudah alih untuk telefon anda dan mula menambah atau menambah baik produk.\n\nSebaliknya, laman web Open Food Facts menawarkan pelbagai cara untuk menyumbang: ';

  @override
  String get contribute_translate_header => 'Terjemahkan';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Mula Terjemahkan';

  @override
  String get contribute_translate_text =>
      'Open Food Facts merupakan projek global yang mengandungi produk dari lebih 160 buah negara. Open Food Facts diterjemahkan ke dalam berpuluh-puluh bahasa, dengan kandungan yang sentiasa berubah.';

  @override
  String get contribute_translate_text_2 =>
      'Terjemahan adalah satu daripada tugas utama projek';

  @override
  String get contribute_join_skill_pool =>
      'Sumbang kemahiran anda kepada Open Food Facts. Sertai kumpulan kemahiran!';

  @override
  String get contribute_share_header =>
      'Kongsikan Fakta Makanan Terbuka dengan rakan-rakan anda';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Sumbang harga dengan meminta eksport GDPR data kad kesetiaan anda';

  @override
  String get tap_to_answer => 'Ketik di sini untuk menjawab soalan';

  @override
  String get tap_to_answer_hint =>
      'Ketik di sini untuk menjawab soalan tentang produk ini';

  @override
  String get robotoff_questions_loading_hint =>
      'Sila tunggu sementara soalan tentang produk ini dimuatkan';

  @override
  String get saving_answer => 'Menyimpan jawapan anda';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Log masuk ke akaun Fakta Makanan Terbuka anda untuk mendapatkan kredit bagi sumbangan anda';

  @override
  String get question_yes_button_accessibility_value => 'Jawab dengan ya';

  @override
  String get question_no_button_accessibility_value => 'Jawab dengan tidak';

  @override
  String get question_skip_button_accessibility_value => 'Langkau soalan ini';

  @override
  String get tap_to_edit_search => 'Ketik untuk mengedit carian';

  @override
  String get myPreferences => 'Keutamaan Saya';

  @override
  String get account_create_message =>
      'Cipta akaun anda dan sertai komuniti Fakta Makanan Terbuka untuk membantu membina pengetahuan tentang makanan di seluruh dunia!';

  @override
  String get join_us => 'Sertai kami';

  @override
  String get myPreferences_profile_title => 'Profil Anda';

  @override
  String get myPreferences_profile_subtitle =>
      'Urus akaun penyumbang Fakta Makanan Terbuka anda.';

  @override
  String get myPreferences_settings_title => 'Tetapan Aplikasi';

  @override
  String get myPreferences_settings_subtitle => 'Mod gelap, Bahasa…';

  @override
  String get myPreferences_food_title => 'Keutamaan Makanan';

  @override
  String get myPreferences_food_subtitle =>
      'Pilih maklumat tentang makanan yang paling penting bagi anda.';

  @override
  String get myPreferences_food_comment =>
      'Pilih maklumat tentang makanan yang paling penting bagi anda untuk menilai makanan mengikut pilihan anda, lihat maklumat yang anda minati dahulu dan dapatkan ringkasan keserasian. Pilihan makanan tersebut kekal pada peranti anda dan tidak dikaitkan dengan akaun penyumbang Fakta Makanan Terbuka anda jika anda mempunyainya.';

  @override
  String get confirmResetPreferences => 'Tetapkan semula pilihan makanan anda?';

  @override
  String get myPersonalizedRanking => 'Kedudukan saya yang diperibadikan';

  @override
  String get ranking_tab_all => 'Semua';

  @override
  String get ranking_subtitle_match_yes => 'Padanan yang hebat untuk anda';

  @override
  String get ranking_subtitle_match_no => 'Padanan yang sangat lemah';

  @override
  String get ranking_subtitle_match_maybe => 'Padanan yang tidak diketahui';

  @override
  String get refresh_with_new_preferences =>
      'Segarkan semula senarai dengan pilihan baharu anda';

  @override
  String get reloaded_with_new_preferences =>
      'Dimuat semula dengan pilihan baharu anda';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Imbas';

  @override
  String get history_navbar_label => 'Sejarah';

  @override
  String get list_navbar_label => 'Senarai';

  @override
  String get category => 'Tapis mengikut kategori';

  @override
  String get category_all => 'Semua';

  @override
  String get category_search => '(carian kategori)';

  @override
  String get filter => 'Tapis';

  @override
  String get scan => 'Produk daripada skrin Imbas';

  @override
  String get scan_history => 'Imbas sejarah';

  @override
  String get search => 'Gelintar';

  @override
  String get search_product_help => 'Cari produk,\njenama atau kod bar';

  @override
  String get search_filter => 'Penapis carian';

  @override
  String get search_history => 'Sejarah carian';

  @override
  String get search_store => 'Cari kedai';

  @override
  String get search_store_help => 'Petunjuk: tambah bandar atau negara';

  @override
  String get tap_for_more => 'Ketik untuk melihat maklumat lanjut…';

  @override
  String get product => 'Produk';

  @override
  String get unknownBrand => 'Jenama tidak diketahui';

  @override
  String get unknownQuantity => 'Kuantiti tidak diketahui';

  @override
  String get unknownProductName => 'Nama produk yang tidak diketahui';

  @override
  String get label_refresh => 'Refresh';

  @override
  String get label_reload => 'Muat semula';

  @override
  String get image => 'Imej';

  @override
  String get front_photo => 'Foto depan';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (imej ini mungkin sudah ketinggalan zaman)';
  }

  @override
  String get outdated_image_short_label => 'mungkin ketinggalan zaman';

  @override
  String get ingredients => 'Bahan-bahan';

  @override
  String get ingredients_editing_instructions =>
      'Kekalkan susunan asal. Nyatakan peratusan apabila dinyatakan. Asingkan dengan koma atau tanda sempang dan gunakan kurungan untuk ramuan sesuatu ramuan.';

  @override
  String get ingredients_editing_error => 'Gagal untuk menyimpan ramuan.';

  @override
  String get ingredients_editing_image_error =>
      'Gagal untuk mendapatkan imej ramuan baharu.';

  @override
  String get ingredients_editing_title => 'Edit Ramuan';

  @override
  String get ingredients_photo => 'Foto ramuan';

  @override
  String get packaging_editing_instructions =>
      'Senaraikan semua bahagian pembungkusan yang dipisahkan dengan koma atau suapan baris, dengan jumlahnya (cth. 1 atau 6) jenis (cth. botol, kotak, tin), bahan (cth. plastik, logam, aluminium) dan jika ada saiznya (cth. 33cl) dan arahan kitar semula.\nContoh: 1 botol kaca untuk dikitar semula, 1 gabus plastik untuk dibuang';

  @override
  String get packaging_editing_error => 'Gagal menyimpan pembungkusan.';

  @override
  String get packaging_editing_image_error =>
      'Gagal mendapatkan imej pembungkusan baharu.';

  @override
  String get packaging_editing_title => 'Edit Pembungkusan';

  @override
  String get nutrition => 'Pemakanan';

  @override
  String get nutrition_facts_photo => 'Foto fakta pemakanan';

  @override
  String get nutrition_facts_editing_title => 'Edit Fakta Pemakanan';

  @override
  String get packaging_information => 'Arahan kitar semula';

  @override
  String get packaging_information_photo => 'Foto arahan kitar semula';

  @override
  String get missing_product => 'Anda telah menemui produk baharu!';

  @override
  String get add_product_take_photos =>
      'Ambil gambar pembungkusan untuk menambah produk ini ke Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Sila ambil beberapa gambar dahulu. Anda boleh menyiapkan produk ini pada masa akan datang.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'Produk Baharu';

  @override
  String get new_product_found_title => 'Produk baharu ditemui!';

  @override
  String get new_product_found_text =>
      'Pangkalan data kolaboratif kami mengandungi lebih daripada **3 juta produk**, tetapi kod bar ini tidak wujud: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'Tinggalkan halaman ini?';

  @override
  String get new_product_leave_message =>
      'Nampaknya anda tidak memasukkan apa-apa. Adakah anda benar-benar mahu meninggalkan halaman ini?';

  @override
  String get new_product_dialog_description =>
      'Sila ambil gambar pembungkusan untuk menambah produk ini ke pangkalan data umum kami';

  @override
  String get new_product_dialog_illustration_description =>
      'Ilustrasi dengan Skor Nutri dan Skor Hijau yang tidak diketahui';

  @override
  String get front_packaging_photo_button_label => 'Foto pembungkusan hadapan';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Sahkan muat naik foto pembungkusan hadapan';

  @override
  String get confirm_button_label => 'Sahkan';

  @override
  String get send_image_button_label => 'Hantar imej';

  @override
  String get crop_page_action_saving => 'Menyimpan imej…';

  @override
  String get crop_page_action_cropping => 'Memotong imej…';

  @override
  String get crop_page_action_local => 'Menyimpan versi setempat…';

  @override
  String get crop_page_action_local_failed_title =>
      'Alamak… ada sesuatu dengan foto awak!';

  @override
  String get crop_page_action_local_failed_message =>
      'Kami tidak dapat memproses imej secara setempat sebelum menghantarnya ke pelayan kami. Sila cuba lagi nanti atau hubungi kami jika masalah berterusan.';

  @override
  String get crop_page_action_retake => 'Ambil semula foto';

  @override
  String get crop_page_too_small_image_title => 'Imej itu terlalu kecil!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Saiz minimum dalam piksel untuk muat naik gambar ialah ${expectedMinWidth}x$expectedMinHeight. Gambar semasa ialah ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Menyediakan panggilan ke pelayan…';

  @override
  String get front_packaging_photo_title => 'Foto Pembungkusan Hadapan';

  @override
  String get ingredients_photo_title => 'Foto Ramuan';

  @override
  String get nutritional_facts_photo_title => 'Foto Fakta Pemakanan';

  @override
  String get recycling_photo_title => 'Arahan kitar semula Foto';

  @override
  String get take_photo_title => 'Ambil gambar';

  @override
  String get take_more_photo_title => 'Take more photos';

  @override
  String get front_photo_uploaded => 'Foto hadapan dimuat naik';

  @override
  String get ingredients_photo_button_label => 'Foto ramuan';

  @override
  String get ingredients_photo_uploaded => 'Foto bahan-bahan dimuat naik';

  @override
  String get nutrition_cache_loading_error =>
      'Tidak dapat memuatkan nutrien daripada cache';

  @override
  String get nutritional_facts_photo_button_label => 'Foto fakta pemakanan';

  @override
  String get nutritional_facts_input_button_label => 'Isi fakta pemakanan';

  @override
  String get nutritional_facts_added => 'Fakta pemakanan ditambah';

  @override
  String get categories_added => 'Kategori ditambah';

  @override
  String get new_product_title_nutriscore => 'Compute the Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Bantu kami dengan mengisi sekurang-kurangnya satu kategori dan nilai pemakanan';

  @override
  String get new_product_title_environmental_score => 'Kira Skor Hijau';

  @override
  String get new_product_subtitle_environmental_score =>
      'Dapatkannya dengan mengisi sekurang-kurangnya satu kategori';

  @override
  String get new_product_additional_environmental_score =>
      'Jadikan pengiraan Skor Hijau lebih tepat dengan asal usul, pembungkusan & banyak lagi';

  @override
  String get new_product_title_nova => 'Kira tahap pemprosesan makanan (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Dapatkannya dengan mengisi kategori makanan dan bahan-bahan';

  @override
  String get new_product_desc_nova_unknown =>
      'Tahap pemprosesan makanan tidak diketahui';

  @override
  String get new_product_title_pictures => 'Produk baharu';

  @override
  String get new_product_title_pictures_details =>
      'Please take the following photos and the Open Food Facts engine can work out the rest!';

  @override
  String get new_product_title_misc => 'Dan beberapa data asas…';

  @override
  String new_product_done_msg(String username) {
    return 'Terima kasih atas sumbangan anda \"$username\"!';
  }

  @override
  String get new_product_done_msg_no_user =>
      'Terima kasih atas sumbangan anda!';

  @override
  String get new_product_done_button_label => 'Temui produk yang telah siap';

  @override
  String get hey_incomplete_product_message =>
      'Ketik untuk menjawab 3 soalan SEKARANG untuk mengira Nutri-Score, Green Score & Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Ketik sekarang untuk menjawab 2 soalan bagi membantu menganalisis kosmetik ini!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Ketik sekarang untuk menjawab 3 soalan bagi membantu menganalisis produk makanan haiwan peliharaan ini!';

  @override
  String get hey_incomplete_product_message_product =>
      'Ketik sekarang untuk membantu melengkapkan produk ini!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Foto fakta nutrisi dimuat naik';

  @override
  String get recycling_photo_button_label => 'Foto kitar semula';

  @override
  String get recycling_photo_uploaded => 'Foto kitar semula dimuat naik';

  @override
  String get take_more_photo_button_label => 'Take more photos';

  @override
  String get other_photo_uploaded => 'Pelbagai foto dimuat naik';

  @override
  String get retake_photo_button_label => 'Ambil Semula';

  @override
  String get selecting_photo => 'Memilih foto';

  @override
  String get uploading_image => 'Memuat naik foto ke pelayan';

  @override
  String get uploading_image_type_front =>
      'Memuat naik imej hadapan ke Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Memuat naik imej ramuan ke Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Memuat naik imej nutrisi ke Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Memuat naik imej pembungkusan ke Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Memuat naik imej lain ke Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Memuat naik imej ke Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Tambahkan ramuan yang hilang';

  @override
  String get score_add_missing_packaging_image =>
      'Tambahkan imej pembungkusan yang hilang';

  @override
  String get score_add_missing_nutrition_facts =>
      'Tambahkan fakta pemakanan yang tiada';

  @override
  String get score_add_missing_product_traces =>
      'Tambahkan jejak produk yang hilang';

  @override
  String get score_add_missing_product_category =>
      'Tambahkan kategori produk yang tiada';

  @override
  String get score_add_missing_precise_product_category =>
      'Pilih kategori yang lebih tepat';

  @override
  String get score_add_missing_product_countries =>
      'Tambahkan negara produk yang tiada';

  @override
  String get score_add_missing_product_emb =>
      'Tambahkan kod kebolehkesanan produk yang hilang';

  @override
  String get score_add_missing_product_labels =>
      'Tambahkan label produk yang hilang';

  @override
  String get score_add_missing_product_origins =>
      'Tambahkan asal produk yang hilang';

  @override
  String get score_add_missing_product_stores =>
      'Tambahkan kedai produk yang tiada';

  @override
  String get score_add_missing_product_brands =>
      'Tambahkan jenama produk yang tiada';

  @override
  String get score_update_nutrition_facts => 'Kemas kini fakta pemakanan';

  @override
  String get nutrition_page_title => 'Fakta Pemakanan';

  @override
  String get nutrition_page_nutritional_info_title => 'Maklumat pemakanan';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Nilai yang dinyatakan pada produk:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Ya';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Tidak';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Buka foto';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Amalan baik: Maklumat pemakanan';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Kadangkala fakta pemakanan **tidak dinyatakan pada pembungkusan** atau pada dokumen yang diberikan bersama produk. Dalam kes ini, dan hanya dalam kes ini, anda boleh menetapkan nilai kepada **TIDAK**.';

  @override
  String get nutrition_page_serving_type_label => 'Nilai pemakanan:';

  @override
  String get nutrition_page_per_100g => 'setiap 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'setiap 100g/ml';

  @override
  String get nutrition_page_per_serving => 'setiap hidangan';

  @override
  String get nutrition_page_add_nutrient => 'Tambah nutrien';

  @override
  String get nutrition_page_serving_size => 'Saiz hidangan';

  @override
  String get nutrition_page_serving_size_hint =>
      'Masukkan saiz hidangan (cth: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Amalan baik: Saiz hidangan';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Nilai ini membantu **membuat pengiraan berkadaran bagi setiap nutrien bagi setiap saiz hidangan**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Unit yang dibenarkan** ialah: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 公升, 公升';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** atau **60 G** (lebih suka yang pertama)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** atau **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Unit tidak sah';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Unit tidak sah';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **gula-gula** dan 2 **biskut**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Unit yang hilang';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Nombor tidak sah';

  @override
  String get nutrition_page_update_running =>
      'Mengemas kini produk pada pelayan…';

  @override
  String get nutrition_page_update_done => 'Produk dikemas kini!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Gunakan kuantiti produk sebagai saiz hidangan';

  @override
  String get nutrition_page_photo_error => 'Tidak dapat memuatkan foto';

  @override
  String get more_photos => 'Foto yang lebih menarik';

  @override
  String get view_more_photo_button =>
      'Lihat semua foto sedia ada untuk produk ini';

  @override
  String get no_product_found => 'Tiada Produk Ditemui';

  @override
  String get no_location_found => 'Tiada lokasi ditemui';

  @override
  String get not_found => 'tidak ditemui:';

  @override
  String get refreshing_product => 'Produk yang diperbaharui';

  @override
  String get product_refreshed => 'Produk diperbaharui';

  @override
  String product_image_accessibility_label(String date) {
    return 'Imej diambil pada $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Imej diambil pada $date. Imej ini mungkin sudah ketinggalan zaman';
  }

  @override
  String get product_image_outdated =>
      'Imej ini mungkin sudah ketinggalan zaman';

  @override
  String get product_image_outdated_explanations_title =>
      'Imej ini mungkin sudah ketinggalan zaman';

  @override
  String get product_image_outdated_explanations_content =>
      'Imej ini diambil lebih setahun yang lalu.\n**Sila semak sama ada ia masih terkini**.\n\nIni **sekadar amaran**. Jika kandungan masih sama, anda boleh mengabaikan mesej ini.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Gantikan foto ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Tambah foto ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Ambil gambar';

  @override
  String get product_image_action_from_gallery =>
      'Pilih daripada galeri telefon anda';

  @override
  String get product_image_action_choose_existing_photo =>
      'Pilih daripada foto produk';

  @override
  String get product_image_details_label => 'Maklumat tentang foto itu';

  @override
  String get product_image_details_from_producer => 'Daripada pengeluar';

  @override
  String get product_image_details_contributor => 'Contributor';

  @override
  String get product_image_details_contributor_producer =>
      'Penyumbang (penerbit)';

  @override
  String get product_image_details_date => 'Tarikh';

  @override
  String get product_image_details_date_unknown => 'Tidak diketahui';

  @override
  String get homepage_main_card_logo_description =>
      'Selamat datang ke Fakta Makanan Terbuka';

  @override
  String get homepage_main_card_subheading =>
      '**Imbas** kod bar atau\n**cari** produk';

  @override
  String get homepage_main_card_search_field_hint => 'Cari produk';

  @override
  String get homepage_main_card_search_field_tooltip => 'Mulakan carian';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Berita terkini: $news_title';
  }

  @override
  String get tagline_app_review => 'Adakah anda suka aplikasi ini?';

  @override
  String get tagline_app_review_button_positive => 'Saya sukakannya! 😍';

  @override
  String get tagline_app_review_button_negative => 'Tidak juga…';

  @override
  String get tagline_app_review_button_later => 'Tanya saya kemudian';

  @override
  String get tagline_feed_news_button => 'Ketahui lebih lanjut';

  @override
  String get app_review_negative_modal_title =>
      'Anda tidak suka aplikasi kami?';

  @override
  String get app_review_negative_modal_text =>
      'Bolehkah anda luangkan beberapa saat untuk memberitahu kami sebabnya?';

  @override
  String get app_review_negative_modal_positive_button => 'Ya, sudah tentu!';

  @override
  String get app_review_negative_modal_negative_button => 'Tidak';

  @override
  String get could_not_refresh => 'Tidak dapat memperbaharui produk';

  @override
  String get product_internet_error_modal_title => 'Ralat telah berlaku!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Kami tidak dapat mendapatkan maklumat tentang produk ini disebabkan oleh ralat rangkaian. Sila semak sambungan internet anda dan cuba lagi.\n\nRalat dalaman:\n$error';
  }

  @override
  String get product_tags_title => 'Sifat produk';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Tiada hartanah';

  @override
  String get product_tags_explanation =>
      'Dengan menambahkan sifat (kunci/nilai) pada produk, anda membantu memperkayakannya.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Tambah sifat';

  @override
  String get add_edit_tags => 'Tambah atau edit sifat';

  @override
  String get edit_tag => 'Edit sifat';

  @override
  String get remove_tag => 'Alih keluar harta';

  @override
  String get tag_key => 'Hartanah';

  @override
  String get tag_keys => 'Hartanah';

  @override
  String get tag_key_uneditable => 'Hartanah (tidak boleh diedit)';

  @override
  String get tag_key_input_hint => 'Masukkan sifat';

  @override
  String get tag_value => 'Nilai';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Masukkan nilai';

  @override
  String get tag_key_item => 'Hartanah:';

  @override
  String get tag_value_item => 'Nilai:';

  @override
  String get tag_key_explanations =>
      'Kunci mestilah huruf kecil dan tanpa sebarang jarak.';

  @override
  String tag_key_already_exists(String property) {
    return 'Tag dengan sifat $property sudah wujud!';
  }

  @override
  String get product_internet_error =>
      'Mustahil untuk mendapatkan maklumat tentang produk ini disebabkan oleh ralat rangkaian.';

  @override
  String get cached_results_from => 'Tunjukkan hasil daripada:';

  @override
  String get product_search_same_category => 'Cari alternatif';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'Ciri ini hanya boleh digunakan untuk produk yang mempunyai kategori.\n\nSila edit produk untuk menambah kategori.';

  @override
  String get product_improvement_add_category =>
      'Tambahkan kategori untuk mengira Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Tambahkan fakta pemakanan untuk mengira Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Tambahkan fakta pemakanan dan kategori untuk mengira Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-Score untuk produk ini tidak boleh dikira, yang mungkin disebabkan oleh contohnya kategori bukan standard. Jika ini dianggap ralat, sila hubungi kami.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Imej pemakanan sudah lapuk: sila muat semula.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Skor Hijau mengambil kira asal-usul ramuan. Sila ambil gambar senarai ramuan dan/atau sebarang tuntutan geografi atau sunting produk, supaya ia boleh diambil kira.';

  @override
  String get country_chooser_label => 'Sila pilih negara';

  @override
  String get currency_chooser_label => 'Sila pilih mata wang';

  @override
  String get country_change_message => 'Awak baru sahaja bertukar negara.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Adakah anda ingin menukar mata wang daripada $previousCurrency kepada $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Sila pilih negara:';

  @override
  String get country_chooser_label_from_settings => 'Negara anda';

  @override
  String get country_selection_explanation =>
      'Sesetengah ciri persekitaran adalah khusus lokasi';

  @override
  String get product_removed_comparison =>
      'Produk dialih keluar daripada perbandingan';

  @override
  String get native_app_settings => 'Tetapan Aplikasi Asli';

  @override
  String get native_app_description =>
      'Tetapan sistem terbuka untuk Fakta Makanan Terbuka';

  @override
  String get product_removed_history => 'Produk dialih keluar daripada sejarah';

  @override
  String get product_removed_list => 'Produk dialih keluar daripada senarai';

  @override
  String get product_could_not_remove => 'Tidak dapat mengalih keluar produk';

  @override
  String get no_prodcut_in_list => 'Tiada terdapat produk dalam senarai ini';

  @override
  String get no_product_in_section => 'Tiada terdapat produk di seksyen ini';

  @override
  String get recently_seen_products => 'Semua produk yang dilihat';

  @override
  String get clear => 'Jelas';

  @override
  String get clear_long => 'Kosongkan senarai';

  @override
  String get really_clear =>
      'Adakah anda benar-benar mahu memadamkan senarai ini?';

  @override
  String pct_match(Object percent) {
    return '$percent% padan';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hari yang lalu',
      one: 'sehari yang lalu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count jam yang lalu',
      one: 'sejam yang lalu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minit yang lalu',
      one: 'seminit yang lalu',
      zero: 'kurang seminit yang lalu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bulan yang lalu',
      one: 'sebulan yang lalu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minggu yang lalu',
      one: 'seminggu yang lalu',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Bandingkan $count Produk',
      one: 'Bandingkan satu Produk',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produk yang dipilih',
      one: 'Satu produk yang dipilih',
      zero: 'Tiada produk yang dipilih',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Bandingkan produk terpilih';

  @override
  String get delete_products_mode => 'Padam produk yang dipilih';

  @override
  String get select_all_products_mode => 'Pilih semua produk';

  @override
  String get select_none_products_mode => 'Pilih tiada';

  @override
  String get compare_products_appbar_title => 'Banding produk';

  @override
  String get compare_products_appbar_subtitle =>
      'Sila pilih sekurang-kurangnya dua produk';

  @override
  String get retry_button_label => 'Cuba lagi';

  @override
  String get connect_with_us => 'Berhubunglah dengan kami';

  @override
  String get tiktok => 'Ikuti kami di TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Ikuti kami di Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Ikuti kami di X (dahulunya Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Ikuti kami di Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Ikuti kami di BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'SOALAN-SOALAN LAZIM';

  @override
  String get discover => 'Temui';

  @override
  String get how_to_contribute => 'Cara untuk menyumbang';

  @override
  String get hint_knowledge_panel_message =>
      'Anda boleh mengetik mana-mana bahagian kad untuk mendapatkan butiran lanjut tentang apa yang anda lihat. Cubalah sekarang!';

  @override
  String get permissions_page_title => 'Akses kamera';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'Jika anda berubah fikiran, pilihan ini boleh didayakan dan dilumpuhkan pada bila-bila masa daripada tetapan.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Antarabangsa: $sdkInt / Keluaran: $release)\nModel: $model\nProduk: $product\nPeranti: $device\nJenama:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModel: $model\nModel setempat: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVersi aplikasi:$appVersion\nNombor binaan aplikasi:$appBuildNumber\nNama pakej aplikasi:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'Menolak';

  @override
  String get ask_me_later_button_label => 'Kemudian';

  @override
  String get are_you_sure => 'Awak pasti?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Teruskan di $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Selamat datang!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Aplikasi yang membantu anda memilih makanan yang baik untuk **anda** dan **planet**!';

  @override
  String get onboarding_continue_button => 'Teruskan';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Memuatkan produk contoh pertama anda';

  @override
  String get onboarding_welcome_warning =>
      'Maaf, ini contoh produk kami, anda tidak boleh mengeditnya :)';

  @override
  String get product_list_your_ranking => 'Kedudukan anda';

  @override
  String get product_list_empty_icon_desc => 'Sejarah tidak tersedia';

  @override
  String get product_list_empty_title => 'Mulakan pengimbasan';

  @override
  String get product_list_empty_message =>
      'Produk yang diimbas akan dipaparkan di sini dan anda boleh menyemak maklumat terperinci mengenainya';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produk',
      one: 'produk',
      zero: 'produk',
    );
    return 'Menyegarkan $_temp0 dalam sejarah anda';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Produk',
      one: 'Produk',
      zero: 'Produk',
    );
    return '$_temp0 muat semula selesai';
  }

  @override
  String get product_list_compare_side_by_side =>
      'Bandingkan sebelah menyebelah';

  @override
  String get loading_dialog_default_title => 'Memuat turun data';

  @override
  String get loading_dialog_default_error_message =>
      'Tidak dapat memuat turun data';

  @override
  String get account_delete => 'Padam akaun';

  @override
  String get account_delete_title => 'Padam akaun saya';

  @override
  String get user_profile => 'Akaun';

  @override
  String get user_profile_title_guest => 'Selamat Datang!';

  @override
  String get user_profile_subtitle_guest =>
      'Daftar masuk atau daftar untuk menyertai komuniti Fakta Makanan Terbuka';

  @override
  String user_profile_title_id_email(String email) {
    return 'Log masuk Fakta Makanan Terbuka: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Selamat datang $id!';
  }

  @override
  String get email_subject_account_deletion => 'Padam akaun';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hai semua, sila padamkan akaun Fakta Makanan Terbuka saya: $userId';
  }

  @override
  String get settings_app_app => 'Permohonan';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Produk';

  @override
  String get settings_app_miscellaneous => 'Pelbagai';

  @override
  String get camera_play_sound_title => 'Mainkan bunyi semasa imbasan';

  @override
  String get camera_play_sound_subtitle =>
      'Akan berbunyi bip pada setiap imbasan yang berjaya';

  @override
  String get camera_window_accessibility_label =>
      'Imbas kod bar dengan kamera anda';

  @override
  String get app_haptic_feedback_title => 'Getaran & Haptik';

  @override
  String get app_haptic_feedback_subtitle =>
      'Getaran selepas melaksanakan beberapa tindakan (kod bar dinyahkod, produk dialih keluar…).';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Apabila diaktifkan, laporan ranap sistem akan dihantar secara automatik ke sistem penjejakan ralat Open Food Facts supaya pepijat dapat dibaiki dan seterusnya menambah baik aplikasi.';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Edit Foto';

  @override
  String get permission_photo_error => 'Ralat';

  @override
  String get permission_photo_denied_title =>
      'Benarkan penggunaan kamera untuk mengimbas kod bar';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Untuk pengalaman yang dipertingkatkan, sila benarkan $appName mengakses kamera anda. Anda boleh mengimbas kod bar secara langsung.';
  }

  @override
  String get permission_photo_denied_button => 'Benarkan';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Kebenaran ditolak';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Memandangkan anda telah menolak kebenaran kamera sebelum ini, anda mesti membenarkannya secara manual daripada Tetapan.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Buka tetapan';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Cancel';

  @override
  String get permission_photo_none_found => 'Tiada kamera dikesan';

  @override
  String get permission_photo_denied => 'Tiada akses kamera diberikan';

  @override
  String get show_product_pictures => 'Tunjukkan gambar produk';

  @override
  String get edit_product_label => 'Edit produk';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Memuat naik suntingan anda…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Suntingan anda **dihantar di latar belakang** (atau kemudian sekiranya berlaku ralat).\nAnda boleh terus mengedit medan produk lain.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Suntingan anda sedang **dihantar di latar belakang** (atau kemudian sekiranya berlaku ralat).';

  @override
  String get edit_product_label_short => 'Edit';

  @override
  String edit_product_form_item_help(String value) {
    return 'Bagaimana untuk memasukkan \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Sila masukkan nilai yang bukan kosong!';

  @override
  String get edit_product_form_item_error_existing => 'Nilai ini sudah ada!';

  @override
  String get edit_product_form_item_add_action_brand => 'Tambah jenama baharu';

  @override
  String get edit_product_form_item_add_action_label => 'Tambah label baharu';

  @override
  String get edit_product_form_item_add_action_store => 'Tambah kedai baharu';

  @override
  String get edit_product_form_item_add_action_origin => 'Tambah asal baharu';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Tambah kod kebolehkesanan baharu';

  @override
  String get edit_product_form_item_add_action_country =>
      'Tambah negara baharu';

  @override
  String get edit_product_form_item_add_action_category =>
      'Tambah kategori baharu';

  @override
  String get edit_product_form_item_add_action_trace => 'Tambah jejak baharu';

  @override
  String get edit_product_form_item_add_suggestion => 'Tambah cadangan';

  @override
  String get edit_product_form_item_deny_suggestion => 'Tolak cadangan';

  @override
  String get edit_product_form_item_details_title => 'Butiran asas';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Nama produk, jenama, kuantiti';

  @override
  String get edit_product_form_item_other_details_title => 'Butiran tambahan';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Laman Web…';

  @override
  String get edit_product_form_item_photos_title => 'Foto';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Tambah atau muat semula foto';

  @override
  String get edit_product_form_item_labels_title => 'Label & Pensijilan';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Label Alam Sekitar, Kualiti…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Masukkan label (cth.: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Amalan baik: Label';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Sebarang ciri produk **yang berdasarkan fakta** dan berbeza daripada bidang lain.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Dibuat di Belgium, dikeluarkan di Brittany…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Kaya dengan serat, sumber zat besi…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Perdagangan yang adil, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Kedai';

  @override
  String get edit_product_form_item_stores_hint => 'Masukkan kedai';

  @override
  String get edit_product_form_item_stores_type => 'kedai';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Amalan baik: Kedai';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Masukkan kedai tempat anda membeli produk tersebut.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Asal-usul';

  @override
  String get edit_product_form_item_origins_hint =>
      'Masukkan asal (cth.: Jerman)';

  @override
  String get edit_product_form_item_origins_type => 'negara';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Amalan baik: Asal-usul';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Tambahkan **sebarang petunjuk asal usul yang boleh didapati pada pembungkusan**.\nAnda tidak perlu risau tentang asal usul yang ditunjukkan terus dalam senarai ramuan.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Daging lembu dari Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soya bukan berasal dari Kesatuan Eropah';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Masukkan negara (cth.: Jerman)';

  @override
  String get edit_product_form_item_countries_type => 'negara';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Amalan baik: Negara';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Negara-negara di mana produk ini tersedia secara meluas** (tidak termasuk kedai yang mengkhusus dalam produk asing).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Kod kebolehjejakan';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Masukkan kod (cth: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'kod kebolehjejakan';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Amalan baik: Kod kebolehkesanan';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Dalam bahagian ini, anda boleh memasukkan kod yang berkaitan dengan **tanda pembungkusan**, **tanda pengenalan** atau **tanda kesihatan**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Contoh kod kebolehkesanan';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Kod EC** yang digunakan dalam Komuniti Eropah untuk mengenal pasti pengeluar atau pembungkus makanan:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: kod negara **France**\n**72.264.002**: data geografi\n**CE**: Komuniti Eropah';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Kod EMB** yang digunakan di Perancis:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Kesan-kesan';

  @override
  String get edit_product_form_item_traces_hint => 'kesan';

  @override
  String get edit_product_form_item_traces_type =>
      'Masukkan jejak (cth.: Kacang soya)';

  @override
  String get edit_product_form_item_categories_title => 'Kategori-kategori';

  @override
  String get edit_product_form_item_categories_hint => 'kategori';

  @override
  String get edit_product_form_item_categories_type =>
      'Masukkan kategori (cth.: Jus oren)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Amalan baik: Kategori';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Nyatakan **hanya kategori yang paling khusus**.\nKategori induk akan ditambah secara automatik.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Kategori tiada?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Sekiranya kategori **tidak tersedia dalam autolengkap**, sila tambahkannya.\nIni akan membantu kami menambah baik Fakta Makanan Terbuka di negara anda.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardin dalam minyak zaitun';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Jus oren daripada pekatan';

  @override
  String get edit_product_form_item_exit_title => 'Berhenti tanpa menyimpan?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Adakah anda ingin menyimpan perubahan anda sebelum meninggalkan halaman ini?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Simpan perubahan';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Buang perubahan';

  @override
  String get edit_product_form_item_ingredients_title => 'Bahan-bahan';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Zum masuk dan keluar dengan mencubit skrin';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Zum masuk dan keluar foto';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Menggunakan **Gerak isyarat Cubit untuk zum**, anda boleh zum masuk atau keluar foto:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Tambah';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Sila masukkan teks terlebih dahulu';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Alih keluar';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Simpan suntingan anda';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Batalkan suntingan anda';

  @override
  String get edit_product_form_item_packaging_title =>
      'Foto arahan kitar semula';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Fakta pemakanan';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Pemakanan, kandungan alkohol…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Amalan baik: Fakta pemakanan';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Nilai pemakanan';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Pertama, pilih jika **nilai disediakan**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Fakta pemakanan';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Kemudian, masukkan nilai pemakanan **seperti yang ditunjukkan pada pembungkusan**. Jika tiada nilai, anda boleh klik pada ikon \"Mata\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Medan tiada?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Jika terdapat entri yang hilang, anda boleh **klik pada ikon \"Tambah\"** untuk menambahkannya (cth: vitamin D, magnesium…).';

  @override
  String get edit_product_form_save => 'Edit';

  @override
  String get edit_product_ingredients_photo_title => 'Foto ramuan';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Foto pembungkusan';

  @override
  String get edit_product_packaging_list_title => 'Senarai pembungkusan';

  @override
  String get no_data_available => 'Tiada data tersedia';

  @override
  String get product_field_website_title => 'Laman Web';

  @override
  String get origins_editing_title => 'Sunting Asal-usul';

  @override
  String get completed_basic_details_btn_text => 'Lengkapkan butiran asas';

  @override
  String get not_implemented_snackbar_text => 'Belum dilaksanakan lagi';

  @override
  String get category_picker_page_appbar_text => 'Kategori-kategori';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Ekstrak bahan-bahan daripada foto';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Mengekstrak bahan-bahan\ndaripada foto';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Memuatkan foto…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Mengapa saya nampak mesej ini?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Untuk menggunakan ciri \"Ekstrak bahan\", foto perlu dimuat naik terlebih dahulu.\n\nSila tunggu beberapa saat atau masukkannya secara manual.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Muat semula foto';

  @override
  String get edit_packaging_extract_btn_text =>
      'Ekstrak pembungkusan\ndaripada foto';

  @override
  String get edit_packaging_extract_btn_text_short => 'Pembungkusan ekstrak';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Mengekstrak pembungkusan daripada foto';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Memuatkan foto…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Mengapa saya nampak mesej ini?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Untuk menggunakan ciri \"Ekstrak pembungkusan\", foto perlu dimuat naik terlebih dahulu.\n\nSila tunggu beberapa saat atau masukkannya secara manual.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Muat semula foto';

  @override
  String get edit_ocr_extract_failed => 'Gagal mengesan teks dalam imej.';

  @override
  String get edit_ocr_extract_disabled_title => 'Tiada gambar!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Untuk menggunakan ciri pengekstrakan teks, anda mesti mengambil gambar terlebih dahulu.';

  @override
  String get user_list_dialog_new_title => 'Senarai produk baharu';

  @override
  String get user_list_dialog_rename_title => 'Namakan semula senarai';

  @override
  String get user_list_subtitle_product => 'Senarai';

  @override
  String get user_list_title => 'Your lists';

  @override
  String get user_list_add_product => 'Tambahkan produk ke senarai anda';

  @override
  String get user_list_button_new => 'Cipta senarai baharu';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Tambah ke senarai';

  @override
  String get added_to_list_msg => 'Ditambah ke senarai';

  @override
  String get user_list_popup_clear => 'Kosongkan sejarah anda';

  @override
  String get user_list_popup_rename => 'Namakan semula';

  @override
  String get user_list_name_hint => 'Senarai saya';

  @override
  String get user_list_name_error_empty => 'Nama adalah wajib';

  @override
  String get user_list_name_error_already => 'Nama itu sudah digunakan';

  @override
  String get user_list_name_error_same => 'Itu nama yang sama';

  @override
  String get user_list_name_input_hint => 'Nama senarai';

  @override
  String get try_again => 'Cuba Lagi';

  @override
  String get there_was_an_error => 'Terdapat ralat';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Tiada kategori ditemui untuk $items';
  }

  @override
  String get camera_toggle_camera => 'Tukar antara kamera belakang dan hadapan';

  @override
  String get camera_toggle_flash => 'HIDUPKAN atau MATIKAN denyar kamera';

  @override
  String get camera_enable_flash => 'Dayakan denyar';

  @override
  String get camera_disable_flash => 'Lumpuhkan denyar';

  @override
  String get camera_flash_error_dialog_title => 'Ralat telah berlaku!';

  @override
  String get camera_flash_error_dialog_message =>
      'Ralat berlaku semasa menukar keadaan lampu kilat anda. Sila pastikan telefon pintar anda tidak mendayakan lampu suluh.';

  @override
  String get category_picker_no_category_found_button => 'Undur';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Klik untuk membuka dalam pelayar anda atau dalam aplikasi (jika dipasang)';

  @override
  String get dev_preferences_screen_title => 'Mod DEV';

  @override
  String get dev_preferences_screen_subtitle =>
      'Akses ciri percubaan dan alat pembangunan';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Mulakan semula onboarding';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Anda kemudian perlu memulakan semula Aplikasi untuk melihatnya semula.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Tukar antara openfoodfacts.org (PROD) dan persekitaran ujian';

  @override
  String get dev_preferences_test_environment_title =>
      'Parameter persekitaran ujian';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL asas untuk persekitaran ujian semasa: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Hos persekitaran ujian';

  @override
  String get dev_preferences_ml_kit_title => 'Gunakan Kit ML';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'maka anda perlu memulakan semula aplikasi ini';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Butang tambahan pada halaman produk';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Edit bahan melalui butang panel pengetahuan';

  @override
  String get dev_preferences_export_history_title => 'Sejarah Eksport';

  @override
  String get dev_preferences_export_history_progress_error => 'pengecualian';

  @override
  String get dev_preferences_export_history_progress_found => 'produk ditemui';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produk TIDAK ditemui';

  @override
  String get dev_preferences_export_history_dialog_title => 'Sejarah eksport';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Cancel';

  @override
  String get dev_preferences_migration_title => 'Migrasi data daripada V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Status: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'kejayaan atau pemasangan baharu';

  @override
  String get dev_preferences_migration_status_success => 'kejayaan';

  @override
  String get dev_preferences_migration_status_error => 'ralat';

  @override
  String get dev_preferences_migration_status_in_progress =>
      'sedang dijalankan';

  @override
  String get dev_preferences_migration_status_required =>
      'diperlukan (klik untuk mula)';

  @override
  String get dev_preferences_migration_status_not_started => 'tidak diketahui';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Akan membersihkan sejarah dan meletakkan 3 produk di sana';

  @override
  String get dev_preferences_news_custom_url_title =>
      'URL tersuai untuk berita';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL fail JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Tidak ditetapkan';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Segar semula terakhir: $date';
  }

  @override
  String get product_type_label_food => 'Makanan';

  @override
  String get product_type_label_beauty => 'Penjagaan diri';

  @override
  String get product_type_label_pet_food => 'Makanan haiwan peliharaan';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'Jenis produk';

  @override
  String get product_type_selection_subtitle => 'Pilih jenis produk ini';

  @override
  String get product_type_selection_empty =>
      'Anda perlu memilih jenis produk terlebih dahulu!';

  @override
  String product_type_selection_already(String productType) {
    return 'Anda tidak boleh menukar jenis produk ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Pintasan ke aplikasi Harga pada halaman produk';

  @override
  String get prices_app_button => 'Pergi ke aplikasi Harga';

  @override
  String get prices_website_button => 'Buka di laman web Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Tambah tanda harga terus daripada galeri';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Sebaik sahaja anda memilih imej, anda tidak akan dapat mengeditnya!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Benarkan komuniti mengesahkan harga yang diekstrak oleh AI.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Tanda Harga Berbilang';

  @override
  String get prices_bulk_proof_upload_title => 'Muat Naik Bukti Pukal';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Memilih fail';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Memulakan muat naik';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Menyalin fail secara tempatan #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Menyediakan muat naik #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Gagal pada imej #$index/$count';
  }

  @override
  String get prices_generic_title => 'Harga';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tambah $count harga',
      one: 'Tambah harga',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Hantar $count harga',
      one: 'Hantar harga',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Tambah item';

  @override
  String get prices_add_a_price => 'Tambah harga';

  @override
  String get prices_add_a_receipt => 'Tambah resit';

  @override
  String get prices_add_price_tags => 'Tambah tanda harga';

  @override
  String prices_barcode_already(String barcode) {
    return 'Kod bar ini ($barcode) sudah ada dalam senarai!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'Tiada produk lagi';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Mencari $barcode';
  }

  @override
  String get prices_barcode_enter => 'Masukkan Kod Bar';

  @override
  String get prices_category_enter => 'Item tanpa kod bar';

  @override
  String get prices_per_kilogram => 'Harga sekilogram';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / unit';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'Pilihan';

  @override
  String get prices_category_error_mandatory => 'Kategori adalah wajib';

  @override
  String get prices_barcode_reader_action => 'Pembaca kod bar';

  @override
  String get prices_view_prices => 'Lihat harga';

  @override
  String get prices_list_title => 'senarai harga';

  @override
  String get prices_list_count => 'Bilangan harga\n';

  @override
  String get prices_list_add_new_price => 'Tambah\nharga baharu';

  @override
  String get prices_list_empty_title => 'Belum ada harga!';

  @override
  String get prices_list_empty_subtitle =>
      'Jadilah yang pertama menambah satu:\nDengan mengimbas **resit** atau **tag harga**!';

  @override
  String get prices_entry_shop_not_found => 'Kedai tidak diketahui';

  @override
  String prices_entry_menu_title(String user) {
    return 'Kemasukan harga daripada \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Lihat semua harga untuk produk ini';

  @override
  String get prices_entry_menu_open_proof => 'Lihat bukti';

  @override
  String get prices_entry_menu_my_prices => 'Lihat harga saya yang lain';

  @override
  String get prices_entry_menu_author_prices => 'Lihat harga lain oleh penulis';

  @override
  String get prices_entry_menu_shop_prices => 'Lihat harga lain dari kedai';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count harga',
      one: '1 harga',
    );
    return '$_temp0 untuk $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Semua $count harga',
      one: 'Hanya satu harga',
      zero: 'Tiada harga lagi',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Harga $pageSize terkini (jumlah: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Harga: $price / Kedai: \"$location\" / Diterbitkan pada $date oleh \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Bukti terbuka bagi \"$user\"';
  }

  @override
  String get prices_open_proof => 'Bukti harga terbuka';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Semua $count bukti',
      one: 'Hanya satu bukti',
      zero: 'Tiada bukti lagi',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Bukti $pageSize terkini (jumlah: $total)';
  }

  @override
  String get prices_users_empty_title => 'Belum ada penyumbang!';

  @override
  String get prices_users_empty_explanation =>
      'Jadilah yang pertama untuk menambah harga!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Penyumbang $pageSize teratas (jumlah: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Belum ada kedai!';

  @override
  String get prices_locations_empty_explanation =>
      'Jadilah yang pertama untuk menambah harga!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Lokasi $pageSize teratas (jumlah: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bukti',
      one: 'Satu bukti',
      zero: 'Tiada bukti',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produk',
      one: 'Satu produk',
      zero: 'Tiada produk',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pengguna',
      one: 'Seorang pengguna',
      zero: 'Tiada pengguna',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count harga',
      one: 'Satu harga',
      zero: 'Tiada harga',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Harga ditambah sebelum ini';

  @override
  String get prices_amount_subtitle => 'Jumlah';

  @override
  String get prices_amount_is_discounted => 'Adakah diskaun?';

  @override
  String get prices_amount_price_normal => 'Harga';

  @override
  String get prices_amount_price_discounted => 'Harga diskaun';

  @override
  String get prices_amount_price_not_discounted => 'Harga asal';

  @override
  String get prices_amount_no_product => 'Satu produk hilang!';

  @override
  String get prices_amount_price_incorrect => 'Nilai salah';

  @override
  String get prices_amount_price_mandatory => 'Nilai wajib';

  @override
  String get prices_currency_subtitle => 'Mata wang';

  @override
  String get prices_date_subtitle => 'Tarikh';

  @override
  String get prices_location_subtitle => 'Kedai';

  @override
  String get prices_location_find => 'Cari kedai';

  @override
  String get prices_location_mandatory => 'Anda perlu memilih kedai!';

  @override
  String get prices_location_search_broader =>
      'Tidak dapat menemui apa yang anda cari? Mari cuba carian yang lebih luas!';

  @override
  String get prices_proof_subtitle => 'Bukti';

  @override
  String get prices_proof_empty_title => 'Belum ada bukti!';

  @override
  String get prices_proof_empty_explanation =>
      'Mulakan dengan menambah foto **resit** atau **tanda harga**!';

  @override
  String get prices_proof_find => 'Pilih bukti';

  @override
  String get prices_proof_change => 'Bukti perubahan';

  @override
  String get prices_proof_receipt => 'Resit';

  @override
  String get prices_proof_price_tag => 'Tanda harga';

  @override
  String get prices_proof_mandatory => 'Anda perlu memilih bukti!';

  @override
  String get prices_add_validation_error => 'Ralat pengesahan';

  @override
  String get prices_privacy_warning_title => 'Amaran privasi';

  @override
  String get prices_unknown_product => 'Produk tidak diketahui';

  @override
  String get prices_privacy_warning_main_message =>
      'Harga **akan diumumkan**, bersama-sama dengan kedai yang dirujuk.\n\nItu mungkin membolehkan orang yang mengetahui tentang nama samaran Open Food Facts anda untuk:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Buat kesimpulan di kawasan mana anda tinggal';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Ketahui apa yang anda beli';

  @override
  String get prices_privacy_warning_sub_message =>
      'Jika anda tidak selesa dengan itu, sila tukar nama samaran anda atau buat akaun Open Food Facts baharu dan log masuk ke aplikasi dengannya.';

  @override
  String get i_refuse => 'Saya menolak';

  @override
  String get i_accept => 'Saya terima';

  @override
  String get prices_currency_change_proposal_title => 'Tukar mata wang?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Mata wang semasa anda ialah **$currency**. Adakah anda ingin menukarnya kepada **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Ya, gunakan $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Tidak, simpan $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Selesai';

  @override
  String get dev_mode_section_server => 'Konfigurasi pelayan';

  @override
  String get dev_mode_section_news => 'Konfigurasi penyedia berita';

  @override
  String get dev_mode_section_product_page => 'Halaman produk';

  @override
  String get dev_mode_section_ui => 'Antara Muka Pengguna';

  @override
  String get dev_mode_section_experimental_features => 'Ciri-ciri eksperimen';

  @override
  String get dev_mode_hide_environmental_score_title => 'Kecualikan Skor Hijau';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Gunakan pemeriksa ejaan untuk skrin OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Bahan-bahan dan pembungkusan)';

  @override
  String get dev_mode_reset_app_language_title => 'Tetapkan semula bahasa apl';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Tambah kad';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Beralih antara prices.openfoodfacts.org (PROD) dan ujian env';

  @override
  String get search_history_item_edit_tooltip =>
      'Gunakan semula dan edit carian ini';

  @override
  String get search_history_item_remove_tooltip => 'Alih keluar';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Anda telah memuat turun semua produk $totalSize .';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Muat turun $count lebih banyak produk\nTelah dimuat turun $downloaded daripada $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Carian anda untuk $search sedang dijalankan.\n\nSila tunggu beberapa saat…';
  }

  @override
  String get user_search_contributor_title => 'Produk yang saya tambah';

  @override
  String get user_search_informer_title => 'Produk yang saya edit';

  @override
  String get user_search_photographer_title =>
      'Produk yang saya ambil gambarnya';

  @override
  String get user_search_to_be_completed_title => 'Produk saya yang akan siap';

  @override
  String get user_search_prices_title => 'Harga saya';

  @override
  String get user_search_proofs_title => 'Bukti saya';

  @override
  String get user_search_proof_title => 'Bukti saya';

  @override
  String search_proof_title(String user) {
    return 'Bukti daripada \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Harga penyumbang: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Harga Terkini ditambah';

  @override
  String get all_search_prices_top_user_title => 'Penyumbang harga tertinggi';

  @override
  String get all_search_prices_top_location_title =>
      'Kedai dengan harga paling tinggi';

  @override
  String get prices_contribution_assistant => 'Pembantu Sumbangan Harga';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Tambah Pelbagai Bukti';

  @override
  String get all_search_prices_top_location_single_title => 'Harga di kedai';

  @override
  String get all_search_prices_top_product_title =>
      'Produk dengan harga paling tinggi';

  @override
  String get all_search_to_be_completed_title =>
      'Semua produk yang akan disiapkan';

  @override
  String get categorize_products_country_title =>
      'Bantu mengkategorikan produk di negara anda';

  @override
  String get edit_product_action_retake_picture => 'Ambil semula foto';

  @override
  String get edit_product_action_take_picture => 'Ambil gambar';

  @override
  String get edit_product_action_confirm => 'Sahkan';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Saya bersetuju dengan Fakta Makanan Terbuka ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'syarat penggunaan dan sumbangan';

  @override
  String get analytics_consent_image_semantic_label => 'Ikon analitik';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Ralat Maut: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Ralat Maut: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'Lengkapkan butiran asas';

  @override
  String get edit_photo_button_label => 'Edit';

  @override
  String get edit_photo_unselect_button_label => 'Nyahpilih foto';

  @override
  String get edit_photo_select_existing_button_label => 'Pilih imej sedia ada';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Pilih imej dengan mengkliknya';

  @override
  String get edit_photo_select_existing_download_label =>
      'Mendapatkan semula imej sedia ada…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Tiada imej yang dimuat naik sebelum ini berkaitan dengan produk ini.';

  @override
  String get edit_photo_language_not_this_one =>
      'Tiada imej dalam bahasa itu lagi';

  @override
  String get edit_photo_language_none => 'Tiada imej lagi';

  @override
  String get category_picker_screen_title => 'Kategori-kategori';

  @override
  String get basic_details => 'Butiran Asas';

  @override
  String get product_name => 'Nama Produk';

  @override
  String get product_names => 'Nama Produk';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Tambah terjemahan baharu';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Sebelum pengesahan, sila pastikan anda hanya menambah terjemahan **jika bahasa tersebut terdapat pada pembungkusan**';

  @override
  String get add_basic_details_product_name_open_photo => 'Lihat foto hadapan';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Ambil gambar hadapan';

  @override
  String get add_basic_details_product_name_hint =>
      'Masukkan nama produk (cth: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Tukar bahasa lalai?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Adakah anda mahu bahasa lalai produk ditetapkan kepada \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Contoh yang baik';

  @override
  String get explanation_section_bad_examples => 'Contoh buruk';

  @override
  String get add_basic_details_product_name_help_title =>
      'Amalan baik: Nama produk';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Nama produk ialah **nama utama yang dicetak pada pembungkusan**. Ia boleh menjadi tanda dagangan berdaftar.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Nota:** Sila jangan tambah terjemahan **jika bahasa tersebut tiada pada pembungkusan**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Sos Tomato';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Jangan sertakan jenama dalam nama';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Sos Tomato **oleh Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Jangan gunakan simbol ®, ™, © atau yang serupa';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count terjemahan lain',
      one: '$count terjemahan lain',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Nama jenama';

  @override
  String get brand_names => 'Nama jenama';

  @override
  String get add_basic_details_brand_name_error => 'Sila masukkan nama jenama';

  @override
  String get add_basic_details_brand_names_hint =>
      'Jenama input (cth.: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Amalan baik: Jenama';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Masukkan **semua jenama produk**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Jenama utama';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Jenama utama**, yang biasanya dipaparkan dengan jelas pada pek hadapan, harus **dimasukkan dahulu**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Jenama lain';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Apabila dijual **oleh syarikat besar**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** dijual oleh **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Apabila dijual dengan jenamanya **diterjemahkan dalam pelbagai bahasa**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Lembah Alam** kadangkala ditulis **Val Alam**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Kuantiti dan berat';

  @override
  String get add_basic_details_quantity_hint =>
      'Masukkan berat dan kuantiti jika perlu (cth: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Amalan baik: Kuantiti';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Salin nilai yang ditunjukkan pada produk dan **jangan lupa unitnya**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** atau **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (untuk 6 biji telur)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(untuk produk dengan 3 kotak, setiap satu 150g)';

  @override
  String get barcode => 'Barkod';

  @override
  String barcode_barcode(String barcode) {
    return 'Kod Bar: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Kod bar tidak sah';

  @override
  String get basic_details_add_success => 'Butiran asas berjaya ditambah';

  @override
  String get basic_details_add_error =>
      'Tidak dapat menambah butiran asas. Sila cuba lagi selepas beberapa ketika';

  @override
  String get clear_search => 'Kosongkan carian anda';

  @override
  String get confirm_clear =>
      'Anda akan memadamkan keseluruhan sejarah anda: adakah anda pasti mahu meneruskan?';

  @override
  String get alert_clear_selected_user_list =>
      'Anda akan memadamkan item yang dipilih dalam sejarah anda';

  @override
  String get confirm_clear_selected_user_list =>
      'Adakah anda pasti mahu meneruskan?';

  @override
  String get alert_select_items_to_clear =>
      'Sila pilih satu atau lebih item untuk dikosongkan';

  @override
  String confirm_clear_user_list(String name) {
    return 'Anda akan mengosongkan senarai ini ($name): adakah anda pasti mahu meneruskan?';
  }

  @override
  String get confirm_delete_user_list_title => 'Padamkan senarai itu?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Anda akan memadamkan senarai \"$name\".\nAdakah anda pasti mahu meneruskan?';
  }

  @override
  String get confirm_delete_user_list_button => 'Ya, saya sahkan';

  @override
  String importance_label(String name, String id) {
    return '$name kepentingan: $id';
  }

  @override
  String get user_list_all_title => 'Senarai';

  @override
  String get user_list_all_empty => 'Cipta senarai pertama anda';

  @override
  String get product_list_select => 'Pilih senarai';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produk',
      one: 'Satu produk',
      zero: 'Senarai kosong',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Tambah senarai';

  @override
  String get open_food_preferences_tooltip => 'Edit pilihan makanan anda';

  @override
  String get add_photo_button_label => 'Tambah foto';

  @override
  String get add_packaging_photo_button_label =>
      'Ambil gambar sebarang maklumat pembungkusan/kitar semula';

  @override
  String get add_origin_photo_button_label =>
      'Ambil gambar sebarang maklumat asal';

  @override
  String get add_emb_photo_button_label =>
      'Ambil gambar sebarang maklumat kod kebolehkesanan';

  @override
  String get add_label_photo_button_label =>
      'Ambil gambar sebarang label & maklumat pensijilan';

  @override
  String get choose_image_source_title => 'Pilih sumber imej';

  @override
  String get choose_image_source_body => 'Sila pilih sumber imej';

  @override
  String get gallery_source_label => 'Galeri';

  @override
  String get gallery_source_access_denied_dialog_title => 'Akses ditolak';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Malangnya, aplikasi ini tidak dapat mengakses galeri anda, kerana anda telah menolak kebenaran tersebut sebelum ini.\n\nSila pergi ke tetapan aplikasi dalam Tetapan telefon anda -> Foto';

  @override
  String get gallery_source_access_denied_dialog_button => 'Buka Tetapan';

  @override
  String get share => 'Kongsi';

  @override
  String share_product_text(String url) {
    return 'Lihat produk ini di Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Lihat produk ini di Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Lihat produk ini di Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Lihat produk ini di Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Lihat senarai produk saya di Open Food Facts: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Ambil gambar';

  @override
  String get choose_from_gallery => 'Pilih daripada galeri';

  @override
  String get image_upload_queued =>
      'Imej akan dimuat naik di latar belakang secepat mungkin.';

  @override
  String get add_price_queued =>
      'Harga akan dihantar ke pelayan secepat mungkin.';

  @override
  String get background_task_title_full_refresh =>
      'Memulakan penyegaran semua produk yang disimpan secara setempat';

  @override
  String get background_task_title_folksonomy =>
      'Mula melakukan tindakan pelayan untuk kemas kini folksonomy yang disimpan secara setempat';

  @override
  String get background_task_title_top_n =>
      'Memulakan muat turun produk paling popular';

  @override
  String get expand_nutrition_facts => 'Kembangkan jadual fakta pemakanan';

  @override
  String get expand_nutrition_facts_body =>
      'Pastikan jadual fakta pemakanan dikembangkan';

  @override
  String get expand_ingredients => 'Kembangkan bahan-bahan';

  @override
  String get expand_ingredients_body => 'Pastikan panel ramuan dikembangkan';

  @override
  String get no_internet_connection => 'Tiada sambungan internet';

  @override
  String get world_results_label => 'Seluruh dunia';

  @override
  String get world_results_action => 'Luaskan pencarian anda ke seluruh dunia';

  @override
  String get copy_to_clipboard => 'Salin';

  @override
  String get paste_from_clipboard => 'Tampal dari papan keratan';

  @override
  String get no_data_available_in_clipboard =>
      'Tiada data tersedia dalam papan keratan anda';

  @override
  String get clipboard_barcode_copy => 'Salin kod bar ke papan keratan';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Kod bar $barcode disalin ke papan keratan!';
  }

  @override
  String get open_product_website => 'Buka produk ini di laman web';

  @override
  String get language_picker_label => 'Bahasa anda';

  @override
  String get country_picker_label => 'Negara anda';

  @override
  String get currency_picker_label => 'Mata wang anda';

  @override
  String get help_with_openfoodfacts => 'Bantuan dengan OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produk ini akan dikemas kini di latar belakang secepat mungkin.';

  @override
  String get no_email_client_available_dialog_title => 'Tiada aplikasi e-mel!';

  @override
  String get no_email_client_available_dialog_content =>
      'Sila hantarkan emel secara manual ke mobile@openfoodfacts.org';

  @override
  String get all_images => 'Semua Imej';

  @override
  String get selected_images => 'Imej Terpilih';

  @override
  String get product_card_remove_product_tooltip => 'Alih keluar produk';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Kod bar baharu diimbas: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Keluarkan semua produk daripada karusel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Sila imbas sekurang-kurangnya dua produk untuk membandingkannya';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Klik untuk membandingkan produk yang telah anda imbas';

  @override
  String get scan_product_loading => 'Anda telah mengimbas\nkod bar:';

  @override
  String get scan_product_loading_initial =>
      'Kami sedang mencari produk ini!\nSila tunggu beberapa saat…';

  @override
  String get scan_product_loading_long_request =>
      'Kami masih mencari produk ini!\nAdakah anda rasa ia mengambil masa yang lama untuk dimuatkan? Kami juga…';

  @override
  String get scan_product_loading_unresponsive =>
      'Kami masih mencari produk ini.\nAdakah anda ingin memulakan semula carian?';

  @override
  String get scan_product_loading_restart_button => 'Mulakan semula carian';

  @override
  String get portion_calculator_description =>
      'Kira fakta pemakanan untuk kuantiti tertentu';

  @override
  String get portion_calculator_hint => 'Kuantiti dalam';

  @override
  String get portion_calculator_accessibility =>
      'Masukkan kuantiti untuk mengira fakta pemakanan';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Sila masukkan kuantiti antara $min dan $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Data hilang. Pengiraan tidak dapat dilakukan.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Fakta pemakanan untuk $grams g (atau ml)';
  }

  @override
  String get offline_data => 'Data Luar Talian';

  @override
  String get ocr_image_upload_instruction =>
      'Muat naik imej untuk mengekstrak maklumat yang terkandung di dalamnya secara automatik.';

  @override
  String get upload_image => 'Muat Naik Foto';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Gagal memuat turun imej';

  @override
  String get image_edit_url_error =>
      'Gagal mengedit imej kerana URL imej tidak ditetapkan.';

  @override
  String get user_picture_source_remember => 'Ingat pilihan saya';

  @override
  String get user_picture_source_ask => 'Tanya setiap kali';

  @override
  String get robotoff_continue => 'Teruskan';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count soalan',
      one: 'soalan',
    );
    return 'Seterusnya $_temp0';
  }

  @override
  String get show_password => 'Tunjukkan Kata Laluan';

  @override
  String get owner_field_info_title => 'Pengeluar memberikan nilai';

  @override
  String get owner_field_info_message =>
      'Dengan logo tersebut, kami menyerlahkan data yang disediakan oleh pengeluar, dan data tersebut mungkin tidak boleh diedit.';

  @override
  String get owner_field_info_close_button => 'Tutup maklumat ini';

  @override
  String get owner_field_image =>
      'Imej ini disediakan oleh penerbit. Ia mungkin tidak boleh diedit.';

  @override
  String get edit_packagings_title => 'Komponen pembungkusan';

  @override
  String get edit_packagings_element_add => 'Tambah komponen pembungkusan';

  @override
  String get edit_packagings_completed => 'Pembungkusan sudah lengkap';

  @override
  String edit_packagings_element_title(int index) {
    return 'Komponen pembungkusan #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Bilangan unit';

  @override
  String get edit_packagings_element_hint_units =>
      'Masukkan bilangan unit pembungkusan dengan bentuk dan bahan yang sama yang terkandung dalam produk.';

  @override
  String get edit_packagings_element_field_shape => 'Bentuk';

  @override
  String get edit_packagings_element_hint_shape =>
      'Masukkan nama bentuk yang disenaraikan dalam arahan kitar semula jika ada atau pilih satu bentuk.';

  @override
  String get edit_packagings_element_example_shape => 'Botol';

  @override
  String get edit_packagings_element_field_material => 'Bahan';

  @override
  String get edit_packagings_element_hint_material =>
      'Masukkan bahan tertentu jika ia dapat ditentukan (kod bahan di dalam segitiga selalunya boleh didapati pada bahagian pembungkusan), atau bahan generik (contohnya plastik atau logam) jika anda tidak pasti.';

  @override
  String get edit_packagings_element_example_material => 'Kaca';

  @override
  String get edit_packagings_element_field_recycling => 'Arahan kitar semula';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Masukkan arahan kitar semula hanya jika ia disenaraikan pada produk.';

  @override
  String get edit_packagings_element_example_recycling => 'Kitar semula';

  @override
  String get edit_packagings_element_field_quantity =>
      'Kuantiti bersih produk seunit';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Masukkan berat bersih atau isipadu bersih dan nyatakan unitnya (contohnya g atau ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Berat satu unit kosong (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Keluarkan sebarang baki makanan dan basuh serta keringkan bahagian pembungkusan sebelum menimbang. Jika boleh, gunakan penimbang dengan ketepatan 0.1g atau 0.01g.';

  @override
  String get background_task_title => 'Sumbangan yang belum selesai';

  @override
  String get background_task_subtitle =>
      'Sumbangan anda disimpan secara automatik ke pelayan kami, tetapi tidak selalunya dalam masa nyata.';

  @override
  String get background_task_list_empty =>
      'Tiada Tugas Latar Belakang Tertangguh';

  @override
  String get background_task_error_server_time_out => 'Tamat masa pelayan';

  @override
  String get background_task_error_no_internet =>
      'Ralat sambungan internet. Cuba kemudian.';

  @override
  String get background_task_operation_unknown =>
      'jenis operasi tidak diketahui';

  @override
  String get background_task_operation_details => 'perubahan terperinci';

  @override
  String get background_task_operation_image => 'muat naik foto';

  @override
  String get background_task_operation_refresh =>
      'muat semula ditangguhkan selepas muat naik foto';

  @override
  String get background_task_run_started => 'bermula';

  @override
  String get background_task_run_not_started => 'belum bermula lagi';

  @override
  String get background_task_run_to_be_deleted => 'untuk dipadamkan';

  @override
  String get background_task_question_stop =>
      'Adakah anda mahu menghentikan tugas itu secepat mungkin?';

  @override
  String get feed_back => 'Maklum balas';

  @override
  String get undo => 'Buat asal';

  @override
  String get copy_email_to_clip_board => 'Salin e-mel ke papan keratan';

  @override
  String get please_send_us_an_email_to =>
      'Sila hantarkan emel kepada kami secara manual ke';

  @override
  String get email_copied_to_clip_board => 'E-mel disalin ke papan keratan!';

  @override
  String get select_accent_color => 'Pilih Warna Aksen';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Biru';

  @override
  String get color_cyan => 'Sian';

  @override
  String get color_green => 'Hijau';

  @override
  String get color_light_brown => 'Lalai';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Oren';

  @override
  String get color_pink => 'Merah jambu';

  @override
  String get color_red => 'Merah';

  @override
  String get color_rust => 'Karat';

  @override
  String get color_teal => 'Biru laut';

  @override
  String get text_contrast_mode => 'Kontras Teks';

  @override
  String get contrast_high => 'Tinggi';

  @override
  String get contrast_medium => 'Sederhana';

  @override
  String get contrast_low => 'Rendah';

  @override
  String get product_refresher_internet_not_found => 'Produk tidak dijumpai!';

  @override
  String get product_refresher_internet_not_connected =>
      'Anda tidak bersambung ke internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Pelayan tergendala ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Ralat pelayan ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produk tidak dijumpai!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Produk dengan kod bar berikut tidak wujud dalam pangkalan data kami: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Tiada sambungan internet!';

  @override
  String get product_loader_network_error_message =>
      'Sila pastikan telefon pintar anda berada pada rangkaian WiFi atau data mudah alih telah diaktifkan';

  @override
  String get page_not_found_title => 'Halaman tidak dijumpai!';

  @override
  String get page_not_found_button => 'Kembali ke laman utama';

  @override
  String get download_data => 'Muat turun data';

  @override
  String get download_top_products =>
      'Muat turun 1000 produk terbaik di negara anda untuk pengimbasan segera';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count teratas',
    );
    return 'Muat turun produk $_temp0 di negara anda untuk pengimbasan segera';
  }

  @override
  String get download_in_progress =>
      'Memuat turun data\nIni mungkin mengambil sedikit masa';

  @override
  String downloaded_products(int num) {
    return '$num produk telah ditambah';
  }

  @override
  String get update_offline_data => 'Kemas kini data produk luar talian';

  @override
  String get update_local_database_sub =>
      'Kemas kini pangkalan data produk tempatan dengan data terkini daripada Open Food Facts';

  @override
  String get clear_local_database => 'Kosongkan data produk luar talian';

  @override
  String get clear_local_database_sub =>
      'Kosongkan semua data produk tempatan daripada apl anda untuk mengosongkan ruang';

  @override
  String deleted_products(int num) {
    return 'Produk $num dipadam';
  }

  @override
  String get loading => 'Loading…';

  @override
  String get know_more => 'Ketahui Lebih Lanjut';

  @override
  String get offline_data_desc =>
      'Klik untuk mengetahui lebih lanjut tentang data luar talian';

  @override
  String get offline_product_data_title => 'Data produk luar talian';

  @override
  String available_for_download(int num) {
    return 'Produk $num tersedia untuk imbasan segera';
  }

  @override
  String get country_selector_title => 'Pilih negara anda:';

  @override
  String get currency_selector_title => 'Pilih mata wang anda:';

  @override
  String get language_selector_title => 'Pilih bahasa anda:';

  @override
  String get language_selector_section_selected => 'Bahasa yang dipilih';

  @override
  String get language_selector_section_frequently_used => 'Kerap digunakan';

  @override
  String get action_delete_list => 'Padam';

  @override
  String get action_change_list => 'Tukar senarai semasa';

  @override
  String get product_list_create => 'Cipta';

  @override
  String get product_list_create_tooltip => 'Cipta senarai baharu';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (New calculation)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (New calculation)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unknown Nutri-Score (New calculation)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score is not applicable';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score tidak berkenaan (Pengiraan baharu)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Skor Hijau A';

  @override
  String get environmental_score_b_new => 'Skor Hijau B';

  @override
  String get environmental_score_c_new => 'Skor Hijau C';

  @override
  String get environmental_score_d_new => 'Skor Hijau D';

  @override
  String get environmental_score_e_new => 'Skor Hijau E';

  @override
  String get environmental_score_unknown_new => 'Skor Hijau Tidak Diketahui';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score tidak berkenaan';

  @override
  String get nova_group_generic_new => 'Makanan ultra-diproses - kumpulan NOVA';

  @override
  String get nova_group_1 => 'Kumpulan NOVA 1';

  @override
  String get nova_group_2 => 'Kumpulan NOVA 2';

  @override
  String get nova_group_3 => 'Kumpulan NOVA 3';

  @override
  String get nova_group_4 => 'Kumpulan NOVA 4';

  @override
  String get nova_group_unknown => 'Kumpulan NOVA Tidak Diketahui';

  @override
  String get nutrition_facts => 'Tahap Nutrien';

  @override
  String get faq_title_partners => 'Rakan Kongsi & Penaung NGO';

  @override
  String get faq_title_vision =>
      'Visi, Misi, Nilai dan Program Fakta Makanan Terbuka';

  @override
  String get faq_title_install_beauty =>
      'Pasang Open Beauty Facts untuk mencipta pangkalan data kosmetik';

  @override
  String get faq_title_install_pet =>
      'Pasang Fakta Makanan Haiwan Peliharaan Terbuka untuk mencipta pangkalan data makanan haiwan peliharaan';

  @override
  String get faq_title_install_product =>
      'Pasang Open Products Facts untuk mencipta pangkalan data produk bagi memanjangkan hayat objek';

  @override
  String get faq_nutriscore_nutriscore =>
      'Pengiraan baharu Nutri-Score: apa yang baharu?';

  @override
  String get contact_title_pro_page =>
      'Profesional? Import produk anda dalam Fakta Makanan Terbuka';

  @override
  String get contact_title_pro_email => 'Hubungan Penerbit';

  @override
  String get contact_title_press_page => 'Halaman Akhbar';

  @override
  String get contact_title_press_email => 'Hubungan Akhbar';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'Langgan kalendar komuniti kami';

  @override
  String get hunger_games_loading_line1 => 'Tolong berikan kami beberapa saat…';

  @override
  String get hunger_games_loading_line2 => 'Kami sedang memuat turun soalan!';

  @override
  String get hunger_games_error_label =>
      'Argh! Ada masalah… dan kami tidak dapat memuatkan soalan.';

  @override
  String get hunger_games_error_retry_button => 'Jom cuba lagi!';

  @override
  String get reorder_attribute_action => 'Susun semula atribut';

  @override
  String get link_cant_be_opened =>
      'Pautan ini tidak boleh dibuka pada peranti anda. Sila pastikan anda telah memasang pelayar web.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Butiran untuk $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Butiran untuk $pageName dengan $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Kongsi';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Di mana boleh dapatkan pengiraan Nutri-Score yang baharu?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score digunakan di 7 buah negara: Perancis, Jerman, Belgium, Sepanyol, Luxembourg, Belanda dan Switzerland.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Pengilang mempunyai tempoh paling lama **2 tahun** selepas dekri ditandatangani **untuk menggantikan** pengiraan lama dengan pengiraan baharu.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'Apakah Skor Hijau?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'The Green-Score ialah logo yang bertujuan untuk memberitahu anda tentang **impak alam sekitar makanan**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Kod warna berbeza daripada hijau tua (**A+**) untuk produk **paling berkesan** kepada merah gelap (**F**) untuk produk **paling berkesan**.';

  @override
  String get guide_greenscore_logos_caption => 'Logo Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Teras: Penilaian kitaran hayat (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Penilaian saintifik bagi kategori makanan';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Untuk setiap kategori produk, skor **penanda aras** diwujudkan menggunakan data daripada pangkalan data alam sekitar Agribalyse (reka bentuk oleh ADEME dan INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Analisis kitaran hayat** ialah kaedah penilaian piawai untuk menjalankan penilaian alam sekitar berbilang peringkat dan berbilang kriteria.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Ia mengukur:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 langkah pengeluaran';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Pertanian';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Pemprosesan';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Pembungkusan';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Pangangkutan';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Pengedaran';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Penggunaan';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 penunjuk kesan alam sekitar';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'Perubahan iklim/jejak karbon';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Penipisan lapisan ozon';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Sinaran mengion';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Tanah';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Penggunaan air & tenaga';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Pencemaran udara';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Marin & air tawar (zarah, pengasidan, eutrofikasi)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Kehabisan sumber.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonus & penalti';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Untuk memberi ganjaran kepada produk yang lebih baik dalam sesuatu kategori, kami kemudiannya akan mengenakan **bonus & penalti berdasarkan beberapa kriteria**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Bonus** diberikan kepada produk yang mempunyai **label rasmi, label atau pensijilan yang menjamin manfaat alam sekitar** (organik, perdagangan adil, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Asal-usul bahan ramuan';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Bonus** diberikan berdasarkan asal usul bahan-bahan tersebut. Bonus ini mengambil kira **kesan ke atas pengangkutan** dan juga **dasar alam sekitar** setiap negara pengeluar.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Penalti** diberikan kepada produk yang mengandungi bahan-bahan yang mempunyai **kesan negatif yang ketara terhadap biodiversiti dan ekosistem**, seperti minyak sawit, yang pengeluarannya bertanggungjawab terhadap penebangan hutan secara besar-besaran.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Pembungkusan';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Penalti** dikira untuk mengambil kira **keliling pembungkusan** (penggunaan bahan mentah kitar semula dan kebolehkitar semula) dan pembungkusan berlebihan.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Untuk mengira Skor Hijau dengan tepat, adalah perlu untuk mempunyai **maklumat yang tidak semestinya dinyatakan pada pembungkusan** (seperti asal usul dan peratusan tepat setiap ramuan) atau yang jarang terdapat dalam bentuk yang boleh digunakan (seperti senarai semua komponen pembungkusan dengan jenis plastik yang digunakan dengan tepat).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Nilai purata digunakan apabila maklumat ini belum tersedia**, tetapi kami kini menyeru semua orang untuk membantu kami mengumpulkan maklumat ini yang akan sangat berguna untuk Skor Hijau tetapi juga untuk banyak kegunaan lain.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Bagaimanakah warganegara boleh membantu?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Semua warganegara boleh membantu kami mengumpulkan dan menstrukturkan maklumat yang terdapat pada produk atau yang boleh disimpulkan daripadanya, seperti maklumat tentang **pembungkusan**: \"Mission Emballages\": inventori pembungkusan kolaboratif berskala besar untuk semua produk makanan (dalam bahasa Perancis).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Bagaimana pengilang boleh membantu';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Pengilang boleh menghantar maklumat mereka terus kepada kami melalui platform percuma kami untuk pengeluar.';

  @override
  String get guide_greenscore_better_product_title =>
      'Produk manakah yang lebih baik untuk planet ini?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Ia boleh menjadi sukar untuk diberitahu';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Memilih makanan yang mampan ialah salah satu perkara paling berkuasa yang boleh kita lakukan untuk iklim, kerana **sistem makanan global kita bertanggungjawab untuk lebih satu perempat daripada semua pelepasan gas rumah hijau**.\n(Sumber: Poore & Nemecek, Sains, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title =>
      'Anda mempunyai kuasa!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Berita baiknya ialah ini memberi kita cara yang berkesan untuk mencipta perubahan.\n**Setiap daripada kita makan sekitar 1,000 hidangan setiap tahun**. Itulah 1,000 peluang untuk **memilih masa depan yang lebih baik untuk planet ini**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Membantu untuk bertanggungjawab dan membuat keputusan';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Memilih makanan yang mampan boleh terasa rumit. Label mengelirukan dan maklumat sering hilang. Green-Score dicipta untuk menjadikannya mudah, memberikan anda penilaian alam sekitar **jelas**, **berasaskan sains** dan **telus** untuk produk makanan, tepat di tempat yang anda perlukan: semasa anda membeli-belah.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Ketelusan';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Tidak seperti label proprietari, pengiraan Green-Score **terbuka sepenuhnya** dan boleh **disahkan oleh sesiapa sahaja**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'Apakah pemprosesan ultra?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Kumpulan NOVA memberitahu anda tentang tahap pemprosesan makanan.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Klasifikasi NOVA membenarkan pengkategorian makanan kepada **4 kumpulan** berdasarkan **darjah pemprosesan industri** mereka (makanan diproses atau tidak diproses secara minimum, bahan masakan, makanan diproses, makanan ultra-diproses).';

  @override
  String get guide_nova_logos_caption => 'Logo NOVA';

  @override
  String get guide_nova_groups_title => '4 kumpulan NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Terdapat 4 kumpulan NOVA, yang bermasalah ialah Kumpulan 4 - Makanan ultra-proses.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Makanan yang diproses secara minimum atau tidak diproses';

  @override
  String get guide_nova_groups_arg1_text =>
      'Makanan yang tidak diproses (atau semula jadi) ialah **bahagian tumbuhan** (biji, buah, daun, batang, akar) **atau haiwan** (otot, organ, telur, susu) yang boleh dimakan, serta kulat, alga dan air, selepas diasingkan daripada alam semula jadi.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 Foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** Foods. Processes include Various preservation Or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed Foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can Be eaten On their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include Those also found in Processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of energy And nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, Lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Masalah dengan pemprosesan ultra';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Pemprosesan bahan makanan yang melampau';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Kebanyakannya **diperoleh daripada pemprosesan lanjut juzuk makanan**, seperti minyak terhidrogenasi atau minyak yang diinteresterifikasi, protein terhidrolisis, isolat protein soya, maltodekstrin, gula invert dan sirap jagung fruktosa tinggi.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Aditif yang melampaui keselamatan makanan tulen';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Bahan tambahan dalam makanan ultra-proses termasuk beberapa bahan yang juga digunakan dalam makanan yang diproses, seperti pengawet, antioksidan dan penstabil. Kelas bahan tambahan yang hanya terdapat dalam produk ultra-proses termasuk yang digunakan **untuk meniru atau meningkatkan kualiti deria makanan atau untuk menyembunyikan aspek produk akhir yang tidak sedap**. Bahan tambahan ini termasuk pewarna dan warna lain, penstabil warna; perisa, penambah perisa, pemanis bukan gula; dan alat bantu pemprosesan seperti agen pengkarbonan, penegangan, pemunculan dan anti-pemunculan, agen penyahbuih, anti-penggumpalan dan penggilapan, pengemulsi, sekuestran dan humektan.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Pemprosesan yang anda tidak boleh lakukan di rumah';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Pelbagai urutan proses digunakan** untuk menggabungkan bahan-bahan yang biasanya banyak dan menghasilkan produk akhir (oleh itu \'ultra-diproses\'). Proses-proses tersebut merangkumi beberapa **tanpa setara domestik**, seperti penghidrogenan dan hidrolisis, penyemperitan dan pengacuan, dan pra-pemprosesan untuk menggoreng.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Aspek pemangsa dan kewangan pemprosesan ultra';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Tujuan keseluruhan pemprosesan ultra adalah untuk menghasilkan produk makanan berjenama**, **mudah** (tahan lama, sedia untuk dimakan), **menarik** (hiper-sedan) dan **sangat menguntungkan** (bahan-bahan kos rendah) yang direka untuk menggantikan semua kumpulan makanan lain. Produk makanan ultra-proses biasanya dibungkus dengan menarik dan dipasarkan secara intensif.';

  @override
  String get guide_nova_explanations_arg5_title => 'Bahaya kesihatan';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Sejak tahun 2018, dengan NutriNet-Santé, kaitan pertama antara **pengambilan makanan ultra-proses dan peningkatan risiko kanser, penyakit kardiovaskular dan diabetes telah ditonjolkan**. Hari ini, lebih daripada 90 kajian di seluruh dunia mengesahkan penemuan ini.\nKaitan paling kuat berkaitan dengan **obesiti, kematian kardiovaskular dan simptom kemurungan**. Pada kanak-kanak, kesannya terutamanya diperhatikan pada ketidakseimbangan berat badan dan lipid.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Negara-negara mengesyorkan mengehadkannya';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Sesetengah negara menggunakan kumpulan NOVA untuk garis panduan atau matlamat diet mereka, contohnya:\n\n- **🇧🇷 Garis panduan diet Brazil** **mengesyorkan untuk mengehadkan penggunaan** makanan yang diproses dan mengelakkan makanan yang terlalu diproses.\n\n- **🇫🇷 Matlamat dasar pemakanan kesihatan awam Perancis** untuk 2018-2022 bertujuan untuk **mengurangkan penggunaan makanan yang terlalu diproses kumpulan 4 sebanyak 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-ms.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Selamat datang ke Fakta Makanan Terbuka!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Apakah Fakta Makanan Terbuka?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts ialah pangkalan data **kolaboratif**, **percuma** dan **terbuka** yang mengandungi produk makanan dari seluruh dunia.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Kami percaya bahawa setiap orang harus mempunyai akses kepada maklumat tentang apa yang mereka makan. Dengan mengumpul data tentang bahan-bahan, alergen, fakta pemakanan dan banyak lagi, **kami memperkasakan pengguna untuk membuat pilihan yang tepat** dan memacu industri makanan **ke arah ketelusan yang lebih tinggi**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Ciri-ciri Fakta Makanan Terbuka';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Dapatkan makluman untuk bahan-bahan yang tidak diingini';

  @override
  String get guide_open_food_facts_tips_title =>
      'Petua untuk mengambil gambar yang hebat';

  @override
  String get guide_open_food_facts_tips_arg1_title =>
      'Perkara yang tidak boleh dilakukan';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Elakkan bayang-bayang dan silau.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Tiada teks kabur atau tidak fokus.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Jangan potong bahagian teks.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Elakkan latar belakang yang sibuk.';

  @override
  String get guide_open_food_facts_tips_arg2_title =>
      'Perkara yang perlu dilakukan';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Gunakan pencahayaan yang baik dan sekata.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Pastikan teks jelas dan mudah dibaca.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Catatkan keseluruhan senarai ramuan.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Letakkan produk di atas permukaan yang rata.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Bantu kami membina \"Wikipedia Makanan\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Skor pada kualiti pemakanan';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Skor untuk mengelakkan makanan ultra-proses';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Skor untuk planet ini';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-ms.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Selamat datang ke Fakta Makanan Haiwan Peliharaan Terbuka!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Apakah Fakta Makanan Haiwan Peliharaan Terbuka?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts melanjutkan misi kami kepada rakan-rakan berbulu kami! Ia merupakan **pangkalan data produk makanan haiwan peliharaan untuk kucing, anjing dan haiwan peliharaan lain**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Kami mengumpulkan maklumat tentang **ramuan**, **analisis pemakanan** dan garis panduan pemberian makanan untuk membantu pemilik haiwan peliharaan memilih makanan terbaik untuk keperluan haiwan mereka.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Ciri-ciri Fakta Makanan Haiwan Peliharaan Terbuka';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Dapatkan makluman untuk bahan-bahan yang tidak diingini';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Adakah haiwan peliharaan anda alah kepada sebarang bahan? Anda boleh menetapkan senarai bahan kosmetik yang perlu dielakkan, terus dalam aplikasi!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Petua untuk mengambil gambar yang hebat';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title =>
      'Perkara yang tidak boleh dilakukan';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Elakkan bayang-bayang dan silau.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Tiada teks kabur atau tidak fokus.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Jangan potong bahagian teks.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Elakkan latar belakang yang sibuk.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title =>
      'Perkara yang perlu dilakukan';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Gunakan pencahayaan yang baik dan sekata.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Pastikan teks jelas dan mudah dibaca.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Catatkan keseluruhan senarai ramuan.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Letakkan produk di atas permukaan yang rata.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Nota tentang pemarkahan';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Membangunkan sistem pemarkahan untuk makanan haiwan peliharaan **bukanlah keutamaan buat masa ini**. Metodologinya akan menjadi rumit, kerana keperluan pemakanan sangat berbeza mengikut spesies, umur dan keadaan kesihatan. Kami belum menemui mana-mana pasukan saintifik bebas yang dapat membangunkan skor sedemikian.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-ms.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Selamat datang ke Fakta Kecantikan Terbuka!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Apakah Fakta Kecantikan Terbuka?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts ialah pangkalan data kolaboratif **produk kosmetik**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Matlamat kami adalah untuk mentafsir senarai ramuan bagi membantu anda **memahami kandungan dalam barangan penjagaan diri anda**. Daripada pelembap hinggalah solekan, kami mengumpul data tentang ramuan, alergen dan pembungkusan untuk menggalakkan ketelusan dalam industri kosmetik.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Ciri-ciri Fakta Kecantikan Terbuka';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Dapatkan makluman untuk bahan-bahan yang tidak diingini';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Adakah anda alah kepada mana-mana bahan? Ingin mengelakkan bahan komedogen? Ingin menjauhi komponen kontroversi? Anda boleh menetapkan senarai bahan kosmetik untuk dielakkan, terus dalam aplikasi!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Petua untuk mengambil gambar yang hebat';

  @override
  String get guide_open_beauty_facts_tips_arg1_title =>
      'Perkara yang tidak boleh dilakukan';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Elakkan bayang-bayang dan silau.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Tiada teks kabur atau tidak fokus.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Jangan potong bahagian teks.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Elakkan latar belakang yang sibuk.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title =>
      'Perkara yang perlu dilakukan';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Gunakan pencahayaan yang baik dan sekata.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Pastikan teks jelas dan mudah dibaca.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Catatkan keseluruhan senarai ramuan.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Ambil seberapa banyak gambar yang diperlukan jika botol itu melengkung.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Anda mungkin perlu membuka label untuk melihat senarai ramuan.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Letakkan produk di atas permukaan yang rata.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Nota tentang pemarkahan';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Tidak seperti produk makanan, dunia kosmetik **tidak mempunyai sistem pemarkahan yang diiktiraf secara universal dan disokong oleh kerajaan seperti Nutri-Score**. Kesan ramuan boleh menjadi sangat peribadi dan bergantung pada jenis kulit, alahan dan masalah individu.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-ms.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices ialah projek untuk **mengumpul dan berkongsi harga produk di seluruh dunia**. Ia merupakan set data yang tersedia secara umum yang boleh digunakan untuk penyelidikan, analisis dan banyak lagi. Open Prices dibangunkan dan diselenggara oleh Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Kami sedang mengumpul dataset harga sumber terbuka**. Harga boleh ditambah oleh pengguna melalui aplikasi web ini atau melalui aplikasi mudah alih rasmi Open Food Facts. Peruncit atau aplikasi pihak ketiga juga boleh menyumbang dengan menggunakan API kami.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Kumpulkan gambar tanda harga di lorong';

  @override
  String get guide_open_prices_how_arg2_title => 'Kumpulkan gambar resit';

  @override
  String get guide_open_prices_why_title =>
      'Mengapakah Open Food Facts melakukan ini?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Maklumat harga adalah sangat penting untuk memahami sistem makanan. Ia merupakan faktor utama dalam memahami kos makanan dan untuk menggalakkan diet yang lebih sihat. Data harga pembukaan merupakan cara untuk memudahkan penyelidik, wartawan dan rakyat untuk **mempunyai pemahaman yang lebih baik tentang bagaimana harga makanan berubah mengikut geografi dan masa**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Jejaki evolusi harga dari semasa ke semasa';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Lihat **evolusi harga**: pengecutan inflasi, inflasi murah, kita boleh menjejakinya bersama-sama!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Bandingkan harga berhampiran anda';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Apabila kami mendapat lebih banyak harga, anda boleh melihat **kedai termurah di sekitar anda**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Adakah anda mempertimbangkan untuk mendapatkan harga daripada laman web peruncit?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Anda boleh menyumbang harga dengan menggunakan API kami.\nJika anda ingin menyumbang harga secara berskala, sila hubungi kami di prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Selamat datang ke Fakta Produk Terbuka!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Apakah Fakta Produk Terbuka?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts ialah pangkalan data terbuka yang besar untuk **mana-mana produk dengan kod bar, yang bukan makanan, kosmetik atau makanan haiwan peliharaan**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Daripada **elektronik** kepada **mainan**, dan **pakaian** kepada **bekalan pembersihan**, jika ia mempunyai kod bar, ia boleh ditambah. Projek ini bertujuan untuk mewujudkan \"Internet Pelbagai Benda\" untuk objek harian, menjadikan maklumat tentangnya boleh diakses secara universal.';

  @override
  String get guide_open_products_facts_features_title =>
      'Ciri-ciri Fakta Produk Terbuka';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts bertujuan untuk menyediakan pengguna **memanjangkan jangka hayat objek** dengan menyediakan penyelesaian bulat untuk menyelenggara, **membaiki**, **mengitar semula** objek mereka atau memberi mereka pemilik baharu.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Jejak karbon untuk sesetengah produk';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impak CO2** oleh Pihak Berkuasa Alam Sekitar Perancis ADEME menyediakan **kesan karbon** bagi pelbagai kategori, pastikan anda mengkategorikan produk dengan tepat.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Indeks kebolehbaikan untuk banyak produk';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Apabila indeks kebolehbaikan Perancis tersedia, kami akan memaparkannya. Selain itu, **anda boleh mula mengumpul pembolehubah menggunakan Enjin Folksonomy**; supaya kami boleh mengiranya semula pada masa hadapan, walaupun di negara yang tidak menyediakannya.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Cari cara untuk menderma/menjual semula produk anda';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Kami menyediakan pautan ke **perkhidmatan mesra pekeliling pihak ketiga** yang membantu anda mendapatkan jenis produk yang anda cari, sebagai produk terpakai, agar lebih berhati-hati terhadap sumber planet.\nSila ambil perhatian bahawa kami tidak dibayar untuk berbuat demikian, dan sistem ini hanya berfungsi sebagai contoh untuk dua laman web di Perancis. Anda boleh membantu mengembangkan sistem ini dengan mendokumentasikan lebih banyak laman web di wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Maklumat apa yang berguna?';

  @override
  String get guide_open_products_facts_information_text =>
      'Untuk pelbagai jenis item, **data yang kami kumpulkan adalah fleksibel**. Untuk berbuat demikian, **kami telah mencipta Enjin Folksonomy**.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'Enjin Folksonomi';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Enjin Folksonomy ialah alat untuk membantu anda melengkapkan produk dengan ciri-ciri yang berkaitan. Ini membantu meningkatkan carian dan kebolehtemuan, tetapi juga mengira dan memaparkan perkara yang menarik pada masa hadapan.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Anda boleh menambah sebarang kekunci dan nilai seperti: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Anda akan mendapat cadangan automatik tentang kemungkinan ciri-ciri, dan anda dialu-alukan untuk menambah dan mendokumentasikan ciri-ciri baharu pada jenis produk kegemaran anda.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-ms.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Pilihan makanan terbuka';

  @override
  String get guide_coming_soon_button_title => 'Akan datang tidak lama lagi';

  @override
  String get guide_learn_more_subtitle => 'Ketik untuk mengetahui lebih lanjut';

  @override
  String get preview_badge => 'Pratonton';

  @override
  String get prices_feedback_form =>
      'Klik di sini untuk menghantar maklum balas anda tentang ciri baharu ini!';

  @override
  String get menu_button_list_actions => 'Pilih tindakan';

  @override
  String get error_loading_photo => 'Ralat memuatkan foto';

  @override
  String get photo_viewer_action_use_picture_as => 'Gunakan sebagai…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Gunakan gambar ini sebagai…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Gunakan gambar ini sebagai… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Butiran';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Butiran foto ini';

  @override
  String get photo_viewer_details_title => 'Butiran foto';

  @override
  String get photo_viewer_details_contributor_title => 'Contributor';

  @override
  String get photo_viewer_details_size_title => 'Saiz';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height piksel';
  }

  @override
  String get photo_viewer_details_date_title => 'Tarikh';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Serasi';

  @override
  String get user_lists_action_multi_select => 'Pelbagai pilihan';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Skor keserasian anda: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Gambar hadapan';

  @override
  String get product_image_ingredients_accessibility_label => 'Gambar ramuan';

  @override
  String get product_image_nutrition_accessibility_label => 'Gambar pemakanan';

  @override
  String get product_image_packaging_accessibility_label =>
      'Gambar pembungkusan';

  @override
  String get product_image_other_accessibility_label => 'Gambar lain';

  @override
  String get product_image_outdated_message =>
      'Gambar ini mungkin sudah ketinggalan zaman';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (imej ini mungkin sudah ketinggalan zaman)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (imej ini mungkin dikunci oleh penerbit)';
  }

  @override
  String get product_image_error => 'Tidak dapat memuatkan imej!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Tidak dapat memuatkan $type (ralat rangkaian?)';
  }

  @override
  String get product_page_image_no_image_available => 'Tiada imej\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Tiada gambar tersedia untuk produk ini';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Susun semula atau sembunyikan tindakan';

  @override
  String get product_page_action_bar_setting_modal_title => 'Edit tindakan';

  @override
  String get product_page_action_bar_item_move_up => 'Bergerak ke atas';

  @override
  String get product_page_action_bar_item_move_down => 'Bergerak ke bawah';

  @override
  String get product_page_action_bar_item_enable => 'Dayakan tindakan';

  @override
  String get product_page_action_bar_item_disable => 'Lumpuhkan tindakan';

  @override
  String get product_page_pending_operations_banner_title =>
      'Memuat naik suntingan anda…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Data yang dipaparkan pada halaman ini **belum lagi mencerminkan pengubahsuaian anda**.\nSila tunggu beberapa saat…';

  @override
  String get product_add_a_language => 'Tambah bahasa';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Kod Bar $barcode';
  }

  @override
  String get carousel_close_tooltip =>
      'Alih keluar produk ini daripada karusel';

  @override
  String get carousel_unsupported_header => 'Kod bar tidak disokong!';

  @override
  String get carousel_unsupported_title => 'Aduh!';

  @override
  String get carousel_unsupported_text =>
      'Kod bar yang diimbas tidak disokong oleh Open Food Facts!';

  @override
  String get carousel_error_header => 'Ralat!';

  @override
  String get carousel_error_title => 'Ia satu penyesalan!';

  @override
  String get carousel_error_text_1 =>
      'Kami tidak dapat memuat turun maklumat pada kod bar ini:';

  @override
  String get carousel_error_text_2 =>
      'Sila semak sambungan Internet anda atau klik butang ini:';

  @override
  String get carousel_error_button => 'Cuba lagi';

  @override
  String get carousel_unknown_product_header => 'Produk tidak diketahui';

  @override
  String get carousel_unknown_product_title =>
      'Tahniah!\nAnda telah menemui __permata yang jarang ditemui!__';

  @override
  String get carousel_unknown_product_text =>
      'Pangkalan data kolaboratif kami mengandungi lebih daripada **3 juta produk**, tetapi kod bar ini tidak wujud: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'Memuatkan maklumat...';

  @override
  String get carousel_loading_title =>
      'Anda baru sahaja mengimbas produk dengan kod bar berikut:';

  @override
  String get carousel_loading_text =>
      'Kami sedang mencarinya dalam pangkalan data kami yang mengandungi lebih daripada **3 juta produk!**';

  @override
  String get product_type_subtitle_food =>
      'Sayur-sayuran, buah-buahan, makanan sejuk beku…';

  @override
  String get product_type_subtitle_beauty => 'Solekan, sabun, ubat gigi…';

  @override
  String get product_type_subtitle_pet_food => 'Makanan untuk anjing, kucing…';

  @override
  String get product_type_subtitle_product => 'Telefon pintar, perabot…';

  @override
  String get photo_field_front => 'Foto produk';

  @override
  String get photo_field_ingredients => 'Foto ramuan';

  @override
  String get photo_field_nutrition => 'Foto pemakanan';

  @override
  String get photo_field_packaging => 'Foto arahan kitar semula';

  @override
  String get photo_already_exists => 'Foto ini sudah wujud';

  @override
  String get photo_missing => 'Foto ini tiada';

  @override
  String get date => 'Tarikh';

  @override
  String get photo_rotate_left => 'Pusing kiri';

  @override
  String get photo_rotate_right => 'Pusing kanan';

  @override
  String get photo_undo_action => 'Batalkan tindakan sebelumnya';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Peta dunia $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Penyumbang OpenStreetMap';

  @override
  String get not_applicable_short => 'Tidak Ada';

  @override
  String get knowledge_panel_warning_text => 'Amaran';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Mengapakah Nutri-Score ini berbeza daripada yang tertera pada pakej?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Terdapat dua kemungkinan penjelasan:\nSenarai ramuan dan/atau fakta pemakanan tidak terkini.\n\nKami menyediakan \"Pengiraan baharu\" bagi Nutri-Score (atau V2). Sila pastikan anda mempunyai sepanduk \"Pengiraan baharu\" pada bungkusan.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Semak bahan-bahan';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Semak fakta pemakanan';

  @override
  String url_not_supported(String url) {
    return 'Malangnya, kami tidak dapat membuka URL:\n$url';
  }

  @override
  String get product_list_export => 'Eksport';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'Lihat kod bar';

  @override
  String get product_footer_action_barcode_short => 'Barkod';

  @override
  String get product_footer_action_open_website => 'Buka laman web';

  @override
  String get product_footer_action_report => 'Laporan';

  @override
  String get product_footer_action_contributor_guide => 'Bantuan';

  @override
  String get product_footer_action_data_quality_tags => 'Kualiti data';

  @override
  String get product_page_tab_for_me => 'Bagi saya';

  @override
  String get product_page_tab_website => 'Laman Web';

  @override
  String get product_page_tab_prices => 'Harga';

  @override
  String get prices_explanation_card_title => 'Kenapa harga?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** ialah projek mengumpul dan berkongsi harga produk di seluruh dunia 🌍. Open Prices dibangunkan dan diselenggara oleh Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Ketahui lebih lanjut';

  @override
  String get product_page_tab_folksonomy => 'Folksonomi';

  @override
  String get folksonomy_explanation_card_title =>
      'Apakah sifat-sifat Folksonomi?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atribut adalah berdasarkan **nilai kunci**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Sifat ini dicipta dan difailkan oleh penyumbang untuk sebarang jenis penggunaan.';

  @override
  String get folksonomy_action_external_link_title => 'Buka pautan luaran';

  @override
  String get folksonomy_action_external_link_warning =>
      'Pautan luar mungkin tidak selamat. Adakah anda benar-benar mahu melawatnya?';

  @override
  String get prices_products_empty_title => 'Tiada harga tersedia';

  @override
  String get prices_products_empty_explanation =>
      'Jadilah yang pertama menyumbang!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Produk $pageSize teratas (jumlah: $total)';
  }

  @override
  String get app_review_title => 'Adakah anda menikmati aplikasi ini?';

  @override
  String get app_review_low => 'Boleh buat lebih baik';

  @override
  String get app_review_medium => 'Tidak teruk';

  @override
  String get app_review_high => 'Saya sukakannya!';

  @override
  String get app_review_feedback_modal_title =>
      'Bantu kami menambah baik aplikasi kami';

  @override
  String get app_review_feedback_modal_content =>
      'Jika anda mempunyai beberapa minit, bolehkah anda menjawab borang ini supaya **kami dapat menambah baik kemas kini akan datang**:';

  @override
  String get app_review_feedback_modal_open_form => 'Jawab borang tersebut';

  @override
  String get app_review_feedback_modal_later => 'Tanya saya kemudian';

  @override
  String get nutrition_facts_extract_new =>
      'BARU: Anda boleh mengekstrak nutrien daripada gambar secara automatik!';

  @override
  String get nutrition_facts_extract_button_text => 'Ekstrak sekarang';

  @override
  String get nutrition_facts_extract_in_progress =>
      'Pengekstrakan sedang dijalankan…';

  @override
  String get nutrition_facts_extract_successful => 'Pengekstrakan berjaya';

  @override
  String get nutrition_facts_extract_failed =>
      'Gagal mengekstrak nutrien daripada gambar';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Statistik';

  @override
  String get prices_stats_title => 'Statistik Harga';

  @override
  String get prices_stats_prices_section => 'Harga';

  @override
  String get prices_stats_products_section => 'Produk';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Pelbagai';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Penggunaan';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Makanan';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Produk';

  @override
  String get prices_stats_pet_food => 'Makanan haiwan peliharaan';

  @override
  String get prices_stats_osm => 'Peta Jalan Terbuka';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Negara-negara';

  @override
  String get prices_stats_price_tag => 'Tanda harga';

  @override
  String get prices_stats_receipt => 'Resit';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Laman Web';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'Kemas kini terakhir pada';

  @override
  String get prices_stats_error => 'Ralat berlaku semasa memuatkan statistik.';

  @override
  String get product_edit_robotoff_question_answered => 'Soalan terjawab!';

  @override
  String get product_edit_robotoff_proof => 'Bukti';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'Harga';

  @override
  String get preferences_prices_subtitle => 'Urus pilihan harga anda';

  @override
  String get preferences_card_project => 'Projek Fakta Makanan Terbuka';

  @override
  String get preferences_contribute_title => 'Sumbang';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'perangkaan saya';

  @override
  String get preferences_contribute_subtitle =>
      'Terjemah, perbaiki alatan kami…';

  @override
  String get preferences_connect_title => 'Sambung';

  @override
  String get preferences_connect_subtitle =>
      'Hubungi kami, atau Ikuti kami di media sosial';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Bantu kami memaklumkan berjuta-juta pengguna di seluruh dunia';

  @override
  String get preferences_card_help => 'Bantuan & Sokongan';

  @override
  String get preferences_faq_title => 'SOALAN-SOALAN LAZIM';

  @override
  String get preferences_faq_subtitle => 'Dapatkan jawapan kepada soalan anda';

  @override
  String get logged_out => 'Log keluar';

  @override
  String get preferences_app_bar_message =>
      'Terima kasih kerana menjadi salah seorang ahli kami!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Lihat semua statistik';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Cari $provider untuk \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Cari tetapan (cth Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Kebolehaksesan: Tunjukkan emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Kebolehcapaian: Alih keluar warna';

  @override
  String get preferences_app_settings_products => 'Produk';

  @override
  String get preferences_card_about => 'Tentang';

  @override
  String get preferences_legal_information_title => 'Maklumat undang-undang';

  @override
  String get preferences_legal_information_subtitle =>
      'Syarat penggunaan, dasar privasi dan banyak lagi';

  @override
  String get preferences_terms_of_use => 'Syarat-syarat penggunaan';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts ialah pangkalan data produk makanan **dibuat oleh semua orang, untuk semua orang**.\nAnda boleh menggunakannya untuk membuat pilihan makanan yang lebih baik, dan kerana ia adalah **data terbuka**, sesiapa sahaja boleh **menggunakannya semula untuk sebarang tujuan**.';

  @override
  String get preferences_privacy_policy => 'Dasar privasi';

  @override
  String get preferences_licenses => 'Lesen';

  @override
  String get preferences_about_app_title => 'Mengenai apl';

  @override
  String get preferences_about_app_subtitle =>
      'Maklumat teknikal, maklumat pembangun dan banyak lagi';

  @override
  String get preferences_card_information => 'Information';

  @override
  String get preferences_version_number_title => 'Nombor versi';

  @override
  String get preferences_scanner_title => 'Pengimbas';

  @override
  String get preferences_app_store => 'Kedai aplikasi';

  @override
  String get preferences_app_system_settings => 'Tetapan sistem';

  @override
  String get preferences_source_code => 'Akses kod sumber';

  @override
  String get preferences_source_code_subtitle =>
      'Dan mula memberi kesan kepada berjuta-juta';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Produk lengkap';

  @override
  String get preferences_tips => 'Petua';

  @override
  String get tips_discover_nutriscore => 'Temui Nutri-Score baharu';

  @override
  String get preferences_on_off_website_subtitle =>
      'Di laman web Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Urus akaun saya';

  @override
  String get preferences_manage_account_tooltip => 'Urus akaun anda';

  @override
  String get preferences_change_password_title => 'Tukar kata laluan saya';

  @override
  String get preferences_danger_zone => 'Zon bahaya';

  @override
  String get preferences_account_deletion_subtitle =>
      'Semua sumbangan anda akan hilang';

  @override
  String get preferences_contributions_title => 'Contributions';

  @override
  String get preferences_dev_mode_app_settings_title => 'Tetapan apl';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Cara yang sangat eksperimen untuk mengimbas produk di luar talian';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Muat semula semua produk daripada pelayan';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Tolong elakkan daripada melakukan itu melainkan benar-benar perlu';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Mod demo';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Tambahkan kad pada pengimbas';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Menambah 3 sampel produk pada pengimbas';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'Hos Folksonomy';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Hos: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Percubaan kebolehaksesan';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Pilihan berbilang produk untuk harga';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Panel pengetahuan pesanan pengguna';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Akses sementara ke carian lokasi';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Perbandingan sebelah menyebelah untuk 2 atau 3 produk';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Import senarai produk';

  @override
  String get preferences_faq_scores_methodologies_title => 'Skor & metodologi';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Ketahui cara Nutri-Score dikira';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Temui perubahan utama kepada metodologi';

  @override
  String get preferences_faq_discover_project_title => 'Temuilah projek';

  @override
  String get preferences_faq_discover_off_title => 'Temui Open Food Facts';

  @override
  String get preferences_faq_discover_obf_title =>
      'Temui Fakta Kecantikan Terbuka';

  @override
  String get preferences_faq_discover_opff_title =>
      'Temui Fakta Makanan Haiwan Peliharaan Terbuka';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title => 'Temui Fakta Produk Terbuka';

  @override
  String get preferences_faq_faq_title => 'Soalan Lazim - Soalan Lazim';

  @override
  String get preferences_faq_off_ngo_title => 'NGO Open Food Facts';

  @override
  String get preferences_about_information_title => 'Information';

  @override
  String get preferences_connect_community_updates_title =>
      'Dapatkan kemas kini komuniti';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Ikuti perkembangan dengan berita apl dan komuniti';

  @override
  String get preferences_connect_community_calendar_title =>
      'Langgan kalendar komuniti kami';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Terlibat dengan menghadiri salah satu acara maya kami';

  @override
  String get preferences_connect_blog_title => 'Blog Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Dapatkan berita terkini, semasa ia berlaku';

  @override
  String get preferences_connect_community_help_title =>
      'Dapatkan bantuan daripada komuniti';

  @override
  String get preferences_connect_improve_app_title =>
      'Bantu kami menambah baik apl';

  @override
  String get preferences_connect_debug_info_title =>
      'Hantarkan maklumat nyahpepijat kepada kami';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Hantarkan e-mel kepada kami dengan maklumat penyahpepijatan terperinci';

  @override
  String get preferences_connect_feedback_title =>
      'Hantar maklum balas kepada kami tentang apl itu';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Bantu membentuk masa depan apl';

  @override
  String get preferences_connect_survey_title => 'Ambil tinjauan apl';

  @override
  String get preferences_connect_survey_subtitle =>
      'Bantu kami memahami perkara yang perlu kami bina seterusnya';

  @override
  String get preferences_connect_professionals_title => 'Profesional';

  @override
  String get preferences_connect_pro_subtitle =>
      'Percuma sepenuhnya, memastikan data tepat untuk 500 apl & berjuta-juta pengguna. Layan diri, serasi dengan PIM atau hamparan (XLSX) anda';

  @override
  String get preferences_connect_pro_email_subtitle => 'Hubungi untuk bermula';

  @override
  String get preferences_connect_press_title => 'Akhbar';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Dapatkan semua bahan yang anda perlukan untuk laporan anda';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Hubungi kami untuk pertanyaan akhbar atau untuk memberitahu kami tentang laporan anda';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Menjadi sukarelawan yang aktif';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Pembangunan, Komunikasi, Reka Bentuk… sebarang jenis sukarelawan atau kepakaran dialu-alukan!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Temui beberapa daripada banyak cara anda boleh menyumbang';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Pembangunan aplikasi mudah alih';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Ketahui cara menyumbang kepada pembangunan perisian';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Binaan harian yang tidak stabil, ciri baharu';

  @override
  String get preferences_contribute_local_community_title =>
      'Kembangkan komuniti setempat anda';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Bantuan dengan perisian, kandungan, terjemahan analisis ramuan';

  @override
  String get preferences_contribute_share_subtitle =>
      'Kami telah menyediakan sedikit templat untuk membantu anda :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Langkah mudah untuk mengembangkan ketelusan makanan di negara anda';

  @override
  String get preferences_contribute_data_quality_title => 'Kualiti data';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Sertai pasukan kualiti data';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Sertai usaha kami untuk memastikan pangkalan data adalah lengkap dan tepat';

  @override
  String get preferences_contributions_products_added_title =>
      'Produk tambahan';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Produk baharu yang saya tambahkan pada Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produk yang perlu saya siapkan';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Semua produk tidak lengkap';

  @override
  String get preferences_my_contributions_prices_title => 'Harga';

  @override
  String get preferences_my_contributions_my_prices_title => 'Harga saya';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Harga saya, bukti saya…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produk yang boleh anda bantu selesaikan';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Bantu mengira Nutri-Score & Green-Score di negara anda';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Harga yang saya sumbangkan';

  @override
  String get preferences_prices_proofs_subtitle => 'Tanda harga dan resit';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Ambil foto resit anda dan imbas kod bar yang berkaitan';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Ambil gambar harga di kedai';

  @override
  String get preferences_prices_newest_title => 'Harga terbaru';

  @override
  String get preferences_prices_newest_subtitle =>
      'Harga terkini ditambah oleh komuniti Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Penyumbang dengan harga terbanyak';

  @override
  String get preferences_prices_metrics_title => 'Metrik Harga Terbuka';

  @override
  String get preferences_prices_metrics_subtitle => 'Ikuti evolusi projek';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Cara untuk menyumbang';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Sahkan harga yang ditambahkan oleh anda sendiri atau orang lain, dengan bantuan AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Tambah banyak resit atau foto rak daripada gulungan kamera anda dengan cepat';

  @override
  String get preferences_prices_challenges_title => 'Cabaran bulanan';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Sertai pencarian tematik bulanan untuk mengumpul harga';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Tuntut semula data kesetiaan anda';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Ketahui cara meminta data anda';

  @override
  String get preferences_page_customize_app_title => 'Sesuaikan apl';

  @override
  String get preferences_page_contribute_project_title =>
      'Menyumbang kepada projek';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Cara mudah untuk membantu Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodologi skor, bantuan dan banyak lagi tentang projek';

  @override
  String get product_edit_robotoff_positive_button => 'Terima cadangan';

  @override
  String get product_edit_robotoff_negative_button => 'Tolak cadangan';

  @override
  String get product_edit_robotoff_show_proof => 'Tunjukkan bukti';

  @override
  String get product_edit_robotoff_expand_proof => 'Kembangkan bukti';

  @override
  String get product_page_tab_raw_data => 'Data mentah';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Halaman $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Halaman $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count daripada $total item';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count daripada $total item';
  }

  @override
  String item_count(int count) {
    return '$count item';
  }

  @override
  String item_count_string(String count) {
    return '$count item';
  }

  @override
  String get prices_no_result => 'Tiada statistik harga ditemui.';

  @override
  String get prices_error_loading_more_items =>
      'Ralat memuatkan lebih banyak item';

  @override
  String get prices_proof_error =>
      'Pengesahan gagal, tidak dapat mengambil bukti';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count daripada $total bukti';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count daripada $total penyumbang';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count daripada $total lokasi';
  }

  @override
  String prices_locations_count(int count) {
    return '$count lokasi';
  }

  @override
  String get restart_to_apply_message =>
      'Sila mulakan semula apl untuk menggunakan perubahan.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Antara muka grafik';

  @override
  String get preferences_app_settings_media_title => 'Media';

  @override
  String get preferences_about_app_development_title => 'Pembangunan';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Makmal Open Food Facts';

  @override
  String get preferences_root_account_title => 'Akaun';

  @override
  String get preferences_contribute_translate_header =>
      'Bawa Open Food Facts kepada bahasa anda';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Daftar dalam versi alfa apl';

  @override
  String get preferences_dev_mode_section_data => 'Data Sumbangan & Produk';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Jangan tunjukkan Folksonomy';

  @override
  String get preferences_account_title => 'Akaun';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Ditambah pada $created';
  }

  @override
  String get location_map_details_title => 'Butiran lokasi';

  @override
  String get location_map_details_name => 'Nama';

  @override
  String get location_map_details_street => 'Jalan';

  @override
  String get location_map_details_city => 'Bandar';

  @override
  String get location_map_details_postcode => 'Poskod';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Koordinat';

  @override
  String get location_map_details_osm_id => 'ID OSM';
}
