// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Latvian (`lv`).
class AppLocalizationsLv extends AppLocalizations {
  AppLocalizationsLv([String locale = 'lv']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Jā';

  @override
  String get add => 'Pievienot';

  @override
  String get account_delete_message =>
      'Vai tiešām vēlaties dzēst savu kontu?\nJa ir konkrēts iemesls, lūdzu, norādiet to zemāk.';

  @override
  String get reason => 'Iemesls';

  @override
  String get okay => 'Labi';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'Izveidot';

  @override
  String get applyButtonText => 'Apply';

  @override
  String get next_label => 'Nākamais';

  @override
  String get continue_label => 'Turpināt';

  @override
  String get exit_label => 'Izeja';

  @override
  String get previous_label => 'Iepriekšējais';

  @override
  String get go_back_to_top => 'Atgriezties augšpusē';

  @override
  String get save => 'Saglabāt';

  @override
  String get save_confirmation => 'Vai tiešām vēlaties saglabāt?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Cancel';

  @override
  String get ignore => 'Ignorēt';

  @override
  String get close => 'Aizvērt';

  @override
  String get no => 'Nē';

  @override
  String get stop => 'Apstāties';

  @override
  String get finish => 'Pabeigt';

  @override
  String get calculate => 'Aprēķināt';

  @override
  String get reset_food_prefs => 'Atiestatīt ēdiena preferences';

  @override
  String get error => 'Kaut kas nogāja greizi';

  @override
  String get error_occurred => 'Radās kļūda';

  @override
  String get featureInProgress =>
      'Mēs joprojām strādājam pie šīs funkcijas, sekojiet līdzi jaunumiem';

  @override
  String get label_web => 'Skatīt tīmeklī';

  @override
  String get learnMore => 'Uzziniet vairāk';

  @override
  String get unknown => 'Nezināms';

  @override
  String get match_very_good => 'Ļoti laba spēle';

  @override
  String get match_good => 'Laba atbilstība';

  @override
  String get match_poor => 'Slikta atbilstība';

  @override
  String get match_may_not => 'Var neatbilst';

  @override
  String get match_does_not => 'Neatbilst';

  @override
  String get match_unknown => 'Nezināma atbilstība';

  @override
  String get match_short_very_good => 'Ļoti laba spēle';

  @override
  String get match_short_good => 'Laba atbilstība';

  @override
  String get match_short_poor => 'Slikta atbilstība';

  @override
  String get match_short_may_not => 'Var neatbilst';

  @override
  String get match_short_does_not => 'Neatbilst';

  @override
  String get match_short_unknown => 'Nezināma atbilstība';

  @override
  String get licenses => 'Licences';

  @override
  String get looking_for => 'Meklēju';

  @override
  String get welcomeToOpenFoodFacts => 'Laipni lūdzam vietnē Open Food Facts';

  @override
  String get whatIsOff =>
      '“Open Food Facts” ir globāla bezpeļņas organizācija, ko atbalsta vietējās kopienas.';

  @override
  String get productDataUtility =>
      'Skatiet pārtikas datus, kas atbilst jūsu vēlmēm.';

  @override
  String get healthCardUtility =>
      'Izvēlieties pārtikas produktus, kas jums ir labi.';

  @override
  String get ecoCardUtility =>
      'Izvēlieties pārtikas produktus, kas ir labi planētai.';

  @override
  String get server_error_open_new_issue =>
      'Nav servera atbildes! Varat atvērt problēmu, izmantojot šo saiti.';

  @override
  String get sign_in_text =>
      'Pierakstieties savā Open Food Facts kontā, lai saglabātu savu ieguldījumu.';

  @override
  String get incorrect_credentials => 'Nepareizs lietotājvārds vai parole.';

  @override
  String get password_lost_incorrect_credentials =>
      'Šis e-pasts vai lietotājvārds neeksistē. Lūdzu, pārbaudiet savus akreditācijas datus.';

  @override
  String get password_lost_server_unavailable =>
      'Atvainojamies par to, ka mūsu serveros pašlaik ir palēnināšanās. Lūdzu, mēģiniet vēlreiz vēlāk.';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable => 'Tīkls nav sasniedzams';

  @override
  String get login_result_type_server_issue =>
      'Problēma serverī. Lūdzu, mēģiniet vēlāk.';

  @override
  String get login_page_username_or_email =>
      'Lūdzu, ievadiet lietotājvārdu vai e-pastu';

  @override
  String get login_page_password_error_empty => 'Lūdzu, ievadiet paroli';

  @override
  String get create_account => 'Izveidot kontu';

  @override
  String get sign_in => 'Ieiet';

  @override
  String get sign_in_mandatory =>
      'Lai izmantotu šo funkciju, jums ir jāpiesakās.';

  @override
  String get help_improve_country =>
      'Palīdziet uzlabot Open Food Facts savā valstī';

  @override
  String get sign_out => 'Izrakstīties';

  @override
  String get sign_out_confirmation => 'Vai tiešām vēlaties izrakstīties?';

  @override
  String get password => 'Parole';

  @override
  String get forgot_password => 'Aizmirsu paroli';

  @override
  String get forgot_password_question => 'Aizmirsu paroli?';

  @override
  String get view_profile => 'Skatīt profilu';

  @override
  String get reset_password => 'Atiestatīt paroli';

  @override
  String get reset_password_explanation_text =>
      'Ja aizmirstat paroli, ievadiet savu lietotājvārdu vai e-pasta adresi, lai saņemtu norādījumus par paroles atiestatīšanu. Neaizmirstiet arī pārbaudīt surogātpasta mapi.';

  @override
  String get username_or_email => 'Lietotājvārds vai e-pasts';

  @override
  String get reset_password_done =>
      'Uz jūsu kontam pievienoto e-pasta adresi ir nosūtīts e-pasts ar saiti paroles atiestatīšanai. Pārbaudiet arī surogātpasta mapi.';

  @override
  String get send_reset_password_mail => 'Mainīt paroli';

  @override
  String get enter_some_text => 'Lūdzu, ievadiet tekstu';

  @override
  String get sign_up_page_title => 'Reģistrēties';

  @override
  String get sign_up_page_action_button => 'Reģistrēties';

  @override
  String get sign_up_page_action_doing_it => 'Reģistrēšanās…';

  @override
  String get sign_up_page_action_ok =>
      'Apsveicam! Jūsu konts tikko ir izveidots.';

  @override
  String get sign_up_page_display_name_hint => 'Nosaukums';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Lūdzu, ievadiet vēlamo parādāmo vārdu.';

  @override
  String get sign_up_page_email_hint => 'E-pasts';

  @override
  String get sign_up_page_email_error_empty => 'E-pasta adrese ir obligāta';

  @override
  String get sign_up_page_email_error_invalid => 'Nederīga e-pasta adrese';

  @override
  String get sign_up_page_username_hint => 'Lietotājvārds: Publiski redzams';

  @override
  String get sign_up_page_username_error_empty =>
      'Lūdzu, ievadiet lietotājvārdu';

  @override
  String get sign_up_page_username_error_invalid =>
      'Lūdzu, ievadiet derīgu lietotājvārdu';

  @override
  String get sign_up_page_username_description =>
      'Lietotājvārdā nedrīkst būt atstarpes, lielie burti vai speciālās rakstzīmes.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Lietotājvārds nedrīkst pārsniegt $value rakstzīmes';
  }

  @override
  String get sign_up_page_password_hint => 'Parole';

  @override
  String get sign_up_page_password_error_empty => 'Lūdzu, ievadiet paroli';

  @override
  String get sign_up_page_password_error_invalid =>
      'Lūdzu, ievadiet derīgu paroli (vismaz 6 rakstzīmes)';

  @override
  String get sign_up_page_confirm_password_hint => 'Apstiprināt paroli';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Lūdzu, apstipriniet paroli';

  @override
  String get sign_up_page_confirm_password_error_invalid => 'Paroles nesakrīt';

  @override
  String get sign_up_page_agree_text =>
      'Es piekrītu atklātajiem pārtikas faktiem';

  @override
  String get sign_up_page_terms_text => 'lietošanas noteikumi un ieguldījums';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Izveidojot kontu, ir obligāti jāpiekrīt Lietošanas noteikumiem, tomēr lietotnē joprojām var veikt anonīmus ieguldījumus.';

  @override
  String get sign_up_page_producer_checkbox => 'Esmu pārtikas ražotājs';

  @override
  String get sign_up_page_producer_hint => 'Ražotājs/zīmols';

  @override
  String get sign_up_page_producer_error_empty =>
      'Lūdzu, ievadiet ražotāja vai zīmola nosaukumu';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Es vēlos abonēt Open Food Facts jaunumus (no abonēšanas varat atteikties jebkurā laikā).';

  @override
  String get sign_up_page_user_name_already_used =>
      'Lietotājvārds jau pastāv, lūdzu, izvēlieties citu lietotājvārdu.';

  @override
  String get sign_up_page_email_already_exists =>
      'jau pastāv, piesakieties kontā vai mēģiniet ar citu e-pastu.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Lūdzu, norādiet derīgu e-pasta adresi.';

  @override
  String get sign_up_page_server_busy =>
      'Atvainojamies, mums radās dažas tehniskas problēmas, lai izveidotu jūsu kontu. Lūdzu, mēģiniet vēlreiz vēlāk.';

  @override
  String get settingsTitle => 'Iestatījumi';

  @override
  String get darkmode => 'Tēma';

  @override
  String get darkmode_dark => 'Tumšs';

  @override
  String get darkmode_light => 'Gaisma';

  @override
  String get darkmode_system_default => 'Sistēmas noklusējuma vērtība';

  @override
  String get thanks_for_contributing => 'Paldies par ieguldījumu!';

  @override
  String get contributors_label => 'Viņi veido lietotni';

  @override
  String get contributors_dialog_title => 'Atbalstītāji';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Līdzstrādnieks: $name';
  }

  @override
  String get contributors_description =>
      'Visu šīs lietotnes līdzautoru saraksts';

  @override
  String get support => 'Atbalsts';

  @override
  String get support_join_slack => 'Lūdziet palīdzību mūsu Slack kanālā';

  @override
  String get support_via_forum => 'Lūdziet palīdzību mūsu forumā';

  @override
  String get support_via_email => 'Sūtiet mums e-pastu';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Vai sūtīt lietotņu žurnālus?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Vai vēlaties e-pasta pielikumā iekļaut lietojumprogrammu žurnālus?';

  @override
  String get termsOfUse => 'Izmantošanas noteikumi';

  @override
  String get legalNotices => 'Juridiskie paziņojumi';

  @override
  String get privacy_policy => 'Privātuma politika';

  @override
  String get about_this_app => 'Par šo lietotni';

  @override
  String get contribute => 'Veicināt / atbalstīt';

  @override
  String get contribute_sw_development => 'Programmatūras izstrāde';

  @override
  String get contribute_develop_text =>
      'Visu Open Food Facts produktu kods ir pieejams vietnē GitHub. Jūs varat atkārtoti izmantot kodu (tas ir atvērtā koda) un palīdzēt mums to uzlabot ikvienam uz visas planētas.';

  @override
  String get contribute_develop_text_2 =>
      'Jūs varat pievienoties Open Food Facts Slack tērzētavai, kas ir vēlamais veids, kā uzdot jautājumus.';

  @override
  String get contribute_develop_dev_mode_title => 'Izstrādātāja režīms?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktivizējiet DEV režīmu';

  @override
  String get contribute_donate_title => 'Ziedot';

  @override
  String get contribute_donate_header => 'Ziedojiet vietnei Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Lūdzu, ņemiet vērā, ka, izmantojot iekšējo alfa versiju, ir iespējams pilnīgs datu zudums, un lietotne jebkurā laikā var kļūt nelietojama!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Produkta nosaukums jāpabeidz';

  @override
  String get contribute_improve_header => 'Uzlabojot';

  @override
  String get contribute_improve_text =>
      'Datubāze ir projekta pamatā. Tajā palīdzēt ir vienkārši un ļoti ātri. Varat lejupielādēt mobilo lietotni savam tālrunim un sākt pievienot vai uzlabot produktus.\n\nNo otras puses, Open Food Facts tīmekļa vietne piedāvā daudzus veidus, kā sniegt savu ieguldījumu: ';

  @override
  String get contribute_translate_header => 'Tulkot';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Sākt tulkošanu';

  @override
  String get contribute_translate_text =>
      '“Open Food Facts” ir globāls projekts, kurā ir iekļauti produkti no vairāk nekā 160 valstīm. “Open Food Facts” tiek tulkots desmitiem valodu, un tā saturs tiek pastāvīgi atjaunināts.';

  @override
  String get contribute_translate_text_2 =>
      'Tulkojumi ir viens no projekta galvenajiem uzdevumiem';

  @override
  String get contribute_join_skill_pool =>
      'Piedalieties Open Food Facts tīmekļa vietnē, lai dalītos savās prasmēs. Pievienojieties prasmju kopienai!';

  @override
  String get contribute_share_header =>
      'Dalieties ar Open Food Facts ar draugiem';

  @override
  String get contribute_share_content =>
      'Vēlējos pastāstīt par lietotni Open Food Facts, ko lietoju, kas ļauj personalizētā veidā iegūt informāciju par pārtikas ietekmi uz veselību un vidi. Tā darbojas, skenējot svītrkodus uz iepakojuma. Visbeidzot, tā ir bez maksas, tai nav nepieciešama reģistrācija, un jūs pat varat palīdzēt palielināt atšifrēto produktu skaitu. Šeit ir saite, lai to lejupielādētu savā tālrunī: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Veiciniet cenu noteikšanu, pieprasot lojalitātes karšu datu eksportu saskaņā ar GDPR';

  @override
  String get tap_to_answer =>
      'Pieskarieties šeit, lai atbildētu uz jautājumiem';

  @override
  String get tap_to_answer_hint =>
      'Pieskarieties šeit, lai atbildētu uz jautājumiem par šo produktu';

  @override
  String get robotoff_questions_loading_hint =>
      'Lūdzu, uzgaidiet, kamēr tiek ielādēti jautājumi par šo produktu.';

  @override
  String get saving_answer => 'Saglabā jūsu atbildi';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Pierakstieties savā Open Food Facts kontā, lai saņemtu atzinību par savu ieguldījumu.';

  @override
  String get question_yes_button_accessibility_value => 'Atbildēt ar jā';

  @override
  String get question_no_button_accessibility_value => 'Atbilde ar nē';

  @override
  String get question_skip_button_accessibility_value => 'Izlaist šo jautājumu';

  @override
  String get tap_to_edit_search =>
      'Pieskarieties, lai rediģētu meklēšanas vaicājumu';

  @override
  String get myPreferences => 'Manas preferences';

  @override
  String get account_create_message =>
      'Izveidojiet savu kontu un pievienojieties Open Food Facts kopienai, lai palīdzētu veidot zināšanas par pārtiku visā pasaulē!';

  @override
  String get join_us => 'Pievienojieties mums';

  @override
  String get myPreferences_profile_title => 'Jūsu profils';

  @override
  String get myPreferences_profile_subtitle =>
      'Pārvaldiet savu Open Food Facts līdzstrādnieka kontu.';

  @override
  String get myPreferences_settings_title => 'Lietotnes iestatījumi';

  @override
  String get myPreferences_settings_subtitle => 'Tumšais režīms, Valodas…';

  @override
  String get myPreferences_food_title => 'Pārtikas preferences';

  @override
  String get myPreferences_food_subtitle =>
      'Izvēlieties, kura informācija par pārtiku jums ir vissvarīgākā.';

  @override
  String get myPreferences_food_comment =>
      'Izvēlieties, kāda informācija par pārtiku jums ir vissvarīgākā, lai klasificētu pārtiku atbilstoši savām vēlmēm, vispirms redzētu informāciju, kas jūs interesē, un saņemtu saderības kopsavilkumu. Šīs pārtikas preferences paliek jūsu ierīcē un nav saistītas ar jūsu Open Food Facts līdzstrādnieka kontu, ja jums tāds ir.';

  @override
  String get confirmResetPreferences =>
      'Vai atiestatīt savas ēdiena preferences?';

  @override
  String get myPersonalizedRanking => 'Mans personalizētais rangs';

  @override
  String get ranking_tab_all => 'All';

  @override
  String get ranking_subtitle_match_yes => 'Lielisks variants tev';

  @override
  String get ranking_subtitle_match_no => 'Ļoti slikta spēle';

  @override
  String get ranking_subtitle_match_maybe => 'Nezināma atbilstība';

  @override
  String get refresh_with_new_preferences =>
      'Atsvaidziniet sarakstu ar savām jaunajām preferencēm';

  @override
  String get reloaded_with_new_preferences =>
      'Atjaunināts ar jūsu jaunajām preferencēm';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Skenēt';

  @override
  String get history_navbar_label => 'Vēsture';

  @override
  String get list_navbar_label => 'Saraksti';

  @override
  String get category => 'Filtrēt pēc kategorijas';

  @override
  String get category_all => 'All';

  @override
  String get category_search => '(kategorijas meklēšana)';

  @override
  String get filter => 'Filtrs';

  @override
  String get scan => 'Produkti no skenēšanas ekrāna';

  @override
  String get scan_history => 'Skenēšanas vēsture';

  @override
  String get search => 'Meklēt';

  @override
  String get search_product_help => 'Meklēt produktu,\nzīmolu vai svītrkodu';

  @override
  String get search_filter => 'Meklēšanas filtrs';

  @override
  String get search_history => 'Meklēšanas vēsture';

  @override
  String get search_store => 'Meklēt veikalu';

  @override
  String get search_store_help => 'Padoms: pievienojiet pilsētu vai valsti';

  @override
  String get tap_for_more => 'Pieskarieties, lai skatītu vairāk informācijas…';

  @override
  String get product => 'Produkts';

  @override
  String get unknownBrand => 'Nezināms zīmols';

  @override
  String get unknownQuantity => 'Nezināms daudzums';

  @override
  String get unknownProductName => 'Nezināms produkta nosaukums';

  @override
  String get label_refresh => 'Refresh';

  @override
  String get label_reload => 'Pārlādēt';

  @override
  String get image => 'Attēls';

  @override
  String get front_photo => 'Priekšējais fotoattēls';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (šis attēls var būt novecojis)';
  }

  @override
  String get outdated_image_short_label => 'var būt novecojis';

  @override
  String get ingredients => 'Sastāvdaļas';

  @override
  String get ingredients_editing_instructions =>
      'Saglabājiet sākotnējo secību. Norādiet procentuālo daudzumu, ja tāds ir norādīts. Atdaliet ar komatu vai defisi un sastāvdaļas sastāvdaļām izmantojiet iekavas.';

  @override
  String get ingredients_editing_error => 'Neizdevās saglabāt sastāvdaļas.';

  @override
  String get ingredients_editing_image_error =>
      'Neizdevās iegūt jaunu sastāvdaļu attēlu.';

  @override
  String get ingredients_editing_title => 'Rediģēt sastāvdaļas';

  @override
  String get ingredients_photo => 'Sastāvdaļu foto';

  @override
  String get packaging_editing_instructions =>
      'Uzskaitiet visas iepakojuma daļas, atdalītas ar komatu vai rindstarpu, norādot to daudzumu (piemēram, 1 vai 6), veidu (piemēram, pudele, kaste, kanna), materiālu (piemēram, plastmasa, metāls, alumīnijs) un, ja pieejams, to izmēru (piemēram, 33cl) un pārstrādes instrukcijas.\nPiemērs: 1 stikla pudele pārstrādei, 1 plastmasas korķis izmešanai';

  @override
  String get packaging_editing_error => 'Neizdevās saglabāt iepakojumu.';

  @override
  String get packaging_editing_image_error =>
      'Neizdevās iegūt jaunu iepakojuma attēlu.';

  @override
  String get packaging_editing_title => 'Rediģēt iepakojumu';

  @override
  String get nutrition => 'Uzturs';

  @override
  String get nutrition_facts_photo => 'Uzturvērtības fakti fotoattēlā';

  @override
  String get nutrition_facts_editing_title => 'Rediģēt uztura informāciju';

  @override
  String get packaging_information => 'Pārstrādes instrukcijas';

  @override
  String get packaging_information_photo => 'Pārstrādes instrukciju fotoattēls';

  @override
  String get missing_product => 'Jūs atradāt jaunu produktu!';

  @override
  String get add_product_take_photos =>
      'Lai pievienotu šo produktu vietnei Open Food Facts, nofotografējiet iepakojumu.';

  @override
  String get add_product_take_photos_descriptive =>
      'Lūdzu, vispirms uzņemiet dažas fotogrāfijas. Produktu vienmēr varat pabeigt vēlāk.';

  @override
  String get add_product_information_button_label =>
      'Pievienojiet informāciju par produktu';

  @override
  String get new_product => 'Jauns produkts';

  @override
  String get new_product_found_title => 'Atrasts jauns produkts!';

  @override
  String get new_product_found_text =>
      'Mūsu sadarbības datubāzē ir vairāk nekā **3 miljoni produktu**, taču šis svītrkods neeksistē: ';

  @override
  String get new_product_found_button => 'Pievienojiet šo produktu';

  @override
  String get new_product_leave_title => 'Vai atstāt šo lapu?';

  @override
  String get new_product_leave_message =>
      'Izskatās, ka jūs neko neesat ievadījis. Vai tiešām vēlaties pamest šo lapu?';

  @override
  String get new_product_dialog_description =>
      'Lūdzu, nofotografējiet iepakojumu, lai pievienotu šo produktu mūsu kopējai datubāzei.';

  @override
  String get new_product_dialog_illustration_description =>
      'Ilustrācija ar nezināmu Nutri-Score un Green Score';

  @override
  String get front_packaging_photo_button_label =>
      'Priekšējā iepakojuma fotoattēls';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Apstipriniet priekšējā iepakojuma fotoattēla augšupielādi';

  @override
  String get confirm_button_label => 'Apstiprināt';

  @override
  String get send_image_button_label => 'Sūtīt attēlu';

  @override
  String get crop_page_action_saving => 'Attēla saglabāšana…';

  @override
  String get crop_page_action_cropping => 'Attēla apgriešana…';

  @override
  String get crop_page_action_local => 'Saglabā lokālo versiju…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ups… kaut kas nav kārtībā ar tavu fotoattēlu!';

  @override
  String get crop_page_action_local_failed_message =>
      'Mēs nevaram apstrādāt attēlu lokāli pirms tā nosūtīšanas uz mūsu serveri. Lūdzu, mēģiniet vēlreiz vai sazinieties ar mums, ja problēma joprojām pastāv.';

  @override
  String get crop_page_action_retake => 'Atkārtoti uzņemt fotoattēlu';

  @override
  String get crop_page_too_small_image_title => 'Attēls ir par mazu!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Minimālais attēla augšupielādes izmērs pikseļos ir ${expectedMinWidth}x$expectedMinHeight. Pašreizējais attēls ir ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Gatavošanās zvanam uz serveri…';

  @override
  String get front_packaging_photo_title => 'Priekšējā iepakojuma fotoattēls';

  @override
  String get ingredients_photo_title => 'Sastāvdaļu foto';

  @override
  String get nutritional_facts_photo_title => 'Uzturvērtības fakti Foto';

  @override
  String get recycling_photo_title => 'Pārstrādes instrukcijas Fotoattēls';

  @override
  String get take_photo_title => 'Fotografēt';

  @override
  String get take_more_photo_title => 'Uzņemt papildus fotogrāfijas';

  @override
  String get front_photo_uploaded => 'Augšupielādēts priekšējais fotoattēls';

  @override
  String get ingredients_photo_button_label => 'Sastāvdaļu foto';

  @override
  String get ingredients_photo_uploaded =>
      'Augšupielādēts sastāvdaļu fotoattēls';

  @override
  String get nutrition_cache_loading_error =>
      'Nevar ielādēt barības vielas no kešatmiņas.';

  @override
  String get nutritional_facts_photo_button_label =>
      'Uzturvērtības fakti fotoattēlā';

  @override
  String get nutritional_facts_input_button_label =>
      'Aizpildiet uzturvērtības informāciju';

  @override
  String get nutritional_facts_added =>
      'Pievienota informācija par uzturvērtību';

  @override
  String get categories_added => 'Pievienotās kategorijas';

  @override
  String get new_product_title_nutriscore => 'Aprēķiniet Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Palīdziet mums, aizpildot vismaz kategoriju un uzturvērtības';

  @override
  String get new_product_title_environmental_score =>
      'Aprēķiniet zaļo punktu skaitu';

  @override
  String get new_product_subtitle_environmental_score =>
      'Iegūstiet to, aizpildot vismaz vienu kategoriju';

  @override
  String get new_product_additional_environmental_score =>
      'Padariet zaļā vērtējuma aprēķinu precīzāku, norādot izcelsmi, iepakojumu un citus datus';

  @override
  String get new_product_title_nova =>
      'Aprēķiniet pārtikas pārstrādes līmeni (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Iegūstiet to, aizpildot pārtikas kategoriju un sastāvdaļas';

  @override
  String get new_product_desc_nova_unknown =>
      'Pārtikas pārstrādes līmenis nav zināms';

  @override
  String get new_product_title_pictures => 'Jauns produkts';

  @override
  String get new_product_title_pictures_details =>
      'Lūdzu, uzņemiet tālāk norādītās fotogrāfijas, un Open Food Facts dzinējs varēs paveikt pārējo!';

  @override
  String get new_product_title_misc => 'Un daži pamatdati…';

  @override
  String new_product_done_msg(String username) {
    return 'Paldies par jūsu ieguldījumu “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Paldies par jūsu ieguldījumu!';

  @override
  String get new_product_done_button_label =>
      'Iepazīstieties ar gatavo produktu';

  @override
  String get hey_incomplete_product_message =>
      'Pieskarieties, lai atbildētu uz 3 jautājumiem TAGAD, lai aprēķinātu Nutri-Score, Green Score un Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Pieskarieties tūlīt, lai atbildētu uz 2 jautājumiem, kas palīdzēs analizēt šo kosmētikas līdzekli!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Pieskarieties tūlīt, lai atbildētu uz 3 jautājumiem, kas palīdzēs analizēt šo mājdzīvnieku barības produktu!';

  @override
  String get hey_incomplete_product_message_product =>
      'Pieskarieties tūlīt, lai palīdzētu pabeigt šo produktu!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Augšupielādēts uztura faktu fotoattēls';

  @override
  String get recycling_photo_button_label => 'Pārstrādes foto';

  @override
  String get recycling_photo_uploaded =>
      'Augšupielādēts fotoattēls par pārstrādi';

  @override
  String get take_more_photo_button_label => 'Uzņemt papildus fotogrāfijas';

  @override
  String get other_photo_uploaded => 'Augšupielādēti dažādi fotoattēli';

  @override
  String get retake_photo_button_label => 'Atkārtoti uzņemt';

  @override
  String get selecting_photo => 'Fotoattēla izvēle';

  @override
  String get uploading_image => 'Fotoattēla augšupielāde serverī';

  @override
  String get uploading_image_type_front =>
      'Priekšējā attēla augšupielāde vietnē Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Sastāvdaļu attēla augšupielāde vietnē Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Uzturvērtības attēla augšupielāde vietnē Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Iepakojuma attēla augšupielāde vietnē Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Augšupielādējot citu attēlu vietnē Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Attēla augšupielāde vietnē Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Pievienojiet trūkstošās sastāvdaļas';

  @override
  String get score_add_missing_packaging_image =>
      'Pievienot trūkstošo iepakojuma attēlu';

  @override
  String get score_add_missing_nutrition_facts =>
      'Pievienojiet trūkstošos uztura informāciju';

  @override
  String get score_add_missing_product_traces =>
      'Pievienot trūkstošās produktu pēdas';

  @override
  String get score_add_missing_product_category => 'Izvēlieties kategoriju';

  @override
  String get score_add_missing_precise_product_category =>
      'Izvēlieties precīzāku kategoriju';

  @override
  String get score_add_missing_product_countries =>
      'Pievienot trūkstošās produktu valstis';

  @override
  String get score_add_missing_product_emb =>
      'Pievienojiet trūkstošos produktu izsekojamības kodus';

  @override
  String get score_add_missing_product_labels =>
      'Pievienojiet trūkstošās produktu etiķetes';

  @override
  String get score_add_missing_product_origins =>
      'Pievienot trūkstošās produktu izcelsmes vietas';

  @override
  String get score_add_missing_product_stores =>
      'Pievienot trūkstošos produktu veikalus';

  @override
  String get score_add_missing_product_brands =>
      'Pievienot trūkstošos produktu zīmolus';

  @override
  String get score_update_nutrition_facts =>
      'Atjaunināt uzturvērtības informāciju';

  @override
  String get nutrition_page_title => 'Uztura fakti';

  @override
  String get nutrition_page_nutritional_info_title =>
      'Uzturvērtības informācija';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Uz produkta norādītās vērtības:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Jā';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Nē';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Atvērt fotoattēlu';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Laba prakse: informācija par uzturvērtību';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Dažreiz uzturvērtības informācija **nav norādīta uz iepakojuma** vai produktam pievienotajā dokumentā. Šādā un tikai šajā gadījumā varat iestatīt vērtību **NĒ**.';

  @override
  String get nutrition_page_serving_type_label => 'Uzturvērtības:';

  @override
  String get nutrition_page_per_100g => 'uz 100 g';

  @override
  String get nutrition_page_per_100g_100ml => 'uz 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'uz porciju';

  @override
  String get nutrition_page_add_nutrient => 'Pievienojiet uzturvielu';

  @override
  String get nutrition_page_serving_size => 'Porcijas lielums';

  @override
  String get nutrition_page_serving_size_hint =>
      'Ievadiet porcijas lielumu (piemēram, 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Laba prakse: porciju lielums';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Šī vērtība palīdz **proporcionāli aprēķināt katru uzturvielu vienā porcijas lielumā**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Atļautās mērvienības** ir: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫名, 公升, 公升, 公升';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** vai **60 G** (vēlams pirmais)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** vai **1 l**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Nederīga mērvienība';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Nederīgas mērvienības';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **konfektes** un 2 **cepumi**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Trūkstoša vienība';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Nederīgs numurs';

  @override
  String get nutrition_page_update_running => 'Produkta atjaunināšana serverī…';

  @override
  String get nutrition_page_update_done => 'Produkts atjaunināts!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Izmantojiet produkta daudzumu kā porcijas lielumu';

  @override
  String get nutrition_page_photo_error => 'Nevar ielādēt fotoattēlu';

  @override
  String get more_photos => 'Vairāk interesantu fotoattēlu';

  @override
  String get view_more_photo_button =>
      'Skatīt visus esošos šī produkta fotoattēlus';

  @override
  String get no_product_found => 'Nav atrasts neviens produkts';

  @override
  String get no_location_found => 'Nav atrasta neviena atrašanās vieta';

  @override
  String get not_found => 'nav atrasts:';

  @override
  String get refreshing_product => 'Atsvaidzinošs produkts';

  @override
  String get product_refreshed => 'Produkts atsvaidzināts';

  @override
  String product_image_accessibility_label(String date) {
    return 'Attēls uzņemts $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Attēls uzņemts $date. Šis attēls var būt novecojis.';
  }

  @override
  String get product_image_outdated => 'Šis attēls var būt novecojis';

  @override
  String get product_image_outdated_explanations_title =>
      'Šis attēls var būt novecojis';

  @override
  String get product_image_outdated_explanations_content =>
      'Šis attēls tika uzņemts pirms vairāk nekā gada.\n**Lūdzu, pārbaudiet, vai tas joprojām ir aktuāls**.\n\nŠis ir **tikai brīdinājums**. Ja saturs joprojām ir tāds pats, varat ignorēt šo ziņojumu.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Aizstāt fotoattēlu ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Pievienot fotoattēlu ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Fotografēt';

  @override
  String get product_image_action_from_gallery =>
      'Izvēlieties no sava tālruņa galerijas';

  @override
  String get product_image_action_choose_existing_photo =>
      'Izvēlieties no produktu fotoattēliem';

  @override
  String get product_image_details_label => 'Informācija par fotoattēlu';

  @override
  String get product_image_details_from_producer => 'No producenta';

  @override
  String get product_image_details_contributor => 'Atbalstītājs';

  @override
  String get product_image_details_contributor_producer =>
      'Līdzstrādnieks (producents)';

  @override
  String get product_image_details_date => 'Datums';

  @override
  String get product_image_details_date_unknown => 'Nezināms';

  @override
  String get homepage_main_card_logo_description =>
      'Laipni lūdzam vietnē Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Noskenējiet** svītrkodu vai\n**meklējiet** produktu';

  @override
  String get homepage_main_card_search_field_hint => 'Meklēt produktu';

  @override
  String get homepage_main_card_search_field_tooltip => 'Sākt meklēšanu';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Jaunākās ziņas: $news_title';
  }

  @override
  String get tagline_app_review => 'Vai jums patīk šī lietotne?';

  @override
  String get tagline_app_review_button_positive => 'Man tas ļoti patīk! 😍';

  @override
  String get tagline_app_review_button_negative => 'Ne īsti…';

  @override
  String get tagline_app_review_button_later => 'Pajautāt man vēlāk';

  @override
  String get tagline_feed_news_button => 'Uzziniet vairāk';

  @override
  String get app_review_negative_modal_title => 'Tev nepatīk mūsu lietotne?';

  @override
  String get app_review_negative_modal_text =>
      'Vai jūs varētu veltīt dažas sekundes, lai pastāstītu mums, kāpēc?';

  @override
  String get app_review_negative_modal_positive_button => 'Jā, absolūti!';

  @override
  String get app_review_negative_modal_negative_button => 'Nē';

  @override
  String get could_not_refresh => 'Nevarēja atsvaidzināt produktu';

  @override
  String get product_internet_error_modal_title => 'Radusies kļūda!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Tīkla kļūdas dēļ nevaram izgūt informāciju par šo produktu. Lūdzu, pārbaudiet interneta savienojumu un mēģiniet vēlreiz.\n\nIekšēja kļūda:\n$error';
  }

  @override
  String get product_tags_title => 'Produkta īpašības';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Nav īpašumu';

  @override
  String get product_tags_explanation =>
      'Pievienojot produktam īpašības (atslēgu/vērtību), jūs palīdzat to bagātināt.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Pievienot īpašības';

  @override
  String get add_edit_tags => 'Pievienot vai rediģēt rekvizītus';

  @override
  String get edit_tag => 'Rediģēt īpašumu';

  @override
  String get remove_tag => 'Noņemt īpašumu';

  @override
  String get tag_key => 'Īpašums';

  @override
  String get tag_keys => 'Īpašumi';

  @override
  String get tag_key_uneditable => 'Īpašums (nerediģējams)';

  @override
  String get tag_key_input_hint => 'Ievadiet īpašību';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Ievadiet vērtību';

  @override
  String get tag_key_item => 'Īpašums:';

  @override
  String get tag_value_item => 'Vērtība:';

  @override
  String get tag_key_explanations =>
      'Atslēgai jābūt ar mazajiem burtiem un bez atstarpēm.';

  @override
  String tag_key_already_exists(String property) {
    return 'Birka ar īpašību $property jau pastāv!';
  }

  @override
  String get product_internet_error =>
      'Tīkla kļūdas dēļ nav iespējams izgūt informāciju par šo produktu.';

  @override
  String get cached_results_from => 'Rādīt rezultātus no:';

  @override
  String get product_search_same_category => 'Atrast alternatīvas';

  @override
  String get product_search_same_category_short => 'Salīdzināt';

  @override
  String get product_search_same_category_error =>
      'Šo funkciju var izmantot tikai produktiem ar kategoriju.\n\nLūdzu, rediģējiet produktu, lai pievienotu kategoriju.';

  @override
  String get product_improvement_add_category =>
      'Pievienojiet kategoriju, lai aprēķinātu Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Pievienojiet uzturvērtības faktus, lai aprēķinātu Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Pievienojiet uzturvērtības faktus un kategoriju, lai aprēķinātu Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Šī produkta Nutri-Score vērtību nevar aprēķināt, kas var būt saistīts, piemēram, ar nestandarta kategoriju. Ja tā tiek uzskatīta par kļūdu, lūdzu, sazinieties ar mums.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Uzturvērtības attēls ir novecojis: lūdzu, atsvaidziniet to.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Zaļais vērtējums ņem vērā sastāvdaļu izcelsmi. Lūdzu, nofotografējiet sastāvdaļu sarakstu un/vai jebkuru ģeogrāfiskās izcelsmes norādi vai rediģējiet produktu, lai tos varētu ņemt vērā.';

  @override
  String get country_chooser_label => 'Lūdzu, izvēlieties valsti';

  @override
  String get currency_chooser_label => 'Lūdzu, izvēlieties valūtu';

  @override
  String get country_change_message => 'Jūs tikko nomainījāt valsti.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Vai vēlaties mainīt valūtu no $previousCurrency uz $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Lūdzu, izvēlieties valsti:';

  @override
  String get country_chooser_label_from_settings => 'Jūsu valsts';

  @override
  String get country_selection_explanation =>
      'Dažas vides iezīmes ir atkarīgas no atrašanās vietas';

  @override
  String get product_removed_comparison => 'Produkts noņemts no salīdzināšanas';

  @override
  String get native_app_settings => 'Vietējās lietotnes iestatījumi';

  @override
  String get native_app_description =>
      'Atvērto sistēmu iestatījumi pakalpojumam Open Food Facts';

  @override
  String get product_removed_history => 'Produkts noņemts no vēstures';

  @override
  String get product_removed_list => 'Produkts noņemts no saraksta';

  @override
  String get product_could_not_remove => 'Nevarēja noņemt produktu';

  @override
  String get no_prodcut_in_list => 'Šajā sarakstā nav neviena produkta';

  @override
  String get no_product_in_section => 'Šajā sadaļā nav neviena produkta';

  @override
  String get recently_seen_products => 'Visi skatītie produkti';

  @override
  String get clear => 'Notīrīt';

  @override
  String get clear_long => 'Iztukšojiet sarakstu';

  @override
  String get really_clear => 'Vai tiešām vēlaties dzēst šo sarakstu?';

  @override
  String pct_match(Object percent) {
    return '${percent}atbilstība %';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pirms dienām',
      one: 'pirms vienas dienas',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pirms stundām',
      one: 'pirms vienas stundas',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pirms minūtēm',
      one: 'pirms vienas minūtes',
      zero: 'pirms mazāk nekā minūtes',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pirms mēnešiem',
      one: 'pirms viena mēneša',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pirms nedēļām',
      one: 'pirms vienas nedēļas',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Salīdzināt $count Produktus',
      one: 'Salīdzināt vienu produktu',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count izvēlētie produkti',
      one: 'Viens izvēlēts produkts',
      zero: 'Nav izvēlēta prece',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Salīdzināt atlasītos produktus';

  @override
  String get delete_products_mode => 'Dzēst atlasītos produktus';

  @override
  String get select_all_products_mode => 'Atlasīt visus produktus';

  @override
  String get select_none_products_mode => 'Neizvēlēties nevienu';

  @override
  String get compare_products_appbar_title => 'Salīdzināt produktus';

  @override
  String get compare_products_appbar_subtitle =>
      'Lūdzu, izvēlieties vismaz divus produktus';

  @override
  String get retry_button_label => 'Atkārtot';

  @override
  String get connect_with_us => 'Sazinieties ar mums';

  @override
  String get tiktok => 'Sekojiet mums TikTok platformā';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Sekojiet mums Instagramā';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Sekojiet mums vietnē X (agrāk Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Sekojiet mums Mastodonā';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Sekojiet mums vietnē BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blogs';

  @override
  String get faq => 'Bieži uzdotie jautājumi';

  @override
  String get discover => 'Atklāj';

  @override
  String get how_to_contribute => 'Kā sniegt ieguldījumu';

  @override
  String get hint_knowledge_panel_message =>
      'Varat pieskarties jebkurai kartītes daļai, lai iegūtu sīkāku informāciju par redzēto. Izmēģiniet tūlīt!';

  @override
  String get permissions_page_title => 'Piekļuve kamerai';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'Ja pārdomājat, šo opciju var jebkurā laikā iespējot un atspējot iestatījumos.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Izlaidums: $release)\nModelis: $model\nProdukts: $product\nIerīce: $device\nZīmols:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModelis: $model\nLokalizētais modelis: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nLietotnes versija:$appVersion\nLietotnes būvējuma numurs:$appBuildNumber\nLietotnes pakotnes nosaukums:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'Atteikties';

  @override
  String get ask_me_later_button_label => 'Vēlāk';

  @override
  String get are_you_sure => 'Vai esi pārliecināts?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Dodieties tālāk uz $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Laipni lūgti!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Lietotne, kas palīdz izvēlēties pārtiku, kas ir laba **jums** un **planētai**!';

  @override
  String get onboarding_continue_button => 'Turpināt';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Notiek pirmā produkta parauga ielāde';

  @override
  String get onboarding_welcome_warning =>
      'Atvainojiet, šis ir mūsu produkta piemērs, to nevar rediģēt :)';

  @override
  String get product_list_your_ranking => 'Jūsu rangs';

  @override
  String get product_list_empty_icon_desc => 'Vēsture nav pieejama';

  @override
  String get product_list_empty_title => 'Sākt skenēšanu';

  @override
  String get product_list_empty_message =>
      'Šeit parādīsies skenēti produkti, un jūs varēsiet apskatīt detalizētu informāciju par tiem.';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produktus',
      one: 'produktu',
      zero: 'produktu',
    );
    return 'Atsvaidzina $_temp0 jūsu vēsturē';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Produkti',
      one: 'Produkts',
      zero: 'Produkts',
    );
    return '$_temp0 atsvaidzināšana pabeigta';
  }

  @override
  String get product_list_compare_side_by_side => 'Salīdzināt blakus';

  @override
  String get loading_dialog_default_title => 'Datu lejupielāde';

  @override
  String get loading_dialog_default_error_message =>
      'Nevarēja lejupielādēt datus';

  @override
  String get account_delete => 'Dzēst kontu';

  @override
  String get account_delete_title => 'Dzēst manu kontu';

  @override
  String get user_profile => 'Konts';

  @override
  String get user_profile_title_guest => 'Laipni lūgti!';

  @override
  String get user_profile_subtitle_guest =>
      'Pierakstieties vai reģistrējieties, lai pievienotos Open Food Facts kopienai';

  @override
  String user_profile_title_id_email(String email) {
    return 'Atvērt pārtikas faktu pieteikšanās: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Laipni lūgti $id!';
  }

  @override
  String get email_subject_account_deletion => 'Dzēst kontu';

  @override
  String email_body_account_deletion(String userId) {
    return 'Sveiki, lūdzu, izdzēsiet manu Open Food Facts kontu: $userId';
  }

  @override
  String get settings_app_app => 'Pieteikums';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Produkti';

  @override
  String get settings_app_miscellaneous => 'Dažādi';

  @override
  String get camera_play_sound_title => 'Atskaņot skaņu skenēšanas laikā';

  @override
  String get camera_play_sound_subtitle =>
      'Pīkstiens atskanēs katras veiksmīgas skenēšanas laikā';

  @override
  String get camera_window_accessibility_label =>
      'Skenējiet svītrkodu ar savu kameru';

  @override
  String get app_haptic_feedback_title => 'Vibrācija un haptika';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrācijas pēc dažu darbību veikšanas (svītrkoda atšifrēšana, produkta izņemšana…).';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Ja šī opcija ir iespējota, avāriju ziņojumi tiek automātiski iesniegti Open Food Facts kļūdu izsekošanas sistēmai, lai kļūdas varētu novērst un tādējādi uzlabot lietotni.';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Rediģēt fotoattēlu';

  @override
  String get permission_photo_error => 'Kļūda';

  @override
  String get permission_photo_denied_title =>
      'Atļaut kameras lietošanu svītrkodu skenēšanai';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Lai uzlabotu lietotāja pieredzi, lūdzu, atļaujiet $appName piekļūt jūsu kamerai. Jūs varēsiet tieši skenēt svītrkodus.';
  }

  @override
  String get permission_photo_denied_button => 'Atļaut';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Atļauja liegta';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Tā kā iepriekš liedzāt kameras atļauju, tā ir jāatļauj manuāli iestatījumos.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Atvērt iestatījumus';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Cancel';

  @override
  String get permission_photo_none_found => 'Nav atrasta neviena kamera';

  @override
  String get permission_photo_denied => 'Piekļuve kamerai nav piešķirta';

  @override
  String get show_product_pictures => 'Rādīt produktu attēlus';

  @override
  String get edit_product_label => 'Labot produktu';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Augšupielādējiet savas izmaiņas…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Jūsu labojumi tiek **nosūtīti fonā** (vai vēlāk kļūdas gadījumā).\nVarat turpināt rediģēt citus produktu laukus.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Jūsu labojumi tiek **sūtīti fonā** (vai vēlāk kļūdas gadījumā).';

  @override
  String get edit_product_label_short => 'Rediģēt';

  @override
  String edit_product_form_item_help(String value) {
    return 'Kā ievadīt \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Lūdzu, ievadiet vērtību, kas nav tukša!';

  @override
  String get edit_product_form_item_error_existing => 'Šī vērtība jau pastāv!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Pievienot jaunu zīmolu';

  @override
  String get edit_product_form_item_add_action_label =>
      'Pievienot jaunu iezīmi';

  @override
  String get edit_product_form_item_add_action_store =>
      'Pievienot jaunu veikalu';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Pievienot jaunu sākumpunktu';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Pievienot jaunu izsekojamības kodu';

  @override
  String get edit_product_form_item_add_action_country =>
      'Pievienot jaunu valsti';

  @override
  String get edit_product_form_item_add_action_category =>
      'Pievienot jaunu kategoriju';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Pievienot jaunu izsekošanas informāciju';

  @override
  String get edit_product_form_item_add_suggestion => 'Pievienot ieteikumu';

  @override
  String get edit_product_form_item_deny_suggestion => 'Noraidīt ieteikumu';

  @override
  String get edit_product_form_item_details_title => 'Pamatinformācija';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Produkta nosaukums, zīmols, daudzums';

  @override
  String get edit_product_form_item_other_details_title =>
      'Papildu informācija';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Tīmekļa vietne…';

  @override
  String get edit_product_form_item_photos_title => 'Fotoattēli';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Pievienot vai atsvaidzināt fotoattēlus';

  @override
  String get edit_product_form_item_labels_title => 'Etiķetes un sertifikāti';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Vides, kvalitātes marķējumi…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Ievadiet nosaukumu (piemēram, NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'etiķete';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Laba prakse: Etiķetes';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Jebkura produkta īpašība, **kas ir faktiska** un atšķiras no citām jomām.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Ražots Beļģijā, ražots Bretaņā…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Bagāts ar šķiedrvielām, dzelzs avots…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Godīga tirdzniecība, Makss Havelārs…';

  @override
  String get edit_product_form_item_stores_title => 'Veikali';

  @override
  String get edit_product_form_item_stores_hint => 'Ievadiet veikala nosaukumu';

  @override
  String get edit_product_form_item_stores_type => 'veikals';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Laba prakse: Veikali';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Ievadiet veikala nosaukumu, kurā iegādājāties preci.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Izcelsme';

  @override
  String get edit_product_form_item_origins_hint =>
      'Ievadiet izcelsmes vietu (piemēram, Vācija)';

  @override
  String get edit_product_form_item_origins_type => 'valsts';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Laba prakse: Izcelsme';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Pievienojiet **jebkādas izcelsmes norādes, ko varat atrast uz iepakojuma**.\nJums nav jāuztraucas par izcelsmi, kas tieši norādīta sastāvdaļu sarakstā.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Liellopu gaļa no Argentīnas';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soja nenāk no Eiropas Savienības';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Ievadiet valsti (piemēram, Vācija)';

  @override
  String get edit_product_form_item_countries_type => 'valsts';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Labā prakse: Valstis';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Valstis, kurās produkts ir plaši pieejams** (neieskaitot veikalus, kas specializējas ārvalstu produktos).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Izsekojamības kodi';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Ievadiet kodu (piemēram, EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'izsekojamības kods';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Laba prakse: Izsekojamības kodi';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Šajā sadaļā varat ievadīt kodus, kas saistīti ar **iepakojuma marķējumiem**, **identifikācijas marķējumiem** vai **veselības marķējumiem**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Izsekojamības kodu piemēri';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EK kodi**, ko Eiropas Kopienā izmanto pārtikas ražotāju vai iepakotāju identificēšanai:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: **Francijas** valsts kods\n**72.264.002**: ģeogrāfiskie dati\n**CE**: Eiropas Kopiena';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB kodi**, ko izmanto Francijā:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Traces';

  @override
  String get edit_product_form_item_traces_hint => 'pēdas';

  @override
  String get edit_product_form_item_traces_type =>
      'Ievadiet pēdas (piemēram, sojas pupiņas)';

  @override
  String get edit_product_form_item_categories_title => 'Kategorijas';

  @override
  String get edit_product_form_item_categories_hint => 'kategorija';

  @override
  String get edit_product_form_item_categories_type =>
      'Ievadiet kategoriju (piemēram, apelsīnu sula)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Laba prakse: Kategorijas';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Norādiet **tikai visprecīzāko kategoriju**.\nVecāku kategorijas tiks pievienotas automātiski.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Trūkstoša kategorija?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Ja kategorija **automātiskajā pabeigšanā nav pieejama**, droši pievienojiet to jebkurā gadījumā.\nTas mums palīdzēs uzlabot Open Food Facts jūsu valstī.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardīnes olīveļļā';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Apelsīnu sula no koncentrāta';

  @override
  String get edit_product_form_item_exit_title => 'Vai iziet nesaglabājot?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Vai vēlaties saglabāt izmaiņas pirms šīs lapas atstāšanas?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Saglabāt izmaiņas';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Atmest izmaiņas';

  @override
  String get edit_product_form_item_ingredients_title => 'Sastāvdaļas';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Pietuviniet un attāliniet ekrānu, saspiežot pirkstus';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Pietuviniet un attāliniet fotoattēlu';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Izmantojot **saspiešanas, lai tuvinātu**, varat tuvināt vai attālināt fotoattēlu:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Pievienot';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Lūdzu, vispirms ievadiet tekstu';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Noņemt';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Saglabāt savu labojumu';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Atcelt savu rediģēšanu';

  @override
  String get edit_product_form_item_packaging_title =>
      'Pārstrādes instrukciju fotoattēls';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Uztura fakti';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Uzturvērtība, alkohola saturs…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Laba prakse: Uzturvērtības fakti';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Uzturvērtības';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Vispirms atlasiet, vai **vērtības ir norādītas**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Uztura fakti';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Pēc tam ievadiet uzturvērtības **kā norādīts uz iepakojuma**. Ja vērtības nav, varat noklikšķināt uz ikonas \"Acs\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Trūkstošs lauks?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Ja ieraksta trūkst, varat **noklikšķināt uz ikonas \"Plus\"**, lai to pievienotu (piemēram: D vitamīns, magnijs…).';

  @override
  String get edit_product_form_save => 'Rediģēt';

  @override
  String get edit_product_ingredients_photo_title => 'Sastāvdaļu foto';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Iepakojuma fotoattēls';

  @override
  String get edit_product_packaging_list_title => 'Iepakojuma saraksts';

  @override
  String get no_data_available => 'Dati nav pieejami';

  @override
  String get product_field_website_title => 'Tīmekļa vietne';

  @override
  String get origins_editing_title => 'Rediģēt izcelsmes vietas';

  @override
  String get completed_basic_details_btn_text => 'Pilnīga pamatinformācija';

  @override
  String get not_implemented_snackbar_text => 'Vēl nav ieviests';

  @override
  String get category_picker_page_appbar_text => 'Kategorijas';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Izņemiet sastāvdaļas no fotoattēla';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Ekstrakta sastāvdaļas';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Sastāvdaļu\niegūšana no fotoattēla';

  @override
  String get edit_ingredients_loading_photo_btn_text =>
      'Notiek fotoattēla ielāde…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Kāpēc es redzu šo ziņojumu?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Lai izmantotu funkciju \"Iegūt sastāvdaļas\", vispirms ir jāaugšupielādē fotoattēls.\n\nLūdzu, uzgaidiet dažas sekundes vai ievadiet tos manuāli.';

  @override
  String get edit_ingredients_refresh_photo_btn_text =>
      'Atsvaidzināt fotoattēlu';

  @override
  String get edit_packaging_extract_btn_text =>
      'Izņemiet iepakojumu\nno fotoattēla';

  @override
  String get edit_packaging_extract_btn_text_short => 'Ekstraktu iepakojums';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Iepakojuma izņemšana no fotoattēla';

  @override
  String get edit_packaging_loading_photo_btn_text =>
      'Notiek fotoattēla ielāde…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Kāpēc es redzu šo ziņojumu?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Lai izmantotu funkciju \"Izvilkt iepakojumu\", vispirms ir jāaugšupielādē fotoattēls.\n\nLūdzu, uzgaidiet dažas sekundes vai ievadiet tos manuāli.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Atsvaidzināt fotoattēlu';

  @override
  String get edit_ocr_extract_failed => 'Neizdevās noteikt tekstu attēlā.';

  @override
  String get edit_ocr_extract_disabled_title => 'Nav attēla!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Lai izmantotu teksta izvilkšanas funkciju, vispirms ir jāuzņem fotoattēls.';

  @override
  String get user_list_dialog_new_title => 'Jauns produktu saraksts';

  @override
  String get user_list_dialog_rename_title => 'Pārdēvēt sarakstu';

  @override
  String get user_list_subtitle_product => 'Saraksti';

  @override
  String get user_list_title => 'Jūsu saraksti';

  @override
  String get user_list_add_product => 'Pievienojiet produktu saviem sarakstiem';

  @override
  String get user_list_button_new => 'Izveidot jaunu sarakstu';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Pievienot sarakstam';

  @override
  String get added_to_list_msg => 'Pievienots sarakstam';

  @override
  String get user_list_popup_clear => 'Notīrīt vēsturi';

  @override
  String get user_list_popup_rename => 'Pārdēvēt';

  @override
  String get user_list_name_hint => 'Mans saraksts';

  @override
  String get user_list_name_error_empty => 'Vārds ir obligāts';

  @override
  String get user_list_name_error_already => 'Šis nosaukums jau tiek lietots';

  @override
  String get user_list_name_error_same => 'Tas ir tas pats vārds';

  @override
  String get user_list_name_input_hint => 'Saraksta nosaukums';

  @override
  String get try_again => 'Mēģiniet vēlreiz';

  @override
  String get there_was_an_error => 'Radās kļūda';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Nav atrasta kategorija, kas atbilst $items';
  }

  @override
  String get camera_toggle_camera =>
      'Pārslēgties starp aizmugurējo un priekšējo kameru';

  @override
  String get camera_toggle_flash =>
      'Ieslēdziet vai izslēdziet kameras zibspuldzi';

  @override
  String get camera_enable_flash => 'Iespējot zibspuldzi';

  @override
  String get camera_disable_flash => 'Atspējot zibspuldzi';

  @override
  String get camera_flash_error_dialog_title => 'Radās kļūda!';

  @override
  String get camera_flash_error_dialog_message =>
      'Mainot zibspuldzes stāvokli, radās kļūda. Lūdzu, pārliecinieties, vai viedtālrunī jau nav iespējota lukturīša funkcija.';

  @override
  String get category_picker_no_category_found_button => 'Atpakaļ';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Noklikšķiniet, lai atvērtu pārlūkprogrammā vai lietojumprogrammā (ja tā ir instalēta)';

  @override
  String get dev_preferences_screen_title => 'Izstrādātāja režīms';

  @override
  String get dev_preferences_screen_subtitle =>
      'Piekļūstiet eksperimentālām funkcijām un izstrādes rīkiem';

  @override
  String get dev_preferences_reset_onboarding_title => 'Atsākt apmācību';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Pēc tam, lai to atkal redzētu, jums ir jārestartē lietotne.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Pārslēgties starp openfoodfacts.org (PROD) un testa vidi';

  @override
  String get dev_preferences_test_environment_title => 'Testa vides parametri';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Pašreizējās testa vides bāzes URL: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Testa vides resursdators';

  @override
  String get dev_preferences_ml_kit_title => 'Izmantojiet ML komplektu';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'tad jums ir jārestartē šī lietotne';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Papildu poga produkta lapā';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Rediģēt sastāvdaļas, izmantojot zināšanu paneļa pogu';

  @override
  String get dev_preferences_export_history_title => 'Eksporta vēsture';

  @override
  String get dev_preferences_export_history_progress_error => 'izņēmums';

  @override
  String get dev_preferences_export_history_progress_found =>
      'produkts atrasts';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produkts NAV atrasts';

  @override
  String get dev_preferences_export_history_dialog_title => 'Eksporta vēsture';

  @override
  String get dev_preferences_button_positive => 'Labi';

  @override
  String get dev_preferences_button_negative => 'Cancel';

  @override
  String get dev_preferences_migration_title => 'Datu migrācija no V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Statuss: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'veiksmīga vai jauna instalēšana';

  @override
  String get dev_preferences_migration_status_success => 'panākumi';

  @override
  String get dev_preferences_migration_status_error => 'kļūda';

  @override
  String get dev_preferences_migration_status_in_progress => 'procesā';

  @override
  String get dev_preferences_migration_status_required =>
      'obligāti (noklikšķiniet, lai sāktu)';

  @override
  String get dev_preferences_migration_status_not_started => 'nezināms';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Notīrīs vēsturi un ievietos tur 3 produktus';

  @override
  String get dev_preferences_news_custom_url_title => 'Pielāgots URL ziņām';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'JSON faila URL:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Nav iestatīts';

  @override
  String get dev_preferences_news_provider_status_title => 'Statuss';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Pēdējā atsvaidzināšana: $date';
  }

  @override
  String get product_type_label_food => 'Ēdiens';

  @override
  String get product_type_label_beauty => 'Personīgā aprūpe';

  @override
  String get product_type_label_pet_food => 'Mājdzīvnieku barība';

  @override
  String get product_type_label_product => 'Citi';

  @override
  String get product_type_selection_title => 'Produkta veids';

  @override
  String get product_type_selection_subtitle => 'Izvēlieties šī produkta veidu';

  @override
  String get product_type_selection_empty =>
      'Vispirms jāizvēlas produkta veids!';

  @override
  String product_type_selection_already(String productType) {
    return 'Jūs nevarat mainīt produkta veidu ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Saīsne uz lietotni Cenas produkta lapā';

  @override
  String get prices_app_button => 'Dodieties uz lietotni Cenas';

  @override
  String get prices_website_button => 'Atvērt vietnē Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Pievienojiet cenu zīmes tieši no galerijas';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Kad attēli būs atlasīti, tos vairs nevarēs rediģēt!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Ļaut kopienai validēt mākslīgā intelekta iegūtās cenas.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Vairākas cenu zīmes';

  @override
  String get prices_bulk_proof_upload_title =>
      'Lielapjoma pierādījumu augšupielāde';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Failu atlasīšana';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Augšupielādes sākšana';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Lokāli kopē failu #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Notiek augšupielādes sagatavošana #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Neizdevās pie attēla #$index/$count';
  }

  @override
  String get prices_generic_title => 'Cenas';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pievienot $count cenas',
      one: 'Pievienot cenu',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Nosūtiet $count cenas',
      one: 'Nosūtiet cenu',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Pievienot vienumu';

  @override
  String get prices_add_a_price => 'Pievienot cenu';

  @override
  String get prices_add_a_receipt => 'Pievienot kvīti';

  @override
  String get prices_add_price_tags => 'Pievienot cenu zīmes';

  @override
  String prices_barcode_already(String barcode) {
    return 'Šis svītrkods ($barcode) jau ir sarakstā!';
  }

  @override
  String get prices_barcode_search_not_found => 'Produkts nav atrasts';

  @override
  String get prices_barcode_search_none_yet => 'Vēl nav neviena produkta';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Meklēju $barcode';
  }

  @override
  String get prices_barcode_enter => 'Ievadiet svītrkodu';

  @override
  String get prices_category_enter => 'Prece bez svītrkoda';

  @override
  String get prices_per_kilogram => 'Cena par kilogramu';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / vienība';

  @override
  String get prices_category_mandatory => 'Obligāti';

  @override
  String get prices_category_optional => 'Pēc izvēles';

  @override
  String get prices_category_error_mandatory => 'Kategorija ir obligāta';

  @override
  String get prices_barcode_reader_action => 'Svītrkodu lasītājs';

  @override
  String get prices_view_prices => 'Skatīt cenas';

  @override
  String get prices_list_title => 'Cenrādis';

  @override
  String get prices_list_count => '\ncenu skaits';

  @override
  String get prices_list_add_new_price => 'Pievienot\njaunu cenu';

  @override
  String get prices_list_empty_title => 'Vēl nav cenas!';

  @override
  String get prices_list_empty_subtitle =>
      'Esi pirmais, kas pievieno:\nNoskenējot **čeku** vai **cenu zīmi**!';

  @override
  String get prices_entry_shop_not_found => 'Nezināms veikals';

  @override
  String prices_entry_menu_title(String user) {
    return 'Cenas ievade no \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Skatīt visas šī produkta cenas';

  @override
  String get prices_entry_menu_open_proof => 'Skatīt pierādījumu';

  @override
  String get prices_entry_menu_my_prices => 'Skatīt manas citas cenas';

  @override
  String get prices_entry_menu_author_prices => 'Skatīt citas autora cenas';

  @override
  String get prices_entry_menu_shop_prices => 'Skatīt citas cenas veikalā';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count cenas',
      one: '1 cena',
    );
    return '$_temp0 par $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Visas $count cenas',
      one: 'Tikai viena cena',
      zero: 'Vēl nav cenas',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Jaunākās $pageSize cenas (kopā: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Cena: $price / Veikals: \"$location\" / Publicēts $date , autors \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Atklāti \"$user\" pierādījumi';
  }

  @override
  String get prices_open_proof => 'Atvērt cenu pierādījumu';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Visi $count pierādījumi',
      one: 'Tikai viens pierādījums',
      zero: 'Vēl nav pierādījumu',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Jaunākie $pageSize pierādījumi (kopā: $total)';
  }

  @override
  String get prices_users_empty_title => 'Vēl nav līdzstrādnieka!';

  @override
  String get prices_users_empty_explanation =>
      'Esi pirmais, kas pievieno cenu!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Lielākie $pageSize līdzstrādnieki (kopā: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Veikala vēl nav!';

  @override
  String get prices_locations_empty_explanation =>
      'Esi pirmais, kas pievieno cenu!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Populārākās $pageSize atrašanās vietas (kopā: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pierādījumi',
      one: 'Viens pierādījums',
      zero: 'Nav pierādījumu',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkti',
      one: 'Viens produkts',
      zero: 'Nav produktu',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count lietotāji',
      one: 'Viens lietotājs',
      zero: 'Nav lietotāju',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count cenas',
      one: 'Viena cena',
      zero: 'Nav cenas',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Cena iepriekš pievienota';

  @override
  String get prices_amount_subtitle => 'Summa';

  @override
  String get prices_amount_is_discounted => 'Vai ir ar atlaidi?';

  @override
  String get prices_amount_price_normal => 'Cena';

  @override
  String get prices_amount_price_discounted => 'Atlaides cena';

  @override
  String get prices_amount_price_not_discounted => 'Sākotnējā cena';

  @override
  String get prices_amount_no_product => 'Trūkst viena produkta!';

  @override
  String get prices_amount_price_incorrect => 'Nepareiza vērtība';

  @override
  String get prices_amount_price_mandatory => 'Obligāta vērtība';

  @override
  String get prices_currency_subtitle => 'Valūta';

  @override
  String get prices_date_subtitle => 'Datums';

  @override
  String get prices_location_subtitle => 'Veikals';

  @override
  String get prices_location_find => 'Atrast veikalu';

  @override
  String get prices_location_mandatory => 'Tev jāizvēlas veikals!';

  @override
  String get prices_location_search_broader =>
      'Nevarējāt atrast meklēto? Mēģināsim veikt plašāku meklēšanu!';

  @override
  String get prices_proof_subtitle => 'Pierādījums';

  @override
  String get prices_proof_empty_title => 'Vēl nav pierādījumu!';

  @override
  String get prices_proof_empty_explanation =>
      'Sāciet, pievienojot **čeka** vai **cenu zīmes** fotoattēlu!';

  @override
  String get prices_proof_find => 'Izvēlieties pierādījumu';

  @override
  String get prices_proof_change => 'Izmaiņu pierādījums';

  @override
  String get prices_proof_receipt => 'Kvīts';

  @override
  String get prices_proof_price_tag => 'Cenas zīme';

  @override
  String get prices_proof_mandatory => 'Jums jāizvēlas pierādījums!';

  @override
  String get prices_add_validation_error => 'Validācijas kļūda';

  @override
  String get prices_privacy_warning_title =>
      'Brīdinājums par konfidencialitāti';

  @override
  String get prices_unknown_product => 'Nezināms produkts';

  @override
  String get prices_privacy_warning_main_message =>
      'Cenas **būs publiskas** kopā ar veikalu, uz kuru tās attiecas.\n\nTas varētu ļaut personām, kuras zina jūsu Open Food Facts pseidonīmu, veikt šādas darbības:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Nosakiet, kurā rajonā jūs dzīvojat';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Ziniet, ko pērkat';

  @override
  String get prices_privacy_warning_sub_message =>
      'Ja tas jums rada bažas, lūdzu, nomainiet savu pseidonīmu vai izveidojiet jaunu Open Food Facts kontu un piesakieties lietotnē ar to.';

  @override
  String get i_refuse => 'Es atsakos';

  @override
  String get i_accept => 'Es piekrītu';

  @override
  String get prices_currency_change_proposal_title => 'Mainīt valūtu?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Jūsu pašreizējā valūta ir **$currency**. Vai vēlaties to mainīt uz **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Jā, izmantojiet $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nē, paturēt $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Pabeigts';

  @override
  String get dev_mode_section_server => 'Servera konfigurācija';

  @override
  String get dev_mode_section_news => 'Ziņu sniedzēja konfigurācija';

  @override
  String get dev_mode_section_product_page => 'Produkta lapa';

  @override
  String get dev_mode_section_ui => 'Lietotāja saskarne';

  @override
  String get dev_mode_section_experimental_features =>
      'Eksperimentālās funkcijas';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Izslēgt zaļo vērtējumu';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Izmantojiet pareizrakstības pārbaudītāju OCR ekrāniem';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Sastāvdaļas un iepakojums)';

  @override
  String get dev_mode_reset_app_language_title => 'Atiestatīt lietotnes valodu';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Pievienot kartes';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Pārslēgties starp prices.openfoodfacts.org (PROD) un testa vidi';

  @override
  String get search_history_item_edit_tooltip =>
      'Atkārtoti izmantot un rediģēt šo meklēšanu';

  @override
  String get search_history_item_remove_tooltip => 'Noņemt';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Jūs esat lejupielādējis visus $totalSize produktus.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Lejupielādēt $count vairāk produktu\nJau lejupielādēti $downloaded no $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Jūsu meklēšana pēc $search notiek.\n\nLūdzu, uzgaidiet dažas sekundes…';
  }

  @override
  String get user_search_contributor_title => 'Produkti, ko es pievienoju';

  @override
  String get user_search_informer_title => 'Mani rediģētie produkti';

  @override
  String get user_search_photographer_title => 'Produkti, ko es fotografēju';

  @override
  String get user_search_to_be_completed_title => 'Mani nepabeigtie produkti';

  @override
  String get user_search_prices_title => 'Manas cenas';

  @override
  String get user_search_proofs_title => 'Mani pierādījumi';

  @override
  String get user_search_proof_title => 'Mans pierādījums';

  @override
  String search_proof_title(String user) {
    return 'Pierādījums no \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Līdzstrādnieku cenas: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Jaunākās pievienotās cenas';

  @override
  String get all_search_prices_top_user_title => 'Galvenie cenu veicinātāji';

  @override
  String get all_search_prices_top_location_title =>
      'Veikali ar visaugstākajām cenām';

  @override
  String get prices_contribution_assistant => 'Cenu ietekmes asistents';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system =>
      'Pievienot vairākus pierādījumus';

  @override
  String get all_search_prices_top_location_single_title => 'Cenas veikalā';

  @override
  String get all_search_prices_top_product_title =>
      'Produkti ar visaugstākajām cenām';

  @override
  String get all_search_to_be_completed_title => 'Visi nepabeigtie produkti';

  @override
  String get categorize_products_country_title =>
      'Palīdziet kategorizēt produktus savā valstī';

  @override
  String get edit_product_action_retake_picture =>
      'Uzņemt fotoattēlu atkārtoti';

  @override
  String get edit_product_action_take_picture => 'Uzņemt fotoattēlu';

  @override
  String get edit_product_action_confirm => 'Apstiprināt';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Es piekrītu atklātajiem pārtikas faktiem ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'lietošanas noteikumi un ieguldījums';

  @override
  String get analytics_consent_image_semantic_label => 'Analītikas ikona';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Fatāla kļūda: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Fatāla kļūda: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Pilnīga pamatinformācija';

  @override
  String get edit_photo_button_label => 'Rediģēt';

  @override
  String get edit_photo_unselect_button_label => 'Noņemt fotoattēla atlasi';

  @override
  String get edit_photo_select_existing_button_label => 'Atlasiet esošu attēlu';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Atlasiet attēlu, noklikšķinot uz tā';

  @override
  String get edit_photo_select_existing_download_label =>
      'Esošo attēlu izgūšana…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Šim produktam iepriekš nav augšupielādētu attēlu.';

  @override
  String get edit_photo_language_not_this_one => 'Šajā valodā vēl nav attēla';

  @override
  String get edit_photo_language_none => 'Vēl nav attēla';

  @override
  String get category_picker_screen_title => 'Kategorijas';

  @override
  String get basic_details => 'Pamatinformācija';

  @override
  String get product_name => 'Produkta nosaukums';

  @override
  String get product_names => 'Produktu nosaukumi';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Pievienot jaunu tulkojumu';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Pirms validācijas, lūdzu, pievienojiet tulkojumu tikai tad, ja **valoda ir norādīta uz iepakojuma**.';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Skatīt priekšējo fotoattēlu';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Uzņemt fotoattēlu no priekšpuses';

  @override
  String get add_basic_details_product_name_hint =>
      'Ievadiet produkta nosaukumu (piemēram: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Vai mainīt noklusējuma valodu?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Vai vēlaties, lai produkta noklusējuma valoda tiktu iestatīta uz \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Labi piemēri';

  @override
  String get explanation_section_bad_examples => 'Slikti piemēri';

  @override
  String get add_basic_details_product_name_help_title =>
      'Laba prakse: Produkta nosaukums';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Produkta nosaukums ir **galvenais nosaukums, kas uzdrukāts uz iepakojuma**. Tā var būt reģistrēta preču zīme.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Piezīme:** Lūdzu, nepievienojiet tulkojumu, **ja valoda nav norādīta uz iepakojuma**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomātu kečups';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Neiekļaujiet nosaukumā zīmolu';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomātu kečups **ražotājs Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Nelietojiet simbolus ®, ™, © vai līdzīgus';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count citi tulkojumi',
      one: '$count cits tulkojums',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Zīmola nosaukums';

  @override
  String get brand_names => 'Zīmolu nosaukumi';

  @override
  String get add_basic_details_brand_name_error =>
      'Lūdzu, ievadiet zīmola nosaukumu';

  @override
  String get add_basic_details_brand_names_hint =>
      'Ievades zīmoli (piemēram, Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Laba prakse: zīmoli';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Ievadiet **visus produkta zīmolus**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Galvenais zīmols';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Vispirms** jāievada **galvenais zīmols**, kas parasti ir skaidri redzams iepakojuma priekšpusē.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Citi zīmoli';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Kad to pārdod **liels uzņēmums**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** pārdod **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Pārdodot kopā ar savu zīmolu **tulkojumā vairākās valodās**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Dabas ieleja** dažreiz tiek rakstīta kā **Val Daba**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Daudzums un svars';

  @override
  String get add_basic_details_quantity_hint =>
      'Ievadiet svaru un, ja nepieciešams, daudzumu (piemēram, 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Laba prakse: Daudzums';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Nokopējiet uz produkta norādīto vērtību un **neaizmirstiet mērvienības**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** vai **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (6 olām)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(produktam ar 3 kastītēm, katra pa 150 g)';

  @override
  String get barcode => 'Svītrkods';

  @override
  String barcode_barcode(String barcode) {
    return 'Svītrkods: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Nederīgs svītrkods';

  @override
  String get basic_details_add_success =>
      'Pamatinformācija veiksmīgi pievienota';

  @override
  String get basic_details_add_error =>
      'Nevar pievienot pamatinformāciju. Lūdzu, mēģiniet vēlreiz pēc kāda laika.';

  @override
  String get clear_search => 'Notīrīt meklēšanu';

  @override
  String get confirm_clear =>
      'Jūs gatavojaties notīrīt visu savu vēsturi: vai tiešām vēlaties turpināt?';

  @override
  String get alert_clear_selected_user_list =>
      'Jūs gatavojaties notīrīt atlasītos vienumus savā vēsturē.';

  @override
  String get confirm_clear_selected_user_list =>
      'Vai tiešām vēlaties turpināt?';

  @override
  String get alert_select_items_to_clear =>
      'Lūdzu, atlasiet vienu vai vairākus vienumus, ko notīrīt';

  @override
  String confirm_clear_user_list(String name) {
    return 'Jūs tūlīt notīrīsiet šo sarakstu ($name): vai tiešām vēlaties turpināt?';
  }

  @override
  String get confirm_delete_user_list_title => 'Vai dzēst sarakstu?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Jūs gatavojaties dzēst sarakstu \"$name\".\nVai tiešām vēlaties turpināt?';
  }

  @override
  String get confirm_delete_user_list_button => 'Jā, es apstiprinu';

  @override
  String importance_label(String name, String id) {
    return '$name svarīgums: $id';
  }

  @override
  String get user_list_all_title => 'Saraksti';

  @override
  String get user_list_all_empty => 'Izveidojiet savu pirmo sarakstu';

  @override
  String get product_list_select => 'Atlasīt sarakstu';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkti',
      one: 'Viens produkts',
      zero: 'Tukšs saraksts',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Pievienot sarakstu';

  @override
  String get open_food_preferences_tooltip =>
      'Rediģējiet savas pārtikas preferences';

  @override
  String get add_photo_button_label => 'Pievienot fotoattēlu';

  @override
  String get add_packaging_photo_button_label =>
      'Nofotografējiet jebkādu iepakojuma/pārstrādes informāciju';

  @override
  String get add_origin_photo_button_label =>
      'Fotografējiet jebkādu izcelsmes informāciju';

  @override
  String get add_emb_photo_button_label =>
      'Nofotografējiet jebkādu izsekojamības koda informāciju';

  @override
  String get add_label_photo_button_label =>
      'Nofotografējiet visas etiķetes un sertifikācijas informāciju';

  @override
  String get choose_image_source_title => 'Izvēlieties attēla avotu';

  @override
  String get choose_image_source_body => 'Lūdzu, izvēlieties attēla avotu';

  @override
  String get gallery_source_label => 'Galerija';

  @override
  String get gallery_source_access_denied_dialog_title => 'Piekļuve liegta';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Diemžēl lietotne nevar piekļūt jūsu galerijai, jo jūs iepriekš esat liedzis atļauju.\n\nLūdzu, dodieties uz lietotnes iestatījumiem savā tālrunī sadaļā Iestatījumi -> Fotoattēli';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Atveriet iestatījumus';

  @override
  String get share => 'Dalīties';

  @override
  String share_product_text(String url) {
    return 'Apskatiet šo produktu vietnē Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Apskatiet šo produktu vietnē Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Apskatiet šo produktu vietnē Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Apskatiet šo produktu vietnē Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Apskatiet manu produktu sarakstu vietnē Open Food Facts: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Fotografēt';

  @override
  String get choose_from_gallery => 'Izvēlieties no galerijas';

  @override
  String get image_upload_queued =>
      'Attēls tiks augšupielādēts fonā, cik drīz vien iespējams.';

  @override
  String get add_price_queued =>
      'Cena tiks nosūtīta uz serveri, cik drīz vien iespējams.';

  @override
  String get background_task_title_full_refresh =>
      'Tiek sākta visu lokāli saglabāto produktu atsvaidzināšana';

  @override
  String get background_task_title_folksonomy =>
      'Servera darbību veikšanas sākšana lokāli saglabātajiem folksonomy atjauninājumiem';

  @override
  String get background_task_title_top_n =>
      'Sākam populārāko produktu lejupielādi';

  @override
  String get expand_nutrition_facts => 'Izvērst uzturvērtības faktu tabulu';

  @override
  String get expand_nutrition_facts_body =>
      'Saglabājiet uzturvērtības faktu tabulu paplašinātu';

  @override
  String get expand_ingredients => 'Izvērst sastāvdaļas';

  @override
  String get expand_ingredients_body =>
      'Saglabājiet sastāvdaļu paneli izvērstu';

  @override
  String get no_internet_connection => 'Nav interneta savienojuma';

  @override
  String get world_results_label => 'Visa pasaule';

  @override
  String get world_results_action => 'Paplašiniet savu meklēšanu visā pasaulē';

  @override
  String get copy_to_clipboard => 'Kopēt';

  @override
  String get paste_from_clipboard => 'Ielīmēt no starpliktuves';

  @override
  String get no_data_available_in_clipboard =>
      'Jūsu starpliktuvē nav pieejami dati';

  @override
  String get clipboard_barcode_copy => 'Kopēt svītrkodu starpliktuvē';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Svītrkods $barcode kopēts starpliktuvē!';
  }

  @override
  String get open_product_website => 'Atveriet šo produktu tīmekļa vietnē';

  @override
  String get language_picker_label => 'Jūsu valoda';

  @override
  String get country_picker_label => 'Jūsu valsts';

  @override
  String get currency_picker_label => 'Jūsu valūta';

  @override
  String get help_with_openfoodfacts => 'Palīdzība ar OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produkts tiks atjaunināts fonā, cik drīz vien iespējams.';

  @override
  String get no_email_client_available_dialog_title => 'Nav e-pasta lietotņu!';

  @override
  String get no_email_client_available_dialog_content =>
      'Lūdzu, manuāli nosūtiet mums e-pastu uz mobile@openfoodfacts.org';

  @override
  String get all_images => 'Visi attēli';

  @override
  String get selected_images => 'Atlasītie attēli';

  @override
  String get product_card_remove_product_tooltip => 'Noņemt produktu';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Jauns svītrkods noskenēts: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Noņemt visus produktus no karuseļa';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Lūdzu, skenējiet vismaz divus produktus, lai tos salīdzinātu.';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Noklikšķiniet, lai salīdzinātu skenētos produktus';

  @override
  String get scan_product_loading => 'Jūs esat noskenējis\nsvītrkodu:';

  @override
  String get scan_product_loading_initial =>
      'Mēs meklējam šo produktu!\nLūdzu, uzgaidiet dažas sekundes…';

  @override
  String get scan_product_loading_long_request =>
      'Mēs joprojām meklējam šo produktu!\nVai jums šķiet, ka ielāde aizņem ilgu laiku? Vai arī mēs…';

  @override
  String get scan_product_loading_unresponsive =>
      'Mēs joprojām meklējam šo produktu.\nVai vēlaties atsākt meklēšanu?';

  @override
  String get scan_product_loading_restart_button => 'Atsākt meklēšanu';

  @override
  String get portion_calculator_description =>
      'Aprēķiniet uzturvērtības faktus konkrētam daudzumam';

  @override
  String get portion_calculator_hint => 'Daudzums iekšā';

  @override
  String get portion_calculator_accessibility =>
      'Ievadiet daudzumu, lai aprēķinātu uzturvērtības faktus';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Lūdzu, ievadiet daudzumu no $min līdz $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Trūkst datu. Aprēķinu nevarēja veikt.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Uzturvērtības fakti $grams g (vai ml)';
  }

  @override
  String get offline_data => 'Bezsaistes dati';

  @override
  String get ocr_image_upload_instruction =>
      'Augšupielādējiet attēlu, lai automātiski iegūtu tajā esošo informāciju.';

  @override
  String get upload_image => 'Augšupielādēt fotoattēlu';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Neizdevās lejupielādēt attēlu';

  @override
  String get image_edit_url_error =>
      'Neizdevās rediģēt attēlu, jo attēla URL nebija iestatīts.';

  @override
  String get user_picture_source_remember => 'Atceries manu izvēli';

  @override
  String get user_picture_source_ask => 'Jautāt katru reizi';

  @override
  String get robotoff_continue => 'Turpināt';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count jautājumi',
      one: 'jautājums',
    );
    return 'Nākamais $_temp0';
  }

  @override
  String get show_password => 'Rādīt paroli';

  @override
  String get owner_field_info_title => 'Ražotāja sniegtās vērtības';

  @override
  String get owner_field_info_message =>
      'Ar šo logotipu mēs izceļam ražotāja sniegtos datus, un tos, iespējams, nevar rediģēt.';

  @override
  String get owner_field_info_close_button => 'Aizvērt šo informāciju';

  @override
  String get owner_field_image =>
      'Šo attēlu nodrošina producents. To, iespējams, nevar rediģēt.';

  @override
  String get edit_packagings_title => 'Iepakojuma komponenti';

  @override
  String get edit_packagings_element_add => 'Pievienot iepakojuma komponentu';

  @override
  String get edit_packagings_completed => 'Iepakojums ir pabeigts';

  @override
  String edit_packagings_element_title(int index) {
    return 'Iepakojuma komponents #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Vienību skaits';

  @override
  String get edit_packagings_element_hint_units =>
      'Ievadiet vienādas formas un materiāla iepakojuma vienību skaitu, kas ietilpst produktā.';

  @override
  String get edit_packagings_element_field_shape => 'Forma';

  @override
  String get edit_packagings_element_hint_shape =>
      'Ievadiet pārstrādes instrukcijās norādīto formas nosaukumu, ja tie ir pieejami, vai atlasiet formu.';

  @override
  String get edit_packagings_element_example_shape => 'Pudele';

  @override
  String get edit_packagings_element_field_material => 'Materiāls';

  @override
  String get edit_packagings_element_hint_material =>
      'Ievadiet konkrēto materiālu, ja to var noteikt (materiāla kodu trīsstūrī bieži var atrast uz iepakojuma detaļām), vai vispārīgu materiālu (piemēram, plastmasu vai metālu), ja neesat pārliecināts.';

  @override
  String get edit_packagings_element_example_material => 'Stikls';

  @override
  String get edit_packagings_element_field_recycling =>
      'Pārstrādes instrukcija';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Ievadiet pārstrādes instrukcijas tikai tad, ja tās ir norādītas uz produkta.';

  @override
  String get edit_packagings_element_example_recycling => 'Pārstrādāt';

  @override
  String get edit_packagings_element_field_quantity =>
      'Produkta neto daudzums uz vienību';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Ievadiet neto svaru vai neto tilpumu un norādiet mērvienību (piemēram, g vai ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Vienas tukšas vienības svars (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Pirms svēršanas izņemiet visus pārtikas atlikumus un nomazgājiet un nosusiniet iepakojuma daļu. Ja iespējams, izmantojiet svarus ar precizitāti 0,1 g vai 0,01 g.';

  @override
  String get background_task_title => 'Gaidāmie ieguldījumi';

  @override
  String get background_task_subtitle =>
      'Jūsu ieguldījums tiek automātiski saglabāts mūsu serverī, bet ne vienmēr reāllaikā.';

  @override
  String get background_task_list_empty => 'Nav gaidošu fona uzdevumu';

  @override
  String get background_task_error_server_time_out => 'Servera taimauts';

  @override
  String get background_task_error_no_internet =>
      'Interneta savienojuma kļūda. Mēģiniet vēlāk.';

  @override
  String get background_task_operation_unknown => 'nezināms darbības veids';

  @override
  String get background_task_operation_details => 'detalizētas izmaiņas';

  @override
  String get background_task_operation_image => 'fotoattēla augšupielāde';

  @override
  String get background_task_operation_refresh =>
      'atsvaidzināšana aizkavējas pēc fotoattēla augšupielādes';

  @override
  String get background_task_run_started => 'sāka';

  @override
  String get background_task_run_not_started => 'vēl nav sākts';

  @override
  String get background_task_run_to_be_deleted => 'tiks dzēsts';

  @override
  String get background_task_question_stop =>
      'Vai vēlaties pēc iespējas ātrāk pārtraukt šo uzdevumu?';

  @override
  String get feed_back => 'Atsauksmes';

  @override
  String get undo => 'Atsaukt';

  @override
  String get copy_email_to_clip_board => 'Kopēt e-pastu uz starpliktuvi';

  @override
  String get please_send_us_an_email_to =>
      'Lūdzu, manuāli nosūtiet mums e-pastu uz';

  @override
  String get email_copied_to_clip_board => 'E-pasts kopēts starpliktuvē!';

  @override
  String get select_accent_color => 'Izvēlieties akcenta krāsu';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Zils';

  @override
  String get color_cyan => 'Ciāna';

  @override
  String get color_green => 'Zaļš';

  @override
  String get color_light_brown => 'Noklusējuma';

  @override
  String get color_magenta => 'Fuksīna';

  @override
  String get color_orange => 'Oranžs';

  @override
  String get color_pink => 'Rozā';

  @override
  String get color_red => 'Sarkans';

  @override
  String get color_rust => 'Rūsa';

  @override
  String get color_teal => 'Zilganzaļa';

  @override
  String get text_contrast_mode => 'Teksta kontrasts';

  @override
  String get contrast_high => 'Augsts';

  @override
  String get contrast_medium => 'Vidējs';

  @override
  String get contrast_low => 'Zems';

  @override
  String get product_refresher_internet_not_found => 'Produkts nav atrasts!';

  @override
  String get product_refresher_internet_not_connected =>
      'Jums nav interneta savienojuma!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Serveris nedarbojas ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Servera kļūda ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produkts nav atrasts!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Produkts ar šādu svītrkodu mūsu datubāzē neeksistē: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Nav interneta pieslēguma!';

  @override
  String get product_loader_network_error_message =>
      'Lūdzu, pārbaudiet, vai jūsu viedtālrunis ir savienots ar Wi-Fi tīklu vai ir iespējoti mobilie dati.';

  @override
  String get page_not_found_title => 'Lapa nav atrasta!';

  @override
  String get page_not_found_button => 'Atgriezties sākumlapā';

  @override
  String get download_data => 'Lejupielādēt datus';

  @override
  String get download_top_products =>
      'Lejupielādējiet 1000 populārākos produktus savā valstī tūlītējai skenēšanai';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produktus',
    );
    return 'Lejupielādējiet labākos $_temp0 savā valstī, lai veiktu tūlītēju skenēšanu';
  }

  @override
  String get download_in_progress =>
      'Datu lejupielāde\nTas var aizņemt kādu laiku';

  @override
  String downloaded_products(int num) {
    return '$num pievienoti produkti';
  }

  @override
  String get update_offline_data => 'Atjaunināt bezsaistes produktu datus';

  @override
  String get update_local_database_sub =>
      'Atjauniniet vietējo produktu datubāzi ar jaunākajiem datiem no Open Food Facts.';

  @override
  String get clear_local_database => 'Notīrīt bezsaistes produktu datus';

  @override
  String get clear_local_database_sub =>
      'Lai atbrīvotu vietu, notīriet no lietotnes visus lokālos produktu datus';

  @override
  String deleted_products(int num) {
    return '$num produkti dzēsti';
  }

  @override
  String get loading => 'Ielādē…';

  @override
  String get know_more => 'Uzziniet vairāk';

  @override
  String get offline_data_desc =>
      'Noklikšķiniet, lai uzzinātu vairāk par bezsaistes datiem';

  @override
  String get offline_product_data_title => 'Bezsaistes produktu dati';

  @override
  String available_for_download(int num) {
    return '$num produkti pieejami tūlītējai skenēšanai';
  }

  @override
  String get country_selector_title => 'Izvēlieties savu valsti:';

  @override
  String get currency_selector_title => 'Izvēlieties savu valūtu:';

  @override
  String get language_selector_title => 'Izvēlieties valodu:';

  @override
  String get language_selector_section_selected => 'Atlasītās valodas';

  @override
  String get language_selector_section_frequently_used => 'Bieži lietots';

  @override
  String get action_delete_list => 'Dzēst';

  @override
  String get action_change_list => 'Mainīt pašreizējo sarakstu';

  @override
  String get product_list_create => 'Izveidot';

  @override
  String get product_list_create_tooltip => 'Izveidot jaunu sarakstu';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Jauns aprēķins)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (jauns aprēķins)';

  @override
  String get nutriscore_unknown => 'Nezināms Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nezināms Nutri-Score (Jauns aprēķins)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score nav piemērojams';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score nav piemērojams (jauns aprēķins)';

  @override
  String get environmental_score_generic_new => 'Zaļais rādītājs';

  @override
  String get environmental_score_a_new => 'Zaļais vērtējums A';

  @override
  String get environmental_score_b_new => 'Zaļais vērtējums B';

  @override
  String get environmental_score_c_new => 'Zaļais vērtējums C';

  @override
  String get environmental_score_d_new => 'Zaļais vērtējums D';

  @override
  String get environmental_score_e_new => 'Zaļais rādītājs E';

  @override
  String get environmental_score_unknown_new => 'Nezināms zaļais rādītājs';

  @override
  String get environmental_score_not_applicable_new =>
      'Zaļais rādītājs nav piemērojams';

  @override
  String get nova_group_generic_new =>
      'Ultraapstrādāti pārtikas produkti — NOVA grupas';

  @override
  String get nova_group_1 => 'NOVA 1. grupa';

  @override
  String get nova_group_2 => 'NOVA 2. grupa';

  @override
  String get nova_group_3 => 'NOVA 3. grupa';

  @override
  String get nova_group_4 => 'NOVA 4. grupa';

  @override
  String get nova_group_unknown => 'Nezināma NOVA grupa';

  @override
  String get nutrition_facts => 'Uzturvielu līmeņi';

  @override
  String get faq_title_partners => 'NVO partneri un patroni';

  @override
  String get faq_title_vision =>
      'Atvērto pārtikas faktu vīzija, misija, vērtības un programmas';

  @override
  String get faq_title_install_beauty =>
      'Instalējiet Open Beauty Facts, lai izveidotu kosmētikas datubāzi';

  @override
  String get faq_title_install_pet =>
      'Instalējiet Open Pet Food Facts, lai izveidotu mājdzīvnieku barības datubāzi';

  @override
  String get faq_title_install_product =>
      'Instalējiet Open Products Facts, lai izveidotu produktu datubāzi objektu kalpošanas laika pagarināšanai.';

  @override
  String get faq_nutriscore_nutriscore =>
      'Jauns Nutri-Score aprēķins: kas jauns?';

  @override
  String get contact_title_pro_page =>
      'Plusi? Importējiet savus produktus Open Food Facts platformā';

  @override
  String get contact_title_pro_email => 'Producenta kontaktinformācija';

  @override
  String get contact_title_press_page => 'Preses lapa';

  @override
  String get contact_title_press_email => 'Preses kontaktinformācija';

  @override
  String get contact_title_newsletter => 'Abonējiet mūsu jaunumus';

  @override
  String get contact_title_calendar => 'Abonējiet mūsu kopienas kalendāru';

  @override
  String get hunger_games_loading_line1 =>
      'Lūdzu, veltiet mums dažas sekundes…';

  @override
  String get hunger_games_loading_line2 => 'Mēs lejupielādējam jautājumus!';

  @override
  String get hunger_games_error_label =>
      'Ak vai! Kaut kas nogāja greizi… , un mēs nevarējām ielādēt jautājumus.';

  @override
  String get hunger_games_error_retry_button => 'Mēģināsim vēlreiz!';

  @override
  String get reorder_attribute_action => 'Pārkārtot atribūtus';

  @override
  String get link_cant_be_opened =>
      'Šo saiti nevar atvērt jūsu ierīcē. Lūdzu, pārbaudiet, vai ir instalēta pārlūkprogramma.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Sīkāka informācija par $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Detalizēta informācija par $pageName ar $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Dalīties';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Kas ir Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Kur atrast jauno Nutri-Score aprēķinu?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score tiek piemērots 7 valstīs: Francijā, Vācijā, Beļģijā, Spānijā, Luksemburgā, Nīderlandē un Šveicē.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Ražotājiem ir ne vairāk kā **2 gadi** pēc dekrēta parakstīšanas, **lai aizstātu** veco aprēķinu ar jauno.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Zaļais rādītājs';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Kāds ir zaļais rādītājs?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score ir logotips, kura mērķis ir informēt jūs par **pārtikas ietekmi uz vidi**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Krāsu kods atšķiras no tumši zaļas (**A+**) **vismazāk ietekmējošiem** produktiem līdz tumši sarkanai (**F**) **visietekmīgākiem** produktiem.';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score logotipi';

  @override
  String get guide_greenscore_lca_title =>
      'Kodols: Dzīves cikla novērtējums (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Pārtikas kategoriju zinātnisks novērtējums';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Katrai produktu kategorijai tiek noteikts **etalona** rādītājs, izmantojot datus no Agribalyse vides datubāzes (izstrādājušas ADEME un INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Dzīves cikla analīze** ir standartizēta novērtēšanas metode daudzpakāpju un daudzkritēriju vides novērtējuma veikšanai.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Tā izmēri:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 ražošanas soļi';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Lauksaimniecība';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Apstrāde';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Iepakojums';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transports';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Izplatīšana';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Patēriņš';

  @override
  String get guide_greenscore_lca_arg3_title => '14 ietekmes uz vidi rādītāji';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Klimata pārmaiņas/oglekļa pēdas nospiedums';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Ozona slāņa noārdīšanās';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Jonizējošais starojums';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Zeme';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Ūdens un enerģijas patēriņš';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Gaisa piesārņojums';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Jūras un saldūdens (daļiņas, paskābināšanās, eitrofikācija)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Resursu izsīkums.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonusi un sodi';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Lai apbalvotu labākus produktus noteiktā kategorijā, mēs piemērojam **bonusus un sodus, pamatojoties uz vairākiem kritērijiem**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Bonuss** tiek piešķirts produktiem, kuriem ir **oficiāla etiķete, marķējums vai sertifikāts, kas garantē ieguvumus videi** (bioloģisks, godīgas tirdzniecības, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Sastāvdaļu izcelsme';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Bonuss** tiek piešķirts, pamatojoties uz sastāvdaļu izcelsmi. Šis bonuss ņem vērā **ietekmi uz transportēšanu**, kā arī katra ražotāja valsts **vides politiku**.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Sods** tiek piemērots produktiem, kas satur sastāvdaļas, kurām ir būtiska **negatīva ietekme uz bioloģisko daudzveidību un ekosistēmām**, piemēram, palmu eļļa, kuras ražošana ir atbildīga par masveida mežu izciršanu.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Iepakojums';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Sods** tiek aprēķināts, ņemot vērā **iepakojuma aprites principu** (pārstrādātu izejvielu izmantošanu un pārstrādājamību) un pārmērīgu iepakošanu.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Lai precīzi aprēķinātu Zaļo rādītāju, ir nepieciešama **informācija, kas ne vienmēr ir norādīta uz iepakojuma** (piemēram, katras sastāvdaļas izcelsme un precīzs procentuālais daudzums) vai kas reti ir pieejama izmantojamā formā (piemēram, visu iepakojuma sastāvdaļu saraksts ar precīziem izmantotās plastmasas veidiem).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Ja šī informācija vēl nav pieejama, tiek izmantotas vidējās vērtības**, taču tagad mēs aicinām ikvienu palīdzēt mums apkopot šo informāciju, kas būs ļoti noderīga gan Green-Score aprēķinā, gan daudzos citos nolūkos.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Kā iedzīvotāji var palīdzēt?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Visi iedzīvotāji var mums palīdzēt apkopot un strukturēt informāciju, kas atrodas uz produktiem vai ko var no tiem secināt, piemēram, informāciju par **iepakojumiem**: \"Mission Emballages\": liela mēroga kopīga visu pārtikas produktu iepakojuma inventarizācija (franciski).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Kā ražotāji var palīdzēt';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Ražotāji var nosūtīt mums savu informāciju tieši, izmantojot mūsu bezmaksas platformu ražotājiem.';

  @override
  String get guide_greenscore_better_product_title =>
      'Kurš produkts ir labāks planētai?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'To var būt grūti pateikt';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Ilgtspējīgas pārtikas izvēle ir viena no spēcīgākajām lietām, ko varam darīt klimata labā, jo **mūsu globālā pārtikas sistēma ir atbildīga par vairāk nekā ceturto daļu no visām siltumnīcefekta gāzu emisijām**.\n(Avots: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Tev ir spēks!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Labā ziņa ir tā, ka tas dod mums spēcīgu veidu, kā radīt pārmaiņas.\n**Katrs no mums katru gadu apēd aptuveni 1000 ēdienreizes**. Tās ir 1000 iespējas **izvēlēties labāku nākotni planētai**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Palīdz būt atbildīgam un pieņemt lēmumus';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Ilgtspējīgas pārtikas izvēle var šķist sarežģīta. Etiķetes ir mulsinošas, un bieži vien trūkst informācijas. Green-Score sistēma tika izveidota, lai vienkāršotu šo procesu, sniedzot jums **skaidru**, **zinātniski pamatotu** un **caurspīdīgu** pārtikas produktu vides novērtējumu tieši tur, kur jums tas nepieciešams: iepirkšanās laikā.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Caurspīdīgums';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Atšķirībā no patentētām etiķetēm, Green-Score aprēķins ir **pilnīgi atvērts** un to var **pārbaudīt jebkurš**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'Kas ir ultraapstrāde?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA grupas informē jūs par pārtikas pārstrādes līmeni.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA klasifikācija ļauj iedalīt pārtikas produktus **4 grupās**, pamatojoties uz to **rūpnieciskās apstrādes pakāpi** (minimāli apstrādāti vai neapstrādāti pārtikas produkti, kulinārijas sastāvdaļas, pārstrādāti pārtikas produkti, īpaši pārstrādāti pārtikas produkti).';

  @override
  String get guide_nova_logos_caption => 'NOVA logotipi';

  @override
  String get guide_nova_groups_title => '4 NOVA grupas';

  @override
  String get guide_nova_groups_intro =>
      'Ir 4 NOVA grupas, no kurām problemātiskākā ir 4. grupa — īpaši pārstrādāti pārtikas produkti.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimāli apstrādāti vai neapstrādāti pārtikas produkti';

  @override
  String get guide_nova_groups_arg1_text =>
      'Neapstrādāti (jeb dabīgi) pārtikas produkti ir **augu** (sēklas, augļi, lapas, stublāji, saknes)**vai dzīvnieku** (muskuļi, subprodukti, olas, piens), kā arī sēnīšu, aļģu un ūdens ēdamās daļas pēc atdalīšanas no dabas.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'Apstrādātas kulinārijas sastāvdaļas, piemēram, **eļļas, sviests, cukurs un sāls**, ir vielas, kas iegūtas no 1. grupas pārtikas produktiem vai no dabas, izmantojot procesus, kas ietver presēšanu, rafinēšanu, malšanu, malšanu un žāvēšanu.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to Group 1** foods. processes include various preservation or cooking methods, and in the case Of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions Of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those Also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain Other sources of energy and nutrients not typically used in culinary preparations. some of these are Directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Problēmas ar ultraapstrādi';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Pārtikas sastāvdaļu ekstremāla apstrāde';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Daudzi no tiem ir **iegūti no pārtikas sastāvdaļu tālākas apstrādes**, piemēram, hidrogenētas vai interesterificētas eļļas, hidrolizēti proteīni, sojas proteīna izolāts, maltodekstrīns, invertcukurs un augsta fruktozes kukurūzas sīrups.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Piedevas, kas pārsniedz tikai pārtikas nekaitīguma prasības';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Ultraapstrādātu pārtikas produktu piedevas ietver dažas, ko izmanto arī pārstrādātos pārtikas produktos, piemēram, konservantus, antioksidantus un stabilizatorus. Piedevu klases, kas atrodamas tikai ultraapstrādātos produktos, ietver tās, ko izmanto, **lai atdarinātu vai uzlabotu pārtikas produktu sensorās īpašības vai maskētu galaprodukta nepatīkamās īpašības**. Šīs piedevas ietver krāsvielas un citas krāsvielas, krāsu stabilizatorus; aromatizētājus, garšas pastiprinātājus, bezcukura saldinātājus; un pārstrādes palīglīdzekļus, piemēram, karbonizācijas, stingrības, apjoma un apjoma samazināšanas vielas, putu novēršanas, pretsalipes un glazūras vielas, emulgatorus, sekvestrantus un mitrinātājus.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Apstrāde, ko nevar veikt mājās';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Tiek izmantots daudz dažādu procesu**, lai apvienotu parasti daudzās sastāvdaļas un izveidotu galaproduktu (tādēļ “ultra apstrādāts”). Procesi ietver vairākus procesus, **kuriem nav līdzinieku vietējā tirgū**, piemēram, hidrogenēšanu un hidrolīzi, ekstrūziju un formēšanu, kā arī pirmapstrādi cepšanai.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Ultraapstrādes plēsonīgie un finansiālie aspekti';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Ultraapstrādes vispārējais mērķis ir radīt firmas zīmola**, **ērtus** (izturīgus, gatavus patēriņam), **pievilcīgus** (ļoti garšīgus) un **ļoti ienesīgus** (ar zemām sastāvdaļām) pārtikas produktus, kas paredzēti, lai izspiestu visas pārējās pārtikas grupas. Ultraapstrādāti pārtikas produkti parasti tiek pievilcīgi iepakoti un intensīvi tirgoti.';

  @override
  String get guide_nova_explanations_arg5_title => 'Bīstamība veselībai';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Kopš 2018. gada ar NutriNet-Santé palīdzību ir pirmās reizes atklātas saiknes starp **ultra apstrādātu pārtikas produktu patēriņu un paaugstinātu vēža, sirds un asinsvadu slimību un diabēta risku**. Šodien šos atklājumus apstiprina vairāk nekā 90 pētījumi visā pasaulē.\nVisspēcīgākās saistības ir saistītas ar **aptaukošanos, sirds un asinsvadu mirstību un depresijas simptomiem**. Bērniem ietekme galvenokārt ir novērota svara un lipīdu nelīdzsvarotības ziņā.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Valstis iesaka tos ierobežot';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Dažas valstis izmanto NOVA grupas savām uztura vadlīnijām vai mērķiem, piemēram:\n\n- **🇧🇷 Brazīlijas** uztura vadlīnijas **iesaka ierobežot pārstrādātas pārtikas patēriņu** un izvairīties no īpaši pārstrādātas pārtikas.\n\n- **🇫🇷 Francijas** sabiedrības veselības uztura politikas mērķi 2018.–2022. gadam ir **samazināt 4. grupas īpaši pārstrādātu pārtikas produktu patēriņu par 20%**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Laipni lūdzam vietnē Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Kas ir Atklātie pārtikas fakti?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      '“Open Food Facts” ir **sadarbības**, **bezmaksas** un **atvērta** pārtikas produktu datubāze no visas pasaules.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Mēs uzskatām, ka ikvienam ir jābūt pieejamai informācijai par to, ko viņš ēd. Apkopojot datus par sastāvdaļām, alergēniem, uzturvērtības faktiem un citiem aspektiem, **mēs dodam patērētājiem iespēju izdarīt apzinātu izvēli** un virzām pārtikas nozari **uz lielāku pārredzamību**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Atvērto pārtikas faktu iezīmes';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Saņemiet brīdinājumus par nevēlamām sastāvdaļām';

  @override
  String get guide_open_food_facts_tips_title =>
      'Padomi lielisku fotoattēlu uzņemšanai';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Ko nedarīt';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Izvairieties no ēnām un atspīduma.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Nav izplūduša vai neasa teksta.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Neizgrieziet teksta daļas.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Izvairieties no rosīgas vides.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Darāmie ieteikumi';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Izmantojiet labu, vienmērīgu apgaismojumu.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Pārliecinieties, ka teksts ir ass un salasāms.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Apkopojiet visu sastāvdaļu sarakstu.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Novietojiet produktu uz līdzenas virsmas.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Palīdziet mums izveidot \"Ēdiena Vikipēdiju\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Uzturvērtības vērtējums';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Vērtējums, lai izvairītos no īpaši pārstrādātiem pārtikas produktiem';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Vērtējums planētai';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-lv.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Laipni lūdzam vietnē Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Kas ir atklātie mājdzīvnieku barības fakti?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      '“Open Pet Food Facts” paplašina mūsu misiju, iekļaujot mūsu pūkainos draugus! Tā ir **mājdzīvnieku barības produktu datubāze kaķiem, suņiem un citiem mājdzīvniekiem**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Mēs apkopojam informāciju par **sastāvdaļām**, **uzturvērtības analīzi** un barošanas vadlīnijām, lai palīdzētu mājdzīvnieku īpašniekiem izvēlēties labāko barību savu dzīvnieku vajadzībām.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Atvērtā mājdzīvnieku barības faktu sadaļas iezīmes';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Saņemiet brīdinājumus par nevēlamām sastāvdaļām';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Vai jūsu mājdzīvniekam ir alerģija pret kādu no sastāvdaļām? Lietotnē varat iestatīt to kosmētikas sastāvdaļu sarakstu, no kurām jāizvairās!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Padomi lielisku fotoattēlu uzņemšanai';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Ko nedarīt';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Izvairieties no ēnām un atspīduma.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Nav izplūduša vai neasa teksta.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Neizgrieziet teksta daļas.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Izvairieties no rosīgas vides.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Darāmie ieteikumi';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Izmantojiet labu, vienmērīgu apgaismojumu.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Pārliecinieties, ka teksts ir ass un salasāms.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Apkopojiet visu sastāvdaļu sarakstu.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Novietojiet produktu uz līdzenas virsmas.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Piezīme par punktu skaitīšanu';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Mājdzīvnieku barības vērtēšanas sistēmas izstrāde **pašlaik nav prioritāte**. Metodoloģija būtu sarežģīta, jo uztura vajadzības ievērojami atšķiras atkarībā no sugas, vecuma un veselības stāvokļa. Mēs vēl neesam atraduši neatkarīgu zinātnisku komandu, kas spētu izstrādāt šādu vērtēšanas sistēmu.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-lv.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Laipni lūdzam vietnē Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Kas ir Atklātie skaistumkopšanas fakti?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      '“Open Beauty Facts” ir **kosmētikas līdzekļu** sadarbības datubāze.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Mūsu mērķis ir atšifrēt sastāvdaļu sarakstus, lai palīdzētu jums **saprast, kas ir jūsu personīgās higiēnas līdzekļos**. Sākot ar mitrinātājiem un beidzot ar kosmētiku, mēs apkopojam datus par sastāvdaļām, alergēniem un iepakojumu, lai veicinātu pārredzamību kosmētikas nozarē.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Atvērto skaistumkopšanas faktu iezīmes';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Saņemiet brīdinājumus par nevēlamām sastāvdaļām';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Vai jums ir alerģija pret kādām sastāvdaļām? Vai vēlaties izvairīties no komedogēnām vielām? Vai vēlaties izvairīties no pretrunīgi vērtētām sastāvdaļām? Lietotnē varat iestatīt sarakstu ar kosmētikas sastāvdaļām, no kurām jāizvairās!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Padomi lielisku fotoattēlu uzņemšanai';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Ko nedarīt';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Izvairieties no ēnām un atspīduma.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Nav izplūduša vai neasa teksta.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Neizgrieziet teksta daļas.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Izvairieties no rosīgas vides.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Darāmie ieteikumi';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Izmantojiet labu, vienmērīgu apgaismojumu.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Pārliecinieties, ka teksts ir ass un salasāms.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Apkopojiet visu sastāvdaļu sarakstu.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Ja pudele ir izliekta, uzņemiet tik daudz attēlu, cik nepieciešams.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Lai redzētu sastāvdaļu sarakstu, iespējams, būs jāatlobī etiķete.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Novietojiet produktu uz līdzenas virsmas.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Piezīme par punktu skaitīšanu';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Atšķirībā no pārtikas produktiem, kosmētikas pasaulē **nav vispārēji atzītas, valdības atbalstītas vērtēšanas sistēmas kā Nutri-Score**. Sastāvdaļu ietekme var būt ļoti individuāla un atkarīga no ādas tipa, alerģijām un individuālām bažām.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-lv.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      '“Open Prices” ir projekts, kura mērķis ir **apkopot un kopīgot produktu cenas visā pasaulē**. Tas ir publiski pieejams datu kopums, ko var izmantot pētniecībai, analīzei un citiem mērķiem. “Open Prices” izstrādā un uztur “Open Food Facts”.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Mēs izmantojam atvērtā pirmkoda cenu datu kopas pūļa resursus**. Cenas var pievienot lietotāji, izmantojot šo tīmekļa lietotni vai oficiālo Open Food Facts mobilo lietotni. Arī mazumtirgotāji vai trešo pušu lietotnes var sniegt savu ieguldījumu, izmantojot mūsu API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Savāciet cenu zīmju fotoattēlus ejās';

  @override
  String get guide_open_prices_how_arg2_title => 'Savāciet čeku fotoattēlus';

  @override
  String get guide_open_prices_why_title => 'Kāpēc Open Food Facts to dara?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Informācija par cenām ir ārkārtīgi svarīga, lai izprastu pārtikas sistēmas. Tas ir galvenais faktors pārtikas izmaksu izpratnē un veselīgāka uztura veicināšanā. Sākotnējie cenu dati ir veids, kā atvieglot pētniekiem, žurnālistiem un pilsoņiem **labāku izpratni par to, kā pārtikas cenas mainās ģeogrāfiski un laikā**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Sekojiet līdzi cenu attīstībai laika gaitā';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Skatiet **cenu evolūciju**: sarukšanas inflācija, lētas inflācijas tendence, mēs varam tām izsekot kopā!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Salīdziniet cenas jūsu tuvumā';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Kad mēs iegūsim vairāk cenu, jūs varēsiet atrast **lētākos veikalus savā apkārtnē**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Vai apsvērāt cenu iegūšanu mazumtirgotāju tīmekļa vietnēs?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Cenu nokasīšana (Cenu skrāpēšana) ir apsvērta iespēja nākotnes Open Prices versijā, taču to veiktu pats Open Prices, lai mēs varētu iegūt cenas pierādījumu, pamatojoties uz HTML lapu.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Jūs varat sniegt savu ieguldījumu cenu noteikšanā, izmantojot mūsu API.\nJa vēlaties sniegt savu ieguldījumu cenu noteikšanā plašā mērogā, lūdzu, sazinieties ar mums pa e-pastu prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Laipni lūdzam Open Products Facts vietnē!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Kas ir atklātie produktu fakti?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      '“Open Products Facts” ir milzīga, atvērta datubāze **jebkuram produktam ar svītrkodu, kas nav pārtika, kosmētika vai mājdzīvnieku barība**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'No **elektronikas** līdz **rotaļlietām** un no **drēbēm** līdz **tīrīšanas līdzekļiem** — ja tam ir svītrkods, to var pievienot. Šī projekta mērķis ir izveidot “lietu internetu” ikdienas priekšmetiem, padarot informāciju par tiem universāli pieejamu.';

  @override
  String get guide_open_products_facts_features_title =>
      'Atvērto produktu faktu iezīmes';

  @override
  String get guide_open_products_facts_features_text =>
      '“Open Products Facts” mērķis ir sniegt patērētājiem iespēju **pagarināt priekšmetu kalpošanas laiku**, piedāvājot aprites ekonomikas risinājumus priekšmetu uzturēšanai, **remontam**, **pārstrādei** vai jaunu īpašnieku piešķiršanai.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Dažu produktu oglekļa pēdas nospiedums';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      'Francijas Vides pārvaldes ADEME **ietekmes uz CO2** dati sniedz daudzu kategoriju **oglekļa ietekmi**, tāpēc pārliecinieties, ka produkti ir precīzi kategorizēti.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Daudzu produktu remontējamības indekss';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Ikreiz, kad būs pieejams franču valodas remontējamības indekss, mēs to parādīsim. Turklāt **varat sākt apkopot mainīgos, izmantojot Folksonomy dzinēju**, lai mēs nākotnē varētu to paši atkārtoti aprēķināt, pat valstīs, kur tas nav pieejams.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Atrodiet veidus, kā ziedot/pārdot savu produktu';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Mēs piedāvājam saites uz **trešo pušu aprites videi draudzīgiem pakalpojumiem**, kas palīdz jums iegūt tieši tādu produktu, kādu meklējat, kā lietotu preci, lai saudzīgāk izturētos pret planētas resursiem.\nŅemiet vērā, ka mums par to netiek maksāts, un ka sistēma darbojas tikai kā piemērs divām tīmekļa vietnēm Francijā. Jūs varat palīdzēt paplašināt šo sistēmu, dokumentējot vairāk vietņu wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Kāda informācija ir noderīga?';

  @override
  String get guide_open_products_facts_information_text =>
      'Tik plašam vienumu klāstam **mūsu apkopotie dati ir elastīgi**. Lai to panāktu, **mēs izveidojām Folksonomy dzinēju**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Folksonomijas dzinējs';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy dzinējs ir rīks, kas palīdz jums papildināt produktus ar atbilstošām īpašībām. Tas palīdz uzlabot meklēšanu un atrodamību, kā arī aprēķināt un attēlot interesantas lietas nākotnē.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Varat pievienot jebkuras atslēgas un vērtības, piemēram: **saderība_ar_5G_mobile_network: jā**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Jūs saņemsiet automātiskus iespējamo īpašību ieteikumus, un jūs varat pievienot un dokumentēt jaunas īpašības par saviem iecienītākajiem produktu veidiem.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-lv.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Atvērt ēdienu preferences';

  @override
  String get guide_coming_soon_button_title => 'Drīzumā';

  @override
  String get guide_learn_more_subtitle => 'Pieskarieties, lai uzzinātu vairāk';

  @override
  String get preview_badge => 'Priekšskatījums';

  @override
  String get prices_feedback_form =>
      'Noklikšķiniet šeit, lai nosūtītu mums savu atsauksmi par šo jauno funkciju!';

  @override
  String get menu_button_list_actions => 'Atlasiet darbību';

  @override
  String get error_loading_photo => 'Kļūda, ielādējot fotoattēlu';

  @override
  String get photo_viewer_action_use_picture_as => 'Lietot kā…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Izmantojiet šo attēlu kā…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Izmantojiet šo attēlu kā… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Sīkāka informācija';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Šī fotoattēla detaļas';

  @override
  String get photo_viewer_details_title => 'Fotoattēla detaļas';

  @override
  String get photo_viewer_details_contributor_title => 'Atbalstītājs';

  @override
  String get photo_viewer_details_size_title => 'Izmērs';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pikseļi';
  }

  @override
  String get photo_viewer_details_date_title => 'Datums';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Saderīgs';

  @override
  String get user_lists_action_multi_select => 'Vairāku elementu atlase';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Jūsu saderības rādītājs: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Priekšējais attēls';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Sastāvdaļu attēls';

  @override
  String get product_image_nutrition_accessibility_label => 'Uztura attēls';

  @override
  String get product_image_packaging_accessibility_label => 'Iepakojuma attēls';

  @override
  String get product_image_other_accessibility_label => 'Cits attēls';

  @override
  String get product_image_outdated_message => 'Šis attēls var būt novecojis';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (šis attēls var būt novecojis)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (šo attēlu var bloķēt producents)';
  }

  @override
  String get product_image_error => 'Nevar ielādēt attēlu!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Nevar ielādēt $type (tīkla kļūda?)';
  }

  @override
  String get product_page_image_no_image_available => 'Nav\nattēla!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Šim produktam nav pieejams attēls';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Pārkārtot vai paslēpt darbības';

  @override
  String get product_page_action_bar_setting_modal_title => 'Rediģēt darbības';

  @override
  String get product_page_action_bar_item_move_up => 'Pārvietot uz augšu';

  @override
  String get product_page_action_bar_item_move_down => 'Pārvietot uz leju';

  @override
  String get product_page_action_bar_item_enable => 'Iespējot darbību';

  @override
  String get product_page_action_bar_item_disable => 'Atspējot darbību';

  @override
  String get product_page_pending_operations_banner_title =>
      'Augšupielādējiet savas izmaiņas…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Šajā lapā redzamie dati **vēl neatspoguļo jūsu veiktās izmaiņas**.\nLūdzu, uzgaidiet dažas sekundes…';

  @override
  String get product_add_a_language => 'Pievienot valodu';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Svītrkods $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Noņemt šo produktu no ruletes';

  @override
  String get carousel_unsupported_header => 'Neatbalstīts svītrkods!';

  @override
  String get carousel_unsupported_title => 'Ups!';

  @override
  String get carousel_unsupported_text =>
      'Open Food Facts neatbalsta skenēto svītrkodu!';

  @override
  String get carousel_error_header => 'Kļūda!';

  @override
  String get carousel_error_title => 'Tas ir žēl!';

  @override
  String get carousel_error_text_1 =>
      'Neizdevās lejupielādēt informāciju par šo svītrkodu:';

  @override
  String get carousel_error_text_2 =>
      'Lūdzu, pārbaudiet interneta savienojumu vai noklikšķiniet uz šīs pogas:';

  @override
  String get carousel_error_button => 'Atkārtot';

  @override
  String get carousel_unknown_product_header => 'Nezināms produkts';

  @override
  String get carousel_unknown_product_title =>
      'Apsveicu!\nTu esi atradis __reto dārgakmeni!__';

  @override
  String get carousel_unknown_product_text =>
      'Mūsu sadarbības datubāzē ir vairāk nekā **3 miljoni produktu**, taču šis svītrkods neeksistē: ';

  @override
  String get carousel_unknown_product_button => 'Pievienojiet šo produktu';

  @override
  String get carousel_loading_header => 'Notiek informācijas ielāde...';

  @override
  String get carousel_loading_title =>
      'Jūs tikko noskenējāt produktu ar šādu svītrkodu:';

  @override
  String get carousel_loading_text =>
      'Mēs to meklējam savā datubāzē, kurā ir vairāk nekā **3 miljoni produktu**!**';

  @override
  String get product_type_subtitle_food =>
      'Dārzeņi, augļi, saldēti pārtikas produkti…';

  @override
  String get product_type_subtitle_beauty => 'Kosmētika, ziepes, zobu pastas…';

  @override
  String get product_type_subtitle_pet_food => 'Barība suņiem, kaķiem…';

  @override
  String get product_type_subtitle_product => 'Viedtālruņi, mēbeles…';

  @override
  String get photo_field_front => 'Produkta fotoattēls';

  @override
  String get photo_field_ingredients => 'Sastāvdaļu foto';

  @override
  String get photo_field_nutrition => 'Uztura foto';

  @override
  String get photo_field_packaging => 'Pārstrādes instrukciju fotoattēls';

  @override
  String get photo_already_exists => 'Šī fotogrāfija jau pastāv';

  @override
  String get photo_missing => 'Šī fotoattēla trūkst';

  @override
  String get date => 'Datums';

  @override
  String get photo_rotate_left => 'Pagriezt pa kreisi';

  @override
  String get photo_rotate_right => 'Pagriezt pa labi';

  @override
  String get photo_undo_action => 'Atsaukt iepriekšējo darbību';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Pasaules karte ar $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap līdzstrādnieki';

  @override
  String get not_applicable_short => 'Nav pieejams';

  @override
  String get knowledge_panel_warning_text => 'Brīdinājums';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Kāpēc šis Nutri-Score atšķiras no tā, kas norādīts uz iepakojuma?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Ir divi iespējamie izskaidrojumi:\nSastāvdaļu saraksts un/vai uzturvērtības fakti nav atjaunināti.\n\nMēs piedāvājam Nutri-Score (vai V2) \"Jaunu aprēķinu\". Lūdzu, pārbaudiet, vai uz iepakojuma ir reklāmkarogs \"Jauns aprēķins\".';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Pārbaudiet sastāvdaļas';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Pārbaudiet uztura faktus';

  @override
  String url_not_supported(String url) {
    return 'Diemžēl mēs nevaram atvērt URL:\n$url';
  }

  @override
  String get product_list_export => 'Eksportēt';

  @override
  String get product_list_import => 'Importēt';

  @override
  String get product_footer_action_barcode => 'Skatīt svītrkodu';

  @override
  String get product_footer_action_barcode_short => 'Svītrkods';

  @override
  String get product_footer_action_open_website => 'Atvērt tīmekļa vietni';

  @override
  String get product_footer_action_report => 'Ziņojums';

  @override
  String get product_footer_action_contributor_guide => 'Palīdzība';

  @override
  String get product_footer_action_data_quality_tags => 'Datu kvalitāte';

  @override
  String get product_page_tab_for_me => 'Man';

  @override
  String get product_page_tab_website => 'Tīmekļa vietne';

  @override
  String get product_page_tab_prices => 'Cenas';

  @override
  String get prices_explanation_card_title => 'Kāpēc cenas?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** ir projekts, lai apkopotu un kopīgotu produktu cenas visā pasaulē 🌍. Open Prices izstrādā un uztur Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Uzziniet vairāk';

  @override
  String get product_page_tab_folksonomy => 'Folksonomija';

  @override
  String get folksonomy_explanation_card_title =>
      'Kādi ir folksonomijas atribūti?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atribūti ir balstīti uz **atslēgas vērtību**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Šīs īpašības izveido un iesniedz līdzstrādnieki jebkāda veida lietojumam.';

  @override
  String get folksonomy_action_external_link_title => 'Atvērt ārējo saiti';

  @override
  String get folksonomy_action_external_link_warning =>
      'Ārējās saites var būt nedrošas. Vai tiešām vēlaties tās apmeklēt?';

  @override
  String get prices_products_empty_title => 'Cena nav pieejama';

  @override
  String get prices_products_empty_explanation =>
      'Esi pirmais, kas sniedz savu ieguldījumu!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Populārākie $pageSize produkti (kopā: $total)';
  }

  @override
  String get app_review_title => 'Vai jums patīk šī lietotne?';

  @override
  String get app_review_low => 'Varētu labāk';

  @override
  String get app_review_medium => 'Nav slikti';

  @override
  String get app_review_high => 'Man tas ļoti patīk!';

  @override
  String get app_review_feedback_modal_title =>
      'Palīdziet mums uzlabot mūsu lietojumprogrammu';

  @override
  String get app_review_feedback_modal_content =>
      'Ja jums ir dažas minūtes, lūdzu, atbildiet uz šo veidlapu, lai **mēs varētu uzlabot turpmākos atjauninājumus**:';

  @override
  String get app_review_feedback_modal_open_form => 'Atbildiet uz veidlapu';

  @override
  String get app_review_feedback_modal_later => 'Pajautāt man vēlāk';

  @override
  String get nutrition_facts_extract_new =>
      'JAUNUMS: Jūs varat automātiski iegūt uzturvielas no attēla!';

  @override
  String get nutrition_facts_extract_button_text => 'Izvilkt tūlīt';

  @override
  String get nutrition_facts_extract_in_progress => 'Notiek ekstrakcija…';

  @override
  String get nutrition_facts_extract_successful => 'Ekstrakcija veiksmīga';

  @override
  String get nutrition_facts_extract_failed =>
      'Neizdevās iegūt barības vielas no attēla';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Statistika';

  @override
  String get prices_stats_title => 'Cenu statistika';

  @override
  String get prices_stats_prices_section => 'Cenas';

  @override
  String get prices_stats_products_section => 'Produkti';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Atbalstītāji';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Dažādi';

  @override
  String get prices_stats_total => 'Kopā';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Patēriņš';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Ēdiens';

  @override
  String get prices_stats_beauty => 'Skaistums';

  @override
  String get prices_stats_products => 'Produkti';

  @override
  String get prices_stats_pet_food => 'Mājdzīvnieku barība';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Countries';

  @override
  String get prices_stats_price_tag => 'Cenas zīme';

  @override
  String get prices_stats_receipt => 'Kvīts';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Tīmekļa vietne';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Citi';

  @override
  String get prices_stats_last_updated => 'Pēdējoreiz atjaunināts';

  @override
  String get prices_stats_error => 'Ielādējot statistiku, radās kļūda.';

  @override
  String get product_edit_robotoff_question_answered =>
      'Atbildēts uz jautājumu!';

  @override
  String get product_edit_robotoff_proof => 'Pierādījums';

  @override
  String get preferences_card_general => 'Vispārīgs';

  @override
  String get preferences_prices_title => 'Cenas';

  @override
  String get preferences_prices_subtitle => 'Pārvaldiet savas cenu preferences';

  @override
  String get preferences_card_project => 'Atvērto pārtikas faktu projekts';

  @override
  String get preferences_contribute_title => 'Veicināt / atbalstīt';

  @override
  String get preferences_my_contributions_title => 'Mani ieguldījumi';

  @override
  String get preferences_my_stats_title => 'Mana statistika';

  @override
  String get preferences_contribute_subtitle =>
      'Tulkojiet, uzlabojiet mūsu rīkus…';

  @override
  String get preferences_connect_title => 'Savienojuma izveide';

  @override
  String get preferences_connect_subtitle =>
      'Sazinieties ar mums vai sekojiet mums sociālajos tīklos';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Palīdziet mums informēt miljoniem patērētāju visā pasaulē';

  @override
  String get preferences_card_help => 'Palīdzība un atbalsts';

  @override
  String get preferences_faq_title => 'Bieži uzdotie jautājumi';

  @override
  String get preferences_faq_subtitle =>
      'Saņemiet atbildes uz saviem jautājumiem';

  @override
  String get logged_out => 'Izrakstīts';

  @override
  String get preferences_app_bar_message =>
      'Paldies, ka esat viens no mūsu biedriem!';

  @override
  String get preferences_app_bar_products_modified => 'Modificēti produkti';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Skatīt visu statistiku';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Meklēt $provider pēc \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Meklēt iestatījumu (piemēram, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Pieejamība: Rādīt emocijzīmes';

  @override
  String get preferences_accessibility_remove_colors =>
      'Pieejamība: Noņemt krāsas';

  @override
  String get preferences_app_settings_products => 'Produkti';

  @override
  String get preferences_card_about => 'Par';

  @override
  String get preferences_legal_information_title => 'Juridiskā informācija';

  @override
  String get preferences_legal_information_subtitle =>
      'Lietošanas noteikumi, privātuma politika un citi noteikumi';

  @override
  String get preferences_terms_of_use => 'Izmantošanas noteikumi';

  @override
  String get preferences_legal_mentions => 'Tiesību pieminēšana';

  @override
  String get preferences_legal_header =>
      '“Open Food Facts” ir pārtikas produktu datubāze, **ko izveidojuši visi, ikvienam**.\nTo var izmantot, lai izdarītu labākas izvēles attiecībā uz pārtiku, un, tā kā tie ir **atvērtie dati**, ikviens tos var **atkārtoti izmantot jebkādiem mērķiem**.';

  @override
  String get preferences_privacy_policy => 'Privātuma politika';

  @override
  String get preferences_licenses => 'Licences';

  @override
  String get preferences_about_app_title => 'Par lietotni';

  @override
  String get preferences_about_app_subtitle =>
      'Tehniskā informācija, informācija izstrādātājiem un cita informācija';

  @override
  String get preferences_card_information => 'Informācija';

  @override
  String get preferences_version_number_title => 'Versijas numurs';

  @override
  String get preferences_scanner_title => 'Skeneris';

  @override
  String get preferences_app_store => 'Lietotņu veikals';

  @override
  String get preferences_app_system_settings => 'Sistēmas iestatījumi';

  @override
  String get preferences_source_code => 'Piekļūstiet avota kodam';

  @override
  String get preferences_source_code_subtitle =>
      'Un sāciet ietekmēt miljoniem cilvēku';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Pastāsti pasaulei';

  @override
  String get preferences_tips => 'Padomi';

  @override
  String get tips_discover_nutriscore => 'Atklājiet jauno Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Atvērto pārtikas faktu tīmekļa vietnē';

  @override
  String get preferences_manage_account_title => 'Pārvaldīt manu kontu';

  @override
  String get preferences_manage_account_tooltip => 'Pārvaldiet savu kontu';

  @override
  String get preferences_change_password_title => 'Mainīt manu paroli';

  @override
  String get preferences_danger_zone => 'Bīstamā zona';

  @override
  String get preferences_account_deletion_subtitle =>
      'Visi jūsu ieguldījumi tiks zaudēti';

  @override
  String get preferences_contributions_title => 'Iemaksas';

  @override
  String get preferences_dev_mode_app_settings_title => 'Lietotnes iestatījumi';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Ļoti eksperimentāls veids, kā skenēt produktus bezsaistē';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Atsvaidzināt visus produktus no servera';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Lūdzu, izvairieties no tā, ja vien tas nav absolūti nepieciešams';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demonstrācijas režīms';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Pievienojiet kartes skenerim';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Pievieno skenerim 3 produktu paraugus';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Folksonomy saimnieks';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Resursdators: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Pieejamības eksperimenti';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Vairāku produktu izvēle pēc cenām';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Lietotāja sakārtoti zināšanu paneļi';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Pagaidu piekļuve atrašanās vietas meklēšanai';

  @override
  String get preferences_dev_mode_comparison_title =>
      '2 vai 3 produktu salīdzinājums blakus';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Produktu saraksta importēšana';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Rezultāti un metodoloģijas';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Uzziniet, kā tiek aprēķināts Nutri-Score rādītājs';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Atklājiet galvenās metodoloģijas izmaiņas';

  @override
  String get preferences_faq_discover_project_title => 'Atklājiet projektu';

  @override
  String get preferences_faq_discover_off_title =>
      'Atklājiet atklātos faktus par pārtiku';

  @override
  String get preferences_faq_discover_obf_title =>
      'Atklājiet atklātus skaistumkopšanas faktus';

  @override
  String get preferences_faq_discover_opff_title =>
      'Atklājiet faktus par mājdzīvnieku barību';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Atklājiet atklātos produktu faktus';

  @override
  String get preferences_faq_faq_title => 'BUJ — bieži uzdotie jautājumi';

  @override
  String get preferences_faq_off_ngo_title => 'NVO Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informācija';

  @override
  String get preferences_connect_community_updates_title =>
      'Saņemiet kopienas atjauninājumus';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Esiet lietas kursā par lietotnes un kopienas jaunumiem';

  @override
  String get preferences_connect_community_calendar_title =>
      'Abonējiet mūsu kopienas kalendāru';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Iesaistieties, apmeklējot kādu no mūsu virtuālajiem pasākumiem';

  @override
  String get preferences_connect_blog_title => 'Atvērto pārtikas faktu emuārs';

  @override
  String get preferences_connect_blog_subtitle =>
      'Saņemiet jaunākās ziņas, tiklīdz tās notiek';

  @override
  String get preferences_connect_community_help_title =>
      'Saņemiet palīdzību no kopienas';

  @override
  String get preferences_connect_improve_app_title =>
      'Palīdziet mums uzlabot lietotni';

  @override
  String get preferences_connect_debug_info_title =>
      'Nosūtiet mums atkļūdošanas informāciju';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Nosūtiet mums e-pastu ar detalizētu atkļūdošanas informāciju';

  @override
  String get preferences_connect_feedback_title =>
      'Sūtiet mums atsauksmes par lietotni';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Palīdziet veidot lietotnes nākotni';

  @override
  String get preferences_connect_survey_title => 'Aizpildiet lietotnes aptauju';

  @override
  String get preferences_connect_survey_subtitle =>
      'Palīdziet mums saprast, ko mums vajadzētu būvēt tālāk';

  @override
  String get preferences_connect_professionals_title => 'Profesionāļi';

  @override
  String get preferences_connect_pro_subtitle =>
      'Pilnīgi bez maksas, nodrošina precīzus datus 500 lietotnēm un miljoniem patērētāju. Pašapkalpošanās, saderīgs ar jūsu PIM vai izklājlapām (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Sazinieties ar mums, lai sāktu darbu';

  @override
  String get preferences_connect_press_title => 'Nospiediet';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Iegūstiet visus materiālus, kas nepieciešami jūsu ziņojumam';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Sazinieties ar mums, ja jums ir jautājumi presei vai vēlaties informēt mūs par savu ziņojumu';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Kļūsti par aktīvu brīvprātīgo';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Izstrāde, komunikācija, dizains… jebkāda veida brīvprātīgais darbs vai zināšanas ir laipni gaidītas!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Atklājiet dažus no daudzajiem veidiem, kā varat sniegt savu ieguldījumu';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Mobilo lietotņu izstrāde';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Uzziniet, kā dot savu ieguldījumu programmatūras izstrādē';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Ikdienas nestabilas versijas, pavisam jaunas funkcijas';

  @override
  String get preferences_contribute_local_community_title =>
      'Attīstiet savu vietējo kopienu';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Palīdzība ar programmatūras, satura, sastāvdaļu analīzes tulkojumiem';

  @override
  String get preferences_contribute_share_subtitle =>
      'Esam sagatavojuši nelielu veidni, lai jums palīdzētu :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Vienkārši soļi, lai palielinātu pārtikas pārredzamību jūsu valstī';

  @override
  String get preferences_contribute_data_quality_title => 'Datu kvalitāte';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Pievienojies datu kvalitātes komandai';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Pievienojieties mūsu centieniem nodrošināt datubāzes pilnīgumu un precizitāti';

  @override
  String get preferences_contributions_products_added_title =>
      'Pievienotie produkti';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Jauni produkti, ko pievienoju vietnei Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produkti, kas man jāpabeidz';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Visi nepabeigtie produkti';

  @override
  String get preferences_my_contributions_prices_title => 'Cenas';

  @override
  String get preferences_my_contributions_my_prices_title => 'Manas cenas';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Manas cenas, mani pierādījumi…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produkti, kuru pabeigšanu varat palīdzēt';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Palīdziet aprēķināt Nutri-Score un Green-Score jūsu valstī';

  @override
  String get preferences_prices_user_prices_subtitle => 'Manas norādītās cenas';

  @override
  String get preferences_prices_proofs_subtitle => 'Cenu zīmes un čeki';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Nofotografējiet savus čekus un noskenējiet saistītos svītrkodus';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Fotografējiet cenas veikalā';

  @override
  String get preferences_prices_newest_title => 'Jaunākās cenas';

  @override
  String get preferences_prices_newest_subtitle =>
      'Jaunākās cenas, ko pievienojusi Open Prices kopiena';

  @override
  String get preferences_prices_top_contributors_title =>
      'Līdzstrādnieki ar visvairāk cenām';

  @override
  String get preferences_prices_metrics_title => 'Atvērt cenu metriku';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Sekojiet līdzi projekta attīstībai';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Veidi, kā sniegt ieguldījumu';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Apstipriniet cenas, ko pievienojāt pats vai citi, izmantojot mākslīgo intelektu';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Ātri pievienojiet daudzus čekus vai plauktu fotoattēlus no kameras saraksta';

  @override
  String get preferences_prices_challenges_title => 'Mēneša izaicinājumi';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Piedalieties ikmēneša tematiskajos uzdevumos, lai savāktu balvas';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Atgūt savus lojalitātes datus';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Uzziniet, kā pieprasīt savus datus';

  @override
  String get preferences_page_customize_app_title => 'Pielāgojiet lietotni';

  @override
  String get preferences_page_contribute_project_title =>
      'Piedalīties projektā';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Vienkārši veidi, kā palīdzēt Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Vērtēšanas metodoloģijas, palīdzība un cita informācija par projektu';

  @override
  String get product_edit_robotoff_positive_button => 'Pieņemt ieteikumu';

  @override
  String get product_edit_robotoff_negative_button => 'Noraidīt ieteikumu';

  @override
  String get product_edit_robotoff_show_proof => 'Parādīt pierādījumus';

  @override
  String get product_edit_robotoff_expand_proof => 'Izvērst pierādījumu';

  @override
  String get product_page_tab_raw_data => 'Neapstrādāti dati';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Lapa $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Lapa $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count no $total vienumiem';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count no $total vienumiem';
  }

  @override
  String item_count(int count) {
    return '$count preces';
  }

  @override
  String item_count_string(String count) {
    return '$count preces';
  }

  @override
  String get prices_no_result => 'Nav atrasta cenu statistika.';

  @override
  String get prices_error_loading_more_items =>
      'Kļūda, ielādējot citus vienumus';

  @override
  String get prices_proof_error =>
      'Autentifikācija neizdevās, nevar izgūt pierādījumus';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count no $total pierādījumiem';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count no $total līdzstrādniekiem';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count no $total atrašanās vietām';
  }

  @override
  String prices_locations_count(int count) {
    return '$count atrašanās vietas';
  }

  @override
  String get restart_to_apply_message =>
      'Lūdzu, restartējiet lietotni, lai izmaiņas stātos spēkā.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafiskā saskarne';

  @override
  String get preferences_app_settings_media_title => 'Mediji';

  @override
  String get preferences_about_app_development_title => 'Izstrāde';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Atvērtās pārtikas faktu laboratorijas';

  @override
  String get preferences_root_account_title => 'Konts';

  @override
  String get preferences_contribute_translate_header =>
      'Atvērtie pārtikas fakti jūsu valodā';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Reģistrējieties lietotnes alfa versijai';

  @override
  String get preferences_dev_mode_section_data =>
      'Ieguldījumi un produktu dati';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Nerādīt folksonomu';

  @override
  String get preferences_account_title => 'Konts';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Pievienots $created';
  }

  @override
  String get location_map_details_title => 'Atrašanās vietas informācija';

  @override
  String get location_map_details_name => 'Nosaukums';

  @override
  String get location_map_details_street => 'Iela';

  @override
  String get location_map_details_city => 'Pilsēta';

  @override
  String get location_map_details_postcode => 'Pasta indekss';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Koordinātas';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
