// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Lithuanian (`lt`).
class AppLocalizationsLt extends AppLocalizations {
  AppLocalizationsLt([String locale = 'lt']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Taip';

  @override
  String get add => 'Pridėti';

  @override
  String get account_delete_message =>
      'Ar tikrai norite ištrinti savo paskyrą?\nJei yra kokia nors konkreti priežastis, nurodykite toliau';

  @override
  String get reason => 'Priežastis';

  @override
  String get okay => 'Gerai';

  @override
  String get validate => 'Patvirtinti';

  @override
  String get create => 'Kurti';

  @override
  String get applyButtonText => 'Taikyti';

  @override
  String get next_label => 'Kitas';

  @override
  String get continue_label => 'Tęsti';

  @override
  String get exit_label => 'Išeiti';

  @override
  String get previous_label => 'Ankstesnis';

  @override
  String get go_back_to_top => 'Grįžti į viršų';

  @override
  String get save => 'Išsaugoti';

  @override
  String get save_confirmation => 'Ar tikrai norite išsaugoti?';

  @override
  String get skip => 'Praleisti';

  @override
  String get cancel => 'Atšaukti';

  @override
  String get ignore => 'Ignoruoti';

  @override
  String get close => 'Uždaryti';

  @override
  String get no => 'Ne';

  @override
  String get stop => 'Sustabdyti';

  @override
  String get finish => 'Užbaigti';

  @override
  String get calculate => 'Apskaičiuoti';

  @override
  String get reset_food_prefs => 'Iš naujo nustatyti maisto nuostatas';

  @override
  String get error => 'Kažkas negerai nutiko';

  @override
  String get error_occurred => 'Įvyko klaida';

  @override
  String get featureInProgress =>
      'Mes vis dar dirbame ties šia funkcija, sekite naujienas';

  @override
  String get label_web => 'Žiūrėti internete';

  @override
  String get learnMore => 'Sužinokite daugiau';

  @override
  String get unknown => 'Nežinoma';

  @override
  String get match_very_good => 'Puikus atitikmuo';

  @override
  String get match_good => 'Geras atitikmuo';

  @override
  String get match_poor => 'Prastas atitikmuo';

  @override
  String get match_may_not => 'Gali nesutapti';

  @override
  String get match_does_not => 'Nesutampa';

  @override
  String get match_unknown => 'Nežinomas atitikmuo';

  @override
  String get match_short_very_good => 'Puikus atitikmuo';

  @override
  String get match_short_good => 'Geras atitikmuo';

  @override
  String get match_short_poor => 'Prastas atitikmuo';

  @override
  String get match_short_may_not => 'Gali nesutapti';

  @override
  String get match_short_does_not => 'Nesutampa';

  @override
  String get match_short_unknown => 'Nežinomas atitikmuo';

  @override
  String get licenses => 'Licencijos';

  @override
  String get looking_for => 'Ieškoti';

  @override
  String get welcomeToOpenFoodFacts => 'Sveiki atvykę į Open Food Facts';

  @override
  String get whatIsOff =>
      '„Open Food Facts“ yra pasaulinė ne pelno siekianti organizacija, kurios veiklą skatina vietos bendruomenės.';

  @override
  String get productDataUtility =>
      'Peržiūrėkite maisto duomenis, atitinkančius jūsų pageidavimus.';

  @override
  String get healthCardUtility => 'Pasirinkite maistą, kuris jums tinka.';

  @override
  String get ecoCardUtility =>
      'Pasirinkite maistą, kuris yra naudingas planetai.';

  @override
  String get server_error_open_new_issue =>
      'Serveris nepasiekimas! Galite iškelti problemą naudodami šią nuorodą.';

  @override
  String get sign_in_text =>
      'Prisijunkite prie „Open Food Facts“ paskyros, kad jūsų įneštas savanoriškas indėlis būtų išsaugotas';

  @override
  String get incorrect_credentials =>
      'Neteisingas prisijungimo vardas arba slaptažodis.';

  @override
  String get password_lost_incorrect_credentials =>
      'Šis el. pašto adresas arba naudotojo vardas neegzistuoja. Patikrinkite savo prisijungimo duomenis.';

  @override
  String get password_lost_server_unavailable =>
      'Šiuo metu mūsų serveriai veikia lėtai ir atsiprašome už tai. Bandykite dar kartą vėliau.';

  @override
  String get login => 'Prisijungti';

  @override
  String get login_result_type_server_unreachable => 'Tinklas nepasiekiamas';

  @override
  String get login_result_type_server_issue =>
      'Problema serveryje. Bandykite vėliau.';

  @override
  String get login_page_username_or_email =>
      'Įveskite slapyvardį arba el. paštą';

  @override
  String get login_page_password_error_empty => 'Įveskite slaptažodį';

  @override
  String get create_account => 'Sukurti paskyrą';

  @override
  String get sign_in => 'Prisijungti';

  @override
  String get sign_in_mandatory =>
      'Kad galėtumėte naudotis šia funkcija, turite prisijungti.';

  @override
  String get help_improve_country =>
      'Padėkite tobulinti „Open Food Facts“ savo šalyje';

  @override
  String get sign_out => 'Atsijungti';

  @override
  String get sign_out_confirmation => 'Ar tikrai norite atsijungti?';

  @override
  String get password => 'Slaptažodis';

  @override
  String get forgot_password => 'Pamiršote slaptažodį';

  @override
  String get forgot_password_question => 'Pamiršote slaptažodį?';

  @override
  String get view_profile => 'Peržiūrėti vartotojo profilį';

  @override
  String get reset_password => 'Atstatyti slaptažodį';

  @override
  String get reset_password_explanation_text =>
      'Jei pamiršote slaptažodį, įveskite savo vartotojo vardą arba el. pašto adresą, kad gautumėte slaptažodžio nustatymo iš naujo instrukcijas. Taip pat nepamirškite patikrinti pašto šiukšlių aplanko.';

  @override
  String get username_or_email =>
      'Vartotojo vardas arba elektroninio pašto adresas';

  @override
  String get reset_password_done =>
      'El. laiškas su slaptažodžio nustatymo nuoroda buvo išsiųstas su jūsų paskyra susietu el. pašto adresu. Taip pat patikrinkite savo šlamštą';

  @override
  String get send_reset_password_mail => 'Pakeisti slaptažodį';

  @override
  String get enter_some_text => 'Įveskite tekstą';

  @override
  String get sign_up_page_title => 'Registruotis';

  @override
  String get sign_up_page_action_button => 'Registruotis';

  @override
  String get sign_up_page_action_doing_it => 'Registruojama…';

  @override
  String get sign_up_page_action_ok =>
      'Sveikiname! Jūsų paskyra ką tik sukurta.';

  @override
  String get sign_up_page_display_name_hint => 'Vardas';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Įveskite rodomą pavadinimą, kurį norite naudoti';

  @override
  String get sign_up_page_email_hint => 'El. paštas';

  @override
  String get sign_up_page_email_error_empty =>
      'El. pašto adresas yra privalomas';

  @override
  String get sign_up_page_email_error_invalid =>
      'Neteisingas el. pašto adresas';

  @override
  String get sign_up_page_username_hint => 'Vartotojo vardas: matomas viešai';

  @override
  String get sign_up_page_username_error_empty => 'Įveskite vartotojo vardą';

  @override
  String get sign_up_page_username_error_invalid =>
      'Įveskite galiojantį vartotojo vardą';

  @override
  String get sign_up_page_username_description =>
      'Vartotojo varde negali būti tarpų, didžiųjų raidžių ar specialiųjų simbolių.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Vartotojo vardas negali būti ilgesnis nei $value simbolių';
  }

  @override
  String get sign_up_page_password_hint => 'Slaptažodis';

  @override
  String get sign_up_page_password_error_empty => 'Įveskite slaptažodį';

  @override
  String get sign_up_page_password_error_invalid =>
      'Įveskite galiojantį slaptažodį (mažiausiai 6 simboliai)';

  @override
  String get sign_up_page_confirm_password_hint => 'Patvirtinkite slaptažodį';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Pakartokite slaptažodį';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Slaptažodžiai nesutampa';

  @override
  String get sign_up_page_agree_text =>
      'Sutinku su atvirų maisto faktų svetaine';

  @override
  String get sign_up_page_terms_text => 'naudojimo ir įnašo sąlygomis';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Kuriant paskyrą sutikti su naudojimo sąlygomis yra privaloma, tačiau anonimiškai vis tiek galima pateikti informaciją per programėlę';

  @override
  String get sign_up_page_producer_checkbox => 'Esu maisto gamintoja';

  @override
  String get sign_up_page_producer_hint => 'Gamintojas/prekės ženklas';

  @override
  String get sign_up_page_producer_error_empty =>
      'Įveskite gamintoją arba prekės pavadinimą';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Norėčiau užsiprenumeruoti „Open Food Facts“ naujienlaiškį (galite bet kada atsisakyti prenumeratos)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Toks vartotojo vardas jau užimtas, prašome pasirinkti kitą.';

  @override
  String get sign_up_page_email_already_exists =>
      'jau egzistuoja, prisijunkite prie paskyros arba pabandykite naudodami kitą el.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Nurodykite teisingą el. pašto adresą.';

  @override
  String get sign_up_page_server_busy =>
      'Atsiprašome, kilo techninių sunkumų kuriant jūsų paskyrą. Bandykite dar kartą vėliau.';

  @override
  String get settingsTitle => 'Nustatymai';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Tamsus';

  @override
  String get darkmode_light => 'Šviesus';

  @override
  String get darkmode_system_default => 'Sistemos numatytasis';

  @override
  String get thanks_for_contributing => 'Ačiū, kad prisidėjote!';

  @override
  String get contributors_label => 'Jie kuria programėlę';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Bendraautorius (-ė): $name';
  }

  @override
  String get contributors_description =>
      'Visų šios programėlės bendraautorių sąrašas';

  @override
  String get support => 'Pagalba';

  @override
  String get support_join_slack => 'Paprašykite pagalbos mūsų „Slack“ kanale';

  @override
  String get support_via_forum => 'Paprašykite pagalbos mūsų forume';

  @override
  String get support_via_email => 'Atsiųskite mums el. laišką';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Siųsti programėlės išrašus?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Ar norite įtraukti programos išrašą į savo el. pašto priedą?';

  @override
  String get termsOfUse => 'Naudojimo sąlygos';

  @override
  String get legalNotices => 'Teisinė informacija';

  @override
  String get privacy_policy => 'Privatumo politika';

  @override
  String get about_this_app => 'Apie šią programėlę';

  @override
  String get contribute => 'Prisidėti';

  @override
  String get contribute_sw_development => 'Programinės įrangos kūrimas';

  @override
  String get contribute_develop_text =>
      'Kiekvieno „Open Food Facts“ produkto kodą galite rasti „GitHub“. Kviečiame pakartotinai naudoti kodą (jis yra atvirojo kodo) ir padėti mums jį tobulinti visiems, visoje planetoje.';

  @override
  String get contribute_develop_text_2 =>
      'Galite prisijungti prie „Open Food Facts Slack“ pokalbių kambario – tai yra pageidaujamas būdas užduoti klausimus.';

  @override
  String get contribute_develop_dev_mode_title => 'Programuotojo režimas?';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'Įjunkite programuotojo režimą';

  @override
  String get contribute_donate_title => 'Paaukokite';

  @override
  String get contribute_donate_header => 'Paaukokite „Open Food Facts“';

  @override
  String get contribute_enroll_alpha_warning =>
      'Atkreipkite dėmesį, kad naudojant vidinę alfa versiją, galimas visiškas duomenų praradimas ir programa gali bet kada tapti netinkama naudoti!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Produktai, kurie turi būti baigti';

  @override
  String get contribute_improve_header => 'Tobulėjimas';

  @override
  String get contribute_improve_text =>
      'Duomenų bazė yra projekto pagrindas. Ja padėti lengva ir labai greita. Galite atsisiųsti mobiliąją programėlę į savo telefoną ir pradėti pridėti arba tobulinti produktus.\n\nKita vertus, „Open Food Facts“ svetainė siūlo daug būdų prisidėti: ';

  @override
  String get contribute_translate_header => 'Išversti';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Pradėkite versti';

  @override
  String get contribute_translate_text =>
      '„Open Food Facts“ yra pasaulinis projektas, apimantis produktus iš daugiau nei 160 šalių. „Open Food Facts“ yra išverstas į dešimtis kalbų, o jo turinys nuolat kinta.';

  @override
  String get contribute_translate_text_2 =>
      'Vertimai yra viena iš pagrindinių projekto užduočių';

  @override
  String get contribute_join_skill_pool =>
      'Papildykite savo įgūdžiais „Open Food Facts“. Prisijunkite prie bendraautorių bazės!';

  @override
  String get contribute_share_header =>
      'Pasidalykite „Open Food Facts“ su draugais';

  @override
  String get contribute_share_content =>
      'Norėjau papasakoti apie programėlę „Open Food Facts“, kurią naudoju pats. Ji leidžia suasmenintai sužinoti jūsų maisto poveikį sveikatai ir aplinkai. Ji veikia nuskaitydama brūkšninius kodus ant pakuotės. Galiausiai, ji nemokama, nereikalauja registracijos ir netgi galite padėti padidinti iššifruojamų produktų skaičių. Štai nuoroda, kaip atsisiųsti ją į savo telefoną: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Prisidėkite prie kainų formavimo, pateikdami užklausą dėl lojalumo kortelių duomenų eksporto pagal BDAR';

  @override
  String get tap_to_answer => 'Bakstelėkite čia, kad atsakytumėte į klausimus';

  @override
  String get tap_to_answer_hint =>
      'Paspausk čia, kad atsakytum į klausimus apie šį produktą';

  @override
  String get robotoff_questions_loading_hint =>
      'Prašome palaukti, kol klausimai apie įš produktą užsikraus';

  @override
  String get saving_answer => 'Išsaugomas jūsų atsakymas';

  @override
  String get contribute_to_get_rewards => 'Tapkite maisto skaidrumo veikėju';

  @override
  String get question_sign_in_text =>
      'Prisijunkite prie savo „Open Food Facts“ paskyros, kad gautumėte kreditą už savo indėlį';

  @override
  String get question_yes_button_accessibility_value => 'Atsakyti „taip“';

  @override
  String get question_no_button_accessibility_value => 'Atsakyti „ne“';

  @override
  String get question_skip_button_accessibility_value =>
      'Praleisti šį klausimą';

  @override
  String get tap_to_edit_search => 'Paliesti ir redaguoti paiešką';

  @override
  String get myPreferences => 'Mano nustatymai';

  @override
  String get account_create_message =>
      'Sukurkite paskyrą ir prisijunkite prie „Open Food Facts“ bendruomenės, kad padėtumėte kaupti žinias apie maistą visame pasaulyje!';

  @override
  String get join_us => 'Prisijunkite prie mūsų';

  @override
  String get myPreferences_profile_title => 'Jūsų profilis';

  @override
  String get myPreferences_profile_subtitle =>
      'Tvarkykite savo „Open Food Facts“ paskyrą.';

  @override
  String get myPreferences_settings_title => 'Programos nustatymai';

  @override
  String get myPreferences_settings_subtitle => 'Tamsusis režimas, kalbos…';

  @override
  String get myPreferences_food_title => 'Maisto pasirinkimai';

  @override
  String get myPreferences_food_subtitle =>
      'Pasirinkite, kokia informacija apie maistą jums yra svarbiausia.';

  @override
  String get myPreferences_food_comment =>
      'Pasirinkite, kokia informacija apie maistą jums svarbiausia, kad galėtumėte suskirstyti maistą pagal savo pageidavimus, pirmiausia matyti jums rūpimą informaciją ir gauti suderinamumo santrauką. Šios maisto nuostatos lieka jūsų įrenginyje ir nėra susietos su jūsų „Open Food Facts“ bendraautorio paskyra, jei tokią turite.';

  @override
  String get confirmResetPreferences => 'Iš naujo nustatyti maisto nuostatas?';

  @override
  String get myPersonalizedRanking => 'Mano asmeninis reitingas';

  @override
  String get ranking_tab_all => 'Visi';

  @override
  String get ranking_subtitle_match_yes => 'Puikus pasirinkimas jums';

  @override
  String get ranking_subtitle_match_no => 'Itin prastas atitikmuo';

  @override
  String get ranking_subtitle_match_maybe => 'Nežinomas atitikmuo';

  @override
  String get refresh_with_new_preferences =>
      'Atnaujinkite sąrašą naudodami naujas nuostatas';

  @override
  String get reloaded_with_new_preferences =>
      'Iš naujo įkeltas su naujomis nuostatomis';

  @override
  String get profile_navbar_label => 'Bendruomenė';

  @override
  String get scan_navbar_label => 'Skenuoti';

  @override
  String get history_navbar_label => 'Istorija';

  @override
  String get list_navbar_label => 'Sąrašai';

  @override
  String get category => 'Filtruoti pagal kategoriją';

  @override
  String get category_all => 'Visi';

  @override
  String get category_search => '(kategorijų paieška)';

  @override
  String get filter => 'Filtras';

  @override
  String get scan => 'Produktai iš nuskaitymo ekrano';

  @override
  String get scan_history => 'Nuskaitymo istorija';

  @override
  String get search => 'Paieška';

  @override
  String get search_product_help =>
      'Ieškokite produkto,\nprekės ženklo arba brūkšninio kodo';

  @override
  String get search_filter => 'Paieškos filtras';

  @override
  String get search_history => 'Paieškos istorija';

  @override
  String get search_store => 'Ieškoti parduotuvės';

  @override
  String get search_store_help => 'Patarimas: pridėkite miestą arba šalį';

  @override
  String get tap_for_more =>
      'Bakstelėkite, kad pamatytumėte daugiau informacijos…';

  @override
  String get product => 'Produktas';

  @override
  String get unknownBrand => 'Nežinomas prekės ženklas';

  @override
  String get unknownQuantity => 'Nežinomas kiekis';

  @override
  String get unknownProductName => 'Nežinomas produkto pavadinimas';

  @override
  String get label_refresh => 'Atnaujinti';

  @override
  String get label_reload => 'Perkrauti';

  @override
  String get image => 'Vaizdas';

  @override
  String get front_photo => 'Priekio nuotrauka';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (šis vaizdas gali būti pasenęs)';
  }

  @override
  String get outdated_image_short_label => 'gali būti pasenę';

  @override
  String get ingredients => 'Sudėtis';

  @override
  String get ingredients_editing_instructions =>
      'Išlaikykite pirminį eiliškumą. Nurodykite procentus, jei reikalaujama. Atskirkite kableliu arba brūkšniu ir naudokite skliaustus sudedamosioms ingrediento dalims.';

  @override
  String get ingredients_editing_error => 'Nepavyko išsaugoti ingredientų.';

  @override
  String get ingredients_editing_image_error =>
      'Nepavyko gauti naujo ingredientų nuotraukos.';

  @override
  String get ingredients_editing_title => 'Redaguoti sudėtį';

  @override
  String get ingredients_photo => 'Sudėties nuotrauka';

  @override
  String get packaging_editing_instructions =>
      'Išvardykite visas pakuotės dalis, atskirtas kableliu arba eilute, nurodydami jų kiekį (pvz., 1 arba 6) tipą (pvz., butelis, dėžutė, skardinė), medžiagą (pvz., plastiką, metalą, aliuminį) ir, jei yra, dydį (pvz., 33 cl) ir perdirbimo instrukcijos.\nPavyzdys: 1 stiklinį butelį perdirbti, 1 plastikinį kamštį išmesti';

  @override
  String get packaging_editing_error => 'Nepavyko išsaugoti pakavimo.';

  @override
  String get packaging_editing_image_error =>
      'Nepavyko gauti naujo pakavimo vaizdo.';

  @override
  String get packaging_editing_title => 'Redaguoti pakavimą';

  @override
  String get nutrition => 'Maistingumas';

  @override
  String get nutrition_facts_photo => 'Maistingumo deklaracijos nuotrauka';

  @override
  String get nutrition_facts_editing_title => 'Redaguoti maistinę vertę';

  @override
  String get packaging_information => 'Perdirbimo instrukcijos';

  @override
  String get packaging_information_photo => 'Perdirbimo instrukcijos nuotrauka';

  @override
  String get missing_product => 'Radote naują produktą!';

  @override
  String get add_product_take_photos =>
      'Nufotografuokite pakuotę, kad galėtumėte įtraukti šį produktą į „Open Food Facts“';

  @override
  String get add_product_take_photos_descriptive =>
      'Pirmiausia padarykite kelias nuotraukas. Produktą visada galite užbaigti vėliau.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'Naujas produktas';

  @override
  String get new_product_found_title => 'Rastas naujas produktas!';

  @override
  String get new_product_found_text =>
      'Mūsų bendradarbiavimo duomenų bazėje yra daugiau negu **3 milijonai produktų**, tačiau šio brūkšninio kodo nėra: ';

  @override
  String get new_product_found_button => 'Pridėti šį produktą';

  @override
  String get new_product_leave_title => 'Palikti šį puslapį?';

  @override
  String get new_product_leave_message =>
      'Atrodo, kad nieko neįvedėte. Ar tikrai norite išeiti iš šio puslapio?';

  @override
  String get new_product_dialog_description =>
      'Nufotografuokite pakuotę, kad pridėtumėte šį produktą prie mūsų bendros duomenų bazės';

  @override
  String get new_product_dialog_illustration_description =>
      'Iliustracija su nežinomu „Nutri-Score“ ir „Green Score“';

  @override
  String get front_packaging_photo_button_label =>
      'Produkto priekinė nuotrauka';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Patvirtinkite gaminio priekinės nuotraukos įkėlimą';

  @override
  String get confirm_button_label => 'Patvirtinti';

  @override
  String get send_image_button_label => 'Siųsti vaizdą';

  @override
  String get crop_page_action_saving => 'Įrašomas vaizdas…';

  @override
  String get crop_page_action_cropping => 'Apkarpomas vaizdas…';

  @override
  String get crop_page_action_local => 'Įrašoma vietinė versija…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oi… jūsų nuotraukai kažkas yra!';

  @override
  String get crop_page_action_local_failed_message =>
      'Negalime apdoroti vaizdo vietoje, prieš išsiųsdami jį į savo serverį. Bandykite dar kartą vėliau arba susisiekite su mumis, jei problema nedingsta.';

  @override
  String get crop_page_action_retake => 'Perfotografuoti';

  @override
  String get crop_page_too_small_image_title => 'Paveikslėlis per mažas!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Mažiausias įkeliamų nuotraukų dydis pikseliais yra ${expectedMinWidth}x$expectedMinHeight. Dabartinė nuotrauka yra ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Ruošiamas skambutis į serverį…';

  @override
  String get front_packaging_photo_title => 'Priekinės pakuotės nuotrauka';

  @override
  String get ingredients_photo_title => 'Sudėties Nuotrauka';

  @override
  String get nutritional_facts_photo_title => 'Maistingumo duomenų nuotrauka';

  @override
  String get recycling_photo_title => 'Perdirbimo instrukcijos Nuotrauka';

  @override
  String get take_photo_title => 'Fotografuoti';

  @override
  String get take_more_photo_title => 'Nufotografuokite daugiau';

  @override
  String get front_photo_uploaded => 'Priekinė nuotrauka įkelta';

  @override
  String get ingredients_photo_button_label => 'Sudėties nuotrauka';

  @override
  String get ingredients_photo_uploaded => 'Ingredientų nuotrauka įkelta';

  @override
  String get nutrition_cache_loading_error =>
      'Nepavyko įkelti maistinių medžiagų iš talpyklos';

  @override
  String get nutritional_facts_photo_button_label =>
      'Maistingumo deklaracijos nuotrauka';

  @override
  String get nutritional_facts_input_button_label => 'Įveskite mitybos faktus';

  @override
  String get nutritional_facts_added => 'Pridėta mitybos faktų';

  @override
  String get categories_added => 'Pridėtos kategorijos';

  @override
  String get new_product_title_nutriscore => 'Apskaičiuoti „Nutri-Score“';

  @override
  String get new_product_subtitle_nutriscore =>
      'Gaukite jį užpildę maisto kategoriją ir maistines vertes';

  @override
  String get new_product_title_environmental_score =>
      'Apskaičiuoti „Green Score“';

  @override
  String get new_product_subtitle_environmental_score =>
      'Gaukite jį užpildę bent vieną kategoriją';

  @override
  String get new_product_additional_environmental_score =>
      'Gaukite tikslesnį „Green Score“ skaičiavimą, nurodydami kilmę, pakuotę ir t. t.';

  @override
  String get new_product_title_nova =>
      'Apskaičiuoti maisto apdorojimo lygį (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Gauti jį užpildžius maisto kategoriją ir ingredientus';

  @override
  String get new_product_desc_nova_unknown =>
      'Maisto perdirbimo lygis nežinomas';

  @override
  String get new_product_title_pictures =>
      'Nufotografuokime kelias nuotraukas!';

  @override
  String get new_product_title_pictures_details =>
      'Prašome nufotografuoti toliau pateiktas nuotraukas, o „Open Food Facts“ sistema sutvarkys likusią informaciją!';

  @override
  String get new_product_title_misc => 'Ir kai kurie pagrindiniai duomenys…';

  @override
  String new_product_done_msg(String username) {
    return 'Ačiū už jūsų indėlį „$username“!';
  }

  @override
  String get new_product_done_msg_no_user => 'Ačiū už jūsų indėlį!';

  @override
  String get new_product_done_button_label => 'Atraskite užbaigtą produktą';

  @override
  String get hey_incomplete_product_message =>
      'Bakstelėkite, kad atsakytumėte į 3 klausimus DABAR ir apskaičiuokite „Nutri-Score“, „Green Score“ ir ultraapdorojimą (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Bakstelėkite dabar, kad atsakytumėte į 2 klausimus, kurie padės išanalizuoti šią kosmetiką!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Bakstelėkite dabar, kad atsakytumėte į 3 klausimus, kurie padės išanalizuoti šį maisto produktą!';

  @override
  String get hey_incomplete_product_message_product =>
      'Bakstelėkite dabar, kad padėtumėte baigti šį produktą!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Įkelta Maistingumo lentelės nuotrauka';

  @override
  String get recycling_photo_button_label =>
      'Perdirbimo informacijos nuotrauka';

  @override
  String get recycling_photo_uploaded => 'Perdirbimo nuotrauka įkelta';

  @override
  String get take_more_photo_button_label => 'Nufotografuokite daugiau';

  @override
  String get other_photo_uploaded => 'Įkelta įvairi nuotrauka';

  @override
  String get retake_photo_button_label => 'Pakartoti';

  @override
  String get selecting_photo => 'Renkantis nuotrauką';

  @override
  String get uploading_image => 'Įkeliama nuotrauka į serverį';

  @override
  String get uploading_image_type_front =>
      'Priekinės nuotraukos įkėlimas į „Open Food Facts“';

  @override
  String get uploading_image_type_ingredients =>
      'Ingredientų paveikslėlio įkėlimas į „Open Food Facts“';

  @override
  String get uploading_image_type_nutrition =>
      'Mitybos paveikslėlio įkėlimas į „Open Food Facts“';

  @override
  String get uploading_image_type_packaging =>
      'Pakuotės paveikslėlio įkėlimas į „Open Food Facts“';

  @override
  String get uploading_image_type_other =>
      'Įkeliamas kitas vaizdas į „Open Food Facts“';

  @override
  String get uploading_image_type_generic =>
      'Įkeliamas vaizdas į „Open Food Facts“';

  @override
  String get score_add_missing_ingredients =>
      'Pridėkite trūkstamus ingredientus';

  @override
  String get score_add_missing_packaging_image =>
      'Pridėti trūkstamą pakuotės vaizdą';

  @override
  String get score_add_missing_nutrition_facts =>
      'Pridėkite trūkstamus mitybos faktus';

  @override
  String get score_add_missing_product_traces =>
      'Pridėti trūkstamus produkto pėdsakus';

  @override
  String get score_add_missing_product_category =>
      'Pridėkite trūkstamą produkto kategoriją';

  @override
  String get score_add_missing_precise_product_category =>
      'Pasirinkite tikslesnę kategoriją';

  @override
  String get score_add_missing_product_countries =>
      'Pridėti trūkstamas produktų šalis';

  @override
  String get score_add_missing_product_emb =>
      'Pridėti trūkstamus produktų atsekamumo kodus';

  @override
  String get score_add_missing_product_labels =>
      'Pridėkite trūkstamas produktų eitketes';

  @override
  String get score_add_missing_product_origins =>
      'Pridėti trūkstamas produktų kilmes';

  @override
  String get score_add_missing_product_stores =>
      'Pridėti trūkstamas produktų parduotuves';

  @override
  String get score_add_missing_product_brands =>
      'Pridėti trūkstamus produktų prekių ženklus';

  @override
  String get score_update_nutrition_facts => 'Atnaujinkite mitybos faktus';

  @override
  String get nutrition_page_title => 'Maistingumo faktai';

  @override
  String get nutrition_page_nutritional_info_title => 'Mitybos informacija';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Ant gaminio nurodytos vertės:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Taip';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Ne';

  @override
  String get nutrition_page_nutritional_info_open_photo =>
      'Atidaryti nuotrauką';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Geroji praktika: informacija apie maistingumą';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Kartais maistingumo faktai **nenurodyti ant pakuotės** arba prie produkto pridedamame dokumente. Tokiu ir tik tokiu atveju galite nustatyti reikšmę **NE**.';

  @override
  String get nutrition_page_serving_type_label => 'Maistinė vertė:';

  @override
  String get nutrition_page_per_100g => 'už 100 g';

  @override
  String get nutrition_page_per_100g_100ml => '100 g/ml';

  @override
  String get nutrition_page_per_serving => 'porcijoje';

  @override
  String get nutrition_page_add_nutrient => 'Pridėti maistinę medžiagą';

  @override
  String get nutrition_page_serving_size => 'Porcijos dydis';

  @override
  String get nutrition_page_serving_size_hint =>
      'Įveskite porcijos dydį (pvz.: 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Geroji praktika. Porcijos dydis';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Ši vertė padeda **proporcingai apskaičiuoti kiekvienos maistinės medžiagos kiekį vienoje porcijoje**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Leidžiami vienetai** yra: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫名,., 公升';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** ar **60 g** (pageidautinas pirmasis)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** arba **1 l**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Netinkamas vienetas';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **g**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Neteisingi vienetai';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **saldainiai** ir 2 **sausainiai**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Trūkstamas vienetas';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Neteisingas numeris';

  @override
  String get nutrition_page_update_running =>
      'Atnaujinamas produktas serveryje…';

  @override
  String get nutrition_page_update_done => 'Produktas atnaujintas!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Naudoti produkto kiekį kaip pateikiamą porciją';

  @override
  String get nutrition_page_photo_error => 'Nepavyko įkelti nuotraukos';

  @override
  String get more_photos => 'Daugiau įdomių nuotraukų';

  @override
  String get view_more_photo_button =>
      'Peržiūrėti visas esamas šio produkto nuotraukas';

  @override
  String get no_product_found => 'Prekės nerasta';

  @override
  String get no_location_found => 'Nerasta jokių vietų';

  @override
  String get not_found => 'nerastas:';

  @override
  String get refreshing_product => 'Produktas atnaujinamas';

  @override
  String get product_refreshed => 'Produktas atnaujintas';

  @override
  String product_image_accessibility_label(String date) {
    return 'Nuotrauka padaryta $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Nuotrauka padaryta $date. Ši nuotrauka gali būti pasenusi';
  }

  @override
  String get product_image_outdated => 'Ši vaizdas gali būti pasenęs';

  @override
  String get product_image_outdated_explanations_title =>
      'Ši vaizdas gali būti pasenęs';

  @override
  String get product_image_outdated_explanations_content =>
      'Ši nuotrauka daryta seniau negu prieš metus.\n**Patikrinkite, ar jis vis dar aktuali**.\n\nTai **tik įspėjimas**. Jei turinys vis dar toks pat, galite nepaisyti šio pranešimo.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Pakeisti nuotrauką ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Pridėti nuotrauką ($type)';
  }

  @override
  String get product_image_action_take_new_picture =>
      'Nufotografuoti naują nuotrauką';

  @override
  String get product_image_action_take_picture => 'Fotografuoti';

  @override
  String get product_image_action_from_gallery =>
      'Pasirinkite iš savo telefono galerijos';

  @override
  String get product_image_action_choose_existing_photo =>
      'Pasirinkite iš produkto nuotraukų';

  @override
  String get product_image_details_label => 'Informacija apie nuotrauką';

  @override
  String get product_image_details_from_producer => 'Iš gamintojo';

  @override
  String get product_image_details_contributor => 'Pagalbininkas';

  @override
  String get product_image_details_contributor_producer =>
      'Bendraautoris (prodiuseris)';

  @override
  String get product_image_details_date => 'Data';

  @override
  String get product_image_details_date_unknown => 'Nežinoma';

  @override
  String get homepage_main_card_logo_description =>
      'Sveiki atvykę į „Open Food Facts“';

  @override
  String get homepage_main_card_subheading =>
      '**Nuskaitykite** brūkšninį kodą arba\n**ieškokite** produkto';

  @override
  String get homepage_main_card_search_field_hint => 'Ieškoti produkto';

  @override
  String get homepage_main_card_search_field_tooltip => 'Pradėti paiešką';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Naujausios naujienos: $news_title';
  }

  @override
  String get tagline_app_review => 'Ar jums patinka ši programėlė?';

  @override
  String get tagline_app_review_button_positive => 'Man ji labai patinka! 😍';

  @override
  String get tagline_app_review_button_negative => 'Nelabai…';

  @override
  String get tagline_app_review_button_later => 'Paklauskite manęs vėliau';

  @override
  String get tagline_feed_news_button => 'Sužinoti daugiau';

  @override
  String get app_review_negative_modal_title =>
      'Jums nepatinka mūsų programėlė?';

  @override
  String get app_review_negative_modal_text =>
      'Ar galėtumėte skirti kelias sekundes ir pasakyti kodėl?';

  @override
  String get app_review_negative_modal_positive_button => 'Taip, žinoma!';

  @override
  String get app_review_negative_modal_negative_button => 'Ne';

  @override
  String get could_not_refresh => 'Nepavyko atnaujinti produkto';

  @override
  String get product_internet_error_modal_title => 'Įvyko klaida!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Dėl tinklo klaidos negalime gauti informacijos apie šį produktą. Patikrinkite interneto ryšį ir bandykite dar kartą.\n\nVidinė klaida:\n$error';
  }

  @override
  String get product_tags_title => 'Produkto savybės';

  @override
  String get no_product_tags_found_message =>
      'Jokių produkto savybių nerasta. Savybes galima naudoti produktams išsamiau ir lankstesčiau aprašyti.';

  @override
  String get product_tags_empty => 'Nėra savybių';

  @override
  String get product_tags_explanation =>
      'Pridėdami prie produkto savybių (raktą / vertę), padedate jį pagerinti.';

  @override
  String get add_tag => 'Pridėti savybę';

  @override
  String get add_tags => 'Pridėti savybes';

  @override
  String get add_edit_tags => 'Pridėti arba redaguoti savybes';

  @override
  String get edit_tag => 'Redaguoti savybę';

  @override
  String get remove_tag => 'Šalinti savybę';

  @override
  String get tag_key => 'Savybė';

  @override
  String get tag_keys => 'Ypatybės';

  @override
  String get tag_key_uneditable => 'Savybė (neredaguotina)';

  @override
  String get tag_key_input_hint => 'Įvesti savybę';

  @override
  String get tag_value => 'Vertė';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Įvesti vertę';

  @override
  String get tag_key_item => 'Savybė:';

  @override
  String get tag_value_item => 'Vertė:';

  @override
  String get tag_key_explanations =>
      'Raktas turi būti mažosiomis raidėmis ir be tarpų.';

  @override
  String tag_key_already_exists(String property) {
    return 'Žyma su savybe $property jau yra!';
  }

  @override
  String get product_internet_error =>
      'Neįmanoma gauti informacijos apie šį gaminį dėl tinklo klaidos.';

  @override
  String get cached_results_from => 'Rodyti rezultatus iš:';

  @override
  String get product_search_same_category => 'Rasti alternatyvų';

  @override
  String get product_search_same_category_short => 'Palyginti';

  @override
  String get product_search_same_category_error =>
      'Šią funkciją galima naudoti tik produktams, priklausantiems kategorijai.\n\nKad pridėtumėte kategoriją, redaguokite produktą.';

  @override
  String get product_improvement_add_category =>
      'Norėdami apskaičiuoti Nutri-Score, pridėkite kategoriją.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Pridėkite mitybos faktus, kad apskaičiuotumėte Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Pridėkite mitybos faktus ir kategoriją, kad apskaičiuotumėte Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Šio produkto Nutri-Score apskaičiuoti negalima, nes tai gali būti dėl, pvz., nestandartinės kategorijos. Jei tai laikoma klaida, susisiekite su mumis.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Mitybos vaizdas pasenęs: prašome jį atnaujinti.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Apskaičiuojant „Green Score“, atsižvelgiama į sudedamųjų dalių kilmę. Nufotografuokite ingredientų sąrašą ir (arba) bet kokį geografinį teiginį ar redaguokite produktą, kad būtų galima į juos atsižvelgti.';

  @override
  String get country_chooser_label => 'Pasirinkite šalį';

  @override
  String get currency_chooser_label => 'Pasirinkite valiutą';

  @override
  String get country_change_message => 'Ką tik pakeitėte šalį.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Ar norite pakeisti valiutą iš $previousCurrency į $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Pasirinkite šalį:';

  @override
  String get country_chooser_label_from_settings => 'Jūsų šalis';

  @override
  String get country_selection_explanation =>
      'Kai kurios aplinkos savybės priklauso nuo vietos';

  @override
  String get product_removed_comparison => 'Produktas pašalintas iš palyginimo';

  @override
  String get native_app_settings => 'Vietinės programos nustatymai';

  @override
  String get native_app_description =>
      'Atviros sistemos nustatymai, skirti „Open Food Facts“';

  @override
  String get product_removed_history => 'Produktas pašalintas iš istorijos';

  @override
  String get product_removed_list => 'Produktas pašalintas iš sąrašo';

  @override
  String get product_could_not_remove => 'Nepavyko pašalinti produkto';

  @override
  String get no_prodcut_in_list => 'Šiame sąraše nėra produkto';

  @override
  String get no_product_in_section => 'Šiame skyriuje nėra produkto';

  @override
  String get recently_seen_products => 'Visi peržiūrėti produktai';

  @override
  String get clear => 'Išvalyti';

  @override
  String get clear_long => 'Išvalyti sąrašą';

  @override
  String get really_clear => 'Ar tikrai norite ištrinti šį sąrašą?';

  @override
  String pct_match(Object percent) {
    return '$percent% atitikmuo';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prieš dienas',
      one: 'prieš vieną dieną',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prieš valandas',
      one: 'prieš valandą',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prieš minutes',
      one: 'prieš vieną minutę',
      zero: 'prieš mažiau nei minutę',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prieš mėnesius',
      one: 'prieš vieną mėnesį',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prieš savaites',
      one: 'prieš savaitę',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Palyginti $count Produktai',
      one: 'Palyginti vieną produktą',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pasirinkta produktų',
      one: 'Pasirinktas  vienas produktas',
      zero: 'Nepasirinktas joks produktas',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Palyginti pasirinktus produktus';

  @override
  String get delete_products_mode => 'Trinti pasirinktus produktus';

  @override
  String get select_all_products_mode => 'Pasirinkti visus produktus';

  @override
  String get select_none_products_mode => 'Nepasirinkti nieko';

  @override
  String get compare_products_appbar_title => 'Palyginkite produktus';

  @override
  String get compare_products_appbar_subtitle =>
      'Prašome pasirinkti bent du produktus';

  @override
  String get retry_button_label => 'Bandyti dar kartą';

  @override
  String get connect_with_us => 'Susisiekite su mumis';

  @override
  String get tiktok => 'Sekite mus „TikTok“';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Sekite mus „Instagram“';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Sekite mus X (anksčiau – „Twitter“)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Sekite mus platformoje „Mastodon“';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Sekite mus „BlueSky“';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blogas';

  @override
  String get faq => 'DUK';

  @override
  String get discover => 'Atrasti';

  @override
  String get how_to_contribute => 'Kaip prisidėti';

  @override
  String get hint_knowledge_panel_message =>
      'Galite paliesti bet kurią kortelės dalį, kad gautumėte daugiau informacijos apie tai, ką matote. Išbandykite dabar!';

  @override
  String get permissions_page_title => 'Prieiga prie kameros';

  @override
  String get permissions_page_body1 =>
      'Norėdami nuskaityti brūkšninius kodus savo telefono kamera, suteikite prieigos teisę.';

  @override
  String get permissions_page_body2 =>
      'Jei apsigalvosite, šią parinktį galite bet kada įjungti ir išjungti nustatymuose.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'Operacinė sistema: „Android“ („SDK“ Int: $sdkInt / Išleidimas: $release)\nModelis: $model\nProduktas: $product\nĮrenginys: $device\nGamintojas: $brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'Operacinė sistema: iOS ($version)\nModelis: $model\nLokalizuotas modelis: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nProgramos versija: $appVersion\nProgramos versijos numeris: $appBuildNumber\nProgramos paketo pavadinimas: $appPackageName';
  }

  @override
  String get authorize_button_label => 'Leisti';

  @override
  String get refuse_button_label => 'Atsisakyti';

  @override
  String get ask_me_later_button_label => 'Vėliau';

  @override
  String get are_you_sure => 'Ar tikrai?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Tęsti toliau $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Sveiki atvykę!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Programėlė, kuri padeda išsirinkti maistą, kuris yra naudingas **jums** ir **planetai**!';

  @override
  String get onboarding_continue_button => 'Tęsti';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Įkeliamas jūsų pirmasis produkto pavyzdys';

  @override
  String get onboarding_welcome_warning =>
      'Atsiprašome, tai mūsų pavyzdinis produktas, jo redaguoti negalima :)';

  @override
  String get product_list_your_ranking => 'Jūsų reitingas';

  @override
  String get product_list_empty_icon_desc => 'Istorija nepasiekiama';

  @override
  String get product_list_empty_title => 'Pradėti nuskaitymą';

  @override
  String get product_list_empty_message =>
      'Čia bus rodomi jūsų nuskaityti produktai ir galėsite peržiūrėti išsamią informaciją apie juos';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'prekės',
      one: 'prekė',
      zero: 'prekė',
    );
    return 'Atnaujinama $_temp0 jūsų istorijoje';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Produktai',
      one: 'Produktas',
      zero: 'Produktas',
    );
    return '$_temp0 atnaujinimas baigtas';
  }

  @override
  String get product_list_compare_side_by_side => 'Palyginti greta';

  @override
  String get loading_dialog_default_title => 'Atsisiunčiami duomenys';

  @override
  String get loading_dialog_default_error_message =>
      'Nepavyko atsisiųsti duomenų';

  @override
  String get account_delete => 'Ištrinti paskyrą';

  @override
  String get account_delete_title => 'Ištrinti mano paskyrą';

  @override
  String get user_profile => 'Paskyra';

  @override
  String get user_profile_title_guest => 'Sveiki!';

  @override
  String get user_profile_subtitle_guest =>
      'Prisijunkite arba užsiregistruokite, kad prisijungtumėte prie „Open Food Facts“ bendruomenės';

  @override
  String user_profile_title_id_email(String email) {
    return 'Prisijungimas prie „Open Food Facts“: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Sveiki $id!';
  }

  @override
  String get email_subject_account_deletion => 'Ištrinti paskyrą';

  @override
  String email_body_account_deletion(String userId) {
    return 'Sveiki, prašau ištrinti mano „Open Food Facts“ paskyrą: $userId';
  }

  @override
  String get settings_app_app => 'Programa';

  @override
  String get settings_app_data => 'Privatumas ir stebėjimas';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Produktai';

  @override
  String get settings_app_miscellaneous => 'Įvairūs';

  @override
  String get camera_play_sound_title => 'Paleiskite garsą nuskaitant';

  @override
  String get camera_play_sound_subtitle =>
      'Supypsi kiekvieną sėkmingą nuskaitymą';

  @override
  String get camera_window_accessibility_label =>
      'Nuskaitykite brūkšninį kodą savo kamera';

  @override
  String get app_haptic_feedback_title => 'Vibracija ir haptika';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibracijos atlikus kai kuriuos veiksmus (brūkšninis kodas iššifruotas, produktas pašalintas…).';

  @override
  String get crash_reporting_toggle_title => 'Pranešimas apie strigtis';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Kai ši funkcija įjungta, gedimų ataskaitos automatiškai pateikiamos „Open Food Facts“ klaidų sekimo sistemai, kad būtų galima ištaisyti klaidas ir taip patobulinti programėlę.';

  @override
  String get send_anonymous_data_toggle_title => 'Siųsti anoniminius duomenis';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Redaguoti nuotrauką';

  @override
  String get permission_photo_error => 'Klaida';

  @override
  String get permission_photo_denied_title =>
      'Leisti naudoti fotoaparatą brūkšniniams kodams nuskaityti';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Jei norite patobulinti patirtį, leiskite $appName pasiekti jūsų fotoaparatą. Galėsite tiesiogiai nuskaityti brūkšninius kodus.';
  }

  @override
  String get permission_photo_denied_button => 'Leisti';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Leidimas atmestas';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Kadangi anksčiau atmetėte fotoaparato leidimą, turite jį leisti rankiniu būdu nustatymuose.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Atidaryti nustatymus';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Atšaukti';

  @override
  String get permission_photo_none_found => 'Kamera neaptikta';

  @override
  String get permission_photo_denied => 'Prieiga prie fotoaparato nesuteikta';

  @override
  String get show_product_pictures => 'Rodyti produktų nuotraukas';

  @override
  String get edit_product_label => 'Redaguoti produktą';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Įkeliamos jūsų redakcijos…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Jūsų korekcijos **siunčiamos fone** (arba vėliau, jei įvyko klaida).\nGalite toliau redaguoti kitus produkto laukus.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Jūsų redakcijos **siunčiamos fone** (arba vėliau, jei įvyko klaida).';

  @override
  String get edit_product_label_short => 'Redaguoti';

  @override
  String edit_product_form_item_help(String value) {
    return 'Kaip įvesti „$value“?';
  }

  @override
  String get edit_product_form_item_error_empty => 'Įveskite netuščią vertę!';

  @override
  String get edit_product_form_item_error_existing => 'Ši vertė jau yra čia!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Pridėti naują prekės ženklą';

  @override
  String get edit_product_form_item_add_action_label => 'Pridėti naują etiketę';

  @override
  String get edit_product_form_item_add_action_store =>
      'Pridėti naują parduotuvę';

  @override
  String get edit_product_form_item_add_action_origin => 'Pridėti naują kilmę';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Pridėti naują atsekamumo kodą';

  @override
  String get edit_product_form_item_add_action_country => 'Pridėti naują šalį';

  @override
  String get edit_product_form_item_add_action_category =>
      'Pridėti naują kategoriją';

  @override
  String get edit_product_form_item_add_action_trace => 'Pridėti naują pėdsaką';

  @override
  String get edit_product_form_item_add_suggestion => 'Pridėti pasiūlymą';

  @override
  String get edit_product_form_item_deny_suggestion => 'Atmesti pasiūlymą';

  @override
  String get edit_product_form_item_details_title => 'Pagrindinės detalės';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Prekės pavadinimas, prekės ženklas, kiekis';

  @override
  String get edit_product_form_item_other_details_title =>
      'Papildoma informacija';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Svetainė…';

  @override
  String get edit_product_form_item_photos_title => 'Nuotraukos';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Pridėkite arba atnaujinkite nuotraukas';

  @override
  String get edit_product_form_item_labels_title => 'Etiketės ir sertifikatai';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Aplinkos; Kokybės žymos…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Įvesti etiketę (pvz., „NutriScore“)';

  @override
  String get edit_product_form_item_labels_type => 'etiketė';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Geroji praktika. Etiketės';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Bet kokia produkto savybė, **kuri yra faktinė** ir skiriasi nuo kitų laukų savybių.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      '„Nutri-Score“, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Pagaminta Belgijoje, pagaminta Bretanėje…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Daug skaidulų, geležies šaltinis…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Sąžininga prekyba, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Parduotuvės';

  @override
  String get edit_product_form_item_stores_hint => 'Įvesti parduotuvę';

  @override
  String get edit_product_form_item_stores_type => 'parduotuvė';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Geroji praktika: parduotuvės';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Įveskite parduotuvės, kurioje įsigijote prekę, pavadinimą.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      '„Walmart“';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      '„Carrefour“';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Kilmė';

  @override
  String get edit_product_form_item_origins_hint =>
      'Įvesti kilmę (pvz., jautiena iš Argentinos)';

  @override
  String get edit_product_form_item_origins_type => 'šalis';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Geroji praktika: kilmė';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Pridėkite **visas kilmės nuorodas, kurias galite rasti ant pakuotės**.\nJums nereikia jaudintis dėl kilmės, nurodytos tiesiogiai ingredientų sąraše.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Jautiena iš Argentinos';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soja nėra kilusi iš Europos Sąjungos';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Įvesti šalį (pvz., Vokietija)';

  @override
  String get edit_product_form_item_countries_type => 'šalis';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Geroji praktika: šalys';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Šalys, kuriose produktas yra plačiai prieinamas** (neįskaitant parduotuvių, kurios specializuojasi užsienio produktų srityje).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Atsekamumo kodai';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Įvesti kodą (pvz.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'atsekamumo kodas';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Geroji praktika: atsekamumo kodai';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Šiame skyriuje galite įvesti kodus, susijusius su **pakavimo ženklais**, **identifikavimo ženklais** arba **sveikumo ženklais**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Atsekamumo kodų pavyzdžiai';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EB kodai**, naudojami Europos bendrijoje maisto produktų gamintojams arba pakuotojams identifikuoti:**';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: Prancūzijos šalies kodas\n**72.264.002**: geografiniai duomenys\n**CE**: Europos bendrija';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB kodai**, naudojami Prancūzijoje:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Pėdsakai';

  @override
  String get edit_product_form_item_traces_hint => 'pėdsakas';

  @override
  String get edit_product_form_item_traces_type =>
      'Įveskite pėdsaką (pvz.: sojų pupelės)';

  @override
  String get edit_product_form_item_categories_title => 'Kategorijos';

  @override
  String get edit_product_form_item_categories_hint => 'kategorija';

  @override
  String get edit_product_form_item_categories_type =>
      'Įvesti kategoriją (pvz., apelsinų sultys)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Geroji praktika: Kategorijos';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Nurodykite **tik pačią konkrečiausią kategoriją**.\nPagrindinės kategorijos bus pridėtos automatiškai.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Trūksta kategorijos?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Jei kategorija **nepasiekiama automatinio užbaigimo funkcija**, vis tiek galite ją pridėti.\nTai padės mums tobulinti „Open Food Facts“ jūsų šalyje.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardinės alyvuogių aliejuje';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Apelsinų sultys iš koncentrato';

  @override
  String get edit_product_form_item_exit_title => 'Išeiti neišsaugojus?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Ar norite išsaugoti pakeitimus prieš išeidami iš šio puslapio?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Įrašyti pakeitimus';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Išmesti pakeitimus';

  @override
  String get edit_product_form_item_ingredients_title => 'Sudėtis';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Priartinkite ir atitolinkite ekraną suspaudžiant pirštais';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Priartinkite ir atitolinkite nuotrauką';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Naudodami **Suspaudimo, kad priartintumėte** gestą, galite priartinti arba atitolinti nuotrauką:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Pridėti';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Pirmiausia įveskite tekstą';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Pašalinti';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Įrašyti savo korekciją';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Atšaukti savo korekciją';

  @override
  String get edit_product_form_item_packaging_title =>
      'Perdirbimo instrukcijos nuotrauka';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Maistingumas';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Maistingumas, alkoholio kiekis…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Gera praktika: maistingumo faktai';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Maistinė vertė';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Pirmiausia pasirinkite, ar pateiktos **reikšmės**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Maistingumas';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Tada įveskite maistinę vertę **kaip nurodyta ant pakuotės**. Jei vertės nėra, galite spustelėti piktogramą „Akis“.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Trūkstamas laukas?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Jei įrašo trūksta, galite **spustelėti pliuso piktogramą**, kad jį pridėtumėte (pvz.: vitaminas D, magnis…).';

  @override
  String get edit_product_form_save => 'Redaguoti';

  @override
  String get edit_product_ingredients_photo_title => 'Sudėties nuotrauka';

  @override
  String get edit_product_ingredients_list_title => 'Sudedamųjų dalių sąrašas';

  @override
  String get edit_product_packaging_photo_title => 'Pakuotės nuotrauka';

  @override
  String get edit_product_packaging_list_title => 'Pakuotės sąrašas';

  @override
  String get no_data_available => 'Nėra duomenų';

  @override
  String get product_field_website_title => 'Interneto svetainė';

  @override
  String get origins_editing_title => 'Redaguoti kilmę';

  @override
  String get completed_basic_details_btn_text =>
      'Užpildyti pagrindinę informaciją';

  @override
  String get not_implemented_snackbar_text => 'Dar neįgyvendinta';

  @override
  String get category_picker_page_appbar_text => 'Kategorijos';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Ištraukite ingredientus iš nuotraukos';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Nuskaityti ingredientus';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Ingredientų\ništraukimas iš nuotraukos';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Kraunama nuotrauka…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Kodėl matau šį pranešimą?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Kad pasinaudotumėte funkcija „Ištraukti sudedamąsias dalis“, pirmiausia reikia įkelti nuotrauką.\n\nPalaukite kelias sekundes arba įveskite rankiniu būdu.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Atnaujinti nuotrauką';

  @override
  String get edit_packaging_extract_btn_text =>
      'Ištraukite pakuotę\niš nuotraukos';

  @override
  String get edit_packaging_extract_btn_text_short => 'Pakuotės ištraukimas';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Pakuotės išėmimas iš nuotraukos';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Kraunama nuotrauka…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Kodėl matau šį pranešimą?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Kad pasinaudotumėte funkcija „Ištraukti pakuotę“, pirmiausia reikia įkelti nuotrauką.\n\nPalaukite kelias sekundes arba įveskite rankiniu būdu.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Atnaujinti nuotrauką';

  @override
  String get edit_ocr_extract_failed => 'Nepavyko aptikti teksto vaizde.';

  @override
  String get edit_ocr_extract_disabled_title => 'Nėra nuotraukos!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Kad galėtumėte naudoti teksto ištraukimo funkcija, pirmiausia būtina nufotografuoti.';

  @override
  String get user_list_dialog_new_title => 'Naujas produktų sąrašas';

  @override
  String get user_list_dialog_rename_title => 'Pervadinti sąrašą';

  @override
  String get user_list_subtitle_product => 'Sąrašai';

  @override
  String get user_list_title => 'Jūsų sąrašai';

  @override
  String get user_list_add_product => 'Įtraukti produktą į savo sąrašus';

  @override
  String get user_list_button_new => 'Sukurti naują sąrašą';

  @override
  String get user_list_empty_label =>
      'Jokio sąrašo dar nėra!\nPradėkite ir sukurkite jį.';

  @override
  String get user_list_button_add_product => 'Pridėti prie sąrašo';

  @override
  String get added_to_list_msg => 'Pridėta prie sąrašo';

  @override
  String get user_list_popup_clear => 'Išvalyti savo istoriją';

  @override
  String get user_list_popup_rename => 'Pervardyti';

  @override
  String get user_list_name_hint => 'Mano sąrašas';

  @override
  String get user_list_name_error_empty => 'Vardas yra privalomas';

  @override
  String get user_list_name_error_already => 'Tas vardas jau naudojamas';

  @override
  String get user_list_name_error_same => 'Tai tas pats vardas';

  @override
  String get user_list_name_input_hint => 'Sąrašo pavadinimas';

  @override
  String get try_again => 'Bandyti dar kartą';

  @override
  String get there_was_an_error => 'Įvyko klaida';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Nerasta $items kategorijos';
  }

  @override
  String get camera_toggle_camera =>
      'Perjungti galinę kamerą į priekinę ir atvirkščiai';

  @override
  String get camera_toggle_flash => 'Įjungti arba išjungti kameros blykstę';

  @override
  String get camera_enable_flash => 'Įjungti blykstę';

  @override
  String get camera_disable_flash => 'Išjungti blykstę';

  @override
  String get camera_flash_error_dialog_title => 'Įvyko klaida!';

  @override
  String get camera_flash_error_dialog_message =>
      'Keičiant jūsų blykstės būseną įvyko klaida. Patikrinkite, ar jūsų išmaniajame telefone dar nėra įjungtas žibintuvėlis.';

  @override
  String get category_picker_no_category_found_button => 'Grįžti';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Spustelėkite, kad atidarytumėte naršyklėje arba programėlėje (jei įdiegta)';

  @override
  String get dev_preferences_screen_title => 'Kurėjo režimas';

  @override
  String get dev_preferences_screen_subtitle =>
      'Pasiekite eksperimentines funkcijas ir kūrimo įrankius';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Iš naujo paleiskite onboarding\'ą';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Tada turite iš naujo paleisti programėlę, kad vėl ją matytumėte.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Perjunkite tarp openfoodfacts.org (PROD) ir testavimo env';

  @override
  String get dev_preferences_test_environment_title =>
      'Bandomosios aplinkos parametrai';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Bazinis dabartinio bandymo env URL: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Bandomosios aplinkos svetainės kompiuteris';

  @override
  String get dev_preferences_ml_kit_title => 'Naudokite „ML“ rinkinį';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'tada turėsite iš naujo paleisti šią programą';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Papildomas mygtukas produkto puslapyje';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Redaguokite ingredientus naudodami žinių skydelio mygtuką';

  @override
  String get dev_preferences_export_history_title => 'Eksportuoti istoriją';

  @override
  String get dev_preferences_export_history_progress_error => 'išimtis';

  @override
  String get dev_preferences_export_history_progress_found =>
      'rastas produktas';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produkto nerasta';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Eksportuoti istoriją';

  @override
  String get dev_preferences_button_positive => 'Gerai';

  @override
  String get dev_preferences_button_negative => 'Atšaukti';

  @override
  String get dev_preferences_migration_title => 'Duomenų perkėlimas iš V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Statusas: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'sėkmė arba naujas įdiegimas';

  @override
  String get dev_preferences_migration_status_success => 'pavyko';

  @override
  String get dev_preferences_migration_status_error => 'klaida';

  @override
  String get dev_preferences_migration_status_in_progress => 'vykdoma';

  @override
  String get dev_preferences_migration_status_required =>
      'būtina (spustelėkite norėdami pradėti)';

  @override
  String get dev_preferences_migration_status_not_started => 'nežinoma';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Išvalys istoriją ir įdės 3 produktus';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Pasirinktinis naujienų URL';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'JSON failo URL:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Nenustatytas';

  @override
  String get dev_preferences_news_provider_status_title => 'Būsena';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Paskutinis atnaujinimas: $date';
  }

  @override
  String get product_type_label_food => 'Maistas';

  @override
  String get product_type_label_beauty => 'Asmens higiena';

  @override
  String get product_type_label_pet_food => 'Naminių gyvūnėlių ėdalas';

  @override
  String get product_type_label_product => 'Kita';

  @override
  String get product_type_selection_title => 'Produkto tipas';

  @override
  String get product_type_selection_subtitle => 'Pasirinkite šio produkto tipą';

  @override
  String get product_type_selection_empty =>
      'Pirmiausia turite pasirinkti produkto tipą!';

  @override
  String product_type_selection_already(String productType) {
    return 'Negalite keisti produkto tipo ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Nuoroda į Kainų programėlę produkto puslapyje';

  @override
  String get prices_app_button => 'Eiti į Kainų programėlę';

  @override
  String get prices_website_button => 'Atidaryti svetainėje „Open Prices“';

  @override
  String get prices_bulk_proof_upload_select =>
      'Pridėti kainų etiketes tiesiai iš galerijos';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Pasirinkus vaizdus, jų redaguoti nebegalėsite!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Leisti bendruomenei patvirtinti dirbtinio intelekto gautas kainas.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Kelios kainų etiketės';

  @override
  String get prices_bulk_proof_upload_title => 'Masinis įrodymų įkėlimas';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Failų pasirinkimas';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Pradedamas įkėlimas';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Vietinis failo kopijavimas #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Ruošiamas įkėlimas #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Nepavyko pasiekti paveikslėlio #$index/$count';
  }

  @override
  String get prices_generic_title => 'Kainos';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pridėti $count kainas',
      one: 'Pridėti kainą',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Atsiųskite $count kainas',
      one: 'Atsiųskite kainą',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Pridėti elementą';

  @override
  String get prices_add_a_price => 'Pridėti kainą';

  @override
  String get prices_add_a_receipt => 'Pridėti kvitą';

  @override
  String get prices_add_price_tags => 'Pridėti kainų etiketes';

  @override
  String prices_barcode_already(String barcode) {
    return 'Šis brūkšninis kodas ($barcode) jau yra sąraše!';
  }

  @override
  String get prices_barcode_search_not_found => 'Prekė nerasta';

  @override
  String get prices_barcode_search_none_yet => 'Dar nėra produktų';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Ieškoma $barcode';
  }

  @override
  String get prices_barcode_enter => 'Įvesti brūkšninį kodą';

  @override
  String get prices_category_enter => 'Prekė be brūkšninio kodo';

  @override
  String get prices_per_kilogram => 'Kaina už kilogramą';

  @override
  String get prices_per_unit => 'Kaina už vienetą';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / vnt.';

  @override
  String get prices_category_mandatory => 'Privaloma';

  @override
  String get prices_category_optional => 'Pasirinktinai';

  @override
  String get prices_category_error_mandatory => 'Kategorija yra privaloma';

  @override
  String get prices_barcode_reader_action => 'Brūkšninių kodų skaitytuvas';

  @override
  String get prices_view_prices => 'Peržiūrėti kainas';

  @override
  String get prices_list_title => 'Kainoraštis';

  @override
  String get prices_list_count => '\nkainų skaičius';

  @override
  String get prices_list_add_new_price => 'Pridėti\nnaują kainą';

  @override
  String get prices_list_empty_title => 'Kainos dar nėra!';

  @override
  String get prices_list_empty_subtitle =>
      'Būkite pirmas, kuris pridės:\nNuskaitydami **kvitą** arba **kainos etiketę**!';

  @override
  String get prices_entry_shop_not_found => 'Nežinoma parduotuvė';

  @override
  String prices_entry_menu_title(String user) {
    return 'Kainos įvedimas iš „$user“';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Peržiūrėti visas šio produkto kainas';

  @override
  String get prices_entry_menu_open_proof => 'Peržiūrėti įrodymą';

  @override
  String get prices_entry_menu_my_prices => 'Peržiūrėti kitas mano kainas';

  @override
  String get prices_entry_menu_author_prices =>
      'Peržiūrėti kitas autoriaus kainas';

  @override
  String get prices_entry_menu_shop_prices =>
      'Peržiūrėti kitas kainas iš parduotuvės';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kainos',
      one: '1 kaina',
    );
    return '$_temp0 už $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Visos $count kainos',
      one: 'Tik viena kaina',
      zero: 'Kainos dar nėra',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Naujausios $pageSize kainos (iš viso: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Kaina: $price / parduotuvė: \"$location\" / Paskėlbė $date \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Atverti \"$user\" įrodymus';
  }

  @override
  String get prices_open_proof => 'Atverti kainos įrodymą';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Visi $count įrodymai',
      one: 'Tik vienas įrodymas',
      zero: 'Įrodymų dar nėra',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Naujausi $pageSize įrodymai (iš viso: $total)';
  }

  @override
  String get prices_users_empty_title => 'Kol kas nėra bendraautorių!';

  @override
  String get prices_users_empty_explanation => 'Būkite pirmas, pridėjęs kainą!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Didžiausi $pageSize bendraautoriai (iš viso: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Parduotuvės dar nėra!';

  @override
  String get prices_locations_empty_explanation =>
      'Būkite pirmas, pridėjęs kainą!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Geriausios $pageSize vietos (iš viso: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count įrodumai',
      one: 'One proof',
      zero: 'No proof',
      many: '$count įrodymų',
      few: '$count įrodymai',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produktai',
      one: 'Vienas produktas',
      zero: 'Nėra produktų',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count vartotojai',
      one: 'Vienas vartotojas',
      zero: 'Nėra vartotojų',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kainos',
      one: 'Viena kaina',
      zero: 'Nėra kainų',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Anksčiau pridėta kaina';

  @override
  String get prices_amount_subtitle => 'Suma';

  @override
  String get prices_amount_is_discounted => 'Ar taikoma nuolaida?';

  @override
  String get prices_amount_price_normal => 'Kaina';

  @override
  String get prices_amount_price_discounted => 'Sumažinta kaina';

  @override
  String get prices_amount_price_not_discounted => 'Pradinė kaina';

  @override
  String get prices_amount_no_product => 'Trūksta vieno produkto!';

  @override
  String get prices_amount_price_incorrect => 'Neteisinga vertė';

  @override
  String get prices_amount_price_mandatory => 'Privaloma reikšmė';

  @override
  String get prices_currency_subtitle => 'Valiuta';

  @override
  String get prices_date_subtitle => 'Data';

  @override
  String get prices_location_subtitle => 'Parduotuvė';

  @override
  String get prices_location_find => 'Rasti parduotuvę';

  @override
  String get prices_location_mandatory => 'Reikia išsirinkti parduotuvę!';

  @override
  String get prices_location_search_broader =>
      'Neradote to, ko ieškojote? Išbandykime platesnę paiešką!';

  @override
  String get prices_proof_subtitle => 'Įrodymai';

  @override
  String get prices_proof_empty_title => 'Dar nėra įrodymų!';

  @override
  String get prices_proof_empty_explanation =>
      'Pradėkite pridėdami **kvito** arba **kainos etiketės** nuotrauką!';

  @override
  String get prices_proof_find => 'Pasirinkite įrodymą';

  @override
  String get prices_proof_change => 'Pakeisti įrodymą';

  @override
  String get prices_proof_receipt => 'Čekis';

  @override
  String get prices_proof_price_tag => 'Kainos etiketė';

  @override
  String get prices_proof_mandatory => 'Reikia pasirinkti įrodymą!';

  @override
  String get prices_add_validation_error => 'Patvirtinimo klaida';

  @override
  String get prices_privacy_warning_title => 'Privatumo įspėjimas';

  @override
  String get prices_unknown_product => 'Nežinomas produktas';

  @override
  String get prices_privacy_warning_main_message =>
      'Kainos **bus viešos** kartu su parduotuve, su kuria jos susijusios.\n\nTai gali leisti žmonėms, žinantiems jūsų „Open Food Facts“ pseudonimą:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Nurodykite, kurioje teritorijoje gyvenate';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Žinokite, ką perkate';

  @override
  String get prices_privacy_warning_sub_message =>
      'Jei jums tai kelia abejonių, pakeiskite savo pseudonimą arba susikurkite naują „Open Food Facts“ paskyrą ir prisijunkite prie programėlės.';

  @override
  String get i_refuse => 'Aš atsisakau';

  @override
  String get i_accept => 'Aš sutinku';

  @override
  String get prices_currency_change_proposal_title => 'Keisti valiutą?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Jūsų dabartinė valiuta yra **$currency**. Ar norėtumėte ją pakeisti į **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Taip, naudoti $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Ne, palikti $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Atlikta';

  @override
  String get dev_mode_section_server => 'Serverio konfigūracija';

  @override
  String get dev_mode_section_news => 'Naujienų teikėjo konfigūravimas';

  @override
  String get dev_mode_section_product_page => 'Produkto puslapis';

  @override
  String get dev_mode_section_ui => 'Vartotojo sąsaja';

  @override
  String get dev_mode_section_experimental_features =>
      'Eksperimentinės funkcijos';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Neįtraukti „Green Score“';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Naudokite rašybos tikrintuvą OCR ekranuose';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Sudedamosios dalys ir pakuotė)';

  @override
  String get dev_mode_reset_app_language_title =>
      'Nustatyti programėlės kalbą iš naujo';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Pridėti kortelių';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Perjungti tarp prices.openfoodfacts.org (PROD) ir bandomosios aplinkos';

  @override
  String get search_history_item_edit_tooltip =>
      'Naudoti pakartotinai ir redaguoti šią paiešką';

  @override
  String get search_history_item_remove_tooltip => 'Pašalinti';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Atsisiuntėte visus $totalSize produktų.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Atsisiųskite dar $count produktų\nJau atsisiųsta $downloaded iš $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Vykdoma jūsų paieška - $search.\n\nŠiek tiek luktelėkite…';
  }

  @override
  String get user_search_contributor_title => 'Produktai, kuriuos pridėjau';

  @override
  String get user_search_informer_title => 'Produktai, kuriuos redagavau';

  @override
  String get user_search_photographer_title =>
      'Produktai, kuriuos fotografavau';

  @override
  String get user_search_to_be_completed_title => 'Mano baigtini produktai';

  @override
  String get user_search_prices_title => 'Mano kainos';

  @override
  String get user_search_proofs_title => 'Mano įrodymai';

  @override
  String get user_search_proof_title => 'Mano įrodymas';

  @override
  String search_proof_title(String user) {
    return 'Įrodymas iš „$user“';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Bendradarbių kainos: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Naujausios kainos pridėtos';

  @override
  String get all_search_prices_top_user_title => 'Didžiausi kainų veiksniai';

  @override
  String get all_search_prices_top_location_title =>
      'Parduotuvės su didžiausiomis kainomis';

  @override
  String get prices_contribution_assistant => 'Kainų pridėjimo asistenatas';

  @override
  String get prices_validation_assistant => 'Kainų tvirtinimo asistentas';

  @override
  String get prices_challenges_page => 'Iššūkiai';

  @override
  String get prices_multiple_proof_addition_system => 'Pridėti kelis įrodymus';

  @override
  String get all_search_prices_top_location_single_title =>
      'Kainos parduotuvėje';

  @override
  String get all_search_prices_top_product_title =>
      'Produktai su didžiausiomis kainomis';

  @override
  String get all_search_to_be_completed_title => 'Visi baigtini gaminiai';

  @override
  String get categorize_products_country_title =>
      'Padėkite suskirstyti produktus į kategorijas savo šalyje';

  @override
  String get edit_product_action_retake_picture => 'Perdaryti nuotrauką';

  @override
  String get edit_product_action_take_picture => 'Nufotografuokite';

  @override
  String get edit_product_action_confirm => 'Patvirtinti';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Sutinku su atvirų maisto faktų svetaine ';

  @override
  String get signup_page_terms_of_use_line2 => 'naudojimo ir įnašo sąlygomis';

  @override
  String get analytics_consent_image_semantic_label => 'Analizės piktograma';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Lemtinga klaida: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Lemtinga klaida: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Užpildyti pagrindinę informaciją';

  @override
  String get edit_photo_button_label => 'Redaguoti';

  @override
  String get edit_photo_unselect_button_label => 'Atžymėti nuotrauką';

  @override
  String get edit_photo_select_existing_button_label =>
      'Pasirinkti egzistuojantį vaizdą';

  @override
  String get edit_photo_select_existing_all_label => 'Esami vaizdai';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Pasirinkite paveikslėlį spustelėdami jį';

  @override
  String get edit_photo_select_existing_download_label =>
      'Gaunami esami vaizdai…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Nėraanksčiau įkeltų vaizdų, susijusių su šiuo produktu.';

  @override
  String get edit_photo_language_not_this_one => 'Dar nėra vaizdo ta kalba';

  @override
  String get edit_photo_language_none => 'Vaizdo dar nėra';

  @override
  String get category_picker_screen_title => 'Kategorijos';

  @override
  String get basic_details => 'Pagrindinės detalės';

  @override
  String get product_name => 'Produkto pavadinimas';

  @override
  String get product_names => 'Produktų pavadinimai';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Pridėti naują vertimą';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Prieš patvirtindami užtikrinkite, kad pridedate tik vertimą **jei kalbos nėra ant pakuotės**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Žiūrėti priekio nuotrauką';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Nufotografuoti priekį';

  @override
  String get add_basic_details_product_name_hint =>
      'Įvestiprodukto pavadinimą (pvz., Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Pakeisti numatytąją kalbą?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Ar norite, kad numatytoji produkto kalba būtų nustatyta į „$language“?';
  }

  @override
  String get explanation_section_good_examples => 'Geri pavyzdžiai';

  @override
  String get explanation_section_bad_examples => 'Blogi pavyzdžiai';

  @override
  String get add_basic_details_product_name_help_title =>
      'Geroji praktika: produkto pavadinimas';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Produkto pavadinimas yra **pagrindinis pavadinimas, išspausdintas ant pakuotės**. Tai gali būti registruotas prekės ženklas.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Pastaba:** Nepridėkite vertimo ,**jei kalbos nėra ant pakuotės**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Pomidorų kečupas';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Neįtraukite prekės ženklo į pavadinimą';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Pomidorų kečupas ** Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Nenaudokite simbolių ®, ™, © ar panašių';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kiti vertimai',
      many: '$count kitų vertimų',
      few: '$count kiti vertimai',
      one: '$count kitas vertimas',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Prekinio ženklo pavadinimas';

  @override
  String get brand_names => 'Prekių ženklų pavadinimai';

  @override
  String get add_basic_details_brand_name_error =>
      'Įveskite prekės ženklo pavadinimą';

  @override
  String get add_basic_details_brand_names_hint =>
      'Įvesti prekių ženklus (pvz., „Ferrero“)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Geroji praktika: Prekių ženklai';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Įveskite **visus produkto prekės ženklus**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Pagrindinis prekės ženklas';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Pagrindinis prekės ženklas**, paprastai aiškiai nurodytas priekinėje pakuotės pusėje, turėtų būti **įvestas pirmiausia**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Kiti prekių ženklai';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Kai parduoda **didelė įmonė**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**„Actimel“** parduoda **„Danone**“';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Kai parduodama su prekės ženklu **išverstas į kelias kalbas**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Gamtos slėnis** kartais rašoma **Val Gamta**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Kiekis ir svoris';

  @override
  String get add_basic_details_quantity_hint =>
      'Įvesti svorį ir, jei reikia, kiekį (pvz., 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Geroji praktika: Kiekis';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Nukopijuokite ant gaminio nurodytą vertę ir **nepamirškite matavimo vienetų**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** arba **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (6 kiaušiniams)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(produktui, kurį sudaro 3 dėžutės po 150 g)';

  @override
  String get barcode => 'Barkodas';

  @override
  String barcode_barcode(String barcode) {
    return 'Brūkšninis kodas: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Netinkamas brūkšninis kodas';

  @override
  String get basic_details_add_success =>
      'Pagrindinė informacija pridėta sėkmingai';

  @override
  String get basic_details_add_error =>
      'Nepavyko pridėti pagrindinės informacijos. Po kurio laiko bandykite dar kartą';

  @override
  String get clear_search => 'Išvalyti savo paiešką';

  @override
  String get confirm_clear =>
      'Ketinate išvalyti visą istoriją: ar tikrai norite tęsti?';

  @override
  String get alert_clear_selected_user_list =>
      'Ketinate išvalyti pasirinktus elementus savo istorijoje';

  @override
  String get confirm_clear_selected_user_list => 'Ar tikrai norite tęsti?';

  @override
  String get alert_select_items_to_clear =>
      'Pasirinkite vieną ar kelis elementus išvalyti';

  @override
  String confirm_clear_user_list(String name) {
    return 'Ketinate išvalyti šį sąrašą ($name): ar tikrai norite tęsti?';
  }

  @override
  String get confirm_delete_user_list_title => 'Ištrinti sąrašą?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Jūs ketinate ištrinti sąrašą „$name“.\nAr tikrai norite tęsti?';
  }

  @override
  String get confirm_delete_user_list_button => 'Taip, patvirtinu';

  @override
  String importance_label(String name, String id) {
    return '$name svarba: $id';
  }

  @override
  String get user_list_all_title => 'Sąrašai';

  @override
  String get user_list_all_empty => 'Sukurkite savo pirmąjį sąrašą';

  @override
  String get product_list_select => 'Pasirinkti sąrašą';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produktų',
      one: 'Vienas produktas',
      zero: 'Tusčias sąrašas',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Pridėti sąrašą';

  @override
  String get open_food_preferences_tooltip =>
      'Redaguokite savo maisto pageidavimus';

  @override
  String get add_photo_button_label => 'Įtraukite nuotrauką';

  @override
  String get add_packaging_photo_button_label =>
      'Nufotografuokite bet kokią pakuotės / perdirbimo informaciją';

  @override
  String get add_origin_photo_button_label =>
      'Nufotografuokite bet kokią kilmės informaciją';

  @override
  String get add_emb_photo_button_label =>
      'Nufotografuokite bet kokią atsekamumo kodo informaciją';

  @override
  String get add_label_photo_button_label =>
      'Nufotografuokite visas etiketes ir sertifikavimo informaciją';

  @override
  String get choose_image_source_title => 'Pasirinkite vaizdo šaltinį';

  @override
  String get choose_image_source_body => 'Prašomė pasirinkti vaizdo šaltinį';

  @override
  String get gallery_source_label => 'Galerija';

  @override
  String get gallery_source_access_denied_dialog_title => 'Prieiga uždrausta';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Deja, programa negali pasiekti jūsų galerijos, nes anksčiau atsisakėte leidimo.\n\nEikite į programos nustatymus savo telefone, Nustatymai -> Nuotraukos';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Atidarykite nustatymus';

  @override
  String get share => 'Dalintis';

  @override
  String share_product_text(String url) {
    return 'Peržiūrėkite šį produktą „Open Food Facts“ svetainėje: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Peržiūrėkite šį produktą „Open Beauty Facts“: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Peržiūrėkite šį produktą „Open PetFood Facts“: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Peržiūrėkite šį produktą „Open Products Facts“: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Peržiūrėkite mano produktų sąrašą „Open Food Facts“ svetainėje: $url';
  }

  @override
  String get capture => 'Nufotografuoti naują nuotrauką';

  @override
  String get capture_new_picture => 'Fotografuoti';

  @override
  String get choose_from_gallery => 'Pasirinkti iš galerijos';

  @override
  String get image_upload_queued =>
      'Produktas bus kuo greičiau atnaujintas fone.';

  @override
  String get add_price_queued =>
      'Kaina bus išsiųsta į serverį kaip įmanoma greičiau.';

  @override
  String get background_task_title_full_refresh =>
      'Pradedamas visų vietoje saugomų produktų atnaujinimas';

  @override
  String get background_task_title_folksonomy =>
      'Pradedami vykdyti serverio veiksmai su lokaliai saugomais „folksonomy“ atnaujinimais';

  @override
  String get background_task_title_top_n =>
      'Pradedamas populiariausių produktų atsisiuntimas';

  @override
  String get expand_nutrition_facts => 'Išplėskite mitybos faktų lentelę';

  @override
  String get expand_nutrition_facts_body =>
      'Laikyti išplėstą mitybos faktų lentelę';

  @override
  String get expand_ingredients => 'Išplėskite ingredientų lentelę';

  @override
  String get expand_ingredients_body =>
      'Laikyti sudedamųjų dalių skydelį išplėstą';

  @override
  String get no_internet_connection => 'Nėra interneto ryšio';

  @override
  String get world_results_label => 'Visas pasaulis';

  @override
  String get world_results_action => 'Išplėskite savo paiešką visame pasaulyje';

  @override
  String get copy_to_clipboard => 'Kopijuoti';

  @override
  String get paste_from_clipboard => 'Įklijuoti iš iškarpinės';

  @override
  String get no_data_available_in_clipboard => 'Jūsų iškarpinėje duomenų nėra';

  @override
  String get clipboard_barcode_copy => 'Nukopijuoti brūkšninį kodą';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Brūkšninis kodas $barcode nukopijuotas!';
  }

  @override
  String get open_product_website => 'Atverti šį produktą tinklalapyje';

  @override
  String get language_picker_label => 'Jūsų kalba';

  @override
  String get country_picker_label => 'Jūsų šalis';

  @override
  String get currency_picker_label => 'Jūsų valiuta';

  @override
  String get help_with_openfoodfacts => 'Pagalba su OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produktas bus kuo greičiau atnaujintas fone.';

  @override
  String get no_email_client_available_dialog_title =>
      'El. laiškų programėlių nėra!';

  @override
  String get no_email_client_available_dialog_content =>
      'Prašome rankiniu būdu atsiųsti mums el. laišką adresu mobile@openfoodfacts.org';

  @override
  String get all_images => 'Visos nuotraukos';

  @override
  String get selected_images => 'Pasirinktos nuotraukos';

  @override
  String get product_card_remove_product_tooltip => 'Pašalinti produktą';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nuskaitytas naujas brūkšninis kodas: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Pašalinti visus produktus iš karuselės';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Nuskaitykite bent du produktus, kad juos palygintumėte';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Palyginkite produktus, kuriuos nuskaitėte';

  @override
  String get scan_product_loading => 'Jūs nuskaitėte\nbrūkšninį kodą:';

  @override
  String get scan_product_loading_initial =>
      'Mes ieškome šio produkto!\nLuktelėkite kelias sekundes…';

  @override
  String get scan_product_loading_long_request =>
      'Mes vis dar ieškome šio produkto!\nAr manote, kad parsisiuntimas trunka ilgai? Taigi, ir mes…';

  @override
  String get scan_product_loading_unresponsive =>
      'Mes vis dar ieškome šio produkto.\nAr norėtumėte iš naujo paleisti paiešką?';

  @override
  String get scan_product_loading_restart_button => 'Paleisti paiešką iš naujo';

  @override
  String get portion_calculator_description =>
      'Apskaičiuokite konkretaus kiekio mitybos faktus';

  @override
  String get portion_calculator_hint => 'Kiekis';

  @override
  String get portion_calculator_accessibility =>
      'Įveskite kiekį, kad apskaičiuotumėte maistinę sudėtį';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Įveskite reikšmę nuo $min iki $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Trūksta duomenų. Nebuvo galima apskaičiuoti.';

  @override
  String portion_calculator_result_title(int grams) {
    return '$grams g (arba ml) maistingumas';
  }

  @override
  String get offline_data => 'Duomenys neprisijungus';

  @override
  String get ocr_image_upload_instruction =>
      'Įkelkite vaizdą, kad automatiškai išskleistumėte jame esančią informaciją.';

  @override
  String get upload_image => 'Įkelti nuotrauką';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Nepavyko atsisiųsti vaizdo';

  @override
  String get image_edit_url_error =>
      'Nepavyko redaguoti vaizdo, nes nebuvo nustatytas URL.';

  @override
  String get user_picture_source_remember => 'Prisiminti mano pasirinkimą';

  @override
  String get user_picture_source_ask => 'Klausti kiekvieną kartą';

  @override
  String get robotoff_continue => 'Tęsti';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count klausimai',
      one: 'klausimas',
    );
    return 'Kitas $_temp0';
  }

  @override
  String get show_password => 'Rodyti Slaptažodį';

  @override
  String get owner_field_info_title => 'Gamintojas pateikė vertes';

  @override
  String get owner_field_info_message =>
      'Šiuo logotipu paryškiname gamintojo pateiktus duomenis, kurie gali būti neredaguotini.';

  @override
  String get owner_field_info_close_button => 'Uždaryti šią informaciją';

  @override
  String get owner_field_image =>
      'Šį vaizdą pateikė gamintojas. Jis gali būti neredaguotinas.';

  @override
  String get edit_packagings_title => 'Pakuotės komponentai';

  @override
  String get edit_packagings_element_add => 'Pridėti pakuotės komponentą';

  @override
  String get edit_packagings_completed => 'Pakuota yra užbaigta';

  @override
  String edit_packagings_element_title(int index) {
    return 'Pakuotės komponentas #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Vienetų skaičius';

  @override
  String get edit_packagings_element_hint_units =>
      'Įveskite tokios pačios formos ir medžiagos, esančios produkto sudėtyje, pakuočių vienetų skaičių.';

  @override
  String get edit_packagings_element_field_shape => 'Forma';

  @override
  String get edit_packagings_element_hint_shape =>
      'Įveskite formos pavadinimą, įtrauktą į perdirbimo instrukcijų, jei tokios yra, sąrašą, arba pasirinkite formą.';

  @override
  String get edit_packagings_element_example_shape => 'Butelis';

  @override
  String get edit_packagings_element_field_material => 'Medžiaga';

  @override
  String get edit_packagings_element_hint_material =>
      'Įveskite konkrečią medžiagą, jei ją galima nustatyti (medžiagos kodą trikampyje dažnai galima rasti ant pakuotės dalių), arba bendrąją medžiagą (pvz., plastikas arba metalas), jei nesate tikri.';

  @override
  String get edit_packagings_element_example_material => 'Stiklas';

  @override
  String get edit_packagings_element_field_recycling =>
      'Perdirbimo instrukcija';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Įveskite perdirbimo instrukcijas tik, jei jos yra nurodytas ant produkto.';

  @override
  String get edit_packagings_element_example_recycling => 'Perdirbimas';

  @override
  String get edit_packagings_element_field_quantity =>
      'Grynasis vieno produkto vieneto kiekis';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Įveskite grynąjį svorį arba grynąjį tūrį ir nurodykite vienetą (pvz., g arba ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Vieno tuščio vieneto svoris (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Prieš sverdami pašalinkite likusį maistą, išplaukite ir išdžiovinkite pakuotės dalį. Jei įmanoma, naudokite 0,1 g arba 0,01 g tikslumo svarstykles.';

  @override
  String get background_task_title => 'Laukiantys įnašai';

  @override
  String get background_task_subtitle =>
      'Jūsų įnašai automatiškai išsaugomi mūsų serveryje, bet ne visada realiuoju laiku.';

  @override
  String get background_task_list_empty => 'Nėra laukiančių foninių užduočių';

  @override
  String get background_task_error_server_time_out =>
      'Serverio skirtasis laikas';

  @override
  String get background_task_error_no_internet =>
      'Interneto ryšio klaida. Pabandyk vėliau.';

  @override
  String get background_task_operation_unknown => 'nežinomas operacijos tipas';

  @override
  String get background_task_operation_details => 'detalūs pakeitimai';

  @override
  String get background_task_operation_image => 'nuotraukos įkėlimas';

  @override
  String get background_task_operation_refresh =>
      'Atnaujinimas atidėtas po nuotraukos įkėlimo';

  @override
  String get background_task_run_started => 'pradėjo';

  @override
  String get background_task_run_not_started => 'dar nepradėta';

  @override
  String get background_task_run_to_be_deleted => 'bus ištrinti';

  @override
  String get background_task_question_stop =>
      'Ar nori sustabdyti šią užduotį kuo greičiau?';

  @override
  String get feed_back => 'Atsiliepimas';

  @override
  String get undo => 'Anuliuoti';

  @override
  String get copy_email_to_clip_board => 'Kopijuoti el. laišką į iškarpinę';

  @override
  String get please_send_us_an_email_to =>
      'Išsiųskite mums el. laišką rankiniu būdu į';

  @override
  String get email_copied_to_clip_board =>
      'El. laiškas nukopijuotas į iškarpinę!';

  @override
  String get select_accent_color => 'Pasirinkti akcento spalvą';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Mėlyna';

  @override
  String get color_cyan => 'Žydra';

  @override
  String get color_green => 'Žalia';

  @override
  String get color_light_brown => 'Numatytoji';

  @override
  String get color_magenta => 'Violetinė';

  @override
  String get color_orange => 'Oranžinė';

  @override
  String get color_pink => 'Rausva';

  @override
  String get color_red => 'Raudona';

  @override
  String get color_rust => 'Rūdis';

  @override
  String get color_teal => 'Smaragdinė';

  @override
  String get text_contrast_mode => 'Teksto kontrastas';

  @override
  String get contrast_high => 'Aukštas';

  @override
  String get contrast_medium => 'Vidutinis';

  @override
  String get contrast_low => 'Mažas';

  @override
  String get product_refresher_internet_not_found => 'Produktas nerastas!';

  @override
  String get product_refresher_internet_not_connected =>
      'Jūs nesate prisijungę prie interneto!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Serveris neveikia ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Serverio klaida ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produktas nerastas!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Produkto su šiuo brūkšniniu kodu mūsų duomenų bazėje nėra: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Nėra interneto ryšio!';

  @override
  String get product_loader_network_error_message =>
      'Pasitikrinkite, ar jūsų išmanusis telefonas yra prijungtas prie „WiFi“ tinklo arba įjungti mobilieji duomenys';

  @override
  String get page_not_found_title => 'Puslapis nerastas!';

  @override
  String get page_not_found_button => 'Grįžti į pagrindinį puslapį';

  @override
  String get download_data => 'Parsisiųsti duomenis';

  @override
  String get download_top_products =>
      'Atsisiųskite 1000 populiariausių produktų savo šalyje, kad galėtumėte greitai nuskaityti';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produktus',
    );
    return 'Atsisiųskite geriausius $_temp0 savo šalyje, kad galėtumėte juos akimirksniu nuskaityti.';
  }

  @override
  String get download_in_progress => 'Duomenų atsisiuntimas\nTai gali užtrukti';

  @override
  String downloaded_products(int num) {
    return 'Pridėta $num produktų';
  }

  @override
  String get update_offline_data =>
      'Atnaujinti produkto duomenis neprisijungus';

  @override
  String get update_local_database_sub =>
      'Atnaujinkite vietinę produktų duomenų bazę naujausiais „Open Food Facts“ duomenimis';

  @override
  String get clear_local_database =>
      'Pašalinti produkto duomenis neprisijungus';

  @override
  String get clear_local_database_sub =>
      'Išvalykite visus vietinio produkto duomenis iš programėlės, kad atlaisvintumėte vietos';

  @override
  String deleted_products(int num) {
    return 'Ištrinta $num produktų';
  }

  @override
  String get loading => 'Įkeliama…';

  @override
  String get know_more => 'Sužinoti daugiau';

  @override
  String get offline_data_desc =>
      'Spustelėkite, kad sužinotumėte daugiau apie duomenis neprisijungus';

  @override
  String get offline_product_data_title => 'Produkto duomenys neprisijungus';

  @override
  String available_for_download(int num) {
    return '$num produktų galima nuskaityti iškart';
  }

  @override
  String get country_selector_title => 'Pasirinkite savo šalį:';

  @override
  String get currency_selector_title => 'Pasirinkite valiutą:';

  @override
  String get language_selector_title => 'Pasirinkite savo kalbą:';

  @override
  String get language_selector_section_selected => 'Pasirinktos kalbos';

  @override
  String get language_selector_section_frequently_used => 'Dažnai naudojama';

  @override
  String get action_delete_list => 'Ištrinti';

  @override
  String get action_change_list => 'Pakeiskite dabartinį sąrašą';

  @override
  String get product_list_create => 'Kurti';

  @override
  String get product_list_create_tooltip => 'Sukurti naują sąrašą';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => '„Nutri-Score E“';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Naujas skaičiavimas)';
  }

  @override
  String get nutriscore_new_formula_title =>
      '„Nutri-Score“ (naujas skaičiavimas)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nežinomas „Nutri-Score“ (naujas skaičiavimas)';

  @override
  String get nutriscore_not_applicable => '„Nutri-Score“ netaikomas';

  @override
  String get nutriscore_not_applicable_new_formula =>
      '„Nutri-Score“ netaikomas (naujas skaičiavimas)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Žalias balas A';

  @override
  String get environmental_score_b_new => 'Žalias balas B';

  @override
  String get environmental_score_c_new => 'Žalias balas C';

  @override
  String get environmental_score_d_new => 'Žalias balas D';

  @override
  String get environmental_score_e_new => 'Žalias balas E';

  @override
  String get environmental_score_unknown_new => 'Nežinomas žaliasis balas';

  @override
  String get environmental_score_not_applicable_new =>
      'Žaliasis balas netaikomas';

  @override
  String get nova_group_generic_new =>
      'Ultraperdirbti maisto produktai – NOVA grupės';

  @override
  String get nova_group_1 => 'NOVA 1 grupė';

  @override
  String get nova_group_2 => 'NOVA 2 grupė';

  @override
  String get nova_group_3 => 'NOVA 3 grupė';

  @override
  String get nova_group_4 => 'NOVA 4 grupė';

  @override
  String get nova_group_unknown => 'Nežinoma NOVA grupė';

  @override
  String get nutrition_facts => 'Maistinių medžiagų lygiai';

  @override
  String get faq_title_partners => 'NVO partneriai ir globėjai';

  @override
  String get faq_title_vision =>
      '„Open Food Facts“ vizija, misija, vertybės ir programos';

  @override
  String get faq_title_install_beauty =>
      'Įdiekite „Open Beauty Facts“, kad sukurtumėte kosmetikos duomenų bazę';

  @override
  String get faq_title_install_pet =>
      'Įdiekite „Open Pet Food Facts“, kad sukurtumėte naminių gyvūnų pašarų duomenų bazę';

  @override
  String get faq_title_install_product =>
      'Įdiekite „Open Products Facts“, kad sukurtumėte produktų duomenų bazę ir pailgintumėte objektų eksploatavimo laiką';

  @override
  String get faq_nutriscore_nutriscore =>
      'Naujas „Nutri-Score“ skaičiavimas: kas naujo?';

  @override
  String get contact_title_pro_page =>
      '„Pro“? Importuokite savo produktus į „Open Food Facts“';

  @override
  String get contact_title_pro_email => 'Gamintojo kontaktai';

  @override
  String get contact_title_press_page => 'Spaudos puslapis';

  @override
  String get contact_title_press_email => 'Kontaktai spaudai';

  @override
  String get contact_title_newsletter => 'Prenumeruokite mūsų naujienlaiškį';

  @override
  String get contact_title_calendar =>
      'Prenumeruokite mūsų bendruomenės kalendorių';

  @override
  String get hunger_games_loading_line1 => 'Duokite mums kelias sekundes…';

  @override
  String get hunger_games_loading_line2 => 'Mes atsisiunčiame klausimus!';

  @override
  String get hunger_games_error_label =>
      'Po galais! Kažkas atsitiko… ir mums nepavyko įkelti klausimų.';

  @override
  String get hunger_games_error_retry_button => 'Pabandykime dar kartą!';

  @override
  String get reorder_attribute_action => 'Pertvarkyti atributus';

  @override
  String get link_cant_be_opened =>
      'Šios nuorodos negalima atidaryti jūsų įrenginyje. Patikrinkite, ar įdiegta naršyklė.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Išsami informacija apie $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Išsami informacija apie $pageName su $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Dalintis';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Kas yra „Nutri-Score“?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Kur rasti naują „Nutri-Score“ skaičiavimo sistemą?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      '„Nutri-Score“ taikoma 7 šalyse: Prancūzijoje, Vokietijoje, Belgijoje, Ispanijoje, Liuksemburge, Nyderlanduose ir Šveicarijoje.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Gamintojai turi ne vėliau kaip **2 metus** nuo dekreto pasirašymo **pakeisti** senąjį skaičiavimą nauju.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Kas yra žaliasis balas?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      '„Green-Score“ – tai logotipas, kuriuo siekiama informuoti jus apie **maisto poveikį aplinkai**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Spalvos kodas svyruoja nuo tamsiai žalios (**A+**), skirtos **mažiausiai poveikį darantiems** produktams, iki tamsiai raudonos (**F**), skirtos **didžiausią poveikį darantiems** produktams.';

  @override
  String get guide_greenscore_logos_caption => '„Green-Score“ logotipai';

  @override
  String get guide_greenscore_lca_title =>
      'Esmė: gyvavimo ciklo vertinimas (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Mokslinis maisto kategorijų vertinimas';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Kiekvienai produktų kategorijai nustatomas **lyginamasis** balas, naudojant „Agribalyse“ aplinkosaugos duomenų bazės (sukurtos ADEME ir INRAE) duomenis.';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Gyvavimo ciklo analizė** yra standartizuotas vertinimo metodas, skirtas atlikti daugiapakopį ir daugiakriterį poveikio aplinkai vertinimą.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Išmatavimai:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 gamybos etapai';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Žemdirbystė';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Apdorojama';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Pakuotė';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportas';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Skirstyti';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Vartojimas';

  @override
  String get guide_greenscore_lca_arg3_title => '14 poveikio aplinkai rodiklių';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Klimato kaita / anglies pėdsakas';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Ozono sluoksnio nykimas';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Jonizuojančioji spinduliuotė';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Žemė';

  @override
  String get guide_greenscore_lca_arg3_text5 =>
      'Vandens ir energijos naudojimas';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Oro tarša';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Jūros ir gėlo vandens (dalelės, rūgštėjimas, eutrofikacija)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Išteklių išeikvojimas.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Premijos ir baudos';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Norėdami apdovanoti geresnius produktus tam tikroje kategorijoje, taikome **premijas ir nuobaudas pagal kelis kriterijus**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Premija** skiriama produktams, turintiems **oficialų ženklą, etiketę ar sertifikatą, garantuojantį naudą aplinkai** (ekologiškas, sąžiningos prekybos, HVE, „Label Rouge“, „Bleu Blanc Cœur“, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Sudedamųjų dalių kilmė';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'Premija skiriama atsižvelgiant į ingredientų kilmę. Ši premija skaičiuojama atsižvelgiant į **poveikį transportui** ir kiekvieno gamintojo šalies **aplinkos politiką**.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Bauda** skiriama produktams, kurių sudėtyje yra ingredientų, darančių didelį **neigiamą poveikį biologinei įvairovei ir ekosistemoms**, pavyzdžiui, palmių aliejaus, kurio gamyba lemia didžiulį miškų naikinimą.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Pakuotė';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Bauda** apskaičiuojama atsižvelgiant į **pakuotės žiediškumą** (perdirbtų žaliavų naudojimą ir perdirbimo galimybes) ir perteklinį pakuotę.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Norint tiksliai apskaičiuoti „Green-Score“, būtina turėti **informaciją, kuri nebūtinai nurodyta ant pakuotės** (pvz., kiekvieno ingrediento kilmę ir tikslų procentą) arba kuri retai prieinama naudotina forma (pvz., visų pakuotės komponentų sąrašą su tiksliais panaudotų plastikų tipais).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Vidutinės vertės naudojamos, kai ši informacija dar nėra prieinama**, tačiau dabar raginame visus padėti mums rinkti šią informaciją, kuri bus labai naudinga tiek „Green-Score“, tiek ir daugeliui kitų tikslų.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Kaip piliečiai gali padėti?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Visi piliečiai gali padėti mums rinkti ir susisteminti informaciją, esančią ant produktų arba kurią galima iš jų išvesti, pavyzdžiui, informaciją apie **pakuotes**: „Mission Emballages“: didelio masto bendradarbiaujant atliekamas visų maisto produktų pakuočių inventorius (prancūzų k.).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Kaip gamintojai gali padėti';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Gamintojai gali siųsti mums savo informaciją tiesiogiai per mūsų nemokamą platformą gamintojams.';

  @override
  String get guide_greenscore_better_product_title =>
      'Kuris produktas geresnis planetai?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Gali būti sunku pasakyti';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Tvaraus maisto pasirinkimas yra vienas iš svarbiausių dalykų, kuriuos galime padaryti dėl klimato, nes **mūsų pasaulinė maisto sistema yra atsakinga už daugiau nei ketvirtadalį visų šiltnamio efektą sukeliančių dujų emisijų**.\n(Šaltinis: Poore ir Nemecek, „Science“, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Tu turi galią!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Geros žinios yra tai, kad tai suteikia mums galingą būdą kurti pokyčius.\n**Kiekvienas iš mūsų kasmet suvalgome apie 1000 patiekalų**. Tai 1000 galimybių **pasirinkti geresnę planetos ateitį**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Padeda būti atsakingam ir priimti sprendimus';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Tvaraus maisto pasirinkimas gali atrodyti sudėtingas. Etiketės gali būti painios, o informacijos dažnai trūksta. „Green-Score“ buvo sukurtas tam, kad viskas būtų paprasta ir suteiktų jums **aiškų**, **mokslu pagrįstą** ir **skaidrų** maisto produktų aplinkosauginį įvertinimą būtent ten, kur jums jo reikia: apsiperkant.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Skaidrumas';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Kitaip nei patentuotų etikečių atveju, „Green-Score“ skaičiavimas yra **visiškai atviras** ir jį gali **patvirtinti bet kas**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'Kas yra ultraprocessing?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA grupės informuoja jus apie maisto perdirbimo lygį.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA klasifikacija leidžia suskirstyti maisto produktus į **4 grupes** pagal jų **pramoninio apdorojimo laipsnį** (minimaliai perdirbti arba neperdirbti maisto produktai, kulinariniai ingredientai, perdirbti maisto produktai, ultraperdirbti maisto produktai).';

  @override
  String get guide_nova_logos_caption => 'NOVA logotipai';

  @override
  String get guide_nova_groups_title => '4 NOVA grupės';

  @override
  String get guide_nova_groups_intro =>
      'Yra 4 NOVA grupės, problemiškiausia yra 4 grupė – itin perdirbti maisto produktai.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimaliai perdirbti arba neperdirbti maisto produktai';

  @override
  String get guide_nova_groups_arg1_text =>
      'Neperdirbtas (arba natūralus) maistas yra **valgomos augalų** (sėklos, vaisiai, lapai, stiebai, šaknys) **arba gyvūnų** (raumenys, subproduktai, kiaušiniai, pienas), taip pat grybų, dumblių ir vandens dalys, atskirtos nuo gamtos.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'Perdirbti kulinariniai ingredientai, tokie kaip **aliejai, sviestas, cukrus ir druska**, yra medžiagos, gautos iš 1 grupės maisto produktų arba iš gamtos taikant tokius procesus kaip spaudimas, rafinavimas, malimas, malimas ir džiovinimas.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 To group 1** foods. processes include various preservation or cooking methods, and in the Case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable As modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually Include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products Also contain other sources of energy and nutrients not typically used in culinary preparations. some of These are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Ultraprocesoriaus problemos';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Ekstremalus maisto ingredientų apdorojimas';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Daugelis jų yra **gaunami toliau perdirbant maisto sudedamąsias dalis**, pavyzdžiui, hidrinti arba interesterifikuoti aliejai, hidrolizuoti baltymai, sojų baltymų izoliatas, maltodekstrinas, invertuotas cukrus ir didelės fruktozės kukurūzų sirupas.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Priedai, kurie neapsiriboja vien tik maisto sauga';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Ultraperdirbtuose maisto produktuose esantys priedai apima ir tuos, kurie taip pat naudojami perdirbtuose maisto produktuose, pavyzdžiui, konservantus, antioksidantus ir stabilizatorius. Priedų, randamų tik ultraperdirbtuose produktuose, klasės apima tuos, kurie naudojami **maisto produktų juslinėms savybėms imituoti arba sustiprinti arba galutinio produkto nemaloniems aspektams paslėpti**. Šie priedai apima dažiklius ir kitus dažiklius, spalvų stabilizatorius; kvapiąsias medžiagas, skonio stipriklius, necukrinius saldiklius; ir pagalbines perdirbimo medžiagas, tokias kaip gazavimo, standinimo, užpildai ir tūrį mažinančios medžiagos, putojimo mažinimo, lipnumą reguliuojančios ir glazūravimo medžiagos, emulsikliai, kompleksonai ir drėgmę išlaikančios medžiagos.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Apdorojimas, kurio negalite atlikti namuose';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Naudojama daugybė procesų sekų**, siekiant sujungti įprastai daug ingredientų ir sukurti galutinį produktą (todėl jis vadinamas „ultra apdorotu“). Šie procesai apima kelis **neturinčius atitikmenų namuose**, pavyzdžiui, hidrinimą ir hidrolizę, ekstruziją ir liejimą, bei paruošiamąjį apdorojimą kepimui.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Plėšrieji ir finansiniai itin didelio apdorojimo aspektai';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Bendras ultraperdirbimo tikslas – kurti firminius, **patogius** (patvarius, paruoštus vartoti), **patrauklius** (itin skanius) ir **labai pelningus** (su pigiais ingredientais) maisto produktus, skirtus išstumti visas kitas maisto grupes. Ultraperdirbti maisto produktai paprastai yra patraukliai supakuoti ir intensyviai parduodami.';

  @override
  String get guide_nova_explanations_arg5_title => 'Pavojus sveikatai';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Nuo 2018 m., pasitelkus „NutriNet-Santé“, buvo pirmą kartą išryškinti ryšiai tarp **ultraperdirbtų maisto produktų vartojimo ir padidėjusios vėžio, širdies ir kraujagyslių ligų bei diabeto rizikos**. Šiandien šiuos rezultatus patvirtina daugiau nei 90 tyrimų visame pasaulyje.\nStipriausi ryšiai yra susiję su **nutukimu, mirtingumu nuo širdies ir kraujagyslių ligų bei depresijos simptomais**. Vaikams poveikis pirmiausia stebimas svorio ir lipidų disbalanso srityse.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Šalys rekomenduoja juos apriboti';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Kai kurios šalys naudoja NOVA grupes savo mitybos gairėms ar tikslams nustatyti, pavyzdžiui:\n\n- **🇧🇷 Brazilijos** mitybos gairėse **rekomenduojama apriboti perdirbto maisto vartojimą** ir vengti itin perdirbto maisto.\n\n- **🇫🇷 Prancūzijos** visuomenės sveikatos mitybos politikos tikslai 2018–2022 m. siekia **20 % sumažinti 4 grupės itin perdirbtų maisto produktų vartojimą**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Sveiki atvykę į „Open Food Facts“!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Kas yra atviri faktai apie maistą?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      '„Open Food Facts“ yra **bendradarbiavimo pagrindu sukurta**, **nemokama** ir **atvira** maisto produktų iš viso pasaulio duomenų bazė.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Tikime, kad kiekvienas turėtų turėti prieigą prie informacijos apie tai, ką valgo. Rinkdami duomenis apie sudedamąsias dalis, alergenus, maistinę vertę ir kita, **suteikiame vartotojams galimybę priimti informacija pagrįstus sprendimus** ir skatiname maisto pramonę **siekti didesnio skaidrumo**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Atvirų maisto faktų ypatybės';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Gaukite įspėjimus apie nepageidaujamus ingredientus';

  @override
  String get guide_open_food_facts_tips_title =>
      'Patarimai, kaip daryti puikias nuotraukas';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Ko nedaryti';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Venkite šešėlių ir akinančių šviesų.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Nėra neryškaus ar nefokusuoto teksto.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Neiškirpkite teksto dalių.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Venkite užimtų fonų.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Daryti';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Naudokite gerą, tolygų apšvietimą.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Įsitikinkite, kad tekstas yra ryškus ir įskaitomas.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Užfiksuokite visą ingredientų sąrašą.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Laikykite gaminį ant lygaus paviršiaus.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Padėkite mums sukurti „Maisto Vikipediją“';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Maistingumo kokybės įvertinimas';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Rezultatas, padedantis išvengti itin perdirbtų maisto produktų';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Rezultatas planetai';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-lt.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Sveiki atvykę į „Open Pet Food Facts“!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Kas yra atviri naminių gyvūnėlių ėdalo faktai?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      '„Open Pet Food Facts“ pratęsia savo misiją, įtraukdama ir mūsų keturkojus draugus! Tai **naminių gyvūnėlių ėdalo produktų katėms, šunims ir kitiems draugams** duomenų bazė.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Renkame informaciją apie **sudedamąsias dalis**, **maistinę analizę** ir šėrimo gaires, kad padėtume augintinių savininkams išsirinkti geriausią ėdalą savo gyvūnų poreikiams.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Atviro naminių gyvūnėlių ėdalo faktų ypatybės';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Gaukite įspėjimus apie nepageidaujamus ingredientus';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Ar jūsų augintinis yra alergiškas kokiems nors ingredientams? Programėlėje galite susikurti vengtinų kosmetikos ingredientų sąrašą!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Patarimai, kaip daryti puikias nuotraukas';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Ko nedaryti';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Venkite šešėlių ir akinančių šviesų.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Nėra neryškaus ar nefokusuoto teksto.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Neiškirpkite teksto dalių.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Venkite užimtų fonų.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Daryti';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Naudokite gerą, tolygų apšvietimą.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Įsitikinkite, kad tekstas yra ryškus ir įskaitomas.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Užfiksuokite visą ingredientų sąrašą.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Laikykite gaminį ant lygaus paviršiaus.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Pastaba apie taškų skaičiavimą';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Gyvūnų ėdalo vertinimo sistemos kūrimas **šiuo metu nėra prioritetas**. Metodologija būtų sudėtinga, nes mitybos poreikiai labai skiriasi priklausomai nuo rūšies, amžiaus ir sveikatos būklės. Kol kas neradome jokios nepriklausomos mokslinės komandos, galinčios sukurti tokį balą.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-lt.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Sveiki atvykę į „Open Beauty Facts“!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Kas yra atviri grožio faktai?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      '„Open Beauty Facts“ yra bendradarbiaujant sukurta **kosmetikos gaminių** duomenų bazė.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Mūsų tikslas – iššifruoti ingredientų sąrašus, kad padėtume jums **suprasti, kas yra jūsų asmeninės higienos priemonėse**. Nuo drėkinamųjų kremų iki makiažo – renkame duomenis apie ingredientus, alergenus ir pakuotes, siekdami skatinti skaidrumą kosmetikos pramonėje.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Atvirų grožio faktų ypatybės';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Gaukite įspėjimus apie nepageidaujamus ingredientus';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Ar esate alergiškas kokiems nors ingredientams? Norite išvengti komedogeninių medžiagų? Norite vengti prieštaringai vertinamų komponentų? Programėlėje galite susikurti vengtinų kosmetikos ingredientų sąrašą!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Patarimai, kaip daryti puikias nuotraukas';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Ko nedaryti';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Venkite šešėlių ir akinančių šviesų.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Nėra neryškaus ar nefokusuoto teksto.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Neiškirpkite teksto dalių.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 => 'Venkite užimtų fonų.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Daryti';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Naudokite gerą, tolygų apšvietimą.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Įsitikinkite, kad tekstas yra ryškus ir įskaitomas.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Užfiksuokite visą ingredientų sąrašą.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Jei butelis išlenktas, padarykite tiek nuotraukų, kiek reikia.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Norint pamatyti sudedamųjų dalių sąrašą, gali tekti nulupti etiketę.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Laikykite gaminį ant lygaus paviršiaus.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Pastaba apie taškų skaičiavimą';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Kitaip nei maisto produktų atveju, kosmetikos pasaulyje **nėra visuotinai pripažintos, vyriausybės remiamos vertinimo sistemos, tokios kaip „Nutri-Score“**. Ingredientų poveikis gali būti labai asmeniškas ir priklausyti nuo odos tipo, alergijų ir individualių poreikių.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-lt.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      '„Open Prices“ yra projektas, skirtas **rinkti ir dalytis produktų kainomis visame pasaulyje**. Tai viešai prieinamas duomenų rinkinys, kurį galima naudoti tyrimams, analizei ir kt. „Open Prices“ kuria ir prižiūri „Open Food Facts“.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Mes renkame atvirojo kodo kainų duomenų rinkinį**. Kainas gali pridėti vartotojai per šią žiniatinklio programėlę arba per oficialią mobiliąją programėlę „Open Food Facts“. Mažmenininkai arba trečiųjų šalių programėlės taip pat gali prisidėti naudodami mūsų API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Surinkite kainų etikečių nuotraukas praėjimuose';

  @override
  String get guide_open_prices_how_arg2_title => 'Surinkite kvitų nuotraukas';

  @override
  String get guide_open_prices_why_title => 'Kodėl „Open Food Facts“ tai daro?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Informacija apie kainas yra nepaprastai svarbi norint suprasti maisto sistemas. Tai pagrindinis veiksnys norint suprasti maisto kainą ir skatinti sveikesnę mitybą. Pradiniai kainų duomenys yra būdas padėti tyrėjams, žurnalistams ir piliečiams **geriau suprasti, kaip maisto kainos kinta geografiniu požiūriu ir laikui bėgant**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Stebėkite kainų pokyčius laikui bėgant';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Stebėkite **kainų evoliuciją**: susitraukimo infliacija, pigios infliacijos tendencija – galime jas sekti kartu!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Palyginkite kainas šalia jūsų';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Kai gausime daugiau kainų, galėsite rasti **pigiausias parduotuves aplink jus**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Ar svarstėte galimybę nuskaityti kainas iš mažmenininkų svetainių?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Kainų nuskaitymas yra svarstoma galimybė būsimoje „Open Prices“ versijoje, tačiau tai atliktų pati „Open Prices“, kad galėtume turėti kainos įrodymą pagal HTML puslapį.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Kainas galite skelbti naudodami mūsų API.\nJei norite prisidėti prie kainų nustatymo dideliu mastu, susisiekite su mumis adresu prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Sveiki atvykę į atvirų produktų faktus!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Kas yra atviri produktų faktai?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      '„Open Products Facts“ yra didžiulė, atvira duomenų bazė, skirta **bet kokiam produktui su brūkšniniu kodu, kuris nėra maistas, kosmetika ar naminių gyvūnėlių ėdalas**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Nuo **elektronikos** iki **žaislų**, nuo **drabužių** iki **valymo priemonių** – jei yra brūkšninis kodas, jį galima pridėti. Šio projekto tikslas – sukurti „daiktų internetą“ kasdieniams daiktams, kad informacija apie juos būtų visuotinai prieinama.';

  @override
  String get guide_open_products_facts_features_title =>
      'Atvirų produktų faktų ypatybės';

  @override
  String get guide_open_products_facts_features_text =>
      '„Open Products Facts“ siekia suteikti vartotojams galimybę **prailginti daiktų gyvavimo laiką**, siūlant žiedinės ekonomikos sprendimus, skirtus jų daiktams prižiūrėti, **remontuoti**, **perdirbti** arba suteikti jiems naują savininką.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Kai kurių produktų anglies pėdsakai';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      'Prancūzijos aplinkos agentūros ADEME **CO2 poveikio** duomenys pateikia daugelio kategorijų **anglies dioksido poveikio** duomenis, todėl būtinai tiksliai suskirstykite produktus į kategorijas.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Daugelio gaminių taisomumo indeksas';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Kai tik bus prieinamas prancūziškas taisomumo indeksas, jį rodysime. Be to, **galite pradėti rinkti kintamuosius naudodami „Folksonomy“ variklį**, kad ateityje galėtume jį perskaičiuoti patys, net ir tose šalyse, kuriose jis nėra prieinamas.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Raskite būdų, kaip paaukoti / perparduoti savo produktą';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Pateikiame nuorodas į **trečiųjų šalių žiedinės ekonomikos paslaugas**, kurios padeda jums įsigyti norimą produktą iš antrų rankų, kad būtų tausojantys planetos išteklius.\nAtkreipkite dėmesį, kad mums už tai nemokama ir kad sistema veikia tik kaip dviejų Prancūzijos svetainių pavyzdys. Galite padėti plėsti šią sistemą dokumentuodami daugiau svetainių wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Kokia informacija yra naudinga?';

  @override
  String get guide_open_products_facts_information_text =>
      'Tokiam plačiam elementų asortimentui **mūsų renkami duomenys yra lankstūs**. Tam **sukūrėme „Folksonomy“ variklį**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Folksonomijos variklis';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      '„Folksonomy“ variklis yra įrankis, padedantis jums papildyti produktus atitinkamomis savybėmis. Tai padeda pagerinti paiešką ir aptinkamumą, taip pat ateityje apskaičiuoti ir rodyti įdomius dalykus.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Galite pridėti bet kokius raktus ir reikšmes, pvz.: **suderinamumas_su_5G_mobile_network: taip**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Gausite automatinius galimų savybių pasiūlymus ir galite pridėti bei dokumentuoti naujas savo mėgstamiausių produktų savybes.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-lt.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Atidaryti maisto nuostatas';

  @override
  String get guide_coming_soon_button_title => 'Netrukus pasirodys';

  @override
  String get guide_learn_more_subtitle =>
      'Palieskite, kad sužinotumėte daugiau';

  @override
  String get preview_badge => 'Peržiūra';

  @override
  String get prices_feedback_form =>
      'Spustelėkite čia, jei norite atsiųsti mums atsiliepimą apie šią naują funkciją!';

  @override
  String get menu_button_list_actions => 'Rinktis veiksmą';

  @override
  String get error_loading_photo => 'Įkeliant nuotrauką, įvyko klaida';

  @override
  String get photo_viewer_action_use_picture_as => 'Naudoti kaip…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Naudoti šią nuotrauką kaip…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Naudokite šį paveikslėlį kaip… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Išsamesnė informacija';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Šios nuotraukos duomenys';

  @override
  String get photo_viewer_details_title => 'Nuotraukos duomenys';

  @override
  String get photo_viewer_details_contributor_title => 'Pagalbininkas';

  @override
  String get photo_viewer_details_size_title => 'Dydis';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pikselių';
  }

  @override
  String get photo_viewer_details_date_title => 'Data';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Suderinama';

  @override
  String get user_lists_action_multi_select => 'Daugybinis pasirinkimas';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Jūsų suderinamumo balas: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Priekinė nuotrauka';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Sudėties nuotrauka';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Maistingumo nuotrauka';

  @override
  String get product_image_packaging_accessibility_label =>
      'Pakuotės nuotrauka';

  @override
  String get product_image_other_accessibility_label => 'Kita nuotrauka';

  @override
  String get product_image_outdated_message =>
      'Ši nuotrauka gali būti pasenusi';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (šis vaizdas gali būti pasenęs)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (šį vaizdą galėjo užrakinti gamintojas)';
  }

  @override
  String get product_image_error => 'Nepavyko įkelti vaizdo!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Nepavyko įkelti $type (tinklo klaida?)';
  }

  @override
  String get product_page_image_no_image_available => 'Nėra\nvaizdo!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Šio produkto paveikslėlio nėra';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Pertvarkyti arba slėpti veiksmus';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Redaguoti veiksmus';

  @override
  String get product_page_action_bar_item_move_up => 'Kilti aukštyn';

  @override
  String get product_page_action_bar_item_move_down => 'Leistis žemyn';

  @override
  String get product_page_action_bar_item_enable => 'Įjungti veiksmą';

  @override
  String get product_page_action_bar_item_disable => 'Išjungti veiksmą';

  @override
  String get product_page_pending_operations_banner_title =>
      'Įkeliamos jūsų redakcijos…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Šiame puslapyje rodomi duomenys **dar neatspindi jūsų modifikacijų**.\nPalaukite kelias sekundes…';

  @override
  String get product_add_a_language => 'Pridėti kalbą';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Brūkšninis kodas $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Pašalinti šį produktą iš karuselės';

  @override
  String get carousel_unsupported_header => 'Nepalaikomas brūkšninis kodas!';

  @override
  String get carousel_unsupported_title => 'Oi!';

  @override
  String get carousel_unsupported_text =>
      'Nuskaityto brūkšninio kodo „Open Food Facts“ nepalaiko!';

  @override
  String get carousel_error_header => 'Klaida!';

  @override
  String get carousel_error_title => 'Koks nusivylimas!';

  @override
  String get carousel_error_text_1 =>
      'Mums nepavyko atsisiųsti informacijos apie šį brūkšninį kodą:';

  @override
  String get carousel_error_text_2 =>
      'Patikrinkite interneto ryšį arba spustelėkite šį mygtuką:';

  @override
  String get carousel_error_button => 'Bandyti dar kartą';

  @override
  String get carousel_unknown_product_header => 'Nežinomas produktas';

  @override
  String get carousel_unknown_product_title =>
      'Sveikiname!\nJūs radote __retą brangakmenį!__';

  @override
  String get carousel_unknown_product_text =>
      'Mūsų bendradarbiavimo duomenų bazėje yra daugiau negu **3 milijonai produktų**, tačiau šio brūkšninio kodo nėra: ';

  @override
  String get carousel_unknown_product_button => 'Pridėti šį produktą';

  @override
  String get carousel_loading_header => 'Įkeliama informacija...';

  @override
  String get carousel_loading_title =>
      'Ką tik nuskaitėte produktą su šiuo brūkšniniu kodu:';

  @override
  String get carousel_loading_text =>
      'Mes jo ieškome savo duomenų bazėje, kurioje yra daugiau negu **3 milijonai produktų!**';

  @override
  String get product_type_subtitle_food =>
      'Daržovės, vaisiai, šaldyti maisto produktai…';

  @override
  String get product_type_subtitle_beauty => 'Makiažas, muilai, dantų pastos…';

  @override
  String get product_type_subtitle_pet_food => 'Maistas šunims, katėms…';

  @override
  String get product_type_subtitle_product => 'Išmanieji telefonai, baldai…';

  @override
  String get photo_field_front => 'Produkto nuotrauka';

  @override
  String get photo_field_ingredients => 'Sudėties nuotrauka';

  @override
  String get photo_field_nutrition => 'Mitybos nuotrauka';

  @override
  String get photo_field_packaging => 'Perdirbimo instrukcijos nuotrauka';

  @override
  String get photo_already_exists => 'Ši nuotrauka jau yra';

  @override
  String get photo_missing => 'Šios nuotraukos trūksta';

  @override
  String get date => 'Data';

  @override
  String get photo_rotate_left => 'Pasukite į kairę';

  @override
  String get photo_rotate_right => 'Pasukite į dešinę';

  @override
  String get photo_undo_action => 'Anuliuoti ankstesnį veiksmą';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$location pasaulio žemėlapis';
  }

  @override
  String get open_street_map_contributor_attribution =>
      '„OpenStreetMap“ bendraautoriai';

  @override
  String get not_applicable_short => 'Netaikoma';

  @override
  String get knowledge_panel_warning_text => 'Įspėjimas';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Kodėl šis „Nutri-Score“ rodiklis skiriasi nuo pateikto ant pakuotės?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Yra du galimi paaiškinimai:\nSudedamųjų dalių sąrašas ir (arba) maistinė vertė nėra atnaujinta.\n\nPateikiame „Naujas Nutri-Score“ (arba V2) skaičiavimas. Patikrinkite, ar ant pakuotės yra antraštė „Naujas skaičiavimas“.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Patikrinkite ingredientus';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Patikrinkite mitybos faktus';

  @override
  String url_not_supported(String url) {
    return 'Deja, negalime atverti URL:\n$url';
  }

  @override
  String get product_list_export => 'Eksportuoti';

  @override
  String get product_list_import => 'Importuoti';

  @override
  String get product_footer_action_barcode => 'Žiūrėti brūkšninį kodą';

  @override
  String get product_footer_action_barcode_short => 'Barkodas';

  @override
  String get product_footer_action_open_website =>
      'Atverti internetinę svetainę';

  @override
  String get product_footer_action_report => 'Pranešti';

  @override
  String get product_footer_action_contributor_guide => 'Pagalba';

  @override
  String get product_footer_action_data_quality_tags => 'Duomenų kokybė';

  @override
  String get product_page_tab_for_me => 'Man';

  @override
  String get product_page_tab_website => 'Interneto svetainė';

  @override
  String get product_page_tab_prices => 'Kainos';

  @override
  String get prices_explanation_card_title => 'Kodėl kainos?';

  @override
  String get prices_explanation_card_line1 =>
      '**„Open Prices“** – tai projektas, skirtas rinkti ir dalytis produktų kainomis visame pasaulyje 🌍. „Open Prices“ kuria ir prižiūri „Open Food Facts“.';

  @override
  String get explanation_card_learn_more_button => 'Sužinokite daugiau';

  @override
  String get product_page_tab_folksonomy => 'Folksonomija';

  @override
  String get folksonomy_explanation_card_title =>
      'Kokie yra folksonomijos atributai?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atributai yra pagrįsti **rakto-reikšmės** principais.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Šias savybes kuria ir pateikia bendraautoriai bet kokiam naudojimui.';

  @override
  String get folksonomy_action_external_link_title =>
      'Atidaryti išorinę nuorodą';

  @override
  String get folksonomy_action_external_link_warning =>
      'Išorinės nuorodos gali būti nesaugios. Ar tikrai norite jas aplankyti?';

  @override
  String get prices_products_empty_title => 'Kaina nežinoma';

  @override
  String get prices_products_empty_explanation => 'Būkite pirmas, prisidėjęs!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Geriausi $pageSize produktai (iš viso: $total)';
  }

  @override
  String get app_review_title => 'Ar jums patinka ši programėlė?';

  @override
  String get app_review_low => 'Galėtų geriau';

  @override
  String get app_review_medium => 'Neblogai';

  @override
  String get app_review_high => 'Man ji labai patinka!';

  @override
  String get app_review_feedback_modal_title =>
      'Padėkite mums patobulinti programėlę';

  @override
  String get app_review_feedback_modal_content =>
      'Jei turite kelias minutes, gal galėtumėte atsakyti į šią formą, kad **galėtume patobulinti būsimuose naujiniuose**:';

  @override
  String get app_review_feedback_modal_open_form =>
      'Atsakyti į formos klausimus';

  @override
  String get app_review_feedback_modal_later => 'Paklauskite manęs vėliau';

  @override
  String get nutrition_facts_extract_new =>
      'NAUJIENA: galite automatiškai gauti maistingąsias medžiagas iš paveikslėlio!';

  @override
  String get nutrition_facts_extract_button_text => 'Gauti dabar';

  @override
  String get nutrition_facts_extract_in_progress => 'Vykdomas išgavimas…';

  @override
  String get nutrition_facts_extract_successful => 'Ištraukimas sėkmingas';

  @override
  String get nutrition_facts_extract_failed =>
      'Nepavyko gauti maistingųjų medžiagų iš paveikslėlio';

  @override
  String get prices_discount => 'Nuolaida';

  @override
  String get prices_stats_statistics => 'Statistika';

  @override
  String get prices_stats_title => 'Kainų statistika';

  @override
  String get prices_stats_prices_section => 'Kainos';

  @override
  String get prices_stats_products_section => 'Produktai';

  @override
  String get prices_stats_locations_section => 'Vietos';

  @override
  String get prices_stats_proofs_section => 'Įrodymai';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Eksperimentai';

  @override
  String get prices_stats_misc_section => 'Įvairūs';

  @override
  String get prices_stats_total => 'Iš viso';

  @override
  String get prices_stats_with_barcode => 'Su brūkšniniu kodu';

  @override
  String get prices_stats_with_category => 'Su kategorija';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Bendruomenė';

  @override
  String get prices_stats_consumption => 'Vartojimas';

  @override
  String get prices_stats_with_price => 'Su kaina';

  @override
  String get prices_stats_food => 'Maistas';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Produktai';

  @override
  String get prices_stats_pet_food => 'Naminių gyvūnėlių ėdalas';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Prisijungus';

  @override
  String get prices_stats_countries => 'Šalys';

  @override
  String get prices_stats_price_tag => 'Kainos etiketė';

  @override
  String get prices_stats_receipt => 'Čekis';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Iššūkiai';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Kainos susietos su kainų etikete';

  @override
  String get prices_stats_currencies => 'Valiutos';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Interneto svetainė';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Kita';

  @override
  String get prices_stats_last_updated => 'Paskutinį kartą atnaujinta';

  @override
  String get prices_stats_error => 'Įkeliant statistiką įvyko klaida.';

  @override
  String get product_edit_robotoff_question_answered => 'Į klausimą atsakyta!';

  @override
  String get product_edit_robotoff_proof => 'Įrodymai';

  @override
  String get preferences_card_general => 'Bendra';

  @override
  String get preferences_prices_title => 'Kainos';

  @override
  String get preferences_prices_subtitle => 'Tvarkykite savo kainų nuostatas';

  @override
  String get preferences_card_project => 'Atvirų maisto faktų projektas';

  @override
  String get preferences_contribute_title => 'Prisidėti';

  @override
  String get preferences_my_contributions_title => 'Mano indėlis';

  @override
  String get preferences_my_stats_title => 'Mano statistika';

  @override
  String get preferences_contribute_subtitle =>
      'Verskite, tobulinkite savo įrankius…';

  @override
  String get preferences_connect_title => 'Prisijungti';

  @override
  String get preferences_connect_subtitle =>
      'Susisiekite arba sekite mus socialiniuose tinkluose';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Padėkite mums informuoti milijonus vartotojų visame pasaulyje';

  @override
  String get preferences_card_help => 'Pagalba ir palaikymas';

  @override
  String get preferences_faq_title => 'DUK';

  @override
  String get preferences_faq_subtitle => 'Gaukite atsakymus į savo klausimus';

  @override
  String get logged_out => 'Atsijungęs';

  @override
  String get preferences_app_bar_message =>
      'Ačiū, kad esate vienas iš mūsų narių!';

  @override
  String get preferences_app_bar_products_modified => 'Produktai modifikuoti';

  @override
  String get preferences_app_bar_prices_added => 'Pridėtos kainos';

  @override
  String get preferences_app_bar_see_all_stats => 'Žr. visą statistiką';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Ieškoti $provider pagal „$keyword“';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Ieškoti nustatymo (pvz., „Nutri-Score“)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Pritaikymas neįgaliesiems: rodyti jaustukus';

  @override
  String get preferences_accessibility_remove_colors =>
      'Pritaikymas neįgaliesiems: pašalinti spalvas';

  @override
  String get preferences_app_settings_products => 'Produktai';

  @override
  String get preferences_card_about => 'Apie';

  @override
  String get preferences_legal_information_title => 'Teisinė informacija';

  @override
  String get preferences_legal_information_subtitle =>
      'Naudojimo sąlygos, privatumo politika ir kita';

  @override
  String get preferences_terms_of_use => 'Naudojimo sąlygos';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      '„Open Food Facts“ yra maisto produktų duomenų bazė, **sukurta visų, skirta visiems**.\nJą galite naudoti norėdami priimti geresnius sprendimus dėl maisto produktų, o kadangi tai yra **atviri duomenys**, kiekvienas gali **ją pakartotinai naudoti bet kokiam tikslui**.';

  @override
  String get preferences_privacy_policy => 'Privatumo politika';

  @override
  String get preferences_licenses => 'Licencijos';

  @override
  String get preferences_about_app_title => 'Apie programėlę';

  @override
  String get preferences_about_app_subtitle =>
      'Techninė informacija, kūrėjo informacija ir kita';

  @override
  String get preferences_card_information => 'Information';

  @override
  String get preferences_version_number_title => 'Versijos numeris';

  @override
  String get preferences_scanner_title => 'Skaitytuvas';

  @override
  String get preferences_app_store => 'Programėlių parduotuvė';

  @override
  String get preferences_app_system_settings => 'Sistemos nustatymai';

  @override
  String get preferences_source_code => 'Prieiga prie šaltinio kodo';

  @override
  String get preferences_source_code_subtitle =>
      'Ir pradėkite daryti įtaką milijonams';

  @override
  String get preferences_add_prices => 'Pridėti kainas';

  @override
  String get preferences_complete_products =>
      'Pilnai užbaik redaguoti produktus';

  @override
  String get preferences_tips => 'Patarimai';

  @override
  String get tips_discover_nutriscore => 'Atraskite naująjį „Nutri-Score“';

  @override
  String get preferences_on_off_website_subtitle =>
      'Atvirų maisto faktų svetainėje';

  @override
  String get preferences_manage_account_title => 'Tvarkyti mano paskyrą';

  @override
  String get preferences_manage_account_tooltip => 'Tvarkykite savo paskyrą';

  @override
  String get preferences_change_password_title => 'Keisti slaptažodį';

  @override
  String get preferences_danger_zone => 'Pavojinga zona';

  @override
  String get preferences_account_deletion_subtitle =>
      'Visi jūsų įnašai bus prarasti';

  @override
  String get preferences_contributions_title => 'Prisidėjo';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Programėlės nustatymai';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Labai eksperimentinis būdas nuskaityti produktus neprisijungus';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Atnaujinti visus produktus iš serverio';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Prašome to nedaryti, nebent tai absoliučiai būtina';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demonstracinis režimas';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Pridėti korteles prie skaitytuvo';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Prideda prie skaitytuvo 3 produktų pavyzdžius';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Folksonomy šeimininkas';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Pagrindinis kompiuteris: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Prieinamumo eksperimentai';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Kelių produktų pasirinkimas pagal kainas';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Vartotojo išdėstytos žinių panelės';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Laikina prieiga prie vietos paieškos';

  @override
  String get preferences_dev_mode_comparison_title =>
      '2 arba 3 produktų palyginimas greta';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Produktų sąrašo importavimas';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Rezultatai ir metodologijos';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Sužinokite, kaip apskaičiuojamas „Nutri-Score“';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Sužinokite apie pagrindinius metodologijos pakeitimus';

  @override
  String get preferences_faq_discover_project_title => 'Apie projektą';

  @override
  String get preferences_faq_discover_off_title =>
      'Atraskite atvirus faktus apie maistą';

  @override
  String get preferences_faq_discover_obf_title =>
      'Atraskite atvirus grožio faktus';

  @override
  String get preferences_faq_discover_opff_title =>
      'Atraskite atvirus faktus apie naminių gyvūnėlių ėdalą';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Atraskite atvirus produktų faktus';

  @override
  String get preferences_faq_faq_title => 'DUK – Dažnai užduodami klausimai';

  @override
  String get preferences_faq_off_ngo_title =>
      'Atvirų maisto faktų nevyriausybinė organizacija';

  @override
  String get preferences_about_information_title => 'Information';

  @override
  String get preferences_connect_community_updates_title =>
      'Gaukite bendruomenės naujienas';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Būkite informuoti apie programėlės ir bendruomenės naujienas';

  @override
  String get preferences_connect_community_calendar_title =>
      'Prenumeruokite mūsų bendruomenės kalendorių';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Prisijunkite prie mūsų virtualių renginių';

  @override
  String get preferences_connect_blog_title => '„Open Food Facts“ tinklaraštis';

  @override
  String get preferences_connect_blog_subtitle =>
      'Gaukite naujausias naujienas, kai tik jos įvyks';

  @override
  String get preferences_connect_community_help_title =>
      'Gaukite pagalbos iš bendruomenės';

  @override
  String get preferences_connect_improve_app_title =>
      'Padėkite mums tobulinti programėlę';

  @override
  String get preferences_connect_debug_info_title =>
      'Atsiųskite mums derinimo informaciją';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Atsiųskite mums el. laišką su išsamia derinimo informacija';

  @override
  String get preferences_connect_feedback_title =>
      'Atsiųskite mums atsiliepimą apie programėlę';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Padėkite formuoti programėlės ateitį';

  @override
  String get preferences_connect_survey_title =>
      'Dalyvaukite programėlės apklausoje';

  @override
  String get preferences_connect_survey_subtitle =>
      'Padėkite mums suprasti, ką turėtume kurti toliau';

  @override
  String get preferences_connect_professionals_title => 'Profesionalai';

  @override
  String get preferences_connect_pro_subtitle =>
      'Visiškai nemokama, užtikrina tikslius duomenis 500 programėlių ir milijonams vartotojų. Savitarnos funkcija, suderinama su jūsų PIM arba skaičiuoklėmis (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Susisiekite, kad pradėtumėte';

  @override
  String get preferences_connect_press_title => 'Spauda';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Gaukite visą medžiagą, kurios jums reikia ataskaitai';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Susisiekite su mumis dėl spaudos klausimų arba norėdami pranešti mums apie savo ataskaitą';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Tapkite aktyviu savanoriu';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Kūrimas, komunikacija, dizainas… bet kokia savanorystė ar patirtis yra laukiami!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Atraskite keletą iš daugelio būdų, kaip galite prisidėti';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Mobiliųjų programėlių kūrimas';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Sužinokite, kaip prisidėti prie programinės įrangos kūrimo';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Kasdienės nestabilios versijos, visiškai naujos funkcijos';

  @override
  String get preferences_contribute_local_community_title =>
      'Plėskite savo vietos bendruomenę';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Pagalba su programinės įrangos, turinio, ingredientų analizės vertimais';

  @override
  String get preferences_contribute_share_subtitle =>
      'Paruošėme nedidelį šabloną, kuris jums padės :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Paprasti žingsniai, kaip padidinti maisto skaidrumą jūsų šalyje';

  @override
  String get preferences_contribute_data_quality_title => 'Duomenų kokybė';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Prisijunkite prie duomenų kokybės komandos';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Prisijunkite prie mūsų pastangų užtikrinti, kad duomenų bazė būtų išsami ir tiksli';

  @override
  String get preferences_contributions_products_added_title =>
      'Pridėti produktai';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nauji produktai, kuriuos pridėjau prie „Open Food Facts“';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produktai, kuriuos man reikia užbaigti';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Visi nebaigti produktai';

  @override
  String get preferences_my_contributions_prices_title => 'Kainos';

  @override
  String get preferences_my_contributions_my_prices_title => 'Mano kainos';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Mano kainos, mano įrodymai…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produktai, kuriuos galite padėti užbaigti';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Padėkite apskaičiuoti „Nutri-Score“ ir „Green-Score“ jūsų šalyje';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Kainos, kurias aš pateikiau';

  @override
  String get preferences_prices_proofs_subtitle => 'Kainų etiketės ir kvitai';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Nufotografuokite savo kvitus ir nuskaitykite susijusius brūkšninius kodus';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Nufotografuokite kainas parduotuvėje';

  @override
  String get preferences_prices_newest_title => 'Naujausios kainos';

  @override
  String get preferences_prices_newest_subtitle =>
      'Naujausios kainos, kurias pridėjo „Open Prices“ bendruomenė';

  @override
  String get preferences_prices_top_contributors_title =>
      'Prisidėjusieji, kurių kainos yra didžiausios';

  @override
  String get preferences_prices_metrics_title => 'Atidaryti kainos metriką';

  @override
  String get preferences_prices_metrics_subtitle => 'Sekite projekto eigą';

  @override
  String get preferences_prices_ways_contribute_title => 'Būdai prisidėti';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Patvirtinkite savo ar kitų pridėtas kainas, pasitelkdami dirbtinį intelektą';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Greitai pridėkite daug kvitų ar lentynų nuotraukų iš savo fotoaparato ritinio';

  @override
  String get preferences_prices_challenges_title => 'Mėnesio iššūkiai';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Dalyvaukite mėnesinėse teminėse užduotyse, kad surinktumėte prizus';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Atgaukite savo lojalumo duomenis';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Sužinokite, kaip pateikti užklausą dėl savo duomenų';

  @override
  String get preferences_page_customize_app_title => 'Programėlės tinkinimas';

  @override
  String get preferences_page_contribute_project_title =>
      'Prisidėti prie projekto';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Paprasti būdai padėti „Open Food Facts“ svetainėje';

  @override
  String get preferences_page_faq_subtitle =>
      'Vertinimo metodikos, pagalba ir kita informacija apie projektą';

  @override
  String get product_edit_robotoff_positive_button => 'Priimti pasiūlymą';

  @override
  String get product_edit_robotoff_negative_button => 'Atmesti pasiūlymą';

  @override
  String get product_edit_robotoff_show_proof => 'Rodyti įrodymą';

  @override
  String get product_edit_robotoff_expand_proof => 'Išplėsti įrodymą';

  @override
  String get product_page_tab_raw_data => 'Neapdoroti duomenys';

  @override
  String page_indicator_with_total(int current, int total) {
    return '$current iš $total psl.';
  }

  @override
  String page_indicator(int current) {
    return '$current psl.';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count iš $total prekių';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count iš $total prekių';
  }

  @override
  String item_count(int count) {
    return '$count prekės';
  }

  @override
  String item_count_string(String count) {
    return '$count prekės';
  }

  @override
  String get prices_no_result => 'Kainų statistikos nerasta.';

  @override
  String get prices_error_loading_more_items =>
      'Įkeliant daugiau prekių įvyko klaida';

  @override
  String get prices_proof_error =>
      'Autentifikavimas nepavyko, negalima gauti įrodymų';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count iš $total įrodymų';
  }

  @override
  String proof_count(int count) {
    return '$count įrodymai (-ų)';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count iš $total bendraautorių';
  }

  @override
  String contributors_count(int count) {
    return '$count bendraautoriai (-ių)';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count iš $total vietų';
  }

  @override
  String prices_locations_count(int count) {
    return '$count vietų';
  }

  @override
  String get restart_to_apply_message =>
      'Kad pakeitimai įsigaliotų, paleiskite programėlę iš naujo.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafinė sąsaja';

  @override
  String get preferences_app_settings_media_title => 'Žiniasklaida';

  @override
  String get preferences_about_app_development_title => 'Programavimas';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Atviros maisto faktų laboratorijos';

  @override
  String get preferences_root_account_title => 'Paskyra';

  @override
  String get preferences_contribute_translate_header =>
      'Atviri maisto faktai jūsų kalba';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Registruokitės programėlės alfa versijai';

  @override
  String get preferences_dev_mode_section_data => 'Įnašai ir produkto duomenys';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Nerodyti folksonomijos';

  @override
  String get preferences_account_title => 'Paskyra';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Pridėta $created';
  }

  @override
  String get location_map_details_title => 'Vietos informacija';

  @override
  String get location_map_details_name => 'Vardas';

  @override
  String get location_map_details_street => 'Gatvė';

  @override
  String get location_map_details_city => 'Miestas';

  @override
  String get location_map_details_postcode => 'Pašto kodas';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Koordinatės';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
