// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Italian (`it`).
class AppLocalizationsIt extends AppLocalizations {
  AppLocalizationsIt([String locale = 'it']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Sì';

  @override
  String get add => 'Aggiungi';

  @override
  String get account_delete_message =>
      'Confermi di voler eliminare il tuo profilo?\nQualora vi fosse una motivazione specifica, si prega di condividerla di seguito';

  @override
  String get reason => 'Motivazione';

  @override
  String get okay => 'Ok';

  @override
  String get validate => 'Convalida';

  @override
  String get create => 'Crea';

  @override
  String get applyButtonText => 'Applica';

  @override
  String get next_label => 'Avanti';

  @override
  String get continue_label => 'Continua';

  @override
  String get exit_label => 'Esci';

  @override
  String get previous_label => 'Indietro';

  @override
  String get go_back_to_top => 'Torna all\'inizio';

  @override
  String get save => 'Salva';

  @override
  String get save_confirmation => 'Sei sicuro di voler salvare?';

  @override
  String get skip => 'Salta';

  @override
  String get cancel => 'Annulla';

  @override
  String get ignore => 'Ignora';

  @override
  String get close => 'Chiudi';

  @override
  String get no => 'No';

  @override
  String get stop => 'Ferma';

  @override
  String get finish => 'Fine';

  @override
  String get calculate => 'Calcola';

  @override
  String get reset_food_prefs => 'Ripristina preferenze alimentari';

  @override
  String get error => 'Si è verificato un errore';

  @override
  String get error_occurred => 'Si è verificato un errore';

  @override
  String get featureInProgress =>
      'Stiamo ancora lavorando a questa funzionalità, rimanete sintonizzati';

  @override
  String get label_web => 'Visualizza sul web';

  @override
  String get learnMore => 'Ulteriori informazioni';

  @override
  String get unknown => 'Sconosciuto';

  @override
  String get match_very_good => 'Corrispondenza molto buona';

  @override
  String get match_good => 'Corrispondenza buona';

  @override
  String get match_poor => 'Corrispondenza debole';

  @override
  String get match_may_not => 'Potrebbe non corrispondere';

  @override
  String get match_does_not => 'Non corrisponde';

  @override
  String get match_unknown => 'Corrispondenza sconosciuta';

  @override
  String get match_short_very_good => 'Corrispondenza molto buona';

  @override
  String get match_short_good => 'Corrispondenza buona';

  @override
  String get match_short_poor => 'Corrispondenza debole';

  @override
  String get match_short_may_not => 'Potrebbe non corrispondere';

  @override
  String get match_short_does_not => 'Non corrisponde';

  @override
  String get match_short_unknown => 'Corrispondenza sconosciuta';

  @override
  String get licenses => 'Licenze';

  @override
  String get looking_for => 'In cerca di';

  @override
  String get welcomeToOpenFoodFacts => 'Benvenuto in Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts è un\'organizzazione globale senza scopo di lucro sostenuta dalle comunità locali.';

  @override
  String get productDataUtility =>
      'Visualizza i dati alimentari rilevanti alle tue preferenze.';

  @override
  String get healthCardUtility => 'Scegli gli alimenti che ti fanno bene.';

  @override
  String get ecoCardUtility => 'Scegli alimenti che fanno bene al pianeta.';

  @override
  String get server_error_open_new_issue =>
      'Nessuna risposta dal server! Puoi aprire una segnalazione con il seguente link.';

  @override
  String get sign_in_text =>
      'Accedi al tuo profilo di Open Food Facts per salvare i tuoi contributi';

  @override
  String get incorrect_credentials => 'Nome utente o password errati.';

  @override
  String get password_lost_incorrect_credentials =>
      'Questo indirizzo email o nome utente non esiste. Controlla le tue credenziali.';

  @override
  String get password_lost_server_unavailable =>
      'Al momento stiamo riscontrando rallentamenti sui nostri server e ce ne scusiamo. Per favore riprova più tardi.';

  @override
  String get login => 'Accedi';

  @override
  String get login_result_type_server_unreachable => 'Rete non raggiungibile';

  @override
  String get login_result_type_server_issue =>
      'Problema sul server. Riprova più tardi.';

  @override
  String get login_page_username_or_email =>
      'Inserire il nome utente o l\'email';

  @override
  String get login_page_password_error_empty => 'Inserire una password';

  @override
  String get create_account => 'Crea account';

  @override
  String get sign_in => 'Accedi';

  @override
  String get sign_in_mandatory =>
      'Per questa funzionalità è necessario accedere.';

  @override
  String get help_improve_country =>
      'Aiutaci a migliorare Open Food Facts nel tuo Paese';

  @override
  String get sign_out => 'Esci';

  @override
  String get sign_out_confirmation => 'Sei sicuro di voler uscire?';

  @override
  String get password => 'Password';

  @override
  String get forgot_password => 'Password dimenticata';

  @override
  String get forgot_password_question => 'Ha dimenticato la password?';

  @override
  String get view_profile => 'Visualizza il profilo';

  @override
  String get reset_password => 'Reimposta password';

  @override
  String get reset_password_explanation_text =>
      'Nel caso di una password dimenticata, inserisci il tuo nome utente o indirizzo email per ricevere istruzioni per un ripristino della password. Inoltre, ricorda di controllare la cartella dello Spam.';

  @override
  String get username_or_email => 'Nome utente o email';

  @override
  String get reset_password_done =>
      'Un\'email con un link per ripristinare la tua password è stata inviata all\'indirizzo email associato al tuo profilo. Inoltre, controlla il tuo spam';

  @override
  String get send_reset_password_mail => 'Modifica la password';

  @override
  String get enter_some_text => 'Sei pregato di inserire del testo';

  @override
  String get sign_up_page_title => 'Iscriviti';

  @override
  String get sign_up_page_action_button => 'Iscriviti';

  @override
  String get sign_up_page_action_doing_it => 'Registrazione…';

  @override
  String get sign_up_page_action_ok =>
      'Congratulazioni! Il tuo profilo è appena stato creato.';

  @override
  String get sign_up_page_display_name_hint => 'Nome';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Sei pregato di inserire il nome visualizzato che desideri usare';

  @override
  String get sign_up_page_email_hint => 'Email';

  @override
  String get sign_up_page_email_error_empty => 'L\'email è obbligatoria';

  @override
  String get sign_up_page_email_error_invalid => 'Email non valida';

  @override
  String get sign_up_page_username_hint =>
      'Nome utente: Visibile pubblicamente';

  @override
  String get sign_up_page_username_error_empty => 'Inserisci un nome utente';

  @override
  String get sign_up_page_username_error_invalid =>
      'Inserisci un nome utente valido';

  @override
  String get sign_up_page_username_description =>
      'Il nome utente non può contenere spazi, maiuscole o caratteri speciali.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Il nome utente non può superare $value caratteri';
  }

  @override
  String get sign_up_page_password_hint => 'Password';

  @override
  String get sign_up_page_password_error_empty =>
      'È necessario inserire una password';

  @override
  String get sign_up_page_password_error_invalid =>
      'Per favore inserisci una password valida (almeno 6 caratteri)';

  @override
  String get sign_up_page_confirm_password_hint => 'Ripeti la password';

  @override
  String get sign_up_page_confirm_password_error_empty => 'Ripeti la password';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Le password non corrispondono';

  @override
  String get sign_up_page_agree_text => 'Acconsento ai';

  @override
  String get sign_up_page_terms_text => 'contributo di Open Food Facts';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Creando un profilo, acconsentire ai Termini d\'Uso è obbligatorio, tuttavia, i contributi anonimi possono ancora esser eseguiti tramite l\'app';

  @override
  String get sign_up_page_producer_checkbox => 'Sono un produttore di alimenti';

  @override
  String get sign_up_page_producer_hint => 'Produttore/marca';

  @override
  String get sign_up_page_producer_error_empty =>
      'Per favore inserisci il nome di un produttore o di una marca';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Vorrei iscrivermi alla newsletter di Open Food facts (Puoi disiscriverti in qualsiasi momento)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Il nome utente esiste già, ti preghiamo di sceglierne un altro.';

  @override
  String get sign_up_page_email_already_exists =>
      'esiste già, accedi al profilo o prova con un\'altra email.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Ti preghiamo di fornire un indirizzo email valido.';

  @override
  String get sign_up_page_server_busy =>
      'Ci scusiamo profondamente, stiamo riscontrando delle difficoltà tecniche nella creazione del tuo account. Ti invitiamo a riprovare più tardi.';

  @override
  String get settingsTitle => 'Impostazioni';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Scuro';

  @override
  String get darkmode_light => 'Chiaro';

  @override
  String get darkmode_system_default => 'Predefinito di sistema';

  @override
  String get thanks_for_contributing => 'Grazie per aver contribuito!';

  @override
  String get contributors_label => 'Stanno costruendo l\'app';

  @override
  String get contributors_dialog_title => 'Contributori';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Contributore: $name';
  }

  @override
  String get contributors_description =>
      'Un elenco di tutti i contributori di questa app';

  @override
  String get support => 'Supporto';

  @override
  String get support_join_slack => 'Chiedi aiuto nel nostro canale di Slack';

  @override
  String get support_via_forum => 'Chiedi aiuto sul nostro forum';

  @override
  String get support_via_email => 'Inviaci un\'email';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Inviare i log dell\'app?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Desideri includere i log dell\'app in allegato alla tua e-mail?';

  @override
  String get termsOfUse => 'Condizioni d\'uso';

  @override
  String get legalNotices => 'Note legali';

  @override
  String get privacy_policy => 'Informativa sulla privacy';

  @override
  String get about_this_app => 'Su quest\'app';

  @override
  String get contribute => 'Contribuire';

  @override
  String get contribute_sw_development => 'Sviluppo software';

  @override
  String get contribute_develop_text =>
      'Il codice per qualsiasi prodotto di Open Food Facts è disponibile su GitHub. Puoi riutilizzare il codice (è open source) e aiutarci a migliorarlo, per tutti, su tutto il pianeta.';

  @override
  String get contribute_develop_text_2 =>
      'Puoi unirti alla chat room di Slack di Open Food Facts, il metodo preferito per fare domande.';

  @override
  String get contribute_develop_dev_mode_title => 'Modalità DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Attiva la Modalità DEV';

  @override
  String get contribute_donate_title => 'Effettua una donazione';

  @override
  String get contribute_donate_header => 'Dona a Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Ti preghiamo di tener presente che, con la versione alfa interna, è possibile la completa perdita dei dati, e che l\'app potrebbe diventare inutilizzabile in qualsiasi momento!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Prodotti da completare';

  @override
  String get contribute_improve_header => 'Aiuta';

  @override
  String get contribute_improve_text =>
      'Il database è il cuore del progetto. È facile e davvero rapido aiutare. Puoi scaricare l\'app mobile per il tuo telefono, e iniziare ad aggiungere o migliorare i prodotti.\n\nD\'altra parte, il sito web di Open Food Facts offre molti metodi per contribuire: ';

  @override
  String get contribute_translate_header => 'Traduci';

  @override
  String get contribute_data_quality => 'Qualità dei Dati';

  @override
  String get contribute_translate_link_text => 'Inizia a Tradurre';

  @override
  String get contribute_translate_text =>
      'Open Food Facts è un progetto globale, contenente prodotti per oltre 160 paesi. Open Food Facts è tradotto in dozzine di lingue, con contenuti in continua evoluzione.';

  @override
  String get contribute_translate_text_2 =>
      'Le traduzioni sono tra i compiti chiave del progetto';

  @override
  String get contribute_join_skill_pool =>
      'Contribuisci con le tue abilità a Open Food Facts. Unisciti al pool di abilità!';

  @override
  String get contribute_share_header =>
      'Condividi Open Food Facts con i tuoi amici';

  @override
  String get contribute_share_content =>
      'Volevo farti conoscere l\'app che sto utilizzando, Open Food Facts, che ti consente di ottenere la salute e gli impatti ambientali dei tuo alimenti, in un modo personalizzato. Funziona scansionando i codici a barre sull\'imballaggio. Infine, è gratuita, non richiede la registrazione e puoi persino aiutare a incrementare il numero di prodotti decifratii. Ecco il link per scaricarla sul tuo telefono: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribuisci ai prezzi richiedendo l\'esportazione GDPR dei dati delle tue carte fedeltà';

  @override
  String get tap_to_answer => 'Tocca qui per rispondere a delle domande';

  @override
  String get tap_to_answer_hint =>
      'Tocca qui per rispondere alle domande su questo prodotto';

  @override
  String get robotoff_questions_loading_hint =>
      'Per favore attendi durante il caricamento delle domande su questo prodotto';

  @override
  String get saving_answer => 'Salvataggio risposta';

  @override
  String get contribute_to_get_rewards =>
      'Diventa un attore della trasparenza alimentare';

  @override
  String get question_sign_in_text =>
      'Accedi al tuo profilo di Open Food Facts per ricevere credito per i tuoi contributi';

  @override
  String get question_yes_button_accessibility_value => 'Rispondi con sì';

  @override
  String get question_no_button_accessibility_value => 'Rispondi con no';

  @override
  String get question_skip_button_accessibility_value => 'Salta questa domanda';

  @override
  String get tap_to_edit_search => 'Tocca per modificare la ricerca';

  @override
  String get myPreferences => 'Le Mie preferenze';

  @override
  String get account_create_message =>
      'Crea il tuo profilo e unisciti alla community di Open Food Facts per aiutare a sviluppare la conoscenza alimentare in tutto il mondo!';

  @override
  String get join_us => 'Unisciti a noi';

  @override
  String get myPreferences_profile_title => 'Il Tuo Profilo';

  @override
  String get myPreferences_profile_subtitle =>
      'Gestisci il tuo profilo da collaboratore di Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Impostazioni dell\'App';

  @override
  String get myPreferences_settings_subtitle => 'Modalità scura, Lingue…';

  @override
  String get myPreferences_food_title => 'Preferenze Alimentari';

  @override
  String get myPreferences_food_subtitle =>
      'Scegli quali informazioni alimentari sono più importanti per te.';

  @override
  String get myPreferences_food_comment =>
      'Scegli quali informazoni alimentari ti importano di più, per poter classificare il cibo secondo le tue preferenze, visualizzare le informazioni che ti interessano di più e ottenere un riepilogo di compatibilità. Queste preferenze alimentari restano sul tuo dispositivo, e non sono associate al profilo da collaboratore di Open Food Facts, se ne possiedi uno.';

  @override
  String get confirmResetPreferences =>
      'Ripristinare le tue preferenze alimentari?';

  @override
  String get myPersonalizedRanking => 'La mia classifica personale';

  @override
  String get ranking_tab_all => 'Tutti';

  @override
  String get ranking_subtitle_match_yes => 'Una corrispondenza ottima per te';

  @override
  String get ranking_subtitle_match_no => 'Corrispondenza molto debole';

  @override
  String get ranking_subtitle_match_maybe => 'Corrispondenza sconosciuta';

  @override
  String get refresh_with_new_preferences =>
      'Aggiorna l\'elenco con le tue nuove preferenze';

  @override
  String get reloaded_with_new_preferences =>
      'Ricaricato con le nuove preferenze';

  @override
  String get profile_navbar_label => 'Comunità';

  @override
  String get scan_navbar_label => 'Analizza';

  @override
  String get history_navbar_label => 'Cronologia';

  @override
  String get list_navbar_label => 'Elenchi';

  @override
  String get category => 'Filtra per categoria';

  @override
  String get category_all => 'Tutti';

  @override
  String get category_search => '(ricerca per categoria)';

  @override
  String get filter => 'Filtra';

  @override
  String get scan => 'Prodotti dalla schermata Scansione';

  @override
  String get scan_history => 'Storico di scansione';

  @override
  String get search => 'Cerca';

  @override
  String get search_product_help =>
      'Cerca un prodotto,\nun marchio o un codice a barre';

  @override
  String get search_filter => 'Filtro di ricerca';

  @override
  String get search_history => 'Cronologia delle ricerche';

  @override
  String get search_store => 'Cerca un negozio';

  @override
  String get search_store_help => 'Suggerimento: aggiungi la città o il paese';

  @override
  String get tap_for_more => 'Tocca per visualizzare ulteriori informazioni…';

  @override
  String get product => 'Prodotto';

  @override
  String get unknownBrand => 'Marca sconosciuta';

  @override
  String get unknownQuantity => 'Quantità sconosciuta';

  @override
  String get unknownProductName => 'Nome del prodotto sconosciuto';

  @override
  String get label_refresh => 'Aggiorna';

  @override
  String get label_reload => 'Ricaricare';

  @override
  String get image => 'Immagine';

  @override
  String get front_photo => 'Foto frontale';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (questa immagine potrebbe essere obsoleta)';
  }

  @override
  String get outdated_image_short_label => 'potrebbe essere obsoleto';

  @override
  String get ingredients => 'Ingredienti';

  @override
  String get ingredients_editing_instructions =>
      'Mantenere l\'ordine originale. Indicare la percentuale quando specificato. Separare con una virgola o un trattino e utilizzare le parentesi per gli ingredienti di un ingrediente.';

  @override
  String get ingredients_editing_error =>
      'Impossibile salvare gli ingredienti.';

  @override
  String get ingredients_editing_image_error =>
      'Impossibile ottenere una nuova immagine degli ingredienti.';

  @override
  String get ingredients_editing_title => 'Modifica ingredienti';

  @override
  String get ingredients_photo => 'Foto degli ingredienti';

  @override
  String get packaging_editing_instructions =>
      'Elenca tutte le parti dell\'imballaggio separate da una virgola o vai a capo, con la loro quantità (es. 1 o 6), tipo (es. bottiglia, scatola, lattina), materiale (es. plastica, metallo, alluminio) e se disponibili le loro dimensioni (es. 33cl) e le istruzioni di riciclaggio.\nEsempio: 1 bottiglia in vetro da riciclare, 1 tappo in plastica da gettare';

  @override
  String get packaging_editing_error => 'Impossibile salvare la confezione.';

  @override
  String get packaging_editing_image_error =>
      'Impossibile ottenere una nuova immagine della confezione.';

  @override
  String get packaging_editing_title => 'Modifica imballaggio';

  @override
  String get nutrition => 'Nutrizione';

  @override
  String get nutrition_facts_photo => 'Foto valori nutrizionali';

  @override
  String get nutrition_facts_editing_title => 'Modifica i valori nutrizionali';

  @override
  String get packaging_information => 'Istruzioni per il riciclaggio';

  @override
  String get packaging_information_photo =>
      'Foto delle istruzioni di riciclaggio';

  @override
  String get missing_product => 'Hai trovato un nuovo prodotto!';

  @override
  String get add_product_take_photos =>
      'Scatta foto dell\'imballaggio per aggiungere questo prodotto a Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Si prega di prendere alcune foto prima. Si può sempre completare il prodotto in un secondo momento.';

  @override
  String get add_product_information_button_label =>
      'Aggiungi informazioni prodotto';

  @override
  String get new_product => 'Nuovo prodotto';

  @override
  String get new_product_found_title => 'Nuovo prodotto trovato!';

  @override
  String get new_product_found_text =>
      'Il nostro database collaborativo contiene più di **3 milioni di prodotti**, ma questo codice a barre non esiste: ';

  @override
  String get new_product_found_button => 'Aggiungi questo prodotto';

  @override
  String get new_product_leave_title => 'Lasciare questa pagina?';

  @override
  String get new_product_leave_message =>
      'Sembra che tu non abbia inserito nulla. Desideri davvero abbandonare questa pagina?';

  @override
  String get new_product_dialog_description =>
      'Si prega di scattare foto della confezione per aggiungere questo prodotto al nostro database comune';

  @override
  String get new_product_dialog_illustration_description =>
      'Un\'illustrazione con Nutri-Score e Punteggio Verde sconosciuti';

  @override
  String get front_packaging_photo_button_label => 'Foto frontale del prodotto';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Conferma il caricamento della foto frontale del Prodotto';

  @override
  String get confirm_button_label => 'Conferma';

  @override
  String get send_image_button_label => 'Invia immagine';

  @override
  String get crop_page_action_saving => 'Salvando l\'immagine…';

  @override
  String get crop_page_action_cropping => 'Ritagliando l\'immagine…';

  @override
  String get crop_page_action_local => 'Salvando una versione locale…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ops… c\'è qualche problema con la tua foto!';

  @override
  String get crop_page_action_local_failed_message =>
      'Non riusciamo a elaborare localmente l\'immagine, prima di inviarla al nostro server. Ti preghiamo di riprovare più tardi o di contattarci se il problema persiste.';

  @override
  String get crop_page_action_retake => 'Riprendi una foto';

  @override
  String get crop_page_too_small_image_title => 'L\'immagine è troppo piccola!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'La dimensione minima in pixel per il caricamento dell\'immagine è ${expectedMinWidth}x$expectedMinHeight. L\'immagine corrente è ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Preparando una chiamata al server…';

  @override
  String get front_packaging_photo_title => 'Foto dell\'Imballaggio Anteriore';

  @override
  String get ingredients_photo_title => 'Foto degli Ingredienti';

  @override
  String get nutritional_facts_photo_title => 'Foto valori nutrizionali';

  @override
  String get recycling_photo_title => 'Istruzioni per il riciclaggio Foto';

  @override
  String get take_photo_title => 'Scatta una foto';

  @override
  String get take_more_photo_title => 'Scatta più foto';

  @override
  String get front_photo_uploaded => 'Foto frontale caricata';

  @override
  String get ingredients_photo_button_label => 'Foto degli ingredienti';

  @override
  String get ingredients_photo_uploaded => 'Foto degli ingredienti caricata';

  @override
  String get nutrition_cache_loading_error =>
      'Impossibile caricare i nutrienti dalla cache';

  @override
  String get nutritional_facts_photo_button_label => 'Foto valori nutrizionali';

  @override
  String get nutritional_facts_input_button_label =>
      'Inserisci i valori nutrizionali';

  @override
  String get nutritional_facts_added => 'Valori nutrizionali aggiunti';

  @override
  String get categories_added => 'Categorie aggiunte';

  @override
  String get new_product_title_nutriscore => 'Calcola il Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Aiutaci compilando almeno una categoria e i valori nutrizionali';

  @override
  String get new_product_title_environmental_score =>
      'Calcola il punteggio verde';

  @override
  String get new_product_subtitle_environmental_score =>
      'Ottienilo compilando almeno una categoria';

  @override
  String get new_product_additional_environmental_score =>
      'Rendi il calcolo del punteggio verde più preciso con le origini, l\'imballaggio e altro ancora';

  @override
  String get new_product_title_nova =>
      'Calcola il livello di trasformazione alimentare (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Ottienilo compilando la categoria e gli ingredienti dell\'alimento';

  @override
  String get new_product_desc_nova_unknown =>
      'Livello di trasformazione alimentare sconosciuto';

  @override
  String get new_product_title_pictures => 'Nuovo prodotto';

  @override
  String get new_product_title_pictures_details =>
      'Scatta le seguenti foto e il motore di Open Food Facts farà il resto!';

  @override
  String get new_product_title_misc => 'E dei dati essenziali…';

  @override
  String new_product_done_msg(String username) {
    return 'Grazie per il tuo contributo “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Grazie per il tuo contributo!';

  @override
  String get new_product_done_button_label => 'Scopri il prodotto completo';

  @override
  String get hey_incomplete_product_message =>
      'Tocca per rispondere a 3 domande ORA per calcolare Nutri-Score, Punteggio Verde e Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Tocca ora per rispondere a 2 domande per aiutare ad analizzare questo cosmetico!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Tocca ora per rispondere a 3 domande per aiutare ad analizzare questo prodotto di alimenti per animali domestici!';

  @override
  String get hey_incomplete_product_message_product =>
      'Tocca ora per aiutare a completare questo prodotto!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Foto dei valori nutrizionali caricata';

  @override
  String get recycling_photo_button_label =>
      'Foto delle istruzioni di riciclaggio';

  @override
  String get recycling_photo_uploaded =>
      'Foto delle istruzioni di riciclaggio caricata';

  @override
  String get take_more_photo_button_label => 'Scatta più foto';

  @override
  String get other_photo_uploaded => 'Foto varie caricate';

  @override
  String get retake_photo_button_label => 'Ri-scatta';

  @override
  String get selecting_photo => 'Selezionando la foto';

  @override
  String get uploading_image => 'Caricamento della foto sul server';

  @override
  String get uploading_image_type_front =>
      'Caricamento dell\'immagine frontale su Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Caricamento dell\'immagine degli ingredienti su Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Caricamento dell\'immagine dei valori nutrizionali su Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Caricamento dell\'immagine dell\'imballaggio su Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Caricamento di un\'altra immagine su Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Caricamento di un\'immagine su Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Aggiungi gli ingredienti mancanti';

  @override
  String get score_add_missing_packaging_image =>
      'Aggiungi l\'immagine mancante dell\'imballaggio';

  @override
  String get score_add_missing_nutrition_facts =>
      'Aggiungi i valori nutrizionali mancanti';

  @override
  String get score_add_missing_product_traces =>
      'Aggiungi tracce di prodotto mancanti';

  @override
  String get score_add_missing_product_category => 'Seleziona una categoria';

  @override
  String get score_add_missing_precise_product_category =>
      'Seleziona una categoria più precisa';

  @override
  String get score_add_missing_product_countries =>
      'Aggiungi i paesi mancanti del prodotto';

  @override
  String get score_add_missing_product_emb =>
      'Aggiungi i codici di tracciabilità mancanti del prodotto';

  @override
  String get score_add_missing_product_labels =>
      'Aggiungi le etichette mancanti del prodotto';

  @override
  String get score_add_missing_product_origins =>
      'Aggiungi le origini mancanti del prodotto';

  @override
  String get score_add_missing_product_stores =>
      'Aggiungi i negozi mancanti del prodotto';

  @override
  String get score_add_missing_product_brands =>
      'Aggiungi le marche mancanti del prodotto';

  @override
  String get score_update_nutrition_facts => 'Aggiorna i valori nutrizionali';

  @override
  String get nutrition_page_title => 'Informazioni nutrizionali';

  @override
  String get nutrition_page_nutritional_info_title =>
      'Informazioni nutrizionali';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Valori specificati sul prodotto:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Sì';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'No';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Apri la foto';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Buone pratiche: informazioni nutrizionali';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'A volte i valori nutrizionali **non sono specificati sulla confezione** o su un documento fornito con il prodotto. In questo caso, e solo in questo caso, è possibile impostare il valore su **NO**.';

  @override
  String get nutrition_page_serving_type_label => 'Valori nutrizionali:';

  @override
  String get nutrition_page_per_100g => 'per 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'per 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'per porzione';

  @override
  String get nutrition_page_add_nutrient => 'Aggiungi un nutriente';

  @override
  String get nutrition_page_serving_size => 'Porzione';

  @override
  String get nutrition_page_serving_size_hint =>
      'Inserisci una porzione (ad esempio: 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Buone pratiche: Porzione';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Questo valore aiuta a **effettuare un calcolo proporzionale di ciascun nutriente per porzione**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Le unità consentite** sono: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** o **60 G** (preferisco il primo)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** o **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Unità non valida';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Unità non valide';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **caramelle** e 2 **biscotti**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Unità mancante';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Numero non valido';

  @override
  String get nutrition_page_update_running =>
      'Caricando il prodotto sul server…';

  @override
  String get nutrition_page_update_done => 'Prodotto aggiornato!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Utilizzare la quantità del prodotto come dimensione di servizio';

  @override
  String get nutrition_page_photo_error => 'Impossibile caricare la foto';

  @override
  String get more_photos => 'Altre foto che potrebbero interessarti';

  @override
  String get view_more_photo_button =>
      'Visualizza tutte le foto esistenti per questo prodotto';

  @override
  String get no_product_found => 'Nessun prodotto trovato';

  @override
  String get no_location_found => 'Nessuna posizione individuata';

  @override
  String get not_found => 'non trovato:';

  @override
  String get refreshing_product => 'Aggiornamento prodotto';

  @override
  String get product_refreshed => 'Prodotto aggiornato';

  @override
  String product_image_accessibility_label(String date) {
    return 'Immagine acquisita in data $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Immagine acquisita in data $date. Questa immagine potrebbe essere obsoleta';
  }

  @override
  String get product_image_outdated =>
      'Questa immagine potrebbe essere obsoleta';

  @override
  String get product_image_outdated_explanations_title =>
      'Questa immagine potrebbe essere obsoleta';

  @override
  String get product_image_outdated_explanations_content =>
      'Questa immagine è stata scattata più di un anno fa.\n**Controlla che sia ancora aggiornata**.\n\nQuesto è **solo un avviso**. Se il contenuto è ancora lo stesso, puoi ignorare questo messaggio.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Sostituisci foto ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Aggiungi una foto ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Scatta una nuova foto';

  @override
  String get product_image_action_take_picture => 'Scatta una foto';

  @override
  String get product_image_action_from_gallery =>
      'Seleziona dalla galleria del tuo telefono';

  @override
  String get product_image_action_choose_existing_photo =>
      'Seleziona dalle foto del prodotto';

  @override
  String get product_image_details_label => 'Informazioni sulla foto';

  @override
  String get product_image_details_from_producer => 'Dal produttore';

  @override
  String get product_image_details_contributor => 'Collaboratori';

  @override
  String get product_image_details_contributor_producer =>
      'Collaboratore (produttore)';

  @override
  String get product_image_details_date => 'Data';

  @override
  String get product_image_details_date_unknown => 'Sconosciuto';

  @override
  String get homepage_main_card_logo_description =>
      'Benvenuti in Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Scansiona** un codice a barre o\n**cerca** un prodotto';

  @override
  String get homepage_main_card_search_field_hint => 'Cerca un prodotto';

  @override
  String get homepage_main_card_search_field_tooltip => 'Inizia la ricerca';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Ultime notizie: $news_title';
  }

  @override
  String get tagline_app_review => 'Ti piace l\'app?';

  @override
  String get tagline_app_review_button_positive => 'La adoro! 😍';

  @override
  String get tagline_app_review_button_negative => 'Non proprio…';

  @override
  String get tagline_app_review_button_later => 'Chiedimelo più tardi';

  @override
  String get tagline_feed_news_button => 'Scopri di più';

  @override
  String get app_review_negative_modal_title => 'Non ti piace la nostra app?';

  @override
  String get app_review_negative_modal_text =>
      'Potrebbe dedicarci qualche secondo per dirci perché?';

  @override
  String get app_review_negative_modal_positive_button => 'Sì, assolutamente!';

  @override
  String get app_review_negative_modal_negative_button => 'No';

  @override
  String get could_not_refresh => 'Impossibile aggiornare il prodotto';

  @override
  String get product_internet_error_modal_title => 'Si è verificato un errore!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Non siamo in grado di recuperare informazioni su questo prodotto a causa di un errore di rete. Controlla la tua connessione internet e riprova.\n\nErrore interno:\n$error';
  }

  @override
  String get product_tags_title => 'Proprietà prodotto';

  @override
  String get no_product_tags_found_message =>
      'Nessuna proprietà del prodotto trovata. Le proprietà possono essere usate per descrivere i prodotti in modo più dettagliato, in modo flessibile. Tocca per aggiungere.';

  @override
  String get product_tags_empty => 'Nessuna proprietà';

  @override
  String get product_tags_explanation =>
      'Aggiungendo proprietà (chiave/valore) a un prodotto, contribuisci ad arricchirlo.';

  @override
  String get add_tag => 'Aggiungi proprietà';

  @override
  String get add_tags => 'Aggiungi proprietà';

  @override
  String get add_edit_tags => 'Aggiungi o modifica proprietà';

  @override
  String get edit_tag => 'Modifica proprietà';

  @override
  String get remove_tag => 'Rimuovi proprietà';

  @override
  String get tag_key => 'Proprietà';

  @override
  String get tag_keys => 'Proprietà';

  @override
  String get tag_key_uneditable => 'Proprietà (non modificabile)';

  @override
  String get tag_key_input_hint => 'Inserisci una proprietà';

  @override
  String get tag_value => 'Valore';

  @override
  String get tag_values => 'Valori';

  @override
  String get tag_value_input_hint => 'Inserisci un valore';

  @override
  String get tag_key_item => 'Proprietà:';

  @override
  String get tag_value_item => 'Valore:';

  @override
  String get tag_key_explanations =>
      'Il nome di una proprietà (key) deve essere scritta in minuscolo e senza spazi.';

  @override
  String tag_key_already_exists(String property) {
    return 'Esiste già un tag con proprietà $property !';
  }

  @override
  String get product_internet_error =>
      'Impossibile recuperare le informazioni su questo prodotto a causa di un errore di rete.';

  @override
  String get cached_results_from => 'Mostra i risultati da:';

  @override
  String get product_search_same_category => 'Trova alternative';

  @override
  String get product_search_same_category_short => 'Confronta';

  @override
  String get product_search_same_category_error =>
      'Questa funzione può essere utilizzata solo per i prodotti con una categoria.\n\nSi prega di modificare il prodotto per aggiungere una categoria.';

  @override
  String get product_improvement_add_category =>
      'Aggiungi una categoria per calcolare il Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Aggiungi i valori nutrizionali per calcolare il Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Aggiungi i valori nutrizionali e una categoria per calcolare il Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Il Nutri-Score per questo prodotto non può essere calcolato, il che potrebbe dipendere da ad es. una categoria non standard. Se consideri questo un errore, per favore contattaci.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'L\'immagine nutrizionale è obsoleta: per favore aggiornala.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Il Green Score tiene conto delle origini degli ingredienti. Si prega di scattare una foto della lista degli ingredienti e/o di qualsiasi rivendicazione geografica o modificare il prodotto, in modo che possano essere presi in considerazione.';

  @override
  String get country_chooser_label => 'Scegli un Paese';

  @override
  String get currency_chooser_label => 'Scegli una valuta';

  @override
  String get country_change_message => 'Hai appena cambiato Paese.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Vuoi cambiare la valuta da $previousCurrency a $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label =>
      'Ti preghiamo di scegliere un paese:';

  @override
  String get country_chooser_label_from_settings => 'Il tuo paese';

  @override
  String get country_selection_explanation =>
      'Alcune caratteristiche ambientali sono specifiche alla posizione';

  @override
  String get product_removed_comparison => 'Prodotti rimosso dal confronto';

  @override
  String get native_app_settings => 'Impostazioni native dell\'App';

  @override
  String get native_app_description =>
      'Apri le impostazioni di sistema per Open Food Facts';

  @override
  String get product_removed_history => 'Prodotto rimosso dalla cronologia';

  @override
  String get product_removed_list => 'Prodotto rimosso dall\'elenco';

  @override
  String get product_could_not_remove => 'Impossibile rimuovere il prodotto';

  @override
  String get no_prodcut_in_list => 'Non ci sono prodotti nella tua lista.';

  @override
  String get no_product_in_section => 'Non ci sono prodotti in questa sezione';

  @override
  String get recently_seen_products => 'Tutti i prodotti visualizzati';

  @override
  String get clear => 'Cancella';

  @override
  String get clear_long => 'Svuota la lista';

  @override
  String get really_clear => 'Desideri davvero eliminare questa lista?';

  @override
  String pct_match(Object percent) {
    return 'Corrispondenza al $percent%';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count giorni fa',
      one: 'un giorno fa',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ore fa',
      one: 'un\'ora fa',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minuti fa',
      one: 'un minuto fa',
      zero: 'meno di un minuto fa',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count mesi fa',
      one: 'un mese fa',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count settimane fa',
      one: 'una settimana fa',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Confronta $count Prodotti',
      one: 'Confronta con un Prodotto',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prodotti selezionati',
      one: 'Un prodotto selezionato',
      zero: 'Nessun prodotto selezionato',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Confronta i prodotti selezionati';

  @override
  String get delete_products_mode => 'Elimina i prodotti selezionati';

  @override
  String get select_all_products_mode => 'Seleziona tutti i prodotti';

  @override
  String get select_none_products_mode => 'Seleziona nessuno';

  @override
  String get compare_products_appbar_title => 'Compara i prodotti';

  @override
  String get compare_products_appbar_subtitle =>
      'Selezionare almeno due prodotti';

  @override
  String get retry_button_label => 'Riprova';

  @override
  String get connect_with_us => 'Connettiti con noi';

  @override
  String get tiktok => 'Seguici su TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Seguici su Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Seguici su X (ex Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Seguici su Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Seguici su BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => 'Scopri';

  @override
  String get how_to_contribute => 'Come contribuire';

  @override
  String get hint_knowledge_panel_message =>
      'Puoi toccare su qualsiasi parte della scheda per ottenere ulteriori dettagli su ciò che vedi. Provaci adesso!';

  @override
  String get permissions_page_title => 'Accesso alla fotocamera';

  @override
  String get permissions_page_body1 =>
      'Per scansionare i codici a barre con la fotocamera del tuo telefono, sei pregato di Autorizzare l\'accesso.';

  @override
  String get permissions_page_body2 =>
      'Se cambi idea, quest\'opzione può essere abilitata e disabilitata in qualsiasi momento dalle impostazioni.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (Int SDK: $sdkInt / Release: $release)\nModello: $model\nProdotto: $product\nDispositivo: $device\nMarca:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModello: $model\nModello localizzato: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVersione app:$appVersion\nNumero build app:$appBuildNumber\nNome pacchetto app:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Autorizza';

  @override
  String get refuse_button_label => 'Rifiuta';

  @override
  String get ask_me_later_button_label => 'In seguito';

  @override
  String get are_you_sure => 'Sei sicuro?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Prosegui su $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Benvenuto !';

  @override
  String get onboarding_home_welcome_text2 =>
      'L\'app che ti aiuta a scegliere il cibo che fa bene a **te** e al **pianeta**!';

  @override
  String get onboarding_continue_button => 'Continua';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Caricamento del tuo primo prodotto d\'esempio';

  @override
  String get onboarding_welcome_warning =>
      'Spiacenti, è il nostro prodotto di esempio, non puoi modificarlo :)';

  @override
  String get product_list_your_ranking => 'La tua posizione';

  @override
  String get product_list_empty_icon_desc => 'Cronologia non disponibile';

  @override
  String get product_list_empty_title => 'Inizia a scansionare';

  @override
  String get product_list_empty_message =>
      'I prodotti scansionati appariranno qui e potrai controllare le informazioni dettagliate su di essi';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'prodotti',
      one: 'prodotto',
      zero: 'prodotto',
    );
    return 'Aggiornando $_temp0 nella tua cronologia';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Prodotti',
      one: 'Prodotto',
      zero: 'Prodotto',
    );
    return 'Aggiornamento di $_temp0 completato';
  }

  @override
  String get product_list_compare_side_by_side => 'Confronta fianco a fianco';

  @override
  String get loading_dialog_default_title => 'Scaricamento dati';

  @override
  String get loading_dialog_default_error_message =>
      'Impossibile scaricare i dati';

  @override
  String get account_delete => 'Elimina account';

  @override
  String get account_delete_title => 'Elimina il mio account';

  @override
  String get user_profile => 'Profilo';

  @override
  String get user_profile_title_guest => 'Benvenuto/a!';

  @override
  String get user_profile_subtitle_guest =>
      'Accedi o iscriviti per unirti alla community di Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Accesso di Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Benvenuto $id!';
  }

  @override
  String get email_subject_account_deletion => 'Elimina account';

  @override
  String email_body_account_deletion(String userId) {
    return 'Salve, siete pregati di eliminare il mio profilo di Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Applicazione';

  @override
  String get settings_app_data => 'Privacy & monitoraggio';

  @override
  String get settings_app_camera => 'Fotocamera';

  @override
  String get settings_app_products => 'Prodotti';

  @override
  String get settings_app_miscellaneous => 'Varie';

  @override
  String get camera_play_sound_title =>
      'Riproduci un suono durante la scansione';

  @override
  String get camera_play_sound_subtitle =>
      'Emette un segnale acustico ad ogni scansione riuscita';

  @override
  String get camera_window_accessibility_label =>
      'Scansiona un codice a barre con la tua fotocamera';

  @override
  String get app_haptic_feedback_title => 'Vibrazione e sensazioni tattili';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrazioni dopo l\'esecuzione di certe azioni (codice a barre rilevato, prodotto rimosso…).';

  @override
  String get crash_reporting_toggle_title => 'Segnalazione di arresti anomali';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Quando abilitato, i rapporti sugli arresti anomali vengono inviati automaticamente al sistema di monitoraggio degli errori di Open Food Facts, così che i bug possano essere risolti e dunque che l\'app possa essere migliorata.';

  @override
  String get send_anonymous_data_toggle_title => 'Invia dati anonimi';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Quando abilitato, alcune informazioni anonime relative all\'utilizzo dell\'app saranno inviate ai server di Open Food Facts, in modo che possiamo comprendere come e quante funzionalità vengono utilizzate, così da migliorarle.';

  @override
  String get product_edit_photo_title => 'Modifica Foto';

  @override
  String get permission_photo_error => 'Errore';

  @override
  String get permission_photo_denied_title =>
      'Consenti l\'uso della fotocamera per scansionare i codici a barre';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Per un\'esperienza migliore, consenti a $appName di accedere alla tua fotocamera. Potrai scansionare direttamente i codici a barre.';
  }

  @override
  String get permission_photo_denied_button => 'Consenti';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Permesso negato';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Poiché, in precedenza, hai negato l\'autorizzazione alla fotocamera, devi consentirla manualmente dalle Impostazioni.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Apri impostazioni';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Annulla';

  @override
  String get permission_photo_none_found => 'Nessuna fotocamera rilevata';

  @override
  String get permission_photo_denied =>
      'Nessun accesso alla telecamera concesso';

  @override
  String get show_product_pictures => 'Mostra immagini prodotto';

  @override
  String get edit_product_label => 'Modifica il prodotto';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Caricamento delle modifiche…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'L\'invio delle modifiche **avviene in background** (o più tardi in caso di errore)\nPuoi continuare a modificare altri campi del prodotto.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Le tue modifiche verranno **inviate in background** (o successivamente in caso di errore).';

  @override
  String get edit_product_label_short => 'Modifica';

  @override
  String edit_product_form_item_help(String value) {
    return 'Come inserire \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Inserisci un valore non vuoto!';

  @override
  String get edit_product_form_item_error_existing =>
      'Questo valore esiste già!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Aggiungi una nuova marca';

  @override
  String get edit_product_form_item_add_action_label =>
      'Aggiungi nuova etichetta';

  @override
  String get edit_product_form_item_add_action_store =>
      'Aggiungi un nuovo negozio';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Aggiungi una nuova origine';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Aggiungi un nuovo codice di tracciabilità';

  @override
  String get edit_product_form_item_add_action_country =>
      'Aggiungi un nuovo Paese';

  @override
  String get edit_product_form_item_add_action_category =>
      'Aggiungi una nuova categoria';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Aggiungi una nuova traccia';

  @override
  String get edit_product_form_item_add_suggestion => 'Aggiungi suggerimento';

  @override
  String get edit_product_form_item_deny_suggestion => 'Rifiuta suggerimento';

  @override
  String get edit_product_form_item_details_title => 'Informazioni base';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Nome prodotto, marca, quantità';

  @override
  String get edit_product_form_item_other_details_title => 'Ulteriori dettagli';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Sito web…';

  @override
  String get edit_product_form_item_photos_title => 'Foto';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Aggiungi o aggiorna le foto';

  @override
  String get edit_product_form_item_labels_title =>
      'Etichette e Certificazioni';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Etiichette ambientali, di qualità…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Inserisci un\'etichetta (ad esempio: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'etichetta';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Buone pratiche: Etichette';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Qualsiasi caratteristica del prodotto **che sia fattuale** e diversa dagli altri campi.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Punteggio Nutrizionale, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Prodotto in Belgio, prodotto in Bretagna…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Ricco di fibre, fonte di ferro…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Commercio equo e solidale, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Negozi';

  @override
  String get edit_product_form_item_stores_hint => 'Inserisci un negozio';

  @override
  String get edit_product_form_item_stores_type => 'negozio';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Buone pratiche: Negozi';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Inserisci il negozio in cui hai acquistato il prodotto.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Origini';

  @override
  String get edit_product_form_item_origins_hint =>
      'Inserisci un\'origine (es.: Germania)';

  @override
  String get edit_product_form_item_origins_type => 'paese';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Buone pratiche: Origini';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Aggiungi **qualsiasi indicazione di origine che puoi trovare sulla confezione**.\nNon devi preoccuparti delle origini indicate direttamente nell\'elenco degli ingredienti.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Carne di manzo argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'La soia non proviene dall\'Unione Europea';

  @override
  String get edit_product_form_item_countries_title => 'Paese';

  @override
  String get edit_product_form_item_countries_hint =>
      'Inserisci un paese (ad esempio: Germania)';

  @override
  String get edit_product_form_item_countries_type => 'paese';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Buone pratiche: Paesi';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Paesi in cui il prodotto è ampiamente disponibile** (esclusi i negozi specializzati in prodotti esteri).';

  @override
  String get edit_product_form_item_emb_codes_title =>
      'Codici di tracciabilità';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Inserisci un codice (es: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'codice di tracciabilità';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Buone pratiche: Codici di tracciabilità';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'In questa sezione è possibile inserire codici relativi a **marchi di imballaggio**, **marchi di identificazione** o **marchi sanitari**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Esempi di codici di tracciabilità';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Codici CE** utilizzati nella Comunità Europea per identificare i produttori o i confezionatori di alimenti:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: codice paese della **Francia**\n**72.264.002**: dati geografici\n**CE**: Comunità Europea';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Codici EMB** utilizzati in Francia:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Tracce';

  @override
  String get edit_product_form_item_traces_hint => 'traccia';

  @override
  String get edit_product_form_item_traces_type =>
      'Inserisci una traccia (ad esempio: semi di soia)';

  @override
  String get edit_product_form_item_categories_title => 'Categorie';

  @override
  String get edit_product_form_item_categories_hint => 'categoria';

  @override
  String get edit_product_form_item_categories_type =>
      'Inserisci una categoria (es.: succo d\'arancia)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Buone pratiche: Categorie';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indica **solo la categoria più specifica**.\nLe categorie padre verranno aggiunte automaticamente.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Categoria mancante?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Se una categoria **non è disponibile nel completamento automatico**, sentiti libero di aggiungerla comunque.\nQuesto ci aiuterà a migliorare Open Food Facts nel tuo Paese.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardine in olio d\'oliva';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Succo d\'arancia da concentrato';

  @override
  String get edit_product_form_item_exit_title => 'Uscire senza salvare?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Salvare le modifiche prima di lasciare questa pagina?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Salva le modifiche';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Scarta le modifiche';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredienti';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Ingrandisci e rimpicciolisci pizzicando con due dita';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Ingrandisci e rimpicciolisci la foto';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Utilizzando il **gesto di pizzicamento per ingrandire**, puoi ingrandire o ridurre la foto:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Aggiungi';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Per favore inserisci prima un testo';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Rimuovi';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Salva la modifica';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Annulla la modifica';

  @override
  String get edit_product_form_item_packaging_title =>
      'Foto delle istruzioni di riciclaggio';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Valori nutrizionali';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Nutrizione, gradazione alcolica…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Buone pratiche: Informazioni nutrizionali';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Valori nutrizionali';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Per prima cosa, seleziona se **sono forniti i valori**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Valori nutrizionali';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Quindi, inserisci i valori nutrizionali **come indicati sulla confezione**. Se non sono presenti valori, puoi cliccare sull\'icona \"Occhio\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Campo mancante?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Se manca una voce, puoi **cliccare sull\'icona \"Più\"** per aggiungerla (ad esempio: vitamina D, magnesio…).';

  @override
  String get edit_product_form_save => 'Modifica';

  @override
  String get edit_product_ingredients_photo_title => 'Foto degli ingredienti';

  @override
  String get edit_product_ingredients_list_title => 'Lista degli ingredienti';

  @override
  String get edit_product_packaging_photo_title => 'Foto dell\'imballaggio';

  @override
  String get edit_product_packaging_list_title => 'Parti dell\'imballaggio';

  @override
  String get no_data_available => 'Nessun dato disponibile';

  @override
  String get product_field_website_title => 'Sito web';

  @override
  String get origins_editing_title => 'Modifica Origini';

  @override
  String get completed_basic_details_btn_text => 'Completa i dettagli di base';

  @override
  String get not_implemented_snackbar_text => 'Non ancora implementato';

  @override
  String get category_picker_page_appbar_text => 'Categorie';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Estrai gli ingredienti dalla foto';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Estrai ingredienti';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Estrazione degli ingredienti\ndalla foto';

  @override
  String get edit_ingredients_loading_photo_btn_text =>
      'Caricamento della foto…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Perché vedo questo messaggio?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Per utilizzare la funzionalità \"Estrai ingredienti\", è necessario prima caricare la foto.\n\nAttendi qualche secondo o inserisci gli ingredienti manualmente.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Aggiorna foto';

  @override
  String get edit_packaging_extract_btn_text =>
      'Estrai la confezione\ndalla foto';

  @override
  String get edit_packaging_extract_btn_text_short =>
      'Estrai informazioni imballaggio';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Estrazione della confezione dalla foto';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Caricamento della foto…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Perché vedo questo messaggio?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Per utilizzare la funzionalità \"Estrai confezioni\", è necessario prima caricare la foto.\n\nAttendi qualche secondo o inserisci le parti della confezione manualmente.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Aggiorna foto';

  @override
  String get edit_ocr_extract_failed =>
      'Impossibile rilevare del testo nell\'immagine.';

  @override
  String get edit_ocr_extract_disabled_title => 'Nessuna immagine';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Per poter utilizzare la funzione di estrazione del testo, è necessario scattare una foto.';

  @override
  String get user_list_dialog_new_title => 'Nuovo elenco di prodotti';

  @override
  String get user_list_dialog_rename_title => 'Rinomina lista';

  @override
  String get user_list_subtitle_product => 'Elenchi';

  @override
  String get user_list_title => 'Le tue liste';

  @override
  String get user_list_add_product => 'Aggiungi il prodotto alle tue liste';

  @override
  String get user_list_button_new => 'Crea una nuova lista';

  @override
  String get user_list_empty_label =>
      'Nessuna lista ancora disponibile, inizia creandone una';

  @override
  String get user_list_button_add_product => 'Aggiungi alla lista';

  @override
  String get added_to_list_msg => 'Aggiunti all\'elenco';

  @override
  String get user_list_popup_clear => 'Cancella la tua cronologia';

  @override
  String get user_list_popup_rename => 'Rinomina';

  @override
  String get user_list_name_hint => 'La mia lista';

  @override
  String get user_list_name_error_empty => 'Il nome è obbligatorio';

  @override
  String get user_list_name_error_already => 'Questo nome è già in uso';

  @override
  String get user_list_name_error_same => 'Questo è lo stesso nome';

  @override
  String get user_list_name_input_hint => 'Nome dell\'elenco';

  @override
  String get try_again => 'Riprovare';

  @override
  String get there_was_an_error => 'Si è verificato un errore';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Nessuna categoria trovata per $items';
  }

  @override
  String get camera_toggle_camera =>
      'Passa alla telecamera posteriore o anteriore';

  @override
  String get camera_toggle_flash =>
      'ATTIVA o DISATTIVA il flash della fotocamera';

  @override
  String get camera_enable_flash => 'Abilita flash';

  @override
  String get camera_disable_flash => 'Disabilita flash';

  @override
  String get camera_flash_error_dialog_title => 'Si è verificato un errore!';

  @override
  String get camera_flash_error_dialog_message =>
      'Si è verificato un errore modificando lo stato del tuo flash. Ti preghiamo di assicurarti che il tuo smartphone non abbia già la torcia abilitata.';

  @override
  String get category_picker_no_category_found_button => 'Indietro';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Fare clic per aprire nel browser o nell\'applicazione (se installata)';

  @override
  String get dev_preferences_screen_title => 'Modalità sviluppatore';

  @override
  String get dev_preferences_screen_subtitle =>
      'Accedi a funzionalità sperimentali e strumenti di sviluppo';

  @override
  String get dev_preferences_reset_onboarding_title => 'Riavvia accesso';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Quindi, devi riavviare l\'app per vederla nuovamente.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Passa tra openfoodfacts.org (PROD) e test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Prova i parametri dell\'ambiente';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL di base per l\'ambiente di test corrente: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Prova l\'ambiente ospite';

  @override
  String get dev_preferences_ml_kit_title => 'Usa Kit ML';

  @override
  String get dev_preferences_ml_kit_subtitle => 'devi poi riavviare quest\'app';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Pulsante aggiuntivo sulla pagina del prodotto';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Modifica gli ingredienti tramite un pulsante del pannello conoscenze';

  @override
  String get dev_preferences_export_history_title => 'Esporta Cronologia';

  @override
  String get dev_preferences_export_history_progress_error => 'eccezione';

  @override
  String get dev_preferences_export_history_progress_found =>
      'prodotto trovato';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'prodotto NON trovato';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Esporta cronologia';

  @override
  String get dev_preferences_button_positive => 'Ok';

  @override
  String get dev_preferences_button_negative => 'Annulla';

  @override
  String get dev_preferences_migration_title => 'Migrazione dei dati da V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Stato: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'successo o nuova installazione';

  @override
  String get dev_preferences_migration_status_success => 'riuscito';

  @override
  String get dev_preferences_migration_status_error => 'errore';

  @override
  String get dev_preferences_migration_status_in_progress => 'in corso';

  @override
  String get dev_preferences_migration_status_required =>
      'richiesto (clicca per iniziare)';

  @override
  String get dev_preferences_migration_status_not_started => 'sconosciuto';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Cancellerà la cronologia e inserirà 3 prodotti qui';

  @override
  String get dev_preferences_news_custom_url_title =>
      'URL personalizzato per le notizie';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL del file JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Non specificato';

  @override
  String get dev_preferences_news_provider_status_title => 'Stato';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Ultimo aggiornamento: $date';
  }

  @override
  String get product_type_label_food => 'Cibo';

  @override
  String get product_type_label_beauty => 'Cura personale';

  @override
  String get product_type_label_pet_food => 'Cibo per animali domestici';

  @override
  String get product_type_label_product => 'Altro';

  @override
  String get product_type_selection_title => 'Tipo di prodotto';

  @override
  String get product_type_selection_subtitle =>
      'Seleziona il tipo di questo prodotto';

  @override
  String get product_type_selection_empty =>
      'Devi prima selezionare un tipo di prodotto!';

  @override
  String product_type_selection_already(String productType) {
    return 'Non puoi cambiare il tipo di prodotto ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Collegamento all\'app Prezzi sulla pagina del prodotto';

  @override
  String get prices_app_button => 'Vai all\'app Prezzi';

  @override
  String get prices_website_button => 'Apri sul sito Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Aggiungi i cartellini dei prezzi direttamente dalla galleria';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Una volta selezionate le immagini, non potrai più modificarle!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'L\'intelligenza artificiale utilizzerà le tue prove per estrarre i prezzi.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Consenti alla comunità di convalidare i prezzi estratti dall\'IA.';

  @override
  String get prices_bulk_proof_upload_subtitle =>
      'Etichette di prezzo multiple';

  @override
  String get prices_bulk_proof_upload_title => 'Caricamento di bozze in blocco';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Selezione dei file';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Avvio del caricamento';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Copia locale del file #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Preparazione del caricamento #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Errore nell\'immagine #$index/$count';
  }

  @override
  String get prices_generic_title => 'Prezzi';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Aggiungi $count prezzi',
      one: 'Aggiungi un prezzo',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Invia $count prezzi',
      one: 'Invia il prezzo',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Aggiungi un elemento';

  @override
  String get prices_add_a_price => 'Aggiungi un prezzo';

  @override
  String get prices_add_a_receipt => 'Aggiungi una ricevuta';

  @override
  String get prices_add_price_tags => 'Aggiungi prezzi';

  @override
  String prices_barcode_already(String barcode) {
    return 'Questo codice a barre ($barcode) è già nell\'elenco!';
  }

  @override
  String get prices_barcode_search_not_found => 'Prodotto non trovato';

  @override
  String get prices_barcode_search_none_yet => 'Ancora nessun prodotto';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Ricerca del codice a barre $barcode';
  }

  @override
  String get prices_barcode_enter => 'Inserisci il codice a barre';

  @override
  String get prices_category_enter => 'Articolo senza codice a barre';

  @override
  String get prices_per_kilogram => 'Prezzo al chilogrammo';

  @override
  String get prices_per_unit => 'Prezzo unitario';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / unità';

  @override
  String get prices_category_mandatory => 'Obbligatorio';

  @override
  String get prices_category_optional => 'Opzionale';

  @override
  String get prices_category_error_mandatory => 'La categoria è obbligatoria';

  @override
  String get prices_barcode_reader_action => 'Lettore del codice a barre';

  @override
  String get prices_view_prices => 'Guarda i prezzi';

  @override
  String get prices_list_title => 'Listino prezzi';

  @override
  String get prices_list_count => 'Numero di prezzi\n';

  @override
  String get prices_list_add_new_price => 'Aggiungi un nuovo prezzo di\n';

  @override
  String get prices_list_empty_title => 'Nessun prezzo ancora!';

  @override
  String get prices_list_empty_subtitle =>
      'Sii il primo ad aggiungerne uno:\nScansionando una **scontrino** o un **cartellino del prezzo**!';

  @override
  String get prices_entry_shop_not_found => 'Negozio sconosciuto';

  @override
  String prices_entry_menu_title(String user) {
    return 'Inserimento prezzo da \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Visualizza tutti i prezzi per questo prodotto';

  @override
  String get prices_entry_menu_open_proof => 'Visualizza la prova';

  @override
  String get prices_entry_menu_my_prices => 'Visualizza i miei altri prezzi';

  @override
  String get prices_entry_menu_author_prices =>
      'Visualizza altri prezzi dell\'autore';

  @override
  String get prices_entry_menu_shop_prices =>
      'Visualizza altri prezzi dal negozio';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prezzi',
      one: '1 prezzo',
    );
    return '$_temp0 per $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tutti e $count i prezzi',
      one: 'Solo un prezzo',
      zero: 'Ancora nessun prezzo',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Ultimi $pageSize prezzi (totale: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Prezzo: $price / Negozio: \"$location\" / Pubblicato il $date da \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Apri le prove di \"$user\"';
  }

  @override
  String get prices_open_proof => 'Apri la prova del prezzo';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tutte e $count le prove',
      one: 'Solo una prova',
      zero: 'Ancora nessuna prova',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Ultime $pageSize prove (totale: $total)';
  }

  @override
  String get prices_users_empty_title => 'Nessun collaboratore ancora!';

  @override
  String get prices_users_empty_explanation =>
      'Sii il primo ad aggiungere un prezzo!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Principali $pageSize contributori (totali: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Nessun negozio ancora!';

  @override
  String get prices_locations_empty_explanation =>
      'Sii il primo ad aggiungere un prezzo!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Principali posizioni $pageSize (totale: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prove',
      one: 'Una prova',
      zero: 'Nessuna prova',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prodotti',
      one: 'Un prodotto',
      zero: 'Nessun prodotto',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count utenti',
      one: 'Un utente',
      zero: 'Nessun utente',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prezzi',
      one: 'Un prezzo',
      zero: 'Nessun prezzo',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Prezzo aggiunto in precedenza';

  @override
  String get prices_amount_subtitle => 'Quantità';

  @override
  String get prices_amount_is_discounted => 'È scontato?';

  @override
  String get prices_amount_price_normal => 'Prezzo';

  @override
  String get prices_amount_price_discounted => 'Prezzo scontato';

  @override
  String get prices_amount_price_not_discounted => 'Prezzo originale';

  @override
  String get prices_amount_no_product => 'Manca un prodotto!';

  @override
  String get prices_amount_price_incorrect => 'Valore non corretto';

  @override
  String get prices_amount_price_mandatory => 'Valore obbligatorio';

  @override
  String get prices_currency_subtitle => 'Moneta';

  @override
  String get prices_date_subtitle => 'Data';

  @override
  String get prices_location_subtitle => 'Negozio';

  @override
  String get prices_location_find => 'Trova un negozio';

  @override
  String get prices_location_mandatory => 'Devi selezionare un negozio!';

  @override
  String get prices_location_search_broader =>
      'Impossibile trovare quello che stavi cercando? Proviamo una ricerca più ampia!';

  @override
  String get prices_proof_subtitle => 'Prova';

  @override
  String get prices_proof_empty_title => 'Nessuna prova ancora!';

  @override
  String get prices_proof_empty_explanation =>
      'Inizia aggiungendo una foto di una **scontrino** o di un **cartellino del prezzo**!';

  @override
  String get prices_proof_find => 'Seleziona una prova';

  @override
  String get prices_proof_change => 'Prova di modifica';

  @override
  String get prices_proof_receipt => 'Ricevuta';

  @override
  String get prices_proof_price_tag => 'Etichetta del prezzo';

  @override
  String get prices_proof_mandatory => 'Devi selezionare una prova!';

  @override
  String get prices_add_validation_error => 'Errore di validazione';

  @override
  String get prices_privacy_warning_title => 'Avviso sulla privacy';

  @override
  String get prices_unknown_product => 'Prodotto sconosciuto';

  @override
  String get prices_privacy_warning_main_message =>
      'I prezzi **saranno pubblici**, insieme al negozio a cui si riferiscono.\n\nCiò potrebbe consentire alle persone che conoscono il tuo pseudonimo Open Food Facts di:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Deduci in quale zona vivi';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Sappi cosa stai acquistando';

  @override
  String get prices_privacy_warning_sub_message =>
      'Se non ti senti a tuo agio, cambia il tuo pseudonimo o crea un nuovo account Open Food Facts e accedi all\'app con quello.';

  @override
  String get i_refuse => 'Mi rifiuto';

  @override
  String get i_accept => 'Accetto';

  @override
  String get prices_currency_change_proposal_title => 'Cambiare la valuta?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'La tua valuta attuale è **$currency**. Vuoi cambiarla in **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Sì, usa $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'No, tieni $currency';
  }

  @override
  String get prices_menu_know_more => 'Scopri di più sui Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Fatto';

  @override
  String get dev_mode_section_server => 'Configurazione del server';

  @override
  String get dev_mode_section_news => 'Configurazione del fornitore di notizie';

  @override
  String get dev_mode_section_product_page => 'Pagina del prodotto';

  @override
  String get dev_mode_section_ui => 'Interfaccia utente';

  @override
  String get dev_mode_section_experimental_features =>
      'Funzionalità sperimentali';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Escludi Punteggio Verde';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Usa un correttore ortografico per le schermate OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredienti e confezione)';

  @override
  String get dev_mode_reset_app_language_title =>
      'Reimposta la lingua dell\'app';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Aggiungi carte';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Passa da prices.openfoodfacts.org (PROD) a test env';

  @override
  String get search_history_item_edit_tooltip =>
      'Riutilzza e modifica questa ricerca';

  @override
  String get search_history_item_remove_tooltip => 'Rimuovi';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Hai scaricato tutti i $totalSize prodotti.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Scarica altri $count prodotti\nGià scaricati $downloaded su $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'La tua ricerca di $search è in corso.\n\nAttendi qualche secondo…';
  }

  @override
  String get user_search_contributor_title => 'Prodotti che ho aggiunto';

  @override
  String get user_search_informer_title => 'Prodotti che ho modificato';

  @override
  String get user_search_photographer_title => 'Prodotti che ho fotografato';

  @override
  String get user_search_to_be_completed_title =>
      'I miei prodotti da completare';

  @override
  String get user_search_prices_title => 'I miei prezzi';

  @override
  String get user_search_proofs_title => 'Le mie prove';

  @override
  String get user_search_proof_title => 'La mia prova';

  @override
  String search_proof_title(String user) {
    return 'Dimostrazione da \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Prezzi per i collaboratori: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Ultimi prezzi aggiunti';

  @override
  String get all_search_prices_top_user_title =>
      'Collaboratori principali prezzi';

  @override
  String get all_search_prices_top_location_title => 'Negozi con più prezzi';

  @override
  String get prices_contribution_assistant =>
      'Assistente al contributo dei prezzi';

  @override
  String get prices_validation_assistant =>
      'Assistente per la convalida dei prezzi';

  @override
  String get prices_challenges_page => 'Sfide';

  @override
  String get prices_multiple_proof_addition_system => 'Aggiungi più prove';

  @override
  String get all_search_prices_top_location_single_title =>
      'Prezzi in un negozio';

  @override
  String get all_search_prices_top_product_title => 'Prodotti con più prezzi';

  @override
  String get all_search_to_be_completed_title =>
      'Tutti i prodotti da completare';

  @override
  String get categorize_products_country_title =>
      'Aiuta a categorizzare i prodotti nel tuo paese';

  @override
  String get edit_product_action_retake_picture => 'Rifai foto';

  @override
  String get edit_product_action_take_picture => 'Scatta foto';

  @override
  String get edit_product_action_confirm => 'Conferma';

  @override
  String get signup_page_terms_of_use_line1 => 'Acconsento ai ';

  @override
  String get signup_page_terms_of_use_line2 => 'contributo di Open Food Facts';

  @override
  String get analytics_consent_image_semantic_label => 'Icona d\'analisi';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Errore Fatale: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Errore Fatale: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Completa i dettagli di base';

  @override
  String get edit_photo_button_label => 'Modifica';

  @override
  String get edit_photo_unselect_button_label => 'Deseleziona foto';

  @override
  String get edit_photo_select_existing_button_label =>
      'Seleziona un\'immagine esistente';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Seleziona un\'immagine premendo su di essa';

  @override
  String get edit_photo_select_existing_download_label =>
      'Recuperando le immagini esistenti…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Non è presente alcuna immagine caricata precedentemente, correlata a questo prodotto.';

  @override
  String get edit_photo_language_not_this_one =>
      'Ancora nessuna immagine in quella lingua';

  @override
  String get edit_photo_language_none => 'Ancora nessuna immagine';

  @override
  String get category_picker_screen_title => 'Categorie';

  @override
  String get basic_details => 'Dettagli di base';

  @override
  String get product_name => 'Nome del prodotto';

  @override
  String get product_names => 'Nomi dei prodotti';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Aggiungi una nuova traduzione';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Prima di convalidare, assicurati di aggiungere una traduzione solo **se la lingua è presente sulla confezione**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Visualizza la foto frontale';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Scatta una foto frontale';

  @override
  String get add_basic_details_product_name_hint =>
      'Inserire il nome del prodotto (ad esempio: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Cambiare la lingua predefinita?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Desideri che la lingua predefinita del prodotto sia impostata su \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Buoni esempi';

  @override
  String get explanation_section_bad_examples => 'Cattivi esempi';

  @override
  String get add_basic_details_product_name_help_title =>
      'Buone pratiche: Nome del prodotto';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Il nome del prodotto è il **nome principale stampato sulla confezione**. Può essere un marchio registrato.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Nota:** non aggiungere una traduzione **se la lingua non è presente sulla confezione**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Ketchup di pomodoro';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Non includere il marchio nel nome';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Ketchup di pomodoro **di Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Non utilizzare simboli ®, ™, © o simili';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count altre traduzioni',
      one: '$count altra traduzione',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Nome del marchio';

  @override
  String get brand_names => 'Nomi della marca';

  @override
  String get add_basic_details_brand_name_error =>
      'Si prega d\'inserire il nome della marca';

  @override
  String get add_basic_details_brand_names_hint =>
      'Marchi di input (ad esempio: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Buone pratiche: Marchi';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Inserisci **tutte le marche del prodotto**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Marchio principale';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'Il **marchio principale**, generalmente chiaramente esposto sulla confezione anteriore, deve essere **inserito per primo**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Altri marchi';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Quando venduto **da una grande azienda**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** è venduto da **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Se venduto con il suo marchio **tradotto in più lingue**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** a volte è scritto **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Quantità e peso';

  @override
  String get add_basic_details_quantity_hint =>
      'Inserire il peso e, se necessario, la quantità (ad esempio: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Buone pratiche: Quantità';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copia il valore indicato sul prodotto e **non dimenticare le unità**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** o **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (per 6 uova)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(per un prodotto con 3 scatole, ciascuna da 150 g)';

  @override
  String get barcode => 'Codice a Barre';

  @override
  String barcode_barcode(String barcode) {
    return 'Codice a barre: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Codice a barre non valido';

  @override
  String get basic_details_add_success => 'Dettagli base aggiunti con successo';

  @override
  String get basic_details_add_error =>
      'Impossibile aggiungere i dettagli di base. Si prega di riprovare dopo un po\' di tempo';

  @override
  String get clear_search => 'Cancella la tua ricerca';

  @override
  String get confirm_clear =>
      'Stai per cancellare la tua intera cronologia: sei sicuro di voler continuare?';

  @override
  String get alert_clear_selected_user_list =>
      'Stai per cancellare gli articoli selezionati nella tua cronologia';

  @override
  String get confirm_clear_selected_user_list =>
      'Sei sicuro di voler continuare?';

  @override
  String get alert_select_items_to_clear =>
      'Sei pregato di selezionare uno o più articoli da rimuovere';

  @override
  String confirm_clear_user_list(String name) {
    return 'Stai per cancellare questo elenco ($name): sei sicuro di voler continuare?';
  }

  @override
  String get confirm_delete_user_list_title => 'Eliminare la lista?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Stai per eliminare la lista \"$name\".\nSei sicuro di voler continuare?';
  }

  @override
  String get confirm_delete_user_list_button => 'Sì, confermo';

  @override
  String importance_label(String name, String id) {
    return '$name importanza: $id';
  }

  @override
  String get user_list_all_title => 'Elenchi';

  @override
  String get user_list_all_empty => 'Crea la tua prima lista';

  @override
  String get product_list_select => 'Seleziona una lista';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prodotti',
      one: 'Un prodotto',
      zero: 'Lista vuota',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Aggiungi elenco';

  @override
  String get open_food_preferences_tooltip =>
      'Modifica le tue preferenze alimentari';

  @override
  String get add_photo_button_label => 'Aggiungi foto';

  @override
  String get add_packaging_photo_button_label =>
      'Scatta le foto di qualsiasi informazione di imballaggio/riciclaggio';

  @override
  String get add_origin_photo_button_label =>
      'Scatta foto di qualsiasi informazione di origine';

  @override
  String get add_emb_photo_button_label =>
      'Scatta foto di qualsiasi informazione sul codice di tracciabilità';

  @override
  String get add_label_photo_button_label =>
      'Scatta foto di tutte le etichette e le informazioni sulle certificazioni';

  @override
  String get choose_image_source_title => 'Scegli sorgente immagine';

  @override
  String get choose_image_source_body => 'Scegliere una sorgente immagine';

  @override
  String get gallery_source_label => 'Galleria';

  @override
  String get gallery_source_access_denied_dialog_title => 'Accesso negato';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Sfortunatamente, l\'applicazione non può accedere alla tua galleria, poiché in precedenza hai negato il permesso.\n\nVai alle impostazioni dell\'app nelle impostazioni del telefono -> Foto';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Apri le impostazioni';

  @override
  String get share => 'Condividi';

  @override
  String share_product_text(String url) {
    return 'Dai un\'occhiata a questo prodotto su Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Dai un\'occhiata a questo prodotto su Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Dai un\'occhiata a questo prodotto su Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Dai un\'occhiata a questo prodotto su Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Dai un\'occhiata alla mia lista di prodotti su Open Food Facts: $url';
  }

  @override
  String get capture => 'Scatta una nuova foto';

  @override
  String get capture_new_picture => 'Scatta una foto';

  @override
  String get choose_from_gallery => 'Scegli dalla galleria';

  @override
  String get image_upload_queued =>
      'L\'immagine sarà caricata in background il prima possibile.';

  @override
  String get add_price_queued =>
      'Il prezzo verrà inviato al server il prima possibile.';

  @override
  String get background_task_title_full_refresh =>
      'Avviando il ricaricamento di tutti i prodotti memorizzati localmente';

  @override
  String get background_task_title_folksonomy =>
      'Inizio dell\'esecuzione delle azioni del server per gli aggiornamenti folksonomia archiviati localmente';

  @override
  String get background_task_title_top_n =>
      'Avviando il download dei prodotti più popolari';

  @override
  String get expand_nutrition_facts =>
      'Espandi la tabella dei valori nutrizionali';

  @override
  String get expand_nutrition_facts_body =>
      'Mantieni espansa la tabella dei valori nutrizionali';

  @override
  String get expand_ingredients => 'Espandi gli ingredienti';

  @override
  String get expand_ingredients_body =>
      'Mantieni espanso il pannello degli ingredienti';

  @override
  String get no_internet_connection => 'Nessuna connessione internet';

  @override
  String get world_results_label => 'Tutto il mondo';

  @override
  String get world_results_action => 'Estendi la tua ricerca al mondo';

  @override
  String get copy_to_clipboard => 'Copia';

  @override
  String get paste_from_clipboard => 'Incolla dagli appunti';

  @override
  String get no_data_available_in_clipboard =>
      'Nessun dato disponibile negli appunti';

  @override
  String get clipboard_barcode_copy => 'Copia il codice a barre negli appunti';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Codice a barre $barcode copiato negli appunti!';
  }

  @override
  String get open_product_website => 'Apri questo prodotto sul sito web';

  @override
  String get language_picker_label => 'La tua lingua';

  @override
  String get country_picker_label => 'Il tuo paese';

  @override
  String get currency_picker_label => 'La tua valuta';

  @override
  String get help_with_openfoodfacts => 'Aiuto con OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Il prodotto sarà aggiornato in background il prima possibile.';

  @override
  String get no_email_client_available_dialog_title =>
      'Nessun\'app di posta elettronica!';

  @override
  String get no_email_client_available_dialog_content =>
      'Ti preghiamo di inviarci manualmente un\'email, a mobile@openfoodfacts.org';

  @override
  String get all_images => 'Tutte le immagini';

  @override
  String get selected_images => 'Immagini selezionate';

  @override
  String get product_card_remove_product_tooltip => 'Rimuovi prodotto';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nuovo codice a barre scansionato: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Rimuovi tutti i prodotti dalla sequenza';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Ti preghiamo di scansionare almeno due prodotti per confrontarli';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Clicca per confrontare i prodotti che hai scansionato';

  @override
  String get scan_product_loading => 'Hai scansionato il\ncodice a barre:';

  @override
  String get scan_product_loading_initial =>
      'Stiamo cercando questo prodotto!\nTi preghiamo di attendere qualche secondo…';

  @override
  String get scan_product_loading_long_request =>
      'Stiamo ancora cercando questo prodotto!\nTrovi che il caricamento richieda molto tempo? Anche noi…';

  @override
  String get scan_product_loading_unresponsive =>
      'Stiamo ancora cercando questo prodotto!\nDesideri riavviare la ricerca?';

  @override
  String get scan_product_loading_restart_button => 'Riavvia la ricerca';

  @override
  String get portion_calculator_description =>
      'Calcola i valori nutrizionali per una quantità specifica';

  @override
  String get portion_calculator_hint => 'Quantità in';

  @override
  String get portion_calculator_accessibility =>
      'Inserisci una quantità per calcolare i valori nutrizionali';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Ti preghiamo di inserire una quantità tra $min e $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Dati mancanti. Impossibile eseguire il calcolo.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Valori nutrizionali per $grams g (o ml)';
  }

  @override
  String get offline_data => 'Dati Offline';

  @override
  String get ocr_image_upload_instruction =>
      'Carica un\'immagine per estrarre automaticamente le informazioni che contiene.';

  @override
  String get upload_image => 'Carica Foto';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Scaricamento dell\'immagine fallito';

  @override
  String get image_edit_url_error =>
      'Modifica dell\'immagine non riuscita perché l\'URL dell\'immagine non era impostato.';

  @override
  String get user_picture_source_remember => 'Ricorda la mia scelta';

  @override
  String get user_picture_source_ask => 'Chiedi ogni volta';

  @override
  String get robotoff_continue => 'Continua';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count domande successive',
      one: 'domanda successiva',
    );
    return '$_temp0';
  }

  @override
  String get show_password => 'Mostra la Password';

  @override
  String get owner_field_info_title => 'Valore fornito dal produttore';

  @override
  String get owner_field_info_message =>
      'Con quel logo mettiamo in evidenza i dati forniti dal produttore, e che potrebbero non essere modificabili.';

  @override
  String get owner_field_info_close_button => 'Chiudi questa informazione';

  @override
  String get owner_field_image =>
      'Questa immagine è fornita dal produttore. Potrebbe non essere modificabile.';

  @override
  String get edit_packagings_title => 'Componenti dell\'imballaggio';

  @override
  String get edit_packagings_element_add =>
      'Aggiungi un componente di imballaggio';

  @override
  String get edit_packagings_completed => 'L\'imballaggio è completo';

  @override
  String edit_packagings_element_title(int index) {
    return 'Componente dell\'imballaggio #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Numero di unità';

  @override
  String get edit_packagings_element_hint_units =>
      'Inserisci il numero di unità di imballaggio della stessa forma e materiale contenute nel prodotto.';

  @override
  String get edit_packagings_element_field_shape => 'Forma';

  @override
  String get edit_packagings_element_hint_shape =>
      'Inserisci il nome della forma elencata nelle istruzioni di riciclaggio se disponibili, oppure selezionane una.';

  @override
  String get edit_packagings_element_example_shape => 'Bottiglia';

  @override
  String get edit_packagings_element_field_material => 'Materiale';

  @override
  String get edit_packagings_element_hint_material =>
      'Inserisci il materiale specifico se determinabile (un codice del materiale in un triangolo si può spesso trovare sulle parti dell\'imballaggio), o un materiale generico (ad esempio, plastica o metallo) se non ne sei sicuro.';

  @override
  String get edit_packagings_element_example_material => 'Vetro';

  @override
  String get edit_packagings_element_field_recycling =>
      'Istruzioni di riciclaggio';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Inserisci le istruzioni di riciclaggio soltanto se sono elencate sul prodotto.';

  @override
  String get edit_packagings_element_example_recycling => 'Ricicla';

  @override
  String get edit_packagings_element_field_quantity =>
      'Quantità netta di prodotto per unità';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Inserisci il peso o il volume netto e indica l\'unità (ad esempio, g o ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Peso di un\'unità vuota (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Rimuovi qualsiasi residuo alimentare e lava e asciuga l\'imballggio prima di pesarlo. Se possibile, utilizza una bilancia con una precisione di 0,1g o 0,01g.';

  @override
  String get background_task_title => 'Contributi in sospeso';

  @override
  String get background_task_subtitle =>
      'I tuoi contributi sono salvati automaticamente sul nostro server, ma non sono sempre in tempo reale.';

  @override
  String get background_task_list_empty =>
      'Nessuna Attività in Background in Sospeso';

  @override
  String get background_task_error_server_time_out => 'Timeout del server';

  @override
  String get background_task_error_no_internet =>
      'Errore di connessione a Internet. Riprova più tardi.';

  @override
  String get background_task_operation_unknown =>
      'tipo di operazione sconosciuto';

  @override
  String get background_task_operation_details => 'modifiche dettagliate';

  @override
  String get background_task_operation_image => 'caricamento foto';

  @override
  String get background_task_operation_refresh =>
      'aggiornamento ritardato dopo il caricamento della foto';

  @override
  String get background_task_run_started => 'avviata';

  @override
  String get background_task_run_not_started => 'non ancora avviata';

  @override
  String get background_task_run_to_be_deleted => 'da eliminare';

  @override
  String get background_task_question_stop =>
      'Desideri interrompere tale attività il prima possibile?';

  @override
  String get feed_back => 'Feedback';

  @override
  String get undo => 'Annulla';

  @override
  String get copy_email_to_clip_board => 'Copia l\'email negli appunti';

  @override
  String get please_send_us_an_email_to =>
      'Per favore inviaci manualmente un\'e-mail a';

  @override
  String get email_copied_to_clip_board => 'Email copiata negli appunti!';

  @override
  String get select_accent_color => 'Seleziona il Colore Secondario';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Blu';

  @override
  String get color_cyan => 'Ciano';

  @override
  String get color_green => 'Verde';

  @override
  String get color_light_brown => 'Predefinito';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Arancione';

  @override
  String get color_pink => 'Rosa';

  @override
  String get color_red => 'Rosso';

  @override
  String get color_rust => 'Ruggine';

  @override
  String get color_teal => 'Verde Acqua';

  @override
  String get text_contrast_mode => 'Contrasto del Testo';

  @override
  String get contrast_high => 'Elevato';

  @override
  String get contrast_medium => 'Medio';

  @override
  String get contrast_low => 'Basso';

  @override
  String get product_refresher_internet_not_found => 'Prodotto non trovato!';

  @override
  String get product_refresher_internet_not_connected =>
      'Non sei connesso a internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server inattivo ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Errore del server ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Prodotto non trovato!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Un prodotto con il seguente codice a barre non esiste nel nostro database: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Nessuna connessione a Internet!';

  @override
  String get product_loader_network_error_message =>
      'Sei pregato di verificare che il tuo smartphone sia connesso a una rete WiFi o abbia i dati mobili abilitati';

  @override
  String get page_not_found_title => 'Pagina non trovata!';

  @override
  String get page_not_found_button => 'Torna alla pagina home';

  @override
  String get download_data => 'Scarica i dati';

  @override
  String get download_top_products =>
      'Scarica i migliori 1000 prodotti nel tuo paese per la scansione istantanea';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prodotti',
    );
    return 'Scarica i migliori $_temp0 nel tuo paese, per la scansione istantanea';
  }

  @override
  String get download_in_progress =>
      'Scaricando i dati...\nPotrebbe volerci un po\'';

  @override
  String downloaded_products(int num) {
    return '$num prodotti aggiunti';
  }

  @override
  String get update_offline_data => 'Aggiorna i dati offline dei prodotti';

  @override
  String get update_local_database_sub =>
      'Aggiorna il database locale dei prodotti con i dati più recenti da Open Food Facts';

  @override
  String get clear_local_database => 'Cancella i dati offline dei prodotti';

  @override
  String get clear_local_database_sub =>
      'Cancella tutti i dati locali dei prodotti dalla tua app per liberare spazio';

  @override
  String deleted_products(int num) {
    return '$num prodotti eliminati';
  }

  @override
  String get loading => 'Caricamento in corso…';

  @override
  String get know_more => 'Scopri di Più';

  @override
  String get offline_data_desc => 'Clicca per scoprire di più sui dati offline';

  @override
  String get offline_product_data_title => 'Dati offline sui prodotti';

  @override
  String available_for_download(int num) {
    return '$num prodotti disponibili per la scansione immediata';
  }

  @override
  String get country_selector_title => 'Seleziona il tuo paese:';

  @override
  String get currency_selector_title => 'Seleziona la tua valuta:';

  @override
  String get language_selector_title => 'Seleziona la tua lingua:';

  @override
  String get language_selector_section_selected => 'Lingue selezionate';

  @override
  String get language_selector_section_frequently_used =>
      'Usato frequentemente';

  @override
  String get action_delete_list => 'Elimina';

  @override
  String get action_change_list => 'Modifica la lista corrente';

  @override
  String get product_list_create => 'Crea';

  @override
  String get product_list_create_tooltip => 'Crea una nuova lista';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Nuovo calcolo)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Nuovo calcolo)';

  @override
  String get nutriscore_unknown => 'Nutri-Score Sconosciuto';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nutri-Score sconosciuto (Nuovo calcolo)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score non applicabile';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score non è applicabile (Nuovo calcolo)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Punteggio verde A';

  @override
  String get environmental_score_b_new => 'Punteggio verde B';

  @override
  String get environmental_score_c_new => 'Punteggio verde C';

  @override
  String get environmental_score_d_new => 'Punteggio verde D';

  @override
  String get environmental_score_e_new => 'Punteggio verde E';

  @override
  String get environmental_score_unknown_new => 'Punteggio verde sconosciuto';

  @override
  String get environmental_score_not_applicable_new =>
      'Il punteggio verde non è applicabile';

  @override
  String get nova_group_generic_new =>
      'Alimenti ultra-processati - gruppi NOVA';

  @override
  String get nova_group_1 => 'Gruppo NOVA 1';

  @override
  String get nova_group_2 => 'Gruppo NOVA 2';

  @override
  String get nova_group_3 => 'Gruppo NOVA 3';

  @override
  String get nova_group_4 => 'Gruppo NOVA 4';

  @override
  String get nova_group_unknown => 'Gruppo NOVA Sconosciuto';

  @override
  String get nutrition_facts => 'Livelli di nutrienti';

  @override
  String get faq_title_partners => 'Partner e sostenitori della ONG';

  @override
  String get faq_title_vision =>
      'Visione, Missione, Valori e Programmi di Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Installa Open Beauty Facts per creare un database cosmetico';

  @override
  String get faq_title_install_pet =>
      'Installa Open Pet Food Facts per creare un database di alimenti per animali domestici';

  @override
  String get faq_title_install_product =>
      'Installa Open Products Facts per creare un database di prodotti per prolungare la vita degli oggetti';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nuovo calcolo del Nutri-Score: cosa c\'è di nuovo?';

  @override
  String get contact_title_pro_page =>
      'Pro? Importa i tuoi prodotti in Open Food Facts';

  @override
  String get contact_title_pro_email => 'Contatto Produttore';

  @override
  String get contact_title_press_page => 'Pagina ufficio stampa';

  @override
  String get contact_title_press_email => 'Contatto ufficio stampa';

  @override
  String get contact_title_newsletter => 'Iscriviti alla nostra newsletter';

  @override
  String get contact_title_calendar =>
      'Iscriviti al calendario della nostra comunità';

  @override
  String get hunger_games_loading_line1 =>
      'Ti preghiamo di darci qualche secondo…';

  @override
  String get hunger_games_loading_line2 => 'Stiamo scaricando le domande!';

  @override
  String get hunger_games_error_label =>
      'Argh! Qualcosa è andato storto… e non siamo riusciti a caricare le domande.';

  @override
  String get hunger_games_error_retry_button => 'Riproviamo!';

  @override
  String get reorder_attribute_action => 'Riordina gli attributi';

  @override
  String get link_cant_be_opened =>
      'Questo collegamento non può essere aperto sul tuo dispositivo. Verifica di avere un browser installato.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Dettagli per $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Dettagli per $pageName con $productName';
  }

  @override
  String get guide_title => 'Guida';

  @override
  String get guide_share_label => 'Condividi';

  @override
  String get guide_nutriscore_v2_title =>
      'Il Nutri-Score è in evoluzione: spiegazioni!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Cos\'è il Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Il Nutri-Score è un logo che ha lo scopo d\'informarti sulla **qualità nutrizionale degli alimenti**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'Il codice colore varia dal verde scuro (**A**) per i prodotti **più salutari** al rosso scuro (**E**) per quelli **meno salutari**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'Il logo A del Nutri-Score';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Perché il Nutri-Score si sta evolvendo?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'La formula del Nutri-Score **sta evolvendo** per fornire raccomandazioni migliori:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Valutazione migliore di tutte le bevande';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'Le note comparative di **latte**, **bevande lattiero-casearie** con zucchero aggiunto e **bevande vegetali** sono stati meglio differenziate nel nuovo algoritmo.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Migliore classificazione delle bevande';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'Il **contenuto di zucchero** viene meglio preso in considerazione e favorisce le bevande **poco zuccherate**.\\n**I dolcificanti verranno anch\'essi penalizzati**: le bibite dietetiche passeranno da un punteggio B a uno compreso tra C ed E. L\'acqua rimane la bevanda consigliata.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Il sale e lo zucchero penalizzati';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'I prodotti **troppo dolci** o **troppo salati** vedranno la loro **valutazione ulteriormente declassata**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'La gerarchia negli oli e nei pesci';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'La valutazione di alcuni **pesci grassi** e **oli ricchi in grassi buoni** migliorerà.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limita la carne rossa';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Il consumo di **carne rossa dovrebbe essere limitato**. Ecco perché il **pollame sarà classificato relativamente meglio**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Come distinguere tra il vecchio e il nuovo calcolo del Nutri-Score?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'D\'ora in poi, il logo può mostrare la dicitura \"**Nuovo calcolo**\" per chiarire che si tratta effettivamente del nuovo calcolo.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Il logo del nuovo Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Dove trovare il nuovo calcolo del Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Il Nutri-Score è applicato in 7 paesi: Francia, Germania, Belgio, Spagna, Lussemburgo, Paesi Bassi e Svizzera.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'I produttori hanno al massimo **2 anni** dalla firma del decreto **per sostituire** il vecchio calcolo con quello nuovo.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Senza dover aspettare, **troverai già nell\'applicazione OpenFoodFacts**, il nuovo calcolo, anche se i produttori non hanno aggiornato il punteggio.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Cosa non cambia';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Il Nutri-Score è un punteggio progettato per **misurare la qualità nutrizionale**. È **complementare al gruppo NOVA** sugli **alimenti ultra-trasformati** (anch\'esso presente nell\'applicazione).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Per i produttori, l\'esposizione del Nutri-Score **rimane facoltativa**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Cos\'è il Green Score?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Il Green-Score è un logo che ha lo scopo di informarti sull\'**impatto ambientale del cibo**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Il codice colore varia dal verde scuro (**A+**) per i prodotti **meno impattanti** al rosso scuro (**F**) per i prodotti **più impattanti**.';

  @override
  String get guide_greenscore_logos_caption => 'I loghi Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Il nucleo: valutazione del ciclo di vita (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Una valutazione scientifica delle categorie alimentari';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Per ogni categoria di prodotto viene stabilito un punteggio di **riferimento** utilizzando i dati del database ambientale Agribalyse (progettato da ADEME e INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**L\'analisi del ciclo di vita** è un metodo di valutazione standardizzato per eseguire una valutazione ambientale multifase e multicriterio.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Misura:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 fasi di produzione';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agricoltura';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Trasformazione';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Imballaggio';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Trasporto';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribuzione';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumo';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indicatori di impatto ambientale';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Cambiamento climatico/impronta di carbonio';

  @override
  String get guide_greenscore_lca_arg3_text2 =>
      'esaurimento dello strato di ozono';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Radiazioni ionizzanti';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Terra';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Consumo di acqua ed energia';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Inquinamento dell\'aria';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Acqua marina e dolce (particelle, acidificazione, eutrofizzazione)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Esaurimento delle risorse.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonus e penalità';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Per premiare i prodotti migliori all\'interno di una categoria, applichiamo **bonus e penalità basati su diversi criteri**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Modalità di produzione';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'Un **bonus** viene assegnato ai prodotti che hanno un\'**etichetta ufficiale, un\'etichetta o una certificazione che garantisce benefici ambientali** (biologico, commercio equo e solidale, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origine degli ingredienti';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'Un **bonus** viene assegnato in base all\'origine degli ingredienti. Questo bonus tiene conto dell\'**impatto sul trasporto** e anche della **politica ambientale** del Paese di ciascun produttore.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Specie in pericolo';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Una **penalità** viene applicata ai prodotti che contengono ingredienti che hanno un significativo **impatto negativo sulla biodiversità e sugli ecosistemi**, come l\'olio di palma, la cui produzione è responsabile di una massiccia deforestazione.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Imballaggio';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'Una **penalità** viene calcolata tenendo conto della **circolarità dell\'imballaggio** (uso di materie prime riciclate e riciclabilità) e del sovraimballaggio.';

  @override
  String get guide_greenscore_transparency_title =>
      'Una maggiore esigenza di trasparenza per misurare meglio e ridurre gli impatti ambientali';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Per calcolare con precisione il Green-Score, è necessario disporre di **informazioni che non sono necessariamente specificate sulla confezione** (come l\'origine e la percentuale esatta di ciascun ingrediente) o che sono raramente disponibili in forma fruibile (come un elenco di tutti i componenti della confezione con i tipi precisi di plastica utilizzati).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Quando queste informazioni non sono ancora disponibili, vengono utilizzati valori medi**, ma ora chiediamo a tutti di aiutarci a raccogliere queste informazioni che saranno molto utili per il Green-Score ma anche per molti altri usi.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Come possono aiutare i cittadini?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Tutti i cittadini possono aiutarci a raccogliere e strutturare le informazioni presenti sui prodotti o che possono essere dedotte da essi, come ad esempio le informazioni sugli **imballaggi**: \"Mission Emballages\": un inventario collaborativo su larga scala degli imballaggi per tutti i prodotti alimentari (in francese).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Come possono aiutare i produttori';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'I produttori possono inviarci le loro informazioni direttamente tramite la nostra piattaforma gratuita per produttori.';

  @override
  String get guide_greenscore_better_product_title =>
      'Quale prodotto è migliore per il pianeta?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Può essere difficile da dire';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Scegliere cibo sostenibile è una delle azioni più efficaci che possiamo intraprendere per il clima, poiché **il nostro sistema alimentare globale è responsabile di oltre un quarto di tutte le emissioni di gas serra**.\n(Fonte: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Hai il potere!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'La buona notizia è che questo ci offre un modo potente per creare un cambiamento.\n**Ognuno di noi consuma circa 1.000 pasti all\'anno**. Sono 1.000 opportunità per **scegliere un futuro migliore per il pianeta**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Aiuta ad essere responsabili e a decidere';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Scegliere alimenti sostenibili può sembrare complicato. Le etichette sono confuse e spesso mancano informazioni. Il Green-Score è stato creato per semplificare le cose, fornendo una valutazione ambientale **chiara**, **basata sulla scienza** e **trasparente** per i prodotti alimentari, proprio dove serve: mentre fai la spesa.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Trasparenza';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'A differenza delle etichette proprietarie, il calcolo del Green-Score è **completamente aperto** e può essere **verificato da chiunque**.';

  @override
  String get guide_nova_title => 'Prodotti alimentari ultra-elaborati';

  @override
  String get guide_nova_what_is_nova_title => 'Che cosa è l\'ultra-processing?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'I gruppi NOVA vi informano sul livello di lavorazione degli alimenti.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'La classificazione NOVA consente di suddividere gli alimenti in **4 gruppi** in base al loro **grado di lavorazione industriale** (alimenti minimamente lavorati o non lavorati, ingredienti culinari, alimenti lavorati, alimenti ultra-lavorati).';

  @override
  String get guide_nova_logos_caption => 'I loghi NOVA';

  @override
  String get guide_nova_groups_title => 'I 4 gruppi NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Esistono 4 gruppi NOVA, il più problematico dei quali è il Gruppo 4: Alimenti ultra-processati.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Alimenti minimamente lavorati o non lavorati';

  @override
  String get guide_nova_groups_arg1_text =>
      'Gli alimenti non trasformati (o naturali) sono le **parti commestibili delle piante** (semi, frutti, foglie, steli, radici) **o degli animali** (muscoli, frattaglie, uova, latte), nonché funghi, alghe e acqua, dopo essere stati separati dalla natura.';

  @override
  String get guide_nova_groups_arg2_title => 'Ingredienti culinari elaborati';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 Foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Alimenti trasformati';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances From Group 2 to group 1** foods. PROCESSES include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most Processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be Eaten on Their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title =>
      'Prodotti alimentari ultra-elaborati';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually Include those Also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other Sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, Such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'I problemi con l\'ultra-elaborazione';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Elaborazione estrema degli ingredienti alimentari';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Molti derivano dall\'ulteriore lavorazione di componenti alimentari, come oli idrogenati o interesterificati, proteine idrolizzate, proteine di soia isolate, maltodestrina, zucchero invertito e sciroppo di mais ad alto contenuto di fruttosio.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Additivi che vanno oltre la pura sicurezza alimentare';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Gli additivi presenti negli alimenti ultra-processati includono alcuni additivi utilizzati anche negli alimenti trasformati, come conservanti, antiossidanti e stabilizzanti. Le classi di additivi presenti solo nei prodotti ultra-processati includono quelli utilizzati **per imitare o migliorare le qualità sensoriali degli alimenti o per mascherare aspetti sgradevoli del prodotto finale**. Questi additivi includono coloranti e altri coloranti, stabilizzanti del colore; aromi, esaltatori di sapidità, dolcificanti non zuccherini; e coadiuvanti tecnologici come agenti carbonatanti, rassodanti, volumizzanti e anti-volume, agenti antischiuma, antiagglomeranti e di glassa, emulsionanti, sequestranti e umettanti.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Elaborazione che non puoi fare a casa';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Per combinare i numerosi ingredienti e creare il prodotto finale (da qui il termine \"ultra-processato\") vengono utilizzate **molteplici sequenze di processi**. I processi includono diversi **senza equivalenti nazionali**, come l\'idrogenazione e l\'idrolisi, l\'estrusione e lo stampaggio, e la pre-lavorazione per la frittura.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Gli aspetti predatori e finanziari dell\'ultra-processing';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Lo scopo generale dell\'ultra-processing è quello di creare prodotti alimentari di marca**, **pratici** (durevoli, pronti al consumo), **attraenti** (iper-appetibili) e **altamente redditizi** (con ingredienti a basso costo), progettati per sostituire tutti gli altri gruppi alimentari. I prodotti alimentari ultra-processati sono solitamente confezionati in modo accattivante e commercializzati in modo intensivo.';

  @override
  String get guide_nova_explanations_arg5_title => 'Un pericolo per la salute';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Dal 2018, con NutriNet-Santé, sono stati evidenziati i primi collegamenti tra **il consumo di alimenti ultra-processati e l\'aumento del rischio di cancro, malattie cardiovascolari e diabete**. Oggi, oltre 90 studi in tutto il mondo confermano questi risultati.\nLe associazioni più forti riguardano **obesità, mortalità cardiovascolare e sintomi depressivi**. Nei bambini, gli effetti si osservano principalmente sul peso e sugli squilibri lipidici.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'I paesi raccomandano di limitarli';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Alcuni paesi utilizzano i gruppi NOVA per le loro linee guida o obiettivi dietetici, ad esempio:\n\n- **🇧🇷 Le linee guida dietetiche del Brasile** **raccomandano di limitare il consumo** di alimenti trasformati ed evitare alimenti ultra-processati.\n\n- **🇫🇷 Gli obiettivi della politica nutrizionale per la salute pubblica della Francia** per il 2018-2022 mirano a **ridurre del 20% il consumo di alimenti ultra-processati del gruppo 4**.';

  @override
  String get guide_nova_share_link => 'https://world-it.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Benvenuti a Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Che cosa sono Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts è un database **collaborativo**, **gratuito** e **aperto** di prodotti alimentari provenienti da tutto il mondo.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Crediamo che tutti debbano avere accesso alle informazioni su ciò che mangiano. Raccogliendo dati su ingredienti, allergeni, informazioni nutrizionali e altro ancora, **mettiamo i consumatori nelle condizioni di fare scelte consapevoli** e guidiamo l\'industria alimentare **verso una maggiore trasparenza**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Caratteristiche di Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Ricevi avvisi per i tuoi ingredienti indesiderati';

  @override
  String get guide_open_food_facts_tips_title =>
      'Suggerimenti per scattare foto fantastiche';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Cosa non fare';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Evitare ombre e riflessi.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Nessun testo sfocato o fuori fuoco.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Non tagliare parti del testo.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Evita sfondi troppo elaborati.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Cosa fare';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Utilizzare un\'illuminazione adeguata e uniforme.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Assicurarsi che il testo sia nitido e leggibile.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Raccogli l\'elenco completo degli ingredienti.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Tenere il prodotto su una superficie piana.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Aiutaci a costruire la \"Wikipedia del cibo\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Un punteggio sulla qualità nutrizionale';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Un punteggio per evitare i cibi ultra-processati';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Un punteggio per il pianeta';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-it.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Benvenuti a Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Che cosa è Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts estende la nostra missione ai nostri amici pelosi! È un **database di prodotti alimentari per gatti, cani e altri animali domestici**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Raccogliamo informazioni su **ingredienti**, **analisi nutrizionali** e linee guida per l\'alimentazione per aiutare i proprietari di animali domestici a scegliere il cibo migliore per le esigenze dei loro animali.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Caratteristiche di Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Ricevi avvisi per i tuoi ingredienti indesiderati';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Il tuo animale domestico è allergico a qualche ingrediente? Puoi impostare un elenco di ingredienti cosmetici da evitare, direttamente nell\'app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Suggerimenti per scattare foto fantastiche';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Cosa non fare';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Evitare ombre e riflessi.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Nessun testo sfocato o fuori fuoco.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Non tagliare parti del testo.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Evita sfondi troppo elaborati.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Cosa fare';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Utilizzare un\'illuminazione adeguata e uniforme.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Assicurarsi che il testo sia nitido e leggibile.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Raccogli l\'elenco completo degli ingredienti.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Tenere il prodotto su una superficie piana.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'Una nota sul punteggio';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Sviluppare un sistema di punteggio per gli alimenti per animali domestici **non è una priorità al momento**. La metodologia sarebbe complessa, poiché le esigenze nutrizionali variano notevolmente a seconda della specie, dell\'età e delle condizioni di salute. Non abbiamo ancora trovato un team scientifico indipendente in grado di sviluppare un punteggio del genere.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-it.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Benvenuti a Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Che cosa sono Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts è un database collaborativo di **prodotti cosmetici**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Il nostro obiettivo è decifrare gli elenchi degli ingredienti per aiutarti a **capire cosa contengono i tuoi prodotti per la cura della persona**. Dalle creme idratanti al trucco, raccogliamo dati su ingredienti, allergeni e packaging per promuovere la trasparenza nel settore cosmetico.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Caratteristiche di Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Ricevi avvisi per i tuoi ingredienti indesiderati';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Sei allergico a qualche ingrediente? Vuoi evitare sostanze comedogene? Vuoi evitare ingredienti controversi? Puoi impostare un elenco di ingredienti cosmetici da evitare, direttamente nell\'app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Suggerimenti per scattare foto fantastiche';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Cosa non fare';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Evitare ombre e riflessi.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Nessun testo sfocato o fuori fuoco.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Non tagliare parti del testo.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Evita sfondi troppo elaborati.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Cosa fare';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Utilizzare un\'illuminazione adeguata e uniforme.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Assicurarsi che il testo sia nitido e leggibile.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Raccogli l\'elenco completo degli ingredienti.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Se la bottiglia è curva, scatta tutte le foto che ritieni necessarie.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Potrebbe essere necessario staccare l\'etichetta per vedere l\'elenco degli ingredienti.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Tenere il prodotto su una superficie piana.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Una nota sul punteggio';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'A differenza dei prodotti alimentari, il mondo della cosmetica **non dispone di un sistema di punteggio universalmente riconosciuto e supportato dal governo come il Nutri-Score**. Gli effetti degli ingredienti possono essere molto personali e dipendere dal tipo di pelle, dalle allergie e dalle esigenze individuali.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-it.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Benvenuti a Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Cosa sono i Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices è un progetto per **raccogliere e condividere i prezzi dei prodotti in tutto il mondo**. Si tratta di un set di dati pubblicamente disponibile che può essere utilizzato per ricerche, analisi e altro ancora. Open Prices è sviluppato e gestito da Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Attualmente sono poche le aziende che possiedono grandi banche dati sui prezzi dei prodotti a livello di codici a barre. Questi prezzi non sono liberamente disponibili, ma venduti ad un prezzo elevato a soggetti privati, ricercatori e altre organizzazioni che possono permetterseli.';

  @override
  String get guide_open_prices_how_title => 'Come funziona Open Prices?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Stiamo creando un dataset open source di prezzi tramite crowdsourcing**. Gli utenti possono aggiungere i prezzi tramite questa app web o tramite l\'app mobile ufficiale Open Food Facts. Anche i rivenditori o le app di terze parti possono contribuire utilizzando la nostra API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Raccogli le foto dei cartellini dei prezzi nei corridoi';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Raccogli le foto delle ricevute';

  @override
  String get guide_open_prices_why_title => 'Perché Open Food Facts fa questo?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Le informazioni sui prezzi sono di fondamentale importanza per comprendere i sistemi alimentari. Sono un fattore chiave per comprendere il costo del cibo e promuovere diete più sane. Rendere pubblici i dati sui prezzi è un modo per aiutare ricercatori, giornalisti e cittadini a **comprendere meglio come i prezzi dei prodotti alimentari variano geograficamente e nel tempo**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Monitora l\'evoluzione dei prezzi nel tempo';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Scopri l\'**evoluzione dei prezzi**: shrinkflation, cheapflation, possiamo monitorarli insieme!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Confronta i prezzi vicino a te';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Man mano che i prezzi aumentano, potrai individuare **i negozi più economici vicino a te**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Hai mai pensato di copiare i prezzi dai siti web dei rivenditori?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Per motivi legali e tecnici, **non consideriamo l\'acquisizione di prezzi dai siti web dei rivenditori come un modo valido per contribuire a Open Prices**. Vogliamo assicurarci che i prezzi che raccogliamo siano accurati e aggiornati, e ricevere prezzi acquisiti dai contributori non ci consente di farlo.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Lo scraping dei prezzi è un\'opzione presa in considerazione in una futura versione di Open Prices, ma verrà eseguito da Open Prices stesso, in modo da poter avere una prova del prezzo basata sulla pagina HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'Sono un rivenditore e voglio contribuire con i prezzi. Come posso farlo?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Puoi contribuire con i prezzi utilizzando la nostra API.\nSe vuoi contribuire con i prezzi su larga scala, contattaci all\'indirizzo prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Benvenuti a Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Che cosa è Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts è un enorme database aperto per **qualsiasi prodotto dotato di codice a barre, che non sia un alimento, un cosmetico o un cibo per animali**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Dall\'**elettronica** ai **giocattoli**, dagli **abiti** ai **prodotti per la pulizia**, tutto ciò che ha un codice a barre può essere aggiunto. Questo progetto mira a creare un \"Internet delle cose\" per gli oggetti di uso quotidiano, rendendo le informazioni su di essi universalmente accessibili.';

  @override
  String get guide_open_products_facts_features_title =>
      'Caratteristiche di Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts si propone di offrire ai consumatori la possibilità di **prolungare la vita degli oggetti** fornendo soluzioni circolari per manutenere, **riparare**, **riciclare** i loro oggetti o dare loro un nuovo proprietario.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Impronta di carbonio per alcuni prodotti';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impatto CO2** dell\'Autorità francese per l\'ambiente ADEME fornisce l\'**impatto di carbonio** di numerose categorie; assicurati di categorizzare i prodotti in modo preciso.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Indice di riparabilità per molti prodotti';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Ogni volta che sarà disponibile un indice di riparabilità francese, lo mostreremo. Inoltre, **potete iniziare a raccogliere le variabili utilizzando il Folksonomy Engine**, in modo che possiamo ricalcolarlo noi stessi in futuro, anche nei paesi in cui non è disponibile.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Trova modi per donare/rivendere il tuo prodotto';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Forniamo link a **servizi di terze parti che rispettano l\'ambiente** che ti aiutano a ottenere il tipo di prodotto che stai cercando, come prodotto di seconda mano, per essere più rispettosi delle risorse del pianeta.\nNota che non siamo pagati per questo e che il sistema funziona solo come esempio per due siti web in Francia. Puoi contribuire ad espandere questo sistema documentando altri siti sul wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Quali informazioni sono utili?';

  @override
  String get guide_open_products_facts_information_text =>
      'Per una gamma così ampia di elementi, **i dati che raccogliamo sono flessibili**. Per farlo, **abbiamo creato il Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Il motore della folksonomia';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Il Folksonomy Engine è uno strumento che ti aiuta a completare i prodotti con proprietà pertinenti. Questo aiuta a migliorare la ricerca e la reperibilità, ma anche a calcolare e visualizzare elementi interessanti in futuro.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Puoi aggiungere qualsiasi chiave e valore come: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Riceverai suggerimenti automatici sulle possibili proprietà e sarai il benvenuto ad aggiungerne e documentarne di nuove per i tuoi tipi di prodotti preferiti.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-it.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Apri le preferenze alimentari';

  @override
  String get guide_coming_soon_button_title => 'Prossimamente';

  @override
  String get guide_learn_more_subtitle => 'Tocca per saperne di più';

  @override
  String get preview_badge => 'Anteprima';

  @override
  String get prices_feedback_form =>
      'Clicca qui per inviarci il tuo feedback su questa nuova funzionalità!';

  @override
  String get menu_button_list_actions => 'Seleziona un\'azione';

  @override
  String get error_loading_photo => 'Errore durante il caricamento della foto';

  @override
  String get photo_viewer_action_use_picture_as => 'Utilizza come…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Usa questa immagine come…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Usa questa immagine come… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Dettagli';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Dettagli di questa foto';

  @override
  String get photo_viewer_details_title => 'Dettagli della foto';

  @override
  String get photo_viewer_details_contributor_title => 'Collaboratori';

  @override
  String get photo_viewer_details_size_title => 'Dimensione';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixel';
  }

  @override
  String get photo_viewer_details_date_title => 'Data';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Compatibile';

  @override
  String get user_lists_action_multi_select => 'Multi-selezione';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Il tuo punteggio di compatibilità: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Immagine frontale';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Immagine della lista degli ingredienti';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Immagine nutrizionale';

  @override
  String get product_image_packaging_accessibility_label =>
      'Imballaggio immagine';

  @override
  String get product_image_other_accessibility_label => 'Altra immagine';

  @override
  String get product_image_outdated_message =>
      'Questa immagine potrebbe essere obsoleta';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (questa immagine potrebbe essere obsoleta)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (questa immagine può essere bloccata dal produttore)';
  }

  @override
  String get product_image_error => 'Impossibile caricare l\'immagine!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Impossibile caricare $type (errore di rete?)';
  }

  @override
  String get product_page_image_no_image_available => 'Nessuna immagine\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Nessuna immagine disponibile per questo prodotto';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Riordina o nascondi azioni';

  @override
  String get product_page_action_bar_setting_modal_title => 'Modifica azioni';

  @override
  String get product_page_action_bar_item_move_up => 'Sposta in alto';

  @override
  String get product_page_action_bar_item_move_down => 'Sposta in basso';

  @override
  String get product_page_action_bar_item_enable => 'Abilita azione';

  @override
  String get product_page_action_bar_item_disable => 'Disabilita azione';

  @override
  String get product_page_pending_operations_banner_title =>
      'Caricamento delle modifiche…';

  @override
  String get product_page_pending_operations_banner_message =>
      'I dati visualizzati in questa pagina **non riflettono ancora le tue modifiche**.\nSi prega di attendere alcuni secondi…';

  @override
  String get product_add_a_language => 'Aggiungi una lingua';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Codice a barre $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Rimuovi questo prodotto dal carosello';

  @override
  String get carousel_unsupported_header => 'Codice a barre non supportato!';

  @override
  String get carousel_unsupported_title => 'Ooops!';

  @override
  String get carousel_unsupported_text =>
      'Il codice a barre scansionato non è supportato da Open Food Facts!';

  @override
  String get carousel_error_header => 'Errore!';

  @override
  String get carousel_error_title => 'Che peccato!';

  @override
  String get carousel_error_text_1 =>
      'Impossibile scaricare le informazioni su questo codice a barre:';

  @override
  String get carousel_error_text_2 =>
      'Si prega di controllare la connessione Internet o fare clic su questo pulsante:';

  @override
  String get carousel_error_button => 'Riprova';

  @override
  String get carousel_unknown_product_header => 'Prodotto sconosciuto';

  @override
  String get carousel_unknown_product_title =>
      'Congratulazioni!\nHai trovato __la gemma rara!__';

  @override
  String get carousel_unknown_product_text =>
      'Il nostro database collaborativo contiene più di **3 milioni di prodotti**, ma questo codice a barre non esiste: ';

  @override
  String get carousel_unknown_product_button => 'Aggiungi questo prodotto';

  @override
  String get carousel_loading_header => 'Caricamento informazioni...';

  @override
  String get carousel_loading_title =>
      'Hai appena analizzato un prodotto con il seguente codice a barre:';

  @override
  String get carousel_loading_text =>
      'Lo stiamo cercando nel nostro database di più di **3 milioni di prodotti!**';

  @override
  String get product_type_subtitle_food =>
      'Ortaggi, frutta, alimenti congelati…';

  @override
  String get product_type_subtitle_beauty => 'Trucco, saponi, dentifrici…';

  @override
  String get product_type_subtitle_pet_food => 'Cibo per cani, gatti…';

  @override
  String get product_type_subtitle_product => 'Smartphone, mobili…';

  @override
  String get photo_field_front => 'Foto del prodotto';

  @override
  String get photo_field_ingredients => 'Foto degli ingredienti';

  @override
  String get photo_field_nutrition => 'Foto di nutrizione';

  @override
  String get photo_field_packaging => 'Foto delle istruzioni di riciclaggio';

  @override
  String get photo_already_exists => 'Questa foto esiste già';

  @override
  String get photo_missing => 'Questa foto è mancante';

  @override
  String get date => 'Data';

  @override
  String get photo_rotate_left => 'Ruota a sinistra';

  @override
  String get photo_rotate_right => 'Ruota a destra';

  @override
  String get photo_undo_action => 'Annulla l\'azione precedente';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Una mappa del mondo di $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Collaboratori di OpenStreetMap';

  @override
  String get not_applicable_short => 'N/D';

  @override
  String get knowledge_panel_warning_text => 'Attenzione';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Perché questo Nutri-Score è diverso da quello riportato sulla confezione?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Ci sono due possibili spiegazioni:\nL\'elenco degli ingredienti e/o i valori nutrizionali non sono aggiornati.\n\nIl Nutri-Score da noi calcolato utilizza il \"nuovo calcolo\" (o v2). Controlla che ci sia il banner \"new calculation\" sulla confezione.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Controlla gli ingredienti';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Controlla i valori nutrizionali';

  @override
  String url_not_supported(String url) {
    return 'Impossibile aprire l\'URL:\n$url';
  }

  @override
  String get product_list_export => 'Esportare';

  @override
  String get product_list_import => 'Importare';

  @override
  String get product_footer_action_barcode => 'Visualizza il codice a barre';

  @override
  String get product_footer_action_barcode_short => 'Codice a Barre';

  @override
  String get product_footer_action_open_website => 'Apri il sito web';

  @override
  String get product_footer_action_report => 'Rapporto';

  @override
  String get product_footer_action_contributor_guide => 'Assistenza';

  @override
  String get product_footer_action_data_quality_tags => 'Qualità dei dati';

  @override
  String get product_page_tab_for_me => 'Per me';

  @override
  String get product_page_tab_website => 'Sito web';

  @override
  String get product_page_tab_prices => 'Prezzi';

  @override
  String get prices_explanation_card_title => 'Perché i prezzi?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** è un progetto per raccogliere e condividere i prezzi dei prodotti in tutto il mondo 🌍. Open Prices è sviluppato e gestito da Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Ulteriori informazioni';

  @override
  String get product_page_tab_folksonomy => 'Folksonomia';

  @override
  String get folksonomy_explanation_card_title =>
      'Quali sono gli attributi della folksonomia?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Gli attributi sono basati su **chiave-valore**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Queste proprietà vengono create e archiviate dai contributori per qualsiasi tipo di utilizzo.';

  @override
  String get folksonomy_action_external_link_title =>
      'Apri collegamento esterno';

  @override
  String get folksonomy_action_external_link_warning =>
      'I link esterni potrebbero non essere sicuri. Vuoi davvero visitarli?';

  @override
  String get prices_products_empty_title => 'Nessun prezzo disponibile';

  @override
  String get prices_products_empty_explanation => 'Sii il primo a contribuire!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'I migliori $pageSize prodotti (totale: $total)';
  }

  @override
  String get app_review_title => 'Ti piace questa app?';

  @override
  String get app_review_low => 'Potrebbe fare di meglio';

  @override
  String get app_review_medium => 'Non male';

  @override
  String get app_review_high => 'Lo adoro!';

  @override
  String get app_review_feedback_modal_title =>
      'Aiutaci a migliorare la nostra applicazione';

  @override
  String get app_review_feedback_modal_content =>
      'Se hai qualche minuto, potresti rispondere a questo modulo in modo che **possiamo migliorare nei futuri aggiornamenti**:';

  @override
  String get app_review_feedback_modal_open_form => 'Rispondi al modulo';

  @override
  String get app_review_feedback_modal_later => 'Chiedimelo più tardi';

  @override
  String get nutrition_facts_extract_new =>
      'NOVITÀ: puoi estrarre automaticamente i nutrienti dall\'immagine!';

  @override
  String get nutrition_facts_extract_button_text => 'Estrai ora';

  @override
  String get nutrition_facts_extract_in_progress => 'Estrazione in corso…';

  @override
  String get nutrition_facts_extract_successful => 'Estrazione riuscita';

  @override
  String get nutrition_facts_extract_failed =>
      'Impossibile estrarre i nutrienti dall\'immagine';

  @override
  String get prices_discount => 'Sconto';

  @override
  String get prices_stats_statistics => 'Statistiche';

  @override
  String get prices_stats_title => 'Statistiche sui prezzi';

  @override
  String get prices_stats_prices_section => 'Prezzi';

  @override
  String get prices_stats_products_section => 'Prodotti';

  @override
  String get prices_stats_locations_section => 'Posizioni';

  @override
  String get prices_stats_proofs_section => 'Prove';

  @override
  String get prices_stats_contributors_section => 'Contributori';

  @override
  String get prices_stats_experiments_section => 'Esperimenti';

  @override
  String get prices_stats_misc_section => 'Varie';

  @override
  String get prices_stats_total => 'Totale';

  @override
  String get prices_stats_with_barcode => 'Con un codice a barre';

  @override
  String get prices_stats_with_category => 'Con una categoria';

  @override
  String get prices_stats_with_discount => 'Con uno sconto';

  @override
  String get prices_stats_community => 'Comunità';

  @override
  String get prices_stats_consumption => 'Consumo';

  @override
  String get prices_stats_with_price => 'Con un prezzo';

  @override
  String get prices_stats_food => 'Cibo';

  @override
  String get prices_stats_beauty => 'Bellezza';

  @override
  String get prices_stats_products => 'Prodotti';

  @override
  String get prices_stats_pet_food => 'Cibo per animali domestici';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Paesi';

  @override
  String get prices_stats_price_tag => 'Etichetta del prezzo';

  @override
  String get prices_stats_receipt => 'Ricevuta';

  @override
  String get prices_stats_gdpr_request => 'Richiesta RGPD';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Sfide';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Prezzi collegati a un cartellino del prezzo';

  @override
  String get prices_stats_currencies => 'Valute';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prezzi e prove per fonte';

  @override
  String get prices_stats_website => 'Sito web';

  @override
  String get prices_stats_mobile_app => 'App mobile';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Altro';

  @override
  String get prices_stats_last_updated => 'Ultimo aggiornamento il';

  @override
  String get prices_stats_error =>
      'Si è verificato un errore durante il caricamento delle statistiche.';

  @override
  String get product_edit_robotoff_question_answered => 'Domanda con risposta!';

  @override
  String get product_edit_robotoff_proof => 'Prova';

  @override
  String get preferences_card_general => 'Generale';

  @override
  String get preferences_prices_title => 'Prezzi';

  @override
  String get preferences_prices_subtitle =>
      'Gestisci le tue preferenze sui prezzi';

  @override
  String get preferences_card_project => 'Il progetto Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribuire';

  @override
  String get preferences_my_contributions_title => 'I miei contributi';

  @override
  String get preferences_my_stats_title => 'Le mie statistiche';

  @override
  String get preferences_contribute_subtitle =>
      'Traduci, migliora i nostri strumenti…';

  @override
  String get preferences_connect_title => 'Collegare';

  @override
  String get preferences_connect_subtitle =>
      'Contattaci o seguici sui social media';

  @override
  String get preferences_support_title => 'Fai una donazione';

  @override
  String get preferences_support_subtitle =>
      'Aiutaci a informare milioni di consumatori in tutto il mondo';

  @override
  String get preferences_card_help => 'Aiuto e supporto';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle => 'Ottieni risposte alle tue domande';

  @override
  String get logged_out => 'Disconnesso';

  @override
  String get preferences_app_bar_message =>
      'Grazie per essere uno dei nostri membri!';

  @override
  String get preferences_app_bar_products_modified => 'Prodotti modificati';

  @override
  String get preferences_app_bar_prices_added => 'Prezzi aggiunti';

  @override
  String get preferences_app_bar_see_all_stats => 'Vedi tutte le statistiche';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Cerca $provider per \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Cerca un\'impostazione (ad esempio Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Accessibilità: Mostra emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Accessibilità: Rimuovi colori';

  @override
  String get preferences_app_settings_products => 'Prodotti';

  @override
  String get preferences_card_about => 'Informazioni';

  @override
  String get preferences_legal_information_title => 'Informazioni legali';

  @override
  String get preferences_legal_information_subtitle =>
      'Termini di utilizzo, informativa sulla privacy e altro ancora';

  @override
  String get preferences_terms_of_use => 'Condizioni d\'uso';

  @override
  String get preferences_legal_mentions => 'Menzioni legali';

  @override
  String get preferences_legal_header =>
      'Open Food Facts è un database di prodotti alimentari **creato da tutti, per tutti**.\nPuoi usarlo per fare scelte alimentari migliori e, poiché si tratta di **dati aperti**, chiunque può **riutilizzarli per qualsiasi scopo**.';

  @override
  String get preferences_privacy_policy => 'Informativa sulla privacy';

  @override
  String get preferences_licenses => 'Licenze';

  @override
  String get preferences_about_app_title => 'Informazioni sull\'app';

  @override
  String get preferences_about_app_subtitle =>
      'Informazioni tecniche, informazioni per gli sviluppatori e altro ancora';

  @override
  String get preferences_card_information => 'Informazioni';

  @override
  String get preferences_version_number_title => 'Numero di versione';

  @override
  String get preferences_scanner_title => 'Scanner';

  @override
  String get preferences_app_store => 'App store';

  @override
  String get preferences_app_system_settings => 'Impostazioni di sistema';

  @override
  String get preferences_source_code => 'Accedi al codice sorgente';

  @override
  String get preferences_source_code_subtitle =>
      'E inizia ad avere un impatto per milioni di persone';

  @override
  String get preferences_add_prices => 'Aggiungi prezzi';

  @override
  String get preferences_complete_products => 'Completa i prodotti';

  @override
  String get preferences_tips => 'Suggerimenti';

  @override
  String get tips_discover_nutriscore => 'Scopri il nuovo Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle => 'Sul sito Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Gestisci il mio account';

  @override
  String get preferences_manage_account_tooltip => 'Gestisci il tuo account';

  @override
  String get preferences_change_password_title => 'Cambia la mia password';

  @override
  String get preferences_danger_zone => 'Zona pericolosa';

  @override
  String get preferences_account_deletion_subtitle =>
      'Tutti i tuoi contributi andranno persi';

  @override
  String get preferences_contributions_title => 'Contributi';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Impostazioni dell\'app';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Un modo molto sperimentale per scansionare i prodotti offline';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Aggiorna tutti i prodotti dal server';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Si prega di evitare di farlo a meno che non sia assolutamente necessario';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Modalità demo';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Aggiungi le carte allo scanner';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Aggiunge 3 prodotti campione allo scanner';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Ospite di Folksonomia';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Ospite: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Esperimenti di accessibilità';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Selezione multi-prodotto per prezzi';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Pannelli informativi ordinati dall\'utente';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Accesso temporaneo alla ricerca della posizione';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Confronto affiancato per 2 o 3 prodotti';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Importazione elenco prodotti';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Punteggi e metodologie';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Scopri come viene calcolato il Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Scopri le principali modifiche alla metodologia';

  @override
  String get preferences_faq_discover_project_title => 'Scopri il progetto';

  @override
  String get preferences_faq_discover_off_title => 'Scopri Open Food Facts';

  @override
  String get preferences_faq_discover_obf_title => 'Scopri Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Scopri Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Scopri i Open Prices';

  @override
  String get preferences_faq_discover_opf_title => 'Scopri Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'FAQ - Domande frequenti';

  @override
  String get preferences_faq_off_ngo_title => 'La ONG Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informazioni';

  @override
  String get preferences_connect_community_updates_title =>
      'Ricevi aggiornamenti dalla community';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Rimani aggiornato sulle novità delle app e della community';

  @override
  String get preferences_connect_community_calendar_title =>
      'Iscriviti al calendario della nostra comunità';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Partecipa a uno dei nostri eventi virtuali';

  @override
  String get preferences_connect_blog_title => 'Il blog Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Ricevi le ultime notizie, non appena accadono';

  @override
  String get preferences_connect_community_help_title =>
      'Ottieni aiuto dalla comunità';

  @override
  String get preferences_connect_improve_app_title =>
      'Aiutaci a migliorare l\'app';

  @override
  String get preferences_connect_debug_info_title =>
      'Inviaci informazioni di debug';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Inviaci un\'e-mail con informazioni dettagliate sul debug';

  @override
  String get preferences_connect_feedback_title =>
      'Inviaci un feedback sull\'app';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Aiutaci a dare forma al futuro dell\'app';

  @override
  String get preferences_connect_survey_title =>
      'Partecipa al sondaggio sull\'app';

  @override
  String get preferences_connect_survey_subtitle =>
      'Aiutaci a capire cosa dovremmo costruire dopo';

  @override
  String get preferences_connect_professionals_title => 'Professionisti';

  @override
  String get preferences_connect_pro_subtitle =>
      'Completamente gratuito, garantisce dati accurati per 500 app e milioni di consumatori. Self-service, compatibile con il tuo PIM o fogli di calcolo (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Contattaci per iniziare';

  @override
  String get preferences_connect_press_title => 'Stampa se';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Ottieni tutto il materiale necessario per il tuo report';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Contattaci per richieste di stampa o per farci sapere del tuo reportage';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Diventa un volontario attivo';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Sviluppo, Comunicazione, Design… qualsiasi tipo di volontariato o competenza è benvenuta!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Scopri alcuni dei tanti modi in cui puoi contribuire';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Sviluppo di app per dispositivi mobili';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Scopri come contribuire allo sviluppo del software';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Build instabili giornaliere, nuove funzionalità';

  @override
  String get preferences_contribute_local_community_title =>
      'Fai crescere la tua comunità locale';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Aiuto con traduzioni di software, contenuti e analisi degli ingredienti';

  @override
  String get preferences_contribute_share_subtitle =>
      'Abbiamo preparato un piccolo modello per aiutarti :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Semplici passi per aumentare la trasparenza alimentare nel tuo Paese';

  @override
  String get preferences_contribute_data_quality_title => 'Qualità dei dati';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Unisciti al team della qualità dei dati';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Unisciti al nostro impegno per garantire che il database sia completo e accurato';

  @override
  String get preferences_contributions_products_added_title =>
      'Prodotti aggiunti';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nuovi prodotti che ho aggiunto a Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Prodotti che devo completare';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Tutti i prodotti incompleti';

  @override
  String get preferences_my_contributions_prices_title => 'Prezzi';

  @override
  String get preferences_my_contributions_my_prices_title => 'I miei prezzi';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'I miei prezzi, le mie prove…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Prodotti che puoi aiutare a completare';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Aiutaci a calcolare il Nutri-Score e il Green-Score nel tuo Paese';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Prezzi a cui ho contribuito';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Cartellini dei prezzi e ricevute';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Scatta foto delle tue ricevute e scansiona i codici a barre associati';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Scatta foto dei prezzi in un negozio';

  @override
  String get preferences_prices_newest_title => 'Prezzi più recenti';

  @override
  String get preferences_prices_newest_subtitle =>
      'Ultimi prezzi aggiunti dalla community Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'I contributori con i prezzi più alti';

  @override
  String get preferences_prices_metrics_title => 'Metriche del prezzo aperto';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Segui l\'evoluzione del progetto';

  @override
  String get preferences_prices_ways_contribute_title => 'Modi per contribuire';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Conferma i prezzi aggiunti da te o da altri, con l\'aiuto dell\'intelligenza artificiale';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Aggiungi rapidamente numerose ricevute o foto di scaffali dal rullino della tua fotocamera';

  @override
  String get preferences_prices_challenges_title => 'Sfide mensili';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Partecipa alle missioni tematiche mensili per raccogliere i premi';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Recupera i tuoi dati fedeltà';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Scopri come richiedere i tuoi dati';

  @override
  String get preferences_page_customize_app_title => 'Personalizza l\'app';

  @override
  String get preferences_page_contribute_project_title =>
      'Contribuisci al progetto';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Modi semplici per aiutare Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodologie di punteggio, assistenza e altro sul progetto';

  @override
  String get product_edit_robotoff_positive_button => 'Accetta il suggerimento';

  @override
  String get product_edit_robotoff_negative_button => 'Rifiuta suggerimento';

  @override
  String get product_edit_robotoff_show_proof => 'Mostra prova';

  @override
  String get product_edit_robotoff_expand_proof => 'Espandi prova';

  @override
  String get product_page_tab_raw_data => 'dati grezzi';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Pagina $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Pagina $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count di $total elementi';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count di $total elementi';
  }

  @override
  String item_count(int count) {
    return '$count elementi';
  }

  @override
  String item_count_string(String count) {
    return '$count elementi';
  }

  @override
  String get prices_no_result => 'Nessuna statistica sui prezzi trovata.';

  @override
  String get prices_error_loading_more_items =>
      'Errore durante il caricamento di altri elementi';

  @override
  String get prices_proof_error =>
      'Autenticazione fallita, impossibile recuperare le prove';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count di $total prove';
  }

  @override
  String proof_count(int count) {
    return '$count prove';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count di $total collaboratori';
  }

  @override
  String contributors_count(int count) {
    return '$count contributori';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count di $total posizioni';
  }

  @override
  String prices_locations_count(int count) {
    return '$count posizioni';
  }

  @override
  String get restart_to_apply_message =>
      'Riavvia l\'app per applicare le modifiche.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Interfaccia grafica';

  @override
  String get preferences_app_settings_media_title => 'Media';

  @override
  String get preferences_about_app_development_title => 'Sviluppo';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Open Food Facts Labs';

  @override
  String get preferences_root_account_title => 'Profilo';

  @override
  String get preferences_contribute_translate_header =>
      'Porta Open Food Facts nella tua lingua';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Iscriviti alla versione alfa dell\'app';

  @override
  String get preferences_dev_mode_section_data =>
      'Contributi e dati di prodotto';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Non mostrare Folksonomia';

  @override
  String get preferences_account_title => 'Profilo';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Aggiunto il $created';
  }

  @override
  String get location_map_details_title => 'Dettagli sulla posizione';

  @override
  String get location_map_details_name => 'Nome';

  @override
  String get location_map_details_street => 'Strada';

  @override
  String get location_map_details_city => 'Città';

  @override
  String get location_map_details_postcode => 'Codice postale';

  @override
  String get location_map_details_country => 'Paese';

  @override
  String get location_map_details_coordinates => 'Coordinate';

  @override
  String get location_map_details_osm_id => 'ID OSM';
}
