// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Icelandic (`is`).
class AppLocalizationsIs extends AppLocalizations {
  AppLocalizationsIs([String locale = 'is']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Yes';

  @override
  String get add => 'Bæta við';

  @override
  String get account_delete_message =>
      'Ertu viss um að þú viljir eyða aðganginum þínum?\nEf það er sérstök ástæða, vinsamlegast deildu henni hér að neðan.';

  @override
  String get reason => 'Ástæða';

  @override
  String get okay => 'Allt í lagi';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'Búa til';

  @override
  String get applyButtonText => 'Apply';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'Halda áfram';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'Fara aftur efst';

  @override
  String get save => 'Save';

  @override
  String get save_confirmation => 'Ertu viss um að þú viljir vista?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Cancel';

  @override
  String get ignore => 'Hunsa';

  @override
  String get close => 'Close';

  @override
  String get no => 'No';

  @override
  String get stop => 'Stöðva';

  @override
  String get finish => 'Ljúka';

  @override
  String get calculate => 'Reikna';

  @override
  String get reset_food_prefs => 'Endurstilla matarstillingar';

  @override
  String get error => 'Eitthvað fór úrskeiðis';

  @override
  String get error_occurred => 'Villa kom upp';

  @override
  String get featureInProgress =>
      'Við erum enn að vinna í þessum eiginleika, fylgist með';

  @override
  String get label_web => 'Skoða á vefnum';

  @override
  String get learnMore => 'Frekari upplýsingar';

  @override
  String get unknown => 'Óþekkt';

  @override
  String get match_very_good => 'Mjög góð samsvörun';

  @override
  String get match_good => 'Góð samsvörun';

  @override
  String get match_poor => 'Léleg samsvörun';

  @override
  String get match_may_not => 'May not match';

  @override
  String get match_does_not => 'Passar ekki saman';

  @override
  String get match_unknown => 'Óþekkt samsvörun';

  @override
  String get match_short_very_good => 'Mjög góð samsvörun';

  @override
  String get match_short_good => 'Góð samsvörun';

  @override
  String get match_short_poor => 'Léleg samsvörun';

  @override
  String get match_short_may_not => 'May not match';

  @override
  String get match_short_does_not => 'Passar ekki saman';

  @override
  String get match_short_unknown => 'Óþekkt samsvörun';

  @override
  String get licenses => 'Leyfi';

  @override
  String get looking_for => 'Að leita að';

  @override
  String get welcomeToOpenFoodFacts => 'Velkomin(n) í Opna matarstaðreyndir';

  @override
  String get whatIsOff =>
      'Open Food Facts er alþjóðleg, hagnaðarlaus stofnun sem er rekin af heimamönnum.';

  @override
  String get productDataUtility =>
      'Sjáðu matargögnin sem tengjast þínum óskum.';

  @override
  String get healthCardUtility => 'Veldu matvæli sem eru góð fyrir þig.';

  @override
  String get ecoCardUtility => 'Veldu matvæli sem eru góð fyrir plánetuna.';

  @override
  String get server_error_open_new_issue =>
      'Engin svörun frá netþjóni! Þú gætir opnað vandamál með eftirfarandi tengli.';

  @override
  String get sign_in_text =>
      'Skráðu þig inn á Open Food Facts reikninginn þinn til að vista framlög þín';

  @override
  String get incorrect_credentials => 'Rangt notandanafn eða lykilorð.';

  @override
  String get password_lost_incorrect_credentials =>
      'Þetta netfang eða notandanafn er ekki til. Vinsamlegast athugaðu innskráningarupplýsingar þínar.';

  @override
  String get password_lost_server_unavailable =>
      'Við erum að upplifa hægagangi á netþjónum okkar og biðjumst afsökunar á því. Vinsamlegast reynið aftur síðar.';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable =>
      'Netið er ekki aðgengilegt';

  @override
  String get login_result_type_server_issue =>
      'Vandamál á netþjóninum. Reyndu aftur síðar.';

  @override
  String get login_page_username_or_email =>
      'Vinsamlegast sláðu inn notandanafn eða netfang';

  @override
  String get login_page_password_error_empty =>
      'Vinsamlegast sláðu inn lykilorð';

  @override
  String get create_account => 'Stofna reikning';

  @override
  String get sign_in => 'Innskráning';

  @override
  String get sign_in_mandatory =>
      'Til að nota þann eiginleika þurfum við að þú skráir þig inn.';

  @override
  String get help_improve_country =>
      'Hjálpaðu til við að bæta Open Food Facts í þínu landi';

  @override
  String get sign_out => 'Skrá út';

  @override
  String get sign_out_confirmation => 'Ertu viss um að þú viljir skrá þig út?';

  @override
  String get password => 'Lykilorð';

  @override
  String get forgot_password => 'Gleymt lykilorð';

  @override
  String get forgot_password_question => 'Gleymt lykilorð?';

  @override
  String get view_profile => 'Skoða prófíl';

  @override
  String get reset_password => 'Endurstilla lykilorð';

  @override
  String get reset_password_explanation_text =>
      'Ef þú gleymir lykilorðinu skaltu slá inn notandanafn eða netfang til að fá leiðbeiningar um endurstillingu lykilorðsins. Mundu einnig að athuga ruslpóstmöppuna.';

  @override
  String get username_or_email => 'Notandanafn eða netfang';

  @override
  String get reset_password_done =>
      'Tölvupóstur með tengli til að endurstilla lykilorðið þitt hefur verið sendur á netfangið sem tengist reikningnum þínum. Athugaðu einnig ruslpóstinn þinn.';

  @override
  String get send_reset_password_mail => 'Breyta lykilorði';

  @override
  String get enter_some_text => 'Vinsamlegast sláðu inn texta';

  @override
  String get sign_up_page_title => 'Skráning';

  @override
  String get sign_up_page_action_button => 'Skráning';

  @override
  String get sign_up_page_action_doing_it => 'Skráning…';

  @override
  String get sign_up_page_action_ok =>
      'Til hamingju! Aðgangurinn þinn hefur verið stofnaður.';

  @override
  String get sign_up_page_display_name_hint => 'Nafn';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Vinsamlegast sláðu inn birtingarheitið sem þú vilt nota';

  @override
  String get sign_up_page_email_hint => 'Netfang';

  @override
  String get sign_up_page_email_error_empty => 'Netfang er krafist';

  @override
  String get sign_up_page_email_error_invalid => 'Ógilt netfang';

  @override
  String get sign_up_page_username_hint => 'Notandanafn: Sýnilegt opinberlega';

  @override
  String get sign_up_page_username_error_empty =>
      'Vinsamlegast sláðu inn notandanafn';

  @override
  String get sign_up_page_username_error_invalid =>
      'Vinsamlegast sláðu inn gilt notandanafn';

  @override
  String get sign_up_page_username_description =>
      'Username cannot contains spaces, caps or special characters.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Notandanafn má ekki vera lengra en $value stafir';
  }

  @override
  String get sign_up_page_password_hint => 'Lykilorð';

  @override
  String get sign_up_page_password_error_empty =>
      'Vinsamlegast sláðu inn lykilorð';

  @override
  String get sign_up_page_password_error_invalid =>
      'Vinsamlegast sláðu inn gilt lykilorð (að minnsta kosti 6 stafir)';

  @override
  String get sign_up_page_confirm_password_hint => 'Staðfesta lykilorð';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Vinsamlegast staðfestu lykilorðið';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Lykilorðin stemma ekki';

  @override
  String get sign_up_page_agree_text => 'Ég samþykki Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'notkunarskilmálar og framlag';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Þegar aðgangur er stofnaður er nauðsynlegt að samþykkja notkunarskilmálana, en samt er hægt að leggja fram nafnlaust framlag í gegnum appið.';

  @override
  String get sign_up_page_producer_checkbox => 'Ég er matvælaframleiðandi';

  @override
  String get sign_up_page_producer_hint => 'Framleiðandi/vörumerki';

  @override
  String get sign_up_page_producer_error_empty =>
      'Vinsamlegast sláðu inn framleiðanda eða vörumerki';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Ég vil gerast áskrifandi að fréttabréfi Open Food Facts (þú getur sagt upp áskrift hvenær sem er)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Notandanafnið er þegar til, vinsamlegast veldu annað notandanafn.';

  @override
  String get sign_up_page_email_already_exists =>
      'er þegar til, skráðu þig inn á reikninginn eða reyndu með öðru netfangi.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Vinsamlegast gefðu upp gilt netfang.';

  @override
  String get sign_up_page_server_busy =>
      'Við biðjumst innilega afsökunar en það hafa komið upp tæknilegir erfiðleikar við að stofna aðganginn þinn. Reyndu aftur síðar.';

  @override
  String get settingsTitle => 'Stillingar';

  @override
  String get darkmode => 'Þema';

  @override
  String get darkmode_dark => 'Dökkt';

  @override
  String get darkmode_light => 'Ljós';

  @override
  String get darkmode_system_default => 'Sjálfgefið kerfi';

  @override
  String get thanks_for_contributing => 'Takk fyrir að leggja þitt af mörkum!';

  @override
  String get contributors_label => 'Þeir eru að smíða appið';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Framlag: $name';
  }

  @override
  String get contributors_description =>
      'Listi yfir alla sem hafa lagt sitt af mörkum í þessu forriti';

  @override
  String get support => 'Stuðningur';

  @override
  String get support_join_slack => 'Biddu um hjálp í Slack-rásinni okkar';

  @override
  String get support_via_forum => 'Biðjið um hjálp á spjallborðinu okkar';

  @override
  String get support_via_email => 'Sendu okkur tölvupóst';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Senda forritaskrár?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Viltu hafa með forritaskrár í viðhengi með tölvupóstinum þínum?';

  @override
  String get termsOfUse => 'Notkunarskilmálar';

  @override
  String get legalNotices => 'Löglegar tilkynningar';

  @override
  String get privacy_policy => 'Persónuverndarstefna';

  @override
  String get about_this_app => 'Um þetta forrit';

  @override
  String get contribute => 'Contribute';

  @override
  String get contribute_sw_development => 'Hugbúnaðarþróun';

  @override
  String get contribute_develop_text =>
      'Kóðinn fyrir allar vörur frá Open Food Facts er aðgengilegur á GitHub. Þér er velkomið að endurnýta kóðann (hann er opinn hugbúnaður) og hjálpa okkur að bæta hann, fyrir alla, á öllum vettvangi.';

  @override
  String get contribute_develop_text_2 =>
      'Þú getur tekið þátt í spjallrásinni Open Food Facts Slack sem er vinsælasti vettvangurinn til að spyrja spurninga.';

  @override
  String get contribute_develop_dev_mode_title => 'DEV-stilling?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Virkjaðu DEV-stillinguna';

  @override
  String get contribute_donate_title => 'Donate';

  @override
  String get contribute_donate_header => 'Gefðu til Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Vinsamlegast athugið að með innbyggðri alfaútgáfu er mögulegt að gagnatap verði algjört og appið gæti orðið ónothæft hvenær sem er!';

  @override
  String get contribute_improve_ProductsToBeCompleted => 'Vörur sem á að klára';

  @override
  String get contribute_improve_header => 'Að bæta sig';

  @override
  String get contribute_improve_text =>
      'Gagnagrunnurinn er kjarninn í verkefninu. Það er auðvelt og mjög fljótlegt að hjálpa til. Þú getur sótt smáforritið fyrir símann þinn og byrjað að bæta við eða bæta vörur.\n\nHins vegar býður vefsíðan Open Food Facts upp á margar leiðir til að leggja sitt af mörkum: ';

  @override
  String get contribute_translate_header => 'Þýða';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Byrjaðu að þýða';

  @override
  String get contribute_translate_text =>
      'Open Food Facts er alþjóðlegt verkefni sem inniheldur vörur frá meira en 160 löndum. Open Food Facts er þýtt á tugi tungumála og efni er í stöðugri þróun.';

  @override
  String get contribute_translate_text_2 =>
      'Þýðingar eru eitt af lykilverkefnum verkefnisins';

  @override
  String get contribute_join_skill_pool =>
      'Leggðu fram færni þína til Open Food Facts. Skráðu þig í færnihópinn!';

  @override
  String get contribute_share_header =>
      'Deildu Open Food Facts með vinum þínum';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Leggðu til verð með því að óska eftir útflutningi á gögnum um tryggðarkort samkvæmt GDPR';

  @override
  String get tap_to_answer => 'Ýttu hér til að svara spurningum';

  @override
  String get tap_to_answer_hint =>
      'Ýttu hér til að svara spurningum um þessa vöru';

  @override
  String get robotoff_questions_loading_hint =>
      'Vinsamlegast bíðið á meðan spurningar um þessa vöru eru hlaðnar inn';

  @override
  String get saving_answer => 'Vistar svarið þitt';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Skráðu þig inn á Open Food Facts reikninginn þinn til að fá inneign fyrir framlag þitt';

  @override
  String get question_yes_button_accessibility_value => 'Svaraðu með já';

  @override
  String get question_no_button_accessibility_value => 'Svara með nei';

  @override
  String get question_skip_button_accessibility_value =>
      'Sleppa þessari spurningu';

  @override
  String get tap_to_edit_search => 'Ýttu til að breyta leit';

  @override
  String get myPreferences => 'Mínar óskir';

  @override
  String get account_create_message =>
      'Stofnaðu aðgang og skráðu þig í Open Food Facts samfélagið til að hjálpa til við að byggja upp þekkingu á mat um allan heim!';

  @override
  String get join_us => 'Vertu með okkur';

  @override
  String get myPreferences_profile_title => 'Prófíllinn þinn';

  @override
  String get myPreferences_profile_subtitle =>
      'Stjórnaðu aðganginum þínum að Open Food Facts sem framlag.';

  @override
  String get myPreferences_settings_title => 'Stillingar forrits';

  @override
  String get myPreferences_settings_subtitle => 'Dökk stilling, Tungumál…';

  @override
  String get myPreferences_food_title => 'Matarval';

  @override
  String get myPreferences_food_subtitle =>
      'Veldu hvaða upplýsingar um mat skipta þig mestu máli.';

  @override
  String get myPreferences_food_comment =>
      'Veldu hvaða upplýsingar um mat skipta þig mestu máli til að raða mat eftir óskum þínum, sjá upplýsingarnar sem þér skipta fyrst máli og fá samhæfingaryfirlit. Þessar mataróskir eru geymdar á tækinu þínu og eru ekki tengdar við Open Food Facts reikninginn þinn ef þú ert með einn.';

  @override
  String get confirmResetPreferences => 'Endurstilla matarstillingarnar þínar?';

  @override
  String get myPersonalizedRanking => 'Persónulega röðun mín';

  @override
  String get ranking_tab_all => 'All';

  @override
  String get ranking_subtitle_match_yes => 'Frábær samsvörun fyrir þig';

  @override
  String get ranking_subtitle_match_no => 'Mjög léleg samsvörun';

  @override
  String get ranking_subtitle_match_maybe => 'Óþekkt samsvörun';

  @override
  String get refresh_with_new_preferences =>
      'Endurnýja listann með nýju stillingunum þínum';

  @override
  String get reloaded_with_new_preferences =>
      'Endurhlaðið með nýju stillingunum þínum';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Skanna';

  @override
  String get history_navbar_label => 'Saga';

  @override
  String get list_navbar_label => 'Listar';

  @override
  String get category => 'Sía eftir flokki';

  @override
  String get category_all => 'All';

  @override
  String get category_search => '(leit að flokki)';

  @override
  String get filter => 'Sía';

  @override
  String get scan => 'Vörur af skannaskjánum';

  @override
  String get scan_history => 'Skannasögu';

  @override
  String get search => 'Search';

  @override
  String get search_product_help => 'Leita að vöru,\nvörumerki eða strikamerki';

  @override
  String get search_filter => 'Leitarsía';

  @override
  String get search_history => 'Leitarsaga';

  @override
  String get search_store => 'Leita að verslun';

  @override
  String get search_store_help => 'Vísbending: Bættu við borg eða landi';

  @override
  String get tap_for_more => 'Ýttu til að sjá frekari upplýsingar…';

  @override
  String get product => 'Product';

  @override
  String get unknownBrand => 'Óþekkt vörumerki';

  @override
  String get unknownQuantity => 'Óþekkt magn';

  @override
  String get unknownProductName => 'Óþekkt vöruheiti';

  @override
  String get label_refresh => 'Refresh';

  @override
  String get label_reload => 'Endurhlaða';

  @override
  String get image => 'Mynd';

  @override
  String get front_photo => 'Mynd að framan';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (þessi mynd gæti verið úrelt)';
  }

  @override
  String get outdated_image_short_label => 'gæti verið úrelt';

  @override
  String get ingredients => 'Innihald';

  @override
  String get ingredients_editing_instructions =>
      'Haldið upprunalegu röðinni. Tilgreinið prósentu ef hún er tilgreind. Aðskiljið með kommu eða bandstriki og notið sviga fyrir innihaldsefni innihaldsefnis.';

  @override
  String get ingredients_editing_error => 'Mistókst að vista hráefnin.';

  @override
  String get ingredients_editing_image_error =>
      'Mistókst að fá nýja mynd af innihaldsefnum.';

  @override
  String get ingredients_editing_title => 'Breyta innihaldsefnum';

  @override
  String get ingredients_photo => 'Mynd af innihaldsefnum';

  @override
  String get packaging_editing_instructions =>
      'Teljið upp alla umbúðahluta, aðskilda með kommu eða línuskiptingu, ásamt magni (t.d. 1 eða 6), gerð (t.d. flaska, kassi, dós), efni (t.d. plast, málmur, ál) og ef mögulegt er, stærð (t.d. 33 cl) og leiðbeiningum um endurvinnslu.\nDæmi: 1 glerflaska til endurvinnslu, 1 plasttappi til að farga.';

  @override
  String get packaging_editing_error => 'Mistókst að vista umbúðirnar.';

  @override
  String get packaging_editing_image_error =>
      'Mistókst að fá nýja mynd af umbúðunum.';

  @override
  String get packaging_editing_title => 'Breyta umbúðum';

  @override
  String get nutrition => 'Næring';

  @override
  String get nutrition_facts_photo => 'Næringarupplýsingar mynd';

  @override
  String get nutrition_facts_editing_title => 'Breyta næringarupplýsingum';

  @override
  String get packaging_information => 'Leiðbeiningar um endurvinnslu';

  @override
  String get packaging_information_photo =>
      'Mynd af leiðbeiningum um endurvinnslu';

  @override
  String get missing_product => 'Þú fannst nýja vöru!';

  @override
  String get add_product_take_photos =>
      'Taktu myndir af umbúðunum til að bæta þessari vöru við Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Vinsamlegast taktu nokkrar myndir fyrst. Þú getur alltaf klárað vöruna síðar.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'Ný vara';

  @override
  String get new_product_found_title => 'Ný vara fundin!';

  @override
  String get new_product_found_text =>
      'Samvinnugagnagrunnur okkar inniheldur meira en **3 milljónir vara**, en þetta strikamerki er ekki til: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'Yfirgefa þessa síðu?';

  @override
  String get new_product_leave_message =>
      'Það lítur út fyrir að þú hafir ekki slegið neitt inn. Viltu virkilega fara af þessari síðu?';

  @override
  String get new_product_dialog_description =>
      'Vinsamlegast takið myndir af umbúðunum til að bæta þessari vöru við sameiginlegan gagnagrunn okkar.';

  @override
  String get new_product_dialog_illustration_description =>
      'Myndskreyting með óþekktum næringarstigum og grænum stigum';

  @override
  String get front_packaging_photo_button_label => 'Mynd af framhlið umbúða';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Staðfesta upphleðslu myndar af framhlið umbúða';

  @override
  String get confirm_button_label => 'Staðfesta';

  @override
  String get send_image_button_label => 'Senda mynd';

  @override
  String get crop_page_action_saving => 'Vistar myndina…';

  @override
  String get crop_page_action_cropping => 'Skerið myndina…';

  @override
  String get crop_page_action_local => 'Vista staðbundna útgáfu…';

  @override
  String get crop_page_action_local_failed_title =>
      'Úbbs… það er eitthvað við myndina þína!';

  @override
  String get crop_page_action_local_failed_message =>
      'Við getum ekki unnið úr myndinni staðbundið áður en við sendum hana á netþjóninn okkar. Vinsamlegast reynið aftur síðar eða hafið samband við okkur ef vandamálið heldur áfram.';

  @override
  String get crop_page_action_retake => 'Taka mynd aftur';

  @override
  String get crop_page_too_small_image_title => 'Myndin er of lítil!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Lágmarksstærð í pixlum til að hlaða upp myndum er ${expectedMinWidth}x$expectedMinHeight. Núverandi mynd er ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Undirbýr símtal til netþjónsins…';

  @override
  String get front_packaging_photo_title => 'Mynd af framhlið umbúða';

  @override
  String get ingredients_photo_title => 'Innihaldsefni Mynd';

  @override
  String get nutritional_facts_photo_title => 'Næringarupplýsingar Mynd';

  @override
  String get recycling_photo_title => 'Leiðbeiningar um endurvinnslu Mynd';

  @override
  String get take_photo_title => 'Take a picture';

  @override
  String get take_more_photo_title => 'Take more photos';

  @override
  String get front_photo_uploaded => 'Mynd að framan hlaðið inn';

  @override
  String get ingredients_photo_button_label => 'Mynd af innihaldsefnum';

  @override
  String get ingredients_photo_uploaded => 'Mynd af innihaldsefnum hlaðið upp';

  @override
  String get nutrition_cache_loading_error =>
      'Ekki tókst að hlaða næringarefnum úr skyndiminni';

  @override
  String get nutritional_facts_photo_button_label => 'Næringarupplýsingar mynd';

  @override
  String get nutritional_facts_input_button_label => 'Fylltu út næringargildi';

  @override
  String get nutritional_facts_added => 'Næringarupplýsingar bættar við';

  @override
  String get categories_added => 'Flokkar bætt við';

  @override
  String get new_product_title_nutriscore => 'Compute the Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Hjálpaðu okkur með því að fylla út að minnsta kosti einn flokk og næringargildi';

  @override
  String get new_product_title_environmental_score =>
      'Reiknaðu út græna stigið';

  @override
  String get new_product_subtitle_environmental_score =>
      'Fáðu það með því að fylla út að minnsta kosti einn flokk';

  @override
  String get new_product_additional_environmental_score =>
      'Gerðu útreikning á Grænu stigi nákvæmari með uppruna, umbúðum og fleiru';

  @override
  String get new_product_title_nova =>
      'Reiknaðu út matvælavinnslustigið (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Fáðu það með því að fylla út matvælaflokkinn og innihaldsefnin';

  @override
  String get new_product_desc_nova_unknown => 'Matvælavinnslustig óþekkt';

  @override
  String get new_product_title_pictures => 'Ný vara';

  @override
  String get new_product_title_pictures_details =>
      'Vinsamlegast taktu eftirfarandi myndir og Open Food Facts vélin getur fundið út restina!';

  @override
  String get new_product_title_misc => 'Og nokkur grunngögn…';

  @override
  String new_product_done_msg(String username) {
    return 'Takk fyrir framlag þitt „$username“!';
  }

  @override
  String get new_product_done_msg_no_user => 'Takk fyrir framlag þitt!';

  @override
  String get new_product_done_button_label => 'Uppgötvaðu fullunna vöruna';

  @override
  String get hey_incomplete_product_message =>
      'Ýttu til að svara 3 spurningum NÚNA til að reikna út næringarstig, grænt stig og öfgavinnslu (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Ýttu núna til að svara tveimur spurningum til að hjálpa þér að greina þessa snyrtivöru!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Ýttu núna til að svara 3 spurningum til að hjálpa þér að greina þessa gæludýrafóðurvöru!';

  @override
  String get hey_incomplete_product_message_product =>
      'Ýttu núna til að hjálpa til við að klára þessa vöru!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Mynd af næringarupplýsingum hlaðið upp';

  @override
  String get recycling_photo_button_label => 'Endurvinnslumynd';

  @override
  String get recycling_photo_uploaded => 'Mynd af endurvinnslu hlaðið upp';

  @override
  String get take_more_photo_button_label => 'Take more photos';

  @override
  String get other_photo_uploaded => 'Ýmis mynd hlaðið upp';

  @override
  String get retake_photo_button_label => 'Endurtaka';

  @override
  String get selecting_photo => 'Að velja mynd';

  @override
  String get uploading_image => 'Hleður upp mynd á netþjóninn';

  @override
  String get uploading_image_type_front =>
      'Hleður upp mynd að framan á Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Hleður upp mynd af innihaldsefnum í Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Hleður upp næringarmynd í Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Hleður upp mynd af umbúðum í Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Hleður upp annarri mynd í Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Hleður upp mynd í Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Bæta við innihaldsefnum sem vantar';

  @override
  String get score_add_missing_packaging_image =>
      'Bæta við mynd af umbúðum sem vantar';

  @override
  String get score_add_missing_nutrition_facts =>
      'Bæta við næringarupplýsingum sem vantar';

  @override
  String get score_add_missing_product_traces =>
      'Bæta við vörusporum sem vantar';

  @override
  String get score_add_missing_product_category => 'Veldu flokk';

  @override
  String get score_add_missing_precise_product_category =>
      'Veldu nákvæmari flokk';

  @override
  String get score_add_missing_product_countries =>
      'Bæta við vörulöndum sem vantar';

  @override
  String get score_add_missing_product_emb =>
      'Bæta við rekjanleikakóðum fyrir vörur sem vantar';

  @override
  String get score_add_missing_product_labels =>
      'Bæta við vörumerkjum sem vantar';

  @override
  String get score_add_missing_product_origins =>
      'Bæta við uppruna vöru sem vantar';

  @override
  String get score_add_missing_product_stores =>
      'Bæta við vöruverslunum sem vantar';

  @override
  String get score_add_missing_product_brands =>
      'Bæta við vörumerkjum sem vantar';

  @override
  String get score_update_nutrition_facts => 'Uppfæra næringargildi';

  @override
  String get nutrition_page_title => 'Næringarupplýsingar';

  @override
  String get nutrition_page_nutritional_info_title => 'Næringarupplýsingar';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Gildi sem tilgreind eru á vörunni:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Yes';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'No';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Opna mynd';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Góðar starfsvenjur: Næringarupplýsingar';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Stundum eru næringargildi **ekki tilgreind á umbúðum** eða á skjali sem fylgir vörunni. Í þessu tilfelli, og aðeins í þessu tilfelli, er hægt að stilla gildið á **NEI**.';

  @override
  String get nutrition_page_serving_type_label => 'Næringargildi:';

  @override
  String get nutrition_page_per_100g => 'í hverjum 100 g';

  @override
  String get nutrition_page_per_100g_100ml => 'á hverja 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'í hverjum skammti';

  @override
  String get nutrition_page_add_nutrient => 'Bætið við næringarefni';

  @override
  String get nutrition_page_serving_size => 'Skammtastærð';

  @override
  String get nutrition_page_serving_size_hint =>
      'Sláðu inn skammtastærð (t.d.: 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Góðar venjur: Skammtastærð';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Þetta gildi hjálpar til við að **gera hlutfallslega útreikninga á hverju næringarefni í hverjum skammti**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Leyfðar einingar** eru: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升., 公升.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** eða **60 G** (helst fyrsta valkosturinn)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** eða **1 l**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Ógild eining';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Ógildar einingar';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **nammi** og 2 **kex**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Vantar eining';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Ógilt númer';

  @override
  String get nutrition_page_update_running => 'Uppfærir vöruna á netþjóninum…';

  @override
  String get nutrition_page_update_done => 'Vara uppfærð!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Notið vörumagnið sem skammtastærð';

  @override
  String get nutrition_page_photo_error => 'Ekki tókst að hlaða myndinni';

  @override
  String get more_photos => 'Fleiri áhugaverðar myndir';

  @override
  String get view_more_photo_button =>
      'Skoða allar myndir sem fyrir eru af þessari vöru';

  @override
  String get no_product_found => 'Engin vara fannst';

  @override
  String get no_location_found => 'Engin staðsetning fannst';

  @override
  String get not_found => 'ekki fundið:';

  @override
  String get refreshing_product => 'Hressandi vara';

  @override
  String get product_refreshed => 'Vara endurnýjuð';

  @override
  String product_image_accessibility_label(String date) {
    return 'Mynd tekin $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Mynd tekin $date. Þessi mynd gæti verið úrelt.';
  }

  @override
  String get product_image_outdated => 'Þessi mynd gæti verið úrelt';

  @override
  String get product_image_outdated_explanations_title =>
      'Þessi mynd gæti verið úrelt';

  @override
  String get product_image_outdated_explanations_content =>
      'Þessi mynd var tekin fyrir meira en ári síðan.\n**Vinsamlegast athugið hvort hún sé enn uppfærð**.\n\nÞetta er **bara viðvörun**. Ef efnið er enn það sama geturðu hunsað þessi skilaboð.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Skipta út mynd ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Bæta við mynd ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Take a picture';

  @override
  String get product_image_action_from_gallery =>
      'Veldu úr myndasafni símans þíns';

  @override
  String get product_image_action_choose_existing_photo =>
      'Veldu úr vörumyndunum';

  @override
  String get product_image_details_label => 'Upplýsingar um myndina';

  @override
  String get product_image_details_from_producer => 'Frá framleiðandanum';

  @override
  String get product_image_details_contributor => 'Contributor';

  @override
  String get product_image_details_contributor_producer =>
      'Framleiðandi (framleiðandi)';

  @override
  String get product_image_details_date => 'Dagsetning';

  @override
  String get product_image_details_date_unknown => 'Óþekkt';

  @override
  String get homepage_main_card_logo_description =>
      'Velkomin(n) í Opna matarstaðreyndir';

  @override
  String get homepage_main_card_subheading =>
      '**Skanna** strikamerki eða\n**leita** að vöru';

  @override
  String get homepage_main_card_search_field_hint => 'Leita að vöru';

  @override
  String get homepage_main_card_search_field_tooltip => 'Hefja leit';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Nýjustu fréttir: $news_title';
  }

  @override
  String get tagline_app_review => 'Líkar þér appið?';

  @override
  String get tagline_app_review_button_positive => 'Ég elska þetta! 😍';

  @override
  String get tagline_app_review_button_negative => 'Ekki alveg…';

  @override
  String get tagline_app_review_button_later => 'Spyrðu mig síðar';

  @override
  String get tagline_feed_news_button => 'Vita meira';

  @override
  String get app_review_negative_modal_title => 'Líkar þér ekki appið okkar?';

  @override
  String get app_review_negative_modal_text =>
      'Gætirðu tekið þér nokkrar sekúndur til að segja okkur af hverju?';

  @override
  String get app_review_negative_modal_positive_button => 'Já, klárlega!';

  @override
  String get app_review_negative_modal_negative_button => 'No';

  @override
  String get could_not_refresh => 'Gat ekki endurnýjað vöruna';

  @override
  String get product_internet_error_modal_title => 'Villa hefur komið upp!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Við gátum ekki sótt upplýsingar um þessa vöru vegna netvillu. Vinsamlegast athugaðu nettenginguna þína og reyndu aftur.\n\nInnri villa:\n$error';
  }

  @override
  String get product_tags_title => 'Eiginleikar vörunnar';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Engar eignir';

  @override
  String get product_tags_explanation =>
      'Með því að bæta eiginleikum (lykil/gildi) við vöru hjálpar þú til við að auðga hana.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Bæta við eiginleikum';

  @override
  String get add_edit_tags => 'Bæta við eða breyta eiginleikum';

  @override
  String get edit_tag => 'Breyta eign';

  @override
  String get remove_tag => 'Fjarlægja eign';

  @override
  String get tag_key => 'Eign';

  @override
  String get tag_keys => 'Eiginleikar';

  @override
  String get tag_key_uneditable => 'Eiginleiki (óbreytanlegur)';

  @override
  String get tag_key_input_hint => 'Sláðu inn eiginleika';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Sláðu inn gildi';

  @override
  String get tag_key_item => 'Eign:';

  @override
  String get tag_value_item => 'Gildi:';

  @override
  String get tag_key_explanations =>
      'Lykill verður að vera með lágstöfum og án bila.';

  @override
  String tag_key_already_exists(String property) {
    return 'Merki með eiginleikanum $property er þegar til!';
  }

  @override
  String get product_internet_error =>
      'Ómögulegt er að sækja upplýsingar um þessa vöru vegna netvillu.';

  @override
  String get cached_results_from => 'Sýna niðurstöður frá:';

  @override
  String get product_search_same_category => 'Finndu valkosti';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'Þessi aðgerð er aðeins hægt að nota fyrir vörur með flokk.\n\nVinsamlegast breyttu vörunni til að bæta við flokki.';

  @override
  String get product_improvement_add_category =>
      'Add a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Add nutrition facts to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Add nutrition facts and a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Ekki er hægt að reikna út næringargildi þessarar vöru, sem gæti til dæmis stafað af óstaðlaðri flokkun. Ef þetta er talið vera villa, vinsamlegast hafið samband við okkur.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Næringarmyndin er úrelt: vinsamlegast endurnýjaðu hana.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Græna einkunnin tekur mið af uppruna innihaldsefnanna. Vinsamlegast takið mynd af innihaldslistanum og/eða landfræðilegum fullyrðingum eða breytið vörunni svo hægt sé að taka tillit til þeirra.';

  @override
  String get country_chooser_label => 'Veldu land';

  @override
  String get currency_chooser_label => 'Veldu gjaldmiðil';

  @override
  String get country_change_message => 'Þú hefur bara skipt um land.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Viltu breyta gjaldmiðlinum úr $previousCurrency í $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Veldu land:';

  @override
  String get country_chooser_label_from_settings => 'Landið þitt';

  @override
  String get country_selection_explanation =>
      'Sumir umhverfisþættir eru staðbundnir';

  @override
  String get product_removed_comparison => 'Vara fjarlægð úr samanburði';

  @override
  String get native_app_settings => 'Stillingar fyrir innfædd forrit';

  @override
  String get native_app_description =>
      'Opna kerfisstillingar fyrir Open Food Facts';

  @override
  String get product_removed_history => 'Vara fjarlægð úr sögu';

  @override
  String get product_removed_list => 'Vara fjarlægð af listanum';

  @override
  String get product_could_not_remove => 'Gat ekki fjarlægt vöruna';

  @override
  String get no_prodcut_in_list => 'Það er engin vara á þessum lista';

  @override
  String get no_product_in_section => 'Það er engin vara í þessum hluta';

  @override
  String get recently_seen_products => 'Allar skoðaðar vörur';

  @override
  String get clear => 'Hreinsa';

  @override
  String get clear_long => 'Tæma listann';

  @override
  String get really_clear => 'Viltu virkilega eyða þessum lista?';

  @override
  String pct_match(Object percent) {
    return '$percent% samsvörun';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fyrir dögum',
      one: 'fyrir einum degi',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fyrir klukkustundum síðan',
      one: 'fyrir einni klukkustund síðan',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fyrir mínútum síðan',
      one: 'fyrir einni mínútu síðan',
      zero: 'fyrir minna en mínútu síðan',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fyrir mánuðum síðan',
      one: 'fyrir einum mánuði síðan',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fyrir vikum',
      one: 'fyrir einni viku',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Berðu saman $count Vörur',
      one: 'Berðu saman eina vöru',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count valdar vörur',
      one: 'Ein vara valin',
      zero: 'Engin vara valin',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Berðu saman valdar vörur';

  @override
  String get delete_products_mode => 'Eyða völdum vörum';

  @override
  String get select_all_products_mode => 'Veldu allar vörur';

  @override
  String get select_none_products_mode => 'Veldu ekkert';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle =>
      'Veldu að minnsta kosti tvær vörur';

  @override
  String get retry_button_label => 'Reyna aftur';

  @override
  String get connect_with_us => 'Tengstu við okkur';

  @override
  String get tiktok => 'Fylgdu okkur á TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Fylgdu okkur á Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Fylgdu okkur á X (áður Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Fylgdu okkur á Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Fylgdu okkur á BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blogg';

  @override
  String get faq => 'Algengar spurningar';

  @override
  String get discover => 'Uppgötva';

  @override
  String get how_to_contribute => 'Hvernig á að leggja sitt af mörkum';

  @override
  String get hint_knowledge_panel_message =>
      'Þú getur pikkað á hvaða hluta kortsins sem er til að fá frekari upplýsingar um það sem þú sérð. Prófaðu það núna!';

  @override
  String get permissions_page_title => 'Aðgangur að myndavél';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'Ef þú skiptir um skoðun er hægt að virkja og slökkva á þessum valkosti hvenær sem er í stillingunum.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'Stýrikerfi: Android (SDK Int: $sdkInt / Útgáfa: $release)\nTegund: $model\nVara: $product\nTæki: $device\nVörumerki:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'Stýrikerfi: iOS ($version)\nGerð: $model\nStaðbundin gerð: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nÚtgáfa forrits:$appVersion\nSmíðanúmer forrits:$appBuildNumber\nNafn forritspakka:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'Neita';

  @override
  String get ask_me_later_button_label => 'Seinna';

  @override
  String get are_you_sure => 'Ertu viss?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Haltu áfram $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Velkomin(n)!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Appið sem hjálpar þér að velja mat sem er hollur fyrir **þig** og **plánetuna**!';

  @override
  String get onboarding_continue_button => 'Halda áfram';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Hleður inn fyrstu sýnishornsvöruna þína';

  @override
  String get onboarding_welcome_warning =>
      'Því miður, þetta er dæmi um vöruna okkar, þú getur ekki breytt henni :)';

  @override
  String get product_list_your_ranking => 'Röðun þín';

  @override
  String get product_list_empty_icon_desc => 'Saga ekki tiltæk';

  @override
  String get product_list_empty_title => 'Byrja að skanna';

  @override
  String get product_list_empty_message =>
      'Skannaðar vörur birtast hér og þú getur skoðað ítarlegar upplýsingar um þær.';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'vörur',
      one: 'vöru',
      zero: 'vöru',
    );
    return 'Endurnýjar $_temp0 í sögunni þinni';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Vörur',
      one: 'Vara',
      zero: 'Vara',
    );
    return '$_temp0 endurnýjun lokið';
  }

  @override
  String get product_list_compare_side_by_side => 'Berðu saman hlið við hlið';

  @override
  String get loading_dialog_default_title => 'Að sækja gögn';

  @override
  String get loading_dialog_default_error_message => 'Gat ekki sótt gögn';

  @override
  String get account_delete => 'Eyða reikningi';

  @override
  String get account_delete_title => 'Eyða reikningnum mínum';

  @override
  String get user_profile => 'Reikningur';

  @override
  String get user_profile_title_guest => 'Velkomin(n)!';

  @override
  String get user_profile_subtitle_guest =>
      'Skráðu þig inn eða skráðu þig til að taka þátt í Open Food Facts samfélaginu';

  @override
  String user_profile_title_id_email(String email) {
    return 'Opna innskráningu á Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Velkomin(n) $id!';
  }

  @override
  String get email_subject_account_deletion => 'Eyða reikningi';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hæ, vinsamlegast eyddu Open Food Facts aðganginum mínum: $userId';
  }

  @override
  String get settings_app_app => 'Umsókn';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'Myndavél';

  @override
  String get settings_app_products => 'Vörur';

  @override
  String get settings_app_miscellaneous => 'Ýmislegt';

  @override
  String get camera_play_sound_title => 'Spila hljóð við skönnun';

  @override
  String get camera_play_sound_subtitle =>
      'Mun pípa við hverja vel heppnaða skönnun';

  @override
  String get camera_window_accessibility_label =>
      'Skannaðu strikamerki með myndavélinni þinni';

  @override
  String get app_haptic_feedback_title => 'Titringur og snertiskynjun';

  @override
  String get app_haptic_feedback_subtitle =>
      'Titringur eftir að ákveðnar aðgerðir eru framkvæmdar (strikamerki afkóðað, vara fjarlægð…).';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Þegar þetta er virkt eru skýrslur um bilun sjálfkrafa sendar inn í villuskráningarkerfi Open Food Facts, svo hægt sé að laga villur og þannig bæta appið.';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Breyta mynd';

  @override
  String get permission_photo_error => 'Villa';

  @override
  String get permission_photo_denied_title =>
      'Leyfa notkun myndavélar til að skanna strikamerki';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Til að bæta upplifunina, vinsamlegast leyfðu $appName aðgang að myndavélinni þinni. Þú munt geta skannað strikamerki beint.';
  }

  @override
  String get permission_photo_denied_button => 'Leyfa';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Leyfi hafnað';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Þar sem þú hefur áður hafnað leyfi fyrir myndavélinni verður þú að leyfa hana handvirkt í stillingunum.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Opna stillingar';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Cancel';

  @override
  String get permission_photo_none_found => 'Engin myndavél greind';

  @override
  String get permission_photo_denied => 'Enginn aðgangur að myndavél veittur';

  @override
  String get show_product_pictures => 'Sýna myndir af vörunni';

  @override
  String get edit_product_label => 'Breyta vöru';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Hleður upp breytingunum þínum…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Breytingarnar þínar eru **sendnar í bakgrunni** (eða síðar ef villa kemur upp).\nÞú getur haldið áfram að breyta öðrum vörusviðum.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Breytingarnar þínar eru **sendnar í bakgrunni** (eða síðar ef villa kemur upp).';

  @override
  String get edit_product_label_short => 'Edit';

  @override
  String edit_product_form_item_help(String value) {
    return 'Hvernig á að slá inn \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Vinsamlegast sláðu inn gildi sem ekki er tómt!';

  @override
  String get edit_product_form_item_error_existing =>
      'Þetta gildi er nú þegar til staðar!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Bæta við nýju vörumerki';

  @override
  String get edit_product_form_item_add_action_label =>
      'Bæta við nýjum merkimiða';

  @override
  String get edit_product_form_item_add_action_store =>
      'Bæta við nýrri verslun';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Bæta við nýjum uppruna';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Bæta við nýjum rekjanleikakóða';

  @override
  String get edit_product_form_item_add_action_country => 'Bæta við nýju landi';

  @override
  String get edit_product_form_item_add_action_category =>
      'Bæta við nýjum flokki';

  @override
  String get edit_product_form_item_add_action_trace => 'Bæta við nýrri slóð';

  @override
  String get edit_product_form_item_add_suggestion => 'Bæta við tillögu';

  @override
  String get edit_product_form_item_deny_suggestion => 'Hafna tillögu';

  @override
  String get edit_product_form_item_details_title => 'Grunnupplýsingar';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Vöruheiti, vörumerki, magn';

  @override
  String get edit_product_form_item_other_details_title =>
      'Frekari upplýsingar';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Vefsíða…';

  @override
  String get edit_product_form_item_photos_title => 'Myndir';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Bæta við eða endurnýja myndir';

  @override
  String get edit_product_form_item_labels_title => 'Merki og vottanir';

  @override
  String get edit_product_form_item_labels_subtitle => 'Umhverfis-, gæðamerki…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Sláðu inn merki (t.d.: Næringargildi)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Góðar starfsvenjur: Merkingar';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Sérhver eiginleiki vörunnar **sem er staðreynd** og frábrugðinn öðrum sviðum.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Næringarstig, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Framleitt í Belgíu, framleitt í Bretagne…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Ríkt af trefjum, járngjafi…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Sanngjarn viðskipti, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Verslanir';

  @override
  String get edit_product_form_item_stores_hint => 'Sláðu inn verslun';

  @override
  String get edit_product_form_item_stores_type => 'verslun';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Góðar starfsvenjur: Verslanir';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Sláðu inn verslunina þar sem þú keyptir vöruna.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Uppruni';

  @override
  String get edit_product_form_item_origins_hint =>
      'Sláðu inn uppruna (t.d. Þýskaland)';

  @override
  String get edit_product_form_item_origins_type => 'country';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Góðar starfsvenjur: Uppruni';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Bætið við **öllum upprunavísum sem þið finnið á umbúðunum**.\nÞið þurfið ekki að hafa áhyggjur af uppruna sem tilgreindur er beint í innihaldslistanum.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Nautakjöt frá Argentínu';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Sojaið kemur ekki frá Evrópusambandinu';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Sláðu inn land (t.d. Þýskaland)';

  @override
  String get edit_product_form_item_countries_type => 'country';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Góðar starfsvenjur: Lönd';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Lönd þar sem varan er víða fáanleg** (að undanskildum verslunum sem sérhæfa sig í erlendum vörum).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Rekjanleikakóðar';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Sláðu inn kóða (td: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'rekjanleikakóði';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Góðar starfsvenjur: Rekjanleikakóðar';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Í þessum hluta er hægt að slá inn kóða sem tengjast **umbúðamerkjum**, **auðkennismerkjum** eða **heilbrigðismerkjum**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Dæmi um rekjanleikakóða';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EB-kóðar** sem notaðir eru í Evrópubandalaginu til að bera kennsl á matvælaframleiðendur eða pökkunaraðila:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: landsnúmer **Frakklands**\n**72.264.002**: landfræðileg gögn\n**CE**: Evrópubandalagið';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB kóðar** notaðir í Frakklandi:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Leifar';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'Sláðu inn rekja (t.d.: sojabaunir)';

  @override
  String get edit_product_form_item_categories_title => 'Categories';

  @override
  String get edit_product_form_item_categories_hint => 'category';

  @override
  String get edit_product_form_item_categories_type =>
      'Sláðu inn flokk (t.d.: Appelsínusafi)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Góðar starfsvenjur: Flokkar';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Tilgreindu **aðeins þann flokk sem er sérstaklega mikilvægur**.\nYfirflokkar verða sjálfkrafa bætt við.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Vantar flokk?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Ef flokkur er **ekki tiltækur í sjálfvirkri útfyllingu**, þá er þér velkomið að bæta honum við samt sem áður.\nÞetta mun hjálpa okkur að bæta Open Food Facts í þínu landi.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardínur í ólífuolíu';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Appelsínusafi úr þykkni';

  @override
  String get edit_product_form_item_exit_title => 'Hætta án þess að vista?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Viltu vista breytingarnar áður en þú ferð af þessari síðu?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Vista breytingar';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Fleygja breytingum';

  @override
  String get edit_product_form_item_ingredients_title => 'Innihald';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Aðdráttur og útdráttur með því að klípa skjáinn';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Aðdráttur og minnkun á myndinni';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Með því að nota **Klípa-til-aðdráttar bendinguna** geturðu aðdráttað eða minnkað myndina:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Bæta við';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Vinsamlegast sláðu fyrst inn texta';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Fjarlægja';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Vistaðu breytinguna þína';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Hætta við breytinguna þína';

  @override
  String get edit_product_form_item_packaging_title =>
      'Mynd af leiðbeiningum um endurvinnslu';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Næringarupplýsingar';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Næringargildi, áfengisinnihald…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Góðar starfsvenjur: Næringarupplýsingar';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Næringargildi';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Fyrst skaltu velja hvort **gildin eru gefin**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Næringarupplýsingar';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Sláðu síðan inn næringargildin **eins og þau eru tilgreind á umbúðunum**. Ef engin gildi eru til staðar geturðu smellt á „Augað“ táknið.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Vantar reit?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Ef færsla vantar geturðu **smellt á „Plús“ táknið** til að bæta henni við (t.d.: D-vítamín, magnesíum…).';

  @override
  String get edit_product_form_save => 'Edit';

  @override
  String get edit_product_ingredients_photo_title => 'Mynd af innihaldsefnum';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Umbúðamynd';

  @override
  String get edit_product_packaging_list_title => 'Umbúðalisti';

  @override
  String get no_data_available => 'Engin gögn tiltæk';

  @override
  String get product_field_website_title => 'Vefsíða';

  @override
  String get origins_editing_title => 'Breyta uppruna';

  @override
  String get completed_basic_details_btn_text => 'Ljúktu við grunnupplýsingar';

  @override
  String get not_implemented_snackbar_text => 'Ekki enn innleitt';

  @override
  String get category_picker_page_appbar_text => 'Categories';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Draga út innihaldsefni úr myndinni';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Að draga innihaldsefni\nút úr myndinni';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Hleður mynd…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Af hverju sé ég þessi skilaboð?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Til að nota eiginleikann „Draga út innihaldsefni“ þarf fyrst að hlaða inn myndinni.\n\nVinsamlegast bíðið í nokkrar sekúndur eða sláið þau inn handvirkt.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Endurnýja mynd';

  @override
  String get edit_packaging_extract_btn_text =>
      'Dragðu út umbúðir\naf myndinni';

  @override
  String get edit_packaging_extract_btn_text_short => 'Útdráttarumbúðir';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Að taka umbúðir úr myndinni';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Hleður mynd…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Af hverju sé ég þessi skilaboð?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Til að nota aðgerðina „Draga út umbúðir“ þarf fyrst að hlaða upp myndinni.\n\nVinsamlegast bíðið í nokkrar sekúndur eða sláið þær inn handvirkt.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Endurnýja mynd';

  @override
  String get edit_ocr_extract_failed => 'Mistókst að greina texta í myndinni.';

  @override
  String get edit_ocr_extract_disabled_title => 'Engin mynd!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Til að nota textaútdráttaraðgerðina verður þú fyrst að taka mynd.';

  @override
  String get user_list_dialog_new_title => 'Nýr vörulisti';

  @override
  String get user_list_dialog_rename_title => 'Endurnefna lista';

  @override
  String get user_list_subtitle_product => 'Listar';

  @override
  String get user_list_title => 'Your lists';

  @override
  String get user_list_add_product => 'Bættu vörunni við listana þína';

  @override
  String get user_list_button_new => 'Búa til nýjan lista';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Bæta við lista';

  @override
  String get added_to_list_msg => 'Bætt við listann';

  @override
  String get user_list_popup_clear => 'Hreinsa sögu þína';

  @override
  String get user_list_popup_rename => 'Endurnefna';

  @override
  String get user_list_name_hint => 'Listinn minn';

  @override
  String get user_list_name_error_empty => 'Nafn er skylda';

  @override
  String get user_list_name_error_already => 'Það nafn er þegar notað';

  @override
  String get user_list_name_error_same => 'Það er sama nafnið';

  @override
  String get user_list_name_input_hint => 'Nafn listans';

  @override
  String get try_again => 'Reyndu aftur';

  @override
  String get there_was_an_error => 'Það kom upp villa';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Enginn flokkur fannst fyrir $items';
  }

  @override
  String get camera_toggle_camera =>
      'Skipta á milli aftari og fremri myndavélar';

  @override
  String get camera_toggle_flash =>
      'Kveiktu eða slökktu á flassinu á myndavélinni';

  @override
  String get camera_enable_flash => 'Virkja flass';

  @override
  String get camera_disable_flash => 'Slökkva á flassinu';

  @override
  String get camera_flash_error_dialog_title => 'Villa kom upp!';

  @override
  String get camera_flash_error_dialog_message =>
      'Villa kom upp við að breyta stöðu flasssins. Gakktu úr skugga um að snjallsíminn þinn hafi ekki þegar virkjað vasaljósið.';

  @override
  String get category_picker_no_category_found_button => 'Til baka';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Smelltu til að opna í vafranum þínum eða í forritinu (ef það er uppsett)';

  @override
  String get dev_preferences_screen_title => 'DEV-stilling';

  @override
  String get dev_preferences_screen_subtitle =>
      'Aðgangur að tilraunaeiginleikum og þróunartólum';

  @override
  String get dev_preferences_reset_onboarding_title => 'Endurræsa innleiðingu';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Þú þarft þá að endurræsa appið til að sjá það aftur.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Skipta á milli openfoodfacts.org (PROD) og prófunarumhverfis';

  @override
  String get dev_preferences_test_environment_title =>
      'Prófunarumhverfisbreytur';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Grunnslóð fyrir núverandi prófunarumhverfi: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Prófunarumhverfisgestgjafi';

  @override
  String get dev_preferences_ml_kit_title => 'Notaðu ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'þá þarftu að endurræsa þetta forrit';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Viðbótarhnappur á vörusíðu';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Breyta innihaldsefnum með hnappi á þekkingarspjaldi';

  @override
  String get dev_preferences_export_history_title => 'Útflutningssaga';

  @override
  String get dev_preferences_export_history_progress_error => 'undantekning';

  @override
  String get dev_preferences_export_history_progress_found => 'vara fannst';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'vara fannst EKKI';

  @override
  String get dev_preferences_export_history_dialog_title => 'Útflutningssaga';

  @override
  String get dev_preferences_button_positive => 'Í lagi';

  @override
  String get dev_preferences_button_negative => 'Cancel';

  @override
  String get dev_preferences_migration_title => 'Gagnaflutningur úr V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Staða: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'vel heppnað eða ný uppsetning';

  @override
  String get dev_preferences_migration_status_success => 'velgengni';

  @override
  String get dev_preferences_migration_status_error => 'villa';

  @override
  String get dev_preferences_migration_status_in_progress => 'í vinnslu';

  @override
  String get dev_preferences_migration_status_required =>
      'nauðsynlegt (smelltu til að byrja)';

  @override
  String get dev_preferences_migration_status_not_started => 'óþekkt';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Mun hreinsa söguna og setja 3 vörur þar inn';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Sérsniðin vefslóð fyrir fréttir';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'Vefslóð JSON skráarinnar:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Ekki stillt';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Síðasta endurnýjun: $date';
  }

  @override
  String get product_type_label_food => 'Matur';

  @override
  String get product_type_label_beauty => 'Persónuleg umhirða';

  @override
  String get product_type_label_pet_food => 'Gæludýrafóður';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'Tegund vöru';

  @override
  String get product_type_selection_subtitle => 'Veldu gerð þessarar vöru';

  @override
  String get product_type_selection_empty =>
      'Þú þarft fyrst að velja vörutegund!';

  @override
  String product_type_selection_already(String productType) {
    return 'Þú getur ekki breytt vörutegundinni ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Flýtileið að Verðlagningarappinu á vörusíðunni';

  @override
  String get prices_app_button => 'Fara í Verðlagningarappið';

  @override
  String get prices_website_button => 'Opið á vefsíðu Opna verðlagningar';

  @override
  String get prices_bulk_proof_upload_select =>
      'Bæta við verðmiðum beint úr myndasafninu';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Þegar þú hefur valið myndir geturðu ekki breytt þeim!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Leyfa samfélaginu að staðfesta verð sem gervigreind dregur út.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Margfeldi verðmiðar';

  @override
  String get prices_bulk_proof_upload_title => 'Fjöldaupphleðsla sönnunargagna';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Að velja skrár';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Að hefja upphleðslu';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Afrita skrána staðbundið #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Undirbýr upphleðslu #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Mistókst við mynd #$index/$count';
  }

  @override
  String get prices_generic_title => 'Verð';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Bæta við $count verði',
      one: 'Bæta við verði',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Senda $count verð',
      one: 'Senda verðið',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Bæta við hlut';

  @override
  String get prices_add_a_price => 'Bæta við verði';

  @override
  String get prices_add_a_receipt => 'Bæta við kvittun';

  @override
  String get prices_add_price_tags => 'Bæta við verðmiðum';

  @override
  String prices_barcode_already(String barcode) {
    return 'Þetta strikamerki ($barcode) er nú þegar á listanum!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'Engin vara ennþá';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Ertu að leita að $barcode';
  }

  @override
  String get prices_barcode_enter => 'Sláðu inn strikamerkið';

  @override
  String get prices_category_enter => 'Vara án strikamerkis';

  @override
  String get prices_per_kilogram => 'Verð á kílógramm';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / eining';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'Valfrjálst';

  @override
  String get prices_category_error_mandatory => 'Flokkurinn er skyldubundinn';

  @override
  String get prices_barcode_reader_action => 'Strikamerkjalesari';

  @override
  String get prices_view_prices => 'Skoða verðin';

  @override
  String get prices_list_title => 'Verðlisti';

  @override
  String get prices_list_count => 'Fjöldi\nverðs';

  @override
  String get prices_list_add_new_price => 'Bæta við nýju verði\n';

  @override
  String get prices_list_empty_title => 'Ekkert verð ennþá!';

  @override
  String get prices_list_empty_subtitle =>
      'Vertu fyrstur til að bæta við einum:\nMeð því að skanna **kvittun** eða **verðmiða**!';

  @override
  String get prices_entry_shop_not_found => 'Óþekkt verslun';

  @override
  String prices_entry_menu_title(String user) {
    return 'Verðfærsla frá \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Skoða öll verð fyrir þessa vöru';

  @override
  String get prices_entry_menu_open_proof => 'Sjá sönnun';

  @override
  String get prices_entry_menu_my_prices => 'Skoðaðu önnur verð hjá mér';

  @override
  String get prices_entry_menu_author_prices =>
      'Skoða önnur verð eftir höfundi';

  @override
  String get prices_entry_menu_shop_prices => 'Skoðaðu önnur verð í búðinni';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count verð',
      one: '1 verð',
    );
    return '$_temp0 fyrir $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Öll $count verð',
      one: 'Aðeins eitt verð',
      zero: 'Ekkert verð ennþá',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Nýjustu $pageSize verð (samtals: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Verð: $price / Verslun: \"$location\" / Birt þann $date af \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Opna sannanir fyrir \"$user\"';
  }

  @override
  String get prices_open_proof => 'Sönnun á opnu verði';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Allar $count sannanir',
      one: 'Aðeins ein sönnun',
      zero: 'Engin sönnun ennþá',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Nýjustu $pageSize sannanir (samtals: $total)';
  }

  @override
  String get prices_users_empty_title => 'Enginn þátttakandi ennþá!';

  @override
  String get prices_users_empty_explanation =>
      'Vertu fyrstur til að bæta við verði!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Helstu $pageSize þátttakendur (samtals: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Engin búð ennþá!';

  @override
  String get prices_locations_empty_explanation =>
      'Vertu fyrstur til að bæta við verði!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Vinsælustu $pageSize staðsetningarnar (samtals: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count sannanir',
      one: 'Ein sönnun',
      zero: 'Engin sönnun',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count vörur',
      one: 'Ein vara',
      zero: 'Engin vara',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count notendur',
      one: 'Einn notandi',
      zero: 'Enginn notandi',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count verð',
      one: 'Eitt verð',
      zero: 'Ekkert verð',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Verð áður bætt við';

  @override
  String get prices_amount_subtitle => 'Upphæð';

  @override
  String get prices_amount_is_discounted => 'Er með afslátt?';

  @override
  String get prices_amount_price_normal => 'Verð';

  @override
  String get prices_amount_price_discounted => 'Afsláttarverð';

  @override
  String get prices_amount_price_not_discounted => 'Upprunalegt verð';

  @override
  String get prices_amount_no_product => 'Ein vara vantar!';

  @override
  String get prices_amount_price_incorrect => 'Rangt gildi';

  @override
  String get prices_amount_price_mandatory => 'Skyldubundið gildi';

  @override
  String get prices_currency_subtitle => 'Gjaldmiðill';

  @override
  String get prices_date_subtitle => 'Dagsetning';

  @override
  String get prices_location_subtitle => 'Verslun';

  @override
  String get prices_location_find => 'Finndu verslun';

  @override
  String get prices_location_mandatory => 'Þú þarft að velja búð!';

  @override
  String get prices_location_search_broader =>
      'Fannstu ekki það sem þú varst að leita að? Prófum víðtækari leit!';

  @override
  String get prices_proof_subtitle => 'Sönnun';

  @override
  String get prices_proof_empty_title => 'Engin sönnun ennþá!';

  @override
  String get prices_proof_empty_explanation =>
      'Byrjaðu á að bæta við mynd af **kvittun** eða **verðmiða**!';

  @override
  String get prices_proof_find => 'Veldu sönnun';

  @override
  String get prices_proof_change => 'Breytingarsönnun';

  @override
  String get prices_proof_receipt => 'Kvittun';

  @override
  String get prices_proof_price_tag => 'Verðmiði';

  @override
  String get prices_proof_mandatory => 'Þú þarft að velja sönnun!';

  @override
  String get prices_add_validation_error => 'Staðfestingarvilla';

  @override
  String get prices_privacy_warning_title => 'Viðvörun um friðhelgi einkalífs';

  @override
  String get prices_unknown_product => 'Óþekkt vara';

  @override
  String get prices_privacy_warning_main_message =>
      'Verð **verður birt opinberlega**, ásamt versluninni sem þau vísa til.\n\nÞað gæti gert fólki sem veit um dulnefnið þitt frá Open Food Facts kleift að:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Ályktaðu á hvaða svæði þú býrð';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Vita hvað þú ert að kaupa';

  @override
  String get prices_privacy_warning_sub_message =>
      'Ef þú ert óánægður með það, vinsamlegast breyttu dulnefninu þínu eða stofnaðu nýjan Open Food Facts aðgang og skráðu þig inn í appið með honum.';

  @override
  String get i_refuse => 'Ég neita';

  @override
  String get i_accept => 'Ég samþykki';

  @override
  String get prices_currency_change_proposal_title => 'Skipta um gjaldmiðil?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Núverandi gjaldmiðill þinn er **$currency**. Viltu breyta honum í **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Já, nota $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nei, haltu $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Lokið';

  @override
  String get dev_mode_section_server => 'Stillingar netþjóns';

  @override
  String get dev_mode_section_news => 'Stillingar fréttaveitu';

  @override
  String get dev_mode_section_product_page => 'Vörusíða';

  @override
  String get dev_mode_section_ui => 'Notendaviðmót';

  @override
  String get dev_mode_section_experimental_features => 'Tilraunaeiginleikar';

  @override
  String get dev_mode_hide_environmental_score_title => 'Útiloka græna einkunn';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Notaðu villuleitara fyrir OCR skjái';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Innihaldsefni og umbúðir)';

  @override
  String get dev_mode_reset_app_language_title => 'Endurstilla forritstungumál';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Bæta við kortum';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Skipta á milli prices.openfoodfacts.org (PROD) og prófunarumhverfis';

  @override
  String get search_history_item_edit_tooltip =>
      'Endurnýta og breyta þessari leit';

  @override
  String get search_history_item_remove_tooltip => 'Fjarlægja';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Þú hefur sótt allar $totalSize vörurnar.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Sækja $count fleiri vörur\nÞegar sótt $downloaded af $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Leit þín að $search er í gangi.\n\nVinsamlegast bíddu í nokkrar sekúndur…';
  }

  @override
  String get user_search_contributor_title => 'Vörur sem ég bætti við';

  @override
  String get user_search_informer_title => 'Vörur sem ég breytti';

  @override
  String get user_search_photographer_title => 'Vörur sem ég ljósmyndaði';

  @override
  String get user_search_to_be_completed_title =>
      'Vörur mínar sem eru tilbúnar';

  @override
  String get user_search_prices_title => 'Verðin mín';

  @override
  String get user_search_proofs_title => 'Sönnunargögn mín';

  @override
  String get user_search_proof_title => 'Sönnun mín';

  @override
  String search_proof_title(String user) {
    return 'Sönnun frá \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Verð framlagsaðila: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Nýjustu verðin bætt við';

  @override
  String get all_search_prices_top_user_title => 'Helstu verðlagsþættir';

  @override
  String get all_search_prices_top_location_title =>
      'Verslanir með hæstu verðin';

  @override
  String get prices_contribution_assistant => 'Aðstoðarmaður við verðlagningu';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system =>
      'Bæta við mörgum sönnunargögnum';

  @override
  String get all_search_prices_top_location_single_title => 'Verð í verslun';

  @override
  String get all_search_prices_top_product_title => 'Vörur með hæstu verði';

  @override
  String get all_search_to_be_completed_title => 'Allar vörur sem á að klára';

  @override
  String get categorize_products_country_title =>
      'Aðstoð við flokkun vara í þínu landi';

  @override
  String get edit_product_action_retake_picture => 'Taka mynd aftur';

  @override
  String get edit_product_action_take_picture => 'Taka mynd';

  @override
  String get edit_product_action_confirm => 'Staðfesta';

  @override
  String get signup_page_terms_of_use_line1 => 'Ég samþykki Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => 'notkunarskilmálar og framlag';

  @override
  String get analytics_consent_image_semantic_label => 'Greiningartákn';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Alvarleg villa: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Alvarleg villa: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Ljúktu við grunnupplýsingar';

  @override
  String get edit_photo_button_label => 'Edit';

  @override
  String get edit_photo_unselect_button_label => 'Afvelja mynd';

  @override
  String get edit_photo_select_existing_button_label =>
      'Veldu fyrirliggjandi mynd';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Veldu mynd með því að smella á hana';

  @override
  String get edit_photo_select_existing_download_label =>
      'Sæki fyrirliggjandi myndir…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Engar myndir hafa verið hlaðnar upp áður sem tengjast þessari vöru.';

  @override
  String get edit_photo_language_not_this_one =>
      'Engin mynd á því tungumáli ennþá';

  @override
  String get edit_photo_language_none => 'Engin mynd ennþá';

  @override
  String get category_picker_screen_title => 'Categories';

  @override
  String get basic_details => 'Grunnupplýsingar';

  @override
  String get product_name => 'Vöruheiti';

  @override
  String get product_names => 'Vöruheiti';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Bæta við nýrri þýðingu';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Áður en þú staðfestir, vertu viss um að þú bætir aðeins við þýðingu **ef tungumálið er til staðar á umbúðunum**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Skoða mynd að framan';

  @override
  String get add_basic_details_product_name_take_photo => 'Taka mynd að framan';

  @override
  String get add_basic_details_product_name_hint =>
      'Sláðu inn heiti vörunnar (t.d.: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Breyta sjálfgefnu tungumáli?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Viltu að sjálfgefið tungumál vörunnar sé stillt á \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Góð dæmi';

  @override
  String get explanation_section_bad_examples => 'Slæm dæmi';

  @override
  String get add_basic_details_product_name_help_title =>
      'Góðar starfsvenjur: Vöruheiti';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Vöruheitið er **aðalheitið sem prentað er á umbúðirnar**. Það getur verið skráð vörumerki.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Athugið:** Vinsamlegast bætið ekki við þýðingu **ef tungumálið er ekki til staðar á umbúðunum**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 => 'Tómatsósa';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Ekki taka vörumerkið með í nafninu';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tómatsósa **eftir Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Ekki nota táknin ®, ™, © eða sambærileg';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aðrar þýðingar',
      one: '$count önnur þýðing',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Vörumerki';

  @override
  String get brand_names => 'Vörumerki';

  @override
  String get add_basic_details_brand_name_error =>
      'Vinsamlegast sláðu inn vörumerkið';

  @override
  String get add_basic_details_brand_names_hint =>
      'Vörumerki fyrir inntak (t.d. Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Góðar starfsvenjur: Vörumerki';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Sláðu inn **öll vörumerki vörunnar**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Aðal vörumerki';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Aðalvörumerkið**, sem almennt er greinilega sýnt á framhlið umbúðanna, ætti að vera **fært inn**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Önnur vörumerki';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Þegar selt er **af stóru fyrirtæki**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** er selt af **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Þegar selt er með vörumerkinu sínu **þýtt á mörg tungumál**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Náttúrudalur** er stundum skrifað **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Magn og þyngd';

  @override
  String get add_basic_details_quantity_hint =>
      'Sláðu inn þyngdina og ef þörf krefur magnið (t.d.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Góðar starfsvenjur: Magn';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Afritaðu gildið sem gefið er upp á vörunni og **gleymdu ekki einingunum**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** eða **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (fyrir 6 egg)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(fyrir vöru með 3 kössum, hver með 150 g)';

  @override
  String get barcode => 'Barcode';

  @override
  String barcode_barcode(String barcode) {
    return 'Strikamerki: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Ógilt strikamerki';

  @override
  String get basic_details_add_success => 'Grunnupplýsingar bættar við';

  @override
  String get basic_details_add_error =>
      'Ekki tókst að bæta við grunnupplýsingum. Reyndu aftur eftir smá tíma.';

  @override
  String get clear_search => 'Hreinsa leitina þína';

  @override
  String get confirm_clear =>
      'Þú ert að fara að hreinsa allan ferilinn þinn: ertu viss um að þú viljir halda áfram?';

  @override
  String get alert_clear_selected_user_list =>
      'Þú ert að fara að hreinsa valda hluti úr sögunni þinni';

  @override
  String get confirm_clear_selected_user_list =>
      'Ertu viss um að þú viljir halda áfram?';

  @override
  String get alert_select_items_to_clear =>
      'Veldu eitt eða fleiri atriði til að hreinsa';

  @override
  String confirm_clear_user_list(String name) {
    return 'Þú ert að fara að hreinsa þennan lista ($name): ertu viss um að þú viljir halda áfram?';
  }

  @override
  String get confirm_delete_user_list_title => 'Eyða listanum?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Þú ert að fara að eyða listanum \"$name\".\nErtu viss um að þú viljir halda áfram?';
  }

  @override
  String get confirm_delete_user_list_button => 'Já, ég staðfesti';

  @override
  String importance_label(String name, String id) {
    return '$name mikilvægi: $id';
  }

  @override
  String get user_list_all_title => 'Listar';

  @override
  String get user_list_all_empty => 'Búðu til fyrsta listann þinn';

  @override
  String get product_list_select => 'Veldu lista';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count vörur',
      one: 'Ein vara',
      zero: 'Tómur listi',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Bæta við lista';

  @override
  String get open_food_preferences_tooltip => 'Breyta matarstillingum þínum';

  @override
  String get add_photo_button_label => 'Bæta við mynd';

  @override
  String get add_packaging_photo_button_label =>
      'Taktu myndir af öllum umbúðum/upplýsingum um endurvinnslu';

  @override
  String get add_origin_photo_button_label =>
      'Taktu myndir af öllum upprunaupplýsingum';

  @override
  String get add_emb_photo_button_label =>
      'Taktu myndir af öllum upplýsingum um rekjanleikakóða';

  @override
  String get add_label_photo_button_label =>
      'Taktu myndir af öllum merkimiðum og upplýsingum um vottanir';

  @override
  String get choose_image_source_title => 'Veldu myndheimild';

  @override
  String get choose_image_source_body => 'Veldu myndheimild';

  @override
  String get gallery_source_label => 'Myndasafn';

  @override
  String get gallery_source_access_denied_dialog_title => 'Aðgangur hafnaður';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Því miður hefur forritið ekki aðgang að myndasafninu þínu, þar sem þú hefur áður hafnað leyfinu.\n\nFarðu í stillingar forritsins í Stillingar símans -> Myndir.';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Opnaðu stillingarnar';

  @override
  String get share => 'Deila';

  @override
  String share_product_text(String url) {
    return 'Skoðið þessa vöru á Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Skoðið þessa vöru á Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Skoðaðu þessa vöru á Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Skoðaðu þessa vöru á Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Skoðið vörulistann minn á Open Food Facts: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Take a picture';

  @override
  String get choose_from_gallery => 'Veldu úr myndasafni';

  @override
  String get image_upload_queued =>
      'Myndin verður hlaðið inn í bakgrunninn eins fljótt og auðið er.';

  @override
  String get add_price_queued =>
      'Verðið verður sent á netþjóninn eins fljótt og auðið er.';

  @override
  String get background_task_title_full_refresh =>
      'Byrjar að endurnýja allar vörur sem eru geymdar á staðnum';

  @override
  String get background_task_title_folksonomy =>
      'Byrja að framkvæma aðgerðir á netþjóni fyrir uppfærslur á fólksonomíunni sem eru geymdar á staðnum';

  @override
  String get background_task_title_top_n =>
      'Byrjað er að hlaða niður vinsælustu vörunum';

  @override
  String get expand_nutrition_facts => 'Stækka töfluna um næringargildi';

  @override
  String get expand_nutrition_facts_body =>
      'Haltu næringargildistöflunni útvíkkaðri';

  @override
  String get expand_ingredients => 'Stækka innihaldsefni';

  @override
  String get expand_ingredients_body =>
      'Halda innihaldsefnaspjaldinu útvíkkuðu';

  @override
  String get no_internet_connection => 'Engin nettenging';

  @override
  String get world_results_label => 'Allur heimurinn';

  @override
  String get world_results_action => 'Útvíkkaðu leit þína til heimsins';

  @override
  String get copy_to_clipboard => 'Afrita';

  @override
  String get paste_from_clipboard => 'Líma af klippiborði';

  @override
  String get no_data_available_in_clipboard =>
      'Engin gögn tiltæk á klippiborðinu þínu';

  @override
  String get clipboard_barcode_copy => 'Afrita strikamerki á klippiborð';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Strikamerki $barcode afritað á klippiborðið!';
  }

  @override
  String get open_product_website => 'Opnaðu þessa vöru á vefsíðunni';

  @override
  String get language_picker_label => 'Tungumál þitt';

  @override
  String get country_picker_label => 'Landið þitt';

  @override
  String get currency_picker_label => 'Gjaldmiðillinn þinn';

  @override
  String get help_with_openfoodfacts => 'Hjálp með OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Varan verður uppfærð í bakgrunni eins fljótt og auðið er.';

  @override
  String get no_email_client_available_dialog_title => 'Engin tölvupóstforrit!';

  @override
  String get no_email_client_available_dialog_content =>
      'Vinsamlegast sendið okkur tölvupóst á mobile@openfoodfacts.org';

  @override
  String get all_images => 'Allar myndir';

  @override
  String get selected_images => 'Valdar myndir';

  @override
  String get product_card_remove_product_tooltip => 'Fjarlægja vöru';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nýtt strikamerki skannað: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Fjarlægðu allar vörur úr hringekjunni';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Vinsamlegast skannaðu að minnsta kosti tvær vörur til að bera þær saman';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Smelltu til að bera saman vörurnar sem þú hefur skannað';

  @override
  String get scan_product_loading => 'Þú hefur skannað\nstrikamerkið:';

  @override
  String get scan_product_loading_initial =>
      'Við erum að leita að þessari vöru!\nVinsamlegast bíðið í nokkrar sekúndur…';

  @override
  String get scan_product_loading_long_request =>
      'Við erum enn að leita að þessari vöru!\nFinnst þér það taka langan tíma að hlaða? Finnst okkur það líka…';

  @override
  String get scan_product_loading_unresponsive =>
      'Við erum enn að leita að þessari vöru.\nViltu endurræsa leitina?';

  @override
  String get scan_product_loading_restart_button => 'Endurræsa leit';

  @override
  String get portion_calculator_description =>
      'Reiknaðu næringargildi fyrir tiltekið magn';

  @override
  String get portion_calculator_hint => 'Magn í';

  @override
  String get portion_calculator_accessibility =>
      'Sláðu inn magn til að reikna út næringargildi';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Vinsamlegast sláðu inn magn á milli $min og $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Gögn vantar. Ekki var hægt að framkvæma útreikning.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Næringargildi fyrir $grams g (eða ml)';
  }

  @override
  String get offline_data => 'Gögn án nettengingar';

  @override
  String get ocr_image_upload_instruction =>
      'Hladdu upp mynd til að sækja upplýsingarnar sem hún inniheldur sjálfkrafa.';

  @override
  String get upload_image => 'Hlaða inn mynd';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Mistókst að sækja myndina';

  @override
  String get image_edit_url_error =>
      'Mistókst að breyta myndinni því vefslóð myndarinnar var ekki stillt.';

  @override
  String get user_picture_source_remember => 'Mundu eftir vali mínu';

  @override
  String get user_picture_source_ask => 'Spyrðu í hvert skipti';

  @override
  String get robotoff_continue => 'Halda áfram';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count spurningar',
      one: 'spurning',
    );
    return 'Næsta $_temp0';
  }

  @override
  String get show_password => 'Sýna lykilorð';

  @override
  String get owner_field_info_title => 'Framleiðandi gaf upp gildi';

  @override
  String get owner_field_info_message =>
      'Með þessu merki undirstrikum við gögn sem framleiðandinn lætur í té og sem hugsanlega er ekki hægt að breyta.';

  @override
  String get owner_field_info_close_button => 'Loka þessum upplýsingum';

  @override
  String get owner_field_image =>
      'Þessi mynd er frá framleiðandanum. Hugsanlega er ekki hægt að breyta henni.';

  @override
  String get edit_packagings_title => 'Umbúðahlutir';

  @override
  String get edit_packagings_element_add => 'Bæta við umbúðaþætti';

  @override
  String get edit_packagings_completed => 'Umbúðirnar eru klárar';

  @override
  String edit_packagings_element_title(int index) {
    return 'Umbúðaþáttur #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Fjöldi eininga';

  @override
  String get edit_packagings_element_hint_units =>
      'Færið inn fjölda umbúðaeininga af sömu lögun og efni sem vörunni eru í.';

  @override
  String get edit_packagings_element_field_shape => 'Lögun';

  @override
  String get edit_packagings_element_hint_shape =>
      'Sláðu inn heiti formsins sem tilgreint er í endurvinnsluleiðbeiningunum ef þau eru tiltæk, eða veldu form.';

  @override
  String get edit_packagings_element_example_shape => 'Flaska';

  @override
  String get edit_packagings_element_field_material => 'Efni';

  @override
  String get edit_packagings_element_hint_material =>
      'Sláðu inn tiltekið efni ef það er ákvarðað (efniskóði innan þríhyrnings er oft að finna á umbúðum) eða almennt efni (til dæmis plast eða málmur) ef þú ert óviss.';

  @override
  String get edit_packagings_element_example_material => 'Gler';

  @override
  String get edit_packagings_element_field_recycling =>
      'Leiðbeiningar um endurvinnslu';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Færið aðeins inn leiðbeiningar um endurvinnslu ef þær eru tilgreindar á vörunni.';

  @override
  String get edit_packagings_element_example_recycling => 'Endurvinna';

  @override
  String get edit_packagings_element_field_quantity =>
      'Nettómagn vöru á einingu';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Færið inn nettóþyngd eða nettórúmmál og tilgreinið eininguna (til dæmis g eða ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Þyngd einnar tómrar einingar (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Fjarlægið allar matarleifar og þvoið og þurrkið umbúðirnar áður en þær eru vigtaðar. Notið vog með 0,1 g eða 0,01 g nákvæmni ef mögulegt er.';

  @override
  String get background_task_title => 'Framlög í bið';

  @override
  String get background_task_subtitle =>
      'Framlög þín eru sjálfkrafa vistuð á netþjóninn okkar, en ekki alltaf í rauntíma.';

  @override
  String get background_task_list_empty => 'Engin verkefni í bið í bakgrunni';

  @override
  String get background_task_error_server_time_out => 'Tímamörk netþjóns';

  @override
  String get background_task_error_no_internet =>
      'Villa í internettengingu. Reyndu síðar.';

  @override
  String get background_task_operation_unknown => 'óþekkt aðgerðartegund';

  @override
  String get background_task_operation_details => 'ítarlegar breytingar';

  @override
  String get background_task_operation_image => 'myndaupphleðsla';

  @override
  String get background_task_operation_refresh =>
      'endurnýjun seinkað eftir að mynd var hlaðið upp';

  @override
  String get background_task_run_started => 'byrjaði';

  @override
  String get background_task_run_not_started => 'ekki byrjað ennþá';

  @override
  String get background_task_run_to_be_deleted => 'að vera eytt';

  @override
  String get background_task_question_stop =>
      'Viltu hætta þessu verkefni eins fljótt og auðið er?';

  @override
  String get feed_back => 'Ábendingar';

  @override
  String get undo => 'Afturkalla';

  @override
  String get copy_email_to_clip_board => 'Afrita tölvupóst á klippiborð';

  @override
  String get please_send_us_an_email_to =>
      'Vinsamlegast sendið okkur tölvupóst handvirkt á';

  @override
  String get email_copied_to_clip_board =>
      'Tölvupóstur afritaður á klippiborð!';

  @override
  String get select_accent_color => 'Veldu áherslulit';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Blár';

  @override
  String get color_cyan => 'Blágrænn';

  @override
  String get color_green => 'Grænn';

  @override
  String get color_light_brown => 'Sjálfgefið';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Appelsínugult';

  @override
  String get color_pink => 'Bleikur';

  @override
  String get color_red => 'Rauður';

  @override
  String get color_rust => 'Ryð';

  @override
  String get color_teal => 'Blágrænn';

  @override
  String get text_contrast_mode => 'Textaandstæður';

  @override
  String get contrast_high => 'Hátt';

  @override
  String get contrast_medium => 'Miðlungs';

  @override
  String get contrast_low => 'Lágt';

  @override
  String get product_refresher_internet_not_found => 'Vara fannst ekki!';

  @override
  String get product_refresher_internet_not_connected =>
      'Þú ert ekki tengdur við internetið!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Netþjónn niðri ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Villa í netþjóni ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Vara fannst ekki!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Vara með eftirfarandi strikamerki er ekki til í gagnagrunninum okkar: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Engin nettenging!';

  @override
  String get product_loader_network_error_message =>
      'Gakktu úr skugga um að snjallsíminn þinn sé tengdur við WiFi net eða að farsímagögn séu virkjuð';

  @override
  String get page_not_found_title => 'Síða fannst ekki!';

  @override
  String get page_not_found_button => 'Fara aftur á forsíðuna';

  @override
  String get download_data => 'Sækja gögn';

  @override
  String get download_top_products =>
      'Sæktu 1000 vinsælustu vörurnar í þínu landi til að skanna þær samstundis';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count vörurnar',
    );
    return 'Sæktu vinsælustu $_temp0 í þínu landi til að skanna þær samstundis';
  }

  @override
  String get download_in_progress => 'Sæki gögn\nÞetta gæti tekið smá tíma';

  @override
  String downloaded_products(int num) {
    return '$num vörur bættar við';
  }

  @override
  String get update_offline_data => 'Uppfæra vörugögn án nettengingar';

  @override
  String get update_local_database_sub =>
      'Uppfæra gagnagrunninn með vörum á staðnum með nýjustu gögnum frá Open Food Facts.';

  @override
  String get clear_local_database => 'Hreinsa vörugögn án nettengingar';

  @override
  String get clear_local_database_sub =>
      'Hreinsaðu öll staðbundin vörugögn úr forritinu þínu til að losa um pláss';

  @override
  String deleted_products(int num) {
    return '$num vörur eyddar';
  }

  @override
  String get loading => 'Loading…';

  @override
  String get know_more => 'Vita meira';

  @override
  String get offline_data_desc =>
      'Smelltu til að fá frekari upplýsingar um gögn án nettengingar';

  @override
  String get offline_product_data_title => 'Ótengdar vöruupplýsingar';

  @override
  String available_for_download(int num) {
    return '$num vörur tiltækar til tafarlausrar skönnunar';
  }

  @override
  String get country_selector_title => 'Veldu land þitt:';

  @override
  String get currency_selector_title => 'Veldu gjaldmiðil þinn:';

  @override
  String get language_selector_title => 'Veldu tungumál:';

  @override
  String get language_selector_section_selected => 'Valin tungumál';

  @override
  String get language_selector_section_frequently_used => 'Oft notað';

  @override
  String get action_delete_list => 'Eyða';

  @override
  String get action_change_list => 'Breyta núverandi lista';

  @override
  String get product_list_create => 'Búa til';

  @override
  String get product_list_create_tooltip => 'Búa til nýjan lista';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (New calculation)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (New calculation)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unknown Nutri-Score (New calculation)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score is not applicable';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score is not applicable (New calculation)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Grænt stig A';

  @override
  String get environmental_score_b_new => 'Grænt stig B';

  @override
  String get environmental_score_c_new => 'Grænt stig C';

  @override
  String get environmental_score_d_new => 'Grænt stig D';

  @override
  String get environmental_score_e_new => 'Grænt stig E';

  @override
  String get environmental_score_unknown_new => 'Óþekkt grænt stig';

  @override
  String get environmental_score_not_applicable_new => 'Grænt stig gildir ekki';

  @override
  String get nova_group_generic_new => 'Ofurunninn matur - NOVA hópar';

  @override
  String get nova_group_1 => 'NOVA hópur 1';

  @override
  String get nova_group_2 => 'NOVA hópur 2';

  @override
  String get nova_group_3 => 'NOVA hópur 3';

  @override
  String get nova_group_4 => 'NOVA hópur 4';

  @override
  String get nova_group_unknown => 'Óþekktur NOVA hópur';

  @override
  String get nutrition_facts => 'Næringargildi';

  @override
  String get faq_title_partners =>
      'Samstarfsaðilar og verndarar félagasamtakanna';

  @override
  String get faq_title_vision =>
      'Sýn, markmið, gildi og áætlanir Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Settu upp Open Beauty Facts til að búa til snyrtivörugagnagrunn';

  @override
  String get faq_title_install_pet =>
      'Settu upp Open Pet Food Facts til að búa til gagnagrunn um gæludýrafóður';

  @override
  String get faq_title_install_product =>
      'Settu upp Open Products Facts til að búa til vörugagnagrunn til að lengja líftíma hluta.';

  @override
  String get faq_nutriscore_nutriscore =>
      'Ný útreikningur á næringargildinu: hvað er nýtt?';

  @override
  String get contact_title_pro_page =>
      'Fagmaður? Flyttu inn vörur þínar í Open Food Facts';

  @override
  String get contact_title_pro_email => 'Hafa samband við framleiðanda';

  @override
  String get contact_title_press_page => 'Fréttasíða';

  @override
  String get contact_title_press_email => 'Tengiliður fjölmiðla';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar =>
      'Gerast áskrifandi að dagatali samfélagsins okkar';

  @override
  String get hunger_games_loading_line1 =>
      'Vinsamlegast gefið okkur nokkrar sekúndur…';

  @override
  String get hunger_games_loading_line2 => 'Við erum að sækja spurningarnar!';

  @override
  String get hunger_games_error_label =>
      'Argh! Eitthvað fór úrskeiðis… og við gátum ekki hlaðið inn spurningunum.';

  @override
  String get hunger_games_error_retry_button => 'Við skulum reyna aftur!';

  @override
  String get reorder_attribute_action => 'Endurraða eigindunum';

  @override
  String get link_cant_be_opened =>
      'Ekki er hægt að opna þennan tengil í tækinu þínu. Gakktu úr skugga um að þú hafir uppsettan vafra.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Upplýsingar um $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Upplýsingar um $pageName með $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Deila';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Hvar er hægt að finna nýja útreikninginn á Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score er notað í 7 löndum: Frakklandi, Þýskalandi, Belgíu, Spáni, Lúxemborg, Hollandi og Sviss.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Framleiðendur hafa í mesta lagi **2 ár** frá undirritun tilskipunarinnar **til að skipta út** gömlu útreikningunum fyrir þá nýju.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Hvað er Græna stigagjöfin?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Græna stigið er lógó sem miðar að því að upplýsa þig um **umhverfisáhrif matvæla**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Litakóðinn er breytilegur frá dökkgrænum (**A+**) fyrir vörurnar sem hafa **minnst áhrif** til dökkrauðum (**F**) fyrir vörurnar sem hafa **mest áhrif**.';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score lógóin';

  @override
  String get guide_greenscore_lca_title => 'Kjarninn: Lífsferilsmat (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Vísindalegt mat á matvælaflokkum';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Fyrir hvern vöruflokk er ákveðið viðmiðunarstig með því að nota gögn úr umhverfisgagnagrunninum Agribalyse (hannaður af ADEME og INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Lífsferilsgreining** er stöðluð matsaðferð til að framkvæma fjölþrepa og fjölþátta umhverfismat.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Það mælir:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 framleiðsluskref';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Packaging';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 vísbendingar um umhverfisáhrif';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Loftslagsbreytingar/kolefnisspor';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Þynning ósonlagsins';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Jónandi geislun';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Land';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Vatns- og orkunotkun';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Loftmengun';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Sjávar- og ferskvatn (agnir, súrnun, ofauðgun)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Tæming auðlinda.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bónusar og refsingar';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Til að verðlauna betri vörur innan tiltekins flokks, beitum við síðan **bónusum og refsingum byggðum á nokkrum viðmiðum**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Bónus** er veittur vörum sem hafa **opinbert merki, merki eða vottun sem tryggir umhverfislegan ávinning** (lífrænt, sanngjarnt viðskipti, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origin of ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Bónus** er veittur út frá uppruna innihaldsefnanna. Þessi bónus tekur mið af **áhrifum á flutninga** og einnig af **umhverfisstefnu** lands hvers framleiðanda.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Refsing** er veitt vörum sem innihalda innihaldsefni sem hafa veruleg **neikvæð áhrif á líffræðilegan fjölbreytileika og vistkerfi**, svo sem pálmaolíu, en framleiðsla hennar veldur mikilli skógareyðingu.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Packaging';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Sekt** er reiknuð út frá því að taka tillit til **hringrásar umbúða** (notkun endurunnins hráefnis og endurvinnanleika) og ofpökkunar.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Til að reikna út Græna stigið nákvæmlega er nauðsynlegt að hafa upplýsingar sem eru ekki endilega tilgreindar á umbúðunum (eins og uppruni og nákvæmt hlutfall hvers innihaldsefnis) eða sem eru sjaldan tiltækar í nothæfu formi (eins og listi yfir alla íhluti umbúðanna ásamt nákvæmum tegundum plasts sem notaðar eru).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Meðalgildi eru notuð þegar þessar upplýsingar eru ekki enn tiltækar**, en við erum nú að kalla eftir því að allir hjálpi okkur að safna þessum upplýsingum sem verða mjög gagnlegar fyrir Green-Score en einnig til margra annarra nota.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Hvernig geta borgarar hjálpað til?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Allir borgarar geta hjálpað okkur að safna og skipuleggja upplýsingar sem eru til staðar á vörum eða sem hægt er að álykta út frá þeim, svo sem upplýsingar um **umbúðir**: „Mission Emballages“: stórfelld samstarfsskráning á umbúðum fyrir allar matvæli (á frönsku).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Hvernig framleiðendur geta hjálpað';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Framleiðendur geta sent okkur upplýsingar sínar beint í gegnum ókeypis vettvang okkar fyrir framleiðendur.';

  @override
  String get guide_greenscore_better_product_title =>
      'Hvaða vara er betri fyrir plánetuna?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Það getur verið erfitt að segja til um það';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Að velja sjálfbæran mat er eitt það öflugasta sem við getum gert fyrir loftslagið, þar sem **matvælakerfi okkar á heimsvísu ber ábyrgð á meira en fjórðungi allrar losunar gróðurhúsalofttegunda**.\n(Heimild: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Þú hefur völdin!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Góðu fréttirnar eru þær að þetta gefur okkur öfluga leið til að skapa breytingar.\n**Hvert og eitt okkar borðar um 1.000 máltíðir á hverju ári**. Það eru 1.000 tækifæri til að **velja betri framtíð fyrir plánetuna**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Hjálpar til við að taka ábyrgð og taka ákvarðanir';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Það getur virst flókið að velja sjálfbæran mat. Merkingar eru ruglingslegar og upplýsingar vantar oft. Græna einkunnin var búin til til að einfalda þetta og gefa þér **skýra**, **vísindalega** og **gagnsæja** umhverfismat fyrir matvæli, nákvæmlega þar sem þú þarft á því að halda: þegar þú verslar.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Gagnsæi';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Ólíkt einkaleyfisvernduðum merkjum er útreikningur Græna stigsins **algjörlega opinn** og hver sem er getur **staðfest hann**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'Hvað er ofurvinnsla?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA hóparnir upplýsa þig um stig matvælavinnslu.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA flokkunin gerir kleift að flokka matvæli í **fjóra hópa** byggt á **gráðu iðnaðarvinnslu** (lágt unnar eða óunnar matvörur, hráefni í matargerð, unnar matvörur, ofurunnar matvörur).';

  @override
  String get guide_nova_logos_caption => 'NOVA lógóin';

  @override
  String get guide_nova_groups_title => 'Fjórir NOVA hóparnir';

  @override
  String get guide_nova_groups_intro =>
      'Það eru fjórir NOVA hópar, og sá vandasamasti er hópur 4 - Ofurunnin matvæli.';

  @override
  String get guide_nova_groups_arg1_title => 'Lítið unnar eða óunnar matvörur';

  @override
  String get guide_nova_groups_arg1_text =>
      'Óunnin (eða náttúruleg) matvæli eru **ætir hlutar plantna** (fræ, ávextir, lauf, stilkar, rætur) **eða dýra** (vöðvar, innmatur, egg, mjólk), sem og sveppir, þörungar og vatn, eftir að hafa verið aðskilin frá náttúrunni.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various Preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most Processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. They can Be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these Formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products Also contain other sources of energy and nutrients not typically used in culinary preparations. some of these Are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Vandamálin með ofurvinnslu';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Öfgafull vinnsla á innihaldsefnum matvæla';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Margar þeirra eru **fengnar úr frekari vinnslu á innihaldsefnum matvæla**, svo sem hertum eða víxlesteruðum olíum, vatnsrofnum próteinum, sojapróteineinangrun, maltódextrín, invertsykri og maíssírópi með háu frúktósainnihaldi.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Aukefni sem fara lengra en hreint matvælaöryggi';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Aukefni í öfgafullum matvælum eru meðal annars þau sem einnig eru notuð í unnum matvælum, svo sem rotvarnarefni, andoxunarefni og bindiefni. Meðal aukefna sem finnast eingöngu í öfgafullum vörum eru þau sem notuð eru **til að herma eftir eða auka skynjunareiginleika matvæla eða til að dylja óþægilega þætti fullunninnar vöru**. Þessi aukefni eru meðal annars litarefni og aðrir litir, litabindandi efni; bragðefni, bragðbætandi efni, sætuefni án sykurs; og hjálparefni við vinnslu eins og kolsýringarefni, stinnandi efni, fyllingarefni og efni sem draga úr fyllingu, froðumyndandi efni, kekkjavarnarefni og gljáefni, ýruefni, bindiefni og rakabindandi efni.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Vinnsla sem þú getur ekki gert heima';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Fjölmargar ferlar eru notaðar** til að sameina venjulega mörg innihaldsefni og búa til lokaafurðina (þess vegna „öfgafullunnið“). Ferlarnir fela í sér nokkrar **sem eiga sér engar innlendar jafngildir**, svo sem vetnun og vatnsrof, útpressun og mótun og forvinnslu fyrir steikingu.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Rándýr og fjárhagslegir þættir ofurvinnslu';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Megintilgangur öfgavinnslu er að skapa vörumerktar**, **þægilegar** (endingargóðar, tilbúnar til neyslu), **aðlaðandi** (ofurbragðgóðar) og **mjög arðbærar** (ódýr innihaldsefni) matvörur sem eru hannaðar til að koma í stað allra annarra matvælaflokka. Ofurunnar matvörur eru yfirleitt pakkaðar á aðlaðandi hátt og markaðssettar á öflugan hátt.';

  @override
  String get guide_nova_explanations_arg5_title => 'Heilsufarsáhætta';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Frá árinu 2018, með NutriNet-Santé, hafa fyrstu tengslin milli **neyslu á ofurunnnum matvælum og aukinnar hættu á krabbameini, hjarta- og æðasjúkdómum og sykursýki verið sýnd**. Í dag staðfesta meira en 90 rannsóknir um allan heim þessar niðurstöður.\nSterkustu tengslin tengjast **offitu, dánartíðni af völdum hjarta- og æðasjúkdóma og þunglyndiseinkennum**. Hjá börnum sjást áhrifin fyrst og fremst á þyngd og ójafnvægi í fituefnum.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Lönd mæla með að takmarka þau';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Sum lönd nota NOVA-hópana fyrir mataræðisleiðbeiningar sínar eða markmið, til dæmis:\n\n- **🇧🇷 Mataræðisleiðbeiningar Brasilíu** **mæla með að takmarka neyslu** á unnum matvælum og forðast ofurunninn mat.\n\n- **🇫🇷 Markmið Frakklands** í lýðheilsu- og næringarstefnu fyrir árin 2018-2022 miða að því að **draga úr neyslu á ofurunnnum matvælum í 4. flokki um 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-is.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Velkomin(n) á Opna matarstaðreyndir!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Hvað eru Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts er **samvinnuþýður**, **ókeypis** og **opinn** gagnagrunnur yfir matvæli frá öllum heimshornum.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Við teljum að allir ættu að hafa aðgang að upplýsingum um það sem þeir borða. Með því að safna gögnum um innihaldsefni, ofnæmisvalda, næringargildi og fleira, **styrkjum við neytendur til að taka upplýstar ákvarðanir** og stuðlum að auknu gagnsæi í matvælaiðnaðinum.**';

  @override
  String get guide_open_food_facts_features_title =>
      'Eiginleikar Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Fáðu tilkynningar um óæskileg innihaldsefni';

  @override
  String get guide_open_food_facts_tips_title =>
      'Ráð til að taka frábærar myndir';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Ekki má';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Forðist skugga og glampa.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Enginn óskýr eða óskýr texti.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Ekki klippa út hluta af textanum.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Forðastu annasama bakgrunna.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Gera';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Notið góða, jafna lýsingu.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Gakktu úr skugga um að textinn sé skarpur og læsilegur.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Taktu upp allan innihaldslistann.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Geymið vöruna á sléttu yfirborði.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Hjálpaðu okkur að byggja upp „Wikipedia matvæla“';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Einkunn fyrir næringargæði';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Einkunn til að forðast ofurunninn mat';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Einkunn fyrir plánetuna';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-is.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Velkomin(n) á Opna staðreyndir um gæludýrafóður!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Hvað eru staðreyndir um opið gæludýrafóður?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts útvíkkar markmið okkar til loðinna vina okkar! Þetta er **gagnagrunnur með gæludýrafóðri fyrir ketti, hunda og aðra félaga**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Við söfnum upplýsingum um **innihaldsefni**, **næringargreiningar** og leiðbeiningar um fóðrun til að hjálpa gæludýraeigendum að velja besta fóðrið fyrir þarfir dýranna sinna.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Eiginleikar Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Fáðu tilkynningar um óæskileg innihaldsefni';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Er gæludýrið þitt með ofnæmi fyrir einhverjum innihaldsefnum? Þú getur stillt lista yfir snyrtivörur sem ber að forðast, beint í appinu!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Ráð til að taka frábærar myndir';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Ekki má';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Forðist skugga og glampa.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Enginn óskýr eða óskýr texti.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Ekki klippa út hluta af textanum.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Forðastu annasama bakgrunna.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Gera';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Notið góða, jafna lýsingu.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Gakktu úr skugga um að textinn sé skarpur og læsilegur.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Taktu upp allan innihaldslistann.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Geymið vöruna á sléttu yfirborði.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Athugasemd um stigagjöf';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Þróun stigakerfis fyrir gæludýrafóður **er ekki forgangsverkefni eins og er**. Aðferðafræðin yrði flókin þar sem næringarþarfir eru mjög mismunandi eftir tegundum, aldri og heilsufari. Við höfum ekki fundið neinn óháðan vísindateymi ennþá sem getur þróað slíka stigagjöf.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-is.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Velkomin á Opna fegurðarstaðreyndir!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Hvað eru Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts er samvinnugagnagrunnur með **snyrtivörum**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Markmið okkar er að greina innihaldslista til að hjálpa þér að **skilja hvað er í persónulegum snyrtivörum**. Við söfnum gögnum um innihaldsefni, ofnæmisvalda og umbúðir, allt frá rakakremum til förðunar, til að stuðla að gagnsæi í snyrtivöruiðnaðinum.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Eiginleikar Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Fáðu tilkynningar um óæskileg innihaldsefni';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Ertu með ofnæmi fyrir einhverjum innihaldsefnum? Viltu forðast innihaldsefni sem valda snyrtivörum? Viltu forðast umdeild innihaldsefni? Þú getur stillt lista yfir snyrtivörur sem þú vilt forðast, beint í appinu!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Ráð til að taka frábærar myndir';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Ekki má';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Forðist skugga og glampa.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Enginn óskýr eða óskýr texti.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Ekki klippa út hluta af textanum.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Forðastu annasama bakgrunna.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Gera';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Notið góða, jafna lýsingu.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Gakktu úr skugga um að textinn sé skarpur og læsilegur.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Taktu upp allan innihaldslistann.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Taktu eins margar myndir og þörf krefur ef flaskan er bogin.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Þú gætir þurft að fletta af merkimiðanum til að sjá innihaldslýsinguna.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Geymið vöruna á sléttu yfirborði.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Athugasemd um stigagjöf';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Ólíkt matvörum hefur snyrtivöruheimurinn **ekki almennt viðurkennt, ríkisstyrkt stigakerfi eins og Nutri-Score**. Áhrif innihaldsefna geta verið mjög persónuleg og háð húðgerð, ofnæmi og einstaklingsbundnum áhyggjum.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-is.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices er verkefni sem safnar og deilir verði á vörum um allan heim. Þetta er opinbert gagnasafn sem hægt er að nota til rannsókna, greininga og fleira. Open Prices er þróað og viðhaldið af Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Við erum að safna saman opnum gagnasafni um verð.** Notendur geta bætt við verðum í gegnum þetta vefforrit eða í gegnum opinbera Open Food Facts smáforritið. Smásalar eða forrit frá þriðja aðila geta einnig lagt sitt af mörkum með því að nota API-ið okkar.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Safnaðu myndum af verðmiðum í göngum';

  @override
  String get guide_open_prices_how_arg2_title => 'Safnaðu myndum af kvittunum';

  @override
  String get guide_open_prices_why_title =>
      'Af hverju gerir Open Food Facts þetta?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Verðupplýsingar eru afar mikilvægar til að skilja matvælakerfi. Þær eru lykilþáttur í að skilja kostnað við matvæli og stuðla að hollara mataræði. Að opna verðgögn er leið til að auðvelda vísindamönnum, blaðamönnum og borgurum að **skilja betur hvernig matvælaverð breytist landfræðilega og í tíma**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Fylgstu með þróun verðs með tímanum';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Sjáðu **þróun verðs**: verðhjöðnun, ódýr verðbólga, við getum fylgst með þeim saman!';

  @override
  String get guide_open_prices_why_arg2_title => 'Berðu saman verð nálægt þér';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Þegar við fáum fleiri verð geturðu fundið **ódýrustu verslanirnar í kringum þig**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Hefurðu íhugað að skafa verð af vefsíðum smásala?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Verðskrapun er íhugaður möguleiki í framtíðarútgáfu af Open Prices, en það yrði gert af Open Prices sjálfu svo við getum haft sönnun fyrir verðinu út frá HTML síðunni.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Þú getur lagt fram verðlagningu með því að nota API-ið okkar.\nEf þú vilt leggja fram verðlagningu í stórum stíl, vinsamlegast hafðu samband við okkur á prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Velkomin(n) í Staðreyndir um opnar vörur!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Hvað eru staðreyndir um opnar vörur?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts er gríðarstór, opinn gagnagrunnur fyrir **allar vörur með strikamerki, sem eru ekki matvæli, snyrtivörur eða gæludýrafóður**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Frá **raftækjum** til **leikfanga** og **fötum** til **hreinsiefna**, ef það er með strikamerki, er hægt að bæta því við. Þetta verkefni miðar að því að búa til „Internet hlutanna“ fyrir hversdagslega hluti og gera upplýsingar um þá aðgengilegar öllum.';

  @override
  String get guide_open_products_facts_features_title =>
      'Eiginleikar Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Markmið Open Products Facts er að veita neytendum möguleika á að **lengja líftíma hluta** með því að bjóða upp á hringlaga lausnir til að viðhalda, **gera við**, **endurvinna** hluti sína eða gefa þeim nýjan eiganda.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Kolefnisspor fyrir sumar vörur';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Áhrif CO2** frá frönsku umhverfisstofnuninni ADEME veitir upplýsingar um **kolefnisáhrif** margra flokka, vertu viss um að flokka vörur nákvæmlega.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Viðgerðarhæfnivísitala fyrir margar vörur';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Þegar franskur viðgerðarvísitala er tiltæk birtum við hana. Þar að auki **geturðu byrjað að safna breytunum með Folksonomy vélinni**; þannig að við getum endurreiknað hana sjálf í framtíðinni, jafnvel í löndum þar sem hún er ekki tiltæk.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Finndu leiðir til að gefa/endurselja vöruna þína';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Við bjóðum upp á tengla á **þriðja aðila sem eru umhverfisvænar** sem hjálpa þér að fá þá vöru sem þú ert að leita að, sem notaða vöru, til að vera mildari við auðlindir jarðarinnar.\nAthugið að við erum ekki greidd fyrir það og að kerfið virkar aðeins sem dæmi fyrir tvær vefsíður í Frakklandi. Þú getur hjálpað til við að stækka þetta kerfi með því að skrá fleiri síður á wiki-síðunni.';

  @override
  String get guide_open_products_facts_information_title =>
      'Hvaða upplýsingar eru gagnlegar?';

  @override
  String get guide_open_products_facts_information_text =>
      'Fyrir svona fjölbreytt úrval atriða **eru gögnin sem við söfnum sveigjanleg**. Til að gera það **bjuggum við til Folksonomy vélina**.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'Þjóðfræðivélin';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy vélin er tól sem hjálpar þér að klára vörur með viðeigandi eiginleikum. Þetta hjálpar til við að bæta leit og uppgötvun, en einnig að reikna út og birta áhugaverða hluti í framtíðinni.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Þú getur bætt við hvaða lyklum og gildum sem er eins og: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Þú færð sjálfvirkar tillögur að mögulegum eiginleikum og þér er hjartanlega velkomið að bæta við og skrá nýjar á uppáhalds vörutegundunum þínum.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-is.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Opna matarstillingar';

  @override
  String get guide_coming_soon_button_title => 'Kemur bráðlega';

  @override
  String get guide_learn_more_subtitle => 'Ýttu til að fá frekari upplýsingar';

  @override
  String get preview_badge => 'Forskoðun';

  @override
  String get prices_feedback_form =>
      'Smelltu hér til að senda okkur ábendingar þínar um þennan nýja eiginleika!';

  @override
  String get menu_button_list_actions => 'Veldu aðgerð';

  @override
  String get error_loading_photo => 'Villa í að hlaða mynd';

  @override
  String get photo_viewer_action_use_picture_as => 'Nota sem…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Nota þessa mynd sem…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Nota þessa mynd sem… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Nánari upplýsingar';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Nánari upplýsingar um þessa mynd';

  @override
  String get photo_viewer_details_title => 'Upplýsingar um myndina';

  @override
  String get photo_viewer_details_contributor_title => 'Contributor';

  @override
  String get photo_viewer_details_size_title => 'Stærð';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixlar';
  }

  @override
  String get photo_viewer_details_date_title => 'Dagsetning';

  @override
  String get photo_viewer_details_url_title => 'Vefslóð';

  @override
  String get product_page_compatibility_score => 'Samhæft';

  @override
  String get user_lists_action_multi_select => 'Fjölval';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Eindrægnisstig þitt: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Front picture';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Ingredients picture';

  @override
  String get product_image_nutrition_accessibility_label => 'Næringarmynd';

  @override
  String get product_image_packaging_accessibility_label => 'Mynd af umbúðum';

  @override
  String get product_image_other_accessibility_label => 'Önnur mynd';

  @override
  String get product_image_outdated_message => 'Þessi mynd gæti verið úrelt';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (þessi mynd gæti verið úrelt)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (framleiðandinn gæti læst þessari mynd)';
  }

  @override
  String get product_image_error => 'Ekki tókst að hlaða myndinni!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Ekki tókst að hlaða $type (netvilla?)';
  }

  @override
  String get product_page_image_no_image_available => 'Engin\nmynd!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Engin mynd tiltæk fyrir þessa vöru';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Endurraða eða fela aðgerðir';

  @override
  String get product_page_action_bar_setting_modal_title => 'Breyta aðgerðum';

  @override
  String get product_page_action_bar_item_move_up => 'Færa upp';

  @override
  String get product_page_action_bar_item_move_down => 'Færa niður';

  @override
  String get product_page_action_bar_item_enable => 'Virkja aðgerð';

  @override
  String get product_page_action_bar_item_disable => 'Slökkva á aðgerð';

  @override
  String get product_page_pending_operations_banner_title =>
      'Hleður upp breytingunum þínum…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Gögnin sem birtast á þessari síðu **endurspegla ekki breytingar þínar enn**.\nVinsamlegast bíðið í nokkrar sekúndur…';

  @override
  String get product_add_a_language => 'Bæta við tungumáli';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Strikamerki $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Fjarlægðu þessa vöru úr hringekjunni';

  @override
  String get carousel_unsupported_header => 'Óstuddur strikamerki!';

  @override
  String get carousel_unsupported_title => 'Úbbs!';

  @override
  String get carousel_unsupported_text =>
      'Strikamerkið sem skannað er er ekki stutt af Open Food Facts!';

  @override
  String get carousel_error_header => 'Villa!';

  @override
  String get carousel_error_title => 'Þetta er leiðinlegt!';

  @override
  String get carousel_error_text_1 =>
      'Við gátum ekki sótt upplýsingar um þetta strikamerki:';

  @override
  String get carousel_error_text_2 =>
      'Vinsamlegast athugaðu nettenginguna þína eða smelltu á þennan hnapp:';

  @override
  String get carousel_error_button => 'Reyna aftur';

  @override
  String get carousel_unknown_product_header => 'Óþekkt vara';

  @override
  String get carousel_unknown_product_title =>
      'Til hamingju!\nÞú hefur fundið __þennan sjaldgæfa gimstein!__';

  @override
  String get carousel_unknown_product_text =>
      'Samvinnugagnagrunnur okkar inniheldur meira en **3 milljónir vara**, en þetta strikamerki er ekki til: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'Hleður upplýsingar...';

  @override
  String get carousel_loading_title =>
      'Þú hefur rétt í þessu skannað vöru með eftirfarandi strikamerki:';

  @override
  String get carousel_loading_text =>
      'Við erum að leita að því í gagnagrunni okkar með meira en **3 milljónum vara!**';

  @override
  String get product_type_subtitle_food => 'Grænmeti, ávextir, frosinn matur…';

  @override
  String get product_type_subtitle_beauty => 'Förðun, sápur, tannkrem…';

  @override
  String get product_type_subtitle_pet_food => 'Fóður fyrir hunda og ketti…';

  @override
  String get product_type_subtitle_product => 'Snjallsímar, húsgögn…';

  @override
  String get photo_field_front => 'Vörumynd';

  @override
  String get photo_field_ingredients => 'Mynd af innihaldsefnum';

  @override
  String get photo_field_nutrition => 'Næringarmynd';

  @override
  String get photo_field_packaging => 'Mynd af leiðbeiningum um endurvinnslu';

  @override
  String get photo_already_exists => 'Þessi mynd er nú þegar til';

  @override
  String get photo_missing => 'Þessi mynd vantar';

  @override
  String get date => 'Dagsetning';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'Afturkalla fyrri aðgerð';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Heimskort af $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap þátttakendur';

  @override
  String get not_applicable_short => 'Ekki til';

  @override
  String get knowledge_panel_warning_text => 'Warning';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Hvers vegna er þessi næringargildi frábrugðin þeirri sem er á umbúðunum?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Tvær mögulegar skýringar eru fyrir hendi:\nInnihaldslisti og/eða næringarupplýsingar eru ekki uppfærðar.\n\nVið birtum „Nýja útreikninginn“ á næringarstiginu (eða V2). Vinsamlegast athugið að þú sjáir borðann „Nýja útreikninginn“ á umbúðunum.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Athugaðu innihaldsefnin';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Athugaðu næringargildi';

  @override
  String url_not_supported(String url) {
    return 'Því miður getum við ekki opnað slóðina:\n$url';
  }

  @override
  String get product_list_export => 'Útflutningur';

  @override
  String get product_list_import => 'Innflutningur';

  @override
  String get product_footer_action_barcode => 'Skoða strikamerki';

  @override
  String get product_footer_action_barcode_short => 'Barcode';

  @override
  String get product_footer_action_open_website => 'Opna vefsíðu';

  @override
  String get product_footer_action_report => 'Skýrsla';

  @override
  String get product_footer_action_contributor_guide => 'Hjálp';

  @override
  String get product_footer_action_data_quality_tags => 'Gögnagæði';

  @override
  String get product_page_tab_for_me => 'Fyrir mig';

  @override
  String get product_page_tab_website => 'Vefsíða';

  @override
  String get product_page_tab_prices => 'Verð';

  @override
  String get prices_explanation_card_title => 'Af hverju verð?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** er verkefni til að safna og deila verði á vörum um allan heim 🌍. Open Prices er þróað og viðhaldið af Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Frekari upplýsingar';

  @override
  String get product_page_tab_folksonomy => 'Þjóðfræði';

  @override
  String get folksonomy_explanation_card_title =>
      'Hvað eru eiginleikar fólksonomíu?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Eiginleikar eru byggðir á **lykilgildum**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Þessir eiginleikar eru búnir til og skráðir af þátttakendum fyrir alls kyns notkun.';

  @override
  String get folksonomy_action_external_link_title =>
      'Opna utanaðkomandi tengil';

  @override
  String get folksonomy_action_external_link_warning =>
      'Utanaðkomandi tenglar gætu verið óöruggir. Viltu virkilega heimsækja þá?';

  @override
  String get prices_products_empty_title => 'Ekkert verð tiltækt';

  @override
  String get prices_products_empty_explanation =>
      'Vertu fyrstur til að leggja þitt af mörkum!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Vinsælustu $pageSize vörurnar (samtals: $total)';
  }

  @override
  String get app_review_title => 'Hefurðu gaman af þessu forriti?';

  @override
  String get app_review_low => 'Gæti gert betur';

  @override
  String get app_review_medium => 'Ekki slæmt';

  @override
  String get app_review_high => 'Ég elska þetta!';

  @override
  String get app_review_feedback_modal_title =>
      'Hjálpaðu okkur að bæta forritið okkar';

  @override
  String get app_review_feedback_modal_content =>
      'Ef þú hefur nokkrar mínútur, gætirðu svarað þessu eyðublaði svo að **við getum bætt okkur í framtíðaruppfærslum**:';

  @override
  String get app_review_feedback_modal_open_form => 'Svaraðu eyðublaðinu';

  @override
  String get app_review_feedback_modal_later => 'Spyrðu mig síðar';

  @override
  String get nutrition_facts_extract_new =>
      'NÝTT: Þú getur sjálfkrafa dregið næringarefnin úr myndinni!';

  @override
  String get nutrition_facts_extract_button_text => 'Draga út núna';

  @override
  String get nutrition_facts_extract_in_progress => 'Útdráttur í gangi…';

  @override
  String get nutrition_facts_extract_successful => 'Útdráttur tókst';

  @override
  String get nutrition_facts_extract_failed =>
      'Mistókst að draga næringarefni úr myndinni';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Tölfræði';

  @override
  String get prices_stats_title => 'Verðtölfræði';

  @override
  String get prices_stats_prices_section => 'Verð';

  @override
  String get prices_stats_products_section => 'Vörur';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Ýmislegt';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Matur';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Vörur';

  @override
  String get prices_stats_pet_food => 'Gæludýrafóður';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Countries';

  @override
  String get prices_stats_price_tag => 'Verðmiði';

  @override
  String get prices_stats_receipt => 'Kvittun';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Vefsíða';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'Síðast uppfært þann';

  @override
  String get prices_stats_error => 'Villa kom upp við að hlaða inn tölfræði.';

  @override
  String get product_edit_robotoff_question_answered => 'Spurning svarað!';

  @override
  String get product_edit_robotoff_proof => 'Sönnun';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'Verð';

  @override
  String get preferences_prices_subtitle => 'Stjórnaðu verðstillingum þínum';

  @override
  String get preferences_card_project => 'Verkefnið Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribute';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'Tölfræði mín';

  @override
  String get preferences_contribute_subtitle => 'Þýða, bæta verkfæri okkar…';

  @override
  String get preferences_connect_title => 'Tengjast';

  @override
  String get preferences_connect_subtitle =>
      'Hafðu samband, eða fylgdu okkur á samfélagsmiðlum';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Hjálpaðu okkur að upplýsa milljónir neytenda um allan heim';

  @override
  String get preferences_card_help => 'Hjálp og stuðningur';

  @override
  String get preferences_faq_title => 'Algengar spurningar';

  @override
  String get preferences_faq_subtitle => 'Fáðu svör við spurningum þínum';

  @override
  String get logged_out => 'Útskráður';

  @override
  String get preferences_app_bar_message =>
      'Takk fyrir að vera einn af meðlimum okkar!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Sjá alla tölfræði';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Leitaðu $provider að \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Leita að stillingu (t.d. næringarstig)';

  @override
  String get preferences_accessibility_show_emoji => 'Aðgengi: Sýna emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Aðgengi: Fjarlægja liti';

  @override
  String get preferences_app_settings_products => 'Vörur';

  @override
  String get preferences_card_about => 'Um forritið';

  @override
  String get preferences_legal_information_title => 'Löglegar upplýsingar';

  @override
  String get preferences_legal_information_subtitle =>
      'Notkunarskilmálar, persónuverndarstefna og fleira';

  @override
  String get preferences_terms_of_use => 'Notkunarskilmálar';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts er gagnagrunnur um matvæli **sem allir búa til, fyrir alla**.\nÞú getur notað hann til að taka betri ákvarðanir um mat og þar sem hann er **opin gögn** getur hver sem er **endurnýtt hann í hvaða tilgangi sem er**.';

  @override
  String get preferences_privacy_policy => 'Persónuverndarstefna';

  @override
  String get preferences_licenses => 'Leyfi';

  @override
  String get preferences_about_app_title => 'Um appið';

  @override
  String get preferences_about_app_subtitle =>
      'Tæknilegar upplýsingar, upplýsingar um forritara og fleira';

  @override
  String get preferences_card_information => 'Information';

  @override
  String get preferences_version_number_title => 'Útgáfunúmer';

  @override
  String get preferences_scanner_title => 'Skanni';

  @override
  String get preferences_app_store => 'App-verslun';

  @override
  String get preferences_app_system_settings => 'Kerfisstillingar';

  @override
  String get preferences_source_code => 'Aðgangur að frumkóðanum';

  @override
  String get preferences_source_code_subtitle =>
      'Og byrjaðu að hafa áhrif fyrir milljónir';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Complete products';

  @override
  String get preferences_tips => 'Ráðleggingar';

  @override
  String get tips_discover_nutriscore => 'Uppgötvaðu nýja Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle => 'Á vefsíðu Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Stjórna reikningnum mínum';

  @override
  String get preferences_manage_account_tooltip =>
      'Stjórnaðu reikningnum þínum';

  @override
  String get preferences_change_password_title => 'Breyta lykilorðinu mínu';

  @override
  String get preferences_danger_zone => 'Hættusvæði';

  @override
  String get preferences_account_deletion_subtitle =>
      'Öll framlög þín munu glatast';

  @override
  String get preferences_contributions_title => 'Contributions';

  @override
  String get preferences_dev_mode_app_settings_title => 'Stillingar forritsins';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Mjög tilraunakennd leið til að skanna vörur án nettengingar';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Endurnýja allar vörur af netþjóninum';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Vinsamlegast forðist að gera það nema það sé algerlega nauðsynlegt';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Sýningarstilling';

  @override
  String get preferences_dev_mode_add_cards_title => 'Bæta kortum við skanna';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Bætir 3 sýnishornsvörum við skannann';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Þjóðsonomy gestgjafi';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Gestgjafi: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Tilraunir um aðgengi';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Fjölbreytt úrval af vörum fyrir verð';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Notandi pantaði þekkingarspjöld';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Tímabundinn aðgangur að staðsetningarleit';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Samanburður á tveimur eða þremur vörum';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Innflutningur vörulista';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Einkunnir og aðferðafræði';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Kynntu þér hvernig Nutri-Score er reiknað út';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Kynntu þér helstu breytingarnar á aðferðafræðinni';

  @override
  String get preferences_faq_discover_project_title => 'Discover the project';

  @override
  String get preferences_faq_discover_off_title =>
      'Uppgötvaðu staðreyndir um matvæli í opnum mæli';

  @override
  String get preferences_faq_discover_obf_title =>
      'Uppgötvaðu staðreyndir um fegurð í opnum skápum';

  @override
  String get preferences_faq_discover_opff_title =>
      'Uppgötvaðu staðreyndir um gæludýrafóður';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Uppgötvaðu staðreyndir um opnar vörur';

  @override
  String get preferences_faq_faq_title =>
      'Algengar spurningar - Algengar spurningar';

  @override
  String get preferences_faq_off_ngo_title =>
      'Frjáls félagasamtökin Open Food Facts';

  @override
  String get preferences_about_information_title => 'Information';

  @override
  String get preferences_connect_community_updates_title =>
      'Fáðu uppfærslur frá samfélaginu';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Vertu upplýstur með fréttum úr appinu og samfélaginu';

  @override
  String get preferences_connect_community_calendar_title =>
      'Gerast áskrifandi að dagatali samfélagsins okkar';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Taktu þátt með því að mæta á einn af sýndarviðburðum okkar';

  @override
  String get preferences_connect_blog_title => 'Bloggið Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Fáðu nýjustu fréttirnar um leið og þær gerast';

  @override
  String get preferences_connect_community_help_title =>
      'Fáðu hjálp frá samfélaginu';

  @override
  String get preferences_connect_improve_app_title =>
      'Hjálpaðu okkur að bæta appið';

  @override
  String get preferences_connect_debug_info_title =>
      'Sendu okkur villuleitarupplýsingar';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Sendið okkur tölvupóst með ítarlegum upplýsingum um villuleit';

  @override
  String get preferences_connect_feedback_title =>
      'Sendu okkur ábendingar um appið';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Hjálpaðu til við að móta framtíð appsins';

  @override
  String get preferences_connect_survey_title =>
      'Taktu þátt í könnuninni um appið';

  @override
  String get preferences_connect_survey_subtitle =>
      'Hjálpaðu okkur að skilja hvað við ættum að byggja næst';

  @override
  String get preferences_connect_professionals_title => 'Fagfólk';

  @override
  String get preferences_connect_pro_subtitle =>
      'Algjörlega ókeypis, tryggir nákvæm gögn fyrir 500 forrit og milljónir neytenda. Sjálfsafgreiðsla, samhæft við PIM eða töflureikna (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Hafðu samband til að byrja';

  @override
  String get preferences_connect_press_title => 'Press';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Fáðu allt efni sem þú þarft fyrir skýrsluna þína';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Hafðu samband ef þú hefur fyrirspurnir frá fjölmiðlum eða vilt láta okkur vita af skýrslunni þinni';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Vertu virkur sjálfboðaliði';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Þróun, samskipti, hönnun… hvers kyns sjálfboðaliðastarf eða sérfræðiþekking er vel þegin!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Uppgötvaðu nokkrar af þeim fjölmörgu leiðum sem þú getur lagt þitt af mörkum';

  @override
  String get preferences_contribute_mobile_dev_title => 'Þróun farsímaforrita';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Lærðu hvernig þú getur lagt þitt af mörkum til hugbúnaðarþróunar';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Daglegar óstöðugar byggingar, glænýir eiginleikar';

  @override
  String get preferences_contribute_local_community_title =>
      'Ræktaðu samfélag þitt';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Aðstoð við þýðingar á hugbúnaði, innihaldi og innihaldsgreiningum';

  @override
  String get preferences_contribute_share_subtitle =>
      'Við höfum útbúið lítið sniðmát til að hjálpa þér :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Einföld skref til að auka gagnsæi í matvælum í þínu landi';

  @override
  String get preferences_contribute_data_quality_title => 'Gögnagæði';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Vertu með í gagnagæðateyminu';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Taktu þátt í átaki okkar til að tryggja að gagnagrunnurinn sé tæmandi og nákvæmur';

  @override
  String get preferences_contributions_products_added_title => 'Bættar vörur';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nýjar vörur sem ég bætti við Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Vörur sem ég þarf að klára';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Allar ófullgerðar vörur';

  @override
  String get preferences_my_contributions_prices_title => 'Verð';

  @override
  String get preferences_my_contributions_my_prices_title => 'Verðin mín';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Verð mín, sannanir mínar…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Vörur sem þú getur hjálpað til við að klára';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Hjálpaðu til við að reikna út næringargildið og græna gildið í þínu landi';

  @override
  String get preferences_prices_user_prices_subtitle => 'Verð sem ég lagði til';

  @override
  String get preferences_prices_proofs_subtitle => 'Verðmiðar og kvittanir';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Taktu myndir af kvittunum þínum og skannaðu tengda strikamerki';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Taktu myndir af verði í búð';

  @override
  String get preferences_prices_newest_title => 'Nýjustu verð';

  @override
  String get preferences_prices_newest_subtitle =>
      'Nýjustu verðin sem Open Prices samfélagið hefur bætt við';

  @override
  String get preferences_prices_top_contributors_title =>
      'Þátttakendur með hæstu verðin';

  @override
  String get preferences_prices_metrics_title => 'Mælingar á opnu verði';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Fylgstu með þróun verkefnisins';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Leiðir til að leggja sitt af mörkum';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Staðfestu verð sem þú eða aðrir hafa bætt við með hjálp gervigreindar';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Bættu fljótt við mörgum kvittunum eða myndum af hillum úr myndavélarrúlunni þinni';

  @override
  String get preferences_prices_challenges_title => 'Mánaðarlegar áskoranir';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Taktu þátt í mánaðarlegum þemaverkefnum til að safna verðum';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Endurheimtu hollustugögnin þín';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Lærðu hvernig á að óska eftir gögnum þínum';

  @override
  String get preferences_page_customize_app_title => 'Sérsníddu appið';

  @override
  String get preferences_page_contribute_project_title =>
      'Leggja sitt af mörkum til verkefnisins';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Einfaldar leiðir til að hjálpa Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Einkunnagjöf, hjálp og fleira um verkefnið';

  @override
  String get product_edit_robotoff_positive_button => 'Samþykkja tillögu';

  @override
  String get product_edit_robotoff_negative_button => 'Hafna tillögu';

  @override
  String get product_edit_robotoff_show_proof => 'Sýna sönnunargögn';

  @override
  String get product_edit_robotoff_expand_proof => 'Stækka sönnunargögn';

  @override
  String get product_page_tab_raw_data => 'Óunnin gögn';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Síða $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Síða $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count af $total atriðum';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count af $total atriðum';
  }

  @override
  String item_count(int count) {
    return '$count atriði';
  }

  @override
  String item_count_string(String count) {
    return '$count atriði';
  }

  @override
  String get prices_no_result => 'Engar verðtölfræðiupplýsingar fundust.';

  @override
  String get prices_error_loading_more_items =>
      'Villa í að hlaða fleiri atriðum';

  @override
  String get prices_proof_error =>
      'Auðkenning mistókst, ekki tókst að sækja sönnunargögn';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count af $total sönnunum';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count af $total framlagsaðilum';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count af $total staðsetningum';
  }

  @override
  String prices_locations_count(int count) {
    return '$count staðsetningar';
  }

  @override
  String get restart_to_apply_message =>
      'Endurræstu forritið til að virkja breytingarnar.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafískt viðmót';

  @override
  String get preferences_app_settings_media_title => 'Fjölmiðlar';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Opna rannsóknarstofur um matvælaupplýsingar';

  @override
  String get preferences_root_account_title => 'Reikningur';

  @override
  String get preferences_contribute_translate_header =>
      'Færðu Open Food Facts yfir á þitt tungumál';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Skráðu þig í alfaútgáfu appsins';

  @override
  String get preferences_dev_mode_section_data => 'Framlög og vörugögn';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Ekki sýna þjóðfræði';

  @override
  String get preferences_account_title => 'Reikningur';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Bætt við $created';
  }

  @override
  String get location_map_details_title => 'Staðsetningarupplýsingar';

  @override
  String get location_map_details_name => 'Nafn';

  @override
  String get location_map_details_street => 'Gata';

  @override
  String get location_map_details_city => 'Borg';

  @override
  String get location_map_details_postcode => 'Póstnúmer';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Hnit';

  @override
  String get location_map_details_osm_id => 'OSM auðkenni';
}
