// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Indonesian (`id`).
class AppLocalizationsId extends AppLocalizations {
  AppLocalizationsId([String locale = 'id']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Ya';

  @override
  String get add => 'Tambahkan';

  @override
  String get account_delete_message =>
      'Anda yakin ingin menghapus akun?\nJika ada alasan khusus, silahkan bagikan di bawah';

  @override
  String get reason => 'Alasan';

  @override
  String get okay => 'Baik';

  @override
  String get validate => 'Validasikan';

  @override
  String get create => 'Buat';

  @override
  String get applyButtonText => 'Terapkan';

  @override
  String get next_label => 'Selanjutnya';

  @override
  String get continue_label => 'Selanjutnya';

  @override
  String get exit_label => 'Keluar';

  @override
  String get previous_label => 'Sebelumnya';

  @override
  String get go_back_to_top => 'Kembali ke atas';

  @override
  String get save => 'menyimpan ';

  @override
  String get save_confirmation => 'Apa Anda yakin ingin menyimpan?';

  @override
  String get skip => 'Lewati';

  @override
  String get cancel => 'Batalkan';

  @override
  String get ignore => 'Abaikan';

  @override
  String get close => 'Tutup';

  @override
  String get no => 'Tidak';

  @override
  String get stop => 'Berhenti';

  @override
  String get finish => 'Selesai';

  @override
  String get calculate => 'Hitung';

  @override
  String get reset_food_prefs => 'Atur ulang preferensi makanan Anda';

  @override
  String get error => 'Ada yang salah';

  @override
  String get error_occurred => 'Terjadi kesalahan';

  @override
  String get featureInProgress =>
      'Kami masih mengerjakan fitur ini, pantau terus';

  @override
  String get label_web => 'Lihat di web';

  @override
  String get learnMore => 'Pelajari lebih lanjut';

  @override
  String get unknown => 'Tidak diketahui';

  @override
  String get match_very_good => 'Sangat sesuai';

  @override
  String get match_good => 'Sesuai';

  @override
  String get match_poor => 'Buruk';

  @override
  String get match_may_not => 'Mungkin tidak sesuai';

  @override
  String get match_does_not => 'Tidak sesuai';

  @override
  String get match_unknown => 'Hasil tidak diketahui';

  @override
  String get match_short_very_good => 'Sangat sesuai';

  @override
  String get match_short_good => 'Sesuai';

  @override
  String get match_short_poor => 'Buruk';

  @override
  String get match_short_may_not => 'Mungkin tidak sesuai';

  @override
  String get match_short_does_not => 'Tidak sesuai';

  @override
  String get match_short_unknown => 'Hasil tidak diketahui';

  @override
  String get licenses => 'Lisensi';

  @override
  String get looking_for => 'Mencari';

  @override
  String get welcomeToOpenFoodFacts => 'Selamat datang di Open Food Facts';

  @override
  String get whatIsOff =>
      'OpenFoodFacts adalah organisasi nirlaba global yang didukung oleh komunitas lokal.';

  @override
  String get productDataUtility =>
      'Lihat data makanan yang cocok dengan preferensi Anda.';

  @override
  String get healthCardUtility => 'Pilih makanan yang baik bagi Anda.';

  @override
  String get ecoCardUtility => 'Pilih makanan yang baik bagi planet Anda.';

  @override
  String get server_error_open_new_issue =>
      'Tidak ada respons server! Anda dapat membuka masalah dengan tautan berikut ini.';

  @override
  String get sign_in_text =>
      'Masuk ke akun OpenFoodFacts untuk menyimpan kontribusi Anda';

  @override
  String get incorrect_credentials =>
      'Nama pengguna atau kata sandi Anda salah.';

  @override
  String get password_lost_incorrect_credentials =>
      'Email atau nama pengguna ini tidak ada. Silakan periksa kredensial Anda.';

  @override
  String get password_lost_server_unavailable =>
      'Saat ini kami sedang mengalami kelambatan pada server kami dan kami mohon maaf untuk itu. Silakan coba lagi nanti.';

  @override
  String get login => 'Masuk';

  @override
  String get login_result_type_server_unreachable =>
      'Jaringan tidak terjangkau';

  @override
  String get login_result_type_server_issue =>
      'Masalah pada server. Silakan coba lagi nanti.';

  @override
  String get login_page_username_or_email =>
      'Silakan masukkan nama pengguna atau email';

  @override
  String get login_page_password_error_empty => 'Silakan masukkan kata sandi';

  @override
  String get create_account => 'Buat akun';

  @override
  String get sign_in => 'Masuk';

  @override
  String get sign_in_mandatory =>
      'Untuk fitur itu, kami perlu anda untuk masuk.';

  @override
  String get help_improve_country =>
      'Bantu tingkatkan Open Food Facts di negara Anda';

  @override
  String get sign_out => 'Keluar';

  @override
  String get sign_out_confirmation => 'Apa Anda yakin Anda ingin keluar?';

  @override
  String get password => 'Kata sandi';

  @override
  String get forgot_password => 'Lupa kata sandi';

  @override
  String get forgot_password_question => 'Lupa kata sandi?';

  @override
  String get view_profile => 'Lihat profil';

  @override
  String get reset_password => 'Atur ulang kata sandi';

  @override
  String get reset_password_explanation_text =>
      'Jika Anda lupa kata sandi, masukkan nama pengguna atau alamat email Anda untuk menerima instruksi untuk mengatur ulang kata sandi. Jangan lupa memeriksa folder Spam.';

  @override
  String get username_or_email => 'Nama pengguna atau alamat e-mail';

  @override
  String get reset_password_done =>
      'E-mail dengan link untuk mengatur ulang kata sandi telah dikirim ke alamat e-mail yang terhubung dengan akun Anda. Periksa folder Spam Anda';

  @override
  String get send_reset_password_mail => 'Ubah kata sandi';

  @override
  String get enter_some_text => 'Harap masukkan teks';

  @override
  String get sign_up_page_title => 'Daftar';

  @override
  String get sign_up_page_action_button => 'Daftar';

  @override
  String get sign_up_page_action_doing_it => 'Mendaftarkan…';

  @override
  String get sign_up_page_action_ok => 'Selamat! Akun Anda baru saja dibuat.';

  @override
  String get sign_up_page_display_name_hint => 'Nama';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Silakan masukkan nama panggilan yang Anda inginkan';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'E-mail diperlukan';

  @override
  String get sign_up_page_email_error_invalid => 'Surel tidak valid';

  @override
  String get sign_up_page_username_hint => 'Nama pengguna: Terlihat publik';

  @override
  String get sign_up_page_username_error_empty =>
      'Silakan masukkan nama pengguna Anda';

  @override
  String get sign_up_page_username_error_invalid =>
      'Silakan masukkan nama pengguna yang sah';

  @override
  String get sign_up_page_username_description =>
      'Username tidak boleh berisi spasi, huruf besar atau karakter khusus.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Nama pengguna tidak dapat melebihi $value karakter';
  }

  @override
  String get sign_up_page_password_hint => 'Kata sandi';

  @override
  String get sign_up_page_password_error_empty => 'Silakan masukkan kata sandi';

  @override
  String get sign_up_page_password_error_invalid =>
      'Silakan masukkan kata sandi yang sah (paling sedikit 6 karakter)';

  @override
  String get sign_up_page_confirm_password_hint => 'Konfirmasi kata sandi';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Harap konfirmasi kata sandi';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Kata sandi tidak cocok';

  @override
  String get sign_up_page_agree_text => 'Saya setuju dengan OpenFoodFacts';

  @override
  String get sign_up_page_terms_text => 'syarat penggunaan dan kontribusi';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Anda wajib menyetujui Persyaratan Penggunaan saat menggunakan akun, akan tetapi kontribusi anonim masih dapat dilakukan melalui aplikasi';

  @override
  String get sign_up_page_producer_checkbox => 'Saya seorang produsen makanan';

  @override
  String get sign_up_page_producer_hint => 'Produsen/merek';

  @override
  String get sign_up_page_producer_error_empty =>
      'Silakan masukkan nama produsen atau merek';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Saya ingin berlangganan buletin OpenFoodFacts (Anda dapat berhenti berlangganan kapan saja)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Username telah terdaftar, silahkan pilih nama lain.';

  @override
  String get sign_up_page_email_already_exists =>
      'telah terdaftar, masuk ke akun atau coba dengan email lain.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Mohon berikan alamat email yang benar.';

  @override
  String get sign_up_page_server_busy =>
      'Mohon maaf, kami mengalami kendala teknis untuk membuat akun Anda. Silakan coba lagi nanti.';

  @override
  String get settingsTitle => 'Pengaturan';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Gelap';

  @override
  String get darkmode_light => 'Terang';

  @override
  String get darkmode_system_default => 'Sistem standar';

  @override
  String get thanks_for_contributing => 'Terima kasih telah berkontribusi!';

  @override
  String get contributors_label => 'Mereka sedang membangun aplikasi';

  @override
  String get contributors_dialog_title => 'Kontributor';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Kontributor: $name';
  }

  @override
  String get contributors_description =>
      'Daftar semua kontributor aplikasi ini';

  @override
  String get support => 'Dukungan';

  @override
  String get support_join_slack => 'Minta bantuan di saluran Slack kami';

  @override
  String get support_via_forum => 'Mintalah bantuan di forum kami';

  @override
  String get support_via_email => 'Kirimkan kami surel';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Kirim log aplikasi?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Apakah anda ingin menyertakan log aplikasi ke email anda?';

  @override
  String get termsOfUse => 'Syarat Penggunaan';

  @override
  String get legalNotices => 'Pernyataan hukum';

  @override
  String get privacy_policy => 'Kebijakan privasi';

  @override
  String get about_this_app => 'Tentang aplikasi ini';

  @override
  String get contribute => 'Berkontribusi';

  @override
  String get contribute_sw_development => 'Pengembangan perangkat lunak';

  @override
  String get contribute_develop_text =>
      'Kode untuk setiap produk OpenFoodFacts tersedia di GitHub. Anda dipersilahkan untuk menggunakan kode tersebut kembali (bersifat open-source) dan bantu kami memperbaikinya untuk semua orang di seluruh planet.';

  @override
  String get contribute_develop_text_2 =>
      'Anda dapat bergabung dengan ruang obrolan Slack OpenFoodFacts yang juga merupakan cara yang lebih disukai untuk mengajukan pertanyaan.';

  @override
  String get contribute_develop_dev_mode_title => 'Mode DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktifkan Mode DEV';

  @override
  String get contribute_donate_title => 'Berdonasi';

  @override
  String get contribute_donate_header => 'Berdonasi ke OpenFoodFacts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Harap diketahui bahwa dengan versi alpha internal, kehilangan data sepenuhnya mungkin terjadi, dan aplikasi dapat menjadi tidak dapat digunakan sewaktu-waktu!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Produk - produk yang perlu dilengkapi';

  @override
  String get contribute_improve_header => 'Meningkatkan';

  @override
  String get contribute_improve_text =>
      'Pembangunan database adalah inti dari proyek ini. Kontribusi dapat dilakukan dengan mudah dan cepat. Anda dapat mengunduh aplikasi seluler untuk ponsel Anda dan mulai menambahkan atau meningkatkan produk.\n\nDi sisi lain, situs web OpenFoodFacts menyediakan banyak cara untuk berkontribusi: ';

  @override
  String get contribute_translate_header => 'Terjemahkan';

  @override
  String get contribute_data_quality => 'Kualitas Data';

  @override
  String get contribute_translate_link_text => 'Mulai Menerjemahkan';

  @override
  String get contribute_translate_text =>
      'OpenFoodFacts adalah proyek global yang berisi produk dari lebih dari 160 negara. OpenFoodFacts diterjemahkan ke dalam berbagai bahasa, dengan konten yang terus dikembangkan.';

  @override
  String get contribute_translate_text_2 =>
      'Penerjemahan adalah salah satu tugas utama dari proyek ini';

  @override
  String get contribute_join_skill_pool =>
      'Kontribusikanlah keterampilan Anda pada Open Food Facts. Bergabunglah ke kumpulan keterampilan!';

  @override
  String get contribute_share_header =>
      'Bagikan OpenFoodFacts dengan teman-teman anda';

  @override
  String get contribute_share_content =>
      'Saya ingin memberi tahu kamu tentang aplikasi yang saya gunakan, OpenFoodFacts, yang memungkinkan kamu untuk mengetahui dampak kesehatan dan lingkungan dari makananmu, secara personal. Aplikasi ini bekerja dengan memindai barcode pada kemasan. Aplikasi ini gratis, tidak perlu pendaftaran, dan kamu bahkan bisa membantu menambah jumlah produk yang diuraikan. Ini tautan untuk mendapatkannya di hpmu: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Berikan harga dengan meminta ekspor GDPR data kartu loyalitas Anda';

  @override
  String get tap_to_answer => 'Ketuk di sini untuk menjawab pertanyaan';

  @override
  String get tap_to_answer_hint =>
      'Ketuk di sini untuk menjawab pertanyaan terkait produk ';

  @override
  String get robotoff_questions_loading_hint =>
      'Harap tunggu sejenak selagi informasi produk dimuat';

  @override
  String get saving_answer => 'Menyimpan jawaban Anda';

  @override
  String get contribute_to_get_rewards => 'Menjadi aktor transparansi pangan';

  @override
  String get question_sign_in_text =>
      'Masuk ke akun OpenFoodFacts, untuk mendapatkan kredit atas kontribusi Anda';

  @override
  String get question_yes_button_accessibility_value => 'Jawab dengan ya';

  @override
  String get question_no_button_accessibility_value => 'Jawab dengan tidak';

  @override
  String get question_skip_button_accessibility_value =>
      'Lewati pertanyaan ini';

  @override
  String get tap_to_edit_search => 'Ketuk untuk menyunting pencarian';

  @override
  String get myPreferences => 'Preferensi Saya';

  @override
  String get account_create_message =>
      'Buat akun Anda dan bergabunglah dengan komunitas OpenFoodFacts untuk meningkatkan pengetahuan tentang makanan di seluruh dunia!';

  @override
  String get join_us => 'Bergabunglah dengan kami';

  @override
  String get myPreferences_profile_title => 'Profil Anda';

  @override
  String get myPreferences_profile_subtitle =>
      'Kelola akun kontributor OpenFoodFacts Anda.';

  @override
  String get myPreferences_settings_title => 'Pengaturan Aplikasi';

  @override
  String get myPreferences_settings_subtitle => 'Mode gelap, Bahasa…';

  @override
  String get myPreferences_food_title => 'Preferensi Makanan';

  @override
  String get myPreferences_food_subtitle =>
      'Pilih informasi tentang makanan yang paling penting bagi anda.';

  @override
  String get myPreferences_food_comment =>
      'Pilih informasi tentang makanan yang paling penting bagi anda, untuk memberi peringkat makanan sesuai preferensi anda, melihat informasi yang paling anda minati lebih dahulu dan dapatkan ringkasan kompatibilitas. Preferensi makanan tersebut tetap ada di perangkat anda, dan tidak terkait dengan akun kontributor OpenFoodFacts anda jika anda memilikinya.';

  @override
  String get confirmResetPreferences => 'Atur ulang preferensi makanan anda?';

  @override
  String get myPersonalizedRanking => 'Peringkat pribadi saya';

  @override
  String get ranking_tab_all => 'Semua';

  @override
  String get ranking_subtitle_match_yes => 'Pilihan cocok untuk Anda';

  @override
  String get ranking_subtitle_match_no => 'Sangat tidak cocok';

  @override
  String get ranking_subtitle_match_maybe => 'Hasil tidak diketahui';

  @override
  String get refresh_with_new_preferences =>
      'Segarkan daftar dengan preferensi baru Anda';

  @override
  String get reloaded_with_new_preferences =>
      'Dimuat ulang dengan preferensi baru Anda';

  @override
  String get profile_navbar_label => 'Komunitas';

  @override
  String get scan_navbar_label => 'Pindai';

  @override
  String get history_navbar_label => 'Riwayat';

  @override
  String get list_navbar_label => 'Daftar';

  @override
  String get category => 'Saring berdasarkan kategori';

  @override
  String get category_all => 'Semua';

  @override
  String get category_search => '(pencarian kategori)';

  @override
  String get filter => 'Filter';

  @override
  String get scan => 'Produk dari layar Pindai';

  @override
  String get scan_history => 'Riwayat pemindaian';

  @override
  String get search => 'Cari';

  @override
  String get search_product_help => 'Cari produk,\nmerek atau kode batang';

  @override
  String get search_filter => 'Filter pencarian';

  @override
  String get search_history => 'Riwayat pencarian';

  @override
  String get search_store => 'Cari toko';

  @override
  String get search_store_help => 'Petunjuk: tambahkan kota atau negara';

  @override
  String get tap_for_more => 'Ketuk untuk lihat info selengkapnya…';

  @override
  String get product => 'Produk';

  @override
  String get unknownBrand => 'Merek tidak dikenal';

  @override
  String get unknownQuantity => 'Jumlah yang tidak diketahui';

  @override
  String get unknownProductName => 'Nama produk tidak dikenal';

  @override
  String get label_refresh => 'Muat ulang';

  @override
  String get label_reload => 'Muat ulang';

  @override
  String get image => 'Gambar';

  @override
  String get front_photo => 'Foto depan';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (gambar ini mungkin sudah terlalu lama)';
  }

  @override
  String get outdated_image_short_label => 'mungkin kedaluwarsa';

  @override
  String get ingredients => 'bahan';

  @override
  String get ingredients_editing_instructions =>
      'Pertahankan urutan aslinya. Tunjukkan persentase bila ditentukan. Pisahkan dengan koma atau tanda hubung dan gunakan tanda kurung untuk bahan-bahan dari suatu bahan.';

  @override
  String get ingredients_editing_error => 'Gagal menyimpan komposisi.';

  @override
  String get ingredients_editing_image_error =>
      'Gagal untuk mendapatkan gambar bahan baru.';

  @override
  String get ingredients_editing_title => 'Sunting Komposisi';

  @override
  String get ingredients_photo => 'Foto kandungan bahan';

  @override
  String get packaging_editing_instructions =>
      'Daftar semua bagian kemasan yang dipisahkan dengan koma atau baris, dengan jumlah (misalnya 1 atau 6), jenis (misalnya botol, kotak, kaleng), material (misalnya plastik, logam, aluminium) dan jika ukuran jika tersedia (misalnya 33cl) dan instruksi daur ulang.\nContoh: 1 gelas botol untuk didaur ulang, 1 sumbat plastik untuk dibuang';

  @override
  String get packaging_editing_error => 'Gagal menyimpan kemasan.';

  @override
  String get packaging_editing_image_error =>
      'Gagal mendapatkan gambar kemasan baru.';

  @override
  String get packaging_editing_title => 'Ubah kemasan';

  @override
  String get nutrition => 'kandungan nutrisi';

  @override
  String get nutrition_facts_photo => 'Foto kandungan gizi';

  @override
  String get nutrition_facts_editing_title => 'Ubah informasi nilai gizi';

  @override
  String get packaging_information => 'Petunjuk daur ulang';

  @override
  String get packaging_information_photo => 'Foto instruksi daur ulang';

  @override
  String get missing_product => 'Anda menemukan produk baru!';

  @override
  String get add_product_take_photos =>
      'Ambil foto kemasan untuk menambahkan produk ini ke OpenFoodFacts';

  @override
  String get add_product_take_photos_descriptive =>
      'Mohon ambil beberapa foto terlebih dahulu. Anda selalu dapat menyelesaikan produk di lain waktu.';

  @override
  String get add_product_information_button_label =>
      'Tambahkan informasi produk';

  @override
  String get new_product => 'Produk Baru';

  @override
  String get new_product_found_title => 'Produk baru ditemukan!';

  @override
  String get new_product_found_text =>
      'Basis data kolaboratif kami berisi lebih dari **3 juta produk**, tetapi barcode ini tidak ada: ';

  @override
  String get new_product_found_button => 'Tambahkan produk ini';

  @override
  String get new_product_leave_title => 'Keluar dari halaman ini?';

  @override
  String get new_product_leave_message =>
      'Anda tidak memasukan informasi apapun, apakah Anda yakin ingin meninggalkan halaman ini?';

  @override
  String get new_product_dialog_description =>
      'Silakan ambil foto kemasan untuk menambahkan produk ini ke basis data umum kami';

  @override
  String get new_product_dialog_illustration_description =>
      'Ilustrasi untuk Nutri-Score dan GreenScore yang tidak diketahui';

  @override
  String get front_packaging_photo_button_label => 'Foto depan produk';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Konfirmasi pengunggahan foto depan produk';

  @override
  String get confirm_button_label => 'Konfirmasi';

  @override
  String get send_image_button_label => 'Kirim gambar';

  @override
  String get crop_page_action_saving => 'Menyimpan gambar…';

  @override
  String get crop_page_action_cropping => 'Memotong gambar…';

  @override
  String get crop_page_action_local => 'Menyimpan versi lokal…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ups... ada yang salah dengan foto Anda!';

  @override
  String get crop_page_action_local_failed_message =>
      'Kami tidak dapat memproses gambar pada perangkat, sebelum mengirimkannya ke server kami. Harap coba lagi nanti atau hubungi kami jika masalah berlanjut.';

  @override
  String get crop_page_action_retake => 'Ambil ulang foto';

  @override
  String get crop_page_too_small_image_title => 'Gambar terlalu kecil!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Ukuran minimum piksel untuk unggahan gambar adalah ${expectedMinWidth}x$expectedMinHeight. Gambar ini $actualHeight×$actualWidth.';
  }

  @override
  String get crop_page_action_server => 'Mempersiapkan panggilan ke server…';

  @override
  String get front_packaging_photo_title => 'Foto Kemasan Depan';

  @override
  String get ingredients_photo_title => 'Foto Komposisi';

  @override
  String get nutritional_facts_photo_title => 'Foto Informasi Nilai Gizi';

  @override
  String get recycling_photo_title => 'Petunjuk daur ulang Foto';

  @override
  String get take_photo_title => 'Ambil gambar';

  @override
  String get take_more_photo_title => 'Ambil lebih banyak foto';

  @override
  String get front_photo_uploaded => 'Foto depan diunggah';

  @override
  String get ingredients_photo_button_label => 'Foto kandungan bahan';

  @override
  String get ingredients_photo_uploaded => 'Foto komposisi diunggah';

  @override
  String get nutrition_cache_loading_error =>
      'Tidak dapat memuat nutrien dari cache';

  @override
  String get nutritional_facts_photo_button_label => 'Foto kandungan gizi';

  @override
  String get nutritional_facts_input_button_label =>
      'Masukkan informasi nilai gizi';

  @override
  String get nutritional_facts_added => 'Informasi nilai gizi ditambahkan';

  @override
  String get categories_added => 'Kategori ditambahkan';

  @override
  String get new_product_title_nutriscore => 'Hitung Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Dapatkan dengan mengisi kategori makanan dan nilai gizi';

  @override
  String get new_product_title_environmental_score => 'Menghitung GreenScore';

  @override
  String get new_product_subtitle_environmental_score =>
      'Dapatkan dengan mengisi minimal satu kategori';

  @override
  String get new_product_additional_environmental_score =>
      'Bbuat perhitungan GreenScore lebih akurat dengan keaslian, kemasan dan lainnya';

  @override
  String get new_product_title_nova =>
      'Menghitung tingkat pengolahan makanan (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Dapatkan dengan mengisi kategori makanan dan bahan makanan';

  @override
  String get new_product_desc_nova_unknown =>
      'Tingkat pemrosesan makanan tidak diketahui';

  @override
  String get new_product_title_pictures => 'Ambil beberapa foto!';

  @override
  String get new_product_title_pictures_details =>
      'Silakan ambil foto-foto berikut ini dan mesin Open Food Facts akan menghitung sisanya!';

  @override
  String get new_product_title_misc => 'Dan beberapa informasi dasar…';

  @override
  String new_product_done_msg(String username) {
    return 'Terima kasih atas kontribusi Anda “$username”!';
  }

  @override
  String get new_product_done_msg_no_user =>
      'Terima kasih atas kontribusi Anda!';

  @override
  String get new_product_done_button_label =>
      'Temukan produk yang sudah lengkap';

  @override
  String get hey_incomplete_product_message =>
      'Ketuk untuk menjawab 3 pertanyaan SEKARANG untuk menghitung Nutri-Score, GreenScore & Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Ketuk sekarang untuk menjawab 2 pertanyaan untuk membantu menganalisis kosmetik ini!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Ketuk sekarang untuk menjawab 3 pertanyaan untuk membantu menganalisis produk makanan hewan peliharaan ini!';

  @override
  String get hey_incomplete_product_message_product =>
      'Ketuk sekarang untuk membantu menyelesaikan produk ini!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Foto informasi nilai gizi telah diunggah';

  @override
  String get recycling_photo_button_label => 'Foto informasi daur ulang';

  @override
  String get recycling_photo_uploaded => 'Foto daur ulang telah diunggah';

  @override
  String get take_more_photo_button_label => 'Ambil lebih banyak foto';

  @override
  String get other_photo_uploaded => 'Berbagai foto telah diunggah';

  @override
  String get retake_photo_button_label => 'Ambil ulang';

  @override
  String get selecting_photo => 'Memilih foto';

  @override
  String get uploading_image => 'Mengunggah foto ke peladen';

  @override
  String get uploading_image_type_front =>
      'Mengunggah gambar depan ke OpenFoodFacts';

  @override
  String get uploading_image_type_ingredients =>
      'Mengunggah gambar bahan ke OpenFoodFacts';

  @override
  String get uploading_image_type_nutrition =>
      'Mengunggah gambar nutrisi ke OpenFoodFacts';

  @override
  String get uploading_image_type_packaging =>
      'Mengunggah gambar kemasan ke OpenFoodFacts';

  @override
  String get uploading_image_type_other =>
      'Mengunggah gambar lain ke OpenFoodFacts';

  @override
  String get uploading_image_type_generic =>
      'Mengunggah gambar ke OpenFoodFacts';

  @override
  String get score_add_missing_ingredients => 'Tambahkan bahan yang kurang';

  @override
  String get score_add_missing_packaging_image =>
      'Tambahkan foto kemasan yang kurang';

  @override
  String get score_add_missing_nutrition_facts =>
      'Tambahkan informasi nilai gizi yang kurang';

  @override
  String get score_add_missing_product_traces =>
      'Tambahkan jejak produk yang hilang';

  @override
  String get score_add_missing_product_category =>
      'Tambahkan kategori produk yang kurang';

  @override
  String get score_add_missing_precise_product_category =>
      'Pilih kategori yang lebih tepat';

  @override
  String get score_add_missing_product_countries =>
      'Tambahkan negara asal produk yang kurang';

  @override
  String get score_add_missing_product_emb =>
      'Tambahkan kode ketertelusuran produk yang kurang';

  @override
  String get score_add_missing_product_labels =>
      'Tambahkan label produk yang kurang';

  @override
  String get score_add_missing_product_origins =>
      'Tambahkan asal produk yang kurang';

  @override
  String get score_add_missing_product_stores =>
      'Tambahkan toko produk yang kurang';

  @override
  String get score_add_missing_product_brands =>
      'Tambahkan merek produk yang kurang';

  @override
  String get score_update_nutrition_facts => 'Perbarui informasi nilai gizi';

  @override
  String get nutrition_page_title => 'Informasi nilai gizi';

  @override
  String get nutrition_page_nutritional_info_title => 'Info Nutrisi';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Nilai yang tertera pada produk:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Ya';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Tidak';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Buka foto';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Praktik baik: Informasi gizi';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Terkadang informasi nutrisi tidak tercantum pada kemasan atau pada dokumen yang disertakan bersama produk. Dalam hal ini, dan hanya dalam hal ini, Anda dapat menetapkan nilainya menjadi **TIDAK**.';

  @override
  String get nutrition_page_serving_type_label => 'Nilai gizi:';

  @override
  String get nutrition_page_per_100g => 'per 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'per 100g/ml';

  @override
  String get nutrition_page_per_serving => 'per sajian';

  @override
  String get nutrition_page_add_nutrient => 'Tambahkan nutrisi';

  @override
  String get nutrition_page_serving_size => 'Takaran saji';

  @override
  String get nutrition_page_serving_size_hint =>
      'Tambahkan ukuran porsi (contoh: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Praktik baik: Ukuran porsi';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Nilai ini membantu untuk **melakukan perhitungan proporsional setiap nutrisi per porsi**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Satuan yang diizinkan** adalah: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g**, atau **60 G** (disarankan yang pertama)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** atau **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Satuan tidak valid';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Satuan tidak valid';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **permen** dan 2 **biskuit**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Unit hilang';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Nomor tidak valid';

  @override
  String get nutrition_page_update_running => 'Memperbarui produk di peladen…';

  @override
  String get nutrition_page_update_done => 'Produk diperbarui!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Gunakan jumlah produk sebagai takaran saji';

  @override
  String get nutrition_page_photo_error => 'Foto tidak dapat dimuat';

  @override
  String get more_photos => 'Lebih banyak foto menarik';

  @override
  String get view_more_photo_button =>
      'Lihat semua foto yang ada untuk produk ini';

  @override
  String get no_product_found => 'Produk tidak ditemukan';

  @override
  String get no_location_found => 'Lokasi tidak ditemukan';

  @override
  String get not_found => 'tidak ditemukan:';

  @override
  String get refreshing_product => 'Muat ulang produk';

  @override
  String get product_refreshed => 'Produk telah dimuat ulang';

  @override
  String product_image_accessibility_label(String date) {
    return 'Gambar diambil pada $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Gambar diambil pada $date. Gambar ini mungkin telah kedaluwarsa';
  }

  @override
  String get product_image_outdated => 'Gambar ini mungkin sudah terlalu lama';

  @override
  String get product_image_outdated_explanations_title =>
      'Gambar ini mungkin sudah terlalu lama';

  @override
  String get product_image_outdated_explanations_content =>
      'Gambar ini diambil lebih dari setahun yang lalu. **Harap periksa apakah gambar masih mutakhir**.\n\nIni **hanya peringatan**. Jika kontennya masih sama, Anda dapat mengabaikan pesan ini.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Ganti foto ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Tambah foto ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Foto Baru';

  @override
  String get product_image_action_take_picture => 'Ambil gambar';

  @override
  String get product_image_action_from_gallery =>
      'Pilih dari galeri perangkat Anda';

  @override
  String get product_image_action_choose_existing_photo =>
      'Pilih dari foto produk';

  @override
  String get product_image_details_label => 'Informasi tentang foto';

  @override
  String get product_image_details_from_producer => 'Dari produsen';

  @override
  String get product_image_details_contributor => 'Kontributor';

  @override
  String get product_image_details_contributor_producer =>
      'Kontributor (produsen)';

  @override
  String get product_image_details_date => 'Tanggal';

  @override
  String get product_image_details_date_unknown => 'Tidak diketahui';

  @override
  String get homepage_main_card_logo_description =>
      'Selamat datang di Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Pindai** kode batang atau\n**cari** suatu produk';

  @override
  String get homepage_main_card_search_field_hint => 'Cari produk';

  @override
  String get homepage_main_card_search_field_tooltip => 'Mulai pencarian';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Berita terbaru: $news_title';
  }

  @override
  String get tagline_app_review => 'Suka dengan aplikasinya?';

  @override
  String get tagline_app_review_button_positive => 'Saya suka sekali! 😍';

  @override
  String get tagline_app_review_button_negative => 'Tidak begitu…';

  @override
  String get tagline_app_review_button_later => 'Tanya lagi nanti';

  @override
  String get tagline_feed_news_button => 'Tahu lebih banyak';

  @override
  String get app_review_negative_modal_title =>
      'Anda tidak menyukai aplikasi kami?';

  @override
  String get app_review_negative_modal_text =>
      'Bisakah Anda meluangkan waktu beberapa detik untuk memberi tahu kami alasannya?';

  @override
  String get app_review_negative_modal_positive_button => 'Ya, tentu saja!';

  @override
  String get app_review_negative_modal_negative_button => 'Tidak';

  @override
  String get could_not_refresh => 'Tidak dapat memuat ulang produk';

  @override
  String get product_internet_error_modal_title => 'Terjadi kesalahan!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Kami tidak dapat memperoleh informasi terkait produk ini karena kesalahan jaringan. Silakan periksa koneksi internet Anda dan coba lagi.\n\nKesalahan internal:\n$error';
  }

  @override
  String get product_tags_title => 'Karakteristik produk';

  @override
  String get no_product_tags_found_message =>
      'Properti produk tidak ditemukan. Properti dapat digunakan untuk mendeskripsikan produk secara lebih rinci, dengan cara yang fleksibel. Ketuk untuk menambahkan.';

  @override
  String get product_tags_empty => 'Tidak ada properti';

  @override
  String get product_tags_explanation =>
      'Dengan menambahkan properti (kunci/nilai) ke suatu produk, Anda membantu memperkayanya.';

  @override
  String get add_tag => 'Tambahkan properti';

  @override
  String get add_tags => 'Tambah properti';

  @override
  String get add_edit_tags => 'Tambah atau sunting properti';

  @override
  String get edit_tag => 'Sunting properti';

  @override
  String get remove_tag => 'Hapus properti';

  @override
  String get tag_key => 'Properti';

  @override
  String get tag_keys => 'Properti';

  @override
  String get tag_key_uneditable => 'Properti (tidak dapat disunting)';

  @override
  String get tag_key_input_hint => 'Masukkan properti';

  @override
  String get tag_value => 'Nilai';

  @override
  String get tag_values => 'Nilai';

  @override
  String get tag_value_input_hint => 'Masukkan nilai';

  @override
  String get tag_key_item => 'Properti:';

  @override
  String get tag_value_item => 'Nilai:';

  @override
  String get tag_key_explanations =>
      'Kunci harus berupa huruf kecil dan tanpa spasi.';

  @override
  String tag_key_already_exists(String property) {
    return 'Tagar dengan properti $property sudah ada!';
  }

  @override
  String get product_internet_error =>
      'Pengambilan informasi tentang produk ini gagal karena kesalahan jaringan.';

  @override
  String get cached_results_from => 'Menampilkan hasil dari:';

  @override
  String get product_search_same_category => 'Temukan alternatif';

  @override
  String get product_search_same_category_short => 'Bandingkan';

  @override
  String get product_search_same_category_error =>
      'Fitur ini hanya dapat digunakan untuk produk dengan kategori.\n\nHarap sunting produk untuk menambahkan kategori.';

  @override
  String get product_improvement_add_category =>
      'Tambahkan kategori untuk menghitung Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Tambahkan informasi nilai gizi untuk menghitung Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Tambahkan informasi nilai gizi dan kategori untuk menghitung Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-Score untuk produk ini tidak dapat dihitung, kemungkinan disebabkan oleh kategori non-standar. Jika ini dianggap sebagai kesalahan, silakan hubungi kami.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Gambar nutrisi sudah tidak berlaku: harap perbaharui.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Greenscore memperhitungkan asal-usul bahan. Harap ambil foto daftar bahan dan/atau klaim geografis atau sunting produk, agar dapat diperhitungkan.';

  @override
  String get country_chooser_label => 'Silakan pilih negara';

  @override
  String get currency_chooser_label => 'Silahkan pilih mata uang';

  @override
  String get country_change_message => 'Anda baru saja mengganti negara.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Apakah Anda ingin mengganti mata uang dari $previousCurrency ke $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Silakan pilih negara:';

  @override
  String get country_chooser_label_from_settings => 'Negara Anda';

  @override
  String get country_selection_explanation =>
      'Beberapa fitur lingkungan bersifat khusus tergantung lokasi';

  @override
  String get product_removed_comparison =>
      'Produk telah dihapus dari perbandingan';

  @override
  String get native_app_settings => 'Pengaturan Aplikasi Asli';

  @override
  String get native_app_description =>
      'Pengaturan sistem terbuka untuk Open Food Facts';

  @override
  String get product_removed_history => 'Produk telah dihapus dari riwayat';

  @override
  String get product_removed_list => 'Produk telah dihapus dari daftar';

  @override
  String get product_could_not_remove => 'Tidak dapat menghapus produk';

  @override
  String get no_prodcut_in_list => 'Tidak ada produk di daftar ini';

  @override
  String get no_product_in_section => 'Tidak ada produk di bagian ini';

  @override
  String get recently_seen_products => 'Semua produk yang dilihat';

  @override
  String get clear => 'Hapus';

  @override
  String get clear_long => 'Kosongkan daftar';

  @override
  String get really_clear =>
      'Apakah anda benar-benar ingin menghapus daftar ini?';

  @override
  String pct_match(Object percent) {
    return '$percent% cocok';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hari yang lalu',
      one: 'satu hari yang lalu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count jam yang lalu',
      one: 'satu jam yang lalu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count menit yang lalu',
      one: 'satu menit yang lalu',
      zero: 'kurang dari satu menit yang lalu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bulan yang lalu',
      one: 'satu bulan yang lalu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minggu yang lalu',
      one: 'satu minggu yang lalu',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Bandingkan $count Produk',
      one: 'Bandingkan satu Produk',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produk terpilih',
      one: 'Satu produk terpilih',
      zero: 'Tidak ada produk dipilih',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Bandingkan produk yang dipilih';

  @override
  String get delete_products_mode => 'Hapus produk yang dipilih';

  @override
  String get select_all_products_mode => 'Pilih semua produk';

  @override
  String get select_none_products_mode => 'Tidak memilih';

  @override
  String get compare_products_appbar_title => 'Bandingkan produk - produk';

  @override
  String get compare_products_appbar_subtitle =>
      'Silahkan pilih minimal dua produk';

  @override
  String get retry_button_label => 'Coba lagi';

  @override
  String get connect_with_us => 'Terhubung dengan kami';

  @override
  String get tiktok => 'Ikuti kami di TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Ikuti kami di Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Ikuti kami di X (sebelumnya Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Ikuti kami di Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Ikuti kami di BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => 'Jelajahi';

  @override
  String get how_to_contribute => 'Cara Berkontribusi';

  @override
  String get hint_knowledge_panel_message =>
      'Anda dapat mengetuk bagian mana pun kartu untuk mendapatkan keterangan lebih lanjut tentang apa yang Anda lihat. Coba sekarang!';

  @override
  String get permissions_page_title => 'Akses kamera';

  @override
  String get permissions_page_body1 =>
      'Untuk memindai kode batang menggunakan kamera ponsel Anda, harap otorisasi akses.';

  @override
  String get permissions_page_body2 =>
      'Jika anda berubah pikiran, pilihan ini dapat diaktikan dan dinonaktifkan kapan saja dari pengaturan.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Rilis: $release)\nModel: $model\nProduk: $product\nPerangkat: $device\nJenama:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModel: $model\nModel lokal: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVersi aplikasi:$appVersion\nNomor pembuatan aplikasi:$appBuildNumber\nNama paket aplikasi:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Mengizinkan';

  @override
  String get refuse_button_label => 'Tolak';

  @override
  String get ask_me_later_button_label => 'Nanti';

  @override
  String get are_you_sure => 'Apakah Anda yakin?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Selanjutnya pada $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Selamat datang!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Aplikasi yang membantu Anda memilih makanan yang baik untuk **Anda** dan **bumi**!';

  @override
  String get onboarding_continue_button => 'Selanjutnya';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Memuat produk contoh pertama Anda';

  @override
  String get onboarding_welcome_warning =>
      'Maaf, ini contoh produk kami, Anda tidak dapat mengeditnya :)';

  @override
  String get product_list_your_ranking => 'Peringkat Anda';

  @override
  String get product_list_empty_icon_desc => 'Riwayat tidak tersedia';

  @override
  String get product_list_empty_title => 'Mulai memindai';

  @override
  String get product_list_empty_message =>
      'Produk yang dipindai akan muncuk di sini dan Anda bisa memeriksa informasi terperinci produk tersebut';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produk',
      one: 'produk',
      zero: 'produk',
    );
    return 'Menyegarkan $_temp0 dalam riwayat anda';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Produk',
      one: 'Produk',
      zero: 'Produk',
    );
    return 'Pembaruan $_temp0 selesai';
  }

  @override
  String get product_list_compare_side_by_side => 'Bandingkan berdampingan';

  @override
  String get loading_dialog_default_title => 'Mengunduh data';

  @override
  String get loading_dialog_default_error_message =>
      'Tidak bisa mengunduh data';

  @override
  String get account_delete => 'Hapus akun';

  @override
  String get account_delete_title => 'Hapus akun saya';

  @override
  String get user_profile => 'Akun';

  @override
  String get user_profile_title_guest => 'Selamat Datang!';

  @override
  String get user_profile_subtitle_guest =>
      'Masuk atau daftar untuk bergabung dengan komunitas OpenFoodFacts';

  @override
  String user_profile_title_id_email(String email) {
    return 'OpenFoodFacts masuk: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Selamat datang $id!';
  }

  @override
  String get email_subject_account_deletion => 'Hapus akun';

  @override
  String email_body_account_deletion(String userId) {
    return 'Halo, tolong hapus akun OpenFoodFacts saya: $userId';
  }

  @override
  String get settings_app_app => 'Aplikasi';

  @override
  String get settings_app_data => 'Privasi dan pemantauan';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Produk - produk';

  @override
  String get settings_app_miscellaneous => 'Lain-lain';

  @override
  String get camera_play_sound_title => 'Putar suara saat memindai';

  @override
  String get camera_play_sound_subtitle =>
      'Akan berbunyi setiap pemindaian berhasil';

  @override
  String get camera_window_accessibility_label =>
      'Pindai kode batang dengan kamera Anda';

  @override
  String get app_haptic_feedback_title => 'Getaran & Haptik';

  @override
  String get app_haptic_feedback_subtitle =>
      'Getaran setelah menjalankan beberapa tindakan (kode barcode diterjemahkan, produk dihapus…).';

  @override
  String get crash_reporting_toggle_title => 'Pelaporan kerusakan';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Saat diaktikan, laporan kerusakan secara otomatis dikirimkan ke sistem pelacakan kesalahan OpenFoodFacts, sehingga bug dapat diperbaiki sehingga dapat meningkatkan aplikasi.';

  @override
  String get send_anonymous_data_toggle_title => 'Kirim data anonim';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Saat diaktifkan, beberapa informasi anonim terkait penggunaan aplikasi akan dikirimkan ke peladen OpenFoodFacts, sehingga kami dapat memahami bagaimana dan berapa banyak fitur digunakan untuk meningkatkannya.';

  @override
  String get product_edit_photo_title => 'Sunting Foto';

  @override
  String get permission_photo_error => 'Kesalahan';

  @override
  String get permission_photo_denied_title =>
      'Izinkan penggunaan kamera untuk memindai kode batang';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Untuk pengalaman yang lebih baik, harap izinkan $appName mengakses kamera Anda. Anda akan dapat langsung memindai kode batang.';
  }

  @override
  String get permission_photo_denied_button => 'Izinkan';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Izin ditolak';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Karena sebelumnya Anda telah menolak izin kamera, Anda harus mengizinkannya secara manual dari Pengaturan.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Buka pengaturan';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Batalkan';

  @override
  String get permission_photo_none_found => 'Kamera tidak terdeksi';

  @override
  String get permission_photo_denied => 'Tidak ada akses kamera yang diberikan';

  @override
  String get show_product_pictures => 'Tampilkan gambar produk';

  @override
  String get edit_product_label => 'Sunting produk';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Mengunggah suntingan Anda…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Hasil suntingan Anda **dikirim di latar belakang** (atau nanti jika terjadi kesalahan).\nAnda dapat terus menyunting bidang produk lainnya.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Susunan suntingan Anda sedang **dikirim di balik layar** (atau nanti jika terjadi kesalahan).';

  @override
  String get edit_product_label_short => 'Sunting';

  @override
  String edit_product_form_item_help(String value) {
    return 'Bagaimana cara memasukkan “$value”?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Harap masukkan nilai yang tidak kosong!';

  @override
  String get edit_product_form_item_error_existing => 'Nilai ini sudah ada!';

  @override
  String get edit_product_form_item_add_action_brand => 'Tambah merek baru';

  @override
  String get edit_product_form_item_add_action_label => 'Tambah label baru';

  @override
  String get edit_product_form_item_add_action_store => 'Tambah toko baru';

  @override
  String get edit_product_form_item_add_action_origin => 'Tambah sumber baru';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Tambah kode penelusuran baru';

  @override
  String get edit_product_form_item_add_action_country => 'Tambah negara baru';

  @override
  String get edit_product_form_item_add_action_category =>
      'Tambah kategori baru';

  @override
  String get edit_product_form_item_add_action_trace => 'Tambahkan jejak baru';

  @override
  String get edit_product_form_item_add_suggestion => 'Tambahkan saran';

  @override
  String get edit_product_form_item_deny_suggestion => 'Tolak saran';

  @override
  String get edit_product_form_item_details_title => 'Rincian dasar';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Nama produk, merek, jumlah';

  @override
  String get edit_product_form_item_other_details_title => 'Detail tambahan';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Situs Web…';

  @override
  String get edit_product_form_item_photos_title => 'Foto - foto';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Tambahkan atau segarkan foto';

  @override
  String get edit_product_form_item_labels_title => 'Label& sertifikat';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Lingkungan, Label kualitas…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Masukkan label (misalnya: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Praktik baik: Label';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Setiap karakteristik produk **yang bersifat faktual** dan berbeda dari bidang-bidang lainnya.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Dibuat di Belgia, diproduksi di Brittany…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Kaya serat, sumber zat besi…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Praktik Dagany yang Adil, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Toko';

  @override
  String get edit_product_form_item_stores_hint => 'Masukkan toko';

  @override
  String get edit_product_form_item_stores_type => 'toko';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Praktik baik: Toko';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Masukkan toko tempat Anda membeli produk tersebut.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Tempat asal';

  @override
  String get edit_product_form_item_origins_hint =>
      'Masukkan negara asal (misalnya: Jerman)';

  @override
  String get edit_product_form_item_origins_type => 'negara';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Praktik baik: Asal-usul';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Tambahkan **segala informasi asal-usul yang dapat Anda temukan pada kemasan**.\nAnda tidak perlu khawatir tentang informasi asal-usul yang tercantum langsung dalam daftar bahan.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Daging sapi dari Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Kedelai tidak berasal dari Uni Eropa';

  @override
  String get edit_product_form_item_countries_title => 'Negara';

  @override
  String get edit_product_form_item_countries_hint =>
      'Masukkan negara (misalnya: Jerman)';

  @override
  String get edit_product_form_item_countries_type => 'negara';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Praktik baik: Negara';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Negara-negara di mana produk ini tersedia secara luas** (tidak termasuk toko-toko yang khusus menjual produk impor).';

  @override
  String get edit_product_form_item_emb_codes_title =>
      'Kode -kode keterlacakan';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Masukkan kode (misal: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'kode keterlacakan';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Praktik baik: Kode pelacakan';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Pada bagian ini, Anda dapat memasukkan kode yang terkait dengan **tanda kemasan**, **tanda identifikasi**, atau **tanda kesehatan**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Contoh kode pelacakan';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Kode EC** yang digunakan di Komunitas Eropa untuk mengidentifikasi produsen atau pengemas makanan:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: kode negara **Prancis**\n**72.264.002**: data geografis\n**CE**: Komunitas Eropa';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Kode EMB** yang digunakan di Prancis:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Jejak - jejak';

  @override
  String get edit_product_form_item_traces_hint => 'jejak';

  @override
  String get edit_product_form_item_traces_type =>
      'Masukkan penelusuran (misalnya: Kedelai)';

  @override
  String get edit_product_form_item_categories_title => 'Kategori';

  @override
  String get edit_product_form_item_categories_hint => 'kategori';

  @override
  String get edit_product_form_item_categories_type =>
      'Masukkan kategori (misalnya: Jus jeruk)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Praktik yang baik: Kategori';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Pilih **hanya kategori yang paling spesifik**.\nKategori induk akan ditambahkan secara otomatis.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Kategori tidak ada?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Jika suatu kategori **tidak tersedia di autocomplete**, silakan tambahkan saja.\nHal ini akan membantu kami memperbaiki Open Food Facts di negara Anda.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Ikan sarden dalam minyak zaitun';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Jus jeruk dari konsentrat';

  @override
  String get edit_product_form_item_exit_title => 'Keluar tanpa menyimpan?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Apa Anda ingin menyimpan perubahan sebelum meninggalkan halaman ini?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Simpan perubahan';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Batalkan perubahan';

  @override
  String get edit_product_form_item_ingredients_title => 'bahan';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Memperbesar dan memperkecil dengan mencubit layar';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Memperbesar dan memperkecil foto';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Menggunakan **gerakan cubit untuk memperbesar**, Anda dapat memperbesar atau memperkecil foto:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Tambahkan';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Harap masukkan teks';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Hapus';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Simpan suntingan Anda';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Batalkan suntingan Anda';

  @override
  String get edit_product_form_item_packaging_title =>
      'Foto instruksi daur ulang';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Informasi nilai gizi';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Nutrisi, kandungan alkohol…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Praktik yang baik: Informasi gizi';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Nilai gizi';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Pertama, pilih apakah **nilai-nilai tersebut disediakan**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Informasi nilai gizi';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Kemudian, masukkan nilai gizi **seperti yang tertera pada kemasan**. Jika tidak ada nilai, Anda dapat mengklik ikon “Mata”.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Kolom tidak ada?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Jika ada entri yang hilang, Anda dapat **mengklik ikon “Plus”** untuk menambahkannya (misalnya: vitamin D, magnesium…).';

  @override
  String get edit_product_form_save => 'Sunting';

  @override
  String get edit_product_ingredients_photo_title => 'Foto kandungan bahan';

  @override
  String get edit_product_ingredients_list_title => 'Daftar kandungan bahan';

  @override
  String get edit_product_packaging_photo_title => 'Foto kemasan';

  @override
  String get edit_product_packaging_list_title => 'Daftar kemasan';

  @override
  String get no_data_available => 'Data tidak tersedia';

  @override
  String get product_field_website_title => 'Situs Web';

  @override
  String get origins_editing_title => 'Ubah Sumber';

  @override
  String get completed_basic_details_btn_text => 'Lengkapi informasi dasar';

  @override
  String get not_implemented_snackbar_text => 'Belum diimplementasi';

  @override
  String get category_picker_page_appbar_text => 'Kategori';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Ekstrak bahan dari foto';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Ekstrak kandungan bahan';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Mengekstrak bahan\ndari foto';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Memuat foto…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Mengapa saya melihat pesan ini?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Untuk menggunakan fitur “Ekstrak bahan”, foto harus diunggah terlebih dulu.\n\nHarap tunggu beberapa detik atau masukkan secara manual.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Muat ulang foto';

  @override
  String get edit_packaging_extract_btn_text => 'Ekstrak kemasan\ndari foto';

  @override
  String get edit_packaging_extract_btn_text_short => 'Ekstrak kemasan';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Mengekstrak kemasan dari foto';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Memuat foto…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Mengapa saya melihat pesan ini?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Untuk menggunakan fitur “Ekstrak kemasan”, foto harus diunggah terlebih dulu.\n\nHarap tunggu beberapa detik atau masukkan secara manual.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Muat ulang foto';

  @override
  String get edit_ocr_extract_failed => 'Gagal mendeteksi teks dalam gambar.';

  @override
  String get edit_ocr_extract_disabled_title => 'Tidak ada gambar!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Untuk menggunakan fitur ekstraksi teks, Anda harus mengambil foto terlebih dahulu.';

  @override
  String get user_list_dialog_new_title => 'Daftar produk baru';

  @override
  String get user_list_dialog_rename_title => 'Ubah nama daftar';

  @override
  String get user_list_subtitle_product => 'Daftar';

  @override
  String get user_list_title => 'Daftar - daftar Anda';

  @override
  String get user_list_add_product => 'Tambahkan produk ke daftar anda';

  @override
  String get user_list_button_new => 'Buat daftar baru';

  @override
  String get user_list_empty_label =>
      'Belum ada daftar yang tersedia, silakan mulai dengan membuatnya';

  @override
  String get user_list_button_add_product => 'Tambahkan ke daftar';

  @override
  String get added_to_list_msg => 'Ditambahkan ke daftar';

  @override
  String get user_list_popup_clear => 'Hapus riwayat';

  @override
  String get user_list_popup_rename => 'Ubah Nama';

  @override
  String get user_list_name_hint => 'Daftar saya';

  @override
  String get user_list_name_error_empty => 'Nama wajib diisi';

  @override
  String get user_list_name_error_already => 'Nama sudah digunakan';

  @override
  String get user_list_name_error_same => 'Itu adalah nama yang sama';

  @override
  String get user_list_name_input_hint => 'Nama daftar';

  @override
  String get try_again => 'Coba Lagi';

  @override
  String get there_was_an_error => 'Terjadi kesalahan';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Tidak ditemukan kategori untuk $items';
  }

  @override
  String get camera_toggle_camera => 'Beralih dari kamera belakang ke depan';

  @override
  String get camera_toggle_flash => 'HIDUPKAN atau MATIKAN flash kamera';

  @override
  String get camera_enable_flash => 'Aktifkan flash';

  @override
  String get camera_disable_flash => 'Matikan flash';

  @override
  String get camera_flash_error_dialog_title => 'Terjadi kesalahan!';

  @override
  String get camera_flash_error_dialog_message =>
      'Terjadi kesalahan sewaktu mengubah status flash. Pastikan smartphone Anda belum mengaktifkan lampu kilat.';

  @override
  String get category_picker_no_category_found_button => 'Kembali';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Klik untuk membuka di peramban Anda atau di aplikasi (jika terpasang)';

  @override
  String get dev_preferences_screen_title => 'Mode DEV';

  @override
  String get dev_preferences_screen_subtitle =>
      'Akses fitur eksperimental dan alat pengembangan';

  @override
  String get dev_preferences_reset_onboarding_title => 'Mulai ulang orientasi';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Anda kemudian harus memulai ulang Aplikasi untuk melihatnya lagi.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Beralih antara openfoodfacts.org (PROD) dan test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Parameter lingkungan pengujian';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL dasar untuk env pengujian saat ini: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Host lingkungan uji';

  @override
  String get dev_preferences_ml_kit_title => 'Gunakan Kit ML';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'maka Anda harus memulai ulang aplikasi ini';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Tombol tambahan pada halaman produk';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Edit bahan melalui tombol panel pengetahuan';

  @override
  String get dev_preferences_export_history_title => 'Ekspor Riwayat';

  @override
  String get dev_preferences_export_history_progress_error => 'pengecualian';

  @override
  String get dev_preferences_export_history_progress_found =>
      'produk ditemukan';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produk TIDAK ditemukan';

  @override
  String get dev_preferences_export_history_dialog_title => 'Ekspor riwayat';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Batalkan';

  @override
  String get dev_preferences_migration_title => 'Migrasi data dari V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Status: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'sukses atau pemasangan baru';

  @override
  String get dev_preferences_migration_status_success => 'berhasil';

  @override
  String get dev_preferences_migration_status_error => 'kesalahan';

  @override
  String get dev_preferences_migration_status_in_progress => 'dalam proses';

  @override
  String get dev_preferences_migration_status_required =>
      'diperlukan (klik untuk memulai)';

  @override
  String get dev_preferences_migration_status_not_started => 'tidak diketahui';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Akan menghapus riwayat dan menempatkan 3 produk di sana';

  @override
  String get dev_preferences_news_custom_url_title => 'URL khusus untuk berita';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL file JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Belum diatur';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Penyegaran terakhir: $date';
  }

  @override
  String get product_type_label_food => 'Makanan';

  @override
  String get product_type_label_beauty => 'Perawatan Pribadi';

  @override
  String get product_type_label_pet_food => 'Makanan hewan';

  @override
  String get product_type_label_product => 'Lainnya';

  @override
  String get product_type_selection_title => 'Tipe produk';

  @override
  String get product_type_selection_subtitle => 'Pilih jenis produk ini';

  @override
  String get product_type_selection_empty =>
      'Anda harus memilih jenis produk terlebih dahulu!';

  @override
  String product_type_selection_already(String productType) {
    return 'Anda tidak dapat mengubah jenis produk ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Pintasan ke aplikasi Harga di halaman produk';

  @override
  String get prices_app_button => 'Buka aplikasi Harga';

  @override
  String get prices_website_button => 'Buka di situs web Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Tambahkan label harga langsung dari galeri';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Setelah Anda memilih gambar, Anda tidak akan dapat menyuntingnya!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI akan menganalisis bukti-bukti Anda untuk mengekstrak harga.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Memungkinkan komunitas untuk memvalidasi harga yang diekstraksi oleh AI.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Label Harga Duplikat';

  @override
  String get prices_bulk_proof_upload_title =>
      'Unggah Bukti dalam Jumlah Besar';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Memilih file';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Memulai pengunggahan';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Menyalin file secara lokal #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Mempersiapkan unggahan #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Gagal pada gambar #$index/$count';
  }

  @override
  String get prices_generic_title => 'Harga';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tambahkan $count harga',
      one: 'Tambahkan harga',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Kirim $count harga',
      one: 'Kirim harga',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Tambahkan item';

  @override
  String get prices_add_a_price => 'Tambahkan harga';

  @override
  String get prices_add_a_receipt => 'Tambahkan tanda terima';

  @override
  String get prices_add_price_tags => 'Tambahkan label harga';

  @override
  String prices_barcode_already(String barcode) {
    return 'Barcode ini ($barcode) sudah ada dalam daftar!';
  }

  @override
  String get prices_barcode_search_not_found => 'Produk tidak ditemukan';

  @override
  String get prices_barcode_search_none_yet => 'Belum ada produk';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Mencari $barcode';
  }

  @override
  String get prices_barcode_enter => 'Masukkan Barcode';

  @override
  String get prices_category_enter => 'Barang tanpa kode batang';

  @override
  String get prices_per_kilogram => 'Harga per kilogram';

  @override
  String get prices_per_unit => 'Harga per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / satuan';

  @override
  String get prices_category_mandatory => 'Wajib';

  @override
  String get prices_category_optional => 'Opsional';

  @override
  String get prices_category_error_mandatory => 'Kategori wajib diisi';

  @override
  String get prices_barcode_reader_action => 'Pembaca barcode';

  @override
  String get prices_view_prices => 'Lihat harga';

  @override
  String get prices_list_title => 'Daftar harga';

  @override
  String get prices_list_count => 'Jumlah\nharga';

  @override
  String get prices_list_add_new_price => 'Tambahkan harga baru\n';

  @override
  String get prices_list_empty_title => 'Belum ada harga!';

  @override
  String get prices_list_empty_subtitle =>
      'Jadilah orang pertama yang menambahkannya:\nDengan memindai **kwitansi** atau **label harga**!';

  @override
  String get prices_entry_shop_not_found => 'Toko tidak dikenal';

  @override
  String prices_entry_menu_title(String user) {
    return 'Harga entri dari \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Lihat semua harga untuk produk ini';

  @override
  String get prices_entry_menu_open_proof => 'Lihat bukti';

  @override
  String get prices_entry_menu_my_prices => 'Lihat harga saya yang lain';

  @override
  String get prices_entry_menu_author_prices => 'Lihat harga lain dari penulis';

  @override
  String get prices_entry_menu_shop_prices => 'Lihat harga lain dari toko';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count harga',
      one: '1 harga',
    );
    return '$_temp0 untuk $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Semua $count harga',
      one: 'Hanya satu harga',
      zero: 'Belum ada harga',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Harga $pageSize terbaru (total: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Harga: $price / Toko: \"$location\" / Diterbitkan pada $date oleh \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Bukti terbuka oleh \"$user\"';
  }

  @override
  String get prices_open_proof => 'Buka bukti harga';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Semua $count bukti',
      one: 'Hanya satu bukti',
      zero: 'Belum ada bukti',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return '$pageSize bukti paling terakhir (total: $total)';
  }

  @override
  String get prices_users_empty_title => 'Belum ada kontributor!';

  @override
  String get prices_users_empty_explanation =>
      'Jadilah yang pertama menambahkan harga!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return '$pageSize kontributor teratas (total: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Belum ada toko!';

  @override
  String get prices_locations_empty_explanation =>
      'Jadilah yang pertama menambahkan harga!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return '$pageSize lokasi teratas (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bukti',
      one: 'Satu bukti',
      zero: 'Tidak ada bukti',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produk',
      one: 'Satu produk',
      zero: 'Tidak ada produk',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pengguna',
      one: 'Satu pengguna',
      zero: 'Tidak ada pengguna',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count harga',
      one: 'Satu harga',
      zero: 'Tidak ada harga',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle =>
      'Harga sudah ditambahkan sebelumnya';

  @override
  String get prices_amount_subtitle => 'Jumlah';

  @override
  String get prices_amount_is_discounted => 'Apakah didiskon?';

  @override
  String get prices_amount_price_normal => 'Harga';

  @override
  String get prices_amount_price_discounted => 'Harga sesudah diskon';

  @override
  String get prices_amount_price_not_discounted => 'Harga asli';

  @override
  String get prices_amount_no_product => 'Ada satu produk yang hilang!';

  @override
  String get prices_amount_price_incorrect => 'Nilai tidak valid';

  @override
  String get prices_amount_price_mandatory => 'Nilai wajib';

  @override
  String get prices_currency_subtitle => 'Mata uang';

  @override
  String get prices_date_subtitle => 'Tanggal';

  @override
  String get prices_location_subtitle => 'Toko';

  @override
  String get prices_location_find => 'Temukan toko';

  @override
  String get prices_location_mandatory => 'Anda harus memilih toko!';

  @override
  String get prices_location_search_broader =>
      'Tidak dapat menemukan apa yang Anda cari? Coba pencarian yang lebih luas!';

  @override
  String get prices_proof_subtitle => 'Bukti';

  @override
  String get prices_proof_empty_title => 'Belum ada bukti!';

  @override
  String get prices_proof_empty_explanation =>
      'Mulailah dengan menambahkan foto **kwitansi** atau **label harga**!';

  @override
  String get prices_proof_find => 'Pilih bukti';

  @override
  String get prices_proof_change => 'Bukti perubahan';

  @override
  String get prices_proof_receipt => 'Resi';

  @override
  String get prices_proof_price_tag => 'Label harga';

  @override
  String get prices_proof_mandatory => 'Anda harus memilih bukti!';

  @override
  String get prices_add_validation_error => 'Kesalahan validasi';

  @override
  String get prices_privacy_warning_title => 'Peringatan privasi';

  @override
  String get prices_unknown_product => 'Produk tidak diketahui';

  @override
  String get prices_privacy_warning_main_message =>
      'Harga **akan dipublikasikan**, beserta toko yang dirujuk.\n\nHal ini memungkinkan orang yang mengetahui nama samaran Open Food Facts Anda untuk:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Menebak di area mana Anda tinggal';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Mengetahui apa yang Anda beli';

  @override
  String get prices_privacy_warning_sub_message =>
      'Jika Anda merasa tidak nyaman dengan hal itu, silakan ganti nama samaran Anda, atau buat akun Open Food Facts baru dan masuk ke aplikasi menggunakan akun tersebut.';

  @override
  String get i_refuse => 'Saya menolak';

  @override
  String get i_accept => 'Saya setuju';

  @override
  String get prices_currency_change_proposal_title => 'Ubah mata uang?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Mata uang Anda saat ini adalah **$currency**. Apa Anda mau mengubahnya ke **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Ya, gunakan $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Tidak, simpan $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Selesai';

  @override
  String get dev_mode_section_server => 'Konfigurasi server';

  @override
  String get dev_mode_section_news => 'Konfigurasi penyedia berita';

  @override
  String get dev_mode_section_product_page => 'Halaman produk';

  @override
  String get dev_mode_section_ui => 'Antarmuka Pengguna';

  @override
  String get dev_mode_section_experimental_features => 'Fitur eksperimental';

  @override
  String get dev_mode_hide_environmental_score_title => 'Kecualikan GreenScore';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Gunakan pemeriksa ejaan untuk layar OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(Bahan dan kemasan)';

  @override
  String get dev_mode_reset_app_language_title => 'Setel ulang bahasa aplikasi';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Tambahkan kartu';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Beralih antara prices.openfoodfacts.org (PROD) dan uji lingkungan';

  @override
  String get search_history_item_edit_tooltip =>
      'Gunakan kembali dan sunting pencarian ini';

  @override
  String get search_history_item_remove_tooltip => 'Hapus';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Anda telah mengunduh semua produk $totalSize.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Unduh $count lebih banyak produk\nSudah mengunduh $downloaded dari $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Pencarian Anda untuk $search sedang berlangsung.\n\nMohon tunggu beberapa detik…';
  }

  @override
  String get user_search_contributor_title => 'Produk yang saya tambahkan';

  @override
  String get user_search_informer_title => 'Produk yang saya sunting';

  @override
  String get user_search_photographer_title => 'Produk yang saya foto';

  @override
  String get user_search_to_be_completed_title =>
      'Produk saya yang harus diselesaikan';

  @override
  String get user_search_prices_title => 'Harga saya';

  @override
  String get user_search_proofs_title => 'Bukti saya';

  @override
  String get user_search_proof_title => 'Bukti saya';

  @override
  String search_proof_title(String user) {
    return 'Bukti dari \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Harga kontributor: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Harga terbaru ditambahkan';

  @override
  String get all_search_prices_top_user_title => 'Kontributor harga teratas';

  @override
  String get all_search_prices_top_location_title =>
      'Toko dengan harga paling tinggi';

  @override
  String get prices_contribution_assistant => 'Asisten Kontribusi Harga';

  @override
  String get prices_validation_assistant => 'Asisten Validasi Harga';

  @override
  String get prices_challenges_page => 'Tantangan';

  @override
  String get prices_multiple_proof_addition_system =>
      'Tambahkan Beberapa Bukti';

  @override
  String get all_search_prices_top_location_single_title => 'Harga di toko';

  @override
  String get all_search_prices_top_product_title =>
      'Produk dengan harga paling tinggi';

  @override
  String get all_search_to_be_completed_title =>
      'Semua produk yang akan diselesaikan';

  @override
  String get categorize_products_country_title =>
      'Bantu mengategorikan produk di negara Anda';

  @override
  String get edit_product_action_retake_picture => 'Ambil ulang';

  @override
  String get edit_product_action_take_picture => 'Ambil foto';

  @override
  String get edit_product_action_confirm => 'Konfirmasi';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Saya setuju dengan OpenFoodFacts ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'syarat penggunaan dan kontribusi';

  @override
  String get analytics_consent_image_semantic_label => 'Ikon analisis';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Kesalahan Fatal: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Kesalahan Fatal: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Lengkapi informasi dasar';

  @override
  String get edit_photo_button_label => 'Sunting';

  @override
  String get edit_photo_unselect_button_label => 'Batalkan pilihan foto';

  @override
  String get edit_photo_select_existing_button_label =>
      'Memilih gambar yang sudah ada';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Pilih gambar dengan mengekliknya';

  @override
  String get edit_photo_select_existing_download_label =>
      'Mengambil gambar yang sudah ada…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Tidak ada gambar yang pernah diunggah sebelumnya terkait dengan produk ini.';

  @override
  String get edit_photo_language_not_this_one =>
      'Belum ada gambar dalam bahasa tersebut';

  @override
  String get edit_photo_language_none => 'Belum ada gambar';

  @override
  String get category_picker_screen_title => 'Kategori';

  @override
  String get basic_details => 'Informasi Dasar';

  @override
  String get product_name => 'Nama Produk';

  @override
  String get product_names => 'Nama Produk';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Tambahkan terjemahan baru';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Sebelum memvalidasi, pastikan Anda hanya menambahkan terjemahan **jika bahasa tersebut tercantum pada kemasan**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Lihat foto tampak depan';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Ambil foto tampak depan';

  @override
  String get add_basic_details_product_name_hint =>
      'Masukkan nama produk (misalnya: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Ubah bahasa default?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Apakah Anda ingin bahasa default produk ditetapkan ke \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Contoh yang baik';

  @override
  String get explanation_section_bad_examples => 'Contoh yang buruk';

  @override
  String get add_basic_details_product_name_help_title =>
      'Praktik yang baik: Nama produk';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Nama produk adalah **nama utama yang tercetak pada kemasan**. Nama tersebut dapat merupakan merek dagang terdaftar.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Catatan:** Jangan menambahkan terjemahan **jika bahasa tersebut tidak tercantum pada kemasan**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Saus Tomat';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Jangan sertakan merek dalam nama produk';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Saus Tomat **oleh Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Jangan gunakan simbol ®, ™, ©, atau sejenisnya';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count terjemahan lainnya',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Nama merek';

  @override
  String get brand_names => 'Nama merek';

  @override
  String get add_basic_details_brand_name_error => 'Harap masukkan nama merek';

  @override
  String get add_basic_details_brand_names_hint =>
      'Masukkan merek (mis: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Praktik yang baik: Merek';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Masukkan **semua merek produk**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Merek utama';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Merek utama**, yang umumnya ditampilkan dengan jelas di bagian depan kemasan, harus **dimasukkan terlebih dahulu**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Merk lainnya';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Ketika dijual **oleh perusahaan besar**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** dijual oleh **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Ketika dijual dengan mereknya **yang diterjemahkan ke dalam beberapa bahasa**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** terkadang ditulis sebagai **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Kuantitas dan berat';

  @override
  String get add_basic_details_quantity_hint =>
      'Masukkan berat dan jika diperlukan jumlahnya (misalnya: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Praktik yang baik: Kuantitas';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Salin nilai yang tertera pada produk dan **jangan lupa satuan**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** atau **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (untuk 6 telur)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(untuk produk dengan 3 kotak, masing-masing 150g)';

  @override
  String get barcode => 'Kode batang';

  @override
  String barcode_barcode(String barcode) {
    return 'Kode batang: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Kode batang tidak valid';

  @override
  String get basic_details_add_success => 'Detail dasar berhasil ditambahkan';

  @override
  String get basic_details_add_error =>
      'Tidak dapat menambahkan informasi dasar. Silakan coba lagi setelah beberapa saat';

  @override
  String get clear_search => 'Hapus pencarian Anda';

  @override
  String get confirm_clear =>
      'Anda akan menghapus seluruh riwayat Anda: apakah Anda yakin ingin melanjutkan?';

  @override
  String get alert_clear_selected_user_list =>
      'Anda akan menghapus item yang dipilih dari riwayat Anda';

  @override
  String get confirm_clear_selected_user_list =>
      'Anda yakin ingin melanjutkan?';

  @override
  String get alert_select_items_to_clear =>
      'Silakan pilih satu atau lebih item untuk dihapus';

  @override
  String confirm_clear_user_list(String name) {
    return 'Anda akan menghapus daftar ini ($name): apakah Anda yakin ingin melanjutkan?';
  }

  @override
  String get confirm_delete_user_list_title => 'Hapus daftar?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Anda akan menghapus daftar “$name”.\nApakah Anda yakin ingin melanjutkan?';
  }

  @override
  String get confirm_delete_user_list_button => 'Ya, saya ingin melanjutkan';

  @override
  String importance_label(String name, String id) {
    return '$name pentingnya: $id';
  }

  @override
  String get user_list_all_title => 'Daftar';

  @override
  String get user_list_all_empty => 'Buat daftar pertama Anda';

  @override
  String get product_list_select => 'Pilih Daftar';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produk',
      one: 'Satu produk',
      zero: 'Daftar kosong',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Tambah daftar';

  @override
  String get open_food_preferences_tooltip => 'Sunting preferensi makanan Anda';

  @override
  String get add_photo_button_label => 'Tambah foto';

  @override
  String get add_packaging_photo_button_label =>
      'Ambil foto dari setiap informasi pengemasan/daur ulang';

  @override
  String get add_origin_photo_button_label => 'Mengambil foto informasi asal';

  @override
  String get add_emb_photo_button_label =>
      'Ambil foto informasi kode penelusuran apa pun';

  @override
  String get add_label_photo_button_label =>
      'Ambil foto informasi label & sertifikasi apa pun';

  @override
  String get choose_image_source_title => 'Memilih sumber gambar';

  @override
  String get choose_image_source_body => 'Silakan pilih sumber gambar';

  @override
  String get gallery_source_label => 'Galeri';

  @override
  String get gallery_source_access_denied_dialog_title => 'Akses ditolak';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Sayangnya, aplikasi ini tidak dapat mengakses galeri Anda, karena Anda telah menolak izin sebelumnya';

  @override
  String get gallery_source_access_denied_dialog_button => 'Buka Pengaturan';

  @override
  String get share => 'Bagikan';

  @override
  String share_product_text(String url) {
    return 'Lihatlah produk ini di Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Lihatlah produk ini di Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Lihatlah produk ini di Open Pet Food Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Lihat produk ini di Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Lihatlah daftar produk saya di Open Food Facts: $url';
  }

  @override
  String get capture => 'Foto Baru';

  @override
  String get capture_new_picture => 'Ambil gambar';

  @override
  String get choose_from_gallery => 'Pilih dari galeri';

  @override
  String get image_upload_queued =>
      'Gambar akan diunggah di latar belakang sesegera mungkin.';

  @override
  String get add_price_queued =>
      'Harga akan dikirim ke server sesegera mungkin.';

  @override
  String get background_task_title_full_refresh =>
      'Memulai penyegaran semua produk yang disimpan secara lokal';

  @override
  String get background_task_title_folksonomy =>
      'Mulai melakukan tindakan server untuk pembaruan folksonomi yang disimpan secara lokal';

  @override
  String get background_task_title_top_n =>
      'Memulai pengunduhan produk paling populer';

  @override
  String get expand_nutrition_facts => 'Perluas tabel fakta nutrisi';

  @override
  String get expand_nutrition_facts_body => 'Perluas tabel fakta nutrisi';

  @override
  String get expand_ingredients => 'Perbanyak bahan';

  @override
  String get expand_ingredients_body =>
      'Pertahankan panel bahan yang diperluas';

  @override
  String get no_internet_connection => 'Tidak ada sambungan Internet';

  @override
  String get world_results_label => 'Seluruh dunia';

  @override
  String get world_results_action => 'Perluas pencarian Anda ke seluruh dunia';

  @override
  String get copy_to_clipboard => 'Salin';

  @override
  String get paste_from_clipboard => 'Tempel dari papan klip';

  @override
  String get no_data_available_in_clipboard =>
      'Tidak ada data yang tersedia di papan klip Anda';

  @override
  String get clipboard_barcode_copy => 'Salin kode batang ke papan klip';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Kode batang $barcode disalin ke papan klip!';
  }

  @override
  String get open_product_website => 'Buka produk ini di situs web';

  @override
  String get language_picker_label => 'Bahasa Anda';

  @override
  String get country_picker_label => 'Negara Anda';

  @override
  String get currency_picker_label => 'Mata uang Anda';

  @override
  String get help_with_openfoodfacts => 'Bantuan OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produk akan diperbarui di latar belakang sesegera mungkin.';

  @override
  String get no_email_client_available_dialog_title =>
      'Tidak ada aplikasi email!';

  @override
  String get no_email_client_available_dialog_content =>
      'Silakan kirimkan email secara manual kepada kami ke mobile@openfoodfacts.org';

  @override
  String get all_images => 'Semua Gambar';

  @override
  String get selected_images => 'Gambar yang dipilih';

  @override
  String get product_card_remove_product_tooltip => 'Hapus produk';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Kode batang baru dipindai: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Hapus semua produk dari carousel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Harap pindai setidaknya dua produk untuk membandingkannya';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Klik untuk membandingkan produk yang telah Anda pindai';

  @override
  String get scan_product_loading => 'Anda telah memindai barcode:';

  @override
  String get scan_product_loading_initial =>
      'Kami sedang memuat produk ini!\nMohon tunggu beberapa saat…';

  @override
  String get scan_product_loading_long_request =>
      'Kami masih mencoba memuat produk ini!\nApakah prosesnya terlalu lama? Mohon tunggu…';

  @override
  String get scan_product_loading_unresponsive =>
      'Kami masih mencoba memuat produk ini.\nApakah Anda ingin mengulang pencarian?';

  @override
  String get scan_product_loading_restart_button => 'Mengulang pencarian';

  @override
  String get portion_calculator_description =>
      'Hitung informasi nilai gizi untuk jumlah tertentu';

  @override
  String get portion_calculator_hint => 'Jumlah dalam';

  @override
  String get portion_calculator_accessibility =>
      'Masukkan kuantitas untuk menghitung informasi nilai nutrisi';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Silakan masukkan jumlah antara $min dan $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Data tidak ditemukan. Perhitungan tidak dapat dilakukan.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Informasi nilai gizi untuk $grams g (or ml)';
  }

  @override
  String get offline_data => 'Data Luring';

  @override
  String get ocr_image_upload_instruction =>
      'Unggah gambar untuk mengekstrak informasi yang dikandungnya secara otomatis.';

  @override
  String get upload_image => 'Unggah Foto';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Gagal mengunduh gambar';

  @override
  String get image_edit_url_error =>
      'Gagal mengedit gambar karena URL gambar tidak ditetapkan.';

  @override
  String get user_picture_source_remember => 'Ingat pilihan saya';

  @override
  String get user_picture_source_ask => 'Tanyakan setiap kali';

  @override
  String get robotoff_continue => 'Selanjutnya';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pertanyaan',
      one: 'pertanyaan',
    );
    return '$_temp0 berikutnya';
  }

  @override
  String get show_password => 'Tampilkan Kata Sandi';

  @override
  String get owner_field_info_title => 'Nilai yang diberikan produsen';

  @override
  String get owner_field_info_message =>
      'Dengan logo tersebut, kami menampilkan data yang disediakan oleh produsen, dan mungkin tidak dapat diedit.';

  @override
  String get owner_field_info_close_button => 'Tutup informasi ini';

  @override
  String get owner_field_image =>
      'Gambar ini disediakan oleh produsen. Gambar ini mungkin tidak dapat diedit.';

  @override
  String get edit_packagings_title => 'Komponen pengemasan';

  @override
  String get edit_packagings_element_add => 'Menambahkan komponen pengemasan';

  @override
  String get edit_packagings_completed => 'Kemasannya sudah lengkap';

  @override
  String edit_packagings_element_title(int index) {
    return 'Komponen kemasan #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Jumlah unit';

  @override
  String get edit_packagings_element_hint_units =>
      'Masukkan jumlah unit kemasan dengan bentuk dan bahan yang sama yang terdapat dalam produk.';

  @override
  String get edit_packagings_element_field_shape => 'Bentuk';

  @override
  String get edit_packagings_element_hint_shape =>
      'Masukkan nama bentuk yang tercantum dalam petunjuk daur ulang jika tersedia, atau pilih bentuk.';

  @override
  String get edit_packagings_element_example_shape => 'Botol';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Masukkan bahan spesifik jika dapat ditentukan (kode bahan di dalam segitiga sering kali dapat ditemukan pada bagian kemasan), atau bahan umum (misalnya plastik atau logam) jika Anda tidak yakin.';

  @override
  String get edit_packagings_element_example_material => 'Kaca';

  @override
  String get edit_packagings_element_field_recycling => 'Instruksi daur ulang';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Masukkan petunjuk daur ulang hanya jika petunjuk tersebut tercantum pada produk.';

  @override
  String get edit_packagings_element_example_recycling => 'Daur Ulang';

  @override
  String get edit_packagings_element_field_quantity =>
      'Jumlah bersih produk per unit';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Masukkan berat bersih atau volume bersih dan tunjukkan satuannya (misalnya g atau ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Berat satu unit kosong (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Buang makanan yang tersisa dan cuci serta keringkan bagian kemasan sebelum menimbang. Jika memungkinkan, gunakan timbangan dengan ketelitian 0,1 gram atau 0,01 gram.';

  @override
  String get background_task_title => 'Kontribusi yang tertunda';

  @override
  String get background_task_subtitle =>
      'Kontribusi Anda secara otomatis disimpan di server kami, tetapi tidak selalu secara real-time.';

  @override
  String get background_task_list_empty =>
      'Tidak Ada Tugas Latar Belakang yang Tertunda';

  @override
  String get background_task_error_server_time_out => 'Batas waktu server';

  @override
  String get background_task_error_no_internet =>
      'Kesalahan koneksi internet. Coba lagi nanti.';

  @override
  String get background_task_operation_unknown =>
      'jenis operasi yang tidak diketahui';

  @override
  String get background_task_operation_details => 'perubahan terperinci';

  @override
  String get background_task_operation_image => 'unggah foto';

  @override
  String get background_task_operation_refresh =>
      'penyegaran tertunda setelah unggahan foto';

  @override
  String get background_task_run_started => 'dimulai';

  @override
  String get background_task_run_not_started => 'belum dimulai';

  @override
  String get background_task_run_to_be_deleted => 'akan dihapus';

  @override
  String get background_task_question_stop =>
      'Apakah Anda ingin menghentikan tugas itu secepatnya?';

  @override
  String get feed_back => 'Umpan balik';

  @override
  String get undo => 'Batalkan';

  @override
  String get copy_email_to_clip_board => 'Salin surel ke papan klip';

  @override
  String get please_send_us_an_email_to =>
      'Mohon kirimkan kami email secara manual ke';

  @override
  String get email_copied_to_clip_board => 'Email disalin ke papan klip!';

  @override
  String get select_accent_color => 'Pilih Warna Aksen';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Biru';

  @override
  String get color_cyan => 'Sian';

  @override
  String get color_green => 'Hijau';

  @override
  String get color_light_brown => 'Bawaan';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Oranye';

  @override
  String get color_pink => 'Pink';

  @override
  String get color_red => 'Merah';

  @override
  String get color_rust => 'Karat';

  @override
  String get color_teal => 'Hijau kebiruan';

  @override
  String get text_contrast_mode => 'Kontras Teks';

  @override
  String get contrast_high => 'Tinggi';

  @override
  String get contrast_medium => 'Sedang';

  @override
  String get contrast_low => 'Rendah';

  @override
  String get product_refresher_internet_not_found => 'Produk tidak ditemukan!';

  @override
  String get product_refresher_internet_not_connected =>
      'Anda tidak tersambung ke internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server mati ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Kesalahan server ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produk tidak ditemukan!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Produk dengan kode batang berikut tidak ada dalam basis data kami: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Tidak ada koneksi internet!';

  @override
  String get product_loader_network_error_message =>
      'Harap periksa apakah ponsel cerdas Anda tersambung pada jaringan WiFi atau data seluler diaktifkan';

  @override
  String get page_not_found_title => 'Halaman tidak ditemukan!';

  @override
  String get page_not_found_button => 'Kembali ke halaman depan';

  @override
  String get download_data => 'Unduh data';

  @override
  String get download_top_products =>
      'Unduh 1000 produk teratas di negara Anda untuk pemindaian instan';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produk',
    );
    return 'Unduh $_temp0 teratas di negara Anda untuk pemindaian instan';
  }

  @override
  String get download_in_progress =>
      'Mengunduh data\nIni mungkin memerlukan waktu beberapa saat';

  @override
  String downloaded_products(int num) {
    return '$num produk ditambahkan';
  }

  @override
  String get update_offline_data => 'Memperbarui data produk offline';

  @override
  String get update_local_database_sub =>
      'Memperbarui basis data produk lokal dengan data terbaru dari Open Food Facts';

  @override
  String get clear_local_database => 'Menghapus data produk offline';

  @override
  String get clear_local_database_sub =>
      'Menghapus semua data produk lokal dari aplikasi Anda untuk mengosongkan ruang';

  @override
  String deleted_products(int num) {
    return '$num produk dihapus';
  }

  @override
  String get loading => 'Memuat…';

  @override
  String get know_more => 'Tahu Lebih Banyak';

  @override
  String get offline_data_desc =>
      'Klik untuk mengetahui lebih lanjut tentang data offline';

  @override
  String get offline_product_data_title => 'Data produk offline';

  @override
  String available_for_download(int num) {
    return 'Produk $num tersedia untuk pemindaian segera';
  }

  @override
  String get country_selector_title => 'Pilih negara Anda:';

  @override
  String get currency_selector_title => 'Pilih mata uang Anda:';

  @override
  String get language_selector_title => 'Pilih bahasa:';

  @override
  String get language_selector_section_selected => 'Bahasa yang dipilih';

  @override
  String get language_selector_section_frequently_used => 'Sering digunakan';

  @override
  String get action_delete_list => 'Hapus';

  @override
  String get action_change_list => 'Mengubah daftar saat ini';

  @override
  String get product_list_create => 'Buat';

  @override
  String get product_list_create_tooltip => 'Buat daftar baru';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Perhitungan baru)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Perhitungan baru)';

  @override
  String get nutriscore_unknown => 'Nutri-Score tidak diketahui';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nutri-Score tidak diketahui (Perhitungan baru)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score tidak dapat diterapkan';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score tidak bisa diterapkan (Perhitungan baru)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Skor Hijau A';

  @override
  String get environmental_score_b_new => 'Skor Hijau B';

  @override
  String get environmental_score_c_new => 'Skor Hijau C';

  @override
  String get environmental_score_d_new => 'Skor Hijau D';

  @override
  String get environmental_score_e_new => 'Skor Hijau E';

  @override
  String get environmental_score_unknown_new => 'Skor Hijau Tidak Diketahui';

  @override
  String get environmental_score_not_applicable_new =>
      'Skor Hijau tidak berlaku';

  @override
  String get nova_group_generic_new => 'Makanan ultra-olahan - Grup NOVA';

  @override
  String get nova_group_1 => 'NOVA Kelompok 1';

  @override
  String get nova_group_2 => 'NOVA Kelompok 2';

  @override
  String get nova_group_3 => 'NOVA Kelompok 3';

  @override
  String get nova_group_4 => 'NOVA Kelompok 4';

  @override
  String get nova_group_unknown => 'Grup NOVA yang tidak diketahui';

  @override
  String get nutrition_facts => 'Tingkat Kandungan Gizi';

  @override
  String get faq_title_partners => 'Para Mitra & Pelindung LSM';

  @override
  String get faq_title_vision =>
      'Visi, Misi, Tata Nilai, dan Program Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Instal Open Beauty Facts untuk membuat basis data kosmetik';

  @override
  String get faq_title_install_pet =>
      'Instal Open Pet Food Facts untuk membuat basis data makanan hewan peliharaan';

  @override
  String get faq_title_install_product =>
      'Instal Open Products Facts untuk membuat basis data produk guna memperpanjang masa pakai objek';

  @override
  String get faq_nutriscore_nutriscore =>
      'Perhitungan baru Nutri-Score: apa yang baru?';

  @override
  String get contact_title_pro_page =>
      'Pro? Impor produk Anda di Open Food Facts';

  @override
  String get contact_title_pro_email => 'Kontak Produser';

  @override
  String get contact_title_press_page => 'Halaman Pers';

  @override
  String get contact_title_press_email => 'Kontak Pers';

  @override
  String get contact_title_newsletter => 'Berlangganan buletin kami';

  @override
  String get contact_title_calendar =>
      'Berlangganan ke kalender komunitas kami';

  @override
  String get hunger_games_loading_line1 =>
      'Tolong beri kami waktu beberapa detik…';

  @override
  String get hunger_games_loading_line2 => 'Kami mengunduh pertanyaannya!';

  @override
  String get hunger_games_error_label =>
      'Argh! Terjadi kesalahan… dan kami tidak bisa memuat pertanyaan.';

  @override
  String get hunger_games_error_retry_button => 'Mari kita coba lagi!';

  @override
  String get reorder_attribute_action => 'Susun ulang atribut';

  @override
  String get link_cant_be_opened =>
      'Tautan ini tidak dapat dibuka di perangkat Anda. Pastikan Anda telah menginstal browser.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Rincian untuk $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Rincian untuk $pageName dengan $productName';
  }

  @override
  String get guide_title => 'Panduan';

  @override
  String get guide_share_label => 'Bagikan';

  @override
  String get guide_nutriscore_v2_title =>
      'Nutri-Score terus berkembang: penjelasan!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Apa itu Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Nutri-Score merupakan sebuah logo yang bertujuan untuk memberikan informasi kepada Anda tentang **kualitas nutrisi makanan**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'Kode warna bervariasi mulai dari hijau tua (**A**) untuk produk **tersehat** hingga merah tua (**E**) untuk produk *kurang sehat**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption => 'Logo Nutri-Score A';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Mengapa Nutri-Score terus berkembang?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'Formula Nutri-Score **berkembang** agar bisa memberikan rekomendasi yang lebih baik:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Lebih baik dalam mengevaluasi semua minuman';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'Catatan perbandingan antara **susu**, **minuman susu* dengan gula tambahan, dan minuman berbasis **sayuran** dibedakan secara lebih baik dengan algoritma baru.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Pemeringkatan minuman lebih baik';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      '**Kandungan gula** diperhitungan dengan lebih baik dan mengutamakan minuman **rendah pemanis**. \\n**Pemanis juga akan dikenakan sanksi**: soda diet akan diturunkan peringkatnya dari B ke antara C dan E. Air tetap minuman yang direkomendasikan.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Garam dan gula dikenai sanksi';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Produk yang **terlalu manis** atau **terlalu asin** akan makin mengalami *penurunan peringkat**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarki minyak dan ikan';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'Peringkat **ikan berlemak** tertentu dan **minyak kaya lemak baik** akan diperbaiki.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Pembatasan daging merah';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Konsumsi **daging merah sebaiknya dibatasi**. Oleh karena itu, **unggas akan diberi peringkat yang relatif lebih baik**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Bagaimana membedakan perhitungan Nutri-Score lama dan baru?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'Mulai saat ini, logo dapat menampilkan penyebutan \"**Perhitungan baru**\" untuk memperjelas bahwa ini merupakan perhitungan baru.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Logo baru Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Di mana saya dapat menemukan penghitungan Nutri-Score yang baru?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score diterapkan di 7 negara: Prancis, Jerman, Belgia, Spanyol, Luksemburg, Belanda, dan Swiss.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Pihak manufaktur memiliki waktu paling lama **2 tahun** setelah penandatanganan keputusan untuk mengganti perhitungan lama dengan yang baru.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Tanpa perlu menunggu, Anda **akan langsung menemukan di dalam aplikasi OpenFoodFacts**, perhitungan baru, termasuk jika produsen belum memperbarui skor.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Apa yang tidak berubah';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Nutri-Score merupakan skor yang dirancang untuk **mengukur kualitas nutrisi**. Ini **melengkapi klasifikasi grup NOVA** untuk **makanan ultra proses** (yang juga ada di dalam aplikasi).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Bagi produsen, tampilan Nutri-Score **tetap opsional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'Apa itu Skor Hijau?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score adalah logo yang bertujuan untuk memberi tahu Anda tentang **dampak lingkungan dari makanan**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Kode warna bervariasi dari hijau tua (**A+**) untuk produk **yang paling tidak berdampak** hingga merah tua (**F**) untuk produk **yang paling berdampak**.';

  @override
  String get guide_greenscore_logos_caption => 'Logo Skor Hijau';

  @override
  String get guide_greenscore_lca_title => 'Inti: Penilaian siklus hidup (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Evaluasi ilmiah terhadap kategori makanan';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Untuk setiap kategori produk, skor **patokan** ditetapkan menggunakan data dari basis data lingkungan Agribalyse (dirancang oleh ADEME dan INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Analisis siklus hidup** adalah metode penilaian standar untuk melaksanakan penilaian lingkungan multi-tahap dan multi-kriteria.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Pengukurannya:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 langkah produksi';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Pertanian';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Memproses';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Kemasan';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportasi';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribusi';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Konsumsi';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indikator dampak lingkungan';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'Perubahan iklim/jejak karbon';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Penipisan lapisan ozon';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Radiasi pengion';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Tanah';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Penggunaan air & energi';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Polusi udara';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Air laut & air tawar (partikel, pengasaman, eutrofikasi)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Penipisan sumber daya.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonus dan penalti';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Untuk memberi penghargaan kepada produk yang lebih baik dalam suatu kategori, kami kemudian menerapkan **bonus & penalti berdasarkan beberapa kriteria**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'Mode produksi';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Bonus** diberikan kepada produk yang memiliki **label resmi, label atau sertifikasi yang menjamin manfaat lingkungan** (organik, perdagangan adil, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title => 'Asal usul bahan';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'Bonus diberikan berdasarkan asal bahan-bahan. Bonus ini memperhitungkan dampak transportasi dan juga kebijakan lingkungan dari negara produsen masing-masing.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Spesies yang terancam punah';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Sanksi** diberikan kepada produk yang mengandung bahan-bahan yang memiliki **dampak negatif yang signifikan terhadap keanekaragaman hayati dan ekosistem**, seperti minyak sawit, yang produksinya bertanggung jawab atas deforestasi besar-besaran.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Kemasan';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Denda** dihitung dengan mempertimbangkan **sirkularitas kemasan** (penggunaan bahan baku daur ulang dan kemampuan daur ulang) dan pengemasan berlebihan.';

  @override
  String get guide_greenscore_transparency_title =>
      'Meningkatnya kebutuhan akan transparansi untuk mengukur dan mengurangi dampak lingkungan dengan lebih baik';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Untuk menghitung Green-Score secara akurat, diperlukan **informasi yang tidak selalu tercantum pada kemasan** (seperti asal dan persentase pasti dari setiap bahan) atau yang jarang tersedia dalam bentuk yang mudah digunakan (seperti daftar semua komponen kemasan dengan jenis plastik yang digunakan secara tepat).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Nilai rata-rata digunakan ketika informasi ini belum tersedia**, tetapi kami sekarang mengajak semua orang untuk membantu kami mengumpulkan informasi ini yang akan sangat berguna untuk Green-Score tetapi juga untuk banyak kegunaan lainnya.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Bagaimana warga dapat membantu?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Seluruh warga dapat membantu kami mengumpulkan dan menyusun informasi yang terdapat pada produk atau yang dapat disimpulkan dari produk tersebut, seperti informasi tentang **kemasan**: \"Mission Emballages\": inventarisasi kemasan skala besar yang dilakukan secara kolaboratif untuk semua produk makanan (dalam bahasa Prancis).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Bagaimana produsen dapat membantu';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Produsen dapat mengirimkan informasi mereka langsung kepada kami melalui platform gratis kami untuk produsen.';

  @override
  String get guide_greenscore_better_product_title =>
      'Produk mana yang lebih baik untuk planet ini?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Sulit untuk mengatakannya';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Memilih makanan berkelanjutan adalah salah satu hal paling hebat yang dapat kita lakukan untuk iklim, karena **sistem pangan global kita bertanggung jawab atas lebih dari seperempat dari seluruh emisi gas rumah kaca**.\n(Sumber: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title =>
      'Anda punya kekuatan!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Kabar baiknya adalah ini memberi kita cara ampuh untuk menciptakan perubahan.\n**Kita masing-masing makan sekitar 1.000 kali setiap tahun**. Itu berarti 1.000 kesempatan untuk **memilih masa depan yang lebih baik bagi planet ini**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Membantu untuk bertanggung jawab dan memutuskan';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Memilih makanan berkelanjutan bisa terasa rumit. Labelnya membingungkan dan informasinya seringkali hilang. Green-Score diciptakan untuk menyederhanakannya, memberikan Anda peringkat lingkungan yang **jelas**, **berbasis sains**, dan **transparan** untuk produk makanan, tepat di tempat yang Anda butuhkan: saat Anda berbelanja.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparansi';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Tidak seperti label hak milik, perhitungan Green-Score **sepenuhnya terbuka** dan dapat **diverifikasi oleh siapa saja**.';

  @override
  String get guide_nova_title => 'Makanan ultraproses';

  @override
  String get guide_nova_what_is_nova_title => 'Apa itu ultra-processing?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Kelompok NOVA memberi tahu Anda tentang tingkat pengolahan makanan.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Klasifikasi NOVA memungkinkan pengkategorian makanan menjadi **4 kelompok** berdasarkan **derajat pemrosesan industrinya** (makanan yang diproses minimal atau tidak diproses, bahan kuliner, makanan olahan, makanan ultra-olahan).';

  @override
  String get guide_nova_logos_caption => 'Logo NOVA';

  @override
  String get guide_nova_groups_title => '4 grup NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Ada 4 kelompok NOVA, yang bermasalah adalah Kelompok 4 - Makanan ultra-olahan.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Makanan yang diproses minimal atau tidak diproses';

  @override
  String get guide_nova_groups_arg1_text =>
      'Makanan yang tidak diolah (atau alami) adalah **bagian tanaman yang dapat dimakan** (biji, buah, daun, batang, akar) **atau hewan** (otot, jeroan, telur, susu), serta jamur, alga, dan air, setelah dipisahkan dari alam.';

  @override
  String get guide_nova_groups_arg2_title => 'Bahan - bahan kuliner olahan';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Makanan olahan';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances From Group 2 to Group 1** Foods. processes include various preservation or cooking methods, and in the case of breads and Cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified Versions of Group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Makanan ultraproses';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in These formulations Usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain Other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted From foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Masalah dengan ultra-processing';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Pemrosesan bahan makanan secara ekstrem';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Banyak di antaranya **berasal dari pengolahan lebih lanjut komponen makanan**, seperti minyak terhidrogenasi atau teresterifikasi, protein terhidrolisis, isolat protein kedelai, maltodekstrin, gula invert, dan sirup jagung fruktosa tinggi.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Aditif yang melampaui keamanan pangan murni';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Zat aditif dalam makanan ultra-olahan mencakup beberapa zat yang juga digunakan dalam makanan olahan, seperti pengawet, antioksidan, dan penstabil. Kelas zat aditif yang hanya ditemukan dalam produk ultra-olahan meliputi zat yang digunakan **untuk meniru atau meningkatkan kualitas sensorik makanan atau untuk menyamarkan aspek yang tidak enak dari produk akhir**. Zat aditif ini meliputi pewarna dan warna lainnya, penstabil warna; perisa, penguat rasa, pemanis non-gula; dan bahan pembantu pengolahan seperti zat karbonasi, pengental, pengembang dan anti-pengembang, penghilang busa, anti-penggumpalan dan pelapis, pengemulsi, pengikat, dan humektan.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Pemrosesan yang tidak dapat Anda lakukan di rumah';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Banyak sekali rangkaian proses yang digunakan** untuk menggabungkan berbagai bahan yang biasanya banyak dan menciptakan produk akhir (karena itu disebut \'ultra-proses\'). Proses-proses tersebut mencakup beberapa proses **yang tidak memiliki padanan di dalam negeri**, seperti hidrogenasi dan hidrolisis, ekstrusi dan pencetakan, serta pra-pemrosesan untuk penggorengan.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Aspek predator dan finansial dari ultra-processing';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Tujuan utama dari pengolahan ultra adalah untuk menciptakan produk makanan bermerek**, **praktis** (tahan lama, siap dikonsumsi), **menarik** (sangat lezat), dan **sangat menguntungkan** (bahan-bahan berbiaya rendah) yang dirancang untuk menggantikan semua kelompok makanan lainnya. Produk makanan ultra-olahan biasanya dikemas secara menarik dan dipasarkan secara intensif.**';

  @override
  String get guide_nova_explanations_arg5_title => 'Bahaya bagi kesehatan';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Sejak 2018, dengan NutriNet-Santé, hubungan pertama antara **konsumsi makanan ultra-olahan dan peningkatan risiko kanker, penyakit kardiovaskular, dan diabetes telah disoroti**. Saat ini, lebih dari 90 studi di seluruh dunia mengkonfirmasi temuan ini.\nHubungan terkuat berkaitan dengan **obesitas, kematian akibat penyakit kardiovaskular, dan gejala depresi**. Pada anak-anak, efeknya terutama diamati pada berat badan dan ketidakseimbangan lipid.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Negara-negara merekomendasikan untuk membatasinya.';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Beberapa negara menggunakan kelompok NOVA untuk pedoman atau tujuan diet mereka, misalnya:\n\n- Pedoman diet **🇧🇷 Brasil** merekomendasikan untuk membatasi konsumsi makanan olahan dan menghindari makanan ultra-olahan.\n\n- Tujuan kebijakan gizi kesehatan masyarakat **🇫🇷 Prancis** untuk tahun 2018-2022 bertujuan untuk **mengurangi konsumsi makanan ultra-olahan kelompok 4 sebesar 20%**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Selamat datang di Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Apa itu Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts adalah basis data produk makanan dari seluruh dunia yang **kolaboratif**, **gratis**, dan **terbuka**.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Kami percaya bahwa setiap orang harus memiliki akses ke informasi tentang apa yang mereka makan. Dengan mengumpulkan data tentang bahan-bahan, alergen, fakta nutrisi, dan banyak lagi, **kami memberdayakan konsumen untuk membuat pilihan yang tepat** dan mendorong industri makanan **menuju transparansi yang lebih besar**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Fitur-fitur dari Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Dapatkan peringatan untuk bahan-bahan yang tidak diinginkan';

  @override
  String get guide_open_food_facts_tips_title =>
      'Tips untuk mengambil foto yang bagus';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Larangan';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Hindari bayangan dan pantulan cahaya.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Tidak ada teks yang buram atau tidak fokus.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Jangan memotong bagian-bagian teks.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Hindari latar belakang yang ramai.';

  @override
  String get guide_open_food_facts_tips_arg2_title =>
      'Hal yang harus dilakukan';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Gunakan pencahayaan yang baik dan merata.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Pastikan teks tajam dan mudah dibaca.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Catat seluruh daftar bahan-bahannya.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Letakkan produk di permukaan yang datar.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Bantu kami membangun \"Wikipedia Makanan\"';

  @override
  String get guide_open_food_facts_scores_arg1_title => 'Skor kualitas nutrisi';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Skor untuk menghindari makanan ultra-olahan';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Sebuah skor untuk planet ini';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-id.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Selamat datang di Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Apa itu Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts memperluas misi kami kepada teman-teman berbulu kami! Ini adalah **basis data produk makanan hewan peliharaan untuk kucing, anjing, dan hewan peliharaan lainnya**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Kami mengumpulkan informasi tentang **bahan-bahan**, **analisis nutrisi**, dan panduan pemberian makan untuk membantu pemilik hewan peliharaan memilih makanan terbaik sesuai kebutuhan hewan mereka.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Fitur-fitur dari Informasi Fakta Makanan Hewan Peliharaan yang Terbuka';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Dapatkan peringatan untuk bahan-bahan yang tidak diinginkan';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Apakah hewan peliharaan Anda alergi terhadap bahan-bahan tertentu? Anda dapat mengatur daftar bahan kosmetik yang harus dihindari, langsung di aplikasi!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips untuk mengambil foto yang bagus';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Larangan';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Hindari bayangan dan pantulan cahaya.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Tidak ada teks yang buram atau tidak fokus.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Jangan memotong bagian-bagian teks.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Hindari latar belakang yang ramai.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title =>
      'Hal yang harus dilakukan';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Gunakan pencahayaan yang baik dan merata.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Pastikan teks tajam dan mudah dibaca.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Catat seluruh daftar bahan-bahannya.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Letakkan produk di permukaan yang datar.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Catatan tentang penilaian';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Mengembangkan sistem penilaian untuk makanan hewan peliharaan **bukan prioritas saat ini**. Metodologinya akan kompleks, karena kebutuhan nutrisi sangat bervariasi menurut spesies, usia, dan kondisi kesehatan. Kami belum menemukan tim ilmiah independen yang mampu mengembangkan skor tersebut.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-id.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Selamat datang di Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Apa itu Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts adalah basis data kolaboratif untuk **produk kosmetik**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Tujuan kami adalah untuk menguraikan daftar bahan agar Anda dapat **memahami apa yang terkandung dalam produk perawatan pribadi Anda**. Mulai dari pelembap hingga riasan, kami mengumpulkan data tentang bahan-bahan, alergen, dan kemasan untuk mendorong transparansi dalam industri kosmetik.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Fitur-fitur dari Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Dapatkan peringatan untuk bahan-bahan yang tidak diinginkan';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Apakah Anda alergi terhadap bahan tertentu? Ingin menghindari zat komedogen? Ingin menjauhi komponen yang kontroversial? Anda dapat mengatur daftar bahan kosmetik yang ingin dihindari, langsung di aplikasi!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips untuk mengambil foto yang bagus';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Larangan';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Hindari bayangan dan pantulan cahaya.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Tidak ada teks yang buram atau tidak fokus.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Jangan memotong bagian-bagian teks.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Hindari latar belakang yang ramai.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title =>
      'Hal yang harus dilakukan';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Gunakan pencahayaan yang baik dan merata.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Pastikan teks tajam dan mudah dibaca.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Catat seluruh daftar bahan-bahannya.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Ambil foto sebanyak yang diperlukan jika botolnya melengkung.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Anda mungkin perlu mengupas labelnya untuk melihat daftar bahan-bahannya.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Letakkan produk di permukaan yang datar.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Catatan tentang penilaian';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Tidak seperti produk makanan, dunia kosmetik **tidak memiliki sistem penilaian yang diakui secara universal dan didukung pemerintah seperti Nutri-Score**. Efek bahan-bahan tertentu sangat personal dan bergantung pada jenis kulit, alergi, dan masalah individu.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-id.openbeautyfacts.org/temukan';

  @override
  String get guide_open_prices_title => 'Selamat datang di Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices adalah sebuah proyek untuk **mengumpulkan dan membagikan harga produk di seluruh dunia**. Ini adalah kumpulan data yang tersedia untuk umum yang dapat digunakan untuk penelitian, analisis, dan banyak lagi. Open Prices dikembangkan dan dikelola oleh Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Saat ini hanya ada sedikit perusahaan yang memiliki database besar harga produk pada tingkat barcode. Harga-harga ini tidak tersedia secara gratis, tetapi dijual dengan harga tinggi kepada pihak swasta, peneliti, dan organisasi lain yang mampu membelinya.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Kami sedang mengumpulkan data harga sumber terbuka melalui crowdsourcing.** Harga dapat ditambahkan oleh pengguna melalui aplikasi web ini, atau melalui aplikasi seluler resmi Open Food Facts. Peritel atau aplikasi pihak ketiga juga dapat berkontribusi dengan menggunakan API kami.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Kumpulkan foto label harga di lorong-lorong toko.';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Kumpulkan foto-foto struk pembelian.';

  @override
  String get guide_open_prices_why_title =>
      'Mengapa Open Food Facts melakukan ini?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Informasi harga sangat penting untuk memahami sistem pangan. Ini merupakan faktor kunci dalam memahami biaya pangan dan untuk mempromosikan pola makan yang lebih sehat. Membuka data harga adalah cara untuk mempermudah peneliti, jurnalis, dan warga untuk **memiliki pemahaman yang lebih baik tentang bagaimana harga pangan bervariasi secara geografis dan dari waktu ke waktu**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Lacak perkembangan harga dari waktu ke waktu.';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Saksikan **evolusi harga**: shrinkflation, cheapflation, kita bisa melacaknya bersama!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Bandingkan harga di dekat Anda';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Dengan semakin banyaknya harga yang kami dapatkan, Anda dapat menemukan **toko-toko termurah di sekitar Anda**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Apakah Anda mempertimbangkan untuk mengambil data harga dari situs web pengecer?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Karena alasan hukum dan teknis, **kami tidak menganggap pengambilan data harga dari situs web pengecer sebagai cara yang sah untuk berkontribusi pada Open Prices**. Kami ingin memastikan bahwa harga yang kami kumpulkan akurat dan terkini, dan menerima data harga yang diambil dari kontributor tidak memungkinkan kami untuk melakukan hal tersebut.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Pengambilan data harga (price scraping) merupakan opsi yang dipertimbangkan dalam versi Open Prices mendatang, tetapi hal itu akan dilakukan oleh Open Prices sendiri sehingga kita dapat memiliki bukti harga berdasarkan halaman HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'Saya seorang pengecer dan saya ingin memberikan kontribusi harga. Bagaimana saya bisa melakukan itu?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Anda dapat berkontribusi dalam hal harga dengan menggunakan API kami.\nJika Anda ingin berkontribusi dalam hal harga dalam skala besar, silakan hubungi kami di prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Selamat datang di Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Apa itu Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts adalah basis data terbuka yang sangat besar untuk **produk apa pun yang memiliki kode batang, yang bukan makanan, kosmetik, atau makanan hewan peliharaan**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Mulai dari **elektronik** hingga **mainan**, dan **pakaian** hingga **perlengkapan kebersihan**, jika memiliki barcode, maka dapat ditambahkan. Proyek ini bertujuan untuk menciptakan \"Internet of Things\" untuk objek sehari-hari, sehingga informasi tentang objek tersebut dapat diakses secara universal.';

  @override
  String get guide_open_products_facts_features_title =>
      'Fitur-fitur Produk Terbuka (Fakta-fakta)';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts bertujuan untuk memberikan solusi sirkular kepada konsumen agar dapat **memperpanjang umur barang**, dengan memelihara, **memperbaiki**, **mendaur ulang** barang mereka, atau memberikannya kepada pemilik baru.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Jejak karbon untuk beberapa produk';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Dampak CO2** dari Otoritas Lingkungan Prancis ADEME memberikan **dampak karbon** dari berbagai kategori, pastikan untuk mengkategorikan produk dengan tepat.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Indeks kemampuan perbaikan untuk banyak produk';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Setiap kali indeks kemampuan perbaikan Prancis tersedia, kami akan menampilkannya. Selain itu, **Anda dapat mulai mengumpulkan variabel menggunakan Folksonomy Engine**; sehingga kami dapat menghitung ulang sendiri di masa mendatang, bahkan di negara-negara yang belum memiliki indeks tersebut.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Temukan cara untuk menyumbangkan/menjual kembali produk Anda.';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Kami menyediakan tautan ke **layanan pihak ketiga yang ramah terhadap ekonomi sirkular** yang membantu Anda mendapatkan jenis produk yang Anda cari, sebagai produk bekas, agar lebih ramah terhadap sumber daya planet.\nPerlu dicatat bahwa kami tidak dibayar untuk melakukan hal itu, dan sistem ini hanya berfungsi sebagai contoh untuk dua situs web di Prancis. Anda dapat membantu memperluas sistem ini dengan mendokumentasikan lebih banyak situs di wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Informasi apa yang bermanfaat?';

  @override
  String get guide_open_products_facts_information_text =>
      'Untuk berbagai macam barang seperti itu, **data yang kami kumpulkan bersifat fleksibel**. Untuk itu, **kami menciptakan Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'Mesin Folksonomi';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine adalah alat yang membantu Anda melengkapi produk dengan properti yang relevan. Ini membantu meningkatkan pencarian dan kemudahan penemuan, serta menghitung dan menampilkan hal-hal menarik di masa mendatang.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Anda dapat menambahkan kunci dan nilai apa pun seperti: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Anda akan mendapatkan saran otomatis mengenai properti yang mungkin, dan Anda dipersilakan untuk menambahkan dan mendokumentasikan properti baru pada jenis produk favorit Anda.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-id.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Terbuka terhadap preferensi makanan';

  @override
  String get guide_coming_soon_button_title => 'Segera hadir';

  @override
  String get guide_learn_more_subtitle =>
      'Ketuk untuk mempelajari lebih lanjut';

  @override
  String get preview_badge => 'Pratinjau';

  @override
  String get prices_feedback_form =>
      'Klik di sini untuk mengirimkan umpan balik Anda tentang fitur baru ini!';

  @override
  String get menu_button_list_actions => 'Pilih tindakan';

  @override
  String get error_loading_photo => 'Eror memuat foto';

  @override
  String get photo_viewer_action_use_picture_as => 'Gunakan sebagai…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Gunakan gambar ini sebagai…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Gunakan gambar ini sebagai… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Rincian';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Rincian foto ini';

  @override
  String get photo_viewer_details_title => 'Rincian foto ini';

  @override
  String get photo_viewer_details_contributor_title => 'Kontributor';

  @override
  String get photo_viewer_details_size_title => 'Ukuran';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height piksel';
  }

  @override
  String get photo_viewer_details_date_title => 'Tanggal';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Kompatibel';

  @override
  String get user_lists_action_multi_select => 'Multi-pilihan';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Skor kompatibilitas Anda: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Gambar depan';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Gambar kandungan bahan';

  @override
  String get product_image_nutrition_accessibility_label => 'Gambar nutrisi';

  @override
  String get product_image_packaging_accessibility_label => 'Gambar kemasan';

  @override
  String get product_image_other_accessibility_label => 'Gambar lainnya';

  @override
  String get product_image_outdated_message =>
      'Gambar ini mungkin sudah terlalu lama';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (gambar ini mungkin sudah terlalu lama)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (gambar ini mungkin dikunci oleh produser)';
  }

  @override
  String get product_image_error => 'Tidak dapat memuat gambar!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Tidak dapat memuat $type (kesalahan jaringan?)';
  }

  @override
  String get product_page_image_no_image_available => 'Tidak ada\ngambar!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Tidak tersedia gambar untuk produk ini';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Susun ulang atau sembunyikan tindakan';

  @override
  String get product_page_action_bar_setting_modal_title => 'Sunting tindakan';

  @override
  String get product_page_action_bar_item_move_up => 'Pindahkan ke atas';

  @override
  String get product_page_action_bar_item_move_down => 'Pindahkan ke bawah';

  @override
  String get product_page_action_bar_item_enable => 'Aktifkan tindakan';

  @override
  String get product_page_action_bar_item_disable => 'Nonaktifkan tindakan';

  @override
  String get product_page_pending_operations_banner_title =>
      'Mengunggah suntingan Anda…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Data yang ditampilkan di halaman ini **belum mencerminkan modifikasi Anda**.\nMohon tunggu beberapa detik…';

  @override
  String get product_add_a_language => 'Tambahkan bahasa';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Kode batang $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Hapus produk ini dari carousel';

  @override
  String get carousel_unsupported_header => 'Kode batang tidak didukung!';

  @override
  String get carousel_unsupported_title => 'Ups!';

  @override
  String get carousel_unsupported_text =>
      'Kode batang yang dipindai tidak didukung oleh Open Food Facts!';

  @override
  String get carousel_error_header => 'Eror!';

  @override
  String get carousel_error_title => 'Sayang sekali!';

  @override
  String get carousel_error_text_1 =>
      'Kami tidak dapat mengunduh informasi pada kode batang:';

  @override
  String get carousel_error_text_2 =>
      'Silakan periksa koneksi internet Anda atau klik tombol ini:';

  @override
  String get carousel_error_button => 'Coba lagi';

  @override
  String get carousel_unknown_product_header => 'Produk tidak diketahui';

  @override
  String get carousel_unknown_product_title =>
      'Selamat!\nAnda menemukan __permata yang langka!__';

  @override
  String get carousel_unknown_product_text =>
      'Basis data kolaboratif kami berisi lebih dari **3 juta produk**, tetapi barcode ini tidak ada: ';

  @override
  String get carousel_unknown_product_button => 'Tambahkan produk ini';

  @override
  String get carousel_loading_header => 'Memuat informasi...';

  @override
  String get carousel_loading_title =>
      'Anda baru saja memindai produk dengan barcode berikut:';

  @override
  String get carousel_loading_text =>
      'Kami mencarinya dalam basis data kami yang berisi lebih dari **3 juta produk!**';

  @override
  String get product_type_subtitle_food =>
      'Sayuran, buah-buahan, makanan beku…';

  @override
  String get product_type_subtitle_beauty => 'Makeup, sabun, pasta gigi…';

  @override
  String get product_type_subtitle_pet_food => 'Makanan anjing, kucing…';

  @override
  String get product_type_subtitle_product => 'Ponsel pintar, furnitur…';

  @override
  String get photo_field_front => 'Foto produk';

  @override
  String get photo_field_ingredients => 'Foto kandungan bahan';

  @override
  String get photo_field_nutrition => 'Foto nutrisi';

  @override
  String get photo_field_packaging => 'Foto instruksi daur ulang';

  @override
  String get photo_already_exists => 'Foto ini sudah ada';

  @override
  String get photo_missing => 'Foto ini hilang';

  @override
  String get date => 'Tanggal';

  @override
  String get photo_rotate_left => 'Putar ke kiri';

  @override
  String get photo_rotate_right => 'Putar ke kanan';

  @override
  String get photo_undo_action => 'Urungkan tindakan sebelumnya';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Peta dunia dari $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Kontributor OpenStreetMap';

  @override
  String get not_applicable_short => 'T/A';

  @override
  String get knowledge_panel_warning_text => 'Peringatan';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Mengapa Nutri-Score ini berbeda dengan yang ada di kemasan?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Ada dua kemungkinan penjelasan:\nDaftar bahan dan/atau fakta gizi tidak mutakhir.\n\nKami menyediakan \"Perhitungan baru\" dari Nutri-Score (atau V2). Harap periksa apakah Anda memiliki spanduk \"Perhitungan baru\" pada kemasannya.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Cek bahan-bahan';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Cek informasi nilai gizi';

  @override
  String url_not_supported(String url) {
    return 'Sayangnya, kami tidak dapat membuka URL:\n$url';
  }

  @override
  String get product_list_export => 'Ekspor';

  @override
  String get product_list_import => 'Impor';

  @override
  String get product_footer_action_barcode => 'Lihat Barcode';

  @override
  String get product_footer_action_barcode_short => 'Kode batang';

  @override
  String get product_footer_action_open_website => 'Buka situs web';

  @override
  String get product_footer_action_report => 'Laporkan';

  @override
  String get product_footer_action_contributor_guide => 'Bantuan';

  @override
  String get product_footer_action_data_quality_tags => 'Kualitas data';

  @override
  String get product_page_tab_for_me => 'Untuk saya';

  @override
  String get product_page_tab_website => 'Situs Web';

  @override
  String get product_page_tab_prices => 'Harga';

  @override
  String get prices_explanation_card_title => 'Mengapa harga?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** adalah proyek untuk mengumpulkan dan berbagi harga produk di seluruh dunia 🌍. Open Prices dikembangkan dan dikelola oleh Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Pelajari lebih lanjut';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title =>
      'Apa saja atribut Folksonomi?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atribut didasarkan pada **kunci-nilai**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Properti ini dibuat dan diarsipkan oleh kontributor untuk segala jenis penggunaan.';

  @override
  String get folksonomy_action_external_link_title => 'Buka tautan eksternal';

  @override
  String get folksonomy_action_external_link_warning =>
      'Tautan eksternal mungkin tidak aman. Apakah Anda benar-benar ingin mengunjunginya?';

  @override
  String get prices_products_empty_title => 'Tidak ada harga yang tersedia';

  @override
  String get prices_products_empty_explanation =>
      'Jadilah yang pertama berkontribusi!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return '$pageSize produk teratas (total: $total)';
  }

  @override
  String get app_review_title => 'Apakah Anda menyukai aplikasi ini?';

  @override
  String get app_review_low => 'Bisa lebih ditingkatkan lagi';

  @override
  String get app_review_medium => 'Cukup baik';

  @override
  String get app_review_high => 'Saya sangat menyukainya!';

  @override
  String get app_review_feedback_modal_title =>
      'Bantu kami meningkatkan aplikasi kami';

  @override
  String get app_review_feedback_modal_content =>
      'Jika Anda memiliki beberapa menit, bisakah Anda mengisi formulir ini agar **kami dapat memperbaiki di pembaruan mendatang**:';

  @override
  String get app_review_feedback_modal_open_form => 'Isi formulir';

  @override
  String get app_review_feedback_modal_later => 'Tanya lagi nanti';

  @override
  String get nutrition_facts_extract_new =>
      'BARU: Anda dapat secara otomatis mengekstrak nutrisi dari gambar!';

  @override
  String get nutrition_facts_extract_button_text => 'Ekstrak sekarang';

  @override
  String get nutrition_facts_extract_in_progress =>
      'Ekstraksi sedang berlangsung…';

  @override
  String get nutrition_facts_extract_successful => 'Ekstraksi berhasil';

  @override
  String get nutrition_facts_extract_failed =>
      'Gagal mengekstrak nutrisi dari gambar';

  @override
  String get prices_discount => 'Diskon';

  @override
  String get prices_stats_statistics => 'Statistik';

  @override
  String get prices_stats_title => 'Statistik Harga';

  @override
  String get prices_stats_prices_section => 'Harga';

  @override
  String get prices_stats_products_section => 'Produk - produk';

  @override
  String get prices_stats_locations_section => 'Lokasi';

  @override
  String get prices_stats_proofs_section => 'Bukti';

  @override
  String get prices_stats_contributors_section => 'Kontributor';

  @override
  String get prices_stats_experiments_section => 'Eksperimen';

  @override
  String get prices_stats_misc_section => 'Lain-lain';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'Dengan kode batang';

  @override
  String get prices_stats_with_category => 'Dengan kategori';

  @override
  String get prices_stats_with_discount => 'Dengan diskon';

  @override
  String get prices_stats_community => 'Komunitas';

  @override
  String get prices_stats_consumption => 'Konsumsi';

  @override
  String get prices_stats_with_price => 'Dengan harga';

  @override
  String get prices_stats_food => 'Makanan';

  @override
  String get prices_stats_beauty => 'Kecantikan';

  @override
  String get prices_stats_products => 'Produk - produk';

  @override
  String get prices_stats_pet_food => 'Makanan hewan';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Aktif';

  @override
  String get prices_stats_countries => 'Negara - negara';

  @override
  String get prices_stats_price_tag => 'Label harga';

  @override
  String get prices_stats_receipt => 'Resi';

  @override
  String get prices_stats_gdpr_request => 'Permintaan GDPR';

  @override
  String get prices_stats_shop_import => 'Belanja impor';

  @override
  String get prices_stats_challenges => 'Tantangan';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Harga yang tercantum pada label harga';

  @override
  String get prices_stats_currencies => 'Mata uang';

  @override
  String get prices_stats_years => 'Tahun';

  @override
  String get prices_stats_by_source_title => 'Harga dan bukti per sumber';

  @override
  String get prices_stats_website => 'Situs Web';

  @override
  String get prices_stats_mobile_app => 'Aplikasi seluler';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Lainnya';

  @override
  String get prices_stats_last_updated => 'Terakhir diperbarui pada';

  @override
  String get prices_stats_error => 'Terjadi kesalahan saat memuat statistik.';

  @override
  String get product_edit_robotoff_question_answered =>
      'Pertanyaan telah terjawab!';

  @override
  String get product_edit_robotoff_proof => 'Bukti';

  @override
  String get preferences_card_general => 'Umum';

  @override
  String get preferences_prices_title => 'Harga';

  @override
  String get preferences_prices_subtitle => 'Kelola preferensi harga Anda';

  @override
  String get preferences_card_project => 'Proyek Fakta Makanan Terbuka';

  @override
  String get preferences_contribute_title => 'Berkontribusi';

  @override
  String get preferences_my_contributions_title => 'Kontribusi saya';

  @override
  String get preferences_my_stats_title => 'Statistik saya';

  @override
  String get preferences_contribute_subtitle =>
      'Terjemahkan, tingkatkan alat kami…';

  @override
  String get preferences_connect_title => 'Menghubungkan';

  @override
  String get preferences_connect_subtitle =>
      'Hubungi kami, atau Ikuti kami di media sosial';

  @override
  String get preferences_support_title => 'Berikan donasi';

  @override
  String get preferences_support_subtitle =>
      'Bantu kami memberi informasi kepada jutaan konsumen di seluruh dunia';

  @override
  String get preferences_card_help => 'Bantuan & Dukungan';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle =>
      'Dapatkan jawaban atas pertanyaan Anda';

  @override
  String get logged_out => 'Keluar';

  @override
  String get preferences_app_bar_message =>
      'Terima kasih telah menjadi salah satu anggota kami!';

  @override
  String get preferences_app_bar_products_modified =>
      'Produk - produk yang dimodifikasi';

  @override
  String get preferences_app_bar_prices_added => 'Harga ditambahkan';

  @override
  String get preferences_app_bar_see_all_stats => 'Lihat semua statistik';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Cari $provider untuk \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Cari pengaturan (misalnya Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Aksesibilitas: Tampilkan emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Aksesibilitas: Hapus warna';

  @override
  String get preferences_app_settings_products => 'Produk - produk';

  @override
  String get preferences_card_about => 'Tentang';

  @override
  String get preferences_legal_information_title => 'Informasi hukum';

  @override
  String get preferences_legal_information_subtitle =>
      'Ketentuan penggunaan, kebijakan privasi, dan lainnya';

  @override
  String get preferences_terms_of_use => 'Syarat Penggunaan';

  @override
  String get preferences_legal_mentions => 'Penyebutan hukum';

  @override
  String get preferences_legal_header =>
      'Open Food Facts adalah basis data produk makanan **yang dibuat oleh semua orang, untuk semua orang**.\nAnda dapat menggunakannya untuk membuat pilihan makanan yang lebih baik, dan karena ini adalah **data terbuka**, siapa pun dapat **menggunakannya kembali untuk tujuan apa pun**.';

  @override
  String get preferences_privacy_policy => 'Kebijakan privasi';

  @override
  String get preferences_licenses => 'Lisensi';

  @override
  String get preferences_about_app_title => 'Tentang aplikasi';

  @override
  String get preferences_about_app_subtitle =>
      'Informasi teknis, informasi pengembang, dan lainnya';

  @override
  String get preferences_card_information => 'Informasi';

  @override
  String get preferences_version_number_title => 'Nomor versi';

  @override
  String get preferences_scanner_title => 'Pemindai';

  @override
  String get preferences_app_store => 'Toko aplikasi';

  @override
  String get preferences_app_system_settings => 'Pengaturan sistem';

  @override
  String get preferences_source_code => 'Akses kode sumber';

  @override
  String get preferences_source_code_subtitle =>
      'Dan mulailah membuat dampak bagi jutaan orang';

  @override
  String get preferences_add_prices => 'Tambahkan harga';

  @override
  String get preferences_complete_products => 'Produk-produk lengkap';

  @override
  String get preferences_tips => 'Kiat';

  @override
  String get tips_discover_nutriscore => 'Temukan Nutri-Score yang baru';

  @override
  String get preferences_on_off_website_subtitle =>
      'Di situs web Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Kelola akun saya';

  @override
  String get preferences_manage_account_tooltip => 'Kelola akun Anda';

  @override
  String get preferences_change_password_title => 'Ubah kata sandi saya';

  @override
  String get preferences_danger_zone => 'Zona bahaya';

  @override
  String get preferences_account_deletion_subtitle =>
      'Semua kontribusi Anda akan hilang';

  @override
  String get preferences_contributions_title => 'Kontribusi';

  @override
  String get preferences_dev_mode_app_settings_title => 'Pengaturan aplikasi';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Cara yang sangat eksperimental untuk memindai produk secara offline';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Segarkan semua produk dari server';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Harap hindari melakukan hal itu kecuali benar-benar diperlukan';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Mode demo';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Tambahkan kartu ke pemindai';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Menambahkan 3 produk sampel ke pemindai';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Pembawa acara Folksonomy';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Tuan rumah: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Eksperimen aksesibilitas';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Pilihan multi-produk untuk harga';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Panel pengetahuan yang dipesan pengguna';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Akses sementara ke pencarian lokasi';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Perbandingan berdampingan untuk 2 atau 3 produk';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Impor daftar produk';

  @override
  String get preferences_faq_scores_methodologies_title => 'Skor & metodologi';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Temukan bagaimana Nutri-Score dihitung';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Temukan perubahan utama pada metodologi';

  @override
  String get preferences_faq_discover_project_title => 'Temukan proyeknya';

  @override
  String get preferences_faq_discover_off_title => 'Temukan Open Food Facts';

  @override
  String get preferences_faq_discover_obf_title =>
      'Temukan Fakta Kecantikan Terbuka';

  @override
  String get preferences_faq_discover_opff_title =>
      'Temukan Fakta Makanan Hewan Peliharaan Terbuka';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Temukan Fakta Produk Terbuka';

  @override
  String get preferences_faq_faq_title =>
      'FAQ - Pertanyaan yang Sering Diajukan';

  @override
  String get preferences_faq_off_ngo_title => 'LSM Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informasi';

  @override
  String get preferences_connect_community_updates_title =>
      'Dapatkan pembaruan komunitas';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Tetap ikuti perkembangan berita aplikasi dan komunitas';

  @override
  String get preferences_connect_community_calendar_title =>
      'Berlangganan ke kalender komunitas kami';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Berpartisipasilah dengan menghadiri salah satu acara virtual kami';

  @override
  String get preferences_connect_blog_title => 'Blog Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Dapatkan berita terbaru, saat itu terjadi';

  @override
  String get preferences_connect_community_help_title =>
      'Dapatkan bantuan dari komunitas';

  @override
  String get preferences_connect_improve_app_title =>
      'Bantu kami meningkatkan aplikasi';

  @override
  String get preferences_connect_debug_info_title =>
      'Kirimkan kami informasi debug';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Kirimkan kami email dengan informasi debugging terperinci';

  @override
  String get preferences_connect_feedback_title =>
      'Kirimkan masukan kepada kami tentang aplikasi ini';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Bantu membentuk masa depan aplikasi';

  @override
  String get preferences_connect_survey_title => 'Ikuti survei aplikasi';

  @override
  String get preferences_connect_survey_subtitle =>
      'Bantu kami memahami apa yang harus kami bangun selanjutnya';

  @override
  String get preferences_connect_professionals_title => 'Profesional';

  @override
  String get preferences_connect_pro_subtitle =>
      'Sepenuhnya gratis, memastikan data akurat untuk 500 aplikasi & jutaan konsumen. Layanan mandiri, kompatibel dengan PIM atau spreadsheet Anda (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Hubungi kami untuk memulai';

  @override
  String get preferences_connect_press_title => 'Pers';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Dapatkan semua materi yang Anda butuhkan untuk laporan Anda';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Hubungi kami untuk pertanyaan pers atau untuk memberi tahu kami tentang laporan Anda';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Menjadi relawan aktif';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Pengembangan, Komunikasi, Desain… segala jenis kesukarelaan atau keahlian diterima!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Temukan beberapa cara Anda dapat berkontribusi';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Pengembangan aplikasi seluler';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Pelajari cara berkontribusi pada pengembangan perangkat lunak';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Build tidak stabil harian, fitur baru';

  @override
  String get preferences_contribute_local_community_title =>
      'Kembangkan komunitas lokal Anda';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Bantuan dengan perangkat lunak, konten, terjemahan analisis bahan';

  @override
  String get preferences_contribute_share_subtitle =>
      'Kami telah menyiapkan templat kecil untuk membantu Anda :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Langkah sederhana untuk menumbuhkan transparansi pangan di negara Anda';

  @override
  String get preferences_contribute_data_quality_title => 'Kualitas data';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Bergabunglah dengan tim kualitas data';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Bergabunglah dengan upaya kami untuk memastikan database lengkap dan akurat';

  @override
  String get preferences_contributions_products_added_title =>
      'Produk tambahan';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Produk baru yang saya tambahkan ke Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produk yang perlu saya selesaikan';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Semua produk tidak lengkap';

  @override
  String get preferences_my_contributions_prices_title => 'Harga';

  @override
  String get preferences_my_contributions_my_prices_title => 'Harga saya';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Harga saya, bukti saya…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produk yang dapat Anda bantu selesaikan';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Bantu hitung Nutri-Score & Green-Score di negara Anda';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Harga yang saya kontribusikan';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Label harga dan tanda terima';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Ambil foto tanda terima Anda dan pindai kode batang terkait';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Ambil foto harga di toko';

  @override
  String get preferences_prices_newest_title => 'Harga terbaru';

  @override
  String get preferences_prices_newest_subtitle =>
      'Harga terbaru yang ditambahkan oleh komunitas Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Kontributor dengan harga terbanyak';

  @override
  String get preferences_prices_metrics_title => 'Metrik Harga Terbuka';

  @override
  String get preferences_prices_metrics_subtitle => 'Ikuti perkembangan proyek';

  @override
  String get preferences_prices_ways_contribute_title => 'Cara berkontribusi';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Konfirmasikan harga yang ditambahkan oleh Anda sendiri atau orang lain, dengan bantuan AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Tambahkan banyak tanda terima atau foto rak dari rol kamera Anda dengan cepat';

  @override
  String get preferences_prices_challenges_title => 'Tantangan bulanan';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Berpartisipasilah dalam misi tematik bulanan untuk mengumpulkan hadiah';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Dapatkan kembali data loyalitas Anda';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Pelajari cara meminta data Anda';

  @override
  String get preferences_page_customize_app_title => 'Sesuaikan aplikasi';

  @override
  String get preferences_page_contribute_project_title =>
      'Berkontribusi pada proyek';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Cara sederhana untuk membantu Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodologi skor, bantuan, dan informasi lebih lanjut tentang proyek ini';

  @override
  String get product_edit_robotoff_positive_button => 'Terima saran';

  @override
  String get product_edit_robotoff_negative_button => 'Tolak saran';

  @override
  String get product_edit_robotoff_show_proof => 'Tunjukkan buktinya';

  @override
  String get product_edit_robotoff_expand_proof => 'Perluas bukti';

  @override
  String get product_page_tab_raw_data => 'Data mentah';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Halaman $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Halaman $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count dari $total item';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count dari $total item';
  }

  @override
  String item_count(int count) {
    return '$count item';
  }

  @override
  String item_count_string(String count) {
    return '$count item';
  }

  @override
  String get prices_no_result => 'Tidak ada statistik harga yang ditemukan.';

  @override
  String get prices_error_loading_more_items =>
      'Terjadi kesalahan saat memuat lebih banyak item';

  @override
  String get prices_proof_error =>
      'Otentikasi gagal, tidak dapat mengambil bukti';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count dari $total bukti';
  }

  @override
  String proof_count(int count) {
    return '$count bukti';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count dari $total kontributor';
  }

  @override
  String contributors_count(int count) {
    return '$count kontributor';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count dari $total lokasi';
  }

  @override
  String prices_locations_count(int count) {
    return '$count lokasi';
  }

  @override
  String get restart_to_apply_message =>
      'Silakan mulai ulang aplikasi untuk menerapkan perubahan.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Antarmuka grafis';

  @override
  String get preferences_app_settings_media_title => 'Media';

  @override
  String get preferences_about_app_development_title => 'Pengembangan';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Laboratorium Open Food Facts';

  @override
  String get preferences_root_account_title => 'Akun';

  @override
  String get preferences_contribute_translate_header =>
      'Hadirkan Open Food Facts ke bahasa Anda';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Daftar di versi alfa aplikasi';

  @override
  String get preferences_dev_mode_section_data => 'Kontribusi & Data Produk';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Jangan tampilkan Folksonomy';

  @override
  String get preferences_account_title => 'Akun';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Ditambahkan pada $created';
  }

  @override
  String get location_map_details_title => 'Detail lokasi';

  @override
  String get location_map_details_name => 'Nama';

  @override
  String get location_map_details_street => 'Jalan';

  @override
  String get location_map_details_city => 'Kota';

  @override
  String get location_map_details_postcode => 'Kode Pos';

  @override
  String get location_map_details_country => 'Negara';

  @override
  String get location_map_details_coordinates => 'Koordinat';

  @override
  String get location_map_details_osm_id => 'ID OSM';
}
