// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hungarian (`hu`).
class AppLocalizationsHu extends AppLocalizations {
  AppLocalizationsHu([String locale = 'hu']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Igen';

  @override
  String get add => 'Hozzáadás';

  @override
  String get account_delete_message =>
      'Biztosan törölni szeretné a fiókját?\nHa van konkrét oka, kérjük ossza meg alább';

  @override
  String get reason => 'Ok';

  @override
  String get okay => 'Rendben';

  @override
  String get validate => 'Érvényesítés';

  @override
  String get create => 'Létrehozás';

  @override
  String get applyButtonText => 'Alkalmaz';

  @override
  String get next_label => 'Következő';

  @override
  String get continue_label => 'Folytatás';

  @override
  String get exit_label => 'Kilépés';

  @override
  String get previous_label => 'Előző';

  @override
  String get go_back_to_top => 'Vissza a tetejére';

  @override
  String get save => 'Mentés';

  @override
  String get save_confirmation => 'Biztosan menteni szeretné?';

  @override
  String get skip => 'Kihagyás';

  @override
  String get cancel => 'Mégse';

  @override
  String get ignore => 'Mellőzés';

  @override
  String get close => 'Bezárás';

  @override
  String get no => 'Nem';

  @override
  String get stop => 'Leállítás';

  @override
  String get finish => 'Befejezés';

  @override
  String get calculate => 'Kiszámítás';

  @override
  String get reset_food_prefs => 'Preferált ételek visszaállítása';

  @override
  String get error => 'Valami hiba történt';

  @override
  String get error_occurred => 'Hiba történt';

  @override
  String get featureInProgress =>
      'Még dolgozunk ezen a funkción, maradjon velünk';

  @override
  String get label_web => 'Megtekintés az interneten';

  @override
  String get learnMore => 'További információk';

  @override
  String get unknown => 'Ismeretlen';

  @override
  String get match_very_good => 'Nagyon jó egyezés';

  @override
  String get match_good => 'Jó egyezés';

  @override
  String get match_poor => 'Gyenge egyezés';

  @override
  String get match_may_not => 'Nem egyezhet';

  @override
  String get match_does_not => 'Nem egyezik';

  @override
  String get match_unknown => 'Ismeretlen egyezés';

  @override
  String get match_short_very_good => 'Nagyon jó egyezés';

  @override
  String get match_short_good => 'Jó egyezés';

  @override
  String get match_short_poor => 'Gyenge egyezés';

  @override
  String get match_short_may_not => 'Nem egyezhet';

  @override
  String get match_short_does_not => 'Nem egyezik';

  @override
  String get match_short_unknown => 'Ismeretlen egyezés';

  @override
  String get licenses => 'Licencek';

  @override
  String get looking_for => 'Keresés';

  @override
  String get welcomeToOpenFoodFacts => 'Üdvözli az Open Food Facts';

  @override
  String get whatIsOff =>
      'Az Open Food Facts egy helyi közösségek által működtetett globális nonprofit szervezet.';

  @override
  String get productDataUtility =>
      'Tekintse meg az Ön preferenciáinak megfelelő élelmiszeradatokat.';

  @override
  String get healthCardUtility =>
      'Válasszon olyan élelmiszereket, amelyek jók Önnek.';

  @override
  String get ecoCardUtility =>
      'Válasszon olyan élelmiszereket, amelyek jót tesznek a bolygónak.';

  @override
  String get server_error_open_new_issue =>
      'A szerver nem válaszol! A következő linken nyithat hibajelentést.';

  @override
  String get sign_in_text =>
      'A közreműködései mentéséhez jelentkezzen be az OpenFoodFacts fiókjába';

  @override
  String get incorrect_credentials => 'Helytelen felhasználónév vagy jelszó.';

  @override
  String get password_lost_incorrect_credentials =>
      'Ez az e-mailcím vagy felhasználónév nem létezik. Ellenőrizze a hitelesítési adatait.';

  @override
  String get password_lost_server_unavailable =>
      'Jelenleg lassulást tapasztalunk a szervereinken, amiért elnézést kérünk. Kérjük, próbálja meg később újra.';

  @override
  String get login => 'Bejelentkezés';

  @override
  String get login_result_type_server_unreachable => 'A hálózat nem érhető el';

  @override
  String get login_result_type_server_issue =>
      'Probléma a szerveren. Kérjük, próbálja meg később.';

  @override
  String get login_page_username_or_email =>
      'Adja meg felhasználónevét vagy e-mail címét';

  @override
  String get login_page_password_error_empty => 'Adjon meg egy jelszót';

  @override
  String get create_account => 'Fiók létrehozása';

  @override
  String get sign_in => 'Bejelentkezés';

  @override
  String get sign_in_mandatory => 'Ehhez a funkcióhoz be kell jelentkeznie.';

  @override
  String get help_improve_country =>
      'Segítsen az Open Food Facts fejlesztésében az Ön országában';

  @override
  String get sign_out => 'Kijelentkezés';

  @override
  String get sign_out_confirmation => 'Biztosan ki szeretne jelentkezni?';

  @override
  String get password => 'Jelszó';

  @override
  String get forgot_password => 'Elfelejtett jelszó';

  @override
  String get forgot_password_question => 'Elfelejtett jelszó?';

  @override
  String get view_profile => 'Profil megtekintése';

  @override
  String get reset_password => 'Jelszó visszaállítása';

  @override
  String get reset_password_explanation_text =>
      'Elfelejtett jelszó esetén adja meg felhasználónevét vagy e-mail címét, hogy megkapja a jelszó visszaállítására vonatkozó utasításokat. Ne felejtse el ellenőrizni a Spam mappát is.';

  @override
  String get username_or_email => 'Felhasználónév vagy e-mail cím';

  @override
  String get reset_password_done =>
      'A jelszó visszaállítására szolgáló hivatkozást elküldtük a fiókjához társított e-mail címre. Ellenőrizze a spam mappát is';

  @override
  String get send_reset_password_mail => 'Jelszó módosítása';

  @override
  String get enter_some_text => 'Írjon be valamilyen szöveget';

  @override
  String get sign_up_page_title => 'Regisztráció';

  @override
  String get sign_up_page_action_button => 'Regisztráció';

  @override
  String get sign_up_page_action_doing_it => 'Regisztráció…';

  @override
  String get sign_up_page_action_ok => 'Gratulálunk, a fiókja létrejött!';

  @override
  String get sign_up_page_display_name_hint => 'Név';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Kérjük, adja meg felhasználónevét';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'E-mail szükséges';

  @override
  String get sign_up_page_email_error_invalid => 'Érvénytelen e-mail';

  @override
  String get sign_up_page_username_hint =>
      'Felhasználónév: Nyilvánosan látható';

  @override
  String get sign_up_page_username_error_empty =>
      'Adjon meg egy felhasználónevet';

  @override
  String get sign_up_page_username_error_invalid =>
      'Adjon meg egy érvényes felhasználónevet';

  @override
  String get sign_up_page_username_description =>
      'A felhasználónév nem tartalmazhat szóközt, nagybetűket vagy speciális karaktereket.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'A felhasználónév nem lehet $value karakternél hosszabb';
  }

  @override
  String get sign_up_page_password_hint => 'Jelszó';

  @override
  String get sign_up_page_password_error_empty => 'Adjon meg egy jelszót';

  @override
  String get sign_up_page_password_error_invalid =>
      'Adjon meg egy érvényes jelszót (legalább 6 karakter)';

  @override
  String get sign_up_page_confirm_password_hint => 'Jelszó megerősítése';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Erősítse meg a jelszavát';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'A jelszavak nem egyeznek';

  @override
  String get sign_up_page_agree_text => 'Egyetértek az Open Food Facts';

  @override
  String get sign_up_page_terms_text =>
      'felhasználási és hozzájárulási feltételeivel';

  @override
  String get donate_url =>
      'https://hu.openfoodfacts.org/donate-to-open-food-facts';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Fiók létrehozásakor a felhasználási feltételek elfogadása kötelező, azonban az alkalmazáson keresztül továbbra is lehetséges a névtelen hozzájárulás';

  @override
  String get sign_up_page_producer_checkbox => 'Élelmiszergyártó vagyok';

  @override
  String get sign_up_page_producer_hint => 'Gyártó/márka';

  @override
  String get sign_up_page_producer_error_empty =>
      'Adjon meg egy gyártói vagy márkanevet';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Szeretnék feliratkozni az Open Food Facts hírlevélre (bármikor leiratkozhat róla)';

  @override
  String get sign_up_page_user_name_already_used =>
      'A felhasználónév már létezik. Válasszon másik felhasználónevet.';

  @override
  String get sign_up_page_email_already_exists =>
      'már létezik, jelentkezzen be a fiókba, vagy próbálja meg másik e-mail címmel.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Valódi email címet adjon meg.';

  @override
  String get sign_up_page_server_busy =>
      'Nagyon sajnáljuk, hogy technikai nehézségekbe ütköztünk a fiók létrehozásánál. Kérjük, próbálja meg később újra.';

  @override
  String get settingsTitle => 'Beállítások';

  @override
  String get darkmode => 'Téma';

  @override
  String get darkmode_dark => 'Sötét';

  @override
  String get darkmode_light => 'Világos';

  @override
  String get darkmode_system_default => 'Rendszer alapértelmezett';

  @override
  String get thanks_for_contributing => 'Köszönjük a közreműködést!';

  @override
  String get contributors_label => 'Ők fejlesztik az alkalmazást';

  @override
  String get contributors_dialog_title => 'Hozzájárulók';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Közreműködő: $name';
  }

  @override
  String get contributors_description =>
      'Az alkalmazás összes közreműködőjének listája';

  @override
  String get support => 'Támogatás';

  @override
  String get support_join_slack => 'Kérjen segítséget Slack csatornánkon.';

  @override
  String get support_via_forum => 'Kérjen segítséget a fórumonkon';

  @override
  String get support_via_email => 'Küldjön nekünk emailt';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Elküldi az alkalmazásnaplókat?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Szeretné csatolni az alkalmazás naplófájlját az e-mail mellékleteként?';

  @override
  String get termsOfUse => 'Felhasználási feltételek';

  @override
  String get legalNotices => 'Jogi nyilatkozat';

  @override
  String get privacy_policy => 'Adatvédelmi Irányelvek';

  @override
  String get about_this_app => 'Az alkalmazásról';

  @override
  String get contribute => 'Hozzájárulás';

  @override
  String get contribute_sw_development => 'Szoftverfejlesztés';

  @override
  String get contribute_develop_text =>
      'Minden Open Food Facts projekt forráskódja elérhető a GitHubon. Szívesen látjuk, ha újrafelhasználja a kódot (nyílt forráskódú), segít nekünk fejleszteni, mindenki számára, az egész bolygón.';

  @override
  String get contribute_develop_text_2 =>
      'Csatlakozhat az Open Food Facts Slack csevegőszobához, amely a kérdések feltevésének kedvelt módja.';

  @override
  String get contribute_develop_dev_mode_title => 'Fejlesztői mód?';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'Fejlesztői mód aktiválása';

  @override
  String get contribute_donate_title => 'Adományozás';

  @override
  String get contribute_donate_header =>
      'Adományozzon az Open Food Facts számára';

  @override
  String get contribute_enroll_alpha_warning =>
      'Vegye figyelembe, hogy a belső alfa verzióval a teljes adatvesztés is előfordulhat, és az alkalmazás bármikor használhatatlanná válhat!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Kiegészítendő termékek';

  @override
  String get contribute_improve_header => 'Javítás';

  @override
  String get contribute_improve_text =>
      'Az adatbázis a projekt magja. Könnyen és nagyon gyorsan hozzá tud járulni. Letöltheti a mobilalkalmazást telefonjára, és megkezdheti a termékek hozzáadását vagy kiegészítését.\n\nAz OpenFoodFacts webhely pedig számos, további módot kínál a hozzájárulásra: ';

  @override
  String get contribute_translate_header => 'Fordítás';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Kezdje el a fordítást';

  @override
  String get contribute_translate_text =>
      'Az OpenFoodFacts egy globális projekt, amely több mint 160 ország termékeit tartalmazza. Az OpenFoodFacts több tucat nyelvre van lefordítva, folyamatosan fejlődő tartalommal.';

  @override
  String get contribute_translate_text_2 =>
      'A fordítás a projekt egyik legfontosabb feladatai közé tartozik';

  @override
  String get contribute_join_skill_pool =>
      'Járuljon hozzá készségeivel az Open Food Factshez. Csatlakozzon a képességtárhoz!';

  @override
  String get contribute_share_header =>
      'Ossza meg barátaival az OpenFoodFacts-et';

  @override
  String get contribute_share_content =>
      'Szerettem volna, ha tudsz az általam használt Open Food Facts nevű alkalmazásról, amely lehetővé teszi, hogy személyre szabott módon megismerd az ételek egészségügyi és környezeti hatásait. A csomagoláson található vonalkódok beolvasásával működik. Nem utolsó sorban ingyenes, nem igényel regisztrációt, és még segíthetsz is növelni a benne lévő termékek számát. Erről a linkről töltheted le a telefonodra: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Árak beküldése hűségkártyák GDPR-adatexportálási kérelmén keresztül';

  @override
  String get tap_to_answer => 'Koppintson a kérdések megválaszolásához';

  @override
  String get tap_to_answer_hint =>
      'Koppintson ide a termékkel kapcsolatos kérdések megválaszolásához';

  @override
  String get robotoff_questions_loading_hint =>
      'Várjon, amíg a termékkel kapcsolatos kérdések betöltődnek';

  @override
  String get saving_answer => 'Válasz mentése';

  @override
  String get contribute_to_get_rewards =>
      'Legyen szereplője az élelmiszer-átláthatóságnak';

  @override
  String get question_sign_in_text =>
      'Jelentkezzen be az OpenFoodFacts fiókjába, hogy az Ön nevéhez kapcsolódjanak a hozzájárulásai';

  @override
  String get question_yes_button_accessibility_value => 'Válasz igennel';

  @override
  String get question_no_button_accessibility_value => 'Válasz nemmel';

  @override
  String get question_skip_button_accessibility_value => 'Kérdés kihagyása';

  @override
  String get tap_to_edit_search => 'Koppintson a keresés szerkesztéséhez';

  @override
  String get myPreferences => 'Saját beállítások';

  @override
  String get account_create_message =>
      'Hozzon létre fiókot, és csatlakozzon az OpenFoodFacts közösséghez, segítve az élelmiszerekkel kapcsolatos ismeretek bővítésében az egész világon!';

  @override
  String get join_us => 'Csatlakozzon';

  @override
  String get myPreferences_profile_title => 'Profilom';

  @override
  String get myPreferences_profile_subtitle =>
      'Kezelje OpenFoodFacts-közreműködői fiókját.';

  @override
  String get myPreferences_settings_title => 'Alkalmazás beállításai';

  @override
  String get myPreferences_settings_subtitle => 'Sötét mód, nyelvek…';

  @override
  String get myPreferences_food_title => 'Élelmiszer-preferenciák';

  @override
  String get myPreferences_food_subtitle =>
      'Válassza ki, hogy mely élelmiszerekkel kapcsolatos információk a legfontosabbak az Ön számára.';

  @override
  String get myPreferences_food_comment =>
      'Válassza ki, hogy az élelmiszerekkel kapcsolatban mely információk a legfontosabbak az Ön számára, hogy az élelmiszereket a preferenciái szerint rangsorolja, az Ön számára fontos információkat lássa elsőként, és kapjon egy megfelelőségi összefoglalót. Ezek az élelmiszer-preferenciák az Ön készülékén maradnak, és nem kapcsolódnak az Open Food Facts közreműködői fiókjához, ha rendelkezik ilyennel.';

  @override
  String get confirmResetPreferences =>
      'Visszaállítja az élelmiszer-preferenciáit?';

  @override
  String get myPersonalizedRanking => 'Személyre szabott rendezés';

  @override
  String get ranking_tab_all => 'Összes';

  @override
  String get ranking_subtitle_match_yes => 'Kiváló egyezés Önnek';

  @override
  String get ranking_subtitle_match_no => 'Nagyon gyenge egyezés';

  @override
  String get ranking_subtitle_match_maybe => 'Ismeretlen egyezés';

  @override
  String get refresh_with_new_preferences =>
      'Frissítse a listát az új preferenciáival';

  @override
  String get reloaded_with_new_preferences =>
      'Újratöltve az új preferenciáival';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Leolvasás';

  @override
  String get history_navbar_label => 'Előzmények';

  @override
  String get list_navbar_label => 'Listák';

  @override
  String get category => 'Szűrés kategória szerint';

  @override
  String get category_all => 'Összes';

  @override
  String get category_search => '(kategória keresés)';

  @override
  String get filter => 'Szűrés';

  @override
  String get scan => 'Termékek a Leolvasás képernyőről';

  @override
  String get scan_history => 'Leolvasási előzmények';

  @override
  String get search => 'Keresés';

  @override
  String get search_product_help =>
      'Keressen egy terméket,\negy márkát vagy vonalkódot';

  @override
  String get search_filter => 'Keresési szűrő';

  @override
  String get search_history => 'Keresési előzmények';

  @override
  String get search_store => 'Üzlet keresése';

  @override
  String get search_store_help => 'Tipp: add meg a várost vagy az országot';

  @override
  String get tap_for_more => 'Koppintson a további információkért…';

  @override
  String get product => 'Termék';

  @override
  String get unknownBrand => 'Ismeretlen márka';

  @override
  String get unknownQuantity => 'Ismeretlen mennyiség';

  @override
  String get unknownProductName => 'Ismeretlen terméknév';

  @override
  String get label_refresh => 'Frissítés';

  @override
  String get label_reload => 'Újratöltés';

  @override
  String get image => 'Kép';

  @override
  String get front_photo => 'Fénykép szemből';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (ez a kép elavult lehet)';
  }

  @override
  String get outdated_image_short_label => 'elavult lehet';

  @override
  String get ingredients => 'Összetevők';

  @override
  String get ingredients_editing_instructions =>
      'Tartsa meg az eredeti sorrendet. Tüntesse fel a százalékos arányt, ha meg van adva. Az összetevőket vesszővel vagy kötőjellel válassza el, és egy összetevő összetevőihez használjon zárójelet.';

  @override
  String get ingredients_editing_error =>
      'Nem sikerült menteni az összetevőket.';

  @override
  String get ingredients_editing_image_error =>
      'Nem sikerült új összetevők fényképét beszerezni.';

  @override
  String get ingredients_editing_title => 'Összetevők szerkesztése';

  @override
  String get ingredients_photo => 'Összetevők fényképe';

  @override
  String get packaging_editing_instructions =>
      'Sorolja fel a csomagolás összes részét vesszővel vagy sortöréssel elválasztva, feltüntetve a mennyiségüket (pl. 1 vagy 6) típusukat (pl. palack, doboz, konzerv), anyagukat (pl. műanyag, fém, alumínium), és ha van, a méretüket (pl. 33cl), valamint az újrahasznosítási utasításokat.\nPéldául: 1 újrahasznosítható üvegpalack, 1 eldobható parafadugó';

  @override
  String get packaging_editing_error => 'Nem sikerült menteni a csomagolást.';

  @override
  String get packaging_editing_image_error =>
      'Nem sikerült új csomagolás fényképét beszerezni.';

  @override
  String get packaging_editing_title => 'Csomagolás szerkesztése';

  @override
  String get nutrition => 'Tápérték';

  @override
  String get nutrition_facts_photo => 'Tápértékadatok fényképe';

  @override
  String get nutrition_facts_editing_title => 'Tápértékadatok szerkesztése';

  @override
  String get packaging_information => 'Újrahasznosítási utasítások';

  @override
  String get packaging_information_photo =>
      'Újrahasznosítási utasítások fényképe';

  @override
  String get missing_product => 'Új terméket talált!';

  @override
  String get add_product_take_photos =>
      'Készítsen fotókat a csomagolásról, hogy hozzáadhassa a terméket a Open Food Factshez';

  @override
  String get add_product_take_photos_descriptive =>
      'Először készítsen néhány fényképet. A terméket később bármikor kiegészítheti.';

  @override
  String get add_product_information_button_label =>
      'Termékinformációk hozzáadása';

  @override
  String get new_product => 'Új termék';

  @override
  String get new_product_found_title => 'Új terméket találtál!';

  @override
  String get new_product_found_text =>
      'Együttműködésen alapuló adatbázisunk több mint **3 millió terméket** tartalmaz, de ez a vonalkód nincs benne: ';

  @override
  String get new_product_found_button => 'Termék hozzáadása';

  @override
  String get new_product_leave_title => 'Elhagyja az oldalt?';

  @override
  String get new_product_leave_message =>
      'Úgy tűnik, hogy nem adott meg semmit. Tényleg el akarja hagyni ezt az oldalt?';

  @override
  String get new_product_dialog_description =>
      'Készítsen fotókat a csomagolásról, hogy hozzáadhassa a terméket a közös adatbázisunkhoz';

  @override
  String get new_product_dialog_illustration_description =>
      'Ismeretlen Nutri-Score-t és Green Score-t ábrázoló illusztráció';

  @override
  String get front_packaging_photo_button_label =>
      'Csomagolás fényképe szemből';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Szembőli csomagolási fotó feltöltésének megerősítése';

  @override
  String get confirm_button_label => 'Megerősítés';

  @override
  String get send_image_button_label => 'Kép küldése';

  @override
  String get crop_page_action_saving => 'Kép mentése…';

  @override
  String get crop_page_action_cropping => 'Kép körbevágása…';

  @override
  String get crop_page_action_local => 'Helyi verzió mentése…';

  @override
  String get crop_page_action_local_failed_title =>
      'Hoppá… valami gond van a fotójával!';

  @override
  String get crop_page_action_local_failed_message =>
      'Nem tudjuk a képet helyben feldolgozni, mielőtt elküldenénk a szerverünkre. Próbálja meg később újra, vagy lépjen kapcsolatba velünk, ha a probléma továbbra is fennáll.';

  @override
  String get crop_page_action_retake => 'Újrafényképezés';

  @override
  String get crop_page_too_small_image_title => 'A fénykép túl kicsi!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Képfeltöltésnél a minimális méret ${expectedMinWidth}x$expectedMinHeight pixel. Az aktuális kép ${actualWidth}x$actualHeight pixeles.';
  }

  @override
  String get crop_page_action_server => 'A szerver hívásának előkészítése…';

  @override
  String get front_packaging_photo_title => 'Csomagolás fényképe szemből';

  @override
  String get ingredients_photo_title => 'Összetevők fényképe';

  @override
  String get nutritional_facts_photo_title => 'Tápértékadatok fényképe';

  @override
  String get recycling_photo_title => 'Újrahasznosítási utasítások Fotó';

  @override
  String get take_photo_title => 'Fénykép készítése';

  @override
  String get take_more_photo_title => 'Készítsen további képeket';

  @override
  String get front_photo_uploaded => 'Szemből készült kép feltöltve';

  @override
  String get ingredients_photo_button_label => 'Összetevők fényképe';

  @override
  String get ingredients_photo_uploaded => 'Összetevők fényképe feltöltve';

  @override
  String get nutrition_cache_loading_error =>
      'Nem sikerült a tápanyagokat betölteni gyorsítótárból';

  @override
  String get nutritional_facts_photo_button_label => 'Tápértékadatok fényképe';

  @override
  String get nutritional_facts_input_button_label => 'Tápértékadatok kitöltése';

  @override
  String get nutritional_facts_added => 'Hozzáadott tápértékadatok';

  @override
  String get categories_added => 'Hozzáadott kategóriák';

  @override
  String get new_product_title_nutriscore => 'Nutri-Score kiszámítása';

  @override
  String get new_product_subtitle_nutriscore =>
      'Segítsen nekünk legalább a kategória és tápértékek kitöltésével';

  @override
  String get new_product_title_environmental_score => 'Green Score kiszámítása';

  @override
  String get new_product_subtitle_environmental_score =>
      'Egy kategória kitöltésével megtudhatja';

  @override
  String get new_product_additional_environmental_score =>
      'Pontosabbá teheti a Green Score számítását a származás, a csomagolás és egyebek kitöltésével';

  @override
  String get new_product_title_nova =>
      'Élelmiszer-feldolgozási szint (NOVA) kiszámítása';

  @override
  String get new_product_subtitle_nova =>
      'Az élelmiszerkategória és az összetevők kitöltésével megtudhatja';

  @override
  String get new_product_desc_nova_unknown =>
      'Az élelmiszer-feldolgozottság szintje ismeretlen';

  @override
  String get new_product_title_pictures => 'Új termék';

  @override
  String get new_product_title_pictures_details =>
      'Please take the following photos and the Open Food Facts engine can work out the rest!';

  @override
  String get new_product_title_misc => 'És pár alapvető adat…';

  @override
  String new_product_done_msg(String username) {
    return 'Köszönjük a közreműködését, $username!';
  }

  @override
  String get new_product_done_msg_no_user => 'Köszönjük a közreműködést!';

  @override
  String get new_product_done_button_label =>
      'Tekintse meg az elkészült terméket';

  @override
  String get hey_incomplete_product_message =>
      'Válaszoljon meg 3 kérdést MOST a Nutri-Score, Green Score és a feldolgozottság (NOVA) kiszámításához!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Válaszoljon meg 2 kérdést, és segítsen elemezni ezt a kozmetikumot!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Válaszoljon meg 3 kérdést, és segítsen elemezni ezt az állateledelt!';

  @override
  String get hey_incomplete_product_message_product =>
      'Segítsen befejezni a terméket!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Tápértékadatok fényképe feltöltve';

  @override
  String get recycling_photo_button_label => 'Újrahasznosítási fénykép';

  @override
  String get recycling_photo_uploaded => 'Újrahasznosítási fénykép feltöltve';

  @override
  String get take_more_photo_button_label => 'Készítsen további képeket';

  @override
  String get other_photo_uploaded => 'További fénykép feltöltve';

  @override
  String get retake_photo_button_label => 'Új fotó';

  @override
  String get selecting_photo => 'Fénykép kiválasztása';

  @override
  String get uploading_image => 'Fénykép feltöltése a szerverre';

  @override
  String get uploading_image_type_front =>
      'Szemből készült kép feltöltése Open Food Factsre';

  @override
  String get uploading_image_type_ingredients =>
      'Összetevők képének feltöltése Open Food Factsre';

  @override
  String get uploading_image_type_nutrition =>
      'Tápérték kép feltöltése Open Food Factsre';

  @override
  String get uploading_image_type_packaging =>
      'Csomagolás képének feltöltése Open Food Factsre';

  @override
  String get uploading_image_type_other =>
      'További kép feltöltése Open Food Factsre';

  @override
  String get uploading_image_type_generic => 'Kép feltöltése Open Food Factsre';

  @override
  String get score_add_missing_ingredients => 'Hiányzó összetevők hozzáadása';

  @override
  String get score_add_missing_packaging_image =>
      'Hiányzó csomagolási kép hozzáadása';

  @override
  String get score_add_missing_nutrition_facts =>
      'Hiányzó tápértékadatok hozzáadása';

  @override
  String get score_add_missing_product_traces =>
      'Hiányzó összetevőnyom hozzáadása';

  @override
  String get score_add_missing_product_category => 'Kategória kiválasztása';

  @override
  String get score_add_missing_precise_product_category =>
      'Válasszon pontosabb kategóriát';

  @override
  String get score_add_missing_product_countries =>
      'Termék országainak pótlása';

  @override
  String get score_add_missing_product_emb => 'Hiányzó üzemkódok hozzáadása';

  @override
  String get score_add_missing_product_labels => 'Hiányzó címkék hozzáadása';

  @override
  String get score_add_missing_product_origins =>
      'Hiányzó származási helyek hozzáadása';

  @override
  String get score_add_missing_product_stores => 'Hiányzó boltok hozzáadása';

  @override
  String get score_add_missing_product_brands => 'Hiányzó márkák hozzáadása';

  @override
  String get score_update_nutrition_facts => 'Tápértékadatok frissítése';

  @override
  String get nutrition_page_title => 'Tápértékadatok';

  @override
  String get nutrition_page_nutritional_info_title => 'Tápanyag-információ';

  @override
  String get nutrition_page_nutritional_info_label =>
      'A terméken fel van tüntetve:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Igen';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Nem';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Fénykép megnyitása';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Jó tanácsok: tápanyag-információ';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Néha a tápértékadatok **nincsenek feltüntetve a csomagoláson** vagy a termékhez mellékelt papíron. Ebben az esetben és csakis ebben az esetben állítsa az értéket **NEM**-re.';

  @override
  String get nutrition_page_serving_type_label => 'Tápértékek:';

  @override
  String get nutrition_page_per_100g => '100g-ra';

  @override
  String get nutrition_page_per_100g_100ml => '100 g/ml-re vonatkozik';

  @override
  String get nutrition_page_per_serving => 'adagonként';

  @override
  String get nutrition_page_add_nutrient => 'Tápanyag hozzáadása';

  @override
  String get nutrition_page_serving_size => 'Adag';

  @override
  String get nutrition_page_serving_size_hint =>
      'Adj meg egy adag méretét (pl.: 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Jó tanácsok: adag';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Ez az érték segít **az egyes tápanyagok adagonkénti mennyiségének kiszámításában**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Használható mértékegységek**: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** vagy **60 G** (az első a javasolt)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** vagy **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Érvénytelen mértékegység';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Érvénytelen mértékegységek';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **cukorka** és 2 **keksz**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Hiányzó mértékegység';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Érvénytelen szám';

  @override
  String get nutrition_page_update_running => 'Termék frissítése a szerveren…';

  @override
  String get nutrition_page_update_done => 'A termék frissítve!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'A termék mennyiségének használata adagméretként';

  @override
  String get nutrition_page_photo_error => 'Nem sikerült betölteni a fényképet';

  @override
  String get more_photos => 'További érdekes képek';

  @override
  String get view_more_photo_button => 'Termék meglévő fotóinak megtekintése';

  @override
  String get no_product_found => 'Nem található termék';

  @override
  String get no_location_found => 'Hely nem található';

  @override
  String get not_found => 'nem található:';

  @override
  String get refreshing_product => 'Termék frissítése';

  @override
  String get product_refreshed => 'Termék frissítve';

  @override
  String product_image_accessibility_label(String date) {
    return 'Kép készítésének ideje: $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Kép készítésének ideje: $date. Ez a kép elavult lehet';
  }

  @override
  String get product_image_outdated => 'Ez a kép elavult lehet';

  @override
  String get product_image_outdated_explanations_title =>
      'Ez a kép elavult lehet';

  @override
  String get product_image_outdated_explanations_content =>
      'Ez a kép több mint egy éve készült.\n**Ellenőrizze, hogy még mindig naprakész-e**.\n\nEz **csak figyelmeztetés**. Ha a tartalom nem változott, figyelmen kívül hagyhatja ezt az üzenetet.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Fénykép lecserélése ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Fénykép készítése ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Új kép készítése';

  @override
  String get product_image_action_take_picture => 'Fénykép készítése';

  @override
  String get product_image_action_from_gallery =>
      'Választás a fényképgalériából';

  @override
  String get product_image_action_choose_existing_photo =>
      'Választás a termékfotók közül';

  @override
  String get product_image_details_label => 'Információk a fényképről';

  @override
  String get product_image_details_from_producer => 'A gyártótól';

  @override
  String get product_image_details_contributor => 'Hozzájáruló';

  @override
  String get product_image_details_contributor_producer =>
      'Közreműködő (gyártó)';

  @override
  String get product_image_details_date => 'Dátum';

  @override
  String get product_image_details_date_unknown => 'Ismeretlen';

  @override
  String get homepage_main_card_logo_description =>
      'Üdvözli az Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Olvasson le** egy vonalkódot vagy\n**keressen** rá egy termékre';

  @override
  String get homepage_main_card_search_field_hint => 'Termék keresése';

  @override
  String get homepage_main_card_search_field_tooltip => 'Keresés indítása';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Legfrissebb hírek: $news_title';
  }

  @override
  String get tagline_app_review => 'Tetszik az alkalmazás?';

  @override
  String get tagline_app_review_button_positive => 'Imádom! 😍';

  @override
  String get tagline_app_review_button_negative => 'Nem igazán…';

  @override
  String get tagline_app_review_button_later => 'Kérdezzen rá később';

  @override
  String get tagline_feed_news_button => 'Tudjon meg többet';

  @override
  String get app_review_negative_modal_title => 'Nem tetszik az alkalmazásunk?';

  @override
  String get app_review_negative_modal_text =>
      'Rászánna pár másodpercet, hogy elmondja nekünk, miért?';

  @override
  String get app_review_negative_modal_positive_button => 'Igen, feltétlenül!';

  @override
  String get app_review_negative_modal_negative_button => 'Nem';

  @override
  String get could_not_refresh => 'Nem sikerült frissíteni a terméket';

  @override
  String get product_internet_error_modal_title => 'Hiba történt.';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Hálózati hiba miatt nem tudtuk lekérni a termék adatait. Ellenőrizze internetkapcsolatát, és próbálja újra.\n\nBelső hiba:\n$error';
  }

  @override
  String get product_tags_title => 'Terméktulajdonságok';

  @override
  String get no_product_tags_found_message =>
      'Nem találtunk terméktulajdonságokat. A tulajdonságok rugalmasan használhatók a termékek részletesebb leírására. Érintse meg a hozzáadáshoz.';

  @override
  String get product_tags_empty => 'Nincsenek ingatlanok';

  @override
  String get product_tags_explanation =>
      'Tulajdonságok (kulcs/érték) hozzáadásával egy termékhez gazdagíthatod azt.';

  @override
  String get add_tag => 'Tulajdonság hozzáadása';

  @override
  String get add_tags => 'Tulajdonságok hozzáadása';

  @override
  String get add_edit_tags => 'Tulajdonságok hozzáadása vagy szerkesztése';

  @override
  String get edit_tag => 'Tulajdonság szerkesztése';

  @override
  String get remove_tag => 'Tulajdonság eltávolítása';

  @override
  String get tag_key => 'Tulajdonság';

  @override
  String get tag_keys => 'Tulajdonságok';

  @override
  String get tag_key_uneditable => 'Tulajdonság (nem szerkeszthető)';

  @override
  String get tag_key_input_hint => 'Adjon meg egy tulajdonságot';

  @override
  String get tag_value => 'Érték';

  @override
  String get tag_values => 'Értékek';

  @override
  String get tag_value_input_hint => 'Adjon meg egy értéket';

  @override
  String get tag_key_item => 'Tulajdonság:';

  @override
  String get tag_value_item => 'Érték:';

  @override
  String get tag_key_explanations =>
      'A kulcsnak kisbetűsnek kell lennie, szóközök nélkül.';

  @override
  String tag_key_already_exists(String property) {
    return 'Már van egy címke $property tulajdonsággal.';
  }

  @override
  String get product_internet_error =>
      'Hálózati hiba miatt nem lehet információkat lekérni erről a termékről.';

  @override
  String get cached_results_from => 'Ekkori eredmények megjelenítése:';

  @override
  String get product_search_same_category => 'Alternatívák keresése';

  @override
  String get product_search_same_category_short => 'Összehasonlít';

  @override
  String get product_search_same_category_error =>
      'Ez a funkció csak kategorizált termékeknél használható.\n\nKategória hozzáadásához szerkessze a terméket.';

  @override
  String get product_improvement_add_category =>
      'A Nutri-Score kiszámításához adjon hozzá egy kategóriát.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'A Nutri-Score kiszámításához adjon hozzá tápértékadatokat.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'A Nutri-Score kiszámításához adjon hozzá tápértékadatokat és egy kategóriát.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Ehhez a termékhez nem számítható ki a Nutri-Score, aminek oka lehet például egy nem szabványos kategória. Ha ez hibának tekinthető, kérjük, vegye fel velünk a kapcsolatot.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'A tápértékek képe elavult: kérjük frissítse.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'A Green Score figyelembe veszi az összetevők eredetét. Fényképezze le az összetevők listáját és/vagy bármilyen földrajzi állítást, vagy módosítsa a terméket úgy, hogy figyelembe lehessen venni azt.';

  @override
  String get country_chooser_label => 'Válasszon egy országot';

  @override
  String get currency_chooser_label => 'Válasszon egy pénznemet';

  @override
  String get country_change_message => 'Ön most módosította az országot.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Meg akarja változtatni a pénznemet erről: $previousCurrency erre: $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Válasszon egy országot:';

  @override
  String get country_chooser_label_from_settings => 'Az Ön országa';

  @override
  String get country_selection_explanation =>
      'Egyes környezeti jellemzők helyspecifikusak';

  @override
  String get product_removed_comparison =>
      'Termék eltávolítva az összehasonlításból';

  @override
  String get native_app_settings => 'Alkalmazás rendszerbeállításai';

  @override
  String get native_app_description =>
      'A rendszer Open Food Factsre vonatkozó beállításainak megnyitása';

  @override
  String get product_removed_history => 'Termék eltávolítva az előzményekből';

  @override
  String get product_removed_list => 'Termék eltávolítva a listáról';

  @override
  String get product_could_not_remove => 'Nem sikerült eltávolítani a terméket';

  @override
  String get no_prodcut_in_list => 'Nincs termék ezen a listán';

  @override
  String get no_product_in_section => 'Nincs termék ebben a szekcióban';

  @override
  String get recently_seen_products => 'Összes megtekintett termék';

  @override
  String get clear => 'Törlés';

  @override
  String get clear_long => 'Lista kiürítése';

  @override
  String get really_clear => 'Valóban törölni szeretné ezt a listát?';

  @override
  String pct_match(Object percent) {
    return '$percent% egyezés';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count napja',
      one: 'egy napja',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count órája',
      one: 'órája',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count perce',
      one: 'one minute ago',
      zero: 'kevesebb mint egy perce',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hónapja',
      one: 'egy hónapja',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hete',
      one: 'egy hete',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count termék összehasonlítása',
      one: 'Egy termék összehasonlítása',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kiválasztott termék',
      one: 'Egy kiválasztott termék',
      zero: 'Nincs kiválasztott termék',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Kiválasztott termékek összehasonlítása';

  @override
  String get delete_products_mode => 'Kiválasztott termékek törlése';

  @override
  String get select_all_products_mode => 'Összes termék kiválasztása';

  @override
  String get select_none_products_mode => 'Kiválasztás megszűntetése';

  @override
  String get compare_products_appbar_title => 'Termékek összehasonlítása';

  @override
  String get compare_products_appbar_subtitle =>
      'Válasszon ki legalább két terméket';

  @override
  String get retry_button_label => 'Újra';

  @override
  String get connect_with_us => 'Lépjen kapcsolatba velünk';

  @override
  String get tiktok => 'Kövess minket TikTokon';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Kövessen minket Instagramon';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Kövessen minket X-en (korábban Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Kövess minket a Mastodonon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Kövess minket a BlueSky-on';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'GYIK';

  @override
  String get discover => 'Felfedezés';

  @override
  String get how_to_contribute => 'Hogyan járulhat hozzá';

  @override
  String get hint_knowledge_panel_message =>
      'A kártya bármelyik részére koppintva további részleteket tudhat meg a látottakról. Próbálja ki most!';

  @override
  String get permissions_page_title => 'Hozzáférés a kamerához';

  @override
  String get permissions_page_body1 =>
      'Ha vonalkódokat szeretne leolvasni a telefon kamerájával, engedélyezze a hozzáférést.';

  @override
  String get permissions_page_body2 =>
      'Ha meggondolná magát, ez az opció bármikor engedélyezhető vagy letiltható a beállításokban.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Kiadás: $release)\nModell: $model\nTermék: $product\nKészülék: $device\nMárka:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModell: $model\nLokalizált modell: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nApp verziója:$appVersion\nApp build száma:$appBuildNumber\nApp csomagneve:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Engedélyezés';

  @override
  String get refuse_button_label => 'Visszautasítás';

  @override
  String get ask_me_later_button_label => 'Később';

  @override
  String get are_you_sure => 'Biztos benne?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'További információk: $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Üdvözlünk!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Az alkalmazás, ami segít olyan élelmiszert választani, ami jó **Önnek** és a **bolygónak**!';

  @override
  String get onboarding_continue_button => 'Folytatás';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Az első példa termék betöltése';

  @override
  String get onboarding_welcome_warning =>
      'Sajnálom, ez a példatermékünk, nem szerkeszthető :)';

  @override
  String get product_list_your_ranking => 'Az Ön helyezése';

  @override
  String get product_list_empty_icon_desc => 'Az előzmények nem érhetőek el';

  @override
  String get product_list_empty_title => 'Leolvasás indítása';

  @override
  String get product_list_empty_message =>
      'A leolvasott termékek itt fognak megjelenni, amelyekről részletes információkat olvashat';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Termékek',
      one: 'Termék',
      zero: 'Termék',
    );
    return '$_temp0 frissítése az előzményekben';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'A termékek',
      one: 'A termék',
      zero: 'A termék',
    );
    return '$_temp0 frissítése befejeződött';
  }

  @override
  String get product_list_compare_side_by_side =>
      'Hasonlítsa össze egymás mellett';

  @override
  String get loading_dialog_default_title => 'Adatok letöltése';

  @override
  String get loading_dialog_default_error_message =>
      'Nem sikerült letölteni az adatokat';

  @override
  String get account_delete => 'Fiók törlése';

  @override
  String get account_delete_title => 'Fiókom törlése';

  @override
  String get user_profile => 'Fiók';

  @override
  String get user_profile_title_guest => 'Üdvözlünk!';

  @override
  String get user_profile_subtitle_guest =>
      'Jelentkezzen be vagy regisztráljon, és csatlakozzon az Open Food Facts közösséghez';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts bejelentkezés: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Üdvözlünk, $id!';
  }

  @override
  String get email_subject_account_deletion => 'Fiók törlése';

  @override
  String email_body_account_deletion(String userId) {
    return 'Üdvözlöm, kérem, törölje Open Food Facts fiókomat: $userId';
  }

  @override
  String get settings_app_app => 'Alkalmazás';

  @override
  String get settings_app_data => 'Adatvédelem és megfigyelés';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Termékek';

  @override
  String get settings_app_miscellaneous => 'Egyéb';

  @override
  String get camera_play_sound_title => 'Hang lejátszása leolvasáskor';

  @override
  String get camera_play_sound_subtitle =>
      'Csippan egyet minden sikeres leolvasásnál';

  @override
  String get camera_window_accessibility_label =>
      'Olvasson le egy vonalkódot a kamerával';

  @override
  String get app_haptic_feedback_title => 'Rezgés és tapintás';

  @override
  String get app_haptic_feedback_subtitle =>
      'Rezgés bizonyos műveletek végrehajtása után (vonalkód dekódolva, termék eltávolítva…).';

  @override
  String get crash_reporting_toggle_title => 'Összeomlási jelentés';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Ha engedélyezve van, a rendszer automatikusan elküldi az összeomlási jelentéseket az Open Food Facts hibakövető rendszerébe, így a hibák kijavíthatók, és ezáltal fejlődik az alkalmazás.';

  @override
  String get send_anonymous_data_toggle_title => 'Névtelen adatok küldése';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Ha engedélyezve van, az alkalmazás használatával kapcsolatban néhány névtelen információt elküldünk az Open Food Facts szerverekre, hogy megértsük, hogyan és mennyi funkciót használ, azok fejlesztése céljából.';

  @override
  String get product_edit_photo_title => 'Fénykép szerkesztése';

  @override
  String get permission_photo_error => 'Hiba';

  @override
  String get permission_photo_denied_title =>
      'Lehetővé teszi a kamera használatát vonalkódok leolvasásához';

  @override
  String permission_photo_denied_message(String appName) {
    return 'A jobb élmény érdekében engedélyezze, hogy az $appName hozzáférjen a kamerához. Így közvetlenül le tudja majd olvasni a vonalkódokat.';
  }

  @override
  String get permission_photo_denied_button => 'Engedélyezés';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Engedély megtagadva';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Mivel korábban megtagadta a kamera engedélyét, manuálisan kell engedélyeznie azt a Beállításokban.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Beállítások megnyitása';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Mégse';

  @override
  String get permission_photo_none_found => 'Nem található kamera';

  @override
  String get permission_photo_denied => 'Nincs kamera hozzáférés engedélyezve';

  @override
  String get show_product_pictures => 'Termékfotók megjelenítése';

  @override
  String get edit_product_label => 'Termék szerkesztése';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Szerkesztések feltöltése…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Szerkesztéseit a rendszer **a háttérben küldi el** (hiba esetén később).\nFolytathatja a termék többi mezőjének szerkesztését.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Szerkesztéseit az alkalmazás **a háttérben küldi el** (hiba esetén később).';

  @override
  String get edit_product_label_short => 'Szerkesztés';

  @override
  String edit_product_form_item_help(String value) {
    return 'Hogyan kell ezt megadni: „$value”?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Egy nem üres értéket adjon meg!';

  @override
  String get edit_product_form_item_error_existing =>
      'Ez az érték már meg van adva!';

  @override
  String get edit_product_form_item_add_action_brand => 'Új márka hozzáadása';

  @override
  String get edit_product_form_item_add_action_label => 'Új címke hozzáadása';

  @override
  String get edit_product_form_item_add_action_store => 'Új üzlet hozzáadása';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Új származási hely hozzáadása';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Új üzemkód hozzáadása';

  @override
  String get edit_product_form_item_add_action_country =>
      'Új ország hozzáadása';

  @override
  String get edit_product_form_item_add_action_category =>
      'Új kategória hozzáadása';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Összetevőnyom hozzáadása';

  @override
  String get edit_product_form_item_add_suggestion => 'Javaslat hozzáadása';

  @override
  String get edit_product_form_item_deny_suggestion => 'Javaslat elutasítása';

  @override
  String get edit_product_form_item_details_title => 'Alapadatok';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Termék neve, márka, mennyiség';

  @override
  String get edit_product_form_item_other_details_title => 'További adatok';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Weboldal…';

  @override
  String get edit_product_form_item_photos_title => 'Fényképek';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Fényképek hozzáadása vagy frissítése';

  @override
  String get edit_product_form_item_labels_title => 'Címkék és tanúsítványok';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Környezetvédelmi, minőségi címkék…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Adjon meg egy címkét (pl. NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'címke';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Jó tanácsok: címkék';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'A termék bármely jellemzője **amely tényszerű** és eltér a többi mezőtől.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Belgiumban gyártott, Olaszországban készült…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rostban gazdag, vasforrás…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fair trade, Zöld Pont…';

  @override
  String get edit_product_form_item_stores_title => 'Boltok';

  @override
  String get edit_product_form_item_stores_hint => 'Adjon meg egy boltot';

  @override
  String get edit_product_form_item_stores_type => 'bolt';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Jó tanácsok: üzletek';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Adja meg az üzletet, ahol a terméket vásárolta.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Aldi';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Auchan';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Származás';

  @override
  String get edit_product_form_item_origins_hint =>
      'Adjon meg egy származási helyet (pl.: Németország)';

  @override
  String get edit_product_form_item_origins_type => 'ország';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Jó tanácsok: származás';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Adjon hozzá **minden, a csomagoláson található eredetmegjelölést**.\nNe foglalkozzon a közvetlenül az összetevők között feltüntetett származásokkal.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'A marhahús Argentínából származik';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'A szója nem az Európai Unióból származik';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Adjon meg egy országot (pl.: Németország)';

  @override
  String get edit_product_form_item_countries_type => 'ország';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Jó tanácsok: országok';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Azon országok, ahol a termék széles körben kapható** (nem csak importárura specializálódott boltokban).';

  @override
  String get edit_product_form_item_emb_codes_title =>
      'Származási kód (EK-üzemkód)';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Adjon meg egy kódot (pl: HU 123 EK, EMB 53062, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'származási kód';

  @override
  String get edit_product_form_item_emb_help_title => 'Jó tanácsok: üzemkódok';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Ebben a részben a **csomagolási jelölésekkel**, **azonosítójelekkel** vagy **egészségügyi jelölésekkel** kapcsolatos kódokat adhat meg.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Példák nyomon követhetőségi kódokra';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      'Az **EK-kódokat** (külföldön általában EC) az Európai Unióban használják az élelmiszergyártók vagy csomagolók azonosítására:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: **Franciaország** országkódja\n**72.264.002**: földrajzi azonosító\n**CE** vagy **EK**: Európai Közösség';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      'Franciaországban használt **EMB kódok**:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Nyomokban';

  @override
  String get edit_product_form_item_traces_hint => 'nyom';

  @override
  String get edit_product_form_item_traces_type =>
      'Összetevőnyom megadása (pl. szója)';

  @override
  String get edit_product_form_item_categories_title => 'Kategóriák';

  @override
  String get edit_product_form_item_categories_hint => 'kategória';

  @override
  String get edit_product_form_item_categories_type =>
      'Adjon meg egy kategóriát (pl.: narancslé)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Jó tanácsok: kategóriák';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      '**Csak a legszűkebb alkategóriát** adja meg.\nA szülőkategóriák automatikusan hozzá lesznek adva.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Hiányzik egy kategória?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Ha egy kategóriát **nem kínál fel az automatikus kiegészítés**, nyugodtan adja hozzá.\nEz segít nekünk az Open Food Facts fejlesztésében az Ön országában.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Szardínia olívaolajban';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Narancslé koncentrátumból';

  @override
  String get edit_product_form_item_exit_title => 'Kilép mentés nélkül?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Szeretné menteni a változtatásokat, mielőtt elhagyja ezt az oldalt?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Módosítások mentése';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Módosítások elvetése';

  @override
  String get edit_product_form_item_ingredients_title => 'Összetevők';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Nagyítás és kicsinyítés a képernyő összecsípésével';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'A fénykép nagyítása és kicsinyítése';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'A **Csippentős nagyítás kézmozdulattal** nagyíthatja vagy kicsinyítheti a fényképet:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Hozzáadás';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Először írjon be egy szöveget';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Eltávolítás';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Szerkesztések mentése';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Szerkesztések törlése';

  @override
  String get edit_product_form_item_packaging_title =>
      'Újrahasznosítási utasítások fényképe';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Tápértékadatok';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Tápanyagok, alkoholtartalom…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Jó tanácsok: tápértékadatok';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Táplálkozási értékek';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Először válassza ki, hogy **mire vonatkoznak az értékek**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Tápértékadatok';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Ezután adja meg a tápértéket **a csomagoláson feltüntetettek szerint**. Ahol nincs érték, kattintson a „Szem” ikonra.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Hiányzik egy mező?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Ha egy adathoz hiányzik a mező, a hozzáadásához **kattintson a „Plusz” ikonra** (pl.: D-vitamin, magnézium…).';

  @override
  String get edit_product_form_save => 'Szerkesztés';

  @override
  String get edit_product_ingredients_photo_title => 'Összetevők fényképe';

  @override
  String get edit_product_ingredients_list_title => 'Összetevők listája';

  @override
  String get edit_product_packaging_photo_title => 'Csomagolás fényképe';

  @override
  String get edit_product_packaging_list_title => 'Csomagolóanyagok listája';

  @override
  String get no_data_available => 'Nincs elérhető adat';

  @override
  String get product_field_website_title => 'Weboldal';

  @override
  String get origins_editing_title => 'Származási helyek szerkesztése';

  @override
  String get completed_basic_details_btn_text => 'Alapvető adatok kitöltés';

  @override
  String get not_implemented_snackbar_text => 'Még nincs implementálva';

  @override
  String get category_picker_page_appbar_text => 'Kategóriák';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Összetevők kinyerése a fényképről';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Összetevők kiolvasása';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Összetevők kinyerése\na fényképről';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Fénykép betöltése…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Miért látom ezt az üzenetet?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Az „Összetevők kinyerése” funkció használatához először fel kell tölteni a fényképet.\n\nKérjük, várjon néhány másodpercet, vagy írja be kézzel.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Fénykép frissítése';

  @override
  String get edit_packaging_extract_btn_text =>
      'Csomagolás kinyerése\na fényképről';

  @override
  String get edit_packaging_extract_btn_text_short =>
      'Csomagolási adatok kinyerése';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Csomagolás kinyerése a fényképről';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Fénykép betöltése…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Miért látom ezt az üzenetet?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'A „Csomagolás kinyerése” funkció használatához először fel kell tölteni a fényképet.\n\nKérjük, várjon néhány másodpercet, vagy írja be kézzel.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Fénykép frissítése';

  @override
  String get edit_ocr_extract_failed =>
      'Nem sikerült felismerni a szöveget a képen.';

  @override
  String get edit_ocr_extract_disabled_title => 'Nincs kép!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'A szövegkinyerés funkció használatához először fényképet kell készítenie.';

  @override
  String get user_list_dialog_new_title => 'Új terméklista';

  @override
  String get user_list_dialog_rename_title => 'Lista átnevezése';

  @override
  String get user_list_subtitle_product => 'Listák';

  @override
  String get user_list_title => 'A listája';

  @override
  String get user_list_add_product => 'Termék listához adása';

  @override
  String get user_list_button_new => 'Új lista létrehozása';

  @override
  String get user_list_empty_label =>
      'Még nincs elérhető lista!\nKezdje azzal, hogy létrehoz egyet.';

  @override
  String get user_list_button_add_product => 'Listához adás';

  @override
  String get added_to_list_msg => 'Hozzáadva a listához';

  @override
  String get user_list_popup_clear => 'Előzmények törlése';

  @override
  String get user_list_popup_rename => 'Átnevezés';

  @override
  String get user_list_name_hint => 'Listám';

  @override
  String get user_list_name_error_empty => 'Név megadása kötelező';

  @override
  String get user_list_name_error_already => 'Ez a név már használatban van';

  @override
  String get user_list_name_error_same => 'Ez ugyanaz a név';

  @override
  String get user_list_name_input_hint => 'Lista neve';

  @override
  String get try_again => 'Újrapróbálkozás';

  @override
  String get there_was_an_error => 'Hiba történt';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Nem található kategória a következőhöz: $items';
  }

  @override
  String get camera_toggle_camera =>
      'Váltás a hátsó és az elülső kamera között';

  @override
  String get camera_toggle_flash =>
      'Vényképező vakujának BE vagy KI kapcsolása';

  @override
  String get camera_enable_flash => 'Vaku bekapcsolása';

  @override
  String get camera_disable_flash => 'Vaku kikapcsolása';

  @override
  String get camera_flash_error_dialog_title => 'Hiba történt!';

  @override
  String get camera_flash_error_dialog_message =>
      'Hiba történt a vaku állapotának módosításakor. Győződjön meg arról, hogy okostelefonján nincs bekapcsolva a zseblámpa.';

  @override
  String get category_picker_no_category_found_button => 'Vissza';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Kattintson a megnyitáshoz a böngészőben vagy az alkalmazásban (ha telepítve van)';

  @override
  String get dev_preferences_screen_title => 'Fejlesztői mód';

  @override
  String get dev_preferences_screen_subtitle =>
      'Hozzáférés kísérleti funkciókhoz és fejlesztőeszközökhöz';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Bemutatkozás újrakezdése';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Ezután újra kell indítania az alkalmazást, hogy újra láthassa.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Váltás az openfoodfacts.org (PROD) és a tesztkörnyezet között';

  @override
  String get dev_preferences_test_environment_title =>
      'Tesztkörnyezet paraméterei';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Az aktuális tesztkörnyezet base URL-je: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Tesztkörnyezet gépneve';

  @override
  String get dev_preferences_ml_kit_title => 'ML Kit használata';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'ezután újra kell indítania az alkalmazást';

  @override
  String get dev_preferences_product_additional_features_title =>
      'További gomb a termékoldalon';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Összetevők szerkesztése a tudnivalók panel gombjával';

  @override
  String get dev_preferences_export_history_title => 'Előzmények exportálása';

  @override
  String get dev_preferences_export_history_progress_error => 'kivétel';

  @override
  String get dev_preferences_export_history_progress_found =>
      'megtalált termék';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'NEM található termék';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Előzmények exportálása';

  @override
  String get dev_preferences_button_positive => 'Ok';

  @override
  String get dev_preferences_button_negative => 'Mégse';

  @override
  String get dev_preferences_migration_title => 'Adatmigráció V1-ről';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Állapot: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'sikeres vagy friss telepítés';

  @override
  String get dev_preferences_migration_status_success => 'sikeres';

  @override
  String get dev_preferences_migration_status_error => 'hiba';

  @override
  String get dev_preferences_migration_status_in_progress => 'folyamatban';

  @override
  String get dev_preferences_migration_status_required =>
      'kötelező (kattintson az indításhoz)';

  @override
  String get dev_preferences_migration_status_not_started => 'ismeretlen';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Törli az előzményeket, és 3 terméket tesz bele';

  @override
  String get dev_preferences_news_custom_url_title => 'Egyéni URL a hírekhez';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'A JSON-fájl URL-je:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Nincs beállítva';

  @override
  String get dev_preferences_news_provider_status_title => 'Állapot';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Utolsó frissítés: $date';
  }

  @override
  String get product_type_label_food => 'Élelmiszer';

  @override
  String get product_type_label_beauty => 'Testápolás';

  @override
  String get product_type_label_pet_food => 'Állateledel';

  @override
  String get product_type_label_product => 'Egyéb';

  @override
  String get product_type_selection_title => 'Terméktípus';

  @override
  String get product_type_selection_subtitle => 'Válassza ki a termék típusát';

  @override
  String get product_type_selection_empty =>
      'Először ki kell választania a termék típusát!';

  @override
  String product_type_selection_already(String productType) {
    return 'Nem módosíthatja a termék típusát ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Árak alkalmazásra mutató gomb a termékoldalon';

  @override
  String get prices_app_button => 'Tovább az Árak appba';

  @override
  String get prices_website_button => 'Nyitva az Open Prices weboldalon';

  @override
  String get prices_bulk_proof_upload_select =>
      'Árcédulák hozzáadása a galériából';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Miután kiválasztotta a képeket, nem fogja tudni szerkeszteni őket!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Lehetővé teszi a közösség számára a mesterséges intelligencia által kinyert árak validálását.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Több árcédula';

  @override
  String get prices_bulk_proof_upload_title => 'Tömeges bizonylatfeltöltés';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Fájlok kiválasztása';

  @override
  String get prices_bulk_proof_upload_step_starting => 'A feltöltés indítása';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Fájl helyi másolása #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Feltöltés előkészítése #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Hiba a következő képnél: #$index/$count';
  }

  @override
  String get prices_generic_title => 'Árak';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ár hozzáadása',
      one: 'Ár hozzáadása',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ár beküldése',
      one: 'Ár beküldése',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Tétel hozzáadása';

  @override
  String get prices_add_a_price => 'Ár hozzáadása';

  @override
  String get prices_add_a_receipt => 'Nyugta hozzáadása';

  @override
  String get prices_add_price_tags => 'Árcédulák hozzáadása';

  @override
  String prices_barcode_already(String barcode) {
    return 'Ez a vonalkód ($barcode) már rajta van a listán!';
  }

  @override
  String get prices_barcode_search_not_found => 'A termék nem található';

  @override
  String get prices_barcode_search_none_yet => 'Még nincs termék';

  @override
  String prices_barcode_search_running(String barcode) {
    return '$barcode keresése';
  }

  @override
  String get prices_barcode_enter => 'Vonalkód beírása';

  @override
  String get prices_category_enter => 'Vonalkód nélküli tétel';

  @override
  String get prices_per_kilogram => 'Kilogrammonkénti ár';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / egység';

  @override
  String get prices_category_mandatory => 'Kötelező';

  @override
  String get prices_category_optional => 'Választható';

  @override
  String get prices_category_error_mandatory =>
      'A kategória kitöltése kötelező';

  @override
  String get prices_barcode_reader_action => 'Vonalkódolvasó';

  @override
  String get prices_view_prices => 'Árak megtekintése';

  @override
  String get prices_list_title => 'Árlista';

  @override
  String get prices_list_count => '\nár száma';

  @override
  String get prices_list_add_new_price => 'Adj hozzá\núj árat';

  @override
  String get prices_list_empty_title => 'Még nincs ár!';

  @override
  String get prices_list_empty_subtitle =>
      'Légy az első, aki hozzáad egyet:\n**Blokk** vagy **árcédula** beolvasásával!';

  @override
  String get prices_entry_shop_not_found => 'Ismeretlen üzlet';

  @override
  String prices_entry_menu_title(String user) {
    return 'Ár megadása \"$user\"-tól';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Tekintse meg a termék összes árát';

  @override
  String get prices_entry_menu_open_proof => 'Nézetbizonyítás';

  @override
  String get prices_entry_menu_my_prices => 'Tekintse meg további áraimat';

  @override
  String get prices_entry_menu_author_prices =>
      'Tekintse meg a szerző további árait';

  @override
  String get prices_entry_menu_shop_prices =>
      'Tekintse meg az üzlet további árait';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ár',
      one: '1 ár',
    );
    return '$_temp0 ehhez: $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ár',
      one: 'Csak egy ár',
      zero: 'Még nincs ár',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Legújabb $pageSize ár (összesen: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Ár: $price / Bolt: \"$location\" / Hozzáadva $date, „$user” által';
  }

  @override
  String prices_open_user_proofs(String user) {
    return '„$user” bizonylatainak megnyitása';
  }

  @override
  String get prices_open_proof => 'Bizonylat megnyitása';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bizonylat',
      one: 'Csak egy bizonylat',
      zero: 'Még nincs bizonylat',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Legújabb $pageSize bizonylat (összesen: $total)';
  }

  @override
  String get prices_users_empty_title => 'Még nincs közreműködő!';

  @override
  String get prices_users_empty_explanation =>
      'Légy az első, aki árat ad hozzá!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize közreműködő (összes: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Még nincs bolt!';

  @override
  String get prices_locations_empty_explanation =>
      'Légy az első, aki árat ad hozzá!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Legnépszerűbb $pageSize hely (összesen: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bizonylat',
      one: 'Egy bizonylat',
      zero: 'Nincsenek bizonylatok',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count termék',
      one: 'Egy termék',
      zero: 'Nincsenek termékek',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count felhasználó',
      one: 'Egy felhasználó',
      zero: '0 felhasználó',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ár',
      one: 'Egy ár',
      zero: 'Nincsenek árak',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Korábban hozzáadott ár';

  @override
  String get prices_amount_subtitle => 'Mennyiség';

  @override
  String get prices_amount_is_discounted => 'Akciós?';

  @override
  String get prices_amount_price_normal => 'Ár';

  @override
  String get prices_amount_price_discounted => 'Akciós ár';

  @override
  String get prices_amount_price_not_discounted => 'Eredeti ár';

  @override
  String get prices_amount_no_product => 'Egy termék hiányzik!';

  @override
  String get prices_amount_price_incorrect => 'Hibás érték';

  @override
  String get prices_amount_price_mandatory => 'Kötelező érték';

  @override
  String get prices_currency_subtitle => 'Pénznem';

  @override
  String get prices_date_subtitle => 'Dátum';

  @override
  String get prices_location_subtitle => 'Bolt';

  @override
  String get prices_location_find => 'Bolt keresése';

  @override
  String get prices_location_mandatory => 'Ki kell választani egy boltot!';

  @override
  String get prices_location_search_broader =>
      'Nem találta, amit keresett? Próbáljunk meg egy átfogóbb keresést!';

  @override
  String get prices_proof_subtitle => 'Bizonylat';

  @override
  String get prices_proof_empty_title => 'Még nincs bizonyíték!';

  @override
  String get prices_proof_empty_explanation =>
      'Kezdd egy **nyugta** vagy egy **árcédula** fotójának hozzáadásával!';

  @override
  String get prices_proof_find => 'Bizonylat kiválasztása';

  @override
  String get prices_proof_change => 'Változásbizonyítás';

  @override
  String get prices_proof_receipt => 'Nyugta';

  @override
  String get prices_proof_price_tag => 'Árcédula';

  @override
  String get prices_proof_mandatory => 'Ki kell választani egy bizonylatot!';

  @override
  String get prices_add_validation_error => 'Érvényesítési hiba';

  @override
  String get prices_privacy_warning_title => 'Adatvédelmi figyelmeztetés';

  @override
  String get prices_unknown_product => 'Ismeretlen termék';

  @override
  String get prices_privacy_warning_main_message =>
      'Az árak **nyilvánosak lesznek** a hivatkozott üzlettel együtt.\n\nEz lehetővé teheti azoknak, akik ismerik az ön Open Food Facts felhasználónevét, hogy:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Megállapítsák, ön merre felé él';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Megtudják, hogy mit vásárol';

  @override
  String get prices_privacy_warning_sub_message =>
      'Ha ez nyugtalanítja, változtassa meg felhasználónevét, vagy hozzon létre egy új Open Food Facts fiókot, és jelentkezzen be vele az alkalmazásba.';

  @override
  String get i_refuse => 'Elutasítom';

  @override
  String get i_accept => 'Elfogadom';

  @override
  String get prices_currency_change_proposal_title => 'Módosítja a pénznemet?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Jelenlegi pénzneme **$currency**. Szeretné módosítani a következőre: **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Igen, váltás erre: $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nem, maradjon $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Kész';

  @override
  String get dev_mode_section_server => 'Szerver beállításai';

  @override
  String get dev_mode_section_news => 'Hírszolgáltató konfigurációja';

  @override
  String get dev_mode_section_product_page => 'Termékoldal';

  @override
  String get dev_mode_section_ui => 'Felhasználói felület';

  @override
  String get dev_mode_section_experimental_features => 'Kísérleti funkciók';

  @override
  String get dev_mode_hide_environmental_score_title => 'Green Score kizárása';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Helyesírás-ellenőrző használata az OCR-képernyőkön';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(összetevők és csomagolás)';

  @override
  String get dev_mode_reset_app_language_title =>
      'Alkalmazás nyelvének visszaállítása';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Kártyák hozzáadása';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Váltás a prices.openfoodfacts.org (PROD) és a test env között';

  @override
  String get search_history_item_edit_tooltip =>
      'Használja újra és szerkessze ezt a keresést';

  @override
  String get search_history_item_remove_tooltip => 'Eltávolítás';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Letöltötte mind a(z) $totalSize terméket.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'További $count termék letöltése\n $downloaded már letöltve ennyiből: $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return '$search keresése folyamatban van.\n\nVárjon pár másodpercet…';
  }

  @override
  String get user_search_contributor_title => 'Általam hozzáadott termékek';

  @override
  String get user_search_informer_title => 'Általam szerkesztett termékek';

  @override
  String get user_search_photographer_title => 'Általam fényképezett termékek';

  @override
  String get user_search_to_be_completed_title => 'Befejezendő termékeim';

  @override
  String get user_search_prices_title => 'Áraim';

  @override
  String get user_search_proofs_title => 'Bizonylataim';

  @override
  String get user_search_proof_title => 'Bizonylataim';

  @override
  String search_proof_title(String user) {
    return 'Bizonyítás a \"$user\"-ból';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Közreműködői árak: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Legutóbb hozzáadott árak';

  @override
  String get all_search_prices_top_user_title => 'Top ár közreműködők';

  @override
  String get all_search_prices_top_location_title =>
      'Legtöbb árral rendelkező boltok';

  @override
  String get prices_contribution_assistant => 'Árhozzájárulási asszisztens';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system =>
      'Több bizonylat hozzáadása';

  @override
  String get all_search_prices_top_location_single_title => 'Bolti árak';

  @override
  String get all_search_prices_top_product_title =>
      'Legtöbb árral rendelkező termékek';

  @override
  String get all_search_to_be_completed_title => 'Összes befejezendő termék';

  @override
  String get categorize_products_country_title =>
      'Segítsen kategorizálni a termékeket az Ön országában';

  @override
  String get edit_product_action_retake_picture => 'Újrafényképezés';

  @override
  String get edit_product_action_take_picture => 'Fénykép készítése';

  @override
  String get edit_product_action_confirm => 'Megerősítés';

  @override
  String get signup_page_terms_of_use_line1 => 'Elfogadom az Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'felhasználási és hozzájárulási feltételeivel';

  @override
  String get analytics_consent_image_semantic_label => 'Analytics ikon';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Végzetes hiba: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Végzetes hiba: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Alapvető adatok kitöltés';

  @override
  String get edit_photo_button_label => 'Szerkesztés';

  @override
  String get edit_photo_unselect_button_label => 'Fotó kijelölésének törlése';

  @override
  String get edit_photo_select_existing_button_label =>
      'Meglévő kép kiválasztása';

  @override
  String get edit_photo_select_existing_all_label => 'A termék meglévő képei';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Válasszon ki egy képet a rákattintással';

  @override
  String get edit_photo_select_existing_download_label =>
      'Meglévő képek lekérése…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Nincsenek ehhez a termékhez kapcsolódóan korábban feltöltött képek.';

  @override
  String get edit_photo_language_not_this_one => 'Még nincs kép ezen a nyelven';

  @override
  String get edit_photo_language_none => 'Még nincsen kép';

  @override
  String get category_picker_screen_title => 'Kategóriák';

  @override
  String get basic_details => 'Alapadatok';

  @override
  String get product_name => 'Termék neve';

  @override
  String get product_names => 'Terméknevek';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Új fordítás hozzáadása';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Csak akkor adjon hozzá fordítást, **ha a nyelv szerepel valahol a csomagoláson**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Elülső oldal fényképének megtekintése';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Fénykép készítése szemből';

  @override
  String get add_basic_details_product_name_hint =>
      'Adja meg a termék nevét (pl.: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Módosítsa az alapértelmezett nyelvet?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Szeretné, hogy a termék alapértelmezett nyelve a következő legyen: \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Jó példák';

  @override
  String get explanation_section_bad_examples => 'Rossz példák';

  @override
  String get add_basic_details_product_name_help_title =>
      'Jó tanácsok: terméknév';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'A termék neve a **a csomagolásra nyomtatott fő név**. Ez lehet bejegyzett védjegy.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Megjegyzés:** Kérjük, ne fordítsa le, **ha a nyelv nem szerepel a csomagoláson**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 => 'Ketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'A névben ne szerepeljen a márka';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      '** Heinz** Ketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Ne használjon ®, ™, © vagy hasonló szimbólumokat';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count további fordítás',
      one: '$count további fordítás',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Márkanév';

  @override
  String get brand_names => 'Márkanevek';

  @override
  String get add_basic_details_brand_name_error => 'Adja meg a márkanevet';

  @override
  String get add_basic_details_brand_names_hint =>
      'Adja meg a márkaneveket (pl. Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Jó tanácsok: márkák';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Adja meg **a terméken látható összes márkát**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Fő márka';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'A **fő márkát**, amely általában jól látható a csomagolás első oldalán, **elsőként kell megadni**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'További márkák';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Ha **egy nagy cég** értékesíti:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      'Az **Actimelt** a **Danone** értékesíti';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Ha a márkanevet **több nyelvre lefordítva** is értékesítik:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      'A **Nature Valley** szót néha **Val Nature**-nek írják';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Mennyiség és súly';

  @override
  String get add_basic_details_quantity_hint =>
      'Adja meg a súlyt és szükség esetén a mennyiséget (pl.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Jó tanácsok: mennyiség';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Másolja le a terméken feltüntetett értéket, és **ne felejtse el a mértékegységet**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** vagy **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (a 6 tojáshoz)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(ha a csomagban 3 doboz van, egyenként 150g)';

  @override
  String get barcode => 'Vonalkód';

  @override
  String barcode_barcode(String barcode) {
    return 'Vonalkód: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Érvénytelen vonalkód';

  @override
  String get basic_details_add_success => 'Az alapadatok sikeresen hozzáadva';

  @override
  String get basic_details_add_error =>
      'Nem sikerült hozzáadni az alapadatokat. Próbálja újra kicsit később';

  @override
  String get clear_search => 'Keresések törlése';

  @override
  String get confirm_clear =>
      'Az összes előzmény törlésére készül: biztosan folytatja?';

  @override
  String get alert_clear_selected_user_list =>
      'A kiválasztott elemek törlésére készül az előzményekből';

  @override
  String get confirm_clear_selected_user_list => 'Biztosan folytatni szeretné?';

  @override
  String get alert_select_items_to_clear =>
      'Válasszon egy vagy több törlendő elemet';

  @override
  String confirm_clear_user_list(String name) {
    return 'A lista kiürítésére készül ($name): biztosan folytatja?';
  }

  @override
  String get confirm_delete_user_list_title => 'Törli a listát?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'A(z) „$name” lista törlésére készül.\nBiztosan folytatja?';
  }

  @override
  String get confirm_delete_user_list_button => 'Igen, megerősítem';

  @override
  String importance_label(String name, String id) {
    return '$name fontosság: $id';
  }

  @override
  String get user_list_all_title => 'Listák';

  @override
  String get user_list_all_empty => 'Hozza létre első listáját';

  @override
  String get product_list_select => 'Lista kiválasztása';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count termék',
      one: 'Egy termék',
      zero: 'Üres lista',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Lista hozzáadása';

  @override
  String get open_food_preferences_tooltip =>
      'Szerkessze az étkezési preferenciáit';

  @override
  String get add_photo_button_label => 'Fénykép hozzáadása';

  @override
  String get add_packaging_photo_button_label =>
      'Fotózza le a csomagolási/újrahasznosítási információkat';

  @override
  String get add_origin_photo_button_label =>
      'Fotózza le a származási információkat';

  @override
  String get add_emb_photo_button_label => 'Fotózza le a gyártási kódokat';

  @override
  String get add_label_photo_button_label =>
      'Fotózza le a címkéket/tanúsítványokat';

  @override
  String get choose_image_source_title => 'Kép forrása';

  @override
  String get choose_image_source_body => 'Válassza ki a kép forrását';

  @override
  String get gallery_source_label => 'Galéria';

  @override
  String get gallery_source_access_denied_dialog_title =>
      'Hozzáférés megtagadva';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Sajnos az alkalmazás nem fér hozzá a galériához, mivel korábban megtagadta az engedélyt.\n\nNyissa meg az alkalmazás beállításait a telefon Beállítások -> Fényképek menüjében';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Beállítások megnyitása';

  @override
  String get share => 'Megosztás';

  @override
  String share_product_text(String url) {
    return 'Nézd meg ezt a terméket az Open Food Facts oldalán: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Nézd meg ezt a terméket az Open Beauty Facts oldalán: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Nézd meg ezt a terméket az Open PetFood Facts oldalán: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Nézd meg ezt a terméket az Open Products Facts oldalán: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Nézd meg a terméklistámat az Open Food Facts oldalán: $url';
  }

  @override
  String get capture => 'Új kép készítése';

  @override
  String get capture_new_picture => 'Fénykép készítése';

  @override
  String get choose_from_gallery => 'Választás a galériából';

  @override
  String get image_upload_queued =>
      'A képet a lehető leghamarabb feltöltjük a háttérben.';

  @override
  String get add_price_queued =>
      'Az árat a lehető leghamarabb elküldjük a szerverre.';

  @override
  String get background_task_title_full_refresh =>
      'Az összes helyben tárolt termék frissítésének megkezdése';

  @override
  String get background_task_title_folksonomy =>
      'A helyileg tárolt folksonomy-frissítésekhez kapcsolódó kiszolgálói műveletek végrehajtásának megkezdése';

  @override
  String get background_task_title_top_n =>
      'A legnépszerűbb termékek letöltésének megkezdése';

  @override
  String get expand_nutrition_facts => 'Tápértéktáblázat kibontása';

  @override
  String get expand_nutrition_facts_body =>
      'Kinyitva tartja a tápértéktáblázatot';

  @override
  String get expand_ingredients => 'Összetevőlista kibontása';

  @override
  String get expand_ingredients_body => 'Nyitva tartja az összetevők paneljét';

  @override
  String get no_internet_connection => 'Nincs internetkapcsolat';

  @override
  String get world_results_label => 'Egész világ';

  @override
  String get world_results_action => 'Keresés kiterjesztése az egész világra';

  @override
  String get copy_to_clipboard => 'Másolás';

  @override
  String get paste_from_clipboard => 'Beillesztés vágólapról';

  @override
  String get no_data_available_in_clipboard => 'Nincs adat a vágólapon';

  @override
  String get clipboard_barcode_copy => 'Vonalkód másolása a vágólapra';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'A(z) $barcode vonalkód a vágólapra másolva.';
  }

  @override
  String get open_product_website => 'Termék megnyitása a weboldalon';

  @override
  String get language_picker_label => 'Alkalmazás nyelve';

  @override
  String get country_picker_label => 'Az Ön országa';

  @override
  String get currency_picker_label => 'Az Ön pénzneme';

  @override
  String get help_with_openfoodfacts => 'OpenFoodFacts segítségkérés';

  @override
  String get product_task_background_schedule =>
      'A termék a lehető leghamarabb frissül a háttérben.';

  @override
  String get no_email_client_available_dialog_title =>
      'Nem található e-mail alkalmazás!';

  @override
  String get no_email_client_available_dialog_content =>
      'Kérjük, küldjön nekünk egy e-mailt manuálisan a mobile@openfoodfacts.org címre';

  @override
  String get all_images => 'Összes kép';

  @override
  String get selected_images => 'Kiválasztott képek';

  @override
  String get product_card_remove_product_tooltip => 'Termék eltávolítása';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Új vonalkód leolvasva: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Összes termék eltávolítása a lapozóból';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Az összehasonlításhoz olvasson le legalább két terméket';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Kattintson a leolvasott termékek összehasonlításához';

  @override
  String get scan_product_loading => 'Leolvasta a\nvonalkódot:';

  @override
  String get scan_product_loading_initial =>
      'Még keressük a terméket!\nVárjon pár másodpercet…';

  @override
  String get scan_product_loading_long_request =>
      'Még mindig keressük a terméket!\nÚgy érzi, hogy sokáig tart a betöltése? Mi is…';

  @override
  String get scan_product_loading_unresponsive =>
      'Még mindig keressük a terméket.\nSzeretné újraindítani a keresést?';

  @override
  String get scan_product_loading_restart_button => 'Keresés újraindítása';

  @override
  String get portion_calculator_description =>
      'Tápértékadatok kiszámítása egy megadott mennyiségre';

  @override
  String get portion_calculator_hint => 'Mennyiség';

  @override
  String get portion_calculator_accessibility =>
      'Adjon meg egy mennyiséget a tápértékadatok kiszámításához';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Egy $min g és $max g közötti mennyiséget adjon meg';
  }

  @override
  String get portion_calculator_computation_error =>
      'Hiányzó adatok miatt a számítást nem lehetett elvégezni.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Tápértékadatok $grams g-ra (vagy ml)';
  }

  @override
  String get offline_data => 'Offline adatok';

  @override
  String get ocr_image_upload_instruction =>
      'Töltsön fel egy képet a rajta lévő információk automatikus kinyeréséhez.';

  @override
  String get upload_image => 'Fénykép feltöltése';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Nem sikerült letölteni a képet';

  @override
  String get image_edit_url_error =>
      'Nem sikerült szerkeszteni a képet, mert a kép URL-je nincs beállítva.';

  @override
  String get user_picture_source_remember => 'Emlékezzen a választásomra';

  @override
  String get user_picture_source_ask => 'Mindig kérdezzen rá';

  @override
  String get robotoff_continue => 'Folytatás';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kérdés',
      one: 'kérdés',
    );
    return 'Következő $_temp0';
  }

  @override
  String get show_password => 'Jelszó megjelenítése';

  @override
  String get owner_field_info_title => 'Gyártó által megadott értékek';

  @override
  String get owner_field_info_message =>
      'Ezzel a logóval a gyártó által megadott adatokat emeljük ki, amelyek nem szerkeszthetők.';

  @override
  String get owner_field_info_close_button => 'Információ bezárása';

  @override
  String get owner_field_image =>
      'Ezt a képet a gyártó biztosította. Lehet, hogy nem szerkeszthető.';

  @override
  String get edit_packagings_title => 'Csomagolás elemei';

  @override
  String get edit_packagings_element_add => 'Csomagolóelem hozzáadása';

  @override
  String get edit_packagings_completed => 'A csomagolási adatok teljesek';

  @override
  String edit_packagings_element_title(int index) {
    return '#$index csomagolóelem';
  }

  @override
  String get edit_packagings_element_field_units => 'Darabszám';

  @override
  String get edit_packagings_element_hint_units =>
      'Adja meg a terméken lévő azonos alakú és anyagú csomagolóelemek számát.';

  @override
  String get edit_packagings_element_field_shape => 'Alak';

  @override
  String get edit_packagings_element_hint_shape =>
      'Adja meg az alak újrahasznosítási utasításokban látható nevét, ha fel van tüntetve, vagy válasszon egy alakot.';

  @override
  String get edit_packagings_element_example_shape => 'Palack';

  @override
  String get edit_packagings_element_field_material => 'Anyag';

  @override
  String get edit_packagings_element_hint_material =>
      'Adja meg a pontos anyagot, ha az megállapítható (egy háromszögben lévő anyagkód gyakran megtalálható a csomagolóelemeken), vagy egy általános anyagnevet (például műanyag vagy fém), ha nem biztos benne.';

  @override
  String get edit_packagings_element_example_material => 'Üveg';

  @override
  String get edit_packagings_element_field_recycling =>
      'Újrahasznosítási utasítás';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Csak akkor adja meg az újrahasznosítási utasításokat, ha fel van tüntetve a terméken.';

  @override
  String get edit_packagings_element_example_recycling => 'Újrahasznosítás';

  @override
  String get edit_packagings_element_field_quantity =>
      'Termék nettó mennyisége (mértékegységgel)';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Adja meg a termék nettó tömegét vagy nettó térfogatát, és tüntesse fel a mértékegységet (például g vagy ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Üres csomagolóelem súlya (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Távolítson el minden megmaradt élelmiszert, és lemérés előtt mossa le és szárítsa meg a csomagolást. Ha lehetséges, használjon 0,1 g vagy 0,01 g pontosságú mérleget.';

  @override
  String get background_task_title => 'Függőben lévő közreműködések';

  @override
  String get background_task_subtitle =>
      'Hozzájárulásait automatikusan mentjük a szerverre, de nem mindig valós időben.';

  @override
  String get background_task_list_empty =>
      'Nincsenek függőben lévő háttérfeladatok';

  @override
  String get background_task_error_server_time_out => 'Kiszolgálói időtúllépés';

  @override
  String get background_task_error_no_internet =>
      'Internetkapcsolati hiba. Próbálja újra.';

  @override
  String get background_task_operation_unknown => 'ismeretlen művelettípus';

  @override
  String get background_task_operation_details => 'részletek módosítva';

  @override
  String get background_task_operation_image => 'fénykép feltöltése';

  @override
  String get background_task_operation_refresh =>
      'késleltetett frissítés a fénykép feltöltése után';

  @override
  String get background_task_run_started => 'elindult';

  @override
  String get background_task_run_not_started => 'még nem indult el';

  @override
  String get background_task_run_to_be_deleted => 'törlendő';

  @override
  String get background_task_question_stop =>
      'Szeretné leállítani ezt a feladatot amint lehet?';

  @override
  String get feed_back => 'Visszajelzés';

  @override
  String get undo => 'Visszavonás';

  @override
  String get copy_email_to_clip_board => 'E-mail másolása a vágólapra';

  @override
  String get please_send_us_an_email_to =>
      'Kérjük, manuálisan küldjön e-mailt a címre';

  @override
  String get email_copied_to_clip_board => 'E-mail vágólapra másolva';

  @override
  String get select_accent_color => 'Kiemelt szín kiválasztása';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Kék';

  @override
  String get color_cyan => 'Cián';

  @override
  String get color_green => 'Zöld';

  @override
  String get color_light_brown => 'Alapértelmezett';

  @override
  String get color_magenta => 'Bíbor';

  @override
  String get color_orange => 'Narancs';

  @override
  String get color_pink => 'Rózsaszín';

  @override
  String get color_red => 'Vörös';

  @override
  String get color_rust => 'Rozsdabarna';

  @override
  String get color_teal => 'Türkiz';

  @override
  String get text_contrast_mode => 'Szövegkontraszt';

  @override
  String get contrast_high => 'Magas';

  @override
  String get contrast_medium => 'Közepes';

  @override
  String get contrast_low => 'Alacsony';

  @override
  String get product_refresher_internet_not_found => 'A termék nem található!';

  @override
  String get product_refresher_internet_not_connected =>
      'Nem csatlakozik az internethez!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'A szerver leállt ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Szerverhiba ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'A termék nem található!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'A következő vonalkódú termék nem található meg az adatbázisunkban: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Nincs internetkapcsolat!';

  @override
  String get product_loader_network_error_message =>
      'Ellenőrizze, hogy okostelefonja csatlakozik-e WiFi hálózathoz, vagy engedélyezve van-e a mobiladat-kapcsolat';

  @override
  String get page_not_found_title => 'Az oldal nem található!';

  @override
  String get page_not_found_button => 'Vissza a kezdőlapra';

  @override
  String get download_data => 'Adatok letöltése';

  @override
  String get download_top_products =>
      'Töltse le országa 1000 legnépszerűbb termékét az azonnali leolvasáshoz';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count legnépszerűbb termékét',
    );
    return 'Töltse le országa $_temp0 az azonnali leolvasáshoz';
  }

  @override
  String get download_in_progress => 'Adatok letöltése\nEz eltarthat egy ideig';

  @override
  String downloaded_products(int num) {
    return '$num termék hozzáadva';
  }

  @override
  String get update_offline_data => 'Offline termékadatok frissítése';

  @override
  String get update_local_database_sub =>
      'Frissítse a helyi termékadatbázist az Open Food Facts legfrissebb adataival';

  @override
  String get clear_local_database => 'Offline termékadatok törlése';

  @override
  String get clear_local_database_sub =>
      'Tárhely felszabadításához törölje az összes helyi termékadatot az alkalmazásból';

  @override
  String deleted_products(int num) {
    return '$num termék törölve';
  }

  @override
  String get loading => 'Betöltés…';

  @override
  String get know_more => 'Tudjon meg többet';

  @override
  String get offline_data_desc =>
      'Kattintson, ha többet szeretne megtudni az offline adatokról';

  @override
  String get offline_product_data_title => 'Offline termékadatok';

  @override
  String available_for_download(int num) {
    return '$num termék elérhető azonnali leolvasáshoz';
  }

  @override
  String get country_selector_title => 'Válassza ki az országát:';

  @override
  String get currency_selector_title => 'Válassza ki a pénznemét:';

  @override
  String get language_selector_title => 'Válassza ki a nyelvet:';

  @override
  String get language_selector_section_selected => 'Kiválasztott nyelvek';

  @override
  String get language_selector_section_frequently_used => 'Gyakran használt';

  @override
  String get action_delete_list => 'Törlés';

  @override
  String get action_change_list => 'Az aktuális lista módosítása';

  @override
  String get product_list_create => 'Létrehozás';

  @override
  String get product_list_create_tooltip => 'Új lista létrehozása';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (új számítás)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (új számítás)';

  @override
  String get nutriscore_unknown => 'Ismeretlen Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Ismeretlen Nutri-Score (új számítás)';

  @override
  String get nutriscore_not_applicable => 'A Nutri-Score nem alkalmazható';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'A Nutri-Score nem alkalmazható (új számítás)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Green-Score A';

  @override
  String get environmental_score_b_new => 'Zöld pontszám B';

  @override
  String get environmental_score_c_new => 'Zöld pontszám C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => 'Ismeretlen zöld pontszám';

  @override
  String get environmental_score_not_applicable_new =>
      'A Green-Score nem alkalmazható';

  @override
  String get nova_group_generic_new =>
      'Ultrafeldolgozott élelmiszerek - NOVA csoportok';

  @override
  String get nova_group_1 => '1. NOVA-csoport';

  @override
  String get nova_group_2 => '2. NOVA-csoport';

  @override
  String get nova_group_3 => '3. NOVA-csoport';

  @override
  String get nova_group_4 => '4. NOVA-csoport';

  @override
  String get nova_group_unknown => 'Ismeretlen NOVA-csoport';

  @override
  String get nutrition_facts => 'Tápanyagszintek';

  @override
  String get faq_title_partners => 'A civil szervezet partnerei és támogatói';

  @override
  String get faq_title_vision =>
      'Open Food Facts vízió, küldetés, értékek és programok';

  @override
  String get faq_title_install_beauty =>
      'Telepítse az Open Beauty Facts alkalmazást kozmetikai adatbázis létrehozásához';

  @override
  String get faq_title_install_pet =>
      'Telepítse az Open Pet Food Facts alkalmazást állateledel adatbázis létrehozásához';

  @override
  String get faq_title_install_product =>
      'Telepítse az Open Products Facts alkalmazást termékadatbázis létrehozásához, az objektumok élettartamának meghosszabbítása érdekében';

  @override
  String get faq_nutriscore_nutriscore =>
      'Új Nutri-Score számítási módszer: mi az újdonság?';

  @override
  String get contact_title_pro_page =>
      'Gyártó? Importálja termékeit Open Food Factsbe';

  @override
  String get contact_title_pro_email => 'Gyártói kapcsolat';

  @override
  String get contact_title_press_page => 'Sajtóoldal';

  @override
  String get contact_title_press_email => 'Sajtókapcsolat';

  @override
  String get contact_title_newsletter => 'Iratkozzon fel hírlevelünkre';

  @override
  String get contact_title_calendar => 'Iratkozzon fel közösségi naptárunkra';

  @override
  String get hunger_games_loading_line1 => 'Adjon nekünk pár másodpercet…';

  @override
  String get hunger_games_loading_line2 => 'Letöltjük a kérdéseket.';

  @override
  String get hunger_games_error_label =>
      'Ajjaj! Hiba történt… és nem tudtuk betölteni a kérdéseket.';

  @override
  String get hunger_games_error_retry_button => 'Próbáljuk újra!';

  @override
  String get reorder_attribute_action => 'Attribútumok átrendezése';

  @override
  String get link_cant_be_opened =>
      'Ez a link nem nyitható meg az eszközén. Ellenőrizze, hogy van-e telepítve böngésző.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return '$productName részletei';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return '$productName részletei: $pageName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Megosztás';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Mi az a Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Hol található meg az új Nutri-Score számítás?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'A Nutri-Score-t hét országban használják: Franciaországban, Németországban, Belgiumban, Spanyolországban, Luxemburgban, Hollandiában és Svájcban.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'A gyártóknak a rendelet aláírásától számítva legfeljebb **két év** áll rendelkezésükre, hogy a régi számítást az újra cseréljék.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'Mi a zöld pontszám?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'A Green-Score egy logó, amelynek célja, hogy tájékoztasson az **élelmiszerek környezeti hatásáról**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'A színkód a sötétzöldtől (**A+**) a **legkevésbé környezetre ható** termékekhez a sötétvörösig (**F**) a **legnagyobb hatású** termékekhez tartozik.';

  @override
  String get guide_greenscore_logos_caption => 'A Green-Score logók';

  @override
  String get guide_greenscore_lca_title =>
      'A lényeg: Életciklus-értékelés (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Az élelmiszerkategóriák tudományos értékelése';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Minden termékkategóriára egy **benchmark** pontszámot határoznak meg az Agribalyse környezetvédelmi adatbázisának adatai alapján (amelyet az ADEME és az INRAE tervezett).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      'Az **életciklus-elemzés** egy szabványosított értékelési módszer többlépcsős és többkritériumos környezeti értékelés elvégzésére.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Méretei:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 gyártási lépés';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Mezőgazdaság';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Feldolgozás';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Csomagolás';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Szállítás';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Elosztás';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Fogyasztás';

  @override
  String get guide_greenscore_lca_arg3_title => '14 környezeti hatásmutató';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'Klímaváltozás/szénlábnyom';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Az ózonréteg elvékonyodása';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ionizáló sugárzás';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Föld';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Víz- és energiafelhasználás';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'A levegő szennyezése';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Tengeri és édesvíz (részecskék, savasodás, eutrofizáció)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Erőforrások kimerülése.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Bónuszok és büntetések';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'A kategórián belüli jobb termékek jutalmazása érdekében **bónuszokat és büntetéseket alkalmazunk számos kritérium alapján**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Bónuszt** azok a termékek kapnak, amelyek **hivatalos címkével, környezeti előnyöket garantáló címkével vagy tanúsítvánnyal** rendelkeznek (bio, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Összetevők eredete';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bónuszt** az összetevők származása alapján ítélik oda. Ez a bónusz figyelembe veszi a **szállításra gyakorolt hatást**, valamint az egyes termelők országának **környezetvédelmi politikáját** is.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Büntetést** szabnak ki azokra a termékekre, amelyek olyan összetevőket tartalmaznak, amelyek jelentős **negatív hatással vannak a biológiai sokféleségre és az ökoszisztémákra**, például a pálmaolajat, amelynek termelése tömeges erdőirtásért felelős.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Csomagolás';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **büntetés** kiszámításakor figyelembe vesszük a **csomagolás körforgását** (újrahasznosított alapanyagok használata és újrahasznosíthatósága), valamint a túlcsomagolást.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'A Green-Score pontos kiszámításához olyan információkra van szükség, **amelyek nem feltétlenül szerepelnek a csomagoláson** (például az egyes összetevők eredete és pontos százalékos aránya), vagy amelyek ritkán állnak rendelkezésre használható formában (például a csomagolás összes összetevőjének listája a felhasznált műanyagok pontos típusaival).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Átlagos értékeket használunk, ha ez az információ még nem áll rendelkezésre**, de most mindenkit arra kérünk, hogy segítsen nekünk összegyűjteni ezeket az információkat, amelyek nagyon hasznosak lesznek a Green-Score, de sok más célra is.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Hogyan segíthetnek a polgárok?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Minden állampolgár segíthet nekünk a termékeken található vagy azokból kikövetkeztethető információk összegyűjtésében és rendszerezésében, például a **csomagoláson** található információkban: „Mission Emballages”: nagyszabású, közösen készített leltár az összes élelmiszertermék csomagolásáról (francia nyelven).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Hogyan segíthetnek a gyártók';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'A gyártók közvetlenül elküldhetik nekünk adataikat az ingyenes platformunkon keresztül.';

  @override
  String get guide_greenscore_better_product_title =>
      'Melyik termék jobb a bolygónak?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Nehéz lehet megmondani';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'A fenntartható élelmiszerek választása az egyik legerősebb dolog, amit a klímavédelemért tehetünk, mivel **globális élelmiszerrendszerünk az összes üvegházhatású gázkibocsátás több mint negyedéért felelős**.\n(Forrás: Poore és Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title =>
      'Benned van a hatalom!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'A jó hír az, hogy ez egy erőteljes módot kínál a változásra.\n**Mindannyian körülbelül 1000 étkezést eszünk évente**. Ez 1000 lehetőség arra, hogy **jobb jövőt válasszunk a bolygó számára**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Segít felelősségteljesen dönteni';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'A fenntartható élelmiszerek kiválasztása bonyolultnak tűnhet. A címkék zavaróak lehetnek, és gyakran hiányoznak az információk. A Green-Score rendszert azért hozták létre, hogy egyszerűvé tegye a dolgot, és **egyértelmű**, **tudományosan megalapozott** és **átlátható** környezetvédelmi besorolást adjon az élelmiszertermékeknek, pont ott, ahol szüksége van rá: vásárlás közben.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Átláthatóság';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'A saját fejlesztésű címkékkel ellentétben a Green-Score számítás **teljesen nyílt**, és **bárki által ellenőrizhető**.';

  @override
  String get guide_nova_title => 'Többszörösen feldolgozott élelmiszerek';

  @override
  String get guide_nova_what_is_nova_title => 'Mi az az ultrafeldolgozás?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'A NOVA csoportok tájékoztatják Önt az élelmiszer-feldolgozás szintjéről.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'A NOVA osztályozás lehetővé teszi az élelmiszerek **4 csoportba** sorolását az **ipari feldolgozás mértéke** alapján (minimálisan feldolgozott vagy feldolgozatlan élelmiszerek, kulináris összetevők, feldolgozott élelmiszerek, ultrafeldolgozott élelmiszerek).';

  @override
  String get guide_nova_logos_caption => 'A NOVA logók';

  @override
  String get guide_nova_groups_title => 'A 4 NOVA csoport';

  @override
  String get guide_nova_groups_intro =>
      '4 NOVA csoport létezik, a problémás a 4. csoport - Ultrafeldolgozott élelmiszerek.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimálisan feldolgozott vagy feldolgozatlan élelmiszerek';

  @override
  String get guide_nova_groups_arg1_text =>
      'UNPROCESSED (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'Feldolgozott összetevők';

  @override
  String get guide_nova_groups_arg2_text =>
      'PROCESSED culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Feldolgozott élelmiszerek';

  @override
  String get guide_nova_groups_arg3_text =>
      'PROCESSED foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to Group 1** foods. processes include various Preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have TWO or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten On their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title =>
      'Többszörösen feldolgozott élelmiszerek';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, Or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used In culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Az ultra-feldolgozással kapcsolatos problémák';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Az élelmiszer-összetevők extrém feldolgozása';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Sokuk **élelmiszer-összetevők további feldolgozásából származik**, például hidrogénezett vagy interészterezett olajok, hidrolizált fehérjék, szójafehérje-izolátum, maltodextrin, invertcukor és magas fruktóztartalmú kukoricaszirup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Adalékanyagok, amelyek túlmutatnak a puszta élelmiszerbiztonságon';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Az ultrafeldolgozott élelmiszerekben található adalékanyagok között vannak olyanok, amelyeket a feldolgozott élelmiszerekben is használnak, például tartósítószerek, antioxidánsok és stabilizátorok. Az adalékanyagok azon osztályai, amelyek csak az ultrafeldolgozott termékekben találhatók, magukban foglalják azokat, amelyeket **az élelmiszerek érzékszervi tulajdonságainak utánzására vagy fokozására, illetve a végtermék kellemetlen tulajdonságainak elrejtésére** használnak. Ezek az adalékanyagok közé tartoznak a színezékek és egyéb színezékek, színstabilizátorok; aromák, ízfokozók, nem cukor alapú édesítőszerek; és feldolgozási segédanyagok, például szénsavasító, szilárdító, tömegnövelő és térfogatnövelő szerek, habzásgátló, csomósodást gátló és fényező anyagok, emulgeálószerek, komplexképzők és nedvesítőszerek.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Otthon nem elvégezhető feldolgozás';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Számos folyamatsorozatot alkalmaznak** a szokásosan sok összetevő kombinálására és a végtermék (innen ered az „ultra feldolgozott”) előállítására. A folyamatok között több olyan is van, **amelyeknek nincs hazai megfelelőjük**, mint például a hidrogénezés és hidrolizálás, az extrudálás és formázás, valamint a sütéshez való előfeldolgozás.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Az ultrafeldolgozás ragadozó és pénzügyi vonatkozásai';

  @override
  String get guide_nova_explanations_arg4_text =>
      'Az ultrafeldolgozott élelmiszerek átfogó célja márkás, kényelmes (tartós, fogyasztásra kész), vonzó (hiperízletes) és rendkívül jövedelmező (alacsony költségű összetevőkből készült) élelmiszerek létrehozása, amelyek célja, hogy kiszorítsanak minden más élelmiszercsoportot. Az ultrafeldolgozott élelmiszereket általában vonzó csomagolásban csomagolják és intenzíven forgalmazzák.';

  @override
  String get guide_nova_explanations_arg5_title => 'Egészségügyi kockázat';

  @override
  String get guide_nova_explanations_arg5_text =>
      '2018 óta a NutriNet-Santé programnak köszönhetően először mutattak ki összefüggéseket **az ultra-feldolgozott élelmiszerek fogyasztása és a rák, a szív- és érrendszeri betegségek, valamint a cukorbetegség fokozott kockázata között**. Ma már több mint 90 tanulmány erősíti meg ezeket a megállapításokat világszerte.\nA legerősebb összefüggések az **elhízáshoz, a szív- és érrendszeri halálozáshoz és a depressziós tünetekhez** kapcsolódnak. Gyermekeknél a hatások elsősorban a testsúlyban és a lipidegyensúly felborulásában figyelhetők meg.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Az országok a korlátozásukat javasolják';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Néhány ország a NOVA csoportokat használja étkezési irányelveihez vagy céljaihoz, például:\n\n- **🇧🇷 Brazília** étkezési irányelvei **a feldolgozott élelmiszerek fogyasztásának korlátozását** és az ultra-feldolgozott élelmiszerek kerülését javasolják.\n\n- **🇫🇷 Franciaország** 2018-2022 közötti közegészségügyi táplálkozáspolitikai céljai a **4. csoportba tartozó ultra-feldolgozott élelmiszerek fogyasztásának 20%-kal történő csökkentése**.';

  @override
  String get guide_nova_share_link => 'https://world-hu.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Üdvözlünk az Open Food Facts oldalán!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Mi az a Nyílt Élelmiszerinformációk?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Az Open Food Facts egy **együttműködésen alapuló**, **ingyenes** és **nyílt** adatbázis, amely a világ minden tájáról származó élelmiszertermékeket tartalmaz.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Úgy gondoljuk, hogy mindenkinek hozzáférése kell legyen az információkhoz arról, hogy mit eszik. Az összetevőkre, allergénekre, tápértékre és egyebekre vonatkozó adatok gyűjtésével **felhatalmazzuk a fogyasztókat a megalapozott döntések meghozatalára**, és az élelmiszeripart **nagyobb átláthatóság** felé tereljük.';

  @override
  String get guide_open_food_facts_features_title =>
      'Az Open Food Facts jellemzői';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Értesítéseket kaphat a nem kívánt összetevőkről';

  @override
  String get guide_open_food_facts_tips_title =>
      'Tippek nagyszerű fotók készítéséhez';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Tiltott dolgok';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Kerülje az árnyékokat és a tükröződést.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Nincs elmosódott vagy életlen szöveg.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Ne vágj ki részeket a szövegből.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Kerüld a zsúfolt háttereket.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Tennivalók';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Használjon jó, egyenletes megvilágítást.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ügyeljen arra, hogy a szöveg éles és olvasható legyen.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Rögzítse a teljes összetevőlistát.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Tartsa a terméket sík felületen.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Segíts nekünk felépíteni az \"Ételek Wikipédiáját\"!';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Pontszám a tápértékre vonatkozóan';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Egy pontszám az ultra-feldolgozott élelmiszerek elkerülésére';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Egy pont a bolygónak';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-hu.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Üdvözöljük az Open Pet Food Facts oldalán!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Mi az a Nyílt Állateledel Tények?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Az Open Pet Food Facts kiterjeszti küldetésünket szőrös barátainkra! Ez egy **macskák, kutyák és más társak számára készült állateledel-termékek adatbázisa**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Információkat gyűjtünk az **összetevőkről**, a **tápanyag-összetételről** és az etetési irányelvekről, hogy segítsük a gazdiknak kiválasztani az állataik igényeinek leginkább megfelelő eledelt.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Az Open Pet Food Facts jellemzői';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Értesítéseket kaphat a nem kívánt összetevőkről';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Allergiás bármilyen összetevőre a kedvenced? Az alkalmazásban beállíthatsz egy listát a kerülendő kozmetikai összetevőkről!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tippek nagyszerű fotók készítéséhez';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Tiltott dolgok';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Kerülje az árnyékokat és a tükröződést.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Nincs elmosódott vagy életlen szöveg.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Ne vágj ki részeket a szövegből.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Kerüld a zsúfolt háttereket.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Tennivalók';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Használjon jó, egyenletes megvilágítást.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ügyeljen arra, hogy a szöveg éles és olvasható legyen.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Rögzítse a teljes összetevőlistát.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Tartsa a terméket sík felületen.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Megjegyzés a pontozásról';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Egy állateledel pontozási rendszerének kidolgozása **jelenleg nem prioritás**. A módszertan összetett lenne, mivel a táplálkozási igények fajonként, koronként és egészségi állapotonként nagymértékben eltérnek. Még nem találtunk független tudományos csapatot, amely képes lenne ilyen pontozást kidolgozni.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-hu.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Üdvözlünk az Open Beauty Facts oldalán!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Mi az a Nyílt Szépség Tények?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Az Open Beauty Facts egy közösen létrehozott adatbázis, amely **kozmetikai termékeket** tartalmaz.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Célunk az összetevők listájának megfejtése, hogy segítsünk megérteni, **mi van a testápolási termékeidben**. A hidratálókrémektől a sminktermékekig adatokat gyűjtünk az összetevőkről, allergénekről és a csomagolásról, hogy elősegítsük az átláthatóságot a kozmetikai iparban.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Az Open Beauty Facts jellemzői';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Értesítéseket kaphat a nem kívánt összetevőkről';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Allergiás vagy bármilyen összetevőre? El szeretnéd kerülni a komedogén anyagokat? Szeretnéd elkerülni a vitatott összetevőket? Beállíthatsz egy listát a kerülendő kozmetikai összetevőkről közvetlenül az alkalmazásban!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tippek nagyszerű fotók készítéséhez';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Tiltott dolgok';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Kerülje az árnyékokat és a tükröződést.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Nincs elmosódott vagy életlen szöveg.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Ne vágj ki részeket a szövegből.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Kerüld a zsúfolt háttereket.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Tennivalók';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Használjon jó, egyenletes megvilágítást.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ügyeljen arra, hogy a szöveg éles és olvasható legyen.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Rögzítse a teljes összetevőlistát.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Készítsen annyi képet, amennyire szüksége van, ha az üveg görbe.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Lehet, hogy le kell húznia a címkét az összetevők listájának megtekintéséhez.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Tartsa a terméket sík felületen.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Megjegyzés a pontozásról';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Az élelmiszerekkel ellentétben a kozmetikumok világában **nincs egyetemesen elismert, kormány által támogatott pontozási rendszer, mint a Nutri-Score**. Az összetevők hatásai nagyon személyesek lehetnek, és függhetnek a bőrtípustól, az allergiáktól és az egyéni aggályoktól.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-hu.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Az Open Prices egy olyan projekt, amelynek célja a **világ minden tájáról származó termékek árainak gyűjtése és megosztása**. Ez egy nyilvánosan elérhető adathalmaz, amely kutatásra, elemzésre és egyebekre felhasználható. Az Open Prices-t az Open Food Facts fejleszti és tartja karban.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Nyílt forráskódú áradatbázist gyűjtünk közösségi finanszírozásból**. Az árakat a felhasználók ezen a webes alkalmazáson vagy a hivatalos Open Food Facts mobilalkalmazáson keresztül adhatják meg. Kiskereskedők vagy harmadik féltől származó alkalmazások is hozzájárulhatnak az API-nk használatával.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Gyűjtsön fotókat az árcédulákról a folyosókon';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Gyűjtsd össze a nyugták fotóit';

  @override
  String get guide_open_prices_why_title =>
      'Miért csinálja ezt az Open Food Facts?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Az árinformációk kiemelkedően fontosak az élelmiszerrendszerek megértéséhez. Kulcsfontosságú tényezők az élelmiszerek költségeinek megértésében és az egészségesebb étrend előmozdításában. A nyitó áradatok megkönnyítik a kutatók, újságírók és polgárok számára, hogy **jobban megértsék az élelmiszerárak földrajzi és időbeli változását**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Az árak időbeli alakulásának nyomon követése';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Nézd az **árak alakulását**: zsugorodási infláció, olcsónflació, együtt nyomon követhetjük őket!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Hasonlítsa össze az árakat a közelben';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Ahogy egyre több árat kapunk, megtalálhatod **a környékeden a legolcsóbb üzleteket**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Fontolóra vetted már, hogy lemásolod az árakat a kiskereskedők weboldalairól?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Az árlekaparás egy fontolóra vett lehetőség az Open Prices jövőbeli verzióiban, de ezt maga az Open Prices végezné el, hogy a HTML oldal alapján bizonyítékot kaphassunk az árról.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Az árakhoz az API-nkon keresztül is hozzájárulhatsz.\nHa nagyobb mennyiségben szeretnél árakat megadni, kérjük, vedd fel velünk a kapcsolatot a prices@openfoodfacts.org címen.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Üdvözöljük az Open Products Facts oldalán!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Mi az a Nyílt Terméktények?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Az Open Products Facts egy hatalmas, nyílt adatbázis, amely **vonalkóddal ellátott termékekre vonatkozik, amelyek nem élelmiszerek, kozmetikumok vagy állateledel**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Az **elektronikától** a **játékokon** át a **ruhákon** át a **tisztítószerekig**, ha van vonalkódjuk, az hozzáadható. Ez a projekt egy „dolgok internetének” létrehozását célozza a mindennapi tárgyak számára, így a róluk szóló információk univerzálisan hozzáférhetőek.';

  @override
  String get guide_open_products_facts_features_title =>
      'A nyílt termékek jellemzői Tények';

  @override
  String get guide_open_products_facts_features_text =>
      'Az Open Products Facts célja, hogy a fogyasztók számára **meghosszabbítsák tárgyaik élettartamát** körforgásos megoldások biztosításával, amelyekkel karbantarthatják, **javíthatják**, **újrahasznosíthatják** tárgyaikat, vagy új tulajdonoshoz juthatnak.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Egyes termékek szénlábnyoma';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      'A Francia Környezetvédelmi Hatóság (ADEME) által készített **CO2 hatás** adatai számos kategóriára kiterjednek, ezért ügyeljen a termékek pontos kategorizálására.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Javíthatósági index számos termék esetében';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Amikor elérhetővé válik egy francia javíthatósági index, megjelenítjük. Ezenkívül **elkezdheti a változók gyűjtését a Folksonomy Engine segítségével**; így a jövőben mi magunk is újra tudjuk számolni, még azokban az országokban is, ahol nem érhető el.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Találj módokat a terméked adományozására/viszonteladására';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Linkeket biztosítunk **harmadik féltől származó, körforgásbarát szolgáltatásokhoz**, amelyek segítenek abban, hogy a keresett terméket használt termékként szerezd be, hogy kíméletesebb legyél a bolygó erőforrásaival.\nFontos megjegyezni, hogy ezért nem fizetnek nekünk, és a rendszer csak példaként működik két franciaországi weboldal esetében. A rendszer bővítésében segíthetsz, ha további oldalakat dokumentálsz a wikin.';

  @override
  String get guide_open_products_facts_information_title =>
      'Milyen információk hasznosak?';

  @override
  String get guide_open_products_facts_information_text =>
      'Ilyen széles termékkör esetén **rugalmasan gyűjtjük az adatokat**. Ennek érdekében **hoztuk létre a Folksonomy Engine-t**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'A Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'A Folksonomy Engine egy olyan eszköz, amely segít releváns tulajdonságokkal rendelkező termékeket létrehozni. Ez segít javítani a keresést és a felfedezhetőséget, valamint a jövőben érdekes dolgok kiszámítását és megjelenítését is lehetővé teszi.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Bármilyen kulcsot és értéket hozzáadhatsz, például: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Automatikus javaslatokat kapsz a lehetséges tulajdonságokra, és szívesen látunk, ha újakat adsz hozzá és dokumentálsz a kedvenc termékeidhez.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-hu.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Ételbeállítások megnyitása';

  @override
  String get guide_coming_soon_button_title => 'Hamarosan érkezik';

  @override
  String get guide_learn_more_subtitle => 'Koppintson a további információkért';

  @override
  String get preview_badge => 'Előnézet';

  @override
  String get prices_feedback_form =>
      'Kattintson ide, ha visszajelzést szeretne küldeni nekünk erről az új funkcióról!';

  @override
  String get menu_button_list_actions => 'Válasszon műveletet';

  @override
  String get error_loading_photo => 'Hiba a fénykép betöltésekor';

  @override
  String get photo_viewer_action_use_picture_as => 'Használat mint…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Kép használata mint…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Kép használata mint… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Részletek';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Fénykép részletei';

  @override
  String get photo_viewer_details_title => 'Fénykép részletei';

  @override
  String get photo_viewer_details_contributor_title => 'Hozzájáruló';

  @override
  String get photo_viewer_details_size_title => 'Méret';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixel';
  }

  @override
  String get photo_viewer_details_date_title => 'Dátum';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'egyezés';

  @override
  String get user_lists_action_multi_select => 'Többszörös kijelölés';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Az Ön kompatibilitási pontszáma: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Elülső oldal képe';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Összetevők listájának képe';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Tápértékadatok képe';

  @override
  String get product_image_packaging_accessibility_label => 'Csomagolás képe';

  @override
  String get product_image_other_accessibility_label => 'Egyéb kép';

  @override
  String get product_image_outdated_message => 'Ez a kép elavult lehet';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (ez a kép elavult lehet)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (lehet, hogy ezt a képet a gyártó zárolta)';
  }

  @override
  String get product_image_error => 'Nem sikerült betölteni a képet!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type betöltése nem sikerült (hálózati hiba?)';
  }

  @override
  String get product_page_image_no_image_available => 'Nincs\nkép!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Nem érhető el kép erről a termékről';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Műveletek átrendezése vagy elrejtése';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Műveletek szerkesztése';

  @override
  String get product_page_action_bar_item_move_up => 'Mozgatás fel';

  @override
  String get product_page_action_bar_item_move_down => 'Mozgatás le';

  @override
  String get product_page_action_bar_item_enable => 'Művelet engedélyezése';

  @override
  String get product_page_action_bar_item_disable => 'Művelet letiltása';

  @override
  String get product_page_pending_operations_banner_title =>
      'Szerkesztések feltöltése…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Az ezen az oldalon megjelenő adatok **még nem tartalmazzák az Ön módosításait**.\nVárjon pár másodpercet…';

  @override
  String get product_add_a_language => 'Nyelv hozzáadása';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Vonalkód: $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Termék eltávolítása a lapozóból';

  @override
  String get carousel_unsupported_header => 'Nem támogatott vonalkód!';

  @override
  String get carousel_unsupported_title => 'Hoppá!';

  @override
  String get carousel_unsupported_text =>
      'A leolvasott vonalkódot az Open Food Facts nem támogatja!';

  @override
  String get carousel_error_header => 'Hiba!';

  @override
  String get carousel_error_title => 'De nagy kár!';

  @override
  String get carousel_error_text_1 =>
      'Nem tudtunk adatokat lekérni erről a vonalkódról:';

  @override
  String get carousel_error_text_2 =>
      'Ellenőrizze internetkapcsolatát, vagy kattintson erre a gombra:';

  @override
  String get carousel_error_button => 'Újra';

  @override
  String get carousel_unknown_product_header => 'Ismeretlen termék';

  @override
  String get carousel_unknown_product_title =>
      'Gratulálok!\n__Ritka gyöngyszemet__ találtál!';

  @override
  String get carousel_unknown_product_text =>
      'Együttműködésen alapuló adatbázisunk több mint **3 millió terméket** tartalmaz, de ez a vonalkód nincs benne: ';

  @override
  String get carousel_unknown_product_button => 'Termék hozzáadása';

  @override
  String get carousel_loading_header => 'Információ betöltése…';

  @override
  String get carousel_loading_title =>
      'Épp most olvasott le egy terméket a következő vonalkóddal:';

  @override
  String get carousel_loading_text =>
      'Már keressük a több mint **3 millió terméket tartalmazó adatbázisunkban**!';

  @override
  String get product_type_subtitle_food =>
      'Zöldségek, gyümölcsök, fagyasztott élelmiszerek…';

  @override
  String get product_type_subtitle_beauty => 'Sminkek, szappanok, fogkrémek…';

  @override
  String get product_type_subtitle_pet_food =>
      'Táplálék kutyáknak, macskáknak…';

  @override
  String get product_type_subtitle_product => 'Okostelefonok, bútorok…';

  @override
  String get photo_field_front => 'Termékfotó';

  @override
  String get photo_field_ingredients => 'Összetevők fényképe';

  @override
  String get photo_field_nutrition => 'Tápértékadatok fényképe';

  @override
  String get photo_field_packaging => 'Újrahasznosítási utasítások fényképe';

  @override
  String get photo_already_exists => 'Ez a fénykép már létezik';

  @override
  String get photo_missing => 'Ez a fénykép hiányzik';

  @override
  String get date => 'Dátum';

  @override
  String get photo_rotate_left => 'Forgatás balra';

  @override
  String get photo_rotate_right => 'Forgatás jobbra';

  @override
  String get photo_undo_action => 'Előző művelet visszavonása';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$location a világtérképen';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap közreműködők';

  @override
  String get not_applicable_short => 'N/A';

  @override
  String get knowledge_panel_warning_text => 'Figyelmeztetés';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Miért különbözik ez a Nutri-Score a csomagoláson lévőtől?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Két lehetséges magyarázat van:\nAz összetevők listája és/vagy a tápértékadatok nem naprakészek.\n\nMi a Nutri-Score „Új számítás” (vagy V2) verzióját adjuk meg. Ellenőrizze, hogy a csomagon szerepel-e az \"Új számítás\" felirat.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Összetevők ellenőrzése';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Tápértékadatok ellenőrzése';

  @override
  String url_not_supported(String url) {
    return 'Sajnos nem tudjuk megnyitni az URL-t:\n$url';
  }

  @override
  String get product_list_export => 'Exportálás';

  @override
  String get product_list_import => 'Importálás';

  @override
  String get product_footer_action_barcode => 'Vonalkód megtekintése';

  @override
  String get product_footer_action_barcode_short => 'Vonalkód';

  @override
  String get product_footer_action_open_website => 'Weboldal megnyitása';

  @override
  String get product_footer_action_report => 'Jelentés';

  @override
  String get product_footer_action_contributor_guide => 'Segítség (EN)';

  @override
  String get product_footer_action_data_quality_tags => 'Adatminőség';

  @override
  String get product_page_tab_for_me => 'Számomra';

  @override
  String get product_page_tab_website => 'Weboldal';

  @override
  String get product_page_tab_prices => 'Árak';

  @override
  String get prices_explanation_card_title => 'Miért az árak?';

  @override
  String get prices_explanation_card_line1 =>
      'Az **Open Prices** egy olyan projekt, amelynek célja a világ minden tájáról származó termékek árainak összegyűjtése és megosztása 🌍. Az Open Prices-t az Open Food Facts fejleszti és tartja karban.';

  @override
  String get explanation_card_learn_more_button => 'További információk';

  @override
  String get product_page_tab_folksonomy => 'Folksonomia';

  @override
  String get folksonomy_explanation_card_title =>
      'Mik a folksonomia attribútumai?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Az attribútumok **kulcs-érték** alapúak.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Ezeket a tulajdonságokat a közreműködők hozzák létre és iktatják bármilyen felhasználásra.';

  @override
  String get folksonomy_action_external_link_title =>
      'Külső hivatkozás megnyitása';

  @override
  String get folksonomy_action_external_link_warning =>
      'A külső linkek nem biztonságosak lehetnek. Biztosan meg szeretnéd látogatni őket?';

  @override
  String get prices_products_empty_title => 'Nincs elérhető ár';

  @override
  String get prices_products_empty_explanation =>
      'Légy az első, aki hozzájárul!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Legnépszerűbb $pageSize termék (összesen: $total)';
  }

  @override
  String get app_review_title => 'Tetszik az alkalmazás?';

  @override
  String get app_review_low => 'Lehetne jobb is';

  @override
  String get app_review_medium => 'Nem rossz';

  @override
  String get app_review_high => 'Imádom!';

  @override
  String get app_review_feedback_modal_title =>
      'Segítsen nekünk alkalmazás fejlesztésében';

  @override
  String get app_review_feedback_modal_content =>
      'Ha van néhány perce, töltse ki ezt az űrlapot, hogy **javíthassunk rajta a jövőbeni frissítésekkel**:';

  @override
  String get app_review_feedback_modal_open_form => 'Űrlap kitöltése';

  @override
  String get app_review_feedback_modal_later => 'Kérdezzen rá később';

  @override
  String get nutrition_facts_extract_new =>
      'ÚJ: Automatikusan kiolvashatja a tápanyagokat a képből!';

  @override
  String get nutrition_facts_extract_button_text => 'Kiolvasás most';

  @override
  String get nutrition_facts_extract_in_progress => 'Kitermelés folyamatban…';

  @override
  String get nutrition_facts_extract_successful => 'A kinyerés sikeres';

  @override
  String get nutrition_facts_extract_failed =>
      'Nem sikerült a tápanyagokat kiolvasni a képről';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Statisztika';

  @override
  String get prices_stats_title => 'Árstatisztika';

  @override
  String get prices_stats_prices_section => 'Árak';

  @override
  String get prices_stats_products_section => 'Termékek';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Hozzájárulók';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Egyéb';

  @override
  String get prices_stats_total => 'Összesen';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Fogyasztás';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Élelmiszer';

  @override
  String get prices_stats_beauty => 'Szépségápolás';

  @override
  String get prices_stats_products => 'Termékek';

  @override
  String get prices_stats_pet_food => 'Állateledel';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Országok';

  @override
  String get prices_stats_price_tag => 'Árcédula';

  @override
  String get prices_stats_receipt => 'Nyugta';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Weboldal';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Egyéb';

  @override
  String get prices_stats_last_updated => 'Utolsó frissítés ideje';

  @override
  String get prices_stats_error =>
      'Hiba történt a statisztikák betöltése közben.';

  @override
  String get product_edit_robotoff_question_answered => 'Kérdés megválaszolva!';

  @override
  String get product_edit_robotoff_proof => 'Bizonylat';

  @override
  String get preferences_card_general => 'Általános';

  @override
  String get preferences_prices_title => 'Árak';

  @override
  String get preferences_prices_subtitle => 'Árbeállítások kezelése';

  @override
  String get preferences_card_project => 'Az Open Food Facts projekt';

  @override
  String get preferences_contribute_title => 'Hozzájárulás';

  @override
  String get preferences_my_contributions_title => 'Hozzájárulásaim';

  @override
  String get preferences_my_stats_title => 'A statisztikáim';

  @override
  String get preferences_contribute_subtitle =>
      'Fordítás, eszközeink fejlesztése…';

  @override
  String get preferences_connect_title => 'Csatlakozás';

  @override
  String get preferences_connect_subtitle =>
      'Keressen minket, vagy kövessen minket a közösségi médiában';

  @override
  String get preferences_support_title => 'Támogass';

  @override
  String get preferences_support_subtitle =>
      'Segítsen nekünk tájékoztatni több millió fogyasztót világszerte';

  @override
  String get preferences_card_help => 'Súgó és támogatás';

  @override
  String get preferences_faq_title => 'GYIK';

  @override
  String get preferences_faq_subtitle => 'Kapj választ a kérdéseidre';

  @override
  String get logged_out => 'Kijelentkezve';

  @override
  String get preferences_app_bar_message =>
      'Köszönjük, hogy tagjaink közé tartozol!';

  @override
  String get preferences_app_bar_products_modified => 'Módosított termékek';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats =>
      'Az összes statisztika megtekintése';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Keresés $provider kifejezésre: „$keyword”';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Beállítás keresése (pl. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Akadálymentesítés: Emojik megjelenítése';

  @override
  String get preferences_accessibility_remove_colors =>
      'Akadálymentesítés: Színek eltávolítása';

  @override
  String get preferences_app_settings_products => 'Termékek';

  @override
  String get preferences_card_about => 'Névjegy';

  @override
  String get preferences_legal_information_title => 'Jogi információk';

  @override
  String get preferences_legal_information_subtitle =>
      'Felhasználási feltételek, adatvédelmi irányelvek és egyebek';

  @override
  String get preferences_terms_of_use => 'Felhasználási feltételek';

  @override
  String get preferences_legal_mentions => 'Jogi közlemény';

  @override
  String get preferences_legal_header =>
      'Az Open Food Facts egy élelmiszertermék-adatbázis, **amelyet mindenki készített, mindenkinek**.\nHasználhatod jobb élelmiszer-döntések meghozatalára, és mivel **nyílt adat**, bárki **újra felhasználhatja bármilyen célra**.';

  @override
  String get preferences_privacy_policy => 'Adatvédelmi Irányelvek';

  @override
  String get preferences_licenses => 'Licencek';

  @override
  String get preferences_about_app_title => 'Az alkalmazásról';

  @override
  String get preferences_about_app_subtitle =>
      'Technikai információk, fejlesztői információk és egyebek';

  @override
  String get preferences_card_information => 'Információ';

  @override
  String get preferences_version_number_title => 'Verziószám';

  @override
  String get preferences_scanner_title => 'Scanner';

  @override
  String get preferences_app_store => 'Alkalmazásbolt';

  @override
  String get preferences_app_system_settings => 'Rendszerbeállítások';

  @override
  String get preferences_source_code => 'Hozzáférés a forráskódhoz';

  @override
  String get preferences_source_code_subtitle =>
      'És kezdj el hatást gyakorolni milliók életére';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Termékek kiegészítése';

  @override
  String get preferences_tips => 'Tippek';

  @override
  String get tips_discover_nutriscore => 'Fedezze fel az új Nutri-Score-t';

  @override
  String get preferences_on_off_website_subtitle =>
      'Az Open Food Facts weboldalon';

  @override
  String get preferences_manage_account_title => 'Fiókom kezelése';

  @override
  String get preferences_manage_account_tooltip => 'Fiók kezelése';

  @override
  String get preferences_change_password_title => 'Jelszó módosítása';

  @override
  String get preferences_danger_zone => 'Veszélyes zóna';

  @override
  String get preferences_account_deletion_subtitle =>
      'Minden hozzájárulásod elveszik';

  @override
  String get preferences_contributions_title => 'Hozzájárulások';

  @override
  String get preferences_dev_mode_app_settings_title => 'Alkalmazásbeállítások';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Nagyon kísérleti módszer a termékek offline szkennelésére';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Az összes termék frissítése a szerverről';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Kérlek, kerüld ezt, kivéve, ha feltétlenül szükséges';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demó mód';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Kártyák hozzáadása a szkennerhez';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      '3 mintaterméket ad a szkennerhez';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Folksonomy házigazda';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Gazdagép: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Akadálymentesítési kísérletek';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Több termék választéka árakon';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Felhasználó által rendezett tudáspanelek';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Ideiglenes hozzáférés a helymeghatározáshoz';

  @override
  String get preferences_dev_mode_comparison_title =>
      '2 vagy 3 termék egymás melletti összehasonlítása';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Terméklista importálása';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Pontszámok és módszertanok';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Fedezze fel, hogyan számítják ki a Nutri-Score-t';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Ismerje meg a módszertan főbb változásait';

  @override
  String get preferences_faq_discover_project_title =>
      'Fedezze fel a projektet';

  @override
  String get preferences_faq_discover_off_title =>
      'Fedezze fel az Open Food Facts-et';

  @override
  String get preferences_faq_discover_obf_title =>
      'Fedezze fel a nyílt szépségápolási tényeket';

  @override
  String get preferences_faq_discover_opff_title =>
      'Fedezze fel az Open állateledel-információkat';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Fedezze fel a nyílt termékekre vonatkozó tényeket';

  @override
  String get preferences_faq_faq_title => 'GYIK - Gyakran Ismételt Kérdések';

  @override
  String get preferences_faq_off_ngo_title =>
      'Az Open Food Facts nem kormányzati szervezet';

  @override
  String get preferences_about_information_title => 'Információ';

  @override
  String get preferences_connect_community_updates_title =>
      'Közösségi frissítések fogadása';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Maradjon naprakész az alkalmazás és a közösség híreivel';

  @override
  String get preferences_connect_community_calendar_title =>
      'Iratkozzon fel közösségi naptárunkra';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Csatlakozz virtuális eseményeink egyikéhez';

  @override
  String get preferences_connect_blog_title => 'Az Open Food Facts blog';

  @override
  String get preferences_connect_blog_subtitle =>
      'Értesülj a legfrissebb hírekről, amint történnek';

  @override
  String get preferences_connect_community_help_title =>
      'Kérjen segítséget a közösségtől';

  @override
  String get preferences_connect_improve_app_title =>
      'Segítsen nekünk fejleszteni az alkalmazást';

  @override
  String get preferences_connect_debug_info_title =>
      'Küldjön nekünk hibakeresési információkat';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Küldjön nekünk egy e-mailt részletes hibakeresési információkkal';

  @override
  String get preferences_connect_feedback_title =>
      'Visszajelzés küldése az alkalmazásról';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Segíts alakítani az alkalmazás jövőjét';

  @override
  String get preferences_connect_survey_title =>
      'Töltsd ki az alkalmazás kérdőívét';

  @override
  String get preferences_connect_survey_subtitle =>
      'Segíts megérteni, hogy mit kellene legközelebb építenünk';

  @override
  String get preferences_connect_professionals_title => 'Szakemberek';

  @override
  String get preferences_connect_pro_subtitle =>
      'Teljesen ingyenes, pontos adatokat biztosít 500 alkalmazás és több millió fogyasztó számára. Önkiszolgáló, kompatibilis a PIM-mel vagy táblázatokkal (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Lépjen kapcsolatba velünk a kezdéshez';

  @override
  String get preferences_connect_press_title => 'Sajtó';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Szerezd meg az összes szükséges anyagot a jelentéshez';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Sajtómegkeresésekkel vagy a jelentéssel kapcsolatos információkkal forduljon hozzánk';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Legyen aktív önkéntes';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Fejlesztés, Kommunikáció, Design… bármilyen önkéntes munkát vagy szakértelmet szívesen látunk!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Fedezze fel a számos módot, ahogyan hozzájárulhat';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Mobilalkalmazás-fejlesztés';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Tanuld meg, hogyan járulhatsz hozzá a szoftverfejlesztéshez';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Napi instabil buildek, vadonatúj funkciók';

  @override
  String get preferences_contribute_local_community_title =>
      'Növeld a helyi közösségedet';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Segítség szoftverek, tartalmak, összetevőelemzések fordításában';

  @override
  String get preferences_contribute_share_subtitle =>
      'Készítettünk egy kis sablont segítségül :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Egyszerű lépések az élelmiszer-átláthatóság növeléséhez az Ön országában';

  @override
  String get preferences_contribute_data_quality_title => 'Adatminőség';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Csatlakozz az adatminőségi csapathoz';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Csatlakozzon erőfeszítéseinkhez, hogy az adatbázis teljes és pontos legyen';

  @override
  String get preferences_contributions_products_added_title =>
      'Hozzáadott termékek';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Új termékek, amiket hozzáadtam az Open Food Facts oldalhoz';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Termékek, amiket el kell végeznem';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Minden befejezetlen termék';

  @override
  String get preferences_my_contributions_prices_title => 'Árak';

  @override
  String get preferences_my_contributions_my_prices_title => 'Áraim';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Az áraim, a bizonyítékaim…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Termékek, amelyek elkészítésében segíthetsz';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Segítsen kiszámítani az Ön országában érvényes Nutri-Score és Green-Score értékeket';

  @override
  String get preferences_prices_user_prices_subtitle => 'Általam megadott árak';

  @override
  String get preferences_prices_proofs_subtitle => 'Árcédulák és nyugták';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Készítsen fotókat a nyugtáiról, és olvassa be a hozzájuk tartozó vonalkódokat';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Készítsen fotókat az árakról egy üzletben';

  @override
  String get preferences_prices_newest_title => 'Legújabb árak';

  @override
  String get preferences_prices_newest_subtitle =>
      'A Open Prices közössége által hozzáadott legújabb árak';

  @override
  String get preferences_prices_top_contributors_title =>
      'A legtöbb árat kínáló közreműködők';

  @override
  String get preferences_prices_metrics_title => 'Nyílt ár mutatók';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Kövesd nyomon a projekt alakulását';

  @override
  String get preferences_prices_ways_contribute_title => 'Hozzájárulási módok';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Mesterséges intelligencia segítségével erősítse meg az Ön vagy mások által hozzáadott árakat';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Gyorsan hozzáadhatsz sok nyugtát vagy polcfotót a kameratekercsből';

  @override
  String get preferences_prices_challenges_title => 'Havi kihívások';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Vegyen részt havi tematikus küldetésekben, hogy díjakat gyűjtsön';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Szerezd vissza hűségadataidat';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Tudja meg, hogyan kérheti adatait';

  @override
  String get preferences_page_customize_app_title =>
      'Az alkalmazás testreszabása';

  @override
  String get preferences_page_contribute_project_title =>
      'Hozzájárulás a projekthez';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Egyszerű módok az Open Food Facts segítésére';

  @override
  String get preferences_page_faq_subtitle =>
      'Pontozási módszerek, segítség és további információk a projektről';

  @override
  String get product_edit_robotoff_positive_button => 'Javaslat elfogadása';

  @override
  String get product_edit_robotoff_negative_button => 'Javaslat elutasítása';

  @override
  String get product_edit_robotoff_show_proof => 'Bizonyíték bemutatása';

  @override
  String get product_edit_robotoff_expand_proof => 'Kibontási bizonyítás';

  @override
  String get product_page_tab_raw_data => 'Nyers adatok';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Oldal $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Oldal $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count a $total elemből';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count a $total elemből';
  }

  @override
  String item_count(int count) {
    return '$count elem';
  }

  @override
  String item_count_string(String count) {
    return '$count elem';
  }

  @override
  String get prices_no_result => 'Nem található árstatisztika.';

  @override
  String get prices_error_loading_more_items =>
      'Hiba történt a további elemek betöltése során';

  @override
  String get prices_proof_error =>
      'A hitelesítés sikertelen, a bizonyítékok nem kérhetők le.';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count a $total bizonyításból';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count a $total közreműködőből';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count a $total helyszínből';
  }

  @override
  String prices_locations_count(int count) {
    return '$count helyszínek';
  }

  @override
  String get restart_to_apply_message =>
      'Kérjük, indítsa újra az alkalmazást a módosítások érvénybe léptetéséhez.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafikus felület';

  @override
  String get preferences_app_settings_media_title => 'Média';

  @override
  String get preferences_about_app_development_title => 'Fejlesztés';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Nyílt Élelmiszerinformációs Laboratóriumok';

  @override
  String get preferences_root_account_title => 'Fiók';

  @override
  String get preferences_contribute_translate_header =>
      'Hozd el a Nyílt Élelmiszerinformációkat a saját nyelvedre';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Regisztrálj az alkalmazás alfa verziójára';

  @override
  String get preferences_dev_mode_section_data =>
      'Hozzájárulások és termékadatok';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Ne mutassa a Folksonomy-t';

  @override
  String get preferences_account_title => 'Fiók';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Hozzáadva ekkor: $created';
  }

  @override
  String get location_map_details_title => 'Helyszín részletei';

  @override
  String get location_map_details_name => 'Név';

  @override
  String get location_map_details_street => 'Utca';

  @override
  String get location_map_details_city => 'Város';

  @override
  String get location_map_details_postcode => 'Irányítószám';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Koordináták';

  @override
  String get location_map_details_osm_id => 'OSM-azonosító';
}
