// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hindi (`hi`).
class AppLocalizationsHi extends AppLocalizations {
  AppLocalizationsHi([String locale = 'hi']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'हाँ';

  @override
  String get add => 'डालिए';

  @override
  String get account_delete_message =>
      'क्या आप वाकई अपना खाता हटाना चाहते हैं?\nयदि कोई विशिष्ट कारण है, तो कृपया नीचे साझा करें';

  @override
  String get reason => 'कारण';

  @override
  String get okay => 'ठीक है';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'बनाएं';

  @override
  String get applyButtonText => 'लागू करें';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'जारी रखना';

  @override
  String get exit_label => 'बाहर निकलें';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'शीर्ष पर वापस जाएँ';

  @override
  String get save => 'सेव़';

  @override
  String get save_confirmation => 'क्या आप वाकई सहेजना चाहते हैं?';

  @override
  String get skip => 'स्किप करें';

  @override
  String get cancel => 'रद्द करें';

  @override
  String get ignore => 'अनदेखा करना';

  @override
  String get close => 'बंद करें';

  @override
  String get no => 'नहीं';

  @override
  String get stop => 'रुकना';

  @override
  String get finish => 'खत्म करना';

  @override
  String get calculate => 'गणना';

  @override
  String get reset_food_prefs => 'भोजन संबंधी प्राथमिकताएं रीसेट करें';

  @override
  String get error => 'कुछ गड़बड़ हुई है।';

  @override
  String get error_occurred => 'एक त्रुटि पाई गई';

  @override
  String get featureInProgress =>
      'हम अभी भी इस सुविधा पर काम कर रहे हैं, बने रहें';

  @override
  String get label_web => 'वेब पर देखें';

  @override
  String get learnMore => 'और अधिक जानें';

  @override
  String get unknown => 'अज्ञात';

  @override
  String get match_very_good => 'बहुत अच्छा मैच';

  @override
  String get match_good => 'अच्छा जोड़ा';

  @override
  String get match_poor => 'खराब मैच';

  @override
  String get match_may_not => 'मेल नहीं खा सकता';

  @override
  String get match_does_not => 'मेल नहीं खाता';

  @override
  String get match_unknown => 'अज्ञात मिलान';

  @override
  String get match_short_very_good => 'बहुत अच्छा मैच';

  @override
  String get match_short_good => 'अच्छा जोड़ा';

  @override
  String get match_short_poor => 'खराब मैच';

  @override
  String get match_short_may_not => 'मेल नहीं खा सकता';

  @override
  String get match_short_does_not => 'मेल नहीं खाता';

  @override
  String get match_short_unknown => 'अज्ञात मिलान';

  @override
  String get licenses => 'लाइसेंस';

  @override
  String get looking_for => 'ढूंढ रहे हैं';

  @override
  String get welcomeToOpenFoodFacts => 'ओपन फूड फैक्ट्स में आपका स्वागत है';

  @override
  String get whatIsOff =>
      'ओपन फूड फैक्ट्स एक वैश्विक गैर-लाभकारी संस्था है जो स्थानीय समुदायों द्वारा संचालित है।';

  @override
  String get productDataUtility =>
      'अपनी प्राथमिकताओं से संबंधित खाद्य डेटा देखें.';

  @override
  String get healthCardUtility =>
      'ऐसे खाद्य पदार्थ चुनें जो आपके लिए अच्छे हों।';

  @override
  String get ecoCardUtility =>
      'ऐसे खाद्य पदार्थ चुनें जो ग्रह के लिए अच्छे हों।';

  @override
  String get server_error_open_new_issue =>
      'सर्वर से कोई प्रतिक्रिया नहीं! आप निम्न लिंक पर जाकर समस्या खोल सकते हैं।';

  @override
  String get sign_in_text =>
      'अपने योगदानों को सहेजने के लिए अपने ओपन फ़ूड फैक्ट्स खाते में साइन इन करें';

  @override
  String get incorrect_credentials => 'गलत उपयोगकर्ता नाम या पासवर्ड।';

  @override
  String get password_lost_incorrect_credentials =>
      'यह ईमेल या उपयोगकर्ता नाम मौजूद नहीं है। कृपया अपने क्रेडेंशियल जांचें।';

  @override
  String get password_lost_server_unavailable =>
      'हमारे सर्वर फ़िलहाल धीमे चल रहे हैं और इसके लिए हमें खेद है। कृपया बाद में पुनः प्रयास करें।';

  @override
  String get login => 'उपयोगकर्ता नाम';

  @override
  String get login_result_type_server_unreachable =>
      'नेटवर्क तक नहीं पहुंचा जा सकता';

  @override
  String get login_result_type_server_issue =>
      'सर्वर में समस्या है। कृपया बाद में प्रयास करें।';

  @override
  String get login_page_username_or_email =>
      'कृपया उपयोगकर्ता नाम या ई-मेल दर्ज करें';

  @override
  String get login_page_password_error_empty => 'कृपया पासवर्ड दर्ज करें';

  @override
  String get create_account => 'खाता बनाएं';

  @override
  String get sign_in => 'साइन इन करें';

  @override
  String get sign_in_mandatory =>
      'उस सुविधा के लिए हमें आपके साइन इन की आवश्यकता है।';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'साइन आउट';

  @override
  String get sign_out_confirmation =>
      'क्या आप द्वारा साइन आउट किया जाना सुनिश्चित है?';

  @override
  String get password => 'पासवर्ड';

  @override
  String get forgot_password => 'पासवर्ड भूल गए';

  @override
  String get forgot_password_question => 'पासवर्ड भूल गए?';

  @override
  String get view_profile => 'प्रोफाइल देखें';

  @override
  String get reset_password => 'पासवर्ड रीसेट';

  @override
  String get reset_password_explanation_text =>
      'पासवर्ड भूल जाने पर, पासवर्ड रीसेट करने के निर्देश प्राप्त करने के लिए अपना उपयोगकर्ता नाम या ईमेल पता दर्ज करें। स्पैम फ़ोल्डर भी चेक करना न भूलें।';

  @override
  String get username_or_email => 'उपयोगकर्ता का नाम या ईमेल';

  @override
  String get reset_password_done =>
      'आपके खाते से जुड़े ईमेल पते पर आपका पासवर्ड रीसेट करने के लिंक वाला एक ईमेल भेजा गया है। अपना स्पैम भी देखें';

  @override
  String get send_reset_password_mail => 'पासवर्ड बदलें';

  @override
  String get enter_some_text => 'कृपया कुछ पाठ दर्ज करें';

  @override
  String get sign_up_page_title => 'साइन अप करें';

  @override
  String get sign_up_page_action_button => 'साइन अप करें';

  @override
  String get sign_up_page_action_doing_it => 'साइन अप करना…';

  @override
  String get sign_up_page_action_ok => 'बधाई हो! आपका खाता अभी-अभी बना है।';

  @override
  String get sign_up_page_display_name_hint => 'नाम';

  @override
  String get sign_up_page_display_name_error_empty =>
      'कृपया वह प्रदर्शन नाम दर्ज करें जिसका आप उपयोग करना चाहते हैं';

  @override
  String get sign_up_page_email_hint => 'ईमेल';

  @override
  String get sign_up_page_email_error_empty => 'ईमेल की जरूरत है';

  @override
  String get sign_up_page_email_error_invalid => 'अमान्य ईमेल';

  @override
  String get sign_up_page_username_hint =>
      'उपयोगकर्ता नाम: सार्वजनिक रूप से दृश्यमान';

  @override
  String get sign_up_page_username_error_empty =>
      'कृपया उपयोगकर्ता नाम दर्ज करें';

  @override
  String get sign_up_page_username_error_invalid =>
      'एक मान्य उपयोगकर्ता का नाम दर्ज करें';

  @override
  String get sign_up_page_username_description =>
      'उपयोगकर्ता नाम में रिक्त स्थान, कैप्स या विशेष वर्ण नहीं हो सकते।';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'उपयोगकर्ता नाम $value वर्णों से अधिक नहीं हो सकता';
  }

  @override
  String get sign_up_page_password_hint => 'पासवर्ड';

  @override
  String get sign_up_page_password_error_empty => 'कृपया पासवर्ड दर्ज करें';

  @override
  String get sign_up_page_password_error_invalid =>
      'कृपया एक मान्य पासवर्ड दर्ज करें (कम से कम 6 अक्षर)';

  @override
  String get sign_up_page_confirm_password_hint => 'पासवर्ड की पुष्टि कीजिये';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'कृपया पासवर्ड की पुष्टि करें';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'पासवर्ड मेल नहीं खाते';

  @override
  String get sign_up_page_agree_text => 'मैं खुले खाद्य तथ्यों से सहमत हूँ';

  @override
  String get sign_up_page_terms_text => 'उपयोग और योगदान की शर्तें';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'खाता बनाते समय, उपयोग की शर्तों से सहमत होना अनिवार्य है, हालाँकि, ऐप के माध्यम से अभी भी गुमनाम योगदान दिया जा सकता है';

  @override
  String get sign_up_page_producer_checkbox => 'मैं एक खाद्य उत्पादक हूँ';

  @override
  String get sign_up_page_producer_hint => 'निर्माता/ब्रांड';

  @override
  String get sign_up_page_producer_error_empty =>
      'कृपया निर्माता या ब्रांड का नाम दर्ज करें';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'मैं ओपन फ़ूड फैक्ट्स न्यूज़लेटर की सदस्यता लेना चाहता/चाहती हूँ (आप किसी भी समय इसकी सदस्यता समाप्त कर सकते हैं)';

  @override
  String get sign_up_page_user_name_already_used =>
      'उपयोगकर्ता नाम पहले से मौजूद है, कृपया कोई अन्य उपयोगकर्ता नाम चुनें.';

  @override
  String get sign_up_page_email_already_exists =>
      'यदि आपका ईमेल पता पहले से मौजूद है, तो खाते में लॉग इन करें या किसी अन्य ईमेल पते से प्रयास करें।';

  @override
  String get sign_up_page_provide_valid_email => 'एक वैध ईमेल पता प्रदान करें।';

  @override
  String get sign_up_page_server_busy =>
      'हमें बहुत खेद है, आपका खाता बनाने में कुछ तकनीकी समस्याएँ आ रही हैं। कृपया बाद में पुनः प्रयास करें।';

  @override
  String get settingsTitle => 'सेटिंग्स';

  @override
  String get darkmode => 'विषय';

  @override
  String get darkmode_dark => 'अँधेरा';

  @override
  String get darkmode_light => 'रोशनी';

  @override
  String get darkmode_system_default => 'प्रणालीगत चूक';

  @override
  String get thanks_for_contributing => 'योगदान के लिए धन्यवाद!';

  @override
  String get contributors_label => 'वे ऐप बना रहे हैं';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'योगदानकर्ता: $name';
  }

  @override
  String get contributors_description => 'इस ऐप के सभी योगदानकर्ताओं की सूची';

  @override
  String get support => 'सहायता';

  @override
  String get support_join_slack => 'हमारे स्लैक चैनल में मदद मांगें';

  @override
  String get support_via_forum => 'हमारे मंच पर सहायता मांगें';

  @override
  String get support_via_email => 'हमें एक ईमेल भेजो';

  @override
  String get support_via_email_include_logs_dialog_title => 'ऐप लॉग भेजें?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'क्या आप अपने ईमेल में आवेदन लॉग संलग्न करना चाहते हैं?';

  @override
  String get termsOfUse => 'उपयोग की शर्तें';

  @override
  String get legalNotices => 'कानूनी नोटिस';

  @override
  String get privacy_policy => 'गोपनीयता नीति';

  @override
  String get about_this_app => 'इस ऐप के बारे में';

  @override
  String get contribute => 'Contribute';

  @override
  String get contribute_sw_development => 'सॉफ्टवेयर डेवलपमेंट';

  @override
  String get contribute_develop_text =>
      'हर ओपन फ़ूड फ़ैक्ट्स उत्पाद का कोड GitHub पर उपलब्ध है। आप इस कोड का पुनः उपयोग कर सकते हैं (यह ओपन सोर्स है) और इसे दुनिया भर के सभी लोगों के लिए बेहतर बनाने में हमारी मदद कर सकते हैं।';

  @override
  String get contribute_develop_text_2 =>
      'आप ओपन फूड फैक्ट्स स्लैक चैटरूम में शामिल हो सकते हैं जो प्रश्न पूछने का पसंदीदा तरीका है।';

  @override
  String get contribute_develop_dev_mode_title => 'देव मोड?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'DEV मोड सक्रिय करें';

  @override
  String get contribute_donate_title => 'दान करें';

  @override
  String get contribute_donate_header => 'ओपन फ़ूड फैक्ट्स को दान करें';

  @override
  String get contribute_enroll_alpha_warning =>
      'कृपया ध्यान रखें कि आंतरिक अल्फा संस्करण के साथ, डेटा की पूर्ण हानि संभव है, और ऐप किसी भी समय अनुपयोगी हो सकता है!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'पूरे किए जाने वाले उत्पाद';

  @override
  String get contribute_improve_header => 'में सुधार';

  @override
  String get contribute_improve_text =>
      'डेटाबेस इस परियोजना का मूल है। इससे मदद करना आसान और बहुत तेज़ है। आप अपने फ़ोन के लिए मोबाइल ऐप डाउनलोड कर सकते हैं और उत्पादों को जोड़ना या उनमें सुधार करना शुरू कर सकते हैं।\n\nदूसरी ओर, ओपन फ़ूड फ़ैक्ट्स वेबसाइट योगदान करने के कई तरीके प्रदान करती है: ';

  @override
  String get contribute_translate_header => 'अनुवाद';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'अनुवाद शुरू करें';

  @override
  String get contribute_translate_text =>
      'ओपन फ़ूड फैक्ट्स एक वैश्विक परियोजना है जिसमें 160 से ज़्यादा देशों के उत्पाद शामिल हैं। ओपन फ़ूड फैक्ट्स का दर्जनों भाषाओं में अनुवाद किया जाता है और इसकी सामग्री लगातार विकसित होती रहती है।';

  @override
  String get contribute_translate_text_2 =>
      'अनुवाद इस परियोजना के प्रमुख कार्यों में से एक है';

  @override
  String get contribute_join_skill_pool =>
      'Contribute your skills to Open Food Facts. Join the skill pool!';

  @override
  String get contribute_share_header =>
      'अपने दोस्तों के साथ खुले भोजन के तथ्य साझा करें';

  @override
  String get contribute_share_content =>
      'मैं आपको उस ऐप के बारे में बताना चाहता हूँ जिसका मैं इस्तेमाल करता हूँ, \"ओपन फ़ूड फैक्ट्स\", जो आपको अपने खाने के स्वास्थ्य और पर्यावरण पर पड़ने वाले प्रभावों को व्यक्तिगत रूप से जानने की सुविधा देता है। यह पैकेजिंग पर दिए गए बारकोड को स्कैन करके काम करता है। यह मुफ़्त है, इसके लिए पंजीकरण की आवश्यकता नहीं है, और आप डिक्रिप्ट किए गए उत्पादों की संख्या बढ़ाने में भी मदद कर सकते हैं। इसे अपने फ़ोन पर डाउनलोड करने के लिए यह लिंक है: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'अपने लॉयल्टी कार्ड डेटा के GDPR निर्यात का अनुरोध करके कीमतों में योगदान करें';

  @override
  String get tap_to_answer => 'प्रश्नों के उत्तर देने के लिए यहां टैप करें';

  @override
  String get tap_to_answer_hint =>
      'इस उत्पाद के बारे में प्रश्नों के उत्तर देने के लिए यहां टैप करें';

  @override
  String get robotoff_questions_loading_hint =>
      'कृपया इस उत्पाद के बारे में प्रश्न लोड होने तक प्रतीक्षा करें';

  @override
  String get saving_answer => 'आपका उत्तर सहेजा जा रहा है';

  @override
  String get contribute_to_get_rewards => 'खाद्य पारदर्शिता के अभिनेता बनें';

  @override
  String get question_sign_in_text =>
      'अपने योगदान का श्रेय पाने के लिए अपने ओपन फ़ूड फैक्ट्स खाते में साइन इन करें';

  @override
  String get question_yes_button_accessibility_value => 'हाँ में उत्तर दें';

  @override
  String get question_no_button_accessibility_value => 'उत्तर दें: नहीं';

  @override
  String get question_skip_button_accessibility_value => 'इस प्रश्न को छोड़ें';

  @override
  String get tap_to_edit_search => 'खोज संपादित करने के लिए टैप करें';

  @override
  String get myPreferences => 'मेरी वरीयताएं';

  @override
  String get account_create_message =>
      'अपना खाता बनाएं और दुनिया भर में खाद्य ज्ञान का निर्माण करने में मदद करने के लिए ओपन फूड फैक्ट्स समुदाय में शामिल हों!';

  @override
  String get join_us => 'हमसे जुड़ें';

  @override
  String get myPreferences_profile_title => 'आपकी प्रोफ़ाइल';

  @override
  String get myPreferences_profile_subtitle =>
      'अपने ओपन फ़ूड फैक्ट्स योगदानकर्ता खाते का प्रबंधन करें।';

  @override
  String get myPreferences_settings_title => 'ऐप सेटिंग्स';

  @override
  String get myPreferences_settings_subtitle => 'डार्क मोड, भाषाएँ…';

  @override
  String get myPreferences_food_title => 'खाद्य प्राथमिकताएँ';

  @override
  String get myPreferences_food_subtitle =>
      'भोजन के बारे में कौन सी जानकारी आपके लिए सबसे अधिक महत्वपूर्ण है, इसका चयन करें।';

  @override
  String get myPreferences_food_comment =>
      'चुनें कि खाने के बारे में कौन सी जानकारी आपके लिए सबसे ज़्यादा मायने रखती है, ताकि आप अपनी पसंद के अनुसार खाने को रैंक कर सकें, सबसे पहले वह जानकारी देख सकें जो आपको पसंद है, और उसकी अनुकूलता का सारांश प्राप्त कर सकें। ये खाने की प्राथमिकताएँ आपके डिवाइस पर ही रहती हैं, और अगर आपका कोई ओपन फ़ूड फ़ैक्ट्स योगदानकर्ता खाता है, तो उससे जुड़ी नहीं होतीं।';

  @override
  String get confirmResetPreferences =>
      'अपनी भोजन संबंधी प्राथमिकताएं पुनः निर्धारित करें?';

  @override
  String get myPersonalizedRanking => 'मेरी व्यक्तिगत रैंकिंग';

  @override
  String get ranking_tab_all => 'सभी';

  @override
  String get ranking_subtitle_match_yes => 'आपके लिए एक बढ़िया मैच';

  @override
  String get ranking_subtitle_match_no => 'बहुत ख़राब मैच';

  @override
  String get ranking_subtitle_match_maybe => 'अज्ञात मिलान';

  @override
  String get refresh_with_new_preferences =>
      'अपनी नई प्राथमिकताओं के साथ सूची को ताज़ा करें';

  @override
  String get reloaded_with_new_preferences =>
      'आपकी नई प्राथमिकताओं के साथ पुनः लोड किया गया';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'स्कैन';

  @override
  String get history_navbar_label => 'वृत्तांत';

  @override
  String get list_navbar_label => 'सूचियों';

  @override
  String get category => 'श्रेणी के अनुसार फ़िल्टर करें';

  @override
  String get category_all => 'सभी';

  @override
  String get category_search => '(श्रेणी खोज)';

  @override
  String get filter => 'फ़िल्टर';

  @override
  String get scan => 'स्कैन स्क्रीन से उत्पाद';

  @override
  String get scan_history => 'स्कैन इतिहास';

  @override
  String get search => 'ढूंढें';

  @override
  String get search_product_help => 'कोई उत्पाद,\nकोई ब्रांड या बारकोड खोजें';

  @override
  String get search_filter => 'खोज फ़िल्टर';

  @override
  String get search_history => 'खोज इतिहास';

  @override
  String get search_store => 'स्टोर खोजें';

  @override
  String get search_store_help => 'संकेत: शहर या देश जोड़ें';

  @override
  String get tap_for_more => 'अधिक जानकारी देखने के लिए टैप करें…';

  @override
  String get product => 'उत्पाद';

  @override
  String get unknownBrand => 'अज्ञात ब्रांड';

  @override
  String get unknownQuantity => 'अज्ञात मात्रा';

  @override
  String get unknownProductName => 'अज्ञात उत्पाद का नाम';

  @override
  String get label_refresh => 'रीफ्रेश करें';

  @override
  String get label_reload => 'पुनः लोड करें';

  @override
  String get image => 'छवि';

  @override
  String get front_photo => 'सामने की तस्वीर';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (यह छवि पुरानी हो सकती है)';
  }

  @override
  String get outdated_image_short_label => 'पुराना हो सकता है';

  @override
  String get ingredients => 'सामग्री';

  @override
  String get ingredients_editing_instructions =>
      'मूल क्रम रखें। निर्दिष्ट होने पर प्रतिशत बताएँ। किसी सामग्री के अवयवों के लिए अल्पविराम या हाइफ़न से अलग करें और कोष्ठक का उपयोग करें।';

  @override
  String get ingredients_editing_error => 'सामग्री को सहेजने में विफल.';

  @override
  String get ingredients_editing_image_error =>
      'नई सामग्री छवि प्राप्त करने में विफल.';

  @override
  String get ingredients_editing_title => 'सामग्री संपादित करें';

  @override
  String get ingredients_photo => 'सामग्री की तस्वीर';

  @override
  String get packaging_editing_instructions =>
      'सभी पैकेजिंग भागों को अल्पविराम या लाइन फीड से अलग करके सूचीबद्ध करें, उनकी मात्रा (उदाहरण के लिए 1 या 6), प्रकार (उदाहरण के लिए बोतल, बॉक्स, कैन), सामग्री (उदाहरण के लिए प्लास्टिक, धातु, एल्युमीनियम) और यदि उपलब्ध हो तो उनका आकार (उदाहरण के लिए 33cl) और रीसाइक्लिंग निर्देश।\nउदाहरण: रीसायकल करने के लिए 1 कांच की बोतल, फेंकने के लिए 1 प्लास्टिक का कॉर्क';

  @override
  String get packaging_editing_error => 'पैकेजिंग सहेजने में विफल.';

  @override
  String get packaging_editing_image_error =>
      'नई पैकेजिंग छवि प्राप्त करने में विफल.';

  @override
  String get packaging_editing_title => 'पैकेजिंग संपादित करें';

  @override
  String get nutrition => 'पोषण';

  @override
  String get nutrition_facts_photo => 'पोषण तथ्य फोटो';

  @override
  String get nutrition_facts_editing_title => 'पोषण तथ्य संपादित करें';

  @override
  String get packaging_information => 'पुनर्चक्रण निर्देश';

  @override
  String get packaging_information_photo => 'रीसाइक्लिंग निर्देश फोटो';

  @override
  String get missing_product => 'आपको एक नया उत्पाद मिला!';

  @override
  String get add_product_take_photos =>
      'इस उत्पाद को ओपन फ़ूड फैक्ट्स में जोड़ने के लिए पैकेजिंग की तस्वीरें लें';

  @override
  String get add_product_take_photos_descriptive =>
      'कृपया पहले कुछ तस्वीरें ले लें। आप बाद में कभी भी उत्पाद पूरा कर सकते हैं।';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'नए उत्पाद';

  @override
  String get new_product_found_title => 'नया उत्पाद मिला!';

  @override
  String get new_product_found_text =>
      'हमारे सहयोगी डेटाबेस में **3 मिलियन से अधिक उत्पाद** हैं, लेकिन यह बारकोड मौजूद नहीं है: ';

  @override
  String get new_product_found_button => 'इस उत्पाद को ऐड करें';

  @override
  String get new_product_leave_title => 'इस पृष्ठ को छोड़ो?';

  @override
  String get new_product_leave_message =>
      'ऐसा लगता है कि आपने कुछ भी इनपुट नहीं किया। क्या आप वाकई यह पेज छोड़ना चाहते हैं?';

  @override
  String get new_product_dialog_description =>
      'कृपया इस उत्पाद को हमारे सामान्य डेटाबेस में जोड़ने के लिए पैकेजिंग की तस्वीरें लें';

  @override
  String get new_product_dialog_illustration_description =>
      'अज्ञात न्यूट्री-स्कोर और ग्रीन स्कोर के साथ एक चित्रण';

  @override
  String get front_packaging_photo_button_label =>
      'सामने की पैकेजिंग की तस्वीर';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'फ्रंट पैकेजिंग फ़ोटो अपलोड करने की पुष्टि करें';

  @override
  String get confirm_button_label => 'पुष्टि करना';

  @override
  String get send_image_button_label => 'छवि भेजें';

  @override
  String get crop_page_action_saving => 'छवि सहेजना…';

  @override
  String get crop_page_action_cropping => 'छवि को क्रॉप करना…';

  @override
  String get crop_page_action_local => 'स्थानीय संस्करण सहेजना…';

  @override
  String get crop_page_action_local_failed_title =>
      'ओह… आपकी फोटो में कुछ गड़बड़ है!';

  @override
  String get crop_page_action_local_failed_message =>
      'हम छवि को अपने सर्वर पर भेजने से पहले, स्थानीय रूप से संसाधित नहीं कर पा रहे हैं। कृपया बाद में पुनः प्रयास करें या यदि समस्या बनी रहती है, तो हमसे संपर्क करें।';

  @override
  String get crop_page_action_retake => 'फ़ोटो दोबारा लें';

  @override
  String get crop_page_too_small_image_title => 'छवि बहुत छोटी है!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'चित्र अपलोड करने के लिए पिक्सेल में न्यूनतम आकार ${expectedMinWidth}x$expectedMinHeightहै। वर्तमान चित्र ${actualWidth}x$actualHeightहै।';
  }

  @override
  String get crop_page_action_server => 'सर्वर पर कॉल की तैयारी…';

  @override
  String get front_packaging_photo_title => 'सामने की पैकेजिंग फोटो';

  @override
  String get ingredients_photo_title => 'सामग्री फोटो';

  @override
  String get nutritional_facts_photo_title => 'पोषण तथ्य फोटो';

  @override
  String get recycling_photo_title => 'पुनर्चक्रण संबंधी निर्देश (फोटो)';

  @override
  String get take_photo_title => 'एक तस्वीर ले लो';

  @override
  String get take_more_photo_title => 'और तस्वीरें लें';

  @override
  String get front_photo_uploaded => 'सामने की तस्वीर अपलोड की गई';

  @override
  String get ingredients_photo_button_label => 'सामग्री की तस्वीर';

  @override
  String get ingredients_photo_uploaded => 'सामग्री की तस्वीर अपलोड की गई';

  @override
  String get nutrition_cache_loading_error =>
      'कैश से पोषक तत्व लोड करने में असमर्थ';

  @override
  String get nutritional_facts_photo_button_label => 'पोषण तथ्य फोटो';

  @override
  String get nutritional_facts_input_button_label => 'पोषण संबंधी तथ्य भरें';

  @override
  String get nutritional_facts_added => 'पोषण संबंधी तथ्य जोड़े गए';

  @override
  String get categories_added => 'श्रेणियाँ जोड़ी गईं';

  @override
  String get new_product_title_nutriscore => 'Compute the Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'कम से कम एक श्रेणी और पोषण संबंधी मान भरकर हमारी सहायता करें';

  @override
  String get new_product_title_environmental_score =>
      'ग्रीन स्कोर की गणना करें';

  @override
  String get new_product_subtitle_environmental_score =>
      'कम से कम एक श्रेणी भरकर इसे प्राप्त करें';

  @override
  String get new_product_additional_environmental_score =>
      'उत्पत्ति, पैकेजिंग और अन्य जानकारी के साथ ग्रीन स्कोर की गणना को अधिक सटीक बनाएं';

  @override
  String get new_product_title_nova =>
      'खाद्य प्रसंस्करण स्तर (NOVA) की गणना करें';

  @override
  String get new_product_subtitle_nova =>
      'खाद्य श्रेणी और सामग्री भरकर इसे प्राप्त करें';

  @override
  String get new_product_desc_nova_unknown => 'खाद्य प्रसंस्करण स्तर अज्ञात';

  @override
  String get new_product_title_pictures => 'नए उत्पाद';

  @override
  String get new_product_title_pictures_details =>
      'Please take the following photos and the Open Food Facts engine can work out the rest!';

  @override
  String get new_product_title_misc => 'और कुछ बुनियादी डेटा…';

  @override
  String new_product_done_msg(String username) {
    return 'आपके योगदान के लिए धन्यवाद “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'आपके योगदान के लिए धन्यवाद!';

  @override
  String get new_product_done_button_label => 'पूर्ण उत्पाद की खोज करें';

  @override
  String get hey_incomplete_product_message =>
      'न्यूट्री-स्कोर, ग्रीन स्कोर और अल्ट्रा-प्रोसेसिंग (नोवा) की गणना करने के लिए अभी 3 प्रश्नों के उत्तर देने के लिए टैप करें!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'इस कॉस्मेटिक का विश्लेषण करने में सहायता के लिए 2 प्रश्नों के उत्तर देने हेतु अभी टैप करें!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'इस पालतू पशु खाद्य उत्पाद का विश्लेषण करने में सहायता के लिए 3 प्रश्नों के उत्तर देने हेतु अभी टैप करें!';

  @override
  String get hey_incomplete_product_message_product =>
      'इस उत्पाद को पूरा करने में सहायता के लिए अभी टैप करें!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'पोषण संबंधी तथ्यों की तस्वीर अपलोड की गई';

  @override
  String get recycling_photo_button_label => 'रीसाइक्लिंग फोटो';

  @override
  String get recycling_photo_uploaded => 'रीसाइक्लिंग फ़ोटो अपलोड की गई';

  @override
  String get take_more_photo_button_label => 'और तस्वीरें लें';

  @override
  String get other_photo_uploaded => 'विविध फ़ोटो अपलोड की गईं';

  @override
  String get retake_photo_button_label => 'फिर से लेना';

  @override
  String get selecting_photo => 'फ़ोटो का चयन';

  @override
  String get uploading_image => 'सर्वर पर फ़ोटो अपलोड करना';

  @override
  String get uploading_image_type_front =>
      'ओपन फ़ूड फैक्ट्स पर सामने की छवि अपलोड की जा रही है';

  @override
  String get uploading_image_type_ingredients =>
      'ओपन फ़ूड फैक्ट्स में सामग्री की छवि अपलोड करना';

  @override
  String get uploading_image_type_nutrition =>
      'ओपन फ़ूड फैक्ट्स पर पोषण संबंधी छवि अपलोड करना';

  @override
  String get uploading_image_type_packaging =>
      'ओपन फ़ूड फैक्ट्स पर पैकेजिंग छवि अपलोड करना';

  @override
  String get uploading_image_type_other =>
      'ओपन फ़ूड फैक्ट्स पर अन्य छवि अपलोड की जा रही है';

  @override
  String get uploading_image_type_generic =>
      'ओपन फ़ूड फैक्ट्स पर छवि अपलोड की जा रही है';

  @override
  String get score_add_missing_ingredients => 'लुप्त सामग्री जोड़ें';

  @override
  String get score_add_missing_packaging_image =>
      'अनुपलब्ध पैकेजिंग छवि जोड़ें';

  @override
  String get score_add_missing_nutrition_facts => 'लुप्त पोषण तथ्य जोड़ें';

  @override
  String get score_add_missing_product_traces => 'गुम उत्पाद अंश जोड़ें';

  @override
  String get score_add_missing_product_category => 'एक श्रेणी चुनें';

  @override
  String get score_add_missing_precise_product_category =>
      'अधिक सटीक श्रेणी चुनें';

  @override
  String get score_add_missing_product_countries =>
      'अनुपलब्ध उत्पाद देशों को जोड़ें';

  @override
  String get score_add_missing_product_emb =>
      'गुम उत्पाद ट्रेसिबिलिटी कोड जोड़ें';

  @override
  String get score_add_missing_product_labels => 'अनुपलब्ध उत्पाद लेबल जोड़ें';

  @override
  String get score_add_missing_product_origins => 'अनुपलब्ध उत्पाद मूल जोड़ें';

  @override
  String get score_add_missing_product_stores => 'अनुपलब्ध उत्पाद स्टोर जोड़ें';

  @override
  String get score_add_missing_product_brands => 'गायब उत्पाद ब्रांड जोड़ें';

  @override
  String get score_update_nutrition_facts => 'पोषण संबंधी तथ्यों को अपडेट करें';

  @override
  String get nutrition_page_title => 'पोषण तथ्य';

  @override
  String get nutrition_page_nutritional_info_title => 'पोषण संबंधी जानकारी';

  @override
  String get nutrition_page_nutritional_info_label =>
      'उत्पाद पर निर्दिष्ट मान:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'हाँ';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'नहीं';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'फ़ोटो खोलें';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'अच्छे अभ्यास: पोषण संबंधी जानकारी';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'कभी-कभी पोषण संबंधी तथ्य **पैकेजिंग पर** या उत्पाद के साथ दिए गए दस्तावेज़ पर निर्दिष्ट नहीं होते हैं। इस स्थिति में, और केवल इसी स्थिति में, आप मान को **नहीं** पर सेट कर सकते हैं।';

  @override
  String get nutrition_page_serving_type_label => 'पौषणिक मूल्य:';

  @override
  String get nutrition_page_per_100g => 'प्रति 100 ग्राम';

  @override
  String get nutrition_page_per_100g_100ml => 'प्रति 100 ग्राम/एमएल';

  @override
  String get nutrition_page_per_serving => 'प्रत्येक हिस्सा';

  @override
  String get nutrition_page_add_nutrient => 'एक पोषक तत्व जोड़ें';

  @override
  String get nutrition_page_serving_size => 'सेवारत माप';

  @override
  String get nutrition_page_serving_size_hint =>
      'सर्विंग साइज़ दर्ज करें (उदाहरण: 100 ग्राम)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'अच्छे अभ्यास: परोसने का आकार';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'यह मान **प्रति सर्विंग आकार में प्रत्येक पोषक तत्व की आनुपातिक गणना करने** में मदद करता है।';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**अनुमत इकाइयाँ** हैं: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨।';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 ग्राम**, **60 ग्राम** या **60 ग्राम** (पहले वाले को प्राथमिकता दें)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 मिली** या **1 लीटर**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'अमान्य इकाई';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 ग्राम';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'अमान्य इकाइयाँ';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 कैंडीज और 2 बिस्कुट';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'गुम इकाई';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'अमान्य संख्या';

  @override
  String get nutrition_page_update_running => 'सर्वर पर उत्पाद को अपडेट करना…';

  @override
  String get nutrition_page_update_done => 'उत्पाद अद्यतन!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'उत्पाद की मात्रा को सर्विंग साइज़ के रूप में उपयोग करें';

  @override
  String get nutrition_page_photo_error => 'फ़ोटो लोड करने में असमर्थ';

  @override
  String get more_photos => 'और भी दिलचस्प तस्वीरें';

  @override
  String get view_more_photo_button => 'इस उत्पाद की सभी मौजूदा तस्वीरें देखें';

  @override
  String get no_product_found => 'कोई उत्पाद नहीं मिला';

  @override
  String get no_location_found => 'कोई स्थान नहीं मिला';

  @override
  String get not_found => 'नहीं मिला:';

  @override
  String get refreshing_product => 'ताज़ा उत्पाद';

  @override
  String get product_refreshed => 'उत्पाद ताज़ा';

  @override
  String product_image_accessibility_label(String date) {
    return 'छवि $dateपर ली गई';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'चित्र $dateपर लिया गया। यह चित्र पुराना हो सकता है';
  }

  @override
  String get product_image_outdated => 'यह छवि पुरानी हो सकती है';

  @override
  String get product_image_outdated_explanations_title =>
      'यह छवि पुरानी हो सकती है';

  @override
  String get product_image_outdated_explanations_content =>
      'यह तस्वीर एक साल से भी ज़्यादा समय पहले ली गई थी।\n**कृपया जाँच लें कि यह अभी भी अद्यतित है**।\n\nयह **सिर्फ़ एक चेतावनी** है। अगर सामग्री अभी भी वही है, तो आप इस संदेश को अनदेखा कर सकते हैं।';

  @override
  String product_image_action_replace_photo(String type) {
    return 'फ़ोटो बदलें ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'फ़ोटो जोड़ें ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'एक तस्वीर ले लो';

  @override
  String get product_image_action_from_gallery => 'अपने फ़ोन की गैलरी से चुनें';

  @override
  String get product_image_action_choose_existing_photo =>
      'उत्पाद फ़ोटो में से चुनें';

  @override
  String get product_image_details_label => 'फोटो के बारे में जानकारी';

  @override
  String get product_image_details_from_producer => 'निर्माता से';

  @override
  String get product_image_details_contributor => 'सहयोगी';

  @override
  String get product_image_details_contributor_producer =>
      'योगदानकर्ता (निर्माता)';

  @override
  String get product_image_details_date => 'तारीख';

  @override
  String get product_image_details_date_unknown => 'अज्ञात';

  @override
  String get homepage_main_card_logo_description =>
      'ओपन फ़ूड फैक्ट्स में आपका स्वागत है';

  @override
  String get homepage_main_card_subheading =>
      'किसी उत्पाद के लिए बारकोड **स्कैन** करें या\n**खोजें**';

  @override
  String get homepage_main_card_search_field_hint => 'किसी उत्पाद की खोज करें';

  @override
  String get homepage_main_card_search_field_tooltip => 'खोज शुरू करें';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'नवीनतम समाचार: $news_title';
  }

  @override
  String get tagline_app_review => 'क्या आपको ऐप पसंद आया?';

  @override
  String get tagline_app_review_button_positive => 'मुझे यह बहुत पसंद है!';

  @override
  String get tagline_app_review_button_negative => 'वास्तव में नहीं…';

  @override
  String get tagline_app_review_button_later => 'मुझसे बाद में पूछें';

  @override
  String get tagline_feed_news_button => 'अधिक जानते हैं';

  @override
  String get app_review_negative_modal_title => 'आपको हमारा ऐप पसंद नहीं आया?';

  @override
  String get app_review_negative_modal_text =>
      'क्या आप हमें कुछ सेकंड देकर बता सकते हैं कि ऐसा क्यों है?';

  @override
  String get app_review_negative_modal_positive_button => 'हां बिल्कुल!';

  @override
  String get app_review_negative_modal_negative_button => 'नहीं';

  @override
  String get could_not_refresh => 'उत्पाद रीफ़्रेश नहीं किया जा सका';

  @override
  String get product_internet_error_modal_title => 'एक गलती हुई है!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'नेटवर्क त्रुटि के कारण हम इस उत्पाद के बारे में जानकारी प्राप्त करने में असमर्थ हैं। कृपया अपना इंटरनेट कनेक्शन जांचें और पुनः प्रयास करें।\n\nआंतरिक त्रुटि:\n$error';
  }

  @override
  String get product_tags_title => 'उत्पाद के गुण';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'कोई संपत्ति नहीं';

  @override
  String get product_tags_explanation =>
      'किसी उत्पाद में गुण (कुंजी/मूल्य) जोड़कर, आप उसे समृद्ध बनाने में मदद करते हैं।';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'गुण जोड़ें';

  @override
  String get add_edit_tags => 'गुण जोड़ें या संपादित करें';

  @override
  String get edit_tag => 'संपत्ति संपादित करें';

  @override
  String get remove_tag => 'संपत्ति हटाएँ';

  @override
  String get tag_key => 'संपत्ति';

  @override
  String get tag_keys => 'गुण';

  @override
  String get tag_key_uneditable => 'संपत्ति (असंपादन योग्य)';

  @override
  String get tag_key_input_hint => 'एक संपत्ति इनपुट करें';

  @override
  String get tag_value => 'मूल्य';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'एक मान इनपुट करें';

  @override
  String get tag_key_item => 'संपत्ति:';

  @override
  String get tag_value_item => 'कीमत:';

  @override
  String get tag_key_explanations =>
      'कुंजी लोअरकेस में तथा बिना किसी रिक्त स्थान के होनी चाहिए।';

  @override
  String tag_key_already_exists(String property) {
    return '$property गुण वाला एक टैग पहले से मौजूद है!';
  }

  @override
  String get product_internet_error =>
      'नेटवर्क त्रुटि के कारण इस उत्पाद के बारे में जानकारी प्राप्त करना असंभव है।';

  @override
  String get cached_results_from => 'परिणाम दिखाएँ:';

  @override
  String get product_search_same_category => 'विकल्प खोजें';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'इस सुविधा का उपयोग केवल श्रेणी वाले उत्पादों के लिए किया जा सकता है।\n\nश्रेणी जोड़ने के लिए कृपया उत्पाद को संपादित करें।';

  @override
  String get product_improvement_add_category =>
      'Add a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Add nutrition facts to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Add nutrition facts and a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'इस उत्पाद के लिए न्यूट्री-स्कोर की गणना नहीं की जा सकती, जो कि गैर-मानक श्रेणी के कारण हो सकता है। अगर इसे त्रुटि माना जाता है, तो कृपया हमसे संपर्क करें।';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'पोषण छवि अप्रचलित है: कृपया इसे ताज़ा करें।';

  @override
  String get product_improvement_origins_to_be_completed =>
      'ग्रीन स्कोर सामग्री की उत्पत्ति को ध्यान में रखता है। कृपया सामग्री सूची और/या किसी भी भौगोलिक दावे की तस्वीर लें या उत्पाद को संपादित करें, ताकि उन्हें ध्यान में रखा जा सके।';

  @override
  String get country_chooser_label => 'कृपया कोई देश चुनें';

  @override
  String get currency_chooser_label => 'कृपया एक मुद्रा चुनें';

  @override
  String get country_change_message => 'आपने अभी-अभी देश बदला है।';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'क्या आप मुद्रा को $previousCurrency से $possibleCurrencyमें बदलना चाहते हैं?';
  }

  @override
  String get onboarding_country_chooser_label => 'कृपया कोई देश चुनें:';

  @override
  String get country_chooser_label_from_settings => 'आपका देश';

  @override
  String get country_selection_explanation =>
      'कुछ पर्यावरणीय विशेषताएँ स्थान-विशिष्ट होती हैं';

  @override
  String get product_removed_comparison => 'उत्पाद को तुलना से हटा दिया गया';

  @override
  String get native_app_settings => 'मूल ऐप सेटिंग्स';

  @override
  String get native_app_description =>
      'ओपन फ़ूड फैक्ट्स के लिए सिस्टम सेटिंग्स खोलें';

  @override
  String get product_removed_history => 'उत्पाद को इतिहास से हटा दिया गया';

  @override
  String get product_removed_list => 'उत्पाद सूची से हटा दिया गया';

  @override
  String get product_could_not_remove => 'उत्पाद हटाया नहीं जा सका';

  @override
  String get no_prodcut_in_list => 'इस सूची में कोई उत्पाद नहीं है';

  @override
  String get no_product_in_section => 'इस अनुभाग में कोई उत्पाद नहीं है';

  @override
  String get recently_seen_products => 'सभी देखे गए उत्पाद';

  @override
  String get clear => 'खाली करें';

  @override
  String get clear_long => 'सूची खाली करें';

  @override
  String get really_clear => 'क्या आप सचमुच इस सूची को हटाना चाहते हैं?';

  @override
  String pct_match(Object percent) {
    return '$percent% मिलान';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count दिन पहले',
      one: 'एक दिन पहले',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count घंटे पहले',
      one: 'एक घंटा पहले',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count मिनट पहले',
      one: 'एक मिनट पहले',
      zero: 'एक मिनट से भी कम समय पहले',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count महीने पहले',
      one: 'एक महीने पहले',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count सप्ताह पहले',
      one: 'एक सप्ताह पहले',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'तुलना करें $count उत्पाद',
      one: 'एक उत्पाद की तुलना करें',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count चयनित उत्पाद',
      one: 'एक चयनित उत्पाद',
      zero: 'कोई चयनित उत्पाद नहीं',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'चयनित उत्पादों की तुलना करें';

  @override
  String get delete_products_mode => 'चयनित उत्पाद हटाएं';

  @override
  String get select_all_products_mode => 'सभी उत्पाद चुनें';

  @override
  String get select_none_products_mode => 'कुछ मत चुनिए';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle =>
      'कृपया कम से कम दो उत्पाद चुनें';

  @override
  String get retry_button_label => 'फिर कोशिश करें  ।';

  @override
  String get connect_with_us => 'हमारे साथ जुड़ें';

  @override
  String get tiktok => 'हमें TikTok पर फ़ॉलो करें';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'हमें इंस्टाग्राम पर फॉलो करें';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'हमें X (पूर्व में ट्विटर) पर फ़ॉलो करें';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'हमें मैस्टोडॉन पर फ़ॉलो करें';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'ब्लूस्काई पर हमें फॉलो करें';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'ब्लॉग';

  @override
  String get faq => 'अक्सर पूछे जाने वाले प्रश्न';

  @override
  String get discover => 'तलाश करें';

  @override
  String get how_to_contribute => 'योगदान कैसे करें';

  @override
  String get hint_knowledge_panel_message =>
      'आप कार्ड के किसी भी हिस्से पर टैप करके, जो आप देख रहे हैं उसके बारे में ज़्यादा जानकारी पा सकते हैं। अभी आज़माएँ!';

  @override
  String get permissions_page_title => 'कैमरा एक्सेस';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'यदि आप अपना विचार बदलते हैं, तो इस विकल्प को सेटिंग्स से किसी भी समय सक्षम और अक्षम किया जा सकता है।';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / रिलीज़: $release)\nमॉडल: $model\nउत्पाद: $product\nडिवाइस: $device\nब्रांड:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'ओएस: iOS ($version)\nमॉडल: $model\nस्थानीयकृत मॉडल: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nऐप संस्करण:$appVersion\nऐप बिल्ड संख्या:$appBuildNumber\nऐप पैकेज नाम:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'अस्वीकार करना';

  @override
  String get ask_me_later_button_label => 'बाद में';

  @override
  String get are_you_sure => 'क्या आपको यकीन है?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'आगे बढ़ें $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'स्वागत !';

  @override
  String get onboarding_home_welcome_text2 =>
      'यह ऐप आपको ऐसा भोजन चुनने में मदद करता है जो आपके और ग्रह के लिए अच्छा है!';

  @override
  String get onboarding_continue_button => 'जारी रखना';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'आपका पहला उदाहरण उत्पाद लोड हो रहा है';

  @override
  String get onboarding_welcome_warning =>
      'क्षमा करें, यह हमारा उदाहरण उत्पाद है, आप इसे संपादित नहीं कर सकते :)';

  @override
  String get product_list_your_ranking => 'आपकी रैंकिंग';

  @override
  String get product_list_empty_icon_desc => 'इतिहास उपलब्ध नहीं है';

  @override
  String get product_list_empty_title => 'स्कैनिंग प्रारंभ करें';

  @override
  String get product_list_empty_message =>
      'स्कैन किए गए उत्पाद यहां दिखाई देंगे और आप उनके बारे में विस्तृत जानकारी देख सकते हैं';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'उत्पाद',
      one: 'उत्पाद',
      zero: 'उत्पाद',
    );
    return 'आपके इतिहास में $_temp0 ताज़ा किया जा रहा है';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'उत्पाद',
      one: 'उत्पाद',
      zero: 'उत्पाद',
    );
    return '$_temp0 ताज़ाकरण पूर्ण';
  }

  @override
  String get product_list_compare_side_by_side => 'साथ-साथ तुलना करें';

  @override
  String get loading_dialog_default_title => 'डेटा डाउनलोड करना';

  @override
  String get loading_dialog_default_error_message =>
      'डेटा डाउनलोड नहीं किया जा सका';

  @override
  String get account_delete => 'खाता हटा दो';

  @override
  String get account_delete_title => 'मेरा एकाउंट हटा दो';

  @override
  String get user_profile => 'खाता';

  @override
  String get user_profile_title_guest => 'स्वागत!';

  @override
  String get user_profile_subtitle_guest =>
      'ओपन फ़ूड फैक्ट्स समुदाय में शामिल होने के लिए साइन-इन या साइन-अप करें';

  @override
  String user_profile_title_id_email(String email) {
    return 'खाद्य तथ्य लॉगिन खोलें: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'स्वागत है $id!';
  }

  @override
  String get email_subject_account_deletion => 'खाता हटा दो';

  @override
  String email_body_account_deletion(String userId) {
    return 'नमस्ते, कृपया मेरा Open Food Facts खाता हटा दें: $userId';
  }

  @override
  String get settings_app_app => 'आवेदन';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'कैमरा';

  @override
  String get settings_app_products => 'उत्पादों';

  @override
  String get settings_app_miscellaneous => 'मिश्रित';

  @override
  String get camera_play_sound_title => 'स्कैन करते समय ध्वनि बजाएँ';

  @override
  String get camera_play_sound_subtitle => 'प्रत्येक सफल स्कैन पर बीप बजेगी';

  @override
  String get camera_window_accessibility_label =>
      'अपने कैमरे से बारकोड स्कैन करें';

  @override
  String get app_haptic_feedback_title => 'कंपन और स्पर्श';

  @override
  String get app_haptic_feedback_subtitle =>
      'कुछ क्रियाएँ निष्पादित करने के बाद कंपन (बारकोड डिकोड किया गया, उत्पाद हटाया गया…)।';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'सक्षम होने पर, क्रैश रिपोर्ट स्वचालित रूप से ओपन फूड फैक्ट्स की त्रुटि ट्रैकिंग प्रणाली को प्रस्तुत की जाती है, ताकि बग को ठीक किया जा सके और इस प्रकार ऐप को बेहतर बनाया जा सके।';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'फ़ोटो संपादित करें';

  @override
  String get permission_photo_error => 'गलती';

  @override
  String get permission_photo_denied_title =>
      'बारकोड स्कैन करने के लिए कैमरे के उपयोग की अनुमति दें';

  @override
  String permission_photo_denied_message(String appName) {
    return 'बेहतर अनुभव के लिए, कृपया $appName को अपने कैमरे तक पहुँचने दें। आप सीधे बारकोड स्कैन कर पाएँगे।';
  }

  @override
  String get permission_photo_denied_button => 'अनुमति दें';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'अनुमति नहीं मिली';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'चूंकि आपने पहले कैमरे की अनुमति को अस्वीकार कर दिया था, इसलिए आपको सेटिंग्स से मैन्युअल रूप से इसकी अनुमति देनी होगी।';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'खुली सेटिंग';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'रद्द करें';

  @override
  String get permission_photo_none_found => 'कोई कैमरा नहीं मिला';

  @override
  String get permission_photo_denied => 'कैमरे तक पहुंच नहीं दी गई';

  @override
  String get show_product_pictures => 'उत्पाद चित्र दिखाएं';

  @override
  String get edit_product_label => 'उत्पाद संपादित करें';

  @override
  String get edit_product_pending_operations_banner_title =>
      'आपके संपादन अपलोड हो रहे हैं…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'आपके संपादन **पृष्ठभूमि में भेजे जा रहे हैं** (या त्रुटि की स्थिति में बाद में)।\nआप अन्य उत्पाद फ़ील्ड का संपादन जारी रख सकते हैं।';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'आपके संपादन **पृष्ठभूमि में** भेजे जा रहे हैं (या त्रुटि होने पर बाद में)।';

  @override
  String get edit_product_label_short => 'संपादित करें';

  @override
  String edit_product_form_item_help(String value) {
    return '\"$value\" कैसे दर्ज करें?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'कृपया एक गैर-रिक्त मान दर्ज करें!';

  @override
  String get edit_product_form_item_error_existing =>
      'यह मान पहले से ही मौजूद है!';

  @override
  String get edit_product_form_item_add_action_brand => 'एक नया ब्रांड जोड़ें';

  @override
  String get edit_product_form_item_add_action_label => 'एक नया लेबल जोड़ें';

  @override
  String get edit_product_form_item_add_action_store => 'एक नया स्टोर जोड़ें';

  @override
  String get edit_product_form_item_add_action_origin => 'एक नया मूल जोड़ें';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'एक नया ट्रेसिबिलिटी कोड जोड़ें';

  @override
  String get edit_product_form_item_add_action_country => 'एक नया देश जोड़ें';

  @override
  String get edit_product_form_item_add_action_category =>
      'एक नई श्रेणी जोड़ें';

  @override
  String get edit_product_form_item_add_action_trace => 'एक नया ट्रेस जोड़ें';

  @override
  String get edit_product_form_item_add_suggestion => 'सुझाव जोड़ें';

  @override
  String get edit_product_form_item_deny_suggestion => 'सुझाव अस्वीकार करें';

  @override
  String get edit_product_form_item_details_title => 'मूल विवरण';

  @override
  String get edit_product_form_item_details_subtitle =>
      'उत्पाद का नाम, ब्रांड, मात्रा';

  @override
  String get edit_product_form_item_other_details_title => 'अतिरिक्त विवरण';

  @override
  String get edit_product_form_item_other_details_subtitle => 'वेबसाइट…';

  @override
  String get edit_product_form_item_photos_title => 'तस्वीरें';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'फ़ोटो जोड़ें या रीफ़्रेश करें';

  @override
  String get edit_product_form_item_labels_title => 'लेबल और प्रमाणन';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'पर्यावरण, गुणवत्ता लेबल…';

  @override
  String get edit_product_form_item_labels_hint =>
      'एक लेबल इनपुट करें (उदाहरण: न्यूट्रीस्कोर)';

  @override
  String get edit_product_form_item_labels_type => 'लेबल';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'अच्छे अभ्यास: लेबल';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'उत्पाद की कोई भी विशेषता **जो तथ्यात्मक हो** और अन्य क्षेत्रों से भिन्न हो।';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'न्यूट्री-स्कोर, नोवा…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'बेल्जियम में निर्मित, ब्रिटनी में उत्पादित…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'आईएसओ 9001, आईएसओ 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'फाइबर से भरपूर, आयरन का स्रोत…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'निष्पक्ष व्यापार, मैक्स हवेलार…';

  @override
  String get edit_product_form_item_stores_title => 'दुकाने';

  @override
  String get edit_product_form_item_stores_hint => 'स्टोर इनपुट करें';

  @override
  String get edit_product_form_item_stores_type => 'दुकान';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'अच्छे अभ्यास: स्टोर';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'उस स्टोर का नाम दर्ज करें जहां से आपने उत्पाद खरीदा था।';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'वॉल-मार्ट';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'CARREFOUR';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'मूल';

  @override
  String get edit_product_form_item_origins_hint =>
      'मूल स्थान दर्ज करें (उदाहरण: जर्मनी)';

  @override
  String get edit_product_form_item_origins_type => 'देश';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'अच्छे अभ्यास: उत्पत्ति';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      '**पैकेजिंग पर मिलने वाले मूल के किसी भी संकेत को जोड़ें**।\nआपको घटक सूची में सीधे संकेतित मूल के बारे में चिंता करने की आवश्यकता नहीं है।';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'अर्जेंटीना से बीफ़';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'सोया यूरोपीय संघ से नहीं आता है';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'कोई देश दर्ज करें (उदाहरण: जर्मनी)';

  @override
  String get edit_product_form_item_countries_type => 'देश';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'अच्छे व्यवहार: देश';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**वे देश जहां उत्पाद व्यापक रूप से उपलब्ध है** (विदेशी उत्पादों में विशेषज्ञता रखने वाली दुकानें शामिल नहीं हैं)।';

  @override
  String get edit_product_form_item_emb_codes_title => 'ट्रेसिबिलिटी कोड';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'एक कोड इनपुट करें (उदाहरण: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'ट्रेसेबिलिटी कोड';

  @override
  String get edit_product_form_item_emb_help_title =>
      'अच्छे अभ्यास: ट्रेसेबिलिटी कोड';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'इस अनुभाग में, आप **पैकेजिंग चिह्न**, **पहचान चिह्न** या **स्वास्थ्य चिह्न** से संबंधित कोड इनपुट कर सकते हैं।';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'ट्रेसेबिलिटी कोड के उदाहरण';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**ई.सी. कोड** यूरोपीय समुदाय में खाद्य उत्पादकों या पैकेजर्स की पहचान करने के लिए उपयोग किया जाता है:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'एफआर\n72.264.002\nसीई';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: **फ्रांस** का देश कोड\n**72.264.002**: भौगोलिक डेटा\n**CE**: यूरोपीय समुदाय';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**फ्रांस में प्रयुक्त EMB कोड**:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'ईएमबी 72264';

  @override
  String get edit_product_form_item_traces_title => 'अवशेष';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'एक ट्रेस इनपुट करें (उदाहरण: सोयाबीन)';

  @override
  String get edit_product_form_item_categories_title => 'श्रेणियाँ';

  @override
  String get edit_product_form_item_categories_hint => 'वर्ग';

  @override
  String get edit_product_form_item_categories_type =>
      'एक श्रेणी दर्ज करें (उदाहरण: संतरे का रस)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'अच्छे अभ्यास: श्रेणियाँ';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      '**केवल सबसे विशिष्ट श्रेणी** इंगित करें।\nमूल श्रेणियां स्वचालित रूप से जोड़ दी जाएंगी।';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'श्रेणी गुम है?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'यदि कोई श्रेणी **स्वतः पूर्ण में उपलब्ध नहीं है**, तो भी उसे जोड़ने में संकोच न करें।\nइससे हमें आपके देश में ओपन फूड फैक्ट्स को बेहतर बनाने में मदद मिलेगी।';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'जैतून के तेल में सार्डिन';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'संतरे का गाढ़ा रस';

  @override
  String get edit_product_form_item_exit_title =>
      'बिना बचत किये नौकरी छोड़ दी?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'क्या आप इस पृष्ठ को छोड़ने से पहले अपने परिवर्तनों को सहेजना चाहते हैं?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'परिवर्तनों को सुरक्षित करें';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'परिवर्तनों को निरस्त करें';

  @override
  String get edit_product_form_item_ingredients_title => 'सामग्री';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'स्क्रीन को पिंच करके ज़ूम इन और आउट करें';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'फ़ोटो को ज़ूम इन और ज़ूम आउट करें';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '**पिंच-टू-ज़ूम जेस्चर** का उपयोग करके, आप फ़ोटो को ज़ूम इन या आउट कर सकते हैं:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'डालिए';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'कृपया पहले एक पाठ दर्ज करें';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'निकालना';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'अपना संपादन सहेजें';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'अपना संपादन रद्द करें';

  @override
  String get edit_product_form_item_packaging_title =>
      'रीसाइक्लिंग निर्देश फोटो';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'पोषण तथ्य';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'पोषण, अल्कोहल सामग्री…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'अच्छे अभ्यास: पोषण तथ्य';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'पौषणिक मूल्य';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'सबसे पहले, चयन करें कि क्या **मान प्रदान किए गए हैं**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'पोषण तथ्य';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'फिर, पोषण संबंधी मान **पैकेजिंग पर दिए गए अनुसार** दर्ज करें। अगर कोई मान नहीं है, तो आप \"आँख\" आइकन पर क्लिक कर सकते हैं।';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'फ़ील्ड गायब है?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'यदि कोई प्रविष्टि छूट गई है, तो आप उसे जोड़ने के लिए **\"प्लस\" आइकन पर क्लिक कर सकते हैं** (उदाहरण: विटामिन डी, मैग्नीशियम…)।';

  @override
  String get edit_product_form_save => 'संपादित करें';

  @override
  String get edit_product_ingredients_photo_title => 'सामग्री की तस्वीर';

  @override
  String get edit_product_ingredients_list_title => 'सामग्री की तालिका';

  @override
  String get edit_product_packaging_photo_title => 'पैकेजिंग फोटो';

  @override
  String get edit_product_packaging_list_title => 'पैकेजिंग सूची';

  @override
  String get no_data_available => 'कोई डेटा मौजूद नहीं';

  @override
  String get product_field_website_title => 'वेबसाइट';

  @override
  String get origins_editing_title => 'मूल संपादित करें';

  @override
  String get completed_basic_details_btn_text => 'बुनियादी विवरण पूरा करें';

  @override
  String get not_implemented_snackbar_text => 'अभी तक कार्यान्वित नहीं';

  @override
  String get category_picker_page_appbar_text => 'श्रेणियाँ';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'फोटो से सामग्री निकालें';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'फ़ोटो से सामग्री\nनिकालना';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'फ़ोटो लोड हो रही है…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'मुझे यह संदेश क्यों दिखाई दे रहा है?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      '\"सामग्री निकालें\" सुविधा का उपयोग करने के लिए, पहले फोटो अपलोड करना होगा।\n\nकृपया कुछ सेकंड प्रतीक्षा करें या उन्हें मैन्युअल रूप से दर्ज करें।';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'फ़ोटो ताज़ा करें';

  @override
  String get edit_packaging_extract_btn_text => 'फ़ोटो से पैकेजिंग\nनिकालें';

  @override
  String get edit_packaging_extract_btn_text_short => 'अर्क पैकेजिंग';

  @override
  String get edit_packaging_extracting_btn_text => 'फोटो से पैकेजिंग निकालना';

  @override
  String get edit_packaging_loading_photo_btn_text => 'फ़ोटो लोड हो रही है…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'मुझे यह संदेश क्यों दिखाई दे रहा है?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      '\"एक्सट्रैक्ट पैकेजिंग\" सुविधा का उपयोग करने के लिए, पहले फोटो अपलोड करना होगा।\n\nकृपया कुछ सेकंड प्रतीक्षा करें या उन्हें मैन्युअल रूप से दर्ज करें।';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'फ़ोटो ताज़ा करें';

  @override
  String get edit_ocr_extract_failed => 'छवि में पाठ का पता लगाने में विफल.';

  @override
  String get edit_ocr_extract_disabled_title => 'कोई तस्वीर नहीं!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'टेक्स्ट निष्कर्षण सुविधा का उपयोग करने के लिए, आपको पहले एक फोटो लेना होगा।';

  @override
  String get user_list_dialog_new_title => 'उत्पादों की नई सूची';

  @override
  String get user_list_dialog_rename_title => 'सूची का नाम बदलें';

  @override
  String get user_list_subtitle_product => 'सूचियों';

  @override
  String get user_list_title => 'आपकी सूचियाँ';

  @override
  String get user_list_add_product => 'उत्पाद को अपनी सूचियों में जोड़ें';

  @override
  String get user_list_button_new => 'एक नई सूची बनाएँ';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'सूची में शामिल';

  @override
  String get added_to_list_msg => 'सूची में जोड़ा गया';

  @override
  String get user_list_popup_clear => 'अपना इतिहास साफ़ करें';

  @override
  String get user_list_popup_rename => 'नाम बदलें';

  @override
  String get user_list_name_hint => 'मेरी सूची';

  @override
  String get user_list_name_error_empty => 'नाम अनिवार्य है';

  @override
  String get user_list_name_error_already => 'वह नाम पहले से ही उपयोग में है';

  @override
  String get user_list_name_error_same => 'यह वही नाम है';

  @override
  String get user_list_name_input_hint => 'सूची का नाम';

  @override
  String get try_again => 'पुनः प्रयास करें';

  @override
  String get there_was_an_error => 'एक त्रुटि हुई';

  @override
  String category_picker_no_category_found_message(String items) {
    return '$itemsके लिए कोई श्रेणी नहीं मिली';
  }

  @override
  String get camera_toggle_camera =>
      'पीछे और सामने वाले कैमरे के बीच स्विच करें';

  @override
  String get camera_toggle_flash => 'कैमरे का फ़्लैश चालू या बंद करें';

  @override
  String get camera_enable_flash => 'फ़्लैश सक्षम करें';

  @override
  String get camera_disable_flash => 'फ़्लैश अक्षम करें';

  @override
  String get camera_flash_error_dialog_title => 'एक त्रुटि पाई गई!';

  @override
  String get camera_flash_error_dialog_message =>
      'आपके फ़्लैश की स्थिति बदलते समय एक त्रुटि हुई। कृपया सुनिश्चित करें कि आपके स्मार्टफ़ोन में टॉर्च पहले से चालू न हो।';

  @override
  String get category_picker_no_category_found_button => 'पीछे';

  @override
  String get user_preferences_item_accessibility_hint =>
      'अपने ब्राउज़र या एप्लिकेशन में खोलने के लिए क्लिक करें (यदि इंस्टॉल है)';

  @override
  String get dev_preferences_screen_title => 'देव मोड';

  @override
  String get dev_preferences_screen_subtitle =>
      'प्रायोगिक सुविधाओं और विकास उपकरणों तक पहुँच';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'ऑनबोर्डिंग पुनः आरंभ करें';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'फिर आपको इसे दोबारा देखने के लिए ऐप को पुनः प्रारंभ करना होगा।';

  @override
  String get dev_preferences_environment_switch_title =>
      'openfoodfacts.org (PROD) और परीक्षण वातावरण के बीच स्विच करें';

  @override
  String get dev_preferences_test_environment_title =>
      'परीक्षण वातावरण पैरामीटर';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'वर्तमान परीक्षण परिवेश के लिए आधार URL: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'परीक्षण वातावरण होस्ट';

  @override
  String get dev_preferences_ml_kit_title => 'एमएल किट का उपयोग करें';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'फिर आपको इस ऐप को पुनः आरंभ करना होगा';

  @override
  String get dev_preferences_product_additional_features_title =>
      'उत्पाद पृष्ठ पर अतिरिक्त बटन';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'ज्ञान पैनल बटन के माध्यम से सामग्री संपादित करें';

  @override
  String get dev_preferences_export_history_title => 'निर्यात इतिहास';

  @override
  String get dev_preferences_export_history_progress_error => 'अपवाद';

  @override
  String get dev_preferences_export_history_progress_found => 'उत्पाद मिला';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'उत्पाद नहीं मिला';

  @override
  String get dev_preferences_export_history_dialog_title => 'निर्यात इतिहास';

  @override
  String get dev_preferences_button_positive => 'ठीक है';

  @override
  String get dev_preferences_button_negative => 'रद्द करें';

  @override
  String get dev_preferences_migration_title => 'V1 से डेटा माइग्रेशन';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'स्थिति: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'सफलता या नई स्थापना';

  @override
  String get dev_preferences_migration_status_success => 'सफलता';

  @override
  String get dev_preferences_migration_status_error => 'गलती';

  @override
  String get dev_preferences_migration_status_in_progress => 'प्रगति पर है';

  @override
  String get dev_preferences_migration_status_required =>
      'आवश्यक (शुरू करने के लिए क्लिक करें)';

  @override
  String get dev_preferences_migration_status_not_started => 'अज्ञात';

  @override
  String get dev_preferences_import_history_subtitle =>
      'इतिहास साफ़ कर देंगे और वहाँ 3 उत्पाद डाल देंगे';

  @override
  String get dev_preferences_news_custom_url_title => 'समाचार के लिए कस्टम URL';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'JSON फ़ाइल का URL:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'सेट नहीं';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'अंतिम रिफ़्रेश: $date';
  }

  @override
  String get product_type_label_food => 'खाना';

  @override
  String get product_type_label_beauty => 'व्यक्तिगत देखभाल';

  @override
  String get product_type_label_pet_food => 'पालतू भोजन';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'उत्पाद का प्रकार';

  @override
  String get product_type_selection_subtitle => 'इस उत्पाद का प्रकार चुनें';

  @override
  String get product_type_selection_empty =>
      'आपको पहले एक उत्पाद प्रकार का चयन करना होगा!';

  @override
  String product_type_selection_already(String productType) {
    return 'आप उत्पाद प्रकार ($productType) नहीं बदल सकते!';
  }

  @override
  String get prices_app_dev_mode_flag => 'उत्पाद पृष्ठ पर मूल्य ऐप का शॉर्टकट';

  @override
  String get prices_app_button => 'कीमतें ऐप पर जाएं';

  @override
  String get prices_website_button => 'ओपन प्राइसेस वेबसाइट पर खोलें';

  @override
  String get prices_bulk_proof_upload_select =>
      'गैलरी से सीधे मूल्य टैग जोड़ें';

  @override
  String get prices_bulk_proof_upload_warning =>
      'एक बार जब आप चित्र चुन लेते हैं, तो आप उन्हें संपादित नहीं कर पाएंगे!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'समुदाय को AI द्वारा निकाली गई कीमतों को मान्य करने की अनुमति दें।';

  @override
  String get prices_bulk_proof_upload_subtitle => 'एकाधिक मूल्य टैग';

  @override
  String get prices_bulk_proof_upload_title => 'बल्क प्रूफ अपलोड';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'फ़ाइलें चुनना';

  @override
  String get prices_bulk_proof_upload_step_starting => 'अपलोड शुरू करना';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'फ़ाइल #$index/$countको स्थानीय रूप से कॉपी किया जा रहा है';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'अपलोड तैयार किया जा रहा है #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'छवि #$index/$countपर विफल';
  }

  @override
  String get prices_generic_title => 'कीमतों';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'मूल्य जोड़ें $count मूल्य',
      one: 'मूल्य जोड़ें',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count कीमतें भेजें',
      one: 'कीमत भेजें',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'एक आइटम जोड़ें';

  @override
  String get prices_add_a_price => 'एक मूल्य जोड़े';

  @override
  String get prices_add_a_receipt => 'रसीद जोड़ें';

  @override
  String get prices_add_price_tags => 'मूल्य टैग जोड़ें';

  @override
  String prices_barcode_already(String barcode) {
    return 'यह बारकोड ($barcode) पहले से ही सूची में है!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'अभी तक कोई उत्पाद नहीं';

  @override
  String prices_barcode_search_running(String barcode) {
    return '$barcodeकी तलाश में';
  }

  @override
  String get prices_barcode_enter => 'बारकोड दर्ज करें';

  @override
  String get prices_category_enter => 'बिना बारकोड वाला आइटम';

  @override
  String get prices_per_kilogram => 'कीमत प्रति किलोग्राम';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / किलोग्राम';

  @override
  String get prices_per_unit_short => ' / इकाई';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'वैकल्पिक';

  @override
  String get prices_category_error_mandatory => 'श्रेणी अनिवार्य है';

  @override
  String get prices_barcode_reader_action => 'बारकोड रीडर';

  @override
  String get prices_view_prices => 'कीमतें देखें';

  @override
  String get prices_list_title => 'मूल्य सूची';

  @override
  String get prices_list_count => '\nकीमतों की संख्या';

  @override
  String get prices_list_add_new_price => '\nनया मूल्य जोड़ें';

  @override
  String get prices_list_empty_title => 'अभी तक कोई कीमत नहीं!';

  @override
  String get prices_list_empty_subtitle =>
      'सबसे पहले जोड़ें:\n**रसीद** या **मूल्य टैग** स्कैन करके!';

  @override
  String get prices_entry_shop_not_found => 'अज्ञात स्टोर';

  @override
  String prices_entry_menu_title(String user) {
    return '\"$user\" से मूल्य प्रविष्टि';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'इस उत्पाद के सभी मूल्य देखें';

  @override
  String get prices_entry_menu_open_proof => 'प्रमाण देखें';

  @override
  String get prices_entry_menu_my_prices => 'मेरी अन्य कीमतें देखें';

  @override
  String get prices_entry_menu_author_prices => 'लेखक द्वारा अन्य मूल्य देखें';

  @override
  String get prices_entry_menu_shop_prices => 'दुकान से अन्य कीमतें देखें';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count मूल्य',
      one: '1 मूल्य',
    );
    return '$_temp0 के लिए $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'सभी $count कीमतें',
      one: 'केवल एक कीमत',
      zero: 'अभी तक कोई कीमत नहीं',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'नवीनतम $pageSize कीमतें (कुल: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'मूल्य: $price / स्टोर: \"$location\" / प्रकाशित: $date द्वारा \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return '\"$user\" के खुले प्रमाण';
  }

  @override
  String get prices_open_proof => 'खुली कीमत का प्रमाण';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'सभी $count प्रमाण',
      one: 'केवल एक प्रमाण',
      zero: 'अभी तक कोई प्रमाण नहीं',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'नवीनतम $pageSize प्रमाण (कुल: $total)';
  }

  @override
  String get prices_users_empty_title => 'अभी तक कोई योगदानकर्ता नहीं!';

  @override
  String get prices_users_empty_explanation =>
      'मूल्य जोड़ने वाले पहले व्यक्ति बनें!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'शीर्ष $pageSize योगदानकर्ता (कुल: $total)';
  }

  @override
  String get prices_locations_empty_title => 'अभी तक कोई दुकान नहीं!';

  @override
  String get prices_locations_empty_explanation =>
      'मूल्य जोड़ने वाले पहले व्यक्ति बनें!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'शीर्ष $pageSize स्थान (कुल: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count प्रमाण',
      one: 'एक प्रमाण',
      zero: 'कोई प्रमाण नहीं',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count उत्पाद',
      one: 'एक उत्पाद',
      zero: 'कोई उत्पाद नहीं',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count उपयोगकर्ता',
      one: 'एक उपयोगकर्ता',
      zero: 'कोई उपयोगकर्ता नहीं',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count कीमतें',
      one: 'एक कीमत',
      zero: 'कोई कीमत नहीं',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'पहले जोड़ा गया मूल्य';

  @override
  String get prices_amount_subtitle => 'मात्रा';

  @override
  String get prices_amount_is_discounted => 'क्या छूट दी गई है?';

  @override
  String get prices_amount_price_normal => 'कीमत';

  @override
  String get prices_amount_price_discounted => 'छूट की दर';

  @override
  String get prices_amount_price_not_discounted => 'असली कीमत';

  @override
  String get prices_amount_no_product => 'एक उत्पाद गायब है!';

  @override
  String get prices_amount_price_incorrect => 'गलत मान';

  @override
  String get prices_amount_price_mandatory => 'अनिवार्य मूल्य';

  @override
  String get prices_currency_subtitle => 'मुद्रा';

  @override
  String get prices_date_subtitle => 'तारीख';

  @override
  String get prices_location_subtitle => 'दुकान';

  @override
  String get prices_location_find => 'एक दुकान खोजें';

  @override
  String get prices_location_mandatory => 'आपको एक दुकान का चयन करना होगा!';

  @override
  String get prices_location_search_broader =>
      'आपको वह नहीं मिला जिसकी आपको तलाश थी? आइए एक व्यापक खोज का प्रयास करें!';

  @override
  String get prices_proof_subtitle => 'सबूत';

  @override
  String get prices_proof_empty_title => 'अभी तक कोई सबूत नहीं!';

  @override
  String get prices_proof_empty_explanation =>
      '**रसीद** या **मूल्य टैग** की तस्वीर जोड़कर शुरुआत करें!';

  @override
  String get prices_proof_find => 'एक प्रूफ़ चुनें';

  @override
  String get prices_proof_change => 'परिवर्तन प्रमाण';

  @override
  String get prices_proof_receipt => 'रसीद';

  @override
  String get prices_proof_price_tag => 'मूल्य का टैग';

  @override
  String get prices_proof_mandatory => 'आपको एक प्रमाण का चयन करना होगा!';

  @override
  String get prices_add_validation_error => 'सत्यापन त्रुटि';

  @override
  String get prices_privacy_warning_title => 'गोपनीयता चेतावनी';

  @override
  String get prices_unknown_product => 'अज्ञात उत्पाद';

  @override
  String get prices_privacy_warning_main_message =>
      'कीमतें **सार्वजनिक होंगी**, साथ ही वे जिस स्टोर का उल्लेख करती हैं उसकी जानकारी भी।\n\nइससे आपके ओपन फ़ूड फैक्ट्स छद्म नाम के बारे में जानने वाले लोगों को यह करने में मदद मिल सकती है:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'अनुमान लगाएं कि आप किस क्षेत्र में रहते हैं';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'जानें कि आपके द्वारा क्या खरीदा जा रहा है';

  @override
  String get prices_privacy_warning_sub_message =>
      'यदि आप इससे असहज हैं, तो कृपया अपना छद्म नाम बदलें, या एक नया ओपन फूड फैक्ट्स अकाउंट बनाएं और उसके साथ ऐप में लॉग इन करें।';

  @override
  String get i_refuse => 'मैंने मना कर दिया';

  @override
  String get i_accept => 'मुझे स्वीकार है';

  @override
  String get prices_currency_change_proposal_title => 'मुद्रा बदलें?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'आपकी वर्तमान मुद्रा **$currency** है। क्या आप इसे **$newCurrency** में बदलना चाहेंगे?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'हाँ, $newCurrencyका उपयोग करें';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'नहीं, $currencyरखें';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'हो गया';

  @override
  String get dev_mode_section_server => 'सर्वर कॉन्फ़िगरेशन';

  @override
  String get dev_mode_section_news => 'समाचार प्रदाता कॉन्फ़िगरेशन';

  @override
  String get dev_mode_section_product_page => 'उत्पाद पृष्ठ';

  @override
  String get dev_mode_section_ui => 'प्रयोक्ता इंटरफ़ेस';

  @override
  String get dev_mode_section_experimental_features => 'प्रायोगिक विशेषताएं';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'ग्रीन स्कोर को बाहर करें';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'OCR स्क्रीन के लिए वर्तनी जाँचक का उपयोग करें';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(सामग्री और पैकेजिंग)';

  @override
  String get dev_mode_reset_app_language_title => 'ऐप भाषा रीसेट करें';

  @override
  String get dev_mode_add_demo_cards_language_title => 'कार्ड जोड़ें';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'prices.openfoodfacts.org (PROD) और परीक्षण वातावरण के बीच स्विच करें';

  @override
  String get search_history_item_edit_tooltip =>
      'इस खोज का पुनः उपयोग और संपादन करें';

  @override
  String get search_history_item_remove_tooltip => 'निकालना';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'आपने सभी $totalSize उत्पाद डाउनलोड कर लिए हैं।';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'डाउनलोड करें $count अधिक उत्पाद\nपहले से ही डाउनलोड किया गया $totalSizeमें से $downloaded.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'आपकी $search की खोज प्रगति पर है।\n\nकृपया कुछ सेकंड प्रतीक्षा करें…';
  }

  @override
  String get user_search_contributor_title => 'मेरे द्वारा जोड़े गए उत्पाद';

  @override
  String get user_search_informer_title => 'मेरे द्वारा संपादित उत्पाद';

  @override
  String get user_search_photographer_title =>
      'जिन उत्पादों की मैंने तस्वीरें खींचीं';

  @override
  String get user_search_to_be_completed_title => 'मेरे पूरे होने वाले उत्पाद';

  @override
  String get user_search_prices_title => 'मेरी कीमतें';

  @override
  String get user_search_proofs_title => 'मेरे प्रमाण';

  @override
  String get user_search_proof_title => 'मेरा प्रमाण';

  @override
  String search_proof_title(String user) {
    return '\"$user\" से प्रमाण';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'योगदानकर्ता मूल्य: $user';
  }

  @override
  String get all_search_prices_latest_title => 'नवीनतम मूल्य जोड़े गए';

  @override
  String get all_search_prices_top_user_title => 'शीर्ष मूल्य योगदानकर्ता';

  @override
  String get all_search_prices_top_location_title =>
      'सबसे अधिक कीमतों वाले स्टोर';

  @override
  String get prices_contribution_assistant => 'मूल्य योगदान सहायक';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'एकाधिक प्रमाण जोड़ें';

  @override
  String get all_search_prices_top_location_single_title => 'स्टोर में कीमतें';

  @override
  String get all_search_prices_top_product_title =>
      'सबसे अधिक कीमत वाले उत्पाद';

  @override
  String get all_search_to_be_completed_title =>
      'सभी पूर्ण किए जाने वाले उत्पाद';

  @override
  String get categorize_products_country_title =>
      'अपने देश में उत्पादों को वर्गीकृत करने में सहायता करें';

  @override
  String get edit_product_action_retake_picture => 'फ़ोटो दोबारा लें';

  @override
  String get edit_product_action_take_picture => 'फोटो लो';

  @override
  String get edit_product_action_confirm => 'पुष्टि करना';

  @override
  String get signup_page_terms_of_use_line1 =>
      'मैं खुले खाद्य तथ्यों से सहमत हूँ ';

  @override
  String get signup_page_terms_of_use_line2 => 'उपयोग और योगदान की शर्तें';

  @override
  String get analytics_consent_image_semantic_label => 'एनालिटिक्स आइकन';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'घातक त्रुटि: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'घातक त्रुटि: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'बुनियादी विवरण पूरा करें';

  @override
  String get edit_photo_button_label => 'संपादित करें';

  @override
  String get edit_photo_unselect_button_label => 'फ़ोटो का चयन रद्द करें';

  @override
  String get edit_photo_select_existing_button_label =>
      'किसी मौजूदा छवि का चयन करें';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'किसी छवि पर क्लिक करके उसे चुनें';

  @override
  String get edit_photo_select_existing_download_label =>
      'मौजूदा छवियाँ पुनर्प्राप्त करना…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'इस उत्पाद से संबंधित कोई चित्र पहले अपलोड नहीं किया गया है।';

  @override
  String get edit_photo_language_not_this_one =>
      'उस भाषा में अभी तक कोई छवि नहीं है';

  @override
  String get edit_photo_language_none => 'अभी तक कोई छवि नहीं';

  @override
  String get category_picker_screen_title => 'श्रेणियाँ';

  @override
  String get basic_details => 'मूल विवरण';

  @override
  String get product_name => 'प्रोडक्ट का नाम';

  @override
  String get product_names => 'उत्पाद नाम';

  @override
  String get add_basic_details_product_name_add_translation =>
      'नया अनुवाद जोड़ें';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'सत्यापन से पहले, कृपया सुनिश्चित करें कि आप अनुवाद केवल तभी जोड़ें **जब पैकेजिंग पर भाषा मौजूद हो**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'सामने की तस्वीर देखें';

  @override
  String get add_basic_details_product_name_take_photo => 'सामने से फ़ोटो लें';

  @override
  String get add_basic_details_product_name_hint =>
      'उत्पाद का नाम दर्ज करें (उदाहरण: नुटेला)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'डिफ़ॉल्ट भाषा बदलें?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'क्या आप चाहते हैं कि उत्पाद की डिफ़ॉल्ट भाषा \'$language\' पर सेट हो?';
  }

  @override
  String get explanation_section_good_examples => 'अच्छे उदाहरण';

  @override
  String get explanation_section_bad_examples => 'बुरे उदाहरण';

  @override
  String get add_basic_details_product_name_help_title =>
      'अच्छे अभ्यास: उत्पाद का नाम';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'उत्पाद का नाम **पैकेजिंग पर छपा मुख्य नाम** होता है। यह एक पंजीकृत ट्रेडमार्क भी हो सकता है।';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**नोट:** कृपया अनुवाद न जोड़ें **यदि पैकेजिंग पर भाषा मौजूद नहीं है**।';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'नेस्क्विक';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'टमाटर केचप';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'नाम में ब्रांड शामिल न करें';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'टमाटर केचप **हेंज़ द्वारा**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      '®, ™, © या इसी तरह के प्रतीकों का उपयोग न करें';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'नेस्क्विक**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count अन्य अनुवाद',
      one: '$count अन्य अनुवाद',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'ब्रांड का नाम';

  @override
  String get brand_names => 'ब्रांड के नाम';

  @override
  String get add_basic_details_brand_name_error =>
      'कृपया ब्रांड का नाम दर्ज करें';

  @override
  String get add_basic_details_brand_names_hint =>
      'इनपुट ब्रांड (उदाहरण: फेरेरो)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'अच्छे अभ्यास: ब्रांड';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      '**उत्पाद के सभी ब्रांड** इनपुट करें।';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'मुख्य ब्रांड';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**मुख्य ब्रांड**, जो आमतौर पर सामने वाले पैक पर स्पष्ट रूप से प्रदर्शित होता है, उसे **पहले दर्ज किया जाना चाहिए**।';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'अन्य ब्रांड';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'जब किसी बड़ी कंपनी द्वारा बेचा जाता है:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**एक्टिमेल** को **डैनोन** द्वारा बेचा जाता है';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'जब इसे अपने ब्रांड के साथ **कई भाषाओं में अनुवादित** बेचा जाता है:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**नेचर वैली** को कभी-कभी **वैल नेचर** लिखा जाता है';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'नुटेला';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'ओरियो, मोंडेलेज़';

  @override
  String get quantity => 'मात्रा और वजन';

  @override
  String get add_basic_details_quantity_hint =>
      'वजन और यदि आवश्यक हो तो मात्रा दर्ज करें (उदाहरण: 4x100 ग्राम)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'अच्छे अभ्यास: मात्रा';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'उत्पाद पर दर्शाए गए मूल्य की प्रतिलिपि बनाएँ और **इकाइयों को न भूलें**।';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 ग्राम** या **230 ग्राम**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (6 अंडों के लिए)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(3 बॉक्स वाले उत्पाद के लिए, प्रत्येक 150g का)';

  @override
  String get barcode => 'बारकोड';

  @override
  String barcode_barcode(String barcode) {
    return 'बारकोड: $barcode';
  }

  @override
  String get barcode_invalid_error => 'अमान्य बारकोड';

  @override
  String get basic_details_add_success =>
      'बुनियादी विवरण सफलतापूर्वक जोड़ा गया';

  @override
  String get basic_details_add_error =>
      'बुनियादी विवरण जोड़ने में असमर्थ। कृपया कुछ समय बाद पुनः प्रयास करें';

  @override
  String get clear_search => 'अपनी खोज साफ़ करें';

  @override
  String get confirm_clear =>
      'आप अपना संपूर्ण इतिहास साफ़ करने वाले हैं: क्या आप वाकई जारी रखना चाहते हैं?';

  @override
  String get alert_clear_selected_user_list =>
      'आप अपने इतिहास में चयनित आइटम साफ़ करने वाले हैं';

  @override
  String get confirm_clear_selected_user_list =>
      'क्या आप वाकई जारी रखना चाहते हैं?';

  @override
  String get alert_select_items_to_clear =>
      'कृपया साफ़ करने के लिए एक या अधिक आइटम चुनें';

  @override
  String confirm_clear_user_list(String name) {
    return 'आप इस सूची को साफ़ करने वाले हैं ($name): क्या आप वाकई जारी रखना चाहते हैं?';
  }

  @override
  String get confirm_delete_user_list_title => 'सूची हटाएँ?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'आप सूची \"$name\" को हटाने वाले हैं।\nक्या आप वाकई जारी रखना चाहते हैं?';
  }

  @override
  String get confirm_delete_user_list_button => 'हाँ, मैं पुष्टि करता हूँ';

  @override
  String importance_label(String name, String id) {
    return '$name महत्व: $id';
  }

  @override
  String get user_list_all_title => 'सूचियों';

  @override
  String get user_list_all_empty => 'अपनी पहली सूची बनाएँ';

  @override
  String get product_list_select => 'एक सूची चुनें';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count उत्पाद',
      one: 'एक उत्पाद',
      zero: 'खाली सूची',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'सूची में जोड़ने';

  @override
  String get open_food_preferences_tooltip =>
      'अपनी खाद्य प्राथमिकताएँ संपादित करें';

  @override
  String get add_photo_button_label => 'तस्वीर जोड़ो';

  @override
  String get add_packaging_photo_button_label =>
      'किसी भी पैकेजिंग/रीसाइक्लिंग जानकारी की तस्वीरें लें';

  @override
  String get add_origin_photo_button_label =>
      'किसी भी मूल जानकारी की तस्वीरें लें';

  @override
  String get add_emb_photo_button_label =>
      'किसी भी ट्रेसिबिलिटी कोड जानकारी की तस्वीरें लें';

  @override
  String get add_label_photo_button_label =>
      'किसी भी लेबल और प्रमाणन जानकारी की तस्वीरें लें';

  @override
  String get choose_image_source_title => 'छवि स्रोत चुनें';

  @override
  String get choose_image_source_body => 'कृपया एक छवि स्रोत चुनें';

  @override
  String get gallery_source_label => 'गैलरी';

  @override
  String get gallery_source_access_denied_dialog_title => 'पहुंच अस्वीकृत';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'दुर्भाग्यवश, एप्लिकेशन आपकी गैलरी तक नहीं पहुंच सकता, क्योंकि आपने पहले ही अनुमति देने से इनकार कर दिया है।\n\nकृपया अपने फ़ोन में एप्लिकेशन सेटिंग पर जाएं सेटिंग्स -> फ़ोटो';

  @override
  String get gallery_source_access_denied_dialog_button => 'सेटिंग्स खोलें';

  @override
  String get share => 'शेयर';

  @override
  String share_product_text(String url) {
    return 'ओपन फ़ूड फैक्ट्स पर इस उत्पाद पर एक नज़र डालें: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'ओपन ब्यूटी फैक्ट्स पर इस उत्पाद पर एक नज़र डालें: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'ओपन पेटफूड फैक्ट्स पर इस उत्पाद पर एक नज़र डालें: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'ओपन प्रोडक्ट्स फैक्ट्स पर इस उत्पाद पर एक नज़र डालें: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'ओपन फ़ूड फैक्ट्स पर मेरे उत्पादों की सूची देखें: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'एक तस्वीर ले लो';

  @override
  String get choose_from_gallery => 'गैलरी से चयन करो';

  @override
  String get image_upload_queued =>
      'छवि को यथाशीघ्र पृष्ठभूमि में अपलोड कर दिया जाएगा।';

  @override
  String get add_price_queued => 'मूल्य यथाशीघ्र सर्वर पर भेज दिया जाएगा।';

  @override
  String get background_task_title_full_refresh =>
      'स्थानीय रूप से संग्रहीत सभी उत्पादों का रिफ्रेश प्रारंभ करना';

  @override
  String get background_task_title_folksonomy =>
      'स्थानीय रूप से संग्रहीत फोल्क्सोनॉमी अपडेट के लिए सर्वर क्रियाएँ निष्पादित करना प्रारंभ करना';

  @override
  String get background_task_title_top_n =>
      'सबसे लोकप्रिय उत्पादों का डाउनलोड शुरू करना';

  @override
  String get expand_nutrition_facts => 'पोषण तथ्य तालिका का विस्तार करें';

  @override
  String get expand_nutrition_facts_body => 'पोषण तथ्य तालिका को विस्तृत रखें';

  @override
  String get expand_ingredients => 'सामग्री का विस्तार करें';

  @override
  String get expand_ingredients_body => 'सामग्री पैनल को विस्तृत रखें';

  @override
  String get no_internet_connection => 'कोई इंटरनेट कनेक्शन नहीं';

  @override
  String get world_results_label => 'पूरी दुनिया';

  @override
  String get world_results_action => 'अपनी खोज को दुनिया तक बढ़ाएँ';

  @override
  String get copy_to_clipboard => 'प्रतिलिपि';

  @override
  String get paste_from_clipboard => 'क्लिपबोर्ड से चिपकाएँ';

  @override
  String get no_data_available_in_clipboard =>
      'आपके क्लिपबोर्ड में कोई डेटा उपलब्ध नहीं है';

  @override
  String get clipboard_barcode_copy => 'बारकोड को क्लिपबोर्ड पर कॉपी करें';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'बारकोड $barcode क्लिपबोर्ड पर कॉपी किया गया!';
  }

  @override
  String get open_product_website => 'इस उत्पाद को वेबसाइट पर खोलें';

  @override
  String get language_picker_label => 'आपकी भाषा';

  @override
  String get country_picker_label => 'आपका देश';

  @override
  String get currency_picker_label => 'आपकी मुद्रा';

  @override
  String get help_with_openfoodfacts => 'ओपनफूडफैक्ट्स में सहायता';

  @override
  String get product_task_background_schedule =>
      'उत्पाद को यथाशीघ्र पृष्ठभूमि में अद्यतन किया जाएगा।';

  @override
  String get no_email_client_available_dialog_title => 'कोई ईमेल ऐप नहीं!';

  @override
  String get no_email_client_available_dialog_content =>
      'कृपया हमें mobile@openfoodfacts.org पर मैन्युअल रूप से ईमेल भेजें';

  @override
  String get all_images => 'सभी छवियाँ';

  @override
  String get selected_images => 'चयनित छवियाँ';

  @override
  String get product_card_remove_product_tooltip => 'उत्पाद हटाएँ';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'नया बारकोड स्कैन किया गया: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip => 'कैरोसेल से सभी उत्पाद हटाएँ';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'कृपया तुलना करने के लिए कम से कम दो उत्पादों को स्कैन करें';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'आपके द्वारा स्कैन किए गए उत्पादों की तुलना करने के लिए क्लिक करें';

  @override
  String get scan_product_loading => 'आपने\nबारकोड स्कैन किया है:';

  @override
  String get scan_product_loading_initial =>
      'हम इस उत्पाद की तलाश कर रहे हैं!\nकृपया कुछ सेकंड प्रतीक्षा करें…';

  @override
  String get scan_product_loading_long_request =>
      'हम अभी भी इस उत्पाद की तलाश में हैं!\nक्या आपको लगता है कि इसे लोड होने में काफ़ी समय लगता है? हमें भी…';

  @override
  String get scan_product_loading_unresponsive =>
      'हम अभी भी इस उत्पाद की तलाश कर रहे हैं।\nक्या आप खोज पुनः आरंभ करना चाहेंगे?';

  @override
  String get scan_product_loading_restart_button => 'खोज पुनः आरंभ करें';

  @override
  String get portion_calculator_description =>
      'किसी विशिष्ट मात्रा के लिए पोषण तथ्यों की गणना करें';

  @override
  String get portion_calculator_hint => 'मात्रा';

  @override
  String get portion_calculator_accessibility =>
      'पोषण तथ्यों की गणना करने के लिए मात्रा दर्ज करें';

  @override
  String portion_calculator_error(int min, int max) {
    return 'कृपया $min और $max ग्राम के बीच मात्रा दर्ज करें';
  }

  @override
  String get portion_calculator_computation_error =>
      'डेटा अनुपलब्ध. गणना नहीं की जा सकी.';

  @override
  String portion_calculator_result_title(int grams) {
    return '$grams ग्राम (या मिलीलीटर) के लिए पोषण तथ्य';
  }

  @override
  String get offline_data => 'ऑफ़लाइन डेटा';

  @override
  String get ocr_image_upload_instruction =>
      'इसमें मौजूद जानकारी को स्वचालित रूप से निकालने के लिए एक छवि अपलोड करें।';

  @override
  String get upload_image => 'फोटो अपलोड करें';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'छवि डाउनलोड करने में विफल';

  @override
  String get image_edit_url_error =>
      'छवि संपादित करने में विफल रहा क्योंकि छवि URL सेट नहीं किया गया था.';

  @override
  String get user_picture_source_remember => 'मेरी पसंद याद रखें';

  @override
  String get user_picture_source_ask => 'हर बार पूछें';

  @override
  String get robotoff_continue => 'जारी रखना';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count प्रश्न',
      one: 'प्रश्न',
    );
    return 'अगला $_temp0';
  }

  @override
  String get show_password => 'पासवर्ड दिखाए';

  @override
  String get owner_field_info_title => 'निर्माता द्वारा प्रदान किए गए मान';

  @override
  String get owner_field_info_message =>
      'उस लोगो के साथ हम निर्माता द्वारा उपलब्ध कराए गए डेटा को हाइलाइट करते हैं, और हो सकता है कि उसे संपादित न किया जा सके।';

  @override
  String get owner_field_info_close_button => 'यह जानकारी बंद करें';

  @override
  String get owner_field_image =>
      'यह छवि निर्माता द्वारा प्रदान की गई है। इसे संपादित नहीं किया जा सकता।';

  @override
  String get edit_packagings_title => 'पैकेजिंग घटक';

  @override
  String get edit_packagings_element_add => 'पैकेजिंग घटक जोड़ें';

  @override
  String get edit_packagings_completed => 'पैकेजिंग पूरी हो गई है';

  @override
  String edit_packagings_element_title(int index) {
    return 'पैकेजिंग घटक #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'इकाइयों की संख्या';

  @override
  String get edit_packagings_element_hint_units =>
      'उत्पाद में निहित समान आकार और सामग्री की पैकेजिंग इकाइयों की संख्या दर्ज करें।';

  @override
  String get edit_packagings_element_field_shape => 'आकार';

  @override
  String get edit_packagings_element_hint_shape =>
      'यदि रीसाइक्लिंग निर्देशों में सूचीबद्ध आकृति का नाम उपलब्ध हो तो उसे दर्ज करें, या कोई आकृति चुनें।';

  @override
  String get edit_packagings_element_example_shape => 'बोतल';

  @override
  String get edit_packagings_element_field_material => 'सामग्री';

  @override
  String get edit_packagings_element_hint_material =>
      'यदि विशिष्ट सामग्री निर्धारित की जा सकती है तो उसे दर्ज करें (त्रिकोण के अंदर एक सामग्री कोड अक्सर पैकेजिंग भागों पर पाया जा सकता है), या यदि आप अनिश्चित हैं तो एक सामान्य सामग्री (उदाहरण के लिए प्लास्टिक या धातु) दर्ज करें।';

  @override
  String get edit_packagings_element_example_material => 'काँच';

  @override
  String get edit_packagings_element_field_recycling => 'पुनर्चक्रण निर्देश';

  @override
  String get edit_packagings_element_hint_recycling =>
      'रीसाइक्लिंग निर्देश केवल तभी दर्ज करें जब वे उत्पाद पर सूचीबद्ध हों।';

  @override
  String get edit_packagings_element_example_recycling => 'अपनी बात दोहराना';

  @override
  String get edit_packagings_element_field_quantity =>
      'प्रति इकाई उत्पाद की शुद्ध मात्रा';

  @override
  String get edit_packagings_element_hint_quantity =>
      'शुद्ध वजन या शुद्ध आयतन दर्ज करें और इकाई बताएं (उदाहरण के लिए ग्राम या मिलीलीटर)।';

  @override
  String get edit_packagings_element_field_weight =>
      'एक खाली इकाई का वजन (ग्राम)';

  @override
  String get edit_packagings_element_hint_weight =>
      'बचे हुए खाने को हटा दें और वज़न करने से पहले पैकेजिंग वाले हिस्से को धोकर सुखा लें। हो सके तो 0.1 ग्राम या 0.01 ग्राम की सटीकता वाले पैमाने का इस्तेमाल करें।';

  @override
  String get background_task_title => 'लंबित योगदान';

  @override
  String get background_task_subtitle =>
      'आपके योगदान स्वचालित रूप से हमारे सर्वर पर सहेजे जाते हैं, लेकिन हमेशा वास्तविक समय में नहीं।';

  @override
  String get background_task_list_empty => 'कोई लंबित पृष्ठभूमि कार्य नहीं';

  @override
  String get background_task_error_server_time_out => 'सर्वर टाइमआउट';

  @override
  String get background_task_error_no_internet =>
      'इंटरनेट कनेक्शन त्रुटि. बाद में प्रयास करें.';

  @override
  String get background_task_operation_unknown => 'अज्ञात ऑपरेशन प्रकार';

  @override
  String get background_task_operation_details => 'विस्तृत परिवर्तन';

  @override
  String get background_task_operation_image => 'फोटो अपलोड';

  @override
  String get background_task_operation_refresh =>
      'फ़ोटो अपलोड के बाद रिफ़्रेश में देरी';

  @override
  String get background_task_run_started => 'शुरू कर दिया';

  @override
  String get background_task_run_not_started => 'अभी तक शुरू नहीं हुआ';

  @override
  String get background_task_run_to_be_deleted => 'हटाए जाने के लिए';

  @override
  String get background_task_question_stop =>
      'क्या आप उस कार्य को यथाशीघ्र रोकना चाहते हैं?';

  @override
  String get feed_back => 'प्रतिक्रिया';

  @override
  String get undo => 'पूर्ववत';

  @override
  String get copy_email_to_clip_board => 'ईमेल को क्लिपबोर्ड पर कॉपी करें';

  @override
  String get please_send_us_an_email_to =>
      'कृपया हमें मैन्युअल रूप से एक ईमेल भेजें';

  @override
  String get email_copied_to_clip_board => 'ईमेल क्लिपबोर्ड पर कॉपी किया गया!';

  @override
  String get select_accent_color => 'एक्सेंट रंग चुनें';

  @override
  String get theme_amoled => 'एमोलेड';

  @override
  String get color_blue => 'नीला';

  @override
  String get color_cyan => 'सियान';

  @override
  String get color_green => 'हरा';

  @override
  String get color_light_brown => 'गलती करना';

  @override
  String get color_magenta => 'मैजेंटा';

  @override
  String get color_orange => 'नारंगी';

  @override
  String get color_pink => 'गुलाबी';

  @override
  String get color_red => 'लाल';

  @override
  String get color_rust => 'जंग';

  @override
  String get color_teal => 'टील';

  @override
  String get text_contrast_mode => 'पाठ कंट्रास्ट';

  @override
  String get contrast_high => 'उच्च';

  @override
  String get contrast_medium => 'मध्यम';

  @override
  String get contrast_low => 'कम';

  @override
  String get product_refresher_internet_not_found => 'उत्पाद नहीं मिला!';

  @override
  String get product_refresher_internet_not_connected =>
      'आप इंटरनेट से कनेक्ट नहीं हैं!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'सर्वर डाउन ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'सर्वर त्रुटि ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'उत्पाद नहीं मिला!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'निम्नलिखित बारकोड वाला कोई उत्पाद हमारे डेटाबेस में मौजूद नहीं है: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'कोई इंटरनेट कनेक्शन नहीं!';

  @override
  String get product_loader_network_error_message =>
      'कृपया जांच लें कि आपका स्मार्टफोन वाई-फाई नेटवर्क पर है या उसमें मोबाइल डेटा सक्षम है';

  @override
  String get page_not_found_title => 'पृष्ठ नहीं मिला!';

  @override
  String get page_not_found_button => 'वापस मुख्य पृष्ठ पर जाएं';

  @override
  String get download_data => 'डेटा डाउनलोड करें';

  @override
  String get download_top_products =>
      'तत्काल स्कैनिंग के लिए अपने देश के शीर्ष 1000 उत्पाद डाउनलोड करें';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count उत्पाद',
    );
    return 'तत्काल स्कैनिंग के लिए अपने देश के शीर्ष $_temp0 डाउनलोड करें';
  }

  @override
  String get download_in_progress =>
      'डेटा डाउनलोड हो रहा है\nइसमें कुछ समय लग सकता है';

  @override
  String downloaded_products(int num) {
    return '$num उत्पाद जोड़े गए';
  }

  @override
  String get update_offline_data => 'ऑफ़लाइन उत्पाद डेटा अपडेट करें';

  @override
  String get update_local_database_sub =>
      'ओपन फ़ूड फैक्ट्स के नवीनतम डेटा के साथ स्थानीय उत्पाद डेटाबेस को अपडेट करें';

  @override
  String get clear_local_database => 'ऑफ़लाइन उत्पाद डेटा साफ़ करें';

  @override
  String get clear_local_database_sub =>
      'जगह खाली करने के लिए अपने ऐप्लिकेशन से सभी स्थानीय उत्पाद डेटा साफ़ करें';

  @override
  String deleted_products(int num) {
    return '$num उत्पाद हटा दिए गए';
  }

  @override
  String get loading => 'लोड किया जा रहा है…';

  @override
  String get know_more => 'अधिक जानते हैं';

  @override
  String get offline_data_desc =>
      'ऑफ़लाइन डेटा के बारे में अधिक जानने के लिए क्लिक करें';

  @override
  String get offline_product_data_title => 'ऑफ़लाइन उत्पाद डेटा';

  @override
  String available_for_download(int num) {
    return '$num उत्पाद तत्काल स्कैनिंग के लिए उपलब्ध हैं';
  }

  @override
  String get country_selector_title => 'अपने देश का चयन करॊ:';

  @override
  String get currency_selector_title => 'अपनी मुद्रा चुनें:';

  @override
  String get language_selector_title => 'अपनी भाषा का चयन करें:';

  @override
  String get language_selector_section_selected => 'चयनित भाषाएँ';

  @override
  String get language_selector_section_frequently_used => 'बहुधा प्रयुक्त';

  @override
  String get action_delete_list => 'नष्ट करे';

  @override
  String get action_change_list => 'वर्तमान सूची बदलें';

  @override
  String get product_list_create => 'बनाएं';

  @override
  String get product_list_create_tooltip => 'एक नई सूची बनाएँ';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (नई गणना)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (नई गणना)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unknown Nutri-Score (New calculation)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score is not applicable';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score is not applicable (New calculation)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Green-Score A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => 'अज्ञात ग्रीन-स्कोर';

  @override
  String get environmental_score_not_applicable_new =>
      'ग्रीन-स्कोर लागू नहीं है';

  @override
  String get nova_group_generic_new =>
      'अति-प्रसंस्कृत खाद्य पदार्थ - NOVA समूह';

  @override
  String get nova_group_1 => 'NOVA ग्रुप 1';

  @override
  String get nova_group_2 => 'NOVA ग्रुप 2';

  @override
  String get nova_group_3 => 'NOVA ग्रुप 3';

  @override
  String get nova_group_4 => 'NOVA ग्रुप 4';

  @override
  String get nova_group_unknown => 'अज्ञात NOVA समूह';

  @override
  String get nutrition_facts => 'पोषक तत्व स्तर';

  @override
  String get faq_title_partners => 'एनजीओ के भागीदार और संरक्षक';

  @override
  String get faq_title_vision =>
      'ओपन फ़ूड फैक्ट्स विजन, मिशन, मूल्य और कार्यक्रम';

  @override
  String get faq_title_install_beauty =>
      'कॉस्मेटिक डेटाबेस बनाने के लिए ओपन ब्यूटी फैक्ट्स इंस्टॉल करें';

  @override
  String get faq_title_install_pet =>
      'पालतू पशुओं के भोजन का डेटाबेस बनाने के लिए ओपन पेट फ़ूड फैक्ट्स इंस्टॉल करें';

  @override
  String get faq_title_install_product =>
      'वस्तुओं का जीवन बढ़ाने के लिए उत्पाद डेटाबेस बनाने हेतु ओपन प्रोडक्ट्स फैक्ट्स स्थापित करें';

  @override
  String get faq_nutriscore_nutriscore =>
      'न्यूट्री-स्कोर की नई गणना: क्या नया है?';

  @override
  String get contact_title_pro_page =>
      'प्रो? अपने उत्पादों को ओपन फ़ूड फैक्ट्स में आयात करें';

  @override
  String get contact_title_pro_email => 'निर्माता संपर्क';

  @override
  String get contact_title_press_page => 'प्रेस पेज';

  @override
  String get contact_title_press_email => 'प्रेस संपर्क';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'हमारे सामुदायिक कैलेंडर की सदस्यता लें';

  @override
  String get hunger_games_loading_line1 => 'कृपया हमें कुछ सेकंड दें…';

  @override
  String get hunger_games_loading_line2 => 'हम प्रश्न डाउनलोड कर रहे हैं!';

  @override
  String get hunger_games_error_label =>
      'अरे! कुछ गड़बड़ हो गई… और हम प्रश्न लोड नहीं कर सके।';

  @override
  String get hunger_games_error_retry_button => 'आइये पुनः प्रयास करें!';

  @override
  String get reorder_attribute_action => 'विशेषताओं को पुनः क्रमित करें';

  @override
  String get link_cant_be_opened =>
      'यह लिंक आपके डिवाइस पर नहीं खुल पा रहा है। कृपया जाँच लें कि आपके डिवाइस पर ब्राउज़र इंस्टॉल है।';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return '$productNameके लिए विवरण';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return '$pageName के साथ $productNameका विवरण';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'शेयर';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'नया न्यूट्री-स्कोर गणना कहां मिलेगी?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'न्यूट्री-स्कोर 7 देशों में लागू किया जाता है: फ्रांस, जर्मनी, बेल्जियम, स्पेन, लक्जमबर्ग, नीदरलैंड और स्विट्जरलैंड।';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'निर्माताओं के पास डिक्री पर हस्ताक्षर के बाद पुरानी गणना को नई गणना से बदलने के लिए अधिकतम 2 वर्ष का समय होता है।';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'ग्रीन स्कोर क्या है?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'ग्रीन-स्कोर एक लोगो है जिसका उद्देश्य आपको भोजन के पर्यावरणीय प्रभाव के बारे में जानकारी देना है।';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'रंग कोड सबसे कम प्रभावशाली उत्पादों के लिए गहरे हरे (A+) से लेकर सबसे अधिक प्रभावशाली उत्पादों के लिए गहरे लाल (F) तक भिन्न होता है।';

  @override
  String get guide_greenscore_logos_caption => 'ग्रीन-स्कोर लोगो';

  @override
  String get guide_greenscore_lca_title => 'मुख्य: जीवन चक्र मूल्यांकन (एलसीए)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'खाद्य श्रेणियों का वैज्ञानिक मूल्यांकन';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'प्रत्येक उत्पाद श्रेणी के लिए, एग्रीबेलाइज़ पर्यावरण डेटाबेस (ADEME और INRAE द्वारा डिज़ाइन किया गया) से डेटा का उपयोग करके एक बेंचमार्क स्कोर स्थापित किया जाता है।';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**जीवन चक्र विश्लेषण** बहु-चरणीय और बहु-मानदंड पर्यावरणीय मूल्यांकन करने के लिए एक मानकीकृत मूल्यांकन पद्धति है।';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**यह उपाय:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 उत्पादन चरण';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'पैकेजिंग';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title => '14 पर्यावरणीय प्रभाव संकेतक';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'जलवायु परिवर्तन/कार्बन पदचिह्न';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'ओजोन परत का क्षरण';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'आयनित विकिरण';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'भूमि';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'जल एवं ऊर्जा उपयोग';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'वायु प्रदूषण';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'समुद्री एवं ताजा जल (कण, अम्लीकरण, सुपोषण)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'संसाधनों का ह्रास.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'बोनस और दंड';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'किसी श्रेणी में बेहतर उत्पादों को पुरस्कृत करने के लिए, हम **कई मानदंडों के आधार पर बोनस और दंड** लागू करते हैं:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'बोनस उन उत्पादों को दिया जाता है जिन पर आधिकारिक लेबल, लेबल या प्रमाणन होता है जो पर्यावरणीय लाभ की गारंटी देता है (जैविक, निष्पक्ष व्यापार, एचवीई, लेबल रूज, ब्लू ब्लैंक कूर, एमएससी/एएससी)।';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'सामग्री की उत्पत्ति';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'सामग्री की उत्पत्ति के आधार पर एक बोनस दिया जाता है। यह बोनस परिवहन पर पड़ने वाले प्रभाव और प्रत्येक उत्पादक देश की पर्यावरण नीति को भी ध्यान में रखता है।';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'उन उत्पादों पर जुर्माना लगाया जाता है जिनमें ऐसे तत्व होते हैं जिनका जैव विविधता और पारिस्थितिकी तंत्र पर महत्वपूर्ण नकारात्मक प्रभाव पड़ता है, जैसे कि पाम ऑयल, जिसके उत्पादन से बड़े पैमाने पर वनों की कटाई होती है।';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'पैकेजिंग';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**जुर्माने** की गणना पैकेजिंग की चक्रीयता (पुनर्नवीनीकृत कच्चे माल का उपयोग और पुनर्चक्रणीयता) और ओवरपैकिंग को ध्यान में रखकर की जाती है।';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'ग्रीन-स्कोर की सटीक गणना करने के लिए, ऐसी जानकारी का होना आवश्यक है जो पैकेजिंग पर आवश्यक रूप से निर्दिष्ट नहीं होती है (जैसे कि उत्पत्ति और प्रत्येक घटक का सटीक प्रतिशत) या जो उपयोग योग्य रूप में शायद ही कभी उपलब्ध होती है (जैसे कि पैकेजिंग के सभी घटकों की सूची और प्रयुक्त प्लास्टिक के सटीक प्रकार)।';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**औसत मान का उपयोग तब किया जाता है जब यह जानकारी अभी उपलब्ध नहीं होती है**, लेकिन अब हम सभी से इस जानकारी को एकत्र करने में हमारी मदद करने का आह्वान कर रहे हैं जो ग्रीन-स्कोर के लिए बहुत उपयोगी होगी, लेकिन कई अन्य उपयोगों के लिए भी उपयोगी होगी।';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'नागरिक कैसे मदद कर सकते हैं?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'सभी नागरिक हमें उत्पादों पर मौजूद या उनसे प्राप्त की जा सकने वाली जानकारी को एकत्रित करने और उसे संरचित करने में सहायता कर सकते हैं, जैसे कि **पैकेजिंग** पर जानकारी: \"मिशन एम्बालाजेस\": सभी खाद्य उत्पादों के लिए पैकेजिंग की एक बड़े पैमाने पर सहयोगात्मक सूची (फ्रेंच में)।';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'निर्माता कैसे मदद कर सकते हैं';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'निर्माता अपनी जानकारी सीधे हमारे निःशुल्क मंच के माध्यम से हमें भेज सकते हैं।';

  @override
  String get guide_greenscore_better_product_title =>
      'कौन सा उत्पाद ग्रह के लिए बेहतर है?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'यह बताना मुश्किल हो सकता है';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'टिकाऊ भोजन का चयन करना सबसे शक्तिशाली चीजों में से एक है जो हम जलवायु के लिए कर सकते हैं, क्योंकि **हमारी वैश्विक खाद्य प्रणाली सभी ग्रीनहाउस गैस उत्सर्जन के एक चौथाई से अधिक के लिए जिम्मेदार है**।\n(स्रोत: पूअर और नेमेसेक, विज्ञान, 2018)।';

  @override
  String get guide_greenscore_better_product_arg2_title => 'आपके पास शक्ति है!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'अच्छी खबर यह है कि इससे हमें बदलाव लाने का एक शक्तिशाली तरीका मिलता है।\n**हम में से हर कोई हर साल लगभग 1,000 बार खाना खाता है**। यानी ग्रह के लिए एक बेहतर भविष्य चुनने के 1,000 अवसर!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'ज़िम्मेदार बनने और निर्णय लेने में मदद करता है';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'टिकाऊ खाद्य पदार्थों का चुनाव करना जटिल लग सकता है। लेबल भ्रामक होते हैं और अक्सर जानकारी गायब होती है। ग्रीन-स्कोर इसे आसान बनाने के लिए बनाया गया है, जो आपको खाद्य उत्पादों के लिए एक **स्पष्ट**, **विज्ञान-आधारित** और **पारदर्शी** पर्यावरणीय रेटिंग देता है, ठीक वहीं जहाँ आपको इसकी ज़रूरत है: खरीदारी करते समय।';

  @override
  String get guide_greenscore_better_product_arg4_title => 'पारदर्शिता';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'स्वामित्व लेबल के विपरीत, ग्रीन-स्कोर गणना **पूरी तरह से खुली** है और इसे **किसी के द्वारा भी सत्यापित किया जा सकता है**।';

  @override
  String get guide_nova_title => 'अल्ट्रा-प्रसंस्कृत खाद्य पदार्थ';

  @override
  String get guide_nova_what_is_nova_title => 'अल्ट्रा-प्रोसेसिंग क्या है?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA समूह आपको खाद्य प्रसंस्करण के स्तर के बारे में जानकारी देते हैं।';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA वर्गीकरण खाद्य पदार्थों को उनके औद्योगिक प्रसंस्करण की डिग्री के आधार पर 4 समूहों में वर्गीकृत करने की अनुमति देता है (न्यूनतम प्रसंस्कृत या असंसाधित खाद्य पदार्थ, पाक सामग्री, प्रसंस्कृत खाद्य पदार्थ, अति-प्रसंस्कृत खाद्य पदार्थ)।';

  @override
  String get guide_nova_logos_caption => 'NOVA लोगो';

  @override
  String get guide_nova_groups_title => '4 NOVA समूह';

  @override
  String get guide_nova_groups_intro =>
      'NOVA के चार समूह हैं, जिनमें से समस्याग्रस्त समूह 4 है - अति-प्रसंस्कृत खाद्य पदार्थ।';

  @override
  String get guide_nova_groups_arg1_title =>
      'न्यूनतम प्रसंस्कृत या असंसाधित खाद्य पदार्थ';

  @override
  String get guide_nova_groups_arg1_text =>
      'unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'अल्ट्रा-प्रसंस्कृत खाद्य पदार्थ';

  @override
  String get guide_nova_groups_arg4_text =>
      'ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'अल्ट्रा-प्रोसेसिंग से जुड़ी समस्याएं';

  @override
  String get guide_nova_explanations_arg1_title =>
      'खाद्य सामग्री का अत्यधिक प्रसंस्करण';

  @override
  String get guide_nova_explanations_arg1_text =>
      'इनमें से कई खाद्य घटकों के आगे के प्रसंस्करण से प्राप्त होते हैं, जैसे हाइड्रोजनीकृत या इंटरस्टेरिफाइड तेल, हाइड्रोलाइज्ड प्रोटीन, सोया प्रोटीन आइसोलेट, माल्टोडेक्सट्रिन, इन्वर्ट शुगर और हाई-फ्रक्टोज कॉर्न सिरप।';

  @override
  String get guide_nova_explanations_arg2_title =>
      'ऐसे योजक जो शुद्ध खाद्य सुरक्षा से परे हैं';

  @override
  String get guide_nova_explanations_arg2_text =>
      'अति-प्रसंस्कृत खाद्य पदार्थों में कुछ ऐसे योजक शामिल होते हैं जिनका उपयोग प्रसंस्कृत खाद्य पदार्थों में भी किया जाता है, जैसे कि परिरक्षक, एंटीऑक्सीडेंट और स्टेबलाइजर। केवल अति-प्रसंस्कृत उत्पादों में पाए जाने वाले योजकों में वे शामिल हैं जिनका उपयोग **खाद्य पदार्थों के संवेदी गुणों की नकल या वृद्धि करने या अंतिम उत्पाद के अरुचिकर पहलुओं को छिपाने के लिए** किया जाता है। इन योजकों में रंग और अन्य रंग, रंग स्टेबलाइजर; स्वाद, स्वाद वर्धक, गैर-चीनी स्वीटनर; और प्रसंस्करण सहायक जैसे कार्बोनेटिंग, फर्मिंग, बल्किंग और एंटी-बल्किंग एजेंट, डी-फोमिंग, एंटी-केकिंग और ग्लेज़िंग एजेंट, इमल्सीफायर, सिक्वेस्ट्रेंट और ह्यूमेक्टेंट्स शामिल हैं।';

  @override
  String get guide_nova_explanations_arg3_title =>
      'प्रसंस्करण जो आप घर पर नहीं कर सकते';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**आमतौर पर कई सामग्रियों को मिलाकर अंतिम उत्पाद (इसलिए \'अति-प्रसंस्कृत\') बनाने के लिए कई प्रक्रियाओं का इस्तेमाल किया जाता है।** इन प्रक्रियाओं में कई ऐसी प्रक्रियाएँ शामिल हैं जिनका कोई घरेलू समकक्ष नहीं है, जैसे हाइड्रोजनीकरण और हाइड्रोलिसिस, एक्सट्रूज़न और मोल्डिंग, और तलने के लिए पूर्व-प्रसंस्करण।';

  @override
  String get guide_nova_explanations_arg4_title =>
      'अल्ट्रा-प्रोसेसिंग के शिकारी और वित्तीय पहलू';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**अल्ट्रा-प्रोसेसिंग का समग्र उद्देश्य ब्रांडेड, सुविधाजनक (टिकाऊ, खाने के लिए तैयार), आकर्षक (अति-स्वादिष्ट) और अत्यधिक लाभदायक (कम लागत वाली सामग्री) खाद्य उत्पाद तैयार करना है जो अन्य सभी खाद्य समूहों को विस्थापित कर सकें। अल्ट्रा-प्रोसेस्ड खाद्य उत्पादों को आमतौर पर आकर्षक ढंग से पैक किया जाता है और उनका गहन विपणन किया जाता है।';

  @override
  String get guide_nova_explanations_arg5_title => 'स्वास्थ्य के लिए खतरा';

  @override
  String get guide_nova_explanations_arg5_text =>
      '2018 से, न्यूट्रीनेट-सैंटे के साथ, **अति-प्रसंस्कृत खाद्य पदार्थों के सेवन और कैंसर, हृदय रोगों और मधुमेह के बढ़ते जोखिमों** के बीच पहली बार संबंध उजागर हुए हैं। आज, दुनिया भर में 90 से ज़्यादा अध्ययन इन निष्कर्षों की पुष्टि करते हैं।\nसबसे मज़बूत संबंध **मोटापे, हृदय संबंधी मृत्यु दर और अवसादग्रस्तता के लक्षणों** से जुड़े हैं। बच्चों पर, इसका प्रभाव मुख्य रूप से वज़न और लिपिड असंतुलन पर देखा जाता है।';

  @override
  String get guide_nova_explanations_arg6_title =>
      'देश इन्हें सीमित करने की अनुशंसा करते हैं';

  @override
  String get guide_nova_explanations_arg6_text =>
      'कुछ देश अपने आहार संबंधी दिशानिर्देशों या लक्ष्यों के लिए NOVA समूहों का उपयोग करते हैं, उदाहरण के लिए:\n\n- **🇧🇷 ब्राज़ील** के आहार संबंधी दिशानिर्देश **प्रसंस्कृत खाद्य पदार्थों की खपत को सीमित करने** और अति-प्रसंस्कृत खाद्य पदार्थों से बचने की सलाह देते हैं।\n\n- **🇫🇷 फ्रांस** के 2018-2022 के सार्वजनिक स्वास्थ्य पोषण नीति लक्ष्यों का लक्ष्य **समूह 4 के अति-प्रसंस्कृत खाद्य पदार्थों की खपत को 20% तक कम करना** है।';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'ओपन फूड फैक्ट्स में आपका स्वागत है!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'ओपन फूड फैक्ट्स क्या है?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'ओपन फूड फैक्ट्स दुनिया भर के खाद्य उत्पादों का एक सहयोगात्मक, निःशुल्क और खुला डेटाबेस है।';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'हमारा मानना है कि हर किसी को अपने खाने की जानकारी होनी चाहिए। सामग्री, एलर्जी, पोषण संबंधी तथ्यों और अन्य चीज़ों पर डेटा इकट्ठा करके, **हम उपभोक्ताओं को सूचित विकल्प चुनने में सक्षम बनाते हैं** और खाद्य उद्योग को **अधिक पारदर्शिता** की ओर ले जाते हैं।';

  @override
  String get guide_open_food_facts_features_title => 'खुले भोजन की विशेषताएं';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'अपने अवांछित अवयवों के लिए अलर्ट प्राप्त करें';

  @override
  String get guide_open_food_facts_tips_title =>
      'बेहतरीन तस्वीरें लेने के लिए सुझाव';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'क्या न करें';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'छाया और चकाचौंध से बचें.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'कोई धुंधला या फोकस से बाहर पाठ नहीं।';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'पाठ के कुछ हिस्सों को काटें नहीं।';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'व्यस्त पृष्ठभूमि से बचें.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'क्या करें';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'अच्छी एवं समान रोशनी का प्रयोग करें।';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'सुनिश्चित करें कि पाठ स्पष्ट और पठनीय हो।';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'संपूर्ण सामग्री सूची कैप्चर करें.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'उत्पाद को समतल सतह पर रखें।';

  @override
  String get guide_open_food_facts_scores_title =>
      '\"भोजन का विकिपीडिया\" बनाने में हमारी सहायता करें';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'पोषण गुणवत्ता पर एक अंक';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'अति-प्रसंस्कृत खाद्य पदार्थों से बचने के लिए एक स्कोर';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'ग्रह के लिए एक अंक';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-hi.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'ओपन पेट फ़ूड फैक्ट्स में आपका स्वागत है!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'ओपन पेट फ़ूड तथ्य क्या है?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'ओपन पेट फ़ूड फैक्ट्स हमारे मिशन को हमारे प्यारे दोस्तों तक बढ़ाता है! यह बिल्लियों, कुत्तों और अन्य पालतू जानवरों के लिए पालतू भोजन उत्पादों का एक डेटाबेस है।';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'हम पालतू पशुओं के मालिकों को उनके पशुओं की आवश्यकताओं के लिए सर्वोत्तम भोजन चुनने में मदद करने के लिए **सामग्री**, **पोषण विश्लेषण**, और आहार संबंधी दिशानिर्देशों पर जानकारी एकत्र करते हैं।';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'खुले पालतू भोजन के तथ्य की विशेषताएं';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'अपने अवांछित अवयवों के लिए अलर्ट प्राप्त करें';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'क्या आपके पालतू जानवर को किसी भी सामग्री से एलर्जी है? आप ऐप में ही उन कॉस्मेटिक सामग्रियों की सूची बना सकते हैं जिनसे आपको बचना चाहिए!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'बेहतरीन तस्वीरें लेने के लिए सुझाव';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'क्या न करें';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'छाया और चकाचौंध से बचें.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'कोई धुंधला या फोकस से बाहर पाठ नहीं।';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'पाठ के कुछ हिस्सों को काटें नहीं।';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'व्यस्त पृष्ठभूमि से बचें.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'क्या करें';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'अच्छी एवं समान रोशनी का प्रयोग करें।';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'सुनिश्चित करें कि पाठ स्पष्ट और पठनीय हो।';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'संपूर्ण सामग्री सूची कैप्चर करें.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'उत्पाद को समतल सतह पर रखें।';

  @override
  String get guide_open_pet_food_facts_scores_title => 'स्कोरिंग पर एक नोट';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'पालतू जानवरों के भोजन के लिए स्कोरिंग प्रणाली विकसित करना **अभी प्राथमिकता नहीं है**। यह कार्यप्रणाली जटिल होगी, क्योंकि पोषण संबंधी ज़रूरतें प्रजातियों, उम्र और स्वास्थ्य स्थिति के अनुसार बहुत भिन्न होती हैं। हमें अभी तक कोई स्वतंत्र वैज्ञानिक टीम नहीं मिली है जो ऐसा स्कोर विकसित कर सके।';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-hi.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'ओपन ब्यूटी फैक्ट्स में आपका स्वागत है!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'ओपन ब्यूटी फैक्ट्स क्या है?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'ओपन ब्यूटी फैक्ट्स कॉस्मेटिक उत्पादों का एक सहयोगी डेटाबेस है।';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'हमारा लक्ष्य सामग्री सूची को समझना है ताकि आपको यह समझने में मदद मिल सके कि **आपके व्यक्तिगत देखभाल उत्पादों में क्या है**। मॉइस्चराइज़र से लेकर मेकअप तक, हम सौंदर्य प्रसाधन उद्योग में पारदर्शिता को बढ़ावा देने के लिए सामग्री, एलर्जी और पैकेजिंग पर डेटा एकत्र करते हैं।';

  @override
  String get guide_open_beauty_facts_features_title =>
      'ओपन ब्यूटी फैक्ट्स की विशेषताएं';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'अपने अवांछित अवयवों के लिए अलर्ट प्राप्त करें';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'क्या आपको किसी भी सामग्री से एलर्जी है? क्या आप कॉमेडोजेनिक पदार्थों से बचना चाहते हैं? विवादास्पद घटकों से दूर रहना चाहते हैं? आप ऐप में ही उन कॉस्मेटिक सामग्रियों की सूची बना सकते हैं जिनसे आपको बचना है!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'बेहतरीन तस्वीरें लेने के लिए सुझाव';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'क्या न करें';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'छाया और चकाचौंध से बचें.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'कोई धुंधला या फोकस से बाहर पाठ नहीं।';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'पाठ के कुछ हिस्सों को काटें नहीं।';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'व्यस्त पृष्ठभूमि से बचें.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'क्या करें';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'अच्छी एवं समान रोशनी का प्रयोग करें।';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'सुनिश्चित करें कि पाठ स्पष्ट और पठनीय हो।';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'संपूर्ण सामग्री सूची कैप्चर करें.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'यदि बोतल घुमावदार है तो जितनी आवश्यकता हो उतनी तस्वीरें लें।';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'आपको सामग्री की सूची देखने के लिए लेबल को छीलना पड़ सकता है।';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'उत्पाद को समतल सतह पर रखें।';

  @override
  String get guide_open_beauty_facts_scores_title => 'स्कोरिंग पर एक नोट';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'खाद्य उत्पादों के विपरीत, सौंदर्य प्रसाधनों की दुनिया में **न्यूट्री-स्कोर** जैसी कोई सार्वभौमिक रूप से मान्यता प्राप्त, सरकार समर्थित स्कोरिंग प्रणाली नहीं है। अवयवों का प्रभाव अत्यधिक व्यक्तिगत हो सकता है और त्वचा के प्रकार, एलर्जी और व्यक्तिगत चिंताओं पर निर्भर करता है।';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-hi.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Open Prices क्या है?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**हम कीमतों का एक ओपन-सोर्स डेटासेट क्राउडसोर्स कर रहे हैं**। उपयोगकर्ता इस वेब ऐप या आधिकारिक ओपन फ़ूड फ़ैक्ट्स मोबाइल ऐप के ज़रिए कीमतें जोड़ सकते हैं। खुदरा विक्रेता या तृतीय-पक्ष ऐप भी हमारे एपीआई का उपयोग करके योगदान दे सकते हैं।';

  @override
  String get guide_open_prices_how_arg1_title =>
      'गलियारों में लगे मूल्य टैग की तस्वीरें एकत्र करें';

  @override
  String get guide_open_prices_how_arg2_title =>
      'रसीदों की तस्वीरें एकत्र करें';

  @override
  String get guide_open_prices_why_title =>
      'ओपन फ़ूड फैक्ट्स ऐसा क्यों कर रहा है?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'खाद्य प्रणालियों को समझने के लिए मूल्य संबंधी जानकारी अत्यंत महत्वपूर्ण है। यह खाद्य पदार्थों की लागत को समझने और स्वास्थ्यवर्धक आहार को बढ़ावा देने में एक महत्वपूर्ण कारक है। मूल्य संबंधी आँकड़े उपलब्ध कराने से शोधकर्ताओं, पत्रकारों और नागरिकों के लिए **भौगोलिक और समय के साथ खाद्य पदार्थों की कीमतों में होने वाले बदलावों को बेहतर ढंग से समझना आसान हो जाता है**।';

  @override
  String get guide_open_prices_why_arg1_title =>
      'समय के साथ कीमतों के विकास पर नज़र रखें';

  @override
  String get guide_open_prices_why_arg1_text =>
      'कीमतों के विकास को देखें: सिकुड़न मुद्रास्फीति, सस्ती मुद्रास्फीति, हम उन्हें एक साथ ट्रैक कर सकते हैं!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'अपने आस-पास की कीमतों की तुलना करें';

  @override
  String get guide_open_prices_why_arg2_text =>
      'जैसे-जैसे हमें और अधिक कीमतें मिलेंगी, आप अपने आस-पास सबसे सस्ती दुकानें ढूंढ सकेंगे।';

  @override
  String get guide_open_prices_scrapping_title =>
      'क्या आपने खुदरा विक्रेताओं की वेबसाइटों से कीमतें हटाने पर विचार किया?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'आप हमारे API का उपयोग करके कीमतों में योगदान कर सकते हैं।\nयदि आप बड़े पैमाने पर कीमतों में योगदान करना चाहते हैं, तो कृपया prices@openfoodfacts.org पर हमसे संपर्क करें।';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'ओपन प्रोडक्ट्स फैक्ट्स में आपका स्वागत है!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'ओपन प्रोडक्ट्स तथ्य क्या है?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'ओपन प्रोडक्ट्स फैक्ट्स **बारकोड वाले किसी भी उत्पाद के लिए एक विशाल, खुला डेटाबेस है, जो खाद्य, कॉस्मेटिक या पालतू भोजन नहीं है**।';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      '**इलेक्ट्रॉनिक्स** से लेकर **खिलौनों** और **कपड़ों** से लेकर **सफाई के सामान** तक, अगर उसमें बारकोड है, तो उसे जोड़ा जा सकता है। इस परियोजना का उद्देश्य रोज़मर्रा की वस्तुओं के लिए \"इंटरनेट ऑफ़ थिंग्स\" बनाना है, जिससे उनके बारे में जानकारी सर्वसुलभ हो सके।';

  @override
  String get guide_open_products_facts_features_title =>
      'खुले उत्पादों की विशेषताएं और तथ्य';

  @override
  String get guide_open_products_facts_features_text =>
      'ओपन प्रोडक्ट्स फैक्ट्स का उद्देश्य उपभोक्ताओं को उनकी वस्तुओं के रखरखाव, मरम्मत, पुनर्चक्रण या उन्हें नया मालिक देने के लिए परिपत्र समाधान प्रदान करके वस्तुओं का जीवन बढ़ाना है।';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'कुछ उत्पादों के लिए कार्बन फुटप्रिंट';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      'फ्रांसीसी पर्यावरण प्राधिकरण ADEME द्वारा **प्रभाव CO2** कई श्रेणियों के **कार्बन प्रभाव** प्रदान करता है, उत्पादों को सटीक रूप से वर्गीकृत करना सुनिश्चित करें।';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'कई उत्पादों के लिए मरम्मत योग्यता सूचकांक';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'जब भी कोई फ़्रांसीसी पुनर्संयोजन सूचकांक उपलब्ध होगा, हम उसे प्रदर्शित करेंगे। इसके अलावा, **आप फ़ोक्सोनॉमी इंजन का उपयोग करके चरों को एकत्रित करना शुरू कर सकते हैं**; ताकि हम भविष्य में, उन देशों में भी जहाँ यह उपलब्ध नहीं है, स्वयं इसकी पुनर्गणना कर सकें।';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'अपने उत्पाद को दान/पुनर्विक्रय करने के तरीके खोजें';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'हम **थर्ड-पार्टी सर्कुलर फ्रेंडली सेवाओं** के लिंक प्रदान करते हैं जो आपको अपनी पसंद का उत्पाद, सेकंड-हैंड उत्पाद के रूप में, ग्रहीय संसाधनों पर अधिक नियंत्रण रखने में मदद करते हैं।\nध्यान दें कि हमें ऐसा करने के लिए भुगतान नहीं किया जाता है, और यह प्रणाली केवल फ्रांस में दो वेबसाइटों के लिए उदाहरण के तौर पर काम करती है। आप विकी पर और अधिक साइटों का दस्तावेज़ीकरण करके इस प्रणाली का विस्तार करने में मदद कर सकते हैं।';

  @override
  String get guide_open_products_facts_information_title =>
      'कौन सी जानकारी उपयोगी है?';

  @override
  String get guide_open_products_facts_information_text =>
      'इतनी विस्तृत श्रृंखला के लिए, **हमारा एकत्रित डेटा लचीला है**। ऐसा करने के लिए, **हमने फोल्क्सोनॉमी इंजन** बनाया है।';

  @override
  String get guide_open_products_facts_folksonomy_title => 'फोल्क्सोनोमी इंजन';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'फोल्क्सोनॉमी इंजन एक ऐसा टूल है जो आपको प्रासंगिक गुणों वाले उत्पाद तैयार करने में मदद करता है। यह खोज और खोज क्षमता को बेहतर बनाने में मदद करता है, साथ ही भविष्य में दिलचस्प चीज़ों की गणना और प्रदर्शन भी करता है।';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'आप कोई भी कुंजी और मान जोड़ सकते हैं जैसे: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'आपको संभावित गुणों का स्वतः सुझाव मिलेगा, और आप अपने पसंदीदा प्रकार के उत्पादों पर नए गुण जोड़ने और दस्तावेज करने के लिए स्वागत योग्य हैं।';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-hi.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'खुली खाद्य प्राथमिकताएँ';

  @override
  String get guide_coming_soon_button_title => 'जल्द आ रहा है';

  @override
  String get guide_learn_more_subtitle => 'अधिक जानने के लिए टैप करें';

  @override
  String get preview_badge => 'पूर्व दर्शन';

  @override
  String get prices_feedback_form =>
      'इस नई सुविधा के बारे में हमें अपनी प्रतिक्रिया भेजने के लिए यहां क्लिक करें!';

  @override
  String get menu_button_list_actions => 'एक क्रिया चुनें';

  @override
  String get error_loading_photo => 'फ़ोटो लोड करने में त्रुटि';

  @override
  String get photo_viewer_action_use_picture_as => '…के रूप में उपयोग करें';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'इस चित्र का उपयोग…के रूप में करें';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'इस चित्र का उपयोग… ($language) के रूप में करें';
  }

  @override
  String get photo_viewer_details_button => 'विवरण';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'इस तस्वीर का विवरण';

  @override
  String get photo_viewer_details_title => 'फोटो का विवरण';

  @override
  String get photo_viewer_details_contributor_title => 'सहयोगी';

  @override
  String get photo_viewer_details_size_title => 'आकार';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height पिक्सेल';
  }

  @override
  String get photo_viewer_details_date_title => 'तारीख';

  @override
  String get photo_viewer_details_url_title => 'यूआरएल';

  @override
  String get product_page_compatibility_score => 'अनुकूल';

  @override
  String get user_lists_action_multi_select => 'बहु-चयन';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'आपका संगतता स्कोर: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Front picture';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Ingredients picture';

  @override
  String get product_image_nutrition_accessibility_label => 'पोषण चित्र';

  @override
  String get product_image_packaging_accessibility_label => 'पैकेजिंग चित्र';

  @override
  String get product_image_other_accessibility_label => 'अन्य चित्र';

  @override
  String get product_image_outdated_message => 'यह चित्र पुराना हो सकता है';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (यह छवि पुरानी हो सकती है)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (यह छवि निर्माता द्वारा लॉक की जा सकती है)';
  }

  @override
  String get product_image_error => 'छवि लोड करने में असमर्थ!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type लोड करने में असमर्थ (नेटवर्क त्रुटि?)';
  }

  @override
  String get product_page_image_no_image_available => 'कोई\nछवि नहीं!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'इस उत्पाद के लिए कोई चित्र उपलब्ध नहीं है';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'क्रियाओं को पुनः क्रमित करें या छिपाएँ';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'क्रियाएँ संपादित करें';

  @override
  String get product_page_action_bar_item_move_up => 'बढ़ाना';

  @override
  String get product_page_action_bar_item_move_down => 'नीचे की ओर';

  @override
  String get product_page_action_bar_item_enable => 'कार्रवाई सक्षम करें';

  @override
  String get product_page_action_bar_item_disable => 'कार्रवाई अक्षम करें';

  @override
  String get product_page_pending_operations_banner_title =>
      'आपके संपादन अपलोड हो रहे हैं…';

  @override
  String get product_page_pending_operations_banner_message =>
      'इस पृष्ठ पर प्रदर्शित डेटा **अभी तक आपके संशोधनों को प्रतिबिंबित नहीं करता है**।\nकृपया कुछ सेकंड प्रतीक्षा करें…';

  @override
  String get product_add_a_language => 'भाषा जोड़ें';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'बारकोड $barcode';
  }

  @override
  String get carousel_close_tooltip => 'इस उत्पाद को कैरोसेल से निकालें';

  @override
  String get carousel_unsupported_header => 'असमर्थित बारकोड!';

  @override
  String get carousel_unsupported_title => 'उफ़!';

  @override
  String get carousel_unsupported_text =>
      'स्कैन किया गया बारकोड ओपन फूड फैक्ट्स द्वारा समर्थित नहीं है!';

  @override
  String get carousel_error_header => 'गलती!';

  @override
  String get carousel_error_title => 'यह तो बहुत बुरी बात है!';

  @override
  String get carousel_error_text_1 =>
      'हम इस बारकोड पर जानकारी डाउनलोड नहीं कर सके:';

  @override
  String get carousel_error_text_2 =>
      'कृपया अपना इंटरनेट कनेक्शन जांचें या इस बटन पर क्लिक करें:';

  @override
  String get carousel_error_button => 'फिर कोशिश करें  ।';

  @override
  String get carousel_unknown_product_header => 'अज्ञात उत्पाद';

  @override
  String get carousel_unknown_product_title =>
      'बधाई हो!\nआपको __दुर्लभ रत्न मिल गया है!__';

  @override
  String get carousel_unknown_product_text =>
      'हमारे सहयोगी डेटाबेस में **3 मिलियन से अधिक उत्पाद** हैं, लेकिन यह बारकोड मौजूद नहीं है: ';

  @override
  String get carousel_unknown_product_button => 'इस उत्पाद को ऐड करें';

  @override
  String get carousel_loading_header => 'जानकारी लोड हो रही है...';

  @override
  String get carousel_loading_title =>
      'आपने अभी-अभी निम्नलिखित बारकोड वाला उत्पाद स्कैन किया है:';

  @override
  String get carousel_loading_text =>
      'हम इसे अपने **3 मिलियन से अधिक उत्पादों** के डेटाबेस में खोज रहे हैं!';

  @override
  String get product_type_subtitle_food => 'सब्जियां, फल, जमे हुए भोजन…';

  @override
  String get product_type_subtitle_beauty => 'मेकअप, साबुन, टूथपेस्ट…';

  @override
  String get product_type_subtitle_pet_food =>
      'कुत्तों, बिल्लियों के लिए भोजन…';

  @override
  String get product_type_subtitle_product => 'स्मार्टफ़ोन, फ़र्नीचर…';

  @override
  String get photo_field_front => 'उत्पाद फोटो';

  @override
  String get photo_field_ingredients => 'सामग्री की तस्वीर';

  @override
  String get photo_field_nutrition => 'पोषण फोटो';

  @override
  String get photo_field_packaging => 'रीसाइक्लिंग निर्देश फोटो';

  @override
  String get photo_already_exists => 'यह फ़ोटो पहले से मौजूद है';

  @override
  String get photo_missing => 'यह फ़ोटो गायब है';

  @override
  String get date => 'तारीख';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'पिछली कार्रवाई को पूर्ववत करें';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$locationका एक विश्व मानचित्र';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'ओपनस्ट्रीटमैप योगदानकर्ता';

  @override
  String get not_applicable_short => 'लागू नहीं';

  @override
  String get knowledge_panel_warning_text => 'चेतावनी';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'यह न्यूट्री-स्कोर पैकेज पर दिए गए न्यूट्री-स्कोर से अलग क्यों है?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'इसके दो संभावित कारण हैं:\nसामग्री की सूची और/या पोषण संबंधी तथ्य अद्यतित नहीं हैं।\n\nहम न्यूट्री-स्कोर (या V2) की \"नई गणना\" प्रदान करते हैं। कृपया जाँच लें कि पैकेज पर \"नई गणना\" का बैनर लगा है।';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'सामग्री की जाँच करें';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'पोषण संबंधी तथ्यों की जाँच करें';

  @override
  String url_not_supported(String url) {
    return 'दुर्भाग्यवश, हम यह URL नहीं खोल सकते:\n$url';
  }

  @override
  String get product_list_export => 'निर्यात';

  @override
  String get product_list_import => 'आयात';

  @override
  String get product_footer_action_barcode => 'बारकोड देखें';

  @override
  String get product_footer_action_barcode_short => 'बारकोड';

  @override
  String get product_footer_action_open_website => 'वेबसाइट खोलें';

  @override
  String get product_footer_action_report => 'प्रतिवेदन';

  @override
  String get product_footer_action_contributor_guide => 'मदद';

  @override
  String get product_footer_action_data_quality_tags =>
      'आधार सामग्री की गुणवत्ता';

  @override
  String get product_page_tab_for_me => 'मेरे लिए';

  @override
  String get product_page_tab_website => 'वेबसाइट';

  @override
  String get product_page_tab_prices => 'कीमतों';

  @override
  String get prices_explanation_card_title => 'कीमतें क्यों?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** दुनिया भर के उत्पादों की कीमतें एकत्रित करने और उन्हें साझा करने का एक प्रोजेक्ट है। Open Prices का विकास और रखरखाव ओपन फ़ूड फ़ैक्ट्स द्वारा किया जाता है।';

  @override
  String get explanation_card_learn_more_button => 'और अधिक जानें';

  @override
  String get product_page_tab_folksonomy => 'लोक्सोनोमी';

  @override
  String get folksonomy_explanation_card_title =>
      'फोल्क्सोनॉमी विशेषताएँ क्या हैं?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'विशेषताएँ **कुंजी-मूल्य** आधारित हैं।';

  @override
  String get folksonomy_explanation_card_line2 =>
      'ये गुण किसी भी प्रकार के उपयोग के लिए योगदानकर्ताओं द्वारा बनाए और दर्ज किए जाते हैं।';

  @override
  String get folksonomy_action_external_link_title => 'बाहरी लिंक खोलें';

  @override
  String get folksonomy_action_external_link_warning =>
      'बाहरी लिंक असुरक्षित हो सकते हैं। क्या आप वाकई उन पर जाना चाहते हैं?';

  @override
  String get prices_products_empty_title => 'कोई मूल्य उपलब्ध नहीं';

  @override
  String get prices_products_empty_explanation => 'सबसे पहले योगदान करें!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'शीर्ष $pageSize उत्पाद (कुल: $total)';
  }

  @override
  String get app_review_title => 'क्या आप इस ऐप का आनंद ले रहे हैं?';

  @override
  String get app_review_low => 'बेहतर कर सकते थे';

  @override
  String get app_review_medium => 'इतना खराब भी नहीं';

  @override
  String get app_review_high => 'मुझे इससे प्यार है!';

  @override
  String get app_review_feedback_modal_title =>
      'हमारे एप्लिकेशन को बेहतर बनाने में हमारी सहायता करें';

  @override
  String get app_review_feedback_modal_content =>
      'यदि आपके पास कुछ मिनट हों, तो कृपया इस फॉर्म का उत्तर दें ताकि **हम भविष्य में अपडेट में सुधार कर सकें**:';

  @override
  String get app_review_feedback_modal_open_form => 'फॉर्म का उत्तर दें';

  @override
  String get app_review_feedback_modal_later => 'मुझसे बाद में पूछें';

  @override
  String get nutrition_facts_extract_new =>
      'नया: आप चित्र से पोषक तत्वों को स्वचालित रूप से निकाल सकते हैं!';

  @override
  String get nutrition_facts_extract_button_text => 'अभी निकालें';

  @override
  String get nutrition_facts_extract_in_progress => 'निष्कर्षण प्रगति पर है…';

  @override
  String get nutrition_facts_extract_successful => 'निष्कर्षण सफल';

  @override
  String get nutrition_facts_extract_failed =>
      'चित्र से पोषक तत्व निकालने में विफल';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'आंकड़े';

  @override
  String get prices_stats_title => 'मूल्य सांख्यिकी';

  @override
  String get prices_stats_prices_section => 'कीमतों';

  @override
  String get prices_stats_products_section => 'उत्पादों';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'मिश्रित';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'खाना';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'उत्पादों';

  @override
  String get prices_stats_pet_food => 'पालतू भोजन';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'देशों';

  @override
  String get prices_stats_price_tag => 'मूल्य का टैग';

  @override
  String get prices_stats_receipt => 'रसीद';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'वेबसाइट';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'एपीआई';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'अंतिम बार अद्यतन किया गया';

  @override
  String get prices_stats_error => 'आंकड़े लोड करते समय एक त्रुटि हुई.';

  @override
  String get product_edit_robotoff_question_answered =>
      'प्रश्न का उत्तर मिल गया!';

  @override
  String get product_edit_robotoff_proof => 'सबूत';

  @override
  String get preferences_card_general => 'सामान्य';

  @override
  String get preferences_prices_title => 'कीमतों';

  @override
  String get preferences_prices_subtitle =>
      'अपनी मूल्य प्राथमिकताएँ प्रबंधित करें';

  @override
  String get preferences_card_project => 'ओपन फ़ूड फैक्ट्स परियोजना';

  @override
  String get preferences_contribute_title => 'Contribute';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'मेरे आँकड़े';

  @override
  String get preferences_contribute_subtitle =>
      'अनुवाद करें, हमारे उपकरणों को बेहतर बनाएं…';

  @override
  String get preferences_connect_title => 'जोड़ना';

  @override
  String get preferences_connect_subtitle =>
      'हमसे संपर्क करें, या सोशल मीडिया पर हमें फ़ॉलो करें';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'दुनिया भर के लाखों उपभोक्ताओं को सूचित करने में हमारी सहायता करें';

  @override
  String get preferences_card_help => 'सहायता और समर्थन';

  @override
  String get preferences_faq_title => 'अक्सर पूछे जाने वाले प्रश्न';

  @override
  String get preferences_faq_subtitle => 'अपने प्रश्नों के उत्तर प्राप्त करें';

  @override
  String get logged_out => 'बाहर आ गये';

  @override
  String get preferences_app_bar_message =>
      'हमारे सदस्यों में से एक बनने के लिए धन्यवाद!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'सभी आँकड़े देखें';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '$provider में \"$keyword\" खोजें';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'किसी सेटिंग की खोज करें (जैसे न्यूट्री-स्कोर)';

  @override
  String get preferences_accessibility_show_emoji => 'पहुँच: इमोजी दिखाएँ';

  @override
  String get preferences_accessibility_remove_colors => 'पहुँच: रंग हटाएँ';

  @override
  String get preferences_app_settings_products => 'उत्पादों';

  @override
  String get preferences_card_about => 'जानकारी';

  @override
  String get preferences_legal_information_title => 'कानूनी जानकारी';

  @override
  String get preferences_legal_information_subtitle =>
      'उपयोग की शर्तें, गोपनीयता नीति, और अधिक';

  @override
  String get preferences_terms_of_use => 'उपयोग की शर्तें';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts एक खाद्य उत्पाद डेटाबेस है जो **सभी के लिए, सभी के द्वारा बनाया गया है**।\nआप इसका उपयोग बेहतर भोजन विकल्प बनाने के लिए कर सकते हैं, और चूंकि यह **खुला डेटा** है, कोई भी इसे किसी भी उद्देश्य के लिए **पुनः उपयोग कर सकता है**।';

  @override
  String get preferences_privacy_policy => 'गोपनीयता नीति';

  @override
  String get preferences_licenses => 'लाइसेंस';

  @override
  String get preferences_about_app_title => 'ऐप के बारे में';

  @override
  String get preferences_about_app_subtitle =>
      'तकनीकी जानकारी, डेवलपर जानकारी, और अधिक';

  @override
  String get preferences_card_information => 'जानकारी';

  @override
  String get preferences_version_number_title => 'संस्करण संख्या';

  @override
  String get preferences_scanner_title => 'स्कैनर';

  @override
  String get preferences_app_store => 'ऐप स्टोर';

  @override
  String get preferences_app_system_settings => 'सिस्टम सेटिंग्स';

  @override
  String get preferences_source_code => 'स्रोत कोड तक पहुँचें';

  @override
  String get preferences_source_code_subtitle =>
      'और लाखों लोगों पर प्रभाव डालना शुरू करें';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'पूर्ण उत्पाद';

  @override
  String get preferences_tips => 'सुझावों';

  @override
  String get tips_discover_nutriscore => 'नए न्यूट्री-स्कोर की खोज करें';

  @override
  String get preferences_on_off_website_subtitle =>
      'ओपन फ़ूड फैक्ट्स वेबसाइट पर';

  @override
  String get preferences_manage_account_title => 'मेरा खाता प्रबंधित करें';

  @override
  String get preferences_manage_account_tooltip => 'अपना खाता प्रबंधित करें';

  @override
  String get preferences_change_password_title => 'मेरा पारण शब्द बदलें';

  @override
  String get preferences_danger_zone => 'खतरा क्षेत्र';

  @override
  String get preferences_account_deletion_subtitle =>
      'आपके सभी योगदान नष्ट हो जायेंगे';

  @override
  String get preferences_contributions_title => 'योगदान';

  @override
  String get preferences_dev_mode_app_settings_title => 'ऐप सेटिंग्स';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'उत्पादों को ऑफ़लाइन स्कैन करने का बहुत ही प्रयोगात्मक तरीका';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'सर्वर से सभी उत्पादों को रीफ़्रेश करें';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'कृपया ऐसा करने से बचें जब तक कि अत्यंत आवश्यक न हो';

  @override
  String get preferences_dev_mode_demo_mode_title => 'डेमो मोड';

  @override
  String get preferences_dev_mode_add_cards_title => 'स्कैनर में कार्ड जोड़ें';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'स्कैनर में 3 नमूना उत्पाद जोड़ता है';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'फोल्क्सोनोमी होस्ट';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'होस्ट: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'सुगम्यता प्रयोग';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'कीमतों के लिए बहु-उत्पाद चयन';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'उपयोगकर्ता द्वारा आदेशित ज्ञान पैनल';

  @override
  String get preferences_dev_mode_location_search_title =>
      'स्थान खोज तक अस्थायी पहुँच';

  @override
  String get preferences_dev_mode_comparison_title =>
      '2 या 3 उत्पादों की साथ-साथ तुलना';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'उत्पाद सूची आयात';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'स्कोर और कार्यप्रणाली';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'जानें कि न्यूट्री-स्कोर की गणना कैसे की जाती है';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'कार्यप्रणाली में मुख्य परिवर्तनों की खोज करें';

  @override
  String get preferences_faq_discover_project_title =>
      'परियोजना के बारे में जानें';

  @override
  String get preferences_faq_discover_off_title =>
      'खुले भोजन के बारे में तथ्य जानें';

  @override
  String get preferences_faq_discover_obf_title =>
      'खुले सौंदर्य तथ्यों की खोज करें';

  @override
  String get preferences_faq_discover_opff_title =>
      'खुले पालतू भोजन के बारे में तथ्य जानें';

  @override
  String get preferences_faq_discover_op_title => 'Open Prices खोजें';

  @override
  String get preferences_faq_discover_opf_title =>
      'ओपन प्रोडक्ट्स के तथ्य जानें';

  @override
  String get preferences_faq_faq_title => 'FAQ - अक्सर पूछे जाने वाले प्रश्न';

  @override
  String get preferences_faq_off_ngo_title => 'ओपन फ़ूड फैक्ट्स एनजीओ';

  @override
  String get preferences_about_information_title => 'जानकारी';

  @override
  String get preferences_connect_community_updates_title =>
      'समुदाय अपडेट प्राप्त करें';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'ऐप और समुदाय की खबरों से अपडेट रहें';

  @override
  String get preferences_connect_community_calendar_title =>
      'हमारे सामुदायिक कैलेंडर की सदस्यता लें';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'हमारे किसी वर्चुअल कार्यक्रम में शामिल होकर इसमें शामिल हों';

  @override
  String get preferences_connect_blog_title => 'ओपन फ़ूड फैक्ट्स ब्लॉग';

  @override
  String get preferences_connect_blog_subtitle =>
      'नवीनतम समाचार प्राप्त करें, जैसे ही वे घटित हों';

  @override
  String get preferences_connect_community_help_title =>
      'समुदाय से सहायता प्राप्त करें';

  @override
  String get preferences_connect_improve_app_title =>
      'ऐप को बेहतर बनाने में हमारी मदद करें';

  @override
  String get preferences_connect_debug_info_title => 'हमें डिबग जानकारी भेजें';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'विस्तृत डिबगिंग जानकारी के साथ हमें एक ईमेल भेजें';

  @override
  String get preferences_connect_feedback_title =>
      'ऐप के बारे में हमें फ़ीडबैक भेजें';

  @override
  String get preferences_connect_feedback_subtitle =>
      'ऐप के भविष्य को आकार देने में मदद करें';

  @override
  String get preferences_connect_survey_title => 'ऐप सर्वेक्षण में भाग लें';

  @override
  String get preferences_connect_survey_subtitle =>
      'हमें यह समझने में मदद करें कि हमें आगे क्या बनाना चाहिए';

  @override
  String get preferences_connect_professionals_title => 'पेशेवरों';

  @override
  String get preferences_connect_pro_subtitle =>
      'पूरी तरह से मुफ़्त, 500 ऐप्स और लाखों उपभोक्ताओं के लिए सटीक डेटा सुनिश्चित करता है। स्वयं-सेवा, आपके PIM या स्प्रेडशीट (XLSX) के साथ संगत।';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'आरंभ करने के लिए संपर्क करें';

  @override
  String get preferences_connect_press_title => 'दबाएँ';

  @override
  String get preferences_connect_press_page_subtitle =>
      'अपनी रिपोर्ट के लिए आवश्यक सभी सामग्री प्राप्त करें';

  @override
  String get preferences_connect_press_email_subtitle =>
      'प्रेस पूछताछ के लिए या अपनी रिपोर्ट के बारे में हमें बताने के लिए हमसे संपर्क करें';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'एक सक्रिय स्वयंसेवक बनें';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'विकास, संचार, डिजाइन… किसी भी प्रकार की स्वयंसेवा या विशेषज्ञता का स्वागत है!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'जानें कि आप किस प्रकार योगदान कर सकते हैं';

  @override
  String get preferences_contribute_mobile_dev_title => 'मोबाइल ऐप विकास';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'सॉफ्टवेयर विकास में योगदान कैसे करें, जानें';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'दैनिक अस्थिर बिल्ड, बिल्कुल नई सुविधाएँ';

  @override
  String get preferences_contribute_local_community_title =>
      'अपने स्थानीय समुदाय का विकास करें';

  @override
  String get preferences_contribute_translate_subtitle =>
      'सॉफ्टवेयर, सामग्री, घटक विश्लेषण अनुवाद में सहायता';

  @override
  String get preferences_contribute_share_subtitle =>
      'हमने आपकी मदद के लिए एक छोटा सा टेम्पलेट तैयार किया है :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'अपने देश में खाद्य पारदर्शिता बढ़ाने के सरल कदम';

  @override
  String get preferences_contribute_data_quality_title =>
      'आधार सामग्री की गुणवत्ता';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'डेटा गुणवत्ता टीम में शामिल हों';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'डेटाबेस को पूर्ण और सटीक बनाने के हमारे प्रयास में शामिल हों';

  @override
  String get preferences_contributions_products_added_title =>
      'जोड़े गए उत्पाद';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'ओपन फ़ूड फैक्ट्स में मेरे द्वारा जोड़े गए नए उत्पाद';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'वे उत्पाद जिन्हें मुझे पूरा करना है';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'सभी अपूर्ण उत्पाद';

  @override
  String get preferences_my_contributions_prices_title => 'कीमतों';

  @override
  String get preferences_my_contributions_my_prices_title => 'मेरी कीमतें';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'मेरी कीमतें, मेरे प्रमाण…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'उत्पाद जिन्हें पूरा करने में आप मदद कर सकते हैं';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'अपने देश में न्यूट्री-स्कोर और ग्रीन-स्कोर की गणना में सहायता करें';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'मेरे द्वारा योगदान की गई कीमतें';

  @override
  String get preferences_prices_proofs_subtitle => 'मूल्य टैग और रसीदें';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'अपनी रसीदों की तस्वीरें लें और संबंधित बारकोड स्कैन करें';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'दुकान में कीमतों की तस्वीरें लें';

  @override
  String get preferences_prices_newest_title => 'नवीनतम कीमतें';

  @override
  String get preferences_prices_newest_subtitle =>
      'Open Prices समुदाय द्वारा जोड़े गए नवीनतम मूल्य';

  @override
  String get preferences_prices_top_contributors_title =>
      'सबसे अधिक मूल्य वाले योगदानकर्ता';

  @override
  String get preferences_prices_metrics_title => 'खुले मूल्य मेट्रिक्स';

  @override
  String get preferences_prices_metrics_subtitle =>
      'परियोजना के विकास का अनुसरण करें';

  @override
  String get preferences_prices_ways_contribute_title => 'योगदान करने के तरीके';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'AI की सहायता से स्वयं या अन्य लोगों द्वारा जोड़े गए मूल्यों की पुष्टि करें';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'अपने कैमरा रोल से जल्दी से कई रसीदें या अलमारियों की तस्वीरें जोड़ें';

  @override
  String get preferences_prices_challenges_title => 'मासिक चुनौतियाँ';

  @override
  String get preferences_prices_challenges_subtitle =>
      'मूल्य एकत्र करने के लिए मासिक विषयगत खोजों में भाग लें';

  @override
  String get preferences_prices_loyalty_data_title =>
      'अपना लॉयल्टी डेटा पुनः प्राप्त करें';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'अपने डेटा का अनुरोध कैसे करें, जानें';

  @override
  String get preferences_page_customize_app_title => 'ऐप को अनुकूलित करें';

  @override
  String get preferences_page_contribute_project_title =>
      'परियोजना में योगदान करें';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'मदद करने के सरल तरीके: Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'स्कोर पद्धतियाँ, सहायता, और परियोजना के बारे में अधिक जानकारी';

  @override
  String get product_edit_robotoff_positive_button => 'सुझाव स्वीकार करें';

  @override
  String get product_edit_robotoff_negative_button => 'सुझाव अस्वीकार करें';

  @override
  String get product_edit_robotoff_show_proof => 'सबूत दिखाओ';

  @override
  String get product_edit_robotoff_expand_proof => 'प्रमाण का विस्तार करें';

  @override
  String get product_page_tab_raw_data => 'कच्चा डेटा';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'पृष्ठ $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'पेज $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count में से $total आइटम';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count में से $total आइटम';
  }

  @override
  String item_count(int count) {
    return '$count आइटम';
  }

  @override
  String item_count_string(String count) {
    return '$count आइटम';
  }

  @override
  String get prices_no_result => 'कोई मूल्य आँकड़े नहीं मिले.';

  @override
  String get prices_error_loading_more_items => 'अधिक आइटम लोड करने में त्रुटि';

  @override
  String get prices_proof_error =>
      'प्रमाणीकरण विफल, प्रमाण प्राप्त करने में असमर्थ';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count में से $total प्रमाण';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count में से $total योगदानकर्ता';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count में से $total स्थान';
  }

  @override
  String prices_locations_count(int count) {
    return '$count स्थान';
  }

  @override
  String get restart_to_apply_message =>
      'कृपया परिवर्तन लागू करने के लिए ऐप को पुनः प्रारंभ करें।';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'ग्राफ़िकल इंटरफ़ेस';

  @override
  String get preferences_app_settings_media_title => 'मिडिया';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'ओपन फ़ूड फैक्ट्स लैब्स';

  @override
  String get preferences_root_account_title => 'खाता';

  @override
  String get preferences_contribute_translate_header =>
      'खुले भोजन के तथ्यों को अपनी भाषा में लाएँ';

  @override
  String get preferences_contribute_enroll_alpha =>
      'ऐप के अल्फ़ा संस्करण में नामांकन करें';

  @override
  String get preferences_dev_mode_section_data => 'योगदान और उत्पाद डेटा';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'फोल्क्सोनॉमी न दिखाएं';

  @override
  String get preferences_account_title => 'खाता';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '$createdपर जोड़ा गया';
  }

  @override
  String get location_map_details_title => 'स्थान विवरण';

  @override
  String get location_map_details_name => 'नाम';

  @override
  String get location_map_details_street => 'गली';

  @override
  String get location_map_details_city => 'शहर';

  @override
  String get location_map_details_postcode => 'पोस्टकोड';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'COORDINATES';

  @override
  String get location_map_details_osm_id => 'ओएसएम आईडी';
}
