// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => ' ';

  @override
  String get yes => 'Oui';

  @override
  String get add => 'Ajouter';

  @override
  String get account_delete_message =>
      'Êtes-vous sûr de vouloir supprimer votre compte ?\nS\'il y a une raison spécifique, veuillez la partager ci-dessous';

  @override
  String get reason => 'Raison';

  @override
  String get okay => 'Ok';

  @override
  String get validate => 'Valider';

  @override
  String get create => 'Créer';

  @override
  String get applyButtonText => 'Appliquer';

  @override
  String get next_label => 'Suivant';

  @override
  String get continue_label => 'Continuer';

  @override
  String get exit_label => 'Quitter';

  @override
  String get previous_label => 'Précédent';

  @override
  String get go_back_to_top => 'Retourner en haut';

  @override
  String get save => 'Enregistrer';

  @override
  String get save_confirmation => 'Voulez-vous vraiment sauvegarder ?';

  @override
  String get skip => 'Ignorer';

  @override
  String get cancel => 'Annuler';

  @override
  String get ignore => 'Ignorer';

  @override
  String get close => 'Fermer';

  @override
  String get no => 'Non';

  @override
  String get stop => 'Arrêter';

  @override
  String get finish => 'Terminer';

  @override
  String get calculate => 'Calculer';

  @override
  String get reset_food_prefs => 'Réinitialiser les préférences alimentaires';

  @override
  String get error => 'Une erreur s\'est produite';

  @override
  String get error_occurred => 'Une erreur s’est produite';

  @override
  String get featureInProgress =>
      'Nous travaillons encore sur cette fonctionnalité, restez à l\'écoute';

  @override
  String get label_web => 'Voir sur le Web';

  @override
  String get learnMore => 'En savoir plus';

  @override
  String get unknown => 'Inconnu';

  @override
  String get match_very_good => 'Très compatible';

  @override
  String get match_good => 'Compatible';

  @override
  String get match_poor => 'Peu compatible';

  @override
  String get match_may_not => 'Compatibilité incertaine';

  @override
  String get match_does_not => 'Pas de compatibilité';

  @override
  String get match_unknown => 'Compatibilité inconnue';

  @override
  String get match_short_very_good => 'Très compatible';

  @override
  String get match_short_good => 'Compatible';

  @override
  String get match_short_poor => 'Peu compatible';

  @override
  String get match_short_may_not => 'Compatibilité incertaine';

  @override
  String get match_short_does_not => 'Pas de compatibilité';

  @override
  String get match_short_unknown => 'Compatibilité inconnue';

  @override
  String get licenses => 'Licences';

  @override
  String get looking_for => 'À la recherche de';

  @override
  String get welcomeToOpenFoodFacts => 'Bienvenue sur Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts est une organisation mondiale à but non lucratif alimentée par les communautés locales.';

  @override
  String get productDataUtility =>
      'Consultez les données alimentaires selon vos préférences.';

  @override
  String get healthCardUtility =>
      'Choisissez des aliments qui sont bons pour vous.';

  @override
  String get ecoCardUtility =>
      'Choisissez des aliments qui sont bons pour la planète.';

  @override
  String get server_error_open_new_issue =>
      'Pas de réponse du serveur ! Vous pouvez ouvrir un incident avec le lien ci-dessous.';

  @override
  String get sign_in_text =>
      'Connectez-vous à votre compte Open Food Facts pour enregistrer vos contributions';

  @override
  String get incorrect_credentials =>
      'Nom d\'utilisateur ou mot de passe incorrect.';

  @override
  String get password_lost_incorrect_credentials =>
      'Cet e-mail ou ce nom d\'utilisateur n\'existe pas. Veuillez vérifier vos informations d\'identification.';

  @override
  String get password_lost_server_unavailable =>
      'Nous subissons actuellement des ralentissements sur nos serveurs et nous nous en excusons. Veuillez réessayer plus tard.';

  @override
  String get login => 'Connexion';

  @override
  String get login_result_type_server_unreachable =>
      'Impossible de se connecter au réseau';

  @override
  String get login_result_type_server_issue =>
      'Problème serveur. Essayez plus tard.';

  @override
  String get login_page_username_or_email =>
      'Veuillez saisir un nom d\'utilisateur ou un e-mail';

  @override
  String get login_page_password_error_empty =>
      'Veuillez saisir un mot de passe';

  @override
  String get create_account => 'Créer un compte';

  @override
  String get sign_in => 'Se connecter';

  @override
  String get sign_in_mandatory =>
      'Pour cette fonctionnalité, vous devez vous connecter.';

  @override
  String get help_improve_country =>
      'Aidez-nous à améliorer Open Food Facts dans votre pays';

  @override
  String get sign_out => 'Se déconnecter';

  @override
  String get sign_out_confirmation => 'Voulez-vous vraiment vous déconnecter ?';

  @override
  String get password => 'Mot de passe';

  @override
  String get forgot_password => 'Mot de passe oublié';

  @override
  String get forgot_password_question => 'Mot de passe oublié ?';

  @override
  String get view_profile => 'Afficher le profil';

  @override
  String get reset_password => 'Réinitialiser le mot de passe';

  @override
  String get reset_password_explanation_text =>
      'En cas d\'oubli du mot de passe, saisissez votre nom d\'utilisateur ou votre adresse e-mail pour recevoir les instructions de réinitialisation du mot de passe. N\'oubliez pas non plus de vérifier le dossier Spam.';

  @override
  String get username_or_email => 'Nom d\'utilisateur ou e-mail';

  @override
  String get reset_password_done =>
      'Un e-mail avec un lien pour réinitialiser votre mot de passe a été envoyé à l\'adresse e-mail associée à votre compte. Vérifiez également vos indésirables';

  @override
  String get send_reset_password_mail => 'Modifier le mot de passe';

  @override
  String get enter_some_text => 'Veuillez saisir du texte';

  @override
  String get sign_up_page_title => 'S\'inscrire';

  @override
  String get sign_up_page_action_button => 'S\'inscrire';

  @override
  String get sign_up_page_action_doing_it => 'Inscription en cours…';

  @override
  String get sign_up_page_action_ok =>
      'Toutes nos félicitations ! Votre compte vient d\'être créé.';

  @override
  String get sign_up_page_display_name_hint => 'Nom';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Veuillez saisir le nom d\'affichage que vous souhaitez utiliser';

  @override
  String get sign_up_page_email_hint => 'Courriel';

  @override
  String get sign_up_page_email_error_empty => 'Une adresse est requise';

  @override
  String get sign_up_page_email_error_invalid => 'E-mail invalide';

  @override
  String get sign_up_page_username_hint =>
      'Nom d\'utilisateur : visible publiquement';

  @override
  String get sign_up_page_username_error_empty =>
      'Veuillez saisir un nom d\'utilisateur';

  @override
  String get sign_up_page_username_error_invalid =>
      'Veuillez saisir un nom d\'utilisateur valide';

  @override
  String get sign_up_page_username_description =>
      'Le nom d\'utilisateur ne peut pas contenir d\'espaces, de majuscules ou de caractères spéciaux.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Le nom d\'utilisateur ne peut pas dépasser $value caractères';
  }

  @override
  String get sign_up_page_password_hint => 'Mot de passe';

  @override
  String get sign_up_page_password_error_empty =>
      'Veuillez saisir un mot de passe';

  @override
  String get sign_up_page_password_error_invalid =>
      'Veuillez saisir un mot de passe valide (au moins 6 caractères)';

  @override
  String get sign_up_page_confirm_password_hint => 'Confirmez le mot de passe';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Veuillez confirmer le mot de passe';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Les mots de passe ne correspondent pas';

  @override
  String get sign_up_page_agree_text => 'Je suis d\'accord avec les';

  @override
  String get sign_up_page_terms_text =>
      'conditions d\'utilisation et de contribution d\'Open Food Facts';

  @override
  String get donate_url => 'https://donner.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Lors de la création d\'un compte, l\'acceptation des conditions d\'utilisation est obligatoire, cependant, des contributions anonymes peuvent toujours être effectuées via l\'application';

  @override
  String get sign_up_page_producer_checkbox =>
      'Je suis un producteur alimentaire';

  @override
  String get sign_up_page_producer_hint => 'Producteur/marque';

  @override
  String get sign_up_page_producer_error_empty =>
      'Veuillez saisir un nom de producteur ou de marque';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Je souhaite m\'inscrire à la newsletter Open Food Facts (Vous pouvez vous désinscrire à tout moment)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Ce nom d\'utilisateur existe déjà, veuillez en choisir un autre.';

  @override
  String get sign_up_page_email_already_exists =>
      'existe déjà, connectez-vous au compte ou essayez avec une autre adresse e-mail.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Veuillez fournir une adresse e-mail valide.';

  @override
  String get sign_up_page_server_busy =>
      'Nous sommes profondément désolés, nous rencontrons quelques difficultés techniques pour créer votre compte. Veuillez réessayer plus tard.';

  @override
  String get settingsTitle => 'Paramètres';

  @override
  String get darkmode => 'Thème';

  @override
  String get darkmode_dark => 'Sombre';

  @override
  String get darkmode_light => 'Clair';

  @override
  String get darkmode_system_default => 'Valeur du système';

  @override
  String get thanks_for_contributing => 'Merci pour votre contribution';

  @override
  String get contributors_label => 'Ils/Elles bâtissent l\'appli';

  @override
  String get contributors_dialog_title => 'Contributeurs';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Contributeur: $name';
  }

  @override
  String get contributors_description =>
      'Une liste de tous les contributeurs de cette appli';

  @override
  String get support => 'Assistance';

  @override
  String get support_join_slack => 'Demandez de l\'aide sur notre canal Slack';

  @override
  String get support_via_forum => 'Demandez de l\'aide sur notre forum';

  @override
  String get support_via_email => 'Envoyez-nous un e-mail';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Envoyer les journaux de débogage ?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Souhaitez-vous inclure les journaux d\'application en pièce jointe à votre e-mail ?';

  @override
  String get termsOfUse => 'Conditions d\'utilisation';

  @override
  String get legalNotices => 'Mentions légales';

  @override
  String get privacy_policy => 'Politique de confidentialité';

  @override
  String get about_this_app => 'À propos de cette appli';

  @override
  String get contribute => 'Contribuer';

  @override
  String get contribute_sw_development => 'Développement logiciel';

  @override
  String get contribute_develop_text =>
      'Le code source de chaque version d\'Open Food Facts est disponible sur GitHub. Vous pouvez réutiliser le code (il est open source) et nous aider à l\'améliorer, pour tout le monde, sur toute la planète.';

  @override
  String get contribute_develop_text_2 =>
      'Vous pouvez rejoindre le salon de discussion Slack Open Food Facts qui est le meilleur moyen de poser des questions.';

  @override
  String get contribute_develop_dev_mode_title => 'Mode de développement ? ';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'Activer le mode de développement';

  @override
  String get contribute_donate_title => 'Faire un don';

  @override
  String get contribute_donate_header =>
      'Faire un don à l\'association Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Veuillez noter qu\'avec la version alpha interne, une perte totale de données est possible et que l\'app peut devenir inutilisable à tout moment !';

  @override
  String get contribute_improve_ProductsToBeCompleted => 'Produits à compléter';

  @override
  String get contribute_improve_header => 'Améliorer';

  @override
  String get contribute_improve_text =>
      'La base de données est le cœur du projet. Il est facile de participer. Vous pouvez télécharger l\'appli mobile, et commencer à ajouter ou améliorer des produits existants: ';

  @override
  String get contribute_translate_header => 'Traduire';

  @override
  String get contribute_data_quality => 'Qualité des données';

  @override
  String get contribute_translate_link_text => 'Commencer à traduire';

  @override
  String get contribute_translate_text =>
      'Open Food Facts est un projet mondial, contenant des produits de plus de 160 pays. Open Food Facts est traduit dans des dizaines de langues, avec un contenu en constante évolution.';

  @override
  String get contribute_translate_text_2 =>
      'Les traductions sont l\'une des tâches clés du projet';

  @override
  String get contribute_join_skill_pool =>
      'Contribuez à Open Food Facts. Rejoignez la réserve de compétences !';

  @override
  String get contribute_share_header => 'Partagez Open Food Facts à vos amis';

  @override
  String get contribute_share_content =>
      'Je voulais te signaler l\'app que j\'utilise, Open Food Facts, qui te permet de voir l\'impact de ton alimentation sur la santé et l\'environnement, de manière personnalisée. Elle fonctionne en scannant les codes barres des emballages. Et en plus c\'est gratuit, sans inscription obligatoire, et tu peux même aider à augmenter le nombre de produits décryptés. Voilà le lien pour la télécharger: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribuez des prix en demandant un export RGPD des données de vos cartes de fidélité';

  @override
  String get tap_to_answer => 'Appuyez ici pour répondre aux questions';

  @override
  String get tap_to_answer_hint =>
      'Appuyez ici pour répondre aux questions sur ce produit';

  @override
  String get robotoff_questions_loading_hint =>
      'Veuillez patienter pendant le chargement des questions sur ce produit';

  @override
  String get saving_answer => 'Enregistrement de votre réponse';

  @override
  String get contribute_to_get_rewards =>
      'Devenez un acteur de la transparence alimentaire';

  @override
  String get question_sign_in_text =>
      'Connectez-vous à votre compte Open Food Facts pour être crédité de vos contributions';

  @override
  String get question_yes_button_accessibility_value => 'Répondre par oui';

  @override
  String get question_no_button_accessibility_value => 'Répondre par non';

  @override
  String get question_skip_button_accessibility_value =>
      'Passer cette question';

  @override
  String get tap_to_edit_search => 'Appuyez pour modifier la recherche';

  @override
  String get myPreferences => 'Mes préférences';

  @override
  String get account_create_message =>
      'Créez votre compte et rejoignez la communauté Open Food Facts pour aider à développer des connaissances alimentaires partout dans le monde !';

  @override
  String get join_us => 'Rejoignez-nous';

  @override
  String get myPreferences_profile_title => 'Votre profil';

  @override
  String get myPreferences_profile_subtitle =>
      'Gérez votre compte contributeur Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Paramètres de l\'application';

  @override
  String get myPreferences_settings_subtitle =>
      'Mode sombre, statistiques, ...';

  @override
  String get myPreferences_food_title => 'Préférences alimentaires';

  @override
  String get myPreferences_food_subtitle =>
      'Choisissez les informations sur la nourriture qui vous importent le plus.';

  @override
  String get myPreferences_food_comment =>
      'Choisissez les informations sur les aliments qui vous intéressent le plus, afin de classer les aliments en fonction de vos préférences, de voir les informations qui vous intéressent en premier et d\'obtenir un résumé de compatibilité. Ces préférences alimentaires restent sur votre appareil et ne sont pas associées à votre compte contributeur Open Food Facts si vous en avez un.';

  @override
  String get confirmResetPreferences =>
      'Réinitialiser vos préférences alimentaires ?';

  @override
  String get myPersonalizedRanking => 'Mon classement personnel';

  @override
  String get ranking_tab_all => 'Tout';

  @override
  String get ranking_subtitle_match_yes => 'Très bonne compatibilité';

  @override
  String get ranking_subtitle_match_no => 'Très mauvaise compatibilité';

  @override
  String get ranking_subtitle_match_maybe => 'Compatibilité inconnue';

  @override
  String get refresh_with_new_preferences =>
      'Actualisez la liste avec vos nouvelles préférences';

  @override
  String get reloaded_with_new_preferences =>
      'Rechargé avec vos nouvelles préférences';

  @override
  String get profile_navbar_label => 'Communauté';

  @override
  String get scan_navbar_label => 'Scanner';

  @override
  String get history_navbar_label => 'Historique';

  @override
  String get list_navbar_label => 'Listes';

  @override
  String get category => 'Filtrer par catégorie';

  @override
  String get category_all => 'Tout';

  @override
  String get category_search => '(recherche par catégorie)';

  @override
  String get filter => 'Filtre';

  @override
  String get scan => 'Produits actuellement dans l\'écran de scan';

  @override
  String get scan_history => 'Historique des scans';

  @override
  String get search => 'Rechercher';

  @override
  String get search_product_help =>
      'Rechercher un produit,\nune marque ou un code-barres';

  @override
  String get search_filter => 'Filtre de recherche';

  @override
  String get search_history => 'Historique de recherche';

  @override
  String get search_store => 'Rechercher un magasin';

  @override
  String get search_store_help => 'Conseil : ajoutez la ville ou le pays';

  @override
  String get tap_for_more => 'Appuyez pour plus d\'informations…';

  @override
  String get product => 'Produit';

  @override
  String get unknownBrand => 'Marque inconnue';

  @override
  String get unknownQuantity => 'quantité inconnue';

  @override
  String get unknownProductName => 'Produit inconnu';

  @override
  String get label_refresh => 'Actualiser';

  @override
  String get label_reload => 'Recharger';

  @override
  String get image => 'Image';

  @override
  String get front_photo => 'Photo frontale';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return 'ma traduction';
  }

  @override
  String get outdated_image_short_label => 'peut-être obsolète';

  @override
  String get ingredients => 'Ingrédients';

  @override
  String get ingredients_editing_instructions =>
      'Conservez l\'ordre original. Indiquer le pourcentage lorsque spécifié. Séparez par une virgule ou un trait d\'union, utilisez des parenthèses pour les ingrédients d\'un ingrédient.';

  @override
  String get ingredients_editing_error =>
      'Échec de l’enregistrement des ingrédients.';

  @override
  String get ingredients_editing_image_error =>
      'Échec de l\'obtention d\'une nouvelle image d\'ingrédients.';

  @override
  String get ingredients_editing_title => 'Modifier les ingrédients';

  @override
  String get ingredients_photo => 'Photo des ingrédients';

  @override
  String get packaging_editing_instructions =>
      'Listez toutes les pièces d\'emballage séparées par une virgule ou un saut de ligne, avec leur quantité (par exemple 1 ou 6) type (par exemple bouteille, boîte, canette), matériau (par exemple plastique, métal, aluminium) et si disponible leur taille (par exemple 33cl) et consignes de recyclage.\nExemple : 1 bouteille en verre à recycler, 1 bouchon en plastique à jeter';

  @override
  String get packaging_editing_error =>
      'Échec de l\'enregistrement de l\'emballage.';

  @override
  String get packaging_editing_image_error =>
      'Impossible d\'obtenir une nouvelle image d\'emballage.';

  @override
  String get packaging_editing_title => 'Modifier l\'emballage';

  @override
  String get nutrition => 'Nutrition';

  @override
  String get nutrition_facts_photo => 'Photo des informations nutritionnelles';

  @override
  String get nutrition_facts_editing_title =>
      'Modifier les informations nutritionnelles';

  @override
  String get packaging_information => 'Consignes de tri / recyclage';

  @override
  String get packaging_information_photo =>
      'Photo des informations de recyclage';

  @override
  String get missing_product => 'Vous avez trouvé un nouveau produit !';

  @override
  String get add_product_take_photos =>
      'Prenez des photos de l\'emballage pour ajouter ce produit à Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Veuillez d\'abord prendre quelques photos. Vous pouvez toujours compléter le produit ultérieurement.';

  @override
  String get add_product_information_button_label =>
      'Ajouter les informations sur le produit';

  @override
  String get new_product => 'Nouveau produit';

  @override
  String get new_product_found_title => 'Nouveau produit trouvé !';

  @override
  String get new_product_found_text =>
      'Notre base de données collaborative contient plus de **3 millions de produits**, mais ce code-barres n\'existe pas : ';

  @override
  String get new_product_found_button => 'Ajouter ce produit';

  @override
  String get new_product_leave_title => 'Quitter cette page ?';

  @override
  String get new_product_leave_message =>
      'Il semble que vous n\'ayez rien saisi. Voulez-vous vraiment quitter cette page ?';

  @override
  String get new_product_dialog_description =>
      'Veuillez prendre des photos de l\'emballage pour ajouter ce produit à notre base de données commune';

  @override
  String get new_product_dialog_illustration_description =>
      'Une illustration avec un Nutri-Score et un Green-Score inconnus';

  @override
  String get front_packaging_photo_button_label => 'Photo frontale du produit';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Confirmer le téleversement de la photo frontale du produit';

  @override
  String get confirm_button_label => 'Confirmer';

  @override
  String get send_image_button_label => 'Envoyer l\'image';

  @override
  String get crop_page_action_saving => 'Enregistrement de l\'image…';

  @override
  String get crop_page_action_cropping => 'Recadrage de l\'image…';

  @override
  String get crop_page_action_local => 'Enregistrement d\'une version locale…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oups… il y a un problème avec votre photo !';

  @override
  String get crop_page_action_local_failed_message =>
      'Nous ne pouvons pas traiter l\'image localement, avant de l\'envoyer à notre serveur. Veuillez réessayer plus tard ou contactez-nous si le problème persiste.';

  @override
  String get crop_page_action_retake => 'Reprendre une photo';

  @override
  String get crop_page_too_small_image_title => 'L\'image est trop petite !';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'La taille minimale en pixels pour le téléchargement d\'images est ${expectedMinWidth}x$expectedMinHeight. L\'image actuelle est ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Préparation d\'un appel au serveur…';

  @override
  String get front_packaging_photo_title => 'Photo de l\'emballage de face';

  @override
  String get ingredients_photo_title => 'Photo des ingrédients';

  @override
  String get nutritional_facts_photo_title =>
      'Photo des valeurs nutritionnelles';

  @override
  String get recycling_photo_title => 'Photo des consignes de tri ou recyclage';

  @override
  String get take_photo_title => 'Prendre une photo';

  @override
  String get take_more_photo_title => 'Prendre plus de photos';

  @override
  String get front_photo_uploaded => 'Photo de la face avant téléchargée';

  @override
  String get ingredients_photo_button_label => 'Photo des ingrédients';

  @override
  String get ingredients_photo_uploaded => 'Photo des ingrédients téléchargée';

  @override
  String get nutrition_cache_loading_error =>
      'Impossible de charger les nutriments à partir du cache';

  @override
  String get nutritional_facts_photo_button_label =>
      'Photo des informations nutritionnelles';

  @override
  String get nutritional_facts_input_button_label =>
      'Saisir les informations nutritionnelles';

  @override
  String get nutritional_facts_added => 'Informations nutritionnelles ajoutées';

  @override
  String get categories_added => 'Catégories ajoutées';

  @override
  String get new_product_title_nutriscore => 'Calculez le Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Merci d\'indiquer la catégorie de l\'aliment et les données nutritionnelles';

  @override
  String get new_product_title_environmental_score => 'Calculez le Green-Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Obtenez-le en remplissant au moins une catégorie';

  @override
  String get new_product_additional_environmental_score =>
      'Rendre le calcul du Green-Score plus précis avec les origines géographiques, l\'emballage et plus';

  @override
  String get new_product_title_nova =>
      'Calculer le niveau de transformation des aliments (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Obtenez-le en remplissant la catégorie alimentaire et les ingrédients';

  @override
  String get new_product_desc_nova_unknown =>
      'Degré de transformation des aliments inconnu';

  @override
  String get new_product_title_pictures => 'Prenons quelques photos !';

  @override
  String get new_product_title_pictures_details =>
      'Prenez les photos nécessaires, le moteur d\'Open Food Facts s\'occupera du reste !';

  @override
  String get new_product_title_misc => 'Et quelques données de base…';

  @override
  String new_product_done_msg(String username) {
    return 'Merci pour votre contribution « $username » !';
  }

  @override
  String get new_product_done_msg_no_user => 'Merci pour votre contribution !';

  @override
  String get new_product_done_button_label => 'Découvrez le produit complété';

  @override
  String get hey_incomplete_product_message =>
      'Appuyez pour répondre MAINTENANT à 3 questions pour calculer le Nutri-Score, le Green-Score et le niveau d\'ultra-transformation (NOVA) !';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Appuyez maintenant pour répondre à 2 questions pour aider à analyser ce cosmétique !';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Appuyez maintenant pour répondre à 3 questions pour aider à analyser ce produit alimentaire pour animaux !';

  @override
  String get hey_incomplete_product_message_product =>
      'Appuyez maintenant pour aider à compléter ce produit !';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Photo des informations nutritionnelles téléchargée';

  @override
  String get recycling_photo_button_label =>
      'Photo des informations de recyclage';

  @override
  String get recycling_photo_uploaded =>
      'Photo des informations de recyclage téléchargée';

  @override
  String get take_more_photo_button_label => 'Prendre plus de photos';

  @override
  String get other_photo_uploaded => 'Photo annexe téléversée';

  @override
  String get retake_photo_button_label => 'Reprendre';

  @override
  String get selecting_photo => 'Sélection de la photo';

  @override
  String get uploading_image => 'Envoi de la photo sur le serveur';

  @override
  String get uploading_image_type_front =>
      'Envoi de la photo de la face avant à Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Envoi de la photo des ingrédients à Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Envoi de la photo des informations nutritionnelles à Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Envoi de la photo de l\'emballage sur Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Envoi d\'une autre image sur Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Envoi de l\'image à Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Ajouter les ingrédients manquants';

  @override
  String get score_add_missing_packaging_image =>
      'Ajouter l\'image d\'emballage manquante';

  @override
  String get score_add_missing_nutrition_facts =>
      'Ajouter les informations nutritionnelles manquantes';

  @override
  String get score_add_missing_product_traces =>
      'Ajouter des traces de produits manquantes';

  @override
  String get score_add_missing_product_category =>
      'Ajouter une catégorie de produit manquante';

  @override
  String get score_add_missing_precise_product_category =>
      'Sélectionnez une catégorie plus précise';

  @override
  String get score_add_missing_product_countries =>
      'Ajouter les pays de vente manquants';

  @override
  String get score_add_missing_product_emb =>
      'Ajouter les codes de traçabilité manquants';

  @override
  String get score_add_missing_product_labels => 'Ajouter les labels manquants';

  @override
  String get score_add_missing_product_origins =>
      'Ajouter les origines manquantes';

  @override
  String get score_add_missing_product_stores =>
      'Ajouter les magasins de vente manquants';

  @override
  String get score_add_missing_product_brands =>
      'Ajouter les marques manquantes';

  @override
  String get score_update_nutrition_facts =>
      'Mettre à jour les informations nutritionnelles';

  @override
  String get nutrition_page_title => 'Informations nutritionnelles';

  @override
  String get nutrition_page_nutritional_info_title =>
      'Informations nutritionnelles';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Valeurs indiquées sur le produit :';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Oui';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Non';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Voir la photo';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Bonnes pratiques : Informations nutritionnelles';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Parfois, les informations nutritionnelles ne sont **pas précisées sur l\'emballage** ou sur un document fourni avec le produit. Dans ce cas, et uniquement dans ce cas, vous pouvez définir la valeur sur **NON**.';

  @override
  String get nutrition_page_serving_type_label => 'Valeurs nutritionnelles :';

  @override
  String get nutrition_page_per_100g => 'pour 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'pour 100g/ml';

  @override
  String get nutrition_page_per_serving => 'par portion';

  @override
  String get nutrition_page_add_nutrient => 'Ajouter un nutriment';

  @override
  String get nutrition_page_serving_size => 'Taille d\'une portion';

  @override
  String get nutrition_page_serving_size_hint =>
      'Indiquez une taille de portion (ex : 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Bonnes pratiques : Taille des portions';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Cette valeur aide à **faire un calcul proportionnel de chaque nutriment par taille de portion**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Les unités autorisées** sont : kg, g, mg, µg, oz, L, dL, cL, mL, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** ou **60 G** (privilégiez le premier)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** ou **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Unité non valide';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Unités non valides';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **bonbons** et 2 **biscuits**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Unité manquante';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Nombre invalide';

  @override
  String get nutrition_page_update_running =>
      'Mise à jour du produit sur le serveur…';

  @override
  String get nutrition_page_update_done => 'Produit mis à jour !';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Utilisez la quantité de produit comme taille de portion';

  @override
  String get nutrition_page_photo_error => 'Impossible de charger la photo';

  @override
  String get more_photos => 'Plus de photos intéressantes';

  @override
  String get view_more_photo_button =>
      'Voir toutes les photos existantes pour ce produit';

  @override
  String get no_product_found => 'Aucun produit trouvé';

  @override
  String get no_location_found => 'Aucun magasin trouvé';

  @override
  String get not_found => 'non trouvé :';

  @override
  String get refreshing_product => 'Actualisation du produit';

  @override
  String get product_refreshed => 'Produit actualisé';

  @override
  String product_image_accessibility_label(String date) {
    return 'Image prise le $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Image prise le $date. Cette image est peut-être obsolète';
  }

  @override
  String get product_image_outdated => 'Cette image peut être obsolète';

  @override
  String get product_image_outdated_explanations_title =>
      'Cette image peut être obsolète';

  @override
  String get product_image_outdated_explanations_content =>
      'Cette image a été prise il y a plus d\'un an.\n**Merci de vérifier qu\'elle est toujours d\'actualité**.\n\nIl s\'agit **uniquement d\'une alerte**. Si le contenu n\'a pas changé, vous pouvez ignorer ce message.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Remplacer la photo ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Ajouter une photo ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'En prendre une autre';

  @override
  String get product_image_action_take_picture => 'Prendre une photo';

  @override
  String get product_image_action_from_gallery =>
      'Sélectionner dans votre galerie';

  @override
  String get product_image_action_choose_existing_photo =>
      'Sélectionner dans les photos du produit';

  @override
  String get product_image_details_label => 'Informations sur la photo';

  @override
  String get product_image_details_from_producer => 'Du producteur';

  @override
  String get product_image_details_contributor => 'Contributeur';

  @override
  String get product_image_details_contributor_producer =>
      'Contributeur (producteur)';

  @override
  String get product_image_details_date => 'Date';

  @override
  String get product_image_details_date_unknown => 'Inconnu';

  @override
  String get homepage_main_card_logo_description =>
      'Bienvenue sur Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Scannez** un code-barres ou\n**recherchez** un produit';

  @override
  String get homepage_main_card_search_field_hint => 'Chercher un produit';

  @override
  String get homepage_main_card_search_field_tooltip => 'Démarrer la recherche';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Dernières nouvelles : $news_title';
  }

  @override
  String get tagline_app_review => 'Aimez-vous cette appli ?';

  @override
  String get tagline_app_review_button_positive => 'Je l\'adore! 😍';

  @override
  String get tagline_app_review_button_negative => 'Pas vraiment…';

  @override
  String get tagline_app_review_button_later => 'Me demander plus tard';

  @override
  String get tagline_feed_news_button => 'En savoir plus';

  @override
  String get app_review_negative_modal_title =>
      'Vous n\'aimez pas notre application ?';

  @override
  String get app_review_negative_modal_text =>
      'Pourriez-vous prendre quelques secondes pour nous dire pourquoi ?';

  @override
  String get app_review_negative_modal_positive_button => 'Oui, absolument !';

  @override
  String get app_review_negative_modal_negative_button => 'Non';

  @override
  String get could_not_refresh => 'Impossible d\'actualiser le produit';

  @override
  String get product_internet_error_modal_title => 'Une erreur est survenue !';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Nous ne parvenons pas à récupérer des informations sur ce produit en raison d\'une erreur réseau. Veuillez vérifier votre connexion internet et réessayer.\n\nErreur interne :\n$error';
  }

  @override
  String get product_tags_title => 'Propriétés du produit';

  @override
  String get no_product_tags_found_message =>
      'Aucune propriété de produit trouvée. Les propriétés peuvent être utilisées pour décrire les produits de manière plus détaillée et flexible.';

  @override
  String get product_tags_empty => 'Aucune propriété';

  @override
  String get product_tags_explanation =>
      'En ajoutant des propriétés (clé / valeur) à un produit, vous permettez de l’enrichir.';

  @override
  String get add_tag => 'Ajouter une propriété';

  @override
  String get add_tags => 'Ajouter des propriétés';

  @override
  String get add_edit_tags => 'Ajouter ou modifier des propriétés';

  @override
  String get edit_tag => 'Modifier la propriété';

  @override
  String get remove_tag => 'Supprimer la propriété';

  @override
  String get tag_key => 'Propriété';

  @override
  String get tag_keys => 'Propriétés';

  @override
  String get tag_key_uneditable => 'Propriété (non modifiable)';

  @override
  String get tag_key_input_hint => 'Saisir une propriété';

  @override
  String get tag_value => 'Valeur';

  @override
  String get tag_values => 'Valeurs';

  @override
  String get tag_value_input_hint => 'Saisir une valeur';

  @override
  String get tag_key_item => 'Propriété :';

  @override
  String get tag_value_item => 'Valeur :';

  @override
  String get tag_key_explanations =>
      'Une clé doit être en minuscule et sans espace.';

  @override
  String tag_key_already_exists(String property) {
    return 'Un tag avec la propriété $property existe déjà !';
  }

  @override
  String get product_internet_error =>
      'Impossible de récupérer les informations sur ce produit en raison d\'une erreur réseau.';

  @override
  String get cached_results_from => 'Résultats mis en cache depuis :';

  @override
  String get product_search_same_category => 'Trouver des alternatives';

  @override
  String get product_search_same_category_short => 'Comparer';

  @override
  String get product_search_same_category_error =>
      'Cette fonctionnalité ne peut être utilisée que pour les produits avec une catégorie.\n\nVeuillez modifier le produit pour ajouter une catégorie.';

  @override
  String get product_improvement_add_category =>
      'Ajoutez une catégorie pour calculer le Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Ajoutez des informations nutritionnelles pour calculer le Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Ajoutez des informations nutritionnelles et une catégorie pour calculer le Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Le Nutri-Score de ce produit ne peut pas être calculé, ce qui peut être dû, par exemple, à une catégorie non standard. Si cela est considéré comme une erreur, veuillez nous contacter.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'L\'image des informations nutritionnelles est obsolète : mettez-la à jour s\'il-vous-plait.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Le Green-Score prend en compte l\'origine des ingrédients. Veuillez prendre en photo la liste d\'ingrédients et/ou toute allégation géographique ou modifiez le produit afin qu\'elles puissent être prises en compte.';

  @override
  String get country_chooser_label => 'Veuillez choisir un pays';

  @override
  String get currency_chooser_label => 'Veuillez choisir une devise';

  @override
  String get country_change_message => 'Vous venez de changer de pays.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Voulez-vous changer la devise de $previousCurrency à $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label =>
      'Veuillez sélectionner un pays :';

  @override
  String get country_chooser_label_from_settings => 'Votre pays';

  @override
  String get country_selection_explanation =>
      'Certaines fonctionnalités environnementales sont liées à l\'emplacement.';

  @override
  String get product_removed_comparison => 'Produit retiré du comparatif';

  @override
  String get native_app_settings => 'Paramètres natifs de l\'application';

  @override
  String get native_app_description =>
      'Ouvrir les paramètres systèmes pour Open Food Facts';

  @override
  String get product_removed_history => 'Produit retiré de l\'historique';

  @override
  String get product_removed_list => 'Produit retiré de la liste';

  @override
  String get product_could_not_remove => 'Impossible de supprimer le produit';

  @override
  String get no_prodcut_in_list => 'Il n\'y a aucun produit dans cette liste';

  @override
  String get no_product_in_section =>
      'Il n\'y a aucun produit dans cette section';

  @override
  String get recently_seen_products => 'Historique des produits consultés';

  @override
  String get clear => 'Effacer';

  @override
  String get clear_long => 'Vider la liste';

  @override
  String get really_clear => 'Voulez-vous vraiment supprimer cette liste ?';

  @override
  String pct_match(Object percent) {
    return '$percent% de correspondance';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'il y a $count jours',
      one: 'il y a un jour',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'il y a $count heures',
      one: 'il y a une heure',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minutes',
      one: 'une minute',
      zero: 'moins d\'une minute',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'il y a $count mois',
      one: 'il y a un mois',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'il y a $count semaines',
      one: 'il y a une semaine',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Comparer $count produits',
      one: 'Comparer un produit',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produits sélectionnés',
      one: 'Un produit sélectionné',
      zero: 'Aucun produit sélectionné',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Comparer les produits sélectionnés';

  @override
  String get delete_products_mode => 'Supprimer les produits sélectionnés';

  @override
  String get select_all_products_mode => 'Sélectionner tout les produits';

  @override
  String get select_none_products_mode => 'Ne rien sélectionner';

  @override
  String get compare_products_appbar_title => 'Comparer les articles';

  @override
  String get compare_products_appbar_subtitle =>
      'Veuillez sélectionner au moins deux produits';

  @override
  String get retry_button_label => 'Réessayer';

  @override
  String get connect_with_us => 'Nous contacter';

  @override
  String get tiktok => 'Suivez-nous sur TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Suivez-nous sur Instagram';

  @override
  String get instagram_link => 'https://instagram.com/openfoodfacts.fr';

  @override
  String get twitter => 'Suivez-nous sur X (anciennement Twitter)';

  @override
  String get twitter_link => 'https://x.com/openfoodfactsfr';

  @override
  String get mastodon => 'Suivez-nous sur Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Suivez-nous sur BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => 'Découvrir';

  @override
  String get how_to_contribute => 'Comment contribuer';

  @override
  String get hint_knowledge_panel_message =>
      'Vous pouvez appuyer sur n\'importe quelle partie de la carte pour obtenir plus d\'informations sur ce que vous voyez. Essayez dès maintenant !';

  @override
  String get permissions_page_title => 'Accès à la caméra';

  @override
  String get permissions_page_body1 =>
      'Pour scanner un code-barres avec l\'appareil photo de votre téléphone, veuillez autoriser l\'accès.';

  @override
  String get permissions_page_body2 =>
      'Si vous changez d\'avis, cette option peut être activée et désactivée à tout moment depuis les paramètres.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'Système d\'exploitation : Android (SDK Int : $sdkInt / Version : $release)\nModèle : $model\nProduit : $product\nAppareil : $device\nMarque : $brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS : iOS ($version)\nModèle : $model\nModèle localisé : $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVersion de l\'application : $appVersion\nNuméro de build de l\'application : $appBuildNumber\nNom du package de l\'application : $appPackageName';
  }

  @override
  String get authorize_button_label => 'Autoriser';

  @override
  String get refuse_button_label => 'Refuser';

  @override
  String get ask_me_later_button_label => 'Plus tard';

  @override
  String get are_you_sure => 'Êtes-vous sûr ?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'En savoir plus sur $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Bienvenue !';

  @override
  String get onboarding_home_welcome_text2 =>
      'L\'application qui vous aide à choisir de la nourriture qui est bonne\npour **vous**\net la **planète** !';

  @override
  String get onboarding_continue_button => 'Continuer';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Chargement de votre premier exemple de produit';

  @override
  String get onboarding_welcome_warning =>
      'Désolé, il s\'agit d\'un exemple de produit, vous ne pouvez pas le modifier :)';

  @override
  String get product_list_your_ranking => 'Votre classement';

  @override
  String get product_list_empty_icon_desc => 'Historique non disponible';

  @override
  String get product_list_empty_title => 'Lancez le scan';

  @override
  String get product_list_empty_message =>
      'Les produits scannés apparaîtront ici et vous pourrez vérifier leurs informations détaillées';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produits',
      one: 'produit',
      zero: 'produits',
    );
    return 'Actualisation de $_temp0 dans votre historique';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produits',
      one: 'produit',
      zero: 'produit',
    );
    return 'Rafraîchissement de $_temp0 terminé';
  }

  @override
  String get product_list_compare_side_by_side => 'Comparer côte à côte';

  @override
  String get loading_dialog_default_title => 'Téléchargement des données';

  @override
  String get loading_dialog_default_error_message =>
      'Impossible de télécharger les données';

  @override
  String get account_delete => 'Supprimer le compte';

  @override
  String get account_delete_title => 'Supprimer mon compte';

  @override
  String get user_profile => 'Compte';

  @override
  String get user_profile_title_guest => 'Bienvenue !';

  @override
  String get user_profile_subtitle_guest =>
      'Connectez-vous ou inscrivez-vous pour rejoindre la communauté Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Identifiant Open Food Facts : $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Bienvenue $id !';
  }

  @override
  String get email_subject_account_deletion => 'Supprimer le compte';

  @override
  String email_body_account_deletion(String userId) {
    return 'Bonjour, veuillez supprimer mon compte Open Food Facts : $userId';
  }

  @override
  String get settings_app_app => 'Application';

  @override
  String get settings_app_data => 'Confidentialité et télémetrie';

  @override
  String get settings_app_camera => 'Appareil photo';

  @override
  String get settings_app_products => 'Produits';

  @override
  String get settings_app_miscellaneous => 'Divers';

  @override
  String get camera_play_sound_title => 'Jouer un son lors du scan';

  @override
  String get camera_play_sound_subtitle => 'Bipper à chaque scan réussi';

  @override
  String get camera_window_accessibility_label =>
      'Scannez un code-barres avec votre appareil photo';

  @override
  String get app_haptic_feedback_title => 'Vibration et retours tactiles';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrations après l\'exécution de certaines actions (code-barres décodé, produit supprimé…).';

  @override
  String get crash_reporting_toggle_title => 'Rapport de plantage';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Quand ils sont activés, les rapports de plantage sont automatiquement envoyés au système de suivi des erreurs d\'Open Food Facts pour améliorer l\'application en corrigeant les bugs.';

  @override
  String get send_anonymous_data_toggle_title => 'Envoyer des données anonymes';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Lorsque cette option est activée, certaines informations anonymes concernant l\'utilisation de l\'application seront envoyées aux serveurs Open Food Facts pour que nous puissions comprendre comment et combien de fonctionnalités sont utilisées afin de les améliorer.';

  @override
  String get product_edit_photo_title => 'Modifier la photo';

  @override
  String get permission_photo_error => 'Erreur';

  @override
  String get permission_photo_denied_title =>
      'Autoriser l\'utilisation de l\'appareil photo pour scanner les codes-barres';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Pour une expérience améliorée, veuillez autoriser $appName à accéder à votre appareil photo. Vous pourrez scanner directement les codes-barres.';
  }

  @override
  String get permission_photo_denied_button => 'Autoriser';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Permission refusée';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Puisque vous avez refusé l\'utilisation de l\'appareil photo, vous devez l\'autoriser manuellement dans les paramètres.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Ouvrir les paramètres';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Annuler';

  @override
  String get permission_photo_none_found => 'Aucune caméra détectée.';

  @override
  String get permission_photo_denied =>
      'Aucun accès à l\'appareil photo autorisé';

  @override
  String get show_product_pictures => 'Afficher les photos du produit';

  @override
  String get edit_product_label => 'Modifier le produit';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Envoi de vos modifications…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Vos modifications sont en cours d\'envoi en **arrière-plan** (ou plus tard en cas d\'erreur).\nVous pouvez continuer d\'éditer d\'autres champs du produit.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Vos modifications sont en cours d\'envoi en **arrière-plan** (ou plus tard en cas d\'erreur).';

  @override
  String get edit_product_label_short => 'Modifier';

  @override
  String edit_product_form_item_help(String value) {
    return 'Comment saisir : \"$value\" ?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Veuillez saisir une valeur correcte !';

  @override
  String get edit_product_form_item_error_existing =>
      'Cette valeur existe déjà !';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Ajouter une nouvelle marque';

  @override
  String get edit_product_form_item_add_action_label =>
      'Ajouter un nouveau label';

  @override
  String get edit_product_form_item_add_action_store =>
      'Ajouter un nouveau magasin';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Ajouter une nouvelle origine';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Ajouter un nouveau code de traçabilité';

  @override
  String get edit_product_form_item_add_action_country =>
      'Ajouter un nouveau pays';

  @override
  String get edit_product_form_item_add_action_category =>
      'Ajouter une nouvelle catégorie';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Ajouter une nouvelle trace';

  @override
  String get edit_product_form_item_add_suggestion => 'Ajouter une suggestion';

  @override
  String get edit_product_form_item_deny_suggestion => 'Refuser la suggestion';

  @override
  String get edit_product_form_item_details_title => 'Informations de base';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Nom du produit, marque & quantité';

  @override
  String get edit_product_form_item_other_details_title =>
      'Détails supplémentaires';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Site Web…';

  @override
  String get edit_product_form_item_photos_title => 'Photos';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Ajouter ou mettre à jour des photos';

  @override
  String get edit_product_form_item_labels_title => 'Labels & Certifications';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Environnement, Labels de qualité…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Saisir un label (ex : Nutri-Score)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Bonnes pratiques : Étiquettes';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Toute caractéristique du produit **qui est factuelle** et différente des autres champs.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Fabriqué en Belgique, produit en Bretagne…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Riche en fibres, source de fer…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Commerce équitable, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Magasins';

  @override
  String get edit_product_form_item_stores_hint => 'Saisir un nom de magasin';

  @override
  String get edit_product_form_item_stores_type => 'magasin';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Bonnes pratiques : Magasins';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Saisissez le magasin où vous avez acheté le produit.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Origines';

  @override
  String get edit_product_form_item_origins_hint =>
      'Saisir une origine (ex : Bœuf d\'Argentine)';

  @override
  String get edit_product_form_item_origins_type => 'pays';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Bonnes pratiques : Origines';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Ajoutez **toutes les indications d’origine que vous pouvez trouver sur l’emballage**.\nVous n’avez pas à vous soucier des origines indiquées directement dans la liste des ingrédients.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Bœuf d\'Argentine';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Le soja ne provient pas de l\'Union Européenne';

  @override
  String get edit_product_form_item_countries_title => 'Pays';

  @override
  String get edit_product_form_item_countries_hint =>
      'Saisir un nom de pays (ex : Espagne)';

  @override
  String get edit_product_form_item_countries_type => 'pays';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Bonnes pratiques : Pays';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Pays où le produit est largement disponible** (hors magasins spécialisés dans les produits étrangers).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Codes de traçabilité';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Saisir un code (ex  : EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'code de traçabilité';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Bonnes pratiques : Codes de traçabilité';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Dans cette section, vous pouvez saisir des codes relatifs aux **marques d\'emballage**, aux **marques d\'identification** ou aux **marques de santé**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Exemples de codes de traçabilité';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Codes CE** utilisés dans la Communauté Européenne pour identifier des producteurs ou des conditionneurs de denrées alimentaires :';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR** : code pays de la **France**\n**72.264.002** : données géographiques\n**CE** : Communauté européenne';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Codes EMB** utilisés en France :';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Traces éventuelles';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'Saisir une trace (ex : soja)';

  @override
  String get edit_product_form_item_categories_title => 'Catégories';

  @override
  String get edit_product_form_item_categories_hint => 'Saisir une catégorie';

  @override
  String get edit_product_form_item_categories_type =>
      'Saisissez une catégorie (ex : jus d\'orange)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Bonnes pratiques : Catégories';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indiquez **uniquement la catégorie la plus spécifique**.\nLes catégories parentes seront ajoutées automatiquement.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Catégorie manquante ?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Si une catégorie n\'est **pas disponible dans la saisie semi-automatique**, n\'hésitez pas à l\'ajouter quand même.\nCela nous aidera à améliorer Open Food Facts dans votre pays.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardines à l\'huile d\'olive';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Jus d\'orange à base de concentré';

  @override
  String get edit_product_form_item_exit_title => 'Quitter sans sauvegarder ?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Souhaitez-vous enregistrer vos modifications avant de quitter cette page ?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Enregistrer les modifications';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Annuler les modifications';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingrédients';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Agrandir ou réduire avec un geste de \"Pinch-to-zoom\"';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Agrandir ou réduire la photo';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'En utilisant le geste dit de **Pinch-to-zoom**, vous pouvez agrandir ou réduire l\'image :';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Ajouter';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Veuillez d\'abord saisir un texte';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Retirer';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Enregistrer votre modification';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Annuler votre modification';

  @override
  String get edit_product_form_item_packaging_title =>
      'Photo des informations de recyclage';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Tableau nutritionnel';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Nutrition, teneur en alcool…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Bonnes pratiques : Informations nutritionnelles';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Valeurs nutritionnelles';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Tout d’abord, sélectionnez si les **valeurs sont fournies** :';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Tableau nutritionnel';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Ensuite, saisissez les valeurs nutritionnelles **telles qu\'indiquées sur l\'emballage**. S\'il n\'y a aucune valeur, vous pouvez cliquer sur l\'icône \"Œil\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Champ manquant ?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Si une entrée est manquante, vous pouvez **cliquer sur l\'icône « Plus »** pour l\'ajouter (ex : vitamine D, magnésium…).';

  @override
  String get edit_product_form_save => 'Modifier';

  @override
  String get edit_product_ingredients_photo_title => 'Photo des ingrédients';

  @override
  String get edit_product_ingredients_list_title => 'Liste des ingrédients';

  @override
  String get edit_product_packaging_photo_title => 'Photo du packaging';

  @override
  String get edit_product_packaging_list_title => 'Détails du Packaging';

  @override
  String get no_data_available => 'Aucune donnée disponible';

  @override
  String get product_field_website_title => 'Site Web';

  @override
  String get origins_editing_title => 'Modifier les origines';

  @override
  String get completed_basic_details_btn_text =>
      'Compléter les informations de base';

  @override
  String get not_implemented_snackbar_text => 'Pas encore disponible';

  @override
  String get category_picker_page_appbar_text => 'Catégories';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extraire les ingrédients à partir de la photo';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extraire les ingrédients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extraction des ingrédients à partir de la photo';

  @override
  String get edit_ingredients_loading_photo_btn_text =>
      'Chargement de la photo…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Pourquoi est-ce que je vois ce message ?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Pour utiliser la fonction \"Extraire les ingrédients\", la photo doit d\'abord être téléversée.\n\nVeuillez patienter quelques secondes ou saisissez-les manuellement.';

  @override
  String get edit_ingredients_refresh_photo_btn_text =>
      'Mettre à jour la photo';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extraire l\'emballage de la photo';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extraire l\'emballage';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extraction de l\'emballage à partir de la photo';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Chargement de la photo…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Pourquoi est-ce que je vois ce message ?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Pour utiliser la fonction \"Extraire l\'emballage\", la photo doit d\'abord être téléversée.\n\nVeuillez patienter quelques secondes ou saisissez-les manuellement.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Mettre à jour la photo';

  @override
  String get edit_ocr_extract_failed =>
      'Impossible de détecter le texte dans l\'image.';

  @override
  String get edit_ocr_extract_disabled_title => 'Photo manquante !';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Afin de pouvoir utiliser l\'extraction du texte, vous devez d\'abord prendre une photo.';

  @override
  String get user_list_dialog_new_title => 'Nouvelle liste de produits';

  @override
  String get user_list_dialog_rename_title => 'Renommer la liste';

  @override
  String get user_list_subtitle_product => 'Listes';

  @override
  String get user_list_title => 'Vos listes';

  @override
  String get user_list_add_product => 'Ajouter le produit à vos listes';

  @override
  String get user_list_button_new => 'Créer une nouvelle liste';

  @override
  String get user_list_empty_label =>
      'Aucune liste disponible pour le moment, veuillez commencer par en créer une';

  @override
  String get user_list_button_add_product => 'Ajouter à une liste';

  @override
  String get added_to_list_msg => 'Ajouté à la liste';

  @override
  String get user_list_popup_clear => 'Effacer votre historique';

  @override
  String get user_list_popup_rename => 'Renommer';

  @override
  String get user_list_name_hint => 'Ma liste';

  @override
  String get user_list_name_error_empty => 'Le nom est obligatoire';

  @override
  String get user_list_name_error_already => 'Ce nom est déjà utilisé';

  @override
  String get user_list_name_error_same => 'C\'est le même nom';

  @override
  String get user_list_name_input_hint => 'Nom de la liste';

  @override
  String get try_again => 'Réessayer';

  @override
  String get there_was_an_error => 'Une erreur s’est produite';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Aucune catégorie trouvée pour $items';
  }

  @override
  String get camera_toggle_camera =>
      'Basculer entre la caméra arrière et avant';

  @override
  String get camera_toggle_flash =>
      'Allumer ou éteindre le flash de l\'appareil photo';

  @override
  String get camera_enable_flash => 'Activer le flash';

  @override
  String get camera_disable_flash => 'Désactiver le flash';

  @override
  String get camera_flash_error_dialog_title => 'Une erreur est survenue !';

  @override
  String get camera_flash_error_dialog_message =>
      'Une erreur s\'est produite lors de la modification de l\'état de votre flash. Veuillez vous assurer que votre smartphone n\'a pas déjà activé la torche.';

  @override
  String get category_picker_no_category_found_button => 'Retour';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Cliquez pour ouvrir dans votre navigateur ou dans l\'application (si installée)';

  @override
  String get dev_preferences_screen_title => 'Mode DEV';

  @override
  String get dev_preferences_screen_subtitle =>
      'Accédez aux fonctionnalités expérimentales et aux outils de développement';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Relancer l\'expérience de bienvenue';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Vous devez ensuite redémarrer l\'application pour la revoir.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Basculer entre openfoodfacts.org (PROD) et test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Adresse de l\'environnement de TEST';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL de base actuelle pour l\'environnement de test : $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Tester l\'hôte de l\'environnement';

  @override
  String get dev_preferences_ml_kit_title => 'Utiliser ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'puis vous devez redémarrer cette application';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Bouton supplémentaire sur la page produit';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Modifier les ingrédients via un bouton de knowledge panel';

  @override
  String get dev_preferences_export_history_title => 'Exporter l\'historique';

  @override
  String get dev_preferences_export_history_progress_error => 'exception';

  @override
  String get dev_preferences_export_history_progress_found => 'produit trouvé';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produit NON trouvé';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Exporter l\'historique';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Annuler';

  @override
  String get dev_preferences_migration_title =>
      'Migration des données depuis la V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Statut : $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'succès ou nouvelle installation';

  @override
  String get dev_preferences_migration_status_success => 'succès';

  @override
  String get dev_preferences_migration_status_error => 'erreur';

  @override
  String get dev_preferences_migration_status_in_progress => 'en cours';

  @override
  String get dev_preferences_migration_status_required =>
      'requis (cliquez pour commencer)';

  @override
  String get dev_preferences_migration_status_not_started => 'inconnu';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Effacera l\'historique et y mettra 3 produits';

  @override
  String get dev_preferences_news_custom_url_title =>
      'URL personnalisée pour les actualités';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL du fichier JSON :';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Non défini';

  @override
  String get dev_preferences_news_provider_status_title => 'État ';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Dernière actualisation : $date';
  }

  @override
  String get product_type_label_food => 'Nourriture';

  @override
  String get product_type_label_beauty => 'Hygiène personnelle';

  @override
  String get product_type_label_pet_food =>
      'Nourriture pour animaux de compagnie';

  @override
  String get product_type_label_product => 'Autre';

  @override
  String get product_type_selection_title => 'Type de produit';

  @override
  String get product_type_selection_subtitle =>
      'Sélectionnez le type de ce produit';

  @override
  String get product_type_selection_empty =>
      'Vous devez d\'abord sélectionner un type de produit !';

  @override
  String product_type_selection_already(String productType) {
    return 'Vous ne pouvez pas modifier le type de produit ($productType) !';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Raccourci vers l\'application Prix sur la page produit';

  @override
  String get prices_app_button => 'Aller sur le site d\'Open Prices';

  @override
  String get prices_website_button => 'Ouvert sur le site Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Ajouter des étiquettes de prix directement depuis la galerie';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Une fois que vous aurez sélectionné des images, vous ne pourrez pas les modifier !';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'L\'IA sera exécutée sur vos preuves pour en extraire les prix.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Permettre à la communauté de valider les prix extraits par l\'IA.';

  @override
  String get prices_bulk_proof_upload_subtitle =>
      'Étiquettes de prix multiples';

  @override
  String get prices_bulk_proof_upload_title =>
      'Téléversement de preuves en masse';

  @override
  String get prices_bulk_proof_upload_step_selecting =>
      'Sélection des fichiers';

  @override
  String get prices_bulk_proof_upload_step_starting =>
      'Démarrer le téléchargement';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Copie locale du fichier #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Préparation du téléchargement #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Échec à l\'image #$index/$count';
  }

  @override
  String get prices_generic_title => 'Prix';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ajouter $count prix',
      one: 'Ajouter un prix',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Envoyer $count prix',
      one: 'Envoyer le prix',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Ajouter un article';

  @override
  String get prices_add_a_price => 'Ajouter un prix';

  @override
  String get prices_add_a_receipt => 'Ajouter un ticket de caisse';

  @override
  String get prices_add_price_tags => 'Ajouter des étiquettes de prix';

  @override
  String prices_barcode_already(String barcode) {
    return 'Ce code-barres ($barcode) est déjà dans la liste !';
  }

  @override
  String get prices_barcode_search_not_found => 'Produit introuvable';

  @override
  String get prices_barcode_search_none_yet => 'Pas encore de produit';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'À la recherche de $barcode';
  }

  @override
  String get prices_barcode_enter => 'Saisie du code-barres';

  @override
  String get prices_category_enter => 'Article sans code-barres';

  @override
  String get prices_per_kilogram => 'Prix au kilo';

  @override
  String get prices_per_unit => 'Prix a l\'unité';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / unité';

  @override
  String get prices_category_mandatory => 'Obligatoire';

  @override
  String get prices_category_optional => 'Facultatif';

  @override
  String get prices_category_error_mandatory => 'La catégorie est obligatoire';

  @override
  String get prices_barcode_reader_action => 'Lecteur de code-barres';

  @override
  String get prices_view_prices => 'Voir les prix';

  @override
  String get prices_list_title => 'Liste de prix';

  @override
  String get prices_list_count => 'Nombre de\nprix';

  @override
  String get prices_list_add_new_price => 'Ajouter un nouveau prix';

  @override
  String get prices_list_empty_title => 'Pas encore de prix !';

  @override
  String get prices_list_empty_subtitle =>
      'Soyez le premier à en ajouter un :\nEn scannant un **reçu** ou une **étiquette de prix** !';

  @override
  String get prices_entry_shop_not_found => 'Magasin inconnu';

  @override
  String prices_entry_menu_title(String user) {
    return 'Entrée de prix de \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Voir tous les prix du produit';

  @override
  String get prices_entry_menu_open_proof => 'Voir la preuve';

  @override
  String get prices_entry_menu_my_prices => 'Voir mes autres prix';

  @override
  String get prices_entry_menu_author_prices =>
      'Voir les autres prix de l\'auteur';

  @override
  String get prices_entry_menu_shop_prices =>
      'Voir les autres prix de ce magasin';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prix',
      one: '1 prix',
    );
    return '$_temp0 pour $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tous les $count prix',
      one: 'Un seul prix',
      zero: 'Aucun prix',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return '$pageSize prix les plus récents (total : $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Prix : $price / Magasin : \"$location\" / Publié le $date par \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Ouvrir les preuves de \"$user\"';
  }

  @override
  String get prices_open_proof => 'Ouvrir la preuve du prix';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Toutes les $count preuves',
      one: 'Une seule preuve',
      zero: 'Aucune preuve',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return '$pageSize preuves les plus récentes (total : $total)';
  }

  @override
  String get prices_users_empty_title => 'Aucun contributeur pour le moment !';

  @override
  String get prices_users_empty_explanation =>
      'Soyez le premier à ajouter un prix !';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize contributeurs (total : $total)';
  }

  @override
  String get prices_locations_empty_title => 'Pas encore de boutique !';

  @override
  String get prices_locations_empty_explanation =>
      'Soyez le premier à ajouter un prix !';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize contributeurs (total : $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produits',
      one: 'Un produit',
      zero: 'Liste vide',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produits',
      one: 'Un produit',
      zero: 'Liste vide',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count utilisateurs',
      one: 'Un utilisateur',
      zero: 'Aucun utilisateur',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prix',
      one: 'Un prix',
      zero: 'Aucun prix',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Prix déjà ajouté';

  @override
  String get prices_amount_subtitle => 'Montant';

  @override
  String get prices_amount_is_discounted => 'En promotion ?';

  @override
  String get prices_amount_price_normal => 'Prix';

  @override
  String get prices_amount_price_discounted => 'Prix en promo';

  @override
  String get prices_amount_price_not_discounted => 'Prix d\'origine';

  @override
  String get prices_amount_no_product => 'Il manque un produit !';

  @override
  String get prices_amount_price_incorrect => 'Valeur incorrecte';

  @override
  String get prices_amount_price_mandatory => 'Valeur obligatoire';

  @override
  String get prices_currency_subtitle => 'Devise';

  @override
  String get prices_date_subtitle => 'Date';

  @override
  String get prices_location_subtitle => 'Magasin';

  @override
  String get prices_location_find => 'Chercher un magasin';

  @override
  String get prices_location_mandatory => 'Vous devez choisir un magasin !';

  @override
  String get prices_location_search_broader =>
      'Vous n\'avez pas trouvé ce que vous cherchiez ? Essayons une recherche plus large !';

  @override
  String get prices_proof_subtitle => 'Preuve';

  @override
  String get prices_proof_empty_title => 'Aucune preuve pour l\'instant !';

  @override
  String get prices_proof_empty_explanation =>
      'Commencez par ajouter une photo d’un **reçu** ou d’une **étiquette de prix** !';

  @override
  String get prices_proof_find => 'Choisir une preuve';

  @override
  String get prices_proof_change => 'Preuve de changement';

  @override
  String get prices_proof_receipt => 'Ticket de caisse';

  @override
  String get prices_proof_price_tag => 'Étiquette de prix';

  @override
  String get prices_proof_mandatory => 'Vous devez choisir une preuve !';

  @override
  String get prices_add_validation_error => 'Erreur de validation';

  @override
  String get prices_privacy_warning_title => 'Avertissement de confidentialité';

  @override
  String get prices_unknown_product => 'Produit inconnu';

  @override
  String get prices_privacy_warning_main_message =>
      'Les prix **seront publics**, ainsi que le magasin auquel ils font référence.\n\nCela pourrait permettre aux personnes qui connaissent votre pseudonyme Open Food Facts de :\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Déduire dans quelle région vous vivez';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Savoir ce que vous achetez';

  @override
  String get prices_privacy_warning_sub_message =>
      'Si cela vous met mal à l\'aise, veuillez changer votre pseudonyme ou créer un nouveau compte Open Food Facts et vous connecter à l\'application avec celui-ci.';

  @override
  String get i_refuse => 'Je refuse';

  @override
  String get i_accept => 'J\'accepte';

  @override
  String get prices_currency_change_proposal_title => 'Changer la monnaie ?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Votre monnaie actuelle est **$currency**. Souhaitez-vous la changer en **$newCurrency** ?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Oui, utiliser $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Non, garder $currency';
  }

  @override
  String get prices_menu_know_more => 'En savoir plus sur Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Fait';

  @override
  String get dev_mode_section_server => 'Configuration du serveur';

  @override
  String get dev_mode_section_news =>
      'Configuration du fournisseur d\'actualités';

  @override
  String get dev_mode_section_product_page => 'Page produit';

  @override
  String get dev_mode_section_ui => 'Interface utilisateur';

  @override
  String get dev_mode_section_experimental_features =>
      'Fonctionnalités expérimentales';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Exclure le Green-Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Utiliser un correcteur orthographique pour les écrans OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingrédients et emballage)';

  @override
  String get dev_mode_reset_app_language_title =>
      'Réinitialiser la langue de l\'application';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Ajouter des cartes';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Basculer entre prices.openfoodfacts.org (PROD) et l\'environnement de test';

  @override
  String get search_history_item_edit_tooltip =>
      'Réutiliser et modifier cette recherche';

  @override
  String get search_history_item_remove_tooltip => 'Retirer';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Vous avez téléchargé les $totalSize produits.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Télécharger $count autres produits\n$downloaded sur $totalSize déjà téléchargés.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Votre recherche de $search est en cours.\n\nVeuillez patienter quelques secondes…';
  }

  @override
  String get user_search_contributor_title => 'Produits que j\'ai ajoutés';

  @override
  String get user_search_informer_title => 'Produits que j\'ai modifiés';

  @override
  String get user_search_photographer_title =>
      'Produits que j\'ai photographiés';

  @override
  String get user_search_to_be_completed_title => 'Mes produits à compléter';

  @override
  String get user_search_prices_title => 'Mes prix';

  @override
  String get user_search_proofs_title => 'Mes preuves';

  @override
  String get user_search_proof_title => 'Ma preuve';

  @override
  String search_proof_title(String user) {
    return 'Preuve de \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Prix contributeur : $user';
  }

  @override
  String get all_search_prices_latest_title => 'Derniers prix ajoutés';

  @override
  String get all_search_prices_top_user_title => 'Top contributeurs';

  @override
  String get all_search_prices_top_location_title => 'Top lieux';

  @override
  String get prices_contribution_assistant =>
      'Assistant de contribution de prix';

  @override
  String get prices_validation_assistant => 'Assistant de validation de prix';

  @override
  String get prices_challenges_page => 'Défis';

  @override
  String get prices_multiple_proof_addition_system =>
      'Ajouter plusieurs preuves';

  @override
  String get all_search_prices_top_location_single_title => 'Prix en magasin';

  @override
  String get all_search_prices_top_product_title => 'Top produits';

  @override
  String get all_search_to_be_completed_title =>
      'Tous les produits à compléter';

  @override
  String get categorize_products_country_title =>
      'Aidez-nous pour les catégories des produits dans votre pays';

  @override
  String get edit_product_action_retake_picture => 'Reprendre une photo';

  @override
  String get edit_product_action_take_picture => 'Prendre la photo';

  @override
  String get edit_product_action_confirm => 'Confirmer';

  @override
  String get signup_page_terms_of_use_line1 => 'Je suis d\'accord avec les ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'conditions d\'utilisation et de contribution d\'Open Food Facts';

  @override
  String get analytics_consent_image_semantic_label => 'Icône de la télémetrie';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Erreur fatale : $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Erreur fatale : $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Compléter les informations de base';

  @override
  String get edit_photo_button_label => 'Modifier';

  @override
  String get edit_photo_unselect_button_label => 'Désélectionner la photo';

  @override
  String get edit_photo_select_existing_button_label =>
      'Choisir une photo existante';

  @override
  String get edit_photo_select_existing_all_label =>
      'Images existantes pour ce produit';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Sélectionnez une image en cliquant dessus';

  @override
  String get edit_photo_select_existing_download_label =>
      'Récupération des images existantes…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Il n\'y a pas de photos précédemment téléchargées liées à ce produit.';

  @override
  String get edit_photo_language_not_this_one =>
      'Pas encore d\'image dans cette langue';

  @override
  String get edit_photo_language_none => 'Pas encore d\'image';

  @override
  String get category_picker_screen_title => 'Catégories';

  @override
  String get basic_details => 'Détails de base';

  @override
  String get product_name => 'Nom du produit';

  @override
  String get product_names => 'Noms de produits';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Ajouter une nouvelle traduction';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Avant de valider, veuillez vous assurer d\'ajouter une traduction uniquement **si la langue est présente sur l\'emballage**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Voir la photo de face';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Prendre une photo de face';

  @override
  String get add_basic_details_product_name_hint =>
      'Saisir le nom du product (ex : Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Changer la langue par défaut ?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Voulez-vous que la langue par défaut du produit soit définie sur «$language» ?';
  }

  @override
  String get explanation_section_good_examples => 'Bon exemple';

  @override
  String get explanation_section_bad_examples => 'Mauvais exemple';

  @override
  String get add_basic_details_product_name_help_title =>
      'Bonnes pratiques : Nom du produit';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Le nom du produit est le **nom principal imprimé sur l\'emballage**. Il peut s\'agir d\'une marque déposée.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Note:** Veuillez ne pas ajouter de traduction **si la langue n\'est pas présente sur l\'emballage**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 => 'Ketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Ne pas inclure la marque dans le nom';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Ketchup aux tomates **par Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'N\'utilisez pas de symboles ®, ™, © ou similaires';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count autres traductions',
      one: '$count autre traduction',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Marque';

  @override
  String get brand_names => 'Marques';

  @override
  String get add_basic_details_brand_name_error => 'Veuillez saisir la marque';

  @override
  String get add_basic_details_brand_names_hint =>
      'Saisir les marques (ex : Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Bonnes pratiques : Marques';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Saisissez **toutes les marques du produit**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Marque principale';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'La **marque principale**, généralement clairement affichée sur le devant de l’emballage, doit être **saisie en premier**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Autres marques';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Lorsque commercialisé **par une grande entreprise** :';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** est commercialisé par **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Lorsque vendu avec sa marque **traduite en plusieurs langues** :';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** s\'écrit parfois **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Quantité et poids';

  @override
  String get add_basic_details_quantity_hint =>
      'Saisir le poids et si besoin la quantité (ex : 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Bonnes pratiques : Quantité';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copiez la valeur indiquée sur le produit et **n\'oubliez pas les unités**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** ou **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (pour 6 œufs)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(pour un produit avec 3 boîtes de 150g chacune)';

  @override
  String get barcode => 'Code-barres';

  @override
  String barcode_barcode(String barcode) {
    return 'Code-barres : $barcode';
  }

  @override
  String get barcode_invalid_error => 'Code-barres invalide';

  @override
  String get basic_details_add_success =>
      'Informations de base ajoutées avec succès';

  @override
  String get basic_details_add_error =>
      'Impossible d\'ajouter les informations de base. Veuillez réessayer après un certain temps';

  @override
  String get clear_search => 'Effacer votre recherche';

  @override
  String get confirm_clear =>
      'Vous êtes sur le point d\'effacer tout votre historique : êtes-vous sûr de vouloir continuer ?';

  @override
  String get alert_clear_selected_user_list =>
      'Vous êtes sur le point d\'effacer les éléments sélectionnés de votre historique';

  @override
  String get confirm_clear_selected_user_list =>
      'Voulez-vous vraiment continuer ?';

  @override
  String get alert_select_items_to_clear =>
      'Veuillez sélectionner un ou plusieurs éléments à effacer';

  @override
  String confirm_clear_user_list(String name) {
    return 'Vous êtes sur le point d\'effacer cette liste ($name) : êtes-vous sûr de vouloir continuer ?';
  }

  @override
  String get confirm_delete_user_list_title => 'Supprimer la liste ?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Vous êtes sur le point de supprimer la liste \"$name\". \nÊtes-vous sûr de vouloir continuer ?';
  }

  @override
  String get confirm_delete_user_list_button => 'Oui, je confirme';

  @override
  String importance_label(String name, String id) {
    return '$name importance : $id';
  }

  @override
  String get user_list_all_title => 'Listes';

  @override
  String get user_list_all_empty => 'Créez votre première liste !';

  @override
  String get product_list_select => 'Sélectionner une liste';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produits',
      one: 'Un produit',
      zero: 'Liste vide',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Ajouter une liste';

  @override
  String get open_food_preferences_tooltip =>
      'Modifier vos préférences alimentaires';

  @override
  String get add_photo_button_label => 'Ajouter une photo';

  @override
  String get add_packaging_photo_button_label =>
      'Prenez des photos de toute information sur l\'emballage/le recyclage';

  @override
  String get add_origin_photo_button_label =>
      'Prenez des photos de toute information sur l\'origine';

  @override
  String get add_emb_photo_button_label =>
      'Prenez des photos de toute information sur les codes de traçabilité';

  @override
  String get add_label_photo_button_label =>
      'Prenez des photos de toute information sur les labels et certifications';

  @override
  String get choose_image_source_title => 'Choisissez la source de l\'image';

  @override
  String get choose_image_source_body =>
      'Veuillez choisir la source de l\'image';

  @override
  String get gallery_source_label => 'Galerie';

  @override
  String get gallery_source_access_denied_dialog_title => 'Accès refusé';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Malheureusement, l\'application ne peut pas accéder à votre galerie photo, car vous avez précédemment refusé l\'autorisation.\n\nVeuillez accéder aux paramètres de l\'application dans les Paramètres de votre téléphone -> Photos';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Ouvrir les Paramètres';

  @override
  String get share => 'Partager';

  @override
  String share_product_text(String url) {
    return 'Jetez un œil à ce produit sur Open Food Facts : $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Jetez un œil à ce produit sur Open Beauty Facts : $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Jetez un œil à ce produit sur Open PetFood Facts : $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Jetez un œil à ce produit sur Open Products Facts : $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Jetez un œil à ma liste de produits sur Open Food Facts : $url';
  }

  @override
  String get capture => 'En prendre une autre';

  @override
  String get capture_new_picture => 'Prendre une photo';

  @override
  String get choose_from_gallery => 'Choisir depuis la galerie';

  @override
  String get image_upload_queued =>
      'L\'image va être envoyée en arrière-plan dès que possible.';

  @override
  String get add_price_queued =>
      'Le prix sera envoyé en arrière-plan dès que possible.';

  @override
  String get background_task_title_full_refresh =>
      'Démarrage de la mise à jour de tous les produits stockés localement';

  @override
  String get background_task_title_folksonomy =>
      'Démarrage des actions serveur pour les mises à jour de folksonomie stockées localement';

  @override
  String get background_task_title_top_n =>
      'Démarrage du téléchargement des produits les plus populaires';

  @override
  String get expand_nutrition_facts => 'Développer le tableau nutritionnel';

  @override
  String get expand_nutrition_facts_body =>
      'Garder le tableau nutritionnel étendu';

  @override
  String get expand_ingredients => 'Développer les ingrédients';

  @override
  String get expand_ingredients_body =>
      'Garder le panneau des ingrédients étendu';

  @override
  String get no_internet_connection => 'Pas de connexion internet';

  @override
  String get world_results_label => 'Monde entier';

  @override
  String get world_results_action => 'Étendez votre recherche au monde';

  @override
  String get copy_to_clipboard => 'Copier';

  @override
  String get paste_from_clipboard => 'Coller depuis le presse-papier';

  @override
  String get no_data_available_in_clipboard =>
      'Aucune donnée disponible dans votre presse-papiers';

  @override
  String get clipboard_barcode_copy =>
      'Copier le code-barres dans le presse-papiers';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Le code-barres $barcode a été copié dans le presse-papiers !';
  }

  @override
  String get open_product_website => 'Ouvrir le produit sur sur le site web';

  @override
  String get language_picker_label => 'Votre langue';

  @override
  String get country_picker_label => 'Votre pays';

  @override
  String get currency_picker_label => 'Votre devise';

  @override
  String get help_with_openfoodfacts => 'Bienvenue sur OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Le produit sera mis à jour en arrière-plan dès que possible.';

  @override
  String get no_email_client_available_dialog_title =>
      'Aucune application de messagerie !';

  @override
  String get no_email_client_available_dialog_content =>
      'Veuillez, s\'il vous plaît, nous envoyer manuellement un email à mobile@openfoodfacts.org';

  @override
  String get all_images => 'Toutes les images';

  @override
  String get selected_images => 'Images sélectionnées';

  @override
  String get product_card_remove_product_tooltip => 'Retirer le produit';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nouveau code-barres scanné : $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Retirer tous les produits du carrousel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Veuillez scanner au moins deux produits pour les comparer';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Comparer les produits que vous avez scannés';

  @override
  String get scan_product_loading => 'Vous avez scanné\nle code-barres :';

  @override
  String get scan_product_loading_initial =>
      'Nous recherchons ce produit !\nVeuillez patienter quelques secondes…';

  @override
  String get scan_product_loading_long_request =>
      'Nous recherchons toujours ce produit !\nTrouvez-vous le temps de chargement trop long ? Nous, oui…';

  @override
  String get scan_product_loading_unresponsive =>
      'Nous recherchons toujours ce produit.\nSouhaitez-vous relancer la recherche ?';

  @override
  String get scan_product_loading_restart_button => 'Relancer la recherche';

  @override
  String get portion_calculator_description =>
      'Calculer les valeurs nutritionnelles pour une quantité spécifique';

  @override
  String get portion_calculator_hint => 'Quantité dans';

  @override
  String get portion_calculator_accessibility =>
      'Saisissez une quantité pour calculer la valeur nutritive';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Merci d\'indiquer une quantité entre $min et $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Données manquantes. Le calcul n\'a pas pu être effectué.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Valeurs nutritionnelles pour $grams g (ou ml)';
  }

  @override
  String get offline_data => 'Données hors-ligne';

  @override
  String get ocr_image_upload_instruction =>
      'Téléchargez une image pour extraire automatiquement les informations fournies.';

  @override
  String get upload_image => 'Envoyer une photo';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Échec du téléchargement de l\'image';

  @override
  String get image_edit_url_error =>
      'Impossible d\'éditer l\'image car l\'URL de l\'image n\'a pas été définie.';

  @override
  String get user_picture_source_remember => 'Mémoriser mon choix';

  @override
  String get user_picture_source_ask => 'Demander à chaque fois';

  @override
  String get robotoff_continue => 'Continuer';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count questions',
      one: 'Une question',
    );
    return '$_temp0 de plus !';
  }

  @override
  String get show_password => 'Afficher le Mot de Passe';

  @override
  String get owner_field_info_title => 'Valeurs fournies par le producteur';

  @override
  String get owner_field_info_message =>
      'Avec ce logo, nous mettons en évidence les données fournies par le producteur, et qui peuvent ne pas être modifiables.';

  @override
  String get owner_field_info_close_button => 'Fermer';

  @override
  String get owner_field_image =>
      'Cette image est fournie par le producteur. Elle peut ne pas être éditable.';

  @override
  String get edit_packagings_title => 'Composants d\'emballage';

  @override
  String get edit_packagings_element_add => 'Ajouter un composant d\'emballage';

  @override
  String get edit_packagings_completed => 'L\'emballage est complet';

  @override
  String edit_packagings_element_title(int index) {
    return 'Composant d\'emballage #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Nombre d\'éléments';

  @override
  String get edit_packagings_element_hint_units =>
      'Entrez le nombre d\'unités d\'emballage de la même forme et de la même matière contenue dans le produit.';

  @override
  String get edit_packagings_element_field_shape => 'Forme';

  @override
  String get edit_packagings_element_hint_shape =>
      'Entrez le nom de la forme indiqué dans les instructions de recyclage si elles sont disponibles, ou sélectionnez une forme.';

  @override
  String get edit_packagings_element_example_shape => 'Bouteille';

  @override
  String get edit_packagings_element_field_material => 'Matière';

  @override
  String get edit_packagings_element_hint_material =>
      'Entrez le matériau spécifique s\'il peut être déterminé (un code de matériau à l\'intérieur d\'un triangle peut souvent être trouvé sur les éléments d\'emballage), ou un matériau générique (par exemple du plastique ou du métal) si vous n\'êtes pas sûr.';

  @override
  String get edit_packagings_element_example_material => 'Verre';

  @override
  String get edit_packagings_element_field_recycling => 'Consigne de tri';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Saisissez les instructions de recyclage uniquement si elles figurent sur le produit.';

  @override
  String get edit_packagings_element_example_recycling => 'Recycler';

  @override
  String get edit_packagings_element_field_quantity =>
      'Quantité nette de produit par unité';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Entrez le poids net ou le volume net et indiquez l\'unité (par exemple g ou ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Poids d\'une unité vide (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Retirez tous les restes de nourriture et lavez et séchez l\'emballage avant de peser. Si possible, utilisez une balance avec une précision de 0,1 g ou 0,01 g.';

  @override
  String get background_task_title => 'Contributions en attente';

  @override
  String get background_task_subtitle =>
      'Vos contributions sont automatiquement enregistrées sur notre serveur, mais pas toujours en temps réel.';

  @override
  String get background_task_list_empty =>
      'Aucune tâche d\'arrière-plan en attente';

  @override
  String get background_task_error_server_time_out => 'Timeout du serveur';

  @override
  String get background_task_error_no_internet =>
      'Erreur de connexion Internet. Essayez plus tard.';

  @override
  String get background_task_operation_unknown => 'type d\'opération inconnu';

  @override
  String get background_task_operation_details => 'modifications détaillées';

  @override
  String get background_task_operation_image => 'Téléversement de photo';

  @override
  String get background_task_operation_refresh =>
      'rafraîchissement retardé après le téléversement de la photo';

  @override
  String get background_task_run_started => 'démarré';

  @override
  String get background_task_run_not_started => 'pas encore débuté';

  @override
  String get background_task_run_to_be_deleted => 'à supprimer';

  @override
  String get background_task_question_stop =>
      'Voulez-vous arrêter cette tâche dès que possible ?';

  @override
  String get feed_back => 'Commentaires';

  @override
  String get undo => 'Annuler';

  @override
  String get copy_email_to_clip_board =>
      'Copier l\'adresse e-mail dans le presse-papiers';

  @override
  String get please_send_us_an_email_to =>
      'Veuillez nous envoyer manuellement un e-mail à';

  @override
  String get email_copied_to_clip_board =>
      'E-mail copié dans le presse-papiers !';

  @override
  String get select_accent_color => 'Sélectionnez la couleur d\'accentuation';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Bleu';

  @override
  String get color_cyan => 'Cyan';

  @override
  String get color_green => 'Vert';

  @override
  String get color_light_brown => 'Par défaut';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Orange';

  @override
  String get color_pink => 'Rose';

  @override
  String get color_red => 'Rouge';

  @override
  String get color_rust => 'Rouille';

  @override
  String get color_teal => 'Bleu canard';

  @override
  String get text_contrast_mode => 'Contraste du texte';

  @override
  String get contrast_high => 'Élevée';

  @override
  String get contrast_medium => 'Moyen';

  @override
  String get contrast_low => 'Faible';

  @override
  String get product_refresher_internet_not_found => 'Produit non trouvé!';

  @override
  String get product_refresher_internet_not_connected =>
      'Vous n\'êtes pas connecté à Internet !';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Serveur en panne ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Erreur de serveur ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produit non trouvé!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Un produit avec le code-barres suivant n\'existe pas dans notre base de données : $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Pas de connexion Internet!';

  @override
  String get product_loader_network_error_message =>
      'Veillez à ce que votre téléphone soit sur un réseau Wi-Fi ou que les données mobiles soient activées';

  @override
  String get page_not_found_title => 'Page non trouvée!';

  @override
  String get page_not_found_button => 'Retourner à la page d\'accueil';

  @override
  String get download_data => 'Télécharger les données';

  @override
  String get download_top_products =>
      'Téléchargez les 1000 meilleurs produits de votre pays pour un scan instantané';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produits',
    );
    return 'Téléchargez le top $_temp0 dans votre pays pour une scan instantané';
  }

  @override
  String get download_in_progress =>
      'Téléchargement des données\nCela peut prendre un certain temps';

  @override
  String downloaded_products(int num) {
    return '$num produits ajoutés';
  }

  @override
  String get update_offline_data =>
      'Mettre à jour les données produit hors ligne';

  @override
  String get update_local_database_sub =>
      'Mettre à jour la base locale de produits avec les dernières données d\'Open Food Facts';

  @override
  String get clear_local_database => 'Effacer les données produit hors ligne';

  @override
  String get clear_local_database_sub =>
      'Effacez toutes les données produit locales de votre application pour libérer de l\'espace';

  @override
  String deleted_products(int num) {
    return '$num produits supprimés';
  }

  @override
  String get loading => 'Chargement…';

  @override
  String get know_more => 'En savoir plus';

  @override
  String get offline_data_desc =>
      'Cliquez pour en savoir plus sur les données hors connexion';

  @override
  String get offline_product_data_title => 'Données produit hors ligne';

  @override
  String available_for_download(int num) {
    return '$num produits disponibles pour un scan immédiat';
  }

  @override
  String get country_selector_title => 'Sélectionnez votre pays :';

  @override
  String get currency_selector_title => 'Sélectionnez votre devise:';

  @override
  String get language_selector_title => 'Sélectionnez votre langue :';

  @override
  String get language_selector_section_selected => 'Langues sélectionnées';

  @override
  String get language_selector_section_frequently_used => 'Fréquemment utilisé';

  @override
  String get action_delete_list => 'Supprimer';

  @override
  String get action_change_list => 'Changer la liste actuelle';

  @override
  String get product_list_create => 'Créer';

  @override
  String get product_list_create_tooltip => 'Créer une nouvelle liste';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Nouveau calcul)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (nouveau calcul)';

  @override
  String get nutriscore_unknown => 'Nutri-Score inconnu';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nutri-Score inconnu (Nouveau calcul)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score non applicable';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Le Nutri-Score n\'est pas applicable (Nouveau calcul)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Green-Score A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => 'Green Score inconnu';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score non applicable';

  @override
  String get nova_group_generic_new =>
      'Aliments ultra-transformés - Groupes NOVA';

  @override
  String get nova_group_1 => 'Groupe NOVA 1';

  @override
  String get nova_group_2 => 'Groupe NOVA 2';

  @override
  String get nova_group_3 => 'Groupe NOVA 3';

  @override
  String get nova_group_4 => 'Groupe NOVA 4';

  @override
  String get nova_group_unknown => 'Groupe NOVA inconnu';

  @override
  String get nutrition_facts => 'Valeurs nutritionnelles';

  @override
  String get faq_title_partners => 'Partenaires et Patrons de l\'ONG';

  @override
  String get faq_title_vision =>
      'La vision, la mission, les valeurs et les programmes d’Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Installez Open Beauty Facts pour créer une base de données cosmétiques';

  @override
  String get faq_title_install_pet =>
      'Installez Open Pet Food Facts pour créer une base de données sur les aliments pour animaux de compagnie';

  @override
  String get faq_title_install_product =>
      'Installez Open Products Facts pour créer une base de données de produits afin de prolonger la durée de vie des objets';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nouveau calcul du Nutri-Score : qu\'est-ce qui a changé ?';

  @override
  String get contact_title_pro_page =>
      'Pro? Importez vos produits dans Open Food Facts';

  @override
  String get contact_title_pro_email => 'Contact producteur';

  @override
  String get contact_title_press_page => 'Page de presse';

  @override
  String get contact_title_press_email => 'Contact de presse';

  @override
  String get contact_title_newsletter => 'S\'abonner à notre newsletter';

  @override
  String get contact_title_calendar =>
      'Abonnez-vous à notre calendrier communautaire';

  @override
  String get hunger_games_loading_line1 =>
      'Veuillez nous laisser quelques secondes…';

  @override
  String get hunger_games_loading_line2 => 'Nous téléchargeons les questions !';

  @override
  String get hunger_games_error_label =>
      'Argh ! Quelque chose s\'est mal passé… et nous n\'avons pas pu charger les questions.';

  @override
  String get hunger_games_error_retry_button => 'Réessayons !';

  @override
  String get reorder_attribute_action => 'Réorganiser les attributs';

  @override
  String get link_cant_be_opened =>
      'Ce lien ne peut pas être ouvert sur votre appareil. Veuillez vérifier qu\'un navigateur est installé.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Détails pour $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Détails pour $pageName avec $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Partager';

  @override
  String get guide_nutriscore_v2_title =>
      'Le Nutri-Score change : explications !';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Qu\'est-ce que le Nutri-Score ?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Le Nutri-Score est un logo qui a pour objectif de vous informer sur la **qualité nutritionnelle des aliments**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'Le code couleur varie en allant du vert foncé (**A**) pour les produits les **plus sains** au rouge foncé (**E**) pour les **moins sains**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'Le logo Nutri-Score A';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Pourquoi le Nutri-Score change-t-il ?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'La formule du Nutri-Score **évolue** pour fournir de meilleures recommandations :';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Mieux évaluer l\'ensemble des boissons';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'Les notes comparées du **lait**, les **boissons lactées** avec ajout de sucre et **végétales** ont été mieux différenciées dans le nouvel algorithme.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Un meilleur classement des boissons';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'La **teneur en sucres** est mieux prise en compte et avantage les boissons **faiblement sucrées**.\\nLes **édulcorants seront également pénalisés** : les sodas light vont être déclassés pour passer d’une note B à entre C et E. L’eau reste la boisson recommandée.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Le sel et sucre pénalisés';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Les produits **trop sucrés** ou **trop salés** verront leur **note encore dégradée**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hiérarchisation des huiles et poissons';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'La note de certains **poissons gras** et des **huiles riches en bonnes graisses** va s’améliorer.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limiter la viande rouge';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'La consommation de **viande rouge est à limiter**. C’est pourquoi la **volaille sera comparativement mieux classée**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Comment différencier ancien Nutri-Score et nouveau calcul ?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'Désormais le logo peut arborer une mention \"**Nouveau calcul**\" pour clarifier qu\'il s\'agit bien du nouveau calcul.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Le logo du nouveau Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Où trouver le nouveau calcul du Nutri-Score ?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Le Nutri-Score est appliqué dans 7 pays : France, Allemagne, Belgique, Espagne, Luxembourg, Pays-Bas et Suisse.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Les fabricants disposent au plus tard de **2 ans** après la signature du décret **pour remplacer** l\'ancien calcul par le nouveau.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Sans attendre, vous **retrouvez déjà dans l\'application Open Food Facts**, le nouveau calcul, y compris si les fabriquants n’ont pas mis à jour le score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Ce qui ne change pas';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Le Nutri-Score est un score conçu pour **mesurer la qualité nutritionnelle**. Il est **complémentaire au groupe NOVA** sur les **aliments ultra-transformés** (également présent dans l\'application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Pour les fabricants, l\'affichage du Nutri-Score **reste optionnel**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Qu\'est-ce que le Green Score ?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Le Green-Score est un logo qui vise à vous informer sur l\'**impact environnemental de l\'alimentation**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Le code couleur varie du vert foncé (**A+**) pour les produits **les moins impactants** au rouge foncé (**F**) pour les produits **les plus impactants**.';

  @override
  String get guide_greenscore_logos_caption => 'Les logos Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Le cœur : l\'analyse du cycle de vie (ACV)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Une évaluation scientifique des catégories d\'aliments';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Pour chaque catégorie de produits, un score **de référence** est établi à partir des données de la base de données environnementale Agribalyse (conçue par l\'ADEME et l\'INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**L’analyse du cycle de vie** est une méthode d’évaluation standardisée permettant de réaliser une évaluation environnementale multi-étapes et multi-critères.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Il mesure :**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 étapes de production';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Transformation';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Emballage';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transport';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consommation';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indicateurs d\'impact environnemental';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Changement climatique/empreinte carbone';

  @override
  String get guide_greenscore_lca_arg3_text2 =>
      'Appauvrissement de la couche d\'ozone';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Rayonnement ionisant';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Atterrir';

  @override
  String get guide_greenscore_lca_arg3_text5 =>
      'Consommation d\'eau et d\'énergie';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Pollution de l\'air';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Eau marine et eau douce (particules, acidification, eutrophisation)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Épuisement des ressources.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonus et pénalités';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Pour récompenser les meilleurs produits d\'une catégorie, on applique ensuite des **bonus et des pénalités basés sur plusieurs critères** :';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode de production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'Un **bonus** est accordé aux produits qui possèdent un **label officiel, un label ou une certification qui garantit des avantages environnementaux** (bio, commerce équitable, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origine des ingrédients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'Un **bonus** est attribué en fonction de l\'origine des ingrédients. Ce bonus tient compte de l\'impact **sur les transports** ainsi que de la **politique environnementale** du pays de chaque producteur.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Espèces menacées';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Un **malus** est appliqué aux produits contenant des ingrédients ayant des **impacts négatifs importants sur la biodiversité et les écosystèmes**, comme l\'huile de palme, dont la production est responsable d\'une déforestation massive.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Emballage';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'Une **pénalité** est calculée pour tenir compte de la **circularité de l\'emballage** (utilisation de matières premières recyclées et recyclabilité) et du suremballage.';

  @override
  String get guide_greenscore_transparency_title =>
      'Un besoin accru de transparence pour mieux mesurer et réduire les impacts environnementaux';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Pour calculer avec précision le Green-Score, il est nécessaire de disposer d\'**informations qui ne sont pas nécessairement spécifiées sur l\'emballage** (telles que l\'origine et le pourcentage exact de chaque ingrédient) ou qui sont rarement disponibles sous une forme utilisable (telles qu\'une liste de tous les composants de l\'emballage avec les types précis de plastiques utilisés).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Des valeurs moyennes sont utilisées lorsque ces informations ne sont pas encore disponibles**, mais nous faisons maintenant appel à tous pour nous aider à collecter ces informations qui seront très utiles pour le Green-Score, mais aussi pour de nombreuses autres utilisations.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Comment les citoyens peuvent-ils aider ?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Tous les citoyens peuvent nous aider à rassembler et à structurer les informations présentes sur les produits ou qui peuvent en être déduites, telles que les informations sur l\'**emballage** : « Mission Emballages » : un inventaire collaboratif à grande échelle des emballages pour tous les produits alimentaires.';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Comment les fabricants peuvent aider';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Les fabricants peuvent nous envoyer leurs informations directement via notre plateforme gratuite destinée aux producteurs.';

  @override
  String get guide_greenscore_better_product_title =>
      'Quel produit est le meilleur pour la planète ?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Cela peut être difficile à dire';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Choisir une alimentation durable est l’une des choses les plus puissantes que nous puissions faire pour le climat, car **notre système alimentaire mondial est responsable de plus d’un quart de toutes les émissions de gaz à effet de serre**.\n(Source : Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title =>
      'Vous avez le pouvoir !';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'La bonne nouvelle, c\'est que cela nous offre un moyen puissant de créer le changement.\n**Chacun de nous mange environ 1 000 repas par an**. Cela représente 1 000 occasions de **choisir un avenir meilleur pour la planète** !';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Aide à être responsable et à décider';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Choisir une alimentation durable peut s\'avérer complexe. Les étiquettes sont confuses et les informations sont souvent manquantes. Le Green-Score a été créé pour simplifier les choses, en vous fournissant une évaluation environnementale **claire**, **fondée scientifiquement** et **transparente** des produits alimentaires, là où vous en avez besoin : pendant vos courses.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparence';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Contrairement aux labels propriétaires, le calcul du Green-Score est **complètement ouvert** et peut être **vérifié par n\'importe qui**.';

  @override
  String get guide_nova_title => 'Aliments ultra-transformés';

  @override
  String get guide_nova_what_is_nova_title =>
      'Qu\'est-ce que l\'ultra-transformation ?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Les groupes NOVA vous informent sur le niveau de transformation des aliments.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'La classification NOVA permet de catégoriser les aliments en **4 groupes** en fonction de leur **degré de transformation industrielle** (aliments peu ou non transformés, ingrédients culinaires, aliments transformés, aliments ultra-transformés).';

  @override
  String get guide_nova_logos_caption => 'Les logos NOVA';

  @override
  String get guide_nova_groups_title => 'Les 4 groupes NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Il existe 4 groupes NOVA, le groupe problématique étant le groupe 4 - Aliments ultra-transformés.';

  @override
  String get guide_nova_groups_arg1_title => 'Aliments peu ou non transformés';

  @override
  String get guide_nova_groups_arg1_text =>
      'Les aliments non transformés (ou naturels) sont les **parties comestibles des plantes** (graines, fruits, feuilles, tiges, racines) **ou des animaux** (muscles, abats, œufs, lait), ainsi que les champignons, les algues et l\'eau, après avoir été séparés de la nature.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Ingrédients culinaires transformés';

  @override
  String get guide_nova_groups_arg2_text =>
      'Les ingrédients culinaires transformés, tels que les **huiles, le beurre, le sucre et le sel**, sont des substances dérivées des aliments du groupe 1 ou de la nature par des procédés qui comprennent le pressage, le raffinage, le broyage, la mouture et le séchage.';

  @override
  String get guide_nova_groups_arg3_title => 'Aliments transformés';

  @override
  String get guide_nova_groups_arg3_text =>
      'Les aliments transformés, tels que les légumes en conserve, le poisson en conserve, les fruits au sirop, les fromages et les pains frais, sont **principalement obtenus par l\'ajout de sel, d\'huile, de sucre ou d\'autres substances issues des groupes 2 aux aliments du groupe 1**. Les procédés de transformation comprennent diverses méthodes de conservation ou de cuisson et, dans le cas du pain et du fromage, une fermentation non alcoolique. La plupart des aliments transformés contiennent deux ou trois ingrédients et sont reconnaissables comme des versions modifiées des aliments du groupe 1. Ils peuvent être consommés seuls ou, le plus souvent, accompagnés d\'autres aliments.';

  @override
  String get guide_nova_groups_arg4_title => 'Aliments ultra-transformés';

  @override
  String get guide_nova_groups_arg4_text =>
      'Les aliments ultra-transformés, tels que les boissons gazeuses, les collations emballées sucrées ou salées, les produits carnés reconstitués et les plats surgelés préparés, **ne sont pas de simples aliments modifiés, mais des formulations composées principalement ou entièrement de substances dérivées d\'aliments et d\'additifs**, ne contenant que très peu, voire pas du tout, d\'aliments intacts du groupe 1. Les ingrédients de ces formulations comprennent généralement ceux que l\'on retrouve également dans les aliments transformés, comme les sucres, les huiles, les matières grasses ou le sel. Cependant, les produits ultra-transformés contiennent aussi d\'autres sources d\'énergie et de nutriments qui ne sont généralement pas utilisées dans les préparations culinaires. Certaines de ces sources sont directement extraites des aliments, comme la caséine, le lactose, le lactosérum et le gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Les problèmes liés à l\'ultra-traitement';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Transformation extrême des ingrédients alimentaires';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Beaucoup sont **dérivés de la transformation ultérieure de constituants alimentaires**, tels que les huiles hydrogénées ou interestérifiées, les protéines hydrolysées, l\'isolat de protéines de soja, la maltodextrine, le sucre inverti et le sirop de maïs à haute teneur en fructose.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Des additifs qui vont au-delà de la simple sécurité alimentaire';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Les additifs présents dans les aliments ultra-transformés comprennent certains additifs également utilisés dans les aliments transformés, tels que les conservateurs, les antioxydants et les stabilisants. Parmi les additifs spécifiques aux produits ultra-transformés figurent ceux utilisés **pour imiter ou rehausser les qualités organoleptiques des aliments ou pour masquer les aspects désagréables du produit final.** Ces additifs incluent les colorants, les stabilisants de couleur, les arômes, les exhausteurs de goût, les édulcorants non sucrés, ainsi que les auxiliaires technologiques tels que les agents de carbonatation, de raffermissement, de charge et anti-charge, les agents antimousse, anti-agglomérants et d\'enrobage, les émulsifiants, les séquestrants et les humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Traitements que vous ne pouvez pas faire à la maison';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Une multitude de procédés successifs sont utilisés** pour combiner les nombreux ingrédients et créer le produit final (d\'où le terme « ultra-transformé »). Parmi ces procédés, plusieurs sont **sans équivalent domestique**, comme l\'hydrogénation et l\'hydrolyse, l\'extrusion et le moulage, ainsi que le prétraitement avant friture.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Les aspects prédateurs et financiers de l\'ultra-transformation';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**L’objectif global de l’ultra-transformation est de créer des produits alimentaires de marque**, **commodes** (à longue durée de vie et prêts à consommer), **attirants**(très savoureux) et **très rentables** (ingrédients à bas coût), conçus pour supplanter tous les autres groupes alimentaires. Ces produits sont généralement présentés dans des emballages attrayants et font l’objet d’un marketing intensif.';

  @override
  String get guide_nova_explanations_arg5_title => 'Un risque pour la santé';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Depuis 2018, avec NutriNet-Santé, les premiers liens entre **la consommation d\'aliments ultra-transformés et l\'augmentation des risques de cancer, de maladies cardiovasculaires et de diabète ont été soulignés**. Aujourd\'hui, plus de 90 études dans le monde confirment ces conclusions.\nLes associations les plus fortes portent sur l\'**obésité, la mortalité cardiovasculaire et les symptômes dépressifs**. Pour les enfants, les effets sont principalement observés sur les déséquilibres de poids et de lipide.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Les pays recommandent de les limiter';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Certains pays utilisent les groupes NOVA pour leurs recommandations ou objectifs nutritionnels, par exemple :\n\n- Les recommandations nutritionnelles du **🇧🇷 Brésil** recommandent de limiter la consommation d’aliments transformés et d’éviter les aliments ultra-transformés.\n\n- Les objectifs de la politique nutritionnelle de santé publique de la **🇫🇷 France** pour la période 2018-2022 visent à **réduire de 20 % la consommation d’aliments ultra-transformés du groupe 4**.';

  @override
  String get guide_nova_share_link => 'https://world-fr.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Bienvenue sur Open Food Facts !';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Qu\'est-ce qu\'Open Food Facts ?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts est une base de données **collaborative**, **gratuite** et **ouverte** de produits alimentaires du monde entier.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Nous pensons que tout le monde devrait avoir accès à des informations sur ce qu\'il ou elle mange. En recueillant des données sur les ingrédients, les allergènes, les infos nutritionnelles et plus encore, nous permettons aux consommateurs de faire des choix éclairés** et de pousser l\'industrie alimentaire **vers une plus grande transparence**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Fonctionnalités d\'Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Recevez des alertes sur les ingrédients que vous souhaitez éviter';

  @override
  String get guide_open_food_facts_tips_title =>
      'Conseils pour prendre de bonnes photos';

  @override
  String get guide_open_food_facts_tips_arg1_title =>
      'Ce qu\'il ne faut pas faire';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Évitez les ombres et les reflets.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Aucun texte flou ou hors focus.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Ne rognez pas de parties du texte.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Évitez les arrière-plans chargés.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'À faire';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Utilisez un éclairage uniforme et de bonne qualité.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Veillez à ce que le texte soit net et lisible.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capturez la liste complète des ingrédients.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Gardez le produit sur une surface plane.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Aidez-nous à construire le « Wikipédia de l\'alimentation »';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Une note sur la qualité nutritionnelle';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Une note pour éviter les aliments ultra-transformés';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Un score pour la planète';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-fr.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Bienvenue sur Open Pet Food Facts !';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Qu\'est-ce que Open Pet Food Facts ?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts étend notre mission à nos amis à quatre pattes ! Il s\'agit d\'une **base de données de produits alimentaires pour chats, chiens et autres animaux de compagnie**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Nous recueillons des informations sur les **ingrédients**, l\'**analyse nutritionnelle** et les recommandations d\'alimentation afin d\'aider les propriétaires d\'animaux à choisir la meilleure alimentation pour les besoins de leurs animaux.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Fonctionnalités d\'Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Recevez des alertes sur les ingrédients que vous souhaitez éviter';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Votre animal est-il allergique à certains ingrédients ? Vous pouvez créer une liste d’ingrédients cosmétiques à éviter directement dans l’application !';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Conseils pour prendre de bonnes photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title =>
      'Ce qu\'il ne faut pas faire';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Évitez les ombres et les reflets.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Aucun texte flou ou hors focus.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Ne rognez pas de parties du texte.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Évitez les arrière-plans chargés.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'À faire';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Utilisez un éclairage uniforme et de bonne qualité.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Veillez à ce que le texte soit net et lisible.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capturez la liste complète des ingrédients.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Gardez le produit sur une surface plane.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'Note sur la notation';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'L\'élaboration d\'un système de notation pour les aliments pour animaux de compagnie **n\'est pas une priorité actuellement**. La méthodologie serait complexe, car les besoins nutritionnels varient considérablement selon l\'espèce, l\'âge et l\'état de santé. Nous n\'avons pas encore trouvé d\'équipe scientifique indépendante capable de développer un tel système.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-fr.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Bienvenue sur Open Beauty Facts !';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Qu\'est-ce qu\'Open Beauty Facts ?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts est une base de données collaborative de **produits cosmétiques**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Notre objectif est de décrypter les listes d\'ingrédients pour vous aider à **comprendre la composition de vos produits de soins personnels**. Des crèmes hydratantes au maquillage, nous collectons des données sur les ingrédients, les allergènes et les emballages afin de promouvoir la transparence dans l\'industrie cosmétique.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Fonctionnalités d\'Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Recevez des alertes sur les ingrédients que vous souhaitez éviter';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Êtes-vous allergique à certains ingrédients ? Souhaitez-vous éviter les substances comédogènes ? Préférez-vous vous tenir à l’écart des composants controversés ? Vous pouvez créer une liste d’ingrédients cosmétiques à éviter, directement dans l’application !';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Conseils pour prendre de bonnes photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title =>
      'Ce qu\'il ne faut pas faire';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Évitez les ombres et les reflets.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Aucun texte flou ou hors focus.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Ne rognez pas de parties du texte.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Évitez les arrière-plans chargés.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'À faire';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Utilisez un éclairage uniforme et de bonne qualité.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Veillez à ce que le texte soit net et lisible.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capturez la liste complète des ingrédients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Prenez autant de photos que nécessaire si la bouteille est incurvée.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Il vous faudra peut-être décoller l\'étiquette pour voir la liste des ingrédients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Gardez le produit sur une surface plane.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Note sur la notation';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Contrairement aux produits alimentaires, le monde des cosmétiques ne dispose pas d\'un système de notation universellement reconnu et approuvé par les pouvoirs publics, tel que le Nutri-Score. Les effets des ingrédients peuvent être très variables d\'une personne à l\'autre et dépendent du type de peau, des allergies et des préoccupations individuelles.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-fr.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Bienvenue chez Open Prices !';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Qu\'est-ce qu\'Open Prices ?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices est un projet visant à **collecter et partager les prix des produits du monde entier**. Il s\'agit d\'un jeu de données publiques pouvant servir à la recherche, à l\'analyse et à bien d\'autres fins. Open Prices est développé et maintenu par Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Actuellement, seules quelques entreprises détiennent une base de données de prix de produits au niveau des code-barres. Ces bases de données ne sont pas librement disponibles, mais vendues à un prix élevé à des acteurs privés, des chercheurs et d\'autres organisations qui sont en mesure de les acheter.';

  @override
  String get guide_open_prices_how_title => 'Comment fonctionne Open Prices ?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Nous constituons une base de données de prix en accès libre grâce à la contribution de la communauté.** Les utilisateurs peuvent ajouter des prix via cette application web ou via l\'application mobile officielle Open Food Facts. Les détaillants et les applications tierces peuvent également contribuer en utilisant notre API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collectez des photos des étiquettes de prix dans les rayons';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Collectez des photos des reçus';

  @override
  String get guide_open_prices_why_title =>
      'Pourquoi Open Food Facts fait-il cela ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'L\'information sur les prix est essentielle pour comprendre les systèmes alimentaires. Elle est déterminante pour appréhender le coût des aliments et promouvoir des régimes alimentaires plus sains. Les données sur Open Prices permettent aux chercheurs, aux journalistes et aux citoyens de mieux comprendre les variations des prix alimentaires dans le temps et l\'espace.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Suivre l\'évolution des prix au fil du temps';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Observez l’**évolution des prix** : shrinkflation, cheapflation, nous pouvons les suivre ensemble !';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Comparez les prix près de chez vous';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Au fur et à mesure que nous recevrons davantage de prix, vous pourrez repérer **les magasins les moins chers autour de chez vous**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Avez-vous pensé à scraper les prix sur les sites Web des distributeurs ?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Pour des raisons juridiques et techniques, **nous ne considérons pas la récupération des prix sur les sites web des détaillants comme une méthode valable pour contribuer à Open Prices**. Nous tenons à garantir l\'exactitude et la mise à jour des prix que nous collectons, et la réception de prix scrapés par des contributeurs ne nous permet pas d\'atteindre cet objectif.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Le scraping des prix est une option envisagée dans une version future d\'Open Prices, mais il serait effectué par Open Prices directement afin que nous puissions avoir une preuve du prix basée sur la page HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'Je suis un distributeur et je souhaite contribuer des prix. Comment puis-je le faire ?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Vous pouvez contribuer en fournissant des prix via notre API.\nSi vous souhaitez contribuer à grande échelle, veuillez nous contacter à l\'adresse prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Bienvenue sur Open Products Facts !';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Qu\'est-ce que Open Products Facts ?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts est une base de données ouverte et massive recensant **tout produit possédant un code-barres, à l\'exception des produits alimentaires, cosmétiques et des aliments pour animaux**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Des **appareils électroniques** aux **jouets**, en passant par les **vêtements** et les **produits d\'entretien**, tout objet muni d\'un code-barres peut être intégré. Ce projet vise à créer un « Internet des objets » pour les objets du quotidien, rendant ainsi les informations les concernant accessibles à tous.';

  @override
  String get guide_open_products_facts_features_title =>
      'Fonctionnalités d\'Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts vise à permettre aux consommateurs de **prolonger la durée de vie des objets** en leur fournissant des solutions circulaires pour entretenir, **réparer**, **recycler** leurs objets ou leur trouver un nouveau propriétaire.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Empreintes carbone de certains produits';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** de l\'ADEME (Agence française pour l\'environnement et la gestion des énergies renouvelables) indique l\'**impact carbone** de nombreuses catégories ; veillez à catégoriser vos produits avec précision.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Indice de réparabilité pour de nombreux produits';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Dès qu\'un indice de réparabilité français sera disponible, nous l\'afficherons. De plus, **vous pouvez commencer à collecter les variables à l\'aide du moteur de folksonomie** ; ainsi, nous pourrons le recalculer nous-mêmes ultérieurement, même dans les pays où il n\'est pas disponible.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Trouvez des moyens de donner/revendre votre produit';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Nous vous proposons des liens vers des **services tiers éco-responsables** qui vous permettent de trouver le produit que vous recherchez d\'occasion, afin de préserver les ressources de la planète.\nVeuillez noter que ce service est entièrement gratuit et que le système n\'est présenté qu\'à titre d\'exemple pour deux sites web en France. Vous pouvez contribuer à son développement en répertoriant d\'autres sites sur le wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Le moteur de folksonomie';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Le moteur de folksonomie est un outil qui vous aide à compléter vos produits avec des propriétés pertinentes. Cela permet d\'améliorer la recherche et la visibilité, mais aussi de calculer et d\'afficher des informations intéressantes à l\'avenir.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Vous pouvez ajouter des clés et des valeurs comme : **compatibilité_avec_réseau_mobile_5G : oui** (veuillez les rentrer en anglais, le système n\'est pas multilingue)';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Vous recevrez des suggestions automatiques de propriétés possibles, et vous êtes invités à en ajouter et à documenter de nouvelles sur vos types de produits préférés.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-fr.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Ouvrir les préférences alimentaires';

  @override
  String get guide_coming_soon_button_title => 'Bientôt disponible';

  @override
  String get guide_learn_more_subtitle => 'Appuyez pour en savoir plus';

  @override
  String get preview_badge => 'Aperçu';

  @override
  String get prices_feedback_form =>
      'Cliquez ici pour nous envoyer vos commentaires sur cette nouvelle fonctionnalité !';

  @override
  String get menu_button_list_actions => 'Sélectionner une action';

  @override
  String get error_loading_photo => 'Erreur lors du chargement de la photo';

  @override
  String get photo_viewer_action_use_picture_as => 'Utiliser comme…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Utilisez cette image comme…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Utilisez cette image comme… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Détails';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Détails de cette photo';

  @override
  String get photo_viewer_details_title => 'Détails de la photo';

  @override
  String get photo_viewer_details_contributor_title => 'Contributeur';

  @override
  String get photo_viewer_details_size_title => 'Taille';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixels';
  }

  @override
  String get photo_viewer_details_date_title => 'Date';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Compatible';

  @override
  String get user_lists_action_multi_select => 'Sélection multiple';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Votre score de compatibilité : $score%';
  }

  @override
  String get product_image_front_accessibility_label =>
      'Photo du produit (recto)';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Photo de la liste des ingrédients';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Photo de la nutrition';

  @override
  String get product_image_packaging_accessibility_label =>
      'Photo de l\'emballage';

  @override
  String get product_image_other_accessibility_label => 'Autres photos';

  @override
  String get product_image_outdated_message => 'Cette image peut être obsolète';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (cette image peut être obsolète)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (cette image peut être verrouillée par le producteur)';
  }

  @override
  String get product_image_error => 'Impossible de charger la photo !';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Impossible de charger le $type (erreur réseau ?)';
  }

  @override
  String get product_page_image_no_image_available => 'Pas \nd\'image !';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Aucune image disponible pour ce produit';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Réorganiser ou masquer les actions';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Modifier les actions';

  @override
  String get product_page_action_bar_item_move_up => 'Déplacer vers le haut';

  @override
  String get product_page_action_bar_item_move_down => 'Déplacer vers le bas';

  @override
  String get product_page_action_bar_item_enable => 'Activer l\'action';

  @override
  String get product_page_action_bar_item_disable => 'Désactiver l\'action';

  @override
  String get product_page_pending_operations_banner_title =>
      'Envoi de vos modifications…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Les données affichées sur cette page **ne reflètent pas encore vos modifications**.\nVeuillez patienter quelques secondes…';

  @override
  String get product_add_a_language => 'Ajouter une langue';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Code-barres : $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Supprimer ce produit du carrousel';

  @override
  String get carousel_unsupported_header => 'Code-barres non pris en charge !';

  @override
  String get carousel_unsupported_title => 'Ouuups!';

  @override
  String get carousel_unsupported_text =>
      'Le code-barres scanné n\'est pas pris en charge par Open Food Facts !';

  @override
  String get carousel_error_header => 'Erreur !';

  @override
  String get carousel_error_title => 'C\'est dommage !';

  @override
  String get carousel_error_text_1 =>
      'Nous n\'avons pas pu télécharger d\'informations sur ce code-barres :';

  @override
  String get carousel_error_text_2 =>
      'Veuillez vérifier votre connexion Internet ou cliquez sur ce bouton :';

  @override
  String get carousel_error_button => 'Réessayer';

  @override
  String get carousel_unknown_product_header => 'Produit inconnu';

  @override
  String get carousel_unknown_product_title =>
      'Félicitations !\nVous avez trouvé __la perle rare !__';

  @override
  String get carousel_unknown_product_text =>
      'Notre base de données collaborative contient plus de **3 millions de produits**, mais ce code-barres n\'existe pas : ';

  @override
  String get carousel_unknown_product_button => 'Ajouter ce produit';

  @override
  String get carousel_loading_header => 'Chargement des informations...';

  @override
  String get carousel_loading_title =>
      'Vous venez de scanner un produit avec le code-barres suivant :';

  @override
  String get carousel_loading_text =>
      'Nous le recherchons dans notre base de données de plus de **3 millions de produits !**';

  @override
  String get product_type_subtitle_food =>
      'Légumes, fruits, aliments surgelés…';

  @override
  String get product_type_subtitle_beauty => 'Maquillage, savons, dentifrices…';

  @override
  String get product_type_subtitle_pet_food => 'Nourriture pour chiens, chats…';

  @override
  String get product_type_subtitle_product => 'Smartphones, meubles…';

  @override
  String get photo_field_front => 'Photo du produit';

  @override
  String get photo_field_ingredients => 'Photo des ingrédients';

  @override
  String get photo_field_nutrition => 'Informations nutritionnelles';

  @override
  String get photo_field_packaging => 'Photo des consignes de tri/recyclage';

  @override
  String get photo_already_exists => 'Cette photo existe déjà';

  @override
  String get photo_missing => 'Cette photo est manquante';

  @override
  String get date => 'Date';

  @override
  String get photo_rotate_left => 'Pivoter à gauche';

  @override
  String get photo_rotate_right => 'Pivoter à droite';

  @override
  String get photo_undo_action => 'Annuler l\'action précédente';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Une carte de $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Contributeurs OpenStreetMap';

  @override
  String get not_applicable_short => 'N/A';

  @override
  String get knowledge_panel_warning_text => 'Avertissement';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Pourquoi ce Nutri-Score est-il différent de celui présent sur l\'emballage ?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Il y a deux explications possibles :\nLa liste des ingrédients et/ou le tableau nutritionnel ne sont pas à jour.\n\nNous affichons le \"Nouveau calcul\" du Nutri-Score (ou V2). Vérifiez que le libellé \"Nouveau calcul\" est bien sur l\'emballage.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Vérifier les ingredients';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Vérifier le tableau nutritionnel';

  @override
  String url_not_supported(String url) {
    return 'Malheureusement, nous ne pouvez pas ouvrir l\'adresse :\n$url';
  }

  @override
  String get product_list_export => 'Exporter';

  @override
  String get product_list_import => 'Importer';

  @override
  String get product_footer_action_barcode => 'Voir le code-barres';

  @override
  String get product_footer_action_barcode_short => 'Code-barres';

  @override
  String get product_footer_action_open_website => 'Ouvrir le site web';

  @override
  String get product_footer_action_report => 'Signaler';

  @override
  String get product_footer_action_contributor_guide => 'Aide';

  @override
  String get product_footer_action_data_quality_tags => 'Qualité des données';

  @override
  String get product_page_tab_for_me => 'Pour moi';

  @override
  String get product_page_tab_website => 'Site Web';

  @override
  String get product_page_tab_prices => 'Prix';

  @override
  String get prices_explanation_card_title => 'Pourquoi ces prix ?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** est un projet visant à collecter et partager les prix des produits du monde entier 🌍. Open Prices est développé et maintenu par Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'En savoir plus';

  @override
  String get product_page_tab_folksonomy => 'Folksonomie';

  @override
  String get folksonomy_explanation_card_title =>
      'Quels sont les attributs de la folksonomie ?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Les attributs sont de type **clé-valeur**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Ces propriétés sont créées et enregistrées par les contributeurs pour tout type d\'utilisation.';

  @override
  String get folksonomy_action_external_link_title => 'Ouvrir le lien externe';

  @override
  String get folksonomy_action_external_link_warning =>
      'Les liens externes peuvent être dangereux. Voulez-vous vraiment y accéder ?';

  @override
  String get prices_products_empty_title => 'Aucun prix disponible';

  @override
  String get prices_products_empty_explanation =>
      'Soyez le premier à contribuer !';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Meilleurs $pageSize produits  (total : $total)';
  }

  @override
  String get app_review_title => 'Appréciez-vous cette application ?';

  @override
  String get app_review_low => 'Pourrait mieux faire';

  @override
  String get app_review_medium => 'Pas mal';

  @override
  String get app_review_high => 'J\'adore !';

  @override
  String get app_review_feedback_modal_title =>
      'Aidez-nous à améliorer notre application';

  @override
  String get app_review_feedback_modal_content =>
      'Si vous avez quelques minutes, pourriez-vous répondre à ce questionnaire afin que **nous puissions nous améliorer dans les prochaines mises à jour** :';

  @override
  String get app_review_feedback_modal_open_form => 'Répondre au questionnaire';

  @override
  String get app_review_feedback_modal_later => 'Me demander plus tard';

  @override
  String get nutrition_facts_extract_new =>
      'NOUVEAU : Vous pouvez extraire automatiquement les nutriments de l\'image !';

  @override
  String get nutrition_facts_extract_button_text => 'Extraire maintenant';

  @override
  String get nutrition_facts_extract_in_progress => 'Extraction en cours…';

  @override
  String get nutrition_facts_extract_successful => 'Extraction réussie';

  @override
  String get nutrition_facts_extract_failed =>
      'Impossible d\'extraire les nutriments de l\'image';

  @override
  String get prices_discount => 'Promo';

  @override
  String get prices_stats_statistics => 'Statistiques';

  @override
  String get prices_stats_title => 'Statistiques des prix';

  @override
  String get prices_stats_prices_section => 'Prix';

  @override
  String get prices_stats_products_section => 'Produits';

  @override
  String get prices_stats_locations_section => 'Lieux';

  @override
  String get prices_stats_proofs_section => 'Preuves';

  @override
  String get prices_stats_contributors_section => 'Contributeurs';

  @override
  String get prices_stats_experiments_section => 'Expérimentations';

  @override
  String get prices_stats_misc_section => 'Divers';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'Avec un code-barres';

  @override
  String get prices_stats_with_category => 'Avec une catégorie';

  @override
  String get prices_stats_with_discount => 'Avec une promotion';

  @override
  String get prices_stats_community => 'Communauté';

  @override
  String get prices_stats_consumption => 'Consommation';

  @override
  String get prices_stats_with_price => 'Avec un prix';

  @override
  String get prices_stats_food => 'Nourriture';

  @override
  String get prices_stats_beauty => 'Beauté';

  @override
  String get prices_stats_products => 'Produits';

  @override
  String get prices_stats_pet_food => 'Nourriture pour animaux de compagnie';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'En ligne';

  @override
  String get prices_stats_countries => 'Pays';

  @override
  String get prices_stats_price_tag => 'Étiquette de prix';

  @override
  String get prices_stats_receipt => 'Ticket de caisse';

  @override
  String get prices_stats_gdpr_request => 'Requête RGPD';

  @override
  String get prices_stats_shop_import => 'Import magasin';

  @override
  String get prices_stats_challenges => 'Défis';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Prix liés à une étiquette de prix';

  @override
  String get prices_stats_currencies => 'Monnaies';

  @override
  String get prices_stats_years => 'Années';

  @override
  String get prices_stats_by_source_title => 'Prix et preuves par source';

  @override
  String get prices_stats_website => 'Site Web';

  @override
  String get prices_stats_mobile_app => 'App mobile';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Autre';

  @override
  String get prices_stats_last_updated => 'Dernière mise à jour le';

  @override
  String get prices_stats_error =>
      'Une erreur s\'est produite lors du chargement des statistiques.';

  @override
  String get product_edit_robotoff_question_answered => 'Question répondue !';

  @override
  String get product_edit_robotoff_proof => 'Preuve';

  @override
  String get preferences_card_general => 'Général';

  @override
  String get preferences_prices_title => 'Prix';

  @override
  String get preferences_prices_subtitle => 'Gérez vos préférences de prix';

  @override
  String get preferences_card_project => 'Le projet Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribuer';

  @override
  String get preferences_my_contributions_title => 'Mes contributions';

  @override
  String get preferences_my_stats_title => 'Mes statistiques';

  @override
  String get preferences_contribute_subtitle =>
      'Traduisez, améliorez nos outils…';

  @override
  String get preferences_connect_title => 'Connecter';

  @override
  String get preferences_connect_subtitle =>
      'Contactez-nous ou suivez-nous sur les réseaux sociaux';

  @override
  String get preferences_support_title => 'Faire un don';

  @override
  String get preferences_support_subtitle =>
      'Aidez-nous à informer des millions de consommateurs à travers le monde';

  @override
  String get preferences_card_help => 'Aide et support';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle => 'Obtenez des réponses à vos questions';

  @override
  String get logged_out => 'Déconnecté';

  @override
  String get preferences_app_bar_message =>
      'Merci d\'être l\'un de nos membres !';

  @override
  String get preferences_app_bar_products_modified => 'Produits modifiés';

  @override
  String get preferences_app_bar_prices_added => 'Prix ajoutés';

  @override
  String get preferences_app_bar_see_all_stats =>
      'Voir toutes les statistiques';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Rechercher $provider pour \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Rechercher un paramètre (ex : Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Accessibilité : Afficher les emojis';

  @override
  String get preferences_accessibility_remove_colors =>
      'Accessibilité : Supprimer les couleurs';

  @override
  String get preferences_app_settings_products => 'Produits';

  @override
  String get preferences_card_about => 'À propos';

  @override
  String get preferences_legal_information_title => 'Informations légales';

  @override
  String get preferences_legal_information_subtitle =>
      'Conditions d\'utilisation, politique de confidentialité et plus encore';

  @override
  String get preferences_terms_of_use => 'Conditions d\'utilisation';

  @override
  String get preferences_legal_mentions => 'Mentions légales';

  @override
  String get preferences_legal_header =>
      'Open Food Facts est une base de données de produits alimentaires **créée par tout le monde, pour tout le monde**.\nVous pouvez l\'utiliser pour faire de meilleurs choix alimentaires, et comme il s\'agit de **données ouvertes**, tout le monde peut **la réutiliser à n\'importe quelle fin**.';

  @override
  String get preferences_privacy_policy => 'Politique de confidentialité';

  @override
  String get preferences_licenses => 'Licences';

  @override
  String get preferences_about_app_title => 'À propos de l\'application';

  @override
  String get preferences_about_app_subtitle =>
      'Informations techniques, informations pour les développeurs et plus encore';

  @override
  String get preferences_card_information => 'Information';

  @override
  String get preferences_version_number_title => 'Numéro de version';

  @override
  String get preferences_scanner_title => 'Scanner';

  @override
  String get preferences_app_store => 'App Store';

  @override
  String get preferences_app_system_settings => 'Paramètres du système';

  @override
  String get preferences_source_code => 'Accéder au code source';

  @override
  String get preferences_source_code_subtitle =>
      'Et commencez à avoir un impact pour des millions de personnes';

  @override
  String get preferences_add_prices => 'Ajouter des prix';

  @override
  String get preferences_complete_products => 'Compléter des produits';

  @override
  String get preferences_tips => 'Conseils';

  @override
  String get tips_discover_nutriscore => 'Découvrez le nouveau Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Sur le site Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Gérer mon compte';

  @override
  String get preferences_manage_account_tooltip => 'Gérez votre compte';

  @override
  String get preferences_change_password_title => 'Changer mon mot de passe';

  @override
  String get preferences_danger_zone => 'Zone dangereuse';

  @override
  String get preferences_account_deletion_subtitle =>
      'Toutes vos contributions seront perdues';

  @override
  String get preferences_contributions_title => 'Contributions';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Paramètres de l\'application';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Une méthode très expérimentale pour scanner des produits hors ligne';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Actualiser tous les produits du serveur';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Veuillez éviter de faire cela à moins que cela ne soit absolument nécessaire.';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Mode démo';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Ajouter des cartes au scanner';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Ajoute 3 échantillons de produits au scanner';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Hôte de Folksonomy Engine';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Hôte : $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Expériences d\'accessibilité';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Sélection multi-produits pour les prix';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Panneaux de connaissances commandés par l\'utilisateur';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Accès temporaire à la recherche de localisation';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Comparaison côte à côte pour 2 ou 3 produits';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Importation de la liste des produits';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Scores et méthodologies';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Découvrez comment le Nutri-Score est calculé';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Découvrez les principaux changements apportés à la méthodologie';

  @override
  String get preferences_faq_discover_project_title => 'Découvrez le projet';

  @override
  String get preferences_faq_discover_off_title => 'Découvrez Open Food Facts';

  @override
  String get preferences_faq_discover_obf_title =>
      'Découvrez Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Découvrez Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Découvrez Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Découvrez Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'FAQ - Foire aux questions';

  @override
  String get preferences_faq_off_ngo_title => 'L\'ONG Open Food Facts';

  @override
  String get preferences_about_information_title => 'Information';

  @override
  String get preferences_connect_community_updates_title =>
      'Recevez les mises à jour de la communauté';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Restez informé des actualités de l\'application et de la communauté';

  @override
  String get preferences_connect_community_calendar_title =>
      'Abonnez-vous à notre calendrier communautaire';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Impliquez-vous en participant à l\'un de nos événements virtuels';

  @override
  String get preferences_connect_blog_title => 'Le blog Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Recevez les dernières nouvelles, au fur et à mesure qu\'elles se produisent';

  @override
  String get preferences_connect_community_help_title =>
      'Obtenez de l\'aide de la communauté';

  @override
  String get preferences_connect_improve_app_title =>
      'Aidez-nous à améliorer l\'application';

  @override
  String get preferences_connect_debug_info_title =>
      'Envoyez-nous des informations de débogage';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Envoyez-nous un e-mail avec des informations de débogage détaillées';

  @override
  String get preferences_connect_feedback_title =>
      'Envoyez-nous vos commentaires sur l\'application';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Aidez-nous à façonner l\'avenir de l\'application';

  @override
  String get preferences_connect_survey_title =>
      'Participez à l\'enquête sur l\'application';

  @override
  String get preferences_connect_survey_subtitle =>
      'Aidez-nous à comprendre ce que nous devrions construire ensuite';

  @override
  String get preferences_connect_professionals_title => 'Professionnels';

  @override
  String get preferences_connect_pro_subtitle =>
      'Entièrement gratuit, il garantit des données précises pour 500 applications et des millions de consommateurs. Libre-service, compatible avec votre PIM ou vos feuilles de calcul (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Contactez-nous pour commencer';

  @override
  String get preferences_connect_press_title => 'Presse';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Obtenez tout le matériel dont vous avez besoin pour votre rapport';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Contactez-nous pour toute demande de presse ou pour nous faire part de votre rapport.';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Devenez un bénévole actif';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Développement, Communication, Design… tout type de volontariat ou d\'expertise est le bienvenu !';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Découvrez quelques-unes des nombreuses façons dont vous pouvez contribuer';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Développement d\'applications mobiles';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Apprenez à contribuer au développement de logiciels';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Des versions quotidiennes instables, de toutes nouvelles fonctionnalités';

  @override
  String get preferences_contribute_local_community_title =>
      'Développez votre communauté locale';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Aide aux traductions de logiciels, de contenus et d\'analyses d\'ingrédients';

  @override
  String get preferences_contribute_share_subtitle =>
      'Nous avons préparé un petit modèle pour vous aider :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Étapes simples pour accroître la transparence alimentaire dans votre pays';

  @override
  String get preferences_contribute_data_quality_title => 'Qualité des données';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Rejoignez l\'équipe de qualité des données';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Rejoignez notre effort pour garantir que la base de données est complète et exacte';

  @override
  String get preferences_contributions_products_added_title =>
      'Produits ajoutés';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nouveaux produits que j\'ai ajoutés à Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produits que je dois compléter';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Tous les produits incomplets';

  @override
  String get preferences_my_contributions_prices_title => 'Prix';

  @override
  String get preferences_my_contributions_my_prices_title => 'Mes prix';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Mes tarifs, mes épreuves…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produits que vous pouvez aider à compléter';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Aidez-nous à calculer le Nutri-Score et le Green-Score dans votre pays';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Prix auxquels j\'ai contribué';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Étiquettes de prix et reçus';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Prenez des photos de vos reçus et scannez les codes-barres associés';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Prendre des photos des prix dans un magasin';

  @override
  String get preferences_prices_newest_title => 'Nouveaux prix';

  @override
  String get preferences_prices_newest_subtitle =>
      'Derniers prix ajoutés par la communauté Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Contributeurs avec le plus de prix';

  @override
  String get preferences_prices_metrics_title => 'Métriques Open Prices';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Suivez l\'évolution du projet';

  @override
  String get preferences_prices_ways_contribute_title => 'Façons de contribuer';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Confirmez les prix ajoutés par vous-même ou par d\'autres, avec l\'aide de l\'IA';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Ajoutez rapidement de nombreux reçus ou photos d\'étagères à partir de votre pellicule';

  @override
  String get preferences_prices_challenges_title => 'Défis mensuels';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Participez à des quêtes thématiques mensuelles pour collecter des prix';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Récupérez vos données de fidélité';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Apprenez comment demander vos données';

  @override
  String get preferences_page_customize_app_title =>
      'Personnaliser l\'application';

  @override
  String get preferences_page_contribute_project_title =>
      'Contribuer au projet';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Des moyens simples pour aider Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Méthodologies de notation, aide et plus sur le projet';

  @override
  String get product_edit_robotoff_positive_button => 'Accepter la suggestion';

  @override
  String get product_edit_robotoff_negative_button => 'Rejeter la suggestion';

  @override
  String get product_edit_robotoff_show_proof => 'Montrer la preuve';

  @override
  String get product_edit_robotoff_expand_proof => 'Développer la preuve';

  @override
  String get product_page_tab_raw_data => 'Données brutes';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Page $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Page $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count sur $total articles';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count sur $total articles';
  }

  @override
  String item_count(int count) {
    return '$count articles';
  }

  @override
  String item_count_string(String count) {
    return '$count articles';
  }

  @override
  String get prices_no_result => 'Aucune statistique de prix trouvée.';

  @override
  String get prices_error_loading_more_items =>
      'Erreur lors du chargement de plus d\'éléments';

  @override
  String get prices_proof_error =>
      'L\'authentification a échoué, impossible de récupérer les preuves';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count sur $total preuves';
  }

  @override
  String proof_count(int count) {
    return '$count preuves';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count sur $total contributeurs';
  }

  @override
  String contributors_count(int count) {
    return '$count contributeurs';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count sur $total emplacements';
  }

  @override
  String prices_locations_count(int count) {
    return '$count emplacements';
  }

  @override
  String get restart_to_apply_message =>
      'Veuillez redémarrer l\'application pour appliquer les modifications.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Interface graphique';

  @override
  String get preferences_app_settings_media_title => 'Médias';

  @override
  String get preferences_about_app_development_title => 'Développement';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Open Food Facts Labs';

  @override
  String get preferences_root_account_title => 'Compte';

  @override
  String get preferences_contribute_translate_header =>
      'Traduire Open Food Facts dans votre langue';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Inscrivez-vous à la version alpha de l\'application';

  @override
  String get preferences_dev_mode_section_data =>
      'Contributions et données sur les produits';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Ne pas afficher Folksonomie';

  @override
  String get preferences_account_title => 'Compte';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Ajouté le $created';
  }

  @override
  String get location_map_details_title => 'Détails de la localisation';

  @override
  String get location_map_details_name => 'Nom';

  @override
  String get location_map_details_street => 'Rue';

  @override
  String get location_map_details_city => 'Ville';

  @override
  String get location_map_details_postcode => 'Code postal';

  @override
  String get location_map_details_country => 'Pays';

  @override
  String get location_map_details_coordinates => 'Coordonnées';

  @override
  String get location_map_details_osm_id => 'ID OSM';
}
