// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Estonian (`et`).
class AppLocalizationsEt extends AppLocalizations {
  AppLocalizationsEt([String locale = 'et']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Jah';

  @override
  String get add => 'Lisa';

  @override
  String get account_delete_message =>
      'Kas oled kindel, et soovid oma konto kustutada?\nKui on konkreetne põhjus, palun jaga seda allpool.';

  @override
  String get reason => 'Põhjus';

  @override
  String get okay => 'Ok';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'Loo';

  @override
  String get applyButtonText => 'Rakenda';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'Jätka';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'Tagasi üles';

  @override
  String get save => 'Salvesta';

  @override
  String get save_confirmation => 'Kas oled kindel, et soovid salvestada?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Tühista';

  @override
  String get ignore => 'Ignoreeri';

  @override
  String get close => 'Sulge';

  @override
  String get no => 'Ei';

  @override
  String get stop => 'Peata';

  @override
  String get finish => 'Lõpeta';

  @override
  String get calculate => 'Arvuta';

  @override
  String get reset_food_prefs => 'Lähtesta toidueelistused';

  @override
  String get error => 'Midagi läks valesti';

  @override
  String get error_occurred => 'Tekkis viga';

  @override
  String get featureInProgress =>
      'Töötame selle funktsiooni kallal, püsige lainel';

  @override
  String get label_web => 'Kuva veebis';

  @override
  String get learnMore => 'Lisateave';

  @override
  String get unknown => 'Tundmatu';

  @override
  String get match_very_good => 'Väga hea vaste';

  @override
  String get match_good => 'Hea vaste';

  @override
  String get match_poor => 'Kehv vaste';

  @override
  String get match_may_not => 'Ei pruugi sobida';

  @override
  String get match_does_not => 'Ei sobi';

  @override
  String get match_unknown => 'Vaste pole teada';

  @override
  String get match_short_very_good => 'Väga hea vaste';

  @override
  String get match_short_good => 'Hea vaste';

  @override
  String get match_short_poor => 'Kehv vaste';

  @override
  String get match_short_may_not => 'Ei pruugi sobida';

  @override
  String get match_short_does_not => 'Ei sobi';

  @override
  String get match_short_unknown => 'Vaste pole teada';

  @override
  String get licenses => 'Litsentsid';

  @override
  String get looking_for => 'Otsin';

  @override
  String get welcomeToOpenFoodFacts => 'Tere tulemast Open Food Factsi lehele';

  @override
  String get whatIsOff =>
      'Open Food Facts on ülemaailmne mittetulundusühing, mida toetavad kohalikud kogukonnad.';

  @override
  String get productDataUtility =>
      'Vaadake oma eelistustega seotud toiduandmeid.';

  @override
  String get healthCardUtility => 'Vali toidud, mis sulle head on.';

  @override
  String get ecoCardUtility => 'Vali toidud, mis on planeedile head.';

  @override
  String get server_error_open_new_issue =>
      'Server ei vasta! Võite probleemi avada järgmise lingi abil.';

  @override
  String get sign_in_text =>
      'Oma panuse salvestamiseks logige sisse oma Open Food Factsi kontole';

  @override
  String get incorrect_credentials => 'Vale kasutajanimi või salasõna.';

  @override
  String get password_lost_incorrect_credentials =>
      'Seda e-posti aadressi või kasutajanime pole olemas. Palun kontrolli oma sisselogimisandmeid.';

  @override
  String get password_lost_server_unavailable =>
      'Meie serverite töö on hetkel aeglasevõitu ja vabandame selle pärast. Palun proovi hiljem uuesti.';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable => 'Võrk pole kättesaadav';

  @override
  String get login_result_type_server_issue =>
      'Serveri probleem. Palun proovige hiljem uuesti.';

  @override
  String get login_page_username_or_email =>
      'Palun sisesta kasutajanimi või e-posti aadress';

  @override
  String get login_page_password_error_empty => 'Palun sisesta salasõna';

  @override
  String get create_account => 'Loo konto';

  @override
  String get sign_in => 'Logi sisse';

  @override
  String get sign_in_mandatory =>
      'Selle funktsiooni kasutamiseks peate sisse logima.';

  @override
  String get help_improve_country =>
      'Aita oma riigis Open Food Factsi täiustada';

  @override
  String get sign_out => 'Logi välja';

  @override
  String get sign_out_confirmation =>
      'Kas oled kindel, et soovid välja logida?';

  @override
  String get password => 'Salasõna';

  @override
  String get forgot_password => 'Unustasin salasõna';

  @override
  String get forgot_password_question => 'Unustasid parooli?';

  @override
  String get view_profile => 'Vaata profiili';

  @override
  String get reset_password => 'Lähtesta salasõna';

  @override
  String get reset_password_explanation_text =>
      'Unustatud salasõna puhil sisesta oma kasutajanimi või e-posti aadress ning saad juhised salasõna lähtestamiseks. Igaks juhuks ära unusta kontrollida e-kirjade rämpsposti kausta.';

  @override
  String get username_or_email => 'Kasutajanimi või e-posti aadress';

  @override
  String get reset_password_done =>
      'Sinu kasutajakontoga seotud e-posti aadressile on saadetud e-kiri salasõna lähtestamise lingiga. Kui sa kirja kohe ei leia, siis vaata ka e-kirjade rämpsposti kausta';

  @override
  String get send_reset_password_mail => 'Muuda salasõna';

  @override
  String get enter_some_text => 'Palun sisesta natuke teksti';

  @override
  String get sign_up_page_title => 'Liitu';

  @override
  String get sign_up_page_action_button => 'Liitu';

  @override
  String get sign_up_page_action_doing_it => 'Registreerumine…';

  @override
  String get sign_up_page_action_ok => 'Palju õnne! Teie konto on just loodud.';

  @override
  String get sign_up_page_display_name_hint => 'Nimi';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Palun sisesta kuvatav nimi, mida soovid kasutada';

  @override
  String get sign_up_page_email_hint => 'E-posti aadress';

  @override
  String get sign_up_page_email_error_empty => 'E-posti aadress on kohustuslik';

  @override
  String get sign_up_page_email_error_invalid => 'Kehtetu e-posti aadress';

  @override
  String get sign_up_page_username_hint => 'Kasutajanimi: avalikult nähtav';

  @override
  String get sign_up_page_username_error_empty => 'Palun sisesta kasutajanimi';

  @override
  String get sign_up_page_username_error_invalid =>
      'Palun sisesta kehtiv kasutajanimi';

  @override
  String get sign_up_page_username_description =>
      'Kasutajanimi ei tohi sisaldada tühikuid, suurtähti ega erimärke.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Kasutajanimi ei tohi olla pikem, kui $value tähemärki';
  }

  @override
  String get sign_up_page_password_hint => 'Salasõna';

  @override
  String get sign_up_page_password_error_empty => 'Palun sisesta salasõna';

  @override
  String get sign_up_page_password_error_invalid =>
      'Palun sisesta kehtiv salasõna (vähemalt 6 tähemärki)';

  @override
  String get sign_up_page_confirm_password_hint => 'Kinnita salasõna';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Palun korda salasõna';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Salasõnad ei klapi';

  @override
  String get sign_up_page_agree_text => 'Nõustun avatud toidufaktidega';

  @override
  String get sign_up_page_terms_text => 'kasutustingimused ja panus';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Konto loomisel on kasutustingimustega nõustumine kohustuslik, kuid rakenduse kaudu saab siiski anonüümselt panustada.';

  @override
  String get sign_up_page_producer_checkbox => 'Olen toidutootja';

  @override
  String get sign_up_page_producer_hint => 'Tootja või kaubamärk';

  @override
  String get sign_up_page_producer_error_empty =>
      'Palun sisesta tootja või kaubamärgi nimi';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Soovin tellida Open Food Factsi uudiskirja (saate igal ajal tellimuse tühistada)';

  @override
  String get sign_up_page_user_name_already_used =>
      'See kasutajanimi on juba olemas, palun vali mõni teine.';

  @override
  String get sign_up_page_email_already_exists =>
      'juba olemas, logi kontole sisse või proovi teise e-posti aadressiga.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Palun sisestage kehtiv e-posti aadress.';

  @override
  String get sign_up_page_server_busy =>
      'Vabandame sügavalt, meil on teie konto loomisel tehnilisi probleeme. Palun proovige hiljem uuesti.';

  @override
  String get settingsTitle => 'Seaded';

  @override
  String get darkmode => 'Teema';

  @override
  String get darkmode_dark => 'Tume';

  @override
  String get darkmode_light => 'Valgus';

  @override
  String get darkmode_system_default => 'Süsteemi vaikeseade';

  @override
  String get thanks_for_contributing => 'Tänan panuse eest!';

  @override
  String get contributors_label => 'Nad ehitavad rakendust';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Kaastööline: $name';
  }

  @override
  String get contributors_description =>
      'Selle rakenduse kõigi kaastööliste loend';

  @override
  String get support => 'Tugi';

  @override
  String get support_join_slack => 'Küsi abi meie Slacki kanalil';

  @override
  String get support_via_forum => 'Küsi abi meie foorumist';

  @override
  String get support_via_email => 'Saatke meile e-kiri';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Kas saata rakenduste logisid?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Kas soovite oma e-kirja manusena lisada rakenduste logid?';

  @override
  String get termsOfUse => 'Kasutustingimused';

  @override
  String get legalNotices => 'Õiguslikud teated';

  @override
  String get privacy_policy => 'Privaatsuspoliitika';

  @override
  String get about_this_app => 'Selle rakenduse kohta';

  @override
  String get contribute => 'Tee kaastööd';

  @override
  String get contribute_sw_development => 'Tarkvaraarendus';

  @override
  String get contribute_develop_text =>
      'Kõigi Open Food Factsi toodete kood on saadaval GitHubis. Olete teretulnud koodi taaskasutama (see on avatud lähtekoodiga) ja aitama meil seda kõigi jaoks kogu planeedil paremaks muuta.';

  @override
  String get contribute_develop_text_2 =>
      'Küsimuste esitamiseks võite liituda Open Food Factsi Slacki vestlusruumiga.';

  @override
  String get contribute_develop_dev_mode_title => 'Arendajarežiim?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktiveeri DEV-režiim';

  @override
  String get contribute_donate_title => 'Anneta';

  @override
  String get contribute_donate_header => 'Anneta Open Food Factsile';

  @override
  String get contribute_enroll_alpha_warning =>
      'Palun arvestage, et sisemise alfaversiooniga on võimalik andmete täielik kadumine ja rakendus võib igal ajal kasutuskõlbmatuks muutuda!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Tooted, mida saad täiendada';

  @override
  String get contribute_improve_header => 'Täiendamine';

  @override
  String get contribute_improve_text =>
      'Andmebaas on projekti tuum. Selle abistamine on lihtne ja väga kiire. Saate oma telefoni alla laadida mobiilirakenduse ja hakata tooteid lisama või täiustama.\n\nTeisest küljest pakub Open Food Factsi veebisait palju võimalusi panustamiseks: ';

  @override
  String get contribute_translate_header => 'Tõlkimine';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Alusta tõlkimist';

  @override
  String get contribute_translate_text =>
      'Open Food Facts on ülemaailmne projekt, mis hõlmab tooteid enam kui 160 riigist. Open Food Facts on tõlgitud kümnetesse keeltesse ja selle sisu areneb pidevalt.';

  @override
  String get contribute_translate_text_2 =>
      'Tõlked on projekti üks põhiülesandeid';

  @override
  String get contribute_join_skill_pool =>
      'Jaga oma oskusi Open Food Factsi lehel. Liitu oskustepagasiga!';

  @override
  String get contribute_share_header => 'Jaga Open Food Factsi oma sõpradega';

  @override
  String get contribute_share_content =>
      'Tahtsin teile rääkida rakendusest Open Food Facts, mida olen kasutanud ja mis võimaldab teil saada teavet oma toidu tervise- ja keskkonnamõjude kohta personaalsel viisil. See töötab pakendil olevate vöötkoodide skannimise teel. Lõpuks on see tasuta, ei vaja registreerimist ja saate isegi aidata suurendada dešifreeritud toodete arvu. Siin on link selle oma telefoni allalaadimiseks: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Panusta hindadesse, taotledes oma kliendikaartide andmete GDPR-i eksporti';

  @override
  String get tap_to_answer => 'Küsimustele vastamiseks puudutage siin';

  @override
  String get tap_to_answer_hint =>
      'Selle toote kohta küsimustele vastamiseks puudutage siin';

  @override
  String get robotoff_questions_loading_hint =>
      'Palun oodake, kuni selle toote kohta käivaid küsimusi laaditakse';

  @override
  String get saving_answer => 'Vastuse salvestamine';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Oma panuse eest tunnustuse saamiseks logige sisse oma Open Food Factsi kontole';

  @override
  String get question_yes_button_accessibility_value => 'Vasta jaatavalt';

  @override
  String get question_no_button_accessibility_value => 'Vasta eitavalt';

  @override
  String get question_skip_button_accessibility_value =>
      'Jäta see küsimus vahele';

  @override
  String get tap_to_edit_search => 'Puudutage otsingu muutmiseks';

  @override
  String get myPreferences => 'Minu eelistused';

  @override
  String get account_create_message =>
      'Loo konto ja liitu Open Food Factsi kogukonnaga, et aidata kaasa toidualaste teadmiste loomisele üle kogu maailma!';

  @override
  String get join_us => 'Liitu meiega';

  @override
  String get myPreferences_profile_title => 'Teie profiil';

  @override
  String get myPreferences_profile_subtitle =>
      'Halda oma Open Food Factsi kaastöölise kontot.';

  @override
  String get myPreferences_settings_title => 'Rakenduse seaded';

  @override
  String get myPreferences_settings_subtitle => 'Tume režiim, keeled…';

  @override
  String get myPreferences_food_title => 'Toidueelistused';

  @override
  String get myPreferences_food_subtitle =>
      'Vali, milline toidualane teave on sinu jaoks kõige olulisem.';

  @override
  String get myPreferences_food_comment =>
      'Valige, milline toidualane teave on teie jaoks kõige olulisem, et järjestada toitu vastavalt oma eelistustele, näha esmalt teile olulist teavet ja saada ühilduvuse kokkuvõte. Need toidueelistused jäävad teie seadmesse ega ole seotud teie Open Food Factsi kaastöölise kontoga, kui teil see on.';

  @override
  String get confirmResetPreferences => 'Kas lähtestad oma toidueelistused?';

  @override
  String get myPersonalizedRanking => 'Minu isikupärastatud edetabel';

  @override
  String get ranking_tab_all => 'Kõik';

  @override
  String get ranking_subtitle_match_yes => 'Suurepärane vaste sulle';

  @override
  String get ranking_subtitle_match_no => 'Väga halb vaste';

  @override
  String get ranking_subtitle_match_maybe => 'Vaste pole teada';

  @override
  String get refresh_with_new_preferences =>
      'Värskenda nimekirja oma uute eelistustega';

  @override
  String get reloaded_with_new_preferences =>
      'Täiustatud teie uute eelistustega';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Skanneeri';

  @override
  String get history_navbar_label => 'Ajalugu';

  @override
  String get list_navbar_label => 'Loendid';

  @override
  String get category => 'Filtreeri kategooria järgi';

  @override
  String get category_all => 'Kõik';

  @override
  String get category_search => '(kategooria otsing)';

  @override
  String get filter => 'Filtreeri';

  @override
  String get scan => 'Skannimisekraanilt kuvatavad tooted';

  @override
  String get scan_history => 'Skannimise ajalugu';

  @override
  String get search => 'Otsi';

  @override
  String get search_product_help => 'Otsi toodet,\nbrändi või vöötkoodi';

  @override
  String get search_filter => 'Otsingufilter';

  @override
  String get search_history => 'Otsinguajalugu';

  @override
  String get search_store => 'Otsi poodi';

  @override
  String get search_store_help => 'Vihje: lisa linn või riik';

  @override
  String get tap_for_more => 'Lisateabe nägemiseks puudutage…';

  @override
  String get product => 'Toode';

  @override
  String get unknownBrand => 'Tundmatu kaubamärk';

  @override
  String get unknownQuantity => 'Tundmatu kogus';

  @override
  String get unknownProductName => 'Tundmatu tootenimi';

  @override
  String get label_refresh => 'Värskenda';

  @override
  String get label_reload => 'Laadi uuesti';

  @override
  String get image => 'Pilt';

  @override
  String get front_photo => 'Esifoto';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (see pilt võib olla aegunud)';
  }

  @override
  String get outdated_image_short_label => 'võib olla aegunud';

  @override
  String get ingredients => 'Koostisosad';

  @override
  String get ingredients_editing_instructions =>
      'Säilita algne järjekord. Märki protsent, kui see on täpsustatud. Eralda koma või sidekriipsuga ja kasuta koostisosa koostisosade puhul sulgudes.';

  @override
  String get ingredients_editing_error =>
      'Koostisosade salvestamine ebaõnnestus.';

  @override
  String get ingredients_editing_image_error =>
      'Uue koostisosade pildi hankimine ebaõnnestus.';

  @override
  String get ingredients_editing_title => 'Koostisosade muutmine';

  @override
  String get ingredients_photo => 'Koostisosade foto';

  @override
  String get packaging_editing_instructions =>
      'Loetlege kõik pakendi osad koma või reavahega eraldatult, märkides ära nende koguse (nt 1 või 6), tüübi (nt pudel, karp, purk), materjali (nt plastik, metall, alumiinium) ja võimaluse korral suuruse (nt 33cl) ning taaskasutusjuhised.\nNäide: 1 klaaspudel taaskasutamiseks, 1 plastkork äraviskamiseks';

  @override
  String get packaging_editing_error => 'Pakendi salvestamine ebaõnnestus.';

  @override
  String get packaging_editing_image_error =>
      'Uue pakendipildi hankimine ebaõnnestus.';

  @override
  String get packaging_editing_title => 'Redigeeri pakendit';

  @override
  String get nutrition => 'Toitained';

  @override
  String get nutrition_facts_photo => 'Toitainefaktide foto';

  @override
  String get nutrition_facts_editing_title => 'Toitumisalase teabe muutmine';

  @override
  String get packaging_information => 'Taaskasutusjuhised';

  @override
  String get packaging_information_photo => 'Foto ringlussevõtu juhistest';

  @override
  String get missing_product => 'Oled leidnud uue toote!';

  @override
  String get add_product_take_photos =>
      'Selle toote lisamiseks Open Food Factsi tehke pakendist fotod.';

  @override
  String get add_product_take_photos_descriptive =>
      'Palun tehke enne mõned fotod. Toote saab alati hiljem valmis teha.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'Uus toode';

  @override
  String get new_product_found_title => 'Uus toode leitud!';

  @override
  String get new_product_found_text =>
      'Meie koostöös loodud andmebaas sisaldab üle **3 miljoni toote**, aga seda vöötkoodi pole olemas: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'Kas lahkuda sellelt lehelt?';

  @override
  String get new_product_leave_message =>
      'Paistab, et sa pole midagi sisestanud. Kas sa tõesti tahad sellelt lehelt lahkuda?';

  @override
  String get new_product_dialog_description =>
      'Palun tehke pakendist fotod, et lisada see toode meie ühisesse andmebaasi.';

  @override
  String get new_product_dialog_illustration_description =>
      'Illustratsioon tundmatu Nutri-Score\'i ja Green Score\'iga';

  @override
  String get front_packaging_photo_button_label => 'Pakendi esikülje foto';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Kinnitage esikülje pakendi foto üleslaadimine';

  @override
  String get confirm_button_label => 'Kinnita';

  @override
  String get send_image_button_label => 'Saada pilt';

  @override
  String get crop_page_action_saving => 'Pildi salvestamine…';

  @override
  String get crop_page_action_cropping => 'Pildi kärpimine…';

  @override
  String get crop_page_action_local => 'Kohaliku versiooni salvestamine…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ups… su fotoga on midagi valesti!';

  @override
  String get crop_page_action_local_failed_message =>
      'Me ei saa pilti enne meie serverisse saatmist lokaalselt töödelda. Palun proovige hiljem uuesti või võtke meiega ühendust, kui probleem püsib.';

  @override
  String get crop_page_action_retake => 'Tehke foto uuesti';

  @override
  String get crop_page_too_small_image_title => 'Pilt on liiga väike!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Pildi üleslaadimise minimaalne pikslite suurus on ${expectedMinWidth}x$expectedMinHeight. Praegune pilt on ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Serverikõne ettevalmistamine…';

  @override
  String get front_packaging_photo_title => 'Esikülje pakendi foto';

  @override
  String get ingredients_photo_title => 'Koostisosade foto';

  @override
  String get nutritional_facts_photo_title => 'Toitumisalane teave Foto';

  @override
  String get recycling_photo_title => 'Taaskasutusjuhised Foto';

  @override
  String get take_photo_title => 'Tehke foto';

  @override
  String get take_more_photo_title => 'Take more photos';

  @override
  String get front_photo_uploaded => 'Esikülgne foto üles laaditud';

  @override
  String get ingredients_photo_button_label => 'Koostisosade foto';

  @override
  String get ingredients_photo_uploaded => 'Koostisosade foto üles laaditud';

  @override
  String get nutrition_cache_loading_error =>
      'Toitainete laadimine vahemälust nurjus';

  @override
  String get nutritional_facts_photo_button_label => 'Toitainefaktide foto';

  @override
  String get nutritional_facts_input_button_label =>
      'Täida toitumisalane teave';

  @override
  String get nutritional_facts_added => 'Toitumisalane teave on lisatud';

  @override
  String get categories_added => 'Kategooriad lisatud';

  @override
  String get new_product_title_nutriscore => 'Arvuta Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Aidake meid, täites vähemalt ühe kategooria ja toiteväärtused';

  @override
  String get new_product_title_environmental_score => 'Arvuta roheline skoor';

  @override
  String get new_product_subtitle_environmental_score =>
      'Saa see, täites vähemalt ühe kategooria';

  @override
  String get new_product_additional_environmental_score =>
      'Muutke rohelise skoori arvutamine päritolu, pakendi ja muu abil täpsemaks';

  @override
  String get new_product_title_nova =>
      'Arvutage toiduainete töötlemise tase (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Hankige see, täites toidukategooria ja koostisosad';

  @override
  String get new_product_desc_nova_unknown =>
      'Toiduainete töötlemise tase teadmata';

  @override
  String get new_product_title_pictures => 'Uus toode';

  @override
  String get new_product_title_pictures_details =>
      'Palun tehke järgmised fotod ja Open Food Factsi mootor saab ülejäänu eest hoolitseda!';

  @override
  String get new_product_title_misc => 'Ja mõned põhiandmed…';

  @override
  String new_product_done_msg(String username) {
    return '$username, suur tänu kaastöö eest!';
  }

  @override
  String get new_product_done_msg_no_user => 'Tänan teid panuse eest!';

  @override
  String get new_product_done_button_label => 'Avastage valmistoode';

  @override
  String get hey_incomplete_product_message =>
      'Puuduta, et vastata KOHE 3 küsimusele ja arvutada välja Nutri-Score, Green Score ja Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Puuduta kohe, et vastata kahele küsimusele, mis aitavad seda kosmeetikatoodet analüüsida!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Puuduta kohe, et vastata 3 küsimusele, mis aitavad seda lemmikloomatoitu analüüsida!';

  @override
  String get hey_incomplete_product_message_product =>
      'Puuduta kohe, et aidata seda toodet komplekteerida!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Toitumisalase teabe foto üles laaditud';

  @override
  String get recycling_photo_button_label => 'Foto ringlussevõtt';

  @override
  String get recycling_photo_uploaded => 'Taaskasutuse foto üles laaditud';

  @override
  String get take_more_photo_button_label => 'Take more photos';

  @override
  String get other_photo_uploaded => 'Muu foto üles laaditud';

  @override
  String get retake_photo_button_label => 'Võta uuesti';

  @override
  String get selecting_photo => 'Foto valimine';

  @override
  String get uploading_image => 'Foto üleslaadimine serverisse';

  @override
  String get uploading_image_type_front =>
      'Esikülje pildi üleslaadimine Open Food Factsi';

  @override
  String get uploading_image_type_ingredients =>
      'Koostisosade pildi üleslaadimine Open Food Factsi';

  @override
  String get uploading_image_type_nutrition =>
      'Toitumisalase pildi üleslaadimine Open Food Factsi';

  @override
  String get uploading_image_type_packaging =>
      'Pakendipildi üleslaadimine Open Food Factsi';

  @override
  String get uploading_image_type_other =>
      'Teise pildi üleslaadimine Open Food Factsi';

  @override
  String get uploading_image_type_generic =>
      'Pildi üleslaadimine Open Food Factsi';

  @override
  String get score_add_missing_ingredients => 'Lisage puuduvad koostisosad';

  @override
  String get score_add_missing_packaging_image => 'Lisa puuduv pakendipilt';

  @override
  String get score_add_missing_nutrition_facts =>
      'Lisage puuduvad toitumisalased andmed';

  @override
  String get score_add_missing_product_traces => 'Lisa puuduvad tootejäljed';

  @override
  String get score_add_missing_product_category => 'Valige kategooria';

  @override
  String get score_add_missing_precise_product_category =>
      'Valige täpsem kategooria';

  @override
  String get score_add_missing_product_countries =>
      'Lisage puuduvad tooteriigid';

  @override
  String get score_add_missing_product_emb =>
      'Lisage puuduvad toote jälgitavuskoodid';

  @override
  String get score_add_missing_product_labels => 'Lisage puuduvad tootesildid';

  @override
  String get score_add_missing_product_origins =>
      'Lisage puuduvad toote päritolukohad';

  @override
  String get score_add_missing_product_stores => 'Lisa puuduvad tootepoed';

  @override
  String get score_add_missing_product_brands => 'Lisage puuduvad tootebrändid';

  @override
  String get score_update_nutrition_facts => 'Värskenda toitumisalast teavet';

  @override
  String get nutrition_page_title => 'Toitumisalane teave';

  @override
  String get nutrition_page_nutritional_info_title => 'Toitumisalane teave';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Tootel märgitud väärtused:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Jah';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Ei';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Ava foto';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Head tavad: toitumisalane teave';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Mõnikord ei ole toitumisalane teave **pakendil** ega tootega kaasasolevas dokumendis märgitud. Sellisel ja ainult sellisel juhul saate väärtuseks määrata **EI**.';

  @override
  String get nutrition_page_serving_type_label => 'Toiteväärtused:';

  @override
  String get nutrition_page_per_100g => '100 g kohta';

  @override
  String get nutrition_page_per_100g_100ml => '100 g/ml kohta';

  @override
  String get nutrition_page_per_serving => 'portsjoni kohta';

  @override
  String get nutrition_page_add_nutrient => 'Lisa toitaine';

  @override
  String get nutrition_page_serving_size => 'Portsjoni suurus';

  @override
  String get nutrition_page_serving_size_hint =>
      'Sisesta portsjoni suurus (nt: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Head tavad: portsjoni suurus';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'See väärtus aitab **iga toitaine proportsionaalset osakaalu portsjoni suuruse kohta arvutada**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Lubatud ühikud** on: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫名, , 公升';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** või **60 G** (eelista esimest)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** või **1 l**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Sobimatu ühik';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 g';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Sobimatud ühikud';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **kommi** ja 2 **küpsist**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Puuduv üksus';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Kehtetu number';

  @override
  String get nutrition_page_update_running => 'Toote uuendamine serveris…';

  @override
  String get nutrition_page_update_done => 'Toode on uuendatud!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Kasutage toote kogust portsjoni suurusena';

  @override
  String get nutrition_page_photo_error => 'Fotot ei õnnestunud laadida';

  @override
  String get more_photos => 'Veel huvitavaid fotosid';

  @override
  String get view_more_photo_button =>
      'Kuva kõik selle toote olemasolevad fotod';

  @override
  String get no_product_found => 'Toodet ei leitud';

  @override
  String get no_location_found => 'Asukohta ei leitud';

  @override
  String get not_found => 'ei leitud:';

  @override
  String get refreshing_product => 'Värskendav toode';

  @override
  String get product_refreshed => 'Toodet värskendati';

  @override
  String product_image_accessibility_label(String date) {
    return 'Pilt on tehtud $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Pilt on tehtud $date. See pilt võib olla aegunud.';
  }

  @override
  String get product_image_outdated => 'See pilt võib olla aegunud';

  @override
  String get product_image_outdated_explanations_title =>
      'See pilt võib olla aegunud';

  @override
  String get product_image_outdated_explanations_content =>
      'See pilt on tehtud rohkem kui aasta tagasi.\n**Palun kontrollige, kas see on ikka ajakohane**.\n\nSee on **lihtsalt hoiatus**. Kui sisu on ikka sama, võite seda teadet ignoreerida.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Asenda foto ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Lisa foto ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Tehke foto';

  @override
  String get product_image_action_from_gallery => 'Vali oma telefoni galeriist';

  @override
  String get product_image_action_choose_existing_photo =>
      'Vali tootepiltide hulgast';

  @override
  String get product_image_details_label => 'Teave foto kohta';

  @override
  String get product_image_details_from_producer => 'Produtsendilt';

  @override
  String get product_image_details_contributor => 'Panustaja';

  @override
  String get product_image_details_contributor_producer =>
      'Kaastööline (produtsent)';

  @override
  String get product_image_details_date => 'Kuupäev';

  @override
  String get product_image_details_date_unknown => 'Tundmatu';

  @override
  String get homepage_main_card_logo_description =>
      'Tere tulemast Open Food Factsi lehele';

  @override
  String get homepage_main_card_subheading =>
      '**Skaneeri** vöötkoodi või\n**otsi** toodet';

  @override
  String get homepage_main_card_search_field_hint => 'Otsi toodet';

  @override
  String get homepage_main_card_search_field_tooltip => 'Alusta otsingut';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Viimased uudised: $news_title';
  }

  @override
  String get tagline_app_review => 'Kas sulle meeldib see rakendus?';

  @override
  String get tagline_app_review_button_positive => 'Mulle meeldib see väga! 😍';

  @override
  String get tagline_app_review_button_negative => 'Mitte päris…';

  @override
  String get tagline_app_review_button_later => 'Küsi hiljem';

  @override
  String get tagline_feed_news_button => 'Tea rohkem';

  @override
  String get app_review_negative_modal_title =>
      'Sulle ei meeldi meie rakendus?';

  @override
  String get app_review_negative_modal_text =>
      'Kas te saaksite paar sekundit öelda, miks?';

  @override
  String get app_review_negative_modal_positive_button => 'Jah, absoluutselt!';

  @override
  String get app_review_negative_modal_negative_button => 'Ei';

  @override
  String get could_not_refresh => 'Toodet ei õnnestunud värskendada';

  @override
  String get product_internet_error_modal_title => 'Tekkis viga!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Selle toote kohta teabe hankimine ebaõnnestus võrguvea tõttu. Palun kontrollige oma internetiühendust ja proovige uuesti.\n\nSisemine viga:\n$error';
  }

  @override
  String get product_tags_title => 'Toote omadused';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Pole omadusi';

  @override
  String get product_tags_explanation =>
      'Tootele omaduste (võti/väärtus) lisamisega aitad andmeid täiendada.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Lisa omadused';

  @override
  String get add_edit_tags => 'Atribuutide lisamine või muutmine';

  @override
  String get edit_tag => 'Muuda atribuuti';

  @override
  String get remove_tag => 'Eemalda vara';

  @override
  String get tag_key => 'Kinnisvara';

  @override
  String get tag_keys => 'Omadused';

  @override
  String get tag_key_uneditable => 'Omadus (muudetav)';

  @override
  String get tag_key_input_hint => 'Sisestage omadus';

  @override
  String get tag_value => 'Väärtus';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Sisestage väärtus';

  @override
  String get tag_key_item => 'Kinnisvara:';

  @override
  String get tag_value_item => 'Väärtus:';

  @override
  String get tag_key_explanations =>
      'Võti peab olema väiketähtedega ja ilma tühikuteta.';

  @override
  String tag_key_already_exists(String property) {
    return 'Silt omadusega $property on juba olemas!';
  }

  @override
  String get product_internet_error =>
      'Selle toote kohta teabe hankimine on võrguvea tõttu võimatu.';

  @override
  String get cached_results_from => 'Näita tulemusi:';

  @override
  String get product_search_same_category => 'Leia alternatiive';

  @override
  String get product_search_same_category_short => 'Võrdle';

  @override
  String get product_search_same_category_error =>
      'Seda funktsiooni saab kasutada ainult kategooriaga toodete puhul.\n\nKategooria lisamiseks muutke toodet.';

  @override
  String get product_improvement_add_category =>
      'Nutri-Score\'i arvutamiseks lisa kategooria.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Nutri-Score\'i arvutamiseks lisa toitumisalane teave.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Nutri-Score\'i arvutamiseks lisa toitumisalane teave ja kategooria.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Selle toote Nutri-Score\'i ei saa arvutada, mis võib olla tingitud näiteks mittestandardsest kategooriast. Kui seda peetakse veaks, võtke meiega ühendust.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Toitumisalane pilt on aegunud: palun värskenda seda.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Roheline hinne arvestab koostisosade päritolu. Palun tehke koostisosade loetelust ja/või geograafilisest väitest foto või muutke toodet, et neid saaks arvesse võtta.';

  @override
  String get country_chooser_label => 'Palun vali riik';

  @override
  String get currency_chooser_label => 'Palun valige valuuta';

  @override
  String get country_change_message => 'Sa just vahetasid riiki.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Kas soovite valuutat muuta $previousCurrency väärtuseks $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Palun vali riik:';

  @override
  String get country_chooser_label_from_settings => 'Sinu riik';

  @override
  String get country_selection_explanation =>
      'Mõned keskkonnaomadused on asukohapõhised';

  @override
  String get product_removed_comparison => 'Toode eemaldati võrdlusest';

  @override
  String get native_app_settings => 'Natiivse rakenduse seaded';

  @override
  String get native_app_description => 'Avatud toidufaktide süsteemiseaded';

  @override
  String get product_removed_history => 'Toode eemaldati ajaloost';

  @override
  String get product_removed_list => 'Toode eemaldati nimekirjast';

  @override
  String get product_could_not_remove => 'Toodet ei saanud eemaldada';

  @override
  String get no_prodcut_in_list => 'Selles nimekirjas pole ühtegi toodet';

  @override
  String get no_product_in_section => 'Selles jaotises pole ühtegi toodet';

  @override
  String get recently_seen_products => 'Kõik vaadatud tooted';

  @override
  String get clear => 'Selge';

  @override
  String get clear_long => 'Tühjenda nimekiri';

  @override
  String get really_clear => 'Kas sa tõesti tahad selle nimekirja kustutada?';

  @override
  String pct_match(Object percent) {
    return '$percent% vaste';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count päeva tagasi',
      one: 'üks päev tagasi',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tundi tagasi',
      one: 'üks tund tagasi',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minutit tagasi',
      one: 'üks minut tagasi',
      zero: 'vähem kui minut tagasi',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kuud tagasi',
      one: 'üks kuu tagasi',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count nädalat tagasi',
      one: 'nädal tagasi',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Võrdle $count Tooteid',
      one: 'Võrdle ühte toodet',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count valitud tooted',
      one: 'Üks valitud toode',
      zero: 'Toodet pole valitud',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Võrdle valitud tooteid';

  @override
  String get delete_products_mode => 'Kustuta valitud tooted';

  @override
  String get select_all_products_mode => 'Vali kõik tooted';

  @override
  String get select_none_products_mode => 'Vali mitte ühtegi';

  @override
  String get compare_products_appbar_title => 'Võrdle tooteid';

  @override
  String get compare_products_appbar_subtitle =>
      'Palun vali vähemalt kaks toodet';

  @override
  String get retry_button_label => 'Proovi uuesti';

  @override
  String get connect_with_us => 'Võtke meiega ühendust';

  @override
  String get tiktok => 'Jälgi meid TikTokis';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Jälgi meid Instagramis';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Jälgi meid X-is (endine Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Jälgi meid Mastodonis';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Jälgi meid BlueSkys';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blogi';

  @override
  String get faq => 'KKK';

  @override
  String get discover => 'Avasta';

  @override
  String get how_to_contribute => 'Kuidas saad osaleda';

  @override
  String get hint_knowledge_panel_message =>
      'Lisateabe saamiseks võite puudutada kaardi mis tahes osa. Proovige kohe!';

  @override
  String get permissions_page_title => 'Kaamera ligipääs';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'Kui te meelt muudate, saab selle valiku igal ajal seadetest lubada ja keelata.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Väljalase: $release)\nMudel: $model\nToode: $product\nSeade: $device\nBränd:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nMudel: $model\nLokaliseeritud mudel: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nRakenduse versioon:$appVersion\nRakenduse ehitusnumber:$appBuildNumber\nRakenduse paketi nimi:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'Keelduma';

  @override
  String get ask_me_later_button_label => 'Hiljem';

  @override
  String get are_you_sure => 'Oled sa kindel?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Mine edasi $sourceName-l';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Tere tulemast!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Rakendus, mis aitab sul valida toitu, mis on hea nii sulle kui ka planeedile!';

  @override
  String get onboarding_continue_button => 'Jätka';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Esimese näidisprodukti laadimine';

  @override
  String get onboarding_welcome_warning =>
      'Vabandust, see on meie näidistoode, sa ei saa seda muuta :)';

  @override
  String get product_list_your_ranking => 'Teie edetabel';

  @override
  String get product_list_empty_icon_desc => 'Ajalugu pole saadaval';

  @override
  String get product_list_empty_title => 'Alusta skannimist';

  @override
  String get product_list_empty_message =>
      'Skannitud tooted kuvatakse siin ja saate nende kohta üksikasjalikku teavet vaadata.';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'tooted',
      one: 'toode',
      zero: 'toode',
    );
    return 'Värskendav $_temp0 sinu ajaloos';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tooted',
      one: 'Toode',
      zero: 'Toode',
    );
    return '$_temp0 värskendamine lõpetatud';
  }

  @override
  String get product_list_compare_side_by_side => 'Võrdle kõrvuti';

  @override
  String get loading_dialog_default_title => 'Andmete allalaadimine';

  @override
  String get loading_dialog_default_error_message =>
      'Andmeid ei õnnestunud alla laadida';

  @override
  String get account_delete => 'Kustuta konto';

  @override
  String get account_delete_title => 'Kustuta minu kasutajakonto';

  @override
  String get user_profile => 'Konto';

  @override
  String get user_profile_title_guest => 'Tere tulemast!';

  @override
  String get user_profile_subtitle_guest =>
      'Logi sisse või registreeru, et liituda Open Food Factsi kogukonnaga';

  @override
  String user_profile_title_id_email(String email) {
    return 'Avatud toidufaktide sisselogimine: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Tere tulemast $id!';
  }

  @override
  String get email_subject_account_deletion => 'Kustuta konto';

  @override
  String email_body_account_deletion(String userId) {
    return 'Tere, palun kustutage minu Open Food Factsi konto: $userId';
  }

  @override
  String get settings_app_app => 'Taotlus';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'Kaamera';

  @override
  String get settings_app_products => 'Tooted';

  @override
  String get settings_app_miscellaneous => 'Muu';

  @override
  String get camera_play_sound_title => 'Esita skaneerimisel heli';

  @override
  String get camera_play_sound_subtitle =>
      'Piiksub iga eduka skannimise korral';

  @override
  String get camera_window_accessibility_label =>
      'Skannige oma kaameraga vöötkoodi';

  @override
  String get app_haptic_feedback_title => 'Vibratsioon ja haptika';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibratsioon pärast teatud toimingute sooritamist (triipkoodi dekodeerimine, toote eemaldamine…).';

  @override
  String get crash_reporting_toggle_title => 'Krahhidest teavitamine';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Kui see on lubatud, edastatakse krahhiaruanded automaatselt Open Food Factsi veajälgimissüsteemi, et vigu saaks parandada ja seeläbi rakendust täiustada.';

  @override
  String get send_anonymous_data_toggle_title => 'Saada anonüümseid andmeid';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Redigeeri fotot';

  @override
  String get permission_photo_error => 'Viga';

  @override
  String get permission_photo_denied_title =>
      'Luba kaameral vöötkoodide skannimine';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Parema kogemuse saamiseks lubage $appName -l oma kaamerale ligi pääseda. Saate otse triipkoode skannida.';
  }

  @override
  String get permission_photo_denied_button => 'Luba';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Luba keelatud';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Kuna olete varem kaamera kasutamise loa keelanud, peate selle käsitsi seadetest lubama.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Ava seaded';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Tühista';

  @override
  String get permission_photo_none_found => 'Kaamerat ei tuvastatud';

  @override
  String get permission_photo_denied => 'Kaamerale ligipääsu pole antud';

  @override
  String get show_product_pictures => 'Näita tootepilte';

  @override
  String get edit_product_label => 'Toote muutmine';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Muudatuste üleslaadimine…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Teie muudatusi **saadetakse taustal** (või vea korral hiljem).\nSaate jätkata teiste tooteväljade muutmist.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Teie muudatusi **saadetakse taustal** (või vea korral hiljem).';

  @override
  String get edit_product_label_short => 'Muuda';

  @override
  String edit_product_form_item_help(String value) {
    return 'Kuidas sisestada \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Palun sisestage mittetühi väärtus!';

  @override
  String get edit_product_form_item_error_existing =>
      'See väärtus on juba olemas!';

  @override
  String get edit_product_form_item_add_action_brand => 'Lisa uus bränd';

  @override
  String get edit_product_form_item_add_action_label => 'Lisa uus silt';

  @override
  String get edit_product_form_item_add_action_store => 'Lisa uus pood';

  @override
  String get edit_product_form_item_add_action_origin => 'Lisa uus lähtepunkt';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Lisa uus jälgitavuskood';

  @override
  String get edit_product_form_item_add_action_country => 'Lisa uus riik';

  @override
  String get edit_product_form_item_add_action_category =>
      'Lisa uus kategooria';

  @override
  String get edit_product_form_item_add_action_trace => 'Lisa uus jälg';

  @override
  String get edit_product_form_item_add_suggestion => 'Lisa soovitus';

  @override
  String get edit_product_form_item_deny_suggestion => 'Keeldu soovitusest';

  @override
  String get edit_product_form_item_details_title => 'Põhiandmed';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Toote nimi, kaubamärk, kogus';

  @override
  String get edit_product_form_item_other_details_title => 'Lisateave';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Veebileht…';

  @override
  String get edit_product_form_item_photos_title => 'Fotod';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Fotode lisamine või värskendamine';

  @override
  String get edit_product_form_item_labels_title => 'Sildid ja sertifikaadid';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Keskkonna- ja kvaliteedimärgised…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Sisestage silt (nt: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Head tavad: Sildid';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Toote mis tahes omadus, **mis on faktiline** ja erineb teistest väljadest.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Valmistatud Belgias, toodetud Bretagne\'is…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Kiudainerikas, rauaallikas…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Aus kaubandus, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Kauplused';

  @override
  String get edit_product_form_item_stores_hint => 'Sisestage poe nimi';

  @override
  String get edit_product_form_item_stores_type => 'pood';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Head tavad: Kauplused';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Sisesta pood, kust sa toote ostsid.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Päritolu';

  @override
  String get edit_product_form_item_origins_hint =>
      'Sisestage päritoluriik (nt: Saksamaa)';

  @override
  String get edit_product_form_item_origins_type => 'riik';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Head tavad: Päritolu';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Lisa **pakendil olevad päritolumärgised**.\nSa ei pea muretsema koostisosade loetelus otse märgitud päritolu pärast.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Argentinast pärit veiseliha';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soja ei pärine Euroopa Liidust';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Sisesta riik (nt: Eesti)';

  @override
  String get edit_product_form_item_countries_type => 'riik';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Head tavad: Riigid';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Riigid, kus toode on laialdaselt saadaval** (välja arvatud välismaistele toodetele spetsialiseerunud kauplused).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Jälgitavuskoodid';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Sisestage kood (nt: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'jälgitavuskood';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Head tavad: Jälgitavuskoodid';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Selles jaotises saate sisestada **pakendimärkide**, **identifitseerimismärkide** või **tervisemärkide** koode.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Jälgitavuskoodide näited';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EÜ koodid**, mida Euroopa Ühenduses kasutatakse toidutootjate või -pakendajate identifitseerimiseks:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: Prantsusmaa** riigikood\n**72.264.002**: geograafilised andmed\n**CE**: Euroopa Ühendus';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      'Prantsusmaal kasutatavad **EMB-koodid**:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Traces';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'Sisesta jälgi (nt: sojaoad)';

  @override
  String get edit_product_form_item_categories_title => 'Kategooriad';

  @override
  String get edit_product_form_item_categories_hint => 'kategooria';

  @override
  String get edit_product_form_item_categories_type =>
      'Sisesta kategooria (nt: apelsinimahl)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Head tavad: Kategooriad';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Märkige **ainult kõige täpsem kategooria**.\nÜlemkategooriad lisatakse automaatselt.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Puudub kategooria?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Kui kategooria **automaatselt täidetavas valikus pole saadaval**, võite selle ikkagi lisada.\nSee aitab meil teie riigis Open Food Factsi täiustada.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardiinid oliiviõlis';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Apelsinimahl kontsentraadist';

  @override
  String get edit_product_form_item_exit_title => 'Kas väljuda salvestamata?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Kas soovite enne sellelt lehelt lahkumist oma muudatused salvestada?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Salvesta muudatused';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Muudatuste tühistamine';

  @override
  String get edit_product_form_item_ingredients_title => 'Koostisosad';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Suumige sisse ja välja ekraani näpistamise teel';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Suumi fotot sisse ja välja';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Fotot saab suurendada või vähendada **Näpistamise abil suumimise žesti** abil.';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Lisa';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Palun sisesta esmalt tekst';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Eemalda';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Salvesta oma muudatus';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Tühista oma muudatus';

  @override
  String get edit_product_form_item_packaging_title =>
      'Foto ringlussevõtu juhistest';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Toitumisalane teave';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Toitumisalane teave, alkoholisisaldus…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Head tavad: Toitumisalane teave';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Toiteväärtused';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Esmalt valige, kas **väärtused on esitatud**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Toitumisalane teave';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Seejärel sisesta toiteväärtused **nagu pakendil näidatud**. Kui väärtust pole, võite klõpsata ikoonil „Silma“.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Puuduv väli?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Kui kirje puudub, saate selle lisamiseks **klõpsata plussmärgi ikoonil** (nt: D-vitamiin, magneesium…).';

  @override
  String get edit_product_form_save => 'Muuda';

  @override
  String get edit_product_ingredients_photo_title => 'Koostisosade foto';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Pakendi foto';

  @override
  String get edit_product_packaging_list_title => 'Pakendite nimekiri';

  @override
  String get no_data_available => 'Andmed pole saadaval';

  @override
  String get product_field_website_title => 'Veebisait';

  @override
  String get origins_editing_title => 'Redigeeri päritolukohti';

  @override
  String get completed_basic_details_btn_text => 'Täielikud põhiandmed';

  @override
  String get not_implemented_snackbar_text => 'Pole veel rakendatud';

  @override
  String get category_picker_page_appbar_text => 'Kategooriad';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Ekstraheeri koostisosad fotolt';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Koostisosade\neraldamine fotolt';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Foto laadimine…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Miks ma seda teadet näen?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Funktsiooni „Koostisosade ekstraheerimine” kasutamiseks tuleb esmalt foto üles laadida.\n\nPalun oota paar sekundit või sisesta need käsitsi.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Värskenda fotot';

  @override
  String get edit_packaging_extract_btn_text => 'Eemalda fotolt pakend\n';

  @override
  String get edit_packaging_extract_btn_text_short => 'Ekstrakti pakend';

  @override
  String get edit_packaging_extracting_btn_text => 'Pakendi eraldamine fotolt';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Foto laadimine…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Miks ma seda teadet näen?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Funktsiooni „Paketi väljavõtmine” kasutamiseks tuleb foto kõigepealt üles laadida.\n\nPalun oota paar sekundit või sisesta need käsitsi.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Värskenda fotot';

  @override
  String get edit_ocr_extract_failed =>
      'Pildil oleva teksti tuvastamine ebaõnnestus.';

  @override
  String get edit_ocr_extract_disabled_title => 'Pilti pole!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Teksti ekstraheerimise funktsiooni kasutamiseks peate kõigepealt foto tegema.';

  @override
  String get user_list_dialog_new_title => 'Uus toodete nimekiri';

  @override
  String get user_list_dialog_rename_title => 'Nimeta loend ümber';

  @override
  String get user_list_subtitle_product => 'Loendid';

  @override
  String get user_list_title => 'Sinu loendid';

  @override
  String get user_list_add_product => 'Lisa toode oma nimekirjadesse';

  @override
  String get user_list_button_new => 'Loo uus nimekiri';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Lisa loendisse';

  @override
  String get added_to_list_msg => 'Lisatud nimekirja';

  @override
  String get user_list_popup_clear => 'Tühjenda oma ajalugu';

  @override
  String get user_list_popup_rename => 'Nimeta ümber';

  @override
  String get user_list_name_hint => 'Minu nimekiri';

  @override
  String get user_list_name_error_empty => 'Nimi on kohustuslik';

  @override
  String get user_list_name_error_already => 'See nimi on juba kasutusel';

  @override
  String get user_list_name_error_same => 'See on sama nimi';

  @override
  String get user_list_name_input_hint => 'Loendi nimi';

  @override
  String get try_again => 'Proovi uuesti';

  @override
  String get there_was_an_error => 'Tekkis viga';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Kategooriat ${items}ei leitud';
  }

  @override
  String get camera_toggle_camera => 'Vaheta tagumise ja esikaamera vahel';

  @override
  String get camera_toggle_flash => 'Lülitage kaamera välk sisse või välja';

  @override
  String get camera_enable_flash => 'Luba välk';

  @override
  String get camera_disable_flash => 'Keela välk';

  @override
  String get camera_flash_error_dialog_title => 'Tekkis viga!';

  @override
  String get camera_flash_error_dialog_message =>
      'Välgu oleku muutmisel ilmnes viga. Veenduge, et teie nutitelefonis poleks taskulamp juba lubatud.';

  @override
  String get category_picker_no_category_found_button => 'Tagasi';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Klõpsake brauseris või rakenduses (kui see on installitud) avamiseks';

  @override
  String get dev_preferences_screen_title => 'Arendajarežiim';

  @override
  String get dev_preferences_screen_subtitle =>
      'Juurdepääs eksperimentaalsetele funktsioonidele ja arendustööriistadele';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Taaskäivitage sisseelamine';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Seejärel peate rakenduse uuesti nägemiseks taaskäivitama.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Vaheta openfoodfacts.org (PROD) ja testkeskkonna vahel';

  @override
  String get dev_preferences_test_environment_title =>
      'Testikeskkonna parameetrid';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Praeguse testkeskkonna baas-URL: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Testikeskkonna host';

  @override
  String get dev_preferences_ml_kit_title => 'Kasutage ML-komplekti';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'siis peate selle rakenduse taaskäivitama';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Lisanupp tootelehel';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Koostisosade muutmine teadmiste paneeli nupu abil';

  @override
  String get dev_preferences_export_history_title => 'Ekspordi ajalugu';

  @override
  String get dev_preferences_export_history_progress_error => 'erand';

  @override
  String get dev_preferences_export_history_progress_found => 'toode leitud';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'toodet EI leitud';

  @override
  String get dev_preferences_export_history_dialog_title => 'Ekspordi ajalugu';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Tühista';

  @override
  String get dev_preferences_migration_title =>
      'Andmete migreerimine versioonist V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Staatus: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'edu või uus install';

  @override
  String get dev_preferences_migration_status_success => 'edu';

  @override
  String get dev_preferences_migration_status_error => 'viga';

  @override
  String get dev_preferences_migration_status_in_progress => 'pooleli';

  @override
  String get dev_preferences_migration_status_required =>
      'nõutav (klõpsa alustamiseks)';

  @override
  String get dev_preferences_migration_status_not_started => 'tundmatu';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Tühjendab ajaloo ja lisab sinna 3 toodet';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Kohandatud URL uudiste jaoks';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'JSON-faili URL:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Pole määratud';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Viimane värskendus: $date';
  }

  @override
  String get product_type_label_food => 'Toit';

  @override
  String get product_type_label_beauty => 'Isiklik hooldus';

  @override
  String get product_type_label_pet_food => 'Lemmikloomatoit';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'Toote tüüp';

  @override
  String get product_type_selection_subtitle => 'Valige selle toote tüüp';

  @override
  String get product_type_selection_empty => 'Esmalt tuleb valida toote tüüp!';

  @override
  String product_type_selection_already(String productType) {
    return 'Toote tüüpi ei saa muuta ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Otsetee tootelehel olevale hinnarakendusele';

  @override
  String get prices_app_button => 'Ava rakendus Hinnad';

  @override
  String get prices_website_button => 'Ava Open Prices\'i veebisaidis';

  @override
  String get prices_bulk_proof_upload_select =>
      'Lisa hinnasildid otse galeriist';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Kui olete pildid valinud, ei saa te neid enam redigeerida!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Luba kogukonnal tehisintellekti abil saadud hindu valideerida.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Mitu hinnasilti';

  @override
  String get prices_bulk_proof_upload_title =>
      'Massilise tõestuse üleslaadimine';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Failide valimine';

  @override
  String get prices_bulk_proof_upload_step_starting =>
      'Üleslaadimise alustamine';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Faili lokaalne kopeerimine #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Üleslaadimise ettevalmistamine #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Ebaõnnestus pildil #$index/$count';
  }

  @override
  String get prices_generic_title => 'Hinnad';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Lisa $count hinnad',
      one: 'Lisa hind',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Saada $count hinnad',
      one: 'Saada hind',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Lisa üksus';

  @override
  String get prices_add_a_price => 'Lisa hind';

  @override
  String get prices_add_a_receipt => 'Lisa kviitung';

  @override
  String get prices_add_price_tags => 'Lisa hinnasildid';

  @override
  String prices_barcode_already(String barcode) {
    return 'See vöötkood ($barcode) on juba nimekirjas!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'Toodet pole veel';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Otsin $barcode';
  }

  @override
  String get prices_barcode_enter => 'Sisestage vöötkood';

  @override
  String get prices_category_enter => 'Toode ilma vöötkoodita';

  @override
  String get prices_per_kilogram => 'Hind kilogrammi kohta';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / ühik';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'Valikuline';

  @override
  String get prices_category_error_mandatory => 'Kategooria on kohustuslik';

  @override
  String get prices_barcode_reader_action => 'Vöötkoodilugeja';

  @override
  String get prices_view_prices => 'Vaata hindu';

  @override
  String get prices_list_title => 'Hinnakiri';

  @override
  String get prices_list_count => '\nhindade arv';

  @override
  String get prices_list_add_new_price => 'Lisa\nuus hind';

  @override
  String get prices_list_empty_title => 'Hinda veel pole!';

  @override
  String get prices_list_empty_subtitle =>
      'Ole esimene, kes selle lisab:\nSkanneerides **kviitungit** või **hinnasilti**!';

  @override
  String get prices_entry_shop_not_found => 'Tundmatu pood';

  @override
  String prices_entry_menu_title(String user) {
    return 'Hinna sisestamine alates \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Kuva kõik selle toote hinnad';

  @override
  String get prices_entry_menu_open_proof => 'Vaata tõendit';

  @override
  String get prices_entry_menu_my_prices => 'Vaata minu teisi hindu';

  @override
  String get prices_entry_menu_author_prices => 'Vaata autori teisi hindu';

  @override
  String get prices_entry_menu_shop_prices => 'Vaata teisi hindu poest';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hinnad',
      one: '1 hind',
    );
    return '$_temp0 eest $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Kõik $count hinnad',
      one: 'Ainult üks hind',
      zero: 'Hinda pole veel',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Viimased $pageSize hinnad (kokku: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Hind: $price / Pood: \"$location\" / Avaldatud $date autorilt \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return '\"$user\" avatud tõestused';
  }

  @override
  String get prices_open_proof => 'Avatud hinna tõend';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Kõik $count tõestused',
      one: 'Ainult üks tõestus',
      zero: 'Tõestust pole veel',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Viimased $pageSize tõestused (kokku: $total)';
  }

  @override
  String get prices_users_empty_title => 'Kaasautoreid veel pole!';

  @override
  String get prices_users_empty_explanation => 'Ole esimene, kes hinna lisab!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Suurimad $pageSize panustajad (kokku: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Pole veel poodi!';

  @override
  String get prices_locations_empty_explanation =>
      'Ole esimene, kes hinna lisab!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Parimad $pageSize asukohad (kokku: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tõestused',
      one: 'Üks tõestus',
      zero: 'Tõestust pole',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tooted',
      one: 'Üks toode',
      zero: 'Ühtegi toodet pole',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kasutajad',
      one: 'Üks kasutaja',
      zero: 'Kasutajaid pole',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hinnad',
      one: 'Üks hind',
      zero: 'Hinda pole',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Hind on eelnevalt lisatud';

  @override
  String get prices_amount_subtitle => 'Summa';

  @override
  String get prices_amount_is_discounted => 'Kas on allahinnatud?';

  @override
  String get prices_amount_price_normal => 'Hind';

  @override
  String get prices_amount_price_discounted => 'Soodushind';

  @override
  String get prices_amount_price_not_discounted => 'Algne hind';

  @override
  String get prices_amount_no_product => 'Üks toode on puudu!';

  @override
  String get prices_amount_price_incorrect => 'Vale väärtus';

  @override
  String get prices_amount_price_mandatory => 'Kohustuslik väärtus';

  @override
  String get prices_currency_subtitle => 'Valuuta';

  @override
  String get prices_date_subtitle => 'Kuupäev';

  @override
  String get prices_location_subtitle => 'Pood';

  @override
  String get prices_location_find => 'Leia pood';

  @override
  String get prices_location_mandatory => 'Sa pead valima poe!';

  @override
  String get prices_location_search_broader =>
      'Ei leidnud seda, mida otsisid? Proovime laiemat otsingut!';

  @override
  String get prices_proof_subtitle => 'Tõestus';

  @override
  String get prices_proof_empty_title => 'Pole veel tõestust!';

  @override
  String get prices_proof_empty_explanation =>
      'Alusta **kviitungi** või **hinnasildi** foto lisamisega!';

  @override
  String get prices_proof_find => 'Valige tõend';

  @override
  String get prices_proof_change => 'Muutuste tõend';

  @override
  String get prices_proof_receipt => 'Kviitung';

  @override
  String get prices_proof_price_tag => 'Hinnasilt';

  @override
  String get prices_proof_mandatory => 'Sa pead valima tõendi!';

  @override
  String get prices_add_validation_error => 'Valideerimisviga';

  @override
  String get prices_privacy_warning_title => 'Privaatsushoiatus';

  @override
  String get prices_unknown_product => 'Tundmatu toode';

  @override
  String get prices_privacy_warning_main_message =>
      'Hinnad **on avalikud** koos kauplusega, millele need viitavad.\n\nSee võib lubada inimestel, kes teavad teie Open Food Factsi pseudonüümi, teha järgmist:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Tehke kindlaks, millises piirkonnas te elate';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Tea, mida sa ostad';

  @override
  String get prices_privacy_warning_sub_message =>
      'Kui see tekitab sinus ebamugavust, palun muuda oma pseudonüümi või loo uus Open Food Factsi konto ja logi sellega rakendusse sisse.';

  @override
  String get i_refuse => 'Ma keeldun';

  @override
  String get i_accept => 'Ma nõustun';

  @override
  String get prices_currency_change_proposal_title => 'Kas vahetada valuutat?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Teie praegune valuuta on **$currency**. Kas soovite selle muuta valuutaks **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Jah, kasuta $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Ei, hoia $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Valmis';

  @override
  String get dev_mode_section_server => 'Serveri konfiguratsioon';

  @override
  String get dev_mode_section_news => 'Uudistepakkuja konfiguratsioon';

  @override
  String get dev_mode_section_product_page => 'Tooteleht';

  @override
  String get dev_mode_section_ui => 'Kasutajaliides';

  @override
  String get dev_mode_section_experimental_features =>
      'Eksperimentaalsed funktsioonid';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Rohelise skoori välistamine';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Kasutage OCR-ekraanide jaoks õigekirjakontrolli';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Koostisosad ja pakend)';

  @override
  String get dev_mode_reset_app_language_title => 'Lähtesta rakenduse keel';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Lisa kaarte';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Vaheta prices.openfoodfacts.org (PROD) ja testkeskkonna vahel';

  @override
  String get search_history_item_edit_tooltip =>
      'Kasuta seda otsingut uuesti ja muuda seda';

  @override
  String get search_history_item_remove_tooltip => 'Eemalda';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Oled kõik $totalSize tooted alla laadinud.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Laadi alla $count rohkem tooteid\nJuba alla laaditud $downloaded / $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Sinu otsing $search on pooleli.\n\nPalun oota paar sekundit…';
  }

  @override
  String get user_search_contributor_title => 'Minu lisatud tooted';

  @override
  String get user_search_informer_title => 'Minu muudetud tooted';

  @override
  String get user_search_photographer_title => 'Tooted, mida ma pildistasin';

  @override
  String get user_search_to_be_completed_title => 'Minu lõpetamata tooted';

  @override
  String get user_search_prices_title => 'Minu hinnad';

  @override
  String get user_search_proofs_title => 'Minu tõestused';

  @override
  String get user_search_proof_title => 'Minu tõestus';

  @override
  String search_proof_title(String user) {
    return 'Tõestus valemist \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Kaastööliste hinnad: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Viimati lisatud hinnad';

  @override
  String get all_search_prices_top_user_title => 'Suurimad hinnategurid';

  @override
  String get all_search_prices_top_location_title =>
      'Kõige soodsamate hindadega poed';

  @override
  String get prices_contribution_assistant => 'Hinnakujunduse assistent';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Lisa mitu tõestust';

  @override
  String get all_search_prices_top_location_single_title => 'Hinnad poes';

  @override
  String get all_search_prices_top_product_title =>
      'Kõige kõrgemate hindadega tooted';

  @override
  String get all_search_to_be_completed_title => 'Kõik valmimisjärgus tooted';

  @override
  String get categorize_products_country_title =>
      'Aita tooteid oma riigis kategoriseerida';

  @override
  String get edit_product_action_retake_picture => 'Tee foto uuesti';

  @override
  String get edit_product_action_take_picture => 'Tehke foto';

  @override
  String get edit_product_action_confirm => 'Kinnita';

  @override
  String get signup_page_terms_of_use_line1 => 'Nõustun avatud toidufaktidega ';

  @override
  String get signup_page_terms_of_use_line2 => 'kasutustingimused ja panus';

  @override
  String get analytics_consent_image_semantic_label => 'Analüütika ikoon';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Saatuslik viga: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Saatuslik viga: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'Täielikud põhiandmed';

  @override
  String get edit_photo_button_label => 'Muuda';

  @override
  String get edit_photo_unselect_button_label => 'Tühista foto valik';

  @override
  String get edit_photo_select_existing_button_label =>
      'Valige olemasolev pilt';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Valige pilt, klõpsates sellel';

  @override
  String get edit_photo_select_existing_download_label =>
      'Olemasolevate piltide hankimine…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Selle tootega seoses pole varem pilte üles laaditud.';

  @override
  String get edit_photo_language_not_this_one =>
      'Selles keeles pole veel pilti';

  @override
  String get edit_photo_language_none => 'Pilti pole veel';

  @override
  String get category_picker_screen_title => 'Kategooriad';

  @override
  String get basic_details => 'Põhiandmed';

  @override
  String get product_name => 'Toote nimi';

  @override
  String get product_names => 'Tootenimed';

  @override
  String get add_basic_details_product_name_add_translation => 'Lisa uus tõlge';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Enne valideerimist palun lisa tõlge ainult siis, kui **keel on pakendil olemas**';

  @override
  String get add_basic_details_product_name_open_photo => 'Vaata esifotot';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Tehke eestpoolt foto';

  @override
  String get add_basic_details_product_name_hint =>
      'Sisesta toote nimi (nt: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Kas muuta vaikekeelt?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Kas soovite, et toote vaikekeeleks määrataks \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Head näited';

  @override
  String get explanation_section_bad_examples => 'Halvad näited';

  @override
  String get add_basic_details_product_name_help_title =>
      'Head tavad: Toote nimetus';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Toote nimi on **pakendil trükitud põhinimi**. See võib olla registreeritud kaubamärk.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Märkus:** Palun ärge lisage tõlget, **kui pakendil pole vastavat keelt**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomatiketšup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Ärge lisage nimesse kaubamärki';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomatiketšup **Heinzilt**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Ärge kasutage sümboleid ®, ™, © ega sarnaseid';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count muud tõlked',
      one: '$count muu tõlge',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Brändi nimi';

  @override
  String get brand_names => 'Kaubamärgid';

  @override
  String get add_basic_details_brand_name_error =>
      'Palun sisestage brändi nimi';

  @override
  String get add_basic_details_brand_names_hint =>
      'Sisendbrändid (nt: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Head tavad: kaubamärgid';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Sisesta **kõik toote kaubamärgid**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Peamine kaubamärk';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Peamine kaubamärk**, mis on tavaliselt pakendi esiküljel selgelt kuvatud, tuleks **sisestada esimesena**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Teised kaubamärgid';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Kui müüb **suur ettevõte**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel**i müüb **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Kui müüakse koos kaubamärgiga **mitmesse keelde tõlgituna**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Looduseorg** on mõnikord kirjutatud ka kui **Val Loodus**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Kogus ja kaal';

  @override
  String get add_basic_details_quantity_hint =>
      'Sisestage kaal ja vajadusel kogus (nt: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Head tavad: Kogus';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Kopeeri tootel näidatud väärtus ja **ära unusta ühikuid**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** või **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (6 muna kohta)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(toote puhul, mis sisaldab 3 karpi, igaüks 150g)';

  @override
  String get barcode => 'Triipkood';

  @override
  String barcode_barcode(String barcode) {
    return 'Triipkood: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Kehtetu vöötkood';

  @override
  String get basic_details_add_success => 'Põhiandmed on edukalt lisatud';

  @override
  String get basic_details_add_error =>
      'Põhiandmete lisamine ebaõnnestus. Proovige mõne aja pärast uuesti.';

  @override
  String get clear_search => 'Tühjenda oma otsing';

  @override
  String get confirm_clear =>
      'Sa oled kogu oma ajaloo kustutamas: kas oled kindel, et soovid jätkata?';

  @override
  String get alert_clear_selected_user_list =>
      'Sa oled oma ajaloost valitud üksusi kustutamas';

  @override
  String get confirm_clear_selected_user_list =>
      'Kas oled kindel, et soovid jätkata?';

  @override
  String get alert_select_items_to_clear =>
      'Palun vali üks või mitu üksust tühjendamiseks';

  @override
  String confirm_clear_user_list(String name) {
    return 'Sa oled selle nimekirja ($name) tühjendamas : kas oled kindel, et soovid jätkata?';
  }

  @override
  String get confirm_delete_user_list_title => 'Kas kustutada nimekiri?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Sa oled kustutamas nimekirja \"$name\".\nKas oled kindel, et soovid jätkata?';
  }

  @override
  String get confirm_delete_user_list_button => 'Jah, ma kinnitan';

  @override
  String importance_label(String name, String id) {
    return '$name tähtsus: $id';
  }

  @override
  String get user_list_all_title => 'Loendid';

  @override
  String get user_list_all_empty => 'Koosta oma esimene loend';

  @override
  String get product_list_select => 'Valige loend';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tooted',
      one: 'Üks toode',
      zero: 'Tühi nimekiri',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Lisa nimekiri';

  @override
  String get open_food_preferences_tooltip => 'Muuda oma toidueelistusi';

  @override
  String get add_photo_button_label => 'Lisa foto';

  @override
  String get add_packaging_photo_button_label =>
      'Tehke pakendi/taaskasutusteabe kohta fotosid.';

  @override
  String get add_origin_photo_button_label =>
      'Tehke fotosid mis tahes päritoluteabe kohta';

  @override
  String get add_emb_photo_button_label =>
      'Tehke jälgitavuskoodi teabest fotosid';

  @override
  String get add_label_photo_button_label =>
      'Tehke fotosid kõikidest siltidest ja sertifitseerimisteabest';

  @override
  String get choose_image_source_title => 'Valige pildi allikas';

  @override
  String get choose_image_source_body => 'Palun vali pildi allikas';

  @override
  String get gallery_source_label => 'Galerii';

  @override
  String get gallery_source_access_denied_dialog_title => 'Juurdepääs keelatud';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Kahjuks ei pääse rakendus teie galeriile ligi, kuna olete varem loa keelanud.\n\nPalun minge oma telefoni rakenduse seadetesse menüüs Seaded -> Fotod';

  @override
  String get gallery_source_access_denied_dialog_button => 'Avage seaded';

  @override
  String get share => 'Jaga';

  @override
  String share_product_text(String url) {
    return 'Vaadake seda toodet Open Food Factsi lehel: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Vaata seda toodet Open Beauty Factsi lehel: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Vaadake seda toodet Open PetFood Factsi lehel: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Vaadake seda toodet Open Products Facts lehel: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Vaadake minu tootenimekirja Open Food Factsis: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Tehke foto';

  @override
  String get choose_from_gallery => 'Vali galeriist';

  @override
  String get image_upload_queued =>
      'Pilt laaditakse taustale üles niipea kui võimalik.';

  @override
  String get add_price_queued =>
      'Hind saadetakse serverisse esimesel võimalusel.';

  @override
  String get background_task_title_full_refresh =>
      'Kõigi kohalikult salvestatud toodete värskendamise alustamine';

  @override
  String get background_task_title_folksonomy =>
      'Serveri toimingute teostamise alustamine lokaalselt salvestatud folksonomy värskenduste jaoks';

  @override
  String get background_task_title_top_n =>
      'Kõige populaarsemate toodete allalaadimise alustamine';

  @override
  String get expand_nutrition_facts => 'Laienda toitumisalase teabe tabelit';

  @override
  String get expand_nutrition_facts_body =>
      'Hoidke toitumisalase teabe tabel laiendatuna';

  @override
  String get expand_ingredients => 'Laienda koostisosi';

  @override
  String get expand_ingredients_body => 'Hoia koostisosade paneel laiendatuna';

  @override
  String get no_internet_connection => 'Internetiühendust pole';

  @override
  String get world_results_label => 'Terve maailm';

  @override
  String get world_results_action => 'Laienda oma otsingut kogu maailmale';

  @override
  String get copy_to_clipboard => 'Kopeeri';

  @override
  String get paste_from_clipboard => 'Kleebi lõikelaualt';

  @override
  String get no_data_available_in_clipboard =>
      'Lõikelaual pole andmeid saadaval';

  @override
  String get clipboard_barcode_copy => 'Kopeeri vöötkood lõikelauale';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Triipkood $barcode kopeeriti lõikelauale!';
  }

  @override
  String get open_product_website => 'Ava see toode veebisaidil';

  @override
  String get language_picker_label => 'Sinu keel';

  @override
  String get country_picker_label => 'Sinu riik';

  @override
  String get currency_picker_label => 'Sinu vääring';

  @override
  String get help_with_openfoodfacts => 'Abi OpenFoodFactsiga';

  @override
  String get product_task_background_schedule =>
      'Toodet uuendatakse taustal niipea kui võimalik.';

  @override
  String get no_email_client_available_dialog_title =>
      'Ei mingeid e-posti rakendusi!';

  @override
  String get no_email_client_available_dialog_content =>
      'Palun saatke meile käsitsi e-kiri aadressile mobile@openfoodfacts.org';

  @override
  String get all_images => 'Kõik pildid';

  @override
  String get selected_images => 'Valitud pildid';

  @override
  String get product_card_remove_product_tooltip => 'Eemalda toode';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Uus vöötkood skannitud: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Eemalda karussellilt kõik tooted';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Palun skannige vähemalt kahte toodet, et neid võrrelda';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Klõpsake skannitud toodete võrdlemiseks';

  @override
  String get scan_product_loading => 'Olete skanninud\nvöötkoodi:';

  @override
  String get scan_product_loading_initial =>
      'Otsime seda toodet!\nPalun oodake paar sekundit…';

  @override
  String get scan_product_loading_long_request =>
      'Me otsime seda toodet endiselt!\nKas teie arvates võtab laadimine kaua aega? Kas meie ka…';

  @override
  String get scan_product_loading_unresponsive =>
      'Jätkuvalt otsime seda toodet.\nKas soovid otsingut uuesti alustada?';

  @override
  String get scan_product_loading_restart_button => 'Alusta otsingut uuesti';

  @override
  String get portion_calculator_description =>
      'Arvutage konkreetse koguse toitumisalane teave';

  @override
  String get portion_calculator_hint => 'Kogus';

  @override
  String get portion_calculator_accessibility =>
      'Toitumisalase teabe arvutamiseks sisestage kogus';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Palun sisesta kogus vahemikus $min kuni $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Puuduvad andmed. Arvutust ei saanud teha.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Toitumisalane teave $grams g (või ml) kohta';
  }

  @override
  String get offline_data => 'Võrguühenduseta andmed';

  @override
  String get ocr_image_upload_instruction =>
      'Laadige pilt üles, et selles sisalduv teave automaatselt välja võtta.';

  @override
  String get upload_image => 'Laadi foto üles';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Pildi allalaadimine ebaõnnestus';

  @override
  String get image_edit_url_error =>
      'Pildi muutmine ebaõnnestus, kuna pildi URL-i polnud määratud.';

  @override
  String get user_picture_source_remember => 'Jäta minu valik meelde';

  @override
  String get user_picture_source_ask => 'Küsi iga kord';

  @override
  String get robotoff_continue => 'Jätka';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count küsimused',
      one: 'küsimus',
    );
    return 'Järgmine $_temp0';
  }

  @override
  String get show_password => 'Näita salasõna';

  @override
  String get owner_field_info_title => 'Tootja esitatud väärtused';

  @override
  String get owner_field_info_message =>
      'Selle logoga tõstame esile tootja esitatud andmeid ja neid ei pruugi olla võimalik muuta.';

  @override
  String get owner_field_info_close_button => 'Sulge see teave';

  @override
  String get owner_field_image =>
      'Selle pildi on esitanud tootja. See ei pruugi olla muudetav.';

  @override
  String get edit_packagings_title => 'Pakendikomponendid';

  @override
  String get edit_packagings_element_add => 'Lisage pakendikomponent';

  @override
  String get edit_packagings_completed => 'Pakend on täielik';

  @override
  String edit_packagings_element_title(int index) {
    return 'Pakendikomponent #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Ühikute arv';

  @override
  String get edit_packagings_element_hint_units =>
      'Sisestage tootes sisalduvate sama kuju ja materjaliga pakkeühikute arv.';

  @override
  String get edit_packagings_element_field_shape => 'Kuju';

  @override
  String get edit_packagings_element_hint_shape =>
      'Sisestage ringlussevõtu juhistes loetletud kuju nimi, kui see on saadaval, või valige kuju.';

  @override
  String get edit_packagings_element_example_shape => 'Pudel';

  @override
  String get edit_packagings_element_field_material => 'Materjal';

  @override
  String get edit_packagings_element_hint_material =>
      'Sisestage konkreetne materjal, kui seda on võimalik kindlaks teha (pakendiosadel võib sageli leida kolmnurga sees oleva materjalikoodi) või üldine materjal (näiteks plastik või metall), kui te pole kindel.';

  @override
  String get edit_packagings_element_example_material => 'Klaas';

  @override
  String get edit_packagings_element_field_recycling => 'Taaskasutusjuhised';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Sisestage ringlussevõtu juhised ainult siis, kui need on tootel loetletud.';

  @override
  String get edit_packagings_element_example_recycling => 'Taaskasuta';

  @override
  String get edit_packagings_element_field_quantity =>
      'Toote netokogus ühiku kohta';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Sisestage netokaal või netomaht ja märkige ühik (näiteks g või ml).';

  @override
  String get edit_packagings_element_field_weight => 'Ühe tühja ühiku kaal (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Eemaldage enne kaalumist kõik ülejäänud toit ning peske ja kuivatage pakend. Võimalusel kasutage kaalu täpsusega 0,1 g või 0,01 g.';

  @override
  String get background_task_title => 'Ootel olevad sissemaksed';

  @override
  String get background_task_subtitle =>
      'Teie panused salvestatakse automaatselt meie serverisse, kuid mitte alati reaalajas.';

  @override
  String get background_task_list_empty => 'Ootel taustaülesandeid pole';

  @override
  String get background_task_error_server_time_out => 'Serveri ajalõpp';

  @override
  String get background_task_error_no_internet =>
      'Internetiühenduse viga. Proovige hiljem.';

  @override
  String get background_task_operation_unknown => 'tundmatu operatsiooni tüüp';

  @override
  String get background_task_operation_details => 'üksikasjalikud muudatused';

  @override
  String get background_task_operation_image => 'foto üleslaadimine';

  @override
  String get background_task_operation_refresh =>
      'värskendamine viibis pärast foto üleslaadimist';

  @override
  String get background_task_run_started => 'alustas';

  @override
  String get background_task_run_not_started => 'pole veel alustatud';

  @override
  String get background_task_run_to_be_deleted => 'kustutatakse';

  @override
  String get background_task_question_stop =>
      'Kas sa tahad selle ülesande niipea kui võimalik lõpetada?';

  @override
  String get feed_back => 'Tagasiside';

  @override
  String get undo => 'Võta tagasi';

  @override
  String get copy_email_to_clip_board => 'Kopeeri e-kiri lõikelauale';

  @override
  String get please_send_us_an_email_to =>
      'Palun saatke meile käsitsi e-kiri aadressile';

  @override
  String get email_copied_to_clip_board => 'E-kiri kopeeriti lõikelauale!';

  @override
  String get select_accent_color => 'Valige aktsentvärv';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Sinine';

  @override
  String get color_cyan => 'Tsüaan';

  @override
  String get color_green => 'Roheline';

  @override
  String get color_light_brown => 'Vaikimisi';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Oranž';

  @override
  String get color_pink => 'Roosa';

  @override
  String get color_red => 'Punane';

  @override
  String get color_rust => 'Rooste';

  @override
  String get color_teal => 'Sinakasroheline';

  @override
  String get text_contrast_mode => 'Teksti kontrastsus';

  @override
  String get contrast_high => 'Kõrge';

  @override
  String get contrast_medium => 'Keskmine';

  @override
  String get contrast_low => 'Madal';

  @override
  String get product_refresher_internet_not_found => 'Toodet ei leitud!';

  @override
  String get product_refresher_internet_not_connected =>
      'Sa pole internetiga ühendatud!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server maas ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Serveri viga ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Toodet ei leitud!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Meie andmebaasis puudub toode järgmise vöötkoodiga: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Internetiühendust pole!';

  @override
  String get product_loader_network_error_message =>
      'Kontrollige, kas teie nutitelefon on WiFi-võrgus või kas mobiilne andmeside on lubatud.';

  @override
  String get page_not_found_title => 'Lehte ei leitud!';

  @override
  String get page_not_found_button => 'Mine tagasi avalehele';

  @override
  String get download_data => 'Laadi andmed alla';

  @override
  String get download_top_products =>
      'Laadige koheseks skannimiseks alla oma riigi 1000 parimat toodet';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tooted',
    );
    return 'Laadige koheseks skaneerimiseks alla oma riigi parimad $_temp0';
  }

  @override
  String get download_in_progress =>
      'Andmete allalaadimine\nSee võib võtta veidi aega';

  @override
  String downloaded_products(int num) {
    return '$num toodet lisatud';
  }

  @override
  String get update_offline_data => 'Värskenda võrguühenduseta tooteandmeid';

  @override
  String get update_local_database_sub =>
      'Värskenda kohalikku tooteandmebaasi Open Food Factsi uusimate andmetega';

  @override
  String get clear_local_database => 'Tühjenda võrguühenduseta tooteandmed';

  @override
  String get clear_local_database_sub =>
      'Ruumi vabastamiseks kustutage oma rakendusest kõik kohalikud tooteandmed';

  @override
  String deleted_products(int num) {
    return '$num toodet kustutatud';
  }

  @override
  String get loading => 'Laadimine…';

  @override
  String get know_more => 'Tea rohkem';

  @override
  String get offline_data_desc =>
      'Lisateabe saamiseks võrguühenduseta andmete kohta klõpsake siin';

  @override
  String get offline_product_data_title => 'Võrguühenduseta tooteandmed';

  @override
  String available_for_download(int num) {
    return '$num tooted koheseks skannimiseks saadaval';
  }

  @override
  String get country_selector_title => 'Vali oma riik:';

  @override
  String get currency_selector_title => 'Valige oma valuuta:';

  @override
  String get language_selector_title => 'Valige oma keel:';

  @override
  String get language_selector_section_selected => 'Valitud keeled';

  @override
  String get language_selector_section_frequently_used => 'Sageli kasutatav';

  @override
  String get action_delete_list => 'Kustuta';

  @override
  String get action_change_list => 'Muuda praegust loendit';

  @override
  String get product_list_create => 'Loo';

  @override
  String get product_list_create_tooltip => 'Loo uus nimekiri';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Uus arvutus)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (uus arvutus)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Tundmatu Nutri-Score (uus arvutus)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score ei ole kohaldatav';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score ei ole kohaldatav (uus arvutus)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Roheline hinne A';

  @override
  String get environmental_score_b_new => 'Rohelise skooriga B';

  @override
  String get environmental_score_c_new => 'Rohelise skoori C';

  @override
  String get environmental_score_d_new => 'Rohelise skoori D';

  @override
  String get environmental_score_e_new => 'Rohelise skoori E';

  @override
  String get environmental_score_unknown_new => 'Tundmatu roheline skoor';

  @override
  String get environmental_score_not_applicable_new =>
      'Roheline punktisumma ei ole kohaldatav';

  @override
  String get nova_group_generic_new => 'Ülitöödeldud toidud - NOVA grupid';

  @override
  String get nova_group_1 => 'NOVA 1. grupp';

  @override
  String get nova_group_2 => 'NOVA 2. grupp';

  @override
  String get nova_group_3 => 'NOVA 3. grupp';

  @override
  String get nova_group_4 => 'NOVA 4. grupp';

  @override
  String get nova_group_unknown => 'Tundmatu NOVA grupp';

  @override
  String get nutrition_facts => 'Toitainete tasemed';

  @override
  String get faq_title_partners => 'MTÜ partnerid ja patroonid';

  @override
  String get faq_title_vision =>
      'Avatud toidufaktide visioon, missioon, väärtused ja programmid';

  @override
  String get faq_title_install_beauty =>
      'Kosmeetikatoodete andmebaasi loomiseks installige Open Beauty Facts';

  @override
  String get faq_title_install_pet =>
      'Lemmikloomatoitude andmebaasi loomiseks installige Open Pet Food Facts';

  @override
  String get faq_title_install_product =>
      'Objektide eluea pikendamiseks toodete andmebaasi loomiseks installige Open Products Facts';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nutri-Score\'i uus arvutus: mis on uut?';

  @override
  String get contact_title_pro_page =>
      'Pluss? Impordi oma tooted Open Food Factsi';

  @override
  String get contact_title_pro_email => 'Produtsendi kontakt';

  @override
  String get contact_title_press_page => 'Pressileht';

  @override
  String get contact_title_press_email => 'Pressikontakt';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'Liitu meie kogukonna kalendriga';

  @override
  String get hunger_games_loading_line1 => 'Palun andke meile paar sekundit…';

  @override
  String get hunger_games_loading_line2 => 'Laadime küsimused alla!';

  @override
  String get hunger_games_error_label =>
      'Appi! Midagi läks valesti… ja me ei saanud küsimusi laadida.';

  @override
  String get hunger_games_error_retry_button => 'Proovime uuesti!';

  @override
  String get reorder_attribute_action => 'Atribuutide ümberjärjestamine';

  @override
  String get link_cant_be_opened =>
      'Seda linki ei saa teie seadmes avada. Palun kontrollige, kas teil on brauser installitud.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return '$productNameüksikasjad';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return '$pageName üksikasjad koos $productName-ga';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Jaga';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Kust leida uus Nutri-Score\'i arvutus?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score\'i kasutatakse seitsmes riigis: Prantsusmaal, Saksamaal, Belgias, Hispaanias, Luksemburgis, Hollandis ja Šveitsis.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Tootjatel on pärast määruse allkirjastamist aega hiljemalt **2 aastat**, et asendada** vana arvutus uuega.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Mis on roheline punktisumma?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score on logo, mille eesmärk on teavitada teid **toidu keskkonnamõjust**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Värvikood varieerub tumerohelisest (**A+**) **kõige väiksema mõjuga** toodete puhul tumepunaseni (**F**) **kõige suurema mõjuga** toodete puhul.';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score\'i logod';

  @override
  String get guide_greenscore_lca_title => 'Tuum: elutsükli hindamine (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Toidukategooriate teaduslik hindamine';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Iga tootekategooria jaoks määratakse **võrdlusnäitaja**, kasutades Agribalyse\'i keskkonnaandmebaasi (ADEME ja INRAE loodud) andmeid.';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Elutsükli analüüs** on standardiseeritud hindamismeetod mitmeastmelise ja mitmekriteeriumilise keskkonnamõju hindamise läbiviimiseks.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**See mõõdab:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 tootmisetappi';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Packaging';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title => '14 keskkonnamõju näitajat';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Kliimamuutused/süsiniku jalajälg';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Osoonikihi kahanemine';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ioniseeriv kiirgus';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Maa';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Vee ja energia tarbimine';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Õhu saastamine';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Mere- ja magevesi (osakesed, hapestumine, eutrofeerumine)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Ressursside ammendumine.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Boonused ja karistused';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Paremate toodete premeerimiseks kategoorias rakendame **boonuseid ja karistusi mitme kriteeriumi alusel**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Boonust** antakse toodetele, millel on **ametlik märgis, märgis või sertifikaat, mis tagab keskkonnakasu** (mahe, õiglane kaubandus, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origin of ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'Koostisosade päritolu alusel antakse **boonust**. See boonus võtab arvesse **mõju transpordile** ja iga tootja riigi **keskkonnapoliitikat**.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Karistust** määratakse toodetele, mis sisaldavad koostisosi, millel on märkimisväärne **negatiivne mõju bioloogilisele mitmekesisusele ja ökosüsteemidele**, näiteks palmiõli, mille tootmine põhjustab massilist metsade hävitamist.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Packaging';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Trahvi** arvutamisel võetakse arvesse pakendi ringluspõhimõtteid (taaskasutatud tooraine kasutamine ja taaskasutatavus) ja ülepakendamist.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Rohelise skoori täpseks arvutamiseks on vaja teavet, mis ei ole pakendil tingimata märgitud (näiteks iga koostisosa päritolu ja täpne protsent) või mis on harva kättesaadav kasutataval kujul (näiteks pakendi kõigi komponentide loetelu koos kasutatud plastide täpsete tüüpidega).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Kui see teave pole veel saadaval, kasutatakse keskmisi väärtusi**, kuid nüüd kutsume kõiki üles aitama meil seda teavet koguda, mis on väga kasulik nii rohelise skoori kui ka paljude muude eesmärkide jaoks.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Kuidas kodanikud saavad aidata?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Kõik kodanikud saavad aidata meil koguda ja struktureerida toodetel olevat või neist tuletatavat teavet, näiteks teavet **pakendil**: „Mission Emballages”: ulatuslik ühine pakendiinventuur kõikide toiduainete jaoks (prantsuse keeles).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Kuidas tootjad saavad aidata';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Tootjad saavad meile oma teabe otse meie tasuta tootjatele mõeldud platvormi kaudu saata.';

  @override
  String get guide_greenscore_better_product_title =>
      'Milline toode on planeedile parem?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Seda võib olla raske öelda';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Jätkusuutliku toidu valimine on üks võimsamaid asju, mida saame kliima heaks teha, kuna **meie globaalne toidusüsteem vastutab enam kui veerandi kogu kasvuhoonegaaside heitkoguste eest**.\n(Allikas: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Sul on võim!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Hea uudis on see, et see annab meile võimsa viisi muutuste loomiseks.\n**Igaüks meist sööb aastas umbes 1000 einet**. See on 1000 võimalust **valida planeedile parem tulevik**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Aitab vastutustundlik olla ja otsuseid langetada';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Jätkusuutliku toidu valimine võib tunduda keeruline. Sildid on segadusttekitavad ja teave on sageli puudulik. Roheline Skoor loodi selle lihtsustamiseks, andes teile toiduainetele **selge**, **teaduspõhise** ja **läbipaistva** keskkonnahinnangu just seal, kus seda vajate: ostlemise ajal.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Läbipaistvus';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Erinevalt omandiõigusega kaitstud märgistest on rohelise skoori arvutus **täiesti avatud** ja seda saab **kõik** kontrollida.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'Mis on ülikõrge töötlemine?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA grupid teavitavad teid toiduainete töötlemise tasemest.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA klassifikatsioon võimaldab toiduaineid jagada nelja rühma vastavalt nende tööstusliku töötlemise astmele (minimaalselt töödeldud või töötlemata toiduained, kulinaarsed koostisosad, töödeldud toiduained, ultratöödeldud toiduained).';

  @override
  String get guide_nova_logos_caption => 'NOVA logod';

  @override
  String get guide_nova_groups_title => '4 NOVA rühma';

  @override
  String get guide_nova_groups_intro =>
      'NOVA-rühmi on neli, millest problemaatilisem on 4. rühm - ülitöödeldud toidud.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimaalselt töödeldud või töötlemata toidud';

  @override
  String get guide_nova_groups_arg1_text =>
      'Töötlemata (ehk looduslikud) toiduained on **taimede** (seemned, viljad, lehed, varred, juured)**või loomade** (lihased, rups, munad, piim) söödavad osad, aga ka seened, vetikad ja vesi pärast loodusest eraldamist.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Töödeldud kulinaarsed koostisosad';

  @override
  String get guide_nova_groups_arg2_text =>
      'Töödeldud kulinaarsed koostisosad, näiteks **õlid, või, suhkur ja sool**, on ained, mis on saadud 1. rühma toiduainetest või loodusest selliste protsesside abil, mis hõlmavad pressimist, rafineerimist, jahvatamist, jahvatamist ja kuivatamist.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various preservation or cooking methods, and In the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three Ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with Little to no intact group 1 food. ingredients in these formulations usually include those also found in Processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain Other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Üliprotsessorite probleemid';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Toidu koostisosade äärmuslik töötlemine';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Paljud neist on **saadud toidu koostisosade edasise töötlemise teel**, näiteks hüdrogeenitud või interesterifitseeritud õlid, hüdrolüüsitud valgud, sojavalgu isolaat, maltodekstriin, invertsuhkur ja kõrge fruktoosisisaldusega maisisiirup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Lisandid, mis ületavad pelgalt toiduohutuse';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Ülitöödeldud toitudes leiduvate lisaainete hulka kuuluvad mõned, mida kasutatakse ka töödeldud toitudes, näiteks säilitusained, antioksüdandid ja stabilisaatorid. Ainult ülitöödeldud toodetes leiduvate lisaainete klasside hulka kuuluvad need, mida **ei kasutata toidu sensoorsete omaduste imiteerimiseks või parandamiseks või lõpptoote ebameeldivate külgede varjamiseks**. Nende lisandite hulka kuuluvad värvained ja muud värvained, värvistabilisaatorid; lõhna- ja maitseained, maitsetugevdajad, suhkruvabad magusained; ja abiained, näiteks gaseerimis-, pinguldamis-, täite- ja täitevastased ained, vahutamisvastased ained, paakumisvastased ained ja glasuuriained, emulgaatorid, sekvestrandid ja niiskusesäilitajad.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Töötlemine, mida kodus teha ei saa';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Tavaliselt paljude koostisosade ühendamiseks ja lõpptoote (sellest ka „ülitöödeldud“) loomiseks kasutatakse mitmeid protsesside järjestusi**. Protsesside hulka kuulub mitu, **millel kodumaised vasted puuduvad**, näiteks hüdrolüüsimine ja hüdrolüüsimine, ekstrusioon ja vormimine ning praadimiseks eelnev töötlemine.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Ülimalt töötlemise röövellikud ja rahalised aspektid';

  @override
  String get guide_nova_explanations_arg4_text =>
      'Ülitöödeldud toiduainete üldine eesmärk on luua kaubamärgiga, mugavaid (vastupidavaid, tarbimisvalmis), atraktiivseid (ülimaitselisi) ja väga kasumlikke (odavate koostisosadega) toiduaineid, mis on loodud tõrjuma välja kõik teised toidugrupid. Ülitöödeldud toiduained on tavaliselt atraktiivselt pakendatud ja turustatakse intensiivselt.';

  @override
  String get guide_nova_explanations_arg5_title => 'Tervisele ohtlik';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Alates 2018. aastast on NutriNet-Santé abil esimesed seosed **ülitöödeldud toitude tarbimise ja vähi, südame-veresoonkonna haiguste ning diabeedi suurenenud riski vahel esile tõstetud**. Tänapäeval kinnitavad neid tulemusi enam kui 90 uuringut kogu maailmas.\nKõige tugevamad seosed on seotud **rasvumise, südame-veresoonkonna suremuse ja depressioonisümptomitega**. Laste puhul on mõjud peamiselt täheldatud kaalu ja lipiidide tasakaaluhäirete osas.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Riigid soovitavad neid piirata';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Mõned riigid kasutavad oma toitumisjuhiste või eesmärkide jaoks NOVA rühmi, näiteks:\n\n- **🇧🇷 Brasiilia** toitumisjuhised **soovitavad piirata töödeldud toidu tarbimist** ja vältida ülitöödeldud toitu.\n\n- **🇫🇷 Prantsusmaa** rahvatervise toitumispoliitika eesmärgid aastateks 2018–2022 on **vähendada 4. rühma ülitöödeldud toitude tarbimist 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-et.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Tere tulemast Open Food Factsi!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Mis on avatud toidufaktid?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts on **koostööl põhinev**, **tasuta** ja **avatud** andmebaas toiduainetest üle kogu maailma.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Usume, et kõigil peaks olema juurdepääs teabele selle kohta, mida nad söövad. Kogudes andmeid koostisosade, allergeenide, toitumisalase teabe ja muu kohta, **anname tarbijatele võimaluse teha teadlikke valikuid** ja suuname toidutööstust **suurema läbipaistvuse** poole.';

  @override
  String get guide_open_food_facts_features_title =>
      'Avatud toidufaktide omadused';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Saate märguandeid soovimatute koostisosade kohta';

  @override
  String get guide_open_food_facts_tips_title =>
      'Näpunäited suurepäraste fotode tegemiseks';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Keeldused';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Väldi varje ja pimestamist.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Udust või fookusest väljas teksti pole.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Ära lõika teksti osi välja.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Väldi kiireid taustu.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Teemad';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Kasutage head ja ühtlast valgustust.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Veendu, et tekst on selge ja loetav.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Jäädvusta kogu koostisosade loend.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Hoidke toodet tasasel pinnal.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Aita meil luua \"Toidu Vikipeediat\"';

  @override
  String get guide_open_food_facts_scores_arg1_title => 'Toiteväärtuse hinne';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Skoor ülitöödeldud toitude vältimiseks';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Skoor planeedile';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-et.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Tere tulemast Open Pet Food Factsi lehele!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Mis on avatud lemmikloomatoidu faktid?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts laiendab meie missiooni meie karvastele sõpradele! See on **lemmikloomatoidu andmebaas kassidele, koertele ja teistele kaaslastele**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Kogume teavet **koostisosade**, **toiteväärtuse analüüsi** ja söötmisjuhiste kohta, et aidata lemmikloomaomanikel valida oma loomade vajadustele parim toit.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Avatud lemmikloomatoidu faktide omadused';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Saate märguandeid soovimatute koostisosade kohta';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Kas teie lemmikloom on mõne koostisosa suhtes allergiline? Saate otse rakenduses koostada nimekirja kosmeetikatoodete koostisosadest, mida vältida!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Näpunäited suurepäraste fotode tegemiseks';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Keeldused';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Väldi varje ja pimestamist.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Udust või fookusest väljas teksti pole.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Ära lõika teksti osi välja.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Väldi kiireid taustu.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Teemad';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Kasutage head ja ühtlast valgustust.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Veendu, et tekst on selge ja loetav.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Jäädvusta kogu koostisosade loend.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Hoidke toodet tasasel pinnal.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Märkus punktiarvestuse kohta';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Lemmikloomatoidu hindamissüsteemi väljatöötamine **pole praegu prioriteet**. Metoodika oleks keeruline, kuna toitumisvajadused on liigiti, vanuselt ja tervislikult erinevad suuresti. Me pole veel leidnud ühtegi sõltumatut teadusmeeskonda, kes suudaks sellise skoori välja töötada.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-et.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Tere tulemast Open Beauty Factsi!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Mis on avatud ilufaktid?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts on **kosmeetikatoodete** koostööl põhinev andmebaas.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Meie eesmärk on dešifreerida koostisosade loendeid, et aidata teil **mõista, mis on teie isikliku hügieeni toodetes**. Niisutajatest meigini – kogume andmeid koostisosade, allergeenide ja pakendite kohta, et edendada kosmeetikatööstuses läbipaistvust.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Avatud ilufaktide omadused';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Saate märguandeid soovimatute koostisosade kohta';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Kas sul on allergia mõne koostisosa suhtes? Kas soovid vältida komedoone tekitavaid aineid? Kas soovid hoiduda vastuolulistest komponentidest? Saad otse rakenduses koostada nimekirja kosmeetikatoodete koostisosadest, mida vältida!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Näpunäited suurepäraste fotode tegemiseks';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Keeldused';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Väldi varje ja pimestamist.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Udust või fookusest väljas teksti pole.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Ära lõika teksti osi välja.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 => 'Väldi kiireid taustu.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Teemad';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Kasutage head ja ühtlast valgustust.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Veendu, et tekst on selge ja loetav.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Jäädvusta kogu koostisosade loend.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Kui pudel on kõver, tehke nii palju pilte kui vaja.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Koostisosade loetelu nägemiseks peate võib-olla etiketi koorima.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Hoidke toodet tasasel pinnal.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Märkus punktiarvestuse kohta';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Erinevalt toiduainetest puudub kosmeetikamaailmas **üldiselt tunnustatud, valitsuse toetatud hindamissüsteem nagu Nutri-Score**. Koostisosade mõju võib olla väga individuaalne ja sõltuda nahatüübist, allergiatest ja individuaalsetest eelistustest.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-et.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices on projekt, mille eesmärk on **koguda ja jagada toodete hindu üle maailma**. See on avalikult kättesaadav andmestik, mida saab kasutada uuringuteks, analüüsiks ja muuks. Open Pricesi arendab ja haldab Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Me kogume avatud lähtekoodiga hinnaandmestikku rahvahulga abil**. Kasutajad saavad hindu lisada selle veebirakenduse või ametliku Open Food Factsi mobiilirakenduse kaudu. Jaemüüjad või kolmandate osapoolte rakendused saavad samuti meie API abil panustada.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Koguge vahekäikudes olevate hinnasiltide fotosid';

  @override
  String get guide_open_prices_how_arg2_title => 'Koguge kviitungite fotosid';

  @override
  String get guide_open_prices_why_title => 'Miks Open Food Facts seda teeb?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Hinnainfo on toidusüsteemide mõistmiseks ülioluline. See on võtmetegur toidu maksumuse mõistmisel ja tervislikuma toitumise edendamisel. Algsed hinnaandmed on viis, kuidas teadlastel, ajakirjanikel ja kodanikel **paremini mõista, kuidas toiduhinnad geograafiliselt ja ajas varieeruvad**.';

  @override
  String get guide_open_prices_why_arg1_title => 'Jälgige hindade arengut ajas';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Vaadake **hindade arengut**: kahanemisinflatsioon, odavinflatsioon, saame neid koos jälgida!';

  @override
  String get guide_open_prices_why_arg2_title => 'Võrdle hindu enda lähedal';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Mida rohkem hindu saame, seda paremini saate märgata **odavamaid poode enda ümber**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Kas kaalusite hindade kopeerimist jaemüüjate veebisaitidelt?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Hinna kraapimist kaalutakse Open Prices\'i tulevases versioonis, kuid seda teeks Open Prices ise, et meil oleks HTML-lehel põhinev hinna tõend.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Hindade avaldamiseks saate kasutada meie API-t.\nKui soovite hindu laiemalt avaldada, võtke meiega ühendust aadressil prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Tere tulemast Open Products Factsi lehele!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Mis on avatud tootefaktid?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts on tohutu avatud andmebaas **kõigile vöötkoodiga toodetele, mis ei ole toit, kosmeetika ega lemmikloomatoit**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Alates **elektroonikast** kuni **mänguasjadeni** ja **riietest** kuni **puhastusvahenditeni** – kui sellel on vöötkood, saab selle lisada. Selle projekti eesmärk on luua igapäevaste esemete jaoks „asjade internet“, mis muudaks nende kohta käiva teabe universaalselt kättesaadavaks.';

  @override
  String get guide_open_products_facts_features_title =>
      'Avatud toodete faktide omadused';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Factsi eesmärk on pakkuda tarbijatele võimalust **pikendada esemete eluiga**, pakkudes ringmajanduse lahendusi oma esemete hooldamiseks, **parandamiseks**, **ringlussevõtuks** või neile uue omaniku andmiseks.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Mõnede toodete süsiniku jalajälg';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      'Prantsuse Keskkonnaameti ADEME **CO2 mõju** pakub paljude kategooriate **süsiniku mõju**, veenduge, et kategoriseeriksite tooted täpselt.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Paljude toodete remonditavusindeks';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Alati, kui prantsusekeelne parandatavuse indeks on saadaval, kuvame selle. Lisaks **võite hakata muutujaid koguma Folksonomy mootori abil**, et saaksime selle tulevikus ise uuesti arvutada, isegi riikides, kus see pole saadaval.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Leidke võimalusi oma toote annetamiseks/edasimüügiks';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Pakume linke **kolmandate osapoolte ringlussõbralikele teenustele**, mis aitavad teil saada just sellist toodet, mida otsite, kasutatud tootena, et olla planeedi ressursside suhtes õrnem.\nPange tähele, et meile selle eest ei maksta ja süsteem töötab ainult näitena kahele Prantsusmaa veebisaidile. Saate aidata seda süsteemi laiendada, dokumenteerides vikis rohkem saite.';

  @override
  String get guide_open_products_facts_information_title =>
      'Milline teave on kasulik?';

  @override
  String get guide_open_products_facts_information_text =>
      'Nii laia valiku üksuste puhul on **meie kogutavad andmed paindlikud**. Selleks **lõime Folksonomy mootori**.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'Folksonomia mootor';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy mootor on tööriist, mis aitab teil tooteid asjakohaste omadustega täiendada. See aitab parandada otsingut ja leitavust, aga ka tulevikus huvitavaid asju arvutada ja kuvada.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Saate lisada mis tahes võtmeid ja väärtusi, näiteks: **ühilduvus_5G_mobile_networkiga: jah**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Saate võimalike omaduste automaatseid soovitusi ning olete väga teretulnud oma lemmiktoodete kohta uusi soovitusi lisama ja dokumenteerima.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-et.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Ava toidueelistused';

  @override
  String get guide_coming_soon_button_title => 'Varsti tulekul';

  @override
  String get guide_learn_more_subtitle => 'Lisateabe saamiseks puudutage';

  @override
  String get preview_badge => 'Eelvaade';

  @override
  String get prices_feedback_form =>
      'Selle uue funktsiooni kohta tagasiside saatmiseks klõpsake siin!';

  @override
  String get menu_button_list_actions => 'Valige toiming';

  @override
  String get error_loading_photo => 'Viga foto laadimisel';

  @override
  String get photo_viewer_action_use_picture_as => 'Kasuta kujul…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Kasuta seda pilti kui…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Kasuta seda pilti kui… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Detailid';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Selle foto üksikasjad';

  @override
  String get photo_viewer_details_title => 'Foto üksikasjad';

  @override
  String get photo_viewer_details_contributor_title => 'Panustaja';

  @override
  String get photo_viewer_details_size_title => 'Suurus';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pikslit';
  }

  @override
  String get photo_viewer_details_date_title => 'Kuupäev';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Ühilduv';

  @override
  String get user_lists_action_multi_select => 'Mitmikvalik';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Teie ühilduvuse skoor: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Front picture';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Ingredients picture';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Toitumisalane pilt';

  @override
  String get product_image_packaging_accessibility_label => 'Pakendi pilt';

  @override
  String get product_image_other_accessibility_label => 'Teine pilt';

  @override
  String get product_image_outdated_message => 'See pilt võib olla aegunud';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (see pilt võib olla aegunud)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (see pilt võib olla tootja poolt lukustatud)';
  }

  @override
  String get product_image_error => 'Pildi laadimine ebaõnnestus!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type laadimine ebaõnnestus (võrgu viga?)';
  }

  @override
  String get product_page_image_no_image_available => 'Pole\npilti!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Selle toote kohta pole pilti saadaval';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Toimingute ümberjärjestamine või peitmine';

  @override
  String get product_page_action_bar_setting_modal_title => 'Muuda toiminguid';

  @override
  String get product_page_action_bar_item_move_up => 'Liiguta üles';

  @override
  String get product_page_action_bar_item_move_down => 'Liiguta alla';

  @override
  String get product_page_action_bar_item_enable => 'Luba toiming';

  @override
  String get product_page_action_bar_item_disable => 'Keela toiming';

  @override
  String get product_page_pending_operations_banner_title =>
      'Muudatuste üleslaadimine…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Sellel lehel kuvatavad andmed **ei kajasta veel teie muudatusi**.\nPalun oodake paar sekundit…';

  @override
  String get product_add_a_language => 'Lisa keel';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Triipkood $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Eemalda see toode karussellis';

  @override
  String get carousel_unsupported_header => 'Toetamata vöötkood!';

  @override
  String get carousel_unsupported_title => 'Ups!';

  @override
  String get carousel_unsupported_text =>
      'Open Food Facts ei toeta skannitud vöötkoodi!';

  @override
  String get carousel_error_header => 'Viga!';

  @override
  String get carousel_error_title => 'See on küll masendav!';

  @override
  String get carousel_error_text_1 =>
      'Selle vöötkoodi kohta ei õnnestunud teavet alla laadida:';

  @override
  String get carousel_error_text_2 =>
      'Palun kontrollige oma internetiühendust või klõpsake seda nuppu:';

  @override
  String get carousel_error_button => 'Proovi uuesti';

  @override
  String get carousel_unknown_product_header => 'Tundmatu toode';

  @override
  String get carousel_unknown_product_title =>
      'Palju õnne!\nOled leidnud __haruldase pärli!__';

  @override
  String get carousel_unknown_product_text =>
      'Meie koostöös loodud andmebaas sisaldab üle **3 miljoni toote**, aga seda vöötkoodi pole olemas: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'Teabe laadimine...';

  @override
  String get carousel_loading_title =>
      'Oled just skanninud toote järgmise vöötkoodiga:';

  @override
  String get carousel_loading_text =>
      'Otsime seda oma andmebaasist, mis sisaldab üle **3 miljoni toote**!';

  @override
  String get product_type_subtitle_food =>
      'Köögiviljad, puuviljad, külmutatud toit…';

  @override
  String get product_type_subtitle_beauty => 'Meik, seebid, hambapastad…';

  @override
  String get product_type_subtitle_pet_food => 'Koerte, kasside toit…';

  @override
  String get product_type_subtitle_product => 'Nutitelefonid, mööbel…';

  @override
  String get photo_field_front => 'Toote foto';

  @override
  String get photo_field_ingredients => 'Koostisosade foto';

  @override
  String get photo_field_nutrition => 'Toitumisfoto';

  @override
  String get photo_field_packaging => 'Foto ringlussevõtu juhistest';

  @override
  String get photo_already_exists => 'See foto on juba olemas';

  @override
  String get photo_missing => 'See foto puudub';

  @override
  String get date => 'Kuupäev';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'Eelmise toimingu tagasivõtmine';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Maailmakaart $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMapi kaastöölised';

  @override
  String get not_applicable_short => 'Pole kohaldatav';

  @override
  String get knowledge_panel_warning_text => 'Warning';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Miks see Nutri-Score pakendil olevast erineb?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Sellel võib olla kaks võimalikku selgitust:\nKoostisosade loetelu ja/või toitumisalane teave ei ole ajakohane.\n\nPakume Nutri-Score\'i (või V2) uut arvutust. Palun kontrollige, kas pakendil on silt „Uus arvutus“.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Kontrolli koostisosi';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Kontrollige toitumisalast teavet';

  @override
  String url_not_supported(String url) {
    return 'Kahjuks ei saa me URL-i avada:\n$url';
  }

  @override
  String get product_list_export => 'Eksport';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'Vaata vöötkoodi';

  @override
  String get product_footer_action_barcode_short => 'Triipkood';

  @override
  String get product_footer_action_open_website => 'Ava veebileht';

  @override
  String get product_footer_action_report => 'Aruanne';

  @override
  String get product_footer_action_contributor_guide => 'Abi';

  @override
  String get product_footer_action_data_quality_tags => 'Andmete kvaliteet';

  @override
  String get product_page_tab_for_me => 'Minu jaoks';

  @override
  String get product_page_tab_website => 'Veebisait';

  @override
  String get product_page_tab_prices => 'Hinnad';

  @override
  String get prices_explanation_card_title => 'Miks hinnad?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** on projekt, mille eesmärk on koguda ja jagada toodete hindu üle maailma 🌍. Open Pricesi arendab ja haldab Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Lisateave';

  @override
  String get product_page_tab_folksonomy => 'Folksonoomia';

  @override
  String get folksonomy_explanation_card_title =>
      'Mis on folksonoomia atribuudid?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atribuudid on **võtme-väärtuse** põhised.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Need omadused loovad ja esitavad kaastöölised mis tahes otstarbeks.';

  @override
  String get folksonomy_action_external_link_title => 'Ava väline link';

  @override
  String get folksonomy_action_external_link_warning =>
      'Välised lingid võivad olla ohtlikud. Kas soovite neid tõesti külastada?';

  @override
  String get prices_products_empty_title => 'Hinda pole saadaval';

  @override
  String get prices_products_empty_explanation =>
      'Ole esimene, kes osaleb ja täiendab andmeid!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Parimad $pageSize tooted (kokku: $total)';
  }

  @override
  String get app_review_title => 'Kas sulle meeldib see rakendus?';

  @override
  String get app_review_low => 'Võiks paremini teha';

  @override
  String get app_review_medium => 'Pole paha';

  @override
  String get app_review_high => 'Ma armastan seda!';

  @override
  String get app_review_feedback_modal_title =>
      'Aidake meil oma rakendust täiustada';

  @override
  String get app_review_feedback_modal_content =>
      'Kui teil on paar minutit aega, palun vastake sellele vormile, et **saaksime tulevasi uuendusi paremaks muuta**:';

  @override
  String get app_review_feedback_modal_open_form => 'Vasta vormile';

  @override
  String get app_review_feedback_modal_later => 'Küsi hiljem';

  @override
  String get nutrition_facts_extract_new =>
      'UUS: Saate pildilt toitained automaatselt eraldada!';

  @override
  String get nutrition_facts_extract_button_text => 'Väljavõte kohe';

  @override
  String get nutrition_facts_extract_in_progress =>
      'Lahtipakkimine on pooleli…';

  @override
  String get nutrition_facts_extract_successful => 'Lahtipakkimine õnnestus';

  @override
  String get nutrition_facts_extract_failed =>
      'Pildilt toitainete eraldamine ebaõnnestus.';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Statistika';

  @override
  String get prices_stats_title => 'Hinnastatistika';

  @override
  String get prices_stats_prices_section => 'Hinnad';

  @override
  String get prices_stats_products_section => 'Tooted';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Muu';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Toit';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Tooted';

  @override
  String get prices_stats_pet_food => 'Lemmikloomatoit';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Riigid';

  @override
  String get prices_stats_price_tag => 'Hinnasilt';

  @override
  String get prices_stats_receipt => 'Kviitung';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Veebisait';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'Viimati uuendatud';

  @override
  String get prices_stats_error => 'Statistika laadimisel ilmnes viga.';

  @override
  String get product_edit_robotoff_question_answered => 'Küsimusele vastatud!';

  @override
  String get product_edit_robotoff_proof => 'Tõestus';

  @override
  String get preferences_card_general => 'Üldine';

  @override
  String get preferences_prices_title => 'Hinnad';

  @override
  String get preferences_prices_subtitle => 'Halda oma hinnaeelistusi';

  @override
  String get preferences_card_project => 'Avatud toidufaktide projekt';

  @override
  String get preferences_contribute_title => 'Tee kaastööd';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'Minu statistika';

  @override
  String get preferences_contribute_subtitle =>
      'Tõlgi, täiustage oma tarvikuid…';

  @override
  String get preferences_connect_title => 'Ühenda';

  @override
  String get preferences_connect_subtitle =>
      'Võtke meiega ühendust või jälgige meid sotsiaalmeedias';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Aidake meil teavitada miljoneid tarbijaid üle maailma';

  @override
  String get preferences_card_help => 'Abi ja tugi';

  @override
  String get preferences_faq_title => 'KKK';

  @override
  String get preferences_faq_subtitle => 'Saage vastuseid oma küsimustele';

  @override
  String get logged_out => 'Välja logitud';

  @override
  String get preferences_app_bar_message => 'Täname, et olete meie liige!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Kuva kõik statistikad';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Otsi $provider märksõna \"$keyword\" jaoks';
  }

  @override
  String get preferences_app_bar_search_hint => 'Otsi seadet (nt Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Ligipääsetavus: kuva emotikone';

  @override
  String get preferences_accessibility_remove_colors =>
      'Ligipääsetavus: värvide eemaldamine';

  @override
  String get preferences_app_settings_products => 'Tooted';

  @override
  String get preferences_card_about => 'Info';

  @override
  String get preferences_legal_information_title => 'Õiguslik teave';

  @override
  String get preferences_legal_information_subtitle =>
      'Kasutustingimused, privaatsuspoliitika ja muu';

  @override
  String get preferences_terms_of_use => 'Kasutustingimused';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts on toiduainete andmebaas, **mille on loonud kõik ja kõigile**.\nSaad seda kasutada paremate toiduvalikute tegemiseks ja kuna tegemist on **avatud andmetega**, saab igaüks seda **mis tahes otstarbel taaskasutada**.';

  @override
  String get preferences_privacy_policy => 'Privaatsuspoliitika';

  @override
  String get preferences_licenses => 'Litsentsid';

  @override
  String get preferences_about_app_title => 'Rakenduse kohta';

  @override
  String get preferences_about_app_subtitle =>
      'Tehniline teave, arendaja teave ja muu';

  @override
  String get preferences_card_information => 'Informatsioon';

  @override
  String get preferences_version_number_title => 'Versiooninumber';

  @override
  String get preferences_scanner_title => 'Skanneri';

  @override
  String get preferences_app_store => 'Rakenduste pood';

  @override
  String get preferences_app_system_settings => 'Süsteemi seaded';

  @override
  String get preferences_source_code => 'Juurdepääs lähtekoodile';

  @override
  String get preferences_source_code_subtitle =>
      'Ja hakake miljonite inimeste heaks mõju avaldama';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Täienda tooteandmeid';

  @override
  String get preferences_tips => 'Näpunäited';

  @override
  String get tips_discover_nutriscore => 'Avastage uus Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Avatud toidufaktide veebisaidil';

  @override
  String get preferences_manage_account_title => 'Halda minu kontot';

  @override
  String get preferences_manage_account_tooltip => 'Halda oma kasutajakontot';

  @override
  String get preferences_change_password_title => 'Muuda minu salasõna';

  @override
  String get preferences_danger_zone => 'Ohutsoon';

  @override
  String get preferences_account_deletion_subtitle =>
      'Kõik teie panused lähevad kaotsi';

  @override
  String get preferences_contributions_title => 'Panused';

  @override
  String get preferences_dev_mode_app_settings_title => 'Rakenduse seaded';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Väga eksperimentaalne viis toodete võrguühenduseta skannimiseks';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Värskenda kõiki tooteid serverist';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Palun vältige seda, kui see pole hädavajalik';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demorežiim';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Lisage kaarte skannerisse';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Lisab skannerisse 3 näidisprodukti';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Folksonomy peremees';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Host: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Ligipääsetavuse katsed';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Mitme toote valik vastavalt hindadele';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Kasutaja järjestatud teadmuspaneelid';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Ajutine juurdepääs asukohaotsingule';

  @override
  String get preferences_dev_mode_comparison_title =>
      '2 või 3 toote kõrvuti võrdlus';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Tooteloendi import';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Hinded ja metoodikad';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Avastage, kuidas Nutri-Score\'i arvutatakse';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Avastage metoodika peamised muudatused';

  @override
  String get preferences_faq_discover_project_title => 'Discover the project';

  @override
  String get preferences_faq_discover_off_title =>
      'Avastage avatud toidufaktid';

  @override
  String get preferences_faq_discover_obf_title => 'Avastage avatud ilufaktid';

  @override
  String get preferences_faq_discover_opff_title =>
      'Avastage lemmikloomatoitude fakte';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Avastage avatud toodete fakte';

  @override
  String get preferences_faq_faq_title => 'KKK - Korduma kippuvad küsimused';

  @override
  String get preferences_faq_off_ngo_title => 'Avatud toidufaktide vabaühendus';

  @override
  String get preferences_about_information_title => 'Informatsioon';

  @override
  String get preferences_connect_community_updates_title =>
      'Saa kogukonna värskendusi';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Püsige kursis rakenduse ja kogukonna uudistega';

  @override
  String get preferences_connect_community_calendar_title =>
      'Liitu meie kogukonna kalendriga';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Osale ühel meie virtuaalsel üritusel';

  @override
  String get preferences_connect_blog_title => 'Avatud toidufaktide ajaveeb';

  @override
  String get preferences_connect_blog_subtitle =>
      'Hankige värskeimad uudised kohe, kui need juhtuvad';

  @override
  String get preferences_connect_community_help_title =>
      'Hankige abi kogukonnalt';

  @override
  String get preferences_connect_improve_app_title =>
      'Aidake meil rakendust täiustada';

  @override
  String get preferences_connect_debug_info_title =>
      'Saatke meile silumisteavet';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Saatke meile e-kiri üksikasjaliku veaotsingu teabega';

  @override
  String get preferences_connect_feedback_title =>
      'Saatke meile rakenduse kohta tagasisidet';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Aita kujundada rakenduse tulevikku';

  @override
  String get preferences_connect_survey_title => 'Osale rakenduse küsitluses';

  @override
  String get preferences_connect_survey_subtitle =>
      'Aidake meil mõista, mida peaksime järgmiseks ehitama';

  @override
  String get preferences_connect_professionals_title => 'Spetsialistid';

  @override
  String get preferences_connect_pro_subtitle =>
      'Täiesti tasuta, tagab täpsed andmed 500 rakenduse ja miljonite tarbijate jaoks. Iseteeninduslik, ühildub teie PIM-i või arvutustabelitega (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Alustamiseks võtke ühendust';

  @override
  String get preferences_connect_press_title => 'Press';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Hankige kogu oma aruande jaoks vajalik materjal';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Võtke meiega ühendust pressipäringute või oma raporti kohta lisateabe saamiseks';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Hakka aktiivseks vabatahtlikuks';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Arendus, suhtlus, disain… Igasugune vabatahtlik töö või oskusteave on teretulnud!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Avasta mõned paljudest viisidest, kuidas saad osaleda';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Mobiilirakenduste arendus';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Siit saad teada, kuidas osaleda tarkvaraarenduses';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Igapäevased ebastabiilsed versioonid, täiesti uued funktsioonid';

  @override
  String get preferences_contribute_local_community_title =>
      'Kasvata oma kohalikku kogukonda';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Abi tarkvara, sisu ja koostisosade analüüsi tõlkimisel';

  @override
  String get preferences_contribute_share_subtitle =>
      'Oleme abiks sulle väikese malli ette valmistanud :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Lihtsad sammud toidu läbipaistvuse suurendamiseks sinu riigis';

  @override
  String get preferences_contribute_data_quality_title => 'Andmete kvaliteet';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Liitu andmekvaliteedi meeskonnaga';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Liitu meie pingutustega, et tagada andmebaasi terviklikkus ja täpsus';

  @override
  String get preferences_contributions_products_added_title => 'Lisatud tooted';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Uued tooted, mille lisasin Open Food Factsi';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Tooted, mis mul vaja valmis saada';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Kõik mittetäielikud tooted';

  @override
  String get preferences_my_contributions_prices_title => 'Hinnad';

  @override
  String get preferences_my_contributions_my_prices_title => 'Minu hinnad';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Minu hinnad, minu tõestused…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Tooted, mille valmimisel saate abiks olla';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Aita arvutada oma riigi Nutri-Score\'i ja Green-Score\'i';

  @override
  String get preferences_prices_user_prices_subtitle => 'Minu lisatud hinnad';

  @override
  String get preferences_prices_proofs_subtitle => 'Hinnasildid ja kviitungid';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Tehke oma kviitungitest fotosid ja skannige nendega seotud triipkoode';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Tehke poes hindu pildistades';

  @override
  String get preferences_prices_newest_title => 'Uusimad hinnad';

  @override
  String get preferences_prices_newest_subtitle =>
      'Open Prices kogukonna lisatud uusimad hinnad';

  @override
  String get preferences_prices_top_contributors_title =>
      'Kõige rohkem hindu pakkunud kaastöölised';

  @override
  String get preferences_prices_metrics_title => 'Avatud hinna mõõdikud';

  @override
  String get preferences_prices_metrics_subtitle => 'Jälgige projekti arengut';

  @override
  String get preferences_prices_ways_contribute_title => 'Osalemise viisid';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Kinnitage tehisintellekti abil enda või teiste lisatud hindu';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Lisage oma kaamerarullist kiiresti palju kviitungeid või riiulite fotosid';

  @override
  String get preferences_prices_challenges_title => 'Igakuised väljakutsed';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Osale igakuistes temaatilistes ülesannetes, et koguda auhindu';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Nõua oma lojaalsusandmed tagasi';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Siit saate teada, kuidas oma andmeid taotleda';

  @override
  String get preferences_page_customize_app_title => 'Rakenduse kohandamine';

  @override
  String get preferences_page_contribute_project_title =>
      'Tee sellele projektile kaastööd';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Lihtsad viisid Open Food Factsi abistamiseks';

  @override
  String get preferences_page_faq_subtitle =>
      'Hindamismetoodikad, abi ja lisateavet projekti kohta';

  @override
  String get product_edit_robotoff_positive_button => 'Nõustu soovitusega';

  @override
  String get product_edit_robotoff_negative_button => 'Keeldu soovitusest';

  @override
  String get product_edit_robotoff_show_proof => 'Näita tõendit';

  @override
  String get product_edit_robotoff_expand_proof => 'Laienda tõestust';

  @override
  String get product_page_tab_raw_data => 'Toorandmed';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Lehekülg $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Lehekülg $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count $total esemest';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count $total esemest';
  }

  @override
  String item_count(int count) {
    return '$count eset';
  }

  @override
  String item_count_string(String count) {
    return '$count eset';
  }

  @override
  String get prices_no_result => 'Hinnastatistikat ei leitud.';

  @override
  String get prices_error_loading_more_items =>
      'Viga rohkemate üksuste laadimisel';

  @override
  String get prices_proof_error =>
      'Autentimine ebaõnnestus, tõendite hankimine ebaõnnestus.';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count $total tõestusest';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count / $total kaasautorist';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count / $total asukohast';
  }

  @override
  String prices_locations_count(int count) {
    return '$count asukohta';
  }

  @override
  String get restart_to_apply_message =>
      'Muudatuste rakendamiseks taaskäivitage rakendus.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Graafiline liides';

  @override
  String get preferences_app_settings_media_title => 'Meedia';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Avatud toidufaktide laborid';

  @override
  String get preferences_root_account_title => 'Konto';

  @override
  String get preferences_contribute_translate_header =>
      'Tõlgi Open Food Facts oma keelde';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Registreeru rakenduse alfaversiooni kasutajaks';

  @override
  String get preferences_dev_mode_section_data => 'Kaastööd ja tooteandmed';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Ära näita folksonoomiat';

  @override
  String get preferences_account_title => 'Konto';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Lisatud $created';
  }

  @override
  String get location_map_details_title => 'Asukoha üksikasjad';

  @override
  String get location_map_details_name => 'Nimi';

  @override
  String get location_map_details_street => 'Tänav';

  @override
  String get location_map_details_city => 'Linn';

  @override
  String get location_map_details_postcode => 'Postiindeks';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Koordinaadid';

  @override
  String get location_map_details_osm_id => 'OSM-i ID';
}
