// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Ja';

  @override
  String get add => 'Hinzufügen';

  @override
  String get account_delete_message =>
      'Möchten Sie Ihr Konto wirklich löschen?\nWenn es einen bestimmten Grund gibt, teilen Sie ihn uns bitte unten mit';

  @override
  String get reason => 'Grund';

  @override
  String get okay => 'Okay';

  @override
  String get validate => 'Bestätigen';

  @override
  String get create => 'Erstellen';

  @override
  String get applyButtonText => 'Übernehmen';

  @override
  String get next_label => 'Weiter';

  @override
  String get continue_label => 'Weiter';

  @override
  String get exit_label => 'Beenden';

  @override
  String get previous_label => 'Zurück';

  @override
  String get go_back_to_top => 'Zurück zum Anfang';

  @override
  String get save => 'Speichern';

  @override
  String get save_confirmation => 'Möchten Sie wirklich speichern?';

  @override
  String get skip => 'Überspringen';

  @override
  String get cancel => 'Abbrechen';

  @override
  String get ignore => 'Ignorieren';

  @override
  String get close => 'Schließen';

  @override
  String get no => 'Nein';

  @override
  String get stop => 'Stopp';

  @override
  String get finish => 'Fertig';

  @override
  String get calculate => 'Berechnen';

  @override
  String get reset_food_prefs => 'Lebensmittelvorlieben zurücksetzen';

  @override
  String get error => 'Ein Problem ist aufgetreten';

  @override
  String get error_occurred => 'Ein Fehler ist aufgetreten';

  @override
  String get featureInProgress =>
      'Wir arbeiten noch an dieser Funktion, bitte gedulden Sie sich';

  @override
  String get label_web => 'Im Browser anschauen';

  @override
  String get learnMore => 'Erfahren Sie mehr';

  @override
  String get unknown => 'Unbekannt';

  @override
  String get match_very_good => 'Sehr gute Übereinstimmung';

  @override
  String get match_good => 'Guter Treffer';

  @override
  String get match_poor => 'Schlechter Treffer';

  @override
  String get match_may_not => 'Stimmt möglicherweise nicht überein';

  @override
  String get match_does_not => 'Stimmt nicht überein';

  @override
  String get match_unknown => 'Unbekanntes Produkt';

  @override
  String get match_short_very_good => 'Sehr gute Übereinstimmung';

  @override
  String get match_short_good => 'Guter Treffer';

  @override
  String get match_short_poor => 'Schlechter Treffer';

  @override
  String get match_short_may_not => 'Stimmt möglicherweise nicht überein';

  @override
  String get match_short_does_not => 'Stimmt nicht überein';

  @override
  String get match_short_unknown => 'Unbekanntes Produkt';

  @override
  String get licenses => 'Lizenzen';

  @override
  String get looking_for => 'Suche nach';

  @override
  String get welcomeToOpenFoodFacts => 'Willkommen bei Open Food Facts';

  @override
  String get whatIsOff =>
      'OpenFoodFacts ist eine globale, gemeinnützige Organisation, die von lokalen Gemeinschaften getragen wird.';

  @override
  String get productDataUtility =>
      'Lassen Sie sich die für Ihre Vorlieben relevanten Lebensmitteldaten anzeigen.';

  @override
  String get healthCardUtility =>
      'Wählen Sie Lebensmittel, die gut für Sie sind.';

  @override
  String get ecoCardUtility =>
      'Wählen Sie die Lebensmittel, die gut für den Planeten sind.';

  @override
  String get server_error_open_new_issue =>
      'Keine Serverantwort! Sie können ein Problem unter dem folgenden Link melden.';

  @override
  String get sign_in_text =>
      'Melden Sie sich bei Ihrem OpenFoodFacts Konto an, um Ihre Beiträge speichern zu können';

  @override
  String get incorrect_credentials => 'Ungültiger Benutzername oder Passwort.';

  @override
  String get password_lost_incorrect_credentials =>
      'Diese E-Mail-Adresse oder dieser Benutzername existiert nicht. Bitte überprüfen Sie Ihre Anmeldedaten.';

  @override
  String get password_lost_server_unavailable =>
      'Zurzeit kommt es auf unseren Servern zu Verzögerungen, für die wir uns entschuldigen. Bitte versuchen Sie es später noch einmal.';

  @override
  String get login => 'Anmelden';

  @override
  String get login_result_type_server_unreachable =>
      'Netzwerk ist nicht erreichbar';

  @override
  String get login_result_type_server_issue =>
      'Problem auf dem Server. Bitte versuchen Sie es später noch einmal.';

  @override
  String get login_page_username_or_email =>
      'Bitte Benutzername oder E-Mail eingeben';

  @override
  String get login_page_password_error_empty =>
      'Bitte geben Sie ein Passwort ein';

  @override
  String get create_account => 'Konto erstellen';

  @override
  String get sign_in => 'Anmelden';

  @override
  String get sign_in_mandatory =>
      'Für diese Funktion müssen Sie sich anmelden.';

  @override
  String get help_improve_country =>
      'Helfen Sie mit, Open Food Facts in Ihrem Land zu verbessern';

  @override
  String get sign_out => 'Abmelden';

  @override
  String get sign_out_confirmation => 'Möchten Sie sich wirklich abmelden?';

  @override
  String get password => 'Passwort';

  @override
  String get forgot_password => 'Passwort vergessen';

  @override
  String get forgot_password_question => 'Passwort vergessen?';

  @override
  String get view_profile => 'Profil anzeigen';

  @override
  String get reset_password => 'Passwort zurücksetzen';

  @override
  String get reset_password_explanation_text =>
      'Wenn Sie Ihr Passwort vergessen haben, geben Sie Ihren Benutzernamen oder Ihre E-Mail-Adresse ein, um Anweisungen zum Zurücksetzen des Passworts zu erhalten. Denken Sie auch daran, den Spam-Ordner zu überprüfen.';

  @override
  String get username_or_email => 'Benutzername oder E-Mail-Adresse';

  @override
  String get reset_password_done =>
      'Eine E-Mail mit einem Link zum Zurücksetzen Ihres Passworts wurde an die mit Ihrem Konto verknüpfte E-Mail-Adresse gesendet. Überprüfen Sie auch Ihren Spam-Ordner.';

  @override
  String get send_reset_password_mail => 'Passwort ändern';

  @override
  String get enter_some_text => 'Bitte geben Sie etwas ein';

  @override
  String get sign_up_page_title => 'Registrieren';

  @override
  String get sign_up_page_action_button => 'Registrieren';

  @override
  String get sign_up_page_action_doing_it => 'Anmeldung';

  @override
  String get sign_up_page_action_ok =>
      'Herzlichen Glückwunsch! Ihr Konto wurde erstellt.';

  @override
  String get sign_up_page_display_name_hint => 'Name';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Bitte geben Sie den zu verwendenden Anzeigenamen ein';

  @override
  String get sign_up_page_email_hint => 'E-Mail-Adresse';

  @override
  String get sign_up_page_email_error_empty => 'E-Mail-Adresse erforderlich';

  @override
  String get sign_up_page_email_error_invalid => 'Ungültige E-Mail-Adresse';

  @override
  String get sign_up_page_username_hint => 'Benutzername: Öffentlich sichtbar';

  @override
  String get sign_up_page_username_error_empty =>
      'Bitte geben Sie einen Benutzernamen ein';

  @override
  String get sign_up_page_username_error_invalid =>
      'Bitte geben Sie einen gültigen Benutzernamen ein';

  @override
  String get sign_up_page_username_description =>
      'Der Benutzername darf keine Leerzeichen, Großbuchstaben oder Sonderzeichen enthalten.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Der Benutzername darf nicht mehr als $value Zeichen enthalten';
  }

  @override
  String get sign_up_page_password_hint => 'Passwort';

  @override
  String get sign_up_page_password_error_empty =>
      'Bitte geben Sie ein Passwort ein';

  @override
  String get sign_up_page_password_error_invalid =>
      'Bitte geben Sie ein gültiges Passwort ein (mindestens 6 Zeichen)';

  @override
  String get sign_up_page_confirm_password_hint => 'Passwort bestätigen';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Bitte bestätigen Sie Ihr Passwort';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Passwörter stimmen nicht überein';

  @override
  String get sign_up_page_agree_text => 'Ich stimme OpenFoodFacts zu';

  @override
  String get sign_up_page_terms_text =>
      'Nutzungsbedingungen von Open Food Facts zu';

  @override
  String get donate_url => 'https://world-de.openfoodfacts.org/spenden';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Bei der Erstellung eines Kontos ist die Zustimmung der Nutzungsbedingungen erforderlich. Anonyme Beiträge können jedoch weiterhin über die App eingereicht werden';

  @override
  String get sign_up_page_producer_checkbox => 'Ich bin Lebensmittelproduzent';

  @override
  String get sign_up_page_producer_hint => 'Hersteller/Marke';

  @override
  String get sign_up_page_producer_error_empty =>
      'Bitte geben Sie einen Hersteller oder Markennamen ein';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Ich möchte den Newsletter von OpenFoodFacts abonnieren (Er kann jederzeit wieder abbestellt werden)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Der Benutzername existiert bereits. Bitte wählen Sie einen anderen Benutzernamen.';

  @override
  String get sign_up_page_email_already_exists =>
      'existiert bereits. Melden Sie sich bei diesem Konto an oder versuchen Sie es mit einer anderen E-Mail-Adresse.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Bitte geben Sie eine gültige E-Mail-Adresse ein.';

  @override
  String get sign_up_page_server_busy =>
      'Es tut uns sehr leid, dass wir haben technische Schwierigkeiten Ihr Konto zu erstellen. Bitte versuchen Sie es später noch einmal.';

  @override
  String get settingsTitle => 'Einstellungen';

  @override
  String get darkmode => 'Farbschema';

  @override
  String get darkmode_dark => 'Dunkel';

  @override
  String get darkmode_light => 'Hell';

  @override
  String get darkmode_system_default => 'Systemstandard';

  @override
  String get thanks_for_contributing => 'Vielen Dank für Ihren Beitrag!';

  @override
  String get contributors_label => 'Diese Leute entwickeln die App';

  @override
  String get contributors_dialog_title => 'Mitwirkende';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Mitwirkende: $name';
  }

  @override
  String get contributors_description =>
      'Eine Liste aller Mitwirkenden an dieser App';

  @override
  String get support => 'Kundenservice';

  @override
  String get support_join_slack => 'Bitte um Hilfe in unserem Slack-Kanal';

  @override
  String get support_via_forum => 'Bitten Sie um Hilfe in unserem Forum';

  @override
  String get support_via_email => 'Senden Sie uns eine E-Mail';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Protokolle der App senden?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Möchten Sie Ihrer E-Mail ein Protokoll der Anwendung als Anhang beifügen?';

  @override
  String get termsOfUse => 'Nutzungsbedingungen';

  @override
  String get legalNotices => 'Rechtliche Hinweise';

  @override
  String get privacy_policy => 'Datenschutzrichtlinien';

  @override
  String get about_this_app => 'Über diese App';

  @override
  String get contribute => 'Mitwirken';

  @override
  String get contribute_sw_development => 'Softwareentwicklung';

  @override
  String get contribute_develop_text =>
      'Der Code für jedes OpenFoodFacts Produkt ist auf GitHub verfügbar. Sie können den Code (Open Source) gerne wiederverwenden und uns dabei helfen, ihn für alle auf der ganzen Welt zu verbessern.';

  @override
  String get contribute_develop_text_2 =>
      'Du kannst dem Open Food Facts Slack Chatroom beitreten, was der bevorzugte Weg ist, Fragen zu stellen.';

  @override
  String get contribute_develop_dev_mode_title => 'Entwicklermodus?';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'Entwicklermodus aktivieren';

  @override
  String get contribute_donate_title => 'Spenden';

  @override
  String get contribute_donate_header => 'Spenden Sie an Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Bitte beachten Sie, dass bei der internen Alpha-Version ein vollständiger Datenverlust möglich ist und die App jederzeit unbrauchbar werden kann!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Zu vervollständigende Produkte';

  @override
  String get contribute_improve_header => 'Verbessern';

  @override
  String get contribute_improve_text =>
      'Die Datenbank ist der Kern des Projekts. Sie können einfach und schnell helfen. Sie können die mobile App für Ihr Telefon herunterladen und Produkte hinzufügen oder verbessern.\n\nAuf der anderen Seite bietet die OpenFoodFacts Website viele Möglichkeiten, einen Beitrag zu leisten: ';

  @override
  String get contribute_translate_header => 'Übersetzen';

  @override
  String get contribute_data_quality => 'Datenqualität';

  @override
  String get contribute_translate_link_text => 'Mit dem Übersetzen beginnen';

  @override
  String get contribute_translate_text =>
      'Open Food Facts ist ein globales Projekt, das Produkte aus über 160 Länder enthält. OpenFoodFacts wird in eine Vielzahl von Sprachen, mit ständig wachsendem Inhalt übersetzt.';

  @override
  String get contribute_translate_text_2 =>
      'Übersetzungen sind eine der Hauptaufgaben des Projekts';

  @override
  String get contribute_join_skill_pool =>
      'Tragen Sie mit Ihren Fähigkeiten zu Open Food Facts bei. Treten Sie dem Kompetenzpool bei!';

  @override
  String get contribute_share_header =>
      'Teilen Sie Open Food Facts mit Ihren Freunden';

  @override
  String get contribute_share_content =>
      'Ich möchte Ihnen die App OpenFoodFacts vorstellen, mit der Sie die Gesundheits- und Umweltauswirkungen Ihrer Lebensmittel auf personalisierte Weise ermitteln können. Es funktioniert durch das Einlesen der Barcodes auf den Verpackungen. Es ist kostenlos, erfordert keine Registrierung und Sie können sogar dazu beitragen, die Zahl der entschlüsselten Produkte zu erhöhen. Hier ist der Link, über den Sie die Software für Ihr Handy erhalten: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Tragen Sie zu den Preisen bei, indem Sie einen GDPR-Export Ihrer Treuekartendaten beantragen';

  @override
  String get tap_to_answer => 'Tippen Sie hier, um Fragen zu beantworten';

  @override
  String get tap_to_answer_hint =>
      'Tippe hier, um Fragen zu diesem Produkt zu beantworten';

  @override
  String get robotoff_questions_loading_hint =>
      'Bitte warten Sie, während Fragen zu diesem Produkt geladen werden';

  @override
  String get saving_answer => 'Ihre Antwort wird gespeichert';

  @override
  String get contribute_to_get_rewards =>
      'Werden Sie ein Akteur der Lebensmitteltransparenz';

  @override
  String get question_sign_in_text =>
      'Melden Sie sich bei Ihrem Open Food Facts-Konto an, um eine Gutschrift für Ihre Beiträge zu erhalten';

  @override
  String get question_yes_button_accessibility_value => 'Mit „Ja” antworten';

  @override
  String get question_no_button_accessibility_value => 'Mit „Nein” antworten';

  @override
  String get question_skip_button_accessibility_value =>
      'Diese Frage überspringen';

  @override
  String get tap_to_edit_search => 'Tippen, um Suche zu bearbeiten';

  @override
  String get myPreferences => 'Meine Einstellungen';

  @override
  String get account_create_message =>
      'Erstellen Sie Ihr Konto und treten Sie der Open Food Facts-Community bei, um das Wissen über Lebensmittel auf der ganzen Welt zu verbessern!';

  @override
  String get join_us => 'Machen Sie mit';

  @override
  String get myPreferences_profile_title => 'Mein Profil';

  @override
  String get myPreferences_profile_subtitle =>
      'Verwalten Sie Ihr Open Food Facts Konto.';

  @override
  String get myPreferences_settings_title => 'App-Einstellungen';

  @override
  String get myPreferences_settings_subtitle => 'Dunkler Modus, Sprachen ...';

  @override
  String get myPreferences_food_title => 'Lebensmittelvorlieben';

  @override
  String get myPreferences_food_subtitle =>
      'Wählen Sie aus, welche Informationen über Lebensmittel für Sie am wichtigsten sind.';

  @override
  String get myPreferences_food_comment =>
      'Wählen Sie aus, welche Informationen über Lebensmittel für Sie am wichtigsten sind, um Lebensmittel nach Ihren Vorlieben zu ordnen, die für Sie wichtigen Informationen zuerst zu sehen und eine Kompatibilitätsübersicht zu erhalten. Diese Lebensmittelpräferenzen verbleiben auf Ihrem Gerät und werden nicht mit Ihrem Open Food Facts-Mitarbeiterkonto verknüpft, falls Sie eines eingerichtet haben.';

  @override
  String get confirmResetPreferences => 'Lebensmittelvorlieben zurücksetzen?';

  @override
  String get myPersonalizedRanking => 'Mein persönliches Ranking';

  @override
  String get ranking_tab_all => 'Alle';

  @override
  String get ranking_subtitle_match_yes => 'Eine gute Wahl für Sie';

  @override
  String get ranking_subtitle_match_no => 'Sehr schlechte Übereinstimmung';

  @override
  String get ranking_subtitle_match_maybe => 'Unbekanntes Produkt';

  @override
  String get refresh_with_new_preferences =>
      'Aktualisieren Sie die Liste mit Ihren neuen Einstellungen';

  @override
  String get reloaded_with_new_preferences =>
      'Mit Ihren neuen Einstellungen neu geladen';

  @override
  String get profile_navbar_label => 'Gemeinschaft';

  @override
  String get scan_navbar_label => 'Einlesen';

  @override
  String get history_navbar_label => 'Verlauf';

  @override
  String get list_navbar_label => 'Listen';

  @override
  String get category => 'Nach Kategorie filtern';

  @override
  String get category_all => 'Alle';

  @override
  String get category_search => '(Kategoriesuche)';

  @override
  String get filter => 'Filter';

  @override
  String get scan => 'Produkte aus dem Bildschirm „Scannen”';

  @override
  String get scan_history => 'Scanverlauf';

  @override
  String get search => 'Suchen';

  @override
  String get search_product_help =>
      'Suche ein Produkt,\neine Marke oder einen Barcode';

  @override
  String get search_filter => 'Suchfilter';

  @override
  String get search_history => 'Suchverlauf';

  @override
  String get search_store => 'Nach einem Store suchen';

  @override
  String get search_store_help =>
      'Hinweis: Fügen Sie die Stadt oder das Land hinzu.';

  @override
  String get tap_for_more => 'Antippen, um weitere Infos anzuzeigen …';

  @override
  String get product => 'Produkt';

  @override
  String get unknownBrand => 'Unbekannte Marke';

  @override
  String get unknownQuantity => 'Unbekannte Menge';

  @override
  String get unknownProductName => 'Unbekannter Produktname';

  @override
  String get label_refresh => 'Aktualisieren';

  @override
  String get label_reload => 'Neu laden';

  @override
  String get image => 'Bild';

  @override
  String get front_photo => 'Foto der Vorderseite';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (dieses Bild kann veraltet sein)';
  }

  @override
  String get outdated_image_short_label => 'möglicherweise veraltet';

  @override
  String get ingredients => 'Zutaten';

  @override
  String get ingredients_editing_instructions =>
      'Behalten Sie die ursprüngliche Reihenfolge bei. Geben Sie, wenn angegeben, den Prozentsatz an. Trennen Sie mit einem Komma oder Bindestrich und verwenden Sie Klammern für Bestandteile einer Zutat.';

  @override
  String get ingredients_editing_error =>
      'Die Zutaten konnten nicht gespeichert werden.';

  @override
  String get ingredients_editing_image_error =>
      'Fehler beim Abrufen eines neuen Zutatenbildes.';

  @override
  String get ingredients_editing_title => 'Zutaten bearbeiten';

  @override
  String get ingredients_photo => 'Foto der Zutatenliste';

  @override
  String get packaging_editing_instructions =>
      'Führen Sie alle Verpackungsteile durch ein Komma oder einen Zeilenvorschub getrennt auf und geben Sie die Anzahl (z. B. 1 oder 6), die Art (z. B. Flasche, Schachtel, Dose), das Material (z. B. Kunststoff, Metall, Aluminium) und, falls vorhanden, die Größe (z. B. 33cl) sowie Recyclinghinweise an.\nBeispiel: 1 Glasflasche zum Recyceln, 1 Plastikkorken zum Wegwerfen';

  @override
  String get packaging_editing_error => 'Fehler beim Speichern der Verpackung.';

  @override
  String get packaging_editing_image_error =>
      'Neues Foto der Verpackung konnte nicht abgerufen werden.';

  @override
  String get packaging_editing_title => 'Verpackung bearbeiten';

  @override
  String get nutrition => 'Nährwertangaben';

  @override
  String get nutrition_facts_photo => 'Foto der Nährwertangaben';

  @override
  String get nutrition_facts_editing_title => 'Nährwertangaben bearbeiten';

  @override
  String get packaging_information => 'Recyclinghinweise';

  @override
  String get packaging_information_photo => 'Foto der Recycling-Anweisungen';

  @override
  String get missing_product => 'Sie haben eine neues Produkt gefunden!';

  @override
  String get add_product_take_photos =>
      'Fotografieren Sie die Verpackung, um dieses Produkt zu Open Food Facts hinzuzufügen';

  @override
  String get add_product_take_photos_descriptive =>
      'Bitte nehmen Sie zuerst ein paar Fotos auf. Sie können das Produkt jederzeit zu einem späteren Zeitpunkt vervollständigen.';

  @override
  String get add_product_information_button_label =>
      'Produktinformation hinzufügen';

  @override
  String get new_product => 'Neues Produkt';

  @override
  String get new_product_found_title => 'Neues Produkt gefunden!';

  @override
  String get new_product_found_text =>
      'Unsere gemeinschaftliche Datenbank enthält mehr als **3 Millionen Produkte**, aber dieser Strichcode existiert nicht: ';

  @override
  String get new_product_found_button => 'Dieses Produkt hinzufügen';

  @override
  String get new_product_leave_title => 'Diese Seite schließen?';

  @override
  String get new_product_leave_message =>
      'Es sieht so aus, als hätten Sie nichts eingegeben. Möchten Sie diese Seite wirklich verlassen?';

  @override
  String get new_product_dialog_description =>
      'Bitte fotografieren Sie die Verpackung, um dieses Produkt in unsere gemeinsame Datenbank aufnehmen zu können';

  @override
  String get new_product_dialog_illustration_description =>
      'Eine Abbildung mit unbekanntem Nutri-Score und Green Score';

  @override
  String get front_packaging_photo_button_label =>
      'Foto von der Vorderseite des Produkts';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Hochladen des Fotos der Vorderseite des Produkts bestätigen';

  @override
  String get confirm_button_label => 'Bestätigen';

  @override
  String get send_image_button_label => 'Foto senden';

  @override
  String get crop_page_action_saving => 'Bild wird gespeichert …';

  @override
  String get crop_page_action_cropping => 'Bild wird zugeschnitten …';

  @override
  String get crop_page_action_local => 'Lokale Version wird gespeichert …';

  @override
  String get crop_page_action_local_failed_title =>
      'Hoppla... es gibt ein Problem mit Ihrem Foto!';

  @override
  String get crop_page_action_local_failed_message =>
      'Das Bild kann nicht lokal verarbeitet werden, bevor es an unseren Server gesendet wird. Bitte versuchen Sie es später noch einmal oder kontaktieren Sie uns, wenn das Problem weiterhin besteht.';

  @override
  String get crop_page_action_retake => 'Foto erneut aufnehmen';

  @override
  String get crop_page_too_small_image_title => 'Das Bild ist zu klein!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Die Mindestgröße in Pixeln für das Hochladen von Bildern ist $expectedMinWidth×$expectedMinHeight. Das aktuelle Bild hat die Maße $actualWidth×$actualHeight.';
  }

  @override
  String get crop_page_action_server =>
      'Anruf an den Server wird vorbereitet …';

  @override
  String get front_packaging_photo_title =>
      'Foto der Vorderseite der Verpackung';

  @override
  String get ingredients_photo_title => 'Foto der Zutatenliste';

  @override
  String get nutritional_facts_photo_title => 'Foto der Nährwertangaben';

  @override
  String get recycling_photo_title => 'Recyclinghinweise (Foto)';

  @override
  String get take_photo_title => 'Foto aufnehmen';

  @override
  String get take_more_photo_title => 'Weitere Fotos aufnehmen';

  @override
  String get front_photo_uploaded =>
      'Foto der Vorderseite der Verpackung hochgeladen';

  @override
  String get ingredients_photo_button_label => 'Foto der Zutatenliste';

  @override
  String get ingredients_photo_uploaded => 'Foto der Zutatenliste hochgeladen';

  @override
  String get nutrition_cache_loading_error =>
      'Kann Nährstoffe nicht aus Cache laden';

  @override
  String get nutritional_facts_photo_button_label => 'Foto der Nährwertangaben';

  @override
  String get nutritional_facts_input_button_label => 'Nährwertangaben eingeben';

  @override
  String get nutritional_facts_added => 'Nährwertangaben hinzugefügt';

  @override
  String get categories_added => 'Kategorien hinzugefügt';

  @override
  String get new_product_title_nutriscore => 'Nutri-Score berechnen';

  @override
  String get new_product_subtitle_nutriscore =>
      'Sie erhalten sie, indem Sie die Lebensmittelkategorie und die Nährwerte eingeben';

  @override
  String get new_product_title_environmental_score => 'Green Score berechnen';

  @override
  String get new_product_subtitle_environmental_score =>
      'Sie erhalten ihn, indem Sie mindestens eine Kategorie ausfüllen';

  @override
  String get new_product_additional_environmental_score =>
      'Präzisere Berechnung des Green Score mit Herkunft, Verpackung und mehr';

  @override
  String get new_product_title_nova =>
      'Berechnen Sie den Grad der Lebensmittelverarbeitung (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Sie erhalten ihn, indem Sie die Lebensmittelkategorie und die Zutaten eingeben';

  @override
  String get new_product_desc_nova_unknown =>
      'Grad der Lebensmittelverarbeitung unbekannt';

  @override
  String get new_product_title_pictures => 'Neues Produkt';

  @override
  String get new_product_title_pictures_details =>
      'Bitte fotografieren Sie das Folgende und die Open Food Facts Engine erledigt den Rest!';

  @override
  String get new_product_title_misc => 'Und einige grundlegende Daten …';

  @override
  String new_product_done_msg(String username) {
    return '„$username”, vielen Dank für Ihr Mitwirken!';
  }

  @override
  String get new_product_done_msg_no_user => 'Danke für Ihren Beitrag!';

  @override
  String get new_product_done_button_label =>
      'Entdecken Sie das fertige Produkt';

  @override
  String get hey_incomplete_product_message =>
      'Tippen Sie JETZT auf die Antwort auf 3 Fragen, um den Nutri-Score, Green Score und die Ultrahochverarbeitung (NOVA) zu berechnen!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Jetzt antippen, um 2 Fragen zu beantworten, die bei der Analyse dieses Kosmetikprodukts helfen!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Jetzt antippen, um 3 Fragen zu beantworten, die bei der Analyse dieses Tiernahrungsprodukts helfen!';

  @override
  String get hey_incomplete_product_message_product =>
      'Jetzt antippen, um dieses Produkt zu vervollständigen!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Foto mit Nährwertangaben hochgeladen';

  @override
  String get recycling_photo_button_label =>
      'Foto mit Informationen zum Recycling';

  @override
  String get recycling_photo_uploaded =>
      'Foto mit Informationen zum Recycling hochgeladen';

  @override
  String get take_more_photo_button_label => 'Weitere Fotos aufnehmen';

  @override
  String get other_photo_uploaded => 'Sonstiges Foto hochgeladen';

  @override
  String get retake_photo_button_label => 'Erneut aufnehmen';

  @override
  String get selecting_photo => 'Fotos werden ausgewählt …';

  @override
  String get uploading_image => 'Foto wird auf den Server hochgeladen';

  @override
  String get uploading_image_type_front =>
      'Foto der Vorderseite wird zu Open Food Facts hochgeladen';

  @override
  String get uploading_image_type_ingredients =>
      'Foto der Zutaten wird zu Open Food Facts hochgeladen';

  @override
  String get uploading_image_type_nutrition =>
      'Foto der Nährwertangaben wird zu Open Food Facts hochgeladen';

  @override
  String get uploading_image_type_packaging =>
      'Foto der Verpackung wird zu Open Food Facts hochgeladen';

  @override
  String get uploading_image_type_other =>
      'Weiteres Foto wird zu Open Food Facts hochgeladen';

  @override
  String get uploading_image_type_generic =>
      'Foto wird zu Open Food Facts hochladen';

  @override
  String get score_add_missing_ingredients => 'Fehlende Zutaten hinzufügen';

  @override
  String get score_add_missing_packaging_image =>
      'Fehlendes Foto der Verpackung hinzufügen';

  @override
  String get score_add_missing_nutrition_facts =>
      'Fehlende Nährwertangaben hinzufügen';

  @override
  String get score_add_missing_product_traces =>
      'Fehlende Produktmerkmale hinzufügen';

  @override
  String get score_add_missing_product_category =>
      'Fehlende Produktkategorie hinzufügen';

  @override
  String get score_add_missing_precise_product_category =>
      'Wählen Sie eine genauere Kategorie';

  @override
  String get score_add_missing_product_countries =>
      'Fehlende Produktländer hinzufügen';

  @override
  String get score_add_missing_product_emb =>
      'Fehlende Rückverfolgbarkeitscodes fürs Produkt hinzufügen';

  @override
  String get score_add_missing_product_labels =>
      'Fehlende Etiketten für Produkte hinzufügen';

  @override
  String get score_add_missing_product_origins =>
      'Fehlende Herkunft der Produkte hinzufügen';

  @override
  String get score_add_missing_product_stores =>
      'Fehlende Shops für Produkte hinzufügen';

  @override
  String get score_add_missing_product_brands =>
      'Fehlende Produktmarken hinzufügen';

  @override
  String get score_update_nutrition_facts => 'Nährwertangaben aktualisieren';

  @override
  String get nutrition_page_title => 'Nährwertangaben';

  @override
  String get nutrition_page_nutritional_info_title => 'Nährwert-Information';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Auf dem Produkt angegebene Werte:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Ja';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Nein';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Foto öffnen';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Bewährte Methoden: Informationen zum Nährwert';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Mitunter sind die Nährwertangaben **nicht auf der Verpackung** oder auf einem dem Produkt beigefügten Dokument angegeben. In diesem Fall, und nur in diesem Fall, können Sie den Wert auf **NEIN** setzen.';

  @override
  String get nutrition_page_serving_type_label => 'Nährwertangaben:';

  @override
  String get nutrition_page_per_100g => 'pro 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'pro 100g/ml';

  @override
  String get nutrition_page_per_serving => 'pro Portion';

  @override
  String get nutrition_page_add_nutrient => 'Nährstoff hinzufügen';

  @override
  String get nutrition_page_serving_size => 'Portionsgröße';

  @override
  String get nutrition_page_serving_size_hint =>
      'Portionsgröße eingeben (z.B.: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Bewährte Methoden: Portionsgröße';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Dieser Wert hilft bei der **Anteilsberechnung der einzelnen Nährstoffe pro Portionsgröße**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Zulässige Einheiten** sind: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** oder **60 G** (bevorzugt die erste Variante)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** oder **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Ungültige Maßeinheit';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Ungültige Maßeinheiten';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **Bonbons** und 2 **Kekse**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Fehlende Einheit';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Ungültige Nummer';

  @override
  String get nutrition_page_update_running =>
      'Produkt wird auf dem Server aktualisiert…';

  @override
  String get nutrition_page_update_done => 'Produkt aktualisiert!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Verwenden Sie die Produktmenge als Portionsgröße';

  @override
  String get nutrition_page_photo_error => 'Foto konnte nicht geladen werden';

  @override
  String get more_photos => 'Weitere interessante Fotos';

  @override
  String get view_more_photo_button =>
      'Alle vorhandenen Fotos für dieses Produkt anzeigen';

  @override
  String get no_product_found => 'Keine Produkte gefunden';

  @override
  String get no_location_found => 'Kein Standort gefunden';

  @override
  String get not_found => 'Nicht gefunden:';

  @override
  String get refreshing_product => 'Produkt wird aktualisiert';

  @override
  String get product_refreshed => 'Produkt aktualisiert';

  @override
  String product_image_accessibility_label(String date) {
    return 'Foto aufgenommen am $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Foto aufgenommen am $date. Dieses Foto kann veraltet sein';
  }

  @override
  String get product_image_outdated =>
      'Dieses Bild ist möglicherweise veraltet';

  @override
  String get product_image_outdated_explanations_title =>
      'Dieses Bild ist möglicherweise veraltet';

  @override
  String get product_image_outdated_explanations_content =>
      'Dieses Bild wurde vor mehr als einem Jahr aufgenommen.\n**Bitte prüfen Sie, ob es noch aktuell ist**.\n\nDies ist **nur ein Warnhinweis**. Wenn der Inhalt immer noch derselbe ist, können Sie diese Meldung ignorieren.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Foto ersetzen ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Foto hinzufügen ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Neu erfassen';

  @override
  String get product_image_action_take_picture => 'Foto aufnehmen';

  @override
  String get product_image_action_from_gallery =>
      'Wählen Sie aus der Galerie Ihres Telefons';

  @override
  String get product_image_action_choose_existing_photo =>
      'Wählen Sie aus den Produktfotos';

  @override
  String get product_image_details_label => 'Informationen zum Foto';

  @override
  String get product_image_details_from_producer => 'Vom Produzenten';

  @override
  String get product_image_details_contributor => 'Mitwirkende(r)';

  @override
  String get product_image_details_contributor_producer =>
      'Mitwirkende (Produzent)';

  @override
  String get product_image_details_date => 'Datum';

  @override
  String get product_image_details_date_unknown => 'Unbekannt';

  @override
  String get homepage_main_card_logo_description =>
      'Willkommen bei Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Scannen** eines Barcodes oder\n**Suchen** nach einem Produkt';

  @override
  String get homepage_main_card_search_field_hint => 'Produkt suchen';

  @override
  String get homepage_main_card_search_field_tooltip => 'Suche starten';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Neueste Nachrichten: $news_title';
  }

  @override
  String get tagline_app_review => 'Gefällt Ihnen die App?';

  @override
  String get tagline_app_review_button_positive => 'Ich liebe sie! 😍';

  @override
  String get tagline_app_review_button_negative => 'Nicht wirklich …';

  @override
  String get tagline_app_review_button_later => 'Später erneut fragen';

  @override
  String get tagline_feed_news_button => 'Mehr erfahren';

  @override
  String get app_review_negative_modal_title => 'Gefällt Ihnen diese App?';

  @override
  String get app_review_negative_modal_text =>
      'Könnten Sie sich ein paar Sekunden Zeit nehmen und uns sagen, warum?';

  @override
  String get app_review_negative_modal_positive_button => 'Ja, natürlich!';

  @override
  String get app_review_negative_modal_negative_button => 'Nein';

  @override
  String get could_not_refresh => 'Produkt konnte nicht aktualisiert werden';

  @override
  String get product_internet_error_modal_title =>
      'Ein Fehler ist aufgetreten!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Aufgrund eines Netzwerkfehlers konnten keine Informationen zu diesem Produkt abgerufen werden. Bitte überprüfen Sie Ihre Internetverbindung und versuchen Sie es erneut.\n\nInterner Fehler:\n$error';
  }

  @override
  String get product_tags_title => 'Produkteigenschaften';

  @override
  String get no_product_tags_found_message =>
      'Keine Produkteigenschaften gefunden. Eigenschaften können verwendet werden, um Produkte auf flexible Art und Weise detaillierter zu beschreiben. Antippen zum Hinzufügen.';

  @override
  String get product_tags_empty => 'Keine Eigenschaften';

  @override
  String get product_tags_explanation =>
      'Indem Sie einem Produkt Eigenschaften (Schlüssel/Wert) hinzufügen, tragen Sie dazu bei, es zu bereichern.';

  @override
  String get add_tag => 'Eigenschaft hinzufügen';

  @override
  String get add_tags => 'Eigenschaften hinzufügen';

  @override
  String get add_edit_tags => 'Eigenschaften hinzufügen oder bearbeiten';

  @override
  String get edit_tag => 'Eigenschaft bearbeiten';

  @override
  String get remove_tag => 'Eigenschaft entfernen';

  @override
  String get tag_key => 'Eigenschaft';

  @override
  String get tag_keys => 'Eigenschaften';

  @override
  String get tag_key_uneditable => 'Eigenschaft (nicht bearbeitbar)';

  @override
  String get tag_key_input_hint => 'Eigenschaft eingeben';

  @override
  String get tag_value => 'Wert';

  @override
  String get tag_values => 'Werte';

  @override
  String get tag_value_input_hint => 'Wert eingeben';

  @override
  String get tag_key_item => 'Eigenschaft:';

  @override
  String get tag_value_item => 'Wert:';

  @override
  String get tag_key_explanations =>
      'Ein Schlüssel muss in Kleinbuchstaben und ohne Leerzeichen angegeben werden.';

  @override
  String tag_key_already_exists(String property) {
    return 'Ein Tag mit einer Eigenschaft $property existiert bereits!';
  }

  @override
  String get product_internet_error =>
      'Informationen über dieses Produkt können aufgrund eines Netzwerkfehlers nicht abgerufen werden.';

  @override
  String get cached_results_from => 'Ergebnisse anzeigen von:';

  @override
  String get product_search_same_category => 'Alternativen finden';

  @override
  String get product_search_same_category_short => 'Vergleichen';

  @override
  String get product_search_same_category_error =>
      'Diese Funktion kann nur für Produkte denen eine Kategorie zugeordnet ist genutzt werden.\n\nBitte bearbeiten Sie das Produkt, um eine Kategorie hinzuzufügen.';

  @override
  String get product_improvement_add_category =>
      'Fügen Sie eine Kategorie hinzu, um den Nutri-Score zu berechnen.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Fügen Sie die Nährwertangaben hinzu, um den Nutri-Score zu berechnen.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Fügen Sie Nährwertangaben und eine Kategorie hinzu, um den Nutri-Score zu berechnen.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Der Nutri-Score für dieses Produkt kann nicht berechnet werden, was z.B. an einer nicht standardkonformen Kategorie liegen kann. Wenn Sie dies für einen Fehler halten, kontaktieren Sie uns bitte.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Das Nährwertbild ist veraltet: Bitte aktualisieren Sie es.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Der Green Score berücksichtigt die Herkunft der Zutaten. Bitte fotografieren Sie die Zutatenliste und/oder alle geografischen Angaben oder bearbeiten Sie das Produkt, damit diese berücksichtigt werden können.';

  @override
  String get country_chooser_label => 'Wählen Sie ein Land aus';

  @override
  String get currency_chooser_label => 'Bitte wählen Sie eine Währung';

  @override
  String get country_change_message => 'Sie haben gerade das Land gewechselt.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Möchten Sie die Währung von $previousCurrency in $possibleCurrency ändern?';
  }

  @override
  String get onboarding_country_chooser_label => 'Bitte wählen Sie ein Land:';

  @override
  String get country_chooser_label_from_settings => 'Ihr Land';

  @override
  String get country_selection_explanation =>
      'Einige Umweltfaktoren sind standortspezifisch';

  @override
  String get product_removed_comparison => 'Produkt aus dem Vergleich entfernt';

  @override
  String get native_app_settings => 'Einstellungen der nativen App';

  @override
  String get native_app_description =>
      'Einstellungen für offene Systeme für Open Food Facts';

  @override
  String get product_removed_history => 'Produkt aus dem Verlauf entfernt';

  @override
  String get product_removed_list => 'Produkt aus der Liste entfernt';

  @override
  String get product_could_not_remove => 'Produkt konnte nicht entfernt werden';

  @override
  String get no_prodcut_in_list => 'Liste enthält noch keine Produkte';

  @override
  String get no_product_in_section => 'Bereich enthält noch kein Produkt';

  @override
  String get recently_seen_products => 'Alle angesehenen Produkte';

  @override
  String get clear => 'Leeren';

  @override
  String get clear_long => 'Liste leeren';

  @override
  String get really_clear => 'Möchten Sie diese Liste wirklich löschen?';

  @override
  String pct_match(Object percent) {
    return '$percent% Übereinstimmung';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Tage her',
      one: 'vor einem Tag',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'vor $count Stunden',
      one: 'vor einer Stunde',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'vor $count Minuten',
      one: 'vor einer Minute',
      zero: 'vor weniger als einer Minute',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'vor $count Monaten',
      one: 'vor einem Monat',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'vor $count Wochen',
      one: 'vor einer Woche',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Produkte vergleichen',
      one: 'Ein Produkt vergleichen',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Produkte ausgewählt',
      one: 'Ein Produkt ausgewählt',
      zero: 'Kein Produkt ausgewählt',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Ausgewählte Produkte vergleichen';

  @override
  String get delete_products_mode => 'Ausgewählte Produkte löschen';

  @override
  String get select_all_products_mode => 'Alle Produkte auswählen';

  @override
  String get select_none_products_mode => 'Auswahl aufheben';

  @override
  String get compare_products_appbar_title => 'Produkte vergleichen';

  @override
  String get compare_products_appbar_subtitle =>
      'Bitte wählen Sie mindestens zwei Produkte';

  @override
  String get retry_button_label => 'Wiederholen';

  @override
  String get connect_with_us => 'Mit uns in Verbindung treten';

  @override
  String get tiktok => 'Folgen Sie uns auf TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Folge uns bei Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Folge uns auf X (vormals Twitter)';

  @override
  String get twitter_link => 'https://twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Folgen Sie uns auf Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Folgen Sie uns auf BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'Häufig gestellte Fragen';

  @override
  String get discover => 'Entdecken';

  @override
  String get how_to_contribute => 'Wie Sie beitragen können';

  @override
  String get hint_knowledge_panel_message =>
      'Sie können auf einen beliebigen Teil tippen, um mehr Details zu sehen. Probieren Sie es jetzt aus!';

  @override
  String get permissions_page_title => 'Zugriff auf Kamera';

  @override
  String get permissions_page_body1 =>
      'Um Strichcodes mit der Kamera Ihres Telefons zu erfassen, autorisieren Sie bitte den Zugriff.';

  @override
  String get permissions_page_body2 =>
      'Wenn Sie Ihre Meinung ändern, können Sie diese Option jederzeit in den Einstellungen aktivieren und deaktivieren.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Release: $release)\nModell: $model\nProdukt: $product\nGerät: $device\nMarke: $brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModell: $model\nLokalisiertes Modell: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nApp-Version: $appVersion\nApp-Build-Nummer: $appBuildNumber\nApp-Paketname: $appPackageName';
  }

  @override
  String get authorize_button_label => 'Autorisieren';

  @override
  String get refuse_button_label => 'Ablehnen';

  @override
  String get ask_me_later_button_label => 'Später';

  @override
  String get are_you_sure => 'Sind Sie sicher?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Weiter zu $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Willkommen!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Die App, die Ihnen hilft, Lebensmittel auszuwählen, die gut für **Sie** und den **Planeten** sind!';

  @override
  String get onboarding_continue_button => 'Weiter';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Ihr erstes Beispielprodukt wird geladen';

  @override
  String get onboarding_welcome_warning =>
      'Tut mir leid, das ist nur ein Beispielprodukt, Sie können es nicht bearbeiten.';

  @override
  String get product_list_your_ranking => 'Ihr Ranking';

  @override
  String get product_list_empty_icon_desc => 'Verlauf nicht verfügbar';

  @override
  String get product_list_empty_title => 'Scannen starten';

  @override
  String get product_list_empty_message =>
      'Die gescannten Produkte werden hier angezeigt und Sie können detaillierte Informationen über sie abrufen';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Produkte',
      one: 'Produkt',
      zero: 'Produkt',
    );
    return '$_temp0 in Ihrem Verlauf wird/werden aktualisiert';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Produkte',
      one: 'Produkt',
      zero: 'Produkt',
    );
    return '$_temp0 vollständig aktualisieren';
  }

  @override
  String get product_list_compare_side_by_side =>
      'Vergleichen Sie nebeneinander';

  @override
  String get loading_dialog_default_title => 'Daten werden heruntergeladen';

  @override
  String get loading_dialog_default_error_message =>
      'Daten konnten nicht heruntergeladen werden';

  @override
  String get account_delete => 'Konto löschen';

  @override
  String get account_delete_title => 'Mein Konto löschen';

  @override
  String get user_profile => 'Konto';

  @override
  String get user_profile_title_guest => 'Willkommen!';

  @override
  String get user_profile_subtitle_guest =>
      'Melden Sie sich an oder registrieren Sie sich, um der Open Food Facts-Community beizutreten';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts-Anmeldung: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Herzlich Willkommen $id!';
  }

  @override
  String get email_subject_account_deletion => 'Konto löschen';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hallo, bitte löschen Sie mein Open Food Facts-Konto: $userId';
  }

  @override
  String get settings_app_app => 'Anwendung';

  @override
  String get settings_app_data => 'Datenschutz und Überwachung';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Produkte';

  @override
  String get settings_app_miscellaneous => 'Verschiedenes';

  @override
  String get camera_play_sound_title => 'Ton beim Scan abspielen';

  @override
  String get camera_play_sound_subtitle =>
      'Signalton bei jedem erfolgreichen Scanvorgang';

  @override
  String get camera_window_accessibility_label =>
      'Lesen Sie einen Barcode mit Ihrer Kamera ein';

  @override
  String get app_haptic_feedback_title => 'Vibration und haptisches Feedback';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrationen nach der Ausführung einiger Aktionen (Barcode dekodiert, Produkt entfernt ...).';

  @override
  String get crash_reporting_toggle_title => 'Abstürze melden';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Wenn aktiviert, werden Absturzberichte automatisch an das Fehlerverfolgungssystem von Open Food Facts übermittelt, so dass Fehler behoben werden können und die App dadurch verbessert wird.';

  @override
  String get send_anonymous_data_toggle_title => 'Anonyme Nutzungsdaten senden';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Wenn aktiviert, werden einige anonyme Informationen über die App-Nutzung an die Server von Open Food Facts gesendet, damit wir verstehen können, wie und wie häufig einzelne Funktionen genutzt werden, um diese zu verbessern.';

  @override
  String get product_edit_photo_title => 'Foto bearbeiten';

  @override
  String get permission_photo_error => 'Fehler';

  @override
  String get permission_photo_denied_title =>
      'Erlauben Sie die Verwendung der Kamera zum Scannen von Barcodes';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Für ein besseres Erlebnis erlauben Sie bitte $appName den Zugriff auf Ihre Kamera. Sie können anschließend sofort Barcodes scannen.';
  }

  @override
  String get permission_photo_denied_button => 'Erlauben';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Zugriff verweigert';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Da Sie der Kamera zuvor die Erlaubnis verweigert haben, müssen Sie diese manuell in den Einstellungen zulassen.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Einstellungen öffnen';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Abbrechen';

  @override
  String get permission_photo_none_found => 'Keine Kamera erkannt';

  @override
  String get permission_photo_denied => 'Zugriff auf Kamera noch nicht gewährt';

  @override
  String get show_product_pictures => 'Produktbilder anzeigen';

  @override
  String get edit_product_label => 'Produkt bearbeiten';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Ihre Änderungen werden hochgeladen ...';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Ihre Bearbeitungen werden **im Hintergrund gesendet** (oder später im Falle eines Fehlers).\n\nSie können andere Produktfelder weiter bearbeiten.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Ihre Bearbeitungen werden **im Hintergrund** (oder später im Falle eines Fehlers) gesendet.';

  @override
  String get edit_product_label_short => 'Bearbeiten';

  @override
  String edit_product_form_item_help(String value) {
    return 'Wie kann „$value“ eingegeben werden?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Wert muss angegeben werden!';

  @override
  String get edit_product_form_item_error_existing =>
      'Dieser Wert ist bereits vorhanden!';

  @override
  String get edit_product_form_item_add_action_brand => 'Neue Marke hinzufügen';

  @override
  String get edit_product_form_item_add_action_label =>
      'Neues Etikett hinzufügen';

  @override
  String get edit_product_form_item_add_action_store =>
      'Neues Geschäft hinzufügen';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Neuen Ursprung hinzufügen';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Neuen Rückverfolgbarkeitscode hinzufügen';

  @override
  String get edit_product_form_item_add_action_country =>
      'Neues Land hinzufügen';

  @override
  String get edit_product_form_item_add_action_category =>
      'Neue Kategorie hinzufügen';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Neues Merkmal hinzufügen';

  @override
  String get edit_product_form_item_add_suggestion => 'Vorschlag hinzufügen';

  @override
  String get edit_product_form_item_deny_suggestion => 'Vorschlag ablehnen';

  @override
  String get edit_product_form_item_details_title => 'Allgemeine Informationen';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Produktname, Hersteller, Menge';

  @override
  String get edit_product_form_item_other_details_title =>
      'Zusätzliche Details';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Website …';

  @override
  String get edit_product_form_item_photos_title => 'Fotos';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Fotos hinzufügen oder aktualisieren';

  @override
  String get edit_product_form_item_labels_title =>
      ' Etikett und Zertifizierungen';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Umweltauswirkungen, Qualitätssiegel …';

  @override
  String get edit_product_form_item_labels_hint =>
      'Bezeichnung eingeben (z.B.: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'Etikett';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Bewährte Methoden: Etiketten';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Jede Eigenschaft des Produkts, die **sachlich** ist und sich von den anderen Bereichen unterscheidet.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA …';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Hergestellt in Belgien, produziert in der Bretagne …';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000 …';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Reich an Ballaststoffen, Eisenquelle …';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fairtrade, Max Havelaar …';

  @override
  String get edit_product_form_item_stores_title => 'Läden';

  @override
  String get edit_product_form_item_stores_hint => 'Geschäft eingeben';

  @override
  String get edit_product_form_item_stores_type => 'Laden';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Bewährte Methoden: Läden';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Geben Sie das Geschäft ein, in dem Sie das Produkt gekauft haben.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Rewe';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Herkunft';

  @override
  String get edit_product_form_item_origins_hint =>
      'Herkunft eingeben (z.B.: Deutschland)';

  @override
  String get edit_product_form_item_origins_type => 'Land';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Bewährte Methoden: Ursprünge';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Fügen Sie **alle Herkunftsangaben hinzu, die Sie auf der Verpackung finden**.\nSie brauchen sich nicht um die Herkunftsangaben zu kümmern, die direkt in der Zutatenliste aufgeführt sind.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Rindfleisch aus Argentinien';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Das Soja stammt nicht aus der Europäischen Union';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Land eingeben (z.B.: Deutschland)';

  @override
  String get edit_product_form_item_countries_type => 'Land';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Bewährte Methoden: Länder';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Länder, in denen das Produkt weithin erhältlich ist** (ohne auf ausländische Produkte spezialisierte Geschäfte).';

  @override
  String get edit_product_form_item_emb_codes_title =>
      'Rückverfolgbarkeitscodes';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Code eingeben (z.B.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522 …)';

  @override
  String get edit_product_form_item_emb_codes_type => 'Rückverfolgbarkeitscode';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Bewährte Methoden: Rückverfolgbarkeitscodes';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'In diesem Abschnitt können Sie Codes für **Verpackungsmarken**, **Identifikationsmarken** oder **Gesundheitsmarken** eingeben.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Beispiele für Rückverfolgbarkeitscodes';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EC-Codes**, die in der Europäischen Gemeinschaft zur Kennzeichnung von Lebensmittelherstellern oder -verpackern verwendet werden:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: Ländercode von **France**\n**72.264.002**: geografische Daten\n**CE**: Europäische Gemeinschaft';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      'In Frankreich verwendete **EMB-Codes**:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Spuren';

  @override
  String get edit_product_form_item_traces_hint => 'Spur';

  @override
  String get edit_product_form_item_traces_type =>
      'Merkmal eingeben (z.B.: Sojabohnen)';

  @override
  String get edit_product_form_item_categories_title => 'Kategorien';

  @override
  String get edit_product_form_item_categories_hint => 'Kategorie';

  @override
  String get edit_product_form_item_categories_type =>
      'Kategorie eingeben (z.B.: Orangensaft)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Bewährte Methoden: Kategorien';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Geben Sie **nur die wichtigste Kategorie** an.\nDie übergeordneten Kategorien werden automatisch hinzugefügt.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Fehlende Kategorie?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Sollte eine Kategorie **nicht in der Autovervollständigung** enthalten sein, können Sie sie trotzdem hinzufügen.\nDies wird uns helfen, Open Food Facts in Ihrem Land zu verbessern.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardinen in Olivenöl';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Orangensaft aus Konzentrat';

  @override
  String get edit_product_form_item_exit_title => 'Beenden ohne zu speichern?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Möchten Sie Ihre Änderungen speichern, bevor Sie diese Seite verlassen?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Änderungen speichern';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Änderungen verwerfen';

  @override
  String get edit_product_form_item_ingredients_title => 'Zutaten';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Vergrößern und Verkleinern indem du den Bildschirm mit zwei Fingern zusammen- oder auseinanderziehst';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Foto vergrößern und verkleinern';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Mit der **Pinch-to-Zoom-Geste** können Sie das Foto vergrößern oder verkleinern:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Hinzufügen';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Bitte zuerst einen Text eingeben';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Entfernen';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Bearbeitung speichern';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Bearbeitung verwerfen';

  @override
  String get edit_product_form_item_packaging_title =>
      'Foto der Recycling-Anweisungen';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Nährwertangaben';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Ernährung, Alkoholgehalt …';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Bewährte Methoden: Nährwertangaben';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Nährwertangaben';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Wählen Sie zunächst aus, ob die **Werte bereitgestellt werden**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Nährwertangaben';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Geben Sie dann die Nährwertangaben **wie auf der Verpackung angegeben** ein. Wenn es keinen Wert gibt, können Sie auf das Symbol „Auge“ klicken.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Fehlendes Feld?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Wenn ein Eintrag fehlt, können Sie **auf das Symbol „Plus“ klicken**, um ihn hinzuzufügen (z. B.: Vitamin D, Magnesium …).';

  @override
  String get edit_product_form_save => 'Bearbeiten';

  @override
  String get edit_product_ingredients_photo_title => 'Foto der Zutatenliste';

  @override
  String get edit_product_ingredients_list_title => 'Zutatenliste';

  @override
  String get edit_product_packaging_photo_title => 'Foto der Verpackung';

  @override
  String get edit_product_packaging_list_title => 'Liste der Verpackungen';

  @override
  String get no_data_available => 'Keine Daten verfügbar';

  @override
  String get product_field_website_title => 'Website';

  @override
  String get origins_editing_title => 'Herkunft bearbeiten';

  @override
  String get completed_basic_details_btn_text =>
      'Allgemeine Angaben vervollständigen';

  @override
  String get not_implemented_snackbar_text => 'Noch nicht implementiert';

  @override
  String get category_picker_page_appbar_text => 'Kategorien';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Zutaten aus dem Foto extrahieren';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Zutaten extrahieren';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Zutaten werden aus\ndem Foto extrahiert';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Foto wird geladen …';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Warum wird diese Meldung angezeigt?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Um die Funktion \"Zutaten extrahieren\" nutzen zu können, muss das Foto zunächst hochgeladen werden.\n\nBitte warten Sie ein paar Sekunden oder geben Sie sie manuell ein.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Foto aktualisieren';

  @override
  String get edit_packaging_extract_btn_text =>
      'Verpackung aus dem\nFoto extrahieren';

  @override
  String get edit_packaging_extract_btn_text_short => 'Verpackung extrahieren';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Verpackung wird aus dem Foto extrahiert';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Foto wird geladen …';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Warum wird diese Meldung angezeigt?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Um die Funktion \"Verpackung extrahieren\" nutzen zu können, muss das Foto zunächst hochgeladen werden.\n\nBitte warten Sie ein paar Sekunden oder geben Sie es manuell ein.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Foto aktualisieren';

  @override
  String get edit_ocr_extract_failed =>
      'Text im Bild konnte nicht erkannt werden.';

  @override
  String get edit_ocr_extract_disabled_title => 'Kein Foto!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Um die Textextraktionsfunktion nutzen zu können, müssen Sie zunächst ein Foto aufnehmen.';

  @override
  String get user_list_dialog_new_title => 'Neue Produktliste';

  @override
  String get user_list_dialog_rename_title => 'Liste umbenennen';

  @override
  String get user_list_subtitle_product => 'Listen';

  @override
  String get user_list_title => 'Ihre Listen';

  @override
  String get user_list_add_product => 'Produkt zu Ihren Listen hinzufügen';

  @override
  String get user_list_button_new => 'Neue Liste erstellen';

  @override
  String get user_list_empty_label =>
      'Noch keine Liste vorhanden!\nBitte beginnen Sie, eine zu erstellen.';

  @override
  String get user_list_button_add_product => 'Zur Liste hinzufügen';

  @override
  String get added_to_list_msg => 'Zur Liste hinzugefügt';

  @override
  String get user_list_popup_clear => 'Verlauf leeren';

  @override
  String get user_list_popup_rename => 'Umbenennen';

  @override
  String get user_list_name_hint => 'Meine Liste';

  @override
  String get user_list_name_error_empty => 'Name ist ein Pflichtfeld';

  @override
  String get user_list_name_error_already =>
      'Dieser Name wird bereits verwendet';

  @override
  String get user_list_name_error_same => 'Das ist derselbe Name';

  @override
  String get user_list_name_input_hint => 'Name der Liste';

  @override
  String get try_again => 'Erneut versuchen';

  @override
  String get there_was_an_error => 'Es ist ein Fehler aufgetreten';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Keine Kategorie für $items gefunden';
  }

  @override
  String get camera_toggle_camera =>
      'Zwischen Rück- und Frontkamera umschalten';

  @override
  String get camera_toggle_flash => 'Kamerablitz ein- oder ausschalten';

  @override
  String get camera_enable_flash => 'Fotoblitz aktivieren';

  @override
  String get camera_disable_flash => 'Fotobblitz deaktivieren';

  @override
  String get camera_flash_error_dialog_title => 'Ein Fehler ist aufgetreten.';

  @override
  String get camera_flash_error_dialog_message =>
      'Inhalt des Dialogs, der erklärt, dass ein Fehler aufgetreten beim Aktivieren des Kamerablitzes aufgetreten ist.';

  @override
  String get category_picker_no_category_found_button => 'Zurück';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Anklicken, um in Ihrem Browser oder in der Anwendung (falls installiert) zu öffnen';

  @override
  String get dev_preferences_screen_title => 'Entwicklermodus';

  @override
  String get dev_preferences_screen_subtitle =>
      'Greifen Sie auf experimentelle Funktionen und Entwicklungstools zu';

  @override
  String get dev_preferences_reset_onboarding_title => 'Intro erneut starten';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Sie müssen anschließend die App neu starten, um sie erneut anzuzeigen.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Wechseln zwischen openfoodfacts.org (PROD) und Testumgebung';

  @override
  String get dev_preferences_test_environment_title => 'Testumgebungsparameter';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Basis-URL für aktuelle Testumgebung: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Testumgebungs-Host';

  @override
  String get dev_preferences_ml_kit_title => 'ML Kit verwenden';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'dann musst du diese App neu starten';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Zusätzliche Schaltfläche auf der Produktseite';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Bearbeiten Sie Zutaten über eine Knowledge-Panel-Schaltfläche';

  @override
  String get dev_preferences_export_history_title => 'Verlauf exportieren';

  @override
  String get dev_preferences_export_history_progress_error => 'ausnahme';

  @override
  String get dev_preferences_export_history_progress_found =>
      'artikel gefunden';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produkt nicht gefunden';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Verlauf exportieren';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Abbrechen';

  @override
  String get dev_preferences_migration_title => 'Datenübernahme aus V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Status: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'Erfolg oder Neuinstallation';

  @override
  String get dev_preferences_migration_status_success => 'erfolgreich';

  @override
  String get dev_preferences_migration_status_error => 'Fehler';

  @override
  String get dev_preferences_migration_status_in_progress => 'in Bearbeitung';

  @override
  String get dev_preferences_migration_status_required =>
      'benötigt (klicken, um zu starten)';

  @override
  String get dev_preferences_migration_status_not_started => 'Unbekannt';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Wird den Verlauf löschen und 3 Produkte einfügen';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Benutzerdefinierte URL für Nachrichten';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL der JSON-Datei:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Nicht festgelegt';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Letzte Aktualisierung: $date';
  }

  @override
  String get product_type_label_food => 'Nahrungsmittel';

  @override
  String get product_type_label_beauty => 'Körperpflege';

  @override
  String get product_type_label_pet_food => 'Haustierfutter';

  @override
  String get product_type_label_product => 'Weitere';

  @override
  String get product_type_selection_title => 'Produkttyp';

  @override
  String get product_type_selection_subtitle =>
      'Wählen Sie die Art dieses Produkts';

  @override
  String get product_type_selection_empty =>
      'Sie müssen zuerst einen Produkttyp auswählen!';

  @override
  String product_type_selection_already(String productType) {
    return 'Sie können den Produkttyp ($productType) nicht ändern!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Verknüpfung zur Preise-App auf der Produktseite';

  @override
  String get prices_app_button => 'Zur Preise-App wechseln';

  @override
  String get prices_website_button => 'Öffnen Sie auf der Open Prices-Website';

  @override
  String get prices_bulk_proof_upload_select =>
      'Preisschilder direkt aus der Galerie hinzufügen';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Sobald Sie Fotos ausgewählt haben, können diese nicht mehr bearbeitet werden!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'KI prüft Ihre Nachweise, um Preise zu ermitteln.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Ermöglichen Sie der Community, von der KI extrahierte Preise zu validieren.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Mehrere Preisschilder';

  @override
  String get prices_bulk_proof_upload_title => 'Massen-Upload von Nachweisen';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Dateien auswählen';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Starten des Uploads';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Datei #$index/${count}wird lokal kopiert';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Upload vorbereiten #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Fehler beim Bild #$index/$count';
  }

  @override
  String get prices_generic_title => 'Preise';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Preise hinzufügen',
      one: 'Preis hinzufügen',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Preise senden',
      one: 'Preis senden',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Ein Element hinzufügen';

  @override
  String get prices_add_a_price => 'Preis hinzufügen';

  @override
  String get prices_add_a_receipt => 'Beleg hinzufügen';

  @override
  String get prices_add_price_tags => 'Preisschilder hinzufügen';

  @override
  String prices_barcode_already(String barcode) {
    return 'Dieser Strichcode ($barcode) ist bereits in der Liste enthalten!';
  }

  @override
  String get prices_barcode_search_not_found => 'Produkt nicht gefunden';

  @override
  String get prices_barcode_search_none_yet => 'Noch kein Produkt';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Nach $barcode suchen';
  }

  @override
  String get prices_barcode_enter => 'Barcode eingeben';

  @override
  String get prices_category_enter => 'Artikel ohne Strichcode';

  @override
  String get prices_per_kilogram => 'Preis pro Kilogramm';

  @override
  String get prices_per_unit => 'Preis pro Stück';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / Einheit';

  @override
  String get prices_category_mandatory => 'Pflichtfeld';

  @override
  String get prices_category_optional => 'Optional';

  @override
  String get prices_category_error_mandatory =>
      'Die Kategorie ist verpflichtend';

  @override
  String get prices_barcode_reader_action => 'Barcodelesegerät';

  @override
  String get prices_view_prices => 'Preise anzeigen';

  @override
  String get prices_list_title => 'Preisliste';

  @override
  String get prices_list_count => 'Anzahl der\nPreise';

  @override
  String get prices_list_add_new_price => 'Fügen Sie einen\nneuen Preis hinzu';

  @override
  String get prices_list_empty_title => 'Noch kein Preis!';

  @override
  String get prices_list_empty_subtitle =>
      'Seien Sie der Erste, der eines hinzufügt:\nIndem Sie einen **Beleg** oder ein **Preisschild** scannen!';

  @override
  String get prices_entry_shop_not_found => 'Unbekannter Laden';

  @override
  String prices_entry_menu_title(String user) {
    return 'Preiseingabe ab \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Alle Preise für dieses Produkt anzeigen';

  @override
  String get prices_entry_menu_open_proof => 'Proof ansehen';

  @override
  String get prices_entry_menu_my_prices => 'Meine anderen Preise ansehen';

  @override
  String get prices_entry_menu_author_prices =>
      'Weitere Preise des Autors anzeigen';

  @override
  String get prices_entry_menu_shop_prices =>
      'Weitere Preise aus dem Shop ansehen';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Preise',
      one: '1 Preis',
    );
    return '$_temp0 für $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Alle $count Preise',
      one: 'Nur ein Preis',
      zero: 'Noch kein Preis',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Letzte $pageSize Preise (insgesamt: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Preis: $price / Laden: „$location” / Veröffentlicht am $date von „$user”';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Nachweise von „$user” öffnen';
  }

  @override
  String get prices_open_proof => 'Preisnachweis öffnen';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Alle $count Nachweise',
      one: 'Nur ein Nachweis',
      zero: 'Noch kein Nachweis',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Letzte $pageSize Nachweise (insgesamt: $total)';
  }

  @override
  String get prices_users_empty_title => 'Noch kein Mitwirkender!';

  @override
  String get prices_users_empty_explanation =>
      'Geben Sie als Erster einen Preis an!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Die besten $pageSize Mitwirkende (insgesamt: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Noch kein Shop!';

  @override
  String get prices_locations_empty_explanation =>
      'Geben Sie als Erster einen Preis an!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Die besten $pageSize Standorte (Insgesamt: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Nachweise',
      one: 'Ein Nachweis',
      zero: 'Keine Nachweise',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Produkte',
      one: 'Ein Produkt',
      zero: 'Keine Produkte',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Benutzer',
      one: 'Ein Benutzer',
      zero: 'Keine Benutzer',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Preise',
      one: 'Ein Preis',
      zero: 'Keine Preise',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Preis zuvor hinzugefügt';

  @override
  String get prices_amount_subtitle => 'Betrag';

  @override
  String get prices_amount_is_discounted => 'Preisreduziert?';

  @override
  String get prices_amount_price_normal => 'Preis';

  @override
  String get prices_amount_price_discounted => 'Reduzierter Preis';

  @override
  String get prices_amount_price_not_discounted => 'Ursprünglicher Preis';

  @override
  String get prices_amount_no_product => 'Ein Produkt fehlt!';

  @override
  String get prices_amount_price_incorrect => 'Ungültiger Wert';

  @override
  String get prices_amount_price_mandatory => 'Notwendiger Wert';

  @override
  String get prices_currency_subtitle => 'Währung';

  @override
  String get prices_date_subtitle => 'Datum';

  @override
  String get prices_location_subtitle => 'Laden';

  @override
  String get prices_location_find => 'Einen Laden finden';

  @override
  String get prices_location_mandatory => 'Sie müssen einen Laden auswählen!';

  @override
  String get prices_location_search_broader =>
      'Sie haben nicht gefunden, wonach Sie gesucht haben? Versuchen Sie es mit einer allgemeineren Suchanfrage!';

  @override
  String get prices_proof_subtitle => 'Nachweis';

  @override
  String get prices_proof_empty_title => 'Noch kein Beweis!';

  @override
  String get prices_proof_empty_explanation =>
      'Fügen Sie zunächst ein Foto einer **Quittung** oder eines **Preisschilds** hinzu!';

  @override
  String get prices_proof_find => 'Wählen Sie einen Nachweis';

  @override
  String get prices_proof_change => 'Wechselnachweis';

  @override
  String get prices_proof_receipt => 'Kassenbon';

  @override
  String get prices_proof_price_tag => 'Preisschild';

  @override
  String get prices_proof_mandatory => 'Sie müssen einen Nachweis auswählen!';

  @override
  String get prices_add_validation_error => 'Überprüfungsfehler';

  @override
  String get prices_privacy_warning_title => 'Datenschutzwarnung';

  @override
  String get prices_unknown_product => 'Unbekanntes Produkt';

  @override
  String get prices_privacy_warning_main_message =>
      'Die Preise **werden zusammen mit dem Geschäft, auf das sie sich beziehen, öffentlich** sein.\n\nDas könnte es Leuten, die Ihr Pseudonym auf Open Food Facts kennen, ermöglichen:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Ermitteln, in welcher Gegend Sie leben';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Erfahren, was Sie kaufen';

  @override
  String get prices_privacy_warning_sub_message =>
      'Wenn Ihnen das unangenehm ist, ändern Sie bitte Ihr Pseudonym oder erstellen Sie ein neues Open Food Facts-Konto und melden Sie sich damit in der App an.';

  @override
  String get i_refuse => 'Ablehnen';

  @override
  String get i_accept => 'Akzeptieren';

  @override
  String get prices_currency_change_proposal_title => 'Währung ändern?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Ihre aktuelle Währung ist **$currency**. Möchten Sie diese in **$newCurrency** ändern?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Ja, $newCurrency verwenden';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nein, $currency behalten';
  }

  @override
  String get prices_menu_know_more => 'Erfahren Sie mehr über Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Fertig';

  @override
  String get dev_mode_section_server => 'Serverkonfiguration';

  @override
  String get dev_mode_section_news => 'Konfiguration des Nachrichtenanbieters';

  @override
  String get dev_mode_section_product_page => 'Produktseite';

  @override
  String get dev_mode_section_ui => 'Benutzeroberfläche';

  @override
  String get dev_mode_section_experimental_features =>
      'Experimentelle Funktionen';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Green Score ausschließen';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Verwenden Sie eine Rechtschreibprüfung für OCR-Bildschirme';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Zutaten und Verpackung)';

  @override
  String get dev_mode_reset_app_language_title => 'App-Sprache zurücksetzen';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Karten hinzufügen';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Wechseln Sie zwischen prices.openfoodfacts.org (PROD) und der Testumgebung';

  @override
  String get search_history_item_edit_tooltip =>
      'Diese Suche wiederverwenden und bearbeiten';

  @override
  String get search_history_item_remove_tooltip => 'Entfernen';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Sie haben alle $totalSize Produkte heruntergeladen.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Downloade $count weitere Produkte\nBereits heruntergeladen $downloaded von $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Ihre Suche nach $search wird ausgeführt.\n\nBitte einen Moment Geduld …';
  }

  @override
  String get user_search_contributor_title =>
      'Produkte, die ich hinzugefügt habe';

  @override
  String get user_search_informer_title => 'Produkte, die ich bearbeitet habe';

  @override
  String get user_search_photographer_title =>
      'Produkte, die ich fotografiert habe';

  @override
  String get user_search_to_be_completed_title =>
      'Meine „noch zu vervollständigenden” Produkte';

  @override
  String get user_search_prices_title => 'Mein Preise';

  @override
  String get user_search_proofs_title => 'Meine Belege';

  @override
  String get user_search_proof_title => 'Meine Nachweise';

  @override
  String search_proof_title(String user) {
    return 'Beweis aus \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Beitragspreise: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Neueste Preise hinzugefügt';

  @override
  String get all_search_prices_top_user_title => 'Aktivste Preis-Mitwirkende';

  @override
  String get all_search_prices_top_location_title =>
      'Läden mit den meisten Preisen';

  @override
  String get prices_contribution_assistant => 'Preis-Mitwirkungsassistent';

  @override
  String get prices_validation_assistant => 'Preisprüfungsassistent';

  @override
  String get prices_challenges_page => 'Herausforderungen';

  @override
  String get prices_multiple_proof_addition_system =>
      'Mehrere Nachweise hinzufügen';

  @override
  String get all_search_prices_top_location_single_title => 'Preise im Laden';

  @override
  String get all_search_prices_top_product_title =>
      'Produkte mit den meisten Preisen';

  @override
  String get all_search_to_be_completed_title =>
      'Alle „noch zu vervollständigenden” Produkte';

  @override
  String get categorize_products_country_title =>
      'Helfen Sie mit, Produkte in Ihrem Land zu kategorisieren';

  @override
  String get edit_product_action_retake_picture => 'Foto wiederholen';

  @override
  String get edit_product_action_take_picture => 'Foto aufnehmen';

  @override
  String get edit_product_action_confirm => 'Bestätigen';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Ich akzeptiere die Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'Nutzungsbedingungen von Open Food Facts zu';

  @override
  String get analytics_consent_image_semantic_label => 'Analysesymbol';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Schwerer Fehler: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Schwerer Fehler: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Allgemeine Angaben vervollständigen';

  @override
  String get edit_photo_button_label => 'Bearbeiten';

  @override
  String get edit_photo_unselect_button_label => 'Foto abwählen';

  @override
  String get edit_photo_select_existing_button_label =>
      'Vorhandene Foto auswählen';

  @override
  String get edit_photo_select_existing_all_label =>
      'Vorhandene Bilder für dieses Produkt';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Wählen Sie ein Bild aus, indem Sie es anklicken';

  @override
  String get edit_photo_select_existing_download_label =>
      'Vorhandene Fotos werden abgerufen …';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Zu diesem Produkt wurden noch keine Fotos hochgeladen.';

  @override
  String get edit_photo_language_not_this_one =>
      'Noch keine Abbildung in dieser Sprache';

  @override
  String get edit_photo_language_none => 'Noch keine Abbildungen verfügbar';

  @override
  String get category_picker_screen_title => 'Kategorien';

  @override
  String get basic_details => 'Allgemeine Details';

  @override
  String get product_name => 'Produktname';

  @override
  String get product_names => 'Produktnamen';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Neue Übersetzung hinzufügen';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Bitte fügen Sie vor der Validierung nur dann eine Übersetzung hinzu, **wenn die Sprache auf der Verpackung angegeben ist**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Foto der Vorderseite anzeigen';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Foto der Vorderseite aufnehmen';

  @override
  String get add_basic_details_product_name_hint =>
      'Namen des Produkts eingeben (z.B.: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Die Standardsprache ändern?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Möchten Sie, dass die Standardsprache des Produkts auf „$language“ eingestellt wird?';
  }

  @override
  String get explanation_section_good_examples => 'Gute Beispiele';

  @override
  String get explanation_section_bad_examples => 'Schlechte Beispiele';

  @override
  String get add_basic_details_product_name_help_title =>
      'Bewährte Methoden: Name des Produkts';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Der Produktname ist der **Hauptname auf der Verpackung**. Er kann eine eingetragene Marke sein.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Hinweis:** Bitte fügen Sie keine Übersetzung hinzu, **wenn die Sprache nicht auf der Verpackung angegeben ist**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomatenketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Die Marke darf nicht im Namen enthalten sein';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomatenketchup **von Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Verwenden Sie keine Symbole wie ®, ™, © oder ähnliche';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count weitere Übersetzungen',
      one: '$count weitere Übersetzung',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Markenname';

  @override
  String get brand_names => 'Markennamen';

  @override
  String get add_basic_details_brand_name_error =>
      'Bitte den Markennamen eingeben';

  @override
  String get add_basic_details_brand_names_hint =>
      'Markenname eingeben (z.B.: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Bewährte Methoden: Marken';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Geben Sie **alle Marken des Produkts** ein.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Wichtigste Marke';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'Die **Wichtigste Marke**, die in der Regel deutlich auf der Vorderseite der Packung zu sehen ist, sollte zuerst **eingetragen** werden.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Weitere Marken';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Wenn sie **von einem großen Unternehmen** verkauft werden:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** wird von **Danone** verkauft';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Beim Verkauf mit seiner Marke **übersetzt in mehrere Sprachen**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** wird manchmal auch als **Val Nature** geschrieben';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Menge und Gewicht';

  @override
  String get add_basic_details_quantity_hint =>
      'Gewicht und ggf. Menge eingeben (z.B.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Bewährte Methoden: Menge';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Übernehmen Sie den auf dem Produkt angegebenen Wert und **vergessen Sie nicht die Einheiten**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** oder **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (für 6 Eier)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(für ein Produkt mit 3 Schachteln zu je 150g)';

  @override
  String get barcode => 'Strichcode';

  @override
  String barcode_barcode(String barcode) {
    return 'Strichcode: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Strichcode ungültig';

  @override
  String get basic_details_add_success =>
      'Allgemeine Details erfolgreich hinzugefügt';

  @override
  String get basic_details_add_error =>
      'Allgemeine Details konnten nicht hinzugefügt werden. Bitte versuche es nach einiger Zeit erneut';

  @override
  String get clear_search => 'Suche zurücksetzen';

  @override
  String get confirm_clear =>
      'Sie sind dabei, Ihren gesamten Verlauf zu löschen: Möchten Sie wirklich fortfahren?';

  @override
  String get alert_clear_selected_user_list =>
      'Sie sind dabei, ausgewählte Elemente in Ihrem Verlauf zu löschen';

  @override
  String get confirm_clear_selected_user_list =>
      'Möchten Sie wirklich fortfahren?';

  @override
  String get alert_select_items_to_clear =>
      'Bitte wählen Sie einen oder mehrere Punkte zum Löschen aus';

  @override
  String confirm_clear_user_list(String name) {
    return 'Sie sind dabei, diese Liste ($name) zu leeren: Möchten Sie wirklich fortfahren?';
  }

  @override
  String get confirm_delete_user_list_title => 'Diese Liste löschen?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Sie sind dabei, die Liste „$name” zu löschen.\nMöchten Sie wirklich fortfahren?';
  }

  @override
  String get confirm_delete_user_list_button => 'Ja, bestätigen';

  @override
  String importance_label(String name, String id) {
    return '$name Wichtigkeit: $id';
  }

  @override
  String get user_list_all_title => 'Listen';

  @override
  String get user_list_all_empty => 'Erstellen Sie Ihre erste Liste';

  @override
  String get product_list_select => 'Wählen Sie eine Liste';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Produkte',
      one: 'Ein Produkt',
      zero: 'Leere Liste',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Liste hinzufügen';

  @override
  String get open_food_preferences_tooltip =>
      'Bearbeiten Sie Ihre Lebensmittelpräferenzen';

  @override
  String get add_photo_button_label => 'Foto hinzufügen';

  @override
  String get add_packaging_photo_button_label =>
      'Fotos von Verpackungs-/Recyclinginformationen aufnehmen';

  @override
  String get add_origin_photo_button_label =>
      'Fotos von allen Herkunftsinformationen aufnehmen';

  @override
  String get add_emb_photo_button_label =>
      'Fotos von allen Rückverfolgbarkeitscode-Informationen aufnehmen';

  @override
  String get add_label_photo_button_label =>
      'Fotos von allen Etiketten und Zertifizierungsinformationen aufnehmen';

  @override
  String get choose_image_source_title => 'Bildquelle wählen';

  @override
  String get choose_image_source_body => 'Bitte wählen Sie eine Bildquelle';

  @override
  String get gallery_source_label => 'Galerie';

  @override
  String get gallery_source_access_denied_dialog_title => 'Zugriff verweigert';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Leider kann die Anwendung nicht auf Ihre Galerie zugreifen, da Sie die Erlaubnis zuvor verweigert haben.\n\nBitte öffnen Sie die App-Einstellungen in Ihrem Telefon unter „Einstellungen” ➜ „Fotos”';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Einstellungen öffnen';

  @override
  String get share => 'Teilen';

  @override
  String share_product_text(String url) {
    return 'Schauen Sie sich dieses Produkt auf Open Food Facts an: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Werfen Sie einen Blick auf dieses Produkt auf Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Werfen Sie einen Blick auf dieses Produkt auf Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Werfen Sie einen Blick auf dieses Produkt auf Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Werfen Sie einen Blick auf meine Liste der Produkte auf Open Food Facts: $url';
  }

  @override
  String get capture => 'Neu erfassen';

  @override
  String get capture_new_picture => 'Foto aufnehmen';

  @override
  String get choose_from_gallery => 'Aus Galerie wählen';

  @override
  String get image_upload_queued =>
      'Das Bild wird so schnell wie möglich im Hintergrund hochgeladen.';

  @override
  String get add_price_queued =>
      'Der Preis wird schnellstmöglich an den Server übermittelt.';

  @override
  String get background_task_title_full_refresh =>
      'Aktualisierung aller lokal gespeicherten Produkte wird gestartet';

  @override
  String get background_task_title_folksonomy =>
      'Die Serveraktionen für lokal gespeicherte Folksonomie-Aktualisierungen werden nun ausgeführt.';

  @override
  String get background_task_title_top_n =>
      'Herunterladen der beliebtesten Produkte wird gestartet';

  @override
  String get expand_nutrition_facts => 'Nährwerttabelle erweitern';

  @override
  String get expand_nutrition_facts_body => 'Nährwerttabelle geöffnet lassen';

  @override
  String get expand_ingredients => 'Zutatenliste erweitern';

  @override
  String get expand_ingredients_body => 'Zutatenliste geöffnet lassen';

  @override
  String get no_internet_connection => 'Keine Internetverbindung';

  @override
  String get world_results_label => 'Ganze Welt';

  @override
  String get world_results_action => 'Erweitern Sie die Suche auf die Welt';

  @override
  String get copy_to_clipboard => 'Kopieren';

  @override
  String get paste_from_clipboard => 'Aus Zwischenablage einfügen';

  @override
  String get no_data_available_in_clipboard =>
      'Keine Daten in Ihrer Zwischenablage verfügbar';

  @override
  String get clipboard_barcode_copy =>
      'Strichcode in die Zwischenablage kopieren';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Strichcode „$barcode“ in die Zwischenablage kopiert!';
  }

  @override
  String get open_product_website => 'Dieses Produkt auf der Website öffnen';

  @override
  String get language_picker_label => 'Ihre Sprache';

  @override
  String get country_picker_label => 'Ihr Land';

  @override
  String get currency_picker_label => 'Eigene Währung';

  @override
  String get help_with_openfoodfacts => 'Hilfe bei OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Das Produkt wird so schnell wie möglich im Hintergrund aktualisiert.';

  @override
  String get no_email_client_available_dialog_title => 'Keine E-Mail-Apps!';

  @override
  String get no_email_client_available_dialog_content =>
      'Bitte senden Sie uns manuell eine E-Mail an mobile@openfoodfacts.org';

  @override
  String get all_images => 'Alle Fotos';

  @override
  String get selected_images => 'Ausgewählte Fotos';

  @override
  String get product_card_remove_product_tooltip => 'Produkt entfernen';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Neuer Strich gescannt: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Alle Produkte aus dem Karussell entfernen';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Bitte scannen Sie mindestens zwei Produkte, um sie zu vergleichen';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Klicken Sie hier, um die von Ihnen erfassten Produkte zu vergleichen';

  @override
  String get scan_product_loading => 'Sie haben den\nStrichcode gescannt:';

  @override
  String get scan_product_loading_initial =>
      'Es wird nach diesem Produkt gesucht!\nBitte warten Sie ein paar Sekunden …';

  @override
  String get scan_product_loading_long_request =>
      'Es wird noch nach diesem Produkt gesucht!\nFinden Sie, dass es sehr lange dauert, bis es geladen wird? Wir auch …';

  @override
  String get scan_product_loading_unresponsive =>
      'Es wird noch nach diesem Produkt gesucht!\nMöchten Sie die Suche neu starten?';

  @override
  String get scan_product_loading_restart_button => 'Suche neu starten';

  @override
  String get portion_calculator_description =>
      'Nährwertangaben für eine bestimmte Menge berechnen';

  @override
  String get portion_calculator_hint => 'Menge in';

  @override
  String get portion_calculator_accessibility =>
      'Menge eingeben, um Nährwertangaben zu berechnen';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Bitte eine Menge zwischen $min und $max g eingebe';
  }

  @override
  String get portion_calculator_computation_error =>
      'Fehlende Daten. Die Berechnung konnte nicht durchgeführt werden.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Nährwertangaben für $grams g (oder ml)';
  }

  @override
  String get offline_data => 'Offline-Daten';

  @override
  String get ocr_image_upload_instruction =>
      'Laden Sie ein Bild hoch, um die darin enthaltenen Informationen automatisch auszulesen.';

  @override
  String get upload_image => 'Foto hochladen';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Bild konnte nicht heruntergeladen werden';

  @override
  String get image_edit_url_error =>
      'Fehler beim Bearbeiten des Bildes, da die Bild-URL nicht festgelegt wurde.';

  @override
  String get user_picture_source_remember => 'Meine Auswahl speichern';

  @override
  String get user_picture_source_ask => 'Jedes Mal nachfragen';

  @override
  String get robotoff_continue => 'Weiter';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Fragen',
      one: 'Frage',
    );
    return 'Nächste $_temp0';
  }

  @override
  String get show_password => 'Passwort anzeigen';

  @override
  String get owner_field_info_title => 'Vom Hersteller bereitgestellte Werte';

  @override
  String get owner_field_info_message =>
      'Mit diesem Logo heben wir die vom Hersteller bereitgestellten Daten hervor, die möglicherweise nicht bearbeitet werden können.';

  @override
  String get owner_field_info_close_button => 'Diesen Hinweis schließen';

  @override
  String get owner_field_image =>
      'Dieses Bild wird vom Hersteller zur Verfügung gestellt. Es kann möglicherweise nicht bearbeitet werden.';

  @override
  String get edit_packagings_title => 'Verpackungsbestandteile';

  @override
  String get edit_packagings_element_add => 'Verpackungsbestandteil hinzufügen';

  @override
  String get edit_packagings_completed => 'Die Verpackung ist vollständig';

  @override
  String edit_packagings_element_title(int index) {
    return 'Verpackungsbestandteil #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Anzahl der Einheiten';

  @override
  String get edit_packagings_element_hint_units =>
      'Geben Sie die Anzahl der Verpackungseinheiten gleicher Form und gleichen Materials an, die in dem Erzeugnis enthalten sind.';

  @override
  String get edit_packagings_element_field_shape => 'Form';

  @override
  String get edit_packagings_element_hint_shape =>
      'Geben Sie den Namen der Form ein, die in der Recycling-Anleitung aufgeführt ist (falls vorhanden) oder wählen Sie eine Form aus.';

  @override
  String get edit_packagings_element_example_shape => 'Flasche';

  @override
  String get edit_packagings_element_field_material => 'Materialien';

  @override
  String get edit_packagings_element_hint_material =>
      'Geben Sie das spezifische Material an, wenn es bestimmt werden kann (ein Materialcode in einem Dreieck ist oft auf Verpackungsteilen zu finden), oder ein allgemeines Material (z. B. Kunststoff oder Metall), wenn Sie sich nicht sicher sind.';

  @override
  String get edit_packagings_element_example_material => 'Glas';

  @override
  String get edit_packagings_element_field_recycling => 'Recycling-Anweisungen';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Geben Sie Recyclinghinweise nur an, wenn sie auf dem Produkt angegeben sind.';

  @override
  String get edit_packagings_element_example_recycling => 'Recyceln';

  @override
  String get edit_packagings_element_field_quantity =>
      'Nettomenge des Produkts pro Einheit';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Geben Sie das Nettogewicht oder Nettovolumen ein und geben Sie die Einheit an (z. B. g oder ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Gewicht einer leeren Einheit (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Entfernen Sie Lebensmittelreste und waschen und trocknen Sie das Verpackungsteil vor dem Wiegen. Verwenden Sie nach Möglichkeit eine Waage mit einer Genauigkeit von 0,1 g oder 0,01 g.';

  @override
  String get background_task_title => 'Ausstehende Beiträge';

  @override
  String get background_task_subtitle =>
      'Ihre Beiträge werden automatisch auf unserem Server gespeichert, aber nicht immer in Echtzeit.';

  @override
  String get background_task_list_empty =>
      'Keine anstehenden Hintergrundaufgaben';

  @override
  String get background_task_error_server_time_out =>
      'Server-Zeitüberschreitung';

  @override
  String get background_task_error_no_internet =>
      'Fehler bei der Internetverbindung. Versuchen Sie es später noch einmal.';

  @override
  String get background_task_operation_unknown => 'Unbekannte Vorgangsart';

  @override
  String get background_task_operation_details => 'Ausführliche Änderungen';

  @override
  String get background_task_operation_image => 'Foto hochladen';

  @override
  String get background_task_operation_refresh =>
      'Aktualisierungsverzögerung nach dem Hochladen von Fotos';

  @override
  String get background_task_run_started => 'Gestartet';

  @override
  String get background_task_run_not_started => 'Noch nicht gestartet';

  @override
  String get background_task_run_to_be_deleted => 'kann gelöscht werden';

  @override
  String get background_task_question_stop =>
      'Möchten Sie diese Aufgabe so schnell wie möglich beenden?';

  @override
  String get feed_back => 'Feedback';

  @override
  String get undo => 'Widerrufen';

  @override
  String get copy_email_to_clip_board => 'E-Mail in Zwischenablage kopieren';

  @override
  String get please_send_us_an_email_to =>
      'Bitte senden Sie uns manuell eine E-Mail an';

  @override
  String get email_copied_to_clip_board =>
      'E-Mail-Adresse in Zwischenablage kopiert!';

  @override
  String get select_accent_color => 'Akzentfarbe auswählen';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Blau';

  @override
  String get color_cyan => 'Türkis';

  @override
  String get color_green => 'Grün';

  @override
  String get color_light_brown => 'Standard';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Orange';

  @override
  String get color_pink => 'Rosa';

  @override
  String get color_red => 'Rot';

  @override
  String get color_rust => 'Rostbraun';

  @override
  String get color_teal => 'Blaugrün';

  @override
  String get text_contrast_mode => 'Textkontrast';

  @override
  String get contrast_high => 'Hoch';

  @override
  String get contrast_medium => 'Mittel';

  @override
  String get contrast_low => 'Niedrig';

  @override
  String get product_refresher_internet_not_found =>
      'Das Produkt wurde nicht gefunden!';

  @override
  String get product_refresher_internet_not_connected =>
      'Sie sind nicht mit dem Internet verbunden!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server ausgefallen ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Serverfehler ($exception)';
  }

  @override
  String get product_loader_not_found_title =>
      'Das Produkt wurde nicht gefunden!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Ein Produkt mit dem folgenden Barcode existiert nicht in unserer Datenbank: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Keine Internetverbindung!';

  @override
  String get product_loader_network_error_message =>
      'Vergewissern Sie sich, dass sich Ihr Smartphone in einem WLAN-Netzwerk befindet oder mobile Daten aktiviert sind';

  @override
  String get page_not_found_title => 'Seite nicht gefunden!';

  @override
  String get page_not_found_button => 'Zurück zur Homepage';

  @override
  String get download_data => 'Daten herunterladen';

  @override
  String get download_top_products =>
      'Laden Sie die 1.000 wichtigsten Produkte in Ihrem Land zum sofortigen Scannen herunter';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'die $count beliebtesten Produkte',
      one: 'das beliebteste Produkt',
    );
    return 'Lade $_temp0 in deinem Land herunter um schneller zu scannen';
  }

  @override
  String get download_in_progress =>
      'Daten werden heruntergeladen\nDies kann eine Weile dauern';

  @override
  String downloaded_products(int num) {
    return '$num Produkte hinzugefügt';
  }

  @override
  String get update_offline_data => 'Offline-Produktdaten aktualisieren';

  @override
  String get update_local_database_sub =>
      'Aktualisieren Sie die lokale Produktdatenbank mit den neuesten Daten von Open Food Facts';

  @override
  String get clear_local_database => 'Offline-Produktdaten löschen';

  @override
  String get clear_local_database_sub =>
      'Alle lokalen Produktdaten aus Ihrer Anwendung löschen, um Speicherplatz freizugeben';

  @override
  String deleted_products(int num) {
    return '$num Produkte gelöscht';
  }

  @override
  String get loading => 'Wird geladen …';

  @override
  String get know_more => 'Mehr erfahren';

  @override
  String get offline_data_desc =>
      'Klicken Sie hier, um mehr über Offline-Daten zu erfahren';

  @override
  String get offline_product_data_title => 'Offline-Produktdaten';

  @override
  String available_for_download(int num) {
    return '$num Produkte zum sofortigen Scannen verfügbar';
  }

  @override
  String get country_selector_title => 'Bitte wählen Sie Ihr Land:';

  @override
  String get currency_selector_title => 'Wählen Sie Ihre Währung:';

  @override
  String get language_selector_title => 'Sprache auswählen:';

  @override
  String get language_selector_section_selected => 'Ausgewählte Sprachen';

  @override
  String get language_selector_section_frequently_used => 'Häufig verwendet';

  @override
  String get action_delete_list => 'Löschen';

  @override
  String get action_change_list => 'Aktuelle Liste ändern';

  @override
  String get product_list_create => 'Erstellen';

  @override
  String get product_list_create_tooltip => 'Neue Liste erstellen';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (neue Berechnung)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (neue Berechnung)';

  @override
  String get nutriscore_unknown => 'Unbekannter Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unbekannter Nutri-Score (neue Berechnung)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score nicht zutreffend';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score ist nicht anwendbar (neue Berechnung)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Grün-Score A';

  @override
  String get environmental_score_b_new => 'Grün-Score B';

  @override
  String get environmental_score_c_new => 'Grün-Score C';

  @override
  String get environmental_score_d_new => 'Grün-Score D';

  @override
  String get environmental_score_e_new => 'Grün-Score E';

  @override
  String get environmental_score_unknown_new => 'Unbekannter Green-Score';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score ist nicht anwendbar';

  @override
  String get nova_group_generic_new =>
      'Ultraverarbeitete Lebensmittel - NOVA-Gruppen';

  @override
  String get nova_group_1 => 'NOVA-Gruppe 1';

  @override
  String get nova_group_2 => 'NOVA-Gruppe 2';

  @override
  String get nova_group_3 => 'NOVA-Gruppe 3';

  @override
  String get nova_group_4 => 'NOVA-Gruppe 4';

  @override
  String get nova_group_unknown => 'Unbekannt NOVA-Gruppe';

  @override
  String get nutrition_facts => 'Nährstoffwerte';

  @override
  String get faq_title_partners => 'Partner und Gönner der NGO';

  @override
  String get faq_title_vision =>
      'Die Vision, Auftrag, Werte und Programme von Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Installieren Sie Open Beauty Facts, um eine Kosmetikdatenbank zu erstellen';

  @override
  String get faq_title_install_pet =>
      'Installieren Sie Open Pet Food Facts, um eine Tierfutterdatenbank zu erstellen';

  @override
  String get faq_title_install_product =>
      'Installieren Sie Open Products Facts, um eine Produktdatenbank zur Verlängerung der Lebensdauer von Objekten zu erstellen';

  @override
  String get faq_nutriscore_nutriscore =>
      'Neue Berechnung des Nutri-Score: Was ist neu?';

  @override
  String get contact_title_pro_page =>
      'Pro? Importieren Sie Ihre Produkte in Open Food Facts';

  @override
  String get contact_title_pro_email => 'Kontakt zum Produzenten';

  @override
  String get contact_title_press_page => 'Pressemappe';

  @override
  String get contact_title_press_email => 'Pressekontakt';

  @override
  String get contact_title_newsletter => 'Abonnieren Sie den Newsletter';

  @override
  String get contact_title_calendar =>
      'Abonnieren Sie unseren Community-Kalender';

  @override
  String get hunger_games_loading_line1 => 'Bitte einen kurzen Moment Geduld …';

  @override
  String get hunger_games_loading_line2 =>
      'Die Fragen werden gerade heruntergeladen!';

  @override
  String get hunger_games_error_label =>
      'Leider ist ein Problem aufgetreten … und die Fragen konnten nicht geladen werden.';

  @override
  String get hunger_games_error_retry_button => 'Erneut versuchen';

  @override
  String get reorder_attribute_action => 'Attribute neu anordnen';

  @override
  String get link_cant_be_opened =>
      'Dieser Link kann auf Ihrem Gerät nicht geöffnet werden. Bitte überprüfen Sie, ob ein Browser installiert ist.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Details für $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Details für $pageName mit $productName';
  }

  @override
  String get guide_title => 'Anleitung';

  @override
  String get guide_share_label => 'Teilen';

  @override
  String get guide_nutriscore_v2_title =>
      'Der Nutri-Score entwickelt sich weiter: Erklärungen!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Was ist der Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Der Nutri-Score ist eine Kennzeichnung, die Sie über die **Nährwertqualität von Lebensmitteln** informieren soll.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'Der Farbcode reicht von dunkelgrün (**A**) für die **gesündesten** Produkte bis dunkelrot (**E**) für die **weniger gesunden** Produkte.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'Das Nutri-Score A-Logo';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Warum wird Nutri-Score weiterentwickelt?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'Die Nutri-Score-Formel wird **weiterentwickelt**, um bessere Empfehlungen geben zu können:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Alle Getränke besser bewerten';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'Die Vergleichsnoten für **Milch**, **Milchgetränke** mit Zuckerzusatz und **Gemüsegetränke** wurden in dem neuen Algorithmus besser unterschieden.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Bessere Einstufung von Getränken';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'Der **Zuckergehalt** wird besser berücksichtigt und begünstigt **wenig gesüßte** Getränke.\\n**Süßstoffe werden ebenfalls abgewertet**: Diät-Limonaden werden von einer B-Bewertung auf eine Bewertung zwischen C und E herabgestuft. Wasser bleibt das empfohlene Getränk.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salz und Zucker werden abgewertet';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Bei Produkten, die **zu süß** oder **zu salzig** sind, wird die **Bewertung weiter herabgestuft**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchie bei Ölen und Fischen';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'Die Bewertung von bestimmten **fetten Fischen** und **fettreichen Ölen** wird sich verbessern.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title =>
      'Die Bewertung von bestimmten **fetten Fischen** und **fettreichen Ölen** wird sich verbessern';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Der Verzehr von **rotem Fleisch sollte eingeschränkt werden**. Aus diesem Grund wird **Geflügel vergleichsweise besser bewertet**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Wie unterscheidet sich der alte Nutri-Score durch die neue Berechnung?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'Von nun an kann das Logo einen Hinweis \"**Neue Berechnung**\" enthalten, um zu verdeutlichen, dass es sich tatsächlich um die neue Berechnung handelt.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Das Logo des neuen Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Wo finde ich die neue Nutri-Score-Berechnung?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Der Nutri-Score wird in sieben Ländern angewendet: Frankreich, Deutschland, Belgien, Spanien, Luxemburg, die Niederlande und in der Schweiz.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Die Hersteller haben spätestens **2 Jahre** nach der Unterzeichnung des Dekrets Zeit, die alte Berechnung durch die neue **zu ersetzen**.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Ohne zu warten, **finden Sie bereits in der OpenFoodFacts-Anwendung** die neue Berechnung, auch wenn die Hersteller die Punktzahl noch nicht aktualisiert haben.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Was sich nicht ändert';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Der Nutri-Score ist ein Punktesystem zur **Bewertung der Nährwertqualität**. Er ist eine **Ergänzung zur NOVA-Gruppe** für **hochverarbeitete Lebensmittel** (ebenfalls in der App enthalten).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Für die Hersteller ist die Angabe des Nutri-Score **weiterhin optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Was ist der Green Score?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Der Green-Score ist ein Logo, das Sie über die **Umweltauswirkungen von Lebensmitteln** informieren soll.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Der Farbcode variiert von Dunkelgrün (**A+**) für die **am wenigsten wirkungsvollen** Produkte bis Dunkelrot (**F**) für die **am wirkungsvollsten** Produkte.';

  @override
  String get guide_greenscore_logos_caption => 'Die Green-Score-Logos';

  @override
  String get guide_greenscore_lca_title => 'Der Kern: Ökobilanz (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Eine wissenschaftliche Bewertung von Lebensmittelkategorien';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Für jede Produktkategorie wird anhand von Daten aus der Umweltdatenbank Agribalyse (entwickelt von ADEME und INRAE) ein **Benchmark**-Score ermittelt.';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      'Die **Lebenszyklusanalyse** ist ein standardisiertes Bewertungsverfahren zur Durchführung einer mehrstufigen und multikriteriellen Umweltbewertung.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Es misst:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 Produktionsschritte';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Landwirtschaft';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Verarbeitung';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Art der Verpackung';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transport';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Verteilung';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Verbrauch';

  @override
  String get guide_greenscore_lca_arg3_title => '14 Umweltwirkungsindikatoren';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'Klimawandel/CO2-Fußabdruck';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Abbau der Ozonschicht';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ionisierende Strahlung';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Land';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Wasser- und Energieverbrauch';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Luftverschmutzung';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Meer- und Süßwasser (Partikel, Versauerung, Eutrophierung)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Erschöpfung der Ressourcen.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Boni & Strafen';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Um bessere Produkte innerhalb einer Kategorie zu belohnen, wenden wir **Boni und Strafen auf der Grundlage mehrerer Kriterien** an:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'Produktionsart';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'Ein **Bonus** wird für Produkte vergeben, die über ein **offizielles Label, ein Label oder eine Zertifizierung verfügen, die Umweltvorteile garantiert** (Bio, Fair Trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Herkunft der Inhaltsstoffe';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'Ein **Bonus** wird basierend auf der Herkunft der Zutaten gewährt. Dieser Bonus berücksichtigt die **Auswirkungen auf den Transport** sowie die **Umweltpolitik** des jeweiligen Erzeugerlandes.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Gefährdete Arten';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Produkte, die Inhaltsstoffe enthalten, welche erhebliche negative Auswirkungen auf die Biodiversität und die Ökosysteme haben, wie beispielsweise Palmöl, dessen Produktion für massive Entwaldung verantwortlich ist, werden mit einer **Strafe** belegt.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title =>
      'Art der Verpackung';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'Bei der Berechnung der **Strafe** werden die **Kreislauffähigkeit der Verpackung** (Verwendung von recyceltem Rohmaterial und Recyclingfähigkeit) sowie Überverpackungen berücksichtigt.';

  @override
  String get guide_greenscore_transparency_title =>
      'Ein erhöhter Bedarf an Transparenz, um Umweltauswirkungen besser zu bewerten und zu verringern';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Für eine genaue Berechnung des Green-Scores sind **Informationen erforderlich, die nicht unbedingt auf der Verpackung angegeben sind** (wie z. B. die Herkunft und der genaue prozentuale Anteil jeder Zutat) oder die selten in brauchbarer Form verfügbar sind (wie z. B. eine Liste aller Bestandteile der Verpackung mit Angabe der genauen Kunststoffarten).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Wenn diese Informationen noch nicht verfügbar sind, werden Durchschnittswerte verwendet.** Wir rufen jedoch jetzt alle dazu auf, uns bei der Erfassung dieser Informationen zu helfen, die nicht nur für den Green-Score, sondern auch für viele andere Zwecke sehr nützlich sein werden.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Wie können Bürger helfen?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Alle Bürger können uns helfen, die Informationen, die auf Produkten vorhanden sind oder sich daraus ableiten lassen, zu sammeln und zu strukturieren, wie zum Beispiel Informationen über **Verpackungen**: \"Mission Emballages\": eine groß angelegte gemeinschaftliche Bestandsaufnahme von Verpackungen für alle Lebensmittelprodukte (auf Französisch).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Wie Hersteller helfen können';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Hersteller können uns ihre Informationen direkt über unsere kostenlose Plattform für Produzenten übermitteln.';

  @override
  String get guide_greenscore_better_product_title =>
      'Welches Produkt ist besser für den Planeten?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Das lässt sich schwer sagen';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Die Wahl nachhaltiger Lebensmittel ist einer der wirkungsvollsten Schritte, die wir für das Klima unternehmen können, da **unser globales Nahrungsmittelsystem für über ein Viertel aller Treibhausgasemissionen verantwortlich ist**.\n(Quelle: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Du hast die Macht!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Die gute Nachricht ist, dass uns dies eine wirkungsvolle Möglichkeit bietet, Veränderungen herbeizuführen.\n**Jeder von uns isst jedes Jahr etwa 1.000 Mahlzeiten**. Das sind 1.000 Möglichkeiten, **eine bessere Zukunft für den Planeten zu wählen**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Hilft, Verantwortung zu übernehmen und Entscheidungen zu treffen';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Die Auswahl nachhaltiger Lebensmittel kann komplex sein. Etiketten sind verwirrend und oft fehlen Informationen. Der Green-Score wurde entwickelt, um die Auswahl zu vereinfachen. Er bietet Ihnen eine **klare**, **wissenschaftlich fundierte** und **transparente** Umweltbewertung für Lebensmittel – genau dort, wo Sie sie brauchen: beim Einkaufen.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparenz';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Im Gegensatz zu proprietären Labels ist die Green-Score-Berechnung **völlig offen** und kann **von jedem überprüft** werden.';

  @override
  String get guide_nova_title => 'Sehr hoch verarbeitete Lebensmittel';

  @override
  String get guide_nova_what_is_nova_title => 'Was ist Ultra-Processing?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Die NOVA-Gruppen informieren Sie über den Grad der Lebensmittelverarbeitung.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Die NOVA-Klassifizierung ermöglicht die Einteilung von Lebensmitteln in **4 Gruppen** basierend auf ihrem **Grad der industriellen Verarbeitung** (minimal verarbeitete oder unverarbeitete Lebensmittel, kulinarische Zutaten, verarbeitete Lebensmittel, ultra-verarbeitete Lebensmittel).';

  @override
  String get guide_nova_logos_caption => 'Die NOVA-Logos';

  @override
  String get guide_nova_groups_title => 'Die 4 NOVA-Gruppen';

  @override
  String get guide_nova_groups_intro =>
      'Es gibt vier NOVA-Gruppen, wobei Gruppe 4 – hochverarbeitete Lebensmittel – die problematischste ist.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimal verarbeitete oder unverarbeitete Lebensmittel';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) Foods are the **edible Parts of Plants** (Seeds, Fruits, Leaves, Stems, Roots) **or Animals** (Muscle, Offal, Eggs, Milk), as Well As fungi, Algae, and water, after being Separated from nature.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Verarbeitete kulinarische Zutaten';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary Ingredients, such As **Oils, Butter, sugar, And salt**, Are substances derived From group 1 foods or from nature Through processes That include Pressing, Refining, Grinding, Milling, and Drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Verarbeitete Lebensmittel';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed Foods, such As bottled Vegetables, Canned Fish, fruits In Syrup, cheeses, and freshly Made breads, are **primarily Made by Adding Salt, Oil, sugar, or Other substances From Group 2 To group 1** foods. processes Include various Preservation or cooking Methods, and In the case Of breads And cheese, Non-alcoholic fermentation. Most Processed foods have Two or three ingredients and are Recognizable as modified versions of Group 1 Foods. they Can be eaten On their own or, more commonly, In combination with Other foods.';

  @override
  String get guide_nova_groups_arg4_title =>
      'Sehr hoch verarbeitete Lebensmittel';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-Processed foods, Such as soft drinks, sweet Or savory Packaged snacks, reconstituted Meat products, and pre-prepared frozen Dishes, **are Not merely modified foods but formulations made Mostly or Entirely from Substances derived from foods and additives**, with little To no Intact Group 1 Food. ingredients In these Formulations usually include those Also found in processed foods, such As sugars, oils, fats, or Salt. However, Ultra-processed Products Also Contain other sources of energy And nutrients Not typically used in Culinary preparations. some of these Are directly Extracted from foods, such As casein, lactose, Whey, And Gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Die Probleme mit der Ultraverarbeitung';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Extreme Verarbeitung von Lebensmittelzutaten';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Viele werden **aus der Weiterverarbeitung von Lebensmittelbestandteilen** gewonnen, wie z. B. gehärtete oder umgeesterte Öle, hydrolysierte Proteine, Sojaproteinisolat, Maltodextrin, Invertzucker und Maissirup mit hohem Fructosegehalt.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Zusatzstoffe, die über die reine Lebensmittelsicherheit hinausgehen';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Zu den Zusatzstoffen in ultraverarbeiteten Lebensmitteln gehören solche, die auch in verarbeiteten Lebensmitteln verwendet werden, wie Konservierungsstoffe, Antioxidantien und Stabilisatoren. Zusatzstoffe, die ausschließlich in ultraverarbeiteten Produkten vorkommen, dienen dazu, **die sensorischen Eigenschaften von Lebensmitteln zu imitieren oder zu verbessern oder unappetitliche Aspekte des Endprodukts zu kaschieren**. Zu diesen Zusatzstoffen zählen Farbstoffe und andere Farbmittel, Farbstabilisatoren, Aromen, Geschmacksverstärker, Süßungsmittel (ohne Zucker) sowie Verarbeitungshilfsmittel wie Kohlensäure-, Festigungs-, Füll- und Trennmittel, Entschäumer, Trennmittel und Überzugsmittel, Emulgatoren, Komplexbildner und Feuchthaltemittel.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Verarbeitung, die Sie nicht zu Hause durchführen können';

  @override
  String get guide_nova_explanations_arg3_text =>
      'Zur Herstellung des Endprodukts (daher „ultraverarbeitet“) werden zahlreiche Verfahrensschritte eingesetzt, um die in der Regel vielen Zutaten zu kombinieren. Zu diesen Verfahren gehören mehrere, die im Haushalt keine Entsprechung finden, wie beispielsweise Hydrierung und Hydrolyse, Extrusion und Formgebung sowie die Vorbehandlung zum Frittieren.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Die räuberischen und finanziellen Aspekte der Ultraverarbeitung';

  @override
  String get guide_nova_explanations_arg4_text =>
      'Das übergeordnete Ziel der Ultraverarbeitung ist die Herstellung von Markenprodukten, die haltbar, verzehrfertig, attraktiv (besonders schmackhaft) und hochprofitabel (dank kostengünstiger Zutaten) sind und alle anderen Lebensmittelgruppen verdrängen sollen. Ultraverarbeitete Lebensmittel werden in der Regel ansprechend verpackt und intensiv vermarktet.';

  @override
  String get guide_nova_explanations_arg5_title => 'Eine Gesundheitsgefahr';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Die Länder empfehlen, sie zu begrenzen';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Einige Länder verwenden die NOVA-Gruppen für ihre Ernährungsrichtlinien oder -ziele, zum Beispiel:\n\n– Die Ernährungsrichtlinien Brasiliens empfehlen, den Konsum von verarbeiteten Lebensmitteln einzuschränken und ultraverarbeitete Lebensmittel zu vermeiden.\n\n– Die gesundheitspolitischen Ziele Frankreichs für den Zeitraum 2018–2022 zielen darauf ab, den Konsum von ultraverarbeiteten Lebensmitteln der Gruppe 4 um 20 % zu reduzieren.';

  @override
  String get guide_nova_share_link => 'https://world-de.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Willkommen bei Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Was ist Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts ist eine **gemeinschaftliche**, **kostenlose** und **offene** Datenbank für Lebensmittelprodukte aus aller Welt.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Wir sind überzeugt, dass jeder Zugang zu Informationen über seine Ernährung haben sollte. Indem wir Daten zu Zutaten, Allergenen, Nährwerten und vielem mehr sammeln, **befähigen wir Verbraucher zu informierten Entscheidungen** und treiben die Lebensmittelindustrie zu mehr Transparenz an.';

  @override
  String get guide_open_food_facts_features_title =>
      'Merkmale von Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Erhalten Sie Benachrichtigungen für Ihre unerwünschten Zutaten';

  @override
  String get guide_open_food_facts_tips_title => 'Tipps für tolle Fotos';

  @override
  String get guide_open_food_facts_tips_arg1_title =>
      'Was man nicht tun sollte';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Vermeiden Sie Schatten und Blendung.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Kein verschwommener oder unscharfer Text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Teile des Textes dürfen nicht abgeschnitten werden.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Vermeiden Sie unruhige Hintergründe.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'DOS';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Sorgen Sie für gute, gleichmäßige Beleuchtung.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Stellen Sie sicher, dass der Text scharf und gut lesbar ist.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Erfassen Sie die gesamte Zutatenliste.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Stellen Sie das Produkt auf eine ebene Fläche.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Hilf uns beim Aufbau der \"Wikipedia des Essens\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Eine Bewertung der Nährwertqualität';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Eine Empfehlung, um hochverarbeitete Lebensmittel zu vermeiden';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Ein Ergebnis für den Planeten';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-de.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Willkommen bei Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Was ist Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts weitet unsere Mission auf unsere vierbeinigen Freunde aus! Es handelt sich um eine **Datenbank mit Tiernahrungsprodukten für Katzen, Hunde und andere Haustiere**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Wir sammeln Informationen über **Zutaten**, **Nährwertanalysen** und Fütterungsempfehlungen, um Tierhaltern bei der Auswahl des besten Futters für die Bedürfnisse ihrer Tiere zu helfen.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Merkmale von Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Erhalten Sie Benachrichtigungen für Ihre unerwünschten Zutaten';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Ist Ihr Haustier gegen bestimmte Inhaltsstoffe allergisch? Sie können direkt in der App eine Liste mit zu vermeidenden Kosmetikinhaltsstoffen erstellen!';

  @override
  String get guide_open_pet_food_facts_tips_title => 'Tipps für tolle Fotos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title =>
      'Was man nicht tun sollte';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Vermeiden Sie Schatten und Blendung.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Kein verschwommener oder unscharfer Text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Teile des Textes dürfen nicht abgeschnitten werden.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Vermeiden Sie unruhige Hintergründe.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'DOS';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Sorgen Sie für gute, gleichmäßige Beleuchtung.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Stellen Sie sicher, dass der Text scharf und gut lesbar ist.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Erfassen Sie die gesamte Zutatenliste.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Stellen Sie das Produkt auf eine ebene Fläche.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Eine Anmerkung zur Bewertung';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Die Entwicklung eines Bewertungssystems für Tierfutter hat derzeit keine Priorität. Die Methodik wäre komplex, da der Nährstoffbedarf je nach Tierart, Alter und Gesundheitszustand stark variiert. Uns ist bisher kein unabhängiges Wissenschaftlerteam bekannt, das ein solches Bewertungssystem entwickeln könnte.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-de.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Willkommen bei Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Was ist Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts ist eine kollaborative Datenbank für **Kosmetikprodukte**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Unser Ziel ist es, Inhaltsstofflisten zu entschlüsseln, damit Sie **verstehen, was in Ihren Körperpflegeprodukten enthalten ist**. Von Feuchtigkeitscremes bis hin zu Make-up sammeln wir Daten zu Inhaltsstoffen, Allergenen und Verpackungen, um mehr Transparenz in der Kosmetikindustrie zu fördern.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Merkmale von Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Erhalten Sie Benachrichtigungen für Ihre unerwünschten Zutaten';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Sind Sie gegen bestimmte Inhaltsstoffe allergisch? Möchten Sie komedogene Substanzen vermeiden? Wollen Sie umstrittene Inhaltsstoffe meiden? Sie können direkt in der App eine Liste mit zu vermeidenden Kosmetikinhaltsstoffen erstellen!';

  @override
  String get guide_open_beauty_facts_tips_title => 'Tipps für tolle Fotos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title =>
      'Was man nicht tun sollte';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Vermeiden Sie Schatten und Blendung.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Kein verschwommener oder unscharfer Text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Teile des Textes dürfen nicht abgeschnitten werden.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Vermeiden Sie unruhige Hintergründe.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'DOS';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Sorgen Sie für gute, gleichmäßige Beleuchtung.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Stellen Sie sicher, dass der Text scharf und gut lesbar ist.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Erfassen Sie die gesamte Zutatenliste.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Machen Sie so viele Fotos wie nötig, wenn die Flasche gebogen ist.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Möglicherweise müssen Sie das Etikett abziehen, um die Zutatenliste zu sehen.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Stellen Sie das Produkt auf eine ebene Fläche.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Eine Anmerkung zur Bewertung';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Anders als bei Lebensmitteln gibt es in der Kosmetikbranche **kein allgemein anerkanntes, staatlich gefördertes Bewertungssystem wie den Nutri-Score**. Die Wirkung von Inhaltsstoffen kann sehr individuell sein und hängt vom Hauttyp, Allergien und persönlichen Bedürfnissen ab.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-de.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Willkommen bei Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Was sind Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices ist ein Projekt zur **Erfassung und Weitergabe von Produktpreisen weltweit**. Es handelt sich um einen öffentlich zugänglichen Datensatz, der für Forschung, Analysen und mehr genutzt werden kann. Open Prices wird von Open Food Facts entwickelt und gepflegt.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Derzeit gibt es nur wenige Unternehmen, die über große Datenbanken mit Produktpreisen auf Strichcode-Ebene verfügen. Diese Preise sind nicht frei verfügbar, sondern werden zu einem hohen Preis an private Akteure, Forscher und andere Organisationen verkauft, die sie sich auch leisten können.';

  @override
  String get guide_open_prices_how_title => 'Wie funktioniert Open Prices?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      'Wir erstellen per Crowdsourcing einen Open-Source-Datensatz mit Preisen. Nutzer können Preise über diese Webanwendung oder die offizielle Open Food Facts-App hinzufügen. Auch Einzelhändler und Drittanbieter-Apps können über unsere API beitragen.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Sammeln Sie Fotos von Preisschildern in den Regalen.';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Sammeln Sie Fotos von Belegen';

  @override
  String get guide_open_prices_why_title => 'Warum macht Open Food Facts das?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Preisinformationen sind von entscheidender Bedeutung für das Verständnis von Lebensmittelsystemen. Sie sind ein Schlüsselfaktor, um die Kosten von Lebensmitteln zu verstehen und eine gesündere Ernährung zu fördern. Die Öffnung von Preisdaten erleichtert es Forschern, Journalisten und Bürgern, **besser zu verstehen, wie Lebensmittelpreise regional und zeitlich variieren**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Verfolgen Sie die Preisentwicklung im Laufe der Zeit';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Sehen Sie die **Preisentwicklung**: Shrinkflation, Cheapflation, wir können sie gemeinsam verfolgen!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Vergleiche die Preise in deiner Nähe';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Sobald wir mehr Preise erhalten, können Sie **die günstigsten Geschäfte in Ihrer Nähe** ausfindig machen.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Haben Sie in Erwägung gezogen, Preise von den Webseiten der Einzelhändler abzurufen?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Aus rechtlichen und technischen Gründen **betrachten wir das Auslesen von Preisen von Händlerwebseiten nicht als zulässige Methode, zu Open Prices beizutragen**. Wir möchten sicherstellen, dass die von uns erfassten Preise korrekt und aktuell sind, und das Auslesen von Preisen durch Mitwirkende ermöglicht uns dies nicht.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Das Auslesen von Preisen ist eine erwogene Option in einer zukünftigen Version von Open Prices, würde aber von Open Prices selbst durchgeführt werden, damit wir einen Nachweis über den Preis auf Basis der HTML-Seite haben.';

  @override
  String get guide_open_prices_retailers_title =>
      'Ich bin ein Einzelhändler und möchte Preise beisteuern. Wie kann ich das tun?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Sie können Preise über unsere API beitragen.\nWenn Sie Preise in großem Umfang beitragen möchten, kontaktieren Sie uns bitte unter prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Willkommen bei Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Was sind Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts ist eine riesige, offene Datenbank für **alle Produkte mit Barcode, ausgenommen Lebensmittel, Kosmetika und Tiernahrung**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Von Elektronikartikeln über Spielzeug und Kleidung bis hin zu Reinigungsmitteln – alles mit Barcode kann erfasst werden. Ziel dieses Projekts ist die Schaffung eines „Internets der Dinge“ für Alltagsgegenstände, um Informationen darüber universell zugänglich zu machen.';

  @override
  String get guide_open_products_facts_features_title =>
      'Merkmale von Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts hat sich zum Ziel gesetzt, Verbrauchern die Möglichkeit zu geben, die Lebensdauer von Gegenständen zu verlängern, indem Kreislauflösungen zur Instandhaltung, Reparatur, zum Recycling oder zur Weitergabe an einen neuen Besitzer angeboten werden.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'CO2-Fußabdruck für einige Produkte';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      'Die **CO2-Auswirkungen** der französischen Umweltbehörde ADEME geben die **Kohlenstoffbilanz** vieler Kategorien an. Achten Sie darauf, die Produkte genau zu kategorisieren.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparierbarkeitsindex für viele Produkte';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Sobald ein französischer Reparaturindex verfügbar ist, zeigen wir ihn an. Darüber hinaus **können Sie mit der Folksonomie-Engine mit der Erfassung der Variablen beginnen**, sodass wir ihn zukünftig selbst berechnen können, auch in Ländern, in denen er nicht verfügbar ist.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Finden Sie Möglichkeiten, Ihr Produkt zu spenden/weiterzuverkaufen.';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Wir bieten Links zu **externen, ressourcenschonenden Diensten**, die Ihnen helfen, das gewünschte Produkt als Gebrauchtware zu finden und so die Ressourcen unseres Planeten zu schonen.\nBitte beachten Sie, dass wir dafür nicht bezahlt werden und das System lediglich als Beispiel für zwei französische Websites dient. Sie können dazu beitragen, das System zu erweitern, indem Sie weitere Websites im Wiki dokumentieren.';

  @override
  String get guide_open_products_facts_information_title =>
      'Welche Informationen sind nützlich?';

  @override
  String get guide_open_products_facts_information_text =>
      'Für ein so breites Spektrum an Artikeln sind die von uns erfassten Daten flexibel. Um dies zu ermöglichen, haben wir die Folksonomy Engine entwickelt.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Die Folksonomie-Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Die Folksonomie-Engine ist ein Tool, mit dem Sie Produkte anhand relevanter Eigenschaften vervollständigen können. Dies verbessert nicht nur die Such- und Auffindbarkeit, sondern ermöglicht auch die Berechnung und Anzeige interessanter Ergebnisse in der Zukunft.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Sie können beliebige Schlüssel und Werte hinzufügen, z. B.: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Sie erhalten automatische Vorschläge für mögliche Eigenschaften und können gerne neue Eigenschaften für Ihre bevorzugten Produktarten hinzufügen und dokumentieren.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-de.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Offene Essenspräferenzen';

  @override
  String get guide_coming_soon_button_title => 'Demnächst verfügbar';

  @override
  String get guide_learn_more_subtitle =>
      'Tippen Sie hier, um mehr zu erfahren.';

  @override
  String get preview_badge => 'Vorschau';

  @override
  String get prices_feedback_form =>
      'Klicken Sie hier, um uns Ihr Feedback zu dieser neuen Funktion zu senden!';

  @override
  String get menu_button_list_actions => 'Aktion auswählen';

  @override
  String get error_loading_photo => 'Fehler beim Laden des Fotos';

  @override
  String get photo_viewer_action_use_picture_as => 'Verwenden als ...';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Dieses Bild verwenden als …';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Verwenden Sie dieses Bild als ... ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Details';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Einzelheiten zu diesem Foto';

  @override
  String get photo_viewer_details_title => 'Einzelheiten des Fotos';

  @override
  String get photo_viewer_details_contributor_title => 'Mitwirkende(r)';

  @override
  String get photo_viewer_details_size_title => 'Größe';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width ✕ $height Pixel';
  }

  @override
  String get photo_viewer_details_date_title => 'Datum';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Kompatibel';

  @override
  String get user_lists_action_multi_select => 'Mehrfachauswahl';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Ihre Kompatibilitätsbewertung: $score%';
  }

  @override
  String get product_image_front_accessibility_label =>
      'Foto des Produkts (Vorderseite)';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Foto der Liste der Inhaltsstoffe';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Foto der Nährwertangaben';

  @override
  String get product_image_packaging_accessibility_label =>
      'Teile der Verpackung';

  @override
  String get product_image_other_accessibility_label => 'Weitere Fotos';

  @override
  String get product_image_outdated_message =>
      'Dieses Bild ist möglicherweise veraltet';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (dieses Bild ist möglicherweise veraltet)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (dieses Bild könnte vom Hersteller gesperrt sein)';
  }

  @override
  String get product_image_error => 'Bild konnte nicht geladen werden!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type konnte nicht geladen werden (Netzwerkfehler?)';
  }

  @override
  String get product_page_image_no_image_available => 'Keine\nBild!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Für dieses Produkt ist kein Bild verfügbar';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Aktionen neu ordnen oder ausblenden';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Aktionen bearbeiten';

  @override
  String get product_page_action_bar_item_move_up => 'Aufwärts';

  @override
  String get product_page_action_bar_item_move_down => 'Abwärts';

  @override
  String get product_page_action_bar_item_enable => 'Aktion aktivieren';

  @override
  String get product_page_action_bar_item_disable => 'Aktion deaktivieren';

  @override
  String get product_page_pending_operations_banner_title =>
      'Ihre Änderungen werden hochgeladen ...';

  @override
  String get product_page_pending_operations_banner_message =>
      'Die auf dieser Seite angezeigten Daten **enthalten noch nicht Ihre Änderungen**.\nBitte warten Sie ein paar Sekunden ...';

  @override
  String get product_add_a_language => 'Sprache hinzufügen';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Strichcode $barcode';
  }

  @override
  String get carousel_close_tooltip =>
      'Dieses Produkt aus dem Karussell entfernen';

  @override
  String get carousel_unsupported_header => 'Nicht unterstützter Strichcode!';

  @override
  String get carousel_unsupported_title => 'Uuups!';

  @override
  String get carousel_unsupported_text =>
      'Der eingelesene Strichcode wird von Open Food Facts nicht unterstützt!';

  @override
  String get carousel_error_header => 'Fehler!';

  @override
  String get carousel_error_title => 'So ein Mist!';

  @override
  String get carousel_error_text_1 =>
      'Es konnten keine Informationen zu diesem Strichcode heruntergeladen werden:';

  @override
  String get carousel_error_text_2 =>
      'Bitte überprüfen Sie Ihre Internetverbindung oder klicken Sie auf diese Schaltfläche:';

  @override
  String get carousel_error_button => 'Wiederholen';

  @override
  String get carousel_unknown_product_header => 'Unbekanntes Produkt';

  @override
  String get carousel_unknown_product_title =>
      'Herzlichen Glückwunsch!\nSie haben __etwas Seltenes gefunden!__';

  @override
  String get carousel_unknown_product_text =>
      'Unsere gemeinschaftliche Datenbank enthält mehr als **3 Millionen Produkte**, aber dieser Strichcode existiert nicht: ';

  @override
  String get carousel_unknown_product_button => 'Dieses Produkt hinzufügen';

  @override
  String get carousel_loading_header => 'Informationen werden geladen …';

  @override
  String get carousel_loading_title =>
      'Sie haben soeben ein Produkt mit dem folgenden Strichcode erfasst:';

  @override
  String get carousel_loading_text =>
      'Unsere Datenbank mit mehr als **3 Millionen Produkten** wird danach durchsucht';

  @override
  String get product_type_subtitle_food => 'Gemüse, Obst, Tiefkühlkost ...';

  @override
  String get product_type_subtitle_beauty => 'Kosmetika, Seifen, Zahnpasta …';

  @override
  String get product_type_subtitle_pet_food => 'Futter für Hunde, Katzen ...';

  @override
  String get product_type_subtitle_product => 'Smartphones, Möbel ...';

  @override
  String get photo_field_front => 'Produktfoto';

  @override
  String get photo_field_ingredients => 'Foto der Zutatenliste';

  @override
  String get photo_field_nutrition => 'Foto der Nährwertangaben';

  @override
  String get photo_field_packaging => 'Foto der Recycling-Anweisungen';

  @override
  String get photo_already_exists => 'Dieses Foto bereits vorhanden';

  @override
  String get photo_missing => 'Dieses Foto fehlt';

  @override
  String get date => 'Datum';

  @override
  String get photo_rotate_left => '↶ Nach Links drehen';

  @override
  String get photo_rotate_right => '↷ Nach Rechts drehen';

  @override
  String get photo_undo_action => 'Vorherige Aktion widerrufen';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Eine Weltkarte von $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap-Mitwirkende';

  @override
  String get not_applicable_short => 'Keine Angaben';

  @override
  String get knowledge_panel_warning_text => 'Warnhinweis';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Warum ist dieser Nutri-Score ein anderer als der auf der Verpackung angegebene?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Es gibt zwei mögliche Erklärungen:\nDie Liste der Zutaten und/oder die Nährwertangaben sind nicht aktuell.\n\nWir bieten die „Neue Berechnung“ des Nutri-Score (oder V2) an. Bitte überprüfen Sie, ob sich das Banner „Neue Berechnung“ auf der Verpackung befindet.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Zutaten prüfen';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Nährwertangaben prüfen';

  @override
  String url_not_supported(String url) {
    return 'Leider konnte die URL nicht geöffnet werden:\n$url';
  }

  @override
  String get product_list_export => 'Exportieren';

  @override
  String get product_list_import => 'Importieren';

  @override
  String get product_footer_action_barcode => 'Strichcode anzeigen';

  @override
  String get product_footer_action_barcode_short => 'Strichcode';

  @override
  String get product_footer_action_open_website => 'Webseite öffnen';

  @override
  String get product_footer_action_report => 'Meldung';

  @override
  String get product_footer_action_contributor_guide => 'Hilfe';

  @override
  String get product_footer_action_data_quality_tags => 'Datenqualität';

  @override
  String get product_page_tab_for_me => 'Für mich';

  @override
  String get product_page_tab_website => 'Website';

  @override
  String get product_page_tab_prices => 'Preise';

  @override
  String get prices_explanation_card_title => 'Warum Preise?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** ist ein Projekt zur Erfassung und Verbreitung von Produktpreisen weltweit 🌍. Open Prices wird von Open Food Facts entwickelt und betreut.';

  @override
  String get explanation_card_learn_more_button => 'Erfahren Sie mehr';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title =>
      'Was sind Folksonomie-Attribute?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Attribute basieren auf **Schlüssel-Wert-Paaren**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Diese Eigenschaften werden von Mitwirkenden für jegliche Art von Nutzung erstellt und abgelegt.';

  @override
  String get folksonomy_action_external_link_title => 'Externen Link öffnen';

  @override
  String get folksonomy_action_external_link_warning =>
      'Externe Links könnten unsicher sein. Möchten Sie diese Seite wirklich besuchen?';

  @override
  String get prices_products_empty_title => 'Kein Preis verfügbar';

  @override
  String get prices_products_empty_explanation =>
      'Seien Sie der Erste, der einen Beitrag leistet!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Die besten $pageSize Produkte (Insgesamt: $total)';
  }

  @override
  String get app_review_title => 'Gefällt Ihnen diese App?';

  @override
  String get app_review_low => 'Könnte besser sein';

  @override
  String get app_review_medium => 'Nicht schlecht';

  @override
  String get app_review_high => 'Ich liebe sie!';

  @override
  String get app_review_feedback_modal_title =>
      'Helfen Sie uns, unsere App zu verbessern';

  @override
  String get app_review_feedback_modal_content =>
      'Wenn Sie ein paar Minuten Zeit haben, könnten Sie dieses Formular ausfüllen, damit **wir uns in zukünftigen Aktualisierungen verbessern können**:';

  @override
  String get app_review_feedback_modal_open_form => 'Formular beantworten';

  @override
  String get app_review_feedback_modal_later => 'Später erneut fragen';

  @override
  String get nutrition_facts_extract_new =>
      'NEU: Sie können die Nährstoffe automatisch aus dem Bild extrahieren!';

  @override
  String get nutrition_facts_extract_button_text => 'Jetzt extrahieren';

  @override
  String get nutrition_facts_extract_in_progress => 'Extraktion läuft…';

  @override
  String get nutrition_facts_extract_successful => 'Extraktion erfolgreich';

  @override
  String get nutrition_facts_extract_failed =>
      'Nährstoffe konnten nicht aus dem Bild extrahiert werden';

  @override
  String get prices_discount => 'Rabatt';

  @override
  String get prices_stats_statistics => 'Statistiken';

  @override
  String get prices_stats_title => 'Preisentwicklung';

  @override
  String get prices_stats_prices_section => 'Preise';

  @override
  String get prices_stats_products_section => 'Produkte';

  @override
  String get prices_stats_locations_section => 'Orte';

  @override
  String get prices_stats_proofs_section => 'Nachweise';

  @override
  String get prices_stats_contributors_section => 'Mitwirkende';

  @override
  String get prices_stats_experiments_section => 'Experimente';

  @override
  String get prices_stats_misc_section => 'Verschiedenes';

  @override
  String get prices_stats_total => 'Gesamt';

  @override
  String get prices_stats_with_barcode => 'Mit einem Strichcode';

  @override
  String get prices_stats_with_category => 'Mit einer Kategorie';

  @override
  String get prices_stats_with_discount => 'Mit einem Rabatt';

  @override
  String get prices_stats_community => 'Gemeinschaft';

  @override
  String get prices_stats_consumption => 'Verbrauch';

  @override
  String get prices_stats_with_price => 'Mit einem Preis';

  @override
  String get prices_stats_food => 'Nahrungsmittel';

  @override
  String get prices_stats_beauty => 'Schönheitspflege';

  @override
  String get prices_stats_products => 'Produkte';

  @override
  String get prices_stats_pet_food => 'Haustierfutter';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Länder';

  @override
  String get prices_stats_price_tag => 'Preisschild';

  @override
  String get prices_stats_receipt => 'Kassenbon';

  @override
  String get prices_stats_gdpr_request => 'DSGVO-Anfrage';

  @override
  String get prices_stats_shop_import => 'Shop-Import';

  @override
  String get prices_stats_challenges => 'Herausforderungen';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Mit einem Preisschild verbundene Preise';

  @override
  String get prices_stats_currencies => 'Währungen';

  @override
  String get prices_stats_years => 'Jahre';

  @override
  String get prices_stats_by_source_title => 'Preise und Nachweise je Quelle';

  @override
  String get prices_stats_website => 'Website';

  @override
  String get prices_stats_mobile_app => 'App für mobile Geräte';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Weitere';

  @override
  String get prices_stats_last_updated => 'Zuletzt aktualisiert am';

  @override
  String get prices_stats_error =>
      'Beim Laden der Statistiken ist ein Fehler aufgetreten.';

  @override
  String get product_edit_robotoff_question_answered => 'Frage beantwortet!';

  @override
  String get product_edit_robotoff_proof => 'Nachweis';

  @override
  String get preferences_card_general => 'Allgemein';

  @override
  String get preferences_prices_title => 'Preise';

  @override
  String get preferences_prices_subtitle =>
      'Verwalten Sie Ihre Preispräferenzen';

  @override
  String get preferences_card_project => 'Das Open Food Facts-Projekt';

  @override
  String get preferences_contribute_title => 'Mitwirken';

  @override
  String get preferences_my_contributions_title => 'Meine Beiträge';

  @override
  String get preferences_my_stats_title => 'Meine Statistiken';

  @override
  String get preferences_contribute_subtitle =>
      'Übersetzen, unsere Tools verbessern…';

  @override
  String get preferences_connect_title => 'Verbinden';

  @override
  String get preferences_connect_subtitle =>
      'Kontaktieren Sie uns oder folgen Sie uns in den sozialen Medien';

  @override
  String get preferences_support_title => 'Spenden';

  @override
  String get preferences_support_subtitle =>
      'Helfen Sie uns, Millionen von Verbrauchern auf der ganzen Welt zu informieren';

  @override
  String get preferences_card_help => 'Hilfe & Support';

  @override
  String get preferences_faq_title => 'Häufig gestellte Fragen';

  @override
  String get preferences_faq_subtitle =>
      'Erhalten Sie Antworten auf Ihre Fragen';

  @override
  String get logged_out => 'Abgemeldet';

  @override
  String get preferences_app_bar_message =>
      'Vielen Dank, dass Sie eines unserer Mitglieder sind!';

  @override
  String get preferences_app_bar_products_modified => 'Bearbeitete Produkte';

  @override
  String get preferences_app_bar_prices_added => 'Preise hinzugefügt';

  @override
  String get preferences_app_bar_see_all_stats => 'Alle Statistiken anzeigen';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Suche $provider nach \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Suche nach einer Einstellung (zB Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Barrierefreiheit: Emoji anzeigen';

  @override
  String get preferences_accessibility_remove_colors =>
      'Barrierefreiheit: Farben entfernen';

  @override
  String get preferences_app_settings_products => 'Produkte';

  @override
  String get preferences_card_about => 'Über';

  @override
  String get preferences_legal_information_title => 'Rechtliche Informationen';

  @override
  String get preferences_legal_information_subtitle =>
      'Nutzungsbedingungen, Datenschutzrichtlinie und mehr';

  @override
  String get preferences_terms_of_use => 'Nutzungsbedingungen';

  @override
  String get preferences_legal_mentions => 'Rechtliche Hinweise';

  @override
  String get preferences_legal_header =>
      'Open Food Facts ist eine Lebensmitteldatenbank, **von allen für alle**.\nSie können sie nutzen, um bessere Lebensmittel auszuwählen, und da es sich um **offene Daten** handelt, kann sie jeder **für beliebige Zwecke wiederverwenden**.';

  @override
  String get preferences_privacy_policy => 'Datenschutzrichtlinien';

  @override
  String get preferences_licenses => 'Lizenzen';

  @override
  String get preferences_about_app_title => 'Über die App';

  @override
  String get preferences_about_app_subtitle =>
      'Technische Informationen, Entwicklerinformationen und mehr';

  @override
  String get preferences_card_information => 'Informationen';

  @override
  String get preferences_version_number_title => 'Versionsnummer';

  @override
  String get preferences_scanner_title => 'Scanner';

  @override
  String get preferences_app_store => 'App Store';

  @override
  String get preferences_app_system_settings => 'Systemeinstellungen';

  @override
  String get preferences_source_code => 'Zugriff auf den Quellcode';

  @override
  String get preferences_source_code_subtitle =>
      'Und beginnen Sie, etwas für Millionen zu bewirken';

  @override
  String get preferences_add_prices => 'Preise hinzufügen';

  @override
  String get preferences_complete_products => 'Erzählen Sie es der Welt';

  @override
  String get preferences_tips => 'Tipps';

  @override
  String get tips_discover_nutriscore => 'Entdecken Sie den neuen Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Auf der Open Food Facts-Website';

  @override
  String get preferences_manage_account_title => 'Mein Konto verwalten';

  @override
  String get preferences_manage_account_tooltip => 'Verwalten Sie Ihr Konto';

  @override
  String get preferences_change_password_title => 'Mein Passwort ändern';

  @override
  String get preferences_danger_zone => 'Gefahrenzone';

  @override
  String get preferences_account_deletion_subtitle =>
      'Alle Ihre Beiträge gehen verloren';

  @override
  String get preferences_contributions_title => 'Beiträge';

  @override
  String get preferences_dev_mode_app_settings_title => 'App-Einstellungen';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Sehr experimentelle Möglichkeit, Produkte offline zu scannen';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Alle Produkte vom Server aktualisieren';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Bitte vermeiden Sie dies, es sei denn, es ist unbedingt erforderlich';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demo-Modus';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Karten zum Scanner hinzufügen';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Fügt dem Scanner 3 Beispielprodukte hinzu';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'Folksonomy-Host';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Gastgeber: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Barrierefreiheitsexperimente';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Auswahl mehrerer Produkte für Preise';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Vom Benutzer geordnete Wissenspanels';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Temporärer Zugriff auf die Standortsuche';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Nebeneinanderstellung von 2 oder 3 Produkten';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Produktlistenimport';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Ergebnisse und Methoden';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Entdecken Sie, wie der Nutri-Score berechnet wird';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Entdecken Sie die wichtigsten Änderungen an der Methodik';

  @override
  String get preferences_faq_discover_project_title =>
      'Entdecken Sie das Projekt';

  @override
  String get preferences_faq_discover_off_title =>
      'Entdecken Sie Open Food Facts';

  @override
  String get preferences_faq_discover_obf_title => 'Entdecke Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Entdecken Sie Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Open Prices entdecken';

  @override
  String get preferences_faq_discover_opf_title =>
      'Entdecken Sie Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'FAQ - Häufig gestellte Fragen';

  @override
  String get preferences_faq_off_ngo_title => 'Die NGO Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informationen';

  @override
  String get preferences_connect_community_updates_title =>
      'Erhalten Sie Community-Updates';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Bleiben Sie mit App- und Community-Neuigkeiten auf dem Laufenden';

  @override
  String get preferences_connect_community_calendar_title =>
      'Abonnieren Sie unseren Community-Kalender';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Engagieren Sie sich, indem Sie an einer unserer virtuellen Veranstaltungen teilnehmen';

  @override
  String get preferences_connect_blog_title => 'Der Open Food Facts Blog';

  @override
  String get preferences_connect_blog_subtitle =>
      'Erhalten Sie die neuesten Nachrichten, sobald sie passieren';

  @override
  String get preferences_connect_community_help_title =>
      'Holen Sie sich Hilfe von der Community';

  @override
  String get preferences_connect_improve_app_title =>
      'Helfen Sie uns, die App zu verbessern';

  @override
  String get preferences_connect_debug_info_title =>
      'Senden Sie uns Debug-Informationen';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Senden Sie uns eine E-Mail mit detaillierten Debuginformationen';

  @override
  String get preferences_connect_feedback_title =>
      'Senden Sie uns Feedback zur App';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Gestalten Sie die Zukunft der App mit';

  @override
  String get preferences_connect_survey_title =>
      'Nehmen Sie an der App-Umfrage teil';

  @override
  String get preferences_connect_survey_subtitle =>
      'Helfen Sie uns zu verstehen, was wir als Nächstes bauen sollten';

  @override
  String get preferences_connect_professionals_title => 'Fachleute';

  @override
  String get preferences_connect_pro_subtitle =>
      'Völlig kostenlos, gewährleistet genaue Daten für 500 Apps und Millionen von Verbrauchern. Selbstbedienung, kompatibel mit Ihrem PIM oder Ihren Tabellenkalkulationen (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Nehmen Sie Kontakt auf, um loszulegen';

  @override
  String get preferences_connect_press_title => 'Presse';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Holen Sie sich alle Materialien, die Sie für Ihren Bericht benötigen';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Kontaktieren Sie uns für Presseanfragen oder um uns über Ihren Bericht zu informieren';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Werden Sie ehrenamtlich aktiv';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Entwicklung, Kommunikation, Design… Jede Art von Freiwilligenarbeit oder Fachwissen ist willkommen!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Entdecken Sie einige der vielen Möglichkeiten, wie Sie beitragen können';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Entwicklung mobiler Apps';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Erfahren Sie, wie Sie zur Softwareentwicklung beitragen können';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Täglich instabile Builds, brandneue Funktionen';

  @override
  String get preferences_contribute_local_community_title =>
      'Erweitern Sie Ihre lokale Community';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Hilfe bei der Übersetzung von Software, Inhalten und Inhaltsstoffanalysen';

  @override
  String get preferences_contribute_share_subtitle =>
      'Wir haben eine kleine Vorlage vorbereitet, die Ihnen dabei hilft :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Einfache Schritte zur Steigerung der Lebensmitteltransparenz in Ihrem Land';

  @override
  String get preferences_contribute_data_quality_title => 'Datenqualität';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Werden Sie Teil des Datenqualitätsteams';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Unterstützen Sie uns bei unseren Bemühungen, die Vollständigkeit und Genauigkeit der Datenbank sicherzustellen';

  @override
  String get preferences_contributions_products_added_title =>
      'Hinzugefügte Produkte';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Neue Produkte, die ich zu Open Food Facts hinzugefügt habe';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produkte, die ich vervollständigen muss';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Alle unvollständigen Produkte';

  @override
  String get preferences_my_contributions_prices_title => 'Preise';

  @override
  String get preferences_my_contributions_my_prices_title => 'Mein Preise';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Meine Preise, meine Beweise…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produkte, bei deren Fertigstellung Sie mithelfen können';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Helfen Sie mit, den Nutri-Score und Green-Score in Ihrem Land zu berechnen';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Preise, die ich beigesteuert habe';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Preisschilder und Quittungen';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Machen Sie Fotos von Ihren Belegen und scannen Sie die zugehörigen Barcodes';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Machen Sie Fotos von den Preisen in einem Geschäft';

  @override
  String get preferences_prices_newest_title => 'Neueste Preise';

  @override
  String get preferences_prices_newest_subtitle =>
      'Neueste Preise, die von der Open Prices-Community hinzugefügt wurden';

  @override
  String get preferences_prices_top_contributors_title =>
      'Beitragende mit den meisten Preisen';

  @override
  String get preferences_prices_metrics_title => 'Open Price-Kennzahlen';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Verfolgen Sie die Entwicklung des Projekts';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Möglichkeiten, einen Beitrag zu leisten';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Bestätigen Sie die von Ihnen oder anderen hinzugefügten Preise mithilfe von KI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Fügen Sie schnell viele Belege oder Fotos von Regalen aus Ihrer Kamerarolle hinzu';

  @override
  String get preferences_prices_challenges_title =>
      'Monatliche Herausforderungen';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Nehmen Sie an monatlichen thematischen Quests teil, um Preise zu sammeln';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Fordern Sie Ihre Treuedaten zurück';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Erfahren Sie, wie Sie Ihre Daten anfordern';

  @override
  String get preferences_page_customize_app_title => 'Passen Sie die App an';

  @override
  String get preferences_page_contribute_project_title =>
      'Tragen Sie zum Projekt bei';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Einfache Möglichkeiten, Open Food Facts zu unterstützen';

  @override
  String get preferences_page_faq_subtitle =>
      'Bewertungsmethoden, Hilfe und mehr zum Projekt';

  @override
  String get product_edit_robotoff_positive_button => 'Vorschlag annehmen';

  @override
  String get product_edit_robotoff_negative_button => 'Vorschlag ablehnen';

  @override
  String get product_edit_robotoff_show_proof => 'Nachweis vorlegen';

  @override
  String get product_edit_robotoff_expand_proof => 'Beweis erweitern';

  @override
  String get product_page_tab_raw_data => 'Rohdaten';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Seite $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Seite $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count von $total Artikeln';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count von $total Artikeln';
  }

  @override
  String item_count(int count) {
    return '$count Artikel';
  }

  @override
  String item_count_string(String count) {
    return '$count Artikel';
  }

  @override
  String get prices_no_result => 'Keine Preisstatistiken gefunden.';

  @override
  String get prices_error_loading_more_items =>
      'Fehler beim Laden weiterer Elemente';

  @override
  String get prices_proof_error =>
      'Authentifizierung fehlgeschlagen, Nachweise konnten nicht abgerufen werden';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count von $total Beweisen';
  }

  @override
  String proof_count(int count) {
    return '$count Belege';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count von $total Mitwirkenden';
  }

  @override
  String contributors_count(int count) {
    return '$count Mitwirkende';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count von $total Standorten';
  }

  @override
  String prices_locations_count(int count) {
    return '$count Standorte';
  }

  @override
  String get restart_to_apply_message =>
      'Bitte starten Sie die App neu, um die Änderungen zu übernehmen.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafische Benutzeroberfläche';

  @override
  String get preferences_app_settings_media_title => 'Medien';

  @override
  String get preferences_about_app_development_title => 'Entwicklung';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Offene Food Facts Labs';

  @override
  String get preferences_root_account_title => 'Konto';

  @override
  String get preferences_contribute_translate_header =>
      'Bringen Sie Open Food Facts in Ihre Sprache';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Melden Sie sich für die Alpha-Version der App an';

  @override
  String get preferences_dev_mode_section_data => 'Beiträge & Produktdaten';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Folksonomy nicht anzeigen';

  @override
  String get preferences_account_title => 'Konto';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Hinzugefügt am $created';
  }

  @override
  String get location_map_details_title => 'Standortdetails';

  @override
  String get location_map_details_name => 'Name';

  @override
  String get location_map_details_street => 'Straße';

  @override
  String get location_map_details_city => 'Stadt';

  @override
  String get location_map_details_postcode => 'Postleitzahl';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Koordinaten';

  @override
  String get location_map_details_osm_id => 'OSM-ID';
}
