// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Catalan Valencian (`ca`).
class AppLocalizationsCa extends AppLocalizations {
  AppLocalizationsCa([String locale = 'ca']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Si';

  @override
  String get add => 'Afegeix';

  @override
  String get account_delete_message =>
      'Segur que voleu suprimir el vostre compte?\nSi hi ha una raó específica, compartiu-la a continuació';

  @override
  String get reason => 'Raó';

  @override
  String get okay => 'D\'acord';

  @override
  String get validate => 'Validar';

  @override
  String get create => 'Crea';

  @override
  String get applyButtonText => 'Aplicar';

  @override
  String get next_label => 'Següent';

  @override
  String get continue_label => 'Continuar';

  @override
  String get exit_label => 'Sortir';

  @override
  String get previous_label => 'Anterior';

  @override
  String get go_back_to_top => 'Torna a dalt';

  @override
  String get save => 'Desa';

  @override
  String get save_confirmation => 'De debò que ho voleu desar?';

  @override
  String get skip => 'Omet';

  @override
  String get cancel => 'Cancel·lar';

  @override
  String get ignore => 'Ignorar';

  @override
  String get close => 'Tanca';

  @override
  String get no => 'No';

  @override
  String get stop => 'Atura\'t';

  @override
  String get finish => 'Finalitzat';

  @override
  String get calculate => 'Calcular';

  @override
  String get reset_food_prefs => 'Restableix les preferències d\'aliments';

  @override
  String get error => 'Alguna cosa ha anat malament';

  @override
  String get error_occurred => 'S\'ha produït un error';

  @override
  String get featureInProgress =>
      'Seguim treballant en aquesta funció, estigueu atents';

  @override
  String get label_web => 'Veure a la web';

  @override
  String get learnMore => 'Saber-ne més';

  @override
  String get unknown => 'Desconegut';

  @override
  String get match_very_good => 'Molt bona coincidència';

  @override
  String get match_good => 'Bona coincidència';

  @override
  String get match_poor => 'Poca coincidència';

  @override
  String get match_may_not => 'Podria no coincidir';

  @override
  String get match_does_not => 'No coincideix';

  @override
  String get match_unknown => 'Coincidència desconeguda';

  @override
  String get match_short_very_good => 'Molt bona coincidència';

  @override
  String get match_short_good => 'Bona coincidència';

  @override
  String get match_short_poor => 'Poca coincidència';

  @override
  String get match_short_may_not => 'Podria no coincidir';

  @override
  String get match_short_does_not => 'No coincideix';

  @override
  String get match_short_unknown => 'Coincidència desconeguda';

  @override
  String get licenses => 'Llicències';

  @override
  String get looking_for => 'Tot cercant';

  @override
  String get welcomeToOpenFoodFacts => 'Benvingut a Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts és una organització sense ànim de lucre global impulsada per les comunitats locals.';

  @override
  String get productDataUtility =>
      'Consulteu les dades dels aliments rellevants per a les vostres preferències.';

  @override
  String get healthCardUtility => 'Trieu aliments que us siguin bons.';

  @override
  String get ecoCardUtility => 'Trieu aliments que siguin bons per al planeta.';

  @override
  String get server_error_open_new_issue =>
      'No hi ha resposta del servidor! Podeu obrir una incidència amb el següent enllaç.';

  @override
  String get sign_in_text =>
      'Inicieu la sessió al vostre compte d\'Open Food Facts per desar les vostres contribucions';

  @override
  String get incorrect_credentials => 'Usuari o contrasenya incorrectes.';

  @override
  String get password_lost_incorrect_credentials =>
      'Aquest correu electrònic o nom d\'usuari no existeix. Si us plau, comproveu les vostres credencials.';

  @override
  String get password_lost_server_unavailable =>
      'Actualment estem experimentant alentiments als nostres servidors i ens disculpem per això. Si us plau, torneu-ho a intentar més tard.';

  @override
  String get login => 'Nom d\'usuari';

  @override
  String get login_result_type_server_unreachable =>
      'La xarxa no és accessible';

  @override
  String get login_result_type_server_issue =>
      'Problema al servidor. Si us plau, intenta-ho més tard.';

  @override
  String get login_page_username_or_email =>
      'Introduïu l\'usuari o l\'adreça electrònica';

  @override
  String get login_page_password_error_empty =>
      'Si us plau, introduïu una contrasenya';

  @override
  String get create_account => 'Crear un compte';

  @override
  String get sign_in => 'Inicia la sessió';

  @override
  String get sign_in_mandatory =>
      'Per a aquesta funció, necessitem que inicieu la sessió.';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'Tanca la sessió';

  @override
  String get sign_out_confirmation => 'Segur que voleu tancar la sessió?';

  @override
  String get password => 'Contrasenya';

  @override
  String get forgot_password => 'Contrasenya oblidada';

  @override
  String get forgot_password_question => 'Has oblidat la contrasenya?';

  @override
  String get view_profile => 'Mostra el perfil';

  @override
  String get reset_password => 'Reinicialitza contrasenya';

  @override
  String get reset_password_explanation_text =>
      'En cas d\'oblidar la contrasenya, introduïu el vostre usuari o adreça electrònica per rebre les instruccions per restablir la contrasenya. A més, recordeu comprovar la carpeta de correu brossa.';

  @override
  String get username_or_email => 'Usuari o adreça electrònica';

  @override
  String get reset_password_done =>
      'S\'ha enviat un missatge de correu electrònic amb un enllaç per restablir la contrasenya a l\'adreça associada al vostre compte. Comproveu també dins el correu brossa';

  @override
  String get send_reset_password_mail => 'Canvia la contrasenya';

  @override
  String get enter_some_text => 'Si us plau, introduïu algun text';

  @override
  String get sign_up_page_title => 'Registreu-vos';

  @override
  String get sign_up_page_action_button => 'Registreu-vos';

  @override
  String get sign_up_page_action_doing_it => 'Registrant-se…';

  @override
  String get sign_up_page_action_ok =>
      'Felicitats! S\'acaba de crear el vostre compte.';

  @override
  String get sign_up_page_display_name_hint => 'Nom';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Introduïu el nom que voleu que es mostri';

  @override
  String get sign_up_page_email_hint => 'Adreça electrònica';

  @override
  String get sign_up_page_email_error_empty => 'Cal una adreça electrònica';

  @override
  String get sign_up_page_email_error_invalid => 'Adreça no vàlida';

  @override
  String get sign_up_page_username_hint => 'Usuari: visible públicament';

  @override
  String get sign_up_page_username_error_empty =>
      'Si us plau, introduïu un usuari';

  @override
  String get sign_up_page_username_error_invalid =>
      'Si us plau, introduïu un usuari vàlid';

  @override
  String get sign_up_page_username_description =>
      'El nom d\'usuari no pot contenir espais, majúscules ni caràcters especials.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'L\'usuari no pot excedir els $value caràcters';
  }

  @override
  String get sign_up_page_password_hint => 'Contrasenya';

  @override
  String get sign_up_page_password_error_empty =>
      'Si us plau, introduïu una contrasenya';

  @override
  String get sign_up_page_password_error_invalid =>
      'Si us plau, introduïu una contrasenya vàlida (com a mínim 6 caràcters)';

  @override
  String get sign_up_page_confirm_password_hint => 'Confirmeu la contrasenya';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Si us plau, confirmeu la contrasenya';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Les contrasenyes no coincideixen';

  @override
  String get sign_up_page_agree_text =>
      'Accepto la Política de Dades sobre Aliments Oberts';

  @override
  String get sign_up_page_terms_text => 'termes d\'ús i contribució';

  @override
  String get donate_url =>
      'https://es-ca.openfoodfacts.org/donate-to-open-food-facts';

  @override
  String get sign_up_page_agree_error_invalid =>
      'En crear un compte, acceptar les condicions d\'ús és obligatori, però encara es poden fer contribucions anònimes a través de l\'aplicació';

  @override
  String get sign_up_page_producer_checkbox => 'Sóc productor d\'aliments';

  @override
  String get sign_up_page_producer_hint => 'Productor/marca';

  @override
  String get sign_up_page_producer_error_empty =>
      'Introduïu un nom de productor o marca';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Vull subscriure\'m al butlletí d\'Open Food Facts (pots donar-te de baixa en qualsevol moment)';

  @override
  String get sign_up_page_user_name_already_used =>
      'El nom d\'usuari ja existeix, trieu-ne un altre.';

  @override
  String get sign_up_page_email_already_exists =>
      'ja existeix, inicieu sessió amb el compte o proveu amb un altre correu electrònic.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Introduïu una adreça electrònica vàlida.';

  @override
  String get sign_up_page_server_busy =>
      'Ho sentim molt, tenim algunes dificultats tècniques per crear el vostre compte. Torneu-ho a intentar més tard.';

  @override
  String get settingsTitle => 'Preferències';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Fosc';

  @override
  String get darkmode_light => 'Clar';

  @override
  String get darkmode_system_default => 'Per defecte del sistema';

  @override
  String get thanks_for_contributing => 'Gràcies per la teva contribució!';

  @override
  String get contributors_label => 'Estan construint l\'aplicació';

  @override
  String get contributors_dialog_title => 'Contribuents';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Col·laborador/a: $name';
  }

  @override
  String get contributors_description =>
      'Una llista de tothom qui col·labora amb aquesta app';

  @override
  String get support => 'Suport';

  @override
  String get support_join_slack => 'Demana ajuda al nostre canal de Slack';

  @override
  String get support_via_forum => 'Demana ajuda al nostre fòrum';

  @override
  String get support_via_email => 'Envieu-nos un correu electrònic';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Vols enviar els registres de l\'aplicació?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Voleu incloure els registres de l\'aplicació al fitxer adjunt al vostre correu electrònic?';

  @override
  String get termsOfUse => 'Condicions d\'ús';

  @override
  String get legalNotices => 'Avisos legals';

  @override
  String get privacy_policy => 'Política de privacitat';

  @override
  String get about_this_app => 'Quant a aquesta aplicació';

  @override
  String get contribute => 'Contribuir';

  @override
  String get contribute_sw_development => 'Desenvolupament de programari';

  @override
  String get contribute_develop_text =>
      'El codi de tots els productes d\'Open Food Facts està disponible a GitHub. Us convidem a reutilitzar el codi (és de codi obert) i ajudar-nos a millorar-lo, per a tothom, a tot el planeta.';

  @override
  String get contribute_develop_text_2 =>
      'Pots unir-te a la sala de xat de Slack d\'Open Food Facts, que és la manera preferida de fer preguntes.';

  @override
  String get contribute_develop_dev_mode_title => 'Mode Desenvolupador?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Activeu el mode DEV';

  @override
  String get contribute_donate_title => 'Feu un donatiu';

  @override
  String get contribute_donate_header => 'Dona a Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Si us plau, tingueu en compte que amb la versió alfa interna, és possible la pèrdua completa de dades i l\'aplicació pot quedar inutilitzable en qualsevol moment!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Productes que s\'han de completar';

  @override
  String get contribute_improve_header => 'Millorant';

  @override
  String get contribute_improve_text =>
      'La base de dades és el nucli del projecte. És fàcil i molt ràpid d\'ajudar. Podeu descarregar l\'aplicació mòbil per al vostre telèfon i començar a afegir o millorar productes.\n\nD\'altra banda, el lloc web Open Food Facts ofereix moltes maneres de contribuir: ';

  @override
  String get contribute_translate_header => 'Tradueix';

  @override
  String get contribute_data_quality => 'Qualitat de les dades';

  @override
  String get contribute_translate_link_text => 'Comenceu a traduir';

  @override
  String get contribute_translate_text =>
      'Open Food Facts és un projecte global que conté productes de més de 160 països. Open Food Facts es tradueix a desenes d\'idiomes i el contingut està en constant evolució.';

  @override
  String get contribute_translate_text_2 =>
      'Les traduccions són una de les tasques clau del projecte';

  @override
  String get contribute_join_skill_pool =>
      'Contribueix amb les teves habilitats a Open Food Facts. Uneix-te al grup d\'habilitats!';

  @override
  String get contribute_share_header =>
      'Comparteix Open Food Facts amb els teus amics';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribueix amb els preus sol·licitant una exportació per RGPD de les dades de les teves targetes de fidelització';

  @override
  String get tap_to_answer => 'Fes clic per respondre preguntes';

  @override
  String get tap_to_answer_hint =>
      'Fes clic aquí per respondre preguntes sobre aquest producte';

  @override
  String get robotoff_questions_loading_hint =>
      'Si us plau, espereu mentre es carreguen les preguntes sobre aquest producte';

  @override
  String get saving_answer => 'Desant la vostra resposta';

  @override
  String get contribute_to_get_rewards =>
      'Convertiu-vos en actor de la transparència alimentària';

  @override
  String get question_sign_in_text =>
      'Inicia la sessió al teu compte d\'Open Food Facts per obtenir crèdit per les teves contribucions';

  @override
  String get question_yes_button_accessibility_value => 'Respondre amb sí';

  @override
  String get question_no_button_accessibility_value => 'Respondre amb no';

  @override
  String get question_skip_button_accessibility_value =>
      'Omet aquesta pregunta';

  @override
  String get tap_to_edit_search => 'Feu clic per editar la cerca';

  @override
  String get myPreferences => 'Les meves preferències';

  @override
  String get account_create_message =>
      'Crea el teu compte i uneix-te a la comunitat Open Food Facts per ajudar a construir coneixement sobre aliments a tot el món!';

  @override
  String get join_us => 'Uneix-te\'ns';

  @override
  String get myPreferences_profile_title => 'El vostre perfil';

  @override
  String get myPreferences_profile_subtitle =>
      'Gestiona el teu compte de col·laborador d\'Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Configuració de l\'App';

  @override
  String get myPreferences_settings_subtitle => 'Mode fosc, Idiomes…';

  @override
  String get myPreferences_food_title => 'Preferències alimentàries';

  @override
  String get myPreferences_food_subtitle =>
      'Triau quina informació dels aliments us importa més.';

  @override
  String get myPreferences_food_comment =>
      'Trieu quina informació sobre els aliments us importa més per classificar els aliments segons les vostres preferències, veure primer la informació que us interessa i obtenir un resum de compatibilitat. Aquestes preferències alimentàries es queden al vostre dispositiu i no estan associades al vostre compte de col·laborador d\'Open Food Facts si en teniu un.';

  @override
  String get confirmResetPreferences =>
      'Voleu restablir les vostres preferències alimentàries?';

  @override
  String get myPersonalizedRanking => 'El meu rànquing personalitzat';

  @override
  String get ranking_tab_all => 'Tots';

  @override
  String get ranking_subtitle_match_yes => 'Una bona coincidència per a vós';

  @override
  String get ranking_subtitle_match_no => 'Coincidència molt pobra';

  @override
  String get ranking_subtitle_match_maybe => 'Coincidència desconeguda';

  @override
  String get refresh_with_new_preferences =>
      'Actualitzeu la llista amb les vostres noves preferències';

  @override
  String get reloaded_with_new_preferences =>
      'Recarregat amb les teves noves preferències';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Escàner';

  @override
  String get history_navbar_label => 'Historial';

  @override
  String get list_navbar_label => 'Llistes';

  @override
  String get category => 'Filtra per categoria';

  @override
  String get category_all => 'Tots';

  @override
  String get category_search => '(cerca per categoria)';

  @override
  String get filter => 'Filtre';

  @override
  String get scan => 'Productes de la pantalla Escaneja';

  @override
  String get scan_history => 'Historial d\'escaneig';

  @override
  String get search => 'Cerca';

  @override
  String get search_product_help =>
      'Cerca un producte,\nuna marca o un codi de barres';

  @override
  String get search_filter => 'Filtre de cerca';

  @override
  String get search_history => 'Historial de cerca';

  @override
  String get search_store => 'Cerca una botiga';

  @override
  String get search_store_help => 'Consell: afegiu la ciutat o el país';

  @override
  String get tap_for_more => 'Toca per veure més informació…';

  @override
  String get product => 'Producte';

  @override
  String get unknownBrand => 'Marca desconeguda';

  @override
  String get unknownQuantity => 'Quantitat desconeguda';

  @override
  String get unknownProductName => 'Nom de producte desconegut';

  @override
  String get label_refresh => 'Refresca';

  @override
  String get label_reload => 'Torna a carregar';

  @override
  String get image => 'Imatge';

  @override
  String get front_photo => 'Foto frontal';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (aquesta imatge pot estar desactualitzada)';
  }

  @override
  String get outdated_image_short_label => 'pot estar desactualitzat';

  @override
  String get ingredients => 'Ingredients';

  @override
  String get ingredients_editing_instructions =>
      'Mantingueu l\'ordre original. Indiqueu el percentatge quan s\'especifiqui. Separeu amb una coma o un guionet i utilitzeu parèntesis per als ingredients d\'un ingredient.';

  @override
  String get ingredients_editing_error =>
      'No s\'han pogut desar els ingredients.';

  @override
  String get ingredients_editing_image_error =>
      'No s\'ha pogut obtenir una nova imatge dels ingredients.';

  @override
  String get ingredients_editing_title => 'Edita els ingredients';

  @override
  String get ingredients_photo => 'Foto dels ingredients';

  @override
  String get packaging_editing_instructions =>
      'Introduïu totes les peces d\'embalatge separades per una coma o una línia, amb la seva quantitat (p. ex. 1 o 6) tipus (p. ex. ampolla, caixa, llauna), material (p. ex. plàstic, metall, alumini) i, si està disponible, la seva mida (p. ex. 33cl) i instruccions de reciclatge.\nExemple: 1 ampolla de vidre per reciclar, 1 suro de plàstic per llençar';

  @override
  String get packaging_editing_error => 'No s\'ha pogut desar l\'embalatge.';

  @override
  String get packaging_editing_image_error =>
      'No s\'ha pogut obtenir una nova imatge del paquet.';

  @override
  String get packaging_editing_title => 'Edita l\'embalatge';

  @override
  String get nutrition => 'Nutrició';

  @override
  String get nutrition_facts_photo => 'Fotos dels valors nutricionals';

  @override
  String get nutrition_facts_editing_title => 'Edita la informació nutricional';

  @override
  String get packaging_information => 'Instruccions de reciclatge';

  @override
  String get packaging_information_photo =>
      'Foto d\'instruccions sobre el reciclatge';

  @override
  String get missing_product => 'Heu trobat un nou producte!';

  @override
  String get add_product_take_photos =>
      'Feu fotos de l\'embalatge per afegir aquest producte a Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Si us plau, feu algunes fotos primer. Sempre podeu completar el producte més endavant.';

  @override
  String get add_product_information_button_label =>
      'Afegiu informació del producte';

  @override
  String get new_product => 'Nou producte';

  @override
  String get new_product_found_title => 'Nou producte trobat!';

  @override
  String get new_product_found_text =>
      'La nostra base de dades col·laborativa conté més de **3 milions de productes**, però aquest codi de barres no existeix: ';

  @override
  String get new_product_found_button => 'Afegir aquest producte';

  @override
  String get new_product_leave_title => 'Voleu sortir d\'aquesta pàgina?';

  @override
  String get new_product_leave_message =>
      'Sembla que no has introduït res. De veritat vols sortir d\'aquesta pàgina?';

  @override
  String get new_product_dialog_description =>
      'Si us plau, feu fotos de l\'embalatge per afegir aquest producte a la nostra base de dades comuna.';

  @override
  String get new_product_dialog_illustration_description =>
      'Una il·lustració amb Nutri-Score i Green Score desconegudes';

  @override
  String get front_packaging_photo_button_label => 'Foto frontal del producte';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Confirma la càrrega de la foto frontal del producte';

  @override
  String get confirm_button_label => 'Confirma';

  @override
  String get send_image_button_label => 'Enviar imatge';

  @override
  String get crop_page_action_saving => 'S\'està desant la imatge…';

  @override
  String get crop_page_action_cropping => 'Retallant la imatge…';

  @override
  String get crop_page_action_local => 'S\'està desant una versió local…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ups… hi ha alguna cosa amb la teva foto!';

  @override
  String get crop_page_action_local_failed_message =>
      'No podem processar la imatge localment abans d\'enviar-la al nostre servidor. Si us plau, torneu-ho a intentar més tard o poseu-vos en contacte amb nosaltres si el problema persisteix.';

  @override
  String get crop_page_action_retake => 'Torna a fer una foto';

  @override
  String get crop_page_too_small_image_title => 'La imatge és massa petita!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'La mida mínima en píxels per pujar imatges és ${expectedMinWidth}x$expectedMinHeight. La imatge actual és de ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Preparant una trucada al servidor…';

  @override
  String get front_packaging_photo_title => 'Foto frontal de l\'embalatge';

  @override
  String get ingredients_photo_title => 'Foto dels ingredients';

  @override
  String get nutritional_facts_photo_title => 'Foto dels valors nutricionals';

  @override
  String get recycling_photo_title => 'Instruccions de reciclatge Foto';

  @override
  String get take_photo_title => 'Fer una foto';

  @override
  String get take_more_photo_title => 'Feu més fotos';

  @override
  String get front_photo_uploaded => 'S\'ha penjat la foto frontal';

  @override
  String get ingredients_photo_button_label => 'Foto dels ingredients';

  @override
  String get ingredients_photo_uploaded =>
      'S\'ha penjat la foto dels ingredients';

  @override
  String get nutrition_cache_loading_error =>
      'No es poden carregar els nutrients de la memòria cau';

  @override
  String get nutritional_facts_photo_button_label =>
      'Fotos dels valors nutricionals';

  @override
  String get nutritional_facts_input_button_label =>
      'Introduïu valors nutricionals';

  @override
  String get nutritional_facts_added => 'Afegits els valors nutricionals';

  @override
  String get categories_added => 'Categories afegides';

  @override
  String get new_product_title_nutriscore => 'Calculeu el Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Aconsegueix-ho omplint la categoria de l\'aliment i els valors nutricionals';

  @override
  String get new_product_title_environmental_score =>
      'Calcula la puntuació verda';

  @override
  String get new_product_subtitle_environmental_score =>
      'Aconsegueix-ho omplint com a mínim una categoria';

  @override
  String get new_product_additional_environmental_score =>
      'Feu que el càlcul de la puntuació verda sigui més precís amb orígens, empaquetatge i més';

  @override
  String get new_product_title_nova =>
      'Calcula el nivell de processament d\'aliments (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Aconsegueix-ho omplint la categoria de l\'aliment i els ingredients';

  @override
  String get new_product_desc_nova_unknown =>
      'Nivell de processament d\'aliments desconegut';

  @override
  String get new_product_title_pictures => 'Fem unes fotos!';

  @override
  String get new_product_title_pictures_details =>
      'Si us plau, feu les fotos següents i el motor Open Food Facts s\'encarregarà de la resta!';

  @override
  String get new_product_title_misc => 'I algunes dades bàsiques…';

  @override
  String new_product_done_msg(String username) {
    return 'Gràcies per la teva contribució “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Gràcies per la teva contribució!';

  @override
  String get new_product_done_button_label => 'Descobreix el producte acabat';

  @override
  String get hey_incomplete_product_message =>
      'Toca per respondre 3 preguntes ARA per calcular Nutri-Score, Green Score i Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Toca ara per respondre 2 preguntes que t\'ajudaran a analitzar aquest cosmètic!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Toca ara per respondre 3 preguntes que t\'ajudaran a analitzar aquest producte alimentari per a mascotes!';

  @override
  String get hey_incomplete_product_message_product =>
      'Toca ara per ajudar a completar aquest producte!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'S\'ha penjat una foto de dades nutricionals';

  @override
  String get recycling_photo_button_label =>
      'Foto informativa sobre el reciclatge';

  @override
  String get recycling_photo_uploaded => 'S\'ha penjat una foto de reciclatge';

  @override
  String get take_more_photo_button_label => 'Feu més fotos';

  @override
  String get other_photo_uploaded => 'S\'ha penjat una altra foto';

  @override
  String get retake_photo_button_label => 'Torna a fer';

  @override
  String get selecting_photo => 'Selecció de la foto';

  @override
  String get uploading_image => 'S\'està carregant la foto al servidor';

  @override
  String get uploading_image_type_front =>
      'Pujant la imatge frontal a Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Pujant la imatge dels ingredients a Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Pujant una imatge nutricional a Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Pujant la imatge de l\'envàs a Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Pujant una altra imatge a Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Pujant una imatge a Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Afegiu els ingredients que falten';

  @override
  String get score_add_missing_packaging_image =>
      'Afegeix la imatge que falta de l\'envàs';

  @override
  String get score_add_missing_nutrition_facts =>
      'Afegiu les dades nutricionals que falten';

  @override
  String get score_add_missing_product_traces =>
      'Afegeix traces de productes que falten';

  @override
  String get score_add_missing_product_category =>
      'Afegiu la categoria de producte que falta';

  @override
  String get score_add_missing_precise_product_category =>
      'Seleccioneu una categoria més precisa';

  @override
  String get score_add_missing_product_countries =>
      'Afegiu els països del producte que falten';

  @override
  String get score_add_missing_product_emb =>
      'Afegiu els codis de traçabilitat dels productes que falten';

  @override
  String get score_add_missing_product_labels =>
      'Afegiu les etiquetes dels productes que falten';

  @override
  String get score_add_missing_product_origins =>
      'Afegiu els orígens dels productes que falten';

  @override
  String get score_add_missing_product_stores =>
      'Afegeix les botigues de productes que falten';

  @override
  String get score_add_missing_product_brands =>
      'Afegeix marques de productes que falten';

  @override
  String get score_update_nutrition_facts =>
      'Actualitzar les dades nutricionals';

  @override
  String get nutrition_page_title => 'Informació nutricional';

  @override
  String get nutrition_page_nutritional_info_title => 'Informació nutricional';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Valors especificats al producte:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Si';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'No';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Obre la foto';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Bones pràctiques: Informació nutricional';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'De vegades, la informació nutricional **no s\'especifica a l\'envàs** ni en un document que s\'inclou amb el producte. En aquest cas, i només en aquest cas, podeu establir el valor a **NO**.';

  @override
  String get nutrition_page_serving_type_label => 'Valors nutricionals:';

  @override
  String get nutrition_page_per_100g => 'per 100 g';

  @override
  String get nutrition_page_per_100g_100ml => 'per 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'per porció';

  @override
  String get nutrition_page_add_nutrient => 'Afegir un nutrient';

  @override
  String get nutrition_page_serving_size => 'Mida de la porció';

  @override
  String get nutrition_page_serving_size_hint =>
      'Introdueix una mida de porció (per exemple: 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Bones pràctiques: Mida de la porció';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Aquest valor ajuda a **fer un càlcul proporcional de cada nutrient per ració**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Les unitats permeses** són: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 公升.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** o **60 g** (preferiu el primer)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** o **1 L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Unitat no vàlida';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Unitats no vàlides';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **caramels** i 2 **galetes**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Unitat que falta';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Número no vàlid';

  @override
  String get nutrition_page_update_running =>
      'Actualització del producte al servidor…';

  @override
  String get nutrition_page_update_done => 'Producte actualitzat!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Utilitzeu la quantitat del producte com a mida de la porció';

  @override
  String get nutrition_page_photo_error => 'No es pot carregar la foto';

  @override
  String get more_photos => 'Més fotos interessants';

  @override
  String get view_more_photo_button =>
      'Veure totes les fotos existents d\'aquest producte';

  @override
  String get no_product_found => 'Cap producte trobat';

  @override
  String get no_location_found => 'No s\'ha trobat cap ubicació';

  @override
  String get not_found => 'no trobat:';

  @override
  String get refreshing_product => 'Producte refrescant';

  @override
  String get product_refreshed => 'Producte actualitzat';

  @override
  String product_image_accessibility_label(String date) {
    return 'Imatge feta el $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Imatge feta el $date. Pot ser que aquesta imatge estigui desactualitzada.';
  }

  @override
  String get product_image_outdated =>
      'Aquesta imatge pot estar desactualitzada';

  @override
  String get product_image_outdated_explanations_title =>
      'Aquesta imatge pot estar desactualitzada';

  @override
  String get product_image_outdated_explanations_content =>
      'Aquesta imatge es va fer fa més d\'un any.\n**Si us plau, comproveu que encara estigui actualitzada**.\n\nAixò **només és un avís**. Si el contingut continua sent el mateix, podeu ignorar aquest missatge.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Substitueix la foto ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Afegeix una foto ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Nova captura';

  @override
  String get product_image_action_take_picture => 'Fer una foto';

  @override
  String get product_image_action_from_gallery =>
      'Selecciona de la galeria del teu telèfon';

  @override
  String get product_image_action_choose_existing_photo =>
      'Selecciona entre les fotos del producte';

  @override
  String get product_image_details_label => 'Informació sobre la foto';

  @override
  String get product_image_details_from_producer => 'Del productor';

  @override
  String get product_image_details_contributor => 'Voluntari/a';

  @override
  String get product_image_details_contributor_producer =>
      'Col·laborador (productor)';

  @override
  String get product_image_details_date => 'Data';

  @override
  String get product_image_details_date_unknown => 'Desconegut';

  @override
  String get homepage_main_card_logo_description =>
      'Benvinguts a Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Escaneja** un codi de barres o\n**cerca** un producte';

  @override
  String get homepage_main_card_search_field_hint => 'Cerca un producte';

  @override
  String get homepage_main_card_search_field_tooltip => 'Inicia la cerca';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Últimes notícies: $news_title';
  }

  @override
  String get tagline_app_review => 'Us agrada l\'aplicació?';

  @override
  String get tagline_app_review_button_positive => 'M\'encanta! 😍';

  @override
  String get tagline_app_review_button_negative => 'No gaire…';

  @override
  String get tagline_app_review_button_later => 'Pregunta-m\'ho després';

  @override
  String get tagline_feed_news_button => 'Més informació';

  @override
  String get app_review_negative_modal_title =>
      'No us agrada, la nostra aplicació?';

  @override
  String get app_review_negative_modal_text =>
      'Podríeu emprar uns minuts per a dir-nos el per què?';

  @override
  String get app_review_negative_modal_positive_button => 'I tant!';

  @override
  String get app_review_negative_modal_negative_button => 'No';

  @override
  String get could_not_refresh => 'Impossible d\'actualitzar el producte';

  @override
  String get product_internet_error_modal_title => 'S\'ha produït un error!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'No podem obtenir informació sobre aquest producte a causa d\'un error de xarxa. Si us plau, comproveu la connexió a Internet i torneu-ho a intentar.\n\nError intern:\n$error';
  }

  @override
  String get product_tags_title => 'Propietats del producte';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Sense propietats';

  @override
  String get product_tags_explanation =>
      'En afegir propietats (clau/valor) a un producte, ajudeu a enriquir-lo.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Afegeix propietats';

  @override
  String get add_edit_tags => 'Afegir o editar propietats';

  @override
  String get edit_tag => 'Edita la propietat';

  @override
  String get remove_tag => 'Elimina la propietat';

  @override
  String get tag_key => 'Propietat';

  @override
  String get tag_keys => 'Propietats';

  @override
  String get tag_key_uneditable => 'Propietat (no editable)';

  @override
  String get tag_key_input_hint => 'Introdueix una propietat';

  @override
  String get tag_value => 'Valor';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Introdueix un valor';

  @override
  String get tag_key_item => 'Propietat:';

  @override
  String get tag_value_item => 'Valor:';

  @override
  String get tag_key_explanations =>
      'Una clau ha d\'estar en minúscules i sense espais.';

  @override
  String tag_key_already_exists(String property) {
    return 'Ja existeix una etiqueta amb la propietat $property !';
  }

  @override
  String get product_internet_error =>
      'No es pot obtenir informació sobre aquest producte a causa d\'un error de xarxa.';

  @override
  String get cached_results_from => 'Mostra resultats de:';

  @override
  String get product_search_same_category => 'Troba alternatives';

  @override
  String get product_search_same_category_short => 'Comparar';

  @override
  String get product_search_same_category_error =>
      'Aquesta funció només es pot utilitzar per a productes amb una categoria.\n\nEditeu el producte per afegir una categoria.';

  @override
  String get product_improvement_add_category =>
      'Afegiu una categoria per calcular el Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Afegiu dades nutricionals per calcular el Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Afegiu dades nutricionals i una categoria per calcular el Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'La Nutri-Score d\'aquest producte no es pot calcular, la qual cosa pot ser degut, per exemple, a una categoria no estàndard. Si ho consideres un error, posa\'t en contacte amb nosaltres.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'La imatge nutricional és obsoleta: si us plau, actualitzeu-la.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'La Puntuació Verda té en compte els orígens dels ingredients. Si us plau, feu una foto de la llista d\'ingredients i/o qualsevol afirmació geogràfica o editeu el producte perquè es puguin tenir en compte.';

  @override
  String get country_chooser_label => 'Si us plau, trieu un país';

  @override
  String get currency_chooser_label => 'Trieu la vostra moneda';

  @override
  String get country_change_message => 'Acabes de canviar de país.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Voleu canviar la moneda de $previousCurrency a $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Si us plau, trieu un país:';

  @override
  String get country_chooser_label_from_settings => 'El vostre país';

  @override
  String get country_selection_explanation =>
      'Algunes característiques ambientals són específiques del lloc';

  @override
  String get product_removed_comparison => 'Producte eliminat de la comparació';

  @override
  String get native_app_settings => 'Configuració de l\'aplicació nativa';

  @override
  String get native_app_description =>
      'Obre la configuració del sistema per a Open Food Facts';

  @override
  String get product_removed_history => 'Producte eliminat de l\'historial';

  @override
  String get product_removed_list => 'Producte eliminat de la llista';

  @override
  String get product_could_not_remove => 'No s\'ha pogut eliminar el producte';

  @override
  String get no_prodcut_in_list => 'No hi ha cap producte en aquesta llista';

  @override
  String get no_product_in_section => 'No hi ha cap producte en aquesta secció';

  @override
  String get recently_seen_products => 'Tots els productes vistos';

  @override
  String get clear => 'Esborra';

  @override
  String get clear_long => 'Buida la llista';

  @override
  String get really_clear => 'Realment voleu suprimir aquesta llista?';

  @override
  String pct_match(Object percent) {
    return '$percent% de coincidència';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'fa $count dies',
      one: 'fa un dia',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Fa $count hores',
      one: 'Fa una hora',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'fa $count minuts',
      one: 'fa un minut',
      zero: 'fa menys d\'un minut',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'fa $count mesos',
      one: 'fa un mes',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'fa $count setmanes',
      one: 'fa una setmana',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Compara $count Productes',
      one: 'Compara un producte',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count productes seleccionats',
      one: 'Un producte seleccionat',
      zero: 'Cap producte seleccionat',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Compara els productes seleccionats';

  @override
  String get delete_products_mode => 'Suprimeix els productes seleccionats';

  @override
  String get select_all_products_mode => 'Selecciona tots els productes';

  @override
  String get select_none_products_mode => 'No seleccionar cap';

  @override
  String get compare_products_appbar_title => 'Comparar productes';

  @override
  String get compare_products_appbar_subtitle =>
      'Seleccioneu com a mínim dos productes';

  @override
  String get retry_button_label => 'Torna a provar';

  @override
  String get connect_with_us => 'Connecta amb nosaltres';

  @override
  String get tiktok => 'Segueix-nos a TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Segueix-nos a Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Segueix-nos a X (abans Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Segueix-nos a Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Segueix-nos a BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Bloc';

  @override
  String get faq => 'PMF';

  @override
  String get discover => 'Descobrir';

  @override
  String get how_to_contribute => 'Com contribuir';

  @override
  String get hint_knowledge_panel_message =>
      'Podeu fer clic a qualsevol part de la targeta per obtenir més detalls del que veieu. Proveu-ho ara!';

  @override
  String get permissions_page_title => 'Accés a la càmera';

  @override
  String get permissions_page_body1 =>
      'Per escanejar codis de barres amb la càmera del telèfon, si us plau, autoritzeu l\'accés.';

  @override
  String get permissions_page_body2 =>
      'Si canvieu d\'opinió, aquesta opció es pot activar o desactivar en qualsevol moment des de la configuració.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'Sistema operatiu: Android (SDK Int: $sdkInt / Versió: $release)\nModel: $model\nProducte: $product\nDispositiu: $device\nMarca:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'Sistema operatiu: iOS ($version)\nModel: $model\nModel localitzat: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVersió de l\'aplicació:$appVersion\nNúmero de compilació de l\'aplicació:$appBuildNumber\nNom del paquet de l\'aplicació:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Autoritza';

  @override
  String get refuse_button_label => 'Denega';

  @override
  String get ask_me_later_button_label => 'Més tard';

  @override
  String get are_you_sure => 'N\'esteu segur?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Aneu més enllà del $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Benvingut/da!';

  @override
  String get onboarding_home_welcome_text2 =>
      'L\'aplicació que t\'ajuda a triar aliments bons per a **tu** i per al **planeta**!';

  @override
  String get onboarding_continue_button => 'Continuar';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'S\'està carregant el vostre primer exemple de producte';

  @override
  String get onboarding_welcome_warning =>
      'Ho sento, és el nostre producte d\'exemple, no el pots editar :)';

  @override
  String get product_list_your_ranking => 'La teva classificació';

  @override
  String get product_list_empty_icon_desc => 'Historial no disponible';

  @override
  String get product_list_empty_title => 'Comenceu a escanejar';

  @override
  String get product_list_empty_message =>
      'Els productes escanejats apareixeran aquí i podeu consultar informació detallada sobre ells';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'els productes',
      one: 'un producte',
      zero: 'cap producte',
    );
    return 'Refrescant $_temp0 en el teu historial';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'pels productes',
      one: 'pel producte',
      zero: 'pel producte',
    );
    return 'Refrescament acabat $_temp0';
  }

  @override
  String get product_list_compare_side_by_side => 'Comparar costat a costat';

  @override
  String get loading_dialog_default_title => 'Descàrregant les dades';

  @override
  String get loading_dialog_default_error_message =>
      'No s\'han pogut baixar les dades';

  @override
  String get account_delete => 'Elimina el compte';

  @override
  String get account_delete_title => 'Suprimeix el meu compte';

  @override
  String get user_profile => 'Compte';

  @override
  String get user_profile_title_guest => 'Benvingut! Benvinguda!';

  @override
  String get user_profile_subtitle_guest =>
      'Inicia la sessió o registra\'t per unir-te a la comunitat Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Inici de sessió a Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Benvingut/da $id!';
  }

  @override
  String get email_subject_account_deletion => 'Elimina el compte';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hola, si us plau, esborreu el meu compte d\'Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Aplicació';

  @override
  String get settings_app_data => 'Privacitat i seguiment';

  @override
  String get settings_app_camera => 'Càmera';

  @override
  String get settings_app_products => 'Productes';

  @override
  String get settings_app_miscellaneous => 'Miscel·lània';

  @override
  String get camera_play_sound_title => 'Reprodueix un so en escanejar';

  @override
  String get camera_play_sound_subtitle =>
      'Emetrà un so en cada escaneig exitós';

  @override
  String get camera_window_accessibility_label =>
      'Escaneja un codi de barres amb la càmera';

  @override
  String get app_haptic_feedback_title => 'Vibració i hàptica';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibracions després d\'executar algunes accions (codi de barres descodificat, producte eliminat…).';

  @override
  String get crash_reporting_toggle_title => 'Informes d\'errors';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Quan estan habilitades, els informes d\'errors s\'envien automàticament al sistema de seguiment d\'errors d\'Open Food Facts, de manera que es puguin corregir errors i així millorar l\'aplicació.';

  @override
  String get send_anonymous_data_toggle_title => 'Enviament de dades anònimes';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Editar foto';

  @override
  String get permission_photo_error => 'Error';

  @override
  String get permission_photo_denied_title =>
      'Permeteu l\'ús de la càmera per escanejar codis de barres';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Per obtenir una experiència millorada, permeteu que $appName accedeixi a la vostra càmera. Us permetrà escanejar codis de barres directament.';
  }

  @override
  String get permission_photo_denied_button => 'Permet';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Permís denegat';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Com que prèviament heu denegat el permís de la càmera, heu de permetre\'l manualment des de la configuració.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Obre la configuració';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Cancel·lar';

  @override
  String get permission_photo_none_found => 'No es detecta cap càmera';

  @override
  String get permission_photo_denied => 'No s\'ha concedit accés a la càmera';

  @override
  String get show_product_pictures => 'Mostra imatges del producte';

  @override
  String get edit_product_label => 'Edita el producte';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Pujant les teves edicions…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Les teves edicions s\'estan **enviant en segon pla** (o més tard en cas d\'error).\nPots continuar editant altres camps de producte.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Les teves edicions s\'estan **enviant en segon pla** (o més tard en cas d\'error).';

  @override
  String get edit_product_label_short => 'Edita';

  @override
  String edit_product_form_item_help(String value) {
    return 'Com s\'introdueix \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Si us plau, introduïu un valor que no sigui buit!';

  @override
  String get edit_product_form_item_error_existing => 'Aquest valor ja hi és!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Afegeix una nova marca';

  @override
  String get edit_product_form_item_add_action_label =>
      'Afegeix una etiqueta nova';

  @override
  String get edit_product_form_item_add_action_store =>
      'Afegeix una botiga nova';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Afegeix un nou origen';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Afegir un nou codi de traçabilitat';

  @override
  String get edit_product_form_item_add_action_country => 'Afegeix un país nou';

  @override
  String get edit_product_form_item_add_action_category =>
      'Afegeix una nova categoria';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Afegeix una nova traça';

  @override
  String get edit_product_form_item_add_suggestion => 'Afegeix un suggeriment';

  @override
  String get edit_product_form_item_deny_suggestion => 'Rebutja el suggeriment';

  @override
  String get edit_product_form_item_details_title => 'Detalls bàsics';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Nom del producte, marca, quantitat';

  @override
  String get edit_product_form_item_other_details_title => 'Més detalls';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Lloc web…';

  @override
  String get edit_product_form_item_photos_title => 'Fotos';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Afegeix o actualitza fotos';

  @override
  String get edit_product_form_item_labels_title =>
      'Etiquetes i certificacions';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Mediambiental, Segells de qualitat…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Introduïu una etiqueta (per exemple: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'etiqueta';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Bones pràctiques: Etiquetes';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Qualsevol característica del producte **que sigui factual** i diferent dels altres camps.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Fabricat a Bèlgica, produït a Bretanya…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Ric en fibra, font de ferro…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Comerç just, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Botigues';

  @override
  String get edit_product_form_item_stores_hint => 'Introdueix una botiga';

  @override
  String get edit_product_form_item_stores_type => 'botiga';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Bones pràctiques: Botigues';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Introdueix la botiga on has comprat el producte.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Orígens';

  @override
  String get edit_product_form_item_origins_hint =>
      'Introdueix un origen (per exemple: Alemanya)';

  @override
  String get edit_product_form_item_origins_type => 'país';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Bones pràctiques: Orígens';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Afegiu **qualsevol indicació d\'origen que trobeu a l\'envàs**.\nNo us heu de preocupar pels orígens indicats directament a la llista d\'ingredients.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Vedella d\'Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'La soja no prové de la Unió Europea';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Introdueix un país (per exemple: Alemanya)';

  @override
  String get edit_product_form_item_countries_type => 'país';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Bones pràctiques: Països';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Països on el producte està àmpliament disponible** (sense incloure botigues especialitzades en productes estrangers).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Codis de traçabilitat';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Introduïu un codi (p. ex.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'codi de traçabilitat';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Bones pràctiques: Codis de traçabilitat';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'En aquesta secció, podeu introduir codis relacionats amb les **marques d\'envasament**, les **marques d\'identificació** o les **marques sanitàries**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Exemples de codis de traçabilitat';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Codis CE** utilitzats a la Comunitat Europea per identificar productors o envasadors d\'aliments:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: codi de país de **França**\n**72.264.002**: dades geogràfiques\n**CE**: Comunitat Europea';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Codis EMB** utilitzats a França:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Rastres';

  @override
  String get edit_product_form_item_traces_hint => 'rastre';

  @override
  String get edit_product_form_item_traces_type =>
      'Introduïu una traça (per exemple: soja)';

  @override
  String get edit_product_form_item_categories_title => 'Categories';

  @override
  String get edit_product_form_item_categories_hint => 'categoria';

  @override
  String get edit_product_form_item_categories_type =>
      'Introdueix una categoria (per exemple: Suc de taronja)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Bones pràctiques: Categories';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indiqueu **només la categoria més específica**.\nLes categories principals s\'afegiran automàticament.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Categoria que falta?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'En cas que una categoria **no estigui disponible a l\'autocompleció**, podeu afegir-la igualment.\nAixò ens ajudarà a millorar Open Food Facts al vostre país.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardines en oli d\'oliva';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Suc de taronja a partir de concentrat';

  @override
  String get edit_product_form_item_exit_title => 'Voleu sortir sense desar?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Voleu desar els canvis abans de sortir de la pàgina?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Desa els canvis';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Descarta els canvis';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredients';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Apropa i allunya el zoom pinçant la pantalla';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Apropar i allunyar la foto';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Amb el gest **Pinch to zoom**, pots ampliar o reduir la foto:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Afegeix';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Si us plau, introduïu un text';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Suprimeix';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Desa la teva edició';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Cancel·la la teva edició';

  @override
  String get edit_product_form_item_packaging_title =>
      'Foto d\'instruccions sobre el reciclatge';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Informació nutricional';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Nutrició, contingut alcohòlic…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Bones pràctiques: Informació nutricional';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Valors nutricionals';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Primer, seleccioneu si es proporcionen els **valors**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Informació nutricional';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'A continuació, introdueix els valors nutricionals **tal com s\'indica a l\'envàs**. Si no hi ha cap valor, pots fer clic a la icona \"Ull\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Camp que falta?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Si falta una entrada, podeu **fer clic a la icona \"Més\"** per afegir-la (per exemple: vitamina D, magnesi…).';

  @override
  String get edit_product_form_save => 'Edita';

  @override
  String get edit_product_ingredients_photo_title => 'Foto dels ingredients';

  @override
  String get edit_product_ingredients_list_title => 'Llistat d\'ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Foto d\'embalatge';

  @override
  String get edit_product_packaging_list_title => 'Llista d\'embalatges';

  @override
  String get no_data_available => 'No hi ha dades disponibles';

  @override
  String get product_field_website_title => 'Lloc web';

  @override
  String get origins_editing_title => 'Edita els orígens';

  @override
  String get completed_basic_details_btn_text => 'Detalls bàsics complets';

  @override
  String get not_implemented_snackbar_text => 'Encara no s\'ha implementat';

  @override
  String get category_picker_page_appbar_text => 'Categories';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extreure els ingredients de la foto';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extreu els ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extracció d\'ingredients\nde la foto';

  @override
  String get edit_ingredients_loading_photo_btn_text =>
      'S\'està carregant la foto…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Per què veig aquest missatge?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Per utilitzar la funció \"Extreure ingredients\", primer cal penjar la foto.\n\nEspereu uns segons o introduïu-los manualment.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Actualitza la foto';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extreu l\'embalatge\nde la foto';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extracte d\'envasament';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extracció de l\'embalatge de la foto';

  @override
  String get edit_packaging_loading_photo_btn_text =>
      'S\'està carregant la foto…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Per què veig aquest missatge?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Per utilitzar la funció \"Extreu l\'embalatge\", primer cal carregar la foto.\n\nEspereu uns segons o introduïu-les manualment.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Actualitza la foto';

  @override
  String get edit_ocr_extract_failed =>
      'No ha pogut detectar text a la imatge.';

  @override
  String get edit_ocr_extract_disabled_title => 'Cap imatge!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Per utilitzar la funció d\'extracció de text, primer heu de fer una foto.';

  @override
  String get user_list_dialog_new_title => 'Nova llista de productes';

  @override
  String get user_list_dialog_rename_title => 'Canvia el nom a la llista';

  @override
  String get user_list_subtitle_product => 'Llistes';

  @override
  String get user_list_title => 'Les vostres llistes';

  @override
  String get user_list_add_product => 'Afegeix el producte a les teves llistes';

  @override
  String get user_list_button_new => 'Crea una llista nova';

  @override
  String get user_list_empty_label =>
      'Encara no hi ha cap llista disponible,\nsi us plau, comenceu creant-ne una';

  @override
  String get user_list_button_add_product => 'Afegeix a la llista';

  @override
  String get added_to_list_msg => 'S\'ha afegit a la llista';

  @override
  String get user_list_popup_clear => 'Neteja l\'historial';

  @override
  String get user_list_popup_rename => 'Canviar el nom';

  @override
  String get user_list_name_hint => 'La meva llista';

  @override
  String get user_list_name_error_empty => 'El nom és obligatori';

  @override
  String get user_list_name_error_already => 'Aquest nom ja s\'està utilitzat';

  @override
  String get user_list_name_error_same => 'Aquest és el mateix nom';

  @override
  String get user_list_name_input_hint => 'Nom de la llista';

  @override
  String get try_again => 'Torneu-ho a provar';

  @override
  String get there_was_an_error => 'S\'ha produït un error';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'No s\'ha trobat cap categoria per a $items';
  }

  @override
  String get camera_toggle_camera =>
      'Canvia entre la càmera posterior i la frontal';

  @override
  String get camera_toggle_flash => 'Enceneu o apagueu el flaix de la càmera';

  @override
  String get camera_enable_flash => 'Activa el flaix';

  @override
  String get camera_disable_flash => 'Desactiva el flaix';

  @override
  String get camera_flash_error_dialog_title => 'S\'ha produït un error!';

  @override
  String get camera_flash_error_dialog_message =>
      'S\'ha produït un error en canviar l\'estat del flaix. Assegureu-vos que el vostre telèfon no tingui la llanterna activada.';

  @override
  String get category_picker_no_category_found_button => 'Enrere';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Feu clic per obrir-ho al navegador o a l\'aplicació (si està instal·lada)';

  @override
  String get dev_preferences_screen_title => 'Mode Desenvolupador';

  @override
  String get dev_preferences_screen_subtitle =>
      'Accediu a funcions experimentals i eines de desenvolupament';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Reinicieu la incorporació';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Llavors heu de reiniciar l\'aplicació per tornar-ho a veure.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Canvia entre openfoodfacts.org (PROD) i prova env';

  @override
  String get dev_preferences_test_environment_title =>
      'Paràmetres de l\'entorn de prova';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL base per a l\'entorn de prova actual: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Amfitrió de l\'entorn de prova';

  @override
  String get dev_preferences_ml_kit_title => 'Utilitzeu el kit ML';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'aleshores heu de reiniciar aquesta aplicació';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Botó addicional a la pàgina del producte';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Editeu els ingredients mitjançant un botó del tauler de coneixement';

  @override
  String get dev_preferences_export_history_title => 'Exporta l\'historial';

  @override
  String get dev_preferences_export_history_progress_error => 'excepció';

  @override
  String get dev_preferences_export_history_progress_found => 'producte trobat';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'producte NO trobat';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Exportació de l\'historial';

  @override
  String get dev_preferences_button_positive => 'D\'acord';

  @override
  String get dev_preferences_button_negative => 'Cancel·lar';

  @override
  String get dev_preferences_migration_title =>
      'Migració de dades des de la V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Estat: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'èxit o instal·lació nova';

  @override
  String get dev_preferences_migration_status_success => 'èxit';

  @override
  String get dev_preferences_migration_status_error => 'error';

  @override
  String get dev_preferences_migration_status_in_progress => 'en curs';

  @override
  String get dev_preferences_migration_status_required =>
      'obligatori (feu clic per començar)';

  @override
  String get dev_preferences_migration_status_not_started => 'desconegut';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Esborrarà l\'historial i hi posarà 3 productes';

  @override
  String get dev_preferences_news_custom_url_title =>
      'URL personalitzada per a notícies';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL del fitxer JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'No definit';

  @override
  String get dev_preferences_news_provider_status_title => 'Estat';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Última actualització: $date';
  }

  @override
  String get product_type_label_food => 'Menjar';

  @override
  String get product_type_label_beauty => 'Cura personal';

  @override
  String get product_type_label_pet_food => 'Menjar per a mascotes';

  @override
  String get product_type_label_product => 'Altres';

  @override
  String get product_type_selection_title => 'Tipus de producte';

  @override
  String get product_type_selection_subtitle =>
      'Seleccioneu el tipus d\'aquest producte';

  @override
  String get product_type_selection_empty =>
      'Primer has de seleccionar un tipus de producte!';

  @override
  String product_type_selection_already(String productType) {
    return 'No podeu canviar el tipus de producte ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Drecera a l\'aplicació Preus a la pàgina del producte';

  @override
  String get prices_app_button => 'Ves a l\'aplicació Preus';

  @override
  String get prices_website_button => 'Obre al lloc web de Preus Oberts';

  @override
  String get prices_bulk_proof_upload_select =>
      'Afegeix etiquetes de preu directament des de la galeria';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Un cop hagis seleccionat les imatges, no les podràs editar!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Permetre que la comunitat validi els preus extrets per la IA.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Etiquetes de preu múltiples';

  @override
  String get prices_bulk_proof_upload_title => 'Càrrega massiva de proves';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Seleccionant fitxers';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Inici de la càrrega';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Copiant localment el fitxer #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Preparant la càrrega #$index/${count}S\'està preparant la càrrega #$index / $count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Error a la imatge #$index/$count';
  }

  @override
  String get prices_generic_title => 'Preus';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Afegeix $count preus',
      one: 'Afegeix un preu',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Envia $count preus',
      one: 'Envia el preu',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Afegeix un element';

  @override
  String get prices_add_a_price => 'Afegir un preu';

  @override
  String get prices_add_a_receipt => 'Afegeix un rebut';

  @override
  String get prices_add_price_tags => 'Afegir etiquetes de preu';

  @override
  String prices_barcode_already(String barcode) {
    return 'Aquest codi de barres ($barcode) ja és a la llista!';
  }

  @override
  String get prices_barcode_search_not_found => 'No s\'ha trobat el producte';

  @override
  String get prices_barcode_search_none_yet => 'Encara no hi ha cap producte';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Buscant $barcode';
  }

  @override
  String get prices_barcode_enter => 'Introduïu el codi de barres';

  @override
  String get prices_category_enter => 'Article sense codi de barres';

  @override
  String get prices_per_kilogram => 'Preu per quilogram';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / unitat';

  @override
  String get prices_category_mandatory => 'Obligatori';

  @override
  String get prices_category_optional => 'Opcional';

  @override
  String get prices_category_error_mandatory => 'La categoria és obligatòria';

  @override
  String get prices_barcode_reader_action => 'Lector de codis de barres';

  @override
  String get prices_view_prices => 'Veure els preus';

  @override
  String get prices_list_title => 'Llista de preus';

  @override
  String get prices_list_count => 'Nombre de preus\n';

  @override
  String get prices_list_add_new_price => 'Afegeix un\npreu nou';

  @override
  String get prices_list_empty_title => 'Encara no hi ha preu!';

  @override
  String get prices_list_empty_subtitle =>
      'Sigues el primer a afegir-ne un:\nEscanejant un **rebut** o una **etiqueta de preu**!';

  @override
  String get prices_entry_shop_not_found => 'Botiga desconeguda';

  @override
  String prices_entry_menu_title(String user) {
    return 'Entrada de preu des de \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Veure tots els preus d\'aquest producte';

  @override
  String get prices_entry_menu_open_proof => 'Veure prova';

  @override
  String get prices_entry_menu_my_prices => 'Veure els meus altres preus';

  @override
  String get prices_entry_menu_author_prices =>
      'Veure altres preus de l\'autor';

  @override
  String get prices_entry_menu_shop_prices => 'Veure altres preus de la botiga';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count preus',
      one: '1 preu',
    );
    return '$_temp0 per a $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tots els $count preus',
      one: 'Només un preu',
      zero: 'Encara no hi ha preu',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Preus més recents $pageSize (total: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Preu: $price / Botiga: \"$location\" / Publicat a $date per \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Proves obertes de \"$user\"';
  }

  @override
  String get prices_open_proof => 'Prova de preu obert';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Totes les $count proves',
      one: 'Només una prova',
      zero: 'Encara no hi ha cap prova',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Últimes proves $pageSize (total: $total)';
  }

  @override
  String get prices_users_empty_title => 'Encara no hi ha cap col·laborador!';

  @override
  String get prices_users_empty_explanation =>
      'Sigues el primer a afegir un preu!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Col·laboradors principals $pageSize (total: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Encara no hi ha botiga!';

  @override
  String get prices_locations_empty_explanation =>
      'Sigues el primer a afegir un preu!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Ubicacions principals $pageSize (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count proves',
      one: 'Una prova',
      zero: 'Cap prova',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count productes',
      one: 'Un producte',
      zero: 'Cap producte',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count usuaris',
      one: 'Un usuari',
      zero: 'Cap usuari',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count preus',
      one: 'Un preu',
      zero: 'Sense preu',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Preu afegit anteriorment';

  @override
  String get prices_amount_subtitle => 'Import';

  @override
  String get prices_amount_is_discounted => 'Té descompte?';

  @override
  String get prices_amount_price_normal => 'Preu';

  @override
  String get prices_amount_price_discounted => 'Preu rebaixat';

  @override
  String get prices_amount_price_not_discounted => 'Preu original';

  @override
  String get prices_amount_no_product => 'Falta un producte!';

  @override
  String get prices_amount_price_incorrect => 'Valor incorrecte';

  @override
  String get prices_amount_price_mandatory => 'Valor obligatori';

  @override
  String get prices_currency_subtitle => 'Moneda';

  @override
  String get prices_date_subtitle => 'Data';

  @override
  String get prices_location_subtitle => 'Botiga';

  @override
  String get prices_location_find => 'Troba una botiga';

  @override
  String get prices_location_mandatory => 'Has de triar una botiga!';

  @override
  String get prices_location_search_broader =>
      'No has trobat el que buscaves? Provem una cerca més àmplia!';

  @override
  String get prices_proof_subtitle => 'Prova';

  @override
  String get prices_proof_empty_title => 'Encara no hi ha proves!';

  @override
  String get prices_proof_empty_explanation =>
      'Comença afegint una foto d\'un **rebut** o una **etiqueta de preu**!';

  @override
  String get prices_proof_find => 'Selecciona una prova';

  @override
  String get prices_proof_change => 'Prova de canvi';

  @override
  String get prices_proof_receipt => 'Rebut';

  @override
  String get prices_proof_price_tag => 'Etiqueta de preu';

  @override
  String get prices_proof_mandatory => 'Has de triar una prova!';

  @override
  String get prices_add_validation_error => 'Error de validació';

  @override
  String get prices_privacy_warning_title => 'Avís de privadesa';

  @override
  String get prices_unknown_product => 'Producte desconegut';

  @override
  String get prices_privacy_warning_main_message =>
      'Els preus **seran públics**, juntament amb la botiga a la qual es refereixen.\n\nAixò podria permetre a les persones que coneixen el vostre pseudònim d\'Open Food Facts:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Dedueix en quina zona vius';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Sàpigues què estàs comprant';

  @override
  String get prices_privacy_warning_sub_message =>
      'Si això no us sembla còmode, canvieu el pseudònim o creeu un compte nou d\'Open Food Facts i inicieu la sessió a l\'aplicació amb ell.';

  @override
  String get i_refuse => 'Em nego';

  @override
  String get i_accept => 'Accepto';

  @override
  String get prices_currency_change_proposal_title => 'Canviar la moneda?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'La teva moneda actual és **$currency**. Vols canviar-la a **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Sí, feu servir $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'No, conserva $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Fet';

  @override
  String get dev_mode_section_server => 'Configuració del servidor';

  @override
  String get dev_mode_section_news => 'Configuració del proveïdor de notícies';

  @override
  String get dev_mode_section_product_page => 'Pàgina del producte';

  @override
  String get dev_mode_section_ui => 'Interfície d\'usuari';

  @override
  String get dev_mode_section_experimental_features =>
      'Característiques experimentals';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Exclou la puntuació verda';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Utilitzeu un corrector ortogràfic per a les pantalles OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredients i embalatge)';

  @override
  String get dev_mode_reset_app_language_title =>
      'Restableix l\'idioma de l\'aplicació';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Afegeix targetes';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Canvia entre prices.openfoodfacts.org (PROD) i l\'entorn de prova';

  @override
  String get search_history_item_edit_tooltip =>
      'Reutilitza i edita aquesta cerca';

  @override
  String get search_history_item_remove_tooltip => 'Suprimeix';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Has baixat tots els $totalSize productes.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Descarrega $count productes més\nJa s\'han descarregat $downloaded de $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'La cerca de $search està en curs.\n\nEspereu uns segons…';
  }

  @override
  String get user_search_contributor_title => 'Productes I afegits';

  @override
  String get user_search_informer_title => 'Productes I editats';

  @override
  String get user_search_photographer_title => 'Productes I fotografiats';

  @override
  String get user_search_to_be_completed_title =>
      'Els meus productes pendents de completar';

  @override
  String get user_search_prices_title => 'Els meus preus';

  @override
  String get user_search_proofs_title => 'Les meves proves';

  @override
  String get user_search_proof_title => 'La meva prova';

  @override
  String search_proof_title(String user) {
    return 'Prova de \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Preus de col·laboradors: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Últims preus afegits';

  @override
  String get all_search_prices_top_user_title =>
      'Els que més contribueixen al preu';

  @override
  String get all_search_prices_top_location_title => 'Botigues amb més preus';

  @override
  String get prices_contribution_assistant =>
      'Assistent de contribució de preus';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Afegeix diverses proves';

  @override
  String get all_search_prices_top_location_single_title =>
      'Preus en una botiga';

  @override
  String get all_search_prices_top_product_title => 'Productes amb més preus';

  @override
  String get all_search_to_be_completed_title =>
      'Tots els productes per completar';

  @override
  String get categorize_products_country_title =>
      'Ajuda a classificar els productes del teu país';

  @override
  String get edit_product_action_retake_picture => 'Torna a fer la foto';

  @override
  String get edit_product_action_take_picture => 'Fes una foto';

  @override
  String get edit_product_action_confirm => 'Confirma';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Accepto la Política de Dades sobre Aliments Oberts ';

  @override
  String get signup_page_terms_of_use_line2 => 'termes d\'ús i contribució';

  @override
  String get analytics_consent_image_semantic_label => 'Icona d\'Analítiques';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Error fatal: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Error fatal: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'Detalls bàsics complets';

  @override
  String get edit_photo_button_label => 'Edita';

  @override
  String get edit_photo_unselect_button_label => 'Desselecciona la foto';

  @override
  String get edit_photo_select_existing_button_label =>
      'Seleccionar una imatge existent';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Seleccioneu una imatge fent-hi clic';

  @override
  String get edit_photo_select_existing_download_label =>
      'Recuperant imatges existents…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'No hi ha imatges carregades anteriorment relacionades amb aquest producte.';

  @override
  String get edit_photo_language_not_this_one =>
      'Encara no hi ha imatge en aquest idioma';

  @override
  String get edit_photo_language_none => 'Encara no hi ha imatge';

  @override
  String get category_picker_screen_title => 'Categories';

  @override
  String get basic_details => 'Detalls bàsics';

  @override
  String get product_name => 'Nom del producte';

  @override
  String get product_names => 'Noms de productes';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Afegeix una nova traducció';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Abans de validar, assegureu-vos d\'afegir només una traducció **si l\'idioma és present a l\'envàs**';

  @override
  String get add_basic_details_product_name_open_photo => 'Veure foto frontal';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Fes una foto frontal';

  @override
  String get add_basic_details_product_name_hint =>
      'Introdueix el nom del producte (per exemple: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Canviar l\'idioma predeterminat?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Voleu que l\'idioma per defecte del producte estigui definit com a \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Bons exemples';

  @override
  String get explanation_section_bad_examples => 'Mals exemples';

  @override
  String get add_basic_details_product_name_help_title =>
      'Bones pràctiques: Nom del producte';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'El nom del producte és el **nom principal imprès a l\'envàs**. Pot ser una marca registrada.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Nota:** Si us plau, no afegiu una traducció **si l\'idioma no apareix a l\'envàs**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'quètxup de tomàquet';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'No inclogueu la marca al nom';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Ketchup de tomàquet **de Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'No utilitzeu símbols ®, ™, © ni similars.';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count altres traduccions',
      one: '$count altra traducció',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Nom de la marca';

  @override
  String get brand_names => 'Noms de marca';

  @override
  String get add_basic_details_brand_name_error =>
      'Si us plau, introduïu el nom de la marca';

  @override
  String get add_basic_details_brand_names_hint =>
      'Marques d\'entrada (per exemple: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Bones pràctiques: Marques';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Introduïu **totes les marques del producte**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Marca principal';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'La **marca principal**, que generalment es mostra clarament a l\'envàs frontal, s\'ha d\'**introduir primer**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Altres marques';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Quan ho ven **una gran empresa**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** és venut per **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Quan es ven amb la seva marca **traduïda a diversos idiomes**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Vall de la Natura** de vegades s\'escriu **Vall Natura**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Quantitat i pes';

  @override
  String get add_basic_details_quantity_hint =>
      'Introduïu el pes i, si cal, la quantitat (per exemple: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Bones pràctiques: Quantitat';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copieu el valor indicat al producte i **no us oblideu de les unitats**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** o **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (per a 6 ous)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(per a un producte amb 3 caixes, cadascuna de 150 g)';

  @override
  String get barcode => 'Codi de barres';

  @override
  String barcode_barcode(String barcode) {
    return 'Codi de barres: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Codi de barres invàlid';

  @override
  String get basic_details_add_success =>
      'Els detalls bàsics s\'han afegit correctament';

  @override
  String get basic_details_add_error =>
      'No es poden afegir detalls bàsics. Si us plau, torna-ho a provar d\'aquí a un temps';

  @override
  String get clear_search => 'Esborra la cerca';

  @override
  String get confirm_clear =>
      'Esteu a punt d\'esborrar tot el vostre historial: esteu segurs que voleu continuar?';

  @override
  String get alert_clear_selected_user_list =>
      'Esteu a punt d\'esborrar els elements seleccionats del vostre historial';

  @override
  String get confirm_clear_selected_user_list =>
      'Estàs segur que vols continuar?';

  @override
  String get alert_select_items_to_clear =>
      'Seleccioneu un o més elements per esborrar';

  @override
  String confirm_clear_user_list(String name) {
    return 'Esteu a punt d\'esborrar aquesta llista ($name): estàs segur que vols continuar?';
  }

  @override
  String get confirm_delete_user_list_title => 'Voleu eliminar la llista?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Esteu a punt d\'eliminar la llista \"$name\".\nEsteu segur que voleu continuar?';
  }

  @override
  String get confirm_delete_user_list_button => 'Sí, confirmo';

  @override
  String importance_label(String name, String id) {
    return '$name importància: $id';
  }

  @override
  String get user_list_all_title => 'Llistes';

  @override
  String get user_list_all_empty => 'Creeu la vostra primera llista';

  @override
  String get product_list_select => 'Tria una llista';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count productes',
      one: 'Un producte',
      zero: 'Llista buida',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Afegeix llista';

  @override
  String get open_food_preferences_tooltip =>
      'Editeu les vostres preferències alimentàries';

  @override
  String get add_photo_button_label => 'Afegeix foto';

  @override
  String get add_packaging_photo_button_label =>
      'Feu fotos de qualsevol informació d\'embalatge/reciclatge';

  @override
  String get add_origin_photo_button_label =>
      'Feu fotos de qualsevol informació d\'origen';

  @override
  String get add_emb_photo_button_label =>
      'Feu fotos de qualsevol informació del codi de traçabilitat';

  @override
  String get add_label_photo_button_label =>
      'Feu fotos de qualsevol informació sobre etiquetes i certificacions';

  @override
  String get choose_image_source_title => 'Trieu la font de la imatge';

  @override
  String get choose_image_source_body => 'Si us plau, trieu una font d\'imatge';

  @override
  String get gallery_source_label => 'Galeria';

  @override
  String get gallery_source_access_denied_dialog_title => 'Accés denegat';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Malauradament, l\'aplicació no pot accedir a la vostra galeria, ja que prèviament heu denegat el permís.\n\nAneu a la configuració de les aplicacions al vostre telèfon Configuració -> Fotos';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Obre la Configuració';

  @override
  String get share => 'Comparteix';

  @override
  String share_product_text(String url) {
    return 'Fes una ullada a aquest producte a Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Fes una ullada a aquest producte a Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Fes una ullada a aquest producte a Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Fes una ullada a aquest producte a Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Fes una ullada a la meva llista de productes a Open Food Facts: $url';
  }

  @override
  String get capture => 'Nova captura';

  @override
  String get capture_new_picture => 'Fer una foto';

  @override
  String get choose_from_gallery => 'Triar de la galeria';

  @override
  String get image_upload_queued =>
      'La imatge es penjarà en segon pla tan aviat com sigui possible.';

  @override
  String get add_price_queued =>
      'El preu s\'enviarà al servidor tan aviat com sigui possible.';

  @override
  String get background_task_title_full_refresh =>
      'Començant l\'actualització de tots els productes emmagatzemats localment';

  @override
  String get background_task_title_folksonomy =>
      'S\'estan començant a realitzar les accions del servidor per a les actualitzacions de folksonomy emmagatzemades localment.';

  @override
  String get background_task_title_top_n =>
      'Començant la descàrrega dels productes més populars';

  @override
  String get expand_nutrition_facts => 'Amplieu la taula de dades nutricionals';

  @override
  String get expand_nutrition_facts_body =>
      'Manteniu la taula de dades nutricionals ampliada';

  @override
  String get expand_ingredients => 'Ampliar els ingredients';

  @override
  String get expand_ingredients_body =>
      'Manteniu el panell d\'ingredients expandit';

  @override
  String get no_internet_connection => 'No hi ha connexió a Internet';

  @override
  String get world_results_label => 'Món sencer';

  @override
  String get world_results_action => 'Amplieu la vostra cerca al món';

  @override
  String get copy_to_clipboard => 'Copia';

  @override
  String get paste_from_clipboard => 'Enganxa des del porta-retalls';

  @override
  String get no_data_available_in_clipboard =>
      'No hi ha dades disponibles al porta-retalls';

  @override
  String get clipboard_barcode_copy =>
      'Copia el codi de barres al porta-retalls';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Codi de barres $barcode copiat al porta-retalls!';
  }

  @override
  String get open_product_website => 'Obre aquest producte al lloc web';

  @override
  String get language_picker_label => 'El vostre idioma';

  @override
  String get country_picker_label => 'El vostre país';

  @override
  String get currency_picker_label => 'La teva moneda';

  @override
  String get help_with_openfoodfacts => 'Ajuda a OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'El producte s\'actualitzarà en segon pla tan aviat com sigui possible.';

  @override
  String get no_email_client_available_dialog_title =>
      'No hi ha aplicacions de correu electrònic!';

  @override
  String get no_email_client_available_dialog_content =>
      'Si us plau, envieu-nos un correu electrònic manualment a mobile@openfoodfacts.org';

  @override
  String get all_images => 'Totes les imatges';

  @override
  String get selected_images => 'Imatges seleccionades';

  @override
  String get product_card_remove_product_tooltip => 'Eliminar el producte';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nou codi de barres escanejat: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Traieu tots els productes del carrusel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Si us plau, escaneja almenys dos productes per comparar-los';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Feu clic per comparar els productes que heu escanejat';

  @override
  String get scan_product_loading => 'Has escanejat\nel codi de barres:';

  @override
  String get scan_product_loading_initial =>
      'Estem buscant aquest producte!\nSi us plau, espereu uns segons…';

  @override
  String get scan_product_loading_long_request =>
      'Encara estem buscant aquest producte!\nTrobeu que triga molt a carregar? Nosaltres també…';

  @override
  String get scan_product_loading_unresponsive =>
      'Encara estem buscant aquest producte.\nVoleu reiniciar la cerca?';

  @override
  String get scan_product_loading_restart_button => 'Reinicia la cerca';

  @override
  String get portion_calculator_description =>
      'Calcula els valors nutricionals per a una quantitat específica';

  @override
  String get portion_calculator_hint => 'Quantitat en';

  @override
  String get portion_calculator_accessibility =>
      'Introdueix una quantitat per calcular les dades nutricionals';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Si us plau, introduïu una quantitat entre $min i $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Falten dades. No s\'ha pogut realitzar el càlcul.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Dades nutricionals per a $grams g (o ml)';
  }

  @override
  String get offline_data => 'Dades fora de línia';

  @override
  String get ocr_image_upload_instruction =>
      'Carregueu una imatge per extreure automàticament la informació que conté.';

  @override
  String get upload_image => 'Penjar una foto';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'No s\'ha pogut baixar la imatge';

  @override
  String get image_edit_url_error =>
      'No s\'ha pogut editar la imatge perquè l\'URL de la imatge no s\'ha definit.';

  @override
  String get user_picture_source_remember => 'Recorda la meva selecció';

  @override
  String get user_picture_source_ask => 'Pregunta cada vegada.';

  @override
  String get robotoff_continue => 'Continuar';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'es $count preguntes',
      one: 'a pregunta',
    );
    return 'Pròxim$_temp0';
  }

  @override
  String get show_password => 'Mostra la contrasenya';

  @override
  String get owner_field_info_title => 'Valors proporcionats pel productor';

  @override
  String get owner_field_info_message =>
      'Amb aquest logotip destaquem les dades proporcionades pel productor, i que poden no ser editables.';

  @override
  String get owner_field_info_close_button => 'Tanca aquesta informació';

  @override
  String get owner_field_image =>
      'Aquesta imatge és proporcionada pel productor. És possible que no sigui editable.';

  @override
  String get edit_packagings_title => 'Components d\'embalatge';

  @override
  String get edit_packagings_element_add => 'Afegiu un component d\'embalatge';

  @override
  String get edit_packagings_completed => 'L\'embalatge està complet';

  @override
  String edit_packagings_element_title(int index) {
    return 'Component d\'embalatge #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Nombre d\'unitats';

  @override
  String get edit_packagings_element_hint_units =>
      'Introduïu el nombre d\'unitats d\'embalatge de la mateixa forma i material que conté el producte.';

  @override
  String get edit_packagings_element_field_shape => 'Forma';

  @override
  String get edit_packagings_element_hint_shape =>
      'Introduïu el nom de la forma que apareix a les instruccions de reciclatge si està disponible o seleccioneu una forma.';

  @override
  String get edit_packagings_element_example_shape => 'Ampolla';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Introduïu el material específic si es pot determinar (hi sol haver un codi de material dins d\'un triangle a les peces d\'embalatge) o un material genèric (per exemple, plàstic o metall) si no n\'esteu segurs.';

  @override
  String get edit_packagings_element_example_material => 'Vidre';

  @override
  String get edit_packagings_element_field_recycling =>
      'Instrucció de reciclatge';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Introduïu les instruccions de reciclatge només si apareixen al producte.';

  @override
  String get edit_packagings_element_example_recycling => 'Reciclar';

  @override
  String get edit_packagings_element_field_quantity =>
      'Quantitat neta de producte per unitat';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Introduïu el pes net o el volum net i indiqueu la unitat (per exemple, g o ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Pes d\'una unitat buida (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Traieu els aliments restants i renteu i assequeu la part de l\'embalatge abans de pesar. Si és possible, utilitzeu una escala amb una precisió de 0,1 g o 0,01 g.';

  @override
  String get background_task_title => 'Contribucions pendents';

  @override
  String get background_task_subtitle =>
      'Les teves contribucions es guarden automàticament al nostre servidor, però no sempre en temps real.';

  @override
  String get background_task_list_empty => 'No hi ha tasques de fons pendents';

  @override
  String get background_task_error_server_time_out =>
      'Temps d\'espera del servidor';

  @override
  String get background_task_error_no_internet =>
      'Error de connexió a Internet. Prova-ho més tard.';

  @override
  String get background_task_operation_unknown =>
      'tipus d\'operació desconegut';

  @override
  String get background_task_operation_details => 'canvis detallats';

  @override
  String get background_task_operation_image => 'càrrega de fotos';

  @override
  String get background_task_operation_refresh =>
      'actualització retardada després de pujar la foto';

  @override
  String get background_task_run_started => 'iniciada';

  @override
  String get background_task_run_not_started => 'sense iniciar';

  @override
  String get background_task_run_to_be_deleted => 'per ser suprimit';

  @override
  String get background_task_question_stop =>
      'Vols aturar aquesta tasca el més aviat possible?';

  @override
  String get feed_back => 'Suggeriments';

  @override
  String get undo => 'Desfés';

  @override
  String get copy_email_to_clip_board =>
      'Copiar correu electrònic al porta-retalls';

  @override
  String get please_send_us_an_email_to =>
      'Envieu-nos manualment un correu electrònic a';

  @override
  String get email_copied_to_clip_board =>
      'S\'ha copiat el correu electrònic al porta-retalls!';

  @override
  String get select_accent_color => 'Seleccioneu Color d\'accent';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Blau';

  @override
  String get color_cyan => 'Cian';

  @override
  String get color_green => 'Verd';

  @override
  String get color_light_brown => 'Per defecte';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Taronja';

  @override
  String get color_pink => 'Rosa';

  @override
  String get color_red => 'Vermell';

  @override
  String get color_rust => 'Rovell';

  @override
  String get color_teal => 'Turquesa fosc';

  @override
  String get text_contrast_mode => 'Contrast del text';

  @override
  String get contrast_high => 'Alt';

  @override
  String get contrast_medium => 'Mitjà';

  @override
  String get contrast_low => 'Baix';

  @override
  String get product_refresher_internet_not_found => 'Producte no trobat!';

  @override
  String get product_refresher_internet_not_connected =>
      'No estàs connectat a Internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Servidor inactiu ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Error del servidor ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Producte no trobat!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Un producte amb el codi de barres següent no existeix a la nostra base de dades: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'No hi ha conexió a internet!';

  @override
  String get product_loader_network_error_message =>
      'Si us plau, comproveu que el vostre telèfon estigui connectat a una xarxa WiFi o que tingui activades les dades mòbils';

  @override
  String get page_not_found_title => 'No s\'ha pogut trobar la pàgina!';

  @override
  String get page_not_found_button => 'Torna a la pàgina d\'inici';

  @override
  String get download_data => 'Descarregar dades';

  @override
  String get download_top_products =>
      'Baixeu els 1000 millors productes del vostre país per a l\'escaneig instantani';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '/s $count producte/s més popular/s',
    );
    return 'Descarrega el$_temp0 al teu país per a l\'escaneig instantani';
  }

  @override
  String get download_in_progress =>
      'Baixant dades\nAixò pot trigar una estona';

  @override
  String downloaded_products(int num) {
    return '$num productes afegits';
  }

  @override
  String get update_offline_data =>
      'Actualitza les dades del producte fora de línia';

  @override
  String get update_local_database_sub =>
      'Actualitzeu la base de dades de productes locals amb les dades més recents d\'Open Food Facts';

  @override
  String get clear_local_database =>
      'Esborra les dades del producte fora de línia';

  @override
  String get clear_local_database_sub =>
      'Esborra totes les dades de productes locals de la teva aplicació per alliberar espai';

  @override
  String deleted_products(int num) {
    return '$num productes suprimits';
  }

  @override
  String get loading => 'S\'està carregant…';

  @override
  String get know_more => 'Més informació';

  @override
  String get offline_data_desc =>
      'Feu clic per obtenir més informació sobre les dades fora de línia';

  @override
  String get offline_product_data_title => 'Dades de producte fora de línia';

  @override
  String available_for_download(int num) {
    return '$num productes disponibles per a l\'exploració immediata';
  }

  @override
  String get country_selector_title => 'Seleccioneu el vostre país:';

  @override
  String get currency_selector_title => 'Seleccioneu la vostra moneda:';

  @override
  String get language_selector_title => 'Selecciona el teu idioma:';

  @override
  String get language_selector_section_selected => 'Idiomes seleccionats';

  @override
  String get language_selector_section_frequently_used =>
      'Utilitzat amb freqüència';

  @override
  String get action_delete_list => 'Elimina';

  @override
  String get action_change_list => 'Canvia la llista actual';

  @override
  String get product_list_create => 'Crea';

  @override
  String get product_list_create_tooltip => 'Crea una llista nova';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (nou càlcul)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (nou càlcul)';

  @override
  String get nutriscore_unknown => 'Nutri-Score desconegut';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nutri-Score desconegut (nou càlcul)';

  @override
  String get nutriscore_not_applicable =>
      'La puntuació Nutri-Score no és aplicable.';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score no és aplicable (nou càlcul)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Puntuació verda A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => 'Puntuació verda desconeguda';

  @override
  String get environmental_score_not_applicable_new =>
      'La puntuació verda no és aplicable';

  @override
  String get nova_group_generic_new => 'Aliments ultraprocessats - Grups NOVA';

  @override
  String get nova_group_1 => 'Grup NOVA 1';

  @override
  String get nova_group_2 => 'Grup NOVA 2';

  @override
  String get nova_group_3 => 'Grup NOVA 3';

  @override
  String get nova_group_4 => 'Grup NOVA 4';

  @override
  String get nova_group_unknown => 'Grup NOVA desconegut';

  @override
  String get nutrition_facts => 'Nivells de nutrients';

  @override
  String get faq_title_partners => 'Socis i patrocinadors de l\'ONG';

  @override
  String get faq_title_vision =>
      'La visió, la missió, els valors i els programes d\'Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Instal·la Open Beauty Facts per crear una base de dades de cosmètics';

  @override
  String get faq_title_install_pet =>
      'Instal·la Open Pet Food Facts per crear una base de dades d\'aliments per a mascotes';

  @override
  String get faq_title_install_product =>
      'Instal·leu Open Products Facts per crear una base de dades de productes per allargar la vida útil dels objectes.';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nou càlcul del Nutri-Score: què hi ha de nou?';

  @override
  String get contact_title_pro_page =>
      'Pro? Importa els teus productes a Open Food Facts';

  @override
  String get contact_title_pro_email => 'Contacte del productor';

  @override
  String get contact_title_press_page => 'Pàgina de premsa';

  @override
  String get contact_title_press_email => 'Contacte de premsa';

  @override
  String get contact_title_newsletter => 'Subscriu-te al nostre butlletí';

  @override
  String get contact_title_calendar =>
      'Subscriu-te al calendari de la nostra comunitat';

  @override
  String get hunger_games_loading_line1 => 'Si us plau, doneu-nos uns segons…';

  @override
  String get hunger_games_loading_line2 => 'Estem descarregant les preguntes!';

  @override
  String get hunger_games_error_label =>
      'Ui! Alguna cosa no ha funcionat… i no hem pogut carregar les preguntes.';

  @override
  String get hunger_games_error_retry_button => 'Tornem-ho a provar!';

  @override
  String get reorder_attribute_action => 'Reordenar els atributs';

  @override
  String get link_cant_be_opened =>
      'Aquest enllaç no es pot obrir al vostre dispositiu. Si us plau, comproveu que teniu un navegador instal·lat.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Detalls per a $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Detalls per a $pageName amb $productName';
  }

  @override
  String get guide_title => 'Guia';

  @override
  String get guide_share_label => 'Comparteix';

  @override
  String get guide_nutriscore_v2_title =>
      'El Nutri-Score està evolucionant: explicacions!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'El Nutri-Score és un logotip que pretén informar-vos sobre la **qualitat nutricional dels aliments**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'El codi de color varia des del verd fosc (**A**) per als productes **més saludables** fins al vermell fosc (**E**) per als **menys saludables**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'El logotip de Nutri-Score A';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Per què està evolucionant Nutri-Score?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'On puc trobar el nou càlcul de Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'El Nutri-Score s\'aplica a 7 països: França, Alemanya, Bèlgica, Espanya, Luxemburg, Països Baixos i Suïssa.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Els fabricants tenen com a màxim **2 anys** després de la signatura del decret **per substituir** el càlcul antic pel nou.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Què és la puntuació verda?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'El Green-Score és un logotip que pretén informar-vos sobre l\'**impacte ambiental dels aliments**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'El codi de color varia del verd fosc (**A+**) per als productes **menys impactants** al vermell fosc (**F**) per als productes **més impactants**.';

  @override
  String get guide_greenscore_logos_caption => 'Els logotips de Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'El nucli: Anàlisi del cicle de vida (ACV)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Una avaluació científica de les categories d\'aliments';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Per a cada categoria de producte, s\'estableix una puntuació **de referència** utilitzant dades de la base de dades ambiental Agribalyse (dissenyada per ADEME i INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      'L\'anàlisi del cicle de vida és un mètode d\'avaluació estandarditzat per dur a terme una avaluació ambiental multietapa i multicriteri.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Mesura:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 passos de producció';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agricultura';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processament';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Empaquetament';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transport';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribució';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consum';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indicadors d\'impacte ambiental';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Canvi climàtic/petjada de carboni';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Esgotament de la capa d\'ozó';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Radiació ionitzant';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Terra';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Ús d\'aigua i energia';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'contaminació de l\'aire';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Aigua marina i dolça (partícules, acidificació, eutrofització)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Esgotament de recursos.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Bonificacions i penalitzacions';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Per recompensar els millors productes dins d\'una categoria, apliquem **bonificacions i penalitzacions basades en diversos criteris**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode de producció';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'Es concedeix una **bonus** als productes que tenen una **etiqueta oficial, una etiqueta o una certificació que garanteix beneficis mediambientals** (orgànic, comerç just, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origen dels ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'S\'atorga una **bonificació** en funció de l\'origen dels ingredients. Aquesta bonificació té en compte l\'**impacte en el transport** i també la **política ambiental** del país de cada productor.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Espècies en perill d\'extinció';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'S\'imposa una **penalització** als productes que contenen ingredients amb impactes negatius significatius sobre la biodiversitat i els ecosistemes, com ara l\'oli de palma, la producció del qual és responsable d\'una desforestació massiva.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Empaquetament';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'Es calcula una **penalització** tenint en compte la **circularitat dels envasos** (ús de matèries primeres reciclades i reciclabilitat) i l\'excés d\'embalatge.';

  @override
  String get guide_greenscore_transparency_title =>
      'Augment de la necessitat de transparència per mesurar i reduir millor els impactes ambientals';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Per calcular amb precisió el Green-Score, cal tenir informació que no necessàriament s\'especifica a l\'envàs (com ara l\'origen i el percentatge exacte de cada ingredient) o que rarament està disponible en forma útil (com ara una llista de tots els components de l\'envàs amb els tipus precisos de plàstics utilitzats).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Es fan servir valors mitjans quan aquesta informació encara no està disponible**, però ara demanem a tothom que ens ajudi a recopilar aquesta informació, que serà molt útil per al Green-Score, però també per a molts altres usos.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Com poden ajudar els ciutadans?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Tots els ciutadans ens poden ajudar a recopilar i estructurar la informació que hi ha als productes o que se\'n pot deduir, com ara la informació sobre els **envasos**: \"Mission Emballages\": un inventari col·laboratiu a gran escala d\'envasos per a tots els productes alimentaris (en francès).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Com poden ajudar els fabricants';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Els fabricants ens poden enviar la seva informació directament a través de la nostra plataforma gratuïta per a productors.';

  @override
  String get guide_greenscore_better_product_title =>
      'Quin producte és millor per al planeta?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Pot ser difícil de dir';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Triar aliments sostenibles és una de les coses més poderoses que podem fer pel clima, ja que **el nostre sistema alimentari global és responsable de més d\'una quarta part de totes les emissions de gasos d\'efecte hivernacle**.\n(Font: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Tu tens el poder!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'La bona notícia és que això ens dóna una manera poderosa de crear canvis.\n**Cadascun de nosaltres menja uns 1.000 àpats cada any**. Això són 1.000 oportunitats per **triar un futur millor per al planeta**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Ajuda a ser responsable i a decidir';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Triar aliments sostenibles pot semblar complex. Les etiquetes són confuses i sovint falta informació. El Green-Score es va crear per simplificar-ho, donant-vos una qualificació ambiental **clara**, **basada en la ciència** i **transparent** per als productes alimentaris, just on la necessiteu: mentre compreu.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparència';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'A diferència de les etiquetes pròpies, el càlcul de Green-Score és **completament obert** i qualsevol persona pot **verificar-lo**.';

  @override
  String get guide_nova_title => 'Aliments ultraprocessats';

  @override
  String get guide_nova_what_is_nova_title => 'Què és l\'ultraprocessament?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Els grups NOVA us informen sobre el nivell de processament d\'aliments.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'La classificació NOVA permet la categorització dels aliments en **4 grups** segons el seu **grau de processament industrial** (aliments mínimament processats o no processats, ingredients culinaris, aliments processats, aliments ultraprocessats).';

  @override
  String get guide_nova_logos_caption => 'Els logotips de NOVA';

  @override
  String get guide_nova_groups_title => 'Els 4 grups NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Hi ha 4 grups NOVA, i el problemàtic és el Grup 4: aliments ultraprocessats.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Aliments mínimament processats o sense processar';

  @override
  String get guide_nova_groups_arg1_text =>
      'Els aliments no processats (o naturals) són les **parts comestibles de les plantes** (llavors, fruits, fulles, tiges, arrels) **o animals** (múscul, despulles, ous, llet), així com els fongs, les algues i l\'aigua, després d\'haver-les separat de la natura.';

  @override
  String get guide_nova_groups_arg2_title => 'Ingredients culinaris processats';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Aliments processats';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes Include various preservation or cooking Methods, and In the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as Modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Aliments ultraprocessats';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. Ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed Products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly Extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Els problemes amb l\'ultraprocessament';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Processament extrem d\'ingredients alimentaris';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Molts **deriven del processament posterior de constituents alimentaris**, com ara olis hidrogenats o interesterificats, proteïnes hidrolitzades, aïllat de proteïna de soja, maltodextrina, sucre invertit i xarop de blat de moro amb alt contingut en fructosa.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Additius que van més enllà de la pura seguretat alimentària';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Els additius dels aliments ultraprocessats inclouen alguns que també s\'utilitzen en aliments processats, com ara conservants, antioxidants i estabilitzadors. Les classes d\'additius que només es troben en productes ultraprocessats inclouen els que s\'utilitzen **per imitar o millorar les qualitats sensorials dels aliments o per dissimular aspectes desagradables del producte final**. Aquests additius inclouen colorants i altres colorants, estabilitzadors del color; sabors, potenciadors del sabor, edulcorants sense sucre; i coadjuvants de processament com ara agents carbonatants, reafirmants, volumitzants i antivoluminants, agents antiespumants, antiaglomerants i glacejants, emulsionants, segrestants i humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Processament que no pots fer a casa';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**S\'utilitza una multitud de seqüències de processos** per combinar els ingredients que normalment són nombrosos i crear el producte final (d\'aquí que es digui \"ultraprocessat\"). Els processos n\'inclouen diversos **sense equivalents domèstics**, com ara la hidrogenació i la hidrolització, l\'extrusió i el modelat, i el preprocessament per a la fregidura.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Els aspectes depredadors i financers de l\'ultraprocessament';

  @override
  String get guide_nova_explanations_arg4_text =>
      'L\'objectiu general de l\'ultraprocessament és crear productes alimentaris de marca, pràctics (duradors, llestos per consumir), atractius (hiperpalatables) i altament rendibles (ingredients de baix cost), dissenyats per desplaçar tots els altres grups d\'aliments. Els productes alimentaris ultraprocessats solen envasar-se de manera atractiva i es comercialitzen de manera intensiva.';

  @override
  String get guide_nova_explanations_arg5_title => 'Un perill per a la salut';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Des del 2018, amb NutriNet-Santé, s\'han destacat els primers vincles entre **el consum d\'aliments ultraprocessats i l\'augment dels riscos de càncer, malalties cardiovasculars i diabetis**. Avui dia, més de 90 estudis a tot el món confirmen aquestes troballes.\nLes associacions més fortes es relacionen amb **l\'obesitat, la mortalitat cardiovascular i els símptomes depressius**. En els nens, els efectes s\'observen principalment en el pes i els desequilibris lipídics.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Els països recomanen limitar-los';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Alguns països utilitzen els grups NOVA per a les seves pautes o objectius dietètics, per exemple:\n\n- **🇧🇷 Les pautes dietètiques del Brasil** **recomanen limitar el consum** d\'aliments processats i evitar els aliments ultraprocessats.\n\n- **🇫🇷 Els objectius de la política nutricional de salut pública de França** per al període 2018-2022 tenen com a objectiu **reduir el consum d\'aliments ultraprocessats del grup 4 en un 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-ca.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Benvinguts a Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Què és Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts és una base de dades **col·laborativa**, **gratuïta** i **oberta** de productes alimentaris d\'arreu del món.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Creiem que tothom hauria de tenir accés a la informació sobre el que menja. Recopilant dades sobre ingredients, al·lèrgens, informació nutricional i més, **capacitem els consumidors per prendre decisions informades** i impulsem la indústria alimentària **cap a una major transparència**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Característiques d\'Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Rep alertes sobre els ingredients no desitjats';

  @override
  String get guide_open_food_facts_tips_title => 'Consells per fer bones fotos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Què no fer';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Eviteu les ombres i els enlluernaments.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Sense text borrós ni desenfocat.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'No retallis parts del text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Eviteu els fons carregats.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Què fer';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Utilitza una bona il·luminació uniforme.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Assegureu-vos que el text sigui nítid i llegible.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Captura tota la llista d\'ingredients.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Mantingueu el producte sobre una superfície plana.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Ajuda\'ns a construir la \"Viquipèdia del menjar\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Una puntuació sobre la qualitat nutricional';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Una puntuació per evitar els aliments ultraprocessats';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Una puntuació per al planeta';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-ca.openfoodfacts.org/descobrir';

  @override
  String get guide_open_pet_food_facts_title =>
      'Benvinguts a Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Què és Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts estén la nostra missió als nostres amics peluts! És una **base de dades de productes alimentaris per a mascotes per a gats, gossos i altres companys**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Recopilem informació sobre **ingredients**, **anàlisi nutricional** i pautes d\'alimentació per ajudar els propietaris de mascotes a triar el millor aliment per a les necessitats dels seus animals.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Característiques dels aliments oberts per a mascotes';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Rep alertes sobre els ingredients no desitjats';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'La teva mascota és al·lèrgica a algun ingredient? Pots definir una llista d\'ingredients cosmètics que cal evitar, directament a l\'aplicació!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Consells per fer bones fotos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Què no fer';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Eviteu les ombres i els enlluernaments.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Sense text borrós ni desenfocat.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'No retallis parts del text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Eviteu els fons carregats.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Què fer';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Utilitza una bona il·luminació uniforme.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Assegureu-vos que el text sigui nítid i llegible.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Captura tota la llista d\'ingredients.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Mantingueu el producte sobre una superfície plana.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Una nota sobre la puntuació';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Desenvolupar un sistema de puntuació per a aliments per a mascotes **no és una prioritat ara mateix**. La metodologia seria complexa, ja que les necessitats nutricionals varien molt segons l\'espècie, l\'edat i l\'estat de salut. Encara no hem trobat cap equip científic independent capaç de desenvolupar aquesta puntuació.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-ca.openpetfoodfacts.org/descobrir';

  @override
  String get guide_open_beauty_facts_title => 'Benvinguts a Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Què és Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts és una base de dades col·laborativa de **productes cosmètics**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'El nostre objectiu és desxifrar les llistes d\'ingredients per ajudar-vos a **entendre què contenen els vostres productes d\'higiene personal**. Des de cremes hidratants fins a maquillatge, recopilem dades sobre ingredients, al·lèrgens i envasos per promoure la transparència en la indústria cosmètica.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Característiques d\'Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Rep alertes sobre els ingredients no desitjats';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Ets al·lèrgic a algun ingredient? Vols evitar les substàncies comedogèniques? Vols mantenir-te allunyat dels components controvertits? Pots definir una llista d\'ingredients cosmètics que cal evitar, directament a l\'aplicació!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Consells per fer bones fotos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Què no fer';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Eviteu les ombres i els enlluernaments.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Sense text borrós ni desenfocat.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'No retallis parts del text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Eviteu els fons carregats.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Què fer';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Utilitza una bona il·luminació uniforme.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Assegureu-vos que el text sigui nítid i llegible.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Captura tota la llista d\'ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Fes tantes fotos com necessitis si l\'ampolla és corba.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Potser haureu de desenganxar l\'etiqueta per veure la llista d\'ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Mantingueu el producte sobre una superfície plana.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Una nota sobre la puntuació';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'A diferència dels productes alimentaris, el món dels cosmètics **no té un sistema de puntuació universalment reconegut i avalat pel govern com el Nutri-Score**. Els efectes dels ingredients poden ser molt personals i depenen del tipus de pell, les al·lèrgies i les preocupacions individuals.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-ca.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices és un projecte per **recopilar i compartir preus de productes a tot el món**. És un conjunt de dades disponible públicament que es pot utilitzar per a la recerca, l\'anàlisi i més. Open Prices està desenvolupat i mantingut per Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'Com funciona Open Prices?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Estem creant col·laboracions amb un conjunt de dades de preus de codi obert.** Els usuaris poden afegir preus a través d\'aquesta aplicació web o a través de l\'aplicació mòbil oficial Open Food Facts. Els minoristes o les aplicacions de tercers també poden contribuir mitjançant la nostra API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Recopila fotos d\'etiquetes de preus als passadissos';

  @override
  String get guide_open_prices_how_arg2_title => 'Recopila fotos de rebuts';

  @override
  String get guide_open_prices_why_title => 'Per què fa això Open Food Facts?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'La informació sobre els preus és de suma importància per entendre els sistemes alimentaris. És un factor clau per entendre el cost dels aliments i per promoure dietes més saludables. Les dades de preus d\'obertura són una manera de facilitar que els investigadors, periodistes i ciutadans puguin **comprensió millor de com varien geogràficament i en el temps els preus dels aliments**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Seguir l\'evolució dels preus al llarg del temps';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Vegeu l\'**evolució dels preus**: inflació minvant, inflació barata, les podem seguir junts!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compara preus a prop teu';

  @override
  String get guide_open_prices_why_arg2_text =>
      'A mesura que tinguem més preus, podreu detectar **les botigues més barates del vostre voltant**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Has considerat extreure preus dels llocs web dels minoristes?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Per motius legals i tècnics, **no considerem que extreure preus dels llocs web dels minoristes sigui una manera vàlida de contribuir a Open Prices**. Volem assegurar-nos que els preus que recopilem siguin precisos i estiguin actualitzats, i rebre preus extrets dels col·laboradors no ens permet fer-ho.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'El scraping de preus és una opció considerada en una versió futura d\'Open Prices, però ho faria el mateix Open Prices per tal que puguem tenir una prova del preu basada en la pàgina HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Podeu contribuir amb preus mitjançant la nostra API.\nSi voleu contribuir amb preus a gran escala, poseu-vos en contacte amb nosaltres a prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Benvinguts a Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Què són els fets sobre productes oberts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts és una base de dades massiva i oberta per a **qualsevol producte amb codi de barres, que no sigui aliment, cosmètic o menjar per a mascotes**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Des d\'**electrònica** fins a **joguines**, i **roba** fins a **productes de neteja**, si té un codi de barres, es pot afegir. Aquest projecte pretén crear una \"Internet de les coses\" per a objectes quotidians, fent que la informació sobre ells sigui universalment accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Característiques dels productes oberts Dades';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts té com a objectiu proporcionar als consumidors la possibilitat d\'**allargar la vida útil dels objectes** proporcionant solucions circulars per mantenir, **reparar**, **reciclar** els seus objectes o donar-los un nou propietari.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Petjades de carboni per a alguns productes';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** de l\'ADEME, l\'Autoritat Francesa de Medi Ambient, proporciona l\'**impacte en carboni** de moltes categories; assegureu-vos de classificar els productes amb precisió.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Índex de reparabilitat per a molts productes';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Sempre que hi hagi un índex de reparabilitat francès disponible, el mostrarem. A més, **podeu començar a recopilar les variables mitjançant el motor de folksonomia**; de manera que puguem recalcular-lo nosaltres mateixos en el futur, fins i tot en països on no està disponible.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Troba maneres de donar/revendre el teu producte';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Us proporcionem enllaços a **serveis de tercers respectuosos amb el medi ambient** que us ajuden a obtenir el tipus de producte que busqueu, com a producte de segona mà, per ser més respectuós amb els recursos planetaris.\nTingueu en compte que no ens paguen per fer això i que el sistema només funciona com a exemple per a dos llocs web a França. Podeu ajudar a ampliar aquest sistema documentant més llocs a la wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Quina informació és útil?';

  @override
  String get guide_open_products_facts_information_text =>
      'Per a una gamma tan àmplia d\'elements, **les dades que recopilem són flexibles**. Per fer-ho, **hem creat el motor de folksonomia**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'El motor de folksonomia';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'El motor de folksonomia és una eina que t\'ajuda a completar productes amb propietats rellevants. Això ajuda a millorar la cerca i la descobribilitat, però també a calcular i mostrar coses interessants en el futur.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Podeu afegir qualsevol clau i valor com ara: **compatibilitat_amb_network_mobile_5G: sí**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Rebràs un autosuggeriment de possibles propietats i et convidem a afegir-ne de noves sobre els teus tipus de productes preferits.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-ca.openproductsfacts.org/descobrir';

  @override
  String get guide_open_preferences_button_title =>
      'Preferències alimentàries obertes';

  @override
  String get guide_coming_soon_button_title => 'Properament';

  @override
  String get guide_learn_more_subtitle => 'Toca per obtenir més informació';

  @override
  String get preview_badge => 'Vista prèvia';

  @override
  String get prices_feedback_form =>
      'Feu clic aquí per enviar-nos els vostres comentaris sobre aquesta nova funció!';

  @override
  String get menu_button_list_actions => 'Selecciona una acció';

  @override
  String get error_loading_photo =>
      'S\'ha produït un error en carregar la foto';

  @override
  String get photo_viewer_action_use_picture_as => 'Utilitza com a…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Fes servir aquesta imatge com a…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Fes servir aquesta imatge com a… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Detalls';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Detalls d\'aquesta foto';

  @override
  String get photo_viewer_details_title => 'Detalls de la foto';

  @override
  String get photo_viewer_details_contributor_title => 'Voluntari/a';

  @override
  String get photo_viewer_details_size_title => 'Mida';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height píxels';
  }

  @override
  String get photo_viewer_details_date_title => 'Data';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Compatible';

  @override
  String get user_lists_action_multi_select => 'Selecció múltiple';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'La teva puntuació de compatibilitat: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Imatge frontal';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Imatge dels ingredients';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Imatge nutricional';

  @override
  String get product_image_packaging_accessibility_label =>
      'Imatge de l\'embalatge';

  @override
  String get product_image_other_accessibility_label => 'Altra imatge';

  @override
  String get product_image_outdated_message =>
      'Aquesta imatge pot estar desactualitzada';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (aquesta imatge pot estar desactualitzada)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (és possible que el productor hagi bloquejat aquesta imatge)';
  }

  @override
  String get product_image_error => 'No s\'ha pogut carregar la imatge!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'No es pot carregar $type (error de xarxa?)';
  }

  @override
  String get product_page_image_no_image_available => 'Cap imatge\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'No hi ha cap imatge disponible per a aquest producte';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Reordenar o ocultar accions';

  @override
  String get product_page_action_bar_setting_modal_title => 'Edita accions';

  @override
  String get product_page_action_bar_item_move_up => 'Puja';

  @override
  String get product_page_action_bar_item_move_down => 'Moure cap avall';

  @override
  String get product_page_action_bar_item_enable => 'Activa l\'acció';

  @override
  String get product_page_action_bar_item_disable => 'Desactiva l\'acció';

  @override
  String get product_page_pending_operations_banner_title =>
      'Pujant les teves edicions…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Les dades que es mostren en aquesta pàgina **encara no reflecteixen les vostres modificacions**.\nEspereu uns segons…';

  @override
  String get product_add_a_language => 'Afegeix un idioma';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Codi de barres $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Elimina aquest producte del carrusel';

  @override
  String get carousel_unsupported_header => 'Codi de barres no compatible!';

  @override
  String get carousel_unsupported_title => 'Ups!';

  @override
  String get carousel_unsupported_text =>
      'El codi de barres escanejat no és compatible amb Open Food Facts!';

  @override
  String get carousel_error_header => 'Error!';

  @override
  String get carousel_error_title => 'És una llàstima!';

  @override
  String get carousel_error_text_1 =>
      'No hem pogut descarregar la informació d\'aquest codi de barres:';

  @override
  String get carousel_error_text_2 =>
      'Si us plau, comproveu la vostra connexió a Internet o feu clic en aquest botó:';

  @override
  String get carousel_error_button => 'Torna a provar';

  @override
  String get carousel_unknown_product_header => 'Producte desconegut';

  @override
  String get carousel_unknown_product_title =>
      'Felicitats!\nHas trobat __la joia rara!__';

  @override
  String get carousel_unknown_product_text =>
      'La nostra base de dades col·laborativa conté més de **3 milions de productes**, però aquest codi de barres no existeix: ';

  @override
  String get carousel_unknown_product_button => 'Afegir aquest producte';

  @override
  String get carousel_loading_header => 'S\'està carregant la informació...';

  @override
  String get carousel_loading_title =>
      'Acabes d\'escanejar un producte amb el següent codi de barres:';

  @override
  String get carousel_loading_text =>
      'Ho estem buscant a la nostra base de dades de més de **3 milions de productes!**';

  @override
  String get product_type_subtitle_food =>
      'Verdures, fruites, aliments congelats…';

  @override
  String get product_type_subtitle_beauty =>
      'Maquillatge, sabons, pastes de dents…';

  @override
  String get product_type_subtitle_pet_food => 'Menjar per a gossos, gats…';

  @override
  String get product_type_subtitle_product => 'Telèfons intel·ligents, mobles…';

  @override
  String get photo_field_front => 'Foto del producte';

  @override
  String get photo_field_ingredients => 'Foto dels ingredients';

  @override
  String get photo_field_nutrition => 'Foto de nutrició';

  @override
  String get photo_field_packaging =>
      'Foto d\'instruccions sobre el reciclatge';

  @override
  String get photo_already_exists => 'Aquesta foto ja existeix';

  @override
  String get photo_missing => 'Falta aquesta foto';

  @override
  String get date => 'Data';

  @override
  String get photo_rotate_left => 'Gira a l\'\'esquerra';

  @override
  String get photo_rotate_right => 'Gira a la dreta';

  @override
  String get photo_undo_action => 'Desfer l\'acció anterior';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Un mapa del món de $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Col·laboradors d\'OpenStreetMap';

  @override
  String get not_applicable_short => 'N/A';

  @override
  String get knowledge_panel_warning_text => 'Avís';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Per què aquesta Nutri-Score és diferent de la que apareix a l\'envàs?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Hi ha dues explicacions possibles:\nLa llista d\'ingredients i/o la informació nutricional no estan actualitzades.\n\nUs proporcionem el \"Nou càlcul\" del Nutri-Score (o V2). Comproveu que tingueu el bàner \"Nou càlcul\" a l\'envàs.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Comprova els ingredients';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Consulta la informació nutricional';

  @override
  String url_not_supported(String url) {
    return 'Malauradament, no podem obrir l\'URL:\n$url';
  }

  @override
  String get product_list_export => 'Exporta';

  @override
  String get product_list_import => 'Importa';

  @override
  String get product_footer_action_barcode => 'Veure codi de barres';

  @override
  String get product_footer_action_barcode_short => 'Codi de barres';

  @override
  String get product_footer_action_open_website => 'Obre el lloc web';

  @override
  String get product_footer_action_report => 'Informe';

  @override
  String get product_footer_action_contributor_guide => 'Ajuda';

  @override
  String get product_footer_action_data_quality_tags => 'Qualitat de les dades';

  @override
  String get product_page_tab_for_me => 'Per a mi';

  @override
  String get product_page_tab_website => 'Lloc web';

  @override
  String get product_page_tab_prices => 'Preus';

  @override
  String get prices_explanation_card_title => 'Per què els preus?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** és un projecte per recopilar i compartir preus de productes d\'arreu del món 🌍. Open Prices està desenvolupat i mantingut per Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Saber-ne més';

  @override
  String get product_page_tab_folksonomy => 'Folksonomia';

  @override
  String get folksonomy_explanation_card_title =>
      'Quins són els atributs de la folksonomia?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Els atributs es basen en **valor-clau**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Aquestes propietats són creades i arxivades pels col·laboradors per a qualsevol tipus d\'ús.';

  @override
  String get folksonomy_action_external_link_title => 'Obre l\'enllaç extern';

  @override
  String get folksonomy_action_external_link_warning =>
      'Els enllaços externs poden ser perillosos. De veritat que els voleu visitar?';

  @override
  String get prices_products_empty_title => 'No hi ha preu disponible';

  @override
  String get prices_products_empty_explanation =>
      'Sigues el primer a contribuir!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Productes principals $pageSize (total: $total)';
  }

  @override
  String get app_review_title => 'Estàs gaudint d\'aquesta aplicació?';

  @override
  String get app_review_low => 'Podria fer-ho millor';

  @override
  String get app_review_medium => 'No està malament';

  @override
  String get app_review_high => 'M\'encanta!';

  @override
  String get app_review_feedback_modal_title =>
      'Ajuda\'ns a millorar la nostra aplicació';

  @override
  String get app_review_feedback_modal_content =>
      'Si tens uns minuts, podries respondre aquest formulari perquè **puguem millorar en futures actualitzacions**:';

  @override
  String get app_review_feedback_modal_open_form => 'Respon el formulari';

  @override
  String get app_review_feedback_modal_later => 'Pregunta-m\'ho després';

  @override
  String get nutrition_facts_extract_new =>
      'NOU: Pots extreure automàticament els nutrients de la imatge!';

  @override
  String get nutrition_facts_extract_button_text => 'Extreu ara';

  @override
  String get nutrition_facts_extract_in_progress => 'Extracció en curs…';

  @override
  String get nutrition_facts_extract_successful => 'Extracció correcta';

  @override
  String get nutrition_facts_extract_failed =>
      'No s\'han pogut extreure els nutrients de la imatge';

  @override
  String get prices_discount => 'Descompte';

  @override
  String get prices_stats_statistics => 'Estadístiques';

  @override
  String get prices_stats_title => 'Estadístiques de preus';

  @override
  String get prices_stats_prices_section => 'Preus';

  @override
  String get prices_stats_products_section => 'Productes';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contribuents';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Miscel·lània';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consum';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Menjar';

  @override
  String get prices_stats_beauty => 'Bellesa';

  @override
  String get prices_stats_products => 'Productes';

  @override
  String get prices_stats_pet_food => 'Menjar per a mascotes';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Països';

  @override
  String get prices_stats_price_tag => 'Etiqueta de preu';

  @override
  String get prices_stats_receipt => 'Rebut';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Lloc web';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Altres';

  @override
  String get prices_stats_last_updated => 'Última actualització el';

  @override
  String get prices_stats_error =>
      'S\'ha produït un error en carregar les estadístiques.';

  @override
  String get product_edit_robotoff_question_answered => 'Pregunta resposta!';

  @override
  String get product_edit_robotoff_proof => 'Prova';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'Preus';

  @override
  String get preferences_prices_subtitle =>
      'Gestiona les teves preferències de preus';

  @override
  String get preferences_card_project => 'El projecte Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribuir';

  @override
  String get preferences_my_contributions_title => 'Les meves aportacions';

  @override
  String get preferences_my_stats_title => 'Les meves estadístiques';

  @override
  String get preferences_contribute_subtitle =>
      'Tradueix, millora les nostres eines…';

  @override
  String get preferences_connect_title => 'Connecta';

  @override
  String get preferences_connect_subtitle =>
      'Contacta\'ns o segueix-nos a les xarxes socials';

  @override
  String get preferences_support_title => 'Fes una donació';

  @override
  String get preferences_support_subtitle =>
      'Ajudeu-nos a informar milions de consumidors arreu del món';

  @override
  String get preferences_card_help => 'Ajuda i assistència';

  @override
  String get preferences_faq_title => 'PMF';

  @override
  String get preferences_faq_subtitle =>
      'Obtén respostes a les teves preguntes';

  @override
  String get logged_out => 'Sessió tancada';

  @override
  String get preferences_app_bar_message =>
      'Gràcies per ser un dels nostres membres!';

  @override
  String get preferences_app_bar_products_modified => 'Productes modificats';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats =>
      'Veure totes les estadístiques';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Cerca $provider per \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Cerca una configuració (per exemple, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Accessibilitat: Mostra emojis';

  @override
  String get preferences_accessibility_remove_colors =>
      'Accessibilitat: Elimina els colors';

  @override
  String get preferences_app_settings_products => 'Productes';

  @override
  String get preferences_card_about => 'Quant a';

  @override
  String get preferences_legal_information_title => 'Informació legal';

  @override
  String get preferences_legal_information_subtitle =>
      'Condicions d\'ús, política de privadesa i més';

  @override
  String get preferences_terms_of_use => 'Condicions d\'ús';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts és una base de dades de productes alimentaris **feta per tothom, per a tothom**.\nLa podeu utilitzar per prendre millors decisions alimentàries i, com que són **dades obertes**, tothom la pot **reutilitzar per a qualsevol propòsit**.';

  @override
  String get preferences_privacy_policy => 'Política de privacitat';

  @override
  String get preferences_licenses => 'Llicències';

  @override
  String get preferences_about_app_title => 'Sobre l\'aplicació';

  @override
  String get preferences_about_app_subtitle =>
      'Informació tècnica, informació per a desenvolupadors i més';

  @override
  String get preferences_card_information => 'Informació';

  @override
  String get preferences_version_number_title => 'Número de versió';

  @override
  String get preferences_scanner_title => 'Escàner';

  @override
  String get preferences_app_store => 'Botiga d\'aplicacions';

  @override
  String get preferences_app_system_settings => 'Configuració del sistema';

  @override
  String get preferences_source_code => 'Accedir al codi font';

  @override
  String get preferences_source_code_subtitle =>
      'I comença a tenir un impacte per a milions de persones';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Expliqueu-ho al món';

  @override
  String get preferences_tips => 'Consells';

  @override
  String get tips_discover_nutriscore => 'Descobreix el nou Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Al lloc web Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Gestiona el meu compte';

  @override
  String get preferences_manage_account_tooltip => 'Gestiona el teu compte';

  @override
  String get preferences_change_password_title => 'Canvia la meva contrasenya';

  @override
  String get preferences_danger_zone => 'Zona de perill';

  @override
  String get preferences_account_deletion_subtitle =>
      'Totes les teves contribucions es perdran';

  @override
  String get preferences_contributions_title => 'Aportacions';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Configuració de l\'aplicació';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Una manera molt experimental d\'escanejar productes fora de línia';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Actualitza tots els productes del servidor';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Si us plau, eviteu fer això si no és absolutament necessari.';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Mode de demostració';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Afegir targetes a l\'escàner';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Afegeix 3 productes de mostra a l\'escàner';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Amfitrió de folksonomia';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Amfitrió: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Experiments d\'accessibilitat';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Selecció de diversos productes per preus';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Panells de coneixement ordenats per l\'usuari';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Accés temporal a la cerca d\'ubicacions';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Comparació paral·lela de 2 o 3 productes';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Importació de la llista de productes';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Puntuacions i metodologies';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Descobreix com es calcula el Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Descobreix els principals canvis en la metodologia';

  @override
  String get preferences_faq_discover_project_title => 'Descobreix el projecte';

  @override
  String get preferences_faq_discover_off_title =>
      'Descobreix els fets sobre menjar obert';

  @override
  String get preferences_faq_discover_obf_title =>
      'Descobreix els fets de bellesa oberts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Descobreix els fets sobre aliments per a mascotes oberts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Descobreix els productes oberts Dades';

  @override
  String get preferences_faq_faq_title => 'Preguntes freqüents';

  @override
  String get preferences_faq_off_ngo_title => 'L\'ONG Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informació';

  @override
  String get preferences_connect_community_updates_title =>
      'Rep actualitzacions de la comunitat';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Estigues al dia de les notícies de l\'aplicació i la comunitat';

  @override
  String get preferences_connect_community_calendar_title =>
      'Subscriu-te al calendari de la nostra comunitat';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Participa assistint a un dels nostres esdeveniments virtuals';

  @override
  String get preferences_connect_blog_title => 'El blog Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Rep les darreres notícies a mesura que es produeixen';

  @override
  String get preferences_connect_community_help_title =>
      'Obtén ajuda de la comunitat';

  @override
  String get preferences_connect_improve_app_title =>
      'Ajuda\'ns a millorar l\'aplicació';

  @override
  String get preferences_connect_debug_info_title =>
      'Envia\'ns informació de depuració';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Envieu-nos un correu electrònic amb informació detallada de depuració';

  @override
  String get preferences_connect_feedback_title =>
      'Envia\'ns comentaris sobre l\'aplicació';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Ajuda a donar forma al futur de l\'aplicació';

  @override
  String get preferences_connect_survey_title =>
      'Respon l\'enquesta de l\'aplicació';

  @override
  String get preferences_connect_survey_subtitle =>
      'Ajuda\'ns a entendre què hem de construir a continuació';

  @override
  String get preferences_connect_professionals_title => 'Professionals';

  @override
  String get preferences_connect_pro_subtitle =>
      'Totalment gratuït, garanteix dades precises per a 500 aplicacions i milions de consumidors. Autoservei, compatible amb el vostre PIM o fulls de càlcul (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Poseu-vos en contacte per començar';

  @override
  String get preferences_connect_press_title => 'Premsa';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Obtén tot el material que necessites per al teu informe';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Poseu-vos en contacte amb nosaltres per a consultes de premsa o per informar-nos sobre el vostre informe';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Fes-te voluntari/ària actiu/va';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Desenvolupament, Comunicació, Disseny… qualsevol tipus de voluntariat o experiència és benvinguda!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Descobreix algunes de les moltes maneres en què pots contribuir';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Desenvolupament d\'aplicacions mòbils';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Aprèn a contribuir al desenvolupament de programari';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Compilacions inestables diàries, funcions completament noves';

  @override
  String get preferences_contribute_local_community_title =>
      'Fes créixer la teva comunitat local';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Ajuda amb programari, continguts, traduccions d\'anàlisi d\'ingredients';

  @override
  String get preferences_contribute_share_subtitle =>
      'Hem preparat una petita plantilla per ajudar-vos :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Passos senzills per augmentar la transparència alimentària al vostre país';

  @override
  String get preferences_contribute_data_quality_title =>
      'Qualitat de les dades';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Uneix-te a l\'equip de qualitat de dades';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Uneix-te al nostre esforç per garantir que la base de dades sigui completa i precisa';

  @override
  String get preferences_contributions_products_added_title =>
      'Productes afegits';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nous productes que he afegit a Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Productes que he de completar';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Tots els productes incomplets';

  @override
  String get preferences_my_contributions_prices_title => 'Preus';

  @override
  String get preferences_my_contributions_my_prices_title => 'Els meus preus';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Els meus preus, les meves proves…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Productes que pots ajudar a completar';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Ajuda a calcular el Nutri-Score i el Green-Score al teu país';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Preus que vaig aportar';

  @override
  String get preferences_prices_proofs_subtitle => 'Etiquetes de preu i rebuts';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Fes fotos dels teus rebuts i escaneja els codis de barres associats';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Fes fotos dels preus en una botiga';

  @override
  String get preferences_prices_newest_title => 'Preus més nous';

  @override
  String get preferences_prices_newest_subtitle =>
      'Últims preus afegits per la comunitat Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Contribuents amb més preus';

  @override
  String get preferences_prices_metrics_title =>
      'Mètriques de preu d\'obertura';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Segueix l\'evolució del projecte';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Maneres de contribuir';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Confirma els preus afegits per tu mateix o per altres persones, amb l\'ajuda de la IA';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Afegeix ràpidament molts rebuts o fotos de prestatges del teu carret de càmera';

  @override
  String get preferences_prices_challenges_title => 'Reptes mensuals';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Participa en missions temàtiques mensuals per aconseguir preus.';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Reclama les teves dades de fidelització';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Aprèn com sol·licitar les teves dades';

  @override
  String get preferences_page_customize_app_title =>
      'Personalitza l\'aplicació';

  @override
  String get preferences_page_contribute_project_title =>
      'Contribueix al projecte';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Maneres senzilles d\'ajudar a Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodologies de puntuació, ajuda i més informació sobre el projecte';

  @override
  String get product_edit_robotoff_positive_button => 'Accepta el suggeriment';

  @override
  String get product_edit_robotoff_negative_button => 'Rebutja el suggeriment';

  @override
  String get product_edit_robotoff_show_proof => 'Mostrar proves';

  @override
  String get product_edit_robotoff_expand_proof => 'Ampliar la prova';

  @override
  String get product_page_tab_raw_data => 'Dades en brut';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Pàgina $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Pàgina $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count de $total elements';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count de $total elements';
  }

  @override
  String item_count(int count) {
    return '$count elements';
  }

  @override
  String item_count_string(String count) {
    return '$count elements';
  }

  @override
  String get prices_no_result => 'No s\'han trobat estadístiques de preus.';

  @override
  String get prices_error_loading_more_items =>
      'S\'ha produït un error en carregar més elements';

  @override
  String get prices_proof_error =>
      'L\'autenticació ha fallat, no s\'han pogut obtenir proves';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count de $total proves';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count de $total col·laboradors';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count de $total ubicacions';
  }

  @override
  String prices_locations_count(int count) {
    return '$count ubicacions';
  }

  @override
  String get restart_to_apply_message =>
      'Reinicieu l\'aplicació per aplicar els canvis.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Interfície gràfica';

  @override
  String get preferences_app_settings_media_title => 'Mitjans de comunicació';

  @override
  String get preferences_about_app_development_title => 'Desenvolupament';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Laboratoris oberts d\'informació sobre aliments';

  @override
  String get preferences_root_account_title => 'Compte';

  @override
  String get preferences_contribute_translate_header =>
      'Porta Open Food Facts al teu idioma';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Inscriu-te a la versió alfa de l\'aplicació';

  @override
  String get preferences_dev_mode_section_data =>
      'Contribucions i dades de producte';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'No mostrar folksonomia';

  @override
  String get preferences_account_title => 'Compte';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Afegit a $created';
  }

  @override
  String get location_map_details_title => 'Detalls de la ubicació';

  @override
  String get location_map_details_name => 'Nom';

  @override
  String get location_map_details_street => 'Carrer';

  @override
  String get location_map_details_city => 'Ciutat';

  @override
  String get location_map_details_postcode => 'Codi postal';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Coordenades';

  @override
  String get location_map_details_osm_id => 'ID d\'OSM';
}
