// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Bengali Bangla (`bn`).
class AppLocalizationsBn extends AppLocalizations {
  AppLocalizationsBn([String locale = 'bn']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'হ্যাঁ';

  @override
  String get add => 'যোগ';

  @override
  String get account_delete_message =>
      'আপনি কি নিশ্চিত যে আপনি আপনার অ্যাকাউন্টটি মুছে ফেলতে চান?\nযদি কোনও নির্দিষ্ট কারণ থাকে, তাহলে দয়া করে নীচে শেয়ার করুন';

  @override
  String get reason => 'কারণ';

  @override
  String get okay => 'ওকে';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'তৈরি করুন';

  @override
  String get applyButtonText => 'এ্যাপ্লাই করুন';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'চালিয়ে যান';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'উপরে ফিরে যান';

  @override
  String get save => 'সংরক্ষণ করুন';

  @override
  String get save_confirmation => 'আপনি সেভ করতে চান?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Cancel';

  @override
  String get ignore => 'উপেক্ষা করুন';

  @override
  String get close => 'বন্ধ করুন';

  @override
  String get no => 'না';

  @override
  String get stop => 'স্টপ';

  @override
  String get finish => 'শেষ';

  @override
  String get calculate => 'গণনা করুন';

  @override
  String get reset_food_prefs => 'খাবারের পছন্দ তালিকা পুনরায় নির্বাচন করুন';

  @override
  String get error => 'কিছু সমস্যা হয়েছে।';

  @override
  String get error_occurred => 'কোথাও একটি ভুল হয়েছে';

  @override
  String get featureInProgress =>
      'আমরা এই ফিচারটি নিয়ে এখনো কাজ করছি, সাথেই থাকুন';

  @override
  String get label_web => 'আমাদের ওয়েবসাইটে দেখুন';

  @override
  String get learnMore => 'আরও জানুন';

  @override
  String get unknown => 'অজানা';

  @override
  String get match_very_good => 'খুব ভালো মিল।';

  @override
  String get match_good => 'ভালো মিল।';

  @override
  String get match_poor => 'খারাপ মিল';

  @override
  String get match_may_not => 'মিল নাও হতে পারে';

  @override
  String get match_does_not => 'মেলে না।';

  @override
  String get match_unknown => 'অজানা মিল';

  @override
  String get match_short_very_good => 'খুব ভালো মিল।';

  @override
  String get match_short_good => 'ভালো মিল।';

  @override
  String get match_short_poor => 'খারাপ মিল';

  @override
  String get match_short_may_not => 'মিল নাও হতে পারে';

  @override
  String get match_short_does_not => 'মেলে না।';

  @override
  String get match_short_unknown => 'অজানা মিল';

  @override
  String get licenses => 'লাইসেন্স';

  @override
  String get looking_for => 'আমি খুঁজছি';

  @override
  String get welcomeToOpenFoodFacts => 'ওপেন ফুড ফ্যাক্টসে আপনাকে স্বাগতম';

  @override
  String get whatIsOff =>
      'ওপেন ফুড ফ্যাক্টস স্থানীয় সম্প্রদায় দ্বারা পরিচালিত একটি বিশ্বব্যাপী অলাভজনক প্রতিষ্ঠান।';

  @override
  String get productDataUtility =>
      'আপনার পছন্দসই খাবার সংশ্লিষ্ট তথ্যাবলি দেখুন।';

  @override
  String get healthCardUtility => 'আপনার জন্য ভালো খাবার পছন্দ করুন।';

  @override
  String get ecoCardUtility => 'এমন খাবার বাছাই করুন যা পৃথিবীর জন্যও উপকারি।';

  @override
  String get server_error_open_new_issue =>
      'সার্ভারের কোনও প্রতিক্রিয়া নেই! আপনি নিম্নলিখিত লিঙ্কটি ব্যবহার করে একটি সমস্যা খুলতে পারেন।';

  @override
  String get sign_in_text =>
      'আপনার অবদান সংরক্ষণ করতে আপনার ওপেন ফুড ফ্যাক্টস অ্যাকাউন্টে সাইন ইন করুন।';

  @override
  String get incorrect_credentials =>
      'আপনি ভুল ইউজারনেম অথবা পাসওয়ার্ড দিয়েছেন।';

  @override
  String get password_lost_incorrect_credentials =>
      'এই ইমেল বা ব্যবহারকারীর নামটি বিদ্যমান নেই। অনুগ্রহ করে আপনার শংসাপত্রগুলি পরীক্ষা করুন।';

  @override
  String get password_lost_server_unavailable =>
      'আমাদের সার্ভারে বর্তমানে স্লোডাউন হচ্ছে এবং এর জন্য আমরা ক্ষমাপ্রার্থী। অনুগ্রহ করে পরে আবার চেষ্টা করুন।';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable =>
      'নেটওয়ার্কটি পৌঁছানো যাচ্ছে না';

  @override
  String get login_result_type_server_issue =>
      'সার্ভারে সমস্যা। পরে চেষ্টা করুন।';

  @override
  String get login_page_username_or_email =>
      'অনুগ্রহ করে আপনার ইউজারনেম অথবা ইমেল লিখুন।';

  @override
  String get login_page_password_error_empty =>
      'দয়া করে একটি পাসওয়ার্ড লিখুন।';

  @override
  String get create_account => 'অ্যাকাউন্ট তৈরি করুন';

  @override
  String get sign_in => 'সাইন ইন';

  @override
  String get sign_in_mandatory =>
      'এই বৈশিষ্ট্যটির জন্য আপনাকে সাইন ইন করতে হবে।';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'সাইন আউট করুন';

  @override
  String get sign_out_confirmation =>
      'আপনি কি নিশ্চিত যে আপনি লগ-আউট করতে চান?';

  @override
  String get password => 'পাসওয়ার্ড';

  @override
  String get forgot_password => 'পাসওয়ার্ড ভুলে গেছেন?';

  @override
  String get forgot_password_question => 'পাসওয়ার্ড ভুলে গেছেন?';

  @override
  String get view_profile => 'আপনার প্রোফাইল দেখুন';

  @override
  String get reset_password => 'পাসওয়ার্ড রিসেট করুন';

  @override
  String get reset_password_explanation_text =>
      'পাসওয়ার্ড ভুলে গেলে, পাসওয়ার্ড রিসেট করার নির্দেশাবলী পেতে আপনার ব্যবহারকারীর নাম বা ইমেল ঠিকানা লিখুন। এছাড়াও, স্প্যাম ফোল্ডারটি পরীক্ষা করতে ভুলবেন না।';

  @override
  String get username_or_email => 'ব্যবহারকারীর নাম অথবা ই-মেইল';

  @override
  String get reset_password_done =>
      'আপনার অ্যাকাউন্টের সাথে সম্পর্কিত ইমেল ঠিকানায় আপনার পাসওয়ার্ড রিসেট করার লিঙ্ক সহ একটি ইমেল পাঠানো হয়েছে। আপনার স্প্যামও পরীক্ষা করুন।';

  @override
  String get send_reset_password_mail => 'পাসওয়ার্ড পরিবর্তন করুন';

  @override
  String get enter_some_text => 'দয়া করে কিছু লেখা লিখুন।';

  @override
  String get sign_up_page_title => 'নিবন্ধন করুন';

  @override
  String get sign_up_page_action_button => 'নিবন্ধন করুন';

  @override
  String get sign_up_page_action_doing_it => 'সাইন আপ করা হচ্ছে…';

  @override
  String get sign_up_page_action_ok =>
      'অভিনন্দন! আপনার অ্যাকাউন্ট তৈরি হয়েছে।';

  @override
  String get sign_up_page_display_name_hint => 'নাম';

  @override
  String get sign_up_page_display_name_error_empty =>
      'আপনি যে প্রদর্শন নামটি ব্যবহার করতে চান তা লিখুন।';

  @override
  String get sign_up_page_email_hint => 'ই-মেইল';

  @override
  String get sign_up_page_email_error_empty => 'ই-মেইল প্রয়োজন।';

  @override
  String get sign_up_page_email_error_invalid => 'অবৈধ ই-মেইল';

  @override
  String get sign_up_page_username_hint =>
      'ব্যবহারকারীর নাম: সর্বজনীনভাবে দৃশ্যমান';

  @override
  String get sign_up_page_username_error_empty =>
      'অনুগ্রহ করে একটি ব্যবহারকারীর নাম লিখুন।';

  @override
  String get sign_up_page_username_error_invalid =>
      'দয়া করে একটি বৈধ ব্যবহারকারীর নাম লিখুন।';

  @override
  String get sign_up_page_username_description =>
      'ব্যবহারকারীর নামে স্পেস, ক্যাপ বা বিশেষ অক্ষর থাকতে পারে না।';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'ব্যবহারকারীর নাম $value অক্ষরের বেশি হতে পারবে না';
  }

  @override
  String get sign_up_page_password_hint => 'পাসওয়ার্ড';

  @override
  String get sign_up_page_password_error_empty =>
      'দয়া করে একটি পাসওয়ার্ড লিখুন।';

  @override
  String get sign_up_page_password_error_invalid =>
      'দয়া করে একটি বৈধ পাসওয়ার্ড লিখুন (কমপক্ষে ৬ অক্ষর)';

  @override
  String get sign_up_page_confirm_password_hint => 'পাসওয়ার্ড নিশ্চিত করুন';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'দয়া করে পাসওয়ার্ডটি নিশ্চিত করুন।';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'পাসওয়ার্ড মিলছে না।';

  @override
  String get sign_up_page_agree_text => 'আমি ওপেন ফুড ফ্যাক্টসের সাথে একমত।';

  @override
  String get sign_up_page_terms_text => 'ব্যবহারের শর্তাবলী এবং অবদান';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'অ্যাকাউন্ট তৈরি করার সময়, ব্যবহারের শর্তাবলীতে সম্মত হওয়া বাধ্যতামূলক, তবে, অ্যাপের মাধ্যমে বেনামী অবদান এখনও করা যেতে পারে।';

  @override
  String get sign_up_page_producer_checkbox => 'আমি একজন খাদ্য উৎপাদক।';

  @override
  String get sign_up_page_producer_hint => 'প্রযোজক/ব্র্যান্ড';

  @override
  String get sign_up_page_producer_error_empty =>
      'অনুগ্রহ করে একটি প্রযোজক বা একটি ব্র্যান্ডের নাম লিখুন।';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'আমি ওপেন ফুড ফ্যাক্টস নিউজলেটার সাবস্ক্রাইব করতে চাই (আপনি যেকোনো সময় এটি থেকে সদস্যতা ত্যাগ করতে পারেন)';

  @override
  String get sign_up_page_user_name_already_used =>
      'ব্যবহারকারীর নামটি ইতিমধ্যেই বিদ্যমান, অনুগ্রহ করে অন্য একটি ব্যবহারকারীর নাম বেছে নিন।';

  @override
  String get sign_up_page_email_already_exists =>
      'ইতিমধ্যেই বিদ্যমান, অ্যাকাউন্টে লগইন করুন অথবা অন্য ইমেল দিয়ে চেষ্টা করুন।';

  @override
  String get sign_up_page_provide_valid_email =>
      'অনুগ্রহ করে একটি বৈধ ইমেল ঠিকানা প্রদান করুন।';

  @override
  String get sign_up_page_server_busy =>
      'আমরা আন্তরিকভাবে দুঃখিত, আপনার অ্যাকাউন্ট তৈরি করতে আমাদের কিছু প্রযুক্তিগত সমস্যা হচ্ছে। অনুগ্রহ করে পরে আবার চেষ্টা করুন।';

  @override
  String get settingsTitle => 'সেটিংস';

  @override
  String get darkmode => 'থিম';

  @override
  String get darkmode_dark => 'অন্ধকার';

  @override
  String get darkmode_light => 'আলো';

  @override
  String get darkmode_system_default => 'সিস্টেম ডিফল্ট';

  @override
  String get thanks_for_contributing => 'অবদান রাখার জন্য ধন্যবাদ!';

  @override
  String get contributors_label => 'তারা অ্যাপটি তৈরি করছে।';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'অবদানকারী: $name';
  }

  @override
  String get contributors_description =>
      'এই অ্যাপের সকল অবদানকারীদের একটি তালিকা';

  @override
  String get support => 'সমর্থন';

  @override
  String get support_join_slack =>
      'আমাদের স্ল্যাক চ্যানেলে সাহায্যের জন্য জিজ্ঞাসা করুন';

  @override
  String get support_via_forum => 'আমাদের ফোরামে সাহায্যের জন্য জিজ্ঞাসা করুন';

  @override
  String get support_via_email => 'আমাদের একটি ই-মেইল পাঠান';

  @override
  String get support_via_email_include_logs_dialog_title => 'অ্যাপ লগ পাঠাবেন?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'আপনি কি আপনার ইমেলের সাথে সংযুক্তিতে অ্যাপ্লিকেশন লগ অন্তর্ভুক্ত করতে চান?';

  @override
  String get termsOfUse => 'ব্যবহারের শর্তাবলী';

  @override
  String get legalNotices => 'আইনি নোটিশ';

  @override
  String get privacy_policy => 'গোপনীয়তা নীতি';

  @override
  String get about_this_app => 'এই অ্যাপ সম্পর্কে';

  @override
  String get contribute => 'সহযগীতা';

  @override
  String get contribute_sw_development => 'সফটওয়্যার ডেভেলপমেন্ট';

  @override
  String get contribute_develop_text =>
      'প্রতিটি ওপেন ফুড ফ্যাক্টস পণ্যের কোড GitHub-এ পাওয়া যায়। আপনি কোডটি পুনঃব্যবহার করতে পারেন (এটি ওপেন সোর্স) এবং এটিকে উন্নত করতে আমাদের সাহায্য করতে পারেন, সকলের জন্য, সমগ্র গ্রহের জন্য।';

  @override
  String get contribute_develop_text_2 =>
      'আপনি ওপেন ফুড ফ্যাক্টস স্ল্যাক চ্যাটরুমে যোগ দিতে পারেন যা প্রশ্ন জিজ্ঞাসা করার পছন্দের উপায়।';

  @override
  String get contribute_develop_dev_mode_title => 'DEV মোড?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'DEV মোড সক্রিয় করুন';

  @override
  String get contribute_donate_title => 'Donate';

  @override
  String get contribute_donate_header => 'খাদ্য তথ্য খুলতে দান করুন';

  @override
  String get contribute_enroll_alpha_warning =>
      'অনুগ্রহ করে স্বীকার করুন যে অভ্যন্তরীণ আলফা সংস্করণের সাথে, ডেটা সম্পূর্ণরূপে হারিয়ে যেতে পারে এবং অ্যাপটি যেকোনো সময় ব্যবহারের অযোগ্য হয়ে যেতে পারে!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'যেসব পণ্য সম্পন্ন করতে হবে';

  @override
  String get contribute_improve_header => 'উন্নতি';

  @override
  String get contribute_improve_text =>
      'ডাটাবেস হল এই প্রকল্পের মূল বিষয়। এটি সাহায্য করা সহজ এবং খুব দ্রুত। আপনি আপনার ফোনের জন্য মোবাইল অ্যাপটি ডাউনলোড করতে পারেন এবং পণ্য যোগ করা বা উন্নত করা শুরু করতে পারেন।\n\nঅন্যদিকে, ওপেন ফুড ফ্যাক্টস ওয়েবসাইট অবদান রাখার অনেক উপায় অফার করে: ';

  @override
  String get contribute_translate_header => 'অনুবাদ করুন';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'অনুবাদ শুরু করুন';

  @override
  String get contribute_translate_text =>
      'ওপেন ফুড ফ্যাক্টস একটি বিশ্বব্যাপী প্রকল্প, যেখানে ১৬০ টিরও বেশি দেশের পণ্য রয়েছে। ওপেন ফুড ফ্যাক্টস কয়েক ডজন ভাষায় অনুবাদ করা হয়, যার বিষয়বস্তু ক্রমাগত পরিবর্তিত হচ্ছে।';

  @override
  String get contribute_translate_text_2 =>
      'অনুবাদ প্রকল্পের অন্যতম প্রধান কাজ।';

  @override
  String get contribute_join_skill_pool =>
      'Contribute your skills to Open Food Facts. Join the skill pool!';

  @override
  String get contribute_share_header =>
      'আপনার বন্ধুদের সাথে খোলা খাবারের তথ্য শেয়ার করুন';

  @override
  String get contribute_share_content =>
      'আমি আপনাকে ওপেন ফুড ফ্যাক্টস অ্যাপটি সম্পর্কে জানাতে চাই, যা আপনাকে আপনার খাবারের স্বাস্থ্য এবং পরিবেশগত প্রভাবগুলি ব্যক্তিগতকৃত উপায়ে পেতে দেয়। এটি প্যাকেজিংয়ের বারকোডগুলি স্ক্যান করে কাজ করে। অবশেষে এটি বিনামূল্যে, নিবন্ধনের প্রয়োজন হয় না এবং আপনি ডিসাইফার করা পণ্যের সংখ্যা বাড়াতেও সাহায্য করতে পারেন। আপনার ফোনে এটি পেতে এখানে লিঙ্কটি রয়েছে: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'আপনার লয়্যালটি কার্ডের ডেটা GDPR এক্সপোর্টের অনুরোধ করে দাম যোগান দিন।';

  @override
  String get tap_to_answer => 'প্রশ্নের উত্তর দিতে এখানে ট্যাপ করুন';

  @override
  String get tap_to_answer_hint =>
      'এই পণ্য সম্পর্কে প্রশ্নের উত্তর দিতে এখানে ট্যাপ করুন';

  @override
  String get robotoff_questions_loading_hint =>
      'এই পণ্য সম্পর্কে প্রশ্ন লোড হওয়া পর্যন্ত অপেক্ষা করুন।';

  @override
  String get saving_answer => 'আপনার উত্তর সংরক্ষণ করা হচ্ছে';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'আপনার অবদানের জন্য ক্রেডিট পেতে আপনার ওপেন ফুড ফ্যাক্টস অ্যাকাউন্টে সাইন ইন করুন।';

  @override
  String get question_yes_button_accessibility_value => 'হ্যাঁ দিয়ে উত্তর দিন';

  @override
  String get question_no_button_accessibility_value => 'না দিয়ে উত্তর দিন';

  @override
  String get question_skip_button_accessibility_value =>
      'এই প্রশ্নটি এড়িয়ে যান';

  @override
  String get tap_to_edit_search => 'সার্চ এডিট করতে ট্যাপ করুন';

  @override
  String get myPreferences => 'আমার পছন্দগুলি';

  @override
  String get account_create_message =>
      'আপনার অ্যাকাউন্ট তৈরি করুন এবং ওপেন ফুড ফ্যাক্টস কমিউনিটিতে যোগদান করুন যাতে সারা বিশ্বে খাদ্য জ্ঞান তৈরিতে সাহায্য করতে পারেন!';

  @override
  String get join_us => 'আমাদের সাথে যোগদান করুন';

  @override
  String get myPreferences_profile_title => 'আপনার প্রোফাইল';

  @override
  String get myPreferences_profile_subtitle =>
      'আপনার ওপেন ফুড ফ্যাক্টস অবদানকারী অ্যাকাউন্ট পরিচালনা করুন।';

  @override
  String get myPreferences_settings_title => 'অ্যাপ সেটিংস';

  @override
  String get myPreferences_settings_subtitle => 'ডার্ক মোড, ভাষা…';

  @override
  String get myPreferences_food_title => 'খাবারের পছন্দ';

  @override
  String get myPreferences_food_subtitle =>
      'খাবার সম্পর্কে কোন তথ্য আপনার কাছে সবচেয়ে গুরুত্বপূর্ণ তা বেছে নিন।';

  @override
  String get myPreferences_food_comment =>
      'আপনার পছন্দ অনুসারে খাবারের র‌্যাঙ্কিং করার জন্য, খাবার সম্পর্কে কোন তথ্য আপনার কাছে সবচেয়ে গুরুত্বপূর্ণ তা বেছে নিন, প্রথমে আপনার গুরুত্বপূর্ণ তথ্য দেখুন এবং একটি সামঞ্জস্যপূর্ণ সারাংশ পান। সেই খাবারের পছন্দগুলি আপনার ডিভাইসে থাকে এবং যদি আপনার ওপেন ফুড ফ্যাক্টস অবদানকারী অ্যাকাউন্ট থাকে তবে সেগুলির সাথে সম্পর্কিত নয়।';

  @override
  String get confirmResetPreferences => 'আপনার খাবারের পছন্দগুলি রিসেট করবেন?';

  @override
  String get myPersonalizedRanking => 'আমার ব্যক্তিগতকৃত র‍্যাঙ্কিং';

  @override
  String get ranking_tab_all => 'All';

  @override
  String get ranking_subtitle_match_yes => 'তোমার জন্য দারুন একটা ম্যাচ';

  @override
  String get ranking_subtitle_match_no => 'খুব খারাপ ম্যাচ';

  @override
  String get ranking_subtitle_match_maybe => 'অজানা মিল';

  @override
  String get refresh_with_new_preferences =>
      'আপনার নতুন পছন্দগুলি দিয়ে তালিকাটি রিফ্রেশ করুন';

  @override
  String get reloaded_with_new_preferences =>
      'আপনার নতুন পছন্দগুলি সহ পুনরায় লোড করা হয়েছে';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'স্ক্যান';

  @override
  String get history_navbar_label => 'ইতিহাস';

  @override
  String get list_navbar_label => 'তালিকা';

  @override
  String get category => 'বিভাগ অনুসারে ফিল্টার করুন';

  @override
  String get category_all => 'All';

  @override
  String get category_search => '(বিভাগ অনুসন্ধান)';

  @override
  String get filter => 'ফিল্টার';

  @override
  String get scan => 'স্ক্যান স্ক্রিন থেকে পণ্যগুলি';

  @override
  String get scan_history => 'স্ক্যান ইতিহাস';

  @override
  String get search => 'অনুসন্ধান';

  @override
  String get search_product_help =>
      'একটি পণ্য,\nএকটি ব্র্যান্ড বা বারকোড খুঁজুন';

  @override
  String get search_filter => 'অনুসন্ধান ফিল্টার';

  @override
  String get search_history => 'অনুসন্ধানের ইতিহাস';

  @override
  String get search_store => 'একটি দোকান খুঁজুন';

  @override
  String get search_store_help => 'ইঙ্গিত: শহর বা দেশ যোগ করুন';

  @override
  String get tap_for_more => 'আরও তথ্য দেখতে ট্যাপ করুন…';

  @override
  String get product => 'Product';

  @override
  String get unknownBrand => 'অজানা ব্র্যান্ড';

  @override
  String get unknownQuantity => 'অজানা পরিমাণ';

  @override
  String get unknownProductName => 'অজানা পণ্যের নাম';

  @override
  String get label_refresh => 'Refresh';

  @override
  String get label_reload => 'পুনরায় লোড করুন';

  @override
  String get image => 'ভাবমূর্তি';

  @override
  String get front_photo => 'সামনের ছবি';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (এই ছবিটি পুরনো হতে পারে)';
  }

  @override
  String get outdated_image_short_label => 'পুরনো হতে পারে';

  @override
  String get ingredients => 'উপকরণসমূহ';

  @override
  String get ingredients_editing_instructions =>
      'মূল ক্রমটি বজায় রাখুন। নির্দিষ্ট করা থাকলে শতাংশটি নির্দেশ করুন। একটি কমা বা হাইফেন দিয়ে আলাদা করুন এবং একটি উপাদানের উপাদানগুলির জন্য বন্ধনী ব্যবহার করুন।';

  @override
  String get ingredients_editing_error => 'উপকরণগুলি সংরক্ষণ করা যায়নি।';

  @override
  String get ingredients_editing_image_error =>
      'নতুন উপাদানের ছবি পাওয়া যায়নি।';

  @override
  String get ingredients_editing_title => 'উপকরণ সম্পাদনা করুন';

  @override
  String get ingredients_photo => 'উপকরণের ছবি';

  @override
  String get packaging_editing_instructions =>
      'কমা বা লাইন ফিড দ্বারা পৃথক করা সমস্ত প্যাকেজিং যন্ত্রাংশের তালিকা তৈরি করুন, তাদের পরিমাণ (যেমন 1 বা 6) প্রকার (যেমন বোতল, বাক্স, ক্যান), উপাদান (যেমন প্লাস্টিক, ধাতু, অ্যালুমিনিয়াম) এবং যদি পাওয়া যায় তবে তাদের আকার (যেমন 33cl) এবং পুনর্ব্যবহারের নির্দেশাবলী সহ।\nউদাহরণ: পুনর্ব্যবহারের জন্য 1টি কাচের বোতল, ফেলে দেওয়ার জন্য 1টি প্লাস্টিকের কর্ক';

  @override
  String get packaging_editing_error => 'প্যাকেজিং সংরক্ষণ করা যায়নি।';

  @override
  String get packaging_editing_image_error =>
      'নতুন প্যাকেজিং ছবি পাওয়া যায়নি।';

  @override
  String get packaging_editing_title => 'প্যাকেজিং সম্পাদনা করুন';

  @override
  String get nutrition => 'পুষ্টি উপাদান';

  @override
  String get nutrition_facts_photo => 'পুষ্টির তথ্যের ছবি';

  @override
  String get nutrition_facts_editing_title => 'পুষ্টির তথ্য সম্পাদনা করুন';

  @override
  String get packaging_information => 'পুনর্ব্যবহারের নির্দেশাবলী';

  @override
  String get packaging_information_photo => 'পুনর্ব্যবহারের নির্দেশাবলীর ছবি';

  @override
  String get missing_product => 'তুমি একটি নতুন পণ্য খুঁজে পেয়েছ!';

  @override
  String get add_product_take_photos =>
      'এই পণ্যটি Open Food Facts-এ যোগ করতে প্যাকেজিংয়ের ছবি তুলুন।';

  @override
  String get add_product_take_photos_descriptive =>
      'প্রথমে কিছু ছবি তুলুন। আপনি পরে যেকোনো সময় পণ্যটি সম্পূর্ণ করতে পারেন।';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'নতুন পণ্য';

  @override
  String get new_product_found_title => 'নতুন পণ্য পাওয়া গেছে!';

  @override
  String get new_product_found_text =>
      'আমাদের সহযোগী ডাটাবেসে **৩০ লক্ষেরও বেশি পণ্য** রয়েছে, কিন্তু এই বারকোডটি বিদ্যমান নেই: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'এই পৃষ্ঠাটি ছেড়ে যাবেন?';

  @override
  String get new_product_leave_message =>
      'মনে হচ্ছে আপনি কিছুই ইনপুট করেননি। আপনি কি সত্যিই এই পৃষ্ঠাটি ছেড়ে যেতে চান?';

  @override
  String get new_product_dialog_description =>
      'আমাদের সাধারণ ডাটাবেসে এই পণ্যটি যোগ করতে দয়া করে প্যাকেজিংয়ের ছবি তুলুন।';

  @override
  String get new_product_dialog_illustration_description =>
      'অজানা Nutri-Score এবং গ্রিন স্কোরের একটি চিত্র';

  @override
  String get front_packaging_photo_button_label => 'সামনের প্যাকেজিং ছবি';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'সামনের প্যাকেজিংয়ের ছবি আপলোড নিশ্চিত করুন';

  @override
  String get confirm_button_label => 'নিশ্চিত করুন';

  @override
  String get send_image_button_label => 'ছবি পাঠান';

  @override
  String get crop_page_action_saving => 'ছবিটি সংরক্ষণ করা হচ্ছে…';

  @override
  String get crop_page_action_cropping => 'ছবি কাটছাঁট করা হচ্ছে…';

  @override
  String get crop_page_action_local => 'স্থানীয় সংস্করণ সংরক্ষণ করা হচ্ছে…';

  @override
  String get crop_page_action_local_failed_title =>
      'ওহো… তোমার ছবিতে কিছু একটা আছে!';

  @override
  String get crop_page_action_local_failed_message =>
      'আমাদের সার্ভারে পাঠানোর আগে আমরা ছবিটি স্থানীয়ভাবে প্রক্রিয়া করতে পারছি না। অনুগ্রহ করে পরে আবার চেষ্টা করুন অথবা সমস্যাটি যদি থেকে যায় তাহলে আমাদের সাথে যোগাযোগ করুন।';

  @override
  String get crop_page_action_retake => 'আবার ছবি তুলুন';

  @override
  String get crop_page_too_small_image_title => 'ছবিটি অনেক ছোট!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'ছবি আপলোডের জন্য পিক্সেলে সর্বনিম্ন আকার হল ${expectedMinWidth}x$expectedMinHeight। বর্তমান ছবিটি হল ${actualWidth}x$actualHeight।';
  }

  @override
  String get crop_page_action_server => 'সার্ভারে কল করার প্রস্তুতি…';

  @override
  String get front_packaging_photo_title => 'সামনের প্যাকেজিং ছবি';

  @override
  String get ingredients_photo_title => 'উপকরণ ছবি';

  @override
  String get nutritional_facts_photo_title => 'পুষ্টির তথ্য ছবি';

  @override
  String get recycling_photo_title => 'পুনর্ব্যবহারের নির্দেশাবলী ছবি';

  @override
  String get take_photo_title => 'একটি ছবি নিন';

  @override
  String get take_more_photo_title => 'আরও কিছু ছবি তুলুন';

  @override
  String get front_photo_uploaded => 'সামনের ছবি আপলোড করা হয়েছে';

  @override
  String get ingredients_photo_button_label => 'উপকরণের ছবি';

  @override
  String get ingredients_photo_uploaded => 'উপকরণের ছবি আপলোড করা হয়েছে';

  @override
  String get nutrition_cache_loading_error =>
      'ক্যাশে থেকে পুষ্টি লোড করা যাচ্ছে না';

  @override
  String get nutritional_facts_photo_button_label => 'পুষ্টির তথ্যের ছবি';

  @override
  String get nutritional_facts_input_button_label => 'পুষ্টির তথ্য পূরণ করুন';

  @override
  String get nutritional_facts_added => 'পুষ্টির তথ্য যোগ করা হয়েছে';

  @override
  String get categories_added => 'বিভাগ যোগ করা হয়েছে';

  @override
  String get new_product_title_nutriscore => 'Nutri-Score গণনা করুন';

  @override
  String get new_product_subtitle_nutriscore =>
      'অন্তত একটি বিভাগ এবং পুষ্টির মান পূরণ করে আমাদের সাহায্য করুন।';

  @override
  String get new_product_title_environmental_score => 'সবুজ স্কোর গণনা করুন';

  @override
  String get new_product_subtitle_environmental_score =>
      'অন্তত একটি বিভাগ পূরণ করে এটি পান';

  @override
  String get new_product_additional_environmental_score =>
      'উৎপত্তি, প্যাকেজিং এবং আরও অনেক কিছুর মাধ্যমে গ্রিন স্কোর গণনা আরও সুনির্দিষ্ট করুন';

  @override
  String get new_product_title_nova =>
      'খাদ্য প্রক্রিয়াকরণ স্তর গণনা করুন (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'খাদ্য বিভাগ এবং উপাদান পূরণ করে এটি পান';

  @override
  String get new_product_desc_nova_unknown =>
      'খাদ্য প্রক্রিয়াকরণের স্তর অজানা';

  @override
  String get new_product_title_pictures => 'নতুন পণ্য';

  @override
  String get new_product_title_pictures_details =>
      'Please take the following photos and the Open Food Facts engine can work out the rest!';

  @override
  String get new_product_title_misc => 'এবং কিছু মৌলিক তথ্য…';

  @override
  String new_product_done_msg(String username) {
    return 'আপনার অবদানের জন্য ধন্যবাদ “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'আপনার অবদানের জন্য ধন্যবাদ!';

  @override
  String get new_product_done_button_label => 'সম্পন্ন পণ্যটি আবিষ্কার করুন';

  @override
  String get hey_incomplete_product_message =>
      'Nutri-Score, গ্রিন স্কোর এবং আল্ট্রা-প্রসেসিং (NOVA) গণনা করতে এখনই 3টি প্রশ্নের উত্তর দিতে ট্যাপ করুন!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'এই প্রসাধনী বিশ্লেষণে সাহায্য করার জন্য ২টি প্রশ্নের উত্তর দিতে এখনই ট্যাপ করুন!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'এই পোষা প্রাণীর খাদ্য পণ্যটি বিশ্লেষণ করতে সাহায্য করার জন্য ৩টি প্রশ্নের উত্তর দিতে এখনই ট্যাপ করুন!';

  @override
  String get hey_incomplete_product_message_product =>
      'এই পণ্যটি সম্পূর্ণ করতে সাহায্য করতে এখনই ট্যাপ করুন!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'পুষ্টি তথ্যের ছবি আপলোড করা হয়েছে';

  @override
  String get recycling_photo_button_label => 'পুনর্ব্যবহারযোগ্য ছবি';

  @override
  String get recycling_photo_uploaded => 'পুনর্ব্যবহারের ছবি আপলোড করা হয়েছে';

  @override
  String get take_more_photo_button_label => 'আরও কিছু ছবি তুলুন';

  @override
  String get other_photo_uploaded => 'বিবিধ ছবি আপলোড করা হয়েছে';

  @override
  String get retake_photo_button_label => 'রিটেক';

  @override
  String get selecting_photo => 'ছবি নির্বাচন করা হচ্ছে';

  @override
  String get uploading_image => 'সার্ভারে ছবি আপলোড করা হচ্ছে';

  @override
  String get uploading_image_type_front =>
      'ওপেন ফুড ফ্যাক্টস-এ সামনের ছবিটি আপলোড করা হচ্ছে';

  @override
  String get uploading_image_type_ingredients =>
      'ওপেন ফুড ফ্যাক্টস-এ উপাদানের ছবি আপলোড করা হচ্ছে';

  @override
  String get uploading_image_type_nutrition =>
      'ওপেন ফুড ফ্যাক্টস-এ পুষ্টির ছবি আপলোড করা হচ্ছে';

  @override
  String get uploading_image_type_packaging =>
      'ওপেন ফুড ফ্যাক্টস-এ প্যাকেজিং ছবি আপলোড করা হচ্ছে';

  @override
  String get uploading_image_type_other =>
      'Open Food Facts-এ অন্য ছবি আপলোড করা হচ্ছে';

  @override
  String get uploading_image_type_generic =>
      'ওপেন ফুড ফ্যাক্টস-এ ছবি আপলোড করা হচ্ছে';

  @override
  String get score_add_missing_ingredients => 'অনুপস্থিত উপাদান যোগ করুন';

  @override
  String get score_add_missing_packaging_image =>
      'অনুপস্থিত প্যাকেজিং ছবি যোগ করুন';

  @override
  String get score_add_missing_nutrition_facts =>
      'বাদ পড়া পুষ্টির তথ্য যোগ করুন';

  @override
  String get score_add_missing_product_traces =>
      'অনুপস্থিত পণ্যের ট্রেস যোগ করুন';

  @override
  String get score_add_missing_product_category => 'একটি বিভাগ নির্বাচন করুন';

  @override
  String get score_add_missing_precise_product_category =>
      'আরও সুনির্দিষ্ট বিভাগ নির্বাচন করুন';

  @override
  String get score_add_missing_product_countries =>
      'অনুপস্থিত পণ্যের দেশগুলি যোগ করুন';

  @override
  String get score_add_missing_product_emb =>
      'অনুপস্থিত পণ্য ট্রেসেবিলিটি কোড যোগ করুন';

  @override
  String get score_add_missing_product_labels =>
      'অনুপস্থিত পণ্য লেবেল যোগ করুন';

  @override
  String get score_add_missing_product_origins =>
      'অনুপস্থিত পণ্যের উৎস যোগ করুন';

  @override
  String get score_add_missing_product_stores =>
      'অনুপস্থিত পণ্যের দোকান যোগ করুন';

  @override
  String get score_add_missing_product_brands =>
      'অনুপস্থিত পণ্য ব্র্যান্ডগুলি যোগ করুন';

  @override
  String get score_update_nutrition_facts => 'পুষ্টির তথ্য আপডেট করুন';

  @override
  String get nutrition_page_title => 'পুষ্টির তথ্য';

  @override
  String get nutrition_page_nutritional_info_title => 'পুষ্টি সংক্রান্ত তথ্য';

  @override
  String get nutrition_page_nutritional_info_label => 'পণ্যে উল্লেখিত মান:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'হ্যাঁ';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'না';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'ছবি খুলুন';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'ভালো অভ্যাস: পুষ্টি সংক্রান্ত তথ্য';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'কখনও কখনও পুষ্টির তথ্য **প্যাকেজে** অথবা পণ্যের সাথে দেওয়া কোনও নথিতে উল্লেখ করা থাকে না। এই ক্ষেত্রে, এবং শুধুমাত্র এই ক্ষেত্রে, আপনি মান **না** তে সেট করতে পারেন।';

  @override
  String get nutrition_page_serving_type_label => 'পুষ্টির মান:';

  @override
  String get nutrition_page_per_100g => 'প্রতি ১০০ গ্রাম';

  @override
  String get nutrition_page_per_100g_100ml => 'প্রতি ১০০ গ্রাম/মিলি';

  @override
  String get nutrition_page_per_serving => 'প্রতি পরিবেশনে';

  @override
  String get nutrition_page_add_nutrient => 'একটি পুষ্টি যোগ করুন';

  @override
  String get nutrition_page_serving_size => 'পরিবেশন পরিমাপ';

  @override
  String get nutrition_page_serving_size_hint =>
      'পরিবেশনের আকার লিখুন (যেমন: ১০০ গ্রাম)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'ভালো অভ্যাস: পরিবেশনের আকার';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'এই মান **প্রতি পরিবেশন আকারের প্রতিটি পুষ্টির আনুপাতিক গণনা** করতে সাহায্য করে।';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**অনুমোদিত ইউনিট** হল: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫克, 公斤, 毫克, 公斤, 毫克';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**৬০ গ্রাম**, **৬০ গ্রাম** অথবা **৬০ গ্রাম** (প্রথমটি পছন্দ করুন)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**১০০০ মিলি** অথবা **১ লিটার**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'অবৈধ ইউনিট';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '৩০ **ছোট**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'অবৈধ ইউনিট';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '৯টি **ক্যান্ডি** এবং ২টি **বিস্কুট**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'ইউনিট অনুপস্থিত';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**৩০**';

  @override
  String get nutrition_page_invalid_number => 'অবৈধ নম্বর';

  @override
  String get nutrition_page_update_running => 'সার্ভারে পণ্য আপডেট করা হচ্ছে…';

  @override
  String get nutrition_page_update_done => 'পণ্য আপডেট করা হয়েছে!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'পরিবেশনের আকার হিসেবে পণ্যের পরিমাণ ব্যবহার করুন';

  @override
  String get nutrition_page_photo_error => 'ছবি লোড করা যাচ্ছে না।';

  @override
  String get more_photos => 'আরও আকর্ষণীয় ছবি';

  @override
  String get view_more_photo_button =>
      'এই পণ্যের জন্য বিদ্যমান সমস্ত ছবি দেখুন';

  @override
  String get no_product_found => 'কোন পণ্য পাওয়া যায়নি';

  @override
  String get no_location_found => 'কোনও অবস্থান পাওয়া যায়নি';

  @override
  String get not_found => 'পাওয়া যায়নি:';

  @override
  String get refreshing_product => 'রিফ্রেশিং পণ্য';

  @override
  String get product_refreshed => 'পণ্যটি রিফ্রেশ করা হয়েছে';

  @override
  String product_image_accessibility_label(String date) {
    return 'ছবিটি $dateএ তোলা হয়েছে';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'ছবিটি $dateএ তোলা। এই ছবিটি পুরনো হতে পারে।';
  }

  @override
  String get product_image_outdated => 'এই ছবিটি পুরনো হতে পারে।';

  @override
  String get product_image_outdated_explanations_title =>
      'এই ছবিটি পুরনো হতে পারে।';

  @override
  String get product_image_outdated_explanations_content =>
      'এই ছবিটি এক বছরেরও বেশি সময় আগে তোলা হয়েছিল।\n**দয়া করে পরীক্ষা করে দেখুন এটি এখনও আপ-টু-ডেট আছে**।\n\nএটি **শুধুমাত্র একটি সতর্কতা**। যদি বিষয়বস্তু এখনও একই থাকে, তাহলে আপনি এই বার্তাটি উপেক্ষা করতে পারেন।';

  @override
  String product_image_action_replace_photo(String type) {
    return 'ছবি প্রতিস্থাপন করুন ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'একটি ছবি যোগ করুন ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'একটি ছবি নিন';

  @override
  String get product_image_action_from_gallery =>
      'আপনার ফোনের গ্যালারি থেকে নির্বাচন করুন';

  @override
  String get product_image_action_choose_existing_photo =>
      'পণ্যের ছবি থেকে নির্বাচন করুন';

  @override
  String get product_image_details_label => 'ছবি সম্পর্কে তথ্য';

  @override
  String get product_image_details_from_producer => 'প্রযোজকের কাছ থেকে';

  @override
  String get product_image_details_contributor => 'Contributor';

  @override
  String get product_image_details_contributor_producer =>
      'অবদানকারী (প্রযোজক)';

  @override
  String get product_image_details_date => 'তারিখ';

  @override
  String get product_image_details_date_unknown => 'অজানা';

  @override
  String get homepage_main_card_logo_description =>
      'ওপেন ফুড ফ্যাক্টস-এ স্বাগতম';

  @override
  String get homepage_main_card_subheading =>
      '**বারকোড স্ক্যান করুন** অথবা\nপণ্যের জন্য **অনুসন্ধান** করুন';

  @override
  String get homepage_main_card_search_field_hint => 'একটি পণ্য খুঁজুন';

  @override
  String get homepage_main_card_search_field_tooltip => 'অনুসন্ধান শুরু করুন';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'সর্বশেষ খবর: $news_title';
  }

  @override
  String get tagline_app_review => 'তুমি কি অ্যাপটি পছন্দ করো?';

  @override
  String get tagline_app_review_button_positive => 'আমি এটা ভালোবাসি! 😍';

  @override
  String get tagline_app_review_button_negative => 'আসলে তা নয়…';

  @override
  String get tagline_app_review_button_later => 'আমাকে পরে জিজ্ঞাসা করো।';

  @override
  String get tagline_feed_news_button => 'আরও জানুন';

  @override
  String get app_review_negative_modal_title =>
      'তুমি কি আমাদের অ্যাপ পছন্দ করো না?';

  @override
  String get app_review_negative_modal_text =>
      'তুমি কি কয়েক সেকেন্ড সময় নিয়ে আমাদের বলতে পারো কেন?';

  @override
  String get app_review_negative_modal_positive_button => 'হ্যাঁ, একেবারে!';

  @override
  String get app_review_negative_modal_negative_button => 'না';

  @override
  String get could_not_refresh => 'পণ্য রিফ্রেশ করা যায়নি';

  @override
  String get product_internet_error_modal_title => 'একটি ত্রুটি ঘটেছে!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'নেটওয়ার্ক ত্রুটির কারণে আমরা এই পণ্য সম্পর্কে তথ্য আনতে পারছি না। অনুগ্রহ করে আপনার ইন্টারনেট সংযোগ পরীক্ষা করে আবার চেষ্টা করুন।\n\nঅভ্যন্তরীণ ত্রুটি:\n$error';
  }

  @override
  String get product_tags_title => 'পণ্যের বৈশিষ্ট্য';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'কোনও সম্পত্তি নেই';

  @override
  String get product_tags_explanation =>
      'একটি পণ্যের বৈশিষ্ট্য (কী/মান) যোগ করে, আপনি এটিকে সমৃদ্ধ করতে সাহায্য করেন।';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'বৈশিষ্ট্য যোগ করুন';

  @override
  String get add_edit_tags => 'বৈশিষ্ট্য যোগ করুন বা সম্পাদনা করুন';

  @override
  String get edit_tag => 'সম্পত্তি সম্পাদনা করুন';

  @override
  String get remove_tag => 'সম্পত্তি সরান';

  @override
  String get tag_key => 'সম্পত্তি';

  @override
  String get tag_keys => 'বৈশিষ্ট্য';

  @override
  String get tag_key_uneditable => 'সম্পত্তি (অসম্পাদনাযোগ্য)';

  @override
  String get tag_key_input_hint => 'একটি সম্পত্তি ইনপুট করুন';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'একটি মান ইনপুট করুন';

  @override
  String get tag_key_item => 'সম্পত্তি:';

  @override
  String get tag_value_item => 'মান:';

  @override
  String get tag_key_explanations =>
      'একটি কী অবশ্যই ছোট হাতের অক্ষরে এবং কোনও ফাঁকা স্থান ছাড়াই হতে হবে।';

  @override
  String tag_key_already_exists(String property) {
    return '$property প্রপার্টি সহ একটি ট্যাগ ইতিমধ্যেই বিদ্যমান!';
  }

  @override
  String get product_internet_error =>
      'নেটওয়ার্ক ত্রুটির কারণে এই পণ্য সম্পর্কে তথ্য আনা অসম্ভব।';

  @override
  String get cached_results_from => 'এর থেকে ফলাফল দেখান:';

  @override
  String get product_search_same_category => 'বিকল্প খুঁজুন';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'এই বৈশিষ্ট্যটি শুধুমাত্র বিভাগযুক্ত পণ্যের জন্য ব্যবহার করা যেতে পারে।\n\nবিভাগ যোগ করতে পণ্যটি সম্পাদনা করুন।';

  @override
  String get product_improvement_add_category =>
      'Nutri-Score গণনা করতে একটি বিভাগ যোগ করুন।';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Nutri-Score গণনা করতে পুষ্টির তথ্য যোগ করুন।';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Nutri-Score গণনা করতে পুষ্টির তথ্য এবং একটি বিভাগ যোগ করুন।';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'এই পণ্যের জন্য Nutri-Score গণনা করা যাচ্ছে না, যা একটি অ-মানক বিভাগের কারণে হতে পারে। যদি এটি একটি ত্রুটি হিসাবে বিবেচিত হয়, তাহলে অনুগ্রহ করে আমাদের সাথে যোগাযোগ করুন।';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'পুষ্টির ছবিটি পুরনো: দয়া করে এটি রিফ্রেশ করুন।';

  @override
  String get product_improvement_origins_to_be_completed =>
      'গ্রিন স্কোর উপাদানগুলির উৎপত্তি বিবেচনা করে। অনুগ্রহ করে উপাদান তালিকা এবং/অথবা যেকোনো ভৌগোলিক দাবির একটি ছবি তুলুন অথবা পণ্যটি সম্পাদনা করুন, যাতে সেগুলি বিবেচনায় নেওয়া যায়।';

  @override
  String get country_chooser_label => 'অনুগ্রহ করে একটি দেশ বেছে নিন।';

  @override
  String get currency_chooser_label => 'অনুগ্রহ করে একটি মুদ্রা বেছে নিন।';

  @override
  String get country_change_message => 'তুমি সবেমাত্র দেশ পরিবর্তন করেছো।';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'আপনি কি মুদ্রা $previousCurrency থেকে $possibleCurrencyএ পরিবর্তন করতে চান?';
  }

  @override
  String get onboarding_country_chooser_label =>
      'অনুগ্রহ করে একটি দেশ বেছে নিন:';

  @override
  String get country_chooser_label_from_settings => 'তোমার দেশ';

  @override
  String get country_selection_explanation =>
      'কিছু পরিবেশগত বৈশিষ্ট্য অবস্থান-নির্দিষ্ট';

  @override
  String get product_removed_comparison => 'তুলনা থেকে পণ্যটি সরানো হয়েছে';

  @override
  String get native_app_settings => 'নেটিভ অ্যাপ সেটিংস';

  @override
  String get native_app_description =>
      'ওপেন ফুড ফ্যাক্টসের জন্য সিস্টেম সেটিংস খুলুন';

  @override
  String get product_removed_history => 'ইতিহাস থেকে পণ্যটি সরানো হয়েছে';

  @override
  String get product_removed_list => 'তালিকা থেকে পণ্যটি সরানো হয়েছে';

  @override
  String get product_could_not_remove => 'পণ্যটি সরানো যায়নি';

  @override
  String get no_prodcut_in_list => 'এই তালিকায় কোনও পণ্য নেই।';

  @override
  String get no_product_in_section => 'এই বিভাগে কোনও পণ্য নেই।';

  @override
  String get recently_seen_products => 'সকল দেখা পণ্য';

  @override
  String get clear => 'মুছে ফেলুন';

  @override
  String get clear_long => 'তালিকাটি খালি করুন';

  @override
  String get really_clear => 'আপনি কি সত্যিই এই তালিকাটি মুছে ফেলতে চান?';

  @override
  String pct_match(Object percent) {
    return '$percent% মিল';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count দিন আগে',
      one: 'একদিন আগে',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ঘন্টা আগে',
      one: 'এক ঘন্টা আগে',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count মিনিট আগে',
      one: 'এক মিনিট আগে',
      zero: 'এক মিনিটেরও কম আগে',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count মাস আগে',
      one: 'এক মাস আগে',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count সপ্তাহ আগে',
      one: 'এক সপ্তাহ আগে',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'তুলনা করুন $count পণ্যের তুলনা করুন',
      one: 'একটি পণ্যের তুলনা করুন',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count নির্বাচিত পণ্য',
      one: 'একটি নির্বাচিত পণ্য',
      zero: 'কোনও নির্বাচিত পণ্য নেই',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'নির্বাচিত পণ্যের তুলনা করুন';

  @override
  String get delete_products_mode => 'নির্বাচিত পণ্যগুলি মুছুন';

  @override
  String get select_all_products_mode => 'সমস্ত পণ্য নির্বাচন করুন';

  @override
  String get select_none_products_mode => 'কোনওটিই নির্বাচন করবেন না';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle =>
      'অনুগ্রহ করে কমপক্ষে দুটি পণ্য নির্বাচন করুন';

  @override
  String get retry_button_label => 'পুনরায় চেষ্টা করুন';

  @override
  String get connect_with_us => 'আমাদের সাথে যোগাযোগ করুন';

  @override
  String get tiktok => 'টিকটকে আমাদের অনুসরণ করুন';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'ইনস্টাগ্রামে আমাদের অনুসরণ করুন';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'X (পূর্বে টুইটার) এ আমাদের অনুসরণ করুন।';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'মাস্টোডনে আমাদের অনুসরণ করুন';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'ব্লুস্কাইতে আমাদের অনুসরণ করুন';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'ব্লগ';

  @override
  String get faq => 'প্রায়শই জিজ্ঞাসিত প্রশ্নাবলী';

  @override
  String get discover => 'আবিষ্কার করো';

  @override
  String get how_to_contribute => 'কীভাবে অবদান রাখবেন';

  @override
  String get hint_knowledge_panel_message =>
      'আপনি যা দেখছেন তার সম্পর্কে আরও বিশদ জানতে কার্ডের যেকোনো অংশে ট্যাপ করতে পারেন। এখনই চেষ্টা করে দেখুন!';

  @override
  String get permissions_page_title => 'ক্যামেরা অ্যাক্সেস';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'যদি আপনি আপনার মত পরিবর্তন করেন, তাহলে সেটিংস থেকে যেকোনো সময় এই বিকল্পটি সক্রিয় এবং নিষ্ক্রিয় করা যেতে পারে।';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'অপারেটিং সিস্টেম: অ্যান্ড্রয়েড (SDK Int: $sdkInt / রিলিজ: $release)\nমডেল: $model\nপণ্য: $product\nডিভাইস: $device\nব্র্যান্ড:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'অপারেটিং সিস্টেম: iOS ($version)\nমডেল: $model\nস্থানীয় মডেল: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nঅ্যাপ ভার্সন:$appVersion\nঅ্যাপ বিল্ড নম্বর:$appBuildNumber\nঅ্যাপ প্যাকেজের নাম:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'প্রত্যাখ্যান করুন';

  @override
  String get ask_me_later_button_label => 'পরে';

  @override
  String get are_you_sure => 'তুমি কি নিশ্চিত?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'আরও এগিয়ে যান $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'স্বাগত!';

  @override
  String get onboarding_home_welcome_text2 =>
      'এই অ্যাপটি আপনাকে **আপনার** এবং **গ্রহের** জন্য ভালো খাবার বেছে নিতে সাহায্য করে!';

  @override
  String get onboarding_continue_button => 'চালিয়ে যান';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'আপনার প্রথম নমুনা পণ্যটি লোড হচ্ছে';

  @override
  String get onboarding_welcome_warning =>
      'দুঃখিত, এটি আমাদের নমুনা পণ্য, আপনি এটি সম্পাদনা করতে পারবেন না :)';

  @override
  String get product_list_your_ranking => 'আপনার র‍্যাঙ্কিং';

  @override
  String get product_list_empty_icon_desc => 'ইতিহাস উপলব্ধ নেই';

  @override
  String get product_list_empty_title => 'স্ক্যান করা শুরু করুন';

  @override
  String get product_list_empty_message =>
      'স্ক্যান করা পণ্যগুলি এখানে প্রদর্শিত হবে এবং আপনি সেগুলি সম্পর্কে বিস্তারিত তথ্য পরীক্ষা করতে পারবেন।';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'পণ্য',
      one: 'পণ্য',
      zero: 'পণ্য',
    );
    return 'আপনার ইতিহাসে $_temp0 রিফ্রেশ করা হচ্ছে';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'পণ্য',
      one: 'পণ্য',
      zero: 'পণ্য',
    );
    return '$_temp0 রিফ্রেশ সম্পূর্ণ';
  }

  @override
  String get product_list_compare_side_by_side => 'পাশাপাশি তুলনা করুন';

  @override
  String get loading_dialog_default_title => 'ডেটা ডাউনলোড করা হচ্ছে';

  @override
  String get loading_dialog_default_error_message => 'ডেটা ডাউনলোড করা যায়নি';

  @override
  String get account_delete => 'অ্যাকাউন্ট মুছুন';

  @override
  String get account_delete_title => 'আমার অ্যাকাউন্ট মুছে ফেলুন';

  @override
  String get user_profile => 'হিসাব';

  @override
  String get user_profile_title_guest => 'স্বাগতম!';

  @override
  String get user_profile_subtitle_guest =>
      'ওপেন ফুড ফ্যাক্টস কমিউনিটিতে যোগদানের জন্য সাইন-ইন করুন অথবা সাইন-আপ করুন।';

  @override
  String user_profile_title_id_email(String email) {
    return 'খাদ্য তথ্য লগইন খুলুন: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'স্বাগতম $id!';
  }

  @override
  String get email_subject_account_deletion => 'অ্যাকাউন্ট মুছুন';

  @override
  String email_body_account_deletion(String userId) {
    return 'হ্যালো, দয়া করে আমার ওপেন ফুড ফ্যাক্টস অ্যাকাউন্টটি মুছে ফেলুন: $userId';
  }

  @override
  String get settings_app_app => 'আবেদন';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'ক্যামেরা';

  @override
  String get settings_app_products => 'পণ্য';

  @override
  String get settings_app_miscellaneous => 'বিবিধ';

  @override
  String get camera_play_sound_title => 'স্ক্যান করার সময় একটি শব্দ বাজান';

  @override
  String get camera_play_sound_subtitle => 'প্রতিটি সফল স্ক্যানে বিপ হবে';

  @override
  String get camera_window_accessibility_label =>
      'আপনার ক্যামেরা দিয়ে একটি বারকোড স্ক্যান করুন';

  @override
  String get app_haptic_feedback_title => 'কম্পন এবং স্পর্শকাতরতা';

  @override
  String get app_haptic_feedback_subtitle =>
      'কিছু ক্রিয়া সম্পাদনের পরে কম্পন (বারকোড ডিকোড করা হয়েছে, পণ্য সরানো হয়েছে…)।';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'সক্রিয় করা হলে, ক্র্যাশ রিপোর্টগুলি স্বয়ংক্রিয়ভাবে ওপেন ফুড ফ্যাক্টসের ত্রুটি ট্র্যাকিং সিস্টেমে জমা দেওয়া হয়, যাতে বাগগুলি ঠিক করা যায় এবং এইভাবে অ্যাপটিকে উন্নত করা যায়।';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'ছবি সম্পাদনা করুন';

  @override
  String get permission_photo_error => 'ত্রুটি';

  @override
  String get permission_photo_denied_title =>
      'বারকোড স্ক্যান করার জন্য ক্যামেরা ব্যবহারের অনুমতি দিন';

  @override
  String permission_photo_denied_message(String appName) {
    return 'উন্নত অভিজ্ঞতার জন্য, অনুগ্রহ করে $appName কে আপনার ক্যামেরা অ্যাক্সেস করার অনুমতি দিন। আপনি সরাসরি বারকোড স্ক্যান করতে পারবেন।';
  }

  @override
  String get permission_photo_denied_button => 'অনুমতি দিন';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'অনুমতি অস্বীকার করা হয়েছে';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'যেহেতু আপনি আগে ক্যামেরার অনুমতি অস্বীকার করেছেন, তাই আপনাকে সেটিংস থেকে ম্যানুয়ালি এটি অনুমোদন করতে হবে।';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'সেটিংস খুলুন';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Cancel';

  @override
  String get permission_photo_none_found => 'কোনও ক্যামেরা শনাক্ত করা যায়নি';

  @override
  String get permission_photo_denied => 'ক্যামেরা অ্যাক্সেসের অনুমতি নেই';

  @override
  String get show_product_pictures => 'পণ্যের ছবি দেখান';

  @override
  String get edit_product_label => 'পণ্য সম্পাদনা করুন';

  @override
  String get edit_product_pending_operations_banner_title =>
      'আপনার সম্পাদনাগুলি আপলোড করা হচ্ছে…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'আপনার সম্পাদনাগুলি **পটভূমিতে** পাঠানো হচ্ছে (অথবা ত্রুটির ক্ষেত্রে পরে)।\nআপনি অন্যান্য পণ্য ক্ষেত্র সম্পাদনা চালিয়ে যেতে পারেন।';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'আপনার সম্পাদনাগুলি **পটভূমিতে** পাঠানো হচ্ছে (অথবা ত্রুটির ক্ষেত্রে পরে)।';

  @override
  String get edit_product_label_short => 'Edit';

  @override
  String edit_product_form_item_help(String value) {
    return '\"$value\" কিভাবে লিখবেন?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'অনুগ্রহ করে একটি অ-খালি মান লিখুন!';

  @override
  String get edit_product_form_item_error_existing => 'এই মানটি ইতিমধ্যেই আছে!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'একটি নতুন ব্র্যান্ড যোগ করুন';

  @override
  String get edit_product_form_item_add_action_label =>
      'একটি নতুন লেবেল যোগ করুন';

  @override
  String get edit_product_form_item_add_action_store =>
      'একটি নতুন দোকান যোগ করুন';

  @override
  String get edit_product_form_item_add_action_origin =>
      'একটি নতুন উৎস যোগ করুন';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'একটি নতুন ট্রেসেবিলিটি কোড যোগ করুন';

  @override
  String get edit_product_form_item_add_action_country =>
      'একটি নতুন দেশ যোগ করুন';

  @override
  String get edit_product_form_item_add_action_category =>
      'একটি নতুন বিভাগ যোগ করুন';

  @override
  String get edit_product_form_item_add_action_trace =>
      'একটি নতুন ট্রেস যোগ করুন';

  @override
  String get edit_product_form_item_add_suggestion => 'পরামর্শ যোগ করুন';

  @override
  String get edit_product_form_item_deny_suggestion =>
      'পরামর্শ প্রত্যাখ্যান করুন';

  @override
  String get edit_product_form_item_details_title => 'মৌলিক বিবরণ';

  @override
  String get edit_product_form_item_details_subtitle =>
      'পণ্যের নাম, ব্র্যান্ড, পরিমাণ';

  @override
  String get edit_product_form_item_other_details_title => 'অতিরিক্ত তথ্য';

  @override
  String get edit_product_form_item_other_details_subtitle => 'ওয়েবসাইট…';

  @override
  String get edit_product_form_item_photos_title => 'ছবি';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'ফটো যোগ করুন বা রিফ্রেশ করুন';

  @override
  String get edit_product_form_item_labels_title => 'লেবেল এবং সার্টিফিকেশন';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'পরিবেশগত, মানসম্মত লেবেল…';

  @override
  String get edit_product_form_item_labels_hint =>
      'একটি লেবেল ইনপুট করুন (যেমন: নিউট্রিস্কোর)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'ভালো অভ্যাস: লেবেল';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'পণ্যের যেকোনো বৈশিষ্ট্য **যা বাস্তবসম্মত** এবং অন্যান্য ক্ষেত্র থেকে আলাদা।';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'নিউট্রি-স্কোর, নোভা…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'বেলজিয়ামে তৈরি, ব্রিটানিতে উৎপাদিত…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'ফাইবার সমৃদ্ধ, আয়রনের উৎস…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'ন্যায্য বাণিজ্য, ম্যাক্স হ্যাভেলার…';

  @override
  String get edit_product_form_item_stores_title => 'দোকান সমূহ';

  @override
  String get edit_product_form_item_stores_hint => 'একটি দোকান ইনপুট করুন';

  @override
  String get edit_product_form_item_stores_type => 'দোকান';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'ভালো অভ্যাস: দোকান';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'আপনি যে দোকান থেকে পণ্যটি কিনেছেন সেই দোকানটি ইনপুট করুন।';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'ওয়ালমার্ট';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'ক্যারফোর';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'লিডল';

  @override
  String get edit_product_form_item_origins_title => 'উৎপত্তি';

  @override
  String get edit_product_form_item_origins_hint =>
      'একটি উৎস ইনপুট করুন (যেমন: জার্মানি)';

  @override
  String get edit_product_form_item_origins_type => 'দেশ';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'ভালো অভ্যাস: উৎপত্তি';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      '**প্যাকেজে উৎপত্তির যেকোনো ইঙ্গিত** যোগ করুন।\nউপাদানের তালিকায় সরাসরি উল্লেখিত উৎপত্তি সম্পর্কে চিন্তা করার দরকার নেই।';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'আর্জেন্টিনার গরুর মাংস';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'সয়া ইউরোপীয় ইউনিয়ন থেকে আসে না।';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'একটি দেশ ইনপুট করুন (যেমন: জার্মানি)';

  @override
  String get edit_product_form_item_countries_type => 'দেশ';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'ভালো অনুশীলন: দেশগুলি';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**যেসব দেশে পণ্যটি ব্যাপকভাবে পাওয়া যায়** (বিদেশী পণ্যের বিশেষজ্ঞ দোকানগুলি বাদে)।';

  @override
  String get edit_product_form_item_emb_codes_title => 'ট্রেসেবিলিটি কোড';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'একটি কোড ইনপুট করুন (যেমন: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'ট্রেসেবিলিটি কোড';

  @override
  String get edit_product_form_item_emb_help_title =>
      'ভালো অভ্যাস: ট্রেসেবিলিটি কোড';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'এই বিভাগে, আপনি **প্যাকেজিং চিহ্ন**, **পরিচয় চিহ্ন** বা **স্বাস্থ্য চিহ্ন** সম্পর্কিত কোডগুলি ইনপুট করতে পারেন।';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'ট্রেসেবিলিটি কোডের উদাহরণ';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**ইসি কোড** ইউরোপীয় সম্প্রদায়ে খাদ্য উৎপাদক বা প্যাকেজার সনাক্ত করতে ব্যবহৃত হয়:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: **ফ্রান্স** এর দেশের কোড\n**৭২.২৬৪.০০২**: ভৌগোলিক তথ্য\n**CE**: ইউরোপীয় সম্প্রদায়';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**ইএমবি কোড** ফ্রান্সে ব্যবহৃত:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'ইএমবি ৭২২৬৪';

  @override
  String get edit_product_form_item_traces_title => 'Traces';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'একটি ট্রেস ইনপুট করুন (যেমন: সয়াবিন)';

  @override
  String get edit_product_form_item_categories_title => 'শ্রেণীসমূহ';

  @override
  String get edit_product_form_item_categories_hint => 'শ্রেণীসমূহ';

  @override
  String get edit_product_form_item_categories_type =>
      'একটি বিভাগ লিখুন (যেমন: কমলার রস)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'ভালো অভ্যাস: বিভাগ';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      '**শুধুমাত্র সবচেয়ে নির্দিষ্ট বিভাগ** নির্দেশ করুন।\nমূল বিভাগগুলি স্বয়ংক্রিয়ভাবে যোগ করা হবে।';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'বিভাগটি অনুপস্থিত?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'যদি কোনও বিভাগ **স্বয়ংক্রিয়ভাবে** উপলব্ধ না থাকে, তাহলে নির্দ্বিধায় এটি যোগ করুন।\nএটি আপনার দেশে ওপেন ফুড ফ্যাক্টস উন্নত করতে আমাদের সাহায্য করবে।';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'জলপাই তেলে সার্ডিন';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'ঘনীভূত কমলার রস';

  @override
  String get edit_product_form_item_exit_title => 'সেভ না করেই ছেড়ে দেবেন?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'এই পৃষ্ঠাটি ছেড়ে যাওয়ার আগে আপনি কি আপনার পরিবর্তনগুলি সংরক্ষণ করতে চান?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'পরিবর্তনগুলি সংরক্ষণ করুন';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'পরিবর্তনগুলি বাতিল করুন';

  @override
  String get edit_product_form_item_ingredients_title => 'উপকরণসমূহ';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'স্ক্রিনটি পিঞ্চ করে জুম ইন এবং আউট করুন';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'ছবিটি জুম ইন এবং আউট করুন';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '**পিঞ্চ-টু-জুম জেসচার** ব্যবহার করে, আপনি ছবিটি জুম ইন বা আউট করতে পারেন:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'যোগ';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'প্রথমে একটি টেক্সট লিখুন।';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'অপসারণ';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'আপনার সম্পাদনা সংরক্ষণ করুন';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'আপনার সম্পাদনা বাতিল করুন';

  @override
  String get edit_product_form_item_packaging_title =>
      'পুনর্ব্যবহারের নির্দেশাবলীর ছবি';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'পুষ্টি তথ্য';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'পুষ্টি, অ্যালকোহলের পরিমাণ…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'ভালো অভ্যাস: পুষ্টির তথ্য';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'পুষ্টির মান';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'প্রথমে, **মান** প্রদান করা হয়েছে কিনা তা নির্বাচন করুন:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'পুষ্টি তথ্য';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'তারপর, প্যাকেজিং-এ নির্দেশিত **পুষ্টির মান** লিখুন। যদি কোনও মান না থাকে, তাহলে আপনি \"আই\" আইকনে ক্লিক করতে পারেন।';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'ক্ষেত্রটি অনুপস্থিত?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'যদি কোনও এন্ট্রি অনুপস্থিত থাকে, তাহলে আপনি **\"প্লাস\" আইকনে ক্লিক করে** এটি যোগ করতে পারেন (যেমন: ভিটামিন ডি, ম্যাগনেসিয়াম…)।';

  @override
  String get edit_product_form_save => 'Edit';

  @override
  String get edit_product_ingredients_photo_title => 'উপকরণের ছবি';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'প্যাকেজিং ছবি';

  @override
  String get edit_product_packaging_list_title => 'প্যাকেজিং তালিকা';

  @override
  String get no_data_available => 'কোন তথ্য নেই';

  @override
  String get product_field_website_title => 'ওয়েবসাইট';

  @override
  String get origins_editing_title => 'উৎপত্তি সম্পাদনা করুন';

  @override
  String get completed_basic_details_btn_text => 'সম্পূর্ণ মৌলিক বিবরণ';

  @override
  String get not_implemented_snackbar_text => 'এখনও বাস্তবায়িত হয়নি';

  @override
  String get category_picker_page_appbar_text => 'শ্রেণীসমূহ';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'ছবি থেকে উপাদানগুলো বের করুন';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'ছবি থেকে\nউপাদানগুলি বের করা হচ্ছে';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'ছবি লোড হচ্ছে…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'আমি এই বার্তাটি কেন দেখতে পাচ্ছি?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      '\"উপাদান বের করুন\" বৈশিষ্ট্যটি ব্যবহার করতে, প্রথমে ছবিটি আপলোড করতে হবে।\n\nঅনুগ্রহ করে কয়েক সেকেন্ড অপেক্ষা করুন অথবা ম্যানুয়ালি লিখুন।';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'ছবি রিফ্রেশ করুন';

  @override
  String get edit_packaging_extract_btn_text => 'ছবি থেকে প্যাকেজিং\nবের করুন';

  @override
  String get edit_packaging_extract_btn_text_short => 'এক্সট্র্যাক্ট প্যাকেজিং';

  @override
  String get edit_packaging_extracting_btn_text =>
      'ছবি থেকে প্যাকেজিং বের করা হচ্ছে';

  @override
  String get edit_packaging_loading_photo_btn_text => 'ছবি লোড হচ্ছে…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'আমি এই বার্তাটি কেন দেখতে পাচ্ছি?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      '\"এক্সট্র্যাক্ট প্যাকেজিং\" বৈশিষ্ট্যটি ব্যবহার করতে, প্রথমে ছবিটি আপলোড করতে হবে।\n\nঅনুগ্রহ করে কয়েক সেকেন্ড অপেক্ষা করুন অথবা ম্যানুয়ালি লিখুন।';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'ছবি রিফ্রেশ করুন';

  @override
  String get edit_ocr_extract_failed => 'ছবিতে লেখা শনাক্ত করা যায়নি।';

  @override
  String get edit_ocr_extract_disabled_title => 'ছবি নেই!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'টেক্সট এক্সট্রাকশন ফিচারটি ব্যবহার করার জন্য, আপনাকে প্রথমে একটি ছবি তুলতে হবে।';

  @override
  String get user_list_dialog_new_title => 'নতুন পণ্যের তালিকা';

  @override
  String get user_list_dialog_rename_title => 'তালিকার নাম পরিবর্তন করুন';

  @override
  String get user_list_subtitle_product => 'তালিকা';

  @override
  String get user_list_title => 'Your lists';

  @override
  String get user_list_add_product => 'আপনার তালিকায় পণ্যটি যোগ করুন';

  @override
  String get user_list_button_new => 'একটি নতুন তালিকা তৈরি করুন';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'তালিকায় যোগ করুন';

  @override
  String get added_to_list_msg => 'তালিকায় যোগ করা হয়েছে';

  @override
  String get user_list_popup_clear => 'আপনার ইতিহাস সাফ করুন';

  @override
  String get user_list_popup_rename => 'পুনঃনামকরণ করুন';

  @override
  String get user_list_name_hint => 'আমার তালিকা';

  @override
  String get user_list_name_error_empty => 'নাম বাধ্যতামূলক';

  @override
  String get user_list_name_error_already =>
      'এই নামটি ইতিমধ্যেই ব্যবহৃত হয়েছে।';

  @override
  String get user_list_name_error_same => 'ওটাও একই নাম।';

  @override
  String get user_list_name_input_hint => 'তালিকার নাম';

  @override
  String get try_again => 'আবার চেষ্টা করো';

  @override
  String get there_was_an_error => 'একটি ত্রুটি ছিল।';

  @override
  String category_picker_no_category_found_message(String items) {
    return '$itemsএর জন্য কোনও বিভাগ পাওয়া যায়নি';
  }

  @override
  String get camera_toggle_camera =>
      'পিছনের এবং সামনের ক্যামেরার মধ্যে স্যুইচ করুন';

  @override
  String get camera_toggle_flash => 'ক্যামেরার ফ্ল্যাশ চালু বা বন্ধ করুন';

  @override
  String get camera_enable_flash => 'ফ্ল্যাশ সক্ষম করুন';

  @override
  String get camera_disable_flash => 'ফ্ল্যাশ বন্ধ করুন';

  @override
  String get camera_flash_error_dialog_title => 'একটি ত্রুটি ঘটেছে!';

  @override
  String get camera_flash_error_dialog_message =>
      'আপনার ফ্ল্যাশের অবস্থা পরিবর্তন করার সময় একটি ত্রুটি ঘটেছে। দয়া করে নিশ্চিত করুন যে আপনার স্মার্টফোনে টর্চটি ইতিমধ্যেই চালু নেই।';

  @override
  String get category_picker_no_category_found_button => 'পিছনে যান';

  @override
  String get user_preferences_item_accessibility_hint =>
      'আপনার ব্রাউজারে বা অ্যাপ্লিকেশনে (যদি ইনস্টল করা থাকে) খুলতে ক্লিক করুন।';

  @override
  String get dev_preferences_screen_title => 'DEV মোড';

  @override
  String get dev_preferences_screen_subtitle =>
      'পরীক্ষামূলক বৈশিষ্ট্য এবং উন্নয়ন সরঞ্জাম অ্যাক্সেস করুন';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'অনবোর্ডিং পুনরায় চালু করুন';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'তারপর আবার দেখার জন্য আপনাকে অ্যাপটি পুনরায় চালু করতে হবে।';

  @override
  String get dev_preferences_environment_switch_title =>
      'openfoodfacts.org (PROD) এবং test env এর মধ্যে স্যুইচ করুন';

  @override
  String get dev_preferences_test_environment_title =>
      'পরিবেশের পরামিতি পরীক্ষা করুন';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'বর্তমান পরীক্ষার env-এর জন্য বেস URL: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'পরীক্ষামূলক পরিবেশ হোস্ট';

  @override
  String get dev_preferences_ml_kit_title => 'এমএল কিট ব্যবহার করুন';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'তারপর আপনাকে এই অ্যাপটি পুনরায় চালু করতে হবে';

  @override
  String get dev_preferences_product_additional_features_title =>
      'পণ্য পৃষ্ঠায় অতিরিক্ত বোতাম';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'নলেজ প্যানেল বোতামের মাধ্যমে উপাদানগুলি সম্পাদনা করুন';

  @override
  String get dev_preferences_export_history_title => 'রপ্তানির ইতিহাস';

  @override
  String get dev_preferences_export_history_progress_error => 'ব্যতিক্রম';

  @override
  String get dev_preferences_export_history_progress_found =>
      'পণ্য পাওয়া গেছে';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'পণ্য পাওয়া যায়নি';

  @override
  String get dev_preferences_export_history_dialog_title => 'রপ্তানির ইতিহাস';

  @override
  String get dev_preferences_button_positive => 'ঠিক আছে';

  @override
  String get dev_preferences_button_negative => 'Cancel';

  @override
  String get dev_preferences_migration_title => 'V1 থেকে ডেটা মাইগ্রেশন';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'অবস্থা: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'সফল অথবা নতুন ইনস্টলেশন';

  @override
  String get dev_preferences_migration_status_success => 'সাফল্য';

  @override
  String get dev_preferences_migration_status_error => 'ত্রুটি';

  @override
  String get dev_preferences_migration_status_in_progress => 'চলছে';

  @override
  String get dev_preferences_migration_status_required =>
      'প্রয়োজনীয় (শুরু করতে ক্লিক করুন)';

  @override
  String get dev_preferences_migration_status_not_started => 'অজানা';

  @override
  String get dev_preferences_import_history_subtitle =>
      'ইতিহাস মুছে ফেলা হবে এবং সেখানে 3টি পণ্য রাখা হবে';

  @override
  String get dev_preferences_news_custom_url_title => 'খবরের জন্য কাস্টম URL';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'JSON ফাইলের URL:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'সেট করা নেই';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'শেষ রিফ্রেশ: $date';
  }

  @override
  String get product_type_label_food => 'খাদ্য';

  @override
  String get product_type_label_beauty => 'ব্যক্তিগত যত্ন';

  @override
  String get product_type_label_pet_food => 'পোষা প্রাণীর খাবার';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'পণ্যের ধরণ';

  @override
  String get product_type_selection_subtitle => 'এই পণ্যের ধরণ নির্বাচন করুন';

  @override
  String get product_type_selection_empty =>
      'আপনাকে প্রথমে একটি পণ্যের ধরণ নির্বাচন করতে হবে!';

  @override
  String product_type_selection_already(String productType) {
    return 'আপনি পণ্যের ধরণ পরিবর্তন করতে পারবেন না ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag => 'পণ্য পৃষ্ঠায় মূল্য অ্যাপের শর্টকাট';

  @override
  String get prices_app_button => 'প্রাইস অ্যাপে যান';

  @override
  String get prices_website_button => 'ওপেন প্রাইস ওয়েবসাইটে খুলুন';

  @override
  String get prices_bulk_proof_upload_select =>
      'গ্যালারি থেকে সরাসরি মূল্য ট্যাগ যোগ করুন';

  @override
  String get prices_bulk_proof_upload_warning =>
      'একবার ছবি নির্বাচন করলে, আপনি আর সেগুলি সম্পাদনা করতে পারবেন না!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'সম্প্রদায়কে AI দ্বারা আহৃত মূল্য যাচাই করার অনুমতি দিন।';

  @override
  String get prices_bulk_proof_upload_subtitle => 'একাধিক মূল্য ট্যাগ';

  @override
  String get prices_bulk_proof_upload_title => 'বাল্ক প্রুফ আপলোড';

  @override
  String get prices_bulk_proof_upload_step_selecting =>
      'ফাইল নির্বাচন করা হচ্ছে';

  @override
  String get prices_bulk_proof_upload_step_starting => 'আপলোড শুরু হচ্ছে';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'স্থানীয়ভাবে ফাইলটি অনুলিপি করা হচ্ছে #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'আপলোডের প্রস্তুতি #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return '#$index/$countছবিতে ব্যর্থ হয়েছে';
  }

  @override
  String get prices_generic_title => 'দাম';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count দাম যোগ করুন',
      one: 'দাম যোগ করুন',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count দাম পাঠান',
      one: 'দাম পাঠান',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'একটি আইটেম যোগ করুন';

  @override
  String get prices_add_a_price => 'একটি মূল্য যোগ করুন';

  @override
  String get prices_add_a_receipt => 'একটি রসিদ যোগ করুন';

  @override
  String get prices_add_price_tags => 'মূল্য ট্যাগ যোগ করুন';

  @override
  String prices_barcode_already(String barcode) {
    return 'এই বারকোডটি ($barcode) ইতিমধ্যেই তালিকায় রয়েছে!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'এখনও কোনও পণ্য নেই।';

  @override
  String prices_barcode_search_running(String barcode) {
    return '$barcodeখুঁজছি';
  }

  @override
  String get prices_barcode_enter => 'বারকোড লিখুন';

  @override
  String get prices_category_enter => 'বারকোড ছাড়া আইটেম';

  @override
  String get prices_per_kilogram => 'প্রতি কেজির দাম';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / কেজি';

  @override
  String get prices_per_unit_short => ' / ইউনিট';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'ঐচ্ছিক';

  @override
  String get prices_category_error_mandatory => 'বিভাগটি বাধ্যতামূলক';

  @override
  String get prices_barcode_reader_action => 'বারকোড রিডার';

  @override
  String get prices_view_prices => 'দাম দেখুন';

  @override
  String get prices_list_title => 'মূল্য তালিকা';

  @override
  String get prices_list_count => '\nদামের সংখ্যা';

  @override
  String get prices_list_add_new_price => '\nনতুন দাম যোগ করুন';

  @override
  String get prices_list_empty_title => 'এখনও দাম নেই!';

  @override
  String get prices_list_empty_subtitle =>
      'প্রথমে একটি যোগ করুন:\nএকটি **রসিদ** অথবা **মূল্য ট্যাগ** স্ক্যান করে!';

  @override
  String get prices_entry_shop_not_found => 'অজানা দোকান';

  @override
  String prices_entry_menu_title(String user) {
    return '\"$user\" থেকে মূল্য এন্ট্রি';
  }

  @override
  String get prices_entry_menu_open_product_prices => 'এই পণ্যের সকল দাম দেখুন';

  @override
  String get prices_entry_menu_open_proof => 'প্রমাণ দেখুন';

  @override
  String get prices_entry_menu_my_prices => 'আমার অন্যান্য দাম দেখুন';

  @override
  String get prices_entry_menu_author_prices => 'লেখকের অন্যান্য দাম দেখুন';

  @override
  String get prices_entry_menu_shop_prices => 'দোকান থেকে অন্যান্য দাম দেখুন';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count দাম',
      one: '১টি দাম',
    );
    return '$_temp0 $productএর জন্য';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'সব $count দাম',
      one: 'শুধুমাত্র একটি দাম',
      zero: 'এখনও কোন দাম নেই',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'সর্বশেষ $pageSize দাম (মোট: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'মূল্য: $price / দোকান: \"$location\" / \"$user\" দ্বারা $date এ প্রকাশিত';
  }

  @override
  String prices_open_user_proofs(String user) {
    return '\"$user\" এর প্রমাণগুলি খুলুন';
  }

  @override
  String get prices_open_proof => 'খোলা দামের প্রমাণ';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'সব $count প্রমাণ',
      one: 'শুধুমাত্র একটি প্রমাণ',
      zero: 'এখনও কোন প্রমাণ নেই',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'সর্বশেষ $pageSize প্রমাণ (মোট: $total)';
  }

  @override
  String get prices_users_empty_title => 'এখনও কোন অবদানকারী নেই!';

  @override
  String get prices_users_empty_explanation => 'দাম যোগ করা প্রথম হোন!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'শীর্ষ $pageSize অবদানকারী (মোট: $total)';
  }

  @override
  String get prices_locations_empty_title => 'এখনও কোন দোকান নেই!';

  @override
  String get prices_locations_empty_explanation => 'দাম যোগ করা প্রথম হোন!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'শীর্ষ $pageSize অবস্থান (মোট: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count প্রমাণ',
      one: 'একটি প্রমাণ',
      zero: 'কোন প্রমাণ নেই',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count পণ্য',
      one: 'একটি পণ্য',
      zero: 'কোনও পণ্য নেই',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ব্যবহারকারী',
      one: 'একজন ব্যবহারকারী',
      zero: 'কোনও ব্যবহারকারী নেই',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count দাম',
      one: 'এক দাম',
      zero: 'কোন দাম নেই',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'পূর্বে যোগ করা দাম';

  @override
  String get prices_amount_subtitle => 'পরিমাণ';

  @override
  String get prices_amount_is_discounted => 'ছাড় দেওয়া হয়?';

  @override
  String get prices_amount_price_normal => 'দাম';

  @override
  String get prices_amount_price_discounted => 'ছাড় দেওয়া দাম';

  @override
  String get prices_amount_price_not_discounted => 'আসল দাম';

  @override
  String get prices_amount_no_product => 'একটি পণ্য অনুপস্থিত!';

  @override
  String get prices_amount_price_incorrect => 'ভুল মান';

  @override
  String get prices_amount_price_mandatory => 'বাধ্যতামূলক মান';

  @override
  String get prices_currency_subtitle => 'মুদ্রা';

  @override
  String get prices_date_subtitle => 'তারিখ';

  @override
  String get prices_location_subtitle => 'দোকান';

  @override
  String get prices_location_find => 'একটি দোকান খুঁজুন';

  @override
  String get prices_location_mandatory => 'তোমাকে একটা দোকান বেছে নিতে হবে!';

  @override
  String get prices_location_search_broader =>
      'আপনি যা খুঁজছিলেন তা খুঁজে পাননি? আরও বিস্তৃত অনুসন্ধানের চেষ্টা করা যাক!';

  @override
  String get prices_proof_subtitle => 'প্রমাণ';

  @override
  String get prices_proof_empty_title => 'এখনও কোন প্রমাণ নেই!';

  @override
  String get prices_proof_empty_explanation =>
      '**রসিদ** অথবা **মূল্য ট্যাগ** এর একটি ছবি যোগ করে শুরু করুন!';

  @override
  String get prices_proof_find => 'একটি প্রমাণ নির্বাচন করুন';

  @override
  String get prices_proof_change => 'প্রমাণ পরিবর্তন করুন';

  @override
  String get prices_proof_receipt => 'রসিদ';

  @override
  String get prices_proof_price_tag => 'মূল্য ট্যাগ';

  @override
  String get prices_proof_mandatory => 'তোমাকে একটা প্রমাণ নির্বাচন করতে হবে!';

  @override
  String get prices_add_validation_error => 'যাচাইকরণ ত্রুটি';

  @override
  String get prices_privacy_warning_title => 'গোপনীয়তা সতর্কতা';

  @override
  String get prices_unknown_product => 'অজানা পণ্য';

  @override
  String get prices_privacy_warning_main_message =>
      'দাম **সর্বজনীন** হবে, সেই সাথে তারা যে দোকানটি উল্লেখ করবে।\n\nএটি আপনার ওপেন ফুড ফ্যাক্টস ছদ্মনাম সম্পর্কে যারা জানেন তাদের এটি করতে সাহায্য করতে পারে:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'আপনি কোন এলাকায় থাকেন তা অনুমান করুন।';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'তুমি কী কিনছো তা জেনে নাও';

  @override
  String get prices_privacy_warning_sub_message =>
      'যদি আপনি এতে অস্বস্তিতে থাকেন, তাহলে অনুগ্রহ করে আপনার ছদ্মনাম পরিবর্তন করুন, অথবা একটি নতুন ওপেন ফুড ফ্যাক্টস অ্যাকাউন্ট তৈরি করুন এবং এটি দিয়ে অ্যাপে লগ ইন করুন।';

  @override
  String get i_refuse => 'আমি প্রত্যাখ্যান করি।';

  @override
  String get i_accept => 'আমি গ্রহণ করি';

  @override
  String get prices_currency_change_proposal_title => 'মুদ্রা পরিবর্তন করবেন?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'আপনার বর্তমান মুদ্রা হল **$currency**। আপনি কি এটিকে **$newCurrency** এ পরিবর্তন করতে চান?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'হ্যাঁ, $newCurrencyব্যবহার করুন';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'না, $currencyরাখুন';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'সম্পন্ন';

  @override
  String get dev_mode_section_server => 'সার্ভার কনফিগারেশন';

  @override
  String get dev_mode_section_news => 'সংবাদ প্রদানকারীর কনফিগারেশন';

  @override
  String get dev_mode_section_product_page => 'পণ্য পৃষ্ঠা';

  @override
  String get dev_mode_section_ui => 'ব্যবহারকারী ইন্টারফেস';

  @override
  String get dev_mode_section_experimental_features => 'পরীক্ষামূলক বৈশিষ্ট্য';

  @override
  String get dev_mode_hide_environmental_score_title => 'সবুজ স্কোর বাদ দিন';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'OCR স্ক্রিনের জন্য একটি বানান পরীক্ষক ব্যবহার করুন';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(উপকরণ এবং প্যাকেজিং)';

  @override
  String get dev_mode_reset_app_language_title => 'অ্যাপের ভাষা রিসেট করুন';

  @override
  String get dev_mode_add_demo_cards_language_title => 'কার্ড যোগ করুন';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'prices.openfoodfacts.org (PROD) এবং test env এর মধ্যে স্যুইচ করুন।';

  @override
  String get search_history_item_edit_tooltip =>
      'এই অনুসন্ধানটি পুনঃব্যবহার এবং সম্পাদনা করুন';

  @override
  String get search_history_item_remove_tooltip => 'অপসারণ';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'আপনি $totalSize এর সকল পণ্য ডাউনলোড করেছেন।';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return '$count আরও পণ্য\nইতিমধ্যে ডাউনলোড করা হয়েছে $downloaded $totalSizeএর মধ্যে $count ডাউনলোড করুন।';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'আপনার $search অনুসন্ধান চলছে।\n\nঅনুগ্রহ করে কয়েক সেকেন্ড অপেক্ষা করুন…';
  }

  @override
  String get user_search_contributor_title => 'আমার যোগ করা পণ্যগুলি';

  @override
  String get user_search_informer_title => 'আমার সম্পাদনা করা পণ্যগুলি';

  @override
  String get user_search_photographer_title => 'আমার তোলা পণ্যগুলি';

  @override
  String get user_search_to_be_completed_title =>
      'আমার সম্পূর্ণ হতে যাওয়া পণ্যগুলি';

  @override
  String get user_search_prices_title => 'আমার দাম';

  @override
  String get user_search_proofs_title => 'আমার প্রমাণ';

  @override
  String get user_search_proof_title => 'আমার প্রমাণ';

  @override
  String search_proof_title(String user) {
    return '\"$user\" থেকে প্রমাণ';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'অবদানকারীর মূল্য: $user';
  }

  @override
  String get all_search_prices_latest_title => 'সর্বশেষ দাম যোগ করা হয়েছে';

  @override
  String get all_search_prices_top_user_title => 'শীর্ষ মূল্য অবদানকারীরা';

  @override
  String get all_search_prices_top_location_title => 'সবচেয়ে বেশি দামের দোকান';

  @override
  String get prices_contribution_assistant => 'মূল্য অবদান সহকারী';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'একাধিক প্রমাণ যোগ করুন';

  @override
  String get all_search_prices_top_location_single_title => 'দোকানে দাম';

  @override
  String get all_search_prices_top_product_title => 'সবচেয়ে বেশি দামের পণ্য';

  @override
  String get all_search_to_be_completed_title => 'সকল সম্পন্ন হতে যাওয়া পণ্য';

  @override
  String get categorize_products_country_title =>
      'আপনার দেশের পণ্যগুলিকে শ্রেণীবদ্ধ করতে সাহায্য করুন';

  @override
  String get edit_product_action_retake_picture => 'ছবি আবার তুলুন';

  @override
  String get edit_product_action_take_picture => 'ছবি তুলুন';

  @override
  String get edit_product_action_confirm => 'নিশ্চিত করুন';

  @override
  String get signup_page_terms_of_use_line1 =>
      'আমি ওপেন ফুড ফ্যাক্টসের সাথে একমত। ';

  @override
  String get signup_page_terms_of_use_line2 => 'ব্যবহারের শর্তাবলী এবং অবদান';

  @override
  String get analytics_consent_image_semantic_label => 'অ্যানালিটিক্স আইকন';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'মারাত্মক ত্রুটি: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'মারাত্মক ত্রুটি: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'সম্পূর্ণ মৌলিক বিবরণ';

  @override
  String get edit_photo_button_label => 'Edit';

  @override
  String get edit_photo_unselect_button_label => 'ছবি নির্বাচন থেকে বাদ দিন';

  @override
  String get edit_photo_select_existing_button_label =>
      'একটি বিদ্যমান ছবি নির্বাচন করুন';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'একটি ছবি নির্বাচন করুন, তাতে ক্লিক করুন';

  @override
  String get edit_photo_select_existing_download_label =>
      'বিদ্যমান ছবিগুলি পুনরুদ্ধার করা হচ্ছে…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'এই পণ্যের সাথে সম্পর্কিত কোনও ছবি আগে আপলোড করা হয়নি।';

  @override
  String get edit_photo_language_not_this_one => 'সেই ভাষায় এখনও কোনও ছবি নেই।';

  @override
  String get edit_photo_language_none => 'এখনও কোনও ছবি নেই।';

  @override
  String get category_picker_screen_title => 'শ্রেণীসমূহ';

  @override
  String get basic_details => 'মৌলিক বিবরণ';

  @override
  String get product_name => 'পণ্যের নাম';

  @override
  String get product_names => 'পণ্যের নাম';

  @override
  String get add_basic_details_product_name_add_translation =>
      'একটি নতুন অনুবাদ যোগ করুন';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'যাচাই করার আগে, দয়া করে নিশ্চিত করুন যে আপনি শুধুমাত্র একটি অনুবাদ যোগ করেছেন **যদি ভাষাটি প্যাকেজিংয়ে উপস্থিত থাকে**';

  @override
  String get add_basic_details_product_name_open_photo => 'সামনের ছবি দেখুন';

  @override
  String get add_basic_details_product_name_take_photo => 'সামনের ছবি তুলুন';

  @override
  String get add_basic_details_product_name_hint =>
      'পণ্যের নাম লিখুন (যেমন: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'ডিফল্ট ভাষা পরিবর্তন করবেন?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'আপনি কি পণ্যের ডিফল্ট ভাষা \'$language\' তে সেট করতে চান?';
  }

  @override
  String get explanation_section_good_examples => 'ভালো উদাহরণ';

  @override
  String get explanation_section_bad_examples => 'খারাপ উদাহরণ';

  @override
  String get add_basic_details_product_name_help_title =>
      'ভালো অভ্যাস: পণ্যের নাম';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'পণ্যের নাম হল **প্যাকেজে মুদ্রিত মূল নাম**। এটি একটি নিবন্ধিত ট্রেডমার্ক হতে পারে।';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**বিঃদ্রঃ:** যদি প্যাকেজিংয়ে ভাষাটি না থাকে তাহলে অনুগ্রহ করে **অনুবাদ যোগ করবেন না**।';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'নেসকুইক';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'টমেটো কেচাপ';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'নামের সাথে ব্র্যান্ডটি অন্তর্ভুক্ত করবেন না';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'টমেটো কেচাপ **হাইঞ্জের**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      '®, ™, © বা অনুরূপ চিহ্ন ব্যবহার করবেন না';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'নেসকুইক**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count অন্যান্য অনুবাদ',
      one: '$count অন্যান্য অনুবাদ',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'ব্র্যান্ড নাম';

  @override
  String get brand_names => 'ব্র্যান্ড নাম';

  @override
  String get add_basic_details_brand_name_error => 'ব্র্যান্ডের নাম লিখুন।';

  @override
  String get add_basic_details_brand_names_hint =>
      'ইনপুট ব্র্যান্ড (যেমন: ফেরেরো)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'ভালো অভ্যাস: ব্র্যান্ড';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      '**পণ্যের সকল ব্র্যান্ড** ইনপুট করুন।';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'প্রধান ব্র্যান্ড';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**প্রধান ব্র্যান্ড**, যা সাধারণত সামনের প্যাকে স্পষ্টভাবে প্রদর্শিত হয়, **প্রথমে** প্রবেশ করানো উচিত।';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'অন্যান্য ব্র্যান্ড';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'যখন **একটি বড় কোম্পানি** বিক্রি করে:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**অ্যাক্টিমেল** **ড্যানোন** দ্বারা বিক্রি করা হয়';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'যখন এর ব্র্যান্ড **একাধিক ভাষায় অনুবাদিত** সহ বিক্রি করা হয়:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**নেচার ভ্যালি** কে মাঝে মাঝে **ভ্যাল নেচার** লেখা হয়';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'নিউটেলা';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'ওরিও, মন্ডেলেজ';

  @override
  String get quantity => 'পরিমাণ এবং ওজন';

  @override
  String get add_basic_details_quantity_hint =>
      'ওজন এবং প্রয়োজনে পরিমাণ লিখুন (যেমন: ৪x১০০ গ্রাম)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'ভালো অভ্যাস: পরিমাণ';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'পণ্যের গায়ে নির্দেশিত মানটি কপি করুন এবং **ইউনিটগুলি ভুলে যাবেন না**।';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**২৩০ গ্রাম** অথবা **২৩০ গ্রাম**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**৬** (৬টি ডিমের জন্য)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**৩ x ১৫০ গ্রাম**\n(৩টি বাক্স বিশিষ্ট পণ্যের জন্য, প্রতিটি ১৫০ গ্রাম)';

  @override
  String get barcode => 'বারকোড';

  @override
  String barcode_barcode(String barcode) {
    return 'বারকোড: $barcode';
  }

  @override
  String get barcode_invalid_error => 'অবৈধ বারকোড';

  @override
  String get basic_details_add_success => 'মৌলিক বিবরণ সফলভাবে যোগ করা হয়েছে';

  @override
  String get basic_details_add_error =>
      'মৌলিক বিবরণ যোগ করা যাচ্ছে না। কিছুক্ষণ পরে আবার চেষ্টা করুন।';

  @override
  String get clear_search => 'আপনার অনুসন্ধান সাফ করুন';

  @override
  String get confirm_clear =>
      'তুমি তোমার সম্পূর্ণ ইতিহাস মুছে ফেলতে চলেছো: তুমি কি নিশ্চিত যে তুমি চালিয়ে যেতে চাও?';

  @override
  String get alert_clear_selected_user_list =>
      'আপনি আপনার ইতিহাস থেকে নির্বাচিত আইটেমগুলি সাফ করতে চলেছেন।';

  @override
  String get confirm_clear_selected_user_list =>
      'আপনি কি নিশ্চিত যে আপনি চালিয়ে যেতে চান?';

  @override
  String get alert_select_items_to_clear =>
      'সাফ করার জন্য এক বা একাধিক আইটেম নির্বাচন করুন';

  @override
  String confirm_clear_user_list(String name) {
    return 'আপনি এই তালিকাটি সাফ করতে চলেছেন ($name): আপনি কি নিশ্চিত যে আপনি চালিয়ে যেতে চান?';
  }

  @override
  String get confirm_delete_user_list_title => 'তালিকাটি মুছে ফেলবেন?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'তুমি \"$name\" তালিকাটি মুছে ফেলতে চলেছো।\nতুমি কি নিশ্চিত যে তুমি চালিয়ে যেতে চাও?';
  }

  @override
  String get confirm_delete_user_list_button => 'হ্যাঁ, আমি নিশ্চিত করছি।';

  @override
  String importance_label(String name, String id) {
    return '$name গুরুত্ব: $id';
  }

  @override
  String get user_list_all_title => 'তালিকা';

  @override
  String get user_list_all_empty => 'আপনার প্রথম তালিকা তৈরি করুন';

  @override
  String get product_list_select => 'একটি তালিকা নির্বাচন করুন';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count পণ্য',
      one: 'একটি পণ্য',
      zero: 'খালি তালিকা',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'তালিকা যোগ করুন';

  @override
  String get open_food_preferences_tooltip =>
      'আপনার খাবারের পছন্দগুলি সম্পাদনা করুন';

  @override
  String get add_photo_button_label => 'ছবি যোগ করুন';

  @override
  String get add_packaging_photo_button_label =>
      'যেকোনো প্যাকেজিং/পুনর্ব্যবহার সংক্রান্ত তথ্যের ছবি তুলুন';

  @override
  String get add_origin_photo_button_label => 'যেকোনো উৎস তথ্যের ছবি তুলুন';

  @override
  String get add_emb_photo_button_label =>
      'যেকোনো ট্রেসেবিলিটি কোড তথ্যের ছবি তুলুন';

  @override
  String get add_label_photo_button_label =>
      'যেকোনো লেবেল এবং সার্টিফিকেশন তথ্যের ছবি তুলুন';

  @override
  String get choose_image_source_title => 'ছবির উৎস বেছে নিন';

  @override
  String get choose_image_source_body => 'অনুগ্রহ করে একটি ছবির উৎস বেছে নিন।';

  @override
  String get gallery_source_label => 'গ্যালারি';

  @override
  String get gallery_source_access_denied_dialog_title => 'অ্যাক্সেস অস্বীকৃত';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'দুর্ভাগ্যবশত, অ্যাপ্লিকেশনটি আপনার গ্যালারি অ্যাক্সেস করতে পারছে না, কারণ আপনি আগে অনুমতি প্রত্যাখ্যান করেছেন।\n\nঅনুগ্রহ করে আপনার ফোনের সেটিংস -> ফটোতে অ্যাপ সেটিংসে যান।';

  @override
  String get gallery_source_access_denied_dialog_button => 'সেটিংস খুলুন';

  @override
  String get share => 'শেয়ার';

  @override
  String share_product_text(String url) {
    return 'ওপেন ফুড ফ্যাক্টস-এ এই পণ্যটি দেখুন: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'ওপেন বিউটি ফ্যাক্টস-এ এই পণ্যটি দেখুন: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'ওপেন পেটফুড ফ্যাক্টস-এ এই পণ্যটি দেখুন: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'ওপেন প্রোডাক্টস ফ্যাক্টস-এ এই পণ্যটি দেখুন: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'ওপেন ফুড ফ্যাক্টস-এ আমার পণ্যের তালিকাটি দেখুন: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'একটি ছবি নিন';

  @override
  String get choose_from_gallery => 'গ্যালারি থেকে বেছে নিন';

  @override
  String get image_upload_queued =>
      'ছবিটি যত তাড়াতাড়ি সম্ভব ব্যাকগ্রাউন্ডে আপলোড করা হবে।';

  @override
  String get add_price_queued => 'দাম যত তাড়াতাড়ি সম্ভব সার্ভারে পাঠানো হবে।';

  @override
  String get background_task_title_full_refresh =>
      'স্থানীয়ভাবে সংরক্ষিত সমস্ত পণ্যের রিফ্রেশ শুরু করা হচ্ছে';

  @override
  String get background_task_title_folksonomy =>
      'স্থানীয়ভাবে সংরক্ষিত লোকসাহিত্য আপডেটের জন্য সার্ভারের ক্রিয়া সম্পাদন শুরু করা হচ্ছে';

  @override
  String get background_task_title_top_n =>
      'সর্বাধিক জনপ্রিয় পণ্যগুলির ডাউনলোড শুরু হচ্ছে';

  @override
  String get expand_nutrition_facts => 'পুষ্টি তথ্যের সারণী প্রসারিত করুন';

  @override
  String get expand_nutrition_facts_body =>
      'পুষ্টির তথ্যের তালিকাটি প্রসারিত রাখুন';

  @override
  String get expand_ingredients => 'উপাদানগুলি প্রসারিত করুন';

  @override
  String get expand_ingredients_body => 'উপাদান প্যানেলটি প্রসারিত রাখুন';

  @override
  String get no_internet_connection => 'ইন্টারনেট সংযোগ নেই';

  @override
  String get world_results_label => 'সমগ্র বিশ্ব';

  @override
  String get world_results_action =>
      'আপনার অনুসন্ধানকে সারা বিশ্বে প্রসারিত করুন';

  @override
  String get copy_to_clipboard => 'কপি';

  @override
  String get paste_from_clipboard => 'ক্লিপবোর্ড থেকে পেস্ট করুন';

  @override
  String get no_data_available_in_clipboard =>
      'আপনার ক্লিপবোর্ডে কোনও ডেটা নেই';

  @override
  String get clipboard_barcode_copy => 'ক্লিপবোর্ডে বারকোড কপি করুন';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'বারকোড $barcode ক্লিপবোর্ডে কপি করা হয়েছে!';
  }

  @override
  String get open_product_website => 'ওয়েবসাইটে এই পণ্যটি খুলুন';

  @override
  String get language_picker_label => 'তোমার ভাষা';

  @override
  String get country_picker_label => 'তোমার দেশ';

  @override
  String get currency_picker_label => 'আপনার মুদ্রা';

  @override
  String get help_with_openfoodfacts =>
      'OpenFoodFacts-এর ব্যাপারে সাহায্য করুন';

  @override
  String get product_task_background_schedule =>
      'পণ্যটি যত তাড়াতাড়ি সম্ভব ব্যাকগ্রাউন্ডে আপডেট করা হবে।';

  @override
  String get no_email_client_available_dialog_title => 'কোনও ইমেল অ্যাপ নেই!';

  @override
  String get no_email_client_available_dialog_content =>
      'অনুগ্রহ করে আমাদেরকে mobile@openfoodfacts.org ঠিকানায় ম্যানুয়ালি একটি ইমেল পাঠান।';

  @override
  String get all_images => 'সব ছবি';

  @override
  String get selected_images => 'নির্বাচিত ছবি';

  @override
  String get product_card_remove_product_tooltip => 'পণ্যটি সরান';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'নতুন বারকোড স্ক্যান করা হয়েছে: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'ক্যারোজেল থেকে সমস্ত পণ্য সরান';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'তুলনা করার জন্য অনুগ্রহ করে কমপক্ষে দুটি পণ্য স্ক্যান করুন।';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'আপনার স্ক্যান করা পণ্যগুলির তুলনা করতে ক্লিক করুন';

  @override
  String get scan_product_loading => 'তুমি\nবারকোডটি স্ক্যান করেছ:';

  @override
  String get scan_product_loading_initial =>
      'আমরা এই পণ্যটি খুঁজছি!\nঅনুগ্রহ করে কয়েক সেকেন্ড অপেক্ষা করুন…';

  @override
  String get scan_product_loading_long_request =>
      'আমরা এখনও এই পণ্যটি খুঁজছি!\nআপনার কি মনে হয় এটি লোড হতে অনেক সময় নেয়? আমরাও তাই…';

  @override
  String get scan_product_loading_unresponsive =>
      'আমরা এখনও এই পণ্যটি খুঁজছি।\nআপনি কি অনুসন্ধানটি পুনরায় শুরু করতে চান?';

  @override
  String get scan_product_loading_restart_button =>
      'অনুসন্ধান পুনরায় শুরু করুন';

  @override
  String get portion_calculator_description =>
      'একটি নির্দিষ্ট পরিমাণের জন্য পুষ্টির তথ্য গণনা করুন';

  @override
  String get portion_calculator_hint => 'পরিমাণ';

  @override
  String get portion_calculator_accessibility =>
      'পুষ্টির তথ্য গণনা করার জন্য একটি পরিমাণ ইনপুট করুন';

  @override
  String portion_calculator_error(int min, int max) {
    return 'অনুগ্রহ করে $min এবং $max g এর মধ্যে একটি পরিমাণ লিখুন';
  }

  @override
  String get portion_calculator_computation_error =>
      'তথ্য অনুপস্থিত। গণনা করা যায়নি।';

  @override
  String portion_calculator_result_title(int grams) {
    return '$grams g (অথবা ml) এর পুষ্টির তথ্য';
  }

  @override
  String get offline_data => 'অফলাইন ডেটা';

  @override
  String get ocr_image_upload_instruction =>
      'একটি ছবি আপলোড করুন যাতে এতে থাকা তথ্য স্বয়ংক্রিয়ভাবে বের করা যায়।';

  @override
  String get upload_image => 'ছবি আপলোড করুন';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'ছবি ডাউনলোড করা যায়নি';

  @override
  String get image_edit_url_error =>
      'ছবির URL সেট না করায় ছবি সম্পাদনা করা যায়নি।';

  @override
  String get user_picture_source_remember => 'আমার পছন্দ মনে রেখো।';

  @override
  String get user_picture_source_ask => 'প্রতিবার জিজ্ঞাসা করুন';

  @override
  String get robotoff_continue => 'চালিয়ে যান';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count প্রশ্ন',
      one: 'প্রশ্ন',
    );
    return 'পরবর্তী $_temp0';
  }

  @override
  String get show_password => 'পাসওয়ার্ড দেখান';

  @override
  String get owner_field_info_title => 'প্রযোজক মূল্য প্রদান করেছেন';

  @override
  String get owner_field_info_message =>
      'সেই লোগোর সাহায্যে আমরা প্রযোজকের দেওয়া তথ্য তুলে ধরি, এবং তা সম্পাদনাযোগ্য নাও হতে পারে।';

  @override
  String get owner_field_info_close_button => 'এই তথ্যটি বন্ধ করুন';

  @override
  String get owner_field_image =>
      'এই ছবিটি প্রযোজক দ্বারা সরবরাহ করা হয়েছে। এটি সম্পাদনাযোগ্য নাও হতে পারে।';

  @override
  String get edit_packagings_title => 'প্যাকেজিং উপাদান';

  @override
  String get edit_packagings_element_add => 'একটি প্যাকেজিং উপাদান যোগ করুন';

  @override
  String get edit_packagings_completed => 'প্যাকেজিং সম্পূর্ণ।';

  @override
  String edit_packagings_element_title(int index) {
    return 'প্যাকেজিং উপাদান #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'ইউনিট সংখ্যা';

  @override
  String get edit_packagings_element_hint_units =>
      'পণ্যটিতে থাকা একই আকৃতি এবং উপাদানের প্যাকেজিং ইউনিটের সংখ্যা লিখুন।';

  @override
  String get edit_packagings_element_field_shape => 'আকৃতি';

  @override
  String get edit_packagings_element_hint_shape =>
      'পুনর্ব্যবহারের নির্দেশাবলীতে তালিকাভুক্ত আকৃতির নাম লিখুন, যদি তা পাওয়া যায়, অথবা একটি আকৃতি নির্বাচন করুন।';

  @override
  String get edit_packagings_element_example_shape => 'বোতল';

  @override
  String get edit_packagings_element_field_material => 'উপাদান';

  @override
  String get edit_packagings_element_hint_material =>
      'যদি নির্দিষ্ট উপাদানটি নির্ধারণ করা যায় (ত্রিভুজের ভিতরে একটি উপাদান কোড প্রায়শই প্যাকেজিং যন্ত্রাংশে পাওয়া যায়), অথবা যদি আপনি নিশ্চিত না হন তবে একটি সাধারণ উপাদান (যেমন প্লাস্টিক বা ধাতু) লিখুন।';

  @override
  String get edit_packagings_element_example_material => 'কাচ';

  @override
  String get edit_packagings_element_field_recycling =>
      'পুনর্ব্যবহারের নির্দেশাবলী';

  @override
  String get edit_packagings_element_hint_recycling =>
      'পণ্যের তালিকায় থাকলেই কেবল পুনর্ব্যবহারের নির্দেশাবলী লিখুন।';

  @override
  String get edit_packagings_element_example_recycling => 'পুনর্ব্যবহারযোগ্য';

  @override
  String get edit_packagings_element_field_quantity =>
      'প্রতি ইউনিটে পণ্যের মোট পরিমাণ';

  @override
  String get edit_packagings_element_hint_quantity =>
      'নেট ওজন বা নেট আয়তন লিখুন এবং এককটি নির্দেশ করুন (উদাহরণস্বরূপ g বা ml)।';

  @override
  String get edit_packagings_element_field_weight =>
      'একটি খালি ইউনিটের ওজন (ছ)';

  @override
  String get edit_packagings_element_hint_weight =>
      'ওজন করার আগে অবশিষ্ট খাবার সরিয়ে ফেলুন এবং প্যাকেজিং অংশটি ধুয়ে শুকিয়ে নিন। সম্ভব হলে, 0.1 গ্রাম বা 0.01 গ্রাম নির্ভুলতার স্কেল ব্যবহার করুন।';

  @override
  String get background_task_title => 'মুলতুবি অবদান';

  @override
  String get background_task_subtitle =>
      'আপনার অবদানগুলি স্বয়ংক্রিয়ভাবে আমাদের সার্ভারে সংরক্ষিত হয়, তবে সবসময় রিয়েল-টাইমে নয়।';

  @override
  String get background_task_list_empty =>
      'কোনও মুলতুবি ব্যাকগ্রাউন্ড টাস্ক নেই';

  @override
  String get background_task_error_server_time_out => 'সার্ভারের সময়সীমা শেষ';

  @override
  String get background_task_error_no_internet =>
      'ইন্টারনেট সংযোগে ত্রুটি। পরে চেষ্টা করুন।';

  @override
  String get background_task_operation_unknown => 'অজানা অপারেশনের ধরণ';

  @override
  String get background_task_operation_details => 'বিস্তারিত পরিবর্তন';

  @override
  String get background_task_operation_image => 'ছবি আপলোড';

  @override
  String get background_task_operation_refresh =>
      'ছবি আপলোডের পরে রিফ্রেশ বিলম্বিত হচ্ছে';

  @override
  String get background_task_run_started => 'শুরু';

  @override
  String get background_task_run_not_started => 'এখনও শুরু হয়নি';

  @override
  String get background_task_run_to_be_deleted => 'মুছে ফেলা হবে';

  @override
  String get background_task_question_stop =>
      'তুমি কি যত তাড়াতাড়ি সম্ভব সেই কাজটি বন্ধ করতে চাও?';

  @override
  String get feed_back => 'প্রতিক্রিয়া';

  @override
  String get undo => 'পূর্বাবস্থায় ফেরান';

  @override
  String get copy_email_to_clip_board => 'ক্লিপবোর্ডে ইমেল কপি করুন';

  @override
  String get please_send_us_an_email_to =>
      'অনুগ্রহ করে আমাদের ম্যানুয়ালি একটি ইমেল পাঠান';

  @override
  String get email_copied_to_clip_board => 'ইমেল ক্লিপবোর্ডে কপি করা হয়েছে!';

  @override
  String get select_accent_color => 'অ্যাকসেন্ট রঙ নির্বাচন করুন';

  @override
  String get theme_amoled => 'অ্যামোলেড';

  @override
  String get color_blue => 'নীল';

  @override
  String get color_cyan => 'সায়ান';

  @override
  String get color_green => 'সবুজ';

  @override
  String get color_light_brown => 'ডিফল্ট';

  @override
  String get color_magenta => 'ম্যাজেন্টা';

  @override
  String get color_orange => 'কমলা';

  @override
  String get color_pink => 'গোলাপি';

  @override
  String get color_red => 'লাল';

  @override
  String get color_rust => 'মরিচা';

  @override
  String get color_teal => 'টিল';

  @override
  String get text_contrast_mode => 'টেক্সট কনট্রাস্ট';

  @override
  String get contrast_high => 'উচ্চ';

  @override
  String get contrast_medium => 'মাঝারি';

  @override
  String get contrast_low => 'কম';

  @override
  String get product_refresher_internet_not_found => 'পণ্যটি পাওয়া যায়নি!';

  @override
  String get product_refresher_internet_not_connected =>
      'তুমি ইন্টারনেটের সাথে সংযুক্ত নও!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'সার্ভার ডাউন ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'সার্ভার ত্রুটি ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'পণ্যটি পাওয়া যায়নি!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'আমাদের ডাটাবেসে নিম্নলিখিত বারকোড সহ কোনও পণ্য বিদ্যমান নেই: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'ইন্টারনেট সংযোগ নেই!';

  @override
  String get product_loader_network_error_message =>
      'আপনার স্মার্টফোনটি ওয়াইফাই নেটওয়ার্কে আছে কিনা অথবা মোবাইল ডেটা সক্ষম আছে কিনা তা পরীক্ষা করে দেখুন।';

  @override
  String get page_not_found_title => 'পাতাটি খুঁজে পাওয়া যায়নি!';

  @override
  String get page_not_found_button => 'হোমপেজে ফিরে যান';

  @override
  String get download_data => 'ডেটা ডাউনলোড করুন';

  @override
  String get download_top_products =>
      'তাৎক্ষণিক স্ক্যানিংয়ের জন্য আপনার দেশের সেরা ১০০০টি পণ্য ডাউনলোড করুন';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count পণ্য',
    );
    return 'তাৎক্ষণিক স্ক্যানিংয়ের জন্য আপনার দেশের শীর্ষস্থানীয় $_temp0 ডাউনলোড করুন।';
  }

  @override
  String get download_in_progress =>
      'ডেটা ডাউনলোড হচ্ছে\nএতে কিছুটা সময় লাগতে পারে';

  @override
  String downloaded_products(int num) {
    return '$num পণ্য যোগ করা হয়েছে';
  }

  @override
  String get update_offline_data => 'অফলাইন পণ্য ডেটা আপডেট করুন';

  @override
  String get update_local_database_sub =>
      'ওপেন ফুড ফ্যাক্টস থেকে সর্বশেষ তথ্য দিয়ে স্থানীয় পণ্য ডাটাবেস আপডেট করুন।';

  @override
  String get clear_local_database => 'অফলাইন পণ্য ডেটা সাফ করুন';

  @override
  String get clear_local_database_sub =>
      'জায়গা খালি করতে আপনার অ্যাপ থেকে সমস্ত স্থানীয় পণ্যের ডেটা সাফ করুন';

  @override
  String deleted_products(int num) {
    return '$num পণ্য মুছে ফেলা হয়েছে';
  }

  @override
  String get loading => 'লোড হচ্ছে…';

  @override
  String get know_more => 'আরও জানুন';

  @override
  String get offline_data_desc => 'অফলাইন ডেটা সম্পর্কে আরও জানতে ক্লিক করুন';

  @override
  String get offline_product_data_title => 'অফলাইন পণ্য ডেটা';

  @override
  String available_for_download(int num) {
    return '$num তাৎক্ষণিক স্ক্যানিংয়ের জন্য উপলব্ধ পণ্য';
  }

  @override
  String get country_selector_title => 'আপনার দেশ নির্বাচন করুন:';

  @override
  String get currency_selector_title => 'আপনার মুদ্রা নির্বাচন করুন:';

  @override
  String get language_selector_title => 'আপনার ভাষা নির্বাচন করুন:';

  @override
  String get language_selector_section_selected => 'নির্বাচিত ভাষা';

  @override
  String get language_selector_section_frequently_used => 'প্রায়শই ব্যবহৃত';

  @override
  String get action_delete_list => 'মুছুন';

  @override
  String get action_change_list => 'বর্তমান তালিকাটি পরিবর্তন করুন';

  @override
  String get product_list_create => 'তৈরি করুন';

  @override
  String get product_list_create_tooltip => 'একটি নতুন তালিকা তৈরি করুন';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score এ';

  @override
  String get nutriscore_b => 'Nutri-Score বি';

  @override
  String get nutriscore_c => 'Nutri-Score সি';

  @override
  String get nutriscore_d => 'Nutri-Score ডি';

  @override
  String get nutriscore_e => 'Nutri-Score ই';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (নতুন হিসাব)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (নতুন হিসাব)';

  @override
  String get nutriscore_unknown => 'অজানা Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula => 'অজানা Nutri-Score (নতুন হিসাব)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score প্রযোজ্য নয়';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score প্রযোজ্য নয় (নতুন হিসাব)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'সবুজ-স্কোর A';

  @override
  String get environmental_score_b_new => 'সবুজ-স্কোর বি';

  @override
  String get environmental_score_c_new => 'সবুজ-স্কোর সি';

  @override
  String get environmental_score_d_new => 'গ্রিন-স্কোর ডি';

  @override
  String get environmental_score_e_new => 'গ্রিন-স্কোর ই';

  @override
  String get environmental_score_unknown_new => 'অজানা সবুজ-স্কোর';

  @override
  String get environmental_score_not_applicable_new =>
      'গ্রিন-স্কোর প্রযোজ্য নয়';

  @override
  String get nova_group_generic_new => 'অতি-প্রক্রিয়াজাত খাবার - NOVA গ্রুপ';

  @override
  String get nova_group_1 => 'NOVA গ্রুপ ১';

  @override
  String get nova_group_2 => 'NOVA গ্রুপ ২';

  @override
  String get nova_group_3 => 'NOVA গ্রুপ ৩';

  @override
  String get nova_group_4 => 'NOVA গ্রুপ ৪';

  @override
  String get nova_group_unknown => 'অজানা NOVA গ্রুপ';

  @override
  String get nutrition_facts => 'পুষ্টির মাত্রা';

  @override
  String get faq_title_partners => 'এনজিওর অংশীদার এবং পৃষ্ঠপোষকরা';

  @override
  String get faq_title_vision =>
      'উন্মুক্ত খাদ্য তথ্য দৃষ্টি, লক্ষ্য, মূল্যবোধ এবং কর্মসূচি';

  @override
  String get faq_title_install_beauty =>
      'একটি কসমেটিক ডাটাবেস তৈরি করতে ওপেন বিউটি ফ্যাক্টস ইনস্টল করুন';

  @override
  String get faq_title_install_pet =>
      'পোষা প্রাণীর খাদ্যের ডাটাবেস তৈরি করতে ওপেন পেট ফুড ফ্যাক্টস ইনস্টল করুন';

  @override
  String get faq_title_install_product =>
      'বস্তুর আয়ু বাড়ানোর জন্য একটি পণ্য ডাটাবেস তৈরি করতে ওপেন প্রোডাক্টস ফ্যাক্টস ইনস্টল করুন।';

  @override
  String get faq_nutriscore_nutriscore => 'Nutri-Scoreের নতুন হিসাব: নতুন কী?';

  @override
  String get contact_title_pro_page =>
      'প্রো? ওপেন ফুড ফ্যাক্টস-এ আপনার পণ্য আমদানি করুন';

  @override
  String get contact_title_pro_email => 'প্রযোজক যোগাযোগ';

  @override
  String get contact_title_press_page => 'প্রেস পেজ';

  @override
  String get contact_title_press_email => 'প্রেস যোগাযোগ';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar =>
      'আমাদের কমিউনিটি ক্যালেন্ডারে সাবস্ক্রাইব করুন';

  @override
  String get hunger_games_loading_line1 => 'আমাদের কয়েক সেকেন্ড সময় দিন…';

  @override
  String get hunger_games_loading_line2 => 'আমরা প্রশ্নগুলো ডাউনলোড করছি!';

  @override
  String get hunger_games_error_label =>
      'ওহ! কিছু সমস্যা হয়েছে… এবং আমরা প্রশ্নগুলি লোড করতে পারিনি।';

  @override
  String get hunger_games_error_retry_button => 'আবার চেষ্টা করা যাক!';

  @override
  String get reorder_attribute_action => 'বৈশিষ্ট্যগুলি পুনঃক্রম করুন';

  @override
  String get link_cant_be_opened =>
      'এই লিঙ্কটি আপনার ডিভাইসে খোলা যাচ্ছে না। অনুগ্রহ করে পরীক্ষা করে নিন যে আপনার একটি ব্রাউজার ইনস্টল করা আছে।';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return '$productNameএর বিবরণ';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return '$pageName এর বিস্তারিত $productNameসহ';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'শেয়ার';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'নতুন Nutri-Score গণনা কোথায় পাবো?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score ৭টি দেশে প্রয়োগ করা হয়: ফ্রান্স, জার্মানি, বেলজিয়াম, স্পেন, লুক্সেমবার্গ, নেদারল্যান্ডস এবং সুইজারল্যান্ড।';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'ডিক্রি স্বাক্ষরের পর থেকে নির্মাতাদের কাছে সর্বাধিক **২ বছর** সময় আছে **পুরানো হিসাব প্রতিস্থাপন** করে নতুন হিসাব প্রয়োগ করার জন্য।';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'গ্রিন স্কোর কী?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'গ্রিন-স্কোর হল একটি লোগো যার লক্ষ্য হল **খাবারের পরিবেশগত প্রভাব** সম্পর্কে আপনাকে অবহিত করা।';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      '**সবচেয়ে কম প্রভাবশালী** পণ্যের জন্য রঙের কোড গাঢ় সবুজ (**A+**) থেকে **সবচেয়ে বেশি প্রভাবশালী** পণ্যের জন্য গাঢ় লাল (**F**) পর্যন্ত পরিবর্তিত হয়।';

  @override
  String get guide_greenscore_logos_caption => 'গ্রিন-স্কোর লোগো';

  @override
  String get guide_greenscore_lca_title =>
      'মূল বিষয়: জীবনচক্র মূল্যায়ন (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'খাদ্য শ্রেণীর একটি বৈজ্ঞানিক মূল্যায়ন';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'প্রতিটি পণ্য বিভাগের জন্য, Agribalyse পরিবেশগত ডাটাবেস (ADEME এবং INRAE দ্বারা ডিজাইন করা) থেকে তথ্য ব্যবহার করে একটি **বেঞ্চমার্ক** স্কোর স্থাপন করা হয়।';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**জীবনচক্র বিশ্লেষণ** হল বহু-পর্যায় এবং বহু-মানদণ্ডের পরিবেশগত মূল্যায়ন সম্পাদনের জন্য একটি প্রমিত মূল্যায়ন পদ্ধতি।';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**এটি পরিমাপ করে:**';

  @override
  String get guide_greenscore_lca_arg2_title => '৬টি উৎপাদন ধাপ';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Packaging';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title => '১৪টি পরিবেশগত প্রভাব সূচক';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'জলবায়ু পরিবর্তন/কার্বন পদচিহ্ন';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'ওজোন স্তরের ক্ষয়';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'আয়নাইজিং বিকিরণ';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'দেশ';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'পানি ও জ্বালানি ব্যবহার';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'বায়ু দূষণ';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'সামুদ্রিক ও মিঠা পানি (কণা, অ্যাসিডিফিকেশন, ইউট্রোফিকেশন)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'সম্পদের অবক্ষয়।';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'বোনাস এবং জরিমানা';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'একটি বিভাগের মধ্যে আরও ভালো পণ্যকে পুরস্কৃত করার জন্য, আমরা বিভিন্ন মানদণ্ডের উপর ভিত্তি করে **বোনাস এবং জরিমানা** প্রয়োগ করি:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**অফিসিয়াল লেবেল, লেবেল অথবা পরিবেশগত সুবিধার নিশ্চয়তা প্রদানকারী সার্টিফিকেশন** (জৈব, ন্যায্য বাণিজ্য, HVE, লেবেল রুজ, ব্লু ব্ল্যাঙ্ক কোউর, MSC/ASC) সহ পণ্যগুলিতে **বোনাস** প্রদান করা হয়।';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'প্রধান উপাদানসমূহ';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'উপাদানের উৎপত্তির উপর ভিত্তি করে একটি **বোনাস** দেওয়া হয়। এই বোনাসে **পরিবহনের উপর প্রভাব** এবং প্রতিটি উৎপাদকের দেশের **পরিবেশগত নীতি** বিবেচনা করা হয়।';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**জরিমানা** এমন পণ্যের উপর দেওয়া হয় যেগুলোতে এমন উপাদান থাকে যা জীববৈচিত্র্য এবং বাস্তুতন্ত্রের উপর উল্লেখযোগ্য **নেতিবাচক প্রভাব ফেলে**, যেমন পাম তেল, যার উৎপাদন ব্যাপক বন উজাড়ের জন্য দায়ী।';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Packaging';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**প্যাকেজিংয়ের বৃত্তাকারতা** (পুনর্ব্যবহারযোগ্য কাঁচামালের ব্যবহার এবং পুনর্ব্যবহারযোগ্যতা) এবং অতিরিক্ত প্যাকিং বিবেচনা করে **জরিমানা** গণনা করা হয়।';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'গ্রিন-স্কোর সঠিকভাবে গণনা করার জন্য, **এমন তথ্য থাকা প্রয়োজন যা প্যাকেজিংয়ে নির্দিষ্টভাবে উল্লেখ করা থাকে না** (যেমন প্রতিটি উপাদানের উৎপত্তি এবং সঠিক শতাংশ) অথবা যা খুব কমই ব্যবহারযোগ্য আকারে পাওয়া যায় (যেমন প্যাকেজিংয়ের সমস্ত উপাদানের তালিকা যেখানে ব্যবহৃত প্লাস্টিকের সুনির্দিষ্ট ধরণ রয়েছে)।';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**যখন এই তথ্য এখনও পাওয়া যায় না তখন গড় মান ব্যবহার করা হয়**, তবে আমরা এখন সকলের কাছে এই তথ্য সংগ্রহে সাহায্য করার আহ্বান জানাচ্ছি যা গ্রিন-স্কোরের জন্য খুবই কার্যকর হবে এবং অন্যান্য অনেক ব্যবহারের জন্যও কার্যকর হবে।';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'নাগরিকরা কীভাবে সাহায্য করতে পারেন?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'সকল নাগরিক আমাদের পণ্যগুলিতে উপস্থিত তথ্য সংগ্রহ এবং গঠন করতে সাহায্য করতে পারেন অথবা যে তথ্য থেকে অনুমান করা যেতে পারে, যেমন **প্যাকেজিং** সম্পর্কিত তথ্য: \"মিশন এমব্যালেজেস\": সমস্ত খাদ্য পণ্যের জন্য প্যাকেজিংয়ের একটি বৃহৎ-স্কেল সহযোগী তালিকা (ফরাসি ভাষায়)।';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'নির্মাতারা কীভাবে সাহায্য করতে পারেন';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'উৎপাদকরা আমাদের উৎপাদকদের জন্য বিনামূল্যের প্ল্যাটফর্মের মাধ্যমে সরাসরি তাদের তথ্য পাঠাতে পারেন।';

  @override
  String get guide_greenscore_better_product_title =>
      'কোন পণ্যটি গ্রহের জন্য ভালো?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'এটা বলা কঠিন হতে পারে';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'জলবায়ুর জন্য টেকসই খাদ্য নির্বাচন করা আমাদের সবচেয়ে শক্তিশালী কাজগুলির মধ্যে একটি, কারণ **আমাদের বিশ্বব্যাপী খাদ্য ব্যবস্থা সমস্ত গ্রিনহাউস গ্যাস নির্গমনের এক চতুর্থাংশেরও বেশিের জন্য দায়ী**।\n(সূত্র: পুরে এবং নেমেসেক, বিজ্ঞান, ২০১৮)।';

  @override
  String get guide_greenscore_better_product_arg2_title => 'তোমার ক্ষমতা আছে!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'সুখবর হলো, এটি আমাদের পরিবর্তন আনার একটি শক্তিশালী উপায় প্রদান করে।\n**আমরা প্রত্যেকে প্রতি বছর প্রায় ১,০০০ বার খাবার খাই**। এটি **গ্রহের জন্য একটি উন্নত ভবিষ্যত বেছে নেওয়ার** ১,০০০ সুযোগ!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'দায়িত্বশীল হতে এবং সিদ্ধান্ত নিতে সাহায্য করে';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'টেকসই খাবার নির্বাচন করা জটিল মনে হতে পারে। লেবেলগুলি বিভ্রান্তিকর এবং প্রায়শই তথ্য অনুপস্থিত থাকে। গ্রিন-স্কোরটি তৈরি করা হয়েছে এটিকে সহজ করার জন্য, যা আপনাকে খাদ্য পণ্যের জন্য **স্পষ্ট**, **বিজ্ঞান-ভিত্তিক** এবং **স্বচ্ছ** পরিবেশগত রেটিং দেয়, ঠিক যেখানে আপনার প্রয়োজন: যখন আপনি কেনাকাটা করেন।';

  @override
  String get guide_greenscore_better_product_arg4_title => 'স্বচ্ছতা';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'মালিকানাধীন লেবেলের বিপরীতে, গ্রিন-স্কোর গণনা **সম্পূর্ণ উন্মুক্ত** এবং **যে কেউ** যাচাই করতে পারে**।';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'আল্ট্রা-প্রসেসিং কী?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA গ্রুপগুলি আপনাকে খাদ্য প্রক্রিয়াকরণের স্তর সম্পর্কে অবহিত করে।';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA শ্রেণীবিভাগ খাদ্যগুলিকে **শিল্প প্রক্রিয়াকরণের মাত্রা** (সর্বনিম্ন প্রক্রিয়াজাত বা অপ্রক্রিয়াজাত খাবার, রন্ধনসম্পর্কীয় উপাদান, প্রক্রিয়াজাত খাবার, অতি-প্রক্রিয়াজাত খাবার) এর উপর ভিত্তি করে **৪টি গ্রুপে** শ্রেণীবদ্ধ করার অনুমতি দেয়।';

  @override
  String get guide_nova_logos_caption => 'NOVA লোগো';

  @override
  String get guide_nova_groups_title => '৪টি NOVA গ্রুপ';

  @override
  String get guide_nova_groups_intro =>
      '৪টি NOVA গ্রুপ আছে, সমস্যাযুক্ত গ্রুপটি হল ৪ - অতি-প্রক্রিয়াজাত খাবার।';

  @override
  String get guide_nova_groups_arg1_title =>
      'ন্যূনতম প্রক্রিয়াজাত বা অপ্রক্রিয়াজাত খাবার';

  @override
  String get guide_nova_groups_arg1_text =>
      'unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. Most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'আল্ট্রা-প্রসেসিংয়ের সমস্যাগুলি';

  @override
  String get guide_nova_explanations_arg1_title =>
      'খাদ্য উপাদানের চরম প্রক্রিয়াকরণ';

  @override
  String get guide_nova_explanations_arg1_text =>
      'অনেকগুলি **খাদ্য উপাদানগুলির আরও প্রক্রিয়াজাতকরণ** থেকে উদ্ভূত হয়, যেমন হাইড্রোজেনেটেড বা ইন্টারেস্টেরিফাইড তেল, হাইড্রোলাইজড প্রোটিন, সয়া প্রোটিন আইসোলেট, মাল্টোডেক্সট্রিন, ইনভার্ট সুগার এবং উচ্চ-ফ্রুক্টোজ কর্ন সিরাপ।';

  @override
  String get guide_nova_explanations_arg2_title =>
      'বিশুদ্ধ খাদ্য নিরাপত্তার বাইরে যাওয়া সংযোজন';

  @override
  String get guide_nova_explanations_arg2_text =>
      'অতি-প্রক্রিয়াজাত খাবারের সংযোজনগুলির মধ্যে রয়েছে এমন কিছু যা প্রক্রিয়াজাত খাবারেও ব্যবহৃত হয়, যেমন প্রিজারভেটিভ, অ্যান্টিঅক্সিডেন্ট এবং স্টেবিলাইজার। শুধুমাত্র অতি-প্রক্রিয়াজাত পণ্যগুলিতে পাওয়া সংযোজনগুলির শ্রেণীর মধ্যে রয়েছে **খাবারের সংবেদনশীল গুণাবলী অনুকরণ বা উন্নত করতে বা চূড়ান্ত পণ্যের অপ্রীতিকর দিকগুলি আড়াল করতে** ব্যবহৃত হয়। এই সংযোজনগুলির মধ্যে রয়েছে রঞ্জক এবং অন্যান্য রঙ, রঙ স্থিতিশীলকারী; স্বাদ, স্বাদ বৃদ্ধিকারী, চিনি-মুক্ত মিষ্টি; এবং প্রক্রিয়াকরণ সহায়ক যেমন কার্বনেটিং, ফার্মিং, বাল্কিং এবং অ্যান্টি-বাল্কিং এজেন্ট, ডি-ফোমিং, অ্যান্টি-কেকিং এবং গ্লেজিং এজেন্ট, ইমালসিফায়ার, সিকোয়েস্ট্র্যান্ট এবং হিউমেক্ট্যান্ট।';

  @override
  String get guide_nova_explanations_arg3_title =>
      'প্রক্রিয়াজাতকরণ যা আপনি বাড়িতে করতে পারবেন না';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**সাধারণত অনেক উপাদান একত্রিত করে চূড়ান্ত পণ্য তৈরি করতে (অতএব \'অতি-প্রক্রিয়াজাত\') **প্রক্রিয়ার একটি ক্রম ব্যবহার করা হয়**। এই প্রক্রিয়াগুলিতে বেশ কয়েকটি **কোনও ঘরোয়া সমতুল্য ছাড়াই** অন্তর্ভুক্ত থাকে, যেমন হাইড্রোজেনেশন এবং হাইড্রোলাইজেশন, এক্সট্রুশন এবং ছাঁচনির্মাণ, এবং ভাজার জন্য প্রাক-প্রক্রিয়াজাতকরণ।';

  @override
  String get guide_nova_explanations_arg4_title =>
      'অতি-প্রক্রিয়াকরণের শিকারী এবং আর্থিক দিকগুলি';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**আল্ট্রা-প্রক্রিয়াকরণের সামগ্রিক উদ্দেশ্য হল ব্র্যান্ডেড**, **সুবিধাজনক** (টেকসই, খাওয়ার জন্য প্রস্তুত), **আকর্ষণীয়** (অতি-সুস্বাদু) এবং **অত্যন্ত লাভজনক** (কম খরচের উপাদান) খাদ্য পণ্য তৈরি করা যা অন্যান্য সমস্ত খাদ্য গোষ্ঠীকে স্থানচ্যুত করার জন্য ডিজাইন করা হয়েছে। অতি-প্রক্রিয়াজাত খাদ্য পণ্যগুলি সাধারণত আকর্ষণীয়ভাবে প্যাকেজ করা হয় এবং নিবিড়ভাবে বাজারজাত করা হয়।';

  @override
  String get guide_nova_explanations_arg5_title => 'স্বাস্থ্য ঝুঁকি';

  @override
  String get guide_nova_explanations_arg5_text =>
      '২০১৮ সাল থেকে, NutriNet-Santé-এর মাধ্যমে, **অতি-প্রক্রিয়াজাত খাবার গ্রহণ এবং ক্যান্সার, হৃদরোগ এবং ডায়াবেটিসের ঝুঁকি বৃদ্ধির মধ্যে প্রথম যোগসূত্র তুলে ধরা হয়েছে**। আজ, বিশ্বব্যাপী ৯০ টিরও বেশি গবেষণা এই ফলাফলগুলি নিশ্চিত করে।\nসবচেয়ে শক্তিশালী সম্পর্ক **স্থূলতা, হৃদরোগজনিত মৃত্যুহার এবং বিষণ্ণতার লক্ষণগুলির** সাথে সম্পর্কিত। শিশুদের উপর, এর প্রভাব প্রাথমিকভাবে ওজন এবং লিপিড ভারসাম্যহীনতার উপর পরিলক্ষিত হয়।';

  @override
  String get guide_nova_explanations_arg6_title =>
      'দেশগুলি এগুলি সীমিত করার পরামর্শ দেয়';

  @override
  String get guide_nova_explanations_arg6_text =>
      'কিছু দেশ তাদের খাদ্যতালিকাগত নির্দেশিকা বা লক্ষ্যের জন্য NOVA গ্রুপ ব্যবহার করে, উদাহরণস্বরূপ:\n\n- **🇧🇷 ব্রাজিল** এর খাদ্যতালিকাগত নির্দেশিকা **প্রক্রিয়াজাত খাবারের ব্যবহার সীমিত করার** এবং অতি-প্রক্রিয়াজাত খাবার এড়িয়ে চলার পরামর্শ দেয়।\n\n- **🇫🇷 ফ্রান্স** এর ২০১৮-২০২২ সালের জনস্বাস্থ্য পুষ্টি নীতির লক্ষ্য হল **গ্রুপ ৪ এর অতি-প্রক্রিয়াজাত খাবারের ব্যবহার ২০% কমানো**।';

  @override
  String get guide_nova_share_link => 'https://world-bn.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'ওপেন ফুড ফ্যাক্টসে স্বাগতম!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'ওপেন ফুড ফ্যাক্টস কী?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'ওপেন ফুড ফ্যাক্টস হল বিশ্বজুড়ে খাদ্য পণ্যের একটি **সহযোগী**, **বিনামূল্যে**, এবং **উন্মুক্ত** ডাটাবেস।';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'আমরা বিশ্বাস করি যে প্রত্যেকেরই তাদের খাবার সম্পর্কে তথ্য পাওয়ার অধিকার থাকা উচিত। উপাদান, অ্যালার্জেন, পুষ্টির তথ্য এবং আরও অনেক কিছুর তথ্য সংগ্রহ করে, **আমরা ভোক্তাদের সচেতনভাবে পছন্দ করার ক্ষমতা প্রদান করি** এবং খাদ্য শিল্পকে **বৃহত্তর স্বচ্ছতার দিকে** চালিত করি।';

  @override
  String get guide_open_food_facts_features_title =>
      'ওপেন ফুড ফ্যাক্টসের বৈশিষ্ট্য';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'আপনার অবাঞ্ছিত উপাদানগুলির জন্য সতর্কতা পান';

  @override
  String get guide_open_food_facts_tips_title => 'দারুন ছবি তোলার টিপস';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'কি করবেন না';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'ছায়া এবং ঝলকানি এড়িয়ে চলুন।';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'কোনও ঝাপসা বা ফোকাসের বাইরের লেখা নেই।';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'লেখার কিছু অংশ কাটছাঁট করবেন না।';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'ব্যস্ত ব্যাকগ্রাউন্ড এড়িয়ে চলুন।';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'কর';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'ভালো, সমান আলো ব্যবহার করুন।';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'নিশ্চিত করুন যে লেখাটি তীক্ষ্ণ এবং পঠনযোগ্য।';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'সম্পূর্ণ উপাদানের তালিকাটি ক্যাপচার করুন।';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'পণ্যটি সমতল পৃষ্ঠে রাখুন।';

  @override
  String get guide_open_food_facts_scores_title =>
      '\"খাবারের উইকিপিডিয়া\" তৈরিতে আমাদের সাহায্য করুন।';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'পুষ্টির মানের উপর একটি স্কোর';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'অতি-প্রক্রিয়াজাত খাবার এড়িয়ে চলার জন্য একটি স্কোর';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'গ্রহের জন্য একটি স্কোর';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-bn.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'ওপেন পেট ফুড ফ্যাক্টস-এ স্বাগতম!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'ওপেন পোষা প্রাণীর খাদ্যের তথ্য কী?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'ওপেন পেট ফুড ফ্যাক্টস আমাদের লক্ষ্যকে আমাদের পশমী বন্ধুদের কাছে প্রসারিত করে! এটি বিড়াল, কুকুর এবং অন্যান্য সঙ্গীদের জন্য পোষা প্রাণীর খাদ্য পণ্যের **ডাটাবেস**।';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'আমরা **উপাদান**, **পুষ্টি বিশ্লেষণ** এবং খাওয়ানোর নির্দেশিকা সম্পর্কিত তথ্য সংগ্রহ করি যাতে পোষা প্রাণীর মালিকরা তাদের পশুর চাহিদার জন্য সেরা খাবার বেছে নিতে পারেন।';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'ওপেন পোষা প্রাণীর খাবারের তথ্যের বৈশিষ্ট্য';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'আপনার অবাঞ্ছিত উপাদানগুলির জন্য সতর্কতা পান';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'আপনার পোষা প্রাণীর কি কোন উপাদানে অ্যালার্জি আছে? আপনি অ্যাপেই কোন প্রসাধনী উপাদান এড়িয়ে চলতে হবে তার একটি তালিকা সেট করতে পারেন!';

  @override
  String get guide_open_pet_food_facts_tips_title => 'দারুন ছবি তোলার টিপস';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'কি করবেন না';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'ছায়া এবং ঝলকানি এড়িয়ে চলুন।';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'কোনও ঝাপসা বা ফোকাসের বাইরের লেখা নেই।';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'লেখার কিছু অংশ কাটছাঁট করবেন না।';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'ব্যস্ত ব্যাকগ্রাউন্ড এড়িয়ে চলুন।';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'কর';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'ভালো, সমান আলো ব্যবহার করুন।';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'নিশ্চিত করুন যে লেখাটি তীক্ষ্ণ এবং পঠনযোগ্য।';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'সম্পূর্ণ উপাদানের তালিকাটি ক্যাপচার করুন।';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'পণ্যটি সমতল পৃষ্ঠে রাখুন।';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'স্কোরিং সম্পর্কে একটি নোট';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'পোষা প্রাণীর খাবারের জন্য একটি স্কোরিং সিস্টেম তৈরি করা **এখনই অগ্রাধিকার নয়**। পদ্ধতিটি জটিল হবে, কারণ প্রজাতি, বয়স এবং স্বাস্থ্যগত অবস্থার উপর নির্ভর করে পুষ্টির চাহিদা ব্যাপকভাবে পরিবর্তিত হয়। আমরা এখনও পর্যন্ত এমন কোনও স্বাধীন বৈজ্ঞানিক দল খুঁজে পাইনি যা এই ধরণের স্কোর তৈরি করতে সক্ষম।';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-bn.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'ওপেন বিউটি ফ্যাক্টসে স্বাগতম!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'ওপেন বিউটি ফ্যাক্টস কী?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'ওপেন বিউটি ফ্যাক্টস হল **প্রসাধনী পণ্য** এর একটি সহযোগী ডাটাবেস।';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'আমাদের লক্ষ্য হল উপাদানের তালিকা বোঝা যায় যাতে আপনি **আপনার ব্যক্তিগত যত্নের জিনিসপত্রে কী আছে তা বুঝতে** পারেন। ময়েশ্চারাইজার থেকে শুরু করে মেকআপ পর্যন্ত, আমরা প্রসাধনী শিল্পে স্বচ্ছতা বৃদ্ধির জন্য উপাদান, অ্যালার্জেন এবং প্যাকেজিংয়ের তথ্য সংগ্রহ করি।';

  @override
  String get guide_open_beauty_facts_features_title =>
      'ওপেন বিউটি ফ্যাক্টসের বৈশিষ্ট্য';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'আপনার অবাঞ্ছিত উপাদানগুলির জন্য সতর্কতা পান';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'আপনার কি কোন উপাদানে অ্যালার্জি আছে? কমেডোজেন পদার্থ এড়াতে চান? বিতর্কিত উপাদান থেকে দূরে থাকতে চান? আপনি অ্যাপেই এড়িয়ে চলার জন্য প্রসাধনী উপাদানের একটি তালিকা সেট করতে পারেন!';

  @override
  String get guide_open_beauty_facts_tips_title => 'দারুন ছবি তোলার টিপস';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'কি করবেন না';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'ছায়া এবং ঝলকানি এড়িয়ে চলুন।';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'কোনও ঝাপসা বা ফোকাসের বাইরের লেখা নেই।';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'লেখার কিছু অংশ কাটছাঁট করবেন না।';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'ব্যস্ত ব্যাকগ্রাউন্ড এড়িয়ে চলুন।';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'কর';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'ভালো, সমান আলো ব্যবহার করুন।';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'নিশ্চিত করুন যে লেখাটি তীক্ষ্ণ এবং পঠনযোগ্য।';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'সম্পূর্ণ উপাদানের তালিকাটি ক্যাপচার করুন।';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'বোতলটি বাঁকা হলে যতটা প্রয়োজন ছবি তুলুন।';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'উপাদানের তালিকা দেখতে আপনাকে লেবেলটি খোসা ছাড়তে হতে পারে।';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'পণ্যটি সমতল পৃষ্ঠে রাখুন।';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'স্কোরিং সম্পর্কে একটি নোট';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'খাদ্য পণ্যের বিপরীতে, প্রসাধনী জগতে **Nutri-Score** এর মতো সর্বজনীনভাবে স্বীকৃত, সরকার-সমর্থিত স্কোরিং সিস্টেম নেই। উপাদানের প্রভাব অত্যন্ত ব্যক্তিগত হতে পারে এবং ত্বকের ধরণ, অ্যালার্জি এবং ব্যক্তিগত উদ্বেগের উপর নির্ভর করে।';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-bn.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**আমরা দামের একটি ওপেন-সোর্স ডেটাসেট ক্রাউডসোর্স করছি**। ব্যবহারকারীরা এই ওয়েব অ্যাপের মাধ্যমে অথবা অফিসিয়াল ওপেন ফুড ফ্যাক্টস মোবাইল অ্যাপের মাধ্যমে দাম যোগ করতে পারবেন। খুচরা বিক্রেতারা বা তৃতীয় পক্ষের অ্যাপগুলিও আমাদের API ব্যবহার করে অবদান রাখতে পারে।';

  @override
  String get guide_open_prices_how_arg1_title =>
      'আইলে মূল্য ট্যাগের ছবি সংগ্রহ করুন';

  @override
  String get guide_open_prices_how_arg2_title => 'রসিদের ছবি সংগ্রহ করুন';

  @override
  String get guide_open_prices_why_title => 'ওপেন ফুড ফ্যাক্টস কেন এটা করছে?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'খাদ্য ব্যবস্থা বোঝার জন্য মূল্য তথ্য অত্যন্ত গুরুত্বপূর্ণ। খাদ্যের দাম বোঝার এবং স্বাস্থ্যকর খাদ্যাভ্যাস প্রচারের ক্ষেত্রে এটি একটি গুরুত্বপূর্ণ বিষয়। মূল্য তথ্য খোলার মাধ্যমে গবেষক, সাংবাদিক এবং নাগরিকদের জন্য **ভৌগোলিকভাবে এবং সময়ের সাথে সাথে খাদ্যের দাম কীভাবে পরিবর্তিত হয় তা আরও ভালভাবে বোঝা সহজ হয়**।';

  @override
  String get guide_open_prices_why_arg1_title =>
      'সময়ের সাথে সাথে দামের বিবর্তন ট্র্যাক করুন';

  @override
  String get guide_open_prices_why_arg1_text =>
      '**দামের বিবর্তন** দেখুন: সঙ্কোচন, সস্তা মূল্যস্ফীতি, আমরা একসাথে এগুলো ট্র্যাক করতে পারি!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'আপনার কাছাকাছি দামের তুলনা করুন';

  @override
  String get guide_open_prices_why_arg2_text =>
      'আমরা যত বেশি দাম পাবো, আপনি **আপনার আশেপাশের সবচেয়ে সস্তা দোকানগুলো** খুঁজে পেতে পারবেন।';

  @override
  String get guide_open_prices_scrapping_title =>
      'আপনি কি খুচরা বিক্রেতাদের ওয়েবসাইট থেকে দাম কমানোর কথা ভেবেছিলেন?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'আপনি আমাদের API ব্যবহার করে মূল্য অবদান রাখতে পারেন।\nআপনি যদি স্কেলে মূল্য অবদান রাখতে চান, তাহলে অনুগ্রহ করে prices@openfoodfacts.org ঠিকানায় আমাদের সাথে যোগাযোগ করুন।';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'ওপেন প্রোডাক্টস ফ্যাক্টসে স্বাগতম!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'ওপেন প্রোডাক্টস ফ্যাক্টস কী?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'ওপেন প্রোডাক্টস ফ্যাক্টস হল **বারকোডযুক্ত যেকোনো পণ্যের জন্য একটি বিশাল, উন্মুক্ত ডাটাবেস, যা খাদ্য, প্রসাধনী বা পোষা প্রাণীর খাবার নয়**।';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      '**ইলেকট্রনিক্স** থেকে **খেলনা**, এবং **জামাকাপড়** থেকে **পরিষ্কারের সরঞ্জাম**, যদি বারকোড থাকে, তাহলে এটি যোগ করা যেতে পারে। এই প্রকল্পের লক্ষ্য হল দৈনন্দিন জিনিসপত্রের জন্য একটি \"ইন্টারনেট অফ থিংস\" তৈরি করা, যার মাধ্যমে সেগুলি সম্পর্কে তথ্য সর্বজনীনভাবে অ্যাক্সেসযোগ্য করা যায়।';

  @override
  String get guide_open_products_facts_features_title =>
      'ওপেন প্রোডাক্ট ফ্যাক্টসের বৈশিষ্ট্য';

  @override
  String get guide_open_products_facts_features_text =>
      'ওপেন প্রোডাক্টস ফ্যাক্টস-এর লক্ষ্য হল ভোক্তাদের তাদের বস্তুর রক্ষণাবেক্ষণ, **মেরামত**, **পুনর্ব্যবহার** অথবা তাদের একজন নতুন মালিক দেওয়ার জন্য বৃত্তাকার সমাধান প্রদানের মাধ্যমে **বস্তুর আয়ু** বৃদ্ধি করা।';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'কিছু পণ্যের জন্য কার্বন পদচিহ্ন';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**ফরাসি পরিবেশ কর্তৃপক্ষ কর্তৃক CO2 এর প্রভাব**। ADEME অনেক বিভাগের **কার্বন প্রভাব** প্রদান করে, পণ্যগুলিকে সুনির্দিষ্টভাবে শ্রেণীবদ্ধ করতে ভুলবেন না।';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'অনেক পণ্যের জন্য মেরামতযোগ্যতা সূচক';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'যখনই একটি ফরাসি মেরামতযোগ্যতা সূচক উপলব্ধ হবে, আমরা এটি প্রদর্শন করব। তাছাড়া, **আপনি ফোকসনোমি ইঞ্জিন** ব্যবহার করে ভেরিয়েবল সংগ্রহ করা শুরু করতে পারেন; যাতে আমরা ভবিষ্যতে এটি নিজেরাই পুনরায় গণনা করতে পারি, এমনকি যেসব দেশে এটি উপলব্ধ নেই সেখানেও।';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'আপনার পণ্য দান/পুনঃবিক্রয় করার উপায় খুঁজুন';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'আমরা **তৃতীয় পক্ষের সার্কুলার বান্ধব পরিষেবা** এর লিঙ্ক প্রদান করি যা আপনাকে আপনার পছন্দের পণ্যটি পেতে সাহায্য করে, একটি সেকেন্ড হ্যান্ড পণ্য হিসেবে, যাতে আপনি গ্রহের সম্পদের প্রতি আরও নম্র হতে পারেন।\nমনে রাখবেন যে আমাদের এটি করার জন্য অর্থ প্রদান করা হয় না এবং সিস্টেমটি কেবল ফ্রান্সের দুটি ওয়েবসাইটের জন্য একটি উদাহরণ হিসেবে কাজ করে। আপনি উইকিতে আরও সাইট নথিভুক্ত করে এই সিস্টেমটি প্রসারিত করতে সাহায্য করতে পারেন।';

  @override
  String get guide_open_products_facts_information_title => 'কোন তথ্য কার্যকর?';

  @override
  String get guide_open_products_facts_information_text =>
      'এত বিস্তৃত পরিসরের আইটেমের জন্য, **আমরা যে তথ্য সংগ্রহ করি তা নমনীয়**। এটি করার জন্য, **আমরা ফোকসনোমি ইঞ্জিন** তৈরি করেছি।';

  @override
  String get guide_open_products_facts_folksonomy_title => 'ফোকসনোমি ইঞ্জিন';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'ফোকসনোমি ইঞ্জিন হল এমন একটি টুল যা আপনাকে প্রাসঙ্গিক বৈশিষ্ট্য সহ পণ্যগুলি সম্পূর্ণ করতে সাহায্য করে। এটি অনুসন্ধান এবং আবিষ্কারযোগ্যতা উন্নত করতে সাহায্য করে, পাশাপাশি ভবিষ্যতে আকর্ষণীয় জিনিসগুলি গণনা এবং প্রদর্শন করতেও সাহায্য করে।';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'আপনি যেকোনো কী এবং মান যোগ করতে পারেন যেমন: **compatibility_with_5G_mobile_network: হ্যাঁ**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'আপনি সম্ভাব্য বৈশিষ্ট্যগুলির স্বয়ংক্রিয় পরামর্শ পাবেন এবং আপনার পছন্দের ধরণের পণ্যগুলিতে নতুন বৈশিষ্ট্য যুক্ত করতে এবং নথিভুক্ত করতে আপনাকে স্বাগত জানাই।';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-bn.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'খাবারের পছন্দগুলি খুলুন';

  @override
  String get guide_coming_soon_button_title => 'শীঘ্রই আসছে';

  @override
  String get guide_learn_more_subtitle => 'আরও জানতে ট্যাপ করুন';

  @override
  String get preview_badge => 'প্রিভিউ';

  @override
  String get prices_feedback_form =>
      'এই নতুন বৈশিষ্ট্য সম্পর্কে আপনার মতামত জানাতে এখানে ক্লিক করুন!';

  @override
  String get menu_button_list_actions => 'একটি অ্যাকশন বেছে নিন';

  @override
  String get error_loading_photo => 'ছবি লোড করার সময় ত্রুটি হয়েছে';

  @override
  String get photo_viewer_action_use_picture_as => '…হিসেবে ব্যবহার করুন';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'এই ছবিটি…হিসেবে ব্যবহার করুন';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'এই ছবিটি… ($language) হিসেবে ব্যবহার করুন';
  }

  @override
  String get photo_viewer_details_button => 'বিস্তারিত';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'এই ছবির বিস্তারিত';

  @override
  String get photo_viewer_details_title => 'ছবির বিস্তারিত';

  @override
  String get photo_viewer_details_contributor_title => 'Contributor';

  @override
  String get photo_viewer_details_size_title => 'আকার';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height পিক্সেল';
  }

  @override
  String get photo_viewer_details_date_title => 'তারিখ';

  @override
  String get photo_viewer_details_url_title => 'URL টি';

  @override
  String get product_page_compatibility_score => 'সামঞ্জস্যপূর্ণ';

  @override
  String get user_lists_action_multi_select => 'একাধিক-নির্বাচন';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'আপনার সামঞ্জস্যের স্কোর: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Front picture';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Ingredients picture';

  @override
  String get product_image_nutrition_accessibility_label => 'পুষ্টির ছবি';

  @override
  String get product_image_packaging_accessibility_label => 'প্যাকেজিং ছবি';

  @override
  String get product_image_other_accessibility_label => 'অন্য ছবি';

  @override
  String get product_image_outdated_message => 'এই ছবিটি পুরনো হতে পারে।';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (এই ছবিটি পুরনো হতে পারে)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (এই ছবিটি প্রযোজক দ্বারা লক করা থাকতে পারে)';
  }

  @override
  String get product_image_error => 'ছবিটি লোড করা যাচ্ছে না!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type লোড করা যাচ্ছে না (নেটওয়ার্ক ত্রুটি?)';
  }

  @override
  String get product_page_image_no_image_available => 'কোন\nছবি নেই!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'এই পণ্যের জন্য কোন ছবি উপলব্ধ নেই।';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'অ্যাকশনগুলি পুনঃক্রম করুন বা লুকান';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'অ্যাকশন সম্পাদনা করুন';

  @override
  String get product_page_action_bar_item_move_up => 'উপরে সরান';

  @override
  String get product_page_action_bar_item_move_down => 'নিচে সরান';

  @override
  String get product_page_action_bar_item_enable => 'অ্যাকশন সক্ষম করুন';

  @override
  String get product_page_action_bar_item_disable => 'অ্যাকশন অক্ষম করুন';

  @override
  String get product_page_pending_operations_banner_title =>
      'আপনার সম্পাদনাগুলি আপলোড করা হচ্ছে…';

  @override
  String get product_page_pending_operations_banner_message =>
      'এই পৃষ্ঠায় প্রদর্শিত তথ্য **এখনও আপনার পরিবর্তনগুলি প্রতিফলিত করে না**।\nঅনুগ্রহ করে কয়েক সেকেন্ড অপেক্ষা করুন…';

  @override
  String get product_add_a_language => 'একটি ভাষা যোগ করুন';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'বারকোড $barcode';
  }

  @override
  String get carousel_close_tooltip => 'ক্যারোজেল থেকে এই পণ্যটি সরিয়ে ফেলুন';

  @override
  String get carousel_unsupported_header => 'অসমর্থিত বারকোড!';

  @override
  String get carousel_unsupported_title => 'উফ!';

  @override
  String get carousel_unsupported_text =>
      'স্ক্যান করা বারকোডটি ওপেন ফুড ফ্যাক্টস দ্বারা সমর্থিত নয়!';

  @override
  String get carousel_error_header => 'ত্রুটি!';

  @override
  String get carousel_error_title => 'এটা একটা বাজে কথা!';

  @override
  String get carousel_error_text_1 =>
      'আমরা এই বারকোডের তথ্য ডাউনলোড করতে পারিনি:';

  @override
  String get carousel_error_text_2 =>
      'আপনার ইন্টারনেট সংযোগ পরীক্ষা করুন অথবা এই বোতামটি ক্লিক করুন:';

  @override
  String get carousel_error_button => 'পুনরায় চেষ্টা করুন';

  @override
  String get carousel_unknown_product_header => 'অজানা পণ্য';

  @override
  String get carousel_unknown_product_title =>
      'অভিনন্দন!\nতুমি __দুর্লভ রত্ন খুঁজে পেয়েছো!__';

  @override
  String get carousel_unknown_product_text =>
      'আমাদের সহযোগী ডাটাবেসে **৩০ লক্ষেরও বেশি পণ্য** রয়েছে, কিন্তু এই বারকোডটি বিদ্যমান নেই: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'তথ্য লোড হচ্ছে...';

  @override
  String get carousel_loading_title =>
      'আপনি এইমাত্র নিম্নলিখিত বারকোড দিয়ে একটি পণ্য স্ক্যান করেছেন:';

  @override
  String get carousel_loading_text =>
      'আমরা **৩০ লক্ষেরও বেশি পণ্যের ডাটাবেসে এটি অনুসন্ধান করছি!**';

  @override
  String get product_type_subtitle_food => 'শাকসবজি, ফলমূল, হিমায়িত খাবার…';

  @override
  String get product_type_subtitle_beauty => 'মেকআপ, সাবান, টুথপেস্ট…';

  @override
  String get product_type_subtitle_pet_food => 'কুকুর, বিড়ালের খাবার…';

  @override
  String get product_type_subtitle_product => 'স্মার্টফোন, আসবাবপত্র…';

  @override
  String get photo_field_front => 'পণ্যের ছবি';

  @override
  String get photo_field_ingredients => 'উপকরণের ছবি';

  @override
  String get photo_field_nutrition => 'পুষ্টির ছবি';

  @override
  String get photo_field_packaging => 'পুনর্ব্যবহারের নির্দেশাবলীর ছবি';

  @override
  String get photo_already_exists => 'এই ছবিটি ইতিমধ্যেই আছে';

  @override
  String get photo_missing => 'এই ছবিটি অনুপস্থিত।';

  @override
  String get date => 'তারিখ';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'পূর্ববর্তী ক্রিয়াটি পূর্বাবস্থায় ফেরান';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$locationএর একটি বিশ্ব মানচিত্র';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'ওপেনস্ট্রিটম্যাপ অবদানকারীরা';

  @override
  String get not_applicable_short => 'নিষিদ্ধ';

  @override
  String get knowledge_panel_warning_text => 'সতর্কতা';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'এই Nutri-Score প্যাকেজের থেকে আলাদা কেন?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'এর দুটি সম্ভাব্য ব্যাখ্যা আছে:\nউপাদানের তালিকা এবং/অথবা পুষ্টির তথ্য হালনাগাদ করা হয়নি।\n\nআমরা Nutri-Score (অথবা V2) এর \"নতুন গণনা\" প্রদান করি। অনুগ্রহ করে পরীক্ষা করে দেখুন যে প্যাকেজে \"নতুন গণনা\" ব্যানারটি আছে কিনা।';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'উপাদানগুলি পরীক্ষা করুন';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'পুষ্টির তথ্য পরীক্ষা করুন';

  @override
  String url_not_supported(String url) {
    return 'দুর্ভাগ্যবশত, আমরা URLটি খুলতে পারছি না:\n$url';
  }

  @override
  String get product_list_export => 'রপ্তানি';

  @override
  String get product_list_import => 'আমদানি করুন';

  @override
  String get product_footer_action_barcode => 'বারকোড দেখুন';

  @override
  String get product_footer_action_barcode_short => 'বারকোড';

  @override
  String get product_footer_action_open_website => 'ওয়েবসাইট খুলুন';

  @override
  String get product_footer_action_report => 'রিপোর্ট';

  @override
  String get product_footer_action_contributor_guide => 'সাহায্য';

  @override
  String get product_footer_action_data_quality_tags => 'ডেটার মান';

  @override
  String get product_page_tab_for_me => 'আমার জন্য';

  @override
  String get product_page_tab_website => 'ওয়েবসাইট';

  @override
  String get product_page_tab_prices => 'দাম';

  @override
  String get prices_explanation_card_title => 'দাম কেন?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** হল বিশ্বজুড়ে পণ্যের দাম সংগ্রহ এবং ভাগ করে নেওয়ার একটি প্রকল্প 🌍। Open Pricesস Open Food Facts দ্বারা তৈরি এবং রক্ষণাবেক্ষণ করা হয়।';

  @override
  String get explanation_card_learn_more_button => 'আরও জানুন';

  @override
  String get product_page_tab_folksonomy => 'ফোকসোনোমি';

  @override
  String get folksonomy_explanation_card_title =>
      'ফোকসনোমি বৈশিষ্ট্যগুলি কী কী?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'বৈশিষ্ট্যগুলি **কী-মান** ভিত্তিক।';

  @override
  String get folksonomy_explanation_card_line2 =>
      'এই বৈশিষ্ট্যগুলি যেকোনো ধরণের ব্যবহারের জন্য অবদানকারীদের দ্বারা তৈরি এবং ফাইল করা হয়।';

  @override
  String get folksonomy_action_external_link_title => 'বাহ্যিক লিঙ্ক খুলুন';

  @override
  String get folksonomy_action_external_link_warning =>
      'বহিঃসংযোগগুলি অনিরাপদ হতে পারে। আপনি কি সত্যিই এটি দেখতে চান?';

  @override
  String get prices_products_empty_title => 'কোন দাম নেই';

  @override
  String get prices_products_empty_explanation =>
      'অবদান রাখার ক্ষেত্রে প্রথম হোন!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'শীর্ষ $pageSize পণ্য (মোট: $total)';
  }

  @override
  String get app_review_title => 'তুমি কি এই অ্যাপটি উপভোগ করছো?';

  @override
  String get app_review_low => 'আরও ভালো করতে পারতাম';

  @override
  String get app_review_medium => 'খারাপ না';

  @override
  String get app_review_high => 'আমি এটা ভালোবাসি!';

  @override
  String get app_review_feedback_modal_title =>
      'আমাদের অ্যাপ্লিকেশন উন্নত করতে সাহায্য করুন';

  @override
  String get app_review_feedback_modal_content =>
      'যদি আপনার কাছে কয়েক মিনিট সময় থাকে, তাহলে আপনি কি এই ফর্মের উত্তর দিতে পারেন যাতে **ভবিষ্যতের আপডেটগুলিতে আমরা আরও উন্নতি করতে পারি**:';

  @override
  String get app_review_feedback_modal_open_form => 'ফর্মটির উত্তর দিন';

  @override
  String get app_review_feedback_modal_later => 'আমাকে পরে জিজ্ঞাসা করো।';

  @override
  String get nutrition_facts_extract_new =>
      'নতুন: আপনি ছবি থেকে স্বয়ংক্রিয়ভাবে পুষ্টি বের করতে পারবেন!';

  @override
  String get nutrition_facts_extract_button_text => 'এখনই বের করুন';

  @override
  String get nutrition_facts_extract_in_progress => 'উত্তোলন চলছে…';

  @override
  String get nutrition_facts_extract_successful => 'নিষ্কাশন সফল হয়েছে';

  @override
  String get nutrition_facts_extract_failed =>
      'ছবি থেকে পুষ্টি উপাদান বের করা যায়নি';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'পরিসংখ্যান';

  @override
  String get prices_stats_title => 'দামের পরিসংখ্যান';

  @override
  String get prices_stats_prices_section => 'দাম';

  @override
  String get prices_stats_products_section => 'পণ্য';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'বিবিধ';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'খাদ্য';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'পণ্য';

  @override
  String get prices_stats_pet_food => 'পোষা প্রাণীর খাবার';

  @override
  String get prices_stats_osm => 'ওপেনস্ট্রিটম্যাপ';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Countries';

  @override
  String get prices_stats_price_tag => 'মূল্য ট্যাগ';

  @override
  String get prices_stats_receipt => 'রসিদ';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'ওয়েবসাইট';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'এপিআই';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'সর্বশেষ আপডেট করা হয়েছে';

  @override
  String get prices_stats_error =>
      'পরিসংখ্যান লোড করার সময় একটি ত্রুটি ঘটেছে।';

  @override
  String get product_edit_robotoff_question_answered => 'প্রশ্নের উত্তর!';

  @override
  String get product_edit_robotoff_proof => 'প্রমাণ';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'দাম';

  @override
  String get preferences_prices_subtitle =>
      'আপনার দামের পছন্দগুলি পরিচালনা করুন';

  @override
  String get preferences_card_project => 'ওপেন ফুড ফ্যাক্টস প্রকল্প';

  @override
  String get preferences_contribute_title => 'সহযগীতা';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'আমার পরিসংখ্যান';

  @override
  String get preferences_contribute_subtitle =>
      'অনুবাদ করুন, আমাদের টুলগুলি উন্নত করুন…';

  @override
  String get preferences_connect_title => 'সংযোগ করুন';

  @override
  String get preferences_connect_subtitle =>
      'আমাদের সাথে যোগাযোগ করুন, অথবা সোশ্যাল মিডিয়াতে আমাদের অনুসরণ করুন';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'বিশ্বজুড়ে লক্ষ লক্ষ গ্রাহককে জানাতে আমাদের সাহায্য করুন';

  @override
  String get preferences_card_help => 'সাহায্য ও সহায়তা';

  @override
  String get preferences_faq_title => 'প্রায়শই জিজ্ঞাসিত প্রশ্নাবলী';

  @override
  String get preferences_faq_subtitle => 'আপনার প্রশ্নের উত্তর পান';

  @override
  String get logged_out => 'লগ আউট হয়েছে';

  @override
  String get preferences_app_bar_message =>
      'আমাদের সদস্যদের একজন হওয়ার জন্য আপনাকে ধন্যবাদ!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'সমস্ত পরিসংখ্যান দেখুন';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '\"$keyword\" এর জন্য $provider অনুসন্ধান করুন';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'একটি সেটিং খুঁজুন (যেমন Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'অ্যাক্সেসিবিলিটি: ইমোজি দেখান';

  @override
  String get preferences_accessibility_remove_colors =>
      'অ্যাক্সেসিবিলিটি: রঙ সরান';

  @override
  String get preferences_app_settings_products => 'পণ্য';

  @override
  String get preferences_card_about => 'সম্পর্কে';

  @override
  String get preferences_legal_information_title => 'আইনি তথ্য';

  @override
  String get preferences_legal_information_subtitle =>
      'ব্যবহারের শর্তাবলী, গোপনীয়তা নীতি, এবং আরও অনেক কিছু';

  @override
  String get preferences_terms_of_use => 'ব্যবহারের শর্তাবলী';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts হল একটি খাদ্য পণ্যের ডাটাবেস যা **সবার জন্য, সবার দ্বারা তৈরি**।\nআপনি এটি ব্যবহার করে আরও ভালো খাবারের পছন্দ করতে পারেন, এবং যেহেতু এটি **ওপেন ডেটা**, তাই যে কেউ **যেকোনো উদ্দেশ্যে এটি পুনরায় ব্যবহার করতে** পারে।';

  @override
  String get preferences_privacy_policy => 'গোপনীয়তা নীতি';

  @override
  String get preferences_licenses => 'লাইসেন্স';

  @override
  String get preferences_about_app_title => 'অ্যাপ সম্পর্কে';

  @override
  String get preferences_about_app_subtitle =>
      'প্রযুক্তিগত তথ্য, বিকাশকারীর তথ্য এবং আরও অনেক কিছু';

  @override
  String get preferences_card_information => 'তথ্য';

  @override
  String get preferences_version_number_title => 'সংস্করণ নম্বর';

  @override
  String get preferences_scanner_title => 'স্ক্যানার';

  @override
  String get preferences_app_store => 'অ্যাপ স্টোর';

  @override
  String get preferences_app_system_settings => 'সিস্টেম সেটিংস';

  @override
  String get preferences_source_code => 'সোর্স কোড অ্যাক্সেস করুন';

  @override
  String get preferences_source_code_subtitle =>
      'এবং লক্ষ লক্ষ মানুষের উপর প্রভাব ফেলতে শুরু করুন';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'সম্পূর্ণ পণ্য';

  @override
  String get preferences_tips => 'পরামর্শ';

  @override
  String get tips_discover_nutriscore => 'নতুন Nutri-Score আবিষ্কার করুন';

  @override
  String get preferences_on_off_website_subtitle =>
      'Open Food Facts ওয়েবসাইটে';

  @override
  String get preferences_manage_account_title =>
      'আমার অ্যাকাউন্ট পরিচালনা করুন';

  @override
  String get preferences_manage_account_tooltip =>
      'তোমার অ্যাকাউন্ট পরিচালনা করো';

  @override
  String get preferences_change_password_title =>
      'আমার পাসওয়ার্ড পরিবর্তন করুন';

  @override
  String get preferences_danger_zone => 'বিপদ অঞ্চল';

  @override
  String get preferences_account_deletion_subtitle =>
      'আপনার সমস্ত অবদান হারিয়ে যাবে';

  @override
  String get preferences_contributions_title => 'অবদান';

  @override
  String get preferences_dev_mode_app_settings_title => 'অ্যাপ সেটিংস';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'অফলাইনে পণ্য স্ক্যান করার খুবই পরীক্ষামূলক উপায়';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'সার্ভার থেকে সমস্ত পণ্য রিফ্রেশ করুন';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'একেবারে প্রয়োজন না হলে দয়া করে এটা করা এড়িয়ে চলুন।';

  @override
  String get preferences_dev_mode_demo_mode_title => 'ডেমো মোড';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'স্ক্যানারে কার্ড যোগ করুন';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'স্ক্যানারে ৩টি নমুনা পণ্য যোগ করে';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'ফোকসনোমি হোস্ট';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'হোস্ট: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'অ্যাক্সেসিবিলিটি পরীক্ষা-নিরীক্ষা';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'দামের জন্য একাধিক পণ্য নির্বাচন';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'ব্যবহারকারীর অর্ডার করা নলেজ প্যানেল';

  @override
  String get preferences_dev_mode_location_search_title =>
      'লোকেশন সার্চে অস্থায়ী অ্যাক্সেস';

  @override
  String get preferences_dev_mode_comparison_title =>
      '২ বা ৩টি পণ্যের পাশাপাশি তুলনা';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'পণ্য তালিকা আমদানি';

  @override
  String get preferences_faq_scores_methodologies_title => 'স্কোর এবং পদ্ধতি';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Nutri-Score কীভাবে গণনা করা হয় তা আবিষ্কার করুন';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'পদ্ধতির প্রধান পরিবর্তনগুলি আবিষ্কার করুন';

  @override
  String get preferences_faq_discover_project_title => 'Discover the project';

  @override
  String get preferences_faq_discover_off_title =>
      'Open Food তথ্য আবিষ্কার করুন।';

  @override
  String get preferences_faq_discover_obf_title =>
      'Open Beauty তথ্য আবিষ্কার করুন';

  @override
  String get preferences_faq_discover_opff_title =>
      'Open Pet Food তথ্য আবিষ্কার করুন।';

  @override
  String get preferences_faq_discover_op_title => 'Open Prices আবিষ্কার করুন';

  @override
  String get preferences_faq_discover_opf_title =>
      'ওপেন প্রোডাক্টস সম্পর্কিত তথ্য আবিষ্কার করুন।';

  @override
  String get preferences_faq_faq_title =>
      'প্রায়শই জিজ্ঞাসিত প্রশ্নাবলী - প্রায়শই জিজ্ঞাসিত প্রশ্নাবলী';

  @override
  String get preferences_faq_off_ngo_title => 'দ্য Open Food Facts এনজিও';

  @override
  String get preferences_about_information_title => 'তথ্য';

  @override
  String get preferences_connect_community_updates_title =>
      'কমিউনিটি আপডেট পান';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'অ্যাপ এবং কমিউনিটির খবরের সাথে আপডেট থাকুন';

  @override
  String get preferences_connect_community_calendar_title =>
      'আমাদের কমিউনিটি ক্যালেন্ডারে সাবস্ক্রাইব করুন';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'আমাদের ভার্চুয়াল ইভেন্টগুলির একটিতে অংশগ্রহণ করে অংশগ্রহণ করুন';

  @override
  String get preferences_connect_blog_title => 'Open Food Facts ব্লগ';

  @override
  String get preferences_connect_blog_subtitle =>
      'সর্বশেষ খবর পান, যেমন ঘটে তেমনই';

  @override
  String get preferences_connect_community_help_title =>
      'সম্প্রদায়ের কাছ থেকে সাহায্য নিন';

  @override
  String get preferences_connect_improve_app_title =>
      'অ্যাপটি উন্নত করতে আমাদের সাহায্য করুন';

  @override
  String get preferences_connect_debug_info_title => 'আমাদের ডিবাগ তথ্য পাঠান';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'বিস্তারিত ডিবাগিং তথ্য সহ আমাদের একটি ইমেল পাঠান।';

  @override
  String get preferences_connect_feedback_title =>
      'অ্যাপটি সম্পর্কে আমাদের মতামত পাঠান';

  @override
  String get preferences_connect_feedback_subtitle =>
      'অ্যাপের ভবিষ্যৎ গঠনে সাহায্য করুন';

  @override
  String get preferences_connect_survey_title => 'অ্যাপ জরিপে অংশগ্রহণ করুন';

  @override
  String get preferences_connect_survey_subtitle =>
      'আমাদের পরবর্তীতে কী তৈরি করা উচিত তা বুঝতে সাহায্য করুন';

  @override
  String get preferences_connect_professionals_title => 'পেশাদাররা';

  @override
  String get preferences_connect_pro_subtitle =>
      'সম্পূর্ণ বিনামূল্যে, ৫০০টি অ্যাপ এবং লক্ষ লক্ষ গ্রাহকের জন্য সঠিক তথ্য নিশ্চিত করে। স্ব-পরিষেবা, আপনার PIM বা স্প্রেডশিটের সাথে সামঞ্জস্যপূর্ণ (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle => 'শুরু করতে যোগাযোগ করুন';

  @override
  String get preferences_connect_press_title => 'Press';

  @override
  String get preferences_connect_press_page_subtitle =>
      'আপনার প্রতিবেদনের জন্য প্রয়োজনীয় সমস্ত উপাদান সংগ্রহ করুন।';

  @override
  String get preferences_connect_press_email_subtitle =>
      'প্রেস অনুসন্ধানের জন্য অথবা আপনার প্রতিবেদন সম্পর্কে আমাদের জানাতে যোগাযোগ করুন।';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'একজন সক্রিয় স্বেচ্ছাসেবক হয়ে উঠুন';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'উন্নয়ন, যোগাযোগ, নকশা… যেকোনো ধরণের স্বেচ্ছাসেবা বা দক্ষতা স্বাগত!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'আপনি কীভাবে অবদান রাখতে পারেন তার কয়েকটি উপায় আবিষ্কার করুন';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'মোবাইল অ্যাপ ডেভেলপমেন্ট';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'সফটওয়্যার ডেভেলপমেন্টে কীভাবে অবদান রাখবেন তা শিখুন';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'প্রতিদিনের অস্থির বিল্ড, একেবারে নতুন বৈশিষ্ট্য';

  @override
  String get preferences_contribute_local_community_title =>
      'আপনার স্থানীয় সম্প্রদায়কে বৃদ্ধি করুন';

  @override
  String get preferences_contribute_translate_subtitle =>
      'সফ্টওয়্যার, বিষয়বস্তু, উপাদান বিশ্লেষণ অনুবাদে সাহায্য করুন';

  @override
  String get preferences_contribute_share_subtitle =>
      'আপনাকে সাহায্য করার জন্য আমরা একটি ছোট টেমপ্লেট প্রস্তুত করেছি :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'আপনার দেশে খাদ্য স্বচ্ছতা বৃদ্ধির সহজ পদক্ষেপ';

  @override
  String get preferences_contribute_data_quality_title => 'ডেটার মান';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'ডেটা কোয়ালিটি টিমে যোগদান করুন';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'ডাটাবেসটি সম্পূর্ণ এবং নির্ভুল নিশ্চিত করার জন্য আমাদের প্রচেষ্টায় যোগ দিন।';

  @override
  String get preferences_contributions_products_added_title => 'যোগ করা পণ্য';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Open Food Facts-এ আমার যোগ করা নতুন পণ্য';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'আমার যেসব পণ্য সম্পূর্ণ করতে হবে';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'সমস্ত অসম্পূর্ণ পণ্য';

  @override
  String get preferences_my_contributions_prices_title => 'দাম';

  @override
  String get preferences_my_contributions_my_prices_title => 'আমার দাম';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'আমার দাম, আমার প্রমাণ…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'আপনি যে পণ্যগুলি সম্পূর্ণ করতে সাহায্য করতে পারেন';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'আপনার দেশে Nutri-Score এবং গ্রিন-স্কোর গণনা করতে সাহায্য করুন';

  @override
  String get preferences_prices_user_prices_subtitle => 'আমার জমা দেওয়া দাম';

  @override
  String get preferences_prices_proofs_subtitle => 'মূল্য ট্যাগ এবং রসিদ';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'আপনার রসিদের ছবি তুলুন এবং সংশ্লিষ্ট বারকোড স্ক্যান করুন';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'দোকানে দামের ছবি তুলুন';

  @override
  String get preferences_prices_newest_title => 'নতুন দাম';

  @override
  String get preferences_prices_newest_subtitle =>
      'Open Pricesস কমিউনিটি কর্তৃক যোগ করা সর্বশেষ দাম';

  @override
  String get preferences_prices_top_contributors_title =>
      'সবচেয়ে বেশি দাম সহ অবদানকারীরা';

  @override
  String get preferences_prices_metrics_title => 'খোলা মূল্য মেট্রিক্স';

  @override
  String get preferences_prices_metrics_subtitle =>
      'প্রকল্পের বিবর্তন অনুসরণ করুন';

  @override
  String get preferences_prices_ways_contribute_title => 'অবদান রাখার উপায়';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'AI এর সাহায্যে নিজের বা অন্যদের দ্বারা যোগ করা দাম নিশ্চিত করুন।';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'আপনার ক্যামেরা রোল থেকে দ্রুত অনেক রসিদ বা তাকের ছবি যোগ করুন';

  @override
  String get preferences_prices_challenges_title => 'মাসিক চ্যালেঞ্জ';

  @override
  String get preferences_prices_challenges_subtitle =>
      'মূল্য সংগ্রহের জন্য মাসিক বিষয়ভিত্তিক অনুসন্ধানে অংশগ্রহণ করুন';

  @override
  String get preferences_prices_loyalty_data_title =>
      'আপনার লয়্যালটি ডেটা পুনরুদ্ধার করুন';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'আপনার ডেটা কীভাবে অনুরোধ করবেন তা জানুন';

  @override
  String get preferences_page_customize_app_title => 'অ্যাপটি কাস্টমাইজ করুন';

  @override
  String get preferences_page_contribute_project_title =>
      'প্রকল্পে অবদান রাখুন';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Open Food Facts সাহায্য করার সহজ উপায়';

  @override
  String get preferences_page_faq_subtitle =>
      'প্রকল্প সম্পর্কে স্কোর পদ্ধতি, সাহায্য এবং আরও অনেক কিছু';

  @override
  String get product_edit_robotoff_positive_button => 'পরামর্শ গ্রহণ করুন';

  @override
  String get product_edit_robotoff_negative_button =>
      'পরামর্শ প্রত্যাখ্যান করুন';

  @override
  String get product_edit_robotoff_show_proof => 'প্রমাণ দেখাও';

  @override
  String get product_edit_robotoff_expand_proof => 'প্রমাণ প্রসারিত করুন';

  @override
  String get product_page_tab_raw_data => 'কাঁচা তথ্য';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'পৃষ্ঠা $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'পৃষ্ঠা $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count এর $total আইটেম';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count এর $total আইটেম';
  }

  @override
  String item_count(int count) {
    return '$count আইটেম';
  }

  @override
  String item_count_string(String count) {
    return '$count আইটেম';
  }

  @override
  String get prices_no_result => 'দামের কোনও পরিসংখ্যান পাওয়া যায়নি।';

  @override
  String get prices_error_loading_more_items =>
      'আরও আইটেম লোড করার সময় ত্রুটি হয়েছে';

  @override
  String get prices_proof_error =>
      'প্রমাণীকরণ ব্যর্থ হয়েছে, প্রমাণ সংগ্রহ করা যায়নি।';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count এর $total প্রমাণ';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count এর মধ্যে $total অবদানকারী';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count এর $total অবস্থান';
  }

  @override
  String prices_locations_count(int count) {
    return '$count অবস্থান';
  }

  @override
  String get restart_to_apply_message =>
      'পরিবর্তনগুলি প্রয়োগ করতে অ্যাপটি পুনরায় চালু করুন।';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'গ্রাফিক্যাল ইন্টারফেস';

  @override
  String get preferences_app_settings_media_title => 'মিডিয়া';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Open Food Facts ল্যাব খুলুন';

  @override
  String get preferences_root_account_title => 'হিসাব';

  @override
  String get preferences_contribute_translate_header =>
      'আপনার ভাষায় উন্মুক্ত খাদ্যের তথ্য আনুন';

  @override
  String get preferences_contribute_enroll_alpha =>
      'অ্যাপটির আলফা সংস্করণে নথিভুক্ত করুন';

  @override
  String get preferences_dev_mode_section_data => 'অবদান এবং পণ্যের তথ্য';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'ফোকসনোমি দেখাবেন না';

  @override
  String get preferences_account_title => 'হিসাব';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '$createdএ যোগ করা হয়েছে';
  }

  @override
  String get location_map_details_title => 'অবস্থানের বিবরণ';

  @override
  String get location_map_details_name => 'নাম';

  @override
  String get location_map_details_street => 'রাস্তা';

  @override
  String get location_map_details_city => 'শহর';

  @override
  String get location_map_details_postcode => 'পোস্টকোড';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'স্থানাঙ্ক';

  @override
  String get location_map_details_osm_id => 'ওএসএম আইডি';
}
