// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Belarusian (`be`).
class AppLocalizationsBe extends AppLocalizations {
  AppLocalizationsBe([String locale = 'be']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Yes';

  @override
  String get add => 'Дадаць';

  @override
  String get account_delete_message =>
      'Вы ўпэўнены, што хочаце выдаліць свой уліковы запіс?\nКалі ёсць канкрэтная прычына, паведаміце пра яе ніжэй';

  @override
  String get reason => 'Прычына';

  @override
  String get okay => 'Добра';

  @override
  String get validate => 'Праверыць';

  @override
  String get create => 'Стварыць';

  @override
  String get applyButtonText => 'Ужыць';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'Працягнуць';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'Вярнуцца ў пачатак';

  @override
  String get save => 'Save';

  @override
  String get save_confirmation => 'Вы ўпэўнены, што хочаце захаваць?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Cancel';

  @override
  String get ignore => 'Ігнараваць';

  @override
  String get close => 'Close';

  @override
  String get no => 'No';

  @override
  String get stop => 'Спыніць';

  @override
  String get finish => 'Фініш';

  @override
  String get calculate => 'Вылічыць';

  @override
  String get reset_food_prefs => 'Скінуць налады харчовых пераваг';

  @override
  String get error => 'Нешта пайшло не так';

  @override
  String get error_occurred => 'Здарылася памылка';

  @override
  String get featureInProgress =>
      'Мы яшчэ працуем над гэтай функцыяй, сачыце за абнаўленнямі';

  @override
  String get label_web => 'Адкрыць у браўзеры';

  @override
  String get learnMore => 'Даведацца больш';

  @override
  String get unknown => 'Невядома';

  @override
  String get match_very_good => 'Вельмі добры матч';

  @override
  String get match_good => 'Добрае супадзенне';

  @override
  String get match_poor => 'Дрэннае супадзенне';

  @override
  String get match_may_not => 'May not match';

  @override
  String get match_does_not => 'Не супадае';

  @override
  String get match_unknown => 'Невядомае супадзенне';

  @override
  String get match_short_very_good => 'Вельмі добры матч';

  @override
  String get match_short_good => 'Добрае супадзенне';

  @override
  String get match_short_poor => 'Дрэннае супадзенне';

  @override
  String get match_short_may_not => 'May not match';

  @override
  String get match_short_does_not => 'Не супадае';

  @override
  String get match_short_unknown => 'Невядомае супадзенне';

  @override
  String get licenses => 'Ліцэнзіі';

  @override
  String get looking_for => 'Шукаю';

  @override
  String get welcomeToOpenFoodFacts => 'Запрашаем у Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts — гэта глабальная некамерцыйная арганізацыя, якая працуе на мясцовых супольнасцях.';

  @override
  String get productDataUtility =>
      'Паглядзіце даныя аб прадуктах, якія адпавядаюць вашым перавагам.';

  @override
  String get healthCardUtility => 'Абірайце прадукты, карысныя для вас.';

  @override
  String get ecoCardUtility => 'Абірайце прадукты, карысныя для планеты.';

  @override
  String get server_error_open_new_issue =>
      'Няма адказу сервера! Вы можаце адкрыць задачу па наступнай спасылцы.';

  @override
  String get sign_in_text =>
      'Увайдзіце ў свой уліковы запіс Open Food Facts, каб захаваць свае ўклады';

  @override
  String get incorrect_credentials =>
      'Няправільнае імя карыстальніка або пароль.';

  @override
  String get password_lost_incorrect_credentials =>
      'Гэты адрас электроннай пошты або імя карыстальніка не існуе. Калі ласка, праверце свае ўліковыя дадзеныя.';

  @override
  String get password_lost_server_unavailable =>
      'У цяперашні час назіраецца запаволенне працы нашых сервераў, і мы прыносім прабачэнні за гэта. Калі ласка, паспрабуйце пазней.';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable => 'Сетка недаступная';

  @override
  String get login_result_type_server_issue =>
      'Праблема на серверы. Паспрабуйце пазней.';

  @override
  String get login_page_username_or_email =>
      'Увядзіце імя карыстальніка або электронную пошту';

  @override
  String get login_page_password_error_empty => 'Увядзіце пароль';

  @override
  String get create_account => 'Стварыць уліковы запіс';

  @override
  String get sign_in => 'Увайсці';

  @override
  String get sign_in_mandatory =>
      'Для выкарыстання гэтай функцыі вам трэба ўвайсці ў сістэму.';

  @override
  String get help_improve_country =>
      'Дапамажыце палепшыць Open Food Facts у вашай краіне';

  @override
  String get sign_out => 'Выйсці';

  @override
  String get sign_out_confirmation => 'Хочаце выйсці з уліковага запісу?';

  @override
  String get password => 'Пароль';

  @override
  String get forgot_password => 'Не памятаю пароль';

  @override
  String get forgot_password_question => 'Забыліся пароль?';

  @override
  String get view_profile => 'Паглядзець профіль';

  @override
  String get reset_password => 'Скінуць пароль';

  @override
  String get reset_password_explanation_text =>
      'Калі вы забылі пароль, увядзіце імя карыстальніка або адрас электроннай пошты, каб атрымаць інструкцыі для скіду пароля. Не забудзьце праверыць папку «Спам».';

  @override
  String get username_or_email => 'Імя карыстальніка або эл. пошта';

  @override
  String get reset_password_done =>
      'На адрас электроннай пошты, звязаны з вашым уліковым запісам, адпраўлены ліст са спасылкай для скіду пароля. Таксама праверце папку «Спам»';

  @override
  String get send_reset_password_mail => 'Змяніць пароль';

  @override
  String get enter_some_text => 'Калі ласка, увядзіце тэкст';

  @override
  String get sign_up_page_title => 'Зарэгістравацца';

  @override
  String get sign_up_page_action_button => 'Зарэгістравацца';

  @override
  String get sign_up_page_action_doing_it => 'Рэгістрацыя…';

  @override
  String get sign_up_page_action_ok =>
      'Віншуем! Ваш уліковы запіс толькі што створаны.';

  @override
  String get sign_up_page_display_name_hint => 'Імя';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Увядзіце імя, якое вы будзеце выкарыстоўваць для адлюстравання';

  @override
  String get sign_up_page_email_hint => 'Эл. пошта';

  @override
  String get sign_up_page_email_error_empty => 'Эл. пошта — абавязкова';

  @override
  String get sign_up_page_email_error_invalid => 'Памылковы адрас эл. пошты';

  @override
  String get sign_up_page_username_hint => 'Імя карыстальніка: бачнае ўсім';

  @override
  String get sign_up_page_username_error_empty => 'Увядзіце імя карыстальніка';

  @override
  String get sign_up_page_username_error_invalid =>
      'Увядзіце сапраўднае імя карыстальніка';

  @override
  String get sign_up_page_username_description =>
      'Username cannot contains spaces, caps or special characters.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Імя карыстальніка не можа змяшчаць больш $value сімвалаў';
  }

  @override
  String get sign_up_page_password_hint => 'Пароль';

  @override
  String get sign_up_page_password_error_empty => 'Увядзіце пароль';

  @override
  String get sign_up_page_password_error_invalid =>
      'Увядзіце пароль, які змяшчае прынамсі 6 сімвалаў';

  @override
  String get sign_up_page_confirm_password_hint => 'Спраўдзіць пароль';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Калі ласка, спраўдзіце пароль';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Паролі не супадаюць';

  @override
  String get sign_up_page_agree_text => 'Я згодны з Адкрытымі фактамі пра ежу';

  @override
  String get sign_up_page_terms_text =>
      'умовамі выкарыстання і ўнёску ў Open Food Facts';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Пры стварэнні ўліковага запісу згода з Умовамі выкарыстання ёсць абавязковай, аднак ананімныя ўнёскі можна па-ранейшаму рабіць праз праграму';

  @override
  String get sign_up_page_producer_checkbox =>
      'Я вытворца прадуктаў харчавання';

  @override
  String get sign_up_page_producer_hint => 'Вытворца/брэнд';

  @override
  String get sign_up_page_producer_error_empty =>
      'Калі ласка, увядзіце вытворцу або назву брэнда';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Я хачу падпісацца на рассылку Open Food Facts (Вы можаце адпісацца ў любы час)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Гэтае імя карыстальніка ўжо існуе, калі ласка, выберыце іншае.';

  @override
  String get sign_up_page_email_already_exists =>
      'ужо існуе, увайдзіце ў свой уліковы запіс або паспрабуйце з іншым адрасам электроннай пошты.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Калі ласка, укажыце сапраўдны адрас электроннай пошты.';

  @override
  String get sign_up_page_server_busy =>
      'Нам вельмі шкада, але ў нас узніклі тэхнічныя праблемы са стварэннем вашага ўліковага запісу. Паўтарыце спробу пазней.';

  @override
  String get settingsTitle => 'Settings';

  @override
  String get darkmode => 'Тэма';

  @override
  String get darkmode_dark => 'Цёмны';

  @override
  String get darkmode_light => 'Светлы';

  @override
  String get darkmode_system_default => 'Прадвызначаны сістэмай';

  @override
  String get thanks_for_contributing => 'Дзякуй за ўнёсак!';

  @override
  String get contributors_label => 'Яны распрацоўваюць праграму';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Аўтар: $name';
  }

  @override
  String get contributors_description => 'Спіс усіх аўтараў гэтага прыкладання';

  @override
  String get support => 'Падтрымка';

  @override
  String get support_join_slack =>
      'Звяртайцеся па дапамогу ў нашым канале Slack';

  @override
  String get support_via_forum => 'Звярніцеся па дапамогу на нашым форуме';

  @override
  String get support_via_email => 'Адпраўце нам электронны ліст';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Адправіць журналы праграмы?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Вы жадаеце ўключыць журналы праграмы ва ўкладанне да электроннага ліста?';

  @override
  String get termsOfUse => 'Умовы выкарыстання';

  @override
  String get legalNotices => 'Юрыдычныя паведамленні';

  @override
  String get privacy_policy => 'Палітыка прыватнасці';

  @override
  String get about_this_app => 'Аб гэтай праграме';

  @override
  String get contribute => 'Contribute';

  @override
  String get contribute_sw_development =>
      'Распрацоўка праграмнага забеспячэння';

  @override
  String get contribute_develop_text =>
      'Код для кожнага прадукту Open Food Facts даступны на GitHub. Вы можаце выкарыстоўваць код паўторна (ён з адкрытым зыходным кодам) і дапамагчы нам палепшыць яго для ўсіх на ўсёй планеце.';

  @override
  String get contribute_develop_text_2 =>
      'Вы можаце далучыцца да чата Open Food Facts у Slack, што з\'яўляецца пераважным спосабам задаваць пытанні.';

  @override
  String get contribute_develop_dev_mode_title => 'Рэжым распрацоўшчыка?';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'Актываваць рэжым распрацоўшчыка';

  @override
  String get contribute_donate_title => 'Donate';

  @override
  String get contribute_donate_header => 'Ахвяруйце Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Звярніце ўвагу, што з унутранай альфа-версіяй магчымая поўная страта дадзеных, і праграма можа стаць непрыдатнай для выкарыстання ў любы момант!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Прадукты, якія будуць завершаны';

  @override
  String get contribute_improve_header => 'Паляпшэнне';

  @override
  String get contribute_improve_text =>
      'База дадзеных — гэта аснова праекта. Дапамагчы лёгка і вельмі хутка. Вы можаце спампаваць мабільнае прыкладанне на свой тэлефон і пачаць дадаваць або паляпшаць прадукты.\n\nЗ іншага боку, вэб-сайт Open Food Facts прапануе мноства спосабаў зрабіць свой унёсак: ';

  @override
  String get contribute_translate_header => 'Перакласці';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Пачаць пераклад';

  @override
  String get contribute_translate_text =>
      '«Адкрытыя факты пра ежу» — гэта глабальны праект, які змяшчае прадукты з больш чым 160 краін. «Адкрытыя факты пра ежу» перакладзены на дзясяткі моў, і яго змест пастаянна абнаўляецца.';

  @override
  String get contribute_translate_text_2 =>
      'Пераклады — адна з ключавых задач праекта';

  @override
  String get contribute_join_skill_pool =>
      'Падзяліцеся сваімі навыкамі з Open Food Facts. Далучайцеся да каманды!';

  @override
  String get contribute_share_header =>
      'Падзяліцеся Open Food Facts са сваімі сябрамі';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Унясіце свой уклад у цэны, запытаўшы экспарт дадзеных вашых карт лаяльнасці ў адпаведнасці з GDPR';

  @override
  String get tap_to_answer => 'Націсніце тут, каб адказаць на пытанні';

  @override
  String get tap_to_answer_hint =>
      'Націсніце тут, каб адказаць на пытанні аб гэтым прадукце';

  @override
  String get robotoff_questions_loading_hint =>
      'Калі ласка, пачакайце, пакуль загружаюцца пытанні па гэтым прадукце';

  @override
  String get saving_answer => 'Захаванне вашага адказу';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Увайдзіце ў свой уліковы запіс Open Food Facts, каб атрымаць узнагароду за ваш унёсак';

  @override
  String get question_yes_button_accessibility_value => 'Адкажыце «так»';

  @override
  String get question_no_button_accessibility_value => 'Адказ без адказу';

  @override
  String get question_skip_button_accessibility_value =>
      'Прапусціць гэтае пытанне';

  @override
  String get tap_to_edit_search => 'Націсніце, каб змяніць пошук';

  @override
  String get myPreferences => 'Мае налады';

  @override
  String get account_create_message =>
      'Стварыце свой уліковы запіс і далучайцеся да суполкі Open Food Facts, каб дапамагчы пашырыць веды пра ежу па ўсім свеце!';

  @override
  String get join_us => 'Далучайцеся да нас';

  @override
  String get myPreferences_profile_title => 'Ваш профіль';

  @override
  String get myPreferences_profile_subtitle =>
      'Кіруйце сваім уліковым запісам аўтара Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Налады праграмы';

  @override
  String get myPreferences_settings_subtitle => 'Цёмны рэжым, Мовы…';

  @override
  String get myPreferences_food_title => 'Перавагі ў харчаванні';

  @override
  String get myPreferences_food_subtitle =>
      'Выберыце, якая інфармацыя пра харчаванне для вас найбольш важная.';

  @override
  String get myPreferences_food_comment =>
      'Выберыце найбольш важную для вас інфармацыю пра ежу, каб ранжыраваць ежу ў адпаведнасці з вашымі перавагамі, бачыць інфармацыю, якая вас цікавіць у першую чаргу, і атрымліваць зводку па сумяшчальнасці. Гэтыя перавагі ў ежы застаюцца на вашай прыладзе і не звязаны з вашым уліковым запісам аўтара Open Food Facts, калі ён у вас ёсць.';

  @override
  String get confirmResetPreferences => 'Скінуць налады харчовых пераваг?';

  @override
  String get myPersonalizedRanking => 'Мой персанальны рэйтынг';

  @override
  String get ranking_tab_all => 'Усе';

  @override
  String get ranking_subtitle_match_yes => 'Найлепшае спалучэнне для вас';

  @override
  String get ranking_subtitle_match_no => 'Найгоршае спалучэнне';

  @override
  String get ranking_subtitle_match_maybe => 'Невядомае супадзенне';

  @override
  String get refresh_with_new_preferences =>
      'Абнавіце спіс з вашымі новымі перавагамі';

  @override
  String get reloaded_with_new_preferences =>
      'Перазагружана з вашымі новымі перавагамі';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Сканаваць';

  @override
  String get history_navbar_label => 'Гісторыя';

  @override
  String get list_navbar_label => 'Спісы';

  @override
  String get category => 'Фільтраваць па катэгорыі';

  @override
  String get category_all => 'Усе';

  @override
  String get category_search => '(пошук па катэгорыі)';

  @override
  String get filter => 'Фільтр';

  @override
  String get scan => 'Прадукты з экрана сканавання';

  @override
  String get scan_history => 'Гісторыя сканавання';

  @override
  String get search => 'Пошук';

  @override
  String get search_product_help => 'Пошук прадукту,\nбрэнда або штрых-кода';

  @override
  String get search_filter => 'Фільтр пошуку';

  @override
  String get search_history => 'Гісторыя пошуку';

  @override
  String get search_store => 'Пошук крамы';

  @override
  String get search_store_help => 'Падказка: дадайце горад або краіну';

  @override
  String get tap_for_more => 'Націсніце, каб убачыць больш інфармацыі…';

  @override
  String get product => 'Прадукт';

  @override
  String get unknownBrand => 'Брэнд невядомы';

  @override
  String get unknownQuantity => 'Невядомая колькасць';

  @override
  String get unknownProductName => 'Назва прадукту невядома';

  @override
  String get label_refresh => 'Абнавіць';

  @override
  String get label_reload => 'Перазагрузіць';

  @override
  String get image => 'Выява';

  @override
  String get front_photo => 'Фота спераду';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (гэты малюнак можа быць састарэлым)';
  }

  @override
  String get outdated_image_short_label => 'можа быць састарэлым';

  @override
  String get ingredients => 'Ingredients';

  @override
  String get ingredients_editing_instructions =>
      'Захоўвайце першапачатковы парадак. Пазначайце працэнт, калі гэта пазначана. Падзяляйце інгрэдыенты коскай або дэфісам і выкарыстоўвайце дужкі.';

  @override
  String get ingredients_editing_error => 'Не ўдалося захаваць інгрэдыенты.';

  @override
  String get ingredients_editing_image_error =>
      'Не ўдалося атрымаць выяву новых інгрэдыентаў.';

  @override
  String get ingredients_editing_title => 'Рэдагаваць інгрэдыенты';

  @override
  String get ingredients_photo => 'Фота інгрэдыентаў';

  @override
  String get packaging_editing_instructions =>
      'Пералічыце ўсе часткі ўпакоўкі, падзеленыя коскай або пераводам радка, з указаннем іх колькасці (напрыклад, 1 ці 6), тыпу (напрыклад, бутэлька, скрынка, банка), матэрыялу (напрыклад, пластык, метал, алюміній) і, калі ёсць, іх памеру (напрыклад, 33cl) ды інструкцыі па перапрацоўцы.\nПрыклад: 1 шкляная бутэлька для перапрацоўкі, 1 пластыкавы корак для выкідання';

  @override
  String get packaging_editing_error => 'Не ўдалося захаваць упакоўку.';

  @override
  String get packaging_editing_image_error =>
      'Не ўдалося атрымаць выяву новай упакоўкі.';

  @override
  String get packaging_editing_title => 'Рэдагаваць упакоўку';

  @override
  String get nutrition => 'Харчаванне';

  @override
  String get nutrition_facts_photo => 'Фота звестак аб пажыўнасці';

  @override
  String get nutrition_facts_editing_title =>
      'Рэдагаваць інфармацыю аб харчовай каштоўнасці';

  @override
  String get packaging_information => 'Інструкцыі па перапрацоўцы';

  @override
  String get packaging_information_photo => 'Фота інструкцый па перапрацоўцы';

  @override
  String get missing_product => 'Вы знайшлі новы прадукт!';

  @override
  String get add_product_take_photos =>
      'Зрабіце фота ўпакоўкі, каб дадаць гэты прадукт у Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Калі ласка, спачатку зрабіце некалькі фота. Вы заўсёды можаце завяршыць дадаванне прадукту пазней.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'Новы прадукт';

  @override
  String get new_product_found_title => 'Знойдзены новы прадукт!';

  @override
  String get new_product_found_text =>
      'Наша сумесная база дадзеных змяшчае больш за **3 мільёны прадуктаў**, але гэты штрых-код не існуе: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'Пакінуць гэтую старонку?';

  @override
  String get new_product_leave_message =>
      'Здаецца, вы нічога не ўвялі. Вы сапраўды хочаце пакінуць гэтую старонку?';

  @override
  String get new_product_dialog_description =>
      'Калі ласка, зрабіце фота ўпакоўкі, каб дадаць гэты прадукт у нашу агульную базу дадзеных';

  @override
  String get new_product_dialog_illustration_description =>
      'Ілюстрацыя з невядомымі паказчыкамі Nutri-Score і Green Score';

  @override
  String get front_packaging_photo_button_label => 'Фота прадукту спераду';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Пацвердзіце запампоўку фота прадукту спераду';

  @override
  String get confirm_button_label => 'Пацвердзіць';

  @override
  String get send_image_button_label => 'Адправіць выяву';

  @override
  String get crop_page_action_saving => 'Захаванне выявы…';

  @override
  String get crop_page_action_cropping => 'Абрэзка выявы…';

  @override
  String get crop_page_action_local => 'Захаванне лакальнай версіі…';

  @override
  String get crop_page_action_local_failed_title => 'Ой… нешта з вашым фота!';

  @override
  String get crop_page_action_local_failed_message =>
      'Нам не ўдалося апрацаваць выяву лакальна перад адпраўкай на наш сервер. Паўтарыце спробу пазней або звяжыцеся з намі, калі праблема не знікне.';

  @override
  String get crop_page_action_retake => 'Зрабіць фота яшчэ раз';

  @override
  String get crop_page_too_small_image_title => 'Малюнак занадта маленькі!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Мінімальны памер у пікселях для загрузкі выявы складае ${expectedMinWidth}x$expectedMinHeight. Бягучая выява мае памер ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Падрыхтоўка званка да сервера…';

  @override
  String get front_packaging_photo_title => 'Фота ўпакоўкі спераду';

  @override
  String get ingredients_photo_title => 'Фота інгрэдыентаў';

  @override
  String get nutritional_facts_photo_title => 'Фота звестак аб пажыўнасці';

  @override
  String get recycling_photo_title => 'Інструкцыі па перапрацоўцы Фота';

  @override
  String get take_photo_title => 'Сфатаграфаваць';

  @override
  String get take_more_photo_title => 'Зрабіце больш здымкаў';

  @override
  String get front_photo_uploaded => 'Фота спераду запампавана';

  @override
  String get ingredients_photo_button_label => 'Фота інгрэдыентаў';

  @override
  String get ingredients_photo_uploaded => 'Фота інгрэдыентаў запампавана';

  @override
  String get nutrition_cache_loading_error =>
      'Не ўдалося загрузіць пажыўныя рэчывы з кэшу';

  @override
  String get nutritional_facts_photo_button_label =>
      'Фота звестак аб пажыўнасці';

  @override
  String get nutritional_facts_input_button_label =>
      'Увядзіце звесткі аб пажыўнасці';

  @override
  String get nutritional_facts_added => 'Звесткі аб пажыўнасці дададзены';

  @override
  String get categories_added => 'Дададзеныя катэгорыі';

  @override
  String get new_product_title_nutriscore => 'Вылічыце Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Дапамажыце нам, запоўніўшы хаця б адну катэгорыю і пазначыўшы харчовую каштоўнасць';

  @override
  String get new_product_title_environmental_score => 'Вылічыце зялёны бал';

  @override
  String get new_product_subtitle_environmental_score =>
      'Атрымайце гэта, запоўніўшы хаця б адну катэгорыю';

  @override
  String get new_product_additional_environmental_score =>
      'Зрабіце разлік «Зялёнага бала» больш дакладным з дапамогай паходжання, упакоўкі і іншага';

  @override
  String get new_product_title_nova =>
      'Вылічыце ўзровень апрацоўкі харчовых прадуктаў (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Атрымайце яго, запоўніўшы катэгорыю ежы і інгрэдыенты';

  @override
  String get new_product_desc_nova_unknown =>
      'Узровень апрацоўкі харчовых прадуктаў невядомы';

  @override
  String get new_product_title_pictures => 'Новы прадукт';

  @override
  String get new_product_title_pictures_details =>
      'Калі ласка, зрабіце наступныя фотаздымкі, а сістэма Open Food Facts падбярэ астатняе!';

  @override
  String get new_product_title_misc => 'І некаторыя асноўныя дадзеныя…';

  @override
  String new_product_done_msg(String username) {
    return 'Дзякуй за ваш унёсак «$username»!';
  }

  @override
  String get new_product_done_msg_no_user => 'Дзякуй за ваш унёсак!';

  @override
  String get new_product_done_button_label =>
      'Адкрыйце для сябе гатовы прадукт';

  @override
  String get hey_incomplete_product_message =>
      'Націсніце, каб адказаць на 3 пытанні ЗАРАЗ, каб вылічыць Nutri-Score, Green Score і Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Націсніце зараз, каб адказаць на 2 пытанні, якія дапамогуць прааналізаваць гэтую касметыку!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Націсніце зараз, каб адказаць на 3 пытанні, якія дапамогуць прааналізаваць гэты корм для хатніх жывёл!';

  @override
  String get hey_incomplete_product_message_product =>
      'Націсніце зараз, каб дапамагчы завяршыць гэты прадукт!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Фота звестак аб пажыўнасці запампавана';

  @override
  String get recycling_photo_button_label =>
      'Фота з інфармацыяй аб перапрацоўцы';

  @override
  String get recycling_photo_uploaded =>
      'Фота звестак аб перапрацоўцы запампавана';

  @override
  String get take_more_photo_button_label => 'Зрабіце больш здымкаў';

  @override
  String get other_photo_uploaded => 'Розныя фота запампаваны';

  @override
  String get retake_photo_button_label => 'Перазняць';

  @override
  String get selecting_photo => 'Выбар фота';

  @override
  String get uploading_image => 'Запампоўванне фота на сервер';

  @override
  String get uploading_image_type_front =>
      'Загрузка пярэдняй выявы ў Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Загрузка выявы інгрэдыентаў у Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Загрузка выявы харчовай каштоўнасці ў Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Загрузка выявы ўпакоўкі ў Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Загрузка іншага малюнка ў Open Food Facts';

  @override
  String get uploading_image_type_generic => 'Загрузка выявы ў Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Дадаць адсутныя інгрэдыенты';

  @override
  String get score_add_missing_packaging_image =>
      'Дадаць адсутную выяву ўпакоўкі';

  @override
  String get score_add_missing_nutrition_facts =>
      'Дадаць адсутныя звесткі аб пажыўнасці';

  @override
  String get score_add_missing_product_traces =>
      'Дадаць адсутныя сляды прадукту';

  @override
  String get score_add_missing_product_category =>
      'Дадаць адсутную катэгорыю прадукту';

  @override
  String get score_add_missing_precise_product_category =>
      'Выберыце больш дакладную катэгорыю';

  @override
  String get score_add_missing_product_countries =>
      'Дадаць адсутныя краіны паходжання прадукту';

  @override
  String get score_add_missing_product_emb =>
      'Дадаць адсутныя коды адсочвання прадуктаў';

  @override
  String get score_add_missing_product_labels =>
      'Дадаць адсутныя этыкеткі прадукту';

  @override
  String get score_add_missing_product_origins =>
      'Дадаць адсутнае паходжанне прадукту';

  @override
  String get score_add_missing_product_stores =>
      'Дадаць адсутныя крамы продажу прадукту';

  @override
  String get score_add_missing_product_brands =>
      'Дадаць адсутныя брэнды прадуктаў';

  @override
  String get score_update_nutrition_facts => 'Абнавіць звесткі аб пажыўнасці';

  @override
  String get nutrition_page_title => 'Інфармацыя пра харчовую каштоўнасць';

  @override
  String get nutrition_page_nutritional_info_title =>
      'Інфармацыя аб харчовай каштоўнасці';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Значэнні, указаныя на прадукце:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Yes';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'No';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Адкрыць фота';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Добрая практыка: інфармацыя аб харчовай каштоўнасці';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Часам інфармацыя аб харчовай каштоўнасці **не пазначана на ўпакоўцы** або ў дакуменце, які пастаўляецца з прадуктам. У гэтым выпадку, і толькі ў гэтым выпадку, вы можаце ўсталяваць значэнне **НЕ**.';

  @override
  String get nutrition_page_serving_type_label => 'Харчовая каштоўнасць:';

  @override
  String get nutrition_page_per_100g => 'на 100 г';

  @override
  String get nutrition_page_per_100g_100ml => 'на 100 г/мл';

  @override
  String get nutrition_page_per_serving => 'на порцыю';

  @override
  String get nutrition_page_add_nutrient => 'Дадайце пажыўнае рэчыва';

  @override
  String get nutrition_page_serving_size => 'Памер порцыі';

  @override
  String get nutrition_page_serving_size_hint =>
      'Увядзіце памер порцыі (напрыклад: 100 г)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Добрыя практыкі: Памер порцыі';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Гэта значэнне дапамагае **зрабіць прапарцыйны разлік кожнага пажыўнага рэчыва на порцыю**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Дазволеныя адзінкі**: кг, г, мг, мкг, унцыя, л, дл, кл, мл, вадкая унцыя, вадкая унцыя, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 г**, **60 г** або **60 Г** (пераважней першы варыянт)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 мл** або **1 л**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Няправільная адзінка вымярэння';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **гр**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Няправільныя адзінкі';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **цукерак** і 2 **печыва**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Адсутнічае адзінка';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Недапушчальны лік';

  @override
  String get nutrition_page_update_running => 'Абнаўленне прадукту на серверы…';

  @override
  String get nutrition_page_update_done => 'Прадукт абноўлены!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Выкарыстоўвайце колькасць прадукту ў якасці памеру порцыі';

  @override
  String get nutrition_page_photo_error => 'Не атрымалася загрузіць фота';

  @override
  String get more_photos => 'Больш цікавых фота';

  @override
  String get view_more_photo_button =>
      'Паглядзець усе існуючыя фатаграфіі гэтага тавару';

  @override
  String get no_product_found => 'Прадукт не знойдзены';

  @override
  String get no_location_found => 'Месцазнаходжанне не знойдзена';

  @override
  String get not_found => 'не знойдзена:';

  @override
  String get refreshing_product => 'Абнаўленне прадукту';

  @override
  String get product_refreshed => 'Прадукт абноўлены';

  @override
  String product_image_accessibility_label(String date) {
    return 'Здымак зроблены $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Выява зроблена $date. Магчыма, гэтая выява састарэла.';
  }

  @override
  String get product_image_outdated => 'Гэта выява можа быць састарэлай';

  @override
  String get product_image_outdated_explanations_title =>
      'Гэта выява можа быць састарэлай';

  @override
  String get product_image_outdated_explanations_content =>
      'Гэты здымак быў зроблены больш за год таму.\n**Калі ласка, праверце, ці актуальны ён**.\n\nГэта **проста папярэджанне**. Калі змест усё той жа, вы можаце ігнараваць гэтае паведамленне.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Замяніць фота ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Дадаць фота ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Зрабіць здымак';

  @override
  String get product_image_action_take_picture => 'Сфатаграфаваць';

  @override
  String get product_image_action_from_gallery => 'Выберыце з галерэі тэлефона';

  @override
  String get product_image_action_choose_existing_photo =>
      'Выберыце з фотаздымкаў прадуктаў';

  @override
  String get product_image_details_label => 'Інфармацыя пра фота';

  @override
  String get product_image_details_from_producer => 'Ад вытворцы';

  @override
  String get product_image_details_contributor => 'Contributor';

  @override
  String get product_image_details_contributor_producer => 'Аўтар (прадзюсар)';

  @override
  String get product_image_details_date => 'Дата';

  @override
  String get product_image_details_date_unknown => 'Невядома';

  @override
  String get homepage_main_card_logo_description =>
      'Сардэчна запрашаем на Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Адсканіруйце** штрых-код або\n**пошукайце** тавар';

  @override
  String get homepage_main_card_search_field_hint => 'Пошук прадукту';

  @override
  String get homepage_main_card_search_field_tooltip => 'Пачаць пошук';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Апошнія навіны: $news_title';
  }

  @override
  String get tagline_app_review => 'Ці падабаецца вам праграма?';

  @override
  String get tagline_app_review_button_positive => 'Мне вельмі падабаецца! 😍';

  @override
  String get tagline_app_review_button_negative => 'Не зусім…';

  @override
  String get tagline_app_review_button_later => 'Спытайце мяне пазней';

  @override
  String get tagline_feed_news_button => 'Даведайцеся больш';

  @override
  String get app_review_negative_modal_title =>
      'Вам не падабаецца наша дадатак?';

  @override
  String get app_review_negative_modal_text =>
      'Ці не маглі б вы прысвяціць некалькі секунд, каб растлумачыць нам, чаму?';

  @override
  String get app_review_negative_modal_positive_button => 'Так, безумоўна!';

  @override
  String get app_review_negative_modal_negative_button => 'No';

  @override
  String get could_not_refresh => 'Не ўдалося абнавіць прадукт';

  @override
  String get product_internet_error_modal_title => 'Узнікла памылка!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Нам не ўдалося атрымаць інфармацыю пра гэты прадукт з-за памылкі сеткі. Праверце падключэнне да Інтэрнэту і паспрабуйце яшчэ раз.\n\nУнутраная памылка:\n$error';
  }

  @override
  String get product_tags_title => 'Уласцівасці прадукту';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Няма ўласцівасцей';

  @override
  String get product_tags_explanation =>
      'Дадаючы ўласцівасці (ключ/значэнне) да прадукту, вы дапамагаеце яго ўзбагаціць.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Дадаць уласцівасці';

  @override
  String get add_edit_tags => 'Дадаць або рэдагаваць уласцівасці';

  @override
  String get edit_tag => 'Рэдагаваць уласцівасць';

  @override
  String get remove_tag => 'Выдаліць уласцівасць';

  @override
  String get tag_key => 'Маёмасць';

  @override
  String get tag_keys => 'Уласцівасці';

  @override
  String get tag_key_uneditable => 'Уласцівасць (не рэдагуецца)';

  @override
  String get tag_key_input_hint => 'Увядзіце ўласцівасць';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Увядзіце значэнне';

  @override
  String get tag_key_item => 'Уласнасць:';

  @override
  String get tag_value_item => 'Значэнне:';

  @override
  String get tag_key_explanations =>
      'Ключ павінен быць напісаны ў малым рэгістры і без прабелаў.';

  @override
  String tag_key_already_exists(String property) {
    return 'Тэг з уласцівасцю $property ужо існуе!';
  }

  @override
  String get product_internet_error =>
      'Немагчыма атрымаць інфармацыю аб гэтым прадукце з-за памылкі сеткі.';

  @override
  String get cached_results_from => 'Паказаць вынікі за:';

  @override
  String get product_search_same_category => 'Знайсці альтэрнатывы';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'Гэтую функцыю можна выкарыстоўваць толькі для тавараў з катэгорыяй.\n\nКалі ласка, адрэдагуйце тавар, каб дадаць катэгорыю.';

  @override
  String get product_improvement_add_category =>
      'Дадайце катэгорыю для разліку Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Add nutrition facts to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Дадайце інфармацыю пра харчовую каштоўнасць і катэгорыю, каб разлічыць Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-ацэнка для гэтага прадукта не можа быць разлічана, што можа быць звязана, напрыклад, з нестандартнай катэгорыяй. Калі вы гэта лічыце памылкай, звяжыцеся з намі.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Выява пажыўнасці ўстарэла: абнавіце яе.';

  @override
  String get product_improvement_origins_to_be_completed =>
      '«Зялёны бал» улічвае паходжанне інгрэдыентаў. Калі ласка, сфатаграфуйце спіс інгрэдыентаў і/або любое геаграфічнае заяўленне, альбо адрэдагуйце прадукт, каб іх можна было ўлічыць.';

  @override
  String get country_chooser_label => 'Калі ласка, выберыце краіну';

  @override
  String get currency_chooser_label => 'Калі ласка, выберыце валюту';

  @override
  String get country_change_message => 'Вы толькі што змянілі краіну.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Вы хочаце змяніць валюту з $previousCurrency на $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Калі ласка, абярыце краіну:';

  @override
  String get country_chooser_label_from_settings => 'Ваша краіна';

  @override
  String get country_selection_explanation =>
      'Некаторыя экалагічныя асаблівасці залежаць ад месцазнаходжання';

  @override
  String get product_removed_comparison => 'Прадукт выдалены з параўнання';

  @override
  String get native_app_settings => 'Налады роднай праграмы';

  @override
  String get native_app_description =>
      'Налады адкрытых сістэм для Open Food Facts';

  @override
  String get product_removed_history => 'Прадукт выдалены з гісторыі';

  @override
  String get product_removed_list => 'Тавар выдалены са спісу';

  @override
  String get product_could_not_remove => 'Не ўдалося выдаліць прадукт';

  @override
  String get no_prodcut_in_list => 'У гэтым спісе няма прадуктаў';

  @override
  String get no_product_in_section => 'У гэтым раздзеле няма прадуктаў';

  @override
  String get recently_seen_products => 'Усе прагледжаныя тавары';

  @override
  String get clear => 'Ачысціць';

  @override
  String get clear_long => 'Ачысціць спіс';

  @override
  String get really_clear => 'Вы сапраўды хочаце выдаліць гэты спіс?';

  @override
  String pct_match(Object percent) {
    return 'працэнт супадзення: $percent%';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count дзён таму',
      one: 'дзень таму',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count гадзін таму',
      one: 'гадзіну таму',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count хвілін таму',
      one: 'адну хвіліну таму',
      zero: 'менш за хвіліну таму',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count месяцаў таму',
      one: 'месяц таму',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count тыдні таму',
      one: 'тыдзень таму',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Параўнайце $count Тавары',
      one: 'Параўнайце адзін тавар',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count выбраныя тавары',
      one: 'Адзін тавараў',
      zero: 'Тавараў няма',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Параўнайце выбраныя тавары';

  @override
  String get delete_products_mode => 'Выдаліць выбраныя тавары';

  @override
  String get select_all_products_mode => 'Выбраць усе тавары';

  @override
  String get select_none_products_mode => 'Не выбіраць нічога';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle =>
      'Выберыце не менш за два прадукты';

  @override
  String get retry_button_label => 'Паўтарыць';

  @override
  String get connect_with_us => 'Звяжыцеся з намі';

  @override
  String get tiktok => 'Сачыце за намі ў TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Сачыце за намі ў Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Сачыце за намі на X (раней Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Сачыце за намі на Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Сачыце за намі на BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Блог';

  @override
  String get faq => 'Часта задаваныя пытанні';

  @override
  String get discover => 'Discover';

  @override
  String get how_to_contribute => 'Як зрабіць унёсак';

  @override
  String get hint_knowledge_panel_message =>
      'Вы можаце націснуць на любую частку карткі, каб даведацца больш аб тым, што вы бачыце. Паспрабуйце зараз!';

  @override
  String get permissions_page_title => 'Доступ да камеры';

  @override
  String get permissions_page_body1 =>
      'Для сканавання штрых-кодаў з дапамогай камеры тэлефона, аўтарызуйце доступ.';

  @override
  String get permissions_page_body2 =>
      'Калі вы перадумаеце, гэту опцыю можна ўключыць і адключыць у наладах у любы час.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'АС: Android (SDK Int: $sdkInt / Выпуск: $release)\nМадэль: $model\nПрадукт: $product\nПрылада: $device\nБрэнд:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'АС: iOS ($version)\nМадэль: $model\nЛакалізаваная мадэль: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nВерсія праграмы:$appVersion\nНумар зборкі праграмы:$appBuildNumber\nНазва пакета праграмы:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Аўтарызаваць';

  @override
  String get refuse_button_label => 'Адмовіцца';

  @override
  String get ask_me_later_button_label => 'Пазней';

  @override
  String get are_you_sure => 'Ты ўпэўнены?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Ідзіце далей на $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Вітаем!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Дадатак, які дапамагае вам выбраць ежу, карысную для **вас** і **планеты**!';

  @override
  String get onboarding_continue_button => 'Працягнуць';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Загружаецца ваш першы прыклад прадукту';

  @override
  String get onboarding_welcome_warning =>
      'Прабачце, гэта наш прыклад прадукту, вы не можаце яго рэдагаваць :)';

  @override
  String get product_list_your_ranking => 'Ваш рэйтынг';

  @override
  String get product_list_empty_icon_desc => 'Гісторыя не даступна';

  @override
  String get product_list_empty_title => 'Пачаць сканаванне';

  @override
  String get product_list_empty_message =>
      'Тут будуць з\'яўляцца адсканаваныя прадукты, і вы зможаце правяраць дэталізаваную інфармацыю пра іх';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'прадукты',
      one: 'прадукт',
      zero: 'прадукт',
    );
    return 'Абнаўленне $_temp0 у вашай гісторыі';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Прадукты',
      one: 'Прадукт',
      zero: 'Прадукт',
    );
    return '$_temp0 абнаўленне завершана';
  }

  @override
  String get product_list_compare_side_by_side => 'Параўнайце побач';

  @override
  String get loading_dialog_default_title => 'Спампоўванне даных';

  @override
  String get loading_dialog_default_error_message =>
      'Не ўдалося спампаваць даныя';

  @override
  String get account_delete => 'Выдаліць уліковы запіс';

  @override
  String get account_delete_title => 'Выдаліць мой уліковы запіс';

  @override
  String get user_profile => 'Уліковы запіс';

  @override
  String get user_profile_title_guest => 'Вітаем!';

  @override
  String get user_profile_subtitle_guest =>
      'Увайдзіце або зарэгіструйцеся, каб далучыцца да супольнасці Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Уваход у Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Сардэчна запрашаем, $id!';
  }

  @override
  String get email_subject_account_deletion => 'Выдаліць уліковы запіс';

  @override
  String email_body_account_deletion(String userId) {
    return 'Прывітанне! Калі ласка, выдаліце мой уліковы запіс Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Праграма';

  @override
  String get settings_app_data => 'Прыватнасць і адсочванне';

  @override
  String get settings_app_camera => 'Камера';

  @override
  String get settings_app_products => 'Прадукты';

  @override
  String get settings_app_miscellaneous => 'Рознае';

  @override
  String get camera_play_sound_title => 'Прайграваць гук пры сканаванні';

  @override
  String get camera_play_sound_subtitle =>
      'Пасля кожнага паспяховага сканавання гучыць сігнал';

  @override
  String get camera_window_accessibility_label =>
      'Сканіруйце штрых-код з дапамогай камеры';

  @override
  String get app_haptic_feedback_title => 'Вібрацыя і тактыльны водгук';

  @override
  String get app_haptic_feedback_subtitle =>
      'Вібрацыі пасля выканання некаторых дзеянняў (штрых-код расшыфраваны, прадукт выдалены…).';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Калі гэтая функцыя ўключана, справаздачы аб збоях аўтаматычна адпраўляюцца ў сістэму адсочвання памылак Open Food Facts, каб памылкі можна было выпраўляць і тым самым паляпшаць праграму.';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Рэдагаваць фота';

  @override
  String get permission_photo_error => 'Памылка';

  @override
  String get permission_photo_denied_title =>
      'Дазволіць выкарыстанне камеры для сканавання штрых-кодаў';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Для пашырэння досведу, дазвольце $appName доступ да камеры. Вы зможаце непасрэдна сканаваць штрых-коды.';
  }

  @override
  String get permission_photo_denied_button => 'Дазволіць';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'У доступе адмоўлена';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Паколькі раней вы адмовілі ў доступе да камеры, то цяпер павінны дазволіць гэта ўручную ў «Наладах».';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Адкрыць налады';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Cancel';

  @override
  String get permission_photo_none_found => 'Камера не выяўлена';

  @override
  String get permission_photo_denied => 'Доступ да камеры не нададзены';

  @override
  String get show_product_pictures => 'Паказаць выявы прадуктаў';

  @override
  String get edit_product_label => 'Рэдагаваць прадукт';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Загрузка вашых правак…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Вашы праўкі **адпраўляюцца ў фонавым рэжыме** (або пазней у выпадку памылкі).\nВы можаце працягнуць рэдагаванне іншых палёў прадукту.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Вашы праўкі **адпраўляюцца ў фонавым рэжыме** (або пазней у выпадку памылкі).';

  @override
  String get edit_product_label_short => 'Edit';

  @override
  String edit_product_form_item_help(String value) {
    return 'Як увесці \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Калі ласка, увядзіце непустое значэнне!';

  @override
  String get edit_product_form_item_error_existing =>
      'Гэтая каштоўнасць ужо ёсць!';

  @override
  String get edit_product_form_item_add_action_brand => 'Дадаць новы брэнд';

  @override
  String get edit_product_form_item_add_action_label => 'Дадаць новую метку';

  @override
  String get edit_product_form_item_add_action_store => 'Дадаць новую краму';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Дадаць новае паходжанне';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Дадаць новы код адсочвання';

  @override
  String get edit_product_form_item_add_action_country => 'Дадаць новую краіну';

  @override
  String get edit_product_form_item_add_action_category =>
      'Дадаць новую катэгорыю';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Дадаць новую трасіроўку';

  @override
  String get edit_product_form_item_add_suggestion => 'Дадаць прапанову';

  @override
  String get edit_product_form_item_deny_suggestion => 'Адхіліць прапанову';

  @override
  String get edit_product_form_item_details_title => 'Асноўныя звесткі';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Назва прадукту, брэнд, колькасць';

  @override
  String get edit_product_form_item_other_details_title => 'Дадатковыя звесткі';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Вэб-сайт…';

  @override
  String get edit_product_form_item_photos_title => 'Фотаздымкі';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Дадаць або абнавіць фота';

  @override
  String get edit_product_form_item_labels_title => 'Этыкеткі і сертыфікаты';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Экалагічныя знакі, знакі якасці…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Увядзіце пазнаку (напрыклад: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Добрая практыка: этыкеткі';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Любая характарыстыка прадукту, **якая з\'яўляецца фактычнай** і адрозніваецца ад іншых палёў.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Зроблена ў Бельгіі, выраблена ў Брэтані…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Багаты клятчаткай, крыніца жалеза…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Справядлівы гандаль, Макс Хавелар…';

  @override
  String get edit_product_form_item_stores_title => 'Крамы';

  @override
  String get edit_product_form_item_stores_hint => 'Увядзіце назву крамы';

  @override
  String get edit_product_form_item_stores_type => 'крама';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Добрая практыка: крамы';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Увядзіце краму, дзе вы набылі тавар.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Карфур';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Лідл';

  @override
  String get edit_product_form_item_origins_title => 'Паходжанне';

  @override
  String get edit_product_form_item_origins_hint =>
      'Увядзіце паходжанне (напрыклад: Германія)';

  @override
  String get edit_product_form_item_origins_type => 'краіна';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Добрая практыка: паходжанне';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Дадайце **любыя пазнакі паходжання, якія вы можаце знайсці на ўпакоўцы**.\nВам не трэба турбавацца аб паходжанні, пазначаным непасрэдна ў спісе інгрэдыентаў.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Ялавічына з Аргенціны';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Соя не паходзіць з Еўрапейскага Саюза';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Увядзіце краіну (напрыклад: Германія)';

  @override
  String get edit_product_form_item_countries_type => 'краіна';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Добрая практыка: Краіны';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Краіны, дзе прадукт шырока даступны** (без уліку крамаў, якія спецыялізуюцца на замежных таварах).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Коды адсочвання';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Увядзіце код (напрыклад: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'код адсочвання';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Добрая практыка: коды адсочвання';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'У гэтым раздзеле вы можаце ўвесці коды, звязаныя з **маркіроўкай упакоўкі**, **ідэнтыфікацыйнай маркіроўкай** або **маркіроўкай санітарнага стану**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Прыклады кодаў адсочвання';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Коды ЕС**, якія выкарыстоўваюцца ў Еўрапейскай супольнасці для ідэнтыфікацыі вытворцаў або ўпакоўшчыкаў прадуктаў харчавання:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: код краіны **Францыя**\n**72.264.002**: геаграфічныя дадзеныя\n**CE**: Еўрапейская супольнасць';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Коды EMB**, якія выкарыстоўваюцца ў Францыі:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'ЭМБ 72264';

  @override
  String get edit_product_form_item_traces_title => 'Traces';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'Увядзіце трасіроўку (напрыклад: соевыя бабы)';

  @override
  String get edit_product_form_item_categories_title => 'Катэгорыі';

  @override
  String get edit_product_form_item_categories_hint => 'катэгорыя';

  @override
  String get edit_product_form_item_categories_type =>
      'Увядзіце катэгорыю (напрыклад: апельсінавы сок)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Добрая практыка: Катэгорыі';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Пазначце **толькі найбольш канкрэтную катэгорыю**.\nБацькоўскія катэгорыі будуць дададзены аўтаматычна.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Адсутнічае катэгорыя?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Калі катэгорыя **недаступная ў аўтазапаўненні**, не саромейцеся дадаць яе ў любым выпадку.\nГэта дапаможа нам палепшыць Open Food Facts у вашай краіне.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Сардзіны ў аліўкавым алеі';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Апельсінавы сок з канцэнтрату';

  @override
  String get edit_product_form_item_exit_title => 'Выйсці без захавання?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Хочаце захаваць змены, перш чым пакінуць гэтую старонку?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Захаваць змены';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Адхіліць змены';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredients';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Павялічвайце і памяншайце маштаб, разводзячы і разводзячы пальцы па экране';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Павялічваць і памяншаць фота';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'З дапамогай **жэсту маштабавання сцісканнем пальцаў** вы можаце павялічваць або памяншаць маштаб фота:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Дадаць';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Спачатку ўвядзіце тэкст';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Выдаліць';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Захавайце рэдагаванне';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Адмяніць рэдагаванне';

  @override
  String get edit_product_form_item_packaging_title =>
      'Фота інструкцый па перапрацоўцы';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Інфармацыя пра харчовую каштоўнасць';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Пажыўнасць, утрыманне алкаголю…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Добрая практыка: Інфармацыя пра харчовую каштоўнасць';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Харчовая каштоўнасць';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Спачатку выберыце, ці **значэнні прадстаўлены**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Інфармацыя пра харчовую каштоўнасць';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Затым увядзіце пажыўную каштоўнасць **як паказана на ўпакоўцы**. Калі значэння няма, вы можаце націснуць на значок «Вока».';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Адсутнічае поле?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Калі запіс адсутнічае, вы можаце **націснуць на значок «Плюс»**, каб дадаць яго (напрыклад: вітамін D, магній…).';

  @override
  String get edit_product_form_save => 'Edit';

  @override
  String get edit_product_ingredients_photo_title => 'Фота інгрэдыентаў';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Фота ўпакоўкі';

  @override
  String get edit_product_packaging_list_title => 'Спіс упакоўкі';

  @override
  String get no_data_available => 'Няма дадзеных';

  @override
  String get product_field_website_title => 'Вэб-сайт';

  @override
  String get origins_editing_title => 'Рэдагаваць паходжанне';

  @override
  String get completed_basic_details_btn_text => 'Запоўніце асноўныя звесткі';

  @override
  String get not_implemented_snackbar_text => 'Яшчэ не рэалізавана';

  @override
  String get category_picker_page_appbar_text => 'Катэгорыі';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Выміце інгрэдыенты з фота';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Выманне інгрэдыентаў\nз фота';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Загрузка фота…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Чаму я бачу гэтае паведамленне?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Каб скарыстацца функцыяй «Выняць інгрэдыенты», спачатку трэба загрузіць фота.\n\nПачакайце некалькі секунд або ўвядзіце іх уручную.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Абнавіць фота';

  @override
  String get edit_packaging_extract_btn_text => 'Выміце ўпакоўку\nз фота';

  @override
  String get edit_packaging_extract_btn_text_short => 'Выняць упакоўку';

  @override
  String get edit_packaging_extracting_btn_text => 'Выманне ўпакоўкі з фота';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Загрузка фота…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Чаму я бачу гэтае паведамленне?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Каб скарыстацца функцыяй «Выняць упакоўку», спачатку трэба загрузіць фота.\n\nПачакайце некалькі секунд або ўвядзіце іх уручную.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Абнавіць фота';

  @override
  String get edit_ocr_extract_failed => 'Не ўдалося выявіць тэкст у выяве.';

  @override
  String get edit_ocr_extract_disabled_title => 'Няма фота!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Каб скарыстацца функцыяй здабывання тэксту, спачатку трэба зрабіць фота.';

  @override
  String get user_list_dialog_new_title => 'Новы спіс прадуктаў';

  @override
  String get user_list_dialog_rename_title => 'Перайменаваць спіс';

  @override
  String get user_list_subtitle_product => 'Спісы';

  @override
  String get user_list_title => 'Your lists';

  @override
  String get user_list_add_product => 'Дадайце прадукт у вашы спісы';

  @override
  String get user_list_button_new => 'Стварыць новы спіс';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Дадаць у спіс';

  @override
  String get added_to_list_msg => 'Дададзена ў спіс';

  @override
  String get user_list_popup_clear => 'Ачысціць гісторыю';

  @override
  String get user_list_popup_rename => 'Перайменаваць';

  @override
  String get user_list_name_hint => 'Мой спіс';

  @override
  String get user_list_name_error_empty => 'Назва ёсць абавязковай';

  @override
  String get user_list_name_error_already => 'Гэтая назва ўжо выкарыстоўваецца';

  @override
  String get user_list_name_error_same => 'Гэта тая ж самая назва';

  @override
  String get user_list_name_input_hint => 'Назва спісу';

  @override
  String get try_again => 'Паўтарыць спробу';

  @override
  String get there_was_an_error => 'Узнікла памылка';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Катэгорыя для $items не знойдзена';
  }

  @override
  String get camera_toggle_camera =>
      'Пераключэнне паміж задняй і пярэдняй камерамі';

  @override
  String get camera_toggle_flash => 'Уключыць або выключыць успышку камеры';

  @override
  String get camera_enable_flash => 'Уключыць успышку';

  @override
  String get camera_disable_flash => 'Адключыць успышку';

  @override
  String get camera_flash_error_dialog_title => 'Узнікла памылка!';

  @override
  String get camera_flash_error_dialog_message =>
      'Падчас змены стану ўспышкі адбылася памылка. Пераканайцеся, што ліхтарык не ўключаны на вашым смартфоне.';

  @override
  String get category_picker_no_category_found_button => 'Назад';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Націсніце, каб адкрыць у браўзеры або ў дадатку (калі ён усталяваны)';

  @override
  String get dev_preferences_screen_title => 'Рэжым распрацоўшчыка';

  @override
  String get dev_preferences_screen_subtitle =>
      'Доступ да эксперыментальных функцый і інструментаў распрацоўкі';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Перазапусціце адаптацыю';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Затым вам трэба перазапусціць праграму, каб зноў убачыць яго.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Пераключэнне паміж openfoodfacts.org (PROD) і тэставым асяроддзем';

  @override
  String get dev_preferences_test_environment_title =>
      'Параметры тэставага асяроддзя';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Базавы URL для бягучага тэставага асяроддзя: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Хост тэставага асяроддзя';

  @override
  String get dev_preferences_ml_kit_title =>
      'Выкарыстоўвайце камплект машыннага навучання';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'тады вам трэба перазапусціць гэта дадатак';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Дадатковая кнопка на старонцы прадукту';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Рэдагаваць інгрэдыенты з дапамогай кнопкі панэлі ведаў';

  @override
  String get dev_preferences_export_history_title => 'Экспартаваць гісторыю';

  @override
  String get dev_preferences_export_history_progress_error => 'выключэнне';

  @override
  String get dev_preferences_export_history_progress_found =>
      'прадукт знойдзены';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'прадукт НЕ знойдзены';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Экспартаваць гісторыю';

  @override
  String get dev_preferences_button_positive => 'Добра';

  @override
  String get dev_preferences_button_negative => 'Cancel';

  @override
  String get dev_preferences_migration_title => 'Перанос даных з V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Статус: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'поспех ці новая ўстаноўка';

  @override
  String get dev_preferences_migration_status_success => 'поспех';

  @override
  String get dev_preferences_migration_status_error => 'памылка';

  @override
  String get dev_preferences_migration_status_in_progress => 'выконваецца';

  @override
  String get dev_preferences_migration_status_required =>
      'патрабуецца (націсніце, каб пачаць)';

  @override
  String get dev_preferences_migration_status_not_started => 'невядома';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Ачысціць гісторыю і змесціць туды 3 прадукты';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Карыстальніцкі URL-адрас для навін';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL-адрас JSON-файла:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Не зададзена';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Апошняе абнаўленне: $date';
  }

  @override
  String get product_type_label_food => 'Ежа';

  @override
  String get product_type_label_beauty => 'Асабістая гігіена';

  @override
  String get product_type_label_pet_food => 'Корм для хатніх жывёл';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'Тып прадукту';

  @override
  String get product_type_selection_subtitle => 'Выберыце тып гэтага прадукту';

  @override
  String get product_type_selection_empty =>
      'Спачатку трэба выбраць тып прадукту!';

  @override
  String product_type_selection_already(String productType) {
    return 'Вы не можаце змяніць тып прадукту ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Ярлык да праграмы «Цэны» на старонцы прадукту';

  @override
  String get prices_app_button => 'Перайдзіце ў праграму «Цэны»';

  @override
  String get prices_website_button => 'Адкрыць на сайце Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Дадайце цэннікі непасрэдна з галерэі';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Пасля выбару малюнкаў вы не зможаце іх рэдагаваць!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Дазволіць супольнасці правяраць цэны, атрыманыя з дапамогай штучнага інтэлекту.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Некалькі цэннікаў';

  @override
  String get prices_bulk_proof_upload_title => 'Масавая загрузка доказаў';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Выбар файлаў';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Пачатак загрузкі';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Лакальнае капіраванне файла #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Падрыхтоўка загрузкі #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Памылка на выяве #$index/$count';
  }

  @override
  String get prices_generic_title => 'Цэны';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Дадаць $count цэны',
      one: 'Дадаць цану',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Даслаць $count цэны',
      one: 'Даслаць цану',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Дадаць элемент';

  @override
  String get prices_add_a_price => 'Дадаць цану';

  @override
  String get prices_add_a_receipt => 'Дадаць квітанцыю';

  @override
  String get prices_add_price_tags => 'Дадаць цэннікі';

  @override
  String prices_barcode_already(String barcode) {
    return 'Гэты штрых-код ($barcode) ужо ёсць у спісе!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'Пакуль няма тавару';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Шукаю $barcode';
  }

  @override
  String get prices_barcode_enter => 'Увядзіце штрых-код';

  @override
  String get prices_category_enter => 'Прадмет без штрых-кода';

  @override
  String get prices_per_kilogram => 'Кошт за кілаграм';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / кг';

  @override
  String get prices_per_unit_short => ' / адзінка';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'Дадаткова';

  @override
  String get prices_category_error_mandatory => 'Катэгорыя абавязковая';

  @override
  String get prices_barcode_reader_action => 'Счытвальнік штрых-кодаў';

  @override
  String get prices_view_prices => 'Паглядзець цэны';

  @override
  String get prices_list_title => 'Прайс-ліст';

  @override
  String get prices_list_count => 'Колькасць цэн\n';

  @override
  String get prices_list_add_new_price => 'Дадаць новую цану\n';

  @override
  String get prices_list_empty_title => 'Пакуль няма цаны!';

  @override
  String get prices_list_empty_subtitle =>
      'Дадайце першы:\nАдсканіруйце **чэк** або **цэннік**!';

  @override
  String get prices_entry_shop_not_found => 'Невядомая крама';

  @override
  String prices_entry_menu_title(String user) {
    return 'Увод цаны ад «$user»';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Паглядзець усе цэны на гэты тавар';

  @override
  String get prices_entry_menu_open_proof => 'Паглядзець доказ';

  @override
  String get prices_entry_menu_my_prices => 'Глядзіце мае іншыя цэны';

  @override
  String get prices_entry_menu_author_prices => 'Глядзіце іншыя цэны аўтара';

  @override
  String get prices_entry_menu_shop_prices => 'Глядзіце іншыя цэны з крамы';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count цэны',
      one: '1 цана',
    );
    return '$_temp0 для $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Усе $count цэны',
      one: 'Толькі адна цана',
      zero: 'Цаны пакуль няма',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Апошнія $pageSize цэны (усяго: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Кошт: $price / Крама: \"$location\" / Апублікавана $date карыстальнікам \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Адкрытыя доказы \"$user\"';
  }

  @override
  String get prices_open_proof => 'Доказ адкрытай цаны';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Усе $count доказы',
      one: 'Толькі адзін доказ',
      zero: 'Пакуль няма доказаў',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Апошнія $pageSize доказы (усяго: $total)';
  }

  @override
  String get prices_users_empty_title => 'Пакуль няма ўдзельніка!';

  @override
  String get prices_users_empty_explanation =>
      'Будзьце першым, хто дадасць цану!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Найлепшыя $pageSize аўтары (усяго: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Крамы пакуль няма!';

  @override
  String get prices_locations_empty_explanation =>
      'Будзьце першым, хто дадасць цану!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Топ $pageSize месцаў (усяго: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count доказы',
      one: 'Адзін доказ',
      zero: 'Няма доказаў',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count тавары',
      one: 'Адзін тавар',
      zero: 'Няма тавараў',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count карыстальнікаў',
      one: 'Адзін карыстальнік',
      zero: 'Няма карыстальніка',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count цэны',
      one: 'Адна цана',
      zero: 'Няма цаны',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Кошт быў дададзены раней';

  @override
  String get prices_amount_subtitle => 'Сума';

  @override
  String get prices_amount_is_discounted => 'Ці са зніжкай?';

  @override
  String get prices_amount_price_normal => 'Кошт';

  @override
  String get prices_amount_price_discounted => 'Зніжаная цана';

  @override
  String get prices_amount_price_not_discounted => 'Першапачатковая цана';

  @override
  String get prices_amount_no_product => 'Аднаго прадукту не хапае!';

  @override
  String get prices_amount_price_incorrect => 'Няправільнае значэнне';

  @override
  String get prices_amount_price_mandatory => 'Абавязковае значэнне';

  @override
  String get prices_currency_subtitle => 'Валюта';

  @override
  String get prices_date_subtitle => 'Дата';

  @override
  String get prices_location_subtitle => 'Крама';

  @override
  String get prices_location_find => 'Знайсці краму';

  @override
  String get prices_location_mandatory => 'Вам трэба выбраць краму!';

  @override
  String get prices_location_search_broader =>
      'Не змаглі знайсці тое, што шукалі? Паспрабуйце больш шырокі пошук!';

  @override
  String get prices_proof_subtitle => 'Доказ';

  @override
  String get prices_proof_empty_title => 'Пакуль няма доказаў!';

  @override
  String get prices_proof_empty_explanation =>
      'Пачніце з дадання фота **чэка** або **цэнніка**!';

  @override
  String get prices_proof_find => 'Выберыце доказ';

  @override
  String get prices_proof_change => 'Доказ змены';

  @override
  String get prices_proof_receipt => 'Квітанцыя';

  @override
  String get prices_proof_price_tag => 'Цэннік';

  @override
  String get prices_proof_mandatory => 'Вам трэба выбраць доказ!';

  @override
  String get prices_add_validation_error => 'Памылка праверкі';

  @override
  String get prices_privacy_warning_title => 'Папярэджанне аб прыватнасці';

  @override
  String get prices_unknown_product => 'Невядомы прадукт';

  @override
  String get prices_privacy_warning_main_message =>
      'Кошты **будуць публічнымі**, а таксама назва крамы, да якой яны адносяцца.\n\nГэта можа дазволіць людзям, якія ведаюць ваш псеўданім Open Food Facts:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Згадайце, у якім раёне вы жывяце';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Ведайце, што вы купляеце';

  @override
  String get prices_privacy_warning_sub_message =>
      'Калі вам гэта не падабаецца, змяніце свой псеўданім або стварыце новы ўліковы запіс Open Food Facts і ўвайдзіце ў праграму з яго дапамогай.';

  @override
  String get i_refuse => 'Я адмаўляюся';

  @override
  String get i_accept => 'Я прымаю';

  @override
  String get prices_currency_change_proposal_title => 'Змяніць валюту?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Ваша бягучая валюта — **$currency**. Вы хочаце змяніць яе на **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Так, выкарыстоўвайце $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Не, пакінуць $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Гатова';

  @override
  String get dev_mode_section_server => 'Канфігурацыя сервера';

  @override
  String get dev_mode_section_news => 'Канфігурацыя пастаўшчыка навін';

  @override
  String get dev_mode_section_product_page => 'Старонка прадукту';

  @override
  String get dev_mode_section_ui => 'Карыстальніцкі інтэрфейс';

  @override
  String get dev_mode_section_experimental_features =>
      'Эксперыментальныя функцыі';

  @override
  String get dev_mode_hide_environmental_score_title => 'Выключыць зялёны бал';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Выкарыстоўвайце праверку арфаграфіі для экранаў OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Інгрэдыенты і ўпакоўка)';

  @override
  String get dev_mode_reset_app_language_title => 'Скінуць мову праграмы';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Дадаць карты';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Пераключэнне паміж prices.openfoodfacts.org (PROD) і тэставым асяроддзем';

  @override
  String get search_history_item_edit_tooltip =>
      'Выкарыстайце і адрэдагуйце гэты пошук';

  @override
  String get search_history_item_remove_tooltip => 'Выдаліць';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Вы спампавалі ўсе прадукты: $totalSize.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Спампаваць яшчэ прадукты: $count\nУжо спампавана $downloaded з $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Выконваецца пошук $search .\n\nКалі ласка, пачакайце некалькі секунд…';
  }

  @override
  String get user_search_contributor_title => 'Прадукты, дададзеныя мною';

  @override
  String get user_search_informer_title => 'Прадукты, рэдагаваныя мною';

  @override
  String get user_search_photographer_title => 'Прадукты, сфатаграфаваныя мною';

  @override
  String get user_search_to_be_completed_title =>
      'Прадукты, недаапрацаваныя мною';

  @override
  String get user_search_prices_title => 'Мае цэны';

  @override
  String get user_search_proofs_title => 'Мае доказы';

  @override
  String get user_search_proof_title => 'Мой доказ';

  @override
  String search_proof_title(String user) {
    return 'Доказ з «$user»';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Цэны ўдзельнікаў: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Дададзены апошнія цэны';

  @override
  String get all_search_prices_top_user_title => 'Найбольшыя ўнёскі ў цэны';

  @override
  String get all_search_prices_top_location_title =>
      'Крамы з самымі высокімі цэнамі';

  @override
  String get prices_contribution_assistant => 'Памочнік па ўнясенні коштаў';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Дадаць некалькі доказаў';

  @override
  String get all_search_prices_top_location_single_title => 'Цэны ў краме';

  @override
  String get all_search_prices_top_product_title =>
      'Прадукты з самымі высокімі коштамі';

  @override
  String get all_search_to_be_completed_title => 'Усе недаапрацаваныя прадукты';

  @override
  String get categorize_products_country_title =>
      'Дапамажыце класіфікаваць тавары ў вашай краіне';

  @override
  String get edit_product_action_retake_picture => 'Перафатаграфаваць';

  @override
  String get edit_product_action_take_picture => 'Сфатаграфаваць';

  @override
  String get edit_product_action_confirm => 'Пацвердзіць';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Я згодны з Адкрытымі фактамі пра ежу ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'умовамі выкарыстання і ўнёску ў Open Food Facts';

  @override
  String get analytics_consent_image_semantic_label => 'Значок аналітыкі';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Фатальная памылка: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Фатальная памылка: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Запоўніце асноўныя звесткі';

  @override
  String get edit_photo_button_label => 'Edit';

  @override
  String get edit_photo_unselect_button_label => 'Адмяніць выбар фота';

  @override
  String get edit_photo_select_existing_button_label =>
      'Выберыце існуючы малюнак';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Выберыце малюнак, націснуўшы на яго';

  @override
  String get edit_photo_select_existing_download_label =>
      'Атрыманне існуючых малюнкаў…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Раней няма загружаных малюнкаў, звязаных з гэтым прадуктам.';

  @override
  String get edit_photo_language_not_this_one =>
      'Пакуль няма выявы на гэтай мове';

  @override
  String get edit_photo_language_none => 'Пакуль няма выявы';

  @override
  String get category_picker_screen_title => 'Катэгорыі';

  @override
  String get basic_details => 'Асноўныя звесткі';

  @override
  String get product_name => 'Назва прадукту';

  @override
  String get product_names => 'Назвы прадуктаў';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Дадаць новы пераклад';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Перад праверкай пераканайцеся, што вы дадаяце пераклад толькі ў тым выпадку, калі гэтая мова ёсць на ўпакоўцы.';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Паглядзець фота спераду';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Зрабіце фота спераду';

  @override
  String get add_basic_details_product_name_hint =>
      'Увядзіце назву прадукту (напрыклад: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Змяніць мову па змаўчанні?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Вы хочаце, каб мова прадукту па змаўчанні была ўстаноўлена на «$language»?';
  }

  @override
  String get explanation_section_good_examples => 'Добрыя прыклады';

  @override
  String get explanation_section_bad_examples => 'Дрэнныя прыклады';

  @override
  String get add_basic_details_product_name_help_title =>
      'Добрая практыка: назва прадукту';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Назва прадукту — гэта **асноўная назва, надрукаваная на ўпакоўцы**. Яна можа быць зарэгістраванай гандлёвай маркай.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Заўвага:** Калі ласка, не дадавайце пераклад, **калі гэтая мова адсутнічае на ўпакоўцы**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Несквік';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Таматавы кетчуп';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Не ўключайце брэнд у назву';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Таматавы кетчуп **ад Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Не выкарыстоўвайце сімвалы ®, ™, © або падобныя';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Несквік**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count іншыя пераклады',
      one: '$count іншы пераклад',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Назва брэнда';

  @override
  String get brand_names => 'Фірмовыя назвы';

  @override
  String get add_basic_details_brand_name_error =>
      'Калі ласка, увядзіце назву брэнда';

  @override
  String get add_basic_details_brand_names_hint =>
      'Увядзіце брэнды (напрыклад: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Добрая практыка: Брэнды';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Увядзіце **усе брэнды прадукту**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Асноўны брэнд';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'Спачатку трэба **ўвесці** **асноўную марку**, якая звычайна выразна пазначана на пярэдняй частцы ўпакоўкі.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Іншыя брэнды';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Калі прадаецца **вялікай кампаніяй**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Актымель** прадае кампанія **Данон**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Пры продажы з **перакладам брэнда на некалькі моў**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Прыродная даліна** часам пішацца **Вал Прырода**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Нутэла';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Арэа, Мандэлез';

  @override
  String get quantity => 'Колькасць і вага';

  @override
  String get add_basic_details_quantity_hint =>
      'Увядзіце вагу і, пры неабходнасці, колькасць (напрыклад: 4x100 г)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Добрая практыка: колькасць';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Скапіруйце значэнне, пазначанае на прадукце, і **не забудзьцеся пра адзінкі вымярэння**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 г** або **230 г**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (на 6 яек)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 г**\n(для прадукту з 3 скрынкамі па 150 г кожная)';

  @override
  String get barcode => 'Штрых-код';

  @override
  String barcode_barcode(String barcode) {
    return 'Штрых-код: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Няправільны штрых-код';

  @override
  String get basic_details_add_success => 'Асноўныя звесткі дададзены';

  @override
  String get basic_details_add_error =>
      'Немагчыма дадаць асноўныя звесткі. Паўтарыце спробу праз некаторы час';

  @override
  String get clear_search => 'Ачысціць пошук';

  @override
  String get confirm_clear =>
      'Вы збіраецеся ачысціць усю сваю гісторыю: упэўнены, што хочаце працягнуць?';

  @override
  String get alert_clear_selected_user_list =>
      'Вы збіраецеся ачысціць выбраныя элементы ў гісторыі';

  @override
  String get confirm_clear_selected_user_list =>
      'Вы ўпэўненыя, што хочаце працягнуць?';

  @override
  String get alert_select_items_to_clear =>
      'Калі ласка, выберыце адзін або некалькі элементаў для ачысткі';

  @override
  String confirm_clear_user_list(String name) {
    return 'Вы збіраецеся ачысціць спіс ($name): упэўнены, што хочаце працягнуць?';
  }

  @override
  String get confirm_delete_user_list_title => 'Выдаліць спіс?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Вы збіраецеся выдаліць спіс «$name».\nВы ўпэўненыя, што хочаце працягнуць?';
  }

  @override
  String get confirm_delete_user_list_button => 'Так, я пацвярджаю';

  @override
  String importance_label(String name, String id) {
    return '$name важнасць: $id';
  }

  @override
  String get user_list_all_title => 'Спісы';

  @override
  String get user_list_all_empty => 'Стварыце свой першы спіс';

  @override
  String get product_list_select => 'Выберыце спіс';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count прадукты',
      one: 'Адзін прадукт',
      zero: 'Пусты спіс',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Дадаць спіс';

  @override
  String get open_food_preferences_tooltip => 'Змяніць свае харчовыя перавагі';

  @override
  String get add_photo_button_label => 'Дадаць фота';

  @override
  String get add_packaging_photo_button_label =>
      'Сфатаграфуйце ўпакоўку/інфармацыю аб перапрацоўцы';

  @override
  String get add_origin_photo_button_label =>
      'Рабіце фатаграфіі любой інфармацыі аб паходжанні';

  @override
  String get add_emb_photo_button_label =>
      'Сфатаграфуйце любую інфармацыю аб кодзе адсочвання';

  @override
  String get add_label_photo_button_label =>
      'Сфатаграфуйце любыя этыкеткі і інфармацыю аб сертыфікатах';

  @override
  String get choose_image_source_title => 'Выбраць крыніцу выявы';

  @override
  String get choose_image_source_body => 'Калі ласка, выберыце крыніцу выявы';

  @override
  String get gallery_source_label => 'Галерэя';

  @override
  String get gallery_source_access_denied_dialog_title => 'Доступ забаронены';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'На жаль, праграма не мае доступу да вашай галерэі, бо вы раней адмовілі ў дазволе.\n\nКалі ласка, перайдзіце ў налады праграмы ў вашым тэлефоне -> Налады -> Фота';

  @override
  String get gallery_source_access_denied_dialog_button => 'Адкрыйце налады';

  @override
  String get share => 'Падзяліцца';

  @override
  String share_product_text(String url) {
    return 'Азнаёмцеся з гэтым прадуктам на Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Азнаёмцеся з гэтым прадуктам на Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Азнаёмцеся з гэтым прадуктам на Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Азнаёмцеся з гэтым прадуктам на старонцы \"Адкрытыя факты пра прадукты\": $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Азнаёмцеся з маім спісам прадуктаў на Open Food Facts: $url';
  }

  @override
  String get capture => 'Зрабіць здымак';

  @override
  String get capture_new_picture => 'Сфатаграфаваць';

  @override
  String get choose_from_gallery => 'Выбраць з галерэі';

  @override
  String get image_upload_queued =>
      'Выява будзе запампавана ў фонавым рэжыме як мага хутчэй.';

  @override
  String get add_price_queued =>
      'Кошт будзе адпраўлены на сервер як мага хутчэй.';

  @override
  String get background_task_title_full_refresh =>
      'Пачатак абнаўлення ўсіх прадуктаў, якія захоўваюцца лакальна';

  @override
  String get background_task_title_folksonomy =>
      'Пачатак выканання дзеянняў сервера для абнаўленняў folksonomy, якія захоўваюцца лакальна';

  @override
  String get background_task_title_top_n =>
      'Пачатак загрузкі найбольш папулярных прадуктаў';

  @override
  String get expand_nutrition_facts =>
      'Разгарнуць табліцу звестак аб пажыўнасці';

  @override
  String get expand_nutrition_facts_body =>
      'Пашырайце табліцу харчовай каштоўнасці';

  @override
  String get expand_ingredients => 'Разгарнуць інгрэдыенты';

  @override
  String get expand_ingredients_body =>
      'Пакіньце панэль інгрэдыентаў разгорнутай';

  @override
  String get no_internet_connection => 'Няма злучэння з інтэрнэтам';

  @override
  String get world_results_label => 'Увесь свет';

  @override
  String get world_results_action => 'Пашырце свой пошук на ўвесь свет';

  @override
  String get copy_to_clipboard => 'Скапіяваць';

  @override
  String get paste_from_clipboard => 'Уставіць з буфера абмену';

  @override
  String get no_data_available_in_clipboard => 'У буферы абмену няма дадзеных';

  @override
  String get clipboard_barcode_copy => 'Скапіяваць штрых-код у буфер абмену';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Штрых-код $barcode скапіяваны ў буфер абмену!';
  }

  @override
  String get open_product_website => 'Адкрыйце гэты прадукт на сайце';

  @override
  String get language_picker_label => 'Ваша мова';

  @override
  String get country_picker_label => 'Ваша краіна';

  @override
  String get currency_picker_label => 'Ваша валюта';

  @override
  String get help_with_openfoodfacts => 'Дапамога з OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Прадукт будзе абноўлены ў фонавым рэжыме як мага хутчэй.';

  @override
  String get no_email_client_available_dialog_title =>
      'Няма праграм электроннай пошты!';

  @override
  String get no_email_client_available_dialog_content =>
      'Калі ласка, дашліце нам ліст уручную на адрас mobile@openfoodfacts.org';

  @override
  String get all_images => 'Усе выявы';

  @override
  String get selected_images => 'Абраныя выявы';

  @override
  String get product_card_remove_product_tooltip => 'Выдаліць прадукт';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Новы адсканаваны штрых-код: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Выдаліць усе тавары з каруселі';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Калі ласка, адсканіруйце як мінімум два тавары, каб параўнаць іх';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Націсніце, каб параўнаць адсканаваныя вамі тавары';

  @override
  String get scan_product_loading => 'Вы адсканавалі\nштрых-код:';

  @override
  String get scan_product_loading_initial =>
      'Мы шукаем гэты тавар!\nКалі ласка, пачакайце некалькі секунд…';

  @override
  String get scan_product_loading_long_request =>
      'Мы ўсё яшчэ шукаем гэты тавар!\nЦі лічыце вы, што ён доўга загружаецца? Мы таксама…';

  @override
  String get scan_product_loading_unresponsive =>
      'Мы ўсё яшчэ шукаем гэты тавар.\nВы жадаеце перазапусціць пошук?';

  @override
  String get scan_product_loading_restart_button => 'Перазапусціць пошук';

  @override
  String get portion_calculator_description =>
      'Разлічыце харчовую каштоўнасць для пэўнай колькасці';

  @override
  String get portion_calculator_hint => 'Колькасць у';

  @override
  String get portion_calculator_accessibility =>
      'Увядзіце колькасць, каб разлічыць харчовую каштоўнасць';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Калі ласка, увядзіце колькасць ад $min да $max г';
  }

  @override
  String get portion_calculator_computation_error =>
      'Адсутнічаюць дадзеныя. Разлік не ўдалося выканаць.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Звесткі аб пажыўнасці на $grams г (або мл)';
  }

  @override
  String get offline_data => 'Аўтаномныя дадзеныя';

  @override
  String get ocr_image_upload_instruction =>
      'Запампуйце выяву для аўтаматычнага распазнання інфармацыі, якую яна змяшчае.';

  @override
  String get upload_image => 'Запампаваць фота';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Не атрымалася спампаваць выяву';

  @override
  String get image_edit_url_error =>
      'Не атрымалася адрэдагаваць выяву, бо яе URL не быў зададзены.';

  @override
  String get user_picture_source_remember => 'Запомніць мой выбар';

  @override
  String get user_picture_source_ask => 'Пытайцеся кожны раз';

  @override
  String get robotoff_continue => 'Працягнуць';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count пытанні',
      one: 'пытанне',
    );
    return 'Наступнае $_temp0';
  }

  @override
  String get show_password => 'Паказаць пароль';

  @override
  String get owner_field_info_title => 'Значэнні, прадстаўленыя вытворцам';

  @override
  String get owner_field_info_message =>
      'З дапамогай гэтага лагатыпа мы вылучаем дадзеныя, прадастаўленыя вытворцам, і якія могуць быць недаступныя для рэдагавання.';

  @override
  String get owner_field_info_close_button => 'Закрыць гэтую інфармацыю';

  @override
  String get owner_field_image =>
      'Гэта выява прадастаўлена вытворцам. Магчыма, яе нельга рэдагаваць.';

  @override
  String get edit_packagings_title => 'Кампаненты ўпакоўкі';

  @override
  String get edit_packagings_element_add => 'Дадаць кампанент упакоўкі';

  @override
  String get edit_packagings_completed => 'Упакоўка завершана';

  @override
  String edit_packagings_element_title(int index) {
    return 'Кампанент упакоўкі #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Колькасць адзінак';

  @override
  String get edit_packagings_element_hint_units =>
      'Увядзіце колькасць адзінак упакоўкі аднолькавай формы і матэрыялу, якія змяшчаюцца ў прадукце.';

  @override
  String get edit_packagings_element_field_shape => 'Форма';

  @override
  String get edit_packagings_element_hint_shape =>
      'Увядзіце назву формы, пазначаную ў інструкцыях па перапрацоўцы, калі яны даступныя, або выберыце форму.';

  @override
  String get edit_packagings_element_example_shape => 'Бутылка';

  @override
  String get edit_packagings_element_field_material => 'Матэрыял';

  @override
  String get edit_packagings_element_hint_material =>
      'Увядзіце канкрэтны матэрыял, калі яго можна вызначыць (код матэрыялу ўнутры трохвугольніка часта можна знайсці на дэталях упакоўкі), або агульны матэрыял (напрыклад, пластык або метал), калі вы не ўпэўненыя.';

  @override
  String get edit_packagings_element_example_material => 'Шкло';

  @override
  String get edit_packagings_element_field_recycling =>
      'Інструкцыя па перапрацоўцы';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Уводзьце інструкцыі па перапрацоўцы толькі ў тым выпадку, калі яны пазначаны на вырабе.';

  @override
  String get edit_packagings_element_example_recycling => 'Перапрацоўка';

  @override
  String get edit_packagings_element_field_quantity =>
      'Чыстая колькасць прадукту на адзінку';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Увядзіце чыстую вагу або чысты аб\'ём і пакажыце адзінку вымярэння (напрыклад, г або мл).';

  @override
  String get edit_packagings_element_field_weight => 'Вага пустой упакоўкі (г)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Выдаліце рэшткі ежы, памыйце і высушыце ўпакоўку перад узважваннем. Па магчымасці выкарыстоўвайце вагі з дакладнасцю 0,1 г або 0,01 г.';

  @override
  String get background_task_title => 'Чакаюцца ўзносы';

  @override
  String get background_task_subtitle =>
      'Вашы ўнёскі аўтаматычна захоўваюцца на нашым серверы, але не заўсёды ў рэжыме рэальнага часу.';

  @override
  String get background_task_list_empty => 'Няма чаканых фонавых задач';

  @override
  String get background_task_error_server_time_out => 'Тайм-аўт сервера';

  @override
  String get background_task_error_no_internet =>
      'Памылка падключэння да Інтэрнэту. Паспрабуйце пазней.';

  @override
  String get background_task_operation_unknown => 'невядомы тып аперацыі';

  @override
  String get background_task_operation_details => 'падрабязныя змены';

  @override
  String get background_task_operation_image => 'загрузка фота';

  @override
  String get background_task_operation_refresh =>
      'абнаўленне затрымліваецца пасля загрузкі фота';

  @override
  String get background_task_run_started => 'пачаў';

  @override
  String get background_task_run_not_started => 'яшчэ не пачалося';

  @override
  String get background_task_run_to_be_deleted => 'будзе выдалена';

  @override
  String get background_task_question_stop =>
      'Вы хочаце спыніць гэтую задачу як мага хутчэй?';

  @override
  String get feed_back => 'Водгук';

  @override
  String get undo => 'Адмяніць';

  @override
  String get copy_email_to_clip_board =>
      'Скапіяваць электронны ліст у буфер абмену';

  @override
  String get please_send_us_an_email_to =>
      'Калі ласка, дашліце нам ліст уручную на адрас';

  @override
  String get email_copied_to_clip_board =>
      'Электронны ліст скапіраваны ў буфер абмену!';

  @override
  String get select_accent_color => 'Выберыце акцэнтны колер';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Сіні';

  @override
  String get color_cyan => 'Блакітны';

  @override
  String get color_green => 'Зялёны';

  @override
  String get color_light_brown => 'Па змаўчанні';

  @override
  String get color_magenta => 'Маджэнта';

  @override
  String get color_orange => 'Аранжавы';

  @override
  String get color_pink => 'Ружовы';

  @override
  String get color_red => 'Чырвоны';

  @override
  String get color_rust => 'Іржа';

  @override
  String get color_teal => 'Бірузовы';

  @override
  String get text_contrast_mode => 'Кантраст тэксту';

  @override
  String get contrast_high => 'Высокі';

  @override
  String get contrast_medium => 'Сярэдні';

  @override
  String get contrast_low => 'Нізкі';

  @override
  String get product_refresher_internet_not_found => 'Тавар не знойдзены!';

  @override
  String get product_refresher_internet_not_connected =>
      'Вы не падключаны да інтэрнэту!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Сервер не працуе ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Памылка сервера ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Тавар не знойдзены!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Прадукт з наступным штрых-кодам адсутнічае ў нашай базе дадзеных: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Няма падключэння да інтэрнэту!';

  @override
  String get product_loader_network_error_message =>
      'Калі ласка, пераканайцеся, што ваш смартфон падключаны да сеткі Wi-Fi або мае ўключаную мабільную перадачу дадзеных';

  @override
  String get page_not_found_title => 'Старонка не знойдзена!';

  @override
  String get page_not_found_button => 'Вярнуцца на галоўную старонку';

  @override
  String get download_data => 'Спампаваць даныя';

  @override
  String get download_top_products =>
      'Спампуйце 1000 лепшых тавараў у вашай краіне для імгненнага сканавання';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count',
    );
    return 'Спампуйце лепшыя прадукты $_temp0 у вашай краіне для імгненнага сканавання';
  }

  @override
  String get download_in_progress =>
      'Спампоўванне дадзеных\nГэта можа заняць некаторы час';

  @override
  String downloaded_products(int num) {
    return 'Дададзена $num тавараў';
  }

  @override
  String get update_offline_data => 'Абнавіць афлайн-даныя пра прадукт';

  @override
  String get update_local_database_sub =>
      'Абнавіце лакальную базу дадзеных прадуктаў апошнімі дадзенымі з Open Food Facts';

  @override
  String get clear_local_database => 'Ачысціць афлайн-даныя прадукту';

  @override
  String get clear_local_database_sub =>
      'Ачысціце ўсе лакальныя даныя аб таварах з праграмы, каб вызваліць месца';

  @override
  String deleted_products(int num) {
    return '$num прадуктаў выдалена';
  }

  @override
  String get loading => 'Loading…';

  @override
  String get know_more => 'Даведайцеся больш';

  @override
  String get offline_data_desc =>
      'Націсніце, каб даведацца больш пра афлайн-дадзеныя';

  @override
  String get offline_product_data_title =>
      'Даныя аб прадукце ў аўтаномным рэжыме';

  @override
  String available_for_download(int num) {
    return '$num прадуктаў, даступных для неадкладнага сканавання';
  }

  @override
  String get country_selector_title => 'Выберыце сваю краіну:';

  @override
  String get currency_selector_title => 'Выберыце валюту:';

  @override
  String get language_selector_title => 'Выберыце мову:';

  @override
  String get language_selector_section_selected => 'Выбраныя мовы';

  @override
  String get language_selector_section_frequently_used =>
      'Часта выкарыстоўваецца';

  @override
  String get action_delete_list => 'Выдаліць';

  @override
  String get action_change_list => 'Змяніць бягучы спіс';

  @override
  String get product_list_create => 'Стварыць';

  @override
  String get product_list_create_tooltip => 'Стварыць новы спіс';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Новы разлік)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (новы разлік)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Невядомы Nutri-Score (новы разлік)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score не ўжываецца';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score не ўжываецца (новы разлік)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Зялёны бал А';

  @override
  String get environmental_score_b_new => 'Зялёны бал B';

  @override
  String get environmental_score_c_new => 'Зялёны бал C';

  @override
  String get environmental_score_d_new => 'Зялёны бал D';

  @override
  String get environmental_score_e_new => 'Зялёны бал E';

  @override
  String get environmental_score_unknown_new => 'Невядомы зялёны бал';

  @override
  String get environmental_score_not_applicable_new =>
      'Зялёны бал не ўжываецца';

  @override
  String get nova_group_generic_new =>
      'Ультраапрацаваныя прадукты - групы NOVA';

  @override
  String get nova_group_1 => 'NOVA Group 1';

  @override
  String get nova_group_2 => 'NOVA Group 2';

  @override
  String get nova_group_3 => 'NOVA Group 3';

  @override
  String get nova_group_4 => 'NOVA Group 4';

  @override
  String get nova_group_unknown => 'Невядомая група NOVA';

  @override
  String get nutrition_facts => 'Узровень пажыўных рэчываў';

  @override
  String get faq_title_partners => 'Партнёры і мецэнаты НДА';

  @override
  String get faq_title_vision =>
      'Бачанне, місія, каштоўнасці і праграмы Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Усталюйце Open Beauty Facts, каб стварыць касметычную базу дадзеных';

  @override
  String get faq_title_install_pet =>
      'Усталюйце Open Pet Food Facts, каб стварыць базу дадзеных кармоў для хатніх жывёл';

  @override
  String get faq_title_install_product =>
      'Усталюйце Open Products Facts, каб стварыць базу дадзеных прадуктаў і падоўжыць тэрмін службы аб\'ектаў';

  @override
  String get faq_nutriscore_nutriscore =>
      'Новы разлік Nutri-Score: што новага?';

  @override
  String get contact_title_pro_page =>
      'Прафесіянал? Імпартуйце свае прадукты ў Open Food Facts';

  @override
  String get contact_title_pro_email => 'Кантакт прадзюсара';

  @override
  String get contact_title_press_page => 'Прэс-старонка';

  @override
  String get contact_title_press_email => 'Кантакт для прэсы';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar =>
      'Падпішыцеся на наш каляндар супольнасці';

  @override
  String get hunger_games_loading_line1 =>
      'Калі ласка, дайце нам некалькі секунд…';

  @override
  String get hunger_games_loading_line2 => 'Мы спампоўваем пытанні!';

  @override
  String get hunger_games_error_label =>
      'Ой! Нешта пайшло не так… , і мы не змаглі загрузіць пытанні.';

  @override
  String get hunger_games_error_retry_button => 'Давайце паспрабуем яшчэ раз!';

  @override
  String get reorder_attribute_action => 'Змяніць парадак атрыбутаў';

  @override
  String get link_cant_be_opened =>
      'Не ўдаецца адкрыць гэту спасылку на вашай прыладзе. Праверце, ці ўсталяваны ў вас браўзер.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Падрабязнасці для $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Падрабязнасці для $pageName з $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Падзяліцца';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Дзе знайсці новы разлік Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score выкарыстоўваецца ў 7 краінах: Францыі, Германіі, Бельгіі, Іспаніі, Люксембургу, Нідэрландах і Швейцарыі.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Вытворцы маюць максімум **2 гады** пасля падпісання ўказа, каб **замяніць** стары разлік новым.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Што такое зялёны бал?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      '«Зялёны бал» — гэта лагатып, мэтай якога з’яўляецца інфармаванне вас пра **ўплыў ежы на навакольнае асяроддзе**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Каляровы код вар\'іруецца ад цёмна-зялёнага (**A+**) для **найменш уплывовых** прадуктаў да цёмна-чырвонага (**F**) для **найбольш уплывовых** прадуктаў.';

  @override
  String get guide_greenscore_logos_caption => 'Лагатыпы Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Асноўнае: Ацэнка жыццёвага цыклу (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Навуковая ацэнка катэгорый прадуктаў харчавання';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Для кожнай катэгорыі прадуктаў **эталонная** ацэнка ўстанаўліваецца з выкарыстаннем дадзеных з экалагічнай базы дадзеных Agribalyse (распрацаванай ADEME і INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Аналіз жыццёвага цыклу** — гэта стандартызаваны метад ацэнкі для правядзення шматэтапнай і шматкрытэрыяльнай ацэнкі ўздзеяння на навакольнае асяроддзе.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Вымярэнні:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 этапаў вытворчасці';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Packaging';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 паказчыкаў уздзеяння на навакольнае асяроддзе';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Змяненне клімату/вугляродны след';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Знішчэнне азонавага слоя';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Іанізуючае выпраменьванне';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Зямля';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Спажыванне вады і энергіі';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Забруджванне паветра';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Марская і прэсная вада (часціцы, падкісленне, эўтрафікацыя)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Знясіленне рэсурсаў.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Бонусы і штрафы';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Каб узнагародзіць лепшыя тавары ў катэгорыі, мы ўжываем **бонусы і штрафы на аснове некалькіх крытэрыяў**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Бонус** прысуджаецца прадуктам, якія маюць **афіцыйную этыкетку, этыкетку або сертыфікат, які гарантуе карысць для навакольнага асяроддзя** (арганічны, справядлівы гандаль, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origin of ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Бонус** прысуджаецца ў залежнасці ад паходжання інгрэдыентаў. Гэты бонус улічвае **ўплыў на транспарт**, а таксама **экалагічную палітыку** краіны кожнага вытворцы.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Штраф** накладаецца на прадукты, якія ўтрымліваюць інгрэдыенты, што аказваюць значны **негатыўны ўплыў на біяразнастайнасць і экасістэмы**, такія як пальмавы алей, вытворчасць якога адказная за масіўную высечку лясоў.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Packaging';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Штраф** разлічваецца з улікам **цыркулярнасці ўпакоўкі** (выкарыстанне перапрацаванай сыравіны і магчымасць перапрацоўкі) і празмернай упакоўкі.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Каб дакладна разлічыць «Зялёны бал», неабходна мець **інфармацыю, якая не абавязкова пазначана на ўпакоўцы** (напрыклад, паходжанне і дакладны працэнт кожнага інгрэдыента) або якая рэдка даступная ў зручнай для выкарыстання форме (напрыклад, спіс усіх кампанентаў упакоўкі з дакладнымі тыпамі выкарыстанага пластыка).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Калі гэтая інфармацыя пакуль недаступная, выкарыстоўваюцца сярэднія значэнні**, але зараз мы заклікаем усіх дапамагчы нам сабраць гэтую інфармацыю, якая будзе вельмі карыснай як для Green-Score, так і для многіх іншых мэтаў.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Як грамадзяне могуць дапамагчы?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Усе грамадзяне могуць дапамагчы нам сабраць і структураваць інфармацыю, якая прысутнічае на прадуктах або якую можна з іх вывесці, напрыклад, інфармацыю аб **ўпакоўцы**: «Mission Emballages»: маштабная сумесная інвентарызацыя ўпакоўкі для ўсіх харчовых прадуктаў (на французскай мове).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Як вытворцы могуць дапамагчы';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Вытворцы могуць дасылаць нам сваю інфармацыю непасрэдна праз нашу бясплатную платформу для вытворцаў.';

  @override
  String get guide_greenscore_better_product_title =>
      'Які прадукт лепшы для планеты?';

  @override
  String get guide_greenscore_better_product_arg1_title => 'Цяжка сказаць';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Выбар устойлівых прадуктаў харчавання — адзін з самых важных крокаў для клімату, бо **наша глабальная харчовая сістэма адказная за больш чым чвэрць усіх выкідаў парніковых газаў**.\n(Крыніца: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'У цябе ёсць сіла!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Добрая навіна заключаецца ў тым, што гэта дае нам магутны спосаб змяніць сітуацыю.\n**Кожны з нас штогод з\'ядае каля 1000 прыёмаў ежы**. Гэта 1000 магчымасцей **выбраць лепшую будучыню для планеты**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Дапамагае быць адказным і прымаць рашэнні';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Выбар устойлівых прадуктаў харчавання можа здацца складаным. Этыкеткі заблытваюць, і інфармацыя часта адсутнічае. Green-Score быў створаны, каб спрасціць гэты працэс, даючы вам **зразумелы**, **навукова абгрунтаваны** і **празрысты** экалагічны рэйтынг харчовых прадуктаў менавіта там, дзе вам гэта трэба: падчас пакупак.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Празрыстасць';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'У адрозненне ад запатэнтаваных маркіровак, разлік Green-Score **цалкам адкрыты** і можа быць **правераны кім заўгодна**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'Што такое ультраапрацоўка?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Групы NOVA інфармуюць вас пра ўзровень апрацоўкі харчовых прадуктаў.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Класіфікацыя NOVA дазваляе класіфікаваць прадукты харчавання на **4 групы** у залежнасці ад **ступені іх прамысловай апрацоўкі** (мінімальна апрацаваныя або неапрацаваныя прадукты, кулінарныя інгрэдыенты, апрацаваныя прадукты, ультраапрацаваныя прадукты).';

  @override
  String get guide_nova_logos_caption => 'Лагатыпы NOVA';

  @override
  String get guide_nova_groups_title => '4 групы NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Існуе 4 групы NOVA, праблемнай з якіх з\'яўляецца 4-я група — ультраапрацаваныя прадукты.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Мінімальна апрацаваныя або неапрацаваныя прадукты';

  @override
  String get guide_nova_groups_arg1_text =>
      'Неапрацаваныя (або натуральныя) прадукты — гэта **ядомыя часткі раслін** (насенне, плады, лісце, сцеблы, карані) **або жывёл** (мышцы, субпрадукты, яйкі, малако), а таксама грыбы, водарасці і вада пасля аддзялення ад прыроды.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. Processes include various Preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most Processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they Can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these Formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also Contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly Extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Праблемы з ультраапрацоўкай';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Экстрэмальная апрацоўка харчовых інгрэдыентаў';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Многія з іх **атрымліваюцца ў выніку далейшай апрацоўкі харчовых кампанентаў**, такіх як гідрагенізаваныя або пераэтэрыфікаваныя алеі, гідралізаваныя бялкі, ізалят соевага бялку, мальтодекстрын, інвертны цукар і кукурузны сіроп з высокім утрыманнем фруктозы.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Дабаўкі, якія выходзяць за рамкі чыстай бяспекі харчовых прадуктаў';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Да дабавак у ультраапрацаваных прадуктах адносяцца тыя, што таксама выкарыстоўваюцца ў апрацаваных прадуктах, такія як кансерванты, антыаксіданты і стабілізатары. Да класаў дабавак, якія змяшчаюцца толькі ў ультраапрацаваных прадуктах, адносяцца тыя, што выкарыстоўваюцца **для імітацыі або паляпшэння сэнсарных якасцей прадуктаў харчавання або для маскіроўкі непрыемных аспектаў канчатковага прадукту**. Да гэтых дабавак адносяцца фарбавальнікі і іншыя колеры, стабілізатары колеру; араматызатары, узмацняльнікі густу, нецукровыя падсалодвальнікі; і тэхналагічныя дапаможнікі, такія як карбанізатары, умацоўвальнікі, рэчывы, якія павялічваюць і антыаб\'ём, пенагаснікі, рэчывы, якія прадухіляюць злежванне і глазуру, эмульгатары, секвестранты і ўвільгатняльнікі.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Апрацоўка, якую немагчыма зрабіць дома';

  @override
  String get guide_nova_explanations_arg3_text =>
      'Для аб\'яднання звычайна вялікай колькасці інгрэдыентаў і стварэння канчатковага прадукту (адсюль і «ультраапрацоўка») выкарыстоўваецца **мноства паслядоўнасцей працэсаў**. Працэсы ўключаюць некалькі **якіх няма айчынных аналагаў**, такіх як гідрагенізацыя і гідралізацыя, экструзія і фармаванне, а таксама папярэдняя апрацоўка для смажання.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Драпежніцкія і фінансавыя аспекты ультраперапрацоўкі';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Агульная мэта ультраапрацоўкі — стварэнне брэндавых**, **зручных** (трывалых, гатовых да ўжывання), **прывабных** (вельмі смачных) і **высокапрыбытковых** (з недарагіх інгрэдыентаў) харчовых прадуктаў, прызначаных для выцяснення ўсіх іншых груп прадуктаў харчавання. Ультраапрацоўчаныя харчовыя прадукты звычайна прывабна ўпакоўваюцца і актыўна прасоўваюцца на рынку.';

  @override
  String get guide_nova_explanations_arg5_title => 'Небяспека для здароўя';

  @override
  String get guide_nova_explanations_arg5_text =>
      'З 2018 года дзякуючы праекту NutriNet-Santé былі выяўлены першыя сувязі паміж **спажываннем ультраапрацаваных прадуктаў харчавання і падвышанай рызыкай раку, сардэчна-сасудзістых захворванняў і дыябету**. Сёння больш за 90 даследаванняў па ўсім свеце пацвярджаюць гэтыя высновы.\nНайбольш моцныя сувязі звязаны з **атлусценнем, смяротнасцю ад сардэчна-сасудзістых захворванняў і дэпрэсіўнымі сімптомамі**. У дзяцей наступствы ў першую чаргу назіраюцца ў вазе і ліпідным дысбалансе.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Краіны рэкамендуюць абмежаваць іх';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Некаторыя краіны выкарыстоўваюць групы NOVA для сваіх дыетычных рэкамендацый або мэтаў, напрыклад:\n\n- **🇧🇷 Рэкамендацыі па харчаванню Бразіліі** **рэкамендуюць абмежаваць спажыванне** апрацаваных прадуктаў харчавання і пазбягаць ультраапрацаваных прадуктаў.\n\n- **🇫🇷 Мэты палітыкі грамадскага здароўя Францыі** у галіне харчавання на 2018-2022 гады накіраваны на **скарачэнне спажывання ультраапрацаваных прадуктаў 4 групы на 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-be.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Сардэчна запрашаем на сайт «Адкрытыя факты пра ежу»!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Што такое Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts — гэта **сумесная**, **бясплатная** і **адкрытая** база дадзеных харчовых прадуктаў з усяго свету.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Мы лічым, што кожны павінен мець доступ да інфармацыі пра тое, што ён ясць. Збіраючы дадзеныя пра інгрэдыенты, алергены, харчовую каштоўнасць і іншае, **мы даем спажыўцам магчымасць рабіць абгрунтаваны выбар** і рухаем харчовую прамысловасць **да большай празрыстасці**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Асаблівасці Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Атрымлівайце апавяшчэнні аб непажаданых інгрэдыентах';

  @override
  String get guide_open_food_facts_tips_title =>
      'Парады для стварэння выдатных фотаздымкаў';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Чаго не рабіць';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Пазбягайце ценяў і блікаў.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Няма размытага або неўвагнутага тэксту.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Не абрэзвайце часткі тэксту.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Пазбягайце насычаных фонаў.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Што рабіць';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Выкарыстоўвайце добрае, раўнамернае асвятленне.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Пераканайцеся, што тэкст выразны і чытэльны.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Запішыце ўвесь спіс інгрэдыентаў.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Трымайце выраб на роўнай паверхні.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Дапамажыце нам стварыць «Вікіпедыю ежы»';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Ацэнка па якасці харчавання';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Рэйтынг, каб пазбегнуць ультраапрацаваных прадуктаў';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Вынік для планеты';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-be.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Сардэчна запрашаем на Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Што такое Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      '«Адкрытыя факты пра корм для хатніх жывёл» распаўсюджваюць нашу місію на нашых пухнатых сяброў! Гэта **база дадзеных кармоў для катоў, сабак і іншых хатніх жывёл**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Мы збіраем інфармацыю пра **інгрэдыенты**, **аналіз харчовай каштоўнасці** і рэкамендацыі па кармленні, каб дапамагчы ўладальнікам хатніх жывёл выбраць найлепшы корм для сваіх жывёл.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Асаблівасці Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Атрымлівайце апавяшчэнні аб непажаданых інгрэдыентах';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Ці ёсць у вашага гадаванца алергія на якія-небудзь інгрэдыенты? Вы можаце ўсталяваць спіс касметычных інгрэдыентаў, якіх варта пазбягаць, прама ў дадатку!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Парады для стварэння выдатных фотаздымкаў';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Чаго не рабіць';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Пазбягайце ценяў і блікаў.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Няма размытага або неўвагнутага тэксту.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Не абрэзвайце часткі тэксту.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Пазбягайце насычаных фонаў.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Што рабіць';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Выкарыстоўвайце добрае, раўнамернае асвятленне.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Пераканайцеся, што тэкст выразны і чытэльны.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Запішыце ўвесь спіс інгрэдыентаў.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Трымайце выраб на роўнай паверхні.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Заўвага пра падлік ачкоў';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Распрацоўка сістэмы ацэнкі корму для хатніх жывёл **пакуль што не з\'яўляецца прыярытэтнай**. Методыка будзе складанай, бо патрэбы ў харчаванні моцна адрозніваюцца ў залежнасці ад віду, узросту і стану здароўя. Пакуль што мы не знайшлі незалежнай навуковай групы, здольнай распрацаваць такую ацэнку.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-be.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Вітаем на сайце «Адкрытыя факты пра прыгажосць»!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Што такое адкрытыя факты пра прыгажосць?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts — гэта сумесная база дадзеных **касметычных прадуктаў**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Наша мэта — расшыфраваць спісы інгрэдыентаў, каб дапамагчы вам **зразумець, што ўваходзіць у склад вашых сродкаў асабістай гігіены**. Ад ўвільгатняльнікаў да касметыкі — мы збіраем дадзеныя аб інгрэдыентах, алергенах і ўпакоўцы, каб спрыяць празрыстасці ў касметычнай прамысловасці.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Асаблівасці Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Атрымлівайце апавяшчэнні аб непажаданых інгрэдыентах';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'У вас алергія на якія-небудзь інгрэдыенты? Хочаце пазбегнуць камедагенных рэчываў? Хочаце пазбягаць спрэчных кампанентаў? Вы можаце стварыць спіс касметычных інгрэдыентаў, якіх варта пазбягаць, прама ў дадатку!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Парады для стварэння выдатных фотаздымкаў';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Чаго не рабіць';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Пазбягайце ценяў і блікаў.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Няма размытага або неўвагнутага тэксту.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Не абрэзвайце часткі тэксту.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Пазбягайце насычаных фонаў.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Што рабіць';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Выкарыстоўвайце добрае, раўнамернае асвятленне.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Пераканайцеся, што тэкст выразны і чытэльны.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Запішыце ўвесь спіс інгрэдыентаў.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Зрабіце столькі здымкаў, колькі трэба, калі бутэлька выгнутая.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Магчыма, вам спатрэбіцца адклеіць этыкетку, каб убачыць спіс інгрэдыентаў.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Трымайце выраб на роўнай паверхні.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Заўвага пра падлік ачкоў';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'У адрозненне ад харчовых прадуктаў, у свеце касметыкі **няма агульнапрызнанай, падтрыманай урадам сістэмы ацэнкі, такой як Nutri-Score**. Эфекты інгрэдыентаў могуць быць вельмі індывідуальнымі і залежаць ад тыпу скуры, алергій і індывідуальных праблем.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-be.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices — гэта праект па **зборы і абмене цэнамі на тавары па ўсім свеце**. Гэта агульнадаступны набор даных, які можна выкарыстоўваць для даследаванняў, аналізу і іншых мэтаў. Open Prices распрацаваны і падтрымліваецца Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Мы збіраем набор дадзеных аб цэнах з адкрытым зыходным кодам**. Карыстальнікі могуць дадаваць цэны праз гэтае вэб-прыкладанне або праз афіцыйнае мабільнае прыкладанне Open Food Facts. Рознічныя прадаўцы або праграмы іншых вытворцаў таксама могуць уносіць свой уклад, выкарыстоўваючы наш API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Збірайце фатаграфіі цэннікаў у праходах';

  @override
  String get guide_open_prices_how_arg2_title => 'Збірайце фатаграфіі чэкаў';

  @override
  String get guide_open_prices_why_title => 'Чаму Open Food Facts робіць гэта?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Інфармацыя аб цэнах мае першараднае значэнне для разумення харчовых сістэм. Гэта ключавы фактар у разуменні кошту прадуктаў харчавання і прасоўванні больш здаровага харчавання. Пачатковыя дадзеныя аб цэнах — гэта спосаб палегчыць даследчыкам, журналістам і грамадзянам **лепшае разуменне таго, як цэны на прадукты харчавання змяняюцца геаграфічна і ў часе**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Адсочвайце дынаміку цэн з цягам часу';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Паглядзіце на **эвалюцыю цэн**: скарочаная інфляцыя, танная інфляцыя, мы можам адсочваць іх разам!';

  @override
  String get guide_open_prices_why_arg2_title => 'Параўнайце цэны побач з вамі';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Па меры таго, як мы будзем атрымліваць больш цэн, вы зможаце знайсці **самыя танныя крамы вакол вас**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Ці разглядалі вы магчымасць узяцця цэн з вэб-сайтаў рознічных гандляроў?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Па юрыдычных і тэхнічных прычынах **мы не лічым атрыманне інфармацыі з вэб-сайтаў рознічных прадаўцоў сапраўдным спосабам унясення ў Open Prices**. Мы хочам пераканацца, што сабраныя намі цэны дакладныя і актуальныя, і атрыманне інфармацыі ад іншых карыстальнікаў не дазваляе нам гэтага рабіць.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'У будучай версіі Open Prices разглядаецца магчымасць збору дадзеных аб цане, але гэта будзе рабіць сам Open Prices, каб мы маглі атрымаць доказ цаны на аснове HTML-старонкі.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Вы можаце дадаваць цэны з дапамогай нашага API.\nКалі вы хочаце дадаваць цэны ў вялікіх маштабах, звяжыцеся з намі па адрасе prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Сардэчна запрашаем на старонку \"Факты аб адкрытых прадуктах\"!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Што такое факты аб адкрытых прадуктах?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts — гэта велізарная адкрытая база дадзеных для **любых прадуктаў са штрых-кодам, якія не з\'яўляюцца прадуктамі харчавання, касметыкай або кормам для хатніх жывёл**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Ад **электронікі** да **цацак**, ад **адзення** да **чысцячых сродкаў** — калі ў прадмета ёсць штрых-код, яго можна дадаць. Мэта гэтага праекта — стварыць «Інтэрнэт рэчаў» для прадметаў паўсядзённага ўжытку, зрабіўшы інфармацыю пра іх універсальна даступнай.';

  @override
  String get guide_open_products_facts_features_title =>
      'Асаблівасці адкрытых прадуктаў Факты';

  @override
  String get guide_open_products_facts_features_text =>
      '«Open Products Facts» імкнецца даць спажыўцам магчымасць **падоўжыць тэрмін службы прадметаў**, прапаноўваючы цыклічныя рашэнні для абслугоўвання, **раманту**, **перапрацоўкі** сваіх прадметаў або даць ім новага ўладальніка.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Вугляродны след некаторых прадуктаў';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Уздзеянне на CO2** ад французскага агенцтва па ахове навакольнага асяроддзя ADEME прадастаўляе **ўздзеянне на вуглярод** па многіх катэгорыях, таму пераканайцеся, што вы дакладна класіфікуеце прадукты.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Індэкс рамонтаздольнасці для многіх вырабаў';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Кожны раз, калі будзе даступны французскі індэкс рамонтнасці, мы яго пакажам. Больш за тое, **вы можаце пачаць збіраць зменныя з дапамогай механізму Folksonomy**, каб мы маглі пералічыць яго самастойна ў будучыні, нават у краінах, дзе ён недаступны.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Знайдзіце спосабы ахвяраваць/перапрадаць свой прадукт';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Мы прапануем спасылкі на **трэцябаковыя сэрвісы, якія працуюць у сферы цыркулярнага выкарыстаньня**, якія дапамогуць вам атрымаць патрэбны вам прадукт, напрыклад, патрыманы прадукт, каб быць больш эканомным на планетарных рэсурсах.\nЗвярніце ўвагу, што нам за гэта не плацяць, і што сістэма працуе толькі ў якасці прыкладу для двух вэб-сайтаў у Францыі. Вы можаце дапамагчы пашырыць гэту сістэму, дакументаваўшы больш сайтаў у вікі.';

  @override
  String get guide_open_products_facts_information_title =>
      'Якая інфармацыя карысная?';

  @override
  String get guide_open_products_facts_information_text =>
      'Для такога шырокага дыяпазону тавараў **дадзеныя, якія мы збіраем, з\'яўляюцца гнуткімі**. Для гэтага **мы стварылі рухавік Folksonomy**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Рухавік фолксаноміі';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine — гэта інструмент, які дапамагае вам дапаўняць прадукты адпаведнымі ўласцівасцямі. Гэта дапамагае палепшыць пошук і выяўленне, а таксама вылічваць і адлюстроўваць цікавыя рэчы ў будучыні.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Вы можаце дадаць любыя ключы і значэнні, напрыклад: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Вы атрымаеце аўтападказку магчымых уласцівасцей, і вы зможаце дадаваць і дакументаваць новыя для вашых любімых відаў прадуктаў.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-be.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Адкрыць харчовыя перавагі';

  @override
  String get guide_coming_soon_button_title => 'Хутка';

  @override
  String get guide_learn_more_subtitle => 'Націсніце, каб даведацца больш';

  @override
  String get preview_badge => 'Папярэдні прагляд';

  @override
  String get prices_feedback_form =>
      'Націсніце тут, каб адправіць нам свой водгук аб гэтай новай функцыі!';

  @override
  String get menu_button_list_actions => 'Выберыце дзеянне';

  @override
  String get error_loading_photo => 'Памылка загрузкі фота';

  @override
  String get photo_viewer_action_use_picture_as => 'Выкарыстоўваць як…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Выкарыстоўваць гэты малюнак як…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Выкарыстоўваць гэты малюнак як… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Падрабязнасці';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Падрабязнасці гэтага фота';

  @override
  String get photo_viewer_details_title => 'Падрабязнасці фота';

  @override
  String get photo_viewer_details_contributor_title => 'Contributor';

  @override
  String get photo_viewer_details_size_title => 'Памер';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height пікселяў';
  }

  @override
  String get photo_viewer_details_date_title => 'Дата';

  @override
  String get photo_viewer_details_url_title => 'URL-адрас';

  @override
  String get product_page_compatibility_score => 'Сумяшчальны';

  @override
  String get user_lists_action_multi_select => 'Множны выбар';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Ваш бал сумяшчальнасці: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Здымак спераду';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Здымак інгрэдыентаў';

  @override
  String get product_image_nutrition_accessibility_label => 'Харчовая карціна';

  @override
  String get product_image_packaging_accessibility_label => 'Выява ўпакоўкі';

  @override
  String get product_image_other_accessibility_label => 'Іншы малюнак';

  @override
  String get product_image_outdated_message =>
      'Гэтая выява можа быць састарэлай';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (гэты малюнак можа быць састарэлым)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (гэта выява можа быць заблакаваная вытворцам)';
  }

  @override
  String get product_image_error => 'Немагчыма загрузіць выяву!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Немагчыма загрузіць $type (памылка сеткі?)';
  }

  @override
  String get product_page_image_no_image_available => 'Няма выявы\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Для гэтага тавару няма выявы';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Змяніць парадак або схаваць дзеянні';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Дзеянні па рэдагаванні';

  @override
  String get product_page_action_bar_item_move_up => 'Перамясціць уверх';

  @override
  String get product_page_action_bar_item_move_down => 'Перамясціць уніз';

  @override
  String get product_page_action_bar_item_enable => 'Уключыць дзеянне';

  @override
  String get product_page_action_bar_item_disable => 'Адключыць дзеянне';

  @override
  String get product_page_pending_operations_banner_title =>
      'Загрузка вашых правак…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Дадзеныя, якія адлюстроўваюцца на гэтай старонцы, **пакуль не адлюстроўваюць вашы змены**.\nКалі ласка, пачакайце некалькі секунд…';

  @override
  String get product_add_a_language => 'Дадаць мову';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Штрых-код $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Выдаліць гэты тавар з каруселі';

  @override
  String get carousel_unsupported_header => 'Непадтрымоўваны штрых-код!';

  @override
  String get carousel_unsupported_title => 'Ой!';

  @override
  String get carousel_unsupported_text =>
      'Адсканаваны штрых-код не падтрымліваецца Open Food Facts!';

  @override
  String get carousel_error_header => 'Памылка!';

  @override
  String get carousel_error_title => 'Гэта аблом!';

  @override
  String get carousel_error_text_1 =>
      'Нам не ўдалося спампаваць інфармацыю па гэтым штрых-кодзе:';

  @override
  String get carousel_error_text_2 =>
      'Калі ласка, праверце падключэнне да Інтэрнэту або націсніце гэту кнопку:';

  @override
  String get carousel_error_button => 'Паўтарыць';

  @override
  String get carousel_unknown_product_header => 'Невядомы прадукт';

  @override
  String get carousel_unknown_product_title =>
      'Віншуем!\nВы знайшлі __рэдкі каштоўны камень!__';

  @override
  String get carousel_unknown_product_text =>
      'Наша сумесная база дадзеных змяшчае больш за **3 мільёны прадуктаў**, але гэты штрых-код не існуе: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'Загрузка інфармацыі...';

  @override
  String get carousel_loading_title =>
      'Вы толькі што адсканавалі прадукт з наступным штрых-кодам:';

  @override
  String get carousel_loading_text =>
      'Мы шукаем яго ў нашай базе дадзеных, якая змяшчае больш за **3 мільёны прадуктаў!**';

  @override
  String get product_type_subtitle_food =>
      'Гародніна, садавіна, замарожаныя прадукты…';

  @override
  String get product_type_subtitle_beauty => 'Касметыка, мыла, зубныя пасты…';

  @override
  String get product_type_subtitle_pet_food => 'Корм для сабак, катоў…';

  @override
  String get product_type_subtitle_product => 'Смартфоны, мэбля…';

  @override
  String get photo_field_front => 'Фота прадукту';

  @override
  String get photo_field_ingredients => 'Фота інгрэдыентаў';

  @override
  String get photo_field_nutrition => 'Фота харчавання';

  @override
  String get photo_field_packaging => 'Фота інструкцый па перапрацоўцы';

  @override
  String get photo_already_exists => 'Гэта фота ўжо існуе';

  @override
  String get photo_missing => 'Гэтае фота адсутнічае';

  @override
  String get date => 'Дата';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'Адмяніць папярэдняе дзеянне';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Мапа свету $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Удзельнікі OpenStreetMap';

  @override
  String get not_applicable_short => 'Няма дадзеных';

  @override
  String get knowledge_panel_warning_text => 'Warning';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Чаму гэты Nutri-Score адрозніваецца ад таго, што на ўпакоўцы?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Ёсць два магчымыя тлумачэнні:\nСпіс інгрэдыентаў і/або інфармацыя аб харчовай каштоўнасці не актуальная.\n\nМы прапануем «Новы разлік» Nutri-Score (або V2). Калі ласка, праверце, ці ёсць на ўпакоўцы банер «Новы разлік».';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Праверце інгрэдыенты';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Праверце інфармацыю пра харчовую каштоўнасць';

  @override
  String url_not_supported(String url) {
    return 'На жаль, мы не можам адкрыць URL-адрас:\n$url';
  }

  @override
  String get product_list_export => 'Экспарт';

  @override
  String get product_list_import => 'Імпарт';

  @override
  String get product_footer_action_barcode => 'Праглядзець штрых-код';

  @override
  String get product_footer_action_barcode_short => 'Штрых-код';

  @override
  String get product_footer_action_open_website => 'Адкрыць вэб-сайт';

  @override
  String get product_footer_action_report => 'Справаздача';

  @override
  String get product_footer_action_contributor_guide => 'Даведка';

  @override
  String get product_footer_action_data_quality_tags => 'Якасць дадзеных';

  @override
  String get product_page_tab_for_me => 'Для мяне';

  @override
  String get product_page_tab_website => 'Вэб-сайт';

  @override
  String get product_page_tab_prices => 'Цэны';

  @override
  String get prices_explanation_card_title => 'Чаму цэны?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** — гэта праект па зборы і абмене цэнамі на тавары па ўсім свеце 🌍. Open Prices распрацаваны і падтрымліваецца Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Даведацца больш';

  @override
  String get product_page_tab_folksonomy => 'Фолксаномія';

  @override
  String get folksonomy_explanation_card_title =>
      'Якія атрыбуты ўяўляюць сабой фолксаномія?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Атрыбуты заснаваны на **пары ключ-значэнне**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Гэтыя ўласцівасці ствараюцца і захоўваюцца ўдзельнікамі для любога выкарыстання.';

  @override
  String get folksonomy_action_external_link_title =>
      'Адкрыць знешнюю спасылку';

  @override
  String get folksonomy_action_external_link_warning =>
      'Знешнія спасылкі могуць быць небяспечнымі. Вы сапраўды хочаце наведаць гэтае месца?';

  @override
  String get prices_products_empty_title => 'Кошт недаступны';

  @override
  String get prices_products_empty_explanation =>
      'Будзьце першым, хто зробіць свой унёсак!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Найлепшыя тавары $pageSize (усяго: $total)';
  }

  @override
  String get app_review_title => 'Вам падабаецца гэта дадатак?';

  @override
  String get app_review_low => 'Магло б зрабіць лепш';

  @override
  String get app_review_medium => 'Нядрэнна';

  @override
  String get app_review_high => 'Мне гэта падабаецца!';

  @override
  String get app_review_feedback_modal_title =>
      'Дапамажыце нам палепшыць наша дадатак';

  @override
  String get app_review_feedback_modal_content =>
      'Калі ў вас ёсць некалькі хвілін, ці не маглі б вы запоўніць гэту форму, каб **мы маглі палепшыць будучыя абнаўленні**:';

  @override
  String get app_review_feedback_modal_open_form =>
      'Адкажыце на запаўненне формы';

  @override
  String get app_review_feedback_modal_later => 'Спытайце мяне пазней';

  @override
  String get nutrition_facts_extract_new =>
      'НОВАЕ: Вы можаце аўтаматычна здабываць пажыўныя рэчывы з выявы!';

  @override
  String get nutrition_facts_extract_button_text => 'Выняць зараз';

  @override
  String get nutrition_facts_extract_in_progress => 'Ідзе здабыванне…';

  @override
  String get nutrition_facts_extract_successful => 'Выманне паспяховае';

  @override
  String get nutrition_facts_extract_failed =>
      'Не атрымалася выняць пажыўныя рэчывы з выявы';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Статыстыка';

  @override
  String get prices_stats_title => 'Статыстыка цэн';

  @override
  String get prices_stats_prices_section => 'Цэны';

  @override
  String get prices_stats_products_section => 'Прадукты';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Рознае';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Ежа';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Прадукты';

  @override
  String get prices_stats_pet_food => 'Корм для хатніх жывёл';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Краіны';

  @override
  String get prices_stats_price_tag => 'Цэннік';

  @override
  String get prices_stats_receipt => 'Квітанцыя';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Вэб-сайт';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'Апошняе абнаўленне';

  @override
  String get prices_stats_error =>
      'Падчас загрузкі статыстыкі адбылася памылка.';

  @override
  String get product_edit_robotoff_question_answered => 'Адказ на пытанне!';

  @override
  String get product_edit_robotoff_proof => 'Доказ';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'Цэны';

  @override
  String get preferences_prices_subtitle => 'Кіруйце сваімі цэнавымі наладамі';

  @override
  String get preferences_card_project => 'Праект Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribute';

  @override
  String get preferences_my_contributions_title => 'My Contributions';

  @override
  String get preferences_my_stats_title => 'Мая статыстыка';

  @override
  String get preferences_contribute_subtitle =>
      'Перакладайце, паляпшайце нашы інструменты…';

  @override
  String get preferences_connect_title => 'Падключыцца';

  @override
  String get preferences_connect_subtitle =>
      'Звяжыцеся з намі або падпішыцеся на нас у сацыяльных сетках';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Дапамажыце нам інфармаваць мільёны спажыўцоў па ўсім свеце';

  @override
  String get preferences_card_help => 'Даведка і падтрымка';

  @override
  String get preferences_faq_title => 'Часта задаваныя пытанні';

  @override
  String get preferences_faq_subtitle => 'Атрымайце адказы на свае пытанні';

  @override
  String get logged_out => 'Выйшаў з сістэмы';

  @override
  String get preferences_app_bar_message =>
      'Дзякуй, што вы з\'яўляецеся адным з нашых удзельнікаў!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Глядзець усю статыстыку';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Пошук па запыце «$keyword» у $provider';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Пошук налады (напрыклад, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Даступнасць: Паказаць эмодзі';

  @override
  String get preferences_accessibility_remove_colors =>
      'Даступнасць: Выдаліць колеры';

  @override
  String get preferences_app_settings_products => 'Прадукты';

  @override
  String get preferences_card_about => 'About';

  @override
  String get preferences_legal_information_title => 'Юрыдычная інфармацыя';

  @override
  String get preferences_legal_information_subtitle =>
      'Умовы карыстання, палітыка прыватнасці і іншае';

  @override
  String get preferences_terms_of_use => 'Умовы выкарыстання';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts — гэта база дадзеных харчовых прадуктаў, **створаная ўсімі і для ўсіх**.\nВы можаце выкарыстоўваць яе, каб рабіць лепшы выбар прадуктаў харчавання, і паколькі гэта **адкрытыя дадзеныя**, кожны можа **паўторна выкарыстоўваць іх для любых мэт**.';

  @override
  String get preferences_privacy_policy => 'Палітыка прыватнасці';

  @override
  String get preferences_licenses => 'Ліцэнзіі';

  @override
  String get preferences_about_app_title => 'Пра праграму';

  @override
  String get preferences_about_app_subtitle =>
      'Тэхнічная інфармацыя, інфармацыя для распрацоўшчыкаў і іншае';

  @override
  String get preferences_card_information => 'Information';

  @override
  String get preferences_version_number_title => 'Нумар версіі';

  @override
  String get preferences_scanner_title => 'Сканер';

  @override
  String get preferences_app_store => 'Крама праграм';

  @override
  String get preferences_app_system_settings => 'Сістэмныя налады';

  @override
  String get preferences_source_code => 'Доступ да зыходнага кода';

  @override
  String get preferences_source_code_subtitle =>
      'І пачніце рабіць уплыў на мільёны';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Complete products';

  @override
  String get preferences_tips => 'Парады';

  @override
  String get tips_discover_nutriscore => 'Адкрыйце для сябе новы Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle => 'На сайце Open Food Facts';

  @override
  String get preferences_manage_account_title =>
      'Кіраваць маім уліковым запісам';

  @override
  String get preferences_manage_account_tooltip =>
      'Кіруйце сваім уліковым запісам';

  @override
  String get preferences_change_password_title => 'Змяніць мой пароль';

  @override
  String get preferences_danger_zone => 'Небяспечная зона';

  @override
  String get preferences_account_deletion_subtitle =>
      'Усе вашы ўнёскі будуць страчаны';

  @override
  String get preferences_contributions_title => 'Contributions';

  @override
  String get preferences_dev_mode_app_settings_title => 'Налады праграмы';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Вельмі эксперыментальны спосаб сканавання прадуктаў афлайн';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Абнавіць усе прадукты з сервера';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Калі ласка, пазбягайце гэтага, калі ў гэтым няма абсалютнай неабходнасці';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Дэманстрацыйны рэжым';

  @override
  String get preferences_dev_mode_add_cards_title => 'Дадаць карты ў сканер';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Дадае 3 узоры прадуктаў у сканер';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'Вядучы фолксаноміі';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Хост: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Эксперыменты з даступнасцю';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Выбар некалькіх прадуктаў па цэнах';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Панэлі ведаў, упарадкаваныя карыстальнікамі';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Часовы доступ да пошуку месцазнаходжання';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Параўнанне 2 ці 3 прадуктаў';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Імпарт спісу прадуктаў';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Ацэнкі і метадалогіі';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Даведайцеся, як разлічваецца Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Даведайцеся пра асноўныя змены ў методыцы';

  @override
  String get preferences_faq_discover_project_title =>
      'Адкрыйце для сябе праект';

  @override
  String get preferences_faq_discover_off_title =>
      'Адкрыйце для сябе адкрытыя факты пра ежу';

  @override
  String get preferences_faq_discover_obf_title =>
      'Адкрыйце для сябе адкрытыя факты пра прыгажосць';

  @override
  String get preferences_faq_discover_opff_title =>
      'Даведайцеся пра Open Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Даведайцеся пра адкрытыя прадукты. Факты';

  @override
  String get preferences_faq_faq_title => 'FAQ - Часта задаваныя пытанні';

  @override
  String get preferences_faq_off_ngo_title => 'НДА Open Food Facts';

  @override
  String get preferences_about_information_title => 'Information';

  @override
  String get preferences_connect_community_updates_title =>
      'Атрымлівайце абнаўленні супольнасці';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Будзьце ў курсе навін праграмы і супольнасці';

  @override
  String get preferences_connect_community_calendar_title =>
      'Падпішыцеся на наш каляндар супольнасці';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Далучайцеся, наведаўшы адно з нашых віртуальных мерапрыемстваў';

  @override
  String get preferences_connect_blog_title => 'Блог Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Атрымлівайце апошнія навіны па меры іх з\'яўлення';

  @override
  String get preferences_connect_community_help_title =>
      'Атрымайце дапамогу ад супольнасці';

  @override
  String get preferences_connect_improve_app_title =>
      'Дапамажыце нам палепшыць праграму';

  @override
  String get preferences_connect_debug_info_title =>
      'Дашліце нам інфармацыю для адладкі';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Дашліце нам ліст з падрабязнай інфармацыяй аб адладцы';

  @override
  String get preferences_connect_feedback_title =>
      'Дашліце нам водгук аб дадатку';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Дапамажыце сфарміраваць будучыню праграмы';

  @override
  String get preferences_connect_survey_title =>
      'Прыміце ўдзел у апытанні па дадатку';

  @override
  String get preferences_connect_survey_subtitle =>
      'Дапамажыце нам зразумець, што нам трэба будаваць далей';

  @override
  String get preferences_connect_professionals_title => 'Прафесіяналы';

  @override
  String get preferences_connect_pro_subtitle =>
      'Цалкам бясплатна, гарантуе дакладныя дадзеныя для 500 праграм і мільёнаў спажыўцоў. Самаабслугоўванне, сумяшчальнасць з вашым PIM або электроннымі табліцамі (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Звяжыцеся з намі, каб пачаць';

  @override
  String get preferences_connect_press_title => 'Прэса';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Атрымайце ўсе неабходныя матэрыялы для вашай справаздачы';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Звяжыцеся з намі па пытаннях прэсы або каб паведаміць нам пра свой даклад';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Станьце актыўным валанцёрам';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Распрацоўка, камунікацыя, дызайн… любы від валанцёрства або экспертызы вітаецца!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Даведайцеся пра некаторыя з шматлікіх спосабаў, як вы можаце зрабіць свой унёсак';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Распрацоўка мабільных праграм';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Даведайцеся, як унесці свой уклад у распрацоўку праграмнага забеспячэння';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Штодзённыя нестабільныя зборкі, зусім новыя функцыі';

  @override
  String get preferences_contribute_local_community_title =>
      'Пашырайце сваю мясцовую супольнасць';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Дапамога з праграмным забеспячэннем, зместам, перакладамі аналізу інгрэдыентаў';

  @override
  String get preferences_contribute_share_subtitle =>
      'Мы падрыхтавалі невялікі шаблон, каб дапамагчы вам :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Простыя крокі для павышэння празрыстасці харчовых прадуктаў у вашай краіне';

  @override
  String get preferences_contribute_data_quality_title => 'Якасць дадзеных';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Далучайцеся да каманды па якасці дадзеных';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Далучайцеся да нашых намаганняў, каб забяспечыць поўную і дакладную базу дадзеных';

  @override
  String get preferences_contributions_products_added_title =>
      'Дададзеныя тавары';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Новыя прадукты, якія я дадаў у Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Прадукты, якія мне трэба выканаць';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Усе няпоўныя прадукты';

  @override
  String get preferences_my_contributions_prices_title => 'Цэны';

  @override
  String get preferences_my_contributions_my_prices_title => 'Мае цэны';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Мае цэны, мае доказы…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Прадукты, якія вы можаце дапамагчы завяршыць';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Дапамажыце разлічыць Nutri-Score і Green-Score у вашай краіне';

  @override
  String get preferences_prices_user_prices_subtitle => 'Цэны, якія я ўнёс';

  @override
  String get preferences_prices_proofs_subtitle => 'Цэннікі і чэкі';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Сфатаграфуйце свае чэкі і адскануйце адпаведныя штрых-коды';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Сфатаграфуйце цэны ў краме';

  @override
  String get preferences_prices_newest_title => 'Найноўшыя цэны';

  @override
  String get preferences_prices_newest_subtitle =>
      'Апошнія цэны, дададзеныя супольнасцю Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Аўтары з найбольшай колькасцю цэн';

  @override
  String get preferences_prices_metrics_title => 'Паказчыкі адкрытай цаны';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Сачыце за развіццём праекта';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Спосабы ўнясення ўкладу';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Пацвердзіце цэны, дададзеныя вамі або іншымі, з дапамогай штучнага інтэлекту';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Хутка дадайце шмат чэкаў або фотаздымкаў паліц з галерэі камеры';

  @override
  String get preferences_prices_challenges_title => 'Штомесячныя выклікі';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Удзельнічайце ў штомесячных тэматычных квэстах, каб збіраць прызы';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Аднавіце свае даныя лаяльнасці';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Даведайцеся, як запытаць свае дадзеныя';

  @override
  String get preferences_page_customize_app_title => 'Наладзьце праграму';

  @override
  String get preferences_page_contribute_project_title =>
      'Зрабіце свой унёсак у праект';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Простыя спосабы дапамагчы Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Метадалогіі ацэнкі, дапамога і іншае пра праект';

  @override
  String get product_edit_robotoff_positive_button => 'Прыняць прапанову';

  @override
  String get product_edit_robotoff_negative_button => 'Адхіліць прапанову';

  @override
  String get product_edit_robotoff_show_proof => 'Паказаць доказ';

  @override
  String get product_edit_robotoff_expand_proof => 'Пашырыць доказ';

  @override
  String get product_page_tab_raw_data => 'Неапрацаваныя дадзеныя';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Старонка $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Старонка $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count з $total элементаў';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count з $total элементаў';
  }

  @override
  String item_count(int count) {
    return '$count прадметаў';
  }

  @override
  String item_count_string(String count) {
    return '$count прадметаў';
  }

  @override
  String get prices_no_result => 'Статыстыка цэн не знойдзена.';

  @override
  String get prices_error_loading_more_items =>
      'Памылка пры загрузцы дадатковых элементаў';

  @override
  String get prices_proof_error =>
      'Памылка аўтэнтыфікацыі, не ўдалося атрымаць доказы';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count з $total доказаў';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count з $total удзельнікаў';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count з $total месцаў';
  }

  @override
  String prices_locations_count(int count) {
    return '$count месцаў';
  }

  @override
  String get restart_to_apply_message =>
      'Калі ласка, перазапусціце праграму, каб змены ўступілі ў сілу.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Графічны інтэрфейс';

  @override
  String get preferences_app_settings_media_title => 'СМІ';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Адкрытыя лабараторыі фактаў пра ежу';

  @override
  String get preferences_root_account_title => 'Уліковы запіс';

  @override
  String get preferences_contribute_translate_header =>
      'Перанясіце Open Food Facts на сваю мову';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Зарэгіструйцеся ў альфа-версіі праграмы';

  @override
  String get preferences_dev_mode_section_data =>
      'Уклад і дадзеныя аб прадукце';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Не паказваць фолксаномію';

  @override
  String get preferences_account_title => 'Уліковы запіс';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Дададзена $created';
  }

  @override
  String get location_map_details_title => 'Звесткі пра месцазнаходжанне';

  @override
  String get location_map_details_name => 'Імя';

  @override
  String get location_map_details_street => 'Вуліца';

  @override
  String get location_map_details_city => 'Горад';

  @override
  String get location_map_details_postcode => 'Паштовы індэкс';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Каардынаты';

  @override
  String get location_map_details_osm_id => 'Ідэнтыфікатар OSM';
}
