// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Azerbaijani (`az`).
class AppLocalizationsAz extends AppLocalizations {
  AppLocalizationsAz([String locale = 'az']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Bəli';

  @override
  String get add => 'Əlavə eləyin';

  @override
  String get account_delete_message =>
      'Hesabınızı silmək istədiyinizə əminsiniz?\nƏgər konkret bir səbəb varsa, zəhmət olmasa aşağıda paylaşın';

  @override
  String get reason => 'Səbəb';

  @override
  String get okay => 'Oldu';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'Yarat';

  @override
  String get applyButtonText => 'Tətbiq et';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'Davam et';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'Yuxarıya qayıt';

  @override
  String get save => 'Save';

  @override
  String get save_confirmation => 'Yadda saxlamaq istədiyinizə əminsiniz?';

  @override
  String get skip => 'Ötür';

  @override
  String get cancel => 'İmtina';

  @override
  String get ignore => 'Rədd et';

  @override
  String get close => 'Bağla';

  @override
  String get no => 'Xeyr';

  @override
  String get stop => 'Dayan';

  @override
  String get finish => 'Bitir';

  @override
  String get calculate => 'Hesablayın';

  @override
  String get reset_food_prefs => 'Qida seçimlərini sıfırlayın';

  @override
  String get error => 'Nəsə səhv getdi';

  @override
  String get error_occurred => 'Bir xəta baş verdi';

  @override
  String get featureInProgress =>
      'Biz hələ də bu funksiya üzərində işləyirik, bizi izləyin';

  @override
  String get label_web => 'Vebdə baxın';

  @override
  String get learnMore => 'Daha çox məlumat əldə edin';

  @override
  String get unknown => 'Naməlum';

  @override
  String get match_very_good => 'Çox yaxşı uyğunluq';

  @override
  String get match_good => 'Yaxşı uyğunluq';

  @override
  String get match_poor => 'Uyğunsuz';

  @override
  String get match_may_not => 'May not match';

  @override
  String get match_does_not => 'Uyğun gəlmir';

  @override
  String get match_unknown => 'Naməlum uyğunluq';

  @override
  String get match_short_very_good => 'Çox yaxşı uyğunluq';

  @override
  String get match_short_good => 'Yaxşı uyğunluq';

  @override
  String get match_short_poor => 'Uyğunsuz';

  @override
  String get match_short_may_not => 'May not match';

  @override
  String get match_short_does_not => 'Uyğun gəlmir';

  @override
  String get match_short_unknown => 'Naməlum uyğunluq';

  @override
  String get licenses => 'Lisenziyalar';

  @override
  String get looking_for => 'Axtarıram';

  @override
  String get welcomeToOpenFoodFacts => 'Open Food Facts Xoş Gəlmisiniz';

  @override
  String get whatIsOff =>
      'Open Food Facts yerli icmalar tərəfindən dəstəklənən qlobal qeyri-kommersiya təşkilatıdır.';

  @override
  String get productDataUtility =>
      'Seçimlərinizə uyğun qida məlumatlarına baxın.';

  @override
  String get healthCardUtility => 'Özünüz üçün faydalı olan qidaları seçin.';

  @override
  String get ecoCardUtility => 'Planet üçün faydalı qidalar seçin.';

  @override
  String get server_error_open_new_issue =>
      'Server cavabı yoxdur! Aşağıdakı link ilə problem aça bilərsiniz.';

  @override
  String get sign_in_text =>
      'Töhfələrinizi saxlamaq üçün Açıq Qida Faktları hesabınıza daxil olun';

  @override
  String get incorrect_credentials => 'Yanlış istifadəçi adı və ya parol.';

  @override
  String get password_lost_incorrect_credentials =>
      'Bu e-poçt və ya istifadəçi adı mövcud deyil. Zəhmət olmasa, etimadnamənizi yoxlayın.';

  @override
  String get password_lost_server_unavailable =>
      'Hazırda serverlərimizdə yavaşlama müşahidə olunur və buna görə üzr istəyirik. Zəhmət olmasa, daha sonra yenidən cəhd edin.';

  @override
  String get login => 'Daxil ol';

  @override
  String get login_result_type_server_unreachable => 'Şəbəkə əlçatan deyil';

  @override
  String get login_result_type_server_issue =>
      'Serverdə problem var. Zəhmət olmasa, daha sonra cəhd edin.';

  @override
  String get login_page_username_or_email =>
      'Zəhmət olmasa, istifadəçi adı və ya e-poçt ünvanı daxil edin';

  @override
  String get login_page_password_error_empty =>
      'Zəhmət olmasa, parol daxil edin';

  @override
  String get create_account => 'Hesab yaradın';

  @override
  String get sign_in => 'Daxil ol';

  @override
  String get sign_in_mandatory => 'Bu funksiya üçün daxil olmağınız lazımdır.';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'Çıxış';

  @override
  String get sign_out_confirmation => 'Hesabdan çıxmaq istədiyinizə əminsiniz?';

  @override
  String get password => 'Şifrə';

  @override
  String get forgot_password => 'Şifrəni unutdum';

  @override
  String get forgot_password_question => 'Şifrəni unutmusunuz?';

  @override
  String get view_profile => 'Profili göstər';

  @override
  String get reset_password => 'Şifrəni sıfırlayın';

  @override
  String get reset_password_explanation_text =>
      'Şifrənizi unutduğunuz halda, parolun sıfırlanması üçün təlimatlar almaq üçün istifadəçi adınızı və ya e-poçt ünvanınızı daxil edin. Həmçinin, Spam qovluğunu yoxlamağı unutmayın.';

  @override
  String get username_or_email => 'İstifadəçi adı və ya e-poçt';

  @override
  String get reset_password_done =>
      'Şifrənizi sıfırlamaq üçün keçid olan bir e-poçt hesabınızla əlaqəli e-poçt ünvanına göndərildi. Spam qovluğunuzu da yoxlayın.';

  @override
  String get send_reset_password_mail => 'Şifrəni dəyişdirin';

  @override
  String get enter_some_text => 'Zəhmət olmasa, mətn daxil edin';

  @override
  String get sign_up_page_title => 'Qeydiyyatdan keçin';

  @override
  String get sign_up_page_action_button => 'Qeydiyyatdan keçin';

  @override
  String get sign_up_page_action_doing_it => 'Qeydiyyatdan keçmək…';

  @override
  String get sign_up_page_action_ok =>
      'Təbrik edirik! Hesabınız yeni yaradıldı.';

  @override
  String get sign_up_page_display_name_hint => 'Ad';

  @override
  String get sign_up_page_display_name_error_empty =>
      'İstifadə etmək istədiyiniz ekran adını daxil edin';

  @override
  String get sign_up_page_email_hint => 'E-poçt';

  @override
  String get sign_up_page_email_error_empty => 'E-poçt tələb olunur';

  @override
  String get sign_up_page_email_error_invalid => 'Yanlış e-poçt';

  @override
  String get sign_up_page_username_hint => 'İstifadəçi adı: Hamıya görünür';

  @override
  String get sign_up_page_username_error_empty =>
      'Zəhmət olmasa, istifadəçi adı daxil edin';

  @override
  String get sign_up_page_username_error_invalid =>
      'Zəhmət olmasa, düzgün istifadəçi adı daxil edin';

  @override
  String get sign_up_page_username_description =>
      'Username cannot contains spaces, caps or special characters.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'İstifadəçi adı $value simvoldan çox ola bilməz';
  }

  @override
  String get sign_up_page_password_hint => 'Şifrə';

  @override
  String get sign_up_page_password_error_empty =>
      'Zəhmət olmasa, parol daxil edin';

  @override
  String get sign_up_page_password_error_invalid =>
      'Zəhmət olmasa, etibarlı parol daxil edin (ən azı 6 simvol)';

  @override
  String get sign_up_page_confirm_password_hint => 'Şifrəni Təsdiqləyin';

  @override
  String get sign_up_page_confirm_password_error_empty => 'Şifrəni təsdiqləyin';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Parollar uyğun gəlmir';

  @override
  String get sign_up_page_agree_text => 'Açıq Qida Faktları ilə razıyam';

  @override
  String get sign_up_page_terms_text => 'istifadə şərtləri və töhfə';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Hesab yaratarkən İstifadə Şərtləri ilə razılaşmaq məcburidir, lakin tətbiq vasitəsilə anonim töhfələr hələ də edilə bilər.';

  @override
  String get sign_up_page_producer_checkbox => 'Mən qida istehsalçısıyam';

  @override
  String get sign_up_page_producer_hint => 'İstehsalçı/brend';

  @override
  String get sign_up_page_producer_error_empty =>
      'Zəhmət olmasa, istehsalçı və ya brend adını daxil edin';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Açıq Qida Faktları bülleteninə abunə olmaq istəyirəm (İstədiyiniz vaxt abunəlikdən çıxa bilərsiniz)';

  @override
  String get sign_up_page_user_name_already_used =>
      'İstifadəçi adı artıq mövcuddur, zəhmət olmasa, başqa istifadəçi adı seçin.';

  @override
  String get sign_up_page_email_already_exists =>
      'hesab artıq mövcuddursa, hesaba daxil olun və ya başqa bir e-poçtla cəhd edin.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Zəhmət olmasa, etibarlı bir e-poçt ünvanı təqdim edin.';

  @override
  String get sign_up_page_server_busy =>
      'Dərin təəssüf edirik, hesabınızı yaratmaqda bəzi texniki çətinliklər var. Zəhmət olmasa, daha sonra yenidən cəhd edin.';

  @override
  String get settingsTitle => 'Tənzimləmələr';

  @override
  String get darkmode => 'Mövzu';

  @override
  String get darkmode_dark => 'Qaranlıq';

  @override
  String get darkmode_light => 'İşıq';

  @override
  String get darkmode_system_default => 'Sistem standartı';

  @override
  String get thanks_for_contributing => 'Töhfə verdiyiniz üçün təşəkkürlər!';

  @override
  String get contributors_label => 'Onlar tətbiqi qururlar';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Töhfəçi: $name';
  }

  @override
  String get contributors_description =>
      'Bu tətbiqin bütün töhfəçilərinin siyahısı';

  @override
  String get support => 'Dəstək';

  @override
  String get support_join_slack => 'Slack kanalımızda kömək istəyin';

  @override
  String get support_via_forum => 'Forumumuzda kömək istəyin';

  @override
  String get support_via_email => 'Bizə e-poçt göndərin';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Tətbiq qeydləri göndərilsin?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Tətbiq qeydlərini e-poçtunuza əlavə edilmiş hissəyə daxil etmək istəyirsiniz?';

  @override
  String get termsOfUse => 'İstifadə şərtləri';

  @override
  String get legalNotices => 'Hüquqi bildirişlər';

  @override
  String get privacy_policy => 'Məxfilik siyasəti';

  @override
  String get about_this_app => 'Bu tətbiq haqqında';

  @override
  String get contribute => 'Contribute';

  @override
  String get contribute_sw_development => 'Proqram təminatının hazırlanması';

  @override
  String get contribute_develop_text =>
      'Hər bir Open Food Facts məhsulunun kodu GitHub-da mövcuddur. Koddan (açıq mənbəlidir) yenidən istifadə edə və onu bütün planetdəki hər kəs üçün təkmilləşdirməyimizə kömək edə bilərsiniz.';

  @override
  String get contribute_develop_text_2 =>
      'Sual vermək üçün ən çox istifadə edilən Open Food Facts Slack söhbət otağına qoşula bilərsiniz.';

  @override
  String get contribute_develop_dev_mode_title => 'DEV Rejimi?';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'DEV rejimini aktivləşdirin';

  @override
  String get contribute_donate_title => 'Donate';

  @override
  String get contribute_donate_header => 'Açıq Qida Faktlarına ianə edin';

  @override
  String get contribute_enroll_alpha_warning =>
      'Daxili alfa versiyası ilə məlumatların tamamilə itirilməsinin mümkün olduğunu və tətbiqin istənilən vaxt istifadəyə yararsız hala düşə biləcəyini nəzərə alın!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Tamamlanacaq məhsullar';

  @override
  String get contribute_improve_header => 'Təkmilləşdirmə';

  @override
  String get contribute_improve_text =>
      'Verilənlər bazası layihənin əsasını təşkil edir. Kömək etmək asandır və çox tezdir. Telefonunuz üçün mobil tətbiqi yükləyə və məhsullar əlavə etməyə və ya təkmilləşdirməyə başlaya bilərsiniz.\n\nDigər tərəfdən, Open Food Facts veb saytı töhfə vermək üçün bir çox yol təklif edir: ';

  @override
  String get contribute_translate_header => 'Tərcümə et';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Tərcüməyə Başlayın';

  @override
  String get contribute_translate_text =>
      'Açıq Qida Faktları 160-dan çox ölkədən məhsulları özündə birləşdirən qlobal bir layihədir. Açıq Qida Faktları daim inkişaf edən məzmunla onlarla dilə tərcümə olunur.';

  @override
  String get contribute_translate_text_2 =>
      'Tərcümələr layihənin əsas vəzifələrindən biridir';

  @override
  String get contribute_join_skill_pool =>
      'Contribute your skills to Open Food Facts. Join the skill pool!';

  @override
  String get contribute_share_header =>
      'Açıq Qida Faktlarını Dostlarınızla Paylaşın';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Loyallıq kartlarınız haqqında məlumatlarınızı GDPR ixracı tələb edərək qiymətlərə töhfə verin';

  @override
  String get tap_to_answer => 'Sualları cavablandırmaq üçün buraya toxunun';

  @override
  String get tap_to_answer_hint =>
      'Bu məhsul haqqında sualları cavablandırmaq üçün buraya toxunun';

  @override
  String get robotoff_questions_loading_hint =>
      'Bu məhsulla bağlı suallar yüklənənə qədər gözləyin';

  @override
  String get saving_answer => 'Cavabınız yadda saxlanılır';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Töhfələriniz üçün kredit almaq üçün Açıq Qida Faktları hesabınıza daxil olun';

  @override
  String get question_yes_button_accessibility_value => 'Bəli ilə cavab verin';

  @override
  String get question_no_button_accessibility_value => 'Xeyr ilə cavab verin';

  @override
  String get question_skip_button_accessibility_value => 'Bu sualı atlayın';

  @override
  String get tap_to_edit_search => 'Axtarışı redaktə etmək üçün toxunun';

  @override
  String get myPreferences => 'Seçimlərim';

  @override
  String get account_create_message =>
      'Hesabınızı yaradın və bütün dünyada qida biliklərinin artırılmasına kömək etmək üçün Açıq Qida Faktları icmasına qoşulun!';

  @override
  String get join_us => 'Bizə qoşulun';

  @override
  String get myPreferences_profile_title => 'Profiliniz';

  @override
  String get myPreferences_profile_subtitle =>
      'Açıq Qida Faktları töhfəçi hesabınızı idarə edin.';

  @override
  String get myPreferences_settings_title => 'Tətbiq Parametrləri';

  @override
  String get myPreferences_settings_subtitle => 'Qaranlıq rejim, Dillər…';

  @override
  String get myPreferences_food_title => 'Yemək Seçimləri';

  @override
  String get myPreferences_food_subtitle =>
      'Qida ilə bağlı hansı məlumatların sizin üçün ən vacib olduğunu seçin.';

  @override
  String get myPreferences_food_comment =>
      'Qida haqqında hansı məlumatların sizin üçün ən vacib olduğunu seçin ki, qidaları seçimlərinizə görə sıralayasınız, əvvəlcə maraqlandığınız məlumata baxın və uyğunluq xülasəsini əldə edin. Həmin qida seçimləri cihazınızda qalır və əgər varsa, Açıq Qida Faktları töhfəçi hesabınızla əlaqələndirilmir.';

  @override
  String get confirmResetPreferences => 'Yemək seçimlərinizi sıfırlayın?';

  @override
  String get myPersonalizedRanking => 'Fərdiləşdirilmiş reytinqim';

  @override
  String get ranking_tab_all => 'All';

  @override
  String get ranking_subtitle_match_yes => 'Sizin üçün əla bir uyğunluq';

  @override
  String get ranking_subtitle_match_no => 'Çox zəif uyğunluq';

  @override
  String get ranking_subtitle_match_maybe => 'Naməlum uyğunluq';

  @override
  String get refresh_with_new_preferences =>
      'Siyahını yeni seçimlərinizlə yeniləyin';

  @override
  String get reloaded_with_new_preferences =>
      'Yeni seçimlərinizlə yenidən yükləndi';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Kodu oxu';

  @override
  String get history_navbar_label => 'Tarixçə';

  @override
  String get list_navbar_label => 'Siyahılar';

  @override
  String get category => 'Kateqoriyaya görə filtrləyin';

  @override
  String get category_all => 'All';

  @override
  String get category_search => '(kateqoriya axtarışı)';

  @override
  String get filter => 'Filtr';

  @override
  String get scan => 'Skan ekranından məhsullar';

  @override
  String get scan_history => 'Skan tarixçəsi';

  @override
  String get search => 'Axtar';

  @override
  String get search_product_help => 'Məhsul,\nbrend və ya barkod axtarın';

  @override
  String get search_filter => 'Axtarış filtri';

  @override
  String get search_history => 'Axtarış tarixçəsi';

  @override
  String get search_store => 'Mağaza axtarın';

  @override
  String get search_store_help => 'İpucu: şəhər və ya ölkə əlavə edin';

  @override
  String get tap_for_more => 'Daha çox məlumat üçün toxunun…';

  @override
  String get product => 'Məhsul';

  @override
  String get unknownBrand => 'Naməlum marka';

  @override
  String get unknownQuantity => 'Naməlum miqdar';

  @override
  String get unknownProductName => 'Naməlum məhsul adı';

  @override
  String get label_refresh => 'Yenilə';

  @override
  String get label_reload => 'Yenidən yükləyin';

  @override
  String get image => 'Şəkil';

  @override
  String get front_photo => 'Ön şəkil';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (bu şəkil köhnəlmiş ola bilər)';
  }

  @override
  String get outdated_image_short_label => 'köhnəlmiş ola bilər';

  @override
  String get ingredients => 'Tərkibi';

  @override
  String get ingredients_editing_instructions =>
      'İlkin sıranı saxlayın. Göstərildikdə faizi göstərin. Vergül və ya defislə ayırın və tərkib hissələrini mötərizədən istifadə edin.';

  @override
  String get ingredients_editing_error =>
      'Tərkib hissələrini saxlamaq mümkün olmadı.';

  @override
  String get ingredients_editing_image_error =>
      'Yeni inqrediyent şəkli əldə etmək alınmadı.';

  @override
  String get ingredients_editing_title => 'Tərkib hissələrini redaktə edin';

  @override
  String get ingredients_photo => 'Tərkibi fotosu';

  @override
  String get packaging_editing_instructions =>
      'Bütün qablaşdırma hissələrini vergül və ya sətir keçidi ilə ayıraraq, onların miqdarını (məsələn, 1 və ya 6), növünü (məsələn, şüşə, qutu, banka), materialını (məsələn, plastik, metal, alüminium) və mümkün olduqda ölçüsünü (məsələn, 33cl) və təkrar emal təlimatlarını göstərin.\nMisal: Təkrar emal üçün 1 şüşə şüşə, atılacaq 1 plastik mantar';

  @override
  String get packaging_editing_error =>
      'Qablaşdırmanı yadda saxlamaq alınmadı.';

  @override
  String get packaging_editing_image_error =>
      'Yeni qablaşdırma şəkli əldə etmək alınmadı.';

  @override
  String get packaging_editing_title => 'Qablaşdırmanı redaktə edin';

  @override
  String get nutrition => 'Qidalanma';

  @override
  String get nutrition_facts_photo => 'Qidalanma faktları fotosu';

  @override
  String get nutrition_facts_editing_title =>
      'Qidalanma Faktlarını Redaktə Edin';

  @override
  String get packaging_information => 'Təkrar emal təlimatları';

  @override
  String get packaging_information_photo => 'Təkrar emal təlimatlarının fotosu';

  @override
  String get missing_product => 'Yeni bir məhsul tapdınız!';

  @override
  String get add_product_take_photos =>
      'Bu məhsulu Açıq Qida Faktlarına əlavə etmək üçün qablaşdırmanın şəkillərini çəkin';

  @override
  String get add_product_take_photos_descriptive =>
      'Əvvəlcə bir neçə şəkil çəkin. Məhsulu həmişə daha sonra tamamlaya bilərsiniz.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'Yeni Məhsul';

  @override
  String get new_product_found_title => 'Yeni məhsul tapıldı!';

  @override
  String get new_product_found_text =>
      'Əməkdaşlıq etdiyimiz verilənlər bazamızda **3 milyondan çox məhsul** var, lakin bu barkod mövcud deyil: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'Bu səhifədən çıxmaq istəyirsiniz?';

  @override
  String get new_product_leave_message =>
      'Deyəsən, heç nə daxil etməmisiniz. Həqiqətən də bu səhifədən çıxmaq istəyirsiniz?';

  @override
  String get new_product_dialog_description =>
      'Bu məhsulu ümumi məlumat bazamıza əlavə etmək üçün qablaşdırmanın şəkillərini çəkin';

  @override
  String get new_product_dialog_illustration_description =>
      'Naməlum Nutri-Score və Green Score ilə illüstrasiya';

  @override
  String get front_packaging_photo_button_label => 'Ön qablaşdırma şəkli';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Ön qablaşdırma fotosunun yüklənməsini təsdiqləyin';

  @override
  String get confirm_button_label => 'Təsdiqləyin';

  @override
  String get send_image_button_label => 'Şəkil göndərin';

  @override
  String get crop_page_action_saving => 'Şəkli yadda saxlayır…';

  @override
  String get crop_page_action_cropping => 'Şəkli kəsmək…';

  @override
  String get crop_page_action_local => 'Yerli versiyanın yadda saxlanılması…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ups… şəklinizlə bağlı bir şey var!';

  @override
  String get crop_page_action_local_failed_message =>
      'Şəkli serverimizə göndərməzdən əvvəl lokal olaraq emal edə bilmirik. Zəhmət olmasa, daha sonra yenidən cəhd edin və ya problem davam edərsə, bizimlə əlaqə saxlayın.';

  @override
  String get crop_page_action_retake => 'Yenidən şəkil çəkin';

  @override
  String get crop_page_too_small_image_title => 'Şəkil çox kiçikdir!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Şəkil yükləmək üçün piksellə minimum ölçü ${expectedMinWidth}x$expectedMinHeight-dir. Hazırkı şəkil ${actualWidth}x$actualHeight-dir.';
  }

  @override
  String get crop_page_action_server => 'Serverə zəng hazırlanır…';

  @override
  String get front_packaging_photo_title => 'Ön Qablaşdırma Şəkili';

  @override
  String get ingredients_photo_title => 'Tərkibi Şəkil';

  @override
  String get nutritional_facts_photo_title => 'Qidalanma Faktları Şəkil';

  @override
  String get recycling_photo_title => 'Təkrar emal təlimatları Şəkil';

  @override
  String get take_photo_title => 'Take a picture';

  @override
  String get take_more_photo_title => 'Take more photos';

  @override
  String get front_photo_uploaded => 'Ön şəkil yükləndi';

  @override
  String get ingredients_photo_button_label => 'Tərkibi fotosu';

  @override
  String get ingredients_photo_uploaded => 'Tərkib hissələrinin şəkli yükləndi';

  @override
  String get nutrition_cache_loading_error =>
      'Keşdən qida maddələrini yükləmək mümkün deyil';

  @override
  String get nutritional_facts_photo_button_label =>
      'Qidalanma faktları fotosu';

  @override
  String get nutritional_facts_input_button_label =>
      'Qidalanma faktlarını doldurun';

  @override
  String get nutritional_facts_added => 'Qidalanma faktları əlavə edildi';

  @override
  String get categories_added => 'Kateqoriyalar əlavə edildi';

  @override
  String get new_product_title_nutriscore => 'Compute the Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Ən azı bir kateqoriya və qida dəyərlərini dolduraraq bizə kömək edin';

  @override
  String get new_product_title_environmental_score => 'Yaşıl Hesabı Hesablayın';

  @override
  String get new_product_subtitle_environmental_score =>
      'Ən azı bir kateqoriya dolduraraq əldə edin';

  @override
  String get new_product_additional_environmental_score =>
      'Yaşıl Bal hesablamasını mənşəyi, qablaşdırması və daha çoxu ilə daha dəqiq edin';

  @override
  String get new_product_title_nova =>
      'Qida emalı səviyyəsini (NOVA) hesablayın';

  @override
  String get new_product_subtitle_nova =>
      'Qida kateqoriyasını və tərkib hissələrini dolduraraq əldə edin';

  @override
  String get new_product_desc_nova_unknown =>
      'Qida emalı səviyyəsi məlum deyil';

  @override
  String get new_product_title_pictures => 'Yeni məhsul';

  @override
  String get new_product_title_pictures_details =>
      'Zəhmət olmasa, aşağıdakı şəkilləri çəkin və Open Food Facts mühərriki qalanını həll edə bilər!';

  @override
  String get new_product_title_misc => 'Və bəzi əsas məlumatlar…';

  @override
  String new_product_done_msg(String username) {
    return '“$username” töhfəniz üçün təşəkkür edirik!';
  }

  @override
  String get new_product_done_msg_no_user => 'Töhfəniz üçün təşəkkürlər!';

  @override
  String get new_product_done_button_label => 'Hazır məhsulu kəşf edin';

  @override
  String get hey_incomplete_product_message =>
      'Nutri-Score, Green Score və Ultra-processing (NOVA) hesablamaq üçün İNDİ 3 suala cavab vermək üçün toxunun!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Bu kosmetik məhsulu təhlil etməyə kömək etmək üçün 2 suala cavab vermək üçün indi toxunun!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Bu ev heyvanı qidası məhsulunu təhlil etməyə kömək etmək üçün 3 suala cavab vermək üçün indi toxunun!';

  @override
  String get hey_incomplete_product_message_product =>
      'Bu məhsulu tamamlamağa kömək etmək üçün indi vurun!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Qidalanma faktları şəkli yükləndi';

  @override
  String get recycling_photo_button_label => 'Təkrar emal fotosu';

  @override
  String get recycling_photo_uploaded => 'Təkrar emal fotosu yükləndi';

  @override
  String get take_more_photo_button_label => 'Take more photos';

  @override
  String get other_photo_uploaded => 'Müxtəlif şəkil yükləndi';

  @override
  String get retake_photo_button_label => 'Yenidən götür';

  @override
  String get selecting_photo => 'Foto seçilir';

  @override
  String get uploading_image => 'Şəkil serverə yüklənir';

  @override
  String get uploading_image_type_front =>
      'Ön şəkli Open Food Facts-a yükləyir';

  @override
  String get uploading_image_type_ingredients =>
      'Tərkib hissələrinin şəkli Open Food Facts-a yüklənir';

  @override
  String get uploading_image_type_nutrition =>
      'Qidalanma şəkli Open Food Facts-a yüklənir';

  @override
  String get uploading_image_type_packaging =>
      'Qablaşdırma şəkli Open Food Facts-a yüklənir';

  @override
  String get uploading_image_type_other =>
      'Open Food Facts-a digər şəkil yüklənir';

  @override
  String get uploading_image_type_generic => 'Şəkil Open Food Facts-a yüklənir';

  @override
  String get score_add_missing_ingredients =>
      'Yarımçıq tərkib hissələrini əlavə edin';

  @override
  String get score_add_missing_packaging_image =>
      'Çatışmayan qablaşdırma şəklini əlavə edin';

  @override
  String get score_add_missing_nutrition_facts =>
      'Çatışmayan qidalanma faktlarını əlavə edin';

  @override
  String get score_add_missing_product_traces =>
      'Məhsulun itkin izlərini əlavə edin';

  @override
  String get score_add_missing_product_category => 'Kateqoriya seçin';

  @override
  String get score_add_missing_precise_product_category =>
      'Daha dəqiq kateqoriya seçin';

  @override
  String get score_add_missing_product_countries =>
      'Məhsulun çatışmayan ölkələrini əlavə edin';

  @override
  String get score_add_missing_product_emb =>
      'Məhsulun izlənilə bilən kodlarının itkin düşdüyünü əlavə edin';

  @override
  String get score_add_missing_product_labels =>
      'Məhsul etiketlərinin çatışmadığını əlavə edin';

  @override
  String get score_add_missing_product_origins =>
      'Məhsul mənşəyinin çatışmadığını əlavə edin';

  @override
  String get score_add_missing_product_stores =>
      'İtkin məhsul mağazaları əlavə edin';

  @override
  String get score_add_missing_product_brands =>
      'İtkin məhsul brendlərini əlavə edin';

  @override
  String get score_update_nutrition_facts => 'Qidalanma faktlarını yeniləyin';

  @override
  String get nutrition_page_title => 'Qidalanma Faktları';

  @override
  String get nutrition_page_nutritional_info_title => 'Qidalanma məlumatları';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Məhsulda göstərilən dəyərlər:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Bəli';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Xeyr';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Açıq foto';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Yaxşı təcrübələr: Qidalanma məlumatları';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Bəzən qidalanma məlumatları **qablaşdırmada** və ya məhsulla birlikdə verilən sənəddə göstərilmir. Bu halda və yalnız bu halda, dəyəri **YOX** olaraq təyin edə bilərsiniz.';

  @override
  String get nutrition_page_serving_type_label => 'Qida dəyərləri:';

  @override
  String get nutrition_page_per_100g => '100 q üçün';

  @override
  String get nutrition_page_per_100g_100ml => '100 q/ml üçün';

  @override
  String get nutrition_page_per_serving => 'porsiya başına';

  @override
  String get nutrition_page_add_nutrient => 'Qidalandırıcı maddə əlavə edin';

  @override
  String get nutrition_page_serving_size => 'Porsiya ölçüsü';

  @override
  String get nutrition_page_serving_size_hint =>
      'Porsiya ölçüsünü daxil edin (məsələn: 100 q)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Yaxşı təcrübələr: Porsiya ölçüsü';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Bu dəyər **hər bir qida maddəsinin porsiya ölçüsünə mütənasib hesablanmasına** kömək edir.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**İcazə verilən vahidlər** bunlardır: kq, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 q**, **60 q** və ya **60 q** (birincisi üstünlük təşkil edir)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** və ya **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Yanlış vahid';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **qr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Yanlış vahidlər';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **konfet** və 2 **peçenye**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Vahid çatışmır';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Yanlış nömrə';

  @override
  String get nutrition_page_update_running => 'Məhsul serverdə yenilənir…';

  @override
  String get nutrition_page_update_done => 'Məhsul yeniləndi!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Məhsul miqdarını porsiya ölçüsü kimi istifadə edin';

  @override
  String get nutrition_page_photo_error => 'Fotonu yükləmək mümkün deyil';

  @override
  String get more_photos => 'Daha maraqlı fotolar';

  @override
  String get view_more_photo_button =>
      'Bu məhsul üçün bütün mövcud şəkillərə baxın';

  @override
  String get no_product_found => 'Heç bir məhsul tapılmadı';

  @override
  String get no_location_found => 'Yer tapılmadı';

  @override
  String get not_found => 'tapılmadı:';

  @override
  String get refreshing_product => 'Təravətləndirici məhsul';

  @override
  String get product_refreshed => 'Məhsul yeniləndi';

  @override
  String product_image_accessibility_label(String date) {
    return 'Şəkil ${date}tarixində çəkilib';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Şəkil ${date}tarixində çəkilib. Bu şəkil köhnəlmiş ola bilər.';
  }

  @override
  String get product_image_outdated => 'Bu şəkil köhnəlmiş ola bilər';

  @override
  String get product_image_outdated_explanations_title =>
      'Bu şəkil köhnəlmiş ola bilər';

  @override
  String get product_image_outdated_explanations_content =>
      'Bu şəkil bir ildən çox əvvəl çəkilib.\n**Zəhmət olmasa, hələ də yenilənib-yenilənmədiyini yoxlayın**.\n\nBu, **sadəcə bir xəbərdarlıqdır**. Məzmun hələ də eynidirsə, bu mesajı qulaqardına vura bilərsiniz.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Şəkli dəyişdirin ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Şəkil əlavə edin ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Take a picture';

  @override
  String get product_image_action_from_gallery =>
      'Telefonunuzun qalereyasından seçin';

  @override
  String get product_image_action_choose_existing_photo =>
      'Məhsul şəkillərindən seçin';

  @override
  String get product_image_details_label => 'Foto haqqında məlumat';

  @override
  String get product_image_details_from_producer => 'Prodüserdən';

  @override
  String get product_image_details_contributor => 'Töhfə verən';

  @override
  String get product_image_details_contributor_producer => 'Töhfəçi (prodüser)';

  @override
  String get product_image_details_date => 'Tarix';

  @override
  String get product_image_details_date_unknown => 'Naməlum';

  @override
  String get homepage_main_card_logo_description =>
      'Açıq Qida Faktlarına Xoş Gəlmisiniz';

  @override
  String get homepage_main_card_subheading =>
      '**Barkodu skan edin** və ya\nməhsulu **axtarın**';

  @override
  String get homepage_main_card_search_field_hint => 'Məhsul axtarın';

  @override
  String get homepage_main_card_search_field_tooltip => 'Axtarışa başlayın';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Son xəbərlər: $news_title';
  }

  @override
  String get tagline_app_review => 'Tətbiqi bəyəndinizmi?';

  @override
  String get tagline_app_review_button_positive => 'Çox bəyəndim! 😍';

  @override
  String get tagline_app_review_button_negative => 'Əslində…deyil';

  @override
  String get tagline_app_review_button_later => 'Daha sonra soruşun';

  @override
  String get tagline_feed_news_button => 'Daha çox məlumat əldə edin';

  @override
  String get app_review_negative_modal_title => 'Tətbiqimizi bəyənmirsiniz?';

  @override
  String get app_review_negative_modal_text =>
      'Səbəbini bizə izah etmək üçün bir neçə saniyə vaxt ayıra bilərsinizmi?';

  @override
  String get app_review_negative_modal_positive_button => 'Bəli, mütləq!';

  @override
  String get app_review_negative_modal_negative_button => 'Xeyr';

  @override
  String get could_not_refresh => 'Məhsulu yeniləmək mümkün olmadı';

  @override
  String get product_internet_error_modal_title => 'Xəta baş verdi!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Şəbəkə xətası səbəbindən bu məhsul haqqında məlumat əldə edə bilmirik. Zəhmət olmasa, internet bağlantınızı yoxlayın və yenidən cəhd edin.\n\nDaxili xəta:\n$error';
  }

  @override
  String get product_tags_title => 'Məhsul xüsusiyyətləri';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Mülkiyyət yoxdur';

  @override
  String get product_tags_explanation =>
      'Məhsula xassələr (açar/dəyər) əlavə etməklə siz onu zənginləşdirməyə kömək edirsiniz.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Xüsusiyyətlər əlavə edin';

  @override
  String get add_edit_tags => 'Xüsusiyyətlər əlavə edin və ya redaktə edin';

  @override
  String get edit_tag => 'Xüsusiyyəti redaktə edin';

  @override
  String get remove_tag => 'Əmlakı silin';

  @override
  String get tag_key => 'Əmlak';

  @override
  String get tag_keys => 'Xüsusiyyətlər';

  @override
  String get tag_key_uneditable => 'Əmlak (redaktə edilə bilməz)';

  @override
  String get tag_key_input_hint => 'Xüsusiyyət daxil edin';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Dəyər daxil edin';

  @override
  String get tag_key_item => 'Əmlak:';

  @override
  String get tag_value_item => 'Dəyər:';

  @override
  String get tag_key_explanations =>
      'Açar kiçik hərflərlə yazılmalı və boşluq olmadan yazılmalıdır.';

  @override
  String tag_key_already_exists(String property) {
    return '$property xüsusiyyətinə malik etiket artıq mövcuddur!';
  }

  @override
  String get product_internet_error =>
      'Şəbəkə xətası səbəbindən bu məhsul haqqında məlumat əldə etmək mümkün deyil.';

  @override
  String get cached_results_from => 'Nəticələri göstər:';

  @override
  String get product_search_same_category => 'Alternativləri tapın';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'Bu xüsusiyyət yalnız kateqoriyalı məhsullar üçün istifadə edilə bilər.\n\nKateqoriya əlavə etmək üçün məhsulu redaktə edin.';

  @override
  String get product_improvement_add_category =>
      'Add a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Add nutrition facts to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Add nutrition facts and a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Bu məhsul üçün Nutri-Score hesablana bilmir, bu da, məsələn, qeyri-standart kateqoriya ilə əlaqəli ola bilər. Əgər bu, səhv hesab olunursa, zəhmət olmasa, bizimlə əlaqə saxlayın.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Qidalanma şəkli köhnəlib: zəhmət olmasa, yeniləyin.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Yaşıl Hesab inqrediyentlərin mənşəyini nəzərə alır. Zəhmət olmasa, inqrediyent siyahısının və/və ya hər hansı coğrafi iddianın şəklini çəkin və ya məhsulu redaktə edin ki, onlar nəzərə alınsın.';

  @override
  String get country_chooser_label => 'Zəhmət olmasa, ölkə seçin';

  @override
  String get currency_chooser_label => 'Zəhmət olmasa, valyuta seçin';

  @override
  String get country_change_message => 'Siz sadəcə ölkələri dəyişmisiniz.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Valyutanı $previousCurrency -dan $possibleCurrency-a dəyişdirmək istəyirsiniz?';
  }

  @override
  String get onboarding_country_chooser_label => 'Zəhmət olmasa, ölkə seçin:';

  @override
  String get country_chooser_label_from_settings => 'Ölkəniz';

  @override
  String get country_selection_explanation =>
      'Bəzi ətraf mühit xüsusiyyətləri yerləşməyə xasdır';

  @override
  String get product_removed_comparison => 'Məhsul müqayisədən silindi';

  @override
  String get native_app_settings => 'Yerli Tətbiq Parametrləri';

  @override
  String get native_app_description =>
      'Açıq Qida Faktları üçün Açıq Sistem Parametrləri';

  @override
  String get product_removed_history => 'Məhsul tarixçədən silindi';

  @override
  String get product_removed_list => 'Məhsul siyahıdan silindi';

  @override
  String get product_could_not_remove => 'Məhsulu silmək mümkün olmadı';

  @override
  String get no_prodcut_in_list => 'Bu siyahıda heç bir məhsul yoxdur';

  @override
  String get no_product_in_section => 'Bu bölmədə məhsul yoxdur';

  @override
  String get recently_seen_products => 'Bütün baxılan məhsullar';

  @override
  String get clear => 'Təmizlə';

  @override
  String get clear_long => 'Siyahını boşaldın';

  @override
  String get really_clear => 'Bu siyahını həqiqətən silmək istəyirsiniz?';

  @override
  String pct_match(Object percent) {
    return '$percent% uyğunluq';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count gün əvvəl',
      one: 'bir gün əvvəl',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count saat əvvəl',
      one: 'bir saat əvvəl',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dəqiqə əvvəl',
      one: 'bir dəqiqə əvvəl',
      zero: 'bir dəqiqədən az əvvəl',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ay əvvəl',
      one: 'bir ay əvvəl',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count həftə əvvəl',
      one: 'bir həftə əvvəl',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Müqayisə Edin $count Məhsullar',
      one: 'Bir Məhsulu Müqayisə Edin',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count seçilmiş məhsullar',
      one: 'Seçilmiş bir məhsul',
      zero: 'Seçilmiş məhsul yoxdur',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Seçilmiş məhsulları müqayisə edin';

  @override
  String get delete_products_mode => 'Seçilmiş məhsulları silin';

  @override
  String get select_all_products_mode => 'Bütün məhsulları seçin';

  @override
  String get select_none_products_mode => 'Heç birini seçməyin';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle =>
      'Zəhmət olmasa, ən azı iki məhsul seçin';

  @override
  String get retry_button_label => 'Yenidən sına';

  @override
  String get connect_with_us => 'Bizimlə əlaqə saxlayın';

  @override
  String get tiktok => 'Bizi TikTok-da izləyin';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Bizi İnstaqramda izləyin';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Bizi X-də (əvvəllər Twitter) izləyin';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Bizi Mastodon-da izləyin';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Bizi BlueSky-da izləyin';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Bloq';

  @override
  String get faq => 'Tez-tez verilən suallar';

  @override
  String get discover => 'Kəşf et';

  @override
  String get how_to_contribute => 'Necə töhfə vermək olar';

  @override
  String get hint_knowledge_panel_message =>
      'Gördükləriniz haqqında daha çox məlumat əldə etmək üçün kartın istənilən hissəsinə toxuna bilərsiniz. İndi sınayın!';

  @override
  String get permissions_page_title => 'Kamera girişi';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'Fikrinizi dəyişsəniz, bu seçim istənilən vaxt parametrlərdən aktivləşdirilə və deaktiv edilə bilər.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'ƏS: Android (SDK Int: $sdkInt / Buraxılış: $release)\nModel: $model\nMəhsul: $product\nCihaz: $device\nBrend:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'ƏS: iOS ($version)\nModel: $model\nLokallaşdırılmış model: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nTətbiq versiyası:$appVersion\nTətbiqin qurulma nömrəsi:$appBuildNumber\nTətbiq paketinin adı:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'Rədd et';

  @override
  String get ask_me_later_button_label => 'Sonradan';

  @override
  String get are_you_sure => 'Əminsən?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return '${sourceName}səhifəsinə keçin';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Xoş gəlmisiniz!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Özünüz və planetiniz üçün faydalı qida seçməyinizə kömək edən tətbiq!';

  @override
  String get onboarding_continue_button => 'Davam et';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'İlk nümunə məhsulunuz yüklənir';

  @override
  String get onboarding_welcome_warning =>
      'Üzr istəyirik, bu bizim nümunə məhsulumuzdur, onu redaktə edə bilməzsiniz :)';

  @override
  String get product_list_your_ranking => 'Reytinqiniz';

  @override
  String get product_list_empty_icon_desc => 'Tarixçə əlçatan deyil';

  @override
  String get product_list_empty_title => 'Skan etməyə başlayın';

  @override
  String get product_list_empty_message =>
      'Skan edilmiş məhsullar burada görünəcək və onlar haqqında ətraflı məlumatı yoxlaya bilərsiniz';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'məhsullar',
      one: 'məhsul',
      zero: 'məhsul',
    );
    return 'Tarixçənizdə $_temp0 təravətləndirici';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Məhsullar',
      one: 'Məhsul',
      zero: 'Məhsul',
    );
    return '$_temp0 yeniləmə tamamlandı';
  }

  @override
  String get product_list_compare_side_by_side => 'Yan-yana müqayisə edin';

  @override
  String get loading_dialog_default_title => 'Məlumatlar yüklənir';

  @override
  String get loading_dialog_default_error_message =>
      'Məlumatları yükləmək mümkün olmadı';

  @override
  String get account_delete => 'Hesabı silin';

  @override
  String get account_delete_title => 'Hesabımı silin';

  @override
  String get user_profile => 'Hesab';

  @override
  String get user_profile_title_guest => 'Xoş gəlmisiniz!';

  @override
  String get user_profile_subtitle_guest =>
      'Açıq Qida Faktları icmasına qoşulmaq üçün daxil olun və ya qeydiyyatdan keçin';

  @override
  String user_profile_title_id_email(String email) {
    return 'Açıq Qida Məlumatları girişi: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Xoş gəlmisiniz $id!';
  }

  @override
  String get email_subject_account_deletion => 'Hesabı silin';

  @override
  String email_body_account_deletion(String userId) {
    return 'Salam, xahiş edirəm Open Food Facts hesabımı silin: $userId';
  }

  @override
  String get settings_app_app => 'Tətbiq';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Məhsullar';

  @override
  String get settings_app_miscellaneous => 'Müxtəlif';

  @override
  String get camera_play_sound_title => 'Skanlama zamanı səs oxudun';

  @override
  String get camera_play_sound_subtitle =>
      'Hər uğurlu taramada səs siqnalı veriləcək';

  @override
  String get camera_window_accessibility_label =>
      'Kameranızla barkod skan edin';

  @override
  String get app_haptic_feedback_title => 'Vibrasiya və Haptika';

  @override
  String get app_haptic_feedback_subtitle =>
      'Bəzi hərəkətləri yerinə yetirdikdən sonra titrəmələr (barkod deşifrə edildi, məhsul silindi…).';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Aktivləşdirildikdə, xəta hesabatları avtomatik olaraq Open Food Facts-ın xəta izləmə sisteminə göndərilir ki, xətalar düzəldilə və tətbiq təkmilləşdirilə bilsin.';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Fotonu redaktə edin';

  @override
  String get permission_photo_error => 'Xəta';

  @override
  String get permission_photo_denied_title =>
      'Barkodları skan etmək üçün kameradan istifadəyə icazə verin';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Təkmilləşdirilmiş təcrübə üçün, xahiş edirik $appName tətbiqinin kameranıza daxil olmasına icazə verin. Barkodları birbaşa skan edə biləcəksiniz.';
  }

  @override
  String get permission_photo_denied_button => 'İcazə verin';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'İcazə rədd edildi';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Əvvəllər kamera icazəsini rədd etdiyiniz üçün onu Parametrlərdən əl ilə icazə verməlisiniz.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Parametrləri açın';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'İmtina';

  @override
  String get permission_photo_none_found => 'Kamera aşkarlanmadı';

  @override
  String get permission_photo_denied => 'Kameraya giriş icazəsi verilməyib';

  @override
  String get show_product_pictures => 'Məhsul şəkillərini göstər';

  @override
  String get edit_product_label => 'Məhsula düzəliş et';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Düzəlişləriniz yüklənir…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Düzəlişləriniz **arxa planda** (və ya səhv olarsa, daha sonra göndərilir) göndərilir.\nDigər məhsul sahələrini redaktə etməyə davam edə bilərsiniz.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Düzəlişləriniz **arxa planda** (və ya səhv olarsa, daha sonra) göndərilir.';

  @override
  String get edit_product_label_short => 'Düzəliş etmək';

  @override
  String edit_product_form_item_help(String value) {
    return '\"$value\" necə daxil edilir?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Zəhmət olmasa, boş olmayan bir dəyər daxil edin!';

  @override
  String get edit_product_form_item_error_existing =>
      'Bu dəyər artıq mövcuddur!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Yeni bir brend əlavə edin';

  @override
  String get edit_product_form_item_add_action_label =>
      'Yeni etiket əlavə edin';

  @override
  String get edit_product_form_item_add_action_store =>
      'Yeni mağaza əlavə edin';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Yeni bir mənbə əlavə edin';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Yeni izləmə kodu əlavə edin';

  @override
  String get edit_product_form_item_add_action_country =>
      'Yeni bir ölkə əlavə edin';

  @override
  String get edit_product_form_item_add_action_category =>
      'Yeni bir kateqoriya əlavə edin';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Yeni bir iz əlavə edin';

  @override
  String get edit_product_form_item_add_suggestion => 'Təklif əlavə edin';

  @override
  String get edit_product_form_item_deny_suggestion => 'Təklifi rədd edin';

  @override
  String get edit_product_form_item_details_title => 'Əsas detallar';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Məhsulun adı, markası, miqdarı';

  @override
  String get edit_product_form_item_other_details_title => 'Əlavə məlumatlar';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Veb sayt…';

  @override
  String get edit_product_form_item_photos_title => 'Şəkillər';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Şəkillər əlavə edin və ya yeniləyin';

  @override
  String get edit_product_form_item_labels_title =>
      'Etiketlər və Sertifikatlar';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Ətraf mühit, keyfiyyət etiketləri…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Etiket daxil edin (məsələn: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'etiket';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Yaxşı təcrübələr: Etiketlər';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Məhsulun **faktiki** və digər sahələrdən fərqli olan istənilən xüsusiyyəti.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Belçikada istehsal olunub, Bretaniyada istehsal olunub…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Liflə zəngindir, dəmir mənbəyidir…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Ədalətli ticarət, Maks Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Mağazalar';

  @override
  String get edit_product_form_item_stores_hint => 'Mağaza daxil edin';

  @override
  String get edit_product_form_item_stores_type => 'mağaza';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Yaxşı təcrübələr: Mağazalar';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Məhsulu aldığınız mağazanın adını daxil edin.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Mənşəyi';

  @override
  String get edit_product_form_item_origins_hint =>
      'Mənşəyini daxil edin (məsələn: Almaniya)';

  @override
  String get edit_product_form_item_origins_type => 'ölkə';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Yaxşı təcrübələr: Mənşəyi';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Qablaşdırmada tapa biləcəyiniz mənşəyinə dair hər hansı bir göstəricini əlavə edin**.\nTərkib hissələri siyahısında birbaşa göstərilən mənşəy barədə narahat olmağınıza ehtiyac yoxdur.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Argentinadan mal əti';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soya Avropa Birliyindən gəlmir';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Ölkə daxil edin (məsələn: Almaniya)';

  @override
  String get edit_product_form_item_countries_type => 'ölkə';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Yaxşı təcrübələr: Ölkələr';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Məhsulun geniş şəkildə mövcud olduğu ölkələr** (xarici məhsullar üzrə ixtisaslaşmış mağazalar istisna olmaqla).';

  @override
  String get edit_product_form_item_emb_codes_title => 'İzlənilə bilən kodlar';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Kodu daxil edin (məsələn: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'izləmə kodu';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Yaxşı təcrübələr: İzlənilə bilən kodlar';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Bu bölmədə **qablaşdırma nişanları**, **identifikasiya nişanları** və ya **sağlamlıq nişanları** ilə əlaqəli kodları daxil edə bilərsiniz.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'İzlənilə bilən kodların nümunələri';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      'Avropa Birliyində qida istehsalçılarını və ya qablaşdırıcılarını müəyyən etmək üçün istifadə edilən **AB kodları**:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: **Fransa** ölkə kodu\n**72.264.002**: coğrafi məlumatlar\n**CE**: Avropa Birliyi';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      'Fransada istifadə edilən **EMB kodları**:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Traces';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'İz daxil edin (məsələn: Soya paxlası)';

  @override
  String get edit_product_form_item_categories_title => 'Kateqoriyalar';

  @override
  String get edit_product_form_item_categories_hint => 'kateqoriya';

  @override
  String get edit_product_form_item_categories_type =>
      'Kateqoriya daxil edin (məsələn: Portağal şirəsi)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Yaxşı təcrübələr: Kateqoriyalar';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      '**Yalnız ən spesifik kateqoriyanı** göstərin.\nƏsas kateqoriyalar avtomatik olaraq əlavə olunacaq.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Kateqoriya çatışmır?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Əgər kateqoriya avtomatik tamamlamada mövcud deyilsə, onu əlavə etməkdən çəkinməyin.\nBu, ölkənizdə Açıq Qida Faktlarını təkmilləşdirməyimizə kömək edəcək.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Zeytun yağında sardina';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Konsentratdan portağal suyu';

  @override
  String get edit_product_form_item_exit_title =>
      'Yadda saxlamadan çıxmaq istəyirsiniz?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Bu səhifədən çıxmazdan əvvəl dəyişikliklərinizi yadda saxlamaq istəyirsiniz?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Dəyişiklikləri yadda saxla';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Dəyişiklikləri ləğv edin';

  @override
  String get edit_product_form_item_ingredients_title => 'Tərkibi';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Ekranı sıxaraq böyüdün və kiçildin';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Şəkli böyüdün və kiçildin';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '**Böyütmək üçün çimdikləmə jestindən** istifadə edərək, şəkli böyüdə və ya kiçildə bilərsiniz:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Əlavə eləyin';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Əvvəlcə mətn daxil edin';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Sil';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Düzəlişinizi yadda saxlayın';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Redaktənizi ləğv edin';

  @override
  String get edit_product_form_item_packaging_title =>
      'Təkrar emal təlimatlarının fotosu';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Qidalanma faktları';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Qidalanma, spirt tərkibi…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Yaxşı təcrübələr: Qidalanma faktları';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Qida dəyərləri';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Əvvəlcə, **dəyərlərin** verilib-verilmədiyini seçin:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Qidalanma faktları';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Daha sonra, qida dəyərlərini **qablaşdırmada göstərildiyi kimi** daxil edin. Əgər heç bir dəyər yoxdursa, \"Göz\" işarəsinə klikləyə bilərsiniz.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Sahə çatışmır?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Əgər bir qeyd yoxdursa, onu əlavə etmək üçün **\"Plus\" işarəsinə** klikləyə bilərsiniz (məsələn: D vitamini, maqnezium…).';

  @override
  String get edit_product_form_save => 'Düzəliş etmək';

  @override
  String get edit_product_ingredients_photo_title => 'Tərkibi fotosu';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Qablaşdırma şəkli';

  @override
  String get edit_product_packaging_list_title => 'Qablaşdırma siyahısı';

  @override
  String get no_data_available => 'Məlumat mövcud deyil';

  @override
  String get product_field_website_title => 'Veb sayt';

  @override
  String get origins_editing_title => 'Mənşəyini redaktə edin';

  @override
  String get completed_basic_details_btn_text => 'Əsas detalları tamamlayın';

  @override
  String get not_implemented_snackbar_text => 'Hələ tətbiq olunmayıb';

  @override
  String get category_picker_page_appbar_text => 'Kateqoriyalar';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Fotoşəkildən inqrediyentləri çıxarın';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Fotodan\nmaddələrin çıxarılması';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Şəkil yüklənir…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Niyə bu mesajı görürəm?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      '\"Tərkib hissələrini çıxarın\" funksiyasından istifadə etmək üçün əvvəlcə foto yüklənməlidir.\n\nZəhmət olmasa, bir neçə saniyə gözləyin və ya onları əl ilə daxil edin.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Şəkli yeniləyin';

  @override
  String get edit_packaging_extract_btn_text =>
      'Şəkildən qablaşdırmanı\nçıxarın';

  @override
  String get edit_packaging_extract_btn_text_short => 'Qablaşdırmanı çıxarın';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Şəkildən qablaşdırma çıxarılır';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Şəkil yüklənir…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Niyə bu mesajı görürəm?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      '\"Qablaşdırmanı çıxarın\" funksiyasından istifadə etmək üçün əvvəlcə foto yüklənməlidir.\n\nZəhmət olmasa, bir neçə saniyə gözləyin və ya onları əl ilə daxil edin.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Şəkli yeniləyin';

  @override
  String get edit_ocr_extract_failed => 'Şəkildəki mətni aşkarlamaq alınmadı.';

  @override
  String get edit_ocr_extract_disabled_title => 'Şəkil yoxdur!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Mətn çıxarma funksiyasından istifadə etmək üçün əvvəlcə şəkil çəkməlisiniz.';

  @override
  String get user_list_dialog_new_title => 'Yeni məhsulların siyahısı';

  @override
  String get user_list_dialog_rename_title => 'Siyahının adını dəyişin';

  @override
  String get user_list_subtitle_product => 'Siyahılar';

  @override
  String get user_list_title => 'Your lists';

  @override
  String get user_list_add_product => 'Məhsulu siyahılarınıza əlavə edin';

  @override
  String get user_list_button_new => 'Yeni siyahı yaradın';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Siyahıya əlavə edin';

  @override
  String get added_to_list_msg => 'Siyahıya əlavə edildi';

  @override
  String get user_list_popup_clear => 'Tarixçənizi təmizləyin';

  @override
  String get user_list_popup_rename => 'Adını dəyiş';

  @override
  String get user_list_name_hint => 'Mənim siyahım';

  @override
  String get user_list_name_error_empty => 'Ad məcburidir';

  @override
  String get user_list_name_error_already => 'Bu ad artıq istifadə olunur';

  @override
  String get user_list_name_error_same => 'Bu eyni addır';

  @override
  String get user_list_name_input_hint => 'Siyahının adı';

  @override
  String get try_again => 'Yenidən cəhd edin';

  @override
  String get there_was_an_error => 'Xəta baş verdi';

  @override
  String category_picker_no_category_found_message(String items) {
    return '$itemsüçün heç bir kateqoriya tapılmadı';
  }

  @override
  String get camera_toggle_camera => 'Arxa və ön kamera arasında keçid';

  @override
  String get camera_toggle_flash => 'Kameranın flaşını yandırın və ya söndürün';

  @override
  String get camera_enable_flash => 'Fləşi aktivləşdirin';

  @override
  String get camera_disable_flash => 'Fləşi deaktiv edin';

  @override
  String get camera_flash_error_dialog_title => 'Xəta baş verdi!';

  @override
  String get camera_flash_error_dialog_message =>
      'Fləşinizin vəziyyətini dəyişdirərkən xəta baş verdi. Zəhmət olmasa, smartfonunuzda fənərin artıq aktiv olmadığından əmin olun.';

  @override
  String get category_picker_no_category_found_button => 'Geri';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Brauzerinizdə və ya tətbiqdə (əgər quraşdırılıbsa) açmaq üçün klikləyin';

  @override
  String get dev_preferences_screen_title => 'DEV Rejimi';

  @override
  String get dev_preferences_screen_subtitle =>
      'Eksperimental xüsusiyyətlərə və inkişaf alətlərinə daxil olun';

  @override
  String get dev_preferences_reset_onboarding_title => 'Yenidən qoşulma';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Daha sonra onu yenidən görmək üçün tətbiqi yenidən başlatmalısınız.';

  @override
  String get dev_preferences_environment_switch_title =>
      'openfoodfacts.org (PROD) və test mühiti arasında keçid edin';

  @override
  String get dev_preferences_test_environment_title =>
      'Test mühit parametrləri';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Cari test mühiti üçün əsas URL: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Test mühiti sahibi';

  @override
  String get dev_preferences_ml_kit_title => 'ML Kitindən istifadə edin';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'sonra bu tətbiqi yenidən başlatmalısınız';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Məhsul səhifəsində əlavə düymə';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Bilik paneli düyməsi vasitəsilə inqrediyentləri redaktə edin';

  @override
  String get dev_preferences_export_history_title => 'İxrac Tarixçəsi';

  @override
  String get dev_preferences_export_history_progress_error => 'istisna';

  @override
  String get dev_preferences_export_history_progress_found => 'məhsul tapıldı';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'məhsul TAPILMADI';

  @override
  String get dev_preferences_export_history_dialog_title => 'İxrac tarixçəsi';

  @override
  String get dev_preferences_button_positive => 'Yaxşı';

  @override
  String get dev_preferences_button_negative => 'İmtina';

  @override
  String get dev_preferences_migration_title =>
      'V1-dən məlumatların köçürülməsi';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Status: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'uğur və ya yeni quraşdırma';

  @override
  String get dev_preferences_migration_status_success => 'uğur';

  @override
  String get dev_preferences_migration_status_error => 'səhv';

  @override
  String get dev_preferences_migration_status_in_progress => 'davam edir';

  @override
  String get dev_preferences_migration_status_required =>
      'tələb olunur (başlamaq üçün klikləyin)';

  @override
  String get dev_preferences_migration_status_not_started => 'naməlum';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Tarixçəni silib ora 3 məhsul yerləşdirəcək';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Xəbərlər üçün xüsusi URL';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'JSON faylının URL-i:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Təyin edilməyib';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Son yeniləmə: $date';
  }

  @override
  String get product_type_label_food => 'Yemək';

  @override
  String get product_type_label_beauty => 'Şəxsi qulluq';

  @override
  String get product_type_label_pet_food => 'Ev heyvanları üçün yem';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'Məhsul növü';

  @override
  String get product_type_selection_subtitle => 'Bu məhsulun növünü seçin';

  @override
  String get product_type_selection_empty =>
      'Əvvəlcə məhsul növünü seçməlisiniz!';

  @override
  String product_type_selection_already(String productType) {
    return 'Məhsul növünü dəyişə bilməzsiniz ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Məhsul səhifəsində Qiymətlər tətbiqinə qısa yol';

  @override
  String get prices_app_button => 'Qiymətlər tətbiqinə keçin';

  @override
  String get prices_website_button => 'Open Prices saytında açın';

  @override
  String get prices_bulk_proof_upload_select =>
      'Qiymət etiketlərini birbaşa qalereyadan əlavə edin';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Şəkilləri seçdikdən sonra onları redaktə edə bilməyəcəksiniz!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'İcmaya AI tərəfindən çıxarılan qiymətləri təsdiqləməyə icazə verin.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Birdən çox qiymət etiketi';

  @override
  String get prices_bulk_proof_upload_title => 'Toplu Sübut Yükləmə';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Faylların seçilməsi';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Yükləmə başlayır';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Faylın lokal surəti #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Yükləmə hazırlanır #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Şəkildə uğursuz oldu #$index/$count';
  }

  @override
  String get prices_generic_title => 'Qiymətlər';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count qiymətləri əlavə et',
      one: 'Qiymət əlavə et',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Göndər $count qiymətləri',
      one: 'Qiyməti göndər',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Bir element əlavə edin';

  @override
  String get prices_add_a_price => 'Qiymət əlavə edin';

  @override
  String get prices_add_a_receipt => 'Qəbz əlavə edin';

  @override
  String get prices_add_price_tags => 'Qiymət etiketləri əlavə edin';

  @override
  String prices_barcode_already(String barcode) {
    return 'Bu barkod ($barcode) artıq siyahıdadır!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'Hələ məhsul yoxdur';

  @override
  String prices_barcode_search_running(String barcode) {
    return '${barcode}axtarılır';
  }

  @override
  String get prices_barcode_enter => 'Barkodu daxil edin';

  @override
  String get prices_category_enter => 'Barkodsuz məhsul';

  @override
  String get prices_per_kilogram => 'Bir kiloqrama görə qiymət';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kq';

  @override
  String get prices_per_unit_short => ' / vahid';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'Könüllü';

  @override
  String get prices_category_error_mandatory => 'Kateqoriya məcburidir';

  @override
  String get prices_barcode_reader_action => 'Barkod oxuyucusu';

  @override
  String get prices_view_prices => 'Qiymətlərə baxın';

  @override
  String get prices_list_title => 'Qiymət siyahısı';

  @override
  String get prices_list_count => '\nqiymətlərin sayı';

  @override
  String get prices_list_add_new_price => '\nyeni qiymət əlavə edin';

  @override
  String get prices_list_empty_title => 'Hələ qiymət yoxdur!';

  @override
  String get prices_list_empty_subtitle =>
      'İlk əlavə edən siz olun:\n**qəbz** və ya **qiymət etiketini** skan etməklə!';

  @override
  String get prices_entry_shop_not_found => 'Naməlum mağaza';

  @override
  String prices_entry_menu_title(String user) {
    return 'Qiymət girişi \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Bu məhsulun bütün qiymətlərinə baxın';

  @override
  String get prices_entry_menu_open_proof => 'sübuta baxın';

  @override
  String get prices_entry_menu_my_prices => 'Digər qiymətlərimə baxın';

  @override
  String get prices_entry_menu_author_prices =>
      'Müəllifin digər qiymətlərinə baxın';

  @override
  String get prices_entry_menu_shop_prices =>
      'Digər qiymətlərə mağazadan baxın';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count qiymətlər',
      one: '1 qiymət',
    );
    return '$_temp0 üçün $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Bütün $count qiymətlər',
      one: 'Yalnız bir qiymət',
      zero: 'Hələ qiymət yoxdur',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Ən son $pageSize qiymətlər (cəmi: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Qiymət: $price / Mağaza: \"$location\" / $date tarixində \"$user\" tərəfindən dərc edilib';
  }

  @override
  String prices_open_user_proofs(String user) {
    return '\"$user\" ifadəsinin açıq sübutları';
  }

  @override
  String get prices_open_proof => 'Açıq qiymət sübutu';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Hamısı $count sübutlar',
      one: 'Yalnız bir sübut',
      zero: 'Hələlik sübut yoxdur',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Ən son $pageSize sübutlar (cəmi: $total)';
  }

  @override
  String get prices_users_empty_title => 'Hələ ianəçi yoxdur!';

  @override
  String get prices_users_empty_explanation =>
      'Qiyməti ilk əlavə edən siz olun!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Ən çox $pageSize töhfə verənlər (cəmi: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Hələ mağaza yoxdur!';

  @override
  String get prices_locations_empty_explanation =>
      'Qiyməti ilk əlavə edən siz olun!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Ən çox $pageSize yer (cəmi: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count sübutlar',
      one: 'Bir sübut',
      zero: 'Sübut yoxdur',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count məhsullar',
      one: 'Bir məhsul',
      zero: 'Məhsul yoxdur',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count istifadəçi',
      one: 'Bir istifadəçi',
      zero: 'İstifadəçi yoxdur',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count qiymətlər',
      one: 'Tək qiymət',
      zero: 'Qiymət yoxdur',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle =>
      'Qiymət əvvəlcədən əlavə edilib';

  @override
  String get prices_amount_subtitle => 'Məbləğ';

  @override
  String get prices_amount_is_discounted => 'Endirimlidirmi?';

  @override
  String get prices_amount_price_normal => 'Qiymət';

  @override
  String get prices_amount_price_discounted => 'Endirimli qiymət';

  @override
  String get prices_amount_price_not_discounted => 'İlkin qiymət';

  @override
  String get prices_amount_no_product => 'Bir məhsul çatışmır!';

  @override
  String get prices_amount_price_incorrect => 'Yanlış dəyər';

  @override
  String get prices_amount_price_mandatory => 'Məcburi dəyər';

  @override
  String get prices_currency_subtitle => 'Valyuta';

  @override
  String get prices_date_subtitle => 'Tarix';

  @override
  String get prices_location_subtitle => 'Mağaza';

  @override
  String get prices_location_find => 'Mağaza tapın';

  @override
  String get prices_location_mandatory => 'Mağaza seçməlisiniz!';

  @override
  String get prices_location_search_broader =>
      'Axtardığınızı tapa bilmədiniz? Daha geniş axtarışa cəhd edək!';

  @override
  String get prices_proof_subtitle => 'Sübut';

  @override
  String get prices_proof_empty_title => 'Hələ sübut yoxdur!';

  @override
  String get prices_proof_empty_explanation =>
      '**qəbz** və ya **qiymət etiketinin** şəklini əlavə etməklə başlayın!';

  @override
  String get prices_proof_find => 'Sübut seçin';

  @override
  String get prices_proof_change => 'Dəyişmə sübutu';

  @override
  String get prices_proof_receipt => 'Qəbz';

  @override
  String get prices_proof_price_tag => 'Qiymət etiketi';

  @override
  String get prices_proof_mandatory => 'Bir dəlil seçməlisiniz!';

  @override
  String get prices_add_validation_error => 'Doğrulama xətası';

  @override
  String get prices_privacy_warning_title => 'Məxfilik xəbərdarlığı';

  @override
  String get prices_unknown_product => 'Naməlum məhsul';

  @override
  String get prices_privacy_warning_main_message =>
      'Qiymətlər **istinad etdikləri mağaza ilə birlikdə açıqlanacaq**.\n\nBu, Açıq Qida Faktları təxəllüsünüz haqqında məlumatı olan insanlara aşağıdakıları etməyə imkan verə bilər:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Hansı ərazidə yaşadığınızı təxmin edin';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Nə aldığınızı bilin';

  @override
  String get prices_privacy_warning_sub_message =>
      'Əgər bundan narahatsınızsa, xahiş edirik təxəllüsünüzü dəyişdirin və ya yeni Open Food Facts hesabı yaradın və tətbiqə daxil olun.';

  @override
  String get i_refuse => 'Mən imtina edirəm';

  @override
  String get i_accept => 'Qəbul edirəm';

  @override
  String get prices_currency_change_proposal_title => 'Valyutanı dəyişmək?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Hazırkı valyutanız **$currency**-dir. Onu **$newCurrency** olaraq dəyişdirmək istərdinizmi?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Bəli, ${newCurrency}istifadə edin';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Xeyr, ${currency}saxlayın';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Hazırdır';

  @override
  String get dev_mode_section_server => 'Server konfiqurasiyası';

  @override
  String get dev_mode_section_news => 'Xəbər provayderinin konfiqurasiyası';

  @override
  String get dev_mode_section_product_page => 'Məhsul səhifəsi';

  @override
  String get dev_mode_section_ui => 'İstifadəçi İnterfeysi';

  @override
  String get dev_mode_section_experimental_features =>
      'Eksperimental xüsusiyyətlər';

  @override
  String get dev_mode_hide_environmental_score_title => 'Yaşıl Hesabı Çıxarın';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'OCR ekranları üçün orfoqrafiya yoxlayıcısından istifadə edin';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Tərkib hissələri və qablaşdırma)';

  @override
  String get dev_mode_reset_app_language_title => 'Proqram dilini sıfırlayın';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Kartlar əlavə edin';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'prices.openfoodfacts.org (PROD) və test env arasında keçid';

  @override
  String get search_history_item_edit_tooltip =>
      'Bu axtarışı yenidən istifadə edin və redaktə edin';

  @override
  String get search_history_item_remove_tooltip => 'Sil';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Bütün $totalSize məhsullarını yükləmisiniz.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return '$count daha çox məhsul\nyükləyin. Artıq ${totalSize}məhsulundan $downloaded yüklənib.';
  }

  @override
  String product_search_loading_message(Object search) {
    return '$search üçün axtarışınız davam edir.\n\nZəhmət olmasa, bir neçə saniyə gözləyin…';
  }

  @override
  String get user_search_contributor_title => 'Əlavə etdiyim məhsullar';

  @override
  String get user_search_informer_title => 'Redaktə etdiyim məhsullar';

  @override
  String get user_search_photographer_title => 'Şəkil çəkdiyim məhsullar';

  @override
  String get user_search_to_be_completed_title => 'Tamamlanacaq məhsullarım';

  @override
  String get user_search_prices_title => 'Qiymətlərim';

  @override
  String get user_search_proofs_title => 'Mənim sübutlarım';

  @override
  String get user_search_proof_title => 'Mənim sübutum';

  @override
  String search_proof_title(String user) {
    return '\"$user\"-dən sübut';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Əmanətçi qiymətləri: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Ən son qiymətlər əlavə edildi';

  @override
  String get all_search_prices_top_user_title => 'Ən çox qiymət töhfə verənlər';

  @override
  String get all_search_prices_top_location_title =>
      'Ən çox qiymətə malik mağazalar';

  @override
  String get prices_contribution_assistant => 'Qiymət Töhfəsi Köməkçisi';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system =>
      'Birdən çox sübut əlavə edin';

  @override
  String get all_search_prices_top_location_single_title =>
      'Mağazada qiymətlər';

  @override
  String get all_search_prices_top_product_title =>
      'Ən çox qiymətə malik məhsullar';

  @override
  String get all_search_to_be_completed_title => 'Bütün tamamlanacaq məhsullar';

  @override
  String get categorize_products_country_title =>
      'Ölkənizdəki məhsulları kateqoriyalara ayırmağa kömək edin';

  @override
  String get edit_product_action_retake_picture => 'Şəkili yenidən çəkin';

  @override
  String get edit_product_action_take_picture => 'Şəkil çəkin';

  @override
  String get edit_product_action_confirm => 'Təsdiqləyin';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Açıq Qida Faktları ilə razıyam ';

  @override
  String get signup_page_terms_of_use_line2 => 'istifadə şərtləri və töhfə';

  @override
  String get analytics_consent_image_semantic_label => 'Analitika ikonası';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Ölümcül Xəta: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Ölümcül Xəta: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Əsas detalları tamamlayın';

  @override
  String get edit_photo_button_label => 'Düzəliş etmək';

  @override
  String get edit_photo_unselect_button_label => 'Fotonun seçimini silin';

  @override
  String get edit_photo_select_existing_button_label =>
      'Mövcud bir şəkil seçin';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Üzərinə klikləyərək bir şəkil seçin';

  @override
  String get edit_photo_select_existing_download_label =>
      'Mövcud şəkillər əldə edilir…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Bu məhsulla bağlı əvvəllər yüklənmiş heç bir şəkil yoxdur.';

  @override
  String get edit_photo_language_not_this_one =>
      'Hələ ki, həmin dildə şəkil yoxdur';

  @override
  String get edit_photo_language_none => 'Hələ şəkil yoxdur';

  @override
  String get category_picker_screen_title => 'Kateqoriyalar';

  @override
  String get basic_details => 'Əsas Təfərrüatlar';

  @override
  String get product_name => 'Məhsulun adı';

  @override
  String get product_names => 'Məhsul Adları';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Yeni tərcümə əlavə edin';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Təsdiqləmədən əvvəl, xahiş edirik, yalnız tərcüməni **qablaşdırmada dil varsa** əlavə etdiyinizə əmin olun.';

  @override
  String get add_basic_details_product_name_open_photo => 'Ön fotoya baxın';

  @override
  String get add_basic_details_product_name_take_photo => 'Ön şəkil çəkin';

  @override
  String get add_basic_details_product_name_hint =>
      'Məhsulun adını daxil edin (məsələn: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Defolt dil dəyişdirilsin?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Məhsulun defolt dilinin \'$language\' olaraq təyin edilməsini istəyirsiniz?';
  }

  @override
  String get explanation_section_good_examples => 'Yaxşı nümunələr';

  @override
  String get explanation_section_bad_examples => 'Pis nümunələr';

  @override
  String get add_basic_details_product_name_help_title =>
      'Yaxşı təcrübələr: Məhsulun adı';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Məhsulun adı qablaşdırmada çap olunmuş **əsas addır**. Qeydiyyatdan keçmiş ticarət nişanı ola bilər.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Qeyd:** Əgər dil qablaşdırmada yoxdursa**, xahiş edirəm tərcümə əlavə etməyin.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Pomidor Ketçupu';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Adda brendi qeyd etməyin';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Heinz tərəfindən hazırlanan pomidor ketçupu**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      '®, ™, © və ya oxşar simvollardan istifadə etməyin';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count digər tərcümələr',
      one: '$count digər tərcümə',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Brend adı';

  @override
  String get brand_names => 'Brend adları';

  @override
  String get add_basic_details_brand_name_error =>
      'Zəhmət olmasa, brend adını daxil edin';

  @override
  String get add_basic_details_brand_names_hint =>
      'Giriş brendləri (məsələn: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Yaxşı təcrübələr: Brendlər';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Məhsulun bütün markalarını** daxil edin.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Əsas brend';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'Ön qablaşdırmada adətən aydın şəkildə göstərilən **əsas marka** əvvəlcə **daxil edilməlidir**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Digər brendlər';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Böyük bir şirkət tərəfindən**satıldıqda:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** Danone** tərəfindən satılır';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Brendi ilə birlikdə satıldıqda **birdən çox dilə tərcümə olunur**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Təbiət Vadisi** bəzən **Val Təbiət** kimi yazılır';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Miqdar və çəki';

  @override
  String get add_basic_details_quantity_hint =>
      'Çəkini və lazım olduqda miqdarı daxil edin (məsələn: 4x100 q)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Yaxşı təcrübələr: Miqdar';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Məhsulun üzərində göstərilən dəyəri kopyalayın və **vahidləri** unutmayın.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 q** və ya **230 q**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (6 yumurta üçün)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 q**\n(hər biri 150 q olan 3 qutulu məhsul üçün)';

  @override
  String get barcode => 'Barkod';

  @override
  String barcode_barcode(String barcode) {
    return 'Barkod: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Yanlış barkod';

  @override
  String get basic_details_add_success => 'Əsas detallar uğurla əlavə edildi';

  @override
  String get basic_details_add_error =>
      'Əsas detalları əlavə etmək mümkün deyil. Bir müddət sonra yenidən cəhd edin';

  @override
  String get clear_search => 'Axtarışınızı təmizləyin';

  @override
  String get confirm_clear =>
      'Bütün tarixçənizi silmək üzrəsiniz: davam etmək istədiyinizə əminsinizmi?';

  @override
  String get alert_clear_selected_user_list =>
      'Tarixçənizdəki seçilmiş elementləri silmək üzrəsiniz';

  @override
  String get confirm_clear_selected_user_list =>
      'Davam etmək istədiyinizə əminsiniz?';

  @override
  String get alert_select_items_to_clear =>
      'Təmizləmək üçün bir və ya daha çox element seçin';

  @override
  String confirm_clear_user_list(String name) {
    return 'Bu siyahını silmək üzrəsiniz ($name): davam etmək istədiyinizə əminsinizmi?';
  }

  @override
  String get confirm_delete_user_list_title => 'Siyahı silinsin?';

  @override
  String confirm_delete_user_list_message(String name) {
    return '\"$name\" siyahısını silmək üzrəsiniz.\nDavam etmək istədiyinizə əminsinizmi?';
  }

  @override
  String get confirm_delete_user_list_button => 'Bəli, təsdiq edirəm';

  @override
  String importance_label(String name, String id) {
    return '$name əhəmiyyəti: $id';
  }

  @override
  String get user_list_all_title => 'Siyahılar';

  @override
  String get user_list_all_empty => 'İlk siyahınızı yaradın';

  @override
  String get product_list_select => 'Siyahı seçin';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count məhsullar',
      one: 'Bir məhsul',
      zero: 'Boş siyahı',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Siyahı əlavə edin';

  @override
  String get open_food_preferences_tooltip =>
      'Yemək seçimlərinizi redaktə edin';

  @override
  String get add_photo_button_label => 'Şəkil əlavə edin';

  @override
  String get add_packaging_photo_button_label =>
      'Qablaşdırma/təkrar emal məlumatlarının şəkillərini çəkin';

  @override
  String get add_origin_photo_button_label =>
      'İstənilən mənşə məlumatının şəkillərini çəkin';

  @override
  String get add_emb_photo_button_label =>
      'İzlənilə bilən kod məlumatlarının şəkillərini çəkin';

  @override
  String get add_label_photo_button_label =>
      'İstənilən etiket və sertifikat məlumatlarının şəkillərini çəkin';

  @override
  String get choose_image_source_title => 'Şəkil mənbəyini seçin';

  @override
  String get choose_image_source_body => 'Zəhmət olmasa, şəkil mənbəyi seçin';

  @override
  String get gallery_source_label => 'Qalereya';

  @override
  String get gallery_source_access_denied_dialog_title => 'Giriş rədd edildi';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Təəssüf ki, tətbiq qalereyanıza daxil ola bilmir, çünki əvvəllər icazəni rədd etmişdiniz.\n\nZəhmət olmasa, telefonunuzun Parametrlər -> Şəkillər bölməsindəki tətbiq parametrlərinə keçin.';

  @override
  String get gallery_source_access_denied_dialog_button => 'Parametrləri açın';

  @override
  String get share => 'Paylaş';

  @override
  String share_product_text(String url) {
    return 'Bu məhsula Open Food Facts saytında nəzər yetirin: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Bu məhsula Open Beauty Facts saytında nəzər yetirin: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Bu məhsula Open PetFood Facts saytında nəzər yetirin: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Bu məhsula Açıq Məhsullar Faktlarında nəzər yetirin: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Açıq Qida Faktları bölməsindəki məhsul siyahıma nəzər yetirin: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Take a picture';

  @override
  String get choose_from_gallery => 'Qalereyadan seçin';

  @override
  String get image_upload_queued =>
      'Şəkil ən qısa zamanda arxa plana yüklənəcək.';

  @override
  String get add_price_queued => 'Qiymət ən qısa zamanda serverə göndəriləcək.';

  @override
  String get background_task_title_full_refresh =>
      'Yerli olaraq saxlanılan bütün məhsulların yenilənməsinə başlanılır';

  @override
  String get background_task_title_folksonomy =>
      'Yerli olaraq saxlanılan folksonomiya yeniləmələri üçün server hərəkətlərini yerinə yetirməyə başlayır';

  @override
  String get background_task_title_top_n =>
      'Ən populyar məhsulların yüklənməsinə başlayırıq';

  @override
  String get expand_nutrition_facts =>
      'Qidalanma məlumatları cədvəlini genişləndirin';

  @override
  String get expand_nutrition_facts_body =>
      'Qidalanma məlumatları cədvəlini genişləndirin';

  @override
  String get expand_ingredients => 'Tərkib hissələrini genişləndirin';

  @override
  String get expand_ingredients_body =>
      'Tərkib hissələri panelini genişləndirilmiş saxlayın';

  @override
  String get no_internet_connection => 'İnternet bağlantısı yoxdur';

  @override
  String get world_results_label => 'Bütün dünya';

  @override
  String get world_results_action => 'Axtarışınızı dünyaya genişləndirin';

  @override
  String get copy_to_clipboard => 'Kopyalayın';

  @override
  String get paste_from_clipboard => 'Panoyadan yapışdırın';

  @override
  String get no_data_available_in_clipboard =>
      'Panoyanızda heç bir məlumat mövcud deyil';

  @override
  String get clipboard_barcode_copy => 'Barkodları panoya kopyalayın';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Barkod $barcode panoya kopyalandı!';
  }

  @override
  String get open_product_website => 'Bu məhsulu veb saytında açın';

  @override
  String get language_picker_label => 'Diliniz';

  @override
  String get country_picker_label => 'Ölkəniz';

  @override
  String get currency_picker_label => 'Valyutanız';

  @override
  String get help_with_openfoodfacts => 'OpenFoodFacts ilə bağlı kömək';

  @override
  String get product_task_background_schedule =>
      'Məhsul ən qısa zamanda arxa planda yenilənəcək.';

  @override
  String get no_email_client_available_dialog_title =>
      'E-poçt tətbiqləri yoxdur!';

  @override
  String get no_email_client_available_dialog_content =>
      'Zəhmət olmasa, mobile@openfoodfacts.org ünvanına əl ilə e-poçt göndərin';

  @override
  String get all_images => 'Bütün Şəkillər';

  @override
  String get selected_images => 'Seçilmiş Şəkillər';

  @override
  String get product_card_remove_product_tooltip => 'Məhsulu silin';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Yeni barkod skan edildi: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Karuseldən bütün məhsulları silin';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Müqayisə etmək üçün ən azı iki məhsulu skan edin';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Skan etdiyiniz məhsulları müqayisə etmək üçün klikləyin';

  @override
  String get scan_product_loading => '\nbarkodu skan etdiniz:';

  @override
  String get scan_product_loading_initial =>
      'Biz bu məhsulu axtarırıq!\nZəhmət olmasa, bir neçə saniyə gözləyin…';

  @override
  String get scan_product_loading_long_request =>
      'Biz hələ də bu məhsulu axtarırıq!\nSizcə, yükləmə çox vaxt aparır? Biz də…';

  @override
  String get scan_product_loading_unresponsive =>
      'Hələ də bu məhsulu axtarırıq.\nAxtarışı yenidən başlatmaq istərdinizmi?';

  @override
  String get scan_product_loading_restart_button => 'Axtarışı yenidən başladın';

  @override
  String get portion_calculator_description =>
      'Müəyyən bir miqdar üçün qidalanma faktlarını hesablayın';

  @override
  String get portion_calculator_hint => 'Miqdar';

  @override
  String get portion_calculator_accessibility =>
      'Qidalanma faktlarını hesablamaq üçün miqdar daxil edin';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Zəhmət olmasa, $min və $max g arasında bir miqdar daxil edin';
  }

  @override
  String get portion_calculator_computation_error =>
      'Məlumat çatışmır. Hesablama aparıla bilmədi.';

  @override
  String portion_calculator_result_title(int grams) {
    return '$grams q (və ya ml) üçün qidalanma məlumatları';
  }

  @override
  String get offline_data => 'Oflayn Məlumatlar';

  @override
  String get ocr_image_upload_instruction =>
      'Tərkibindəki məlumatları avtomatik olaraq çıxarmaq üçün bir şəkil yükləyin.';

  @override
  String get upload_image => 'Şəkil yükləyin';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Şəkil yüklənə bilmədi';

  @override
  String get image_edit_url_error =>
      'Şəklin URL-i təyin edilmədiyi üçün şəkli redaktə etmək alınmadı.';

  @override
  String get user_picture_source_remember => 'Seçimimi xatırla';

  @override
  String get user_picture_source_ask => 'Hər dəfə soruşun';

  @override
  String get robotoff_continue => 'Davam et';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count suallar',
      one: 'sual',
    );
    return 'Növbəti $_temp0';
  }

  @override
  String get show_password => 'Şifrəni Göstər';

  @override
  String get owner_field_info_title => 'İstehsalçı dəyərlər təqdim etdi';

  @override
  String get owner_field_info_message =>
      'Həmin loqo ilə prodüser tərəfindən təqdim edilən məlumatları vurğulayırıq və bu məlumatları redaktə etmək mümkün olmaya bilər.';

  @override
  String get owner_field_info_close_button => 'Bu məlumatı bağlayın';

  @override
  String get owner_field_image =>
      'Bu şəkil prodüser tərəfindən təqdim olunub. Redaktə edilə bilməyə bilər.';

  @override
  String get edit_packagings_title => 'Qablaşdırma komponentləri';

  @override
  String get edit_packagings_element_add => 'Qablaşdırma komponenti əlavə edin';

  @override
  String get edit_packagings_completed => 'Qablaşdırma tamamlandı';

  @override
  String edit_packagings_element_title(int index) {
    return 'Qablaşdırma komponenti #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Vahidlərin sayı';

  @override
  String get edit_packagings_element_hint_units =>
      'Məhsulda olan eyni forma və materialdan olan qablaşdırma vahidlərinin sayını daxil edin.';

  @override
  String get edit_packagings_element_field_shape => 'Forma';

  @override
  String get edit_packagings_element_hint_shape =>
      'Təkrar emal təlimatlarında sadalanan forma adını varsa, daxil edin və ya forma seçin.';

  @override
  String get edit_packagings_element_example_shape => 'Şüşə';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Əgər müəyyən edilə bilirsə, konkret materialı (üçbucağın içərisindəki material koduna tez-tez qablaşdırma hissələrində rast gəlmək olar), yaxud əmin deyilsinizsə, ümumi materialı (məsələn, plastik və ya metal) daxil edin.';

  @override
  String get edit_packagings_element_example_material => 'Şüşə';

  @override
  String get edit_packagings_element_field_recycling => 'Təkrar emal təlimatı';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Təkrar emal təlimatlarını yalnız məhsulun üzərində sadalandığı təqdirdə daxil edin.';

  @override
  String get edit_packagings_element_example_recycling => 'Təkrar emal';

  @override
  String get edit_packagings_element_field_quantity =>
      'Vahid başına xalis məhsul miqdarı';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Xalis çəkini və ya xalis həcmi daxil edin və vahidi göstərin (məsələn, q və ya ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Bir boş vahidin çəkisi (q)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Qalan qida qalıqlarını çıxarın və ölçməzdən əvvəl qablaşdırma hissəsini yuyub qurulayın. Mümkünsə, 0,1 q və ya 0,01 q dəqiqliyə malik tərəzidən istifadə edin.';

  @override
  String get background_task_title => 'Gözlənilən töhfələr';

  @override
  String get background_task_subtitle =>
      'Töhfələriniz avtomatik olaraq serverimizdə saxlanılır, lakin həmişə real vaxt rejimində deyil.';

  @override
  String get background_task_list_empty =>
      'Gözlənilən Arxa Plan Tapşırıqları Yoxdur';

  @override
  String get background_task_error_server_time_out => 'Server fasiləsi';

  @override
  String get background_task_error_no_internet =>
      'İnternet bağlantısı xətası. Daha sonra cəhd edin.';

  @override
  String get background_task_operation_unknown => 'naməlum əməliyyat növü';

  @override
  String get background_task_operation_details => 'ətraflı dəyişikliklər';

  @override
  String get background_task_operation_image => 'şəkil yükləmə';

  @override
  String get background_task_operation_refresh =>
      'şəkil yükləndikdən sonra yeniləmə gecikdi';

  @override
  String get background_task_run_started => 'başladı';

  @override
  String get background_task_run_not_started => 'hələ başlamayıb';

  @override
  String get background_task_run_to_be_deleted => 'silinəcək';

  @override
  String get background_task_question_stop =>
      'Bu işi ən qısa müddətdə dayandırmaq istəyirsən?';

  @override
  String get feed_back => 'Rəy';

  @override
  String get undo => 'Geri al';

  @override
  String get copy_email_to_clip_board => 'E-poçtu panoya kopyalayın';

  @override
  String get please_send_us_an_email_to =>
      'Zəhmət olmasa, bizə əl ilə bir e-poçt göndərin';

  @override
  String get email_copied_to_clip_board => 'E-poçt panoya kopyalandı!';

  @override
  String get select_accent_color => 'Vurğu Rəngini Seçin';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Mavi';

  @override
  String get color_cyan => 'Firuzəyi';

  @override
  String get color_green => 'Yaşıl';

  @override
  String get color_light_brown => 'Defolt';

  @override
  String get color_magenta => 'Bənövşəyi';

  @override
  String get color_orange => 'Narıncı';

  @override
  String get color_pink => 'Çəhrayı';

  @override
  String get color_red => 'Qırmızı';

  @override
  String get color_rust => 'Pas';

  @override
  String get color_teal => 'Firuzəyi';

  @override
  String get text_contrast_mode => 'Mətn Kontrastı';

  @override
  String get contrast_high => 'Yüksək';

  @override
  String get contrast_medium => 'Orta';

  @override
  String get contrast_low => 'Aşağı';

  @override
  String get product_refresher_internet_not_found => 'Məhsul tapılmadı!';

  @override
  String get product_refresher_internet_not_connected =>
      'İnternetə qoşulmamısınız!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server işləmir ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Server xətası ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Məhsul tapılmadı!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Aşağıdakı barkodlu məhsul verilənlər bazamızda yoxdur: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'İnternet bağlantısı yoxdur!';

  @override
  String get product_loader_network_error_message =>
      'Zəhmət olmasa, smartfonunuzun WiFi şəbəkəsinə qoşulduğunu və ya mobil məlumatların aktivləşdirildiyini yoxlayın';

  @override
  String get page_not_found_title => 'Səhifə tapılmadı!';

  @override
  String get page_not_found_button => 'Ana səhifəyə qayıdın';

  @override
  String get download_data => 'Məlumatları yükləyin';

  @override
  String get download_top_products =>
      'Ani skan etmək üçün ölkənizdəki ən yaxşı 1000 məhsulu yükləyin';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count məhsullarını',
    );
    return 'Ani skan etmək üçün ölkənizdəki ən yaxşı $_temp0 yükləyin';
  }

  @override
  String get download_in_progress =>
      'Məlumatlar yüklənir\nBu bir az vaxt apara bilər';

  @override
  String downloaded_products(int num) {
    return '$num məhsullar əlavə edildi';
  }

  @override
  String get update_offline_data => 'Oflayn məhsul məlumatlarını yeniləyin';

  @override
  String get update_local_database_sub =>
      'Yerli məhsul məlumat bazasını Open Food Facts-dan ən son məlumatlarla yeniləyin';

  @override
  String get clear_local_database => 'Oflayn məhsul məlumatlarını silin';

  @override
  String get clear_local_database_sub =>
      'Yer boşaltmaq üçün tətbiqinizdən bütün yerli məhsul məlumatlarını silin';

  @override
  String deleted_products(int num) {
    return '$num məhsullar silindi';
  }

  @override
  String get loading => 'Yüklənir…';

  @override
  String get know_more => 'Daha çox məlumat əldə edin';

  @override
  String get offline_data_desc =>
      'Oflayn məlumatlar haqqında daha çox məlumat əldə etmək üçün klikləyin';

  @override
  String get offline_product_data_title => 'Oflayn məhsul məlumatları';

  @override
  String available_for_download(int num) {
    return '$num məhsullar dərhal skan edilə bilər';
  }

  @override
  String get country_selector_title => 'Ölkənizi seçin:';

  @override
  String get currency_selector_title => 'Valyutanızı seçin:';

  @override
  String get language_selector_title => 'Dilinizi seçin:';

  @override
  String get language_selector_section_selected => 'Seçilmiş dillər';

  @override
  String get language_selector_section_frequently_used =>
      'Tez-tez istifadə olunur';

  @override
  String get action_delete_list => 'Sil';

  @override
  String get action_change_list => 'Mövcud siyahını dəyişdirin';

  @override
  String get product_list_create => 'Yarat';

  @override
  String get product_list_create_tooltip => 'Yeni siyahı yaradın';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Yeni hesablama)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Yeni hesablama)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unknown Nutri-Score (New calculation)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score tətbiq olunmur';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score tətbiq olunmur (Yeni hesablama)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Yaşıl xal A';

  @override
  String get environmental_score_b_new => 'Yaşıl xal B';

  @override
  String get environmental_score_c_new => 'Yaşıl xal C';

  @override
  String get environmental_score_d_new => 'Yaşıl xal D';

  @override
  String get environmental_score_e_new => 'Yaşıl xal E';

  @override
  String get environmental_score_unknown_new => 'Naməlum Yaşıl Hesab';

  @override
  String get environmental_score_not_applicable_new =>
      'Yaşıl-Xal tətbiq edilmir';

  @override
  String get nova_group_generic_new => 'Ultra işlənmiş qidalar - NOVA qrupları';

  @override
  String get nova_group_1 => 'NOVA Qrup 1';

  @override
  String get nova_group_2 => 'NOVA Qrupu 2';

  @override
  String get nova_group_3 => 'NOVA Qrupu 3';

  @override
  String get nova_group_4 => 'NOVA Qrupu 4';

  @override
  String get nova_group_unknown => 'Naməlum NOVA Qrupu';

  @override
  String get nutrition_facts => 'Qida Səviyyələri';

  @override
  String get faq_title_partners => 'QHT-nin Tərəfdaşları və Himayədarları';

  @override
  String get faq_title_vision =>
      'Açıq Qida Faktları Vizyonu, Missiyası, Dəyərləri və Proqramları';

  @override
  String get faq_title_install_beauty =>
      'Kosmetik verilənlər bazası yaratmaq üçün Açıq Gözəllik Faktlarını quraşdırın';

  @override
  String get faq_title_install_pet =>
      'Ev heyvanları üçün qida bazası yaratmaq üçün Açıq Ev Heyvanları Yeməyi Faktlarını quraşdırın';

  @override
  String get faq_title_install_product =>
      'Obyektlərin ömrünü uzatmaq üçün məhsullar verilənlər bazası yaratmaq məqsədilə Açıq Məhsullar Faktlarını quraşdırın';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nutri-Score-un yeni hesablanması: yeniliklər nələrdir?';

  @override
  String get contact_title_pro_page =>
      'Pro? Məhsullarınızı Açıq Qida Faktları bölməsindən idxal edin';

  @override
  String get contact_title_pro_email => 'İstehsalçı ilə əlaqə';

  @override
  String get contact_title_press_page => 'Mətbuat Səhifəsi';

  @override
  String get contact_title_press_email => 'Mətbuatla Əlaqə';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'İcma təqvimimizə abunə olun';

  @override
  String get hunger_games_loading_line1 =>
      'Zəhmət olmasa, bizə bir neçə saniyə vaxt verin…';

  @override
  String get hunger_games_loading_line2 => 'Sualları yükləyirik!';

  @override
  String get hunger_games_error_label =>
      'Aaa! Nəsə səhv getdi… və sualları yükləyə bilmədik.';

  @override
  String get hunger_games_error_retry_button => 'Gəlin yenidən cəhd edək!';

  @override
  String get reorder_attribute_action => 'Atributları yenidən sıralayın';

  @override
  String get link_cant_be_opened =>
      'Bu link cihazınızda açıla bilməz. Zəhmət olmasa, brauzerinizin quraşdırıldığını yoxlayın.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return '$productNameüçün təfərrüatlar';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return '$pageName üçün ${productName}ilə təfərrüatlar';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Paylaş';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Yeni Nutri-Score hesablamasını haradan tapa bilərsiniz?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score 7 ölkədə tətbiq olunur: Fransa, Almaniya, Belçika, İspaniya, Lüksemburq, Hollandiya və İsveçrə.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'İstehsalçılara köhnə hesablamanı yenisi ilə əvəz etmək üçün fərmanın imzalanmasından sonra ən geci **2 il** vaxtı var.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'Yaşıl Hesab nədir?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score **qidanın ətraf mühitə təsiri** haqqında sizə məlumat vermək məqsədi daşıyan loqodur.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Rəng kodu **ən az təsirli** məhsullar üçün tünd yaşıldan (**A+**) **ən təsirli** məhsullar üçün tünd qırmızıya (**F**) qədər dəyişir.';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score loqoları';

  @override
  String get guide_greenscore_lca_title =>
      'Əsas: Həyat dövrünün qiymətləndirilməsi (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Qida kateqoriyalarının elmi qiymətləndirilməsi';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Hər bir məhsul kateqoriyası üçün Agribalyse ətraf mühit məlumat bazasından (ADEME və INRAE tərəfindən hazırlanmışdır) məlumatlardan istifadə etməklə **benchmark** balı müəyyən edilir.';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Həyat dövrünün təhlili** çoxmərhələli və çoxmeyarlı ətraf mühitin qiymətləndirilməsini həyata keçirmək üçün standartlaşdırılmış qiymətləndirmə metodudur.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Ölçülər:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 istehsal addımı';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Packaging';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 ətraf mühitə təsir göstəricisi';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'İqlim dəyişikliyi/karbon izi';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Ozon qatının deşilməsi';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'İonlaşdırıcı şüalanma';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Torpaq';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Su və enerji istifadəsi';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Havanın çirklənməsi';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Dəniz və şirin su (hissəciklər, turşulaşma, evtrofikasiya)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Resursların tükənməsi.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Bonuslar və cərimələr';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Bir kateqoriya daxilində daha yaxşı məhsulları mükafatlandırmaq üçün bir neçə meyara əsasən **bonuslar və cərimələr** tətbiq edirik:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Bonus** rəsmi etiketə, etiketə və ya ətraf mühitə fayda təmin edən sertifikata** malik məhsullara verilir (üzvi, ədalətli ticarət, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origin of ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Bonus** inqrediyentlərin mənşəyinə əsasən verilir. Bu bonus, nəqliyyata təsirini** və hər bir istehsalçı ölkəsinin **ətraf mühit siyasətini** nəzərə alır.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Biomüxtəlifliyə və ekosistemlərə** əhəmiyyətli dərəcədə **mənfi təsirlər** göstərən və kütləvi meşə qırılmasına səbəb olan palma yağı kimi tərkib hissələri olan məhsullara **cərimə** tətbiq olunur.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Packaging';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'Qablaşdırmanın **dairəviliyini** (təkrar emal olunmuş xammaldan istifadə və təkrar emal oluna bilmə qabiliyyəti) və həddindən artıq qablaşdırmanı nəzərə almaq üçün **cərimə** hesablanır.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Yaşıl Balın dəqiq hesablanması üçün, qablaşdırmada mütləq göstərilməyən məlumatlara** (məsələn, mənşəyi və hər bir tərkib hissəsinin dəqiq faizi) və ya nadir hallarda istifadəyə yararlı formada (məsələn, istifadə olunan plastik növləri ilə qablaşdırmanın bütün komponentlərinin siyahısı) sahib olmaq lazımdır.';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Bu məlumat hələ mövcud olmadıqda orta dəyərlərdən istifadə olunur**, lakin indi hər kəsi Yaşıl Hesab üçün, eləcə də bir çox digər məqsədlər üçün çox faydalı olacaq bu məlumatı toplamağımıza kömək etməyə çağırırıq.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Vətəndaşlar necə kömək edə bilərlər?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Bütün vətəndaşlar məhsullarda mövcud olan və ya onlardan çıxarıla bilən məlumatların, məsələn, **qablaşdırma** haqqında məlumatların toplanmasına və strukturlaşdırılmasına kömək edə bilərlər: \"Missiya Emballages\": bütün qida məhsulları üçün qablaşdırmanın genişmiqyaslı birgə inventarı (fransız dilində).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'İstehsalçılar necə kömək edə bilər';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'İstehsalçılar öz məlumatlarını birbaşa istehsalçılar üçün pulsuz platformamız vasitəsilə bizə göndərə bilərlər.';

  @override
  String get guide_greenscore_better_product_title =>
      'Hansı məhsul planet üçün daha yaxşıdır?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Bunu demək çətin ola bilər';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Davamlı qida seçimi iqlim üçün edə biləcəyimiz ən güclü şeylərdən biridir, çünki **qlobal qida sistemimiz bütün istixana qazları emissiyalarının dörddə birindən çoxuna cavabdehdir**.\n(Mənbə: Poore & Nemecek, Elm, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Gücün var!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Yaxşı xəbər budur ki, bu, bizə dəyişiklik yaratmaq üçün güclü bir yol verir.\n**Hər birimiz hər il təxminən 1000 yemək yeyirik**. Bu, **planet üçün daha yaxşı bir gələcək seçmək** üçün 1000 fürsətdir!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Məsuliyyətli olmağa və qərar verməyə kömək edir';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Davamlı qida seçimi kompleks hiss edə bilər. Etiketlər çaşdırıcıdır və məlumat tez-tez çatışmır. Green-Score bunu sadə etmək üçün yaradılmışdır, sizə ərzaq məhsulları üçün **aydın**, **elmə əsaslanan** və **şəffaf** ekoloji reytinq verir, sizə lazım olan yerdə: alış-veriş edərkən.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Şəffaflıq';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Mülkiyyət etiketlərindən fərqli olaraq, Yaşıl Xal hesablanması **tamamilə açıqdır** və **hər kəs tərəfindən təsdiqlənə bilər**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'Ultra emal nədir?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA qrupları sizə qida emalı səviyyəsi haqqında məlumat verir.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA təsnifatı qidaları **sənaye emal dərəcəsinə** (minimum işlənmiş və ya emal olunmamış qidalar, kulinariya inqrediyentləri, emal olunmuş qidalar, ultra emal olunmuş qidalar) əsasən **4 qrupa** təsnif etməyə imkan verir.';

  @override
  String get guide_nova_logos_caption => 'NOVA loqoları';

  @override
  String get guide_nova_groups_title => '4 NOVA qrupu';

  @override
  String get guide_nova_groups_intro =>
      '4 NOVA qrupu var, problemli qrup 4-cü qrup - Ultra emal olunmuş qidalardır.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimum işlənmiş və ya işlənməmiş qidalar';

  @override
  String get guide_nova_groups_arg1_text =>
      'Emal olunmamış (və ya təbii) qidalar təbiətdən ayrıldıqdan sonra bitkilərin** (toxumlar, meyvələr, yarpaqlar, gövdələr, köklər)**və ya heyvanların** (əzələlər, içalat, yumurta, süd), eləcə də göbələklərin, yosunların və suyun **yeməli hissələridir.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. Processes include various preservation or cooking methods, and in the case of breads and Cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions Of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with Little to no intact group 1 food. ingredients in these formulations Usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-Processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly Extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Ultra emal ilə bağlı problemlər';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Qida inqrediyentlərinin həddindən artıq emalı';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Bir çoxu **hidrogenləşdirilmiş və ya maraqlılaşdırılmış yağlar, hidroliz edilmiş zülallar, soya zülalı izolatı, maltodekstrin, invert şəkər və yüksək fruktoza qarğıdalı siropu kimi qida tərkib hissələrinin sonrakı emalından** əldə edilir.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Təmiz qida təhlükəsizliyindən kənara çıxan əlavələr';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Ultra emal olunmuş qidalardakı əlavələrə konservantlar, antioksidantlar və stabilizatorlar kimi emal olunmuş qidalarda da istifadə olunan bəzi əlavələr daxildir. Yalnız ultra emal olunmuş məhsullarda rast gəlinən əlavə siniflərinə **qidaların hissiyyat keyfiyyətlərini təqlid etmək və ya artırmaq və ya son məhsulun xoşagəlməz aspektlərini gizlətmək üçün istifadə edilənlər** daxildir. Bu əlavələrə boyalar və digər rənglər, rəng stabilizatorları; ətirlər, ləzzət artırıcılar, şəkərsiz tatlandırıcılar; və karbonatlaşdırıcı, bərkidici, qabarıqlıq və qabarıqlığa qarşı maddələr, köpüklənməni aradan qaldıran, yapışmaya və şirələnməyə qarşı maddələr, emulqatorlar, sekvestrantlar və nəmləndiricilər kimi emal vasitələri daxildir.';

  @override
  String get guide_nova_explanations_arg3_title => 'Evdə emal edə bilməzsiniz';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Adətən çoxlu sayda inqrediyenti birləşdirmək və son məhsulu (buna görə də \"ultra emal olunmuş\") yaratmaq üçün çoxsaylı proses ardıcıllığından istifadə olunur**. Proseslərə hidrogenləşmə və hidroliz, ekstruziya və qəlibləmə, eləcə də qızartma üçün əvvəlcədən emal kimi yerli ekvivalenti olmayan bir neçə **proses** daxildir.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Ultra emalın yırtıcı və maliyyə aspektləri';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Ultra emalın ümumi məqsədi, bütün digər qida qruplarını əvəz etmək üçün hazırlanmış markalı**, **rahat** (davamlı, istehlaka hazır), **cəlbedici** (hiper dadlı) və **yüksək gəlirli** (aşağı qiymətli inqrediyentlər) qida məhsulları yaratmaqdır. Ultra emal olunmuş qida məhsulları adətən cəlbedici şəkildə qablaşdırılır və intensiv şəkildə satılır.';

  @override
  String get guide_nova_explanations_arg5_title => 'Sağlamlıq üçün təhlükə';

  @override
  String get guide_nova_explanations_arg5_text =>
      '2018-ci ildən bəri NutriNet-Santé ilə **ultra emal olunmuş qidaların istehlakı ilə xərçəng, ürək-damar xəstəlikləri və diabet risklərinin artması arasındakı ilk əlaqələr vurğulanmışdır**. Bu gün dünyada 90-dan çox tədqiqat bu tapıntıları təsdiqləyir.\nƏn güclü əlaqələr **piylənmə, ürək-damar ölümü və depressiv simptomlar** ilə əlaqədardır. Uşaqlarda təsirlər əsasən çəki və lipid balanssızlığına müşahidə olunur.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Ölkələr onları məhdudlaşdırmağı tövsiyə edir';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Bəzi ölkələr pəhriz qaydaları və ya məqsədləri üçün NOVA qruplarından istifadə edirlər, məsələn:\n\n- **🇧🇷 Braziliyanın** pəhriz qaydaları **emal olunmuş qidaların istehlakını məhdudlaşdırmağı** və ultra emal olunmuş qidalardan çəkinməyi tövsiyə edir.\n\n- **🇫🇷 Fransanın** 2018-2022-ci illər üçün ictimai səhiyyə qidalanma siyasəti məqsədləri **4-cü qrup ultra emal olunmuş qidaların istehlakını 20% azaltmağı** hədəfləyir.';

  @override
  String get guide_nova_share_link => 'https://world-az.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Açıq Qida Faktlarına Xoş Gəlmisiniz!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Açıq Qida Faktları nədir?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts dünyanın hər yerindən qida məhsullarının **əməkdaşlıq**, **pulsuz** və **açıq** verilənlər bazasıdır.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Biz inanırıq ki, hər kəsin nə yediyi barədə məlumata çıxışı olmalıdır. Tərkib hissələri, allergenlər, qidalanma faktları və daha çox şey haqqında məlumat toplamaqla, **istehlakçıları məlumatlı seçimlər etməyə** və qida sənayesini **daha çox şəffaflığa** doğru irəlilətməyə təşviq edirik.';

  @override
  String get guide_open_food_facts_features_title =>
      'Açıq Qida Faktlarının Xüsusiyyətləri';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'İstənməyən maddələriniz üçün bildirişlər alın';

  @override
  String get guide_open_food_facts_tips_title =>
      'Əla şəkillər çəkmək üçün məsləhətlər';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Edilməməli şeylər';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Kölgələrdən və parıltılardan çəkinin.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Bulanıq və ya fokusdan kənar mətn yoxdur.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Mətnin bəzi hissələrini kəsməyin.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Məşğul fonlardan çəkinin.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Etməli olduğunuz şeylər';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Yaxşı, bərabər işıqlandırmadan istifadə edin.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Mətnin aydın və oxunaqlı olduğundan əmin olun.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Bütün inqrediyentlər siyahısını ələ keçirin.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Məhsulu düz bir səthdə saxlayın.';

  @override
  String get guide_open_food_facts_scores_title =>
      '\"Qida Vikipediyası\"nı yaratmağımıza kömək edin';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Qidalanma keyfiyyətinə dair bal';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Ultra emal olunmuş qidalardan qaçınmaq üçün bir bal';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Planet üçün bir xal';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-az.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Açıq Ev Heyvanları Yeməyi Faktlarına xoş gəlmisiniz!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Açıq Ev Heyvanları Yeməyi Faktları nədir?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Açıq Ev Heyvanları Yeməyi Faktları missiyamızı tüklü dostlarımıza da şamil edir! Bu, **pişiklər, itlər və digər yoldaşlar üçün ev heyvanları yemi məhsullarının məlumat bazasıdır**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Ev heyvanları sahiblərinə heyvanlarının ehtiyacları üçün ən yaxşı yeməyi seçməyə kömək etmək üçün **tərkib hissələri**, **qidalanma təhlili** və qidalanma qaydaları haqqında məlumat toplayırıq.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Açıq Ev Heyvanları Yeməyi Faktlarının Xüsusiyyətləri';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'İstənməyən maddələriniz üçün bildirişlər alın';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Ev heyvanınız hər hansı bir tərkib hissəsinə allergiyası varmı? Tətbiqdə qarşısını almaq üçün kosmetik maddələrin siyahısını təyin edə bilərsiniz!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Əla şəkillər çəkmək üçün məsləhətlər';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Edilməməli şeylər';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Kölgələrdən və parıltılardan çəkinin.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Bulanıq və ya fokusdan kənar mətn yoxdur.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Mətnin bəzi hissələrini kəsməyin.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Məşğul fonlardan çəkinin.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title =>
      'Etməli olduğunuz şeylər';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Yaxşı, bərabər işıqlandırmadan istifadə edin.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Mətnin aydın və oxunaqlı olduğundan əmin olun.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Bütün inqrediyentlər siyahısını ələ keçirin.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Məhsulu düz bir səthdə saxlayın.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Qol vurmaqla bağlı qeyd';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Ev heyvanları üçün yem üçün bal sistemi hazırlamaq **hazırda prioritet deyil**. Metodologiya mürəkkəb olardı, çünki qidalanma ehtiyacları növlərə, yaşa və sağlamlıq vəziyyətinə görə çox dəyişir. Hələ ki, belə bir bal hazırlaya bilən müstəqil elmi qrup tapmamışıq.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-az.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Açıq Gözəllik Faktlarına xoş gəlmisiniz!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Açıq Gözəllik Faktları nədir?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts, **kosmetik məhsulların** birgə verilənlər bazasıdır.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Məqsədimiz, **şəxsi qulluq vasitələrinizin tərkibində nə olduğunu anlamağınıza** kömək etmək üçün tərkib hissələrinin siyahısını deşifrə etməkdir. Nəmləndiricilərdən makiyaja qədər, kosmetika sənayesində şəffaflığı təşviq etmək üçün tərkib hissələri, allergenlər və qablaşdırma haqqında məlumat toplayırıq.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Açıq Gözəllik Faktlarının Xüsusiyyətləri';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'İstənməyən maddələriniz üçün bildirişlər alın';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Hər hansı tərkib hissəsinə qarşı allergiyanız varmı? Komedogen maddələrdən qaçınmaq istəyirsiniz? Mübahisəli komponentlərdən uzaq durmaq istəyirsiniz? Tətbiqdə qaçınmaq istədiyiniz kosmetik maddələrin siyahısını təyin edə bilərsiniz!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Əla şəkillər çəkmək üçün məsləhətlər';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Edilməməli şeylər';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Kölgələrdən və parıltılardan çəkinin.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Bulanıq və ya fokusdan kənar mətn yoxdur.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Mətnin bəzi hissələrini kəsməyin.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Məşğul fonlardan çəkinin.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title =>
      'Etməli olduğunuz şeylər';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Yaxşı, bərabər işıqlandırmadan istifadə edin.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Mətnin aydın və oxunaqlı olduğundan əmin olun.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Bütün inqrediyentlər siyahısını ələ keçirin.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Şüşə əyridirsə, lazım olan qədər şəkil çəkin.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Tərkib hissələrinin siyahısını görmək üçün etiketi soymaq lazım ola bilər.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Məhsulu düz bir səthdə saxlayın.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Qol vurmaqla bağlı qeyd';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Qida məhsullarından fərqli olaraq, kosmetika dünyasında **Nutri-Score** kimi universal olaraq qəbul edilmiş, hökumət tərəfindən dəstəklənən qiymətləndirmə sistemi yoxdur. Tərkib hissələrinin təsiri olduqca fərdi ola bilər və dəri tipindən, allergiyadan və fərdi narahatlıqlardan asılıdır.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-az.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Biz açıq mənbəli qiymətlər məlumat dəstini kütləvi mənbələrdən əldə edirik**. Qiymətlər istifadəçilər tərəfindən bu veb tətbiq və ya rəsmi Open Food Facts mobil tətbiqi vasitəsilə əlavə edilə bilər. Pərakəndə satıcılar və ya üçüncü tərəf tətbiqləri də API-mizdən istifadə edərək töhfə verə bilərlər.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Dəhlizlərdə qiymət etiketlərinin şəkillərini toplayın';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Qəbzlərin şəkillərini toplayın';

  @override
  String get guide_open_prices_why_title => 'Niyə Open Food Facts bunu edir?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Qiymət məlumatları qida sistemlərini anlamaq üçün çox vacibdir. Bu, qidanın qiymətini anlamaqda və daha sağlam pəhrizləri təşviq etməkdə əsas amildir. Açılış qiymət məlumatları tədqiqatçılar, jurnalistlər və vətəndaşlar üçün qida qiymətlərinin coğrafi və zaman baxımından necə dəyişdiyini daha yaxşı başa düşməyi asanlaşdıran bir yoldur.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Zamanla qiymətlərin təkamülünü izləyin';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Qiymətlərin **təkamülünə** baxın: kiçilmə, ucuzlaşma, onları birlikdə izləyə bilərik!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Yaxınlığınızdakı qiymətləri müqayisə edin';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Daha çox qiymət əldə etdikcə, ətrafınızdakı **ən ucuz mağazaları** görə bilərsiniz.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Pərakəndə satış saytlarından qiymətləri silməyi düşündünüzmü?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'API-mizdən istifadə edərək qiymətlər təklif edə bilərsiniz.\nƏgər miqyaslı qiymətlər təklif etmək istəyirsinizsə, zəhmət olmasa, prices@openfoodfacts.org ünvanı vasitəsilə bizimlə əlaqə saxlayın.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Açıq Məhsullar Faktlarına Xoş Gəlmisiniz!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Açıq Məhsullar Faktları Nədir?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Açıq Məhsullar Faktları, qida, kosmetika və ya ev heyvanları üçün yem olmayan, barkodlu istənilən məhsul üçün geniş, açıq verilənlər bazasıdır.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      '**Elektronikadan** **oyuncaqlara** və **paltardan** **təmizlik ləvazimatlarına** qədər, əgər barkod varsa, əlavə edilə bilər. Bu layihə gündəlik əşyalar üçün \"Əşyaların İnterneti\" yaratmağı və onlar haqqında məlumatları hamı üçün əlçatan etməyi hədəfləyir.';

  @override
  String get guide_open_products_facts_features_title =>
      'Açıq Məhsullar Faktlarının Xüsusiyyətləri';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts istehlakçılara obyektlərinin saxlanması, **təmiri**, **təkrar emalı** və ya onlara yeni sahib vermək üçün dairəvi həllər təqdim etməklə onların **ömrünü uzatmaq** imkanı yaratmağı hədəfləyir.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Bəzi məhsullar üçün karbon izləri';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      'Fransa Ətraf Mühit Təşkilatı ADEME tərəfindən **Təsir CO2** bir çox kateqoriyanın **karbon təsirini** təmin edir, məhsulları dəqiq təsnif etdiyinizə əmin olun.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Bir çox məhsul üçün təmir qabiliyyəti indeksi';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Fransa təmir qabiliyyəti indeksi mövcud olduqda, biz onu göstərəcəyik. Bundan əlavə, **Folksonomy Engine** istifadə edərək dəyişənləri toplamağa başlaya bilərsiniz; beləliklə, gələcəkdə, hətta mövcud olmadığı ölkələrdə belə, onu özümüz yenidən hesablaya bilərik.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Məhsulunuzu bağışlamaq/təkrar satmaq yollarını tapın';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Planet resurslarına daha ehtiyatla yanaşmaq üçün ikinci əl məhsul kimi axtardığınız məhsul növünü əldə etməyinizə kömək edən **üçüncü tərəf dairəvi xidmətlərinə** keçidlər təqdim edirik.\nQeyd edək ki, bunun üçün bizə pul ödənilmir və sistem yalnız Fransadakı iki veb sayt üçün nümunə kimi işləyir. Vikipediyada daha çox saytı sənədləşdirməklə bu sistemin genişləndirilməsinə kömək edə bilərsiniz.';

  @override
  String get guide_open_products_facts_information_title =>
      'Hansı məlumatlar faydalıdır?';

  @override
  String get guide_open_products_facts_information_text =>
      'Bu qədər geniş çeşiddə məhsullar üçün **topladığımız məlumatlar çevikdir**. Bunu etmək üçün **Folksonomy Engine** yaratdıq.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Folksonomiya Mühərriki';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine, müvafiq xüsusiyyətlərə malik məhsulları tamamlamağınıza kömək edən bir vasitədir. Bu, axtarış və aşkarlanmanı yaxşılaşdırmağa, eyni zamanda gələcəkdə maraqlı şeyləri hesablamağa və göstərməyə kömək edir.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Siz istənilən açar və dəyərləri əlavə edə bilərsiniz, məsələn: **5G_mobile_network_ilə_uyğunluq: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Mümkün xüsusiyyətlər barədə avtomatik təklif alacaqsınız və sevdiyiniz məhsul növlərinə yenilərini əlavə edib sənədləşdirə bilərsiniz.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-az.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Açıq yemək seçimləri';

  @override
  String get guide_coming_soon_button_title => 'Tezliklə';

  @override
  String get guide_learn_more_subtitle => 'Daha çox məlumat üçün toxunun';

  @override
  String get preview_badge => 'Önizləmə';

  @override
  String get prices_feedback_form =>
      'Bu yeni funksiya haqqında rəylərinizi bizə göndərmək üçün buraya klikləyin!';

  @override
  String get menu_button_list_actions => 'Bir hərəkət seçin';

  @override
  String get error_loading_photo => 'Foto yüklənmə xətası';

  @override
  String get photo_viewer_action_use_picture_as => '…kimi istifadə edin';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Bu şəkli…kimi istifadə edin';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Bu şəkli… ($language) kimi istifadə edin';
  }

  @override
  String get photo_viewer_details_button => 'Təfərrüatlar';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Bu fotonun təfərrüatları';

  @override
  String get photo_viewer_details_title => 'Fotonun təfərrüatları';

  @override
  String get photo_viewer_details_contributor_title => 'Töhfə verən';

  @override
  String get photo_viewer_details_size_title => 'Ölçü';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height piksel';
  }

  @override
  String get photo_viewer_details_date_title => 'Tarix';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Uyğundur';

  @override
  String get user_lists_action_multi_select => 'Çoxlu seçim';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Uyğunluq balınız: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Front picture';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Ingredients picture';

  @override
  String get product_image_nutrition_accessibility_label => 'Qidalanma şəkli';

  @override
  String get product_image_packaging_accessibility_label => 'Qablaşdırma şəkli';

  @override
  String get product_image_other_accessibility_label => 'Digər şəkil';

  @override
  String get product_image_outdated_message => 'Bu şəkil köhnəlmiş ola bilər';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (bu şəkil köhnəlmiş ola bilər)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (bu şəkil prodüser tərəfindən kilidlənmiş ola bilər)';
  }

  @override
  String get product_image_error => 'Şəkli yükləmək mümkün deyil!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type (şəbəkə xətası?) yüklənə bilmir';
  }

  @override
  String get product_page_image_no_image_available => '\nşəkli yoxdur!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Bu məhsul üçün şəkil yoxdur';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Hərəkətləri yenidən sıralayın və ya gizlədin';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Əməliyyatları redaktə edin';

  @override
  String get product_page_action_bar_item_move_up => 'Yuxarı hərəkət edin';

  @override
  String get product_page_action_bar_item_move_down => 'Aşağı hərəkət etdirin';

  @override
  String get product_page_action_bar_item_enable => 'Əməliyyatı aktivləşdirin';

  @override
  String get product_page_action_bar_item_disable => 'Əməliyyatı deaktiv edin';

  @override
  String get product_page_pending_operations_banner_title =>
      'Düzəlişləriniz yüklənir…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Bu səhifədə göstərilən məlumatlar **hələlik dəyişikliklərinizi əks etdirmir**.\nZəhmət olmasa, bir neçə saniyə gözləyin…';

  @override
  String get product_add_a_language => 'Dil əlavə edin';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Barkod $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Bu məhsulu karuseldən silin';

  @override
  String get carousel_unsupported_header => 'Dəstəklənməyən barkod!';

  @override
  String get carousel_unsupported_title => 'Ups!';

  @override
  String get carousel_unsupported_text =>
      'Skan edilmiş barkod Open Food Facts tərəfindən dəstəklənmir!';

  @override
  String get carousel_error_header => 'Xəta!';

  @override
  String get carousel_error_title => 'Bu, çox pisdir!';

  @override
  String get carousel_error_text_1 =>
      'Bu barkod haqqında məlumatı yükləyə bilmədik:';

  @override
  String get carousel_error_text_2 =>
      'İnternet bağlantınızı yoxlayın və ya bu düyməni vurun:';

  @override
  String get carousel_error_button => 'Yenidən sına';

  @override
  String get carousel_unknown_product_header => 'Naməlum məhsul';

  @override
  String get carousel_unknown_product_title =>
      'Təbriklər!\nNadir __gövhər tapdınız!__';

  @override
  String get carousel_unknown_product_text =>
      'Əməkdaşlıq etdiyimiz verilənlər bazamızda **3 milyondan çox məhsul** var, lakin bu barkod mövcud deyil: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'Məlumat yüklənir...';

  @override
  String get carousel_loading_title =>
      'Siz sadəcə aşağıdakı barkodla məhsulu skan etdiniz:';

  @override
  String get carousel_loading_text =>
      'Biz bunu **3 milyondan çox məhsuldan ibarət verilənlər bazamızda axtarırıq!**';

  @override
  String get product_type_subtitle_food =>
      'Tərəvəzlər, meyvələr, dondurulmuş qidalar…';

  @override
  String get product_type_subtitle_beauty =>
      'Makiyaj, sabunlar, diş məcunları…';

  @override
  String get product_type_subtitle_pet_food => 'İtlər və pişiklər üçün yem…';

  @override
  String get product_type_subtitle_product => 'Smartfonlar, mebel…';

  @override
  String get photo_field_front => 'Məhsul şəkli';

  @override
  String get photo_field_ingredients => 'Tərkibi fotosu';

  @override
  String get photo_field_nutrition => 'Qidalanma fotosu';

  @override
  String get photo_field_packaging => 'Təkrar emal təlimatlarının fotosu';

  @override
  String get photo_already_exists => 'Bu foto artıq mövcuddur';

  @override
  String get photo_missing => 'Bu foto yoxdur';

  @override
  String get date => 'Tarix';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'Əvvəlki əməliyyatı geri qaytarın';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '${location}dünya xəritəsi';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap töhfəçiləri';

  @override
  String get not_applicable_short => 'Yoxdur';

  @override
  String get knowledge_panel_warning_text => 'Xәbәrdarlıq';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Bu Nutri-Score qablaşdırmada göstəriləndən nə üçün fərqlidir?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'İki mümkün izahat var:\nTərkib hissələrinin siyahısı və/və ya qidalanma məlumatları yenilənməyib.\n\nNutri-Score (və ya V2)-nin \"Yeni hesablamasını\" təqdim edirik. Zəhmət olmasa, qablaşdırmada \"Yeni hesablama\" bannerinin olub olmadığını yoxlayın.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Tərkib hissələrini yoxlayın';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Qidalanma faktlarını yoxlayın';

  @override
  String url_not_supported(String url) {
    return 'Təəssüf ki, URL-i aça bilmirik:\n$url';
  }

  @override
  String get product_list_export => 'İxrac et';

  @override
  String get product_list_import => 'İdxal';

  @override
  String get product_footer_action_barcode => 'Barkod koduna baxın';

  @override
  String get product_footer_action_barcode_short => 'Barkod';

  @override
  String get product_footer_action_open_website => 'Veb saytı açın';

  @override
  String get product_footer_action_report => 'Hesabat';

  @override
  String get product_footer_action_contributor_guide => 'Kömək';

  @override
  String get product_footer_action_data_quality_tags => 'Məlumat keyfiyyəti';

  @override
  String get product_page_tab_for_me => 'mənim üçün';

  @override
  String get product_page_tab_website => 'Veb sayt';

  @override
  String get product_page_tab_prices => 'Qiymətlər';

  @override
  String get prices_explanation_card_title => 'Niyə qiymətlər?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** bütün dünya üzrə məhsulların qiymətlərini toplamaq və paylaşmaq layihəsidir 🌍. Açıq Qiymətlər Open Food Facts tərəfindən hazırlanır və saxlanılır.';

  @override
  String get explanation_card_learn_more_button => 'Daha çox məlumat əldə edin';

  @override
  String get product_page_tab_folksonomy => 'Folksonomiya';

  @override
  String get folksonomy_explanation_card_title =>
      'Folksonomiyanın atributları hansılardır?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atributlar **açar-dəyər** əsasındadır.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Bu xassələr hər cür istifadə üçün ianəçilər tərəfindən yaradılır və təqdim olunur.';

  @override
  String get folksonomy_action_external_link_title => 'Xarici linki açın';

  @override
  String get folksonomy_action_external_link_warning =>
      'Xarici keçidlər təhlükəli ola bilər. Həqiqətən də onu ziyarət etmək istəyirsiniz?';

  @override
  String get prices_products_empty_title => 'Qiymət yoxdur';

  @override
  String get prices_products_empty_explanation => 'İlk töhfə verən siz olun!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Ən çox $pageSize məhsul (cəmi: $total)';
  }

  @override
  String get app_review_title => 'Bu tətbiqdən zövq alırsınız?';

  @override
  String get app_review_low => 'Daha yaxşısını edə bilərdi';

  @override
  String get app_review_medium => 'Pis deyil';

  @override
  String get app_review_high => 'Mən bunu sevirəm!';

  @override
  String get app_review_feedback_modal_title =>
      'Tətbiqimizi təkmilləşdirməyə kömək edin';

  @override
  String get app_review_feedback_modal_content =>
      'Bir neçə dəqiqəniz varsa, **gələcək yeniləmələrdə təkmilləşdirə bilməyimiz** üçün bu formanı cavablandıra bilərsinizmi?';

  @override
  String get app_review_feedback_modal_open_form => 'Forma cavab verin';

  @override
  String get app_review_feedback_modal_later => 'Daha sonra soruşun';

  @override
  String get nutrition_facts_extract_new =>
      'YENİ: Şəkildəki qida maddələrini avtomatik olaraq çıxara bilərsiniz!';

  @override
  String get nutrition_facts_extract_button_text => 'İndi çıxarın';

  @override
  String get nutrition_facts_extract_in_progress => 'Çıxarma davam edir…';

  @override
  String get nutrition_facts_extract_successful => 'Çıxarma uğurludur';

  @override
  String get nutrition_facts_extract_failed =>
      'Şəkildən qida maddələrini çıxarmaq mümkün olmadı';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Statistika';

  @override
  String get prices_stats_title => 'Qiymətlər Statistikası';

  @override
  String get prices_stats_prices_section => 'Qiymətlər';

  @override
  String get prices_stats_products_section => 'Məhsullar';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Müxtəlif';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Yemək';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Məhsullar';

  @override
  String get prices_stats_pet_food => 'Ev heyvanları üçün yem';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Ölkələr';

  @override
  String get prices_stats_price_tag => 'Qiymət etiketi';

  @override
  String get prices_stats_receipt => 'Qəbz';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Veb sayt';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'Son yenilənmə tarixi';

  @override
  String get prices_stats_error => 'Statistika yüklənərkən xəta baş verdi.';

  @override
  String get product_edit_robotoff_question_answered => 'Suala cavab verildi!';

  @override
  String get product_edit_robotoff_proof => 'Sübut';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'Qiymətlər';

  @override
  String get preferences_prices_subtitle => 'Qiymət seçimlərinizi idarə edin';

  @override
  String get preferences_card_project => 'Open Food Facts layihəsi';

  @override
  String get preferences_contribute_title => 'Contribute';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'Mənim statistikam';

  @override
  String get preferences_contribute_subtitle =>
      'Tərcümə edin, alətlərimizi təkmilləşdirin…';

  @override
  String get preferences_connect_title => 'Qoşun';

  @override
  String get preferences_connect_subtitle =>
      'Əlaqə saxlayın və ya sosial mediada bizi izləyin';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Dünyadakı milyonlarla istehlakçıya məlumat verməkdə bizə kömək edin';

  @override
  String get preferences_card_help => 'Yardım və Dəstək';

  @override
  String get preferences_faq_title => 'Tez-tez verilən suallar';

  @override
  String get preferences_faq_subtitle => 'Suallarınıza cavab alın';

  @override
  String get logged_out => 'Çıxdı';

  @override
  String get preferences_app_bar_message =>
      'Üzvlərimizdən biri olduğunuz üçün təşəkkür edirik!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Bütün statistikaya baxın';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '$provider üçün \"$keyword\" axtarın';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Parametrləri axtarın (məsələn, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Əlçatanlıq: Emoji göstərin';

  @override
  String get preferences_accessibility_remove_colors =>
      'Əlçatanlıq: Rəngləri silin';

  @override
  String get preferences_app_settings_products => 'Məhsullar';

  @override
  String get preferences_card_about => 'Haqqında';

  @override
  String get preferences_legal_information_title => 'Hüquqi məlumat';

  @override
  String get preferences_legal_information_subtitle =>
      'İstifadə şərtləri, məxfilik siyasəti və s';

  @override
  String get preferences_terms_of_use => 'İstifadə şərtləri';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts **hər kəs tərəfindən, hamı üçün** hazırlanmış qida məhsulları məlumat bazasıdır.\nSiz ondan daha yaxşı qida seçimləri etmək üçün istifadə edə bilərsiniz və **açıq məlumat** olduğundan, hər kəs **istənilən məqsəd üçün** təkrar istifadə edə bilər.';

  @override
  String get preferences_privacy_policy => 'Məxfilik siyasəti';

  @override
  String get preferences_licenses => 'Lisenziyalar';

  @override
  String get preferences_about_app_title => 'Proqram haqqında';

  @override
  String get preferences_about_app_subtitle =>
      'Texniki məlumat, tərtibatçı məlumatı və s';

  @override
  String get preferences_card_information => 'Məlumat';

  @override
  String get preferences_version_number_title => 'Versiya nömrəsi';

  @override
  String get preferences_scanner_title => 'Skaner';

  @override
  String get preferences_app_store => 'Proqram mağazası';

  @override
  String get preferences_app_system_settings => 'Sistem parametrləri';

  @override
  String get preferences_source_code => 'Mənbə koduna daxil olun';

  @override
  String get preferences_source_code_subtitle =>
      'Və milyonlarla insana təsir etməyə başlayın';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Complete products';

  @override
  String get preferences_tips => 'Məsləhətlər';

  @override
  String get tips_discover_nutriscore => 'Yeni Nutri-Score-u kəşf edin';

  @override
  String get preferences_on_off_website_subtitle => 'Open Food Facts saytında';

  @override
  String get preferences_manage_account_title => 'Hesabımı idarə et';

  @override
  String get preferences_manage_account_tooltip => 'Hesabınızı idarə edin';

  @override
  String get preferences_change_password_title => 'Parolumu dəyişin';

  @override
  String get preferences_danger_zone => 'Təhlükəli zona';

  @override
  String get preferences_account_deletion_subtitle =>
      'Bütün töhfələriniz itiriləcək';

  @override
  String get preferences_contributions_title => 'Contributions';

  @override
  String get preferences_dev_mode_app_settings_title => 'Proqram parametrləri';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Məhsulları oflayn skan etməyin çox eksperimental yolu';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Serverdən bütün məhsulları yeniləyin';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Zəhmət olmasa, çox zərurət olmadıqca bunu etməkdən çəkinin';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demo rejimi';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Skanerə kartları əlavə edin';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Skanerə 3 nümunə məhsul əlavə edir';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Folksonomiya aparıcısı';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Aparıcı: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Əlçatanlıq təcrübələri';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Qiymətlər üçün çoxlu məhsul seçimi';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'İstifadəçinin sifariş etdiyi bilik panelləri';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Məkan axtarışına müvəqqəti giriş';

  @override
  String get preferences_dev_mode_comparison_title =>
      '2 və ya 3 məhsul üçün yan-yana müqayisə';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Məhsul siyahısı idxalı';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Ballar və metodologiyalar';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Nutri-Score-un necə hesablandığını kəşf edin';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Metodologiyada əsas dəyişiklikləri kəşf edin';

  @override
  String get preferences_faq_discover_project_title => 'Discover the project';

  @override
  String get preferences_faq_discover_off_title => 'Open Food Facts kəşf edin';

  @override
  String get preferences_faq_discover_obf_title =>
      'Açıq Gözəllik Faktlarını Kəşf Edin';

  @override
  String get preferences_faq_discover_opff_title =>
      'Açıq Ev Heyvanları Yeməyi Faktlarını Kəşf Edin';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Açıq Məhsullar Faktlarını Kəşf Edin';

  @override
  String get preferences_faq_faq_title => 'FAQ - Tez-tez verilən suallar';

  @override
  String get preferences_faq_off_ngo_title => 'Open Food Facts QHT';

  @override
  String get preferences_about_information_title => 'Məlumat';

  @override
  String get preferences_connect_community_updates_title =>
      'İcma yeniləmələrini əldə edin';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Proqram və icma xəbərləri ilə əlaqədə qalın';

  @override
  String get preferences_connect_community_calendar_title =>
      'İcma təqvimimizə abunə olun';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Virtual tədbirlərimizdən birində iştirak etməklə siz də iştirak edin';

  @override
  String get preferences_connect_blog_title => 'Open Food Facts bloqu';

  @override
  String get preferences_connect_blog_subtitle => 'Ən son xəbərləri əldə edin';

  @override
  String get preferences_connect_community_help_title =>
      'Cəmiyyətdən kömək alın';

  @override
  String get preferences_connect_improve_app_title =>
      'Proqramı təkmilləşdirməkdə bizə kömək edin';

  @override
  String get preferences_connect_debug_info_title =>
      'Sazlama məlumatını bizə göndərin';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Ətraflı sazlama məlumatı ilə bizə e-poçt göndərin';

  @override
  String get preferences_connect_feedback_title =>
      'Tətbiq haqqında bizə rəy göndərin';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Proqramın gələcəyini formalaşdırmağa kömək edin';

  @override
  String get preferences_connect_survey_title =>
      'Tətbiq sorğusunda iştirak edin';

  @override
  String get preferences_connect_survey_subtitle =>
      'Bundan sonra nə qurmalı olduğumuzu anlamağa kömək edin';

  @override
  String get preferences_connect_professionals_title => 'Peşəkarlar';

  @override
  String get preferences_connect_pro_subtitle =>
      'Tamamilə pulsuz, 500 proqram və milyonlarla istehlakçı üçün dəqiq məlumat təmin edir. PIM və ya cədvəllərinizə uyğun olan özünə xidmət (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Başlamaq üçün əlaqə saxlayın';

  @override
  String get preferences_connect_press_title => 'Press';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Hesabatınız üçün lazım olan bütün materialları əldə edin';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Mətbuat sorğuları üçün əlaqə saxlayın və ya hesabatınız haqqında bizə bildirin';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Aktiv könüllü olun';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'İnkişaf, Ünsiyyət, Dizayn… istənilən növ könüllülük və ya təcrübə alqışlanır!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Töhfə verə biləcəyiniz bir çox yoldan bəzilərini kəşf edin';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Mobil proqram inkişafı';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Proqram təminatının inkişafına necə töhfə verməyi öyrənin';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Gündəlik qeyri-sabit quruluşlar, yeni xüsusiyyətlər';

  @override
  String get preferences_contribute_local_community_title =>
      'Yerli icmanızı inkişaf etdirin';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Proqram təminatı, məzmun, inqrediyent təhlili tərcümələri ilə kömək edin';

  @override
  String get preferences_contribute_share_subtitle =>
      'Sizə kömək etmək üçün kiçik bir şablon hazırlamışıq :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Ölkənizdə qida şəffaflığını artırmaq üçün sadə addımlar';

  @override
  String get preferences_contribute_data_quality_title => 'Məlumat keyfiyyəti';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Məlumat keyfiyyəti komandasına qoşulun';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Verilənlər bazasının tam və dəqiq olmasını təmin etmək üçün səylərimizə qoşulun';

  @override
  String get preferences_contributions_products_added_title =>
      'Əlavə edilmiş məhsullar';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Open Food Facts-a əlavə etdiyim yeni məhsullar';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Tamamlamalı olduğum məhsullar';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Bütün natamam məhsullar';

  @override
  String get preferences_my_contributions_prices_title => 'Qiymətlər';

  @override
  String get preferences_my_contributions_my_prices_title => 'Qiymətlərim';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Qiymətlərim, sübutlarım…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Tamamlamağa kömək edə biləcəyiniz məhsullar';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Ölkənizdə Nutri-Score və Green-Score-u hesablamağa kömək edin';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Mən töhfə verdiyim qiymətlər';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Qiymət etiketləri və qəbzlər';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Qəbzlərinizin fotoşəkillərini çəkin və əlaqəli barkodları skan edin';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Mağazada qiymətlərin fotoşəkillərini çəkin';

  @override
  String get preferences_prices_newest_title => 'Ən yeni qiymətlər';

  @override
  String get preferences_prices_newest_subtitle =>
      'Open Prices icması tərəfindən əlavə edilən son qiymətlər';

  @override
  String get preferences_prices_top_contributors_title =>
      'Ən çox qiymətə sahib olanlar';

  @override
  String get preferences_prices_metrics_title => 'Açıq Qiymət ölçüləri';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Layihənin təkamülünü izləyin';

  @override
  String get preferences_prices_ways_contribute_title => 'Töhfə vermə yolları';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'AI köməyi ilə özünüz və ya başqaları tərəfindən əlavə edilmiş qiymətləri təsdiqləyin';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Tezliklə kamera rulonuzdan çoxlu qəbz və ya rəflərin fotoşəkillərini əlavə edin';

  @override
  String get preferences_prices_challenges_title => 'Aylıq çətinliklər';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Qiymətləri toplamaq üçün aylıq tematik tapşırıqlarda iştirak edin';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Loyallıq məlumatlarınızı geri alın';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Məlumatlarınızı necə tələb edəcəyinizi öyrənin';

  @override
  String get preferences_page_customize_app_title => 'Proqramı fərdiləşdirin';

  @override
  String get preferences_page_contribute_project_title =>
      'Layihəyə töhfə verin';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Open Food Facts na kömək etməyin sadə yolları';

  @override
  String get preferences_page_faq_subtitle =>
      'Hesab metodologiyaları, yardım və layihə haqqında daha çox';

  @override
  String get product_edit_robotoff_positive_button => 'Təklifi qəbul edin';

  @override
  String get product_edit_robotoff_negative_button => 'Təklifi rədd edin';

  @override
  String get product_edit_robotoff_show_proof => 'Sübut göstər';

  @override
  String get product_edit_robotoff_expand_proof => 'Sübutları genişləndirin';

  @override
  String get product_page_tab_raw_data => 'Xam məlumat';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Səhifə $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Səhifə $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$total elementdən $count';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$total elementdən $count';
  }

  @override
  String item_count(int count) {
    return '$count əşyalar';
  }

  @override
  String item_count_string(String count) {
    return '$count əşyalar';
  }

  @override
  String get prices_no_result => 'Qiymət statistikası tapılmadı.';

  @override
  String get prices_error_loading_more_items =>
      'Daha çox element yüklənərkən xəta baş verdi';

  @override
  String get prices_proof_error =>
      'Doğrulama uğursuz oldu, sübutları əldə etmək mümkün olmadı';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$total sübutlardan $count';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$total töhfə verənlərdən $count';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$total yerlərdən $count';
  }

  @override
  String prices_locations_count(int count) {
    return '$count yerlər';
  }

  @override
  String get restart_to_apply_message =>
      'Dəyişiklikləri tətbiq etmək üçün proqramı yenidən başladın.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Qrafik interfeys';

  @override
  String get preferences_app_settings_media_title => 'Media';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Qida Faktları Laboratoriyalarını açın';

  @override
  String get preferences_root_account_title => 'Hesab';

  @override
  String get preferences_contribute_translate_header =>
      'Open Food Facts dilinizə gətirin';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Proqramın alfa versiyasında qeydiyyatdan keçin';

  @override
  String get preferences_dev_mode_section_data => 'Töhfələr və Məhsul datası';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Folksonomiya göstərməyin';

  @override
  String get preferences_account_title => 'Hesab';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '${created}tarixində əlavə edilib';
  }

  @override
  String get location_map_details_title => 'Yerləşmə təfərrüatları';

  @override
  String get location_map_details_name => 'Ad';

  @override
  String get location_map_details_street => 'Küçə';

  @override
  String get location_map_details_city => 'Şəhər';

  @override
  String get location_map_details_postcode => 'Poçt kodu';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Koordinatlar';

  @override
  String get location_map_details_osm_id => 'OSM ID-si';
}
