// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Amharic (`am`).
class AppLocalizationsAm extends AppLocalizations {
  AppLocalizationsAm([String locale = 'am']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Yes';

  @override
  String get add => 'ያክሉ';

  @override
  String get account_delete_message =>
      'መለያዎን መሰረዝ እንደሚፈልጉ እርግጠኛ ነዎት?\nየተወሰነ ምክንያት ካለ፣ እባክዎ ከታች ያጋሩ';

  @override
  String get reason => 'ምክንያት';

  @override
  String get okay => 'እሺ';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'ፍጠር';

  @override
  String get applyButtonText => 'Apply';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'ቀጥል';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'ወደ ላይ ተመለስ';

  @override
  String get save => 'Save';

  @override
  String get save_confirmation => 'እርግጠኛ ነዎት ማስቀመጥ ይፈልጋሉ?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Cancel';

  @override
  String get ignore => 'ችላ በል';

  @override
  String get close => 'Close';

  @override
  String get no => 'No';

  @override
  String get stop => 'ተወ';

  @override
  String get finish => 'ጨርስ';

  @override
  String get calculate => 'አስላ';

  @override
  String get reset_food_prefs => 'የምግብ ምርጫዎችን ዳግም ያስጀምሩ';

  @override
  String get error => 'የሆነ ችግር ተፈጥሯል';

  @override
  String get error_occurred => 'ስህተት ተከስቷል';

  @override
  String get featureInProgress => 'አሁንም በዚህ ባህሪ ላይ እየሰራን ነው፣ ይከታተሉን';

  @override
  String get label_web => 'በድር ላይ ይመልከቱ';

  @override
  String get learnMore => 'ተጨማሪ ይወቁ';

  @override
  String get unknown => 'ያልታወቀ';

  @override
  String get match_very_good => 'በጣም ጥሩ ተዛማጅ';

  @override
  String get match_good => 'ጥሩ ተዛማጅ';

  @override
  String get match_poor => 'ደካማ ተዛማጅ';

  @override
  String get match_may_not => 'May not match';

  @override
  String get match_does_not => 'አይዛመድም';

  @override
  String get match_unknown => 'ያልታወቀ ተዛማጅ';

  @override
  String get match_short_very_good => 'በጣም ጥሩ ተዛማጅ';

  @override
  String get match_short_good => 'ጥሩ ተዛማጅ';

  @override
  String get match_short_poor => 'ደካማ ተዛማጅ';

  @override
  String get match_short_may_not => 'May not match';

  @override
  String get match_short_does_not => 'አይዛመድም';

  @override
  String get match_short_unknown => 'ያልታወቀ ተዛማጅ';

  @override
  String get licenses => 'ፍቃዶች';

  @override
  String get looking_for => 'እየፈለግኩ ነው';

  @override
  String get welcomeToOpenFoodFacts => 'ወደ Open Food Facts እንኳን በደህና መጡ';

  @override
  String get whatIsOff =>
      'ክፍት የምግብ ፋክትስ በአካባቢ ማህበረሰቦች የሚተዳደር ዓለም አቀፍ ለትርፍ ያልተቋቋመ ድርጅት ነው።';

  @override
  String get productDataUtility => 'ከምርጫዎችዎ ጋር የሚዛመድ የምግብ መረጃ ይመልከቱ።';

  @override
  String get healthCardUtility => 'ለእርስዎ ጥሩ የሆኑ ምግቦችን ይምረጡ።';

  @override
  String get ecoCardUtility => 'ለፕላኔቷ ጥሩ የሆኑ ምግቦችን ምረጥ።';

  @override
  String get server_error_open_new_issue =>
      'የአገልጋይ ምላሽ የለም! በሚከተለው አገናኝ ችግር ሊከፍቱ ይችላሉ።';

  @override
  String get sign_in_text => 'አስተዋጽዖዎችዎን ለማስቀመጥ ወደ ክፍት የምግብ እውነታዎች መለያዎ ይግቡ';

  @override
  String get incorrect_credentials => 'የተሳሳተ የተጠቃሚ ስም ወይም የይለፍ ቃል።';

  @override
  String get password_lost_incorrect_credentials =>
      'ይህ ኢሜይል ወይም የተጠቃሚ ስም የለም። እባክዎ የእርስዎን ምስክርነቶች ያረጋግጡ።';

  @override
  String get password_lost_server_unavailable =>
      'በአሁኑ ጊዜ በአገልጋዮቻችን ላይ ፍጥነት መቀነስ እያጋጠመን ነው፣ እና ለዚህ ይቅርታ እንጠይቃለን። እባክዎ ቆይተው እንደገና ይሞክሩ።';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable => 'አውታረ መረቡ ሊደረስበት የማይችል ነው';

  @override
  String get login_result_type_server_issue => 'በአገልጋዩ ላይ ችግር። እባክዎ በኋላ ይሞክሩ።';

  @override
  String get login_page_username_or_email => 'እባክዎ የተጠቃሚ ስም ወይም ኢሜይል ያስገቡ';

  @override
  String get login_page_password_error_empty => 'እባክዎ የይለፍ ቃል ያስገቡ';

  @override
  String get create_account => 'መለያ ፍጠር';

  @override
  String get sign_in => 'ይግቡ';

  @override
  String get sign_in_mandatory => 'ለዚያ ባህሪ እርስዎ በመለያ እንዲገቡ እንፈልጋለን።';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'ውጣ';

  @override
  String get sign_out_confirmation => 'ለመውጣት እርግጠኛ ነዎት?';

  @override
  String get password => 'የይለፍ ቃል';

  @override
  String get forgot_password => 'የይለፍ ቃል ረስተዋል';

  @override
  String get forgot_password_question => 'የይለፍ ቃል ረሱ?';

  @override
  String get view_profile => 'መገለጫ ይመልከቱ';

  @override
  String get reset_password => 'የይለፍ ቃል ዳግም አስጀምር';

  @override
  String get reset_password_explanation_text =>
      'የይለፍ ቃል ከተረሳ፣ የይለፍ ቃል ዳግም ለማስጀመር መመሪያዎችን ለመቀበል የተጠቃሚ ስምዎን ወይም የኢሜይል አድራሻዎን ያስገቡ። እንዲሁም የአይፈለጌ መልእክት አቃፊውን መፈተሽዎን ያስታውሱ።';

  @override
  String get username_or_email => 'የተጠቃሚ ስም ወይም ኢሜይል';

  @override
  String get reset_password_done =>
      'የይለፍ ቃልዎን ዳግም ለማስጀመር አገናኝ ያለው ኢሜይል ከመለያዎ ጋር ወደተገናኘው የኢሜይል አድራሻ ተልኳል። እንዲሁም አይፈለጌ መልእክትዎን ያረጋግጡ።';

  @override
  String get send_reset_password_mail => 'የይለፍ ቃል ቀይር';

  @override
  String get enter_some_text => 'እባክዎ የተወሰነ ጽሑፍ ያስገቡ';

  @override
  String get sign_up_page_title => 'ይመዝገቡ';

  @override
  String get sign_up_page_action_button => 'ይመዝገቡ';

  @override
  String get sign_up_page_action_doing_it => 'በመመዝገብ ላይ…';

  @override
  String get sign_up_page_action_ok => 'እንኳን ደስ አላችሁ! መለያዎ አሁን ተፈጥሯል።';

  @override
  String get sign_up_page_display_name_hint => 'ስም';

  @override
  String get sign_up_page_display_name_error_empty =>
      'እባክዎ መጠቀም የሚፈልጉትን የማሳያ ስም ያስገቡ';

  @override
  String get sign_up_page_email_hint => 'ኢሜይል';

  @override
  String get sign_up_page_email_error_empty => 'ኢሜይል ያስፈልጋል';

  @override
  String get sign_up_page_email_error_invalid => 'ልክ ያልሆነ ኢሜይል';

  @override
  String get sign_up_page_username_hint => 'የተጠቃሚ ስም፡ በይፋ የሚታይ';

  @override
  String get sign_up_page_username_error_empty => 'እባክዎ የተጠቃሚ ስም ያስገቡ';

  @override
  String get sign_up_page_username_error_invalid => 'እባክዎ ትክክለኛ የተጠቃሚ ስም ያስገቡ';

  @override
  String get sign_up_page_username_description =>
      'Username cannot contains spaces, caps or special characters.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'የተጠቃሚ ስም ከ $value ቁምፊዎች መብለጥ አይችልም';
  }

  @override
  String get sign_up_page_password_hint => 'የይለፍ ቃል';

  @override
  String get sign_up_page_password_error_empty => 'እባክዎ የይለፍ ቃል ያስገቡ';

  @override
  String get sign_up_page_password_error_invalid =>
      'እባክዎ ትክክለኛ የይለፍ ቃል ያስገቡ (ቢያንስ 6 ቁምፊዎች)';

  @override
  String get sign_up_page_confirm_password_hint => 'የይለፍ ቃል አረጋግጥ';

  @override
  String get sign_up_page_confirm_password_error_empty => 'የይለፍ ቃሉን ያረጋግጡ እባክዎ';

  @override
  String get sign_up_page_confirm_password_error_invalid => 'የይለፍ ቃሎች አይዛመዱም';

  @override
  String get sign_up_page_agree_text => 'በክፍት የምግብ እውነታዎች እስማማለሁ';

  @override
  String get sign_up_page_terms_text => 'የአጠቃቀም ውሎች እና መዋጮዎች';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'መለያ ሲፈጥሩ፣ የአጠቃቀም ውሉን መስማማት ግዴታ ነው፣ ሆኖም ግን፣ ስም-አልባ አስተዋጽዖዎች አሁንም በመተግበሪያው በኩል ሊደረጉ ይችላሉ።';

  @override
  String get sign_up_page_producer_checkbox => 'የምግብ አምራች ነኝ';

  @override
  String get sign_up_page_producer_hint => 'ፕሮዲዩሰር/ብራንድ';

  @override
  String get sign_up_page_producer_error_empty =>
      'እባክዎ ፕሮዲዩሰር ወይም የምርት ስም ያስገቡ';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'ለ Open Food Facts ጋዜጣ መመዝገብ እፈልጋለሁ (በማንኛውም ጊዜ ከደንበኝነት ምዝገባ መውጣት ይችላሉ)';

  @override
  String get sign_up_page_user_name_already_used =>
      'የተጠቃሚ ስም አስቀድሞ አለ፣ እባክዎ ሌላ የተጠቃሚ ስም ይምረጡ።';

  @override
  String get sign_up_page_email_already_exists =>
      'አስቀድሞ አለ፣ ወደ መለያው ይግቡ ወይም በሌላ ኢሜይል ይሞክሩ።';

  @override
  String get sign_up_page_provide_valid_email => 'እባክዎ ትክክለኛ የኢሜይል አድራሻ ያቅርቡ።';

  @override
  String get sign_up_page_server_busy =>
      'በጣም እናዝናለን፣ መለያዎን ለመፍጠር አንዳንድ የቴክኒክ ችግሮች አጋጥመውናል። እባክዎ ቆይተው እንደገና ይሞክሩ።';

  @override
  String get settingsTitle => 'Settings';

  @override
  String get darkmode => 'ገጽታ';

  @override
  String get darkmode_dark => 'ጨለማ';

  @override
  String get darkmode_light => 'ብርሃን';

  @override
  String get darkmode_system_default => 'የስርዓት ነባሪ';

  @override
  String get thanks_for_contributing => 'ስላበረከቱልን እናመሰግናለን!';

  @override
  String get contributors_label => 'መተግበሪያውን እየገነቡ ነው';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'አበርካች፦ $name';
  }

  @override
  String get contributors_description => 'የዚህ መተግበሪያ አስተዋጽዖ አበርካቾች በሙሉ ዝርዝር';

  @override
  String get support => 'ድጋፍ';

  @override
  String get support_join_slack => 'በSlack ቻናላችን እርዳታ ይጠይቁ';

  @override
  String get support_via_forum => 'በእኛ መድረክ ላይ እርዳታ ይጠይቁ';

  @override
  String get support_via_email => 'ኢሜይል ይላኩልን';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'የመተግበሪያ ምዝግብ ማስታወሻዎችን ይላኩ?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'የመተግበሪያ ምዝግብ ማስታወሻዎችን በኢሜልዎ አባሪ ውስጥ ማካተት ይፈልጋሉ?';

  @override
  String get termsOfUse => 'የአጠቃቀም ውሎች';

  @override
  String get legalNotices => 'የህግ ማስታወቂያዎች';

  @override
  String get privacy_policy => 'የግላዊነት መመሪያ';

  @override
  String get about_this_app => 'ስለዚህ መተግበሪያ';

  @override
  String get contribute => 'Contribute';

  @override
  String get contribute_sw_development => 'የሶፍትዌር ልማት';

  @override
  String get contribute_develop_text =>
      'የእያንዳንዱ ክፍት የምግብ መረጃ ምርት ኮድ በጂትሆብ ላይ ይገኛል። ኮዱን (ክፍት ምንጭ ነው) እንደገና መጠቀም እና በመላው ፕላኔት ላይ ላሉ ሰዎች ሁሉ እንድናሻሽለው መርዳት ይችላሉ።';

  @override
  String get contribute_develop_text_2 =>
      'ጥያቄዎችን ለመጠየቅ ተመራጭ መንገድ የሆነውን የOpen Food Facts Slack chatroom መቀላቀል ይችላሉ።';

  @override
  String get contribute_develop_dev_mode_title => 'የDEV ሁነታ?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'የDEV ሁነታን ያግብሩ';

  @override
  String get contribute_donate_title => 'Donate';

  @override
  String get contribute_donate_header => 'ለክፍት የምግብ እውነታዎች ይለግሱ';

  @override
  String get contribute_enroll_alpha_warning =>
      'በውስጣዊ የአልፋ ስሪት፣ የውሂብ ሙሉ በሙሉ መጥፋት እንደሚቻል እና መተግበሪያው በማንኛውም ጊዜ ጥቅም ላይ ሊውል እንደማይችል እባክዎ ልብ ይበሉ!';

  @override
  String get contribute_improve_ProductsToBeCompleted => 'የሚጠናቀቁ ምርቶች';

  @override
  String get contribute_improve_header => 'ማሻሻል';

  @override
  String get contribute_improve_text =>
      'የመረጃ ቋቱ የፕሮጀክቱ ዋና አካል ነው። ለመርዳት ቀላል እና በጣም ፈጣን ነው። ለስልክዎ የሞባይል መተግበሪያን ማውረድ እና ምርቶችን ማከል ወይም ማሻሻል መጀመር ይችላሉ።\n\nበሌላ በኩል፣ የOpen Food Facts ድህረ ገጽ አስተዋጽዖ ለማድረግ ብዙ መንገዶችን ያቀርባል፡ ';

  @override
  String get contribute_translate_header => 'ተርጉም';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'መተርጎም ጀምር';

  @override
  String get contribute_translate_text =>
      'ክፍት የምግብ እውነታዎች ከ160 በላይ አገሮችን ያካተተ ዓለም አቀፍ ፕሮጀክት ነው። ክፍት የምግብ እውነታዎች ወደ ደርዘን በሚቆጠሩ ቋንቋዎች የተተረጎመ ሲሆን በየጊዜው እየተሻሻለ የሚሄድ ይዘት አለው።';

  @override
  String get contribute_translate_text_2 => 'ትርጉሞች ከፕሮጀክቱ ቁልፍ ተግባራት አንዱ ናቸው';

  @override
  String get contribute_join_skill_pool =>
      'ክህሎቶችዎን ለ Open Food Facts ያበርክቱ። የክህሎት ቡድኑን ይቀላቀሉ!';

  @override
  String get contribute_share_header => 'ክፍት የምግብ እውነታዎችን ከጓደኞችዎ ጋር ያጋሩ';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'የታማኝነት ካርዶችዎን ውሂብ ወደ ውጭ ለመላክ የጂዲፒአር (GDPR) በመጠየቅ ዋጋዎችን ያበርክቱ';

  @override
  String get tap_to_answer => 'ጥያቄዎችን ለመመለስ እዚህ መታ ያድርጉ';

  @override
  String get tap_to_answer_hint => 'ስለዚህ ምርት ጥያቄዎችን ለመመለስ እዚህ መታ ያድርጉ';

  @override
  String get robotoff_questions_loading_hint =>
      'ስለዚህ ምርት ጥያቄዎች እስኪጫኑ ድረስ እባክዎ ይጠብቁ';

  @override
  String get saving_answer => 'መልስዎን በማስቀመጥ ላይ';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'ለምታበረክቱት አስተዋጽኦ ክሬዲት ለማግኘት ወደ ክፍት የምግብ እውነታዎች መለያዎ ይግቡ';

  @override
  String get question_yes_button_accessibility_value => 'አዎ የሚል መልስ';

  @override
  String get question_no_button_accessibility_value => 'አይ የሚል መልስ';

  @override
  String get question_skip_button_accessibility_value => 'ይህንን ጥያቄ ዝለል';

  @override
  String get tap_to_edit_search => 'ፍለጋን ለማርትዕ መታ ያድርጉ';

  @override
  String get myPreferences => 'የእኔ ምርጫዎች';

  @override
  String get account_create_message =>
      'በዓለም ዙሪያ የምግብ እውቀትን ለመገንባት መለያዎን ይፍጠሩ እና ክፍት የምግብ እውነታዎች ማህበረሰብን ይቀላቀሉ!';

  @override
  String get join_us => 'ይቀላቀሉን';

  @override
  String get myPreferences_profile_title => 'የእርስዎ መገለጫ';

  @override
  String get myPreferences_profile_subtitle =>
      'የክፍት ምግብ እውነታዎች አስተዋጽዖ አበርካች መለያዎን ያስተዳድሩ።';

  @override
  String get myPreferences_settings_title => 'የመተግበሪያ ቅንብሮች';

  @override
  String get myPreferences_settings_subtitle => 'ጨለማ ሁነታ፣ ቋንቋዎች…';

  @override
  String get myPreferences_food_title => 'የምግብ ምርጫዎች';

  @override
  String get myPreferences_food_subtitle => 'ስለ ምግብ በጣም አስፈላጊ የሆነውን መረጃ ይምረጡ።';

  @override
  String get myPreferences_food_comment =>
      'ምግብን እንደ ምርጫዎ ደረጃ ለመስጠት፣ ቅድሚያ የሚሰጧቸውን መረጃዎች ለማየት እና የተኳሃኝነት ማጠቃለያ ለማግኘት ስለ ምግብ ምን አይነት መረጃ ለእርስዎ በጣም አስፈላጊ እንደሆነ ይምረጡ፣ ይህም በመሳሪያዎ ላይ ይቆያል፣ እና ካለዎት ከክፍት የምግብ እውነታዎች አስተዋጽዖ አበርካች መለያዎ ጋር አይቆራኙም።';

  @override
  String get confirmResetPreferences => 'የምግብ ምርጫዎችዎን ዳግም ያስጀምሩ?';

  @override
  String get myPersonalizedRanking => 'የእኔ የግል ደረጃ አሰጣጥ';

  @override
  String get ranking_tab_all => 'All';

  @override
  String get ranking_subtitle_match_yes => 'ለእርስዎ በጣም ጥሩ ተዛማጅ';

  @override
  String get ranking_subtitle_match_no => 'በጣም ደካማ ተዛማጅ';

  @override
  String get ranking_subtitle_match_maybe => 'ያልታወቀ ተዛማጅ';

  @override
  String get refresh_with_new_preferences => 'ዝርዝሩን በአዲሶቹ ምርጫዎችዎ ያድሱ';

  @override
  String get reloaded_with_new_preferences => 'በአዲሶቹ ምርጫዎችዎ እንደገና ተጭኗል';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'ቃኝ';

  @override
  String get history_navbar_label => 'ታሪክ';

  @override
  String get list_navbar_label => 'ዝርዝሮች';

  @override
  String get category => 'በምድብ ያጣሩ';

  @override
  String get category_all => 'All';

  @override
  String get category_search => '(የምድብ ፍለጋ)';

  @override
  String get filter => 'ማጣሪያ';

  @override
  String get scan => 'ከቅኝት ማያ ገጽ የተገኙ ምርቶች';

  @override
  String get scan_history => 'ታሪክን ይቃኙ';

  @override
  String get search => 'Search';

  @override
  String get search_product_help => 'ምርትን ይፈልጉ\nብራንድ ወይም ባር ኮድ';

  @override
  String get search_filter => 'የፍለጋ ማጣሪያ';

  @override
  String get search_history => 'የፍለጋ ታሪክ';

  @override
  String get search_store => 'ሱቅ ይፈልጉ';

  @override
  String get search_store_help => 'ፍንጭ፡ ከተማዋን ወይም አገሩን ጨምሩ';

  @override
  String get tap_for_more => 'ተጨማሪ መረጃ ለማየት መታ ያድርጉ…';

  @override
  String get product => 'Product';

  @override
  String get unknownBrand => 'የማይታወቅ የምርት ስም';

  @override
  String get unknownQuantity => 'ያልታወቀ ብዛት';

  @override
  String get unknownProductName => 'ያልታወቀ የምርት ስም';

  @override
  String get label_refresh => 'Refresh';

  @override
  String get label_reload => 'እንደገና ጫን';

  @override
  String get image => 'ምስል';

  @override
  String get front_photo => 'የፊት ፎቶ';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (ይህ ምስል ጊዜው ያለፈበት ሊሆን ይችላል)';
  }

  @override
  String get outdated_image_short_label => 'ጊዜ ያለፈበት ሊሆን ይችላል';

  @override
  String get ingredients => 'Ingredients';

  @override
  String get ingredients_editing_instructions =>
      'የመጀመሪያውን ቅደም ተከተል ያስቀምጡ። ሲገለጽ መቶኛውን ይጥቀሱ። በኮማ ወይም በሰረዝ ይለያዩት እና ለአንድ ንጥረ ነገር ንጥረ ነገሮች ቅንፎችን ይጠቀሙ።';

  @override
  String get ingredients_editing_error => 'ንጥረ ነገሮቹን ማስቀመጥ አልተሳካም።';

  @override
  String get ingredients_editing_image_error =>
      'አዲስ የንጥረ ነገሮች ምስል ማግኘት አልተሳካም።';

  @override
  String get ingredients_editing_title => 'ግብዓቶችን አርትዕ ያድርጉ';

  @override
  String get ingredients_photo => 'የንጥረ ነገሮች ፎቶ';

  @override
  String get packaging_editing_instructions =>
      'ሁሉንም የማሸጊያ ክፍሎች በኮማ ወይም በመስመር ምግብ የተለዩ፣ መጠናቸው (ለምሳሌ 1 ወይም 6) ዓይነት (ለምሳሌ ጠርሙስ፣ ሳጥን፣ ቆርቆሮ)፣ ቁሳቁስ (ለምሳሌ ፕላስቲክ፣ ብረት፣ አሉሚኒየም) እና መጠናቸው (ለምሳሌ 33cl) እና እንደገና ጥቅም ላይ የማዋል መመሪያዎቻቸውን ይዘረዝራሉ።\nምሳሌ፡ 1 ብርጭቆ ጠርሙስ እንደገና ጥቅም ላይ ለማዋል፣ 1 የፕላስቲክ ቡሽ ለመወርወር';

  @override
  String get packaging_editing_error => 'ማሸጊያውን ማስቀመጥ አልተሳካም።';

  @override
  String get packaging_editing_image_error => 'አዲስ የማሸጊያ ምስል ማግኘት አልተሳካም።';

  @override
  String get packaging_editing_title => 'ማሸጊያን ያርትዑ';

  @override
  String get nutrition => 'የተመጣጠነ ምግብ';

  @override
  String get nutrition_facts_photo => 'የአመጋገብ እውነታዎች ፎቶ';

  @override
  String get nutrition_facts_editing_title => 'የአመጋገብ እውነታዎችን ያርትዑ';

  @override
  String get packaging_information => 'የመልሶ ጥቅም ላይ የማዋል መመሪያዎች';

  @override
  String get packaging_information_photo => 'የመልሶ ጥቅም ላይ ማዋል መመሪያዎች ፎቶ';

  @override
  String get missing_product => 'አዲስ ምርት አግኝተዋል!';

  @override
  String get add_product_take_photos =>
      'ይህንን ምርት ወደ Open Food Facts ለማከል የማሸጊያውን ፎቶ ያንሱ';

  @override
  String get add_product_take_photos_descriptive =>
      'እባክዎን መጀመሪያ አንዳንድ ፎቶዎችን ያንሱ። ምርቱን በኋላ ላይ ሁልጊዜ ማጠናቀቅ ይችላሉ።';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'አዲስ ምርት';

  @override
  String get new_product_found_title => 'አዲስ ምርት ተገኝቷል!';

  @override
  String get new_product_found_text =>
      'የትብብር ዳታቤዛችን ከ **3 ሚሊዮን በላይ ምርቶችን** ይዟል፣ ነገር ግን ይህ ባርኮድ የለም፦ ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'ከዚህ ገጽ ውጣ?';

  @override
  String get new_product_leave_message =>
      'ምንም ነገር ያላስገቡ ይመስላል። ይህንን ገጽ መልቀቅ በእርግጥ ይፈልጋሉ?';

  @override
  String get new_product_dialog_description =>
      'እባክዎን ይህንን ምርት ወደ የጋራ የመረጃ ቋታችን ለማከል የማሸጊያውን ፎቶዎች ያንሱ';

  @override
  String get new_product_dialog_illustration_description =>
      'የማይታወቅ የኑትሪ-ስኮር እና የአረንጓዴ ነጥብ ያለው ምሳሌ';

  @override
  String get front_packaging_photo_button_label => 'የፊት ማሸጊያ ፎቶ';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'የፊት ማሸጊያ ፎቶ መጫንን ያረጋግጡ';

  @override
  String get confirm_button_label => 'አረጋግጥ';

  @override
  String get send_image_button_label => 'ምስል ላክ';

  @override
  String get crop_page_action_saving => 'ምስሉን በማስቀመጥ ላይ…';

  @override
  String get crop_page_action_cropping => 'ምስሉን መከርከም…';

  @override
  String get crop_page_action_local => 'የአካባቢውን ስሪት በማስቀመጥ ላይ…';

  @override
  String get crop_page_action_local_failed_title => 'ውይ… ፎቶህ ላይ የሆነ ነገር አለ!';

  @override
  String get crop_page_action_local_failed_message =>
      'ምስሉን ወደ አገልጋያችን ከመላክዎ በፊት በአካባቢው ማስኬድ አልቻልንም። እባክዎ ቆይተው እንደገና ይሞክሩ ወይም ችግሩ ከቀጠለ ያግኙን።';

  @override
  String get crop_page_action_retake => 'ፎቶ እንደገና አንሳ';

  @override
  String get crop_page_too_small_image_title => 'ምስሉ በጣም ትንሽ ነው!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'ለስዕል ለመስቀል ዝቅተኛው የፒክሰል መጠን ${expectedMinWidth}x$expectedMinHeightነው። የአሁኑ ስዕል ${actualWidth}x$actualHeightነው።';
  }

  @override
  String get crop_page_action_server => 'ወደ አገልጋዩ ጥሪ በማዘጋጀት ላይ…';

  @override
  String get front_packaging_photo_title => 'የፊት ማሸጊያ ፎቶ';

  @override
  String get ingredients_photo_title => 'የግብዓቶች ፎቶ';

  @override
  String get nutritional_facts_photo_title => 'የአመጋገብ እውነታዎች ፎቶ';

  @override
  String get recycling_photo_title => 'የመልሶ ጥቅም ላይ ማዋል መመሪያዎች ፎቶ';

  @override
  String get take_photo_title => 'Take a picture';

  @override
  String get take_more_photo_title => 'Take more photos';

  @override
  String get front_photo_uploaded => 'የፊት ፎቶ ተሰቅሏል';

  @override
  String get ingredients_photo_button_label => 'የንጥረ ነገሮች ፎቶ';

  @override
  String get ingredients_photo_uploaded => 'የግብዓቶች ፎቶ ተሰቅሏል';

  @override
  String get nutrition_cache_loading_error => 'ንጥረ ነገሮችን ከመሸጎጫ መጫን አልተቻለም';

  @override
  String get nutritional_facts_photo_button_label => 'የአመጋገብ እውነታዎች ፎቶ';

  @override
  String get nutritional_facts_input_button_label => 'የአመጋገብ እውነታዎችን ይሙሉ';

  @override
  String get nutritional_facts_added => 'የአመጋገብ እውነታዎች ተጨምረዋል';

  @override
  String get categories_added => 'ምድቦች ታክለዋል';

  @override
  String get new_product_title_nutriscore => 'Compute the Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'ቢያንስ አንድ ምድብ እና የአመጋገብ እሴቶችን በመሙላት ያግዙን';

  @override
  String get new_product_title_environmental_score => 'አረንጓዴውን ውጤት አስላ';

  @override
  String get new_product_subtitle_environmental_score =>
      'ቢያንስ አንድ ምድብ በመሙላት ያግኙት';

  @override
  String get new_product_additional_environmental_score =>
      'በመነሻ፣ በማሸጊያ እና በሌሎችም አማካኝነት የአረንጓዴ ነጥብ ስሌትን የበለጠ ትክክለኛ ያድርጉት';

  @override
  String get new_product_title_nova => 'የምግብ ማቀነባበሪያ ደረጃን (NOVA) አስላ';

  @override
  String get new_product_subtitle_nova => 'የምግብ ምድቡን እና ግብዓቶቹን በመሙላት ያግኙት';

  @override
  String get new_product_desc_nova_unknown => 'የምግብ ማቀነባበሪያ ደረጃ አይታወቅም';

  @override
  String get new_product_title_pictures => 'አዲስ ምርት';

  @override
  String get new_product_title_pictures_details =>
      'Please take the following photos and the Open Food Facts engine can work out the rest!';

  @override
  String get new_product_title_misc => 'እና አንዳንድ መሰረታዊ መረጃዎች…';

  @override
  String new_product_done_msg(String username) {
    return '\"$username\" ላበረከቱት አስተዋጽኦ እናመሰግናለን!';
  }

  @override
  String get new_product_done_msg_no_user => 'ላበረከቱት አስተዋጽኦ እናመሰግናለን!';

  @override
  String get new_product_done_button_label => 'የተጠናቀቀውን ምርት ያግኙ';

  @override
  String get hey_incomplete_product_message =>
      'Nutri-Score፣ Green Score & Ultra-processing (NOVA) ለማስላት 3 ጥያቄዎችን ለመመለስ አሁን መታ ያድርጉ!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'ይህንን ኮስሞቲክስ ለመተንተን ሁለት ጥያቄዎችን ለመመለስ አሁን ይንኩ!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'ይህንን የቤት እንስሳት የምግብ ምርት ለመተንተን የሚረዱ 3 ጥያቄዎችን ለመመለስ አሁን ይንኩ!';

  @override
  String get hey_incomplete_product_message_product =>
      'ይህንን ምርት ለማጠናቀቅ አሁን ይንኩ!';

  @override
  String get nutritional_facts_photo_uploaded => 'የአመጋገብ እውነታዎች ፎቶ ተሰቅሏል';

  @override
  String get recycling_photo_button_label => 'የመልሶ ጥቅም ላይ ማዋል ፎቶ';

  @override
  String get recycling_photo_uploaded => 'የመልሶ ጥቅም ላይ የዋለ ፎቶ ተሰቅሏል';

  @override
  String get take_more_photo_button_label => 'Take more photos';

  @override
  String get other_photo_uploaded => 'የተለያዩ ፎቶዎች ተሰቅለዋል';

  @override
  String get retake_photo_button_label => 'እንደገና ውሰድ';

  @override
  String get selecting_photo => 'ፎቶን በመምረጥ ላይ';

  @override
  String get uploading_image => 'ፎቶ ወደ አገልጋዩ በመስቀል ላይ';

  @override
  String get uploading_image_type_front =>
      'የፊት ፎቶን ወደ Open Food Facts በመስቀል ላይ';

  @override
  String get uploading_image_type_ingredients =>
      'የንጥረ ነገሮች ምስል ወደ ክፍት የምግብ እውነታዎች መስቀል';

  @override
  String get uploading_image_type_nutrition =>
      'የአመጋገብ ምስልን ወደ ክፍት የምግብ እውነታዎች መስቀል';

  @override
  String get uploading_image_type_packaging =>
      'የማሸጊያ ምስልን ወደ ክፍት የምግብ እውነታዎች መስቀል';

  @override
  String get uploading_image_type_other => 'ሌላ ምስል ወደ Open Food Facts በመስቀል ላይ';

  @override
  String get uploading_image_type_generic => 'ምስል ወደ ክፍት የምግብ እውነታዎች መስቀል';

  @override
  String get score_add_missing_ingredients => 'የጎደሉ ንጥረ ነገሮችን ያክሉ';

  @override
  String get score_add_missing_packaging_image => 'የጎደለውን የማሸጊያ ምስል ያክሉ';

  @override
  String get score_add_missing_nutrition_facts => 'የጎደሉ የአመጋገብ እውነታዎችን ያክሉ';

  @override
  String get score_add_missing_product_traces => 'የጎደሉ የምርት ዱካዎችን ያክሉ';

  @override
  String get score_add_missing_product_category => 'ምድብ ይምረጡ';

  @override
  String get score_add_missing_precise_product_category =>
      'ይበልጥ ትክክለኛ የሆነ ምድብ ይምረጡ';

  @override
  String get score_add_missing_product_countries => 'የጎደሉ የምርት አገሮችን ያክሉ';

  @override
  String get score_add_missing_product_emb => 'የጎደሉ የምርት መከታተያ ኮዶችን ያክሉ';

  @override
  String get score_add_missing_product_labels => 'የጎደሉ የምርት መለያዎችን ያክሉ';

  @override
  String get score_add_missing_product_origins => 'የጎደሉ የምርት መነሻዎችን ያክሉ';

  @override
  String get score_add_missing_product_stores => 'የጎደሉ የምርት መደብሮችን ያክሉ';

  @override
  String get score_add_missing_product_brands => 'የጎደሉ የምርት ብራንዶችን ያክሉ';

  @override
  String get score_update_nutrition_facts => 'የአመጋገብ እውነታዎችን አዘምን';

  @override
  String get nutrition_page_title => 'የአመጋገብ እውነታዎች';

  @override
  String get nutrition_page_nutritional_info_title => 'የአመጋገብ መረጃ';

  @override
  String get nutrition_page_nutritional_info_label => 'በምርቱ ላይ የተገለጹ እሴቶች፡';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Yes';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'No';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'ፎቶ ክፈት';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'ጥሩ ልምዶች፡ የአመጋገብ መረጃ';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'አንዳንድ ጊዜ የአመጋገብ እውነታዎች **በማሸጊያው** ላይ ወይም ከምርቱ ጋር በተሰጠው ሰነድ ላይ አይገለጹም። በዚህ ሁኔታ፣ እና በዚህ ሁኔታ ብቻ፣ እሴቱን ወደ **NO** ማቀናበር ይችላሉ።';

  @override
  String get nutrition_page_serving_type_label => 'የአመጋገብ እሴቶች፡';

  @override
  String get nutrition_page_per_100g => 'በ100 ግራም';

  @override
  String get nutrition_page_per_100g_100ml => 'በ100 ግራም/ሚሊ ሊትር';

  @override
  String get nutrition_page_per_serving => 'በአንድ አቅርቦት';

  @override
  String get nutrition_page_add_nutrient => 'ንጥረ ነገር ይጨምሩ';

  @override
  String get nutrition_page_serving_size => 'የማቅረቢያ መጠን';

  @override
  String get nutrition_page_serving_size_hint =>
      'የማቅረቢያ መጠን ያስገቡ (ለምሳሌ፡ 100 ግራም)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'ጥሩ ልምዶች፡ የማቅረቢያ መጠን';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'ይህ እሴት **በአንድ አቅርቦት መጠን የእያንዳንዱን ንጥረ ነገር ተመጣጣኝ ስሌት ለማድረግ ይረዳል**።';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '** የተፈቀዱ ክፍሎች ** ናቸው፡ ኪግ፣ g፣ mg፣ µg፣ oz፣ l፣ dl፣ cl፣ ml፣ fl.oz፣ fl oz፣ г, мг, кг, ኤል, дл, kl, мл, 毫克, 公斤, 毫名, 公斤, 毫名, 公斤, 毫名, 公斤, 毫名, 公斤';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 ግራም**፣ **60 ግራም** ወይም **60 ግራም** (የመጀመሪያውን ይመርጣሉ)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ሚሊ ሊትር** ወይም **1 ሊትር**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'ልክ ያልሆነ አሃድ';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **ግራ**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'ልክ ያልሆኑ አሃዶች';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **ከረሜላዎች** እና 2 **ብስኩት**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'የጠፋ አሃድ';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'ልክ ያልሆነ ቁጥር';

  @override
  String get nutrition_page_update_running => 'ምርቱን በአገልጋዩ ላይ ማዘመን…';

  @override
  String get nutrition_page_update_done => 'ምርት ተዘምኗል!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'የምርቱን መጠን እንደ የማቅረቢያ መጠን ይጠቀሙበት';

  @override
  String get nutrition_page_photo_error => 'ፎቶውን መጫን አልተቻለም';

  @override
  String get more_photos => 'ተጨማሪ አስደሳች ፎቶዎች';

  @override
  String get view_more_photo_button => 'የዚህን ምርት ሁሉንም ነባር ፎቶዎች ይመልከቱ';

  @override
  String get no_product_found => 'ምንም ምርት አልተገኘም';

  @override
  String get no_location_found => 'ምንም ቦታ አልተገኘም';

  @override
  String get not_found => 'አልተገኘም፦';

  @override
  String get refreshing_product => 'ምርትን የሚያድስ';

  @override
  String get product_refreshed => 'ምርቱ ታድሷል';

  @override
  String product_image_accessibility_label(String date) {
    return 'ምስሉ የተነሳው በ $dateላይ ነው';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'ምስሉ የተነሳው በ $dateላይ ነው። ይህ ምስል ጊዜው ያለፈበት ሊሆን ይችላል';
  }

  @override
  String get product_image_outdated => 'ይህ ምስል ጊዜው ያለፈበት ሊሆን ይችላል';

  @override
  String get product_image_outdated_explanations_title =>
      'ይህ ምስል ጊዜው ያለፈበት ሊሆን ይችላል';

  @override
  String get product_image_outdated_explanations_content =>
      'ይህ ምስል የተወሰደው ከአንድ ዓመት በፊት ነው።\n**እባክዎ አሁንም ወቅታዊ መሆኑን ያረጋግጡ።**።\n\nይህ **ማስጠንቀቂያ ብቻ ነው**። ይዘቱ አሁንም ተመሳሳይ ከሆነ፣ ይህንን መልእክት ችላ ማለት ይችላሉ።';

  @override
  String product_image_action_replace_photo(String type) {
    return 'ፎቶ ተካ ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'ፎቶ ያክሉ ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Take a picture';

  @override
  String get product_image_action_from_gallery => 'ከስልክዎ ጋለሪ ውስጥ ይምረጡ';

  @override
  String get product_image_action_choose_existing_photo => 'ከምርት ፎቶዎች ውስጥ ይምረጡ';

  @override
  String get product_image_details_label => 'ስለ ፎቶው መረጃ';

  @override
  String get product_image_details_from_producer => 'ከፕሮዲዩሰሩ';

  @override
  String get product_image_details_contributor => 'Contributor';

  @override
  String get product_image_details_contributor_producer =>
      'አስተዋጽዖ አበርካች (አዘጋጅ)';

  @override
  String get product_image_details_date => 'ቀን';

  @override
  String get product_image_details_date_unknown => 'ያልታወቀ';

  @override
  String get homepage_main_card_logo_description =>
      'ወደ Open Food Facts እንኳን በደህና መጡ';

  @override
  String get homepage_main_card_subheading => '**ባርኮድ ወይም\n**ምርትን ይፈልጉ*** ይቃኙ';

  @override
  String get homepage_main_card_search_field_hint => 'ምርት ይፈልጉ';

  @override
  String get homepage_main_card_search_field_tooltip => 'ፍለጋ ጀምር';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'የቅርብ ጊዜ ዜና፦ $news_title';
  }

  @override
  String get tagline_app_review => 'መተግበሪያውን ወደዱት?';

  @override
  String get tagline_app_review_button_positive => 'ወድጄዋለሁ! 😍';

  @override
  String get tagline_app_review_button_negative => 'በእውነቱ አይደለም…';

  @override
  String get tagline_app_review_button_later => 'በኋላ ጠይቀኝ';

  @override
  String get tagline_feed_news_button => 'ተጨማሪ እወቅ';

  @override
  String get app_review_negative_modal_title => 'መተግበሪያችንን አልወደዱትም?';

  @override
  String get app_review_negative_modal_text =>
      'ለምን እንደሆነ ጥቂት ሰከንዶች ወስደህ ልትነግረን ትችላለህ?';

  @override
  String get app_review_negative_modal_positive_button => 'አዎ፣ በፍጹም!';

  @override
  String get app_review_negative_modal_negative_button => 'No';

  @override
  String get could_not_refresh => 'ምርቱን ማደስ አልተቻለም';

  @override
  String get product_internet_error_modal_title => 'ስህተት ተከስቷል!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'በአውታረ መረብ ስህተት ምክንያት ስለዚህ ምርት መረጃ ማግኘት አልቻልንም። እባክዎ የበይነመረብ ግንኙነትዎን ያረጋግጡ እና እንደገና ይሞክሩ።\n\nውስጣዊ ስህተት፦\n$error';
  }

  @override
  String get product_tags_title => 'የምርት ባህሪያት';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'ምንም ንብረቶች የሉም';

  @override
  String get product_tags_explanation =>
      'ንብረቶችን (ቁልፍ/ዋጋ) ወደ ምርት በማከል፣ ለማበልጸግ ይረዳሉ።';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'ባህሪያትን ያክሉ';

  @override
  String get add_edit_tags => 'ባህሪያትን ያክሉ ወይም ያርትዑ';

  @override
  String get edit_tag => 'ባህሪን ያርትዑ';

  @override
  String get remove_tag => 'ንብረትን አስወግድ';

  @override
  String get tag_key => 'ንብረት';

  @override
  String get tag_keys => 'ንብረቶች';

  @override
  String get tag_key_uneditable => 'ንብረት (ሊስተካከል የማይችል)';

  @override
  String get tag_key_input_hint => 'ባህሪ ያስገቡ';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'እሴት ያስገቡ';

  @override
  String get tag_key_item => 'ንብረት፡';

  @override
  String get tag_value_item => 'ዋጋ፡';

  @override
  String get tag_key_explanations => 'ቁልፍ ትንሽ ፊደል እና ምንም ቦታ የሌለው መሆን አለበት።';

  @override
  String tag_key_already_exists(String property) {
    return '$property ንብረት ያለው መለያ አስቀድሞ አለ!';
  }

  @override
  String get product_internet_error =>
      'በአውታረ መረብ ስህተት ምክንያት ስለዚህ ምርት መረጃ ማግኘት አይቻልም።';

  @override
  String get cached_results_from => 'ውጤቶችን አሳይ ከ፡';

  @override
  String get product_search_same_category => 'አማራጮችን ያግኙ';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'ይህ ባህሪ ጥቅም ላይ ሊውል የሚችለው ምድብ ላላቸው ምርቶች ብቻ ነው።\n\nምድብ ለማከል ምርቱን ያርትዑ።';

  @override
  String get product_improvement_add_category =>
      'የNutri-Score ን ለማስላት ምድብ ያክሉ።';

  @override
  String get product_improvement_add_nutrition_facts =>
      'የNutri-Score ን ለማስላት የአመጋገብ እውነታዎችን ያክሉ።';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'የNutri-Score ን ለማስላት የአመጋገብ እውነታዎችን እና ምድብ ያክሉ።';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'የዚህ ምርት የNutri-Score ሊሰላ አይችልም፣ ይህም ምናልባት መደበኛ ያልሆነ ምድብ ሊሆን ይችላል። ይህ እንደ ስህተት ከተቆጠረ፣ እባክዎን ያግኙን።';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'የአመጋገብ ምስሉ ጊዜ ያለፈበት ነው፡ እባክዎን ያድሱት።';

  @override
  String get product_improvement_origins_to_be_completed =>
      'አረንጓዴው ነጥብ የንጥረ ነገሮቹን አመጣጥ ግምት ውስጥ ያስገባል። እባክዎን የንጥረ ነገሮቹን ዝርዝር እና/ወይም ማንኛውንም የጂኦግራፊያዊ ጥያቄ ፎቶ ያንሱ ወይም ምርቱን ያርትዑ፣ ስለዚህ ግምት ውስጥ መግባት ይችላሉ።';

  @override
  String get country_chooser_label => 'እባክዎ አገር ይምረጡ';

  @override
  String get currency_chooser_label => 'እባክዎ ምንዛሬ ይምረጡ';

  @override
  String get country_change_message => 'አገሮችን አሁን ቀይረሃል።';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'ምንዛሬውን ከ $previousCurrency ወደ $possibleCurrencyመቀየር ይፈልጋሉ?';
  }

  @override
  String get onboarding_country_chooser_label => 'እባክዎ አገር ይምረጡ፦';

  @override
  String get country_chooser_label_from_settings => 'ሀገርህ';

  @override
  String get country_selection_explanation =>
      'አንዳንድ የአካባቢ ገጽታዎች ለአካባቢ የተወሰኑ ናቸው';

  @override
  String get product_removed_comparison => 'ምርቱ ከንጽጽር ተወግዷል';

  @override
  String get native_app_settings => 'ቤተኛ የመተግበሪያ ቅንብሮች';

  @override
  String get native_app_description => 'ለክፍት የምግብ እውነታዎች የስርዓት ቅንብሮችን ይክፈቱ';

  @override
  String get product_removed_history => 'ምርቱ ከታሪክ ተወግዷል';

  @override
  String get product_removed_list => 'ምርቱ ከዝርዝሩ ተወግዷል';

  @override
  String get product_could_not_remove => 'ምርቱን ማስወገድ አልተቻለም';

  @override
  String get no_prodcut_in_list => 'በዚህ ዝርዝር ውስጥ ምንም አይነት ምርት የለም';

  @override
  String get no_product_in_section => 'በዚህ ክፍል ውስጥ ምንም ምርት የለም';

  @override
  String get recently_seen_products => 'ሁሉም የታዩ ምርቶች';

  @override
  String get clear => 'አጽዳ';

  @override
  String get clear_long => 'ዝርዝሩን ባዶ አድርግ';

  @override
  String get really_clear => 'ይህንን ዝርዝር በእርግጥ መሰረዝ ይፈልጋሉ?';

  @override
  String pct_match(Object percent) {
    return '$percent% ተዛማጅ';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ከቀናት በፊት',
      one: 'ከአንድ ቀን በፊት',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ከሰዓታት በፊት',
      one: 'ከአንድ ሰዓት በፊት',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ከደቂቃዎች በፊት',
      one: 'ከአንድ ደቂቃ በፊት',
      zero: 'ከአንድ ደቂቃ ባነሰ ጊዜ ውስጥ',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ከወራት በፊት',
      one: 'ከአንድ ወር በፊት',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ከሳምንታት በፊት',
      one: 'ከአንድ ሳምንት በፊት',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ያወዳድሩ $count ምርቶች',
      one: 'አንድ ምርት ያወዳድሩ',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count የተመረጡ ምርቶች',
      one: 'አንድ የተመረጠ ምርት',
      zero: 'የተመረጠ ምርት የለም',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'የተመረጡ ምርቶችን ያወዳድሩ';

  @override
  String get delete_products_mode => 'የተመረጡ ምርቶችን ሰርዝ';

  @override
  String get select_all_products_mode => 'ሁሉንም ምርቶች ይምረጡ';

  @override
  String get select_none_products_mode => 'ምንም አትምረጥ';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle => 'እባክዎ ቢያንስ ሁለት ምርቶችን ይምረጡ';

  @override
  String get retry_button_label => 'እንደገና ሞክር';

  @override
  String get connect_with_us => 'ከእኛ ጋር ይገናኙ';

  @override
  String get tiktok => 'በቲኪት ላይ ይከተሉን';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'በኢንስታግራም ይከተሉን';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'በX (ቀደም ሲል ትዊተር) ይከተሉን';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'በማስቶዶን ይከተሉን';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'በBlueSky ላይ ይከተሉን';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'ጦማር';

  @override
  String get faq => 'ተደጋጋሚ ጥያቄዎች';

  @override
  String get discover => 'Discover';

  @override
  String get how_to_contribute => 'እንዴት መዋጮ ማድረግ እንደሚቻል';

  @override
  String get hint_knowledge_panel_message =>
      'ስለምታዩት ነገር የበለጠ ዝርዝር መረጃ ለማግኘት የካርዱን ማንኛውንም ክፍል መታ ማድረግ ይችላሉ። አሁኑኑ ይሞክሩት!';

  @override
  String get permissions_page_title => 'የካሜራ መዳረሻ';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'ሀሳብዎን ከቀየሩ፣ ይህ አማራጭ በማንኛውም ጊዜ ከቅንብሮች ውስጥ ሊነቃ እና ሊሰናከል ይችላል።';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'ስርዓተ ክወና፦ አንድሮይድ (SDK Int: $sdkInt / ልቀት፦ $release)\nሞዴል፦ $model\nምርት፦ $product\nመሣሪያ፦ $device\nየምርት ስም፦$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'ስርዓተ ክወና፡ iOS ($version)\nሞዴል፡ $model\nአካባቢያዊ የተደረገ ሞዴል፡ $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nየመተግበሪያ ስሪት፡$appVersion\nየመተግበሪያ ግንባታ ቁጥር፡$appBuildNumber\nየመተግበሪያ ጥቅል ስም፡$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'እምቢ ማለት';

  @override
  String get ask_me_later_button_label => 'በኋላ ላይ';

  @override
  String get are_you_sure => 'ኧረ';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'በ $sourceNameላይ ተጨማሪ ይሂዱ';
  }

  @override
  String get onboarding_home_welcome_text1 => 'እንኳን ደህና መጣህ !';

  @override
  String get onboarding_home_welcome_text2 =>
      'ለእርስዎ እና ለ **ፕላኔቷ** ጥሩ የሆነ ምግብ እንዲመርጡ የሚያግዝዎት መተግበሪያ!';

  @override
  String get onboarding_continue_button => 'ቀጥል';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'የመጀመሪያውን የምሳሌ ምርትዎን በመጫን ላይ';

  @override
  String get onboarding_welcome_warning =>
      'ይቅርታ፣ የእኛ ምሳሌ ምርት ነው፣ እርስዎ ሊያስተካክሉት አይችሉም :)';

  @override
  String get product_list_your_ranking => 'ደረጃዎ';

  @override
  String get product_list_empty_icon_desc => 'ታሪክ አይገኝም';

  @override
  String get product_list_empty_title => 'መቃኘት ጀምር';

  @override
  String get product_list_empty_message =>
      'የተቃኙ ምርቶች እዚህ ይታያሉ እና ስለእነሱ ዝርዝር መረጃ ማየት ይችላሉ';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ምርቶች',
      one: 'ምርት',
      zero: 'ምርት',
    );
    return 'የሚያድስ $_temp0 በታሪክዎ ውስጥ';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ምርቶች',
      one: 'ምርት',
      zero: 'ምርት',
    );
    return '$_temp0 ማደስ ተጠናቋል';
  }

  @override
  String get product_list_compare_side_by_side => 'ጎን ለጎን አወዳድር';

  @override
  String get loading_dialog_default_title => 'ውሂብን በማውረድ ላይ';

  @override
  String get loading_dialog_default_error_message => 'ውሂብ ማውረድ አልተቻለም';

  @override
  String get account_delete => 'መለያ ሰርዝ';

  @override
  String get account_delete_title => 'መለያዬን ሰርዝ';

  @override
  String get user_profile => 'መለያ';

  @override
  String get user_profile_title_guest => 'እንኳን ደህና መጣህ!';

  @override
  String get user_profile_subtitle_guest =>
      'ወደ ክፍት የምግብ እውነታዎች ማህበረሰብ ለመቀላቀል ይግቡ ወይም ይመዝገቡ';

  @override
  String user_profile_title_id_email(String email) {
    return 'የምግብ እውነታዎችን ክፍት መግቢያ፦ $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'እንኳን ደህና መጡ $id!';
  }

  @override
  String get email_subject_account_deletion => 'መለያ ሰርዝ';

  @override
  String email_body_account_deletion(String userId) {
    return 'ሰላም፣ እባክዎን የክፍት ምግብ እውነታዎች መለያዬን ይሰርዙ፦ $userId';
  }

  @override
  String get settings_app_app => 'ማመልከቻ';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'ካሜራ';

  @override
  String get settings_app_products => 'ምርቶች';

  @override
  String get settings_app_miscellaneous => 'የተለያዩ';

  @override
  String get camera_play_sound_title => 'ቃኝ ላይ ድምጽ አጫውት';

  @override
  String get camera_play_sound_subtitle => 'በእያንዳንዱ ስኬታማ ቅኝት ላይ ድምጽ ያሰማል';

  @override
  String get camera_window_accessibility_label => 'ባርኮድ በካሜራዎ ይቃኙ';

  @override
  String get app_haptic_feedback_title => 'ንዝረት እና ሃፕቲክስ';

  @override
  String get app_haptic_feedback_subtitle =>
      'አንዳንድ እርምጃዎችን ከፈጸሙ በኋላ የሚፈጠሩ ንዝረቶች (የባርኮድ ዲኮድ ተፈትቷል፣ ምርቱ ተወግዷል…)።';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'ሲነቃ፣ የብልሽት ሪፖርቶች በራስ-ሰር ወደ Open Food Facts\' የስህተት መከታተያ ስርዓት ይገባሉ፣ በዚህም ሳንካዎች ሊስተካከሉ እና በዚህም መተግበሪያውን ማሻሻል ይችላሉ።';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'ፎቶን ያርትዑ';

  @override
  String get permission_photo_error => 'ስህተት';

  @override
  String get permission_photo_denied_title => 'ባርኮዶችን ለመቃኘት ካሜራውን እንዲጠቀሙ ይፍቀዱ';

  @override
  String permission_photo_denied_message(String appName) {
    return 'ለተሻሻለ ተሞክሮ፣ እባክዎ $appName ካሜራዎን እንዲደርስ ይፍቀዱለት። ባርኮዶችን በቀጥታ መቃኘት ይችላሉ።';
  }

  @override
  String get permission_photo_denied_button => 'ፍቀድ';

  @override
  String get permission_photo_denied_dialog_settings_title => 'ፈቃድ ተከልክሏል';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'ቀደም ሲል የካሜራውን ፈቃድ እንደከለከሉት፣ ከቅንብሮች ውስጥ እራስዎ መፍቀድ አለብዎት።';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'ቅንብሮችን ክፈት';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Cancel';

  @override
  String get permission_photo_none_found => 'ምንም ካሜራ አልተገኘም';

  @override
  String get permission_photo_denied => 'የካሜራ መዳረሻ አልተሰጠም';

  @override
  String get show_product_pictures => 'የምርት ስዕሎችን አሳይ';

  @override
  String get edit_product_label => 'ምርትን ያርትዑ';

  @override
  String get edit_product_pending_operations_banner_title =>
      'አርትዖቶችዎን በመስቀል ላይ…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'አርትዖቶችዎ **ከበስተጀርባ** እየተላኩ ነው (ወይም በኋላ ላይ ስህተት ከተፈጠረ)።\nሌሎች የምርት መስኮችን ማርትዕ መቀጠል ይችላሉ።';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'አርትዖቶችዎ ከበስተጀርባ እየተላኩ ነው** (ወይም በኋላ ላይ ስህተት ከተፈጠረ)።';

  @override
  String get edit_product_label_short => 'Edit';

  @override
  String edit_product_form_item_help(String value) {
    return '\"$value\" እንዴት ማስገባት ይቻላል?';
  }

  @override
  String get edit_product_form_item_error_empty => 'እባክዎ ባዶ ያልሆነ እሴት ያስገቡ!';

  @override
  String get edit_product_form_item_error_existing => 'ይህ ዋጋ አስቀድሞ አለ!';

  @override
  String get edit_product_form_item_add_action_brand => 'አዲስ የምርት ስም ያክሉ';

  @override
  String get edit_product_form_item_add_action_label => 'አዲስ መለያ ያክሉ';

  @override
  String get edit_product_form_item_add_action_store => 'አዲስ መደብር ያክሉ';

  @override
  String get edit_product_form_item_add_action_origin => 'አዲስ መነሻ ያክሉ';

  @override
  String get edit_product_form_item_add_action_emb_code => 'አዲስ የመከታተያ ኮድ ያክሉ';

  @override
  String get edit_product_form_item_add_action_country => 'አዲስ አገር ያክሉ';

  @override
  String get edit_product_form_item_add_action_category => 'አዲስ ምድብ ያክሉ';

  @override
  String get edit_product_form_item_add_action_trace => 'አዲስ ዱካ ያክሉ';

  @override
  String get edit_product_form_item_add_suggestion => 'ጥቆማ ያክሉ';

  @override
  String get edit_product_form_item_deny_suggestion => 'ጥቆማን እምቢ';

  @override
  String get edit_product_form_item_details_title => 'መሰረታዊ ዝርዝሮች';

  @override
  String get edit_product_form_item_details_subtitle => 'የምርት ስም፣ የምርት ስም፣ ብዛት';

  @override
  String get edit_product_form_item_other_details_title => 'ተጨማሪ ዝርዝሮች';

  @override
  String get edit_product_form_item_other_details_subtitle => 'ድህረ ገጽ…';

  @override
  String get edit_product_form_item_photos_title => 'ፎቶዎች';

  @override
  String get edit_product_form_item_photos_subtitle => 'ፎቶዎችን ያክሉ ወይም ያድሱ';

  @override
  String get edit_product_form_item_labels_title => 'መለያዎች እና የምስክር ወረቀቶች';

  @override
  String get edit_product_form_item_labels_subtitle => 'የአካባቢ፣ የጥራት መለያዎች…';

  @override
  String get edit_product_form_item_labels_hint =>
      'መለያ ያስገቡ (ለምሳሌ፡ NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'ጥሩ ልምዶች፡ መለያዎች';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'የምርቱ ማንኛውም ባህሪ **እውነታ ያለው** እና ከሌሎች መስኮች የተለየ።';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score፣ NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'በቤልጂየም የተሰራ፣ በብሪታኒ የተሰራ…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001፣ ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'በፋይበር የበለፀገ፣ የብረት ምንጭ…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'ፍትሃዊ ንግድ፣ Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'መደብሮች';

  @override
  String get edit_product_form_item_stores_hint => 'መደብር ያስገቡ';

  @override
  String get edit_product_form_item_stores_type => 'መደብር';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'ጥሩ ልምዶች፡ መደብሮች';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'ምርቱን የገዙበትን መደብር ያስገቡ።';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'ዎልማርት';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'ካርሬፎር';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 => 'ሊድል';

  @override
  String get edit_product_form_item_origins_title => 'መነሻዎች';

  @override
  String get edit_product_form_item_origins_hint => 'መነሻ ያስገቡ (ለምሳሌ፡ ጀርመን)';

  @override
  String get edit_product_form_item_origins_type => 'country';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'ጥሩ ልምዶች፡ መነሻዎች';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'በማሸጊያው ላይ የሚያገኟቸውን **የመነሻ ምልክቶችን** ያክሉ።\nበቀጥታ በንጥረ ነገሮች ዝርዝር ውስጥ ስለተጠቀሱት አመጣጥ መጨነቅ አያስፈልግዎትም።';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'ከአርጀንቲና የመጣ የበሬ ሥጋ';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'አኩሪ አተር ከአውሮፓ ህብረት አይመጣም';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint => 'አገር ያስገቡ (ለምሳሌ፡ ጀርመን)';

  @override
  String get edit_product_form_item_countries_type => 'country';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'ጥሩ ልምዶች፡ አገሮች';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**ምርቱ በስፋት የሚገኝባቸው አገሮች** (በውጭ ምርቶች ላይ የተካኑ መደብሮችን ሳይጨምር)።';

  @override
  String get edit_product_form_item_emb_codes_title => 'የመከታተያ ኮዶች';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'ኮድ ያስገቡ (ለምሳሌ፡ EMB 53062፣ FR 62.448.034 CE፣ 84 R 20፣ 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'የመከታተያ ኮድ';

  @override
  String get edit_product_form_item_emb_help_title => 'ጥሩ ልምዶች፡ የመከታተያ ኮዶች';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'በዚህ ክፍል ውስጥ፣ ከ **የማሸጊያ ምልክቶች**፣ **የመለያ ምልክቶች** ወይም **የጤና ምልክቶች** ጋር የተያያዙ ኮዶችን ማስገባት ይችላሉ።';

  @override
  String get edit_product_form_item_emb_help_info2_title => 'የመከታተያ ኮዶች ምሳሌዎች';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**የኢሲ ኮዶች** በአውሮፓ ማህበረሰብ ውስጥ የምግብ አምራቾችን ወይም ፓኬጆችን ለመለየት ጥቅም ላይ ይውላሉ፡';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nዓ.ም.';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: የ **ፈረንሳይ የአገር ኮድ**\n**72.264.002**: የጂኦግራፊያዊ መረጃ\n**CE**: የአውሮፓ ማህበረሰብ';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**የኢኤምቢ ኮዶች** በፈረንሳይ ጥቅም ላይ የዋሉ፦';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Traces';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'ዱካ ያስገቡ (ለምሳሌ፡ የአኩሪ አተር ባቄላ)';

  @override
  String get edit_product_form_item_categories_title => 'Categories';

  @override
  String get edit_product_form_item_categories_hint => 'category';

  @override
  String get edit_product_form_item_categories_type =>
      'ምድብ ያስገቡ (ለምሳሌ፡ የብርቱካን ጭማቂ)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'ጥሩ ልምዶች፡ ምድቦች';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      '**በጣም ልዩ የሆነውን ምድብ ብቻ** ያመልክቱ።\nየወላጅ ምድቦች በራስ-ሰር ይታከላሉ።';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'ምድብ ይጎድላል?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'አንድ ምድብ **በራስ-ኮምፕሌት** የማይገኝ ከሆነ፣ ለማንኛውም ለማከል ነፃነት ይሰማዎ።\nይህ በአገርዎ ውስጥ ክፍት የምግብ እውነታዎችን እንድናሻሽል ይረዳናል።';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'ሳርዲን በወይራ ዘይት ውስጥ';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'ከኮምዩቴሽን የተገኘ የብርቱካን ጭማቂ';

  @override
  String get edit_product_form_item_exit_title => 'ሳያስቀምጡ ይቁሙ?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'ከዚህ ገጽ ከመውጣትዎ በፊት ለውጦችዎን ማስቀመጥ ይፈልጋሉ?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'ለውጦችን አስቀምጥ';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'ለውጦችን አስወግድ';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredients';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'ማያ ገጹን በመቆንጠጥ ያጉሉ እና ያሳንሱ';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'ፎቶውን አጉላና አሳንስ';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '**የማጉላት-ቁንጥጫ ምልክትን** በመጠቀም፣ ፎቶውን ማጉላት ወይም ማሳነስ ይችላሉ፦';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'ያክሉ';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'እባክዎ መጀመሪያ ጽሑፍ ያስገቡ';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'አስወግድ';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => 'አርትዖትዎን ያስቀምጡ';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip => 'አርትዖትዎን ሰርዝ';

  @override
  String get edit_product_form_item_packaging_title =>
      'የመልሶ ጥቅም ላይ ማዋል መመሪያዎች ፎቶ';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'የአመጋገብ እውነታዎች';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'የአመጋገብ፣ የአልኮል ይዘት…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'ጥሩ ልምዶች፡ የአመጋገብ እውነታዎች';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'የአመጋገብ እሴቶች';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'በመጀመሪያ፣ **እሴቶቹ የተሰጡ መሆናቸውን** ይምረጡ፡';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'የአመጋገብ እውነታዎች';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'ከዚያም በማሸጊያው ላይ እንደተገለጸው የአመጋገብ ዋጋዎቹን **ያስገቡ**። ምንም ዋጋ ከሌለ \"ዓይን\" የሚለውን አዶ ጠቅ ማድረግ ይችላሉ።';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'የጎደለ መስክ?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'አንድ ግቤት ከጠፋ፣ \"ፕላስ\" የሚለውን አዶ** ላይ ጠቅ በማድረግ ማከል ይችላሉ (ለምሳሌ፡ ቫይታሚን ዲ፣ ማግኒዚየም…)።';

  @override
  String get edit_product_form_save => 'Edit';

  @override
  String get edit_product_ingredients_photo_title => 'የንጥረ ነገሮች ፎቶ';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'የማሸጊያ ፎቶ';

  @override
  String get edit_product_packaging_list_title => 'የማሸጊያ ዝርዝር';

  @override
  String get no_data_available => 'ምንም ውሂብ አይገኝም';

  @override
  String get product_field_website_title => 'ድህረገፅ';

  @override
  String get origins_editing_title => 'መነሻዎችን አርትዕ';

  @override
  String get completed_basic_details_btn_text => 'መሰረታዊ ዝርዝሮችን ይሙሉ';

  @override
  String get not_implemented_snackbar_text => 'እስካሁን አልተተገበረም';

  @override
  String get category_picker_page_appbar_text => 'Categories';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'ከፎቶው ውስጥ ንጥረ ነገሮችን ያውጡ';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'ከፎቶው ውስጥ ንጥረ ነገሮችን ማውጣት\n';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'ፎቶ በመጫን ላይ…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'ይህንን መልእክት ለምን አየዋለሁ?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'የ\"ኤክስትራክት ኢንዳክተሮች\" ባህሪን ለመጠቀም፣ ፎቶው መጀመሪያ መጫን አለበት።\n\nእባክዎ ለጥቂት ሰከንዶች ይጠብቁ ወይም በእጅ ያስገቡዋቸው።';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'ፎቶን አድስ';

  @override
  String get edit_packaging_extract_btn_text => 'ከፎቶው ላይ የማሸጊያውን ማውጣት\n';

  @override
  String get edit_packaging_extract_btn_text_short => 'የማውጣት ማሸጊያ';

  @override
  String get edit_packaging_extracting_btn_text => 'ማሸጊያውን ከፎቶው ማውጣት';

  @override
  String get edit_packaging_loading_photo_btn_text => 'ፎቶ በመጫን ላይ…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'ይህንን መልእክት ለምን አየዋለሁ?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      '\"የማውጣት ማሸጊያ\" ባህሪን ለመጠቀም፣ ፎቶው መጀመሪያ መጫን አለበት።\n\nእባክዎ ለጥቂት ሰከንዶች ይጠብቁ ወይም በእጅ ያስገቡዋቸው።';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'ፎቶን አድስ';

  @override
  String get edit_ocr_extract_failed => 'በምስሉ ላይ ያለውን ጽሑፍ ማግኘት አልተሳካም።';

  @override
  String get edit_ocr_extract_disabled_title => 'ፎቶ የለም!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'የጽሑፍ ማውጣት ባህሪውን ለመጠቀም መጀመሪያ ፎቶ ማንሳት አለብዎት።';

  @override
  String get user_list_dialog_new_title => 'አዲስ የምርት ዝርዝር';

  @override
  String get user_list_dialog_rename_title => 'ዝርዝሩን እንደገና ይሰይሙ';

  @override
  String get user_list_subtitle_product => 'ዝርዝሮች';

  @override
  String get user_list_title => 'Your lists';

  @override
  String get user_list_add_product => 'ምርቱን ወደ ዝርዝሮችዎ ያክሉ';

  @override
  String get user_list_button_new => 'አዲስ ዝርዝር ይፍጠሩ';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'ወደ ዝርዝሩ ያክሉ';

  @override
  String get added_to_list_msg => 'ወደ ዝርዝሩ ታክሏል';

  @override
  String get user_list_popup_clear => 'ታሪክዎን ያጽዱ';

  @override
  String get user_list_popup_rename => 'እንደገና ሰይም';

  @override
  String get user_list_name_hint => 'የእኔ ዝርዝር';

  @override
  String get user_list_name_error_empty => 'ስም ግዴታ ነው';

  @override
  String get user_list_name_error_already => 'ያ ስም አስቀድሞ ጥቅም ላይ ውሏል';

  @override
  String get user_list_name_error_same => 'ያ ስም ተመሳሳይ ነው';

  @override
  String get user_list_name_input_hint => 'የዝርዝሩ ስም';

  @override
  String get try_again => 'እንደገና ይሞክሩ';

  @override
  String get there_was_an_error => 'ስህተት ነበር';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'ለ $itemsምንም ምድብ አልተገኘም';
  }

  @override
  String get camera_toggle_camera => 'በጀርባ እና በፊት ካሜራ መካከል ይቀያይሩ';

  @override
  String get camera_toggle_flash => 'የካሜራውን ብልጭታ ያብሩ ወይም ያጥፉ';

  @override
  String get camera_enable_flash => 'ፍላሽ አንቃ';

  @override
  String get camera_disable_flash => 'ፍላሽን አሰናክል';

  @override
  String get camera_flash_error_dialog_title => 'ስህተት ተከስቷል!';

  @override
  String get camera_flash_error_dialog_message =>
      'የፍላሽዎን ሁኔታ በመቀየር ላይ ስህተት ተከስቷል። እባክዎ ስማርት ስልክዎ ችቦው አስቀድሞ እንዳልነቃ ያረጋግጡ።';

  @override
  String get category_picker_no_category_found_button => 'ተመለስ';

  @override
  String get user_preferences_item_accessibility_hint =>
      'በአሳሽዎ ወይም በመተግበሪያው ውስጥ ለመክፈት ጠቅ ያድርጉ (ከተጫነ)';

  @override
  String get dev_preferences_screen_title => 'የDEV ሁነታ';

  @override
  String get dev_preferences_screen_subtitle =>
      'የሙከራ ባህሪያትን እና የልማት መሳሪያዎችን ይድረሱ';

  @override
  String get dev_preferences_reset_onboarding_title => 'ማዋሃድን እንደገና ያስጀምሩ';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'ከዚያ መተግበሪያውን እንደገና ለማየት እንደገና ማስጀመር አለብዎት።';

  @override
  String get dev_preferences_environment_switch_title =>
      'በ openfoodfacts.org (PROD) እና በሙከራ env መካከል ይቀያይሩ';

  @override
  String get dev_preferences_test_environment_title => 'የሙከራ አካባቢ መለኪያዎች';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'የአሁኑ የሙከራ ኢንቭ መሰረታዊ ዩአርኤል፦ $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'የሙከራ አካባቢ አስተናጋጅ';

  @override
  String get dev_preferences_ml_kit_title => 'የኤምኤል ኪትን ይጠቀሙ';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'ከዚያ ይህንን መተግበሪያ እንደገና ማስጀመር አለብዎት';

  @override
  String get dev_preferences_product_additional_features_title =>
      'በምርት ገጽ ላይ ተጨማሪ አዝራር';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'ግብዓቶችን በእውቀት ፓነል አዝራር ያርትዑ';

  @override
  String get dev_preferences_export_history_title => 'የውጪ ታሪክ';

  @override
  String get dev_preferences_export_history_progress_error => 'ልዩ ሁኔታ';

  @override
  String get dev_preferences_export_history_progress_found => 'ምርት ተገኝቷል';

  @override
  String get dev_preferences_export_history_progress_not_found => 'ምርት አልተገኘም';

  @override
  String get dev_preferences_export_history_dialog_title => 'የውጪ ታሪክ';

  @override
  String get dev_preferences_button_positive => 'እሺ';

  @override
  String get dev_preferences_button_negative => 'Cancel';

  @override
  String get dev_preferences_migration_title => 'የውሂብ ዝውውር ከV1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'ሁኔታ፡ $status';
  }

  @override
  String get dev_preferences_migration_status_already_done => 'ስኬት ወይም አዲስ ጭነት';

  @override
  String get dev_preferences_migration_status_success => 'ስኬት';

  @override
  String get dev_preferences_migration_status_error => 'ስህተት';

  @override
  String get dev_preferences_migration_status_in_progress => 'በሂደት ላይ';

  @override
  String get dev_preferences_migration_status_required =>
      'ያስፈልጋል (ለመጀመር ጠቅ ያድርጉ)';

  @override
  String get dev_preferences_migration_status_not_started => 'ያልታወቀ';

  @override
  String get dev_preferences_import_history_subtitle =>
      'ታሪክን ያጸዳል እና 3 ምርቶችን እዚያ ውስጥ ያስቀምጣል';

  @override
  String get dev_preferences_news_custom_url_title => 'ለዜና ብጁ ዩአርኤል';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'የJSON ፋይል ዩአርኤል፦';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'አልተዘጋጀም';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'የመጨረሻ እድሳት፦ $date';
  }

  @override
  String get product_type_label_food => 'ምግብ';

  @override
  String get product_type_label_beauty => 'የግል እንክብካቤ';

  @override
  String get product_type_label_pet_food => 'የቤት እንስሳት ምግብ';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'የምርት አይነት';

  @override
  String get product_type_selection_subtitle => 'የዚህን ምርት አይነት ይምረጡ';

  @override
  String get product_type_selection_empty => 'መጀመሪያ የምርት አይነት መምረጥ ያስፈልግዎታል!';

  @override
  String product_type_selection_already(String productType) {
    return 'የምርት አይነትን መቀየር አይችሉም ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag => 'በምርት ገጽ ላይ የዋጋዎች አቋራጭ መተግበሪያ';

  @override
  String get prices_app_button => 'ወደ የዋጋዎች መተግበሪያ ይሂዱ';

  @override
  String get prices_website_button => 'በክፍት ዋጋዎች ድህረ ገጽ ላይ ክፈት';

  @override
  String get prices_bulk_proof_upload_select =>
      'የዋጋ መለያዎችን በቀጥታ ከማዕከለ-ስዕላት ያክሉ';

  @override
  String get prices_bulk_proof_upload_warning =>
      'ምስሎችን አንዴ ከመረጡ በኋላ፣ እነሱን ማርትዕ አይችሉም!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'ማህበረሰቡ በ AI የወጡትን ዋጋዎች እንዲያረጋግጥ ይፍቀዱለት።';

  @override
  String get prices_bulk_proof_upload_subtitle => 'በርካታ የዋጋ መለያዎች';

  @override
  String get prices_bulk_proof_upload_title => 'የጅምላ ማረጋገጫ ጭነት';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'ፋይሎችን መምረጥ';

  @override
  String get prices_bulk_proof_upload_step_starting => 'ሰቀላውን በመጀመር ላይ';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'በአገር ውስጥ ፋይል #$index/$countበመቅዳት ላይ';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'ሰቀላን በማዘጋጀት ላይ #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'ምስሉ ላይ አልተሳካም #$index/$count';
  }

  @override
  String get prices_generic_title => 'ዋጋዎች';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ያክሉ $count ዋጋዎች',
      one: 'ዋጋ ያክሉ',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ላክ $count ዋጋዎች',
      one: 'ዋጋውን ላክ',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'አንድ ንጥል ያክሉ';

  @override
  String get prices_add_a_price => 'ዋጋ ያክሉ';

  @override
  String get prices_add_a_receipt => 'ደረሰኝ ያክሉ';

  @override
  String get prices_add_price_tags => 'የዋጋ መለያዎችን ያክሉ';

  @override
  String prices_barcode_already(String barcode) {
    return 'ይህ ባርኮድ ($barcode) አስቀድሞ በዝርዝሩ ውስጥ አለ!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'እስካሁን ምንም ምርት የለም';

  @override
  String prices_barcode_search_running(String barcode) {
    return '$barcodeን እየፈለግኩ ነው';
  }

  @override
  String get prices_barcode_enter => 'የባርኮዱን ያስገቡ';

  @override
  String get prices_category_enter => 'ያለ ባርኮድ እቃ';

  @override
  String get prices_per_kilogram => 'ዋጋ በኪሎግራም';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / ኪ.ግ';

  @override
  String get prices_per_unit_short => ' / አሃድ';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'አማራጭ';

  @override
  String get prices_category_error_mandatory => 'ምድቡ የግዴታ ነው';

  @override
  String get prices_barcode_reader_action => 'የባርኮድ አንባቢ';

  @override
  String get prices_view_prices => 'ዋጋዎችን ይመልከቱ';

  @override
  String get prices_list_title => 'የዋጋ ዝርዝር';

  @override
  String get prices_list_count => 'የ\nዋጋዎች';

  @override
  String get prices_list_add_new_price => '\nአዲስ ዋጋ ይጨምሩ';

  @override
  String get prices_list_empty_title => 'እስካሁን ምንም ዋጋ የለም!';

  @override
  String get prices_list_empty_subtitle =>
      'አንድ ለመጨመር የመጀመሪያው ይሁኑ፡\n**ደረሰኝ** ወይም **የዋጋ መለያ** በመቃኘት!';

  @override
  String get prices_entry_shop_not_found => 'ያልታወቀ መደብር';

  @override
  String prices_entry_menu_title(String user) {
    return 'የዋጋ ግቤት ከ\"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'የዚህን ምርት ሁሉንም ዋጋዎች ይመልከቱ';

  @override
  String get prices_entry_menu_open_proof => 'ማስረጃ ይመልከቱ';

  @override
  String get prices_entry_menu_my_prices => 'የእኔን ሌሎች ዋጋ ይመልከቱ';

  @override
  String get prices_entry_menu_author_prices => 'ሌሎች ዋጋዎችን በጸሐፊው ይመልከቱ';

  @override
  String get prices_entry_menu_shop_prices => 'ከሱቁ ሌሎች ዋጋዎችን ይመልከቱ';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ዋጋዎች',
      one: '1 ዋጋ',
    );
    return '$_temp0 ለ $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ሁሉም $count ዋጋዎች',
      one: 'አንድ ዋጋ ብቻ',
      zero: 'እስካሁን ምንም ዋጋ የለም',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'የቅርብ ጊዜ $pageSize ዋጋዎች (ጠቅላላ፡ $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'ዋጋ፡ $price / መደብር፡ \"$location\" / በ $date በ\"$user\" ላይ ታትሟል';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'የ\"$user\" ግልጽ ማስረጃዎች';
  }

  @override
  String get prices_open_proof => 'ክፍት የዋጋ ማረጋገጫ';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ሁሉም $count ማስረጃዎች',
      one: 'አንድ ማረጋገጫ ብቻ',
      zero: 'እስካሁን ምንም ማረጋገጫ የለም',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'የቅርብ ጊዜ $pageSize ማስረጃዎች (ጠቅላላ፡ $total)';
  }

  @override
  String get prices_users_empty_title => 'እስካሁን ምንም አስተዋጽዖ የለም!';

  @override
  String get prices_users_empty_explanation => 'ዋጋ ለመጨመር የመጀመሪያው ይሁኑ!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'ከፍተኛ $pageSize አስተዋጽዖ አበርካቾች (ጠቅላላ፡ $total)';
  }

  @override
  String get prices_locations_empty_title => 'እስካሁን ምንም ሱቅ የለም!';

  @override
  String get prices_locations_empty_explanation => 'ዋጋ ለመጨመር የመጀመሪያው ይሁኑ!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'ከፍተኛ $pageSize አካባቢዎች (ጠቅላላ፡ $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ማስረጃዎች',
      one: 'አንድ ማረጋገጫ',
      zero: 'ምንም ማረጋገጫ የለም',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ምርቶች',
      one: 'አንድ ምርት',
      zero: 'ምርት የለም',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ተጠቃሚዎች',
      one: 'አንድ ተጠቃሚ',
      zero: 'ተጠቃሚ የለም',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ዋጋዎች',
      one: 'አንድ ዋጋ',
      zero: 'ዋጋ የለውም',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'ዋጋ ከዚህ ቀደም ታክሏል።';

  @override
  String get prices_amount_subtitle => 'መጠን';

  @override
  String get prices_amount_is_discounted => 'ቅናሽ አለው?';

  @override
  String get prices_amount_price_normal => 'ዋጋ';

  @override
  String get prices_amount_price_discounted => 'ቅናሽ የተደረገበት ዋጋ';

  @override
  String get prices_amount_price_not_discounted => 'የመጀመሪያው ዋጋ';

  @override
  String get prices_amount_no_product => 'አንድ ምርት ጠፍቷል!';

  @override
  String get prices_amount_price_incorrect => 'የተሳሳተ እሴት';

  @override
  String get prices_amount_price_mandatory => 'የግዴታ እሴት';

  @override
  String get prices_currency_subtitle => 'ምንዛሬ';

  @override
  String get prices_date_subtitle => 'ቀን';

  @override
  String get prices_location_subtitle => 'ሱቅ';

  @override
  String get prices_location_find => 'ሱቅ ያግኙ';

  @override
  String get prices_location_mandatory => 'ሱቅ መምረጥ አለብህ!';

  @override
  String get prices_location_search_broader =>
      'የሚፈልጉትን ማግኘት አልቻሉም? ሰፋ ያለ ፍለጋ እንሞክር!';

  @override
  String get prices_proof_subtitle => 'ማረጋገጫ';

  @override
  String get prices_proof_empty_title => 'እስካሁን ምንም ማረጋገጫ የለም!';

  @override
  String get prices_proof_empty_explanation =>
      '**ደረሰኝ** ወይም **የዋጋ መለያ** ፎቶ በማከል ይጀምሩ!';

  @override
  String get prices_proof_find => 'ማስረጃ ይምረጡ';

  @override
  String get prices_proof_change => 'የለውጥ ማረጋገጫ';

  @override
  String get prices_proof_receipt => 'ደረሰኝ';

  @override
  String get prices_proof_price_tag => 'የዋጋ መለያ';

  @override
  String get prices_proof_mandatory => 'ማስረጃ መምረጥ ያስፈልግዎታል!';

  @override
  String get prices_add_validation_error => 'የማረጋገጫ ስህተት';

  @override
  String get prices_privacy_warning_title => 'የግላዊነት ማስጠንቀቂያ';

  @override
  String get prices_unknown_product => 'ያልታወቀ ምርት';

  @override
  String get prices_privacy_warning_main_message =>
      'ዋጋዎች **ለሕዝብ ይፋ ይሆናሉ**፣ ከሚያመለክቱበት መደብር ጋር።\n\nይህ ስለ ክፍት የምግብ እውነታዎች ቅጽል ስምዎ የሚያውቁ ሰዎች የሚከተሉትን እንዲያደርጉ ያስችላቸዋል፦\n';

  @override
  String get prices_privacy_warning_message_bullet_1 => 'በየትኛው አካባቢ እንደሚኖሩ ገምቱ';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'ምን እየገዙ እንደሆነ ይወቁ';

  @override
  String get prices_privacy_warning_sub_message =>
      'በዚህ ካልተደሰቱ፣ እባክዎን የውሸት ስምዎን ይቀይሩ ወይም አዲስ የክፍት ምግብ እውነታዎች መለያ ይፍጠሩ እና በእሱ ወደ መተግበሪያው ይግቡ።';

  @override
  String get i_refuse => 'እምቢ እላለሁ';

  @override
  String get i_accept => 'እቀበላለሁ';

  @override
  String get prices_currency_change_proposal_title => 'ምንዛሬውን ይለውጣሉ?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'የአሁኑ ምንዛሬዎ **$currency** ነው። ወደ **$newCurrencyሊቀይሩት ይፈልጋሉ **?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'አዎ፣ $newCurrencyን ይጠቀሙ';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'አይ፣ አስቀምጥ $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'ተጠናቅቋል';

  @override
  String get dev_mode_section_server => 'የአገልጋይ ውቅር';

  @override
  String get dev_mode_section_news => 'የዜና አቅራቢ ውቅር';

  @override
  String get dev_mode_section_product_page => 'የምርት ገጽ';

  @override
  String get dev_mode_section_ui => 'የተጠቃሚ በይነገጽ';

  @override
  String get dev_mode_section_experimental_features => 'የሙከራ ባህሪያት';

  @override
  String get dev_mode_hide_environmental_score_title => 'አረንጓዴ ነጥብ አታካትት';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'ለኦሲአር ማያ ገጾች የፊደል አራሚ ይጠቀሙ';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(ግብዓቶች እና ማሸጊያዎች)';

  @override
  String get dev_mode_reset_app_language_title => 'የመተግበሪያ ቋንቋን ዳግም ያስጀምሩ';

  @override
  String get dev_mode_add_demo_cards_language_title => 'ካርዶችን ያክሉ';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'prices.openfoodfacts.org (PROD) እና test env መካከል ይቀያይሩ';

  @override
  String get search_history_item_edit_tooltip =>
      'ይህንን ፍለጋ እንደገና ይጠቀሙበት እና ያርትዑ';

  @override
  String get search_history_item_remove_tooltip => 'አስወግድ';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'ሁሉንም $totalSize ምርቶች አውርደዋል።';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return '$count ተጨማሪ ምርቶችን ያውርዱ\nአስቀድመው ወርደዋል $downloaded ከ $totalSize።';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'የ $search ፍለጋዎ በሂደት ላይ ነው።\n\nእባክዎ ጥቂት ሰከንዶች ይጠብቁ…';
  }

  @override
  String get user_search_contributor_title => 'የጨመርኳቸው ምርቶች';

  @override
  String get user_search_informer_title => 'አርትዕ ያደረግኳቸው ምርቶች';

  @override
  String get user_search_photographer_title => 'ፎቶግራፍ ያነሳኋቸው ምርቶች';

  @override
  String get user_search_to_be_completed_title => 'የሚጠናቀቁልኝ ምርቶቼ';

  @override
  String get user_search_prices_title => 'የእኔ ዋጋዎች';

  @override
  String get user_search_proofs_title => 'ማስረጃዎቼ';

  @override
  String get user_search_proof_title => 'የእኔ ማስረጃ';

  @override
  String search_proof_title(String user) {
    return 'ከ \"$user\" የተገኘ ማስረጃ';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'የአስተዋጽዖ ዋጋ፡ $user';
  }

  @override
  String get all_search_prices_latest_title => 'የቅርብ ጊዜ ዋጋዎች ታክለዋል';

  @override
  String get all_search_prices_top_user_title => 'ከፍተኛ የዋጋ አስተዋጽዖ አበርካቾች';

  @override
  String get all_search_prices_top_location_title => 'ከፍተኛ ዋጋ ያላቸው መደብሮች';

  @override
  String get prices_contribution_assistant => 'የዋጋ አስተዋጽዖ ረዳት';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'በርካታ ማረጋገጫዎችን ያክሉ';

  @override
  String get all_search_prices_top_location_single_title => 'ዋጋዎች በሱቅ ውስጥ';

  @override
  String get all_search_prices_top_product_title => 'ከፍተኛ ዋጋ ያላቸው ምርቶች';

  @override
  String get all_search_to_be_completed_title => 'ሁሉም የሚጠናቀቁ ምርቶች';

  @override
  String get categorize_products_country_title => 'በአገርዎ ውስጥ ምርቶችን ለመመደብ ያግዙ';

  @override
  String get edit_product_action_retake_picture => 'ፎቶ እንደገና አንሳ';

  @override
  String get edit_product_action_take_picture => 'ፎቶ አንሳ';

  @override
  String get edit_product_action_confirm => 'አረጋግጥ';

  @override
  String get signup_page_terms_of_use_line1 => 'በክፍት የምግብ እውነታዎች እስማማለሁ ';

  @override
  String get signup_page_terms_of_use_line2 => 'የአጠቃቀም ውሎች እና መዋጮዎች';

  @override
  String get analytics_consent_image_semantic_label => 'የትንታኔ አዶ';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'ገዳይ ስህተት፦ $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'ገዳይ ስህተት፦ $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'መሰረታዊ ዝርዝሮችን ይሙሉ';

  @override
  String get edit_photo_button_label => 'Edit';

  @override
  String get edit_photo_unselect_button_label => 'ፎቶን አትምረጥ';

  @override
  String get edit_photo_select_existing_button_label => 'አሁን ያለ ምስል ይምረጡ';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle => 'ምስሉን ጠቅ በማድረግ ይምረጡ';

  @override
  String get edit_photo_select_existing_download_label =>
      'ነባር ምስሎችን ሰርስሮ ማውጣት…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'ከዚህ ምርት ጋር የተያያዙ ቀደም ሲል የተሰቀሉ ምስሎች የሉም።';

  @override
  String get edit_photo_language_not_this_one => 'በዚያ ቋንቋ እስካሁን ምንም ምስል የለም';

  @override
  String get edit_photo_language_none => 'እስካሁን ምንም ምስል የለም';

  @override
  String get category_picker_screen_title => 'Categories';

  @override
  String get basic_details => 'መሰረታዊ ዝርዝሮች';

  @override
  String get product_name => 'የምርት ስም';

  @override
  String get product_names => 'የምርት ስሞች';

  @override
  String get add_basic_details_product_name_add_translation => 'አዲስ ትርጉም ያክሉ';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'ከማረጋገጥዎ በፊት፣ እባክዎ በማሸጊያው ላይ ያለው ቋንቋ ካለ ብቻ ትርጉም ማከልዎን ያረጋግጡ**';

  @override
  String get add_basic_details_product_name_open_photo => 'የፊት ፎቶውን ይመልከቱ';

  @override
  String get add_basic_details_product_name_take_photo => 'የፊት ፎቶ አንሳ';

  @override
  String get add_basic_details_product_name_hint =>
      'የምርት ስም ያስገቡ (ለምሳሌ፡ Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'ነባሪ ቋንቋ ይቀየር?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'የምርቱ ነባሪ ቋንቋ ወደ \'$language\' እንዲዋቀር ይፈልጋሉ?';
  }

  @override
  String get explanation_section_good_examples => 'ጥሩ ምሳሌዎች';

  @override
  String get explanation_section_bad_examples => 'መጥፎ ምሳሌዎች';

  @override
  String get add_basic_details_product_name_help_title => 'ጥሩ ልምዶች፡ የምርት ስም';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'የምርት ስሙ በማሸጊያው ላይ የታተመው **ዋና ስም** ነው። የተመዘገበ የንግድ ምልክት ሊሆን ይችላል።';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**ማሳሰቢያ፡** ቋንቋው በማሸጊያው ላይ ከሌለ እባክዎን ትርጉም አያክሉ**።';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'ኔስኩዊክ';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'የቲማቲም ኬትጪፕ';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'የምርት ስሙን በስሙ ውስጥ አያካትቱ';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'ቲማቲም ኬትጪፕ **በሄንዝ**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'ምልክቶችን ®፣ ™፣ © ወይም ተመሳሳይ አይጠቀሙ';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'ኔስኩዊክ**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ሌሎች ትርጉሞች',
      one: '$count ሌላ ትርጉም',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'የምርት ስም';

  @override
  String get brand_names => 'የምርት ስሞች';

  @override
  String get add_basic_details_brand_name_error => 'የምርት ስሙን እባክዎ ያስገቡ';

  @override
  String get add_basic_details_brand_names_hint => 'የግብዓት ብራንዶች (ለምሳሌ፡ ፌሬሮ)';

  @override
  String get add_basic_details_product_brand_help_title => 'ጥሩ ልምዶች፡ ብራንዶች';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'ያስገቡ **የምርቱ ሁሉንም የምርት ስሞች**።';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'ዋና የምርት ስም';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'ዋናው የምርት ስም**፣ በአጠቃላይ በፊት ፓኬጁ ላይ በግልጽ የሚታየው፣ **መጀመሪያ መግባት** አለበት።';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'ሌሎች የምርት ስሞች';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'በአንድ ትልቅ ኩባንያ ሲሸጥ **';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**አክቲሜል** የሚሸጠው በ **ዳንኖን** ነው*';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'ከብራንዱ ጋር ሲሸጥ **በብዙ ቋንቋዎች የተተረጎመ**፦';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**የተፈጥሮ ቫሊ** አንዳንድ ጊዜ የሚጻፈው **የተፈጥሮ ቫሊ**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'ኑቴላ';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'ኦሬኦ፣ ሞንዴሌዝ';

  @override
  String get quantity => 'ብዛት እና ክብደት';

  @override
  String get add_basic_details_quantity_hint =>
      'ክብደቱን እና አስፈላጊ ከሆነ ብዛቱን ያስገቡ (ለምሳሌ፡ 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title => 'ጥሩ ልምዶች፡ ብዛት';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'በምርቱ ላይ የተጠቀሰውን እሴት ይቅዱ እና **አሃዶችን አይርሱ**።';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 ግራም** ወይም **230 ግራም**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (ለ6 እንቁላሎች)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 ግራም**\n(እያንዳንዳቸው 150 ግራም 3 ሳጥኖች ላሏቸው ምርቶች)';

  @override
  String get barcode => 'Barcode';

  @override
  String barcode_barcode(String barcode) {
    return 'ባርኮድ፡ $barcode';
  }

  @override
  String get barcode_invalid_error => 'ልክ ያልሆነ ባርኮድ';

  @override
  String get basic_details_add_success => 'መሰረታዊ ዝርዝሮች በተሳካ ሁኔታ ታክለዋል';

  @override
  String get basic_details_add_error =>
      'መሰረታዊ ዝርዝሮችን ማከል አልተቻለም። እባክዎ ከተወሰነ ጊዜ በኋላ እንደገና ይሞክሩ።';

  @override
  String get clear_search => 'ፍለጋዎን ያጽዱ';

  @override
  String get confirm_clear => 'ታሪክህን በሙሉ ልታጸዳው ነው፡ እርግጠኛ ነህ መቀጠል ትፈልጋለህ?';

  @override
  String get alert_clear_selected_user_list => 'በታሪክዎ ውስጥ የተመረጡትን ንጥሎች ሊያጸዱ ነው';

  @override
  String get confirm_clear_selected_user_list => 'እርግጠኛ ነዎት መቀጠል ይፈልጋሉ?';

  @override
  String get alert_select_items_to_clear =>
      'ለማጽዳት እባክዎ አንድ ወይም ከዚያ በላይ እቃዎችን ይምረጡ';

  @override
  String confirm_clear_user_list(String name) {
    return 'ይህንን ዝርዝር ሊያጸዱ ነው ($name): መቀጠል እንደሚፈልጉ እርግጠኛ ነዎት?';
  }

  @override
  String get confirm_delete_user_list_title => 'ዝርዝሩን ሰርዝ?';

  @override
  String confirm_delete_user_list_message(String name) {
    return '\"$name\"ዝርዝሩን ልትሰርዝ ነው።\nመቀጠል እንደምትፈልግ እርግጠኛ ነህ?';
  }

  @override
  String get confirm_delete_user_list_button => 'አዎ፣ አረጋግጣለሁ';

  @override
  String importance_label(String name, String id) {
    return '$name አስፈላጊነት፡ $id';
  }

  @override
  String get user_list_all_title => 'ዝርዝሮች';

  @override
  String get user_list_all_empty => 'የመጀመሪያ ዝርዝርዎን ይፍጠሩ';

  @override
  String get product_list_select => 'ዝርዝር ይምረጡ';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ምርቶች',
      one: 'አንድ ምርት',
      zero: 'ባዶ ዝርዝር',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'ዝርዝር ያክሉ';

  @override
  String get open_food_preferences_tooltip => 'የምግብ ምርጫዎችዎን ያርትዑ';

  @override
  String get add_photo_button_label => 'ፎቶ ያክሉ';

  @override
  String get add_packaging_photo_button_label =>
      'የማሸጊያ/የድጋሚ ጥቅም ላይ የዋለ ማንኛውንም መረጃ ፎቶግራፍ ያንሱ';

  @override
  String get add_origin_photo_button_label => 'የማንኛውንም የመነሻ መረጃ ፎቶዎች ያንሱ';

  @override
  String get add_emb_photo_button_label => 'የማንኛውንም የመከታተያ ኮድ መረጃ ፎቶዎች ያንሱ';

  @override
  String get add_label_photo_button_label =>
      'የማንኛውንም መለያዎች እና የምስክር ወረቀቶች መረጃ ፎቶዎችን ያንሱ';

  @override
  String get choose_image_source_title => 'የምስል ምንጭ ይምረጡ';

  @override
  String get choose_image_source_body => 'እባክዎ የምስል ምንጭ ይምረጡ';

  @override
  String get gallery_source_label => 'ጋለሪ';

  @override
  String get gallery_source_access_denied_dialog_title => 'መዳረሻ ተከልክሏል';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'እንደ አለመታደል ሆኖ፣ ቀደም ሲል ፈቃዱን ስለከለከሉ መተግበሪያው ወደ ጋለሪዎ መድረስ አይችልም።\n\nእባክዎ በስልክዎ ቅንብሮች ውስጥ ወዳለው የመተግበሪያ ቅንብሮች ይሂዱ -> ፎቶዎች';

  @override
  String get gallery_source_access_denied_dialog_button => 'ቅንብሮችን ይክፈቱ';

  @override
  String get share => 'አጋራ';

  @override
  String share_product_text(String url) {
    return 'ይህንን ምርት በክፍት የምግብ እውነታዎች ላይ ይመልከቱ፡ $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'ይህንን ምርት በክፍት የውበት እውነታዎች ላይ ይመልከቱ፡ $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'ይህንን ምርት በክፍት የቤት እንስሳት ምግብ እውነታዎች ላይ ይመልከቱ፦ $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'ይህንን ምርት በክፍት ምርቶች እውነታዎች ላይ ይመልከቱ፦ $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'በክፍት የምግብ እውነታዎች ላይ የምርቶቼን ዝርዝር ይመልከቱ፡ $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Take a picture';

  @override
  String get choose_from_gallery => 'ከማዕከለ-ስዕላት ይምረጡ';

  @override
  String get image_upload_queued => 'ምስሉ በተቻለ ፍጥነት ከበስተጀርባ ይሰቀላል።';

  @override
  String get add_price_queued => 'ዋጋው በተቻለ ፍጥነት ወደ አገልጋዩ ይላካል።';

  @override
  String get background_task_title_full_refresh =>
      'በአካባቢው የተከማቹትን ምርቶች በሙሉ ማደስ መጀመር';

  @override
  String get background_task_title_folksonomy =>
      'በአገር ውስጥ ለተከማቹ የ folksonomy ዝመናዎች የአገልጋይ እርምጃዎችን ማከናወን በመጀመር ላይ';

  @override
  String get background_task_title_top_n => 'በጣም ተወዳጅ ምርቶችን ማውረድ መጀመር';

  @override
  String get expand_nutrition_facts => 'የአመጋገብ እውነታዎችን ሰንጠረዥ ዘርጋ';

  @override
  String get expand_nutrition_facts_body => 'የአመጋገብ እውነታዎችን ሰንጠረዥ ማስፋትዎን ይቀጥሉ';

  @override
  String get expand_ingredients => 'ንጥረ ነገሮችን ዘርጋ';

  @override
  String get expand_ingredients_body => 'የንጥረ ነገሮች ፓነል እንዲሰፋ ያድርጉት';

  @override
  String get no_internet_connection => 'የኢንተርኔት ግንኙነት የለም';

  @override
  String get world_results_label => 'መላው ዓለም';

  @override
  String get world_results_action => 'ፍለጋዎን ወደ ዓለም ያስፋፉ';

  @override
  String get copy_to_clipboard => 'ቅጂ';

  @override
  String get paste_from_clipboard => 'ከቅንጥብ ሰሌዳ ይለጥፉ';

  @override
  String get no_data_available_in_clipboard => 'በቅንጥብ ሰሌዳዎ ውስጥ ምንም ውሂብ አይገኝም';

  @override
  String get clipboard_barcode_copy => 'ባርኮዱን ወደ ቅንጥብ ሰሌዳው ይቅዱ';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'ባርኮድ $barcode ወደ ቅንጥብ ሰሌዳው ተገልብጧል!';
  }

  @override
  String get open_product_website => 'ይህንን ምርት በድር ጣቢያው ላይ ይክፈቱ';

  @override
  String get language_picker_label => 'የእርስዎ ቋንቋ';

  @override
  String get country_picker_label => 'ሀገርህ';

  @override
  String get currency_picker_label => 'የእርስዎ ምንዛሬ';

  @override
  String get help_with_openfoodfacts => 'በኦፕንፉድፋክስ ላይ እገዛ';

  @override
  String get product_task_background_schedule => 'ምርቱ በተቻለ ፍጥነት ከበስተጀርባ ይዘምናል።';

  @override
  String get no_email_client_available_dialog_title => 'የኢሜይል መተግበሪያዎች የሉም!';

  @override
  String get no_email_client_available_dialog_content =>
      'እባክዎን በእጅ ኢሜይል ወደ mobile@openfoodfacts.org ይላኩልን።';

  @override
  String get all_images => 'ሁሉም ምስሎች';

  @override
  String get selected_images => 'የተመረጡ ምስሎች';

  @override
  String get product_card_remove_product_tooltip => 'ምርትን ያስወግዱ';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'አዲስ የባርኮድ ስካነር፦ $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip => 'ሁሉንም ምርቶች ከካሮሴል ውስጥ ያስወግዱ';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'እባክዎ ቢያንስ ሁለት ምርቶችን ለማነፃፀር ይቃኙ';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'የተቃኙዋቸውን ምርቶች ለማነፃፀር ጠቅ ያድርጉ';

  @override
  String get scan_product_loading => 'የ\nባርኮዱን ቃኝተሃል፦';

  @override
  String get scan_product_loading_initial =>
      'ይህንን ምርት እየፈለግን ነው!\nእባክዎ ለጥቂት ሰከንዶች ይጠብቁ…';

  @override
  String get scan_product_loading_long_request =>
      'አሁንም ይህንን ምርት እየፈለግን ነው!\nለመጫን ረጅም ጊዜ እንደሚወስድ ይሰማዎታል? እኛም…';

  @override
  String get scan_product_loading_unresponsive =>
      'አሁንም ይህንን ምርት እየፈለግን ነው።\nፍለጋውን እንደገና ማስጀመር ይፈልጋሉ?';

  @override
  String get scan_product_loading_restart_button => 'ፍለጋን እንደገና ያስጀምሩ';

  @override
  String get portion_calculator_description => 'ለተወሰነ መጠን የአመጋገብ እውነታዎችን አስላ';

  @override
  String get portion_calculator_hint => 'ብዛት በ';

  @override
  String get portion_calculator_accessibility =>
      'የአመጋገብ እውነታዎችን ለማስላት ብዛት ያስገቡ';

  @override
  String portion_calculator_error(int min, int max) {
    return 'እባክዎ በ $min እና $max g መካከል ያለ መጠን ያስገቡ';
  }

  @override
  String get portion_calculator_computation_error =>
      'የጎደለ ውሂብ። ስሌት ሊከናወን አልቻለም።';

  @override
  String portion_calculator_result_title(int grams) {
    return 'የአመጋገብ እውነታዎች ለ $grams ግ (ወይም ሚሊ ሊትር)';
  }

  @override
  String get offline_data => 'ከመስመር ውጭ ውሂብ';

  @override
  String get ocr_image_upload_instruction =>
      'በውስጡ ያለውን መረጃ በራስ-ሰር ለማውጣት ምስል ይስቀሉ።';

  @override
  String get upload_image => 'ፎቶ ስቀል';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'ምስሉን ማውረድ አልተሳካም';

  @override
  String get image_edit_url_error => 'የምስሉ ዩአርኤል ስላልተዘጋጀ ምስሉን ማርትዕ አልተሳካም።';

  @override
  String get user_picture_source_remember => 'ምርጫዬን አስታውስ';

  @override
  String get user_picture_source_ask => 'በእያንዳንዱ ጊዜ ጠይቅ';

  @override
  String get robotoff_continue => 'ቀጥል';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ጥያቄዎች',
      one: 'ጥያቄ',
    );
    return 'ቀጣይ $_temp0';
  }

  @override
  String get show_password => 'የይለፍ ቃል አሳይ';

  @override
  String get owner_field_info_title => 'አዘጋጅ የሰጡት እሴቶች';

  @override
  String get owner_field_info_message =>
      'በዚያ አርማ በአምራቹ የቀረበውን መረጃ እናደምቃለን፤ ይህም ሊስተካከል የማይችል ሊሆን ይችላል።';

  @override
  String get owner_field_info_close_button => 'ይህንን መረጃ ዝጋ';

  @override
  String get owner_field_image =>
      'ይህ ምስል የቀረበው በአምራቹ ነው። ሊስተካከል የማይችል ሊሆን ይችላል።';

  @override
  String get edit_packagings_title => 'የማሸጊያ ክፍሎች';

  @override
  String get edit_packagings_element_add => 'የማሸጊያ ክፍል ያክሉ';

  @override
  String get edit_packagings_completed => 'ማሸጊያው ተጠናቅቋል';

  @override
  String edit_packagings_element_title(int index) {
    return 'የማሸጊያ ክፍል #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'የአሃዶች ብዛት';

  @override
  String get edit_packagings_element_hint_units =>
      'በምርቱ ውስጥ የተካተቱትን ተመሳሳይ ቅርፅ እና ቁሳቁስ ያላቸውን የማሸጊያ ክፍሎች ብዛት ያስገቡ።';

  @override
  String get edit_packagings_element_field_shape => 'ቅርጽ';

  @override
  String get edit_packagings_element_hint_shape =>
      'በሪሳይክል አጠቃቀም መመሪያው ውስጥ የተዘረዘሩትን የቅርጽ ስም ያስገቡ ወይም ቅርፅ ይምረጡ።';

  @override
  String get edit_packagings_element_example_shape => 'ጠርሙስ';

  @override
  String get edit_packagings_element_field_material => 'ቁሳቁስ';

  @override
  String get edit_packagings_element_hint_material =>
      'የተወሰነውን ቁሳቁስ መለየት ከተቻለ (በሶስት ማዕዘን ውስጥ ያለ የቁሳቁስ ኮድ ብዙውን ጊዜ በማሸጊያ ክፍሎች ላይ ሊገኝ ይችላል) ወይም እርግጠኛ ካልሆኑ አጠቃላይ ቁሳቁስ (ለምሳሌ ፕላስቲክ ወይም ብረት) ያስገቡ።';

  @override
  String get edit_packagings_element_example_material => 'ብርጭቆ';

  @override
  String get edit_packagings_element_field_recycling => 'የመልሶ ጥቅም ላይ የማዋል መመሪያ';

  @override
  String get edit_packagings_element_hint_recycling =>
      'በምርቱ ላይ ከተዘረዘሩ ብቻ የሪሳይክል አጠቃቀም መመሪያዎችን ያስገቡ።';

  @override
  String get edit_packagings_element_example_recycling => 'እንደገና ጥቅም ላይ ማዋል';

  @override
  String get edit_packagings_element_field_quantity => 'በአንድ አሃድ የተጣራ የምርት ብዛት';

  @override
  String get edit_packagings_element_hint_quantity =>
      'የተጣራ ክብደትን ወይም የተጣራ መጠን ያስገቡ እና መለኪያውን (ለምሳሌ ግ ወይም ሚሊ ሊትር) ያመልክቱ።';

  @override
  String get edit_packagings_element_field_weight => 'የአንድ ባዶ አሃድ ክብደት (ግ)';

  @override
  String get edit_packagings_element_hint_weight =>
      'የቀረውን ምግብ ያስወግዱና ከመመዘንዎ በፊት የማሸጊያውን ክፍል ያጠቡና ያድርቁ። ከተቻለ 0.1 ግራም ወይም 0.01 ግራም ትክክለኛነት ያለው ሚዛን ይጠቀሙ።';

  @override
  String get background_task_title => 'በመጠባበቅ ላይ ያሉ አስተዋጽዖዎች';

  @override
  String get background_task_subtitle =>
      'የእርስዎ አስተዋጽዖዎች በራስ-ሰር ወደ አገልጋያችን ይቀመጣሉ፣ ነገር ግን ሁልጊዜ በእውነተኛ ጊዜ ላይሆኑ ይችላሉ።';

  @override
  String get background_task_list_empty => 'ምንም በመጠባበቅ ላይ ያሉ የጀርባ ተግባራት የሉም';

  @override
  String get background_task_error_server_time_out => 'የአገልጋይ ጊዜ አልቋል';

  @override
  String get background_task_error_no_internet =>
      'የኢንተርኔት ግንኙነት ስህተት። በኋላ ይሞክሩ።';

  @override
  String get background_task_operation_unknown => 'የማይታወቅ የአሠራር አይነት';

  @override
  String get background_task_operation_details => 'ዝርዝር ለውጦች';

  @override
  String get background_task_operation_image => 'የፎቶ ሰቀላ';

  @override
  String get background_task_operation_refresh => 'ፎቶ ከተሰቀለ በኋላ ማደስ ዘግይቷል';

  @override
  String get background_task_run_started => 'ተጀምሯል';

  @override
  String get background_task_run_not_started => 'ገና አልተጀመረም';

  @override
  String get background_task_run_to_be_deleted => 'ሊሰረዝ ነው';

  @override
  String get background_task_question_stop => 'ያንን ተግባር በተቻለ ፍጥነት ማቆም ይፈልጋሉ?';

  @override
  String get feed_back => 'ግብረመልስ';

  @override
  String get undo => 'ቀልብስ';

  @override
  String get copy_email_to_clip_board => 'ኢሜይልን ወደ ቅንጥብ ሰሌዳ ቅዳ';

  @override
  String get please_send_us_an_email_to => 'እባክዎን በእጅ ኢሜይል ይላኩልን ወደ';

  @override
  String get email_copied_to_clip_board => 'ኢሜይል ወደ ቅንጥብ ሰሌዳ ተቀድቷል!';

  @override
  String get select_accent_color => 'የአክሰንት ቀለም ይምረጡ';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'ሰማያዊ';

  @override
  String get color_cyan => 'ሲያን';

  @override
  String get color_green => 'አረንጓዴ';

  @override
  String get color_light_brown => 'ነባሪ';

  @override
  String get color_magenta => 'ማጀንታ';

  @override
  String get color_orange => 'ብርቱካናማ';

  @override
  String get color_pink => 'ሮዝ';

  @override
  String get color_red => 'ቀይ';

  @override
  String get color_rust => 'ዝገት';

  @override
  String get color_teal => 'ቲል';

  @override
  String get text_contrast_mode => 'የጽሑፍ ንፅፅር';

  @override
  String get contrast_high => 'ከፍተኛ';

  @override
  String get contrast_medium => 'መካከለኛ';

  @override
  String get contrast_low => 'ዝቅተኛ';

  @override
  String get product_refresher_internet_not_found => 'ምርቱ አልተገኘም!';

  @override
  String get product_refresher_internet_not_connected => 'ከኢንተርኔት ጋር አልተገናኙም!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'አገልጋይ ጠፍቷል ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'የአገልጋይ ስህተት ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'ምርቱ አልተገኘም!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'የሚከተለው ባርኮድ ያለው ምርት በእኛ የውሂብ ጎታ ውስጥ የለም፦ $barcode';
  }

  @override
  String get product_loader_network_error_title => 'የኢንተርኔት ግንኙነት የለም!';

  @override
  String get product_loader_network_error_message =>
      'ስማርት ስልክዎ በዋይፋይ ኔትወርክ ላይ መሆኑን ወይም የሞባይል ዳታ መብራቱን ያረጋግጡ።';

  @override
  String get page_not_found_title => 'ገጹ አልተገኘም!';

  @override
  String get page_not_found_button => 'ወደ መነሻ ገጹ ይመለሱ';

  @override
  String get download_data => 'ውሂብ አውርድ';

  @override
  String get download_top_products =>
      'ለፈጣን ቅኝት በአገርዎ ውስጥ ያሉትን 1000 ምርጥ ምርቶችን ያውርዱ';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ምርቶች',
    );
    return 'ለፈጣን ቅኝት በአገርዎ ውስጥ ያሉትን ምርጥ $_temp0 ያውርዱ';
  }

  @override
  String get download_in_progress => 'ውሂብ በማውረድ ላይ\nይህ ጊዜ ሊወስድ ይችላል';

  @override
  String downloaded_products(int num) {
    return '$num ምርቶች ታክለዋል';
  }

  @override
  String get update_offline_data => 'የመስመር ውጪ የምርት ውሂብን አዘምን';

  @override
  String get update_local_database_sub =>
      'የአካባቢውን የምርት ዳታቤዝ ከ Open Food Facts የቅርብ ጊዜ መረጃ ጋር ያዘምኑ';

  @override
  String get clear_local_database => 'የመስመር ውጪ የምርት ውሂብን ያጽዱ';

  @override
  String get clear_local_database_sub =>
      'ቦታ ለማስለቀቅ ከመተግበሪያዎ ውስጥ ሁሉንም የአካባቢ ምርት ውሂብ ያጽዱ';

  @override
  String deleted_products(int num) {
    return '$num ምርቶች ተሰርዘዋል';
  }

  @override
  String get loading => 'Loading…';

  @override
  String get know_more => 'ተጨማሪ እወቅ';

  @override
  String get offline_data_desc => 'ስለ ከመስመር ውጭ ውሂብ የበለጠ ለማወቅ ጠቅ ያድርጉ';

  @override
  String get offline_product_data_title => 'የመስመር ውጪ የምርት ውሂብ';

  @override
  String available_for_download(int num) {
    return '$num ምርቶች ወዲያውኑ ለመቃኘት ይገኛሉ';
  }

  @override
  String get country_selector_title => 'አገርዎን ይምረጡ፦';

  @override
  String get currency_selector_title => 'ምንዛሬዎን ይምረጡ፦';

  @override
  String get language_selector_title => 'ቋንቋዎን ይምረጡ፦';

  @override
  String get language_selector_section_selected => 'የተመረጡ ቋንቋዎች';

  @override
  String get language_selector_section_frequently_used => 'በተደጋጋሚ ጥቅም ላይ የዋለ';

  @override
  String get action_delete_list => 'ሰርዝ';

  @override
  String get action_change_list => 'የአሁኑን ዝርዝር ይቀይሩ';

  @override
  String get product_list_create => 'ፍጠር';

  @override
  String get product_list_create_tooltip => 'አዲስ ዝርዝር ይፍጠሩ';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (አዲስ ስሌት)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (አዲስ ስሌት)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unknown Nutri-Score (New calculation)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score ተፈጻሚ አይሆንም';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score ተፈጻሚ አይሆንም (አዲስ ስሌት)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'አረንጓዴ-ውጤት ኤ';

  @override
  String get environmental_score_b_new => 'አረንጓዴ-ውጤት ቢ';

  @override
  String get environmental_score_c_new => 'አረንጓዴ-ውጤት ሲ';

  @override
  String get environmental_score_d_new => 'አረንጓዴ-ውጤት ዲ';

  @override
  String get environmental_score_e_new => 'አረንጓዴ-ውጤት ኢ';

  @override
  String get environmental_score_unknown_new => 'ያልታወቀ አረንጓዴ-ውጤት';

  @override
  String get environmental_score_not_applicable_new => 'አረንጓዴ-ውጤት ተፈጻሚ አይሆንም';

  @override
  String get nova_group_generic_new => 'እጅግ በጣም የተቀነባበሩ ምግቦች - NOVA ቡድኖች';

  @override
  String get nova_group_1 => 'NOVA Group 1';

  @override
  String get nova_group_2 => 'NOVA Group 2';

  @override
  String get nova_group_3 => 'NOVA Group 3';

  @override
  String get nova_group_4 => 'NOVA Group 4';

  @override
  String get nova_group_unknown => 'Unknown NOVA Group';

  @override
  String get nutrition_facts => 'የአመጋገብ ደረጃዎች';

  @override
  String get faq_title_partners => 'የመንግስታዊ ያልሆነ ድርጅት አጋሮች እና ደጋፊዎች';

  @override
  String get faq_title_vision => 'ክፍት የምግብ እውነታዎች ራዕይ፣ ተልዕኮ፣ እሴቶች እና ፕሮግራሞች';

  @override
  String get faq_title_install_beauty =>
      'የመዋቢያ ዳታቤዝ ለመፍጠር ክፍት የውበት እውነታዎችን ይጫኑ';

  @override
  String get faq_title_install_pet =>
      'የቤት እንስሳት ምግብ ዳታቤዝ ለመፍጠር ክፍት የቤት እንስሳት ምግብ እውነታዎችን ይጫኑ';

  @override
  String get faq_title_install_product =>
      'የነገሮችን ዕድሜ ለማራዘም የምርት ዳታቤዝ ለመፍጠር የክፍት ምርቶች እውነታዎችን ይጫኑ';

  @override
  String get faq_nutriscore_nutriscore =>
      'የ Nutri-Score አዲስ ስሌት፡ ምን አዲስ ነገር አለ?';

  @override
  String get contact_title_pro_page => 'ፕሮፌሽናል? ምርቶችዎን ወደ ክፍት የምግብ እውነታዎች ያስገቡ';

  @override
  String get contact_title_pro_email => 'የአምራች እውቂያ';

  @override
  String get contact_title_press_page => 'ገጽን ይጫኑ';

  @override
  String get contact_title_press_email => 'የፕሬስ እውቂያ';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'ለማህበረሰብ የቀን መቁጠሪያችን ይመዝገቡ';

  @override
  String get hunger_games_loading_line1 => 'እባክዎ ጥቂት ሰከንዶች ይስጡን…';

  @override
  String get hunger_games_loading_line2 => 'ጥያቄዎቹን እያወረድን ነው!';

  @override
  String get hunger_games_error_label =>
      'ኧረ! የሆነ ችግር ተፈጥሯል… እና ጥያቄዎቹን መጫን አልቻልንም።';

  @override
  String get hunger_games_error_retry_button => 'እንደገና እንሞክር!';

  @override
  String get reorder_attribute_action => 'ባህሪያትን እንደገና ደርድር';

  @override
  String get link_cant_be_opened =>
      'ይህ አገናኝ በመሳሪያዎ ላይ ሊከፈት አይችልም። እባክዎ አሳሽ መጫኑን ያረጋግጡ።';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'ዝርዝሮች ለ $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'ዝርዝሮች ለ $pageName ከ $productNameጋር';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'አጋራ';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'አዲሱን የ Nutri-Score ስሌት የት ማግኘት ይቻላል?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'የኑትሪ-ስኮር ውጤት በ7 አገሮች ውስጥ ጥቅም ላይ ውሏል፤ ፈረንሳይ፣ ጀርመን፣ ቤልጂየም፣ ስፔን፣ ሉክሰምበርግ፣ ኔዘርላንድስ እና ስዊዘርላንድ።';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'አምራቾች አዋጁን ከፈረሙ በኋላ ቢበዛ **2 ዓመት** የድሮውን ስሌት በአዲሱ ለመተካት አላቸው።';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'አረንጓዴው ነጥብ ምንድን ነው?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'አረንጓዴው ነጥብ ስለ ** የምግብ አካባቢያዊ ተጽእኖ ለእርስዎ ለማሳወቅ ያለመ አርማ ነው።';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'የቀለም ኮድ ከጨለማ አረንጓዴ (**A+**) ለ ** ቢያንስ ተፅዕኖ ፈጣሪ ** ምርቶች ወደ ጥቁር ቀይ (**F**) ለ ** በጣም ተፅዕኖ ፈጣሪዎች ይለያያል።';

  @override
  String get guide_greenscore_logos_caption => 'የአረንጓዴው ነጥብ አርማዎች';

  @override
  String get guide_greenscore_lca_title => 'ዋናው፡ የሕይወት ዑደት ግምገማ (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title => 'የምግብ ምድቦች ሳይንሳዊ ግምገማ';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'ለእያንዳንዱ የምርት ምድብ የ **ቤንችማርክ** ነጥብ ከአግሪባሊሴ የአካባቢ ዳታቤዝ (በADEME እና INRAE የተነደፈ) መረጃን በመጠቀም ይመሰረታል።';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**የህይወት ኡደት ትንተና** ባለ ብዙ ደረጃ እና ባለብዙ መስፈርት የአካባቢ ግምገማ ለማካሄድ ደረጃውን የጠበቀ የግምገማ ዘዴ ነው።';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**የሚለካው:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 የምርት ደረጃዎች';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Packaging';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title => '14 የአካባቢ ተጽዕኖ አመልካቾች';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'የአየር ንብረት ለውጥ/የካርቦን አሻራ';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'የኦዞን ንብርብር መሟጠጥ';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'ionizing ጨረር';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'መሬት';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'የውሃ እና የኃይል አጠቃቀም';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'የአየር ብክለት';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'የባህር እና ንጹህ ውሃ (ቅንጣቶች፣ አሲዳማነት፣ eutrophication)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'የሀብቶች መሟጠጥ.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'ጉርሻዎች እና ቅጣቶች';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'በአንድ ምድብ ውስጥ የተሻሉ ምርቶችን ለመሸለም፣ ከዚያም በበርካታ መስፈርቶች ላይ የተመሰረቱ **ጉርሻዎችን እና ቅጣቶችን** እንተገብራለን፡';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**ጉርሻ** የሚሰጠው **ኦፊሴላዊ መለያ፣ መለያ ወይም የአካባቢ ጥቅሞችን የሚያረጋግጥ የምስክር ወረቀት ላላቸው ምርቶች** (ኦርጋኒክ፣ ፍትሃዊ ንግድ፣ HVE፣ Label Rouge፣ Bleu Blanc Cœur፣ MSC/ASC) ነው።';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origin of ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**ጉርሻ** የሚሰጠው በንጥረ ነገሮቹ አመጣጥ ላይ በመመስረት ነው። ይህ ጉርሻ በመጓጓዣ ላይ ያለውን **ተፅዕኖ** እና የእያንዳንዱን አምራች ሀገር **የአካባቢ ፖሊሲ** ግምት ውስጥ ያስገባል።';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'እንደ የዘንባባ ዘይት ያሉ በብዝሃ ሕይወት እና በሥነ-ምህዳሮች ላይ ከፍተኛ አሉታዊ ተጽዕኖ የሚያሳድሩ ንጥረ ነገሮችን የያዙ ምርቶች **ቅጣት** ይሰጣቸዋል፤ ይህም የዘንባባ ዘይት ምርት ለከፍተኛ የደን ጭፍጨፋ ምክንያት ነው።';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Packaging';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**ቅጣት** የሚሰላው የማሸጊያውን ክብ ቅርጽ** (እንደገና ጥቅም ላይ የዋለ ጥሬ ዕቃ እና እንደገና ጥቅም ላይ ሊውል የሚችልበትን) እና ከመጠን በላይ ማሸግን ግምት ውስጥ በማስገባት ነው።';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'አረንጓዴ-ነጥብ በትክክል ለማስላት፣ በማሸጊያው ላይ ያልተጠቀሰ ** መረጃ (እንደ አመጣጥ እና የእያንዳንዱ ንጥረ ነገር ትክክለኛ መቶኛ) ወይም በቀላሉ ጥቅም ላይ በሚውል መልኩ የማይገኝ (ለምሳሌ ጥቅም ላይ የዋሉ ትክክለኛ የፕላስቲክ ዓይነቶችን የያዘ የማሸጊያውን ሁሉንም ክፍሎች ዝርዝር) መያዝ ያስፈልጋል።';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**አማካይ እሴቶች ይህ መረጃ ገና በማይገኝበት ጊዜ ጥቅም ላይ ይውላሉ**፣ ነገር ግን አሁን ይህንን መረጃ ለመሰብሰብ ሁሉም ሰው እንዲረዳን ጥሪ እናቀርባለን፣ ይህም ለአረንጓዴ-ውጤት በጣም ጠቃሚ ቢሆንም ለሌሎች ብዙ አገልግሎቶችም ጭምር ነው።';

  @override
  String get guide_greenscore_transparency_arg1_title => 'ዜጎች እንዴት ሊረዱ ይችላሉ?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'ሁሉም ዜጎች በምርቶች ላይ የሚገኘውን ወይም ከእነሱ ሊገኙ የሚችሉ መረጃዎችን ለመሰብሰብ እና ለማዋቀር ሊረዱን ይችላሉ፣ ለምሳሌ ስለ **ማሸጊያ** መረጃ፡ \"Mission Emballages\"፡ ለሁሉም የምግብ ምርቶች (በፈረንሳይኛ) ሰፊ የጋራ የማሸጊያ ክምችት።';

  @override
  String get guide_greenscore_transparency_arg2_title => 'አምራቾች እንዴት እንደሚረዱ';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'አምራቾች መረጃቸውን በቀጥታ በአምራቾቻችን በነፃ መድረክ በኩል ሊልኩልን ይችላሉ።';

  @override
  String get guide_greenscore_better_product_title => 'የትኛው ምርት ለፕላኔቱ የተሻለ ነው?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'ለመናገር አስቸጋሪ ሊሆን ይችላል';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'ቀጣይነት ያለው ምግብ መምረጥ ለአየር ንብረት ልናደርጋቸው ከምንችላቸው በጣም ሀይለኛ ነገሮች አንዱ ነው፣ ምክንያቱም ** የአለም አቀፍ የምግብ ስርዓታችን ከሩብ በላይ ለሚሆኑት የሙቀት አማቂ ጋዝ ልቀቶች ተጠያቂ ነው።\n(ምንጭ፡ Poore & Nemecek, Science, 2018)';

  @override
  String get guide_greenscore_better_product_arg2_title => 'ጉልበት አለህ!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'ጥሩ ዜናው ይህ ለውጥ ለመፍጠር ኃይለኛ መንገድ ይሰጠናል.\n**እያንዳንዳችን በዓመት ወደ 1,000 ገደማ ምግብ እንበላለን**። ለፕላኔቷ የተሻለ የወደፊት ሁኔታን ለመምረጥ 1,000 እድሎች ነው ***!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'ተጠያቂ ለመሆን እና ለመወሰን ይረዳል';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'ዘላቂ ምግብን መምረጥ ውስብስብነት ሊሰማው ይችላል. መለያዎች ግራ የሚያጋቡ ናቸው እና መረጃ ብዙ ጊዜ ይጎድላል። አረንጓዴው ነጥብ ቀላል ለማድረግ የተፈጠረ ሲሆን ይህም **ግልጽ******በሳይንስ ላይ የተመሰረተ** እና **ግልጽ የሆነ** የምግብ ምርቶች በሚፈልጉበት ቦታ ይሰጥዎታል፡ ሲገዙ።';

  @override
  String get guide_greenscore_better_product_arg4_title => 'ግልጽነት';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'ከባለቤትነት መለያዎች በተለየ የአረንጓዴው ነጥብ ስሌት **ሙሉ በሙሉ ክፍት ነው** እና **በማንኛውም ሰው ሊረጋገጥ ይችላል**።';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'ultra-processing ምንድን ነው?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'የNOVA ቡድኖች ስለ ምግብ ሂደት ደረጃ ያሳውቁዎታል።';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'የNOVA ምደባ በ **4 ቡድኖች** በኢንዱስትሪ ሂደት ደረጃቸው** (በትንሹ የተቀነባበሩ ወይም ያልተመረቱ ምግቦች፣ የምግብ እቃዎች፣ የተጨማዱ ምግቦች፣ እጅግ በጣም የተቀነባበሩ ምግቦች) ላይ ተመስርተው ምግቦችን በ **4 ቡድኖች ለመከፋፈል ያስችላል።';

  @override
  String get guide_nova_logos_caption => 'የ NOVA አርማዎች';

  @override
  String get guide_nova_groups_title => '4ቱ የ NOVA ቡድኖች';

  @override
  String get guide_nova_groups_intro =>
      '4 የNOVA ቡድኖች አሉ፣ ችግሩ ያለው ቡድን 4 - እጅግ በጣም የተቀነባበሩ ምግቦች ናቸው።';

  @override
  String get guide_nova_groups_arg1_title => 'በትንሹ የተሰሩ ወይም ያልተዘጋጁ ምግቦች';

  @override
  String get guide_nova_groups_arg1_text =>
      'unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'ከ ultra-processing ጋር ያሉ ችግሮች';

  @override
  String get guide_nova_explanations_arg1_title => 'የምግብ ንጥረ ነገሮችን በጣም ማቀነባበር';

  @override
  String get guide_nova_explanations_arg1_text =>
      'ብዙዎቹ እንደ ሃይድሮጂን የተጨመረባቸው ወይም ወለድ ያላቸው ዘይቶች፣ ሃይድሮላይዝድ ፕሮቲኖች፣ የአኩሪ አተር ፕሮቲን ኢሶሌት፣ ማልቶዴክስትሪን፣ ኢንቨርት ስኳር እና ከፍተኛ የፍሩክቶስ የበቆሎ ሽሮፕ ካሉ የምግብ ንጥረ ነገሮች ተጨማሪ ሂደት የተገኙ ናቸው።';

  @override
  String get guide_nova_explanations_arg2_title =>
      'ከንጹህ የምግብ ደህንነት በላይ የሆኑ ተጨማሪዎች';

  @override
  String get guide_nova_explanations_arg2_text =>
      'እጅግ በጣም በተቀነባበሩ ምግቦች ውስጥ ያሉ ተጨማሪዎች እንደ መከላከያዎች፣ አንቲኦክሲደንቶች እና ማረጋጊያዎች ባሉ በተቀነባበሩ ምግቦች ውስጥም ጥቅም ላይ የሚውሉትን ያካትታሉ። እጅግ በጣም በተቀነባበሩ ምርቶች ውስጥ ብቻ የሚገኙ ተጨማሪዎች ምድቦች የምግቦችን የስሜት ህዋሳት ለመምሰል ወይም ለማሻሻል ወይም የመጨረሻውን ምርት የማይመቹ ገጽታዎችን ለመደበቅ የሚያገለግሉትን ያካትታሉ**። እነዚህ ተጨማሪዎች ማቅለሚያዎችን እና ሌሎች ቀለሞችን፣ የቀለም ማረጋጊያዎችን፤ ጣዕሞችን፣ የጣዕም ማበልጸጊያዎችን፣ ስኳር ያልሆኑ ጣፋጮችን እና እንደ ካርቦን ማጠንከር፣ ማጠንከር፣ ማጉላት እና ፀረ-ቡልኪንግ ወኪሎች፣ አረፋ ማውጣት፣ ፀረ-ኬኪንግ እና ግላዝ ወኪሎች፣ ኢሙልሲፋየሮች፣ ሴክስታንት እና እርጥበት አዘል ንጥረ ነገሮችን ያካትታሉ።';

  @override
  String get guide_nova_explanations_arg3_title =>
      'በማቀነባበር እርስዎ ቤት ውስጥ ማድረግ አይችሉም';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**ብዙውን ጊዜ ብዙ ንጥረ ነገሮችን ለማጣመር እና የመጨረሻውን ምርት (ስለዚህ \'እጅግ በጣም የተዋቀረ\') ለመፍጠር በርካታ የሂደቶች ቅደም ተከተሎች ጥቅም ላይ ይውላሉ። ሂደቶቹ እንደ ሃይድሮጂንዜሽን እና ሃይድሮላይዜሽን፣ ኤክስትሩዥን እና ሻጋታ እና ለመጥበስ ቅድመ-ማቀነባበሪያ ያሉ በርካታ የቤት ውስጥ ተመጣጣኝ ያልሆኑ **ያሉ** ያካትታሉ።';

  @override
  String get guide_nova_explanations_arg4_title =>
      'የ ultra-processing አዳኝ እና የገንዘብ ገጽታዎች';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**የአልትራ-ፕሮሰሲንግ አጠቃላይ ዓላማ ሌሎች የምግብ ቡድኖችን ለማፈናቀል የተነደፉ የምርት ስም**፣ **ምቹ** (ዘላቂ፣ ለመበላት ዝግጁ)፣ **ማራኪ** (በጣም ጣፋጭ) እና **በጣም ትርፋማ** (ዝቅተኛ ዋጋ ያላቸው ግብዓቶች) የምግብ ምርቶችን መፍጠር ነው። አልትራ-ፕሮሰሲንግ የምግብ ምርቶች ብዙውን ጊዜ ማራኪ በሆነ መልኩ የታሸጉ እና በከፍተኛ ሁኔታ ለገበያ የሚቀርቡ ናቸው።';

  @override
  String get guide_nova_explanations_arg5_title => 'የጤና አደጋ';

  @override
  String get guide_nova_explanations_arg5_text =>
      'ከ2018 ጀምሮ፣ ከNutriNet-Santé ጋር፣ እጅግ በጣም የተቀነባበሩ ምግቦችን ፍጆታ እና የካንሰር፣ የልብና የደም ቧንቧ በሽታዎች እና የስኳር በሽታ አደጋዎች መጨመር መካከል የመጀመሪያው ትስስር ጎልቶ ታይቷል**። ዛሬ፣ በዓለም ዙሪያ ከ90 በላይ ጥናቶች እነዚህን ግኝቶች አረጋግጠዋል።\nጠንካራዎቹ ግንኙነቶች ከ**ውፍረት፣ የልብና የደም ቧንቧ ሞት እና የመንፈስ ጭንቀት ምልክቶች** ጋር የተያያዙ ናቸው። በልጆች ላይ፣ ውጤቶቹ በዋነኝነት የሚታዩት በክብደት እና በሊፒድ አለመመጣጠን ላይ ነው።';

  @override
  String get guide_nova_explanations_arg6_title =>
      'አገሮች እነዚህን ገደቦች እንዲገድቡ ይመክራሉ';

  @override
  String get guide_nova_explanations_arg6_text =>
      'አንዳንድ አገሮች የNOVA ቡድኖችን ለአመጋገብ መመሪያዎቻቸው ወይም ግቦቻቸው ይጠቀማሉ፣ ለምሳሌ፦\n\n- **🇧🇷 የብራዚል** የአመጋገብ መመሪያዎች **የተቀነባበሩ ምግቦችን ፍጆታ ለመገደብ** እና እጅግ በጣም የተቀነባበሩ ምግቦችን ለማስወገድ ይመክራሉ።\n\n- **🇫🇷 የፈረንሳይ** የ2018-2022 የህዝብ ጤና የአመጋገብ ፖሊሲ ግቦች **የቡድን 4 እጅግ በጣም የተቀነባበሩ ምግቦችን ፍጆታ በ20% ለመቀነስ ያለመ ነው።**';

  @override
  String get guide_nova_share_link => 'https://world-am.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'ወደ Open Food Facts እንኳን በደህና መጡ!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'የምግብ ክፍት እውነታዎች ምንድን ነው?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'ክፍት የምግብ ፋንታክስ **ተባባሪ**፣ **ነጻ** እና **ክፍት** የምግብ መረጃ ቋት ሲሆን ከመላው ዓለም የተውጣጡ የምግብ ምርቶችን ያካትታል።';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'ሁሉም ሰው ስለሚመገበው ምግብ መረጃ ማግኘት እንዳለበት እናምናለን። ስለ ንጥረ ነገሮች፣ ስለ አለርጂዎች፣ ስለ አመጋገብ እውነታዎች እና ሌሎችም መረጃዎችን በመሰብሰብ፣ **ሸማቾች በመረጃ ላይ የተመሰረተ ምርጫ እንዲያደርጉ እና የምግብ ኢንዱስትሪውን ወደተሻለ ግልጽነት እንዲያመሩ እናበረታታቸዋለን**።';

  @override
  String get guide_open_food_facts_features_title => 'የክፍት ምግብ እውነታዎች ባህሪያት';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'የማይፈለጉ ንጥረ ነገሮችን በተመለከተ ማንቂያዎችን ያግኙ';

  @override
  String get guide_open_food_facts_tips_title => 'ምርጥ ፎቶዎችን ለማንሳት ጠቃሚ ምክሮች';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'ማድረግ የሌለባቸው ነገሮች';

  @override
  String get guide_open_food_facts_tips_arg1_text1 => 'ጥላዎችን እና ነጸብራቅን ያስወግዱ።';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'ምንም ብዥታ ወይም ትኩረት የማይሰጥ ጽሑፍ የለም።';

  @override
  String get guide_open_food_facts_tips_arg1_text3 => 'የጽሑፉን ክፍሎች አይቁረጡ።';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'የተጨናነቁ ዳራዎችን ያስወግዱ።';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'የሚደረጉ ነገሮች';

  @override
  String get guide_open_food_facts_tips_arg2_text1 => 'ጥሩ፣ እኩል የሆነ ብርሃን ይጠቀሙ።';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'ጽሑፉ ስለታም እና ሊነበብ የሚችል መሆኑን ያረጋግጡ።';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'የጠቅላላውን ንጥረ ነገር ዝርዝር ይያዙ።';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'ምርቱን በጠፍጣፋ መሬት ላይ ያስቀምጡት።';

  @override
  String get guide_open_food_facts_scores_title =>
      '\"ዊኪፔዲያ ኦፍ ፉድ\" እንድንገነባ ያግዙን';

  @override
  String get guide_open_food_facts_scores_arg1_title => 'የአመጋገብ ጥራት ላይ ነጥብ';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'እጅግ በጣም የተቀነባበሩ ምግቦችን ለማስወገድ የሚያስችል ውጤት';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'ለፕላኔቷ የሚሆን ነጥብ';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-am.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'ወደ Open Pet Food Facts እንኳን በደህና መጡ!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'የክፍት የቤት እንስሳት ምግብ እውነታዎች ምንድን ናቸው?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'ክፍት የቤት እንስሳት የምግብ እውነታዎች ተልእኳችንን ለፀጉር ጓደኞቻችን ያሰፋዋል! ለድመቶች፣ ለውሾች እና ለሌሎች አጋሮች የቤት እንስሳት የምግብ ምርቶች የውሂብ ጎታ ነው**።';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'የቤት እንስሳት ባለቤቶች ለእንስሳቶቻቸው ፍላጎት የሚስማማውን ምርጥ ምግብ እንዲመርጡ ለመርዳት ስለ **ንጥረ ነገሮች**፣ **የአመጋገብ ትንተና** እና ስለ አመጋገብ መመሪያዎች መረጃ እንሰበስባለን።';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'የክፍት የቤት እንስሳት ምግብ እውነታዎች ባህሪያት';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'የማይፈለጉ ንጥረ ነገሮችን በተመለከተ ማንቂያዎችን ያግኙ';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'የቤት እንስሳዎ ለማንኛውም ንጥረ ነገሮች አለርጂክ ነው? በመተግበሪያው ውስጥ ለማስወገድ የሚያስፈልጉዎትን የመዋቢያ ንጥረ ነገሮች ዝርዝር ማዘጋጀት ይችላሉ!';

  @override
  String get guide_open_pet_food_facts_tips_title => 'ምርጥ ፎቶዎችን ለማንሳት ጠቃሚ ምክሮች';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'ማድረግ የሌለባቸው ነገሮች';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'ጥላዎችን እና ነጸብራቅን ያስወግዱ።';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'ምንም ብዥታ ወይም ትኩረት የማይሰጥ ጽሑፍ የለም።';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 => 'የጽሑፉን ክፍሎች አይቁረጡ።';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 => 'የተጨናነቁ ዳራዎችን ያስወግዱ።';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'የሚደረጉ ነገሮች';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'ጥሩ፣ እኩል የሆነ ብርሃን ይጠቀሙ።';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'ጽሑፉ ስለታም እና ሊነበብ የሚችል መሆኑን ያረጋግጡ።';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'የጠቅላላውን ንጥረ ነገር ዝርዝር ይያዙ።';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'ምርቱን በጠፍጣፋ መሬት ላይ ያስቀምጡት።';

  @override
  String get guide_open_pet_food_facts_scores_title => 'ስለ ውጤት ማስቆጠር ማስታወሻ';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'የቤት እንስሳትን ለመመገብ የውጤት አሰጣጥ ስርዓት ማዘጋጀት **አሁን ቅድሚያ የሚሰጠው ጉዳይ አይደለም**። የአመጋገብ ፍላጎቶች በእንስሳት፣ በእድሜ እና በጤና ሁኔታ በእጅጉ ስለሚለያዩ ዘዴው ውስብስብ ይሆናል። እንዲህ አይነት ውጤት ሊያመጣ የሚችል ገለልተኛ የሳይንስ ቡድን እስካሁን አላገኘንም።';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-am.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'ወደ ክፍት የውበት እውነታዎች እንኳን በደህና መጡ!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'ክፍት የውበት እውነታዎች ምንድን ናቸው?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'ክፍት የውበት እውነታዎች የ **ኮስሜቲክ ምርቶች** የጋራ የመረጃ ቋት ነው።';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'ግባችን በግል እንክብካቤ ዕቃዎችዎ ውስጥ ያለውን ነገር እንዲረዱ ለማገዝ የንጥረ ነገሮች ዝርዝርን መፍታት ነው። ከእርጥበት ማድረቂያዎች እስከ ሜካፕ፣ በመዋቢያ ኢንዱስትሪ ውስጥ ግልጽነትን ለማስተዋወቅ ስለ ንጥረ ነገሮች፣ ስለ አለርጂዎች እና ስለ ማሸጊያዎች መረጃዎችን እንሰበስባለን።';

  @override
  String get guide_open_beauty_facts_features_title => 'የክፍት ውበት እውነታዎች ገጽታዎች';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'የማይፈለጉ ንጥረ ነገሮችን በተመለከተ ማንቂያዎችን ያግኙ';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'ለማንኛውም ንጥረ ነገሮች አለርጂክ ነዎት? የኮሜዶጅን ንጥረ ነገሮችን ማስወገድ ይፈልጋሉ? አወዛጋቢ ከሆኑ ንጥረ ነገሮች መራቅ ይፈልጋሉ? በመተግበሪያው ውስጥ ሊያስወግዷቸው የሚገቡ የመዋቢያ ንጥረ ነገሮችን ዝርዝር ማዘጋጀት ይችላሉ!';

  @override
  String get guide_open_beauty_facts_tips_title => 'ምርጥ ፎቶዎችን ለማንሳት ጠቃሚ ምክሮች';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'ማድረግ የሌለባቸው ነገሮች';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'ጥላዎችን እና ነጸብራቅን ያስወግዱ።';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'ምንም ብዥታ ወይም ትኩረት የማይሰጥ ጽሑፍ የለም።';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 => 'የጽሑፉን ክፍሎች አይቁረጡ።';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 => 'የተጨናነቁ ዳራዎችን ያስወግዱ።';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'የሚደረጉ ነገሮች';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'ጥሩ፣ እኩል የሆነ ብርሃን ይጠቀሙ።';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'ጽሑፉ ስለታም እና ሊነበብ የሚችል መሆኑን ያረጋግጡ።';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'የጠቅላላውን ንጥረ ነገር ዝርዝር ይያዙ።';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'ጠርሙሱ የተጠማዘዘ ከሆነ የሚያስፈልገውን ያህል ፎቶ ያንሱ።';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'የንጥረ ነገሮችን ዝርዝር ለማየት መለያውን መገልበጥ ያስፈልግዎት ይሆናል።';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'ምርቱን በጠፍጣፋ መሬት ላይ ያስቀምጡት።';

  @override
  String get guide_open_beauty_facts_scores_title => 'ስለ ውጤት ማስቆጠር ማስታወሻ';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'ከምግብ ምርቶች በተለየ መልኩ የመዋቢያዎች ዓለም **እንደ Nutri-Score** ያለ በዓለም አቀፍ ደረጃ የታወቀ፣ በመንግስት የሚደገፍ የውጤት አሰጣጥ ስርዓት የለውም። የንጥረ ነገሮች ተፅእኖዎች በጣም ግላዊ ሊሆኑ እና በቆዳ አይነት፣ በአለርጂዎች እና በግለሰብ ጉዳዮች ላይ የተመሰረቱ ሊሆኑ ይችላሉ።';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-am.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**ዋጋዎችን ክፍት ምንጭ የውሂብ ስብስብ እያሰባሰብን ነው**። ዋጋዎች በተጠቃሚዎች በዚህ የድር መተግበሪያ ወይም በይፋዊው የክፍት ምግብ እውነታዎች የሞባይል መተግበሪያ በኩል ሊታከሉ ይችላሉ። ቸርቻሪዎች ወይም የሶስተኛ ወገን መተግበሪያዎች የእኛን ኤፒአይ በመጠቀምም አስተዋጽዖ ማድረግ ይችላሉ።';

  @override
  String get guide_open_prices_how_arg1_title =>
      'የዋጋ መለያዎችን ፎቶዎች በመተላለፊያዎች ውስጥ ይሰብስቡ';

  @override
  String get guide_open_prices_how_arg2_title => 'የደረሰኞችን ፎቶዎች ይሰብስቡ';

  @override
  String get guide_open_prices_why_title =>
      'ኦፕን ፉድ ፋውንትስ ይህን የሚያደርገው ለምንድን ነው?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'የምግብ ስርዓቶችን ለመረዳት የዋጋ መረጃ እጅግ በጣም አስፈላጊ ነው። የምግብ ዋጋን ለመረዳት እና ጤናማ ምግቦችን ለማስተዋወቅ ቁልፍ ነገር ነው። የዋጋ መረጃ መክፈት ተመራማሪዎች፣ ጋዜጠኞች እና ዜጎች የምግብ ዋጋ በጂኦግራፊያዊ እና በጊዜ እንዴት እንደሚለያይ የተሻለ ግንዛቤ እንዲኖራቸው ለማድረግ የሚያስችል መንገድ ነው።';

  @override
  String get guide_open_prices_why_arg1_title => 'የዋጋዎችን እድገት በጊዜ ሂደት ይከታተሉ';

  @override
  String get guide_open_prices_why_arg1_text =>
      'የዋጋዎችን **ዝግመተ ለውጥ** ይመልከቱ፡ የዋጋ ንረት መቀነስ፣ ርካሽ የዋጋ ንረት፣ አብረን መከታተል እንችላለን!';

  @override
  String get guide_open_prices_why_arg2_title => 'በአቅራቢያዎ ያሉ ዋጋዎችን ያወዳድሩ';

  @override
  String get guide_open_prices_why_arg2_text =>
      'ተጨማሪ ዋጋዎችን ስናገኝ፣ **በዙሪያዎ በጣም ርካሹን መደብሮች** ማግኘት ይችላሉ።';

  @override
  String get guide_open_prices_scrapping_title =>
      'ከቸርቻሪዎች ድረ-ገጾች ላይ የዋጋ ቅነሳዎችን አስበዋል?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'የዋጋ ቅየራ (Preces scraping) ወደፊት በሚካሄደው የOpen Prices ስሪት ውስጥ እንደ አማራጭ የሚወሰድ ቢሆንም፣ በHTML ገጹ ላይ ተመስርቶ የዋጋውን ማረጋገጫ ማግኘት እንድንችል በክፍት Prices ራሱ ይከናወናል።';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'የእኛን ኤፒአይ በመጠቀም ዋጋዎችን ማበርከት ይችላሉ።\nዋጋዎችን በስፋት ማበርከት ከፈለጉ፣ እባክዎን በprices@openfoodfacts.org ያግኙን።';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'ወደ Open Products Facts እንኳን በደህና መጡ!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'የክፍት ምርቶች እውነታዎች ምንድን ናቸው?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'ክፍት ምርቶች ፋክትስ ባርኮድ ያለው ለማንኛውም ምርት ግዙፍ፣ ክፍት የመረጃ ቋት ሲሆን ይህም ምግብ፣ የመዋቢያ ወይም የቤት እንስሳት ምግብ ያልሆነ** ነው።';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'ከ **ኤሌክትሮኒክስ** እስከ **መጫወቻዎች**፣ እና **ልብስ** እስከ **የጽዳት አቅርቦቶች**፣ ባርኮድ ካለው፣ ሊጨመር ይችላል። ይህ ፕሮጀክት ለዕለታዊ ዕቃዎች \"የነገሮች በይነመረብ\" ለመፍጠር ያለመ ሲሆን ስለእነሱ መረጃ በዓለም አቀፍ ደረጃ ተደራሽ ያደርገዋል።';

  @override
  String get guide_open_products_facts_features_title =>
      'የክፍት ምርቶች እውነታዎች ባህሪያት';

  @override
  String get guide_open_products_facts_features_text =>
      'ክፍት ምርቶች ፋውንቴሽን ሸማቾች ዕቃዎቻቸውን ለመጠገን፣ ለመጠገን፣ እንደገና ጥቅም ላይ ለማዋል ወይም አዲስ ባለቤት ለመስጠት ክብ መፍትሄዎችን በማቅረብ የነገሮችን ዕድሜ እንዲያራዝሙ** ለማቅረብ ያለመ ነው።';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'ለአንዳንድ ምርቶች የካርቦን አሻራዎች';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**የካርቦን ዳይኦክሳይድ ተጽእኖ** በፈረንሳይ የአካባቢ ባለስልጣን ADEME የብዙ ምድቦችን **የካርቦን ተጽእኖ** ያቀርባል፣ ምርቶችን በትክክል መመደብዎን ያረጋግጡ።';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'ለብዙ ምርቶች የማሻሻያ መረጃ ጠቋሚ';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'የፈረንሳይ የማካካሻ ኢንዴክስ በሚገኝበት ጊዜ ሁሉ እናሳየዋለን። ከዚህም በላይ፣ **ተለዋዋጮቹን በፎልክሶኖሚ ሞተር** በመጠቀም መሰብሰብ መጀመር ይችላሉ፤ ስለዚህም ወደፊት በማይገኝባቸው አገሮች ውስጥ እንኳን እራሳችንን እንደገና ማስላት እንችላለን።';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'ምርትዎን ለመለገስ/እንደገና ለመሸጥ መንገዶችን ያግኙ';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'ለሶስተኛ ወገን ክብ ቅርጽ ያላቸው አገልግሎቶች** አገናኞችን እናቀርባለን፤ እነዚህም የሚፈልጉትን ምርት እንደ ሁለተኛ እጅ ምርት እንዲያገኙ የሚያግዙዎት ሲሆን ይህም በፕላኔታዊ ሀብቶች ላይ የበለጠ ጨዋነት እንዲኖራቸው ይረዳል።\nያንን ለማድረግ ክፍያ እንዳልተከፈለን እና ስርዓቱ በፈረንሳይ ውስጥ ላሉ ሁለት ድር ጣቢያዎች ብቻ እንደ ምሳሌ ሆኖ እንደሚሰራ ልብ ይበሉ። በዊኪው ላይ ተጨማሪ ጣቢያዎችን በመመዝገብ ይህንን ስርዓት ለማስፋፋት ሊረዱዎት ይችላሉ።';

  @override
  String get guide_open_products_facts_information_title =>
      'ምን አይነት መረጃ ጠቃሚ ነው?';

  @override
  String get guide_open_products_facts_information_text =>
      'ለእንደዚህ አይነት ሰፊ የእቃዎች ክልል **የምንሰበስበው መረጃ ተለዋዋጭ ነው**። ይህንን ለማድረግ **ፎልክሶኖሚ ሞተር** ፈጠርን።';

  @override
  String get guide_open_products_facts_folksonomy_title => 'የፎልክሶኖሚ ሞተር';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'የፎልክሶኖሚ ሞተር ተዛማጅ ባህሪያት ያላቸውን ምርቶች እንዲያጠናቅቁ የሚያግዝ መሳሪያ ነው። ይህ ፍለጋን እና ተገኝነትን ለማሻሻል ይረዳል፣ ነገር ግን ለወደፊቱ አስደሳች ነገሮችን ለማስላት እና ለማሳየት ይረዳል።';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'እንደ **ተኳሃኝነት_ከ_5G_mobile_network ጋር፡ አዎ** ያሉ ማንኛውንም ቁልፎችን እና እሴቶችን ማከል ይችላሉ';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'ሊሆኑ የሚችሉ ንብረቶችን በራስ-ሰር የመምከር እድል ያገኛሉ፣ እና በሚወዷቸው የምርት አይነቶች ላይ አዳዲስ ምርቶችን ማከል እና መመዝገብ ይችላሉ።';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-am.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'ክፍት የምግብ ምርጫዎች';

  @override
  String get guide_coming_soon_button_title => 'በቅርቡ ይመጣል';

  @override
  String get guide_learn_more_subtitle => 'ተጨማሪ ለማወቅ መታ ያድርጉ';

  @override
  String get preview_badge => 'ቅድመ እይታ';

  @override
  String get prices_feedback_form =>
      'ስለዚህ አዲስ ባህሪ ያለዎትን አስተያየት ለመላክ እዚህ ጠቅ ያድርጉ!';

  @override
  String get menu_button_list_actions => 'እርምጃ ይምረጡ';

  @override
  String get error_loading_photo => 'ፎቶ በመጫን ላይ ስህተት';

  @override
  String get photo_viewer_action_use_picture_as => 'እንደ…ይጠቀሙ';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'ይህንን ስዕል እንደ…ይጠቀሙበት';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'ይህንን ስዕል እንደ… ($language) ይጠቀሙበት';
  }

  @override
  String get photo_viewer_details_button => 'ዝርዝሮች';

  @override
  String get photo_viewer_details_button_accessibility_label => 'የዚህ ፎቶ ዝርዝሮች';

  @override
  String get photo_viewer_details_title => 'የፎቶው ዝርዝሮች';

  @override
  String get photo_viewer_details_contributor_title => 'Contributor';

  @override
  String get photo_viewer_details_size_title => 'መጠን';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height ፒክስሎች';
  }

  @override
  String get photo_viewer_details_date_title => 'ቀን';

  @override
  String get photo_viewer_details_url_title => 'ዩአርኤል';

  @override
  String get product_page_compatibility_score => 'ተኳሃኝ';

  @override
  String get user_lists_action_multi_select => 'ባለብዙ ምርጫ';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'የተኳሃኝነት ነጥብዎ፦ $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Front picture';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Ingredients picture';

  @override
  String get product_image_nutrition_accessibility_label => 'የአመጋገብ ምስል';

  @override
  String get product_image_packaging_accessibility_label => 'የማሸጊያ ስዕል';

  @override
  String get product_image_other_accessibility_label => 'ሌላ ሥዕል';

  @override
  String get product_image_outdated_message => 'ይህ ፎቶ ጊዜው ያለፈበት ሊሆን ይችላል';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (ይህ ምስል ጊዜው ያለፈበት ሊሆን ይችላል)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (ይህ ምስል በአምራቹ ሊቆለፍ ይችላል)';
  }

  @override
  String get product_image_error => 'ምስሉን መጫን አልተቻለም!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type ን መጫን አልተቻለም (የአውታረ መረብ ስህተት?)';
  }

  @override
  String get product_page_image_no_image_available => 'ምንም\nምስል የለም!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'ለዚህ ምርት ምንም ፎቶ የለም';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'እርምጃዎችን እንደገና ደርድር ወይም ደብቅ';

  @override
  String get product_page_action_bar_setting_modal_title => 'እርምጃዎችን ያርትዑ';

  @override
  String get product_page_action_bar_item_move_up => 'ወደ ላይ ውሰድ';

  @override
  String get product_page_action_bar_item_move_down => 'ወደ ታች ውሰድ';

  @override
  String get product_page_action_bar_item_enable => 'እርምጃን አንቃ';

  @override
  String get product_page_action_bar_item_disable => 'እርምጃን አሰናክል';

  @override
  String get product_page_pending_operations_banner_title =>
      'አርትዖቶችዎን በመስቀል ላይ…';

  @override
  String get product_page_pending_operations_banner_message =>
      'በዚህ ገጽ ላይ የሚታየው ውሂብ **እስካሁን ማሻሻያዎችዎን አያንጸባርቅም።**።\nእባክዎ ጥቂት ሰከንዶች ይጠብቁ…';

  @override
  String get product_add_a_language => 'ቋንቋ ያክሉ';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'ባርኮድ $barcode';
  }

  @override
  String get carousel_close_tooltip => 'ይህንን ምርት ከካሮሴል ውስጥ ያስወግዱት';

  @override
  String get carousel_unsupported_header => 'የማይደገፍ ባርኮድ!';

  @override
  String get carousel_unsupported_title => 'ኡፍፍፍ!';

  @override
  String get carousel_unsupported_text => 'የተቃኘው ባርኮድ በክፍት ፉድ ፋክትስ አይደገፍም!';

  @override
  String get carousel_error_header => 'ስህተት!';

  @override
  String get carousel_error_title => 'በጣም ያሳዝናል!';

  @override
  String get carousel_error_text_1 => 'በዚህ ባርኮድ ላይ መረጃ ማውረድ አልቻልንም፡';

  @override
  String get carousel_error_text_2 => 'የኢንተርኔት ግንኙነትዎን ያረጋግጡ ወይም ይህንን ቁልፍ ይጫኑ፦';

  @override
  String get carousel_error_button => 'እንደገና ሞክር';

  @override
  String get carousel_unknown_product_header => 'ያልታወቀ ምርት';

  @override
  String get carousel_unknown_product_title =>
      'እንኳን ደስ አላችሁ!\nብርቅዬውን ዕንቁ አግኝተሃል!__';

  @override
  String get carousel_unknown_product_text =>
      'የትብብር ዳታቤዛችን ከ **3 ሚሊዮን በላይ ምርቶችን** ይዟል፣ ነገር ግን ይህ ባርኮድ የለም፦ ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'መረጃ በመጫን ላይ...';

  @override
  String get carousel_loading_title => 'የሚከተለውን ባርኮድ በመጠቀም አንድን ምርት አሁን ቃኝተሃል፦';

  @override
  String get carousel_loading_text =>
      'ከ **3 ሚሊዮን በላይ ምርቶች ባሉበት የውሂብ ጎታችን ውስጥ እየፈለግነው ነው!**';

  @override
  String get product_type_subtitle_food => 'አትክልቶች፣ ፍራፍሬዎች፣ የቀዘቀዘ ምግብ…';

  @override
  String get product_type_subtitle_beauty => 'ሜካፕ፣ ሳሙናዎች፣ የጥርስ ሳሙናዎች…';

  @override
  String get product_type_subtitle_pet_food => 'ለውሾች፣ ድመቶች የሚሆን ምግብ…';

  @override
  String get product_type_subtitle_product => 'ስማርት ስልኮች፣ የቤት እቃዎች…';

  @override
  String get photo_field_front => 'የምርት ፎቶ';

  @override
  String get photo_field_ingredients => 'የንጥረ ነገሮች ፎቶ';

  @override
  String get photo_field_nutrition => 'የአመጋገብ ፎቶ';

  @override
  String get photo_field_packaging => 'የመልሶ ጥቅም ላይ ማዋል መመሪያዎች ፎቶ';

  @override
  String get photo_already_exists => 'ይህ ፎቶ አስቀድሞ አለ';

  @override
  String get photo_missing => 'ይህ ፎቶ ጠፍቷል';

  @override
  String get date => 'ቀን';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'ቀዳሚውን እርምጃ ቀልብስ';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'የ $locationየዓለም ካርታ';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'የOpenStreetMap አስተዋጽዖ አበርካቾች';

  @override
  String get not_applicable_short => 'የለም';

  @override
  String get knowledge_panel_warning_text => 'Warning';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'ይህ የኑትሪ-ስኮር ከጥቅሉ ላይ ካለው የተለየ የሆነው ለምንድነው?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'ሁለት ሊሆኑ የሚችሉ ማብራሪያዎች አሉ፦\nየንጥረ ነገሮች እና/ወይም የአመጋገብ እውነታዎች ዝርዝር ወቅታዊ አይደለም።\n\nየNutri-Score (ወይም V2) \"አዲስ ስሌት\" እናቀርባለን። እባክዎን በጥቅሉ ላይ \"አዲስ ስሌት\" የሚለውን ባነር እንዳለዎት ያረጋግጡ።';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'ንጥረ ነገሮችን ያረጋግጡ';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'የአመጋገብ እውነታዎችን ያረጋግጡ';

  @override
  String url_not_supported(String url) {
    return 'በሚያሳዝን ሁኔታ፣ ዩአርኤሉን መክፈት አንችልም፦\n$url';
  }

  @override
  String get product_list_export => 'ወደ ውጭ ላክ';

  @override
  String get product_list_import => 'አስመጣ';

  @override
  String get product_footer_action_barcode => 'ባርኮድ ይመልከቱ';

  @override
  String get product_footer_action_barcode_short => 'Barcode';

  @override
  String get product_footer_action_open_website => 'ድህረ ገጽን ክፈት';

  @override
  String get product_footer_action_report => 'ሪፖርት ያድርጉ';

  @override
  String get product_footer_action_contributor_guide => 'እገዛ';

  @override
  String get product_footer_action_data_quality_tags => 'የውሂብ ጥራት';

  @override
  String get product_page_tab_for_me => 'ለኔ';

  @override
  String get product_page_tab_website => 'ድህረገፅ';

  @override
  String get product_page_tab_prices => 'ዋጋዎች';

  @override
  String get prices_explanation_card_title => 'ለምን ዋጋዎች?';

  @override
  String get prices_explanation_card_line1 =>
      '** Open Prices ** በዓለም ዙሪያ ያሉ ምርቶችን የመሰብሰብ እና የመጋራት ፕሮጀክት ነው 🌍። Open Prices የሚዘጋጀው በክፍት Open Food Facts ነው።';

  @override
  String get explanation_card_learn_more_button => 'ተጨማሪ ይወቁ';

  @override
  String get product_page_tab_folksonomy => 'ፎልክሶኖሚ';

  @override
  String get folksonomy_explanation_card_title => 'Folksonomy ባህሪያት ምንድን ናቸው?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'ባህሪያት **ቁልፍ-እሴት** የተመሰረቱ ናቸው።';

  @override
  String get folksonomy_explanation_card_line2 =>
      'እነዚህ ንብረቶች ለየትኛውም አይነት አገልግሎት አስተዋፅዖ አበርካቾች የተፈጠሩ እና የተመዘገቡ ናቸው።';

  @override
  String get folksonomy_action_external_link_title => 'ውጫዊ ሊንክ ክፈት';

  @override
  String get folksonomy_action_external_link_warning =>
      'ውጫዊ አገናኞች ደህንነታቸው ያልተጠበቀ ሊሆን ይችላል። በእርግጥ መጎብኘት ይፈልጋሉ?';

  @override
  String get prices_products_empty_title => 'ምንም ዋጋ አይገኝም';

  @override
  String get prices_products_empty_explanation => 'አስተዋጽዖ ለማድረግ የመጀመሪያው ይሁኑ!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'ከፍተኛ $pageSize ምርቶች (ጠቅላላ፡ $total)';
  }

  @override
  String get app_review_title => 'ይህን መተግበሪያ እየተደሰቱበት ነው?';

  @override
  String get app_review_low => 'የተሻለ ማድረግ ይቻል ነበር';

  @override
  String get app_review_medium => 'መጥፎ አይደለም';

  @override
  String get app_review_high => 'በጣም እወደዋለሁ!';

  @override
  String get app_review_feedback_modal_title => 'መተግበሪያችንን እንድናሻሽል ያግዙን';

  @override
  String get app_review_feedback_modal_content =>
      'ጥቂት ደቂቃዎች ካሉዎት፣ **በወደፊት ዝማኔዎች ላይ ማሻሻል እንድንችል ይህንን ቅጽ መመለስ ይችላሉ**፡';

  @override
  String get app_review_feedback_modal_open_form => 'ለቅጹ መልስ ይስጡ';

  @override
  String get app_review_feedback_modal_later => 'በኋላ ጠይቀኝ';

  @override
  String get nutrition_facts_extract_new =>
      'አዲስ፡- ንጥረ ነገሮቹን ከስዕሉ በራስ-ሰር ማውጣት ይችላሉ!';

  @override
  String get nutrition_facts_extract_button_text => 'አሁን አውጥተህ አውጣ';

  @override
  String get nutrition_facts_extract_in_progress => 'ማውጣት በሂደት ላይ…';

  @override
  String get nutrition_facts_extract_successful => 'ማውጣት ተሳክቷል።';

  @override
  String get nutrition_facts_extract_failed => 'ከስዕሉ ውስጥ ንጥረ ነገሮችን ማውጣት አልተሳካም';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'ስታቲስቲክስ';

  @override
  String get prices_stats_title => 'የዋጋዎች ስታቲስቲክስ';

  @override
  String get prices_stats_prices_section => 'ዋጋዎች';

  @override
  String get prices_stats_products_section => 'ምርቶች';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'የተለያዩ';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'ምግብ';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'ምርቶች';

  @override
  String get prices_stats_pet_food => 'የቤት እንስሳት ምግብ';

  @override
  String get prices_stats_osm => 'ኦፕን ስትሪት ካርታ';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Countries';

  @override
  String get prices_stats_price_tag => 'የዋጋ መለያ';

  @override
  String get prices_stats_receipt => 'ደረሰኝ';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'ድህረገፅ';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'ኤፒአይ';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'ለመጨረሻ ጊዜ የተዘመነው በ';

  @override
  String get prices_stats_error => 'ስታቲስቲክስን በመጫን ላይ ስህተት ተከስቷል።';

  @override
  String get product_edit_robotoff_question_answered => 'ጥያቄው መልስ አግኝቷል!';

  @override
  String get product_edit_robotoff_proof => 'ማረጋገጫ';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'ዋጋዎች';

  @override
  String get preferences_prices_subtitle => 'የዋጋ ምርጫዎችዎን ያስተዳድሩ';

  @override
  String get preferences_card_project => 'ክፍት የምግብ እውነታዎች ፕሮጀክት';

  @override
  String get preferences_contribute_title => 'Contribute';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'የእኔ ስታቲስቲክስ';

  @override
  String get preferences_contribute_subtitle => 'ተርጉም፣ መሳሪያዎቻችንን አሻሽል…';

  @override
  String get preferences_connect_title => 'ተገናኝ';

  @override
  String get preferences_connect_subtitle => 'ያግኙን ወይም በማህበራዊ ሚዲያ ላይ ይከተሉን።';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'በአለም ዙሪያ በሚሊዮን የሚቆጠሩ ሸማቾችን እንድናሳውቅ ያግዙን።';

  @override
  String get preferences_card_help => 'እገዛ እና ድጋፍ';

  @override
  String get preferences_faq_title => 'ተደጋጋሚ ጥያቄዎች';

  @override
  String get preferences_faq_subtitle => 'ለጥያቄዎችዎ መልስ ያግኙ';

  @override
  String get logged_out => 'ወጥቷል';

  @override
  String get preferences_app_bar_message => 'ከአባሎቻችን አንዱ ስለሆኑ እናመሰግናለን!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'ሁሉንም ስታቲስቲክስ ይመልከቱ';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '$provider \"$keyword\" ፈልግ';
  }

  @override
  String get preferences_app_bar_search_hint => 'መቼት ፈልግ (ለምሳሌ Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji => 'ተደራሽነት፡ ስሜት ገላጭ ምስል አሳይ';

  @override
  String get preferences_accessibility_remove_colors => 'ተደራሽነት: ቀለሞችን ያስወግዱ';

  @override
  String get preferences_app_settings_products => 'ምርቶች';

  @override
  String get preferences_card_about => 'About';

  @override
  String get preferences_legal_information_title => 'የህግ መረጃ';

  @override
  String get preferences_legal_information_subtitle =>
      'የአጠቃቀም ውል፣ የግላዊነት ፖሊሲ እና ሌሎችም።';

  @override
  String get preferences_terms_of_use => 'የአጠቃቀም ውሎች';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'ክፍት Open Food Facts የምግብ ምርቶች ዳታቤዝ ነው **በሁሉም ሰው የተሰራ ለሁሉም**።\nየተሻሉ የምግብ ምርጫዎችን ለማድረግ ሊጠቀሙበት ይችላሉ፣ እና **ክፍት ዳታ** እንደመሆኑ ማንኛውም ሰው ** ለማንኛውም ዓላማ እንደገና ሊጠቀምበት ይችላል**።';

  @override
  String get preferences_privacy_policy => 'የግላዊነት መመሪያ';

  @override
  String get preferences_licenses => 'ፍቃዶች';

  @override
  String get preferences_about_app_title => 'ስለ መተግበሪያው';

  @override
  String get preferences_about_app_subtitle => 'ቴክኒካዊ መረጃ፣ የገንቢ መረጃ እና ሌሎችም።';

  @override
  String get preferences_card_information => 'Information';

  @override
  String get preferences_version_number_title => 'የስሪት ቁጥር';

  @override
  String get preferences_scanner_title => 'ስካነር';

  @override
  String get preferences_app_store => 'የመተግበሪያ መደብር';

  @override
  String get preferences_app_system_settings => 'የስርዓት ቅንብሮች';

  @override
  String get preferences_source_code => 'የምንጭ ኮዱን ይድረሱ';

  @override
  String get preferences_source_code_subtitle =>
      'እና በሚሊዮኖች ለሚቆጠሩ ሰዎች ተጽእኖ መፍጠር ይጀምሩ';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Complete products';

  @override
  String get preferences_tips => 'ጠቃሚ ምክሮች';

  @override
  String get tips_discover_nutriscore => 'አዲሱን Nutri-Score ያግኙ';

  @override
  String get preferences_on_off_website_subtitle =>
      'በክፍት Open Food Facts ድህረ ገጽ ላይ';

  @override
  String get preferences_manage_account_title => 'መለያዬን አስተዳድር';

  @override
  String get preferences_manage_account_tooltip => 'መለያህን አስተዳድር';

  @override
  String get preferences_change_password_title => 'የይለፍ ቃሌን ቀይር';

  @override
  String get preferences_danger_zone => 'አደገኛ ዞን';

  @override
  String get preferences_account_deletion_subtitle => 'ሁሉም የእርስዎ አስተዋጽዖዎች ይጠፋሉ';

  @override
  String get preferences_contributions_title => 'Contributions';

  @override
  String get preferences_dev_mode_app_settings_title => 'የመተግበሪያ ቅንብሮች';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'ከመስመር ውጭ ምርቶችን ለመቃኘት በጣም የሙከራ መንገድ';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'ሁሉንም ምርቶች ከአገልጋዩ ያድሱ';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'በጣም አስፈላጊ ካልሆነ በስተቀር እባክዎ ያንን ከማድረግ ይቆጠቡ';

  @override
  String get preferences_dev_mode_demo_mode_title => 'የማሳያ ሁነታ';

  @override
  String get preferences_dev_mode_add_cards_title => 'ካርዶችን ወደ ስካነር ያክሉ';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      '3 ናሙና ምርቶችን ወደ ስካነር ያክላል';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'Folksonomy አስተናጋጅ';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'አስተናጋጅ: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'የተደራሽነት ሙከራዎች';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'ባለብዙ-ምርቶች ለዋጋ ምርጫ';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'በተጠቃሚ የታዘዙ የእውቀት ፓነሎች';

  @override
  String get preferences_dev_mode_location_search_title =>
      'የአካባቢ ፍለጋ ጊዜያዊ መዳረሻ';

  @override
  String get preferences_dev_mode_comparison_title =>
      'ለ 2 ወይም 3 ምርቶች ጎን ለጎን ማነፃፀር';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'የምርት ዝርዝር ማስመጣት';

  @override
  String get preferences_faq_scores_methodologies_title => 'ውጤቶች እና ዘዴዎች';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Nutri-Score እንዴት እንደሚሰላ ይወቁ';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'በአሰራር ዘዴው ላይ ዋና ለውጦችን ያግኙ';

  @override
  String get preferences_faq_discover_project_title => 'Discover the project';

  @override
  String get preferences_faq_discover_off_title => 'ክፍት Open Food Factsን ያግኙ';

  @override
  String get preferences_faq_discover_obf_title => 'ክፍት የውበት እውነታዎችን ያግኙ';

  @override
  String get preferences_faq_discover_opff_title =>
      'የክፍት የቤት እንስሳት ምግብ እውነታዎችን ያግኙ';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title => 'የክፍት ምርቶች እውነታዎችን ያግኙ';

  @override
  String get preferences_faq_faq_title => 'ተደጋጋሚ ጥያቄዎች - ተዘውትረው የሚጠየቁ ጥያቄዎች';

  @override
  String get preferences_faq_off_ngo_title =>
      'ክፍት Open Food Facts መንግሥታዊ ያልሆነ ድርጅት';

  @override
  String get preferences_about_information_title => 'Information';

  @override
  String get preferences_connect_community_updates_title =>
      'የማህበረሰብ ዝመናዎችን ያግኙ';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'ከመተግበሪያ እና ከማህበረሰብ ዜና ጋር እንደተገናኙ ይቆዩ';

  @override
  String get preferences_connect_community_calendar_title =>
      'ለማህበረሰብ የቀን መቁጠሪያችን ይመዝገቡ';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'ከምናባዊ ዝግጅቶቻችን በአንዱ በመገኘት ይሳተፉ';

  @override
  String get preferences_connect_blog_title => 'ክፍት Open Food Facts ብሎግ';

  @override
  String get preferences_connect_blog_subtitle => 'እንደሚከሰቱ የቅርብ ጊዜ ዜናዎችን ያግኙ';

  @override
  String get preferences_connect_community_help_title => 'ከማህበረሰቡ እርዳታ ያግኙ';

  @override
  String get preferences_connect_improve_app_title => 'መተግበሪያውን እንድናሻሽል ያግዙን።';

  @override
  String get preferences_connect_debug_info_title => 'የማረም መረጃ ላኩልን።';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'ዝርዝር የማረሚያ መረጃ የያዘ ኢሜይል ላኩልን።';

  @override
  String get preferences_connect_feedback_title => 'ስለ መተግበሪያው ግብረመልስ ይላኩልን።';

  @override
  String get preferences_connect_feedback_subtitle =>
      'የመተግበሪያውን የወደፊት ሁኔታ ለመቅረጽ ያግዙ';

  @override
  String get preferences_connect_survey_title => 'የመተግበሪያ ዳሰሳውን ይውሰዱ';

  @override
  String get preferences_connect_survey_subtitle =>
      'ቀጥሎ ምን መገንባት እንዳለብን እንድንረዳ እርዳን';

  @override
  String get preferences_connect_professionals_title => 'ባለሙያዎች';

  @override
  String get preferences_connect_pro_subtitle =>
      'ሙሉ በሙሉ ነፃ፣ ለ500 መተግበሪያዎች እና በሚሊዮኖች ለሚቆጠሩ ሸማቾች ትክክለኛ መረጃን ያረጋግጣል። የራስ አገልግሎት፣ ከእርስዎ PIM ወይም የተመን ሉህ (XLSX) ጋር ተኳሃኝ';

  @override
  String get preferences_connect_pro_email_subtitle => 'ለመጀመር ተገናኝ';

  @override
  String get preferences_connect_press_title => 'Press';

  @override
  String get preferences_connect_press_page_subtitle =>
      'ለሪፖርትዎ የሚያስፈልጉዎትን ነገሮች በሙሉ ያግኙ';

  @override
  String get preferences_connect_press_email_subtitle =>
      'ለጋዜጣዊ ጥያቄዎች ያነጋግሩ ወይም ስለ ሪፖርትዎ ለእኛ ያሳውቁን።';

  @override
  String get preferences_contribute_active_volunteer_title => 'ንቁ ፈቃደኛ ሁን';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'ልማት፣ ኮሙኒኬሽን፣ ዲዛይን… ማንኛውም አይነት በጎ ፈቃደኝነት ወይም እውቀት በደስታ ይቀበላሉ!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'አስተዋጽዖ ማድረግ ከሚችሉባቸው በርካታ መንገዶች መካከል አንዳንዶቹን ያግኙ';

  @override
  String get preferences_contribute_mobile_dev_title => 'የሞባይል መተግበሪያ ልማት';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'ለሶፍትዌር ልማት እንዴት አስተዋፅዖ ማድረግ እንደሚችሉ ይወቁ';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'ዕለታዊ ያልተረጋጉ ግንባታዎች፣ አዲስ ባህሪያት';

  @override
  String get preferences_contribute_local_community_title =>
      'የአካባቢዎን ማህበረሰብ ያሳድጉ';

  @override
  String get preferences_contribute_translate_subtitle =>
      'በሶፍትዌር፣ ይዘቶች፣ የንጥረ ነገር ትንተና ትርጉሞች እገዛ';

  @override
  String get preferences_contribute_share_subtitle =>
      'እርስዎን ለመርዳት ትንሽ አብነት አዘጋጅተናል :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'በአገርዎ ውስጥ የምግብ ግልፅነትን ለማሳደግ ቀላል እርምጃዎች';

  @override
  String get preferences_contribute_data_quality_title => 'የውሂብ ጥራት';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'የውሂብ ጥራት ቡድኑን ይቀላቀሉ';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'የመረጃ ቋቱ የተሟላ እና ትክክለኛ መሆኑን ለማረጋገጥ ጥረታችንን ይቀላቀሉ';

  @override
  String get preferences_contributions_products_added_title => 'የተጨመሩ ምርቶች';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'ወደ ክፈት Open Food Facts ያከልኳቸው አዳዲስ ምርቶች';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'ለማጠናቀቅ የሚያስፈልጉኝ ምርቶች';

  @override
  String get preferences_contributions_all_incomplete_title => 'ሁሉም ያልተሟሉ ምርቶች';

  @override
  String get preferences_my_contributions_prices_title => 'ዋጋዎች';

  @override
  String get preferences_my_contributions_my_prices_title => 'የእኔ ዋጋዎች';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'የኔ ዋጋ፣ ማስረጃዎቼ…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'ሊረዷቸው የሚችሏቸው ምርቶች ለማጠናቀቅ';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'በአገርዎ ያለውን Nutri-Score እና Green-Score ለማስላት ያግዙ';

  @override
  String get preferences_prices_user_prices_subtitle => 'ያበረከትኳቸው ዋጋዎች';

  @override
  String get preferences_prices_proofs_subtitle => 'የዋጋ መለያዎች እና ደረሰኞች';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'የእርስዎን ደረሰኞች ፎቶዎች ያንሱ እና ተዛማጅ ባርኮዶችን ይቃኙ';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'በአንድ ሱቅ ውስጥ የዋጋ ፎቶዎችን ያንሱ';

  @override
  String get preferences_prices_newest_title => 'አዳዲስ ዋጋዎች';

  @override
  String get preferences_prices_newest_subtitle =>
      'በOpen Prices ማህበረሰብ የታከሉ የቅርብ ጊዜ ዋጋዎች';

  @override
  String get preferences_prices_top_contributors_title =>
      'ብዙ ዋጋ ያላቸው አስተዋጽዖ አበርካቾች';

  @override
  String get preferences_prices_metrics_title => 'የዋጋ መለኪያዎችን ይክፈቱ';

  @override
  String get preferences_prices_metrics_subtitle => 'የፕሮጀክቱን ዝግመተ ለውጥ ተከተል';

  @override
  String get preferences_prices_ways_contribute_title => 'የማዋጣት መንገዶች';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'በ AI እገዛ በራስዎ ወይም በሌሎች የተጨመሩትን ዋጋዎች ያረጋግጡ';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'ከካሜራ ጥቅልዎ ብዙ ደረሰኞችን ወይም የመደርደሪያ ፎቶዎችን በፍጥነት ያክሉ';

  @override
  String get preferences_prices_challenges_title => 'ወርሃዊ ፈተናዎች';

  @override
  String get preferences_prices_challenges_subtitle =>
      'ዋጋዎችን ለመሰብሰብ በወርሃዊ ጭብጥ ተልዕኮዎች ውስጥ ይሳተፉ';

  @override
  String get preferences_prices_loyalty_data_title => 'የታማኝነት ውሂብዎን መልሰው ያግኙ';

  @override
  String get preferences_prices_gdpr_subtitle => 'የእርስዎን ውሂብ እንዴት እንደሚጠይቁ ይወቁ';

  @override
  String get preferences_page_customize_app_title => 'መተግበሪያውን ያብጁ';

  @override
  String get preferences_page_contribute_project_title => 'ለፕሮጀክቱ አስተዋፅኦ ያድርጉ';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Open Food Facts የሚረዱ ቀላል መንገዶች';

  @override
  String get preferences_page_faq_subtitle =>
      'ስለ ፕሮጀክቱ ዘዴዎች፣ እገዛ እና ሌሎችንም አስቆጥሩ';

  @override
  String get product_edit_robotoff_positive_button => 'ጥቆማ ተቀበል';

  @override
  String get product_edit_robotoff_negative_button => 'ጥቆማን አትቀበል';

  @override
  String get product_edit_robotoff_show_proof => 'ማስረጃ አሳይ';

  @override
  String get product_edit_robotoff_expand_proof => 'ማስረጃን ዘርጋ';

  @override
  String get product_page_tab_raw_data => 'ጥሬ መረጃ';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'ገጽ $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'ገጽ $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count ከ $total እቃዎች';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count ከ $total እቃዎች';
  }

  @override
  String item_count(int count) {
    return '$count እቃዎች';
  }

  @override
  String item_count_string(String count) {
    return '$count እቃዎች';
  }

  @override
  String get prices_no_result => 'ምንም የዋጋ ስታቲስቲክስ አልተገኘም።';

  @override
  String get prices_error_loading_more_items => 'ተጨማሪ ንጥሎችን መጫን ላይ ስህተት';

  @override
  String get prices_proof_error => 'ማረጋገጥ አልተሳካም፣ ማስረጃዎችን ማምጣት አልተቻለም';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count የ $total ማስረጃዎች';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count የ $total አበርካቾች';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count የ $total ቦታዎች';
  }

  @override
  String prices_locations_count(int count) {
    return '$count ቦታዎች';
  }

  @override
  String get restart_to_apply_message =>
      'ለውጦቹን ተግባራዊ ለማድረግ እባክዎ መተግበሪያውን እንደገና ያስጀምሩ።';

  @override
  String get preferences_app_settings_graphical_interface_title => 'ግራፊክ በይነገጽ';

  @override
  String get preferences_app_settings_media_title => 'ሚዲያ';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Open Food Facts ቤተሙከራዎችን ይክፈቱ';

  @override
  String get preferences_root_account_title => 'መለያ';

  @override
  String get preferences_contribute_translate_header =>
      'ክፍት Open Food Factsን ወደ ቋንቋዎ አምጡ';

  @override
  String get preferences_contribute_enroll_alpha =>
      'በመተግበሪያው የአልፋ ስሪት ውስጥ ይመዝገቡ';

  @override
  String get preferences_dev_mode_section_data => 'አስተዋጽዖ እና የምርት ውሂብ';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Folksonomy አታሳይ';

  @override
  String get preferences_account_title => 'መለያ';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '$createdላይ ተጨምሯል።';
  }

  @override
  String get location_map_details_title => 'የአካባቢ ዝርዝሮች';

  @override
  String get location_map_details_name => 'ስም';

  @override
  String get location_map_details_street => 'ጎዳና';

  @override
  String get location_map_details_city => 'ከተማ';

  @override
  String get location_map_details_postcode => 'የፖስታ ኮድ';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'መጋጠሚያዎች';

  @override
  String get location_map_details_osm_id => 'የOSM መታወቂያ';
}
