import 'dart:js_interop';

import 'js_interop.dart';

// ignore_for_file: non_constant_identifier_names
typedef Pointer = int;

/// Typed wrappers around the symbols exported by SQLite.
///
/// Generated by `tool/generate_bindings.dart`.
extension type SqliteExports(JSObject raw) implements JSObject {
  external Global get sqlite3_temp_directory;
  external int sqlite3_initialize();
  external void sqlite3_free(Pointer /*<void *>*/ arg0);
  external int sqlite3_open_v2(
    Pointer /*<struct sqlite3_char *>*/ filename,
    Pointer /*<struct sqlite3 * *>*/ ppDb,
    int flags,
    Pointer /*<struct sqlite3_char *>*/ zVfs,
  );
  external int sqlite3_close_v2(Pointer /*<struct sqlite3 *>*/ db);
  external int sqlite3_extended_result_codes(
    Pointer /*<struct sqlite3 *>*/ db,
    int onoff,
  );
  external int sqlite3_extended_errcode(Pointer /*<struct sqlite3 *>*/ db);
  external Pointer /*<struct sqlite3_char *>*/ sqlite3_errmsg(
    Pointer /*<struct sqlite3 *>*/ db,
  );
  external Pointer /*<struct sqlite3_char *>*/ sqlite3_errstr(int code);
  external int sqlite3_error_offset(Pointer /*<struct sqlite3 *>*/ db);
  external Pointer /*<struct sqlite3_char *>*/ sqlite3_libversion();
  external Pointer /*<struct sqlite3_char *>*/ sqlite3_sourceid();
  external int sqlite3_libversion_number();
  external JSBigInt sqlite3_last_insert_rowid(
    Pointer /*<struct sqlite3 *>*/ db,
  );
  external int sqlite3_changes(Pointer /*<struct sqlite3 *>*/ db);
  external int sqlite3_exec(
    Pointer /*<struct sqlite3 *>*/ db,
    Pointer /*<struct sqlite3_char *>*/ sql,
    Pointer /*<void *>*/ callback,
    Pointer /*<void *>*/ argToCb,
    Pointer /*<struct sqlite3_char * *>*/ errorOut,
  );
  external int sqlite3_get_autocommit(Pointer /*<struct sqlite3 *>*/ db);
  external int sqlite3_prepare_v2(
    Pointer /*<struct sqlite3 *>*/ db,
    Pointer /*<struct sqlite3_char *>*/ zSql,
    int nByte,
    Pointer /*<struct sqlite3_stmt * *>*/ ppStmt,
    Pointer /*<struct sqlite3_char * *>*/ pzTail,
  );
  external int sqlite3_prepare_v3(
    Pointer /*<struct sqlite3 *>*/ db,
    Pointer /*<struct sqlite3_char *>*/ zSql,
    int nByte,
    int prepFlags,
    Pointer /*<struct sqlite3_stmt * *>*/ ppStmt,
    Pointer /*<struct sqlite3_char * *>*/ pzTail,
  );
  external int sqlite3_finalize(Pointer /*<struct sqlite3_stmt *>*/ pStmt);
  external int sqlite3_step(Pointer /*<struct sqlite3_stmt *>*/ pStmt);
  external int sqlite3_reset(Pointer /*<struct sqlite3_stmt *>*/ pStmt);
  external int sqlite3_stmt_isexplain(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
  );
  external int sqlite3_stmt_readonly(Pointer /*<struct sqlite3_stmt *>*/ pStmt);
  external int sqlite3_column_count(Pointer /*<struct sqlite3_stmt *>*/ pStmt);
  external int sqlite3_bind_parameter_count(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
  );
  external int sqlite3_bind_parameter_index(
    Pointer /*<struct sqlite3_stmt *>*/ arg0,
    Pointer /*<struct sqlite3_char *>*/ zName,
  );
  external Pointer /*<struct sqlite3_char *>*/ sqlite3_column_name(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
    int N,
  );
  external int sqlite3_bind_double(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
    int index,
    double data,
  );
  external int sqlite3_bind_int64(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
    int index,
    JSBigInt data,
  );
  external int sqlite3_bind_null(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
    int index,
  );
  external Pointer /*<void *>*/ sqlite3_column_blob(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
    int iCol,
  );
  external double sqlite3_column_double(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
    int iCol,
  );
  external JSBigInt sqlite3_column_int64(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
    int iCol,
  );
  external Pointer /*<struct sqlite3_char *>*/ sqlite3_column_text(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
    int iCol,
  );
  external int sqlite3_column_bytes(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
    int iCol,
  );
  external int sqlite3_column_type(
    Pointer /*<struct sqlite3_stmt *>*/ pStmt,
    int iCol,
  );
  external Pointer /*<void *>*/ sqlite3_value_blob(
    Pointer /*<struct sqlite3_value *>*/ value,
  );
  external double sqlite3_value_double(
    Pointer /*<struct sqlite3_value *>*/ value,
  );
  external int sqlite3_value_type(Pointer /*<struct sqlite3_value *>*/ value);
  external JSBigInt sqlite3_value_int64(
    Pointer /*<struct sqlite3_value *>*/ value,
  );
  external Pointer /*<struct sqlite3_char *>*/ sqlite3_value_text(
    Pointer /*<struct sqlite3_value *>*/ value,
  );
  external int sqlite3_value_bytes(Pointer /*<struct sqlite3_value *>*/ value);
  external int sqlite3_value_subtype(
    Pointer /*<struct sqlite3_value *>*/ value,
  );
  external Pointer /*<void *>*/ sqlite3_aggregate_context(
    Pointer /*<struct sqlite3_context *>*/ ctx,
    int nBytes,
  );
  external Pointer /*<void *>*/ sqlite3_user_data(
    Pointer /*<struct sqlite3_context *>*/ ctx,
  );
  external void sqlite3_result_blob64(
    Pointer /*<struct sqlite3_context *>*/ ctx,
    Pointer /*<void *>*/ data,
    JSBigInt length,
    Pointer /*<void *>*/ destructor,
  );
  external void sqlite3_result_double(
    Pointer /*<struct sqlite3_context *>*/ ctx,
    double result,
  );
  external void sqlite3_result_error(
    Pointer /*<struct sqlite3_context *>*/ ctx,
    Pointer /*<struct sqlite3_char *>*/ msg,
    int length,
  );
  external void sqlite3_result_int64(
    Pointer /*<struct sqlite3_context *>*/ ctx,
    JSBigInt result,
  );
  external void sqlite3_result_null(Pointer /*<struct sqlite3_context *>*/ ctx);
  external void sqlite3_result_text(
    Pointer /*<struct sqlite3_context *>*/ ctx,
    Pointer /*<struct sqlite3_char *>*/ data,
    int length,
    Pointer /*<void *>*/ destructor,
  );
  external void sqlite3_result_subtype(
    Pointer /*<struct sqlite3_context *>*/ ctx,
    int subtype,
  );
  external int sqlite3_db_config(Pointer /*<struct sqlite3 *>*/ db, int op);
  external int sqlite3session_create(
    Pointer /*<struct sqlite3 *>*/ db,
    Pointer /*<struct sqlite3_char *>*/ zDb,
    Pointer /*<struct sqlite3_session * *>*/ ppSession,
  );
  external void sqlite3session_delete(
    Pointer /*<struct sqlite3_session *>*/ pSession,
  );
  external int sqlite3session_enable(
    Pointer /*<struct sqlite3_session *>*/ pSession,
    int bEnable,
  );
  external int sqlite3session_indirect(
    Pointer /*<struct sqlite3_session *>*/ pSession,
    int bIndirect,
  );
  external int sqlite3changeset_start(
    Pointer /*<struct sqlite3_changeset_iter * *>*/ pp,
    int nChangeset,
    Pointer /*<void *>*/ pChangeset,
  );
  external int sqlite3changeset_finalize(
    Pointer /*<struct sqlite3_changeset_iter *>*/ pIter,
  );
  external int sqlite3changeset_next(
    Pointer /*<struct sqlite3_changeset_iter *>*/ pIter,
  );
  external int sqlite3changeset_op(
    Pointer /*<struct sqlite3_changeset_iter *>*/ pIter,
    Pointer /*<struct sqlite3_char * *>*/ pzTab,
    Pointer /*<int *>*/ pnCol,
    Pointer /*<int *>*/ pOp,
    Pointer /*<int *>*/ pbIndirect,
  );
  external int sqlite3changeset_old(
    Pointer /*<struct sqlite3_changeset_iter *>*/ pIter,
    int iVal,
    Pointer /*<struct sqlite3_value * *>*/ ppValue,
  );
  external int sqlite3changeset_new(
    Pointer /*<struct sqlite3_changeset_iter *>*/ pIter,
    int iVal,
    Pointer /*<struct sqlite3_value * *>*/ ppValue,
  );
  external int sqlite3changeset_invert(
    int nIn,
    Pointer /*<void *>*/ pIn,
    Pointer /*<int *>*/ pnOut,
    Pointer /*<void * *>*/ ppOut,
  );
  external int sqlite3session_patchset(
    Pointer /*<struct sqlite3_session *>*/ pSession,
    Pointer /*<int *>*/ pnPatchset,
    Pointer /*<void * *>*/ ppPatchset,
  );
  external int sqlite3session_changeset(
    Pointer /*<struct sqlite3_session *>*/ pSession,
    Pointer /*<int *>*/ pnChangeset,
    Pointer /*<void * *>*/ ppChangeset,
  );
  external int sqlite3session_isempty(
    Pointer /*<struct sqlite3_session *>*/ pSession,
  );
  external int sqlite3session_attach(
    Pointer /*<struct sqlite3_session *>*/ pSession,
    Pointer /*<struct sqlite3_char *>*/ zTab,
  );
  external int sqlite3session_diff(
    Pointer /*<struct sqlite3_session *>*/ pSession,
    Pointer /*<struct sqlite3_char *>*/ zFromDb,
    Pointer /*<struct sqlite3_char *>*/ zTbl,
    Pointer /*<struct sqlite3_char * *>*/ pzErrMsg,
  );
  external Pointer /*<void *>*/ dart_sqlite3_malloc(int size);
  external void dart_sqlite3_free(Pointer /*<void *>*/ ptr);
  external int dart_sqlite3_bind_blob(
    Pointer /*<struct sqlite3_stmt *>*/ stmt,
    int index,
    Pointer /*<void *>*/ buf,
    int len,
  );
  external int dart_sqlite3_bind_text(
    Pointer /*<struct sqlite3_stmt *>*/ stmt,
    int index,
    Pointer /*<char *>*/ buf,
    int len,
  );
  external Pointer /*<struct sqlite3_vfs *>*/ dart_sqlite3_register_vfs(
    Pointer /*<char *>*/ name,
    ExternalDartReference<Object>? vfs,
    int makeDefault,
  );
  external int dart_sqlite3_unregister_vfs(
    Pointer /*<struct sqlite3_vfs *>*/ vfs,
  );
  external int dart_sqlite3_create_function_v2(
    Pointer /*<struct sqlite3 *>*/ db,
    Pointer /*<char *>*/ zFunctionName,
    int nArg,
    int eTextRep,
    int isAggregate,
    ExternalDartReference<Object>? handlers,
  );
  external int dart_sqlite3_create_window_function(
    Pointer /*<struct sqlite3 *>*/ db,
    Pointer /*<char *>*/ zFunctionName,
    int nArg,
    int eTextRep,
    ExternalDartReference<Object>? handlers,
  );
  external void dart_sqlite3_updates(
    Pointer /*<struct sqlite3 *>*/ db,
    ExternalDartReference<Object>? callback,
  );
  external void dart_sqlite3_commits(
    Pointer /*<struct sqlite3 *>*/ db,
    ExternalDartReference<Object>? callback,
  );
  external void dart_sqlite3_rollbacks(
    Pointer /*<struct sqlite3 *>*/ db,
    ExternalDartReference<Object>? callback,
  );
  external int dart_sqlite3_create_collation(
    Pointer /*<struct sqlite3 *>*/ db,
    Pointer /*<char *>*/ zName,
    int eTextRep,
    ExternalDartReference<Object>? function,
  );
  external int dart_sqlite3_db_config_int(
    Pointer /*<struct sqlite3 *>*/ db,
    int op,
    int arg,
  );
  external int dart_sqlite3changeset_apply(
    Pointer /*<struct sqlite3 *>*/ db,
    int nChangeset,
    Pointer /*<void *>*/ pChangeset,
    ExternalDartReference<Object>? callbacks,
    int filter,
  );
  external int dart_sqlite3_busy_handler(
    Pointer /*<struct sqlite3 *>*/ db,
    ExternalDartReference<Object>? callback,
  );
}
