#ifndef _RIVE_DASH_PATH_HPP_
#define _RIVE_DASH_PATH_HPP_
#include "rive/generated/shapes/paint/dash_path_base.hpp"

#include "rive/shapes/paint/shape_paint.hpp"
#include "rive/shapes/paint/stroke_effect.hpp"
#include "rive/shapes/paint/stroke_effect.hpp"
#include "rive/shapes/shape_paint_path.hpp"
#include "rive/renderer.hpp"
#include "rive/math/raw_path.hpp"
#include "rive/math/path_measure.hpp"
#include <vector>

namespace rive
{
class Dash;
class PathDasher
{
    friend class Dash;

protected:
    void invalidateSourcePath();
    virtual void invalidateDash();
    ShapePaintPath* dash(const RawPath* source,
                         Dash* offset,
                         Span<Dash*> dashes);
    ShapePaintPath* applyDash(const RawPath* source,
                              Dash* offset,
                              Span<Dash*> dashes);

protected:
    ShapePaintPath m_path;
    PathMeasure m_pathMeasure;

public:
    float pathLength() const;
    virtual ~PathDasher() {}
};

class DashPath : public DashPathBase, public PathDasher, public StrokeEffect
{
public:
    StatusCode onAddedClean(CoreContext* context) override;
    void invalidateEffect() override;
    void offsetChanged() override;
    void offsetIsPercentageChanged() override;
    void updateEffect(const ShapePaintPath* source,
                      ShapePaintType shapePaintType) override;
    ShapePaintPath* effectPath() override;
    void invalidateDash() override;
    ShapePaint* parentPaint() override
    {
        return parent() != nullptr ? parent()->as<ShapePaint>() : nullptr;
    }

private:
    std::vector<Dash*> m_dashes;
};
} // namespace rive
#endif