import "../iso_locale_mapper.dart";

/// Contains 250 translation(s).
/// Provides translations for the Arabic language
/// locale.
class ArCountriesL10N extends IsoLocaleMapper<String> {
  /// Provides country translations for the `ar` locale.
  ArCountriesL10N() {
    map.addAll({
      "ABW": "أروبا",
      "ABW+": "أروبا",
      "AFG": "أفغانستان",
      "AFG+": "جمهورية أففانستان الإسلامية",
      "AGO": "جمهورية أنغولا",
      "AGO+": "أنغولا",
      "AIA": "أنغويلا",
      "AIA+": "أنغويلا",
      "ALA": "جزر أولاند",
      "ALA+": "جزر أولاند",
      "ALB": "ألبانيا",
      "ALB+": "جمهورية ألبانيا",
      "AND": "أندورا",
      "AND+": "إمارة أندورا",
      "ARE": "دولة الإمارات العربية المتحدة",
      "ARE+": "الإمارات العربية المتحدة",
      "ARG": "الأرجنتين",
      "ARG+": "جمهورية الأرجنتين",
      "ARM": "أرمينيا",
      "ARM+": "جمهورية أرمينيا",
      "ASM": "ساموا الأمريكية",
      "ASM+": "ساموا الأمريكية",
      "ATA": "أنتارتيكا",
      "ATA+": "أنتارتيكا",
      "ATF": "أراض فرنسية جنوبية وأنتارتيكية",
      "ATF+": "مقاطعات وأقاليم ما وراء البحار الفرنسية",
      "ATG": "أنتيغوا وباربودا",
      "ATG+": "أنتيغوا وباربودا",
      "AUS": "أستراليا",
      "AUS+": "كومونولث أستراليا",
      "AUT": "النمسا",
      "AUT+": "جمهورية النمسا",
      "AZE": "أذربيجان",
      "AZE+": "جمهورية أذربيجان",
      "BDI": "بوروندي",
      "BDI+": "جمهورية بوروندي",
      "BEL": "بلجيكا",
      "BEL+": "مملكة بلجيكا",
      "BEN": "بنين",
      "BEN+": "جمهورية بنين",
      "BES": "الجزر الكاريبية الهولندية",
      "BES+": "بونير وسينت أوستاتيوس وسابا",
      "BFA": "بوركينا فاسو",
      "BFA+": "بوركينا فاسو",
      "BGD": "بنغلاديش",
      "BGD+": "جمهورية بنغلاديش الشعبية",
      "BGR": "بلغاريا",
      "BGR+": "جمهورية بلغاريا",
      "BHR": "‏البحرين",
      "BHR+": "مملكة البحرين",
      "BHS": "باهاماس",
      "BHS+": "كومنولث جزر البهاما",
      "BIH": "البوسنة والهرسك",
      "BIH+": "جمهورية البوسنة والهرسك",
      "BLM": "سان بارتليمي",
      "BLM+": "التجمع الإقليمي لسانت بارتيليمي",
      "BLR": "بيلاروسيا",
      "BLR+": "جمهورية بيلاروسيا",
      "BLZ": "بليز",
      "BLZ+": "بليز",
      "BMU": "برمودا",
      "BMU+": "برمودا",
      "BOL": "بوليفيا",
      "BOL+": "دولة بوليفيا المتعددة القوميات",
      "BRA": "البرازيل",
      "BRA+": "جمهورية البرازيل الاتحادية",
      "BRB": "باربادوس",
      "BRB+": "باربادوس",
      "BRN": "بروناي",
      "BRN+": "بروناي دار السلام",
      "BTN": "بوتان",
      "BTN+": "مملكة بوتان",
      "BVT": "جزر بوفيه",
      "BVT+": "جزر بوفيه",
      "BWA": "بوتسوانا",
      "BWA+": "جمهورية بوتسوانا",
      "CAF": "جمهورية أفريقيا الوسطى",
      "CAF+": "جمهورية أفريقيا الوسطى",
      "CAN": "كندا",
      "CAN+": "كندا",
      "CCK": "جزر كوكوس",
      "CCK+": "إقليم جزر كوكوس",
      "CHE": "سويسرا",
      "CHE+": "الاتحاد السويسري",
      "CHL": "تشيلي",
      "CHL+": "جمهورية تشيلي",
      "CHN": "الصين",
      "CHN+": "جمهورية الصين الشعبية",
      "CIV": "ساحل العاج",
      "CIV+": "جمهورية ساحل العاج",
      "CMR": "الكاميرون",
      "CMR+": "جمهورية الكاميرون",
      "COD": "الكونغو",
      "COD+": "جمهورية الكونغو الديمقراطية",
      "COG": "جمهورية الكونفو",
      "COG+": "جمهورية الكونغو",
      "COK": "جزر كوك",
      "COK+": "جزر كوك",
      "COL": "كولومبيا",
      "COL+": "جمهورية كولومبيا",
      "COM": "جزر القمر",
      "COM+": "الإتحاد القمري",
      "CPV": "كابو فيردي",
      "CPV+": "جمهورية كابو فيردي",
      "CRI": "كوستاريكا",
      "CRI+": "جمهورية كوستاريكا",
      "CUB": "كوبا",
      "CUB+": "جمهورية كوبا",
      "CUW": "كوراساو",
      "CUW+": "دولة كوراساو",
      "CXR": "جزيرة كريسماس",
      "CXR+": "جزيرة كريسماس",
      "CYM": "جزر كايمان",
      "CYM+": "جزر كايمان",
      "CYP": "قبرص",
      "CYP+": "جمهورية قبرص",
      "CZE": "التشيك",
      "CZE+": "جمهورية التشيك",
      "DEU": "ألمانيا",
      "DEU+": "جمهورية ألمانيا الاتحادية",
      "DJI": "جيبوتي",
      "DJI+": "جمهورية جيبوتي",
      "DMA": "دومينيكا",
      "DMA+": "كومونولث دومينيكا",
      "DNK": "الدنمارك",
      "DNK+": "مملكة الدنمارك",
      "DOM": "جمهورية الدومينيكان",
      "DOM+": "جمهورية الدومينيكان",
      "DZA": "الجزائر",
      "DZA+": "الجمهورية الديمقراطية الشعبية الجزائرية",
      "ECU": "الإكوادور",
      "ECU+": "جمهورية الإكوادور",
      "EGY": "مصر",
      "EGY+": "جمهورية مصر العربية",
      "ERI": "إريتريا",
      "ERI+": "دولة إريتريا",
      "ESH": "الصحراء الغربية",
      "ESH+": "الجمهورية العربية الصحراوية الديمقراطية",
      "ESP": "إسبانيا",
      "ESP+": "مملكة إسبانيا",
      "EST": "إستونيا",
      "EST+": "جمهورية إستونيا",
      "ETH": "إثيوبيا",
      "ETH+": "جمهورية إثيوبيا الفدرالية الديموقراطية",
      "FIN": "فنلندا",
      "FIN+": "جمهورية فنلندا",
      "FJI": "فيجي",
      "FJI+": "جمهورية جزر فيجي",
      "FLK": "جزر فوكلاند",
      "FLK+": "جزر فوكلاند",
      "FRA": "فرنسا",
      "FRA+": "الجمهورية الفرنسية",
      "FRO": "جزر فارو",
      "FRO+": "جزر فارو",
      "FSM": "ميكرونيسيا",
      "FSM+": "ولايات ميكرونيسيا المتحدة",
      "GAB": "الغابون",
      "GAB+": "جمهورية الغابون",
      "GBR": "المملكة المتحدة",
      "GBR+": "المملكة المتحدة لبريطانيا العظمى وايرلندا الشمالية",
      "GEO": "جورجيا",
      "GEO+": "جورجيا",
      "GGY": "غيرنزي",
      "GGY+": "غيرنزي",
      "GHA": "غانا",
      "GHA+": "جمهورية غانا",
      "GIB": "جبل طارق",
      "GIB+": "جبل طارق",
      "GIN": "غينيا",
      "GIN+": "جمهورية غينيا",
      "GLP": "غوادلوب",
      "GLP+": "غوادلوب",
      "GMB": "غامبيا",
      "GMB+": "جمهورية غامبيا",
      "GNB": "غينيا بيساو",
      "GNB+": "جمهورية غينيا بيساو",
      "GNQ": "غينيا الاستوائية",
      "GNQ+": "جمهورية غينيا الاستوائية",
      "GRC": "اليونان",
      "GRC+": "الجمهورية الهيلينية",
      "GRD": "غرينادا",
      "GRD+": "غرينادا",
      "GRL": "جرينلاند",
      "GRL+": "جرينلاند",
      "GTM": "غواتيمالا",
      "GTM+": "جمهورية غواتيمالا",
      "GUF": "غويانا",
      "GUF+": "غويانا الفرنسية",
      "GUM": "غوام",
      "GUM+": "غوام",
      "GUY": "غيانا",
      "GUY+": "جمهورية غيانا التعاونية",
      "HKG": "هونغ كونغ",
      "HKG+": "منطقة هونغ كونغ الادارية التابعة لجمهورية الصين الشعبية",
      "HMD": "جزيرة هيرد وجزر ماكدونالد",
      "HMD+": "جزيرة هيرد وجزر ماكدونالد",
      "HND": "هندوراس",
      "HND+": "جمهورية هندوراس",
      "HRV": "كرواتيا",
      "HRV+": "جمهورية كرواتيا",
      "HTI": "هايتي",
      "HTI+": "جمهورية هايتي",
      "HUN": "المجر",
      "HUN+": "الجمهورية المجرية",
      "IDN": "إندونيسيا",
      "IDN+": "جمهورية إندونيسيا",
      "IMN": "جزيرة مان",
      "IMN+": "جزيرة مان",
      "IND": "الهند",
      "IND+": "جمهورية الهند",
      "IOT": "إقليم المحيط الهندي البريطاني",
      "IOT+": "إقليم المحيط الهندي البريطاني",
      "IRL": "أيرلندا",
      "IRL+": "جمهورية أيرلندا",
      "IRN": "إيران",
      "IRN+": "جمهورية إيران الإسلامية",
      "IRQ": "العراق",
      "IRQ+": "جمهورية العراق",
      "ISL": "آيسلندا",
      "ISL+": "آيسلندا",
      "ISR": "إسرائيل",
      "ISR+": "دولة إسرائيل",
      "ITA": "إيطاليا",
      "ITA+": "الجمهورية الإيطالية",
      "JAM": "جامايكا",
      "JAM+": "جامايكا",
      "JEY": "جيرزي",
      "JEY+": "جيرزي",
      "JOR": "الأردن",
      "JOR+": "المملكة الأردنية الهاشمية",
      "JPN": "اليابان",
      "JPN+": "اليابان",
      "KAZ": "كازاخستان",
      "KAZ+": "جمهورية كازاخستان",
      "KEN": "كينيا",
      "KEN+": "جمهورية كينيا",
      "KGZ": "قيرغيزستان",
      "KGZ+": "الجمهورية القيرغيزية",
      "KHM": "كمبوديا",
      "KHM+": "مملكة كمبوديا",
      "KIR": "كيريباتي",
      "KIR+": "جمهورية كيريباتي",
      "KNA": "سانت كيتس ونيفيس",
      "KNA+": "اتحاد القديس كريستوفر ونيفيس",
      "KOR": "كوريا الجنوبية",
      "KOR+": "جمهورية كوريا",
      "KWT": "الكويت",
      "KWT+": "دولة الكويت",
      "LAO": "لاوس",
      "LAO+": "جمهورية لاوس الديمقراطية الشعبية",
      "LBN": "لبنان",
      "LBN+": "الجمهورية اللبنانية",
      "LBR": "ليبيريا",
      "LBR+": "جمهورية ليبيريا",
      "LBY": "‏ليبيا",
      "LBY+": "دولة ليبيا",
      "LCA": "سانت لوسيا",
      "LCA+": "سانت لوسيا",
      "LIE": "ليختنشتاين",
      "LIE+": "إمارة ليختنشتاين",
      "LKA": "سريلانكا",
      "LKA+": "جمهورية سريلانكا الديمقراطية الشعبية",
      "LSO": "ليسوتو",
      "LSO+": "مملكة ليسوتو",
      "LTU": "ليتوانيا",
      "LTU+": "جمهورية ليتوانيا",
      "LUX": "لوكسمبورغ",
      "LUX+": "دوقية لوكسمبورغ",
      "LVA": "لاتفيا",
      "LVA+": "جمهورية لاتفيا",
      "MAC": "ماكاو",
      "MAC+": "منطقة ماكاو الإدارية التابعة لجمهورية الصين الشعبية",
      "MAF": "سانت مارتن",
      "MAF+": "سانت مارتن",
      "MAR": "المغرب",
      "MAR+": "المملكة المغربية",
      "MCO": "موناكو",
      "MCO+": "إمارة موناكو",
      "MDA": "مولدوڤا",
      "MDA+": "جمهورية مولدوڤا",
      "MDG": "مدغشقر",
      "MDG+": "جمهورية مدغشقر",
      "MDV": "المالديف",
      "MDV+": "جمهورية المالديف",
      "MEX": "المسكيك",
      "MEX+": "الولايات المتحدة المكسيكية",
      "MHL": "جزر مارشال",
      "MHL+": "جمهورية جزر مارشال",
      "MKD": "شمال مقدونيا",
      "MKD+": "جمهورية شمال مقدونيا",
      "MLI": "مالي",
      "MLI+": "جمهورية مالي",
      "MLT": "مالطا",
      "MLT+": "جمهورية مالطا",
      "MMR": "ميانمار",
      "MMR+": "جمهورية اتحاد ميانمار",
      "MNE": "الجبل الاسود",
      "MNE+": "الجبل الاسود",
      "MNG": "منغوليا",
      "MNG+": "جمهورية منغوليا",
      "MNP": "جزر ماريانا الشمالية",
      "MNP+": "كومونولث جزر ماريانا الشمالية",
      "MOZ": "موزمبيق",
      "MOZ+": "جمهورية موزمبيق",
      "MRT": "موريتانيا",
      "MRT+": "الجمهورية الإسلامية الموريتانية",
      "MSR": "مونتسرات",
      "MSR+": "مونتسرات",
      "MTQ": "مارتينيك",
      "MTQ+": "مارتينيك",
      "MUS": "موريشيوس",
      "MUS+": "جمهورية موريشيوس",
      "MWI": "مالاوي",
      "MWI+": "جمهورية مالاوي",
      "MYS": "ماليزيا",
      "MYS+": "ماليزيا",
      "MYT": "مايوت",
      "MYT+": "مايوت",
      "NAM": "ناميبيا",
      "NAM+": "جمهورية ناميبيا",
      "NCL": "كاليدونيا الجديدة",
      "NCL+": "كاليدونيا الجديدة",
      "NER": "النيجر",
      "NER+": "جمهورية النيجر",
      "NFK": "جزيرة نورفولك",
      "NFK+": "إقليم جزيرة نورفولك",
      "NGA": "نيجيريا",
      "NGA+": "جمهورية نيجيريا الاتحادية",
      "NIC": "نيكاراغوا",
      "NIC+": "جمهورية نيكاراغوا",
      "NIU": "نييوي",
      "NIU+": "نييوي",
      "NLD": "هولندا",
      "NLD+": "مملكة هولندا",
      "NOR": "النرويج",
      "NOR+": "مملكة النرويج",
      "NPL": "نيبال",
      "NPL+": "جمهورية نيبال الديمقراطية الاتحادية",
      "NRU": "ناورو",
      "NRU+": "جمهورية ناورو",
      "NZL": "نيوزيلندا",
      "NZL+": "نيوزيلندا",
      "OMN": "عمان",
      "OMN+": "سلطنة عمان",
      "PAK": "باكستان",
      "PAK+": "جمهورية باكستان الإسلامية",
      "PAN": "بنما",
      "PAN+": "جمهورية بنما",
      "PCN": "جزر بيتكيرن",
      "PCN+": "جزر بيتكيرن",
      "PER": "بيرو",
      "PER+": "جمهورية بيرو",
      "PHL": "الفلبين",
      "PHL+": "جمهورية الفلبين",
      "PLW": "بالاو",
      "PLW+": "جمهورية بالاو",
      "PNG": "بابوا غينيا الجديدة",
      "PNG+": "دولة بابوا غينيا الجديدة",
      "POL": "بولندا",
      "POL+": "الجمهورية البولندية",
      "PRI": "بويرتوريكو",
      "PRI+": "كومنولث بويرتوريكو",
      "PRK": "كوريا الشمالية",
      "PRK+": "جمهورية كوريا الديمقراطية الشعبية",
      "PRT": "البرتغال",
      "PRT+": "الجمهورية البرتغالية",
      "PRY": "باراغواي",
      "PRY+": "جمهورية باراغواي",
      "PSE": "فلسطين",
      "PSE+": "دولة فلسطين",
      "PYF": "بولينزيا الفرنسية",
      "PYF+": "بولينزيا الفرنسية",
      "QAT": "قطر",
      "QAT+": "دولة قطر",
      "REU": "لا ريونيون",
      "REU+": "جزيرة لا ريونيون",
      "ROU": "رومانيا",
      "ROU+": "رومانيا",
      "RUS": "روسيا",
      "RUS+": "روسيا الاتحادية",
      "RWA": "رواندا",
      "RWA+": "جمهورية رواندا",
      "SAU": "السعودية",
      "SAU+": "المملكة العربية السعودية",
      "SDN": "السودان",
      "SDN+": "جمهورية السودان",
      "SEN": "السنغال",
      "SEN+": "جمهورية السنغال",
      "SGP": "سنغافورة",
      "SGP+": "جمهورية سنغافورة",
      "SGS": "جورجيا الجنوبية",
      "SGS+": "جورجيا الجنوبية وجزر ساندوتش الجنوبية",
      "SHN": "سانت هيلينا وأسينشين وتريستان دا كونا",
      "SHN+": "سانت هيلينا وأسينشين وتريستان دا كونا",
      "SJM": "سفالبارد ويان ماين",
      "SJM+": "سفالبارد ويان ماين",
      "SLB": "جزر سليمان",
      "SLB+": "جزر سليمان",
      "SLE": "سيراليون",
      "SLE+": "جمهورية سيراليون",
      "SLV": "السلفادور",
      "SLV+": "جمهورية السلفادور",
      "SMR": "سان مارينو",
      "SMR+": "جمهورية سان مارينو",
      "SOM": "الصومال",
      "SOM+": "جمهورية الصومال الفيدرالية",
      "SPM": "سان بيير وميكلون",
      "SPM+": "سان بيير وميكلون",
      "SRB": "صيربيا",
      "SRB+": "جمهورية صيربيا",
      "SSD": "جنوب السودان",
      "SSD+": "جمهورية جنوب السودان",
      "STP": "ساو تومي وبرينسيب",
      "STP+": "جمهورية ساو تومي وبرينسيب الديمقراطية",
      "SUR": "سورينام",
      "SUR+": "جمهورية سورينام",
      "SVK": "سلوفاكيا",
      "SVK+": "جمهورية سلوفاكيا",
      "SVN": "سلوفينيا",
      "SVN+": "جمهورية سلوفينيا",
      "SWE": "السويد",
      "SWE+": "مملكة السويد",
      "SWZ": "إسواتيني",
      "SWZ+": "مملكة إسواتيني",
      "SXM": "سينت مارتن",
      "SXM+": "سينت مارتن",
      "SYC": "سيشل",
      "SYC+": "جمهورية سيشل",
      "SYR": "سوريا",
      "SYR+": "الجمهورية العربية السورية",
      "TCA": "جزر توركس وكايكوس",
      "TCA+": "جزر توركس وكايكوس",
      "TCD": "تشاد",
      "TCD+": "جمهورية تشاد",
      "TGO": "توغو",
      "TGO+": "جمهورية توغو",
      "THA": "تايلند",
      "THA+": "مملكة تايلند",
      "TJK": "طاجيكستان",
      "TJK+": "جمهورية طاجيكستان",
      "TKL": "توكيلاو",
      "TKL+": "توكيلاو",
      "TKM": "تركمانستان",
      "TKM+": "تركمانستان",
      "TLS": "تيمور الشرقية",
      "TLS+": "جمهورية تيمور الشرقية الديمقراطية",
      "TON": "تونغا",
      "TON+": "مملكة تونغا",
      "TTO": "ترينيداد وتوباغو",
      "TTO+": "جمهورية ترينيداد وتوباغو",
      "TUN": "تونس",
      "TUN+": "الجمهورية التونسية",
      "TUR": "تركيا",
      "TUR+": "الجمهورية التركية",
      "TUV": "توفالو",
      "TUV+": "توفالو",
      "TWN": "تايوان",
      "TWN+": "جمهورية الصين (تايوان)",
      "TZA": "تنزانيا",
      "TZA+": "جمهورية تنزانيا الاتحادية",
      "UGA": "أوغندا",
      "UGA+": "جمهورية أوغندا",
      "UKR": "أوكرانيا",
      "UKR+": "أوكرانيا",
      "UMI": "جزر الولايات المتحدة الصغيرة النائية",
      "UMI+": "جزر الولايات المتحدة الصغيرة النائية",
      "UNK": "كوسوفو",
      "UNK+": "جمهورية كوسوفو",
      "URY": "الأوروغواي",
      "URY+": "جمهورية الأوروغواي الشرقية",
      "USA": "الولايات المتحدة",
      "USA+": "الولايات المتحدة الامريكية",
      "UZB": "أوزباكستان",
      "UZB+": "جمهورية أوزباكستان",
      "VAT": "مدينة الفاتيكان",
      "VAT+": "دولة مدينة الفاتيكان",
      "VCT": "سانت فينسنت والغرينادين",
      "VCT+": "سانت فينسنت والغرينادين",
      "VEN": "فنزويلا",
      "VEN+": "جمهورية فنزويلا البوليفارية",
      "VGB": "جزر العذراء",
      "VGB+": "جزر العذراء البريطانية",
      "VIR": "جزر العذراء الامريكية",
      "VIR+": "جزر العذراء الامريكية",
      "VNM": "فيتنام",
      "VNM+": "جمهورية فيتنام الاشتراكية",
      "VUT": "فانواتو",
      "VUT+": "جمهورية فانواتو",
      "WLF": "واليس وفوتونا",
      "WLF+": "إقليم جزر واليس وفوتونا",
      "WSM": "ساموا",
      "WSM+": "دولة ساموا المستقلة",
      "YEM": "اليمن",
      "YEM+": "الجمهورية اليمنية",
      "ZAF": "جنوب أفريقيا",
      "ZAF+": "جمهورية جنوب أفريقيا",
      "ZMB": "زامبيا",
      "ZMB+": "جمهورية زامبيا",
      "ZWE": "زيمبابوي",
      "ZWE+": "جمهورية زيمبابوي",
    });
  }
}
