import 'package:openfoodfacts/openfoodfacts.dart';

/// Currency symbols.
extension CurrencyExtension on Currency {
  String getFullName() {
    final String? symbol = _symbols[this];
    if (symbol == null) {
      return name;
    }
    // e.g. for CHF
    if (symbol == name) {
      return name;
    }
    return '$name ($symbol)';
  }

  // source: https://www.xe.com/symbols/
  static final Map<Currency, String> _symbols = <Currency, String>{
    Currency.ALL: 'Lek',
    Currency.AFN: String.fromCharCode(1547),
    Currency.ARS: r'$',
    Currency.AWG: String.fromCharCode(402),
    Currency.AUD: r'$',
    Currency.AZN: String.fromCharCode(8380),
    Currency.BSD: r'$',
    Currency.BBD: r'$',
    Currency.BYN: 'Br',
    Currency.BZD: r'BZ$',
    Currency.BMD: r'$',
    Currency.BOB: r'$b',
    Currency.BAM: 'KM',
    Currency.BWP: 'P',
    Currency.BGN: '${String.fromCharCode(1083)}${String.fromCharCode(1074)}',
    Currency.BRL: r'R$',
    Currency.BND: r'$',
    Currency.KHR: String.fromCharCode(6107),
    Currency.CAD: r'$',
    Currency.KYD: r'$',
    Currency.CLP: r'$',
    Currency.CNY: String.fromCharCode(165),
    Currency.COP: r'$',
    Currency.CRC: String.fromCharCode(8353),
    Currency.HRK: 'kn',
    Currency.CUP: String.fromCharCode(8369),
    Currency.CZK: 'K${String.fromCharCode(269)}',
    Currency.DKK: 'kr',
    Currency.DOP: r'RD$',
    Currency.XCD: r'$',
    Currency.EGP: String.fromCharCode(163),
    Currency.SVC: r'$',
    Currency.EUR: String.fromCharCode(8364),
    Currency.FKP: String.fromCharCode(163),
    Currency.FJD: r'$',
    Currency.GHS: String.fromCharCode(162),
    Currency.GIP: String.fromCharCode(163),
    Currency.GTQ: 'Q',
    Currency.GYD: r'$',
    Currency.HNL: 'L',
    Currency.HKD: r'$',
    Currency.HUF: 'Ft',
    Currency.ISK: 'kr',
    Currency.INR: String.fromCharCode(8377),
    Currency.IDR: 'Rp',
    Currency.IRR: String.fromCharCode(65020),
    Currency.ILS: String.fromCharCode(8362),
    Currency.JMD: r'J$',
    Currency.JPY: String.fromCharCode(165),
    Currency.KZT: '${String.fromCharCode(1083)}${String.fromCharCode(1074)}',
    Currency.KPW: String.fromCharCode(8361),
    Currency.KRW: String.fromCharCode(8361),
    Currency.KGS: '${String.fromCharCode(1083)}${String.fromCharCode(1074)}',
    Currency.LAK: String.fromCharCode(8365),
    Currency.LBP: String.fromCharCode(163),
    Currency.LRD: r'$',
    Currency.MKD:
        '${String.fromCharCode(1076)}${String.fromCharCode(1077)}${String.fromCharCode(1085)}',
    Currency.MYR: 'RM',
    Currency.MUR: String.fromCharCode(8360),
    Currency.MXN: r'$',
    Currency.MNT: String.fromCharCode(8366),
    Currency.MZN: 'MT',
    Currency.NAD: r'$',
    Currency.NPR: String.fromCharCode(8360),
    Currency.ANG: String.fromCharCode(402),
    Currency.NZD: r'$',
    Currency.NIO: r'C$',
    Currency.NGN: String.fromCharCode(8358),
    Currency.NOK: 'kr',
    Currency.OMR: String.fromCharCode(65020),
    Currency.PKR: String.fromCharCode(8360),
    Currency.PAB: 'B/.',
    Currency.PYG: 'Gs',
    Currency.PEN: 'S/.',
    Currency.PHP: String.fromCharCode(8369),
    Currency.PLN: 'z${String.fromCharCode(322)}',
    Currency.QAR: String.fromCharCode(65020),
    Currency.RON: 'lei',
    Currency.RUB: String.fromCharCode(8381),
    Currency.SHP: String.fromCharCode(163),
    Currency.SAR: String.fromCharCode(65020),
    Currency.RSD:
        '${String.fromCharCode(1044)}${String.fromCharCode(1080)}${String.fromCharCode(1085)}.',
    Currency.SCR: String.fromCharCode(8360),
    Currency.SGD: r'$',
    Currency.SBD: r'$',
    Currency.SOS: 'S',
    Currency.ZAR: 'R',
    Currency.LKR: String.fromCharCode(8360),
    Currency.SEK: 'kr',
    Currency.CHF: 'CHF',
    Currency.SRD: r'$',
    Currency.SYP: String.fromCharCode(163),
    Currency.TWD: r'NT$',
    Currency.THB: String.fromCharCode(3647),
    Currency.TTD: r'TT$',
    Currency.TRY: String.fromCharCode(8378),
    Currency.UAH: String.fromCharCode(8372),
    Currency.GBP: String.fromCharCode(163),
    Currency.USD: r'$',
    Currency.UYU: r'$U',
    Currency.UZS: '${String.fromCharCode(1083)}${String.fromCharCode(1074)}',
    Currency.VEF: 'Bs',
    Currency.VND: String.fromCharCode(8363),
    Currency.YER: String.fromCharCode(65020),
    Currency.ZWD: r'Z$',
  };
}
