import 'dart:math' as math;

import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:smooth_app/generic_lib/design_constants.dart';
import 'package:smooth_app/l10n/app_localizations.dart';
import 'package:smooth_app/pages/guides/helpers/guides_content.dart';
import 'package:smooth_app/pages/guides/helpers/guides_extra.dart';
import 'package:smooth_app/pages/guides/helpers/guides_footer.dart';
import 'package:smooth_app/pages/guides/helpers/guides_header.dart';
import 'package:smooth_app/resources/app_icons.dart' as icons;
import 'package:smooth_app/themes/theme_provider.dart';
import 'package:vector_graphics/vector_graphics.dart';

class GuideOpenBeautyFacts extends StatelessWidget {
  const GuideOpenBeautyFacts({super.key});

  @override
  Widget build(BuildContext context) {
    final AppLocalizations appLocalizations = AppLocalizations.of(context);

    return GuidesPage.smallHeader(
      pageName: 'OpenBeautyFacts',
      header: const _OpenBeautyFactsHeader(),
      body: const <Widget>[
        _OpenBeautyFactsSection1(),
        _OpenBeautyFactsSection2(),
        _OpenBeautyFactsSection3(),
        _OpenBeautyFactsSection4(),
      ],
      footer: SliverToBoxAdapter(
        child: GuidesFooter(
          shareUrl: appLocalizations.guide_open_beauty_facts_share_link,
        ),
      ),
    );
  }
}

class _OpenBeautyFactsHeader extends StatelessWidget {
  const _OpenBeautyFactsHeader();

  @override
  Widget build(BuildContext context) {
    final AppLocalizations appLocalizations = AppLocalizations.of(context);

    return GuidesHeader(
      title: appLocalizations.guide_open_beauty_facts_title,
      illustration: const _OpenBeautyFactsHeaderIllustration(),
    );
  }
}

class _OpenBeautyFactsHeaderIllustration extends StatelessWidget {
  const _OpenBeautyFactsHeaderIllustration();

  @override
  Widget build(BuildContext context) {
    return const Align(
      alignment: AlignmentDirectional.centerEnd,
      child: Column(
        mainAxisAlignment: MainAxisAlignment.end,
        children: <Widget>[
          Expanded(
            flex: 32,
            child: SvgPicture(
              AssetBytesLoader(
                'assets/guides/open_beauty_facts/open_beauty_facts_logo.svg.vec',
              ),
              width: 140.0,
            ),
          ),
        ],
      ),
    );
  }
}

class _OpenBeautyFactsSection1 extends StatelessWidget {
  const _OpenBeautyFactsSection1();

  @override
  Widget build(BuildContext context) {
    final AppLocalizations appLocalizations = AppLocalizations.of(context);

    return GuidesParagraph(
      title: appLocalizations
          .guide_open_beauty_facts_what_is_open_beauty_facts_title,
      content: <Widget>[
        GuidesText(
          text: appLocalizations
              .guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1,
        ),
        GuidesText(
          text: appLocalizations
              .guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2,
        ),
        Padding(
          padding: const EdgeInsetsDirectional.only(top: BALANCED_SPACE),
          child: Transform.rotate(
            angle: 0.44 * (360.0 / (math.pi)),
            child: const SvgPicture(
              AssetBytesLoader(
                'assets/guides/open_beauty_facts/beauty_bottle_with_sticker.svg.vec',
              ),
              width: 50.0,
            ),
          ),
        ),
      ],
    );
  }
}

class _OpenBeautyFactsSection2 extends StatelessWidget {
  const _OpenBeautyFactsSection2();

  @override
  Widget build(BuildContext context) {
    final AppLocalizations appLocalizations = AppLocalizations.of(context);

    return GuidesParagraph(
      title: appLocalizations.guide_open_beauty_facts_features_title,
      content: <Widget>[
        GuidesTitleWithText(
          icon: const icons.StopSign(),
          title: appLocalizations.guide_open_beauty_facts_features_arg1_title,
          text:
              appLocalizations.guide_open_beauty_facts_features_arg1_paragraph1,
        ),
        const GuidesComingSoonLabel(),
      ],
    );
  }
}

class _OpenBeautyFactsSection3 extends StatelessWidget {
  const _OpenBeautyFactsSection3();

  @override
  Widget build(BuildContext context) {
    final AppLocalizations appLocalizations = AppLocalizations.of(context);
    final String assetSuffix = context.lightTheme() ? 'light' : 'dark';

    return GuidesParagraph(
      title: appLocalizations.guide_open_beauty_facts_tips_title,
      content: <Widget>[
        GuidesTitleContainer(
          title: appLocalizations.guide_open_beauty_facts_tips_arg2_title,
          icon: const icons.Thumb.up(size: 20.0, color: Colors.white),
          child: GuidesGrid(
            columns: 2,
            verticalSpacing: SMALL_SPACE,
            horizontalSpacing: MEDIUM_SPACE,
            maxLines: 2,
            itemWidthPercent: 0.22,
            items: <GuidesGridItem>[
              GuidesGridItem(
                label: appLocalizations.guide_open_beauty_facts_tips_arg2_text1,
                asset:
                    'assets/guides/shared/photo_lightning_$assetSuffix.svg.vec',
              ),
              GuidesGridItem(
                label: appLocalizations.guide_open_beauty_facts_tips_arg2_text2,
                asset: 'assets/guides/shared/photo_sharp_$assetSuffix.svg.vec',
              ),
              GuidesGridItem(
                label: appLocalizations.guide_open_beauty_facts_tips_arg2_text3,
                asset:
                    'assets/guides/shared/photo_capture_$assetSuffix.svg.vec',
              ),
              GuidesGridItem(
                label: appLocalizations.guide_open_beauty_facts_tips_arg2_text4,
                asset: 'assets/guides/shared/photo_bottle_$assetSuffix.svg.vec',
              ),
              GuidesGridItem(
                label: appLocalizations.guide_open_beauty_facts_tips_arg2_text5,
                asset:
                    'assets/guides/shared/photo_peel_label_$assetSuffix.svg.vec',
              ),
              GuidesGridItem(
                label: appLocalizations.guide_open_beauty_facts_tips_arg2_text6,
                asset:
                    'assets/guides/shared/photo_surface_$assetSuffix.svg.vec',
              ),
            ],
          ),
        ),
        GuidesTitleContainer(
          title: appLocalizations.guide_open_beauty_facts_tips_arg1_title,
          icon: const icons.Thumb.down(size: 20.0, color: Colors.white),
          child: GuidesGrid(
            columns: 2,
            verticalSpacing: SMALL_SPACE,
            horizontalSpacing: MEDIUM_SPACE,
            maxLines: 2,
            itemWidthPercent: 0.22,
            items: <GuidesGridItem>[
              GuidesGridItem(
                label: appLocalizations.guide_open_beauty_facts_tips_arg1_text1,
                asset:
                    'assets/guides/shared/photo_shadows_$assetSuffix.svg.vec',
              ),
              GuidesGridItem(
                label: appLocalizations.guide_open_beauty_facts_tips_arg1_text2,
                asset: 'assets/guides/shared/photo_blurry_$assetSuffix.svg.vec',
              ),
              GuidesGridItem(
                label: appLocalizations.guide_open_beauty_facts_tips_arg1_text3,
                asset: 'assets/guides/shared/photo_crop_$assetSuffix.svg.vec',
              ),
              GuidesGridItem(
                label: appLocalizations.guide_open_beauty_facts_tips_arg1_text4,
                asset: 'assets/guides/shared/photo_busy_$assetSuffix.svg.vec',
              ),
            ],
          ),
        ),
      ],
    );
  }
}

class _OpenBeautyFactsSection4 extends StatelessWidget {
  const _OpenBeautyFactsSection4();

  @override
  Widget build(BuildContext context) {
    final AppLocalizations appLocalizations = AppLocalizations.of(context);

    return GuidesParagraph(
      title: appLocalizations.guide_open_beauty_facts_scores_title,
      content: <Widget>[
        GuidesText(
          text: appLocalizations.guide_open_beauty_facts_scores_paragraph1,
        ),
      ],
    );
  }
}
