// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Ukrainian (`uk`).
class AppLocalizationsUk extends AppLocalizations {
  AppLocalizationsUk([String locale = 'uk']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Так';

  @override
  String get add => 'Додати';

  @override
  String get account_delete_message =>
      'Ви впевнені, що хочете видалити свій обліковий запис?\nЯкщо є певна причина, опишіть її нижче';

  @override
  String get reason => 'Причина';

  @override
  String get okay => 'Okay';

  @override
  String get validate => 'Перевірити';

  @override
  String get create => 'Створити';

  @override
  String get applyButtonText => 'Застосувати';

  @override
  String get next_label => 'Далі';

  @override
  String get continue_label => 'Продовжити';

  @override
  String get exit_label => 'Вийти';

  @override
  String get previous_label => 'Попередній';

  @override
  String get go_back_to_top => 'На початок';

  @override
  String get save => 'Зберегти';

  @override
  String get save_confirmation => 'Ви впевнені, що хочете зберегти?';

  @override
  String get skip => 'Пропустити';

  @override
  String get cancel => 'Відмінити';

  @override
  String get ignore => 'Ігнорувати';

  @override
  String get close => 'Закрити';

  @override
  String get no => 'Ні';

  @override
  String get stop => 'Зупинити';

  @override
  String get finish => 'Завершити';

  @override
  String get calculate => 'Підрахувати';

  @override
  String get reset_food_prefs => 'Скинути налаштування харчових переваг';

  @override
  String get error => 'Сталась помилка';

  @override
  String get error_occurred => 'Виникла помилка';

  @override
  String get featureInProgress =>
      'Ми все ще працюємо над цією функцією, стежте за оновленнями';

  @override
  String get label_web => 'Переглянути в Інтернеті';

  @override
  String get learnMore => 'Докладніше';

  @override
  String get unknown => 'Невідомий';

  @override
  String get match_very_good => 'Чудово поєднується';

  @override
  String get match_good => 'Добре поєднується';

  @override
  String get match_poor => 'Погано поєднується';

  @override
  String get match_may_not => 'Може не поєднуватися';

  @override
  String get match_does_not => 'Не поєднується';

  @override
  String get match_unknown => 'Невідоме поєднання';

  @override
  String get match_short_very_good => 'Чудово поєднується';

  @override
  String get match_short_good => 'Добре поєднується';

  @override
  String get match_short_poor => 'Погано поєднується';

  @override
  String get match_short_may_not => 'Може не поєднуватися';

  @override
  String get match_short_does_not => 'Не поєднується';

  @override
  String get match_short_unknown => 'Невідоме поєднання';

  @override
  String get licenses => 'Ліцензії';

  @override
  String get looking_for => 'Шукаю';

  @override
  String get welcomeToOpenFoodFacts => 'Вітаємо в Open Food Facts';

  @override
  String get whatIsOff =>
      'OpenFoodFacts - це світова некомерційна організація, що підтримується місцевими спільнотами.';

  @override
  String get productDataUtility =>
      'Продивіться дані про харчові продукти, що відповідають вашим вподобанням.';

  @override
  String get healthCardUtility => 'Обирайте продукти, що є корисними для вас.';

  @override
  String get ecoCardUtility => 'Обирайте продукти, що є корисними для планети.';

  @override
  String get server_error_open_new_issue =>
      'Немає відповіді сервера! Ви можете відкрити проблему за наступним посиланням.';

  @override
  String get sign_in_text =>
      'Увійдіть до свого облікового запису Open Food Facts, щоб зберегти свої внески';

  @override
  String get incorrect_credentials =>
      'Неправильне ім\'я користувача або пароль.';

  @override
  String get password_lost_incorrect_credentials =>
      'Така електронна пошта або ім\'я користувача не існує. Будь ласка, перевірте ваші облікові дані.';

  @override
  String get password_lost_server_unavailable =>
      'Наразі наші сервери сповільнюються, і ми приносимо вибачення за це. Будь-ласка спробуйте пізніше.';

  @override
  String get login => 'Ім\'я користувача';

  @override
  String get login_result_type_server_unreachable => 'Мережа недоступна';

  @override
  String get login_result_type_server_issue =>
      'Проблема на сервері. Спробуйте пізніше.';

  @override
  String get login_page_username_or_email =>
      'Введіть, буль ласка, ім\'я користувача або адресу електронної пошти';

  @override
  String get login_page_password_error_empty => 'Будь ласка, введіть пароль';

  @override
  String get create_account => 'Створіть обліковий запис';

  @override
  String get sign_in => 'Увійти';

  @override
  String get sign_in_mandatory => 'Для цієї функції вам необхідно увійти.';

  @override
  String get help_improve_country =>
      'Допоможіть вдосконалити Open Food Facts у вашій країні';

  @override
  String get sign_out => 'Вийти';

  @override
  String get sign_out_confirmation =>
      'Ви дійсно хочете вийти з облікового запису?';

  @override
  String get password => 'Пароль';

  @override
  String get forgot_password => 'Забули пароль';

  @override
  String get forgot_password_question => 'Забули пароль?';

  @override
  String get view_profile => 'Переглянути сторінку';

  @override
  String get reset_password => 'Скинути пароль';

  @override
  String get reset_password_explanation_text =>
      'Якщо ви забули пароль, введіть своє ім\'я користувача та адресу електронної пошти, щоб отримати інструкції для відновлення паролю. Також не забудьте перевірити папку \"Спам\".';

  @override
  String get username_or_email => 'Ім\'я користувача або електронна пошта';

  @override
  String get reset_password_done =>
      'На адресу електронної пошти, прив\'язану до вашого облікового запису було надіслано лист із посиланням для відновлення паролю. Також перевіряйте папку \"Спам\"';

  @override
  String get send_reset_password_mail => 'Змінити пароль';

  @override
  String get enter_some_text => 'Будь ласка, введіть текст';

  @override
  String get sign_up_page_title => 'Зареєструватися';

  @override
  String get sign_up_page_action_button => 'Зареєструватися';

  @override
  String get sign_up_page_action_doing_it => 'Реєстрація…';

  @override
  String get sign_up_page_action_ok => 'Вітаємо! Ваш обліковий створено.';

  @override
  String get sign_up_page_display_name_hint => 'Ім’я';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Будь ласка, введіть відображуване ім\'я, яке ви хочете використовувати.';

  @override
  String get sign_up_page_email_hint => 'Електронна пошта';

  @override
  String get sign_up_page_email_error_empty =>
      'Необхідно заповнити поле електронної адреси';

  @override
  String get sign_up_page_email_error_invalid => 'Невірний e-mail';

  @override
  String get sign_up_page_username_hint => 'Ім\'я користувача: Публічно видиме';

  @override
  String get sign_up_page_username_error_empty =>
      'Будь ласка, введіть ім\'я користувача';

  @override
  String get sign_up_page_username_error_invalid =>
      'Будь ласка, введіть коректне ім\'я';

  @override
  String get sign_up_page_username_description =>
      'Ім\'я користувача не може містити пробіли, великі та спеціальні символи.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Ім\'я користувача не може перевищувати $value символів';
  }

  @override
  String get sign_up_page_password_hint => 'Пароль';

  @override
  String get sign_up_page_password_error_empty => 'Будь ласка, введіть пароль';

  @override
  String get sign_up_page_password_error_invalid =>
      'Будь ласка, введіть дійсний пароль (принаймні 6 символів)';

  @override
  String get sign_up_page_confirm_password_hint => 'Підтвердіть пароль';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Будь ласка, підтвердіть пароль';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Паролі відрізняються';

  @override
  String get sign_up_page_agree_text => 'Я погоджуюсь з Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'умови використання та внесок';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'При створенні облікового запису, згода з Умовами використання є обов\'язковою, проте анонімні пропозиції, як і раніше, можна робити через додаток';

  @override
  String get sign_up_page_producer_checkbox =>
      'Я виробник продуктів харчування';

  @override
  String get sign_up_page_producer_hint => 'Виробник/бренд';

  @override
  String get sign_up_page_producer_error_empty =>
      'Будь ласка, введіть виробника або торгову марку';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Я хотів би підписатися на інформаційну розсилку Open Food Facts (Ви можете відписатися від неї у будь-який час)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Ім\'я користувача вже існує, будь ласка, виберіть інше ім\'я користувача.';

  @override
  String get sign_up_page_email_already_exists =>
      'вже існує, увійдіть до облікового запису або спробуйте іншу електронну адресу.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Будь ласка, вкажіть дійсну адресу електронної пошти.';

  @override
  String get sign_up_page_server_busy =>
      'Нам дуже прикро, у нас виникли деякі технічні труднощі зі створенням вашого облікового запису. Будь-ласка спробуйте пізніше.';

  @override
  String get settingsTitle => 'Налаштування';

  @override
  String get darkmode => 'Тема';

  @override
  String get darkmode_dark => 'Темна тема';

  @override
  String get darkmode_light => 'Світла тема';

  @override
  String get darkmode_system_default => 'Системні установки за замовчуванням';

  @override
  String get thanks_for_contributing => 'Дякуємо за внесок!';

  @override
  String get contributors_label => 'Вони створюють додаток';

  @override
  String get contributors_dialog_title => 'Співучасники';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Автор: $name';
  }

  @override
  String get contributors_description => 'Список всіх учасників цього додатку';

  @override
  String get support => 'Підтримка';

  @override
  String get support_join_slack =>
      'Зверніться за допомогою на нашому каналі Slack';

  @override
  String get support_via_forum => 'Зверніться за допомогою на наш форум';

  @override
  String get support_via_email => 'Надішліть нам e-mail';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Надіслати записи аплікації?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Чи бажаєте додати записи аплікації до Вашого повідомлення?';

  @override
  String get termsOfUse => 'Умови використання';

  @override
  String get legalNotices => 'Юридична інформація';

  @override
  String get privacy_policy => 'Політика конфіденційности';

  @override
  String get about_this_app => 'Про додаток';

  @override
  String get contribute => 'Долучитись';

  @override
  String get contribute_sw_development => 'Розробка програмного забезпечення';

  @override
  String get contribute_develop_text =>
      'Код кожного продукту Open Food Facts доступний на GitHub. Ви можете повторно використовувати код (це відкритий код) і допомогти нам покращувати його для всіх на цій планеті.';

  @override
  String get contribute_develop_text_2 =>
      'Ви можете приєднатися до чату Open Food Facts в Slack, який є найкращим способом поставати запитання.';

  @override
  String get contribute_develop_dev_mode_title => 'Режим DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Активувати режим DEV';

  @override
  String get contribute_donate_title => 'Підтримати проект';

  @override
  String get contribute_donate_header => 'Донатьте на Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Будь ласка, зверніть увагу, що з внутрішньою альфа-версією можлива повна втрата даних, і додаток може стати непридатним для використання в будь-який момент!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Незавантажені продукти';

  @override
  String get contribute_improve_header => 'Поліпшення';

  @override
  String get contribute_improve_text =>
      'Ця база даних є основою проєкту. Допомогти легко і дуже швидко. Ви можете завантажити мобільний додаток на ваш телефон і почати додавати або покращувати продукти.\n\nЗ іншого боку, вебсайт Open Food Facts пропонує багато способів зробити свій внесок: ';

  @override
  String get contribute_translate_header => 'Перекласти';

  @override
  String get contribute_data_quality => 'Якість даних';

  @override
  String get contribute_translate_link_text => 'Почніть перекладати';

  @override
  String get contribute_translate_text =>
      'Open Food Facts - Це глобальний проєкт, що містить продукти з понад 160 країн. Open Food Facts перекладається на десятки мов, вона постійно змінюється.';

  @override
  String get contribute_translate_text_2 =>
      'Переклади - одне з ключових завдань проекту';

  @override
  String get contribute_join_skill_pool =>
      'Долучайте свої навички до Open Food Facts. Приєднуйтесь до групи навичок!';

  @override
  String get contribute_share_header =>
      'Діліться Open Food Facts зі своїми друзями';

  @override
  String get contribute_share_content =>
      'Я хотів би розповісти вам про додаток, яким я користуюся, Open Food Facts, і який дозволяє вам отримувати інформацію про вплив продуктів харчування на здоров\'я та навколишнє середовище в персоналізованому режимі. Він працює шляхом сканування штрих-кодів на упаковці. Зрештою, це безкоштовно, не вимагає реєстрації, і ви навіть можете допомогти збільшити кількість розшифрованих продуктів. Ось посилання, за яким ви можете завантажити його на свій телефон: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Додайте ціни, надіславши запит на експорт даних ваших карток постійного клієнта відповідно до GDPR';

  @override
  String get tap_to_answer => 'Натисніть тут, що відповісти на запитання';

  @override
  String get tap_to_answer_hint =>
      'Натисніть тут, щоб відповісти на запитання про цей продукт';

  @override
  String get robotoff_questions_loading_hint =>
      'Будь ласка, зачекайте, поки завантажуються питання про цей продукт';

  @override
  String get saving_answer => 'Збереження відповіді';

  @override
  String get contribute_to_get_rewards => 'Станьте учасником Food Transparency';

  @override
  String get question_sign_in_text =>
      'Увійдіть до свого облікового запису Open Food Fact, щоб ваші внески було оцінено';

  @override
  String get question_yes_button_accessibility_value => 'Відповідайте так';

  @override
  String get question_no_button_accessibility_value => 'Відповідайте ні';

  @override
  String get question_skip_button_accessibility_value =>
      'Пропустити це питання';

  @override
  String get tap_to_edit_search => 'Натисніть для редагування пошуку';

  @override
  String get myPreferences => 'Мої вподобання';

  @override
  String get account_create_message =>
      'Створіть власний обліковий запис і приєднуйтеся до спільноти Open Food Facts, щоб допомогти поширювати знання про їжу в усьому світі!';

  @override
  String get join_us => 'Приєднайся до нас';

  @override
  String get myPreferences_profile_title => 'Ваш Профіль';

  @override
  String get myPreferences_profile_subtitle =>
      'Керуйте своїм обліковим записом учасника Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Налаштування Додатку';

  @override
  String get myPreferences_settings_subtitle => 'Темний режим, мови…';

  @override
  String get myPreferences_food_title => 'Харчові вподобання';

  @override
  String get myPreferences_food_subtitle =>
      'Виберіть інформацію про їжу, яка цікавить Вас понад усе.';

  @override
  String get myPreferences_food_comment =>
      'Виберіть, яка інформація про продукти харчування є для вас найважливішою, щоб ранжувати продукти відповідно до ваших уподобань, першочергово бачити інформацію, яка вас цікавить, і отримати зведення про сумісність. Ці харчові вподобання залишаються на вашому пристрої та не пов\'язані з вашим обліковим записом учасника Open Food Facts, якщо ви його маєте.';

  @override
  String get confirmResetPreferences => 'Змінити свої харчові вподобання?';

  @override
  String get myPersonalizedRanking => 'Мій персональний рейтинг';

  @override
  String get ranking_tab_all => 'Усі';

  @override
  String get ranking_subtitle_match_yes => 'Гарне поєднання для Вас';

  @override
  String get ranking_subtitle_match_no => 'Дуже погане поєднання';

  @override
  String get ranking_subtitle_match_maybe => 'Невідоме поєднання';

  @override
  String get refresh_with_new_preferences =>
      'Оновити список з вашими новими налаштуваннями';

  @override
  String get reloaded_with_new_preferences =>
      'Перезавантажено з вашими новими налаштуваннями';

  @override
  String get profile_navbar_label => 'Спільнота';

  @override
  String get scan_navbar_label => 'Сканувати';

  @override
  String get history_navbar_label => 'Історія';

  @override
  String get list_navbar_label => 'Списки';

  @override
  String get category => 'Фільтр за категорією';

  @override
  String get category_all => 'Усі';

  @override
  String get category_search => '(пошук за категорією)';

  @override
  String get filter => 'Фільтр';

  @override
  String get scan => 'Товари з екрана сканування';

  @override
  String get scan_history => 'Сканування історії пошуку';

  @override
  String get search => 'Пошук';

  @override
  String get search_product_help => 'Пошук товару,\nбренду або штрих-коду';

  @override
  String get search_filter => 'Фільтр пошуку';

  @override
  String get search_history => 'Історія пошуку';

  @override
  String get search_store => 'Пошук магазину';

  @override
  String get search_store_help => 'Підказка: додайте місто або країну';

  @override
  String get tap_for_more => 'Натисніть, щоб побачити більше…';

  @override
  String get product => 'Продукт';

  @override
  String get unknownBrand => 'Невідома марка';

  @override
  String get unknownProductName => 'Невідомий продукт';

  @override
  String get label_refresh => 'Оновлення';

  @override
  String get label_reload => 'Перезавантажити';

  @override
  String get image => 'Зображення';

  @override
  String get front_photo => 'Фото переднього плану';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (це зображення може бути застарілим)';
  }

  @override
  String get outdated_image_short_label => 'може бути застарілим';

  @override
  String get ingredients => 'Інгредієнти';

  @override
  String get ingredients_editing_instructions =>
      'Зберігайте оригінальне замовлення. Вкажіть відсоток. Розділяйте комами або дефісом і використовуйте дужки для інгредієнтів інгредієнта.';

  @override
  String get ingredients_editing_error => 'Не вдалося зберегти інгредієнти.';

  @override
  String get ingredients_editing_image_error =>
      'Не вдалося отримати зображення нових інгредієнтів.';

  @override
  String get ingredients_editing_title => 'Редагувати інгредієнти';

  @override
  String get ingredients_photo => 'Фото інгредієнтів';

  @override
  String get packaging_editing_instructions =>
      'Перелічіть всі частини упаковки, розділені комою або переносом рядка, із зазначенням їх кількості (наприклад, 1 або 6), типу (наприклад, пляшка, коробка, банка), матеріалу (наприклад, пластик, метал, алюміній) і, якщо можливо, їх розміру (наприклад, 33 мл) та інструкцій з переробки.\nПриклад: 1 скляна пляшка для переробки, 1 пластикова пробка для викидання';

  @override
  String get packaging_editing_error => 'Не вдалося зберегти пакунок.';

  @override
  String get packaging_editing_image_error =>
      'Не вдалося отримати нове зображення пакунку.';

  @override
  String get packaging_editing_title => 'Редагувати пакунок';

  @override
  String get nutrition => 'Харчова цінність';

  @override
  String get nutrition_facts_photo => 'Фото харчової цінності';

  @override
  String get nutrition_facts_editing_title => 'Редагувати харчові показники';

  @override
  String get packaging_information => 'Інформація про упакування';

  @override
  String get packaging_information_photo => 'Фото з інформацією про упакування';

  @override
  String get missing_product => 'Ви знайшли новий продукт!';

  @override
  String get add_product_take_photos =>
      'Сфотографуйте пакування, щоб додати цей продукт до Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Будь ласка, для початку зробіть кілька світлин. Ви можете завершити опис продукту в будь-який час.';

  @override
  String get add_product_information_button_label =>
      'Додайте інформацію про продукт';

  @override
  String get new_product => 'Новий Продукт';

  @override
  String get new_product_found_title => 'Знайдено новий товар!';

  @override
  String get new_product_found_text =>
      'Наша спільна база даних містить понад **3 млн продуктів**, але цей штрих-код не існує: ';

  @override
  String get new_product_found_button => 'Додати цей продукт';

  @override
  String get new_product_leave_title => 'Покинути цю сторінку?';

  @override
  String get new_product_leave_message =>
      'Схоже, ви нічого не ввели. Ви справді хочете залишити цю сторінку?';

  @override
  String get new_product_dialog_description =>
      'Будь ласка, сфотографуйте упаковку, щоб додати цей продукт до нашої спільної бази даних';

  @override
  String get new_product_dialog_illustration_description =>
      'Ілюстрація з невідомими Nutri-Score та Eco-Score';

  @override
  String get front_packaging_photo_button_label =>
      'Фото передньої частини продукту';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Підтвердьте завантаження передньої фотографії продукту';

  @override
  String get confirm_button_label => 'Підтвердити';

  @override
  String get send_image_button_label => 'Надіслати зображення';

  @override
  String get crop_page_action_saving => 'Збереження зображення…';

  @override
  String get crop_page_action_cropping => 'Обрізання зображення…';

  @override
  String get crop_page_action_local => 'Збереження локальної версії…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ой… з твоєю фотографією щось сталося!';

  @override
  String get crop_page_action_local_failed_message =>
      'Ми не можемо обробити зображення локально перед надсиланням на наш сервер. Спробуйте пізніше або зв’яжіться з нами, якщо проблема не зникне.';

  @override
  String get crop_page_action_retake => 'Повторити фото';

  @override
  String get crop_page_too_small_image_title => 'Зрбраження занадто маленьке!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Мінімальний розмір зображення у пікселях - ${expectedMinWidth}x$expectedMinHeight. Поточна картинка ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Підготовка виклику до сервера…';

  @override
  String get front_packaging_photo_title => 'Фото лицьової сторони пакування';

  @override
  String get ingredients_photo_title => 'Фото інгредієнтів';

  @override
  String get nutritional_facts_photo_title =>
      'Світлина харчової цінності продукту';

  @override
  String get recycling_photo_title => 'Обробка фото';

  @override
  String get take_photo_title => 'Сфотографувати';

  @override
  String get take_more_photo_title => 'Зробити більше фото';

  @override
  String get front_photo_uploaded => 'Попереднє фото завантажено';

  @override
  String get ingredients_photo_button_label => 'Фото інгредієнтів';

  @override
  String get ingredients_photo_uploaded => 'Фото Інгредієнтів завантажено';

  @override
  String get nutrition_cache_loading_error =>
      'Не вдалося завантажити поживні речовини з кешу';

  @override
  String get nutritional_facts_photo_button_label => 'Фото харчової цінності';

  @override
  String get nutritional_facts_input_button_label =>
      'Введіть дані про харчову цінність';

  @override
  String get nutritional_facts_added => 'Харчова цінність додана';

  @override
  String get categories_added => 'Категорії додано';

  @override
  String get new_product_title_nutriscore => 'Розрахувати Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Допоможіть нам, заповнивши принаймні категорію та харчові цінності';

  @override
  String get new_product_title_environmental_score =>
      'Обчисліть бал Green Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Отримайте це, заповнивши принаймні одну категорію';

  @override
  String get new_product_additional_environmental_score =>
      'Зробіть обчислення Eco-Score більш точним за походженням, пакуванням тощо';

  @override
  String get new_product_title_nova =>
      'Обчисліть рівень обробки харчових продуктів (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Отримайте це, заповнивши категорію продукту та інгредієнти';

  @override
  String get new_product_desc_nova_unknown => 'Рівень обробки їжі є невідомим';

  @override
  String get new_product_title_pictures => 'Новий товар';

  @override
  String get new_product_title_pictures_details =>
      'Будь ласка, зробіть наступні фотографії, і система Open Food Facts зможе розібратися з усіма іншими!';

  @override
  String get new_product_title_misc => 'І трохи основних даних…';

  @override
  String new_product_done_msg(String username) {
    return 'Дякуємо за ваш внесок «$username»!';
  }

  @override
  String get new_product_done_msg_no_user => 'Дякуємо за Ваш внесок!';

  @override
  String get new_product_done_button_label =>
      'Відкрийте для себе готовий продукт';

  @override
  String get hey_incomplete_product_message =>
      'Натисніть, щоб відповісти на 3 запитання ЗАРАЗ для обчислення Nutri-Score, Green Score та ультраобробки (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Торкніться зараз, щоб відповісти на 2 запитання, щоб допомогти проаналізувати цю косметику!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Торкніться зараз, щоб відповісти на 3 запитання, щоб допомогти проаналізувати цей корм для домашніх тварин!';

  @override
  String get hey_incomplete_product_message_product =>
      'Торкніться зараз, щоб допомогти завершити цей продукт!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Завантаження фотографій харчових фактів';

  @override
  String get recycling_photo_button_label =>
      'Фотографія з інформацією щодо перероблювання';

  @override
  String get recycling_photo_uploaded => 'Фотографію перероблення завантажено';

  @override
  String get take_more_photo_button_label => 'Зробити більше фото';

  @override
  String get other_photo_uploaded => 'Різні фото завантажено';

  @override
  String get retake_photo_button_label => 'Перезняти';

  @override
  String get selecting_photo => 'Вибрати фото';

  @override
  String get uploading_image => 'Вивантаження фото на сервер';

  @override
  String get uploading_image_type_front =>
      'Вивантаження лицьового зображення до Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Вивантаження зображення інгредієнтів до Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Вивантаження зображення харчової цінності до Open  Food  Facts';

  @override
  String get uploading_image_type_packaging =>
      'Завантаження зображення пакування на Open  Food  Facts';

  @override
  String get uploading_image_type_other =>
      'Вивантаження іншого зображення на Open  Food  Facts';

  @override
  String get uploading_image_type_generic =>
      'Вивантаження зображення до Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Додати відсутні інгредієнти';

  @override
  String get score_add_missing_packaging_image =>
      'Додайте відсутнє зображення упакування';

  @override
  String get score_add_missing_nutrition_facts =>
      'Додати відсутні поживні речовини';

  @override
  String get score_add_missing_product_traces =>
      'Додайте відсутні сліди продукту';

  @override
  String get score_add_missing_product_category =>
      'Додати відсутню категорію продукту';

  @override
  String get score_add_missing_precise_product_category =>
      'Виберіть точнішу категорію';

  @override
  String get score_add_missing_product_countries =>
      'Додайте відсутні країни для товарів';

  @override
  String get score_add_missing_product_emb =>
      'Додайте відсутні коди відстеження продукту';

  @override
  String get score_add_missing_product_labels =>
      'Додайте відсутні етикетки продуктів';

  @override
  String get score_add_missing_product_origins =>
      'Додати відсутню категорію продукту';

  @override
  String get score_add_missing_product_stores =>
      'Додайте відсутні магазини продуктів';

  @override
  String get score_add_missing_product_brands =>
      'Додати відсутні бренди товарів';

  @override
  String get score_update_nutrition_facts => 'Оновити поживні речовини';

  @override
  String get nutrition_page_title => 'Детальна харчова цінність';

  @override
  String get nutrition_page_nutritional_info_title =>
      'Інформація про харчову цінність';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Значення, вказані на продукті:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Так';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Ні';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Відкрити фото';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Належні практики: інформація про харчування';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Іноді інформація про харчову цінність **не вказана на пакуванні** або в документі, що додається до продукту. У цьому випадку, і тільки в цьому випадку, ви можете встановити значення **НІ**.';

  @override
  String get nutrition_page_serving_type_label => 'Харчова цінність:';

  @override
  String get nutrition_page_per_100g => 'на 100 г.';

  @override
  String get nutrition_page_per_100g_100ml => 'на 100 г/мл';

  @override
  String get nutrition_page_per_serving => 'в одній порції';

  @override
  String get nutrition_page_add_nutrient => 'Додати поживну речовину';

  @override
  String get nutrition_page_serving_size => 'Розмір порції';

  @override
  String get nutrition_page_serving_size_hint =>
      'Введення службового розміру (наприклад: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Належна практика: Розмір порції';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Це значення допомагає **пропорційно розрахувати кількість кожної поживної речовини на порцію**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Дозволені одинці** такі: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 г**, **60г** або **60 Г** (бажано перший варіант)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 мл** або **1л**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Помилкова одиниця';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **гр**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Помилкові одиниці';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **цукерок** та 2 **печива**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Відсутня одиниця';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Недійсний номер';

  @override
  String get nutrition_page_update_running => 'Оновлення продукту на сервері…';

  @override
  String get nutrition_page_update_done => 'Продукт оновлено!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Використовувати кількість товару як розмір';

  @override
  String get nutrition_page_photo_error => 'Не вдалося завантажити фото';

  @override
  String get more_photos => 'Більше цікавих фото';

  @override
  String get view_more_photo_button =>
      'Переглянути всі наявні фотографії цього продукту';

  @override
  String get no_product_found => 'Продукт не знайдено';

  @override
  String get no_location_found => 'Локацію не знайдено';

  @override
  String get not_found => 'не знайдено:';

  @override
  String get refreshing_product => 'Освіжаючий товар';

  @override
  String get product_refreshed => 'Продукт обновлено';

  @override
  String product_image_accessibility_label(String date) {
    return 'Зображення зроблене $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Зображення, зроблене $date. Це зображення може бути застарілим';
  }

  @override
  String get product_image_outdated => 'Це зображення може бути застарілим';

  @override
  String get product_image_outdated_explanations_title =>
      'Це зображення може бути застарілим';

  @override
  String get product_image_outdated_explanations_content =>
      'Це фото зроблено більше року тому.\n**Будь ласка, перевірте, чи воно досі актуальне**.\n\nЦе **лише попередження**. Якщо вміст залишається незмінним, ви можете проігнорувати це повідомлення.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Замінити фото ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Додати фото ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Зробити нове фото';

  @override
  String get product_image_action_take_picture => 'Сфотографувати';

  @override
  String get product_image_action_from_gallery =>
      'Виберіть з галереї вашого пристрою';

  @override
  String get product_image_action_choose_existing_photo =>
      'Вибрати з фотографій товару';

  @override
  String get product_image_details_label => 'Інформація про фото';

  @override
  String get product_image_details_from_producer => 'Від виробника';

  @override
  String get product_image_details_contributor => 'Учасник';

  @override
  String get product_image_details_contributor_producer => 'Автор (продюсер)';

  @override
  String get product_image_details_date => 'Дата';

  @override
  String get product_image_details_date_unknown => 'Невідомий';

  @override
  String get homepage_main_card_logo_description => 'Вітаємо в Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Відскануйте** штрих-код або\n**знайдіть** продукт';

  @override
  String get homepage_main_card_search_field_hint => 'Пошук товару';

  @override
  String get homepage_main_card_search_field_tooltip => 'Почати пошук';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Останні новини: $news_title';
  }

  @override
  String get tagline_app_review => 'Вам подобається цей додаток?';

  @override
  String get tagline_app_review_button_positive => 'Я в захопленні! 😍';

  @override
  String get tagline_app_review_button_negative => 'Не дуже…';

  @override
  String get tagline_app_review_button_later => 'Запитайте мене пізніше';

  @override
  String get tagline_feed_news_button => 'Докладніше';

  @override
  String get app_review_negative_modal_title =>
      'Вам не подобається наш додаток?';

  @override
  String get app_review_negative_modal_text =>
      'Не могли б ви витратити кілька секунд, щоб сказати нам, чому?';

  @override
  String get app_review_negative_modal_positive_button => 'Так, звичайно!';

  @override
  String get app_review_negative_modal_negative_button => 'Ні';

  @override
  String get could_not_refresh => 'Не вдалося оновити продукт';

  @override
  String get product_internet_error_modal_title => 'Сталася помилка!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Ми не можемо отримати інформацію про цей продукт через помилку мережі. Перевірте підключення до Інтернету та повторіть спробу.\n\nВнутрішня помилка:\n$error';
  }

  @override
  String get product_tags_title => 'Властивості продукції';

  @override
  String get no_product_tags_found_message =>
      'Властивості продукту не знайдено. Властивості можна використовувати для більш детального опису продуктів у гнучкий спосіб. Торкніться, щоб додати.';

  @override
  String get product_tags_empty => 'Немає властивостей';

  @override
  String get product_tags_explanation =>
      'Додаючи властивості (ключ/значення) до продукту, ви допомагаєте його збагатити.';

  @override
  String get add_tag => 'Додати властивість';

  @override
  String get add_tags => 'Додати властивості';

  @override
  String get add_edit_tags => 'Додати або редагувати властивості';

  @override
  String get edit_tag => 'Змінити властивість';

  @override
  String get remove_tag => 'Видалити властивість';

  @override
  String get tag_key => 'Властивість';

  @override
  String get tag_keys => 'Властивості';

  @override
  String get tag_key_uneditable => 'Власність (не можна редагувати)';

  @override
  String get tag_key_input_hint => 'Введіть властивість';

  @override
  String get tag_value => 'Цінність';

  @override
  String get tag_values => 'Цінності';

  @override
  String get tag_value_input_hint => 'Введіть значення';

  @override
  String get tag_key_item => 'Властивість:';

  @override
  String get tag_value_item => 'Значення:';

  @override
  String get tag_key_explanations =>
      'Ключ повинен бути малим регістром і без пробілів.';

  @override
  String tag_key_already_exists(String property) {
    return 'Тег із властивістю $property вже існує!';
  }

  @override
  String get product_internet_error =>
      'Неможливо отримати інформацію про цей продукт через помилку мережі.';

  @override
  String get cached_results_from => 'Показати результати з:';

  @override
  String get product_search_same_category => 'Знайти альтернативи';

  @override
  String get product_search_same_category_short => 'Порівняти';

  @override
  String get product_search_same_category_error =>
      'Цю функцію можна використовувати лише для товарів із категорією.\n\nВідредагуйте продукт, щоб додати категорію.';

  @override
  String get product_improvement_add_category =>
      'Додати категорію для розрахунку харчової цінності Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Додати поживні речовини задля вирахування Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Додати поживні речовини та категорію для вирахування Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Показник харчової цінності Nutri-Score для цього продукту не може бути розрахований через нестандартну категорію. Якщо Ви вважаєте, що сталося помилка, зв\'яжіться з нами.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Зображення харчування є застарілим: будь ласка, оновіть його.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Eco-Score враховує походження інгредієнтів. Будь ласка, сфотографуйте перелік інгредієнтів та/або географічну характеристику або відредагуйте продукт, щоб вони були враховані.';

  @override
  String get country_chooser_label => 'Будь ласка, виберіть країну';

  @override
  String get currency_chooser_label => 'Будь ласка виберіть валюту';

  @override
  String get country_change_message => 'Ви щойно змінили країну.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Ви хочете змінити валюту з $previousCurrency на $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Будь ласка, виберіть країну:';

  @override
  String get country_chooser_label_from_settings => 'Ваша країна';

  @override
  String get country_selection_explanation =>
      'Деякі особливості навколишнього середовища залежать від місця розташування';

  @override
  String get product_removed_comparison => 'Продукт вилучено з порівняння';

  @override
  String get native_app_settings => 'Власні налаштування програми';

  @override
  String get native_app_description =>
      'Налаштування відкритих систем для Open Food Facts';

  @override
  String get product_removed_history => 'Продукт вилучено з історії';

  @override
  String get product_removed_list => 'Продукт вилучено з історії';

  @override
  String get product_could_not_remove => 'Неможливо видалити продукт';

  @override
  String get no_prodcut_in_list => 'В цьому списку немає такого товару';

  @override
  String get no_product_in_section => 'У цьому розділі немає товару';

  @override
  String get recently_seen_products => 'Всі переглянуті товари';

  @override
  String get clear => 'Очистити';

  @override
  String get clear_long => 'Очистити список';

  @override
  String get really_clear => 'Ви справді хочете видалити цей список?';

  @override
  String pct_match(Object percent) {
    return '$percent% збігів';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count днів тому',
      one: 'один день тому',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count годин тому',
      one: 'одна година тому',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count хвилин тому',
      one: 'одна хвилина тому',
      zero: 'менш ніж хвилину тому',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count місяців тому',
      one: 'місяць тому',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count тижнів тому',
      one: 'тиждень тому',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Порівняти $count продукти',
      one: 'Порівняти продукт',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count selected products',
      one: 'One selected product',
      zero: 'No selected product',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Порівняти вибрані продукти';

  @override
  String get delete_products_mode => 'Видалити вибрані продукти';

  @override
  String get select_all_products_mode => 'Обрати всі продукти';

  @override
  String get select_none_products_mode => 'Зняти виділення';

  @override
  String get compare_products_appbar_title => 'Порівняти товари';

  @override
  String get compare_products_appbar_subtitle =>
      'Виберіть принаймні два продукти';

  @override
  String get retry_button_label => 'Повторити спробу';

  @override
  String get connect_with_us => 'Зв\'яжіться з нами';

  @override
  String get tiktok => 'Слідкуйте за нами в TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Слідкуйте за нами в Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Слідкуйте за нами в X (раніше Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Слідкуйте за нами на Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Слідкуйте за нами на BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Блог';

  @override
  String get faq => 'ЧаПИ';

  @override
  String get discover => 'Огляд';

  @override
  String get how_to_contribute => 'Як зробити внесок';

  @override
  String get hint_knowledge_panel_message =>
      'Ви можете торкнутися будь-якої частини картки, щоб дізнатися більше про те, що ви бачите. Спробуй зараз!';

  @override
  String get permissions_page_title => 'Доступ до камери';

  @override
  String get permissions_page_body1 =>
      'Щоб сканувати штрих-коди за допомогою камери телефону, авторизуйте доступ.';

  @override
  String get permissions_page_body2 =>
      'Якщо ви передумаєте, цю опцію можна будь-коли ввімкнути або вимкнути в налаштуваннях.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'ОС: Android (SDK Int: $sdkInt / Випуск: $release)\nМодель: $model\nПродукт: $product\nПрилад: $device\nМарка: $brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'ОС: iOS ($version)\nМодель: $model\nЛокалізована модель: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nВерсія додатку:$appVersion\nПартія збірки додатку:$appBuildNumber\nПартія пакету:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Авторизувати';

  @override
  String get refuse_button_label => 'Відмовитися';

  @override
  String get ask_me_later_button_label => 'Потім';

  @override
  String get are_you_sure => 'Ви впевнені?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Продовжити на $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Ласкаво просимо!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Додаток, який допоможе вам вибрати їжу, яка корисна для **вас** і **планети**!';

  @override
  String get onboarding_continue_button => 'Продовжити';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Завантаження вашого першого прикладу продукту';

  @override
  String get onboarding_welcome_warning =>
      'Вибачте, це наш приклад продукту, ви не можете його редагувати :)';

  @override
  String get product_list_your_ranking => 'Ваш рейтинг';

  @override
  String get product_list_empty_icon_desc => 'Історія недоступна';

  @override
  String get product_list_empty_title => 'Почати сканування';

  @override
  String get product_list_empty_message =>
      'Тут з’являться скановані продукти, і ви зможете переглянути детальну інформацію про них';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'продуктів',
      one: 'продукту',
      zero: 'продукту',
    );
    return 'Оновлення $_temp0 у вашій історії';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'продукти',
      one: 'продукт',
      zero: 'продкту',
    );
    return '$_temp0 завершило оновлення';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Завантаження даних';

  @override
  String get loading_dialog_default_error_message =>
      'Не вдалося завантажити дані';

  @override
  String get account_delete => 'Видалити обліковий запис';

  @override
  String get account_delete_title => 'Видалити мій обліковий запис';

  @override
  String get user_profile => 'Обліковий запис';

  @override
  String get user_profile_title_guest => 'Ласкаво просимо!';

  @override
  String get user_profile_subtitle_guest =>
      'Увійдіть або зареєструйтеся, аби приєднатися до спільноти community';

  @override
  String user_profile_title_id_email(String email) {
    return 'Логін Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Ласкаво просимо $id!';
  }

  @override
  String get email_subject_account_deletion => 'Видалити обліковий запис';

  @override
  String email_body_account_deletion(String userId) {
    return 'Привіт, будь ласка, видаліть мій обліковий запис Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Додаток';

  @override
  String get settings_app_data => 'Конфіденційність і моніторинг';

  @override
  String get settings_app_camera => 'Камера';

  @override
  String get settings_app_products => 'Товари';

  @override
  String get settings_app_miscellaneous => 'Різне';

  @override
  String get camera_play_sound_title => 'Відтворення звуку під час сканування';

  @override
  String get camera_play_sound_subtitle =>
      'Буде відтворення звукового сигналу після кожного успішного сканування';

  @override
  String get camera_window_accessibility_label =>
      'Відскануйте штрих-код камерою';

  @override
  String get app_haptic_feedback_title => 'Вібрація та тактильні відчуття';

  @override
  String get app_haptic_feedback_subtitle =>
      'Вібрації після виконання певних дій (зчитування штрих-коду, вилучення товару...).';

  @override
  String get crash_reporting_toggle_title => 'Звіти про помилки';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Якщо ввімкнено, звіти про збої автоматично надсилаються до системи відстеження помилок Open Food Facts, щоб можна було виправити помилки та покращити додаток таким чином.';

  @override
  String get send_anonymous_data_toggle_title => 'Надішліть анонімні дані';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'При активації додатку, певна анонімна інформація про використання додатку буде відправлена на сервери Open  Food  Facts, щоб ми мали змогу зрозуміти, як і в якому обсязі використовуються функції для їх покращення.';

  @override
  String get product_edit_photo_title => 'Редагувати світлину';

  @override
  String get permission_photo_error => 'Помилка';

  @override
  String get permission_photo_denied_title =>
      'Дозволити використання камери для сканування штрих-кодів';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Для кращого досвіду дозвольте $appName доступ до камери. Ви зможете безпосередньо сканувати штрих-коди.';
  }

  @override
  String get permission_photo_denied_button => 'Дозволити';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'У доступі відмовлено';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Оскільки ви раніше відмовили у дозволі на камеру, ви повинні дозволити його вручну в Налаштуваннях.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Open Settings';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Відмінити';

  @override
  String get permission_photo_none_found => 'Камера не виявлена';

  @override
  String get permission_photo_denied => 'Доступ до камери не надано';

  @override
  String get show_product_pictures => 'Показати фотографії продукту';

  @override
  String get edit_product_label => 'Редагувати товар';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Завантаження ваших змін…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Ваші зміни **надсилаються у фоновому режимі** (або пізніше, у разі помилки).\nВи можете продовжити редагування інших полів продукту.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Ваші зміни **надсилаються у фоновому режимі** (або пізніше, у разі помилки).';

  @override
  String get edit_product_label_short => 'Редагувати';

  @override
  String edit_product_form_item_help(String value) {
    return 'Як ввести \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Будь ласка, введіть непорожнє значення!';

  @override
  String get edit_product_form_item_error_existing => 'Це значення вже є!';

  @override
  String get edit_product_form_item_add_action_brand => 'Додати новий бренд';

  @override
  String get edit_product_form_item_add_action_label => 'Додати нову мітку';

  @override
  String get edit_product_form_item_add_action_store => 'Додати новий магазин';

  @override
  String get edit_product_form_item_add_action_origin => 'Додати нове джерело';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Додати новий код трасування';

  @override
  String get edit_product_form_item_add_action_country => 'Додати нову країну';

  @override
  String get edit_product_form_item_add_action_category =>
      'Додати нову категорію';

  @override
  String get edit_product_form_item_add_action_trace => 'Додайте новий слід';

  @override
  String get edit_product_form_item_add_suggestion => 'Додати пропозицію';

  @override
  String get edit_product_form_item_deny_suggestion => 'Відхилити пропозицію';

  @override
  String get edit_product_form_item_details_title => 'Основні деталі';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Назва продукту, бренд, кількість';

  @override
  String get edit_product_form_item_other_details_title =>
      'Додаткова інформація';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Вебсайт…';

  @override
  String get edit_product_form_item_photos_title => 'Світлини';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Додайте або оновіть фотографії';

  @override
  String get edit_product_form_item_labels_title =>
      'Маркування та сертифікація';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Екологічні, етикетки якості…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Введіть мітку (наприклад, NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'етикетка';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Належна практика: Етикетки';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Будь-яка характеристика продукту, яка є фактичною і відрізняється від інших полів.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Зроблено в Бельгії, вироблено в Британії…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Багатий на клітковину, джерело заліза…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Справедлива торгівля, Макс Гейфелар…';

  @override
  String get edit_product_form_item_stores_title => 'Магазини';

  @override
  String get edit_product_form_item_stores_hint => 'Введіть магазин';

  @override
  String get edit_product_form_item_stores_type => 'магазин';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Хороші практики: Магазини';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Додайте магазин, де ви знайшли цей товар';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Сільпо';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 => 'АТБ';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Місце вироблення';

  @override
  String get edit_product_form_item_origins_hint =>
      'Введіть походження (наприклад, Німеччина)';

  @override
  String get edit_product_form_item_origins_type => 'країна';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Належні практики: Походження';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Додайте **всі вказівки про походження, які ви можете знайти на пакуванні**.\nНе потрібно турбуватися про походження, вказане безпосередньо в списку інгредієнтів.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Яловичина з Аргентини';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Соя не походить з Європейського Союзу';

  @override
  String get edit_product_form_item_countries_title => 'Країна';

  @override
  String get edit_product_form_item_countries_hint =>
      'Введіть країну (наприклад, Німеччина)';

  @override
  String get edit_product_form_item_countries_type => 'країна';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Належні практики: Країни';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Країни, де продукт широко доступний** (не включаючи магазини, що спеціалізуються на іноземних товарах).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Код відстеження';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Введіть код (наприклад: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'коди відстежування';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Належні практики: Коди відстеження';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'У цьому розділі ви можете ввести коди, пов\'язані з **маркуванням пакування**, **ідентифікаційними маркуваннями** або **маркуваннями здоров\'я**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Приклади кодів відстеження';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Коди ЄС**, що використовуються в Європейському Співтоваристві для ідентифікації виробників або пакувальників харчових продуктів:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: код країни **Франція**\n**72.264.002**: географічні дані\n**CE**: Європейський Союз';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB коди**, що використовуються у Франції:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Сліди';

  @override
  String get edit_product_form_item_traces_hint => 'залишок';

  @override
  String get edit_product_form_item_traces_type =>
      'Введіть слід (наприклад: соєві боби)';

  @override
  String get edit_product_form_item_categories_title => 'Категорії';

  @override
  String get edit_product_form_item_categories_hint => 'категорія';

  @override
  String get edit_product_form_item_categories_type =>
      'Введіть категорію (наприклад, апельсиновий сік)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Рекомендовані практики: Категорії';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Вкажіть **тільки найбільш конкретну категорію**.\nБатьківські категорії будуть додані автоматично.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Відсутня категорія?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Якщо категорія **недоступна в автозаповненні**, однаково додайте її. \nЦе допоможе нам покращити Open Food Facts у вашій країні.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Сардини в оливковій олії';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Апельсиновий сік з концентрату';

  @override
  String get edit_product_form_item_exit_title => 'Вийти без збереження?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Бажаєте зберегти зміни, перш ніж покинути цю сторінку?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Зберегти зміни';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Скасувати зміни';

  @override
  String get edit_product_form_item_ingredients_title => 'Інгредієнти';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Збільшуйте та зменшуйте масштаб, притиснувши екран';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Збільшити та зменшити фото';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'За допомогою **Pinch-to-zoom жесту** можна збільшувати або зменшувати масштаб фотографії:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Додати';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Будь ласка, введіть слово';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Видалити';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Зберегти ваше редагування';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Скасувати редагування';

  @override
  String get edit_product_form_item_packaging_title =>
      'Інструкція з перероблювання';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Харчова цінність';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Поживність, вміст алкоголю…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Корисні практики: Харчова цінність';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Харчова цінність';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Спочатку виберіть, чи **значення вказані**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Харчова цінність';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Потім введіть харчову цінність **відповідно до інформації на пакуванні**. Якщо цінність не вказана, ви можете натиснути на піктограму «Око».';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Відсутнє поле?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Якщо якась позиція відсутня, ви можете **натиснути на значок «Плюс»**, щоб додати її (наприклад: вітамін D, магній…).';

  @override
  String get edit_product_form_save => 'Редагувати';

  @override
  String get edit_product_ingredients_photo_title => 'Фото інгредієнтів';

  @override
  String get edit_product_ingredients_list_title => 'Список інгредієнтів';

  @override
  String get edit_product_packaging_photo_title => 'Фото упаковки';

  @override
  String get edit_product_packaging_list_title => 'Пакувальний лист';

  @override
  String get no_data_available => 'Немає даних';

  @override
  String get product_field_website_title => 'Сайт';

  @override
  String get origins_editing_title => 'Редагувати походження';

  @override
  String get completed_basic_details_btn_text => 'Заповніть основні деталі';

  @override
  String get not_implemented_snackbar_text => 'Ще не реалізовано';

  @override
  String get category_picker_page_appbar_text => 'Категорії';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Видобути інгредієнти з фото';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Вилучити інгредієнти';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Отримання інгредієнтів із зображення';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Завантаження фото…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Чому я бачу це повідомлення?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Щоб скористатися функцією «Витяг інгредієнтів», спершу потрібно завантажити фото.\n\nЗачекайте кілька секунд або введіть їх вручну.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Оновити фото';

  @override
  String get edit_packaging_extract_btn_text => 'Видобути упаковку\nз фото';

  @override
  String get edit_packaging_extract_btn_text_short => 'Розпакування пакунків';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Вилучення пакунка з фотографії';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Завантаження фото…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Чому я бачу це повідомлення?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Щоб скористатися функцією «Витягнути упаковку», спочатку потрібно завантажити фотографію.\n\nЗачекайте кілька секунд або введіть їх вручну.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Оновити фото';

  @override
  String get edit_ocr_extract_failed =>
      'Не вдалося опізнати текст зі світлини.';

  @override
  String get edit_ocr_extract_disabled_title => 'Немає картинки!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Щоб скористатися функцією вилучення тексту, потрібно спочатку зробити фото.';

  @override
  String get user_list_dialog_new_title => 'Новий список продуктів';

  @override
  String get user_list_dialog_rename_title => 'Перейменувати список';

  @override
  String get user_list_subtitle_product => 'Списки';

  @override
  String get user_list_title => 'Ваші списки';

  @override
  String get user_list_add_product => 'Додати продукт до ваших списків';

  @override
  String get user_list_button_new => 'Створити новий список';

  @override
  String get user_list_empty_label =>
      'Список ще не доступний, почніть зі створення';

  @override
  String get user_list_button_add_product => 'Додати до списку';

  @override
  String get added_to_list_msg => 'Додано до списку';

  @override
  String get user_list_popup_clear => 'Очистити вашу історію';

  @override
  String get user_list_popup_rename => 'Перейменувати';

  @override
  String get user_list_name_hint => 'Мій список';

  @override
  String get user_list_name_error_empty => 'Назва обов\'язкова';

  @override
  String get user_list_name_error_already => 'Ця назва вже використовується';

  @override
  String get user_list_name_error_same => 'Це та ж сама назва';

  @override
  String get user_list_name_input_hint => 'Назва списку';

  @override
  String get try_again => 'Спробувати ще раз';

  @override
  String get there_was_an_error => 'Виникла помилка';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Не знайдено категорію для $items';
  }

  @override
  String get camera_toggle_camera =>
      'Перемикатися між задньою та передньою камерами';

  @override
  String get camera_toggle_flash => 'Увімкнути або вимкнути спалах камери';

  @override
  String get camera_enable_flash => 'Увімкнути спалах';

  @override
  String get camera_disable_flash => 'Вимкнути спалах';

  @override
  String get camera_flash_error_dialog_title => 'Виникла помилка!';

  @override
  String get camera_flash_error_dialog_message =>
      'Сталася помилка під час зміни стану вашого спалаху. Переконайтеся, що на вашому смартфоні ще не ввімкнено ліхтарик.';

  @override
  String get category_picker_no_category_found_button => 'Назад';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Клацніть, щоб відкрити у вашому браузері або в додатку (якщо встановлено)';

  @override
  String get dev_preferences_screen_title => 'Режим розробника';

  @override
  String get dev_preferences_screen_subtitle =>
      'Доступ до експериментальних функцій та інструментів розробки';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Перезапустити onboarding';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Вам потрібно перезавантажити додаток, щоб побачити його знову.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Переключитися між openfoodfacts.org (PROD) та test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Перевірити параметри довкілля';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Базова URL-адреса для поточного тестового оточення: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Хост тестового середовища';

  @override
  String get dev_preferences_ml_kit_title => 'Застосувати ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'тоді вам доведеться перезапустити цей додаток';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Додаткова кнопка на сторінці продукту';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Редагуйте інгредієнти за допомогою кнопки на панелі знань';

  @override
  String get dev_preferences_export_history_title => 'Експорт історії';

  @override
  String get dev_preferences_export_history_progress_error => 'виняток';

  @override
  String get dev_preferences_export_history_progress_found =>
      'продукт знайдено';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'продукт НЕ знайдено';

  @override
  String get dev_preferences_export_history_dialog_title => 'Експорт історії';

  @override
  String get dev_preferences_button_positive => 'Добре';

  @override
  String get dev_preferences_button_negative => 'Відмінити';

  @override
  String get dev_preferences_migration_title => 'Перенесення даних з V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Статус: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'успішне або нове встановлення';

  @override
  String get dev_preferences_migration_status_success => 'успішно';

  @override
  String get dev_preferences_migration_status_error => 'помилка';

  @override
  String get dev_preferences_migration_status_in_progress => 'в процесі';

  @override
  String get dev_preferences_migration_status_required =>
      'Необхідно (натиснути, щоб розпочати)';

  @override
  String get dev_preferences_migration_status_not_started => 'невідоме';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Очистить історію та помістіть туди 3 продукти';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Користувацьке URL для новин';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL для JSON файлу:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Не встановлено';

  @override
  String get dev_preferences_news_provider_status_title => 'Стан';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Останнє оновлення: $date';
  }

  @override
  String get product_type_label_food => 'Їжа';

  @override
  String get product_type_label_beauty => 'Особистий догляд';

  @override
  String get product_type_label_pet_food => 'Корм для домашніх тварин';

  @override
  String get product_type_label_product => 'Інше';

  @override
  String get product_type_selection_title => 'Тип продукту';

  @override
  String get product_type_selection_subtitle => 'Виберіть тип цього товару';

  @override
  String get product_type_selection_empty =>
      'Спочатку потрібно вибрати тип товару!';

  @override
  String product_type_selection_already(String productType) {
    return 'Ви не можете змінити тип товару ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Ярлик програми «Ціни» на сторінці продукту';

  @override
  String get prices_app_button => 'Перейдіть у додаток Ціни';

  @override
  String get prices_website_button => 'Відкрити на веб-сайті Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Додайте цінники прямо з галереї';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Після вибору зображень Ви не зможете їх редагувати!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'ШІ працюватиме на ваших доказах, щоб отримати ціни.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Дозвольте спільноті перевіряти ціни, отримані за допомогою штучного інтелекту.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Кілька цінників';

  @override
  String get prices_bulk_proof_upload_title =>
      'Масове підтвердження завантаження';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Вибір файлів';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Початок завантаження';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Локальне копіювання файлу #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Підготовка завантаження #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Помилка на зображенні #$index/$count';
  }

  @override
  String get prices_generic_title => 'Ціни';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Додайте $count цін',
      one: 'Додайте ціну',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Надіслати $count ціни',
      many: 'Надіслати $count цін',
      few: 'Надіслати $count ціни',
      one: 'Надіслати$count ціну',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Додати елемент';

  @override
  String get prices_add_a_price => 'Додати ціну';

  @override
  String get prices_add_a_receipt => 'Додати чек';

  @override
  String get prices_add_price_tags => 'Додайте цінові бірки';

  @override
  String prices_barcode_already(String barcode) {
    return 'Цей штрих-код ($barcode) вже є у списку!';
  }

  @override
  String get prices_barcode_search_not_found => 'Товар не знайдено';

  @override
  String get prices_barcode_search_none_yet => 'Ще немає товару';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Шукаю $barcode';
  }

  @override
  String get prices_barcode_enter => 'Введіть штрих-код';

  @override
  String get prices_category_enter => 'Товар без штрих-коду';

  @override
  String get prices_per_kilogram => 'Ціна за кілограм';

  @override
  String get prices_per_unit => 'Ціна за одиницю';

  @override
  String get prices_per_kilogram_short => ' / кг';

  @override
  String get prices_per_unit_short => ' / одиниця';

  @override
  String get prices_category_mandatory => 'Обов\'язковий';

  @override
  String get prices_category_optional => 'Необов\'язково';

  @override
  String get prices_category_error_mandatory => 'Категорія обов\'язкова';

  @override
  String get prices_barcode_reader_action => 'Сканер штрих-коду';

  @override
  String get prices_view_prices => 'Переглянути ціни';

  @override
  String get prices_list_title => 'Прайс-лист';

  @override
  String get prices_list_count => 'Кількість цін\n';

  @override
  String get prices_list_add_new_price => 'Додати нову ціну\n';

  @override
  String get prices_list_empty_title => 'Ціни ще немає!';

  @override
  String get prices_list_empty_subtitle =>
      'Додайте першим:\nВідскануйте **чек** або **цінник**!';

  @override
  String get prices_entry_shop_not_found => 'Невідомий магазин';

  @override
  String prices_entry_menu_title(String user) {
    return 'Введена ціна від \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Переглянути всі ціни на цей товар';

  @override
  String get prices_entry_menu_open_proof => 'Переглянути доказ';

  @override
  String get prices_entry_menu_my_prices => 'Переглянути інші мої ціни';

  @override
  String get prices_entry_menu_author_prices => 'Переглянути інші ціни автора';

  @override
  String get prices_entry_menu_shop_prices =>
      'Переглянути інші ціни з магазину';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ціни',
      one: '1 ціна',
    );
    return '$_temp0 за $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Усі $count ціни',
      one: 'Тільки одна ціна',
      zero: 'Ціни ще немає',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Останні $pageSize ціни (всього: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Ціна: $price / Магазин: \"$location\" / Опубліковано $date користувачем \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Відкрити докази від \"$user\"';
  }

  @override
  String get prices_open_proof => 'Доказ відкритої ціни';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Усі $count докази',
      one: 'Тільки один доказ',
      zero: 'Доказів ще немає',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Останні $pageSize докази (всього: $total)';
  }

  @override
  String get prices_users_empty_title => 'Ще немає учасників!';

  @override
  String get prices_users_empty_explanation =>
      'Будьте першим, хто додасть ціну!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Топ $pageSize учасників (всього: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Магазину ще немає!';

  @override
  String get prices_locations_empty_explanation =>
      'Будьте першим, хто додасть ціну!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Топ $pageSize місць (всього: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count proofs',
      one: 'One proof',
      zero: 'No proof',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: 'One product',
      zero: 'No product',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count users',
      one: 'One user',
      zero: 'No user',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: 'One price',
      zero: 'No price',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Ціна додана раніше';

  @override
  String get prices_amount_subtitle => 'Кількість';

  @override
  String get prices_amount_is_discounted => 'Чи є знижка?';

  @override
  String get prices_amount_price_normal => 'Ціна';

  @override
  String get prices_amount_price_discounted => 'Ціна зі знижкою';

  @override
  String get prices_amount_price_not_discounted => 'Початкова ціна';

  @override
  String get prices_amount_no_product => 'Бракує одного товару!';

  @override
  String get prices_amount_price_incorrect => 'Помилкове значення';

  @override
  String get prices_amount_price_mandatory => 'Обов\'язкове значення';

  @override
  String get prices_currency_subtitle => 'Валюта';

  @override
  String get prices_date_subtitle => 'Дата';

  @override
  String get prices_location_subtitle => 'Крамниця';

  @override
  String get prices_location_find => 'Знайти магазин';

  @override
  String get prices_location_mandatory => 'Вам потрібно вибрати магазин!';

  @override
  String get prices_location_search_broader =>
      'Не змогли знайти те, що шукали? Давайте спробуємо розширити пошук!';

  @override
  String get prices_proof_subtitle => 'Доказ';

  @override
  String get prices_proof_empty_title => 'Поки що немає доказів!';

  @override
  String get prices_proof_empty_explanation =>
      'Почніть із додавання фотографії **чек** або **цінника**!';

  @override
  String get prices_proof_find => 'Виберіть доказ';

  @override
  String get prices_proof_change => 'Змінити доказ';

  @override
  String get prices_proof_receipt => 'Квитанція';

  @override
  String get prices_proof_price_tag => 'Цінник';

  @override
  String get prices_proof_mandatory => 'Вам потрібно вибрати доказ!';

  @override
  String get prices_add_validation_error => 'Помилка перевірки';

  @override
  String get prices_privacy_warning_title =>
      'Попередження про конфіденційність';

  @override
  String get prices_unknown_product => 'Невідомий продукт';

  @override
  String get prices_privacy_warning_main_message =>
      'Ціни **будуть оприлюднені** разом із магазином, до якого вони відносяться.\n\nЦе може дозволити людям, які знають про ваш псевдонім в Open Food Facts:';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Визначте, в якій області ви проживаєте';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Знайте, що купуєте';

  @override
  String get prices_privacy_warning_sub_message =>
      'Якщо вас це турбує, будь ласка, змініть свій псевдонім або створіть новий обліковий запис Open Food Facts і увійдіть в додаток за допомогою нього.';

  @override
  String get i_refuse => 'Відмовляюсь';

  @override
  String get i_accept => 'Я приймаю';

  @override
  String get prices_currency_change_proposal_title => 'Змінити валюту?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Ваша поточна валюта – **$currency**. Бажаєте змінити її на **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Так, використовувати $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Ні, залишити $currency';
  }

  @override
  String get prices_menu_know_more => 'Знайте більше про Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Виконано';

  @override
  String get dev_mode_section_server => 'Конфігурація сервера';

  @override
  String get dev_mode_section_news => 'Конфігурація постачальника новин';

  @override
  String get dev_mode_section_product_page => 'Сторінка продукту';

  @override
  String get dev_mode_section_ui => 'Інтерфейс користувача';

  @override
  String get dev_mode_section_experimental_features =>
      'Експериментальні функції';

  @override
  String get dev_mode_hide_environmental_score_title => 'Виключити Green Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Використовуйте перевірку орфографії для OCR екранів';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Інгредієнти та упаковка)';

  @override
  String get dev_mode_reset_app_language_title => 'Скинути мову програми';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Додати картки';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Перемикання між prices.openfoodfacts.org (PROD) та тестовим середовищем';

  @override
  String get search_history_item_edit_tooltip =>
      'Повторно використовуйте та редагуйте цей пошук';

  @override
  String get search_history_item_remove_tooltip => 'Видалити';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Всі $totalSize продукти завантажено.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Завантажити ще $count товарів\nВже завантажено $downloaded з $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Ваш пошук $search триває. Будь ласка, зачекайте кілька секунд…';
  }

  @override
  String get user_search_contributor_title => 'Додані мною продукти';

  @override
  String get user_search_informer_title => 'Відредаговані мною продукти';

  @override
  String get user_search_photographer_title => 'Сфотографовані мною продукти';

  @override
  String get user_search_to_be_completed_title => 'Мої завершені товари';

  @override
  String get user_search_prices_title => 'Мої ціни';

  @override
  String get user_search_proofs_title => 'Мої докази';

  @override
  String get user_search_proof_title => 'Мої докази';

  @override
  String search_proof_title(String user) {
    return '';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Ціни для учасників: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Останні додані ціни';

  @override
  String get all_search_prices_top_user_title => 'Найбільші учасники цін';

  @override
  String get all_search_prices_top_location_title =>
      'Магазини з найбільшими цінами';

  @override
  String get prices_contribution_assistant => 'Помічник внеску цін';

  @override
  String get prices_validation_assistant => 'Помічник Перевірки Ціни';

  @override
  String get prices_challenges_page => 'Випробування';

  @override
  String get prices_multiple_proof_addition_system => 'Додайте кілька доказів';

  @override
  String get all_search_prices_top_location_single_title => 'Ціни в магазині';

  @override
  String get all_search_prices_top_product_title => 'Товари з найбільшою ціною';

  @override
  String get all_search_to_be_completed_title => 'Мої завершені товари';

  @override
  String get categorize_products_country_title =>
      'Допоможіть класифікувати продукти у вашій країні';

  @override
  String get edit_product_action_retake_picture => 'Переробити фото';

  @override
  String get edit_product_action_take_picture => 'Зробити знімок';

  @override
  String get edit_product_action_confirm => 'Підтвердити';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Я погоджуюсь з Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => 'умови використання та внесок';

  @override
  String get analytics_consent_image_semantic_label => 'Значок аналітики';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Фатальна помилка: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Фатальна помилка: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Заповніть основні деталі';

  @override
  String get edit_photo_button_label => 'Редагувати';

  @override
  String get edit_photo_unselect_button_label => 'Скасувати вибір фото';

  @override
  String get edit_photo_select_existing_button_label =>
      'Вибрати наявне зображення';

  @override
  String get edit_photo_select_existing_all_label =>
      'Існуючі зображення для цього продукту';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Виберіть зображення, натиснувши на нього';

  @override
  String get edit_photo_select_existing_download_label =>
      'Отримання наявних зображень…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Немає раніше завантажених зображень, пов’язаних із цим продуктом.';

  @override
  String get edit_photo_language_not_this_one =>
      'Ще немає зображення цією мовою';

  @override
  String get edit_photo_language_none => 'Ще немає зображення';

  @override
  String get category_picker_screen_title => 'Категорії';

  @override
  String get basic_details => 'Основні деталі';

  @override
  String get product_name => 'Назва продукту';

  @override
  String get product_names => 'Назви товарів';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Додати новий переклад';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Перед перевіркою переконайтеся, що ви додаєте переклад, лише **якщо мова вказана на упаковці**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Перегляд фото передньої частини';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Зробіть переднє фото';

  @override
  String get add_basic_details_product_name_hint =>
      'Введіть назву продукту (наприклад, Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Змінити мову за замовчуванням?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Ви хочете встановити мову продукту за замовчуванням на «$language»?';
  }

  @override
  String get explanation_section_good_examples => 'Гарні приклади';

  @override
  String get explanation_section_bad_examples => 'Погані приклади';

  @override
  String get add_basic_details_product_name_help_title =>
      'Належні практики: Назва продукту';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Назва продукту — це **основна назва, надрукована на упаковці**. Це може бути зареєстрована торгова марка.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Примітка:** Будь ласка, не додавайте переклад, **якщо мова не вказана на упаковці**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Несквік';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Томатний кетчуп';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Не включайте бренд у назву';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Томатний кетчуп **від Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Не використовуйте символи ®, ™, © або подібні';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count інші переклади',
      many: '$count інші переклади',
      few: '$count інші переклади',
      one: '$count інший переклад',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Назва бренду';

  @override
  String get brand_names => 'Торгові марки';

  @override
  String get add_basic_details_brand_name_error =>
      'Будь ласка, введіть назву бренду';

  @override
  String get add_basic_details_brand_names_hint =>
      'Введіть бренди (наприклад, Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Належні практики: Бренди';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Введіть **всі бренди продукту**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Основний бренд';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Основний бренд**, який зазвичай чітко зображений на передній стороні пакування, слід **вводити першим**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Інші бренди';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Коли продається **великою компанією**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Актимель** продається компанією **Данон**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Коли продається з брендом, **перекладеним кількома мовами**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** іноді написано як **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Нутелла';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Орео, Монделез';

  @override
  String get quantity => 'Кількість і вага';

  @override
  String get add_basic_details_quantity_hint =>
      'Введіть вагу та, якщо необхідно, кількість (наприклад, 4x100 г)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Належні практики: Кількість';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Скопіюйте значення, зазначене на товарі, і **не забудьте про одиниці вимірювання**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230г** або **230 г**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (для 6 яєць)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 г**\n(для продукту з 3 коробками, кожна по 150 г)';

  @override
  String get barcode => 'Код товару';

  @override
  String barcode_barcode(String barcode) {
    return 'Штрих-код: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Штрих-код не є дійсним';

  @override
  String get basic_details_add_success => 'Основні деталі успішно додано';

  @override
  String get basic_details_add_error =>
      'Неможливо додати основні деталі. Спробуйте ще раз через деякий час';

  @override
  String get clear_search => 'Очистити поле пошуку';

  @override
  String get confirm_clear =>
      'Ви збираєтеся очистити всю свою історію: ви впевнені, що бажаєте продовжити?';

  @override
  String get alert_clear_selected_user_list =>
      'Ви збираєтеся очистити вибрані елементи в історії';

  @override
  String get confirm_clear_selected_user_list =>
      'Ви впевнені, що хочете продовжити?';

  @override
  String get alert_select_items_to_clear =>
      'Виберіть один або кілька елементів для очищення';

  @override
  String confirm_clear_user_list(String name) {
    return 'Ви збираєтеся очистити цей список ($name): ви впевнені, що бажаєте продовжити?';
  }

  @override
  String get confirm_delete_user_list_title => 'Видалити цей список?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Ви збираєтеся видалити цей список \"$name\".\nВи впевнені, що бажаєте продовжити?';
  }

  @override
  String get confirm_delete_user_list_button => 'Так, я підтверджую';

  @override
  String importance_label(String name, String id) {
    return '$name важливість: $id';
  }

  @override
  String get user_list_all_title => 'Списки';

  @override
  String get user_list_all_empty => 'Створіть перший список';

  @override
  String get product_list_select => 'Виберіть список';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count продукти',
      one: 'Один продукт',
      zero: 'Порожній список',
      many: '$count продукти',
      few: '$count продукти',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Додати список';

  @override
  String get open_food_preferences_tooltip =>
      'Відредагуйте свої вподобання в їжі';

  @override
  String get add_photo_button_label => 'Додати фотографію';

  @override
  String get add_packaging_photo_button_label =>
      'Сфотографуйте будь-яку інформацію про упаковку/переробку';

  @override
  String get add_origin_photo_button_label =>
      'Фотографуйте будь-яку інформацію про походження';

  @override
  String get add_emb_photo_button_label =>
      'Фотографуйте будь-яку інформацію про код відстеження';

  @override
  String get add_label_photo_button_label =>
      'Фотографуйте будь-які етикетки та інформацію про сертифікати';

  @override
  String get choose_image_source_title => 'Виберіть джерело зображення';

  @override
  String get choose_image_source_body =>
      'Будь ласка, оберіть джерело зображення';

  @override
  String get gallery_source_label => 'Галерея';

  @override
  String get gallery_source_access_denied_dialog_title => 'Доступ заборонено';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'На жаль, програма не може отримати доступ до вашої галереї, оскільки ви раніше відмовили в дозволі.\n\nБудь ласка, перейдіть до налаштувань програми у своєму телефоні Налаштування -> Фотографії';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Відкрийте Налаштування';

  @override
  String get share => 'Поділитися';

  @override
  String share_product_text(String url) {
    return 'Перегляньте цей продукт на Open  Food  Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Перегляньте цей продукт на Open  Food  Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Подивіться на цей товар на Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Перегляньте цей продукт на Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Перегляньте мій список продуктів на Open  Food  Facts: $url';
  }

  @override
  String get capture => 'Зробити нове фото';

  @override
  String get capture_new_picture => 'Сфотографувати';

  @override
  String get choose_from_gallery => 'Вибрати з галереї';

  @override
  String get image_upload_queued =>
      'Зображення буде завантажено у фоновому режимі якомога швидше.';

  @override
  String get add_price_queued => 'Ціна буде надіслана на сервер якнайшвидше.';

  @override
  String get background_task_title_full_refresh =>
      'Запуск оновлення всіх продуктів, які зберігаються локальна';

  @override
  String get background_task_title_top_n =>
      'Початок завантаження найпопулярніших продуктів';

  @override
  String get expand_nutrition_facts =>
      'Розгорнути таблицю фактів про поживні речовини';

  @override
  String get expand_nutrition_facts_body =>
      'Тримайте таблицю фактів харчування розширеною';

  @override
  String get expand_ingredients => 'Розгорнути інгредієнти';

  @override
  String get expand_ingredients_body =>
      'Тримайте панель інгредієнтів розгорнутою';

  @override
  String get no_internet_connection => 'Відсутнє підключення до Інтернету';

  @override
  String get world_results_label => 'Весь світ';

  @override
  String get world_results_action => 'Розширте свій пошук на весь світ';

  @override
  String get copy_to_clipboard => 'Копіювати';

  @override
  String get paste_from_clipboard => 'Вставити з буферу';

  @override
  String get no_data_available_in_clipboard =>
      'У вашому буфері обміну немає даних';

  @override
  String get clipboard_barcode_copy => 'Скопіювати штрих-код в буфер обміну';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Штрих-код $barcode скопійовано в буфер обміну!';
  }

  @override
  String get open_product_website => 'Відкрити цей товар на веб-сайті';

  @override
  String get language_picker_label => 'Ваша мова';

  @override
  String get country_picker_label => 'Ваша країна';

  @override
  String get currency_picker_label => 'Ваша валюта';

  @override
  String get help_with_openfoodfacts => 'Допомога з OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Продукт буде оновлено у фоновому режимі якомога швидше.';

  @override
  String get no_email_client_available_dialog_title =>
      'Немає поштового застосунку!';

  @override
  String get no_email_client_available_dialog_content =>
      'Будь ласка, надішліть нам електронний лист вручну на mobile@openfoodfacts.org';

  @override
  String get all_images => 'Усі зображення';

  @override
  String get selected_images => 'Вибрані зображення';

  @override
  String get product_card_remove_product_tooltip => 'Видалити продукт';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Новий сканований штрих-код: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Видалити всі продукти з каруселі';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Проскануйте принаймні два продукти, щоб порівняти їх';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Натисніть щоб порівняти проскановані продукти';

  @override
  String get scan_product_loading => 'Ви відсканували\nштрих-коду:';

  @override
  String get scan_product_loading_initial =>
      'Ми шукаємо цей товар!\nБудь ласка, зачекайте кілька секунд…';

  @override
  String get scan_product_loading_long_request =>
      'Ми все ще шукаємо цей продукт!\nзнайдемо для завантаження займає багато часу? Так, ми…';

  @override
  String get scan_product_loading_unresponsive =>
      'Ми все ще шукаємо цей продукт.\nХочете відновити пошук?';

  @override
  String get scan_product_loading_restart_button => 'Перезапустити пошук';

  @override
  String get portion_calculator_description =>
      'Розрахуйте поживну цінність для певної кількості';

  @override
  String get portion_calculator_hint => 'Кількість в';

  @override
  String get portion_calculator_accessibility =>
      'Вкажіть кількість для обчислення харчових продуктів';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Будь ласка, введіть кількість від $min до $max г';
  }

  @override
  String get portion_calculator_computation_error =>
      'Відсутні дані. Не вдалося виконати розрахунок.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Харчова цінність $grams г (або мл)';
  }

  @override
  String get offline_data => 'Офлайн-дані';

  @override
  String get ocr_image_upload_instruction =>
      'Завантажте зображення, щоб автоматично отримати надану інформацію.';

  @override
  String get upload_image => 'Завантажити фото';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Не вдалося завантажити зображення';

  @override
  String get image_edit_url_error =>
      'Не вдалося редагувати зображення, оскільки URL-адресу зображення не вказано.';

  @override
  String get user_picture_source_remember => 'Запам\'ятати';

  @override
  String get user_picture_source_ask => 'Запитувати щоразу';

  @override
  String get robotoff_continue => 'Продовжити';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count запитання',
      one: 'запитання',
    );
    return 'Наступне $_temp0';
  }

  @override
  String get show_password => 'Показати пароль';

  @override
  String get owner_field_info_title => 'Значення надав виробник';

  @override
  String get owner_field_info_message =>
      'Цим логотипом ми виділяємо дані, надані виробником, і їх неможливо редагувати.';

  @override
  String get owner_field_info_close_button => 'Закрити цю інформацію';

  @override
  String get owner_field_image =>
      'Це зображення надано виробником. Його не можна редагувати.';

  @override
  String get edit_packagings_title => 'Пакетні компоненти';

  @override
  String get edit_packagings_element_add => 'Додайте елемент упакування';

  @override
  String get edit_packagings_completed => 'Пакування завершено';

  @override
  String edit_packagings_element_title(int index) {
    return 'Пакування компоненту #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Кількість одиниць';

  @override
  String get edit_packagings_element_hint_units =>
      'Введіть кількість пакувальних одиниць однакової форми та матеріалу, які містяться в продукті.';

  @override
  String get edit_packagings_element_field_shape => 'Форма';

  @override
  String get edit_packagings_element_hint_shape =>
      'Введіть назву форми, вказану в інструкціях з перероблювання, якщо вони доступні, або виберіть форму.';

  @override
  String get edit_packagings_element_example_shape => 'Пляшка';

  @override
  String get edit_packagings_element_field_material => 'Матеріал';

  @override
  String get edit_packagings_element_hint_material =>
      'Введіть конкретний матеріал, якщо він може бути визначений (матеріальний код всередині трикутника часто можна знайти на упаковуванні) або загальний матеріал (наприклад пластик чи метал) якщо ви не впевнені.';

  @override
  String get edit_packagings_element_example_material => 'Скло';

  @override
  String get edit_packagings_element_field_recycling =>
      'Інструкція по переробці';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Вказуйте інструкції з утилізації, тільки якщо вони зазначені на виробі.';

  @override
  String get edit_packagings_element_example_recycling => 'Переробка';

  @override
  String get edit_packagings_element_field_quantity =>
      'Чиста кількість продукту на одиницю';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Введіть вагу нетто або об\'єм нетто і вкажіть одиницю виміру (наприклад, г або мл).';

  @override
  String get edit_packagings_element_field_weight => 'Вага пустої одиниці (г)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Перед зважуванням видаліть залишки їжі, вимийте та висушіть пакувальну частину. Якщо можливо, використовуйте ваги з точністю до 0,1 г або 0,01 г.';

  @override
  String get background_task_title => 'Чекає на внесок';

  @override
  String get background_task_subtitle =>
      'Ваші внески зберігаються автоматично (але не завжди в режимі реального часу).';

  @override
  String get background_task_list_empty => 'Незавершених завдань немає';

  @override
  String get background_task_error_server_time_out => 'Час очікування сервера';

  @override
  String get background_task_error_no_internet =>
      'Не вдалося підключитися до інтернету. Спробуйте пізніше.';

  @override
  String get background_task_operation_unknown => 'невідома операція';

  @override
  String get background_task_operation_details => 'детально про зміни';

  @override
  String get background_task_operation_image => 'завантажити світлину';

  @override
  String get background_task_operation_refresh =>
      'оновлення відбувається із затримкою після завантаження фотографій';

  @override
  String get background_task_run_started => 'розпочато';

  @override
  String get background_task_run_not_started => 'ще не розпочато';

  @override
  String get background_task_run_to_be_deleted => 'буде вилучено';

  @override
  String get background_task_question_stop =>
      'Ви хочете припинити це завдання якомога швидше?';

  @override
  String get feed_back => 'Відгук';

  @override
  String get undo => 'Скасувати';

  @override
  String get copy_email_to_clip_board => 'Скопіюйте лист до буфера обміну';

  @override
  String get please_send_us_an_email_to =>
      'Будь ласка, надішліть нам електронного листа на адресу';

  @override
  String get email_copied_to_clip_board => 'Лист скопійовано в буфер обміну!';

  @override
  String get select_accent_color => 'Виберіть колір акценту';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Синій';

  @override
  String get color_cyan => 'Голубий';

  @override
  String get color_green => 'Зелений';

  @override
  String get color_light_brown => 'За умовчанням';

  @override
  String get color_magenta => 'Пурпуровий';

  @override
  String get color_orange => 'Оранжевий';

  @override
  String get color_pink => 'Рожевий';

  @override
  String get color_red => 'Червоний';

  @override
  String get color_rust => 'Іржавий';

  @override
  String get color_teal => 'Бірюзовий';

  @override
  String get text_contrast_mode => 'Контрастність тексту';

  @override
  String get contrast_high => 'Висока';

  @override
  String get contrast_medium => 'Середня';

  @override
  String get contrast_low => 'Низька';

  @override
  String get product_refresher_internet_not_found => 'Продукт не знайдено!';

  @override
  String get product_refresher_internet_not_connected =>
      'Ви не підключені до Інтернету!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Сервер не працює ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Помилка сервера ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Продукт не знайдено!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Товар з таким штрих-кодом не існує в нашій базі даних: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Немає підключення до інтернету!';

  @override
  String get product_loader_network_error_message =>
      'Переконайтеся, що ваш смартфон підключений до мережі WiFi або увімкнений мобільний зв\'язок';

  @override
  String get page_not_found_title => 'Сторінку не знайдено!';

  @override
  String get page_not_found_button => 'Поверніться на головну сторінку';

  @override
  String get download_data => 'Завантажити дані';

  @override
  String get download_top_products =>
      'Завантажте 1000 найпопулярніших продуктів у вашій країні для миттєвого сканування';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count продуктів',
      many: '$count продуктів',
      few: '$count продукти',
      one: '$count продукти',
    );
    return 'Завантажте найкращі $_temp0 у вашій країні для миттєвого сканування';
  }

  @override
  String get download_in_progress =>
      'Завантаження даних\nЦе може зайняти деякий час';

  @override
  String downloaded_products(int num) {
    return '$num продуктів додано';
  }

  @override
  String get update_offline_data => 'Оновіть дані продукту офлайн';

  @override
  String get update_local_database_sub =>
      'Оновіть базу даних місцевих продуктів останніми даними від Open Food Facts';

  @override
  String get clear_local_database => 'Очистіть дані продукту офлайн';

  @override
  String get clear_local_database_sub =>
      'Видаліть всі локальні дані про продукти, щоб звільнити місце';

  @override
  String deleted_products(int num) {
    return '$num продуктів видалено';
  }

  @override
  String get loading => 'Завантаження…';

  @override
  String get know_more => 'Докладніше';

  @override
  String get offline_data_desc =>
      'Натисніть, щоб дізнатися більше про офлайн-дані';

  @override
  String get offline_product_data_title => 'Дані продукту офлайн';

  @override
  String available_for_download(int num) {
    return '$num продуктів доступні для миттєвого сканування';
  }

  @override
  String get country_selector_title => 'Оберіть вашу країну:';

  @override
  String get currency_selector_title => 'Оберіть Вашу валюту:';

  @override
  String get language_selector_title => 'Виберіть свою мову:';

  @override
  String get language_selector_section_selected => 'Вибрані мови';

  @override
  String get language_selector_section_frequently_used => 'Часто вживані';

  @override
  String get action_delete_list => 'Видалити';

  @override
  String get action_change_list => 'Змінити поточний список';

  @override
  String get product_list_create => 'Створити';

  @override
  String get product_list_create_tooltip => 'Створити новий список';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Оцінка Nutri-Score A';

  @override
  String get nutriscore_b => 'Оцінка Nutri-Score B';

  @override
  String get nutriscore_c => 'Оцінка Nutri-Score C';

  @override
  String get nutriscore_d => 'Оцінка Nutri-Score D';

  @override
  String get nutriscore_e => 'Оцінка Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (новий розрахунок)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Новий розрахунок)';

  @override
  String get nutriscore_unknown => 'Невідома оцінка Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Невідомий Nutri-Score (новий розрахунок)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score не застосовується';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score не застосовується (новий розрахунок)';

  @override
  String get environmental_score_generic_new =>
      'Green-Score (показник впливу на довкілля)';

  @override
  String get environmental_score_a_new => 'Зелений бал A';

  @override
  String get environmental_score_b_new => 'Зелений бал B';

  @override
  String get environmental_score_c_new => 'Зелений бал C';

  @override
  String get environmental_score_d_new => 'Зелений бал D';

  @override
  String get environmental_score_e_new => 'Зелений бал E';

  @override
  String get environmental_score_unknown_new => 'Невідомий зелений бал';

  @override
  String get environmental_score_not_applicable_new =>
      'Грін-Скор не застосовується';

  @override
  String get nova_group_generic_new => 'Ультраоброблені продукти - групи NOVA';

  @override
  String get nova_group_1 => 'Група NOVA 1';

  @override
  String get nova_group_2 => 'Група NOVA 2';

  @override
  String get nova_group_3 => 'Група NOVA 3';

  @override
  String get nova_group_4 => 'Група NOVA 4';

  @override
  String get nova_group_unknown => 'Невідома група NOVA';

  @override
  String get nutrition_facts => 'Рівні поживних речовин';

  @override
  String get faq_title_partners => 'Партнери та Патрони НГО';

  @override
  String get faq_title_vision =>
      'Концепція, завдання, цінності та програми Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Встановіть Open Beauty Facts для створення косметичної бази даних';

  @override
  String get faq_title_install_pet =>
      'Встановіть Open Pet Food Facts щоб створити базу даних для домашніх тварин';

  @override
  String get faq_title_install_product =>
      'Встановіть Open Products Facts, щоб створити базу даних продуктів і подовжити термін служби об’єктів';

  @override
  String get faq_nutriscore_nutriscore =>
      'Новий розрахунок Nutri-Score: що нового?';

  @override
  String get contact_title_pro_page =>
      'Pro? Імпортуйте свої продукти в Open Food Facts';

  @override
  String get contact_title_pro_email => 'Контакт виробника';

  @override
  String get contact_title_press_page => 'Інформація для преси';

  @override
  String get contact_title_press_email => 'Контакти для преси';

  @override
  String get contact_title_newsletter => 'Підпишіться на нашу розсилку новин';

  @override
  String get contact_title_calendar =>
      'Підпишіться на календар нашої спільноти';

  @override
  String get hunger_games_loading_line1 =>
      'Будь ласка, дайте нам кілька секунд…';

  @override
  String get hunger_games_loading_line2 => 'Ми завантажуємо питання!';

  @override
  String get hunger_games_error_label =>
      'Ох! Щось пішло не так… і ми не змогли завантажити питання.';

  @override
  String get hunger_games_error_retry_button => 'Давайте спробуємо ще раз!';

  @override
  String get reorder_attribute_action => 'Змінити порядок атрибутів';

  @override
  String get link_cant_be_opened =>
      'Це посилання не може бути відкрито на вашому пристрої. Будь ласка, перевірте чи встановлено браузер.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Деталі для $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Деталі для $pageName з $productName';
  }

  @override
  String get guide_title => 'Посібник';

  @override
  String get guide_share_label => 'Поділитися';

  @override
  String get guide_nutriscore_v2_title =>
      'Nutri-Score розвивається: пояснення!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Що таке Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Nutri-Score – це логотип, мета якого інформувати вас про **поживну якість харчових продуктів**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'Кольоровий код варіюється від темно-зеленого (**A**) для **найздоровіших** продуктів до темно-червоного (**E**) для **менш корисних** продуктів.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'Логотип Nutri-Score A';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Чому Nutri-Score розвивається?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'Формула Nutri-Score **еволюціонує**, щоб надавати кращі рекомендації:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title => 'Краще оцініть всі напої';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'Порівняльні ноти **молока**, **молочних напоїв** з додаванням цукру та **овочевих** напоїв у новому алгоритмі краще розрізнили.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title => 'Кращий рейтинг напоїв';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      '**Вміст цукру** краще брати до уваги, і він надає перевагу напоям із **слабким вмістом цукру**.\\n**Підсолоджувачі також будуть штрафуватися**: рейтинг дієтичних газованих напоїв буде знижено з B до C і E. Вода залишається рекомендованим напоєм.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title => 'Сіль і цукор штрафні';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Продукти **занадто солодкі** або **занадто солоні** отримають **рейтинг ще більше знижений**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title => 'Ієрархія в оліях і рибі';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'Поліпшиться рейтинг певної **жирної риби** та **олій, багатих хорошими жирами**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Обмежити червоне м\'ясо';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Споживання **червоного м’яса слід обмежити**. Ось чому **птах матиме порівняно кращий рейтинг**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Як відрізнити старий Nutri-Score від нового розрахунку?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'Відтепер логотип може показувати згадку «**Новий розрахунок**», щоб уточнити, що це справді новий розрахунок.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Логотип нового Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Де знайти новий розрахунок Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score застосовується в 7 країнах: Франції, Німеччині, Бельгії, Іспанії, Люксембурзі, Нідерландах і Швейцарії.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Виробники мають максимум **2 роки** після підпису декларації **щоб замінити** старі розрахунки новими.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Без очікування ви вже знайдете в додатку OpenFoodFacts новий розрахунок, включаючи в тому числі якщо постачальники не оновили бали.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Що не змінилося';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Nutri-Score – це оцінка, розроблена для **вимірювання якості харчування**. Він **доповнює групу NOVA** щодо **ультраоброблених продуктів** (також присутня в додатку).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Для постачальників зображення Nutri-Score **залишається необов’язковим**.';

  @override
  String get guide_greenscore_title =>
      'Green-Score (показник впливу на довкілля)';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Що таке Зелений бал?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      '«Зелений бал» – це логотип, метою якого є інформування про **вплив їжі на навколишнє середовище**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Колірний код варіюється від темно-зеленого (**A+**) для продуктів з **найменшим впливом** до темно-червоного (**F**) для продуктів з **найбільшим впливом**.';

  @override
  String get guide_greenscore_logos_caption => 'Логотипи Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Основне: Оцінка життєвого циклу (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Наукова оцінка категорій харчових продуктів';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Для кожної категорії продуктів встановлюється **бенчмарк** з використанням даних з екологічної бази даних Agribalyse (розробленої ADEME та INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Аналіз життєвого циклу** – це стандартизований метод оцінки для проведення багатоетапної та багатокритеріальної екологічної оцінки.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Він вимірює:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 етапів виробництва';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Сільське господарство';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Обробляється';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Упаковка';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Транспортування';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Поширення';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Споживання';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 показників впливу на навколишнє середовище';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'Зміна клімату/вуглецевий слід';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Руйнування озонового шару';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Іонізуюче випромінювання';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Земля';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Використання води та енергії';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Забруднення повітря';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Морська та прісна вода (частинки, підкислення, евтрофікація)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Виснаження ресурсів.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Бонуси та штрафи';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Щоб винагородити кращі продукти в межах категорії, ми застосовуємо **бонуси та штрафи на основі кількох критеріїв**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Спосіб виробництва';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Бонус** надається продуктам, які мають **офіційну етикетку, маркування або сертифікат, що гарантує екологічні переваги** (органічний, справедлива торгівля, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Походження інгредієнтів';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Бонус** надається залежно від походження інгредієнтів. Цей бонус враховує **вплив на транспортування**, а також **екологічну політику** країни кожного виробника.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Види, які знаходяться під загрозою зникнення';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Штраф** накладається на продукти, що містять інгредієнти, які мають значний **негативний вплив на біорізноманіття та екосистеми**, такі як пальмова олія, виробництво якої є причиною масового вирубування лісів.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Упаковка';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Штраф** розраховується з урахуванням **циклічності пакування** (використання переробленої сировини та можливість вторинної переробки) та перепакування.';

  @override
  String get guide_greenscore_transparency_title =>
      'Зростання потреби в прозорості для кращого вимірювання та зменшення впливу на навколишнє середовище';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Для точного розрахунку Green-Score необхідно мати **інформацію, яка не обов\'язково вказана на упаковці** (таку як походження та точний відсоток кожного інгредієнта) або яка рідко доступна у придатній для використання формі (таку як перелік усіх компонентів упаковки з точним зазначенням типів використаних пластиків).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Якщо ця інформація ще не доступна, використовуються середні значення**, але зараз ми звертаємося до всіх із проханням допомогти нам зібрати цю інформацію, яка буде дуже корисною для Green-Score, а також для багатьох інших цілей.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Як громадяни можуть допомогти?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Всі громадяни можуть допомогти нам зібрати та систематизувати інформацію, яка міститься на продуктах або може бути виведена з них, наприклад, інформацію на **упаковці**: «Mission Emballages»: великомасштабний спільний інвентар упаковки для всіх харчових продуктів (французькою мовою).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Як виробники можуть допомогти';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Виробники можуть надсилати нам свою інформацію безпосередньо через нашу безкоштовну платформу для виробників.';

  @override
  String get guide_greenscore_better_product_title =>
      'Який продукт кращий для планети?';

  @override
  String get guide_greenscore_better_product_arg1_title => 'Важко сказати';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Вибір екологічно чистих продуктів харчування – це один із найпотужніших кроків, які ми можемо зробити для клімату, оскільки **наша глобальна продовольча система відповідає за понад чверть усіх викидів парникових газів**.\n(Джерело: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'У тебе є сила!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Гарна новина полягає в тому, що це дає нам потужний спосіб змінити світ на краще.\n**Кожен з нас з\'їдає близько 1000 страв щороку**. Це 1000 можливостей **обрати краще майбутнє для планети**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Допомагає бути відповідальним та приймати рішення';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Вибір екологічно чистих продуктів харчування може здатися складним. Етикетки заплутують, а інформація часто відсутня. Green-Score був створений для того, щоб спростити цей процес, надаючи вам **чіткий**, **науково обґрунтований** та **прозорий** екологічний рейтинг харчових продуктів саме там, де вам це потрібно: під час покупок.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Прозорість';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'На відміну від власних позначок, розрахунок Green-Score є **повністю відкритим** і може бути **перевірений будь-ким**.';

  @override
  String get guide_nova_title => 'Ультраоброблені продукти';

  @override
  String get guide_nova_what_is_nova_title => 'Що таке ультраобробка?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Групи NOVA інформують вас про **рівень обробки харчових продуктів**.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Класифікація NOVA дозволяє класифікувати продукти харчування на **4 групи** залежно від їхнього **ступеню промислової обробки** (мінімально оброблені або необроблені продукти, кулінарні інгредієнти, оброблені продукти, ультраоброблені продукти).';

  @override
  String get guide_nova_logos_caption => 'Логотипи NOVA';

  @override
  String get guide_nova_groups_title => '4 групи NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Існує 4 групи NOVA, проблемною є Група 4 – Ультраоброблені продукти.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Мінімально оброблені або необроблені продукти';

  @override
  String get guide_nova_groups_arg1_text =>
      'Неперероблені (або натуральні) продукти харчування — це **їстівні частини рослин** (насіння, плоди, листя, стебла, коріння) **або тварин** (м\'язові тканини, субпродукти, яйця, молоко), а також гриби, водорості та вода після їх відокремлення від природи.';

  @override
  String get guide_nova_groups_arg2_title => 'Оброблені кулінарні інгредієнти';

  @override
  String get guide_nova_groups_arg2_text =>
      'Перероблені кулінарні інгредієнти, такі як **олії, масло, цукор і сіль**, є речовинами, отриманими з продуктів групи 1 або з природних джерел шляхом пресування, рафінування, подрібнення, помелу та сушіння.';

  @override
  String get guide_nova_groups_arg3_title => 'Напівфабрикати';

  @override
  String get guide_nova_groups_arg3_text =>
      'Перероблені харчові продукти, такі як консервовані овочі, рибні консерви, фрукти в сиропі, сир та свіжоспечений хліб, **переважно виготовляються шляхом додавання солі, олії, цукру або інших речовин з продуктів 2-ї до 1-ї групи**. Процеси включають різні методи консервування або приготування їжі, а у випадку хліба та сиру – безалкогольне бродіння. Більшість перероблених харчових продуктів містять два або три інгредієнти та є модифікованими версіями продуктів 1-ї групи. Їх можна вживати окремо або, що частіше, у поєднанні з іншими продуктами.';

  @override
  String get guide_nova_groups_arg4_title => 'Ультраоброблені продукти';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ультраоброблені харчові продукти, такі як безалкогольні напої, солодкі або солоні упаковані снеки, відновлені м\'ясні продукти та попередньо приготовані заморожені страви, **це не просто модифіковані харчові продукти, а рецептури, виготовлені переважно або повністю з речовин, отриманих з харчових продуктів та добавок**, з малою кількістю або взагалі без незмінних харчових продуктів Групи 1. Інгредієнти в цих рецептурах зазвичай включають ті, що також містяться в оброблених харчових продуктах, такі як цукри, олії, жири або сіль. Однак ультраоброблені продукти також містять інші джерела енергії та поживних речовин, які зазвичай не використовуються в кулінарних приготуваннях. Деякі з них безпосередньо видобуваються з харчових продуктів, такі як казеїн, лактоза, сироватка та глютен.';

  @override
  String get guide_nova_explanations_title => 'Проблеми з ультраобробкою';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Екстремальна обробка харчових інгредієнтів';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Багато з них **отримують шляхом подальшої переробки харчових компонентів**, таких як гідрогенізовані або переетерифіковані олії, гідролізовані білки, ізолят соєвого білка, мальтодекстрин, інвертний цукор та кукурудзяний сироп з високим вмістом фруктози.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Добавки, що виходять за рамки чистої безпеки харчових продуктів';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Добавки в надмірно оброблених продуктах харчування включають деякі, які також використовуються в оброблених продуктах харчування, такі як консерванти, антиоксиданти та стабілізатори. Класи добавок, які містяться тільки в надмірно оброблених продуктах, включають ті, що використовуються **для імітації або поліпшення сенсорних якостей продуктів харчування або для маскування неприємних смакових якостей кінцевого продукту**. До цих добавок належать барвники та інші кольорові речовини, стабілізатори кольору; ароматизатори, підсилювачі смаку, нецукрові підсолоджувачі; а також технологічні добавки, такі як карбонізуючі, зміцнювальні, наповнювальні та антинаповнювальні агенти, антипінні, антизлежувальні та глазурувальні агенти, емульгатори, секвестранти та зволожувачі.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Обробка, яку неможливо виконати вдома';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Використовується безліч послідовностей процесів** для поєднання, як правило, багатьох інгредієнтів і створення кінцевого продукту (звідси і назва «ультраоброблені»). Ці процеси включають кілька **процесів, які не мають аналогів у побуті**, таких як гідрогенізація та гідролізація, екструзія та формування, а також попередня обробка для смаження.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Хижацькі та фінансові аспекти ультраобробки';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Загальна мета ультраобробки полягає у створенні брендових**, **зручних** (довготривалих, готових до споживання), **привабливих** (надзвичайно смачних) та **високоприбуткових** (з дешевими інгредієнтами) харчових продуктів, призначених для витіснення всіх інших груп харчових продуктів. Ультраоброблені харчові продукти зазвичай мають привабливу упаковку та інтенсивно рекламуються.';

  @override
  String get guide_nova_explanations_arg5_title => 'Небезпека для здоров\'я';

  @override
  String get guide_nova_explanations_arg5_text =>
      'З 2018 року, завдяки NutriNet-Santé, було виявлено перші зв\'язки між **споживанням надмірно оброблених продуктів харчування та підвищеним ризиком розвитку раку, серцево-судинних захворювань і діабету**. На сьогоднішній день понад 90 досліджень у всьому світі підтверджують ці висновки.\nНайсильніші зв\'язки стосуються **ожиріння, серцево-судинної смертності та депресивних симптомів**. У дітей ефекти в першу чергу спостерігаються на вазі та ліпідному дисбалансі.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Країни рекомендують обмежити їх';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Деякі країни використовують групи NOVA для своїх дієтичних рекомендацій або цілей, наприклад:\n\n- **🇧🇷 Бразилія** у своїх дієтичних рекомендаціях **рекомендує обмежити споживання** перероблених продуктів і уникати ультраоброблених продуктів.\n\n- **🇫🇷 Франція** у своїх цілях щодо політики громадського здоров\'я в галузі харчування на 2018-2022 роки ставить за мету **зменшити споживання ультраоброблених продуктів групи 4 на 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-uk.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Вітаємо в Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Що таке Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts - це некомерційна, спільна, безкоштовна та відкрита база даних про харчові продукти з усього світу.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Ми вважаємо, що кожен повинен мати доступ до інформації про те, що він їсть. Збираючи дані про інгредієнти, алергени, харчову цінність та інше, **ми даємо споживачам можливість робити обґрунтований вибір** і сприяємо **підвищенню прозорості** в харчовій промисловості.';

  @override
  String get guide_open_food_facts_features_title => 'Функції Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Отримуйте сповіщення про небажані інгредієнти';

  @override
  String get guide_open_food_facts_tips_title =>
      'Поради щодо створення чудових фотографій';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Що не робити';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Уникати тіней та відблиску.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Без розмитого або нечіткого тексту.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Не обрізайте частини тексту.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Уникайте завантажених фонів.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Що робити';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Використовуйте гарне, рівномірне освітлення.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Переконайтеся, що текст чіткий та читабельний.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Захопіть весь список інгредієнтів.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Тримайте продукт на плоскій поверхні.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Допоможіть нам створити «Вікіпедію їжі»';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Оцінка за поживну якість';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Оцінка, щоб уникнути ультраоброблених продуктів';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Оцінка для планети';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-uk.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Вітаємо в Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Що таке Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts розширює нашу місію на наших пухнастих друзів! Це **база даних продуктів харчування для котів, собак та інших домашніх тварин**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Ми збираємо інформацію про **інгредієнти**, **харчову цінність** та рекомендації щодо годування, щоб допомогти власникам домашніх тварин вибрати найкращий корм для потреб своїх улюбленців.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Функції Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Отримуйте сповіщення про небажані інгредієнти';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Чи має ваш улюбленець алергію на якісь інгредієнти? Ви можете створити список косметичних інгредієнтів, яких слід уникати, прямо в додатку!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Поради щодо створення чудових фотографій';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Що не робити';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Уникати тіней та відблиску.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Без розмитого або нечіткого тексту.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Не обрізайте частини тексту.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Уникайте завантажених фонів.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Що робити';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Використовуйте гарне, рівномірне освітлення.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Переконайтеся, що текст чіткий та читабельний.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Захопіть весь список інгредієнтів.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Тримайте продукт на плоскій поверхні.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Примітка щодо підрахунку очок';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Розробка системи оцінювання кормів для домашніх тварин **наразі не є пріоритетом**. Методологія буде складною, оскільки потреби в поживних речовинах значно різняться залежно від виду, віку та стану здоров\'я тварин. Ми ще не знайшли незалежної наукової групи, здатної розробити таку систему оцінювання.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-uk.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Вітаємо в Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Що таке Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts - це спільна база даних **косметичної продукції**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Наша мета — розшифрувати списки інгредієнтів, щоб допомогти вам **зрозуміти, що міститься у ваших засобах особистої гігієни**. Від зволожуючих кремів до косметики — ми збираємо дані про інгредієнти, алергени та упаковку, щоб сприяти прозорості в косметичній галузі.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Функції Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Отримуйте сповіщення про небажані інгредієнти';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Ви маєте алергію на якісь інгредієнти? Хочете уникати комедогенних речовин? Хочете уникати суперечливих компонентів? Ви можете створити список косметичних інгредієнтів, яких слід уникати, прямо в додатку!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Поради щодо створення чудових фотографій';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Що не робити';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Уникати тіней та відблиску.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Без розмитого або нечіткого тексту.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Не обрізайте частини тексту.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Уникайте завантажених фонів.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Що робити';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Використовуйте гарне, рівномірне освітлення.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Переконайтеся, що текст чіткий та читабельний.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Захопіть весь список інгредієнтів.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Зробіть стільки фотографій, скільки потрібно, якщо пляшка вигнута.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Можливо, вам доведеться відклеїти етикетку, щоб побачити список інгредієнтів.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Тримайте продукт на плоскій поверхні.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Примітка щодо підрахунку очок';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'На відміну від харчових продуктів, у світі косметики **не існує загальновизнаної, підтриманої урядом системи оцінювання, подібної до Nutri-Score**. Вплив інгредієнтів може бути дуже індивідуальним і залежати від типу шкіри, алергій та особистих особливостей.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-uk.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Вітаємо в Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Що таке Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices — це проект, спрямований на **збір та обмін інформацією про ціни на товари по всьому світу**. Це загальнодоступний набір даних, який можна використовувати для досліджень, аналізу та інших цілей. Open Prices розроблений та підтримується Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Зараз мало компаній, які мають великі бази даних про ціни на продукцію на рівні штрих-коду. Цих цін нема у вільному доступі, а продаються вони за високу ціну приватним гравцям, дослідникам та іншим організаціям, які можуть їх собі дозволити.';

  @override
  String get guide_open_prices_how_title => 'Як Open Prices працюють?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Ми збираємо відкритий набір даних про ціни за допомогою краудсорсингу**. Користувачі можуть додавати ціни через цей веб-додаток або через офіційний мобільний додаток Open Food Facts. Роздрібні продавці або сторонні додатки також можуть брати участь у цьому процесі, використовуючи наш API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Збирайте фотографії цінників у торгових залах';

  @override
  String get guide_open_prices_how_arg2_title => 'Збирайте фотографії чеків';

  @override
  String get guide_open_prices_why_title => 'Чому Open Food Facts це робить?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Інформація про ціни має надзвичайно важливе значення для розуміння продовольчих систем. Це ключовий фактор для розуміння вартості продуктів харчування та сприяння здоровому харчуванню. Відкриття даних про ціни є способом полегшити дослідникам, журналістам та громадянам **краще розуміння того, як ціни на продукти харчування змінюються в залежності від географічного положення та часу**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Відстежуйте динаміку цін з часом';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Дивіться на **еволюцію цін**: шринкфляція, дефляція, ми можемо відстежувати їх разом!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Порівняйте ціни поруч із вами';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Коли ми дізнаємося більше про ціни, ви зможете знайти **найдешевші магазини навколо вас**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Ви розглядали можливість зібрати ціни з веб-сайтів роздрібних торговців?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'З юридичних та технічних причин **ми не вважаємо копіювання цін з веб-сайтів роздрібних продавців дійсним способом внеску в Open Prices**. Ми хочемо бути впевнені, що ціни, які ми збираємо, є точними та актуальними, а отримання скопійованих цін від учасників не дозволяє нам цього зробити.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Скрейпінг цін є варіантом, який розглядається в майбутній версії Open Prices, але це буде робити сама Open Prices, щоб ми могли отримати підтвердження ціни на основі HTML-сторінки.';

  @override
  String get guide_open_prices_retailers_title =>
      'Я роздрібний продавець і хочу вказати ціни. Як я можу це зробити?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Ви можете надавати ціни, використовуючи наш API.\nЯкщо ви хочете надавати ціни у великих обсягах, зв\'яжіться з нами за адресою prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Вітаємо в Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Що таке Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts — це величезна відкрита база даних про **будь-які товари зі штрих-кодом, за винятком продуктів харчування, косметики та кормів для домашніх тварин**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Від **електроніки** до **іграшок**, від **одягу** до **чистячих засобів** — якщо на товарі є штрих-код, його можна додати. Цей проект має на меті створити «Інтернет речей» для повсякденних предметів, зробивши інформацію про них загальнодоступною.';

  @override
  String get guide_open_products_facts_features_title =>
      'Функції Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts має на меті допомогти споживачам **продовжити термін експлуатації предметів**, пропонуючи циркулярні рішення для їхнього обслуговування, **ремонту**, **переробки** або передачі новому власнику.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Вуглецевий слід деяких продуктів';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Вплив CO2** від французького агентства з охорони навколишнього середовища ADEME надає інформацію про **вплив вуглецю** для багатьох категорій, тому переконайтеся, що ви точно класифікували продукти.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Індекс ремонтопридатності для багатьох виробів';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Коли французький індекс ремонтопридатності буде доступний, ми його відобразимо. Більше того, **ви можете почати збирати змінні за допомогою Folksonomy Engine**, щоб ми могли перерахувати його самостійно в майбутньому, навіть у країнах, де він недоступний.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Знайдіть способи пожертвувати/перепродати свій продукт';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Ми надаємо посилання на **послуги третіх сторін, що сприяють циркулярній економіці**, які допоможуть вам знайти продукт, який ви шукаєте, у вигляді вживаного товару, щоб бути більш дбайливими до ресурсів планети.\nЗверніть увагу, що ми не отримуємо за це винагороду, і що система працює лише як приклад для двох веб-сайтів у Франції. Ви можете допомогти розширити цю систему, додавши інформацію про інші сайти на вікі.';

  @override
  String get guide_open_products_facts_information_title =>
      'Яка інформація корисна?';

  @override
  String get guide_open_products_facts_information_text =>
      'Для такого широкого спектру товарів **дані, які ми збираємо, є гнучкими**. Для цього **ми створили Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine — це інструмент, який допомагає доповнювати продукти відповідними властивостями. Це сприяє поліпшенню пошуку та виявлення, а також обчисленню та відображенню цікавих речей у майбутньому.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Ви можете додати будь-які ключі та значення, наприклад: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Ви отримаєте автопідказки щодо можливих властивостей, а також можете додавати та документувати нові властивості для своїх улюблених видів продуктів.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-uk.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food налаштування';

  @override
  String get guide_coming_soon_button_title => 'Незабаром!';

  @override
  String get guide_learn_more_subtitle => 'Торкніться, щоб дізнатися більше';

  @override
  String get preview_badge => 'Попередній перегляд';

  @override
  String get prices_feedback_form =>
      'Натисніть тут, щоб надіслати нам свій відгук про цю нову функцію!';

  @override
  String get menu_button_list_actions => 'Виберіть дію';

  @override
  String get error_loading_photo => 'Помилка завантаження фото';

  @override
  String get photo_viewer_action_use_picture_as => 'Використовувати як…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Використовуйте це зображення як…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Використовуйте це зображення як… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Подробиці';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Подробиці цього фото';

  @override
  String get photo_viewer_details_title => 'Подробиці цього фото';

  @override
  String get photo_viewer_details_contributor_title => 'Учасник';

  @override
  String get photo_viewer_details_size_title => 'Розміром';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height пікселів';
  }

  @override
  String get photo_viewer_details_date_title => 'Дата';

  @override
  String get photo_viewer_details_url_title => 'URL-адреса';

  @override
  String get product_page_compatibility_score => 'Сумісний';

  @override
  String get user_lists_action_multi_select => 'Мультивиділення';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Ваша оцінка сумісності: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Фронтальне фото';

  @override
  String get product_image_ingredients_accessibility_label => 'Фото складників';

  @override
  String get product_image_nutrition_accessibility_label => 'Харчова картина';

  @override
  String get product_image_packaging_accessibility_label => 'Картинка упаковки';

  @override
  String get product_image_other_accessibility_label => 'Інші зображення';

  @override
  String get product_image_outdated_message =>
      'Це зображення може бути застарілим';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (це зображення може бути застарілим)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (це зображення може бути заблоковано виробником)';
  }

  @override
  String get product_image_error => 'Не вдалося завантажити зображення!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Не вдалося завантажити $type (помилка мережі?)';
  }

  @override
  String get product_page_image_no_image_available => 'Немає\nзображення!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Для цього товару немає зображення';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Змінити порядок або приховати дії';

  @override
  String get product_page_action_bar_setting_modal_title => 'Редагувати дії';

  @override
  String get product_page_action_bar_item_move_up => 'Перемістити вгору';

  @override
  String get product_page_action_bar_item_move_down => 'Перемістити вниз';

  @override
  String get product_page_action_bar_item_enable => 'Увімкнути дію';

  @override
  String get product_page_action_bar_item_disable => 'Вимкнути дію';

  @override
  String get product_page_pending_operations_banner_title =>
      'Завантаження ваших змін…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Дані, відображені на цій сторінці, **ще не відображають ваших змін**.\nЗачекайте кілька секунд…';

  @override
  String get product_add_a_language => 'Додати мову';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Штрих-код: $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Видалити цей товар з каруселі';

  @override
  String get carousel_unsupported_header => 'Штрих-код не підтримується!';

  @override
  String get carousel_unsupported_title => 'Йой, халепа!';

  @override
  String get carousel_unsupported_text =>
      'Відсканований штрих-код не підтримується Open Food Facts!';

  @override
  String get carousel_error_header => 'Помилка!';

  @override
  String get carousel_error_title => 'Це облом!';

  @override
  String get carousel_error_text_1 =>
      'Нам не вдалося завантажити інформацію про цей штрих-код:';

  @override
  String get carousel_error_text_2 =>
      'Перевірте підключення до Інтернету або натисніть цю кнопку:';

  @override
  String get carousel_error_button => 'Повторити спробу';

  @override
  String get carousel_unknown_product_header => 'Невідомий продукт';

  @override
  String get carousel_unknown_product_title =>
      'Щиро вітаю!\nВи знайшли __рідкісний камінь!__';

  @override
  String get carousel_unknown_product_text =>
      'Наша спільна база даних містить понад **3 млн продуктів**, але цей штрих-код не існує: ';

  @override
  String get carousel_unknown_product_button => 'Додати цей продукт';

  @override
  String get carousel_loading_header => 'Завантаження інформації...';

  @override
  String get carousel_loading_title =>
      'Ви щойно відсканували продукт із таким штрих-кодом:';

  @override
  String get carousel_loading_text =>
      'Ми шукаємо його в нашій базі даних із понад **3 мільйонів продуктів!**';

  @override
  String get product_type_subtitle_food =>
      'Овочі, фрукти, заморожені продукти…';

  @override
  String get product_type_subtitle_beauty => 'Макіяж, мило, зубні пасти…';

  @override
  String get product_type_subtitle_pet_food => 'Корм для собак, котів…';

  @override
  String get product_type_subtitle_product => 'Смартфони, меблі…';

  @override
  String get photo_field_front => 'Фото товару';

  @override
  String get photo_field_ingredients => 'Фото інгредієнтів';

  @override
  String get photo_field_nutrition => 'Фото харчування';

  @override
  String get photo_field_packaging => 'Фото з інформацією про упакування';

  @override
  String get photo_already_exists => 'Це фото вже існує';

  @override
  String get photo_missing => 'Немає цього фото';

  @override
  String get date => 'Дата';

  @override
  String get photo_rotate_left => 'Оберніть ліворуч';

  @override
  String get photo_rotate_right => 'Оберніть праворуч';

  @override
  String get photo_undo_action => 'Скасувати попередню дію';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Карта світу $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Учасники OpenStreetMap';

  @override
  String get not_applicable_short => 'Н/Д';

  @override
  String get knowledge_panel_warning_text => 'Увага';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Чому цей Nutri-Score відрізняється від того, що на упаковці?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Є два можливі пояснення:\nСписок інгредієнтів та/або харчова цінність не є актуальною.\n\nМи пропонуємо «Новий розрахунок» Nutri-Score (або V2). Переконайтеся, що у вас на упаковці є банер «Новий розрахунок».';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Перевірка інгредієнтів';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Перевірка фактів харчування';

  @override
  String url_not_supported(String url) {
    return 'На жаль, ми не можемо відкрити URL:\n$url';
  }

  @override
  String get product_list_export => 'Експортувати';

  @override
  String get product_list_import => 'Імпортувати';

  @override
  String get product_footer_action_barcode => 'Переглянути штрих-код';

  @override
  String get product_footer_action_barcode_short => 'Код товару';

  @override
  String get product_footer_action_open_website => 'Відкрити сайт';

  @override
  String get product_footer_action_report => 'Скарга';

  @override
  String get product_footer_action_contributor_guide => 'Допомога';

  @override
  String get product_footer_action_data_quality_tags => 'Якість даних';

  @override
  String get product_page_tab_for_me => 'Для мене';

  @override
  String get product_page_tab_website => 'Сайт';

  @override
  String get product_page_tab_prices => 'Ціни';

  @override
  String get prices_explanation_card_title => 'Чому ціни?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** – це проєкт для збору та поширення інформації про ціни на товари з усього світу 🌍. Open Prices розроблено та підтримується Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Докладніше';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title => 'Які атрибути фолксономії?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Атрибути базуються на парі **ключ-значення**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Ці властивості створюються та зберігаються учасниками для будь-якого використання.';

  @override
  String get folksonomy_action_external_link_title =>
      'Відкрити зовнішнє посилання';

  @override
  String get folksonomy_action_external_link_warning =>
      'Зовнішні посилання можуть бути небезпечними. Ви справді хочете це відвідати?';

  @override
  String get prices_products_empty_title => 'Ціна недоступна';

  @override
  String get prices_products_empty_explanation =>
      'Будьте першим, хто зробить свій внесок!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Топ $pageSize продуктів (всього: $total)';
  }

  @override
  String get app_review_title => 'Вам подобається цей додаток?';

  @override
  String get app_review_low => 'Могло бути й краще';

  @override
  String get app_review_medium => 'Непогано';

  @override
  String get app_review_high => 'Обожнюю!';

  @override
  String get app_review_feedback_modal_title =>
      'Допоможіть нам покращити наш додаток';

  @override
  String get app_review_feedback_modal_content =>
      'Якщо у вас є кілька хвилин, ви можете відповісти на цю форму, щоб **ми могли покращити майбутні оновлення**:';

  @override
  String get app_review_feedback_modal_open_form => 'Відповісти на форму';

  @override
  String get app_review_feedback_modal_later => 'Запитайте мене пізніше';

  @override
  String get nutrition_facts_extract_new =>
      'НОВИНКА: Ви можете автоматично витягувати поживні речовини із зображення!';

  @override
  String get nutrition_facts_extract_button_text => 'Видобути зараз';

  @override
  String get nutrition_facts_extract_in_progress => 'Триває видобування…';

  @override
  String get nutrition_facts_extract_successful => 'Видобування успішне';

  @override
  String get nutrition_facts_extract_failed =>
      'Не вдалося отримати поживні речовини із зображення';

  @override
  String get prices_discount => 'Знижка';

  @override
  String get prices_stats_statistics => 'Статистика';

  @override
  String get prices_stats_title => 'Статистика цін';

  @override
  String get prices_stats_prices_section => 'Ціни';

  @override
  String get prices_stats_products_section => 'Товари';

  @override
  String get prices_stats_locations_section => 'Місцезнаходження';

  @override
  String get prices_stats_proofs_section => 'Докази';

  @override
  String get prices_stats_contributors_section => 'Співучасники';

  @override
  String get prices_stats_experiments_section => 'Експерименти';

  @override
  String get prices_stats_misc_section => 'Різне';

  @override
  String get prices_stats_total => 'Усього';

  @override
  String get prices_stats_with_barcode => 'Зі штрих-кодом';

  @override
  String get prices_stats_with_category => 'З категорією';

  @override
  String get prices_stats_with_discount => 'Зі знижкою';

  @override
  String get prices_stats_community => 'Спільнота';

  @override
  String get prices_stats_consumption => 'Споживання';

  @override
  String get prices_stats_with_price => 'З ціною';

  @override
  String get prices_stats_food => 'Їжа';

  @override
  String get prices_stats_beauty => 'Краса';

  @override
  String get prices_stats_products => 'Товари';

  @override
  String get prices_stats_pet_food => 'Корм для домашніх тварин';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Онлайн';

  @override
  String get prices_stats_countries => 'Країн';

  @override
  String get prices_stats_price_tag => 'Цінник';

  @override
  String get prices_stats_receipt => 'Квитанція';

  @override
  String get prices_stats_gdpr_request => 'Запит GDPR';

  @override
  String get prices_stats_shop_import => 'Імпорт магазину';

  @override
  String get prices_stats_challenges => 'Випробування';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Ціни, пов\'язані з тегом ціни';

  @override
  String get prices_stats_currencies => 'Валюти';

  @override
  String get prices_stats_years => 'Роки';

  @override
  String get prices_stats_by_source_title => 'Ціни та докази за джерелом';

  @override
  String get prices_stats_website => 'Сайт';

  @override
  String get prices_stats_mobile_app => 'Мобільний додаток';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Інше';

  @override
  String get prices_stats_last_updated => 'Останнє оновлення';

  @override
  String get prices_stats_error =>
      'Сталася помилка під час завантаження статистики.';

  @override
  String get product_edit_robotoff_question_answered =>
      'На запитання відповіли!';

  @override
  String get product_edit_robotoff_proof => 'Доказ';

  @override
  String get preferences_card_general => 'Загальні';

  @override
  String get preferences_prices_title => 'Ціни';

  @override
  String get preferences_prices_subtitle =>
      'Керуйте своїми ціновими налаштуваннями';

  @override
  String get preferences_card_project => 'Проєкт «Факти про відкриту їжу»';

  @override
  String get preferences_contribute_title => 'Долучитись';

  @override
  String get preferences_my_contributions_title => 'Мої внески';

  @override
  String get preferences_my_stats_title => 'Моя статистика';

  @override
  String get preferences_contribute_subtitle =>
      'Перекладайте, покращуйте наші інструменти…';

  @override
  String get preferences_connect_title => 'Підключитися';

  @override
  String get preferences_connect_subtitle =>
      'Звертайтеся до нас або слідкуйте за нами в соціальних мережах';

  @override
  String get preferences_support_title => 'Зробіть пожертву';

  @override
  String get preferences_support_subtitle =>
      'Допоможіть нам інформувати мільйони споживачів у всьому світі';

  @override
  String get preferences_card_help => 'Довідка та підтримка';

  @override
  String get preferences_faq_title => 'ЧаПИ';

  @override
  String get preferences_faq_subtitle =>
      'Отримайте відповіді на свої запитання';

  @override
  String get logged_out => 'Вийшов з системи';

  @override
  String get preferences_app_bar_message =>
      'Дякуємо, що ви є одним із наших учасників!';

  @override
  String get preferences_app_bar_products_modified => 'Змінені товари';

  @override
  String get preferences_app_bar_prices_added => 'Ціни додано';

  @override
  String get preferences_app_bar_see_all_stats => 'Переглянути всю статистику';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Пошук $provider за запитом \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Пошук налаштування (наприклад, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Доступність: Показати емодзі';

  @override
  String get preferences_accessibility_remove_colors =>
      'Доступність: Видалити кольори';

  @override
  String get preferences_app_settings_products => 'Товари';

  @override
  String get preferences_card_about => 'Про додаток';

  @override
  String get preferences_legal_information_title => 'Правова інформація';

  @override
  String get preferences_legal_information_subtitle =>
      'Умови використання, політика конфіденційності та інше';

  @override
  String get preferences_terms_of_use => 'Умови використання';

  @override
  String get preferences_legal_mentions => 'Юридичні згадки';

  @override
  String get preferences_legal_header =>
      'Open Food Facts – це база даних про харчові продукти, **створена всіма для всіх**.\nВи можете використовувати її, щоб робити кращий вибір продуктів харчування, а оскільки це **відкриті дані**, кожен може **повторно використовувати їх для будь-яких цілей**.';

  @override
  String get preferences_privacy_policy => 'Політика конфіденційности';

  @override
  String get preferences_licenses => 'Ліцензії';

  @override
  String get preferences_about_app_title => 'Про додаток';

  @override
  String get preferences_about_app_subtitle =>
      'Технічна інформація, інформація для розробників та інше';

  @override
  String get preferences_card_information => 'Інформація';

  @override
  String get preferences_version_number_title => 'Номер версії';

  @override
  String get preferences_scanner_title => 'Сканер';

  @override
  String get preferences_app_store => 'Магазин додатків';

  @override
  String get preferences_app_system_settings => 'Системні налаштування';

  @override
  String get preferences_source_code => 'Доступ до вихідного коду';

  @override
  String get preferences_source_code_subtitle =>
      'І почніть впливати на мільйони';

  @override
  String get preferences_add_prices => 'Додати ціни';

  @override
  String get preferences_complete_products =>
      'Доповнюйте інформацію про продукти';

  @override
  String get preferences_tips => 'Поради';

  @override
  String get tips_discover_nutriscore => 'Відкрийте для себе новий Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'На веб-сайті Open Food Facts';

  @override
  String get preferences_manage_account_title =>
      'Керувати моїм обліковим записом';

  @override
  String get preferences_manage_account_tooltip =>
      'Керуйте своїм обліковим записом';

  @override
  String get preferences_change_password_title => 'Змінити мій пароль';

  @override
  String get preferences_danger_zone => 'НЕБЕЗПЕЧНА ЗОНА';

  @override
  String get preferences_account_deletion_subtitle =>
      'Усі ваші внески будуть втрачені';

  @override
  String get preferences_contributions_title => 'Внески';

  @override
  String get preferences_dev_mode_app_settings_title => 'Налаштування програми';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Дуже експериментальний спосіб сканування продуктів офлайн';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Оновити всі продукти з сервера';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Будь ласка, уникайте цього, якщо це не є абсолютно необхідним';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Демо-режим';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Додавання карток до сканера';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Додає 3 зразки продуктів до сканера';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Ведучий фолксономії';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Ведучий: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Експерименти з доступністю';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Вибір кількох товарів за цінами';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Користувачі впорядкували панелі знань';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Тимчасовий доступ до пошуку місцезнаходження';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Порівняння 2 або 3 продуктів';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Імпорт списку товарів';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Оцінки та методології';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Дізнайтеся, як розраховується Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Дізнайтеся про основні зміни в методології';

  @override
  String get preferences_faq_discover_project_title =>
      'Відкрийте для себе проєкт';

  @override
  String get preferences_faq_discover_off_title =>
      'Відкрийте для себе факти про відкриту їжу';

  @override
  String get preferences_faq_discover_obf_title =>
      'Відкрийте для себе Open Beauty Facts.';

  @override
  String get preferences_faq_discover_opff_title =>
      'Відкрийте для себе Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title =>
      'Відкрийте для себе Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Відкрийте для себе Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'FAQ - Часті запитання';

  @override
  String get preferences_faq_off_ngo_title =>
      'Громадська організація «Факти про відкриту їжу»';

  @override
  String get preferences_about_information_title => 'Інформація';

  @override
  String get preferences_connect_community_updates_title =>
      'Отримуйте оновлення спільноти';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Будьте в курсі новин застосунку та спільноти';

  @override
  String get preferences_connect_community_calendar_title =>
      'Підпишіться на календар нашої спільноти';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Долучайтеся, відвідавши один із наших віртуальних заходів';

  @override
  String get preferences_connect_blog_title => 'Блог «Факти про відкриту їжу»';

  @override
  String get preferences_connect_blog_subtitle =>
      'Отримуйте останні новини, як тільки вони трапляються';

  @override
  String get preferences_connect_community_help_title =>
      'Отримайте допомогу від громади';

  @override
  String get preferences_connect_improve_app_title =>
      'Допоможіть нам покращити додаток';

  @override
  String get preferences_connect_debug_info_title =>
      'Надішліть нам інформацію для налагодження';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Надішліть нам електронного листа з детальною інформацією про налагодження';

  @override
  String get preferences_connect_feedback_title =>
      'Надішліть нам відгук про додаток';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Допоможіть сформувати майбутнє додатка';

  @override
  String get preferences_connect_survey_title =>
      'Пройдіть опитування щодо програми';

  @override
  String get preferences_connect_survey_subtitle =>
      'Допоможіть нам зрозуміти, що нам слід будувати далі';

  @override
  String get preferences_connect_professionals_title => 'Професіонали';

  @override
  String get preferences_connect_pro_subtitle =>
      'Абсолютно безкоштовно, забезпечує точні дані для 500 програм та мільйонів споживачів. Самообслуговування, сумісне з вашим PIM або електронними таблицями (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Зв\'яжіться з нами, щоб розпочати';

  @override
  String get preferences_connect_press_title => 'Преса';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Отримайте всі необхідні матеріали для вашого звіту';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Звертайтеся до нас з питань преси або щоб повідомити про ваш звіт';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Станьте активним волонтером';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Розробка, комунікація, дизайн… будь-який вид волонтерства чи експертизи вітається!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Відкрийте для себе деякі з багатьох способів, як ви можете зробити свій внесок';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Розробка мобільних додатків';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Дізнайтеся, як зробити внесок у розробку програмного забезпечення';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Щоденні нестабільні збірки, абсолютно нові функції';

  @override
  String get preferences_contribute_local_community_title =>
      'Розвивайте свою місцеву громаду';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Допомога з програмним забезпеченням, контентом, перекладом аналізу інгредієнтів';

  @override
  String get preferences_contribute_share_subtitle =>
      'Ми підготували невеликий шаблон, щоб допомогти вам :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Прості кроки для підвищення прозорості харчових продуктів у вашій країні';

  @override
  String get preferences_contribute_data_quality_title => 'Якість даних';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Приєднуйтесь до команди з якості даних';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Приєднуйтесь до наших зусиль, щоб забезпечити повноту та точність бази даних';

  @override
  String get preferences_contributions_products_added_title =>
      'Додані продукти';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Нові продукти, які я додав до Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Продукти, які мені потрібно виконати';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Усі некомплектні продукти';

  @override
  String get preferences_my_contributions_prices_title => 'Ціни';

  @override
  String get preferences_my_contributions_my_prices_title => 'Мої ціни';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Мої ціни, мої докази…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Продукти, які ви можете допомогти завершити';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Допоможіть розрахувати Nutri-Score та Green-Score у вашій країні';

  @override
  String get preferences_prices_user_prices_subtitle => 'Ціни, які я надав';

  @override
  String get preferences_prices_proofs_subtitle => 'Цінники та квитанції';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Сфотографуйте свої чеки та відскануйте відповідні штрих-коди';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Фотографуйте ціни в магазині';

  @override
  String get preferences_prices_newest_title => 'Найновіші ціни';

  @override
  String get preferences_prices_newest_subtitle =>
      'Останні ціни, додані спільнотою Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Автори з найбільшою кількістю цін';

  @override
  String get preferences_prices_metrics_title => 'Метрики ціни відкриття';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Слідкуйте за розвитком проекту';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Способи зробити внесок';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Підтверджуйте ціни, додані вами або іншими, за допомогою штучного інтелекту';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Швидко додавайте багато чеків або фотографій полиць зі своєї фотоплівки';

  @override
  String get preferences_prices_challenges_title => 'Щомісячні виклики';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Беріть участь у щомісячних тематичних квестах, щоб збирати призи';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Поверніть свої дані лояльності';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Дізнайтеся, як запросити свої дані';

  @override
  String get preferences_page_customize_app_title => 'Налаштуйте програму';

  @override
  String get preferences_page_contribute_project_title =>
      'Зробіть свій внесок у проєкт';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Прості способи допомогти. Open Food Facts.';

  @override
  String get preferences_page_faq_subtitle =>
      'Методології оцінювання, допомога та багато іншого про проєкт';

  @override
  String get product_edit_robotoff_positive_button => 'Прийняти пропозицію';

  @override
  String get product_edit_robotoff_negative_button => 'Відхилити пропозицію';

  @override
  String get product_edit_robotoff_show_proof => 'Показати доказ';

  @override
  String get product_edit_robotoff_expand_proof => 'Розгорнути доказ';

  @override
  String get product_page_tab_raw_data => 'Необроблені дані';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Сторінка $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Сторінка $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count від $total елементів';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count від $total елементів';
  }

  @override
  String item_count(int count) {
    return '$count елементів';
  }

  @override
  String item_count_string(String count) {
    return '$count елементів';
  }

  @override
  String get prices_no_result => 'Статистика цін не знайдена.';

  @override
  String get prices_error_loading_more_items =>
      'Помилка завантаження додаткових елементів';

  @override
  String get prices_proof_error =>
      'Не вдалося пройти автентифікацію, неможливо отримати докази';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count з $total доказів';
  }

  @override
  String proof_count(int count) {
    return '$count доказів';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count з $total учасників';
  }

  @override
  String contributors_count(int count) {
    return '$count учасників';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count з $total локацій';
  }

  @override
  String prices_locations_count(int count) {
    return '$count локацій';
  }

  @override
  String get restart_to_apply_message =>
      'Будь ласка, перезапустіть програму, щоб застосувати зміни.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Графічний інтерфейс';

  @override
  String get preferences_app_settings_media_title => 'Медіа';

  @override
  String get preferences_about_app_development_title => 'Розроблення';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Відкриті лабораторії фактів про їжу';

  @override
  String get preferences_root_account_title => 'Обліковий запис';

  @override
  String get preferences_contribute_translate_header =>
      'Перенесіть Open Food Facts на свою мову';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Зареєструйтесь в альфа-версії програми';

  @override
  String get preferences_dev_mode_section_data => 'Внески та дані про продукт';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Не показувати фолксономію';

  @override
  String get preferences_account_title => 'Обліковий запис';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Додано $created';
  }

  @override
  String get location_map_details_title => 'Деталі місцезнаходження';

  @override
  String get location_map_details_name => 'Ім’я';

  @override
  String get location_map_details_street => 'Вулиця';

  @override
  String get location_map_details_city => 'Місто';

  @override
  String get location_map_details_postcode => 'Поштовий індекс';

  @override
  String get location_map_details_country => 'Країна';

  @override
  String get location_map_details_coordinates => 'Координати';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
